/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
    'jquery',
    'mage/template',
    'mage/translate',
    "mage/calendar",
    'prototype'
], function (jQuery, mageTemplate, $t) {
    'use strict';

    if (typeof AppointmentBookingProduct == 'undefined') {
        window.AppointmentBookingProduct = {};
    }

    AppointmentBookingProduct.Config = Class.create();
    AppointmentBookingProduct.Config.prototype = {
        /**
         * Initialize function.
         *
         * @param {Object} options
         */
        initialize: function (options) {
            var options = JSON.parse(jQuery('#product_composite_configure_form_fields #wk-appointment-opt-json-data').attr('data-option'));
            var optionsData = JSON.parse(options.optionsJson)
            jQuery.each(optionsData, function (k, v) {
                if (v.title == 'Booking Date') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Booking Slot') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
            });
            if (jQuery('#product_composite_configure_form_fields .wk-apnt-booked-slot-summary').is(':empty')) {
                this.options = options;
                this.initializeSlotData(this);
                jQuery("body").find("#product_composite_configure_form_fields .wk-apnt-booked-slot-summary").html('<span></span>');
            }
        },

        initializeSlotData: function (self) {
            var todaySlotArr = self.options.todaySlotArr;
            var options = JSON.parse(self.options.optionsJson);
            var unvailableDates = self.options.appointmentUnavailableDates;
            var holidaysData = self.options.holidaysData;
            jQuery("#product_composite_configure_form_fields #wk-apnt-bk-select-date").datepicker({
                'dateFormat':'mm/dd/yy',
                'minDate': 'today',
                'maxDate': self.options.bookingAvailableTo,
                'beforeShowDay': function (date) {
                    var string = jQuery.datepicker.formatDate('dd M, yy', date);
                    var isDisabled = (jQuery.inArray(string, unvailableDates) != -1);
                    if(isDisabled){
                        return [!isDisabled];
                    }
                    string = jQuery.datepicker.formatDate('yy-mm-dd', date);
                    let holiday = holidaysData[string];
                    if(holiday){
                        return [false,'',holiday];
                    }
                    return [true];
                },
            });
            todaySlotArr.now = parseInt(Date.now()/1000);
            todaySlotArr.activeFirst = 0;

            var tmpl = self.templateTodayGenerate(todaySlotArr);

            jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-select-time-opt-wrapper').html(tmpl);
            var selectedTime = jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-slot-selected').text();
            jQuery('#product_composite_configure_form_fields #wk-abk-booking-time-field').val(selectedTime);
            jQuery('#product_composite_configure_form_fields #wk-abk-booking-time-field').next('.wk-bk-select-time-label').text(selectedTime);
            self._setProductOptions(jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-slot-selected'), options);

            jQuery("body").on('change', '#product_composite_configure_form_fields #wk-apnt-bk-select-date', function () {
                var dataOption = JSON.parse(jQuery('#product_composite_configure_form_fields #wk-appointment-opt-json-data').attr('data-option'));
                var monthArr = dataOption.monthArr;
                var todaySlotArr = dataOption.todaySlotArr;
                var availableSlotArr = dataOption.availableSlotArr;
                var options = JSON.parse(dataOption.optionsJson);

                var selectedDate  = jQuery(this).val();

                var parsedDate = Date.parse(selectedDate, "yyyy-MM-dd");
                var str = parsedDate.toString();
                parsedDate = str.substr(0, str.length-3);

                var selectedDateArr  = selectedDate.split('/');
                var day = selectedDateArr[1];
                var month = selectedDateArr[0];
                var year = selectedDateArr[2];
                var formatedDate = day+" "+monthArr[month]+", "+year;
                let optionDate = year+"-"+month+"-"+day;
                var d = new Date(selectedDate);
                var dayIndex = d.getDay();
                if (dayIndex == 0) {
                    dayIndex = 7;
                }

                var todayDate = new Date();
                var tday = todayDate.getDate();
                var tmonth = todayDate.getMonth() + 1;
                var tyear = todayDate.getFullYear();
                let holidayDateFormat = jQuery.datepicker.formatDate('yy-mm-dd', d);
                var isHoliday = holidaysData[holidayDateFormat];
                if(isHoliday){
                    tmpl = null;
                } else if (day == tday && month == tmonth && year == tyear) {
                    // if from selected date is today
                    var tmpl = self.templateTodayGenerate(todaySlotArr);
                } else {
                    var data = {};
                    var tmpl = self.templateGenerateByDay(availableSlotArr, data, dayIndex);
                }
                jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-select-time-opt-wrapper').html(tmpl);

                if (parsedDate in dataOption.bookedData) {
                    jQuery.each(dataOption.bookedData[parsedDate], function (key, value) {
                        if (jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-select-time-opt-wrapper').find(".wk-bk-select-time-opt[data-type-time='"+key+"']").length) {
                            var optTimeHtml = jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-select-time-opt-wrapper').find(".wk-bk-select-time-opt[data-type-time='"+key+"']");
                            var remainingQty = optTimeHtml.data("slot-qty") - value;
                            if (remainingQty <= 0) {
                                optTimeHtml.removeClass('wk-bk-slot-booked');
                                optTimeHtml.addClass('wk-bk-slot-booked');
                            }
                        }
                    });
                }

                jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-select-time-opt-wrapper').removeAttr('style');
                var selectedTime = jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-slot-selected').text();
                var isTimeClosed = false;
                jQuery('#product_composite_configure_form_fields #wk-abk-booking-time-field').val(selectedTime);
                jQuery('#product_composite_configure_form_fields #wk-abk-slot-day-index').val(jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-slot-selected').attr('data-day-index'));
                jQuery('#product_composite_configure_form_fields #wk-abk-parent-slot-id').val(jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-slot-selected').attr('data-index'));
                jQuery('#product_composite_configure_form_fields #wk-abk-slot-id').val(jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-slot-selected').attr('data-slot-index'));
                if (!tmpl) {
                    selectedTime = dataOption.titleClosed;
                    isTimeClosed = true;
                    jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-select-time-opt-wrapper').attr('style', 'display: none;');
                }
                jQuery(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text(selectedTime);
                if (!selectedTime) {
                    jQuery(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text($t('Closed'));
                }
                jQuery(this).parents('.wk-bk-dates-container').find('.wk-bk-select-date-label').text(formatedDate);
                jQuery(this).parents('.wk-bk-dates-container').find('.wk-bk-select-date-label').attr('data-booking-date', optionDate);
                var bookedDate = jQuery(this).parents('.wk-bk-dates-container').find('.wk-bk-select-date-label').text();
                jQuery.each(options, function (k, v) {
                    if (v.title == 'Booking Date') {
                        jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(optionDate);
                    }
                    if (v.title == 'Booking Slot') {
                        if (isTimeClosed) {
                            selectedTime = "";
                        }
                        jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(selectedTime);
                    }
                });
            });
            jQuery("body").on('click', '#product_composite_configure_form_fields .wk-appointmentbk-select-time-opt', function () {
                if (!jQuery(this).hasClass('wk-bk-slot-booked')) {
                    var dataOption = JSON.parse(jQuery('#product_composite_configure_form_fields #wk-appointment-opt-json-data').attr('data-option'));
                    var options = JSON.parse(dataOption.optionsJson);
    
                    self._setProductOptions(jQuery(this), options);
                    jQuery(this).addClass('wk-bk-slot-selected');
                }
                jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-select-time-label').trigger('click');
            });
            jQuery('#product_composite_configure_form_fields #wk-apnt-bk-select-date').trigger('change');
        },

        templateTodayGenerate: function (data) {
            var tempHtml = '';
            jQuery.each(data.slots, function (key, value) {
                jQuery.each(value, function (slotKey, slotValue) {
                    tempHtml = tempHtml + '<span class="wk-bk-select-time-opt wk-appointmentbk-select-time-opt ';
                    if ((slotValue.qty <= 0)
                        || (data.now >= slotValue.timestring)
                        || (data.bookedTimeSlot.length >0 & (slotValue.time).includes(data.bookedTimeSlot))) {
                        tempHtml = tempHtml + data.bookedClass;
                    }
                    if (key == data.index & slotKey == data.slotIndex & (data.now <= slotValue.timestring)) {
                        data.activeFirst = 1;
                        tempHtml = tempHtml + data.selectedClass;
                    }
                    if (data.now <= slotValue.timestring & data.activeFirst == 0) {
                        data.activeFirst = 1;
                        tempHtml = tempHtml + data.selectedClass;
                    }
                    tempHtml = tempHtml + '" data-type-time="'+slotValue.time+'"';
                    tempHtml = tempHtml + 'data-day-index="'+data.fromDayIndex+'"';
                    tempHtml = tempHtml + 'data-index="'+key+'"';
                    tempHtml = tempHtml + 'data-slot-index="'+slotKey+'"';
                    tempHtml = tempHtml + 'data-slot-qty="'+slotValue.qty+'">';
                    tempHtml = tempHtml + slotValue.time;
                    tempHtml = tempHtml + '</span>';
                });
            });
            return tempHtml;
        },

        templateGenerateByDay: function (availableSlotArr, data, dayIndex) {
            var tempHtml = '';
            if (availableSlotArr[dayIndex]) {
                var j = 0;
                jQuery.each(availableSlotArr[dayIndex], function (key, value) {
                    jQuery.each(value, function (slotKey, slotValue) {
                        tempHtml = tempHtml + '<span class="wk-bk-select-time-opt wk-appointmentbk-select-time-opt ';
                        if (slotValue.qty<=0) {
                            tempHtml = tempHtml + ' wk-bk-slot-booked';
                        }
                        if (slotValue.qty>0 & !j) {
                            console.log(slotValue.qty+"   "+j);
                            tempHtml = tempHtml + ' wk-bk-slot-selected';
                        }
                        tempHtml = tempHtml + '" data-type-time="'+slotValue.time+'"';
                        tempHtml = tempHtml + ' data-day-index="'+dayIndex+'"';
                        tempHtml = tempHtml + ' data-index="'+key+'"';
                        tempHtml = tempHtml + ' data-slot-index="'+slotKey+'"';
                        tempHtml = tempHtml + ' data-slot-qty="'+slotValue.qty+'">';
                        tempHtml = tempHtml + slotValue.time + '</span>';
                        j++;
                        if (slotValue.qty<=0) {
                            j--;
                        }
                    });
                });
            }
            return tempHtml;
        },

        _setProductOptions: function (element, options) {
            var thisObj = element;
            var selectedTime = thisObj.attr('data-type-time');
            jQuery("#product_composite_configure_form_fields .wk-appointmentbk-select-time-opt").each(function () {
                var currSelectedTime = jQuery(this).attr('data-type-time');
                if (jQuery(this).hasClass('wk-bk-slot-selected') & currSelectedTime!=selectedTime) {
                    jQuery(this).removeClass('wk-bk-slot-selected');
                }
            });
            thisObj.parents('.wk-bk-dates-right-container').find('.wk-bk-select-time-label').text(selectedTime);
            jQuery('#product_composite_configure_form_fields #wk-abk-booking-time-field').val(selectedTime);
            jQuery('#product_composite_configure_form_fields #wk-abk-slot-day-index').val(thisObj.attr('data-day-index'));
            jQuery('#product_composite_configure_form_fields #wk-abk-parent-slot-id').val(thisObj.attr('data-index'));
            jQuery('#product_composite_configure_form_fields #wk-abk-slot-id').val(thisObj.attr('data-slot-index'));
            var bookedDate = jQuery('#product_composite_configure_form_fields .wk-bk-appointment-container .wk-bk-select-date-label').attr('data-booking-date');
            jQuery.each(options, function (k, v) {
                if (v.title == 'Booking Date') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(bookedDate);
                }
                if (v.title == 'Booking Slot') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(selectedTime);
                }
            });
        }
    };
});
