/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
    'jquery',
    'mage/template',
    'mage/translate',
    'Magento_Ui/js/modal/alert',
    "jquery/ui",
    'prototype'
], function (jQuery, mageTemplate, $t, alert) {
    'use strict';

    if (typeof DefaultBookingProduct == 'undefined') {
        window.DefaultBookingProduct = {};
    }

    DefaultBookingProduct.Config = Class.create();
    DefaultBookingProduct.Config.prototype = {
        /**
         * Initialize function.
         *
         * @param {Object} options
         */
        initialize: function (options) {
            var options = JSON.parse(jQuery('#product_composite_configure_form_fields #wk-default-opt-json-data').attr('data-option'));
            jQuery.each(
                options.options,
                function (k, v) {
                    if (v.title == 'Booking From') {
                        jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                    }
                    if (v.title == 'Booking Till') {
                        jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                    }
                }
            );
            if (jQuery('#product_composite_configure_form_fields .booked-slot-summary').is(':empty')) {
                this.options = options;
                this.initializeSlotData(this);
                this.createSlotsData();
            }
            if (jQuery('#product_composite_configure_form_fields .wk-selected-radio-btn').length) {
                var selectedRadioBtn = jQuery('#product_composite_configure_form_fields .wk-selected-radio-btn').val();
                jQuery('#product_composite_configure_form_fields .'+selectedRadioBtn).find('input[type=radio]').prop('checked', true);
                jQuery('#product_composite_configure_form_fields .'+selectedRadioBtn).find('input[type=radio]').each(function() {
                    jQuery(this).prop('checked', true);
                });
            }
        },

        initializeSlotData: function (self) {
            jQuery(document).on(
                'click',
                '#product_composite_configure_form_fields .wk-available-day',
                function (event) {
                    if (jQuery(this).hasClass('slot-available')) {
                        var date = jQuery(this).attr("data-date");
                        jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');
                        jQuery(this).addClass('active');
                        self.loadSlotsData(date);
                    }
                }
            );
            jQuery(document).on(
                'click',
                '#product_composite_configure_form_fields .wk-next-cal',
                function (event) {
                    var currentCalendar = jQuery(this).parent().parent();
                    currentCalendar.hide();
                    currentCalendar.next().show();
                }
            );
            jQuery(document).on(
                'click',
                '#product_composite_configure_form_fields .wk-previous-cal',
                function (event) {
                    var currentCalendar = jQuery(this).parent().parent();
                    currentCalendar.hide();
                    currentCalendar.prev().show();
                }
            );

            jQuery(document).on(
                'click',
                '#product_composite_configure_form_fields .wk-slot-select-radio',
                function (event) {
                    var dataOption = JSON.parse(jQuery('#product_composite_configure_form_fields #wk-default-opt-json-data').attr('data-option'));
                    var slots = dataOption.slots;
                    jQuery(this).prop('checked', true);
                    var qtyBox = jQuery(this).parents('.wk-col').find('.wk-qty');
                    var regex = /^[0-9]*(?:\.\d{1,2})?$/; // allow only numbers [0-9]
                    var qty = qtyBox.val();
                    var id = qtyBox.attr("data-id");
                    var prevQty = jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val();
                    var fieldPrevQty = 0;
                    var info = slots[id];
                    var option = {};
                    var cond = true;
                    var updatedQty = qtyBox.next('.wk-qty-booked-hide').val();

                    if (qty == 0) {
                        cond = false;
                        alert({
                            content: $t('Please enter a value greater than 0')
                        });
                        jQuery(this).prop('checked', false);
                        self.removeSelectedSlot(qtyBox, id, dataOption);
                    } else if (!regex.test(qty) || qty == "") {
                        cond = false;
                        alert({
                            content: $t('Please enter a numeric value and is greater than 0')
                        });
                        jQuery(this).prop('checked', false);
                    } else if (cond && (parseInt(info['qty']) < qty || updatedQty >= parseInt(info['qty']))) {
                        cond = false;
                        alert({
                            content: $t('Quantity not available for this slot')
                        });
                        qtyBox.val(0);
                        jQuery(this).prop('checked', false);
                    }

                    if (cond && qty > 0) {
                        var fromOptionId, toOptionId;
                        jQuery.each(
                            dataOption.options,
                            function (k, v) {
                                if (v.title == 'Booking From') {
                                    option[v.id] = info['booking_from'];
                                    fromOptionId = v.id;
                                }
                                if (v.title == 'Booking Till') {
                                    option[v.id] = info['booking_to'];
                                    toOptionId = v.id;
                                }
                            }
                        );
                        qtyBox.prev('.wk-booked-txt').text($t("Selected"));
                        updatedQty = parseInt(qty);
                        fieldPrevQty = qtyBox.next('.wk-qty-booked-hide').val();
                        qtyBox.next('.wk-qty-booked-hide').val(updatedQty);

                        
                        var remainingQty = parseInt(info['qty']);
                        if (remainingQty >= parseInt(qty)) {
                            remainingQty -= parseInt(qty);
                            qtyBox.parent().siblings('.wk-col.middle').find('.wk-avl-text').next().text(remainingQty);
                        }
                        var bookingFrom = info['booking_from'];
                        var bookingTo = info['booking_to'];

                        if (jQuery('#product_composite_configure_form_fields .wk-modal-foot').find('.booked-short-history').length) {
                            if (jQuery('.wk-modal-foot').find(".booked-short-history[data-booked-slot-id=" + id + "]").length) {
                                jQuery('.wk-modal-foot').find(".booked-short-history[data-booked-slot-id=" + id + "]").html('');
                                jQuery('.wk-modal-foot').find(".booked-short-history[data-booked-slot-id=" + id + "]")
                                .append(
                                     jQuery('<input>').attr('type', 'hidden').attr('name', 'booked_qty').val(updatedQty),
                                     jQuery('<input>').attr('type', 'hidden').attr('name', 'slot_id').val(id),
                                     jQuery('<span>').text($t(updatedQty + " slot is selected for booking between " + bookingFrom + " to " + bookingTo))
                                )
                            } else {
                                jQuery('.booked-slot-summary').append(jQuery('<div>')
                                .attr('data-booked-slot-id', id)
                                .addClass('booked-short-history')
                                .append(
                                    jQuery('<input>').attr('type', 'hidden').attr('name', 'booked_qty').val(updatedQty),
                                    jQuery('<input>').attr('type', 'hidden').attr('name', 'slot_id').val(id),
                                    jQuery('<span>').text($t(updatedQty + " slot is selected for booking between " + bookingFrom + " to " + bookingTo))
                                ))
                            }
                         } else {
                             jQuery('#product_composite_configure_form_fields .wk-modal-foot').find('.booked-slot-summary')
                            .html(
                              jQuery('<div>')
                                 .attr('data-booked-slot-id', id)
                                 .addClass('booked-short-history')
                                 .append(
                                     jQuery('<input>').attr('type', 'hidden').attr('name', 'booked_qty').val(updatedQty),
                                     jQuery('<input>').attr('type', 'hidden').attr('name', 'slot_id').val(id),
                                     jQuery('<span>').text($t(updatedQty + " slot is selected for booking between " + bookingFrom + " to " + bookingTo))
                                 )
                            );
                         }
                        jQuery('#product_composite_configure_form_fields #options_'+fromOptionId+'_text').val(bookingFrom);
                        jQuery('#product_composite_configure_form_fields #options_'+toOptionId+'_text').val(bookingTo);
                        if (isNaN(prevQty) || prevQty == '') {
                            prevQty = 0;
                        }
                        if (fieldPrevQty != '' && parseInt(prevQty) >= parseInt(fieldPrevQty)) {
                            prevQty = prevQty - fieldPrevQty;
                        }
                        qty = parseInt(prevQty) + parseInt(qty);

                        jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val(qty);
                        jQuery('#product_composite_configure_form_fields #order-search').append(
                            jQuery('<input>').attr('type', 'hidden')
                                .addClass('wk-selected-radio-btn')
                                .val('wk-many-row-id'+id)
                        );
                        jQuery('#product_composite_configure_form_fields .wk-slots-summary-wrapper').show();
                    } else if (cond && qty == 0 && (event.keyCode == 8 || event.keyCode == 46)) {
                        self.removeSelectedSlot(qtyBox, id, dataOption);
                        jQuery(this).prop('checked', false);
                    }
                }
            );                
        },

        removeSelectedSlot: function (quantityBox, id, options) {
            var slots = options.slots;
            var info = slots[id];
            var bookingFrom = info['booking_from'];
            var bookingTo = info['booking_to'];
            if (jQuery("body").find("#product_composite_configure_form_fields .booked-slot-summary").find(".booked-short-history[data-booked-slot-id=" + id + "]")) {
                if (quantityBox.length) {
                    var bookedQty = jQuery("body")
                        .find(".booked-slot-summary")
                        .find(".booked-short-history[data-booked-slot-id=" + id + "]")
                        .children('input').val();
                    quantityBox.val(0);
                    quantityBox.siblings('.wk-booked-txt').text($t('your need'));
                    quantityBox.siblings('.wk-qty-booked-hide').val(0);
                    var availableQty = quantityBox.parent()
                        .siblings('.middle')
                        .find('.wk-label-avl-qty .wk-avl-text')
                        .next().text();
                    availableQty = parseInt(availableQty) + parseInt(bookedQty);
                    if (availableQty >= 0) {
                        var availableQty = quantityBox.parent()
                            .siblings('.middle')
                            .find('.wk-label-avl-qty .wk-avl-text')
                            .next().text(availableQty);
                    }
                }
                jQuery("body")
                    .find("#product_composite_configure_form_fields .booked-slot-summary")
                    .find(".booked-short-history[data-booked-slot-id=" + id + "]")
                    .remove();
                if (jQuery("body").find("#product_composite_configure_form_fields .booked-slot-summary").is(':empty')) {
                    jQuery("body").find('#product_composite_configure_form_fields .wk-slots-summary-wrapper').hide();
                }
            }
            
            var fromOptionId, toOptionId;
            jQuery.each(
                options.options,
                function (k, v) {
                    if (v.title == 'Booking From') {
                        fromOptionId = v.id;
                    }
                    if (v.title == 'Booking Till') {
                        toOptionId = v.id;
                    }
                }
            );
            if (jQuery('#product_composite_configure_form_fields .wk-modal-foot').find('.booked-short-history').length) {
                var allSelectedQty = jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val();
                var selFrom = jQuery('#product_composite_configure_form_fields #options_'+fromOptionId+'_text').val();
                var selTo = jQuery('#product_composite_configure_form_fields #options_'+toOptionId+'_text').val();
                var slotId = jQuery('#product_composite_configure_form_fields .wk-modal-foot')
                                .find(".booked-short-history[data-booked-slot-id!=" + id + "]").first().attr('data-booked-slot-id');
                var slotInfo = slots[slotId];
                var newFrom = slotInfo['booking_from'];
                var newTo = slotInfo['booking_to'];       
                allSelectedQty = parseInt(allSelectedQty) - parseInt(bookedQty);
                jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val(allSelectedQty);
                if (bookingFrom == selFrom) {
                    jQuery('#product_composite_configure_form_fields #options_'+fromOptionId+'_text').val(newFrom);
                }
                if (bookingTo == selTo) {
                    jQuery('#product_composite_configure_form_fields #options_'+toOptionId+'_text').val(newTo);
                }
            } else {
                jQuery('#product_composite_configure_form_fields #options_'+fromOptionId+'_text').val('');
                jQuery('#product_composite_configure_form_fields #options_'+toOptionId+'_text').val('');
                jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val('');
            }
        },

        createSlotsData: function () {
            var d = new Date();
            var curr_date = d.getDate();
            var curr_month = d.getMonth() + 1;
            if (curr_month < 10) {
                curr_month = '0' + curr_month;
            }
            if (curr_date < 10) {
                curr_date = '0' + curr_date;
            }
            var curr_year = d.getFullYear();
            var todayDate = curr_year + "-" + curr_month + "-" + curr_date;
            var todayElemnt = jQuery("#product_composite_configure_form_fields .wk-calendar-container").find('.wk-calendar-col').find('.wk-calendar-cell[data-date=' + todayDate + ']');

            if (todayElemnt.length) {
                if (jQuery(todayElemnt).hasClass('slot-available')) {
                    var date = todayElemnt.attr("data-date");
                    jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');
                    todayElemnt.addClass('active');
                    this.loadSlotsData(date);
                } else {
                    if (jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .slot-available').first().length) {
                        var date = jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .slot-available').first().attr("data-date");
                        jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');
                        jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .slot-available').first().addClass('active');
                        this.loadSlotsData(date);
                    }
                }
            } else {
                if (jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .slot-available').first().length) {
                    var date = jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .slot-available').first().attr("data-date");
                    jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');
                    jQuery('#product_composite_configure_form_fields .wk-calendar-container .wk-calendar-col .slot-available').first().addClass('active');
                    this.loadSlotsData(date);
                }
            }
        },

        loadSlotsData: function (date) {
            var options = this.options;
            jQuery.ajax(
                {
                    url: options.slotsUrl,
                    type: 'POST',
                    dataType: 'json',
                    data: { product_id: options.productId, date: date },
                    success: function (data) {
                        if (data.avl == 1) {
                            var slotHtml = "";
                            jQuery.each(
                                data.slots,
                                function (key, item) {
                                    var day = item.day;
                                    var id = item.id;
                                    var qtyInfo = item.qty;
                                    var dateFormatted = item.date_formatted.split(",");
                                    var dateFrom = item.booking_from.split(",");
                                    var dateTo = item.booking_to.split(",");
                                    var reservedQty = 0;
                                    if (options.booking_type == 2) {
                                        var rowClass = 'wk-row';
                                    } else {
                                        var rowClass = 'wk-row wk-many-row wk-many-row-id'+id;
                                    }
                                    slotHtml += '<div class="' + rowClass + '">';
                                    if (options.booking_type == 2) {
                                        slotHtml += '<div class="wk-col first">' +
                                            '<span class="wk-label-days">' + item.no_of_days + '</span>' +
                                            '<span class="wk-label-days-text">' +
                                            '<div>' + $t('Day') + '</div>' +
                                            '<div>' + $t('Slot') + '</div>' +
                                            '</span>' +
                                            '</div>';
                                    }
                                    if (!jQuery('#product_composite_configure_form_fields .booked-slot-summary').is(':empty')) {
                                        if (jQuery('#product_composite_configure_form_fields .booked-slot-summary').find('.booked-short-history[data-booked-slot-id="' + id + '"]').length) {
                                            reservedQty = jQuery('#product_composite_configure_form_fields .booked-slot-summary').find('.booked-short-history[data-booked-slot-id="' + id + '"]').children('input').val();
                                            qtyInfo = parseInt(qtyInfo) - parseInt(reservedQty);
                                        }
                                    }
                                    var textQtyBox = $t('Your Need');
                                    var checked = '';
                                    if (reservedQty > 0) {
                                        textQtyBox = $t('Selected');
                                        checked = "checked";
                                    }
                                    slotHtml += '<div class="wk-col middle">' +
                                        '<span class="wk-label-dates">' +
                                        '<span class="wk-span-from">';
                                    if (options.booking_type == 2) {
                                        slotHtml += '<div>' + dateFrom[0] + '</div>';
                                    }
                                    slotHtml += '<div>' + dateFrom[1] + '</div>' +
                                        '</span>' +
                                        '<span>to</span>' +
                                        '<span class="wk-span-to">';
                                    if (options.booking_type == 2) {
                                        slotHtml += '<div>' + dateTo[0] + '</div>';
                                    }
                                    slotHtml += '<div>' + dateTo[1] + '</div>' +
                                        '</span>' +
                                        '</span>' +
                                        '<span class="wk-label-avl-qty">' +
                                        '<span class="wk-avl-text">' + $t('Available :') + '</span>' +
                                        '<span>' + qtyInfo + '</span>' +
                                        '</span>' +
                                        '</div>';
                                    slotHtml += '<div class="wk-col last">' +
                                        '<span class="wk-booked-txt">' + textQtyBox + '</span>' +
                                        '<input type="number" class="wk-qty" value="' + reservedQty + '" data-id=' + id + '>' +
                                        '<input type="hidden" name="wk-qty-booked-hide" value="' + reservedQty + '" class="wk-qty-booked-hide">' +
                                        '<label class="wk-slot-select-radio-container"><input type="checkbox" name="wk-slot-select-radio" class="wk-slot-select-radio required-entry"' + checked + ' ><span class="wk-slot-select-radio-btn"></span>'+
                                        '</div></label>';
                                    slotHtml += '</div>';

                                    if (dateFormatted[0] < 10) {
                                        dateFormatted[0] = '0' + dateFormatted[0];
                                    }
                                    jQuery("#product_composite_configure_form_fields .wk-booking-table-head").find('.wk-selected-date').text(dateFormatted[0]);
                                    jQuery("#product_composite_configure_form_fields .wk-booking-table-head").find('.wk-month').text(dateFormatted[1]);
                                    jQuery("#product_composite_configure_form_fields .wk-booking-table-head").find('.wk-selected-day').text(day);
                                }
                            );
                            jQuery("#product_composite_configure_form_fields .wk-booking-table-body").html(slotHtml);
                        } else {
                            var slotHtml = "";
                            slotHtml = '<div class="wk-no-booking">' + data.msg + '</div>';
                            jQuery("#product_composite_configure_form_fields .wk-booking-table-body").html(slotHtml);
                        }
                    }
                }
            );
        }
    };
});
