/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
    'jquery',
    'mage/template',
    'mage/translate',
    'Magento_Ui/js/modal/alert',
    "jquery/ui",
    'prototype'
], function (jQuery, mageTemplate, $t, alert) {
    'use strict';

    if (typeof EventBookingProduct == 'undefined') {
        window.EventBookingProduct = {};
    }

    EventBookingProduct.Config = Class.create();
    EventBookingProduct.Config.prototype = {
        /**
         * Initialize function.
         *
         * @param {Object} config
         */
        initialize: function (config) {
            var separatorIndex, paramsStr, urlValues, i, childSettings, prevSetting, nextSetting, optionsById={};

            this.config     = config;
            this.options = this.config.options;
            jQuery.each(this.options, function (k, v) {
                optionsById[v.id] = v.title;
                if (v.title == 'Event Tickets') {
                    jQuery('#product_composite_configure_form_fields #select_'+v.id).parents('.field.admin__field').hide();
                }
                if (v.title == 'Event From') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Event To') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Event Location') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
            });

            if (config.containerId) {
                this.settings   = $$('#' + config.containerId + ' ' + '.wk-bk-option');
            } else {
                this.settings   = $$('.wk-bk-option');
            }

            // Put events to check select reloads
            this.settings.each(function (element) {
                Event.observe(element, 'change', this.configure.bind(this));
            }.bind(this));

            // Set values to inputs
            this.configureForValues();
            document.observe('dom:loaded', this.configureForValues.bind(this));
        },

        /**
         * Configure for values.
         */
        configureForValues: function () {
            this.settings.each(function (element) {
                this.configureElement(element);
            }.bind(this));
        },

        /**
         * @param {Object} event
         */
        configure: function (event) {
            var element = Event.element(event);
            this.configureElement(element);
        },

        /**
         * @param {Object} element
         */
        configureElement: function (element) {
            this.fillSelect(element);
        },

        /**
         * @param {Object} element
         */
        fillSelect: function (element) {
            var fromDateEle, toDateEle, locEle;

            if (fromDateEle = element.parentNode.parentNode.querySelector('#wk-option-from-date')) {
                var dataOptId = fromDateEle.getAttribute('data-opt-id');
                var dataOptValue = fromDateEle.value;
                jQuery('#product_composite_configure_form_fields #'+dataOptId).val(dataOptValue);
            }

            if (toDateEle = element.parentNode.parentNode.querySelector('#wk-option-to-date')) {
                var dataOptId = toDateEle.getAttribute('data-opt-id');
                var dataOptValue = toDateEle.value;
                jQuery('#product_composite_configure_form_fields #'+dataOptId).val(dataOptValue);                
            }

            if (locEle = element.parentNode.parentNode.querySelector('#wk-option-loc-date')) {
                var dataOptId = locEle.getAttribute('data-opt-id');
                var dataOptValue = locEle.value;
                jQuery('#product_composite_configure_form_fields #'+dataOptId).val(dataOptValue);                
            }

            if (element.querySelector('.wk-event-custom-option')) {
                element.querySelector('.wk-event-custom-option').onclick = function() {
                    var inputField = element.querySelector('.wk-event-custom-option');
                    var checkbox = element.querySelector('.wk-event-select-radio');
                    if (checkbox && checkbox.checked) {
                        checkbox.checked = false;
                    }
                    // if (element.querySelector('.wk-event-select-radio')) {
                    //     element.querySelector('.wk-event-select-radio').checked = false;
                    // }
                };
            }

            if (element.querySelector('.wk-event-select-radio')) {
                element.querySelector('.wk-event-select-radio').onclick = function() {
                    this.checked = true;
                    var qty = 0;
                    var fieldPrevQty = 0;
                    var id = '';
                    var valId = '';
                    var qtyBox = element.querySelector('.wk-event-custom-option');
                    var prevQty = jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val();
                    if (qtyBox) {
                        qty = qtyBox.value;
                        fieldPrevQty = qtyBox.getAttribute('data-prev');
                        id = qtyBox.getAttribute('data-option-id');
                        valId = qtyBox.getAttribute("data-option-val-id");
                    }
                    var regex = /^[0-9]*(?:\.\d{1,2})?$/; // allow only numbers [0-9]
                    var cond = true;

                    if (qty == 0) {
                        cond = false;
                        alert({
                            content: $t('Please enter a value greater than 0')
                        });
                        this.checked = false;
                        var selectEventEl = document.getElementById('select_'+id).options;
                        for(var i = 0; i < selectEventEl.length; i++){
                            if (selectEventEl[i].getAttribute('value') == valId) {
                                selectEventEl[i].selected = false;
                                if (fieldPrevQty != '' && fieldPrevQty != 0) {
                                    prevQty = prevQty - fieldPrevQty;
                                    jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val(prevQty);
                                    qtyBox.setAttribute('data-prev',0);
                                }
                            }
                        }
                        return false;
                    } else if (!regex.test(qty) || qty == "") {
                        cond = false;
                        alert({
                            content: $t('Please enter a numeric value and is greater than 0')
                        });
                        this.checked = false;
                        var selectEventEl = document.getElementById('select_'+id).options;
                        for(var i = 0; i < selectEventEl.length; i++){
                            if (selectEventEl[i].getAttribute('value') == valId) {
                                selectEventEl[i].selected = false;
                                if (fieldPrevQty != '' && fieldPrevQty != 0) {
                                    prevQty = prevQty - fieldPrevQty;
                                    jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val(prevQty);
                                    qtyBox.setAttribute('data-prev',0);
                                }
                            }
                        }
                    }

                    if (cond && qty > 0) {
                        if (isNaN(prevQty) || prevQty == '') {
                            prevQty = 0;
                        }
                        if (fieldPrevQty != '' && parseInt(prevQty) >= parseInt(fieldPrevQty)) {
                            prevQty = prevQty - fieldPrevQty;
                        }
                        qtyBox.setAttribute('data-prev',qty);
                        qty = parseInt(prevQty) + parseInt(qty);
                        var AllQtybox = jQuery('.wk-event-custom-option');
                        var selectedOpt = []
                        jQuery(AllQtybox).each(function() {
                           if (jQuery(this).attr('data-prev') != '' && jQuery(this).attr('data-prev') != 0) {
                               var optId = jQuery(this).attr('data-option-id');
                               var optValId = jQuery(this).attr('data-option-val-id');
                               selectedOpt.push(optValId);
                           }
                        });
                        jQuery('#product_composite_configure_form_fields #select_'+id).val(selectedOpt).trigger("change");
                        jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val(qty);
                        jQuery('#product_composite_configure_form_fields #order-search').append(
                            jQuery('<input>').attr('type', 'hidden')
                                .addClass('wk-selected-event-radio-btn')
                                .val('wk-event-row-id'+id+valId)
                        );
                    } else if (cond && qty == 0 && (this.keyCode == 8 || this.keyCode == 46)) {
                        this.checked = false;
                        var selectEventEl = document.getElementById('#product_composite_configure_form_fields #select_'+id).options;
                        for(var i = 0; i < selectEventEl.length; i++){
                            selectEventEl[i].selected = false;
                        }
                    }
                }
            }
        }
    };
});
