/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
    "jquery",
    'mage/template',
    'mage/translate',
    "mage/calendar",
    'prototype'
], function (jQuery, mageTemplate, $t) {
    'use strict';

    if (typeof HotelBookingProduct == 'undefined') {
        window.HotelBookingProduct = {};
    }

    HotelBookingProduct.Config = Class.create();
    HotelBookingProduct.Config.prototype = {

        /**
         * Initialize function.
         *
         * @param {Object} config
         */
        initialize: function (config) {
            this.config = config;
            var datesArr = [];
            var bookedDatesArr = [];
            var superAttrName = '';

            var optionsData = JSON.parse(config.optionsJson);

            jQuery.each(optionsData, function (k, v) {
                if (v.title == 'Booking From') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Booking Till') {
                   jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Adults') {
                   jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Kids') {
                   jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
            });

            if (config.containerId) {
                this.settings   = $$('#' + config.containerId + ' ' + '.wk-bk-dates-container');
            } else {
                this.settings   = $$('.wk-bk-dates-container');
            }

            // Set values to inputs
            this.configureForValues();
            document.observe('dom:loaded', this.configureForValues.bind(this));
        },

        /**
         * Configure for values.
         */
        configureForValues: function () {
            this.settings.each(function (element) {
                this.configureElement(element);
            }.bind(this));
        },

        /**
         * @param {Object} event
         */
        configure: function (event) {
            var element = Event.element(event);

            this.configureElement(element);
        },

        /**
         * @param {Object} element
         */
        configureElement: function (element) {
            this.fillSelect(element);
        },

        /**
         * @param {Object} element
         */
        fillSelect: function (element) {
            var self = this;
            var availableDatesArr = [];

            if (self.config.bookedDates) {
                self.bookedDatesArr = JSON.parse(self.config.bookedDates);
            }
            if (self.config.availableDates) {
                availableDatesArr = JSON.parse(self.config.availableDates);
            }

            if (element.parentNode.parentNode.querySelector('#product_composite_configure_fields_qty')) {
                element.parentNode.parentNode
                    .querySelector('#product_composite_configure_fields_qty')
                    .hidden = true;
            }

            this.setDefaultDateRange(self, element);

            var children = element.querySelectorAll('.hotel-number-quantity');
            for(var i=0; i < children.length; i++) {
                if (children[i].querySelector('.quantity-up')) {
                    jQuery(children[i].querySelector('.quantity-up')).unbind("click");
                    self.clickQuantityUp(self, element, children[i].querySelector('.quantity-up'));
                }
            }

            var children = element.querySelectorAll('.hotel-number-quantity');
            for(var i=0; i < children.length; i++) {
                if (children[i].querySelector('.quantity-down')) {
                    jQuery(children[i].querySelector('.quantity-down')).unbind("click");
                    self.clickQuantityDown(self, element, children[i].querySelector('.quantity-down'));
                }
            }
        },
    
        setDefaultDateRange: function (self, element) {
            if (element.querySelector('#wk-hbk-select-date-from')) {
                var bookingDateFrom = jQuery(element.querySelector('#wk-hbk-select-date-from'))
                    .datepicker({
                        'minDate': 'today',
                        'dateFormat': 'dd M, yy'
                    })
                    .on("change", function () {
                        bookingDateTo.datepicker("option", "minDate", self.getBookingDate(self, element, this, 0));
                    }),
                bookingDateTo = jQuery(element.querySelector('#wk-hbk-select-date-to'))
                    .datepicker({
                        'minDate': '+1',
                        'dateFormat': 'dd M, yy'
                    })
                    .on("change", function () {
                        bookingDateFrom.datepicker("option", "maxDate", self.getBookingDate(self, element, this, +1));
                    });
                this.setBlurOnDates(self, element);
                this.roomConfigTypesClick(self, element);
            }
        },
    
        getBookingDate: function (self, element, currentElement, counter) {
            var date;
            try {
                var dateFormat = "dd M, yy";
                date = jQuery.datepicker.parseDate(dateFormat, currentElement.value);
                date.setDate(date.getDate() + counter);


                var dataOptId = jQuery(element.querySelector('#wk-hbk-select-date-from')).attr('data-opt-id');
                jQuery('#product_composite_configure_form_fields #'+dataOptId)
                    .val(element.querySelector('#wk-hbk-select-date-from').value);

                var dataOptId = jQuery(currentElement).attr('data-opt-id');
                jQuery('#product_composite_configure_form_fields #'+dataOptId).val(currentElement.value);

                self.calculatePrice(self, element);

                var hotelQty = self.calculateQty(self, element);
                var node = document.createElement("input");
                node.setAttribute("type", "hidden");
                node.setAttribute("id", "wk-hotel-qty");
                node.setAttribute("name", "hotel_qty");
                node.setAttribute("value", hotelQty);
                element.appendChild(node);
            } catch (error) {
                date = null;
            }
            return date;
        },
         
        setBlurOnDates: function (self, element) {
            element.querySelector('#wk-hbk-select-date-from').onblur = function() {
                var availableDatesArr = [];
                if (self.config.bookedDates) {
                    self.bookedDatesArr = JSON.parse(self.config.bookedDates);
                }
                if (self.config.availableDates) {
                    availableDatesArr = JSON.parse(self.config.availableDates);
                }
                var selectedDateFrom = this.value;
                var selectedDateTo = element.querySelector('#wk-hbk-select-date-to').value;
                if (selectedDateFrom && selectedDateTo) {
                    selectedDateFrom = Date.parse(selectedDateFrom);
                    selectedDateTo = Date.parse(selectedDateTo);
                    var _array = [];
                    for (var key in self.datesArr) {
                        var booked_dates_str = Date.parse(key);
                        if (booked_dates_str >= selectedDateFrom && booked_dates_str <= selectedDateTo) {
                            _array.push(self.datesArr[key]);
                        }
                    }
                    if (_array.length > 0) {
                        var maxRoom = Math.min.apply(Math, _array);
                        if (element.querySelector('.input-text.hotel-number-field.no-of-rooms')) {
                            jQuery(element.querySelector('.input-text.hotel-number-field.no-of-rooms'))
                                .attr("max", maxRoom);
                            if (maxRoom == 0) {
                                element.querySelector('.input-text.hotel-number-field.no-of-rooms').value = 0;
                            }
                        }
                    } else {
                        var childProduct = jQuery("input[name='selected_configurable_option']").val();
                        if (childProduct && availableDatesArr[childProduct]) {
                            if (element.querySelector('.input-text.hotel-number-field.no-of-rooms')) {
                                jQuery(element.querySelector('.input-text.hotel-number-field.no-of-rooms'))
                                    .attr("max", availableDatesArr[childProduct]);
                            }
                        }
                    }
                } else {
                    var childProduct = jQuery("input[name='selected_configurable_option']").val();
                    if (childProduct && availableDatesArr[childProduct]) {
                        if (element.querySelector('.input-text.hotel-number-field.no-of-rooms')) {
                            jQuery(element.querySelector('.input-text.hotel-number-field.no-of-rooms'))
                                .attr("max", availableDatesArr[childProduct]);
                        }
                    }
                }
            }
        },
    
        roomConfigTypesClick: function (self, element) {
            var children = element.querySelector('.hotel-super-attribute-select').querySelectorAll('.room-config-types');
            for(var i=0; i < children.length; i++) {
                if (children[i]) {
                    children[i].onclick = function() {
                        jQuery(element.querySelector('#wk-hbk-select-date-from')).datepicker("destroy");
                        jQuery(element.querySelector('#wk-bk-select-date-to')).datepicker("destroy");
                        self.setDefaultDateRange(self, element);
                        self.superAttributeSelected(self, element, this);
                    }
                }
            }
        },

        superAttributeSelected: function (self, element, currentElement)
        {
            var superButton = jQuery(currentElement);
            var optionId = jQuery(currentElement).attr("id");

            var superAttributeName = superButton.parents(".hotel-super-attribute-select").data("supername");
            self.superAttrName = superAttributeName;
            var superAttrPosition = superButton.parents(".hotel-super-attribute-select").data("position");
            if (jQuery("body .hotel-super-attribute-select").length > 1 && superAttrPosition == 1) {
                jQuery.each(
                    jQuery("body .hotel-super-attribute-select"),
                    function () {
                        if (jQuery(this).data("position") !== 1) {
                            jQuery(this).find(".room-config-types").removeClass("hotel-selected");
                        }
                    }
                );
            }
            superButton.siblings().removeClass("hotel-selected");
            // superButton.toggleClass("hotel-selected");
            superButton.removeClass("hotel-selected");
            superButton.addClass("hotel-selected");
            jQuery("body").find("select[name='" + superAttributeName + "']").val(optionId).change();
            var selectedOpt = jQuery("select[name='" + superAttributeName + "'] option[value='"+optionId+"']");

            self.calculatePrice(self, element);

            var hotelQty = self.calculateQty(self, element);
            var node = document.createElement("input");
            node.setAttribute("type", "hidden");
            node.setAttribute("name", "hotel_qty");
            node.setAttribute("id", "wk-hotel-qty");
            node.setAttribute("value", hotelQty);
            element.appendChild(node);

            jQuery("input[name='selected_configurable_option']").val(selectedOpt.attr('product-id'));

            var childProduct = jQuery("input[name='selected_configurable_option']").val();
            if (childProduct) {
                self.datesArr = [];
                var disabledDates = [];
                if (self.bookedDatesArr) {
                    for (var key in self.bookedDatesArr) {
                        if (key == childProduct) {
                            for (var date in self.bookedDatesArr[key]["booked_dates"]) {
                                self.datesArr = self.bookedDatesArr[key]["booked_dates"];
                                if (self.bookedDatesArr[key]["booked_dates"][date] <= 0) {
                                    disabledDates.push(date);
                                }
                            }
                        }
                    }
                }
                if (disabledDates.length > 0) {
                    jQuery(element.querySelector('#wk-hbk-select-date-from')).datepicker("destroy");
                    jQuery(element.querySelector('#wk-bk-select-date-to')).datepicker("destroy");
                    var bookingDateFrom = jQuery(element.querySelector('#wk-hbk-select-date-from'))
                        .datepicker({
                            'minDate': 'today',
                            'dateFormat': 'dd M, yy',
                            "beforeShowDay": function (date) {
                                var string = jQuery.datepicker.formatDate('dd M, yy', date);
                                var isDisabled = (jQuery.inArray(string, disabledDates) != -1);
                                return [!isDisabled];
                            }
                        }).on("change", function () {
                            bookingDateTo.datepicker("option", "minDate", self.getBookingDate(self, element, this, +1));
                        }),
                        bookingDateTo = jQuery(element.querySelector('#wk-bk-select-date-to'))
                            .datepicker({
                                'minDate': 'today',
                                'dateFormat': 'dd M, yy',
                                "beforeShowDay": function (date) {
                                    var string = jQuery.datepicker.formatDate('dd M, yy', date);
                                    var isDisabled = (jQuery.inArray(string, disabledDates) != -1);
                                    return [!isDisabled];
                                }
                            }).on("change", function () {
                                bookingDateFrom.datepicker("option", "maxDate", self.getBookingDate(self, element, this, -1));
                            });
                }

                this.setBlurOnDates(self, element);
            }
        },

        clickQuantityUp: function (self, element, currentElement) {
            currentElement.onclick = function () {
                var quantityField = jQuery(this).parents('.hotel-number-quantity');
                var numberFieldinput = quantityField.find('input.hotel-number-field[type="number"]');
                var max = parseInt(numberFieldinput.attr('max'));
                var step = parseInt(numberFieldinput.attr('step'));
                if (!step) {
                    step = 1;
                }

                var numberFieldValue = numberFieldinput.val();
                if (!numberFieldValue) {
                    numberFieldValue = 0;
                }

                var oldValue = parseInt(numberFieldValue);
                if (!max) {
                    var newVal = oldValue + step;
                } else {
                    if (oldValue >= max) {
                        var newVal = oldValue;
                    } else {
                        var newVal = oldValue + step;
                    }
                }

                numberFieldinput.val(newVal);

                if (numberFieldinput.attr('id') == 'wk_bk_qty') {
                    jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val(newVal);
                } else {
                    var dataOptId = numberFieldinput.attr('data-opt-id');
                    jQuery('#product_composite_configure_form_fields #'+dataOptId).val(newVal);
                }
            }
        },

        clickQuantityDown: function (self, element, currentElement) {
            currentElement.onclick = function () {
                var quantityField = jQuery(this).parents('.hotel-number-quantity');
                var numberFieldinput = quantityField.find('input.hotel-number-field[type="number"]');
                var min = parseInt(numberFieldinput.attr('min'));
                var step = parseInt(numberFieldinput.attr('step'));
                if (!step) {
                    step = 1;
                }

                var numberFieldValue = numberFieldinput.val();
                if (!numberFieldValue) {
                    numberFieldValue = 1;
                }

                var oldValue = parseInt(numberFieldValue);

                if (oldValue <= min) {
                    var newVal = oldValue;
                } else {
                    var newVal = oldValue - step;
                }

                numberFieldinput.val(newVal);

                if (numberFieldinput.attr('id') == 'wk_bk_qty') {
                    jQuery('#product_composite_configure_form_fields #product_composite_configure_input_qty').val(newVal);
                } else {
                    var dataOptId = numberFieldinput.attr('data-opt-id');
                    jQuery('#product_composite_configure_form_fields #'+dataOptId).val(newVal);
                }
                //numberFieldinput.trigger("change");
            }
        },

        calculatePrice: function (self, element) {
            var price;
            var selectedOpt = jQuery("select[name='" + self.superAttrName + "']").find('option:selected'); 
            var chargedPrice = parseFloat(selectedOpt.attr("original-price"));
            var dateFrom = new Date(element.querySelector('#wk-hbk-select-date-from').value);
            var dateTo = new Date(element.querySelector('#wk-hbk-select-date-to').value);

            var timeDiff = dateTo.getTime() - dateFrom.getTime();
            var daysDiff = parseInt(timeDiff / (1000 * 3600 * 24));
            price = chargedPrice*daysDiff;
            selectedOpt.attr('price', price);
        },
        
        calculateQty: function (self, element) {
            if (element.querySelector('#wk-hotel-qty')) {
                element.querySelector('#wk-hotel-qty').remove();
            }
            var qty = 0;
            var bookingFrom = Date.parse(jQuery("input#wk-hbk-select-date-from").val());
            var bookingTo = Date.parse(jQuery("input#wk-hbk-select-date-to").val());

            var noOfDays = Math.round((bookingTo - bookingFrom) / (1000 * 60 * 60 * 24));
            if (parseInt(noOfDays)) {
                qty = qty + noOfDays;
            }

            return qty;
        }
    };
});
