/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
    "jquery",
    'mage/template',
    'mage/translate',
    'Magento_Ui/js/modal/alert',
    "mage/calendar",
    "jquery/ui",
    'prototype'
], function (jQuery, mageTemplate, $t, alert) {
    'use strict';

    var inputTemplate = '<div class="wk-bk-dates-left-container">'+
            '<div>'+
                '<span class="table-attr-labels">'+$t('Select Date')+'</span>'+
            '</div>'+
            '<input class="required-entry input-text wk-bk-datetype" type="text" id="wk-tbk-select-date"  name="booking_date" value="<%- data.bookingAvailableFrom %>" placeholder="<%- data.bookingDate %>" readonly/><label for="wk-tbk-select-date" data-booking-date="<%- data.bookingDate %>" class="wk-bk-select-date-label"><%- data.bookingDate %></label>'+
        '</div>'+
        '<div class="wk-bk-dates-right-container">'+
            '<div>'+
                '<span class="table-attr-labels">'+$t('Select Time')+'</span>'+
            '</div>'+
            '<input id="wk-bk-booking-time-field" type="hidden" name="booking_time" value="<%- data.defaultTime %>"/><label for="wk-bk-select-time" class="wk-bk-select-time-label"><%- data.defaultTimeLabel %></label>'+
            '<div class="wk-bk-select-time-opt-wrapper"'+
                '<% if (data.slots == "undefind") { %>' +
                    ' style="display: none;"' +
                '<% } %>'+
                '>'+
            '</div>'+
        '</div>'+
        '<div class="wk-bk-table-options fieldset">'+
            '<div id="wk-bk-option-qty" class="wk-table-options field required">'+
                '<label class="table-attr-labels label">'+
                    '<%- data.customOptionLabel %>'+
                '</label>'+
                '<div>'+
                    '<span class="users-icon"></span>'+
                    '<% if (data.chargedPerConfig == 1) { %>'+
                        '<input id="wk-table-qty"'+
                            'class="input-text product-custom-option validate-number no_of_guests"'+
                            'name="wk-table-qty"'+
                            'aria-required="true" type="number" min="1"'+
                            'max="<%- data.maxCapacity %>"'+
                            'value="<%- data.minNoOfGuestsAllowed %>"'+
                            'step = "1"/>'+
                    '<% } else { %>'+
                        '<input id="wk-table-qty"'+
                            'class="input-text product-custom-option validate-number no_of_guests"'+
                            'name="wk-table-qty"'+
                            'aria-required="true" type="number" min="1"'+
                            'max="<%- data.maxCapacity %>"'+
                            'step = "1"/>'+
                    '<% } %>'+
                '</div>'+
            '</div>'+
            '<% _.each(data.optionsData, function(optionValues, optionId) { %>'+
                '<% if (optionValues.title == "Special Request/Notes") { %>'+
                    '<div class="wk-table-options">'+
                        '<label class="table-attr-labels">'+
                            $t("<%- optionValues.title %>") +
                        '</label>'+
                        '<div>'+
                            '<textarea '+
                            'class="input-text product-custom-option wk-table-spcl-req-option" '+
                            'name="wk-table-spcl-req-option" '+
                            'data-opt-id="options_<%- optionValues.id %>_text" '+
                            'placeholder="'+$t("we would prefer window table first.")+'"'+
                            '></textarea>'+
                        '</div>'+
                    '</div>'+
                '<% } %>'+
            '<% }); %>'+
        '</div>'+
        '<input type="hidden" name="parent_slot_id" id="wk-bk-parent-slot-id" value="<%- data.parentSlotIndex %>">'+
        '<input type="hidden" name="slot_id" id="wk-bk-slot-id" value="<%- data.childSlotIndex %>">'+
        '<input type="hidden" name="slot_day_index" id="wk-bk-slot-day-index" value="<%- data.fromDayIndex %>">'+
        '<input type="hidden" name="charged_per_count" id="charged_per_count" value="<%- data.chargedPerCount %>"></input>';

        var selectTimeOptTodayTemplate = '<% _.each(data.slots, function(value, key) { %>' +
            '<% _.each(value, function(slotValue, slotKey) { %>' +
                '<span class="wk-bk-select-time-opt wk-table-select-time-opt  ' +
                    '<% if ((slotValue.qty <= 0) || (data.now >= slotValue.timestring) || (data.bookedTimeSlot.length >0 & (slotValue.time).includes(data.bookedTimeSlot))) { %>' +
                        '<%- data.bookedClass %>' +
                    '<% } %>' +
                    '<% if (key == data.index & slotKey == data.slotIndex & (data.now <= slotValue.timestring)) { %>' +
                        '<% data.activeFirst = 1; %>' +
                        '<%- data.selectedClass %>' +
                    '<% } %>' +
                    '<% if (data.now <= slotValue.timestring & data.activeFirst == 0) { %>' +
                        '<% data.activeFirst = 1; %>' +
                        '<%- data.selectedClass %>' +
                    '<% } %>' +
                    '" data-type-time="<%- slotValue.time %>" data-day-index="<%- data.fromDayIndex %>" data-index="<%- key %>" data-slot-index="<%- slotKey %>" data-slot-qty="<%- slotValue.qty %>">' +
                    '<%- slotValue.time %>' +
                '</span>' +
            '<% }); %>' +
        '<% }); %>';

    if (typeof TableBookingProduct == 'undefined') {
        window.TableBookingProduct = {};
    }

    TableBookingProduct.Config = Class.create();
    TableBookingProduct.Config.prototype = {
        inputTemplate: inputTemplate,
        selectTimeOptTodayTemplate: selectTimeOptTodayTemplate,
        /**
         * Initialize function.
         *
         * @param {Object} config
         */
        initialize: function (config) {
            config.optionsData = JSON.parse(config.optionsJson);
            this.config     = config;
            this.optionsData = this.config.optionsData;
            this.holidaysData = config.holidaysData;
            this.isTodayHoliday = config.isTodayHoliday;

            jQuery.each(this.optionsData, function (k, v) {
                if (v.title == 'Booking Date') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(config.bookingDate);
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Booking Slot') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(config.bookingSlot);
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Special Request/Notes') {
                   jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Charged Per') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(config.chargedPerLabel);
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
            });

            if (config.containerId) {
                this.settings   = $$('#' + config.containerId + ' ' + '.wk-bk-option');
            } else {
                this.settings   = $$('.wk-bk-option');
            }

            // Put events to check select reloads
            // this.settings.each(function (element) {
            //     Event.observe(element, 'change', this.configure.bind(this));
            // }.bind(this));

            // Set values to inputs
            this.configureForValues();
            document.observe('dom:loaded', this.configureForValues.bind(this));
        },

        /**
         * Configure for values.
         */
        configureForValues: function () {
            this.settings.each(function (element) {
                this.configureElement(element);
            }.bind(this));
        },

        /**
         * @param {Object} event
         */
        configure: function (event) {
            var element = Event.element(event);

            this.configureElement(element);
        },

        /**
         * @param {Object} element
         */
        configureElement: function (element) {
            this.fillSelect(element);
        },

        /**
         * @param {Object} element
         */
        fillSelect: function (element) {
            var self = this;
            //var optionId = element.id.replace(/[a-z]*/, '');
            var todaySlotArr = this.config.todaySlotArr;

            var progressTmpl = mageTemplate(this.inputTemplate),
            tmpl;
            tmpl = progressTmpl({
                data: this.config
            });

            element.innerHTML = tmpl;
            // element.childNodes[1].childNodes[2] = .wk-bk-select-time-label

            if (element.childNodes[1]) {
                if (element.childNodes[1].childNodes[2]) {
                    //element.childNodes[1].childNodes[2].setAttribute("data-mage-init", "{'dropdown':{}}");
                    jQuery(element.childNodes[1].childNodes[2]).dropdown();
                }
            }

            // element.childNodes[0].childNodes[1] = #wk-tbk-select-date
            jQuery(element.childNodes[0].childNodes[1])
            .datepicker({
                minDate: this.config.bookingAvailableFrom,
                maxDate: this.config.bookingAvailableTo,
                beforeShowDay: function (date) {
                    let string = jQuery.datepicker.formatDate('yy-mm-dd', date);
                    let holiday = self.holidaysData[string];
                    if(holiday){
                        return [false,'',holiday];
                    }
                    return [true];
                },
                onSelect: function () {
                    self.getTableBookingDate(self, element, this);
                }
            });
            
            todaySlotArr.now = parseInt(Date.now()/1000);
            todaySlotArr.activeFirst = 0;
            if(!this.isTodayHoliday) {
                var progressTmpl = mageTemplate(this.selectTimeOptTodayTemplate),
                tmpl;
                tmpl = progressTmpl({
                    data: todaySlotArr
                });
            }else{
                tmpl = null;
            }

            //element.childNodes[1].childNodes[3] = .wk-bk-select-time-opt-wrapper
            var selectTimeOptElement = element.childNodes[1].childNodes[3];

            selectTimeOptElement.innerHTML = tmpl;


            if (element.childNodes[2].querySelector('#wk-table-qty')) {
                element.childNodes[2].querySelector('#wk-table-qty')
                    .setAttribute('data-validate', '{"required":true}');                
            }

            if (element.parentNode.parentNode.parentNode.parentNode.querySelector('#product_composite_configure_fields_qty')) {
                element.parentNode.parentNode.parentNode.parentNode
                    .querySelector('#product_composite_configure_fields_qty')
                    .hidden = true;
            }

            this.changeQtyEvent(self, element);

            this.changeSpecialRequestEvent(self, element);

            this.selectTimeSlot(self, selectTimeOptElement, element);

            var selectedTime = '';
            if (selectTimeOptElement.querySelector('.wk-bk-slot-selected') != null) {
                selectedTime = selectTimeOptElement.querySelector('.wk-bk-slot-selected').textContent;
            }

            //element.childNodes[1].childNodes[1] = #wk-bk-booking-time-field
            var bookingTimeField = element.childNodes[1].childNodes[1];
            bookingTimeField.value = selectedTime;
            bookingTimeField.nextSibling.textContent = selectedTime;
            if (!selectedTime) {
                bookingTimeField.nextSibling.textContent = $t('Closed');
            }

            this._setProductOptions(selectTimeOptElement.querySelector('.wk-bk-slot-selected'), element);
        },
    
        getTableBookingDate: function (self, element, currentElement) {
            var date;
            try {
                var dateFormat = "mm/dd/yy";
                date = jQuery.datepicker.parseDate(dateFormat, currentElement.value);

                var options = this.config;
                var monthArr = options.monthArr;
                var todaySlotArr = options.todaySlotArr;
                todaySlotArr.now = parseInt(Date.now()/1000);
                todaySlotArr.activeFirst = 0;
                var optionsData = JSON.parse(options.optionsJson);
    
                var selectedDate  = currentElement.value;

                var parsedDate = Date.parse(selectedDate, "yyyy-MM-dd");
                var str = parsedDate.toString();
                parsedDate = str.substr(0, str.length-3);

                var selectedDateArr  = selectedDate.split('/');
                var day = selectedDateArr[1];
                var month = selectedDateArr[0];
                var year = selectedDateArr[2];
                var formatedDate = day+" "+monthArr[month]+", "+year;
                let optionDate = year+"-"+month+"-"+day;
                var d = new Date(selectedDate);
                var dayIndex = d.getDay();
                if (dayIndex == 0) {
                    dayIndex = 7;
                }

                var todayDate = new Date();
                var tday = todayDate.getDate();
                var tmonth = todayDate.getMonth() + 1;
                var tyear = todayDate.getFullYear();
                // if from selected date is today
                if (day == tday && month == tmonth && year == tyear) {
                    var progressTmpl = mageTemplate(this.selectTimeOptTodayTemplate),
                    tmpl;
                    tmpl = progressTmpl({
                        data: todaySlotArr
                    });
                } else {
                    tmpl = this.generateSelectTimeOptTemplateByDay(options, dayIndex);
                }

                if (element.childNodes[1].childNodes[2]) {
                    jQuery(element.childNodes[1].childNodes[2]).dropdown();                    
                }

                //element.childNodes[1].childNodes[3] = .wk-bk-select-time-opt-wrapper

                var selectTimeOptElement = element.childNodes[1].childNodes[3];

                selectTimeOptElement.innerHTML = tmpl;

                this.selectTimeSlot(self, selectTimeOptElement, element);      

                if (parsedDate in options.bookedData) {
                    jQuery.each(options.bookedData[parsedDate], function (key, value) {
                        if (selectTimeOptElement.querySelector(".wk-table-select-time-opt[data-type-time='"+key+"']").length) {
                            var optTimeHtml = selectTimeOptElement.querySelector(".wk-table-select-time-opt[data-type-time='"+key+"']");
                            var remainingQty = optTimeHtml.data("slot-qty") - value;
                            if (remainingQty <= 0) {
                                optTimeHtml.classList.remove('wk-bk-slot-booked');
                                optTimeHtml.classList.remove('wk-bk-slot-selected');
                                optTimeHtml.classList.add('wk-bk-slot-booked');
                                selectTimeOptElement.querySelector(".wk-table-select-time-opt[data-type-time='"+key+"']")
                                    .nextSibling
                                    .classList
                                    .add('wk-bk-slot-selected');
                            }
                        }
                    });
                }

                
                selectTimeOptElement.removeAttribute('style');
                var selectedTime = '';
                if (selectTimeOptElement.querySelector('.wk-bk-slot-selected') != null) {
                    var selectedTime = selectTimeOptElement.querySelector('.wk-bk-slot-selected').textContent;
                    var wkBkSlotSelected = selectTimeOptElement.querySelector('.wk-bk-slot-selected');

                    if (element.querySelector('#wk-bk-slot-day-index') != null) {
                        element.querySelector('#wk-bk-slot-day-index').value = jQuery(wkBkSlotSelected).attr('data-day-index');
                    }

                    if (element.querySelector('#wk-bk-parent-slot-id') != null) {
                        element.querySelector('#wk-bk-parent-slot-id').value = jQuery(wkBkSlotSelected).attr('data-index');
                    }

                    if (element.querySelector('#wk-bk-slot-id') != null) {
                        element.querySelector('#wk-bk-slot-id').value = jQuery(wkBkSlotSelected).attr('data-slot-index');
                    }
                }

                var isTimeClosed = false;

                //element.childNodes[1].childNodes[1] = #wk-bk-booking-time-field
                var bookingTimeField = element.childNodes[1].childNodes[1];

                bookingTimeField.value = selectedTime;

                //element.childNodes[1].childNodes[1].nextSibling = .wk-bk-select-time-label
                bookingTimeField.nextSibling.textContent = selectedTime;

                if (!selectedTime) {
                    bookingTimeField.nextSibling.textContent = $t('Closed');
                }
                if (!tmpl) {
                    selectedTime = options.titleClosed;
                    isTimeClosed = true;
                    jQuery(selectTimeOptElement).attr('style', 'display: none;');
                }
                if (selectedTime.length == 0) {
                    selectedTime = options.titleClosed;
                    isTimeClosed = true;
                }
                bookingTimeField.nextSibling.textContent = selectedTime;
                if (!selectedTime) {
                    bookingTimeField.nextSibling.textContent = $t('Closed');
                }

                //element.childNodes[0].childNodes[2] = .wk-bk-select-date-label;
                element.childNodes[0].childNodes[2].textContent = formatedDate;
                var attr = document.createAttribute("data-booking-date");
                attr.value = optionDate;
                element.childNodes[0].childNodes[2].setAttributeNode(attr);
                jQuery.each(optionsData, function (k, v) {
                    if (v.title == 'Booking Date') {
                        if (jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').length) {
                            jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(optionDate);
                        }
                    }
                    if (v.title == 'Booking Slot') {
                        if (isTimeClosed) {
                            selectedTime = "";
                        }
                        if (jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').length) {
                            jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(selectedTime);
                        }
                    }
                });
            } catch (error) {
                console.log(error);
                date = null;
            }
            return date;
        },

        generateSelectTimeOptTemplateByDay: function (options, dayIndex) {
            var availableSlotArr = options.availableSlotArr;
            var tempHtml = '';
            if (availableSlotArr[dayIndex] != 'undefined') {
                var j = 0;
                jQuery.each(availableSlotArr[dayIndex], function (key, value) {
                    jQuery.each(value, function (slotKey, slotValue) {
                        tempHtml = tempHtml + '<span class="wk-bk-select-time-opt wk-table-select-time-opt ';
                        if (slotValue.qty<=0) {
                            tempHtml = tempHtml + 'wk-bk-slot-booked ';
                        }
                        if (slotValue.qty>0 && !j) {
                            tempHtml = tempHtml + 'wk-bk-slot-selected ';
                        }
                        tempHtml = tempHtml + '"';
                        tempHtml = tempHtml + 'data-type-time="'+ slotValue.time +'"';
                        tempHtml = tempHtml + 'data-day-index="'+dayIndex+'"';
                        tempHtml = tempHtml + 'data-index="'+key+'"';
                        tempHtml = tempHtml + 'data-slot-index="'+slotKey+'"';
                        tempHtml = tempHtml + 'data-slot-qty="'+slotValue.qty+'">';
                        tempHtml = tempHtml + slotValue.time;
                        tempHtml = tempHtml + '</span>';
                        j++;
                        if (slotValue.qty<=0) {
                            j--;
                        }
                    });
                });
            }
            return tempHtml;
        },

        _setProductOptions: function (thisObj, element) {
            var optionsData = this.config.optionsData;
            var selectedTime  = jQuery(thisObj).attr('data-type-time');

            var children = element.childNodes[1].childNodes[3].children;
            for(var i=0; i < children.length; i++) {
                if (children[i].nodeType == 1) {
                    if (jQuery(children[i]).hasClass('wk-bk-slot-selected')) {
                        jQuery(children[i]).removeClass('wk-bk-slot-selected');
                    }
                }
            }
            jQuery(thisObj).parents('.wk-bk-dates-right-container').find('.wk-bk-select-time-label').text(selectedTime);
            jQuery(thisObj).addClass('wk-bk-slot-selected');

            if (element.querySelector('#wk-bk-slot-day-index') != null) {
                element.querySelector('#wk-bk-slot-day-index').value = jQuery(thisObj).attr('data-day-index');
            }

            if (element.querySelector('#wk-bk-parent-slot-id') != null) {
                element.querySelector('#wk-bk-parent-slot-id').value = jQuery(thisObj).attr('data-index');
            }

            if (element.querySelector('#wk-bk-slot-id') != null) {
                element.querySelector('#wk-bk-slot-id').value = jQuery(thisObj).attr('data-slot-index');
            }

            //element.childNodes[1].childNodes[1] = #wk-bk-booking-time-field
            var bookingTimeField = element.childNodes[1].childNodes[1];

            bookingTimeField.value = selectedTime;
            bookingTimeField.nextSibling.textContent = selectedTime;

            if (!selectedTime) {
                bookingTimeField.nextSibling.textContent = $t('Closed');
            }
            var bookedDate = jQuery(element.childNodes[0].childNodes[2]).attr('data-booking-date');
            jQuery.each(optionsData, function (k, v) {
                if (v.title == 'Booking Date') {
                    if (jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').length) {
                        jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(bookedDate);
                    }
                }
                if (v.title == 'Booking Slot') {
                    if (jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').length) {
                        jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(selectedTime);
                    }
                }
            });
        },

        changeQtyEvent: function (self, element) {
            element.childNodes[2].querySelector('#wk-table-qty').onchange = function() {
                var selectedQty = jQuery(this).val();
                var options = self.config;
                if (options.chargedPerConfig==1) {
                    var updatedQty = 1;
                    if (options.stepSize > 1) {
                        if (selectedQty % options.stepSize == 0) {
                            updatedQty = selectedQty / options.stepSize;
                        } else {
                            updatedQty = selectedQty / options.stepSize;
                            if (updatedQty < 1) {
                                updatedQty = updatedQty + 1;
                            }
                        }
                    } else {
                        updatedQty = selectedQty;
                    }
                    if (updatedQty > 0) {
                        jQuery("#product_composite_configure_form_fields #product_composite_configure_fields_qty").find("input[name='qty']").val(parseInt(updatedQty));
                        return true;
                    } else {
                        alert({content: $t('Minimum no. of allowed guests are '+options.stepSize)});
                        return false;
                    }
                } else {
                    if (selectedQty > 0) {
                        jQuery("#product_composite_configure_form_fields #product_composite_configure_fields_qty").find("input[name='qty']").val(parseInt(selectedQty));
                        return true;
                    } else {
                        return false;
                    }
                }
            };
        },

        changeSpecialRequestEvent: function (self, element) {
            element.childNodes[2].querySelector('.wk-table-spcl-req-option').onchange = function() {
                var dataOptId = jQuery(this).attr('data-opt-id');
                jQuery('#product_composite_configure_form_fields #'+dataOptId).val(jQuery(this).val());
            };
        },

        selectTimeSlot: function (self, selectTimeOptElement, element) {
            var children = selectTimeOptElement.children;
            for(var i=0; i < children.length; i++) {
                if (children[i].nodeType == 1) {
                    children[i].onclick = function() {
                        var thisObj = this;
                        // trigger event
                        element.childNodes[1].childNodes[2].click();

                        if (!jQuery(thisObj).hasClass('wk-bk-slot-booked')) {
                            var optionsData = self.config.optionsData;
                            var selectedTime  = jQuery(thisObj).attr('data-type-time');

                            var children = element.childNodes[1].childNodes[3].children;
                            for(var i=0; i < children.length; i++) {
                                if (children[i].nodeType == 1) {
                                    if (jQuery(children[i]).hasClass('wk-bk-slot-selected')) {
                                        jQuery(children[i]).removeClass('wk-bk-slot-selected');
                                    }
                                }
                            }
                            jQuery(thisObj).parents('.wk-bk-dates-right-container')
                                            .find('.wk-bk-select-time-label')
                                            .text(selectedTime);
                            jQuery(thisObj).addClass('wk-bk-slot-selected');


                            //element.childNodes[1].childNodes[1] = #wk-bk-booking-time-field
                            var bookingTimeField = element.childNodes[1].childNodes[1];

                            bookingTimeField.value = selectedTime;
                            bookingTimeField.nextSibling.textContent = selectedTime;

                            if (!selectedTime) {
                                bookingTimeField.nextSibling.textContent = $t('Closed');
                            }
                
                            if (element.querySelector('#wk-bk-slot-day-index') != null) {
                                element.querySelector('#wk-bk-slot-day-index').value = jQuery(thisObj).attr('data-day-index');
                            }
                
                            if (element.querySelector('#wk-bk-parent-slot-id') != null) {
                                element.querySelector('#wk-bk-parent-slot-id').value = jQuery(thisObj).attr('data-index');
                            }
                
                            if (element.querySelector('#wk-bk-slot-id') != null) {
                                element.querySelector('#wk-bk-slot-id').value = jQuery(thisObj).attr('data-slot-index');
                            }
                            var bookedDate = jQuery(element.childNodes[0].childNodes[2]).attr('data-booking-date');
                            jQuery.each(optionsData, function (k, v) {
                                if (v.title == 'Booking Date') {
                                    if (jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').length) {
                                        jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(bookedDate);
                                    }
                                }
                                if (v.title == 'Booking Slot') {
                                    if (jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').length) {
                                        jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val(selectedTime);
                                    }
                                }
                            });
                        }
                    };
                }
            }
        }
    };
});
