require.config({"config": {
        "jsbuild":{"js/theme.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine('globalNavigationScroll', [\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var win = $(window),\n        subMenuClass = '.submenu',\n        fixedClassName = '_fixed',\n        menu = $('.menu-wrapper'),\n        content = $('.page-wrapper'),\n        menuItems = $('#nav').children('li'),\n        winHeight,\n        menuHeight = menu.height(),\n        menuScrollMax = 0,\n        submenuHeight = 0,\n        contentHeight,\n        winTop = 0,\n        winTopLast = 0,\n        scrollStep = 0,\n        nextTop = 0;\n\n    /**\n     * Check if menu is fixed\n     * @returns {Boolean}\n     */\n    function isMenuFixed() {\n        return menuHeight < contentHeight && contentHeight > winHeight;\n    }\n\n    /**\n     * Check if class exist than add or do nothing\n     * @param {jQuery} el\n     * @param {String} $class\n     */\n    function checkAddClass(el, $class) {\n        if (!el.hasClass($class)) {\n            el.addClass($class);\n        }\n    }\n\n    /**\n     * Check if class exist than remove or do nothing\n     * @param {jQuery} el\n     * @param {String} $class\n     */\n    function checkRemoveClass(el, $class) {\n        if (el.hasClass($class)) {\n            el.removeClass($class);\n        }\n    }\n\n    /**\n     * Calculate and apply menu position\n     */\n    function positionMenu() {\n\n        //  Spotting positions and heights\n        winHeight = win.height();\n        contentHeight = content.height();\n        winTop = win.scrollTop();\n        scrollStep = winTop - winTopLast;\n\n        if (isMenuFixed()) { // fixed menu cases\n\n            checkAddClass(menu, fixedClassName);\n\n            if (menuHeight > winHeight) { // smart scroll cases\n\n                if (winTop > winTopLast) { //eslint-disable-line max-depth\n\n                    menuScrollMax = menuHeight - winHeight;\n\n                    nextTop < menuScrollMax - scrollStep ?\n                        nextTop += scrollStep : nextTop = menuScrollMax;\n\n                    menu.css('top', -nextTop);\n\n                } else if (winTop <= winTopLast) { // scroll up\n\n                    nextTop > -scrollStep ?\n                        nextTop += scrollStep : nextTop = 0;\n\n                    menu.css('top', -nextTop);\n\n                }\n\n            }\n\n        } else { // static menu cases\n            checkRemoveClass(menu, fixedClassName);\n            menu.css('top', 'auto');\n        }\n\n        //  Save previous window scrollTop\n        winTopLast = winTop;\n\n    }\n\n    positionMenu(); // page start calculation\n\n    //  Change position on scroll\n    win.on('scroll', function () {\n        positionMenu();\n    });\n\n    win.on('resize', function () {\n\n        winHeight = win.height();\n\n        //  Reset position if fixed and out of smart scroll\n        if (menuHeight < contentHeight && menuHeight <= winHeight) {\n            menu.removeAttr('style');\n            menuItems.off();\n        }\n\n    });\n\n    //  Add event to menuItems to check submenu overlap\n    menuItems.on('click', function () {\n\n        var submenu = $(this).children(subMenuClass),\n            delta,\n            logo = $('.logo')[0].offsetHeight;\n\n        submenuHeight = submenu.height();\n\n        if (submenuHeight > menuHeight && menuHeight + logo > winHeight) {\n            menu.height(submenuHeight - logo);\n            delta = -menu.position().top;\n            window.scrollTo(0, 0);\n            positionMenu();\n            window.scrollTo(0, delta);\n            positionMenu();\n            menuHeight = submenuHeight;\n        }\n    });\n\n});\n\ndefine('globalNavigation', [\n    'jquery',\n    'jquery/ui',\n    'globalNavigationScroll'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.globalNavigation', {\n        options: {\n            selectors: {\n                menu: '#nav',\n                currentItem: '._current',\n                topLevelItem: '.level-0',\n                topLevelHref: '> a',\n                subMenu: '> .submenu',\n                closeSubmenuBtn: '[data-role=\"close-submenu\"]'\n            },\n            overlayTmpl: '<div class=\"admin__menu-overlay\"></div>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var selectors = this.options.selectors;\n\n            this.menu = this.element;\n            this.menuLinks = $(selectors.topLevelHref, selectors.topLevelItem);\n            this.closeActions = $(selectors.closeSubmenuBtn);\n\n            this._initOverlay()\n                ._bind();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initOverlay: function () {\n            this.overlay = $(this.options.overlayTmpl).appendTo('body').hide(0);\n\n            return this;\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var focus = this._focus.bind(this),\n                open = this._open.bind(this),\n                blur = this._blur.bind(this),\n                keyboard = this._keyboard.bind(this);\n\n            this.menuLinks\n                .on('focus', focus)\n                .on('click', open);\n\n            this.menuLinks.last().on('blur', blur);\n\n            this.closeActions.on('keydown', keyboard);\n        },\n\n        /**\n         * Remove active class from current menu item\n         * Turn back active class to current page menu item\n         */\n        _blur: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem),\n                currentItem = $(selectors.menu).find(selectors.currentItem);\n\n            menuItem.removeClass('_active');\n            currentItem.addClass('_active');\n        },\n\n        /**\n         * Add focus to active menu item\n         */\n        _keyboard: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem);\n\n            if (e.which === 13) {\n                this._close(e);\n                $(selectors.topLevelHref, menuItem).trigger('focus');\n            }\n        },\n\n        /**\n         * Toggle active state on focus\n         */\n        _focus: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem);\n\n            menuItem.addClass('_active')\n                .siblings(selectors.topLevelItem)\n                .removeClass('_active');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _closeSubmenu: function (e) {\n            var selectors = this.options.selectors,\n                currentItem = $(selectors.menu).find(selectors.currentItem);\n\n            this._close(e);\n\n            currentItem.addClass('_active');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _open: function (e) {\n            var selectors = this.options.selectors,\n                menuItemSelector = selectors.topLevelItem,\n                menuItem = $(e.target).closest(menuItemSelector),\n                subMenu = $(selectors.subMenu, menuItem),\n                close = this._closeSubmenu.bind(this),\n                closeBtn = subMenu.find(selectors.closeSubmenuBtn);\n\n            if (subMenu.length) {\n                e.preventDefault();\n            }\n            closeBtn.on('click', close);\n\n            if ($(menuItem).hasClass('_show')) {\n                closeBtn.trigger('click');\n            } else {\n                menuItem.addClass('_show')\n                    .siblings(menuItemSelector)\n                    .removeClass('_show');\n                subMenu.attr('aria-expanded', 'true');\n                this.overlay.show(0).on('click', close);\n                this.menuLinks.last().off('blur');\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _close: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = this.menu.find(selectors.topLevelItem + '._show'),\n                subMenu = $(selectors.subMenu, menuItem),\n                closeBtn = subMenu.find(selectors.closeSubmenuBtn),\n                blur = this._blur.bind(this);\n\n            e.preventDefault();\n\n            this.overlay.hide(0).off('click');\n\n            this.menuLinks.last().on('blur', blur);\n\n            closeBtn.off('click');\n\n            subMenu.attr('aria-expanded', 'false');\n\n            menuItem.removeClass('_show _active');\n        }\n    });\n\n    return $.mage.globalNavigation;\n});\n\ndefine('globalSearch', [\n    'jquery',\n    'Magento_Ui/js/lib/key-codes',\n    'jquery-ui-modules/widget'\n], function ($, keyCodes) {\n    'use strict';\n\n    $.widget('mage.globalSearch', {\n        options: {\n            field: '.search-global-field',\n            fieldActiveClass: '_active',\n            input: '#search-global'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.field = $(this.options.field);\n            this.input = $(this.options.input);\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.input.on('blur.resetGlobalSearchForm', function () {\n                if (!self.input.val()) {\n                    self.field.removeClass(self.options.fieldActiveClass);\n                }\n            });\n\n            this.input.on('focus.activateGlobalSearchForm', function () {\n                self.field.addClass(self.options.fieldActiveClass);\n            });\n\n            $(document).on('keydown.activateGlobalSearchForm', function (event) {\n                var inputs = [\n                    'input',\n                    'select',\n                    'textarea'\n                ];\n\n                if (keyCodes[event.which] !== 'forwardSlashKey' ||\n                    inputs.indexOf(event.target.tagName.toLowerCase()) !== -1 ||\n                    event.target.isContentEditable\n                ) {\n                    return;\n                }\n\n                event.preventDefault();\n\n                self.input.focus();\n            });\n        }\n    });\n\n    return $.mage.globalSearch;\n});\n\ndefine('modalPopup', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.modalPopup', {\n        options: {\n            popup: '.popup',\n            btnDismiss: '[data-dismiss=\"popup\"]',\n            btnHide: '[data-hide=\"popup\"]'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.fade = this.element;\n            this.popup = $(this.options.popup, this.fade);\n            this.btnDismiss = $(this.options.btnDismiss, this.popup);\n            this.btnHide = $(this.options.btnHide, this.popup);\n\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.btnDismiss\n                .on('click.dismissModalPopup', function () {\n                    self.fade.remove();\n                });\n\n            this.btnHide\n                .on('click.hideModalPopup', function () {\n                    self.fade.hide();\n                });\n        }\n    });\n\n    return $.mage.modalPopup;\n});\n\ndefine('useDefault', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.useDefault', {\n        options: {\n            field: '.field',\n            useDefault: '.use-default',\n            checkbox: '.use-default-control',\n            label: '.use-default-label'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.el = this.element;\n            this.field = $(this.el).closest(this.options.field);\n            this.useDefault = $(this.options.useDefault, this.field);\n            this.checkbox = $(this.options.checkbox, this.useDefault);\n            this.label = $(this.options.label, this.useDefault);\n            this.origValue = this.el.attr('data-store-label');\n\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.el.on(\n                    'change.toggleUseDefaultVisibility keyup.toggleUseDefaultVisibility',\n                    $.proxy(this._toggleUseDefaultVisibility, this)\n                ).trigger('change.toggleUseDefaultVisibility');\n\n            this.checkboxon('change.setOrigValue', function () {\n                if ($(this).prop('checked')) {\n                    self.el\n                        .val(self.origValue)\n                        .trigger('change.toggleUseDefaultVisibility');\n\n                    $(this).prop('checked', false);\n                }\n            });\n        },\n\n        /**\n         * @private\n         */\n        _toggleUseDefaultVisibility: function () {\n            var curValue = this.el.val(),\n                origValue = this.origValue;\n\n            this[curValue != origValue ? '_show' : '_hide'](); //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            this.useDefault.show();\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            this.useDefault.hide();\n        }\n    });\n\n    return $.mage.useDefault;\n});\n\ndefine('loadingPopup', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.loadingPopup', {\n        options: {\n            message: 'Please wait...',\n            timeout: 5000,\n            timeoutId: null,\n            callback: null,\n            template: null\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.template =\n                '<div class=\"popup popup-loading\">' +\n                '<div class=\"popup-inner\">' + this.options.message + '</div>' +\n                '</div>';\n\n            this.popup = $(this.template);\n\n            this._show();\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.element\n                .on('showLoadingPopup', function () {\n                    self._show();\n                })\n                .on('hideLoadingPopup', function () {\n                    self._hide();\n                });\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            var options = this.options,\n                timeout = options.timeout;\n\n            $('body').trigger('processStart');\n\n            if (timeout) {\n                options.timeoutId = setTimeout(this._delayedHide.bind(this), timeout);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            $('body').trigger('processStop');\n        },\n\n        /**\n         * @private\n         */\n        _delayedHide: function () {\n            this._hide();\n\n            this.options.callback && this.options.callback();\n\n            this.options.timeoutId && clearTimeout(this.options.timeoutId);\n        }\n    });\n\n    return $.mage.loadingPopup;\n});\n\ndefine('collapsable', [\n    'jquery',\n    'jquery/ui',\n    'jquery/jquery.tabs'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.collapsable', {\n        options: {\n            parent: null,\n            openedClass: 'opened',\n            wrapper: '.fieldset-wrapper'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._events();\n        },\n\n        /** @inheritdoc */\n        _events: function () {\n            var self = this;\n\n            this.element\n                .on('show.bs.collapse', function (e) {\n                    var fieldsetWrapper = $(this).closest(self.options.wrapper);\n\n                    fieldsetWrapper.addClass(self.options.openedClass);\n                    e.stopPropagation();\n                })\n                .on('hide.bs.collapse', function (e) {\n                    var fieldsetWrapper = $(this).closest(self.options.wrapper);\n\n                    fieldsetWrapper.removeClass(self.options.openedClass);\n                    e.stopPropagation();\n                });\n        }\n    });\n\n    return $.mage.collapsable;\n});\n\ndefine('js/theme', [\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'collapsable',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    /* @TODO refactor collapsible as widget and avoid logic binding with such a general selectors */\n    $('.collapse').collapsable();\n\n    $.each($('.entry-edit'), function (i, entry) {\n        $('.collapse:first', entry).filter(function () {\n            return $(this).data('collapsed') !== true;\n        }).collapse('show');\n    });\n\n    keyboardHandler.apply();\n});\n","Magento_Downloadable/downloadable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/product/weight-handler',\n    'Magento_Catalog/catalog/type-events'\n], function ($, weight, productType) {\n    'use strict';\n\n    return {\n        $checkbox: $('[data-action=change-type-product-downloadable]'),\n        $items: $('#product_info_tabs_downloadable_items'),\n        $tab: null,\n        isDownloadable: false,\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.$checkbox.prop('checked', true);\n            this.$items.show();\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.$checkbox.prop('checked', false);\n            this.$items.hide();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_Downloadable/downloadable-type-handler': function (data) {\n            this.$tab = $('[data-tab=' + data.tabId + ']');\n            this.isDownloadable = data.isDownloadable;\n            this.bindAll();\n            this._initType();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            this.$checkbox.on('change', function (event) {\n                $(document).trigger('setTypeProduct', $(event.target).prop('checked') ?\n                    'downloadable' :\n                    productType.type.init === 'downloadable' ? 'virtual' : productType.type.init\n                );\n            });\n\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n            if (productType.type.current === 'downloadable') {\n                weight.change(false);\n                weight.$weightSwitcher().one('change', function () {\n                    $(document).trigger(\n                        'setTypeProduct',\n                        productType.type.init === 'downloadable' ? 'virtual' : productType.type.init\n                    );\n                });\n                this.show();\n            } else {\n                this.hide();\n            }\n        }\n    };\n});\n","Magento_Downloadable/js/components/is-downloadable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                disabled: 'changeVisibility'\n            },\n            modules: {\n                samplesFieldset: '${ $.samplesFieldset }',\n                linksFieldset: '${ $.linksFieldset}'\n            }\n        },\n\n        /**\n         * Change visibility for samplesFieldset & linksFieldset based on current statuses of checkbox.\n         */\n        changeVisibility: function () {\n            if (this.samplesFieldset() && this.linksFieldset()) {\n                if (this.checked() && !this.disabled()) {\n                    this.samplesFieldset().visible(true);\n                    this.linksFieldset().visible(true);\n                } else {\n                    this.samplesFieldset().visible(false);\n                    this.linksFieldset().visible(false);\n                }\n            }\n        },\n\n        /**\n         * Handle checked state changes for checkbox / radio button.\n         *\n         * @param {Boolean} newChecked\n         */\n        onCheckedChanged: function (newChecked) {\n            this.changeVisibility();\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_Downloadable/js/components/use-price-default-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            linksPurchasedSeparately: '0',\n            listens: {\n                linksPurchasedSeparately: 'changeVisibleStatus'\n            }\n        },\n\n        /**\n         * Change visibility of checkbox\n         */\n        changeVisibleStatus: function () {\n            if (this.linksPurchasedSeparately === '1') {\n                this.visible(true);\n            } else {\n                this.visible(false);\n            }\n        }\n    });\n});\n","Magento_Downloadable/js/components/upload-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (Select, registry) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            listens: {\n                value: 'changeTypeUpload'\n            },\n            typeUrl: 'file',\n            typeFile: 'link_url',\n            filterPlaceholder: 'ns = ${ $.ns }, parentScope = ${ $.parentScope }'\n        },\n\n        /**\n         * Initialize component.\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .changeTypeUpload(this.initialValue);\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         *\n         * @param {String} currentValue\n         * @returns {*}\n         */\n        onUpdate: function (currentValue) {\n            this.changeTypeUpload(currentValue);\n\n            return this._super();\n        },\n\n        /**\n         * Change visibility for typeUrl/typeFile based on current value.\n         *\n         * @param {String} currentValue\n         */\n        changeTypeUpload: function (currentValue) {\n            var componentFile = this.filterPlaceholder + ', index=' + this.typeFile,\n                componentUrl = this.filterPlaceholder + ', index=' + this.typeUrl;\n\n            switch (currentValue) {\n\n                case 'file':\n                    this.changeVisible(componentFile, true);\n                    this.changeVisible(componentUrl, false);\n                    break;\n\n                case 'url':\n                    this.changeVisible(componentFile, false);\n                    this.changeVisible(componentUrl, true);\n                    break;\n            }\n        },\n\n        /**\n         * Change visible\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         */\n        changeVisible: function (filter, visible) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    currentComponent.visible(visible);\n                }\n            );\n        }\n    });\n});\n","Magento_Downloadable/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {FileUploder} Chainable.\n         */\n        addFile: function (file) {\n            var processedFile = this.processFile(file),\n                tmpFile = [],\n                resultFile = {\n                'file': processedFile.file,\n                'name': processedFile.name,\n                'size': processedFile.size,\n                'status': processedFile.status ? processedFile.status : 'new'\n            };\n\n            tmpFile[0] = resultFile;\n\n            this.isMultipleFiles ?\n                this.value.push(tmpFile) :\n                this.value(tmpFile);\n\n            return this;\n        }\n    });\n});\n","Magento_Downloadable/js/components/price-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            linksPurchasedSeparately: '0',\n            useDefaultPrice: false,\n            listens: {\n                linksPurchasedSeparately: 'changeDisabledStatus',\n                useDefaultPrice: 'changeDisabledStatus'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.changeDisabledStatus();\n\n            return this;\n        },\n\n        /**\n         * Disable/enable price field\n         */\n        changeDisabledStatus: function () {\n            if (this.linksPurchasedSeparately === '1') {\n                if (this.useDefaultPrice) {\n                    this.disabled(true);\n                } else {\n                    this.disabled(false);\n                }\n            } else {\n                this.disabled(true);\n            }\n        }\n    });\n});\n","Magento_Cms/js/folder-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.folderTree', {\n        options: {\n            root: 'root',\n            rootName: 'Root',\n            url: '',\n            currentPath: ['root'],\n            tree: {\n                core: {\n                    themes: {\n                        dots: false\n                    },\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    check_callback: true\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                }\n            }\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var options = this.options,\n                treeOptions = $.extend(\n                    true,\n                    {},\n                    options.tree,\n                    {\n                        core: {\n                            data: {\n                                url: options.url,\n                                type: 'POST',\n                                dataType: 'text',\n                                dataFilter: $.proxy(function (data) {\n                                    return this._convertData(JSON.parse(data));\n                                }, this),\n\n                                /**\n                                 * @param {HTMLElement} node\n                                 * @return {Object}\n                                 */\n                                data: function (node) {\n                                    return {\n                                        node: node.id === 'root' ? null : node.id,\n                                        'form_key': window.FORM_KEY\n                                    };\n                                }\n                            }\n                        }\n                    }\n                );\n\n            this.element.jstree(treeOptions)\n                .on('ready.jstree', $.proxy(this.treeLoaded, this))\n                .on('load_node.jstree', $.proxy(this._createRootNode, this));\n        },\n\n        /**\n         * Tree loaded.\n         */\n        treeLoaded: function () {\n            var path = this.options.currentPath,\n                tree = this.element,\n                lastExistentFolderEl,\n\n                /**\n                 * Recursively open folders specified in path array.\n                 */\n                recursiveOpen = function () {\n                    var folderEl = $('[data-id=\"' + path.pop() + '\"]');\n\n                    // if folder doesn't exist, select the last opened folder\n                    if (!folderEl.length) {\n                        tree.jstree('select_node', lastExistentFolderEl);\n\n                        return;\n                    }\n\n                    lastExistentFolderEl = folderEl;\n\n                    if (path.length) {\n                        tree.jstree('open_node', folderEl, recursiveOpen);\n                    } else {\n                        tree.jstree('open_node', folderEl, function () {\n                            tree.jstree('select_node', folderEl);\n                        });\n                    }\n                };\n\n            recursiveOpen();\n        },\n\n        /**\n         * Create tree root node\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _createRootNode: function (event, data) {\n            var rootNode, children;\n\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if (data.node.id === '#') {\n                rootNode = {\n                    id: this.options.root,\n                    text: this.options.rootName,\n                    li_attr: {\n                        'data-id': this.options.root\n                    }\n                };\n                children = data.node.children;\n\n                data.instance.element.jstree().create_node(null, rootNode, 'first', function () {\n                    data.instance.element.jstree().move_node(children, rootNode.id);\n                });\n            }\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n        },\n\n        /**\n         * @param {*} data\n         * @return {*}\n         * @private\n         */\n        _convertData: function (data) {\n            return $.map(data, function (node) {\n\n                return {\n                    id: node.id,\n                    text: node.text,\n                    path: node.path,\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    li_attr: {\n                        'data-id': node.id\n                    },\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    children: node.children\n                };\n            });\n        }\n    });\n\n    return $.mage.folderTree;\n});\n","Magento_GroupedProduct/js/grouped-product-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid'\n], function (_, registry, dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n\n        /**\n         * Set max element position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        setMaxPosition: function (position, elem) {\n\n            if (position || position === 0) {\n                this.checkMaxPosition(position);\n                this.sort(position, elem);\n\n                if (~~position === this.maxPosition && ~~position > this.getDefaultPageBoundary() + 1) {\n                    this.shiftNextPagesPositions(position);\n                }\n            } else {\n                this.maxPosition += 1;\n            }\n        },\n\n        /**\n         * Shift positions for next page elements\n         *\n         * @param {Number} position\n         */\n        shiftNextPagesPositions: function (position) {\n\n            var recordData = this.recordData(),\n                startIndex = ~~this.currentPage() * this.pageSize,\n                offset = position - startIndex + 1,\n                index = startIndex;\n\n            if (~~this.currentPage() === this.pages()) {\n                return false;\n            }\n\n            for (index; index < recordData.length; index++) {\n                recordData[index].position = index + offset;\n            }\n            this.recordData(recordData);\n        },\n\n        /**\n         * Update position for element after position from another page is entered\n         *\n         * @param {Object} data\n         * @param {Object} event\n         */\n        updateGridPosition: function (data, event) {\n            var inputValue = parseInt(event.target.value, 10),\n                recordData = this.recordData(),\n                record,\n                previousValue,\n                updatedRecord;\n\n            record = this.elems().find(function (obj) {\n                return obj.dataScope === data.parentScope;\n            });\n\n            previousValue = this.getCalculatedPosition(record);\n\n            if (isNaN(inputValue) || inputValue < 0 || inputValue === previousValue) {\n                return false;\n            }\n\n            this.elems([]);\n\n            updatedRecord = this.getUpdatedRecordIndex(recordData, record.data().id);\n\n            if (inputValue >= this.recordData().size() - 1) {\n                recordData[updatedRecord].position = this.getGlobalMaxPosition() + 1;\n            } else {\n                recordData.forEach(function (value, index) {\n                    if (~~value.id === ~~record.data().id) {\n                        recordData[index].position = inputValue;\n                    } else if (inputValue > previousValue && index <= inputValue) {\n                        recordData[index].position = index - 1;\n                    } else if (inputValue < previousValue && index >= inputValue) {\n                        recordData[index].position = index + 1;\n                    }\n                });\n            }\n\n            this.reloadGridData(recordData);\n\n        },\n\n        /**\n         * Get updated record index\n         *\n         * @param  {Array} recordData\n         * @param {Number} recordId\n         * @return {Number}\n         */\n        getUpdatedRecordIndex: function (recordData, recordId) {\n            return recordData.map(function (o) {\n                return ~~o.id;\n            }).indexOf(~~recordId);\n        },\n\n        /**\n         *\n         * @param {Array} recordData - to reprocess\n         */\n        reloadGridData: function (recordData) {\n            this.recordData(recordData.sort(function (a, b) {\n                return ~~a.position - ~~b.position;\n            }));\n            this._updateCollection();\n            this.reload();\n        },\n\n        /**\n         * Event handler for \"Send to bottom\" button\n         *\n         * @param {Object} positionObj\n         * @return {Boolean}\n         */\n        sendToBottom: function (positionObj) {\n\n            var objectToUpdate = this.getObjectToUpdate(positionObj),\n                recordData = this.recordData(),\n                updatedRecord;\n\n            if (~~this.currentPage() === this.pages) {\n                objectToUpdate.position = this.maxPosition;\n            } else {\n                this.elems([]);\n                updatedRecord = this.getUpdatedRecordIndex(recordData, objectToUpdate.data().id);\n                recordData[updatedRecord].position = this.getGlobalMaxPosition() + 1;\n                this.reloadGridData(recordData);\n            }\n\n            return false;\n        },\n\n        /**\n         * Event handler for \"Send to top\" button\n         *\n         * @param {Object} positionObj\n         * @return {Boolean}\n         */\n        sendToTop: function (positionObj) {\n            var objectToUpdate = this.getObjectToUpdate(positionObj),\n                recordData = this.recordData(),\n                updatedRecord;\n\n            //isFirst\n            if (~~this.currentPage() === 1) {\n                objectToUpdate.position = 0;\n            } else {\n                this.elems([]);\n                updatedRecord = this.getUpdatedRecordIndex(recordData, objectToUpdate.data().id);\n                recordData.forEach(function (value, index) {\n                    recordData[index].position = index === updatedRecord ? 0 : value.position + 1;\n                });\n                this.reloadGridData(recordData);\n            }\n\n            return false;\n        },\n\n        /**\n         * Get element from grid for update\n         *\n         * @param {Object} object\n         * @return {*}\n         */\n        getObjectToUpdate: function (object) {\n            return this.elems().filter(function (item) {\n                return item.name === object.parentName;\n            })[0];\n        },\n\n        /**\n         * Value function for position input\n         *\n         * @param {Object} data\n         * @return {Number}\n         */\n        getCalculatedPosition: function (data) {\n            return (~~this.currentPage() - 1) * this.pageSize + this.elems().pluck('name').indexOf(data.name);\n        },\n\n        /**\n         * Return Page Boundary\n         *\n         * @return {Number}\n         */\n        getDefaultPageBoundary: function () {\n            return ~~this.currentPage() * this.pageSize - 1;\n        },\n\n        /**\n         * Returns position for last element to be moved after\n         *\n         * @return {Number}\n         */\n        getGlobalMaxPosition: function () {\n            return _.max(this.recordData().map(function (r) {\n                return ~~r.position;\n            }));\n        }\n    });\n});\n","Magento_GroupedProduct/js/grouped-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/adminhtml/grid'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.groupedProduct', {\n        /**\n         * Create widget\n         * @private\n         */\n        _create: function () {\n            this.$grid = this.element.find('[data-role=grouped-product-grid]');\n            this.$grid.sortable({\n                distance: 8,\n                items: '[data-role=row]',\n                tolerance: 'pointer',\n                cancel: ':input',\n                update: $.proxy(function () {\n                    this.element.trigger('resort');\n                }, this)\n            });\n\n            this.productTmpl = mageTemplate('#group-product-template');\n\n            $.each(\n                this.$grid.data('products'),\n                $.proxy(function (index, product) {\n                    this._add(null, product);\n                }, this)\n            );\n\n            this._on({\n                'add': '_add',\n                'resort': '_resort',\n                'click [data-column=actions] [data-role=delete]': '_remove'\n            });\n\n            this._bindDialog();\n            this._updateGridVisibility();\n        },\n\n        /**\n         * Add product to grouped grid\n         * @param {EventObject} event\n         * @param {Object} product\n         * @private\n         */\n        _add: function (event, product) {\n            var tmpl,\n                productExists;\n\n            productExists = this.$grid.find('[data-role=id]')\n                .filter(function (index, element) {\n                    return $(element).val() == product.id; //eslint-disable-line eqeqeq\n                }).length;\n\n            if (!productExists) {\n                tmpl = this.productTmpl({\n                    data: product\n                });\n\n                $(tmpl).appendTo(this.$grid.find('tbody'));\n            }\n        },\n\n        /**\n         * Remove product\n         * @param {EventObject} event\n         * @private\n         */\n        _remove: function (event) {\n            $(event.target).closest('[data-role=row]').remove();\n            this.element.trigger('resort');\n            this._updateGridVisibility();\n        },\n\n        /**\n         * Resort products\n         * @private\n         */\n        _resort: function () {\n            this.element.find('[data-role=position]').each($.proxy(function (index, element) {\n                $(element).val(index + 1);\n            }, this));\n        },\n\n        /**\n         * Create modal for show product\n         *\n         * @private\n         */\n        _bindDialog: function () {\n            var widget = this,\n                selectedProductList = {},\n                popup = $('[data-role=add-product-dialog]'),\n                gridPopup;\n\n            popup.modal({\n                type: 'slide',\n                innerScroll: true,\n                title: $.mage.__('Add Products to Group'),\n                modalClass: 'grouped',\n\n                /** @inheritdoc */\n                open: function () {\n                    $(this).addClass('admin__scope-old'); // ToDo UI: remove with old styles removal\n                },\n                buttons: [{\n                    id: 'grouped-product-dialog-apply-button',\n                    text: $.mage.__('Add Selected Products'),\n                    'class': 'action-primary action-add',\n\n                    /** @inheritdoc */\n                    click: function () {\n                        $.each(selectedProductList, function (index, product) {\n                            widget._add(null, product);\n                        });\n                        widget._resort();\n                        widget._updateGridVisibility();\n                        popup.modal('closeModal');\n                    }\n                }]\n            });\n\n            popup.on('click', '[data-role=row]', function (event) {\n                var target = $(event.target);\n\n                if (!target.is('input')) {\n                    target.closest('[data-role=row]')\n                        .find('[data-column=entity_ids] input')\n                        .prop('checked', function (element, value) {\n                            return !value;\n                        })\n                        .trigger('change');\n                }\n            });\n\n            popup.on(\n                'change',\n                '[data-role=row] [data-column=entity_ids] input',\n                $.proxy(function (event) {\n                    var element = $(event.target),\n                        product = {};\n\n                    if (element.is(':checked')) {\n                        product.id = element.val();\n                        product.qty = 0;\n                        element.closest('[data-role=row]').find('[data-column]').each(function (index, el) {\n                            let text = $(el).text();\n\n                            product[$(el).data('column')] = text.trim();\n                        });\n                        selectedProductList[product.id] = product;\n                    } else {\n                        delete selectedProductList[element.val()];\n                    }\n                }, this)\n            );\n\n            gridPopup = $(this.options.gridPopup).data('gridObject');\n\n            $('[data-role=add-product]').on('click', function (event) {\n                event.preventDefault();\n                popup.modal('openModal');\n                gridPopup.reload();\n                selectedProductList = {};\n            });\n\n            $('#' + gridPopup.containerId).on('gridajaxsettings', function (event, ajaxSettings) {\n                var ids = widget.$grid.find('[data-role=id]').map(function (index, element) {\n                    return $(element).val();\n                }).toArray();\n\n                ajaxSettings.data.filter = $.extend(ajaxSettings.data.filter || {}, {\n                    'entity_ids': ids\n                });\n            }).on('gridajax', function (event, ajaxRequest) {\n                ajaxRequest.done(function () {\n                    popup.find('[data-role=row] [data-column=entity_ids] input').each(function (index, element) {\n                        var $element = $(element);\n\n                        $element.prop('checked', !!selectedProductList[$element.val()]);\n                    });\n                });\n            });\n        },\n\n        /**\n         * Show or hide message\n         * @private\n         */\n        _updateGridVisibility: function () {\n            var showGrid = this.element.find('[data-role=id]').length > 0;\n\n            this.element.find('.grid-container').toggle(showGrid);\n            this.element.find('.no-products-message').toggle(!showGrid);\n        }\n    });\n\n    return $.mage.groupedProduct;\n});\n","Magento_Eav/js/input-types.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    return function (config) {\n        $('select#frontend_input').each(function () {\n            var select = $(this),\n                currentValue = select.find('option:selected').val(),\n                compatibleTypes = config.inputTypes,\n                enabledTypes = [],\n                iterator,\n                warning = $('<label>')\n                    .hide()\n                    .text($.mage.__('These changes affect all related products.'))\n                    .addClass('mage-error')\n                    .attr({\n                        generated: true, for: select.attr('id')\n                    }),\n                hint = $('<p>')\n                    .hide()\n                    .addClass('note')\n                    .attr({\n                        generated: true\n                    }),\n                hints = config.hints,\n\n            /**\n             * Toggle hint about changes types\n             */\n            toggleWarning = function () {\n                if (select.find('option:selected').val() === currentValue) {\n                    warning.hide();\n                } else {\n                    warning.show();\n                }\n            },\n\n            /**\n             * Toggle hint\n             */\n            toggleHint = function () {\n                if (typeof hints[select.find('option:selected').val()] !== 'undefined') {\n                    select.after(hint.show().text(hints[select.find('option:selected').val()]));\n                } else {\n                    hint.hide();\n                }\n            },\n\n            /**\n             * Remove unsupported options\n             */\n            removeOption = function () {\n                if (!~enabledTypes.indexOf($(this).val())) {\n                    $(this).remove();\n                }\n            };\n\n            // find enabled types for switching dor current input type\n            for (iterator = 0; iterator < compatibleTypes.length; iterator++) {\n                if (compatibleTypes[iterator].indexOf(currentValue) >= 0) {\n                    enabledTypes = compatibleTypes[iterator];\n                }\n            }\n\n            // Check current type (allow only compatible types)\n            if (~enabledTypes.indexOf(currentValue)) {\n                // Enable select and keep only available options (all other will be removed)\n                select.prop('disabled', false).find('option').each(removeOption);\n                // Add warning on page and event for show/hide it\n                select.after(warning).on('change', toggleWarning);\n            }\n            //bind hint toggling on change event\n            select.on('change', toggleHint);\n            //show hint for currently selected value\n            toggleHint();\n        });\n    };\n});\n","vimeo/player.min.js":"/*! @vimeo/player v2.16.4 | (c) 2022 Vimeo | MIT License | https://github.com/vimeo/player.js */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):((e=\"undefined\"!=typeof globalThis?globalThis:e||self).Vimeo=e.Vimeo||{},e.Vimeo.Player=t())}(this,function(){\"use strict\";function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,\"value\"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var e=\"undefined\"!=typeof global&&\"[object global]\"==={}.toString.call(global);function i(e,t){return 0===e.indexOf(t.toLowerCase())?e:\"\".concat(t.toLowerCase()).concat(e.substr(0,1).toUpperCase()).concat(e.substr(1))}function l(e){return/^(https?:)?\\/\\/((player|www)\\.)?vimeo\\.com(?=$|\\/)/.test(e)}function u(e){var t=0<arguments.length&&void 0!==e?e:{},n=t.id,e=t.url,t=n||e;if(!t)throw new Error(\"An id or url must be passed, either in an options object or as a data-vimeo-id or data-vimeo-url attribute.\");if(e=t,!isNaN(parseFloat(e))&&isFinite(e)&&Math.floor(e)==e)return\"https://vimeo.com/\".concat(t);if(l(t))return t.replace(\"http:\",\"https:\");if(n)throw new TypeError(\"\u201c\".concat(n,\"\u201d is not a valid video id.\"));throw new TypeError(\"\u201c\".concat(t,\"\u201d is not a vimeo.com url.\"))}var t=void 0!==Array.prototype.indexOf,Player=\"undefined\"!=typeof window&&void 0!==window.postMessage;if(!(e||t&&Player))throw new Error(\"Sorry, the Vimeo Player API is not available in this browser.\");var n,o,a=\"undefined\"!=typeof globalThis?globalThis:\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:{};function c(){if(void 0===this)throw new TypeError(\"Constructor WeakMap requires 'new'\");if(o(this,\"_id\",\"_WeakMap_\"+f()+\".\"+f()),0<arguments.length)throw new TypeError(\"WeakMap iterable is not supported\")}function s(e,t){if(!d(e)||!n.call(e,\"_id\"))throw new TypeError(t+\" method called on incompatible receiver \"+typeof e)}function f(){return Math.random().toString().substring(2)}function d(e){return Object(e)===e}(Player=\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:a).WeakMap||(n=Object.prototype.hasOwnProperty,Player.WeakMap=((o=function(e,t,n){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:n}):e[t]=n})(c.prototype,\"delete\",function(e){if(s(this,\"delete\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)&&(delete e[this._id],!0)}),o(c.prototype,\"get\",function(e){if(s(this,\"get\"),d(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),o(c.prototype,\"has\",function(e){if(s(this,\"has\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),o(c.prototype,\"set\",function(e,t){if(s(this,\"set\"),!d(e))throw new TypeError(\"Invalid value used as weak map key\");var n=e[this._id];return n&&n[0]===e?n[1]=t:o(e,this._id,[e,t]),this}),o(c,\"_polyfill\",!0),c));var h,m=(function(e){var t,n,r;r=function(){var t,n,r,o,i,e=Object.prototype.toString,a=\"undefined\"!=typeof setImmediate?function(e){return setImmediate(e)}:setTimeout;try{Object.defineProperty({},\"x\",{}),t=function(e,t,n,r){return Object.defineProperty(e,t,{value:n,writable:!0,configurable:!1!==r})}}catch(e){t=function(e,t,n){return e[t]=n,e}}function u(e,t){this.fn=e,this.self=t,this.next=void 0}function l(e,t){y.add(e,t),n=n||a(y.drain)}function c(e){var t,n=typeof e;return\"function\"==typeof(t=null!=e&&(\"object\"==n||\"function\"==n)?e.then:t)&&t}function s(){for(var e=0;e<this.chain.length;e++)!function(e,t,n){var r,o;try{!1===t?n.reject(e.msg):(r=!0===t?e.msg:t.call(void 0,e.msg))===n.promise?n.reject(TypeError(\"Promise-chain cycle\")):(o=c(r))?o.call(r,n.resolve,n.reject):n.resolve(r)}catch(e){n.reject(e)}}(this,1===this.state?this.chain[e].success:this.chain[e].failure,this.chain[e]);this.chain.length=0}function f(e){var n,r=this;if(!r.triggered){r.triggered=!0,r.def&&(r=r.def);try{(n=c(e))?l(function(){var t=new m(r);try{n.call(e,function(){f.apply(t,arguments)},function(){d.apply(t,arguments)})}catch(e){d.call(t,e)}}):(r.msg=e,r.state=1,0<r.chain.length&&l(s,r))}catch(e){d.call(new m(r),e)}}}function d(e){var t=this;t.triggered||(t.triggered=!0,(t=t.def?t.def:t).msg=e,t.state=2,0<t.chain.length&&l(s,t))}function h(e,n,r,o){for(var t=0;t<n.length;t++)!function(t){e.resolve(n[t]).then(function(e){r(t,e)},o)}(t)}function m(e){this.def=e,this.triggered=!1}function v(e){this.promise=e,this.state=0,this.triggered=!1,this.chain=[],this.msg=void 0}function p(e){if(\"function\"!=typeof e)throw TypeError(\"Not a function\");if(0!==this.__NPO__)throw TypeError(\"Not a promise\");this.__NPO__=1;var r=new v(this);this.then=function(e,t){var n={success:\"function\"!=typeof e||e,failure:\"function\"==typeof t&&t};return n.promise=new this.constructor(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");n.resolve=e,n.reject=t}),r.chain.push(n),0!==r.state&&l(s,r),n.promise},this.catch=function(e){return this.then(void 0,e)};try{e.call(void 0,function(e){f.call(r,e)},function(e){d.call(r,e)})}catch(e){d.call(r,e)}}var y={add:function(e,t){i=new u(e,t),o?o.next=i:r=i,o=i,i=void 0},drain:function(){var e=r;for(r=o=n=void 0;e;)e.fn.call(e.self),e=e.next}},g=t({},\"constructor\",p,!1);return t(p.prototype=g,\"__NPO__\",0,!1),t(p,\"resolve\",function(n){return n&&\"object\"==typeof n&&1===n.__NPO__?n:new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");e(n)})}),t(p,\"reject\",function(n){return new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");t(n)})}),t(p,\"all\",function(t){var a=this;return\"[object Array]\"!=e.call(t)?a.reject(TypeError(\"Not an array\")):0===t.length?a.resolve([]):new a(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");var r=t.length,o=Array(r),i=0;h(a,t,function(e,t){o[e]=t,++i===r&&n(o)},e)})}),t(p,\"race\",function(t){var r=this;return\"[object Array]\"!=e.call(t)?r.reject(TypeError(\"Not an array\")):new r(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");h(r,t,function(e,t){n(t)},e)})}),p},(n=a)[t=\"Promise\"]=n[t]||r(),e.exports&&(e.exports=n[t])}(h={exports:{}}),h.exports),v=new WeakMap;function p(e,t,n){var r=v.get(e.element)||{};t in r||(r[t]=[]),r[t].push(n),v.set(e.element,r)}function y(e,t){return(v.get(e.element)||{})[t]||[]}function g(e,t,n){var r=v.get(e.element)||{};if(!r[t])return!0;if(!n)return r[t]=[],v.set(e.element,r),!0;n=r[t].indexOf(n);return-1!==n&&r[t].splice(n,1),v.set(e.element,r),r[t]&&0===r[t].length}var w=[\"autopause\",\"autoplay\",\"background\",\"byline\",\"color\",\"controls\",\"dnt\",\"height\",\"id\",\"interactive_params\",\"keyboard\",\"loop\",\"maxheight\",\"maxwidth\",\"muted\",\"playsinline\",\"portrait\",\"responsive\",\"speed\",\"texttrack\",\"title\",\"transparent\",\"url\",\"width\"];function b(r,e){return w.reduce(function(e,t){var n=r.getAttribute(\"data-vimeo-\".concat(t));return!n&&\"\"!==n||(e[t]=\"\"===n?1:n),e},1<arguments.length&&void 0!==e?e:{})}function k(e,t){var n=e.html;if(!t)throw new TypeError(\"An element must be provided\");if(null!==t.getAttribute(\"data-vimeo-initialized\"))return t.querySelector(\"iframe\");e=document.createElement(\"div\");return e.innerHTML=n,t.appendChild(e.firstChild),t.setAttribute(\"data-vimeo-initialized\",\"true\"),t.querySelector(\"iframe\")}function E(i,e,t){var a=1<arguments.length&&void 0!==e?e:{},u=2<arguments.length?t:void 0;return new Promise(function(t,n){if(!l(i))throw new TypeError(\"\u201c\".concat(i,\"\u201d is not a vimeo.com url.\"));var e,r=\"https://vimeo.com/api/oembed.json?url=\".concat(encodeURIComponent(i));for(e in a)a.hasOwnProperty(e)&&(r+=\"&\".concat(e,\"=\").concat(encodeURIComponent(a[e])));var o=new(\"XDomainRequest\"in window?XDomainRequest:XMLHttpRequest);o.open(\"GET\",r,!0),o.onload=function(){if(404!==o.status)if(403!==o.status)try{var e=JSON.parse(o.responseText);if(403===e.domain_status_code)return k(e,u),void n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));t(e)}catch(e){n(e)}else n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));else n(new Error(\"\u201c\".concat(i,\"\u201d was not found.\")))},o.onerror=function(){var e=o.status?\" (\".concat(o.status,\")\"):\"\";n(new Error(\"There was an error fetching the embed code from Vimeo\".concat(e,\".\")))},o.send()})}function T(e){function n(e){\"console\"in window&&console.error&&console.error(\"There was an error creating an embed: \".concat(e))}e=0<arguments.length&&void 0!==e?e:document,e=[].slice.call(e.querySelectorAll(\"[data-vimeo-id], [data-vimeo-url]\"));e.forEach(function(t){try{if(null!==t.getAttribute(\"data-vimeo-defer\"))return;var e=b(t);E(u(e),e,t).then(function(e){return k(e,t)}).catch(n)}catch(e){n(e)}})}function P(e){if(\"string\"==typeof e)try{e=JSON.parse(e)}catch(e){return console.warn(e),{}}return e}function _(e,t,n){e.element.contentWindow&&e.element.contentWindow.postMessage&&(t={method:t},void 0!==n&&(t.value=n),8<=(n=parseFloat(navigator.userAgent.toLowerCase().replace(/^.*msie (\\d+).*$/,\"$1\")))&&n<10&&(t=JSON.stringify(t)),e.element.contentWindow.postMessage(t,e.origin))}function M(n,r){var t,e,o,i,a=[];(r=P(r)).event?(\"error\"===r.event&&y(n,r.data.method).forEach(function(e){var t=new Error(r.data.message);t.name=r.data.name,e.reject(t),g(n,r.data.method,e)}),a=y(n,\"event:\".concat(r.event)),t=r.data):r.method&&(e=n,o=r.method,(i=!((i=y(e,o)).length<1)&&(i=i.shift(),g(e,o,i),i))&&(a.push(i),t=r.value)),a.forEach(function(e){try{if(\"function\"==typeof e)return void e.call(n,t);e.resolve(t)}catch(e){}})}var N,F,x,C=new WeakMap,j=new WeakMap,A={},Player=function(){function Player(i){var e,a=this,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,Player),window.jQuery&&i instanceof jQuery&&(1<i.length&&window.console&&console.warn&&console.warn(\"A jQuery object with multiple elements was passed, using the first element.\"),i=i[0]),\"undefined\"!=typeof document&&\"string\"==typeof i&&(i=document.getElementById(i)),e=i,!Boolean(e&&1===e.nodeType&&\"nodeName\"in e&&e.ownerDocument&&e.ownerDocument.defaultView))throw new TypeError(\"You must pass either a valid element or a valid id.\");if(\"IFRAME\"===i.nodeName||(r=i.querySelector(\"iframe\"))&&(i=r),\"IFRAME\"===i.nodeName&&!l(i.getAttribute(\"src\")||\"\"))throw new Error(\"The player element passed isn\u2019t a Vimeo embed.\");if(C.has(i))return C.get(i);this._window=i.ownerDocument.defaultView,this.element=i,this.origin=\"*\";var n,r=new m(function(r,o){var e;a._onMessage=function(e){if(l(e.origin)&&a.element.contentWindow===e.source){\"*\"===a.origin&&(a.origin=e.origin);var t=P(e.data);if(t&&\"error\"===t.event&&t.data&&\"ready\"===t.data.method){var n=new Error(t.data.message);return n.name=t.data.name,void o(n)}e=t&&\"ready\"===t.event,n=t&&\"ping\"===t.method;if(e||n)return a.element.setAttribute(\"data-ready\",\"true\"),void r();M(a,t)}},a._window.addEventListener(\"message\",a._onMessage),\"IFRAME\"!==a.element.nodeName&&E(u(e=b(i,t)),e,i).then(function(e){var t,n,r=k(e,i);return a.element=r,a._originalElement=i,t=i,n=r,r=v.get(t),v.set(n,r),v.delete(t),C.set(a.element,a),e}).catch(o)});return j.set(this,r),C.set(this.element,this),\"IFRAME\"===this.element.nodeName&&_(this,\"ping\"),A.isEnabled&&(n=function(){return A.exit()},this.fullscreenchangeHandler=function(){(A.isFullscreen?p:g)(a,\"event:exitFullscreen\",n),a.ready().then(function(){_(a,\"fullscreenchange\",A.isFullscreen)})},A.on(\"fullscreenchange\",this.fullscreenchangeHandler)),this}var e,t,n;return e=Player,(t=[{key:\"callMethod\",value:function(n){var r=this,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return new m(function(e,t){return r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n,o)}).catch(t)})}},{key:\"get\",value:function(n){var r=this;return new m(function(e,t){return n=i(n,\"get\"),r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n)}).catch(t)})}},{key:\"set\",value:function(n,r){var o=this;return new m(function(e,t){if(n=i(n,\"set\"),null==r)throw new TypeError(\"There must be a value to set.\");return o.ready().then(function(){p(o,n,{resolve:e,reject:t}),_(o,n,r)}).catch(t)})}},{key:\"on\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(!t)throw new TypeError(\"You must pass a callback function.\");if(\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");0===y(this,\"event:\".concat(e)).length&&this.callMethod(\"addEventListener\",e).catch(function(){}),p(this,\"event:\".concat(e),t)}},{key:\"off\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(t&&\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");g(this,\"event:\".concat(e),t)&&this.callMethod(\"removeEventListener\",e).catch(function(e){})}},{key:\"loadVideo\",value:function(e){return this.callMethod(\"loadVideo\",e)}},{key:\"ready\",value:function(){var e=j.get(this)||new m(function(e,t){t(new Error(\"Unknown player. Probably unloaded.\"))});return m.resolve(e)}},{key:\"addCuePoint\",value:function(e){return this.callMethod(\"addCuePoint\",{time:e,data:1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}})}},{key:\"removeCuePoint\",value:function(e){return this.callMethod(\"removeCuePoint\",e)}},{key:\"enableTextTrack\",value:function(e,t){if(!e)throw new TypeError(\"You must pass a language.\");return this.callMethod(\"enableTextTrack\",{language:e,kind:t})}},{key:\"disableTextTrack\",value:function(){return this.callMethod(\"disableTextTrack\")}},{key:\"pause\",value:function(){return this.callMethod(\"pause\")}},{key:\"play\",value:function(){return this.callMethod(\"play\")}},{key:\"requestFullscreen\",value:function(){return A.isEnabled?A.request(this.element):this.callMethod(\"requestFullscreen\")}},{key:\"exitFullscreen\",value:function(){return A.isEnabled?A.exit():this.callMethod(\"exitFullscreen\")}},{key:\"getFullscreen\",value:function(){return A.isEnabled?m.resolve(A.isFullscreen):this.get(\"fullscreen\")}},{key:\"requestPictureInPicture\",value:function(){return this.callMethod(\"requestPictureInPicture\")}},{key:\"exitPictureInPicture\",value:function(){return this.callMethod(\"exitPictureInPicture\")}},{key:\"getPictureInPicture\",value:function(){return this.get(\"pictureInPicture\")}},{key:\"unload\",value:function(){return this.callMethod(\"unload\")}},{key:\"destroy\",value:function(){var n=this;return new m(function(e){var t;j.delete(n),C.delete(n.element),n._originalElement&&(C.delete(n._originalElement),n._originalElement.removeAttribute(\"data-vimeo-initialized\")),n.element&&\"IFRAME\"===n.element.nodeName&&n.element.parentNode&&(n.element.parentNode.parentNode&&n._originalElement&&n._originalElement!==n.element.parentNode?n.element.parentNode.parentNode.removeChild(n.element.parentNode):n.element.parentNode.removeChild(n.element)),n.element&&\"DIV\"===n.element.nodeName&&n.element.parentNode&&(n.element.removeAttribute(\"data-vimeo-initialized\"),(t=n.element.querySelector(\"iframe\"))&&t.parentNode&&(t.parentNode.parentNode&&n._originalElement&&n._originalElement!==t.parentNode?t.parentNode.parentNode.removeChild(t.parentNode):t.parentNode.removeChild(t))),n._window.removeEventListener(\"message\",n._onMessage),A.isEnabled&&A.off(\"fullscreenchange\",n.fullscreenchangeHandler),e()})}},{key:\"getAutopause\",value:function(){return this.get(\"autopause\")}},{key:\"setAutopause\",value:function(e){return this.set(\"autopause\",e)}},{key:\"getBuffered\",value:function(){return this.get(\"buffered\")}},{key:\"getCameraProps\",value:function(){return this.get(\"cameraProps\")}},{key:\"setCameraProps\",value:function(e){return this.set(\"cameraProps\",e)}},{key:\"getChapters\",value:function(){return this.get(\"chapters\")}},{key:\"getCurrentChapter\",value:function(){return this.get(\"currentChapter\")}},{key:\"getColor\",value:function(){return this.get(\"color\")}},{key:\"setColor\",value:function(e){return this.set(\"color\",e)}},{key:\"getCuePoints\",value:function(){return this.get(\"cuePoints\")}},{key:\"getCurrentTime\",value:function(){return this.get(\"currentTime\")}},{key:\"setCurrentTime\",value:function(e){return this.set(\"currentTime\",e)}},{key:\"getDuration\",value:function(){return this.get(\"duration\")}},{key:\"getEnded\",value:function(){return this.get(\"ended\")}},{key:\"getLoop\",value:function(){return this.get(\"loop\")}},{key:\"setLoop\",value:function(e){return this.set(\"loop\",e)}},{key:\"setMuted\",value:function(e){return this.set(\"muted\",e)}},{key:\"getMuted\",value:function(){return this.get(\"muted\")}},{key:\"getPaused\",value:function(){return this.get(\"paused\")}},{key:\"getPlaybackRate\",value:function(){return this.get(\"playbackRate\")}},{key:\"setPlaybackRate\",value:function(e){return this.set(\"playbackRate\",e)}},{key:\"getPlayed\",value:function(){return this.get(\"played\")}},{key:\"getQualities\",value:function(){return this.get(\"qualities\")}},{key:\"getQuality\",value:function(){return this.get(\"quality\")}},{key:\"setQuality\",value:function(e){return this.set(\"quality\",e)}},{key:\"getSeekable\",value:function(){return this.get(\"seekable\")}},{key:\"getSeeking\",value:function(){return this.get(\"seeking\")}},{key:\"getTextTracks\",value:function(){return this.get(\"textTracks\")}},{key:\"getVideoEmbedCode\",value:function(){return this.get(\"videoEmbedCode\")}},{key:\"getVideoId\",value:function(){return this.get(\"videoId\")}},{key:\"getVideoTitle\",value:function(){return this.get(\"videoTitle\")}},{key:\"getVideoWidth\",value:function(){return this.get(\"videoWidth\")}},{key:\"getVideoHeight\",value:function(){return this.get(\"videoHeight\")}},{key:\"getVideoUrl\",value:function(){return this.get(\"videoUrl\")}},{key:\"getVolume\",value:function(){return this.get(\"volume\")}},{key:\"setVolume\",value:function(e){return this.set(\"volume\",e)}}])&&r(e.prototype,t),n&&r(e,n),Player}();return e||(N=function(){for(var e,t=[[\"requestFullscreen\",\"exitFullscreen\",\"fullscreenElement\",\"fullscreenEnabled\",\"fullscreenchange\",\"fullscreenerror\"],[\"webkitRequestFullscreen\",\"webkitExitFullscreen\",\"webkitFullscreenElement\",\"webkitFullscreenEnabled\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"webkitRequestFullScreen\",\"webkitCancelFullScreen\",\"webkitCurrentFullScreenElement\",\"webkitCancelFullScreen\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"mozRequestFullScreen\",\"mozCancelFullScreen\",\"mozFullScreenElement\",\"mozFullScreenEnabled\",\"mozfullscreenchange\",\"mozfullscreenerror\"],[\"msRequestFullscreen\",\"msExitFullscreen\",\"msFullscreenElement\",\"msFullscreenEnabled\",\"MSFullscreenChange\",\"MSFullscreenError\"]],n=0,r=t.length,o={};n<r;n++)if((e=t[n])&&e[1]in document){for(n=0;n<e.length;n++)o[t[0][n]]=e[n];return o}return!1}(),F={fullscreenchange:N.fullscreenchange,fullscreenerror:N.fullscreenerror},x={request:function(o){return new Promise(function(e,t){function n(){x.off(\"fullscreenchange\",n),e()}x.on(\"fullscreenchange\",n);var r=(o=o||document.documentElement)[N.requestFullscreen]();r instanceof Promise&&r.then(n).catch(t)})},exit:function(){return new Promise(function(t,e){var n,r;x.isFullscreen?(n=function e(){x.off(\"fullscreenchange\",e),t()},x.on(\"fullscreenchange\",n),(r=document[N.exitFullscreen]())instanceof Promise&&r.then(n).catch(e)):t()})},on:function(e,t){e=F[e];e&&document.addEventListener(e,t)},off:function(e,t){e=F[e];e&&document.removeEventListener(e,t)}},Object.defineProperties(x,{isFullscreen:{get:function(){return Boolean(document[N.fullscreenElement])}},element:{enumerable:!0,get:function(){return document[N.fullscreenElement]}},isEnabled:{enumerable:!0,get:function(){return Boolean(document[N.fullscreenEnabled])}}}),A=x,T(),function(e){var r=0<arguments.length&&void 0!==e?e:document;window.VimeoPlayerResizeEmbeds_||(window.VimeoPlayerResizeEmbeds_=!0,window.addEventListener(\"message\",function(e){if(l(e.origin)&&e.data&&\"spacechange\"===e.data.event)for(var t=r.querySelectorAll(\"iframe\"),n=0;n<t.length;n++)if(t[n].contentWindow===e.source){t[n].parentElement.style.paddingBottom=\"\".concat(e.data.data[0].bottom,\"px\");break}}))}()),Player});\n","vimeo/vimeo-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'vimeo'\n], function (Player) {\n    'use strict';\n\n    window.Vimeo = window.Vimeo || {\n        'Player': Player\n    };\n});\n","Magento_SalesRule/js/form/element/manage-coupon-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, uiRegistry, fieldset, async) {\n    'use strict';\n\n    return fieldset.extend({\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Initialize element\n         *\n         * @returns {Abstract} Chainable\n         */\n        initialize: function (elems, position) {\n            var obj = this;\n\n            this._super();\n\n            async.async('#sales-rule-form-tab-coupons', document.getElementById('container'), function (node) {\n                var useAutoGeneration = uiRegistry.get(\n                    'sales_rule_form.sales_rule_form.rule_information.use_auto_generation'\n                );\n\n                useAutoGeneration.on('checked', function () {\n                    obj.enableDisableFields();\n                });\n                obj.enableDisableFields();\n            });\n\n            return this;\n        },\n\n        /*eslint-enable no-unused-vars*/\n        /*eslint-disable lines-around-comment*/\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            /**\n             * \\Magento\\Rule\\Model\\AbstractModel::COUPON_TYPE_AUTO\n             */\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/coupon-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function (_, uiRegistry, select) {\n    'use strict';\n\n    return select.extend({\n\n        /**\n         * Hide fields on coupon tab\n         */\n        onUpdate: function () {\n\n            /* eslint-disable eqeqeq */\n            if (this.value() != this.displayOnlyForCouponType) {\n                uiRegistry.get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation').checked(false);\n            }\n\n            this.enableDisableFields();\n        },\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/apply_to_shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox-toggle-notice'\n], function (Checkbox) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            imports: {\n                toggleDisabled: '${ $.parentName }.simple_action:value'\n            }\n        },\n\n        /**\n         * Toggle element disabled state according to simple action value.\n         *\n         * @param {String} action\n         */\n        toggleDisabled: function (action) {\n            switch (action) {\n                default:\n                    this.disabled(false);\n            }\n\n            if (this.disabled()) {\n                this.checked(false);\n            }\n        }\n    });\n});\n","Magento_Ui/js/block-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/knockout/template/loader',\n    'mage/template'\n], function (ko, $, templateLoader, template) {\n    'use strict';\n\n    var blockLoaderTemplatePath = 'ui/block-loader',\n        blockContentLoadingClass = '_block-content-loading',\n        blockLoader,\n        blockLoaderClass,\n        blockLoaderElement = $.Deferred(),\n        loaderImageHref = $.Deferred();\n\n    templateLoader.loadTemplate(blockLoaderTemplatePath).done(function (blockLoaderTemplate) {\n        loaderImageHref.done(function (loaderHref) {\n            blockLoader = template(blockLoaderTemplate.trim(), {\n                loaderImageHref: loaderHref\n            });\n            blockLoader = $(blockLoader);\n            blockLoaderClass = '.' + blockLoader.attr('class');\n            blockLoaderElement.resolve();\n        });\n    });\n\n    /**\n     * Helper function to check if blockContentLoading class should be applied.\n     * @param {Object} element\n     * @returns {Boolean}\n     */\n    function isLoadingClassRequired(element) {\n        var position = element.css('position');\n\n        if (position === 'absolute' || position === 'fixed') {\n            return false;\n        }\n\n        return true;\n    }\n\n    /**\n     * Add loader to block.\n     * @param {Object} element\n     */\n    function addBlockLoader(element) {\n        element.find(':focus').trigger('blur');\n        element.find('input:disabled, select:disabled').addClass('_disabled');\n        element.find('input, select').prop('disabled', true);\n\n        if (isLoadingClassRequired(element)) {\n            element.addClass(blockContentLoadingClass);\n        }\n        element.append(blockLoader.clone());\n    }\n\n    /**\n     * Remove loader from block.\n     * @param {Object} element\n     */\n    function removeBlockLoader(element) {\n        if (!element.has(blockLoaderClass).length) {\n            return;\n        }\n        element.find(blockLoaderClass).remove();\n        element.find('input:not(\"._disabled\"), select:not(\"._disabled\")').prop('disabled', false);\n        element.find('input:disabled, select:disabled').removeClass('_disabled');\n        element.removeClass(blockContentLoadingClass);\n    }\n\n    return function (loaderHref) {\n        loaderImageHref.resolve(loaderHref);\n        ko.bindingHandlers.blockLoader = {\n            /**\n             * Process loader for block\n             * @param {String} element\n             * @param {Boolean} displayBlockLoader\n             */\n            update: function (element, displayBlockLoader) {\n                element = $(element);\n\n                if (ko.unwrap(displayBlockLoader())) {\n                    blockLoaderElement.done(addBlockLoader(element));\n                } else {\n                    blockLoaderElement.done(removeBlockLoader(element));\n                }\n            }\n        };\n    };\n});\n","Magento_Ui/js/dynamic-rows/dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'mageUtils',\n    'underscore',\n    'uiLayout',\n    'uiCollection',\n    'uiRegistry',\n    'mage/translate',\n    'jquery'\n], function (ko, utils, _, layout, uiCollection, registry, $t, $) {\n    'use strict';\n\n    /**\n     * Checks value type and cast to boolean if needed\n     *\n     * @param {*} value\n     *\n     * @returns {Boolean|*} casted or origin value\n     */\n    function castValue(value) {\n        if (_.isUndefined(value) || value === '' || _.isNull(value)) {\n            return false;\n        }\n\n        return value;\n    }\n\n    /**\n     * Compares arrays.\n     *\n     * @param {Array} base - array as method bases its decision on first argument.\n     * @param {Array} current - second array\n     *\n     * @returns {Boolean} result - is current array equal to base array\n     */\n    function compareArrays(base, current) {\n        var index = 0,\n            length = base.length;\n\n        if (base.length !== current.length) {\n            return false;\n        }\n\n        /*eslint-disable max-depth, eqeqeq, no-use-before-define */\n        for (index; index < length; index++) {\n            if (_.isArray(base[index]) && _.isArray(current[index])) {\n                if (!compareArrays(base[index], current[index])) {\n                    return false;\n                }\n            } else if (typeof base[index] === 'object' && typeof current[index] === 'object') {\n                if (!compareObjects(base[index], current[index])) {\n                    return false;\n                }\n            } else if (castValue(base[index]) != castValue(current[index])) {\n                return false;\n            }\n        }/*eslint-enable max-depth, eqeqeq, no-use-before-define */\n\n        return true;\n    }\n\n    /**\n     * Compares objects. Compares only properties from origin object,\n     * if current object has more properties - they are not considered\n     *\n     * @param {Object} base - first object\n     * @param {Object} current - second object\n     *\n     * @returns {Boolean} result - is current object equal to base object\n     */\n    function compareObjects(base, current) {\n        var prop;\n\n        /*eslint-disable max-depth, eqeqeq*/\n        for (prop in base) {\n            if (_.isArray(base[prop]) && _.isArray(current[prop])) {\n                if (!compareArrays(base[prop], current[prop])) {\n                    return false;\n                }\n            } else if (typeof base[prop] === 'object' && typeof current[prop] === 'object') {\n                if (!compareObjects(base[prop], current[prop])) {\n                    return false;\n                }\n            } else if (castValue(base[prop]) != castValue(current[prop])) {\n                return false;\n            }\n        }/*eslint-enable max-depth, eqeqeq */\n\n        return true;\n    }\n\n    return uiCollection.extend({\n        defaults: {\n            defaultRecord: false,\n            columnsHeader: true,\n            columnsHeaderAfterRender: false,\n            columnsHeaderClasses: '',\n            labels: [],\n            recordTemplate: 'record',\n            collapsibleHeader: false,\n            additionalClasses: {},\n            visible: true,\n            disabled: false,\n            fit: false,\n            addButton: true,\n            addButtonLabel: $t('Add'),\n            recordData: [],\n            maxPosition: 0,\n            deleteProperty: 'delete',\n            identificationProperty: 'record_id',\n            deleteValue: true,\n            showSpinner: true,\n            isDifferedFromDefault: false,\n            defaultState: [],\n            defaultPagesState: {},\n            pagesChanged: {},\n            hasInitialPagesState: {},\n            changed: false,\n            fallbackResetTpl: 'ui/form/element/helper/fallback-reset-link',\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/dynamic-rows/dnd',\n                template: 'ui/dynamic-rows/cells/dnd',\n                recordsProvider: '${ $.name }',\n                enabled: true\n            },\n            templates: {\n                record: {\n                    parent: '${ $.$data.collection.name }',\n                    name: '${ $.$data.index }',\n                    dataScope: '${ $.$data.collection.index }.${ $.name }',\n                    nodeTemplate: '${ $.parent }.${ $.$data.collection.recordTemplate }'\n                }\n            },\n            links: {\n                recordData: '${ $.provider }:${ $.dataScope }.${ $.index }'\n            },\n            listens: {\n                visible: 'setVisible',\n                disabled: 'setDisabled',\n                childTemplate: 'initHeader',\n                recordTemplate: 'onUpdateRecordTemplate',\n                recordData: 'setDifferedFromDefault parsePagesData setRecordDataToCache',\n                currentPage: 'changePage',\n                elems: 'checkSpinner',\n                changed: 'updateTrigger'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }'\n            },\n            pages: 1,\n            pageSize: 20,\n            relatedData: [],\n            currentPage: 1,\n            recordDataCache: [],\n            startIndex: 0\n        },\n\n        /**\n         * Sets record data to cache\n         */\n        setRecordDataToCache: function (data) {\n            this.recordDataCache = data;\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method, set observe variable.\n         * Use parent \"track\" method - wrapper observe array\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this,\n                'processingDeleteRecord',\n                'onChildrenUpdate',\n                'checkDefaultState',\n                'renderColumnsHeader',\n                'deleteHandler',\n                'setDefaultState'\n            );\n\n            this._super()\n                .initChildren()\n                .initDnd()\n                .initDefaultRecord()\n                .setInitialProperty()\n                .setColumnsHeaderListener()\n                .checkSpinner();\n\n            this.on('recordData', this.checkDefaultState);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        bubble: function (event) {\n            if (event === 'deleteRecord' || event === 'update') {\n                return false;\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Inits DND module\n         *\n         * @returns {Object} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            if (this.dnd()) {\n                this.dnd().destroy();\n            }\n            this._super();\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('childTemplate')\n                .observe([\n                    'pages',\n                    'currentPage',\n                    'recordData',\n                    'columnsHeader',\n                    'visible',\n                    'disabled',\n                    'labels',\n                    'showSpinner',\n                    'isDifferedFromDefault',\n                    'changed'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initElement: function (elem) {\n            this._super();\n            elem.on({\n                'deleteRecord': this.deleteHandler,\n                'update': this.onChildrenUpdate,\n                'addChild': this.setDefaultState\n            });\n\n            return this;\n        },\n\n        /**\n         * Handler for deleteRecord event\n         *\n         * @param {Number|String} index - element index\n         * @param {Number|String} id\n         */\n        deleteHandler: function (index, id) {\n            var defaultState;\n\n            this.setDefaultState();\n            defaultState = this.defaultPagesState[this.currentPage()];\n            this.processingDeleteRecord(index, id);\n            this.pagesChanged[this.currentPage()] =\n                !compareArrays(defaultState, this.arrayFilter(this.getChildItems()));\n            this.changed(_.some(this.pagesChanged));\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            if (_.isArray(this.recordData())) {\n                this.recordData.each(function (data, index) {\n                    this.source.set(this.dataScope + '.' + this.index + '.' + index + '.initialize', true);\n                }, this);\n            }\n\n            return this;\n        },\n\n        /**\n         * Handler for update event\n         *\n         * @param {Boolean} state\n         */\n        onChildrenUpdate: function (state) {\n            var changed,\n                dataScope,\n                changedElemDataScope;\n\n            if (state && !this.hasInitialPagesState[this.currentPage()]) {\n                this.setDefaultState();\n                changed = this.getChangedElems(this.elems());\n                dataScope = this.elems()[0].dataScope.split('.');\n                dataScope.splice(dataScope.length - 1, 1);\n                changed.forEach(function (elem) {\n                    changedElemDataScope = elem.dataScope.split('.');\n                    changedElemDataScope.splice(0, dataScope.length);\n                    changedElemDataScope[0] =\n                        (parseInt(changedElemDataScope[0], 10) - this.pageSize * (this.currentPage() - 1)).toString();\n                    this.setValueByPath(\n                        this.defaultPagesState[this.currentPage()],\n                        changedElemDataScope, elem.initialValue\n                    );\n                }, this);\n            }\n\n            if (this.defaultPagesState[this.currentPage()]) {\n                this.setChangedForCurrentPage();\n            }\n        },\n\n        /**\n         * Set default dynamic-rows state or state before changing data\n         *\n         * @param {Array} data - defaultState data\n         */\n        setDefaultState: function (data) {\n            var componentData,\n                childItems;\n\n            if (!this.hasInitialPagesState[this.currentPage()]) {\n                childItems = this.getChildItems();\n                componentData = childItems.length ?\n                    utils.copy(childItems) :\n                    utils.copy(this.getChildItems(this.recordDataCache));\n                componentData.forEach(function (dataObj) {\n                    if (dataObj.hasOwnProperty('initialize')) {\n                        delete dataObj.initialize;\n                    }\n                });\n\n                this.hasInitialPagesState[this.currentPage()] = true;\n                this.defaultPagesState[this.currentPage()] = data ? data : this.arrayFilter(componentData);\n            }\n        },\n\n        /**\n         * Sets value to object by string path\n         *\n         * @param {Object} obj\n         * @param {Array|String} path\n         * @param {*} value\n         */\n        setValueByPath: function (obj, path, value) {\n            var prop;\n\n            if (_.isString(path)) {\n                path = path.split('.');\n            }\n\n            if (path.length - 1) {\n                prop = obj[path[0]];\n                path.splice(0, 1);\n                this.setValueByPath(prop, path, value);\n            } else if (path.length && obj) {\n                obj[path[0]] = value;\n            }\n        },\n\n        /**\n         * Returns elements which changed self state\n         *\n         * @param {Array} array - data array\n         * @param {Array} changed - array with changed elements\n         * @returns {Array} changed - array with changed elements\n         */\n        getChangedElems: function (array, changed) {\n            changed = changed || [];\n\n            array.forEach(function (elem) {\n                if (_.isFunction(elem.elems)) {\n                    this.getChangedElems(elem.elems(), changed);\n                } else if (_.isFunction(elem.hasChanged) && elem.hasChanged()) {\n                    changed.push(elem);\n                }\n            }, this);\n\n            return changed;\n        },\n\n        /**\n         * Checks columnsHeaderAfterRender property,\n         * and set listener on elems if needed\n         *\n         * @returns {Object} Chainable.\n         */\n        setColumnsHeaderListener: function () {\n            if (this.columnsHeaderAfterRender) {\n                this.on('recordData', this.renderColumnsHeader);\n\n                if (_.isArray(this.recordData()) && this.recordData().length) {\n                    this.renderColumnsHeader();\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks whether component's state is default or not\n         */\n        checkDefaultState: function () {\n            var isRecordDataArray = _.isArray(this.recordData()),\n                initialize,\n                hasNotDefaultRecords = isRecordDataArray ? !!this.recordData().filter(function (data) {\n                    return !data.initialize;\n                }).length : false;\n\n            if (!this.hasInitialPagesState[this.currentPage()] && isRecordDataArray && hasNotDefaultRecords) {\n                this.hasInitialPagesState[this.currentPage()] = true;\n                this.defaultPagesState[this.currentPage()] = utils.copy(this.getChildItems().filter(function (data) {\n                    initialize = data.initialize;\n                    delete data.initialize;\n\n                    return initialize;\n                }));\n\n                this.setChangedForCurrentPage();\n            } else if (this.hasInitialPagesState[this.currentPage()]) {\n                this.setChangedForCurrentPage();\n            }\n        },\n\n        /**\n         * Filters out deleted items from array\n         *\n         * @param {Array} data\n         *\n         * @returns {Array} filtered array\n         */\n        arrayFilter: function (data) {\n            var prop;\n\n            /*eslint-disable no-loop-func*/\n            data.forEach(function (elem) {\n                for (prop in elem) {\n                    if (_.isArray(elem[prop])) {\n                        elem[prop] = _.filter(elem[prop], function (elemProp) {\n                            return elemProp[this.deleteProperty] !== this.deleteValue;\n                        }, this);\n\n                        elem[prop].forEach(function (elemProp) {\n                            if (_.isArray(elemProp)) {\n                                elem[prop] = this.arrayFilter(elemProp);\n                            }\n                        }, this);\n                    }\n                }\n            }, this);\n\n            /*eslint-enable no-loop-func*/\n\n            return data;\n        },\n\n        /**\n         * Triggers update event\n         *\n         * @param {Boolean} val\n         */\n        updateTrigger: function (val) {\n            this.trigger('update', val);\n        },\n\n        /**\n         * Returns component state\n         */\n        hasChanged: function () {\n            return this.changed();\n        },\n\n        /**\n         * Render column header\n         */\n        renderColumnsHeader: function () {\n            this.recordData().length ? this.columnsHeader(true) : this.columnsHeader(false);\n        },\n\n        /**\n         * Init default record\n         *\n         * @returns Chainable.\n         */\n        initDefaultRecord: function () {\n            if (this.defaultRecord && !this.recordData().length) {\n                this.addChild();\n            }\n\n            return this;\n        },\n\n        /**\n         * Create header template\n         *\n         * @param {Object} prop - instance obj\n         *\n         * @returns {Object} Chainable.\n         */\n        createHeaderTemplate: function (prop) {\n            var visible = prop.visible !== false,\n                disabled = _.isUndefined(prop.disabled) ? this.disabled() : prop.disabled;\n\n            return {\n                visible: ko.observable(visible),\n                disabled: ko.observable(disabled)\n            };\n        },\n\n        /**\n         * Init header elements\n         */\n        initHeader: function () {\n            var labels = [],\n                data;\n\n            if (!this.labels().length) {\n                _.each(this.childTemplate.children, function (cell) {\n                    data = this.createHeaderTemplate(cell.config);\n                    cell.config.labelVisible = false;\n                    _.extend(data, {\n                        defaultLabelVisible: data.visible(),\n                        label: cell.config.label,\n                        name: cell.name,\n                        required: !!cell.config.validation,\n                        columnsHeaderClasses: cell.config.columnsHeaderClasses,\n                        sortOrder: cell.config.sortOrder\n                    });\n                    labels.push(data);\n                }, this);\n                this.labels(_.sortBy(labels, 'sortOrder'));\n            }\n        },\n\n        /**\n         * Set max element position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        setMaxPosition: function (position, elem) {\n            if (position || position === 0) {\n                this.checkMaxPosition(position);\n                this.sort(position, elem);\n            } else {\n                this.maxPosition += 1;\n            }\n        },\n\n        /**\n         * Sort element by position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        sort: function (position, elem) {\n            var that = this,\n                sorted,\n                updatedCollection;\n\n            if (this.elems().filter(function (el) {\n                    return el.position || el.position === 0;\n                }).length !== this.getChildItems().length) {\n\n                return false;\n            }\n\n            if (!elem.containers.length) {\n                registry.get(elem.name, function () {\n                    that.sort(position, elem);\n                });\n\n                return false;\n            }\n\n            sorted = this.elems().sort(function (propOne, propTwo) {\n                return ~~propOne.position - ~~propTwo.position;\n            });\n\n            updatedCollection = this.updatePosition(sorted, position, elem.name);\n            this.elems(updatedCollection);\n        },\n\n        /**\n         * Checking loader visibility\n         *\n         * @param {Array} elems\n         */\n        checkSpinner: function (elems) {\n            this.showSpinner(!(!this.recordData().length || elems && elems.length === this.getChildItems().length));\n        },\n\n        /**\n         * Filtering data and calculates the quantity of pages\n         *\n         * @param {Array} data\n         */\n        parsePagesData: function (data) {\n            this.relatedData = this.deleteProperty ?\n                _.filter(data, function (elem) {\n                    return elem && elem[this.deleteProperty] !== this.deleteValue;\n                }, this) : data;\n\n            this._updatePagesQuantity();\n        },\n\n        /**\n         * Reinit record data in order to remove deleted values\n         *\n         * @return void\n         */\n        reinitRecordData: function () {\n            this.recordData(\n                _.filter(this.recordData(), function (elem) {\n                    return elem && elem[this.deleteProperty] !== this.deleteValue;\n                }, this)\n            );\n        },\n\n        /**\n         * Get items to rendering on current page\n         *\n         * @returns {Array} data\n         */\n        getChildItems: function (data, page) {\n            var dataRecord = data || this.relatedData,\n                startIndex;\n\n            this.startIndex = (~~this.currentPage() - 1) * this.pageSize;\n\n            startIndex = page || this.startIndex;\n\n            return dataRecord.slice(startIndex, this.startIndex + parseInt(this.pageSize, 10));\n        },\n\n        /**\n         * Get record count with filtered delete property.\n         *\n         * @returns {Number} count\n         */\n        getRecordCount: function () {\n            return _.filter(this.recordData(), function (record) {\n                return record && record[this.deleteProperty] !== this.deleteValue;\n            }, this).length;\n        },\n\n        /**\n         * Get number of columns\n         *\n         * @returns {Number} columns\n         */\n        getColumnsCount: function () {\n            return this.labels().length + (this.dndConfig.enabled ? 1 : 0);\n        },\n\n        /**\n         * Processing pages before addChild\n         *\n         * @param {Object} ctx - element context\n         * @param {Number|String} index - element index\n         * @param {Number|String} prop - additional property to element\n         */\n        processingAddChild: function (ctx, index, prop) {\n            this.bubble('addChild', false);\n\n            if (this.relatedData.length && this.relatedData.length % this.pageSize === 0) {\n                this.pages(this.pages() + 1);\n                this.nextPage();\n            } else if (~~this.currentPage() !== this.pages()) {\n                this.currentPage(this.pages());\n            }\n\n            this.addChild(ctx, index, prop);\n        },\n\n        /**\n         * Processing pages before deleteRecord\n         *\n         * @param {Number|String} index - element index\n         * @param {Number|String} recordId\n         */\n        processingDeleteRecord: function (index, recordId) {\n            this.deleteRecord(index, recordId);\n        },\n\n        /**\n         * Change page\n         *\n         * @param {Number} page - current page\n         */\n        changePage: function (page) {\n            this.clear();\n\n            if (page === 1 && !this.recordData().length) {\n                return false;\n            }\n\n            if (~~page > this.pages()) {\n                this.currentPage(this.pages());\n\n                return false;\n            } else if (~~page < 1) {\n                this.currentPage(1);\n\n                return false;\n            }\n\n            this.initChildren();\n\n            return true;\n        },\n\n        /**\n         * Check page\n         *\n         * @returns {Boolean} is page first or not\n         */\n        isFirst: function () {\n            return this.currentPage() === 1;\n        },\n\n        /**\n         * Check page\n         *\n         * @returns {Boolean} is page last or not\n         */\n        isLast: function () {\n            return this.currentPage() === this.pages();\n        },\n\n        /**\n         * Change page to next\n         */\n        nextPage: function () {\n            this.currentPage(this.currentPage() + 1);\n        },\n\n        /**\n         * Change page to previous\n         */\n        previousPage: function () {\n            this.currentPage(this.currentPage() - 1);\n        },\n\n        /**\n         * Check dependency and set position to elements\n         *\n         * @param {Array} collection - elems\n         * @param {Number} position - current position\n         * @param {String} elemName - element name\n         *\n         * @returns {Array} collection\n         */\n        updatePosition: function (collection, position, elemName) {\n            var curPos,\n                parsePosition = ~~position,\n                result = _.filter(collection, function (record) {\n                    return ~~record.position === parsePosition;\n                });\n\n            if (result[1]) {\n                curPos = parsePosition + 1;\n                result[0].name === elemName ? result[1].position = curPos : result[0].position = curPos;\n                this.updatePosition(collection, curPos);\n            }\n\n            return collection;\n        },\n\n        /**\n         * Check max elements position and set if max\n         *\n         * @param {Number} position - current position\n         */\n        checkMaxPosition: function (position) {\n            var max = 0,\n                pos;\n\n            this.recordData.each(function (record) {\n                pos = ~~record.position;\n                pos > max ? max = pos : false;\n            });\n\n            max < position ? max = position : false;\n            this.maxPosition = max;\n        },\n\n        /**\n         * Remove and set new max position\n         */\n        removeMaxPosition: function () {\n            this.maxPosition = 0;\n            this.elems.each(function (record) {\n                this.maxPosition < record.position ? this.maxPosition = ~~record.position : false;\n            }, this);\n        },\n\n        /**\n         * Update record template and rerender elems\n         *\n         * @param {String} recordName - record name\n         */\n        onUpdateRecordTemplate: function (recordName) {\n            if (recordName) {\n                this.recordTemplate = recordName;\n                this.reload();\n            }\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         *\n         */\n        deleteRecord: function (index, recordId) {\n            var recordInstance,\n                lastRecord,\n                recordsData,\n                lastRecordIndex;\n\n            if (this.deleteProperty) {\n                recordsData = this.recordData();\n                recordInstance = _.find(this.elems(), function (elem) {\n                    return elem.index === index;\n                });\n                recordInstance.destroy();\n                this.elems([]);\n                this._updateCollection();\n                this.removeMaxPosition();\n                recordsData[recordInstance.index][this.deleteProperty] = this.deleteValue;\n                this.recordData(recordsData);\n                this.reinitRecordData();\n                this.reload();\n            } else {\n                this.update = true;\n\n                if (~~this.currentPage() === this.pages()) {\n                    lastRecordIndex = this.startIndex + this.getChildItems().length - 1;\n                    lastRecord =\n                        _.findWhere(this.elems(), {\n                            index: lastRecordIndex\n                        }) ||\n                        _.findWhere(this.elems(), {\n                            index: lastRecordIndex.toString()\n                        });\n\n                    lastRecord.destroy();\n                }\n\n                this.removeMaxPosition();\n                recordsData = this._getDataByProp(recordId);\n                this._updateData(recordsData);\n                this.update = false;\n            }\n\n            this._reducePages();\n            this._sort();\n        },\n\n        /**\n         * Update number of pages.\n         *\n         * @private\n         * @return void\n         */\n        _updatePagesQuantity: function () {\n            var pages = Math.ceil(this.relatedData.length / this.pageSize) || 1;\n\n            this.pages(pages);\n        },\n\n        /**\n         * Reduce the number of pages\n         *\n         * @private\n         * @return void\n         */\n        _reducePages: function () {\n            if (this.pages() < ~~this.currentPage()) {\n                this.currentPage(this.pages());\n            }\n        },\n\n        /**\n         * Get data object by some property\n         *\n         * @param {Number} id - element id\n         * @param {String} prop - property\n         */\n        _getDataByProp: function (id, prop) {\n            prop = prop || this.identificationProperty;\n\n            return _.reject(this.getChildItems(), function (recordData) {\n                return recordData[prop].toString() === id.toString();\n            }, this);\n        },\n\n        /**\n         * Sort elems by position property\n         */\n        _sort: function () {\n            this.elems(this.elems().sort(function (propOne, propTwo) {\n                return ~~propOne.position - ~~propTwo.position;\n            }));\n        },\n\n        /**\n         * Set new data to dataSource,\n         * delete element\n         *\n         * @param {Array} data - record data\n         */\n        _updateData: function (data) {\n            var elems = _.clone(this.elems()),\n                path,\n                dataArr;\n\n            dataArr = this.recordData.splice(this.startIndex, this.recordData().length - this.startIndex);\n            dataArr.splice(0, this.pageSize);\n            elems = _.sortBy(this.elems(), function (elem) {\n                return ~~elem.index;\n            });\n\n            data.concat(dataArr).forEach(function (rec, idx) {\n                if (elems[idx]) {\n                    elems[idx].recordId = rec[this.identificationProperty];\n                }\n\n                if (!rec.position) {\n                    rec.position = this.maxPosition;\n                    this.setMaxPosition();\n                }\n\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + idx);\n                this.source.set(path, rec);\n            }, this);\n\n            this.elems(elems);\n        },\n\n        /**\n         * Rerender dynamic-rows elems\n         */\n        reload: function () {\n            this.clear();\n            this.initChildren(false, true);\n            this._updatePagesQuantity();\n\n            /* After change page size need to check existing current page */\n            this._reducePages();\n        },\n\n        /**\n         * Update page size based on select change event.\n         * The value needs to be retrieved from select as ko value handler is executed after the event handler.\n         *\n         * @param {Object} component\n         * @param {jQuery.Event} event\n         */\n        updatePageSize: function (component, event) {\n            this.pageSize = $(event.target).val();\n            this.reload();\n        },\n\n        /**\n         * Destroy all dynamic-rows elems\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            this.destroyChildren();\n\n            return this;\n        },\n\n        /**\n         * Reset data to initial value.\n         * Call method reset on child elements.\n         */\n        reset: function () {\n            var elems = this.elems();\n\n            _.each(elems, function (elem) {\n                if (_.isFunction(elem.reset)) {\n                    elem.reset();\n                }\n            });\n        },\n\n        /**\n         * Set classes\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} Classes\n         */\n        setClasses: function (data) {\n            var additional;\n\n            if (_.isString(data.additionalClasses)) {\n                additional = data.additionalClasses.split(' ');\n                data.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    data.additionalClasses[name] = true;\n                });\n            }\n\n            if (!data.additionalClasses) {\n                data.additionalClasses = {};\n            }\n\n            _.extend(data.additionalClasses, {\n                '_fit': data.fit,\n                '_required': data.required,\n                '_error': data.error,\n                '_empty': !this.elems().length,\n                '_no-header': this.columnsHeaderAfterRender || this.collapsibleHeader\n            });\n\n            return data.additionalClasses;\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            this.showSpinner(true);\n            this.getChildItems().forEach(function (data, index) {\n                this.addChild(data, this.startIndex + index);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Set visibility to dynamic-rows child\n         *\n         * @param {Boolean} state\n         */\n        setVisible: function (state) {\n            this.elems.each(function (record) {\n                record.setVisible(state);\n            }, this);\n        },\n\n        /**\n         * Set disabled property to dynamic-rows child\n         *\n         * @param {Boolean} state\n         */\n        setDisabled: function (state) {\n            this.elems.each(function (record) {\n                record.setDisabled(state);\n            }, this);\n        },\n\n        /**\n         * Set visibility to column\n         *\n         * @param {Number} index - column index\n         * @param {Boolean} state\n         */\n        setVisibilityColumn: function (index, state) {\n            this.elems.each(function (record) {\n                record.setVisibilityColumn(index, state);\n            }, this);\n        },\n\n        /**\n         * Set disabled property to column\n         *\n         * @param {Number} index - column index\n         * @param {Boolean} state\n         */\n        setDisabledColumn: function (index, state) {\n            this.elems.each(function (record) {\n                record.setDisabledColumn(index, state);\n            }, this);\n        },\n\n        /**\n         * Add child components\n         *\n         * @param {Object} data - component data\n         * @param {Number} index - record(row) index\n         * @param {Number|String} prop - custom identify property\n         *\n         * @returns {Object} Chainable.\n         */\n        addChild: function (data, index, prop) {\n            var template = this.templates.record,\n                child;\n\n            index = index || _.isNumber(index) ? index : this.recordData().length;\n            prop = prop || _.isNumber(prop) ? prop : index;\n\n            _.extend(this.templates.record, {\n                recordId: prop\n            });\n\n            child = utils.template(template, {\n                collection: this,\n                index: index\n            });\n\n            layout([child]);\n\n            return this;\n        },\n\n        /**\n         * Restore value to default\n         */\n        restoreToDefault: function () {\n            this.recordData(utils.copy(this.default));\n            this.reload();\n        },\n\n        /**\n         * Update whether value differs from default value\n         */\n        setDifferedFromDefault: function () {\n            var recordData;\n\n            if (this.default) {\n                recordData = utils.copy(this.recordData());\n\n                Array.isArray(recordData) && recordData.forEach(function (item) {\n                    delete item['record_id'];\n                });\n\n                this.isDifferedFromDefault(!_.isEqual(recordData, this.default));\n            }\n        },\n\n        /**\n         * Set the changed property if the current page is different\n         * than the default state\n         *\n         * @return void\n         */\n        setChangedForCurrentPage: function () {\n            this.pagesChanged[this.currentPage()] =\n                !compareArrays(this.defaultPagesState[this.currentPage()], this.arrayFilter(this.getChildItems()));\n            this.changed(_.some(this.pagesChanged));\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/dnd.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiElement',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (ko, $, _, Element) {\n    'use strict';\n\n    var transformProp;\n\n    /**\n     * Get element context\n     */\n    function getContext(elem) {\n        return ko.contextFor(elem);\n    }\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.createElement('div').style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform !== 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] !== 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    return Element.extend({\n        defaults: {\n            separatorsClass: {\n                top: '_dragover-top',\n                bottom: '_dragover-bottom'\n            },\n            step: 'auto',\n            tableClass: 'table.admin__dynamic-rows',\n            recordsCache: [],\n            draggableElement: {},\n            draggableElementClass: '_dragged',\n            elemPositions: [],\n            listens: {\n                '${ $.recordsProvider }:elems': 'setCacheRecords'\n            },\n            modules: {\n                parentComponent: '${ $.recordsProvider }'\n            }\n        },\n\n        /**\n         * Initialize component\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'mousemoveHandler',\n                'mouseupHandler'\n            );\n\n            this._super()\n                .body = $('body');\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'recordsCache'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init listens to start drag\n         *\n         * @param {Object} elem - DOM element\n         * @param {Object} data - element data\n         */\n        initListeners: function (elem, data) {\n            $(elem).on('mousedown touchstart', this.mousedownHandler.bind(this, data, elem));\n        },\n\n        /**\n         * Mouse down handler\n         *\n         * @param {Object} data - element data\n         * @param {Object} elem - element\n         * @param {Object} event - key down event\n         */\n        mousedownHandler: function (data, elem, event) {\n            var recordNode = this.getRecordNode(elem),\n                originRecord = $(elem).parents('tr').eq(0),\n                drEl = this.draggableElement,\n                $table = $(elem).parents('table').eq(0),\n                $tableWrapper = $table.parent(),\n                outerHight =\n                    $table.children('thead').outerHeight() === undefined ? 0 : $table.children('thead').outerHeight();\n\n            this.disableScroll();\n            $(recordNode).addClass(this.draggableElementClass);\n            $(originRecord).addClass(this.draggableElementClass);\n            this.step = this.step === 'auto' ? originRecord.height() / 2 : this.step;\n            drEl.originRow = originRecord;\n            drEl.instance = recordNode = this.processingStyles(recordNode, elem);\n            drEl.instanceCtx = this.getRecord(originRecord[0]);\n            drEl.eventMousedownY = this.getPageY(event);\n            drEl.minYpos =\n                $table.offset().top - originRecord.offset().top + outerHight;\n            drEl.maxYpos = drEl.minYpos + $table.children('tbody').outerHeight() - originRecord.outerHeight();\n            $tableWrapper.append(recordNode);\n            this.body.on('mousemove touchmove', this.mousemoveHandler);\n            this.body.on('mouseup touchend', this.mouseupHandler);\n        },\n\n        /**\n         * Mouse move handler\n         *\n         * @param {Object} event - mouse move event\n         */\n        mousemoveHandler: function (event) {\n            var depEl = this.draggableElement,\n                pageY = this.getPageY(event),\n                positionY = pageY - depEl.eventMousedownY,\n                processingPositionY = positionY + 'px',\n                processingMaxYpos = depEl.maxYpos + 'px',\n                processingMinYpos = depEl.minYpos + 'px',\n                depElement = this.getDepElement(depEl.instance, positionY, depEl.originRow);\n\n            if (depElement) {\n                depEl.depElement ? depEl.depElement.elem.removeClass(depEl.depElement.className) : false;\n                depEl.depElement = depElement;\n                depEl.depElement.insert !== 'none' ? depEl.depElement.elem.addClass(depElement.className) : false;\n            } else if (depEl.depElement && depEl.depElement.insert !== 'none') {\n                depEl.depElement.elem.removeClass(depEl.depElement.className);\n                depEl.depElement.insert = 'none';\n            }\n\n            if (positionY > depEl.minYpos && positionY < depEl.maxYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingPositionY + ')';\n            } else if (positionY < depEl.minYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingMinYpos + ')';\n            } else if (positionY >= depEl.maxYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingMaxYpos + ')';\n            }\n        },\n\n        /**\n         * Mouse up handler\n         */\n        mouseupHandler: function (event) {\n            var depElementCtx,\n                drEl = this.draggableElement,\n                pageY = this.getPageY(event),\n                positionY = pageY - drEl.eventMousedownY;\n\n            this.enableScroll();\n            drEl.depElement = this.getDepElement(drEl.instance, positionY, this.draggableElement.originRow);\n\n            drEl.instance.remove();\n\n            if (drEl.depElement) {\n                depElementCtx = this.getRecord(drEl.depElement.elem[0]);\n                drEl.depElement.elem.removeClass(drEl.depElement.className);\n\n                if (drEl.depElement.insert !== 'none') {\n                    this.setPosition(drEl.depElement.elem, depElementCtx, drEl);\n                }\n            }\n\n            drEl.originRow.removeClass(this.draggableElementClass);\n\n            this.body.off('mousemove touchmove', this.mousemoveHandler);\n            this.body.off('mouseup touchend', this.mouseupHandler);\n\n            this.draggableElement = {};\n        },\n\n        /**\n         * Set position to element\n         *\n         * @param {Object} depElem - dep element\n         * @param {Object} depElementCtx - dep element context\n         * @param {Object} dragData - data draggable element\n         */\n        setPosition: function (depElem, depElementCtx, dragData) {\n            var depElemPosition = ~~depElementCtx.position;\n\n            if (dragData.depElement.insert === 'after') {\n                dragData.instanceCtx.position = depElemPosition + 1;\n            } else if (dragData.depElement.insert === 'before') {\n                dragData.instanceCtx.position = depElemPosition;\n            }\n        },\n\n        /**\n         * Get dependency element\n         *\n         * @param {Object} curInstance - current element instance\n         * @param {Number} position\n         * @param {Object} row\n         */\n        getDepElement: function (curInstance, position, row) {\n            var tableSelector = this.tableClass + ' tr',\n                $table = $(row).parents('table').eq(0),\n                $curInstance = $(curInstance),\n                recordsCollection = $table.find('table').length ?\n                    $table.find('tbody > tr').filter(function (index, elem) {\n                        return !$(elem).parents(tableSelector).length;\n                    }) :\n                    $table.find('tbody > tr'),\n                curInstancePositionTop = $curInstance.position().top,\n                curInstancePositionBottom = curInstancePositionTop + $curInstance.height();\n\n            if (position < 0) {\n                return this._getDepElement(recordsCollection, 'before', curInstancePositionTop);\n            } else if (position > 0) {\n                return this._getDepElement(recordsCollection, 'after', curInstancePositionBottom);\n            }\n        },\n\n        /**\n         * Get dependency element private\n         *\n         * @param {Array} collection - record collection\n         * @param {String} position - position to add\n         * @param {Number} dragPosition - position drag element\n         */\n        _getDepElement: function (collection, position, dragPosition) {\n            var rec,\n                rangeEnd,\n                rangeStart,\n                result,\n                className,\n                i = 0,\n                length = collection.length;\n\n            for (i; i < length; i++) {\n                rec = collection.eq(i);\n\n                if (position === 'before') {\n                    rangeStart = collection.eq(i).position().top - this.step;\n                    rangeEnd = rangeStart + this.step * 2;\n                    className = this.separatorsClass.top;\n                } else if (position === 'after') {\n                    rangeEnd = rec.position().top + rec.height() + this.step;\n                    rangeStart = rangeEnd - this.step * 2;\n                    className = this.separatorsClass.bottom;\n                }\n\n                if (dragPosition > rangeStart && dragPosition < rangeEnd) {\n                    result = {\n                        elem: rec,\n                        insert: rec[0] === this.draggableElement.originRow[0] ? 'none' : position,\n                        className: className\n                    };\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Set default position of draggable element\n         *\n         * @param {Object} elem - current element instance\n         * @param {Object} data - current element data\n         */\n        _setDefaultPosition: function (elem, data) {\n            var originRecord = $(elem).parents('tr').eq(0),\n                position = originRecord.position();\n\n            ++position.top;\n            $(data).css(position);\n        },\n\n        /**\n         * Set records to cache\n         *\n         * @param {Object} records - record instance\n         */\n        setCacheRecords: function (records) {\n            this.recordsCache(records);\n        },\n\n        /**\n         * Set styles to draggable element\n         *\n         * @param {Object} data - data\n         * @param {Object} elem - elem instance\n         * @returns {Object} instance data.\n         */\n        processingStyles: function (data, elem) {\n            var table = $(elem).parents('table').eq(0),\n                columns = table.find('th'),\n                recordColumns = $(data).find('td');\n\n            this._setDefaultPosition(elem, $(data));\n            this._setColumnsWidth(columns, recordColumns);\n            this._setTableWidth(table, $(data));\n\n            return data;\n        },\n\n        /**\n         * Set table width.\n         *\n         * @param {Object} originalTable - original record instance\n         * @param {Object} recordTable - draggable record instance\n         */\n        _setTableWidth: function (originalTable, recordTable) {\n            recordTable.outerWidth(originalTable.outerWidth());\n        },\n\n        /**\n         * Set columns width.\n         *\n         * @param {Object} originColumns - original record instance\n         * @param {Object} recordColumns - draggable record instance\n         */\n        _setColumnsWidth: function (originColumns, recordColumns) {\n            var i = 0,\n                length = originColumns.length;\n\n            for (i; i < length; i++) {\n                recordColumns.eq(i).outerWidth(originColumns.eq(i).outerWidth());\n            }\n        },\n\n        /**\n         * Get copy original record\n         *\n         * @param {Object} record - original record instance\n         * @returns {Object} draggable record instance\n         */\n        getRecordNode: function (record) {\n            var $record = $(record),\n                table = $record.parents('table')[0].cloneNode(true),\n                $table = $(table);\n\n            $table.find('tr').remove();\n            $table.append($record.parents('tr')[0].cloneNode(true));\n\n            return table;\n        },\n\n        /**\n         * Get record context by element\n         *\n         * @param {Object} elem - original element\n         * @returns {Object} draggable record context\n         */\n        getRecord: function (elem) {\n            var ctx = getContext(elem),\n                index = _.isFunction(ctx.$index) ? ctx.$index() : ctx.$index;\n\n            return this.recordsCache()[index];\n        },\n\n        /**\n         * Get correct page Y\n         *\n         * @param {Object} event - current event\n         * @returns {integer}\n         */\n        getPageY: function (event) {\n            var pageY;\n\n            if (event.type.indexOf('touch') >= 0) {\n                if (event.originalEvent.touches[0]) {\n                    pageY = event.originalEvent.touches[0].pageY;\n                } else {\n                    pageY = event.originalEvent.changedTouches[0].pageY;\n                }\n            } else {\n                pageY = event.pageY;\n            }\n\n            return pageY;\n        },\n\n        /**\n         * Disable page scrolling\n         */\n        disableScroll: function () {\n            document.body.addEventListener('touchmove', this.preventDefault, {\n                passive: false\n            });\n        },\n\n        /**\n         * Enable page scrolling\n         */\n        enableScroll: function () {\n            document.body.removeEventListener('touchmove', this.preventDefault, {\n                passive: false\n            });\n        },\n\n        /**\n         * Prevent default function\n         *\n         * @param {Object} event - event object\n         */\n        preventDefault: function (event) {\n            event.preventDefault();\n        }\n\n    });\n});\n","Magento_Ui/js/dynamic-rows/record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection',\n    'uiRegistry'\n], function (_, uiCollection, registry) {\n    'use strict';\n\n    return uiCollection.extend({\n        defaults: {\n            visible: true,\n            disabled: true,\n            headerLabel: '',\n            label: '',\n            positionProvider: 'position',\n            imports: {\n                data: '${ $.provider }:${ $.dataScope }'\n            },\n            listens: {\n                position: 'initPosition',\n                elems: 'setColumnVisibleListener'\n            },\n            links: {\n                position: '${ $.name }.${ $.positionProvider }:value'\n            },\n            exports: {\n                recordId: '${ $.provider }:${ $.dataScope }.record_id'\n            },\n            modules: {\n                parentComponent: '${ $.parentName }'\n            }\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method, set observe variable.\n         * Use parent \"track\" method - wrapper observe array\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            registry.async(this.name + '.' + this.positionProvider)(function (component) {\n\n                /**\n                 * Overwrite hasChanged method\n                 *\n                 * @returns {Boolean}\n                 */\n                component.hasChanged = function () {\n\n                    /* eslint-disable eqeqeq */\n                    return this.value().toString() != this.initialValue.toString();\n\n                    /* eslint-enable eqeqeq */\n                };\n\n                if (!component.initialValue) {\n                    component.initialValue = self.parentComponent().maxPosition;\n                    component.bubble('update', component.hasChanged());\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Init config\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.label = this.label || this.headerLabel;\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('position')\n                .observe([\n                    'visible',\n                    'disabled',\n                    'data',\n                    'label'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init element position\n         *\n         * @param {Number} position - element position\n         */\n        initPosition: function (position) {\n            var pos = parseInt(position, 10);\n\n            this.parentComponent().setMaxPosition(pos, this);\n\n            if (!pos && pos !== 0) {\n                this.position = this.parentComponent().maxPosition;\n            }\n        },\n\n        /**\n         * Set column visibility listener\n         */\n        setColumnVisibleListener: function () {\n            var elem = _.find(this.elems(), function (curElem) {\n                return !curElem.hasOwnProperty('visibleListener');\n            });\n\n            if (!elem) {\n                return;\n            }\n\n            this.childVisibleListener(elem);\n\n            if (!elem.visibleListener) {\n                elem.on('visible', this.childVisibleListener.bind(this, elem));\n            }\n\n            elem.visibleListener = true;\n        },\n\n        /**\n         * Child visibility listener\n         *\n         * @param {Object} data\n         */\n        childVisibleListener: function (data) {\n            this.setVisibilityColumn(data.index, data.visible());\n        },\n\n        /**\n         * Reset data to initial value.\n         * Call method reset on child elements.\n         */\n        reset: function () {\n            var elems = this.elems(),\n                nameIsEqual,\n                dataScopeIsEqual;\n\n            _.each(elems, function (elem) {\n                nameIsEqual = this.name + '.' + this.positionProvider === elem.name;\n                dataScopeIsEqual = this.dataScope === elem.dataScope;\n\n                if (!(nameIsEqual || dataScopeIsEqual) && _.isFunction(elem.reset)) {\n                    elem.reset();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Clear data\n         *\n         * @returns {Collection} Chainable.\n         */\n        clear: function () {\n            var elems = this.elems(),\n                nameIsEqual,\n                dataScopeIsEqual;\n\n            _.each(elems, function (elem) {\n                nameIsEqual = this.name + '.' + this.positionProvider === elem.name;\n                dataScopeIsEqual = this.dataScope === elem.dataScope;\n\n                if (!(nameIsEqual || dataScopeIsEqual) && _.isFunction(elem.reset)) {\n                    elem.clear();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Get label for collapsible header\n         *\n         * @param {String} label\n         *\n         * @returns {String}\n         */\n        getLabel: function (label) {\n            if (_.isString(label)) {\n                this.label(label);\n            } else if (label && this.label()) {\n                return this.label();\n            } else {\n                this.label(this.headerLabel);\n            }\n\n            return this.label();\n        },\n\n        /**\n         * Set visibility to record child\n         *\n         * @param {Boolean} state\n         */\n        setVisible: function (state) {\n            this.elems.each(function (cell) {\n                cell.visible(state);\n            });\n        },\n\n        /**\n         * Set visibility to child by index\n         *\n         * @param {Number} index\n         * @param {Boolean} state\n         */\n        setVisibilityColumn: function (index, state) {\n            var elems = this.elems(),\n                curElem = parseInt(index, 10),\n                label;\n\n            if (!this.parentComponent()) {\n                return false;\n            }\n\n            if (_.isNaN(curElem)) {\n                _.findWhere(elems, {\n                    index: index\n                }).visible(state);\n                label = _.findWhere(this.parentComponent().labels(), {\n                    name: index\n                });\n                label.defaultLabelVisible && label.visible(state);\n            } else {\n                elems[curElem].visible(state);\n            }\n        },\n\n        /**\n         * Set disabled to child\n         *\n         * @param {Boolean} state\n         */\n        setDisabled: function (state) {\n            this.elems.each(function (cell) {\n                cell.disabled(state);\n            });\n        },\n\n        /**\n         * Set disabled to child by index\n         *\n         * @param {Number} index\n         * @param {Boolean} state\n         */\n        setDisabledColumn: function (index, state) {\n            index = ~~index;\n            this.elems()[index].disabled(state);\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/action-delete.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: false\n            }\n        },\n\n        /**\n         * Delete record handler.\n         *\n         * @param {Number} index\n         * @param {Number} id\n         */\n        deleteRecord: function (index, id) {\n            this.bubble('deleteRecord', index, id);\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/dynamic-rows-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './dynamic-rows'\n], function (_, dynamicRows) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            dataProvider: '',\n            insertData: [],\n            map: null,\n            cacheGridData: [],\n            deleteProperty: false,\n            positionProvider: 'position',\n            dataLength: 0,\n            identificationProperty: 'id',\n            identificationDRProperty: 'id',\n            listens: {\n                'insertData': 'processingInsertData',\n                'recordData': 'initElements setToInsertData'\n            },\n            mappingSettings: {\n                enabled: true,\n                distinct: true\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this.setToInsertData = _.debounce(this.setToInsertData, 200);\n\n            return this._super();\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertData'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Set data from recordData to insertData\n         */\n        setToInsertData: function () {\n            var insertData = [],\n                obj;\n\n            if (this.recordData().length && !this.update) {\n                _.each(this.recordData(), function (recordData) {\n                    obj = {};\n                    obj[this.map[this.identificationProperty]] = recordData[this.identificationProperty];\n                    insertData.push(obj);\n                }, this);\n\n                if (insertData.length) {\n                    this.source.set(this.dataProvider, insertData);\n                }\n            }\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            this.getChildItems().forEach(function (data, index) {\n                this.processingAddChild(data, this.startIndex + index, data[this.identificationDRProperty]);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Initialize elements from grid\n         *\n         * @param {Array} data\n         *\n         * @returns {Object} Chainable.\n         */\n        initElements: function (data) {\n            var newData = this.getNewData(data);\n\n            this.parsePagesData(data);\n\n            if (newData.length) {\n                if (this.insertData().length) {\n                    this.processingAddChild(newData[0], data.length - 1, newData[0][this.identificationProperty]);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete record instance\n         * update data provider dataScope\n         *\n         * @param {String|Number} index - record index\n         * @param {String|Number} recordId\n         */\n        deleteRecord: function (index, recordId) {\n            this.updateInsertData(recordId);\n            this._super();\n        },\n\n        /**\n         * Updates insertData when record is deleted\n         *\n         * @param {String|Number} recordId\n         */\n        updateInsertData: function (recordId) {\n            var data = this.getElementData(this.insertData(), recordId),\n            prop = this.map[this.identificationDRProperty];\n\n            this.insertData(_.reject(this.source.get(this.dataProvider), function (recordData) {\n                return recordData[prop].toString() === data[prop].toString();\n            }, this));\n        },\n\n        /**\n         * Find data object by index\n         *\n         * @param {Array} array - data collection\n         * @param {Number} index - element index\n         * @param {String} property - to find by property\n         *\n         * @returns {Object} data object\n         */\n        getElementData: function (array, index, property) {\n            var obj = {},\n                result;\n\n            property ? obj[property] = index : obj[this.map[this.identificationDRProperty]] = index;\n            result = _.findWhere(array, obj);\n\n            if (!result) {\n                property ?\n                    obj[property] = index.toString() :\n                    obj[this.map[this.identificationDRProperty]] = index.toString();\n            }\n\n            result = _.findWhere(array, obj);\n\n            return result;\n        },\n\n        /**\n         * Processing pages before addChild\n         *\n         * @param {Object} ctx - element context\n         * @param {Number|String} index - element index\n         * @param {Number|String} prop - additional property to element\n         */\n        processingAddChild: function (ctx, index, prop) {\n            if (this._elems.length > this.pageSize) {\n                return false;\n            }\n\n            this.showSpinner(true);\n            this.addChild(ctx, index, prop);\n        },\n\n        /**\n         * Contains old data with new\n         *\n         * @param {Array} data\n         *\n         * @returns {Array} changed data\n         */\n        getNewData: function (data) {\n            var changes = [],\n                tmpObj = {};\n\n            if (data.length !== this.relatedData.length) {\n                _.each(data, function (obj) {\n                    tmpObj[this.identificationDRProperty] = obj[this.identificationDRProperty];\n\n                    if (!_.findWhere(this.relatedData, tmpObj)) {\n                        changes.push(obj);\n                    }\n                }, this);\n            }\n\n            return changes;\n        },\n\n        /**\n         * Processing insert data\n         *\n         * @param {Object} data\n         */\n        processingInsertData: function (data) {\n            var changes,\n                obj = {};\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            if (changes.length) {\n                obj[this.identificationDRProperty] = changes[0][this.map[this.identificationProperty]];\n\n                if (_.findWhere(this.recordData(), obj)) {\n                    return false;\n                }\n\n                changes.forEach(function (changedObject) {\n                    this.mappingValue(changedObject);\n                }, this);\n            }\n        },\n\n        /**\n         * Mapping value from grid\n         *\n         * @param {Array} data\n         */\n        mappingValue: function (data) {\n            var obj = {},\n                tmpObj = {};\n\n            if (this.mappingSettings.enabled) {\n                _.each(this.map, function (prop, index) {\n                    obj[index] = !_.isUndefined(data[prop]) ? data[prop] : '';\n                }, this);\n            } else {\n                obj = data;\n            }\n\n            if (this.mappingSettings.distinct) {\n                tmpObj[this.identificationDRProperty] = obj[this.identificationDRProperty];\n\n                if (_.findWhere(this.recordData(), tmpObj)) {\n                    return false;\n                }\n            }\n\n            if (!obj.hasOwnProperty(this.positionProvider)) {\n                this.setMaxPosition();\n                obj[this.positionProvider] = this.maxPosition;\n            }\n\n            this.source.set(this.dataScope + '.' + this.index + '.' + this.recordData().length, obj);\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.forEach(function (record, index) {\n                obj[this.map[this.identificationDRProperty]] = record[this.map[this.identificationDRProperty]];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        }\n    });\n});\n","Magento_Ui/js/modal/modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'text!ui/template/modal/modal-popup.html',\n    'text!ui/template/modal/modal-slide.html',\n    'text!ui/template/modal/modal-custom.html',\n    'Magento_Ui/js/lib/key-codes',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/core',\n    'mage/translate',\n    'jquery/z-index'\n], function ($, _, template, popupTpl, slideTpl, customTpl, keyCodes) {\n    'use strict';\n\n    /**\n     * Detect browser transition end event.\n     * @return {String|undefined} - transition event.\n     */\n    var transitionEvent = (function () {\n        var transition,\n            elementStyle = document.createElement('div').style,\n            transitions = {\n                'transition': 'transitionend',\n                'OTransition': 'oTransitionEnd',\n                'MozTransition': 'transitionend',\n                'WebkitTransition': 'webkitTransitionEnd'\n            };\n\n        for (transition in transitions) {\n            if (elementStyle[transition] !== undefined && transitions.hasOwnProperty(transition)) {\n                return transitions[transition];\n            }\n        }\n    })();\n\n    /**\n     * Modal Window Widget\n     */\n    $.widget('mage.modal', {\n        options: {\n            id: null,\n            type: 'popup',\n            title: '',\n            subTitle: '',\n            modalClass: '',\n            focus: '[data-role=\"closeBtn\"]',\n            autoOpen: false,\n            clickableOverlay: true,\n            popupTpl: popupTpl,\n            slideTpl: slideTpl,\n            customTpl: customTpl,\n            modalVisibleClass: '_show',\n            parentModalClass: '_has-modal',\n            innerScrollClass: '_inner-scroll',\n            responsive: false,\n            innerScroll: false,\n            modalTitle: '[data-role=\"title\"]',\n            modalSubTitle: '[data-role=\"subTitle\"]',\n            modalBlock: '[data-role=\"modal\"]',\n            modalCloseBtn: '[data-role=\"closeBtn\"]',\n            modalContent: '[data-role=\"content\"]',\n            modalAction: '[data-role=\"action\"]',\n            focusableScope: '[data-role=\"focusable-scope\"]',\n            focusableStart: '[data-role=\"focusable-start\"]',\n            focusableEnd: '[data-role=\"focusable-end\"]',\n            appendTo: 'body',\n            wrapperClass: 'modals-wrapper',\n            overlayClass: 'modals-overlay',\n            responsiveClass: 'modal-slide',\n            trigger: '',\n            modalLeftMargin: 45,\n            closeText: $.mage.__('Close'),\n            buttons: [{\n                text: $.mage.__('Ok'),\n                class: '',\n                attr: {},\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) {\n                    this.closeModal(event);\n                }\n            }],\n            keyEventHandlers: {\n\n                /**\n                 * Tab key press handler,\n                 * set focus to elements\n                 */\n                tabKey: function () {\n                    if (document.activeElement === this.modal[0]) {\n                        this._setFocus('start');\n                    }\n                },\n\n                /**\n                 * Escape key press handler,\n                 * close modal window\n                 * @param {Object} event - event\n                 */\n                escapeKey: function (event) {\n                    if (this.options.isOpen && this.modal.find(document.activeElement).length ||\n                        this.options.isOpen && this.modal[0] === document.activeElement) {\n                        this.closeModal(event);\n                    }\n                }\n            }\n        },\n\n        /**\n         * Creates modal widget.\n         */\n        _create: function () {\n            _.bindAll(\n                this,\n                'keyEventSwitcher',\n                '_tabSwitcher',\n                'closeModal'\n            );\n\n            this.options.id = this.uuid;\n            this.options.transitionEvent = transitionEvent;\n            this._createWrapper();\n            this._renderModal();\n            this._createButtons();\n\n            if (this.options.trigger) {\n                $(document).on('click', this.options.trigger, _.bind(this.toggleModal, this));\n            }\n            this._on(this.modal.find(this.options.modalCloseBtn), {\n                'click': this.options.modalCloseBtnHandler ? this.options.modalCloseBtnHandler : this.closeModal\n            });\n            this._on(this.element, {\n                'openModal': this.openModal,\n                'closeModal': this.closeModal\n            });\n            this.options.autoOpen ? this.openModal() : false;\n        },\n\n        /**\n         * Returns element from modal node.\n         * @return {Object} - element.\n         */\n        _getElem: function (elem) {\n            return this.modal.find(elem);\n        },\n\n        /**\n         * Gets visible modal count.\n         * * @return {Number} - visible modal count.\n         */\n        _getVisibleCount: function () {\n            var modals = this.modalWrapper.find(this.options.modalBlock);\n\n            return modals.filter('.' + this.options.modalVisibleClass).length;\n        },\n\n        /**\n         * Gets count of visible modal by slide type.\n         * * @return {Number} - visible modal count.\n         */\n        _getVisibleSlideCount: function () {\n            var elems = this.modalWrapper.find('[data-type=\"slide\"]');\n\n            return elems.filter('.' + this.options.modalVisibleClass).length;\n        },\n\n        /**\n         * Listener key events.\n         * Call handler function if it exists\n         */\n        keyEventSwitcher: function (event) {\n            var key = keyCodes[event.keyCode];\n\n            if (this.options.keyEventHandlers.hasOwnProperty(key)) {\n                this.options.keyEventHandlers[key].apply(this, arguments);\n            }\n        },\n\n        /**\n         * Set title for modal.\n         *\n         * @param {String} title\n         */\n        setTitle: function (title) {\n            var $title = this.modal.find(this.options.modalTitle),\n                $subTitle = this.modal.find(this.options.modalSubTitle);\n\n            $title.text(title);\n            $title.append($subTitle);\n        },\n\n        /**\n         * Set sub title for modal.\n         *\n         * @param {String} subTitle\n         */\n        setSubTitle: function (subTitle) {\n            this.options.subTitle = subTitle;\n            this.modal.find(this.options.modalSubTitle).html(subTitle);\n        },\n\n        /**\n         * Toggle modal.\n         * * @return {Element} - current element.\n         */\n        toggleModal: function () {\n            if (this.options.isOpen === true) {\n                this.closeModal();\n            } else {\n                this.openModal();\n            }\n        },\n\n        /**\n         * Open modal.\n         * * @return {Element} - current element.\n         */\n        openModal: function () {\n            this.options.isOpen = true;\n            this.focussedElement = document.activeElement;\n            this._createOverlay();\n            this._setActive();\n            this._setKeyListener();\n            this.modal.one(this.options.transitionEvent, _.bind(this._setFocus, this, 'end', 'opened'));\n            this.modal.one(this.options.transitionEvent, _.bind(this._trigger, this, 'opened'));\n            this.modal.addClass(this.options.modalVisibleClass);\n\n            if (!this.options.transitionEvent) {\n                this._trigger('opened');\n            }\n\n            return this.element;\n        },\n\n        /**\n         * Set focus to element.\n         * @param {String} position - can be \"start\" and \"end\"\n         *      positions.\n         *      If position is \"end\" - sets focus to first\n         *      focusable element in modal window scope.\n         *      If position is \"start\" - sets focus to last\n         *      focusable element in modal window scope\n         *\n         *  @param {String} type - can be \"opened\" or false\n         *      If type is \"opened\" - looks to \"this.options.focus\"\n         *      property and sets focus\n         */\n        _setFocus: function (position, type) {\n            var focusableElements,\n                infelicity;\n\n            if (type === 'opened' && this.options.focus) {\n                this.modal.find($(this.options.focus)).trigger('focus');\n            } else if (type === 'opened' && !this.options.focus) {\n                this.modal.find(this.options.focusableScope).trigger('focus');\n            } else if (position === 'end') {\n                this.modal.find(this.options.modalCloseBtn).trigger('focus');\n            } else if (position === 'start') {\n                infelicity = 2; //Constant for find last focusable element\n                focusableElements = this.modal.find(':focusable');\n                focusableElements.eq(focusableElements.length - infelicity).trigger('focus');\n            }\n        },\n\n        /**\n         * Set events listener when modal is opened.\n         */\n        _setKeyListener: function () {\n            this.modal.find(this.options.focusableStart).on('focusin', this._tabSwitcher);\n            this.modal.find(this.options.focusableEnd).on('focusin', this._tabSwitcher);\n            this.modal.on('keydown', this.keyEventSwitcher);\n        },\n\n        /**\n         * Remove events listener when modal is closed.\n         */\n        _removeKeyListener: function () {\n            this.modal.find(this.options.focusableStart).off('focusin', this._tabSwitcher);\n            this.modal.find(this.options.focusableEnd).off('focusin', this._tabSwitcher);\n            this.modal.off('keydown', this.keyEventSwitcher);\n        },\n\n        /**\n         * Switcher for focus event.\n         * @param {Object} e - event\n         */\n        _tabSwitcher: function (e) {\n            var target = $(e.target);\n\n            if (target.is(this.options.focusableStart)) {\n                this._setFocus('start');\n            } else if (target.is(this.options.focusableEnd)) {\n                this._setFocus('end');\n            }\n        },\n\n        /**\n         * Close modal.\n         * * @return {Element} - current element.\n         */\n        closeModal: function () {\n            var that = this;\n\n            this._removeKeyListener();\n            this.options.isOpen = false;\n            this.modal.one(this.options.transitionEvent, function () {\n                that._close();\n            });\n            this.modal.removeClass(this.options.modalVisibleClass);\n\n            if (!this.options.transitionEvent) {\n                that._close();\n            }\n\n            return this.element;\n        },\n\n        /**\n         * Helper for closeModal function.\n         */\n        _close: function () {\n            var trigger = _.bind(this._trigger, this, 'closed', this.modal);\n\n            $(this.focussedElement).trigger('focus');\n            this._destroyOverlay();\n            this._unsetActive();\n            _.defer(trigger, this);\n        },\n\n        /**\n         * Set z-index and margin for modal and overlay.\n         */\n        _setActive: function () {\n            var zIndex = this.modal.zIndex(),\n                baseIndex = zIndex + this._getVisibleCount();\n\n            if (this.modal.data('active')) {\n                return;\n            }\n\n            this.modal.data('active', true);\n\n            this.overlay.zIndex(++baseIndex);\n            this.prevOverlayIndex = this.overlay.zIndex();\n            this.modal.zIndex(this.overlay.zIndex() + 1);\n\n            if (this._getVisibleSlideCount()) {\n                this.modal.css('marginLeft', this.options.modalLeftMargin * this._getVisibleSlideCount());\n            }\n        },\n\n        /**\n         * Unset styles for modal and set z-index for previous modal.\n         */\n        _unsetActive: function () {\n            this.modal.removeAttr('style');\n            this.modal.data('active', false);\n\n            if (this.overlay) {\n                this.overlay.zIndex(this.prevOverlayIndex - 1);\n            }\n        },\n\n        /**\n         * Creates wrapper to hold all modals.\n         */\n        _createWrapper: function () {\n            this.modalWrapper = $(this.options.appendTo).find('.' + this.options.wrapperClass);\n\n            if (!this.modalWrapper.length) {\n                this.modalWrapper = $('<div></div>')\n                    .addClass(this.options.wrapperClass)\n                    .appendTo(this.options.appendTo);\n            }\n        },\n\n        /**\n         * Compile template and append to wrapper.\n         */\n        _renderModal: function () {\n            $(template(\n                this.options[this.options.type + 'Tpl'],\n                {\n                    data: this.options\n                })).appendTo(this.modalWrapper);\n            this.modal = this.modalWrapper.find(this.options.modalBlock).last();\n            this.element.appendTo(this._getElem(this.options.modalContent));\n\n            if (this.element.is(':hidden')) {\n                this.element.show();\n            }\n        },\n\n        /**\n         * Creates buttons pane.\n         */\n        _createButtons: function () {\n            this.buttons = this._getElem(this.options.modalAction);\n            _.each(this.options.buttons, function (btn, key) {\n                var button = this.buttons[key];\n\n                if (btn.attr) {\n                    $(button).attr(btn.attr);\n                }\n\n                if (btn.class) {\n                    $(button).addClass(btn.class);\n                }\n\n                if (!btn.click) {\n                    btn.click = this.closeModal;\n                }\n                $(button).on('click', _.bind(btn.click, this));\n            }, this);\n        },\n\n        /**\n         * Creates overlay, append it to wrapper, set previous click event on overlay.\n         */\n        _createOverlay: function () {\n            var events,\n                outerClickHandler = this.options.outerClickHandler || this.closeModal;\n\n            this.overlay = $('.' + this.options.overlayClass);\n\n            if (!this.overlay.length) {\n                $(this.options.appendTo).addClass(this.options.parentModalClass);\n                this.overlay = $('<div></div>')\n                    .addClass(this.options.overlayClass)\n                    .appendTo(this.modalWrapper);\n            }\n            events = $._data(this.overlay.get(0), 'events');\n            events ? this.prevOverlayHandler = events.click[0].handler : false;\n            this.options.clickableOverlay ? this.overlay.off().on('click', outerClickHandler) : false;\n        },\n\n        /**\n         * Destroy overlay.\n         */\n        _destroyOverlay: function () {\n            if (this._getVisibleCount()) {\n                this.overlay.off().on('click', this.prevOverlayHandler);\n            } else {\n                $(this.options.appendTo).removeClass(this.options.parentModalClass);\n                this.overlay.remove();\n                this.overlay = null;\n            }\n        }\n    });\n\n    return $.mage.modal;\n});\n","Magento_Ui/js/modal/modalToggle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($) {\n    'use strict';\n\n    return function (config, el) {\n        var widget,\n            content;\n\n        if (config.contentSelector) {\n            content = $(config.contentSelector);\n        } else if (config.content) {\n            content = $('<div></div>').html(config.content);\n        } else {\n            content = $('<div></div>');\n        }\n\n        widget = content.modal(config);\n\n        $(el).on(config.toggleEvent, function () {\n            var state = widget.data('mage-modal').options.isOpen;\n\n            if (state) {\n                widget.modal('closeModal');\n            } else {\n                widget.modal('openModal');\n            }\n\n            return false;\n        });\n\n        return widget;\n    };\n});\n","Magento_Ui/js/modal/modal-component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiCollection',\n    'uiRegistry',\n    'underscore',\n    './modal'\n], function ($, Collection, registry, _) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/modal/modal-component',\n            title: '',\n            subTitle: '',\n            options: {\n                modalClass: '',\n                title: '',\n                subTitle: '',\n                buttons: [],\n                keyEventHandlers: {}\n            },\n            valid: true,\n            links: {\n                title: 'options.title',\n                subTitle: 'options.subTitle'\n            },\n            listens: {\n                state: 'onState',\n                title: 'setTitle',\n                'options.subTitle': 'setSubTitle'\n            },\n            modalClass: 'modal-component',\n            onCancel: 'closeModal'\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this,\n                'initModal',\n                'openModal',\n                'closeModal',\n                'toggleModal',\n                'setPrevValues',\n                'validate');\n            this.initializeContent();\n\n            return this;\n        },\n\n        /**\n         * Initializes modal configuration\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            return this._super()\n                .initSelector()\n                .initModalEvents();\n        },\n\n        /**\n         * Configure modal selector\n         *\n         * @returns {Object} Chainable.\n         */\n        initSelector: function () {\n            var modalClass = this.name.replace(/\\./g, '_');\n\n            this.contentSelector = '.' + this.modalClass;\n            this.options.modalClass = this.options.modalClass + ' ' + modalClass;\n            this.rootSelector = '.' + modalClass;\n\n            return this;\n        },\n\n        /**\n         * Configure modal keyboard handlers\n         * and outer click\n         *\n         * @returns {Object} Chainable.\n         */\n        initModalEvents: function () {\n            this.options.keyEventHandlers.escapeKey = this.options.outerClickHandler = this[this.onCancel].bind(this);\n\n            return this;\n        },\n\n        /**\n         * Initialize modal's content components\n         */\n        initializeContent: function () {\n            $.async({\n                component: this.name\n            }, this.initModal);\n        },\n\n        /**\n         * Init toolbar section so other components will be able to place something in it\n         */\n        initToolbarSection: function () {\n            this.set('toolbarSection', this.modal.data('mage-modal').modal.find('header').get(0));\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe(['state', 'focused']);\n\n            return this;\n        },\n\n        /**\n         * Wrap content in a modal of certain type\n         *\n         * @param {HTMLElement} element\n         * @returns {Object} Chainable.\n         */\n        initModal: function (element) {\n            if (!this.modal) {\n                this.overrideModalButtonCallback();\n                this.options.modalCloseBtnHandler = this[this.onCancel].bind(this);\n                this.modal = $(element).modal(this.options);\n                this.initToolbarSection();\n\n                if (this.waitCbk) {\n                    this.waitCbk();\n                    this.waitCbk = null;\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            if (this.modal) {\n                this.state(true);\n            } else {\n                this.waitCbk = this.openModal;\n            }\n        },\n\n        /**\n         * Close modal\n         */\n        closeModal: function () {\n            if (this.modal) {\n                this.state(false);\n            } else {\n                this.waitCbk = this.closeModal;\n            }\n        },\n\n        /**\n         * Toggle modal\n         */\n        toggleModal: function () {\n            if (this.modal) {\n                this.state(!this.state());\n            } else {\n                this.waitCbk = this.toggleModal;\n            }\n        },\n\n        /**\n         * Sets title for modal\n         *\n         * @param {String} title\n         */\n        setTitle: function (title) {\n            if (this.title !== title) {\n                this.title = title;\n            }\n\n            if (this.modal) {\n                this.modal.modal('setTitle', title);\n            }\n        },\n\n        /**\n         * Sets subTitle for modal\n         *\n         * @param {String} subTitle\n         */\n        setSubTitle: function (subTitle) {\n            if (this.subTitle !== subTitle) {\n                this.subTitle = subTitle;\n            }\n\n            if (this.modal) {\n                this.modal.modal('setSubTitle', subTitle);\n            }\n        },\n\n        /**\n         * Wrap content in a modal of certain type\n         *\n         * @param {Boolean} state\n         */\n        onState: function (state) {\n            if (state) {\n                this.modal.modal('openModal');\n                this.applyData();\n            } else {\n                this.modal.modal('closeModal');\n            }\n        },\n\n        /**\n         * Validate everything validatable in modal\n         */\n        validate: function (elem) {\n            if (typeof elem === 'undefined') {\n                return;\n            }\n\n            if (typeof elem.validate === 'function') {\n                this.valid &= elem.validate().valid;\n            } else if (elem.elems) {\n                elem.elems().forEach(this.validate, this);\n            }\n        },\n\n        /**\n         * Reset data from provider\n         */\n        resetData: function () {\n            this.elems().forEach(this.resetValue, this);\n        },\n\n        /**\n         * Update 'applied' property with data from modal content\n         */\n        applyData: function () {\n            var applied = {};\n\n            this.elems().forEach(this.gatherValues.bind(this, applied), this);\n            this.applied = applied;\n        },\n\n        /**\n         * Gather values from modal content\n         *\n         * @param {Array} applied\n         * @param {HTMLElement} elem\n         */\n        gatherValues: function (applied, elem) {\n            if (typeof elem.value === 'function') {\n                applied[elem.name] = elem.value();\n            } else if (elem.elems) {\n                elem.elems().forEach(this.gatherValues.bind(this, applied), this);\n            }\n        },\n\n        /**\n         * Set to previous values from modal content\n         *\n         * @param {HTMLElement} elem\n         */\n        setPrevValues: function (elem) {\n            if (typeof elem.value === 'function') {\n                this.modal.focus();\n                elem.value(this.applied[elem.name]);\n            } else if (elem.elems) {\n                elem.elems().forEach(this.setPrevValues, this);\n            }\n        },\n\n        /**\n         * Triggers some method in every modal child elem, if this method is defined\n         *\n         * @param {Object} action - action configuration,\n         * must contain actionName and targetName and\n         * can contain params\n         */\n        triggerAction: function (action) {\n            var targetName = action.targetName,\n                params = action.params || [],\n                actionName = action.actionName,\n                target;\n\n            target = registry.async(targetName);\n\n            if (target && typeof target === 'function' && actionName) {\n                params.unshift(actionName);\n                target.apply(target, params);\n            }\n        },\n\n        /**\n         * Override modal buttons callback placeholders with real callbacks\n         */\n        overrideModalButtonCallback: function () {\n            var buttons = this.options.buttons;\n\n            if (buttons && buttons.length) {\n                buttons.forEach(function (button) {\n                    button.click = this.getButtonClickHandler(button.actions);\n                }, this);\n            }\n        },\n\n        /**\n         * Generate button click handler based on button's 'actions' configuration\n         */\n        getButtonClickHandler: function (actionsConfig) {\n            var actions = actionsConfig.map(\n                function (actionConfig) {\n                    if (_.isObject(actionConfig)) {\n                        return this.triggerAction.bind(this, actionConfig);\n                    }\n\n                    return this[actionConfig] ? this[actionConfig].bind(this) : function () {};\n                }, this);\n\n            return function () {\n                actions.forEach(\n                    function (action) {\n                        action();\n                    }\n                );\n            };\n        },\n\n        /**\n         * Cancels changes in modal:\n         * returning elems values to the previous state,\n         * and close modal\n         */\n        actionCancel: function () {\n            this.elems().forEach(this.setPrevValues, this);\n            this.closeModal();\n        },\n\n        /**\n         * Accept changes in modal by not preventing them.\n         * Can be extended by exporting 'gatherValues' result somewhere\n         */\n        actionDone: function () {\n            this.valid = true;\n            this.elems().forEach(this.validate, this);\n\n            if (this.valid) {\n                this.closeModal();\n            }\n        }\n    });\n});\n","Magento_Ui/js/modal/prompt.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'text!ui/template/modal/modal-prompt-content.html',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, _, template, promptContentTmpl) {\n    'use strict';\n\n    $.widget('mage.prompt', $.mage.modal, {\n        options: {\n            modalClass: 'prompt',\n            promptContentTmpl: promptContentTmpl,\n            promptField: '[data-role=\"promptField\"]',\n            attributesForm: {},\n            attributesField: {},\n            value: '',\n            validation: false,\n            validationRules: [],\n            keyEventHandlers: {\n\n                /**\n                 * Enter key press handler,\n                 * submit result and close modal window\n                 * @param {Object} event - event\n                 */\n                enterKey: function (event) {\n                    if (this.options.isOpen && this.modal.find(document.activeElement).length ||\n                        this.options.isOpen && this.modal[0] === document.activeElement) {\n                        this.closeModal(true);\n                        event.preventDefault();\n                    }\n                },\n\n                /**\n                 * Tab key press handler,\n                 * set focus to elements\n                 */\n                tabKey: function () {\n                    if (document.activeElement === this.modal[0]) {\n                        this._setFocus('start');\n                    }\n                },\n\n                /**\n                 * Escape key press handler,\n                 * cancel and close modal window\n                 * @param {Object} event - event\n                 */\n                escapeKey: function (event) {\n                    if (this.options.isOpen && this.modal.find(document.activeElement).length ||\n                        this.options.isOpen && this.modal[0] === document.activeElement) {\n                        this.closeModal();\n                        event.preventDefault();\n                    }\n                }\n            },\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {},\n\n                /**\n                 * Callback confirm.\n                 */\n                confirm: function () {},\n\n                /**\n                 * Callback cancel.\n                 */\n                cancel: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }, {\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal(true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this.options.focus = this.options.promptField;\n            this.options.validation = this.options.validation && this.options.validationRules.length;\n            this.options.outerClickHandler = this.options.outerClickHandler || _.bind(this.closeModal, this, false);\n            this._super();\n            this.modal.find(this.options.modalContent).append(this.getFormTemplate());\n            this.modal.find(this.options.modalCloseBtn).off().on('click',  _.bind(this.closeModal, this, false));\n\n            if (this.options.validation) {\n                this.setValidationClasses();\n            }\n\n            this.openModal();\n        },\n\n        /**\n         * Form template getter.\n         *\n         * @returns {Object} Form template.\n         */\n        getFormTemplate: function () {\n            var formTemplate,\n                formAttr = '',\n                inputAttr = '',\n                attributeName;\n\n            for (attributeName in this.options.attributesForm) {\n                if (this.options.attributesForm.hasOwnProperty(attributeName)) {\n                    formAttr = formAttr + ' ' + attributeName + '=\"' +\n                        this.options.attributesForm[attributeName] + '\"';\n                }\n            }\n\n            for (attributeName in this.options.attributesField) {\n                if (this.options.attributesField.hasOwnProperty(attributeName)) {\n                    inputAttr = inputAttr + ' ' + attributeName + '=\"' +\n                        this.options.attributesField[attributeName] + '\"';\n                }\n            }\n\n            formTemplate = $(template(this.options.promptContentTmpl, {\n                data: this.options,\n                formAttr: formAttr,\n                inputAttr: inputAttr\n            }));\n\n            return formTemplate;\n        },\n\n        /**\n         * Remove widget\n         */\n        _remove: function () {\n            this.modal.remove();\n        },\n\n        /**\n         * Validate prompt field\n         */\n        validate: function () {\n            return $.validator.validateSingleElement(this.options.promptField);\n        },\n\n        /**\n         * Add validation classes to prompt field\n         */\n        setValidationClasses: function () {\n            this.modal.find(this.options.promptField).attr('class', $.proxy(function (i, val) {\n                return val + ' ' + this.options.validationRules.join(' ');\n            }, this));\n        },\n\n        /**\n         * Open modal window\n         */\n        openModal: function () {\n            this._super();\n            this.modal.find(this.options.promptField).val(this.options.value);\n        },\n\n        /**\n         * Close modal window\n         */\n        closeModal: function (result) {\n            var value;\n\n            if (result) {\n                if (this.options.validation && !this.validate()) {\n                    return false;\n                }\n\n                value = this.modal.find(this.options.promptField).val();\n                this.options.actions.confirm.call(this, value);\n            } else {\n                this.options.actions.cancel.call(this, result);\n            }\n\n            this.options.actions.always();\n            this.element.on('promptclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div class=\"prompt-message\"></div>').html(config.content).prompt(config);\n    };\n});\n","Magento_Ui/js/modal/alert.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, _) {\n    'use strict';\n\n    $.widget('mage.alert', $.mage.confirm, {\n        options: {\n            modalClass: 'confirm',\n            title: $.mage.__('Attention'),\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal(true);\n                }\n            }]\n        },\n\n        /**\n         * Close modal window.\n         */\n        closeModal: function () {\n            this.options.actions.always();\n            this.element.on('alertclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).alert(config);\n    };\n});\n","Magento_Ui/js/modal/confirm.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/modal'\n], function ($, _, $t) {\n    'use strict';\n\n    $.widget('mage.confirm', $.mage.modal, {\n        options: {\n            modalClass: 'confirm',\n            title: '',\n            focus: '.action-accept',\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {},\n\n                /**\n                 * Callback confirm.\n                 */\n                confirm: function () {},\n\n                /**\n                 * Callback cancel.\n                 */\n                cancel: function () {}\n            },\n            buttons: [{\n                text: $t('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function (event) {\n                    this.closeModal(event);\n                }\n            }, {\n                text: $t('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function (event) {\n                    this.closeModal(event, true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this._super();\n            this.modal.find(this.options.modalCloseBtn).off().on('click', _.bind(this.closeModal, this));\n            this.openModal();\n        },\n\n        /**\n         * Remove modal window.\n         */\n        _remove: function () {\n            this.modal.remove();\n        },\n\n        /**\n         * Open modal window.\n         */\n        openModal: function () {\n            return this._super();\n        },\n\n        /**\n         * Close modal window.\n         */\n        closeModal: function (event, result) {\n            result = result || false;\n\n            if (result) {\n                this.options.actions.confirm(event);\n            } else {\n                this.options.actions.cancel(event);\n            }\n            this.options.actions.always(event);\n            this.element.on('confirmclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).confirm(config);\n    };\n});\n","Magento_Ui/js/form/button-adapter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiClass',\n    'jquery',\n    'underscore',\n    'uiRegistry'\n], function (Class, $, _, registry) {\n    'use strict';\n\n    return Class.extend({\n\n        /**\n         * Initialize actions and adapter.\n         *\n         * @param {Object} config\n         * @param {Element} elem\n         * @returns {Object}\n         */\n        initialize: function (config, elem) {\n            return this._super()\n                .initActions()\n                .initAdapter(elem);\n        },\n\n        /**\n         * Creates callback from declared actions.\n         *\n         * @returns {Object}\n         */\n        initActions: function () {\n            var callbacks = [];\n\n            _.each(this.actions, function (action) {\n                callbacks.push({\n                    action: registry.async(action.targetName),\n                    args: _.union([action.actionName], action.params)\n                });\n            });\n\n            /**\n             * Callback function.\n             */\n            this.callback = function () {\n                _.each(callbacks, function (callback) {\n                    callback.action.apply(callback.action, callback.args);\n                });\n            };\n\n            return this;\n        },\n\n        /**\n         * Attach callback handler on button.\n         *\n         * @param {Element} elem\n         */\n        initAdapter: function (elem) {\n            $(elem).on('click', this.callback);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiElement',\n    './client',\n    'mageUtils'\n], function (_, Element, Client, utils) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            clientConfig: {\n                urls: {\n                    save: '${ $.submit_url }',\n                    beforeSave: '${ $.validate_url }'\n                }\n            },\n            ignoreTmpls: {\n                data: true\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initClient();\n\n            return this;\n        },\n\n        /**\n         * Initializes client component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initClient: function () {\n            this.client = new Client(this.clientConfig);\n\n            return this;\n        },\n\n        /**\n         * Saves currently available data.\n         *\n         * @param {Object} [options] - Addtitional request options.\n         * @returns {Provider} Chainable.\n         */\n        save: function (options) {\n            var data = this.get('data');\n\n            this.client.save(data, options);\n\n            return this;\n        },\n\n        /**\n         * Update data that stored in provider.\n         *\n         * @param {Boolean} isProvider\n         * @param {Object} newData\n         * @param {Object} oldData\n         *\n         * @returns {Provider}\n         */\n        updateConfig: function (isProvider, newData, oldData) {\n            if (isProvider === true) {\n                this.setData(oldData, newData, this);\n            }\n\n            return this;\n        },\n\n        /**\n         *  Set data to provider based on current data.\n         *\n         * @param {Object} oldData\n         * @param {Object} newData\n         * @param {Provider} current\n         * @param {String} parentPath\n         */\n        setData: function (oldData, newData, current, parentPath) {\n            _.each(newData, function (val, key) {\n                if (_.isObject(val) || _.isArray(val)) {\n                    this.setData(oldData[key], val, current[key], utils.fullPath(parentPath, key));\n                } else if (val != oldData[key] && oldData[key] == current[key]) {//eslint-disable-line eqeqeq\n                    this.set(utils.fullPath(parentPath, key), val);\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Ui/js/form/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/spinner',\n    'rjsResolver',\n    './adapter',\n    'uiCollection',\n    'mageUtils',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'mage/validation'\n], function (_, loader, resolver, adapter, Collection, utils, $, app) {\n    'use strict';\n\n    /**\n     * Format params\n     *\n     * @param {Object} params\n     * @returns {Array}\n     */\n    function prepareParams(params) {\n        var result = '?';\n\n        _.each(params, function (value, key) {\n            result += key + '=' + value + '&';\n        });\n\n        return result.slice(0, -1);\n    }\n\n    /**\n     * Collect form data.\n     *\n     * @param {Array} items\n     * @returns {Object}\n     */\n    function collectData(items) {\n        var result = {},\n            name;\n\n        items = Array.prototype.slice.call(items);\n\n        items.forEach(function (item) {\n            switch (item.type) {\n                case 'checkbox':\n                    result[item.name] = +!!item.checked;\n                    break;\n\n                case 'radio':\n                    if (item.checked) {\n                        result[item.name] = item.value;\n                    }\n                    break;\n\n                case 'select-multiple':\n                    name = item.name.substring(0, item.name.length - 2); //remove [] from the name ending\n                    result[name] = _.pluck(item.selectedOptions, 'value');\n                    break;\n\n                default:\n                    result[item.name] = item.value;\n            }\n        });\n\n        return result;\n    }\n\n    /**\n     * Makes ajax request\n     *\n     * @param {Object} params\n     * @param {Object} data\n     * @param {String} url\n     * @returns {*}\n     */\n    function makeRequest(params, data, url) {\n        var save = $.Deferred();\n\n        data = utils.serialize(data);\n        data['form_key'] = window.FORM_KEY;\n\n        if (!url) {\n            save.resolve();\n        }\n\n        $('body').trigger('processStart');\n\n        $.ajax({\n            url: url + prepareParams(params),\n            data: data,\n            dataType: 'json',\n\n            /**\n             * Success callback.\n             * @param {Object} resp\n             * @returns {Boolean}\n             */\n            success: function (resp) {\n                if (resp.ajaxExpired) {\n                    window.location.href = resp.ajaxRedirect;\n                }\n\n                if (!resp.error) {\n                    save.resolve(resp);\n\n                    return true;\n                }\n\n                $('body').notification('clear');\n                $.each(resp.messages, function (key, message) {\n                    $('body').notification('add', {\n                        error: resp.error,\n                        message: message,\n\n                        /**\n                         * Inserts message on page\n                         * @param {String} msg\n                         */\n                        insertMethod: function (msg) {\n                            $('.page-main-actions').after(msg);\n                        }\n                    });\n                });\n            },\n\n            /**\n             * Complete callback.\n             */\n            complete: function () {\n                $('body').trigger('processStop');\n            }\n        });\n\n        return save.promise();\n    }\n\n    /**\n     * Check if fields is valid.\n     *\n     * @param {Array}items\n     * @returns {Boolean}\n     */\n    function isValidFields(items) {\n        var result = true;\n\n        _.each(items, function (item) {\n            if (!$.validator.validateSingleElement(item)) {\n                result = false;\n            }\n        });\n\n        return result;\n    }\n\n    return Collection.extend({\n        defaults: {\n            additionalFields: [],\n            additionalInvalid: false,\n            selectorPrefix: '.page-content',\n            messagesClass: 'messages',\n            errorClass: '.admin__field._error',\n            eventPrefix: '.${ $.index }',\n            ajaxSave: false,\n            ajaxSaveType: 'default',\n            imports: {\n                reloadUrl: '${ $.provider}:reloadUrl'\n            },\n            listens: {\n                selectorPrefix: 'destroyAdapter initAdapter',\n                '${ $.name }.${ $.reloadItem }': 'params.set reload'\n            },\n            exports: {\n                selectorPrefix: '${ $.provider }:client.selectorPrefix',\n                messagesClass: '${ $.provider }:client.messagesClass'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initAdapter();\n\n            resolver(this.hideLoader, this);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'responseData',\n                    'responseStatus'\n                ]);\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n\n            this.selector = '[data-form-part=' + this.namespace + ']';\n\n            return this;\n        },\n\n        /**\n         * Initialize adapter handlers.\n         *\n         * @returns {Object}\n         */\n        initAdapter: function () {\n            adapter.on({\n                'reset': this.reset.bind(this),\n                'save': this.save.bind(this, true, {}),\n                'saveAndContinue': this.save.bind(this, false, {})\n            }, this.selectorPrefix, this.eventPrefix);\n\n            return this;\n        },\n\n        /**\n         * Destroy adapter handlers.\n         *\n         * @returns {Object}\n         */\n        destroyAdapter: function () {\n            adapter.off([\n                'reset',\n                'save',\n                'saveAndContinue'\n            ], this.eventPrefix);\n\n            return this;\n        },\n\n        /**\n         * Hide loader.\n         *\n         * @returns {Object}\n         */\n        hideLoader: function () {\n            loader.get(this.name).hide();\n\n            return this;\n        },\n\n        /**\n         * Validate and save form.\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        save: function (redirect, data) {\n            this.validate();\n\n            if (!this.additionalInvalid && !this.source.get('params.invalid')) {\n                this.setAdditionalData(data)\n                    .submit(redirect);\n            } else {\n                this.focusInvalid();\n            }\n        },\n\n        /**\n         * Tries to set focus on first invalid form field.\n         *\n         * @returns {Object}\n         */\n        focusInvalid: function () {\n            var invalidField = _.find(this.delegate('checkInvalid'));\n\n            if (!_.isUndefined(invalidField) && _.isFunction(invalidField.focused)) {\n                invalidField.focused(true);\n            }\n\n            return this;\n        },\n\n        /**\n         * Set additional data to source before form submit and after validation.\n         *\n         * @param {Object} data\n         * @returns {Object}\n         */\n        setAdditionalData: function (data) {\n            _.each(data, function (value, name) {\n                this.source.set('data.' + name, value);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Submits form\n         *\n         * @param {String} redirect\n         */\n        submit: function (redirect) {\n            var additional = collectData(this.additionalFields),\n                source = this.source;\n\n            _.each(additional, function (value, name) {\n                source.set('data.' + name, value);\n            });\n\n            source.save({\n                redirect: redirect,\n                ajaxSave: this.ajaxSave,\n                ajaxSaveType: this.ajaxSaveType,\n                response: {\n                    data: this.responseData,\n                    status: this.responseStatus\n                },\n                attributes: {\n                    id: this.namespace\n                }\n            });\n        },\n\n        /**\n         * Validates each element and returns true, if all elements are valid.\n         */\n        validate: function () {\n            this.additionalFields = document.querySelectorAll(this.selector);\n            this.source.set('params.invalid', false);\n            this.source.trigger('data.validate');\n            this.set('additionalInvalid', !isValidFields(this.additionalFields));\n        },\n\n        /**\n         * Trigger reset form data.\n         */\n        reset: function () {\n            this.source.trigger('data.reset');\n            $('[data-bind*=datepicker]').val('');\n        },\n\n        /**\n         * Trigger overload form data.\n         */\n        overload: function () {\n            this.source.trigger('data.overload');\n        },\n\n        /**\n         * Updates data from server.\n         */\n        reload: function () {\n            makeRequest(this.params, this.data, this.reloadUrl).then(function (data) {\n                app(data, true);\n            });\n        }\n    });\n});\n","Magento_Ui/js/form/client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    /**\n     * Before save validate request.\n     *\n     * @param {Object} data\n     * @param {String} url\n     * @param {String} selectorPrefix\n     * @param {String} messagesClass\n     * @returns {*}\n     */\n    function beforeSave(data, url, selectorPrefix, messagesClass) {\n        var save = $.Deferred();\n\n        data = utils.serialize(utils.filterFormData(data));\n        data['form_key'] = window.FORM_KEY;\n\n        if (!url || url === 'undefined') {\n            return save.resolve();\n        }\n\n        $('body').trigger('processStart');\n\n        $.ajax({\n            url: url,\n            data: data,\n\n            /**\n             * Success callback.\n             * @param {Object} resp\n             * @returns {Boolean}\n             */\n            success: function (resp) {\n                if (!resp.error) {\n                    save.resolve();\n\n                    return true;\n                }\n\n                $('body').notification('clear');\n                $.each(resp.messages || [resp.message] || [], function (key, message) {\n                    $('body').notification('add', {\n                        error: resp.error,\n                        message: message,\n\n                        /**\n                         * Insert method.\n                         *\n                         * @param {String} msg\n                         */\n                        insertMethod: function (msg) {\n                            var $wrapper = $('<div></div>').addClass(messagesClass).html(msg);\n\n                            $('.page-main-actions', selectorPrefix).after($wrapper);\n                            $('html, body').animate({\n                                scrollTop: $('.page-main-actions', selectorPrefix).offset().top\n                            });\n                        }\n                    });\n                });\n            },\n\n            /**\n             * Complete callback.\n             */\n            complete: function () {\n                $('body').trigger('processStop');\n            }\n        });\n\n        return save.promise();\n    }\n\n    return Class.extend({\n\n        /**\n         * Assembles data and submits it using 'utils.submit' method\n         */\n        save: function (data, options) {\n            var url = this.urls.beforeSave,\n                save = this._save.bind(this, data, options);\n\n            beforeSave(data, url, this.selectorPrefix, this.messagesClass).then(save);\n\n            return this;\n        },\n\n        /**\n         * Save data.\n         *\n         * @param {Object} data\n         * @param {Object} options\n         * @returns {Object}\n         * @private\n         */\n        _save: function (data, options) {\n            var url = this.urls.save;\n\n            $('body').trigger('processStart');\n            options = options || {};\n\n            if (!options.redirect) {\n                url += 'back/edit';\n            }\n\n            if (options.ajaxSave) {\n                utils.ajaxSubmit({\n                    url: url,\n                    data: data\n                }, options);\n\n                $('body').trigger('processStop');\n\n                return this;\n            }\n\n            utils.submit({\n                url: url,\n                data: data\n            }, options.attributes);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/adapter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/adapter/buttons'\n], function ($, _, buttons) {\n    'use strict';\n\n    var selectorPrefix = '',\n        eventPrefix;\n\n    /**\n     * Initialize listener.\n     *\n     * @param {Function} callback\n     * @param {String} action\n     */\n    function initListener(callback, action) {\n        var selector    = selectorPrefix ? selectorPrefix + ' ' + buttons[action] : buttons[action],\n            elem        = $(selector)[0];\n\n        if (!elem) {\n            return;\n        }\n\n        if (elem.onclick) {\n            elem.onclick = null;\n        }\n\n        $(elem).on('click' + eventPrefix, callback);\n    }\n\n    /**\n     * Destroy listener.\n     *\n     * @param {String} action\n     */\n    function destroyListener(action) {\n        var selector    = selectorPrefix ? selectorPrefix + ' ' + buttons[action] : buttons[action],\n            elem        = $(selector)[0];\n\n        if (!elem) {\n            return;\n        }\n\n        if (elem.onclick) {\n            elem.onclick = null;\n        }\n\n        $(elem).off('click' + eventPrefix);\n    }\n\n    return {\n\n        /**\n         * Attaches events handlers.\n         *\n         * @param {Object} handlers\n         * @param {String} selectorPref\n         * @param {String} eventPref\n         */\n        on: function (handlers, selectorPref, eventPref) {\n            selectorPrefix = selectorPrefix || selectorPref;\n            eventPrefix = eventPref;\n            _.each(handlers, initListener);\n            selectorPrefix = '';\n        },\n\n        /**\n         * Removes events handlers.\n         *\n         * @param {Object} handlers\n         * @param {String} eventPref\n         */\n        off: function (handlers, eventPref) {\n            eventPrefix = eventPref;\n            _.each(handlers, destroyListener);\n        }\n    };\n});\n","Magento_Ui/js/form/switcher.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (_, registry, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            rules: []\n        },\n\n        /**\n         * Initializes instance of a DataSwitcher.\n         *\n         * @returns {DataSwitcher} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initRules();\n\n            return this;\n        },\n\n        /**\n         *\n         * @returns {DataSwitcher} Chainable.\n         */\n        initRules: function () {\n            this.rules.forEach(this.initRule, this);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule definition.\n         * @returns {DataSwitcher} Chainable.\n         */\n        initRule: function (rule) {\n            var handler = this.onValueChange.bind(this, rule);\n\n            if (!rule.target) {\n                rule.target = this.target;\n            }\n\n            if (!rule.property) {\n                rule.property = this.property;\n            }\n\n            registry.get(rule.target, function (target) {\n                this.applyRule(rule, target.get(rule.property));\n                target.on(rule.property, handler);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule definition.\n         * @returns {DataSwitcher} Chainable.\n         */\n        addRule: function (rule) {\n            this.rules.push(rule);\n            this.initRule(rule);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule object.\n         * @param {*} value - Current value associated with a rule.\n         */\n        applyRule: function (rule, value) {\n            var actions = rule.actions;\n\n            //TODO Refactor this logic in scope of MAGETWO-48585\n            /* eslint-disable eqeqeq */\n            if (rule.value != value) {\n                return;\n            } else if (rule.strict) {\n                return;\n            }\n\n            /* eslint-enable eqeqeq */\n            actions.forEach(this.applyAction, this);\n        },\n\n        /**\n         *\n         * @param {Object} action - Action object.\n         */\n        applyAction: function (action) {\n            registry.get(action.target, function (target) {\n                var callback = target[action.callback];\n\n                callback.apply(target, action.params || []);\n            });\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rules object.\n         * @param {*} value - Current value associated with a rule.\n         */\n        onValueChange: function (rule, value) {\n            this.applyRule(rule, value);\n        }\n    });\n});\n","Magento_Ui/js/form/components/insert.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'jquery',\n    'mage/translate',\n    'mageUtils',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/bindings',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (Element, $, $t, utils, _, alert) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            content: '',\n            template: 'ui/form/insert',\n            showSpinner: true,\n            loading: false,\n            autoRender: true,\n            visible: true,\n            contentSelector: '${$.name}',\n            externalData: [],\n            params: {\n                namespace: '${ $.ns }'\n            },\n            renderSettings: {\n                url: '${ $.render_url }',\n                dataType: 'html'\n            },\n            updateSettings: {\n                url: '${ $.update_url }',\n                dataType: 'json'\n            },\n            imports: {},\n            exports: {},\n            listens: {},\n            links: {\n                value: '${ $.provider }:${ $.dataScope}'\n            },\n            modules: {\n                externalSource: '${ $.externalProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            _.bindAll(this, 'onRender', 'onUpdate');\n\n            if (this.autoRender) {\n                this.render();\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'visible',\n                    'content',\n                    'value',\n                    'loading'\n                ]);\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            this.initDataLink(config)._super();\n            this.contentSelector = this.contentSelector.replace(/\\./g, '_');\n\n            return this;\n        },\n\n        /**\n         * Sync data with external provider.\n         *\n         * @param {Object} config\n         * @returns {Object}\n         */\n        initDataLink: function (config) {\n            var key, value;\n\n            if (config.dataLinks) {\n                _.each(config.externalData, function (val) {\n                    value = val;\n                    key = 'externalValue.' + val.replace('data.', '');\n\n                    if (config.dataLinks.imports) {\n                        this.imports[key] = '${ $.externalProvider }:' + value;\n                    }\n\n                    if (config.dataLinks.exports) {\n                        this.exports[key] = '${ $.externalProvider }:' + value;\n                    }\n                    this.links[key] = '${ $.externalProvider }:' + value;\n                }, this.constructor.defaults);\n            }\n\n            if (config.realTimeLink) {\n                this.constructor.defaults.links.externalValue = 'value';\n            }\n\n            return this;\n        },\n\n        /**\n         * Request for render content.\n         *\n         * @returns {Object}\n         */\n        render: function (params) {\n            var self = this,\n                request;\n\n            if (this.isRendered) {\n                return this;\n            }\n\n            self.previousParams = params || {};\n\n            $.async({\n                component: this.name,\n                ctx: '.' + this.contentSelector\n            }, function (el) {\n                self.contentEl = $(el);\n                self.startRender = true;\n                params = _.extend({}, self.params, params || {});\n                request = self.requestData(params, self.renderSettings);\n                request\n                    .done(self.onRender)\n                    .fail(self.onError);\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this.destroyInserted()\n                ._super();\n        },\n\n        /**\n         * Destroy inserted components.\n         *\n         * @returns {Object}\n         */\n        destroyInserted: function () {\n            if (this.isRendered) {\n                this.isRendered = false;\n                this.content('');\n\n                if (this.externalSource()) {\n                    this.externalSource().destroy();\n                }\n                this.initExternalLinks();\n            }\n\n            return this;\n        },\n\n        /**\n         * Initialize links on external components.\n         *\n         * @returns {Object}\n         */\n        initExternalLinks: function () {\n            var imports = this.filterExternalLinks(this.imports, this.ns),\n                exports = this.filterExternalLinks(this.exports, this.ns),\n                links = this.filterExternalLinks(this.links, this.ns);\n\n            this.setLinks(links, 'imports')\n                .setLinks(links, 'exports');\n\n            _.each({\n                exports: exports,\n                imports: imports\n            }, this.setLinks, this);\n\n            return this;\n        },\n\n        /**\n         * Filter external links.\n         *\n         * @param {Object} data\n         * @param {String }ns\n         * @returns {Object}\n         */\n        filterExternalLinks: function (data, ns) {\n            var links  = {};\n\n            _.each(data, function (value, key) {\n                if (typeof value === 'string' && value.split('.')[0] === ns) {\n                    links[key] = value;\n                }\n            });\n\n            return links;\n        },\n\n        /**\n         * Request with configurable params and settings.\n         *\n         * @param {Object} params\n         * @param {Object} ajaxSettings\n         * @returns {Object}\n         */\n        requestData: function (params, ajaxSettings) {\n            var query = utils.copy(params);\n\n            ajaxSettings = _.extend({\n                url: this['update_url'],\n                method: 'GET',\n                data: query,\n                dataType: 'json'\n            }, ajaxSettings);\n\n            this.loading(true);\n\n            return $.ajax(ajaxSettings);\n        },\n\n        /**\n         * Callback that render content.\n         *\n         * @param {*} data\n         */\n        onRender: function (data) {\n            var resp;\n\n            this.loading(false);\n\n            try {\n                resp = JSON.parse(data);\n\n                if (resp.ajaxExpired) {\n                    window.location.href = resp.ajaxRedirect;\n                }\n            } catch (e) {\n                this.set('content', data);\n                this.isRendered = true;\n                this.startRender = false;\n            }\n        },\n\n        /**\n         * Error callback.\n         *\n         * @param {Object} xhr\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            alert({\n                content: $t('Something went wrong.')\n            });\n        },\n\n        /**\n         * Getter for external data.\n         *\n         * @returns {Object}\n         */\n        getExternalData: function () {\n            var data = {};\n\n            _.each(this.externalData, function (path) {\n                utils.nested(data, path.replace('data.', ''), this.externalSource().get(path));\n            }, this);\n\n            return data;\n        },\n\n        /**\n         * Request for update data.\n         *\n         * @returns {*|Object}\n         */\n        updateData: function (params) {\n            var request;\n\n            params = _.extend(params || {}, this.params);\n\n            if (!this.startRender && !this.isRendered) {\n                return this.render(params);\n            }\n\n            request = this.requestData(params, this.updateSettings);\n            request\n                .done(this.onUpdate)\n                .fail(this.onError);\n\n            return request;\n        },\n\n        /**\n         * Set data to external provider, clear changes.\n         *\n         * @param {*} data\n         */\n        onUpdate: function (data) {\n            this.externalSource().set('data', data);\n            this.externalSource().trigger('data.overload');\n            this.loading(false);\n        }\n    });\n});\n","Magento_Ui/js/form/components/insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    './insert',\n    'mageUtils',\n    'underscore'\n], function ($, Insert, utils, _) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            externalListingName: '${ $.ns }.${ $.ns }',\n            behaviourType: 'simple',\n            externalFilterMode: false,\n            requestConfig: {\n                method: 'POST'\n            },\n            externalCondition: 'nin',\n            settings: {\n                edit: {\n                    imports: {\n                        'onChangeRecord': '${ $.editorProvider }:changed'\n                    }\n                },\n                filter: {\n                    exports: {\n                        'requestConfig': '${ $.externalProvider }:requestConfig'\n                    }\n                }\n            },\n            imports: {\n                onSelectedChange: '${ $.selectionsProvider }:selected',\n                'update_url': '${ $.externalProvider }:update_url',\n                'indexField': '${ $.selectionsProvider }:indexField'\n            },\n            exports: {\n                externalFiltersModifier: '${ $.externalProvider }:params.filters_modifier'\n            },\n            listens: {\n                externalValue: 'updateExternalFiltersModifier updateSelections',\n                indexField: 'initialUpdateListing'\n            },\n            modules: {\n                selections: '${ $.selectionsProvider }',\n                externalListing: '${ $.externalListingName }'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this, 'updateValue', 'updateExternalValueByEditableData');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var defaults = this.constructor.defaults;\n\n            if (config.behaviourType === 'edit') {\n                defaults.editableData = {};\n                _.map(defaults.settings.edit.imports, function (value, key) {\n                    this.imports[key] = value;\n                }, defaults);\n            }\n\n            if (config.externalFilterMode === true) {\n                _.map(defaults.settings.filter.exports, function (value, key) {\n                    this.exports[key] = value;\n                }, defaults);\n            }\n\n            return this._super();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'externalValue'\n                ]);\n        },\n\n        /** @inheritdoc */\n        destroyInserted: function () {\n            if (this.isRendered && this.externalListing()) {\n                this.externalListing().source.storage().clearRequests();\n                this.externalListing().delegate('destroy');\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Store data from edited record\n         *\n         * @param {Object} record\n         */\n        onChangeRecord: function (record) {\n            this.updateEditableData(record);\n\n            if (!this.dataLinks.imports) {\n                return;\n            }\n\n            this.updateExternalValueByEditableData();\n        },\n\n        /**\n         * Updates externalValue every time row is selected,\n         * if it is configured by 'dataLinks.imports'\n         * Also suppress dataLinks so import/export of selections will not activate each other in circle\n         *\n         */\n        onSelectedChange: function () {\n            if (!this.dataLinks.imports ||\n                this.suppressDataLinks ||\n                _.isBoolean(this.initialExportDone) && !this.initialExportDone\n            ) {\n                this.suppressDataLinks = false;\n\n                return;\n            }\n\n            this.suppressDataLinks = true;\n            this.updateExternalValue();\n        },\n\n        /**\n         * Stores data from editor in editableData\n         * @param {Object} record\n         *\n         */\n        updateEditableData: function (record) {\n            var id = _.keys(record[0])[0];\n\n            this.editableData[id] = record[0][id];\n        },\n\n        /**\n         * Updates externalValue by data from editor (already stored in editableData)\n         *\n         */\n        updateExternalValueByEditableData: function () {\n            var updatedExtValue;\n\n            if (!(this.behaviourType === 'edit') || _.isEmpty(this.editableData) || _.isEmpty(this.externalValue())) {\n                return;\n            }\n\n            updatedExtValue = this.externalValue();\n            updatedExtValue.map(function (item) {\n                _.extend(item, this.editableData[item[this.indexField]]);\n            }, this);\n            this.setExternalValue(updatedExtValue);\n        },\n\n        /**\n         * Updates externalValue, from selectionsProvider data (if it is enough)\n         * or ajax request to server\n         *\n         * @returns {Object} result - deferred that will be resolved when value is updated\n         */\n        updateExternalValue: function () {\n            var result = $.Deferred(),\n                provider = this.selections(),\n                selections,\n                totalSelected,\n                itemsType,\n                rows;\n\n            if (!provider) {\n                return result;\n            }\n\n            selections = provider && provider.getSelections();\n            totalSelected = provider.totalSelected();\n            itemsType = selections && selections.excludeMode ? 'excluded' : 'selected';\n            rows = provider && provider.rows();\n\n            if (this.canUpdateFromClientData(totalSelected, selections.selected, rows)) {\n                this.updateFromClientData(selections.selected, rows);\n                this.updateExternalValueByEditableData();\n                result.resolve();\n            } else {\n                this.updateFromServerData(selections, itemsType).done(function () {\n                    this.updateExternalValueByEditableData();\n                    result.resolve();\n                }.bind(this));\n            }\n\n            return result;\n        },\n\n        /**\n         * Check if the selected rows data can be taken from selectionsProvider data\n         * (which only stores data of the current page rows)\n         *  + from already saved data\n         *\n         * @param {Boolean} totalSelected - total rows selected (include rows that were filtered out)\n         * @param {Array} selected - ids of selected rows\n         * @param {Object} rows\n         */\n        canUpdateFromClientData: function (totalSelected, selected, rows) {\n            var alreadySavedSelectionsIds = _.pluck(this.externalValue(), this.indexField),\n                rowsOnCurrentPageIds = _.pluck(rows, this.indexField);\n\n            return totalSelected === selected.length &&\n                _.intersection(_.union(alreadySavedSelectionsIds, rowsOnCurrentPageIds), selected).length ===\n                selected.length;\n        },\n\n        /**\n         * Updates externalValue, from selectionsProvider data\n         * (which only stores data of the current page rows)\n         *  + from already saved data\n         *  so we can avoid request to server\n         *\n         * @param {Array} selected - ids of selected rows\n         * @param {Object} rows\n         */\n        updateFromClientData: function (selected, rows) {\n            var value,\n                rowIds,\n                valueIds;\n\n            if (!selected || !selected.length) {\n                this.setExternalValue([]);\n\n                return;\n            }\n\n            value = this.externalValue();\n            rowIds = _.pluck(rows, this.indexField);\n            valueIds = _.pluck(value, this.indexField);\n\n            value = _.map(selected, function (item) {\n                if (_.contains(rowIds, item)) {\n                    return _.find(rows, function (row) {\n                        return row[this.indexField] === item;\n                    }, this);\n                } else if (_.contains(valueIds, item)) {\n                    return _.find(value, function (row) {\n                        return row[this.indexField] === item;\n                    }, this);\n                }\n            }, this);\n\n            this.setExternalValue(value);\n        },\n\n        /**\n         * Updates externalValue, from ajax request to grab selected rows data\n         *\n         * @param {Object} selections\n         * @param {String} itemsType\n         *\n         * @returns {Object} request - deferred that will be resolved when ajax is done\n         */\n        updateFromServerData: function (selections, itemsType) {\n            var filterType = selections && selections.excludeMode ? 'nin' : 'in',\n                selectionsData = {},\n                request;\n\n            _.extend(selectionsData, this.params || {}, selections.params);\n\n            if (selections[itemsType] && selections[itemsType].length) {\n                selectionsData.filters = {};\n                selectionsData['filters_modifier'] = {};\n                selectionsData['filters_modifier'][this.indexField] = {\n                    'condition_type': filterType,\n                    value: selections[itemsType]\n                };\n            }\n\n            selectionsData.paging = {\n                notLimits: 1\n            };\n\n            request = this.requestData(selectionsData, {\n                method: this.requestConfig.method\n            });\n            request\n                .done(function (data) {\n                    this.setExternalValue(data.items || data);\n                    this.loading(false);\n                }.bind(this))\n                .fail(this.onError);\n\n            return request;\n        },\n\n        /**\n         * Set listing rows data to the externalValue,\n         * or if externalData is configured with the names of particular columns,\n         * filter rows data to have only these columns, and then set to the externalValue\n         *\n         * @param {Object} newValue - rows data\n         *\n         */\n        setExternalValue: function (newValue) {\n            var keys = this.externalData,\n                value = this.externalValue(),\n                selectedIds = _.pluck(newValue, this.indexField);\n\n            if (_.isArray(keys) && !_.isEmpty(keys)) {\n                newValue = _.map(newValue, function (item) {\n                    return _.pick(item, keys);\n                }, this);\n            } else if (keys && _.isString(keys) && !_.isEmpty(newValue)) {\n                newValue = newValue[0][keys];\n            }\n\n            if (this.externalFilterMode) {\n                newValue = _.union(newValue, _.filter(value,\n                    function (item) {\n                        return !_.contains(selectedIds, item[this.indexField]);\n                    }, this));\n            }\n\n            this.set('externalValue', newValue);\n        },\n\n        /**\n         * Updates external filter (if externalFilterMode is on)\n         * every time, when value is updated,\n         * so grid is re-filtered to exclude or include selected rows only\n         *\n         * @param {Object} items\n         */\n        updateExternalFiltersModifier: function (items) {\n            var provider,\n                filter = {};\n\n            if (!this.externalFilterMode) {\n                return;\n            }\n\n            provider = this.selections();\n\n            if (!provider) {\n                this.needInitialListingUpdate = true;\n\n                return;\n            }\n\n            filter[this.indexField] = {\n                'condition_type': this.externalCondition,\n                value: _.pluck(items, this.indexField)\n            };\n            this.set('externalFiltersModifier', filter);\n        },\n\n        /**\n         * Updates grid selections\n         * every time, when extenalValue is updated,\n         * so grid is re-selected according to externalValue updated\n         * Also suppress dataLinks so import/export of selections will not activate each other in circle\n         *\n         * @param {Object} items\n         */\n        updateSelections: function (items) {\n            var provider,\n                ids;\n\n            if (!this.dataLinks.exports || this.suppressDataLinks) {\n                this.suppressDataLinks = false;\n                this.initialExportDone = true;\n\n                return;\n            }\n\n            provider = this.selections();\n\n            if (!provider) {\n                this.needInitialListingUpdate = true;\n\n                return;\n            }\n\n            this.suppressDataLinks = true;\n            provider.deselectAll();\n\n            if (_.isString(items)) {\n                provider.selected([items] || []);\n            } else {\n                ids = _.pluck(items || [], this.indexField)\n                    .map(function (item) {\n                        return item.toString();\n                    });\n\n                provider.selected(ids || []);\n            }\n            this.initialExportDone = true;\n        },\n\n        /**\n         * initial update of the listing\n         * with rows that must be checked/filtered\n         * by the indexes\n         */\n        initialUpdateListing: function () {\n            var items = this.externalValue();\n\n            if (this.needInitialListingUpdate && items) {\n                this.updateExternalFiltersModifier(items);\n                this.updateSelections(items);\n                this.needInitialListingUpdate = false;\n            }\n        },\n\n        /**\n         * Reload source\n         */\n        reload: function () {\n            this.externalSource().set('params.t', new Date().getTime());\n        },\n\n        /**\n         * Updates value from external value\n         *\n         */\n        updateValue: function () {\n            this.set('value', this.externalValue());\n        },\n\n        /**\n         * Updates external value, then updates value from external value\n         *\n         */\n        save: function () {\n            this.updateExternalValue().done(\n                function () {\n                    if (!this.realTimeLink) {\n                        this.updateValue();\n                    }\n                }.bind(this)\n            );\n        }\n    });\n});\n","Magento_Ui/js/form/components/html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent'\n], function ($, _, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            content:        '',\n            showSpinner:    false,\n            loading:        false,\n            visible:        true,\n            template:       'ui/content/content',\n            additionalClasses: {},\n            ignoreTmpls: {\n                content: true\n            }\n        },\n\n        /**\n         * Extends instance with default config, calls 'initialize' method of\n         *     parent, calls 'initAjaxConfig'\n         */\n        initialize: function () {\n            _.bindAll(this, 'onContainerToggle', 'onDataLoaded');\n\n            this._super()\n                ._setClasses()\n                .initAjaxConfig();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' method of parent, initializes observable\n         * properties of instance\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('content loading visible');\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses,\n                classes;\n\n            if (_.isString(additional)) {\n                additional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__scope-old': !!additional\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initContainer: function (parent) {\n            this._super();\n\n            parent.on('active', this.onContainerToggle);\n\n            return this;\n        },\n\n        /**\n         * Initializes default ajax config on instance\n         *\n         * @return {Object} - reference to instance\n         */\n        initAjaxConfig: function () {\n            this.ajaxConfig = {\n                url: this.url,\n                data: {\n                    FORM_KEY: window.FORM_KEY\n                },\n                success:    this.onDataLoaded\n            };\n\n            return this;\n        },\n\n        /**\n         * Calls 'loadData' if both 'active' variable and 'shouldLoad'\n         * property are truthy\n         *\n         * @param  {Boolean} active\n         */\n        onContainerToggle: function (active) {\n            if (active && this.shouldLoad()) {\n                this.loadData();\n            }\n        },\n\n        /**\n         * Defines if instance has 'content' property defined.\n         *\n         * @return {Boolean} [description]\n         */\n        hasData: function () {\n            return !!this.content();\n        },\n\n        /**\n         * Defines if instance should load external data\n         *\n         * @return {Boolean}\n         */\n        shouldLoad: function () {\n            return this.url && !this.hasData() && !this.loading();\n        },\n\n        /**\n         * Sets loading property to true, makes ajax call\n         *\n         * @return {Object} - reference to instance\n         */\n        loadData: function () {\n            this.loading(true);\n\n            $.ajax(this.ajaxConfig);\n\n            return this;\n        },\n\n        /**\n         * Ajax's request success handler. Calls 'updateContent' passing 'data'\n         * to it, then sets 'loading' property to false.\n         *\n         * @param  {String} data\n         */\n        onDataLoaded: function (data) {\n            this.updateContent(data)\n                .loading(false);\n        },\n\n        /**\n         * Sets incoming data 'content' property's value\n         *\n         * @param  {String} content\n         * @return {Object} - reference to instance\n         */\n        updateContent: function (content) {\n            this.content(content);\n\n            return this;\n        },\n\n        /**\n         * Content getter\n         *\n         * @returns {String}\n         */\n        getContentUnsanitizedHtml: function () {\n            return this.content();\n        }\n    });\n});\n","Magento_Ui/js/form/components/group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection'\n], function (_, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            showLabel: true,\n            required: false,\n            template: 'ui/group/group',\n            fieldTemplate: 'ui/form/field',\n            breakLine: true,\n            validateWholeGroup: false,\n            additionalClasses: {}\n        },\n\n        /**\n         * Extends this with defaults and config.\n         * Then calls initObservable, iniListenes and extractData methods.\n         */\n        initialize: function () {\n            this._super()\n                ._setClasses();\n\n            return this;\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('visible')\n                .observe({\n                    required: !!+this.required\n                });\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses,\n                classes;\n\n            if (_.isString(additional)) {\n                additional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__control-grouped': !this.breakLine,\n                'admin__control-fields': this.breakLine,\n                required:   this.required,\n                _error:     this.error,\n                _disabled:  this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Defines if group has only one element.\n         * @return {Boolean}\n         */\n        isSingle: function () {\n            return this.elems.getLength() === 1;\n        },\n\n        /**\n         * Defines if group has multiple elements.\n         * @return {Boolean}\n         */\n        isMultiple: function () {\n            return this.elems.getLength() > 1;\n        },\n\n        /**\n         * Returns an array of child components previews.\n         *\n         * @returns {Array}\n         */\n        getPreview: function () {\n            return this.elems.map('getPreview');\n        }\n    });\n});\n","Magento_Ui/js/form/components/tab_group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/collapsible'\n], function (_, Collapsible) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.validate': 'onValidate'\n            },\n            collapsible: false,\n            opened: true\n        },\n\n        /**\n         * Invokes initElement method of parent class, calls 'initActivation' method\n         * passing element to it.\n         * @param {Object} elem\n         * @returns {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            this._super()\n                .initActivation(elem);\n\n            return this;\n        },\n\n        /**\n         * Activates element if one is first or if one has 'active' propert\n         * set to true.\n         *\n         * @param  {Object} elem\n         * @returns {Object} - reference to instance\n         */\n        initActivation: function (elem) {\n            var elems   = this.elems(),\n                isFirst = !elems.indexOf(elem);\n\n            if (isFirst || elem.active()) {\n                elem.activate();\n            }\n\n            return this;\n        },\n\n        /**\n         * Delegates 'validate' method on element, then reads 'invalid' property\n         * of params storage, and if defined, activates element, sets\n         * 'allValid' property of instance to false and sets invalid's\n         * 'focused' property to true.\n         *\n         * @param {Object} elem\n         */\n        validate: function (elem) {\n            var result  = elem.delegate('validate'),\n                invalid;\n\n            invalid = _.find(result, function (item) {\n                return typeof item !== 'undefined' && !item.valid;\n            });\n\n            if (invalid) {\n                elem.activate();\n                invalid.target.focused(true);\n            }\n\n            return invalid;\n        },\n\n        /**\n         * Sets 'allValid' property of instance to true, then calls 'validate' method\n         * of instance for each element.\n         */\n        onValidate: function () {\n            this.elems.sortBy(function (elem) {\n                return !elem.active();\n            }).some(this.validate, this);\n        }\n    });\n});\n","Magento_Ui/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './insert',\n    'mageUtils',\n    'jquery'\n], function (Insert, utils, $) {\n    'use strict';\n\n    /**\n     * Get page actions element.\n     *\n     * @param {String} elem\n     * @param {String} actionsClass\n     * @returns {String}\n     */\n    function getPageActions(elem, actionsClass) {\n        var el = document.createElement('div');\n\n        el.innerHTML = elem;\n\n        return el.getElementsByClassName(actionsClass)[0];\n    }\n\n    /**\n     * Return element without page actions toolbar\n     *\n     * @param {String} elem\n     * @param {String} actionsClass\n     * @returns {String}\n     */\n    function removePageActions(elem, actionsClass) {\n        var el = document.createElement('div'),\n            actions;\n\n        el.innerHTML = elem;\n        actions = el.getElementsByClassName(actionsClass)[0];\n\n        if (actions) {\n            el.removeChild(actions);\n        }\n\n        return el.innerHTML;\n    }\n\n    return Insert.extend({\n        defaults: {\n            externalFormName: '${ $.ns }.${ $.ns }',\n            pageActionsClass: 'page-actions',\n            actionsContainerClass: 'page-main-actions',\n            exports: {\n                prefix: '${ $.externalFormName }:selectorPrefix'\n            },\n            imports: {\n                toolbarSection: '${ $.toolbarContainer }:toolbarSection',\n                prefix: '${ $.toolbarContainer }:rootSelector',\n                messagesClass: '${ $.externalFormName }:messagesClass'\n            },\n            settings: {\n                ajax: {\n                    ajaxSave: true,\n                    exports: {\n                        ajaxSave: '${ $.externalFormName }:ajaxSave'\n                    },\n                    imports: {\n                        responseStatus: '${ $.externalFormName }:responseStatus',\n                        responseData: '${ $.externalFormName }:responseData'\n                    }\n                }\n            },\n            modules: {\n                externalForm: '${ $.externalFormName }'\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('responseStatus');\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var defaults = this.constructor.defaults;\n\n            utils.extend(defaults, defaults.settings[config.formSubmitType] || {});\n\n            return this._super();\n        },\n\n        /** @inheritdoc*/\n        destroyInserted: function () {\n            if (this.isRendered && this.externalForm()) {\n                this.externalForm().delegate('destroy');\n                this.removeActions();\n                this.responseStatus(undefined);\n                this.responseData = {};\n            }\n\n            return this._super();\n        },\n\n        /** @inheritdoc */\n        onRender: function (data) {\n            var actions = getPageActions(data, this.pageActionsClass);\n\n            if (!data.length) {\n                return this;\n            }\n            data = removePageActions(data, this.pageActionsClass);\n            this.renderActions(actions);\n            this._super(data);\n        },\n\n        /**\n         * Insert actions in toolbar.\n         *\n         * @param {String} actions\n         */\n        renderActions: function (actions) {\n            var $container = $('<div></div>');\n\n            $container\n                .addClass(this.actionsContainerClass)\n                .append(actions);\n\n            this.formHeader = $container;\n\n            $(this.toolbarSection).append(this.formHeader);\n        },\n\n        /**\n         * Remove actions toolbar.\n         */\n        removeActions: function () {\n            $(this.formHeader).siblings('.' + this.messagesClass).remove();\n            $(this.formHeader).remove();\n            this.formHeader = $();\n        },\n\n        /**\n         * Reset external form data.\n         */\n        resetForm: function () {\n            if (this.externalSource()) {\n                this.externalSource().trigger('data.reset');\n                this.responseStatus(undefined);\n            }\n        }\n    });\n});\n","Magento_Ui/js/form/components/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'uiRegistry',\n    'uiLayout',\n    'mageUtils',\n    'underscore'\n], function (Element, registry, layout, utils, _) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            buttonClasses: {},\n            additionalClasses: {},\n            displayArea: 'outsideGroup',\n            displayAsLink: false,\n            elementTmpl: 'ui/form/element/button',\n            template: 'ui/form/components/button/simple',\n            visible: true,\n            disabled: false,\n            title: '',\n            buttonTextId: '',\n            ariLabelledby: ''\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            return this._super()\n                ._setClasses()\n                ._setButtonClasses();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'visible',\n                    'disabled',\n                    'title',\n                    'childError'\n                ]);\n        },\n\n        /**\n         * Performs configured actions\n         */\n        action: function () {\n            this.actions.forEach(this.applyAction, this);\n        },\n\n        /**\n         * Apply action on target component,\n         * but previously create this component from template if it is not existed\n         *\n         * @param {Object} action - action configuration\n         */\n        applyAction: function (action) {\n            var targetName = action.targetName,\n                params = utils.copy(action.params) || [],\n                actionName = action.actionName,\n                target;\n\n            if (!registry.has(targetName)) {\n                this.getFromTemplate(targetName);\n            }\n            target = registry.async(targetName);\n\n            if (target && typeof target === 'function' && actionName) {\n                params.unshift(actionName);\n                target.apply(target, params);\n            }\n        },\n\n        /**\n         * Create target component from template\n         *\n         * @param {Object} targetName - name of component,\n         * that supposed to be a template and need to be initialized\n         */\n        getFromTemplate: function (targetName) {\n            var parentName = targetName.split('.'),\n                index = parentName.pop(),\n                child;\n\n            parentName = parentName.join('.');\n            child = utils.template({\n                parent: parentName,\n                name: index,\n                nodeTemplate: targetName\n            });\n            layout([child]);\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Object} Chainable.\n         */\n        _setClasses: function () {\n            if (typeof this.additionalClasses === 'string') {\n                if (this.additionalClasses === '') {\n                    this.additionalClasses = {};\n\n                    return this;\n                }\n\n                this.additionalClasses = this.additionalClasses\n                    .trim()\n                    .split(' ')\n                    .reduce(function (classes, name) {\n                        classes[name] = true;\n\n                        return classes;\n                    }, {}\n                );\n            }\n\n            return this;\n        },\n\n        /**\n         * Extends 'buttonClasses' object.\n         *\n         * @returns {Object} Chainable.\n         */\n        _setButtonClasses: function () {\n            var additional = this.buttonClasses;\n\n            if (_.isString(additional)) {\n                this.buttonClasses = {};\n\n                if (additional.trim().length) {\n                    additional = additional.trim().split(' ');\n\n                    additional.forEach(function (name) {\n                        if (name.length) {\n                            this.buttonClasses[name] = true;\n                        }\n                    }, this);\n                }\n            }\n\n            _.extend(this.buttonClasses, {\n                'action-basic': !this.displayAsLink,\n                'action-additional': this.displayAsLink\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/components/multiline.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './group'\n], function (Group) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            }\n        },\n\n        /**\n         * Initialize Multiline component.\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            return this._super()\n                ._prepareValue();\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initObservable: function () {\n            this._super()\n                .observe('value');\n\n            return this;\n        },\n\n        /**\n         * Prepare value for Multiline options.\n         *\n         * @returns {Object} Chainable.\n         * @private\n         */\n        _prepareValue: function () {\n            var value = this.value();\n\n            if (typeof value === 'string') {\n                this.value(value.split('\\n'));\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/components/collection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Ui/js/modal/confirm'\n], function (_, utils, registry, Component, layout, confirm) {\n    'use strict';\n\n    var childTemplate = {\n        parent: '${ $.$data.name }',\n        name: '${ $.$data.childIndex }',\n        dataScope: '${ $.name }',\n        nodeTemplate: '${ $.$data.name }.${ $.$data.itemTemplate }'\n    };\n\n    return Component.extend({\n        defaults: {\n            lastIndex: 0,\n            template: 'ui/form/components/collection'\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method.\n         */\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            return this;\n        },\n\n        /**\n         * Activates the incoming child and triggers the update event.\n         *\n         * @param {Object} elem - Incoming child.\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.activate();\n\n            this.bubble('update');\n\n            return this;\n        },\n\n        /**\n         * Loops over corresponding data in data storage,\n         * creates child for each and pushes it's identifier to initialItems array.\n         *\n         * @returns {Collection} Chainable.\n         */\n        initChildren: function () {\n            var children = this.source.get(this.dataScope),\n                initial = this.initialItems = [];\n\n            _.each(children, function (item, index) {\n                initial.push(index);\n                this.addChild(index);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Creates new item of collection, based on incoming 'index'.\n         * If not passed creates one with 'new_' prefix.\n         *\n         * @param {String|Object} [index] - Index of a child.\n         * @returns {Collection} Chainable.\n         */\n        addChild: function (index) {\n            this.childIndex = !_.isString(index) ?\n                'new_' + this.lastIndex++ :\n                index;\n\n            layout([utils.template(childTemplate, this)]);\n\n            return this;\n        },\n\n        /**\n         * Returns true if current set of items differ from initial one,\n         * or if some child has been changed.\n         *\n         * @returns {Boolean}\n         */\n        hasChanged: function () {\n            var initial = this.initialItems,\n                current = this.elems.pluck('index'),\n                changed = !utils.equalArrays(initial, current);\n\n            return changed || this.elems.some(function (elem) {\n                return _.some(elem.delegate('hasChanged'));\n            });\n        },\n\n        /**\n         * Initiates validation of its' children components.\n         *\n         * @returns {Array} An array of validation results.\n         */\n        validate: function () {\n            var elems;\n\n            this.allValid = true;\n\n            elems = this.elems.sortBy(function (elem) {\n                return !elem.active();\n            });\n\n            elems = elems.map(this._validate, this);\n\n            return _.flatten(elems);\n        },\n\n        /**\n         * Iterator function for components validation.\n         * Activates first invalid child component.\n         *\n         * @param {Object} elem - Element to run validation on.\n         * @returns {Array} An array of validation results.\n         */\n        _validate: function (elem) {\n            var result = elem.delegate('validate'),\n                invalid;\n\n            invalid = _.some(result, function (item) {\n                return !item.valid;\n            });\n\n            if (this.allValid && invalid) {\n                this.allValid = false;\n\n                elem.activate();\n            }\n\n            return result;\n        },\n\n        /**\n         * Creates function that removes element\n         * from collection using '_removeChild' method.\n         * @param  {Object} elem - Element that should be removed.\n         * @deprecated Not used anymore\n         */\n        removeAddress: function (elem) {\n            var self = this;\n\n            confirm({\n                content: this.removeMessage,\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        self._removeAddress(elem);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Removes element from both collection and data storage,\n         * activates first element if removed one was active,\n         * triggers 'update' event.\n         *\n         * @param {Object} elem - Element to remove.\n         */\n        _removeAddress: function (elem) {\n            var isActive = elem.active(),\n                first;\n\n            elem.destroy();\n\n            first = this.elems.first();\n\n            if (first && isActive) {\n                first.activate();\n            }\n\n            this.bubble('update');\n        }\n    });\n});\n","Magento_Ui/js/form/components/tab.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiCollection'\n], function (Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            uniqueProp:     'active',\n            active:         false,\n            wasActivated:   false\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            this._super()\n                .setUnique();\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('active wasActivated');\n\n            return this;\n        },\n\n        /**\n         * Sets active property to true, then invokes pushParams method.\n         */\n        activate: function () {\n            this.active(true);\n            this.wasActivated(true);\n\n            this.setUnique();\n\n            return true;\n        }\n    });\n});\n","Magento_Ui/js/form/components/fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/collapsible',\n    'underscore'\n], function (Collapsible, _) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            template: 'ui/form/fieldset',\n            collapsible: false,\n            changed: false,\n            loading: false,\n            error: false,\n            opened: false,\n            level: 0,\n            visible: true,\n            initializeFieldsetDataByDefault: false, /* Data in some fieldsets should be initialized before open */\n            disabled: false,\n            listens: {\n                'opened': 'onVisibilityChange'\n            },\n            additionalClasses: {}\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onChildrenUpdate', 'onChildrenError', 'onContentLoading');\n\n            return this._super()\n                ._setClasses();\n        },\n\n        /**\n         * Initializes components' configuration.\n         *\n         * @returns {Fieldset} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n            this._wasOpened = this.opened || !this.collapsible;\n\n            return this;\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         *\n         * @returns {Object} Reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('changed loading error visible');\n\n            return this;\n        },\n\n        /**\n         * Calls parent's initElement method.\n         * Assigns callbacks on various events of incoming element.\n         *\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            elem.initContainer(this);\n\n            elem.on({\n                'update': this.onChildrenUpdate,\n                'loading': this.onContentLoading,\n                'error': this.onChildrenError\n            });\n\n            if (this.disabled) {\n                try {\n                    elem.disabled(true);\n                }\n                catch (e) {\n\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Is being invoked on children update.\n         * Sets changed property to one incoming.\n         *\n         * @param  {Boolean} hasChanged\n         */\n        onChildrenUpdate: function (hasChanged) {\n            if (!hasChanged) {\n                hasChanged = _.some(this.delegate('hasChanged'));\n            }\n\n            this.bubble('update', hasChanged);\n            this.changed(hasChanged);\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses,\n                classes;\n\n            if (_.isString(additional)) {\n                additional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__collapsible-block-wrapper': this.collapsible,\n                _show: this.opened,\n                _hide: !this.opened,\n                _disabled: this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Handler of the \"opened\" property changes.\n         *\n         * @param {Boolean} isOpened\n         */\n        onVisibilityChange: function (isOpened) {\n            if (!this._wasOpened) {\n                this._wasOpened = isOpened;\n            }\n        },\n\n        /**\n         * Is being invoked on children validation error.\n         * Sets error property to one incoming.\n         *\n         * @param {String} message - error message.\n         */\n        onChildrenError: function (message) {\n            var hasErrors = false;\n\n            if (!message) {\n                hasErrors = this._isChildrenHasErrors(hasErrors, this);\n            }\n\n            this.error(hasErrors || message);\n\n            if (hasErrors || message) {\n                this.open();\n            }\n        },\n\n        /**\n         * Returns errors of children if exist\n         *\n         * @param {Boolean} hasErrors\n         * @param {*} container\n         * @return {Boolean}\n         * @private\n         */\n        _isChildrenHasErrors: function (hasErrors, container) {\n            var self = this;\n\n            if (hasErrors === false && container.hasOwnProperty('elems')) {\n                hasErrors = container.elems.some('error');\n\n                if (hasErrors === false && container.hasOwnProperty('_elems')) {\n                    container._elems.forEach(function (child) {\n\n                        if (hasErrors === false) {\n                            hasErrors = self._isChildrenHasErrors(hasErrors, child);\n                        }\n                    });\n                }\n            }\n\n            return hasErrors;\n        },\n\n        /**\n         * Callback that sets loading property to true.\n         */\n        onContentLoading: function (isLoading) {\n            this.loading(isLoading);\n        }\n    });\n});\n","Magento_Ui/js/form/components/area.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './tab'\n], function (_, Tab) {\n    'use strict';\n\n    return Tab.extend({\n        defaults: {\n            uniqueNs:   'params.activeArea',\n            template:   'ui/area',\n            changed:    false,\n            loading:    false\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onChildrenUpdate', 'onContentLoading');\n\n            return this._super();\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('changed loading');\n\n            return this;\n        },\n\n        /**\n         * Calls parent's initElement method.\n         * Assigns callbacks on various events of incoming element.\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.on({\n                'update':   this.onChildrenUpdate,\n                'loading':  this.onContentLoading\n            });\n\n            return this;\n        },\n\n        /**\n         * Is being invoked on children update.\n         * Sets changed property to one incoming.\n         * Invokes setActive method if settings\n         * contain makeVisible property set to true.\n         *\n         * @param  {Boolean} hasChanged\n         */\n        onChildrenUpdate: function (hasChanged) {\n            if (!hasChanged) {\n                hasChanged = _.some(this.delegate('hasChanged'));\n            }\n\n            this.changed(hasChanged);\n        },\n\n        /**\n         * Callback that sets loading property to true.\n         */\n        onContentLoading: function (isLoading) {\n            this.loading(isLoading);\n        }\n    });\n});\n","Magento_Ui/js/form/components/collection/item.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    '../tab'\n], function (_, utils, Tab) {\n    'use strict';\n\n    var previewConfig = {\n        separator: ' ',\n        prefix: ''\n    };\n\n    /**\n     * Parses incoming data and returns result merged with default preview config\n     *\n     * @param  {Object|String} data\n     * @return {Object}\n     */\n    function parsePreview(data) {\n        if (typeof data == 'string') {\n            data = {\n                items: data\n            };\n        }\n\n        data.items = utils.stringToArray(data.items);\n\n        return _.defaults(data, previewConfig);\n    }\n\n    return Tab.extend({\n        defaults: {\n            label: '',\n            uniqueNs: 'activeCollectionItem',\n            previewTpl: 'ui/form/components/collection/preview'\n        },\n\n        /**\n         * Extends instance with default config, calls initializes of parent class\n         */\n        initialize: function () {\n            _.bindAll(this, 'buildPreview', 'hasPreview');\n\n            return this._super();\n        },\n\n        /**\n         * Calls initProperties of parent class, initializes properties\n         * of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initConfig: function () {\n            this._super();\n\n            this.displayed = [];\n\n            return this;\n        },\n\n        /**\n         * Calls initObservable of parent class, initializes observable\n         * properties of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    noPreview: true,\n                    indexed: {}\n                });\n\n            return this;\n        },\n\n        /**\n         * Is being called when child element has been initialized,\n         *     calls initElement of parent class, binds to element's update event,\n         *     calls insertToArea and insertToIndexed methods passing element to it\n         *\n         * @param  {Object} elem\n         */\n        initElement: function (elem) {\n            this._super()\n                .insertToIndexed(elem);\n\n            return this;\n        },\n\n        /**\n         * Adds element to observable indexed object of instance\n         *\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        insertToIndexed: function (elem) {\n            var indexed = this.indexed();\n\n            indexed[elem.index] = elem;\n\n            this.indexed(indexed);\n\n            return this;\n        },\n\n        /**\n         * Destroys current instance along with all of its' children.\n         * Overrides base method to clear data when this method is called.\n         */\n        destroy: function () {\n            this._super();\n            this._clearData();\n        },\n\n        /**\n         * Clears all data associated with component.\n         * @private\n         *\n         * @returns {Item} Chainable.\n         */\n        _clearData: function () {\n            this.source.remove(this.dataScope);\n\n            return this;\n        },\n\n        /**\n         * Formats incoming previews array via parsePreview function.\n         *\n         * @param  {Array} previews\n         * @return {Array} - formatted previews\n         */\n        formatPreviews: function (previews) {\n            return previews.map(parsePreview);\n        },\n\n        /**\n         * Creates string view of previews\n         *\n         * @param  {Object} data\n         * @return {Strict} - formatted preview string\n         */\n        buildPreview: function (data) {\n            var preview = this.getPreview(data.items),\n                prefix = data.prefix;\n\n            return prefix + preview.join(data.separator);\n        },\n\n        /**\n         * Defines if instance has preview for incoming data\n         *\n         * @param  {Object}  data\n         * @return {Boolean}\n         */\n        hasPreview: function (data) {\n            return !!this.getPreview(data.items).length;\n        },\n\n        /**\n         * Creates an array of previews for elements specified in incoming\n         * items array, calls updatePreview afterwards.\n         *\n         * @param  {Array} items - An array of element's indexes.\n         * @returns {Array} An array of previews.\n         */\n        getPreview: function (items) {\n            var elems = this.indexed(),\n                displayed = this.displayed,\n                preview;\n\n            items = items.map(function (index) {\n                var elem = elems[index];\n\n                preview = elem && elem.visible() ? elem.getPreview() : '';\n\n                preview = Array.isArray(preview) ?\n                    _.compact(preview).join(', ') :\n                    preview;\n\n                utils.toggle(displayed, index, !!preview);\n\n                return preview;\n            });\n\n            this.noPreview(!displayed.length);\n\n            return _.compact(items);\n        }\n    });\n});\n","Magento_Ui/js/form/adapter/buttons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        'reset': '#reset',\n        'save': '#save',\n        'saveAndContinue': '#save_and_continue'\n    };\n});\n","Magento_Ui/js/form/element/single-checkbox-use-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isUseDefault: false,\n            isUseConfig: false,\n            listens: {\n                'isUseConfig': 'toggleElement',\n                'isUseDefault': 'toggleElement'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n\n            return this\n                ._super()\n                .observe('isUseConfig');\n        },\n\n        /**\n         * Toggle element\n         */\n        toggleElement: function () {\n            this.disabled(this.isUseDefault() || this.isUseConfig());\n\n            if (this.source) {\n                this.source.set('data.use_default.' + this.index, Number(this.isUseDefault()));\n            }\n        }\n    });\n});\n","Magento_Ui/js/form/element/single-checkbox-toggle-notice.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (SingleCheckbox) {\n    'use strict';\n\n    return SingleCheckbox.extend({\n        defaults: {\n            notices: [],\n            tracks: {\n                notice: true\n            }\n        },\n\n        /**\n         * Choose notice on initialization\n         *\n         * @returns {*|void|Element}\n         */\n        initialize: function () {\n            this._super()\n                .chooseNotice();\n\n            return this;\n        },\n\n        /**\n         * Choose notice function\n         *\n         * @returns void\n         */\n        chooseNotice: function () {\n            var checkedNoticeNumber = Number(this.checked());\n\n            this.notice = this.notices[checkedNoticeNumber];\n        },\n\n        /**\n         * Choose notice on update\n         *\n         * @returns void\n         */\n        onUpdate: function () {\n            this._super();\n            this.chooseNotice();\n        }\n    });\n});\n","Magento_Ui/js/form/element/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'mageUtils'\n], function (Element, utils) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            error: '',\n            uid: utils.uniqueid(),\n            disabled: false,\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            }\n        },\n\n        /**\n         * Has service\n         *\n         * @returns {Boolean} false.\n         */\n        hasService: function () {\n            return false;\n        },\n\n        /**\n         * Has addons\n         *\n         * @returns {Boolean} false.\n         */\n        hasAddons: function () {\n            return false;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('disabled visible value');\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/media.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mageUtils',\n    './abstract'\n], function (utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: ''\n            }\n        },\n\n        /**\n         * Initializes file component.\n         *\n         * @returns {Media} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFormId();\n\n            return this;\n        },\n\n        /**\n         * Defines form ID with which file input will be associated.\n         *\n         * @returns {Media} Chainable.\n         */\n        initFormId: function () {\n            var namespace;\n\n            if (this.formId) {\n                return this;\n            }\n\n            namespace   = this.name.split('.');\n            this.formId = namespace[0];\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './abstract',\n    'Magento_Ui/js/lib/key-codes',\n    'mage/translate',\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, Abstract, keyCodes, $t, ko, $) {\n    'use strict';\n\n    var isTouchDevice = typeof document.ontouchstart !== 'undefined';\n\n    /**\n     * Processing options list\n     *\n     * @param {Array} array - Property array\n     * @param {String} separator - Level separator\n     * @param {Array} created - list to add new options\n     *\n     * @return {Array} Plain options list\n     */\n    function flattenCollection(array, separator, created) {\n        var i = 0,\n            length,\n            childCollection;\n\n        array = _.compact(array);\n        length = array.length;\n        created = created || [];\n\n        for (i; i < length; i++) {\n            created.push(array[i]);\n\n            if (array[i].hasOwnProperty(separator)) {\n                childCollection = array[i][separator];\n                delete array[i][separator];\n                flattenCollection.call(this, childCollection, separator, created);\n            }\n        }\n\n        return created;\n    }\n\n    /**\n     * Set levels to options list\n     *\n     * @param {Array} array - Property array\n     * @param {String} separator - Level separator\n     * @param {Number} level - Starting level\n     * @param {String} path - path to root\n     *\n     * @returns {Array} Array with levels\n     */\n    function setProperty(array, separator, level, path) {\n        var i = 0,\n            length,\n            nextLevel,\n            nextPath;\n\n        array = _.compact(array);\n        length = array.length;\n        level = level || 0;\n        path = path || '';\n\n        for (i; i < length; i++) {\n            if (array[i]) {\n                _.extend(array[i], {\n                    level: level,\n                    path: path\n                });\n            }\n\n            if (array[i].hasOwnProperty(separator)) {\n                nextLevel = level + 1;\n                nextPath = path ? path + '.' + array[i].label : array[i].label;\n                setProperty.call(this, array[i][separator], separator, nextLevel, nextPath);\n            }\n        }\n\n        return array;\n    }\n\n    /**\n     * Preprocessing options list\n     *\n     * @param {Array} nodes - Options list\n     *\n     * @return {Object} Object with property - options(options list)\n     *      and cache options with plain and tree list\n     */\n    function parseOptions(nodes) {\n        var caption,\n            value,\n            cacheNodes,\n            copyNodes;\n\n        nodes = setProperty(nodes, 'optgroup');\n        copyNodes = JSON.parse(JSON.stringify(nodes));\n        cacheNodes = flattenCollection(copyNodes, 'optgroup');\n\n        nodes = _.map(nodes, function (node) {\n            value = node.value;\n\n            if (value == null || value === '') {\n                if (_.isUndefined(caption)) {\n                    caption = node.label;\n                }\n            } else {\n                return node;\n            }\n        });\n\n        return {\n            options: _.compact(nodes),\n            cacheOptions: {\n                plain: _.compact(cacheNodes),\n                tree: _.compact(nodes)\n            }\n        };\n    }\n\n    return Abstract.extend({\n        defaults: {\n            options: [],\n            total: 0,\n            listVisible: false,\n            value: [],\n            filterOptions: false,\n            chipsEnabled: true,\n            itemsQuantity: '',\n            filterInputValue: '',\n            filterOptionsFocus: false,\n            multiselectFocus: false,\n            multiple: true,\n            selectType: 'tree',\n            lastSelectable: false,\n            showFilteredQuantity: true,\n            showCheckbox: true,\n            levelsVisibility: true,\n            openLevelsAction: true,\n            showOpenLevelsActionIcon: true,\n            optgroupLabels: false,\n            closeBtn: true,\n            showPath: true,\n            labelsDecoration: false,\n            disableLabel: false,\n            filterRateLimit: 500,\n            filterRateLimitMethod: 'notifyAtFixedRate',\n            closeBtnLabel: $t('Done'),\n            optgroupTmpl: 'ui/grid/filters/elements/ui-select-optgroup',\n            quantityPlaceholder: $t('options'),\n            hoverClass: '_hover',\n            rootListSelector: 'ul.admin__action-multiselect-menu-inner._root',\n            visibleOptionSelector: 'li.admin__action-multiselect-menu-inner-item:visible',\n            actionTargetSelector: '.action-menu-item',\n            selectedPlaceholders: {\n                defaultPlaceholder: $t('Select...'),\n                lotPlaceholders: $t('Selected')\n            },\n            separator: 'optgroup',\n            searchOptions: false,\n            loading: false,\n            searchUrl: false,\n            lastSearchKey: '',\n            lastSearchPage: 1,\n            filterPlaceholder: '',\n            emptyOptionsHtml: '',\n            cachedSearchResults: {},\n            pageLimit: 50,\n            deviation: 30,\n            validationLoading: false,\n            isRemoveSelectedIcon: false,\n            debounce: 300,\n            missingValuePlaceholder: $t('Entity with ID: %s doesn\\'t exist'),\n            isDisplayMissingValuePlaceholder: false,\n            currentSearchKey: '',\n            listens: {\n                listVisible: 'cleanHoveredElement',\n                filterInputValue: 'filterOptionsList',\n                options: 'checkOptionsList'\n            },\n            presets: {\n                single: {\n                    showCheckbox: false,\n                    chipsEnabled: false,\n                    closeBtn: false\n                },\n                optgroup: {\n                    showCheckbox: false,\n                    lastSelectable: true,\n                    optgroupLabels: true,\n                    openLevelsAction: false,\n                    labelsDecoration: true,\n                    showOpenLevelsActionIcon: false\n                }\n            }\n        },\n\n        /**\n         * Initializes UISelect component.\n         *\n         * @returns {UISelect} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            $.async(\n                this.rootListSelector,\n                this,\n                this.onRootListRender.bind(this)\n            );\n\n            return this;\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         * Set defaults according to mode and levels configuration\n         *\n         * @param  {Object} config\n         * @returns {Object} Chainable.\n         */\n        initConfig: function (config) {\n            var result = parseOptions(config.options),\n                defaults = this.constructor.defaults,\n                multiple = _.isBoolean(config.multiple) ? config.multiple : defaults.multiple,\n                type = config.selectType || defaults.selectType,\n                showOpenLevelsActionIcon = _.isBoolean(config.showOpenLevelsActionIcon) ?\n                    config.showOpenLevelsActionIcon :\n                    defaults.showOpenLevelsActionIcon,\n                openLevelsAction = _.isBoolean(config.openLevelsAction) ?\n                    config.openLevelsAction :\n                    defaults.openLevelsAction;\n\n            multiple = !multiple ? 'single' : false;\n            config.showOpenLevelsActionIcon = showOpenLevelsActionIcon && openLevelsAction;\n            _.extend(config, result, defaults.presets[multiple], defaults.presets[type]);\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Check child optgroup\n         */\n        hasChildList: function () {\n            return _.find(this.options(), function (option) {\n                return !!option[this.separator];\n            }, this);\n        },\n\n        /**\n         * Check tree mode\n         */\n        isTree: function () {\n            return this.hasChildList() && this.selectType !== 'optgroup';\n        },\n\n        /**\n         * Add option to lastOptions array\n         *\n         * @param {Object} data\n         * @returns {Boolean}\n         */\n        addLastElement: function (data) {\n            if (!data.hasOwnProperty(this.separator)) {\n                !this.cacheOptions.lastOptions ? this.cacheOptions.lastOptions = [] : false;\n\n                if (!_.findWhere(\n                    this.cacheOptions.lastOptions,\n                        {\n                            value: data.value\n                        }\n                    )\n                ) {\n                    this.cacheOptions.lastOptions.push(data);\n                }\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Return empty options html\n         */\n        getEmptyOptionsUnsanitizedHtml: function () {\n            return this.emptyOptionsHtml;\n        },\n\n        /**\n         * Check options length and set to cache\n         * if some options is added\n         *\n         * @param {Array} options - ui select options\n         */\n        checkOptionsList: function (options) {\n            if (options.length > this.cacheOptions.plain.length) {\n                this.cacheOptions.plain = options;\n                this.setCaption();\n            }\n        },\n\n        /**\n         * Check label decoration\n         */\n        isLabelDecoration: function (data) {\n            return data.hasOwnProperty(this.separator) && this.labelsDecoration;\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe([\n                'listVisible',\n                'placeholder',\n                'multiselectFocus',\n                'options',\n                'itemsQuantity',\n                'filterInputValue',\n                'filterOptionsFocus',\n                'loading',\n                'validationLoading',\n                'isDisplayMissingValuePlaceholder'\n            ]);\n\n            this.filterInputValue.extend({\n                rateLimit: {\n                    timeout: this.filterRateLimit,\n                    method: this.filterRateLimitMethod\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * object with key - keyname and value - handler function for this key\n         *\n         * @returns {Object} Object with handlers function name.\n         */\n        keyDownHandlers: function () {\n            return {\n                enterKey: this.enterKeyHandler,\n                escapeKey: this.escapeKeyHandler,\n                spaceKey: this.enterKeyHandler,\n                pageUpKey: this.pageUpKeyHandler,\n                pageDownKey: this.pageDownKeyHandler\n            };\n        },\n\n        /**\n         * Processing level visibility for levels\n         *\n         * @param {Object} data - element data\n         *\n         * @returns {Boolean} level visibility.\n         */\n        showLevels: function (data) {\n            var curLevel = ++data.level,\n                isVisible;\n\n            if (data.visible) {\n                isVisible = data.visible();\n            } else {\n                isVisible = !!data.hasOwnProperty(this.separator) &&\n                    _.isBoolean(this.levelsVisibility) &&\n                    this.levelsVisibility ||\n                    data.hasOwnProperty(this.separator) && parseInt(this.levelsVisibility, 10) >= curLevel;\n\n                data.visible = ko.observable(isVisible);\n                data.isVisited = isVisible;\n            }\n\n            return isVisible;\n        },\n\n        /**\n         * Processing level visibility for levels\n         *\n         * @param {Object} data - element data\n         *\n         * @returns {Boolean} level visibility.\n         */\n        getLevelVisibility: function (data) {\n            if (data.visible) {\n                return data.visible();\n            }\n\n            return this.showLevels(data);\n        },\n\n        /**\n         * Set option to options array.\n         *\n         * @param {Object} option\n         * @param {Array} options\n         */\n        setOption: function (option, options) {\n            var copyOptionsTree;\n\n            options = options || this.cacheOptions.tree;\n\n            _.each(options, function (opt) {\n                if (opt.value == option.parent) { //eslint-disable-line eqeqeq\n                    delete  option.parent;\n                    opt[this.separator] ? opt[this.separator].push(option) : opt[this.separator] = [option];\n                    copyOptionsTree = JSON.parse(JSON.stringify(this.cacheOptions.tree));\n                    this.cacheOptions.plain = flattenCollection(copyOptionsTree, this.separator);\n                    this.options(this.cacheOptions.tree);\n                } else if (opt[this.separator]) {\n                    this.setOption(option, opt[this.separator]);\n                }\n            }, this);\n        },\n\n        /**\n         * Handler outerClick event. Closed options list\n         */\n        outerClick: function () {\n            this.listVisible() ? this.listVisible(false) : false;\n\n            if (isTouchDevice) {\n                this.multiselectFocus(false);\n            }\n        },\n\n        /**\n         * Handler keydown event to filter options input\n         *\n         * @returns {Boolean} Returned true for emersion events\n         */\n        filterOptionsKeydown: function (data, event) {\n            var key = keyCodes[event.keyCode];\n\n            !this.isTabKey(event) ? event.stopPropagation() : false;\n\n            if (key === 'pageDownKey' || key === 'pageUpKey') {\n                event.preventDefault();\n                this.filterOptionsFocus(false);\n                this.cacheUiSelect.focus();\n            }\n\n            this.keydownSwitcher(data, event);\n\n            return true;\n        },\n\n        /**\n         * Filtered options list by value from filter options list\n         */\n        filterOptionsList: function () {\n            var value = this.filterInputValue().trim().toLowerCase(),\n                array = [];\n\n            if (this.searchOptions) {\n                return this.loadOptions(value);\n            }\n\n            this.cleanHoveredElement();\n\n            if (!value) {\n                this.renderPath = false;\n                this.options(this.cacheOptions.tree);\n                this._setItemsQuantity(false);\n\n                return false;\n            }\n\n            this.showPath ? this.renderPath = true : false;\n\n            if (this.filterInputValue()) {\n\n                array = this.selectType === 'optgroup' ?\n                    this._getFilteredArray(this.cacheOptions.lastOptions, value) :\n                    this._getFilteredArray(this.cacheOptions.plain, value);\n\n                if (!value.length) {\n                    this.options(this.cacheOptions.plain);\n                    this._setItemsQuantity(this.cacheOptions.plain.length);\n                } else {\n                    this.options(array);\n                    this._setItemsQuantity(array.length);\n                }\n\n                return false;\n            }\n\n            this.options(this.cacheOptions.plain);\n        },\n\n        /**\n         * Filtered options list by value from filter options list\n         *\n         * @param {Array} list - option list\n         * @param {String} value\n         *\n         * @returns {Array} filters result\n         */\n        _getFilteredArray: function (list, value) {\n            var i = 0,\n                array = [],\n                curOption;\n\n            for (i; i < list.length; i++) {\n                curOption = list[i].label.toLowerCase();\n\n                if (curOption.indexOf(value) > -1) {\n                    array.push(list[i]); /*eslint max-depth: [2, 4]*/\n                }\n            }\n\n            return array;\n        },\n\n        /**\n         * Get path to current option\n         *\n         * @param {Object} data - option data\n         * @returns {String} path\n         */\n        getPath: function (data) {\n            var pathParts,\n                createdPath = '';\n\n            if (this.renderPath) {\n                pathParts = data.path.split('.');\n                _.each(pathParts, function (curData) {\n                    createdPath = createdPath ? createdPath + ' / ' + curData : curData;\n                });\n\n                return createdPath;\n            }\n        },\n\n        /**\n         * Set filtered items quantity\n         *\n         * @param {Object} data - option data\n         */\n        _setItemsQuantity: function (data) {\n            if (this.showFilteredQuantity) {\n                data || parseInt(data, 10) === 0 ?\n                    this.itemsQuantity(this.getItemsPlaceholder(data)) :\n                    this.itemsQuantity('');\n            }\n        },\n\n        /**\n         * Return formatted items placeholder.\n         *\n         * @param {Object} data - option data\n         * @returns {String}\n         */\n        getItemsPlaceholder: function (data) {\n            return data + ' ' + this.quantityPlaceholder;\n        },\n\n        /**\n         * Remove element from selected array\n         */\n        removeSelected: function (value, data, event) {\n            event ? event.stopPropagation() : false;\n            this.value.remove(value);\n        },\n\n        /**\n         * Checked key name\n         *\n         * @returns {Boolean}\n         */\n        isTabKey: function (event) {\n            return keyCodes[event.keyCode] === 'tabKey';\n        },\n\n        /**\n         * Clean hoveredElement variable\n         *\n         * @returns {Object} Chainable\n         */\n        cleanHoveredElement: function () {\n            if (this.hoveredElement) {\n                $(this.hoveredElement)\n                    .children(this.actionTargetSelector)\n                    .removeClass(this.hoverClass);\n\n                this.hoveredElement = null;\n            }\n\n            return this;\n        },\n\n        /**\n         * Check selected option\n         *\n         * @param {String} value - option value\n         * @return {Boolean}\n         */\n        isSelected: function (value) {\n            return this.multiple ? _.contains(this.value(), value) : this.value() === value;\n        },\n\n        /**\n         * Check selected option\n         *\n         * @param {Object} option - option value\n         * @return {Boolean}\n         */\n        isSelectedValue: function (option) {\n            if (_.isUndefined(option)) {\n                return false;\n            }\n\n            return this.isSelected(option.value);\n        },\n\n        /**\n         * Check optgroup label\n         *\n         * @param {Object} data - element data\n         * @return {Boolean}\n         */\n        isOptgroupLabels: function (data) {\n            return data.hasOwnProperty(this.separator) && this.optgroupLabels;\n        },\n\n        /**\n         * Check hovered option\n         *\n         * @param {Object} data - element data\n         * @return {Boolean}\n         */\n        isHovered: function (data) {\n            var element = this.hoveredElement,\n                elementData;\n\n            if (!element) {\n                return false;\n            }\n\n            elementData = ko.dataFor(this.hoveredElement);\n\n            if (_.isUndefined(elementData)) {\n                return false;\n            }\n\n            return data.value === elementData.value;\n        },\n\n        /**\n         * Toggle list visibility\n         *\n         * @returns {Object} Chainable\n         */\n        toggleListVisible: function () {\n            this.listVisible(!this.disabled() && !this.listVisible());\n\n            return this;\n        },\n\n        /**\n         * Get selected element labels\n         *\n         * @returns {Array} array labels\n         */\n        getSelected: function () {\n            var selected = this.value();\n\n            return this.cacheOptions.plain.filter(function (opt) {\n                return _.isArray(selected) ?\n                    _.contains(selected, opt.value) :\n                selected == opt.value;//eslint-disable-line eqeqeq\n            });\n        },\n\n        /**\n         * Toggle activity list element\n         *\n         * @param {Object} data - selected option data\n         * @returns {Object} Chainable\n         */\n        toggleOptionSelected: function (data) {\n            var isSelected = this.isSelected(data.value);\n\n            if (this.lastSelectable && data.hasOwnProperty(this.separator)) {\n                return this;\n            }\n\n            if (!this.multiple) {\n                if (!isSelected) {\n                    this.value(data.value);\n                }\n                this.listVisible(false);\n            } else {\n                if (!isSelected) { /*eslint no-lonely-if: 0*/\n                    this.value.push(data.value);\n                } else {\n                    this.value(_.without(this.value(), data.value));\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Change visibility to child level\n         *\n         * @param {Object} data - element data\n         */\n        openChildLevel: function (data) {\n            var contextElement = data,\n                isVisible;\n\n            if (\n                this.openLevelsAction &&\n                data.hasOwnProperty(this.separator) && _.isBoolean(this.levelsVisibility) ||\n                this.openLevelsAction &&\n                data.hasOwnProperty(this.separator) && parseInt(this.levelsVisibility, 10) <= data.level\n            ) {\n                isVisible = !contextElement.visible();\n\n                if (isVisible && !contextElement.isVisited) {\n                    contextElement.isVisited = true;\n                }\n\n                contextElement.visible(isVisible);\n            }\n        },\n\n        /**\n         * Check selected elements\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            if (!this.value()) {\n                this.value([]);\n            }\n\n            return this.value() ? !!this.value().length : false;\n        },\n\n        /**\n         * Handles hover on list items.\n         *\n         * @param {Object} event - mousemove event\n         */\n        onDelegatedMouseMove: function (event) {\n            var target = $(event.currentTarget).closest(this.visibleOptionSelector)[0];\n\n            if (this.isCursorPositionChange(event) || this.hoveredElement === target) {\n                return;\n            }\n\n            this._hoverTo(target);\n            this.setCursorPosition(event);\n        },\n\n        /**\n         * Get option index\n         *\n         * @param {Object} data - object with data about this element\n         *\n         * @returns {Number}\n         */\n        getOptionIndex: function (data) {\n            var index;\n\n            _.each(this.cacheOptions.plain, function (opt, id) {\n                if (data.value === opt.value) {\n                    index = id;\n                }\n            });\n\n            return index;\n        },\n\n        /**\n         * Set X and Y cursor position\n         *\n         * @param {Object} event - mousemove event\n         */\n        setCursorPosition: function (event) {\n            this.cursorPosition = {\n                x: event.pageX,\n                y: event.pageY\n            };\n        },\n\n        /**\n         * Check previous and current cursor position\n         *\n         * @param {Object} event - mousemove event\n         * @returns {Boolean}\n         */\n        isCursorPositionChange: function (event) {\n            return this.cursorPosition &&\n                this.cursorPosition.x === event.pageX &&\n                this.cursorPosition.y === event.pageY;\n        },\n\n        /**\n         * Set true to observable variable multiselectFocus\n         * @param {Object} ctx\n         * @param {Object} event - focus event\n         */\n        onFocusIn: function (ctx, event) {\n            !this.cacheUiSelect ? this.cacheUiSelect = event.target : false;\n            this.multiselectFocus(true);\n        },\n\n        /**\n         * Set false to observable variable multiselectFocus\n         * and close list\n         */\n        onFocusOut: function () {\n            this.multiselectFocus(false);\n        },\n\n        /**\n         * Handler enter key, if select list is closed - open select,\n         * if select list is open toggle selected current option\n         */\n        enterKeyHandler: function () {\n\n            if (this.filterOptionsFocus()) {\n                return false;\n            }\n\n            if (this.listVisible()) {\n                if (this.hoveredElement) {\n                    this.toggleOptionSelected(ko.dataFor(this.hoveredElement));\n                }\n            } else {\n                this.setListVisible(true);\n            }\n        },\n\n        /**\n         * Handler escape key, if select list is open - closes it,\n         */\n        escapeKeyHandler: function () {\n            this.listVisible() ? this.setListVisible(false) : false;\n        },\n\n        /**\n         * Handler pageDown key, selected next option in list, if current option is last\n         * selected first option in list\n         */\n        pageDownKeyHandler: function () {\n            this._setHoverToElement(1);\n        },\n\n        /**\n         * Get jQuery element by option data\n         *\n         * @param {Object} data - option data\n         *\n         * @returns {Object} jQuery element\n         */\n        _getElemByData: function (data) {\n            var i = 0,\n                list = $(this.cacheUiSelect).find('li'),\n                length = this.options().length,\n                result;\n\n            for (i; i < length; i++) {\n                if (this.options()[i].value === data.value) {\n                    result = $(list[i]);\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Set hover to visible element\n         *\n         * @param {Number} direction - iterator\n         */\n        _setHoverToElement: function (direction) {\n            var element;\n\n            if (direction ===  1) {\n                element = this._getNextElement();\n            } else if (direction === -1) {\n                element = this._getPreviousElement();\n            }\n\n            if (element) {\n                this._hoverTo(element);\n                this._scrollTo(element);\n            }\n        },\n\n        /**\n         * Find current hovered element\n         * and change scroll position\n         *\n         * @param {Number} element - element index\n         */\n        _scrollTo: function (element) {\n            var curEl = $(element).children(this.actionTargetSelector),\n                wrapper = $(this.rootList),\n                curElPos = {},\n                wrapperPos = {};\n\n            curElPos.start = curEl.offset().top;\n            curElPos.end = curElPos.start + curEl.outerHeight();\n\n            wrapperPos.start = wrapper.offset().top;\n            wrapperPos.end = wrapperPos.start + wrapper.height();\n\n            if (curElPos.start < wrapperPos.start) {\n                wrapper.scrollTop(wrapper.scrollTop() - (wrapperPos.start - curElPos.start));\n            } else if (curElPos.end > wrapperPos.end) {\n                wrapper.scrollTop(wrapper.scrollTop() + curElPos.end - wrapperPos.end);\n            }\n        },\n\n        /**\n         * Handler pageUp key, selected previous option in list, if current option is first -\n         * selected last option in list\n         */\n        pageUpKeyHandler: function () {\n            this._setHoverToElement(-1);\n        },\n\n        /**\n         * Switcher to parse keydown event and delegate event to needful method\n         *\n         * @param {Object} data - element data\n         * @param {Object} event - keydown event\n         * @returns {Boolean} if handler for this event doesn't found return true\n         */\n        keydownSwitcher: function (data, event) {\n            var keyName = keyCodes[event.keyCode];\n\n            if (this.isTabKey(event)) {\n                if (!this.filterOptionsFocus() && this.listVisible() && this.filterOptions) {\n                    this.cacheUiSelect.trigger('blur');\n                    this.filterOptionsFocus(true);\n                    this.cleanHoveredElement();\n\n                    return false;\n                }\n                this.listVisible(false);\n\n                return true;\n            }\n\n            if (this.keyDownHandlers().hasOwnProperty(keyName)) {\n                this.keyDownHandlers()[keyName].apply(this, arguments);\n            } else {\n                return true;\n            }\n        },\n\n        /**\n         * Set caption\n         */\n        setCaption: function () {\n            var length, caption = '';\n\n            if (!_.isArray(this.value()) && this.value()) {\n                length = 1;\n            } else if (this.value()) {\n                length = this.value().length;\n            } else {\n                this.value([]);\n                length = 0;\n            }\n            this.warn(caption);\n\n            //check if option was removed\n            if (this.isDisplayMissingValuePlaceholder && length && !this.getSelected().length) {\n                caption = this.missingValuePlaceholder.replace('%s', this.value());\n                this.placeholder(caption);\n                this.warn(caption);\n\n                return this.placeholder();\n            }\n\n            if (length > 1) {\n                this.placeholder(length + ' ' + this.selectedPlaceholders.lotPlaceholders);\n            } else if (length && this.getSelected().length) {\n                this.placeholder(this.getSelected()[0].label);\n            } else {\n                this.placeholder(this.selectedPlaceholders.defaultPlaceholder);\n            }\n\n            return this.placeholder();\n        },\n\n        /**\n         * Set list status, open or close\n         *\n         * @param {Boolean} value - variable for set list visible status\n         */\n        setListVisible: function (value) {\n            this.listVisible(value);\n        },\n\n        /**\n         * Processes preview for option by it's value, and sets the result\n         * to 'preview' observable\n         *\n         * @returns {String}\n         */\n        getPreview: function () {\n            var selected = this.getSelected();\n\n            return selected.map(function (option) {\n                return option.label;\n            }).join(', ');\n        },\n\n        /**\n         * Defines previous option element to\n         * the one that is currently hovered.\n         *\n         * @returns {Element}\n         */\n        _getPreviousElement: function () {\n            var currentElement = this.hoveredElement,\n                lastElement    = this._getLastIn(this.rootList),\n                previousElement;\n\n            if (!currentElement) {\n                return lastElement;\n            }\n\n            previousElement = $(currentElement).prev()[0];\n\n            return this._getLastIn(previousElement) ||\n                previousElement ||\n                this._getFirstParentOf(currentElement) ||\n                lastElement;\n        },\n\n        /**\n         * Defines next option element to\n         * the one that is currently hovered.\n         *\n         * @returns {Element}\n         */\n        _getNextElement: function () {\n            var currentElement = this.hoveredElement,\n                firstElement   = this._getFirstIn(this.rootList);\n\n            if (!currentElement) {\n                return firstElement;\n            }\n\n            return this._getFirstIn(currentElement) ||\n                $(currentElement).next()[0] ||\n                this._getParentsOf(currentElement).next()[0] ||\n                firstElement;\n        },\n\n        /**\n         * Returns first option element in provided scope.\n         *\n         * @param {Element} scope\n         * @returns {Element}\n         */\n        _getFirstIn: function (scope) {\n            return $(scope).find(this.visibleOptionSelector)[0];\n        },\n\n        /**\n         * Returns last descendant option element in provided scope.\n         *\n         * @param {Element} scope\n         * @returns {Element}\n         */\n        _getLastIn: function (scope) {\n            return $(scope).find(this.visibleOptionSelector).last()[0];\n        },\n\n        /**\n         * Returns a collection of parent option elements.\n         *\n         * @param {Element} scope\n         * @returns {jQueryCollection}\n         */\n        _getParentsOf: function (scope) {\n            return $(scope).parents(this.visibleOptionSelector);\n        },\n\n        /**\n         * Returns first parent option element.\n         *\n         * @param {Element} scope\n         * @returns {Element}\n         */\n        _getFirstParentOf: function (scope) {\n            return this._getParentsOf(scope)[0];\n        },\n\n        /**\n         * Sets hover class to provided option element.\n         *\n         * @param {Element} element\n         */\n        _hoverTo: function (element) {\n            if (this.hoveredElement) {\n                $(this.hoveredElement)\n                    .children(this.actionTargetSelector)\n                    .removeClass(this.hoverClass);\n            }\n\n            $(element)\n                .children(this.actionTargetSelector)\n                .addClass(this.hoverClass);\n\n            this.hoveredElement = element;\n        },\n\n        /**\n         * Callback which fires when root list element is rendered.\n         *\n         * @param {Element} element\n         */\n        onRootListRender: function (element) {\n            var targetSelector = 'li > ' + this.actionTargetSelector;\n\n            this.rootList = element;\n\n            $(this.rootList).on(\n                'mousemove',\n                targetSelector,\n                this.onDelegatedMouseMove.bind(this)\n            );\n        },\n\n        /**\n         * Returns options from cache or send request\n         *\n         * @param {String} searchKey\n         */\n        loadOptions: function (searchKey) {\n            var currentPage = searchKey === this.lastSearchKey ? this.lastSearchPage + 1 : 1,\n                cachedSearchResult;\n\n            this.renderPath = !!this.showPath;\n\n            if (this.isSearchKeyCached(searchKey)) {\n                cachedSearchResult = this.getCachedSearchResults(searchKey);\n                this.cacheOptions.plain = cachedSearchResult.options;\n                this.options(cachedSearchResult.options);\n                this.afterLoadOptions(searchKey, cachedSearchResult.lastPage, cachedSearchResult.total);\n\n                return;\n            }\n\n            if (currentPage === 1) {\n                this.options([]);\n            }\n            this.processRequest(searchKey, currentPage);\n        },\n\n        /**\n         * Load more options on scroll down\n         * @param {Object} data\n         * @param {Event} event\n         */\n        onScrollDown: function (data, event) {\n            var clientHight = event.target.scrollTop + event.target.clientHeight,\n                scrollHeight = event.target.scrollHeight;\n\n            if (!this.searchOptions) {\n                return;\n            }\n\n            if (clientHight > scrollHeight - this.deviation && !this.isSearchKeyCached(data.filterInputValue())) {\n                this.loadOptions(data.filterInputValue());\n            }\n        },\n\n        /**\n         * Returns cached search result by search key\n         *\n         * @param {String} searchKey\n         * @return {Object}\n         */\n        getCachedSearchResults: function (searchKey) {\n            if (this.cachedSearchResults.hasOwnProperty(searchKey)) {\n                return this.cachedSearchResults[searchKey];\n            }\n\n            return {\n                options: [],\n                lastPage: 1,\n                total: 0\n            };\n        },\n\n        /**\n         * Cache loaded data\n         *\n         * @param {String} searchKey\n         * @param {Array} optionsArray\n         * @param {Number} page\n         * @param {Number} total\n         */\n        setCachedSearchResults: function (searchKey, optionsArray, page, total) {\n            var cachedData = {};\n\n            cachedData.options = optionsArray;\n            cachedData.lastPage = page;\n            cachedData.total = total;\n            this.cachedSearchResults[searchKey] = cachedData;\n        },\n\n        /**\n         * Check if search key cached\n         *\n         * @param {String} searchKey\n         * @return {Boolean}\n         */\n        isSearchKeyCached: function (searchKey) {\n            var totalCached = this.cachedSearchResults.hasOwnProperty(searchKey) ?\n                this.deviation * this.cachedSearchResults[searchKey].lastPage :\n                0;\n\n            return totalCached > 0 && totalCached >= this.cachedSearchResults[searchKey].total;\n        },\n\n        /**\n         * Submit request to load data\n         *\n         * @param {String} searchKey\n         * @param {Number} page\n         */\n        processRequest: function (searchKey, page) {\n            this.loading(true);\n            this.currentSearchKey = searchKey;\n            $.ajax({\n                url: this.searchUrl,\n                type: 'get',\n                dataType: 'json',\n                context: this,\n                data: {\n                    searchKey: searchKey,\n                    page: page,\n                    limit: this.pageLimit\n                },\n                success: $.proxy(this.success, this),\n                error: $.proxy(this.error, this),\n                beforeSend: $.proxy(this.beforeSend, this),\n                complete: $.proxy(this.complete, this, searchKey, page)\n            });\n        },\n\n        /** @param {Object} response */\n        success: function (response) {\n            var existingOptions = this.options();\n\n            _.each(response.options, function (opt) {\n                existingOptions.push(opt);\n            });\n\n            this.total = response.total;\n            this.cacheOptions.plain = existingOptions;\n            this.options(existingOptions);\n        },\n\n        /** add actions before ajax request */\n        beforeSend: function () {\n\n        },\n\n        /** set empty array if error occurs */\n        error: function () {\n            this.options([]);\n        },\n\n        /** cache options and stop loading*/\n        complete: function (searchKey, page) {\n            this.setCachedSearchResults(searchKey, this.options(), page, this.total);\n            this.afterLoadOptions(searchKey, page, this.total);\n        },\n\n        /**\n         * Stop loading and update data after options were updated\n         *\n         * @param {String} searchKey\n         * @param {Number} page\n         * @param {Number} total\n         */\n        afterLoadOptions: function (searchKey, page, total) {\n            this.lastSearchKey = searchKey;\n            this.lastSearchPage = page;\n            this._setItemsQuantity(total);\n            this.loading(false);\n        }\n    });\n});\n","Magento_Ui/js/form/element/abstract.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiElement',\n    'Magento_Ui/js/lib/validation/validator'\n], function (_, utils, layout, Element, validator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true,\n            preview: '',\n            focused: false,\n            required: false,\n            disabled: false,\n            valueChangedByUser: false,\n            elementTmpl: 'ui/form/element/input',\n            tooltipTpl: 'ui/form/element/helper/tooltip',\n            fallbackResetTpl: 'ui/form/element/helper/fallback-reset',\n            'input_type': 'input',\n            placeholder: false,\n            description: '',\n            labelVisible: true,\n            label: '',\n            error: '',\n            warn: '',\n            notice: '',\n            customScope: '',\n            default: '',\n            isDifferedFromDefault: false,\n            showFallbackReset: false,\n            additionalClasses: {},\n            isUseDefault: '',\n            serviceDisabled: false,\n            valueUpdate: false, // ko binding valueUpdate\n\n            switcherConfig: {\n                component: 'Magento_Ui/js/form/switcher',\n                name: '${ $.name }_switcher',\n                target: '${ $.name }',\n                property: 'value'\n            },\n            listens: {\n                visible: 'setPreview',\n                value: 'setDifferedFromDefault',\n                '${ $.provider }:data.reset': 'reset',\n                '${ $.provider }:data.overload': 'overload',\n                '${ $.provider }:${ $.customScope ? $.customScope + \".\" : \"\"}data.validate': 'validate',\n                'isUseDefault': 'toggleUseDefault'\n            },\n            ignoreTmpls: {\n                value: true\n            },\n\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            _.bindAll(this, 'reset');\n\n            this._super()\n                .setInitialValue()\n                ._setClasses()\n                .initSwitcher();\n\n            return this;\n        },\n\n        /**\n         * Checks if component has error.\n         *\n         * @returns {Object}\n         */\n        checkInvalid: function () {\n            return this.error() && this.error().length ? this : null;\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            var rules = this.validation = this.validation || {};\n\n            this._super();\n\n            this.observe('error disabled focused preview visible value warn notice isDifferedFromDefault')\n                .observe('isUseDefault serviceDisabled')\n                .observe({\n                    'required': !!rules['required-entry']\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initConfig: function () {\n            var uid = utils.uniqueid(),\n                name,\n                valueUpdate,\n                scope;\n\n            this._super();\n\n            scope = this.dataScope.split('.');\n            name = scope.length > 1 ? scope.slice(1) : scope;\n\n            valueUpdate = this.showFallbackReset ? 'afterkeydown' : this.valueUpdate;\n\n            _.extend(this, {\n                uid: uid,\n                noticeId: 'notice-' + uid,\n                errorId: 'error-' + uid,\n                tooltipId: 'tooltip-' + uid,\n                inputName: utils.serializeName(name.join('.')),\n                valueUpdate: valueUpdate\n            });\n\n            return this;\n        },\n\n        /**\n         * Initializes switcher element instance.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initSwitcher: function () {\n            if (this.switcherConfig.enabled) {\n                layout([this.switcherConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets initial value of the element and subscribes to it's changes.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.on('value', this.onUpdate.bind(this));\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses;\n\n            if (_.isString(additional)) {\n                this.additionalClasses = {};\n\n                if (additional.trim().length) {\n                    additional = additional.trim().split(' ');\n\n                    additional.forEach(function (name) {\n                        if (name.length) {\n                            this.additionalClasses[name] = true;\n                        }\n                    }, this);\n                }\n            }\n\n            _.extend(this.additionalClasses, {\n                _required: this.required,\n                _error: this.error,\n                _warn: this.warn,\n                _disabled: this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Gets initial value of element\n         *\n         * @returns {*} Elements' value.\n         */\n        getInitialValue: function () {\n            var values = [this.value(), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /**\n         * Sets 'value' as 'hidden' property's value, triggers 'toggle' event,\n         * sets instance's hidden identifier in params storage based on\n         * 'value'.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        setVisible: function (isVisible) {\n            this.visible(isVisible);\n\n            return this;\n        },\n\n        /**\n         * Show element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        show: function () {\n            this.visible(true);\n\n            return this;\n        },\n\n        /**\n         * Hide element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        hide: function () {\n            this.visible(false);\n\n            return this;\n        },\n\n        /**\n         * Disable element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        disable: function () {\n            this.disabled(true);\n\n            return this;\n        },\n\n        /**\n         * Enable element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        enable: function () {\n            this.disabled(false);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {(String|Object)} rule\n         * @param {(Object|Boolean)} [options]\n         * @returns {Abstract} Chainable.\n         */\n        setValidation: function (rule, options) {\n            var rules = utils.copy(this.validation),\n                changed;\n\n            if (_.isObject(rule)) {\n                _.extend(this.validation, rule);\n            } else {\n                this.validation[rule] = options;\n            }\n\n            changed = !utils.compare(rules, this.validation).equal;\n\n            if (changed) {\n                this.required(!!rules['required-entry']);\n                this.validate();\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns unwrapped preview observable.\n         *\n         * @returns {String} Value of the preview observable.\n         */\n        getPreview: function () {\n            return this.value();\n        },\n\n        /**\n         * Checks if element has addons\n         *\n         * @returns {Boolean}\n         */\n        hasAddons: function () {\n            return this.addbefore || this.addafter;\n        },\n\n        /**\n         * Checks if element has service setting\n         *\n         * @returns {Boolean}\n         */\n        hasService: function () {\n            return this.service && this.service.template;\n        },\n\n        /**\n         * Defines if value has changed.\n         *\n         * @returns {Boolean}\n         */\n        hasChanged: function () {\n            var notEqual = this.value() !== this.initialValue;\n\n            return !this.visible() ? false : notEqual;\n        },\n\n        /**\n         * Checks if 'value' is not empty.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !utils.isEmpty(this.value());\n        },\n\n        /**\n         * Sets value observable to initialValue property.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        reset: function () {\n            this.value(this.initialValue);\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * Sets current state as initial.\n         */\n        overload: function () {\n            this.setInitialValue();\n            this.bubble('update', this.hasChanged());\n        },\n\n        /**\n         * Clears 'value' property.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        clear: function () {\n            this.value('');\n\n            return this;\n        },\n\n        /**\n         * Converts values like 'null' or 'undefined' to an empty string.\n         *\n         * @param {*} value - Value to be processed.\n         * @returns {*}\n         */\n        normalizeData: function (value) {\n            return utils.isEmpty(value) ? '' : value;\n        },\n\n        /**\n         * Validates itself by it's validation rules using validator object.\n         * If validation of a rule did not pass, writes it's message to\n         * 'error' observable property.\n         *\n         * @returns {Object} Validate information.\n         */\n        validate: function () {\n            var value = this.value(),\n                result = validator(this.validation, value, this.validationParams),\n                message = !this.disabled() && this.visible() ? result.message : '',\n                isValid = this.disabled() || !this.visible() || result.passed;\n\n            this.error(message);\n            this.error.valueHasMutated();\n            this.bubble('error', message);\n\n            //TODO: Implement proper result propagation for form\n            if (this.source && !isValid) {\n                this.source.set('params.invalid', true);\n            }\n\n            return {\n                valid: isValid,\n                target: this\n            };\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         */\n        onUpdate: function () {\n            this.bubble('update', this.hasChanged());\n\n            this.validate();\n        },\n\n        /**\n         * Restore value to default\n         */\n        restoreToDefault: function () {\n            this.value(this.default);\n            this.focused(true);\n        },\n\n        /**\n         * Update whether value differs from default value\n         */\n        setDifferedFromDefault: function () {\n            var value = typeof this.value() != 'undefined' && this.value() !== null ? this.value() : '',\n                defaultValue = typeof this.default != 'undefined' && this.default !== null ? this.default : '';\n\n            this.isDifferedFromDefault(value !== defaultValue);\n        },\n\n        /**\n         * @param {Boolean} state\n         */\n        toggleUseDefault: function (state) {\n            this.disabled(state);\n\n            if (this.source && this.hasService()) {\n                this.source.set('data.use_default.' + this.index, Number(state));\n            }\n        },\n\n        /**\n         *  Callback when value is changed by user\n         */\n        userChanges: function () {\n            this.valueChangedByUser = true;\n        },\n\n        /**\n         * Returns correct id for 'aria-describedby' accessibility attribute\n         *\n         * @returns {Boolean|String}\n         */\n        getDescriptionId: function () {\n            var id = false;\n\n            if (this.error()) {\n                id = this.errorId;\n            } else if (this.notice()) {\n                id = this.noticeId;\n            }\n\n            return id;\n        }\n    });\n});\n","Magento_Ui/js/form/element/single-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'underscore',\n    'mage/translate'\n], function (AbstractField, _, $t) {\n    'use strict';\n\n    return AbstractField.extend({\n        defaults: {\n            template: 'ui/form/components/single/field',\n            checked: false,\n            initialChecked: false,\n            multiple: false,\n            prefer: 'checkbox', // 'radio' | 'checkbox' | 'toggle'\n            valueMap: {},\n\n            templates: {\n                radio: 'ui/form/components/single/radio',\n                checkbox: 'ui/form/components/single/checkbox',\n                toggle: 'ui/form/components/single/switcher'\n            },\n\n            listens: {\n                'checked': 'onCheckedChanged',\n                'value': 'onExtendedValueChanged'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function (config) {\n            this._super();\n\n            if (!config.elementTmpl) {\n                if (!this.prefer && !this.multiple) {\n                    this.elementTmpl = this.templates.radio;\n                } else if (this.prefer === 'radio') {\n                    this.elementTmpl = this.templates.radio;\n                } else if (this.prefer === 'checkbox') {\n                    this.elementTmpl = this.templates.checkbox;\n                } else if (this.prefer === 'toggle') {\n                    this.elementTmpl = this.templates.toggle;\n                } else {\n                    this.elementTmpl = this.templates.checkbox;\n                }\n            }\n\n            if (this.prefer === 'toggle' && _.isEmpty(this.toggleLabels)) {\n                this.toggleLabels = {\n                    'on': $t('Yes'),\n                    'off': $t('No')\n                };\n            }\n\n            if (typeof this.default === 'undefined' || this.default === null) {\n                this.default = '';\n            }\n\n            if (typeof this.value === 'undefined' || this.value === null) {\n                this.value = _.isEmpty(this.valueMap) || this.default !== '' ? this.default : this.valueMap.false;\n                this.initialValue = this.value;\n            } else {\n                this.initialValue = this.value;\n            }\n\n            if (this.multiple && !_.isArray(this.value)) {\n                this.value = []; // needed for correct observable assignment\n            }\n\n            this.initialChecked = this.checked;\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe('checked');\n        },\n\n        /**\n         * Get true/false key from valueMap by value.\n         *\n         * @param {*} value\n         * @returns {Boolean|undefined}\n         */\n        getReverseValueMap: function getReverseValueMap(value) {\n            var bool = false;\n\n            _.some(this.valueMap, function (iValue, iBool) {\n                if (iValue === value) {\n                    bool = iBool === 'true';\n\n                    return true;\n                }\n            });\n\n            return bool;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            if (_.isEmpty(this.valueMap)) {\n                this.on('value', this.onUpdate.bind(this));\n            } else {\n                this._super();\n                this.checked(this.getReverseValueMap(this.value()));\n            }\n\n            return this;\n        },\n\n        /**\n         * Handle dataScope changes for checkbox / radio button.\n         *\n         * @param {*} newExportedValue\n         */\n        onExtendedValueChanged: function (newExportedValue) {\n            var isMappedUsed = !_.isEmpty(this.valueMap),\n                oldChecked = this.checked.peek(),\n                oldValue = this.initialValue,\n                newChecked;\n\n            if (this.multiple) {\n                newChecked = newExportedValue.indexOf(oldValue) !== -1;\n            } else if (isMappedUsed) {\n                newChecked = this.getReverseValueMap(newExportedValue);\n            } else if (typeof newExportedValue === 'boolean') {\n                newChecked = newExportedValue;\n            } else {\n                newChecked = newExportedValue === oldValue;\n            }\n\n            if (newChecked !== oldChecked) {\n                this.checked(newChecked);\n            }\n        },\n\n        /**\n         * Handle checked state changes for checkbox / radio button.\n         *\n         * @param {Boolean} newChecked\n         */\n        onCheckedChanged: function (newChecked) {\n            var isMappedUsed = !_.isEmpty(this.valueMap),\n                oldValue = this.initialValue,\n                newValue;\n\n            if (isMappedUsed) {\n                newValue = this.valueMap[newChecked];\n            } else {\n                newValue = oldValue;\n            }\n\n            if (!this.multiple && newChecked) {\n                this.value(newValue);\n            } else if (!this.multiple && !newChecked) {\n                if (typeof newValue === 'boolean') {\n                    this.value(newChecked);\n                } else if (newValue === this.value.peek()) {\n                    this.value('');\n                }\n\n                if (isMappedUsed) {\n                    this.value(newValue);\n                }\n            } else if (this.multiple && newChecked && this.value.indexOf(newValue) === -1) {\n                this.value.push(newValue);\n            } else if (this.multiple && !newChecked && this.value.indexOf(newValue) !== -1) {\n                this.value.splice(this.value.indexOf(newValue), 1);\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            if (this.hasUnique) {\n                this.setUnique();\n            }\n\n            return this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            if (this.multiple && this.initialChecked) {\n                this.value.push(this.initialValue);\n            } else if (this.multiple && !this.initialChecked) {\n                this.value.splice(this.value.indexOf(this.initialValue), 1);\n            } else {\n                this.value(this.initialValue);\n            }\n\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            if (this.multiple) {\n                this.value([]);\n            } else {\n                this.value('');\n            }\n\n            this.error(false);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'moment',\n    'mageUtils',\n    './abstract',\n    'moment-timezone-with-data'\n], function (moment, utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            options: {},\n\n            storeTimeZone: 'UTC',\n\n            validationParams: {\n                dateFormat: '${ $.outputDateFormat }'\n            },\n\n            /**\n             * Format of date that comes from the\n             * server (ICU Date Format).\n             *\n             * Used only in date picker mode\n             * (this.options.showsTime == false).\n             *\n             * @type {String}\n             */\n            inputDateFormat: 'y-MM-dd',\n\n            /**\n             * Format of date that should be sent to the\n             * server (ICU Date Format).\n             *\n             * Used only in date picker mode\n             * (this.options.showsTime == false).\n             *\n             * @type {String}\n             */\n            outputDateFormat: 'MM/dd/y',\n\n            /**\n             * Date/time format that is used to display date in\n             * the input field.\n             *\n             * @type {String}\n             */\n            pickerDateTimeFormat: '',\n\n            pickerDefaultDateFormat: 'MM/dd/y', // ICU Date Format\n            pickerDefaultTimeFormat: 'h:mm a', // ICU Time Format\n\n            elementTmpl: 'ui/form/element/date',\n\n            /**\n             * Format needed by moment timezone for conversion\n             */\n            timezoneFormat: 'YYYY-MM-DD HH:mm',\n\n            listens: {\n                'value': 'onValueChange',\n                'shiftedValue': 'onShiftedValueChange'\n            },\n\n            /**\n             * Date/time value shifted to corresponding timezone\n             * according to this.storeTimeZone property. This value\n             * will be sent to the server.\n             *\n             * @type {String}\n             */\n            shiftedValue: ''\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            if (!this.options.dateFormat) {\n                this.options.dateFormat = this.pickerDefaultDateFormat;\n            }\n\n            if (!this.options.timeFormat) {\n                this.options.timeFormat = this.pickerDefaultTimeFormat;\n            }\n\n            this.prepareDateTimeFormats();\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super().observe(['shiftedValue']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        getPreview: function () {\n            return this.shiftedValue();\n        },\n\n        /**\n         * Prepares and sets date/time value that will be displayed\n         * in the input field.\n         *\n         * @param {String} value\n         */\n        onValueChange: function (value) {\n            var shiftedValue;\n\n            if (value) {\n                if (this.options.showsTime && !this.options.timeOnly) {\n                    shiftedValue = moment.tz(value, 'UTC').tz(this.storeTimeZone);\n                } else {\n                    shiftedValue = moment(value, this.outputDateFormat, true);\n                }\n\n                if (!shiftedValue.isValid()) {\n                    shiftedValue = moment(value, this.inputDateFormat);\n                }\n                shiftedValue = shiftedValue.format(this.pickerDateTimeFormat);\n            } else {\n                shiftedValue = '';\n            }\n\n            if (shiftedValue !== this.shiftedValue()) {\n                this.shiftedValue(shiftedValue);\n            }\n        },\n\n        /**\n         * Prepares and sets date/time value that will be sent\n         * to the server.\n         *\n         * @param {String} shiftedValue\n         */\n        onShiftedValueChange: function (shiftedValue) {\n            var value,\n                formattedValue,\n                momentValue;\n\n            if (shiftedValue) {\n                momentValue = moment(shiftedValue, this.pickerDateTimeFormat);\n\n                if (this.options.showsTime && !this.options.timeOnly) {\n                    formattedValue = moment(momentValue).format(this.timezoneFormat);\n                    value = moment.tz(formattedValue, this.storeTimeZone).tz('UTC').toISOString();\n                } else {\n                    value = momentValue.format(this.outputDateFormat);\n                }\n            } else {\n                value = '';\n            }\n\n            if (value !== this.value()) {\n                this.value(value);\n            }\n        },\n\n        /**\n         * Prepares and converts all date/time formats to be compatible\n         * with moment.js library.\n         */\n        prepareDateTimeFormats: function () {\n            if (this.options.timeOnly) {\n                this.pickerDateTimeFormat = this.options.timeFormat;\n            } else {\n                this.pickerDateTimeFormat = this.options.dateFormat;\n\n                if (this.options.showsTime) {\n                    this.pickerDateTimeFormat += ' ' + this.options.timeFormat;\n                }\n            }\n\n            this.pickerDateTimeFormat = utils.convertToMomentFormat(this.pickerDateTimeFormat);\n\n            if (this.options.dateFormat) {\n                this.outputDateFormat = this.options.dateFormat;\n            }\n\n            this.inputDateFormat = this.options.timeOnly ?\n                utils.convertToMomentFormat(this.pickerDefaultTimeFormat) :\n                utils.convertToMomentFormat(this.inputDateFormat);\n            this.outputDateFormat = this.options.timeOnly ?\n                utils.convertToMomentFormat(this.options.timeFormat) :\n                utils.convertToMomentFormat(this.outputDateFormat);\n\n            this.validationParams.dateFormat = this.outputDateFormat;\n        }\n    });\n});\n","Magento_Ui/js/form/element/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    './abstract',\n    'uiLayout'\n], function (_, utils, registry, Abstract, layout) {\n    'use strict';\n\n    var inputNode = {\n        parent: '${ $.$data.parentName }',\n        component: 'Magento_Ui/js/form/element/abstract',\n        template: '${ $.$data.template }',\n        provider: '${ $.$data.provider }',\n        name: '${ $.$data.index }_input',\n        dataScope: '${ $.$data.customEntry }',\n        customScope: '${ $.$data.customScope }',\n        sortOrder: {\n            after: '${ $.$data.name }'\n        },\n        displayArea: 'body',\n        label: '${ $.$data.label }'\n    };\n\n    /**\n     * Parses incoming options, considers options with undefined value property\n     *     as caption\n     *\n     * @param  {Array} nodes\n     * @return {Object}\n     */\n    function parseOptions(nodes, captionValue) {\n        var caption,\n            value;\n\n        nodes = _.map(nodes, function (node) {\n            value = node.value;\n\n            if (value === null || value === captionValue) {\n                if (_.isUndefined(caption)) {\n                    caption = node.label;\n                }\n            } else {\n                return node;\n            }\n        });\n\n        return {\n            options: _.compact(nodes),\n            caption: _.isString(caption) ? caption : false\n        };\n    }\n\n    /**\n     * Recursively loops over data to find non-undefined, non-array value\n     *\n     * @param  {Array} data\n     * @return {*} - first non-undefined value in array\n     */\n    function findFirst(data) {\n        var value;\n\n        data.some(function (node) {\n            value = node.value;\n\n            if (Array.isArray(value)) {\n                value = findFirst(value);\n            }\n\n            return !_.isUndefined(value);\n        });\n\n        return value;\n    }\n\n    /**\n     * Recursively set to object item like value and item.value like key.\n     *\n     * @param {Array} data\n     * @param {Object} result\n     * @returns {Object}\n     */\n    function indexOptions(data, result) {\n        var value;\n\n        result = result || {};\n\n        data.forEach(function (item) {\n            value = item.value;\n\n            if (Array.isArray(value)) {\n                indexOptions(value, result);\n            } else {\n                result[value] = item;\n            }\n        });\n\n        return result;\n    }\n\n    return Abstract.extend({\n        defaults: {\n            customName: '${ $.parentName }.${ $.index }_input',\n            elementTmpl: 'ui/form/element/select',\n            caption: '',\n            options: []\n        },\n\n        /**\n         * Extends instance with defaults, extends config with formatted values\n         *     and options, and invokes initialize method of AbstractElement class.\n         *     If instance's 'customEntry' property is set to true, calls 'initInput'\n         */\n        initialize: function () {\n            this._super();\n\n            if (this.customEntry) {\n                registry.get(this.name, this.initInput.bind(this));\n            }\n\n            if (this.filterBy) {\n                this.initFilter();\n            }\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n\n            this.initialOptions = this.options;\n\n            this.observe('options caption')\n                .setOptions(this.options());\n\n            return this;\n        },\n\n        /**\n         * Set link for filter.\n         *\n         * @returns {Object} Chainable\n         */\n        initFilter: function () {\n            var filter = this.filterBy;\n\n            this.filter(this.default, filter.field);\n            this.setLinks({\n                filter: filter.target\n            }, 'imports');\n\n            return this;\n        },\n\n        /**\n         * Creates input from template, renders it via renderer.\n         *\n         * @returns {Object} Chainable.\n         */\n        initInput: function () {\n            layout([utils.template(inputNode, this)]);\n\n            return this;\n        },\n\n        /**\n         * Matches specified value with existing options\n         * or, if value is not specified, returns value of the first option.\n         *\n         * @returns {*}\n         */\n        normalizeData: function () {\n            var value = this._super(),\n                option;\n\n            if (value !== '') {\n                option = this.getOption(value);\n\n                return option && option.value;\n            }\n\n            if (!this.caption()) {\n                return findFirst(this.options);\n            }\n        },\n\n        /**\n         * Filters 'initialOptions' property by 'field' and 'value' passed,\n         * calls 'setOptions' passing the result to it\n         *\n         * @param {*} value\n         * @param {String} field\n         */\n        filter: function (value, field) {\n            var source = this.initialOptions,\n                result;\n\n            field = field || this.filterBy.field;\n\n            result = _.filter(source, function (item) {\n                return item[field] === value || item.value === '';\n            });\n\n            this.setOptions(result);\n        },\n\n        /**\n         * Change visibility for input.\n         *\n         * @param {Boolean} isVisible\n         */\n        toggleInput: function (isVisible) {\n            registry.get(this.customName, function (input) {\n                input.setVisible(isVisible);\n            });\n        },\n\n        /**\n         * Sets 'data' to 'options' observable array, if instance has\n         * 'customEntry' property set to true, calls 'setHidden' method\n         *  passing !options.length as a parameter\n         *\n         * @param {Array} data\n         * @returns {Object} Chainable\n         */\n        setOptions: function (data) {\n            var captionValue = this.captionValue || '',\n                result = parseOptions(data, captionValue),\n                isVisible;\n\n            this.indexedOptions = indexOptions(result.options);\n\n            this.options(result.options);\n\n            if (!this.caption()) {\n                this.caption(result.caption);\n            }\n\n            if (this.customEntry) {\n                isVisible = !!result.options.length;\n\n                this.setVisible(isVisible);\n                this.toggleInput(!isVisible);\n            }\n\n            return this;\n        },\n\n        /**\n         * Processes preview for option by it's value, and sets the result\n         * to 'preview' observable\n         *\n         * @returns {Object} Chainable.\n         */\n        getPreview: function () {\n            var value = this.value(),\n                option = this.indexedOptions[value],\n                preview = option ? option.label : '';\n\n            this.preview(preview);\n\n            return preview;\n        },\n\n        /**\n         * Get option from indexedOptions list.\n         *\n         * @param {Number} value\n         * @returns {Object} Chainable\n         */\n        getOption: function (value) {\n            return this.indexedOptions[value];\n        },\n\n        /**\n         * Select first available option\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            var value = this.caption() ? '' : findFirst(this.options);\n\n            this.value(value);\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialValue: function () {\n            if (_.isUndefined(this.value()) && !this.default) {\n                this.clear();\n            }\n\n            return this._super();\n        }\n    });\n});\n","Magento_Ui/js/form/element/country.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    './select'\n], function (_, registry, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            imports: {\n                update: '${ $.parentName }.website_id:value'\n            }\n        },\n\n        /**\n         * Filters 'initialOptions' property by 'field' and 'value' passed,\n         * calls 'setOptions' passing the result to it\n         *\n         * @param {*} value\n         * @param {String} field\n         */\n        filter: function (value, field) {\n            var result, defaultCountry, defaultValue;\n\n            if (!field) { //validate field, if we are on update\n                field = this.filterBy.field;\n            }\n\n            this._super(value, field);\n            result = _.filter(this.initialOptions, function (item) {\n\n                if (item[field]) {\n                    return ~item[field].indexOf(value);\n                }\n\n                return false;\n            });\n\n            this.setOptions(result);\n            this.reset();\n\n            if (!this.value()) {\n                defaultCountry = _.filter(result, function (item) {\n                    return item['is_default'] && _.contains(item['is_default'], value);\n                });\n\n                if (defaultCountry.length) {\n                    defaultValue = defaultCountry.shift();\n                    this.value(defaultValue.value);\n                }\n            }\n        }\n    });\n});\n\n","Magento_Ui/js/form/element/color-picker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Ui/js/form/element/color-picker-palette'\n], function ($t, Abstract, palette) {\n    'use strict';\n\n    return Abstract.extend({\n\n        defaults: {\n            colorPickerConfig: {\n                chooseText: $t('Apply'),\n                cancelText: $t('Cancel'),\n                maxSelectionSize: 8,\n                clickoutFiresChange: true,\n                allowEmpty: true,\n                localStorageKey: 'magento.spectrum',\n                palette: palette\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n\n            this.colorPickerConfig.value = this.value;\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n/* global Base64 */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/validation/validator',\n    'Magento_Ui/js/form/element/abstract',\n    'mage/backend/notification',\n    'mage/translate',\n    'jquery/file-uploader',\n    'mage/adminhtml/tools'\n], function ($, _, utils, uiAlert, validator, Element, notification, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            value: [],\n            aggregatedErrors: [],\n            maxFileSize: false,\n            isMultipleFiles: false,\n            placeholderType: 'document', // 'image', 'video'\n            allowedExtensions: false,\n            previewTmpl: 'ui/form/element/uploader/preview',\n            dropZone: '[data-role=drop-zone]',\n            isLoading: false,\n            uploaderConfig: {\n                dataType: 'json',\n                sequentialUploads: true,\n                formData: {\n                    'form_key': window.FORM_KEY\n                }\n            },\n            tracks: {\n                isLoading: true\n            }\n        },\n\n        /**\n         * Initializes file uploader plugin on provided input element.\n         *\n         * @param {HTMLInputElement} fileInput\n         * @returns {FileUploader} Chainable.\n         */\n        initUploader: function (fileInput) {\n            this.$fileInput = fileInput;\n\n            _.extend(this.uploaderConfig, {\n                dropZone: $(fileInput).closest(this.dropZone),\n                change: this.onFilesChoosed.bind(this),\n                drop: this.onFilesChoosed.bind(this),\n                add: this.onBeforeFileUpload.bind(this),\n                fail: this.onFail.bind(this),\n                done: this.onFileUploaded.bind(this),\n                start: this.onLoadingStart.bind(this),\n                stop: this.onLoadingStop.bind(this)\n            });\n\n            $(fileInput).fileupload(this.uploaderConfig);\n\n            return this;\n        },\n\n        /**\n         * Defines initial value of the instance.\n         *\n         * @returns {FileUploader} Chainable.\n         */\n        setInitialValue: function () {\n            var value = this.getInitialValue();\n\n            value = value.map(this.processFile, this);\n\n            this.initialValue = value.slice();\n\n            this.value(value);\n            this.on('value', this.onUpdate.bind(this));\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * Empties files list.\n         *\n         * @returns {FileUploader} Chainable.\n         */\n        clear: function () {\n            this.value.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Checks if files list contains any items.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.value().length;\n        },\n\n        /**\n         * Resets files list to its' initial value.\n         *\n         * @returns {FileUploader}\n         */\n        reset: function () {\n            var value = this.initialValue.slice();\n\n            this.value(value);\n\n            return this;\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {FileUploader} Chainable.\n         */\n        addFile: function (file) {\n            file = this.processFile(file);\n\n            this.isMultipleFiles ?\n                this.value.push(file) :\n                this.value([file]);\n\n            return this;\n        },\n\n        /**\n         * Retrieves from the list file which matches\n         * search criteria implemented in itertor function.\n         *\n         * @param {Function} fn - Function that will be invoked\n         *      for each file in the list.\n         * @returns {Object}\n         */\n        getFile: function (fn) {\n            return _.find(this.value(), fn);\n        },\n\n        /**\n         * Removes provided file from thes files list.\n         *\n         * @param {Object} file\n         * @returns {FileUploader} Chainable.\n         */\n        removeFile: function (file) {\n            this.value.remove(file);\n\n            return this;\n        },\n\n        /**\n         * May perform modifications on the provided\n         * file object before adding it to the files list.\n         *\n         * @param {Object} file\n         * @returns {Object} Modified file object.\n         */\n        processFile: function (file) {\n            file.previewType = this.getFilePreviewType(file);\n\n            if (!file.id && file.name) {\n                file.id = Base64.mageEncode(file.name);\n            }\n\n            this.observe.call(file, true, [\n                'previewWidth',\n                'previewHeight'\n            ]);\n\n            return file;\n        },\n\n        /**\n         * Formats incoming bytes value to a readable format.\n         *\n         * @param {Number} bytes\n         * @returns {String}\n         */\n        formatSize: function (bytes) {\n            var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'],\n                i;\n\n            if (bytes === 0) {\n                return '0 Byte';\n            }\n\n            i = window.parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));\n\n            return Math.round(bytes / Math.pow(1024, i), 2) + ' ' + sizes[i];\n        },\n\n        /**\n         * Returns path to the files' preview image.\n         *\n         * @param {Object} file\n         * @returns {String}\n         */\n        getFilePreview: function (file) {\n            return file.url;\n        },\n\n        /**\n         * Returns path to the file's preview template.\n         *\n         * @returns {String}\n         */\n        getPreviewTmpl: function () {\n            return this.previewTmpl;\n        },\n\n        /**\n         * Checks if provided file is allowed to be uploaded.\n         *\n         * @param {Object} file\n         * @returns {Object} Validation result.\n         */\n        isFileAllowed: function (file) {\n            var result;\n\n            _.every([\n                this.isExtensionAllowed(file),\n                this.isSizeExceeded(file)\n            ], function (value) {\n                result = value;\n\n                return value.passed;\n            });\n\n            return result;\n        },\n\n        /**\n         * Checks if extension of provided file is allowed.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {Boolean}\n         */\n        isExtensionAllowed: function (file) {\n            return validator('validate-file-type', file.name, this.allowedExtensions);\n        },\n\n        /**\n         * Get simplified file type.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {String}\n         */\n        getFilePreviewType: function (file) {\n            var type;\n\n            if (!file.type) {\n                return 'document';\n            }\n\n            type = file.type.split('/')[0];\n\n            return type !== 'image' && type !== 'video' ? 'document' : type;\n        },\n\n        /**\n         * Checks if size of provided file exceeds\n         * defined in configuration size limits.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {Boolean}\n         */\n        isSizeExceeded: function (file) {\n            return validator('validate-max-size', file.size, this.maxFileSize);\n        },\n\n        /**\n         * Displays provided error message.\n         *\n         * @param {String} msg\n         * @returns {FileUploader} Chainable.\n         */\n        notifyError: function (msg) {\n            var data = {\n                content: msg\n            };\n\n            if (this.isMultipleFiles) {\n                data.modalClass = '_image-box';\n            }\n\n            uiAlert(data);\n\n            return this;\n        },\n\n        /**\n         * Performs data type conversions.\n         *\n         * @param {*} value\n         * @returns {Array}\n         */\n        normalizeData: function (value) {\n            return utils.isEmpty(value) ? [] : value;\n        },\n\n        /**\n         * Checks if files list is different\n         * from its' initial value.\n         *\n         * @returns {Boolean}\n         */\n        hasChanged: function () {\n            var value = this.value(),\n                initial = this.initialValue;\n\n            return !utils.equalArrays(value, initial);\n        },\n\n        /**\n         * Handler which is invoked when files are choosed for upload.\n         * May be used for implementation of additional validation rules,\n         * e.g. total files and a total size rules.\n         *\n         * @param {Event} event - Event object.\n         * @param {Object} data - File data that will be uploaded.\n         */\n        onFilesChoosed: function (event, data) {\n            // no option exists in file uploader for restricting upload chains to single files\n            // this enforces that policy\n            if (!this.isMultipleFiles) {\n                data.files.splice(1);\n            }\n        },\n\n        /**\n         * Handler which is invoked prior to the start of a file upload.\n         *\n         * @param {Event} event - Event object.\n         * @param {Object} data - File data that will be uploaded.\n         */\n        onBeforeFileUpload: function (event, data) {\n            var file = data.files[0],\n                allowed = this.isFileAllowed(file),\n                target = $(event.target);\n\n            if (this.disabled()) {\n                this.notifyError($t('The file upload field is disabled.'));\n\n                return;\n            }\n\n            if (allowed.passed) {\n                target.on('fileuploadsend', function (eventBound, postData) {\n                    postData.data.append('param_name', this.paramName);\n                }.bind(data));\n\n                target.fileupload('process', data).done(function () {\n                    data.submit();\n                });\n            } else {\n                this.aggregateError(file.name, allowed.message);\n\n                // if all files in upload chain are invalid, stop callback is never called; this resolves promise\n                if (this.aggregatedErrors.length === data.originalFiles.length) {\n                    this.uploaderConfig.stop();\n                }\n            }\n        },\n\n        /**\n         * Add error message associated with filename for display when upload chain is complete\n         *\n         * @param {String} filename\n         * @param {String} message\n         */\n        aggregateError: function (filename, message) {\n            this.aggregatedErrors.push({\n                filename: filename,\n                message: message\n            });\n        },\n\n        /**\n         * @param {Event} event\n         * @param {Object} data\n         */\n        onFail: function (event, data) {\n            console.error(data.jqXHR.responseText);\n            console.error(data.jqXHR.status);\n        },\n\n        /**\n         * Handler of the file upload complete event.\n         *\n         * @param {Event} event\n         * @param {Object} data\n         */\n        onFileUploaded: function (event, data) {\n            var uploadedFilename = data.files[0].name,\n                file = data.result,\n                error = file.error;\n\n            error ?\n                this.aggregateError(uploadedFilename, error) :\n                this.addFile(file);\n        },\n\n        /**\n         * Load start event handler.\n         */\n        onLoadingStart: function () {\n            this.isLoading = true;\n        },\n\n        /**\n         * Load stop event handler.\n         */\n        onLoadingStop: function () {\n            var aggregatedErrorMessages = [];\n\n            this.isLoading = false;\n\n            if (!this.aggregatedErrors.length) {\n                return;\n            }\n\n            if (!this.isMultipleFiles) { // only single file upload occurred; use first file's error message\n                aggregatedErrorMessages.push(this.aggregatedErrors[0].message);\n            } else { // construct message from all aggregatedErrors\n                _.each(this.aggregatedErrors, function (error) {\n                    notification().add({\n                        error: true,\n                        message: '%s' + error.message, // %s to be used as placeholder for html injection\n\n                        /**\n                         * Adds constructed error notification to aggregatedErrorMessages\n                         *\n                         * @param {String} constructedMessage\n                         */\n                        insertMethod: function (constructedMessage) {\n                            var escapedFileName = $('<div>').text(error.filename).html(),\n                                errorMsgBodyHtml = '<strong>%s</strong> %s.<br>'\n                                    .replace('%s', escapedFileName)\n                                    .replace('%s', $t('was not uploaded'));\n\n                            // html is escaped in message body for notification widget; prepend unescaped html here\n                            constructedMessage = constructedMessage.replace('%s', errorMsgBodyHtml);\n\n                            aggregatedErrorMessages.push(constructedMessage);\n                        }\n                    });\n                });\n            }\n\n            this.notifyError(aggregatedErrorMessages.join(''));\n\n            // clear out aggregatedErrors array for this completed upload chain\n            this.aggregatedErrors = [];\n        },\n\n        /**\n         * Handler function which is supposed to be invoked when\n         * file input element has been rendered.\n         *\n         * @param {HTMLInputElement} fileInput\n         */\n        onElementRender: function (fileInput) {\n            this.initUploader(fileInput);\n        },\n\n        /**\n         * Handler of the preview image load event.\n         *\n         * @param {Object} file - File associated with an image.\n         * @param {Event} event\n         */\n        onPreviewLoad: function (file, event) {\n            var img = event.currentTarget;\n\n            file.previewWidth = img.naturalWidth;\n            file.previewHeight = img.naturalHeight;\n        },\n\n        /**\n         * Restore value to default\n         */\n        restoreToDefault: function () {\n            var defaultValue = utils.copy(this.default);\n\n            defaultValue.map(this.processFile, this);\n            this.value(defaultValue);\n        },\n\n        /**\n         * Update whether value differs from default value\n         */\n        setDifferedFromDefault: function () {\n            var value = utils.copy(this.value());\n\n            this.isDifferedFromDefault(!_.isEqual(value, this.default));\n        }\n    });\n});\n","Magento_Ui/js/form/element/checkbox-set.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    './abstract'\n], function (_, utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            template: 'ui/form/element/checkbox-set',\n            multiple: false,\n            multipleScopeValue: null\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function () {\n            this._super();\n\n            this.value = this.normalizeData(this.value);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initLinks: function () {\n            var scope = this.source.get(this.dataScope);\n\n            this.multipleScopeValue = this.multiple && _.isArray(scope) ? utils.copy(scope) : undefined;\n\n            return this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            this.value(utils.copy(this.initialValue));\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            var value = this.multiple ? [] : '';\n\n            this.value(value);\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        normalizeData: function (value) {\n            if (!this.multiple) {\n                return this._super();\n            }\n\n            return _.isArray(value) ? utils.copy(value) : [];\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.initialValue = utils.copy(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        getInitialValue: function () {\n            var values = [this.multipleScopeValue, this.default, this.value.peek(), []],\n                value;\n\n            if (!this.multiple) {\n                return this._super();\n            }\n\n            values.some(function (v) {\n                return _.isArray(v) && (value = utils.copy(v));\n            });\n\n            return value;\n        },\n\n        /**\n         * Returns labels which matches current value.\n         *\n         * @returns {String|Array}\n         */\n        getPreview: function () {\n            var option;\n\n            if (!this.multiple) {\n                option = this.getOption(this.value());\n\n                return option ? option.label : '';\n            }\n\n            return this.value.map(function (value) {\n                return this.getOption(value).label;\n            }, this);\n        },\n\n        /**\n         * Returns option object associated with provided value.\n         *\n         * @param {String} value\n         * @returns {Object}\n         */\n        getOption: function (value) {\n            return _.findWhere(this.options, {\n                value: value\n            });\n        },\n\n        /**\n         * @inheritdoc\n         */\n        hasChanged: function () {\n            var value = this.value(),\n                initial = this.initialValue;\n\n            return this.multiple ?\n                !utils.equalArrays(value, initial) :\n                this._super();\n        }\n    });\n});\n","Magento_Ui/js/form/element/multiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    './select'\n], function (_, utils, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            size: 5,\n            elementTmpl: 'ui/form/element/multiselect',\n            listens: {\n                value: 'setDifferedFromDefault setPrepareToSendData'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.initialValue = utils.copy(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        normalizeData: function (value) {\n            if (utils.isEmpty(value)) {\n                value = [];\n            }\n\n            return _.isString(value) ? value.split(',') : value;\n        },\n\n        /**\n         * Sets the prepared data to dataSource\n         * by path, where key is component link to dataSource with\n         * suffix \"-prepared-for-send\"\n         *\n         * @param {Array} data - current component value\n         */\n        setPrepareToSendData: function (data) {\n            if (_.isUndefined(data) || !data.length) {\n                data = '';\n            }\n\n            this.source.set(this.dataScope + '-prepared-for-send', data);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        getInitialValue: function () {\n            var values = [\n                    this.normalizeData(this.source.get(this.dataScope)),\n                    this.normalizeData(this.default)\n                ],\n                value;\n\n            values.some(function (v) {\n                return _.isArray(v) && (value = utils.copy(v)) && !_.isEmpty(v);\n            });\n\n            return value;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        hasChanged: function () {\n            var value = this.value(),\n                initial = this.initialValue;\n\n            return !utils.equalArrays(value, initial);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            this.value(utils.copy(this.initialValue));\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            this.value([]);\n            this.error(false);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/post-code.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                countryOptions: '${ $.parentName }.country_id:indexedOptions',\n                update: '${ $.parentName }.country_id:value'\n            }\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n\n            /**\n             * equalityComparer function\n             *\n             * @returns boolean.\n             */\n            this.value.equalityComparer = function (oldValue, newValue) {\n                return !oldValue && !newValue || oldValue === newValue;\n            };\n\n            return this;\n        },\n\n        /**\n         * Method called every time country selector's value gets changed.\n         * Updates all validations and requirements for certain country.\n         * @param {String} value - Selected country ID.\n         */\n        update: function (value) {\n            var isZipCodeOptional,\n                option;\n\n            if (!value) {\n                return;\n            }\n\n            option = _.isObject(this.countryOptions) && this.countryOptions[value];\n\n            if (!option) {\n                return;\n            }\n\n            isZipCodeOptional = !!option['is_zipcode_optional'];\n\n            if (isZipCodeOptional) {\n                this.error(false);\n            }\n\n            this.validation['required-entry'] = !isZipCodeOptional;\n            this.required(!isZipCodeOptional);\n        }\n    });\n});\n","Magento_Ui/js/form/element/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            cols: 15,\n            rows: 2,\n            elementTmpl: 'ui/form/element/textarea'\n        }\n    });\n});\n","Magento_Ui/js/form/element/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Base64 */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/validation/validator',\n    'Magento_Ui/js/form/element/file-uploader',\n    'mage/adminhtml/browser'\n], function ($, _, utils, uiAlert, validator, Element, browser) {\n    'use strict';\n\n    return Element.extend({\n        /**\n         * {@inheritDoc}\n         */\n        initialize: function () {\n            this._super();\n\n            // Listen for file deletions from the media browser\n            $(window).on('fileDeleted.mediabrowser', this.onDeleteFile.bind(this));\n        },\n\n        /**\n         * Assign uid for media gallery\n         *\n         * @return {ImageUploader} Chainable.\n         */\n        initConfig: function () {\n            var mediaGalleryUid = utils.uniqueid();\n\n            this._super();\n\n            _.extend(this, {\n                mediaGalleryUid: mediaGalleryUid\n            });\n\n            return this;\n        },\n\n        /**\n         * Add file event callback triggered from media gallery\n         *\n         * @param {ImageUploader} imageUploader - UI Class\n         * @param {Event} e\n         */\n        addFileFromMediaGallery: function (imageUploader, e) {\n            var $buttonEl = $(e.target),\n                fileSize = $buttonEl.data('size'),\n                fileMimeType = $buttonEl.data('mime-type'),\n                filePathname = $buttonEl.val(),\n                fileBasename = filePathname.split('/').pop();\n\n            this.addFile({\n                type: fileMimeType,\n                name: fileBasename,\n                size: fileSize,\n                url: filePathname\n            });\n        },\n\n        /**\n         * Open the media browser dialog\n         *\n         * @param {ImageUploader} imageUploader - UI Class\n         * @param {Event} e\n         */\n        openMediaBrowserDialog: function (imageUploader, e) {\n            var $buttonEl = $(e.target),\n                openDialogUrl = this.mediaGallery.openDialogUrl +\n                'target_element_id/' + $buttonEl.attr('id') +\n                '/store/' + this.mediaGallery.storeId +\n                '/type/image/?isAjax=true';\n\n            if (this.mediaGallery.initialOpenSubpath) {\n                openDialogUrl += '&current_tree_path=' + Base64.idEncode(this.mediaGallery.initialOpenSubpath);\n            }\n\n            browser.openDialog(\n                openDialogUrl,\n                null,\n                null,\n                this.mediaGallery.openDialogTitle,\n                {\n                    targetElementId: $buttonEl.attr('id')\n                }\n            );\n        },\n\n        /**\n         * @param {jQuery.event} e\n         * @param {Object} data\n         * @returns {Object} Chainables\n         */\n        onDeleteFile: function (e, data) {\n            var fileId = this.getFileId(),\n                deletedFileIds = data.ids;\n\n            if (fileId && $.inArray(fileId, deletedFileIds) > -1) {\n                this.clear();\n            }\n\n            return this;\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        clear: function () {\n            this.value([]);\n\n            return this;\n        },\n\n        /**\n         * Gets the ID of the file used if set\n         *\n         * @return {String|Null} ID\n         */\n        getFileId: function () {\n            return this.hasData() ? this.value()[0].id : null;\n        },\n\n        /**\n         * Trigger native browser file upload UI via clicking on 'Upload' button\n         *\n         * @param {ImageUploader} imageUploader - UI Class\n         * @param {Event} e\n         */\n        triggerImageUpload: function (imageUploader, e) {\n            $(e.target).closest('.file-uploader').find('input[type=\"file\"]').trigger('click');\n        },\n\n        /**\n         * Get list of file extensions allowed in comma delimited format\n         *\n         * @return {String}\n         */\n        getAllowedFileExtensionsInCommaDelimitedFormat: function () {\n            var allowedExtensions = this.allowedExtensions.toUpperCase().split(' ');\n\n            // if jpg and jpeg in allowed extensions, remove jpeg from list\n            if (allowedExtensions.indexOf('JPG') !== -1 && allowedExtensions.indexOf('JPEG') !== -1) {\n                allowedExtensions.splice(allowedExtensions.indexOf('JPEG'), 1);\n            }\n\n            return allowedExtensions.join(', ');\n        }\n    });\n});\n","Magento_Ui/js/form/element/website.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    './select'\n], function (_, registry, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            customerId: null,\n            isGlobalScope: 0\n        },\n\n        /**\n         * Website component constructor.\n         * @returns {exports}\n         */\n        initialize: function () {\n            this._super();\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/color-picker-palette.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return [\n        [\n            'rgb(0,0,0)', 'rgb(52,52,52)', 'rgb(83,83,83)', 'rgb(135,135,135)', 'rgb(193,193,193)',\n            'rgb(234,234,234)', 'rgb(240,240,240)', 'rgb(255,255,255)'\n        ],\n        [\n            'rgb(252,0,9)', 'rgb(253,135,10)', 'rgb(255,255,13)', 'rgb(35,255,9)', 'rgb(33,255,255)',\n            'rgb(0,0,254)', 'rgb(132,0,254)', 'rgb(251,0,255)'\n        ],\n        [\n            'rgb(240,192,194)', 'rgb(251,223,194)', 'rgb(255,241,193)', 'rgb(210,230,201)',\n            'rgb(199,217,220)', 'rgb(197,219,240)', 'rgb(208,200,227)', 'rgb(229,199,212)'\n        ],\n        [\n            'rgb(228,133,135)', 'rgb(246,193,139)', 'rgb(254,225,136)', 'rgb(168,208,152)',\n            'rgb(146,184,190)', 'rgb(143,184,227)', 'rgb(165,148,204)', 'rgb(202,147,175)'\n        ],\n        [\n            'rgb(214,78,83)', 'rgb(243,163,88)', 'rgb(254,211,83)', 'rgb(130,187,106)',\n            'rgb(99,149,159)', 'rgb(93,150,211)', 'rgb(123,100,182)', 'rgb(180,100,142)'\n        ],\n        [\n            'rgb(190,0,5)', 'rgb(222,126,44)', 'rgb(236,183,39)', 'rgb(89,155,61)', 'rgb(55,110,123)',\n            'rgb(49,112,185)', 'rgb(83,55,150)', 'rgb(147,55,101)'\n        ],\n        [\n            'rgb(133,0,3)', 'rgb(163,74,10)', 'rgb(177,127,7)', 'rgb(45,101,23)', 'rgb(18,62,74)',\n            'rgb(14,62,129)', 'rgb(40,15,97)', 'rgb(95,16,55)'\n        ],\n        [\n            'rgb(81,0,1)', 'rgb(100,48,7)', 'rgb(107,78,3)', 'rgb(31,63,16)',\n            'rgb(13,39,46)', 'rgb(10,40,79)', 'rgb(24,12,59)', 'rgb(59,10,36)'\n        ]\n    ];\n});\n","Magento_Ui/js/form/element/url-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, layout, $t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            linkedElement: {},\n            settingTemplate: 'ui/form/element/urlInput/setting',\n            typeSelectorTemplate: 'ui/form/element/urlInput/typeSelector',\n            options: [],\n            linkedElementInstances: {},\n            //checkbox\n            isDisplayAdditionalSettings: true,\n            settingValue: false,\n            settingLabel: $t('Open in new tab'),\n            tracks: {\n                linkedElement: true\n            },\n            baseLinkSetting: {\n                namePrefix: '${$.name}.',\n                dataScopePrefix: '${$.dataScope}.',\n                provider: '${$.provider}'\n            },\n            urlTypes: {},\n            listens: {\n                settingValue: 'checked',\n                disabled: 'hideLinkedElement',\n                linkType: 'createChildUrlInputComponent'\n            },\n            links: {\n                linkType: '${$.provider}:${$.dataScope}.type',\n                settingValue: '${$.provider}:${$.dataScope}.setting'\n            }\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var processedLinkTypes = {},\n                baseLinkType = this.constructor.defaults.baseLinkSetting;\n\n            _.each(config.urlTypes, function (linkSettingsArray, linkName) {\n                //add link name by link type\n                linkSettingsArray.name = baseLinkType.namePrefix + linkName;\n                linkSettingsArray.dataScope = baseLinkType.dataScopePrefix + linkName;\n                linkSettingsArray.type = linkName;\n                linkSettingsArray.disabled = config.disabled;\n                linkSettingsArray.visible = config.visible;\n                processedLinkTypes[linkName] = {};\n                _.extend(processedLinkTypes[linkName], baseLinkType, linkSettingsArray);\n            });\n            _.extend(this.constructor.defaults.urlTypes, processedLinkTypes);\n\n            this._super();\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('componentTemplate options value linkType settingValue checked isDisplayAdditionalSettings')\n                .setOptions();\n\n            return this;\n        },\n\n        /**\n         * Set options to select based on link types configuration\n         *\n         * @return {Object}\n         */\n        setOptions: function () {\n            var result = [];\n\n            _.each(this.urlTypes, function (option, key) {\n                result.push({\n                    value: key,\n                    label: option.label,\n                    sortOrder: option.sortOrder || 0\n                });\n            });\n\n            //sort options by sortOrder\n            result.sort(function (a, b) {\n                return a.sortOrder > b.sortOrder ? 1 : -1;\n            });\n\n            this.options(result);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setPreview: function (visible) {\n            this.linkedElement().visible(visible);\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @param {Boolean} disabled\n         */\n        hideLinkedElement: function (disabled) {\n            this.linkedElement().disabled(disabled);\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            _.each(this.linkedElementInstances, function (value) {\n                value().destroy();\n            });\n            this._super();\n        },\n\n        /**\n         * Create child component by value\n         *\n         * @param {String} value\n         * @return void\n         */\n        createChildUrlInputComponent: function (value) {\n            var elementConfig;\n\n            if (!_.isEmpty(value) && _.isUndefined(this.linkedElementInstances[value])) {\n                elementConfig = this.urlTypes[value];\n                layout([elementConfig]);\n                this.linkedElementInstances[value] = this.requestModule(elementConfig.name);\n            }\n            this.linkedElement = this.linkedElementInstances[value];\n\n        },\n\n        /**\n         * Returns linked element to display related field in template\n         * @return String\n         */\n        getLinkedElementName: function () {\n            return this.linkedElement;\n        },\n\n        /**\n         * Add ability to choose check box by clicking on label\n         */\n        checkboxClick: function () {\n            if (!this.disabled()) {\n                this.settingValue(!this.settingValue());\n            }\n        }\n    });\n});\n","Magento_Ui/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    './select',\n    'Magento_Checkout/js/model/default-post-code-resolver'\n], function (_, registry, Select, defaultPostCodeResolver) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            skipValidation: false,\n            imports: {\n                countryOptions: '${ $.parentName }.country_id:indexedOptions',\n                update: '${ $.parentName }.country_id:value'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            var option;\n\n            this._super();\n\n            option = _.find(this.countryOptions, function (row) {\n                return row['is_default'] === true;\n            });\n            this.hideRegion(option);\n\n            return this;\n        },\n\n        /**\n         * Method called every time country selector's value gets changed.\n         * Updates all validations and requirements for certain country.\n         * @param {String} value - Selected country ID.\n         */\n        update: function (value) {\n            var isRegionRequired,\n                option;\n\n            if (!value) {\n                return;\n            }\n\n            option = _.isObject(this.countryOptions) && this.countryOptions[value];\n\n            if (!option) {\n                return;\n            }\n\n            this.hideRegion(option);\n\n            defaultPostCodeResolver.setUseDefaultPostCode(!option['is_zipcode_optional']);\n\n            isRegionRequired = !this.skipValidation && !!option['is_region_required'];\n\n            if (!isRegionRequired) {\n                this.error(false);\n            }\n\n            this.required(isRegionRequired);\n            this.validation['required-entry'] = isRegionRequired;\n\n            registry.get(this.customName, function (input) {\n                input.required(isRegionRequired);\n                input.validation['required-entry'] = isRegionRequired;\n                input.validation['validate-not-number-first'] = !this.options().length;\n            }.bind(this));\n        },\n\n        /**\n         * Hide select and corresponding text input field if region must not be shown for selected country.\n         *\n         * @private\n         * @param {Object}option\n         */\n        hideRegion: function (option) {\n            if (!option || option['is_region_visible'] !== false) {\n                return;\n            }\n\n            this.setVisible(false);\n\n            if (this.customEntry) {\n                this.toggleInput(false);\n            }\n        }\n    });\n});\n","Magento_Ui/js/form/element/wysiwyg.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'wysiwygAdapter',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'ko',\n    './abstract',\n    'mage/adminhtml/events',\n    'Magento_Variable/variables'\n], function (wysiwyg, $, _, ko, Abstract, varienGlobalEvents) {\n    'use strict';\n\n    return Abstract.extend({\n        currentWysiwyg: undefined,\n        defaults: {\n            elementSelector: 'textarea',\n            suffixRegExpPattern: '${ $.wysiwygUniqueSuffix }',\n            $wysiwygEditorButton: '',\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            },\n            template: 'ui/form/field',\n            elementTmpl: 'ui/form/element/wysiwyg',\n            content:        '',\n            showSpinner:    false,\n            loading:        false,\n            listens: {\n                disabled: 'setDisabled'\n            }\n        },\n\n        /**\n         *\n         * @returns {} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initNodeListener();\n\n            $.async({\n                component: this,\n                selector: 'button'\n            }, function (element) {\n                this.$wysiwygEditorButton = this.$wysiwygEditorButton ?\n                    this.$wysiwygEditorButton.add($(element)) : $(element);\n            }.bind(this));\n\n            // disable editor completely after initialization is field is disabled\n            varienGlobalEvents.attachEventHandler('wysiwygEditorInitialized', function () {\n                if (!_.isUndefined(window.tinyMceEditors)) {\n                    this.currentWysiwyg = window.tinyMceEditors[this.wysiwygId];\n                }\n\n                if (this.disabled()) {\n                    this.setDisabled(true);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var pattern = config.suffixRegExpPattern || this.constructor.defaults.suffixRegExpPattern;\n\n            pattern = pattern.replace(/\\$/g, '\\\\$&');\n            config.content = config.content.replace(new RegExp(pattern, 'g'), this.getUniqueSuffix(config));\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Build unique id based on name, underscore separated.\n         *\n         * @param {Object} config\n         */\n        getUniqueSuffix: function (config) {\n            return config.name.replace(/(\\.|-)/g, '_');\n        },\n\n        /**\n         * @inheritdoc\n         */\n        destroy: function () {\n            this._super();\n            wysiwyg.removeEvents(this.wysiwygId);\n        },\n\n        /**\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['value', 'content']);\n\n            return this;\n        },\n\n        /**\n         *\n         * @returns {} Chainable.\n         */\n        initNodeListener: function () {\n            $.async({\n                component: this,\n                selector: this.elementSelector\n            }, this.setElementNode.bind(this));\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {HTMLElement} node\n         */\n        setElementNode: function (node) {\n            $(node).bindings({\n                value: this.value\n            });\n        },\n\n        /**\n         * Set disabled property to wysiwyg component\n         *\n         * @param {Boolean} disabled\n         */\n        setDisabled: function (disabled) {\n            if (this.$wysiwygEditorButton && disabled) {\n                this.$wysiwygEditorButton.prop('disabled', 'disabled');\n            } else if (this.$wysiwygEditorButton) {\n                this.$wysiwygEditorButton.prop('disabled', false);\n            }\n\n            /* eslint-disable no-undef */\n            if (!_.isUndefined(this.currentWysiwyg) && this.currentWysiwyg.activeEditor()) {\n                this.currentWysiwyg.setEnabledStatus(!disabled);\n                this.currentWysiwyg.getPluginButtons().prop('disabled', disabled);\n            }\n        },\n\n        /**\n         * Content getter\n         *\n         * @returns {String}\n         */\n        getContentUnsanitizedHtml: function () {\n            return this.content();\n        }\n    });\n});\n","Magento_Ui/js/form/element/boolean.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            checked: false,\n            links: {\n                checked: 'value'\n            }\n        },\n\n        /**\n         * @returns {*|void|Element}\n         */\n        initObservable: function () {\n            return this._super()\n                    .observe('checked');\n        },\n\n        /**\n         * Converts provided value to boolean.\n         *\n         * @returns {Boolean}\n         */\n        normalizeData: function () {\n            return !!+this._super();\n        },\n\n        /**\n         * Calls 'onUpdate' method of parent, if value is defined and instance's\n         *     'unique' property set to true, calls 'setUnique' method\n         *\n         * @return {Object} - reference to instance\n         */\n        onUpdate: function () {\n            if (this.hasUnique) {\n                this.setUnique();\n            }\n\n            return this._super();\n        }\n    });\n});\n","Magento_Ui/js/lib/spinner.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var selector = '[data-role=\"spinner\"]',\n        spinner = $(selector);\n\n    return {\n        /**\n         * Show spinner.\n         */\n        show: function () {\n            spinner.show();\n        },\n\n        /**\n         * Hide spinner.\n         */\n        hide: function () {\n            spinner.hide();\n        },\n\n        /**\n         * Get spinner by selector.\n         *\n         * @param {String} id\n         * @return {jQuery}\n         */\n        get: function (id) {\n            return $(selector + '[data-component=\"' + id + '\"]');\n        }\n    };\n});\n","Magento_Ui/js/lib/step-wizard.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiRegistry',\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'ko',\n    'mage/backend/notification',\n    'mage/translate'\n], function (uiRegistry, Component, $, _, ko) {\n    'use strict';\n\n    var Wizard;\n\n    ko.utils.domNodeDisposal.cleanExternalData = _.wrap(\n        ko.utils.domNodeDisposal.cleanExternalData,\n        function (func, node) {\n            if (!$(node).closest('[data-type=skipKO]').length) {\n                func(node);\n            }\n        }\n    );\n\n    /**\n     * Wizard constructor.\n     *\n     * @param {Array} steps\n     * @param {String} modalClass\n     * @constructor\n     */\n    Wizard = function (steps, modalClass) {\n        this.steps = steps;\n        this.index = 0;\n        this.data = {};\n        this.nextLabelText = $.mage.__('Next');\n        this.prevLabelText = $.mage.__('Back');\n        this.elementSelector = '[data-role=steps-wizard-main]';\n        this.element = modalClass ? $('.' + modalClass + this.elementSelector) : $(this.elementSelector);\n        this.nextLabel = '[data-role=\"step-wizard-next\"]';\n        this.prevLabel = '[data-role=\"step-wizard-prev\"]';\n        this.element.notification();\n\n        /**\n         * Move to newIndex.\n         *\n         * @param {Number} newIndex\n         * @return {String}\n         */\n        this.move = function (newIndex) {\n            if (!this.preventSwitch(newIndex)) {\n                if (newIndex > this.index) {\n                    this._next(newIndex);\n                } else if (newIndex < this.index) {\n                    this._prev(newIndex);\n                }\n            }\n            this.updateLabels(this.getStep());\n            this.showNotificationMessage();\n\n            return this.getStep().name;\n        };\n\n        /**\n         * Move wizard to next step.\n         *\n         * @return {String}\n         */\n        this.next = function () {\n            this.move(this.index + 1);\n\n            return this.getStep().name;\n        };\n\n        /**\n         * Move wizard to previous step.\n         *\n         * @return {String}\n         */\n        this.prev = function () {\n            this.move(this.index - 1);\n\n            return this.getStep().name;\n        };\n\n        /**\n         * @return {*}\n         */\n        this.preventSwitch = function (newIndex) {\n            return newIndex < 0 || (newIndex - this.index) > 1;//eslint-disable-line no-extra-parens\n        };\n\n        /**\n         * @param {Number} newIndex\n         * @return {Boolean}\n         * @private\n         */\n        this._next = function (newIndex) {\n            newIndex = _.isNumber(newIndex) ? newIndex : this.index + 1;\n\n            try {\n                this.getStep().force(this);\n\n                if (newIndex >= steps.length) {\n                    return false;\n                }\n            } catch (e) {\n                this.setNotificationMessage(e.message, true);\n\n                return false;\n            }\n            this.cleanErrorNotificationMessage();\n            this.index = newIndex;\n            this.cleanNotificationMessage();\n            this.render();\n        };\n\n        /**\n         * @param {Number} newIndex\n         * @private\n         */\n        this._prev = function (newIndex) {\n            newIndex = _.isNumber(newIndex) ? newIndex : this.index - 1;\n            this.getStep().back(this);\n            this.index = newIndex;\n        };\n\n        /**\n         * @param {Number} stepIndex\n         * @return {Object}\n         */\n        this.getStep = function (stepIndex) {\n            return this.steps[stepIndex || this.index] || {};\n        };\n\n        /**\n         * @param {String} message\n         * @param {String} error\n         */\n        this.notifyMessage = function (message, error) {\n            $(this.element).notification('clear').notification('add', {\n                error: error,\n                message: message\n            });\n        };\n\n        /**\n         * @param {Object} step\n         */\n        this.updateLabels = function (step) {\n            this.element.find(this.nextLabel).find('button').text(step.nextLabelText || this.nextLabelText);\n            this.element.find(this.prevLabel).find('button').text(step.prevLabelText || this.prevLabelText);\n        };\n\n        /**\n         * Show notification message.\n         */\n        this.showNotificationMessage = function () {\n            if (!_.isEmpty(this.getStep())) {\n                this.hideNotificationMessage();\n\n                if (this.getStep().notificationMessage.text !== null) {\n                    this.notifyMessage(\n                        this.getStep().notificationMessage.text,\n                        this.getStep().notificationMessage.error\n                    );\n                }\n            }\n        };\n\n        /**\n         * Remove notification message.\n         */\n        this.cleanNotificationMessage = function () {\n            this.getStep().notificationMessage.text = null;\n            this.hideNotificationMessage();\n        };\n\n        /**\n         * Remove error message.\n         */\n        this.cleanErrorNotificationMessage = function () {\n            if (this.getStep().notificationMessage.error === true) {\n                this.cleanNotificationMessage();\n            }\n        };\n\n        /**\n         * @param {String} text\n         * @param {String} error\n         */\n        this.setNotificationMessage = function (text, error) {\n            error = error !== undefined;\n\n            if (!_.isEmpty(this.getStep())) {\n                this.getStep().notificationMessage.text = text;\n                this.getStep().notificationMessage.error = error;\n                this.showNotificationMessage();\n            }\n        };\n\n        /**\n         * Hide notification message.\n         */\n        this.hideNotificationMessage = function () {\n            $(this.element).notification('clear');\n        };\n\n        /**\n         * Render step.\n         */\n        this.render = function () {\n            this.hideNotificationMessage();\n            this.getStep().render(this);\n        };\n\n        /**\n         * Initialize step.\n         */\n        this.init = function () {\n            this.updateLabels(this.getStep());\n            this.render();\n        };\n        this.init();\n    };\n\n    return Component.extend({\n        defaults: {\n            modalClass: '',\n            initData: [],\n            stepsNames: [],\n            selectedStep: '',\n            steps: [],\n            disabled: true\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selectedStep.subscribe(this.wrapDisabledBackButton.bind(this));\n        },\n\n        /** @inheritdoc */\n        initElement: function (step) {\n            step.initData = this.initData;\n            step.mode = _.all(this.initData, _.isEmpty) ? 'create' : 'edit';\n            this.steps[this.getStepIndexByName(step.name)] = step;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe([\n                'selectedStep',\n                'disabled'\n            ]);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            _.each(this.steps, function (step) {\n                step.destroy();\n            });\n\n            this._super();\n        },\n\n        /**\n         * Toggle disable property.\n         *\n         * @param {String} stepName\n         */\n        wrapDisabledBackButton: function (stepName) {\n            if (_.first(this.stepsNames) === stepName) {\n                this.disabled(true);\n            } else {\n                this.disabled(false);\n            }\n        },\n\n        /**\n         * Get step by index name.\n         *\n         * @param {String} stepName\n         */\n        getStepIndexByName: function (stepName) {\n            return _.indexOf(this.stepsNames, stepName);\n        },\n        //controls, todo to another object\n        /**\n         * Select next step.\n         */\n        next: function () {\n            this.selectedStep(this.wizard.next());\n        },\n\n        /**\n         * Select previous step.\n         */\n        back: function () {\n            this.selectedStep(this.wizard.prev());\n        },\n\n        /**\n         * Open wizard.\n         */\n        open: function () {\n            this.selectedStep(this.stepsNames.first());\n            this.wizard = new Wizard(this.steps, this.modalClass);\n        },\n\n        /**\n         * Close wizard.\n         */\n        close: function () {\n            var modal =  uiRegistry.get(this.initData.configurableModal);\n\n            if (!_.isUndefined(modal)) {\n                modal.closeModal();\n            }\n        },\n\n        /**\n         * @param {Object} data\n         * @param {Object} event\n         */\n        showSpecificStep: function (data, event) {\n            var index = _.indexOf(this.stepsNames, event.target.hash.substr(1)),\n                stepName = this.wizard.move(index);\n\n            this.selectedStep(stepName);\n        }\n    });\n});\n","Magento_Ui/js/lib/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            collapsible: true\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('opened');\n\n            return this;\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        toggleOpened: function () {\n            this.opened() ?\n                this.close() :\n                this.open();\n\n            return this;\n        },\n\n        /**\n         * Sets 'opened' flag to false.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        close: function () {\n            if (this.collapsible) {\n                this.opened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets 'opened' flag to true.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        open: function () {\n            if (this.collapsible) {\n                this.opened(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/lib/key-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        13: 'enterKey',\n        27: 'escapeKey',\n        40: 'pageDownKey',\n        38: 'pageUpKey',\n        32: 'spaceKey',\n        9:  'tabKey',\n        37: 'pageLeftKey',\n        39: 'pageRightKey',\n        17: 'ctrlKey',\n        18: 'altKey',\n        16: 'shiftKey',\n        191: 'forwardSlashKey',\n        66: 'bKey',\n        73: 'iKey',\n        85: 'uKey'\n    };\n});\n","Magento_Ui/js/lib/view/utils/bindings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore'\n], function (ko, $, _) {\n    'use strict';\n\n    /**\n     * Checks if provided  value is a dom element.\n     *\n     * @param {*} node - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isDomElement(node) {\n        return typeof node === 'object' && node.tagName && node.nodeType;\n    }\n\n    /**\n     * Removes from the provided array all non-root nodes located inside\n     * of the comment element as long as the closing comment tags.\n     *\n     * @param {(Array|ArrayLike)} nodes - An array of nodes to be processed.\n     * @returns {Array}\n     */\n    function normalize(nodes) {\n        var result;\n\n        nodes   = _.toArray(nodes);\n        result  = nodes.slice();\n\n        nodes.forEach(function (node) {\n            if (node.nodeType === 8) {\n                result = !ko.virtualElements.hasBindingValue(node) ?\n                    _.without(result, node) :\n                    _.difference(result, ko.virtualElements.childNodes(node));\n            }\n        });\n\n        return result;\n    }\n\n    /**\n     * Extends binding context of each item in the collection.\n     *\n     * @param {...Object} extenders - Multiple extender objects to be applied to the context.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.extendCtx = function () {\n        var nodes       = normalize(this),\n            extenders   = _.toArray(arguments);\n\n        nodes.forEach(function (node) {\n            var ctx  = ko.contextFor(node),\n                data = [ctx].concat(extenders);\n\n            _.extend.apply(_, data);\n        });\n\n        return this;\n    };\n\n    /**\n     * Evaluates bindings specified in each DOM element of collection.\n     *\n     * @param {(HTMLElement|Object)} [ctx] - Context to use for bindings evaluation.\n     *      If not specified then current context of a collections' item will be used.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.applyBindings = function (ctx) {\n        var nodes = normalize(this),\n            nodeCtx;\n\n        if (isDomElement(ctx)) {\n            ctx = ko.contextFor(ctx);\n        }\n\n        nodes.forEach(function (node) {\n            nodeCtx = ctx || ko.contextFor(node);\n\n            ko.applyBindings(nodeCtx, node);\n        });\n\n        return this;\n    };\n\n    /**\n     * Adds specified bindings to each DOM element in\n     * collection and evaluates them with provided context.\n     *\n     * @param {(Object|Function)} data - Either bindings object or a function\n     *      which returns bindings data for each element in collection.\n     * @param {(HTMLElement|Object)} [ctx] - Context to use for bindings evaluation.\n     *      If not specified then current context of a collections' item will be used.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.bindings = function (data, ctx) {\n        var nodes    = normalize(this),\n            bindings = data,\n            nodeCtx;\n\n        if (isDomElement(ctx)) {\n            ctx = ko.contextFor(ctx);\n        }\n\n        nodes.forEach(function (node) {\n            nodeCtx = ctx || ko.contextFor(node);\n\n            if (_.isFunction(data)) {\n                bindings = data(nodeCtx, node);\n            }\n\n            ko.applyBindingsToNode(node, bindings, nodeCtx);\n        });\n\n        return this;\n    };\n});\n","Magento_Ui/js/lib/view/utils/dom-observer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'domReady!'\n], function ($, _) {\n    'use strict';\n\n    var counter = 1,\n        watchers,\n        globalObserver,\n        disabledNodes = [];\n\n    watchers = {\n        selectors: {},\n        nodes: {}\n    };\n\n    /**\n     * Checks if node represents an element node (nodeType === 1).\n     *\n     * @param {HTMLElement} node\n     * @returns {Boolean}\n     */\n    function isElementNode(node) {\n        return node.nodeType === 1;\n    }\n\n    /**\n     * Extracts all child descendant\n     * elements of a specified node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Array}\n     */\n    function extractChildren(node) {\n        var children = node.querySelectorAll('*');\n\n        return _.toArray(children);\n    }\n\n    /**\n     * Extracts node identifier. If ID is not specified,\n     * then it will be created for the provided node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Number}\n     */\n    function getNodeId(node) {\n        var id = node._observeId;\n\n        if (!id) {\n            id = node._observeId = counter++;\n        }\n\n        return id;\n    }\n\n    /**\n     * Invokes callback passing node to it.\n     *\n     * @param {HTMLElement} node\n     * @param {Object} data\n     */\n    function trigger(node, data) {\n        var id = getNodeId(node),\n            ids = data.invoked;\n\n        if (_.contains(ids, id)) {\n            return;\n        }\n\n        data.callback(node);\n        data.invoked.push(id);\n    }\n\n    /**\n     * Adds node to the observer list.\n     *\n     * @param {HTMLElement} node\n     * @returns {Object}\n     */\n    function createNodeData(node) {\n        var nodes   = watchers.nodes,\n            id      = getNodeId(node);\n\n        nodes[id] = nodes[id] || {};\n\n        return nodes[id];\n    }\n\n    /**\n     * Returns data associated with a specified node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Object|Undefined}\n     */\n    function getNodeData(node) {\n        var nodeId = node._observeId;\n\n        return watchers.nodes[nodeId];\n    }\n\n    /**\n     * Removes data associated with a specified node.\n     *\n     * @param {HTMLElement} node\n     */\n    function removeNodeData(node) {\n        var nodeId = node._observeId;\n\n        delete watchers.nodes[nodeId];\n    }\n\n    /**\n     * Adds removal listener for a specified node.\n     *\n     * @param {HTMLElement} node\n     * @param {Object} data\n     */\n    function addRemovalListener(node, data) {\n        var nodeData = createNodeData(node);\n\n        (nodeData.remove = nodeData.remove || []).push(data);\n    }\n\n    /**\n     * Adds listener for the nodes which matches specified selector.\n     *\n     * @param {String} selector - CSS selector.\n     * @param {Object} data\n     */\n    function addSelectorListener(selector, data) {\n        var storage = watchers.selectors;\n\n        (storage[selector] = storage[selector] || []).push(data);\n    }\n\n    /**\n     * Calls handlers associated with an added node.\n     * Adds listeners for the node removal.\n     *\n     * @param {HTMLElement} node - Added node.\n     */\n    function processAdded(node) {\n        _.each(watchers.selectors, function (listeners, selector) {\n            listeners.forEach(function (data) {\n                if (!data.ctx.contains(node) || !$(node, data.ctx).is(selector)) {\n                    return;\n                }\n\n                if (data.type === 'add') {\n                    trigger(node, data);\n                } else if (data.type === 'remove') {\n                    addRemovalListener(node, data);\n                }\n            });\n        });\n    }\n\n    /**\n     * Calls handlers associated with a removed node.\n     *\n     * @param {HTMLElement} node - Removed node.\n     */\n    function processRemoved(node) {\n        var nodeData    = getNodeData(node),\n            listeners   = nodeData && nodeData.remove;\n\n        if (!listeners) {\n            return;\n        }\n\n        listeners.forEach(function (data) {\n            trigger(node, data);\n        });\n\n        removeNodeData(node);\n    }\n\n    /**\n     * Removes all non-element nodes from provided array\n     * and appends to it descendant elements.\n     *\n     * @param {Array} nodes\n     * @returns {Array}\n     */\n    function formNodesList(nodes) {\n        var result = [],\n            children;\n\n        nodes = _.toArray(nodes).filter(isElementNode);\n\n        nodes.forEach(function (node) {\n            result.push(node);\n\n            children = extractChildren(node);\n            result   = result.concat(children);\n        });\n\n        return result;\n    }\n\n    /**\n     * Collects all removed and added nodes from\n     * mutation records into separate arrays\n     * while removing duplicates between both types of changes.\n     *\n     * @param {Array} mutations - An array of mutation records.\n     * @returns {Object} Object with 'removed' and 'added' nodes arrays.\n     */\n    function formChangesLists(mutations) {\n        var removed = [],\n            added = [];\n\n        mutations.forEach(function (record) {\n            removed = removed.concat(_.toArray(record.removedNodes));\n            added   = added.concat(_.toArray(record.addedNodes));\n        });\n\n        removed = removed.filter(function (node) {\n            var addIndex = added.indexOf(node),\n                wasAdded = !!~addIndex;\n\n            if (wasAdded) {\n                added.splice(addIndex, 1);\n            }\n\n            return !wasAdded;\n        });\n\n        return {\n            removed: formNodesList(removed),\n            added: formNodesList(added)\n        };\n    }\n\n    /**\n     * Verify if the DOM node is a child of a defined disabled node, if so we shouldn't observe provided mutation.\n     *\n     * @param {Object} mutation - a single mutation\n     * @returns {Boolean}\n     */\n    function shouldObserveMutation(mutation) {\n        var isDisabled;\n\n        if (disabledNodes.length > 0) {\n            // Iterate through the disabled nodes and determine if this mutation is occurring inside one of them\n            isDisabled = _.find(disabledNodes, function (node) {\n                return node === mutation.target || $.contains(node, mutation.target);\n            });\n\n            // If we find a matching node we should not observe the mutation\n            return !isDisabled;\n        }\n\n        return true;\n    }\n\n    /**\n     * Should we observe these mutations? Check the first and last mutation to determine if this is a disabled mutation,\n     * we check both the first and last in case one has been removed from the DOM during the process of the mutation.\n     *\n     * @param {Array} mutations - An array of mutation records.\n     * @returns {Boolean}\n     */\n    function shouldObserveMutations(mutations) {\n        var firstMutation,\n            lastMutation;\n\n        if (mutations.length > 0) {\n            firstMutation = mutations[0];\n            lastMutation = mutations[mutations.length - 1];\n\n            return shouldObserveMutation(firstMutation) && shouldObserveMutation(lastMutation);\n        }\n\n        return true;\n    }\n\n    globalObserver = new MutationObserver(function (mutations) {\n        var changes;\n\n        if (shouldObserveMutations(mutations)) {\n            changes = formChangesLists(mutations);\n\n            changes.removed.forEach(processRemoved);\n            changes.added.forEach(processAdded);\n        }\n    });\n\n    globalObserver.observe(document.body, {\n        subtree: true,\n        childList: true\n    });\n\n    return {\n        /**\n         * Disable a node from being observed by the mutations, you may want to disable specific aspects of the\n         * application which are heavy on DOM changes. The observer running on some actions could cause significant\n         * delays and degrade the performance of that specific part of the application exponentially.\n         *\n         * @param {HTMLElement} node - a HTML node within the document\n         */\n        disableNode: function (node) {\n            disabledNodes.push(node);\n        },\n\n        /**\n         * Adds listener for the appearance of nodes that matches provided\n         * selector and which are inside of the provided context. Callback will be\n         * also invoked on elements which a currently present.\n         *\n         * @param {String} selector - CSS selector.\n         * @param {Function} callback - Function that will invoked when node appears.\n         * @param {HTMLElement} [ctx=document.body] - Context inside of which to search for the node.\n         */\n        get: function (selector, callback, ctx) {\n            var data,\n                nodes;\n\n            data = {\n                ctx: ctx || document.body,\n                type: 'add',\n                callback: callback,\n                invoked: []\n            };\n\n            nodes = $(selector, data.ctx).toArray();\n\n            nodes.forEach(function (node) {\n                trigger(node, data);\n            });\n\n            addSelectorListener(selector, data);\n        },\n\n        /**\n         * Adds listener for the nodes removal.\n         *\n         * @param {(jQueryObject|HTMLElement|Array|String)} selector\n         * @param {Function} callback - Function that will invoked when node is removed.\n         * @param {HTMLElement} [ctx=document.body] - Context inside of which to search for the node.\n         */\n        remove: function (selector, callback, ctx) {\n            var nodes = [],\n                data;\n\n            data = {\n                ctx: ctx || document.body,\n                type: 'remove',\n                callback: callback,\n                invoked: []\n            };\n\n            if (typeof selector === 'object') {\n                nodes = !_.isUndefined(selector.length) ?\n                    _.toArray(selector) :\n                    [selector];\n            } else if (_.isString(selector)) {\n                nodes = $(selector, ctx).toArray();\n\n                addSelectorListener(selector, data);\n            }\n\n            nodes.forEach(function (node) {\n                addRemovalListener(node, data);\n            });\n        },\n\n        /**\n         * Removes listeners.\n         *\n         * @param {String} selector\n         * @param {Function} [fn]\n         */\n        off: function (selector, fn) {\n            var selectors = watchers.selectors,\n                listeners = selectors[selector];\n\n            if (selector && !fn) {\n                delete selectors[selector];\n            } else if (listeners && fn) {\n                selectors[selector] = listeners.filter(function (data) {\n                    return data.callback !== fn;\n                });\n            }\n        }\n    };\n});\n","Magento_Ui/js/lib/view/utils/raf.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var processMap = new WeakMap(),\n        origRaf,\n        raf;\n\n    origRaf = window.requestAnimationFrame ||\n        window.webkitRequestAnimationFrame ||\n        window.mozRequestAnimationFrame ||\n        window.onRequestAnimationFrame ||\n        window.msRequestAnimationFrame ||\n        function (callback) {\n            if (typeof callback != 'function') {\n                throw new Error('raf argument \"callback\" must be of type function');\n            }\n            window.setTimeout(callback, 1000 / 60);\n        };\n\n    /**\n     * Creates new process object or extracts the\n     * the existing one.\n     *\n     * @param {*} id - Process identifier.\n     * @param {Number} fps - Required FPS count.\n     * @returns {Object}\n     */\n    function getProcess(id, fps) {\n        var process = processMap.get(id);\n\n        if (!process) {\n            process = {};\n            processMap.set(id, process);\n        }\n\n        if (process.fps !== fps) {\n            process.fps        = fps;\n            process.interval   = 1000 / fps;\n            process.update     = Date.now();\n        }\n\n        return process;\n    }\n\n    /**\n     * Proxy method which delegates call to the 'requestAnimationFrame'\n     * function and optionally can keep track of the FPS with which\n     * provided function is called.\n     *\n     * @param {Function} callback - Callback function to be passed to 'requestAnimationFrame'.\n     * @param {Number} [fps] - If specified, will update FPS counter for the provided function.\n     * @returns {Number|Boolean} ID of request or a flag which indicates\n     *      whether callback fits specified FPS.\n     */\n    raf = function (callback, fps) {\n        var rafId = origRaf(callback);\n\n        return fps ? raf.tick(callback, fps) : rafId;\n    };\n\n    /**\n     * Updates FPS counter for the specified process\n     * and returns a flag which indicates whether\n     * counter value is equal or greater than the required FPS.\n     *\n     * @param {*} id - Process identifier.\n     * @param {Number} fps - Required FPS count.\n     * @returns {Boolean}\n     */\n    raf.tick = function (id, fps) {\n        var process  = getProcess(id, fps),\n            now      = Date.now(),\n            delta    = now - process.update,\n            interval = process.interval;\n\n        if (fps >= 60 || delta >= interval) {\n            process.update = now - delta % interval;\n\n            return true;\n        }\n\n        return false;\n    };\n\n    return raf;\n});\n","Magento_Ui/js/lib/view/utils/async.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    './dom-observer',\n    'Magento_Ui/js/lib/knockout/extender/bound-nodes',\n    './bindings'\n], function (ko, $, _, registry, domObserver, boundedNodes) {\n    'use strict';\n\n    /**\n     * Checks if provided value is a dom element.\n     *\n     * @param {*} node - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isDomElement(node) {\n        return typeof node === 'object' && node.tagName && node.nodeType;\n    }\n\n    /**\n     * Parses provided string and extracts\n     * component, context and selector data from it.\n     *\n     * @param {String} str - String to be processed.\n     * @returns {Object} Data retrieved from string.\n     *\n     * @example Sample format.\n     *      '{{component}}:{{ctx}} -> {{selector}}'\n     *\n     *      component - Name of component.\n     *      ctx - Selector of the root node upon which component is binded.\n     *      selector - Selector of DOM elements located\n     *          inside of a previously specified context.\n     */\n    function parseSelector(str) {\n        var data    = str.trim().split('->'),\n            result  = {},\n            componentData;\n\n        if (data.length === 1) {\n            if (!~data[0].indexOf(':')) {\n                result.selector = data[0];\n            } else {\n                componentData = data[0];\n            }\n        } else {\n            componentData   = data[0];\n            result.selector = data[1];\n        }\n\n        if (componentData) {\n            componentData = componentData.split(':');\n\n            result.component = componentData[0];\n            result.ctx = componentData[1];\n        }\n\n        _.each(result, function (value, key) {\n            result[key] = value.trim();\n        });\n\n        return result;\n    }\n\n    /**\n     * Internal method used to normalize argumnets passed\n     * to 'async' module methods.\n     *\n     * @param {(String|Object)} selector\n     * @param {(HTMLElement|Object|String)} [ctx]\n     * @returns {Object}\n     */\n    function parseData(selector, ctx) {\n        var data = {};\n\n        if (arguments.length === 2) {\n            data.selector = selector;\n\n            if (isDomElement(ctx)) {\n                data.ctx = ctx;\n            } else {\n                data.component = ctx;\n                data.ctx = '*';\n            }\n        } else {\n            data = _.isString(selector) ?\n                parseSelector(selector) :\n                selector;\n        }\n\n        return data;\n    }\n\n    /**\n     * Creates promise that will be resolved\n     * when requested component is registred.\n     *\n     * @param {String} name - Name of component.\n     * @returns {jQueryPromise}\n     */\n    function waitComponent(name) {\n        var deffer = $.Deferred();\n\n        if (_.isString(name)) {\n            registry.get(name, function (component) {\n                deffer.resolve(component);\n            });\n        } else {\n            deffer.resolve(name);\n        }\n\n        return deffer.promise();\n    }\n\n    /**\n     * Creates listener for the nodes binded to provided component.\n     *\n     * @param {Object} data - Listener data.\n     * @param {Object} component - Associated with nodes component.\n     */\n    function setRootListener(data, component) {\n        boundedNodes.get(component, function (root) {\n            if (!$(root).is(data.ctx || '*')) {\n                return;\n            }\n\n            data.selector ?\n                domObserver.get(data.selector, data.fn, root) :\n                data.fn(root);\n        });\n    }\n\n    /*eslint-disable no-unused-vars*/\n    /**\n     * Sets listener for the appearance of elements which\n     * matches specified selector data.\n     *\n     * @param {(String|Object)} selector - Valid css selector or a string\n     *      in format acceptable by 'parseSelector' method or an object with\n     *      'component', 'selector' and 'ctx' properties.\n     * @param {(HTMLElement|Object|String)} [ctx] - Optional context parameter\n     *      which might be a DOM element, component instance or components' name.\n     * @param {Function} fn - Callback that will be invoked\n     *      when required DOM element appears.\n     *\n     * @example\n     *      Creating listener of the 'span' nodes appearance,\n     *      located inside of 'div' nodes, which are binded to 'cms_page_listing' component:\n     *\n     *      $.async('cms_page_listing:div -> span', function (node) {});\n     *\n     * @example Another syntaxes of the previous example.\n     *      $.async({\n     *          component: 'cms_page_listing',\n     *          ctx: 'div',\n     *          selector: 'span'\n     *       }, function (node) {});\n     *\n     * @example Listens for appearance of any child node inside of specified component.\n     *      $.async('> *', 'cms_page_lsiting', function (node) {});\n     *\n     * @example Listens for appearance of 'span' nodes inside of specific context.\n     *      $.async('span', document.getElementById('test'), function (node) {});\n     */\n    $.async = function (selector, ctx, fn) {\n        var args = _.toArray(arguments),\n            data = parseData.apply(null, _.initial(args));\n\n        data.fn = _.last(args);\n\n        if (data.component) {\n            waitComponent(data.component)\n                .then(setRootListener.bind(null, data));\n        } else {\n            domObserver.get(data.selector, data.fn, data.ctx);\n        }\n    };\n\n    /*eslint-enable no-unused-vars*/\n\n    _.extend($.async, {\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Returns collection of elements found by provided selector data.\n         *\n         * @param {(String|Object)} selector - See 'async' definition.\n         * @param {(HTMLElement|Object|String)} [ctx] - See 'async' definition.\n         * @returns {Array} An array of DOM elements.\n         */\n        get: function (selector, ctx) {\n            var data        = parseData.apply(null, arguments),\n                component   = data.component,\n                nodes;\n\n            if (!component) {\n                return $(data.selector, data.ctx).toArray();\n            } else if (_.isString(component)) {\n                component = registry.get(component);\n            }\n\n            if (!component) {\n                return [];\n            }\n\n            nodes = boundedNodes.get(component);\n            nodes = $(nodes).filter(data.ctx).toArray();\n\n            return data.selector ?\n                $(data.selector, nodes).toArray() :\n                nodes;\n        },\n\n        /*eslint-enable no-unused-vars*/\n\n        /**\n         * Sets removal listener of the specified nodes.\n         *\n         * @param {(HTMLElement|Array|ArrayLike)} nodes - Nodes whose removal to track.\n         * @param {Function} fn - Callback that will be invoked when node is removed.\n         */\n        remove: function (nodes, fn) {\n            domObserver.remove(nodes, fn);\n        },\n\n        parseSelector: parseSelector\n    });\n\n    return $;\n});\n","Magento_Ui/js/lib/registry/registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var privateData = new WeakMap();\n\n    /**\n     * Extracts private item storage associated\n     * with a provided registry instance.\n     *\n     * @param {Object} container\n     * @returns {Object}\n     */\n    function getItems(container) {\n        return privateData.get(container).items;\n    }\n\n    /**\n     * Extracts private requests array associated\n     * with a provided registry instance.\n     *\n     * @param {Object} container\n     * @returns {Array}\n     */\n    function getRequests(container) {\n        return privateData.get(container).requests;\n    }\n\n    /**\n     * Wrapper function used for convenient access to the elements.\n     * See 'async' method for examples of usage and comparison\n     * with a regular 'get' method.\n     *\n     * @param {(String|Object|Function)} name - Key of the requested element.\n     * @param {Registry} registry - Instance of a registry\n     *      where to search for the element.\n     * @param {(Function|String)} [method] - Optional callback function\n     *      or a name of the elements' method which\n     *      will be invoked when element is available in registry.\n     * @returns {*}\n     */\n    function async(name, registry, method) {\n        var args = _.toArray(arguments).slice(3);\n\n        if (_.isString(method)) {\n            registry.get(name, function (component) {\n                component[method].apply(component, args);\n            });\n        } else if (_.isFunction(method)) {\n            registry.get(name, method);\n        } else if (!args.length) {\n            return registry.get(name);\n        }\n    }\n\n    /**\n     * Checks that every property of the query object\n     * is present and equal to the corresponding\n     * property in target object.\n     * Note that non-strict comparison is used.\n     *\n     * @param {Object} query - Query object.\n     * @param {Object} target - Target object.\n     * @returns {Boolean}\n     */\n    function compare(query, target) {\n        var matches = true,\n            index,\n            keys,\n            key;\n\n        if (!_.isObject(query) || !_.isObject(target)) {\n            return false;\n        }\n\n        keys = Object.getOwnPropertyNames(query);\n        index = keys.length;\n\n        while (matches && index--) {\n            key = keys[index];\n\n            /* eslint-disable eqeqeq */\n            if (target[key] != query[key]) {\n                matches = false;\n            }\n\n            /* eslint-enable eqeqeq */\n        }\n\n        return matches;\n    }\n\n    /**\n     * Explodes incoming string into object if\n     * string is defined as a set of key = value pairs.\n     *\n     * @param {(String|*)} query - String to be processed.\n     * @returns {Object|*} Either created object or an unmodified incoming\n     *      value if conversion was not possible.\n     * @example Sample conversions.\n     *      'key = value, key2 = value2'\n     *      => {key: 'value', key2: 'value2'}\n     */\n    function explode(query) {\n        var result = {},\n            index,\n            data;\n\n        if (typeof query !== 'string' || !~query.indexOf('=')) {\n            return query;\n        }\n\n        query = query.split(',');\n        index = query.length;\n\n        while (index--) {\n            data = query[index].split('=');\n\n            result[data[0].trim()] = data[1].trim();\n        }\n\n        return result;\n    }\n\n    /**\n     * Extracts items from the provided data object\n     * which matches specified search criteria.\n     *\n     * @param {Object} data - Data object where to perform a lookup.\n     * @param {(String|Object|Function)} query - Search criteria.\n     * @param {Boolean} findAll - Flag that defines whether to\n     *      search for all applicable items or to stop on a first found entry.\n     * @returns {Array|Object|*}\n     */\n    function find(data, query, findAll) {\n        var iterator,\n            item;\n\n        query = explode(query);\n\n        if (typeof query === 'string') {\n            item = data[query];\n\n            if (findAll) {\n                return item ? [item] : [];\n            }\n\n            return item;\n        }\n\n        iterator = !_.isFunction(query) ?\n            compare.bind(null, query) :\n            query;\n\n        return findAll ?\n            _.filter(data, iterator) :\n            _.find(data, iterator);\n    }\n\n    /**\n     * @constructor\n     */\n    function Registry() {\n        var data = {\n            items: {},\n            requests: []\n        };\n\n        this._updateRequests = _.debounce(this._updateRequests.bind(this), 10);\n        privateData.set(this, data);\n    }\n\n    Registry.prototype = {\n        constructor: Registry,\n\n        /**\n         * Retrieves item from registry which matches specified search criteria.\n         *\n         * @param {(Object|String|Function|Array)} query - Search condition (see examples).\n         * @param {Function} [callback] - Callback that will be invoked when\n         *      all of the requested items are available.\n         * @returns {*}\n         *\n         * @example Requesting item by it's name.\n         *      var obj = {index: 'test', sample: true};\n         *\n         *      registry.set('first', obj);\n         *      registry.get('first') === obj;\n         *      => true\n         *\n         * @example Requesting item with a specific properties.\n         *      registry.get('sample = 1, index = test') === obj;\n         *      => true\n         *      registry.get('sample = 0, index = foo') === obj;\n         *      => false\n         *\n         * @example Declaring search criteria as an object.\n         *      registry.get({sample: true}) === obj;\n         *      => true;\n         *\n         * @example Providing custom search handler.\n         *      registry.get(function (item) { return item.sample === true; }) === obj;\n         *      => true\n         *\n         * @example Sample asynchronous request declaration.\n         *      registry.get('index = test', function (item) {});\n         *\n         * @example Requesting multiple elements.\n         *      registry.set('second', {index: 'test2'});\n         *      registry.get(['first', 'second'], function (first, second) {});\n         */\n        get: function (query, callback) {\n            if (typeof callback !== 'function') {\n                return find(getItems(this), query);\n            }\n\n            this._addRequest(query, callback);\n        },\n\n        /**\n         * Sets provided item to the registry.\n         *\n         * @param {String} id - Item's identifier.\n         * @param {*} item - Item's data.\n         * returns {Registry} Chainable.\n         */\n        set: function (id, item) {\n            getItems(this)[id] = item;\n\n            this._updateRequests();\n\n            return this;\n        },\n\n        /**\n         * Removes specified item from registry.\n         * Note that search query is not applicable.\n         *\n         * @param {String} id - Item's identifier.\n         * @returns {Registry} Chainable.\n         */\n        remove: function (id) {\n            delete getItems(this)[id];\n\n            return this;\n        },\n\n        /**\n         * Retrieves a collection of elements that match\n         * provided search criteria.\n         *\n         * @param {(Object|String|Function)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {Array} Found elements.\n         */\n        filter: function (query) {\n            return find(getItems(this), query, true);\n        },\n\n        /**\n         * Checks that at least one element in collection\n         * matches provided search criteria.\n         *\n         * @param {(Object|String|Function)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {Boolean}\n         */\n        has: function (query) {\n            return !!this.get(query);\n        },\n\n        /**\n         * Checks that registry contains a provided item.\n         *\n         * @param {*} item - Item to be checked.\n         * @returns {Boolean}\n         */\n        contains: function (item) {\n            return _.contains(getItems(this), item);\n        },\n\n        /**\n         * Extracts identifier of an item if it's present in registry.\n         *\n         * @param {*} item - Item whose identifier will be extracted.\n         * @returns {String|Undefined}\n         */\n        indexOf: function (item) {\n            return _.findKey(getItems(this), function (elem) {\n                return item === elem;\n            });\n        },\n\n        /**\n         * Same as a 'get' method except that it returns\n         * a promise object instead of invoking provided callback.\n         *\n         * @param {(String|Function|Object|Array)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {jQueryPromise}\n         */\n        promise: function (query) {\n            var defer    = $.Deferred(),\n                callback = defer.resolve.bind(defer);\n\n            this.get(query, callback);\n\n            return defer.promise();\n        },\n\n        /**\n         * Creates a wrapper function over the provided search query\n         * in order to provide somehow more convenient access to the\n         * registry's items.\n         *\n         * @param {(String|Object|Function)} query - Search criteria.\n         *      See 'get' method for the syntax examples.\n         * @returns {Function}\n         *\n         * @example Comparison with a 'get' method on retrieving items.\n         *      var module = registry.async('name');\n         *\n         *      module();\n         *      => registry.get('name');\n         *\n         * @example Asynchronous request.\n         *      module(function (component) {});\n         *      => registry.get('name', function (component) {});\n         *\n         * @example Requesting item and invoking it's method with specified parameters.\n         *      module('trigger', true);\n         *      => registry.get('name', function (component) {\n         *          component.trigger(true);\n         *      });\n         */\n        async: function (query) {\n            return async.bind(null, query, this);\n        },\n\n        /**\n         * Creates new instance of a Registry.\n         *\n         * @returns {Registry} New instance.\n         */\n        create: function () {\n            return new Registry;\n        },\n\n        /**\n         * Adds new request to the queue or resolves it immediately\n         * if all of the required items are available.\n         *\n         * @private\n         * @param {(Object|String|Function|Array)} queries - Search criteria.\n         *      See 'get' method for the syntax examples.\n         * @param {Function} callback - Callback that will be invoked when\n         *      all of the requested items are available.\n         * @returns {Registry}\n         */\n        _addRequest: function (queries, callback) {\n            var request;\n\n            if (!Array.isArray(queries)) {\n                queries = queries ? [queries] : [];\n            }\n\n            request = {\n                queries: queries.map(explode),\n                callback: callback\n            };\n\n            this._canResolve(request) ?\n                this._resolveRequest(request) :\n                getRequests(this).push(request);\n\n            return this;\n        },\n\n        /**\n         * Updates requests list resolving applicable items.\n         *\n         * @private\n         * @returns {Registry} Chainable.\n         */\n        _updateRequests: function () {\n            getRequests(this)\n                .filter(this._canResolve, this)\n                .forEach(this._resolveRequest, this);\n\n            return this;\n        },\n\n        /**\n         * Resolves provided request invoking it's callback\n         * with items specified in query parameters.\n         *\n         * @private\n         * @param {Object} request - Request object.\n         * @returns {Registry} Chainable.\n         */\n        _resolveRequest: function (request) {\n            var requests = getRequests(this),\n                items    = request.queries.map(this.get, this),\n                index    = requests.indexOf(request);\n\n            request.callback.apply(null, items);\n\n            if (~index) {\n                requests.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if provided request can be resolved.\n         *\n         * @private\n         * @param {Object} request - Request object.\n         * @returns {Boolean}\n         */\n        _canResolve: function (request) {\n            var queries = request.queries;\n\n            return queries.every(this.has, this);\n        }\n    };\n\n    return new Registry;\n});\n","Magento_Ui/js/lib/logger/levels-pool.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var LEVELS,\n        CODE_MAP;\n\n    LEVELS = {\n        NONE: 0,\n        ERROR: 1,\n        WARN: 2,\n        INFO: 3,\n        DEBUG: 4,\n        ALL: 5\n    };\n\n    CODE_MAP = _.invert(LEVELS);\n\n    return {\n        /**\n         * Returns the list of available log levels.\n         *\n         * @returns {Object}\n         */\n        getLevels: function () {\n            return LEVELS;\n        },\n\n        /**\n         * Returns name of the log level that matches to the provided code.\n         *\n         * @returns {String}\n         */\n        getNameByCode: function (code) {\n            return CODE_MAP[code];\n        }\n    };\n});\n","Magento_Ui/js/lib/logger/message-pool.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(function () {\n    'use strict';\n\n    var MESSAGES = {\n        templateStartLoading:\n            'The \"${ $.template }\" template requested by  the \"${$.component}\" component started loading.',\n        templateLoadedFromServer:\n            'The \"${ $.template }\" template requested by the \"${$.component}\" component  was loaded from server.\"',\n        templateLoadedFromCache:\n            'The \"${ $.template }\" template  requested by the \"${$.component}\" component was loaded from cache.\"',\n        templateLoadingFail: 'Failed to load the \"${ $.template }\" template requested by \"${$.component}\".',\n        componentStartInitialization:\n            'Component \"${$.component}\" start initialization with instance name \"${$.componentName}\".',\n        componentStartLoading: ' Started loading the \"${$.component}\" component.',\n        componentFinishLoading: 'The \"${$.component}\" component was loaded.',\n        componentLoadingFail: 'Failed to load the \"${$.component}\" component.',\n        depsLoadingFail: 'Could not get the declared \"${$.deps}\" dependency for the \"${$.component}\" instance.',\n        depsStartRequesting: 'Requesting the \"${$.deps}\" dependency for the \"${$.component}\" instance.',\n        depsFinishRequesting: 'The \"${$.deps}\" dependency for the \"${$.component}\" instance was received.',\n        requestingComponent: 'Requesting the \"${$.component}\" component.',\n        requestingComponentIsLoaded: 'The requested \"${$.component}\" component was received.',\n        requestingComponentIsFailed: 'Could not get the requested \"${$.component}\" component.'\n    };\n\n    return {\n        /**\n         * Returns message that matches the provided code.\n         *\n         * @param {String} code - Message's identifier\n         * @returns {String}\n         */\n        getMessage: function (code) {\n            return MESSAGES[code];\n        },\n\n        /**\n         * Adds a new message to the poll.\n         *\n         * @param {String} code - Message's identifier.\n         * @param {String} message - Text of the message\n         */\n        addMessage: function (code, message) {\n            MESSAGES[code] = message;\n        },\n\n        /**\n         * Tells whether message with provide code exists in the poll.\n         *\n         * @param {String} code - Message's identifier.\n         * @returns {Boolean}\n         */\n        hasMessage: function (code) {\n            return MESSAGES.hasOwnProperty(code);\n        }\n    };\n});\n","Magento_Ui/js/lib/logger/entry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    /**\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [data]\n     */\n    function LogEntry(message, level, data) {\n        /**\n         * @readonly\n         * @type {Number}\n         */\n        this.timestamp = Date.now();\n\n        /**\n         * @readonly\n         * @type {Number}\n         */\n        this.level = level;\n\n        /**\n         * @readonly\n         * @type {String}\n         */\n        this.levelName = logLevels.getNameByCode(level);\n\n        /**\n         * @readonly\n         * @type {Object}\n         */\n        this.data = data;\n\n        /**\n         * @readonly\n         * @type {String}\n         */\n        this.message = message;\n    }\n\n    return LogEntry;\n});\n","Magento_Ui/js/lib/logger/formatter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'moment',\n    'mage/utils/template'\n], function (moment, mageTemplate) {\n    'use strict';\n\n    /**\n     * @param {String} dateFormat\n     * @param {String} template\n     */\n    function LogFormatter(dateFormat, template) {\n        /**\n         * @protected\n         * @type {String}\n         */\n        this.dateFormat_ = 'YYYY-MM-DD hh:mm:ss';\n\n        /**\n         * @protected\n         * @type {String}\n         */\n        this.template_ = '[${ $.date }] [${ $.entry.levelName }] ${ $.message }';\n\n        if (dateFormat) {\n            this.dateFormat_ = dateFormat;\n        }\n\n        if (template) {\n            this.template_ = template;\n        }\n    }\n\n    /**\n     * @param {LogEntry} entry\n     * @returns {String}\n     */\n    LogFormatter.prototype.process = function (entry) {\n        var message = mageTemplate.template(entry.message, entry.data),\n            date = moment(entry.timestamp).format(this.dateFormat_);\n\n        return mageTemplate.template(this.template_, {\n            date: date,\n            entry: entry,\n            message: message\n        });\n    };\n\n    return LogFormatter;\n});\n","Magento_Ui/js/lib/logger/console-logger.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './logger',\n    './entry-factory',\n    './console-output-handler',\n    './formatter',\n    './message-pool',\n    './levels-pool',\n    'Magento_Ui/js/lib/core/storage/local',\n    'underscore',\n    './logger-utils'\n], function (Logger, entryFactory, ConsoleHandler, Formatter, messagePoll, levelsPoll, storage, _, LoggerUtils) {\n    'use strict';\n\n    var STORAGE_NAMESPACE = 'CONSOLE_LOGGER';\n\n    /**\n     * Singleton Logger's sub-class instance of which is configured to display its\n     * messages to the console. It also provides the support of predefined messages\n     * and persists its display level.\n     */\n    function ConsoleLogger() {\n        var formatter = new Formatter(),\n            consoleHandler = new ConsoleHandler(formatter),\n            savedLevel = storage.get(STORAGE_NAMESPACE),\n            utils = new LoggerUtils(this);\n\n        Logger.call(this, consoleHandler, entryFactory);\n\n        if (savedLevel) {\n            this.displayLevel_ = savedLevel;\n        }\n\n        this.utils = utils;\n        this.messages = messagePoll;\n        this.levels = levelsPoll.getLevels();\n    }\n\n    _.extend(ConsoleLogger, Logger);\n\n    ConsoleLogger.prototype = Object.create(Logger.prototype);\n    ConsoleLogger.prototype.constructor = ConsoleLogger;\n\n    /**\n     * Overrides parent method to save the provided display level.\n     *\n     * @override\n     */\n    ConsoleLogger.prototype.setDisplayLevel = function (level) {\n        Logger.prototype.setDisplayLevel.call(this, level);\n\n        storage.set(STORAGE_NAMESPACE, level);\n    };\n\n    /**\n     * Adds the support of predefined messages.\n     *\n     * @protected\n     * @override\n     */\n    ConsoleLogger.prototype.createEntry_ = function (message, level, data) {\n        var code;\n\n        if (messagePoll.hasMessage(message)) {\n            data = data || {};\n            code = message;\n            message = messagePoll.getMessage(code);\n\n            data.messageCode = code;\n        }\n\n        return Logger.prototype.createEntry_.call(this, message, level, data);\n    };\n\n    return new ConsoleLogger();\n});\n","Magento_Ui/js/lib/logger/logger.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    var levels = logLevels.getLevels();\n\n    /**\n     * @param {LogOutputHandler} outputHandler\n     * @param {LogEntryFactory} entryFactory\n     */\n    function Logger(outputHandler, entryFactory) {\n        /**\n         * An array of log entries.\n         *\n         * @protected\n         * @type {Array<LogEntry>}\n         */\n        this.entries_ = [];\n\n        /**\n         * Current display level.\n         *\n         * @protected\n         * @type {Number}\n         */\n        this.displayLevel_ = levels.ERROR;\n\n        /**\n         * An array of display criteria.\n         *\n         * @protected\n         * @type {Array<LogCriteria>}\n         */\n        this.displayCriteria_ = [];\n\n        /**\n         * @protected\n         * @type {LogEntryFactory}\n         */\n        this.entryFactory_ = entryFactory;\n\n        /**\n         * @protected\n         * @type {Array<LogOutputHandler>}\n         */\n        this.outputHandlers_ = [outputHandler];\n\n        this.addDisplayCriteria(this.matchesLevel_);\n    }\n\n    /**\n     * Swaps current display level with the provided one.\n     *\n     * @param {Number} level - Level's code.\n     */\n    Logger.prototype.setDisplayLevel = function (level) {\n        var levelName = logLevels.getNameByCode(level);\n\n        if (!levelName) {\n            throw new TypeError('The provided level is not defined in the levels list.');\n        }\n\n        this.displayLevel_ = level;\n    };\n\n    /**\n     * Sets up the criteria by which log entries will be filtered out from the output.\n     *\n     * @param {LogCriteria} criteria\n     */\n    Logger.prototype.addDisplayCriteria = function (criteria) {\n        this.displayCriteria_.push(criteria);\n    };\n\n    /**\n     * Removes previously defined criteria.\n     *\n     * @param {LogCriteria} criteria\n     */\n    Logger.prototype.removeDisplayCriteria = function (criteria) {\n        var index = this.displayCriteria_.indexOf(criteria);\n\n        if (~index) {\n            this.displayCriteria_.splice(index, 1);\n        }\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.error = function (message, messageData) {\n        return this.log_(message, levels.ERROR, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.warn = function (message, messageData) {\n        return this.log_(message, levels.WARN, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.info = function (message, messageData) {\n        return this.log_(message, levels.INFO, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.debug = function (message, messageData) {\n        return this.log_(message, levels.DEBUG, messageData);\n    };\n\n    /**\n     * @protected\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.log_ = function (message, level, messageData) {\n        var entry = this.createEntry_(message, level, messageData);\n\n        this.entries_.push(entry);\n\n        if (this.matchesCriteria_(entry)) {\n            this.processOutput_(entry);\n        }\n\n        return entry;\n    };\n\n    /**\n     * @protected\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.createEntry_ = function (message, level, messageData) {\n        return this.entryFactory_.createEntry(message, level, messageData);\n    };\n\n    /**\n     * Returns an array of log entries that have been added to the logger.\n     *\n     * @param {LogCriteria} [criteria] - Optional filter criteria.\n     * @returns {Array<LogEntry>}\n     */\n    Logger.prototype.getEntries = function (criteria) {\n        if (criteria) {\n            return this.entries_.filter(criteria);\n        }\n\n        return this.entries_;\n    };\n\n    /**\n     * @param {LogCriteria} [criteria]\n     */\n    Logger.prototype.dump = function (criteria) {\n        var entries;\n\n        if (!criteria) {\n            criteria = this.matchesCriteria_;\n        }\n\n        entries = this.entries_.filter(criteria, this);\n\n        this.outputHandlers_.forEach(function (handler) {\n            handler.dump(entries);\n        });\n    };\n\n    /**\n     * @protected\n     * @param {LogEntry} entry\n     */\n    Logger.prototype.processOutput_ = function (entry) {\n        this.outputHandlers_.forEach(function (handler) {\n            handler.show(entry);\n        });\n    };\n\n    /**\n     * @protected\n     * @param {LogEntry} entry\n     * @returns {Boolean}\n     */\n    Logger.prototype.matchesCriteria_ = function (entry) {\n        return this.displayCriteria_.every(function (criteria) {\n            return criteria.call(this, entry);\n        }, this);\n    };\n\n    /**\n     * Checks that the level of provided entry passes the \"displayLevel_\" threshold.\n     *\n     * @protected\n     * @param {LogEntry} entry - Entry to be checked.\n     * @returns {Boolean}\n     */\n    Logger.prototype.matchesLevel_ = function (entry) {\n        return entry.level <= this.displayLevel_;\n    };\n\n    return Logger;\n});\n","Magento_Ui/js/lib/logger/console-output-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    var levels = logLevels.getLevels();\n\n    /**\n     * @param {LogFormatter} formatter\n     */\n    function ConsoleOutputHandler(formatter) {\n        /**\n         * @protected\n         * @type {LogFormatter}\n         */\n        this.formatter_ = formatter;\n    }\n\n    /**\n     * Display data of the provided entry to the console.\n     *\n     * @param {LogEntry} entry - Entry to be displayed.\n     */\n    ConsoleOutputHandler.prototype.show = function (entry) {\n        var displayString = this.formatter_.process(entry);\n\n        switch (entry.level) {\n            case levels.ERROR:\n                console.error(displayString);\n                break;\n\n            case levels.WARN:\n                console.warn(displayString);\n                break;\n\n            case levels.INFO:\n                console.info(displayString);\n                break;\n\n            case levels.DEBUG:\n                console.log(displayString);\n                break;\n        }\n    };\n\n    /**\n     * Displays the array of entries.\n     *\n     * @param {Array<LogEntry>} entries\n     */\n    ConsoleOutputHandler.prototype.dump = function (entries) {\n        entries.forEach(this.show, this);\n    };\n\n    return ConsoleOutputHandler;\n});\n","Magento_Ui/js/lib/logger/logger-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Utils methods for logger\n     * @param {Logger} logger\n     */\n    function LogUtils(logger) {\n        this.logger = logger;\n\n    }\n\n    /**\n     * Method for logging asynchronous operations\n     * @param {Promise} promise\n     * @param {Object} config\n     */\n    LogUtils.prototype.asyncLog = function (promise, config) {\n        var levels,\n            messages,\n            wait;\n\n        config = config || {};\n        levels = config.levels || this.createLevels();\n        messages = config.messages || this.createMessages();\n        wait = config.wait || 5000;\n\n        this.logger[levels.requested](messages.requested, config.data);\n        setTimeout(function () {\n            promise.state() === 'pending' ?\n                this.logger[levels.failed](messages.failed, config.data) :\n                this.logger[levels.loaded](messages.loaded, config.data);\n        }.bind(this), wait);\n    };\n\n    /**\n     * Method that creates object of messages\n     * @param {String} requested - log message that showing that request for class is started\n     * @param {String} loaded - log message that show when requested class is loaded\n     * @param {String} failed - log message that show when requested class is failed\n     * @returns {Object}\n     */\n    LogUtils.prototype.createMessages = function (requested, loaded, failed) {\n        return {\n            requested: requested || '',\n            loaded: loaded || '',\n            failed: failed || ''\n        };\n    };\n\n    /**\n     * Method that creates object of log levels\n     * @param {String} requested - log message that showing that request for class is started\n     * @param {String} loaded - log message that show when requested class is loaded\n     * @param {String} failed - log message that show when requested class is failed\n     * @returns {Object}\n     */\n    LogUtils.prototype.createLevels = function (requested, loaded, failed) {\n        return {\n            requested: requested || 'info',\n            loaded: loaded || 'info',\n            failed: failed || 'warn'\n        };\n    };\n\n    return LogUtils;\n});\n","Magento_Ui/js/lib/logger/entry-factory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './entry'\n], function (LogEntry) {\n    'use strict';\n\n    return {\n        /**\n         * @param {String} message\n         * @param {Number} level\n         * @param {Object} [messageData]\n         * @returns {LogEntry}\n         */\n        createEntry: function (message, level, messageData) {\n            return new LogEntry(message, level, messageData);\n        }\n    };\n});\n","Magento_Ui/js/lib/core/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore'\n], function (ko, _) {\n    'use strict';\n\n    var eventsMap = new WeakMap();\n\n    /**\n     * Returns events map or a specific event\n     * data associated with a provided object.\n     *\n     * @param {Object} obj - Key in the events weakmap.\n     * @param {String} [name] - Name of the event.\n     * @returns {Map|Array|Boolean}\n     */\n    function getEvents(obj, name) {\n        var events = eventsMap.get(obj);\n\n        if (!events) {\n            return false;\n        }\n\n        return name ? events.get(name) : events;\n    }\n\n    /**\n     * Adds new event handler.\n     *\n     * @param {Object} obj - Key in the events weakmap.\n     * @param {String} ns - Callback namespace.\n     * @param {Function} callback - Event callback.\n     * @param {String} name - Name of the event.\n     */\n    function addHandler(obj, ns, callback, name) {\n        var events      = getEvents(obj),\n            observable,\n            data;\n\n        observable = !ko.isObservable(obj[name]) ?\n            ko.getObservable(obj, name) :\n            obj[name];\n\n        if (observable) {\n            observable.subscribe(callback);\n\n            return;\n        }\n\n        if (!events) {\n            events = new Map();\n\n            eventsMap.set(obj, events);\n        }\n\n        data = {\n            callback: callback,\n            ns: ns\n        };\n\n        events.has(name) ?\n            events.get(name).push(data) :\n            events.set(name, [data]);\n    }\n\n    /**\n     * Invokes provided callbacks with a specified arguments.\n     *\n     * @param {Array} handlers\n     * @param {Array} args\n     * @returns {Boolean}\n     */\n    function trigger(handlers, args) {\n        var bubble = true,\n            callback;\n\n        handlers.forEach(function (handler) {\n            callback = handler.callback;\n\n            if (callback.apply(null, args) === false) {\n                bubble = false;\n            }\n        });\n\n        return bubble;\n    }\n\n    return {\n\n        /**\n         * Calls callback when name event is triggered.\n         * @param  {String}   events\n         * @param  {Function} callback\n         * @param  {Function} ns\n         * @return {Object} reference to this\n         */\n        on: function (events, callback, ns) {\n            var iterator;\n\n            if (arguments.length < 2) {\n                ns = callback;\n            }\n\n            iterator = addHandler.bind(null, this, ns);\n\n            _.isObject(events) ?\n                _.each(events, iterator) :\n                iterator(callback, events);\n\n            return this;\n        },\n\n        /**\n         * Removed callback from listening to target event\n         * @param  {String} ns\n         * @return {Object} reference to this\n         */\n        off: function (ns) {\n            var storage = getEvents(this);\n\n            if (!storage) {\n                return this;\n            }\n\n            storage.forEach(function (handlers, name) {\n                handlers = handlers.filter(function (handler) {\n                    return !ns ? false : handler.ns !== ns;\n                });\n\n                handlers.length ?\n                    storage.set(name, handlers) :\n                    storage.delete(name);\n            });\n\n            return this;\n        },\n\n        /**\n         * Triggers event and executes all attached callbacks.\n         *\n         * @param {String} name - Name of the event to be triggered.\n         * @returns {Boolean}\n         */\n        trigger: function (name) {\n            var handlers,\n                args;\n\n            handlers = getEvents(this, name),\n            args = _.toArray(arguments).slice(1);\n\n            if (!handlers || !name) {\n                return true;\n            }\n\n            return trigger(handlers, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/core/class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/utils/wrapper'\n], function (_, utils, wrapper) {\n    'use strict';\n\n    var Class;\n\n    /**\n     * Returns property of an object if\n     * it's his own property.\n     *\n     * @param {Object} obj - Object whose property should be retrieved.\n     * @param {String} prop - Name of the property.\n     * @returns {*} Value of the property or false.\n     */\n    function getOwn(obj, prop) {\n        return _.isObject(obj) && obj.hasOwnProperty(prop) && obj[prop];\n    }\n\n    /**\n     * Creates constructor function which allows\n     * initialization without usage of a 'new' operator.\n     *\n     * @param {Object} protoProps - Prototypal properties of a new constructor.\n     * @param {Function} constructor\n     * @returns {Function} Created constructor.\n     */\n    function createConstructor(protoProps, constructor) {\n        var UiClass = constructor;\n\n        if (!UiClass) {\n\n            /**\n             * Default constructor function.\n             */\n            UiClass = function () {\n                var obj = this;\n\n                if (!_.isObject(obj) || Object.getPrototypeOf(obj) !== UiClass.prototype) {\n                    obj = Object.create(UiClass.prototype);\n                }\n\n                obj.initialize.apply(obj, arguments);\n\n                return obj;\n            };\n        }\n\n        UiClass.prototype = protoProps;\n        UiClass.prototype.constructor = UiClass;\n\n        return UiClass;\n    }\n\n    Class = createConstructor({\n\n        /**\n         * Entry point to the initialization of constructor's instance.\n         *\n         * @param {Object} [options={}]\n         * @returns {Class} Chainable.\n         */\n        initialize: function (options) {\n            this.initConfig(options);\n\n            return this;\n        },\n\n        /**\n         * Recursively extends data specified in constructors' 'defaults'\n         * property with provided options object. Evaluates resulting\n         * object using string templates (see: mage/utils/template.js).\n         *\n         * @param {Object} [options={}]\n         * @returns {Class} Chainable.\n         */\n        initConfig: function (options) {\n            var defaults    = this.constructor.defaults,\n                config      = utils.extend({}, defaults, options || {}),\n                ignored     = config.ignoreTmpls || {},\n                cached      = utils.omit(config, ignored);\n\n            config = utils.template(config, this, false, true);\n\n            _.each(cached, function (value, key) {\n                utils.nested(config, key, value);\n            });\n\n            return _.extend(this, config);\n        }\n    });\n\n    _.extend(Class, {\n        defaults: {\n            ignoreTmpls: {\n                templates: true\n            }\n        },\n\n        /**\n         * Creates new constructor based on a current prototype properties,\n         * extending them with properties specified in 'exender' object.\n         *\n         * @param {Object} [extender={}]\n         * @returns {Function} New constructor.\n         */\n        extend: function (extender) {\n            var parent      = this,\n                parentProto = parent.prototype,\n                childProto  = Object.create(parentProto),\n                child       = createConstructor(childProto, getOwn(extender, 'constructor')),\n                defaults;\n\n            extender = extender || {};\n            defaults = extender.defaults;\n\n            delete extender.defaults;\n\n            _.each(extender, function (method, name) {\n                childProto[name] = wrapper.wrapSuper(parentProto[name], method);\n            });\n\n            child.defaults = utils.extend({}, parent.defaults || {});\n\n            if (defaults) {\n                utils.extend(child.defaults, defaults);\n                extender.defaults = defaults;\n            }\n\n            return _.extend(child, {\n                __super__:  parentProto,\n                extend:     parent.extend\n            });\n        }\n    });\n\n    return Class;\n});\n","Magento_Ui/js/lib/core/collection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiElement'\n], function (_, utils, registry, Element) {\n    'use strict';\n\n    /**\n     * Removes non plain object items from the specified array.\n     *\n     * @param {Array} container - Array whose value should be filtered.\n     * @returns {Array}\n     */\n    function compact(container) {\n        return _.values(container).filter(utils.isObject);\n    }\n\n    /**\n     * Defines index of an item in a specified container.\n     *\n     * @param {*} item - Item whose index should be defined.\n     * @param {Array} container - Container upon which to perform search.\n     * @returns {Number}\n     */\n    function _findIndex(item, container) {\n        var index = _.findKey(container, function (value) {\n            return value === item;\n        });\n\n        if (typeof index === 'undefined') {\n            index = _.findKey(container, function (value) {\n                return value && value.name === item;\n            });\n        }\n\n        return typeof index === 'undefined' ? -1 : index;\n    }\n\n    /**\n     * Inserts specified item into container at a specified position.\n     *\n     * @param {*} item - Item to be inserted into container.\n     * @param {Array} container - Container of items.\n     * @param {*} [position=-1] - Position at which item should be inserted.\n     *      Position can represent:\n     *          - specific index in container\n     *          - item which might already be present in container\n     *          - structure with one of these properties: after, before\n     * @returns {Boolean|*}\n     *      - true if element has changed its' position\n     *      - false if nothing has changed\n     *      - inserted value if it wasn't present in container\n     */\n    function _insertAt(item, container, position) {\n        var currentIndex = _findIndex(item, container),\n            newIndex,\n            target;\n\n        if (typeof position === 'undefined') {\n            position = -1;\n        } else if (typeof position === 'string') {\n            position = isNaN(+position) ? position : +position;\n        }\n\n        newIndex = position;\n\n        if (~currentIndex) {\n            target = container.splice(currentIndex, 1)[0];\n\n            if (typeof item === 'string') {\n                item = target;\n            }\n        }\n\n        if (typeof position !== 'number') {\n            target = position.after || position.before || position;\n\n            newIndex = _findIndex(target, container);\n\n            if (~newIndex && (position.after || newIndex >= currentIndex)) {\n                newIndex++;\n            }\n        }\n\n        if (newIndex < 0) {\n            newIndex += container.length + 1;\n        }\n\n        container[newIndex] ?\n            container.splice(newIndex, 0, item) :\n            container[newIndex] = item;\n\n        return !~currentIndex ? item : currentIndex !== newIndex;\n    }\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/collection',\n            _elems: [],\n            ignoreTmpls: {\n                childDefaults: true\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Model} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    elems: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @param {Object} elem - Instance of an element that was added.\n         * @returns {Collection} Chainable.\n         */\n        initElement: function (elem) {\n            elem.initContainer(this);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a child found by provided index.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Object}\n         */\n        getChild: function (index) {\n            return _.findWhere(this.elems(), {\n                index: index\n            });\n        },\n\n        /**\n         * Requests specified components to insert\n         * them into 'elems' array starting from provided position.\n         *\n         * @param {(String|Array)} elems - Name of the component to insert.\n         * @param {Number} [position=-1] - Position at which to insert elements.\n         * @returns {Collection} Chainable.\n         */\n        insertChild: function (elems, position) {\n            var container   = this._elems,\n                insert      = this._insert.bind(this),\n                update;\n\n            if (!Array.isArray(elems)) {\n                elems = [elems];\n            }\n\n            elems.map(function (item) {\n                return item.elem ?\n                    _insertAt(item.elem, container, item.position) :\n                    _insertAt(item, container, position);\n            }).forEach(function (item) {\n                if (item === true) {\n                    update = true;\n                } else if (_.isString(item)) {\n                    registry.get(item, insert);\n                } else if (utils.isObject(item)) {\n                    insert(item);\n                }\n            });\n\n            if (update) {\n                this._updateCollection();\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes specified child from collection.\n         *\n         * @param {(Object|String)} elem - Child or index of a child to be removed.\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         *\n         * @returns {Collection} Chainable.\n         */\n        removeChild: function (elem, skipUpdate) {\n            if (_.isString(elem)) {\n                elem = this.getChild(elem);\n            }\n\n            if (elem) {\n                utils.remove(this._elems, elem);\n\n                if (!skipUpdate) {\n                    this._updateCollection();\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Destroys collection children with its' elements.\n         */\n        destroyChildren: function () {\n            this.elems.each(function (elem) {\n                elem.destroy(true);\n            });\n\n            this._updateCollection();\n        },\n\n        /**\n         * Clear data. Call method \"clear\"\n         * in child components\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            var elems = this.elems();\n\n            _.each(elems, function (elem) {\n                if (_.isFunction(elem.clear)) {\n                    elem.clear();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Checks if specified child exists in collection.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Boolean}\n         */\n        hasChild: function (index) {\n            return !!this.getChild(index);\n        },\n\n        /**\n         * Creates 'async' wrapper for the specified child\n         * using uiRegistry 'async' method and caches it\n         * in a '_requested' components  object.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Function} Async module wrapper.\n         */\n        requestChild: function (index) {\n            var name = this.formChildName(index);\n\n            return this.requestModule(name);\n        },\n\n        /**\n         * Creates complete child name based on a provided index.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {String}\n         */\n        formChildName: function (index) {\n            return this.name + '.' + index;\n        },\n\n        /**\n         * Retrieves requested region.\n         * Creates region if it was not created yet\n         *\n         * @returns {ObservableArray}\n         */\n        getRegion: function (name) {\n            var regions = this.regions = this.regions || {};\n\n            if (!regions[name]) {\n                regions[name] = [];\n\n                this.observe.call(regions, name);\n            }\n\n            return regions[name];\n        },\n\n        /**\n         * Checks if the specified region has any elements\n         * associated with it.\n         *\n         * @param {String} name\n         * @returns {Boolean}\n         */\n        regionHasElements: function (name) {\n            var region = this.getRegion(name);\n\n            return region().length > 0;\n        },\n\n        /**\n         * Replaces specified regions' data with a provided one.\n         * Creates region if it was not created yet.\n         *\n         * @param {Array} items - New regions' data.\n         * @param {String} name - Name of the region.\n         * @returns {Collection} Chainable.\n         */\n        updateRegion: function (items, name) {\n            this.getRegion(name)(items);\n\n            return this;\n        },\n\n        /**\n         * Destroys collection along with its' elements.\n         */\n        destroy: function () {\n            this._super();\n\n            this.elems.each('destroy');\n        },\n\n        /**\n         * Inserts provided component into 'elems' array at a specified position.\n         * @private\n         *\n         * @param {Object} elem - Element to insert.\n         */\n        _insert: function (elem) {\n            var index = _.findKey(this._elems, function (value) {\n                return value === elem.name;\n            });\n\n            if (typeof index !== 'undefined') {\n                this._elems[index] = elem;\n            }\n\n            this._updateCollection()\n                .initElement(elem);\n        },\n\n        /**\n         * Synchronizes multiple elements arrays with a core '_elems' container.\n         * Performs elemets grouping by theirs 'displayArea' property.\n         * @private\n         *\n         * @returns {Collection} Chainable.\n         */\n        _updateCollection: function () {\n            var _elems = compact(this._elems),\n                grouped;\n\n            grouped = _elems.filter(function (elem) {\n                return elem.displayArea && _.isString(elem.displayArea);\n            });\n            grouped = _.groupBy(grouped, 'displayArea');\n\n            _.each(grouped, this.updateRegion, this);\n\n            _.each(this.regions, function (items) {\n                var hasObsoleteComponents = items().length && !_.intersection(_elems, items()).length;\n\n                if (hasObsoleteComponents) {\n                    items.removeAll();\n                }\n            });\n\n            this.elems(_elems);\n\n            return this;\n        },\n\n        /**\n         * Tries to call specified method of a current component,\n         * otherwise delegates attempt to its' children.\n         *\n         * @param {String} target - Name of the method.\n         * @param {...*} parameters - Arguments that will be passed to method.\n         * @returns {*} Result of the method calls.\n         */\n        delegate: function (target) {\n            var args = _.toArray(arguments);\n\n            target = this[target];\n\n            if (_.isFunction(target)) {\n                return target.apply(this, args.slice(1));\n            }\n\n            return this._delegate(args);\n        },\n\n        /**\n         * Calls 'delegate' method of all of it's children components.\n         * @private\n         *\n         * @param {Array} args - An array of arguments to pass to the next delegation call.\n         * @returns {Array} An array of delegation results.\n         */\n        _delegate: function (args) {\n            var result;\n\n            result = this.elems.map(function (elem) {\n                var target;\n\n                if (!_.isFunction(elem.delegate)) {\n                    target = elem[args[0]];\n\n                    if (_.isFunction(target)) {\n                        return target.apply(elem, args.slice(1));\n                    }\n                } else {\n                    return elem.delegate.apply(elem, args);\n                }\n            });\n\n            return _.flatten(result);\n        }\n    });\n});\n","Magento_Ui/js/lib/core/storage/local.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiEvents'\n], function (_, registry, utils, EventsBus) {\n    'use strict';\n\n    var root = 'appData',\n        localStorage,\n        hasSupport,\n        storage;\n\n    /**\n     * Flag which indicates whether localStorage is supported.\n     */\n    hasSupport = (function () {\n        var key = '_storageSupported';\n\n        try {\n            localStorage = window.localStorage;\n            localStorage.setItem(key, 'true');\n\n            if (localStorage.getItem(key) === 'true') {\n                localStorage.removeItem(key);\n\n                return true;\n            }\n\n            return false;\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    if (!hasSupport) {\n        localStorage = {\n            _data: {},\n\n            /**\n             * Sets value of the specified item.\n             *\n             * @param {String} key - Key of the property.\n             * @param {*} value - Properties' value.\n             */\n            setItem: function (key, value) {\n                this._data[key] = value + '';\n            },\n\n            /**\n             * Retrieves specified item.\n             *\n             * @param {String} key - Key of the property to be retrieved.\n             */\n            getItem: function (key) {\n                return this._data[key];\n            },\n\n            /**\n             * Removes specified item.\n             *\n             * @param {String} key - Key of the property to be removed.\n             */\n            removeItem: function (key) {\n                delete this._data[key];\n            },\n\n            /**\n             * Removes all items.\n             */\n            clear: function () {\n                this._data = {};\n            }\n        };\n    }\n\n    /**\n     * Extracts and parses data stored in localStorage by the\n     * key specified in 'root' variable.\n     *\n     * @returns {Object}\n     */\n    function getRoot() {\n        var data = localStorage.getItem(root),\n            result = {};\n\n        if (!_.isNull(data) && typeof data != 'undefined') {\n            result = JSON.parse(data);\n        }\n\n        return result;\n    }\n\n    /**\n     * Writes provided data to the localStorage.\n     *\n     * @param {*} data - Data to be stored.\n     */\n    function setRoot(data) {\n        localStorage.setItem(root, JSON.stringify(data));\n    }\n\n    /**\n     * Provides methods to work with a localStorage\n     * as a single nested structure.\n     */\n    storage = _.extend({\n\n        /**\n         * Retrieves value of the specified property.\n         *\n         * @param {String} path - Path to the property.\n         *\n         * @example Retrieving data.\n         *      localStorage =>\n         *          'appData' => '\n         *              \"one\": {\"two\": \"three\"}\n         *          '\n         *      storage.get('one.two')\n         *      => \"three\"\n         *\n         *      storage.get('one')\n         *      => {\"two\": \"three\"}\n         */\n        get: function (path) {\n            var data = getRoot();\n\n            return utils.nested(data, path);\n        },\n\n        /**\n         * Sets specified data to the localStorage.\n         *\n         * @param {String} path - Path of the property.\n         * @param {*} value - Value of the property.\n         *\n         * @example Setting data.\n         *      storage.set('one.two', 'four');\n         *      => localStorage =>\n         *          'appData' => '\n         *              \"one\": {\"two\": \"four\"}\n         *          '\n         */\n        set: function (path, value) {\n            var data = getRoot();\n\n            utils.nested(data, path, value);\n\n            setRoot(data);\n        },\n\n        /**\n         * Removes specified data from the localStorage.\n         *\n         * @param {String} path - Path to the property that should be removed.\n         *\n         * @example Removing data.\n         *      storage.remove('one.two', 'four');\n         *      => localStorage =>\n         *          'appData' => '\n         *              \"one\": {}\n         *          '\n         */\n        remove: function (path) {\n            var data = getRoot();\n\n            utils.nestedRemove(data, path);\n\n            setRoot(data);\n        }\n    }, EventsBus);\n\n    registry.set('localStorage', storage);\n\n    return storage;\n});\n","Magento_Ui/js/lib/core/element/links.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry'\n], function (ko, _, utils, registry) {\n    'use strict';\n\n    /**\n     * Parse provided data.\n     *\n     * @param {String} placeholder\n     * @param {String} data\n     * @param {String} direction\n     * @returns {Boolean|Object}\n     */\n    function parseData(placeholder, data, direction) {\n        if (typeof data !== 'string') {\n            return false;\n        }\n\n        data = data.split(':');\n\n        if (!data[0]) {\n            return false;\n        }\n\n        if (!data[1]) {\n            data[1] = data[0];\n            data[0] = placeholder;\n        }\n\n        return {\n            target: data[0],\n            property: data[1],\n            direction: direction\n        };\n    }\n\n    /**\n     * Check if value not empty.\n     *\n     * @param {*} value\n     * @returns {Boolean}\n     */\n    function notEmpty(value) {\n        return typeof value !== 'undefined' && value != null;\n    }\n\n    /**\n     * Update value for linked component.\n     *\n     * @param {Object} data\n     * @param {Object} owner\n     * @param {Object} target\n     * @param {*} value\n     */\n    function updateValue(data, owner, target, value) {\n        var component = target.component,\n            property = target.property,\n            linked = data.linked;\n\n        if (data.mute) {\n            return;\n        }\n\n        if (linked) {\n            linked.mute = true;\n        }\n\n        if (owner.component !== target.component) {\n            value = data.inversionValue ? !utils.copy(value) : utils.copy(value);\n        }\n\n        component.set(property, value, owner);\n\n        if (property === 'disabled' && value) {\n            component.set('validate', value, owner);\n        }\n\n        if (linked) {\n            linked.mute = false;\n        }\n    }\n\n    /**\n     * Get value form owner component property.\n     *\n     * @param {Object} owner\n     * @returns {*}\n     */\n    function getValue(owner) {\n        var component = owner.component,\n            property = owner.property;\n\n        return component.get(property);\n    }\n\n    /**\n     * Format provided params to object.\n     *\n     * @param {String} ownerComponent\n     * @param {String} targetComponent\n     * @param {String} ownerProp\n     * @param {String} targetProp\n     * @param {String} direction\n     * @returns {Object}\n     */\n    function form(ownerComponent, targetComponent, ownerProp, targetProp, direction) {\n        var result,\n            tmp;\n\n        result = {\n            owner: {\n                component: ownerComponent,\n                property: ownerProp\n            },\n            target: {\n                component: targetComponent,\n                property: targetProp\n            }\n        };\n\n        if (direction === 'exports') {\n            tmp = result.owner;\n            result.owner = result.target;\n            result.target = tmp;\n        }\n\n        return result;\n    }\n\n    /**\n     * Set data to linked property.\n     *\n     * @param {Object} map\n     * @param {Object} data\n     */\n    function setLinked(map, data) {\n        var match;\n\n        if (!map) {\n            return;\n        }\n\n        match = _.findWhere(map, {\n            linked: false,\n            target: data.target,\n            property: data.property\n        });\n\n        if (match) {\n            match.linked = data;\n            data.linked = match;\n        }\n    }\n\n    /**\n     * Set data by direction.\n     *\n     * @param {Object} maps\n     * @param {String} property\n     * @param {Object} data\n     */\n    function setData(maps, property, data) {\n        var direction   = data.direction,\n            map         = maps[direction];\n\n        data.linked = false;\n\n        (map[property] = map[property] || []).push(data);\n\n        direction = direction === 'imports' ? 'exports' : 'imports';\n\n        setLinked(maps[direction][property], data);\n    }\n\n    /**\n     * Set links for components.\n     *\n     * @param {String} target\n     * @param {String} owner\n     * @param {Object} data\n     * @param {String} property\n     * @param {Boolean} immediate\n     */\n    function setLink(target, owner, data, property, immediate) {\n        var direction = data.direction,\n            formated = form(target, owner, data.property, property, direction),\n            callback,\n            value;\n\n        owner = formated.owner;\n        target = formated.target;\n\n        callback = updateValue.bind(null, data, owner, target);\n\n        owner.component.on(owner.property, callback, target.component.name);\n\n        if (immediate) {\n            value = getValue(owner);\n\n            if (notEmpty(value)) {\n                updateValue(data, owner, target, value);\n            }\n        }\n    }\n\n    /**\n     * Transfer data between components.\n     *\n     * @param {Object} owner\n     * @param {Object} data\n     */\n    function transfer(owner, data) {\n        var args = _.toArray(arguments);\n\n        if (data.target.substr(0, 1) === '!') {\n            data.target = data.target.substr(1);\n            data.inversionValue = true;\n        }\n\n        if (owner.name === data.target) {\n            args.unshift(owner);\n\n            setLink.apply(null, args);\n        } else {\n            registry.get(data.target, function (target) {\n                args.unshift(target);\n\n                setLink.apply(null, args);\n            });\n        }\n    }\n\n    return {\n        /**\n         * Assign listeners.\n         *\n         * @param {Object} listeners\n         * @returns {Object} Chainable\n         */\n        setListeners: function (listeners) {\n            var owner = this,\n                data;\n\n            _.each(listeners, function (callbacks, sources) {\n                sources = sources.split(' ');\n                callbacks = callbacks.split(' ');\n\n                sources.forEach(function (target) {\n                    callbacks.forEach(function (callback) {//eslint-disable-line max-nested-callbacks\n                        data = parseData(owner.name, target, 'imports');\n\n                        if (data) {\n                            setData(owner.maps, callback, data);\n                            transfer(owner, data, callback);\n                        }\n                    });\n                });\n            });\n\n            return this;\n        },\n\n        /**\n         * Set links in provided direction.\n         *\n         * @param {Object} links\n         * @param {String} direction\n         * @returns {Object} Chainable\n         */\n        setLinks: function (links, direction) {\n            var owner = this,\n                property,\n                data;\n\n            for (property in links) {\n                if (links.hasOwnProperty(property)) {\n                    data = parseData(owner.name, links[property], direction);\n\n                    if (data) {//eslint-disable-line max-depth\n                        setData(owner.maps, property, data);\n                        transfer(owner, data, property, true);\n                    }\n                }\n            }\n\n            return this;\n        }\n    };\n});\n","Magento_Ui/js/lib/core/element/element.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiEvents',\n    'uiClass',\n    './links',\n    '../storage/local'\n], function (ko, _, utils, registry, Events, Class, links) {\n    'use strict';\n\n    var Element;\n\n    /**\n     * Creates observable property using knockouts'\n     * 'observableArray' or 'observable' methods,\n     * depending on a type of 'value' parameter.\n     *\n     * @param {Object} obj - Object to whom property belongs.\n     * @param {String} key - Key of the property.\n     * @param {*} value - Initial value.\n     */\n    function observable(obj, key, value) {\n        var method = Array.isArray(value) ? 'observableArray' : 'observable';\n\n        if (_.isFunction(obj[key]) && !ko.isObservable(obj[key])) {\n            return;\n        }\n\n        if (ko.isObservable(value)) {\n            value = value();\n        }\n\n        ko.isObservable(obj[key]) ?\n            obj[key](value) :\n            obj[key] = ko[method](value);\n    }\n\n    /**\n     * Creates observable property using 'track' method.\n     *\n     * @param {Object} obj - Object to whom property belongs.\n     * @param {String} key - Key of the property.\n     * @param {*} value - Initial value.\n     */\n    function accessor(obj, key, value) {\n        if (_.isFunction(obj[key]) || ko.isObservable(obj[key])) {\n            return;\n        }\n\n        obj[key] = value;\n\n        if (!ko.es5.isTracked(obj, key)) {\n            ko.track(obj, [key]);\n        }\n    }\n\n    Element = _.extend({\n        defaults: {\n            _requested: {},\n            containers: [],\n            exports: {},\n            imports: {},\n            links: {},\n            listens: {},\n            name: '',\n            ns: '${ $.name.split(\".\")[0] }',\n            provider: '',\n            registerNodes: true,\n            source: null,\n            statefull: {},\n            template: '',\n            tracks: {},\n            storageConfig: {\n                provider: 'localStorage',\n                namespace: '${ $.name }',\n                path: '${ $.storageConfig.provider }:${ $.storageConfig.namespace }'\n            },\n            maps: {\n                imports: {},\n                exports: {}\n            },\n            modules: {\n                storage: '${ $.storageConfig.provider }'\n            }\n        },\n\n        /**\n         * Initializes model instance.\n         *\n         * @returns {Element} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initObservable()\n                .initModules()\n                .initStatefull()\n                .initLinks()\n                .initUnique();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Element} Chainable.\n         */\n        initObservable: function () {\n            _.each(this.tracks, function (enabled, key) {\n                if (enabled) {\n                    this.track(key);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Parses 'modules' object and creates\n         * async wrappers for specified components.\n         *\n         * @returns {Element} Chainable.\n         */\n        initModules: function () {\n            _.each(this.modules, function (name, property) {\n                if (name) {\n                    this[property] = this.requestModule(name);\n                }\n            }, this);\n\n            if (!_.isFunction(this.source)) {\n                this.source = registry.get(this.provider);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when current element was injected to another component.\n         *\n         * @param {Object} parent - Instance of a 'parent' component.\n         * @returns {Collection} Chainable.\n         */\n        initContainer: function (parent) {\n            this.containers.push(parent);\n\n            return this;\n        },\n\n        /**\n         * Initializes statefull properties\n         * based on the keys of 'statefull' object.\n         *\n         * @returns {Element} Chainable.\n         */\n        initStatefull: function () {\n            _.each(this.statefull, function (path, key) {\n                if (path) {\n                    this.setStatefull(key, path);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Initializes links between properties.\n         *\n         * @returns {Element} Chainbale.\n         */\n        initLinks: function () {\n            return this.setListeners(this.listens)\n                       .setLinks(this.links, 'imports')\n                       .setLinks(this.links, 'exports')\n                       .setLinks(this.exports, 'exports')\n                       .setLinks(this.imports, 'imports');\n        },\n\n        /**\n         * Initializes listeners of the unique property.\n         *\n         * @returns {Element} Chainable.\n         */\n        initUnique: function () {\n            var update = this.onUniqueUpdate.bind(this),\n                uniqueNs = this.uniqueNs;\n\n            this.hasUnique = this.uniqueProp && uniqueNs;\n\n            if (this.hasUnique) {\n                this.source.on(uniqueNs, update, this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Makes specified property to be stored automatically.\n         *\n         * @param {String} key - Name of the property\n         *      that will be stored.\n         * @param {String} [path=key] - Path to the property in storage.\n         * @returns {Element} Chainable.\n         */\n        setStatefull: function (key, path) {\n            var link = {};\n\n            path        = !_.isString(path) || !path ? key : path;\n            link[key]   = this.storageConfig.path + '.' + path;\n\n            this.setLinks(link, 'imports')\n                .setLinks(link, 'exports');\n\n            return this;\n        },\n\n        /**\n         * Updates property specified in uniqueNs\n         * if elements' unique property is set to 'true'.\n         *\n         * @returns {Element} Chainable.\n         */\n        setUnique: function () {\n            var property = this.uniqueProp;\n\n            if (this[property]()) {\n                this.source.set(this.uniqueNs, this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates 'async' wrapper for the specified component\n         * using uiRegistry 'async' method and caches it\n         * in a '_requested' components  object.\n         *\n         * @param {String} name - Name of requested component.\n         * @returns {Function} Async module wrapper.\n         */\n        requestModule: function (name) {\n            var requested = this._requested;\n\n            if (!requested[name]) {\n                requested[name] = registry.async(name);\n            }\n\n            return requested[name];\n        },\n\n        /**\n         * Returns path to elements' template.\n         *\n         * @returns {String}\n         */\n        getTemplate: function () {\n            return this.template;\n        },\n\n        /**\n         * Checks if template was specified for an element.\n         *\n         * @returns {Boolean}\n         */\n        hasTemplate: function () {\n            return !!this.template;\n        },\n\n        /**\n         * Returns value of the nested property.\n         *\n         * @param {String} path - Path to the property.\n         * @returns {*} Value of the property.\n         */\n        get: function (path) {\n            return utils.nested(this, path);\n        },\n\n        /**\n         * Sets provided value as a value of the specified nested property.\n         * Triggers changes notifications, if value has mutated.\n         *\n         * @param {String} path - Path to property.\n         * @param {*} value - New value of the property.\n         * @returns {Element} Chainable.\n         */\n        set: function (path, value) {\n            var data = this.get(path),\n                diffs;\n\n            diffs = !_.isFunction(data) && !this.isTracked(path) ?\n                utils.compare(data, value, path) :\n                false;\n\n            utils.nested(this, path, value);\n\n            if (diffs) {\n                this._notifyChanges(diffs);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes nested property from the object.\n         *\n         * @param {String} path - Path to the property.\n         * @returns {Element} Chainable.\n         */\n        remove: function (path) {\n            var data = utils.nested(this, path),\n                diffs;\n\n            if (_.isUndefined(data) || _.isFunction(data)) {\n                return this;\n            }\n\n            diffs = utils.compare(data, undefined, path);\n\n            utils.nestedRemove(this, path);\n\n            this._notifyChanges(diffs);\n\n            return this;\n        },\n\n        /**\n         * Creates observable properties for the current object.\n         *\n         * If 'useTrack' flag is set to 'true' then each property will be\n         * created with a ES5 get/set accessor descriptors, instead of\n         * making them an observable functions.\n         * See 'knockout-es5' library for more information.\n         *\n         * @param {Boolean} [useAccessors=false] - Whether to create an\n         *      observable function or to use property accesessors.\n         * @param {(Object|String|Array)} properties - List of observable properties.\n         * @returns {Element} Chainable.\n         *\n         * @example Sample declaration and equivalent knockout methods.\n         *      this.key = 'value';\n         *      this.array = ['value'];\n         *\n         *      this.observe(['key', 'array']);\n         *      =>\n         *          this.key = ko.observable('value');\n         *          this.array = ko.observableArray(['value']);\n         *\n         * @example Another syntaxes of the previous example.\n         *      this.observe({\n         *          key: 'value',\n         *          array: ['value']\n         *      });\n         */\n        observe: function (useAccessors, properties) {\n            var model = this,\n                trackMethod;\n\n            if (typeof useAccessors !== 'boolean') {\n                properties   = useAccessors;\n                useAccessors = false;\n            }\n\n            trackMethod = useAccessors ? accessor : observable;\n\n            if (_.isString(properties)) {\n                properties = properties.split(' ');\n            }\n\n            if (Array.isArray(properties)) {\n                properties.forEach(function (key) {\n                    trackMethod(model, key, model[key]);\n                });\n            } else if (typeof properties === 'object') {\n                _.each(properties, function (value, key) {\n                    trackMethod(model, key, value);\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Delegates call to 'observe' method but\n         * with a predefined 'useAccessors' flag.\n         *\n         * @param {(String|Array|Object)} properties - List of observable properties.\n         * @returns {Element} Chainable.\n         */\n        track: function (properties) {\n            this.observe(true, properties);\n\n            return this;\n        },\n\n        /**\n         * Checks if specified property is tracked.\n         *\n         * @param {String} property - Property to be checked.\n         * @returns {Boolean}\n         */\n        isTracked: function (property) {\n            return ko.es5.isTracked(this, property);\n        },\n\n        /**\n         * Invokes subscribers for the provided changes.\n         *\n         * @param {Object} diffs - Object with changes descriptions.\n         * @returns {Element} Chainable.\n         */\n        _notifyChanges: function (diffs) {\n            diffs.changes.forEach(function (change) {\n                this.trigger(change.path, change.value, change);\n            }, this);\n\n            _.each(diffs.containers, function (changes, name) {\n                var value = utils.nested(this, name);\n\n                this.trigger(name, value, changes);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Extracts all stored data and sets it to element.\n         *\n         * @returns {Element} Chainable.\n         */\n        restore: function () {\n            var ns = this.storageConfig.namespace,\n                storage = this.storage();\n\n            if (storage) {\n                utils.extend(this, storage.get(ns));\n            }\n\n            return this;\n        },\n\n        /**\n         * Stores value of the specified property in components' storage module.\n         *\n         * @param {String} property\n         * @param {*} [data=this[property]]\n         * @returns {Element} Chainable.\n         */\n        store: function (property, data) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property);\n\n            if (arguments.length < 2) {\n                data = this.get(property);\n            }\n\n            this.storage('set', path, data);\n\n            return this;\n        },\n\n        /**\n         * Extracts specified property from storage.\n         *\n         * @param {String} [property] - Name of the property\n         *      to be extracted. If not specified then all of the\n         *      stored will be returned.\n         * @returns {*}\n         */\n        getStored: function (property) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property),\n                storage = this.storage(),\n                data;\n\n            if (storage) {\n                data = storage.get(path);\n            }\n\n            return data;\n        },\n\n        /**\n         * Removes stored property.\n         *\n         * @param {String} property - Property to be removed from storage.\n         * @returns {Element} Chainable.\n         */\n        removeStored: function (property) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property);\n\n            this.storage('remove', path);\n\n            return this;\n        },\n\n        /**\n         * Destroys current instance along with all of its' children.\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         */\n        destroy: function (skipUpdate) {\n            this._dropHandlers()\n                ._clearRefs(skipUpdate);\n        },\n\n        /**\n         * Removes events listeners.\n         * @private\n         *\n         * @returns {Element} Chainable.\n         */\n        _dropHandlers: function () {\n            this.off();\n\n            if (_.isFunction(this.source)) {\n                this.source().off(this.name);\n            } else if (this.source) {\n                this.source.off(this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes all references to current instance and\n         * calls 'destroy' method on all of its' children.\n         * @private\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         *\n         * @returns {Element} Chainable.\n         */\n        _clearRefs: function (skipUpdate) {\n            registry.remove(this.name);\n\n            this.containers.forEach(function (parent) {\n                parent.removeChild(this, skipUpdate);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Overrides 'EventsBus.trigger' method to implement events bubbling.\n         *\n         * @param {...*} arguments - Any number of arguments that should be passed to the events' handler.\n         * @returns {Boolean} False if event bubbling was canceled.\n         */\n        bubble: function () {\n            var args = _.toArray(arguments),\n                bubble = this.trigger.apply(this, args),\n                result;\n\n            if (!bubble) {\n                return false;\n            }\n\n            this.containers.forEach(function (parent) {\n                result = parent.bubble.apply(parent, args);\n\n                if (result === false) {\n                    bubble = false;\n                }\n            });\n\n            return !!bubble;\n        },\n\n        /**\n         * Callback which fires when property under uniqueNs has changed.\n         */\n        onUniqueUpdate: function (name) {\n            var active = name === this.name,\n                property = this.uniqueProp;\n\n            this[property](active);\n        },\n\n        /**\n         * Clean data form data source.\n         *\n         * @returns {Element}\n         */\n        cleanData: function () {\n            if (this.source && this.source.componentType === 'dataSource') {\n                if (this.elems) {\n                    _.each(this.elems(), function (val) {\n                        val.cleanData();\n                    });\n                } else {\n                    this.source.remove(this.dataScope);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Fallback data.\n         */\n        cacheData: function () {\n            this.cachedComponent = utils.copy(this);\n        },\n\n        /**\n         * Update configuration in component.\n         *\n         * @param {*} oldValue\n         * @param {*} newValue\n         * @param {String} path - path to value.\n         * @returns {Element}\n         */\n        updateConfig: function (oldValue, newValue, path) {\n            var names = path.split('.'),\n                index = _.lastIndexOf(names, 'config') + 1;\n\n            names = names.splice(index, names.length - index).join('.');\n            this.set(names, newValue);\n\n            return this;\n        }\n    }, Events, links);\n\n    return Class.extend(Element);\n});\n","Magento_Ui/js/lib/knockout/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Loads all available knockout bindings, sets custom template engine, initializes knockout on page */\n\ndefine([\n    'ko',\n    './template/engine',\n    'knockoutjs/knockout-es5',\n    './bindings/bootstrap',\n    './extender/observable_array',\n    './extender/bound-nodes',\n    'domReady!'\n], function (ko, templateEngine) {\n    'use strict';\n\n    ko.uid = 0;\n\n    ko.setTemplateEngine(templateEngine);\n    ko.applyBindings();\n});\n","Magento_Ui/js/lib/knockout/template/observable_source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * Is being used by knockout template engine to store template to.\n */\ndefine([\n    'ko',\n    'uiClass'\n], function (ko, Class) {\n    'use strict';\n\n    return Class.extend({\n\n        /**\n         * Initializes templateName, _data, nodes properties.\n         *\n         * @param  {template} template - identifier of template\n         */\n        initialize: function (template) {\n            this.templateName = template;\n            this._data = {};\n            this.nodes = ko.observable([]);\n        },\n\n        /**\n         * Data setter. If only one arguments passed, returns corresponding value.\n         * Else, writes into it.\n         * @param  {String} key - key to write to or to read from\n         * @param  {*} value\n         * @return {*} - if 1 arg provided, Returns _data[key] property\n         */\n        data: function (key, value) {\n            if (arguments.length === 1) {\n                return this._data[key];\n            }\n\n            this._data[key] = value;\n        }\n    });\n});\n","Magento_Ui/js/lib/knockout/template/engine.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    './observable_source',\n    './renderer',\n    '../../logger/console-logger'\n], function ($, ko, _, Source, renderer, consoleLogger) {\n    'use strict';\n\n    var RemoteTemplateEngine,\n        NativeTemplateEngine = ko.nativeTemplateEngine,\n        sources = {};\n\n    /**\n     * Remote template engine class. Is used to be able to load remote templates via knockout template binding.\n     */\n    RemoteTemplateEngine = function () {\n        // Instance reference for closure.\n        var engine = this,\n        // Decorate the builtin Knockout \"template\" binding to track synchronous template renders.\n        origUpdate = ko.bindingHandlers.template.update;\n\n        /**\n         * Counter to track the number of currently running render tasks (both synchronous and asynchronous).\n         * @type {Number}\n         * @private\n         */\n        this._rendersOutstanding = 0;\n\n        /**\n         * Use a jQuery object as an event bus (but any event emitter with on/off/emit methods could work)\n         * @type {jQuery}\n         * @private\n         */\n        this._events = $(this);\n\n        /**\n         * Rendered templates\n         * @type {Object}\n         * @private\n         */\n        this._templatesRendered = {};\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Decorate update method\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         * @param {Object} allBindings\n         * @param {Object} viewModel\n         * @param {ko.bindingContext} bindingContext\n         * @returns {*}\n         */\n        ko.bindingHandlers.template.update = function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n            /*eslint-enable no-unused-vars*/\n            var options = ko.utils.peekObservable(valueAccessor()),\n                templateName,\n                isSync,\n                updated;\n\n            if (typeof options === 'object') {\n                if (options.templateEngine && options.templateEngine !== engine) {\n                    return origUpdate.apply(this, arguments);\n                }\n\n                if (!options.name) {\n                    consoleLogger.error('Could not find template name', options);\n                }\n                templateName = options.name;\n            } else if (typeof options === 'string') {\n                templateName = options;\n            } else {\n                consoleLogger.error('Could not build a template binding', options);\n            }\n            engine._trackRender(templateName);\n            isSync = engine._hasTemplateLoaded(templateName);\n            updated = origUpdate.apply(this, arguments);\n\n            if (isSync) {\n                engine._releaseRender(templateName, 'sync');\n            }\n\n            return updated;\n        };\n    };\n\n    /**\n     * Creates unique template identifier based on template name and it's extenders (optional)\n     * @param  {String} templateName\n     * @return {String} - unique template identifier\n     */\n    function createTemplateIdentifier(templateName) {\n        return templateName;\n    }\n\n    RemoteTemplateEngine.prototype = new NativeTemplateEngine;\n    RemoteTemplateEngine.prototype.constructor = RemoteTemplateEngine;\n\n    /**\n     * When an asynchronous render task begins, increment the internal counter for tracking when renders are complete.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._trackRender = function (templateName) {\n        var rendersForTemplate = this._templatesRendered[templateName] !== undefined ?\n            this._templatesRendered[templateName] : 0;\n\n        this._rendersOutstanding++;\n        this._templatesRendered[templateName] = rendersForTemplate + 1;\n        this._resolveRenderWaits();\n    };\n\n    /**\n     * When an asynchronous render task ends, decrement the internal counter for tracking when renders are complete.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._releaseRender = function (templateName) {\n        var rendersForTemplate = this._templatesRendered[templateName];\n\n        this._rendersOutstanding--;\n        this._templatesRendered[templateName] = rendersForTemplate - 1;\n        this._resolveRenderWaits();\n    };\n\n    /**\n     * Check to see if renders are complete and trigger events for listeners.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._resolveRenderWaits = function () {\n        if (this._rendersOutstanding === 0) {\n            this._events.triggerHandler('finishrender');\n        }\n    };\n\n    /**\n     * Get a promise for the end of the current run of renders, both sync and async.\n     * @return {jQueryPromise} - promise that resolves when render completes\n     */\n    RemoteTemplateEngine.prototype.waitForFinishRender = function () {\n        var defer = $.Deferred();\n\n        this._events.one('finishrender', defer.resolve);\n\n        return defer.promise();\n    };\n\n    /**\n     * Returns true if this template has already been asynchronously loaded and will be synchronously rendered.\n     * @param {String} templateName\n     * @returns {Boolean}\n     * @private\n     */\n    RemoteTemplateEngine.prototype._hasTemplateLoaded = function (templateName) {\n        // Sources object will have cached template once makeTemplateSource has run\n        return sources.hasOwnProperty(templateName);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Caches template after it's unique name and renders in once.\n     * If template name is not typeof string, delegates work to knockout.templateSources.anonymousTemplate.\n     * @param  {*} template\n     * @param  {HTMLElement} templateDocument - document\n     * @param  {Object} options - options, passed to template binding\n     * @param  {ko.bindingContext} bindingContext\n     * @returns {TemplateSource} Object with methods 'nodes' and 'data'.\n     */\n    RemoteTemplateEngine.prototype.makeTemplateSource = function (template, templateDocument, options, bindingContext) {\n        var engine = this,\n            source,\n            templateId;\n\n        if (typeof template === 'string') {\n            templateId = createTemplateIdentifier(template);\n            source = sources[templateId];\n\n            if (!source) {\n                source = new Source(template);\n                source.requestedBy = bindingContext.$data.name;\n                sources[templateId] = source;\n\n                consoleLogger.info('templateStartLoading', {\n                    template: templateId,\n                    component: bindingContext.$data.name\n                });\n\n                renderer.render(template).then(function (rendered) {\n                    consoleLogger.info('templateLoadedFromServer', {\n                        template: templateId,\n                        component: bindingContext.$data.name\n                    });\n                    source.nodes(rendered);\n                    engine._releaseRender(templateId, 'async');\n                }).fail(function () {\n                    consoleLogger.error('templateLoadingFail', {\n                        template: templateId,\n                        component: bindingContext.$data.name\n                    });\n                });\n            }\n\n            if (source.requestedBy !== bindingContext.$data.name) {\n                consoleLogger.info('templateLoadedFromCache', {\n                    template: templateId,\n                    component: bindingContext.$data.name\n                });\n            }\n\n            return source;\n        } else if (template.nodeType === 1 || template.nodeType === 8) {\n            source = new ko.templateSources.anonymousTemplate(template);\n\n            return source;\n        }\n\n        throw new Error('Unknown template type: ' + template);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Should return array of html elements.\n     * @param  {TemplateSource} templateSource - object with methods 'nodes' and 'data'.\n     * @return {Array} - array of html elements\n     */\n    RemoteTemplateEngine.prototype.renderTemplateSource = function (templateSource) {\n        var nodes = templateSource.nodes();\n\n        return ko.utils.cloneNodes(nodes);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Created in order to invoke makeTemplateSource method with custom set of params.\n     * @param  {*} template - template identifier\n     * @param  {ko.bindingContext} bindingContext\n     * @param  {Object} options - options, passed to template binding\n     * @param  {HTMLElement} templateDocument - document\n     * @return {Array} - array of html elements\n     */\n    RemoteTemplateEngine.prototype.renderTemplate = function (template, bindingContext, options, templateDocument) {\n        var templateSource = this.makeTemplateSource(template, templateDocument, options, bindingContext);\n\n        return this.renderTemplateSource(templateSource);\n    };\n\n    return new RemoteTemplateEngine;\n});\n","Magento_Ui/js/lib/knockout/template/renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    './loader'\n], function ($, _, loader) {\n    'use strict';\n\n    var colonReg       = /\\\\:/g,\n        renderedTemplatePromises = {},\n        attributes     = {},\n        elements       = {},\n        globals        = [],\n        renderer,\n        preset;\n\n    renderer = {\n\n        /**\n         * Loads template by provided path and\n         * than converts it's content to html.\n         *\n         * @param {String} tmplPath - Path to the template.\n         * @returns {jQueryPromise}\n         * @alias getRendered\n         */\n        render: function (tmplPath) {\n            var cachedPromise = renderedTemplatePromises[tmplPath];\n\n            if (!cachedPromise) {\n                cachedPromise = renderedTemplatePromises[tmplPath] = loader\n                    .loadTemplate(tmplPath)\n                    .then(renderer.parseTemplate);\n            }\n\n            return cachedPromise;\n        },\n\n        /**\n         * @ignore\n         */\n        getRendered: function (tmplPath) {\n            return renderer.render(tmplPath);\n        },\n\n        /**\n         * Parses provided string as html content\n         * and returns an array of DOM elements.\n         *\n         * @param {String} html - String to be processed.\n         * @returns {Array}\n         */\n        parseTemplate: function (html) {\n            var fragment = document.createDocumentFragment();\n\n            $(fragment).append(html);\n\n            return renderer.normalize(fragment);\n        },\n\n        /**\n         * Processes custom attributes and nodes of provided DOM element.\n         *\n         * @param {HTMLElement} content - Element to be processed.\n         * @returns {Array} An array of content's child nodes.\n         */\n        normalize: function (content) {\n            globals.forEach(function (handler) {\n                handler(content);\n            });\n\n            return _.toArray(content.childNodes);\n        },\n\n        /**\n         * Adds new global content handler.\n         *\n         * @param {Function} handler - Function which will be invoked for\n         *      an every content passed to 'normalize' method.\n         * @returns {Renderer} Chainable.\n         */\n        addGlobal: function (handler) {\n            if (!_.contains(globals, handler)) {\n                globals.push(handler);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes specified global content handler.\n         *\n         * @param {Function} handler - Handler to be removed.\n         * @returns {Renderer} Chainable.\n         */\n        removeGlobal: function (handler) {\n            var index = globals.indexOf(handler);\n\n            if (~index) {\n                globals.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds new custom attribute handler.\n         *\n         * @param {String} id - Attribute identifier.\n         * @param {(Object|Function)} [config={}]\n         * @returns {Renderer} Chainable.\n         */\n        addAttribute: function (id, config) {\n            var data = {\n                name: id,\n                binding: id,\n                handler: renderer.handlers.attribute\n            };\n\n            if (_.isFunction(config)) {\n                data.handler = config;\n            } else if (_.isObject(config)) {\n                _.extend(data, config);\n            }\n\n            data.id = id;\n            attributes[id] = data;\n\n            return this;\n        },\n\n        /**\n         * Removes specified attribute handler.\n         *\n         * @param {String} id - Attribute identifier.\n         * @returns {Renderer} Chainable.\n         */\n        removeAttribute: function (id) {\n            delete attributes[id];\n\n            return this;\n        },\n\n        /**\n         * Adds new custom node handler.\n         *\n         * @param {String} id - Node identifier.\n         * @param {(Object|Function)} [config={}]\n         * @returns {Renderer} Chainable.\n         */\n        addNode: function (id, config) {\n            var data = {\n                name: id,\n                binding: id,\n                handler: renderer.handlers.node\n            };\n\n            if (_.isFunction(config)) {\n                data.handler = config;\n            } else if (_.isObject(config)) {\n                _.extend(data, config);\n            }\n\n            data.id = id;\n            elements[id] = data;\n\n            return this;\n        },\n\n        /**\n         * Removes specified custom node handler.\n         *\n         * @param {String} id - Node identifier.\n         * @returns {Renderer} Chainable.\n         */\n        removeNode: function (id) {\n            delete elements[id];\n\n            return this;\n        },\n\n        /**\n         * Checks if provided DOM element is a custom node.\n         *\n         * @param {HTMLElement} node - Node to be checked.\n         * @returns {Boolean}\n         */\n        isCustomNode: function (node) {\n            return _.some(elements, function (elem) {\n                return elem.name.toUpperCase() === node.tagName;\n            });\n        },\n\n        /**\n         * Processes custom attributes of a content's child nodes.\n         *\n         * @param {HTMLElement} content - DOM element to be processed.\n         */\n        processAttributes: function (content) {\n            var repeat;\n\n            repeat = _.some(attributes, function (attr) {\n                var attrName = attr.name,\n                    nodes    = content.querySelectorAll('[' + attrName + ']'),\n                    handler  = attr.handler;\n\n                return _.toArray(nodes).some(function (node) {\n                    var data = node.getAttribute(attrName);\n\n                    return handler(node, data, attr) === true;\n                });\n            });\n\n            if (repeat) {\n                renderer.processAttributes(content);\n            }\n        },\n\n        /**\n         * Processes custom nodes of a provided content.\n         *\n         * @param {HTMLElement} content - DOM element to be processed.\n         */\n        processNodes: function (content) {\n            var repeat;\n\n            repeat = _.some(elements, function (element) {\n                var nodes   = content.querySelectorAll(element.name),\n                    handler = element.handler;\n\n                return _.toArray(nodes).some(function (node) {\n                    var data = node.getAttribute('args');\n\n                    return handler(node, data, element) === true;\n                });\n            });\n\n            if (repeat) {\n                renderer.processNodes(content);\n            }\n        },\n\n        /**\n         * Wraps provided string in curly braces if it's necessary.\n         *\n         * @param {String} args - String to be wrapped.\n         * @returns {String} Wrapped string.\n         */\n        wrapArgs: function (args) {\n            if (~args.indexOf('\\\\:')) {\n                args = args.replace(colonReg, ':');\n            } else if (~args.indexOf(':') && !~args.indexOf('}')) {\n                args = '{' + args + '}';\n            }\n\n            return args;\n        },\n\n        /**\n         * Wraps child nodes of provided DOM element\n         * with knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node whose children should be wrapped.\n         * @param {String} binding - Name of the binding for the opener comment tag.\n         * @param {String} data - Data associated with a binding.\n         *\n         * @example\n         *      <div id=\"example\"><span/></div>\n         *      wrapChildren(document.getElementById('example'), 'foreach', 'data');\n         *      =>\n         *      <div id=\"example\">\n         *      <!-- ko foreach: data -->\n         *          <span></span>\n         *      <!-- /ko -->\n         *      </div>\n         */\n        wrapChildren: function (node, binding, data) {\n            var tag = this.createComment(binding, data),\n                $node = $(node);\n\n            $node.prepend(tag.open);\n            $node.append(tag.close);\n        },\n\n        /**\n         * Wraps specified node with knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node to be wrapped.\n         * @param {String} binding - Name of the binding for the opener comment tag.\n         * @param {String} data - Data associated with a binding.\n         *\n         * @example\n         *      <div id=\"example\"></div>\n         *      wrapNode(document.getElementById('example'), 'foreach', 'data');\n         *      =>\n         *      <!-- ko foreach: data -->\n         *          <div id=\"example\"></div>\n         *      <!-- /ko -->\n         */\n        wrapNode: function (node, binding, data) {\n            var tag = this.createComment(binding, data),\n                $node = $(node);\n\n            $node.before(tag.open);\n            $node.after(tag.close);\n        },\n\n        /**\n         * Creates knockouts' comment tag for the provided binding.\n         *\n         * @param {String} binding - Name of the binding.\n         * @param {String} data - Data associated with a binding.\n         * @returns {Object} Object with an open and close comment elements.\n         */\n        createComment: function (binding, data) {\n            return {\n                open: document.createComment(' ko ' + binding + ': ' + data + ' '),\n                close: document.createComment(' /ko ')\n            };\n        }\n    };\n\n    renderer.handlers = {\n\n        /**\n         * Basic node handler. Replaces custom nodes\n         * with a corresponding knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node to be processed.\n         * @param {String} data\n         * @param {Object} element\n         * @returns {Boolean} True\n         *\n         * @example Sample syntaxes conversions.\n         *      <with args=\"model\">\n         *          <span/>\n         *      </with>\n         *      =>\n         *      <!-- ko with: model-->\n         *          <span/>\n         *      <!-- /ko -->\n         */\n        node: function (node, data, element) {\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, element.binding, data);\n            $(node).replaceWith(node.childNodes);\n\n            return true;\n        },\n\n        /**\n         * Base attribute handler. Replaces custom attributes with\n         * a corresponding knockouts' data binding.\n         *\n         * @param {HTMLElement} node - Node to be processed.\n         * @param {String} data - Data associated with a binding.\n         * @param {Object} attr - Attribute definition.\n         *\n         * @example Sample syntaxes conversions.\n         *      <div text=\"label\"></div>\n         *      =>\n         *      <div data-bind=\"text: label\"></div>\n         */\n        attribute: function (node, data, attr) {\n            data = renderer.wrapArgs(data);\n\n            renderer.bindings.add(node, attr.binding, data);\n            node.removeAttribute(attr.name);\n        },\n\n        /**\n         * Wraps provided node with a knockouts' comment tag.\n         *\n         * @param {HTMLElement} node - Node that will be wrapped.\n         * @param {String} data - Data associated with a binding.\n         * @param {Object} attr - Attribute definition.\n         *\n         * @example\n         *      <div outereach=\"data\" class=\"test\"></div>\n         *      =>\n         *      <!-- ko foreach: data -->\n         *          <div class=\"test\"></div>\n         *      <!-- /ko -->\n         */\n        wrapAttribute: function (node, data, attr) {\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, attr.binding, data);\n            node.removeAttribute(attr.name);\n        }\n    };\n\n    renderer.bindings = {\n\n        /**\n         * Appends binding string to the current\n         * 'data-bind' attribute of provided node.\n         *\n         * @param {HTMLElement} node - DOM element whose 'data-bind' attribute will be extended.\n         * @param {String} name - Name of a binding.\n         * @param {String} data - Data associated with the binding.\n         */\n        add: function (node, name, data) {\n            var bindings = this.get(node);\n\n            if (bindings) {\n                bindings += ', ';\n            }\n\n            bindings += name;\n\n            if (data) {\n                bindings += ': ' + data;\n            }\n\n            this.set(node, bindings);\n        },\n\n        /**\n         * Extracts value of a 'data-bind' attribute from provided node.\n         *\n         * @param {HTMLElement} node - Node whose attribute to be extracted.\n         * @returns {String}\n         */\n        get: function (node) {\n            return node.getAttribute('data-bind') || '';\n        },\n\n        /**\n         * Sets 'data-bind' attribute of the specified node\n         * to the provided value.\n         *\n         * @param {HTMLElement} node - Node whose attribute will be altered.\n         * @param {String} bindings - New value of 'data-bind' attribute.\n         */\n        set: function (node, bindings) {\n            node.setAttribute('data-bind', bindings);\n        }\n    };\n\n    renderer\n        .addGlobal(renderer.processAttributes)\n        .addGlobal(renderer.processNodes);\n\n    /**\n     * Collection of default binding conversions.\n     */\n    preset = {\n        nodes: _.object([\n            'if',\n            'text',\n            'with',\n            'scope',\n            'ifnot',\n            'foreach',\n            'component'\n        ], Array.prototype),\n        attributes: _.object([\n            'css',\n            'attr',\n            'html',\n            'with',\n            'text',\n            'click',\n            'event',\n            'submit',\n            'enable',\n            'disable',\n            'options',\n            'visible',\n            'template',\n            'hasFocus',\n            'textInput',\n            'component',\n            'uniqueName',\n            'optionsText',\n            'optionsValue',\n            'checkedValue',\n            'selectedOptions'\n        ], Array.prototype)\n    };\n\n    _.extend(preset.attributes, {\n        if: renderer.handlers.wrapAttribute,\n        ifnot: renderer.handlers.wrapAttribute,\n        innerif: {\n            binding: 'if'\n        },\n        innerifnot: {\n            binding: 'ifnot'\n        },\n        outereach: {\n            binding: 'foreach',\n            handler: renderer.handlers.wrapAttribute\n        },\n        foreach: {\n            name: 'each'\n        },\n        value: {\n            name: 'ko-value'\n        },\n        style: {\n            name: 'ko-style'\n        },\n        checked: {\n            name: 'ko-checked'\n        },\n        disabled: {\n            name: 'ko-disabled',\n            binding: 'disable'\n        },\n        focused: {\n            name: 'ko-focused',\n            binding: 'hasFocus'\n        },\n\n        /**\n         * Custom 'render' attribute handler function. Wraps child elements\n         * of a node with knockout's 'ko template:' comment tag.\n         *\n         * @param {HTMLElement} node - Element to be processed.\n         * @param {String} data - Data specified in 'render' attribute of a node.\n         */\n        render: function (node, data) {\n            data = data || 'getTemplate()';\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapChildren(node, 'template', data);\n            node.removeAttribute('render');\n        }\n    });\n\n    _.extend(preset.nodes, {\n        foreach: {\n            name: 'each'\n        },\n\n        /**\n         * Custom 'render' node handler function.\n         * Replaces node with knockout's 'ko template:' comment tag.\n         *\n         * @param {HTMLElement} node - Element to be processed.\n         * @param {String} data - Data specified in 'args' attribute of a node.\n         */\n        render: function (node, data) {\n            data = data || 'getTemplate()';\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, 'template', data);\n            $(node).replaceWith(node.childNodes);\n        }\n    });\n\n    _.each(preset.attributes, function (data, id) {\n        renderer.addAttribute(id, data);\n    });\n\n    _.each(preset.nodes, function (data, id) {\n        renderer.addNode(id, data);\n    });\n\n    return renderer;\n});\n","Magento_Ui/js/lib/knockout/template/loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var licenseRegExp   = /<!--[\\s\\S]*?-->/,\n        defaultPlugin   = 'text',\n        defaultExt      = 'html';\n\n    /**\n     * Checks of provided string contains a file extension.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function hasFileExtension(str) {\n        return !!~str.indexOf('.') && !!str.split('.').pop();\n    }\n\n    /**\n     * Checks if provided string contains a requirejs's plugin reference.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function hasPlugin(str) {\n        return !!~str.indexOf('!');\n    }\n\n    /**\n     * Checks if provided string is a full path to the file.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function isFullPath(str) {\n        return !!~str.indexOf('://');\n    }\n\n    /**\n     * Removes license comment from the provided string.\n     *\n     * @param {String} content - String to be processed.\n     * @returns {String}\n     */\n    function removeLicense(content) {\n        return content.replace(licenseRegExp, function (match) {\n            return ~match.indexOf('/**') ? '' : match;\n        });\n    }\n\n    return {\n\n        /**\n         * Attempts to extract template by provided path from\n         * a DOM element and falls back to a file loading if\n         * none of the DOM nodes was found.\n         *\n         * @param {String} path - Path to the template or a DOM selector.\n         * @returns {jQueryPromise}\n         */\n        loadTemplate: function (path) {\n            var content = this.loadFromNode(path),\n                defer;\n\n            if (content) {\n                defer = $.Deferred();\n\n                defer.resolve(content);\n\n                return defer.promise();\n            }\n\n            return this.loadFromFile(path);\n        },\n\n        /**\n         * Loads template from external file by provided\n         * path, which will be preliminary formatted.\n         *\n         * @param {String} path - Path to the template.\n         * @returns {jQueryPromise}\n         */\n        loadFromFile: function (path) {\n            var loading = $.Deferred();\n\n            path = this.formatPath(path);\n\n            require([path], function (template) {\n                template = removeLicense(template);\n                loading.resolve(template);\n            }, function (err) {\n                loading.reject(err);\n            });\n\n            return loading.promise();\n        },\n\n        /**\n         * Attempts to extract content of a node found by provided selector.\n         *\n         * @param {String} selector - Node's selector (not necessary valid).\n         * @returns {String|Boolean} If specified node doesn't exists\n         *      'false' will be returned, otherwise returns node's content.\n         */\n        loadFromNode: function (selector) {\n            var node;\n\n            try {\n                node =\n                    document.getElementById(selector) ||\n                    document.querySelector(selector);\n\n                return node ? node.innerHTML : false;\n            } catch (e) {\n                return false;\n            }\n        },\n\n        /**\n         * Adds requirejs's plugin and file extension to\n         * to the provided string if it's necessary.\n         *\n         * @param {String} path - Path to be processed.\n         * @returns {String} Formatted path.\n         */\n        formatPath: function (path) {\n            var result = path;\n\n            if (!hasPlugin(path)) {\n                result = defaultPlugin + '!' + result;\n            }\n\n            if (isFullPath(path)) {\n                return result;\n            }\n\n            if (!hasFileExtension(path)) {\n                result += '.' + defaultExt;\n            }\n\n            return result.replace(/^([^\\/]+)/g, '$1/template');\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/bind-html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/apply/main',\n    '../template/renderer'\n], function (ko, _, mage, renderer) {\n    'use strict';\n\n    /**\n     * Set html to node element.\n     *\n     * @param {HTMLElement} el - Element to apply bindings to.\n     * @param {Function} html - Observable html content.\n     */\n    function setHtml(el, html) {\n        ko.utils.emptyDomNode(el);\n        html = ko.utils.unwrapObservable(html);\n\n        if (!_.isNull(html) && !_.isUndefined(html)) {\n            if (!_.isString(html)) {\n                html = html.toString();\n            }\n\n            el.innerHTML = html;\n        }\n    }\n\n    /**\n     * Apply bindings and call magento attributes parser.\n     *\n     * @param {HTMLElement} el - Element to apply bindings to.\n     * @param {ko.bindingContext} ctx - Instance of ko.bindingContext, passed to binding initially.\n     */\n    function applyComponents(el, ctx) {\n        ko.utils.arrayForEach(el.childNodes, ko.cleanNode);\n        ko.applyBindingsToDescendants(ctx, el);\n        mage.apply();\n    }\n\n    ko.bindingHandlers.bindHtml = {\n        /**\n         * Scope binding's init method.\n         *\n         * @returns {Object} - Knockout declaration for it to let binding control descendants.\n         */\n        init: function () {\n            return {\n                controlsDescendantBindings: true\n            };\n        },\n\n        /**\n         * Reads params passed to binding.\n         * Set html to node element, apply bindings and call magento attributes parser.\n         *\n         * @param {HTMLElement} el - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to el.\n         * @param {ko.bindingContext} bindingContext - Instance of ko.bindingContext, passed to binding initially.\n         */\n        update: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            setHtml(el, valueAccessor());\n            applyComponents(el, bindingContext);\n        }\n    };\n\n    renderer.addAttribute('bindHtml');\n});\n","Magento_Ui/js/lib/knockout/bindings/fadeVisible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko'\n], function ($, ko) {\n    'use strict';\n\n    ko.bindingHandlers.fadeVisible = {\n        /**\n         * Initially set the element to be instantly visible/hidden depending on the value.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            var value = valueAccessor();\n\n            // Use \"unwrapObservable\" so we can handle values that may or may not be observable\n            $(element).toggle(ko.unwrap(value));\n        },\n\n        /**\n         * Whenever the value subsequently changes, slowly fade the element in or out.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            var value = valueAccessor();\n\n            ko.unwrap(value) ? $(element).fadeIn() : $(element).fadeOut();\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/scope.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates scope binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'uiRegistry',\n    'mage/translate',\n    '../template/renderer',\n    'jquery',\n    '../../logger/console-logger'\n], function (ko, registry, $t, renderer, $, consoleLogger) {\n    'use strict';\n\n    /**\n     * Creates child context with passed component param as $data. Extends context with $t helper.\n     * Applies bindings to descendant nodes.\n     * @param {HTMLElement} el - element to apply bindings to.\n     * @param {ko.bindingContext} bindingContext - instance of ko.bindingContext, passed to binding initially.\n     * @param {Promise} promise - instance of jQuery promise\n     * @param {Object} component - component instance to attach to new context\n     */\n    function applyComponents(el, bindingContext, promise, component) {\n        promise.resolve();\n        component = bindingContext.createChildContext(component);\n\n        ko.utils.extend(component, {\n            $t: $t\n        });\n\n        ko.utils.arrayForEach(ko.virtualElements.childNodes(el), ko.cleanNode);\n\n        ko.applyBindingsToDescendants(component, el);\n    }\n\n    ko.bindingHandlers.scope = {\n\n        /**\n         * Scope binding's init method.\n         * @returns {Object} - Knockout declaration for it to let binding control descendants.\n         */\n        init: function () {\n            return {\n                controlsDescendantBindings: true\n            };\n        },\n\n        /**\n         * Reads params passed to binding, parses component declarations.\n         * Fetches for those found and attaches them to the new context.\n         * @param {HTMLElement} el - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to el.\n         * @param {ko.bindingContext} bindingContext - Instance of ko.bindingContext, passed to binding initially.\n         */\n        update: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            var component = valueAccessor(),\n                promise = $.Deferred(),\n                apply = applyComponents.bind(this, el, bindingContext, promise),\n                loggerUtils = consoleLogger.utils;\n\n            if (typeof component === 'string') {\n                loggerUtils.asyncLog(\n                    promise,\n                    {\n                        data: {\n                            component: component\n                        },\n                        messages: loggerUtils.createMessages(\n                            'requestingComponent',\n                            'requestingComponentIsLoaded',\n                            'requestingComponentIsFailed'\n                        )\n                    }\n                );\n\n                registry.get(component, apply);\n            } else if (typeof component === 'function') {\n                component(apply);\n            }\n        }\n    };\n\n    ko.virtualElements.allowedBindings.scope = true;\n\n    renderer\n        .addNode('scope')\n        .addAttribute('scope', {\n            name: 'ko-scope'\n        });\n});\n","Magento_Ui/js/lib/knockout/bindings/tooltip.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    'mage/template',\n    'text!ui/template/tooltip/tooltip.html',\n    '../template/renderer'\n], function ($, ko, _, template, tooltipTmpl, renderer) {\n    'use strict';\n\n    var tooltip,\n        defaults,\n        positions,\n        transformProp,\n        checkedPositions = {},\n        iterator = 0,\n        previousTooltip,\n        tooltipData,\n        positionData = {},\n        tooltipsCollection = {},\n        isTouchDevice = (function () {\n            return 'ontouchstart' in document.documentElement;\n        })(),\n        CLICK_EVENT = (function () {\n            return isTouchDevice ? 'touchstart' : 'click';\n        })();\n\n    defaults = {\n        tooltipWrapper: '[data-tooltip=tooltip-wrapper]',\n        tooltipContentBlock: 'data-tooltip-content',\n        closeButtonClass: 'action-close',\n        tailClass: 'data-tooltip-tail',\n        action: 'hover',\n        delay: 300,\n        track: false,\n        step: 20,\n        position: 'top',\n        closeButton: false,\n        showed: false,\n        strict: true,\n        center: false,\n        closeOnScroll: true\n    };\n\n    tooltipData = {\n        tooltipClasses: '',\n        trigger: false,\n        timeout: 0,\n        element: false,\n        event: false,\n        targetElement: {},\n        showed: false,\n        currentID: 0\n    };\n\n    /**\n     * Polyfill for css transform\n     */\n    transformProp = (function () {\n        var style = document.createElement('div').style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform !== 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] !== 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    positions = {\n\n        /*eslint max-depth: [0, 0]*/\n\n        map: {\n            horizontal: {\n                s: 'w',\n                p: 'left'\n            },\n            vertical: {\n                s: 'h',\n                p: 'top'\n            }\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        top: function (s) {\n            return positions._topLeftChecker(s, positions.map, 'vertical', '_bottom', 'top', 'right');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        left: function (s) {\n            return positions._topLeftChecker(s, positions.map, 'horizontal', '_right', 'left', 'top');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        bottom: function (s) {\n            return positions._bottomRightChecker(s, positions.map, 'vertical', '_top', 'bottom', 'left');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        right: function (s) {\n            return positions._bottomRightChecker(s, positions.map, 'horizontal', '_left', 'right', 'bottom');\n        },\n\n        /**\n         * Check can tooltip setted on current position or not. If can't setted - delegate call.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {String} className - class whats should be setted to tooltip\n         * @param {String} side - parent method name\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _topLeftChecker: function (s, map, direction, className, side, delegate) {\n            var result = {\n                    position: {}\n                },\n                config = tooltip.getTooltip(tooltipData.currentID),\n                startPosition = !config.strict ? s.eventPosition : s.elementPosition,\n                changedDirection;\n\n            checkedPositions[side] = true;\n\n            if (\n                startPosition[map[direction].p] - s.tooltipSize[map[direction].s] - config.step >\n                s.scrollPosition[map[direction].p]\n            ) {\n                result.position[map[direction].p] = startPosition[map[direction].p] - s.tooltipSize[map[direction].s] -\n                    config.step;\n                result.className = className;\n                result.side = side;\n                changedDirection = direction === 'vertical' ? 'horizontal' : 'vertical';\n                result = positions._normalize(s, result, config, delegate, map, changedDirection);\n            } else if (!checkedPositions[delegate]) {\n                result = positions[delegate].apply(null, arguments);\n            } else {\n                result = positions.positionCenter(s, result);\n            }\n\n            return result;\n        },\n\n        /**\n         * Check can tooltip setted on current position or not. If can't setted - delegate call.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {String} className - class whats should be setted to tooltip\n         * @param {String} side - parent method name\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _bottomRightChecker: function (s, map, direction, className, side, delegate) {\n            var result = {\n                    position: {}\n                },\n                config = tooltip.getTooltip(tooltipData.currentID),\n                startPosition = !config.strict ? s.eventPosition : {\n                    top: s.elementPosition.top + s.elementSize.h,\n                    left: s.elementPosition.left + s.elementSize.w\n                },\n                changedDirection;\n\n            checkedPositions[side] = true;\n\n            if (\n                startPosition[map[direction].p] + s.tooltipSize[map[direction].s] + config.step <\n                s.scrollPosition[map[direction].p] + s.windowSize[map[direction].s]\n            ) {\n                result.position[map[direction].p] = startPosition[map[direction].p] + config.step;\n                result.className = className;\n                result.side = side;\n                changedDirection = direction === 'vertical' ? 'horizontal' : 'vertical';\n                result = positions._normalize(s, result, config, delegate, map, changedDirection);\n            } else if (!checkedPositions[delegate]) {\n                result = positions[delegate].apply(null, arguments);\n            } else {\n                result = positions.positionCenter(s, result);\n            }\n\n            return result;\n        },\n\n        /**\n         * Centered tooltip if tooltip does not fit in window\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        positionCenter: function (s, data) {\n            data = positions._positionCenter(s, data, 'horizontal', positions.map);\n            data = positions._positionCenter(s, data, 'vertical', positions.map);\n\n            return data;\n        },\n\n        /**\n         * Centered tooltip side\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {String} direction - vertical or horizontal\n         * @param {Object} map - mapping for get direction positions\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _positionCenter: function (s, data, direction, map) {\n            if (s.tooltipSize[map[direction].s] < s.windowSize[map[direction].s]) {\n                data.position[map[direction].p] = (s.windowSize[map[direction].s] -\n                    s.tooltipSize[map[direction].s]) / 2 + s.scrollPosition[map[direction].p];\n            } else {\n                data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                data.tooltipSize = {};\n                data.tooltipSize[map[direction].s] = s.windowSize[map[direction].s];\n            }\n\n            return data;\n        },\n\n        /**\n         * Normalize horizontal or vertical position.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {Object} config - tooltip config\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _normalize: function (s, data, config, delegate, map, direction) {\n            var startPosition = !config.center ? s.eventPosition : {\n                    left: s.elementPosition.left + s.elementSize.w / 2,\n                    top: s.elementPosition.top + s.elementSize.h / 2\n                },\n                depResult;\n\n            if (startPosition[map[direction].p] - s.tooltipSize[map[direction].s] / 2 >\n                s.scrollPosition[map[direction].p] && startPosition[map[direction].p] +\n                s.tooltipSize[map[direction].s] / 2 <\n                s.scrollPosition[map[direction].p] + s.windowSize[map[direction].s]\n            ) {\n                data.position[map[direction].p] = startPosition[map[direction].p] - s.tooltipSize[map[direction].s] / 2;\n            } else {\n\n                /*eslint-disable no-lonely-if*/\n                if (!checkedPositions[delegate]) {\n                    depResult = positions[delegate].apply(null, arguments);\n\n                    if (depResult.hasOwnProperty('className')) {\n                        data = depResult;\n                    } else {\n                        data = positions._normalizeTail(s, data, config, delegate, map, direction, startPosition);\n                    }\n                } else {\n                    data = positions._normalizeTail(s, data, config, delegate, map, direction, startPosition);\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Calc tail position.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {Object} config - tooltip config\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {Object} startPosition - start position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _normalizeTail: function (s, data, config, delegate, map, direction, startPosition) {\n            data.tail = {};\n\n            if (s.tooltipSize[map[direction].s] < s.windowSize[map[direction].s]) {\n\n                if (\n                    startPosition[map[direction].p] >\n                    s.windowSize[map[direction].s] / 2 + s.scrollPosition[map[direction].p]\n                ) {\n                    data.position[map[direction].p] = s.windowSize[map[direction].s] +\n                        s.scrollPosition[map[direction].p] - s.tooltipSize[map[direction].s];\n                    data.tail[map[direction].p] = startPosition[map[direction].p] -\n                        s.tooltipSize[map[direction].s] / 2 - data.position[map[direction].p];\n                } else {\n                    data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                    data.tail[map[direction].p] = startPosition[map[direction].p] -\n                        s.tooltipSize[map[direction].s] / 2 - data.position[map[direction].p];\n                }\n            } else {\n                data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                data.tail[map[direction].p] = s.eventPosition[map[direction].p] - s.windowSize[map[direction].s] / 2;\n                data.tooltipSize = {};\n                data.tooltipSize[map[direction].s] = s.windowSize[map[direction].s];\n            }\n\n            return data;\n        }\n    };\n\n    tooltip = {\n\n        /**\n         * Set new tooltip to tooltipCollection, save config, and add unic id\n         *\n         * @param {Object} config - tooltip config\n         * @returns {String} tooltip id\n         */\n        setTooltip: function (config) {\n            var property = 'id-' + iterator;\n\n            tooltipsCollection[property] = config;\n            iterator++;\n\n            return property;\n        },\n\n        /**\n         * Get tooltip config by id\n         *\n         * @param {String} id - tooltip id\n         * @returns {Object} tooltip config\n         */\n        getTooltip: function (id) {\n            return tooltipsCollection[id];\n        },\n\n        /**\n         * Set content to current tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {Object} viewModel - tooltip view model\n         * @param {String} id - tooltip id\n         * @param {Object} bindingCtx - tooltip context\n         * @param {Object} event - action event\n         */\n        setContent: function (tooltipElement, viewModel, id, bindingCtx, event) {\n            var html = $(tooltipElement).html(),\n                config = tooltip.getTooltip(id),\n                body = $('body');\n\n            tooltipData.currentID = id;\n            tooltipData.trigger = $(event.currentTarget);\n            tooltip.setTargetData(event);\n            body.on('mousemove.setTargetData', tooltip.setTargetData);\n            tooltip.clearTimeout(id);\n\n            tooltipData.timeout = _.delay(function () {\n                body.off('mousemove.setTargetData', tooltip.setTargetData);\n\n                if (tooltipData.trigger[0] === tooltipData.targetElement) {\n                    tooltip.destroy(id);\n                    event.stopPropagation();\n                    tooltipElement = tooltip.createTooltip(id);\n                    tooltipElement.find('.' + defaults.tooltipContentBlock).append(html);\n                    tooltipElement.applyBindings(bindingCtx);\n                    tooltip.setHandlers(id);\n                    tooltip.setPosition(tooltipElement, id);\n                    previousTooltip = id;\n                }\n\n            }, config.delay);\n        },\n\n        /**\n         * Set position to current tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {String} id - tooltip id\n         */\n        setPosition: function (tooltipElement, id) {\n            var config = tooltip.getTooltip(id);\n\n            tooltip.sizeData = {\n                windowSize: {\n                    h: $(window).outerHeight(),\n                    w: $(window).outerWidth()\n                },\n                scrollPosition: {\n                    top: $(window).scrollTop(),\n                    left: $(window).scrollLeft()\n                },\n                tooltipSize: {\n                    h: tooltipElement.outerHeight(),\n                    w: tooltipElement.outerWidth()\n                },\n                elementSize: {\n                    h: tooltipData.trigger.outerHeight(),\n                    w: tooltipData.trigger.outerWidth()\n                },\n                elementPosition: tooltipData.trigger.offset(),\n                eventPosition: this.getEventPosition(tooltipData.event)\n            };\n\n            _.extend(positionData, positions[config.position](tooltip.sizeData));\n            tooltipElement.css(positionData.position);\n            tooltipElement.addClass(positionData.className);\n            tooltip._setTooltipSize(positionData, tooltipElement);\n            tooltip._setTailPosition(positionData, tooltipElement);\n            checkedPositions = {};\n        },\n\n        /**\n         * Check position data and change tooltip size if needs\n         *\n         * @param {Object} data - position data\n         * @param {Object} tooltipElement - tooltip element\n         */\n        _setTooltipSize: function (data, tooltipElement) {\n            if (data.tooltipSize) {\n                data.tooltipSize.w ?\n                    tooltipElement.css('width', data.tooltipSize.w) :\n                    tooltipElement.css('height', data.tooltipSize.h);\n            }\n        },\n\n        /**\n         * Check position data and set position to tail\n         *\n         * @param {Object} data - position data\n         * @param {Object} tooltipElement - tooltip element\n         */\n        _setTailPosition: function (data, tooltipElement) {\n            var tail,\n                tailMargin;\n\n            if (data.tail) {\n                tail = tooltipElement.find('.' + defaults.tailClass);\n\n                if (data.tail.left) {\n                    tailMargin = parseInt(tail.css('margin-left'), 10);\n                    tail.css('margin-left', tailMargin + data.tail.left);\n                } else {\n                    tailMargin = parseInt(tail.css('margin-top'), 10);\n                    tail.css('margin-top', tailMargin + data.tail.top);\n                }\n            }\n        },\n\n        /**\n         * Resolves position for tooltip\n         *\n         * @param {Object} event\n         * @returns {Object}\n         */\n        getEventPosition: function (event) {\n            var position = {\n                left: event.originalEvent && event.originalEvent.pageX || 0,\n                top: event.originalEvent && event.originalEvent.pageY || 0\n            };\n\n            if (position.left === 0 && position.top === 0) {\n                _.extend(position, event.target.getBoundingClientRect());\n            }\n\n            return position;\n        },\n\n        /**\n         * Close tooltip if action happened outside handler and tooltip element\n         *\n         * @param {String} id - tooltip id\n         * @param {Object} event - action event\n         */\n        outerClick: function (id, event) {\n            var tooltipElement = $(event.target).parents(defaults.tooltipWrapper)[0],\n                isTrigger = event.target === tooltipData.trigger[0] || $.contains(tooltipData.trigger[0], event.target);\n\n            if (tooltipData.showed && tooltipElement !== tooltipData.element[0] && !isTrigger) {\n                tooltip.destroy(id);\n            }\n        },\n\n        /**\n         * Parse keydown event and if event trigger is escape key - close tooltip\n         *\n         * @param {Object} event - action event\n         */\n        keydownHandler: function (event) {\n            if (tooltipData.showed && event.keyCode === 27) {\n                tooltip.destroy(tooltipData.currentID);\n            }\n        },\n\n        /**\n         * Change tooltip position when track is enabled\n         *\n         * @param {Object} event - current event\n         */\n        track: function (event) {\n            var inequality = {},\n                map = positions.map,\n                translate = {\n                    left: 'translateX',\n                    top: 'translateY'\n                },\n                eventPosition = {\n                    left: event.pageX,\n                    top: event.pageY\n                },\n                tooltipSize = {\n                    w: tooltipData.element.outerWidth(),\n                    h: tooltipData.element.outerHeight()\n                },\n                direction = positionData.side === 'bottom' || positionData.side === 'top' ? 'horizontal' : 'vertical';\n\n            inequality[map[direction].p] = eventPosition[map[direction].p] - (positionData.position[map[direction].p] +\n                tooltipSize[map[direction].s] / 2);\n\n            if (positionData.position[map[direction].p] + inequality[map[direction].p] +\n                tooltip.sizeData.tooltipSize[map[direction].s] >\n                tooltip.sizeData.windowSize[map[direction].s] + tooltip.sizeData.scrollPosition[map[direction].p] ||\n                inequality[map[direction].p] + positionData.position[map[direction].p] <\n                tooltip.sizeData.scrollPosition[map[direction].p]) {\n\n                return false;\n            }\n\n            tooltipData.element[0].style[transformProp] = translate[map[direction].p] +\n                '(' + inequality[map[direction].p] + 'px)';\n        },\n\n        /**\n         * Set handlers to tooltip\n         *\n         * @param {String} id - tooltip id\n         */\n        setHandlers: function (id) {\n            var config = tooltip.getTooltip(id);\n\n            if (config.track) {\n                tooltipData.trigger.on('mousemove.track', tooltip.track);\n            }\n\n            if (config.action === 'click') {\n                $(window).on(CLICK_EVENT + '.outerClick', tooltip.outerClick.bind(null, id));\n            }\n\n            if (config.closeButton) {\n                $('.' + config.closeButtonClass).on('click.closeButton', tooltip.destroy.bind(null, id));\n            }\n\n            if (config.closeOnScroll) {\n                document.addEventListener('scroll', tooltip.destroy, true);\n                $(window).on('scroll.tooltip', tooltip.outerClick.bind(null, id));\n            }\n\n            $(window).on('keydown.tooltip', tooltip.keydownHandler);\n            $(window).on('resize.outerClick', tooltip.outerClick.bind(null, id));\n        },\n\n        /**\n         * Toggle tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {Object} viewModel - tooltip view model\n         * @param {String} id - tooltip id\n         */\n        toggleTooltip: function (tooltipElement, viewModel, id) {\n            if (previousTooltip === id && tooltipData.showed) {\n                tooltip.destroy(id);\n\n                return false;\n            }\n\n            tooltip.setContent.apply(null, arguments);\n\n            return false;\n        },\n\n        /**\n         * Create tooltip and append to DOM\n         *\n         * @param {String} id - tooltip id\n         * @returns {Object} tooltip element\n         */\n        createTooltip: function (id) {\n            var body = $('body'),\n                config = tooltip.getTooltip(id);\n\n            $(template(tooltipTmpl, {\n                data: config\n            })).appendTo(body);\n\n            tooltipData.showed = true;\n            tooltipData.element = $(config.tooltipWrapper);\n\n            return tooltipData.element;\n        },\n\n        /**\n         * Check action and clean timeout\n         *\n         * @param {String} id - tooltip id\n         */\n        clearTimeout: function (id) {\n            var config = tooltip.getTooltip(id);\n\n            if (config.action === 'hover') {\n                clearTimeout(tooltipData.timeout);\n            }\n        },\n\n        /**\n         * Check previous tooltip\n         */\n        checkPreviousTooltip: function () {\n            if (!tooltipData.timeout) {\n                tooltip.destroy();\n            }\n        },\n\n        /**\n         * Destroy tooltip instance\n         */\n        destroy: function () {\n            if (tooltipData.element) {\n                tooltipData.element.remove();\n                tooltipData.showed = false;\n            }\n\n            positionData = {};\n            tooltipData.timeout = false;\n            tooltip.removeHandlers();\n        },\n\n        /**\n         * Remove tooltip handlers\n         */\n        removeHandlers: function () {\n            $('.' + defaults.closeButtonClass).off('click.closeButton');\n            tooltipData.trigger.off('mousemove.track');\n            document.removeEventListener('scroll', tooltip.destroy, true);\n            $(window).off('scroll.tooltip');\n            $(window).off(CLICK_EVENT + '.outerClick');\n            $(window).off('keydown.tooltip');\n            $(window).off('resize.outerClick');\n        },\n\n        /**\n         * Set target element\n         *\n         * @param {Object} event - current event\n         */\n        setTargetData: function (event) {\n            tooltipData.event = event;\n\n            //TODO: bug chrome v.49; Link to issue https://bugs.chromium.org/p/chromium/issues/detail?id=161464\n            if (event.timeStamp - (tooltipData.timestamp || 0) < 1) {\n                return;\n            }\n\n            if (event.type === 'mousemove') {\n                tooltipData.targetElement = event.target;\n            } else {\n                tooltipData.targetElement = event.currentTarget;\n                tooltipData.timestamp = event.timeStamp;\n            }\n        },\n\n        /**\n         * Merged user config with defaults configuration\n         *\n         * @param {Object} config - user config\n         * @returns {Object} merged config\n         */\n        processingConfig: function (config) {\n            return _.extend({}, defaults, config);\n        }\n    };\n\n    ko.bindingHandlers.tooltip = {\n\n        /**\n         * Initialize tooltip\n         *\n         * @param {Object} elem - tooltip DOM element\n         * @param {Function} valueAccessor - ko observable property, tooltip data\n         * @param {Object} allBindings - all bindings on current element\n         * @param {Object} viewModel - current element viewModel\n         * @param {Object} bindingCtx - current element binding context\n         */\n        init: function (elem, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var config = tooltip.processingConfig(valueAccessor()),\n                $parentScope = config.parentScope ? $(config.parentScope) : $(elem).parent(),\n                tooltipId;\n\n            $(elem).addClass('hidden');\n\n            if (isTouchDevice) {\n                config.action = 'click';\n            }\n            tooltipId = tooltip.setTooltip(config);\n\n            if (config.action === 'hover') {\n                $parentScope.on(\n                    'mouseenter',\n                    config.trigger,\n                    tooltip.setContent.bind(null, elem, viewModel, tooltipId, bindingCtx)\n                );\n                $parentScope.on(\n                    'mouseleave',\n                    config.trigger,\n                    tooltip.checkPreviousTooltip.bind(null, tooltipId)\n                );\n            } else if (config.action === 'click') {\n                $parentScope.on(\n                    'click',\n                    config.trigger,\n                    tooltip.toggleTooltip.bind(null, elem, viewModel, tooltipId, bindingCtx)\n                );\n            }\n\n            return {\n                controlsDescendantBindings: true\n            };\n        }\n    };\n\n    renderer.addAttribute('tooltip');\n});\n","Magento_Ui/js/lib/knockout/bindings/outer_click.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates outerClick binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var defaults = {\n        onlyIfVisible: true\n    };\n\n    /**\n     * Checks if element sis visible.\n     *\n     * @param {Element} el\n     * @returns {Boolean}\n     */\n    function isVisible(el) {\n        var style = window.getComputedStyle(el),\n            visibility = {\n                display: 'none',\n                visibility: 'hidden',\n                opacity: '0'\n            },\n            visible = true;\n\n        _.each(visibility, function (val, key) {\n            if (style[key] === val) {\n                visible = false;\n            }\n        });\n\n        return visible;\n    }\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element,\n     * invokes specified in configuration callback.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} config\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, config, e) {\n        var target = e.target,\n            callback = config.callback;\n\n        if (container === target || container.contains(target)) {\n            return;\n        }\n\n        if (config.onlyIfVisible) {\n            if (!_.isNull(container.offsetParent) && isVisible(container)) {\n                callback();\n            }\n        } else {\n            callback();\n        }\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {(Object|Function)} [options={}]\n     * @returns {Object}\n     */\n    function buildConfig(options) {\n        var config = {};\n\n        if (_.isFunction(options)) {\n            options = {\n                callback: options\n            };\n        } else if (!_.isObject(options)) {\n            options = {};\n        }\n\n        return _.extend(config, defaults, options);\n    }\n\n    ko.bindingHandlers.outerClick = {\n\n        /**\n         * Initializes outer click binding.\n         */\n        init: function (element, valueAccessor) {\n            var config = buildConfig(valueAccessor()),\n                outerClick = onOuterClick.bind(null, element, config),\n                isTouchDevice = typeof document.ontouchstart !== 'undefined';\n\n            if (isTouchDevice) {\n                $(document).on('touchstart', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('touchstart', outerClick);\n                });\n            } else {\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n        }\n    };\n\n    renderer.addAttribute('outerClick');\n});\n","Magento_Ui/js/lib/knockout/bindings/simple-checked.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.simpleChecked = {\n        'after': ['attr'],\n\n        /**\n         * Implements same functionality as a standard 'simpleChecked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                updateView,\n                updateModel;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            /**\n             * Updates checked observable\n             */\n            updateModel = function () {\n                var  modelValue = ko.dependencyDetection.ignore(valueAccessor),\n                    isChecked = element.checked;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (modelValue.peek() === isChecked) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue(isChecked);\n            };\n\n            /**\n             * Updates checkbox state\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                element.checked = !!modelValue;\n            };\n\n            ko.utils.registerEventHandler(element, 'change', updateModel);\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting._twoWayBindings.simpleChecked = true;\n\n    renderer.addAttribute('simpleChecked');\n    renderer.addAttribute('simple-checked', {\n        binding: 'simpleChecked'\n    });\n});\n","Magento_Ui/js/lib/knockout/bindings/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function (require) {\n    'use strict';\n\n    var renderer = require('../template/renderer');\n\n    renderer.addAttribute('repeat', renderer.handlers.wrapAttribute);\n\n    renderer.addAttribute('outerfasteach', {\n        binding: 'fastForEach',\n        handler: renderer.handlers.wrapAttribute\n    });\n\n    renderer\n        .addNode('repeat')\n        .addNode('fastForEach');\n\n    return {\n        resizable:      require('./resizable'),\n        i18n:           require('./i18n'),\n        scope:          require('./scope'),\n        range:          require('./range'),\n        mageInit:       require('./mage-init'),\n        keyboard:       require('./keyboard'),\n        optgroup:       require('./optgroup'),\n        afterRender:     require('./after-render'),\n        autoselect:     require('./autoselect'),\n        datepicker:     require('./datepicker'),\n        outerClick:     require('./outer_click'),\n        fadeVisible:    require('./fadeVisible'),\n        collapsible:    require('./collapsible'),\n        staticChecked:  require('./staticChecked'),\n        simpleChecked:  require('./simple-checked'),\n        bindHtml:       require('./bind-html'),\n        tooltip:        require('./tooltip'),\n        repeat:         require('knockoutjs/knockout-repeat'),\n        fastForEach:    require('knockoutjs/knockout-fast-foreach'),\n        colorPicker:    require('./color-picker')\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/range.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var isTouchDevice = !_.isUndefined(document.ontouchstart),\n        sliderFn = 'slider',\n        sliderModule = 'jquery-ui-modules/slider';\n\n    if (isTouchDevice) {\n        sliderFn = 'touchSlider';\n        sliderModule = 'mage/touch-slider';\n    }\n\n    ko.bindingHandlers.range = {\n\n        /**\n         * Initializes binding and a slider update.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            var config  = valueAccessor(),\n                value   = config.value;\n\n            _.extend(config, {\n                value: value(),\n\n                /**\n                 * Callback which is being called when sliders' value changes.\n                 *\n                 * @param {Event} event\n                 * @param {Object} ui\n                 */\n                slide: function (event, ui) {\n                    value(ui.value);\n                }\n            });\n\n            require([sliderModule], function () {\n                $(element)[sliderFn](config);\n            });\n        },\n\n        /**\n         * Updates sliders' plugin configuration.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            var config = valueAccessor();\n\n            config.value = ko.unwrap(config.value);\n\n            require([sliderModule], function () {\n                $(element)[sliderFn]('option', config);\n            });\n        }\n    };\n\n    renderer.addAttribute('range');\n});\n","Magento_Ui/js/lib/knockout/bindings/mage-init.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/apply/main'\n], function (ko, _, mage) {\n    'use strict';\n\n    ko.bindingHandlers.mageInit = {\n        /**\n         * Initializes components assigned to HTML elements.\n         *\n         * @param {HTMLElement} el\n         * @param {Function} valueAccessor\n         */\n        init: function (el, valueAccessor) {\n            var data = valueAccessor();\n\n            _.each(data, function (config, component) {\n                mage.applyFor(el, config, component);\n            });\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/staticChecked.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.staticChecked = {\n        'after': ['value', 'attr'],\n\n        /**\n         * Implements same functionality as a standard 'checked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor, allBindings) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                isValueArray,\n                oldElemValue,\n                useCheckedValue,\n                checkedValue,\n                updateModel,\n                updateView;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            checkedValue = ko.pureComputed(function () {\n                if (allBindings.has('checkedValue')) {\n                    return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                } else if (allBindings.has('value')) {\n                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                }\n\n                return element.value;\n            });\n\n            isValueArray = isCheckbox && ko.utils.unwrapObservable(valueAccessor()) instanceof Array;\n            oldElemValue = isValueArray ? checkedValue() : undefined;\n            useCheckedValue = isRadio || isValueArray;\n\n            /**\n             * Updates values array if it's necessary.\n             */\n            updateModel = function () {\n                var isChecked = element.checked,\n                    elemValue = useCheckedValue ? checkedValue() : isChecked,\n                    modelValue;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue = ko.dependencyDetection.ignore(valueAccessor);\n\n                if (isValueArray) {\n                    if (oldElemValue !== elemValue) {\n                        oldElemValue = elemValue;\n                    } else {\n                        ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);\n                    }\n                } else {\n                    ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                }\n            };\n\n            /**\n             * Updates checkbox state.\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                if (isValueArray) {\n                    element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n                } else if (isCheckbox) {\n                    element.checked = modelValue;\n                } else {\n                    element.checked = checkedValue() === modelValue;\n                }\n            };\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n\n            ko.utils.registerEventHandler(element, 'click', updateModel);\n\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting._twoWayBindings.staticChecked = true;\n\n    renderer.addAttribute('staticChecked');\n});\n","Magento_Ui/js/lib/knockout/bindings/optgroup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'mageUtils'\n    ], function (ko, utils) {\n    'use strict';\n\n    var captionPlaceholder = {},\n        optgroupTmpl = '<optgroup label=\"${ $.label }\"></optgroup>',\n        nbspRe = /&nbsp;/g,\n        optionsText,\n        optionsValue,\n        optionTitle;\n\n    ko.bindingHandlers.optgroup = {\n        /**\n         * @param {*} element\n         */\n        init: function (element) {\n            if (ko.utils.tagNameLower(element) !== 'select') {\n                throw new Error('options binding applies only to SELECT elements');\n            }\n\n            // Remove all existing <option>s.\n            while (element.length > 0) {\n                element.remove(0);\n            }\n        },\n\n        /**\n         * @param {*} element\n         * @param {*} valueAccessor\n         * @param {*} allBindings\n         */\n        update: function (element, valueAccessor, allBindings) {\n            var selectWasPreviouslyEmpty = element.length === 0,\n                previousScrollTop = !selectWasPreviouslyEmpty && element.multiple ? element.scrollTop : null,\n                includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                arrayToDomNodeChildrenOptions = {},\n                captionValue,\n                unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                filteredArray,\n                previousSelectedValues,\n                itemUpdate = false,\n                callback = setSelectionCallback,//eslint-disable-line no-use-before-define\n                nestedOptionsLevel = -1;\n\n            optionsText = ko.utils.unwrapObservable(allBindings.get('optionsText')) || 'text';\n            optionsValue = ko.utils.unwrapObservable(allBindings.get('optionsValue')) || 'value';\n            optionTitle = optionsText + 'title';\n\n            if (element.multiple) {\n                previousSelectedValues = ko.utils.arrayMap(\n                    selectedOptions(),//eslint-disable-line no-use-before-define\n                    ko.selectExtensions.readValue\n                );\n            } else {\n                previousSelectedValues = element.selectedIndex >= 0 ?\n                    [ko.selectExtensions.readValue(element.options[element.selectedIndex])] :\n                    [];\n            }\n\n            if (unwrappedArray) {\n                if (typeof unwrappedArray.length === 'undefined') { // Coerce single value into array\n                    unwrappedArray = [unwrappedArray];\n                }\n\n                // Filter out any entries marked as destroyed\n                filteredArray = ko.utils.arrayFilter(unwrappedArray, function (item) {\n                    if (item && !item.label) {\n                        return false;\n                    }\n\n                    return includeDestroyed ||\n                        item === undefined ||\n                        item === null ||\n                        !ko.utils.unwrapObservable(item._destroy);\n                });\n                filteredArray.map(recursivePathBuilder, null);//eslint-disable-line no-use-before-define\n            }\n\n            /**\n             * @param {*} option\n             */\n            arrayToDomNodeChildrenOptions.beforeRemove = function (option) {\n                element.removeChild(option);\n            };\n\n            if (allBindings.has('optionsAfterRender')) {\n\n                /**\n                 * @param {*} arrayEntry\n                 * @param {*} newOptions\n                 */\n                callback = function (arrayEntry, newOptions) {\n                    setSelectionCallback(arrayEntry, newOptions);//eslint-disable-line no-use-before-define\n                    ko.dependencyDetection.ignore(\n                        allBindings.get('optionsAfterRender'),\n                        null,\n                        [newOptions[0],\n                        arrayEntry !== captionPlaceholder ? arrayEntry : undefined]\n                    );\n                };\n            }\n\n            filteredArray = formatOptions(filteredArray);//eslint-disable-line no-use-before-define\n            ko.utils.setDomNodeChildrenFromArrayMapping(\n                element,\n                filteredArray,\n                optionNodeFromArray,//eslint-disable-line no-use-before-define\n                arrayToDomNodeChildrenOptions,\n                callback\n            );\n\n            ko.dependencyDetection.ignore(function () {\n                var selectionChanged;\n\n                if (allBindings.get('valueAllowUnset') && allBindings.has('value')) {\n                    // The model value is authoritative, so make sure its value is the one selected\n                    ko.selectExtensions.writeValue(\n                        element,\n                        ko.utils.unwrapObservable(allBindings.get('value')),\n                        true /* allowUnset */\n                    );\n                } else {\n                    // Determine if the selection has changed as a result of updating the options list\n                    if (element.multiple) {\n                        // For a multiple-select box, compare the new selection count to the previous one\n                        // But if nothing was selected before, the selection can't have changed\n                        selectionChanged = previousSelectedValues.length &&\n                            selectedOptions().length < //eslint-disable-line no-use-before-define\n                            previousSelectedValues.length;\n                    } else {\n                        // For a single-select box, compare the current value to the previous value\n                        // But if nothing was selected before or nothing is selected now,\n                        // just look for a change in selection\n                        selectionChanged = previousSelectedValues.length && element.selectedIndex >= 0 ?\n                            ko.selectExtensions.readValue(element.options[element.selectedIndex]) !==\n                            previousSelectedValues[0] : previousSelectedValues.length || element.selectedIndex >= 0;\n                    }\n\n                    // Ensure consistency between model value and selected option.\n                    // If the dropdown was changed so that selection is no longer the same,\n                    // notify the value or selectedOptions binding.\n                    if (selectionChanged) {\n                        ko.utils.triggerEvent(element, 'change');\n                    }\n                }\n            });\n\n            /*eslint-enable max-len, no-use-before-define*/\n\n            if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20) {\n                element.scrollTop = previousScrollTop;\n            }\n\n            /**\n             * @returns {*}\n             */\n            function selectedOptions() {\n                return ko.utils.arrayFilter(element.options, function (node) {\n                    return node.selected;\n                });\n            }\n\n            /**\n             * @param {*} object\n             * @param {*} predicate\n             * @param {*} defaultValue\n             * @returns {*}\n             */\n            function applyToObject(object, predicate, defaultValue) {\n                var predicateType = typeof predicate;\n\n                if (predicateType === 'function') {   // run it against the data value\n                    return predicate(object);\n                } else if (predicateType === 'string') { // treat it as a property name on the data value\n                    return object[predicate];\n                }\n\n                return defaultValue;\n            }\n\n            /**\n             * @param {*} obj\n             */\n            function recursivePathBuilder(obj) {\n\n                obj[optionTitle] = (this && this[optionTitle] ? this[optionTitle] + '/' : '') + obj[optionsText].trim();\n\n                if (Array.isArray(obj[optionsValue])) {\n                    obj[optionsValue].map(recursivePathBuilder, obj);\n                }\n            }\n\n            /**\n             * @param {Array} arrayEntry\n             * @param {*} oldOptions\n             * @returns {*[]}\n             */\n            function optionNodeFromArray(arrayEntry, oldOptions) {\n                var option;\n\n                if (oldOptions.length) {\n                    previousSelectedValues = oldOptions[0].selected ?\n                        [ko.selectExtensions.readValue(oldOptions[0])] : [];\n                    itemUpdate = true;\n                }\n\n                if (arrayEntry === captionPlaceholder) { // empty value, label === caption\n                    option = element.ownerDocument.createElement('option');\n                    ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                    ko.selectExtensions.writeValue(option, undefined);\n                } else if (typeof arrayEntry[optionsValue] === 'undefined') { // empty value === optgroup\n                    if (arrayEntry.__disableTmpl) {\n                        option = '<optgroup label=\"' + arrayEntry[optionsText] + '\"></optgroup>';\n                    } else {\n                        option = utils.template(optgroupTmpl, {\n                            label: arrayEntry[optionsText],\n                            title: arrayEntry[optionsText + 'title']\n                        });\n                    }\n                    option = ko.utils.parseHtmlFragment(option)[0];\n\n                } else {\n                    option = element.ownerDocument.createElement('option');\n                    option.setAttribute('data-title', arrayEntry[optionsText + 'title']);\n                    ko.selectExtensions.writeValue(option, arrayEntry[optionsValue]);\n                    ko.utils.setTextContent(option, arrayEntry[optionsText]);\n                }\n\n                return [option];\n            }\n\n            /**\n             * @param {*} newOptions\n             */\n            function setSelectionCallback(newOptions) {\n                var isSelected;\n\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                if (previousSelectedValues.length && newOptions.value) {\n                    isSelected = ko.utils.arrayIndexOf(\n                        previousSelectedValues,\n                        ko.selectExtensions.readValue(newOptions.value)\n                    ) >= 0;\n\n                    ko.utils.setOptionNodeSelectionState(newOptions.value, isSelected);\n\n                    // If this option was changed from being selected during a single-item update, notify the change\n                    if (itemUpdate && !isSelected) {\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, 'change']);\n                    }\n                }\n            }\n\n            /**\n             * @param {*} string\n             * @param {Number} times\n             * @returns {Array}\n             */\n            function strPad(string, times) {\n                return new Array(times + 1).join(string);\n            }\n\n            /**\n             * @param {*} options\n             * @returns {Array}\n             */\n            function formatOptions(options) {\n                var res = [];\n\n                nestedOptionsLevel++;\n\n                if (!nestedOptionsLevel) { // zero level\n                    // If caption is included, add it to the array\n                    if (allBindings.has('optionsCaption')) {\n                        captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                        // If caption value is null or undefined, don't show a caption\n                        if (//eslint-disable-line max-depth\n                            captionValue !== null &&\n                            captionValue !== undefined &&\n                            captionValue !== false\n                        ) {\n                            res.push(captionPlaceholder);\n                        }\n                    }\n                }\n\n                ko.utils.arrayForEach(options, function (option) {\n                    var value = applyToObject(option, optionsValue, option),\n                        label = applyToObject(option, optionsText, value) || '',\n                        disabled = applyToObject(option, 'disabled', false) || false,\n                        obj = {},\n                        space = '\\u2007\\u2007\\u2007';\n\n                    obj[optionTitle] = applyToObject(option, optionsText + 'title', value);\n\n                    if (disabled) {\n                        obj.disabled = disabled;\n                    }\n\n                    if (option.hasOwnProperty('__disableTmpl')) {\n                        obj.__disableTmpl = option.__disableTmpl;\n                    }\n\n                    label = label.replace(nbspRe, '').trim();\n\n                    if (Array.isArray(value)) {\n                        obj[optionsText] = strPad('&nbsp;', nestedOptionsLevel * 4) + label;\n                        res.push(obj);\n                        res = res.concat(formatOptions(value));\n                    } else {\n                        obj[optionsText] = strPad(space, nestedOptionsLevel * 2) + label;\n                        obj[optionsValue] = value;\n                        res.push(obj);\n                    }\n                });\n                nestedOptionsLevel--;\n\n                return res;\n            }\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/keyboard.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.keyboard = {\n\n        /**\n         * Attaches keypress handlers to element\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         * @param  {Object} allBindings - all bindings object\n         * @param  {Object} viewModel - reference to viewmodel\n         */\n        init: function (el, valueAccessor, allBindings, viewModel) {\n            var map = valueAccessor();\n\n            ko.utils.registerEventHandler(el, 'keyup', function (e) {\n                var callback = map[e.keyCode];\n\n                if (callback) {\n                    return callback.call(viewModel, e);\n                }\n            });\n        }\n    };\n\n    renderer.addAttribute('keyboard');\n});\n","Magento_Ui/js/lib/knockout/bindings/color-picker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer',\n    'spectrum',\n    'tinycolor'\n], function (ko, $, renderer, spectrum, tinycolor) {\n    'use strict';\n\n    /**\n     * Change color picker status to be enabled or disabled\n     *\n     * @param {HTMLElement} element - Element to apply colorpicker enable/disable status to.\n     * @param {Object} viewModel - Object, which represents view model binded to el.\n     */\n    function changeColorPickerStateBasedOnViewModel(element, viewModel) {\n        $(element).spectrum(viewModel.disabled() ? 'disable' : 'enable');\n    }\n\n    ko.bindingHandlers.colorPicker = {\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = valueAccessor(),\n\n                /** change value */\n                changeValue = function (value) {\n                    if (value == null) {\n                        value = '';\n                    }\n                    config.value(value.toString());\n                };\n\n            config.change = changeValue;\n\n            config.hide = changeValue;\n\n            /** show value */\n            config.show = function () {\n                if (!viewModel.focused()) {\n                    viewModel.focused(true);\n                }\n\n                return true;\n            };\n\n            $(element).spectrum(config);\n\n            changeColorPickerStateBasedOnViewModel(element, viewModel);\n        },\n\n        /**\n         * Reads params passed to binding, parses component declarations.\n         * Fetches for those found and attaches them to the new context.\n         *\n         * @param {HTMLElement} element - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to element.\n         */\n        update: function (element, valueAccessor, allBindings, viewModel) {\n            var config = valueAccessor();\n\n            /** Initialise value as empty if it is undefined when color picker input is reset **/\n            if (config.value() === undefined) {\n                config.value('');\n            }\n\n            if (tinycolor(config.value()).isValid() || config.value() === '') {\n                $(element).spectrum('set', config.value());\n\n                if (config.value() !== '') {\n                    config.value($(element).spectrum('get').toString());\n                }\n            }\n\n            changeColorPickerStateBasedOnViewModel(element, viewModel);\n        }\n    };\n\n    renderer.addAttribute('colorPicker');\n});\n","Magento_Ui/js/lib/knockout/bindings/autoselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer'\n], function (ko, $, renderer) {\n    'use strict';\n\n    /**\n     * 'Focus' event handler.\n     *\n     * @param {EventObject} e\n     */\n    function onFocus(e) {\n        e.target.select();\n    }\n\n    ko.bindingHandlers.autoselect = {\n\n        /**\n         * Adds event handler which automatically\n         * selects inputs' element text when field gets focused.\n         */\n        init: function (element, valueAccessor) {\n            var enabled = ko.unwrap(valueAccessor());\n\n            if (enabled !== false) {\n                $(element).on('focus', onFocus);\n            }\n        }\n    };\n\n    renderer.addAttribute('autoselect');\n});\n","Magento_Ui/js/lib/knockout/bindings/i18n.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'module',\n    '../template/renderer',\n    'mage/translate'\n], function ($, ko, module, renderer) {\n    'use strict';\n\n    var locations = {\n            'legend': 'Caption for the fieldset element',\n            'label': 'Label for an input element.',\n            'button': 'Push button',\n            'a': 'Link label',\n            'b': 'Bold text',\n            'strong': 'Strong emphasized text',\n            'i': 'Italic text',\n            'em': 'Emphasized text',\n            'u': 'Underlined text',\n            'sup': 'Superscript text',\n            'sub': 'Subscript text',\n            'span': 'Span element',\n            'small': 'Smaller text',\n            'big': 'Bigger text',\n            'address': 'Contact information',\n            'blockquote': 'Long quotation',\n            'q': 'Short quotation',\n            'cite': 'Citation',\n            'caption': 'Table caption',\n            'abbr': 'Abbreviated phrase',\n            'acronym': 'An acronym',\n            'var': 'Variable part of a text',\n            'dfn': 'Term',\n            'strike': 'Strikethrough text',\n            'del': 'Deleted text',\n            'ins': 'Inserted text',\n            'h1': 'Heading level 1',\n            'h2': 'Heading level 2',\n            'h3': 'Heading level 3',\n            'h4': 'Heading level 4',\n            'h5': 'Heading level 5',\n            'h6': 'Heading level 6',\n            'center': 'Centered text',\n            'select': 'List options',\n            'img': 'Image',\n            'input': 'Form element'\n        },\n\n        /**\n         * Generates [data-translate] attribute's value\n         * @param {Object} translationData\n         * @param {String} location\n         */\n        composeTranslateAttr = function (translationData, location) {\n            var obj = [{\n                'shown': translationData.shown,\n                'translated': translationData.translated,\n                'original': translationData.original,\n                'location': locations[location] || 'Text'\n            }];\n\n            return JSON.stringify(obj);\n        },\n\n        /**\n         * Sets text for the element\n         * @param {Object} el\n         * @param {String} text\n         */\n        setText = function (el, text) {\n            $(el).text(text);\n        },\n\n        /**\n         * Sets [data-translate] attribute for the element\n         * @param {Object} el - The element which is binded\n         * @param {String} original - The original value of the element\n         */\n        setTranslateProp = function (el, original) {\n            var location = $(el).prop('tagName').toLowerCase(),\n                translated = $.mage.__(original),\n                translationData = {\n                    shown: translated,\n                    translated: translated,\n                    original: original\n                },\n                translateAttr = composeTranslateAttr(translationData, location);\n\n            $(el).attr('data-translate', translateAttr);\n\n            setText(el, translationData.shown);\n        },\n\n        /**\n         * Checks if node represents ko virtual node (nodeType === 8, nodeName === '#comment').\n         *\n         * @param {HTMLElement} node\n         * @returns {Boolean}\n         */\n        isVirtualElement = function (node) {\n            return node.nodeType === 8;\n        },\n\n        /**\n        * Checks if it's real DOM element\n        * in case of virtual element, returns span wrapper\n        * @param {Object} el\n        * @param {bool} isUpdate\n        * @return {Object} el\n        */\n        getRealElement = function (el, isUpdate) {\n            if (isVirtualElement(el)) {\n                if (isUpdate) {\n                    return $(el).next('span');\n                }\n\n                return $('<span></span>').insertAfter(el);\n            }\n\n            return el;\n        },\n\n        /**\n         * execute i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         * @param {bool} isUpdate\n         */\n        execute = function (element, valueAccessor, isUpdate) {\n            var original = ko.unwrap(valueAccessor() || ''),\n                el = getRealElement(element, isUpdate),\n                inlineTranslation = (module.config() || {}).inlineTranslation;\n\n            if (inlineTranslation) {\n                setTranslateProp(el, original);\n            } else {\n                setText(el, $.mage.__(original));\n            }\n        };\n\n    /**\n     * i18n binding\n     * @property {Function}  init\n     * @property {Function}  update\n     */\n    ko.bindingHandlers.i18n = {\n\n        /**\n         * init i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            execute(element, valueAccessor);\n        },\n\n        /**\n         * update i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            execute(element, valueAccessor, true);\n        }\n    };\n\n    ko.virtualElements.allowedBindings.i18n = true;\n\n    renderer\n        .addNode('translate', {\n            binding: 'i18n'\n        })\n        .addAttribute('translate', {\n            binding: 'i18n'\n        });\n});\n","Magento_Ui/js/lib/knockout/bindings/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var collapsible,\n        defaults;\n\n    defaults = {\n        closeOnOuter: true,\n        onTarget: false,\n        openClass: '_active',\n        as: '$collapsible'\n    };\n\n    collapsible = {\n\n        /**\n         * Sets 'opened' property to true.\n         */\n        open: function () {\n            this.opened(true);\n        },\n\n        /**\n         * Sets 'opened' property to false.\n         */\n        close: function () {\n            this.opened(false);\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         */\n        toggle: function () {\n            this.opened(!this.opened());\n        }\n    };\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element, closes collapsible model.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} model\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, model, e) {\n        var target = e.target;\n\n        if (target !== container && !container.contains(target)) {\n            model.close();\n        }\n    }\n\n    /**\n     * Creates 'css' binding which toggles\n     * class specified in 'name' parameter.\n     *\n     * @param {Object} model\n     * @param {String} name\n     * @returns {Object}\n     */\n    function getClassBinding(model, name) {\n        var binding = {};\n\n        binding[name] = model.opened;\n\n        return {\n            css: binding\n        };\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {Object} [options={}]\n     * @returns {Object} Complete instance configuration.\n     */\n    function buildConfig(options) {\n        if (typeof options !== 'object') {\n            options = {};\n        }\n\n        return _.extend({}, defaults, options);\n    }\n\n    ko.bindingHandlers.collapsible = {\n\n        /**\n         * Initializes 'collapsible' binding.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var $collapsible = Object.create(collapsible),\n                config = buildConfig(valueAccessor()),\n                outerClick,\n                bindings;\n\n            _.bindAll($collapsible, 'open', 'close', 'toggle');\n\n            $collapsible.opened = ko.observable(!!config.opened);\n\n            bindingCtx[config.as] = $collapsible;\n\n            if (config.closeOnOuter) {\n                outerClick = onOuterClick.bind(null, element, $collapsible);\n\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n\n            if (config.openClass) {\n                bindings = getClassBinding($collapsible, config.openClass);\n\n                ko.applyBindingsToNode(element, bindings, bindingCtx);\n            }\n\n            if (config.onTarget) {\n                $(element).on('click', $collapsible.toggle);\n            }\n\n            if (viewModel && _.isFunction(viewModel.on)) {\n                viewModel.on({\n                    close:          $collapsible.close,\n                    open:           $collapsible.open,\n                    toggleOpened:   $collapsible.toggle\n                });\n            }\n        }\n    };\n\n    ko.bindingHandlers.closeCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which closes associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.close);\n            }\n        }\n    };\n\n    ko.bindingHandlers.openCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which opens associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.open);\n            }\n        }\n    };\n\n    ko.bindingHandlers.toggleCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which toggles associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.toggle);\n            }\n        }\n    };\n\n    renderer\n        .addAttribute('collapsible')\n        .addAttribute('openCollapsible')\n        .addAttribute('closeCollapsible')\n        .addAttribute('toggleCollapsible');\n});\n","Magento_Ui/js/lib/knockout/bindings/after-render.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.afterRender = {\n\n        /**\n         * Binding init callback.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var callback = valueAccessor();\n\n            if (typeof callback === 'function') {\n                callback.call(viewModel, element, viewModel);\n            }\n        }\n    };\n\n    renderer.addAttribute('afterRender');\n});\n","Magento_Ui/js/lib/knockout/bindings/resizable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, async, registry, _, renderer) {\n    'use strict';\n\n    var sizeOptions = [\n            'minHeight',\n            'maxHeight',\n            'minWidth',\n            'maxWidth'\n        ],\n\n        handles = {\n            height: '.ui-resizable-s, .ui-resizable-n',\n            width: '.ui-resizable-w, .ui-resizable-e'\n        };\n\n    /**\n     * Recalcs visibility of handles, width and height of resizable based on content\n     * @param {HTMLElement} element\n     */\n    function adjustSize(element) {\n        var maxHeight,\n            maxWidth;\n\n        element = $(element);\n        maxHeight = element.resizable('option').maxHeight;\n        maxWidth = element.resizable('option').maxWidth;\n\n        if (maxHeight && element.height() > maxHeight) {\n            element.height(maxHeight + 1);\n            $(handles.height).hide();\n        } else {\n            $(handles.height).show();\n        }\n\n        if (maxWidth && element.width() > maxWidth) {\n            element.width(maxWidth + 1);\n            $(handles.width).hide();\n        } else {\n            $(handles.width).show();\n        }\n    }\n\n    /**\n     * Recalcs allowed min, max width and height based on configured selectors\n     * @param {Object} sizeConstraints\n     * @param {String} componentName\n     * @param {HTMLElement} element\n     * @param {Boolean} hasWidthUpdate\n     */\n    function recalcAllowedSize(sizeConstraints, componentName, element, hasWidthUpdate) {\n        var size;\n\n        element = $(element);\n\n        if (!element.data('resizable')) {\n            return;\n        }\n\n        if (!hasWidthUpdate) {\n            element.css('width', 'auto');\n        }\n\n        _.each(sizeConstraints, function (selector, key) {\n            async.async({\n                component: componentName,\n                selector: selector\n            }, function (elem) {\n                size = key.indexOf('Height') !== -1 ? $(elem).outerHeight(true) : $(elem).outerWidth(true);\n\n                if (element.data('resizable')) {\n                    element.resizable('option', key, size + 1);\n                }\n            });\n        }, this);\n\n        adjustSize(element);\n    }\n\n    /**\n     * Preprocess config to separate options,\n     * which must be processed further before applying\n     *\n     * @param {Object} config\n     * @param {Object} viewModel\n     * @param {*} element\n     * @return {Object} config\n     */\n    function processConfig(config, viewModel, element) {\n        var sizeConstraint,\n            sizeConstraints = {},\n            recalc,\n            hasWidthUpdate;\n\n        if (_.isEmpty(config)) {\n            return {};\n        }\n        _.each(sizeOptions, function (key) {\n            sizeConstraint = config[key];\n\n            if (sizeConstraint && !_.isNumber(sizeConstraint)) {\n                sizeConstraints[key] = sizeConstraint;\n                delete config[key];\n            }\n        });\n        hasWidthUpdate =  _.some(sizeConstraints, function (value, key) {\n            return key.indexOf('Width') !== -1;\n        });\n\n        recalc = recalcAllowedSize.bind(null, sizeConstraints, viewModel.name, element, hasWidthUpdate);\n        config.start = recalc;\n        $(window).on('resize.resizable', recalc);\n        registry.get(viewModel.provider).on('reloaded', recalc);\n\n        return config;\n    }\n\n    ko.bindingHandlers.resizable = {\n\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = processConfig(valueAccessor(), viewModel, element);\n\n            require(['jquery-ui-modules/resizable'], function () {\n                if ($.fn.resizable) {\n                    $(element).resizable(config);\n                }\n            });\n        }\n    };\n\n    renderer.addAttribute('resizable');\n});\n","Magento_Ui/js/lib/knockout/bindings/datepicker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates datepicker binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (ko, _, $, $t) {\n    'use strict';\n\n    var defaults = {\n        dateFormat: 'mm\\/dd\\/yyyy',\n        showsTime: false,\n        timeFormat: null,\n        buttonImage: null,\n        buttonImageOnly: null,\n        buttonText: $t('Select Date')\n    };\n\n    ko.bindingHandlers.datepicker = {\n        /**\n         * Initializes calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * For more info about options take a look at \"mage/calendar\" and jquery.ui.datepicker widget.\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         * @param {object} allBindings\n         * @param {object} viewModel\n         * @param {object} bindingContext\n         */\n        init: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            var config = valueAccessor(),\n                observable,\n                options = {};\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            require(['mage/calendar'], function () {\n                $(el).calendar(options);\n\n                ko.utils.registerEventHandler(el, 'change', function () {\n                    observable(this.value);\n                });\n            });\n\n            if (bindingContext.$data) {\n                bindingContext.$data.value.subscribe(function (newVal) {\n                    if (!newVal) {\n                        $(el).val('');\n                    }\n                }, this);\n            }\n\n\n        },\n\n        /**\n         * Update calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * @param {HTMLElement} element - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         */\n        update: function (element, valueAccessor) {\n            var config = valueAccessor(),\n                $element = $(element),\n                observable,\n                options = {},\n                newVal;\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            require(['moment', 'mage/utils/misc', 'mage/calendar'], function (moment, utils) {\n                if (_.isEmpty(observable())) {\n                    newVal = null;\n                } else {\n                    newVal = moment(\n                        observable(),\n                        utils.convertToMomentFormat(\n                            options.dateFormat + (options.showsTime ? ' ' + options.timeFormat : '')\n                        )\n                    ).toDate();\n                }\n\n                if (!options.timeOnly) {\n                    $element.datepicker('setDate', newVal);\n                    $element.trigger('blur');\n                }\n            });\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/extender/bound-nodes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/utils/wrapper',\n    'uiEvents'\n], function (ko, _, wrapper, Events) {\n    'use strict';\n\n    var nodesMap = new WeakMap();\n\n    /**\n     * Returns a array of nodes associated with a specified model.\n     *\n     * @param {Object} model\n     * @returns {Undefined|Array}\n     */\n    function getBounded(model) {\n        return nodesMap.get(model);\n    }\n\n    /**\n     * Removes specified node to models' associations list, if it's\n     * a root node (node is not a descendant of any previously added nodes).\n     * Triggers 'addNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function addBounded(model, node) {\n        var nodes = getBounded(model),\n            isRoot;\n\n        if (!nodes) {\n            nodesMap.set(model, [node]);\n\n            Events.trigger.call(model, 'addNode', node);\n\n            return;\n        }\n\n        isRoot = nodes.every(function (bounded) {\n            return !bounded.contains(node);\n        });\n\n        if (isRoot) {\n            nodes.push(node);\n\n            Events.trigger.call(model, 'addNode', node);\n        }\n    }\n\n    /**\n     * Removes specified node from models' associations list.\n     * Triggers 'removeNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function removeBounded(model, node) {\n        var nodes = getBounded(model),\n            index;\n\n        if (!nodes) {\n            return;\n        }\n\n        index = nodes.indexOf(node);\n\n        if (~index) {\n            nodes.splice(index, 0);\n\n            Events.trigger.call(model, 'removeNode', node);\n        }\n\n        if (!nodes.length) {\n            nodesMap.delete(model);\n        }\n    }\n\n    /**\n     * Returns node's first sibling of 'element' type within the common component scope\n     *\n     * @param {HTMLElement} node\n     * @param {*} data\n     * @returns {HTMLElement}\n     */\n    function getElement(node, data) {\n        var elem;\n\n        while (node.nextElementSibling) {\n            node = node.nextElementSibling;\n\n            if (node.nodeType === 1 && ko.dataFor(node) === data) {\n                elem = node;\n                break;\n            }\n        }\n\n        return elem;\n    }\n\n    wrapper.extend(ko, {\n\n        /**\n         * Extends knockouts' 'applyBindings'\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'applyBindings' method.\n         * @param {Object} ctx\n         * @param {HTMLElement} node - Original 'applyBindings' method.\n         */\n        applyBindings: function (orig, ctx, node) {\n            var result = orig(),\n                data = ctx && (ctx.$data || ctx);\n\n            if (node && node.nodeType === 8) {\n                node = getElement(node, data);\n            }\n\n            if (!node || node.nodeType !== 1) {\n                return result;\n            }\n\n            if (data && data.registerNodes) {\n                addBounded(data, node);\n            }\n\n            return result;\n        },\n\n        /**\n         * Extends knockouts' cleanNode\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'cleanNode' method.\n         * @param {HTMLElement} node - Original 'cleanNode' method.\n         */\n        cleanNode: function (orig, node) {\n            var result = orig(),\n                data;\n\n            if (node.nodeType !== 1) {\n                return result;\n            }\n\n            data = ko.dataFor(node);\n\n            if (data && data.registerNodes) {\n                removeBounded(data, node);\n            }\n\n            return result;\n        }\n    });\n\n    return {\n\n        /**\n         * Returns root nodes associated with a model. If callback is provided,\n         * will iterate through all of the present nodes triggering callback\n         * for each of it. Also it will subscribe to the 'addNode' event.\n         *\n         * @param {Object} model\n         * @param {Function} [callback]\n         * @returns {Array|Undefined}\n         */\n        get: function (model, callback) {\n            var nodes = getBounded(model) || [];\n\n            if (!_.isFunction(callback)) {\n                return nodes;\n            }\n\n            nodes.forEach(function (node) {\n                callback(node);\n            });\n\n            this.add.apply(this, arguments);\n        },\n\n        /**\n         * Subscribes to adding of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        add: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('addNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Subscribes to removal of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        remove: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('removeNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Removes subscriptions from the model.\n         *\n         * @param {Object} model\n         */\n        off: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            Events.off.apply(model, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/extender/observable_array.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Iterator function.\n     *\n     * @param {String} callback\n     * @param {Array} args\n     * @param {Object} elem\n     * @returns {*}\n     */\n    function iterator(callback, args, elem) {\n        callback = elem[callback];\n\n        if (_.isFunction(callback)) {\n            return callback.apply(elem, args);\n        }\n\n        return callback;\n    }\n\n    /**\n     * Wrapper function.\n     *\n     * @param {String} method\n     * @returns {Function}\n     */\n    function wrapper(method) {\n        return function (iteratee) {\n            var callback = iteratee,\n                elems = this(),\n                args = _.toArray(arguments);\n\n            if (_.isString(iteratee)) {\n                callback = iterator.bind(null, iteratee, args.slice(1));\n\n                args.unshift(callback);\n            }\n\n            args.unshift(elems);\n\n            return _[method].apply(_, args);\n        };\n    }\n\n    _.extend(ko.observableArray.fn, {\n        each: wrapper('each'),\n\n        map: wrapper('map'),\n\n        filter: wrapper('filter'),\n\n        some: wrapper('some'),\n\n        every: wrapper('every'),\n\n        groupBy: wrapper('groupBy'),\n\n        sortBy: wrapper('sortBy'),\n\n        /**\n         * Wrapper for underscore findWhere function.\n         *\n         * @param {Object} properties\n         * @return {Object}\n         */\n        findWhere: function (properties) {\n            return _.findWhere(this(), properties);\n        },\n\n        /**\n         * Wrapper for underscore contains function.\n         *\n         * @param {*} value\n         * @return {Boolean}\n         */\n        contains: function (value) {\n            return _.contains(this(), value);\n        },\n\n        /**\n         * Inverse contains call.\n         *\n         * @return {Boolean}\n         */\n        hasNo: function () {\n            return !this.contains.apply(this, arguments);\n        },\n\n        /**\n         * Getter for length property.\n         *\n         * @return {Number}\n         */\n        getLength: function () {\n            return this().length;\n        },\n\n        /**\n         * Create object with keys that gets from each object property.\n         *\n         * @return {Object}\n         */\n        indexBy: function (key) {\n            return _.indexBy(this(), key);\n        },\n\n        /**\n         * Returns a copy of the array with all instances of the values removed.\n         *\n         * @return {Array}\n         */\n        without: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.without.apply(_, args);\n        },\n\n        /**\n         * Returns the first element of an array.\n         *\n         * @return {*}\n         */\n        first: function () {\n            return _.first(this());\n        },\n\n        /**\n         * Returns the last element of an array\n         *\n         * @return {*}\n         */\n        last: function () {\n            return _.last(this());\n        },\n\n        /**\n         * Iterate and pick provided properties.\n         *\n         * @return {Array}\n         */\n        pluck: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.pluck.apply(_, args);\n        }\n    });\n});\n","Magento_Ui/js/lib/validation/utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(function () {\n    'use strict';\n\n    var utils = {\n        /**\n         * Check if string is empty with trim.\n         *\n         * @param {String} value\n         * @return {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || value == null || value.length === 0 || /^\\s+$/.test(value);\n        },\n\n        /**\n         * Check if string is empty no trim.\n         *\n         * @param {String} value\n         * @return {Boolean}\n         */\n        isEmptyNoTrim: function (value) {\n            return value === '' || value == null || value.length === 0;\n        },\n\n        /**\n         * Checks if {value} is between numbers {from} and {to}.\n         *\n         * @param {String} value\n         * @param {String} from\n         * @param {String} to\n         * @return {Boolean}\n         */\n        isBetween: function (value, from, to) {\n            return (from === null || from === '' || value >= utils.parseNumber(from)) &&\n                   (to === null || to === '' || value <= utils.parseNumber(to));\n        },\n\n        /**\n         * Parse price string.\n         *\n         * @param {String} value\n         * @return {Number}\n         */\n        parseNumber: function (value) {\n            var isDot, isComa;\n\n            if (typeof value !== 'string') {\n                return parseFloat(value);\n            }\n            isDot = value.indexOf('.');\n            isComa = value.indexOf(',');\n\n            if (isDot !== -1 && isComa !== -1) {\n                if (isComa > isDot) {\n                    value = value.replace('.', '').replace(',', '.');\n                } else {\n                    value = value.replace(',', '');\n                }\n            } else if (isComa !== -1) {\n                value = value.replace(',', '.');\n            }\n\n            return parseFloat(value);\n        },\n\n        /**\n         * Removes HTML tags and space characters, numbers and punctuation.\n         *\n         * @param {String} value -  Value being stripped.\n         * @return {String}\n         */\n        stripHtml: function (value) {\n            return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n        }\n    };\n\n    return utils;\n});\n","Magento_Ui/js/lib/validation/validator.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './rules'\n], function (_, rulesList) {\n    'use strict';\n\n    /**\n     * Validates provided value be the specified rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {*} value - Value to be checked.\n     * @param {*} [params]\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validate(id, value, params, additionalParams) {\n        var rule,\n            message,\n            valid,\n            result = {\n                rule: id,\n                passed: true,\n                message: ''\n            };\n\n        if (_.isObject(params)) {\n            message = params.message || '';\n        }\n\n        if (!rulesList[id]) {\n            return result;\n        }\n\n        rule    = rulesList[id];\n        message = message || rule.message;\n        valid   = rule.handler(value, params, additionalParams);\n\n        if (!valid) {\n            params = Array.isArray(params) ?\n                params :\n                [params];\n\n            if (typeof message === 'function') {\n                message = message.call(rule);\n            }\n\n            message = params.reduce(function (msg, param, idx) {\n                return msg.replace(new RegExp('\\\\{' + idx + '\\\\}', 'g'), param);\n            }, message);\n\n            result.passed = false;\n            result.message = message;\n        }\n\n        return result;\n    }\n\n    /**\n     * Validates provided value by a specified set of rules.\n     *\n     * @param {(String|Object)} rules - One or many validation rules.\n     * @param {*} value - Value to be checked.\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validator(rules, value, additionalParams) {\n        var result;\n\n        if (typeof rules === 'object') {\n            result = {\n                passed: true\n            };\n\n            _.every(rules, function (ruleParams, id) {\n                if (ruleParams.validate || ruleParams !== false || additionalParams) {\n                    result = validate(id, value, ruleParams, additionalParams);\n\n                    return result.passed;\n                }\n\n                return true;\n            });\n\n            return result;\n        }\n\n        return validate.apply(null, arguments);\n    }\n\n    /**\n     * Adds new validation rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {Function} handler - Validation function.\n     * @param {String} message - Error message.\n     */\n    validator.addRule = function (id, handler, message) {\n        rulesList[id] = {\n            handler: handler,\n            message: message\n        };\n    };\n\n    /**\n     * Returns rule object found by provided identifier.\n     *\n     * @param {String} id - Rule identifier.\n     * @returns {Object}\n     */\n    validator.getRule = function (id) {\n        return rulesList[id];\n    };\n\n    return validator;\n});\n","Magento_Ui/js/lib/validation/rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    './utils',\n    'moment',\n    'tinycolor',\n    'jquery/validate',\n    'mage/translate'\n], function ($, _, utils, moment, tinycolor) {\n    'use strict';\n\n    /**\n     * validate credit card number using mod10\n     * @param {String} s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = '0123456789',\n            w = '',\n            i, j, k, m, c, a, x;\n\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n\n            if (v.indexOf(x, 0) !== -1) {\n                w += x;\n            }\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n\n        return c % 10 === 0;\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    return _.mapObject({\n        'min_text_length': [\n            function (value, params) {\n                return _.isUndefined(value) || value.length === 0 || value.length >= +params;\n            },\n            $.mage.__('Please enter more or equal than {0} symbols.')\n        ],\n        'max_text_length': [\n            function (value, params) {\n                return !_.isUndefined(value) && value.length <= +params;\n            },\n            $.mage.__('Please enter less or equal than {0} symbols.')\n        ],\n        'max-words': [\n            function (value, params) {\n                return utils.isEmpty(value) || utils.stripHtml(value).match(/\\b\\w+\\b/g).length < params;\n            },\n            $.mage.__('Please enter {0} words or less.')\n        ],\n        'min-words': [\n            function (value, params) {\n                return utils.isEmpty(value) || utils.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            $.mage.__('Please enter at least {0} words.')\n        ],\n        'range-words': [\n            function (value, params) {\n                var match = utils.stripHtml(value).match(/\\b\\w+\\b/g) || [];\n\n                return utils.isEmpty(value) || match.length >= params[0] &&\n                    match.length <= params[1];\n            },\n            $.mage.__('Please enter between {0} and {1} words.')\n        ],\n        'letters-with-basic-punc': [\n            function (value) {\n                return utils.isEmpty(value) || /^[a-z\\-.,()\\u0027\\u0022\\s]+$/i.test(value);\n            },\n            $.mage.__('Letters or punctuation only please')\n        ],\n        'alphanumeric': [\n            function (value) {\n                return utils.isEmpty(value) || /^\\w+$/i.test(value);\n            },\n            $.mage.__('Letters, numbers, spaces or underscores only please')\n        ],\n        'letters-only': [\n            function (value) {\n                return utils.isEmpty(value) || /^[a-z]+$/i.test(value);\n            },\n            $.mage.__('Letters only please')\n        ],\n        'no-whitespace': [\n            function (value) {\n                return utils.isEmpty(value) || /^\\S+$/i.test(value);\n            },\n            $.mage.__('No white space please')\n        ],\n        'no-marginal-whitespace': [\n            function (value) {\n                return !/^\\s+|\\s+$/i.test(value);\n            },\n            $.mage.__('No marginal white space please')\n        ],\n        'zip-range': [\n            function (value) {\n                return utils.isEmpty(value) || /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            $.mage.__('Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx')\n        ],\n        'integer': [\n            function (value) {\n                return utils.isEmpty(value) || /^-?\\d+$/.test(value);\n            },\n            $.mage.__('A positive or negative non-decimal number please')\n        ],\n        'vinUS': [\n            function (value) {\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n\n                if (value.length !== 17) {\n                    return false;\n                }\n                var i, n, d, f, cd, cdv,//eslint-disable-line vars-on-top\n                    LL = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],//eslint-disable-line max-len\n                    VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9],\n                    FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2],\n                    rs = 0;\n\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = value.slice(i, i + 1);\n\n                    if (i === 8) {\n                        cdv = d;\n                    }\n\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {//eslint-disable-line max-depth\n                            if (d.toUpperCase() === LL[n]) {//eslint-disable-line max-depth\n                                d = VL[n];\n                                d *= f;\n\n                                if (isNaN(cdv) && n === 8) {//eslint-disable-line max-depth\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n                cd = rs % 11;\n\n                if (cd === 10) {\n                    cd = 'X';\n                }\n\n                if (cd === cdv) {\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('The specified vehicle identification number (VIN) is invalid.')\n        ],\n        'dateITA': [\n            function (value) {\n                var check = false,\n                    re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/,\n                    adata, gg, mm, aaaa, xdata;\n\n                if (re.test(value)) {\n                    adata = value.split('/');\n                    gg = parseInt(adata[0], 10);\n                    mm = parseInt(adata[1], 10);\n                    aaaa = parseInt(adata[2], 10);\n                    xdata = new Date(aaaa, mm - 1, gg);\n\n                    if (xdata.getFullYear() === aaaa &&\n                        xdata.getMonth() === mm - 1 &&\n                        xdata.getDate() === gg\n                    ) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n\n                return check;\n            },\n            $.mage.__('Please enter a correct date')\n        ],\n        'dateNL': [\n            function (value) {\n                return /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            $.mage.__('Vul hier een geldige datum in.')\n        ],\n        'time': [\n            function (value) {\n                return utils.isEmpty(value) || /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 and 23:59')\n        ],\n        'time12h': [\n            function (value) {\n                return utils.isEmpty(value) || /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\s[AP]M))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 am and 12:00 pm')\n        ],\n        'phoneUS': [\n            function (value) {\n                value = value.replace(/\\s+/g, '');\n\n                return utils.isEmpty(value) || value.length > 9 &&\n                    value.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'phoneUK': [\n            function (value) {\n                return utils.isEmpty(value) || value.length > 9 &&\n                    value.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'mobileUK': [\n            function (value) {\n                return utils.isEmpty(value) || value.length > 9 && value.match(/^((0|\\+44)7\\d{3}\\s?\\d{6})$/);\n            },\n            $.mage.__('Please specify a valid mobile number')\n        ],\n        'stripped-min-length': [\n            function (value, param) {\n                return _.isUndefined(value) || value.length === 0 || utils.stripHtml(value).length >= param;\n            },\n            $.mage.__('Please enter at least {0} characters')\n        ],\n        'email2': [\n            function (value) {\n                return utils.isEmpty(value) || /^((([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\u0022)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\u0022)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);//eslint-disable-line max-len\n            },\n            $.validator.messages.email\n        ],\n        'url2': [\n            function (value) {\n                return utils.isEmpty(value) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);//eslint-disable-line max-len\n            },\n            $.validator.messages.url\n        ],\n        'credit-card-types': [\n            function (value, param) {\n                var validTypes;\n\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, '');\n                validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'ipv4': [\n            function (value) {\n                return utils.isEmpty(value) || /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid IP v4 address.')\n        ],\n        'ipv6': [\n            function (value) {\n                return utils.isEmpty(value) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid IP v6 address.')\n        ],\n        'pattern': [\n            function (value, param) {\n                return utils.isEmpty(value) || new RegExp(param).test(value);\n            },\n            $.mage.__('Invalid format.')\n        ],\n        'validate-no-html-tags': [\n            function (value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            $.mage.__('HTML tags are not allowed.')\n        ],\n        'validate-select': [\n            function (value) {\n                return value !== 'none' && value != null && value.length !== 0;\n            },\n            $.mage.__('Please select an option.')\n        ],\n        'validate-no-empty': [\n            function (value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('Empty Value.')\n        ],\n        'validate-alphanum-with-spaces': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9 ]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.')\n        ],\n        'validate-data': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')//eslint-disable-line max-len\n        ],\n        'validate-street': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.')\n        ],\n        'validate-phoneStrict': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-phoneLax': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-fax': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid fax number (Ex: 123-456-7890).')\n        ],\n        'validate-email': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-emailSender': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[\\S ]+$/.test(value);\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-password': [\n            function (value) {\n                var pass;\n\n                if (value == null) {\n                    return false;\n                }\n\n                pass = value.trim();\n\n                if (!pass.length) {\n                    return true;\n                }\n\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-admin-password': [\n            function (value) {\n                var pass;\n\n                if (value == null) {\n                    return false;\n                }\n\n                pass = value.trim();\n\n                if (pass.length === 0) {\n                    return true;\n                }\n\n                if (!/[a-z]/i.test(value) || !/[0-9]/.test(value)) {\n                    return false;\n                }\n\n                if (pass.length < 7) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 7 or more characters, using both numeric and alphabetic.')\n        ],\n        'validate-customer-password': [\n            function (v, elm) {\n                var validator = this,\n                    counter = 0,\n                    passwordMinLength = $(elm).data('password-min-length'),\n                    passwordMinCharacterSets = $(elm).data('password-min-character-sets'),\n                    pass = v.trim(),\n                    result = pass.length >= passwordMinLength;\n\n                if (result === false) {\n                    validator.passwordErrorMessage = $.mage.__('Minimum length of this field must be equal or greater than %1 symbols. Leading and trailing spaces will be ignored.').replace('%1', passwordMinLength);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                if (pass.match(/\\d+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[a-z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[A-Z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter++;\n                }\n\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__('Minimum of different classes of characters in password is %1. Classes of characters: Lower Case, Upper Case, Digits, Special Characters.').replace('%1', passwordMinCharacterSets);//eslint-disable-line max-len\n                }\n\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        'validate-url': [\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = (value || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. Protocol is required (http://, https:// or ftp://).')\n        ],\n        'validate-clean-url': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. For example http://www.example.com or www.example.com.')\n        ],\n        'validate-xml-identifier': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(value);\n\n            },\n            $.mage.__('Please enter a valid XML-identifier (Ex: something_1, block5, id-4).')\n        ],\n        'validate-ssn': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(value);\n\n            },\n            $.mage.__('Please enter a valid social security number (Ex: 123-45-6789).')\n        ],\n        'validate-zip-us': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(value);\n\n            },\n            $.mage.__('Please enter a valid zip code (Ex: 90602 or 90602-1234).')\n        ],\n        'validate-date-au': [\n            function (value) {\n                var regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/,\n                    d;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                if (utils.isEmpty(value) || !regex.test(value)) {\n                    return false;\n                }\n                d = new Date(value.replace(regex, '$2/$1/$3'));\n\n                return parseInt(RegExp.$2, 10) === 1 + d.getMonth() &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            $.mage.__('Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.')\n        ],\n        'validate-currency-dollar': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid $ amount. For example $100.00.')\n        ],\n        'validate-not-negative-number': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value >= 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n\n            },\n            $.mage.__('Please enter a number 0 or greater, without comma in this field.')\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        'validate-zero-or-greater': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value >= 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n            },\n            $.mage.__('Please enter a number 0 or greater, without comma in this field.')\n        ],\n        'validate-greater-than-zero': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value > 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n            },\n            $.mage.__('Please enter a number greater than 0, without comma in this field.')\n        ],\n        'validate-css-length': [\n            function (value) {\n                if (value !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).')\n        ],\n        'validate-number': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    !isNaN(utils.parseNumber(value)) &&\n                    /^\\s*-?\\d*(?:[.,|'|\\s]\\d+)*(?:[.,|'|\\s]\\d{2})?-?\\s*$/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-integer': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value)) && /^\\s*-?\\d*\\s*$/.test(value);\n            },\n            $.mage.__('Please enter a valid integer in this field.')\n        ],\n        'validate-number-range': [\n            function (value, param) {\n                var numValue, dataAttrRange, result, range, m;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/;\n                result = true;\n                range = param;\n\n                if (range) {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-positive-percent-decimal': [\n            function (value) {\n                var numValue;\n\n                if (utils.isEmptyNoTrim(value) || !/^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(value)) {\n                    return false;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                return utils.isBetween(numValue, 0.01, 100);\n            },\n            $.mage.__('Please enter a valid percentage discount value greater than 0.')\n        ],\n        'validate-digits': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !/[^\\d]/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-digits-range': [\n            function (value, param) {\n                var numValue, dataAttrRange, result, range, m;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/;\n                result = true;\n                range = param;\n\n                if (range) {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-range': [\n            function (value) {\n                var minValue, maxValue, ranges;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](value)) {\n                    minValue = maxValue = utils.parseNumber(value);\n                } else {\n                    ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(value);\n\n                    if (ranges) {\n                        minValue = utils.parseNumber(ranges[1]);\n                        maxValue = utils.parseNumber(ranges[2]);\n\n                        if (minValue > maxValue) {//eslint-disable-line max-depth\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-alpha': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z]+$/.test(value);\n            },\n            $.mage.__('Please use letters only (a-z or A-Z) in this field.')\n        ],\n        'validate-code': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z]+[a-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only lowercase letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')//eslint-disable-line max-len\n        ],\n        'validate-alphanum': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.')//eslint-disable-line max-len\n        ],\n        'validate-not-number-first': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[^0-9-\\.].*$/.test(value.trim());\n            },\n            $.mage.__('First character must be letter.')\n        ],\n        'validate-date': [\n            function (value, params, additionalParams) {\n                var test = moment(value, additionalParams.dateFormat);\n\n                return utils.isEmptyNoTrim(value) || test.isValid();\n            },\n            $.mage.__('Please enter a valid date.')\n        ],\n        'validate-date-range': [\n            function (value, params) {\n                var fromDate = $('input[name*=\"' + params + '\"]').val();\n\n                return moment.utc(value).unix() >= moment.utc(fromDate).unix() || isNaN(moment.utc(value).unix());\n            },\n            $.mage.__('Make sure the To Date is later than or the same as the From Date.')\n        ],\n        'validate-identifier': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(value);\n            },\n            $.mage.__('Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").')//eslint-disable-line max-len\n        ],\n        'validate-trailing-hyphen': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(?!-)(?!.*-$).+$/.test(value);\n            },\n            $.mage.__('Trailing hyphens are not allowed.')\n        ],\n        'validate-zip-international': [\n\n            /*function(v) {\n            // @TODO: Cleanup\n            return Validation.get('IsEmpty').test(v) || /(^[A-z0-9]{2,10}([\\s]{0,1}|[\\-]{0,1})[A-z0-9]{2,10}$)/.test(v);\n            }*/\n            function () {\n                return true;\n            },\n            $.mage.__('Please enter a valid zip code.')\n        ],\n        'validate-state': [\n            function (value) {\n                return value !== 0;\n            },\n            $.mage.__('Please select State/Province.')\n        ],\n        'less-than-equals-to': [\n            function (value, params) {\n                value = utils.parseNumber(value);\n\n                if (isNaN(parseFloat(params))) {\n                    params = $(params).val();\n                }\n\n                params = utils.parseNumber(params);\n\n                if (!isNaN(params) && !isNaN(value)) {\n                    this.lteToVal = params;\n\n                    return value <= params;\n                }\n\n                return true;\n            },\n            function () {\n                return $.mage.__('Please enter a value less than or equal to %s.').replace('%s', this.lteToVal);\n            }\n        ],\n        'greater-than-equals-to': [\n            function (value, params) {\n                value = utils.parseNumber(value);\n\n                if (isNaN(parseFloat(params))) {\n                    params = $(params).val();\n                }\n\n                params = utils.parseNumber(params);\n\n                if (!isNaN(params) && !isNaN(value)) {\n                    this.gteToVal = params;\n\n                    return value >= params;\n                }\n\n                return true;\n            },\n            function () {\n                return $.mage.__('Please enter a value greater than or equal to %s.').replace('%s', this.gteToVal);\n            }\n        ],\n        'validate-emails': [\n            function (value) {\n                var validRegexp, emails, i;\n\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n                validRegexp = /^[a-z0-9\\._-]{1,30}@([a-z0-9_-]{1,30}\\.){1,5}[a-z]{2,4}$/i;\n                emails = value.split(/[\\s\\n\\,]+/g);\n\n                for (i = 0; i < emails.length; i++) {\n                    if (!validRegexp.test(emails[i].strip())) {\n                        return false;\n                    }\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter valid email addresses, separated by commas. For example, johndoe@domain.com, johnsmith@domain.com.')//eslint-disable-line max-len\n        ],\n        'validate-cc-number': [\n\n            /**\n             * Validate credit card number based on mod 10.\n             *\n             * @param {String} value - credit card number\n             * @return {Boolean}\n             */\n            function (value) {\n                if (value) {\n                    return validateCreditCard(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-cc-ukss': [\n\n            /**\n             * Validate Switch/Solo/Maestro issue number and start date is filled.\n             *\n             * @param {String} value - input field value\n             * @return {*}\n             */\n            function (value) {\n                return value;\n            },\n            $.mage.__('Please enter issue number or start date for switch/solo card type.')\n        ],\n        'required-entry': [\n            function (value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'checked': [\n            function (value) {\n                return value;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'not-negative-amount': [\n            function (value) {\n                if (value.length) {\n                    return (/^\\s*\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter positive number in this field.')\n        ],\n        'validate-per-page-value-list': [\n            function (value) {\n                var isValid = true,\n                    values = value.split(','),\n                    i;\n\n                if (utils.isEmpty(value)) {\n                    return isValid;\n                }\n\n                for (i = 0; i < values.length; i++) {\n                    if (!/^[0-9]+$/.test(values[i])) {\n                        isValid = false;\n                    }\n                }\n\n                return isValid;\n            },\n            $.mage.__('Please enter a valid value, ex: 10,20,30')\n        ],\n        'validate-new-password': [\n            function (value) {\n                if ($.validator.methods['validate-password'] && !$.validator.methods['validate-password'](value)) {\n                    return false;\n                }\n\n                if (utils.isEmpty(value) && value !== '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-item-quantity': [\n            function (value, params) {\n                var validator = this,\n                    result = false,\n                    // obtain values for validation\n                    qty = utils.parseNumber(value),\n                    isMinAllowedValid = typeof params.minAllowed === 'undefined' ||\n                        qty >= utils.parseNumber(params.minAllowed),\n                    isMaxAllowedValid = typeof params.maxAllowed === 'undefined' ||\n                        qty <= utils.parseNumber(params.maxAllowed),\n                    isQtyIncrementsValid = typeof params.qtyIncrements === 'undefined' ||\n                        qty % utils.parseNumber(params.qtyIncrements) === 0;\n\n                result = qty > 0;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('Please enter a quantity greater than 0.');//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMinAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The fewest you may purchase is %1.').replace('%1', params.minAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMaxAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The maximum you may purchase is %1.').replace('%1', params.maxAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isQtyIncrementsValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('You can buy this product only in quantities of %1 at a time.').replace('%1', params.qtyIncrements);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                return result;\n            }, function () {\n                return this.itemQtyErrorMessage;\n            }\n        ],\n        'equalTo': [\n            function (value, param) {\n                return value === $(param).val();\n            },\n            $.validator.messages.equalTo\n        ],\n        'validate-file-type': [\n            function (name, types) {\n                var extension = name.split('.').pop().toLowerCase();\n\n                if (types && typeof types === 'string') {\n                    types = types.split(' ');\n                }\n\n                return !types || !types.length || ~types.indexOf(extension);\n            },\n            $.mage.__('We don\\'t recognize or support this file extension type.')\n        ],\n        'validate-max-size': [\n            function (size, maxSize) {\n                return maxSize === false || size < maxSize;\n            },\n            $.mage.__('File you are trying to upload exceeds maximum file size limit.')\n        ],\n        'validate-if-tag-script-exist': [\n            function (value) {\n                return !value || (/<script\\b[^>]*>([\\s\\S]*?)<\\/script>$/ig).test(value);\n            },\n            $.mage.__('Please use tag SCRIPT with SRC attribute or with proper content to include JavaScript to the document.')//eslint-disable-line max-len\n        ],\n        'date_range_min': [\n            function (value, minValue, params) {\n                return moment.utc(value, params.dateFormat).unix() >= minValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'date_range_max': [\n            function (value, maxValue, params) {\n                return moment.utc(value, params.dateFormat).unix() <= maxValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'validate-color': [\n            function (value) {\n                if (value === '') {\n                    return true;\n                }\n\n                return tinycolor(value).isValid();\n            },\n            $.mage.__('Wrong color format. Please specify color in HEX, RGBa, HSVa, HSLa or use color name.')\n        ],\n        'blacklist-url': [\n            function (value, param) {\n                return new RegExp(param).test(value);\n            },\n            $.mage.__('This link is not allowed.')\n        ],\n        'validate-dob': [\n            function (value, param, params) {\n                if (value === '') {\n                    return true;\n                }\n\n                return moment.utc(value, params.dateFormat).isSameOrBefore(moment.utc());\n            },\n            $.mage.__('The Date of Birth should not be greater than today.')\n        ],\n        'validate-no-utf8mb4-characters': [\n            function (value) {\n                var validator = this,\n                    message = $.mage.__('Please remove invalid characters: {0}.'),\n                    matches = value.match(/(?:[\\uD800-\\uDBFF][\\uDC00-\\uDFFF])/g),\n                    result = matches === null;\n\n                if (!result) {\n                    validator.charErrorMessage = message.replace('{0}', matches.join());\n                }\n\n                return result;\n            }, function () {\n                return this.charErrorMessage;\n            }\n        ]\n    }, function (data) {\n        return {\n            handler: data[0],\n            message: data[1]\n        };\n    });\n});\n","Magento_Ui/js/core/app.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    './renderer/types',\n    './renderer/layout',\n    '../lib/knockout/bootstrap'\n], function (types, layout) {\n    'use strict';\n\n    return function (data, merge) {\n        types.set(data.types);\n        layout(data.components, undefined, true, merge);\n    };\n});\n","Magento_Ui/js/core/renderer/layout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'uiRegistry',\n    './types',\n    '../../lib/logger/console-logger'\n], function (_, $, utils, registry, types, consoleLogger) {\n    'use strict';\n\n    var templates = registry.create(),\n        layout = {},\n        cachedConfig = {};\n\n    /**\n     * Build name from parent name and node name\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @param {String} [name]\n     * @returns {String}\n     */\n    function getNodeName(parent, node, name) {\n        var parentName = parent && parent.name;\n\n        if (typeof name !== 'string') {\n            name = node.name || name;\n        }\n\n        return utils.fullPath(parentName, name);\n    }\n\n    /**\n     * Get node type from node or parent.\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @returns {String}\n     */\n    function getNodeType(parent, node) {\n        return node.type || parent && parent.childType;\n    }\n\n    /**\n     * Get data scope based on parent data scope and node data scope.\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @returns {String}\n     */\n    function getDataScope(parent, node) {\n        var dataScope = node.dataScope,\n            parentScope = parent && parent.dataScope;\n\n        return !utils.isEmpty(parentScope) ?\n            !utils.isEmpty(dataScope) ?\n                parentScope + '.' + dataScope :\n                parentScope :\n            dataScope || '';\n    }\n\n    /**\n     * Load node dependencies on other instances.\n     *\n     * @param {Object} node\n     * @returns {jQueryPromise}\n     */\n    function loadDeps(node) {\n        var loaded = $.Deferred(),\n            loggerUtils = consoleLogger.utils;\n\n        if (node.deps) {\n            consoleLogger.utils.asyncLog(\n                loaded,\n                {\n                    data: {\n                        component: node.name,\n                        deps: node.deps\n                    },\n                    messages: loggerUtils.createMessages(\n                        'depsStartRequesting',\n                        'depsFinishRequesting',\n                        'depsLoadingFail'\n                    )\n                }\n            );\n        }\n\n        registry.get(node.deps, function (deps) {\n            node.provider = node.extendProvider ? deps && deps.name : node.provider;\n            loaded.resolve(node);\n        });\n\n        return loaded.promise();\n    }\n\n    /**\n     * Load node component file via requirejs.\n     *\n     * @param {Object} node\n     * @returns {jQueryPromise}\n     */\n    function loadSource(node) {\n        var loaded = $.Deferred(),\n            source = node.component;\n\n        consoleLogger.info('componentStartLoading', {\n            component: node.component\n        });\n\n        require([source], function (constr) {\n            consoleLogger.info('componentFinishLoading', {\n                component: node.component\n            });\n            loaded.resolve(node, constr);\n        }, function () {\n            consoleLogger.error('componentLoadingFail', {\n                component: node.component\n            });\n        });\n\n        return loaded.promise();\n    }\n\n    /**\n     * Create a new component instance and set it to the registry.\n     *\n     * @param {Object} node\n     * @param {Function} Constr\n     */\n    function initComponent(node, Constr) {\n        var component = new Constr(_.omit(node, 'children'));\n\n        consoleLogger.info('componentStartInitialization', {\n            component: node.component,\n            componentName: node.name\n        });\n\n        registry.set(node.name, component);\n    }\n\n    /**\n     * Application entry point.\n     *\n     * @param {Object} nodes\n     * @param {Object} parent\n     * @param {Boolean} cached\n     * @param {Boolean} merge\n     * @returns {Boolean|undefined}\n     */\n    function run(nodes, parent, cached, merge) {\n        if (_.isBoolean(merge) && merge) {\n            layout.merge(nodes);\n\n            return false;\n        }\n\n        if (cached) {\n            cachedConfig[_.keys(nodes)[0]] = JSON.parse(JSON.stringify(nodes));\n        }\n\n        _.each(nodes || [], layout.iterator.bind(layout, parent));\n    }\n\n    _.extend(layout, {\n        /**\n         * Determines if node ready to be added or process it.\n         *\n         * @param {Object} parent\n         * @param {Object|String} node\n         */\n        iterator: function (parent, node) {\n            var action = _.isString(node) ?\n                this.addChild :\n                this.process;\n\n            action.apply(this, arguments);\n        },\n\n        /**\n         * Prepare component.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Object}\n         */\n        process: function (parent, node, name) {\n            if (!parent && node.parent) {\n                return this.waitParent(node, name);\n            }\n\n            if (node.nodeTemplate) {\n                return this.waitTemplate.apply(this, arguments);\n            }\n\n            node = this.build.apply(this, arguments);\n\n            if (!registry.has(node.name)) {\n                this.addChild(parent, node)\n                    .manipulate(node)\n                    .initComponent(node);\n            }\n\n            if (node) {\n                run(node.children, node);\n            }\n\n            return this;\n        },\n\n        /**\n         * Detailed processing of component config.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Boolean|Object}\n         */\n        build: function (parent, node, name) {\n            var defaults    = parent && parent.childDefaults || {},\n                children    = this.filterDisabledChildren(node.children),\n                type        = getNodeType(parent, node),\n                dataScope   = getDataScope(parent, node),\n                component,\n                extendDeps  = true,\n                nodeName;\n\n            node.children = false;\n            node.extendProvider = true;\n\n            if (node.config && node.config.provider || node.provider) {\n                node.extendProvider = false;\n            }\n\n            if (node.config && node.config.deps || node.deps) {\n                extendDeps = false;\n            }\n\n            node = utils.extend({\n            }, types.get(type), defaults, node);\n\n            nodeName = getNodeName(parent, node, name);\n\n            if (registry.has(nodeName)) {\n                component = registry.get(nodeName);\n                component.children = children;\n\n                return component;\n            }\n\n            if (extendDeps && parent && parent.deps && type) {\n                node.deps = parent.deps;\n            }\n\n            _.extend(node, node.config || {}, {\n                index: node.name || name,\n                name: nodeName,\n                dataScope: dataScope,\n                parentName: utils.getPart(nodeName, -2),\n                parentScope: utils.getPart(dataScope, -2)\n            });\n\n            node.children = children;\n            node.componentType = node.type;\n\n            delete node.type;\n            delete node.config;\n\n            if (children) {\n                node.initChildCount = _.size(children);\n            }\n\n            if (node.isTemplate) {\n                node.isTemplate = false;\n\n                templates.set(node.name, node);\n                registry.get(node.parentName, function (parentComp) {\n                    parentComp.childTemplate = node;\n                });\n\n                return false;\n            }\n\n            if (node.componentDisabled === true) {\n                return false;\n            }\n\n            return node;\n        },\n\n        /**\n         * Filter out all disabled components.\n         *\n         * @param {Object} children\n         * @returns {*}\n         */\n        filterDisabledChildren: function (children) {\n            var cIds;\n\n            //cleanup children config.componentDisabled = true\n            if (children && typeof children === 'object') {\n                cIds = Object.keys(children);\n\n                if (cIds) {\n                    _.each(cIds, function (cId) {\n                        if (typeof children[cId] === 'object' &&\n                            children[cId].hasOwnProperty('config') &&\n                            typeof children[cId].config === 'object' &&\n                            children[cId].config.hasOwnProperty('componentDisabled') &&\n                            children[cId].config.componentDisabled === true) {\n                            delete children[cId];\n                        }\n                    });\n                }\n            }\n\n            return children;\n        },\n\n        /**\n         * Init component.\n         *\n         * @param {Object} node\n         * @returns {Object}\n         */\n        initComponent: function (node) {\n            if (!node.component) {\n                return this;\n            }\n\n            loadDeps(node)\n                .then(loadSource)\n                .done(initComponent);\n\n            return this;\n        }\n    });\n\n    _.extend(layout, {\n        /**\n         * Loading component marked as isTemplate.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @returns {Object}\n         */\n        waitTemplate: function (parent, node) {\n            var args = _.toArray(arguments);\n\n            templates.get(node.nodeTemplate, function () {\n                this.applyTemplate.apply(this, args);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Waiting for parent component and process provided component.\n         *\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Object}\n         */\n        waitParent: function (node, name) {\n            var process = this.process.bind(this);\n\n            registry.get(node.parent, function (parent) {\n                process(parent, node, name);\n            });\n\n            return this;\n        },\n\n        /**\n         * Processing component marked as isTemplate.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         */\n        applyTemplate: function (parent, node, name) {\n            var template = templates.get(node.nodeTemplate);\n\n            node = utils.extend({}, template, node);\n\n            delete node.nodeTemplate;\n\n            this.process(parent, node, name);\n        }\n    });\n\n    _.extend(layout, {\n        /**\n         * Determines inserting strategy.\n         *\n         * @param {Object} node\n         * @returns {Object}\n         */\n        manipulate: function (node) {\n            var name = node.name;\n\n            if (node.appendTo) {\n                this.insert(name, node.appendTo, -1);\n            }\n\n            if (node.prependTo) {\n                this.insert(name, node.prependTo, 0);\n            }\n\n            if (node.insertTo) {\n                this.insertTo(name, node.insertTo);\n            }\n\n            return this;\n        },\n\n        /**\n         * Insert component to provide target and position.\n         *\n         * @param {Object|String} item\n         * @param {Object} target\n         * @param {Number} position\n         * @returns {Object}\n         */\n        insert: function (item, target, position) {\n            registry.get(target, function (container) {\n                container.insertChild(item, position);\n            });\n\n            return this;\n        },\n\n        /**\n         * Insert component into multiple targets.\n         *\n         * @param {Object} item\n         * @param {Array} targets\n         * @returns {Object}\n         */\n        insertTo: function (item, targets) {\n            _.each(targets, function (info, target) {\n                this.insert(item, target, info.position);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Add provided child to parent.\n         *\n         * @param {Object} parent\n         * @param {Object|String} child\n         * @returns {Object}\n         */\n        addChild: function (parent, child) {\n            var name;\n\n            if (parent && parent.component) {\n                name = child.name || child;\n\n                this.insert(name, parent.name, child.sortOrder);\n            }\n\n            return this;\n        },\n\n        /**\n         * Merge components configuration with cached configuration.\n         *\n         * @param {Array} components\n         */\n        merge: function (components) {\n            var cachedKey = _.keys(components)[0],\n                compared = utils.compare(cachedConfig[cachedKey], components),\n                remove = this.filterComponents(this.getByProperty(compared.changes, 'type', 'remove'), true),\n                update = this.getByProperty(compared.changes, 'type', 'update'),\n                dataSources = this.getDataSources(components),\n                names, index, name, component;\n\n            _.each(dataSources, function (val, key) {\n                name = key.replace(/\\.children|\\.config/g, '');\n                component = registry.get(name);\n\n                component.cacheData();\n                component.updateConfig(\n                    true,\n                    this.getFullConfig(key, components),\n                    this.getFullConfig(key, cachedConfig[cachedKey])\n                );\n            }, this);\n\n            _.each(remove, function (val) {\n                component = registry.get(val.path);\n\n                if (component) {\n                    component.destroy();\n                }\n            });\n\n            update = _.compact(_.filter(update, function (val) {\n                return !_.isEqual(val.oldValue, val.value);\n            }));\n\n            _.each(update, function (val) {\n                names = val.path.split('.');\n                index = Math.max(_.lastIndexOf(names, 'config'), _.lastIndexOf(names, 'children') + 2);\n                name = _.without(names.splice(0, index), 'children', 'config').join('.');\n                component = registry.get(name);\n\n                if (val.name === 'sortOrder' && component) {\n                    registry.get(component.parentName).insertChild(component, val.value);\n                } else if (component) {\n                    component.updateConfig(\n                        val.oldValue,\n                        val.value,\n                        val.path\n                    );\n                }\n            }, this);\n\n            run(components, undefined, true);\n        },\n\n        /**\n         * Recursive dataSource assignment.\n         *\n         * @param {Object} config\n         * @param {String} parentPath\n         * @returns {Object}\n         */\n        getDataSources: function (config, parentPath) {\n            var dataSources = {},\n                key, obj;\n\n            /* eslint-disable no-loop-func, max-depth */\n            for (key in config) {\n                if (config.hasOwnProperty(key)) {\n                    if (\n                        key === 'type' &&\n                        config[key] === 'dataSource' &&\n                        config.hasOwnProperty('config')\n                    ) {\n                        dataSources[parentPath + '.config'] = config.config;\n                    } else if (_.isObject(config[key])) {\n                        obj = this.getDataSources(config[key], utils.fullPath(parentPath, key));\n\n                        _.each(obj, function (value, path) {\n                            dataSources[path] = value;\n                        });\n                    }\n                }\n            }\n\n            /* eslint-enable no-loop-func, max-depth */\n\n            return dataSources;\n        },\n\n        /**\n         * Configuration getter.\n         *\n         * @param {String} path\n         * @param {Object} config\n         * @returns {Boolean|Object}\n         */\n        getFullConfig: function (path, config) {\n            var index;\n\n            path = path.split('.');\n            index = _.lastIndexOf(path, 'config');\n\n            if (!~index) {\n                return false;\n            }\n            path = path.splice(0, index);\n\n            _.each(path, function (val) {\n                config = config[val];\n            });\n\n            return config.config;\n        },\n\n        /**\n         * Filter data by property and value.\n         *\n         * @param {Object} data\n         * @param {String} prop\n         * @param {*} propValue\n         */\n        getByProperty: function (data, prop, propValue) {\n            return _.filter(data, function (value) {\n                return value[prop] === propValue;\n            });\n        },\n\n        /**\n         * Filter components.\n         *\n         * @param {Array} data\n         * @param {Boolean} splitPath\n         * @param {Number} index\n         * @param {String} separator\n         * @param {String} keyName\n         * @returns {Array}\n         */\n        filterComponents: function (data, splitPath, index, separator, keyName) {\n            var result = [],\n                names, length;\n\n            index = -2;\n            separator = '.' || separator;\n            keyName = 'children' || keyName;\n\n            _.each(data, function (val) {\n                names = val.path.split(separator);\n                length  = names.length;\n\n                if (names[length + index] === keyName) {\n                    val.path = splitPath ? _.without(names, keyName).join(separator) : val.path;\n                    result.push(val);\n                }\n            });\n\n            return result;\n        }\n    });\n\n    return run;\n});\n","Magento_Ui/js/core/renderer/types.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils'\n], function (_, utils) {\n    'use strict';\n\n    var store = {};\n\n    /**\n     * Flatten a nested data.\n     *\n     * @param {Object} data\n     * @returns {Object}\n     */\n    function flatten(data) {\n        var extender = data.extends || [],\n            result = {};\n\n        extender = utils.stringToArray(extender);\n\n        extender.push(data);\n\n        extender.forEach(function (item) {\n            if (_.isString(item)) {\n                item = store[item] || {};\n            }\n\n            utils.extend(result, item);\n        });\n\n        delete result.extends;\n\n        return result;\n    }\n\n    return {\n        /**\n         * Set types to store object.\n         *\n         * @param {Object} types\n         */\n        set: function (types) {\n            types = types || {};\n\n            utils.extend(store, types);\n\n            _.each(types, function (data, type) {\n                store[type] = flatten(data);\n            });\n        },\n\n        /**\n         * Get type from store object.\n         *\n         * @param {String} type\n         * @returns {*|{}}\n         */\n        get: function (type) {\n            return store[type] || {};\n        }\n    };\n});\n","Magento_Ui/js/timeline/timeline-view.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, raf, registry, Class) {\n    'use strict';\n\n    var hasClassList = (function () {\n        var list = document.createElement('_').classList;\n\n        return !!list && !list.toggle('_test', false);\n    })();\n\n    /**\n     * Polyfill of the 'classList.toggle' method.\n     *\n     * @param {HTMLElement} elem\n     */\n    function toggleClass(elem) {\n        var classList   = elem.classList,\n            args        = Array.prototype.slice.call(arguments, 1),\n            $elem;\n\n        if (hasClassList) {\n            classList.toggle.apply(classList, args);\n        } else {\n            $elem = $(elem);\n            $elem.toggleClass.apply($elem, args);\n        }\n    }\n\n    return Class.extend({\n        defaults: {\n            selectors: {\n                content: '.timeline-content',\n                timeUnit: '.timeline-unit',\n                item: '.timeline-item:not([data-role=no-data-msg])',\n                event: '.timeline-event'\n            }\n        },\n\n        /**\n         * Initializes TimelineView component.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'refresh',\n                'initContent',\n                'initItem',\n                'initTimeUnit',\n                'getItemBindings',\n                'updateItemsPosition',\n                'onScaleChange',\n                'onEventElementRender',\n                'onWindowResize',\n                'onContentScroll',\n                'onDataReloaded',\n                'onToStartClick',\n                'onToEndClick'\n            );\n\n            this._super()\n                .initModel()\n                .waitContent();\n\n            return this;\n        },\n\n        /**\n         * Applies listeners for the model properties changes.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        initModel: function () {\n            var model = registry.get(this.model);\n\n            model.on('scale', this.onScaleChange);\n            model.source.on('reloaded', this.onDataReloaded);\n\n            this.model = model;\n\n            return this;\n        },\n\n        /**\n         * Applies DOM watcher for the\n         * content element rendering.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        waitContent: function () {\n            $.async({\n                selector: this.selectors.content,\n                component: this.model\n            }, this.initContent);\n\n            return this;\n        },\n\n        /**\n         * Initializes timelines' content element.\n         *\n         * @param {HTMLElement} content\n         * @returns {TimelineView} Chainable.\n         */\n        initContent: function (content) {\n            this.$content = content;\n\n            $(content).on('scroll', this.onContentScroll);\n            $(window).on('resize', this.onWindowResize);\n\n            $.async(this.selectors.item, content, this.initItem);\n            $.async(this.selectors.event, content, this.onEventElementRender);\n            $.async(this.selectors.timeUnit, content, this.initTimeUnit);\n\n            this.refresh();\n\n            return this;\n        },\n\n        /**\n         * Initializes timeline item element,\n         * e.g. establishes event listeners and applies data bindings.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView} Chainable.\n         */\n        initItem: function (elem) {\n            $(elem)\n                .bindings(this.getItemBindings)\n                .on('click', '._toend', this.onToEndClick)\n                .on('click', '._tostart', this.onToStartClick);\n\n            return this;\n        },\n\n        /**\n         * Initializes timeline unit element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView} Chainable.\n         */\n        initTimeUnit: function (elem) {\n            $(elem).bindings(this.getTimeUnitBindings());\n\n            return this;\n        },\n\n        /**\n         * Updates items positions in a\n         * loop if state of a view has changed.\n         */\n        refresh: function () {\n            raf(this.refresh);\n\n            if (this._update) {\n                this._update = false;\n\n                this.updateItemsPosition();\n            }\n        },\n\n        /**\n         * Returns object width additional bindings\n         * for a timeline unit element.\n         *\n         * @returns {Object}\n         */\n        getTimeUnitBindings: function () {\n            return {\n                style: {\n                    width: ko.computed(function () {\n                        return this.getTimeUnitWidth() + '%';\n                    }.bind(this))\n                }\n            };\n        },\n\n        /**\n         * Returns object with additional\n         * bindings for a timeline item element.\n         *\n         * @param {Object} ctx\n         * @returns {Object}\n         */\n        getItemBindings: function (ctx) {\n            return {\n                style: {\n                    width: ko.computed(function () {\n                        return this.getItemWidth(ctx.$row()) + '%';\n                    }.bind(this)),\n\n                    'margin-left': ko.computed(function () {\n                        return this.getItemMargin(ctx.$row()) + '%';\n                    }.bind(this))\n                }\n            };\n        },\n\n        /**\n         * Calculates width in percents of a timeline unit element.\n         *\n         * @returns {Number}\n         */\n        getTimeUnitWidth: function () {\n            return 100 / this.model.scale;\n        },\n\n        /**\n         * Calculates width of a record in percents.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getItemWidth: function (record) {\n            var days = 0;\n\n            if (record) {\n                days = this.model.getDaysLength(record);\n            }\n\n            return this.getTimeUnitWidth()  * days;\n        },\n\n        /**\n         * Calculates left margin value for provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getItemMargin: function (record) {\n            var offset = 0;\n\n            if (record) {\n                offset = this.model.getStartDelta(record);\n            }\n\n            return this.getTimeUnitWidth() * offset;\n        },\n\n        /**\n         * Returns collection of currently available\n         * timeline item elements.\n         *\n         * @returns {Array<HTMLElement>}\n         */\n        getItems: function () {\n            var items = this.$content.querySelectorAll(this.selectors.item);\n\n            return _.toArray(items);\n        },\n\n        /**\n         * Updates positions of timeline elements.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        updateItemsPosition: function () {\n            this.getItems()\n                .forEach(this.updatePositionFor, this);\n\n            return this;\n        },\n\n        /**\n         * Updates position of provided timeline element.\n         *\n         * @param {HTMLElement} $elem\n         * @returns {TimelineView} Chainable.\n         */\n        updatePositionFor: function ($elem) {\n            var $event      = $elem.querySelector(this.selectors.event),\n                leftEdge    = this.getLeftEdgeFor($elem),\n                rightEdge   = this.getRightEdgeFor($elem);\n\n            if ($event) {\n                $event.style.left = Math.max(-leftEdge, 0) + 'px';\n                $event.style.right = Math.max(rightEdge, 0) + 'px';\n            }\n\n            toggleClass($elem, '_scroll-start', leftEdge < 0);\n            toggleClass($elem, '_scroll-end', rightEdge > 0);\n\n            return this;\n        },\n\n        /**\n         * Scrolls content area to the start of provided element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView}\n         */\n        toStartOf: function (elem) {\n            var leftEdge = this.getLeftEdgeFor(elem);\n\n            this.$content.scrollLeft += leftEdge;\n\n            return this;\n        },\n\n        /**\n         * Scrolls content area to the end of provided element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView}\n         */\n        toEndOf: function (elem) {\n            var rightEdge = this.getRightEdgeFor(elem);\n\n            this.$content.scrollLeft += rightEdge + 1;\n\n            return this;\n        },\n\n        /**\n         * Calculates location of the left edge of an element\n         * relative to the contents' left edge.\n         *\n         * @param {HTMLElement} elem\n         * @returns {Number}\n         */\n        getLeftEdgeFor: function (elem) {\n            var leftOffset = elem.getBoundingClientRect().left;\n\n            return leftOffset - this.$content.getBoundingClientRect().left;\n        },\n\n        /**\n         * Calculates location of the right edge of an element\n         * relative to the contents' right edge.\n         *\n         * @param {HTMLElement} elem\n         * @returns {Number}\n         */\n        getRightEdgeFor: function (elem) {\n            var elemWidth   = elem.offsetWidth,\n                leftEdge    = this.getLeftEdgeFor(elem);\n\n            return leftEdge + elemWidth - this.$content.offsetWidth;\n        },\n\n        /**\n         * 'To Start' button 'click' event handler.\n         *\n         * @param {jQueryEvent} event\n         */\n        onToStartClick: function (event) {\n            var elem = event.originalEvent.currentTarget;\n\n            event.stopPropagation();\n\n            this.toStartOf(elem);\n        },\n\n        /**\n         * 'To End' button 'click' event handler.\n         *\n         * @param {jQueryEvent} event\n         */\n        onToEndClick: function (event) {\n            var elem = event.originalEvent.currentTarget;\n\n            event.stopPropagation();\n\n            this.toEndOf(elem);\n        },\n\n        /**\n         * Handler of the scale value 'change' event.\n         */\n        onScaleChange: function () {\n            this._update = true;\n        },\n\n        /**\n         * Callback function which is invoked\n         * when event element was rendered.\n         */\n        onEventElementRender: function () {\n            this._update = true;\n        },\n\n        /**\n         * Window 'resize' event handler.\n         */\n        onWindowResize: function () {\n            this._update = true;\n        },\n\n        /**\n         * Content container 'scroll' event handler.\n         */\n        onContentScroll: function () {\n            this._update = true;\n        },\n\n        /**\n         * Data 'reload' event handler.\n         */\n        onDataReloaded: function () {\n            this._update = true;\n        }\n    });\n});\n","Magento_Ui/js/timeline/timeline.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'moment',\n    'uiLayout',\n    'Magento_Ui/js/grid/listing'\n], function (_, moment, layout, Listing) {\n    'use strict';\n\n    var ONE_DAY = 86400000;\n\n    return Listing.extend({\n        defaults: {\n            recordTmpl: 'ui/timeline/record',\n            dateFormat: 'YYYY-MM-DD HH:mm:ss',\n            headerFormat: 'ddd MM/DD',\n            detailsFormat: 'DD/MM/YYYY HH:mm:ss',\n            scale: 7,\n            scaleStep: 1,\n            minScale: 7,\n            maxScale: 28,\n            minDays: 28,\n            displayMode: 'timeline',\n            displayModes: {\n                timeline: {\n                    label: 'Timeline',\n                    value: 'timeline',\n                    template: 'ui/timeline/timeline'\n                }\n            },\n            viewConfig: {\n                component: 'Magento_Ui/js/timeline/timeline-view',\n                name: '${ $.name }_view',\n                model: '${ $.name }'\n            },\n            tracks: {\n                scale: true\n            },\n            statefull: {\n                scale: true\n            },\n            range: {}\n        },\n\n        /**\n         * Initializes Timeline component.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initView()\n                .updateRange();\n\n            return this;\n        },\n\n        /**\n         * Initializes components configuration.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.maxScale = Math.min(this.minDays, this.maxScale);\n            this.minScale = Math.min(this.maxScale, this.minScale);\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe.call(this.range, true, 'hasToday');\n\n            return this;\n        },\n\n        /**\n         * Initializes TimelineView component.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initView: function () {\n            layout([this.viewConfig]);\n\n            return this;\n        },\n\n        /**\n         * Checks if provided event record is active,\n         * i.e. it has already started.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isActive: function (record) {\n            return Number(record.status) === 1;\n        },\n\n        /**\n         * Checks if provided event record is upcoming,\n         * i.e. it will start later on.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isUpcoming: function (record) {\n            return Number(record.status) === 2;\n        },\n\n        /**\n         * Checks if provided event record is permanent,\n         * i.e. it has no ending time.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isPermanent: function (record) {\n            return !this.getEndDate(record);\n        },\n\n        /**\n         * Checks if provided date indicates current day.\n         *\n         * @param {(Number|Moment)} date\n         * @returns {Boolenan}\n         */\n        isToday: function (date) {\n            return moment().isSame(date, 'day');\n        },\n\n        /**\n         * Checks if range object contains todays date.\n         *\n         * @returns {Boolean}\n         */\n        hasToday: function () {\n            return this.range.hasToday;\n        },\n\n        /**\n         * Returns start date of provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getStartDate: function (record) {\n            return record['start_time'];\n        },\n\n        /**\n         * Returns end date of provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getEndDate: function (record) {\n            return record['end_time'];\n        },\n\n        /**\n         * Returns difference in days between records' start date\n         * and a first day of a range.\n         *\n         * @param {Object} record\n         * @returns {Number}\n         */\n        getStartDelta: function (record) {\n            var start    = this.createDate(this.getStartDate(record)),\n                firstDay = this.range.firstDay;\n\n            return start.diff(firstDay, 'days', true);\n        },\n\n        /**\n         * Calculates the amount of days that provided event lasts.\n         *\n         * @param {Object} record\n         * @returns {Number}\n         */\n        getDaysLength: function (record) {\n            var start   = this.createDate(this.getStartDate(record)),\n                end     = this.createDate(this.getEndDate(record));\n\n            if (!end.isValid()) {\n                end = this.range.lastDay.endOf('day');\n            }\n\n            return end.diff(start, 'days', true);\n        },\n\n        /**\n         * Creates new date object based on provided date string value.\n         *\n         * @param {String} dateStr\n         * @returns {Moment}\n         */\n        createDate: function (dateStr) {\n            return moment(dateStr, this.dateFormat);\n        },\n\n        /**\n         * Converts days to weeks.\n         *\n         * @param {Number} days\n         * @returns {Number}\n         */\n        daysToWeeks: function (days) {\n            var weeks = days / 7;\n\n            if (weeks % 1) {\n                weeks = weeks.toFixed(1);\n            }\n\n            return weeks;\n        },\n\n        /**\n         * Updates data of a range object,\n         * e.g. total days, first day and last day, etc.\n         *\n         * @returns {Object} Range instance.\n         */\n        updateRange: function () {\n            var firstDay    = this._getFirstDay(),\n                lastDay     = this._getLastDay(),\n                totalDays   = lastDay.diff(firstDay, 'days'),\n                days        = [],\n                i           = -1;\n\n            if (totalDays < this.minDays) {\n                totalDays += this.minDays - totalDays - 1;\n            }\n\n            while (++i <= totalDays) {\n                days.push(+firstDay + ONE_DAY * i);\n            }\n\n            return _.extend(this.range, {\n                days:       days,\n                totalDays:  totalDays,\n                firstDay:   firstDay,\n                lastDay:    moment(_.last(days)),\n                hasToday:   this.isToday(firstDay)\n            });\n        },\n\n        /**\n         *\n         * @private\n         * @param {String} key\n         * @returns {Array<Moment>}\n         */\n        _getDates: function (key) {\n            var dates = [];\n\n            this.rows.forEach(function (record) {\n                if (record[key]) {\n                    dates.push(this.createDate(record[key]));\n                }\n            }, this);\n\n            return dates;\n        },\n\n        /**\n         * Returns date which is closest to the current day.\n         *\n         * @private\n         * @returns {Moment}\n         */\n        _getFirstDay: function () {\n            var dates = this._getDates('start_time'),\n                first = moment.min(dates).subtract(1, 'day'),\n                today = moment();\n\n            if (!first.isValid() || first < today) {\n                first = today;\n            }\n\n            return first.startOf('day');\n        },\n\n        /**\n         * Returns the most distant date\n         * specified in available records.\n         *\n         * @private\n         * @returns {Moment}\n         */\n        _getLastDay: function () {\n            var startDates  = this._getDates('start_time'),\n                endDates    = this._getDates('end_time'),\n                last        = moment.max(startDates.concat(endDates));\n\n            return last.add(1, 'day').startOf('day');\n        },\n\n        /**\n         * TODO: remove after integration with date binding.\n         *\n         * @param {Number} timestamp\n         * @returns {String}\n         */\n        formatHeader: function (timestamp) {\n            return moment(timestamp).format(this.headerFormat);\n        },\n\n        /**\n         * TODO: remove after integration with date binding.\n         *\n         * @param {String} date\n         * @returns {String}\n         */\n        formatDetails: function (date) {\n            return moment(date).format(this.detailsFormat);\n        }\n    });\n});\n","Magento_Ui/js/grid/sortBy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiElement'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/sortBy',\n            options: [],\n            applied: {},\n            sorting: 'asc',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            selectedOption: '',\n            isVisible: true,\n            listens: {\n                'selectedOption': 'applyChanges'\n            },\n            statefull: {\n                selectedOption: true,\n                applied: true\n            },\n            exports: {\n                applied: '${ $.provider }:params.sorting'\n            },\n            imports: {\n                preparedOptions: '${ $.columnsProvider }:elems'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'applied',\n                    'selectedOption',\n                    'isVisible'\n                ]);\n        },\n\n        /**\n         * Prepared sort order options\n         */\n        preparedOptions: function (columns) {\n            if (columns && columns.length > 0) {\n                columns.map(function (column) {\n                    if (column.sortable === true) {\n                        this.options.push({\n                            value: column.index,\n                            label: column.label\n                        });\n                        this.isVisible(true);\n                    } else {\n                        this.isVisible(false);\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Apply changes\n         */\n        applyChanges: function () {\n            this.applied({\n                field: this.selectedOption(),\n                direction: this.sorting\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/spinner',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (ko, _, loader, resolver, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/listing',\n            listTemplate: 'ui/list/listing',\n            stickyTmpl: 'ui/grid/sticky/listing',\n            viewSwitcherTmpl: 'ui/grid/view-switcher',\n            positions: false,\n            displayMode: 'grid',\n            displayModes: {\n                grid: {\n                    value: 'grid',\n                    label: 'Grid',\n                    template: '${ $.template }'\n                },\n                list: {\n                    value: 'list',\n                    label: 'List',\n                    template: '${ $.listTemplate }'\n                }\n            },\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/grid/dnd',\n                columnsProvider: '${ $.name }',\n                enabled: true\n            },\n            editorConfig: {\n                name: '${ $.name }_editor',\n                component: 'Magento_Ui/js/grid/editing/editor',\n                columnsProvider: '${ $.name }',\n                dataProvider: '${ $.provider }',\n                enabled: false\n            },\n            resizeConfig: {\n                name: '${ $.name }_resize',\n                columnsProvider: '${ $.name }',\n                component: 'Magento_Ui/js/grid/resize',\n                enabled: false\n            },\n            imports: {\n                rows: '${ $.provider }:data.items'\n            },\n            listens: {\n                elems: 'updatePositions updateVisible',\n                '${ $.provider }:reload': 'onBeforeReload',\n                '${ $.provider }:reloaded': 'onDataReloaded'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }',\n                resize: '${ $.resizeConfig.name }'\n            },\n            tracks: {\n                displayMode: true\n            },\n            statefull: {\n                displayMode: true\n            }\n        },\n\n        /**\n         * Initializes Listing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateVisible');\n\n            this._super()\n                .initDnd()\n                .initEditor()\n                .initResize();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: [],\n                    visibleColumns: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Creates drag&drop widget instance.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes resize component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initResize: function () {\n            if (this.resizeConfig.enabled) {\n                layout([this.resizeConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates inline editing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initEditor: function () {\n            if (this.editorConfig.enabled) {\n                layout([this.editorConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initElement: function (element) {\n            var currentCount = this.elems().length,\n                totalCount = this.initChildCount;\n\n            if (totalCount === currentCount) {\n                this.initPositions();\n            }\n\n            element.on('visible', this.updateVisible);\n\n            return this._super();\n        },\n\n        /**\n         * Defines initial order of child elements.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initPositions: function () {\n            this.on('positions', this.applyPositions.bind(this));\n\n            this.setStatefull('positions');\n\n            return this;\n        },\n\n        /**\n         * Updates current state of child positions.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updatePositions: function () {\n            var positions = {};\n\n            this.elems.each(function (elem, index) {\n                positions[elem.index] = index;\n            });\n\n            this.set('positions', positions);\n\n            return this;\n        },\n\n        /**\n         * Resorts child elements array according to provided positions.\n         *\n         * @param {Object} positions - Object where key represents child\n         *      index and value is its' position.\n         * @returns {Listing} Chainable.\n         */\n        applyPositions: function (positions) {\n            var sorting;\n\n            sorting = this.elems.map(function (elem) {\n                return {\n                    elem: elem,\n                    position: positions[elem.index]\n                };\n            });\n\n            this.insertChild(sorting);\n\n            return this;\n        },\n\n        /**\n         * Returns reference to 'visibleColumns' array.\n         *\n         * @returns {Array}\n         */\n        getVisible: function () {\n            var observable = ko.getObservable(this, 'visibleColumns');\n\n            return observable || this.visibleColumns;\n        },\n\n        /**\n         * Returns path to the template\n         * defined for a current display mode.\n         *\n         * @returns {String} Path to the template.\n         */\n        getTemplate: function () {\n            var mode = this.displayModes[this.displayMode];\n\n            return mode.template;\n        },\n\n        /**\n         * Returns an array of available display modes.\n         *\n         * @returns {Array<Object>}\n         */\n        getDisplayModes: function () {\n            var modes = this.displayModes;\n\n            return _.values(modes);\n        },\n\n        /**\n         * Sets display mode to provided value.\n         *\n         * @param {String} index\n         * @returns {Listing} Chainable\n         */\n        setDisplayMode: function (index) {\n            this.displayMode = index;\n\n            return this;\n        },\n\n        /**\n         * Returns total number of displayed columns in grid.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.visibleColumns.length;\n        },\n\n        /**\n         * Updates array of visible columns.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updateVisible: function () {\n            this.visibleColumns = this.elems.filter('visible');\n\n            return this;\n        },\n\n        /**\n         * Checks if grid has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.rows && !!this.rows.length;\n        },\n\n        /**\n         * Hides loader.\n         */\n        hideLoader: function () {\n            loader.get(this.name).hide();\n        },\n\n        /**\n         * Shows loader.\n         */\n        showLoader: function () {\n            loader.get(this.name).show();\n        },\n\n        /**\n         * Handler of the data providers' 'reload' event.\n         */\n        onBeforeReload: function () {\n            this.showLoader();\n        },\n\n        /**\n         * Handler of the data providers' 'reloaded' event.\n         */\n        onDataReloaded: function () {\n            resolver(this.hideLoader, this);\n        }\n    });\n});\n","Magento_Ui/js/grid/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'rjsResolver',\n    'uiLayout',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'uiElement',\n    'uiRegistry',\n    'Magento_Ui/js/grid/data-storage'\n], function ($, _, utils, resolver, layout, alert, $t, Element, registry) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            firstLoad: true,\n            lastError: false,\n            storageConfig: {\n                component: 'Magento_Ui/js/grid/data-storage',\n                provider: '${ $.storageConfig.name }',\n                name: '${ $.name }_storage',\n                updateUrl: '${ $.update_url }'\n            },\n            listens: {\n                params: 'onParamsChange',\n                requestConfig: 'updateRequestConfig'\n            },\n            ignoreTmpls: {\n                data: true\n            },\n            triggerDataReload: false\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            utils.limit(this, 'onParamsChange', 5);\n            _.bindAll(this, 'onReload');\n\n            this._super()\n                .initStorage()\n                .clearData();\n\n            // Load data when there will\n            // be no more pending assets.\n            resolver(this.reload, this);\n\n            return this;\n        },\n\n        /**\n         * Initializes storage component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initStorage: function () {\n            layout([this.storageConfig]);\n\n            return this;\n        },\n\n        /**\n         * Clears provider's data properties.\n         *\n         * @returns {Provider} Chainable.\n         */\n        clearData: function () {\n            this.setData({\n                items: [],\n                totalRecords: 0,\n                showTotalRecords: true\n            });\n\n            return this;\n        },\n\n        /**\n         * Overrides current data with a provided one.\n         *\n         * @param {Object} data - New data object.\n         * @returns {Provider} Chainable.\n         */\n        setData: function (data) {\n            data = this.processData(data);\n\n            this.set('data', data);\n\n            return this;\n        },\n\n        /**\n         * Processes data before applying it.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {Object}\n         */\n        processData: function (data) {\n            var items = data.items;\n\n            _.each(items, function (record, index) {\n                record._rowIndex = index;\n            });\n\n            return data;\n        },\n\n        /**\n         * Reloads data with current parameters.\n         *\n         * @returns {Promise} Reload promise object.\n         */\n        reload: function (options) {\n            var request = this.storage().getData(this.params, options);\n\n            this.trigger('reload');\n\n            request\n                .done(this.onReload)\n                .fail(this.onError.bind(this));\n\n            return request;\n        },\n\n        /**\n         * Handles changes of 'params' object.\n         */\n        onParamsChange: function () {\n            // It's necessary to make a reload only\n            // after the initial loading has been made.\n            if (!this.firstLoad) {\n                this.reload();\n            } else {\n                this.triggerDataReload = true;\n            }\n        },\n\n        /**\n         * Handles reload error.\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            this.set('lastError', true);\n\n            this.firstLoad = false;\n            this.triggerDataReload = false;\n\n            alert({\n                content: $t('Something went wrong.')\n            });\n        },\n\n        /**\n         * Handles successful data reload.\n         *\n         * @param {Object} data - Retrieved data object.\n         */\n        onReload: function (data) {\n            this.firstLoad = false;\n            this.set('lastError', false);\n            this.setData(data)\n                .trigger('reloaded');\n\n            if (this.triggerDataReload) {\n                this.triggerDataReload = false;\n                this.reload();\n            }\n        },\n\n        /**\n         * Updates storage's request configuration\n         *\n         * @param {Object} requestConfig\n         */\n        updateRequestConfig: function (requestConfig) {\n            registry.get(this.storageConfig.provider, function (storage) {\n                _.extend(storage.requestConfig, requestConfig);\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/dnd.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, registry, Class) {\n    'use strict';\n\n    var isTouchDevice = typeof document.ontouchstart !== 'undefined',\n        transformProp;\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.body.style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform != 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] != 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    /**\n     * Returns first touch data if it's available.\n     *\n     * @param {(MouseEvent|TouchEvent)} e - Event object.\n     * @returns {Object}\n     */\n    function getTouch(e) {\n        return e.touches ? e.touches[0] : e;\n    }\n\n    /**\n     * Moves specified DOM element to the x and y coordinates.\n     *\n     * @param {HTMLElement} elem - Element to be relocated.\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     */\n    function locate(elem, x, y) {\n        var value = 'translate(' + x + 'px,' + y + 'px)';\n\n        elem.style[transformProp] = value;\n    }\n\n    /*eslint-disable no-extra-parens*/\n    /**\n     * Checks if specified coordinate is inside of the provided area.\n     *\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     * @param {Object} area - Object which represents area.\n     * @returns {Boolean}\n     */\n    function isInside(x, y, area) {\n        return (\n            area &&\n            x >= area.left && x <= area.right &&\n            y >= area.top && y <= area.bottom\n        );\n    }\n\n    /*eslint-enable no-extra-parens*/\n\n    /**\n     * Calculates distance between two points.\n     *\n     * @param {Number} x1 - X coordinate of a first point.\n     * @param {Number} y1 - Y coordinate of a first point.\n     * @param {Number} x2 - X coordinate of a second point.\n     * @param {Number} y2 - Y coordinate of a second point.\n     * @returns {Number} Distance between points.\n     */\n    function distance(x1, y1, x2, y2) {\n        var dx = x2 - x1,\n            dy = y2 - y1;\n\n        dx *= dx;\n        dy *= dy;\n\n        return Math.sqrt(dx + dy);\n    }\n\n    /**\n     * Returns viewModel associated with a provided DOM element.\n     *\n     * @param {HTMLElement} elem\n     * @returns {Object|Array}\n     */\n    function getModel(elem) {\n        return ko.dataFor(elem);\n    }\n\n    /**\n     * Checks whether cols are identical\n     *\n     * @param {HTMLElement} c1\n     * @param {HTMLElement} c2\n     * @returns {Boolean}\n     */\n    function compareCols(c1, c2) {\n        return c1.cellIndex === c2.cellIndex;\n    }\n\n    return Class.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table.data-grid',\n            mainTableSelector: '[data-role=\"grid\"]',\n            columnSelector: '${ $.tableSelector } thead tr th',\n            noSelectClass: '_no-select',\n            hiddenClass: '_hidden',\n            fixedX: false,\n            fixedY: true,\n            minDistance: 2,\n            columns: []\n        },\n\n        /**\n         * Initializes Dnd component.\n         *\n         * @returns {Dnd} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initTable',\n                'initColumn',\n                'removeColumn',\n                'onMouseMove',\n                'onMouseUp',\n                'onMouseDown'\n            );\n\n            this.$body = $('body');\n\n            this._super()\n                .initListeners();\n\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.columnSelector, this.initColumn);\n\n            return this;\n        },\n\n        /**\n         * Binds necessary events listeners.\n         *\n         * @returns {Dnd} Chainbale.\n         */\n        initListeners: function () {\n            if (isTouchDevice) {\n                $(document).on({\n                    touchmove: this.onMouseMove,\n                    touchend: this.onMouseUp,\n                    touchleave: this.onMouseUp\n                });\n            } else {\n                $(document).on({\n                    mousemove: this.onMouseMove,\n                    mouseup: this.onMouseUp\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Defines specified table element as a main container.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {Dnd} Chainable.\n         */\n        initTable: function (table) {\n            this.table =  $(table).is(this.mainTableSelector) ?  table : this.table;\n\n            $(table).addClass('data-grid-draggable');\n\n            return this;\n        },\n\n        /**\n         * Sets specified column as a draggable element.\n         *\n         * @param {HTMLTableHeaderCellElement} column - Columns header element.\n         * @returns {Dnd} Chainable.\n         */\n        initColumn: function (column) {\n            var model = getModel(column),\n                eventName;\n\n            if (!model || !model.draggable) {\n                return this;\n            }\n\n            if (!ko.es5.isTracked(model, 'dragover')) {\n                model.track('dragover');\n            }\n\n            this.columns.push(column);\n\n            $(column).bindings({\n                css: {\n                    '_dragover-left': ko.computed(function () {\n                        return model.dragover === 'right';\n                    }),\n                    '_dragover-right': ko.computed(function () {\n                        return model.dragover === 'left';\n                    })\n                }\n            });\n\n            eventName = isTouchDevice ?\n                'touchstart' :\n                'mousedown';\n\n            $(column).on(eventName, this.onMouseDown);\n            $.async.remove(column, this.removeColumn);\n\n            return this;\n        },\n\n        /**\n         * Removes specified column element from the columns array.\n         *\n         * @param {HTMLTableHeaderCellElement} column - Columns header element.\n         * @returns {Dnd} Chainable.\n         */\n        removeColumn: function (column) {\n            var columns = this.columns,\n                index = columns.indexOf(column);\n\n            if (~index) {\n                columns.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns index of column.\n         *\n         * @param {HTMLTableHeaderCellElement} elem\n         * @returns {Number}\n         */\n        _getColumnIndex: function (elem) {\n            return _.toArray(elem.parentNode.cells).indexOf(elem);\n        },\n\n        /**\n         * Calculates coordinates of draggable elements.\n         *\n         * @returns {Dnd} Chainbale.\n         */\n        _cacheCoords: function () {\n            var container   = this.table.getBoundingClientRect(),\n                bodyRect    = document.body.getBoundingClientRect(),\n                grabbed     = this.grabbed,\n                dragElem    = grabbed.elem,\n                cells       = _.toArray(dragElem.parentNode.cells),\n                rect;\n\n            this.coords = this.columns.map(function (column) {\n                var data,\n                    colIndex = _.findIndex(cells, function (cell) {\n                        return compareCols(cell, column);\n                    });\n\n                rect = column.getBoundingClientRect();\n\n                data = {\n                    index: colIndex,\n                    target: column,\n                    orig: rect,\n                    left: rect.left - bodyRect.left,\n                    right: rect.right - bodyRect.left,\n                    top: rect.top - bodyRect.top,\n                    bottom: container.bottom - bodyRect.top\n                };\n\n                if (column === dragElem) {\n                    this.dragArea = data;\n\n                    grabbed.shiftX = rect.left - grabbed.x;\n                    grabbed.shiftY = rect.top - grabbed.y;\n                }\n\n                return data;\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Creates clone of a target table with only specified column visible.\n         *\n         * @param {HTMLTableHeaderCellElement} elem - Dragging column.\n         * @returns {Dnd} Chainbale.\n         */\n        _cloneTable: function (elem) {\n            var clone       = this.table.cloneNode(true),\n                columnIndex = this._getColumnIndex(elem),\n                headRow     = clone.tHead.firstElementChild,\n                headCells   = _.toArray(headRow.cells),\n                tableBody   = clone.tBodies[0],\n                bodyRows    = _.toArray(tableBody.children),\n                origTrs     = this.table.tBodies[0].children;\n\n            clone.style.width = elem.offsetWidth + 'px';\n\n            headCells.forEach(function (th, index) {\n                if (index !== columnIndex) {\n                    headRow.removeChild(th);\n                }\n            });\n\n            headRow.cells[0].style.height = elem.offsetHeight + 'px';\n\n            bodyRows.forEach(function (row, rowIndex) {\n                var cells = row.cells,\n                    cell;\n\n                if (cells.length !== headCells.length) {\n                    tableBody.removeChild(row);\n\n                    return;\n                }\n\n                cell = row.cells[columnIndex].cloneNode(true);\n\n                while (row.firstElementChild) {\n                    row.removeChild(row.firstElementChild);\n                }\n\n                cell.style.height = origTrs[rowIndex].cells[columnIndex].offsetHeight + 'px';\n\n                row.appendChild(cell);\n            });\n\n            this.dragTable = clone;\n\n            $(clone)\n                .addClass('_dragging-copy')\n                .appendTo('body');\n\n            return this;\n        },\n\n        /**\n         * Matches provided coordinates to available areas.\n         *\n         * @param {Number} x - X coordinate of a mouse pointer.\n         * @param {Number} y - Y coordinate of a mouse pointer.\n         * @returns {Object|Undefined} Matched area.\n         */\n        _getDropArea: function (x, y) {\n            return _.find(this.coords, function (area) {\n                return isInside(x, y, area);\n            });\n        },\n\n        /**\n         * Updates state of hovered areas.\n         *\n         * @param {Number} x - X coordinate of a mouse pointer.\n         * @param {Number} y - Y coordinate of a mouse pointer.\n         */\n        _updateAreas: function (x, y) {\n            var leavedArea = this.dropArea,\n                area = this.dropArea = this._getDropArea(x, y);\n\n            if (leavedArea) {\n                this.dragleave(leavedArea);\n            }\n\n            if (area && !compareCols(area.target, this.dragArea.target)) {\n                this.dragenter(area);\n            }\n        },\n\n        /**\n         * Grab action handler.\n         *\n         * @param {Number} x - X coordinate of a grabbed point.\n         * @param {Number} y - Y coordinate of a grabbed point.\n         * @param {HTMLElement} elem - Grabbed element.\n         */\n        grab: function (x, y, elem) {\n            this.initDrag = true;\n\n            this.grabbed = {\n                x: x,\n                y: y,\n                elem: elem\n            };\n\n            this.$body.addClass(this.noSelectClass);\n        },\n\n        /**\n         * Dragstart action handler.\n         *\n         * @param {HTMLTableHeaderCellElement} elem - Element which is dragging.\n         */\n        dragstart: function (elem) {\n            this.initDrag = false;\n            this.dropArea = false;\n            this.dragging = true;\n\n            getModel(elem).dragging(true);\n\n            this._cacheCoords()\n                ._cloneTable(elem);\n        },\n\n        /**\n         * Drag action handler. Locates draggable\n         * grid at a specified coordinates.\n         *\n         * @param {Number} x - X coordinate.\n         * @param {Number} y - Y coordinate.\n         */\n        drag: function (x, y) {\n            var grabbed  = this.grabbed,\n                dragArea = this.dragArea,\n                posX     = x + grabbed.shiftX,\n                posY     = y + grabbed.shiftY;\n\n            if (this.fixedX) {\n                x    = dragArea.left;\n                posX = dragArea.orig.left;\n            }\n\n            if (this.fixedY) {\n                y    = dragArea.top;\n                posY = dragArea.orig.top;\n            }\n\n            locate(this.dragTable, posX, posY);\n\n            if (!isInside(x, y, this.dropArea)) {\n                this._updateAreas(x, y);\n            }\n        },\n\n        /**\n         * Dragenter action handler.\n         *\n         * @param {Object} dropArea\n         */\n        dragenter: function (dropArea) {\n            var direction = this.dragArea.index < dropArea.index ?\n                'left' :\n                'right';\n\n            getModel(dropArea.target).dragover = direction;\n        },\n\n        /**\n         * Dragleave action handler.\n         *\n         * @param {Object} dropArea\n         */\n        dragleave: function (dropArea) {\n            getModel(dropArea.target).dragover = false;\n        },\n\n        /**\n         * Dragend action handler.\n         *\n         * @param {Object} dragArea\n         */\n        dragend: function (dragArea) {\n            var dropArea = this.dropArea,\n                dragElem = dragArea.target;\n\n            this.dragging = false;\n\n            document.body.removeChild(this.dragTable);\n\n            getModel(dragElem).dragging(false);\n\n            if (dropArea && !compareCols(dropArea.target, dragElem)) {\n                this.drop(dropArea, dragArea);\n            }\n        },\n\n        /**\n         * Drop action handler.\n         *\n         * @param {Object} dropArea\n         * @param {Object} dragArea\n         */\n        drop: function (dropArea, dragArea) {\n            var dropModel = getModel(dropArea.target),\n                dragModel = getModel(dragArea.target);\n\n            getModel(this.table).insertChild(dragModel, dropModel);\n            dropModel.dragover = false;\n        },\n\n        /**\n         * Documents' 'mousemove' event handler.\n         *\n         * @param {(MouseEvent|TouchEvent)} e - Event object.\n         */\n        onMouseMove: function (e) {\n            var grab    = this.grabbed,\n                touch   = getTouch(e),\n                x       = touch.pageX,\n                y       = touch.pageY;\n\n            if (this.initDrag || this.dragging) {\n                e.preventDefault();\n            }\n\n            if (this.initDrag && distance(x, y, grab.x, grab.y) >= this.minDistance) {\n                this.dragstart(grab.elem);\n            }\n\n            if (this.dragging) {\n                this.drag(x, y);\n            }\n        },\n\n        /**\n         * Documents' 'mouseup' event handler.\n         */\n        onMouseUp: function () {\n            if (this.initDrag || this.dragging) {\n                this.initDrag = false;\n                this.$body.removeClass(this.noSelectClass);\n            }\n\n            if (this.dragging) {\n                this.dragend(this.dragArea);\n            }\n        },\n\n        /**\n         * Columns' 'mousedown' event handler.\n         *\n         * @param {(MouseEvent|TouchEvent)} e - Event object.\n         */\n        onMouseDown: function (e) {\n            var touch = getTouch(e);\n\n            this.grab(touch.pageX, touch.pageY, e.currentTarget);\n        }\n    });\n});\n","Magento_Ui/js/grid/export.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiElement'\n], function ($, _, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/exportButton',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            checked: '',\n            additionalParams: [],\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initChecked();\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n\n            _.each(this.additionalParams, function (value, key) {\n                key = 'additionalParams.' + key;\n                this.imports[key] = value;\n            }, this);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('checked');\n\n            return this;\n        },\n\n        /**\n         * Checks first option if checked not defined.\n         *\n         * @returns {Object}\n         */\n        initChecked: function () {\n            if (!this.checked()) {\n                this.checked(\n                    this.options[0].value\n                );\n            }\n\n            return this;\n        },\n\n        /**\n         * Compose params object that will be added to request.\n         *\n         * @returns {Object}\n         */\n        getParams: function () {\n            var selections = this.selections(),\n                data = selections ? selections.getSelections() : null,\n                itemsType,\n                result = {};\n\n            if (data) {\n                itemsType = data.excludeMode ? 'excluded' : 'selected';\n                result.filters = data.params.filters;\n                result.search = data.params.search;\n                result.namespace = data.params.namespace;\n                result[itemsType] = data[itemsType];\n                _.each(this.additionalParams, function (param, key) {\n                    result[key] = param;\n                });\n\n                if (!result[itemsType].length) {\n                    result[itemsType] = false;\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Find checked option.\n         *\n         * @returns {Object}\n         */\n        getActiveOption: function () {\n            return _.findWhere(this.options, {\n                value: this.checked()\n            });\n        },\n\n        /**\n         * Build option url.\n         *\n         * @param {Object} option\n         * @returns {String}\n         */\n        buildOptionUrl: function (option) {\n            var params = this.getParams();\n\n            if (!params) {\n                return 'javascript:void(0);';\n            }\n\n            return option.url + '?' + $.param(params);\n            //TODO: MAGETWO-40250\n        },\n\n        /**\n         * Redirect to built option url.\n         */\n        applyOption: function () {\n            var option = this.getActiveOption(),\n                url = this.buildOptionUrl(option);\n\n            location.href = url;\n\n        }\n    });\n});\n","Magento_Ui/js/grid/tree-massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/massactions'\n], function (ko, _, Massactions) {\n    'use strict';\n\n    return Massactions.extend({\n        defaults: {\n            template: 'ui/grid/tree-massactions',\n            submenuTemplate: 'ui/grid/submenu',\n            listens: {\n                opened: 'hideSubmenus'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .recursiveObserveActions(this.actions());\n\n            return this;\n        },\n\n        /**\n         * Recursive initializes observable actions.\n         *\n         * @param {Array} actions - Action objects.\n         * @param {String} [prefix] - An optional string that will be prepended\n         *      to the \"type\" field of all child actions.\n         * @returns {Massactions} Chainable.\n         */\n        recursiveObserveActions: function (actions, prefix) {\n            _.each(actions, function (action) {\n                if (prefix) {\n                    action.type = prefix + '.' + action.type;\n                }\n\n                if (action.actions) {\n                    action.visible = ko.observable(false);\n                    action.parent = actions;\n                    this.recursiveObserveActions(action.actions, action.type);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var action = this.getAction(actionIndex),\n                visibility;\n\n            if (action.visible) {\n                visibility = action.visible();\n\n                this.hideSubmenus(action.parent);\n                action.visible(!visibility);\n\n                return this;\n            }\n\n            return this._super(actionIndex);\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Array} actions - Action objects.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex, actions) {\n            var currentActions = actions || this.actions(),\n                result = false;\n\n            _.find(currentActions, function (action) {\n                if (action.type === actionIndex) {\n                    result = action;\n\n                    return true;\n                }\n\n                if (action.actions) {\n                    result = this.getAction(actionIndex, action.actions);\n\n                    return result;\n                }\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Recursive hide all sub folders in given array.\n         *\n         * @param {Array} actions - Action objects.\n         * @returns {Massactions} Chainable.\n         */\n        hideSubmenus: function (actions) {\n            var currentActions = actions || this.actions();\n\n            _.each(currentActions, function (action) {\n                if (action.visible && action.visible()) {\n                    action.visible(false);\n                }\n\n                if (action.actions) {\n                    this.hideSubmenus(action.actions);\n                }\n            }, this);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/resize.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'Magento_Ui/js/lib/knockout/extender/bound-nodes',\n    'uiElement'\n], function ($, ko, _, utils, registry, boundedNodes, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table.data-grid',\n            mainTableSelector: '[data-role=\"grid\"]',\n            columnSelector: '${ $.tableSelector } thead tr th',\n            fieldSelector: '${ $.tableSelector } tbody tr td',\n\n            imports: {\n                storageColumnsData: '${ $.storageConfig.path }.storageColumnsData'\n            },\n            storageColumnsData: {},\n            columnsElements: {},\n            tableWidth: 0,\n            sumColumnsWidth: 0,\n            showLines: 4,\n            resizableElementClass: 'shadow-div',\n            resizingColumnClass: '_resizing',\n            fixedLayoutClass: '_layout-fixed',\n            inResizeClass: '_in-resize',\n            visibleClass: '_resize-visible',\n            cellContentElement: 'div.data-grid-cell-content',\n            minColumnWidth: 40,\n            layoutFixedPolyfillIterator: 0,\n            windowResize: false,\n            resizable: false,\n            resizeConfig: {\n                maxRowsHeight: [],\n                curResizeElem: {},\n                depResizeElem: {},\n                previousWidth: null\n            }\n        },\n\n        /**\n         * Initialize application -\n         * binding functions context,\n         * set handlers for table elements\n         *\n         * @returns {Object} Chainable\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initTable',\n                'initColumn',\n                'mousedownHandler',\n                'mousemoveHandler',\n                'mouseupHandler',\n                'refreshLastColumn',\n                'refreshMaxRowHeight',\n                'preprocessingWidth',\n                '_eventProxy',\n                'checkAfterResize'\n            );\n\n            this._super();\n            this.observe(['maxRowsHeight']);\n            this.maxRowsHeight([]);\n\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.columnSelector, this.initColumn);\n\n            return this;\n        },\n\n        /**\n         * Set table element and adds handler to mousedown on headers\n         *\n         * @returns {Object} Chainable\n         */\n        initTable: function (table) {\n            if ($(table).is(this.mainTableSelector)) {\n                this.table = table;\n                this.tableWidth = $(table).outerWidth();\n                $(window).on('resize', this.checkAfterResize);\n            }\n\n            //TODO - Must be deleted when Firefox fixed problem with table-layout: fixed\n            //ticket to Firefox: https://bugs.webkit.org/show_bug.cgi?id=90068\n            if (navigator.userAgent.search(/Firefox/) > -1) {\n                this._layoutFixedPolyfill();\n            }\n\n            $(table).addClass(this.fixedLayoutClass);\n\n            return this;\n        },\n\n        /**\n         * Window resize handler,\n         * check changes on table width and\n         * set new width to variable\n         * after window resize start preprocessingWidth method\n         */\n        checkAfterResize: function () {\n            var tableWidth,\n                self = this;\n\n            setTimeout(function () {\n                tableWidth = $(self.table).outerWidth();\n\n                if (self.tableWidth !== tableWidth) {\n                    self.tableWidth = tableWidth;\n                } else {\n                    self.preprocessingWidth();\n                }\n            }, 300);\n        },\n\n        /**\n         * Check conditions to set minimal width\n         */\n        checkSumColumnsWidth: function () {\n            var table = $(this.table),\n                elems = table.find('th:not([style*=\"width: auto\"]):visible'),\n                elemsWidthMin = table.find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible'),\n                elemsWidthAuto = table.find('th[style*=\"width: auto\"]:visible'),\n                model;\n\n            this.sumColumnsWidth = 0;\n            _.each(elems, function (elem) {\n                model = ko.dataFor(elem);\n                model.width && model.width !== 'auto' ? this.sumColumnsWidth += model.width : false;\n            }, this);\n\n            if (\n                    this.sumColumnsWidth + elemsWidthAuto.length *\n                    this.minColumnWidth + elemsWidthMin.length *\n                    this.minColumnWidth > this.tableWidth\n            ) {\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Set minimal width to element with \"auto\" width\n         */\n        setWidthToColumnsWidthAuto: function () {\n            var elemsWidthAuto = $(this.table).find('th[style*=\"width: auto\"]:visible');\n\n            _.each(elemsWidthAuto, function (elem) {\n                $(elem).outerWidth(this.minColumnWidth - 1);\n            }, this);\n        },\n\n        /**\n         * Check conditions to set auto width\n         */\n        hasMinimal: function () {\n            var table = $(this.table),\n                elemsWidthMin = table.find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible'),\n                elemsWidthAuto = table.find('th[style*=\"width: auto\"]:visible');\n\n            if (\n                    elemsWidthAuto && this.sumColumnsWidth + elemsWidthAuto.length *\n                    this.minColumnWidth + elemsWidthMin.length * this.minColumnWidth + 5 < this.tableWidth\n            ) {\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Set \"auto\" width to element with minimal width\n         */\n        setAuto: function () {\n            var elemsWidthAuto = $(this.table).find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible');\n\n            _.each(elemsWidthAuto, function (elem) {\n                $(elem).outerWidth('auto');\n            }, this);\n        },\n\n        /**\n         * Check columns width and preprocessing\n         */\n        preprocessingWidth: function () {\n            if (this.checkSumColumnsWidth()) {\n                this.setWidthToColumnsWidthAuto();\n            } else if (this.hasMinimal()) {\n                this.setAuto();\n            }\n        },\n\n        /**\n         * Init columns elements,\n         * set width to current column element,\n         * add resizable element to columns header,\n         * check and add no-resize class to last column,\n         * stop parents events,\n         * add handler to visibility column\n         *\n         * @param {Object} column - columns header element (th)\n         */\n        initColumn: function (column) {\n            var model = ko.dataFor(column),\n                ctxIndex = this.getCtxIndex(ko.contextFor(column));\n\n            model.width = this.getDefaultWidth(column);\n\n            if (!this.hasColumn(model, ctxIndex, false)) {\n                this.columnsElements[model.index] = this.columnsElements[model.index] || {};\n                this.columnsElements[model.index][ctxIndex] = column;\n                this.initResizableElement(column);\n                this.setStopPropagationHandler(column);\n                $(column).outerWidth(model.width);\n            }\n\n            this.refreshLastColumn(column);\n            this.preprocessingWidth();\n\n            model.on('visible', this.refreshLastColumn.bind(this, column));\n            model.on('visible', this.preprocessingWidth.bind(this));\n        },\n\n        /**\n         * Hack for mozilla firefox\n         */\n        _layoutFixedPolyfill: function () {\n            var self = this;\n\n            setTimeout(function () {\n                if (self.layoutFixedPolyfillIterator < 20) {\n                    $(window).trigger('resize');\n                    self.layoutFixedPolyfillIterator++;\n                    self._layoutFixedPolyfill();\n                } else {\n                    return false;\n                }\n            }, 500);\n        },\n\n        /**\n         * Check element is resizable or not\n         * and append resizable element to DOM\n         *\n         * @param {Object} column - columns header element (th)\n         * @returns {Boolean}\n         */\n        initResizableElement: function (column) {\n            var model = ko.dataFor(column),\n                templateDragElement = '<div class=\"' + this.resizableElementClass + '\"></div>';\n\n            if (_.isUndefined(model.resizeEnabled) || model.resizeEnabled) {\n                $(column).append(templateDragElement);\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Check event target and if need stop parents event,\n         *\n         * @param {Object} column - columns header element (th)\n         * @returns {Boolean}\n         */\n        setStopPropagationHandler: function (column) {\n            var events,\n                click,\n                mousedown;\n\n            $(column).on('click', this._eventProxy);\n            $(column).on('mousedown', this._eventProxy);\n\n            events = $._data(column, 'events');\n\n            click = events.click;\n            mousedown = events.mousedown;\n            click.unshift(click.pop());\n            mousedown.unshift(mousedown.pop());\n\n            return this;\n        },\n\n        /**\n         * Check event target and stop event if need\n         *\n         * @param {Object} event\n         */\n        _eventProxy: function (event) {\n            if ($(event.target).is('.' + this.resizableElementClass)) {\n\n                if (event.type === 'click') {\n                    event.stopImmediatePropagation();\n                } else if (event.type === 'mousedown') {\n                    this.mousedownHandler(event);\n                }\n            }\n        },\n\n        /**\n         * Check visible columns and set disable class to resizable elements,\n         *\n         * @param {Object} column - columns header element (th)\n         */\n        refreshLastColumn: function (column) {\n            var i = 0,\n                columns = $(column).parent().children().not(':hidden'),\n                length = columns.length;\n\n            $('.' + this.visibleClass).removeClass(this.visibleClass);\n\n            $(column).parent().children().not(':hidden').last().addClass(this.visibleClass);\n\n            for (i; i < length; i++) {\n\n                if (!columns.eq(i).find('.' + this.resizableElementClass).length && i) {\n                    columns.eq(i - 1).addClass(this.visibleClass);\n                }\n            }\n\n        },\n\n        /**\n         * Refresh max height to row elements,\n         *\n         * @param {Object} elem - (td)\n         */\n        refreshMaxRowHeight: function (elem) {\n            var rowsH = this.maxRowsHeight(),\n                curEL = $(elem).find('div'),\n                height,\n                obj = this.hasRow($(elem).parent()[0], true);\n\n            curEL.css('white-space', 'nowrap');\n            height = curEL.height() * this.showLines;\n            curEL.css('white-space', 'normal');\n\n            if (obj) {\n                if (obj.maxHeight < height) {\n                    rowsH[_.indexOf(rowsH, obj)].maxHeight = height;\n                } else {\n                    return false;\n                }\n            } else {\n                rowsH.push({\n                    elem: $(elem).parent()[0],\n                    maxHeight: height\n                });\n            }\n\n            $(elem).parent().children().find(this.cellContentElement).css('max-height', height + 'px');\n            this.maxRowsHeight(rowsH);\n        },\n\n        /**\n         * Set resize class to elements when resizable\n         */\n        _setResizeClass: function () {\n            var rowElements = $(this.table).find('tr');\n\n            rowElements\n                .find('td:eq(' + this.resizeConfig.curResizeElem.ctx.$index() + ')')\n                .addClass(this.resizingColumnClass);\n            rowElements\n                .find('td:eq(' + this.resizeConfig.depResizeElem.ctx.$index() + ')')\n                .addClass(this.resizingColumnClass);\n        },\n\n        /**\n         * Remove resize class to elements when resizable\n         */\n        _removeResizeClass: function () {\n            var rowElements = $(this.table).find('tr');\n\n            rowElements\n                .find('td:eq(' + this.resizeConfig.curResizeElem.ctx.$index() + ')')\n                .removeClass(this.resizingColumnClass);\n            rowElements\n                .find('td:eq(' + this.resizeConfig.depResizeElem.ctx.$index() + ')')\n                .removeClass(this.resizingColumnClass);\n        },\n\n        /**\n         * Check conditions to resize\n         *\n         * @returns {Boolean}\n         */\n        _canResize: function (column) {\n            if (\n                $(column).hasClass(this.visibleClass) ||\n                !$(this.resizeConfig.depResizeElem.elems[0]).find('.' + this.resizableElementClass).length\n            ) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Mouse down event handler,\n         * find current and dep column to resize\n         *\n         * @param {Object} event\n         */\n        mousedownHandler: function (event) {\n            var target = event.target,\n                column = $(target).parent()[0],\n                cfg = this.resizeConfig,\n                body = $('body');\n\n            event.stopImmediatePropagation();\n            cfg.curResizeElem.model = ko.dataFor(column);\n            cfg.curResizeElem.ctx = ko.contextFor(column);\n            cfg.curResizeElem.elems = this.hasColumn(cfg.curResizeElem.model, false, true);\n            cfg.curResizeElem.position = event.pageX;\n            cfg.depResizeElem.elems = this.getNextElements(cfg.curResizeElem.elems[0]);\n            cfg.depResizeElem.model = ko.dataFor(cfg.depResizeElem.elems[0]);\n            cfg.depResizeElem.ctx = ko.contextFor(cfg.depResizeElem.elems[0]);\n\n            this._setResizeClass();\n\n            if (!this._canResize(column)) {\n                return false;\n            }\n\n            event.stopPropagation();\n            this.resizable = true;\n            cfg.curResizeElem.model.width = $(cfg.curResizeElem.elems[0]).outerWidth();\n            cfg.depResizeElem.model.width = $(cfg.depResizeElem.elems[0]).outerWidth();\n            body.addClass(this.inResizeClass);\n            body.on('mousemove', this.mousemoveHandler);\n            $(window).on('mouseup', this.mouseupHandler);\n        },\n\n        /**\n         * Mouse move event handler,\n         * change columns width\n         *\n         * @param {Object} event\n         */\n        mousemoveHandler: function (event) {\n            var cfg = this.resizeConfig,\n                width = event.pageX - cfg.curResizeElem.position,\n                self = this;\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            if (\n                this.resizable &&\n                this.minColumnWidth < cfg.curResizeElem.model.width + width &&\n                this.minColumnWidth < cfg.depResizeElem.model.width - width &&\n                cfg.previousWidth !== width\n            ) {\n                cfg.curResizeElem.model.width += width;\n                cfg.depResizeElem.model.width -= width;\n\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(cfg.curResizeElem.model.width);\n                });\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(cfg.depResizeElem.model.width);\n                });\n\n                cfg.previousWidth = width;\n                cfg.curResizeElem.position = event.pageX;\n            } else if (width <= -(cfg.curResizeElem.model.width - this.minColumnWidth)) {\n\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(self.minColumnWidth);\n                });\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(\n                    cfg.depResizeElem.model.width +\n                    cfg.curResizeElem.model.width -\n                    self.minColumnWidth);\n                });\n\n            } else if (width >= cfg.depResizeElem.model.width - this.minColumnWidth) {\n\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(self.minColumnWidth);\n                });\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(\n                        cfg.curResizeElem.model.width +\n                        cfg.depResizeElem.model.width -\n                        self.minColumnWidth\n                    );\n                });\n            }\n        },\n\n        /**\n         * Mouse up event handler,\n         * change columns width\n         *\n         * @param {Object} event\n         */\n        mouseupHandler: function (event) {\n            var cfg = this.resizeConfig,\n                body = $('body');\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            this._removeResizeClass();\n            this.storageColumnsData[cfg.curResizeElem.model.index] = cfg.curResizeElem.model.width;\n            this.storageColumnsData[cfg.depResizeElem.model.index] = cfg.depResizeElem.model.width;\n            this.resizable = false;\n\n            this.store('storageColumnsData');\n\n            body.removeClass(this.inResizeClass);\n            body.off('mousemove', this.mousemoveHandler);\n            $(window).off('mouseup', this.mouseupHandler);\n        },\n\n        /**\n         * Find dependency element\n         *\n         * @param {Object} element - current element\n         * @returns {Object} next element data\n         */\n        getNextElements: function (element) {\n            var nextElem = $(element).next()[0],\n                nextElemModel = ko.dataFor(nextElem),\n                nextElemData = this.hasColumn(nextElemModel, false, true);\n\n            if (nextElemData) {\n                if (nextElemModel.visible) {\n                    return nextElemData;\n                }\n\n                return this.getNextElements(nextElem);\n            }\n        },\n\n        /**\n         * Get default width\n         *\n         * @param {Object} column - (th) element\n         * @return {String} width for current column\n         */\n        getDefaultWidth: function (column) {\n            var model = ko.dataFor(column);\n\n            if (this.storageColumnsData[model.index]) {\n                return this.storageColumnsData[model.index];\n            }\n\n            if (model.resizeDefaultWidth) {\n                return parseInt(model.resizeDefaultWidth, 10);\n            }\n\n            return 'auto';\n        },\n\n        /**\n         * Check column is render or not\n         *\n         * @param {Object} model - cur column model\n         * @param {String|Boolean} ctxIndex - index of context, or false, if want to get cols from all ctx\n         * @param {Boolean} returned - need return column object or not\n         * @return {Boolean} if returned param is false, returned boolean value, else return current object data\n         */\n        hasColumn: function (model, ctxIndex, returned) {\n            var colElem = this.columnsElements[model.index] || {},\n                getFromAllCtx = ctxIndex === false;\n\n            if (colElem && (getFromAllCtx || colElem.hasOwnProperty(ctxIndex))) {\n\n                if (returned) {\n                    return getFromAllCtx ?\n                        _.values(colElem) :\n                        colElem[ctxIndex];\n                }\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Check row is render or not\n         *\n         * @param {Object} elem - cur column element\n         * @param {Boolean} returned - need return column object or not\n         * @return {Boolean|Object} if returned param is false, returned boolean value, else return current object data\n         */\n        hasRow: function (elem, returned) {\n            var i = 0,\n                el = this.maxRowsHeight(),\n                length = el.length;\n\n            for (i; i < length; i++) {\n                if (this.maxRowsHeight()[i].elem === elem) {\n                    if (returned) {//eslint-disable-line max-depth\n                        return this.maxRowsHeight()[i];\n                    }\n\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Generate index that will identify context\n         *\n         * @param {Object} ctx\n         * @return {String}\n         */\n        getCtxIndex: function (ctx) {\n            return ctx ? ctx.$parents.reduce(function (pv, cv) {\n                return (pv.index || pv) + (cv || {}).index;\n            }) : ctx;\n        }\n    });\n});\n","Magento_Ui/js/grid/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            cacheRequests: true,\n            cachedRequestDelay: 50,\n            indexField: 'entity_id',\n            requestConfig: {\n                url: '${ $.updateUrl }',\n                method: 'GET',\n                dataType: 'json'\n            },\n            dataScope: '',\n            data: {}\n        },\n\n        /**\n         * Initializes dataStorage configuration.\n         *\n         * @returns {DataStorage} Chainable.\n         */\n        initConfig: function () {\n            var scope;\n\n            this._super();\n\n            scope = this.dataScope;\n\n            if (typeof scope === 'string') {\n                this.dataScope = scope ? [scope] : [];\n            }\n\n            this._requests = [];\n\n            return this;\n        },\n\n        /**\n         * Extracts data which matches specified set of identifiers.\n         *\n         * @param {Array} ids - Records identifiers.\n         * @returns {Array|Boolean}\n         */\n        getByIds: function (ids) {\n            var result = [],\n                hasData;\n\n            hasData = ids.every(function (id) {\n                var item = this.data[id];\n\n                return item ? result.push(item) : false;\n            }, this);\n\n            return hasData ? result : false;\n        },\n\n        /**\n         * Extracts identifiers of provided records.\n         * If no records were provided then full list of\n         * current data id's will be returned.\n         *\n         * @param {Object|Array} [data=this.data]\n         * @returns {Array}\n         */\n        getIds: function (data) {\n            data = data || this.data;\n\n            return _.pluck(data, this.indexField);\n        },\n\n        /**\n         * Extracts data which matches specified parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @param {Object} [options={}]\n         * @returns {jQueryPromise}\n         */\n        getData: function (params, options) {\n            var cachedRequest;\n\n            if (this.hasScopeChanged(params)) {\n                this.clearRequests();\n            } else {\n                cachedRequest = this.getRequest(params);\n            }\n\n            options = options || {};\n\n            return !options.refresh && cachedRequest ?\n                this.getRequestData(cachedRequest) :\n                this.requestData(params);\n        },\n\n        /**\n         * Tells whether one of the parameters defined in the \"dataScope\" has\n         * changed since the last request.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {Boolean}\n         */\n        hasScopeChanged: function (params) {\n            var lastRequest = _.last(this._requests),\n                keys,\n                diff;\n\n            if (!lastRequest) {\n                return false;\n            }\n\n            diff = utils.compare(lastRequest.params, params);\n\n            keys = _.pluck(diff.changes, 'path');\n            keys = keys.concat(Object.keys(diff.containers));\n\n            return _.intersection(this.dataScope, keys).length > 0;\n        },\n\n        /**\n         * Extends records of current data object\n         * with the provided records collection.\n         *\n         * @param {Array} data - An array of records.\n         * @returns {DataStorage} Chainable.\n         */\n        updateData: function (data) {\n            var records = _.indexBy(data || [], this.indexField);\n\n            _.extend(this.data, records);\n\n            return this;\n        },\n\n        /**\n         * Sends request to the server with provided parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {jQueryPromise}\n         */\n        requestData: function (params) {\n            var query = utils.copy(params),\n                handler = this.onRequestComplete.bind(this, query),\n                request;\n\n            this.requestConfig.data = query;\n            request = $.ajax(this.requestConfig).done(handler);\n\n            return request;\n        },\n\n        /**\n         * Returns request's instance which\n         * contains provided parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {Object} Instance of request.\n         */\n        getRequest: function (params) {\n            return _.find(this._requests, function (request) {\n                return _.isEqual(params, request.params);\n            }, this);\n        },\n\n        /**\n         * Forms data object associated with provided request.\n         *\n         * @param {Object} request - Request object.\n         * @returns {jQueryPromise}\n         */\n        getRequestData: function (request) {\n            var defer = $.Deferred(),\n                resolve = defer.resolve.bind(defer),\n                delay = this.cachedRequestDelay,\n                result;\n\n            if (request.showTotalRecords === undefined) {\n                request.showTotalRecords = true;\n            }\n\n            result = {\n                items: this.getByIds(request.ids),\n                totalRecords: request.totalRecords,\n                showTotalRecords: request.showTotalRecords,\n                errorMessage: request.errorMessage\n            };\n\n            delay ?\n                _.delay(resolve, delay, result) :\n                resolve(result);\n\n            return defer.promise();\n        },\n\n        /**\n         * Caches requests object with provided parameters\n         * and data object associated with it.\n         *\n         * @param {Object} data - Data associated with request.\n         * @param {Object} params - Request parameters.\n         * @returns {DataStorage} Chainable.\n         */\n        cacheRequest: function (data, params) {\n            var cached = this.getRequest(params);\n\n            if (cached) {\n                this.removeRequest(cached);\n            }\n\n            if (data.showTotalRecords === undefined) {\n                data.showTotalRecords = true;\n            }\n\n            this._requests.push({\n                ids: this.getIds(data.items),\n                params: params,\n                totalRecords: data.totalRecords,\n                showTotalRecords: data.showTotalRecords,\n                errorMessage: data.errorMessage\n            });\n\n            return this;\n        },\n\n        /**\n         * Clears all cached requests.\n         *\n         * @returns {DataStorage} Chainable.\n         */\n        clearRequests: function () {\n            this._requests.splice(0);\n\n            return this;\n        },\n\n        /**\n         * Removes provided request object from cached requests list.\n         *\n         * @param {Object} request - Request object.\n         * @returns {DataStorage} Chainable.\n         */\n        removeRequest: function (request) {\n            var requests = this._requests,\n                index = requests.indexOf(request);\n\n            if (~index) {\n                requests.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if request with a specified parameters was cached.\n         *\n         * @param {Object} params - Parameters of the request.\n         * @returns {Boolean}\n         */\n        wasRequested: function (params) {\n            return !!this.getRequest(params);\n        },\n\n        /**\n         * Handles successful data request.\n         *\n         * @param {Object} params - Request parameters.\n         * @param {Object} data - Response data.\n         */\n        onRequestComplete: function (params, data) {\n            this.updateData(data.items);\n\n            if (this.cacheRequests) {\n                this.cacheRequest(data, params);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function (_, registry, utils, Collapsible, confirm, alert, $t) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            template: 'ui/grid/actions',\n            stickyTmpl: 'ui/grid/sticky/actions',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            actions: [],\n            noItemsMsg: $t('You haven\\'t selected any items!'),\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('actions');\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var data = this.getSelections(),\n                action,\n                callback;\n\n            if (!data.total) {\n                alert({\n                    content: this.noItemsMsg\n                });\n\n                return this;\n            }\n\n            action   = this.getAction(actionIndex);\n            callback = this._getCallback(action, data);\n\n            action.confirm ?\n                this._confirm(action, callback) :\n                callback();\n\n            return this;\n        },\n\n        /**\n         * Retrieves selections data from the selections provider.\n         *\n         * @returns {Object|Undefined}\n         */\n        getSelections: function () {\n            var provider = this.selections(),\n                selections = provider && provider.getSelections();\n\n            return selections;\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex) {\n            return _.findWhere(this.actions(), {\n                type: actionIndex\n            });\n        },\n\n        /**\n         * Adds new action. If action with a specified identifier\n         * already exists, than the original one will be overrided.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Massactions} Chainable.\n         */\n        addAction: function (action) {\n            var actions = this.actions(),\n                index = _.findIndex(actions, {\n                    type: action.type\n                });\n\n            ~index ?\n                actions[index] = action :\n                actions.push(action);\n\n            this.actions(actions);\n\n            return this;\n        },\n\n        /**\n         * Creates action callback based on its' data. If action doesn't spicify\n         * a callback function than the default one will be used.\n         *\n         * @private\n         * @param {Object} action - Actions' object.\n         * @param {Object} selections - Selections data.\n         * @returns {Function} Callback function.\n         */\n        _getCallback: function (action, selections) {\n            var callback = action.callback,\n                args     = [action, selections];\n\n            if (utils.isObject(callback)) {\n                args.unshift(callback.target);\n\n                callback = registry.async(callback.provider);\n            } else if (typeof callback != 'function') {\n                callback = this.defaultCallback.bind(this);\n            }\n\n            return function () {\n                callback.apply(null, args);\n            };\n        },\n\n        /**\n         * Default action callback. Sends selections data\n         * via POST request.\n         *\n         * @param {Object} action - Action data.\n         * @param {Object} data - Selections data.\n         */\n        defaultCallback: function (action, data) {\n            var itemsType = data.excludeMode ? 'excluded' : 'selected',\n                selections = {};\n\n            selections[itemsType] = data[itemsType];\n\n            if (!selections[itemsType].length) {\n                selections[itemsType] = false;\n            }\n\n            _.extend(selections, data.params || {});\n\n            utils.submit({\n                url: action.url,\n                data: selections\n            });\n        },\n\n        /**\n         * Shows actions' confirmation window.\n         *\n         * @param {Object} action - Actions' data.\n         * @param {Function} callback - Callback that will be\n         *      invoked if action is confirmed.\n         */\n        _confirm: function (action, callback) {\n            var confirmData = action.confirm,\n                data = this.getSelections(),\n                total = data.total ? data.total : 0,\n                confirmMessage = confirmData.message + (data.showTotalRecords || data.showTotalRecords === undefined ?\n                    ' (' + total + ' record' + (total > 1 ? 's' : '') + ')'\n                    : '');\n\n            confirm({\n                title: confirmData.title,\n                content: confirmMessage,\n                actions: {\n                    confirm: callback\n                }\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/toolbar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'rjsResolver',\n    'uiCollection'\n], function (_, $, raf, resolver, Collection) {\n    'use strict';\n\n    var transformProp;\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.documentElement.style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform != 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] != 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    /**\n     * Moves specified DOM element to the x and y coordinates.\n     *\n     * @param {HTMLElement} elem - Element to be relocated.\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     */\n    function locate(elem, x, y) {\n        var value = 'translate(' + x + 'px,' + y + 'px)';\n\n        elem.style[transformProp] = value;\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/toolbar',\n            stickyTmpl: 'ui/grid/sticky/sticky',\n            tableSelector: 'table',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            refreshFPS: 15,\n            sticky: false,\n            visible: false,\n            _resized: true,\n            _scrolled: true,\n            _tableScrolled: true,\n            _requiredNodes: {\n                '$stickyToolbar': true,\n                '$stickyTable': true,\n                '$table': true,\n                '$sticky': true\n            },\n            stickyClass: {\n                'sticky-header': true\n            }\n        },\n\n        /**\n         * Initializes sticky toolbar component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            if (this.sticky) {\n                this.waitDOMElements()\n                    .then(this.run.bind(this));\n            }\n\n            return this;\n        },\n\n        /**\n         * Establishes DOM elements wait process.\n         *\n         * @returns {jQueryPromise} Promise which will be resolved\n         *      when all of the required DOM elements are defined.\n         */\n        waitDOMElements: function () {\n            var _domPromise = $.Deferred();\n\n            _.bindAll(this, 'setStickyTable', 'setTableNode');\n\n            $.async({\n                ctx: ':not([data-role=\"sticky-el-root\"])',\n                component: this.columnsProvider,\n                selector: this.tableSelector\n            }, this.setTableNode);\n\n            $.async({\n                ctx: '[data-role=\"sticky-el-root\"]',\n                component: this.columnsProvider,\n                selector: this.tableSelector\n            }, this.setStickyTable);\n\n            this._domPromise = _domPromise;\n\n            return _domPromise.promise();\n        },\n\n        /**\n         * Defines left caption element.\n         *\n         * @param {HTMLElement} node\n         */\n        setLeftCap: function (node) {\n            this.$leftCap = node;\n        },\n\n        /**\n         * Defines right caption element.\n         *\n         * @param {HTMLElement} node\n         */\n        setRightCap: function (node) {\n            this.$rightCap = node;\n        },\n\n        /**\n         * Defines original table element.\n         *\n         * @param {HTMLTableElement} node\n         */\n        setTableNode: function (node) {\n            this.$cols = node.tHead.children[0].cells;\n            this.$tableContainer = node.parentNode;\n\n            this.setNode('$table', node);\n        },\n\n        /**\n         * Defines sticky table element.\n         *\n         * @param {HTMLTableElement} node\n         */\n        setStickyTable: function (node) {\n            this.$stickyCols = node.tHead.children[0].cells;\n\n            this.setNode('$stickyTable', node);\n        },\n\n        /**\n         * Defines sticky toolbar node.\n         *\n         * @param {HTMLElement} node\n         */\n        setStickyToolbarNode: function (node) {\n            this.setNode('$stickyToolbar', node);\n        },\n\n        /**\n         * Defines sticky element container.\n         *\n         * @param {HTMLElement} node\n         */\n        setStickyNode: function (node) {\n            this.setNode('$sticky', node);\n        },\n\n        /**\n         * Defines toolbar element container.\n         *\n         * @param {HTMLElement} node\n         */\n        setToolbarNode: function (node) {\n            this.$toolbar = node;\n        },\n\n        /**\n         * Sets provided node as a value of 'key' property and\n         * performs check for required DOM elements.\n         *\n         * @param {String} key - Properties key.\n         * @param {HTMLElement} node - DOM element.\n         */\n        setNode: function (key, node) {\n            var nodes = this._requiredNodes,\n                promise = this._domPromise,\n                defined;\n\n            this[key] = node;\n\n            defined = _.every(nodes, function (enabled, name) {\n                return enabled ? this[name] : true;\n            }, this);\n\n            if (defined) {\n                resolver(promise.resolve, promise);\n            }\n        },\n\n        /**\n         * Starts refresh process of the sticky element\n         * and assigns DOM elements events handlers.\n         */\n        run: function () {\n            _.bindAll(\n                this,\n                'refresh',\n                '_onWindowResize',\n                '_onWindowScroll',\n                '_onTableScroll'\n            );\n\n            $(window).on({\n                scroll: this._onWindowScroll,\n                resize: this._onWindowResize\n            });\n\n            $(this.$tableContainer).on('scroll', this._onTableScroll);\n\n            this.refresh();\n            this.checkTableWidth();\n        },\n\n        /**\n         * Refreshes state of the sticky element and\n         * invokes DOM elements events handlers\n         * if corresponding event has been triggered.\n         */\n        refresh: function () {\n            if (!raf(this.refresh, this.refreshFPS)) {\n                return;\n            }\n\n            if (this._scrolled) {\n                this.onWindowScroll();\n            }\n\n            if (this._tableScrolled) {\n                this.onTableScroll();\n            }\n\n            if (this._resized) {\n                this.onWindowResize();\n            }\n\n            if (this.visible) {\n                this.checkTableWidth();\n            }\n        },\n\n        /**\n         * Shows sticky toolbar.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        show: function () {\n            this.visible = true;\n            //Check admin grid button has addedr not\n            if ($('.page-main-actions').length === 0) {\n                this.$sticky.style.top = 0;\n            }\n            this.$sticky.style.display = '';\n            this.$toolbar.style.visibility = 'hidden';\n\n            return this;\n        },\n\n        /**\n         * Hides sticky toolbar.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        hide: function () {\n            this.visible = false;\n\n            this.$sticky.style.display = 'none';\n            this.$toolbar.style.visibility = '';\n\n            return this;\n        },\n\n        /**\n         * Checks if sticky toolbar covers original elements.\n         *\n         * @returns {Boolean}\n         */\n        isCovered: function () {\n            var stickyTop = this._stickyTableTop + this._wScrollTop;\n\n            return stickyTop > this._tableTop;\n        },\n\n        /**\n         * Updates offset of the sticky table element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateStickyTableOffset: function () {\n            var style,\n                top;\n\n            if (this.visible) {\n                top = this.$stickyTable.getBoundingClientRect().top;\n            } else {\n                style = this.$sticky.style;\n\n                style.visibility = 'hidden';\n                style.display = '';\n\n                top = this.$stickyTable.getBoundingClientRect().top;\n\n                style.display = 'none';\n                style.visibility = '';\n            }\n\n            this._stickyTableTop = top;\n\n            return this;\n        },\n\n        /**\n         * Updates offset of the original table element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableOffset: function () {\n            var box = this.$table.getBoundingClientRect(),\n                top = box.top + this._wScrollTop;\n\n            if (this._tableTop !== top) {\n                this._tableTop = top;\n\n                this.onTableTopChange(top);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if width of the table or it's columns has changed.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        checkTableWidth: function () {\n            var cols        = this.$cols,\n                total       = cols.length,\n                rightBorder = cols[total - 2].offsetLeft,\n                tableWidth  = this.$table.offsetWidth;\n\n            if (this._tableWidth !== tableWidth) {\n                this._tableWidth = tableWidth;\n\n                this.onTableWidthChange(tableWidth);\n            }\n\n            if (this._rightBorder !== rightBorder) {\n                this._rightBorder = rightBorder;\n\n                this.onColumnsWidthChange();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates width of the sticky table.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableWidth: function () {\n            this.$stickyTable.style.width = this._tableWidth + 'px';\n\n            if (this._tableWidth < this._toolbarWidth) {\n                this.checkToolbarSize();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates width of the sticky columns.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateColumnsWidth: function () {\n            var cols        = this.$cols,\n                index       = cols.length,\n                stickyCols  = this.$stickyCols;\n\n            while (index--) {\n                stickyCols[index].width = cols[index].offsetWidth;\n            }\n\n            return this;\n        },\n\n        /**\n         * Upadates size of the sticky toolbar element\n         * and invokes corresponding 'change' event handlers.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        checkToolbarSize: function () {\n            var width = this.$tableContainer.offsetWidth;\n\n            if (this._toolbarWidth !== width) {\n                this._toolbarWidth = width;\n\n                this.onToolbarWidthChange(width);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sticky toolbar visibility if it's necessary.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateVisibility: function () {\n            if (this.visible !== this.isCovered()) {\n                this.visible ? this.hide() : this.show();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates position of the left cover area.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateLeftCap: function () {\n            locate(this.$leftCap, -this._wScrollLeft, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates position of the right cover area.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateRightCap: function () {\n            var left = this._toolbarWidth - this._wScrollLeft;\n\n            locate(this.$rightCap, left, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates position of the sticky table.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableScroll: function () {\n            var container = this.$tableContainer,\n                left = container.scrollLeft + this._wScrollLeft;\n\n            locate(this.$stickyTable, -left, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates width of the toolbar element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateToolbarWidth: function () {\n            this.$stickyToolbar.style.width = this._toolbarWidth + 'px';\n\n            return this;\n        },\n\n        /**\n         * Handles changes of the toolbar element's width.\n         */\n        onToolbarWidthChange: function () {\n            this.updateToolbarWidth()\n                .updateRightCap();\n        },\n\n        /**\n         * Handles changes of the table top position.\n         */\n        onTableTopChange: function () {\n            this.updateStickyTableOffset();\n        },\n\n        /**\n         * Handles change of the table width.\n         */\n        onTableWidthChange: function () {\n            this.updateTableWidth();\n        },\n\n        /**\n         * Handles change of the table columns width.\n         */\n        onColumnsWidthChange: function () {\n            this.updateColumnsWidth();\n        },\n\n        /**\n         * Handles changes of the window's size.\n         */\n        onWindowResize: function () {\n            this.checkToolbarSize();\n\n            this._resized = false;\n        },\n\n        /**\n         * Handles changes of the original table scroll position.\n         */\n        onTableScroll: function () {\n            this.updateTableScroll();\n\n            this._tableScrolled = false;\n        },\n\n        /**\n         * Handles changes of window's scroll position.\n         */\n        onWindowScroll: function () {\n            var scrollTop = window.pageYOffset,\n                scrollLeft = window.pageXOffset;\n\n            if (this._wScrollTop !== scrollTop) {\n                this._wScrollTop = scrollTop;\n\n                this.onWindowScrollTop(scrollTop);\n            }\n\n            if (this._wScrollLeft !== scrollLeft) {\n                this._wScrollLeft = scrollLeft;\n\n                this.onWindowScrollLeft(scrollLeft);\n            }\n\n            this._scrolled = false;\n        },\n\n        /**\n         * Handles changes of windows' top scroll position.\n         */\n        onWindowScrollTop: function () {\n            this.updateTableOffset()\n                .updateVisibility();\n        },\n\n        /**\n         * Handles changes of windows' left scroll position.\n         */\n        onWindowScrollLeft: function () {\n            this.updateRightCap()\n                .updateLeftCap()\n                .updateTableScroll();\n        },\n\n        /**\n         * Original window 'scroll' event handler.\n         * Sets 'scrolled' flag to 'true'.\n         *\n         * @private\n         */\n        _onWindowScroll: function () {\n            this._scrolled = true;\n        },\n\n        /**\n         * Original window 'resize' event handler.\n         * Sets 'resized' flag to 'true'.\n         *\n         * @private\n         */\n        _onWindowResize: function () {\n            this._resized = true;\n        },\n\n        /**\n         * Original table 'scroll' event handler.\n         * Sets '_tableScrolled' flag to 'true'.\n         *\n         * @private\n         */\n        _onTableScroll: function () {\n            this._tableScrolled = true;\n        }\n    });\n});\n","Magento_Ui/js/grid/masonry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/listing',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'jquery',\n    'ko',\n    'underscore'\n], function (Listing, raf, $, ko, _) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            template: 'ui/grid/masonry',\n            imports: {\n                rows: '${ $.provider }:data.items',\n                errorMessage: '${ $.provider }:data.errorMessage'\n            },\n            listens: {\n                rows: 'initComponent'\n            },\n\n            /**\n             * Images container id\n             * @param string\n             */\n            containerId: null,\n\n            /**\n             * Minimum aspect ratio for each image\n             * @param int\n             */\n            minRatio: null,\n\n            /**\n             * Container width\n             * @param int\n             */\n            containerWidth: window.innerWidth,\n\n            /**\n             * Margin between images\n             * @param int\n             */\n            imageMargin: 20,\n\n            /**\n             * Maximum image height value\n             * @param int\n             */\n            maxImageHeight: 240,\n\n            /**\n             * The value is minimum image width to height ratio when container width is less than the key\n             * @param {Object}\n             */\n            containerWidthToMinRatio: {\n                640: 3,\n                1280: 5,\n                1920: 8\n            },\n\n            /**\n             * Default minimal image width to height ratio.\n             * Applied when container width is greater than max width in the containerWidthToMinRatio matrix.\n             * @param int\n             */\n            defaultMinRatio: 10,\n\n            /**\n             * Layout update FPS during window resizing\n             */\n            refreshFPS: 60\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'rows',\n                    'errorMessage'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init component handler\n         * @param {Object} rows\n         * @return {Object}\n         */\n        initComponent: function (rows) {\n            if (!rows.length) {\n                return;\n            }\n            this.imageMargin = parseInt(this.imageMargin, 10);\n            this.container = $('[data-id=\"' + this.containerId + '\"]')[0];\n\n            this.setLayoutStyles();\n            this.setEventListener();\n\n            return this;\n        },\n\n        /**\n         * Set event listener to track resize event\n         */\n        setEventListener: function () {\n            window.addEventListener('resize', function () {\n                this.updateStyles();\n            }.bind(this));\n        },\n\n        /**\n         * Updates styles for component.\n         */\n        updateStyles: function () {\n            raf(function () {\n                this.containerWidth = window.innerWidth;\n                this.setLayoutStyles();\n            }.bind(this), this.refreshFPS);\n        },\n\n        /**\n         * Set layout styles inside the container\n         */\n        setLayoutStyles: function () {\n            var containerWidth = parseInt(this.container.clientWidth, 10),\n                rowImages = [],\n                ratio = 0,\n                rowHeight = 0,\n                calcHeight = 0,\n                isLastRow = false,\n                rowNumber = 1;\n\n            this.setMinRatio();\n\n            this.rows().forEach(function (image, index) {\n                ratio += parseFloat((image.width / image.height).toFixed(2));\n                rowImages.push(image);\n\n                if (ratio < this.minRatio && index + 1 !== this.rows().length) {\n                    // Row has more space for images and the image is not the last one - proceed to the next iteration\n                    return;\n                }\n\n                ratio = Math.max(ratio, this.minRatio);\n                calcHeight = (containerWidth - this.imageMargin * rowImages.length) / ratio;\n                rowHeight = calcHeight < this.maxImageHeight ? calcHeight : this.maxImageHeight;\n                isLastRow = index + 1 === this.rows().length;\n\n                this.assignImagesToRow(rowImages, rowNumber, rowHeight, isLastRow);\n\n                rowImages = [];\n                ratio = 0;\n                rowNumber++;\n\n            }.bind(this));\n        },\n\n        /**\n         * Apply styles, css classes and add properties for images in the row\n         *\n         * @param {Object[]} images\n         * @param {Number} rowNumber\n         * @param {Number} rowHeight\n         * @param {Boolean} isLastRow\n         */\n        assignImagesToRow: function (images, rowNumber, rowHeight, isLastRow) {\n            var imageWidth;\n\n            images.forEach(function (img) {\n                imageWidth = rowHeight * (img.width / img.height).toFixed(2);\n                this.setImageStyles(img, imageWidth, rowHeight);\n                this.setImageClass(img, {\n                    bottom: isLastRow\n                });\n                img.rowNumber = rowNumber;\n            }.bind(this));\n\n            images[0].firstInRow = true;\n            images[images.length - 1].lastInRow = true;\n        },\n\n        /**\n         * Wait for container to initialize\n         */\n        waitForContainer: function (callback) {\n            if (typeof this.container === 'undefined') {\n                setTimeout(function () {\n                    this.waitForContainer(callback);\n                }.bind(this), 500);\n            } else {\n                setTimeout(callback, 0);\n            }\n        },\n\n        /**\n         * Set layout styles when container element is loaded.\n         */\n        setLayoutStylesWhenLoaded: function () {\n            this.waitForContainer(function () {\n                this.setLayoutStyles();\n            }.bind(this));\n        },\n\n        /**\n         * Set styles for every image in layout\n         *\n         * @param {Object} img\n         * @param {Number} width\n         * @param {Number} height\n         */\n        setImageStyles: function (img, width, height) {\n            if (!img.styles) {\n                img.styles = ko.observable();\n            }\n            img.styles({\n                width: parseInt(width, 10) + 'px',\n                height: parseInt(height, 10) + 'px'\n            });\n        },\n\n        /**\n         * Set css classes to and an image\n         *\n         * @param {Object} image\n         * @param {Object} classes\n         */\n        setImageClass: function (image, classes) {\n            if (!image.css) {\n                image.css = ko.observable(classes);\n            }\n            image.css(classes);\n        },\n\n        /**\n         * Set min ratio for images in layout\n         */\n        setMinRatio: function () {\n            var minRatio = _.find(\n                this.containerWidthToMinRatio,\n\n                /**\n                 * Find the minimal ratio for container width in the matrix\n                 *\n                 * @param {Number} ratio\n                 * @param {Number} width\n                 * @returns {Boolean}\n                 */\n                function (ratio, width) {\n                    return this.containerWidth <= width;\n                },\n                this\n            );\n\n            this.minRatio = minRatio ? minRatio : this.defaultMinRatio;\n        },\n\n        /**\n         * Checks if grid has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.rows() && !!this.rows().length;\n        },\n\n        /**\n         * Returns error message returned by the data provider\n         *\n         * @returns {String|null}\n         */\n        getErrorMessageUnsanitizedHtml: function () {\n            return this.errorMessage();\n        }\n    });\n});\n","Magento_Ui/js/grid/url-filter-applier.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'underscore',\n    'jquery'\n], function (Component, _, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            listingNamespace: null,\n            bookmarkProvider: 'componentType = bookmark, ns = ${ $.listingNamespace }',\n            filterProvider: 'componentType = filters, ns = ${ $.listingNamespace }',\n            filterKey: 'filters',\n            searchString: location.search,\n            modules: {\n                bookmarks: '${ $.bookmarkProvider }',\n                filterComponent: '${ $.filterProvider }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n            this.apply();\n\n            return this;\n        },\n\n        /**\n         * Apply filter\n         */\n        apply: function () {\n            var urlFilter = this.getFilterParam(this.searchString),\n                applied,\n                filters;\n\n            if (_.isUndefined(this.filterComponent())) {\n                setTimeout(function () {\n                    this.apply();\n                }.bind(this), 100);\n\n                return;\n            }\n\n            if (!_.isUndefined(this.bookmarks())) {\n                if (!_.size(this.bookmarks().getViewData(this.bookmarks().defaultIndex))) {\n                    setTimeout(function () {\n                        this.apply();\n                    }.bind(this), 500);\n\n                    return;\n                }\n            }\n\n            if (Object.keys(urlFilter).length) {\n                applied = this.filterComponent().get('applied');\n                filters = $.extend({}, applied, urlFilter);\n                this.filterComponent().set('applied', filters);\n            }\n        },\n\n        /**\n         * Get filter param from url\n         *\n         * @returns {Object}\n         */\n        getFilterParam: function (url) {\n            var searchString = decodeURI(url),\n                itemArray;\n\n            return _.chain(searchString.slice(1).split('&'))\n                .map(function (item) {\n\n                    if (item && item.search(this.filterKey) !== -1) {\n                        itemArray = item.split('=');\n\n                        if (itemArray[1].search('\\\\[') === 0) {\n                            itemArray[1] = itemArray[1].replace(/[\\[\\]]/g, '').split(',');\n                        }\n\n                        itemArray[0] = itemArray[0].replace(this.filterKey, '')\n                                .replace(/[\\[\\]]/g, '');\n\n                        return itemArray;\n                    }\n                }.bind(this))\n                .compact()\n                .object()\n                .value();\n        }\n    });\n});\n","Magento_Ui/js/grid/cells/sanitizedHtml.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'escaper'\n], function (Column, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getSafeHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        },\n\n        /**\n         * UnsanitizedHtml version of getSafeHtml.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getSafeUnsanitizedHtml: function (label) {\n            return this.getSafeHtml(label);\n        }\n    });\n});\n","Magento_Ui/js/grid/search/search.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mage/translate',\n    'mageUtils',\n    'uiElement',\n    'jquery'\n], function (_, layout, $t, utils, Element, $) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/search/search',\n            placeholder: $t('Search by keyword'),\n            label: $t('Keyword'),\n            value: '',\n            keywordUpdated: false,\n            previews: [],\n            chipsProvider: 'componentType = filtersChips, ns = ${ $.ns }',\n            statefull: {\n                value: true\n            },\n            tracks: {\n                value: true,\n                previews: true,\n                inputValue: true,\n                focused: true,\n                keywordUpdated: true\n            },\n            imports: {\n                inputValue: 'value',\n                updatePreview: 'value',\n                focused: false\n            },\n            exports: {\n                value: '${ $.provider }:params.search',\n                keywordUpdated: '${ $.provider }:params.keywordUpdated'\n            },\n            modules: {\n                chips: '${ $.chipsProvider }'\n            }\n        },\n\n        /**\n         * Initializes search component.\n         *\n         * @returns {Search} Chainable.\n         */\n        initialize: function () {\n            var urlParams = window.location.href.slice(window.location.href.search('[\\&\\?](search=)')).split('&'),\n                searchTerm = [];\n\n            this._super()\n                .initChips();\n\n            if (urlParams[0]) {\n                searchTerm = urlParams[0].split('=');\n\n                if (searchTerm[1]) {\n                    this.apply(decodeURIComponent(searchTerm[1]));\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes chips component.\n         *\n         * @returns {Search} Chainbale.\n         */\n        initChips: function () {\n            this.chips('insertChild', this, 0);\n\n            return this;\n        },\n\n        /**\n         * Clears search.\n         *\n         * @returns {Search} Chainable.\n         */\n        clear: function () {\n            this.value = '';\n\n            return this;\n        },\n\n        /**\n         * Click To ScrollTop.\n         */\n        scrollTo: function ($data) {\n            $('html, body').animate({\n                scrollTop: 0\n            }, 'slow', function () {\n                $data.focused = false;\n                $data.focused = true;\n            });\n        },\n\n        /**\n         * Resets input value to the last applied state.\n         *\n         * @returns {Search} Chainable.\n         */\n        cancel: function () {\n            this.inputValue = this.value;\n\n            return this;\n        },\n\n        /**\n         * Applies search query.\n         *\n         * @param {String} [value=inputValue] - If not specified, then\n         *      value of the input field will be used.\n         * @returns {Search} Chainable.\n         */\n        apply: function (value) {\n            value = value || this.inputValue;\n\n            this.keywordUpdated = this.value !== value;\n            this.value = this.inputValue = value.trim();\n\n            return this;\n        },\n\n        /**\n         * Updates preview data.\n         *\n         * @returns {Search} Chainable.\n         */\n        updatePreview: function () {\n            var preview = [];\n\n            if (this.value) {\n                preview.push({\n                    elem: this,\n                    label: this.label,\n                    preview: this.value\n                });\n            }\n\n            this.previews = preview;\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/columns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'uiCollection'\n], function (_, utils, $t, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/controls/columns',\n            minVisible: 1,\n            maxVisible: 30,\n            viewportSize: 18,\n            displayArea: 'dataGridActions',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            imports: {\n                addColumns: '${ $.columnsProvider }:elems'\n            },\n            templates: {\n                headerMsg: $t('${ $.visible } out of ${ $.total } visible')\n            }\n        },\n\n        /**\n         * Resets columns visibility to theirs default state.\n         *\n         * @returns {Columns} Chainable.\n         */\n        reset: function () {\n            this.elems.each('applyState', 'default', 'visible');\n\n            return this;\n        },\n\n        /**\n         * Applies last saved state of columns visibility.\n         *\n         * @returns {Columns} Chainable.\n         */\n        cancel: function () {\n            this.elems.each('applyState', '', 'visible');\n\n            return this;\n        },\n\n        /**\n         * Adds columns whose visibility can be controlled to the component.\n         *\n         * @param {Array} columns - Elements array that will be added to component.\n         * @returns {Columns} Chainable.\n         */\n        addColumns: function (columns) {\n            columns = _.where(columns, {\n                controlVisibility: true\n            });\n\n            this.insertChild(columns);\n\n            return this;\n        },\n\n        /**\n         * Defines whether child elements array length\n         * is greater than the 'viewportSize' property.\n         *\n         * @returns {Boolean}\n         */\n        hasOverflow: function () {\n            return this.elems().length > this.viewportSize;\n        },\n\n        /**\n         * Helper, checks\n         *  - if less than one item choosen\n         *  - if more then viewportMaxSize choosen\n         *\n         * @param {Object} elem\n         * @returns {Boolean}\n         */\n        isDisabled: function (elem) {\n            var visible = this.countVisible();\n\n            return elem.visible ?\n                    visible === this.minVisible :\n                    visible === this.maxVisible;\n        },\n\n        /**\n         * Counts number of visible columns.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.elems.filter('visible').length;\n        },\n\n        /**\n         * Compile header message from headerMessage setting.\n         *\n         * @returns {String}\n         */\n        getHeaderMessage: function () {\n            return utils.template(this.templates.headerMsg, {\n                visible: this.countVisible(),\n                total: this.elems().length\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/button/split.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).on('click.splitDefault', '.action-default', function () {\n            $(this).siblings('.dropdown-menu').find('.item-default').trigger('click');\n        });\n    };\n});\n","Magento_Ui/js/grid/controls/bookmarks/storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Ui/js/lib/core/storage/local',\n    'uiClass'\n], function ($, utils, storage, Class) {\n    'use strict';\n\n    /**\n     * Removes ns prefix for path.\n     *\n     * @param {String} ns\n     * @param {String} path\n     * @returns {String}\n     */\n    function removeNs(ns, path) {\n        return path.replace(ns + '.', '');\n    }\n\n    return Class.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                data: {\n                    namespace: '${ $.namespace }'\n                }\n            }\n        },\n\n        /**\n         * Delegates call to the localStorage adapter.\n         */\n        get: function () {\n            return {};\n        },\n\n        /**\n         * Sends request to store specified data.\n         *\n         * @param {String} path - Path by which data should be stored.\n         * @param {*} value - Value to be sent.\n         */\n        set: function (path, value) {\n            var property = removeNs(this.namespace, path),\n                data = {},\n                config;\n\n            utils.nested(data, property, value);\n\n            config = utils.extend({\n                url: this.saveUrl,\n                data: {\n                    data: JSON.stringify(data)\n                }\n            }, this.ajaxSettings);\n\n            $.ajax(config);\n        },\n\n        /**\n         * Sends request to remove specified data.\n         *\n         * @param {String} path - Path to the property to be removed.\n         */\n        remove: function (path) {\n            var property = removeNs(this.namespace, path),\n                config;\n\n            config = utils.extend({\n                url: this.deleteUrl,\n                data: {\n                    data: property\n                }\n            }, this.ajaxSettings);\n\n            $.ajax(config);\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/bookmarks/bookmarks.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (_, utils, $t, resolver, layout, Collection) {\n    'use strict';\n\n    /**\n     * Removes 'current' namespace from a 'path' string.\n     *\n     * @param {String} path\n     * @returns {String} Path without namespace.\n     */\n    function removeStateNs(path) {\n        path = typeof path == 'string' ? path.split('.') : [];\n\n        if (path[0] === 'current') {\n            path.shift();\n        }\n\n        return path.join('.');\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/controls/bookmarks/bookmarks',\n            viewTmpl: 'ui/grid/controls/bookmarks/view',\n            newViewLabel: $t('New View'),\n            defaultIndex: 'default',\n            activeIndex: 'default',\n            viewsArray: [],\n            storageConfig: {\n                provider: '${ $.storageConfig.name }',\n                name: '${ $.name }_storage',\n                component: 'Magento_Ui/js/grid/controls/bookmarks/storage'\n            },\n            views: {\n                default: {\n                    label: $t('Default View'),\n                    index: 'default',\n                    editable: false\n                }\n            },\n            tracks: {\n                editing: true,\n                viewsArray: true,\n                activeView: true,\n                hasChanges: true,\n                customLabel: true,\n                customVisible: true\n            },\n            listens: {\n                activeIndex: 'onActiveIndexChange',\n                activeView: 'checkState',\n                current: 'onStateChange'\n            }\n        },\n\n        /**\n         * Initializes bookmarks component.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initialize: function () {\n            utils.limit(this, 'checkState', 5);\n            utils.limit(this, 'saveState', 2000);\n\n            this._super()\n                .restore()\n                .initStorage()\n                .initViews();\n\n            return this;\n        },\n\n        /**\n         * Creates custom storage instance.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initStorage: function () {\n            layout([this.storageConfig]);\n\n            return this;\n        },\n\n        /**\n         * Defines default data if it wasn't gathered previously.\n         *\n         * @private\n         * @returns {Bookmarks} Chainbale.\n         */\n        initDefaultView: function () {\n            var data = this.getViewData(this.defaultIndex);\n\n            if (!_.size(data) && (this.current.columns && this.current.positions)) {\n                    this.setViewData(this.defaultIndex, this.current)\n                        .saveView(this.defaultIndex);\n                    this.defaultDefined = true;\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates instances of a previously saved views.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initViews: function () {\n            _.each(this.views, function (config) {\n                this.addView(config);\n            }, this);\n\n            this.activeView = this.getActiveView();\n\n            return this;\n        },\n\n        /**\n         * Creates complete configuration for a view.\n         *\n         * @param {Object} [config] - Additional configuration object.\n         * @returns {Object}\n         */\n        buildView: function (config) {\n            var view = {\n                label: this.newViewLabel,\n                index: '_' + Date.now(),\n                editable: true\n            };\n\n            utils.extend(view, config || {});\n\n            view.data   = view.data || utils.copy(this.current);\n            view.value  = view.label;\n\n            this.observe.call(view, true, 'label value');\n\n            return view;\n        },\n\n        /**\n         * Creates instance of a view with a provided configuration.\n         *\n         * @param {Object} [config] - View configuration.\n         * @param {Boolean} [saveView=false] - Whether to save created view automatically or not.\n         * @param {Boolean} [applyView=false] - Whether to apply created view automatically or not.\n         * @returns {View} Created view.\n         */\n        addView: function (config, saveView, applyView) {\n            var view    = this.buildView(config),\n                index   = view.index;\n\n            this.views[index] = view;\n\n            if (saveView) {\n                this.saveView(index);\n            }\n\n            if (applyView) {\n                this.applyView(index);\n            }\n\n            this.updateArray();\n\n            return view;\n        },\n\n        /**\n         * Removes specified view.\n         *\n         * @param {String} index - Index of a view to be removed.\n         * @returns {Bookmarks} Chainable.\n         */\n        removeView: function (index) {\n            var viewPath = this.getViewPath(index);\n\n            if (this.isViewActive(index)) {\n                this.applyView(this.defaultIndex);\n            }\n\n            this.endEdit(index)\n                .remove(viewPath)\n                .removeStored(viewPath)\n                .updateArray();\n\n            return this;\n        },\n\n        /**\n         * Saves data of a specified view.\n         *\n         * @param {String} index - Index of a view to be saved.\n         * @returns {Bookmarks} Chainable.\n         */\n        saveView: function (index) {\n            var viewPath = this.getViewPath(index);\n\n            this.updateViewLabel(index)\n                .endEdit(index)\n                .store(viewPath)\n                .checkState();\n\n            return this;\n        },\n\n        /**\n         * Sets specified view as active\n         * and applies its' state.\n         *\n         * @param {String} index - Index of a view to be applied.\n         * @returns {Bookmarks} Chainable.\n         */\n        applyView: function (index) {\n            this.applyStateOf(index)\n                .set('activeIndex', index);\n\n            return this;\n        },\n\n        /**\n         * Updates data of a specified view if it's\n         * currently active and saves its' data.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        updateAndSave: function (index) {\n            if (this.isViewActive(index)) {\n                this.updateActiveView(index);\n            }\n\n            this.saveView(index);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a specified view.\n         *\n         * @param {String} index - Index of a view to be retrieved.\n         * @returns {View}\n         */\n        getView: function (index) {\n            return this.views[index];\n        },\n\n        /**\n         * Returns instance of an active view.\n         *\n         * @returns {View}\n         */\n        getActiveView: function () {\n            return this.views[this.activeIndex];\n        },\n\n        /**\n         * Checks if specified view is active.\n         *\n         * @param {String} index - Index of a view to be checked.\n         * @returns {Boolean}\n         */\n        isViewActive: function (index) {\n            return this.activeView === this.getView(index);\n        },\n\n        /**\n         * Sets current state as a data of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        updateActiveView: function () {\n            this.setViewData(this.activeIndex, this.current);\n\n            return this;\n        },\n\n        /**\n         * Replaces label a view with a provided one.\n         * If new label is not specified, then views'\n         * 'value' property will be taken.\n         *\n         * @param {String} index - Index of a view.\n         * @param {String} [label=view.value] - New labels' value.\n         * @returns {Bookmarks} Chainable.\n         */\n        updateViewLabel: function (index, label) {\n            var view    = this.getView(index),\n                current = view.label;\n\n            label = (label || view.value).trim() || current;\n            label = this.uniqueLabel(label, current);\n\n            view.label = view.value = label;\n\n            return this;\n        },\n\n        /**\n         * Retrieves data of a specified view.\n         *\n         * @param {String} index - Index of a view whose data should be retrieved.\n         * @param {String} [property] - If not specified then whole views' data will be retrieved.\n         * @returns {Object} Views' data.\n         */\n        getViewData: function (index, property) {\n            var view = this.getView(index),\n                data = view.data;\n\n            if (property) {\n                data = utils.nested(data, property);\n            }\n\n            return utils.copy(data);\n        },\n\n        /**\n         * Sets data to the specified view.\n         *\n         * @param {String} index - Index of a view whose data will be replaced.\n         * @param {Object} data - New view data.\n         * @returns {Bookmarks} Chainable.\n         */\n        setViewData: function (index, data) {\n            var path = this.getViewPath(index) + '.data';\n\n            this.set(path, utils.copy(data));\n\n            return this;\n        },\n\n        /**\n         * Starts editing of a specified view.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        editView: function (index) {\n            this.editing = index;\n\n            return this;\n        },\n\n        /**\n         * Ends editing of specified view\n         * and restores its' label.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        endEdit: function (index) {\n            var view;\n\n            if (!this.isEditing(index)) {\n                return this;\n            }\n\n            index   = index || this.editing;\n            view    = this.getView(index);\n\n            view.value = view.label;\n\n            this.editing = false;\n\n            return this;\n        },\n\n        /**\n         * Checks if specified view is in editing state.\n         *\n         * @param {String} index - Index of a view to be checked.\n         * @returns {Boolean}\n         */\n        isEditing: function (index) {\n            return this.editing === index;\n        },\n\n        /**\n         * Generates label unique among present views, based\n         * on the incoming label pattern.\n         *\n         * @param {String} [label=this.newViewLabel] - Label pattern.\n         * @param {String} [exclude]\n         * @returns {String}\n         */\n        uniqueLabel: function (label, exclude) {\n            var labels      = _.pluck(this.views, 'label'),\n                hasParenth  = _.last(label) === ')',\n                index       = 2,\n                result,\n                suffix;\n\n            labels = _.without(labels, exclude);\n            result = label = label || this.newViewLabel;\n\n            for (index = 2; _.contains(labels, result); index++) {\n                suffix = '(' + index + ')';\n\n                if (!hasParenth) {\n                    suffix = ' ' + suffix;\n                }\n\n                result = label + suffix;\n            }\n\n            return result;\n        },\n\n        /**\n         * Applies state of a specified view, without\n         * making it active.\n         *\n         * @param {String} [state=this.activeIndex]\n         * @param {String} [property]\n         * @returns {Bookmarks} Chainable.\n         */\n        applyStateOf: function (state, property) {\n            var index    = state || this.activeIndex,\n                dataPath = removeStateNs(property),\n                viewData = this.getViewData(index, dataPath);\n\n            dataPath = dataPath ?\n                'current.' + dataPath :\n                'current';\n\n            this.set(dataPath, viewData);\n\n            return this;\n        },\n\n        /**\n         * Saves current state.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        saveState: function () {\n            this.store('current');\n            return this;\n        },\n\n        /**\n         * Applies state of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        resetState: function () {\n            this.applyStateOf(this.activeIndex);\n\n            return this;\n        },\n\n        /**\n         * Checks if current state is different\n         * from the state of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        checkState: function () {\n            var viewData = this.getViewData(this.activeIndex),\n                diff     = utils.compare(viewData, this.current);\n\n            this.hasChanges = !diff.equal;\n\n            return this;\n        },\n\n        /**\n         * Returns path to the view instance,\n         * based on a provided index.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {String}\n         */\n        getViewPath: function (index) {\n            return 'views.' + index;\n        },\n\n        /**\n         * Updates the array of views.\n         *\n         * @returns {Bookmarks} Chainable\n         */\n        updateArray: function () {\n            this.viewsArray = _.values(this.views);\n\n            return this;\n        },\n\n        /**\n         * Shows custom view field and creates unique label for it.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        showCustom: function () {\n            this.customLabel    = this.uniqueLabel();\n            this.customVisible  = true;\n\n            return this;\n        },\n\n        /**\n         * Hides custom view field.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        hideCustom: function () {\n            this.customVisible = false;\n\n            return this;\n        },\n\n        /**\n         * Checks if custom view field is visible.\n         *\n         * @returns {Boolean}\n         */\n        isCustomVisible: function () {\n            return this.customVisible;\n        },\n\n        /**\n         * Creates new view instance with a label specified\n         * in a custom view field.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        applyCustom: function () {\n            var label = this.customLabel.trim();\n\n            this.hideCustom()\n                .addView({\n                    label: this.uniqueLabel(label)\n                }, true, true);\n\n            return this;\n        },\n\n        /**\n         * Listener of the activeIndex property.\n         */\n        onActiveIndexChange: function () {\n            this.activeView = this.getActiveView();\n            this.updateActiveView();\n            this.store('activeIndex');\n        },\n\n        /**\n         * Listener of the activeIndex property.\n         */\n        onStateChange: function () {\n            this.checkState();\n            this.saveState();\n\n            if (!this.defaultDefined) {\n                resolver(this.initDefaultView, this);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/range.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mageUtils',\n    'Magento_Ui/js/form/components/group',\n    'mage/translate'\n], function (_, layout, utils, Group, $t) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            template: 'ui/grid/filters/elements/group',\n            isRange: true,\n            templates: {\n                base: {\n                    parent: '${ $.$data.group.name }',\n                    provider: '${ $.$data.group.provider }',\n                    template: 'ui/grid/filters/field'\n                },\n                date: {\n                    component: 'Magento_Ui/js/form/element/date',\n                    dateFormat: 'MM/dd/YYYY',\n                    shiftedValue: 'filter'\n                },\n                datetime: {\n                    component: 'Magento_Ui/js/form/element/date',\n                    dateFormat: 'MM/dd/YYYY',\n                    shiftedValue: 'filter',\n                    options: {\n                        showsTime: true\n                    }\n                },\n                text: {\n                    component: 'Magento_Ui/js/form/element/abstract'\n                },\n                ranges: {\n                    from: {\n                        label: $t('from'),\n                        dataScope: 'from'\n                    },\n                    to: {\n                        label: $t('to'),\n                        dataScope: 'to'\n                    }\n                }\n            }\n        },\n\n        /**\n         * Initializes range component.\n         *\n         * @returns {Range} Chainable.\n         */\n        initialize: function (config) {\n            if (config.dateFormat) {\n                this.constructor.defaults.templates.date.pickerDefaultDateFormat = config.dateFormat;\n            }\n            this._super()\n                .initChildren();\n\n            return this;\n        },\n\n        /**\n         * Creates instances of child components.\n         *\n         * @returns {Range} Chainable.\n         */\n        initChildren: function () {\n            var children = this.buildChildren();\n\n            layout(children);\n\n            return this;\n        },\n\n        /**\n         * Creates configuration for the child components.\n         *\n         * @returns {Object}\n         */\n        buildChildren: function () {\n            var templates   = this.templates,\n                typeTmpl    = templates[this.rangeType],\n                tmpl        = utils.extend({}, templates.base, typeTmpl),\n                children    = {};\n\n            _.each(templates.ranges, function (range, key) {\n                children[key] = utils.extend({}, tmpl, range);\n            });\n\n            return utils.template(children, {\n                group: this\n            }, true, true);\n        },\n\n        /**\n         * Clears childrens data.\n         *\n         * @returns {Range} Chainable.\n         */\n        clear: function () {\n            this.elems.each('clear');\n\n            return this;\n        },\n\n        /**\n         * Checks if some children has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return this.elems.some('hasData');\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/filters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiCollection',\n    'mage/translate',\n    'jquery'\n], function (_, utils, layout, Collection, $t, $) {\n    'use strict';\n\n    /**\n     * Extracts and formats preview of an element.\n     *\n     * @param {Object} elem - Element whose preview should be extracted.\n     * @returns {Object} Formatted data.\n     */\n    function extractPreview(elem) {\n        return {\n            label: elem.label,\n            preview: elem.getPreview(),\n            elem: elem\n        };\n    }\n\n    /**\n     * Removes empty properties from the provided object.\n     *\n     * @param {Object} data - Object to be processed.\n     * @returns {Object}\n     */\n    function removeEmpty(data) {\n        var result = utils.mapRecursive(data, utils.removeEmptyValues.bind(utils));\n\n        return utils.mapRecursive(result, function (value) {\n            return _.isString(value) ? value.trim() : value;\n        });\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/filters/filters',\n            stickyTmpl: 'ui/grid/sticky/filters',\n            _processed: [],\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            bookmarksProvider: 'ns = ${ $.ns }, componentType = bookmark',\n            applied: {\n                placeholder: true\n            },\n            filters: {\n                placeholder: true\n            },\n            templates: {\n                filters: {\n                    base: {\n                        parent: '${ $.$data.filters.name }',\n                        name: '${ $.$data.column.index }',\n                        provider: '${ $.$data.filters.name }',\n                        dataScope: '${ $.$data.column.index }',\n                        label: '${ $.$data.column.label }',\n                        imports: {\n                            visible: '${ $.$data.column.name }:visible'\n                        }\n                    },\n                    text: {\n                        component: 'Magento_Ui/js/form/element/abstract',\n                        template: 'ui/grid/filters/field'\n                    },\n                    select: {\n                        component: 'Magento_Ui/js/form/element/select',\n                        template: 'ui/grid/filters/field',\n                        options: '${ JSON.stringify($.$data.column.options) }',\n                        caption: ' '\n                    },\n                    dateRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'date'\n                    },\n                    datetimeRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'datetime'\n                    },\n                    textRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'text'\n                    }\n                }\n            },\n            chipsConfig: {\n                name: '${ $.name }_chips',\n                provider: '${ $.chipsConfig.name }',\n                component: 'Magento_Ui/js/grid/filters/chips'\n            },\n            listens: {\n                active: 'updatePreviews',\n                applied: 'cancel updateActive'\n            },\n            statefull: {\n                applied: true\n            },\n            exports: {\n                applied: '${ $.provider }:params.filters'\n            },\n            imports: {\n                onColumnsUpdate: '${ $.columnsProvider }:elems',\n                onBackendError: '${ $.provider }:lastError',\n                bookmarksActiveIndex: '${ $.bookmarksProvider }:activeIndex'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }',\n                chips: '${ $.chipsConfig.provider }'\n            }\n        },\n\n        /**\n         * Initializes filters component.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initialize: function (config) {\n            if (typeof config.options !== 'undefined' && config.options.dateFormat) {\n                this.constructor.defaults.templates.filters.dateRange.dateFormat = config.options.dateFormat;\n            }\n            _.bindAll(this, 'updateActive');\n\n            this._super()\n                .initChips()\n                .cancel();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    active: [],\n                    previews: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes chips component.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initChips: function () {\n            layout([this.chipsConfig]);\n\n            this.chips('insertChild', this.name);\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to filters collection.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.on('elems', this.updateActive);\n\n            this.updateActive();\n\n            return this;\n        },\n\n        /**\n         * Clears filters data.\n         *\n         * @param {Object} [filter] - If provided, then only specified\n         *      filter will be cleared. Otherwise, clears all data.\n         * @returns {Filters} Chainable.\n         */\n        clear: function (filter) {\n            filter ?\n                filter.clear() :\n                _.invoke(this.active, 'clear');\n\n            this.apply();\n\n            return this;\n        },\n\n        /**\n         * Sets filters data to the applied state.\n         *\n         * @returns {Filters} Chainable.\n         */\n        apply: function () {\n            if (typeof $('body').notification === 'function') {\n                $('body').notification('clear');\n            }\n            this.set('applied', removeEmpty(this.filters));\n            return this;\n        },\n\n        /**\n         * Resets filters to the last applied state.\n         *\n         * @returns {Filters} Chainable.\n         */\n        cancel: function () {\n            this.set('filters', utils.copy(this.applied));\n\n            return this;\n        },\n\n        /**\n         * Sets provided data to filter components (without applying it).\n         *\n         * @param {Object} data - Filters data.\n         * @param {Boolean} [partial=false] - Flag that defines whether\n         *      to completely replace current filters data or to extend it.\n         * @returns {Filters} Chainable.\n         */\n        setData: function (data, partial) {\n            var filters = partial ? this.filters : {};\n\n            data = utils.extend({}, filters, data);\n\n            this.set('filters', data);\n\n            return this;\n        },\n\n        /**\n         * Creates instance of a filter associated with the provided column.\n         *\n         * @param {Column} column - Column component for which to create a filter.\n         * @returns {Filters} Chainable.\n         */\n        addFilter: function (column) {\n            var index       = column.index,\n                processed   = this._processed,\n                filter;\n\n            if (!column.filter || _.contains(processed, index)) {\n                return this;\n            }\n\n            filter = this.buildFilter(column);\n\n            processed.push(index);\n\n            layout([filter]);\n\n            return this;\n        },\n\n        /**\n         * Creates filter component configuration associated with the provided column.\n         *\n         * @param {Column} column - Column component with a basic filter declaration.\n         * @returns {Object} Filters' configuration.\n         */\n        buildFilter: function (column) {\n            var filters = this.templates.filters,\n                filter  = column.filter,\n                type    = filters[filter.filterType];\n\n            if (_.isObject(filter) && type) {\n                filter = utils.extend({}, type, filter);\n            } else if (_.isString(filter)) {\n                filter = filters[filter];\n            }\n\n            filter = utils.extend({}, filters.base, filter);\n            //Accepting labels as is.\n            filter.__disableTmpl = {\n                label: 1,\n                options: 1\n            };\n\n            filter = utils.template(filter, {\n                filters: this,\n                column: column\n            }, true, true);\n\n            filter.__disableTmpl = {\n                label: true\n            };\n\n            return filter;\n        },\n\n        /**\n         * Returns an array of range filters.\n         *\n         * @returns {Array}\n         */\n        getRanges: function () {\n            return this.elems.filter(function (filter) {\n                return filter.isRange;\n            });\n        },\n\n        /**\n         * Returns an array of non-range filters.\n         *\n         * @returns {Array}\n         */\n        getPlain: function () {\n            return this.elems.filter(function (filter) {\n                return !filter.isRange;\n            });\n        },\n\n        /**\n         * Tells wether specified filter should be visible.\n         *\n         * @param {Object} filter\n         * @returns {Boolean}\n         */\n        isFilterVisible: function (filter) {\n            return filter.visible() || this.isFilterActive(filter);\n        },\n\n        /**\n         * Checks if specified filter is active.\n         *\n         * @param {Object} filter\n         * @returns {Boolean}\n         */\n        isFilterActive: function (filter) {\n            return _.contains(this.active, filter);\n        },\n\n        /**\n         * Checks if collection has visible filters.\n         *\n         * @returns {Boolean}\n         */\n        hasVisible: function () {\n            return this.elems.some(this.isFilterVisible, this);\n        },\n\n        /**\n         * Finds filters with a not empty data\n         * and sets them to the 'active' filters array.\n         *\n         * @returns {Filters} Chainable.\n         */\n        updateActive: function () {\n            var applied = _.keys(this.applied);\n\n            this.active = this.elems.filter(function (elem) {\n                return _.contains(applied, elem.index);\n            });\n\n            return this;\n        },\n\n        /**\n         * Returns number of applied filters.\n         *\n         * @returns {Number}\n         */\n        countActive: function () {\n            return this.active.length;\n        },\n\n        /**\n         * Extract previews of a specified filters.\n         *\n         * @param {Array} filters - Filters to be processed.\n         * @returns {Filters} Chainable.\n         */\n        updatePreviews: function (filters) {\n            var previews = filters.map(extractPreview);\n\n            this.previews = _.compact(previews);\n\n            return this;\n        },\n\n        /**\n         * Listener of the columns provider children array changes.\n         *\n         * @param {Array} columns - Current columns list.\n         */\n        onColumnsUpdate: function (columns) {\n            columns.forEach(this.addFilter, this);\n        },\n\n        /**\n         * Provider ajax error listener.\n         *\n         * @param {bool} isError - Selected index of the filter.\n         */\n        onBackendError: function (isError) {\n            var defaultMessage = 'Something went wrong with processing the default view and we have restored the ' +\n                    'filter to its original state.',\n                customMessage  = 'Something went wrong with processing current custom view and filters have been ' +\n                    'reset to its original state. Please edit filters then click apply.';\n\n            if (isError) {\n                this.clear();\n\n                $('body').notification('clear')\n                    .notification('add', {\n                        error: true,\n                        message: $.mage.__(this.bookmarksActiveIndex !== 'default' ? customMessage : defaultMessage),\n\n                        /**\n                         * @param {String} message\n                         */\n                        insertMethod: function (message) {\n                            var $wrapper = $('<div></div>').html(message);\n\n                            $('.page-main-actions').after($wrapper);\n                        }\n                    });\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/chips.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection'\n], function (_, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/filters/chips',\n            componentType: 'filtersChips'\n        },\n\n        /**\n         * Defines if some of components' children has available previews.\n         *\n         * @returns {Boolean}\n         */\n        hasPreviews: function () {\n            return this.elems().some(function (elem) {\n                return !!elem.previews.length;\n            });\n        },\n\n        /**\n         * Calls clear method on all of its' children.\n         *\n         * @returns {Chips} Chainable.\n         */\n        clear: function () {\n            _.invoke(this.elems(), 'clear');\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/elements/ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select',\n    'jquery',\n    'underscore'\n], function (Select, $, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            bookmarkProvider: 'ns = ${ $.ns }, index = bookmarks',\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            validationUrl: false,\n            loadedOption: [],\n            validationLoading: true,\n            imports: {\n                applied: '${ $.filterChipsProvider }:applied',\n                activeIndex: '${ $.bookmarkProvider }:activeIndex'\n            },\n            modules: {\n                filterChips: '${ $.filterChipsProvider }'\n            },\n            listens: {\n                activeIndex: 'validateInitialValue',\n                applied: 'validateInitialValue'\n            }\n\n        },\n\n        /**\n         * Initializes UiSelect component.\n         *\n         * @returns {UiSelect} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            this.validateInitialValue();\n\n            return this;\n        },\n\n        /**\n         * Validate initial value actually exists\n         */\n        validateInitialValue: function () {\n            if (_.isEmpty(this.value())) {\n                this.validationLoading(false);\n\n                return;\n            }\n\n            $.ajax({\n                url: this.validationUrl,\n                type: 'GET',\n                dataType: 'json',\n                context: this,\n                data: {\n                    ids: this.value()\n                },\n\n                /** @param {Object} response */\n                success: function (response) {\n                    if (!_.isEmpty(response)) {\n                        this.options([]);\n                        this.success({\n                            options: response\n                        });\n                    }\n                    this.filterChips().updateActive();\n                },\n\n                /** set empty array if error occurs */\n                error: function () {\n                    this.options([]);\n                },\n\n                /** stop loader */\n                complete: function () {\n                    this.validationLoading(false);\n                    this.setCaption();\n                }\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/sticky/sticky.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/lib/view/utils/raf'\n], function ($, _, Component, raf) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            listingSelector: '${ $.listingProvider }::not([data-role = \"sticky-el-root\"])',\n            toolbarSelector: '${ $.toolbarProvider }::not([data-role = \"sticky-el-root\"])',\n            bulkRowSelector: '[data-role = \"data-grid-bulk-row\"]',\n            bulkRowHeaderSelector: '.data-grid-info-panel:visible',\n            tableSelector: 'table',\n            columnSelector: 'thead tr th',\n            rowSelector: 'tbody tr',\n            toolbarCollapsiblesSelector: '[data-role=\"toolbar-menu-item\"]',\n            toolbarCollapsiblesActiveClass: '_active',\n            template: 'ui/grid/sticky/sticky',\n            stickyContainerSelector: '.sticky-header',\n            stickyElementSelector: '[data-role = \"sticky-el-root\"]',\n            leftDataGridCapSelector: '.data-grid-cap-left',\n            rightDataGridCapSelector: '.data-grid-cap-right',\n            visible: false,\n            enableToolbar: true,\n            enableHeader: true,\n            modules: {\n                toolbar: '${ $.toolbarProvider }',\n                listing: '${ $.listingProvider }'\n            },\n            otherStickyElsSize: 77,\n            containerNode: null,\n            listingNode: null,\n            toolbarNode: null,\n            stickyListingNode: null,\n            stickyToolbarNode: null,\n            storedOriginalToolbarElements: [],\n            cache: {},\n            flags: {},\n            dirtyFlag: 'dirty'\n        },\n\n        /**\n         * Initializes Sticky component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this,\n                'adjustStickyElems',\n                'initListingNode',\n                'initToolbarNode',\n                'initContainerNode',\n                'initColumns',\n                'initStickyListingNode',\n                'initStickyToolbarNode',\n                'initLeftDataGridCap',\n                'initRightDataGridCap'\n            );\n\n            $.async(this.listingSelector,\n                this.initListingNode);\n            $.async(this.toolbarSelector,\n                this.initToolbarNode);\n\n            $.async(this.stickyContainerSelector,\n                this,\n                this.initContainerNode);\n\n            return this;\n        },\n\n        /**\n         * Init observables\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('visible');\n\n            return this;\n        },\n\n        /**\n         * Init original listing node\n         *\n         * @param {HTMLElement} node\n         */\n        initListingNode: function (node) {\n            if ($(node).is(this.stickyElementSelector)) {\n                return;\n            }\n            this.listingNode = $(node);\n            $.async(this.columnSelector, node, this.initColumns);\n        },\n\n        /**\n         * Init original toolbar node\n         *\n         * @param {HTMLElement} node\n         */\n        initToolbarNode: function (node) {\n            if ($(node).is(this.stickyElementSelector)) {\n                return;\n            }\n            this.toolbarNode = $(node);\n        },\n\n        /**\n         * Init sticky listing node\n         *\n         * @param {HTMLElement} node\n         */\n        initStickyListingNode: function (node) {\n            this.stickyListingNode = $(node);\n            this.checkPos();\n            this.initListeners();\n        },\n\n        /**\n         * Init sticky toolbar node\n         *\n         * @param {HTMLElement} node\n         */\n        initStickyToolbarNode: function (node) {\n            this.stickyToolbarNode = $(node);\n        },\n\n        /**\n         * Init sticky header container node\n         *\n         * @param {HTMLElement} node\n         */\n        initContainerNode: function (node) {\n            this.containerNode = $(node);\n\n            $.async(this.leftDataGridCapSelector,\n                node,\n                this.initLeftDataGridCap);\n            $.async(this.rightDataGridCapSelector,\n                node,\n                this.initRightDataGridCap);\n\n            $.async(this.stickyElementSelector,\n                this.listing(),\n                this.initStickyListingNode);\n            $.async(this.stickyElementSelector,\n                this.toolbar(),\n                this.initStickyToolbarNode);\n        },\n\n        /**\n         * Init columns (each time when amount of columns is changed)\n         *\n         */\n        initColumns: function () {\n            this.columns = this.listingNode.find(this.columnSelector);\n        },\n\n        /**\n         * Init left DataGridCap\n         *\n         * @param {HTMLElement} node\n         */\n        initLeftDataGridCap: function (node) {\n            this.leftDataGridCap = $(node);\n        },\n\n        /**\n         * Init right DataGridCap\n         *\n         * @param {HTMLElement} node\n         */\n        initRightDataGridCap: function (node) {\n            this.rightDataGridCap = $(node);\n        },\n\n        /**\n         * Init listeners\n         *\n         * @returns {Object} Chainable.\n         */\n        initListeners: function () {\n            this.adjustStickyElems();\n            this.initOnResize()\n                .initOnScroll()\n                .initOnListingScroll();\n\n            return this;\n        },\n\n        /**\n         * Start to listen to window scroll event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnScroll: function () {\n            this.lastHorizontalScrollPos = $(window).scrollLeft();\n            document.addEventListener('scroll', function () {\n                this.flags.scrolled = true;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Start to listen to original listing scroll event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnListingScroll: function () {\n            $(this.listingNode).on('scroll', function (e) {\n                this.flags.listingScrolled = true;\n                this.flags.listingScrolledValue = $(e.target).scrollLeft();\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Start to listen to window resize event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnResize: function () {\n            $(window).on('resize', function () {\n                this.flags.resized = true;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Adjust sticky header elements according to flags of the events that have happened in the endless RAF loop\n         */\n        adjustStickyElems: function () {\n            if (this.flags.resized ||\n                this.flags.scrolled) {\n                this.checkPos();\n            }\n\n            if (this.visible) {\n                this.checkTableElemsWidth();\n\n                if (this.flags.originalWidthChanged) {\n                    this.adjustContainerElemsWidth();\n                }\n\n                if (this.flags.resized) {\n                    this.onResize();\n                }\n\n                if (this.flags.scrolled) {\n                    this.onWindowScroll();\n                }\n\n                if (this.flags.listingScrolled) {\n                    this.onListingScroll(this.flags.listingScrolledValue);\n                }\n            }\n            _.each(this.flags, function (val, key) {\n                if (val === this.dirtyFlag) {\n                    this.flags[key] = false;\n                } else if (val) {\n                    this.flags[key] = this.dirtyFlag;\n                }\n            }, this);\n\n            raf(this.adjustStickyElems);\n        },\n\n        /**\n         * Handles window scroll\n         */\n        onWindowScroll: function () {\n            var scrolled = $(window).scrollLeft(),\n                horizontal = this.lastHorizontalScrollPos !== scrolled;\n\n            if (horizontal) {\n                this.adjustOffset()\n                    .adjustDataGridCapPositions();\n                this.lastHorizontalScrollPos = scrolled;\n            } else {\n                this.checkPos();\n            }\n        },\n\n        /**\n         * Handles original listing scroll\n         *\n         * @param {Number} scrolled\n         */\n        onListingScroll: function (scrolled) {\n            this.adjustOffset(scrolled);\n        },\n\n        /**\n         * Handles window resize\n         */\n        onResize: function () {\n            this.checkPos();\n            this.adjustContainerElemsWidth()\n                .adjustDataGridCapPositions();\n        },\n\n        /**\n         * Check if original table or columns change it dimensions and sets appropriate flag\n         */\n        checkTableElemsWidth: function () {\n            var newWidth = this.getTableWidth();\n\n            if (this.cache.tableWidth !== newWidth) {\n                this.cache.tableWidth = newWidth;\n                this.flags.originalWidthChanged = true;\n            } else if (this.cache.colChecksum !== this.getColsChecksum()) {\n                this.cache.colChecksum = this.getColsChecksum();\n                this.flags.originalWidthChanged = true;\n            }\n        },\n\n        /**\n         * Get the checksum of original columns width\n         *\n         * @returns {Number}.\n         */\n        getColsChecksum: function () {\n            return _.reduce(this.columns,\n            function (pv, cv) {\n                return ($(pv).width() || pv) + '' + $(cv).width();\n            });\n        },\n\n        /**\n         * Get the width of the sticky table wrapper\n         *\n         * @returns {Number}.\n         */\n        getListingWidth: function () {\n            return this.listingNode.width();\n        },\n\n        /**\n         * Get the width of the original table\n         *\n         * @returns {Number}.\n         */\n        getTableWidth: function () {\n            return this.listingNode.find(this.tableSelector).width();\n        },\n\n        /**\n         * Get the top elem: header or toolbar\n         *\n         * @returns {HTMLElement}.\n         */\n        getTopElement: function () {\n            return this.toolbarNode || this.listingNode;\n        },\n\n        /**\n         * Get the height of the other sticky elem (Page header)\n         *\n         * @returns {Number}.\n         */\n        getOtherStickyElementsSize: function () {\n            return this.otherStickyElsSize;\n        },\n\n        /**\n         * Get original bulk row height, if is visible\n         *\n         * @returns {Number}.\n         */\n        getBulkRowHeight: function () {\n            return this.listingNode.find(this.bulkRowSelector).filter(':visible').height();\n        },\n\n        /**\n         * Get top Y coord of the sticky header\n         *\n         * @returns {Number}.\n         */\n        getListingTopYCoord: function () {\n            var bulkRowHeight = this.getBulkRowHeight();\n\n            return this.listingNode.find('tbody').offset().top -\n                this.containerNode.height() -\n                $(window).scrollTop() +\n                bulkRowHeight;\n        },\n\n        /**\n         * Check if sticky header must be visible\n         *\n         * @returns {Boolean}.\n         */\n        getMustBeSticky: function () {\n            var stickyTopCondition = this.getListingTopYCoord() - this.getOtherStickyElementsSize(),\n                stickyBottomCondition = this.listingNode.offset().top +\n                    this.listingNode.height() -\n                    $(window).scrollTop() +\n                    this.getBulkRowHeight() -\n                    this.getOtherStickyElementsSize();\n\n            return stickyTopCondition < 0 && stickyBottomCondition > 0;\n        },\n\n        /**\n         * Resize sticky header and cols\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustContainerElemsWidth: function () {\n            this.resizeContainer()\n                .resizeCols()\n                .resizeBulk();\n\n            return this;\n        },\n\n        /**\n         * Resize sticky header\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeContainer: function () {\n            var listingWidth = this.getListingWidth();\n\n            this.stickyListingNode.innerWidth(listingWidth);\n            this.stickyListingNode.find(this.tableSelector).innerWidth(this.getTableWidth());\n\n            if (this.stickyToolbarNode) {\n                this.stickyToolbarNode.innerWidth(listingWidth);\n            }\n\n            return this;\n        },\n\n        /**\n         * Resize sticky cols\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeCols: function () {\n            var cols = this.listingNode.find(this.columnSelector);\n\n            this.stickyListingNode.find(this.columnSelector).each(function (ind) {\n                var originalColWidth =  $(cols[ind]).width();\n\n                $(this).width(originalColWidth);\n            });\n\n            return this;\n        },\n\n        /**\n         * Resize bulk row header\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeBulk: function () {\n            var bulk = this.containerNode.find(this.bulkRowHeaderSelector)[0];\n\n            if (bulk) {\n                $(bulk).innerWidth(this.getListingWidth());\n            }\n\n            return this;\n        },\n\n        /**\n         * Reset viewport to the top of listing\n         */\n        resetToTop: function () {\n            var posOfTopEl = this.getTopElement().offset().top - this.getOtherStickyElementsSize() || 0;\n\n            $(window).scrollTop(posOfTopEl);\n        },\n\n        /**\n         * Adjust sticky header offset\n         *\n         * @param {Number} val\n         * @returns {Object} Chainable.\n         */\n        adjustOffset: function (val) {\n            val = val || this.listingNode.scrollLeft();\n            this.stickyListingNode.offset({\n                left: this.listingNode.offset().left - val\n            });\n\n            return this;\n        },\n\n        /**\n         * Adjust both DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustDataGridCapPositions: function () {\n            this.adjustLeftDataGridCapPos()\n                .adjustRightDataGridCapPos();\n\n            return this;\n        },\n\n        /**\n         * Adjust left DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustLeftDataGridCapPos: function () {\n            this.leftDataGridCap.offset({\n                left: this.listingNode.offset().left - this.leftDataGridCap.width()\n            });\n\n            return this;\n        },\n\n        /**\n         * Adjust right DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustRightDataGridCapPos: function () {\n            this.rightDataGridCap.offset({\n                left: this.listingNode.offset().left + this.listingNode.width()\n            });\n\n            return this;\n        },\n\n        /**\n         * Hides the oiginal toolbar opened dropdowns/collapsibles etc\n         */\n        collapseOriginalElements: function () {\n            this.toolbarNode\n                .find(this.toolbarCollapsiblesSelector)\n                .css('visibility', 'hidden');\n            $(this.listingNode.find(this.bulkRowSelector)[0]).css('visibility', 'hidden');\n        },\n\n        /**\n         * Restores the oiginal toolbar opened dropdowns/collapsibles etc\n         */\n        restoreOriginalElements: function () {\n            this.toolbarNode\n                .find(this.toolbarCollapsiblesSelector)\n                .css('visibility', 'visible');\n            $(this.listingNode.find(this.bulkRowSelector)[0]).css('visibility', 'visible');\n        },\n\n        /**\n         * Toggle the visibility of sticky header\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleContainerVisibility: function () {\n            this.visible = !this.visible;\n\n            return this;\n        },\n\n        /**\n         * Checks position of the listing to know if need to show/hide sticky header\n         *\n         * @returns {Boolean} whether the visibility of the sticky header was toggled.\n         */\n        checkPos: function () {\n            var isSticky = this.visible,\n                mustBeSticky = this.getMustBeSticky(),\n                needChange = isSticky !== mustBeSticky;\n\n            if (needChange) {\n                if (mustBeSticky) {\n                    this.collapseOriginalElements();\n                    this.toggleContainerVisibility();\n                    this.adjustContainerElemsWidth()\n                        .adjustOffset()\n                        .adjustDataGridCapPositions();\n\n                } else {\n                    this.toggleContainerVisibility();\n                    this.restoreOriginalElements();\n                }\n            }\n\n            return needChange;\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            validateBeforeSave: true,\n            requestConfig: {\n                dataType: 'json',\n                type: 'POST'\n            }\n        },\n\n        /**\n         * Initializes client instance.\n         *\n         * @returns {Client} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onSuccess', 'onError');\n\n            return this._super();\n        },\n\n        /**\n         * Sends XMLHttpRequest with a provided configuration.\n         *\n         * @param {Object} config - Configuration of request.\n         * @returns {jQueryPromise}\n         */\n        send: function (config) {\n            var deffer  = $.Deferred();\n\n            config = utils.extend({}, this.requestConfig, config);\n\n            $.ajax(config)\n                .done(_.partial(this.onSuccess, deffer))\n                .fail(_.partial(this.onError, deffer));\n\n            return deffer.promise();\n        },\n\n        /**\n         * Proxy save method which might invoke\n         * data validation prior to its' saving.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {jQueryPromise}\n         */\n        save: function (data) {\n            var save = this._save.bind(this, data);\n\n            return this.validateBeforeSave ?\n                this.validate(data).pipe(save) :\n                save();\n        },\n\n        /**\n         * Sends request to validate provided data.\n         *\n         * @param {Object} data - Data to be validated.\n         * @returns {jQueryPromise}\n         */\n        validate: function (data) {\n            return this.send({\n                url: this.validateUrl,\n                data: data\n            });\n        },\n\n        /**\n         * Sends request to save provided data.\n         *\n         * @private\n         * @param {Object} data - Data to be validated.\n         * @returns {jQueryPromise}\n         */\n        _save: function (data) {\n            return this.send({\n                url: this.saveUrl,\n                data: data\n            });\n        },\n\n        /**\n         * Creates error object with a provided message.\n         *\n         * @param {String} msg - Errors' message.\n         * @returns {Object}\n         */\n        createError: function (msg) {\n            return {\n                type: 'error',\n                message: msg\n            };\n        },\n\n        /**\n         * Handles ajax error callback.\n         *\n         * @param {jQueryPromise} promise - Promise to be rejected.\n         * @param {jQueryXHR} xhr - See 'jquery' ajax error callback.\n         * @param {String} status - See 'jquery' ajax error callback.\n         * @param {(String|Object)} err - See 'jquery' ajax error callback.\n         */\n        onError: function (promise, xhr, status, err) {\n            var msg;\n\n            msg = xhr.status !== 200 ?\n                xhr.status + ' (' + xhr.statusText + ')' :\n                err;\n\n            promise.reject(this.createError(msg));\n        },\n\n        /**\n         * Handles ajax success callback.\n         *\n         * @param {jQueryPromise} promise - Promise to be resolved.\n         * @param {*} data - See 'jquery' ajax success callback.\n         */\n        onSuccess: function (promise, data) {\n            var errors;\n\n            if (data.error) {\n                errors = _.map(data.messages, this.createError, this);\n\n                promise.reject(errors);\n            } else {\n                promise.resolve(data);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiCollection'\n], function (_, utils, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            active: true,\n            hasChanges: false,\n            fields: [],\n            errorsCount: 0,\n            fieldTmpl: 'ui/grid/editing/field',\n            rowTmpl: 'ui/grid/editing/row',\n            templates: {\n                fields: {\n                    base: {\n                        parent: '${ $.$data.record.name }',\n                        name: '${ $.$data.column.index }',\n                        provider: '${ $.$data.record.name }',\n                        dataScope: 'data.${ $.$data.column.index }',\n                        imports: {\n                            disabled: '${ $.$data.record.parentName }:fields.${ $.$data.column.index }.disabled'\n                        },\n                        isEditor: true\n                    },\n                    text: {\n                        component: 'Magento_Ui/js/form/element/abstract',\n                        template: 'ui/form/element/input'\n                    },\n                    date: {\n                        component: 'Magento_Ui/js/form/element/date',\n                        template: 'ui/form/element/date',\n                        dateFormat: 'MMM d, y h:mm:ss a'\n                    },\n                    select: {\n                        component: 'Magento_Ui/js/form/element/select',\n                        template: 'ui/form/element/select',\n                        options: '${ JSON.stringify($.$data.column.options) }'\n                    }\n                }\n            },\n            ignoreTmpls: {\n                data: true\n            },\n            listens: {\n                elems: 'updateFields',\n                data: 'updateState'\n            },\n            imports: {\n                onColumnsUpdate: '${ $.columnsProvider }:elems'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }',\n                editor: '${ $.editorProvider }'\n            }\n        },\n\n        /**\n         * Initializes record component.\n         *\n         * @returns {Record} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'countErrors');\n            utils.limit(this, 'updateState', 10);\n\n            return this._super();\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Record} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('errorsCount hasChanges')\n                .observe('active fields');\n\n            return this;\n        },\n\n        /**\n         * Adds listeners on a field.\n         *\n         * @returns {Record} Chainable.\n         */\n        initElement: function (field) {\n            field.on('error', this.countErrors);\n\n            return this._super();\n        },\n\n        /**\n         * Creates new instance of a field.\n         *\n         * @param {Column} column - Column instance which contains field definition.\n         * @returns {Record} Chainable.\n         */\n        initField: function (column) {\n            var field = this.buildField(column);\n\n            layout([field]);\n\n            return this;\n        },\n\n        /**\n         * Builds fields' configuration described in a provided column.\n         *\n         * @param {Column} column - Column instance which contains field definition.\n         * @returns {Object} Complete fields' configuration.\n         */\n        buildField: function (column) {\n            var fields = this.templates.fields,\n                field  = column.editor;\n\n            if (_.isObject(field) && field.editorType) {\n                field = utils.extend({}, fields[field.editorType], field);\n            } else if (_.isString(field)) {\n                field = fields[field];\n            }\n\n            field = utils.extend({}, fields.base, field);\n\n            return utils.template(field, {\n                record: this,\n                column: column\n            }, true, true);\n        },\n\n        /**\n         * Creates fields for the specified columns.\n         *\n         * @param {Array} columns - An array of column instances.\n         * @returns {Record} Chainable.\n         */\n        createFields: function (columns) {\n            columns.forEach(function (column) {\n                if (column.editor && !this.hasChild(column.index)) {\n                    this.initField(column);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a column found by provided index.\n         *\n         * @param {String} index - Index of a column (e.g. 'title').\n         * @returns {Column}\n         */\n        getColumn: function (index) {\n            return this.columns().getChild(index);\n        },\n\n        /**\n         * Returns records' current data object.\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            return this.filterData(this.data);\n        },\n\n        /**\n         * Returns saved records' data. Data will be processed\n         * with a 'filterData' and 'normalizeData' methods.\n         *\n         * @returns {Object} Saved records' data.\n         */\n        getSavedData: function () {\n            var editor      = this.editor(),\n                savedData   = editor.getRowData(this.index);\n\n            savedData = this.filterData(savedData);\n\n            return this.normalizeData(savedData);\n        },\n\n        /**\n         * Replaces current records' data with the provided one.\n         *\n         * @param {Object} data - New records data.\n         * @param {Boolean} [partial=false] - Flag that defines whether\n         *      to completely replace current data or to extend it.\n         * @returns {Record} Chainable.\n         */\n        setData: function (data, partial) {\n            var currentData = partial ? this.data : {};\n\n            data = this.normalizeData(data);\n            data = utils.extend({}, currentData, data);\n\n            this.set('data', data)\n                .updateState();\n\n            return this;\n        },\n\n        /**\n         * Filters provided object extracting from it values\n         * that can be matched with an existing fields.\n         *\n         * @param {Object} data - Object to be processed.\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var fields = _.pluck(this.elems(), 'index');\n\n            _.each(this.preserveFields, function (enabled, field) {\n                if (enabled && !_.contains(fields, field)) {\n                    fields.push(field);\n                }\n            });\n\n            return _.pick(data, fields);\n        },\n\n        /**\n         * Parses values of a provided object with\n         * a 'normalizeData' method of a corresponding field.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {Object}\n         */\n        normalizeData: function (data) {\n            var index;\n\n            this.elems.each(function (elem) {\n                index = elem.index;\n\n                if (data.hasOwnProperty(index)) {\n                    data[index] = elem.normalizeData(data[index]);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Clears values of all fields.\n         *\n         * @returns {Record} Chainable.\n         */\n        clear: function () {\n            this.elems.each('clear');\n\n            return this;\n        },\n\n        /**\n         * Validates all of the available fields.\n         *\n         * @returns {Array} An array with validation results.\n         */\n        validate: function () {\n            return this.elems.map('validate');\n        },\n\n        /**\n         * Checks if all fields are valid.\n         *\n         * @returns {Boolean}\n         */\n        isValid: function () {\n            return _.every(this.validate(), 'valid');\n        },\n\n        /**\n         * Counts total errors amount across all fields.\n         *\n         * @returns {Number}\n         */\n        countErrors: function () {\n            var errorsCount = this.elems.filter('error').length;\n\n            this.errorsCount = errorsCount;\n\n            return errorsCount;\n        },\n\n        /**\n         * Returns difference between current data and its'\n         * initial state, retrieved from the records collection.\n         *\n         * @returns {Object} Object with changes descriptions.\n         */\n        checkChanges: function () {\n            var savedData   = this.getSavedData(),\n                data        = this.normalizeData(this.getData());\n\n            return utils.compare(savedData, data);\n        },\n\n        /**\n         * Updates 'fields' array filling it with available editors\n         * or with column instances if associated field is not present.\n         *\n         * @returns {Record} Chainable.\n         */\n        updateFields: function () {\n            var fields;\n\n            fields = this.columns().elems.map(function (column) {\n                return this.getChild(column.index) || column;\n            }, this);\n\n            this.fields(fields);\n\n            return this;\n        },\n\n        /**\n         * Updates state of a 'hasChanges' property.\n         *\n         * @returns {Record} Chainable.\n         */\n        updateState: function () {\n            var diff = this.checkChanges(),\n                changed = {};\n\n            this.hasChanges = !diff.equal;\n            changed[this.index] = this.data;\n            this.editor().set('changed', [changed]);\n\n            return this;\n        },\n\n        /**\n         * Checks if provided column is an actions column.\n         *\n         * @param {Column} column - Column to be checked.\n         * @returns {Boolean}\n         */\n        isActionsColumn: function (column) {\n            return column.dataType === 'actions';\n        },\n\n        /**\n         * Listener of columns provider child array changes.\n         *\n         * @param {Array} columns - Modified child elements array.\n         */\n        onColumnsUpdate: function (columns) {\n            this.createFields(columns)\n                .updateFields();\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    './record'\n], function (_, utils, Record) {\n    'use strict';\n\n    /**\n     * Removes empty properties from the provided object.\n     *\n     * @param {Object} data - Object to be processed.\n     * @returns {Object}\n     */\n    function removeEmpty(data) {\n        data = utils.flatten(data);\n        data = _.omit(data, utils.isEmpty);\n\n        return utils.unflatten(data);\n    }\n\n    return Record.extend({\n        defaults: {\n            template: 'ui/grid/editing/bulk',\n            active: false,\n            templates: {\n                fields: {\n                    select: {\n                        caption: ' '\n                    }\n                }\n            },\n            imports: {\n                active: '${ $.editorProvider }:isMultiEditing'\n            },\n            listens: {\n                data: 'updateState',\n                active: 'updateState'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    hasData: false\n                });\n\n            return this;\n        },\n\n        /**\n         * Extends original method to disable possible\n         * 'required-entry' validation rule.\n         *\n         * @returns {Object} Columns' field definition.\n         */\n        buildField: function () {\n            var field = this._super(),\n                rules = field.validation;\n\n            if (rules) {\n                delete rules['required-entry'];\n            }\n\n            return field;\n        },\n\n        /**\n         * Applies current data to all active records.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        apply: function () {\n            if (this.isValid()) {\n                this.applyData()\n                    .clear();\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets available data to all active records.\n         *\n         * @param {Object} [data] -  If not specified, then current fields data will be used.\n         * @returns {Bulk} Chainable.\n         */\n        applyData: function (data) {\n            data = data || this.getData();\n\n            this.editor('setData', data, true);\n\n            return this;\n        },\n\n        /**\n         * Returns data of all non-empty fields.\n         *\n         * @returns {Object} Fields data without empty values.\n         */\n        getData: function () {\n            return removeEmpty(this._super());\n        },\n\n        /**\n         * Updates own 'hasData' property and defines\n         * whether regular rows editing can be resumed.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        updateState: function () {\n            var fields  = _.keys(this.getData()),\n                hasData = !!fields.length;\n\n            this.hasData = hasData;\n\n            if (!this.active()) {\n                fields = [];\n            }\n\n            this.editor('disableFields', fields);\n            this.editor('canSave', !fields.length);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/editor-view.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, registry, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table',\n            rowSelector: '${ $.tableSelector } tbody tr.data-row',\n            headerButtonsTmpl:\n                '<!-- ko template: headerButtonsTmpl --><!-- /ko -->',\n            bulkTmpl:\n                '<!-- ko scope: bulk -->' +\n                    '<!-- ko template: getTemplate() --><!-- /ko -->' +\n                '<!-- /ko -->',\n            rowTmpl:\n                '<!-- ko with: _editor -->' +\n                    '<!-- ko if: isActive($row()._rowIndex, true) -->' +\n                        '<!-- ko with: getRecord($row()._rowIndex, true) -->' +\n                            '<!-- ko template: rowTmpl --><!-- /ko -->' +\n                        '<!-- /ko -->' +\n                        '<!-- ko if: isSingleEditing && singleEditingButtons -->' +\n                            '<!-- ko template: rowButtonsTmpl --><!-- /ko -->' +\n                        '<!-- /ko -->' +\n                    '<!-- /ko -->' +\n               '<!-- /ko -->'\n        },\n\n        /**\n         * Initializes view component.\n         *\n         * @returns {View} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initRoot',\n                'initTable',\n                'initRow',\n                'rowBindings',\n                'tableBindings'\n            );\n\n            this._super();\n\n            this.model = registry.get(this.model);\n\n            $.async(this.rootSelector, this.initRoot);\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.rowSelector, this.initRow);\n\n            return this;\n        },\n\n        /**\n         * Initializes columns root container.\n         *\n         * @param {HTMLElement} node\n         * @returns {View} Chainable.\n         */\n        initRoot: function (node) {\n            $(this.headerButtonsTmpl)\n                .insertBefore(node)\n                .applyBindings(this.model);\n\n            return this;\n        },\n\n        /**\n         * Initializes table element.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {View} Chainable.\n         */\n        initTable: function (table) {\n            $(table).bindings(this.tableBindings);\n\n            this.initBulk(table);\n\n            return this;\n        },\n\n        /**\n         * Initializes bulk editor element\n         * for the provided table.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {View} Chainable.\n         */\n        initBulk: function (table) {\n            var tableBody = $('tbody', table)[0];\n\n            $(this.bulkTmpl)\n                .prependTo(tableBody)\n                .applyBindings(this.model);\n\n            return this;\n        },\n\n        /**\n         * Initializes table row.\n         *\n         * @param {HTMLTableRowElement} row\n         * @returns {View} Chainable.\n         */\n        initRow: function (row) {\n            var $editingRow;\n\n            $(row).extendCtx({\n                    _editor: this.model\n                }).bindings(this.rowBindings);\n\n            $editingRow = $(this.rowTmpl)\n                .insertBefore(row)\n                .applyBindings(row);\n\n            ko.utils.domNodeDisposal.addDisposeCallback(row, this.removeEditingRow.bind(this, $editingRow));\n\n            return this;\n        },\n\n        /**\n         * Returns row bindings.\n         *\n         * @param {Object} ctx - Current context of a row.\n         * @returns {Object}\n         */\n        rowBindings: function (ctx) {\n            var model = this.model;\n\n            return {\n                visible: ko.computed(function () {\n                    var record = ctx.$row(),\n                        index = record && record._rowIndex;\n\n                    return !model.isActive(index, true);\n                })\n            };\n        },\n\n        /**\n         * Returns table bindings.\n         *\n         * @returns {Object}\n         */\n        tableBindings: function () {\n            var model = this.model;\n\n            return {\n                css: {\n                    '_in-edit': ko.computed(function () {\n                        return model.hasActive() && !model.permanentlyActive;\n                    })\n                }\n            };\n        },\n\n        /**\n         * Removes specified array of nodes.\n         *\n         * @param {ArrayLike} row\n         */\n        removeEditingRow: function (row) {\n            _.toArray(row).forEach(ko.removeNode);\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/editor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'mage/translate',\n    'uiCollection'\n], function (_, utils, layout, $t, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            rowButtonsTmpl: 'ui/grid/editing/row-buttons',\n            headerButtonsTmpl: 'ui/grid/editing/header-buttons',\n            successMsg: $t('You have successfully saved your edits.'),\n            errorsCount: 0,\n            bulkEnabled: true,\n            multiEditingButtons: true,\n            singleEditingButtons: true,\n            isMultiEditing: false,\n            isSingleEditing: false,\n            permanentlyActive: false,\n            rowsData: [],\n            fields: {},\n\n            templates: {\n                record: {\n                    parent: '${ $.$data.editor.name }',\n                    name: '${ $.$data.recordId }',\n                    component: 'Magento_Ui/js/grid/editing/record',\n                    columnsProvider: '${ $.$data.editor.columnsProvider }',\n                    editorProvider: '${ $.$data.editor.name }',\n                    preserveFields: {\n                        '${ $.$data.editor.indexField }': true\n                    }\n                }\n            },\n            bulkConfig: {\n                component: 'Magento_Ui/js/grid/editing/bulk',\n                name: '${ $.name }_bulk',\n                editorProvider: '${ $.name }',\n                columnsProvider: '${ $.columnsProvider }'\n            },\n            clientConfig: {\n                component: 'Magento_Ui/js/grid/editing/client',\n                name: '${ $.name }_client'\n            },\n            viewConfig: {\n                component: 'Magento_Ui/js/grid/editing/editor-view',\n                name: '${ $.name }_view',\n                model: '${ $.name }',\n                columnsProvider: '${ $.columnsProvider }'\n            },\n            imports: {\n                rowsData: '${ $.dataProvider }:data.items'\n            },\n            listens: {\n                '${ $.dataProvider }:reloaded': 'cancel',\n                '${ $.selectProvider }:selected': 'onSelectionsChange'\n            },\n            modules: {\n                source: '${ $.dataProvider }',\n                client: '${ $.clientConfig.name }',\n                columns: '${ $.columnsProvider }',\n                bulk: '${ $.bulkConfig.name }',\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /**\n         * Initializes editor component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateState', 'countErrors', 'onDataSaved', 'onSaveError');\n\n            this._super()\n                .initBulk()\n                .initClient()\n                .initView();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'errorsCount',\n                    'isMultiEditing',\n                    'isSingleEditing',\n                    'isSingleColumnEditing',\n                    'changed'\n                ])\n                .observe({\n                    canSave: true,\n                    activeRecords: [],\n                    messages: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes bulk editing component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initBulk: function () {\n            if (this.bulkEnabled) {\n                layout([this.bulkConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes editors' view component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initView: function () {\n            layout([this.viewConfig]);\n\n            return this;\n        },\n\n        /**\n         * Initializes client component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initClient: function () {\n            layout([this.clientConfig]);\n\n            return this;\n        },\n\n        /**\n         * Creates instance of a new record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        initRecord: function (id, isIndex) {\n            var record = this.buildRecord(id, isIndex);\n\n            layout([record]);\n\n            return this;\n        },\n\n        /**\n         * Adds listeners on a new record.\n         *\n         * @param {Record} record\n         * @returns {Editor} Chainable.\n         */\n        initElement: function (record) {\n            record.on({\n                'active': this.updateState,\n                'errorsCount': this.countErrors\n            });\n\n            this.updateState();\n\n            return this._super();\n        },\n\n        /**\n         * Creates configuration for a new record associated with a row data.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Object} Record configuration.\n         */\n        buildRecord: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex),\n                recordTmpl = this.templates.record,\n                record;\n\n            if (this.getRecord(recordId)) {\n                return this;\n            }\n\n            record = utils.template(recordTmpl, {\n                editor: this,\n                recordId: id\n            });\n\n            record.recordId = id;\n            record.data     = this.getRowData(id);\n\n            return record;\n        },\n\n        /**\n         * Starts editing of a specified record. If records'\n         * instance doesn't exist, than it will be created.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        edit: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex),\n                record   = this.getRecord(recordId);\n\n            record ?\n                record.active(true) :\n                this.initRecord(recordId);\n\n            return this;\n        },\n\n        /**\n         * Drops list of selections while activating only the specified record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        startEdit: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex);\n\n            this.selections()\n                .deselectAll()\n                .select(recordId);\n\n            return this.edit(recordId);\n        },\n\n        /**\n         * Hides records and resets theirs data.\n         *\n         * @returns {Editor} Chainable.\n         */\n        cancel: function () {\n            this.reset()\n                .hide()\n                .clearMessages()\n                .bulk('clear');\n\n            return this;\n        },\n\n        /**\n         * Hides records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        hide: function () {\n            this.activeRecords.each('active', false);\n\n            return this;\n        },\n\n        /**\n         * Resets active records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        reset: function () {\n            this.elems.each(function (record) {\n                this.resetRecord(record.recordId);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Validates and saves data of active records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        save: function () {\n            var data;\n\n            if (!this.isValid()) {\n                return this;\n            }\n\n            data = {\n                items: this.getData()\n            };\n\n            this.clearMessages()\n                .columns('showLoader');\n\n            this.client()\n                .save(data)\n                .done(this.onDataSaved)\n                .fail(this.onSaveError);\n\n            return this;\n        },\n\n        /**\n         * Validates all active records.\n         *\n         * @returns {Array} An array of records and theirs validation results.\n         */\n        validate: function () {\n            return this.activeRecords.map(function (record) {\n                return {\n                    target: record,\n                    valid: record.isValid()\n                };\n            });\n        },\n\n        /**\n         * Checks if all active records are valid.\n         *\n         * @returns {Boolean}\n         */\n        isValid: function () {\n            return _.every(this.validate(), 'valid');\n        },\n\n        /**\n         * Returns active records data, indexed by a theirs ids.\n         *\n         * @returns {Object} Collection of records data.\n         */\n        getData: function () {\n            var data = this.activeRecords.map(function (record) {\n                var elemKey,\n                    recordData = record.getData();\n\n                for (elemKey in recordData) {\n                    if (_.isUndefined(recordData[elemKey])) {\n                        recordData[elemKey] = null;\n                    }\n                }\n\n                return recordData;\n            });\n\n            return _.indexBy(data, this.indexField);\n        },\n\n        /**\n         * Sets provided data to all active records.\n         *\n         * @param {Object} data - See 'setData' method of a 'Record'.\n         * @param {Boolean} partial - See 'setData' method of a 'Record'.\n         * @returns {Editor} Chainable.\n         */\n        setData: function (data, partial) {\n            this.activeRecords.each('setData', data, partial);\n\n            return this;\n        },\n\n        /**\n         * Resets specific records' data\n         * to the data present in associated row.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        resetRecord: function (id, isIndex) {\n            var record  = this.getRecord(id, isIndex),\n                data    = this.getRowData(id, isIndex);\n\n            if (record && data) {\n                record.setData(data);\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a specified record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Record}\n         */\n        getRecord: function (id, isIndex) {\n            return this.elems.findWhere({\n                recordId: this.getId(id, isIndex)\n            });\n        },\n\n        /**\n         * Creates record name based on a provided id.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {String}\n         */\n        formRecordName: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.name + '.' + id;\n        },\n\n        /**\n         * Disables editing of specified fields.\n         *\n         * @param {Array} fields - An array of fields indexes to be disabled.\n         * @returns {Editor} Chainable.\n         */\n        disableFields: function (fields) {\n            var columns = this.columns().elems(),\n                data    = utils.copy(this.fields);\n\n            columns.forEach(function (column) {\n                var index = column.index,\n                    field = data[index] = data[index] || {};\n\n                field.disabled = _.contains(fields, index);\n            });\n\n            this.set('fields', data);\n\n            return this;\n        },\n\n        /**\n         * Converts index of a row into the record id.\n         *\n         * @param {(Number|String)} id - Records' identifier or its' index in the rows array.\n         * @param {Boolean} [isIndex=false] - Flag that indicates if first\n         *      parameter is an index or identifier.\n         * @returns {String} Records' id.\n         */\n        getId: function (id, isIndex) {\n            var rowsData = this.rowsData,\n                record;\n\n            if (isIndex === true) {\n                record  = rowsData[id];\n                id      = record ? record[this.indexField] : false;\n            }\n\n            return id;\n        },\n\n        /**\n         * Returns data of a specified row.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Object}\n         */\n        getRowData: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return _.find(this.rowsData, function (row) {\n                return row[this.indexField] === id;\n            }, this);\n        },\n\n        /**\n         * Checks if specified record is active.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See'getId' method.\n         * @returns {Boolean}\n         */\n        isActive: function (id, isIndex) {\n            var record = this.getRecord(id, isIndex);\n\n            return _.contains(this.activeRecords(), record);\n        },\n\n        /**\n         * Checks if editor has active records.\n         *\n         * @returns {Boolean}\n         */\n        hasActive: function () {\n            return !!this.activeRecords().length || this.permanentlyActive;\n        },\n\n        /**\n         * Counts number of active records.\n         *\n         * @returns {Number}\n         */\n        countActive: function () {\n            return this.activeRecords().length;\n        },\n\n        /**\n         * Counts number of invalid fields across all active records.\n         *\n         * @returns {Number}\n         */\n        countErrors: function () {\n            var errorsCount = 0;\n\n            this.activeRecords.each(function (record) {\n                errorsCount += record.errorsCount;\n            });\n\n            this.errorsCount = errorsCount;\n\n            return errorsCount;\n        },\n\n        /**\n         * Translatable error message text.\n         *\n         * @returns {String}\n         */\n        countErrorsMessage: function () {\n            return $t('There are {placeholder} messages requires your attention.')\n                .replace('{placeholder}', this.countErrors());\n        },\n\n        /**\n         * Checks if editor has any errors.\n         *\n         * @returns {Boolean}\n         */\n        hasErrors: function () {\n            return !!this.countErrors();\n        },\n\n        /**\n         * Handles changes of the records 'active' property.\n         *\n         * @returns {Editor} Chainable.\n         */\n        updateState: function () {\n            var active      = this.elems.filter('active'),\n                activeCount = active.length,\n                columns     = this.columns().elems;\n\n            columns.each('disableAction', !!activeCount);\n\n            this.isMultiEditing = activeCount > 1;\n            this.isSingleEditing = activeCount === 1;\n\n            this.activeRecords(active);\n\n            return this;\n        },\n\n        /**\n         * Returns list of selections from a current page.\n         *\n         * @returns {Array}\n         */\n        getSelections: function () {\n            return this.selections().getPageSelections();\n        },\n\n        /**\n         * Starts editing of selected records. If record\n         * is not in the selections list, then it will get hidden.\n         *\n         * @returns {Editor} Chainable.\n         */\n        editSelected: function () {\n            var selections = this.getSelections();\n\n            this.elems.each(function (record) {\n                if (!_.contains(selections, record.recordId)) {\n                    record.active(false);\n                }\n            });\n\n            selections.forEach(function (id) {\n                this.edit(id);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Checks if there is any additional messages.\n         *\n         * @returns {Boolean}\n         */\n        hasMessages: function () {\n            return this.messages().length;\n        },\n\n        /**\n         * Adds new additional message or a set of messages.\n         *\n         * @param {(Object|Array)} message - Messages to be added.\n         * @returns {Editor} Chainable.\n         */\n        addMessage: function (message) {\n            var messages = this.messages();\n\n            Array.isArray(message) ?\n                messages.push.apply(messages, message) :\n                messages.push(message);\n\n            this.messages(messages);\n\n            return this;\n        },\n\n        /**\n         * Removes all additional messages.\n         *\n         * @returns {Editor} Chainable.\n         */\n        clearMessages: function () {\n            this.messages.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Listener of the selections data changes.\n         */\n        onSelectionsChange: function () {\n            if (this.hasActive()) {\n                this.editSelected();\n            }\n        },\n\n        /**\n         * Handles successful save request.\n         */\n        onDataSaved: function () {\n            var msg = {\n                type: 'success',\n                message: this.successMsg\n            };\n\n            this.addMessage(msg)\n                .source('reload', {\n                    refresh: true\n                });\n        },\n\n        /**\n         * Handles failed save request.\n         *\n         * @param {(Array|Object)} errors - List of errors or a single error object.\n         */\n        onSaveError: function (errors) {\n            this.addMessage(errors)\n                .columns('hideLoader');\n        }\n    });\n});\n","Magento_Ui/js/grid/paging/paging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiElement'\n], function (ko, _, utils, layout, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/paging/paging',\n            totalTmpl: 'ui/grid/paging-total',\n            totalRecords: 0,\n            showTotalRecords: true,\n            pages: 1,\n            current: 1,\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                }\n            },\n\n            imports: {\n                totalSelected: '${ $.selectProvider }:totalSelected',\n                totalRecords: '${ $.provider }:data.totalRecords',\n                showTotalRecords: '${ $.provider }:data.showTotalRecords',\n                filters: '${ $.provider }:params.filters',\n                keywordUpdated: '${ $.provider }:params.keywordUpdated'\n            },\n\n            exports: {\n                pageSize: '${ $.provider }:params.paging.pageSize',\n                current: '${ $.provider }:params.paging.current'\n            },\n\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n\n            statefull: {\n                pageSize: true,\n                current: true\n            },\n\n            listens: {\n                'pages': 'onPagesChange',\n                'pageSize': 'onPageSizeChange',\n                'totalRecords': 'updateCounter',\n                'showTotalRecords': 'updateShowTotalRecords',\n                '${ $.provider }:params.filters': 'goFirst',\n                '${ $.provider }:params.search': 'onSearchUpdate'\n            },\n\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes()\n                .updateCounter();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'totalSelected',\n                    'totalRecords',\n                    'showTotalRecords',\n                    'pageSize',\n                    'pages',\n                    'current'\n                ]);\n\n            this._current = ko.pureComputed({\n                read: ko.getObservable(this, 'current'),\n\n                /**\n                 * Validates page change according to user's input.\n                 * Sets current observable to result of validation.\n                 * Calls reload method then.\n                 */\n                write: function (value) {\n                    this.setPage(value)\n                        ._current.notifySubscribers(this.current);\n                },\n\n                owner: this\n            });\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            layout([this.sizesConfig]);\n\n            return this;\n        },\n\n        /**\n         * Gets first item index on current page.\n         *\n         * @returns {Number}\n         */\n        getFirstItemIndex: function () {\n            return this.pageSize * (this.current - 1) + 1;\n        },\n\n        /**\n         * Gets last item index on current page.\n         *\n         * @returns {Number}\n         */\n        getLastItemIndex: function () {\n            var lastItem = this.getFirstItemIndex() + this.pageSize - 1;\n\n            return this.totalRecords < lastItem ? this.totalRecords : lastItem;\n        },\n\n        /**\n         * Sets cursor to the provied value.\n         *\n         * @param {(Number|String)} value - New value of the cursor.\n         * @returns {Paging} Chainable.\n         */\n        setPage: function (value) {\n            this.current = this.normalize(value);\n\n            return this;\n        },\n\n        /**\n         * Increments current page value.\n         *\n         * @returns {Paging} Chainable.\n         */\n        next: function () {\n            this.setPage(this.current + 1);\n\n            return this;\n        },\n\n        /**\n         * Decrements current page value.\n         *\n         * @returns {Paging} Chainable.\n         */\n        prev: function () {\n            this.setPage(this.current - 1);\n\n            return this;\n        },\n\n        /**\n         * Goes to the first page.\n         *\n         * @returns {Paging} Chainable.\n         */\n        goFirst: function () {\n            if (!_.isUndefined(this.filters)) {\n                this.current = 1;\n            }\n\n            return this;\n        },\n\n        /**\n         * Goes to the last page.\n         *\n         * @returns {Paging} Chainable.\n         */\n        goLast: function () {\n            this.current = this.pages;\n\n            return this;\n        },\n\n        /**\n         * Checks if current page is the first one.\n         *\n         * @returns {Boolean}\n         */\n        isFirst: function () {\n            return this.current === 1;\n        },\n\n        /**\n         * Checks if current page is the last one.\n         *\n         * @returns {Boolean}\n         */\n        isLast: function () {\n            return this.current === this.pages;\n        },\n\n        /**\n         * Updates number of pages.\n         */\n        updateCounter: function () {\n            this.pages = Math.ceil(this.totalRecords / this.pageSize) || 1;\n\n            return this;\n        },\n\n        /**\n         * Updates show total records flag.\n         */\n        updateShowTotalRecords: function () {\n            if (this.showTotalRecords === undefined) {\n                this.showTotalRecords = true;\n            }\n            return this;\n        },\n\n        /**\n         * Calculates new page cursor based on the\n         * previous and current page size values.\n         */\n        updateCursor: function () {\n            var cursor = this.current - 1,\n                size = this.pageSize,\n                oldSize = _.isUndefined(this.previousSize) ? this.pageSize : this.previousSize,\n                delta = cursor * (oldSize - size) / size;\n\n            delta = size > oldSize ?\n                Math.ceil(delta) :\n                Math.floor(delta);\n\n            cursor += delta + 1;\n\n            this.previousSize = size;\n\n            this.setPage(cursor);\n\n            return this;\n        },\n\n        /**\n         * Converts provided value to a number and puts\n         * it in range between 1 and total amount of pages.\n         *\n         * @param {(Number|String)} value - Value to be normalized.\n         * @returns {Number}\n         */\n        normalize: function (value) {\n            value = +value;\n\n            if (isNaN(value)) {\n                return 1;\n            }\n\n            return utils.inRange(Math.round(value), 1, this.pages);\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            this.updateCounter()\n                .updateCursor();\n        },\n\n        /**\n         * Handles changes of the pages amount.\n         */\n        onPagesChange: function () {\n            this.updateCursor();\n        },\n\n        /**\n         * Resent the pagination to Page 1 on search keyword update\n         */\n        onSearchUpdate: function () {\n            if (!_.isUndefined(this.keywordUpdated) && this.keywordUpdated) {\n                this.goFirst();\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiElement'\n], function (ko, _, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/paging/sizes',\n            minSize: 1,\n            maxSize: 999,\n            statefull: {\n                options: true,\n                value: true\n            },\n            listens: {\n                value: 'onValueChange',\n                options: 'onSizesChange'\n            }\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .updateArray();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'value',\n                    'editing',\n                    'customVisible',\n                    'customValue'\n                ])\n                .track({\n                    optionsArray: []\n                });\n\n            this._value = ko.pureComputed({\n                read: ko.getObservable(this, 'value'),\n\n                /**\n                 * Validates input field prior to updating 'value' property.\n                 */\n                write: function (value) {\n                    value = this.normalize(value);\n\n                    this.value = value;\n                    this._value.notifySubscribers(value);\n                },\n\n                owner: this\n            });\n\n            return this;\n        },\n\n        /**\n         * Starts editing of the specified size.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Sizes} Chainable.\n         */\n        edit: function (value) {\n            this.editing = value;\n\n            return this;\n        },\n\n        /**\n         * Discards changes made to the currently editable size.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardEditing: function () {\n            var value = this.editing;\n\n            if (value) {\n                this.updateSize(value, value);\n            }\n\n            return this;\n        },\n\n        /**\n         * Invokes 'discardEditing' and 'discardCustom' actions.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardAll: function () {\n            this.discardEditing()\n                .discardCustom();\n\n            return this;\n        },\n\n        /**\n         * Returns value of the first size.\n         *\n         * @returns {Number}\n         */\n        getFirst: function () {\n            return this.optionsArray[0].value;\n        },\n\n        /**\n         * Returns size which matches specified value.\n         *\n         * @param {Number} value - Value of the item.\n         * @returns {Object|Undefined}\n         */\n        getSize: function (value) {\n            return this.options[value];\n        },\n\n        /**\n         * Sets current size to the specified value.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Sizes} Chainable.\n         */\n        setSize: function (value) {\n            this.value = value;\n\n            return this;\n        },\n\n        /**\n         * Adds a new value to sizes list.\n         *\n         * @param {Number} value - Value to be added.\n         * @returns {Sizes} Chainable.\n         */\n        addSize: function (value) {\n            var size;\n\n            if (!this.hasSize(value)) {\n                size = this.createSize(value);\n\n                this.set('options.' + value, size);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes provided value from the sizes list.\n         *\n         * @param {Number} value - Value to be removed.\n         * @returns {Sizes} Chainable.\n         */\n        removeSize: function (value) {\n            if (!this.hasSize(value)) {\n                return this;\n            }\n\n            this.remove('options.' + value);\n\n            if (this.isSelected(value)) {\n                this.setSize(this.getFirst());\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates existing value to the provided one. If new value\n         * is not specified, then sizes' '_value' property will be taken.\n         *\n         * @param {Number} value - Existing value that should be updated.\n         * @param {(Number|String)} [newValue=size._value] - New size value.\n         * @returns {Sizes} Chainable.\n         */\n        updateSize: function (value, newValue) {\n            var size = this.getSize(value);\n\n            if (!size) {\n                return this;\n            }\n\n            newValue = newValue || size._value;\n\n            if (isNaN(+newValue)) {\n                this.discardEditing();\n\n                return this;\n            }\n\n            newValue = this.normalize(newValue);\n\n            this.remove('options.' + value)\n                .addSize(newValue);\n\n            if (this.isSelected(value)) {\n                this.setSize(newValue);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates new editable size instance with the provided value.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Object}\n         */\n        createSize: function (value) {\n            return {\n                value: value,\n                label: value,\n                _value: value,\n                editable: true\n            };\n        },\n\n        /**\n         * Checks if provided value exists in the sizes list.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        hasSize: function (value) {\n            return !!this.getSize(value);\n        },\n\n        /**\n         * Hides and clears custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardCustom: function () {\n            this.hideCustom()\n                .clearCustom();\n\n            return this;\n        },\n\n        /**\n         * Shows custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        showCustom: function () {\n            this.customVisible = true;\n\n            return this;\n        },\n\n        /**\n         * Hides custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        hideCustom: function () {\n            this.customVisible = false;\n\n            return this;\n        },\n\n        /**\n         * Empties value of the custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        clearCustom: function () {\n            this.customValue = '';\n\n            return this;\n        },\n\n        /**\n         * Adds a new size specified in the custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        applyCustom: function () {\n            var value = this.customValue;\n\n            value = this.normalize(value);\n\n            this.addSize(value)\n                .setSize(value)\n                .discardCustom();\n\n            return this;\n        },\n\n        /**\n         * Checks if custom field is visible.\n         *\n         * @returns {Boolean}\n         */\n        isCustomVisible: function () {\n            return this.customVisible;\n        },\n\n        /**\n         * Converts provided value to a number and puts\n         * it in range between 'minSize' and 'maxSize' properties.\n         *\n         * @param {(Number|String)} value - Value to be normalized.\n         * @returns {Number}\n         */\n        normalize: function (value) {\n            value = +value;\n\n            if (isNaN(value)) {\n                return this.getFirst();\n            }\n\n            return utils.inRange(Math.round(value), this.minSize, this.maxSize);\n        },\n\n        /**\n         * Updates the array of options.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        updateArray: function () {\n            var array = _.values(this.options);\n\n            this.optionsArray = _.sortBy(array, 'value');\n\n            return this;\n        },\n\n        /**\n         * Checks if provided value is in editing state.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEditing: function (value) {\n            return this.editing === value;\n        },\n\n        /**\n         * Checks if provided value is selected.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isSelected: function (value) {\n            return this.value === value;\n        },\n\n        /**\n         * Listener of the 'value' property changes.\n         */\n        onValueChange: function () {\n            this.discardAll()\n                .trigger('close');\n        },\n\n        /**\n         * Listener of the 'options' object changes.\n         */\n        onSizesChange: function () {\n            this.editing = false;\n\n            this.updateArray();\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/column.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiElement'\n], function (_, registry, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'ui/grid/cells/text',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: true,\n            sorting: false,\n            visible: true,\n            draggable: true,\n            fieldClass: {},\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                '${ $.provider }:params.sorting.field': 'onSortChange'\n            },\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes column component.\n         *\n         * @returns {Column} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFieldClass();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Column} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'visible',\n                    'sorting',\n                    'disableAction'\n                ])\n                .observe([\n                    'dragging'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Extends list of field classes.\n         *\n         * @returns {Column} Chainable.\n         */\n        initFieldClass: function () {\n            _.extend(this.fieldClass, {\n                _dragging: this.dragging\n            });\n\n            return this;\n        },\n\n        /**\n         * Applies specified stored state of a column or one of its' properties.\n         *\n         * @param {String} state - Defines what state should be used: saved or default.\n         * @param {String} [property] - Defines what columns' property should be applied.\n         *      If not specified, then all columns stored properties will be used.\n         * @returns {Column} Chainable.\n         */\n        applyState: function (state, property) {\n            var namespace = this.storageConfig.root;\n\n            if (property) {\n                namespace += '.' + property;\n            }\n\n            this.storage('applyStateOf', state, namespace);\n\n            return this;\n        },\n\n        /**\n         * Sets columns' sorting. If column is currently sorted,\n         * than its' direction will be toggled.\n         *\n         * @param {*} [enable=true] - If false, than sorting will\n         *      be removed from a column.\n         * @returns {Column} Chainable.\n         */\n        sort: function (enable) {\n            if (!this.sortable) {\n                return this;\n            }\n\n            enable !== false ?\n                this.toggleSorting() :\n                this.sorting = false;\n\n            return this;\n        },\n\n        /**\n         * Sets descending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortDescending: function () {\n            if (this.sortable) {\n                this.sorting = 'desc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets ascending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortAscending: function () {\n            if (this.sortable) {\n                this.sorting = 'asc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sorting direction.\n         *\n         * @returns {Column} Chainable.\n         */\n        toggleSorting: function () {\n            this.sorting === 'asc' ?\n                this.sortDescending() :\n                this.sortAscending();\n\n            return this;\n        },\n\n        /**\n         * Checks if column is sorted.\n         *\n         * @returns {Boolean}\n         */\n        isSorted: function () {\n            return !!this.sorting;\n        },\n\n        /**\n         * Exports sorting data to the dataProvider if\n         * sorting of a column is enabled.\n         */\n        exportSorting: function () {\n            if (!this.sorting) {\n                return;\n            }\n\n            this.source('set', 'params.sorting', {\n                field: this.index,\n                direction: this.sorting\n            });\n        },\n\n        /**\n         * Checks if column has an assigned action that will\n         * be performed when clicking on one of its' fields.\n         *\n         * @returns {Boolean}\n         */\n        hasFieldAction: function () {\n            return !!this.fieldAction || !!this.fieldActions;\n        },\n\n        /**\n         * Applies action described in a 'fieldAction' property\n         * or actions described in 'fieldActions' property.\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @returns {Column} Chainable.\n         *\n         * @example Example of fieldAction definition, which is equivalent to\n         *      referencing to external component named 'listing.multiselect'\n         *      and calling its' method 'toggleSelect' with params [rowIndex, true] =>\n         *\n         *      {\n         *          provider: 'listing.multiselect',\n         *          target: 'toggleSelect',\n         *          params: ['${ $.$data.rowIndex }', true]\n         *      }\n         */\n        applyFieldAction: function (rowIndex) {\n            if (!this.hasFieldAction() || this.disableAction) {\n                return this;\n            }\n\n            if (this.fieldActions) {\n                this.fieldActions.forEach(this.applySingleAction.bind(this, rowIndex), this);\n            } else {\n                this.applySingleAction(rowIndex);\n            }\n\n            return this;\n        },\n\n        /**\n         * Applies single action\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @param {Object} action - Action (fieldAction) to be applied\n         *\n         */\n        applySingleAction: function (rowIndex, action) {\n            var callback;\n\n            action = action || this.fieldAction;\n            action = utils.template(action, {\n                column: this,\n                rowIndex: rowIndex\n            }, true);\n\n            callback = this._getFieldCallback(action);\n\n            if (_.isFunction(callback)) {\n                callback();\n            }\n        },\n\n        /**\n         * Returns field action handler if it was specified.\n         *\n         * @param {Object} record - Record object with which action is associated.\n         * @returns {Function|Undefined}\n         */\n        getFieldHandler: function (record) {\n            if (this.hasFieldAction()) {\n                return this.applyFieldAction.bind(this, record._rowIndex);\n            }\n        },\n\n        /**\n         * Creates action callback based on its' data.\n         *\n         * @param {Object} action - Actions' object.\n         * @returns {Function|Boolean} Callback function or false\n         *      value if it was impossible create a callback.\n         */\n        _getFieldCallback: function (action) {\n            var args     = action.params || [],\n                callback = action.target;\n\n            if (action.provider && action.target) {\n                args.unshift(action.target);\n\n                callback = registry.async(action.provider);\n            }\n\n            if (!_.isFunction(callback)) {\n                return false;\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Ment to preprocess data associated with a current columns' field.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabel: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * UnsanitizedHtml version of getLabel.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabelUnsanitizedHtml: function (record) {\n            return this.getLabel(record);\n        },\n\n        /**\n         * Returns list of classes that should be applied to a field.\n         *\n         * @returns {Object}\n         */\n        getFieldClass: function () {\n            return this.fieldClass;\n        },\n\n        /**\n         * Returns path to the columns' header template.\n         *\n         * @returns {String}\n         */\n        getHeader: function () {\n            return this.headerTmpl;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Listener of the providers' sorting state changes.\n         *\n         * @param {Srting} field - Field by which current sorting is performed.\n         */\n        onSortChange: function (field) {\n            if (field !== this.index) {\n                this.sort(false);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/expandable.js":"/**\n * Copyright \u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    './column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/expandable',\n            tooltipTmpl: 'ui/grid/cells/expandable/content',\n            visibeItemsLimit: 5,\n            tooltipTitle: ''\n        },\n\n        /**\n         * Gets label from full options array.\n         *\n         * @param {Object} record - Record object.\n         * @returns {String}\n         */\n        getFullLabel: function (record) {\n            return this.getLabelsArray(record).join(', ');\n        },\n\n        /**\n         * Gets label from options array limited by 'visibeItemsLimit'.\n         *\n         * @param {Object} record - Record object.\n         * @returns {String}\n         */\n        getShortLabel: function (record) {\n            return this.getLabelsArray(record).slice(0, this.visibeItemsLimit).join(', ');\n        },\n\n        /**\n         * Extracts array of labels associated with provided values and sort it alphabetically.\n         *\n         * @param {Object} record - Record object.\n         * @returns {Array}\n         */\n        getLabelsArray: function (record) {\n            var values = this.getLabel(record),\n                options = this.options || [],\n                labels = [];\n\n            if (_.isString(values)) {\n                values = values.split(',');\n            }\n\n            if (!Array.isArray(values)) {\n                values = [values];\n            }\n\n            values = values.map(function (value) {\n                return value + '';\n            });\n\n            options = this.flatOptions(options);\n\n            options.forEach(function (item) {\n                if (_.contains(values, item.value + '')) {\n                    labels.push(item.label);\n                }\n            });\n\n            return labels.sort(\n                function (labelFirst, labelSecond) {\n                    return labelFirst.toLowerCase().localeCompare(labelSecond.toLowerCase());\n                }\n            );\n        },\n\n        /**\n         * Transformation tree options structure to liner array.\n         *\n         * @param {Array} options\n         * @returns {Array}\n         */\n        flatOptions: function (options) {\n            var self = this;\n\n            return options.reduce(function (opts, option) {\n                if (_.isArray(option.value)) {\n                    opts = opts.concat(self.flatOptions(option.value));\n                } else {\n                    opts.push(option);\n                }\n\n                return opts;\n            }, []);\n        },\n\n        /**\n         * Checks if amount of options is more than limit value.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isExpandable: function (record) {\n            return this.getLabel(record).length > this.visibeItemsLimit;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/link.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './column',\n    'mageUtils'\n], function (Column, utils) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            link: 'link',\n            bodyTmpl: 'ui/grid/cells/link'\n        },\n\n        /**\n         * Returns link to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLink: function (record) {\n            return utils.nested(record, this.link);\n        },\n\n        /**\n         * Check if link parameter exist in record.\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isLink: function (record) {\n            return !!utils.nested(record, this.link);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/onoff.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mage/translate',\n    './multiselect',\n    'uiRegistry'\n], function (_, $t, Column, registry) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/onoff',\n            bodyTmpl: 'ui/grid/cells/onoff',\n            fieldClass: {\n                'admin__scope-old': true,\n                'data-grid-onoff-cell': true,\n                'data-grid-checkbox-cell': false\n            },\n            imports: {\n                selectedData: '${ $.provider }:data.selectedData'\n            },\n            listens: {\n                '${ $.provider }:reloaded': 'setDefaultSelections'\n            }\n        },\n\n        /**\n         * @param {Number} id\n         * @returns {*}\n         */\n        getLabel: function (id) {\n            return this.selected.indexOf(id) !== -1 ? $t('On') : $t('Off');\n        },\n\n        /**\n         * Sets the ids for preselected elements\n         * @returns void\n         */\n        setDefaultSelections: function () {\n            var positionCacheValid = registry.get('position_cache_valid'),\n                selectedFromCache = registry.get('selected_cache'),\n                key,\n                i;\n\n            if (positionCacheValid && this.selected().length === 0) {\n                // Check selected data\n                selectedFromCache = JSON.parse(selectedFromCache);\n\n                for (i = 0; i < selectedFromCache.length; i++) {\n                    this.selected.push(selectedFromCache[i]);\n                }\n\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n\n                return;\n            }\n\n            if (positionCacheValid && this.selected().length > 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n\n                return;\n            }\n\n            if (this.selectedData.length === 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify([]));\n\n                return;\n            }\n\n            // Check selected data\n            for (key in this.selectedData) {\n                if (this.selectedData.hasOwnProperty(key) && this.selected().indexOf(key) === -1) {\n                    this.selected.push(key);\n                }\n            }\n            // Uncheck unselected data\n            for (i = 0; i < this.selected().length; i++) {\n                key = this.selected()[i];\n                this.selectedData.hasOwnProperty(key) || this.selected.splice(this.selected().indexOf(key), 1);\n                this.selectedData.hasOwnProperty(key) || i--;\n            }\n            registry.set('position_cache_valid', true);\n            registry.set('selected_cache', JSON.stringify(this.selected()));\n        },\n\n        /**\n         * Show/hide action in the massaction menu\n         * @param {Number} actionId\n         * @returns {Boolean}\n         */\n        isActionRelevant: function (actionId) {\n            var relevant = true;\n\n            switch (actionId) {\n                case 'selectPage':\n                    relevant = !this.isPageSelected(true);\n                    break;\n\n                case 'deselectPage':\n                    relevant =  this.isPageSelected();\n                    break;\n            }\n\n            return relevant;\n        },\n\n        /**\n         * Updates values of the 'allSelected'\n         * and 'indetermine' properties.\n         *\n         * @returns {Object} Chainable.\n         */\n        updateState: function () {\n            var positionCacheValid = registry.get('position_cache_valid'),\n                totalRecords    = this.totalRecords(),\n                selected        = this.selected().length,\n                excluded        = this.excluded().length,\n                totalSelected   = this.totalSelected(),\n                allSelected;\n\n            if (positionCacheValid && this.selected().length > 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n            }\n\n            // When filters are enabled then totalRecords is unknown\n            if (this.getFiltering()) {\n                if (this.getFiltering().search !== '') {\n                    totalRecords = -1;\n                }\n            }\n\n            allSelected = totalRecords && totalSelected === totalRecords;\n\n            if (this.excludeMode()) {\n                if (excluded === totalRecords) {\n                    this.deselectAll();\n                }\n            } else if (totalRecords && selected === totalRecords) {\n                this.selectAll();\n            }\n\n            this.allSelected(allSelected);\n            this.indetermine(totalSelected && !allSelected);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mageUtils',\n    'moment',\n    './column',\n    'underscore',\n    'moment-timezone-with-data'\n], function (utils, moment, Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            dateFormat: 'MMM d, YYYY h:mm:ss A',\n            calendarConfig: []\n        },\n\n        /**\n         * Overrides base method to normalize date format\n         *\n         * @returns {DateColumn} Chainable\n         */\n        initConfig: function () {\n            this._super();\n\n            this.dateFormat = utils.normalizeDate(this.dateFormat ? this.dateFormat : this.options.dateFormat);\n\n            return this;\n        },\n\n        /**\n         * Formats incoming date based on the 'dateFormat' property.\n         *\n         * @returns {String} Formatted date.\n         */\n        getLabel: function (value, format) {\n            var date;\n\n            if (this.storeLocale !== undefined) {\n                moment.locale(this.storeLocale, utils.extend({}, this.calendarConfig));\n            }\n\n            date = moment.utc(this._super());\n\n            if (!_.isUndefined(this.timezone) && moment.tz.zone(this.timezone) !== null) {\n                date = date.tz(this.timezone);\n            }\n\n            date = date.isValid() && value[this.index] ?\n                date.format(format || this.dateFormat) :\n                '';\n\n            return date;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/image-preview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Ui/js/lib/key-codes'\n], function ($, _, Column, keyCodes) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/columns/image-preview',\n            previewImageSelector: '[data-image-preview]',\n            visibleRecord: null,\n            height: 0,\n            displayedRecord: {},\n            lastOpenedImage: false,\n            fields: {\n                previewUrl: 'preview_url',\n                title: 'title'\n            },\n            modules: {\n                masonry: '${ $.parentName }',\n                thumbnailComponent: '${ $.parentName }.thumbnail_url'\n            },\n            statefull: {\n                sorting: true,\n                lastOpenedImage: true\n            },\n            listens: {\n                '${ $.provider }:params.filters': 'hide',\n                '${ $.provider }:params.search': 'hide',\n                '${ $.provider }:params.paging': 'hide',\n                '${ $.provider }:data.items': 'updateDisplayedRecord'\n            },\n            exports: {\n                height: '${ $.parentName }.thumbnail_url:previewHeight'\n            }\n        },\n\n        /**\n         * Initialize image preview component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            $(document).on('keydown', this.handleKeyDown.bind(this));\n\n            this.lastOpenedImage.subscribe(function (newValue) {\n\n                if (newValue === false && _.isNull(this.visibleRecord())) {\n                    return;\n                }\n\n                if (newValue === this.visibleRecord()) {\n                    return;\n                }\n\n                if (newValue === false) {\n                    this.hide();\n\n                    return;\n                }\n\n                this.show(this.masonry().rows()[newValue]);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         * @return {