require.config({"config": {
        "jsbuild":{"Magento_Integration/js/integration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * jQuery plugin is added.\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.integration', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            /**\n             * URL of the integration grid.\n             * @type {String}\n             */\n            gridUrl: ''\n        },\n\n        /**\n         * Bind event handler for the action when admin clicks \"Save & Activate\" button.\n         * @private\n         */\n        _create: function () {\n            if ($('#save-split-button-activate').length) {\n                // We're on the \"New integration\" page - bind related handler\n                this._form = $('#edit_form');\n                this._form.on('saveAndActivate', $.proxy(this._saveAndActivate, this));\n            }\n        },\n\n        /**\n         * Save new integration, then kick off the activate dialog.\n         * @private\n         */\n        _saveAndActivate: function () {\n            if (this._form.validation && !this._form.validation('isValid')) {\n                return false;\n            }\n\n            $.ajax({\n                url: this._form.prop('action'),\n                type: 'post',\n                data: this._form.serialize(),\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (data) {\n                    var integrationName, that;\n\n                    if (data._redirect) {\n                        window.location.href = data._redirect;\n                    } else if (data.integrationId) {\n                        integrationName = $('#integration_properties_name').val();\n                        window.integration.popup.show($('<span>').attr({\n                            'data-row-dialog': 'permissions',\n                            'data-row-id': data.integrationId,\n                            // We do escaping here instead of the place of actual output because _showPopup()\n                            // actually receives dialog window title from couple of places: from here and from the grid.\n                            // The issue is we always should escape values in the grid, so that value is already\n                            // escaped. To avoid double escaping we do it here instead of the output.\n                            'data-row-name': $('<div>').text(integrationName).html(),\n                            'data-row-is-reauthorize': '0',\n                            'data-row-is-token-exchange': data.isTokenExchange\n                        }));\n                        that = this;\n                        $('#integration-popup-container').on('dialogclose', function () {\n                            $('body').trigger('processStart');\n                            window.location.href = that.options.gridUrl;\n\n                            return false;\n                        });\n                    }\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n\n            return true;\n        }\n    });\n\n    /**\n     * @param {*} permissionsDialogUrl\n     * @param {*} tokensDialogUrl\n     * @param {*} tokensExchangeUrl\n     * @param {*} gridUrl\n     * @param {*} successCallbackUrl\n     * @return {Object}\n     * @constructor\n     */\n    window.Integration = function (\n        permissionsDialogUrl,\n        tokensDialogUrl,\n        tokensExchangeUrl,\n        gridUrl,\n        successCallbackUrl\n    ) {\n        var url = {\n            permissions: permissionsDialogUrl,\n            tokens: tokensDialogUrl,\n            tokensExchange: tokensExchangeUrl,\n            grid: gridUrl\n        },\n        IdentityLogin = {\n            win: null,\n            strLocation: null,\n            checker: null,\n            isCalledBack: false,\n            //Info popup dialog. Should be hidden when login window is closed\n            jqInfoDialog: $('#integration-popup-container'),\n            successCallbackUrl: successCallbackUrl,\n            Constants: {\n                /*\n                 This interval is set such that it adjusts to the child window closing timeout of 1000 ms. This will\n                 give the checker function enough time to detect if the successCallback has been invoked\n                 */\n                CHECKER_INTERVAL: 500,\n                //Login screen size plus some buffer\n                WIDTH: 680,\n                HEIGHT: 510,\n                // subtract pixels(30) and width(680) from screen width to move popup from extreme left\n                LEFT: screen.width - 680 - 30,\n                // subtract pixels(300) and height(300) from screen height to move from top\n                TOP: screen.height - 510 - 300\n            },\n\n            /**\n             * @param {*} identityCallbackUrl\n             * @param {*} consumerKey\n             * @param {*} jqInfoDialog\n             */\n            invokePopup: function (identityCallbackUrl, consumerKey, jqInfoDialog) {\n                var param;\n\n                // Callback should be invoked only once. Reset callback flag on subsequent invocations.\n                IdentityLogin.isCalledBack = false;\n                IdentityLogin.jqInfoDialog = jqInfoDialog;\n                param = $.param({\n                    'oauth_consumer_key': consumerKey,\n                    'success_call_back': IdentityLogin.successCallbackUrl\n                });\n                IdentityLogin.win = window.open(identityCallbackUrl + '?' + param, '',\n                    'top=' + IdentityLogin.Constants.TOP +\n                        ', left=' + IdentityLogin.Constants.LEFT +\n                        ', width=' + IdentityLogin.Constants.WIDTH +\n                        ', height=' + IdentityLogin.Constants.HEIGHT + ',scrollbars=no');\n\n                if (IdentityLogin.checker != null) {\n                    //Clear any previous check\n                    clearInterval(IdentityLogin.checker);\n                }\n                //Polling to detect url of the child window.\n                IdentityLogin.checker = setInterval(\n                    IdentityLogin.fnCheckLocation, IdentityLogin.Constants.CHECKER_INTERVAL\n                );\n            },\n\n            /**\n             * Function to check the location of the child popup window.\n             * Once detected if the callback is successful, parent window will be reloaded\n             */\n            fnCheckLocation: function () {\n                if (IdentityLogin.win == null) {\n                    return;\n                }\n                // Check to see if the location has changed.\n                try {\n                    //Is the success callback invoked\n                    if (IdentityLogin.win.closed ||\n                        IdentityLogin.win.location.href == IdentityLogin.successCallbackUrl //eslint-disable-line eqeqeq\n                    ) {\n                        //Stop the polling\n                        clearInterval(IdentityLogin.checker);\n                        $('body').trigger('processStart');\n                        //Check for window closed\n                        window.location.href = url.grid;\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                    }\n                } catch (e) {\n                    //squash. In case Window closed without success callback, clear polling\n                    if (IdentityLogin.win.closed) {\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                        clearInterval(IdentityLogin.checker);\n                    }\n\n                    return;\n                }\n            }\n        },\n\n        /**\n         * @param {Object} popupWindow\n         * @return {Boolean}\n         */\n        isPopupBlocked = function (popupWindow) {\n            try {\n                popupWindow.focus();\n            } catch (e) {\n                alert({\n                    content: $.mage.__('Popup Blocker is enabled! Please add this site to your exception list.')\n                });\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {*} dialog\n         * @param {*} title\n         * @param {*} okButton\n         * @param {*} ajaxUrl\n         * @private\n         */\n        _showPopup = function (dialog, title, okButton, ajaxUrl) {\n            $.ajax({\n                url: ajaxUrl,\n                cache: false,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                method: 'GET',\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    // Show the spinner\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (result) {\n                    var redirect = result._redirect,\n                        identityLinkUrl, consumerKey, popupHtml, popup, resultObj, buttons, dialogProperties;\n\n                    if (redirect) {\n                        window.location.href = redirect;\n\n                        return;\n                    }\n\n                    identityLinkUrl = null;\n                    consumerKey = null;\n                    popupHtml = null;\n                    popup = $('#integration-popup-container');\n\n                    try {\n                        resultObj = typeof result === 'string' ?\n                            JSON.parse(result) :\n                            result;\n\n                        identityLinkUrl = resultObj['identity_link_url'];\n                        consumerKey      = resultObj['oauth_consumer_key'];\n                        popupHtml       = resultObj['popup_content'];\n\n                    } catch (e) {\n                        //This is expected if result is not json. Do nothing.\n                    }\n\n                    if (identityLinkUrl && consumerKey && popupHtml) {\n                        IdentityLogin.invokePopup(identityLinkUrl, consumerKey, popup);\n\n                        if (isPopupBlocked(IdentityLogin.win)) {\n                            return;\n                        }\n                    } else {\n                        popupHtml = result;\n                    }\n\n                    if (popup.length === 0) {\n                        popup = $('<div></div>');\n                    }\n                    popup.html(popupHtml);\n\n                    buttons = [];\n                    dialogProperties = {\n                        title: title,\n                        type: 'slide',\n                        dialogClass: dialog == 'permissions' ? 'integration-dialog' : 'integration-dialog no-close' //eslint-disable-line\n                    };\n\n                    // Add confirmation button to the list of dialog buttons. okButton not set for tokenExchange dialog\n                    if (okButton) {\n                        buttons.push(okButton);\n                    }\n                    // Add button only if its not empty\n                    if (buttons.length > 0) {\n                        dialogProperties.buttons = buttons;\n                    }\n                    popup.modal(dialogProperties);\n                    popup.modal('openModal');\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    // Hide the spinner\n                    $('body').trigger('processStop');\n                }\n            });\n        };\n\n        return {\n            popup: {\n                /**\n                 * @param {*} ctx\n                 */\n                show: function (ctx) {\n                    var dialog = $(ctx).attr('data-row-dialog'),\n                        isReauthorize = $(ctx).attr('data-row-is-reauthorize'),\n                        isTokenExchange = $(ctx).attr('data-row-is-token-exchange'),\n                        integrationId, ajaxUrl, integrationName, okButton;\n\n                    if (!url.hasOwnProperty(dialog)) {\n                        throw 'Invalid dialog type';\n                    }\n\n                    integrationId = $(ctx).attr('data-row-id');\n\n                    if (!integrationId) {\n                        throw 'Unable to find integration ID';\n                    }\n\n                    // Replace placeholders in URL\n                    ajaxUrl = url[dialog].replace(':id', integrationId).replace(':isReauthorize', isReauthorize);\n\n                    try {\n                        // Get integration name either from current element or from neighbor column\n                        integrationName = $(ctx).attr('data-row-name') ||\n                            $(ctx).parents('tr').find('.col-name').html().trim(); // eslint-disable-line jquery-no-trim\n\n                        if (integrationName.indexOf('<span') > -1) {\n                            // Remove unsecure URL warning from popup window title if it is present\n                            integrationName = integrationName.substring(0, integrationName.indexOf('<span'));\n                        }\n                    } catch (e) {\n                        throw 'Unable to find integration name';\n                    }\n\n                    okButton = {\n                        permissions: {\n                            text: isReauthorize == '1' ? $.mage.__('Reauthorize') : $.mage.__('Allow'), //eslint-disable-line\n                            'class': 'action-primary',\n                            attr: {\n                                'data-row-id': integrationId,\n                                'data-row-name': integrationName,\n                                'data-row-dialog': isTokenExchange == '1' ? 'tokensExchange' : 'tokens', //eslint-disable-line\n                                'data-row-is-reauthorize': isReauthorize,\n                                'data-row-is-token-exchange': isTokenExchange\n                            },\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Find the 'Allow' button and clone - it has all necessary data, but is going to be\n                                // destroyed along with the current dialog\n                                var context = this.modal.find('button.action-primary').clone(true);\n\n                                this.closeModal();\n                                this.modal.remove();\n                                // Make popup out of data we saved from 'Allow' button\n                                window.integration.popup.show(context);\n                            }\n                        },\n                        tokens: {\n                            text: $.mage.__('Done'),\n                            'class': 'action-primary',\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Integration has been activated at the point of generating tokens\n                                window.location.href = url.grid;\n                            }\n                        }\n                    };\n\n                    _showPopup(dialog, integrationName, okButton[dialog], ajaxUrl);\n                }\n            }\n        };\n    };\n\n    return $.mage.integration;\n});\n","Magento_ConfigurableProduct/js/configurable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'collapsible',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'domReady!'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        $block: null,\n        hasVariations: null,\n        configurationSectionMessageHandler: (function () {\n            var title = $('[data-role=\"product-create-configuration-info\"]'),\n                buttons = $('[data-action=\"product-create-configuration-buttons\"]'),\n                newText = 'Configurations cannot be created for a standard product with downloadable files.' +\n                ' To create configurations, first remove all downloadable files.',\n                oldText = title.text();\n\n            return function (change) {\n                if (change) {\n                    title.text(newText);\n                    buttons.hide();\n                } else {\n                    title.text(oldText);\n                    buttons.show();\n                }\n            };\n        }()),\n\n        /**\n         * Set element disabled\n         * @param {Object} $element - jquery instance element\n         * @param {Bool} state\n         * @param {Bool} triggerEvent\n         * @private\n         */\n        _setElementDisabled: function ($element, state, triggerEvent) {\n            if (!$element.is('[data-locked]')) {\n                $element.prop('disabled', state);\n\n                if (triggerEvent) {\n                    $element.trigger('change');\n                }\n            }\n        },\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.configurationSectionMessageHandler(false);\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.configurationSectionMessageHandler(true);\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('changeConfigurableTypeProduct', function (event, isConfigurable) {\n                $(document).trigger('setTypeProduct', isConfigurable ?\n                    'configurable' :\n                    productType.type.init === 'configurable' ? 'simple' : productType.type.init\n                );\n            });\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n\n            /*var suggestContainer = $('#product-template-suggest-container .action-dropdown > .action-toggle');\n\n\n            if (productType.type.current === 'configurable') {\n                this._setElementDisabled(suggestContainer.addClass('disabled'), true);\n                this._setElementDisabled($('#inventory_qty'), true);\n                this._setElementDisabled($('#inventory_stock_availability'), false);\n                this._setElementDisabled($('#qty'), true, true);\n                this._setElementDisabled($('#quantity_and_stock_status'), false, false);\n            } else {\n                this._setElementDisabled(suggestContainer.removeClass('disabled'), false);\n                this._setElementDisabled($('#inventory_qty'), false);\n                this._setElementDisabled($('#inventory_stock_availability'), true);\n                this._setElementDisabled($('#qty'), false, true);\n            }\n            */\n\n            /*if (['simple', 'virtual', 'configurable'].indexOf(productType.type.current) < 0) {\n                this.hide();\n            } else {\n                this.show();\n            }*/\n\n            this.show();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_ConfigurableProduct/js/configurable-type-handler': function (data) {\n            this.$block = $(data.blockId + ' input[name=\"attributes[]\"]');\n            this.hasVariations = data.hasVariations;\n\n            //advancedPricingHandler.init();\n            //priceTypeHandler.init();\n\n            /*if (productType.type.init === 'configurable' && !this.hasVariations) {\n                $(document).trigger('setTypeProduct', 'simple');\n            }*/\n            $(document).trigger('setTypeProduct', 'simple');\n\n            this.bindAll();\n            this._initType();\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**************************** CONFIGURABLE PRODUCT **************************/\n/* global Product, optionsPrice */\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/translate',\n    'prototype'\n], function (jQuery, mageTemplate) {\n    'use strict';\n\n    if (typeof Product == 'undefined') {\n        window.Product = {};\n    }\n\n    Product.Config = Class.create();\n    Product.Config.prototype = {\n        /**\n         * Initialize function.\n         *\n         * @param {Object} config\n         */\n        initialize: function (config) {\n            var separatorIndex, paramsStr, urlValues, i, childSettings, prevSetting, nextSetting;\n\n            // Magic preprocessing\n            // TODO MAGETWO-31539\n            config.taxConfig = {\n                showBothPrices: false,\n                inclTaxTitle: jQuery.mage.__('Incl. Tax')\n            };\n\n            this.config     = config;\n            this.taxConfig  = this.config.taxConfig;\n\n            if (config.containerId) {\n                this.settings   = $$('#' + config.containerId + ' ' + '.super-attribute-select');\n            } else {\n                this.settings   = $$('.super-attribute-select');\n            }\n            this.state      = new Hash();\n            this.priceTemplate = mageTemplate(this.config.template);\n            this.prices     = config.prices;\n            this.values     = {};\n\n            // Set default values from config\n            if (config.defaultValues) {\n                this.values = config.defaultValues;\n            }\n\n            // Overwrite defaults by url\n            separatorIndex = window.location.href.indexOf('#');\n\n            if (separatorIndex != -1) { //eslint-disable-line eqeqeq\n                paramsStr = window.location.href.substr(separatorIndex + 1);\n                urlValues = paramsStr.toQueryParams();\n\n                for (i in urlValues) { //eslint-disable-line guard-for-in\n                    this.values[i] = urlValues[i];\n                }\n            }\n\n            // Overwrite defaults by inputs values if needed\n            if (config.inputsInitialized) {\n                this.values = {};\n                this.settings.each(function (element) {\n                    var attributeId;\n\n                    if (element.value) {\n                        attributeId = element.id.replace(/[a-z]*/, '');\n                        this.values[attributeId] = element.value;\n                    }\n                }.bind(this));\n            }\n\n            // Put events to check select reloads\n            this.settings.each(function (element) {\n                Event.observe(element, 'change', this.configure.bind(this));\n            }.bind(this));\n\n            // fill state\n            this.settings.each(function (element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.config.attributes[attributeId]) {\n                    element.config = this.config.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.state[attributeId] = false;\n                }\n            }.bind(this));\n\n            // Init settings dropdown\n            childSettings = [];\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                prevSetting = this.settings[i - 1] ? this.settings[i - 1] : false;\n                nextSetting = this.settings[i + 1] ? this.settings[i + 1] : false;\n\n                if (i === 0) {\n                    this.fillSelect(this.settings[i]);\n                } else {\n                    this.settings[i].disabled = true;\n                }\n                $(this.settings[i]).childSettings = childSettings.clone();\n                $(this.settings[i]).prevSetting   = prevSetting;\n                $(this.settings[i]).nextSetting   = nextSetting;\n                childSettings.push(this.settings[i]);\n            }\n\n            // Set values to inputs\n            this.configureForValues();\n            document.observe('dom:loaded', this.configureForValues.bind(this));\n        },\n\n        /**\n         * Configure for values.\n         */\n        configureForValues: function () {\n            if (this.values) {\n                this.settings.each(function (element) {\n                    var attributeId = element.attributeId;\n\n                    element.value = typeof this.values[attributeId] === 'undefined' ? '' : this.values[attributeId];\n                    this.configureElement(element);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Object} event\n         */\n        configure: function (event) {\n            var element = Event.element(event);\n\n            this.configureElement(element);\n        },\n\n        /**\n         * @param {Object} element\n         */\n        configureElement: function (element) {\n            this.reloadOptionLabels(element);\n\n            if (element.value) {\n                this.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this.fillSelect(element.nextSetting);\n                    this.resetChildren(element.nextSetting);\n                }\n            } else {\n                this.resetChildren(element);\n            }\n            this.reloadPrice();\n        },\n\n        /**\n         * @param {Object} element\n         */\n        reloadOptionLabels: function (element) {\n            var selectedPrice = 0,\n                option, i;\n\n            if (element.options[element.selectedIndex] && element.options[element.selectedIndex].config) {\n                option = element.options[element.selectedIndex].config;\n                selectedPrice = parseFloat(this.config.optionPrices[option.allowedProducts[0]].finalPrice.amount);\n            }\n            element.setAttribute('price', selectedPrice);\n\n            for (i = 0; i < element.options.length; i++) {\n                if (element.options[i].config) {\n                    element.options[i].setAttribute('price', selectedPrice);\n                    element.options[i].setAttribute('summarizePrice', 0);\n                    element.options[i].text = this.getOptionLabel(element.options[i].config, selectedPrice);\n                }\n            }\n        },\n\n        /* eslint-disable max-depth */\n        /**\n         * @param {Object} element\n         */\n        resetChildren: function (element) {\n            var i;\n\n            if (element.childSettings) {\n                for (i = 0; i < element.childSettings.length; i++) {\n                    element.childSettings[i].selectedIndex = 0;\n                    element.childSettings[i].disabled = true;\n\n                    if (element.config) {\n                        this.state[element.config.id] = false;\n                    }\n                }\n            }\n        },\n\n        /**\n         * @param {Object} element\n         */\n        fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this.getAttributeOptions(attributeId),\n                prevConfig = false,\n                index = 1,\n                i, j, allowedProducts;\n\n            this.clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.config.chooseText;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (i = 0; i < options.length; i++) {\n                    allowedProducts = [];\n\n                    if (prevConfig) {\n                        for (j = 0; j < options[i].products.length; j++) {\n                            if (prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1\n                            ) {\n                                allowedProducts.push(options[i].products[j]);\n                            }\n                        }\n                    } else {\n                        allowedProducts = options[i].products.clone();\n                    }\n\n                    if (allowedProducts.size() > 0) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this.getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price != 'undefined') {\n                            element.options[index].setAttribute('price', options[i].price);\n                        }\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n                }\n            }\n        },\n\n        //eslint-enable max-depth\n        /**\n         * @param {Object} option\n         */\n        getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * @param {*} price\n         * @param {Boolean} showSign\n         * @return {String}\n         */\n        formatPrice: function (price, showSign) {\n            var str = '',\n                roundedPrice;\n\n            price = parseFloat(price);\n\n            if (showSign) {\n                if (price < 0) {\n                    str += '-';\n                    price = -price;\n                } else {\n                    str += '+';\n                }\n            }\n\n            roundedPrice = Number(Math.round(price + 'e+2') + 'e-2').toString();\n\n            if (this.prices && this.prices[roundedPrice]) {\n                str += this.prices[roundedPrice];\n            } else {\n                str += this.priceTemplate({\n                    data: {\n                        price: price.toFixed(2)\n                    }\n                });\n            }\n\n            return str;\n        },\n\n        /**\n         * @param {Object} element\n         */\n        clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * @param {*} attributeId\n         * @return {*|undefined}\n         */\n        getAttributeOptions: function (attributeId) {\n            if (this.config.attributes[attributeId]) {\n                return this.config.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload price.\n         *\n         * @return {undefined|Number}\n         */\n        reloadPrice: function () {\n            var price = 0,\n                oldPrice = 0,\n                inclTaxPrice = 0,\n                exclTaxPrice = 0,\n                i, selected;\n\n            if (this.config.disablePriceReload) {\n                return undefined;\n            }\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                if (selected.config) {\n                    price += parseFloat(selected.config.price);\n                    oldPrice += parseFloat(selected.config.oldPrice);\n                    inclTaxPrice += parseFloat(selected.config.inclTaxPrice);\n                    exclTaxPrice += parseFloat(selected.config.exclTaxPrice);\n                }\n            }\n\n            optionsPrice.changePrice(\n                'config', {\n                    'price': price,\n                    'oldPrice': oldPrice,\n                    'inclTaxPrice': inclTaxPrice,\n                    'exclTaxPrice': exclTaxPrice\n                }\n            );\n            optionsPrice.reload();\n\n            return price;\n        },\n\n        /**\n         * Reload old price.\n         */\n        reloadOldPrice: function () {\n            var price, i, selected;\n\n            if (this.config.disablePriceReload) {\n                return;\n            }\n\n            if ($('old-price-' + this.config.productId)) {\n\n                price = parseFloat(this.config.oldPrice);\n\n                for (i = this.settings.length - 1; i >= 0; i--) {\n                    selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                    if (selected.config) {\n                        price += parseFloat(selected.config.price);\n                    }\n                }\n\n                if (price < 0) {\n                    price = 0;\n                }\n                price = this.formatPrice(price);\n\n                if ($('old-price-' + this.config.productId)) {\n                    $('old-price-' + this.config.productId).innerHTML = price;\n                }\n\n            }\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/options/price-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'notification',\n    'mage/translate'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        isConfigurable: false,\n        messageInited: false,\n        messageSelector: '[data-role=product-custom-options-content]',\n        isPercentPriceTypeExist: function () {\n            var productOptionsContainer = $('#product_options_container_top');\n\n            return !!productOptionsContainer.length;\n        },\n        showWarning: function () {\n            if (!this.messageInited) {\n                $(this.messageSelector).notification();\n                this.messageInited = true;\n            }\n            this.hideWarning();\n            $(this.messageSelector).notification('add', {\n                message: $.mage.__('Custom options with price type \"percent\" is not available for ' +\n                    'configurable product.'),\n                error: false,\n                messageContainer: this.messageSelector\n            });\n        },\n        hideWarning: function () {\n            $(this.messageSelector).notification('clear');\n        },\n        init: function () {\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n\n            $('#product-edit-form-tabs').on('change', '.opt-type > select', function () {\n                var selected = $('.opt-type > select :selected'),\n                    optGroup = selected.parent().attr('label');\n\n                if (optGroup === 'Select') {\n                    $('#product-edit-form-tabs').on(\n                        'click',\n                        '[data-ui-id=\"admin-product-options-options-box-select-option-type-add-select-row-button\"]',\n                        function () {\n                            this.percentPriceTypeHandler();\n                        }.bind(this)\n                    );\n                } else {\n                    this.percentPriceTypeHandler();\n                }\n            }.bind(this));\n\n            this._initType();\n        },\n        _initType: function () {\n            this.isConfigurable = productType.type.current === 'configurable';\n            if (this.isPercentPriceTypeExist()) {\n                this.percentPriceTypeHandler();\n            }\n        },\n        percentPriceTypeHandler: function () {\n            var priceType = $('[data-attr=\"price-type\"]'),\n                optionPercentPriceType = priceType.find('option[value=\"percent\"]');\n\n            if (this.isConfigurable) {\n                this.showWarning();\n                optionPercentPriceType.hide();\n                optionPercentPriceType.parent().val() === 'percent' ? optionPercentPriceType.parent().val('fixed') : '';\n            } else {\n                $(this.messageSelector).notification();\n                optionPercentPriceType.show();\n                this.hideWarning();\n            }\n        }\n    };\n});\n*/\n","Magento_ConfigurableProduct/js/variations/variations.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'uiRegistry',\n    'mage/translate'\n], function (Component, $, ko, _, alert, registry, $t) {\n    'use strict';\n\n    /**\n     * @param {*} message\n     * @constructor\n     */\n    function UserException(message) {\n        this.message = message;\n        this.name = 'UserException';\n    }\n    UserException.prototype = Object.create(Error.prototype);\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            attributes: [],\n            usedAttributes: [],\n            attributeCodes: [],\n            attributesData: {},\n            productMatrix: [],\n            variations: [],\n            formSaveParams: [],\n            productAttributes: [],\n            disabledAttributes: [],\n            fullAttributes: [],\n            rowIndexToEdit: false,\n            productAttributesMap: null,\n            value: [],\n            modules: {\n                associatedProductGrid: '${ $.configurableProductGrid }',\n                wizardButtonElement: '${ $.wizardModalButtonName }',\n                formElement: '${ $.formName }',\n                attributeSetHandlerModal: '${ $.attributeSetHandler }'\n            },\n            imports: {\n                attributeSetName: '${ $.provider }:configurableNewAttributeSetName',\n                attributeSetId: '${ $.provider }:configurableExistingAttributeSetId',\n                attributeSetSelection: '${ $.provider }:configurableAffectedAttributeSet',\n                productPrice: '${ $.provider }:data.product.price'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScopeVariations }',\n                usedAttributes: '${ $.provider }:${ $.dataScopeAttributes }',\n                attributesData: '${ $.provider }:${ $.dataScopeAttributesData }',\n                attributeCodes: '${ $.provider }:${ $.dataScopeAttributeCodes }',\n                skeletonAttributeSet: '${ $.provider }:data.new-variations-attribute-set-id'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.changeButtonWizard();\n            this.initProductAttributesMap();\n            this.disableConfigurableAttributes(this.productAttributes);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(\n                'actions opened attributes productMatrix value usedAttributes attributesData attributeCodes'\n            );\n\n            return this;\n        },\n\n        /**\n         * @param {Object} product\n         * @return {Object}\n         * @private\n         */\n        _makeProduct: function (product) {\n            var productId = product['entity_id'] || product.productId || null,\n                attributes = _.pick(product, this.attributes.pluck('code')),\n                options = _.map(attributes, function (option, attribute) {\n                    var oldOptions = _.findWhere(this.attributes(), {\n                            code: attribute\n                        }).options,\n                        result;\n\n                    if (_.isFunction(oldOptions)) {\n                        result = oldOptions.findWhere({\n                            value: option\n                        });\n                    } else {\n                        result = _.findWhere(oldOptions, {\n                            value: option\n                        });\n                    }\n\n                    return result;\n                }.bind(this));\n\n            return {\n                attribute: JSON.stringify(attributes),\n                editable: false,\n                images: {\n                    preview: product['thumbnail_src']\n                },\n                name: product.name || product.sku,\n                options: options,\n                price: parseFloat(Math.round(product.price.replace(/[^\\d.]+/g, '') + 'e+4') + 'e-4').toFixed(4),\n                productId: productId,\n                productUrl: this.buildProductUrl(productId),\n                quantity: product.quantity || null,\n                sku: product.sku,\n                status: product.status === undefined ? 1 : parseInt(product.status, 10),\n                variationKey: this.getVariationKey(options),\n                weight: product.weight || null\n            };\n        },\n\n        /**\n         * @param {String} name\n         * @return {String|Number|Array}\n         */\n        getProductValue: function (name) {\n            var value;\n\n            name = name.split('/').join('][');\n            value = $('[name=\"product[' + name + ']\"]:enabled:not(.ignore-validate)', this.productForm).val();\n            if (value === undefined) {\n                value = this.source.get('data.product.' + name);\n            }\n            return value;\n        },\n\n        /**\n         * @param {Object} data\n         * @param {String} field\n         * @return {String}\n         */\n        getRowId: function (data, field) {\n            var key = data.variationKey;\n\n            return 'variations-matrix-' + key + '-' + field;\n        },\n\n        /**\n         * @param {Object} variation\n         * @param {String} field\n         * @return {String}\n         */\n        getVariationRowName: function (variation, field) {\n            var result;\n\n            if (variation.productId) {\n                result = 'configurations[' + variation.productId + '][' + field.split('/').join('][') + ']';\n            } else {\n                result = 'variations-matrix[' + variation.variationKey + '][' + field.split('/').join('][') + ']';\n            }\n\n            return result;\n        },\n\n        /**\n         * @param {*} variations\n         * @param {*} attributes\n         */\n        render: function (variations, attributes) {\n            this.changeButtonWizard();\n            this.populateVariationMatrix(variations);\n            this.attributes(attributes);\n            this.disableConfigurableAttributes(attributes);\n            this.handleValue(variations);\n            this.handleAttributes();\n        },\n\n        /**\n         * Change button wizard.\n         */\n        changeButtonWizard: function () {\n            if (this.variations.length) {\n                this.wizardButtonElement().title(this.wizardModalButtonTitle);\n            }\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        handleValue: function (variations) {\n            var tmpArray = [];\n\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {}),\n                    gallery = {\n                        images: {}\n                    },\n                    types = {};\n\n                _.each(variation.images.images, function (image) {\n                    gallery.images[image['file_id']] = {\n                        position: image.position,\n                        file: image.file,\n                        disabled: image.disabled,\n                        label: image.label || ''\n                    };\n                    _.each(image.galleryTypes, function (type) {\n                        types[type] = image.file;\n                    });\n                }, this);\n\n                tmpArray.push(_.extend(variation, types, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    priceCurrency: this.currencySymbol,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? 0 : 1,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10),\n                    newProduct: variation.productId ? 0 : 1,\n                    'media_gallery': gallery\n                }));\n            }, this);\n\n            this.value(tmpArray);\n        },\n\n        /**\n         * Handle attributes.\n         */\n        handleAttributes: function () {\n            var tmpArray = [],\n                codesArray = [],\n                tmpOptions = {},\n                option = {},\n                position = 0,\n                values = {};\n\n            _.each(this.attributes(), function (attribute) {\n                tmpArray.push(attribute.id);\n                codesArray.push(attribute.code);\n                values = {};\n                _.each(attribute.chosen, function (row) {\n                    values[row.value] = {\n                        'include': '1',\n                        'value_index': row.value\n                    };\n                }, this);\n                option = {\n                    'attribute_id': attribute.id,\n                    'code': attribute.code,\n                    'label': attribute.label,\n                    'position': position,\n                    'values': values\n                };\n                tmpOptions[attribute.id] = option;\n                position++;\n            }, this);\n\n            this.attributesData(tmpOptions);\n            this.usedAttributes(tmpArray);\n            this.attributeCodes(codesArray);\n        },\n\n        /**\n         * Get attributes options\n         * @see use in matrix.phtml\n         *\n         * @returns {Array}\n         */\n        getAttributesOptions: function () {\n            return this.showVariations() ? this.productMatrix()[0].options : [];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        showVariations: function () {\n            return this.productMatrix().length > 0;\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        populateVariationMatrix: function (variations) {\n            this.productMatrix([]);\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {});\n\n                this.productMatrix.push(_.extend(variation, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? !variation.productId : variation.editable,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10)\n                }));\n            }, this);\n        },\n\n        /**\n         * @param {*} productId\n         */\n        buildProductUrl: function (productId) {\n            return this.productUrl.replace('%id%', productId);\n        },\n\n        /**\n         * @param {Object} options\n         * @return {String}\n         */\n        getVariationKey: function (options) {\n            return _.pluck(options, 'value').sort().join('-');\n        },\n\n        /**\n         * @param {*} options\n         * @return {*|null}\n         */\n        getProductIdByOptions: function (options) {\n            return this.productAttributesMap[this.getVariationKey(options)] || null;\n        },\n\n        /**\n         * Init product attributes map\n         */\n        initProductAttributesMap: function () {\n            if (this.productAttributesMap === null) {\n                this.productAttributesMap = {};\n                _.each(this.variations, function (product) {\n                    this.productAttributesMap[this.getVariationKey(product.options)] = product.productId;\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Array} attributes\n         */\n        disableConfigurableAttributes: function (attributes) {\n            var element;\n\n            _.each(this.disabledAttributes, function (attribute) {\n                registry.get('inputName = ' + 'product[' + attribute + ']').disabled(false);\n            });\n            this.disabledAttributes = [];\n\n            _.each(attributes, function (attribute) {\n                element = registry.get('inputName = ' + 'product[' + attribute.code + ']');\n\n                if (!_.isUndefined(element)) {\n                    element.disabled(true);\n                    this.disabledAttributes.push(attribute.code);\n                }\n            }, this);\n        },\n\n        /**\n         * Get currency symbol\n         * @returns {String}\n         */\n        getCurrencySymbol: function () {\n            return this.currencySymbol;\n        },\n\n        /**\n         * Chose action for the form save button\n         */\n        saveFormHandler: function () {\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                this.serializeData();\n            }\n\n            if (this.checkForNewAttributes()) {\n                this.formSaveParams = arguments;\n                this.attributeSetHandlerModal().openModal();\n            } else {\n                if (this.validateForm(this.formElement())) {\n                    this.clearOutdatedData();\n                }\n                this.formElement().save(arguments[0], arguments[1]);\n\n                if (this.formElement().source.get('params.invalid')) {\n                    this.unserializeData();\n                }\n            }\n        },\n\n        /**\n         * @param {Object} formElement\n         *\n         * Validates each form element and returns true, if all elements are valid.\n         */\n        validateForm: function (formElement) {\n            formElement.validate();\n\n            return !formElement.additionalInvalid && !formElement.source.get('params.invalid');\n        },\n\n        /**\n         * Serialize data for specific form fields\n         *\n         * Serializes some complex data fields\n         *\n         * Original fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         *\n         * Serialized fields in request:\n         *   - configurable-matrix-serialized;\n         *   - associated_product_ids_serialized.\n         */\n        serializeData: function () {\n            if (this.source.data['configurable-matrix']) {\n                this.source.data['configurable-matrix-serialized'] =\n                    JSON.stringify(this.source.data['configurable-matrix']);\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                this.source.data['associated_product_ids_serialized'] =\n                    JSON.stringify(this.source.data['associated_product_ids']);\n            }\n        },\n\n        /**\n         * Clear outdated data for specific form fields\n         *\n         * Outdated fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         */\n        clearOutdatedData: function () {\n            if (this.source.data['configurable-matrix']) {\n                delete this.source.data['configurable-matrix'];\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                delete this.source.data['associated_product_ids'];\n            }\n        },\n\n        /**\n         * Unserialize data for specific form fields\n         *\n         * Unserializes some fields that were serialized this.serializeData\n         */\n        unserializeData: function () {\n            if (this.source.data['configurable-matrix-serialized']) {\n                this.source.data['configurable-matrix'] =\n                    JSON.parse(this.source.data['configurable-matrix-serialized']);\n                delete this.source.data['configurable-matrix-serialized'];\n            }\n\n            if (this.source.data['associated_product_ids_serialized']) {\n                this.source.data['associated_product_ids'] =\n                    JSON.parse(this.source.data['associated_product_ids_serialized']);\n                delete this.source.data['associated_product_ids_serialized'];\n            }\n        },\n\n        /**\n         * Check for newly added attributes\n         * @returns {Boolean}\n         */\n        checkForNewAttributes: function () {\n            var element, newAttributes = false;\n\n            _.each(this.source.get('data.attribute_codes'), function (attribute) {\n                element = registry.get('index = ' + attribute);\n\n                if (_.isUndefined(element)) {\n                    newAttributes = true;\n                }\n            }, this);\n\n            return newAttributes;\n        },\n\n        /**\n         * New attributes handler\n         * @returns {Boolean}\n         */\n        addNewAttributeSetHandler: function () {\n            var chosenAttributeSetOption;\n\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                chosenAttributeSetOption = this.attributeSetSelection;\n\n                if (chosenAttributeSetOption === 'new') {\n                    this.createNewAttributeSet();\n\n                    return false;\n                }\n\n                if (chosenAttributeSetOption === 'existing') {\n                    this.set(\n                        'skeletonAttributeSet',\n                        this.attributeSetId\n                    );\n                }\n\n                this.closeDialogAndProcessForm();\n\n                return true;\n            }\n\n            this.unserializeData();\n\n            return false;\n        },\n\n        /**\n         * Handles new attribute set creation\n         * @returns {Boolean}\n         */\n        createNewAttributeSet: function () {\n            var messageBoxElement = registry.get('index = affectedAttributeSetError');\n\n            messageBoxElement.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.attributeSetCreationUrl,\n                data: {\n                    gotoEdit: 1,\n                    'attribute_set_name': this.attributeSetName,\n                    'skeleton_set': this.skeletonAttributeSet,\n                    'return_session_messages_only': 1\n                },\n                dataType: 'json',\n                showLoader: true,\n                context: this\n            }).done(function (data) {\n                if (!data.error) {\n                    this.set(\n                        'skeletonAttributeSet',\n                        data.id\n                    );\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                    this.closeDialogAndProcessForm();\n                } else {\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                }\n\n                return false;\n            }).fail(function (xhr) {\n                if (xhr.statusText === 'abort') {\n                    return;\n                }\n\n                alert({\n                    content: $t('Something went wrong.')\n                });\n            });\n\n            return false;\n        },\n\n        /**\n         * Closes attribute set handler modal and process product form\n         */\n        closeDialogAndProcessForm: function () {\n            this.attributeSetHandlerModal().closeModal();\n            this.formElement().save(this.formSaveParams[0], this.formSaveParams[1]);\n        },\n\n        /**\n         * Retrieves product price\n         * @returns {*}\n         */\n        getProductPrice: function () {\n            return this.productPrice;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/product-grid.js":"// jscs:disable requireDotNotation\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'underscore',\n    'notification',\n    'mage/translate'\n], function (Component, $, bootstrap, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            productsGridUrl: null,\n            productAttributes: [],\n            productsModal: null,\n            button: '',\n            gridSelector: '[data-grid-id=associated-products-container]',\n            modules: {\n                productsFilter: '${ $.productsFilter }',\n                productsProvider: '${ $.productsProvider }',\n                productsMassAction: '${ $.productsMassAction }',\n                productsColumns: '${ $.productsColumns }',\n                variationsComponent: '${ $.configurableVariations }'\n            },\n            listens: {\n                '${ $.productsProvider }:data': '_showMessageAssociatedGrid _handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect',\n                '${ $.configurableVariations }:productMatrix': '_showButtonAddManual _switchProductType'\n            }\n        },\n\n        /**\n         * Initialize\n         *\n         * @param {Array} options\n         */\n        initialize: function (options) {\n            this._super(options);\n            this.productsModal = $(this.gridSelector).modal({\n                title: $.mage.__('Select Associated Product'),\n                type: 'slide',\n                buttons: [\n                    {\n                        text: $.mage.__('Cancel'),\n\n                        /** Close modal */\n                        click: function () {\n                            this.closeModal();\n                        }\n                    }, {\n                        text: $.mage.__('Done'),\n                        click: this.close.bind(this, null)\n                    }\n                ]\n            });\n\n            this.productsProvider(function () {\n                this.productsModal.notification();\n            }.bind(this));\n            this.variationsComponent(function (variation) {\n                this._showButtonAddManual(variation.productMatrix());\n            }.bind(this));\n\n            this._initGrid = _.once(this._initGrid);\n            this._switchProductType = _.wrap(this._switchProductType.bind(this), function (func, params) {\n                if (!!params.length !== !!this.init) {\n                    this.init = !!params.length;\n                    func(params);\n                }\n            }.bind(this._switchProductType));\n        },\n\n        /**\n         * Initial observerable\n         * @returns {*}\n         */\n        initObservable: function () {\n            this._super().observe('button');\n\n            return this;\n        },\n\n        /**\n         * init Grid\n         * @private\n         */\n        _initGrid: function (filterData) {\n            $.ajax({\n                type: 'GET',\n                url: this._buildGridUrl(filterData),\n                context: $('body')\n            }).done(function (data) {\n                bootstrap(JSON.parse(data));\n            });\n        },\n\n        /**\n         * Select different product in configurations section\n         * @see configurable_associated_product_listing.xml\n         * @param {Integer} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.close(rowIndex);\n        },\n\n        /**\n         * Open\n         * @param {Object} filterData - filter data\n         * @param {Object|*} filterData.filters - attribute name\n         * @param {Object|*} filterData.filters_modifier - modifier value\n         * @param {String} callbackName\n         * @param {Boolean} showMassActionColumn\n         */\n        open: function (filterData, callbackName, showMassActionColumn) {\n            this.callbackName = callbackName;\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = showMassActionColumn;\n                });\n                massActionComponent.visible = showMassActionColumn;\n            }.bind(this));\n            this._setFilter(filterData);\n            this._initGrid(filterData);\n            this.productsModal.trigger('openModal');\n        },\n\n        /**\n         * Close\n         */\n        close: function (rowIndex) {\n            try {\n                if (this.productsMassAction().selected.getLength()) {\n                    this.variationsComponent()[this.callbackName](this.productsMassAction()\n                        .selected.map(this.getProductById.bind(this)));\n                    this.productsMassAction().deselectAll();\n                } else if (!_.isNull(rowIndex)) {\n                    this.variationsComponent()[this.callbackName]([this.getProductByIndex(rowIndex)]);\n                }\n                this.productsModal.trigger('closeModal');\n            } catch (e) {\n                if (e.name === 'UserException') {\n                    this.productsModal.notification('clear');\n                    this.productsModal.notification('add', {\n                        message: e.message,\n                        messageContainer: this.gridSelector\n                    });\n                } else {\n                    throw e;\n                }\n            }\n        },\n\n        /**\n         * Get product by id\n         * @param {Integer} productId\n         * @returns {*}\n         */\n        getProductById: function (productId) {\n            return _.findWhere(this.productsProvider().data.items, {\n                'entity_id': productId\n            });\n        },\n\n        /**\n         * Get product\n         * @param {Integer} rowIndex\n         * @returns {*}\n         */\n        getProductByIndex: function (rowIndex) {\n            return this.productsProvider().data.items[rowIndex];\n        },\n\n        /**\n         * Build grid url\n         * @private\n         */\n        _buildGridUrl: function (filterData) {\n            var params = '?' + $.param({\n                'filters': filterData.filters,\n                'attributes_codes': this._getAttributesCodes(),\n                'filters_modifier': filterData['filters_modifier']\n            });\n\n            return this.productsGridUrl + params;\n        },\n\n        /**\n         * Show button add manual\n         * @param {Array} variations\n         * @returns {*}\n         * @private\n         */\n        _showButtonAddManual: function (variations) {\n            return this.button(variations.length);\n        },\n\n        /**\n         * @param {Array} variations\n         * @private\n         */\n        _switchProductType: function (variations) {\n            $(document).trigger('changeConfigurableTypeProduct', variations.length);\n        },\n\n        /**\n         * Get attributes codes used for configurable\n         * @private\n         */\n        _getAttributesCodes: function () {\n            return this.variationsComponent().attributes.pluck('code');\n        },\n\n        /**\n         * Show data associated grid\n         * @private\n         */\n        _showMessageAssociatedGrid: function (data) {\n            this.productsModal.notification('clear');\n\n            if (data.items.length) {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('Choose a new product to delete and replace the current product configuration.'),\n                    messageContainer: this.gridSelector\n                });\n            } else {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('For better results, add attributes and attribute values to your products.'),\n                    messageContainer: this.gridSelector\n                });\n            }\n        },\n\n        /**\n         * Show manually grid\n         */\n        showManuallyGrid: function () {\n            var filterModifier = _.mapObject(_.object(this._getAttributesCodes(), []), function () {\n                    return {\n                        'condition_type': 'notnull'\n                    };\n                }),\n                usedProductIds = _.values(this.variationsComponent().productAttributesMap);\n\n            if (usedProductIds && usedProductIds.length > 0) {\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n            }\n\n            this.open(\n                {\n                    'filters_modifier': filterModifier\n                },\n                'appendProducts',\n                true\n            );\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                        selectedVariationKeys,\n                        _.pluck(this.variationsComponent().productMatrix(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows, selectedVariationKeys;\n\n            if (this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Object} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            this._variationKeyMap = {};\n\n            _.each(items, function (row) {\n                this._variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return this._variationKeyMap;\n        },\n\n        /**\n         * Set filter\n         * @private\n         */\n        _setFilter: function (filterData) {\n            this.productsProvider(function (provider) {\n                provider.params['filters_modifier'] = filterData['filters_modifier'];\n                provider.params['attributes_codes'] = this._getAttributesCodes();\n            }.bind(this));\n\n            this.productsFilter(function (filter) {\n                filter.set('filters', _.extend({\n                    'filters_modifier': filterData['filters_modifier']\n                }, filterData.filters))\n                    .apply();\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes'\n], function (Sizes) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            options: {\n                '20': {\n                    value: 20,\n                    label: 20\n                },\n                '30': {\n                    value: 30,\n                    label: 30\n                },\n                '50': {\n                    value: 50,\n                    label: 50\n                }\n            },\n            value: 20\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/select_attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'mage/translate'\n], function (Component, $, _) {\n    'use strict';\n\n    /**\n     * @param {Function} provider\n     */\n    var initNewAttributeListener = function (provider) {\n        $('[data-role=product-variations-matrix]').on('add', function () {\n            provider().reload();\n        });\n    };\n\n    return Component.extend({\n        attributesLabels: {},\n        stepInitialized: false,\n        defaults: {\n            modules: {\n                multiselect: '${ $.multiselectName }',\n                attributeProvider: '${ $.providerName }'\n            },\n            listens: {\n                '${ $.multiselectName }:selected': 'doSelectedAttributesLabels',\n                '${ $.multiselectName }:rows': 'doSelectSavedAttributes'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            selectedAttributes: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selected = [];\n\n            initNewAttributeListener(this.attributeProvider);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['selectedAttributes']);\n\n            return this;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Set notification message.\n         */\n        setNotificationMessage: function () {\n            /*eslint-disable max-len*/\n            var msg = $.mage.__('When you remove or add an attribute, we automatically update all configurations and you will need to recreate current configurations manually.');\n\n            /*eslint-enable max-len*/\n\n            if (this.mode === 'edit') {\n                this.wizard.setNotificationMessage(msg);\n            }\n        },\n\n        /**\n         * Do select saved attributes.\n         */\n        doSelectSavedAttributes: function () {\n            if (this.stepInitialized === false) {\n                this.stepInitialized = true;\n                //cache attributes labels, which can be present on the 2nd page\n                _.each(this.initData.attributes, function (attribute) {\n                    this.attributesLabels[attribute.id] = attribute.label;\n                }.bind(this));\n                this.multiselect().selected(_.pluck(this.initData.attributes, 'id'));\n            }\n        },\n\n        /**\n         * @param {*} selected\n         */\n        doSelectedAttributesLabels: function (selected) {\n            var labels = [];\n\n            this.selected = selected;\n            _.each(selected, function (attributeId) {\n                var attribute;\n\n                if (!this.attributesLabels[attributeId]) {\n                    attribute = _.findWhere(this.multiselect().rows(), {\n                        'attribute_id': attributeId\n                    });\n\n                    if (attribute) {\n                        this.attributesLabels[attribute['attribute_id']] = attribute['frontend_label'];\n                    }\n                }\n                labels.push(this.attributesLabels[attributeId]);\n            }.bind(this));\n            this.selectedAttributes(labels.join(', '));\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            wizard.data.attributesIds = this.multiselect().selected;\n\n            if (!wizard.data.attributesIds() || wizard.data.attributesIds().length === 0) {\n                throw new Error($.mage.__('Please select attribute(s).'));\n            }\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/attributes_values.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/translate'\n], function (Component, $, ko, _, utils, Collapsible) {\n    'use strict';\n\n    //connect items with observableArrays\n    ko.bindingHandlers.sortableList = {\n        /** @inheritdoc */\n        init: function (element, valueAccessor) {\n            var list = valueAccessor();\n\n            $(element).sortable({\n                axis: 'y',\n                handle: '[data-role=\"draggable\"]',\n                tolerance: 'pointer',\n\n                /** @inheritdoc */\n                update: function (event, ui) {\n                    var item = ko.contextFor(ui.item[0]).$data,\n                        position = ko.utils.arrayIndexOf(ui.item.parent().children(), ui.item[0]);\n\n                    if (ko.contextFor(ui.item[0]).$index() != position) { //eslint-disable-line eqeqeq\n                        if (position >= 0) {\n                            list.remove(item);\n                            list.splice(position, 0, item);\n                        }\n                        ui.item.remove();\n                    }\n                }\n            });\n        }\n    };\n\n    return Collapsible.extend({\n        defaults: {\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            createOptionsUrl: null,\n            attributes: [],\n            stepInitialized: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.createAttribute = _.wrap(this.createAttribute, function () {\n                var args = _.toArray(arguments),\n                    createAttribute = args.shift();\n\n                return this.doInitSavedOptions(createAttribute.apply(this, args));\n            });\n            this.createAttribute = _.memoize(this.createAttribute.bind(this), _.property('id'));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['attributes']);\n\n            return this;\n        },\n\n        /**\n         * Create option.\n         */\n        createOption: function () {\n            // this - current attribute\n            this.options.push({\n                value: 0,\n                label: '',\n                id: utils.uniqueid(),\n                'attribute_id': this.id,\n                'is_new': true\n            });\n        },\n\n        /**\n         * @param {Object} option\n         */\n        saveOption: function (option) {\n            if (this.isValidOption(option)) {\n                this.options.remove(option);\n                this.options.push(option);\n                this.chosenOptions.push(option.id);\n            }\n        },\n\n        /**\n         * @param {Object} newOption\n         * @return boolean\n         */\n        isValidOption: function (newOption) {\n            var duplicatedOptions = [],\n                errorOption,\n                allOptions = [];\n\n            newOption.label = newOption.label.trim();\n\n            if (_.isEmpty(newOption.label)) {\n                return false;\n            }\n\n            _.each(this.options(), function (option) {\n                if (!_.isUndefined(allOptions[option.label]) && newOption.label === option.label) {\n                    duplicatedOptions.push(option);\n                }\n\n                allOptions[option.label] = option.label;\n            });\n\n            if (duplicatedOptions.length) {\n                _.each(duplicatedOptions, function (duplicatedOption) {\n                    errorOption = $('[data-role=\"' + duplicatedOption.id + '\"]');\n                    errorOption.addClass('_error');\n                });\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * @param {Object} option\n         */\n        removeOption: function (option) {\n            this.options.remove(option);\n        },\n\n        /**\n         * @param {String} attribute\n         */\n        removeAttribute: function (attribute) {\n            this.attributes.remove(attribute);\n            this.wizard.setNotificationMessage(\n                $.mage.__('An attribute has been removed. This attribute will no longer appear in your configurations.')\n            );\n        },\n\n        /**\n         * @param {Object} attribute\n         * @param {*} index\n         * @return {Object}\n         */\n        createAttribute: function (attribute, index) {\n            attribute.chosenOptions = ko.observableArray([]);\n            attribute.options = ko.observableArray(_.map(attribute.options, function (option) {\n                option.id = utils.uniqueid();\n\n                return option;\n            }));\n            attribute.opened = ko.observable(this.initialOpened(index));\n            attribute.collapsible = ko.observable(true);\n            attribute.isValidOption = this.isValidOption;\n\n            return attribute;\n        },\n\n        /**\n         * First 3 attribute panels must be open.\n         *\n         * @param {Number} index\n         * @return {Boolean}\n         */\n        initialOpened: function (index) {\n            return index < 3;\n        },\n\n        /**\n         * Save attribute.\n         */\n        saveAttribute: function () {\n            var errorMessage = $.mage.__('Select options for all attributes or remove unused attributes.');\n\n            if (!this.attributes().length) {\n                throw new Error(errorMessage);\n            }\n\n            _.each(this.attributes(), function (attribute) {\n                attribute.chosen = [];\n\n                if (!attribute.chosenOptions.getLength()) {\n                    throw new Error(errorMessage);\n                }\n                _.each(attribute.chosenOptions(), function (id) {\n                    attribute.chosen.push(attribute.options.findWhere({\n                        id: id\n                    }));\n                });\n            });\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        selectAllAttributes: function (attribute) {\n            this.chosenOptions(_.pluck(attribute.options(), 'id'));\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        deSelectAllAttributes: function (attribute) {\n            attribute.chosenOptions.removeAll();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        saveOptions: function () {\n            var newOptions = [];\n\n            _.each(this.attributes(), function (attribute) {\n                _.each(attribute.options(), function (element) {\n                    var option = attribute.options.findWhere({\n                        id: element.id\n                    });\n\n                    if (option['is_new'] === true) {\n                        if (!attribute.isValidOption(option)) {\n                            throw new Error(\n                                $.mage.__('The value of attribute \"\"%1\"\" must be unique')\n                                    .replace('\"%1\"', attribute.label)\n                            );\n                        }\n\n                        newOptions.push(option);\n                    }\n                });\n            });\n\n            if (!newOptions.length) {\n                return false;\n            }\n\n            $.ajax({\n                type: 'POST',\n                url: this.createOptionsUrl,\n                data: {\n                    options: newOptions\n                },\n                showLoader: true\n            }).done(function (savedOptions) {\n                if (savedOptions.error) {\n                    this.notificationMessage.error = savedOptions.error;\n                    this.notificationMessage.text = savedOptions.message;\n\n                    return;\n                }\n\n                _.each(this.attributes(), function (attribute) {\n                    _.each(savedOptions, function (newOptionId, oldOptionId) {\n                        var option = attribute.options.findWhere({\n                            id: oldOptionId\n                        });\n\n                        if (option) {\n                            attribute.options.remove(option);\n                            option['is_new'] = false;\n                            option.value = newOptionId;\n                            attribute.options.push(option);\n                        }\n                    });\n                });\n\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attributeIds\n         */\n        requestAttributes: function (attributeIds) {\n            $.ajax({\n                type: 'GET',\n                url: this.optionsUrl,\n                data: {\n                    attributes: attributeIds\n                },\n                showLoader: true\n            }).done(function (attributes) {\n                attributes = _.sortBy(attributes, function (attribute) {\n                    return this.wizard.data.attributesIds.indexOf(attribute.id);\n                }.bind(this));\n                this.attributes(_.map(attributes, this.createAttribute));\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attribute\n         * @return {*}\n         */\n        doInitSavedOptions: function (attribute) {\n            var selectedOptions, selectedOptionsIds, selectedAttribute = _.findWhere(this.initData.attributes, {\n                id: attribute.id\n            });\n\n            if (selectedAttribute) {\n                selectedOptions = _.pluck(selectedAttribute.chosen, 'value');\n                selectedOptionsIds = _.pluck(_.filter(attribute.options(), function (option) {\n                    return _.contains(selectedOptions, option.value);\n                }), 'id');\n                attribute.chosenOptions(selectedOptionsIds);\n                this.initData.attributes = _.without(this.initData.attributes, selectedAttribute);\n            }\n\n            return attribute;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.requestAttributes(wizard.data.attributesIds());\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.saveOptions();\n            this.saveAttribute(wizard);\n\n            wizard.data.attributes = this.attributes;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        back: function (wizard) {\n            wizard.data.attributesIds(this.attributes().pluck('id'));\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/paging/paging',\n    'mage/translate'\n], function (Component, $, ko, _, paging) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }',\n                modalComponent: '${ $.modalComponent }',\n                matrixGridComponent: '${ $.matrixGridComponent }'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            gridExisting: [],\n            gridNew: [],\n            gridDeleted: [],\n            variationsExisting: [],\n            variationsNew: [],\n            variationsDeleted: [],\n            pagingExisting: paging({\n                name: 'configurableWizard.pagingExisting',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingExisting_sizes'\n                }\n            }),\n            pagingNew: paging({\n                name: 'configurableWizard.pagingNew',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingNew_sizes'\n                }\n            }),\n            pagingDeleted: paging({\n                name: 'configurableWizard.pagingDeleted',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingDeleted_sizes'\n                }\n            }),\n            attributes: [],\n            attributesName: [$.mage.__('Images'), $.mage.__('SKU'), $.mage.__('Quantity'), $.mage.__('Price')],\n            sections: [],\n            gridTemplate: 'Magento_ConfigurableProduct/variations/steps/summary-grid',\n            quantityFieldName: 'quantity'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            var pagingObservables = {\n                currentNew: ko.getObservable(this.pagingNew, 'current'),\n                currentExisting: ko.getObservable(this.pagingExisting, 'current'),\n                currentDeleted: ko.getObservable(this.pagingDeleted, 'current'),\n                pageSizeNew: ko.getObservable(this.pagingNew, 'pageSize'),\n                pageSizeExisting: ko.getObservable(this.pagingExisting, 'pageSize'),\n                pageSizeDeleted: ko.getObservable(this.pagingDeleted, 'pageSize')\n            };\n\n            this._super().observe('gridExisting gridNew gridDeleted attributes sections');\n            this.gridExisting.columns = ko.observableArray();\n            this.gridNew.columns = ko.observableArray();\n            this.gridDeleted.columns = ko.observableArray();\n\n            _.each(pagingObservables, function (observable) {\n                observable.subscribe(function () {\n                    this.generateGrid();\n                }, this);\n            }, this);\n\n            return this;\n        },\n        nextLabelText: $.mage.__('Generate Products'),\n        variations: [],\n\n        /**\n         * @param {*} variations\n         * @param {Function} getSectionValue\n         */\n        calculate: function (variations, getSectionValue) {\n            var productSku = this.variationsComponent().getProductValue('sku'),\n                productPrice = this.variationsComponent().getProductPrice(),\n                productWeight = this.variationsComponent().getProductValue('weight'),\n                productName = this.variationsComponent().getProductValue('name'),\n                variationsKeys = [],\n                gridExisting = [],\n                gridNew = [],\n                gridDeleted = [],\n                matrixGridData = this.matrixGridComponent() ?\n                    _.indexBy(this.matrixGridComponent().getUnionInsertData(), 'variationKey') : {};\n\n            this.variations = [];\n            _.each(variations, function (options) {\n                var product, images, sku, name, quantity, price, variation,\n                    variationsKey = this.variationsComponent().getVariationKey(options),\n                    productDataFromGrid = matrixGridData[variationsKey] || {},\n                    productDataFromWizard = {},\n                    productId = this.variationsComponent().getProductIdByOptions(options);\n\n                if (productId) {\n                    product = _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    });\n                }\n                images = getSectionValue('images', options);\n                sku = productSku + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                name = productName + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                quantity = getSectionValue(this.quantityFieldName, options);\n\n                if (quantity) {\n                    productDataFromWizard[this.quantityFieldName] = quantity;\n                }\n                price = getSectionValue('price', options);\n\n                if (price) {\n                    productDataFromWizard.price = price;\n                }\n\n                if (productId && !images.file) {\n                    images = product.images;\n                }\n                productDataFromGrid = _.pick(\n                    productDataFromGrid,\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    'qty'\n                );\n\n                if (productDataFromGrid.hasOwnProperty('qty')) {\n                    productDataFromGrid[this.quantityFieldName] = productDataFromGrid.qty;\n                }\n                delete productDataFromGrid.qty;\n                product = _.pick(\n                    product || {},\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    this.quantityFieldName\n                );\n                variation = {\n                    options: options,\n                    images: images,\n                    sku: sku,\n                    name: name,\n                    price: productPrice,\n                    productId: productId,\n                    weight: productWeight,\n                    editable: true\n                };\n                variation[this.quantityFieldName] = quantity;\n                variation = _.extend(variation, product, productDataFromGrid, productDataFromWizard);\n\n                if (productId) {\n                    gridExisting.push(this.prepareRowForGrid(variation));\n                } else {\n                    gridNew.push(this.prepareRowForGrid(variation));\n                }\n                this.variations.push(variation);\n                variationsKeys.push(variationsKey);\n            }, this);\n\n            _.each(_.omit(this.variationsComponent().productAttributesMap, variationsKeys), function (productId) {\n                gridDeleted.push(this.prepareRowForGrid(\n                    _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    })\n                ));\n            }.bind(this));\n\n            this.variationsExisting = gridExisting;\n            this.variationsNew = gridNew;\n            this.variationsDeleted = gridDeleted;\n        },\n\n        /**\n         * Generate grid.\n         */\n        generateGrid: function () {\n            var pageExisting = this.pagingExisting.pageSize * this.pagingExisting.current,\n                pageNew = this.pagingNew.pageSize * this.pagingNew.current,\n                pageDeleted = this.pagingDeleted.pageSize * this.pagingDeleted.current;\n\n            this.pagingExisting.totalRecords = this.variationsExisting.length;\n            this.gridExisting(this.variationsExisting.slice(pageExisting - this.pagingExisting.pageSize, pageExisting));\n\n            this.pagingNew.totalRecords = this.variationsNew.length;\n            this.gridNew(this.variationsNew.slice(pageNew - this.pagingNew.pageSize, pageNew));\n\n            this.pagingDeleted.totalRecords = this.variationsDeleted.length;\n            this.gridDeleted(this.variationsDeleted.slice(pageDeleted - this.pagingDeleted.pageSize, pageDeleted));\n        },\n\n        /**\n         * @param {Object} variation\n         * @return {Array}\n         */\n        prepareRowForGrid: function (variation) {\n            var row = [];\n\n            row.push(_.extend({\n                images: []\n            }, variation.images));\n            row.push(variation.sku);\n            row.push(variation[this.quantityFieldName]);\n            _.each(variation.options, function (option) {\n                row.push(option.label);\n            });\n            row.push(this.variationsComponent().getCurrencySymbol() +  ' ' + variation.price);\n\n            return row;\n        },\n\n        /**\n         * @return {String|*}\n         */\n        getGridTemplate: function () {\n            return this.gridTemplate;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getGridId: function () {\n            return _.uniqueId('grid_');\n        },\n\n        /**\n         * @param {*} attributes\n         * @return {Array}\n         */\n        getColumnsName: function (attributes) {\n            var columns = this.attributesName.slice(0);\n\n            attributes.each(function (attribute, index) {\n                columns.splice(3 + index, 0, attribute.label);\n            }, this);\n\n            return columns;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.sections(wizard.data.sections());\n            this.attributes(wizard.data.attributes());\n            this.gridNew([]);\n            this.gridExisting([]);\n            this.gridDeleted([]);\n            this.gridExisting.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridNew.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridDeleted.columns(this.getColumnsName(this.variationsComponent().productAttributes));\n            this.calculate(wizard.data.variations, wizard.data.sectionHelper);\n            this.generateGrid();\n        },\n\n        /**\n         * Force.\n         */\n        force: function () {\n            this.variationsComponent().render(this.variations, this.attributes());\n            this.modalComponent().closeModal();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY, byteConvert */\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Catalog/js/product-gallery',\n    'jquery/file-uploader',\n    'mage/translate',\n    'Magento_ConfigurableProduct/js/variations/variations'\n], function (Component, $, ko, _, Collapsible, mageTemplate, alert) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }'\n            },\n            countVariations: 0,\n            attributes: [],\n            sections: {},\n            images: null,\n            price: '',\n            quantity: '',\n            notificationMessage: {\n                text: null,\n                error: null\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe('countVariations attributes sections');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n            this.sections({\n                images: {\n                    label: 'images',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                },\n                price: {\n                    label: 'price',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable(),\n                    currencySymbol: ''\n                },\n                quantity: {\n                    label: 'quantity',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                }\n            });\n\n            this.variationsComponent(function (variationsComponent) {\n                this.sections().price.currencySymbol = variationsComponent.getCurrencySymbol();\n            }.bind(this));\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantity: this.quantity\n                };\n            }.bind(this);\n\n            /**\n             * @param {Object} images\n             * @param {*} typePreview\n             */\n            this.makeImages = function (images, typePreview) {\n                var preview;\n\n                if (!images) {\n                    this.images = [];\n                    this.preview = self.noImage;\n                    this.file = null;\n                } else {\n                    this.images = images;\n                    preview = _.find(this.images, function (image) {\n                        return _.contains(image.galleryTypes, typePreview);\n                    });\n\n                    if (preview) {\n                        this.file = preview.file;\n                        this.preview = preview.url;\n                    } else {\n                        this.file = null;\n                        this.preview = self.noImage;\n                    }\n                }\n            };\n            this.images = new this.makeImages();\n            _.each(this.sections(), function (section) {\n                section.type.subscribe(function () {\n                    this.setWizardNotifyMessageDependOnSectionType();\n                }.bind(this));\n            }, this);\n        },\n        types: ['each', 'single', 'none'],\n\n        /**\n         * Set Wizard notify message depend on section type\n         */\n        setWizardNotifyMessageDependOnSectionType: function () {\n            var flag = false;\n\n            _.each(this.sections(), function (section) {\n                if (section.type() !== 'none') {\n                    flag = true;\n                }\n            }, this);\n\n            if (flag) {\n                this.wizard.setNotificationMessage(\n                    $.mage.__('Choose this option to delete and replace extension data for all past configurations.')\n                );\n            } else {\n                this.wizard.cleanNotificationMessage();\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.attributes(wizard.data.attributes());\n\n            if (this.mode === 'edit') {\n                this.setWizardNotifyMessageDependOnSectionType();\n            }\n            //fill option section data\n            this.attributes.each(function (attribute) {\n                attribute.chosen.each(function (option) {\n                    option.sections = ko.observable(this.makeOptionSections());\n                }, this);\n            }, this);\n            //reset section.attribute\n            _.each(this.sections(), function (section) {\n                section.attribute(null);\n            });\n\n            this.initCountVariations();\n            this.bindGalleries();\n        },\n\n        /**\n         * Init count variations.\n         */\n        initCountVariations: function () {\n            var variations = this.generateVariation(this.attributes()),\n                newVariations = _.map(variations, function (options) {\n                    return this.variationsComponent().getVariationKey(options);\n                }.bind(this)),\n                existingVariations = _.keys(this.variationsComponent().productAttributesMap);\n\n            this.countVariations(_.difference(newVariations, existingVariations).length);\n        },\n\n        /**\n         * @param {Object} attributes - example [['b1', 'b2'],['a1', 'a2', 'a3'],['c1', 'c2', 'c3'],['d1']]\n         * @returns {*} example [['b1','a1','c1','d1'],['b1','a1','c2','d1']...]\n         */\n        generateVariation: function (attributes) {\n            return _.reduce(attributes, function (matrix, attribute) {\n                var tmp = [];\n\n                _.each(matrix, function (variations) {\n                    _.each(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n                        tmp.push(_.union(variations, [option]));\n                    });\n                });\n\n                if (!tmp.length) {\n                    return _.map(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n\n                        return [option];\n                    });\n                }\n\n                return tmp;\n            }, []);\n        },\n\n        /**\n         * @param {*} section\n         * @param {Object} options\n         * @return {*}\n         */\n        getSectionValue: function (section, options) {\n            switch (this.sections()[section].type()) {\n                case 'each':\n                    return _.find(this.sections()[section].attribute().chosen, function (chosen) {\n                        return _.find(options, function (option) {\n                            return chosen.id == option.id; //eslint-disable-line eqeqeq\n                        });\n                    }).sections()[section];\n\n                case 'single':\n                    return this.sections()[section].value();\n\n                case 'none':\n                    return this[section];\n            }\n        },\n\n        /**\n         * @param {*} node\n         * @return {Promise|*}\n         */\n        getImageProperty: function (node) {\n            var types = node.find('[data-role=gallery]').productGallery('option').types,\n                images = _.map(node.find('[data-role=image]'), function (image) {\n                    var imageData = $(image).data('imageData'),\n                        positionElement;\n\n                    imageData.galleryTypes = _.pluck(_.filter(types, function (type) {\n                        return type.value === imageData.file;\n                    }), 'code');\n\n                    //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    positionElement =\n                        $(image).find('[name=\"product[media_gallery][images][' + imageData.file_id + '][position]\"]');\n                    //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    if (!_.isEmpty(positionElement.val())) {\n                        imageData.position = positionElement.val();\n                    }\n\n                    return imageData;\n                });\n\n            return _.reject(images, function (image) {\n                return !!image.isRemoved;\n            });\n        },\n\n        /**\n         * Fill images section.\n         */\n        fillImagesSection: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    if (this.sections().images.attribute()) {\n                        this.sections().images.attribute().chosen.each(function (option) {\n                            option.sections().images = new this.makeImages(\n                                this.getImageProperty($('[data-role=step-gallery-option-' + option.id + ']')),\n                                'thumbnail'\n                            );\n                        }, this);\n                    }\n                    break;\n\n                case 'single':\n                    this.sections().images.value(new this.makeImages(\n                        this.getImageProperty($('[data-role=step-gallery-single]')),\n                        'thumbnail'\n                    ));\n                    break;\n\n                default:\n                    this.sections().images.value(new this.makeImages());\n                    break;\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.fillImagesSection();\n            this.validate();\n            this.validateImage();\n            wizard.data.sections = this.sections;\n            wizard.data.sectionHelper = this.getSectionValue.bind(this);\n            wizard.data.variations = this.generateVariation(this.attributes());\n        },\n\n        /**\n         * Validate.\n         */\n        validate: function () {\n            var formValid;\n\n            _.each(this.sections(), function (section) {\n                switch (section.type()) {\n                    case 'each':\n                        if (!section.attribute()) {\n                            throw new Error($.mage.__('Please select attribute for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n\n                    case 'single':\n                        if (!section.value()) {\n                            throw new Error($.mage.__('Please fill in the values for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n                }\n            }, this);\n            formValid = true;\n            _.each($('[data-role=attributes-values-form]'), function (form) {\n                formValid = $(form).valid() && formValid;\n            });\n\n            if (!formValid) {\n                throw new Error($.mage.__('Please fill-in correct values.'));\n            }\n        },\n\n        /**\n         * Validate image.\n         */\n        validateImage: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    _.each(this.sections().images.attribute().chosen, function (option) {\n                        if (!option.sections().images.images.length) {\n                            throw new Error($.mage.__('Please select image(s) for your attribute.'));\n                        }\n                    });\n                    break;\n\n                case 'single':\n                    if (this.sections().images.value().file == null) {\n                        throw new Error($.mage.__('Please choose image(s).'));\n                    }\n                    break;\n            }\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n            this.setWizardNotifyMessageDependOnSectionType();\n        },\n\n        /**\n         * Bind galleries.\n         */\n        bindGalleries: function () {\n            $('[data-role=bulk-step] [data-role=gallery]').each(function (index, element) {\n                var gallery = $(element),\n                    uploadInput = $(gallery.find('[name=image]')),\n                    dropZone = $(gallery).find('.image-placeholder');\n\n                if (!gallery.data('gallery-initialized')) {\n                    gallery.mage('productGallery', {\n                        template: '[data-template=gallery-content]',\n                        dialogTemplate: '.dialog-template',\n                        dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n                    });\n\n                    uploadInput.fileupload({\n                        dataType: 'json',\n                        dropZone: dropZone,\n                        process: [{\n                            action: 'load',\n                            fileTypes: /^image\\/(gif|jpeg|png)$/\n                        }, {\n                            action: 'resize',\n                            maxWidth: 1920,\n                            maxHeight: 1200\n                        }, {\n                            action: 'save'\n                        }],\n                        formData: {\n                            'form_key': FORM_KEY\n                        },\n                        sequentialUploads: true,\n                        acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        add: function (e, data) {\n                            var progressTmpl = mageTemplate('[data-template=uploader]'),\n                                fileSize,\n                                tmpl;\n\n                            $.each(data.files, function (i, file) {\n                                fileSize = typeof file.size == 'undefined' ?\n                                    $.mage.__('We could not detect a size.') :\n                                    byteConvert(file.size);\n\n                                data.fileId = Math.random().toString(33).substr(2, 18);\n\n                                tmpl = progressTmpl({\n                                    data: {\n                                        name: file.name,\n                                        size: fileSize,\n                                        id: data.fileId\n                                    }\n                                });\n\n                                $(tmpl).appendTo(gallery.find('[data-role=uploader]'));\n                            });\n\n                            $(this).fileupload('process', data).done(function () {\n                                data.submit();\n                            });\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        done: function (e, data) {\n                            if (data.result && !data.result.error) {\n                                gallery.trigger('addItem', data.result);\n                            } else {\n                                $('#' + data.fileId)\n                                    .delay(2000)\n                                    .hide('highlight');\n                                alert({\n                                    content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                                });\n                            }\n                            $('#' + data.fileId).remove();\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        progress: function (e, data) {\n                            var progress = parseInt(data.loaded / data.total * 100, 10),\n                                progressSelector = '#' + data.fileId + ' .progressbar-container .progressbar';\n\n                            $(progressSelector).css('width', progress + '%');\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        fail: function (e, data) {\n                            var progressSelector = '#' + data.fileId;\n\n                            $(progressSelector).removeClass('upload-progress').addClass('upload-failure')\n                                .delay(2000)\n                                .hide('highlight')\n                                .remove();\n                        }\n                    });\n                    gallery.data('gallery-initialized', 1);\n                }\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/modal-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'underscore'\n], function (Modal, registry, _) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            stepWizard: '',\n            modules: {\n                form: '${ $.formName }'\n            }\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            var stepWizard = {};\n\n            this.form().validate();\n\n            if (this.form().source.get('params.invalid') === false) {\n                stepWizard = registry.get('index = ' + this.stepWizard);\n\n                if (!_.isUndefined(stepWizard)) {\n                    stepWizard.open();\n                }\n\n                this._super();\n            } else {\n                this.form().focusInvalid();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/container-configurable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.is_downloadable': 'handleProductType'\n            },\n            links: {\n                isDownloadable: '${ $.provider }:data.is_downloadable'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.handleProductType(this.isDownloadable);\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Change content for container and visibility for button\n         *\n         * @param {String} isDownloadable\n         */\n        handleProductType: function (isDownloadable) {\n            if (isDownloadable === '1') {\n                this.content(this.content2);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(false);\n                }\n            } else {\n                this.content(this.content1);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(true);\n                }\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-warning.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            isConfigurable: false\n        },\n\n        /**\n         * Updates component visibility state.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateVisibility: function (variationsEmpty) {\n            var isVisible = this.isConfigurable || !variationsEmpty;\n\n            this.visible(isVisible);\n\n            return isVisible;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Catalog/js/components/custom-options-price-type'\n], function (_, PriceType) {\n    'use strict';\n\n    return PriceType.extend({\n        defaults: {\n            isConfigurable: false,\n            isFiltered: null,\n            defaultOptions: null,\n            filteredOptions: null,\n            bannedOptions: []\n        },\n\n        /**\n         * Updates options.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateOptions: function (variationsEmpty) {\n            var isFiltered = this.isConfigurable || !variationsEmpty,\n                value;\n\n            if (this.isFiltered !== isFiltered) {\n                value = this.value();\n\n                this.options(isFiltered ? this.getFilteredOptions() : this.getDefaultOptions());\n                this.value(value);\n            }\n\n            return isFiltered;\n        },\n\n        /**\n         * Get default list of options.\n         *\n         * @returns {Array}\n         */\n        getDefaultOptions: function () {\n            if (this.defaultOptions === null) {\n                this.defaultOptions = this.options();\n            }\n\n            return this.defaultOptions;\n        },\n\n        /**\n         * Get filtered list of options.\n         *\n         * @returns {Array}\n         */\n        getFilteredOptions: function () {\n            var defaultOptions;\n\n            if (this.filteredOptions === null) {\n                defaultOptions = this.getDefaultOptions();\n                this.filteredOptions = [];\n\n                _.each(defaultOptions, function (option) {\n                    if (this.bannedOptions.indexOf(option.value) === -1) {\n                        this.filteredOptions.push(option);\n                    }\n                }, this);\n            }\n\n            return this.filteredOptions;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader',\n    'underscore'\n], function (Element, _) {\n    'use strict';\n\n    return Element.extend({\n        processedFile: {},\n        actionsListOpened: false,\n        thumbnailUrl: '',\n        thumbnail: null,\n        smallImage: null,\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['processedFile', 'actionsListOpened', 'thumbnailUrl', 'thumbnail', 'smallImage']);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            var value = this.getInitialValue();\n\n            if (!_.isString(value)) {\n                this._super();\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {Object} Chainable.\n         */\n        addFile: function (file) {\n            this.processedFile(this.processFile(file));\n\n            this.value(this.processedFile().file);\n\n            return this;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            } else {\n                this.actionsListOpened(true);\n            }\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @returns {Object} Chainable\n         */\n        closeList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete Image\n         *\n         * @returns {Object} Chainable\n         */\n        deleteImage: function () {\n            this.processedFile({});\n            this.value(null);\n            this.thumbnail(null);\n            this.thumbnailUrl(null);\n            this.smallImage(null);\n\n            return this;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'jquery'\n], function (_, registry, dynamicRows, $) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            actionsListOpened: false,\n            canEditField: 'canEdit',\n            newProductField: 'newProduct',\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            dataProviderFromGrid: '',\n            dataProviderChangeFromGrid: '',\n            insertDataFromGrid: [],\n            changeDataFromGrid: [],\n            dataProviderFromWizard: '',\n            insertDataFromWizard: [],\n            map: null,\n            isEmpty: true,\n            isShowAddProductButton: false,\n            cacheGridData: [],\n            unionInsertData: [],\n            deleteProperty: false,\n            dataLength: 0,\n            identificationProperty: 'id',\n            'attribute_set_id': '',\n            attributesTmp: [],\n            changedFlag: 'was_changed',\n            listens: {\n                'insertDataFromGrid': 'processingInsertDataFromGrid',\n                'insertDataFromWizard': 'processingInsertDataFromWizard',\n                'unionInsertData': 'processingUnionInsertData',\n                'changeDataFromGrid': 'processingChangeDataFromGrid',\n                'isEmpty': 'changeVisibility'\n            },\n            imports: {\n                'attribute_set_id': '${$.provider}:data.product.attribute_set_id'\n            },\n            'exports': {\n                'attribute_set_id': '${$.provider}:data.new-variations-attribute-set-id'\n            },\n            modules: {\n                modalWithGrid: '${ $.modalWithGrid }',\n                gridWithProducts: '${ $.gridWithProducts}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super()\n                .changeVisibility(this.isEmpty());\n\n            return this;\n        },\n\n        /**\n         * Change visibility\n         *\n         * When isEmpty = true, then visbible = false\n         *\n         * @param {Boolean} isEmpty\n         */\n        changeVisibility: function (isEmpty) {\n            this.visible(!isEmpty);\n        },\n\n        /**\n         * Open modal with grid.\n         *\n         * @param {String} rowIndex\n         */\n        openModalWithGrid: function (rowIndex) {\n            var productSource = this.source.get(this.dataScope + '.' + this.index + '.' + rowIndex),\n                product = {\n                    'id': productSource.id,\n                    'attributes': productSource['configurable_attribute']\n                };\n\n            this.modalWithGrid().openModal();\n            this.gridWithProducts().showGridChangeProduct(rowIndex, product);\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            var tmpArray = [];\n\n            this.recordData.each(function (recordData) {\n                tmpArray.push(recordData);\n            }, this);\n\n            this.unionInsertData(tmpArray);\n\n            return this;\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         */\n        deleteRecord: function (index) {\n            var tmpArray,\n                lastRecord;\n\n            this.reRender = false;\n            tmpArray = this.getUnionInsertData();\n            tmpArray.splice(index, 1);\n\n            if (!tmpArray.length) {\n                this.attributesTmp = this.source.get('data.attributes');\n                this.source.set('data.attributes', []);\n                this.cacheGridData = [];\n            }\n\n            if (parseInt(this.currentPage(), 10) === this.pages()) {\n                lastRecord =\n                    _.findWhere(this.elems(), {\n                        index: this.startIndex + this.getChildItems().length - 1\n                    }) ||\n                    _.findWhere(this.elems(), {\n                        index: (this.startIndex + this.getChildItems().length - 1).toString()\n                    });\n\n                lastRecord.destroy();\n            }\n\n            this.unionInsertData(tmpArray);\n\n            if (this.pages() < parseInt(this.currentPage(), 10)) {\n                this.currentPage(this.pages());\n            }\n\n            this.reRender = true;\n            this.showSpinner(false);\n        },\n\n        /**\n         * Generate associated products\n         */\n        generateAssociatedProducts: function () {\n            var productsIds = [];\n\n            this.getUnionInsertData().forEach(function (data) {\n                if (data.id !== null) {\n                    productsIds.push(data.id);\n                }\n            });\n\n            this.source.set(this.dataScopeAssociatedProduct, productsIds);\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertDataFromGrid', 'unionInsertData', 'isEmpty', 'isShowAddProductButton', 'actionsListOpened'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get union insert data from source\n         *\n         * @returns {Array}\n         */\n        getUnionInsertData: function () {\n            var source = this.source.get(this.dataScope + '.' + this.index),\n                result = [];\n\n            _.each(source, function (data) {\n                result.push(data);\n            });\n\n            return result;\n        },\n\n        /**\n         * Process union insert data.\n         *\n         * @param {Array} data\n         */\n        processingUnionInsertData: function (data) {\n            var dataCount,\n                elemsCount,\n                tmpData,\n                path,\n                attributeCodes = this.source.get('data.attribute_codes');\n\n            this.isEmpty(data.length === 0);\n            this.isShowAddProductButton(\n                (!attributeCodes || data.length > 0 ? data.length : attributeCodes.length) > 0\n            );\n\n            tmpData = data.slice(this.pageSize * (this.currentPage() - 1),\n                                 this.pageSize * (this.currentPage() - 1) + parseInt(this.pageSize, 10));\n\n            this.source.set(this.dataScope + '.' + this.index, []);\n\n            _.each(tmpData, function (row, index) {\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + index);\n                row.attributes = $('<i></i>').text(row.attributes).html();\n                this.source.set(path, row);\n            }, this);\n\n            this.source.set(this.dataScope + '.' + this.index, data);\n            this.parsePagesData(data);\n\n            // Render\n            dataCount = tmpData.length;\n            elemsCount = this.elems().length;\n\n            if (dataCount > elemsCount) {\n                tmpData.each(function (elemData, index) {\n                    this.addChild(elemData, this.startIndex + index);\n                }, this);\n            } else {\n                for (elemsCount; elemsCount > dataCount; elemsCount--) {\n                    this.elems()[elemsCount - 1].destroy();\n                }\n            }\n\n            this.generateAssociatedProducts();\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            return this;\n        },\n\n        /**\n         * Parsed data\n         *\n         * @param {Array} data - array with data\n         * about selected records\n         */\n        processingInsertDataFromGrid: function (data) {\n            var changes,\n                tmpArray;\n\n            if (!data.length) {\n                return;\n            }\n\n            tmpArray = this.getUnionInsertData();\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            changes.each(function (changedObject) {\n                var mappedData = this.mappingValue(changedObject);\n\n                mappedData[this.canEditField] = 0;\n                mappedData[this.newProductField] = 0;\n                mappedData.variationKey = this._getVariationKey(changedObject);\n                mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n                tmpArray.push(mappedData);\n            }, this);\n\n            // Attributes cannot be changed before regeneration thought wizard\n            if (!this.source.get('data.attributes').length) {\n                this.source.set('data.attributes', this.attributesTmp);\n            }\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Process changes from grid.\n         *\n         * @param {Object} data\n         */\n        processingChangeDataFromGrid: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                mappedData = this.mappingValue(data.product);\n\n            mappedData[this.canEditField] = 0;\n            mappedData[this.newProductField] = 0;\n            mappedData.variationKey = this._getVariationKey(data.product);\n            mappedData['configurable_attribute'] = this._getConfigurableAttribute(data.product);\n            tmpArray[data.rowIndex] = mappedData;\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Get variation key.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getVariationKey: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                key = [];\n\n            attrCodes.each(function (code) {\n                key.push(data[code]);\n            });\n\n            return key.sort().join('-');\n        },\n\n        /**\n         * Get configurable attribute.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getConfigurableAttribute: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                confAttrs = {};\n\n            attrCodes.each(function (code) {\n                confAttrs[code] = data[code];\n            });\n\n            return JSON.stringify(confAttrs);\n        },\n\n        /**\n         * Process data insertion from wizard\n         *\n         * @param {Object} data\n         */\n        processingInsertDataFromWizard: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                productIdsToDelete = this.source.get(this.dataScopeAssociatedProduct),\n                index,\n                product = {};\n\n            tmpArray = this.unsetArrayItem(\n                tmpArray,\n                {\n                    id: null\n                }\n            );\n\n            _.each(data, function (row) {\n                if (row.productId) {\n                    index = _.indexOf(productIdsToDelete, row.productId);\n\n                    if (index > -1) {\n                        productIdsToDelete.splice(index, 1);\n                        tmpArray = this.unsetArrayItem(\n                            tmpArray,\n                            {\n                                id: row.productId\n                            }\n                        );\n                    }\n                }\n                product = this.getProductData(row);\n\n                product[this.changedFlag] = true;\n                product[this.canEditField] = row.editable;\n                product[this.newProductField] = row.newProduct;\n                tmpArray.push(product);\n            }, this);\n\n            _.each(productIdsToDelete, function (id) {\n                tmpArray = this.unsetArrayItem(\n                    tmpArray,\n                    {\n                        id: id\n                    }\n                );\n            }, this);\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         *\n         * @param {Object} row\n         * @returns {Object}\n         */\n        getProductData: function (row) {\n            var product,\n                attributesText = '';\n\n            _.each(row.options, function (attribute) {\n                if (attributesText) {\n                    attributesText += ', ';\n                }\n                attributesText += attribute['attribute_label'] + ': ' + attribute.label;\n            }, this);\n\n            product = {\n                'id': row.productId,\n                'product_link': row.productUrl,\n                'name': row.name,\n                'sku': row.sku,\n                'status': row.status,\n                'price': row.price,\n                'price_currency': row.priceCurrency,\n                'price_string': row.priceCurrency + row.price,\n                'weight': row.weight,\n                'qty': row.quantity,\n                'variationKey': row.variationKey,\n                'configurable_attribute': row.attribute,\n                'thumbnail_image': row.images.preview,\n                'media_gallery': row['media_gallery'],\n                'swatch_image': row['swatch_image'],\n                'small_image': row['small_image'],\n                image: row.image,\n                'thumbnail': row.thumbnail,\n                'attributes': attributesText\n            };\n\n            return product;\n        },\n\n        /**\n         * Remove array items matching condition.\n         *\n         * @param {Array} data\n         * @param {Object} condition\n         * @returns {Array}\n         */\n        unsetArrayItem: function (data, condition) {\n            var objs = _.where(data, condition);\n\n            _.each(objs, function (obj) {\n                var index = _.indexOf(data, obj);\n\n                if (index > -1) {\n                    data.splice(index, 1);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.each(function (record, index) {\n                obj[this.map.id] = record[this.map.id];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Mapped value\n         */\n        mappingValue: function (data) {\n            var result = {};\n\n            _.each(this.map, function (prop, index) {\n                result[index] = data[prop];\n            });\n\n            return result;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function (rowIndex) {\n            var state = false;\n\n            if (rowIndex !== this.actionsListOpened()) {\n                state = rowIndex;\n            }\n            this.actionsListOpened(state);\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable\n         */\n        closeList: function (rowIndex) {\n            if (this.actionsListOpened() === rowIndex) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggle product status.\n         *\n         * @param {Number} rowIndex\n         */\n        toggleStatusProduct: function (rowIndex) {\n            var tmpArray = this.getUnionInsertData(),\n                status = parseInt(tmpArray[rowIndex].status, 10);\n\n            if (status === 1) {\n                tmpArray[rowIndex].status = 2;\n            } else {\n                tmpArray[rowIndex].status = 1;\n            }\n\n            tmpArray[rowIndex][this.changedFlag] = true;\n            this.unionInsertData(tmpArray);\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/price-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handlePriceValue(this.isConfigurable);\n            // add listener to track \"configurable\" type\n            this.setListeners({\n                isConfigurable: 'handlePriceValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Disable and clear price if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handlePriceValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n            this.required(!!this.isUseDefault() || !isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/qty-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handleQtyValue(this.isConfigurable);\n\n            /** important to set this listener in initialize because of a different order of processing.\n             * Do not move to defaults->listens section */\n            this.setListeners({\n                isConfigurable: 'handleQtyValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Disable and clear Qty if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handleQtyValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/associated-product-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function (_, insertListing) {\n    'use strict';\n\n    return insertListing.extend({\n        defaults: {\n            gridInitialized: false,\n            paramsUpdated: false,\n            showMassActionColumn: true,\n            currentProductId: 0,\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            typeGrid: '',\n            product: {},\n            rowIndexForChange: undefined,\n            changeProductData: [],\n            modules: {\n                productsProvider: '${ $.productsProvider }',\n                productsColumns: '${ $.productsColumns }',\n                productsMassAction: '${ $.productsMassAction }',\n                modalWithGrid: '${ $.modalWithGrid }',\n                productsFilters: '${ $.productsFilters }'\n            },\n            exports: {\n                externalProviderParams: '${ $.externalProvider }:params'\n            },\n            links: {\n                changeProductData: '${ $.provider }:${ $.changeProductProvider }'\n            },\n            listens: {\n                '${ $.externalProvider }:params': '_setFilters _setVisibilityMassActionColumn',\n                '${ $.productsProvider }:data': '_handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect'\n            }\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(\n                'changeProductData'\n            );\n\n            return this;\n        },\n\n        /**\n         * Get ids of used products.\n         *\n         * @returns {Array}\n         */\n        getUsedProductIds: function () {\n            var usedProductsIds = this.source.get(this.dataScopeAssociatedProduct);\n\n            return usedProductsIds.slice();\n        },\n\n        /**\n         * Request for render content.\n         *\n         * @returns {Object}\n         */\n        doRender: function (showMassActionColumn, typeGrid) {\n            this.typeGrid = typeGrid;\n            this.showMassActionColumn = showMassActionColumn;\n\n            if (this.gridInitialized) {\n                this.paramsUpdated = false;\n                this.productsFilters().clear();\n                this._setFilters(this.externalProviderParams);\n                this._setVisibilityMassActionColumn();\n            }\n\n            return this.render();\n        },\n\n        /**\n         * Show grid with assigned product.\n         *\n         * @returns {Object}\n         */\n        showGridAssignProduct: function () {\n            this.product = {};\n            this.rowIndexForChange = undefined;\n\n            return this.doRender(true, 'assignProduct');\n        },\n\n        /**\n         * Show grid with changed product.\n         *\n         * @param {String} rowIndex\n         * @param {String} product\n         */\n        showGridChangeProduct: function (rowIndex, product) {\n            this.rowIndexForChange = rowIndex;\n            this.product = product;\n            this.doRender(false, 'changeProduct');\n        },\n\n        /**\n         * Select product.\n         *\n         * @param {String} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.changeProductData({\n                rowIndex: this.rowIndexForChange,\n                product: this.productsProvider().data.items[rowIndex]\n            });\n            this.modalWithGrid().closeModal();\n        },\n\n        /**\n         * Set visibility state for mass action column\n         *\n         * @private\n         */\n        _setVisibilityMassActionColumn: function () {\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = this.showMassActionColumn;\n                }, this);\n                massActionComponent.visible = this.showMassActionColumn;\n            }.bind(this));\n        },\n\n        /**\n         * Set filters.\n         *\n         * @param {Object} params\n         * @private\n         */\n        _setFilters: function (params) {\n            var filterModifier = {},\n                attrCodes,\n                usedProductIds,\n                attributes;\n\n            params = _.omit(params);\n\n            if (!this.paramsUpdated) {\n                this.gridInitialized = true;\n                this.paramsUpdated = true;\n\n                attrCodes = this._getAttributesCodes();\n                usedProductIds = this.getUsedProductIds();\n\n                if (this.currentProductId) {\n                    usedProductIds.push(this.currentProductId);\n                }\n\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n                attrCodes.each(function (code) {\n                    filterModifier[code] = {\n                        'condition_type': 'notnull'\n                    };\n                });\n\n                if (this.typeGrid === 'changeProduct') {\n                    attributes = JSON.parse(this.product.attributes);\n\n                    filterModifier = _.extend(filterModifier, _.mapObject(attributes, function (value) {\n                        return {\n                            'condition_type': 'eq',\n                            'value': value\n                        };\n                    }));\n\n                    params.filters = attributes;\n                } else {\n                    params.filters = {};\n                }\n\n                params['attributes_codes'] = attrCodes;\n\n                this.set('externalProviderParams', params);\n                this.set('externalFiltersModifier', filterModifier);\n            }\n        },\n\n        /**\n         * Get attribute codes.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getAttributesCodes: function () {\n            var attrCodes = this.source.get('data.attribute_codes');\n\n            return attrCodes ? attrCodes : [];\n        },\n\n        /**\n         * Get product variations.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getProductVariations: function () {\n            var matrix = this.source.get('data.configurable-matrix');\n\n            return matrix ? matrix : [];\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.typeGrid === 'assignProduct') {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Handle manual selection.\n         *\n         * @param {Array} selected\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows,\n                selectedVariationKeys;\n\n            if (this.typeGrid === 'assignProduct') {\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                    selectedVariationKeys,\n                    _.pluck(this._getProductVariations(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Array} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            var variationKeyMap = {};\n\n            _.each(items, function (row) {\n                variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return variationKeyMap;\n        }\n    });\n});\n","requirejs/domReady.js":"/**\n * @license RequireJS domReady 2.0.1 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/domReady for details\n */\n/*jslint */\n/*global require: false, define: false, requirejs: false,\n  window: false, clearInterval: false, document: false,\n  self: false, setInterval: false */\n\n\ndefine(function () {\n    'use strict';\n\n    var isTop, testDiv, scrollIntervalId,\n        isBrowser = typeof window !== \"undefined\" && window.document,\n        isPageLoaded = !isBrowser,\n        doc = isBrowser ? document : null,\n        readyCalls = [];\n\n    function runCallbacks(callbacks) {\n        var i;\n        for (i = 0; i < callbacks.length; i += 1) {\n            callbacks[i](doc);\n        }\n    }\n\n    function callReady() {\n        var callbacks = readyCalls;\n\n        if (isPageLoaded) {\n            //Call the DOM ready callbacks\n            if (callbacks.length) {\n                readyCalls = [];\n                runCallbacks(callbacks);\n            }\n        }\n    }\n\n    /**\n     * Sets the page as loaded.\n     */\n    function pageLoaded() {\n        if (!isPageLoaded) {\n            isPageLoaded = true;\n            if (scrollIntervalId) {\n                clearInterval(scrollIntervalId);\n            }\n\n            callReady();\n        }\n    }\n\n    if (isBrowser) {\n        if (document.addEventListener) {\n            //Standards. Hooray! Assumption here that if standards based,\n            //it knows about DOMContentLoaded.\n            document.addEventListener(\"DOMContentLoaded\", pageLoaded, false);\n            window.addEventListener(\"load\", pageLoaded, false);\n        } else if (window.attachEvent) {\n            window.attachEvent(\"onload\", pageLoaded);\n\n            testDiv = document.createElement('div');\n            try {\n                isTop = window.frameElement === null;\n            } catch (e) {}\n\n            //DOMContentLoaded approximation that uses a doScroll, as found by\n            //Diego Perini: http://javascript.nwbox.com/IEContentLoaded/,\n            //but modified by other contributors, including jdalton\n            if (testDiv.doScroll && isTop && window.external) {\n                scrollIntervalId = setInterval(function () {\n                    try {\n                        testDiv.doScroll();\n                        pageLoaded();\n                    } catch (e) {}\n                }, 30);\n            }\n        }\n\n        //Check if document is no longer loading, and if so, just trigger page load\n        //listeners. Latest webkit browsers also use \"interactive\", and\n        //will fire the onDOMContentLoaded before \"interactive\" but not after\n        //entering \"interactive\" or \"complete\". More details:\n        //http://dev.w3.org/html5/spec/the-end.html#the-end\n        //http://stackoverflow.com/questions/3665561/document-readystate-of-interactive-vs-ondomcontentloaded\n        //Hmm, this is more complicated on further use, see \"firing too early\"\n        //bug: https://github.com/requirejs/domReady/issues/1\n        //so removing the || document.readyState === \"interactive\" test.\n        //There is still a window.onload binding that should get fired if\n        //DOMContentLoaded is missed.\n        if (document.readyState !== \"loading\") {\n            // Handle it asynchronously to allow scripts the opportunity to delay ready\n            setTimeout(pageLoaded);\n        }\n    }\n\n    /** START OF PUBLIC API **/\n\n    /**\n     * Registers a callback for DOM ready. If DOM is already ready, the\n     * callback is called immediately.\n     * @param {Function} callback\n     */\n    function domReady(callback) {\n        if (isPageLoaded) {\n            callback(doc);\n        } else {\n            readyCalls.push(callback);\n        }\n        return domReady;\n    }\n\n    domReady.version = '2.0.1';\n\n    /**\n     * Loader Plugin API method\n     */\n    domReady.load = function (name, req, onLoad, config) {\n        if (config.isBuild) {\n            onLoad(null);\n        } else {\n            domReady(onLoad);\n        }\n    };\n\n    /** END OF PUBLIC API **/\n\n    return domReady;\n});\n","Magento_UrlRewrite/js/url-rewrite-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/form',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).form().validation({\n            validationUrl: data.url\n        });\n    };\n});\n","Magento_CatalogInventory/js/components/use-config-min-sale-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'underscore',\n    'uiRegistry'\n], function (checkbox, _, registry) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: ''\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            this.onCheckedChanged(this.checked());\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            var valueFromConfig = this.valueFromConfig();\n\n            if (newChecked && (_.isArray(valueFromConfig) && valueFromConfig.length === 0 || valueFromConfig === 1)) {\n                this.changeVisibleDisabled(this.inputField, true, true, 1);\n            } else if (newChecked && _.isObject(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, false, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, true, true, null);\n            } else if (newChecked && _.isNumber(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, true, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            } else {\n                this.changeVisibleDisabled(this.inputField, true, this.disabled() || false, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * Change visible and disabled\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         * @param {Boolean} disabled\n         * @param {Null|Number} valueFromConfig\n         */\n        changeVisibleDisabled: function (filter, visible, disabled, valueFromConfig) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    var initialValue = currentComponent.initialValue;\n\n                    if (_.isString(initialValue) || initialValue === 0 || valueFromConfig === 1) {\n                        currentComponent.value(1);\n                    } else if (initialValue) {\n                        currentComponent.value(initialValue);\n                    }\n\n                    currentComponent.visible(visible);\n                    currentComponent.disabled(disabled);\n                }\n            );\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: '',\n            disableParent: false,\n            listens: {\n                disabled: 'processState',\n                checked: 'processState onCheckedChanged'\n            },\n            imports: {\n                readOnly: 'ns = ${ $.ns }, index = stock_data:disabled'\n            }\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue', 'disableParent']);\n        },\n\n        /**\n         * Handle checked and disabled changes to calculate disableParent value\n         */\n        processState: function () {\n            this.disableParent(this.checked() || this.readOnly);\n\n            if (this.readOnly) {\n                this.disable();\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/qty-validator-changer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input'\n        },\n\n        /**\n         * Change validator\n         */\n        handleChanges: function (value) {\n            var isDigits = value !== 1;\n\n            this.validation['validate-integer'] = isDigits;\n            this.validation['less-than-equals-to'] = isDigits ? 99999999 : 99999999.9999;\n            this.validate();\n        }\n    });\n});\n","Magento_InventoryBundleProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryBundleProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryBundleProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryBundleProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Sm_MegaMenu/js/jquery.nestable.js":"/**\n * Copyright \u00a9 2015 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine( [ \"jquery\" ], function ( $ ) {\n(function($, window, document, undefined)\n{\n\n\tvar hasTouch = 'ontouchstart' in document;\n\n\t/**\n\t * Detect CSS pointer-events property\n\t * events are normally disabled on the dragging element to avoid conflicts\n\t * https://github.com/ausi/Feature-detection-technique-for-pointer-events/blob/master/modernizr-pointerevents.js\n\t */\n\tvar hasPointerEvents = (function () {\n\t\tvar el = document.createElement('div'),\n\t\t\tdocEl = document.documentElement;\n\t\tif (!('pointerEvents' in el.style)) {\n\t\t\treturn false;\n\t\t}\n\t\tel.style.pointerEvents = 'auto';\n\t\tel.style.pointerEvents = 'x';\n\t\tdocEl.appendChild(el);\n\t\tvar supports = window.getComputedStyle && window.getComputedStyle(el, '').pointerEvents === 'auto';\n\t\tdocEl.removeChild(el);\n\t\treturn !!supports;\n\t})();\n\n\tvar defaults = {\n\t\tlistNodeName: 'ol',\n\t\titemNodeName: 'li',\n\t\trootClass: 'dd',\n\t\tlistClass: 'dd-list',\n\t\titemClass: 'dd-item',\n\t\tdragClass: 'dd-dragel',\n\t\thandleClass: 'dd-handle',\n\t\tcollapsedClass: 'dd-collapsed',\n\t\tplaceClass: 'dd-placeholder',\n\t\tnoDragClass: 'dd-nodrag',\n\t\temptyClass: 'dd-empty',\n\t\texpandBtnHTML: '<button data-action=\"expand\" type=\"button\">Expand</button>',\n\t\tcollapseBtnHTML: '<button data-action=\"collapse\" type=\"button\">Collapse</button>',\n\t\tgroup: 0,\n\t\tmaxDepth: 5,\n\t\tthreshold: 20\n\t};\n\n\tfunction Plugin(element, options) {\n\t\tthis.w = $(document);\n\t\tthis.el = $(element);\n\t\tthis.options = $.extend({}, defaults, options);\n\t\tthis.init();\n\t}\n\n\tPlugin.prototype = {\n\n\t\tinit: function () {\n\t\t\tvar list = this;\n\n\t\t\tlist.reset();\n\n\t\t\tlist.el.data('nestable-group', this.options.group);\n\n\t\t\tlist.placeEl = $('<div class=\"' + list.options.placeClass + '\"/>');\n\n\t\t\t$.each(this.el.find(list.options.itemNodeName), function (k, el) {\n\t\t\t\tlist.setParent($(el));\n\t\t\t});\n\n\t\t\tlist.el.on('click', 'button', function (e) {\n\t\t\t\tif (list.dragEl) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar target = $(e.currentTarget),\n\t\t\t\t\taction = target.data('action'),\n\t\t\t\t\titem = target.parent(list.options.itemNodeName);\n\t\t\t\tif (action === 'collapse') {\n\t\t\t\t\tlist.collapseItem(item);\n\t\t\t\t}\n\t\t\t\tif (action === 'expand') {\n\t\t\t\t\tlist.expandItem(item);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tvar onStartEvent = function (e) {\n\t\t\t\tvar handle = $(e.target);\n\t\t\t\tif (!handle.hasClass(list.options.handleClass)) {\n\t\t\t\t\tif (handle.closest('.' + list.options.noDragClass).length) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\thandle = handle.closest('.' + list.options.handleClass);\n\t\t\t\t}\n\n\t\t\t\tif (!handle.length || list.dragEl) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tlist.isTouch = /^touch/.test(e.type);\n\t\t\t\tif (list.isTouch && e.touches.length !== 1) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\te.preventDefault();\n\t\t\t\tlist.dragStart(e.touches ? e.touches[0] : e);\n\t\t\t};\n\n\t\t\tvar onMoveEvent = function (e) {\n\t\t\t\tif (list.dragEl) {\n\t\t\t\t\te.preventDefault();\n\t\t\t\t\tlist.dragMove(e.touches ? e.touches[0] : e);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tvar onEndEvent = function (e) {\n\t\t\t\tif (list.dragEl) {\n\t\t\t\t\te.preventDefault();\n\t\t\t\t\tlist.dragStop(e.touches ? e.touches[0] : e);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tif (hasTouch) {\n\t\t\t\tlist.el[0].addEventListener('touchstart', onStartEvent, false);\n\t\t\t\twindow.addEventListener('touchmove', onMoveEvent, false);\n\t\t\t\twindow.addEventListener('touchend', onEndEvent, false);\n\t\t\t\twindow.addEventListener('touchcancel', onEndEvent, false);\n\t\t\t}\n\n\t\t\tlist.el.on('mousedown', onStartEvent);\n\t\t\tlist.w.on('mousemove', onMoveEvent);\n\t\t\tlist.w.on('mouseup', onEndEvent);\n\n\t\t},\n\n\t\tserialize: function () {\n\t\t\tvar data,\n\t\t\t\tdepth = 0,\n\t\t\t\tlist = this;\n\t\t\tstep = function (level, depth) {\n\t\t\t\tvar array = [],\n\t\t\t\t\titems = level.children(list.options.itemNodeName);\n\t\t\t\titems.each(function () {\n\t\t\t\t\tvar li = $(this),\n\t\t\t\t\t\titem = $.extend({}, li.data()),\n\t\t\t\t\t\tsub = li.children(list.options.listNodeName);\n\t\t\t\t\tif (sub.length) {\n\t\t\t\t\t\titem.children = step(sub, depth + 1);\n\t\t\t\t\t}\n\t\t\t\t\tarray.push(item);\n\t\t\t\t});\n\t\t\t\treturn array;\n\t\t\t};\n\t\t\tdata = step(list.el.find(list.options.listNodeName).first(), depth);\n\t\t\treturn data;\n\t\t},\n\n\t\tserialise: function () {\n\t\t\treturn this.serialize();\n\t\t},\n\n\t\treset: function () {\n\t\t\tthis.mouse = {\n\t\t\t\toffsetX: 0,\n\t\t\t\toffsetY: 0,\n\t\t\t\tstartX: 0,\n\t\t\t\tstartY: 0,\n\t\t\t\tlastX: 0,\n\t\t\t\tlastY: 0,\n\t\t\t\tnowX: 0,\n\t\t\t\tnowY: 0,\n\t\t\t\tdistX: 0,\n\t\t\t\tdistY: 0,\n\t\t\t\tdirAx: 0,\n\t\t\t\tdirX: 0,\n\t\t\t\tdirY: 0,\n\t\t\t\tlastDirX: 0,\n\t\t\t\tlastDirY: 0,\n\t\t\t\tdistAxX: 0,\n\t\t\t\tdistAxY: 0\n\t\t\t};\n\t\t\tthis.isTouch = false;\n\t\t\tthis.moving = false;\n\t\t\tthis.dragEl = null;\n\t\t\tthis.dragRootEl = null;\n\t\t\tthis.dragDepth = 0;\n\t\t\tthis.hasNewRoot = false;\n\t\t\tthis.pointEl = null;\n\t\t},\n\n\t\texpandItem: function (li) {\n\t\t\tli.removeClass(this.options.collapsedClass);\n\t\t\tli.children('[data-action=\"expand\"]').hide();\n\t\t\tli.children('[data-action=\"collapse\"]').show();\n\t\t\tli.children(this.options.listNodeName).show();\n\t\t},\n\n\t\tcollapseItem: function (li) {\n\t\t\tvar lists = li.children(this.options.listNodeName);\n\t\t\tif (lists.length) {\n\t\t\t\tli.addClass(this.options.collapsedClass);\n\t\t\t\tli.children('[data-action=\"collapse\"]').hide();\n\t\t\t\tli.children('[data-action=\"expand\"]').show();\n\t\t\t\tli.children(this.options.listNodeName).hide();\n\t\t\t}\n\t\t},\n\n\t\texpandAll: function () {\n\t\t\tvar list = this;\n\t\t\tlist.el.find(list.options.itemNodeName).each(function () {\n\t\t\t\tlist.expandItem($(this));\n\t\t\t});\n\t\t},\n\n\t\tcollapseAll: function () {\n\t\t\tvar list = this;\n\t\t\tlist.el.find(list.options.itemNodeName).each(function () {\n\t\t\t\tlist.collapseItem($(this));\n\t\t\t});\n\t\t},\n\n\t\tsetParent: function (li) {\n\t\t\tif (li.children(this.options.listNodeName).length) {\n\t\t\t\tli.prepend($(this.options.expandBtnHTML));\n\t\t\t\tli.prepend($(this.options.collapseBtnHTML));\n\t\t\t}\n\t\t\tli.children('[data-action=\"expand\"]').hide();\n\t\t},\n\n\t\tunsetParent: function (li) {\n\t\t\tli.removeClass(this.options.collapsedClass);\n\t\t\tli.children('[data-action]').remove();\n\t\t\tli.children(this.options.listNodeName).remove();\n\t\t},\n\n\t\tdragStart: function (e) {\n\t\t\tvar mouse = this.mouse,\n\t\t\t\ttarget = $(e.target),\n\t\t\t\tdragItem = target.closest(this.options.itemNodeName);\n\n\t\t\tthis.placeEl.css('height', dragItem.height());\n\n\t\t\tmouse.offsetX = e.offsetX !== undefined ? e.offsetX : e.pageX - target.offset().left;\n\t\t\tmouse.offsetY = e.offsetY !== undefined ? e.offsetY : e.pageY - target.offset().top;\n\t\t\tmouse.startX = mouse.lastX = e.pageX;\n\t\t\tmouse.startY = mouse.lastY = e.pageY;\n\n\t\t\tthis.dragRootEl = this.el;\n\n\t\t\tthis.dragEl = $(document.createElement(this.options.listNodeName)).addClass(this.options.listClass + ' ' + this.options.dragClass);\n\t\t\tthis.dragEl.css('width', dragItem.width());\n\n\t\t\tdragItem.after(this.placeEl);\n\t\t\tdragItem[0].parentNode.removeChild(dragItem[0]);\n\t\t\tdragItem.appendTo(this.dragEl);\n\n\t\t\t$(document.body).append(this.dragEl);\n\t\t\tthis.dragEl.css({\n\t\t\t\t'left': e.pageX - mouse.offsetX,\n\t\t\t\t'top': e.pageY - mouse.offsetY\n\t\t\t});\n\t\t\t// total depth of dragging item\n\t\t\tvar i, depth,\n\t\t\t\titems = this.dragEl.find(this.options.itemNodeName);\n\t\t\tfor (i = 0; i < items.length; i++) {\n\t\t\t\tdepth = $(items[i]).parents(this.options.listNodeName).length;\n\t\t\t\tif (depth > this.dragDepth) {\n\t\t\t\t\tthis.dragDepth = depth;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tdragStop: function (e) {\n\t\t\tvar el = this.dragEl.children(this.options.itemNodeName).first();\n\t\t\tel[0].parentNode.removeChild(el[0]);\n\t\t\tthis.placeEl.replaceWith(el);\n\n\t\t\tthis.dragEl.remove();\n\t\t\tthis.el.trigger('change');\n\t\t\tif (this.hasNewRoot) {\n\t\t\t\tthis.dragRootEl.trigger('change');\n\t\t\t}\n\t\t\tthis.reset();\n\t\t},\n\n\t\tdragMove: function (e) {\n\t\t\tvar list, parent, prev, next, depth,\n\t\t\t\topt = this.options,\n\t\t\t\tmouse = this.mouse;\n\n\t\t\tthis.dragEl.css({\n\t\t\t\t'left': e.pageX - mouse.offsetX,\n\t\t\t\t'top': e.pageY - mouse.offsetY\n\t\t\t});\n\n\t\t\t// mouse position last events\n\t\t\tmouse.lastX = mouse.nowX;\n\t\t\tmouse.lastY = mouse.nowY;\n\t\t\t// mouse position this events\n\t\t\tmouse.nowX = e.pageX;\n\t\t\tmouse.nowY = e.pageY;\n\t\t\t// distance mouse moved between events\n\t\t\tmouse.distX = mouse.nowX - mouse.lastX;\n\t\t\tmouse.distY = mouse.nowY - mouse.lastY;\n\t\t\t// direction mouse was moving\n\t\t\tmouse.lastDirX = mouse.dirX;\n\t\t\tmouse.lastDirY = mouse.dirY;\n\t\t\t// direction mouse is now moving (on both axis)\n\t\t\tmouse.dirX = mouse.distX === 0 ? 0 : mouse.distX > 0 ? 1 : -1;\n\t\t\tmouse.dirY = mouse.distY === 0 ? 0 : mouse.distY > 0 ? 1 : -1;\n\t\t\t// axis mouse is now moving on\n\t\t\tvar newAx = Math.abs(mouse.distX) > Math.abs(mouse.distY) ? 1 : 0;\n\n\t\t\t// do nothing on first move\n\t\t\tif (!mouse.moving) {\n\t\t\t\tmouse.dirAx = newAx;\n\t\t\t\tmouse.moving = true;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// calc distance moved on this axis (and direction)\n\t\t\tif (mouse.dirAx !== newAx) {\n\t\t\t\tmouse.distAxX = 0;\n\t\t\t\tmouse.distAxY = 0;\n\t\t\t} else {\n\t\t\t\tmouse.distAxX += Math.abs(mouse.distX);\n\t\t\t\tif (mouse.dirX !== 0 && mouse.dirX !== mouse.lastDirX) {\n\t\t\t\t\tmouse.distAxX = 0;\n\t\t\t\t}\n\t\t\t\tmouse.distAxY += Math.abs(mouse.distY);\n\t\t\t\tif (mouse.dirY !== 0 && mouse.dirY !== mouse.lastDirY) {\n\t\t\t\t\tmouse.distAxY = 0;\n\t\t\t\t}\n\t\t\t}\n\t\t\tmouse.dirAx = newAx;\n\n\t\t\t/**\n\t\t\t * move horizontal\n\t\t\t */\n\t\t\tif (mouse.dirAx && mouse.distAxX >= opt.threshold) {\n\t\t\t\t// reset move distance on x-axis for new phase\n\t\t\t\tmouse.distAxX = 0;\n\t\t\t\tprev = this.placeEl.prev(opt.itemNodeName);\n\t\t\t\t// increase horizontal level if previous sibling exists and is not collapsed\n\t\t\t\tif (mouse.distX > 0 && prev.length && !prev.hasClass(opt.collapsedClass)) {\n\t\t\t\t\t// cannot increase level when item above is collapsed\n\t\t\t\t\tlist = prev.find(opt.listNodeName).last();\n\t\t\t\t\t// check if depth limit has reached\n\t\t\t\t\tdepth = this.placeEl.parents(opt.listNodeName).length;\n\t\t\t\t\tif (depth + this.dragDepth <= opt.maxDepth) {\n\t\t\t\t\t\t// create new sub-level if one doesn't exist\n\t\t\t\t\t\tif (!list.length) {\n\t\t\t\t\t\t\tlist = $('<' + opt.listNodeName + '/>').addClass(opt.listClass);\n\t\t\t\t\t\t\tlist.append(this.placeEl);\n\t\t\t\t\t\t\tprev.append(list);\n\t\t\t\t\t\t\tthis.setParent(prev);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// else append to next level up\n\t\t\t\t\t\t\tlist = prev.children(opt.listNodeName).last();\n\t\t\t\t\t\t\tlist.append(this.placeEl);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t// decrease horizontal level\n\t\t\t\tif (mouse.distX < 0) {\n\t\t\t\t\t// we can't decrease a level if an item preceeds the current one\n\t\t\t\t\tnext = this.placeEl.next(opt.itemNodeName);\n\t\t\t\t\tif (!next.length) {\n\t\t\t\t\t\tparent = this.placeEl.parent();\n\t\t\t\t\t\tthis.placeEl.closest(opt.itemNodeName).after(this.placeEl);\n\t\t\t\t\t\tif (!parent.children().length) {\n\t\t\t\t\t\t\tthis.unsetParent(parent.parent());\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar isEmpty = false;\n\n\t\t\t// find list item under cursor\n\t\t\tif (!hasPointerEvents) {\n\t\t\t\tthis.dragEl[0].style.visibility = 'hidden';\n\t\t\t}\n\t\t\tthis.pointEl = $(document.elementFromPoint(e.pageX - document.body.scrollLeft, e.pageY - (window.pageYOffset || document.documentElement.scrollTop)));\n\t\t\tif (!hasPointerEvents) {\n\t\t\t\tthis.dragEl[0].style.visibility = 'visible';\n\t\t\t}\n\t\t\tif (this.pointEl.hasClass(opt.handleClass)) {\n\t\t\t\tthis.pointEl = this.pointEl.parent(opt.itemNodeName);\n\t\t\t}\n\t\t\tif (this.pointEl.hasClass(opt.emptyClass)) {\n\t\t\t\tisEmpty = true;\n\t\t\t}\n\t\t\telse if (!this.pointEl.length || !this.pointEl.hasClass(opt.itemClass)) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// find parent list of item under cursor\n\t\t\tvar pointElRoot = this.pointEl.closest('.' + opt.rootClass),\n\t\t\t\tisNewRoot = this.dragRootEl.data('nestable-id') !== pointElRoot.data('nestable-id');\n\n\t\t\t/**\n\t\t\t * move vertical\n\t\t\t */\n\t\t\tif (!mouse.dirAx || isNewRoot || isEmpty) {\n\t\t\t\t// check if groups match if dragging over new root\n\t\t\t\tif (isNewRoot && opt.group !== pointElRoot.data('nestable-group')) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\t// check depth limit\n\t\t\t\tdepth = this.dragDepth - 1 + this.pointEl.parents(opt.listNodeName).length;\n\t\t\t\tif (depth > opt.maxDepth) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar before = e.pageY < (this.pointEl.offset().top + this.pointEl.height() / 2);\n\t\t\t\tparent = this.placeEl.parent();\n\t\t\t\t// if empty create new list to replace empty placeholder\n\t\t\t\tif (isEmpty) {\n\t\t\t\t\tlist = $(document.createElement(opt.listNodeName)).addClass(opt.listClass);\n\t\t\t\t\tlist.append(this.placeEl);\n\t\t\t\t\tthis.pointEl.replaceWith(list);\n\t\t\t\t}\n\t\t\t\telse if (before) {\n\t\t\t\t\tthis.pointEl.before(this.placeEl);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.pointEl.after(this.placeEl);\n\t\t\t\t}\n\t\t\t\tif (!parent.children().length) {\n\t\t\t\t\tthis.unsetParent(parent.parent());\n\t\t\t\t}\n\t\t\t\tif (!this.dragRootEl.find(opt.itemNodeName).length) {\n\t\t\t\t\tthis.dragRootEl.append('<div class=\"' + opt.emptyClass + '\"/>');\n\t\t\t\t}\n\t\t\t\t// parent root list has changed\n\t\t\t\tif (isNewRoot) {\n\t\t\t\t\tthis.dragRootEl = pointElRoot;\n\t\t\t\t\tthis.hasNewRoot = this.el[0] !== this.dragRootEl[0];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t};\n\n\t$.fn.nestable = function (params) {\n\t\tvar lists = this,\n\t\t\tretval = this;\n\n\t\tlists.each(function () {\n\t\t\tvar plugin = $(this).data(\"nestable\");\n\n\t\t\tif (!plugin) {\n\t\t\t\t$(this).data(\"nestable\", new Plugin(this, params));\n\t\t\t\t$(this).data(\"nestable-id\", new Date().getTime());\n\t\t\t} else {\n\t\t\t\tif (typeof params === 'string' && typeof plugin[params] === 'function') {\n\t\t\t\t\tretval = plugin[params]();\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\treturn retval || lists;\n\t};\n\n}(window.jQuery || window.Zepto, window, document));\n });","Magento_Weee/js/regions-tax-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            filterBy: {\n                field: 'country',\n                target: '${ $.parentName }.country:value'\n            }\n        },\n\n        /** @inheritdoc */\n        filter: function () {\n            this._super();\n            this.disableSelect();\n        },\n\n        /**\n         * Disables select if there's no regions/states\n         *\n         * @returns {*} instance - Chainable\n         */\n        disableSelect: function () {\n            var empty = !this.options().length;\n\n            this.disabled(empty);\n\n            if (empty) {\n                this.error('');\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Weee/js/fpt-attribute.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global RegionUpdater */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'mage/adminhtml/form'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.fptAttribute', {\n        /** @inheritdoc */\n        _create: function () {\n            var widget = this;\n\n            this.rowTmpl = mageTemplate(this.element.find('[data-role=\"row-template\"]').html());\n\n            this._initOptionItem();\n\n            if ($(this.options.bundlePriceType).val() === '0') {\n                this.element.hide();\n            }\n\n            $.each(this.options.itemsData, function () {\n                widget.addItem(this);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initOptionItem: function () {\n            var widget = this,\n                isOriginalRequired = $(widget.element).hasClass('required');\n\n            this._on({\n                /**\n                 * Add new tax item.\n                 *\n                 * @param {jQuery.Event} event\n                 */\n                'click [data-action=add-fpt-item]': function (event) {\n                    this.addItem(event);\n                },\n\n                /**\n                 * Delete tax item.\n                 *\n                 * @param {jQuery.Event} event\n                 */\n                'click [data-action=delete-fpt-item]': function (event) {\n                    var parent = $(event.target).closest('[data-role=\"fpt-item-row\"]');\n\n                    parent.find('[data-role=\"delete-fpt-item\"]').val(1);\n                    parent.addClass('ignore-validate').hide();\n                },\n\n                /**\n                 * Change tax item country/state.\n                 *\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                'change [data-role=\"select-country\"]': function (event, data) {\n                    var currentElement = event.target || event.srcElement || event.currentTarget,\n                        parentElement = $(currentElement).closest('[data-role=\"fpt-item-row\"]'),\n                        updater;\n\n                    data = data || {};\n                    updater = new RegionUpdater(\n                        parentElement.find('[data-role=\"select-country\"]').attr('id'), null,\n                        parentElement.find('[data-role=\"select-state\"]').attr('id'),\n                        widget.options.region, 'disable', true\n                    );\n                    updater.update();\n                    //set selected state value if set\n                    if (data.state) {\n                        parentElement.find('[data-role=\"select-state\"]').val(data.state);\n                    }\n\n                    if (!isOriginalRequired && $(widget.element).hasClass('required')) {\n                        $(widget.element).removeClass('required');\n                    }\n                }\n            });\n\n            $(this.options.bundlePriceType).on('change', function (event) {\n                var attributeItems = widget.element.find('[data-role=\"delete-fpt-item\"]');\n\n                if ($(event.target).val() === '0') {\n                    widget.element.hide();\n                    attributeItems.each(function () {\n                        $(this).val(1);\n                    });\n                } else {\n                    widget.element.show();\n                    attributeItems.each(function () {\n                        if ($(this).closest('[data-role=\"fpt-item-row\"]').is(':visible')) {\n                            $(this).val(0);\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Add custom option.\n         *\n         * @param {jQuery.Event} event\n         */\n        addItem: function (event) {\n            var data = {},\n                currentElement = event.target || event.srcElement || event.currentTarget,\n                tmpl;\n\n            if (typeof currentElement !== 'undefined') {\n                data['website_id'] = 0;\n            } else {\n                data = event;\n            }\n\n            data.index = this.element.find('[data-role=\"fpt-item-row\"]').length;\n\n            tmpl = this.rowTmpl({\n                data: data\n            });\n\n            $(tmpl).appendTo(this.element.find('[data-role=\"fpt-item-container\"]'));\n\n            //set selected website_id value if set\n            if (data['website_id']) {\n                this.element.find('[data-role=\"select-website\"][id$=\"_' + data.index + '_website\"]')\n                    .val(data['website_id']);\n            }\n\n            //set selected country value if set\n            if (data.country) {\n                this.element.find('[data-role=\"select-country\"][id$=\"_' + data.index + '_country\"]')\n                    .val(data.country).trigger('change', data);\n            }\n        }\n    });\n\n    return $.mage.fptAttribute;\n});\n","Magento_Weee/js/fpt-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/group',\n    'uiRegistry',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate',\n    'underscore'\n], function (Group, uiRegistry, validation, $t, _) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            showLabel: true,\n            required: false,\n            template: 'ui/group/group',\n            fieldTemplate: 'ui/form/field',\n            breakLine: true,\n            validateWholeGroup: false,\n            additionalClasses: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            validation.addRule('validate-fpt-group', function (value) {\n                if (value.indexOf('?') !== -1) {\n\n                    return false;\n                }\n\n                return true;\n            }, $t(\n                'Set unique country-state combinations within the same fixed product tax. ' +\n                'Verify the combinations and try again.'\n            ));\n\n            this._super();\n        },\n\n        /**\n         *\n         * @private\n         */\n        _handleOptionsAvailability: function () {\n            var parent,\n                dup;\n\n            dup = {};\n            parent = uiRegistry.get(uiRegistry.get(this.parentName).parentName);\n            _.each(parent.elems(), function (elem) {\n                var country,\n                    state,\n                    val,\n                    key;\n\n                country = uiRegistry.get(elem.name + '.countryState.country');\n                state = uiRegistry.get(elem.name + '.countryState.state');\n                val = uiRegistry.get(elem.name + '.countryState.val');\n\n                key = country.value() + (state.value() > 0 ? state.value() : 0);\n                dup[key]++;\n\n                if (!dup[key]) {\n                    dup[key] = 1;\n                    val.value('');\n                } else {\n                    dup[key]++;\n                    val.value(country.value() + '?' + country.name);\n                }\n            });\n        },\n\n        /** @inheritdoc */\n        initElement: function (elem) {\n            var obj;\n\n            obj = this;\n            this._super();\n            elem.on('value', function () {\n                obj._handleOptionsAvailability();\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Weee/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Weee/price/adjustment',\n            dataSource: '${ $.parentName }.provider',\n            //Weee configuration constants can be configured from backend\n            inclFptWithDesc: 1,//show FPT and description\n            inclFpt: 0, //show FPT attribute\n            exclFpt: 2, //do not show FPT\n            bothFptPrices: 3 //show price without FPT and with FPT and with description\n        },\n\n        /**\n         * Get Weee attributes.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeAttributes: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'];\n        },\n\n        /**\n         * Get Weee without Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTax: function (taxAmount) {\n            return taxAmount['amount_excl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithoutTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithoutTax(taxAmount);\n        },\n\n        /**\n         * Get Weee with Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTax: function (taxAmount) {\n            return taxAmount['tax_amount_incl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithTax(taxAmount);\n        },\n\n        /**\n         * Get Weee Tax name.\n         *\n         * @param {String} taxAmount\n         * @return {String} Weee name\n         */\n        getWeeTaxAttributeName: function (taxAmount) {\n            return taxAmount['attribute_code'];\n        },\n\n        /**\n         * Set price type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Check if Weee Tax must be shown.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isShown: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'].length;\n        },\n\n        /**\n         * Get Weee final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustment: function (row) {\n            return row['price_info']['extension_attributes']['weee_adjustment'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeAdjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustmentUnsanitizedHtml: function (row) {\n            return this.getWeeeAdjustment(row);\n        },\n\n        /**\n         * Return whether display setting is to display price including FPT only.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFpt: function () {\n            return +this.source.data.displayWeee === this.inclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * price including FPT and FPT description.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFptDescr: function () {\n            return +this.source.data.displayWeee === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price\n         * excluding FPT but including FPT description and final price.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFptDescr: function () {\n            return +this.source.data.displayWeee === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding FPT.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFpt: function () {\n            return +this.source.data.displayWeee === this.bothFptPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclTax: function () {\n            return +this.source.data.displayTaxes === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPricesTax: function () {\n            return +this.source.data.displayTaxes === this.bothFptPrices;\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryGroupedProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryGroupedProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_Tax/js/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'mage/backend/editablemultiselect'\n]);\n","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * UnsanitizedHtml version of getTax.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTaxUnsanitizedHtml: function (row) {\n            return this.getTax(row);\n        },\n\n        /**\n         * Set price tax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Magefan_Blog/js/post-gallery.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\n/*jshint jquery:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'uiRegistry',\n    'productGallery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget',\n    'baseImage'\n], function ($, _, mageTemplate, registry, productGallery) {\n    'use strict';\n\n    $.widget('mage.productGallery', $.mage.productGallery, {\n        _showDialog: function (imageData) {}\n    });\n\n    return $.mage.productGallery;\n});\n","Magefan_Blog/js/jquery.tagsinput.js":"/*\r\n\r\n\tjQuery Tags Input Plugin 1.3.3\r\n\r\n\tCopyright (c) 2011 XOXCO, Inc\r\n\r\n\tDocumentation for this plugin lives here:\r\n\thttp://xoxco.com/clickable/jquery-tags-input\r\n\r\n\tLicensed under the MIT license:\r\n\thttp://www.opensource.org/licenses/mit-license.php\r\n\r\n\tben@xoxco.com\r\n\r\n*/\r\n\r\n(function($) {\r\n\r\n\tvar delimiter = new Array();\r\n\tvar tags_callbacks = new Array();\r\n\t$.fn.doAutosize = function(o){\r\n\t    var minWidth = $(this).data('minwidth'),\r\n\t        maxWidth = $(this).data('maxwidth'),\r\n\t        val = '',\r\n\t        input = $(this),\r\n\t        testSubject = $('#'+$(this).data('tester_id'));\r\n\r\n\t    if (val === (val = input.val())) {return;}\r\n\r\n\t    // Enter new content into testSubject\r\n\t    var escaped = val.replace(/&/g, '&amp;').replace(/\\s/g,' ').replace(/</g, '&lt;').replace(/>/g, '&gt;');\r\n\t    testSubject.html(escaped);\r\n\t    // Calculate new width + whether to change\r\n\t    var testerWidth = testSubject.width(),\r\n\t        newWidth = (testerWidth + o.comfortZone) >= minWidth ? testerWidth + o.comfortZone : minWidth,\r\n\t        currentWidth = input.width(),\r\n\t        isValidWidthChange = (newWidth < currentWidth && newWidth >= minWidth)\r\n\t                             || (newWidth > minWidth && newWidth < maxWidth);\r\n\r\n\t    // Animate width\r\n\t    if (isValidWidthChange) {\r\n\t        input.width(newWidth);\r\n\t    }\r\n\r\n\r\n  };\r\n  $.fn.resetAutosize = function(options){\r\n    // alert(JSON.stringify(options));\r\n    var minWidth =  $(this).data('minwidth') || options.minInputWidth || $(this).width(),\r\n        maxWidth = $(this).data('maxwidth') || options.maxInputWidth || ($(this).closest('.tagsinput').width() - options.inputPadding),\r\n        val = '',\r\n        input = $(this),\r\n        testSubject = $('<tester/>').css({\r\n            position: 'absolute',\r\n            top: -9999,\r\n            left: -9999,\r\n            width: 'auto',\r\n            fontSize: input.css('fontSize'),\r\n            fontFamily: input.css('fontFamily'),\r\n            fontWeight: input.css('fontWeight'),\r\n            letterSpacing: input.css('letterSpacing'),\r\n            whiteSpace: 'nowrap'\r\n        }),\r\n        testerId = $(this).attr('id')+'_autosize_tester';\r\n    if(! $('#'+testerId).length > 0){\r\n      testSubject.attr('id', testerId);\r\n      testSubject.appendTo('body');\r\n    }\r\n\r\n    input.data('minwidth', minWidth);\r\n    input.data('maxwidth', maxWidth);\r\n    input.data('tester_id', testerId);\r\n    input.css('width', minWidth);\r\n  };\r\n\r\n\t$.fn.addTag = function(value,options) {\r\n\t\t\toptions = jQuery.extend({focus:false,callback:true},options);\r\n\t\t\tthis.each(function() {\r\n\t\t\t\tvar id = $(this).attr('id');\r\n\r\n\t\t\t\tvar tagslist = $(this).val().split(delimiter[id]);\r\n\t\t\t\tif (tagslist[0] == '') {\r\n\t\t\t\t\ttagslist = new Array();\r\n\t\t\t\t}\r\n\r\n\t\t\t\tvalue = jQuery.trim(value);\r\n\r\n\t\t\t\tif (options.unique) {\r\n\t\t\t\t\tvar skipTag = $(this).tagExist(value);\r\n\t\t\t\t\tif(skipTag == true) {\r\n\t\t\t\t\t    //Marks fake input as not_valid to let styling it\r\n    \t\t\t\t    $('#'+id+'_tag').addClass('not_valid');\r\n    \t\t\t\t}\r\n\t\t\t\t} else {\r\n\t\t\t\t\tvar skipTag = false;\r\n\t\t\t\t}\r\n\r\n\t\t\t\tif (value !='' && skipTag != true) {\r\n                    $('<span>').addClass('tag').append(\r\n                        $('<span>').text(value).append('&nbsp;&nbsp;'),\r\n                        $('<a>', {\r\n                            href  : '#',\r\n                            title : 'Removing tag',\r\n                            text  : 'x'\r\n                        }).click(function () {\r\n                            return $('#' + id).removeTag(escape(value));\r\n                        })\r\n                    ).insertBefore('#' + id + '_addTag');\r\n\r\n\t\t\t\t\ttagslist.push(value);\r\n\r\n\t\t\t\t\t$('#'+id+'_tag').val('');\r\n\t\t\t\t\tif (options.focus) {\r\n\t\t\t\t\t\t$('#'+id+'_tag').focus();\r\n\t\t\t\t\t} else {\r\n\t\t\t\t\t\t$('#'+id+'_tag').blur();\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t\t$.fn.tagsInput.updateTagsField(this,tagslist);\r\n\r\n\t\t\t\t\tif (options.callback && tags_callbacks[id] && tags_callbacks[id]['onAddTag']) {\r\n\t\t\t\t\t\tvar f = tags_callbacks[id]['onAddTag'];\r\n\t\t\t\t\t\tf.call(this, value);\r\n\t\t\t\t\t}\r\n\t\t\t\t\tif(tags_callbacks[id] && tags_callbacks[id]['onChange'])\r\n\t\t\t\t\t{\r\n\t\t\t\t\t\tvar i = tagslist.length;\r\n\t\t\t\t\t\tvar f = tags_callbacks[id]['onChange'];\r\n\t\t\t\t\t\tf.call(this, $(this), tagslist[i-1]);\r\n\t\t\t\t\t}\r\n\t\t\t\t}\r\n\r\n\t\t\t});\r\n\r\n\t\t\treturn false;\r\n\t\t};\r\n\r\n\t$.fn.removeTag = function(value) {\r\n\t\t\tvalue = unescape(value);\r\n\t\t\tthis.each(function() {\r\n\t\t\t\tvar id = $(this).attr('id');\r\n\r\n\t\t\t\tvar old = $(this).val().split(delimiter[id]);\r\n\r\n\t\t\t\t$('#'+id+'_tagsinput .tag').remove();\r\n\t\t\t\tstr = '';\r\n\t\t\t\tfor (i=0; i< old.length; i++) {\r\n\t\t\t\t\tif (old[i]!=value) {\r\n\t\t\t\t\t\tstr = str + delimiter[id] +old[i];\r\n\t\t\t\t\t}\r\n\t\t\t\t}\r\n\r\n\t\t\t\t$.fn.tagsInput.importTags(this,str);\r\n\r\n\t\t\t\tif (tags_callbacks[id] && tags_callbacks[id]['onRemoveTag']) {\r\n\t\t\t\t\tvar f = tags_callbacks[id]['onRemoveTag'];\r\n\t\t\t\t\tf.call(this, value);\r\n\t\t\t\t}\r\n\t\t\t});\r\n\r\n\t\t\treturn false;\r\n\t\t};\r\n\r\n\t$.fn.tagExist = function(val) {\r\n\t\tvar id = $(this).attr('id');\r\n\t\tvar tagslist = $(this).val().split(delimiter[id]);\r\n\t\treturn (jQuery.inArray(val, tagslist) >= 0); //true when tag exists, false when not\r\n\t};\r\n\r\n   // clear all existing tags and import new ones from a string\r\n   $.fn.importTags = function(str) {\r\n      var id = $(this).attr('id');\r\n      $('#'+id+'_tagsinput .tag').remove();\r\n      $.fn.tagsInput.importTags(this,str);\r\n   }\r\n\r\n\t$.fn.tagsInput = function(options) {\r\n    var settings = jQuery.extend({\r\n      interactive:true,\r\n      defaultText:'add a tag',\r\n      minChars:0,\r\n      width:'300px',\r\n      height:'100px',\r\n      autocomplete: {selectFirst: false },\r\n      hide:true,\r\n      delimiter: ',',\r\n      unique:true,\r\n      removeWithBackspace:true,\r\n      placeholderColor:'#666666',\r\n      autosize: true,\r\n      comfortZone: 20,\r\n      inputPadding: 6*2\r\n    },options);\r\n\r\n    \tvar uniqueIdCounter = 0;\r\n\r\n\t\tthis.each(function() {\r\n         // If we have already initialized the field, do not do it again\r\n         if (typeof $(this).attr('data-tagsinput-init') !== 'undefined') {\r\n            return;\r\n         }\r\n\r\n         // Mark the field as having been initialized\r\n         $(this).attr('data-tagsinput-init', true);\r\n\r\n\t\t\tif (settings.hide) {\r\n\t\t\t\t$(this).hide();\r\n\t\t\t}\r\n\t\t\tvar id = $(this).attr('id');\r\n\t\t\tif (!id || delimiter[$(this).attr('id')]) {\r\n\t\t\t\tid = $(this).attr('id', 'tags' + new Date().getTime() + (uniqueIdCounter++)).attr('id');\r\n\t\t\t}\r\n\r\n\t\t\tvar data = jQuery.extend({\r\n\t\t\t\tpid:id,\r\n\t\t\t\treal_input: '#'+id,\r\n\t\t\t\tholder: '#'+id+'_tagsinput',\r\n\t\t\t\tinput_wrapper: '#'+id+'_addTag',\r\n\t\t\t\tfake_input: '#'+id+'_tag'\r\n\t\t\t},settings);\r\n\r\n\t\t\tdelimiter[id] = data.delimiter;\r\n\r\n\t\t\tif (settings.onAddTag || settings.onRemoveTag || settings.onChange) {\r\n\t\t\t\ttags_callbacks[id] = new Array();\r\n\t\t\t\ttags_callbacks[id]['onAddTag'] = settings.onAddTag;\r\n\t\t\t\ttags_callbacks[id]['onRemoveTag'] = settings.onRemoveTag;\r\n\t\t\t\ttags_callbacks[id]['onChange'] = settings.onChange;\r\n\t\t\t}\r\n\r\n\t\t\tvar markup = '<div id=\"'+id+'_tagsinput\" class=\"tagsinput\"><div id=\"'+id+'_addTag\">';\r\n\r\n\t\t\tif (settings.interactive) {\r\n\t\t\t\tmarkup = markup + '<input id=\"'+id+'_tag\" value=\"\" data-default=\"'+settings.defaultText+'\" />';\r\n\t\t\t}\r\n\r\n\t\t\tmarkup = markup + '</div><div class=\"tags_clear\"></div></div>';\r\n\r\n\t\t\t$(markup).insertAfter(this);\r\n\r\n\t\t\t$(data.holder).css('width',settings.width);\r\n\t\t\t$(data.holder).css('min-height',settings.height);\r\n\t\t\t$(data.holder).css('height',settings.height);\r\n\r\n\t\t\tif ($(data.real_input).val()!='') {\r\n\t\t\t\t$.fn.tagsInput.importTags($(data.real_input),$(data.real_input).val());\r\n\t\t\t}\r\n\t\t\tif (settings.interactive) {\r\n\t\t\t\t$(data.fake_input).val($(data.fake_input).attr('data-default'));\r\n\t\t\t\t$(data.fake_input).css('color',settings.placeholderColor);\r\n\t\t        $(data.fake_input).resetAutosize(settings);\r\n\r\n\t\t\t\t$(data.holder).bind('click',data,function(event) {\r\n\t\t\t\t\t$(event.data.fake_input).focus();\r\n\t\t\t\t});\r\n\r\n\t\t\t\t$(data.fake_input).bind('focus',data,function(event) {\r\n\t\t\t\t\tif ($(event.data.fake_input).val()==$(event.data.fake_input).attr('data-default')) {\r\n\t\t\t\t\t\t$(event.data.fake_input).val('');\r\n\t\t\t\t\t}\r\n\t\t\t\t\t$(event.data.fake_input).css('color','#000000');\r\n\t\t\t\t});\r\n\r\n\t\t\t\tif (settings.autocomplete_url != undefined) {\r\n\t\t\t\t\tautocomplete_options = {source: settings.autocomplete_url};\r\n\t\t\t\t\tfor (attrname in settings.autocomplete) {\r\n\t\t\t\t\t\tautocomplete_options[attrname] = settings.autocomplete[attrname];\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t\tif (jQuery.Autocompleter !== undefined) {\r\n\t\t\t\t\t\t$(data.fake_input).autocomplete(settings.autocomplete_url, settings.autocomplete);\r\n\t\t\t\t\t\t$(data.fake_input).bind('result',data,function(event,data,formatted) {\r\n\t\t\t\t\t\t\tif (data) {\r\n\t\t\t\t\t\t\t\t$('#'+id).addTag(data[0] + \"\",{focus:true,unique:(settings.unique)});\r\n\t\t\t\t\t\t\t}\r\n\t\t\t\t\t  \t});\r\n\t\t\t\t\t} else if (jQuery.ui.autocomplete !== undefined) {\r\n\t\t\t\t\t\t$(data.fake_input).autocomplete(autocomplete_options);\r\n\t\t\t\t\t\t$(data.fake_input).bind('autocompleteselect',data,function(event,ui) {\r\n\t\t\t\t\t\t\t$(event.data.real_input).addTag(ui.item.value,{focus:true,unique:(settings.unique)});\r\n\t\t\t\t\t\t\treturn false;\r\n\t\t\t\t\t\t});\r\n\t\t\t\t\t}\r\n\r\n\r\n\t\t\t\t} else {\r\n\t\t\t\t\t\t// if a user tabs out of the field, create a new tag\r\n\t\t\t\t\t\t// this is only available if autocomplete is not used.\r\n\t\t\t\t\t\t$(data.fake_input).bind('blur',data,function(event) {\r\n\t\t\t\t\t\t\tvar d = $(this).attr('data-default');\r\n\t\t\t\t\t\t\tif ($(event.data.fake_input).val()!='' && $(event.data.fake_input).val()!=d) {\r\n\t\t\t\t\t\t\t\tif( (event.data.minChars <= $(event.data.fake_input).val().length) && (!event.data.maxChars || (event.data.maxChars >= $(event.data.fake_input).val().length)) )\r\n\t\t\t\t\t\t\t\t\t$(event.data.real_input).addTag($(event.data.fake_input).val(),{focus:true,unique:(settings.unique)});\r\n\t\t\t\t\t\t\t} else {\r\n\t\t\t\t\t\t\t\t$(event.data.fake_input).val($(event.data.fake_input).attr('data-default'));\r\n\t\t\t\t\t\t\t\t$(event.data.fake_input).css('color',settings.placeholderColor);\r\n\t\t\t\t\t\t\t}\r\n\t\t\t\t\t\t\treturn false;\r\n\t\t\t\t\t\t});\r\n\r\n\t\t\t\t}\r\n\t\t\t\t// if user types a default delimiter like comma,semicolon and then create a new tag\r\n\t\t\t\t$(data.fake_input).bind('keypress',data,function(event) {\r\n\t\t\t\t\tif (_checkDelimiter(event)) {\r\n\t\t\t\t\t    event.preventDefault();\r\n\t\t\t\t\t\tif( (event.data.minChars <= $(event.data.fake_input).val().length) && (!event.data.maxChars || (event.data.maxChars >= $(event.data.fake_input).val().length)) )\r\n\t\t\t\t\t\t\t$(event.data.real_input).addTag($(event.data.fake_input).val(),{focus:true,unique:(settings.unique)});\r\n\t\t\t\t\t  \t$(event.data.fake_input).resetAutosize(settings);\r\n\t\t\t\t\t\treturn false;\r\n\t\t\t\t\t} else if (event.data.autosize) {\r\n\t\t\t            $(event.data.fake_input).doAutosize(settings);\r\n\r\n          \t\t\t}\r\n\t\t\t\t});\r\n\t\t\t\t//Delete last tag on backspace\r\n\t\t\t\t// data.removeWithBackspace && $(data.fake_input).bind('keydown', function(event)\r\n\t\t\t\t// {\r\n\t\t\t\t// \tif(event.keyCode == 8 && $(this).val() == '')\r\n\t\t\t\t// \t{\r\n\t\t\t\t// \t\t event.preventDefault();\r\n\t\t\t\t// \t\t var last_tag = $(this).closest('.tagsinput').find('.tag:last').text();\r\n\t\t\t\t// \t\t var id = $(this).attr('id').replace(/_tag$/, '');\r\n\t\t\t\t// \t\t last_tag = last_tag.replace(/[\\s]+x$/, '');\r\n\t\t\t\t// \t\t $('#' + id).removeTag(escape(last_tag));\r\n\t\t\t\t// \t\t $(this).trigger('focus');\r\n\t\t\t\t// \t}\r\n\t\t\t\t// });\r\n\t\t\t\t// $(data.fake_input).blur();\r\n\r\n\t\t\t\t//Removes the not_valid class when user changes the value of the fake input\r\n\t\t\t\tif(data.unique) {\r\n\t\t\t\t    $(data.fake_input).keydown(function(event){\r\n\t\t\t\t        if(event.keyCode == 8 || String.fromCharCode(event.which).match(/\\w+|[\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1,/]+/)) {\r\n\t\t\t\t            $(this).removeClass('not_valid');\r\n\t\t\t\t        }\r\n\t\t\t\t    });\r\n\t\t\t\t}\r\n\t\t\t} // if settings.interactive\r\n\t\t});\r\n\r\n\t\treturn this;\r\n\r\n\t};\r\n\r\n\t$.fn.tagsInput.updateTagsField = function(obj,tagslist) {\r\n\t\tvar id = $(obj).attr('id');\r\n\t\t$(obj).val(tagslist.join(delimiter[id]));\r\n\t};\r\n\r\n\t$.fn.tagsInput.importTags = function(obj,val) {\r\n\t\t$(obj).val('');\r\n\t\tvar id = $(obj).attr('id');\r\n\t\tvar tags = val.split(delimiter[id]);\r\n\t\tfor (i=0; i<tags.length; i++) {\r\n\t\t\t$(obj).addTag(tags[i],{focus:false,callback:false});\r\n\t\t}\r\n\t\tif(tags_callbacks[id] && tags_callbacks[id]['onChange'])\r\n\t\t{\r\n\t\t\tvar f = tags_callbacks[id]['onChange'];\r\n\t\t\tf.call(obj, obj, tags[i]);\r\n\t\t}\r\n\t};\r\n\r\n   /**\r\n     * check delimiter Array\r\n     * @param event\r\n     * @returns {boolean}\r\n     * @private\r\n     */\r\n   var _checkDelimiter = function(event){\r\n      var found = false;\r\n      if (event.which == 13) {\r\n         return true;\r\n      }\r\n\r\n      if (typeof event.data.delimiter === 'string') {\r\n         if (event.which == event.data.delimiter.charCodeAt(0)) {\r\n            found = true;\r\n         }\r\n      } else {\r\n         $.each(event.data.delimiter, function(index, delimiter) {\r\n            if (event.which == delimiter.charCodeAt(0)) {\r\n               found = true;\r\n            }\r\n         });\r\n      }\r\n\r\n      return found;\r\n   }\r\n})(jQuery);\r\n","Magefan_Blog/js/form/element/link.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (AbstractElement) {\n    'use strict';\n\n    return AbstractElement.extend({\n        defaults: {\n            elementTmpl: 'Magefan_Blog/form/element/link'\n        },\n\n        initialize: function () {\n            this._super();\n\n            var value = this.value();\n            this.url = value.url;\n            this.title = value.title;\n            this.text = value.text;\n        },\n\n    });\n});","Magefan_Blog/js/components/new-category.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine([\n    'Magefan_Blog/js/components/new-tag'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': data.model['is_active'],\n                level: data.model['level'],\n                value: data.model['category_id'],\n                label: data.model['title'],\n                parent: data.model['parent_id']\n            };\n        }\n    });\n});\n","Magefan_Blog/js/components/new-tag.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/ui-select'\n], function (_, Select) {\n    'use strict';\n\n    function flatten(a, s, cr)\n    {\n        var i = 0, c;\n        a = _.compact(a);\n        cr = cr || [];\n        for (i; i < a.length; i++) {\n            cr.push(a[i]);\n            if (a[i].hasOwnProperty(s)) {\n                c = a[i][s];\n                delete a[i][s];\n                flatten.call(this, c, s, cr);\n            }\n        }\n        return cr;\n    }\n\n    return Select.extend({\n\n        /**\n         * Parse data and set it to options.\n         *\n         * @param {Object} data - Response data object.\n         * @returns {Object}\n         */\n        setParsed: function (data) {\n            var option = this.parseData(data),\n                copyOptionsTree\n            if (data.error) {\n                return this;\n            }\n\n            this.options([]);\n            if (!option.parent) {\n                this.cacheOptions.tree.push(option);\n                copyOptionsTree = JSON.parse(JSON.stringify(this.cacheOptions.tree));\n                this.cacheOptions.plain = flatten(copyOptionsTree, this.separator);\n                this.options(this.cacheOptions.tree);\n            } else {\n                this.setOption(option);\n            }\n            this.set('newOption', option);\n        },\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': \"1\",\n                level: 0,\n                value: data.model['tag_id'],\n                label: data.model['title'],\n                parent: 0\n            };\n        }\n    });\n});\n","js-cookie/cookie-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-cookie/js.cookie'\n], function ($, cookie) {\n    'use strict';\n\n    window.Cookies = window.Cookies || cookie;\n\n    var config = $.cookie = function (key, value, options) {\n        if (value !== undefined) {\n            options = $.extend({}, config.defaults, options);\n\n            return cookie.set(key, value, options);\n        }\n\n        var result = key ? undefined : {},\n            cookies = document.cookie ? document.cookie.split('; ') : [],\n            i;\n\n        for (i = 0; i < cookies.length; i++) {\n            var parts = cookies[i].split('='),\n                name = config.raw ? parts.shift() : decodeURIComponent(parts.shift()),\n                cookieValue = parts.join('=');\n\n            if (key && key === name) {\n                result = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '));\n                break;\n            }\n\n            if (!key && (cookieValue = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '))) !== undefined) {\n                result[name] = cookieValue;\n            }\n        }\n\n        return result;\n    };\n\n    config.defaults = {};\n\n    $.removeCookie = function (key, options) {\n        if ($.cookie(key) === undefined) {\n            return false;\n        }\n\n        $.cookie(key, '', $.extend({}, options, { expires: -1 }));\n        return !$.cookie(key);\n    };\n});\n","js-cookie/js.cookie.js":"/*! js-cookie v3.0.1 | MIT */\n;\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = global || self, (function () {\n                var current = global.Cookies;\n                var exports = global.Cookies = factory();\n                exports.noConflict = function () { global.Cookies = current; return exports; };\n            }()));\n}(this, (function () { 'use strict';\n\n    /* eslint-disable no-var */\n    function assign (target) {\n        for (var i = 1; i < arguments.length; i++) {\n            var source = arguments[i];\n            for (var key in source) {\n                target[key] = source[key];\n            }\n        }\n        return target\n    }\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n    var defaultConverter = {\n        read: function (value) {\n            if (value[0] === '\"') {\n                value = value.slice(1, -1);\n            }\n            return value.replace(/(%[\\dA-F]{2})+/gi, decodeURIComponent)\n        },\n        write: function (value) {\n            return encodeURIComponent(value).replace(\n                /%(2[346BF]|3[AC-F]|40|5[BDE]|60|7[BCD])/g,\n                decodeURIComponent\n            )\n        }\n    };\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n\n    function init (converter, defaultAttributes) {\n        function set (key, value, attributes) {\n            if (typeof document === 'undefined') {\n                return\n            }\n\n            attributes = assign({}, defaultAttributes, attributes);\n\n            if (typeof attributes.expires === 'number') {\n                attributes.expires = new Date(Date.now() + attributes.expires * 864e5);\n            }\n            if (attributes.expires) {\n                attributes.expires = attributes.expires.toUTCString();\n            }\n\n            key = encodeURIComponent(key)\n                .replace(/%(2[346B]|5E|60|7C)/g, decodeURIComponent)\n                .replace(/[()]/g, escape);\n\n            var stringifiedAttributes = '';\n            for (var attributeName in attributes) {\n                if (!attributes[attributeName]) {\n                    continue\n                }\n\n                stringifiedAttributes += '; ' + attributeName;\n\n                if (attributes[attributeName] === true) {\n                    continue\n                }\n\n                // Considers RFC 6265 section 5.2:\n                // ...\n                // 3.  If the remaining unparsed-attributes contains a %x3B (\";\")\n                //     character:\n                // Consume the characters of the unparsed-attributes up to,\n                // not including, the first %x3B (\";\") character.\n                // ...\n                stringifiedAttributes += '=' + attributes[attributeName].split(';')[0];\n            }\n\n            return (document.cookie =\n                key + '=' + converter.write(value, key) + stringifiedAttributes)\n        }\n\n        function get (key) {\n            if (typeof document === 'undefined' || (arguments.length && !key)) {\n                return\n            }\n\n            // To prevent the for loop in the first place assign an empty array\n            // in case there are no cookies at all.\n            var cookies = document.cookie ? document.cookie.split('; ') : [];\n            var jar = {};\n            for (var i = 0; i < cookies.length; i++) {\n                var parts = cookies[i].split('=');\n                var value = parts.slice(1).join('=');\n\n                try {\n                    var foundKey = decodeURIComponent(parts[0]);\n                    jar[foundKey] = converter.read(value, foundKey);\n\n                    if (key === foundKey) {\n                        break\n                    }\n                } catch (e) {}\n            }\n\n            return key ? jar[key] : jar\n        }\n\n        return Object.create(\n            {\n                set: set,\n                get: get,\n                remove: function (key, attributes) {\n                    set(\n                        key,\n                        '',\n                        assign({}, attributes, {\n                            expires: -1\n                        })\n                    );\n                },\n                withAttributes: function (attributes) {\n                    return init(this.converter, assign({}, this.attributes, attributes))\n                },\n                withConverter: function (converter) {\n                    return init(assign({}, this.converter, converter), this.attributes)\n                }\n            },\n            {\n                attributes: { value: Object.freeze(defaultAttributes) },\n                converter: { value: Object.freeze(converter) }\n            }\n        )\n    }\n\n    var api = init(defaultConverter, { path: '/' });\n    /* eslint-enable no-var */\n\n    return api;\n\n})));\n","Magento_Swatches/js/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n *  @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'prototype',\n    'validation'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var swatchOptionTextDefaultInputType = 'radio',\n            swatchTextOption = {\n                table: $('swatch-text-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                isReadOnly: config.isReadOnly,\n                template: mageTemplate('#swatch-text-row-template'),\n\n                /**\n                 * Add option\n                 *\n                 * @param {Object} data\n                 * @param {Object} render\n                 */\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1\n                        };\n                        isNewOption = true;\n                    }\n\n                    if (!data.intype) {\n                        data.intype = swatchOptionTextDefaultInputType;\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                    }\n                },\n\n                /**\n                 * Remove option\n                 *\n                 * @param {Object} event\n                 */\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n                },\n\n                /**\n                 * Update items count field\n                 */\n                updateItemsCountField: function () {\n                    $('swatch-text-option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n\n                /**\n                 * Enable delete button for new option\n                 *\n                 * @param {String} id\n                 */\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_swatch_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n\n                /**\n                 * Bind remove button\n                 */\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-text-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n\n                /**\n                 * Render action\n                 */\n                render: function () {\n                    Element.insert($$('[data-role=swatch-text-options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n\n                /**\n                 * Render action with delay (performance fix)\n                 *\n                 * @param {Object} data\n                 * @param {Number} from\n                 * @param {Number} step\n                 * @param {Number} delay\n                 * @returns {Boolean}\n                 */\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n\n                /**\n                 * Ignore validate action\n                 */\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                }\n            };\n\n        if ($('add_new_swatch_text_option_button')) {\n            Event.observe(\n                'add_new_swatch_text_option_button',\n                'click',\n                swatchTextOption.add.bind(swatchTextOption, true)\n            );\n        }\n        jQuery('#swatch-text-options-panel').on('render', function () {\n            swatchTextOption.ignoreValidate();\n\n            if (swatchTextOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            swatchTextOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            swatchTextOption.bindRemoveButtons();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=swatch-text-options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n\n                    /**\n                     * Update components\n                     */\n                    update: function () {\n                        $('[data-role=swatch-text-options-container] [data-role=order]').each(\n                            function (index, element) {\n                                $(element).val(index + 1);\n                            }\n                        );\n                    }\n                });\n            });\n        }\n\n        jQuery(function () {\n            if (jQuery('#frontend_input').val() !== 'swatch_text') {\n                jQuery('.swatch-text-field-0').removeClass('required-option');\n            }\n        });\n\n        window.swatchTextOption = swatchTextOption;\n        window.swatchOptionTextDefaultInputType = swatchOptionTextDefaultInputType;\n\n        rg.set('swatch-text-options-panel', swatchTextOption);\n    };\n});\n","Magento_Swatches/js/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/prompt',\n    'uiRegistry',\n    'collapsable'\n], function ($, alert, prompt, rg) {\n    'use strict';\n\n    return function (optionConfig) {\n        var activePanelClass = 'selected-type-options',\n            swatchProductAttributes = {\n                frontendInput: $('#frontend_input'),\n                isFilterable: $('#is_filterable'),\n                isFilterableInSearch: $('#is_filterable_in_search'),\n                backendType: $('#backend_type'),\n                usedForSortBy: $('#used_for_sort_by'),\n                frontendClass: $('#frontend_class'),\n                isWysiwygEnabled: $('#is_wysiwyg_enabled'),\n                isHtmlAllowedOnFront: $('#is_html_allowed_on_front'),\n                isRequired: $('#is_required'),\n                isUnique: $('#is_unique'),\n                defaultValueText: $('#default_value_text'),\n                defaultValueTextarea: $('#default_value_textarea'),\n                defaultValueDate: $('#default_value_date'),\n                defaultValueDatetime: $('#default_value_datetime'),\n                defaultValueYesno: $('#default_value_yesno'),\n                isGlobal: $('#is_global'),\n                useProductImageForSwatch: $('#use_product_image_for_swatch'),\n                updateProductPreviewImage: $('#update_product_preview_image'),\n                usedInProductListing: $('#used_in_product_listing'),\n                isVisibleOnFront: $('#is_visible_on_front'),\n                position: $('#position'),\n                attrTabsFront: $('#product_attribute_tabs_front'),\n\n                /**\n                 * @returns {*|jQuery|HTMLElement}\n                 */\n                get tabsFront() {\n                    return this.attrTabsFront.length ? this.attrTabsFront.closest('li') : $('#front_fieldset-wrapper');\n                },\n                selectFields: ['boolean', 'select', 'multiselect', 'price', 'swatch_text', 'swatch_visual'],\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                toggleApplyVisibility: function (select) {\n                    if ($(select).val() === 1) {\n                        $(select).next('select').removeClass('no-display');\n                        $(select).next('select').removeClass('ignore-validate');\n                    } else {\n                        $(select).next('select').addClass('no-display');\n                        $(select).next('select').addClass('ignore-validate');\n                        $(select).next('select option:selected').each(function () {\n                            this.selected = false;\n                        });\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                checkOptionsPanelVisibility: function () {\n                    var selectOptionsPanel = $('#manage-options-panel'),\n                        visualOptionsPanel = $('#swatch-visual-options-panel'),\n                        textOptionsPanel = $('#swatch-text-options-panel');\n\n                    this._hidePanel(selectOptionsPanel);\n                    this._hidePanel(visualOptionsPanel);\n                    this._hidePanel(textOptionsPanel);\n\n                    switch (this.frontendInput.val()) {\n                        case 'swatch_visual':\n                            this._showPanel(visualOptionsPanel);\n                            break;\n\n                        case 'swatch_text':\n                            this._showPanel(textOptionsPanel);\n                            break;\n\n                        case 'select':\n                        case 'multiselect':\n                            this._showPanel(selectOptionsPanel);\n                            break;\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                bindAttributeInputType: function () {\n                    this.checkOptionsPanelVisibility();\n                    this.switchDefaultValueField();\n\n                    if (!~$.inArray(this.frontendInput.val(), this.selectFields)) {\n                        // not in array\n                        this.isFilterable.selectedIndex = 0;\n                        this._disable(this.isFilterable);\n                        this._disable(this.isFilterableInSearch);\n                    } else {\n                        // in array\n                        this._enable(this.isFilterable);\n                        this._enable(this.isFilterableInSearch);\n                        this.backendType.val('int');\n                    }\n\n                    if (this.frontendInput.val() === 'multiselect' ||\n                        this.frontendInput.val() === 'gallery' ||\n                        this.frontendInput.val() === 'textarea'\n                    ) {\n                        this._disable(this.usedForSortBy);\n                    } else {\n                        this._enable(this.usedForSortBy);\n                    }\n\n                    if (this.frontendInput.val() === 'swatch_text') {\n                        $('.swatch-text-field-0').addClass('required-option');\n                    } else {\n                        $('.swatch-text-field-0').removeClass('required-option');\n                    }\n\n                    this.setRowVisibility(this.isWysiwygEnabled, false);\n                    this.setRowVisibility(this.isHtmlAllowedOnFront, false);\n\n                    switch (this.frontendInput.val()) {\n                        case 'textarea':\n                            this.setRowVisibility(this.isWysiwygEnabled, true);\n\n                            if (this.isWysiwygEnabled.val() === '0') {\n                                this._enable(this.isHtmlAllowedOnFront);\n                            }\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                            break;\n\n                        case 'text':\n                            this.setRowVisibility(this.isHtmlAllowedOnFront, true);\n                            this._enable(this.frontendClass);\n                            break;\n\n                        case 'select':\n                        case 'multiselect':\n                            this.setRowVisibility(this.isHtmlAllowedOnFront, true);\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                            break;\n                        default:\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                    }\n\n                    this.switchIsFilterable();\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                switchIsFilterable: function () {\n                    if (this.isFilterable.selectedIndex === 0) {\n                        this._disable(this.position);\n                    } else {\n                        this._enable(this.position);\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                switchDefaultValueField: function () {\n                    var currentValue = this.frontendInput.val(),\n                        defaultValueTextVisibility = false,\n                        defaultValueTextareaVisibility = false,\n                        defaultValueDateVisibility = false,\n                        defaultValueDatetimeVisibility = false,\n                        defaultValueYesnoVisibility = false,\n                        scopeVisibility = true,\n                        useProductImageForSwatch = false,\n                        defaultValueUpdateImage = false,\n                        optionDefaultInputType = '',\n                        isFrontTabHidden = false,\n                        thing = this;\n\n                    if (!this.frontendInput.length) {\n                        return;\n                    }\n\n                    switch (currentValue) {\n                        case 'select':\n                            optionDefaultInputType = 'radio';\n                            break;\n\n                        case 'multiselect':\n                            optionDefaultInputType = 'checkbox';\n                            break;\n\n                        case 'date':\n                            defaultValueDateVisibility = true;\n                            break;\n\n                        case 'datetime':\n                            defaultValueDatetimeVisibility = true;\n                            break;\n\n                        case 'boolean':\n                            defaultValueYesnoVisibility = true;\n                            break;\n\n                        case 'textarea':\n                        case 'texteditor':\n                            defaultValueTextareaVisibility = true;\n                            break;\n\n                        case 'media_image':\n                            defaultValueTextVisibility = false;\n                            break;\n\n                        case 'price':\n                            scopeVisibility = false;\n                            break;\n\n                        case 'swatch_visual':\n                            useProductImageForSwatch = true;\n                            defaultValueUpdateImage = true;\n                            defaultValueTextVisibility = false;\n                            break;\n\n                        case 'swatch_text':\n                            useProductImageForSwatch = false;\n                            defaultValueUpdateImage = true;\n                            defaultValueTextVisibility = false;\n                            break;\n                        default:\n                            defaultValueTextVisibility = true;\n                            break;\n                    }\n\n                    delete optionConfig.hiddenFields['swatch_visual'];\n                    delete optionConfig.hiddenFields['swatch_text'];\n\n                    if (currentValue === 'media_image') {\n                        this.tabsFront.hide();\n                        this.setRowVisibility(this.isRequired, false);\n                        this.setRowVisibility(this.isUnique, false);\n                        this.setRowVisibility(this.frontendClass, false);\n                    } else if (optionConfig.hiddenFields[currentValue]) {\n                        $.each(optionConfig.hiddenFields[currentValue], function (key, option) {\n                            switch (option) {\n                                case '_front_fieldset':\n                                    thing.tabsFront.hide();\n                                    isFrontTabHidden = true;\n                                    break;\n\n                                case '_default_value':\n                                    defaultValueTextVisibility = false;\n                                    defaultValueTextareaVisibility = false;\n                                    defaultValueDateVisibility = false;\n                                    defaultValueDatetimeVisibility = false;\n                                    defaultValueYesnoVisibility = false;\n                                    break;\n\n                                case '_scope':\n                                    scopeVisibility = false;\n                                    break;\n                                default:\n                                    thing.setRowVisibility($('#' + option), false);\n                            }\n                        });\n\n                        if (!isFrontTabHidden) {\n                            thing.tabsFront.show();\n                        }\n\n                    } else {\n                        this.tabsFront.show();\n                        this.showDefaultRows();\n                    }\n\n                    this.setRowVisibility(this.defaultValueText, defaultValueTextVisibility);\n                    this.setRowVisibility(this.defaultValueTextarea, defaultValueTextareaVisibility);\n                    this.setRowVisibility(this.defaultValueDate, defaultValueDateVisibility);\n                    this.setRowVisibility(this.defaultValueDatetime, defaultValueDatetimeVisibility);\n                    this.setRowVisibility(this.defaultValueYesno, defaultValueYesnoVisibility);\n                    this.setRowVisibility(this.isGlobal, scopeVisibility);\n\n                    /* swatch attributes */\n                    this.setRowVisibility(this.useProductImageForSwatch, useProductImageForSwatch);\n                    this.setRowVisibility(this.updateProductPreviewImage, defaultValueUpdateImage);\n\n                    $('input[name=\\'default[]\\']').each(function () {\n                        $(this).attr('type', optionDefaultInputType);\n                    });\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                showDefaultRows: function () {\n                    this.setRowVisibility(this.isRequired, true);\n                    this.setRowVisibility(this.isUnique, true);\n                    this.setRowVisibility(this.frontendClass, true);\n                },\n\n                /**\n                 * @param {Object} el\n                 * @param {Boolean} isVisible\n                 * @this {swatchProductAttributes}\n                 */\n                setRowVisibility: function (el, isVisible) {\n                    if (isVisible) {\n                        el.show();\n                        el.closest('.field').show();\n                    } else {\n                        el.hide();\n                        el.closest('.field').hide();\n                    }\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _disable: function (el) {\n                    el.attr('disabled', 'disabled');\n                },\n\n                /**\n                 * @param {jQuery} el\n                 * @this {swatchProductAttributes}\n                 */\n                _enable: function (el) {\n                    if (!el.attr('readonly')) {\n                        el.prop('disabled', false);\n                    }\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _showPanel: function (el) {\n                    el.closest('.fieldset').show();\n                    el.addClass(activePanelClass);\n                    this._render(el.attr('id'));\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _hidePanel: function (el) {\n                    el.closest('.fieldset').hide();\n                    el.removeClass(activePanelClass);\n                },\n\n                /**\n                 * @param {String} id\n                 * @this {swatchProductAttributes}\n                 */\n                _render: function (id) {\n                    rg.get(id, function () {\n                        $('#' + id).trigger('render');\n                    });\n                },\n\n                /**\n                 * @param {String} promptMessage\n                 * @this {swatchProductAttributes}\n                 */\n                saveAttributeInNewSet: function (promptMessage) {\n\n                    prompt({\n                        content: promptMessage,\n                        actions: {\n\n                            /**\n                             * @param {String} val\n                             * @this {actions}\n                             */\n                            confirm: function (val) {\n                                var rules = ['required-entry', 'validate-no-html-tags'],\n                                    newAttributeSetNameInputId = $('#new_attribute_set_name'),\n                                    editForm = $('#edit_form'),\n                                    newAttributeSetName = val,\n                                    i;\n\n                                if (!newAttributeSetName) {\n                                    return;\n                                }\n\n                                for (i = 0; i < rules.length; i++) {\n                                    if (!$.validator.methods[rules[i]](newAttributeSetName)) {\n                                        alert({\n                                            content: $.validator.messages[rules[i]]\n                                        });\n\n                                        return;\n                                    }\n                                }\n\n                                if (newAttributeSetNameInputId.length) {\n                                    newAttributeSetNameInputId.val(newAttributeSetName);\n                                } else {\n                                    editForm.append(new Element('input', {\n                                            type: 'hidden',\n                                            id: newAttributeSetNameInputId,\n                                            name: 'new_attribute_set_name',\n                                            value: newAttributeSetName\n                                        })\n                                    );\n                                }\n                                // Temporary solution will replaced after refactoring of attributes functionality\n                                editForm.triggerHandler('save');\n                            }\n                        }\n                    });\n                }\n            };\n\n        $(function () {\n            var editForm = $('#edit_form'),\n                swatchVisualPanel = $('#swatch-visual-options-panel'),\n                swatchTextPanel = $('#swatch-text-options-panel'),\n                tableBody = $(),\n                activePanel = $();\n\n            $('#frontend_input').on('change', function () {\n                swatchProductAttributes.bindAttributeInputType();\n            });\n            $('#is_filterable').on('change', function () {\n                swatchProductAttributes.switchIsFilterable();\n            });\n\n            swatchProductAttributes.bindAttributeInputType();\n\n            // @todo: refactor collapsible component\n            $('.attribute-popup .collapse, [data-role=\"advanced_fieldset-content\"]')\n                .collapsable()\n                .collapse('hide');\n\n            editForm.on('beforeSubmit', function () {\n                var optionContainer, optionsValues;\n\n                activePanel = swatchTextPanel.hasClass(activePanelClass) ? swatchTextPanel : swatchVisualPanel;\n                optionContainer = activePanel.find('table tbody');\n\n                if (activePanel.hasClass(activePanelClass)) {\n                    optionsValues = $.map(\n                        optionContainer.find('tr'),\n                        function (row) {\n                            return $(row).find('input, select, textarea').serialize();\n                        }\n                    );\n                    $('<input>')\n                        .attr({\n                            type: 'hidden',\n                            name: 'serialized_options'\n                        })\n                        .val(JSON.stringify(optionsValues))\n                        .prependTo(editForm);\n                }\n\n                tableBody = optionContainer.detach();\n            });\n\n            editForm.on('afterValidate.error highlight.validate', function () {\n                if (activePanel.hasClass(activePanelClass)) {\n                    activePanel.find('table').append(tableBody);\n                    $('input[name=\"serialized_options\"]').remove();\n                }\n            });\n        });\n\n        window.saveAttributeInNewSet = swatchProductAttributes.saveAttributeInNewSet;\n        window.toggleApplyVisibility = swatchProductAttributes.toggleApplyVisibility;\n    };\n});\n","Magento_Swatches/js/visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/colorpicker/js/colorpicker',\n    'prototype',\n    'jquery/ui',\n    'validation'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var swatchOptionVisualDefaultInputType = 'radio',\n            swatchVisualOption = {\n                table: $('swatch-visual-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                isReadOnly: config.isReadOnly,\n                template: mageTemplate('#swatch-visual-row-template'),\n\n                /**\n                 * Add new option using template\n                 *\n                 * @param {Object} data\n                 * @param {Object} render\n                 */\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1,\n                            'empty_class': 'unavailable'\n                        };\n                        isNewOption = true;\n                    } else if (data.defaultswatch0 === '') {\n                        data['empty_class'] = 'unavailable';\n                    }\n\n                    if (!data.intype) {\n                        data.intype = swatchOptionVisualDefaultInputType;\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                    }\n                },\n\n                /**\n                 * ColorPicker initialization process\n                 */\n                initColorPicker: function () {\n                    var element = this,\n                        hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                    jQuery(this).ColorPicker({\n\n                        /**\n                         * ColorPicker onShow action\n                         */\n                        onShow: function () {\n                            var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                                menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                            menu.hide();\n                            jQuery(element).ColorPickerSetColor(color);\n                        },\n\n                        /**\n                         * ColorPicker onSubmit action\n                         *\n                         * @param {String} hsb\n                         * @param {String} hex\n                         * @param {String} rgb\n                         * @param {String} el\n                         */\n                        onSubmit: function (hsb, hex, rgb, el) {\n                            var container = jQuery(el).parent().parent().prev();\n\n                            jQuery(el).ColorPickerHide();\n                            container.parent().removeClass('unavailable');\n                            container.prev('input').val('#' + hex);\n                            container.css('background', '#' + hex);\n                        }\n                    });\n\n                    if (hiddenColorPicker) {\n                        jQuery(this).ColorPickerShow();\n                    }\n                },\n\n                /**\n                 * Remove action\n                 *\n                 * @param {Object} event\n                 */\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n                },\n\n                /**\n                 * Update items count field\n                 */\n                updateItemsCountField: function () {\n                    $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n\n                /**\n                 * Enable delete button for new option\n                 *\n                 * @param {String} id\n                 */\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_swatch_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n\n                /**\n                 * Bind remove button\n                 */\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-visual-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n\n                /**\n                 * Render options\n                 */\n                render: function () {\n                    Element.insert($$('[data-role=swatch-visual-options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n\n                /**\n                 * Render elements with delay (performance fix)\n                 *\n                 * @param {Object} data\n                 * @param {Number} from\n                 * @param {Number} step\n                 * @param {Number} delay\n                 * @returns {Boolean}\n                 */\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n\n                /**\n                 * Ignore validate action\n                 */\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                }\n            };\n\n        if ($('add_new_swatch_visual_option_button')) {\n            Event.observe(\n                'add_new_swatch_visual_option_button',\n                'click',\n                swatchVisualOption.add.bind(swatchVisualOption, {}, true)\n            );\n        }\n\n        jQuery('#swatch-visual-options-panel').on('render', function () {\n            swatchVisualOption.ignoreValidate();\n\n            if (swatchVisualOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            swatchVisualOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            swatchVisualOption.bindRemoveButtons();\n            jQuery('#swatch-visual-options-panel').on(\n                'click',\n                '.colorpicker_handler',\n                swatchVisualOption.initColorPicker\n            );\n        });\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=swatch-visual-options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n\n                    /**\n                     * Update component\n                     */\n                    update: function () {\n                        $('[data-role=swatch-visual-options-container] [data-role=order]').each(\n                            function (index, element) {\n                                $(element).val(index + 1);\n                            }\n                        );\n                    }\n                });\n            });\n        }\n\n        window.swatchVisualOption = swatchVisualOption;\n        window.swatchOptionVisualDefaultInputType = swatchOptionVisualDefaultInputType;\n\n        rg.set('swatch-visual-options-panel', swatchVisualOption);\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe></iframe>', {\n                        id:  'upload_iframe',\n                        name: 'upload_iframe'\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form></form>', {\n                        id: 'swatch_form_image_upload',\n                        name: 'swatch_form_image_upload',\n                        target: 'upload_iframe',\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: config.uploadActionUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var container = $('#' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        container.prev('input').val(imageParams['file_path']);\n                        container.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        container.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.on('load', iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(document).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).attr('id'));\n                swatchComponents.inputFile.trigger('click');\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(document).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('');\n                optionPanel.children('.swatch_window').css('background', '');\n\n                optionPanel.addClass('unavailable');\n\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(document).on('click', '.swatches-visual-col', function () {\n                var currentElement = $(this).find('.swatch_sub-menu_container');\n\n                jQuery('.swatch_sub-menu_container').not(currentElement).hide();\n                currentElement.toggle();\n            });\n        });\n    };\n});\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/smart-keyboard-handler',\n    'mage/translate',\n    'priceUtils',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'mage/validation/validation'\n], function ($, _, mageTemplate, keyboardHandler, $t, priceUtils) {\n    'use strict';\n\n    /**\n     * Extend form validation to support swatch accessibility\n     */\n    $.widget('mage.validation', $.mage.validation, {\n        /**\n         * Handle form with swatches validation. Focus on first invalid swatch block.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var swatchWrapper, firstActive, swatches, swatch, successList, errorList, firstSwatch;\n\n            this._superApply(arguments);\n\n            swatchWrapper = '.swatch-attribute-options';\n            swatches = $(event.target).find(swatchWrapper);\n\n            if (!swatches.length) {\n                return;\n            }\n\n            swatch = '.swatch-attribute';\n            firstActive = $(validation.errorList[0].element || []);\n            successList = validation.successList;\n            errorList = validation.errorList;\n            firstSwatch = $(firstActive).parent(swatch).find(swatchWrapper);\n\n            keyboardHandler.focus(swatches);\n\n            $.each(successList, function (index, item) {\n                $(item).parent(swatch).find(swatchWrapper).attr('aria-invalid', false);\n            });\n\n            $.each(errorList, function (index, item) {\n                $(item.element).parent(swatch).find(swatchWrapper).attr('aria-invalid', true);\n            });\n\n            if (firstSwatch.length) {\n                $(firstSwatch).trigger('focus');\n            }\n        }\n    });\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - data-option-type (integer, 0-3)\n     *  - data-option-label (string)\n     *  - data-option-tooltip-thumb\n     *  - data-option-tooltip-value\n     *  - data-thumb-width\n     *  - data-thumb-height\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.data('option-type'), 10),\n                label = $this.data('option-label'),\n                thumb = $this.data('option-tooltip-thumb'),\n                value = $this.data('option-tooltip-value'),\n                width = $this.data('thumb-width'),\n                height = $this.data('thumb-height'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.length) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.on('mouseenter', function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial',\n                                    'width': width + 'px',\n                                    'height': height + 'px'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            });\n\n            $this.on('mouseleave', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // selector of category product tile wrapper\n            selectorProductTile: '.product-item',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // control label id\n            controlLabelId: '',\n\n            // text for more button\n            moreButtonText: $t('More'),\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            // Use ajax to get image data\n            useAjax: false,\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n\n            // whether swatches are rendered in product list or on product page\n            inProductList: false,\n\n            // sly-old-price block selector\n            slyOldPriceSelector: '.sly-old-price',\n\n            // tier prise selectors start\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: '',\n            // tier prise selectors end\n\n            // A price label selector\n            normalPriceLabelSelector: '.product-info-main .normal-price .price-label',\n            qtyInfo: '#qty'\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns int|null\n         */\n        getProduct: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) ? products[0] : null;\n        },\n\n        /**\n         * Get chosen product id\n         *\n         * @returns int|null\n         */\n        getProductId: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) && products.length === 1 ? products[0] : null;\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            // Don't render the same set of swatches twice\n            if ($(this.element).attr('data-rendered')) {\n                return;\n            }\n\n            $(this.element).attr('data-rendered', true);\n\n            if (_.isEmpty(this.options.jsonConfig.images)) {\n                this.options.useAjax = true;\n                // creates debounced variant of _LoadProductMedia()\n                // to use it in events handlers instead of _LoadProductMedia()\n                this._debouncedLoadProductMedia = _.debounce(this._LoadProductMedia.bind(this), 500);\n            }\n\n            this.options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                // store unsorted attributes\n                this.options.jsonConfig.mappedAttributes = _.clone(this.options.jsonConfig.attributes);\n                this._sortAttributes();\n                this._RenderControls();\n                this._setPreSelectedGallery();\n                $(this.element).trigger('swatch.initialized');\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return parseInt(attribute.position, 10);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                productData = this._determineProductData(),\n                $main = productData.isInProductView ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (productData.isInProductView) {\n                gallery.data('gallery') ?\n                    this._onGalleryLoaded(gallery) :\n                    gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n\n            this.productForm = this.element.parents(this.options.selectorProductTile).find('form:first');\n            this.inProductList = this.productForm.length > 0;\n            $(this.options.qtyInfo).on('input', this._onQtyChanged.bind(this));\n        },\n\n        /**\n         * Determine product id and related data\n         *\n         * @returns {{productId: *, isInProductView: bool}}\n         * @private\n         */\n        _determineProductData: function () {\n            // Check if product is in a list of products.\n            var productId,\n                isInProductView = false;\n\n            productId = this.element.parents('.product-item-details')\n                    .find('.price-box.price-final_price').attr('data-product-id');\n\n            if (!productId) {\n                // Check individual product.\n                productId = $('[name=product]').val();\n                isInProductView = productId > 0;\n            }\n\n            return {\n                productId: productId,\n                isInProductView: isInProductView\n            };\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText,\n                showTooltip = this.options.showTooltip;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    controlLabelId = 'option-label-' + item.code + '-' + item.id,\n                    options = $widget._RenderSwatchOptions(item, controlLabelId),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    listLabel = '',\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span id=\"' + controlLabelId + '\" class=\"' + classes.attributeLabelClass + '\">' +\n                        $('<i></i>').text(item.label).html() +\n                        '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.inProductList) {\n                    $widget.productForm.append(input);\n                    input = '';\n                    listLabel = 'aria-label=\"' + $('<i></i>').text(item.label).html() + '\"';\n                } else {\n                    listLabel = 'aria-labelledby=\"' + controlLabelId + '\"';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code + '\" ' +\n                         'data-attribute-code=\"' + item.code + '\" ' +\n                         'data-attribute-id=\"' + item.id + '\">' +\n                        label +\n                        '<div aria-activedescendant=\"\" ' +\n                             'tabindex=\"0\" ' +\n                             'aria-invalid=\"false\" ' +\n                             'aria-required=\"true\" ' +\n                             'role=\"listbox\" ' + listLabel +\n                             'class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: this.products\n                        };\n                    }\n                });\n            });\n\n            if (showTooltip === 1) {\n                // Connect Tooltip\n                container\n                    .find('[data-option-type=\"1\"], [data-option-type=\"2\"],' +\n                        ' [data-option-type=\"0\"], [data-option-type=\"3\"]')\n                    .SwatchRendererTooltip();\n            }\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        disableSwatchForOutOfStockProducts: function () {\n            let $widget = this, container = this.element;\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                let item = this;\n\n                if ($widget.options.jsonConfig.canDisplayShowOutOfStockStatus) {\n                    let salableProducts = $widget.options.jsonConfig.salable[item.id],\n                        swatchOptions = $(container).find(`[data-attribute-id='${item.id}']`).find('.swatch-option');\n\n                    swatchOptions.each(function (key, value) {\n                        let optionId = $(value).data('option-id');\n\n                        if (!salableProducts.hasOwnProperty(optionId)) {\n                            $(value).attr('disabled', true).addClass('disabled');\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @param {String} controlId\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config, controlId) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                sizeConfig = this.options.jsonSwatchImageSizeConfig,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function (index) {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    width,\n                    height,\n                    attr,\n                    swatchImageWidth,\n                    swatchImageHeight;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\"><span>' + moreText + '</span></a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ?\n                    $('<i></i>').text(optionConfig[id].value).html() : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;\n                height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;\n                label = this.label ? $('<i></i>').text(this.label).html() : '';\n                attr =\n                    ' id=\"' + controlId + '-item-' + id + '\"' +\n                    ' index=\"' + index + '\"' +\n                    ' aria-checked=\"false\"' +\n                    ' aria-describedby=\"' + controlId + '\"' +\n                    ' tabindex=\"0\"' +\n                    ' data-option-type=\"' + type + '\"' +\n                    ' data-option-id=\"' + id + '\"' +\n                    ' data-option-label=\"' + label + '\"' +\n                    ' aria-label=\"' + label + '\"' +\n                    ' role=\"option\"' +\n                    ' data-thumb-width=\"' + width + '\"' +\n                    ' data-thumb-height=\"' + height + '\"';\n\n                attr += thumb !== '' ? ' data-option-tooltip-thumb=\"' + thumb + '\"' : '';\n                attr += value !== '' ? ' data-option-tooltip-value=\"' + value + '\"' : '';\n\n                swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;\n                swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        ' style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        ' style=\"background: url(' + value + ') no-repeat center; background-size: initial;width:' +\n                        swatchImageWidth + 'px; height:' + swatchImageHeight + 'px\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Default\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" data-option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" data-option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required: true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"false\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n            var $widget = this,\n                options = this.options.classes,\n                target;\n\n            $widget.element.on('click', '.' + options.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + options.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + options.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n\n            $widget.element.on('keydown', function (e) {\n                if (e.which === 13) {\n                    target = $(e.target);\n\n                    if (target.is('.' + options.optionClass)) {\n                        return $widget._OnClick(target, $widget);\n                    } else if (target.is('.' + options.selectClass)) {\n                        return $widget._OnChange(target, $widget);\n                    } else if (target.is('.' + options.moreButton)) {\n                        e.preventDefault();\n\n                        return $widget._OnMoreClick(target);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Load media gallery using ajax or json config.\n         *\n         * @private\n         */\n        _loadMedia: function () {\n            var $main = this.inProductList ?\n                    this.element.parents('.product-item-info') :\n                    this.element.parents('.column.main'),\n                images;\n\n            if (this.options.useAjax) {\n                this._debouncedLoadProductMedia();\n            }  else {\n                images = this.options.jsonConfig.images[this.getProduct()];\n\n                if (!images) {\n                    images = this.options.mediaGalleryInitial;\n                }\n                this.updateBaseImage(this._sortImages(images), $main, !this.inProductList);\n            }\n        },\n\n        /**\n         * Sorting images array\n         *\n         * @private\n         */\n        _sortImages: function (images) {\n            return _.sortBy(images, function (image) {\n                return parseInt(image.position, 10);\n            });\n        },\n\n        /**\n         * Event for swatch options\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnClick: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                $wrapper = $this.parents('.' + $widget.options.classes.attributeOptionsWrapper),\n                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput),\n                checkAdditionalData = JSON.parse(this.options.jsonSwatchConfig[attributeId]['additional_data']),\n                $priceBox = $widget.element.parents($widget.options.selectorProduct)\n                    .find(this.options.selectorProductPrice);\n\n            if ($widget.inProductList) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.hasClass('disabled')) {\n                return;\n            }\n\n            if ($this.hasClass('selected')) {\n                $parent.removeAttr('data-option-selected').find('.selected').removeClass('selected');\n                $input.val('');\n                $label.text('');\n                $this.attr('aria-checked', false);\n            } else {\n                $parent.attr('data-option-selected', $this.data('option-id')).find('.selected').removeClass('selected');\n                $label.text($this.data('option-label'));\n                $input.val($this.data('option-id'));\n                $input.attr('data-attr-name', this._getAttributeCodeById(attributeId));\n                $this.addClass('selected');\n                $widget._toggleCheckedAttributes($this, $wrapper);\n            }\n\n            $widget._Rebuild();\n\n            if ($priceBox.is(':data(mage-priceBox)')) {\n                $widget._UpdatePrice();\n            }\n\n            $(document).trigger('updateMsrpPriceBlock',\n                [\n                    this._getSelectedOptionPriceIndex(),\n                    $widget.options.jsonConfig.optionPrices,\n                    $priceBox\n                ]);\n\n            if (parseInt(checkAdditionalData['update_product_preview_image'], 10) === 1) {\n                $widget._loadMedia();\n            }\n\n            $input.trigger('change');\n        },\n\n        /**\n         * Get selected option price index\n         *\n         * @return {String|undefined}\n         * @private\n         */\n        _getSelectedOptionPriceIndex: function () {\n            var allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (_.isEmpty(allowedProduct)) {\n                return undefined;\n            }\n\n            return allowedProduct;\n        },\n\n        /**\n         * Get human readable attribute code (eg. size, color) by it ID from configuration\n         *\n         * @param {Number} attributeId\n         * @returns {*}\n         * @private\n         */\n        _getAttributeCodeById: function (attributeId) {\n            var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n            return attribute ? attribute.code : attributeId;\n        },\n\n        /**\n         * Toggle accessibility attributes\n         *\n         * @param {Object} $this\n         * @param {Object} $wrapper\n         * @private\n         */\n        _toggleCheckedAttributes: function ($this, $wrapper) {\n            $wrapper.attr('aria-activedescendant', $this.attr('id'))\n                    .find('.' + this.options.classes.optionClass).attr('aria-checked', false);\n            $this.attr('aria-checked', true);\n        },\n\n        /**\n         * Event for select\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnChange: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput);\n\n            if ($widget.productForm.length > 0) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.val() > 0) {\n                $parent.attr('data-option-selected', $this.val());\n                $input.val($this.val());\n            } else {\n                $parent.removeAttr('data-option-selected');\n                $input.val('');\n            }\n\n            $widget._Rebuild();\n            $widget._UpdatePrice();\n            $widget._loadMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for more switcher\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _OnMoreClick: function ($this) {\n            $this.nextAll().show();\n            $this.trigger('blur').remove();\n        },\n\n        /**\n         * Rewind options for controls\n         *\n         * @private\n         */\n        _Rewind: function (controls) {\n            controls.find('div[data-option-id], option[data-option-id]')\n                .removeClass('disabled')\n                .prop('disabled', false);\n            controls.find('div[data-option-empty], option[data-option-empty]')\n                .attr('disabled', true)\n                .addClass('disabled')\n                .attr('tabindex', '-1');\n            this.disableSwatchForOutOfStockProducts();\n        },\n\n        /**\n         * Rebuild container\n         *\n         * @private\n         */\n        _Rebuild: function () {\n            var $widget = this,\n                controls = $widget.element.find('.' + $widget.options.classes.attributeClass + '[data-attribute-id]'),\n                selected = controls.filter('[data-option-selected]');\n\n            // Enable all options\n            $widget._Rewind(controls);\n\n            // done if nothing selected\n            if (selected.length <= 0) {\n                return;\n            }\n\n            // Disable not available options\n            controls.each(function () {\n                var $this = $(this),\n                    id = $this.data('attribute-id'),\n                    products = $widget._CalcProducts(id);\n\n                if (selected.length === 1 && selected.first().data('attribute-id') === id) {\n                    return;\n                }\n\n                $this.find('[data-option-id]').each(function () {\n                    var $element = $(this),\n                        option = $element.data('option-id');\n\n                    if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option) ||\n                        $element.hasClass('selected') ||\n                        $element.is(':selected')) {\n                        return;\n                    }\n\n                    if (_.intersection(products, $widget.optionsMap[id][option].products).length <= 0) {\n                        $element.attr('disabled', true).addClass('disabled');\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get selected product list\n         *\n         * @returns {Array}\n         * @private\n         */\n        _CalcProducts: function ($skipAttributeId) {\n            var $widget = this,\n                selectedOptions = '.' + $widget.options.classes.attributeClass + '[data-option-selected]',\n                products = [];\n\n            // Generate intersection of products\n            $widget.element.find(selectedOptions).each(function () {\n                var id = $(this).data('attribute-id'),\n                    option = $(this).attr('data-option-selected');\n\n                if ($skipAttributeId !== undefined && $skipAttributeId === id) {\n                    return;\n                }\n\n                if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option)) {\n                    return;\n                }\n\n                if (products.length === 0) {\n                    products = $widget.optionsMap[id][option].products;\n                } else {\n                    products = _.intersection(products, $widget.optionsMap[id][option].products);\n                }\n            });\n\n            return products;\n        },\n\n        /**\n         * Update total price\n         *\n         * @private\n         */\n        _UpdatePrice: function () {\n            var $widget = this,\n                $product = $widget.element.parents($widget.options.selectorProduct),\n                $productPrice = $product.find(this.options.selectorProductPrice),\n                result = $widget._getNewPrices(),\n                tierPriceHtml,\n                isShow;\n\n            $productPrice.trigger(\n                'updatePrice',\n                {\n                    'prices': $widget._getPrices(result, $productPrice.priceBox('option').prices)\n                }\n            );\n\n            isShow = typeof result != 'undefined' && result.oldPrice.amount !== result.finalPrice.amount;\n\n            $productPrice.find('span:first').toggleClass('special-price', isShow);\n\n            $product.find(this.options.slyOldPriceSelector)[isShow ? 'show' : 'hide']();\n\n            if (typeof result != 'undefined' && result.tierPrices && result.tierPrices.length) {\n                if (this.options.tierPriceTemplate) {\n                    tierPriceHtml = mageTemplate(\n                        this.options.tierPriceTemplate,\n                        {\n                            'tierPrices': result.tierPrices,\n                            '$t': $t,\n                            'currencyFormat': this.options.jsonConfig.currencyFormat,\n                            'priceUtils': priceUtils\n                        }\n                    );\n                    $(this.options.tierPriceBlockSelector).html(tierPriceHtml).show();\n                }\n            } else {\n                $(this.options.tierPriceBlockSelector).hide();\n            }\n\n            $(this.options.normalPriceLabelSelector).hide();\n\n            _.each($('.' + this.options.classes.attributeOptionsWrapper), function (attribute) {\n                if ($(attribute).find('.' + this.options.classes.optionClass + '.selected').length === 0) {\n                    if ($(attribute).find('.' + this.options.classes.selectClass).length > 0) {\n                        _.each($(attribute).find('.' + this.options.classes.selectClass), function (dropdown) {\n                            if ($(dropdown).val() === '0') {\n                                $(this.options.normalPriceLabelSelector).show();\n                            }\n                        }.bind(this));\n                    } else {\n                        $(this.options.normalPriceLabelSelector).show();\n                    }\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Get new prices for selected options\n         *\n         * @returns {*}\n         * @private\n         */\n        _getNewPrices: function () {\n            var $widget = this,\n                newPrices = $widget.options.jsonConfig.prices,\n                allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (!_.isEmpty(allowedProduct)) {\n                newPrices = this.options.jsonConfig.optionPrices[allowedProduct];\n            }\n\n            return newPrices;\n        },\n\n        /**\n         * Get prices\n         *\n         * @param {Object} newPrices\n         * @param {Object} displayPrices\n         * @returns {*}\n         * @private\n         */\n        _getPrices: function (newPrices, displayPrices) {\n            var $widget = this;\n\n            if (_.isEmpty(newPrices)) {\n                newPrices = $widget._getNewPrices();\n            }\n            _.each(displayPrices, function (price, code) {\n\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Get product with minimum price from selected options.\n         *\n         * @param {Array} allowedProducts\n         * @returns {String}\n         * @private\n         */\n        _getAllowedProductWithMinPrice: function (allowedProducts) {\n            var optionPrices = this.options.jsonConfig.optionPrices,\n                product = {},\n                optionFinalPrice, optionMinPrice;\n\n            _.each(allowedProducts, function (allowedProduct) {\n                optionFinalPrice = parseFloat(optionPrices[allowedProduct].finalPrice.amount);\n\n                if (_.isEmpty(product) || optionFinalPrice < optionMinPrice) {\n                    optionMinPrice = optionFinalPrice;\n                    product = allowedProduct;\n                }\n            }, this);\n\n            return product;\n        },\n\n        /**\n         * Gets all product media and change current to the needed one\n         *\n         * @private\n         */\n        _LoadProductMedia: function () {\n            var $widget = this,\n                $this = $widget.element,\n                productData = this._determineProductData(),\n                mediaCallData,\n                mediaCacheKey,\n\n                /**\n                 * Processes product media data\n                 *\n                 * @param {Object} data\n                 * @returns void\n                 */\n                mediaSuccessCallback = function (data) {\n                    if (!(mediaCacheKey in $widget.options.mediaCache)) {\n                        $widget.options.mediaCache[mediaCacheKey] = data;\n                    }\n                    $widget._ProductMediaCallback($this, data, productData.isInProductView);\n                    setTimeout(function () {\n                        $widget._DisableProductMediaLoader($this);\n                    }, 300);\n                };\n\n            if (!$widget.options.mediaCallback) {\n                return;\n            }\n\n            mediaCallData = {\n                'product_id': this.getProduct()\n            };\n\n            mediaCacheKey = JSON.stringify(mediaCallData);\n\n            if (mediaCacheKey in $widget.options.mediaCache) {\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                mediaSuccessCallback($widget.options.mediaCache[mediaCacheKey]);\n            } else {\n                mediaCallData.isAjax = true;\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                $widget.xhr = $.ajax({\n                    url: $widget.options.mediaCallback,\n                    cache: true,\n                    type: 'GET',\n                    dataType: 'json',\n                    data: mediaCallData,\n                    success: mediaSuccessCallback\n                }).done(function () {\n                    $widget._XhrKiller();\n                });\n            }\n        },\n\n        /**\n         * Enable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _EnableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .addClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .addClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Disable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _DisableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .removeClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .removeClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Callback for product media\n         *\n         * @param {Object} $this\n         * @param {String} response\n         * @param {Boolean} isInProductView\n         * @private\n         */\n        _ProductMediaCallback: function ($this, response, isInProductView) {\n            var $main = isInProductView ? $this.parents('.column.main') : $this.parents('.product-item-info'),\n                $widget = this,\n                images = [],\n\n                /**\n                 * Check whether object supported or not\n                 *\n                 * @param {Object} e\n                 * @returns {*|Boolean}\n                 */\n                support = function (e) {\n                    return e.hasOwnProperty('large') && e.hasOwnProperty('medium') && e.hasOwnProperty('small');\n                };\n\n            if (_.size($widget) < 1 || !support(response)) {\n                this.updateBaseImage(this.options.mediaGalleryInitial, $main, isInProductView);\n\n                return;\n            }\n\n            images.push({\n                full: response.large,\n                img: response.medium,\n                thumb: response.small,\n                isMain: true\n            });\n\n            if (response.hasOwnProperty('gallery')) {\n                $.each(response.gallery, function () {\n                    if (!support(this) || response.large === this.large) {\n                        return;\n                    }\n                    images.push({\n                        full: this.large,\n                        img: this.medium,\n                        thumb: this.small\n                    });\n                });\n            }\n\n            this.updateBaseImage(images, $main, isInProductView);\n        },\n\n        /**\n         * Check if images to update are initial and set their type\n         * @param {Array} images\n         */\n        _setImageType: function (images) {\n\n            images.map(function (img) {\n                if (!img.type) {\n                    img.type = 'image';\n                }\n            });\n\n            return images;\n        },\n\n        /**\n         * Update [gallery-placeholder] or [product-image-photo]\n         * @param {Array} images\n         * @param {jQuery} context\n         * @param {Boolean} isInProductView\n         */\n        updateBaseImage: function (images, context, isInProductView) {\n            var justAnImage = images[0],\n                initialImages = this.options.mediaGalleryInitial,\n                imagesToUpdate,\n                gallery = context.find(this.options.mediaGallerySelector).data('gallery'),\n                isInitial;\n\n            if (isInProductView) {\n                if (_.isUndefined(gallery)) {\n                    context.find(this.options.mediaGallerySelector).on('gallery:loaded', function () {\n                        this.updateBaseImage(images, context, isInProductView);\n                    }.bind(this));\n\n                    return;\n                }\n\n                imagesToUpdate = images.length ? this._setImageType($.extend(true, [], images)) : [];\n                isInitial = _.isEqual(imagesToUpdate, initialImages);\n\n                if (this.options.gallerySwitchStrategy === 'prepend' && !isInitial) {\n                    imagesToUpdate = imagesToUpdate.concat(initialImages);\n                }\n\n                imagesToUpdate = this._setImageIndex(imagesToUpdate);\n\n                gallery.updateData(imagesToUpdate);\n                this._addFotoramaVideoEvents(isInitial);\n            } else if (justAnImage && justAnImage.img) {\n                context.find('.product-image-photo').attr('src', justAnImage.img);\n            }\n        },\n\n        /**\n         * Add video events\n         *\n         * @param {Boolean} isInitial\n         * @private\n         */\n        _addFotoramaVideoEvents: function (isInitial) {\n            if (_.isUndefined($.mage.AddFotoramaVideoEvents)) {\n                return;\n            }\n\n            if (isInitial) {\n                $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n\n                return;\n            }\n\n            $(this.options.mediaGallerySelector).AddFotoramaVideoEvents({\n                selectedOption: this.getProduct(),\n                dataMergeStrategy: this.options.gallerySwitchStrategy\n            });\n        },\n\n        /**\n         * Set correct indexes for image set.\n         *\n         * @param {Array} images\n         * @private\n         */\n        _setImageIndex: function (images) {\n            var length = images.length,\n                i;\n\n            for (i = 0; length > i; i++) {\n                images[i].i = i + 1;\n            }\n\n            return images;\n        },\n\n        /**\n         * Kill doubled AJAX requests\n         *\n         * @private\n         */\n        _XhrKiller: function () {\n            var $widget = this;\n\n            if ($widget.xhr !== undefined && $widget.xhr !== null) {\n                $widget.xhr.abort();\n                $widget.xhr = null;\n            }\n        },\n\n        /**\n         * Emulate mouse click on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelected: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeCode, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-code=\"' + attributeCode + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Emulate mouse click or selection change on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelectedByAttributeId: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeId, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-id=\"' + attributeId + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Get default options values settings with either URL query parameters\n         * @private\n         */\n        _getSelectedAttributes: function () {\n            var hashIndex = window.location.href.indexOf('#'),\n                selectedAttributes = {},\n                params;\n\n            if (hashIndex !== -1) {\n                params = $.parseQuery(window.location.href.substr(hashIndex + 1));\n\n                selectedAttributes = _.invert(_.mapObject(_.invert(params), function (attributeId) {\n                    var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n                    return attribute ? attribute.code : attributeId;\n                }.bind(this)));\n            }\n\n            return selectedAttributes;\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         *\n         * @param {HTMLElement} element - DOM element associated with a gallery.\n         */\n        _onGalleryLoaded: function (element) {\n            var galleryObject = element.data('gallery');\n\n            this.options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n        },\n\n        /**\n         * Sets mediaCache for cases when jsonConfig contains preSelectedGallery on layered navigation result pages\n         *\n         * @private\n         */\n        _setPreSelectedGallery: function () {\n            var mediaCallData;\n\n            if (this.options.jsonConfig.preSelectedGallery) {\n                mediaCallData = {\n                    'product_id': this.getProduct()\n                };\n\n                this.options.mediaCache[JSON.stringify(mediaCallData)] = this.options.jsonConfig.preSelectedGallery;\n            }\n        },\n\n        /**\n         * Callback for quantity change event.\n         */\n        _onQtyChanged: function () {\n            var $price = this.element.parents(this.options.selectorProduct)\n                .find(this.options.selectorProductPrice);\n\n            $price.trigger(\n                'updatePrice',\n                {\n                    'prices': this._getPrices(this._getNewPrices(), $price.priceBox('option').prices)\n                }\n            );\n        }\n    });\n\n    return $.mage.SwatchRenderer;\n});\n","Magento_Swatches/js/form/element/swatch-visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'mage/template',\n    'uiRegistry',\n    'prototype',\n    'Magento_Ui/js/form/element/abstract',\n    'jquery/colorpicker/js/colorpicker',\n    'jquery/ui'\n], function (_, jQuery, mageTemplate, rg, prototype, Abstract) {\n    'use strict';\n\n    /**\n     * Former implementation.\n     *\n     * @param {*} value\n     * @param {Object} container\n     * @param {String} uploadUrl\n     * @param {String} elementName\n     */\n    function oldCode(value, container, uploadUrl, elementName) {\n        var swatchVisualOption = {\n            itemCount: 0,\n            totalItems: 0,\n            rendered: 0,\n            isReadOnly: false,\n\n            /**\n             * Initialize.\n             */\n            initialize: function () {\n                if (_.isEmpty(value)) {\n                    container.addClassName('unavailable');\n                }\n\n                jQuery(container).on(\n                    'click',\n                    '.colorpicker_handler',\n                    this.initColorPicker\n                );\n            },\n\n            /**\n             * ColorPicker initialization process\n             */\n            initColorPicker: function () {\n                var element = this,\n                    hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                jQuery(this).ColorPicker({\n\n                    /**\n                     * ColorPicker onShow action\n                     */\n                    onShow: function () {\n                        var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                            menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                        menu.hide();\n                        jQuery(element).ColorPickerSetColor(color);\n                    },\n\n                    /**\n                     * ColorPicker onSubmit action\n                     *\n                     * @param {String} hsb\n                     * @param {String} hex\n                     * @param {String} rgb\n                     * @param {String} el\n                     */\n                    onSubmit: function (hsb, hex, rgb, el) {\n                        var localContainer = jQuery(el).parent().parent().prev();\n\n                        jQuery(el).ColorPickerHide();\n                        localContainer.parent().removeClass('unavailable');\n                        localContainer.prev('input').val('#' + hex).trigger('change');\n                        localContainer.css('background', '#' + hex);\n                    }\n                });\n\n                if (hiddenColorPicker) {\n                    jQuery(this).ColorPickerShow();\n                }\n            },\n\n            /**\n             * Remove action\n             *\n             * @param {Object} event\n             */\n            remove: function (event) {\n                var element = $(Event.findElement(event, 'tr')),\n                    elementFlags; // !!! Button already have table parent in safari\n\n                // Safari workaround\n                element.ancestors().each(function (parentItem) {\n                    if (parentItem.hasClassName('option-row')) {\n                        element = parentItem;\n                        throw $break;\n                    } else if (parentItem.hasClassName('box')) {\n                        throw $break;\n                    }\n                });\n\n                if (element) {\n                    elementFlags = element.getElementsByClassName('delete-flag');\n\n                    if (elementFlags[0]) {\n                        elementFlags[0].value = 1;\n                    }\n\n                    element.addClassName('no-display');\n                    element.addClassName('template');\n                    element.hide();\n                    this.totalItems--;\n                    this.updateItemsCountField();\n                }\n            },\n\n            /**\n             * Update items count field\n             */\n            updateItemsCountField: function () {\n                $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n            }\n        };\n\n        //swatchVisualOption.initColorPicker();\n\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe></iframe>', {\n                        name: 'upload_iframe_' + elementName\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form></form>', {\n                        name: 'swatch_form_image_upload_' + elementName,\n                        target: 'upload_iframe_' + elementName,\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: uploadUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            swatchVisualOption.initialize();\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var localContainer = $('.' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        localContainer.prev('input').val(imageParams['file_path']).trigger('change');\n                        localContainer.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        localContainer.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.on('load', iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(container).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).data('class'));\n                swatchComponents.inputFile.trigger('click');\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(container).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('').trigger('change');\n                optionPanel.children('.swatch_window').css('background', '');\n                optionPanel.addClass('unavailable');\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(container).on('click', '.swatch_window', function () {\n                jQuery('.swatch_sub-menu_container').hide();\n                $(this).next('div').toggle();\n            });\n        });\n    }\n\n    return Abstract.extend({\n        defaults: {\n            elementId: 0,\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            value: '',\n            uploadUrl: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Initialize.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initOldCode()\n                .on('value', this.onChangeColor.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Handler function that execute when color changes.\n         *\n         * @param {String} data - color\n         */\n        onChangeColor: function (data) {\n            if (!data) {\n                jQuery('.' + this.elementName).parent().removeClass('unavailable');\n            }\n        },\n\n        /**\n         * Initialize wrapped former implementation.\n         *\n         * @returns {Object} Chainable.\n         */\n        initOldCode: function () {\n            jQuery.async('.' + this.elementName, this.name, function (elem) {\n                oldCode(this.value(), elem.parentElement, this.uploadUrl, this.elementName);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId, prefixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            this.inputName = prefixName + '[' + this.elementName + ']';\n            this.exportDataLink = 'data.' + this.prefixName + '.' + this.elementName;\n            this.exports.value = this.provider + ':' + this.exportDataLink;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n\n            this.source.remove(this.exportDataLink);\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Add new level of nesting.\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        }\n    });\n});\n","Magento_Security/js/escaper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * A loose JavaScript version of Magento\\Framework\\Escaper\n *\n * Due to differences in how XML/HTML is processed in PHP vs JS there are a couple of minor differences in behavior\n * from the PHP counterpart.\n *\n * The first difference is that the default invocation of escapeHtml without allowedTags will double-escape existing\n * entities as the intention of such an invocation is that the input isn't supposed to contain any HTML.\n *\n * The second difference is that escapeHtml will not escape quotes. Since the input is actually being processed by the\n * DOM there is no chance of quotes being mixed with HTML syntax. And, since escapeHtml is not\n * intended to be used with raw injection into a HTML attribute, this is acceptable.\n *\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        neverAllowedElements: ['script', 'img', 'embed', 'iframe', 'video', 'source', 'object', 'audio'],\n        generallyAllowedAttributes: ['id', 'class', 'href', 'title', 'style'],\n        forbiddenAttributesByElement: {\n            a: ['style']\n        },\n\n        /**\n         * Escape a string for safe injection into HTML\n         *\n         * @param {String} data\n         * @param {Array|null} allowedTags\n         * @returns {String}\n         */\n        escapeHtml: function (data, allowedTags) {\n            var domParser = new DOMParser(),\n                fragment = domParser.parseFromString('<div></div>', 'text/html');\n\n            fragment = fragment.body.childNodes[0];\n            allowedTags = typeof allowedTags === 'object' && allowedTags.length ? allowedTags : null;\n\n            if (allowedTags) {\n                fragment.innerHTML = data || '';\n                allowedTags = this._filterProhibitedTags(allowedTags);\n\n                this._removeComments(fragment);\n                this._removeNotAllowedElements(fragment, allowedTags);\n                this._removeNotAllowedAttributes(fragment);\n\n                return fragment.innerHTML;\n            }\n\n            fragment.textContent = data || '';\n\n            return fragment.innerHTML;\n        },\n\n        /**\n         * Remove the always forbidden tags from a list of provided tags\n         *\n         * @param {Array} tags\n         * @returns {Array}\n         * @private\n         */\n        _filterProhibitedTags: function (tags) {\n            return tags.filter(function (n) {\n                return this.neverAllowedElements.indexOf(n) === -1;\n            }.bind(this));\n        },\n\n        /**\n         * Remove comment nodes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeComments: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_COMMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                    false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                nodesToRemove.push(treeWalker.currentNode);\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.removeChild(nodeToRemove);\n            });\n        },\n\n        /**\n         * Strip the given node of all disallowed tags while permitting any nested text nodes\n         *\n         * @param {Node} node\n         * @param {Array|null} allowedTags\n         * @private\n         */\n        _removeNotAllowedElements: function (node, allowedTags) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function (currentNode) {\n                        return allowedTags.indexOf(currentNode.nodeName.toLowerCase()) === -1 ?\n                            NodeFilter.FILTER_ACCEPT\n                            // SKIP instead of REJECT because REJECT also rejects child nodes\n                            : NodeFilter.FILTER_SKIP;\n                    },\n                false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                if (allowedTags.indexOf(treeWalker.currentNode.nodeName.toLowerCase()) === -1) {\n                    nodesToRemove.push(treeWalker.currentNode);\n                }\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.replaceChild(\n                    node.ownerDocument.createTextNode(nodeToRemove.textContent),\n                    nodeToRemove\n                );\n            });\n        },\n\n        /**\n         * Remove any invalid attributes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeNotAllowedAttributes: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                false\n                ),\n                i,\n                attribute,\n                nodeName,\n                attributesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                for (i = 0; i < treeWalker.currentNode.attributes.length; i++) {\n                    attribute = treeWalker.currentNode.attributes[i];\n                    nodeName = treeWalker.currentNode.nodeName.toLowerCase();\n\n                    if (this.generallyAllowedAttributes.indexOf(attribute.name) === -1  || // eslint-disable-line max-depth,max-len\n                        this._checkHrefValue(attribute) ||\n                        this.forbiddenAttributesByElement[nodeName] &&\n                        this.forbiddenAttributesByElement[nodeName].indexOf(attribute.name) !== -1\n                    ) {\n                        attributesToRemove.push(attribute);\n                    }\n                }\n            }\n\n            attributesToRemove.forEach(function (attributeToRemove) {\n                attributeToRemove.ownerElement.removeAttribute(attributeToRemove.name);\n            });\n        },\n\n        /**\n         * Check that attribute contains script content\n         *\n         * @param {Object} attribute\n         * @private\n         */\n        _checkHrefValue: function (attribute) {\n            return attribute.nodeName === 'href' && attribute.nodeValue.startsWith('javascript');\n        }\n    };\n});\n","Magento_Security/js/confirm-redirect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*eslint-disable no-undef*/\ndefine(\n    ['jquery'],\n    function ($) {\n        'use strict';\n\n        return function (config, element) {\n            $(element).on('click', config, function () {\n                confirmSetLocation(config.message, config.url);\n            });\n        };\n    }\n);\n","Magento_Security/js/system/config/session-size.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/confirm',\n    'domReady!'\n], function ($, $t, confirm) {\n    'use strict';\n\n    return function (config, inputEl) {\n        var $inputEl = $(inputEl);\n\n        $inputEl.on('blur', function () {\n            var inputVal = parseInt($inputEl.val(), 10);\n\n            if (inputVal < 256000) {\n                confirm({\n                    title: $t(config.modalTitleText),\n                    content: $t(config.modalContentBody),\n                    buttons: [{\n                        text: $t('No'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Close modal and trigger 'cancel' action on click\n                         */\n                        click: function (event) {\n                            this.closeModal(event);\n                        }\n                    }, {\n                        text: $t('Yes'),\n                        class: 'action-primary action-accept',\n\n                        /**\n                         * Close modal and trigger 'confirm' action on click\n                         */\n                        click: function (event) {\n                            this.closeModal(event, true);\n                        }\n                    }],\n                    actions: {\n\n                        /**\n                         * Revert back to original value\n                         */\n                        cancel: function () {\n                            $inputEl.val(256000);\n                        }\n                    }\n                });\n            }\n        });\n    };\n});\n","Mageplaza_Smtp/js/testconnection.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Smtp\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\ndefine([\r\n    \"jquery\",\r\n    \"Magento_Ui/js/modal/alert\",\r\n    \"mage/translate\",\r\n    \"jquery/ui\"\r\n], function ($, alert, $t) {\r\n    \"use strict\";\r\n\r\n    $.widget('mageplaza.testconnection', {\r\n        options: {\r\n            ajaxUrl: '',\r\n            testConnection: '#email_marketing_general_test_connection',\r\n            appID: '#email_marketing_general_app_id',\r\n            secretKey: '#email_marketing_general_secret_key',\r\n        },\r\n        _create: function () {\r\n            var self = this;\r\n\r\n            $(this.options.testConnection).click(function (e) {\r\n                e.preventDefault();\r\n                self._ajaxSubmit();\r\n            });\r\n        },\r\n\r\n        _ajaxSubmit: function () {\r\n            $.ajax({\r\n                url: this.options.ajaxUrl,\r\n                data: {\r\n                    appID: $(this.options.appID).val(),\r\n                    secretKey: $(this.options.secretKey).val()\r\n                },\r\n                dataType: 'json',\r\n                showLoader: true,\r\n                success: function (result) {\r\n                    alert({\r\n                        title: result.status ? $t('Success') : $t('Error'),\r\n                        content: result.content\r\n                    });\r\n                }\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.testconnection;\r\n});\r\n","Mageplaza_Smtp/js/abandonedcart.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_SMTP\r\n * @copyright   Copyright (c) Mageplaza (http://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\ndefine([\r\n    'jquery',\r\n    'Magento_Ui/js/modal/modal'\r\n], function ($, modal) {\r\n    \"use strict\";\r\n\r\n    $.widget('mageplaza.abandonedcarts', {\r\n\r\n        _create: function () {\r\n            this.initObserve();\r\n        },\r\n\r\n        /**\r\n         * Init observe\r\n         */\r\n        initObserve: function () {\r\n            var self = this,\r\n                popupSendEmailElement = $('#popup-send-email'),\r\n                copyElement = $('#copy');\r\n\r\n            $(\"#send\").click(function () {\r\n                $('#popup-send-email-details').show();\r\n                $('#popup-send-email-preview').show();\r\n                $('#preview').hide();\r\n                $('#popup-send-email-back').hide();\r\n\r\n                modal({\r\n                    type: 'popup',\r\n                    responsive: true,\r\n                    innerScroll: true,\r\n                    title: '',\r\n                    buttons: []\r\n                }, popupSendEmailElement);\r\n\r\n                popupSendEmailElement.modal('openModal');\r\n            });\r\n\r\n            $('#popup-send-email-preview').click(function () {\r\n                self.preview();\r\n            });\r\n\r\n            $('#popup-send-email form').submit(function(){\r\n                $(this).find(':submit').attr('disabled','disabled');\r\n            });\r\n\r\n\r\n            $('#popup-send-email-back').click(function () {\r\n                $('#popup-send-email-details').show();\r\n                $('#popup-send-email-preview').show();\r\n                $('#preview').hide();\r\n                this.hide();\r\n            });\r\n\r\n            copyElement.click(function () {\r\n               self.copyToClipboard();\r\n               $('#link-tooltip').text(self.options.copied_message);\r\n\r\n            });\r\n\r\n            copyElement.mouseout(function () {\r\n                $('#link-tooltip').text(self.options.tooltip);\r\n            })\r\n\r\n        },\r\n        copyToClipboard: function(){\r\n            var temp = $('<input>');\r\n\r\n            $('body').append(temp);\r\n            temp.val($('#recovery_link > span').text()).select();\r\n            document.execCommand('copy');\r\n            temp.remove();\r\n        },\r\n\r\n        /**\r\n         * @param type\r\n         * @param message\r\n         * @returns {string}\r\n         */\r\n        getMessageHtml: function (type, message) {\r\n            return '<div class=\"message message-' + type + '\"> <span>' + message + '</span> </div>';\r\n        },\r\n        getParams: function () {\r\n            return {\r\n                from: $('#sender').val(),\r\n                quote_id: this.options.quote_id,\r\n                template_id: $('#email-template').val(),\r\n                customer_name: this.options.customer_name,\r\n                additional_message: $('#additional-message').val()\r\n            }\r\n        },\r\n        preview: function () {\r\n            var self = this;\r\n\r\n            $.ajax({\r\n                url: this.options.preview_url,\r\n                data: this.getParams(),\r\n                dataType: 'json',\r\n                showLoader: true,\r\n                success: function (result) {\r\n                    if (result.status) {\r\n                        var dstFrame = document.getElementById('iframe-preview'),\r\n                            dstDoc   = dstFrame.contentDocument || dstFrame.contentWindow.document;\r\n\r\n                        dstDoc.write(result.content);\r\n                        dstDoc.close();\r\n                        $('#popup-send-email-details').hide();\r\n                        $('#popup-send-email-back').show();\r\n                        $('#preview').show();\r\n                        $('#popup-send-email-preview').hide();\r\n                        $('#subject strong').text(result.subject);\r\n                        $('#preview-from').text(result.from.email);\r\n                    } else {\r\n                        $('#popup-send-email #messages').html(self.getMessageHtml('error error', result.message));\r\n                    }\r\n                }\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.abandonedcarts;\r\n});\r\n","Mageplaza_Smtp/js/testemail.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Smtp\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\ndefine([\r\n    \"jquery\",\r\n    \"Magento_Ui/js/modal/alert\",\r\n    \"mage/translate\",\r\n    \"jquery/ui\"\r\n], function ($, alert, $t) {\r\n    \"use strict\";\r\n\r\n    $.widget('mageplaza.testEmail', {\r\n        options: {\r\n            ajaxUrl: '',\r\n            testEmail: '#smtp_configuration_option_test_email_sent',\r\n            fromEmailElem: '#smtp_configuration_option_test_email_from',\r\n            hostElem: '#smtp_configuration_option_host',\r\n            portElem: '#smtp_configuration_option_port',\r\n            authenticationElem: '#smtp_configuration_option_authentication',\r\n            protocolElem: '#smtp_configuration_option_protocol',\r\n            usernameElem: '#smtp_configuration_option_username',\r\n            passwordElem: '#smtp_configuration_option_password',\r\n            rerutnPathElem: '#smtp_configuration_option_return_path_email'\r\n        },\r\n        _create: function () {\r\n            var self = this;\r\n\r\n            $(this.options.testEmail).click(function (e) {\r\n                e.preventDefault();\r\n                if (self.element.val()) {\r\n                    self._ajaxSubmit();\r\n                }\r\n            });\r\n        },\r\n\r\n        _ajaxSubmit: function () {\r\n            $.ajax({\r\n                url: this.options.ajaxUrl,\r\n                data: {\r\n                    from: $(this.options.fromEmailElem).val(),\r\n                    to: this.element.val(),\r\n                    host: $(this.options.hostElem).val(),\r\n                    port: $(this.options.portElem).val(),\r\n                    authentication: $(this.options.authenticationElem).val(),\r\n                    protocol: $(this.options.protocolElem).val(),\r\n                    username: $(this.options.usernameElem).val(),\r\n                    password: $(this.options.passwordElem).val(),\r\n                    returnpath: $(this.options.rerutnPathElem).val()\r\n                },\r\n                dataType: 'json',\r\n                showLoader: true,\r\n                success: function (result) {\r\n                    alert({\r\n                        title: result.status ? $t('Success') : $t('Error'),\r\n                        content: result.content\r\n                    });\r\n                }\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.testEmail;\r\n});\r\n","Mageplaza_Smtp/js/sync/sync.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Smtp\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\ndefine([\n    'jquery',\n    'Mageplaza_Smtp/js/model/sync'\n], function ($, Sync) {\n    'use strict';\n\n    $.widget('mageplaza.sync', {\n        options: {\n            ajaxUrl: '',\n            websiteId: '',\n            storeId: '',\n            estimateUrl: '',\n            buttonElement: '#email_marketing_general_synchronization_sync',\n            saveLog: '#email_marketing_general_synchronization_sync_log',\n            prefix: '#mp-synchronize',\n            console: '.email_marketing_general_synchronization_sync_console'\n        },\n        _create: function () {\n            var self = this;\n\n            $(this.options.buttonElement).click(function (e) {\n                e.preventDefault();\n                Sync.process(self.options);\n            });\n\n            $(this.options.saveLog).click(function (e) {\n                e.preventDefault();\n                Sync.saveLog(self.options.console);\n            });\n        },\n    });\n\n    return $.mageplaza.sync;\n});\n","Mageplaza_Smtp/js/model/sync.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Smtp\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate'\n], function ($, _, $t) {\n    \"use strict\";\n\n    return {\n        options: {},\n        currentResult: {},\n        totalSync: 0,\n\n        /**\n         * @param classCss\n         * @param message\n         */\n        showMessage: function (classCss, message) {\n            var messageElement = this.getElement(\".message\");\n\n            messageElement.removeClass('message-error message-success message-notice');\n            this.getElement(\".message-text strong\").text(message);\n            messageElement.addClass(classCss).show();\n        },\n\n        /**\n         * @param value\n         * @returns {*|n.fn.init|r.fn.init|jQuery.fn.init|jQuery|HTMLElement}\n         */\n        getElement: function (value) {\n            return $(this.options.prefix + ' ' + value);\n        },\n\n        /**\n         * @param start\n         * @param i\n         */\n        syncData: function (start, i) {\n            var end         = start + 100,\n                ids         = this.currentResult.ids.slice(start, end),\n                self        = this,\n                createdFrom = $('#datepicker-from').val(),\n                createdTo   = $('#datepicker-to').val(),\n                daysRange   = $('#email_marketing_general_synchronization_days_range').val(),\n                type        = $('#email_marketing_general_synchronization_sync_type').val(),\n                syncOptions = $('#email_marketing_general_synchronization_sync_options').val(),\n                percent, percentText;\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'post',\n                dataType: 'json',\n                data: {\n                    type: i ? i : type,\n                    syncOptions: syncOptions,\n                    ids: ids,\n                    from: createdFrom,\n                    to: createdTo,\n                    daysRange: daysRange\n                },\n                success: function (result) {\n                    var inputLog = self.getElement('#mp-log-data').val();\n\n                    inputLog += JSON.stringify(result.log) + '|';\n\n                    if (result.status) {\n                        percent = ids.length / self.currentResult.total * 100;\n                        self.totalSync += result.total;\n                        percent = percent.toFixed(2);\n\n                        self.currentResult.percent += parseFloat(percent);\n                        if (self.currentResult.percent > 100) {\n                            self.currentResult.percent = 100;\n                        }\n                        self.getElement('#mp-log-data').val(inputLog);\n                        self.getElement('#mp-console-log').val(self.formatLog(result.log, self));\n                        percentText = self.currentResult.percent.toFixed(2) + '%';\n                        if (percentText === '100.00%' || self.totalSync === self.currentResult.total) {\n                            percentText = '100%';\n                            $(self.options.buttonElement).removeClass('disabled');\n                        }\n\n                        self.getElement('.progress-bar').css('width', percentText);\n                        self.getElement('#sync-percent').text(\n                            percentText + ' (' + self.totalSync + '/' + self.currentResult.total + ')'\n                        );\n\n                        if (i && i >= 1 && i <= 3) {\n                            self.getElement('.progress-bar-' + i).css('width', percentText);\n                            self.getElement('#sync-percent-' + i).text(\n                                percentText + ' (' + self.totalSync + '/' + self.currentResult.total + ')'\n                            );\n                        }\n\n                        if (end < self.currentResult.total) {\n                            self.syncData(end, i);\n                        } else {\n                            self.getElement('.syncing').hide();\n                            if (type === 'all') {\n                                self.showMultiMessages('message message-success', self.options.successMessage[i]);\n                            } else {\n                                self.showMessage('message-success', self.options.successMessage[type]);\n                            }\n                            if (i !== null) {\n                                self.estimateSyncAll(i + 1, syncOptions, createdFrom, createdTo, daysRange);\n                            }\n                        }\n                    } else {\n                        self.getElement('#mp-console-log').val(self.formatLog(result.log, self));\n                        self.getElement('#mp-log-data').val(inputLog);\n                        if (type === 'all') {\n                            self.showMultiMessages('message message-error', result.message);\n                        } else {\n                            self.showMessage('message-error', result.message);\n                        }\n                        $(self.options.buttonElement).removeClass('disabled');\n                    }\n                }\n            });\n        },\n\n        formatLog: function (log, self) {\n            var rs = self.getElement('#mp-console-log').val();\n\n            rs += log.message + '\\n';\n\n            _.each(log.data, function (item, index) {\n                if (index === 'success') {\n                    rs += ($t('Success: ') + item + '\\n')\n                }\n\n                if (index === 'error') {\n                    rs += ($t('Error: ') + item + '\\n')\n                }\n\n                if (index === 'error_details') {\n                    _.each(item, function (detail) {\n                        rs += ($t('Item ID: ' + detail.id + '\\n'))\n                        rs += ($t('Error: ' + detail.message + '\\n\\n'))\n                    })\n                }\n            });\n\n            return rs;\n        },\n\n        /**\n         * @param options\n         */\n        process: function (options) {\n            var self        = this,\n                type        = $('#email_marketing_general_synchronization_sync_type').val(),\n                syncOptions = $('#email_marketing_general_synchronization_sync_options').val(),\n                createdFrom = $('#datepicker-from').val(),\n                createdTo   = $('#datepicker-to').val(),\n                daysRange   = $('#email_marketing_general_synchronization_days_range').val();\n\n            options.buttonElement = '#email_marketing_general_synchronization button';\n            this.options          = options;\n            this.currentResult    = {};\n\n            self.getElement('.progress-content').hide();\n\n            if (type !== 'all') {\n                self.estimateSync(type, syncOptions, createdFrom, createdTo, daysRange);\n            } else {\n                self.getElement('#mp-console-log').val('');\n                self.getElement('#mp-log-data').val('');\n                self.estimateSyncAll(null, syncOptions, createdFrom, createdTo, daysRange);\n            }\n        },\n\n        estimateSync: function (type, syncOptions, createdFrom, createdTo, daysRange) {\n            var self = this;\n\n            $.ajax({\n                url: this.options.estimateUrl,\n                data: {\n                    websiteId: this.options.websiteId,\n                    storeId: this.options.storeId,\n                    type: type,\n                    syncOptions: syncOptions,\n                    from: createdFrom,\n                    to: createdTo,\n                    daysRange: daysRange\n                },\n                dataType: 'json',\n                showLoader: true,\n                success: function (result) {\n                    window.onbeforeunload = (e) => {\n                        e.preventDefault();\n                        e.returnValue = $t('Changes you made may not be saved.');\n                    };\n\n                    self.getElement('.multi-messages').hide();\n\n                    if (result.status) {\n                        self.currentResult = result;\n                        self.getElement('.message').hide();\n                        if (self.currentResult.total > 0) {\n                            self.getElement('#console-log').show();\n                        }\n                        self.getElement('#mp-console-log').val('');\n                        self.getElement('#mp-log-data').val('');\n\n                        if (self.currentResult.total > 0) {\n                            self.getElement('#sync-percent').text('0%');\n                            self.getElement('.progress-bar').removeAttr('style');\n                            self.currentResult.percent = 0;\n                            self.getElement('#progress-content').show();\n                            self.totalSync = 0;\n                            self.getElement('.syncing').hide();\n                            self.getElement('#syncing').show();\n                            $(self.options.buttonElement).addClass('disabled');\n                            self.syncData(0, null);\n                        } else {\n                            self.showMessage('message-notice', result.message);\n                            $(self.options.buttonElement).removeClass('disabled');\n                            self.getElement('#progress-content').hide();\n                        }\n                    } else {\n                        self.showMessage('message-error', result.message);\n                        $(self.options.buttonElement).removeClass('disabled');\n                        self.getElement('#progress-content').hide();\n                    }\n                }\n            });\n        },\n\n        estimateSyncAll: function (i = null, syncOptions, createdFrom, createdTo, daysRange) {\n            var self = this;\n\n            if (i === null) {\n                self.getElement('.multi-messages').html('');\n                i = 1;\n            }\n\n            if (i <= 3) {\n                $.ajax({\n                    url: this.options.estimateUrl,\n                    data: {\n                        websiteId: this.options.websiteId,\n                        storeId: this.options.storeId,\n                        type: i,\n                        syncOptions: syncOptions,\n                        from: createdFrom,\n                        to: createdTo,\n                        daysRange: daysRange\n                    },\n                    dataType: 'json',\n                    showLoader: true,\n                    success: function (result) {\n                        window.onbeforeunload = (e) => {\n                            e.preventDefault();\n                            e.returnValue = $t('Changes you made may not be saved.');\n                        };\n\n                        if (result.status) {\n                            self.currentResult = result;\n                            self.getElement('.message').hide();\n                            self.getElement('.multi-messages').show();\n                            self.getElement('.multi-messages .message').show();\n                            if (self.currentResult.total > 0) {\n                                self.getElement('#console-log').show();\n                            }\n\n                            if (self.currentResult.total > 0) {\n                                self.getElement('#sync-percent-' + i).text('0%');\n                                self.getElement('.progress-bar-' + i).removeAttr('style');\n                                self.currentResult.percent = 0;\n                                self.getElement('#progress-content-' + i).show();\n                                self.totalSync = 0;\n                                self.getElement('.syncing').hide();\n                                self.getElement('#syncing-' + i).show();\n                                $(self.options.buttonElement).addClass('disabled');\n                                self.syncData(0, i);\n                            } else {\n                                self.showMultiMessages('message message-notice', result.message);\n                                $(self.options.buttonElement).removeClass('disabled');\n                                self.getElement('#progress-content-' + i).hide();\n                                self.estimateSyncAll(i + 1, syncOptions, createdFrom, createdTo, daysRange);\n                            }\n                        } else {\n                            self.showMultiMessages('message message-error', result.message);\n                            $(self.options.buttonElement).removeClass('disabled');\n                            self.getElement('#progress-content-' + i).hide();\n                        }\n                    }\n                });\n            }\n        },\n\n        showMultiMessages: function (classCss, message) {\n            var messageElement = this.getElement('.multi-messages'),\n                html           = '<div class=\"' + classCss + '\"><span class=\"message-text\"><strong>'\n                    + message + '</strong></span><br></div>';\n\n            messageElement.append(html);\n            messageElement.find('.message').show();\n        },\n\n        saveLog: function (console) {\n            var log     = $(console).val(),\n                content = 'status,message,success,error,detail' + '\\n',\n                arrLog  = log.split('|');\n\n            _.each(arrLog, function (item) {\n                if (item) {\n                    var data   = JSON.parse(item),\n                        detail = '';\n\n                    content += data.success + ',' + data.message + ',' + data.data.success + ',' + data.data.error + ',';\n                    _.each(data.data.error_details, function (error) {\n                        if (error) {\n                            detail += JSON.stringify(error) + '\\n';\n                        }\n                    });\n                    var newDetail = detail.replace(',', ';');\n                    newDetail     = newDetail.replace(/['\"]+/g, '');\n                    content += '\"' + newDetail + '\"' + '\\n';\n                }\n            });\n\n            var hiddenElement      = document.createElement('a');\n            hiddenElement.href     = 'data:text/csv;charset=utf-8,' + encodeURI(content);\n            hiddenElement.target   = '_blank';\n            hiddenElement.download = 'mp-console-log.csv';\n            hiddenElement.click();\n        }\n    };\n});\n","Mageplaza_Smtp/js/grid/columns/status.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license sliderConfig is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Smtp\r\n * @copyright   Copyright (c) Mageplaza (http://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'Magento_Ui/js/grid/columns/select'\r\n], function (Column) {\r\n    'use strict';\r\n\r\n    return Column.extend({\r\n        defaults: {\r\n            bodyTmpl: 'ui/grid/cells/html'\r\n        },\r\n        getLabel: function (record) {\r\n            var label = this._super(record);\r\n\r\n            if (label !== '') {\r\n                if (record.status == 1) {\r\n                    label = '<span class=\"grid-severity-notice\"><span>' + label + '</span></span>';\r\n                } else {\r\n                    label = '<span class=\"grid-severity-minor\"><span>' + label + '</span></span>';\r\n                }\r\n            }\r\n\r\n            return label;\r\n        }\r\n    });\r\n});\r\n\r\n","Mageplaza_Smtp/js/grid/columns/actions.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license sliderConfig is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Smtp\n * @copyright   Copyright (c) Mageplaza (http://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/grid/columns/actions',\n    'Magento_Ui/js/modal/modal'\n], function ($, Column) {\n    'use strict';\n\n    function strip(html){\n        var doc = new DOMParser().parseFromString(html, 'text/html');\n\n        return doc.body.textContent || \"\";\n    }\n\n    return Column.extend({\n        modal: {},\n\n        /**\n         * @inheritDoc\n         */\n        defaultCallback: function (actionIndex, recordId, action) {\n            if (actionIndex !== 'view') {\n                return this._super();\n            }\n\n            if (typeof this.modal[action.rowIndex] === 'undefined' || typeof this.modal[action.rowIndex] === 'object') {\n                var row = this.rows[action.rowIndex],\n                    modalHtml = '<iframe srcdoc=\"' + row['email_content'] + '\" style=\"width: 100%; height: 100%\"></iframe>';\n\n                this.modal[action.rowIndex] = $('<div>')\n                    .html(modalHtml)\n                    .modal({\n                        type: 'slide',\n                        title: strip(row['subject']),\n                        modalClass: 'mpsmtp-modal-email',\n                        innerScroll: true,\n                        buttons: []\n                    });\n            }\n\n            this.modal[action.rowIndex].trigger('openModal');\n        }\n    });\n});\n\n","Magento_Theme/js/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'prototype'\n], function () {\n    'use strict';\n\n    /**\n     * @param {*} selected\n     * @param {Object} defaultsById\n     */\n    function parentThemeOnChange(selected, defaultsById) {\n        var statusBar = $$('.tab-item-link')[0],\n            isChanged = statusBar.hasClassName('changed'),\n            defaults;\n\n        if (!isChanged) {\n            defaults = defaultsById[selected];\n            $('theme_title').value = defaults['theme_title'];\n        }\n    }\n\n    window.parentThemeOnChange = parentThemeOnChange;\n});\n","Magento_Theme/js/custom-js-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('theme.themeJsList', {\n        options: {\n            templateId: null,\n            emptyTemplateId: null,\n            refreshFileListEvent: null,\n            prefixItemId: '',\n            suffixItemId: ''\n        },\n\n        /**\n         * Initialize widget\n         *\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind event handlers\n         *\n         * @protected\n         */\n        _bind: function () {\n            $('body').on(this.options.refreshFileListEvent, $.proxy(this._onRefreshList, this));\n        },\n\n        /**\n         * Render js files list\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @protected\n         */\n        _onRefreshList: function (event, data) {\n            $(this.element).html('');\n\n            if (data.jsList.length) {\n                this._renderList(data.jsList);\n            } else {\n                this._renderEmptyList();\n            }\n        },\n\n        /**\n         * Get item js list id\n         *\n         * @param {*} fileId\n         * @return {String}\n         * @protected\n         */\n        _getItemId: function (fileId) {\n            return this.options.prefixItemId + fileId + this.options.suffixItemId;\n        },\n\n        /**\n         * Render js list\n         *\n         * @param {Array} jsList\n         * @protected\n         */\n        _renderList: function (jsList) {\n            var itemTmpl,\n                index,\n                tmpl;\n\n            for (index = 0; index < jsList.length; index++) {\n                itemTmpl = $('<li></li>').html($(this.options.templateId).html());\n\n                $(itemTmpl).attr('class', $(this.options.templateId).attr('class'));\n\n                itemTmpl.attr('id', this._getItemId(jsList[index].id));\n\n                tmpl = mageTemplate(itemTmpl.html(), {\n                    data: jsList[index]\n                });\n\n                itemTmpl.html(tmpl);\n\n                itemTmpl.removeClass('no-display');\n                itemTmpl.appendTo(this.element);\n            }\n        },\n\n        /**\n         * Set empty js list\n         *\n         * @protected\n         */\n        _renderEmptyList: function () {\n            var itemTmpl = $('<li></li>').html($(this.options.emptyTemplateId).html());\n\n            $(itemTmpl).attr('class', $(this.options.emptyTemplateId).attr('class'));\n\n            itemTmpl.attr('id', 'empty-js-list');\n            itemTmpl.removeClass('no-display');\n            itemTmpl.appendTo(this.element);\n        }\n    });\n});\n","Magento_Theme/js/bootstrap.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery/fileUploader/jquery.fileupload-ui',\n    'mage/adminhtml/browser',\n    'Magento_Theme/js/form'\n]);\n","Magento_Theme/js/sortable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.sortable'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    /**\n     * Widget panel\n     */\n    $.widget('mage.sortable', $.ui.sortable, {\n        options: {\n            moveUpEvent:   'moveUp',\n            moveDownEvent: 'moveDown'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n            this.initButtons();\n            this.bind();\n        },\n\n        /**\n         * Init buttons.\n         */\n        initButtons: function () {\n            this.element.find('input.up').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveUpEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n            this.element.find('input.down').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveDownEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n        },\n\n        /**\n         * Bind.\n         */\n        bind: function () {\n            var $body = $('body');\n\n            $body.on(this.options.moveUpEvent, $.proxy(this._onMoveUp, this));\n            $body.on(this.options.moveDownEvent, $.proxy(this._onMoveDown, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveUp: function (event, data) {\n            data.item.insertBefore(data.item.prev());\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveDown: function (event, data) {\n            data.item.insertAfter(data.item.next());\n        }\n    });\n\n    return $.mage.sortable;\n});\n","Magento_Theme/js/form/component/robots-reset-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'uiRegistry'\n], function (Button, registry) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            customInstructionField: '${ $.parentName }.custom_instructions',\n            label: '',\n            buttonTpl: 'Magento_Theme/form/element/button'\n        },\n\n        /**\n         * @private\n         * @param {String} json\n         * @return {String}\n         */\n        _parseJson: function (json) {\n            return JSON.parse(json);\n        },\n\n        /**\n         * @param {String} defaultRobotsTxt\n         */\n        reset: function (defaultRobotsTxt) {\n            var customInstructions = registry.get(this.customInstructionField);\n\n            if (customInstructions) {\n                customInstructions.set('value', this._parseJson(defaultRobotsTxt));\n            }\n        }\n    });\n});\n","Magento_AdvancedSearch/js/testconnection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.testConnection', {\n        options: {\n            url: '',\n            elementId: '',\n            successText: '',\n            failedText: '',\n            fieldMapping: ''\n        },\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function () {\n            this._on({\n                'click': $.proxy(this._connect, this)\n            });\n        },\n\n        /**\n         * Method triggers an AJAX request to check search engine connection\n         * @private\n         */\n        _connect: function () {\n            var result = this.options.failedText,\n                element =  $('#' + this.options.elementId),\n                self = this,\n                params = {},\n                msg = '',\n                fieldToCheck = this.options.fieldToCheck || 'success';\n\n            element.removeClass('success').addClass('fail');\n            $.each(JSON.parse(this.options.fieldMapping), function (key, el) {\n                params[key] = $('#' + el).val();\n            });\n            $.ajax({\n                url: this.options.url,\n                showLoader: true,\n                data: params,\n                headers: this.options.headers || {}\n            }).done(function (response) {\n                if (response[fieldToCheck]) {\n                    element.removeClass('fail').addClass('success');\n                    result = self.options.successText;\n                } else {\n                    msg = response.errorMessage;\n\n                    if (msg) {\n                        alert({\n                            content: msg\n                        });\n                    }\n                }\n            }).always(function () {\n                $('#' + self.options.elementId + '_result').text(result);\n            });\n        }\n    });\n\n    return $.mage.testConnection;\n});\n","Magento_ReleaseNotification/js/modal/component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function ($, Modal, alert, $t) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            imports: {\n                logAction:  '${ $.provider }:data.logAction'\n            }\n        },\n\n        /**\n         * Error handler.\n         *\n         * @param {Object} xhr - request result.\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            alert({\n                content: xhr.message || $t('An error occurred while logging process.')\n            });\n        },\n\n        /**\n         * Log release notes show\n         */\n        logReleaseNotesShow: function () {\n            var self = this,\n                data = {\n                    'form_key': window.FORM_KEY\n                };\n\n            $.ajax({\n                type: 'POST',\n                url: this.logAction,\n                data: data,\n                showLoader: true\n            }).done(function (xhr) {\n                if (xhr.error) {\n                    self.onError(xhr);\n                }\n            }).fail(this.onError);\n        },\n\n        /**\n         * Close release notes\n         */\n        closeReleaseNotes: function () {\n            this.logReleaseNotesShow();\n            this.closeModal();\n        }\n    });\n});\n","Magento_Shipping/js/packages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal, $t) {\n    'use strict';\n\n    return function (config, element) {\n        config.buttons = [\n            {\n                text: $t('Print'),\n                'class': 'action action-primary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    window.location.href = this.options.url;\n                }\n            }, {\n                text: $t('Cancel'),\n                'class': 'action action-secondary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }\n        ];\n        modal(config, element);\n    };\n});\n","Magento_Shipping/order/packaging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['prototype'], function () {\n\n    window.Packaging = Class.create();\n    Packaging.prototype = {\n        /**\n         * Initialize object\n         */\n        initialize: function (params) {\n            this.packageIncrement = 0;\n            this.packages = [];\n            this.itemsAll = [];\n            this.createLabelUrl = params.createLabelUrl ? params.createLabelUrl : null;\n            this.itemsGridUrl = params.itemsGridUrl ? params.itemsGridUrl : null;\n            this.errorQtyOverLimit = params.errorQtyOverLimit;\n            this.titleDisabledSaveBtn = params.titleDisabledSaveBtn;\n            this.window = $('packaging_window');\n            this.messages = this.window.select('.message-warning')[0];\n            this.packagesContent = $('packages_content');\n            this.template = $('package_template');\n            this.paramsCreateLabelRequest = {};\n            this.validationErrorMsg = params.validationErrorMsg;\n\n            this.defaultItemsQty            = params.shipmentItemsQty ? params.shipmentItemsQty : null;\n            this.defaultItemsPrice          = params.shipmentItemsPrice ? params.shipmentItemsPrice : null;\n            this.defaultItemsName           = params.shipmentItemsName ? params.shipmentItemsName : null;\n            this.defaultItemsWeight         = params.shipmentItemsWeight ? params.shipmentItemsWeight : null;\n            this.defaultItemsProductId      = params.shipmentItemsProductId ? params.shipmentItemsProductId : null;\n            this.defaultItemsOrderItemId    = params.shipmentItemsOrderItemId ? params.shipmentItemsOrderItemId : null;\n\n            this.shippingInformation = params.shippingInformation ? params.shippingInformation : null;\n            this.thisPage           = params.thisPage ? params.thisPage : null;\n            this.customizableContainers = params.customizable ? params.customizable : [];\n\n            this.eps = 0.000001;\n        },\n\n        /**\n         * Get Package Id\n         */\n        getPackageId: function (packageBlock) {\n            return packageBlock.id.match(/\\d{0,}$/)[0];\n        },\n\n        //******************** Setters **********************************//\n        setLabelCreatedCallback: function (callback) {\n            this.labelCreatedCallback = callback;\n        },\n        setCancelCallback: function (callback) {\n            this.cancelCallback = callback;\n        },\n        setConfirmPackagingCallback: function (callback) {\n            this.confirmPackagingCallback = callback;\n        },\n        setItemQtyCallback: function (callback) {\n            this.itemQtyCallback = callback;\n        },\n        setCreateLabelUrl: function (url) {\n            this.createLabelUrl = url;\n        },\n        setParamsCreateLabelRequest: function (params) {\n            Object.extend(this.paramsCreateLabelRequest, params);\n        },\n        //******************** End Setters *******************************//\n\n        showWindow: function () {\n            if (this.packagesContent.childElements().length == 0) {\n                this.newPackage();\n            }\n            const allowedPackageTypes = [\"N\",\"D\"];\n\n            if (!Object.values(this.customizableContainers).some(packageType => allowedPackageTypes.includes(packageType))) {\n                $('packaging_window').select(\n                    'th.col-length,th.col-width,th.col-height'\n                ).forEach(element => {\n                    element.classList.remove('_required')\n                });\n            }\n            jQuery(this.window).modal('openModal');\n        },\n\n        cancelPackaging: function () {\n            if (Object.isFunction(this.cancelCallback)) {\n                this.cancelCallback();\n            }\n        },\n\n        confirmPackaging: function (params) {\n            if (Object.isFunction(this.confirmPackagingCallback)) {\n                this.confirmPackagingCallback();\n            }\n        },\n\n        checkAllItems: function (headCheckbox) {\n            $(headCheckbox).up('table').select('tbody input[type=\"checkbox\"]').each(function (checkbox) {\n                checkbox.checked = headCheckbox.checked;\n                this._observeQty.call(checkbox);\n            }.bind(this));\n        },\n\n        cleanPackages: function () {\n            this.packagesContent.update();\n            this.packages = [];\n            this.itemsAll = [];\n            this.packageIncrement = 0;\n            this._setAllItemsPackedState();\n            this.messages.hide().update();\n        },\n\n        sendCreateLabelRequest: function () {\n            var self = this;\n\n            if (!this.validate()) {\n                this.messages.show().update(this.validationErrorMsg);\n\n                return;\n            }\n            this.messages.hide().update();\n\n            if (this.createLabelUrl) {\n                var weight, length, width, height = null;\n                var packagesParams = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    weight = parseFloat(pack.select('input[name=\"container_weight\"]')[0].value);\n                    length = parseFloat(pack.select('input[name=\"container_length\"]')[0].value);\n                    width = parseFloat(pack.select('input[name=\"container_width\"]')[0].value);\n                    height = parseFloat(pack.select('input[name=\"container_height\"]')[0].value);\n                    packagesParams[packageId] = {\n                        container:                  pack.select('select[name=\"package_container\"]')[0].value,\n                        customs_value:              parseFloat(pack.select('input[name=\"package_customs_value\"]')[0].value, 10),\n                        weight:                     isNaN(weight) ? '' : weight,\n                        length:                     isNaN(length) ? '' : length,\n                        width:                      isNaN(width) ? '' : width,\n                        height:                     isNaN(height) ? '' : height,\n                        weight_units:               pack.select('select[name=\"container_weight_units\"]')[0].value,\n                        dimension_units:            pack.select('select[name=\"container_dimension_units\"]')[0].value\n                    };\n\n                    if (isNaN(packagesParams[packageId]['customs_value'])) {\n                        packagesParams[packageId]['customs_value'] = 0;\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"package_size\"]')[0]) {\n                        if ('' != pack.select('select[name=\"package_size\"]')[0].value) {\n                            packagesParams[packageId]['size'] = pack.select('select[name=\"package_size\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('input[name=\"container_girth\"]')[0]) {\n                        if ('' != pack.select('input[name=\"container_girth\"]')[0].value) {\n                            packagesParams[packageId]['girth'] = pack.select('input[name=\"container_girth\"]')[0].value;\n                            packagesParams[packageId]['girth_dimension_units'] = pack.select('select[name=\"container_girth_dimension_units\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"content_type\"]')[0] && 'undefined' != typeof pack.select('input[name=\"content_type_other\"]')[0]) {\n                        packagesParams[packageId]['content_type'] = pack.select('select[name=\"content_type\"]')[0].value;\n                        packagesParams[packageId]['content_type_other'] = pack.select('input[name=\"content_type_other\"]')[0].value;\n                    } else {\n                        packagesParams[packageId]['content_type'] = '';\n                        packagesParams[packageId]['content_type_other'] = '';\n                    }\n                    var deliveryConfirmation = pack.select('select[name=\"delivery_confirmation_types\"]');\n\n                    if (deliveryConfirmation.length) {\n                        packagesParams[packageId]['delivery_confirmation'] =  deliveryConfirmation[0].value;\n                    }\n                }.bind(this));\n\n                for (var packageId in this.packages) {\n                    if (!isNaN(packageId)) {\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[container]']              = packagesParams[packageId]['container'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight]']                 = packagesParams[packageId]['weight'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[customs_value]']          = packagesParams[packageId]['customs_value'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[length]']                 = packagesParams[packageId]['length'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[width]']                  = packagesParams[packageId]['width'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[height]']                 = packagesParams[packageId]['height'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight_units]']           = packagesParams[packageId]['weight_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[dimension_units]']        = packagesParams[packageId]['dimension_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type]']           = packagesParams[packageId]['content_type'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type_other]']     = packagesParams[packageId]['content_type_other'];\n\n                        if ('undefined' != typeof packagesParams[packageId]['size']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[size]'] = packagesParams[packageId]['size'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['girth']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth]'] = packagesParams[packageId]['girth'];\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth_dimension_units]'] = packagesParams[packageId]['girth_dimension_units'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['delivery_confirmation']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[delivery_confirmation]']  = packagesParams[packageId]['delivery_confirmation'];\n                        }\n\n                        for (var packedItemId in this.packages[packageId]['items']) {\n                            if (!isNaN(packedItemId)) {\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][qty]']           = this.packages[packageId]['items'][packedItemId]['qty'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][customs_value]'] = this.packages[packageId]['items'][packedItemId]['customs_value'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][price]']         = self.defaultItemsPrice[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][name]']          = self.defaultItemsName[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][weight]']        = self.defaultItemsWeight[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][product_id]']    = self.defaultItemsProductId[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][order_item_id]'] = self.defaultItemsOrderItemId[packedItemId];\n                            }\n                        }\n                    }\n                }\n\n                new Ajax.Request(this.createLabelUrl, {\n                    parameters: this.paramsCreateLabelRequest,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.messages.show().innerHTML = response.message;\n                            } else if (response.ok && Object.isFunction(this.labelCreatedCallback)) {\n                                this.labelCreatedCallback(response);\n                            }\n                        }\n                    }.bind(this)\n                });\n\n                if (this.paramsCreateLabelRequest['code'] &&\n                    this.paramsCreateLabelRequest['carrier_title'] &&\n                    this.paramsCreateLabelRequest['method_title'] &&\n                    this.paramsCreateLabelRequest['price']\n                ) {\n                    var a = this.paramsCreateLabelRequest['code'];\n                    var b = this.paramsCreateLabelRequest['carrier_title'];\n                    var c = this.paramsCreateLabelRequest['method_title'];\n                    var d = this.paramsCreateLabelRequest['price'];\n\n                    this.paramsCreateLabelRequest = {};\n                    this.paramsCreateLabelRequest['code']           = a;\n                    this.paramsCreateLabelRequest['carrier_title']  = b;\n                    this.paramsCreateLabelRequest['method_title']   = c;\n                    this.paramsCreateLabelRequest['price']          = d;\n                } else {\n                    this.paramsCreateLabelRequest = {};\n                }\n            }\n        },\n\n        validate: function () {\n            var dimensionElements = $('packaging_window').select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],input[name=container_girth]:not(\"._disabled\")'\n            );\n            var callback = null;\n\n            if (dimensionElements.any(function (element) {\n                return !!element.value;\n            })) {\n                callback = function (element) {\n                    $(element).addClassName('required-entry');\n                };\n            } else {\n                callback = function (element) {\n                    $(element).removeClassName('required-entry');\n                };\n            }\n            dimensionElements.each(callback);\n\n            const allowedPackageTypes = [\"N\",\"D\"];\n\n            if (Object.values(this.customizableContainers).some(packageType => allowedPackageTypes.includes(packageType))) {\n                dimensionElements.each(function(element) {\n                    $(element).addClassName('required-entry');\n                });\n            }\n\n            return result = $$('[id^=\"package_block_\"]      input').collect(function (element) {\n                return this.validateElement(element);\n            }, this).all();\n        },\n\n        validateElement: function (elm) {\n            var cn = $w(elm.className);\n\n            return result = cn.all(function (value) {\n                var v = Validation.get(value);\n\n                if (Validation.isVisible(elm) && !v.test($F(elm), elm)) {\n                    $(elm).addClassName('validation-failed');\n\n                    return false;\n                }\n                $(elm).removeClassName('validation-failed');\n\n                return true;\n\n            });\n        },\n\n        validateCustomsValue: function () {\n            var items = [];\n            var isValid = true;\n            var itemsPrepare = [];\n            var itemsPacked = [];\n\n            this.packagesContent.childElements().each(function (pack) {\n                itemsPrepare = pack.select('[data-role=\"package-items\"]')[0];\n\n                if (itemsPrepare) {\n                    items = items.concat(itemsPrepare.select('.grid tbody tr'));\n                }\n                itemsPacked = pack.select('.package_items')[0];\n\n                if (itemsPacked) {\n                    items = items.concat(itemsPacked.select('.grid tbody tr'));\n                }\n            });\n\n            items.each(function (item) {\n                var itemCustomsValue = item.select('[name=\"customs_value\"]')[0];\n\n                if (!this.validateElement(itemCustomsValue)) {\n                    isValid = false;\n                }\n            }.bind(this));\n\n            if (isValid) {\n                this.messages.hide().update();\n            } else {\n                this.messages.show().update(this.validationErrorMsg);\n            }\n\n            return isValid;\n        },\n\n        newPackage: function () {\n            var pack = this.template.cloneNode(true);\n\n            pack.id = 'package_block_' + ++this.packageIncrement;\n            pack.addClassName('package-block');\n            pack.select('[data-role=package-number]')[0].update(this.packageIncrement);\n            this.packagesContent.insert({\n                top: pack\n            });\n            pack.select('[data-action=package-save-items]')[0].hide();\n            pack.show();\n        },\n\n        deletePackage: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId];\n            pack.remove();\n            this.messages.hide().update();\n            this._setAllItemsPackedState();\n        },\n\n        deleteItem: function (obj) {\n            var item = $(obj).up('tr');\n            var itemId = item.select('[type=\"checkbox\"]')[0].value;\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId]['items'][itemId];\n\n            if (item.offsetParent.rows.length <= 2) { /* head + this last row */\n                $(packItems).hide();\n            }\n            item.remove();\n            this.messages.hide().update();\n            this._recalcContainerWeightAndCustomsValue(packItems);\n            this._setAllItemsPackedState();\n        },\n\n        recalcContainerWeightAndCustomsValue: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n\n            if (packItems) {\n                if (!this.validateCustomsValue()) {\n                    return;\n                }\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            }\n        },\n\n        getItemsForPack: function (obj) {\n            if (this.itemsGridUrl) {\n                var parameters = $H({\n                    'shipment_id': this.shipmentId\n                });\n                var packageBlock = $(obj).up('[id^=\"package_block\"]');\n                var packagePrapare = packageBlock.select('[data-role=package-items]')[0];\n                var packagePrapareGrid = packagePrapare.select('.grid_prepare')[0];\n\n                new Ajax.Request(this.itemsGridUrl, {\n                    parameters: parameters,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response) {\n                            packagePrapareGrid.update(response);\n                            this.processPackagePrepare(packagePrapareGrid);\n\n                            if (packagePrapareGrid.select('.grid tbody tr').length) {\n                                packageBlock.select('[data-action=package-add-items]')[0].hide();\n                                packageBlock.select('[data-action=package-save-items]')[0].show();\n                                packagePrapare.show();\n                            } else {\n                                packagePrapareGrid.update();\n                            }\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        getPackedItemsQty: function () {\n            var items = [];\n\n            for (var packageId in this.packages) {\n                if (!isNaN(packageId)) {\n                    for (var packedItemId in this.packages[packageId]['items']) {\n                        if (!isNaN(packedItemId)) {\n                            if (items[packedItemId]) {\n                                items[packedItemId] += this.packages[packageId]['items'][packedItemId]['qty'];\n                            } else {\n                                items[packedItemId] = this.packages[packageId]['items'][packedItemId]['qty'];\n                            }\n                        }\n                    }\n                }\n            }\n\n            return items;\n        },\n\n        _parseQty: function (obj) {\n            var qty = $(obj).hasClassName('qty-decimal') ? parseFloat(obj.value) : parseInt(obj.value);\n\n            if (isNaN(qty) || qty <= 0) {\n                qty = 1;\n            }\n\n            return qty;\n        },\n\n        packItems: function (obj) {\n            var anySelected = false;\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var packagePrepare = packageBlock.select('[data-role=package-items]')[0];\n            var packagePrepareGrid = packagePrepare.select('.grid_prepare')[0];\n\n            // check for exceeds the total shipped quantity\n            var checkExceedsQty = false;\n\n            this.messages.hide().update();\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n                var itemId = checkbox.value;\n                var qtyValue  = this._parseQty(item.select('[name=\"qty\"]')[0]);\n\n                item.select('[name=\"qty\"]')[0].value = qtyValue;\n\n                if (checkbox.checked && this._checkExceedsQty(itemId, qtyValue)) {\n                    this.messages.show().update(this.errorQtyOverLimit);\n                    checkExceedsQty = true;\n                }\n            }.bind(this));\n\n            if (checkExceedsQty) {\n                return;\n            }\n\n            if (!this.validateCustomsValue()) {\n                return;\n            }\n\n            // prepare items for packing\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n\n                if (checkbox.checked) {\n                    var qty  = item.select('[name=\"qty\"]')[0];\n                    var qtyValue  = this._parseQty(qty);\n\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                    anySelected = true;\n                    qty.disabled = 'disabled';\n                    checkbox.disabled = 'disabled';\n                    packagePrepareGrid.select('.grid th [type=\"checkbox\"]')[0].up('th label').hide();\n                    item.select('[data-action=package-delete-item]')[0].show();\n                } else {\n                    item.remove();\n                }\n            }.bind(this));\n\n            // packing items\n            if (anySelected) {\n                var packItems = packageBlock.select('.package_items')[0];\n\n                if (!packItems) {\n                    packagePrepare.insert(new Element('div').addClassName('grid_prepare'));\n                    packagePrepare.insert({\n                        after: packagePrepareGrid\n                    });\n                    packItems = packagePrepareGrid.removeClassName('grid_prepare').addClassName('package_items');\n                    packItems.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]) {\n                            this.packages[packageId] = {\n                                'items': [], 'params': {}\n                            };\n                        }\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                        }\n                    }.bind(this));\n                } else {\n                    packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                            packItems.select('.grid tbody')[0].insert(item);\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                            var packItem = packItems.select('[type=\"checkbox\"][value=\"' + itemId + '\"]')[0].up('tr').select('[name=\"qty\"]')[0];\n\n                            packItem.value = this.packages[packageId]['items'][itemId]['qty'];\n                        }\n                    }.bind(this));\n                    packagePrepareGrid.update();\n                }\n                $(packItems).show();\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            } else {\n                packagePrepareGrid.update();\n            }\n\n            // show/hide disable/enable\n            packagePrepare.hide();\n            packageBlock.select('[data-action=package-save-items]')[0].hide();\n            packageBlock.select('[data-action=package-add-items]')[0].show();\n            this._setAllItemsPackedState();\n        },\n\n        validateItemQty: function (itemId, qty) {\n            return this.defaultItemsQty[itemId] < qty ? this.defaultItemsQty[itemId] : qty;\n        },\n\n        changeMeasures: function (obj) {\n            var incr = 0;\n            var incrSelected = 0;\n\n            obj.childElements().each(function (option) {\n                if (option.selected) {\n                    incrSelected = incr;\n                }\n                incr++;\n            });\n\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n\n            packageBlock.select('.measures').each(function (item) {\n                if (item.name != obj.name) {\n                    var incr = 0;\n\n                    item.select('option').each(function (option) {\n                        if (incr == incrSelected) {\n                            item.value = option.value;\n                            //option.selected = true\n                        }\n                        incr++;\n                    });\n                }\n            });\n\n        },\n\n        checkSizeAndGirthParameter: function (obj, enabled) {\n            if (enabled == 0) {\n                return;\n            }\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            var packageSize = currentNode.select('select[name=package_size]');\n            var packageContainer = currentNode.select('select[name=package_container]');\n            var packageGirth = currentNode.select('input[name=container_girth]');\n            var packageGirthDimensionUnits = currentNode.select('select[name=container_girth_dimension_units]');\n\n            if (packageSize.length <= 0) {\n                return;\n            }\n\n            var girthEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'VARIABLE';\n\n            if (!girthEnabled) {\n                packageGirth[0].value = '';\n                packageGirth[0].disable();\n                packageGirth[0].addClassName('_disabled');\n                packageGirthDimensionUnits[0].disable();\n                packageGirthDimensionUnits[0].addClassName('_disabled');\n            } else {\n                packageGirth[0].enable();\n                packageGirth[0].removeClassName('_disabled');\n                packageGirthDimensionUnits[0].enable();\n                packageGirthDimensionUnits[0].removeClassName('_disabled');\n            }\n\n            var sizeEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'RECTANGULAR' ||\n                packageContainer[0].value == 'VARIABLE';\n\n            if (!sizeEnabled) {\n                option = document.createElement('OPTION');\n                option.value = '';\n                option.text = '';\n                packageSize[0].options.add(option);\n                packageSize[0].value = '';\n                packageSize[0].disable();\n                packageSize[0].addClassName('_disabled');\n            } else {\n                for (i = 0; i < packageSize[0].length; i++) {\n                    if (packageSize[0].options[i].value == '') {\n                        packageSize[0].removeChild(packageSize[0].options[i]);\n                    }\n                }\n                packageSize[0].enable();\n                packageSize[0].removeClassName('_disabled');\n            }\n        },\n\n        changeContainerType: function (obj) {\n            if (this.customizableContainers.length <= 0) {\n                return;\n            }\n\n            var disable = true;\n\n            for (var i in this.customizableContainers) {\n                if (this.customizableContainers[i] == obj.value) {\n                    disable = false;\n                    break;\n                }\n            }\n\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            $(currentNode).select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],select[name=container_dimension_units]'\n            ).each(function (inputElement) {\n                if (disable) {\n                    Form.Element.disable(inputElement);\n                    inputElement.addClassName('_disabled');\n\n                    if (inputElement.nodeName == 'INPUT') {\n                        $(inputElement).value = '';\n                    }\n                } else {\n                    Form.Element.enable(inputElement);\n                    inputElement.removeClassName('_disabled');\n                }\n            });\n        },\n\n        changeContentTypes: function (obj) {\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var contentType = packageBlock.select('[name=content_type]')[0];\n            var contentTypeOther = packageBlock.select('[name=content_type_other]')[0];\n\n            if (contentType.value == 'OTHER') {\n                Form.Element.enable(contentTypeOther);\n                contentTypeOther.removeClassName('_disabled');\n            } else {\n                Form.Element.disable(contentTypeOther);\n                contentTypeOther.addClassName('_disabled');\n            }\n\n        },\n\n        //******************** Private functions **********************************//\n        _getItemsCount: function (items) {\n            var count = 0;\n\n            items.each(function (itemCount) {\n                if (!isNaN(itemCount)) {\n                    count += parseFloat(itemCount);\n                }\n            });\n\n            return count;\n        },\n\n        /**\n         * Show/hide disable/enable buttons in case of all items packed state\n         */\n        _setAllItemsPackedState: function () {\n            var addPackageBtn = $$('[data-action=add-packages]')[0];\n            var savePackagesBtn = $$('[data-action=save-packages]')[0];\n\n            if (this._getItemsCount(this.itemsAll) > 0 &&\n                    this._checkExceedsQtyFinal(this._getItemsCount(this.getPackedItemsQty()), this._getItemsCount(this.itemsAll))\n            ) {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.disabled = 'disabled';\n                    button.addClassName('_disabled');\n                });\n                addPackageBtn.addClassName('_disabled');\n                Form.Element.disable(addPackageBtn);\n                savePackagesBtn.removeClassName('_disabled');\n                Form.Element.enable(savePackagesBtn);\n                savePackagesBtn.title = '';\n\n                // package number recalculation\n                var packagesRecalc = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    if (!pack.select('.package_items .grid tbody tr').length) {\n                        pack.remove();\n                    }\n                });\n                var packagesCount = this.packagesContent.childElements().length;\n\n                this.packageIncrement = packagesCount;\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    pack.id = 'package_block_' + packagesCount;\n                    pack.select('[data-role=package-number]')[0].update(packagesCount);\n                    packagesRecalc[packagesCount] = this.packages[packageId];\n                    --packagesCount;\n                }.bind(this));\n                this.packages = packagesRecalc;\n\n            } else {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.removeClassName('_disabled');\n                    Form.Element.enable(button);\n                });\n                addPackageBtn.removeClassName('_disabled');\n                Form.Element.enable(addPackageBtn);\n                savePackagesBtn.addClassName('_disabled');\n                Form.Element.disable(savePackagesBtn);\n                savePackagesBtn.title = this.titleDisabledSaveBtn;\n            }\n        },\n\n        processPackagePrepare: function (packagePrepare) {\n            var itemsAll = [],\n                qty,\n                itemId,\n                qtyValue = 0,\n                value = 1;\n\n            packagePrepare.select('.grid tbody tr').each(function (item) {\n                qty = item.select('[name=\"qty\"]')[0],\n                    itemId = item.select('[type=\"checkbox\"]')[0].value,\n                    qtyValue = parseFloat(qty.value);\n\n                if (Object.isFunction(this.itemQtyCallback)) {\n                    value = this.itemQtyCallback(itemId);\n\n                    if (typeof value !== 'undefined') {\n                        qtyValue = parseFloat(value);\n                        qtyValue = this.validateItemQty(itemId, qtyValue);\n                        qty.value = qtyValue;\n                    }\n                } else {\n                    value = item.select('[name=\"qty\"]')[0].value;\n                    qtyValue = typeof value == 'string' && value.length == 0 ? 0 : parseFloat(value);\n\n                    if (isNaN(qtyValue) || qtyValue < 0) {\n                        qtyValue = 1;\n                    }\n                }\n\n                if (qtyValue == 0) {\n                    item.remove();\n\n                    return;\n                }\n                var packedItems = this.getPackedItemsQty();\n\n                itemsAll[itemId] = qtyValue;\n\n                for (var packedItemId in packedItems) {\n                    if (!isNaN(packedItemId)) {\n                        var packedQty = packedItems[packedItemId];\n\n                        if (itemId == packedItemId) {\n                            if (qtyValue == packedQty || qtyValue <= packedQty) {\n                                item.remove();\n                            } else if (qtyValue > packedQty) {\n                                /* fix float number precision */\n                                qty.value = Number(Number(Math.round(qtyValue - packedQty + 'e+4') + 'e-4').toFixed(4));\n                            }\n                        }\n                    }\n                }\n            }.bind(this));\n\n            if (!this.itemsAll.length) {\n                this.itemsAll = itemsAll;\n            }\n\n            packagePrepare.select('tbody input[type=\"checkbox\"]').each(function (item) {\n                $(item).observe('change', this._observeQty);\n                this._observeQty.call(item);\n            }.bind(this));\n        },\n\n        _observeQty: function () {\n            /** this = input[type=\"checkbox\"] */\n            var tr  = jQuery(this).closest('tr')[0],\n                qty = $(tr.cells[tr.cells.length - 1]).select('input[name=\"qty\"]')[0];\n\n            if (qty.disabled = !this.checked) {\n                $(qty).addClassName('_disabled');\n            } else {\n                $(qty).removeClassName('_disabled');\n            }\n        },\n\n        _checkExceedsQty: function (itemId, qty) {\n            var packedItemQty = this.getPackedItemsQty()[itemId] ? this.getPackedItemsQty()[itemId] : 0;\n            var allItemQty = this.itemsAll[itemId];\n\n            return qty * (1 - this.eps) > allItemQty *  (1 + this.eps)  - packedItemQty * (1 - this.eps);\n        },\n\n        _checkExceedsQtyFinal: function (checkOne, defQty) {\n            return checkOne * (1 + this.eps) >= defQty * (1 - this.eps);\n        },\n\n        _recalcContainerWeightAndCustomsValue: function (container) {\n            var packageBlock = container.up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var containerWeight = packageBlock.select('[name=\"container_weight\"]')[0];\n            var containerCustomsValue = packageBlock.select('[name=\"package_customs_value\"]')[0];\n\n            containerWeight.value = 0;\n            containerCustomsValue.value = 0;\n            container.select('.grid tbody tr').each(function (item) {\n                var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                if (isNaN(qtyValue) || qtyValue <= 0) {\n                    qtyValue = 1;\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                }\n                var itemWeight = parseFloat(this._getElementText(item.select('[data-role=item-weight]')[0]));\n\n                containerWeight.value = parseFloat(containerWeight.value) + itemWeight * qtyValue;\n                var itemCustomsValue = parseFloat(item.select('[name=\"customs_value\"]')[0].value) || 0;\n\n                containerCustomsValue.value = parseFloat(containerCustomsValue.value) + itemCustomsValue * qtyValue;\n                this.packages[packageId]['items'][itemId]['customs_value'] = itemCustomsValue;\n            }.bind(this));\n            containerWeight.value = parseFloat(parseFloat(Math.round(containerWeight.value + 'e+4') + 'e-4').toFixed(4));\n            containerCustomsValue.value = parseFloat(Math.round(containerCustomsValue.value + 'e+2') + 'e-2').toFixed(2);\n\n            if (containerCustomsValue.value == 0) {\n                containerCustomsValue.value = '';\n            }\n        },\n\n        _getElementText: function (el) {\n            if ('string' == typeof el.textContent) {\n                return el.textContent;\n            }\n\n            if ('string' == typeof el.innerText) {\n                return el.innerText;\n            }\n\n            return el.innerHTML.replace(/<[^>]*>/g, '');\n        }\n        //******************** End Private functions ******************************//\n    };\n\n});\n","Magento_AdminAdobeIms/postcss.config.js":"module.exports = {\n    plugins: [\n        require('postcss-import'),\n        require('postcss-varfallback'),\n        require('postcss-dropunusedvars'),\n        require('cssnano')\n    ]\n};\n","Magento_AdminAdobeIms/js/admin_adobe_ims_load_icons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_AdminAdobeIms/js/loadicons'\n], function ($, _, loadicons) {\n    'use strict';\n\n    var icons = {},\n\n    loadIcons = {\n        /**\n         * loadicons initialization\n         */\n        init: function () {\n            loadicons(icons.spectrumCssIcons);\n            loadicons(icons.spectrumIcons);\n        },\n\n        /**\n         * @param {Object} iconUrls\n         * @constructor\n         */\n        'Magento_AdminAdobeIms/js/admin_adobe_ims_load_icons': function (iconUrls) {\n            icons = iconUrls;\n            loadIcons.init();\n        }\n    };\n\n    return loadIcons;\n});\n","Magento_AdminAdobeIms/js/adobe-ims-reauth.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_AdobeIms/js/action/authorization'\n], function (Component, $, login) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            loginConfig: {\n                url: 'https://ims-na1-stg.adobelogin.com/ims/authorize',\n                callbackParsingParams: {\n                    regexpPattern: /auth\\[code=(success|error);message=(.+)\\]/,\n                    codeIndex: 1,\n                    messageIndex: 2,\n                    nameIndex: 3,\n                    successCode: 'success',\n                    errorCode: 'error'\n                },\n                popupWindowParams: {\n                    width: 500,\n                    height: 600,\n                    top: 100,\n                    left: 300\n                },\n                popupWindowTimeout: 60000\n            }\n        },\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.login();\n        },\n\n        /**\n         * Open popup for Adobe reauth\n         *\n         * @return {window.Promise}\n         */\n        login: function () {\n            var deferred = $.Deferred(),\n                loginConfig = this.loginConfig;\n\n            $('input.ims_verification').on('click', function () {\n                login(loginConfig)\n                    .then(function (response) {\n                        if (response.isAuthorized === true) {\n                            $('input.ims_verified').val(true);\n                        }\n                        deferred.resolve(response);\n                    })\n                    .fail(function (error) {\n                        deferred.reject(error);\n                    });\n            });\n\n            return deferred.promise();\n        }\n    });\n});\n","Magento_AdminAdobeIms/js/loadicons.js":"/*\nCopyright 2018 Adobe. All rights reserved.\nThis file is licensed to you under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License. You may obtain a copy\nof the License at http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software distributed under\nthe License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS\nOF ANY KIND, either express or implied. See the License for the specific language\ngoverning permissions and limitations under the License.\n*/\n\n// UMD pattern via umdjs\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    // AMD\n    define([], factory);\n  }\n  else if (typeof module === 'object' && module.exports) {\n    // CommonJS-like\n    module.exports = factory();\n  }\n  else {\n    // Browser\n    root.loadIcons = factory();\n  }\n}(typeof self !== 'undefined' ? self : this, function() {\n  function handleError(string) {\n    string = 'loadIcons: '+string;\n    var error = new Error(string);\n\n    console.error(error.toString());\n\n    if (typeof callback === 'function') {\n      callback(error);\n    }\n  }\n\n  function injectSVG(svgURL, callback) {\n    var error;\n    // 200 for web servers, 0 for CEP panels\n    if (this.status !== 200 && this.status !== 0) {\n      handleError('Failed to fetch icons, server returned ' + this.status);\n      return;\n    }\n\n    // Parse the SVG\n    var parser = new DOMParser();\n    try {\n      var doc = parser.parseFromString(this.responseText, 'image/svg+xml');\n      var svg = doc.firstChild;\n    }\n    catch (err) {\n      handleError('Error parsing SVG: ' + err);\n      return;\n    }\n\n    // Make sure a real SVG was returned\n    if (svg && svg.tagName === 'svg') {\n      // Hide the element\n      svg.style.display = 'none';\n\n      svg.setAttribute('data-url', svgURL);\n\n      // Insert it into the head\n      document.head.insertBefore(svg, null);\n\n      // Pass the SVG to the callback\n      if (typeof callback === 'function') {\n        callback(null, svg);\n      }\n    }\n    else {\n      handleError('Parsed SVG document contained something other than an SVG');\n    }\n  }\n\n  function loadIcons(svgURL, callback) {\n    // Request the SVG sprite\n    var req = new XMLHttpRequest();\n    req.open('GET', svgURL, true);\n    req.addEventListener('load', injectSVG.bind(req, svgURL, callback));\n    req.addEventListener('error', function(event) {\n      handleError('Request failed');\n    });\n    req.send();\n  }\n\n  return loadIcons;\n}));\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_InventoryAdminUi/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/region'\n], function (Region) {\n    'use strict';\n\n    return Region.extend({\n        defaults: {\n            regionScope: 'data.general.region'\n        },\n\n        /**\n         * Set region to source form\n         *\n         * @param {String} value - region\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (parseFloat(value)) {\n                this.source.set(this.regionScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_InventoryAdminUi/js/stock/grid/dynamic-rows/assigned-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid'\n], function (_, dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n        defaults: {\n            cacheGridDataIndex: []\n        },\n\n        /**\n         * Performance optimization of setting initial property to records data of only first page\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            var startIndex,\n                stopIndex;\n\n            if (_.isArray(this.recordData())) {\n                startIndex = (~~this.currentPage() - 1) * this.pageSize;\n                stopIndex = startIndex + parseInt(this.pageSize, 10);\n                this.recordData.each(function (data, index) {\n                    if (index < stopIndex) {\n                        this.source.set(this.dataScope + '.' + this.index + '.' + index + '.initialize', true);\n                    }\n                }, this);\n            }\n\n            return this;\n        },\n\n        /**\n         * Performance optimization of checking changed records\n         * skip when checks are not necessary\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                changes = [],\n                dataIndex = [],\n                changesIndex = [];\n\n            if (cacheLength === curData || cacheLength > curData) {\n                return [];\n            }\n\n            if (!cacheLength) {\n                return data;\n            }\n            data.forEach(function (record, index) {\n                dataIndex[index] = record[this.map[this.identificationDRProperty]];\n            }, this);\n            changesIndex = _.difference(dataIndex, this.cacheGridDataIndex);\n            changesIndex.forEach(function (changeIndex) {\n                data.forEach(function (record, index) {\n                    if (changeIndex === record[this.map[this.identificationDRProperty]]) {\n                        changes.push(data[index]);\n                    }\n                }, this);\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Performance optimization of processing insert data\n         *\n         * @param {Object} data\n         */\n        processingInsertData: function (data) {\n            this._super(data);\n            data.forEach(function (record, index) {\n                this.cacheGridDataIndex[index] = record[this.map[this.identificationDRProperty]];\n            }, this);\n        }\n    });\n});\n","Magento_InventoryAdminUi/js/stock/grid/cell/assigned-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryAdminUi/stock/grid/cell/assigned-sources-cell.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         *\n         * @param {Array} record\n         * @returns {Array}\n         */\n        getTooltipData: function (record) {\n            return record[this.index].map(function (source) {\n                return {\n                    sourceCode: source.sourceCode,\n                    name: source.name\n                };\n            });\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourcesAssignedToStockOrderedByPriority: function (record) {\n            return this.getTooltipData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_InventoryInStorePickupAdminUi/js/form/components/fieldset.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'ko'\n], function (Fieldset, ko) {\n    'use strict';\n\n    /**\n     * TODO Remove when issue is resolved in core.\n     * @see Please check issue in core for more details: https://github.com/magento/magento2/issues/22067.\n     */\n    return Fieldset.extend(ko).extend(\n        {\n            /**\n             * Convert `visible` value from string ('1', '0') to bool (true, false)\n             */\n            initialize: function () {\n                this._super();\n\n                // eslint-disable-next-line vars-on-top\n                var visible = this.visible;\n\n                this.visible = ko.computed({\n                    /**\n                     * @returns {Boolean}\n                     */\n                    read: function () {\n                        return visible();\n                    },\n\n                    /**\n                     * @param {String} value\n                     */\n                    write: function (value) {\n                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));\n                        visible(value);\n                    },\n                    owner: this\n                });\n                this.visible(visible());\n            }\n        }\n    );\n});\n","Magento_InventoryInStorePickupAdminUi/js/form/element/conditional-required.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'ko',\n    'underscore',\n    'mageUtils'\n], function (uiElement, ko, _, utils) {\n    'use strict';\n\n    /**\n     * Provide possibility to make field required by dependency on other field value.\n     */\n    return uiElement.extend(\n        {\n            /**\n             * Convert `required` value from string ('1', '0') to bool (true, false)\n             */\n            initialize: function () {\n                this._super();\n\n                // eslint-disable-next-line vars-on-top\n                var required = this.required;\n\n                this.required = ko.computed({\n                    /**\n                     * @returns {Boolean}\n                     */\n                    read: function () {\n                        return required();\n                    },\n\n                    /**\n                     * @param {String|Boolean} value\n                     */\n                    write: function (value) {\n                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));\n\n                        if (required() !== value) {\n                            required(value);\n                            this.setValidation('required-entry', required());\n                        }\n                    },\n                    owner: this\n                });\n                this.required(required());\n            },\n\n            /**\n             * @param {(String|Object)} rule\n             * @param {(Object|Boolean)} [options]\n             * @returns {Abstract} Chainable.\n             */\n            setValidation: function (rule, options) {\n                var rules = utils.copy(this.validation),\n                    changed;\n\n                if (_.isObject(rule)) {\n                    _.extend(this.validation, rule);\n                } else {\n                    this.validation[rule] = options;\n                }\n\n                changed = !utils.compare(rules, this.validation).equal;\n\n                if (changed) {\n                    this.required(!!this.validation['required-entry']);\n                    this.validate();\n                }\n\n                return this;\n            }\n        }\n    );\n});\n","PayPal_Braintree/js/system.js":"require(['jquery', 'Magento_Ui/js/modal/alert', 'mage/translate', 'domReady!'], function ($, alert, $t) {\n    function disablePayLaterMessages()\n    {\n        let merchantCountry = $('[data-ui-id=\"adminhtml-system-config-field-country-0-select-groups-account-fields-merchant-country-value\"]').val();\n        let payPalCredit = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-fields-braintree-paypal-credit-active-value\"]').val();\n        let cart = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-cart-fields-message-cart-enable-value\"]');\n        let product = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-checkout-fields-message-checkout-enable-value\"]')\n        let checkout = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-productpage-fields-message-productpage-enable-value\"]')\n        let allowedCountries = ['GB', 'FR', 'US', 'DE', 'AU'];\n\n        if($.inArray(merchantCountry, allowedCountries) === -1 || payPalCredit === 1){\n            //hide pay later message\n            cart.val(0).attr('readonly',true).click();\n            product.val(0).attr('readonly',true).click();\n            checkout.val(0).attr('readonly',true).click();\n        }\n        if (merchantCountry) {\n            if ( merchantCountry === 'GB') {\n                merchantCountry = 'UK'\n            }\n            cart.next().find('a').attr('href', cart.next().find('a').attr('href') + merchantCountry.toLowerCase());\n            product.next().find('a').attr('href', product.next().find('a').attr('href') + merchantCountry.toLowerCase());\n            checkout.next().find('a').attr('href', checkout.next().find('a').attr('href') + merchantCountry.toLowerCase());\n        }\n\n    }\n\n    window.braintreeValidator = function (endpoint, environmentId, skip = false) {\n        environmentId = $('[data-ui-id=\"' + environmentId + '\"]').val();\n\n        let merchantId = '', publicId = '', privateId = '';\n\n        if (environmentId === 'sandbox') {\n            merchantId = $('[data-ui-id=\"text-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-merchant-id-value\"]').val();\n            publicId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-public-key-value\"]').val();\n            privateId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-private-key-value\"]').val();\n        } else {\n            merchantId = $('[data-ui-id=\"text-groups-braintree-section-groups-braintree-groups-braintree-required-fields-merchant-id-value\"]').val();\n            publicId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-public-key-value\"]').val();\n            privateId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-private-key-value\"]').val();\n        }\n\n        /* Remove previous success message if present */\n        if ($(\".braintree-credentials-success-message\")) {\n            $(\".braintree-credentials-success-message\").remove();\n        }\n\n        /* Basic field validation */\n        var errors = [];\n\n        if (!environmentId || environmentId !== 'sandbox' && environmentId !== 'production') {\n            errors.push($t(\"Please select an Environment\"));\n        }\n\n        if (!merchantId) {\n            errors.push($t(\"Please enter a Merchant ID\"));\n        }\n\n        if (!publicId) {\n            errors.push($t('Please enter a Public Key'));\n        }\n\n        if (!privateId) {\n            errors.push($t('Please enter a Private Key'));\n        }\n\n        if (errors.length > 0) {\n            alert({\n                title: $t('Braintree Credential Validation Failed'),\n                content:  errors.join('<br />')\n            });\n            return false;\n        }\n\n        $(this).text($t(\"We're validating your credentials...\")).attr('disabled', true);\n\n        var self = this;\n        $.ajax({\n            type: 'POST',\n            url: endpoint,\n            data: {\n                environment: environmentId,\n                merchant_id: merchantId,\n                public_key: publicId,\n                private_key: privateId\n            },\n            showLoader: true,\n            success: function (result) {\n                if (result.success === 'true') {\n                    if (skip === true) {\n                        $('<div class=\"message message-success braintree-credentials-success-message\">' + $t(\"Your credentials are valid.\") + '</div>').insertAfter($('.paypal-styling-buttons'));\n                    } else {\n                        $('<div class=\"message message-success braintree-credentials-success-message\">' + $t(\"Your credentials are valid.\") + '</div>').insertAfter(self);\n                    }\n                } else {\n                    alert({\n                        title: $t('Braintree Credential Validation Failed'),\n                        content: $t('Your Braintree Credentials could not be validated. Please ensure you have selected the correct environment and entered a valid Merchant ID, Public Key and Private Key.')\n                    });\n                }\n            }\n        }).always(function () {\n            $(self).text($t(\"Validate Credentials\")).attr('disabled', false);\n        });\n    };\n\n    window.applyForAll = function () {\n        let buttonShowStatus = '', buttonLabel = '', buttonColor = '', buttonShape = '', buttonSize = '';\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n\n        let location = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]').val();\n        let buttonType = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-fields-paypal-location-' + location + '-button-type-value\"]').val();\n        buttonShowStatus = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-show-value\"]').val();\n        buttonLabel = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-label-value\"]').val();\n        buttonColor = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-color-value\"]').val();\n        buttonShape = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-shape-value\"]').val();\n        buttonSize = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-size-value\"]').val();\n\n        // pay later messaging styling field values\n        let messagingShow = $('.' + location + '-messaging-show').val();\n        let messagingLayout = $('.' + location + '-messaging-layout').val();\n        let messagingLogo = $('.' + location + '-messaging-logo').val();\n        let messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n        let messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').val(buttonShowStatus).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').val(buttonLabel).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').val(buttonColor).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').val(buttonShape).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').val(buttonSize).click();\n            });\n\n            // apply pay later messaging styling for all locations\n            $('.' + loc + '-messaging-show').val(messagingShow).click();\n            $('.' + loc + '-messaging-layout').val(messagingLayout).click();\n            $('.' + loc + '-messaging-logo').val(messagingLogo).click();\n            $('.' + loc + '-messaging-logo-position').val(messagingLogoPosition).click();\n            $('.' + loc + '-messaging-text-color').val(messagingTextColor).click();\n        });\n        $('#save').click();\n    };\n\n    window.resetAll = function () {\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n        let buttonShowStatus = 1, buttonLabel = 'paypal', buttonColor = 'gold', buttonShape = 'rect', buttonSize = 'responsive';\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').val(buttonShowStatus).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').val(buttonLabel).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').val(buttonColor).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').val(buttonShape).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').val(buttonSize).click();\n            });\n\n            // reset pay later messaging styling to recommended defaults\n            $('.' + loc + '-messaging-show').val(1).click();\n            $('.' + loc + '-messaging-layout').val('text').click();\n            $('.' + loc + '-messaging-logo').val('inline').click();\n            $('.' + loc + '-messaging-logo-position').val('left').click();\n            $('.' + loc + '-messaging-text-color').val('black').click();\n        });\n        $('#save').click();\n    };\n\n    window.applyButton = function () {\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').click();\n            });\n\n            // apply pay later messaging styling to current location\n            $('.' + loc + '-messaging-show').click();\n            $('.' + loc + '-messaging-layout').click();\n            $('.' + loc + '-messaging-logo').click();\n            $('.' + loc + '-messaging-logo-position').click();\n            $('.' + loc + '-messaging-text-color').click();\n        });\n        $('#save').click();\n    };\n\n    var locations = ['checkout', 'productpage', 'cart'];\n    hidePaypalSections();\n    $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]').change(function () {\n        hidePaypalSections();\n    });\n    locations.each(function (loc) {\n        $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-'+loc+'-fields-paypal-location-'+loc+'-button-type-value\"]').change(function () {\n            hidePaypalSections();\n        });\n    });\n\n    function hidePaypalSections() {\n        var mainLocation, merchantCountryIndex, mainType;\n        var locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n        mainLocation = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]');\n        if (mainLocation.length < 1) {\n            return false;\n        }\n        merchantCountryIndex = mainLocation.attr('id').split('_')[1];\n        mainType = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-'+mainLocation.val()+'-fields-paypal-location-'+mainLocation.val()+'-button-type-value\"]');\n        locations.each(function (loc) {\n            $('#row_payment_' + merchantCountryIndex + '_braintree_section_braintree_braintree_paypal_styling_button_' + loc).hide();\n            buttonTypes.each(function (type) {\n                $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_'+loc+'_button_location_'+loc+'_type_' + type).hide();\n            });\n        });\n        $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_'+mainLocation.val()+'_button_location_'+mainLocation.val()+'_type_' + mainType.val()).show();\n        $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_' + mainLocation.val()).show();\n    }\n    disablePayLaterMessages();\n});\n","PayPal_Braintree/js/virtual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'mage/translate',\n    'PayPal_Braintree/js/validator',\n    'braintree',\n    'braintreeHostedFields'\n], function ($, Class, alert, domObserver, $t, validator, client, hostedFields) {\n    'use strict';\n\n    return Class.extend({\n\n        defaults: {\n            $container: null,\n            container: 'payment_form_braintree',\n            braintree: null,\n            selectedCardType: null,\n            hostedFieldsInstance: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            validator.setConfig(this);\n\n            self.$container = $('#' + self.container);\n            this._super()\n                .observe([\n                    'selectedCardType'\n                ]);\n\n            domObserver.get('#' + self.container, function () {\n                self.initBraintree();\n            });\n\n            return this;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        initBraintree: function () {\n            var self = this;\n\n            try {\n                $('body').trigger('processStart');\n\n                client.create({\n                    authorization: self.clientToken\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        alert({\n                            content: $t('Please configure your Braintree Payments account in order to use the virtual terminal.')\n                        });\n                        console.error('Error!', clientErr);\n                        return self.error(response.clientErr);\n                    }\n\n                    hostedFields.create({\n                        client: clientInstance,\n                        fields: self.getHostedFields()\n                    }, function (createErr, hostedFieldsInstance) {\n                        if (createErr) {\n                            self.error($t(createErr));\n                            console.error('Error!', createErr);\n                            return;\n                        }\n\n                        self.hostedFieldsInstance = hostedFieldsInstance;\n                        self.$container.on('takePayment', self.submitOrder.bind(self));\n\n                        $('body').trigger('processStop');\n                    }.bind(this));\n                }.bind(this));\n            } catch (e) {\n                $('body').trigger('processStop');\n                self.error(e.message);\n                console.log(e);\n            }\n        },\n\n        /**\n         * Get hosted fields configuration\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            return {\n                number: {\n                    selector: this.getSelector('cc_number'),\n                    placeholder: $t('4111 1111 1111 1111')\n                },\n                expirationMonth: {\n                    selector: this.getSelector('cc_exp_month'),\n                    placeholder: $t('MM')\n                },\n                expirationYear: {\n                    selector: this.getSelector('cc_exp_year'),\n                    placeholder: $t('YY')\n                },\n                cvv: {\n                    selector: this.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                }\n            };\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            var $container = $('#' + this.container);\n            $container.find('[name=\"payment_method_nonce\"]').val(nonce);\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function (event) {\n            event.preventDefault();\n\n            this.$container.validate().form();\n            this.$container.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$container.validate().errorList.length) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n            this.tokenizeHostedFields();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.$container.submit();\n        },\n\n        /**\n         * Get list of currently available card types\n         * @returns {Array}\n         */\n        getCcAvailableTypes: function () {\n            var types = [],\n                $options = $(this.getSelector('cc_type')).find('option');\n\n            $.map($options, function (option) {\n                types.push($(option).val());\n            });\n\n            return types;\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({\n                vault: false // vault or no?\n            }, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    $('body').trigger('processStop');\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            this.error($t('Please enter a card number, expiration date and CVV'));\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            this.error($t('Please correct the problems with the Credit Card fields.'));\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            this.error($t('The payment method used, already exists in the user\\'s vault. Please use the vault option instead.'));\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            this.error($t('CVV did not pass verification'));\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            this.error($t('There was an issue tokenizing the card. Please check the card is valid.'));\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            this.error($t('There was an error connecting to Braintree. Please try again.'));\n                            break;\n                        default:\n                            this.error($t('There was an issue processing the payment. Please try again.'));\n                            console.error('Braintree error', tokenizeErr);\n                            break;\n                    }\n                } else {\n                    this.setPaymentDetails(payload.nonce);\n                    this.placeOrder();\n                }\n            }.bind(this));\n        }\n    });\n});\n","PayPal_Braintree/js/paypalStylingPreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'underscore',\n    'jquery',\n    'domReady!'\n], function (_, $) {\n    'use strict';\n    let buttonIds = [], currentButtonId = '';\n    let location = '', buttonType = '', buttonShow = '', buttonLabel = '', buttonColor = '', buttonShape = '', buttonSize = '';\n    let messagingShow = '', messagingLayout = '', messagingLogo = '', messagingLogoPosition = '', messagingTextColor = '';\n\n    function getCurrentLocationAndButtonType()\n    {\n        location = $('.payment-location').val();\n        buttonType = $('.' + location + '-button-type').val();\n    }\n\n    $(document).ready(function () {\n        getCurrentLocationAndButtonType();\n\n        $('.payment-location').on('change', function (customEvent) {\n            location = $(this).val();\n            buttonType = $('.' + location + '-button-type').val();\n            buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n            buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n            buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n            buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n            buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n            updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n\n            // render pay later messages when location changed\n            messagingShow = $('.' + location + '-messaging-show').val();\n            messagingLayout = $('.' + location + '-messaging-layout').val();\n            messagingLogo = $('.' + location + '-messaging-logo').val();\n            messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n            messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n            renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n            customEvent.stopImmediatePropagation();\n        });\n\n        $(\"select\").change(function () {\n            $(document).on('change', '.' + location + '-button-type', function (customEvent) {\n                buttonType = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-show', function (customEvent) {\n                buttonShow = $(this).val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-label', function (customEvent) {\n                buttonLabel = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-color', function (customEvent) {\n                buttonColor = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-shape', function (customEvent) {\n                buttonShape = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-size', function (customEvent) {\n                buttonSize = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-show', function (customEvent) {\n                messagingShow = $(this).val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-layout', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $(this).val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-logo', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $(this).val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-logo-position', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $(this).val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-text-color', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $(this).val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n        });\n    });\n\n    /**\n     * Update PayPal, Credit and Pay Later button styling if applicable\n     * @param location\n     * @param buttonType\n     * @param buttonShow\n     * @param buttonLabel\n     * @param buttonColor\n     * @param buttonShape\n     * @param buttonSize\n     */\n    let updatePayPalButtonStyling = function (location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize) {\n        $('.action-braintree-paypal-logo').each(function () {\n            if ($.inArray($(this).attr('id'), buttonIds) === -1) {\n                buttonIds.push($(this).attr('id'));\n            }\n        });\n\n        buttonIds.each(function (id) {\n            let result = id.startsWith(buttonType);\n            if (result === true) {\n                currentButtonId = id;\n            }\n        });\n\n        let currentButtonElement = $('#' + currentButtonId);\n        if (currentButtonElement.length) {\n            let style = {\n                color: buttonColor,\n                shape: buttonShape,\n                size: buttonSize,\n                label: buttonLabel\n            };\n            style.fundingicons = true;\n            let fundingSource = buttonType;\n\n            // Render\n            let button = paypal.Buttons({\n                fundingSource: fundingSource,\n                style: style,\n\n                onInit: function (data, actions) {\n                    actions.disable();\n                }\n            });\n            if (!button.isEligible()) {\n                console.log('PayPal button is not eligible');\n                currentButtonElement.parent().remove();\n                return;\n            }\n            if (currentButtonElement.length) {\n                currentButtonElement.empty();\n                if (buttonShow === '1') {\n                    button.render('#' + currentButtonElement.attr('id'));\n                }\n            }\n        }\n    };\n\n    /**\n     * Render and update Pay Later messaging style\n     * @param location\n     * @param messagingShow\n     * @param messagingLayout\n     * @param messagingLogo\n     * @param messagingLogoPosition\n     * @param messagingTextColor\n     */\n    let renderPayLaterMessages = function (location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor) {\n        $('.action-braintree-paypal-message').each(function () {\n            let messageElement = $('#' + $(this).attr('id'));\n\n            let payLaterMessageStyle = {\n                layout: messagingLayout,\n                text: {\n                    color: messagingTextColor\n                },\n                logo: {\n                    type: messagingLogo,\n                    position: messagingLogoPosition\n                }\n            };\n\n            let messageElementId = $(messageElement).attr('id');\n            let messageAmount = $(messageElement).data('pp-amount');\n            let parentElementId = messageElement.closest('tr').attr('id');\n\n            let messages = paypal.Messages({\n                amount: $(messageElement).data('pp-amount'),\n                pageType: location,\n                style: payLaterMessageStyle\n            });\n\n            if (messageElement.length) {\n                if (messagingShow === '1') {\n                    messageElement.remove();\n                    $('#' + parentElementId + ' td.value').append('<div class=\"action-braintree-paypal-message\" id=\"' + messageElementId + '\" data-pp-amount=\"' + messageAmount + '\" data-pp-type=\"' + location + '\" data-messaging-show=\"' + messagingShow + '\" data-messaging-layout=\"' + messagingLayout + '\" data-messaging-logo=\"' + messagingLogo + '\" data-messaging-logo-position=\"' + messagingLogoPosition + '\" data-messaging-text-color=\"' + messagingTextColor + '\"></div>');\n                    messages.render('#' + messageElementId);\n                } else {\n                    messageElement.hide();\n                }\n            }\n        });\n    };\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert'\n], function ($, Class, alert) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            $container: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            self.$selector = $('#' + self.selector);\n            self.$container =  $('#' + self.container);\n            self.$selector.on(\n                'setVaultNotActive.' + self.getCode(),\n                function () {\n                    self.$selector.off('submitOrder.' + self.getCode());\n                }\n            );\n            self._super();\n\n            self.initEventHandlers();\n\n            return self;\n        },\n\n        /**\n         * Get payment code\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Init event handlers\n         */\n        initEventHandlers: function () {\n            $(this.$container).find('[name=\"payment[token_switcher]\"]')\n                .on('click', this.selectPaymentMethod.bind(this));\n        },\n\n        /**\n         * Select current payment token\n         */\n        selectPaymentMethod: function () {\n            this.disableEventListeners();\n            this.enableEventListeners();\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.' + this.getCode(), this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n        },\n\n        /**\n         * Pre submit for order\n         * @returns {Boolean}\n         */\n        submitOrder: function () {\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$selector.validate().errorList.length) {\n                return false;\n            }\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.$selector.trigger('realOrder');\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            $('body').trigger('processStart');\n\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            }).done(function (response) {\n                self.setPaymentDetails(response.paymentMethodNonce);\n                self.placeOrder();\n            }).fail(function (response) {\n                var failed = JSON.parse(response.responseText);\n\n                self.error(failed.message);\n            }).always(function () {\n                $('body').trigger('processStop');\n            });\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            this.createPublicHashSelector();\n\n            this.$selector.find('[name=\"payment[public_hash]\"]').val(this.publicHash);\n            this.$selector.find('[name=\"payment[payment_method_nonce]\"]').val(nonce).prop('disabled', false);\n        },\n\n        /**\n         * Creates public hash selector\n         */\n        createPublicHashSelector: function () {\n            var $input;\n\n            if (this.$selector.find('[name=\"payment[payment_method_nonce]\"]').length === 0) {\n                $input = $('<input>').attr(\n                    {\n                        type: 'hidden',\n                        id: this.getNonceSelectorName(),\n                        name: 'payment[payment_method_nonce]'\n                    }\n                );\n\n                $input.appendTo(this.$selector);\n                $input.prop('disabled', false);\n            }\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Get selector name for nonce input\n         * @returns {String}\n         */\n        getNonceSelectorName: function () {\n            return 'nonce_' + this.getCode();\n        }\n    });\n});\n","PayPal_Braintree/js/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'mage/translate',\n    'PayPal_Braintree/js/validator',\n    'braintree',\n    'braintreeHostedFields'\n], function ($, Class, alert, domObserver, $t, validator, client, hostedFields) {\n    'use strict';\n\n    return Class.extend({\n\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            container: 'payment_form_braintree',\n            active: false,\n            scriptLoaded: false,\n            braintree: null,\n            selectedCardType: null,\n            imports: {\n                onActiveChange: 'active'\n            },\n            hostedFieldsInstance: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            validator.setConfig(this);\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe([\n                    'active',\n                    'scriptLoaded',\n                    'selectedCardType'\n                ]);\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.code)\n                .on('changePaymentMethod.' + this.code, this.changePaymentMethod.bind(this));\n\n            // listen block changes\n            domObserver.get('#' + self.container, function () {\n                if (self.scriptLoaded()) {\n                    self.$selector.off('submit');\n                    self.initBraintree();\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.code);\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.off('submitOrder.braintree');\n                this.$selector.on('submitOrder', function () {\n                    $('#payment_form_braintree').find('[type=\"submit\"]').trigger('click');\n                    $('#edit_form').trigger('realOrder');\n                });\n\n                return;\n            }\n            this.disableEventListeners();\n\n            if (typeof window.order !== 'undefined') {\n                window.order.addExcludedPaymentMethod(this.code);\n            }\n\n            if (!this.clientToken) {\n                this.error($.mage.__('This payment is not available'));\n\n                return;\n            }\n\n            this.enableEventListeners();\n\n            if (!this.scriptLoaded()) {\n                this.initBraintree();\n            }\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        initBraintree: function () {\n            var self = this;\n            this.scriptLoaded(true);\n\n            self.disableEventListeners();\n\n            try {\n                $('body').trigger('processStart');\n\n                client.create({\n                    authorization: self.clientToken\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error!', clientErr);\n                        return self.error(response.clientErr);\n                    }\n\n                    hostedFields.create({\n                        client: clientInstance,\n                        fields: self.getHostedFields()\n                    }, function (createErr, hostedFieldsInstance) {\n                        if (createErr) {\n                            self.error($t(createErr));\n                            console.error('Error!', createErr);\n                            return;\n                        }\n\n                        self.hostedFieldsInstance = hostedFieldsInstance;\n                        self.enableEventListeners();\n\n                        $('body').trigger('processStop');\n                    }.bind(this));\n                }.bind(this));\n            } catch (e) {\n                $('body').trigger('processStop');\n                self.error(e.message);\n                console.log(e);\n            }\n        },\n\n        /**\n         * Get hosted fields configuration\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number'),\n                        placeholder: $t('4111 1111 1111 1111')\n                    },\n                    expirationMonth: {\n                        selector: self.getSelector('cc_exp_month'),\n                        placeholder: $t('MM')\n                    },\n                    expirationYear: {\n                        selector: self.getSelector('cc_exp_year'),\n                        placeholder: $t('YY')\n                    }\n                };\n\n            if (self.useCvv) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.braintree', this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n            this.$selector.off('submit');\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            var $container = $('#' + this.container);\n\n            $container.find('[name=\"payment[payment_method_nonce]\"]').val(nonce);\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function () {\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$selector.validate().errorList.length) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n            this.tokenizeHostedFields();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            $('#' + this.selector).trigger('realOrder');\n        },\n\n        /**\n         * Get list of currently available card types\n         * @returns {Array}\n         */\n        getCcAvailableTypes: function () {\n            var types = [],\n                $options = $(this.getSelector('cc_type')).find('option');\n\n            $.map($options, function (option) {\n                types.push($(option).val());\n            });\n\n            return types;\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({\n                vault: false // vault or no?\n            }, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    $('body').trigger('processStop');\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            this.error($t('Please enter a card number, expiration date and CVV'));\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            this.error($t('Please correct the problems with the Credit Card fields.'));\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            this.error($t('The payment method used, already exists in the user\\'s vault. Please use the vault option instead.'));\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            this.error($t('CVV did not pass verification'));\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            this.error($t('There was an issue tokenizing the card. Please check the card is valid.'));\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            this.error($t('There was an error connecting to Braintree. Please try again.'));\n                            break;\n                        default:\n                            this.error($t('There was an issue processing the payment. Please try again.'));\n                            console.error('Braintree error', tokenizeErr);\n                            break;\n                    }\n                } else {\n                    this.setPaymentDetails(payload.nonce);\n                    $('#' + this.container).find('[type=\"submit\"]').trigger('click');\n                }\n            }.bind(this));\n        }\n    });\n});\n","PayPal_Braintree/js/paypalButtonPreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'braintree',\n    'braintreePayPalCheckout',\n    'domReady!'\n], function (_, $, braintree, paypalCheckout) {\n    'use strict';\n    let buttonIds = [];\n\n    return {\n        events: {\n            onClick: null\n        },\n\n        /**\n         * @param token\n         * @param currency\n         * @param env\n         * @param local\n         */\n        init: function (token, currency, env, local) {\n            buttonIds = [];\n            $('.action-braintree-paypal-logo').each(function () {\n                if (!$(this).hasClass(\"button-loaded\")) {\n                    $(this).addClass('button-loaded');\n                    buttonIds.push($(this).attr('id'));\n                }\n            });\n\n            if (buttonIds.length > 0) {\n                this.loadSDK(token, currency, env, local);\n            }\n        },\n\n        /**\n         * Load Braintree PayPal SDK\n         * @param token\n         * @param currency\n         * @param env\n         * @param local\n         */\n        loadSDK: function (token, currency, env, local) {\n            braintree.create({\n                authorization: token\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('paypalCheckout error', clientErr);\n                    return this.showError(\"PayPal Checkout could not be initialized. Please contact the store owner.\");\n                }\n                paypalCheckout.create({\n                    client: clientInstance\n                }, function (err, paypalCheckoutInstance) {\n                    if (typeof paypal !== 'undefined' ) {\n                        this.renderPayPalButtons(buttonIds);\n                        this.renderPayPalMessages();\n                    } else {\n                        var configSDK = {\n                            components: 'buttons,messages,funding-eligibility',\n                            \"enable-funding\": \"paylater\",\n                            currency: currency\n                        };\n                        if (env === 'sandbox' && (local !== '' || local !== 'undefined')) {\n                            configSDK[\"buyer-country\"] = local;\n                        }\n                        paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                            this.renderPayPalButtons(buttonIds);\n                            this.renderPayPalMessages();\n                        }.bind(this));\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Render PayPal buttons\n         * @param ids\n         */\n        renderPayPalButtons: function (ids) {\n            _.each(ids, function (id) {\n                this.payPalButton(id);\n            }.bind(this));\n        },\n\n        /**\n         * Render PayPal messages\n         */\n        renderPayPalMessages: function () {\n            $('.action-braintree-paypal-message').each(function () {\n                let messages = paypal.Messages({\n                    amount: $(this).data('pp-amount'),\n                    pageType: $(this).data('pp-type'),\n                    style: {\n                        layout: $(this).data('messaging-layout'),\n                        text: {\n                            color:   $(this).data('messaging-text-color')\n                        },\n                        logo: {\n                            type: $(this).data('messaging-logo'),\n                            position: $(this).data('messaging-logo-position')\n                        }\n                    }\n                });\n\n                if ($('#' + $(this).attr('id')).length && $(this).data('messaging-show')) {\n                    messages.render('#' + $(this).attr('id'));\n                }\n            });\n        },\n\n        /**\n         * @param id\n         */\n        payPalButton: function (id) {\n            let data = $('#' + id);\n            let style = {\n                color: data.data('color'),\n                shape: data.data('shape'),\n                size: data.data('size'),\n                label: data.data('label')\n            };\n\n            if (data.data('fundingicons')) {\n                style.fundingicons = data.data('fundingicons');\n            }\n\n            // Render\n            var button = paypal.Buttons({\n                fundingSource: data.data('funding'),\n                style: style,\n\n                onInit: function (data, actions) {\n                    actions.disable();\n                }\n            });\n            if (!button.isEligible()) {\n                console.log('PayPal button is not elligible');\n                data.parent().remove();\n                return;\n            }\n            if ($('#' + data.attr('id')).length && data.data('show')) {\n                button.render('#' + data.attr('id'));\n            }\n        },\n    }\n});\n","PayPal_Braintree/js/grid/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/provider'\n], function (_, Provider) {\n    'use strict';\n\n    return Provider.extend({\n\n        /**\n         * Reload grid\n         * @returns {exports}\n         */\n        reload: function () {\n            if (this.hasFilters()) {\n                this._super();\n\n                return this;\n            }\n\n            this.trigger('reload');\n\n            this.onReload({\n                items: [],\n                totalRecords: 0\n            });\n\n            return this;\n        },\n\n        /**\n         * Has filters checker\n         * @returns {Boolean}\n         */\n        hasFilters: function () {\n            var params = this.params,\n                filters = params.filters || {};\n\n            return _.keys(filters).length > 1;\n        }\n    });\n});\n","Magento_LoginAsCustomerAdminUi/js/confirmation-popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'jquery',\n    'ko',\n    'mage/translate',\n    'mage/template',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'text!Magento_LoginAsCustomerAdminUi/template/confirmation-popup/store-view-ptions.html'\n], function (Component, confirm, $, ko, $t, template, _, alert, selectTpl) {\n\n    'use strict';\n\n    return Component.extend({\n        /**\n         * Initialize Component\n         */\n        initialize: function () {\n            var self = this,\n                content;\n\n            this._super();\n\n            content = '<div class=\"message message-warning\">' + self.content + '</div>';\n\n            if (self.showStoreViewOptions) {\n                content = template(\n                    selectTpl,\n                    {\n                        data: {\n                            showStoreViewOptions: self.showStoreViewOptions,\n                            storeViewOptions: self.storeViewOptions,\n                            label: $t('Store')\n                        }\n                    }) + content;\n            }\n\n            /**\n             * Confirmation popup\n             *\n             * @param {String} url\n             * @returns {Boolean}\n             */\n            window.lacConfirmationPopup = function (url) {\n                confirm({\n                    title: self.title,\n                    content: content,\n                    modalClass: 'confirm lac-confirm',\n                    actions: {\n                        /**\n                         * Confirm action.\n                         */\n                        confirm: function () {\n                            var storeId = $('#lac-confirmation-popup-store-id').val(),\n                                formKey = $('input[name=\"form_key\"]').val(),\n                                params = {};\n\n                            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                            if (storeId) {\n                                params.store_id = storeId;\n                            }\n\n                            if (formKey) {\n                                params.form_key = formKey;\n                            }\n                            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n                            $.ajax({\n                                url: url,\n                                type: 'POST',\n                                dataType: 'json',\n                                data: params,\n                                showLoader: true,\n\n                                /**\n                                 * Open redirect URL in new window, or show messages if they are present\n                                 *\n                                 * @param {Object} data\n                                 */\n                                success: function (data) {\n                                    var messages = data.messages || [];\n\n                                    if (data.message) {\n                                        messages.push(data.message);\n                                    }\n\n                                    if (data.redirectUrl) {\n                                        window.open(data.redirectUrl);\n                                    } else if (messages.length) {\n                                        messages = messages.map(function (message) {\n                                            return _.escape(message);\n                                        });\n\n                                        alert({\n                                            content: messages.join('<br>')\n                                        });\n                                    }\n                                },\n\n                                /**\n                                 * Show XHR response text\n                                 *\n                                 * @param {Object} jqXHR\n                                 */\n                                error: function (jqXHR) {\n                                    alert({\n                                        content: _.escape(jqXHR.responseText)\n                                    });\n                                }\n                            });\n                        }\n                    },\n                    buttons: [{\n                        text: $t('Cancel'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Click handler.\n                         */\n                        click: function (event) {\n                            this.closeModal(event);\n                        }\n                    }, {\n                        text: $t('Login as Customer'),\n                        class: 'action-primary action-accept',\n\n                        /**\n                         * Click handler.\n                         */\n                        click: function (event) {\n                            this.closeModal(event, true);\n                        }\n                    }]\n                });\n\n                return false;\n            };\n        }\n    });\n});\n","Magento_Catalog/js/price-option-file.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.priceOptionFile', {\n        options: {\n            fileName: '',\n            fileNamed: '',\n            fieldNameAction: '',\n            changeFileSelector: '',\n            deleteFileSelector: ''\n        },\n\n        /**\n         * Creates instance of widget\n         * @private\n         */\n        _create: function () {\n            this.fileDeleteFlag = this.fileChangeFlag = false;\n            this.inputField = this.element.find('input[name=' + this.options.fileName + ']')[0];\n            this.inputFieldAction = this.element.find('input[name=' + this.options.fieldNameAction + ']')[0];\n            this.fileNameSpan = this.element.parent('dd').find('.' + this.options.fileNamed);\n\n            $(this.options.changeFileSelector).on('click', $.proxy(function () {\n                this._toggleFileChange();\n            }, this));\n            $(this.options.deleteFileSelector).on('click', $.proxy(function () {\n                this._toggleFileDelete();\n            }, this));\n        },\n\n        /**\n         * Toggles whether the current file is being changed or not. If the file is being deleted\n         * then the option to change the file is disabled.\n         * @private\n         */\n        _toggleFileChange: function () {\n            this.element.toggle();\n            this.fileChangeFlag = !this.fileChangeFlag;\n\n            if (!this.fileDeleteFlag) {\n                $(this.inputFieldAction).attr('value', this.fileChangeFlag ? 'save_new' : 'save_old');\n                this.inputField.disabled = !this.fileChangeFlag;\n            }\n        },\n\n        /**\n         * Toggles whether the file is to be deleted. When the file is being deleted, the name of\n         * the file is decorated with strike-through text and the option to change the file is\n         * disabled.\n         * @private\n         */\n        _toggleFileDelete: function () {\n            this.fileDeleteFlag = $(this.options.deleteFileSelector + ':checked').val();\n            $(this.inputFieldAction).attr('value',\n                this.fileDeleteFlag ? '' : this.fileChangeFlag ? 'save_new' : 'save_old');\n            this.inputField.disabled = this.fileDeleteFlag || !this.fileChangeFlag;\n            this.fileNameSpan.css('text-decoration', this.fileDeleteFlag ? 'line-through' : 'none');\n        }\n    });\n\n    return $.mage.priceOptionFile;\n});\n","Magento_Catalog/js/category-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($, utils) {\n    'use strict';\n\n    $.widget('mage.categoryTree', {\n        options: {\n            url: '',\n            data: [],\n            tree: {\n                core: {\n                    themes: {\n                        dots: false\n                    }\n                }\n            }\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var options = this.options,\n                treeOptions = $.extend(\n                    true,\n                    {},\n                    options.tree,\n                    {\n                        core: {\n                            data: this._convertData(this.options.data).children\n                        }\n                    }\n                );\n\n            this.element.jstree(treeOptions);\n            this.element.on('select_node.jstree', $.proxy(this._selectNode, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _selectNode: function (event, data) {\n            var node = data.node;\n\n            if (!node.state.disabled) {\n                window.location = window.location + '/' + node.id;\n            } else {\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @param {Array} nodes\n         * @returns {Array}\n         * @private\n         */\n        _convertDataNodes: function (nodes) {\n            var nodesData = [];\n\n            nodes.children.forEach(function (node) {\n                nodesData.push(this._convertData(node));\n            }, this);\n\n            return nodesData;\n        },\n\n        /**\n         * @param {Object} node\n         * @return {*}\n         * @private\n         */\n        _convertData: function (node) {\n            var self = this,\n                result;\n\n            if (!node) {\n                return result;\n            }\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            result = {\n                id: node.id,\n                text: utils.unescape(node.name) + ' (' + node.product_count + ')',\n                li_attr: {\n                    class: node.cls + (!!node.disabled ? ' disabled' : '') //eslint-disable-line no-extra-boolean-cast\n                },\n                state: {\n                    disabled: node.disabled,\n                    opened:  !!node.children_count && node.expanded\n                }\n            };\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n            if (node.children) {\n                result.children = [];\n                $.each(node.children, function () {\n                    result.children.push(self._convertData(this));\n                });\n            }\n\n            return result;\n        }\n    });\n\n    return $.mage.categoryTree;\n});\n","Magento_Catalog/js/product-gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'baseImage'\n], function ($, _, mageTemplate, registry) {\n    'use strict';\n\n    /**\n     * Formats incoming bytes value to a readable format.\n     *\n     * @param {Number} bytes\n     * @returns {String}\n     */\n    function bytesToSize(bytes) {\n        var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'],\n            i;\n\n        if (bytes === 0) {\n            return '0 Byte';\n        }\n\n        i = window.parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));\n\n        return Math.round(bytes / Math.pow(1024, i), 2) + ' ' + sizes[i];\n    }\n\n    /**\n     * Product gallery widget\n     */\n    $.widget('mage.productGallery', {\n        options: {\n            imageSelector: '[data-role=image]',\n            imageElementSelector: '[data-role=image-element]',\n            template: '[data-template=image]',\n            imageResolutionLabel: '[data-role=resolution]',\n            imgTitleSelector: '[data-role=img-title]',\n            imageSizeLabel: '[data-role=size]',\n            types: null,\n            initialized: false\n        },\n\n        /**\n         * Gallery creation\n         * @protected\n         */\n        _create: function () {\n            this.options.types = this.options.types || this.element.data('types');\n            this.options.images = this.options.images || this.element.data('images');\n            this.options.parentComponent = this.options.parentComponent || this.element.data('parent-component');\n\n            this.imgTmpl = mageTemplate(this.element.find(this.options.template).html().trim());\n\n            this._bind();\n\n            this._isInitializingItems = true;\n            this._initializedItemCount = 0;\n            this._lastInitializedElement = null;\n\n            $.each(this.options.images, $.proxy(function (index, imageData) {\n                this.element.trigger('addItem', imageData);\n            }, this));\n\n            this._updateImagesRoles();\n            this._contentUpdated();\n\n            this._isInitializingItems = false;\n            this.options.initialized = true;\n        },\n\n        /**\n         * Bind handler to elements\n         * @protected\n         */\n        _bind: function () {\n            this._on({\n                updateImageTitle: '_updateImageTitle',\n                updateVisibility: '_updateVisibility',\n                openDialog: '_onOpenDialog',\n                addItem: '_addItem',\n                removeItem: '_removeItem',\n                setImageType: '_setImageType',\n                setPosition: '_setPosition',\n                resort: '_resort',\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseup [data-role=delete-button]': function (event) {\n                    var $imageContainer;\n\n                    event.preventDefault();\n                    $imageContainer = $(event.currentTarget).closest(this.options.imageSelector);\n                    this.element.find('[data-role=dialog]').trigger('close');\n                    this.element.trigger('removeItem', $imageContainer.data('imageData'));\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseup [data-role=make-base-button]': function (event) {\n                    var $imageContainer,\n                        imageData;\n\n                    event.preventDefault();\n                    event.stopImmediatePropagation();\n                    $imageContainer = $(event.currentTarget).closest(this.options.imageSelector);\n                    imageData = $imageContainer.data('imageData');\n                    this.setBase(imageData);\n                }\n            });\n\n            this.element.sortable({\n                distance: 8,\n                items: this.options.imageSelector,\n                tolerance: 'pointer',\n                cancel: 'input, button, .uploader',\n                update: $.proxy(function () {\n                    this.element.trigger('resort');\n                }, this)\n            });\n        },\n\n        /**\n         * Set image as main\n         * @param {Object} imageData\n         * @private\n         */\n        setBase: function (imageData) {\n            var baseImage = this.options.types.image,\n                sameImages = $.grep(\n                    $.map(this.options.types, function (el) {\n                        return el;\n                    }),\n                    function (el) {\n                        return el.value === baseImage.value;\n                    }\n                ),\n                isImageOpened = this.findElement(imageData).hasClass('active');\n\n            $.each(sameImages, $.proxy(function (index, image) {\n                this.element.trigger('setImageType', {\n                    type: image.code,\n                    imageData: imageData\n                });\n\n                if (isImageOpened) {\n                    this.element.find('.item').addClass('selected');\n                    this.element.find('[data-role=type-selector]').prop({\n                        'checked': true\n                    });\n                }\n            }, this));\n        },\n\n        /**\n         * Find element by fileName\n         * @param {Object} data\n         * @returns {Element}\n         */\n        findElement: function (data) {\n            return this.element.find(this.options.imageSelector).filter(function () {\n                return $(this).data('imageData').file === data.file;\n            }).first();\n        },\n\n        /**\n         * Mark parent fieldset that content was updated\n         */\n        _contentUpdated: function () {\n            if (this.options.initialized && this.options.parentComponent) {\n                registry.async(this.options.parentComponent)(\n                    function (parentComponent) {\n                        parentComponent.bubble('update', true);\n                    }\n                );\n            }\n        },\n\n        /**\n         * Add image\n         * @param {jQuery.Event} event\n         * @param {Object} imageData\n         * @private\n         */\n        _addItem: function (event, imageData) {\n            var element,\n                imgElement,\n                lastElement,\n                count,\n                position;\n\n            if (this._isInitializingItems) {\n                count = this._initializedItemCount++;\n                lastElement = this._lastInitializedElement;\n            } else {\n                count = this.element.find(this.options.imageSelector).length;\n                lastElement = this.element.find(this.options.imageSelector + ':last');\n            }\n\n            position = count + 1;\n\n            if (lastElement && lastElement.length === 1) {\n                position = parseInt(lastElement.data('imageData').position || count, 10) + 1;\n            }\n            imageData = $.extend({\n                'file_id': imageData['value_id'] ? imageData['value_id'] : Math.random().toString(33).substr(2, 18),\n                'disabled': imageData.disabled ? imageData.disabled : 0,\n                'position': position,\n                sizeLabel: bytesToSize(imageData.size)\n            }, imageData);\n\n            element = this.imgTmpl({\n                data: imageData\n            });\n\n            element = $(element).data('imageData', imageData);\n\n            if (count === 0) {\n                element.prependTo(this.element);\n            } else {\n                element.insertAfter(lastElement);\n            }\n\n            this._lastInitializedElement = element;\n\n            if (!this.options.initialized &&\n                this.options.images.length === 0 ||\n                this.options.initialized &&\n                this.element.find(this.options.imageSelector + ':not(.removed)').length === 1\n            ) {\n                this.setBase(imageData);\n            }\n\n            imgElement = element.find(this.options.imageElementSelector);\n\n            imgElement.on('load', this._updateImageDimesions.bind(this, element));\n\n            $.each(this.options.types, $.proxy(function (index, image) {\n                if (imageData.file === image.value) {\n                    this.element.trigger('setImageType', {\n                        type: image.code,\n                        imageData: imageData\n                    });\n                }\n            }, this));\n\n            if (!this._isInitializingItems) {\n                this._updateImagesRoles();\n                this._contentUpdated();\n            }\n        },\n\n        /**\n         * Returns a list of current images.\n         *\n         * @returns {jQueryCollection}\n         */\n        _getImages: function () {\n            return this.element.find(this.options.imageSelector);\n        },\n\n        /**\n         * Returns a list of images roles.\n         *\n         * @return {Object}\n         */\n        _getRoles: function () {\n            return _.mapObject(this.options.types, function (data, key) {\n                var elem = this.element.find('.image-' + key);\n\n                return {\n                    index: key,\n                    value: elem.val(),\n                    elem: elem\n                };\n            }, this);\n        },\n\n        /**\n         * Updates labels with roles information for each image.\n         */\n        _updateImagesRoles: function () {\n            var $images = this._getImages().toArray(),\n                roles = this._getRoles();\n\n            $images.forEach(function (img) {\n                var $img = $(img),\n                    data = $img.data('imageData');\n\n                $img.find('[data-role=roles-labels] li').each(function (index, elem) {\n                    var $elem = $(elem),\n                        roleCode = $elem.data('roleCode'),\n                        role = roles[roleCode];\n\n                    role.value === data.file  ?\n                        $elem.show() :\n                        $elem.hide();\n                });\n\n            });\n        },\n\n        /**\n         * Updates image's dimensions information.\n         *\n         * @param {jQeuryCollection} imgContainer\n         */\n        _updateImageDimesions: function (imgContainer) {\n            var $img = imgContainer.find(this.options.imageElementSelector)[0],\n                $dimens = imgContainer.find('[data-role=image-dimens]');\n\n            $dimens.text($img.naturalWidth + 'x' + $img.naturalHeight + ' px');\n        },\n\n        /**\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         */\n        _updateImageTitle: function (event, data) {\n            var imageData = data.imageData,\n                $imgContainer = this.findElement(imageData),\n                $title = $imgContainer.find(this.options.imgTitleSelector),\n                value;\n\n            value = imageData['media_type'] === 'external-video' ?\n                imageData['video_title'] :\n                imageData.label;\n\n            $title.text(value);\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Remove Image\n         * @param {jQuery.Event} event\n         * @param {Object} imageData\n         * @private\n         */\n        _removeItem: function (event, imageData) {\n            var $imageContainer = this.findElement(imageData);\n\n            imageData.isRemoved = true;\n            $imageContainer.addClass('removed').hide().find('.is-removed').val(1);\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image type\n         * @param {jQuery.Event} event\n         * @param {Obejct} data\n         * @private\n         */\n        _setImageType: function (event, data) {\n            if (data.type === 'image') {\n                this.element.find('.base-image').removeClass('base-image');\n            }\n\n            if (data.imageData) {\n                this.options.types[data.type].value = data.imageData.file;\n\n                if (data.type === 'image') {\n                    this.findElement(data.imageData).addClass('base-image');\n                }\n            } else {\n                this.options.types[data.type].value = 'no_selection';\n            }\n            this.element.find('.image-' + data.type).val(this.options.types[data.type].value || 'no_selection');\n            this._updateImagesRoles();\n            this._contentUpdated();\n        },\n\n        /**\n         * Resort images\n         * @private\n         */\n        _resort: function () {\n            this.element.find('.position').each($.proxy(function (index, element) {\n                var value = $(element).val();\n\n                if (value != index) { //eslint-disable-line eqeqeq\n                    this.element.trigger('moveElement', {\n                        imageData: $(element).closest(this.options.imageSelector).data('imageData'),\n                        position: index\n                    });\n                    $(element).val(index);\n                }\n            }, this));\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image position\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _setPosition: function (event, data) {\n            var $element = this.findElement(data.imageData),\n                curIndex = this.element.find(this.options.imageSelector).index($element),\n                newPosition = data.position + (curIndex > data.position ? -1 : 0);\n\n            if (data.position != curIndex) { //eslint-disable-line eqeqeq\n                if (data.position === 0) {\n                    this.element.prepend($element);\n                } else {\n                    $element.insertAfter(\n                        this.element.find(this.options.imageSelector).eq(newPosition)\n                    );\n                }\n                this.element.trigger('resort');\n            }\n\n            this._contentUpdated();\n        }\n    });\n\n    // Extension for mage.productGallery - Add advanced settings block\n    $.widget('mage.productGallery', $.mage.productGallery, {\n        options: {\n            dialogTemplate: '[data-role=img-dialog-tmpl]',\n            dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var template = this.element.find(this.options.dialogTemplate),\n                containerTmpl = this.element.find(this.options.dialogContainerTmpl);\n\n            this._super();\n            this.modalPopupInit = false;\n\n            if (template.length) {\n                this.dialogTmpl = mageTemplate(template.html().trim());\n            }\n\n            if (containerTmpl.length) {\n                this.dialogContainerTmpl = mageTemplate(containerTmpl.html().trim());\n            } else {\n                this.dialogContainerTmpl = mageTemplate('');\n            }\n\n            this._initDialog();\n        },\n\n        /**\n         * Bind handler to elements\n         * @protected\n         */\n        _bind: function () {\n            var events = {};\n\n            this._super();\n\n            events['click [data-role=close-panel]'] = $.proxy(function () {\n                this.element.find('[data-role=dialog]').trigger('close');\n            }, this);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.imageSelector] = function (event) {\n                var imageData, $imageContainer;\n\n                if (!$(event.currentTarget).is('.ui-sortable-helper')) {\n                    $(event.currentTarget).addClass('active');\n                    imageData = $(event.currentTarget).data('imageData');\n                    $imageContainer = this.findElement(imageData);\n\n                    if ($imageContainer.is('.removed')) {\n                        return;\n                    }\n                    this.element.trigger('openDialog', [imageData]);\n                }\n            };\n            this._on(events);\n            this.element.on('sortstart', $.proxy(function () {\n                this.element.find('[data-role=dialog]').trigger('close');\n            }, this));\n        },\n\n        /**\n         * Initializes dialog element.\n         */\n        _initDialog: function () {\n            var $dialog = $(this.dialogContainerTmpl());\n\n            $dialog.modal({\n                'type': 'slide',\n                title: $.mage.__('Image Detail'),\n                buttons: [],\n\n                /** @inheritdoc */\n                opened: function () {\n                    $dialog.trigger('open');\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    $dialog.trigger('close');\n                }\n            });\n\n            $dialog.on('open', this.onDialogOpen.bind(this));\n            $dialog.on('close', function () {\n                var $imageContainer = $dialog.data('imageContainer');\n\n                $imageContainer.removeClass('active');\n                $dialog.find('#hide-from-product-page').remove();\n            });\n\n            $dialog.on('change', '[data-role=type-selector]', function () {\n                var parent = $(this).closest('.item'),\n                    selectedClass = 'selected';\n\n                parent.toggleClass(selectedClass, $(this).prop('checked'));\n            });\n\n            $dialog.on('change', '[data-role=type-selector]', $.proxy(this._notifyType, this));\n\n            $dialog.on('change', '[data-role=visibility-trigger]', $.proxy(function (e) {\n                var imageData = $dialog.data('imageData');\n\n                this.element.trigger('updateVisibility', {\n                    disabled: $(e.currentTarget).is(':checked'),\n                    imageData: imageData\n                });\n            }, this));\n\n            $dialog.on('change', '[data-role=\"image-description\"]', function (e) {\n                var target = $(e.target),\n                    targetName = target.attr('name'),\n                    desc = target.val(),\n                    imageData = $dialog.data('imageData');\n\n                this.element.find('input[type=\"hidden\"][name=\"' + targetName + '\"]').val(desc);\n\n                imageData.label = desc;\n                imageData['label_default'] = desc;\n\n                this.element.trigger('updateImageTitle', {\n                    imageData: imageData\n                });\n            }.bind(this));\n\n            this.$dialog = $dialog;\n        },\n\n        /**\n         * @param {Object} imageData\n         * @private\n         */\n        _showDialog: function (imageData) {\n            var $imageContainer = this.findElement(imageData),\n                $template;\n\n            $template = this.dialogTmpl({\n                'data': imageData\n            });\n\n            this.$dialog\n                .html($template)\n                .data('imageData', imageData)\n                .data('imageContainer', $imageContainer)\n                .modal('openModal');\n        },\n\n        /**\n         * Handles dialog open event.\n         *\n         * @param {EventObject} event\n         */\n        onDialogOpen: function (event) {\n            var imageData = this.$dialog.data('imageData'),\n                imageSizeKb = imageData.sizeLabel,\n                image = document.createElement('img'),\n                sizeSpan = this.$dialog.find(this.options.imageSizeLabel)\n                    .find('[data-message]'),\n                resolutionSpan = this.$dialog.find(this.options.imageResolutionLabel)\n                    .find('[data-message]'),\n                sizeText = sizeSpan.attr('data-message').replace('{size}', imageSizeKb),\n                resolutionText;\n\n            image.src = imageData.url;\n\n            resolutionText = resolutionSpan\n                .attr('data-message')\n                .replace('{width}^{height}', image.width + 'x' + image.height);\n\n            sizeSpan.text(sizeText);\n            resolutionSpan.text(resolutionText);\n\n            $(event.target)\n                .find('[data-role=type-selector]')\n                .each($.proxy(function (index, checkbox) {\n                    var $checkbox = $(checkbox),\n                        parent = $checkbox.closest('.item'),\n                        selectedClass = 'selected',\n                        isChecked = this.options.types[$checkbox.val()].value == imageData.file; //eslint-disable-line\n\n                    $checkbox.prop(\n                        'checked',\n                        isChecked\n                    );\n                    parent.toggleClass(selectedClass, isChecked);\n                }, this));\n        },\n\n        /**\n         *\n         * Click by image handler\n         *\n         * @param {jQuery.Event} e\n         * @param {Object} imageData\n         * @private\n         */\n        _onOpenDialog: function (e, imageData) {\n            if (imageData['media_type'] && imageData['media_type'] != 'image') { //eslint-disable-line eqeqeq\n                return;\n            }\n            this._showDialog(imageData);\n        },\n\n        /**\n         * Change visibility\n         *\n         * @param {jQuery.Event} event\n         * * @param {Object} data\n         * @private\n         */\n        _updateVisibility: function (event, data) {\n            var imageData = data.imageData,\n                disabled = +data.disabled,\n                $imageContainer = this.findElement(imageData);\n\n            !!disabled ? //eslint-disable-line no-extra-boolean-cast\n                $imageContainer.addClass('hidden-for-front') :\n                $imageContainer.removeClass('hidden-for-front');\n\n            $imageContainer.find('[name*=\"disabled\"]').val(disabled);\n            imageData.disabled = disabled;\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _notifyType: function (event) {\n            var $checkbox = $(event.currentTarget),\n                $imageContainer = $checkbox.closest('[data-role=dialog]').data('imageContainer');\n\n            this.element.trigger('setImageType', {\n                type: $checkbox.val(),\n                imageData: $checkbox.is(':checked') ? $imageContainer.data('imageData') : null\n            });\n\n            this._updateImagesRoles();\n        }\n    });\n\n    return $.mage.productGallery;\n});\n","Magento_Catalog/js/custom-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'useDefault',\n    'collapsable',\n    'mage/translate',\n    'mage/backend/validation',\n    'Magento_Ui/js/modal/modal'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.customOptions', {\n        options: {\n            selectionItemCount: {}\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.baseTmpl = mageTemplate('#custom-option-base-template');\n            this.rowTmpl = mageTemplate('#custom-option-select-type-row-template');\n\n            this._initOptionBoxes();\n            this._initSortableSelections();\n            this._bindCheckboxHandlers();\n            this._bindReadOnlyMode();\n            this._addValidation();\n        },\n\n        /**\n         * @private\n         */\n        _addValidation: function () {\n            $.validator.addMethod(\n                'required-option-select', function (value) {\n                    return value !== '';\n                }, $.mage.__('Select type of option.'));\n\n            $.validator.addMethod(\n                'required-option-select-type-rows', function (value, element) {\n                    var optionContainerElm = element.up('div[id*=_type_]'),\n                        selectTypesFlag = false,\n                        selectTypeElements = $('#' + optionContainerElm.id + ' .select-type-title');\n\n                    selectTypeElements.each(function () {\n                        if (!$(this).closest('tr').hasClass('ignore-validate')) {\n                            selectTypesFlag = true;\n                        }\n                    });\n\n                    return selectTypesFlag;\n                }, $.mage.__('Please add rows to option.'));\n        },\n\n        /**\n         * @private\n         */\n        _initOptionBoxes: function () {\n            var syncOptionTitle;\n\n            if (!this.options.isReadonly) {\n                this.element.sortable({\n                    axis: 'y',\n                    handle: '[data-role=draggable-handle]',\n                    items: '#product_options_container_top > div',\n                    update: this._updateOptionBoxPositions,\n                    tolerance: 'pointer'\n                });\n            }\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            syncOptionTitle = function (event) {\n                var currentValue = $(event.target).val(),\n                    optionBoxTitle = $(\n                        '.admin__collapsible-title > span',\n                        $(event.target).closest('.fieldset-wrapper')\n                    ),\n                    newOptionTitle = $.mage.__('New Option');\n\n                optionBoxTitle.text(currentValue === '' ? newOptionTitle : currentValue);\n            };\n            this._on({\n                /**\n                 * Reset field value to Default\n                 */\n                'click .use-default-label': function (event) {\n                    $(event.target).closest('label').find('input').prop('checked', true).trigger('change');\n                },\n\n                /**\n                 * Remove custom option or option row for 'select' type of custom option\n                 */\n                'click button[id^=product_option_][id$=_delete]': function (event) {\n                    var element = $(event.target).closest('#product_options_container_top > div.fieldset-wrapper,tr');\n\n                    if (element.length) {\n                        $('#product_' + element.attr('id').replace('product_', '') + '_is_delete').val(1);\n                        element.addClass('ignore-validate').hide();\n                        this.refreshSortableElements();\n                    }\n                },\n\n                /**\n                 * Minimize custom option block\n                 */\n                'click #product_options_container_top [data-target$=-content]': function () {\n                    if (this.options.isReadonly) {\n                        return false;\n                    }\n                },\n\n                /**\n                 * Add new custom option\n                 */\n                'click #add_new_defined_option': function (event) {\n                    this.addOption(event);\n                },\n\n                /**\n                 * Add new option row for 'select' type of custom option\n                 */\n                'click button[id^=product_option_][id$=_add_select_row]': function (event) {\n                    this.addSelection(event);\n                },\n\n                /**\n                 * Import custom options from products\n                 */\n                'click #import_new_defined_option': function () {\n                    var importContainer = $('#import-container'),\n                        widget = this;\n\n                    importContainer.modal({\n                        title: $.mage.__('Select Product'),\n                        type: 'slide',\n\n                        /** @inheritdoc */\n                        opened: function () {\n                            $(document).off().on('click', '#productGrid_massaction-form button', function () {\n                                $('.import-custom-options-apply-button').trigger('click', 'massActionTrigger');\n                            });\n                        },\n                        buttons: [{\n                            text: $.mage.__('Import'),\n                            attr: {\n                                id: 'import-custom-options-apply-button'\n                            },\n                            'class': 'action-primary action-import import-custom-options-apply-button',\n\n                            /** @inheritdoc */\n                            click: function (event, massActionTrigger) {\n                                var request = [];\n\n                                $(this.element).find('input[name=product]:checked').map(function () {\n                                    request.push(this.value);\n                                });\n\n                                if (request.length === 0) {\n                                    if (!massActionTrigger) {\n                                        alert({\n                                            content: $.mage.__('An item needs to be selected. Select and try again.')\n                                        });\n                                    }\n\n                                    return;\n                                }\n\n                                $.post(widget.options.customOptionsUrl, {\n                                    'products[]': request,\n                                    'form_key': widget.options.formKey\n                                }, function ($data) {\n                                    $.each(JSON.parse($data), function (el) {\n                                        var i;\n\n                                        el.id = widget.getFreeOptionId(el.id);\n                                        el['option_id'] = el.id;\n\n                                        if (typeof el.optionValues !== 'undefined') {\n                                            for (i = 0; i < el.optionValues.length; i++) {\n                                                el.optionValues[i]['option_id'] = el.id;\n                                            }\n                                        }\n                                        //Adding option\n                                        widget.addOption(el);\n                                        //Will save new option on server side\n                                        $('#product_option_' + el.id + '_option_id').val(0);\n                                        $('#option_' + el.id + ' input[name$=\"option_type_id]\"]').val(-1);\n                                    });\n                                    importContainer.modal('closeModal');\n                                });\n                            }\n                        }]\n                    });\n                    importContainer.load(\n                        this.options.productGridUrl,\n                        {\n                            'form_key': this.options.formKey,\n                            'current_product_id': this.options.currentProductId\n                        },\n                        function () {\n                            importContainer.modal('openModal');\n                        }\n                    );\n                },\n\n                /**\n                 * Change custom option type\n                 */\n                'change select[id^=product_option_][id$=_type]': function (event, data) {\n                    var widget = this,\n                        currentElement = $(event.target),\n                        parentId = '#' + currentElement.closest('.fieldset-alt').attr('id'),\n                        group = currentElement.find('[value=\"' + currentElement.val() + '\"]')\n                            .closest('optgroup').attr('data-optgroup-name'),\n                        previousGroup = $(parentId + '_previous_group').val(),\n                        previousBlock = $(parentId + '_type_' + previousGroup),\n                        tmpl, disabledBlock, priceType;\n\n                    data = data || {};\n\n                    if (typeof group !== 'undefined') {\n                        group = group.toLowerCase();\n                    }\n\n                    if (previousGroup !== group) {\n                        if (previousBlock.length) {\n                            previousBlock.addClass('ignore-validate').hide();\n                        }\n                        $(parentId + '_previous_group').val(group);\n\n                        if (typeof group === 'undefined') {\n                            return;\n                        }\n                        disabledBlock = $(parentId).find(parentId + '_type_' + group);\n\n                        if (disabledBlock.length) {\n                            disabledBlock.removeClass('ignore-validate').show();\n                        } else {\n                            if ($.isEmptyObject(data)) { //eslint-disable-line max-depth\n                                data['option_id'] = $(parentId + '_id').val();\n                                data.price = data.sku = '';\n                            }\n                            data.group = group;\n\n                            tmpl = widget.element.find('#custom-option-' + group + '-type-template').html();\n                            tmpl = mageTemplate(tmpl, {\n                                data: data\n                            });\n\n                            $(tmpl).insertAfter($(parentId));\n\n                            if (data['price_type']) { //eslint-disable-line max-depth\n                                priceType = $('#' + widget.options.fieldId + '_' + data['option_id'] + '_price_type');\n                                priceType.val(data['price_type']).attr('data-store-label', data['price_type']);\n                            }\n                            this._bindUseDefault(widget.options.fieldId + '_' + data['option_id'], data);\n                            //Add selections\n\n                            if (data.optionValues) { //eslint-disable-line max-depth\n                                data.optionValues.each(function (value) {\n                                    widget.addSelection(value);\n                                });\n                            }\n                        }\n                    }\n                },\n                //Sync title\n                'change .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle,\n                'keyup .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle,\n                'paste .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initSortableSelections: function () {\n            if (!this.options.isReadonly) {\n                this.element.find('[id^=product_option_][id$=_type_select] tbody').sortable({\n                    axis: 'y',\n                    handle: '[data-role=draggable-handle]',\n\n                    /** @inheritdoc */\n                    helper: function (event, ui) {\n                        ui.children().each(function () {\n                            $(this).width($(this).width());\n                        });\n\n                        return ui;\n                    },\n                    update: this._updateSelectionsPositions,\n                    tolerance: 'pointer'\n                });\n            }\n        },\n\n        /**\n         * Sync sort order checkbox with hidden dropdown\n         */\n        _bindCheckboxHandlers: function () {\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'change [id^=product_option_][id$=_required]': function (event) {\n                    var $this = $(event.target);\n\n                    $this.closest('#product_options_container_top > div')\n                        .find('[name$=\"[is_require]\"]').val($this.is(':checked') ? 1 : 0);\n                }\n            });\n            this.element.find('[id^=product_option_][id$=_required]').each(function () {\n                $(this).prop('checked', $(this).closest('#product_options_container_top > div')\n                        .find('[name$=\"[is_require]\"]').val() > 0);\n            });\n        },\n\n        /**\n         * Update Custom option position\n         */\n        _updateOptionBoxPositions: function () {\n            $(this).find('div[id^=option_]:not(.ignore-validate) .fieldset-alt > [name$=\"[sort_order]\"]').each(\n                function (index) {\n                    $(this).val(index);\n                });\n        },\n\n        /**\n         * Update selections positions for 'select' type of custom option\n         */\n        _updateSelectionsPositions: function () {\n            $(this).find('tr:not(.ignore-validate) [name$=\"[sort_order]\"]').each(function (index) {\n                $(this).val(index);\n            });\n        },\n\n        /**\n         * Disable input data if \"Read Only\"\n         */\n        _bindReadOnlyMode: function () {\n            if (this.options.isReadonly) {\n                $('div.product-custom-options').find('button,input,select,textarea').each(function () {\n                    $(this).prop('disabled', true);\n\n                    if ($(this).is('button')) {\n                        $(this).addClass('disabled');\n                    }\n                });\n            }\n        },\n\n        /**\n         * @param {String} id\n         * @param {Object} data\n         * @private\n         */\n        _bindUseDefault: function (id, data) {\n            var title = $('#' + id + '_title'),\n                price = $('#' + id + '_price'),\n                priceType = $('#' + id + '_price_type');\n\n            //enable 'use default' link for title\n            if (data.checkboxScopeTitle) {\n                title.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_title]',\n                    checkbox: 'input[id$=_title_use_default]',\n                    label: 'span'\n                });\n            }\n            //enable 'use default' link for price and price_type\n            if (data.checkboxScopePrice) {\n                price.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_price]',\n                    checkbox: 'input[id$=_price_use_default]',\n                    label: 'span'\n                });\n                //not work set default value for second field\n                priceType.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_price]',\n                    checkbox: 'input[id$=_price_use_default]',\n                    label: 'span'\n                });\n            }\n        },\n\n        /**\n         * Add selection value for 'select' type of custom option\n         */\n        addSelection: function (event) {\n            var data = {},\n                element = event.target || event.srcElement || event.currentTarget,\n                rowTmpl, priceType;\n\n            if (typeof element !== 'undefined') {\n                data.id = $(element).closest('#product_options_container_top > div')\n                    .find('[name^=\"product[options]\"][name$=\"[id]\"]').val();\n                data['option_type_id'] = -1;\n\n                if (!this.options.selectionItemCount[data.id]) {\n                    this.options.selectionItemCount[data.id] = 1;\n                }\n\n                data['select_id'] = this.options.selectionItemCount[data.id];\n                data.price = data.sku = '';\n            } else {\n                data = event;\n                data.id = data['option_id'];\n                data['select_id'] = data['option_type_id'];\n                this.options.selectionItemCount[data.id] = data['item_count'];\n            }\n\n            rowTmpl = this.rowTmpl({\n                data: data\n            });\n\n            $(rowTmpl).appendTo($('#select_option_type_row_' + data.id));\n\n            //set selected price_type value if set\n            if (data['price_type']) {\n                priceType = $('#' + this.options.fieldId + '_' + data.id + '_select_' + data['select_id'] +\n                    '_price_type');\n                priceType.val(data['price_type']).attr('data-store-label', data['price_type']);\n            }\n\n            this._bindUseDefault(this.options.fieldId + '_' + data.id + '_select_' + data['select_id'], data);\n            this.refreshSortableElements();\n            this.options.selectionItemCount[data.id] = parseInt(this.options.selectionItemCount[data.id], 10) + 1;\n\n            $('#' + this.options.fieldId + '_' + data.id + '_select_' + data['select_id'] + '_title').trigger('focus');\n        },\n\n        /**\n         * Add custom option\n         */\n        addOption: function (event) {\n            var data = {},\n                element = event.target || event.srcElement || event.currentTarget,\n                baseTmpl;\n\n            if (typeof element !== 'undefined') {\n                data.id = this.options.itemCount;\n                data.type = '';\n                data['option_id'] = 0;\n            } else {\n                data = event;\n                this.options.itemCount = data['item_count'];\n            }\n\n            baseTmpl = this.baseTmpl({\n                data: data\n            });\n\n            $(baseTmpl)\n                .appendTo(this.element.find('#product_options_container_top'))\n                .find('.collapse').collapsable();\n\n            //set selected type value if set\n            if (data.type) {\n                $('#' + this.options.fieldId + '_' + data.id + '_type').val(data.type).trigger('change', data);\n            }\n\n            //set selected is_require value if set\n            if (data['is_require']) {\n                $('#' + this.options.fieldId + '_' + data.id + '_is_require').val(data['is_require']).trigger('change');\n            }\n\n            this.refreshSortableElements();\n            this._bindCheckboxHandlers();\n            this._bindReadOnlyMode();\n            this.options.itemCount++;\n            $('#' + this.options.fieldId + '_' + data.id + '_title').trigger('change');\n        },\n\n        /**\n         * @return {Object}\n         */\n        refreshSortableElements: function () {\n            if (!this.options.isReadonly) {\n                this.element.sortable('refresh');\n                this._updateOptionBoxPositions.apply(this.element);\n                this._updateSelectionsPositions.apply(this.element);\n                this._initSortableSelections();\n            }\n\n            return this;\n        },\n\n        /**\n         * @param {String} id\n         * @return {*}\n         */\n        getFreeOptionId: function (id) {\n            return $('#' + this.options.fieldId + '_' + id).length ? this.getFreeOptionId(parseInt(id, 10) + 1) : id;\n        }\n    });\n\n});\n","Magento_Catalog/js/price-option-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'priceUtils',\n    'priceOptions',\n    'jquery-ui-modules/widget'\n], function ($, utils) {\n    'use strict';\n\n    var globalOptions = {\n            fromSelector: 'form',\n            dropdownsSelector: '[data-role=calendar-dropdown]'\n        },\n        optionHandler = {};\n\n    optionHandler.optionHandlers = {};\n\n    /**\n     * Custom handler for Date-with-Dropdowns option type.\n     * @param  {jQuery} siblings\n     * @return {Function} function that return object { optionHash : optionAdditionalPrice }\n     */\n    function onCalendarDropdownChange(siblings) {\n        return function (element, optionConfig) {\n            var changes = {},\n                optionId = utils.findOptionId(element),\n                overhead = optionConfig[optionId].prices,\n                isNeedToUpdate = true,\n                optionHash = 'price-option-calendar-' + optionId;\n\n            siblings.each(function (index, el) {\n                isNeedToUpdate = isNeedToUpdate && !!$(el).val();\n            });\n\n            overhead = isNeedToUpdate ? overhead : {};\n            changes[optionHash] = overhead;\n\n            return changes;\n        };\n    }\n\n    /**\n     * Returns number of days for special month and year\n     * @param  {Number} month\n     * @param  {Number} year\n     * @return {Number}\n     */\n    function getDaysInMonth(month, year) {\n        return new Date(year, month, 0).getDate();\n    }\n\n    /**\n     * Adjusts the number of days in the day option element based on which month or year\n     * is selected (changed). Adjusts the days to 28, 29, 30, or 31 typically.\n     * @param {jQuery} dropdowns\n     */\n    function onDateChange(dropdowns) {\n        var daysNodes,\n            curMonth, curYear, expectedDays,\n            options, needed,\n            month = dropdowns.filter('[data-calendar-role=month]'),\n            year = dropdowns.filter('[data-calendar-role=year]');\n\n        if (month.length && year.length) {\n            daysNodes = dropdowns.filter('[data-calendar-role=day]').find('option');\n\n            curMonth = month.val() || '01';\n            curYear = year.val() || '2000';\n            expectedDays = getDaysInMonth(curMonth, curYear);\n\n            if (daysNodes.length - 1 > expectedDays) { // remove unnecessary option nodes\n                daysNodes.each(function (i, e) {\n                    if (e.value > expectedDays) {\n                        $(e).remove();\n                    }\n                });\n            } else if (daysNodes.length - 1 < expectedDays) { // add missing option nodes\n                options = [];\n                needed = expectedDays - daysNodes.length + 1;\n\n                while (needed--) { //eslint-disable-line max-depth\n                    options.push(\n                        '<option value=\"' + (expectedDays - needed) + '\">' + (expectedDays - needed) + '</option>'\n                    );\n                }\n                $(options.join('')).insertAfter(daysNodes.last());\n            }\n        }\n    }\n\n    $.widget('mage.priceOptionDate', {\n        options: globalOptions,\n\n        /**\n         * Function-initializer of priceOptionDate widget\n         * @private\n         */\n        _create: function initOptionDate() {\n            var field = this.element,\n                form = field.closest(this.options.fromSelector),\n                dropdowns = $(this.options.dropdownsSelector, field),\n                dateOptionId;\n\n            if (dropdowns.length) {\n                dateOptionId = this.options.dropdownsSelector + dropdowns.attr('name');\n\n                optionHandler.optionHandlers[dateOptionId] = onCalendarDropdownChange(dropdowns);\n\n                form.priceOptions(optionHandler);\n\n                dropdowns.data('role', dateOptionId);\n                dropdowns.on('change', onDateChange.bind(this, dropdowns));\n            }\n        }\n    });\n\n    return $.mage.priceOptionDate;\n});\n","Magento_Catalog/js/options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\n// jscs:disable jsDoc\n\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'prototype',\n    'form',\n    'validation',\n    'mage/translate'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var optionPanel = jQuery('#manage-options-panel'),\n            editForm = jQuery('#edit_form'),\n            attributeOption = {\n                table: $('attribute-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                template: mageTemplate('#row-template'),\n                newOptionClass: 'new-option',\n                isReadOnly: config.isReadOnly,\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1,\n                            'rowClasses': this.newOptionClass\n                        };\n                        isNewOption = true;\n                    }\n\n                    if (!data.intype) {\n                        data.intype = this.getOptionInputType();\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                        this.updateItemsCountField();\n                    }\n                },\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n\n                    if (element.hasClassName(this.newOptionClass)) {\n                        element.remove();\n                    }\n                },\n                updateItemsCountField: function () {\n                    $('option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-visual-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n                render: function () {\n                    Element.insert($$('[data-role=options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                },\n                getOptionInputType: function () {\n                    var optionDefaultInputType = 'radio';\n\n                    if ($('frontend_input') && $('frontend_input').value === 'multiselect') {\n                        optionDefaultInputType = 'checkbox';\n                    }\n\n                    return optionDefaultInputType;\n                }\n            },\n            tableBody = jQuery(),\n            activePanelClass = 'selected-type-options';\n\n        if ($('add_new_option_button')) {\n            Event.observe('add_new_option_button', 'click', attributeOption.add.bind(attributeOption, {}, true));\n        }\n        $('manage-options-panel').on('click', '.delete-option', function (event) {\n            attributeOption.remove(event);\n        });\n\n        optionPanel.on('render', function () {\n            attributeOption.ignoreValidate();\n\n            if (attributeOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            attributeOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            attributeOption.bindRemoveButtons();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n                    update: function () {\n                        $('[data-role=options-container] [data-role=order]').each(function (index, element) {\n                            $(element).val(index + 1);\n                        });\n                    }\n                });\n            });\n        }\n        editForm.on('beforeSubmit', function () {\n            var optionContainer = optionPanel.find('table tbody'),\n                optionsValues;\n\n            if (optionPanel.hasClass(activePanelClass)) {\n                optionsValues = jQuery.map(\n                    optionContainer.find('tr'),\n                    function (row) {\n                        return jQuery(row).find('input, select, textarea').serialize();\n                    }\n                );\n                jQuery('<input>')\n                    .attr({\n                        type: 'hidden',\n                        name: 'serialized_options'\n                    })\n                    .val(JSON.stringify(optionsValues))\n                    .prependTo(editForm);\n            }\n            tableBody = optionContainer.detach();\n        });\n        editForm.on('afterValidate.error highlight.validate', function () {\n            if (optionPanel.hasClass(activePanelClass)) {\n                optionPanel.find('table').append(tableBody);\n                jQuery('input[name=\"serialized_options\"]').remove();\n            }\n        });\n        window.attributeOption = attributeOption;\n        window.optionDefaultInputType = attributeOption.getOptionInputType();\n\n        rg.set('manage-options-panel', attributeOption);\n    };\n});\n","Magento_Catalog/js/price-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery-ui-modules/widget'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        optionTemplate: '<%= data.label %>' +\n        '<% if (data.finalPrice.value > 0) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } else if (data.finalPrice.value < 0) { %>' +\n        ' <%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig) {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            $(this.options.optionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions() {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event) {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig[optionId];\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue] ? optionConfig[optionValue].prices : null;\n\n                    if (prices) {\n                        _.each(prices, function (price, type) {\n                            var value = +price.amount;\n\n                            value += _.reduce(price.adjustments, function (sum, x) { //eslint-disable-line\n                                return sum + x;\n                            }, 0);\n                            toTemplate.data[type] = {\n                                value: value,\n                                formatted: utils.formatPriceLocale(value, format)\n                            };\n                        });\n\n                        $option.text(template(toTemplate));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         * @private\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n            this._super(options);\n\n            return this;\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Magento_Catalog/js/edit-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\n// jscs:disable jsDoc\n\nrequire([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'loadingPopup',\n    'mage/backend/floating-header'\n], function (jQuery, confirm) {\n    'use strict';\n\n    /**\n     * Delete some category\n     * This routine get categoryId explicitly, so even if currently selected tree node is out of sync\n     * with this form, we surely delete same category in the tree and at backend.\n     *\n     * @deprecated\n     * @see deleteConfirm\n     */\n    function categoryDelete(url) {\n        confirm({\n            content: 'Are you sure you want to delete this category?',\n            actions: {\n                confirm: function () {\n                    location.href = url;\n                }\n            }\n        });\n    }\n\n    function displayLoadingMask() {\n        jQuery('body').loadingPopup();\n    }\n\n    window.categoryDelete = categoryDelete;\n    window.displayLoadingMask = displayLoadingMask;\n});\n","Magento_Catalog/js/new-category-dialog.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/*global FORM_KEY*/\ndefine([\n    'jquery',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/backend/tree-suggest',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    /** Clear parent category. */\n    var clearParentCategory = function () {\n        $('#new_category_parent').find('option').each(function () {\n            $('#new_category_parent-suggest').treeSuggest('removeOption', null, this);\n        });\n    };\n\n    $.widget('mage.newCategoryDialog', {\n        /** @inheritdoc */\n        _create: function () {\n            var widget = this,\n                newCategoryForm;\n\n            $('#new_category_parent').before($('<input>', {\n                id: 'new_category_parent-suggest',\n                placeholder: $.mage.__('start typing to search category')\n            }));\n\n            $('#new_category_parent-suggest').treeSuggest(this.options.suggestOptions)\n                .on('suggestbeforeselect', function (event) {\n                    clearParentCategory();\n                    $(event.target).treeSuggest('close');\n                });\n\n            $.validator.addMethod('validate-parent-category', function () {\n                return $('#new_category_parent').val() || $('#new_category_parent-suggest').val() === '';\n            }, $.mage.__('Choose existing category.'));\n            newCategoryForm = $('#new_category_form');\n            newCategoryForm.mage('validation', {\n                /**\n                 * @param {jQuery} error\n                 * @param {*} element\n                 */\n                errorPlacement: function (error, element) {\n                    error.insertAfter(element.is('#new_category_parent') ?\n                        $('#new_category_parent-suggest').closest('.mage-suggest') :\n                        element);\n                }\n            }).on('highlight.validate', function (e) {\n                var options = $(this).validation('option');\n\n                if ($(e.target).is('#new_category_parent')) {\n                    options.highlight($('#new_category_parent-suggest').get(0),\n                        options.errorClass, options.validClass || '');\n                }\n            });\n            this.element.modal({\n                type: 'slide',\n                modalClass: 'mage-new-category-dialog form-inline',\n                title: $.mage.__('Create Category'),\n\n                /** @inheritdoc */\n                opened: function () {\n                    var enteredName = $('#category_ids-suggest').val();\n\n                    $('#new_category_name').val(enteredName);\n\n                    if (enteredName === '') {\n                        $('#new_category_name').trigger('focus');\n                    }\n                    $('#new_category_messages').html('');\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    var validationOptions = newCategoryForm.validation('option');\n\n                    $('#new_category_name, #new_category_parent-suggest').val('');\n                    validationOptions.unhighlight($('#new_category_parent-suggest').get(0),\n                        validationOptions.errorClass, validationOptions.validClass || '');\n                    newCategoryForm.validation('clearError');\n                    $('#category_ids-suggest').trigger('focus');\n                },\n                buttons: [{\n                    text: $.mage.__('Create Category'),\n                    class: 'action-primary',\n\n                    /** @inheritdoc */\n                    click: function (e) {\n                        var thisButton;\n\n                        if (!newCategoryForm.valid()) {\n                            return;\n                        }\n                        thisButton = $(e.currentTarget);\n\n                        thisButton.prop('disabled', true);\n                        $.ajax({\n                            type: 'POST',\n                            url: widget.options.saveCategoryUrl,\n                            data: {\n                                name: $('#new_category_name').val(),\n                                parent: $('#new_category_parent').val(),\n                                'is_active': 1,\n                                'include_in_menu': 1,\n                                'use_config': ['available_sort_by', 'default_sort_by'],\n                                'form_key': FORM_KEY,\n                                'return_session_messages_only': 1\n                            },\n                            dataType: 'json',\n                            context: $('body')\n                        }).done(function (data) {\n                            var $suggest;\n\n                            if (!data.error) {\n                                $suggest = $('#category_ids-suggest');\n\n                                $suggest.trigger('selectItem', {\n                                    id: data.category['entity_id'],\n                                    label: data.category.name\n                                });\n                                $('#new_category_name, #new_category_parent-suggest').val('');\n                                $suggest.val('');\n                                clearParentCategory();\n                                $(widget.element).modal('closeModal');\n                            } else {\n                                $('#new_category_messages').html(data.messages);\n                            }\n                        }).always(\n                            function () {\n                                thisButton.prop('disabled', false);\n                            }\n                        );\n                    }\n                }]\n            });\n        }\n    });\n\n    return $.mage.newCategoryDialog;\n});\n","Magento_Catalog/js/price-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var globalPriceFormat = {\n        requiredPrecision: 2,\n        integerRequired: 1,\n        decimalSymbol: ',',\n        groupSymbol: ',',\n        groupLength: ','\n    };\n\n    /**\n     * Repeats {string} {times} times\n     * @param  {String} string\n     * @param  {Number} times\n     * @return {String}\n     */\n    function stringPad(string, times) {\n        return new Array(times + 1).join(string);\n    }\n\n    /**\n     * Format the price with the compliance to the specified locale\n     *\n     * @param {Number} amount\n     * @param {Object} format\n     * @param  {Boolean} isShowSign\n     */\n    function formatPriceLocale(amount, format, isShowSign)\n    {\n        var s = '',\n            precision, pattern, locale, r;\n\n        format = _.extend(globalPriceFormat, format);\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        pattern = format.pattern || '%s';\n        locale = window.LOCALE || 'en-US';\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n        amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision));\n        r = amount.toLocaleString(locale, {minimumFractionDigits: precision});\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Formatter for price amount\n     * @param  {Number}  amount\n     * @param  {Object}  format\n     * @param  {Boolean} isShowSign\n     * @return {String}              Formatted value\n     * @deprecated\n     */\n    function formatPrice(amount, format, isShowSign) {\n        var s = '',\n            precision, integerRequired, decimalSymbol, groupSymbol, groupLength, pattern, i, pad, j, re, r, am;\n\n        format = _.extend(globalPriceFormat, format);\n\n        // copied from price-option.js | Could be refactored with varien/js.js\n\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        integerRequired = isNaN(format.integerRequired = Math.abs(format.integerRequired)) ? 1 : format.integerRequired;\n        decimalSymbol = format.decimalSymbol === undefined ? ',' : format.decimalSymbol;\n        groupSymbol = format.groupSymbol === undefined ? '.' : format.groupSymbol;\n        groupLength = format.groupLength === undefined ? 3 : format.groupLength;\n        pattern = format.pattern || '%s';\n\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n\n        // we're avoiding the usage of to fixed, and using round instead with the e representation to address\n        // numbers like 1.005 = 1.01. Using ToFixed to only provide trailing zeroes in case we have a whole number\n        i = parseInt(\n                amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision)),\n                10\n            ) + '';\n        pad = i.length < integerRequired ? integerRequired - i.length : 0;\n\n        i = stringPad('0', pad) + i;\n\n        j = i.length > groupLength ? i.length % groupLength : 0;\n        re = new RegExp('(\\\\d{' + groupLength + '})(?=\\\\d)', 'g');\n\n        // replace(/-/, 0) is only for fixing Safari bug which appears\n        // when Math.abs(0).toFixed() executed on '0' number.\n        // Result is '0.-0' :(\n\n        am = Number(Math.round(Math.abs(amount - i) + 'e+' + precision) + ('e-' + precision));\n        r = (j ? i.substr(0, j) + groupSymbol : '') +\n            i.substr(j).replace(re, '$1' + groupSymbol) +\n            (precision ? decimalSymbol + am.toFixed(precision).replace(/-/, 0).slice(2) : '');\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Deep clone of Object. Doesn't support functions\n     * @param {Object} obj\n     * @return {Object}\n     */\n    function objectDeepClone(obj) {\n        return JSON.parse(JSON.stringify(obj));\n    }\n\n    /**\n     * Helper to find ID in name attribute\n     * @param   {jQuery} element\n     * @returns {undefined|String}\n     */\n    function findOptionId(element) {\n        var re, id, name;\n\n        if (!element) {\n            return id;\n        }\n        name = $(element).attr('name');\n\n        if (name.indexOf('[') !== -1) {\n            re = /\\[([^\\]]+)?\\]/;\n        } else {\n            re = /_([^\\]]+)?_/; // just to support file-type-option\n        }\n        id = re.exec(name) && re.exec(name)[1];\n\n        if (id) {\n            return id;\n        }\n    }\n\n    return {\n        formatPriceLocale: formatPriceLocale,\n        formatPrice: formatPrice,\n        deepClone: objectDeepClone,\n        strPad: stringPad,\n        findOptionId: findOptionId\n    };\n});\n","Magento_Catalog/js/category-checkbox-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Ext, varienWindowOnload, varienElementMethods */\n\ndefine([\n    'jquery',\n    'prototype',\n    'extjs/ext-tree-checkbox',\n    'mage/adminhtml/form'\n], function (jQuery) {\n    'use strict';\n\n    return function (config) {\n        var tree,\n            options = {\n                dataUrl: config.dataUrl,\n                divId: config.divId,\n                rootVisible: config.rootVisible,\n                useAjax: config.useAjax,\n                currentNodeId: config.currentNodeId,\n                jsFormObject: window[config.jsFormObject],\n                name: config.name,\n                checked: config.checked,\n                allowDrop: config.allowDrop,\n                rootId: config.rootId,\n                expanded: config.expanded,\n                categoryId: config.categoryId,\n                treeJson: config.treeJson\n            },\n            data = {},\n            parameters = {},\n            root = {},\n            key = '';\n\n        /**\n         * Fix ext compatibility with prototype 1.6\n         */\n        Ext.lib.Event.getTarget = function (e) {\n            var ee = e.browserEvent || e;\n\n            return ee.target ? Event.element(ee) : null;\n        };\n\n        /**\n         * @param {Object} el\n         * @param {Object} nodeConfig\n         */\n        Ext.tree.TreePanel.Enhanced = function (el, nodeConfig) {\n            Ext.tree.TreePanel.Enhanced.superclass.constructor.call(this, el, nodeConfig);\n        };\n\n        Ext.extend(Ext.tree.TreePanel.Enhanced, Ext.tree.TreePanel, {\n            /**\n             * @param {Object} treeConfig\n             * @param {Boolean} firstLoad\n             */\n            loadTree: function (treeConfig, firstLoad) {\n                parameters = treeConfig.parameters,\n                    data = treeConfig.data,\n                    root = new Ext.tree.TreeNode(parameters);\n\n                if (typeof parameters.rootVisible !== 'undefined') {\n                    this.rootVisible = parameters.rootVisible * 1;\n                }\n\n                this.nodeHash = {};\n                this.setRootNode(root);\n\n                if (firstLoad) {\n                    this.addListener('click', this.categoryClick.createDelegate(this));\n                }\n\n                this.loader.buildCategoryTree(root, data);\n                this.el.dom.innerHTML = '';\n                // render the tree\n                this.render();\n            },\n\n            /**\n             * @param {Object} node\n             */\n            categoryClick: function (node) {\n                node.getUI().check(!node.getUI().checked());\n            }\n        });\n\n        jQuery(function () {\n            var categoryLoader = new Ext.tree.TreeLoader({\n                dataUrl: config.dataUrl\n            });\n\n            /**\n             * @param {Object} response\n             * @param {Object} parent\n             * @param {Function} callback\n             */\n            categoryLoader.processResponse = function (response, parent, callback) {\n                config = JSON.parse(response.responseText);\n\n                this.buildCategoryTree(parent, config);\n\n                if (typeof callback === 'function') {\n                    callback(this, parent);\n                }\n            };\n\n            /**\n             * @param {Object} nodeConfig\n             * @returns {Object}\n             */\n            categoryLoader.createNode = function (nodeConfig) {\n                var node;\n\n                nodeConfig.uiProvider = Ext.tree.CheckboxNodeUI;\n\n                if (nodeConfig.children && !nodeConfig.children.length) {\n                    delete nodeConfig.children;\n                    node = new Ext.tree.AsyncTreeNode(nodeConfig);\n                } else {\n                    node = new Ext.tree.TreeNode(nodeConfig);\n                }\n\n                return node;\n            };\n\n            /**\n             * @param {Object} parent\n             * @param {Object} nodeConfig\n             * @param {Integer} i\n             */\n            categoryLoader.processCategoryTree = function (parent, nodeConfig, i) {\n                var node,\n                    _node = {};\n\n                nodeConfig[i].uiProvider = Ext.tree.CheckboxNodeUI;\n\n                _node = Object.clone(nodeConfig[i]);\n\n                if (_node.children && !_node.children.length) {\n                    delete _node.children;\n                    node = new Ext.tree.AsyncTreeNode(_node);\n                } else {\n                    node = new Ext.tree.TreeNode(nodeConfig[i]);\n                }\n                parent.appendChild(node);\n                node.loader = node.getOwnerTree().loader;\n\n                if (_node.children) {\n                    categoryLoader.buildCategoryTree(node, _node.children);\n                }\n            };\n\n            /**\n             * @param {Object} parent\n             * @param {Object} nodeConfig\n             * @returns {void}\n             */\n            categoryLoader.buildCategoryTree = function (parent, nodeConfig) {\n                var i = 0;\n\n                if (!nodeConfig) {\n                    return null;\n                }\n\n                if (parent && nodeConfig && nodeConfig.length) {\n                    for (i; i < nodeConfig.length; i++) {\n                        categoryLoader.processCategoryTree(parent, nodeConfig, i);\n                    }\n                }\n            };\n\n            /**\n             *\n             * @param {Object} hash\n             * @param {Object} node\n             * @returns {Object}\n             */\n            categoryLoader.buildHashChildren = function (hash, node) {\n                var i = 0,\n                    len;\n\n                if (node.childNodes.length > 0 || node.loaded === false && node.loading === false) {\n                    hash.children = [];\n\n                    for (i, len = node.childNodes.length; i < len; i++) {\n                        hash.children = hash.children ? hash.children : [];\n                        hash.children.push(this.buildHash(node.childNodes[i]));\n                    }\n                }\n\n                return hash;\n            };\n\n            /**\n             * @param {Object} node\n             * @returns {Object}\n             */\n            categoryLoader.buildHash = function (node) {\n                var hash = {};\n\n                hash = this.toArray(node.attributes);\n\n                return categoryLoader.buildHashChildren(hash, node);\n            };\n\n            /**\n             * @param {Object} attributes\n             * @returns {Object}\n             */\n            categoryLoader.toArray = function (attributes) {\n                data = {};\n\n                for (key in attributes) {\n\n                    if (attributes[key]) {\n                        data[key] = attributes[key];\n                    }\n                }\n\n                return data;\n            };\n\n            categoryLoader.on('beforeload', function (treeLoader, node) {\n                treeLoader.baseParams.id = node.attributes.id;\n                treeLoader.baseParams.selected = options.jsFormObject.updateElement.value;\n            });\n\n            categoryLoader.on('load', function () {\n                varienWindowOnload();\n            });\n\n            tree = new Ext.tree.TreePanel.Enhanced(options.divId, {\n                animate: false,\n                loader: categoryLoader,\n                enableDD: false,\n                containerScroll: true,\n                selModel: new Ext.tree.CheckNodeMultiSelectionModel(),\n                rootVisible: options.rootVisible,\n                useAjax: options.useAjax,\n                currentNodeId: options.currentNodeId,\n                addNodeTo: false,\n                rootUIProvider: Ext.tree.CheckboxNodeUI\n            });\n\n            tree.on('check', function (node) {\n                options.jsFormObject.updateElement.value = this.getChecked().join(', ');\n                varienElementMethods.setHasChanges(node.getUI().checkbox);\n            }, tree);\n\n            // set the root node\n            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            parameters = {\n                text: options.name,\n                draggable: false,\n                checked: options.checked,\n                uiProvider: Ext.tree.CheckboxNodeUI,\n                allowDrop: options.allowDrop,\n                id: options.rootId,\n                expanded: options.expanded,\n                category_id: options.categoryId\n            };\n            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            tree.loadTree({\n                parameters: parameters, data: options.treeJson\n            }, true);\n        });\n    };\n});\n","Magento_Catalog/js/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, utils, _, mageTemplate) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceConfig: null,\n        prices: {},\n        priceTemplate: '<span class=\"price\"><%- data.formatted %></span>'\n    };\n\n    $.widget('mage.priceBox', {\n        options: globalOptions,\n        qtyInfo: '#qty',\n\n        /**\n         * Widget initialisation.\n         * Every time when option changed prices also can be changed. So\n         * changed options.prices -> changed cached prices -> recalculation -> redraw price box\n         */\n        _init: function initPriceBox() {\n            var box = this.element;\n\n            box.trigger('updatePrice');\n            this.cache.displayPrices = utils.deepClone(this.options.prices);\n        },\n\n        /**\n         * Widget creating.\n         */\n        _create: function createPriceBox() {\n            var box = this.element;\n\n            this.cache = {};\n            this._setDefaultsFromPriceConfig();\n            this._setDefaultsFromDataSet();\n\n            box.on('reloadPrice', this.reloadPrice.bind(this));\n            box.on('updatePrice', this.onUpdatePrice.bind(this));\n            $(this.qtyInfo).on('input', this.updateProductTierPrice.bind(this));\n            box.trigger('price-box-initialized');\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updatePrice method.\n         * @param {Event} event\n         * @param {Object} prices\n         */\n        onUpdatePrice: function onUpdatePrice(event, prices) {\n            return this.updatePrice(prices);\n        },\n\n        /**\n         * Updates price via new (or additional values).\n         * It expects object like this:\n         * -----\n         *   \"option-hash\":\n         *      \"price-code\":\n         *         \"amount\": 999.99999,\n         *         ...\n         * -----\n         * Empty option-hash object or empty price-code object treats as zero amount.\n         * @param {Object} newPrices\n         */\n        updatePrice: function updatePrice(newPrices) {\n            var prices = this.cache.displayPrices,\n                additionalPrice = {},\n                pricesCode = [],\n                priceValue, origin, finalPrice;\n\n            this.cache.additionalPriceObject = this.cache.additionalPriceObject || {};\n\n            if (newPrices) {\n                $.extend(this.cache.additionalPriceObject, newPrices);\n            }\n\n            if (!_.isEmpty(additionalPrice)) {\n                pricesCode = _.keys(additionalPrice);\n            } else if (!_.isEmpty(prices)) {\n                pricesCode = _.keys(prices);\n            }\n\n            _.each(this.cache.additionalPriceObject, function (additional) {\n                if (additional && !_.isEmpty(additional)) {\n                    pricesCode = _.keys(additional);\n                }\n                _.each(pricesCode, function (priceCode) {\n                    priceValue = additional[priceCode] || {};\n                    priceValue.amount = +priceValue.amount || 0;\n                    priceValue.adjustments = priceValue.adjustments || {};\n\n                    additionalPrice[priceCode] = additionalPrice[priceCode] || {\n                        'amount': 0,\n                        'adjustments': {}\n                    };\n                    additionalPrice[priceCode].amount =  0 + (additionalPrice[priceCode].amount || 0) +\n                        priceValue.amount;\n                    _.each(priceValue.adjustments, function (adValue, adCode) {\n                        additionalPrice[priceCode].adjustments[adCode] = 0 +\n                            (additionalPrice[priceCode].adjustments[adCode] || 0) + adValue;\n                    });\n                });\n            });\n\n            if (_.isEmpty(additionalPrice)) {\n                this.cache.displayPrices = utils.deepClone(this.options.prices);\n            } else {\n                _.each(additionalPrice, function (option, priceCode) {\n                    origin = this.options.prices[priceCode] || {};\n                    finalPrice = prices[priceCode] || {};\n                    option.amount = option.amount || 0;\n                    origin.amount = origin.amount || 0;\n                    origin.adjustments = origin.adjustments || {};\n                    finalPrice.adjustments = finalPrice.adjustments || {};\n\n                    finalPrice.amount = 0 + origin.amount + option.amount;\n                    _.each(option.adjustments, function (pa, paCode) {\n                        finalPrice.adjustments[paCode] = 0 + (origin.adjustments[paCode] || 0) + pa;\n                    });\n                }, this);\n            }\n\n            this.element.trigger('priceUpdated', this.cache.displayPrices);\n            this.element.trigger('reloadPrice');\n        },\n\n        /*eslint-disable no-extra-parens*/\n        /**\n         * Render price unit block.\n         */\n        reloadPrice: function reDrawPrices() {\n            var priceFormat = (this.options.priceConfig && this.options.priceConfig.priceFormat) || {},\n                priceTemplate = mageTemplate(this.options.priceTemplate);\n\n            _.each(this.cache.displayPrices, function (price, priceCode) {\n                price.final = _.reduce(price.adjustments, function (memo, amount) {\n                    return memo + amount;\n                }, price.amount);\n\n                price.formatted = utils.formatPriceLocale(price.final, priceFormat);\n\n                $('[data-price-type=\"' + priceCode + '\"]', this.element).html(priceTemplate({\n                    data: price\n                }));\n            }, this);\n        },\n\n        /*eslint-enable no-extra-parens*/\n        /**\n         * Overwrites initial (default) prices object.\n         * @param {Object} prices\n         */\n        setDefault: function setDefaultPrices(prices) {\n            this.cache.displayPrices = utils.deepClone(prices);\n            this.options.prices = utils.deepClone(prices);\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge of accepted configuration.\n         * @param  {Object} options\n         * @return {mage.priceBox}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            if ('disabled' in options) {\n                this._setOption('disabled', options.disabled);\n            }\n\n            return this;\n        },\n\n        /**\n         * setDefaultsFromDataSet\n         */\n        _setDefaultsFromDataSet: function _setDefaultsFromDataSet() {\n            var box = this.element,\n                priceHolders = $('[data-price-type]', box),\n                prices = this.options.prices;\n\n            this.options.productId = box.data('productId');\n\n            if (_.isEmpty(prices)) {\n                priceHolders.each(function (index, element) {\n                    var type = $(element).data('priceType'),\n                        amount = parseFloat($(element).data('priceAmount'));\n\n                    if (type && !_.isNaN(amount)) {\n                        prices[type] = {\n                            amount: amount\n                        };\n                    }\n                });\n            }\n        },\n\n        /**\n         * setDefaultsFromPriceConfig\n         */\n        _setDefaultsFromPriceConfig: function _setDefaultsFromPriceConfig() {\n            var config = this.options.priceConfig;\n\n            if (config && config.prices) {\n                this.options.prices = config.prices;\n            }\n        },\n\n        /**\n         * Updates product final and base price according to tier prices\n         */\n        updateProductTierPrice: function updateProductTierPrice() {\n            var originalPrice,\n                prices = {'prices': {}};\n\n            if (this.options.prices.finalPrice) {\n                originalPrice = this.options.prices.finalPrice.amount;\n                prices.prices.finalPrice = {'amount': this.getPrice('price') - originalPrice};\n            }\n\n            if (this.options.prices.basePrice) {\n                originalPrice = this.options.prices.basePrice.amount;\n                prices.prices.basePrice = {'amount': this.getPrice('basePrice') - originalPrice};\n            }\n\n            this.updatePrice(prices);\n        },\n\n        /**\n         * Returns price.\n         *\n         * @param {String} priceKey\n         * @returns {Number}\n         */\n        getPrice: function (priceKey) {\n            var productQty = $(this.qtyInfo).val(),\n                result,\n                tierPriceItem,\n                i;\n\n            for (i = 0; i < this.options.priceConfig.tierPrices.length; i++) {\n                tierPriceItem = this.options.priceConfig.tierPrices[i];\n                if (productQty >= tierPriceItem.qty && tierPriceItem[priceKey]) {\n                    result = tierPriceItem[priceKey];\n                }\n            }\n\n            return result;\n        }\n    });\n\n    return $.mage.priceBox;\n});\n","Magento_Catalog/js/bundle-proxy-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'uiRegistry',\n    'underscore'\n], function (Button, registry, _) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            currentRecordNamespace: 'bundle_current_record',\n            listingDataProvider: '',\n            value: [],\n            imports: {\n                currentRecordName: '${ $.provider }:${ $.currentRecordNamespace }',\n                listingData: '${ $.provider }:${ $.listingDataProvider }'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            },\n            listens: {\n                listingData: 'setListingData'\n            }\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSource();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'value',\n                    'listingData'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Calls 'destroy' of parent and\n         * clear listing provider source\n         *\n         * @returns {Object} Chainable.\n         */\n        destroy: function () {\n            this._super();\n            this.source.set(this.listingDataProvider, []);\n\n            return this;\n        },\n\n        /**\n         * Call parent \"action\" method\n         * and set new data to record and listing.\n         *\n         * @returns {Object} Chainable.\n         */\n\n        action: function () {\n            this._super();\n            this.source.set(this.currentRecordNamespace, this.name);\n            this.source.set(this.listingDataProvider, this.value());\n\n            return this;\n        },\n\n        /**\n         * Init current source.\n         *\n         * @returns {Object} Chainable.\n         */\n        initSource: function () {\n            if (!_.isFunction(this.source)) {\n                this.source = registry.get(this.provider);\n            }\n\n            return this;\n        },\n\n        /**\n         * Set data to listing source.\n         *\n         * @returns {Object} Chainable.\n         */\n        setListingData: function (data) {\n            if (this.name === this.currentRecordName) {\n                this.source.set(this.dataScope, data);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/custom-options-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/ui-select'\n], function ($, _, registry, UiSelect) {\n    'use strict';\n\n    return UiSelect.extend({\n        defaults: {\n            previousGroup: null,\n            groupsConfig: {},\n            valuesMap: {},\n            indexesMap: {},\n            filterPlaceholder: 'ns = ${ $.ns }, parentScope = ${ $.parentScope }'\n        },\n\n        /**\n         * Initialize component.\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .initMapping()\n                .updateComponents(this.initialValue, true);\n        },\n\n        /**\n         * Create additional mappings.\n         *\n         * @returns {Element}\n         */\n        initMapping: function () {\n            _.each(this.groupsConfig, function (groupData, group) {\n                _.each(groupData.values, function (value) {\n                    this.valuesMap[value] = group;\n                }, this);\n\n                _.each(groupData.indexes, function (index) {\n                    if (!this.indexesMap[index]) {\n                        this.indexesMap[index] = [];\n                    }\n\n                    this.indexesMap[index].push(group);\n                }, this);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         *\n         * @param {String} currentValue\n         * @returns {*}\n         */\n        onUpdate: function (currentValue) {\n            this.updateComponents(currentValue);\n\n            return this._super();\n        },\n\n        /**\n         * Show, hide or clear components based on the current type value.\n         *\n         * @param {String} currentValue\n         * @param {Boolean} isInitialization\n         * @returns {Element}\n         */\n        updateComponents: function (currentValue, isInitialization) {\n            var currentGroup = this.valuesMap[currentValue];\n\n            if (currentGroup !== this.previousGroup) {\n                _.each(this.indexesMap, function (groups, index) {\n                    var template = this.filterPlaceholder + ', index = ' + index,\n                        visible = groups.indexOf(currentGroup) !== -1,\n                        component;\n\n                    switch (index) {\n                        case 'container_type_static':\n                        case 'values':\n                            template = 'ns=' + this.ns +\n                                ', dataScope=' + this.parentScope +\n                                ', index=' + index;\n                            break;\n                    }\n\n                    /*eslint-disable max-depth */\n                    if (isInitialization) {\n                        registry.async(template)(\n                            function (currentComponent) {\n                                currentComponent.visible(visible);\n                            }\n                        );\n                    } else {\n                        component = registry.get(template);\n\n                        if (component) {\n                            component.visible(visible);\n                        }\n                    }\n                }, this);\n\n                this.previousGroup = currentGroup;\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/form/element/checkbox.js":"/**\r\n * Copyright \u00a9 Magento, Inc. All rights reserved.\r\n * See COPYING.txt for license details.\r\n */\r\n\r\ndefine([\r\n    'Magento_Ui/js/form/element/single-checkbox'\r\n], function (Checkbox) {\r\n    'use strict';\r\n\r\n    return Checkbox.extend({\r\n        defaults: {\r\n            inputCheckBoxName: '',\r\n            prefixElementName: '',\r\n            parentDynamicRowName: 'visual_swatch'\r\n        },\r\n\r\n        /**\r\n         * Parses options and merges the result with instance\r\n         *\r\n         * @returns {Object} Chainable.\r\n         */\r\n        initConfig: function () {\r\n            this._super();\r\n            this.configureDataScope();\r\n\r\n            return this;\r\n        },\r\n\r\n        /** @inheritdoc */\r\n        initialize: function () {\r\n            this._super();\r\n\r\n            if (this.rows && this.rows().elems().length === 0) {\r\n                this.checked(true);\r\n            }\r\n\r\n            return this;\r\n        },\r\n\r\n        /**\r\n         * Configure data scope.\r\n         */\r\n        configureDataScope: function () {\r\n            var recordId,\r\n                value;\r\n\r\n            recordId = this.parentName.split('.').last();\r\n            value = this.prefixElementName + recordId;\r\n\r\n            this.dataScope = 'data.' + this.inputCheckBoxName;\r\n            this.inputName = this.dataScopeToHtmlArray(this.inputCheckBoxName);\r\n\r\n            this.initialValue = value;\r\n\r\n            this.links.value = this.provider + ':' + this.dataScope;\r\n        },\r\n\r\n        /**\r\n         * Get HTML array from data scope.\r\n         *\r\n         * @param {String} dataScopeString\r\n         * @returns {String}\r\n         */\r\n        dataScopeToHtmlArray: function (dataScopeString) {\r\n            var dataScopeArray, dataScope, reduceFunction;\r\n\r\n            /**\r\n             * Add new level of nesting.\r\n             *\r\n             * @param {String} prev\r\n             * @param {String} curr\r\n             * @returns {String}\r\n             */\r\n            reduceFunction = function (prev, curr) {\r\n                return prev + '[' + curr + ']';\r\n            };\r\n\r\n            dataScopeArray = dataScopeString.split('.');\r\n\r\n            dataScope = dataScopeArray.shift();\r\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\r\n\r\n            return dataScope;\r\n        }\r\n    });\r\n});\r\n","Magento_Catalog/js/form/element/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            suffixName: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId,\n                prefixName,\n                suffixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '[' + this.suffixName + ']';\n            }\n            this.inputName = prefixName + '[' + this.elementName + ']' + suffixName;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '.' + this.suffixName;\n            }\n\n            this.exportDataLink = 'data.' + this.prefixName + '.' + this.elementName + suffixName;\n            this.exports.value = this.provider + ':' + this.exportDataLink;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n\n            this.source.remove(this.exportDataLink);\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Add new level of nesting.\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        }\n    });\n});\n","Magento_Catalog/js/form/element/action-delete.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            suffixName: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @param  {Object} config\n         * @returns {Object} Chainable.\n         */\n        initConfig: function (config) {\n            this._super(config);\n\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId,\n                prefixName,\n                suffixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '[' + this.suffixName + ']';\n            }\n            this.inputName = prefixName + '[' + this.elementName + ']' + suffixName;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '.' + this.suffixName;\n            }\n            this.dataScope = 'data.' + this.prefixName + '.' + this.elementName + suffixName;\n\n            this.links.value = this.provider + ':' + this.dataScope;\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Reduce\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        },\n\n        /**\n         * Delete record instance\n         * update data provider dataScope\n         *\n         * @param {Object} parents\n         */\n        deleteRecord: function (parents) {\n            this.value(1);\n            parents[1].deleteRecord(parents[0].index, parents[0].recordId);\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/new-category.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Parse data and set it to options.\n         *\n         * @param {Object} data - Response data object.\n         * @returns {Object}\n         */\n        setParsed: function (data) {\n            var option = this.parseData(data);\n\n            if (data.error) {\n                return this;\n            }\n\n            this.options([]);\n            this.setOption(option);\n            this.set('newOption', option);\n        },\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': data.category['is_active'],\n                level: data.category.level,\n                value: data.category['entity_id'],\n                label: data.category.name,\n                parent: data.category.parent\n            };\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-per-page.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'rjsResolver'\n], function (DynamicRows, _, utils, layout, resolver) {\n    'use strict';\n\n    return DynamicRows.extend({\n        defaults: {\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                options: {\n                    '20': {\n                        value: 20,\n                        label: 20\n                    },\n                    '30': {\n                        value: 30,\n                        label: 30\n                    },\n                    '50': {\n                        value: 50,\n                        label: 50\n                    },\n                    '100': {\n                        value: 100,\n                        label: 100\n                    },\n                    '200': {\n                        value: 200,\n                        label: 200\n                    }\n                },\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                },\n                enabled: false\n            },\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n            listens: {\n                'pageSize': 'onPageSizeChange'\n            },\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes();\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            if (this.sizesConfig.enabled) {\n                layout([this.sizesConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'pageSize'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            resolver(function () {\n                if (this.elems().length) {\n                    this.reload();\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Catalog/js/components/product-ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated see Magento/Ui/view/base/web/js/grid/filters/elements/ui-select.js\n */\ndefine([\n    'Magento_Ui/js/form/element/ui-select',\n    'jquery',\n    'underscore'\n], function (Select, $, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            validationUrl: false,\n            loadedOption: [],\n            validationLoading: true\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.validateInitialValue();\n\n            return this;\n        },\n\n        /**\n         * Validate initial value actually exists\n         */\n        validateInitialValue: function () {\n            if (!_.isEmpty(this.value())) {\n                $.ajax({\n                    url: this.validationUrl,\n                    type: 'GET',\n                    dataType: 'json',\n                    context: this,\n                    data: {\n                        productId: this.value()\n                    },\n\n                    /** @param {Object} response */\n                    success: function (response) {\n                        if (!_.isEmpty(response)) {\n                            this.options([response]);\n                            this.loadedOption = response;\n                        }\n                    },\n\n                    /** set empty array if error occurs */\n                    error: function () {\n                        this.options([]);\n                    },\n\n                    /** stop loader */\n                    complete: function () {\n                        this.validationLoading(false);\n                        this.setCaption();\n                    }\n                });\n            } else {\n                this.validationLoading(false);\n            }\n        },\n\n        /** @inheritdoc */\n        getSelected: function () {\n            var options = this._super();\n\n            if (!_.isEmpty(this.loadedOption)) {\n                return this.value() === this.loadedOption.value ? [this.loadedOption] : options;\n            }\n\n            return options;\n        }\n    });\n});\n","Magento_Catalog/js/components/url-key-handle-changes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Checkbox) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            imports: {\n                handleUseDefault: '${ $.parentName }.use_default.url_key:checked',\n                urlKey: '${ $.provider }:data.url_key'\n            },\n            listens: {\n                urlKey: 'handleChanges'\n            },\n            modules: {\n                useDefault: '${ $.parentName }.use_default.url_key'\n            }\n        },\n\n        /**\n         * Disable checkbox field, when 'url_key' field without changes or 'use default' field is checked\n         */\n        handleChanges: function (newValue) {\n            this.disabled(newValue === this.valueMap['true'] || this.useDefault.checked);\n        },\n\n        /**\n         * Disable checkbox field, when 'url_key' field without changes or 'use default' field is checked\n         */\n        handleUseDefault: function (checkedUseDefault) {\n            this.disabled(this.urlKey === this.valueMap['true'] || checkedUseDefault);\n        }\n    });\n});\n","Magento_Catalog/js/components/checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'knockout'\n], function (Abstract, ko) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Element} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('checked');\n\n            this.value = ko.pureComputed({\n\n                /**\n                 * use 'mappedValue' as value if checked\n                 */\n                read: function () {\n                    return this.checked() ? this.mappedValue : '';\n                },\n\n                /**\n                 * any value made checkbox checked\n                 */\n                write: function (val) {\n                    if (val) {\n                        this.checked(true);\n                    }\n                },\n                owner: this\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/custom-options-component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.addBefore(this.addbefore);\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initObservable: function () {\n            this._super();\n\n            this.observe('addBefore');\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function ($, registry, _, InsertListing) {\n    'use strict';\n\n    return InsertListing.extend({\n        defaults: {\n            addAttributeUrl: '',\n            attributeSetId: '',\n            attributeIds: '',\n            groupCode: '',\n            groupName: '',\n            groupSortOrder: 0,\n            productId: 0,\n            formProvider: '',\n            modules: {\n                form: '${ $.formProvider }',\n                modal: '${ $.parentName }'\n            },\n            productType: ''\n        },\n\n        /**\n         * Render attribute\n         */\n        render: function () {\n            this._super();\n        },\n\n        /**\n         * Save attribute\n         */\n        save: function () {\n            this.addSelectedAttributes();\n            this._super();\n        },\n\n        /**\n         * Add selected attributes\n         */\n        addSelectedAttributes: function () {\n            $.ajax({\n                url: this.addAttributeUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: {\n                    attributeIds: this.selections().getSelections(),\n                    templateId: this.attributeSetId,\n                    groupCode: this.groupCode,\n                    groupName: this.groupName,\n                    groupSortOrder: this.groupSortOrder,\n                    productId: this.productId,\n                    componentJson: 1\n                },\n                success: function () {\n                    this.form().params = {\n                        set: this.attributeSetId,\n                        id: this.productId,\n                        type: this.productType\n                    };\n                    this.form().reload();\n                    this.modal().state(false);\n                    this.reload();\n                }.bind(this)\n            });\n        }\n    });\n});\n","Magento_Catalog/js/components/website-currency-symbol.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            currenciesForWebsites: {},\n            tracks: {\n                currency: true\n            }\n        },\n\n        /**\n         * Set currency symbol per website\n         *\n         * @param {String} value - currency symbol\n         */\n        setDifferedFromDefault: function (value) {\n            this.currency = this.currenciesForWebsites[value];\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/js/components/attribute-set-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            listens: {\n                'value': 'changeFormSubmitUrl'\n            },\n            modules: {\n                formProvider: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Change set parameter in save and validate urls of form\n         *\n         * @param {String|Number} value\n         */\n        changeFormSubmitUrl: function (value) {\n            var pattern = /(set\\/)(\\d)*?\\//,\n                change = '$1' + value + '/';\n\n            this.formProvider().client.urls.save = this.formProvider().client.urls.save.replace(pattern, change);\n            this.formProvider().client.urls.beforeSave = this.formProvider().client.urls.beforeSave.replace(\n                pattern,\n                change\n            );\n        }\n    });\n});\n","Magento_Catalog/js/components/reset-dynamic-rows-grid-row-position-on-delete.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'rjsResolver',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid'\n], function (_, registry, resolver, dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n\n        /** @inheritdoc */\n        deleteRecord: function () {\n            this._super();\n            this.resetPosition();\n        },\n\n        /**\n         * Reset the position on delete of the record.\n         */\n        resetPosition() {\n            let self = this,\n                position = 0;\n\n            _.filter(this.elems(), function (elem, index) {\n                if (index === 0) {\n                    position = (self.currentPage() - 1) * self.pageSize + 1;\n                }\n                _.filter(elem.elems(),function (childElem) {\n                    if (childElem.index === 'position') {\n                        childElem.value(position);\n                    }\n                });\n                position++;\n            });\n        },\n\n        /** @inheritdoc */\n        nextPage: function () {\n            this._super();\n            resolver(function () {\n                if (this.elems().length) {\n                    this.resetPosition();\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-grid-paging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/paging',\n    'underscore'\n], function (Paging, _) {\n    'use strict';\n\n    return Paging.extend({\n        defaults: {\n            totalTmpl: 'Magento_Catalog/attributes/grid/paging',\n            modules: {\n                selectionColumn: '${ $.selectProvider }'\n            },\n            listens: {\n                '${ $.selectProvider }:selected': 'changeLabel'\n            },\n            label: '',\n            selectedAttrs: []\n        },\n\n        /**\n         * Change label.\n         *\n         * @param {Array} selected\n         */\n        changeLabel: function (selected) {\n            this.selectedAttrs = [];\n            _.each(this.selectionColumn().rows(), function (row) {\n                if (selected.indexOf(row['attribute_id']) !== -1) {\n                    this.selectedAttrs.push(row['attribute_code']);\n                }\n            }, this);\n\n            this.label(this.selectedAttrs.join(', '));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('label');\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/disable-hide-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/visible-on-option/strategy',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, visibleStrategy, disableStrategy) {\n    'use strict';\n\n    return Element.extend(visibleStrategy).extend(disableStrategy);\n});\n","Magento_Catalog/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (_, Select, uiRegistry) {\n    'use strict';\n\n    return Select.extend({\n        /**\n         * {@inheritdoc}\n         */\n        onUpdate: function () {\n            this._super();\n\n            this.updateAddBeforeForPrice();\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.updateAddBeforeForPrice();\n\n            return this;\n        },\n\n        /**\n         * Update addbefore for price field. Change it to currency or % depends of price_type value.\n         */\n        updateAddBeforeForPrice: function () {\n            var addBefore, currentValue, priceIndex, priceName, uiPrice;\n\n            priceIndex = typeof this.imports.priceIndex == 'undefined' ? 'price' : this.imports.priceIndex;\n            priceName = this.parentName + '.' + priceIndex;\n\n            uiPrice = uiRegistry.get(priceName);\n\n            if (uiPrice && uiPrice.addbeforePool) {\n                currentValue = this.value();\n\n                uiPrice.addbeforePool.forEach(function (item) {\n                    if (item.value === currentValue) {\n                        addBefore = item.label;\n                    }\n                });\n\n                if (typeof addBefore != 'undefined') {\n                    uiPrice.addBefore(addBefore);\n                }\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-tier-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function (_, DynamicRows) {\n    'use strict';\n\n    /**\n     * @deprecated Parent method contains labels sorting.\n     * @see Magento_Ui/js/dynamic-rows/dynamic-rows\n     */\n    return DynamicRows.extend({\n\n        /**\n         * Init header elements\n         */\n        initHeader: function () {\n            var labels;\n\n            this._super();\n            labels = _.clone(this.labels());\n            labels = _.sortBy(labels, function (label) {\n                return label.sortOrder;\n            });\n\n            this.labels(labels);\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/core/app'\n], function (Fieldset, app) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:additionalAttributes': 'onAttributeAdd'\n            }\n        },\n\n        /**\n         * On attribute add trigger\n         *\n         * @param {Object} listOfNewAttributes\n         */\n        onAttributeAdd: function (listOfNewAttributes) {\n            app(listOfNewAttributes, true);\n        }\n    });\n});\n","Magento_Catalog/js/components/import-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'underscore',\n    'uiRegistry'\n], function (Abstract, _, registry) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            allowImport: true,\n            autoImportIfEmpty: false,\n            values: {},\n            mask: '',\n            queryTemplate: 'ns = ${ $.ns }, index = '\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            if (this.allowImport) {\n                this.setHandlers();\n            }\n        },\n\n        /**\n         * Split mask placeholder and attach events to placeholder fields.\n         */\n        setHandlers: function () {\n            var str = this.mask || '',\n                placeholders;\n\n            placeholders = str.match(/{{(.*?)}}/g); // Get placeholders\n\n            _.each(placeholders, function (placeholder) {\n                placeholder = placeholder.replace(/[{{}}]/g, ''); // Remove curly braces\n\n                registry.get(this.queryTemplate + placeholder, function (component) {\n                    this.values[placeholder] = component.getPreview();\n                    component.on('value', this.updateValue.bind(this, placeholder, component));\n                    component.valueUpdate = 'keyup';\n                }.bind(this));\n            }, this);\n        },\n\n        /**\n         * Update field with mask value, if it's allowed.\n         *\n         * @param {Object} placeholder\n         * @param {Object} component\n         */\n        updateValue: function (placeholder, component) {\n            var string = this.mask || '',\n                nonEmptyValueFlag = false;\n\n            if (placeholder) {\n                this.values[placeholder] = component.getPreview() || '';\n            }\n\n            if (!this.allowImport) {\n                return;\n            }\n\n            _.each(this.values, function (propertyValue, propertyName) {\n                string = string.replace('{{' + propertyName + '}}', propertyValue);\n                nonEmptyValueFlag = nonEmptyValueFlag || !!propertyValue;\n            });\n\n            if (nonEmptyValueFlag) {\n                string = string.replace(/(<([^>]+)>)/ig, ''); // Remove html tags\n                this.value(string);\n            } else {\n                this.value('');\n            }\n        },\n\n        /**\n         * Disallow import when initial value isn't empty string\n         *\n         * @returns {*}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            if (this.initialValue !== '') {\n                this.allowImport = false;\n            }\n\n            return this;\n        },\n\n        /**\n         *  Callback when value is changed by user,\n         *  and disallow/allow import value\n         */\n        userChanges: function () {\n\n            /**\n             *  As userChanges is called before updateValue,\n             *  we forced to get value from component by reference\n             */\n            var actualValue = arguments[1].currentTarget.value;\n\n            this._super();\n\n            if (actualValue === '') {\n                this.allowImport = true;\n\n                if (this.autoImportIfEmpty) {\n                    this.updateValue(null, null);\n                }\n            } else {\n                this.allowImport = false;\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-import-custom-options-per-page.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Catalog/js/components/dynamic-rows-import-custom-options',\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'rjsResolver'\n], function (DrCustomOptions, _, utils, layout, resolver) {\n    'use strict';\n\n    return DrCustomOptions.extend({\n        defaults: {\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                options: {\n                    '20': {\n                        value: 20,\n                        label: 20\n                    },\n                    '30': {\n                        value: 30,\n                        label: 30\n                    },\n                    '50': {\n                        value: 50,\n                        label: 50\n                    },\n                    '100': {\n                        value: 100,\n                        label: 100\n                    },\n                    '200': {\n                        value: 200,\n                        label: 200\n                    }\n                },\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                },\n                enabled: false\n            },\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n            listens: {\n                'pageSize': 'onPageSizeChange'\n            },\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes();\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            if (this.sizesConfig.enabled) {\n                layout([this.sizesConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'pageSize'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            resolver(function () {\n                if (this.elems().length) {\n                    this.reload();\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Catalog/js/components/new-attribute-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_Ui/js/modal/alert'\n], function ($, Form, prompt, alert) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            newSetPromptMessage: '',\n            listens: {\n                responseData: 'processResponseData'\n            },\n            modules: {\n                productForm: 'product_form.product_form'\n            }\n        },\n\n        /**\n         * Process response data\n         *\n         * @param {Object} data\n         */\n        processResponseData: function (data) {\n            if (data.params['new_attribute_set_id']) {\n                this.productForm().params = {\n                    set: data.params['new_attribute_set_id']\n                };\n            }\n        },\n\n        /**\n         * Process Save In New Attribute Set prompt\n         */\n        saveAttributeInNewSet: function () {\n\n            var self = this;\n\n            this.validate();\n\n            if (!this.additionalInvalid && !this.source.get('params.invalid')) {\n                prompt({\n                    content: this.newSetPromptMessage,\n                    actions: {\n\n                        /**\n                         * @param {String} val\n                         * @this {actions}\n                         */\n                        confirm: function (val) {\n                            var rules = ['required-entry', 'validate-no-html-tags'],\n                                editForm = self,\n                                newAttributeSetName = val,\n                                i,\n                                params = {};\n\n                            if (!newAttributeSetName) {\n                                return;\n                            }\n\n                            for (i = 0; i < rules.length; i++) {\n                                if (!$.validator.methods[rules[i]](newAttributeSetName)) {\n                                    alert({\n                                        content: $.validator.messages[rules[i]]\n                                    });\n\n                                    return;\n                                }\n                            }\n\n                            params['new_attribute_set_name'] = newAttributeSetName;\n                            editForm.setAdditionalData(params);\n                            editForm.save();\n                        }\n                    }\n                });\n            } else {\n                this.focusInvalid();\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            form: '${ $.namespace }.${ $.namespace }',\n            visible: false,\n            imports: {\n                responseData: '${ $.form }:responseData',\n                visible: 'responseData.error',\n                content: 'responseData.messages'\n            },\n            listens: {\n                '${ $.provider }:data.reset': 'hide'\n            }\n        },\n\n        /**\n         * Show messages.\n         */\n        show: function () {\n            this.visible(true);\n        },\n\n        /**\n         * Hide messages.\n         */\n        hide: function () {\n            this.visible(false);\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-import-custom-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid',\n    'underscore',\n    'mageUtils'\n], function (DynamicRows, _, utils) {\n    'use strict';\n\n    return DynamicRows.extend({\n        defaults: {\n            mappingSettings: {\n                enabled: false,\n                distinct: false\n            },\n            update: true,\n            map: {\n                'option_id': 'option_id'\n            },\n            identificationProperty: 'option_id',\n            identificationDRProperty: 'option_id'\n        },\n\n        /** @inheritdoc */\n        processingInsertData: function (data) {\n            var options = [],\n                currentOption,\n                generalContext = this;\n\n            if (!data) {\n                return;\n            }\n            _.each(data, function (item) {\n                if (!item.options) {\n                    return;\n                }\n                _.each(item.options, function (option) {\n                    currentOption = utils.copy(option);\n\n                    if (currentOption.hasOwnProperty('option_id')) {\n                        delete currentOption['option_id'];\n                    }\n\n                    if (currentOption.values.length > 0) {\n                        generalContext.removeOptionsIds(currentOption.values);\n                    }\n                    options.push(currentOption);\n                });\n            });\n\n            if (!options.length) {\n                return;\n            }\n            this.cacheGridData = options;\n            _.each(options, function (opt) {\n                this.mappingValue(opt);\n            }, this);\n\n            this.insertData([]);\n        },\n\n        /**\n         * Removes option_id and option_type_id from every option\n         *\n         * @param {Array} options\n         */\n        removeOptionsIds: function (options) {\n            _.each(options, function (optionValue) {\n                delete optionValue['option_id'];\n                delete optionValue['option_type_id'];\n            });\n        },\n\n        /** @inheritdoc */\n        processingAddChild: function (ctx, index, prop) {\n            if (!ctx) {\n                this.showSpinner(true);\n                this.addChild(ctx, index, prop);\n\n                return;\n            }\n\n            this._super(ctx, index, prop);\n        },\n\n        /**\n         * Set empty array to dataProvider\n         */\n        clearDataProvider: function () {\n            this.source.set(this.dataProvider, []);\n        },\n\n        /**\n         * Mutes parent method\n         */\n        updateInsertData: function () {\n            return false;\n        }\n    });\n});\n","Magento_Catalog/js/components/new-attribute-insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (InsertForm) {\n    'use strict';\n\n    return InsertForm.extend({\n        defaults: {\n            modules: {\n                productForm: 'product_form.product_form'\n            },\n            listens: {\n                responseStatus: 'processResponseStatus'\n            },\n            attributeSetId: 0,\n            productId: 0\n        },\n\n        /**\n         * Process response status.\n         */\n        processResponseStatus: function () {\n            if (this.responseStatus()) {\n\n                if (this.productForm().params === undefined) {\n                    this.productForm().params = {\n                        set: this.attributeSetId\n                    };\n                }\n\n                if (this.productId) {\n                    this.productForm().params.id = this.productId;\n                }\n                this.productForm().params.type = this.productType;\n\n                this.productForm().reload();\n                this.resetForm();\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/visible-on-option/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/yesno.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/date',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/textarea',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/strategy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        defaults: {\n            valuesForOptions: [],\n            imports: {\n                toggleVisibility:\n                    'product_attribute_add_form.product_attribute_add_form.base_fieldset.frontend_input:value'\n            },\n            isShown: false,\n            inverseVisibility: false\n        },\n\n        /**\n         * Toggle visibility state.\n         *\n         * @param {Number} selected\n         */\n        toggleVisibility: function (selected) {\n            this.isShown = selected in this.valuesForOptions;\n            this.visible(this.inverseVisibility ? !this.isShown : this.isShown);\n        }\n    };\n});\n","Magento_Catalog/js/components/visible-on-option/fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Fieldset, strategy) {\n    'use strict';\n\n    return Fieldset.extend(strategy).extend(\n        {\n            defaults: {\n                openOnShow: true\n            },\n\n            /**\n             * Toggle visibility state.\n             */\n            toggleVisibility: function () {\n                this._super();\n\n                if (this.openOnShow) {\n                    this.opened(this.inverseVisibility ? !this.isShown : this.isShown);\n                }\n            }\n        }\n    );\n});\n","Magento_Catalog/js/components/disable-on-option/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/yesno.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    var comp = Element.extend(strategy).extend({\n\n        defaults: {\n            listens: {\n                disabled: 'updateValueForDisabledField',\n                visible: 'updateValueForDisabledField'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n            this.updateValueForDisabledField();\n\n            return this;\n        },\n\n        /**\n         * Set element value to O(No) if element is invisible and disabled\n         * Set element value to initialValue if element becomes visible and enable\n         */\n        updateValueForDisabledField: function () {\n            if (!this.disabled() && this.visible()) {\n                this.set('value', this.initialValue);\n            } else {\n                this.set('value', 0);\n            }\n        }\n    });\n\n    return comp.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/strategy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        defaults: {\n            valuesForEnable: [],\n            disabled: true,\n            imports: {\n                toggleDisable:\n                    'product_attribute_add_form.product_attribute_add_form.base_fieldset.frontend_input:value'\n            }\n        },\n\n        /**\n         * Toggle disabled state.\n         *\n         * @param {Number} selected\n         */\n        toggleDisable: function (selected) {\n            this.disabled(!(selected in this.valuesForEnable));\n        }\n    };\n});\n","Magento_Catalog/js/components/use-parent-settings/toggle-disabled-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var mixin = {\n        defaults: {\n            imports: {\n                toggleDisabled: '${ $.parentName }.custom_use_parent_settings:checked'\n            },\n            useParent: false,\n            useDefaults: false\n        },\n\n        /**\n         * Disable form input if settings for parent section is used\n         * or default value is applied.\n         *\n         * @param {Boolean} isUseParent\n         */\n        toggleDisabled: function (isUseParent) {\n            var disabled = this.useParent = isUseParent;\n\n            if (!disabled && !_.isUndefined(this.service)) {\n                disabled = !!this.isUseDefault();\n            }\n\n            this.saveUseDefaults();\n            this.disabled(disabled);\n        },\n\n        /**\n         * Stores original state of the field.\n         */\n        saveUseDefaults: function () {\n            this.useDefaults = this.disabled();\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            this._super();\n            this.isUseDefault(this.useDefaults);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        toggleUseDefault: function (state) {\n            this._super();\n            this.disabled(state || this.useParent);\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_Catalog/js/components/use-parent-settings/single-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/textarea'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/utils/percentage-price-calculator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['Magento_Ui/js/lib/validation/utils'], function (utils) {\n    'use strict';\n\n    /**\n     * Calculates the price input value when entered percentage value.\n     *\n     * @param {String} price\n     * @param {String} input\n     *\n     * @returns {String}\n     */\n    return function (price, input) {\n        var result,\n            lastInputSymbol = input.slice(-1),\n            inputPercent = input.slice(0, -1),\n            parsedPercent = utils.parseNumber(inputPercent),\n            parsedPrice = utils.parseNumber(price);\n\n        if (lastInputSymbol !== '%') {\n            result = input;\n        } else if (\n            input === '%' ||\n            isNaN(parsedPrice) ||\n            parsedPercent != inputPercent || /* eslint eqeqeq:0 */\n            isNaN(parsedPercent) ||\n            input === ''\n        ) {\n            result = '';\n        } else if (parsedPercent > 100) {\n            result = '0.00';\n        } else if (lastInputSymbol === '%') {\n            result = parsedPrice - parsedPrice * (inputPercent / 100);\n            result = result.toFixed(2);\n        } else {\n            result = input;\n        }\n\n        return result;\n    };\n});\n","Magento_Catalog/js/product/learn-more.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Depends on this option, \"Learn More\" link can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'learn_more', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/weight-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return {\n\n        /**\n         * Get weight\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weight: function () {\n            return $('#weight');\n        },\n\n        /**\n         * Weight Switcher\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weightSwitcher: function () {\n            return $('[data-role=weight-switcher]');\n        },\n\n        /**\n         * Weight Change Toggle\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weightChangeToggle: function () {\n            return $('#toggle_weight');\n        },\n\n        /**\n         * Is locked\n         * @returns {*}\n         */\n        isLocked: function () {\n            return this.$weight().is('[data-locked]');\n        },\n\n        /**\n         * Disabled\n         */\n        disabled: function () {\n            this.$weight().addClass('ignore-validate').prop('disabled', true);\n        },\n\n        /**\n         * Enabled\n         */\n        enabled: function () {\n            this.$weight().removeClass('ignore-validate').prop('disabled', false);\n        },\n\n        /**\n         * Disabled Switcher\n         */\n        disabledSwitcher: function () {\n            this.$weightSwitcher().find('input[type=\"radio\"]').addClass('ignore-validate').prop('disabled', true);\n        },\n\n        /**\n         * Enabled Switcher\n         */\n        enabledSwitcher: function () {\n            this.$weightSwitcher().find('input[type=\"radio\"]').removeClass('ignore-validate').prop('disabled', false);\n        },\n\n        /**\n         * Switch Weight\n         * @returns {*}\n         */\n        switchWeight: function () {\n            if (this.hasWeightChangeToggle()) {\n                return;\n            }\n\n            return this.productHasWeightBySwitcher() ? this.enabled() : this.disabled();\n        },\n\n        /**\n         * Toggle Switcher\n         */\n        toggleSwitcher: function () {\n            this.isWeightChanging() ? this.enabledSwitcher() : this.disabledSwitcher();\n        },\n\n        /**\n         * Hide weight switcher\n         */\n        hideWeightSwitcher: function () {\n            this.$weightSwitcher().hide();\n        },\n\n        /**\n         * Has weight switcher\n         * @returns {*}\n         */\n        hasWeightSwitcher: function () {\n            return this.$weightSwitcher().is(':visible');\n        },\n\n        /**\n         * Has weight\n         * @returns {*}\n         */\n        hasWeight: function () {\n            return this.$weight.is(':visible');\n        },\n\n        /**\n         * Has weight change toggle\n         * @returns {*}\n         */\n        hasWeightChangeToggle: function () {\n            return this.$weightChangeToggle().is(':visible');\n        },\n\n        /**\n         * Product has weight\n         * @returns {Bool}\n         */\n        productHasWeightBySwitcher: function () {\n            return $('input:checked', this.$weightSwitcher()).val() === '1';\n        },\n\n        /**\n         * Product weight toggle is checked\n         * @returns {Bool}\n         */\n        isWeightChanging: function () {\n            return this.$weightChangeToggle().is(':checked');\n        },\n\n        /**\n         * Change\n         * @param {String} data\n         */\n        change: function (data) {\n            var value = data !== undefined ? +data : !this.productHasWeightBySwitcher();\n\n            $('input[value=' + value + ']', this.$weightSwitcher()).prop('checked', true);\n            this.switchWeight();\n        },\n\n        /**\n         * Constructor component\n         */\n        'Magento_Catalog/js/product/weight-handler': function () {\n            this.bindAll();\n\n            if (this.hasWeightSwitcher()) {\n                this.switchWeight();\n            }\n\n            if (this.hasWeightChangeToggle()) {\n                this.toggleSwitcher();\n            }\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            this.$weightSwitcher().find('input').on('change', this.switchWeight.bind(this));\n        }\n    };\n});\n","Magento_Catalog/js/product/addtocompare-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @returns {Array}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_compare_button'].url ||\n                    row['add_to_compare_button']['post_data']);\n        },\n\n        /**\n         * Depends on this option, \"Add to compare\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_compare', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, stock status text can be \"In stock\" or \"Out Of Stock\"\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isAvailable: function (row) {\n            return row['is_available'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'escaper'\n], function (Column, columnStatusValidator, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Depends on this option, product name can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'name', 'show_attributes');\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getNameUnsanitizedHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        }\n    });\n});\n","Magento_Catalog/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing'\n], function (ko, _, Listing) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/column-status-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        /**\n         * Check whether we can show column depends on server settings or not\n         *\n         * @param {Object} source\n         * @param {String} attributeCode\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        isValid: function (source, attributeCode, type) {\n            var attributes;\n\n            if (!source[type]) {\n                return false;\n            }\n\n            attributes = source[type].split(',');\n\n            return _.contains(attributes, attributeCode);\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/pricetype-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiCollection'\n], function (ko, _, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        /**\n         * Find from all price ui components, price with specific code, init source on it and set priceType\n         *\n         * @param {String} code\n         * @returns {*|T}\n         */\n        getPriceByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                price;\n\n            price = _.filter(elems, function (elem) {\n                return elem.index.split('.').shift() === code;\n            }, this).pop();\n\n            price.source = this.source();\n            price.priceType = code;\n\n            return price;\n        },\n\n        /**\n         * Retrieve body template\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check whether price has price range, depends on different options, that can be choose\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'uiLayout'\n], function (ko, _, registry, utils, Collection, columnStatusValidator, layout) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: '',\n            hasSpecialPrice: false,\n            showMinimalPrice: false,\n            useLinkForAsLowAs: false,\n            visible: true,\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_Catalog/product/price/price_box',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: false,\n            sorting: false,\n            draggable: true,\n            fieldClass: {},\n            renders: {\n                default: {}\n            },\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                elems: ''\n            },\n            modules: {\n                source: '${ $.provider }'\n            },\n            pricesInit: {}\n        },\n\n        /**\n         * Sort prices api\n         *\n         * @returns {exports}\n         */\n        sort: function () {\n            return this;\n        },\n\n        /**\n         * Check whether is allowed to render price or not\n         *\n         * @returns {*}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'price', 'show_attributes');\n        },\n\n        /**\n         * Retrieve array of prices, that should be rendered for specific product\n         *\n         * @param {Array} row\n         * @return {Array}\n         */\n        getPrices: function (row) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                result;\n\n            //we cant take type of product from row\n            this.initPrices(row);\n            result = _.filter(elems, function (elem) {\n                return elem.productType === row.type;\n            });\n\n            return result;\n        },\n\n        /**\n         * Recursive Merging of objects\n         *\n         * @param {Array} target\n         * @param {Array} source\n         * @returns {Array}\n         * @private\n         */\n        _deepObjectExtend: function (target, source) {\n            var _target = utils.copy(target);\n\n            _.each(source, function (value, key) {\n                if (_.keys(value).length && typeof _target[key] !== 'undefined') {\n                    _target[key] = this._deepObjectExtend(_target[key], value);\n                } else {\n                    _target[key] = value;\n                }\n            }, this);\n\n            return _target;\n        },\n\n        /**\n         * Init price type box, in cases when product type has custom component or bodyTmpl\n         *\n         * @param {String} productType\n         * @private\n         */\n        _initPriceWithCustomMetaData: function (productType) {\n            var price = this._deepObjectExtend(\n                this.renders.prices['default'],\n                this.renders.prices[productType]\n            );\n\n            price.name = productType + '.default';\n            price.parent = this.name;\n            price.source = this.source;\n            price.productType = productType;\n            layout([price]);\n        },\n\n        /**\n         * Init Prices by product type and add them to layout\n         *\n         * @param {Array} _priceData\n         * @param {String} productType\n         * @private\n         */\n        _initPricesForProductType: function (_priceData, productType) {\n            var prices = [];\n\n            this._setPriceNamesToPrices(_priceData, productType);\n            _.sortBy(_priceData, this._comparePrices);\n\n            _.each(_priceData, function (priceData) {\n                if (!priceData.component) {\n                    return;\n                }\n\n                priceData.parent = this.name;\n                priceData.provider = this.provider;\n                priceData.productType = productType;\n                priceData = utils.template(priceData, this);\n                prices.push(priceData);\n            }, this);\n\n            layout(prices);\n        },\n\n        /**\n         * Init dynamic price components\n         *\n         * @param {Array} row\n         * @returns {void}\n         */\n        initPrices: function (row) {\n            var _priceData = [],\n                productType = row.type,\n                defaultPrice = this.renders.prices['default'];\n\n            if (this.pricesInit[productType]) {\n                return true;\n            }\n\n            this.pricesInit[productType] = true;\n\n            if (this.renders.prices[productType] && this._needToApplyCustomTemplate(this.renders.prices[productType])) {\n                return this._initPriceWithCustomMetaData(productType);\n            }\n\n            if (this.renders.prices[productType] && this.renders.prices[productType].children) {\n                _priceData = this._deepObjectExtend(defaultPrice.children, this.renders.prices[productType].children);\n            } else {\n                _priceData = defaultPrice.children;\n            }\n\n            return this._initPricesForProductType(_priceData, productType);\n        },\n\n        /**\n         * Set name to all price components\n         *\n         * @param {Array} prices\n         * @param {String} productType\n         * @private\n         */\n        _setPriceNamesToPrices: function (prices, productType) {\n            _.each(prices, function (price, name) {\n                price.priceType = name;\n                price.name = name + '.' + productType;\n            });\n\n            return prices;\n        },\n\n        /**\n         * Sort callback to compare prices by sort order\n         *\n         * @param {Number} firstPrice\n         * @param {Number} secondPrice\n         * @returns {Number}\n         * @private\n         */\n        _comparePrices: function (firstPrice, secondPrice) {\n            if (firstPrice.sortOrder < secondPrice.sortOrder) {\n                return -1;\n            }\n\n            if (firstPrice.sortOrder > secondPrice.sortOrder) {\n                return 1;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Check whether metadata of product type prices was changed, and we should\n         * to apply custom template or custom component\n         *\n         * @param {Array} productData\n         * @returns {*}\n         * @private\n         */\n        _needToApplyCustomTemplate: function (productData) {\n            return productData.bodyTmpl || productData.component;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get price label.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (_, Element, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Catalog/product/list/columns/image',\n            imageCode: 'default',\n            image: {}\n        },\n\n        /**\n         * Find image by code in scope of images\n         *\n         * @param {Object} images\n         * @returns {*|T}\n         */\n        getImage: function (images) {\n            return _.filter(images, function (image) {\n                return this.imageCode === image.code;\n            }, this).pop();\n        },\n\n        /**\n         * Get image path.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getImageUrl: function (row) {\n            return this.getImage(row.images).url;\n        },\n\n        /**\n         * Get image box width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getWidth: function (row) {\n            return this.getImage(row.images).width;\n        },\n\n        /**\n         * Get image box height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getHeight: function (row) {\n            return this.getImage(row.images).height;\n        },\n\n        /**\n         * Get resized image width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageWidth: function (row) {\n            return this.getImage(row.images)['resized_width'];\n        },\n\n        /**\n         * Get resized image height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageHeight: function (row) {\n            return this.getImage(row.images)['resized_height'];\n        },\n\n        /**\n         * Get image alt text.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getLabel: function (row) {\n            if (!this.imageExists(row)) {\n                return this._super();\n            }\n\n            return this.getImage(row.images).label;\n        },\n\n        /**\n         * Check if image exist.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        imageExists: function (row) {\n            return this.getImage(row.images) !== 'undefined';\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'image', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/final-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection'\n], function (_, registry, utils, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: false,\n            headerTmpl: 'ui/grid/columns/text',\n            showMinimalPrice: false,\n            showMaximumPrice: false,\n            useLinkForAsLowAs: false,\n            bodyTmpl: 'Magento_Catalog/product/final_price',\n            priceWrapperCssClasses: '',\n            priceWrapperAttr: {}\n        },\n\n        /**\n         * Get product final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPrice: function (row) {\n            return row['price_info']['formatted_prices']['final_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPriceUnsanitizedHtml: function (row) {\n            return this.getPrice(row);\n        },\n\n        /**\n         * Get product regular price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPriceUnsanitizedHtml: function (row) {\n            return this.getRegularPrice(row);\n        },\n\n        /**\n         * Check if product has a price range.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Check if product has special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} special price html\n         */\n        hasSpecialPrice: function (row) {\n            return row['price_info']['regular_price'] > row['price_info']['final_price'];\n        },\n\n        /**\n         * Check if product has minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        isMinimalPrice: function (row) {\n            return row['price_info']['minimal_price'] < row['price_info']['final_price'];\n        },\n\n        /**\n         * Get product minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPrice: function (row) {\n            return row['price_info']['formatted_prices']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPriceUnsanitizedHtml: function (row) {\n            return this.getMinimalPrice(row);\n        },\n\n        /**\n         * Check if product is salable.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Get product maximum price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPriceUnsanitizedHtml: function (row) {\n            return this.getMaxPrice(row);\n        },\n\n        /**\n         * Get product maximum regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMaxRegularPrice(row);\n        },\n\n        /**\n         * Get product minimal regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['min_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMinRegularPrice(row);\n        },\n\n        /**\n         * Get adjustments names and return as string.\n         *\n         * @return {String} adjustments classes\n         */\n        getAdjustmentCssClasses: function () {\n            return _.pluck(this.getAdjustments(), 'index').join(' ');\n        },\n\n        /**\n         * Get product minimal price as number.\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmount: function (row) {\n            return row['price_info']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPriceAmount\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmountUnsanitizedHtml: function (row) {\n            return this.getMinimalPriceAmount(row);\n        },\n\n        /**\n         * Get product minimal regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} minimal regular price amount\n         */\n        getMinimalRegularPriceAmount: function (row) {\n            return row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Get product maximum price as number.\n         *\n         * @param {Object} row\n         * @return {Number} maximum price amount\n         */\n        getMaximumPriceAmount: function (row) {\n            return row['price_info']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} maximum regular price amount\n         */\n        getMaximumRegularPriceAmount: function (row) {\n            return row['price_info']['max_regular_price'];\n        },\n\n        /**\n         * Check if minimal regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMinRegularPrice: function (row) {\n            return this.getMinimalPriceAmount(row) < this.getMinimalRegularPriceAmount(row);\n        },\n\n        /**\n         * Check if maximum regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMaxRegularPrice: function (row) {\n            return this.getMaximumPriceAmount(row) < this.getMaximumRegularPriceAmount(row);\n        },\n\n        /**\n         * Get path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get all price adjustments.\n         *\n         * @returns {Object}\n         */\n        getAdjustments: function () {\n            var adjustments = this.elems();\n\n            _.each(adjustments, function (adjustment) {\n                adjustment.setPriceType(this.priceType);\n                adjustment.source = this.source;\n            }, this);\n\n            return adjustments;\n        }\n    });\n});\n","Magento_Catalog/js/tier-price/percentage-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_Catalog/js/utils/percentage-price-calculator'\n], function (Element, _, $, percentagePriceCalculator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            priceElem: '${ $.parentName }.price',\n            selector: 'input',\n            imports: {\n                priceValue: '${ $.priceElem }:priceValue'\n            },\n            exports: {\n                calculatedVal: '${ $.priceElem }:value'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n\n            _.bindAll(this, 'initPriceListener', 'onInput');\n\n            $.async({\n                component: this.priceElem,\n                selector: this.selector\n            }, this.initPriceListener);\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initObservable: function () {\n            return this._super()\n                .observe(['visible']);\n        },\n\n        /**\n         * Handles keyup event on price input.\n         *\n         * {@param} HTMLElement elem\n         */\n        initPriceListener: function (elem) {\n            $(elem).on('keyup.priceCalc', this.onInput);\n        },\n\n        /**\n         * Delegates calculation of the price input value to percentagePriceCalculator.\n         *\n         * {@param} object event\n         */\n        onInput: function (event) {\n            var value = event.currentTarget.value;\n\n            if (value.slice(-1) === '%') {\n                value = percentagePriceCalculator(this.priceValue, value);\n                this.set('calculatedVal', value);\n            }\n        }\n    });\n});\n","Magento_Catalog/js/tier-price/value-type-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry',\n    'underscore'\n], function (Select, uiRegistry, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            prices: {}\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n            delete this.prices.__disableTmpl;\n            this.prepareForm();\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        prepareForm: function () {\n            var elements = this.getElementsByPrices(),\n                prices = this.prices,\n                currencyType = _.keys(prices)[0],\n                select = this;\n\n            uiRegistry.get(elements, function () {\n                _.each(arguments, function (currentValue) {\n                    if (parseFloat(currentValue.value()) > 0) {\n                        _.each(prices, function (priceValue, priceKey) {\n                            if (priceValue === currentValue.name) {\n                                currencyType = priceKey;\n                            }\n                        });\n                    }\n                });\n                select.value(currencyType);\n                select.on('value', select.onUpdate.bind(select));\n                select.onUpdate();\n            });\n        },\n\n        /**\n         * @returns {Array}\n         */\n        getElementsByPrices: function () {\n            var elements = [];\n\n            _.each(this.prices, function (currentValue) {\n                elements.push(currentValue);\n            });\n\n            return elements;\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated\n         */\n        onUpdate: function () {\n            var value = this.value(),\n                prices = this.prices,\n                select = this,\n                parentDataScopeArr = this.dataScope.split('.'),\n                parentDataScope,\n                elements = this.getElementsByPrices();\n\n            parentDataScopeArr.pop();\n            parentDataScope = parentDataScopeArr.join('.');\n\n            uiRegistry.get(elements, function () {\n                var sourceData = select.source.get(parentDataScope);\n\n                _.each(arguments, function (currentElement) {\n                    var index;\n\n                    _.each(prices, function (priceValue, priceKey) {\n                        if (priceValue === currentElement.name) {\n                            index = priceKey;\n                        }\n                    });\n\n                    if (value === index) {\n                        currentElement.visible(true);\n                        sourceData[currentElement.index] = currentElement.value();\n                    } else {\n                        currentElement.value('');\n                        currentElement.visible(false);\n                        delete sourceData[currentElement.index];\n                    }\n                });\n                select.source.set(parentDataScope, sourceData);\n            });\n        }\n    });\n});\n","Magento_Catalog/component/file-type-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if (value === 'file') {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-container.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/components/group'\n], function ($, Group) {\n    'use strict';\n\n    return Group.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['field', 'area', 'file', 'date', 'date_time', 'time']) !== -1) {\n                this.visible(true);\n\n                return true;\n            }\n\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            parentOption: null\n        },\n\n        /**\n         * Initialize component.\n         *\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .initLinkToParent();\n        },\n\n        /**\n         * Cache link to parent component - option holder.\n         *\n         * @returns {Element}\n         */\n        initLinkToParent: function () {\n            var pathToParent = this.parentName.replace(/(\\.[^.]*){2}$/, '');\n\n            this.parentOption = registry.async(pathToParent);\n            this.value() && this.parentOption('label', this.value());\n\n            return this;\n        },\n\n        /**\n         * On value change handler.\n         *\n         * @param {String} value\n         */\n        onUpdate: function (value) {\n            this.parentOption(function (component) {\n                component.set('label', value ? value : component.get('headerLabel'));\n            });\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/component/image-size-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/validation/utils',\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate'\n], function ($, utils, Abstract, validator) {\n    'use strict';\n\n    validator.addRule(\n        'validate-image-size-range',\n        function (value) {\n            var dataAttrRange = /^(\\d+)x(\\d+)$/,\n                m;\n\n            if (utils.isEmptyNoTrim(value)) {\n                return true;\n            }\n\n            m = dataAttrRange.exec(value);\n\n            return !!(m &&  m[1] > 0 && m[2] > 0);\n        },\n        $.mage.__('This value does not follow the specified format (for example, 200X300).')\n    );\n\n    return Abstract.extend({\n\n        /**\n         * Checks for relevant value\n         *\n         * @returns {Boolean}\n         */\n        isRangeCorrect: function () {\n            return validator('validate-image-size-range', this.value()).passed;\n        }\n    });\n});\n","Magento_Catalog/component/text-type-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/element/abstract'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks for relevant value\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['field', 'area']) !== -1) {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/element/select'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if (!value || $.inArray(value, ['drop_down', 'radio', 'checkbox', 'multiple']) !== -1) {\n                this.reset();\n                this.disabled(true);\n\n                return false;\n            }\n\n            this.disabled(false);\n\n            return true;\n        }\n    });\n});\n","Magento_Catalog/component/select-type-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['drop_down', 'radio', 'checkbox', 'multiple']) !== -1) {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/catalog/type-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return {\n        $type: $('#product_type_id'),\n\n        /**\n         * Init\n         */\n        init: function () {\n            this.type = {\n                init: this.$type.val(),\n                current: this.$type.val()\n            };\n\n            this.bindAll();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('setTypeProduct', function (event, type) {\n                this.setType(type);\n            }.bind(this));\n\n            //direct change type input\n            this.$type.on('change', function () {\n                this.type.current = this.$type.val();\n                this._notifyType();\n            }.bind(this));\n        },\n\n        /**\n         * Set type\n         * @param {String} type - type product (downloadable, simple, virtual ...)\n         * @returns {*}\n         */\n        setType: function (type) {\n            return this.$type.val(type || this.type.init).trigger('change');\n        },\n\n        /**\n         * Notify type\n         * @private\n         */\n        _notifyType: function () {\n            $(document).trigger('changeTypeProduct', this.type);\n        }\n    };\n});\n","Magento_Catalog/catalog/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, registry) {\n    'use strict';\n\n    $.widget('mage.productAttributes', {\n        /** @inheritdoc */\n        _create: function () {\n            this._on({\n                'click': '_showPopup'\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initModal: function () {\n            var self = this;\n\n            this.modal = $('<div id=\"create_new_attribute\"></div>').modal({\n                title: $.mage.__('New Attribute'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                opened: function () {\n                    $(this).parent().addClass('modal-content-new-attribute');\n                    self.iframe = $('<iframe id=\"create_new_attribute_container\"></iframe>').attr({\n                        src: self._prepareUrl(),\n                        frameborder: 0\n                    });\n                    self.modal.append(self.iframe);\n                    self._changeIframeSize();\n                    $(window).off().on('resize.modal', _.debounce(self._changeIframeSize.bind(self), 400));\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    var doc = self.iframe.get(0).document;\n\n                    if (doc && typeof doc.execCommand === 'function') {\n                        //IE9 break script loading but not execution on iframe removing\n                        doc.execCommand('stop');\n                        self.iframe.remove();\n                    }\n                    self.modal.data('mageModal').modal.remove();\n                    $(window).off('resize.modal');\n                }\n            });\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getHeight: function () {\n            var modal = this.modal.data('mageModal').modal,\n                modalHead = modal.find('header'),\n                modalHeadHeight = modalHead.outerHeight(),\n                modalHeight = modal.outerHeight(),\n                modalContentPadding = this.modal.parent().outerHeight() - this.modal.parent().height();\n\n            return modalHeight - modalHeadHeight - modalContentPadding;\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getWidth: function () {\n            return this.modal.width();\n        },\n\n        /**\n         * @private\n         */\n        _changeIframeSize: function () {\n            this.modal.parent().outerHeight(this._getHeight());\n            this.iframe.outerHeight(this._getHeight());\n            this.iframe.outerWidth(this._getWidth());\n\n        },\n\n        /**\n         * @return {String}\n         * @private\n         */\n        _prepareUrl: function () {\n            var productSource,\n                attributeSetId = '';\n\n            if (this.options.dataProvider) {\n                try {\n                    productSource = registry.get(this.options.dataProvider);\n                    attributeSetId = productSource.data.product['attribute_set_id'];\n                } catch (e) {}\n            }\n\n            return this.options.url +\n                (/\\?/.test(this.options.url) ? '&' : '?') +\n                'set=' + attributeSetId;\n        },\n\n        /**\n         * @private\n         */\n        _showPopup: function () {\n            this._initModal();\n            this.modal.modal('openModal');\n        }\n    });\n\n    return $.mage.productAttributes;\n});\n","Magento_Catalog/catalog/base-image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'jquery/file-uploader',\n    'mage/translate',\n    'mage/backend/notification'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.baseImage', {\n        /**\n         * Button creation\n         * @protected\n         */\n        options: {\n            maxImageUploadCount: 10\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var $container = this.element,\n                imageTmpl = mageTemplate(this.element.find('[data-template=image]').html()),\n                $dropPlaceholder = this.element.find('.image-placeholder'),\n                $galleryContainer = $('#media_gallery_content'),\n                mainClass = 'base-image',\n                maximumImageCount = 5,\n                $fieldCheckBox = $container.closest('[data-attribute-code=image]').find(':checkbox'),\n                isDefaultChecked = $fieldCheckBox.is(':checked'),\n                findElement, updateVisibility;\n\n            if (isDefaultChecked) {\n                $fieldCheckBox.trigger('click');\n            }\n\n            /**\n             * @param {Object} data\n             * @return {HTMLElement}\n             */\n            findElement = function (data) {\n                return $container.find('.image:not(.image-placeholder)').filter(function () {\n                    if (!$(this).data('image')) {\n                        return false;\n                    }\n\n                    return $(this).data('image').file === data.file;\n                }).first();\n            };\n\n            /** Update image visibility. */\n            updateVisibility = function () {\n                var elementsList = $container.find('.image:not(.removed-item)');\n\n                elementsList.each(function (index) {\n                    $(this)[index < maximumImageCount ? 'show' : 'hide']();\n                });\n                $dropPlaceholder[elementsList.length > maximumImageCount ? 'hide' : 'show']();\n            };\n\n            $galleryContainer.on('setImageType', function (event, data) {\n                if (data.type === 'image') {\n                    $container.find('.' + mainClass).removeClass(mainClass);\n\n                    if (data.imageData) {\n                        findElement(data.imageData).addClass(mainClass);\n                    }\n                }\n            });\n\n            $galleryContainer.on('addItem', function (event, data) {\n                var tmpl = imageTmpl({\n                    data: data\n                });\n\n                $(tmpl).data('image', data).insertBefore($dropPlaceholder);\n\n                updateVisibility();\n            });\n\n            $galleryContainer.on('removeItem', function (event, image) {\n                findElement(image).addClass('removed-item').hide();\n                updateVisibility();\n            });\n\n            $galleryContainer.on('moveElement', function (event, data) {\n                var $element = findElement(data.imageData),\n                    $after;\n\n                if (data.position === 0) {\n                    $container.prepend($element);\n                } else {\n                    $after = $container.find('.image').eq(data.position);\n\n                    if (!$element.is($after)) {\n                        $element.insertAfter($after);\n                    }\n                }\n                updateVisibility();\n            });\n\n            $container.on('click', '[data-role=make-base-button]', function (event) {\n                var data;\n\n                event.preventDefault();\n                data = $(event.target).closest('.image').data('image');\n                $galleryContainer.productGallery('setBase', data);\n            });\n\n            $container.on('click', '[data-role=delete-button]', function (event) {\n                event.preventDefault();\n                $galleryContainer.trigger('removeItem', $(event.target).closest('.image').data('image'));\n            });\n\n            $container.sortable({\n                axis: 'x',\n                items: '.image:not(.image-placeholder)',\n                distance: 8,\n                tolerance: 'pointer',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                stop: function (event, data) {\n                    $galleryContainer.trigger('setPosition', {\n                        imageData: data.item.data('image'),\n                        position: $container.find('.image').index(data.item)\n                    });\n                    $galleryContainer.trigger('resort');\n                }\n            }).disableSelection();\n\n            this.element.find('input[type=\"file\"]').fileupload({\n                dataType: 'json',\n                dropZone: $dropPlaceholder.closest('[data-attribute-code]'),\n                acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n                maxFileSize: this.element.data('maxFileSize'),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                done: function (event, data) {\n                    $dropPlaceholder.find('.progress-bar').text('').removeClass('in-progress');\n\n                    if (!data.result) {\n                        return;\n                    }\n\n                    if (!data.result.error) {\n                        $galleryContainer.trigger('addItem', data.result);\n                    } else {\n                        alert({\n                            content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                        });\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                change: function (e, data) {\n                    if (data.files.length > this.options.maxImageUploadCount) {\n                        $('body').notification('clear').notification('add', {\n                            error: true,\n                            message: $.mage.__('You can\\'t upload more than ' + this.options.maxImageUploadCount +\n                                ' images in one time'),\n\n                            /**\n                             * @param {*} message\n                             */\n                            insertMethod: function (message) {\n                                $('.page-main-actions').after(message);\n                            }\n                        });\n\n                        return false;\n                    }\n                }.bind(this),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} data\n                 */\n                add: function (event, data) {\n                    $(this).fileupload('process', data).done(function () {\n                        data.submit();\n                    });\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                progress: function (e, data) {\n                    var progress = parseInt(data.loaded / data.total * 100, 10);\n\n                    $dropPlaceholder.find('.progress-bar').addClass('in-progress').text(progress + '%');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                start: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.addClass('loading');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                stop: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.removeClass('loading');\n                }\n            });\n        }\n    });\n\n    return $.mage.baseImage;\n});\n","Magento_Catalog/catalog/apply-to-type-switcher.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events'\n], function ($, productType) {\n    'use strict';\n\n    return {\n\n        /**\n         * Bind event\n         */\n        bindAll: function () {\n            $('[data-form=edit-product] [data-role=tabs]').on(\n                'contentUpdated',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $('#product_info_tabs').on(\n                'beforePanelsMove tabscreate tabsactivate',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $(document).on('changeTypeProduct', this._switchToTypeByApplyAttr.bind(this));\n        },\n\n        /**\n         * Constructor component\n         */\n        'Magento_Catalog/catalog/apply-to-type-switcher': function () {\n            this.bindAll();\n            this._switchToTypeByApplyAttr();\n        },\n\n        /**\n         * Show/hide elements based on type\n         *\n         * @private\n         */\n        _switchToTypeByApplyAttr: function () {\n            $('[data-apply-to]:not(.removed)').each(function (index, element) {\n                var attrContainer = $(element),\n                    applyTo = attrContainer.data('applyTo') || [],\n                    $inputs = attrContainer.find('select, input, textarea');\n\n                if (applyTo.length === 0 || $.inArray(productType.type.current, applyTo) !== -1) {\n                    attrContainer.removeClass('not-applicable-attribute');\n                    $inputs.removeClass('ignore-validate');\n                } else {\n                    attrContainer.addClass('not-applicable-attribute');\n                    $inputs.addClass('ignore-validate');\n                }\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    window.Product = {};\n\n    /**\n     * @param {String} id\n     * @return {*|jQuery|HTMLElement}\n     */\n    function byId(id) {\n        return $('#' + id);\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function disableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', true);\n\n        if (field.next().hasClass('addafter')) {\n            field.parent().addClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', true);\n        }\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function enableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', false);\n\n        if (field.parent().hasClass('_update-attributes-disabled')) {\n            field.parent().removeClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', false);\n        }\n    }\n\n    /**\n     * @param {String} toogleIdentifier\n     * @param {String} fieldId\n     */\n    function toogleFieldEditMode(toogleIdentifier, fieldId) {\n        if ($(toogleIdentifier).is(':checked')) {\n            enableFieldEditMode(fieldId);\n        } else {\n            disableFieldEditMode(fieldId);\n        }\n    }\n\n    /**\n     * On complete disable.\n     */\n    function onCompleteDisableInited() {\n        var item;\n\n        $.each($('[data-disable]'), function () {\n            item = $(this).data('disable');\n            disableFieldEditMode(item);\n        });\n    }\n\n    /**\n     * @param {String} urlKey\n     */\n    function onUrlkeyChanged(urlKey) {\n        var hidden, chbx, oldValue;\n\n        urlKey = byId(urlKey);\n        hidden = urlKey.siblings('input[type=hidden]');\n        chbx = urlKey.siblings('input[type=checkbox]');\n        oldValue = chbx.val();\n\n        chbx.prop('disabled', oldValue === urlKey.val());\n        hidden.prop('disabled', chbx.prop('disabled'));\n    }\n\n    /**\n     * @param {HTMLElement} element\n     */\n    function onCustomUseParentChanged(element) {\n        var useParent, parent;\n\n        element = $(element);\n        useParent = element.val() == 1; //eslint-disable-line eqeqeq\n        parent = element.offsetParent().parent();\n\n        parent.find('input, select, textarea').each(function (i, el) {\n            el = $(el);\n\n            if (element.prop('id') !== el.prop('id')) {\n                el.prop('disabled', useParent);\n            }\n        });\n\n        parent.find('img').each(function (i, el) {\n            if (useParent) {\n                $(el).hide();\n            } else {\n                $(el).show();\n            }\n        });\n    }\n\n    window.onCustomUseParentChanged = onCustomUseParentChanged;\n    window.onUrlkeyChanged = onUrlkeyChanged;\n    window.toogleFieldEditMode = toogleFieldEditMode;\n\n    $(onCompleteDisableInited);\n});\n","Magento_Catalog/catalog/category/assign-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mage/adminhtml/grid'\n], function () {\n    'use strict';\n\n    return function (config) {\n        var selectedProducts = config.selectedProducts,\n            categoryProducts = $H(selectedProducts),\n            gridJsObject = window[config.gridJsObjectName],\n            tabIndex = 1000;\n\n        $('in_category_products').value = Object.toJSON(categoryProducts);\n\n        /**\n         * Register Category Product\n         *\n         * @param {Object} grid\n         * @param {Object} element\n         * @param {Boolean} checked\n         */\n        function registerCategoryProduct(grid, element, checked) {\n            if (checked) {\n                if (element.positionElement) {\n                    element.positionElement.disabled = false;\n                    categoryProducts.set(element.value, element.positionElement.value);\n                }\n            } else {\n                if (element.positionElement) {\n                    element.positionElement.disabled = true;\n                }\n                categoryProducts.unset(element.value);\n            }\n            $('in_category_products').value = Object.toJSON(categoryProducts);\n            grid.reloadParams = {\n                'selected_products[]': categoryProducts.keys()\n            };\n        }\n\n        /**\n         * Click on product row\n         *\n         * @param {Object} grid\n         * @param {String} event\n         */\n        function categoryProductRowClick(grid, event) {\n            var trElement = Event.findElement(event, 'tr'),\n                eventElement = Event.element(event),\n                isInputCheckbox = eventElement.tagName === 'INPUT' && eventElement.type === 'checkbox',\n                isInputPosition = grid.targetElement &&\n                    grid.targetElement.tagName === 'INPUT' &&\n                    grid.targetElement.name === 'position',\n                checked = false,\n                checkbox = null;\n\n            if (eventElement.tagName === 'LABEL' &&\n                trElement.querySelector('#' + eventElement.htmlFor) &&\n                trElement.querySelector('#' + eventElement.htmlFor).type === 'checkbox'\n            ) {\n                event.stopPropagation();\n                trElement.querySelector('#' + eventElement.htmlFor).trigger('click');\n\n                return;\n            }\n\n            if (trElement && !isInputPosition) {\n                checkbox = Element.getElementsBySelector(trElement, 'input');\n\n                if (checkbox[0]) {\n                    checked = isInputCheckbox ? checkbox[0].checked : !checkbox[0].checked;\n                    gridJsObject.setCheckboxChecked(checkbox[0], checked);\n                }\n            }\n        }\n\n        /**\n         * Change product position\n         *\n         * @param {String} event\n         */\n        function positionChange(event) {\n            var element = Event.element(event);\n\n            if (element && element.checkboxElement && element.checkboxElement.checked) {\n                categoryProducts.set(element.checkboxElement.value, element.value);\n                $('in_category_products').value = Object.toJSON(categoryProducts);\n            }\n        }\n\n        /**\n         * Initialize category product row\n         *\n         * @param {Object} grid\n         * @param {String} row\n         */\n        function categoryProductRowInit(grid, row) {\n            var checkbox = $(row).getElementsByClassName('checkbox')[0],\n                position = $(row).getElementsByClassName('input-text')[0];\n\n            if (checkbox && position) {\n                checkbox.positionElement = position;\n                position.checkboxElement = checkbox;\n                position.disabled = !checkbox.checked;\n                position.tabIndex = tabIndex++;\n                Event.observe(position, 'keyup', positionChange);\n            }\n        }\n\n        gridJsObject.rowClickCallback = categoryProductRowClick;\n        gridJsObject.initRowCallback = categoryProductRowInit;\n        gridJsObject.checkboxCheckCallback = registerCategoryProduct;\n\n        if (gridJsObject.rows) {\n            gridJsObject.rows.each(function (row) {\n                categoryProductRowInit(gridJsObject, row);\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/category/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert'\n], function ($, alert) {\n    'use strict';\n\n    return function (config) {\n        var categoryForm = {\n            options: {\n                categoryIdSelector: 'input[name=\"id\"]',\n                categoryPathSelector: 'input[name=\"path\"]',\n                categoryParentSelector: 'input[name=\"parent\"]',\n                categoryLevelSelector: 'input[name=\"level\"]',\n                refreshUrl: config.refreshUrl\n            },\n\n            /**\n             * Sending ajax to server to refresh field 'path'\n             * @protected\n             */\n            refreshPath: function () {\n                if (!$(this.options.categoryIdSelector)) {\n                    return false;\n                }\n                $.ajax({\n                    url: this.options.refreshUrl,\n                    method: 'GET',\n                    showLoader: true\n                }).done(this._refreshPathSuccess.bind(this));\n            },\n\n            /**\n             * Refresh field 'path' on ajax success\n             * @param {Object} data\n             * @private\n             */\n            _refreshPathSuccess: function (data) {\n                if (data.error) {\n                    alert({\n                        content: data.message\n                    });\n                } else {\n                    $(this.options.categoryIdSelector).val(data.id).trigger('change');\n                    $(this.options.categoryPathSelector).val(data.path).trigger('change');\n                    $(this.options.categoryParentSelector).val(data.parentId).trigger('change');\n                    $(this.options.categoryLevelSelector).val(data.level).trigger('change');\n                }\n            }\n        };\n\n        $('body').on('categoryMove.tree', $.proxy(categoryForm.refreshPath.bind(categoryForm), this));\n    };\n});\n","Magento_Catalog/catalog/product/attribute/unique-validate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/validation'\n], function (jQuery) {\n    'use strict';\n\n    return function (config) {\n        var msg = '',\n            _config = jQuery.extend({\n                element: null,\n                message: '',\n                uniqueClass: 'required-unique'\n            }, config),\n\n            /** @inheritdoc */\n            messager = function () {\n                return msg;\n            };\n\n        if (typeof _config.element === 'string') {\n            jQuery.validator.addMethod(\n                _config.element,\n\n                function (value, element) {\n                    var inputs = jQuery(element)\n                            .closest('table')\n                            .find('.' + _config.uniqueClass + ':visible'),\n                        valuesHash = {},\n                        isValid = true,\n                        duplicates = [];\n\n                    inputs.each(function (el) {\n                        var inputValue = inputs[el].value;\n\n                        if (typeof valuesHash[inputValue] !== 'undefined') {\n                            isValid = false;\n                            duplicates.push(inputValue);\n                        }\n                        valuesHash[inputValue] = el;\n                    });\n\n                    if (!isValid) {\n                        msg = _config.message + ' (' + duplicates.join(', ') + ')';\n                    }\n\n                    return isValid;\n                },\n\n                messager\n            );\n        }\n    };\n});\n","Magento_Catalog/catalog/product/composite/configure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'jquery/ui',\n    'mage/translate',\n    'prototype',\n    'Magento_Ui/js/modal/modal'\n], function (jQuery) {\n\n    window.ProductConfigure = Class.create();\n\n    ProductConfigure.prototype = {\n\n        listTypes:                  $H({}),\n        current:                    $H({}),\n        itemsFilter:                $H({}),\n        blockWindow:                null,\n        blockForm:                  null,\n        blockFormFields:            null,\n        blockFormAdd:               null,\n        blockFormConfirmed:         null,\n        blockConfirmed:             null,\n        blockIFrame:                null,\n        blockCancelBtn:             null,\n        blockMask:                  null,\n        blockMsg:                   null,\n        blockMsgError:              null,\n        windowHeight:               null,\n        confirmedCurrentId:         null,\n        confirmCallback:            {},\n        cancelCallback:             {},\n        onLoadIFrameCallback:       {},\n        showWindowCallback:         {},\n        beforeSubmitCallback:       {},\n        iFrameJSVarname:            null,\n        _listTypeId:                1,\n\n        /**\n         * Initialize object\n         */\n        initialize: function () {\n            var self = this,\n                popupDialog = jQuery('#product_composite_configure');\n\n            this._initWindowElements();\n            jQuery.async('#product_composite_configure', function (el) {\n                if (el !== popupDialog[0]) {\n                    el = popupDialog[0];\n                }\n                self.dialog = jQuery(el).modal({\n                    title: jQuery.mage.__('Configure Product'),\n                    type: 'slide',\n                    buttons: [{\n                        text: jQuery.mage.__('OK'),\n                        'class': 'action-primary',\n                        click: function () {\n                            self.onConfirmBtn();\n                        }\n                    }],\n                    closed: function () {\n                        self.clean('window');\n                    },\n                });\n            });\n        },\n\n        /**\n         * Initialize window elements\n         */\n        _initWindowElements: function () {\n            this.blockWindow                = $('product_composite_configure');\n            this.blockForm                  = $('product_composite_configure_form');\n            this.blockFormFields            = $('product_composite_configure_form_fields');\n            this.blockFormAdd               = $('product_composite_configure_form_additional');\n            this.blockFormConfirmed         = $('product_composite_configure_form_confirmed');\n            this.blockConfirmed             = $('product_composite_configure_confirmed');\n            this.blockIFrame                = $('product_composite_configure_iframe');\n            this.blockCancelBtn             = $('product_composite_configure_form_cancel');\n            this.blockMsg                   = $('product_composite_configure_messages');\n            this.blockMsgError              = this.blockMsg.select('.message.error div')[0];\n            this.iFrameJSVarname            = this.blockForm.select('input[name=\"as_js_varname\"]')[0].value;\n        },\n\n        /**\n         * Returns next unique list type id\n         */\n        _generateListTypeId: function () {\n            return '_internal_lt_' + this._listTypeId++;\n        },\n\n        /**\n         * Add product list types as scope and their urls\n         * example: addListType('product_to_add', {urlFetch: 'http://magento...'})\n         * example: addListType('wishlist', {urlSubmit: 'http://magento...'})\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlFetch: 'http://magento...'} for fetching configuration fields through ajax\n         *             - {urlConfirm: 'http://magento...'} for submit configured data through iFrame when clicked confirm button\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         */\n        addListType: function (type, urls) {\n            if ('undefined' == typeof this.listTypes[type]) {\n                this.listTypes[type] = {};\n            }\n            Object.extend(this.listTypes[type], urls);\n\n            return this;\n        },\n\n        /**\n         * Adds complex list type - that is used to submit several list types at once\n         * Only urlSubmit is possible for this list type\n         * example: addComplexListType(['wishlist', 'product_list'], 'http://magento...')\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         * @return type string\n         */\n        addComplexListType: function (types, urlSubmit) {\n            var type = this._generateListTypeId();\n\n            this.listTypes[type] = {};\n            this.listTypes[type].complexTypes = types;\n            this.listTypes[type].urlSubmit = urlSubmit;\n\n            return type;\n        },\n\n        /**\n         * Add filter of items\n         *\n         * @param listType scope name\n         * @param itemsFilter\n         */\n        addItemsFilter: function (listType, itemsFilter) {\n            if (!listType || !itemsFilter) {\n                return false;\n            }\n\n            if ('undefined' == typeof this.itemsFilter[listType]) {\n                this.itemsFilter[listType] = [];\n            }\n            this.itemsFilter[listType] = this.itemsFilter[listType].concat(itemsFilter);\n\n            return this;\n        },\n\n        /**\n         * Returns id of block where configuration for an item is stored\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return string\n         */\n        _getConfirmedBlockId: function (listType, itemId) {\n            return this.blockConfirmed.id + '[' + listType + '][' + itemId + ']';\n        },\n\n        /**\n         * Checks whether item has some configuration fields\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return bool\n         */\n        itemConfigured: function (listType, itemId) {\n            var confirmedBlockId = this._getConfirmedBlockId(listType, itemId);\n            var itemBlock = $(confirmedBlockId);\n\n            return !!(itemBlock && itemBlock.innerHTML);\n        },\n\n        /**\n         * Show configuration fields of item, if it not found then get it through ajax\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        showItemConfiguration: function (listType, itemId) {\n            if (!listType || !itemId) {\n                return false;\n            }\n\n            this.initialize();\n            this.current.listType = listType;\n            this.current.itemId = itemId;\n            this.confirmedCurrentId = this._getConfirmedBlockId(listType, itemId);\n\n            if (!this.itemConfigured(listType, itemId)) {\n                this._requestItemConfiguration(listType, itemId);\n            } else {\n                this._processFieldsData('item_restore');\n                this._showWindow();\n            }\n        },\n\n        /**\n         * Get configuration fields of product through ajax and show them\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        _requestItemConfiguration: function (listType, itemId) {\n            if (!this.listTypes[listType].urlFetch) {\n                return false;\n            }\n            var url = this.listTypes[listType].urlFetch;\n\n            if (url) {\n                new Ajax.Request(url, {\n                    parameters: {\n                        id: itemId\n                    },\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.blockMsg.show();\n                                this.blockMsgError.innerHTML = response.message;\n                                if(this.blockCancelBtn) {\n                                    this.blockCancelBtn.hide();\n                                }\n                                this.setConfirmCallback(listType, null);\n                                this._showWindow();\n                            }\n                        } else if (response) {\n                            response += '';\n                            this.blockFormFields.update(response);\n\n                            // Add special div to hold mage data, e.g. scripts to execute on every popup show\n                            var mageData = {};\n                            var scripts = response.extractScripts();\n\n                            mageData.scripts = scripts;\n\n                            var scriptHolder = new Element('div', {\n                                'style': 'display:none'\n                            });\n\n                            scriptHolder.mageData = mageData;\n                            this.blockFormFields.insert(scriptHolder);\n\n                            // Show window\n                            this._showWindow();\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        /**\n         * Triggered on confirm button click\n         * Do submit configured data through iFrame if needed\n         */\n        onConfirmBtn: function () {\n            if (jQuery(this.blockForm).valid()) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    this.submit();\n                } else {\n                    this._processFieldsData('item_confirm');\n                    this._closeWindow();\n\n                    if (Object.isFunction(this.confirmCallback[this.current.listType])) {\n                        this.confirmCallback[this.current.listType]();\n                    }\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Triggered on cancel button click\n         */\n        onCancelBtn: function () {\n            this._closeWindow();\n\n            if (Object.isFunction(this.cancelCallback[this.current.listType])) {\n                this.cancelCallback[this.current.listType]();\n            }\n\n            return this;\n        },\n\n        /**\n         * Submit configured data through iFrame\n         *\n         * @param listType scope name\n         */\n        submit: function (listType) {\n            // prepare data\n            if (listType) {\n                this.current.listType = listType;\n                this.current.itemId = null;\n            }\n            var urlConfirm = this.listTypes[this.current.listType].urlConfirm;\n            var urlSubmit = this.listTypes[this.current.listType].urlSubmit;\n\n            if (!urlConfirm && !urlSubmit) {\n                return false;\n            }\n\n            if (urlConfirm) {\n                this.blockForm.action = urlConfirm;\n                this.addFields([new Element('input', {\n                    type: 'hidden', name: 'id', value: this.current.itemId\n                })]);\n            } else {\n                this.blockForm.action = urlSubmit;\n\n                var complexTypes = this.listTypes[this.current.listType].complexTypes;\n\n                if (complexTypes) {\n                    this.addFields([new Element('input', {\n                        type: 'hidden', name: 'configure_complex_list_types', value: complexTypes.join(',')\n                    })]);\n                }\n\n                this._processFieldsData('current_confirmed_to_form');\n\n                // Disable item controls that duplicate added fields (e.g. sometimes qty controls can intersect)\n                // so they won't be submitted\n                var tagNames = ['input', 'select', 'textarea'];\n\n                var names = {}; // Map of added field names\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormAdd.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        names[elements[index].name] = true;\n                    }\n                }\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormConfirmed.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        var element = elements[index];\n\n                        if (names[element.name]) {\n                            element.setAttribute('configure_disabled', 1);\n                            element.setAttribute('configure_prev_disabled', element.disabled ? 1 : 0);\n                            element.disabled = true;\n                        } else {\n                            element.setAttribute('configure_disabled', 0);\n                        }\n                    }\n                }\n            }\n            // do submit\n            if (Object.isFunction(this.beforeSubmitCallback[this.current.listType])) {\n                this.beforeSubmitCallback[this.current.listType]();\n            }\n            this.blockForm.submit();\n\n            // Show loader\n            jQuery(this.blockForm).trigger('processStart');\n\n            return this;\n        },\n\n        /**\n         * Add dynamically additional fields for form\n         *\n         * @param fields\n         */\n        addFields: function (fields) {\n            fields.each(function (elm) {\n                this.blockFormAdd.insert(elm);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Triggered when form was submitted and iFrame was loaded. Get response from iFrame and handle it\n         */\n        onLoadIFrame: function () {\n            this.blockFormConfirmed.select('[configure_disabled=1]').each(function (element) {\n                element.disabled = element.getAttribute('configure_prev_disabled') == '1';\n            });\n\n            this._processFieldsData('form_confirmed_to_confirmed');\n\n            var response = this.blockIFrame.contentWindow[this.iFrameJSVarname];\n\n            if (response && 'object' == typeof response) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    if (response.ok) {\n                        this._closeWindow();\n                        this.clean('current');\n                    } else if (response.error) {\n                        this.showItemConfiguration(this.current.listType, this.current.itemId);\n                        this.blockMsg.show();\n                        this.blockMsgError.innerHTML = response.message;\n                        this._showWindow();\n\n                        jQuery(this.blockForm).trigger('processStop');\n                        return false;\n                    }\n                }\n\n                if (Object.isFunction(this.onLoadIFrameCallback[this.current.listType])) {\n                    this.onLoadIFrameCallback[this.current.listType](response);\n                }\n                document.fire(this.current.listType + ':afterIFrameLoaded');\n            }\n            // Hide loader\n            jQuery(this.blockForm).trigger('processStop');\n\n            this.clean('current');\n            this.initialize();\n        },\n\n        /**\n         * Helper for fetching content from iFrame\n         */\n        _getIFrameContent: function () {\n            var content = this.blockIFrame.contentWindow || this.blockIFrame.contentDocument;\n\n            if (content.document) {\n                content = content.document;\n            }\n\n            return content;\n        },\n\n        /**\n         * Helper to find qty of currently confirmed item\n         */\n        getCurrentConfirmedQtyElement: function () {\n            var elms = $(this.confirmedCurrentId).getElementsByTagName('input');\n\n            for (var i = 0; i < elms.length; i++) {\n                if (elms[i].name == 'qty') {\n                    return elms[i];\n                }\n            }\n        },\n\n        /**\n         * Helper to find select element of currently confirmed item\n         */\n        getCurrentConfirmedSelectElement: function () {\n            return $(this.confirmedCurrentId).getElementsByTagName('select');\n        },\n\n        /**\n         * Helper to find qty of active form\n         */\n        getCurrentFormQtyElement: function () {\n            var elms = this.blockFormFields.getElementsByTagName('input');\n\n            for (var i = 0; i < elms.length; i++) {\n                if (elms[i].name == 'qty') {\n                    return elms[i];\n                }\n            }\n        },\n\n        /**\n         * Show configuration window\n         */\n        _showWindow: function () {\n            this.dialog.modal('openModal');\n            //this._toggleSelectsExceptBlock(false);\n\n            if (Object.isFunction(this.showWindowCallback[this.current.listType])) {\n                this.showWindowCallback[this.current.listType]();\n            }\n        },\n\n        /**\n         * Close configuration window\n         */\n        _closeWindow: function () {\n            this.dialog.modal('closeModal');\n            //this.blockWindow.style.display = 'none';\n            //this.clean('window');\n        },\n\n        /**\n         * Attach callback function triggered when confirm button was clicked\n         *\n         * @param confirmCallback\n         */\n        setConfirmCallback: function (listType, confirmCallback) {\n            this.confirmCallback[listType] = confirmCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when cancel button was clicked\n         *\n         * @param cancelCallback\n         */\n        setCancelCallback: function (listType, cancelCallback) {\n            this.cancelCallback[listType] = cancelCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when iFrame was loaded\n         *\n         * @param onLoadIFrameCallback\n         */\n        setOnLoadIFrameCallback: function (listType, onLoadIFrameCallback) {\n            this.onLoadIFrameCallback[listType] = onLoadIFrameCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when iFrame was loaded\n         *\n         * @param showWindowCallback\n         */\n        setShowWindowCallback: function (listType, showWindowCallback) {\n            this.showWindowCallback[listType] = showWindowCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered before submitting form\n         *\n         * @param beforeSubmitCallback\n         */\n        setBeforeSubmitCallback: function (listType, beforeSubmitCallback) {\n            this.beforeSubmitCallback[listType] = beforeSubmitCallback;\n\n            return this;\n        },\n\n        /**\n         * Clean object data\n         *\n         * @param method can be 'all' or 'current'\n         */\n        clean: function (method) {\n            var listInfo = null;\n            var listTypes = null;\n            var removeConfirmed = function (listTypes) {\n                this.blockConfirmed.childElements().each(function (elm) {\n                    for (var i = 0, len = listTypes.length; i < len; i++) {\n                        var pattern = this.blockConfirmed.id + '[' + listTypes[i] + ']';\n\n                        if (elm.id.indexOf(pattern) == 0) {\n                            elm.remove();\n                            break;\n                        }\n                    }\n                }.bind(this));\n            }.bind(this);\n\n            switch (method) {\n                case 'current':\n                    listInfo = this.listTypes[this.current.listType];\n                    listTypes = [this.current.listType];\n\n                    if (listInfo && listInfo.complexTypes) {\n                        listTypes = listTypes.concat(listInfo.complexTypes);\n                    }\n                    removeConfirmed(listTypes);\n                    break;\n\n                case 'window':\n                    this.blockFormFields.update();\n                    this.blockMsg.hide();\n                    this.blockMsgError.update();\n                    if(this.blockCancelBtn) {\n                        this.blockCancelBtn.show();\n                    }\n                    break;\n                default:\n                    // search in list types for its cleaning\n                    if (this.listTypes[method]) {\n                        listInfo = this.listTypes[method];\n                        listTypes = [method];\n\n                        if (listInfo.complexTypes) {\n                            listTypes = listTypes.concat(listInfo.complexTypes);\n                        }\n                        removeConfirmed(listTypes);\n                        // clean all\n                    } else if (!method) {\n                        this.current = $H({});\n                        this.blockConfirmed.update();\n                        this.blockFormFields.update();\n                        this.blockMsg.hide();\n                        this.blockMsgError.update();\n                        if(this.blockCancelBtn) {\n                            this.blockCancelBtn.show();\n                        }\n                    }\n                    break;\n            }\n            this._getIFrameContent().body.innerHTML = '';\n            this.blockIFrame.contentWindow[this.iFrameJSVarname] = {};\n            this.blockFormAdd.update();\n            this.blockFormConfirmed.update();\n            this.blockForm.action = '';\n\n            return this;\n        },\n\n        /**\n         * Process fields data: save, restore, move saved to form and back\n         *\n         * @param method can be 'item_confirm', 'item_restore', 'current_confirmed_to_form', 'form_confirmed_to_confirmed'\n         */\n        _processFieldsData: function (method) {\n            var self = this;\n\n            /**\n             * Internal function for rename fields names of some list type\n             * if listType is not specified, then it won't be added as prefix to all names\n             *\n             * @param method can be 'current_confirmed_to_form', 'form_confirmed_to_confirmed'\n             * @param blockItem\n             */\n            var _renameFields = function (method, blockItem, listType) {\n                var pattern           = null;\n                var patternFlat       = null;\n                var patternPrefix     = RegExp('\\\\s', 'g');\n                var replacement       = null;\n                var replacementFlat   = null;\n                var replacementPrefix = '_';\n                var scopeArr          = blockItem.id.match(/.*\\[\\w+\\]\\[([^\\]]+)\\]$/);\n                var itemId            = scopeArr[1];\n\n                if (method == 'current_confirmed_to_form') {\n                    pattern         = RegExp('(\\\\w+)(\\\\[?)');\n                    patternFlat     = RegExp('(\\\\w+)');\n                    replacement     = 'item[' + itemId + '][$1]$2';\n                    replacementFlat = 'item_' + itemId + '_$1';\n\n                    if (listType) {\n                        replacement = 'list[' + listType + '][item][' + itemId + '][$1]$2';\n                        replacementFlat = 'list_' + listType + '_' + replacementFlat;\n                    }\n                } else if (method == 'form_confirmed_to_confirmed') {\n                    var stPattern = 'item\\\\[' + itemId + '\\\\]\\\\[(\\\\w+)\\\\](.*)';\n                    var stPatternFlat = 'item_' + itemId + '_(\\\\w+)';\n\n                    if (listType) {\n                        stPattern = 'list\\\\[' + listType + '\\\\]\\\\[item\\\\]\\\\[' + itemId + '\\\\]\\\\[(\\\\w+)\\\\](.*)';\n                        stPatternFlat = 'list_' + listType + '_' + stPatternFlat;\n                    }\n                    pattern         = new RegExp(stPattern);\n                    patternFlat     = new RegExp(stPatternFlat);\n                    replacement     = '$1$2';\n                    replacementFlat = '$1';\n                } else {\n                    return false;\n                }\n                var rename = function (elms) {\n                    for (var i = 0; i < elms.length; i++) {\n                        if (elms[i].name && elms[i].type == 'file') {\n                            var prefixName = 'options[files_prefix]',\n                                prefixValue = 'item_' + itemId + '_';\n\n                            self.blockFormFields.insert(new Element('input', {\n                                type: 'hidden',\n                                name: prefixName.replace(pattern, replacement),\n                                value: prefixValue.replace(patternPrefix, replacementPrefix)\n                            }));\n                            elms[i].name = elms[i].name.replace(patternFlat, replacementFlat);\n                        } else if (elms[i].name) {\n                            elms[i].name = elms[i].name.replace(pattern, replacement);\n                        }\n                    }\n                };\n\n                rename(blockItem.getElementsByTagName('input'));\n                rename(blockItem.getElementsByTagName('select'));\n                rename(blockItem.getElementsByTagName('textarea'));\n            };\n\n            switch (method) {\n                case 'item_confirm':\n                    if (!$(this.confirmedCurrentId)) {\n                        this.blockConfirmed.insert(new Element('div', {\n                            id: this.confirmedCurrentId\n                        }));\n                    } else {\n                        $(this.confirmedCurrentId).update();\n                    }\n                    this.blockFormFields.childElements().each(function (elm) {\n                        $(this.confirmedCurrentId).insert(elm);\n                    }.bind(this));\n                    break;\n\n                case 'item_restore':\n                    this.blockFormFields.update();\n\n                    // clone confirmed to form\n                    var mageData = null;\n\n                    $(this.confirmedCurrentId).childElements().each(function (elm) {\n                        var cloned = elm.cloneNode(true);\n\n                        if (elm.mageData) {\n                            cloned.mageData = elm.mageData;\n                            mageData = elm.mageData;\n                        }\n                        this.blockFormFields.insert(cloned);\n                    }.bind(this));\n\n                    // get confirmed values\n                    var fieldsValue = {};\n                    var getConfirmedValues = function (elms) {\n                        for (var i = 0; i < elms.length; i++) {\n                            if (elms[i].name) {\n                                if ('undefined' == typeof fieldsValue[elms[i].name]) {\n                                    fieldsValue[elms[i].name] = {};\n                                }\n\n                                if (elms[i].type == 'checkbox') {\n                                    fieldsValue[elms[i].name][elms[i].value] = elms[i].checked;\n                                } else if (elms[i].type == 'radio') {\n                                    if (elms[i].checked) {\n                                        fieldsValue[elms[i].name] = elms[i].value;\n                                    }\n                                } else {\n                                    fieldsValue[elms[i].name] = Form.Element.getValue(elms[i]);\n                                }\n                            }\n                        }\n                    };\n\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('input'));\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('select'));\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('textarea'));\n\n                    // restore confirmed values\n                    var restoreConfirmedValues = function (elms) {\n                        for (var i = 0; i < elms.length; i++) {\n                            if ('undefined' != typeof fieldsValue[elms[i].name]) {\n                                if (elms[i].type != 'file') {\n                                    if (elms[i].type == 'checkbox') {\n                                        elms[i].checked = fieldsValue[elms[i].name][elms[i].value];\n                                    } else if (elms[i].type == 'radio') {\n                                        if (elms[i].value == fieldsValue[elms[i].name]) {\n                                            elms[i].checked = true;\n                                        }\n                                    } else {\n                                        elms[i].setValue(fieldsValue[elms[i].name]);\n                                    }\n                                }\n                            }\n                        }\n                    };\n\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('input'));\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('select'));\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('textarea'));\n\n                    // Execute scripts\n                    if (mageData && mageData.scripts) {\n                        this.restorePhase = true;\n\n                        try {\n                            mageData.scripts.map(function (script) {\n                                return eval(script);\n                            });\n                        } catch (e) {\n\n                        }\n                        this.restorePhase = false;\n                    }\n                    break;\n\n                case 'current_confirmed_to_form':\n                    var allowedListTypes = {};\n\n                    allowedListTypes[this.current.listType] = true;\n                    var listInfo = this.listTypes[this.current.listType];\n\n                    if (listInfo.complexTypes) {\n                        for (var i = 0, len = listInfo.complexTypes.length; i < len; i++) {\n                            allowedListTypes[listInfo.complexTypes[i]] = true;\n                        }\n                    }\n\n                    this.blockFormConfirmed.update();\n                    this.blockConfirmed.childElements().each(function (blockItem) {\n                        var scopeArr    = blockItem.id.match(/.*\\[(\\w+)\\]\\[([^\\]]+)\\]$/);\n                        var listType    = scopeArr[1];\n                        var itemId    = scopeArr[2];\n\n                        if (allowedListTypes[listType] && (!this.itemsFilter[listType] ||\n                            this.itemsFilter[listType].indexOf(itemId) != -1)) {\n                            _renameFields(method, blockItem, listInfo.complexTypes ? listType : null);\n                            this.blockFormConfirmed.insert(blockItem);\n                        }\n                    }.bind(this));\n                    break;\n\n                case 'form_confirmed_to_confirmed':\n                    var listInfo = this.listTypes[this.current.listType];\n\n                    this.blockFormConfirmed.childElements().each(function (blockItem) {\n                        var scopeArr = blockItem.id.match(/.*\\[(\\w+)\\]\\[([^\\]]+)\\]$/);\n                        var listType = scopeArr[1];\n\n                        _renameFields(method, blockItem, listInfo.complexTypes ? listType : null);\n                        this.blockConfirmed.insert(blockItem);\n                    }.bind(this));\n                    break;\n            }\n        },\n\n        /**\n         * Check if qty selected correctly\n         *\n         * @param object element\n         * @param object event\n         */\n        changeOptionQty: function (element, event) {\n            var checkQty = true;\n\n            if ('undefined' != typeof event) {\n                if (event.keyCode == 8 || event.keyCode == 46) {\n                    checkQty = false;\n                }\n            }\n\n            if (checkQty && (Number(element.value) <= 0 || isNaN(Number(element.value)))) {\n                element.value = 1;\n            }\n        }\n    };\n\n    productConfigure = new ProductConfigure();\n    jQuery(document).trigger('productConfigure:inited');\n    jQuery(document).data('productConfigureInited', true);\n});\n","Magento_Catalog/catalog/product/edit/attribute.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage',\n    'validation'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).mage('form').validation({\n            validationUrl: config.validationUrl\n        });\n    };\n});\n","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiated by prepareExports, accounting for which module loader is being used.\n  var weakMapFactory;\n\n  // Extends a Knockout instance with Knockout-ES5 functionality\n  function attachToKo(ko) {\n    ko.track = track;\n    ko.untrack = untrack;\n    ko.getObservable = getObservable;\n    ko.valueHasMutated = valueHasMutated;\n    ko.defineProperty = defineComputedProperty;\n\n    // todo: test it, maybe added it to ko. directly\n    ko.es5 = {\n      getAllObservablesForObject: getAllObservablesForObject,\n      notifyWhenPresentOrFutureArrayValuesMutate: notifyWhenPresentOrFutureArrayValuesMutate,\n      isTracked: isTracked\n    };\n  }\n\n  // Determines which module loading scenario we're in, grabs dependencies, and attaches to KO\n  function prepareExports() {\n    if (typeof exports === 'object' && typeof module === 'object') {\n      // Node.js case - load KO and WeakMap modules synchronously\n      ko = require('knockout');\n      var WM = require('../lib/weakmap');\n      attachToKo(ko);\n      weakMapFactory = function() { return new WM(); };\n      module.exports = ko;\n    } else if (typeof define === 'function' && define.amd) {\n      define(['knockout'], function(koModule) {\n        ko = koModule;\n        attachToKo(koModule);\n        weakMapFactory = function() { return new global.WeakMap(); };\n        return koModule;\n      });\n    } else if ('ko' in global) {\n      // Non-module case - attach to the global instance, and assume a global WeakMap constructor\n      ko = global.ko;\n      attachToKo(global.ko);\n      weakMapFactory = function() { return new global.WeakMap(); };\n    }\n  }\n\n  prepareExports();\n\n})(this);","knockoutjs/knockout-fast-foreach.js":"/*!\n  Knockout Fast Foreach v0.4.1 (2015-07-17T14:06:15.974Z)\n  By: Brian M Hunt (C) 2015\n  License: MIT\n\n  Adds `fastForEach` to `ko.bindingHandlers`.\n*/\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    define(['knockout'], factory);\n  } else if (typeof exports === 'object') {\n    module.exports = factory(require('knockout'));\n  } else {\n    root.KnockoutFastForeach = factory(root.ko);\n  }\n}(this, function (ko) {\n  \"use strict\";\n// index.js\n// --------\n// Fast For Each\n//\n// Employing sound techniques to make a faster Knockout foreach binding.\n// --------\n\n//      Utilities\n\n// from https://github.com/jonschlinkert/is-plain-object\nfunction isPlainObject(o) {\n  return !!o && typeof o === 'object' && o.constructor === Object;\n}\n\n// From knockout/src/virtualElements.js\nvar commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\nvar startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\nvar supportsDocumentFragment = document && typeof document.createDocumentFragment === \"function\";\nfunction isVirtualNode(node) {\n  return (node.nodeType === 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n}\n\n\n// Get a copy of the (possibly virtual) child nodes of the given element,\n// put them into a container, then empty the given node.\nfunction makeTemplateNode(sourceNode) {\n  var container = document.createElement(\"div\");\n  var parentNode;\n  if (sourceNode.content) {\n    // For e.g. <template> tags\n    parentNode = sourceNode.content;\n  } else if (sourceNode.tagName === 'SCRIPT') {\n    parentNode = document.createElement(\"div\");\n    parentNode.innerHTML = sourceNode.text;\n  } else {\n    // Anything else e.g. <div>\n    parentNode = sourceNode;\n  }\n  ko.utils.arrayForEach(ko.virtualElements.childNodes(parentNode), function (child) {\n    // FIXME - This cloneNode could be expensive; we may prefer to iterate over the\n    // parentNode children in reverse (so as not to foul the indexes as childNodes are\n    // removed from parentNode when inserted into the container)\n    if (child) {\n      container.insertBefore(child.cloneNode(true), null);\n    }\n  });\n  return container;\n}\n\nfunction insertAllAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode) {\n  var frag, len, i;\n  // poor man's node and array check, should be enough for this\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\" && typeof nodeOrNodeArrayToInsert.length === \"undefined\") {\n    throw new Error(\"Expected a single node or a node array\");\n  }\n\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\") {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode);\n    return;\n  }\n\n  if (nodeOrNodeArrayToInsert.length === 1) {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert[0], insertAfterNode);\n    return;\n  }\n\n  if (supportsDocumentFragment) {\n    frag = document.createDocumentFragment();\n\n    for (i = 0, len = nodeOrNodeArrayToInsert.length; i !== len; ++i) {\n      frag.appendChild(nodeOrNodeArrayToInsert[i]);\n    }\n    ko.virtualElements.insertAfter(containerNode, frag, insertAfterNode);\n  } else {\n    // Nodes are inserted in reverse order - pushed down immediately after\n    // the last node for the previous item or as the first node of element.\n    for (i = nodeOrNodeArrayToInsert.length - 1; i >= 0; --i) {\n      var child = nodeOrNodeArrayToInsert[i];\n      if (!child) {\n        return;\n      }\n      ko.virtualElements.insertAfter(containerNode, child, insertAfterNode);\n    }\n  }\n}\n\n// Mimic a KO change item 'add'\nfunction valueToChangeAddItem(value, index) {\n  return {\n    status: 'added',\n    value: value,\n    index: index\n  };\n}\n\nfunction isAdditionAdjacentToLast(changeIndex, arrayChanges) {\n  return changeIndex > 0 &&\n    changeIndex < arrayChanges.length &&\n    arrayChanges[changeIndex].status === \"added\" &&\n    arrayChanges[changeIndex - 1].status === \"added\" &&\n    arrayChanges[changeIndex - 1].index === arrayChanges[changeIndex].index - 1;\n}\n\nfunction FastForEach(spec) {\n  this.element = spec.element;\n  this.container = isVirtualNode(this.element) ?\n                   this.element.parentNode : this.element;\n  this.$context = spec.$context;\n  this.data = spec.data;\n  this.as = spec.as;\n  this.noContext = spec.noContext;\n  this.templateNode = makeTemplateNode(\n    spec.name ? document.getElementById(spec.name).cloneNode(true) : spec.element\n  );\n  this.afterQueueFlush = spec.afterQueueFlush;\n  this.beforeQueueFlush = spec.beforeQueueFlush;\n  this.changeQueue = [];\n  this.lastNodesList = [];\n  this.indexesToDelete = [];\n  this.rendering_queued = false;\n\n  // Remove existing content.\n  ko.virtualElements.emptyNode(this.element);\n\n  // Prime content\n  var primeData = ko.unwrap(this.data);\n  if (primeData.map) {\n    this.onArrayChange(primeData.map(valueToChangeAddItem));\n  }\n\n  // Watch for changes\n  if (ko.isObservable(this.data)) {\n    if (!this.data.indexOf) {\n      // Make sure the observable is trackable.\n      this.data = this.data.extend({trackArrayChanges: true});\n    }\n    this.changeSubs = this.data.subscribe(this.onArrayChange, this, 'arrayChange');\n  }\n}\n\n\nFastForEach.animateFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame ||\n  window.mozRequestAnimationFrame || window.msRequestAnimationFrame ||\n  function(cb) { return window.setTimeout(cb, 1000 / 60); };\n\n\nFastForEach.prototype.dispose = function () {\n  if (this.changeSubs) {\n    this.changeSubs.dispose();\n  }\n};\n\n\n// If the array changes we register the change.\nFastForEach.prototype.onArrayChange = function (changeSet) {\n  var self = this;\n  var changeMap = {\n    added: [],\n    deleted: []\n  };\n  for (var i = 0, len = changeSet.length; i < len; i++) {\n    // the change is appended to a last change info object when both are 'added' and have indexes next to each other\n    // here I presume that ko is sending changes in monotonic order (in index variable) which happens to be true, tested with push and splice with multiple pushed values\n    if (isAdditionAdjacentToLast(i, changeSet)) {\n      var batchValues = changeMap.added[changeMap.added.length - 1].values;\n      if (!batchValues) {\n        // transform the last addition into a batch addition object\n        var lastAddition = changeMap.added.pop();\n        var batchAddition = {\n          isBatch: true,\n          status: 'added',\n          index: lastAddition.index,\n          values: [lastAddition.value]\n        };\n        batchValues = batchAddition.values;\n        changeMap.added.push(batchAddition);\n      }\n      batchValues.push(changeSet[i].value);\n    } else {\n      changeMap[changeSet[i].status].push(changeSet[i]);\n    }\n  }\n  if (changeMap.deleted.length > 0) {\n    this.changeQueue.push.apply(this.changeQueue, changeMap.deleted);\n    this.changeQueue.push({status: 'clearDeletedIndexes'});\n  }\n  this.changeQueue.push.apply(this.changeQueue, changeMap.added);\n  // Once a change is registered, the ticking count-down starts for the processQueue.\n  if (this.changeQueue.length > 0 && !this.rendering_queued) {\n    this.rendering_queued = true;\n    FastForEach.animateFrame.call(window, function () { self.processQueue(); });\n  }\n};\n\n\n// Reflect all the changes in the queue in the DOM, then wipe the queue.\nFastForEach.prototype.processQueue = function () {\n  var self = this;\n\n  // Callback so folks can do things before the queue flush.\n  if (typeof this.beforeQueueFlush === 'function') {\n    this.beforeQueueFlush(this.changeQueue);\n  }\n\n  ko.utils.arrayForEach(this.changeQueue, function (changeItem) {\n    // console.log(self.data(), \"CI\", JSON.stringify(changeItem, null, 2), JSON.stringify($(self.element).text()))\n    self[changeItem.status](changeItem);\n    // console.log(\"  ==> \", JSON.stringify($(self.element).text()))\n  });\n  this.rendering_queued = false;\n  // Callback so folks can do things.\n  if (typeof this.afterQueueFlush === 'function') {\n    this.afterQueueFlush(this.changeQueue);\n  }\n  this.changeQueue = [];\n};\n\n\n// Process a changeItem with {status: 'added', ...}\nFastForEach.prototype.added = function (changeItem) {\n  var index = changeItem.index;\n  var valuesToAdd = changeItem.isBatch ? changeItem.values : [changeItem.value];\n  var referenceElement = this.lastNodesList[index - 1] || null;\n  // gather all childnodes for a possible batch insertion\n  var allChildNodes = [];\n\n  for (var i = 0, len = valuesToAdd.length; i < len; ++i) {\n    var templateClone = this.templateNode.cloneNode(true);\n    var childContext;\n\n    if (this.noContext) {\n      childContext = this.$context.extend({\n        '$item': valuesToAdd[i]\n      });\n    } else {\n      childContext = this.$context.createChildContext(valuesToAdd[i], this.as || null);\n    }\n\n    // apply bindings first, and then process child nodes, because bindings can add childnodes\n    ko.applyBindingsToDescendants(childContext, templateClone);\n\n    var childNodes = ko.virtualElements.childNodes(templateClone);\n    // Note discussion at https://github.com/angular/angular.js/issues/7851\n    allChildNodes.push.apply(allChildNodes, Array.prototype.slice.call(childNodes));\n    this.lastNodesList.splice(index + i, 0, childNodes[childNodes.length - 1]);\n  }\n\n  insertAllAfter(this.element, allChildNodes, referenceElement);\n};\n\n\n// Process a changeItem with {status: 'deleted', ...}\nFastForEach.prototype.deleted = function (changeItem) {\n  var index = changeItem.index;\n  var ptr = this.lastNodesList[index],\n      // We use this.element because that will be the last previous node\n      // for virtual element lists.\n      lastNode = this.lastNodesList[index - 1] || this.element;\n  do {\n    ptr = ptr.previousSibling;\n    ko.removeNode((ptr && ptr.nextSibling) || ko.virtualElements.firstChild(this.element));\n  } while (ptr && ptr !== lastNode);\n  // The \"last node\" in the DOM from which we begin our delets of the next adjacent node is\n  // now the sibling that preceded the first node of this item.\n  this.lastNodesList[index] = this.lastNodesList[index - 1];\n  this.indexesToDelete.push(index);\n};\n\n\n// We batch our deletion of item indexes in our parallel array.\n// See brianmhunt/knockout-fast-foreach#6/#8\nFastForEach.prototype.clearDeletedIndexes = function () {\n  // We iterate in reverse on the presumption (following the unit tests) that KO's diff engine\n  // processes diffs (esp. deletes) monotonically ascending i.e. from index 0 -> N.\n  for (var i = this.indexesToDelete.length - 1; i >= 0; --i) {\n    this.lastNodesList.splice(this.indexesToDelete[i], 1);\n  }\n  this.indexesToDelete = [];\n};\n\n\nko.bindingHandlers.fastForEach = {\n  // Valid valueAccessors:\n  //    []\n  //    ko.observable([])\n  //    ko.observableArray([])\n  //    ko.computed\n  //    {data: array, name: string, as: string}\n  init: function init(element, valueAccessor, bindings, vm, context) {\n    var value = valueAccessor(),\n        ffe;\n    if (isPlainObject(value)) {\n      value.element = value.element || element;\n      value.$context = context;\n      ffe = new FastForEach(value);\n    } else {\n      ffe = new FastForEach({\n        element: element,\n        data: ko.unwrap(context.$rawData) === value ? context.$rawData : value,\n        $context: context\n      });\n    }\n    ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n      ffe.dispose();\n    });\n    return {controlsDescendantBindings: true};\n  },\n\n  // Export for testing, debugging, and overloading.\n  FastForEach: FastForEach\n};\n\nko.virtualElements.allowedBindings.fastForEach = true;\n}));"}
}});
