require.config({"config": {
        "jsbuild":{"jquery/ui-modules/i18n/datepicker-ml.js":"/* Malayalam (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Saji Nediyanchath (saji89@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ml = {\n\tcloseText: \"\u0d36\u0d30\u0d3f\",\n\tprevText: \"\u0d2e\u0d41\u0d28\u0d4d\u0d28\u0d24\u0d4d\u0d24\u0d46\",\n\tnextText: \"\u0d05\u0d1f\u0d41\u0d24\u0d4d\u0d24\u0d24\u0d4d \",\n\tcurrentText: \"\u0d07\u0d28\u0d4d\u0d28\u0d4d\",\n\tmonthNames: [ \"\u0d1c\u0d28\u0d41\u0d35\u0d30\u0d3f\", \"\u0d2b\u0d46\u0d2c\u0d4d\u0d30\u0d41\u0d35\u0d30\u0d3f\", \"\u0d2e\u0d3e\u0d30\u0d4d\u200d\u0d1a\u0d4d\u0d1a\u0d4d\", \"\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u200d\", \"\u0d2e\u0d47\u0d2f\u0d4d\", \"\u0d1c\u0d42\u0d23\u0d4d\u200d\",\n\t\"\u0d1c\u0d42\u0d32\u0d48\", \"\u0d06\u0d17\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4d\", \"\u0d38\u0d46\u0d2a\u0d4d\u0d31\u0d4d\u0d31\u0d02\u0d2c\u0d30\u0d4d\u200d\", \"\u0d12\u0d15\u0d4d\u0d1f\u0d4b\u0d2c\u0d30\u0d4d\u200d\", \"\u0d28\u0d35\u0d02\u0d2c\u0d30\u0d4d\u200d\", \"\u0d21\u0d3f\u0d38\u0d02\u0d2c\u0d30\u0d4d\u200d\" ],\n\tmonthNamesShort: [ \"\u0d1c\u0d28\u0d41\", \"\u0d2b\u0d46\u0d2c\u0d4d\", \"\u0d2e\u0d3e\u0d30\u0d4d\u200d\", \"\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\", \"\u0d2e\u0d47\u0d2f\u0d4d\", \"\u0d1c\u0d42\u0d23\u0d4d\u200d\",\n\t\"\u0d1c\u0d42\u0d32\u0d3e\", \"\u0d06\u0d17\", \"\u0d38\u0d46\u0d2a\u0d4d\", \"\u0d12\u0d15\u0d4d\u0d1f\u0d4b\", \"\u0d28\u0d35\u0d02\", \"\u0d21\u0d3f\u0d38\" ],\n\tdayNames: [ \"\u0d1e\u0d3e\u0d2f\u0d30\u0d4d\u200d\", \"\u0d24\u0d3f\u0d19\u0d4d\u0d15\u0d33\u0d4d\u200d\", \"\u0d1a\u0d4a\u0d35\u0d4d\u0d35\", \"\u0d2c\u0d41\u0d27\u0d28\u0d4d\u200d\", \"\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02\", \"\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\", \"\u0d36\u0d28\u0d3f\" ],\n\tdayNamesShort: [ \"\u0d1e\u0d3e\u0d2f\", \"\u0d24\u0d3f\u0d19\u0d4d\u0d15\", \"\u0d1a\u0d4a\u0d35\u0d4d\u0d35\", \"\u0d2c\u0d41\u0d27\", \"\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02\", \"\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\", \"\u0d36\u0d28\u0d3f\" ],\n\tdayNamesMin: [ \"\u0d1e\u0d3e\", \"\u0d24\u0d3f\", \"\u0d1a\u0d4a\", \"\u0d2c\u0d41\", \"\u0d35\u0d4d\u0d2f\u0d3e\", \"\u0d35\u0d46\", \"\u0d36\" ],\n\tweekHeader: \"\u0d06\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ml );\n\nreturn datepicker.regional.ml;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr.js":"/* French initialisation for the jQuery UI date picker plugin. */\n/* Written by Keith Wood (kbwood{at}iinet.com.au),\n\t\t\t  St\u00e9phane Nahmani (sholby@sholby.net),\n\t\t\t  St\u00e9phane Raimbault <stephane.raimbault@gmail.com> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fr = {\n\tcloseText: \"Fermer\",\n\tprevText: \"Pr\u00e9c\u00e9dent\",\n\tnextText: \"Suivant\",\n\tcurrentText: \"Aujourd'hui\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avr.\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sem.\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fr );\n\nreturn datepicker.regional.fr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ca.js":"/* Inicialitzaci\u00f3 en catal\u00e0 per a l'extensi\u00f3 'UI date picker' per jQuery. */\n/* Writers: (joan.leon@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ca = {\n\tcloseText: \"Tanca\",\n\tprevText: \"Anterior\",\n\tnextText: \"Seg\u00fcent\",\n\tcurrentText: \"Avui\",\n\tmonthNames: [ \"gener\", \"febrer\", \"mar\u00e7\", \"abril\", \"maig\", \"juny\",\n\t\"juliol\", \"agost\", \"setembre\", \"octubre\", \"novembre\", \"desembre\" ],\n\tmonthNamesShort: [ \"gen\", \"feb\", \"mar\u00e7\", \"abr\", \"maig\", \"juny\",\n\t\"jul\", \"ag\", \"set\", \"oct\", \"nov\", \"des\" ],\n\tdayNames: [ \"diumenge\", \"dilluns\", \"dimarts\", \"dimecres\", \"dijous\", \"divendres\", \"dissabte\" ],\n\tdayNamesShort: [ \"dg\", \"dl\", \"dt\", \"dc\", \"dj\", \"dv\", \"ds\" ],\n\tdayNamesMin: [ \"dg\", \"dl\", \"dt\", \"dc\", \"dj\", \"dv\", \"ds\" ],\n\tweekHeader: \"Set\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ca );\n\nreturn datepicker.regional.ca;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ru.js":"/* Russian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Andrew Stromnov (stromnov@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ru = {\n\tcloseText: \"\u0417\u0430\u043a\u0440\u044b\u0442\u044c\",\n\tprevText: \"&#x3C;\u041f\u0440\u0435\u0434\",\n\tnextText: \"\u0421\u043b\u0435\u0434&#x3E;\",\n\tcurrentText: \"\u0421\u0435\u0433\u043e\u0434\u043d\u044f\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\u044c\", \"\u0424\u0435\u0432\u0440\u0430\u043b\u044c\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\u044c\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\u044c\",\n\t\"\u0418\u044e\u043b\u044c\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c\", \"\u041e\u043a\u0442\u044f\u0431\u0440\u044c\", \"\u041d\u043e\u044f\u0431\u0440\u044c\", \"\u0414\u0435\u043a\u0430\u0431\u0440\u044c\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435\", \"\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a\", \"\u0432\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0441\u0440\u0435\u0434\u0430\", \"\u0447\u0435\u0442\u0432\u0435\u0440\u0433\", \"\u043f\u044f\u0442\u043d\u0438\u0446\u0430\", \"\u0441\u0443\u0431\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u0432\u0441\u043a\", \"\u043f\u043d\u0434\", \"\u0432\u0442\u0440\", \"\u0441\u0440\u0434\", \"\u0447\u0442\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u0412\u0441\", \"\u041f\u043d\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0442\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u041d\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ru );\n\nreturn datepicker.regional.ru;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr-CA.js":"/* Canadian-French initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"fr-CA\" ] = {\n\tcloseText: \"Fermer\",\n\tprevText: \"Pr\u00e9c\u00e9dent\",\n\tnextText: \"Suivant\",\n\tcurrentText: \"Aujourd'hui\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sem.\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional[ \"fr-CA\" ] );\n\nreturn datepicker.regional[ \"fr-CA\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-sk.js":"/* Slovak initialisation for the jQuery UI date picker plugin. */\n/* Written by Vojtech Rinik (vojto@hmm.sk). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sk = {\n\tcloseText: \"Zavrie\u0165\",\n\tprevText: \"&#x3C;Predch\u00e1dzaj\u00faci\",\n\tnextText: \"Nasleduj\u00faci&#x3E;\",\n\tcurrentText: \"Dnes\",\n\tmonthNames: [ \"janu\u00e1r\", \"febru\u00e1r\", \"marec\", \"apr\u00edl\", \"m\u00e1j\", \"j\u00fan\",\n\t\"j\u00fal\", \"august\", \"september\", \"okt\u00f3ber\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"M\u00e1j\", \"J\u00fan\",\n\t\"J\u00fal\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"nede\u013ea\", \"pondelok\", \"utorok\", \"streda\", \"\u0161tvrtok\", \"piatok\", \"sobota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Str\", \"\u0160tv\", \"Pia\", \"Sob\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"St\", \"\u0160t\", \"Pia\", \"So\" ],\n\tweekHeader: \"Ty\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sk );\n\nreturn datepicker.regional.sk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-cy-GB.js":"/* Welsh/UK initialisation for the jQuery UI date picker plugin. */\n/* Written by William Griffiths. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"cy-GB\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"Ionawr\", \"Chwefror\", \"Mawrth\", \"Ebrill\", \"Mai\", \"Mehefin\",\n\t\"Gorffennaf\", \"Awst\", \"Medi\", \"Hydref\", \"Tachwedd\", \"Rhagfyr\" ],\n\tmonthNamesShort: [ \"Ion\", \"Chw\", \"Maw\", \"Ebr\", \"Mai\", \"Meh\",\n\t\"Gor\", \"Aws\", \"Med\", \"Hyd\", \"Tac\", \"Rha\" ],\n\tdayNames: [\n\t\t\"Dydd Sul\",\n\t\t\"Dydd Llun\",\n\t\t\"Dydd Mawrth\",\n\t\t\"Dydd Mercher\",\n\t\t\"Dydd Iau\",\n\t\t\"Dydd Gwener\",\n\t\t\"Dydd Sadwrn\"\n\t],\n\tdayNamesShort: [ \"Sul\", \"Llu\", \"Maw\", \"Mer\", \"Iau\", \"Gwe\", \"Sad\" ],\n\tdayNamesMin: [ \"Su\", \"Ll\", \"Ma\", \"Me\", \"Ia\", \"Gw\", \"Sa\" ],\n\tweekHeader: \"Wy\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"cy-GB\" ] );\n\nreturn datepicker.regional[ \"cy-GB\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-is.js":"/* Icelandic initialisation for the jQuery UI date picker plugin. */\n/* Written by Haukur H. Thorsson (haukur@eskill.is). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.is = {\n\tcloseText: \"Loka\",\n\tprevText: \"&#x3C; Fyrri\",\n\tnextText: \"N\u00e6sti &#x3E;\",\n\tcurrentText: \"\u00cd dag\",\n\tmonthNames: [ \"Jan\u00faar\", \"Febr\u00faar\", \"Mars\", \"Apr\u00edl\", \"Ma\u00ed\", \"J\u00fan\u00ed\",\n\t\"J\u00fal\u00ed\", \"\u00c1g\u00fast\", \"September\", \"Okt\u00f3ber\", \"N\u00f3vember\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Ma\u00ed\", \"J\u00fan\",\n\t\"J\u00fal\", \"\u00c1g\u00fa\", \"Sep\", \"Okt\", \"N\u00f3v\", \"Des\" ],\n\tdayNames: [\n\t\t\"Sunnudagur\",\n\t\t\"M\u00e1nudagur\",\n\t\t\"\u00deri\u00f0judagur\",\n\t\t\"Mi\u00f0vikudagur\",\n\t\t\"Fimmtudagur\",\n\t\t\"F\u00f6studagur\",\n\t\t\"Laugardagur\"\n\t],\n\tdayNamesShort: [ \"Sun\", \"M\u00e1n\", \"\u00deri\", \"Mi\u00f0\", \"Fim\", \"F\u00f6s\", \"Lau\" ],\n\tdayNamesMin: [ \"Su\", \"M\u00e1\", \"\u00der\", \"Mi\", \"Fi\", \"F\u00f6\", \"La\" ],\n\tweekHeader: \"Vika\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.is );\n\nreturn datepicker.regional.is;\n\n} );\n","jquery/ui-modules/i18n/datepicker-it-CH.js":"/* Italian initialisation for the jQuery UI date picker plugin. */\n/* Written by Antonello Pasella (antonello.pasella@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"it-CH\" ] = {\n\tcloseText: \"Chiudi\",\n\tprevText: \"&#x3C;Prec\",\n\tnextText: \"Succ&#x3E;\",\n\tcurrentText: \"Oggi\",\n\tmonthNames: [ \"Gennaio\", \"Febbraio\", \"Marzo\", \"Aprile\", \"Maggio\", \"Giugno\",\n\t\t\"Luglio\", \"Agosto\", \"Settembre\", \"Ottobre\", \"Novembre\", \"Dicembre\" ],\n\tmonthNamesShort: [ \"Gen\", \"Feb\", \"Mar\", \"Apr\", \"Mag\", \"Giu\",\n\t\t\"Lug\", \"Ago\", \"Set\", \"Ott\", \"Nov\", \"Dic\" ],\n\tdayNames: [ \"Domenica\", \"Luned\u00ec\", \"Marted\u00ec\", \"Mercoled\u00ec\", \"Gioved\u00ec\", \"Venerd\u00ec\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"Mer\", \"Gio\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"it-CH\" ] );\n\nreturn datepicker.regional[ \"it-CH\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-it.js":"/* Italian initialisation for the jQuery UI date picker plugin. */\n/* Written by Antonello Pasella (antonello.pasella@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.it = {\n\tcloseText: \"Chiudi\",\n\tprevText: \"&#x3C;Prec\",\n\tnextText: \"Succ&#x3E;\",\n\tcurrentText: \"Oggi\",\n\tmonthNames: [ \"Gennaio\", \"Febbraio\", \"Marzo\", \"Aprile\", \"Maggio\", \"Giugno\",\n\t\t\"Luglio\", \"Agosto\", \"Settembre\", \"Ottobre\", \"Novembre\", \"Dicembre\" ],\n\tmonthNamesShort: [ \"Gen\", \"Feb\", \"Mar\", \"Apr\", \"Mag\", \"Giu\",\n\t\t\"Lug\", \"Ago\", \"Set\", \"Ott\", \"Nov\", \"Dic\" ],\n\tdayNames: [ \"Domenica\", \"Luned\u00ec\", \"Marted\u00ec\", \"Mercoled\u00ec\", \"Gioved\u00ec\", \"Venerd\u00ec\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"Mer\", \"Gio\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.it );\n\nreturn datepicker.regional.it;\n\n} );\n","jquery/ui-modules/i18n/datepicker-kk.js":"/* Kazakh (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Dmitriy Karasyov (dmitriy.karasyov@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.kk = {\n\tcloseText: \"\u0416\u0430\u0431\u0443\",\n\tprevText: \"&#x3C;\u0410\u043b\u0434\u044b\u04a3\u0493\u044b\",\n\tnextText: \"\u041a\u0435\u043b\u0435\u0441\u0456&#x3E;\",\n\tcurrentText: \"\u0411\u04af\u0433\u0456\u043d\",\n\tmonthNames: [ \"\u049a\u0430\u04a3\u0442\u0430\u0440\", \"\u0410\u049b\u043f\u0430\u043d\", \"\u041d\u0430\u0443\u0440\u044b\u0437\", \"\u0421\u04d9\u0443\u0456\u0440\", \"\u041c\u0430\u043c\u044b\u0440\", \"\u041c\u0430\u0443\u0441\u044b\u043c\",\n\t\"\u0428\u0456\u043b\u0434\u0435\", \"\u0422\u0430\u043c\u044b\u0437\", \"\u049a\u044b\u0440\u043a\u04af\u0439\u0435\u043a\", \"\u049a\u0430\u0437\u0430\u043d\", \"\u049a\u0430\u0440\u0430\u0448\u0430\", \"\u0416\u0435\u043b\u0442\u043e\u049b\u0441\u0430\u043d\" ],\n\tmonthNamesShort: [ \"\u049a\u0430\u04a3\", \"\u0410\u049b\u043f\", \"\u041d\u0430\u0443\", \"\u0421\u04d9\u0443\", \"\u041c\u0430\u043c\", \"\u041c\u0430\u0443\",\n\t\"\u0428\u0456\u043b\", \"\u0422\u0430\u043c\", \"\u049a\u044b\u0440\", \"\u049a\u0430\u0437\", \"\u049a\u0430\u0440\", \"\u0416\u0435\u043b\" ],\n\tdayNames: [ \"\u0416\u0435\u043a\u0441\u0435\u043d\u0431\u0456\", \"\u0414\u04af\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0421\u0435\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0421\u04d9\u0440\u0441\u0435\u043d\u0431\u0456\", \"\u0411\u0435\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0416\u04b1\u043c\u0430\", \"\u0421\u0435\u043d\u0431\u0456\" ],\n\tdayNamesShort: [ \"\u0436\u043a\u0441\", \"\u0434\u0441\u043d\", \"\u0441\u0441\u043d\", \"\u0441\u0440\u0441\", \"\u0431\u0441\u043d\", \"\u0436\u043c\u0430\", \"\u0441\u043d\u0431\" ],\n\tdayNamesMin: [ \"\u0416\u043a\", \"\u0414\u0441\", \"\u0421\u0441\", \"\u0421\u0440\", \"\u0411\u0441\", \"\u0416\u043c\", \"\u0421\u043d\" ],\n\tweekHeader: \"\u041d\u0435\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.kk );\n\nreturn datepicker.regional.kk;\n\n} );\n","jquery/ui-modules/effects/effect-fade.js":"/*!\n * jQuery UI Effects Fade 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Fade Effect\n//>>group: Effects\n//>>description: Fades the element.\n//>>docs: http://api.jqueryui.com/fade-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"fade\", \"toggle\", function( options, done ) {\n\tvar show = options.mode === \"show\";\n\n\t$( this )\n\t\t.css( \"opacity\", show ? 0 : 1 )\n\t\t.animate( {\n\t\t\topacity: show ? 1 : 0\n\t\t}, {\n\t\t\tqueue: false,\n\t\t\tduration: options.duration,\n\t\t\teasing: options.easing,\n\t\t\tcomplete: done\n\t\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-drop.js":"/*!\n * jQuery UI Effects Drop 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Drop Effect\n//>>group: Effects\n//>>description: Moves an element in one direction and hides it at the same time.\n//>>docs: http://api.jqueryui.com/drop-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"drop\", \"hide\", function( options, done ) {\n\n\tvar distance,\n\t\telement = $( this ),\n\t\tmode = options.mode,\n\t\tshow = mode === \"show\",\n\t\tdirection = options.direction || \"left\",\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tmotion = ( direction === \"up\" || direction === \"left\" ) ? \"-=\" : \"+=\",\n\t\toppositeMotion = ( motion === \"+=\" ) ? \"-=\" : \"+=\",\n\t\tanimation = {\n\t\t\topacity: 0\n\t\t};\n\n\t$.effects.createPlaceholder( element );\n\n\tdistance = options.distance ||\n\t\telement[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]( true ) / 2;\n\n\tanimation[ ref ] = motion + distance;\n\n\tif ( show ) {\n\t\telement.css( animation );\n\n\t\tanimation[ ref ] = oppositeMotion + distance;\n\t\tanimation.opacity = 1;\n\t}\n\n\t// Animate\n\telement.animate( animation, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: done\n\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-puff.js":"/*!\n * jQuery UI Effects Puff 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Puff Effect\n//>>group: Effects\n//>>description: Creates a puff effect by scaling the element up and hiding it at the same time.\n//>>docs: http://api.jqueryui.com/puff-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\",\n\t\t\t\"./effect-scale\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"puff\", \"hide\", function( options, done ) {\n\tvar newOptions = $.extend( true, {}, options, {\n\t\tfade: true,\n\t\tpercent: parseInt( options.percent, 10 ) || 150\n\t} );\n\n\t$.effects.effect.scale.call( this, newOptions, done );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-scale.js":"/*!\n * jQuery UI Effects Scale 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Scale Effect\n//>>group: Effects\n//>>description: Grows or shrinks an element and its content.\n//>>docs: http://api.jqueryui.com/scale-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\",\n\t\t\t\"./effect-size\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"scale\", function( options, done ) {\n\n\t// Create element\n\tvar el = $( this ),\n\t\tmode = options.mode,\n\t\tpercent = parseInt( options.percent, 10 ) ||\n\t\t\t( parseInt( options.percent, 10 ) === 0 ? 0 : ( mode !== \"effect\" ? 0 : 100 ) ),\n\n\t\tnewOptions = $.extend( true, {\n\t\t\tfrom: $.effects.scaledDimensions( el ),\n\t\t\tto: $.effects.scaledDimensions( el, percent, options.direction || \"both\" ),\n\t\t\torigin: options.origin || [ \"middle\", \"center\" ]\n\t\t}, options );\n\n\t// Fade option to support puff\n\tif ( options.fade ) {\n\t\tnewOptions.from.opacity = 1;\n\t\tnewOptions.to.opacity = 0;\n\t}\n\n\t$.effects.effect.size.call( this, newOptions, done );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-size.js":"/*!\n * jQuery UI Effects Size 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Size Effect\n//>>group: Effects\n//>>description: Resize an element to a specified width and height.\n//>>docs: http://api.jqueryui.com/size-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"size\", function( options, done ) {\n\n\t// Create element\n\tvar baseline, factor, temp,\n\t\telement = $( this ),\n\n\t\t// Copy for children\n\t\tcProps = [ \"fontSize\" ],\n\t\tvProps = [ \"borderTopWidth\", \"borderBottomWidth\", \"paddingTop\", \"paddingBottom\" ],\n\t\thProps = [ \"borderLeftWidth\", \"borderRightWidth\", \"paddingLeft\", \"paddingRight\" ],\n\n\t\t// Set options\n\t\tmode = options.mode,\n\t\trestore = mode !== \"effect\",\n\t\tscale = options.scale || \"both\",\n\t\torigin = options.origin || [ \"middle\", \"center\" ],\n\t\tposition = element.css( \"position\" ),\n\t\tpos = element.position(),\n\t\toriginal = $.effects.scaledDimensions( element ),\n\t\tfrom = options.from || original,\n\t\tto = options.to || $.effects.scaledDimensions( element, 0 );\n\n\t$.effects.createPlaceholder( element );\n\n\tif ( mode === \"show\" ) {\n\t\ttemp = from;\n\t\tfrom = to;\n\t\tto = temp;\n\t}\n\n\t// Set scaling factor\n\tfactor = {\n\t\tfrom: {\n\t\t\ty: from.height / original.height,\n\t\t\tx: from.width / original.width\n\t\t},\n\t\tto: {\n\t\t\ty: to.height / original.height,\n\t\t\tx: to.width / original.width\n\t\t}\n\t};\n\n\t// Scale the css box\n\tif ( scale === \"box\" || scale === \"both\" ) {\n\n\t\t// Vertical props scaling\n\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\tfrom = $.effects.setTransition( element, vProps, factor.from.y, from );\n\t\t\tto = $.effects.setTransition( element, vProps, factor.to.y, to );\n\t\t}\n\n\t\t// Horizontal props scaling\n\t\tif ( factor.from.x !== factor.to.x ) {\n\t\t\tfrom = $.effects.setTransition( element, hProps, factor.from.x, from );\n\t\t\tto = $.effects.setTransition( element, hProps, factor.to.x, to );\n\t\t}\n\t}\n\n\t// Scale the content\n\tif ( scale === \"content\" || scale === \"both\" ) {\n\n\t\t// Vertical props scaling\n\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\tfrom = $.effects.setTransition( element, cProps, factor.from.y, from );\n\t\t\tto = $.effects.setTransition( element, cProps, factor.to.y, to );\n\t\t}\n\t}\n\n\t// Adjust the position properties based on the provided origin points\n\tif ( origin ) {\n\t\tbaseline = $.effects.getBaseline( origin, original );\n\t\tfrom.top = ( original.outerHeight - from.outerHeight ) * baseline.y + pos.top;\n\t\tfrom.left = ( original.outerWidth - from.outerWidth ) * baseline.x + pos.left;\n\t\tto.top = ( original.outerHeight - to.outerHeight ) * baseline.y + pos.top;\n\t\tto.left = ( original.outerWidth - to.outerWidth ) * baseline.x + pos.left;\n\t}\n\tdelete from.outerHeight;\n\tdelete from.outerWidth;\n\telement.css( from );\n\n\t// Animate the children if desired\n\tif ( scale === \"content\" || scale === \"both\" ) {\n\n\t\tvProps = vProps.concat( [ \"marginTop\", \"marginBottom\" ] ).concat( cProps );\n\t\thProps = hProps.concat( [ \"marginLeft\", \"marginRight\" ] );\n\n\t\t// Only animate children with width attributes specified\n\t\t// TODO: is this right? should we include anything with css width specified as well\n\t\telement.find( \"*[width]\" ).each( function() {\n\t\t\tvar child = $( this ),\n\t\t\t\tchildOriginal = $.effects.scaledDimensions( child ),\n\t\t\t\tchildFrom = {\n\t\t\t\t\theight: childOriginal.height * factor.from.y,\n\t\t\t\t\twidth: childOriginal.width * factor.from.x,\n\t\t\t\t\touterHeight: childOriginal.outerHeight * factor.from.y,\n\t\t\t\t\touterWidth: childOriginal.outerWidth * factor.from.x\n\t\t\t\t},\n\t\t\t\tchildTo = {\n\t\t\t\t\theight: childOriginal.height * factor.to.y,\n\t\t\t\t\twidth: childOriginal.width * factor.to.x,\n\t\t\t\t\touterHeight: childOriginal.height * factor.to.y,\n\t\t\t\t\touterWidth: childOriginal.width * factor.to.x\n\t\t\t\t};\n\n\t\t\t// Vertical props scaling\n\t\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\t\tchildFrom = $.effects.setTransition( child, vProps, factor.from.y, childFrom );\n\t\t\t\tchildTo = $.effects.setTransition( child, vProps, factor.to.y, childTo );\n\t\t\t}\n\n\t\t\t// Horizontal props scaling\n\t\t\tif ( factor.from.x !== factor.to.x ) {\n\t\t\t\tchildFrom = $.effects.setTransition( child, hProps, factor.from.x, childFrom );\n\t\t\t\tchildTo = $.effects.setTransition( child, hProps, factor.to.x, childTo );\n\t\t\t}\n\n\t\t\tif ( restore ) {\n\t\t\t\t$.effects.saveStyle( child );\n\t\t\t}\n\n\t\t\t// Animate children\n\t\t\tchild.css( childFrom );\n\t\t\tchild.animate( childTo, options.duration, options.easing, function() {\n\n\t\t\t\t// Restore children\n\t\t\t\tif ( restore ) {\n\t\t\t\t\t$.effects.restoreStyle( child );\n\t\t\t\t}\n\t\t\t} );\n\t\t} );\n\t}\n\n\t// Animate\n\telement.animate( to, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: function() {\n\n\t\t\tvar offset = element.offset();\n\n\t\t\tif ( to.opacity === 0 ) {\n\t\t\t\telement.css( \"opacity\", from.opacity );\n\t\t\t}\n\n\t\t\tif ( !restore ) {\n\t\t\t\telement\n\t\t\t\t\t.css( \"position\", position === \"static\" ? \"relative\" : position )\n\t\t\t\t\t.offset( offset );\n\n\t\t\t\t// Need to save style here so that automatic style restoration\n\t\t\t\t// doesn't restore to the original styles from before the animation.\n\t\t\t\t$.effects.saveStyle( element );\n\t\t\t}\n\n\t\t\tdone();\n\t\t}\n\t} );\n\n} );\n\n} );\n","jquery/ui-modules/effects/effect-clip.js":"/*!\n * jQuery UI Effects Clip 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Clip Effect\n//>>group: Effects\n//>>description: Clips the element on and off like an old TV.\n//>>docs: http://api.jqueryui.com/clip-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"clip\", \"hide\", function( options, done ) {\n\tvar start,\n\t\tanimate = {},\n\t\telement = $( this ),\n\t\tdirection = options.direction || \"vertical\",\n\t\tboth = direction === \"both\",\n\t\thorizontal = both || direction === \"horizontal\",\n\t\tvertical = both || direction === \"vertical\";\n\n\tstart = element.cssClip();\n\tanimate.clip = {\n\t\ttop: vertical ? ( start.bottom - start.top ) / 2 : start.top,\n\t\tright: horizontal ? ( start.right - start.left ) / 2 : start.right,\n\t\tbottom: vertical ? ( start.bottom - start.top ) / 2 : start.bottom,\n\t\tleft: horizontal ? ( start.right - start.left ) / 2 : start.left\n\t};\n\n\t$.effects.createPlaceholder( element );\n\n\tif ( options.mode === \"show\" ) {\n\t\telement.cssClip( animate.clip );\n\t\tanimate.clip = start;\n\t}\n\n\telement.animate( animate, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: done\n\t} );\n\n} );\n\n} );\n","jquery/ui-modules/effects/effect-pulsate.js":"/*!\n * jQuery UI Effects Pulsate 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Pulsate Effect\n//>>group: Effects\n//>>description: Pulsates an element n times by changing the opacity to zero and back.\n//>>docs: http://api.jqueryui.com/pulsate-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"pulsate\", \"show\", function( options, done ) {\n\tvar element = $( this ),\n\t\tmode = options.mode,\n\t\tshow = mode === \"show\",\n\t\thide = mode === \"hide\",\n\t\tshowhide = show || hide,\n\n\t\t// Showing or hiding leaves off the \"last\" animation\n\t\tanims = ( ( options.times || 5 ) * 2 ) + ( showhide ? 1 : 0 ),\n\t\tduration = options.duration / anims,\n\t\tanimateTo = 0,\n\t\ti = 1,\n\t\tqueuelen = element.queue().length;\n\n\tif ( show || !element.is( \":visible\" ) ) {\n\t\telement.css( \"opacity\", 0 ).show();\n\t\tanimateTo = 1;\n\t}\n\n\t// Anims - 1 opacity \"toggles\"\n\tfor ( ; i < anims; i++ ) {\n\t\telement.animate( { opacity: animateTo }, duration, options.easing );\n\t\tanimateTo = 1 - animateTo;\n\t}\n\n\telement.animate( { opacity: animateTo }, duration, options.easing );\n\n\telement.queue( done );\n\n\t$.effects.unshift( element, queuelen, anims + 1 );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-explode.js":"/*!\n * jQuery UI Effects Explode 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Explode Effect\n//>>group: Effects\n/* eslint-disable max-len */\n//>>description: Explodes an element in all directions into n pieces. Implodes an element to its original wholeness.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/explode-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"explode\", \"hide\", function( options, done ) {\n\n\tvar i, j, left, top, mx, my,\n\t\trows = options.pieces ? Math.round( Math.sqrt( options.pieces ) ) : 3,\n\t\tcells = rows,\n\t\telement = $( this ),\n\t\tmode = options.mode,\n\t\tshow = mode === \"show\",\n\n\t\t// Show and then visibility:hidden the element before calculating offset\n\t\toffset = element.show().css( \"visibility\", \"hidden\" ).offset(),\n\n\t\t// Width and height of a piece\n\t\twidth = Math.ceil( element.outerWidth() / cells ),\n\t\theight = Math.ceil( element.outerHeight() / rows ),\n\t\tpieces = [];\n\n\t// Children animate complete:\n\tfunction childComplete() {\n\t\tpieces.push( this );\n\t\tif ( pieces.length === rows * cells ) {\n\t\t\tanimComplete();\n\t\t}\n\t}\n\n\t// Clone the element for each row and cell.\n\tfor ( i = 0; i < rows; i++ ) { // ===>\n\t\ttop = offset.top + i * height;\n\t\tmy = i - ( rows - 1 ) / 2;\n\n\t\tfor ( j = 0; j < cells; j++ ) { // |||\n\t\t\tleft = offset.left + j * width;\n\t\t\tmx = j - ( cells - 1 ) / 2;\n\n\t\t\t// Create a clone of the now hidden main element that will be absolute positioned\n\t\t\t// within a wrapper div off the -left and -top equal to size of our pieces\n\t\t\telement\n\t\t\t\t.clone()\n\t\t\t\t.appendTo( \"body\" )\n\t\t\t\t.wrap( \"<div></div>\" )\n\t\t\t\t.css( {\n\t\t\t\t\tposition: \"absolute\",\n\t\t\t\t\tvisibility: \"visible\",\n\t\t\t\t\tleft: -j * width,\n\t\t\t\t\ttop: -i * height\n\t\t\t\t} )\n\n\t\t\t\t// Select the wrapper - make it overflow: hidden and absolute positioned based on\n\t\t\t\t// where the original was located +left and +top equal to the size of pieces\n\t\t\t\t.parent()\n\t\t\t\t\t.addClass( \"ui-effects-explode\" )\n\t\t\t\t\t.css( {\n\t\t\t\t\t\tposition: \"absolute\",\n\t\t\t\t\t\toverflow: \"hidden\",\n\t\t\t\t\t\twidth: width,\n\t\t\t\t\t\theight: height,\n\t\t\t\t\t\tleft: left + ( show ? mx * width : 0 ),\n\t\t\t\t\t\ttop: top + ( show ? my * height : 0 ),\n\t\t\t\t\t\topacity: show ? 0 : 1\n\t\t\t\t\t} )\n\t\t\t\t\t.animate( {\n\t\t\t\t\t\tleft: left + ( show ? 0 : mx * width ),\n\t\t\t\t\t\ttop: top + ( show ? 0 : my * height ),\n\t\t\t\t\t\topacity: show ? 1 : 0\n\t\t\t\t\t}, options.duration || 500, options.easing, childComplete );\n\t\t}\n\t}\n\n\tfunction animComplete() {\n\t\telement.css( {\n\t\t\tvisibility: \"visible\"\n\t\t} );\n\t\t$( pieces ).remove();\n\t\tdone();\n\t}\n} );\n\n} );\n","jquery/ui-modules/effects/effect-transfer.js":"/*!\n * jQuery UI Effects Transfer 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Transfer Effect\n//>>group: Effects\n//>>description: Displays a transfer effect from one element to another.\n//>>docs: http://api.jqueryui.com/transfer-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nvar effect;\nif ( $.uiBackCompat !== false ) {\n\teffect = $.effects.define( \"transfer\", function( options, done ) {\n\t\t$( this ).transfer( options, done );\n\t} );\n}\nreturn effect;\n\n} );\n","jquery/ui-modules/effects/effect-blind.js":"/*!\n * jQuery UI Effects Blind 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Blind Effect\n//>>group: Effects\n//>>description: Blinds the element.\n//>>docs: http://api.jqueryui.com/blind-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"blind\", \"hide\", function( options, done ) {\n\tvar map = {\n\t\t\tup: [ \"bottom\", \"top\" ],\n\t\t\tvertical: [ \"bottom\", \"top\" ],\n\t\t\tdown: [ \"top\", \"bottom\" ],\n\t\t\tleft: [ \"right\", \"left\" ],\n\t\t\thorizontal: [ \"right\", \"left\" ],\n\t\t\tright: [ \"left\", \"right\" ]\n\t\t},\n\t\telement = $( this ),\n\t\tdirection = options.direction || \"up\",\n\t\tstart = element.cssClip(),\n\t\tanimate = { clip: $.extend( {}, start ) },\n\t\tplaceholder = $.effects.createPlaceholder( element );\n\n\tanimate.clip[ map[ direction ][ 0 ] ] = animate.clip[ map[ direction ][ 1 ] ];\n\n\tif ( options.mode === \"show\" ) {\n\t\telement.cssClip( animate.clip );\n\t\tif ( placeholder ) {\n\t\t\tplaceholder.css( $.effects.clipToBox( animate ) );\n\t\t}\n\n\t\tanimate.clip = start;\n\t}\n\n\tif ( placeholder ) {\n\t\tplaceholder.animate( $.effects.clipToBox( animate ), options.duration, options.easing );\n\t}\n\n\telement.animate( animate, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: done\n\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-highlight.js":"/*!\n * jQuery UI Effects Highlight 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Highlight Effect\n//>>group: Effects\n//>>description: Highlights the background of an element in a defined color for a custom duration.\n//>>docs: http://api.jqueryui.com/highlight-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"highlight\", \"show\", function( options, done ) {\n\tvar element = $( this ),\n\t\tanimation = {\n\t\t\tbackgroundColor: element.css( \"backgroundColor\" )\n\t\t};\n\n\tif ( options.mode === \"hide\" ) {\n\t\tanimation.opacity = 0;\n\t}\n\n\t$.effects.saveStyle( element );\n\n\telement\n\t\t.css( {\n\t\t\tbackgroundImage: \"none\",\n\t\t\tbackgroundColor: options.color || \"#ffff99\"\n\t\t} )\n\t\t.animate( animation, {\n\t\t\tqueue: false,\n\t\t\tduration: options.duration,\n\t\t\teasing: options.easing,\n\t\t\tcomplete: done\n\t\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-fold.js":"/*!\n * jQuery UI Effects Fold 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Fold Effect\n//>>group: Effects\n//>>description: Folds an element first horizontally and then vertically.\n//>>docs: http://api.jqueryui.com/fold-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"fold\", \"hide\", function( options, done ) {\n\n\t// Create element\n\tvar element = $( this ),\n\t\tmode = options.mode,\n\t\tshow = mode === \"show\",\n\t\thide = mode === \"hide\",\n\t\tsize = options.size || 15,\n\t\tpercent = /([0-9]+)%/.exec( size ),\n\t\thorizFirst = !!options.horizFirst,\n\t\tref = horizFirst ? [ \"right\", \"bottom\" ] : [ \"bottom\", \"right\" ],\n\t\tduration = options.duration / 2,\n\n\t\tplaceholder = $.effects.createPlaceholder( element ),\n\n\t\tstart = element.cssClip(),\n\t\tanimation1 = { clip: $.extend( {}, start ) },\n\t\tanimation2 = { clip: $.extend( {}, start ) },\n\n\t\tdistance = [ start[ ref[ 0 ] ], start[ ref[ 1 ] ] ],\n\n\t\tqueuelen = element.queue().length;\n\n\tif ( percent ) {\n\t\tsize = parseInt( percent[ 1 ], 10 ) / 100 * distance[ hide ? 0 : 1 ];\n\t}\n\tanimation1.clip[ ref[ 0 ] ] = size;\n\tanimation2.clip[ ref[ 0 ] ] = size;\n\tanimation2.clip[ ref[ 1 ] ] = 0;\n\n\tif ( show ) {\n\t\telement.cssClip( animation2.clip );\n\t\tif ( placeholder ) {\n\t\t\tplaceholder.css( $.effects.clipToBox( animation2 ) );\n\t\t}\n\n\t\tanimation2.clip = start;\n\t}\n\n\t// Animate\n\telement\n\t\t.queue( function( next ) {\n\t\t\tif ( placeholder ) {\n\t\t\t\tplaceholder\n\t\t\t\t\t.animate( $.effects.clipToBox( animation1 ), duration, options.easing )\n\t\t\t\t\t.animate( $.effects.clipToBox( animation2 ), duration, options.easing );\n\t\t\t}\n\n\t\t\tnext();\n\t\t} )\n\t\t.animate( animation1, duration, options.easing )\n\t\t.animate( animation2, duration, options.easing )\n\t\t.queue( done );\n\n\t$.effects.unshift( element, queuelen, 4 );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-shake.js":"/*!\n * jQuery UI Effects Shake 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Shake Effect\n//>>group: Effects\n//>>description: Shakes an element horizontally or vertically n times.\n//>>docs: http://api.jqueryui.com/shake-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"shake\", function( options, done ) {\n\n\tvar i = 1,\n\t\telement = $( this ),\n\t\tdirection = options.direction || \"left\",\n\t\tdistance = options.distance || 20,\n\t\ttimes = options.times || 3,\n\t\tanims = times * 2 + 1,\n\t\tspeed = Math.round( options.duration / anims ),\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tpositiveMotion = ( direction === \"up\" || direction === \"left\" ),\n\t\tanimation = {},\n\t\tanimation1 = {},\n\t\tanimation2 = {},\n\n\t\tqueuelen = element.queue().length;\n\n\t$.effects.createPlaceholder( element );\n\n\t// Animation\n\tanimation[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance;\n\tanimation1[ ref ] = ( positiveMotion ? \"+=\" : \"-=\" ) + distance * 2;\n\tanimation2[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance * 2;\n\n\t// Animate\n\telement.animate( animation, speed, options.easing );\n\n\t// Shakes\n\tfor ( ; i < times; i++ ) {\n\t\telement\n\t\t\t.animate( animation1, speed, options.easing )\n\t\t\t.animate( animation2, speed, options.easing );\n\t}\n\n\telement\n\t\t.animate( animation1, speed, options.easing )\n\t\t.animate( animation, speed / 2, options.easing )\n\t\t.queue( done );\n\n\t$.effects.unshift( element, queuelen, anims + 1 );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-slide.js":"/*!\n * jQuery UI Effects Slide 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Slide Effect\n//>>group: Effects\n//>>description: Slides an element in and out of the viewport.\n//>>docs: http://api.jqueryui.com/slide-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"slide\", \"show\", function( options, done ) {\n\tvar startClip, startRef,\n\t\telement = $( this ),\n\t\tmap = {\n\t\t\tup: [ \"bottom\", \"top\" ],\n\t\t\tdown: [ \"top\", \"bottom\" ],\n\t\t\tleft: [ \"right\", \"left\" ],\n\t\t\tright: [ \"left\", \"right\" ]\n\t\t},\n\t\tmode = options.mode,\n\t\tdirection = options.direction || \"left\",\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tpositiveMotion = ( direction === \"up\" || direction === \"left\" ),\n\t\tdistance = options.distance ||\n\t\t\telement[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]( true ),\n\t\tanimation = {};\n\n\t$.effects.createPlaceholder( element );\n\n\tstartClip = element.cssClip();\n\tstartRef = element.position()[ ref ];\n\n\t// Define hide animation\n\tanimation[ ref ] = ( positiveMotion ? -1 : 1 ) * distance + startRef;\n\tanimation.clip = element.cssClip();\n\tanimation.clip[ map[ direction ][ 1 ] ] = animation.clip[ map[ direction ][ 0 ] ];\n\n\t// Reverse the animation if we're showing\n\tif ( mode === \"show\" ) {\n\t\telement.cssClip( animation.clip );\n\t\telement.css( ref, animation[ ref ] );\n\t\tanimation.clip = startClip;\n\t\tanimation[ ref ] = startRef;\n\t}\n\n\t// Actually animate\n\telement.animate( animation, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: done\n\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-bounce.js":"/*!\n * jQuery UI Effects Bounce 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Bounce Effect\n//>>group: Effects\n//>>description: Bounces an element horizontally or vertically n times.\n//>>docs: http://api.jqueryui.com/bounce-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"bounce\", function( options, done ) {\n\tvar upAnim, downAnim, refValue,\n\t\telement = $( this ),\n\n\t\t// Defaults:\n\t\tmode = options.mode,\n\t\thide = mode === \"hide\",\n\t\tshow = mode === \"show\",\n\t\tdirection = options.direction || \"up\",\n\t\tdistance = options.distance,\n\t\ttimes = options.times || 5,\n\n\t\t// Number of internal animations\n\t\tanims = times * 2 + ( show || hide ? 1 : 0 ),\n\t\tspeed = options.duration / anims,\n\t\teasing = options.easing,\n\n\t\t// Utility:\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tmotion = ( direction === \"up\" || direction === \"left\" ),\n\t\ti = 0,\n\n\t\tqueuelen = element.queue().length;\n\n\t$.effects.createPlaceholder( element );\n\n\trefValue = element.css( ref );\n\n\t// Default distance for the BIGGEST bounce is the outer Distance / 3\n\tif ( !distance ) {\n\t\tdistance = element[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]() / 3;\n\t}\n\n\tif ( show ) {\n\t\tdownAnim = { opacity: 1 };\n\t\tdownAnim[ ref ] = refValue;\n\n\t\t// If we are showing, force opacity 0 and set the initial position\n\t\t// then do the \"first\" animation\n\t\telement\n\t\t\t.css( \"opacity\", 0 )\n\t\t\t.css( ref, motion ? -distance * 2 : distance * 2 )\n\t\t\t.animate( downAnim, speed, easing );\n\t}\n\n\t// Start at the smallest distance if we are hiding\n\tif ( hide ) {\n\t\tdistance = distance / Math.pow( 2, times - 1 );\n\t}\n\n\tdownAnim = {};\n\tdownAnim[ ref ] = refValue;\n\n\t// Bounces up/down/left/right then back to 0 -- times * 2 animations happen here\n\tfor ( ; i < times; i++ ) {\n\t\tupAnim = {};\n\t\tupAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n\t\telement\n\t\t\t.animate( upAnim, speed, easing )\n\t\t\t.animate( downAnim, speed, easing );\n\n\t\tdistance = hide ? distance * 2 : distance / 2;\n\t}\n\n\t// Last Bounce when Hiding\n\tif ( hide ) {\n\t\tupAnim = { opacity: 0 };\n\t\tupAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n\t\telement.animate( upAnim, speed, easing );\n\t}\n\n\telement.queue( done );\n\n\t$.effects.unshift( element, queuelen, anims + 1 );\n} );\n\n} );\n","jquery/spectrum/tinycolor.js":"// TinyColor v1.4.2\n// https://github.com/bgrins/TinyColor\n// Brian Grinstead, MIT License\n\n(function(Math) {\n\n    var trimLeft = /^\\s+/,\n        trimRight = /\\s+$/,\n        tinyCounter = 0,\n        mathRound = Math.round,\n        mathMin = Math.min,\n        mathMax = Math.max,\n        mathRandom = Math.random;\n\n    function tinycolor (color, opts) {\n\n        color = (color) ? color : '';\n        opts = opts || { };\n\n        // If input is already a tinycolor, return itself\n        if (color instanceof tinycolor) {\n            return color;\n        }\n        // If we are called as a function, call using new instead\n        if (!(this instanceof tinycolor)) {\n            return new tinycolor(color, opts);\n        }\n\n        var rgb = inputToRGB(color);\n        this._originalInput = color,\n            this._r = rgb.r,\n            this._g = rgb.g,\n            this._b = rgb.b,\n            this._a = rgb.a,\n            this._roundA = mathRound(100*this._a) / 100,\n            this._format = opts.format || rgb.format;\n        this._gradientType = opts.gradientType;\n\n        // Don't let the range of [0,255] come back in [0,1].\n        // Potentially lose a little bit of precision here, but will fix issues where\n        // .5 gets interpreted as half of the total, instead of half of 1\n        // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n        if (this._r < 1) { this._r = mathRound(this._r); }\n        if (this._g < 1) { this._g = mathRound(this._g); }\n        if (this._b < 1) { this._b = mathRound(this._b); }\n\n        this._ok = rgb.ok;\n        this._tc_id = tinyCounter++;\n    }\n\n    tinycolor.prototype = {\n        isDark: function() {\n            return this.getBrightness() < 128;\n        },\n        isLight: function() {\n            return !this.isDark();\n        },\n        isValid: function() {\n            return this._ok;\n        },\n        getOriginalInput: function() {\n            return this._originalInput;\n        },\n        getFormat: function() {\n            return this._format;\n        },\n        getAlpha: function() {\n            return this._a;\n        },\n        getBrightness: function() {\n            //http://www.w3.org/TR/AERT#color-contrast\n            var rgb = this.toRgb();\n            return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n        },\n        getLuminance: function() {\n            //http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef\n            var rgb = this.toRgb();\n            var RsRGB, GsRGB, BsRGB, R, G, B;\n            RsRGB = rgb.r/255;\n            GsRGB = rgb.g/255;\n            BsRGB = rgb.b/255;\n\n            if (RsRGB <= 0.03928) {R = RsRGB / 12.92;} else {R = Math.pow(((RsRGB + 0.055) / 1.055), 2.4);}\n            if (GsRGB <= 0.03928) {G = GsRGB / 12.92;} else {G = Math.pow(((GsRGB + 0.055) / 1.055), 2.4);}\n            if (BsRGB <= 0.03928) {B = BsRGB / 12.92;} else {B = Math.pow(((BsRGB + 0.055) / 1.055), 2.4);}\n            return (0.2126 * R) + (0.7152 * G) + (0.0722 * B);\n        },\n        setAlpha: function(value) {\n            this._a = boundAlpha(value);\n            this._roundA = mathRound(100*this._a) / 100;\n            return this;\n        },\n        toHsv: function() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n        },\n        toHsvString: function() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n            return (this._a == 1) ?\n                \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n        },\n        toHsl: function() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n        },\n        toHslString: function() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n            return (this._a == 1) ?\n                \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n        },\n        toHex: function(allow3Char) {\n            return rgbToHex(this._r, this._g, this._b, allow3Char);\n        },\n        toHexString: function(allow3Char) {\n            return '#' + this.toHex(allow3Char);\n        },\n        toHex8: function(allow4Char) {\n            return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);\n        },\n        toHex8String: function(allow4Char) {\n            return '#' + this.toHex8(allow4Char);\n        },\n        toRgb: function() {\n            return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n        },\n        toRgbString: function() {\n            return (this._a == 1) ?\n                \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n        },\n        toPercentageRgb: function() {\n            return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n        },\n        toPercentageRgbString: function() {\n            return (this._a == 1) ?\n                \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n        },\n        toName: function() {\n            if (this._a === 0) {\n                return \"transparent\";\n            }\n\n            if (this._a < 1) {\n                return false;\n            }\n\n            return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n        },\n        toFilter: function(secondColor) {\n            var hex8String = '#' + rgbaToArgbHex(this._r, this._g, this._b, this._a);\n            var secondHex8String = hex8String;\n            var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n            if (secondColor) {\n                var s = tinycolor(secondColor);\n                secondHex8String = '#' + rgbaToArgbHex(s._r, s._g, s._b, s._a);\n            }\n\n            return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n        },\n        toString: function(format) {\n            var formatSet = !!format;\n            format = format || this._format;\n\n            var formattedString = false;\n            var hasAlpha = this._a < 1 && this._a >= 0;\n            var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"hex4\" || format === \"hex8\" || format === \"name\");\n\n            if (needsAlphaFormat) {\n                // Special case for \"transparent\", all other non-alpha formats\n                // will return rgba when there is transparency.\n                if (format === \"name\" && this._a === 0) {\n                    return this.toName();\n                }\n                return this.toRgbString();\n            }\n            if (format === \"rgb\") {\n                formattedString = this.toRgbString();\n            }\n            if (format === \"prgb\") {\n                formattedString = this.toPercentageRgbString();\n            }\n            if (format === \"hex\" || format === \"hex6\") {\n                formattedString = this.toHexString();\n            }\n            if (format === \"hex3\") {\n                formattedString = this.toHexString(true);\n            }\n            if (format === \"hex4\") {\n                formattedString = this.toHex8String(true);\n            }\n            if (format === \"hex8\") {\n                formattedString = this.toHex8String();\n            }\n            if (format === \"name\") {\n                formattedString = this.toName();\n            }\n            if (format === \"hsl\") {\n                formattedString = this.toHslString();\n            }\n            if (format === \"hsv\") {\n                formattedString = this.toHsvString();\n            }\n\n            return formattedString || this.toHexString();\n        },\n        clone: function() {\n            return tinycolor(this.toString());\n        },\n\n        _applyModification: function(fn, args) {\n            var color = fn.apply(null, [this].concat([].slice.call(args)));\n            this._r = color._r;\n            this._g = color._g;\n            this._b = color._b;\n            this.setAlpha(color._a);\n            return this;\n        },\n        lighten: function() {\n            return this._applyModification(lighten, arguments);\n        },\n        brighten: function() {\n            return this._applyModification(brighten, arguments);\n        },\n        darken: function() {\n            return this._applyModification(darken, arguments);\n        },\n        desaturate: function() {\n            return this._applyModification(desaturate, arguments);\n        },\n        saturate: function() {\n            return this._applyModification(saturate, arguments);\n        },\n        greyscale: function() {\n            return this._applyModification(greyscale, arguments);\n        },\n        spin: function() {\n            return this._applyModification(spin, arguments);\n        },\n\n        _applyCombination: function(fn, args) {\n            return fn.apply(null, [this].concat([].slice.call(args)));\n        },\n        analogous: function() {\n            return this._applyCombination(analogous, arguments);\n        },\n        complement: function() {\n            return this._applyCombination(complement, arguments);\n        },\n        monochromatic: function() {\n            return this._applyCombination(monochromatic, arguments);\n        },\n        splitcomplement: function() {\n            return this._applyCombination(splitcomplement, arguments);\n        },\n        triad: function() {\n            return this._applyCombination(triad, arguments);\n        },\n        tetrad: function() {\n            return this._applyCombination(tetrad, arguments);\n        }\n    };\n\n// If input is an object, force 1 into \"1.0\" to handle ratios properly\n// String input requires \"1.0\" as input, so 1 will be treated as 1\n    tinycolor.fromRatio = function(color, opts) {\n        if (typeof color == \"object\") {\n            var newColor = {};\n            for (var i in color) {\n                if (color.hasOwnProperty(i)) {\n                    if (i === \"a\") {\n                        newColor[i] = color[i];\n                    }\n                    else {\n                        newColor[i] = convertToPercentage(color[i]);\n                    }\n                }\n            }\n            color = newColor;\n        }\n\n        return tinycolor(color, opts);\n    };\n\n// Given a string or object, convert that input to RGB\n// Possible string inputs:\n//\n//     \"red\"\n//     \"#f00\" or \"f00\"\n//     \"#ff0000\" or \"ff0000\"\n//     \"#ff000000\" or \"ff000000\"\n//     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n//     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n//     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n//     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n//     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n//     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n//     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n//\n    function inputToRGB(color) {\n\n        var rgb = { r: 0, g: 0, b: 0 };\n        var a = 1;\n        var s = null;\n        var v = null;\n        var l = null;\n        var ok = false;\n        var format = false;\n\n        if (typeof color == \"string\") {\n            color = stringInputToObject(color);\n        }\n\n        if (typeof color == \"object\") {\n            if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {\n                rgb = rgbToRgb(color.r, color.g, color.b);\n                ok = true;\n                format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n            }\n            else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {\n                s = convertToPercentage(color.s);\n                v = convertToPercentage(color.v);\n                rgb = hsvToRgb(color.h, s, v);\n                ok = true;\n                format = \"hsv\";\n            }\n            else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {\n                s = convertToPercentage(color.s);\n                l = convertToPercentage(color.l);\n                rgb = hslToRgb(color.h, s, l);\n                ok = true;\n                format = \"hsl\";\n            }\n\n            if (color.hasOwnProperty(\"a\")) {\n                a = color.a;\n            }\n        }\n\n        a = boundAlpha(a);\n\n        return {\n            ok: ok,\n            format: color.format || format,\n            r: mathMin(255, mathMax(rgb.r, 0)),\n            g: mathMin(255, mathMax(rgb.g, 0)),\n            b: mathMin(255, mathMax(rgb.b, 0)),\n            a: a\n        };\n    }\n\n\n// Conversion Functions\n// --------------------\n\n// `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n// <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n// `rgbToRgb`\n// Handle bounds / percentage checking to conform to CSS color spec\n// <http://www.w3.org/TR/css3-color/>\n// *Assumes:* r, g, b in [0, 255] or [0, 1]\n// *Returns:* { r, g, b } in [0, 255]\n    function rgbToRgb(r, g, b){\n        return {\n            r: bound01(r, 255) * 255,\n            g: bound01(g, 255) * 255,\n            b: bound01(b, 255) * 255\n        };\n    }\n\n// `rgbToHsl`\n// Converts an RGB color value to HSL.\n// *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n// *Returns:* { h, s, l } in [0,1]\n    function rgbToHsl(r, g, b) {\n\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n\n        var max = mathMax(r, g, b), min = mathMin(r, g, b);\n        var h, s, l = (max + min) / 2;\n\n        if(max == min) {\n            h = s = 0; // achromatic\n        }\n        else {\n            var d = max - min;\n            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n            switch(max) {\n                case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                case g: h = (b - r) / d + 2; break;\n                case b: h = (r - g) / d + 4; break;\n            }\n\n            h /= 6;\n        }\n\n        return { h: h, s: s, l: l };\n    }\n\n// `hslToRgb`\n// Converts an HSL color value to RGB.\n// *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n// *Returns:* { r, g, b } in the set [0, 255]\n    function hslToRgb(h, s, l) {\n        var r, g, b;\n\n        h = bound01(h, 360);\n        s = bound01(s, 100);\n        l = bound01(l, 100);\n\n        function hue2rgb(p, q, t) {\n            if(t < 0) t += 1;\n            if(t > 1) t -= 1;\n            if(t < 1/6) return p + (q - p) * 6 * t;\n            if(t < 1/2) return q;\n            if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n            return p;\n        }\n\n        if(s === 0) {\n            r = g = b = l; // achromatic\n        }\n        else {\n            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n            var p = 2 * l - q;\n            r = hue2rgb(p, q, h + 1/3);\n            g = hue2rgb(p, q, h);\n            b = hue2rgb(p, q, h - 1/3);\n        }\n\n        return { r: r * 255, g: g * 255, b: b * 255 };\n    }\n\n// `rgbToHsv`\n// Converts an RGB color value to HSV\n// *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n// *Returns:* { h, s, v } in [0,1]\n    function rgbToHsv(r, g, b) {\n\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n\n        var max = mathMax(r, g, b), min = mathMin(r, g, b);\n        var h, s, v = max;\n\n        var d = max - min;\n        s = max === 0 ? 0 : d / max;\n\n        if(max == min) {\n            h = 0; // achromatic\n        }\n        else {\n            switch(max) {\n                case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                case g: h = (b - r) / d + 2; break;\n                case b: h = (r - g) / d + 4; break;\n            }\n            h /= 6;\n        }\n        return { h: h, s: s, v: v };\n    }\n\n// `hsvToRgb`\n// Converts an HSV color value to RGB.\n// *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n// *Returns:* { r, g, b } in the set [0, 255]\n    function hsvToRgb(h, s, v) {\n\n        h = bound01(h, 360) * 6;\n        s = bound01(s, 100);\n        v = bound01(v, 100);\n\n        var i = Math.floor(h),\n            f = h - i,\n            p = v * (1 - s),\n            q = v * (1 - f * s),\n            t = v * (1 - (1 - f) * s),\n            mod = i % 6,\n            r = [v, q, p, p, t, v][mod],\n            g = [t, v, v, q, p, p][mod],\n            b = [p, p, t, v, v, q][mod];\n\n        return { r: r * 255, g: g * 255, b: b * 255 };\n    }\n\n// `rgbToHex`\n// Converts an RGB color to hex\n// Assumes r, g, and b are contained in the set [0, 255]\n// Returns a 3 or 6 character hex\n    function rgbToHex(r, g, b, allow3Char) {\n\n        var hex = [\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16))\n        ];\n\n        // Return a 3 character hex if possible\n        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n        }\n\n        return hex.join(\"\");\n    }\n\n// `rgbaToHex`\n// Converts an RGBA color plus alpha transparency to hex\n// Assumes r, g, b are contained in the set [0, 255] and\n// a in [0, 1]. Returns a 4 or 8 character rgba hex\n    function rgbaToHex(r, g, b, a, allow4Char) {\n\n        var hex = [\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16)),\n            pad2(convertDecimalToHex(a))\n        ];\n\n        // Return a 4 character hex if possible\n        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);\n        }\n\n        return hex.join(\"\");\n    }\n\n// `rgbaToArgbHex`\n// Converts an RGBA color to an ARGB Hex8 string\n// Rarely used, but required for \"toFilter()\"\n    function rgbaToArgbHex(r, g, b, a) {\n\n        var hex = [\n            pad2(convertDecimalToHex(a)),\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16))\n        ];\n\n        return hex.join(\"\");\n    }\n\n// `equals`\n// Can be called with any tinycolor input\n    tinycolor.equals = function (color1, color2) {\n        if (!color1 || !color2) { return false; }\n        return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n    };\n\n    tinycolor.random = function() {\n        return tinycolor.fromRatio({\n            r: mathRandom(),\n            g: mathRandom(),\n            b: mathRandom()\n        });\n    };\n\n\n// Modification Functions\n// ----------------------\n// Thanks to less.js for some of the basics here\n// <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n    function desaturate(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.s -= amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n\n    function saturate(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.s += amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n\n    function greyscale(color) {\n        return tinycolor(color).desaturate(100);\n    }\n\n    function lighten (color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.l += amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n    function brighten(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var rgb = tinycolor(color).toRgb();\n        rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n        rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n        rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n        return tinycolor(rgb);\n    }\n\n    function darken (color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.l -= amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n// Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n// Values outside of this range will be wrapped into this range.\n    function spin(color, amount) {\n        var hsl = tinycolor(color).toHsl();\n        var hue = (hsl.h + amount) % 360;\n        hsl.h = hue < 0 ? 360 + hue : hue;\n        return tinycolor(hsl);\n    }\n\n// Combination Functions\n// ---------------------\n// Thanks to jQuery xColor for some of the ideas behind these\n// <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n    function complement(color) {\n        var hsl = tinycolor(color).toHsl();\n        hsl.h = (hsl.h + 180) % 360;\n        return tinycolor(hsl);\n    }\n\n    function triad(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n        ];\n    }\n\n    function tetrad(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n        ];\n    }\n\n    function splitcomplement(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n            tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n        ];\n    }\n\n    function analogous(color, results, slices) {\n        results = results || 6;\n        slices = slices || 30;\n\n        var hsl = tinycolor(color).toHsl();\n        var part = 360 / slices;\n        var ret = [tinycolor(color)];\n\n        for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n            hsl.h = (hsl.h + part) % 360;\n            ret.push(tinycolor(hsl));\n        }\n        return ret;\n    }\n\n    function monochromatic(color, results) {\n        results = results || 6;\n        var hsv = tinycolor(color).toHsv();\n        var h = hsv.h, s = hsv.s, v = hsv.v;\n        var ret = [];\n        var modification = 1 / results;\n\n        while (results--) {\n            ret.push(tinycolor({ h: h, s: s, v: v}));\n            v = (v + modification) % 1;\n        }\n\n        return ret;\n    }\n\n// Utility Functions\n// ---------------------\n\n    tinycolor.mix = function(color1, color2, amount) {\n        amount = (amount === 0) ? 0 : (amount || 50);\n\n        var rgb1 = tinycolor(color1).toRgb();\n        var rgb2 = tinycolor(color2).toRgb();\n\n        var p = amount / 100;\n\n        var rgba = {\n            r: ((rgb2.r - rgb1.r) * p) + rgb1.r,\n            g: ((rgb2.g - rgb1.g) * p) + rgb1.g,\n            b: ((rgb2.b - rgb1.b) * p) + rgb1.b,\n            a: ((rgb2.a - rgb1.a) * p) + rgb1.a\n        };\n\n        return tinycolor(rgba);\n    };\n\n\n// Readability Functions\n// ---------------------\n// <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)\n\n// `contrast`\n// Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)\n    tinycolor.readability = function(color1, color2) {\n        var c1 = tinycolor(color1);\n        var c2 = tinycolor(color2);\n        return (Math.max(c1.getLuminance(),c2.getLuminance())+0.05) / (Math.min(c1.getLuminance(),c2.getLuminance())+0.05);\n    };\n\n// `isReadable`\n// Ensure that foreground and background color combinations meet WCAG2 guidelines.\n// The third argument is an optional Object.\n//      the 'level' property states 'AA' or 'AAA' - if missing or invalid, it defaults to 'AA';\n//      the 'size' property states 'large' or 'small' - if missing or invalid, it defaults to 'small'.\n// If the entire object is absent, isReadable defaults to {level:\"AA\",size:\"small\"}.\n\n// *Example*\n//    tinycolor.isReadable(\"#000\", \"#111\") => false\n//    tinycolor.isReadable(\"#000\", \"#111\",{level:\"AA\",size:\"large\"}) => false\n    tinycolor.isReadable = function(color1, color2, wcag2) {\n        var readability = tinycolor.readability(color1, color2);\n        var wcag2Parms, out;\n\n        out = false;\n\n        wcag2Parms = validateWCAG2Parms(wcag2);\n        switch (wcag2Parms.level + wcag2Parms.size) {\n            case \"AAsmall\":\n            case \"AAAlarge\":\n                out = readability >= 4.5;\n                break;\n            case \"AAlarge\":\n                out = readability >= 3;\n                break;\n            case \"AAAsmall\":\n                out = readability >= 7;\n                break;\n        }\n        return out;\n\n    };\n\n// `mostReadable`\n// Given a base color and a list of possible foreground or background\n// colors for that base, returns the most readable color.\n// Optionally returns Black or White if the most readable color is unreadable.\n// *Example*\n//    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:false}).toHexString(); // \"#112255\"\n//    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:true}).toHexString();  // \"#ffffff\"\n//    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"large\"}).toHexString(); // \"#faf3f3\"\n//    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"small\"}).toHexString(); // \"#ffffff\"\n    tinycolor.mostReadable = function(baseColor, colorList, args) {\n        var bestColor = null;\n        var bestScore = 0;\n        var readability;\n        var includeFallbackColors, level, size ;\n        args = args || {};\n        includeFallbackColors = args.includeFallbackColors ;\n        level = args.level;\n        size = args.size;\n\n        for (var i= 0; i < colorList.length ; i++) {\n            readability = tinycolor.readability(baseColor, colorList[i]);\n            if (readability > bestScore) {\n                bestScore = readability;\n                bestColor = tinycolor(colorList[i]);\n            }\n        }\n\n        if (tinycolor.isReadable(baseColor, bestColor, {\"level\":level,\"size\":size}) || !includeFallbackColors) {\n            return bestColor;\n        }\n        else {\n            args.includeFallbackColors=false;\n            return tinycolor.mostReadable(baseColor,[\"#fff\", \"#000\"],args);\n        }\n    };\n\n\n// Big List of Colors\n// ------------------\n// <http://www.w3.org/TR/css3-color/#svg-color>\n    var names = tinycolor.names = {\n        aliceblue: \"f0f8ff\",\n        antiquewhite: \"faebd7\",\n        aqua: \"0ff\",\n        aquamarine: \"7fffd4\",\n        azure: \"f0ffff\",\n        beige: \"f5f5dc\",\n        bisque: \"ffe4c4\",\n        black: \"000\",\n        blanchedalmond: \"ffebcd\",\n        blue: \"00f\",\n        blueviolet: \"8a2be2\",\n        brown: \"a52a2a\",\n        burlywood: \"deb887\",\n        burntsienna: \"ea7e5d\",\n        cadetblue: \"5f9ea0\",\n        chartreuse: \"7fff00\",\n        chocolate: \"d2691e\",\n        coral: \"ff7f50\",\n        cornflowerblue: \"6495ed\",\n        cornsilk: \"fff8dc\",\n        crimson: \"dc143c\",\n        cyan: \"0ff\",\n        darkblue: \"00008b\",\n        darkcyan: \"008b8b\",\n        darkgoldenrod: \"b8860b\",\n        darkgray: \"a9a9a9\",\n        darkgreen: \"006400\",\n        darkgrey: \"a9a9a9\",\n        darkkhaki: \"bdb76b\",\n        darkmagenta: \"8b008b\",\n        darkolivegreen: \"556b2f\",\n        darkorange: \"ff8c00\",\n        darkorchid: \"9932cc\",\n        darkred: \"8b0000\",\n        darksalmon: \"e9967a\",\n        darkseagreen: \"8fbc8f\",\n        darkslateblue: \"483d8b\",\n        darkslategray: \"2f4f4f\",\n        darkslategrey: \"2f4f4f\",\n        darkturquoise: \"00ced1\",\n        darkviolet: \"9400d3\",\n        deeppink: \"ff1493\",\n        deepskyblue: \"00bfff\",\n        dimgray: \"696969\",\n        dimgrey: \"696969\",\n        dodgerblue: \"1e90ff\",\n        firebrick: \"b22222\",\n        floralwhite: \"fffaf0\",\n        forestgreen: \"228b22\",\n        fuchsia: \"f0f\",\n        gainsboro: \"dcdcdc\",\n        ghostwhite: \"f8f8ff\",\n        gold: \"ffd700\",\n        goldenrod: \"daa520\",\n        gray: \"808080\",\n        green: \"008000\",\n        greenyellow: \"adff2f\",\n        grey: \"808080\",\n        honeydew: \"f0fff0\",\n        hotpink: \"ff69b4\",\n        indianred: \"cd5c5c\",\n        indigo: \"4b0082\",\n        ivory: \"fffff0\",\n        khaki: \"f0e68c\",\n        lavender: \"e6e6fa\",\n        lavenderblush: \"fff0f5\",\n        lawngreen: \"7cfc00\",\n        lemonchiffon: \"fffacd\",\n        lightblue: \"add8e6\",\n        lightcoral: \"f08080\",\n        lightcyan: \"e0ffff\",\n        lightgoldenrodyellow: \"fafad2\",\n        lightgray: \"d3d3d3\",\n        lightgreen: \"90ee90\",\n        lightgrey: \"d3d3d3\",\n        lightpink: \"ffb6c1\",\n        lightsalmon: \"ffa07a\",\n        lightseagreen: \"20b2aa\",\n        lightskyblue: \"87cefa\",\n        lightslategray: \"789\",\n        lightslategrey: \"789\",\n        lightsteelblue: \"b0c4de\",\n        lightyellow: \"ffffe0\",\n        lime: \"0f0\",\n        limegreen: \"32cd32\",\n        linen: \"faf0e6\",\n        magenta: \"f0f\",\n        maroon: \"800000\",\n        mediumaquamarine: \"66cdaa\",\n        mediumblue: \"0000cd\",\n        mediumorchid: \"ba55d3\",\n        mediumpurple: \"9370db\",\n        mediumseagreen: \"3cb371\",\n        mediumslateblue: \"7b68ee\",\n        mediumspringgreen: \"00fa9a\",\n        mediumturquoise: \"48d1cc\",\n        mediumvioletred: \"c71585\",\n        midnightblue: \"191970\",\n        mintcream: \"f5fffa\",\n        mistyrose: \"ffe4e1\",\n        moccasin: \"ffe4b5\",\n        navajowhite: \"ffdead\",\n        navy: \"000080\",\n        oldlace: \"fdf5e6\",\n        olive: \"808000\",\n        olivedrab: \"6b8e23\",\n        orange: \"ffa500\",\n        orangered: \"ff4500\",\n        orchid: \"da70d6\",\n        palegoldenrod: \"eee8aa\",\n        palegreen: \"98fb98\",\n        paleturquoise: \"afeeee\",\n        palevioletred: \"db7093\",\n        papayawhip: \"ffefd5\",\n        peachpuff: \"ffdab9\",\n        peru: \"cd853f\",\n        pink: \"ffc0cb\",\n        plum: \"dda0dd\",\n        powderblue: \"b0e0e6\",\n        purple: \"800080\",\n        rebeccapurple: \"663399\",\n        red: \"f00\",\n        rosybrown: \"bc8f8f\",\n        royalblue: \"4169e1\",\n        saddlebrown: \"8b4513\",\n        salmon: \"fa8072\",\n        sandybrown: \"f4a460\",\n        seagreen: \"2e8b57\",\n        seashell: \"fff5ee\",\n        sienna: \"a0522d\",\n        silver: \"c0c0c0\",\n        skyblue: \"87ceeb\",\n        slateblue: \"6a5acd\",\n        slategray: \"708090\",\n        slategrey: \"708090\",\n        snow: \"fffafa\",\n        springgreen: \"00ff7f\",\n        steelblue: \"4682b4\",\n        tan: \"d2b48c\",\n        teal: \"008080\",\n        thistle: \"d8bfd8\",\n        tomato: \"ff6347\",\n        turquoise: \"40e0d0\",\n        violet: \"ee82ee\",\n        wheat: \"f5deb3\",\n        white: \"fff\",\n        whitesmoke: \"f5f5f5\",\n        yellow: \"ff0\",\n        yellowgreen: \"9acd32\"\n    };\n\n// Make it easy to access colors via `hexNames[hex]`\n    var hexNames = tinycolor.hexNames = flip(names);\n\n\n// Utilities\n// ---------\n\n// `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n    function flip(o) {\n        var flipped = { };\n        for (var i in o) {\n            if (o.hasOwnProperty(i)) {\n                flipped[o[i]] = i;\n            }\n        }\n        return flipped;\n    }\n\n// Return a valid alpha value [0,1] with all invalid values being set to 1\n    function boundAlpha(a) {\n        a = parseFloat(a);\n\n        if (isNaN(a) || a < 0 || a > 1) {\n            a = 1;\n        }\n\n        return a;\n    }\n\n// Take input from [0, n] and return it as [0, 1]\n    function bound01(n, max) {\n        if (isOnePointZero(n)) { n = \"100%\"; }\n\n        var processPercent = isPercentage(n);\n        n = mathMin(max, mathMax(0, parseFloat(n)));\n\n        // Automatically convert percentage into number\n        if (processPercent) {\n            n = parseInt(n * max, 10) / 100;\n        }\n\n        // Handle floating point rounding errors\n        if ((Math.abs(n - max) < 0.000001)) {\n            return 1;\n        }\n\n        // Convert into [0, 1] range if it isn't already\n        return (n % max) / parseFloat(max);\n    }\n\n// Force a number between 0 and 1\n    function clamp01(val) {\n        return mathMin(1, mathMax(0, val));\n    }\n\n// Parse a base-16 hex value into a base-10 integer\n    function parseIntFromHex(val) {\n        return parseInt(val, 16);\n    }\n\n// Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n// <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n    function isOnePointZero(n) {\n        return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n    }\n\n// Check to see if string passed in is a percentage\n    function isPercentage(n) {\n        return typeof n === \"string\" && n.indexOf('%') != -1;\n    }\n\n// Force a hex value to have 2 characters\n    function pad2(c) {\n        return c.length == 1 ? '0' + c : '' + c;\n    }\n\n// Replace a decimal with it's percentage value\n    function convertToPercentage(n) {\n        if (n <= 1) {\n            n = (n * 100) + \"%\";\n        }\n\n        return n;\n    }\n\n// Converts a decimal to a hex value\n    function convertDecimalToHex(d) {\n        return Math.round(parseFloat(d) * 255).toString(16);\n    }\n// Converts a hex value to a decimal\n    function convertHexToDecimal(h) {\n        return (parseIntFromHex(h) / 255);\n    }\n\n    var matchers = (function() {\n\n        // <http://www.w3.org/TR/css3-values/#integers>\n        var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n        // <http://www.w3.org/TR/css3-values/#number-value>\n        var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n        // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n        var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n        // Actual matching.\n        // Parentheses and commas are optional, but not required.\n        // Whitespace can take the place of commas or opening paren\n        var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n        return {\n            CSS_UNIT: new RegExp(CSS_UNIT),\n            rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n            rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n            hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n            hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n            hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n            hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n            hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n            hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n        };\n    })();\n\n// `isValidCSSUnit`\n// Take in a single string / number and check to see if it looks like a CSS unit\n// (see `matchers` above for definition).\n    function isValidCSSUnit(color) {\n        return !!matchers.CSS_UNIT.exec(color);\n    }\n\n// `stringInputToObject`\n// Permissive string parsing.  Take in a number of formats, and output an object\n// based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n    function stringInputToObject(color) {\n\n        color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n        var named = false;\n        if (names[color]) {\n            color = names[color];\n            named = true;\n        }\n        else if (color == 'transparent') {\n            return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n        }\n\n        // Try to match string input using regular expressions.\n        // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n        // Just return an object and let the conversion functions handle that.\n        // This way the result will be the same whether the tinycolor is initialized with string or object.\n        var match;\n        if ((match = matchers.rgb.exec(color))) {\n            return { r: match[1], g: match[2], b: match[3] };\n        }\n        if ((match = matchers.rgba.exec(color))) {\n            return { r: match[1], g: match[2], b: match[3], a: match[4] };\n        }\n        if ((match = matchers.hsl.exec(color))) {\n            return { h: match[1], s: match[2], l: match[3] };\n        }\n        if ((match = matchers.hsla.exec(color))) {\n            return { h: match[1], s: match[2], l: match[3], a: match[4] };\n        }\n        if ((match = matchers.hsv.exec(color))) {\n            return { h: match[1], s: match[2], v: match[3] };\n        }\n        if ((match = matchers.hsva.exec(color))) {\n            return { h: match[1], s: match[2], v: match[3], a: match[4] };\n        }\n        if ((match = matchers.hex8.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                a: convertHexToDecimal(match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if ((match = matchers.hex6.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        if ((match = matchers.hex4.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1] + '' + match[1]),\n                g: parseIntFromHex(match[2] + '' + match[2]),\n                b: parseIntFromHex(match[3] + '' + match[3]),\n                a: convertHexToDecimal(match[4] + '' + match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if ((match = matchers.hex3.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1] + '' + match[1]),\n                g: parseIntFromHex(match[2] + '' + match[2]),\n                b: parseIntFromHex(match[3] + '' + match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n\n        return false;\n    }\n\n    function validateWCAG2Parms(parms) {\n        // return valid WCAG2 parms for isReadable.\n        // If input parms are invalid, return {\"level\":\"AA\", \"size\":\"small\"}\n        var level, size;\n        parms = parms || {\"level\":\"AA\", \"size\":\"small\"};\n        level = (parms.level || \"AA\").toUpperCase();\n        size = (parms.size || \"small\").toLowerCase();\n        if (level !== \"AA\" && level !== \"AAA\") {\n            level = \"AA\";\n        }\n        if (size !== \"small\" && size !== \"large\") {\n            size = \"small\";\n        }\n        return {\"level\":level, \"size\":size};\n    }\n\n// Node: Export function\n    if (typeof module !== \"undefined\" && module.exports) {\n        module.exports = tinycolor;\n    }\n// AMD/requirejs: Define the module\n    else if (typeof define === 'function' && define.amd) {\n        define(function () {return tinycolor;});\n    }\n// Browser: Expose to window\n    else {\n        window.tinycolor = tinycolor;\n    }\n\n})(Math);\n","jquery/spectrum/spectrum.js":"// Spectrum Colorpicker v1.8.1\n// https://github.com/bgrins/spectrum\n// Author: Brian Grinstead\n// License: MIT\n\n(function (factory) {\n    \"use strict\";\n\n    if (typeof define === 'function' && define.amd) { // AMD\n        define(['jquery'], factory);\n    }\n    else if (typeof exports == \"object\" && typeof module == \"object\") { // CommonJS\n        module.exports = factory(require('jquery'));\n    }\n    else { // Browser\n        factory(jQuery);\n    }\n})(function($, undefined) {\n    \"use strict\";\n\n    var defaultOpts = {\n\n            // Callbacks\n            beforeShow: noop,\n            move: noop,\n            change: noop,\n            show: noop,\n            hide: noop,\n\n            // Options\n            color: false,\n            flat: false,\n            showInput: false,\n            allowEmpty: false,\n            showButtons: true,\n            clickoutFiresChange: true,\n            showInitial: false,\n            showPalette: false,\n            showPaletteOnly: false,\n            hideAfterPaletteSelect: false,\n            togglePaletteOnly: false,\n            showSelectionPalette: true,\n            localStorageKey: false,\n            appendTo: \"body\",\n            maxSelectionSize: 7,\n            cancelText: \"cancel\",\n            chooseText: \"choose\",\n            togglePaletteMoreText: \"more\",\n            togglePaletteLessText: \"less\",\n            clearText: \"Clear Color Selection\",\n            noColorSelectedText: \"No Color Selected\",\n            preferredFormat: false,\n            className: \"\", // Deprecated - use containerClassName and replacerClassName instead.\n            containerClassName: \"\",\n            replacerClassName: \"\",\n            showAlpha: false,\n            theme: \"sp-light\",\n            palette: [[\"#ffffff\", \"#000000\", \"#ff0000\", \"#ff8000\", \"#ffff00\", \"#008000\", \"#0000ff\", \"#4b0082\", \"#9400d3\"]],\n            selectionPalette: [],\n            disabled: false,\n            offset: null\n        },\n        spectrums = [],\n        IE = !!/msie/i.exec( window.navigator.userAgent ),\n        rgbaSupport = (function() {\n            function contains( str, substr ) {\n                return !!~('' + str).indexOf(substr);\n            }\n\n            var elem = document.createElement('div');\n            var style = elem.style;\n            style.cssText = 'background-color:rgba(0,0,0,.5)';\n            return contains(style.backgroundColor, 'rgba') || contains(style.backgroundColor, 'hsla');\n        })(),\n        replaceInput = [\n            \"<div class='sp-replacer'>\",\n            \"<div class='sp-preview'><div class='sp-preview-inner'></div></div>\",\n            \"<div class='sp-dd'>&#9660;</div>\",\n            \"</div>\"\n        ].join(''),\n        markup = (function () {\n\n            // IE does not support gradients with multiple stops, so we need to simulate\n            //  that for the rainbow slider with 8 divs that each have a single gradient\n            var gradientFix = \"\";\n            if (IE) {\n                for (var i = 1; i <= 6; i++) {\n                    gradientFix += \"<div class='sp-\" + i + \"'></div>\";\n                }\n            }\n\n            return [\n                \"<div class='sp-container sp-hidden'>\",\n                \"<div class='sp-palette-container'>\",\n                \"<div class='sp-palette sp-thumb sp-cf'></div>\",\n                \"<div class='sp-palette-button-container sp-cf'>\",\n                \"<button type='button' class='sp-palette-toggle'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-picker-container'>\",\n                \"<div class='sp-top sp-cf'>\",\n                \"<div class='sp-fill'></div>\",\n                \"<div class='sp-top-inner'>\",\n                \"<div class='sp-color'>\",\n                \"<div class='sp-sat'>\",\n                \"<div class='sp-val'>\",\n                \"<div class='sp-dragger'></div>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-clear sp-clear-display'>\",\n                \"</div>\",\n                \"<div class='sp-hue'>\",\n                \"<div class='sp-slider'></div>\",\n                gradientFix,\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>\",\n                \"</div>\",\n                \"<div class='sp-input-container sp-cf'>\",\n                \"<input class='sp-input' type='text' spellcheck='false'  />\",\n                \"</div>\",\n                \"<div class='sp-initial sp-thumb sp-cf'></div>\",\n                \"<div class='sp-button-container sp-cf'>\",\n                \"<a class='sp-cancel' href='#'></a>\",\n                \"<button type='button' class='sp-choose'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\"\n            ].join(\"\");\n        })();\n\n    function paletteTemplate (p, color, className, opts) {\n        var html = [];\n        for (var i = 0; i < p.length; i++) {\n            var current = p[i];\n            if(current) {\n                var tiny = tinycolor(current);\n                var c = tiny.toHsl().l < 0.5 ? \"sp-thumb-el sp-thumb-dark\" : \"sp-thumb-el sp-thumb-light\";\n                c += (tinycolor.equals(color, current)) ? \" sp-thumb-active\" : \"\";\n                var formattedString = tiny.toString(opts.preferredFormat || \"rgb\");\n                var swatchStyle = rgbaSupport ? (\"background-color:\" + tiny.toRgbString()) : \"filter:\" + tiny.toFilter();\n                html.push('<span title=\"' + formattedString + '\" data-color=\"' + tiny.toRgbString() + '\" class=\"' + c + '\"><span class=\"sp-thumb-inner\" style=\"' + swatchStyle + ';\"></span></span>');\n            } else {\n                var cls = 'sp-clear-display';\n                html.push($('<div />')\n                    .append($('<span data-color=\"\" style=\"background-color:transparent;\" class=\"' + cls + '\"></span>')\n                        .attr('title', opts.noColorSelectedText)\n                    )\n                    .html()\n                );\n            }\n        }\n        return \"<div class='sp-cf \" + className + \"'>\" + html.join('') + \"</div>\";\n    }\n\n    function hideAll() {\n        for (var i = 0; i < spectrums.length; i++) {\n            if (spectrums[i]) {\n                spectrums[i].hide();\n            }\n        }\n    }\n\n    function instanceOptions(o, callbackContext) {\n        var opts = $.extend({}, defaultOpts, o);\n        opts.callbacks = {\n            'move': bind(opts.move, callbackContext),\n            'change': bind(opts.change, callbackContext),\n            'show': bind(opts.show, callbackContext),\n            'hide': bind(opts.hide, callbackContext),\n            'beforeShow': bind(opts.beforeShow, callbackContext)\n        };\n\n        return opts;\n    }\n\n    function spectrum(element, o) {\n\n        var opts = instanceOptions(o, element),\n            flat = opts.flat,\n            showSelectionPalette = opts.showSelectionPalette,\n            localStorageKey = opts.localStorageKey,\n            theme = opts.theme,\n            callbacks = opts.callbacks,\n            resize = throttle(reflow, 10),\n            visible = false,\n            isDragging = false,\n            dragWidth = 0,\n            dragHeight = 0,\n            dragHelperHeight = 0,\n            slideHeight = 0,\n            slideWidth = 0,\n            alphaWidth = 0,\n            alphaSlideHelperWidth = 0,\n            slideHelperHeight = 0,\n            currentHue = 0,\n            currentSaturation = 0,\n            currentValue = 0,\n            currentAlpha = 1,\n            palette = [],\n            paletteArray = [],\n            paletteLookup = {},\n            selectionPalette = opts.selectionPalette.slice(0),\n            maxSelectionSize = opts.maxSelectionSize,\n            draggingClass = \"sp-dragging\",\n            shiftMovementDirection = null;\n\n        var doc = element.ownerDocument,\n            body = doc.body,\n            boundElement = $(element),\n            disabled = false,\n            container = $(markup, doc).addClass(theme),\n            pickerContainer = container.find(\".sp-picker-container\"),\n            dragger = container.find(\".sp-color\"),\n            dragHelper = container.find(\".sp-dragger\"),\n            slider = container.find(\".sp-hue\"),\n            slideHelper = container.find(\".sp-slider\"),\n            alphaSliderInner = container.find(\".sp-alpha-inner\"),\n            alphaSlider = container.find(\".sp-alpha\"),\n            alphaSlideHelper = container.find(\".sp-alpha-handle\"),\n            textInput = container.find(\".sp-input\"),\n            paletteContainer = container.find(\".sp-palette\"),\n            initialColorContainer = container.find(\".sp-initial\"),\n            cancelButton = container.find(\".sp-cancel\"),\n            clearButton = container.find(\".sp-clear\"),\n            chooseButton = container.find(\".sp-choose\"),\n            toggleButton = container.find(\".sp-palette-toggle\"),\n            isInput = boundElement.is(\"input\"),\n            isInputTypeColor = isInput && boundElement.attr(\"type\") === \"color\" && inputTypeColorSupport(),\n            shouldReplace = isInput && !flat,\n            replacer = (shouldReplace) ? $(replaceInput).addClass(theme).addClass(opts.className).addClass(opts.replacerClassName) : $([]),\n            offsetElement = (shouldReplace) ? replacer : boundElement,\n            previewElement = replacer.find(\".sp-preview-inner\"),\n            initialColor = opts.color || (isInput && boundElement.val()),\n            colorOnShow = false,\n            currentPreferredFormat = opts.preferredFormat,\n            clickoutFiresChange = !opts.showButtons || opts.clickoutFiresChange,\n            isEmpty = !initialColor,\n            allowEmpty = opts.allowEmpty && !isInputTypeColor;\n\n        function applyOptions() {\n\n            if (opts.showPaletteOnly) {\n                opts.showPalette = true;\n            }\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n\n            if (opts.palette) {\n                palette = opts.palette.slice(0);\n                paletteArray = $.isArray(palette[0]) ? palette : [palette];\n                paletteLookup = {};\n                for (var i = 0; i < paletteArray.length; i++) {\n                    for (var j = 0; j < paletteArray[i].length; j++) {\n                        var rgb = tinycolor(paletteArray[i][j]).toRgbString();\n                        paletteLookup[rgb] = true;\n                    }\n                }\n            }\n\n            container.toggleClass(\"sp-flat\", flat);\n            container.toggleClass(\"sp-input-disabled\", !opts.showInput);\n            container.toggleClass(\"sp-alpha-enabled\", opts.showAlpha);\n            container.toggleClass(\"sp-clear-enabled\", allowEmpty);\n            container.toggleClass(\"sp-buttons-disabled\", !opts.showButtons);\n            container.toggleClass(\"sp-palette-buttons-disabled\", !opts.togglePaletteOnly);\n            container.toggleClass(\"sp-palette-disabled\", !opts.showPalette);\n            container.toggleClass(\"sp-palette-only\", opts.showPaletteOnly);\n            container.toggleClass(\"sp-initial-disabled\", !opts.showInitial);\n            container.addClass(opts.className).addClass(opts.containerClassName);\n\n            reflow();\n        }\n\n        function initialize() {\n\n            if (IE) {\n                container.find(\"*:not(input)\").attr(\"unselectable\", \"on\");\n            }\n\n            applyOptions();\n\n            if (shouldReplace) {\n                boundElement.after(replacer).hide();\n            }\n\n            if (!allowEmpty) {\n                clearButton.hide();\n            }\n\n            if (flat) {\n                boundElement.after(container).hide();\n            }\n            else {\n\n                var appendTo = opts.appendTo === \"parent\" ? boundElement.parent() : $(opts.appendTo);\n                if (appendTo.length !== 1) {\n                    appendTo = $(\"body\");\n                }\n\n                appendTo.append(container);\n            }\n\n            updateSelectionPaletteFromStorage();\n\n            offsetElement.on(\"click.spectrum touchstart.spectrum\", function (e) {\n                if (!disabled) {\n                    toggle();\n                }\n\n                e.stopPropagation();\n\n                if (!$(e.target).is(\"input\")) {\n                    e.preventDefault();\n                }\n            });\n\n            if(boundElement.is(\":disabled\") || (opts.disabled === true)) {\n                disable();\n            }\n\n            // Prevent clicks from bubbling up to document.  This would cause it to be hidden.\n            container.click(stopPropagation);\n\n            // Handle user typed input\n            textInput.change(setFromTextInput);\n            textInput.on(\"paste\", function () {\n                setTimeout(setFromTextInput, 1);\n            });\n            textInput.keydown(function (e) { if (e.keyCode == 13) { setFromTextInput(); } });\n\n            cancelButton.text(opts.cancelText);\n            cancelButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                revert();\n                hide();\n            });\n\n            clearButton.attr(\"title\", opts.clearText);\n            clearButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                isEmpty = true;\n                move();\n\n                if(flat) {\n                    //for the flat style, this is a change event\n                    updateOriginalInput(true);\n                }\n            });\n\n            chooseButton.text(opts.chooseText);\n            chooseButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                if (IE && textInput.is(\":focus\")) {\n                    textInput.trigger('change');\n                }\n\n                if (isValid()) {\n                    updateOriginalInput(true);\n                    hide();\n                }\n            });\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n            toggleButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                opts.showPaletteOnly = !opts.showPaletteOnly;\n\n                // To make sure the Picker area is drawn on the right, next to the\n                // Palette area (and not below the palette), first move the Palette\n                // to the left to make space for the picker, plus 5px extra.\n                // The 'applyOptions' function puts the whole container back into place\n                // and takes care of the button-text and the sp-palette-only CSS class.\n                if (!opts.showPaletteOnly && !flat) {\n                    container.css('left', '-=' + (pickerContainer.outerWidth(true) + 5));\n                }\n                applyOptions();\n            });\n\n            draggable(alphaSlider, function (dragX, dragY, e) {\n                currentAlpha = (dragX / alphaWidth);\n                isEmpty = false;\n                if (e.shiftKey) {\n                    currentAlpha = Math.round(currentAlpha * 10) / 10;\n                }\n\n                move();\n            }, dragStart, dragStop);\n\n            draggable(slider, function (dragX, dragY) {\n                currentHue = parseFloat(dragY / slideHeight);\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n                move();\n            }, dragStart, dragStop);\n\n            draggable(dragger, function (dragX, dragY, e) {\n\n                // shift+drag should snap the movement to either the x or y axis.\n                if (!e.shiftKey) {\n                    shiftMovementDirection = null;\n                }\n                else if (!shiftMovementDirection) {\n                    var oldDragX = currentSaturation * dragWidth;\n                    var oldDragY = dragHeight - (currentValue * dragHeight);\n                    var furtherFromX = Math.abs(dragX - oldDragX) > Math.abs(dragY - oldDragY);\n\n                    shiftMovementDirection = furtherFromX ? \"x\" : \"y\";\n                }\n\n                var setSaturation = !shiftMovementDirection || shiftMovementDirection === \"x\";\n                var setValue = !shiftMovementDirection || shiftMovementDirection === \"y\";\n\n                if (setSaturation) {\n                    currentSaturation = parseFloat(dragX / dragWidth);\n                }\n                if (setValue) {\n                    currentValue = parseFloat((dragHeight - dragY) / dragHeight);\n                }\n\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n\n                move();\n\n            }, dragStart, dragStop);\n\n            if (!!initialColor) {\n                set(initialColor);\n\n                // In case color was black - update the preview UI and set the format\n                // since the set function will not run (default color is black).\n                updateUI();\n                currentPreferredFormat = opts.preferredFormat || tinycolor(initialColor).format;\n\n                addColorToSelectionPalette(initialColor);\n            }\n            else {\n                updateUI();\n            }\n\n            if (flat) {\n                show();\n            }\n\n            function paletteElementClick(e) {\n                if (e.data && e.data.ignore) {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n                }\n                else {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n\n                    updateOriginalInput(true);\n                    if (opts.hideAfterPaletteSelect) {\n                        hide();\n                    }\n                }\n\n                return false;\n            }\n\n            var paletteEvent = IE ? \"mousedown.spectrum\" : \"click.spectrum touchstart.spectrum\";\n            paletteContainer.on(paletteEvent, \".sp-thumb-el\", paletteElementClick);\n            initialColorContainer.on(paletteEvent, \".sp-thumb-el:nth-child(1)\", { ignore: true }, paletteElementClick);\n        }\n\n        function updateSelectionPaletteFromStorage() {\n\n            if (localStorageKey && window.localStorage) {\n\n                // Migrate old palettes over to new format.  May want to remove this eventually.\n                try {\n                    var oldPalette = window.localStorage[localStorageKey].split(\",#\");\n                    if (oldPalette.length > 1) {\n                        delete window.localStorage[localStorageKey];\n                        $.each(oldPalette, function(i, c) {\n                            addColorToSelectionPalette(c);\n                        });\n                    }\n                }\n                catch(e) { }\n\n                try {\n                    selectionPalette = window.localStorage[localStorageKey].split(\";\");\n                }\n                catch (e) { }\n            }\n        }\n\n        function addColorToSelectionPalette(color) {\n            if (showSelectionPalette) {\n                var rgb = tinycolor(color).toRgbString();\n                if (!paletteLookup[rgb] && $.inArray(rgb, selectionPalette) === -1) {\n                    selectionPalette.push(rgb);\n                    while(selectionPalette.length > maxSelectionSize) {\n                        selectionPalette.shift();\n                    }\n                }\n\n                if (localStorageKey && window.localStorage) {\n                    try {\n                        window.localStorage[localStorageKey] = selectionPalette.join(\";\");\n                    }\n                    catch(e) { }\n                }\n            }\n        }\n\n        function getUniqueSelectionPalette() {\n            var unique = [];\n            if (opts.showPalette) {\n                for (var i = 0; i < selectionPalette.length; i++) {\n                    var rgb = tinycolor(selectionPalette[i]).toRgbString();\n\n                    if (!paletteLookup[rgb]) {\n                        unique.push(selectionPalette[i]);\n                    }\n                }\n            }\n\n            return unique.reverse().slice(0, opts.maxSelectionSize);\n        }\n\n        function drawPalette() {\n\n            var currentColor = get();\n\n            var html = $.map(paletteArray, function (palette, i) {\n                return paletteTemplate(palette, currentColor, \"sp-palette-row sp-palette-row-\" + i, opts);\n            });\n\n            updateSelectionPaletteFromStorage();\n\n            if (selectionPalette) {\n                html.push(paletteTemplate(getUniqueSelectionPalette(), currentColor, \"sp-palette-row sp-palette-row-selection\", opts));\n            }\n\n            paletteContainer.html(html.join(\"\"));\n        }\n\n        function drawInitial() {\n            if (opts.showInitial) {\n                var initial = colorOnShow;\n                var current = get();\n                initialColorContainer.html(paletteTemplate([initial, current], current, \"sp-palette-row-initial\", opts));\n            }\n        }\n\n        function dragStart() {\n            if (dragHeight <= 0 || dragWidth <= 0 || slideHeight <= 0) {\n                reflow();\n            }\n            isDragging = true;\n            container.addClass(draggingClass);\n            shiftMovementDirection = null;\n            boundElement.trigger('dragstart.spectrum', [ get() ]);\n        }\n\n        function dragStop() {\n            isDragging = false;\n            container.removeClass(draggingClass);\n            boundElement.trigger('dragstop.spectrum', [ get() ]);\n        }\n\n        function setFromTextInput() {\n\n            var value = textInput.val();\n\n            if ((value === null || value === \"\") && allowEmpty) {\n                set(null);\n                move();\n                updateOriginalInput();\n            }\n            else {\n                var tiny = tinycolor(value);\n                if (tiny.isValid()) {\n                    set(tiny);\n                    move();\n                    updateOriginalInput(true);\n                }\n                else {\n                    textInput.addClass(\"sp-validation-error\");\n                }\n            }\n        }\n\n        function toggle() {\n            if (visible) {\n                hide();\n            }\n            else {\n                show();\n            }\n        }\n\n        function show() {\n            var event = $.Event('beforeShow.spectrum');\n\n            if (visible) {\n                reflow();\n                return;\n            }\n\n            boundElement.trigger(event, [ get() ]);\n\n            if (callbacks.beforeShow(get()) === false || event.isDefaultPrevented()) {\n                return;\n            }\n\n            hideAll();\n            visible = true;\n\n            $(doc).on(\"keydown.spectrum\", onkeydown);\n            $(doc).on(\"click.spectrum\", clickout);\n            $(window).on(\"resize.spectrum\", resize);\n            replacer.addClass(\"sp-active\");\n            container.removeClass(\"sp-hidden\");\n\n            reflow();\n            updateUI();\n\n            colorOnShow = get();\n\n            drawInitial();\n            callbacks.show(colorOnShow);\n            boundElement.trigger('show.spectrum', [ colorOnShow ]);\n        }\n\n        function onkeydown(e) {\n            // Close on ESC\n            if (e.keyCode === 27) {\n                hide();\n            }\n        }\n\n        function clickout(e) {\n            // Return on right click.\n            if (e.button == 2) { return; }\n\n            // If a drag event was happening during the mouseup, don't hide\n            // on click.\n            if (isDragging) { return; }\n\n            if (clickoutFiresChange) {\n                updateOriginalInput(true);\n            }\n            else {\n                revert();\n            }\n            hide();\n        }\n\n        function hide() {\n            // Return if hiding is unnecessary\n            if (!visible || flat) { return; }\n            visible = false;\n\n            $(doc).off(\"keydown.spectrum\", onkeydown);\n            $(doc).off(\"click.spectrum\", clickout);\n            $(window).off(\"resize.spectrum\", resize);\n\n            replacer.removeClass(\"sp-active\");\n            container.addClass(\"sp-hidden\");\n\n            callbacks.hide(get());\n            boundElement.trigger('hide.spectrum', [ get() ]);\n        }\n\n        function revert() {\n            set(colorOnShow, true);\n            updateOriginalInput(true);\n        }\n\n        function set(color, ignoreFormatChange) {\n            if (tinycolor.equals(color, get())) {\n                // Update UI just in case a validation error needs\n                // to be cleared.\n                updateUI();\n                return;\n            }\n\n            var newColor, newHsv;\n            if (!color && allowEmpty) {\n                isEmpty = true;\n            } else {\n                isEmpty = false;\n                newColor = tinycolor(color);\n                newHsv = newColor.toHsv();\n\n                currentHue = (newHsv.h % 360) / 360;\n                currentSaturation = newHsv.s;\n                currentValue = newHsv.v;\n                currentAlpha = newHsv.a;\n            }\n            updateUI();\n\n            if (newColor && newColor.isValid() && !ignoreFormatChange) {\n                currentPreferredFormat = opts.preferredFormat || newColor.getFormat();\n            }\n        }\n\n        function get(opts) {\n            opts = opts || { };\n\n            if (allowEmpty && isEmpty) {\n                return null;\n            }\n\n            return tinycolor.fromRatio({\n                h: currentHue,\n                s: currentSaturation,\n                v: currentValue,\n                a: Math.round(currentAlpha * 1000) / 1000\n            }, { format: opts.format || currentPreferredFormat });\n        }\n\n        function isValid() {\n            return !textInput.hasClass(\"sp-validation-error\");\n        }\n\n        function move() {\n            updateUI();\n\n            callbacks.move(get());\n            boundElement.trigger('move.spectrum', [ get() ]);\n        }\n\n        function updateUI() {\n\n            textInput.removeClass(\"sp-validation-error\");\n\n            updateHelperLocations();\n\n            // Update dragger background color (gradients take care of saturation and value).\n            var flatColor = tinycolor.fromRatio({ h: currentHue, s: 1, v: 1 });\n            dragger.css(\"background-color\", flatColor.toHexString());\n\n            // Get a format that alpha will be included in (hex and names ignore alpha)\n            var format = currentPreferredFormat;\n            if (currentAlpha < 1 && !(currentAlpha === 0 && format === \"name\")) {\n                if (format === \"hex\" || format === \"hex3\" || format === \"hex6\" || format === \"name\") {\n                    format = \"rgb\";\n                }\n            }\n\n            var realColor = get({ format: format }),\n                displayColor = '';\n\n            //reset background info for preview element\n            previewElement.removeClass(\"sp-clear-display\");\n            previewElement.css('background-color', 'transparent');\n\n            if (!realColor && allowEmpty) {\n                // Update the replaced elements background with icon indicating no color selection\n                previewElement.addClass(\"sp-clear-display\");\n            }\n            else {\n                var realHex = realColor.toHexString(),\n                    realRgb = realColor.toRgbString();\n\n                // Update the replaced elements background color (with actual selected color)\n                if (rgbaSupport || realColor.alpha === 1) {\n                    previewElement.css(\"background-color\", realRgb);\n                }\n                else {\n                    previewElement.css(\"background-color\", \"transparent\");\n                    previewElement.css(\"filter\", realColor.toFilter());\n                }\n\n                if (opts.showAlpha) {\n                    var rgb = realColor.toRgb();\n                    rgb.a = 0;\n                    var realAlpha = tinycolor(rgb).toRgbString();\n                    var gradient = \"linear-gradient(left, \" + realAlpha + \", \" + realHex + \")\";\n\n                    if (IE) {\n                        alphaSliderInner.css(\"filter\", tinycolor(realAlpha).toFilter({ gradientType: 1 }, realHex));\n                    }\n                    else {\n                        alphaSliderInner.css(\"background\", \"-webkit-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-moz-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-ms-\" + gradient);\n                        // Use current syntax gradient on unprefixed property.\n                        alphaSliderInner.css(\"background\",\n                            \"linear-gradient(to right, \" + realAlpha + \", \" + realHex + \")\");\n                    }\n                }\n\n                displayColor = realColor.toString(format);\n            }\n\n            // Update the text entry input as it changes happen\n            if (opts.showInput) {\n                textInput.val(displayColor);\n            }\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            drawInitial();\n        }\n\n        function updateHelperLocations() {\n            var s = currentSaturation;\n            var v = currentValue;\n\n            if(allowEmpty && isEmpty) {\n                //if selected color is empty, hide the helpers\n                alphaSlideHelper.hide();\n                slideHelper.hide();\n                dragHelper.hide();\n            }\n            else {\n                //make sure helpers are visible\n                alphaSlideHelper.show();\n                slideHelper.show();\n                dragHelper.show();\n\n                // Where to show the little circle in that displays your current selected color\n                var dragX = s * dragWidth;\n                var dragY = dragHeight - (v * dragHeight);\n                dragX = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragWidth - dragHelperHeight, dragX - dragHelperHeight)\n                );\n                dragY = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragHeight - dragHelperHeight, dragY - dragHelperHeight)\n                );\n                dragHelper.css({\n                    \"top\": dragY + \"px\",\n                    \"left\": dragX + \"px\"\n                });\n\n                var alphaX = currentAlpha * alphaWidth;\n                alphaSlideHelper.css({\n                    \"left\": (alphaX - (alphaSlideHelperWidth / 2)) + \"px\"\n                });\n\n                // Where to show the bar that displays your current selected hue\n                var slideY = (currentHue) * slideHeight;\n                slideHelper.css({\n                    \"top\": (slideY - slideHelperHeight) + \"px\"\n                });\n            }\n        }\n\n        function updateOriginalInput(fireCallback) {\n            var color = get(),\n                displayColor = '',\n                hasChanged = !tinycolor.equals(color, colorOnShow);\n\n            if (color) {\n                displayColor = color.toString(currentPreferredFormat);\n                // Update the selection palette with the current color\n                addColorToSelectionPalette(color);\n            }\n\n            if (isInput) {\n                boundElement.val(displayColor);\n            }\n\n            if (fireCallback && hasChanged) {\n                callbacks.change(color);\n                boundElement.trigger('change', [ color ]);\n            }\n        }\n\n        function reflow() {\n            if (!visible) {\n                return; // Calculations would be useless and wouldn't be reliable anyways\n            }\n            dragWidth = dragger.width();\n            dragHeight = dragger.height();\n            dragHelperHeight = dragHelper.height();\n            slideWidth = slider.width();\n            slideHeight = slider.height();\n            slideHelperHeight = slideHelper.height();\n            alphaWidth = alphaSlider.width();\n            alphaSlideHelperWidth = alphaSlideHelper.width();\n\n            if (!flat) {\n                container.css(\"position\", \"absolute\");\n                if (opts.offset) {\n                    container.offset(opts.offset);\n                } else {\n                    container.offset(getOffset(container, offsetElement));\n                }\n            }\n\n            updateHelperLocations();\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            boundElement.trigger('reflow.spectrum');\n        }\n\n        function destroy() {\n            boundElement.show();\n            offsetElement.off(\"click.spectrum touchstart.spectrum\");\n            container.remove();\n            replacer.remove();\n            spectrums[spect.id] = null;\n        }\n\n        function option(optionName, optionValue) {\n            if (optionName === undefined) {\n                return $.extend({}, opts);\n            }\n            if (optionValue === undefined) {\n                return opts[optionName];\n            }\n\n            opts[optionName] = optionValue;\n\n            if (optionName === \"preferredFormat\") {\n                currentPreferredFormat = opts.preferredFormat;\n            }\n            applyOptions();\n        }\n\n        function enable() {\n            disabled = false;\n            boundElement.attr(\"disabled\", false);\n            offsetElement.removeClass(\"sp-disabled\");\n        }\n\n        function disable() {\n            hide();\n            disabled = true;\n            boundElement.attr(\"disabled\", true);\n            offsetElement.addClass(\"sp-disabled\");\n        }\n\n        function setOffset(coord) {\n            opts.offset = coord;\n            reflow();\n        }\n\n        initialize();\n\n        var spect = {\n            show: show,\n            hide: hide,\n            toggle: toggle,\n            reflow: reflow,\n            option: option,\n            enable: enable,\n            disable: disable,\n            offset: setOffset,\n            set: function (c) {\n                set(c);\n                updateOriginalInput();\n            },\n            get: get,\n            destroy: destroy,\n            container: container\n        };\n\n        spect.id = spectrums.push(spect) - 1;\n\n        return spect;\n    }\n\n    /**\n     * checkOffset - get the offset below/above and left/right element depending on screen position\n     * Thanks https://github.com/jquery/jquery-ui/blob/master/ui/jquery.ui.datepicker.js\n     */\n    function getOffset(picker, input) {\n        var extraY = 0;\n        var dpWidth = picker.outerWidth();\n        var dpHeight = picker.outerHeight();\n        var inputHeight = input.outerHeight();\n        var doc = picker[0].ownerDocument;\n        var docElem = doc.documentElement;\n        var viewWidth = docElem.clientWidth + $(doc).scrollLeft();\n        var viewHeight = docElem.clientHeight + $(doc).scrollTop();\n        var offset = input.offset();\n        var offsetLeft = offset.left;\n        var offsetTop = offset.top;\n\n        offsetTop += inputHeight;\n\n        offsetLeft -=\n            Math.min(offsetLeft, (offsetLeft + dpWidth > viewWidth && viewWidth > dpWidth) ?\n                Math.abs(offsetLeft + dpWidth - viewWidth) : 0);\n\n        offsetTop -=\n            Math.min(offsetTop, ((offsetTop + dpHeight > viewHeight && viewHeight > dpHeight) ?\n                Math.abs(dpHeight + inputHeight - extraY) : extraY));\n\n        return {\n            top: offsetTop,\n            bottom: offset.bottom,\n            left: offsetLeft,\n            right: offset.right,\n            width: offset.width,\n            height: offset.height\n        };\n    }\n\n    /**\n     * noop - do nothing\n     */\n    function noop() {\n\n    }\n\n    /**\n     * stopPropagation - makes the code only doing this a little easier to read in line\n     */\n    function stopPropagation(e) {\n        e.stopPropagation();\n    }\n\n    /**\n     * Create a function bound to a given object\n     * Thanks to underscore.js\n     */\n    function bind(func, obj) {\n        var slice = Array.prototype.slice;\n        var args = slice.call(arguments, 2);\n        return function () {\n            return func.apply(obj, args.concat(slice.call(arguments)));\n        };\n    }\n\n    /**\n     * Lightweight drag helper.  Handles containment within the element, so that\n     * when dragging, the x is within [0,element.width] and y is within [0,element.height]\n     */\n    function draggable(element, onmove, onstart, onstop) {\n        onmove = onmove || function () { };\n        onstart = onstart || function () { };\n        onstop = onstop || function () { };\n        var doc = document;\n        var dragging = false;\n        var offset = {};\n        var maxHeight = 0;\n        var maxWidth = 0;\n        var hasTouch = ('ontouchstart' in window);\n\n        var duringDragEvents = {};\n        duringDragEvents[\"selectstart\"] = prevent;\n        duringDragEvents[\"dragstart\"] = prevent;\n        duringDragEvents[\"touchmove mousemove\"] = move;\n        duringDragEvents[\"touchend mouseup\"] = stop;\n\n        function prevent(e) {\n            if (e.stopPropagation) {\n                e.stopPropagation();\n            }\n            if (e.preventDefault) {\n                e.preventDefault();\n            }\n            e.returnValue = false;\n        }\n\n        function move(e) {\n            if (dragging) {\n                // Mouseup happened outside of window\n                if (IE && doc.documentMode < 9 && !e.button) {\n                    return stop();\n                }\n\n                var t0 = e.originalEvent && e.originalEvent.touches && e.originalEvent.touches[0];\n                var pageX = t0 && t0.pageX || e.pageX;\n                var pageY = t0 && t0.pageY || e.pageY;\n\n                var dragX = Math.max(0, Math.min(pageX - offset.left, maxWidth));\n                var dragY = Math.max(0, Math.min(pageY - offset.top, maxHeight));\n\n                if (hasTouch) {\n                    // Stop scrolling in iOS\n                    prevent(e);\n                }\n\n                onmove.apply(element, [dragX, dragY, e]);\n            }\n        }\n\n        function start(e) {\n            var rightclick = (e.which) ? (e.which == 3) : (e.button == 2);\n\n            if (!rightclick && !dragging) {\n                if (onstart.apply(element, arguments) !== false) {\n                    dragging = true;\n                    maxHeight = $(element).height();\n                    maxWidth = $(element).width();\n                    offset = $(element).offset();\n\n                    $(doc).on(duringDragEvents);\n                    $(doc.body).addClass(\"sp-dragging\");\n\n                    move(e);\n\n                    prevent(e);\n                }\n            }\n        }\n\n        function stop() {\n            if (dragging) {\n                $(doc).off(duringDragEvents);\n                $(doc.body).removeClass(\"sp-dragging\");\n\n                // Wait a tick before notifying observers to allow the click event\n                // to fire in Chrome.\n                setTimeout(function() {\n                    onstop.apply(element, arguments);\n                }, 0);\n            }\n            dragging = false;\n        }\n\n        $(element).on(\"touchstart mousedown\", start);\n    }\n\n    function throttle(func, wait, debounce) {\n        var timeout;\n        return function () {\n            var context = this, args = arguments;\n            var throttler = function () {\n                timeout = null;\n                func.apply(context, args);\n            };\n            if (debounce) clearTimeout(timeout);\n            if (debounce || !timeout) timeout = setTimeout(throttler, wait);\n        };\n    }\n\n    function inputTypeColorSupport() {\n        return $.fn.spectrum.inputTypeColorSupport();\n    }\n\n    /**\n     * Define a jQuery plugin\n     */\n    var dataID = \"spectrum.id\";\n    $.fn.spectrum = function (opts, extra) {\n\n        if (typeof opts == \"string\") {\n\n            var returnValue = this;\n            var args = Array.prototype.slice.call( arguments, 1 );\n\n            this.each(function () {\n                var spect = spectrums[$(this).data(dataID)];\n                if (spect) {\n                    var method = spect[opts];\n                    if (!method) {\n                        throw new Error( \"Spectrum: no such method: '\" + opts + \"'\" );\n                    }\n\n                    if (opts == \"get\") {\n                        returnValue = spect.get();\n                    }\n                    else if (opts == \"container\") {\n                        returnValue = spect.container;\n                    }\n                    else if (opts == \"option\") {\n                        returnValue = spect.option.apply(spect, args);\n                    }\n                    else if (opts == \"destroy\") {\n                        spect.destroy();\n                        $(this).removeData(dataID);\n                    }\n                    else {\n                        method.apply(spect, args);\n                    }\n                }\n            });\n\n            return returnValue;\n        }\n\n        // Initializing a new instance of spectrum\n        return this.spectrum(\"destroy\").each(function () {\n            var options = $.extend({}, $(this).data(), opts);\n            var spect = spectrum(this, options);\n            $(this).data(dataID, spect.id);\n        });\n    };\n\n    $.fn.spectrum.load = true;\n    $.fn.spectrum.loadOpts = {};\n    $.fn.spectrum.draggable = draggable;\n    $.fn.spectrum.defaults = defaultOpts;\n    $.fn.spectrum.inputTypeColorSupport = function inputTypeColorSupport() {\n        if (typeof inputTypeColorSupport._cachedResult === \"undefined\") {\n            var colorInput = $(\"<input type='color'/>\")[0]; // if color element is supported, value will default to not null\n            inputTypeColorSupport._cachedResult = colorInput.type === \"color\" && colorInput.value !== \"\";\n        }\n        return inputTypeColorSupport._cachedResult;\n    };\n\n    $.spectrum = { };\n    $.spectrum.localization = { };\n    $.spectrum.palettes = { };\n\n    $.fn.spectrum.processNativeColorInputs = function () {\n        var colorInputs = $(\"input[type=color]\");\n        if (colorInputs.length && !inputTypeColorSupport()) {\n            colorInputs.spectrum({\n                preferredFormat: \"hex6\"\n            });\n        }\n    };\n\n    // TinyColor v1.1.2\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    (function() {\n\n        var trimLeft = /^[\\s,#]+/,\n            trimRight = /\\s+$/,\n            tinyCounter = 0,\n            math = Math,\n            mathRound = math.round,\n            mathMin = math.min,\n            mathMax = math.max,\n            mathRandom = math.random;\n\n        var tinycolor = function(color, opts) {\n\n            color = (color) ? color : '';\n            opts = opts || { };\n\n            // If input is already a tinycolor, return itself\n            if (color instanceof tinycolor) {\n                return color;\n            }\n            // If we are called as a function, call using new instead\n            if (!(this instanceof tinycolor)) {\n                return new tinycolor(color, opts);\n            }\n\n            var rgb = inputToRGB(color);\n            this._originalInput = color;\n            this._r = rgb.r;\n            this._g = rgb.g;\n            this._b = rgb.b;\n            this._a = rgb.a;\n            this._roundA = mathRound(1000 * this._a) / 1000;\n            this._format = opts.format || rgb.format;\n            this._gradientType = opts.gradientType;\n\n            // Don't let the range of [0,255] come back in [0,1].\n            // Potentially lose a little bit of precision here, but will fix issues where\n            // .5 gets interpreted as half of the total, instead of half of 1\n            // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n            if (this._r < 1) { this._r = mathRound(this._r); }\n            if (this._g < 1) { this._g = mathRound(this._g); }\n            if (this._b < 1) { this._b = mathRound(this._b); }\n\n            this._ok = rgb.ok;\n            this._tc_id = tinyCounter++;\n        };\n\n        tinycolor.prototype = {\n            isDark: function() {\n                return this.getBrightness() < 128;\n            },\n            isLight: function() {\n                return !this.isDark();\n            },\n            isValid: function() {\n                return this._ok;\n            },\n            getOriginalInput: function() {\n                return this._originalInput;\n            },\n            getFormat: function() {\n                return this._format;\n            },\n            getAlpha: function() {\n                return this._a;\n            },\n            getBrightness: function() {\n                var rgb = this.toRgb();\n                return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n            },\n            setAlpha: function(value) {\n                this._a = boundAlpha(value);\n                this._roundA = mathRound(1000 * this._a) / 1000;\n                return this;\n            },\n            toHsv: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n            },\n            toHsvString: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n                return (this._a == 1) ?\n                    \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                    \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n            },\n            toHsl: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n            },\n            toHslString: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n                return (this._a == 1) ?\n                    \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                    \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n            },\n            toHex: function(allow3Char) {\n                return rgbToHex(this._r, this._g, this._b, allow3Char);\n            },\n            toHexString: function(allow3Char) {\n                return '#' + this.toHex(allow3Char);\n            },\n            toHex8: function() {\n                return rgbaToHex(this._r, this._g, this._b, this._a);\n            },\n            toHex8String: function() {\n                return '#' + this.toHex8();\n            },\n            toRgb: function() {\n                return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n            },\n            toRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                    \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n            },\n            toPercentageRgb: function() {\n                return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n            },\n            toPercentageRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                    \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n            },\n            toName: function() {\n                if (this._a === 0) {\n                    return \"transparent\";\n                }\n\n                if (this._a < 1) {\n                    return false;\n                }\n\n                return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n            },\n            toFilter: function(secondColor) {\n                var hex8String = '#' + rgbaToHex(this._r, this._g, this._b, this._a);\n                var secondHex8String = hex8String;\n                var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n                if (secondColor) {\n                    var s = tinycolor(secondColor);\n                    secondHex8String = s.toHex8String();\n                }\n\n                return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n            },\n            toString: function(format) {\n                var formatSet = !!format;\n                format = format || this._format;\n\n                var formattedString = false;\n                var hasAlpha = this._a < 1 && this._a >= 0;\n                var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"name\");\n\n                if (needsAlphaFormat) {\n                    // Special case for \"transparent\", all other non-alpha formats\n                    // will return rgba when there is transparency.\n                    if (format === \"name\" && this._a === 0) {\n                        return this.toName();\n                    }\n                    return this.toRgbString();\n                }\n                if (format === \"rgb\") {\n                    formattedString = this.toRgbString();\n                }\n                if (format === \"prgb\") {\n                    formattedString = this.toPercentageRgbString();\n                }\n                if (format === \"hex\" || format === \"hex6\") {\n                    formattedString = this.toHexString();\n                }\n                if (format === \"hex3\") {\n                    formattedString = this.toHexString(true);\n                }\n                if (format === \"hex8\") {\n                    formattedString = this.toHex8String();\n                }\n                if (format === \"name\") {\n                    formattedString = this.toName();\n                }\n                if (format === \"hsl\") {\n                    formattedString = this.toHslString();\n                }\n                if (format === \"hsv\") {\n                    formattedString = this.toHsvString();\n                }\n\n                return formattedString || this.toHexString();\n            },\n\n            _applyModification: function(fn, args) {\n                var color = fn.apply(null, [this].concat([].slice.call(args)));\n                this._r = color._r;\n                this._g = color._g;\n                this._b = color._b;\n                this.setAlpha(color._a);\n                return this;\n            },\n            lighten: function() {\n                return this._applyModification(lighten, arguments);\n            },\n            brighten: function() {\n                return this._applyModification(brighten, arguments);\n            },\n            darken: function() {\n                return this._applyModification(darken, arguments);\n            },\n            desaturate: function() {\n                return this._applyModification(desaturate, arguments);\n            },\n            saturate: function() {\n                return this._applyModification(saturate, arguments);\n            },\n            greyscale: function() {\n                return this._applyModification(greyscale, arguments);\n            },\n            spin: function() {\n                return this._applyModification(spin, arguments);\n            },\n\n            _applyCombination: function(fn, args) {\n                return fn.apply(null, [this].concat([].slice.call(args)));\n            },\n            analogous: function() {\n                return this._applyCombination(analogous, arguments);\n            },\n            complement: function() {\n                return this._applyCombination(complement, arguments);\n            },\n            monochromatic: function() {\n                return this._applyCombination(monochromatic, arguments);\n            },\n            splitcomplement: function() {\n                return this._applyCombination(splitcomplement, arguments);\n            },\n            triad: function() {\n                return this._applyCombination(triad, arguments);\n            },\n            tetrad: function() {\n                return this._applyCombination(tetrad, arguments);\n            }\n        };\n\n        // If input is an object, force 1 into \"1.0\" to handle ratios properly\n        // String input requires \"1.0\" as input, so 1 will be treated as 1\n        tinycolor.fromRatio = function(color, opts) {\n            if (typeof color == \"object\") {\n                var newColor = {};\n                for (var i in color) {\n                    if (color.hasOwnProperty(i)) {\n                        if (i === \"a\") {\n                            newColor[i] = color[i];\n                        }\n                        else {\n                            newColor[i] = convertToPercentage(color[i]);\n                        }\n                    }\n                }\n                color = newColor;\n            }\n\n            return tinycolor(color, opts);\n        };\n\n        // Given a string or object, convert that input to RGB\n        // Possible string inputs:\n        //\n        //     \"red\"\n        //     \"#f00\" or \"f00\"\n        //     \"#ff0000\" or \"ff0000\"\n        //     \"#ff000000\" or \"ff000000\"\n        //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n        //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n        //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n        //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n        //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n        //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n        //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n        //\n        function inputToRGB(color) {\n\n            var rgb = { r: 0, g: 0, b: 0 };\n            var a = 1;\n            var ok = false;\n            var format = false;\n\n            if (typeof color == \"string\") {\n                color = stringInputToObject(color);\n            }\n\n            if (typeof color == \"object\") {\n                if (color.hasOwnProperty(\"r\") && color.hasOwnProperty(\"g\") && color.hasOwnProperty(\"b\")) {\n                    rgb = rgbToRgb(color.r, color.g, color.b);\n                    ok = true;\n                    format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"v\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.v = convertToPercentage(color.v);\n                    rgb = hsvToRgb(color.h, color.s, color.v);\n                    ok = true;\n                    format = \"hsv\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"l\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.l = convertToPercentage(color.l);\n                    rgb = hslToRgb(color.h, color.s, color.l);\n                    ok = true;\n                    format = \"hsl\";\n                }\n\n                if (color.hasOwnProperty(\"a\")) {\n                    a = color.a;\n                }\n            }\n\n            a = boundAlpha(a);\n\n            return {\n                ok: ok,\n                format: color.format || format,\n                r: mathMin(255, mathMax(rgb.r, 0)),\n                g: mathMin(255, mathMax(rgb.g, 0)),\n                b: mathMin(255, mathMax(rgb.b, 0)),\n                a: a\n            };\n        }\n\n\n        // Conversion Functions\n        // --------------------\n\n        // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n        // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n        // `rgbToRgb`\n        // Handle bounds / percentage checking to conform to CSS color spec\n        // <http://www.w3.org/TR/css3-color/>\n        // *Assumes:* r, g, b in [0, 255] or [0, 1]\n        // *Returns:* { r, g, b } in [0, 255]\n        function rgbToRgb(r, g, b){\n            return {\n                r: bound01(r, 255) * 255,\n                g: bound01(g, 255) * 255,\n                b: bound01(b, 255) * 255\n            };\n        }\n\n        // `rgbToHsl`\n        // Converts an RGB color value to HSL.\n        // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n        // *Returns:* { h, s, l } in [0,1]\n        function rgbToHsl(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, l = (max + min) / 2;\n\n            if(max == min) {\n                h = s = 0; // achromatic\n            }\n            else {\n                var d = max - min;\n                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n\n                h /= 6;\n            }\n\n            return { h: h, s: s, l: l };\n        }\n\n        // `hslToRgb`\n        // Converts an HSL color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hslToRgb(h, s, l) {\n            var r, g, b;\n\n            h = bound01(h, 360);\n            s = bound01(s, 100);\n            l = bound01(l, 100);\n\n            function hue2rgb(p, q, t) {\n                if(t < 0) t += 1;\n                if(t > 1) t -= 1;\n                if(t < 1/6) return p + (q - p) * 6 * t;\n                if(t < 1/2) return q;\n                if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n                return p;\n            }\n\n            if(s === 0) {\n                r = g = b = l; // achromatic\n            }\n            else {\n                var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n                var p = 2 * l - q;\n                r = hue2rgb(p, q, h + 1/3);\n                g = hue2rgb(p, q, h);\n                b = hue2rgb(p, q, h - 1/3);\n            }\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHsv`\n        // Converts an RGB color value to HSV\n        // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n        // *Returns:* { h, s, v } in [0,1]\n        function rgbToHsv(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, v = max;\n\n            var d = max - min;\n            s = max === 0 ? 0 : d / max;\n\n            if(max == min) {\n                h = 0; // achromatic\n            }\n            else {\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n                h /= 6;\n            }\n            return { h: h, s: s, v: v };\n        }\n\n        // `hsvToRgb`\n        // Converts an HSV color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hsvToRgb(h, s, v) {\n\n            h = bound01(h, 360) * 6;\n            s = bound01(s, 100);\n            v = bound01(v, 100);\n\n            var i = math.floor(h),\n                f = h - i,\n                p = v * (1 - s),\n                q = v * (1 - f * s),\n                t = v * (1 - (1 - f) * s),\n                mod = i % 6,\n                r = [v, q, p, p, t, v][mod],\n                g = [t, v, v, q, p, p][mod],\n                b = [p, p, t, v, v, q][mod];\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHex`\n        // Converts an RGB color to hex\n        // Assumes r, g, and b are contained in the set [0, 255]\n        // Returns a 3 or 6 character hex\n        function rgbToHex(r, g, b, allow3Char) {\n\n            var hex = [\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            // Return a 3 character hex if possible\n            if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n                return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n            }\n\n            return hex.join(\"\");\n        }\n        // `rgbaToHex`\n        // Converts an RGBA color plus alpha transparency to hex\n        // Assumes r, g, b and a are contained in the set [0, 255]\n        // Returns an 8 character hex\n        function rgbaToHex(r, g, b, a) {\n\n            var hex = [\n                pad2(convertDecimalToHex(a)),\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            return hex.join(\"\");\n        }\n\n        // `equals`\n        // Can be called with any tinycolor input\n        tinycolor.equals = function (color1, color2) {\n            if (!color1 || !color2) { return false; }\n            return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n        };\n        tinycolor.random = function() {\n            return tinycolor.fromRatio({\n                r: mathRandom(),\n                g: mathRandom(),\n                b: mathRandom()\n            });\n        };\n\n\n        // Modification Functions\n        // ----------------------\n        // Thanks to less.js for some of the basics here\n        // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n        function desaturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s -= amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function saturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s += amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function greyscale(color) {\n            return tinycolor(color).desaturate(100);\n        }\n\n        function lighten (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l += amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        function brighten(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var rgb = tinycolor(color).toRgb();\n            rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n            rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n            rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n            return tinycolor(rgb);\n        }\n\n        function darken (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l -= amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n        // Values outside of this range will be wrapped into this range.\n        function spin(color, amount) {\n            var hsl = tinycolor(color).toHsl();\n            var hue = (mathRound(hsl.h) + amount) % 360;\n            hsl.h = hue < 0 ? 360 + hue : hue;\n            return tinycolor(hsl);\n        }\n\n        // Combination Functions\n        // ---------------------\n        // Thanks to jQuery xColor for some of the ideas behind these\n        // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n        function complement(color) {\n            var hsl = tinycolor(color).toHsl();\n            hsl.h = (hsl.h + 180) % 360;\n            return tinycolor(hsl);\n        }\n\n        function triad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function tetrad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function splitcomplement(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n                tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n            ];\n        }\n\n        function analogous(color, results, slices) {\n            results = results || 6;\n            slices = slices || 30;\n\n            var hsl = tinycolor(color).toHsl();\n            var part = 360 / slices;\n            var ret = [tinycolor(color)];\n\n            for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n                hsl.h = (hsl.h + part) % 360;\n                ret.push(tinycolor(hsl));\n            }\n            return ret;\n        }\n\n        function monochromatic(color, results) {\n            results = results || 6;\n            var hsv = tinycolor(color).toHsv();\n            var h = hsv.h, s = hsv.s, v = hsv.v;\n            var ret = [];\n            var modification = 1 / results;\n\n            while (results--) {\n                ret.push(tinycolor({ h: h, s: s, v: v}));\n                v = (v + modification) % 1;\n            }\n\n            return ret;\n        }\n\n        // Utility Functions\n        // ---------------------\n\n        tinycolor.mix = function(color1, color2, amount) {\n            amount = (amount === 0) ? 0 : (amount || 50);\n\n            var rgb1 = tinycolor(color1).toRgb();\n            var rgb2 = tinycolor(color2).toRgb();\n\n            var p = amount / 100;\n            var w = p * 2 - 1;\n            var a = rgb2.a - rgb1.a;\n\n            var w1;\n\n            if (w * a == -1) {\n                w1 = w;\n            } else {\n                w1 = (w + a) / (1 + w * a);\n            }\n\n            w1 = (w1 + 1) / 2;\n\n            var w2 = 1 - w1;\n\n            var rgba = {\n                r: rgb2.r * w1 + rgb1.r * w2,\n                g: rgb2.g * w1 + rgb1.g * w2,\n                b: rgb2.b * w1 + rgb1.b * w2,\n                a: rgb2.a * p  + rgb1.a * (1 - p)\n            };\n\n            return tinycolor(rgba);\n        };\n\n\n        // Readability Functions\n        // ---------------------\n        // <http://www.w3.org/TR/AERT#color-contrast>\n\n        // `readability`\n        // Analyze the 2 colors and returns an object with the following properties:\n        //    `brightness`: difference in brightness between the two colors\n        //    `color`: difference in color/hue between the two colors\n        tinycolor.readability = function(color1, color2) {\n            var c1 = tinycolor(color1);\n            var c2 = tinycolor(color2);\n            var rgb1 = c1.toRgb();\n            var rgb2 = c2.toRgb();\n            var brightnessA = c1.getBrightness();\n            var brightnessB = c2.getBrightness();\n            var colorDiff = (\n                Math.max(rgb1.r, rgb2.r) - Math.min(rgb1.r, rgb2.r) +\n                Math.max(rgb1.g, rgb2.g) - Math.min(rgb1.g, rgb2.g) +\n                Math.max(rgb1.b, rgb2.b) - Math.min(rgb1.b, rgb2.b)\n            );\n\n            return {\n                brightness: Math.abs(brightnessA - brightnessB),\n                color: colorDiff\n            };\n        };\n\n        // `readable`\n        // http://www.w3.org/TR/AERT#color-contrast\n        // Ensure that foreground and background color combinations provide sufficient contrast.\n        // *Example*\n        //    tinycolor.isReadable(\"#000\", \"#111\") => false\n        tinycolor.isReadable = function(color1, color2) {\n            var readability = tinycolor.readability(color1, color2);\n            return readability.brightness > 125 && readability.color > 500;\n        };\n\n        // `mostReadable`\n        // Given a base color and a list of possible foreground or background\n        // colors for that base, returns the most readable color.\n        // *Example*\n        //    tinycolor.mostReadable(\"#123\", [\"#fff\", \"#000\"]) => \"#000\"\n        tinycolor.mostReadable = function(baseColor, colorList) {\n            var bestColor = null;\n            var bestScore = 0;\n            var bestIsReadable = false;\n            for (var i=0; i < colorList.length; i++) {\n\n                // We normalize both around the \"acceptable\" breaking point,\n                // but rank brightness constrast higher than hue.\n\n                var readability = tinycolor.readability(baseColor, colorList[i]);\n                var readable = readability.brightness > 125 && readability.color > 500;\n                var score = 3 * (readability.brightness / 125) + (readability.color / 500);\n\n                if ((readable && ! bestIsReadable) ||\n                    (readable && bestIsReadable && score > bestScore) ||\n                    ((! readable) && (! bestIsReadable) && score > bestScore)) {\n                    bestIsReadable = readable;\n                    bestScore = score;\n                    bestColor = tinycolor(colorList[i]);\n                }\n            }\n            return bestColor;\n        };\n\n\n        // Big List of Colors\n        // ------------------\n        // <http://www.w3.org/TR/css3-color/#svg-color>\n        var names = tinycolor.names = {\n            aliceblue: \"f0f8ff\",\n            antiquewhite: \"faebd7\",\n            aqua: \"0ff\",\n            aquamarine: \"7fffd4\",\n            azure: \"f0ffff\",\n            beige: \"f5f5dc\",\n            bisque: \"ffe4c4\",\n            black: \"000\",\n            blanchedalmond: \"ffebcd\",\n            blue: \"00f\",\n            blueviolet: \"8a2be2\",\n            brown: \"a52a2a\",\n            burlywood: \"deb887\",\n            burntsienna: \"ea7e5d\",\n            cadetblue: \"5f9ea0\",\n            chartreuse: \"7fff00\",\n            chocolate: \"d2691e\",\n            coral: \"ff7f50\",\n            cornflowerblue: \"6495ed\",\n            cornsilk: \"fff8dc\",\n            crimson: \"dc143c\",\n            cyan: \"0ff\",\n            darkblue: \"00008b\",\n            darkcyan: \"008b8b\",\n            darkgoldenrod: \"b8860b\",\n            darkgray: \"a9a9a9\",\n            darkgreen: \"006400\",\n            darkgrey: \"a9a9a9\",\n            darkkhaki: \"bdb76b\",\n            darkmagenta: \"8b008b\",\n            darkolivegreen: \"556b2f\",\n            darkorange: \"ff8c00\",\n            darkorchid: \"9932cc\",\n            darkred: \"8b0000\",\n            darksalmon: \"e9967a\",\n            darkseagreen: \"8fbc8f\",\n            darkslateblue: \"483d8b\",\n            darkslategray: \"2f4f4f\",\n            darkslategrey: \"2f4f4f\",\n            darkturquoise: \"00ced1\",\n            darkviolet: \"9400d3\",\n            deeppink: \"ff1493\",\n            deepskyblue: \"00bfff\",\n            dimgray: \"696969\",\n            dimgrey: \"696969\",\n            dodgerblue: \"1e90ff\",\n            firebrick: \"b22222\",\n            floralwhite: \"fffaf0\",\n            forestgreen: \"228b22\",\n            fuchsia: \"f0f\",\n            gainsboro: \"dcdcdc\",\n            ghostwhite: \"f8f8ff\",\n            gold: \"ffd700\",\n            goldenrod: \"daa520\",\n            gray: \"808080\",\n            green: \"008000\",\n            greenyellow: \"adff2f\",\n            grey: \"808080\",\n            honeydew: \"f0fff0\",\n            hotpink: \"ff69b4\",\n            indianred: \"cd5c5c\",\n            indigo: \"4b0082\",\n            ivory: \"fffff0\",\n            khaki: \"f0e68c\",\n            lavender: \"e6e6fa\",\n            lavenderblush: \"fff0f5\",\n            lawngreen: \"7cfc00\",\n            lemonchiffon: \"fffacd\",\n            lightblue: \"add8e6\",\n            lightcoral: \"f08080\",\n            lightcyan: \"e0ffff\",\n            lightgoldenrodyellow: \"fafad2\",\n            lightgray: \"d3d3d3\",\n            lightgreen: \"90ee90\",\n            lightgrey: \"d3d3d3\",\n            lightpink: \"ffb6c1\",\n            lightsalmon: \"ffa07a\",\n            lightseagreen: \"20b2aa\",\n            lightskyblue: \"87cefa\",\n            lightslategray: \"789\",\n            lightslategrey: \"789\",\n            lightsteelblue: \"b0c4de\",\n            lightyellow: \"ffffe0\",\n            lime: \"0f0\",\n            limegreen: \"32cd32\",\n            linen: \"faf0e6\",\n            magenta: \"f0f\",\n            maroon: \"800000\",\n            mediumaquamarine: \"66cdaa\",\n            mediumblue: \"0000cd\",\n            mediumorchid: \"ba55d3\",\n            mediumpurple: \"9370db\",\n            mediumseagreen: \"3cb371\",\n            mediumslateblue: \"7b68ee\",\n            mediumspringgreen: \"00fa9a\",\n            mediumturquoise: \"48d1cc\",\n            mediumvioletred: \"c71585\",\n            midnightblue: \"191970\",\n            mintcream: \"f5fffa\",\n            mistyrose: \"ffe4e1\",\n            moccasin: \"ffe4b5\",\n            navajowhite: \"ffdead\",\n            navy: \"000080\",\n            oldlace: \"fdf5e6\",\n            olive: \"808000\",\n            olivedrab: \"6b8e23\",\n            orange: \"ffa500\",\n            orangered: \"ff4500\",\n            orchid: \"da70d6\",\n            palegoldenrod: \"eee8aa\",\n            palegreen: \"98fb98\",\n            paleturquoise: \"afeeee\",\n            palevioletred: \"db7093\",\n            papayawhip: \"ffefd5\",\n            peachpuff: \"ffdab9\",\n            peru: \"cd853f\",\n            pink: \"ffc0cb\",\n            plum: \"dda0dd\",\n            powderblue: \"b0e0e6\",\n            purple: \"800080\",\n            rebeccapurple: \"663399\",\n            red: \"f00\",\n            rosybrown: \"bc8f8f\",\n            royalblue: \"4169e1\",\n            saddlebrown: \"8b4513\",\n            salmon: \"fa8072\",\n            sandybrown: \"f4a460\",\n            seagreen: \"2e8b57\",\n            seashell: \"fff5ee\",\n            sienna: \"a0522d\",\n            silver: \"c0c0c0\",\n            skyblue: \"87ceeb\",\n            slateblue: \"6a5acd\",\n            slategray: \"708090\",\n            slategrey: \"708090\",\n            snow: \"fffafa\",\n            springgreen: \"00ff7f\",\n            steelblue: \"4682b4\",\n            tan: \"d2b48c\",\n            teal: \"008080\",\n            thistle: \"d8bfd8\",\n            tomato: \"ff6347\",\n            turquoise: \"40e0d0\",\n            violet: \"ee82ee\",\n            wheat: \"f5deb3\",\n            white: \"fff\",\n            whitesmoke: \"f5f5f5\",\n            yellow: \"ff0\",\n            yellowgreen: \"9acd32\"\n        };\n\n        // Make it easy to access colors via `hexNames[hex]`\n        var hexNames = tinycolor.hexNames = flip(names);\n\n\n        // Utilities\n        // ---------\n\n        // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n        function flip(o) {\n            var flipped = { };\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    flipped[o[i]] = i;\n                }\n            }\n            return flipped;\n        }\n\n        // Return a valid alpha value [0,1] with all invalid values being set to 1\n        function boundAlpha(a) {\n            a = parseFloat(a);\n\n            if (isNaN(a) || a < 0 || a > 1) {\n                a = 1;\n            }\n\n            return a;\n        }\n\n        // Take input from [0, n] and return it as [0, 1]\n        function bound01(n, max) {\n            if (isOnePointZero(n)) { n = \"100%\"; }\n\n            var processPercent = isPercentage(n);\n            n = mathMin(max, mathMax(0, parseFloat(n)));\n\n            // Automatically convert percentage into number\n            if (processPercent) {\n                n = parseInt(n * max, 10) / 100;\n            }\n\n            // Handle floating point rounding errors\n            if ((math.abs(n - max) < 0.000001)) {\n                return 1;\n            }\n\n            // Convert into [0, 1] range if it isn't already\n            return (n % max) / parseFloat(max);\n        }\n\n        // Force a number between 0 and 1\n        function clamp01(val) {\n            return mathMin(1, mathMax(0, val));\n        }\n\n        // Parse a base-16 hex value into a base-10 integer\n        function parseIntFromHex(val) {\n            return parseInt(val, 16);\n        }\n\n        // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n        // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n        function isOnePointZero(n) {\n            return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n        }\n\n        // Check to see if string passed in is a percentage\n        function isPercentage(n) {\n            return typeof n === \"string\" && n.indexOf('%') != -1;\n        }\n\n        // Force a hex value to have 2 characters\n        function pad2(c) {\n            return c.length == 1 ? '0' + c : '' + c;\n        }\n\n        // Replace a decimal with it's percentage value\n        function convertToPercentage(n) {\n            if (n <= 1) {\n                n = (n * 100) + \"%\";\n            }\n\n            return n;\n        }\n\n        // Converts a decimal to a hex value\n        function convertDecimalToHex(d) {\n            return Math.round(parseFloat(d) * 255).toString(16);\n        }\n        // Converts a hex value to a decimal\n        function convertHexToDecimal(h) {\n            return (parseIntFromHex(h) / 255);\n        }\n\n        var matchers = (function() {\n\n            // <http://www.w3.org/TR/css3-values/#integers>\n            var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n            // <http://www.w3.org/TR/css3-values/#number-value>\n            var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n            // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n            var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n            // Actual matching.\n            // Parentheses and commas are optional, but not required.\n            // Whitespace can take the place of commas or opening paren\n            var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n            var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n            return {\n                rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n                rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n                hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n                hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n                hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n                hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n                hex3: /^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n                hex6: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n                hex8: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n            };\n        })();\n\n        // `stringInputToObject`\n        // Permissive string parsing.  Take in a number of formats, and output an object\n        // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n        function stringInputToObject(color) {\n\n            color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n            var named = false;\n            if (names[color]) {\n                color = names[color];\n                named = true;\n            }\n            else if (color == 'transparent') {\n                return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n            }\n\n            // Try to match string input using regular expressions.\n            // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n            // Just return an object and let the conversion functions handle that.\n            // This way the result will be the same whether the tinycolor is initialized with string or object.\n            var match;\n            if ((match = matchers.rgb.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3] };\n            }\n            if ((match = matchers.rgba.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsl.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3] };\n            }\n            if ((match = matchers.hsla.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsv.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3] };\n            }\n            if ((match = matchers.hsva.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3], a: match[4] };\n            }\n            if ((match = matchers.hex8.exec(color))) {\n                return {\n                    a: convertHexToDecimal(match[1]),\n                    r: parseIntFromHex(match[2]),\n                    g: parseIntFromHex(match[3]),\n                    b: parseIntFromHex(match[4]),\n                    format: named ? \"name\" : \"hex8\"\n                };\n            }\n            if ((match = matchers.hex6.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1]),\n                    g: parseIntFromHex(match[2]),\n                    b: parseIntFromHex(match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n            if ((match = matchers.hex3.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1] + '' + match[1]),\n                    g: parseIntFromHex(match[2] + '' + match[2]),\n                    b: parseIntFromHex(match[3] + '' + match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n\n            return false;\n        }\n\n        window.tinycolor = tinycolor;\n    })();\n\n    $(function () {\n        if ($.fn.spectrum.load) {\n            $.fn.spectrum.processNativeColorInputs();\n        }\n    });\n\n});\n","Magento_Payment/js/transparent.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n/* @api */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Payment/js/model/credit-card-validation/validator'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.transparent', {\n        options: {\n            editFormSelector: '#edit_form',\n            hiddenFormTmpl:\n                '<form target=\"<%= data.target %>\" action=\"<%= data.action %>\"' +\n                'method=\"POST\" hidden' +\n                'enctype=\"application/x-www-form-urlencoded\" class=\"no-display\">' +\n                    '<% _.each(data.inputs, function(val, key){ %>' +\n                    '<input value=\"<%= val %>\" name=\"<%= key %>\" type=\"hidden\">' +\n                    '<% }); %>' +\n                '</form>',\n            cgiUrl: null,\n            orderSaveUrl: null,\n            controller: null,\n            gateway: null,\n            dateDelim: null,\n            cardFieldsMap: null,\n            expireYearLength: 2\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.hiddenFormTmpl = mageTemplate(this.options.hiddenFormTmpl);\n\n            $(this.options.editFormSelector).on('changePaymentMethod', this._setPlaceOrderHandler.bind(this));\n            $(this.options.editFormSelector).trigger('changePaymentMethod', [\n                $(this.options.editFormSelector).find(':radio[name=\"payment[method]\"]:checked').val()\n            ]);\n        },\n\n        /**\n         * Handler for form submit.\n         *\n         * @param {Object} event\n         * @param {String} method\n         */\n        _setPlaceOrderHandler: function (event, method) {\n            var $editForm = $(this.options.editFormSelector);\n\n            $editForm.off('beforeSubmitOrder.' + this.options.gateway);\n\n            if (method === this.options.gateway) {\n                $editForm.on('beforeSubmitOrder.' +  this.options.gateway, this._placeOrderHandler.bind(this));\n            }\n        },\n\n        /**\n         * Handler for form submit to call gateway for credit card validation.\n         *\n         * @param {Event} event\n         * @return {Boolean}\n         * @private\n         */\n        _placeOrderHandler: function (event) {\n            if ($(this.options.editFormSelector).valid()) {\n                this._orderSave();\n            } else {\n                $('body').trigger('processStop');\n            }\n            event.stopImmediatePropagation();\n\n            return false;\n        },\n\n        /**\n         * Handler for Place Order button to call gateway for credit card validation.\n         * Save order and generate post data for gateway call.\n         *\n         * @private\n         */\n        _orderSave: function () {\n            var postData = {\n                'form_key': FORM_KEY,\n                'cc_type': this.ccType()\n            };\n\n            $.ajax({\n                url: this.options.orderSaveUrl,\n                type: 'post',\n                context: this,\n                data: postData,\n                dataType: 'json',\n\n                /**\n                 * Success callback\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    if (response.success && response[this.options.gateway]) {\n                        this._postPaymentToGateway(response);\n                    } else {\n                        this._processErrors(response);\n                    }\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n        },\n\n        /**\n         * Post data to gateway for credit card validation.\n         *\n         * @param {Object} response\n         * @private\n         */\n        _postPaymentToGateway: function (response) {\n            var $iframeSelector = $('[data-container=\"' + this.options.gateway + '-transparent-iframe\"]'),\n                data,\n                tmpl,\n                iframe;\n\n            data = this._preparePaymentData(response);\n            tmpl = this.hiddenFormTmpl({\n                data: {\n                    target: $iframeSelector.attr('name'),\n                    action: this.options.cgiUrl,\n                    inputs: data\n                }\n            });\n\n            iframe = $iframeSelector\n                .on('submit', function (event) {\n                    event.stopPropagation();\n                });\n            $(tmpl).appendTo(iframe).trigger('submit');\n            iframe.html('');\n        },\n\n        /**\n         * @returns {String}\n         */\n        ccType: function () {\n            return this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-type\"]'\n            ).val();\n        },\n\n        /**\n         * Add credit card fields to post data for gateway.\n         *\n         * @param {Object} response\n         * @private\n         */\n        _preparePaymentData: function (response) {\n            var ccfields,\n                data,\n                preparedata;\n\n            data = response[this.options.gateway].fields;\n            ccfields = this.options.cardFieldsMap;\n\n            if (this.element.find('[data-container=\"' + this.options.gateway + '-cc-cvv\"]').length) {\n                data[ccfields.cccvv] = this.element.find(\n                    '[data-container=\"' + this.options.gateway + '-cc-cvv\"]'\n                ).val();\n            }\n            preparedata = this._prepareExpDate();\n            data[ccfields.ccexpdate] = preparedata.month + this.options.dateDelim + preparedata.year;\n            data[ccfields.ccnum] = this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-number\"]'\n            ).val();\n\n            return data;\n        },\n\n        /**\n         * Grab Month and Year into one\n         * @returns {Object}\n         * @private\n         */\n        _prepareExpDate: function () {\n            var year = this.element.find('[data-container=\"' + this.options.gateway + '-cc-year\"]').val(),\n                month = parseInt(\n                    this.element.find('[data-container=\"' + this.options.gateway + '-cc-month\"]').val(), 10\n                );\n\n            if (year.length > this.options.expireYearLength) {\n                year = year.substring(year.length - this.options.expireYearLength);\n            }\n\n            if (month < 10) {\n                month = '0' + month;\n            }\n\n            return {\n                month: month, year: year\n            };\n        },\n\n        /**\n         * Processing errors\n         *\n         * @param {Object} response\n         * @private\n         */\n        _processErrors: function (response) {\n            var msg = response['error_messages'];\n\n            if (typeof msg === 'object') {\n                alert({\n                    content: msg.join('\\n')\n                });\n            }\n\n            if (msg) {\n                alert({\n                    content: msg\n                });\n            }\n        }\n    });\n\n    return $.mage.transparent;\n});\n","Magento_Payment/js/model/credit-card-validation/cvv-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    /**\n     * CVV number validation.\n     * Validate digit count for CVV code.\n     *\n     * @param {*} value\n     * @param {Number} maxLength\n     * @return {Object}\n     */\n    return function (value, maxLength) {\n        var DEFAULT_LENGTH = 3;\n\n        maxLength = maxLength || DEFAULT_LENGTH;\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (value.length === maxLength) {\n            return resultWrapper(true, true);\n        }\n\n        if (value.length < maxLength) {\n            return resultWrapper(false, true);\n        }\n\n        if (value.length > maxLength) {\n            return resultWrapper(false, false);\n        }\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'Magento_Payment/js/model/credit-card-validation/cvv-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n    'mage/translate'\n], function ($, cvvValidator, creditCardNumberValidator, yearValidator, monthValidator, creditCardData) {\n    'use strict';\n\n    $('.payment-method-content input[type=\"number\"]').on('keyup', function () {\n        if ($(this).val() < 0) {\n            $(this).val($(this).val().replace(/^-/, ''));\n        }\n    });\n\n    $.each({\n        'validate-card-type': [\n            function (number, item, allowedTypes) {\n                var cardInfo,\n                    i,\n                    l;\n\n                if (!creditCardNumberValidator(number).isValid) {\n                    return false;\n                }\n\n                cardInfo = creditCardNumberValidator(number).card;\n\n                for (i = 0, l = allowedTypes.length; i < l; i++) {\n                    if (cardInfo.title == allowedTypes[i].type) { //eslint-disable-line eqeqeq\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card type number.')\n        ],\n        'validate-card-number': [\n\n            /**\n             * Validate credit card number based on mod 10\n             *\n             * @param {*} number - credit card number\n             * @return {Boolean}\n             */\n            function (number) {\n                return creditCardNumberValidator(number).isValid;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-card-date': [\n\n            /**\n             * Validate credit card expiration month\n             *\n             * @param {String} date - month\n             * @return {Boolean}\n             */\n            function (date) {\n                return monthValidator(date).isValid;\n            },\n            $.mage.__('Incorrect credit card expiration month.')\n        ],\n        'validate-card-cvv': [\n\n            /**\n             * Validate cvv\n             *\n             * @param {String} cvv - card verification value\n             * @return {Boolean}\n             */\n            function (cvv) {\n                var maxLength = creditCardData.creditCard ? creditCardData.creditCard.code.size : 3;\n\n                return cvvValidator(cvv, maxLength).isValid;\n            },\n            $.mage.__('Please enter a valid credit card verification number.')\n        ],\n        'validate-card-year': [\n\n            /**\n             * Validate credit card expiration year\n             *\n             * @param {String} date - year\n             * @return {Boolean}\n             */\n            function (date) {\n                return yearValidator(date).isValid;\n            },\n            $.mage.__('Incorrect credit card expiration year.')\n        ]\n\n    }, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([], function () {\n    'use strict';\n\n    return {\n        creditCard: null,\n        creditCardNumber: null,\n        expirationMonth: null,\n        expirationYear: null,\n        cvvCode: null\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'mageUtils',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator'\n], function (utils, parseDate, expirationMonth, expirationYear) {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @param {*} month\n     * @param {*} year\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid, month, year) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid,\n            month: month,\n            year: year\n        };\n    }\n\n    return function (value) {\n        var date,\n            monthValid,\n            yearValid;\n\n        if (utils.isEmpty(value)) {\n            return resultWrapper(false, false, null, null);\n        }\n\n        value = value.replace(/^(\\d\\d) (\\d\\d(\\d\\d)?)$/, '$1/$2');\n        date = parseDate(value);\n        monthValid = expirationMonth(date.month);\n        yearValid = expirationYear(date.year);\n\n        if (monthValid.isValid && yearValid.isValid) {\n            return resultWrapper(true, true, date.month, date.year);\n        }\n\n        if (monthValid.isPotentiallyValid && yearValid.isPotentiallyValid) {\n            return resultWrapper(false, true, null, null);\n        }\n\n        return resultWrapper(false, false, null, null);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'mageUtils',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type'\n], function (utils, luhn10, creditCardTypes) {\n    'use strict';\n\n    /**\n     * @param {*} card\n     * @param {*} isPotentiallyValid\n     * @param {*} isValid\n     * @return {Object}\n     */\n    function resultWrapper(card, isPotentiallyValid, isValid) {\n        return {\n            card: card,\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var potentialTypes,\n            cardType,\n            valid,\n            i,\n            maxLength;\n\n        if (utils.isEmpty(value)) {\n            return resultWrapper(null, false, false);\n        }\n\n        value = value.replace(/\\s+/g, '');\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(null, false, false);\n        }\n\n        potentialTypes = creditCardTypes.getCardTypes(value);\n\n        if (potentialTypes.length === 0) {\n            return resultWrapper(null, false, false);\n        } else if (potentialTypes.length !== 1) {\n            return resultWrapper(null, true, false);\n        }\n\n        cardType = potentialTypes[0];\n\n        if (cardType.type === 'unionpay') {  // UnionPay is not Luhn 10 compliant\n            valid = true;\n        } else {\n            valid = luhn10(value);\n        }\n\n        for (i = 0; i < cardType.lengths.length; i++) {\n            if (cardType.lengths[i] === value.length) {\n                return resultWrapper(cardType, valid, valid);\n            }\n        }\n\n        maxLength = Math.max.apply(null, cardType.lengths);\n\n        if (value.length < maxLength) {\n            return resultWrapper(cardType, true, false);\n        }\n\n        return resultWrapper(cardType, false, false);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Luhn algorithm verification\n     */\n    return function (a, b, c, d, e) {\n        for (d = +a[b = a.length - 1], e = 0; b--;) {\n            c = +a[b];\n            d += ++e % 2 ? 2 * c % 10 + (c > 4) : c;\n        }\n\n        return !(d % 10);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'mageUtils'\n], function ($, utils) {\n    'use strict';\n\n    var types = [\n        {\n            title: 'Visa',\n            type: 'VI',\n            pattern: '^4\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'MasterCard',\n            type: 'MC',\n            pattern: '^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'American Express',\n            type: 'AE',\n            pattern: '^3([47]\\\\d*)?$',\n            isAmex: true,\n            gaps: [4, 10],\n            lengths: [15],\n            code: {\n                name: 'CID',\n                size: 4\n            }\n        },\n        {\n            title: 'Diners',\n            type: 'DN',\n            pattern: '^(3(0[0-5]|095|6|[8-9]))\\\\d*$',\n            gaps: [4, 10],\n            lengths: [14, 16, 17, 18, 19],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'Discover',\n            type: 'DI',\n            pattern: '^(6011(0|[2-4]|74|7[7-9]|8[6-9]|9)|6(4[4-9]|5))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CID',\n                size: 3\n            }\n        },\n        {\n            title: 'JCB',\n            type: 'JCB',\n            pattern: '^35(2[8-9]|[3-8])\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'UnionPay',\n            type: 'UN',\n            pattern: '^(622(1(2[6-9]|[3-9])|[3-8]|9([[0-1]|2[0-5]))|62[4-6]|628([2-8]))\\\\d*?$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CVN',\n                size: 3\n            }\n        },\n        {\n            title: 'Maestro International',\n            type: 'MI',\n            pattern: '^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Maestro Domestic',\n            type: 'MD',\n            pattern: '^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Hipercard',\n            type: 'HC',\n            pattern: '^((606282)|(637095)|(637568)|(637599)|(637609)|(637612))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [13, 16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Elo',\n            type: 'ELO',\n            pattern: '^((509091)|(636368)|(636297)|(504175)|(438935)|(40117[8-9])|(45763[1-2])|' +\n                '(457393)|(431274)|(50990[0-2])|(5099[7-9][0-9])|(50996[4-9])|(509[1-8][0-9][0-9])|' +\n                '(5090(0[0-2]|0[4-9]|1[2-9]|[24589][0-9]|3[1-9]|6[0-46-9]|7[0-24-9]))|' +\n                '(5067(0[0-24-8]|1[0-24-9]|2[014-9]|3[0-379]|4[0-9]|5[0-3]|6[0-5]|7[0-8]))|' +\n                '(6504(0[5-9]|1[0-9]|2[0-9]|3[0-9]))|' +\n                '(6504(8[5-9]|9[0-9])|6505(0[0-9]|1[0-9]|2[0-9]|3[0-8]))|' +\n                '(6505(4[1-9]|5[0-9]|6[0-9]|7[0-9]|8[0-9]|9[0-8]))|' +\n                '(6507(0[0-9]|1[0-8]))|(65072[0-7])|(6509(0[1-9]|1[0-9]|20))|' +\n                '(6516(5[2-9]|6[0-9]|7[0-9]))|(6550(0[0-9]|1[0-9]))|' +\n                '(6550(2[1-9]|3[0-9]|4[0-9]|5[0-8])))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Aura',\n            type: 'AU',\n            pattern: '^5078\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        }\n    ];\n\n    return {\n        /**\n         * @param {*} cardNumber\n         * @return {Array}\n         */\n        getCardTypes: function (cardNumber) {\n            var i, value,\n                result = [];\n\n            if (utils.isEmpty(cardNumber)) {\n                return result;\n            }\n\n            if (cardNumber === '') {\n                return $.extend(true, {}, types);\n            }\n\n            for (i = 0; i < types.length; i++) {\n                value = types[i];\n\n                if (new RegExp(value.pattern).test(cardNumber)) {\n                    result.push($.extend(true, {}, value));\n                }\n            }\n\n            return result;\n        }\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var currentYear = new Date().getFullYear(),\n            len = value.length,\n            valid,\n            expMaxLifetime = 19;\n\n        if (value.replace(/\\s/g, '') === '') {\n            return resultWrapper(false, true);\n        }\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (len !== 4) {\n            return resultWrapper(false, true);\n        }\n\n        value = parseInt(value, 10);\n        valid = value >= currentYear && value <= currentYear + expMaxLifetime;\n\n        return resultWrapper(valid, valid);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function (value) {\n        var month, len;\n\n        if (value.match('/')) {\n            value = value.split(/\\s*\\/\\s*/g);\n\n            return {\n                month: value[0],\n                year: value.slice(1).join()\n            };\n        }\n\n        len = value[0] === '0' || value.length > 5 || value.length === 4 || value.length === 3 ? 2 : 1;\n        month = value.substr(0, len);\n\n        return {\n            month: month,\n            year: value.substr(month.length, 4)\n        };\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var month,\n            monthValid;\n\n        if (value.replace(/\\s/g, '') === '' || value === '0') {\n            return resultWrapper(false, true);\n        }\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (isNaN(value)) {\n            return resultWrapper(false, false);\n        }\n\n        month = parseInt(value, 10);\n        monthValid = month > 0 && month < 13;\n\n        return resultWrapper(monthValid, monthValid);\n    };\n});\n","Magento_InventoryShippingAdminUi/js/form/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'underscore',\n    'mageUtils'\n], function ($, Form, _, utils) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            sourceSelectionUrl: '${ $.sourceSelectionUrl }'\n        },\n\n        /**\n         * Process source selection algorithm\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        processAlgorithm: function (redirect, data) {\n            var formData = utils.filterFormData(this.source.get('data'));\n\n            data.requestData = [];\n\n            _.each(formData.items, function (item) {\n                data.requestData.push({\n                    orderItem: item.orderItemId,\n                    sku: item.sku,\n                    qty: item.qtyToShip\n                });\n            });\n\n            data.orderId = formData['order_id'];\n            data.websiteId = formData.websiteId;\n            data = utils.serialize(utils.filterFormData(data));\n            data['form_key'] = window.FORM_KEY;\n\n            if (!this.sourceSelectionUrl || this.sourceSelectionUrl === 'undefined') {\n                return $.Deferred.resolve();\n            }\n\n            $('body').trigger('processStart');\n\n            $.ajax({\n                url: this.sourceSelectionUrl,\n                data: data,\n\n                /**\n                 * Success callback.\n                 *\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var dataItems = this.source.get('data.items');\n\n                    _.each(dataItems, function (item) {\n                        if (response[item.orderItemId]) {\n                            this.source.set('data.items.' + item['record_id'] + '.sources', response[item.orderItemId]);\n                        }\n                    }.bind(this));\n                    this.source.trigger('reInitSources');\n                    this.source.set('data.sourceCodes', response.sourceCodes ? response.sourceCodes : []);\n                }.bind(this),\n\n                /**\n                 * Complete callback.\n                 */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/form/element/qty_to_deduct.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'mageUtils'\n], function (Abstract, utils) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            sourceCode: null,\n            qtyAvailable: 0\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            var path,\n                qtyToShip,\n                isManageStock;\n\n            this._super();\n\n            //TODO: Is it right way?\n            path = utils.getPart(utils.getPart(this.parentScope, -2), -2);\n            qtyToShip = this.source.get(path + '.qtyToShip');\n            isManageStock = this.source.get(path + '.isManageStock');\n\n            this.validation['less-than-equals-to'] = isManageStock ? this.qtyAvailable : qtyToShip;\n\n            return this;\n        },\n\n        /**\n         * Toggle disabled state.\n         *\n         * @param {String} selected\n         */\n        toggleDisable: function (selected) {\n            this.disabled(selected ? selected.toString() !== this.sourceCode : !selected);\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/form/element/source_code.js":"define([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, select) {\n    'use strict';\n\n    return select.extend({\n        /**\n         * @inheritdoc\n         */\n        setOptions: function (data) {\n            var result = this._super(data);\n\n            if (data.length === 1) {\n                this.value(data[0].value);\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/order/grid/cell/allocated-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryShippingAdminUi/order/grid/cell/allocated-sources-cell.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         *\n         * @param {Array} record\n         * @returns {Array}\n         */\n        getTooltipData: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getAllocatedSources: function (record) {\n            return this.getTooltipData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_PageBuilderAdminAnalytics/js/page-builder/events-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['underscore', 'Magento_PageBuilderAdminAnalytics/js/page-builder/event-builder'],\n    function (_, EventBuilder) {\n        'use strict';\n\n        return function (target) {\n            var originalTarget = target.trigger,\n                isAdminAnalyticsEnabled,\n                event,\n                hasPageBuilderBeenUsed = false,\n                delayedPush;\n\n            /**\n             * Invokes custom code to track information regarding Page Builder usage\n             *\n             * @param {String} name\n             * @param {Array} args\n             */\n\n            target.trigger = function (name, args) {\n                originalTarget.apply(originalTarget, [name, args]);\n                isAdminAnalyticsEnabled =\n                    !_.isUndefined(window.digitalData) &&\n                    !_.isUndefined(window._satellite);\n\n                if (!hasPageBuilderBeenUsed && name.indexOf('stage:fullScreenModeChangeAfter') !== -1 &&\n                    args.fullScreen && isAdminAnalyticsEnabled\n                ) {\n                    hasPageBuilderBeenUsed = true;\n                    window.digitalData.page.url = window.location.href;\n                    window.digitalData.page.attributes = {\n                        editedWithPageBuilder: 'true'\n                    };\n                    window._satellite.track('page');\n                }\n\n                event = EventBuilder.build(name, args);\n\n                if (isAdminAnalyticsEnabled && !_.isUndefined(window.digitalData.event) && !_.isUndefined(event)) {\n                    delayedPush = setInterval(function (object) {\n                        if (_.isArray(window.digitalData.event)) {\n                            window.digitalData.event.push(object);\n                            window._satellite.track('event');\n                            clearInterval(delayedPush);\n                        }\n                    }, 500, event);\n                }\n            };\n\n            return target;\n        };\n    });\n","Magento_PageBuilderAdminAnalytics/js/page-builder/event-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    return {\n\n        /**\n         * Sets up event attributes and action depending on name and args\n         *\n         * @param {String} name\n         * @param {Array} args\n         */\n\n        build: function (name, args) {\n            var action = '',\n                eventAttributes = {},\n                event;\n\n            if (_.isUndefined(args)) {\n                return;\n            }\n\n            switch (name) {\n                case 'contentType:duplicateAfter':\n                    action = 'duplicate';\n                    break;\n\n                case 'contentType:removeAfter':\n                    action = 'remove';\n                    break;\n\n                case 'contentType:createAfter':\n                    action = 'create';\n                    break;\n\n                case 'contentType:editBefore':\n                    action = 'edit';\n                    break;\n\n                case 'contentType:visibilityAfter':\n                    action = args.visibility ? 'show' : 'hide';\n                    break;\n\n                default:\n                    break;\n            }\n\n            if (!_.isUndefined(args.contentType)) {\n                eventAttributes = args.contentType.config;\n            } else if (!_.isUndefined(args.originalContentType)) {\n                eventAttributes = args.originalContentType.config;\n            }\n\n            if (action !== '' && !_.isEmpty(eventAttributes)) {\n                event = {\n                    element: eventAttributes.label,\n                    type: eventAttributes.name,\n                    action: action,\n                    widget: {\n                        name: eventAttributes.form,\n                        type: eventAttributes['menu_section']\n                    },\n                    feature: 'page-builder-tracker'\n                };\n            }\n\n            return event;\n        }\n    };\n});\n","Magento_Review/js/rating.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('marketing.ratingControl', {\n        options: {\n            colorFilled: '#333',\n            colorUnfilled: '#CCCCCC',\n            colorHover: '#f30'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._labels = this.element.find('label');\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._labels.on({\n                click: $.proxy(function (e) {\n                    $(e.currentTarget).prev().prop('checked', true);\n                    this._updateRating();\n                }, this),\n\n                hover: $.proxy(function (e) {\n                    this._updateHover($(e.currentTarget), this.options.colorHover);\n                }, this),\n\n                mouseleave: $.proxy(function (e) {\n                    this._updateHover($(e.currentTarget), this.options.colorUnfilled);\n                }, this)\n            });\n\n            this._updateRating();\n        },\n\n        /**\n         * @param {jQuery} elem\n         * @param {String} color\n         * @private\n         */\n        _updateHover: function (elem, color) {\n            elem.nextAll('label').addBack().filter(function () {\n                return !$(this).data('checked');\n            }).css('color', color);\n        },\n\n        /**\n         * @private\n         */\n        _updateRating: function () {\n            var checkedInputs = this.element.find('input[type=\"radio\"]:checked');\n\n            checkedInputs.nextAll('label').addBack().css('color', this.options.colorFilled).data('checked', true);\n            checkedInputs.prevAll('label').css('color', this.options.colorUnfilled).data('checked', false);\n        },\n\n        /**\n         * Remove rating when form reset\n         */\n        removeRating: function () {\n            var checkedInputs = this.element.find('input[type=\"radio\"]');\n\n            checkedInputs.nextAll('label').css('color', this.options.colorUnfilled).data('checked', false);\n        }\n    });\n\n});\n","Magento_Rule/conditions-data-normalizer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    /**\n     * @constructor\n     */\n    var ConditionsDataNormalizer = function () {\n        this.patterns = {\n            validate: /^[a-z0-9_.-][a-z0-9_.-]*(?:\\[(?:\\d*|[a-z0-9_.-]+)\\])*$/i,\n            key: /[a-z0-9_.-]+|(?=\\[\\])/gi,\n            push: /^$/,\n            fixed: /^\\d+$/,\n            named: /^[a-z0-9_.-]+$/i\n        };\n    };\n\n    ConditionsDataNormalizer.prototype = {\n        /**\n         * Will convert an object:\n         * {\n         *   \"foo[bar][1][baz]\": 123,\n         *   \"foo[bar][1][blah]\": 321\n         *   \"foo[bar][1--1][ah]\": 456\n         * }\n         *\n         * to\n         * {\n         *   \"foo\": {\n         *     \"bar\": {\n         *       \"1\": {\n         *         \"baz\": 123,\n         *         \"blah\": 321\n         *       },\n         *       \"1--1\": {\n         *         \"ah\": 456\n         *       }\n         *     }\n         *   }\n         * }\n         */\n        normalize: function normalize(value) {\n            var el, _this = this;\n\n            this.pushes = {};\n            this.data = {};\n\n            _.each(value, function (e, i) {\n                el = {};\n                el[i] = e;\n\n                _this._addPair({\n                    name: i,\n                    value: e\n                });\n            });\n\n            return this.data;\n        },\n\n        /**\n         * @param {Object} base\n         * @param {String} key\n         * @param {String} value\n         * @return {Object}\n         * @private\n         */\n        _build: function build(base, key, value) {\n            base[key] = value;\n\n            return base;\n        },\n\n        /**\n         * @param {Object} root\n         * @param {String} value\n         * @return {*}\n         * @private\n         */\n        _makeObject: function makeObject(root, value) {\n            var keys = root.match(this.patterns.key),\n                k, idx; // nest, nest, ..., nest\n\n            while ((k = keys.pop()) !== undefined) {\n                // foo[]\n                if (this.patterns.push.test(k)) {\n                    idx = this._incrementPush(root.replace(/\\[\\]$/, ''));\n                    value = this._build([], idx, value);\n                } // foo[n]\n                else if (this.patterns.fixed.test(k)) {\n                    value = this._build({}, k, value);\n                } // foo; foo[bar]\n                else if (this.patterns.named.test(k)) {\n                    value = this._build({}, k, value);\n                }\n            }\n\n            return value;\n        },\n\n        /**\n         * @param {String} key\n         * @return {Number}\n         * @private\n         */\n        _incrementPush: function incrementPush(key) {\n            if (this.pushes[key] === undefined) {\n                this.pushes[key] = 0;\n            }\n\n            return this.pushes[key]++;\n        },\n\n        /**\n         * @param {Object} pair\n         * @return {Object}\n         * @private\n         */\n        _addPair: function addPair(pair) {\n            var obj = this._makeObject(pair.name, pair.value);\n\n            if (!this.patterns.validate.test(pair.name)) {\n                return this;\n            }\n\n            this.data = $.extend(true, this.data, obj);\n\n            return this;\n        }\n    };\n\n    return ConditionsDataNormalizer;\n});\n","Magento_Rule/rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'prototype'\n], function (jQuery) {\n    'use strict';\n\n    var VarienRulesForm = new Class.create();\n\n    VarienRulesForm.prototype = {\n        initialize: function (parent, newChildUrl) {\n            this.parent = $(parent);\n            this.newChildUrl  = newChildUrl;\n            this.shownElement = null;\n            this.updateElement = null;\n            this.chooserSelectedItems = $H({});\n            this.readOnly = false;\n\n            var elems = this.parent.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                this.initParam(elems[i]);\n            }\n        },\n\n        setReadonly: function (readonly) {\n            this.readOnly = readonly;\n            var elems = this.parent.getElementsByClassName('rule-param-remove');\n\n            for (var i = 0; i < elems.length; i++) {\n                var element = elems[i];\n\n                if (this.readOnly) {\n                    element.hide();\n                } else {\n                    element.show();\n                }\n            }\n\n            var elems = this.parent.getElementsByClassName('rule-param-new-child');\n\n            for (var i = 0; i < elems.length; i++) {\n                var element = elems[i];\n\n                if (this.readOnly) {\n                    element.hide();\n                } else {\n                    element.show();\n                }\n            }\n\n            var elems = this.parent.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                var container = elems[i];\n                var label = Element.down(container, '.label');\n\n                if (label) {\n                    if (this.readOnly) {\n                        label.addClassName('label-disabled');\n                    } else {\n                        label.removeClassName('label-disabled');\n                    }\n                }\n            }\n        },\n\n        initParam: function (container) {\n            container.rulesObject = this;\n            var label = Element.down(container, '.label');\n\n            if (label) {\n                Event.observe(label, 'click', this.showParamInputField.bind(this, container));\n            }\n\n            var elem = Element.down(container, '.element');\n\n            if (elem) {\n                var trig = elem.down('.rule-chooser-trigger');\n\n                if (trig) {\n                    Event.observe(trig, 'click', this.toggleChooser.bind(this, container));\n                }\n\n                var apply = elem.down('.rule-param-apply');\n\n                if (apply) {\n                    Event.observe(apply, 'click', this.hideParamInputField.bind(this, container));\n                } else {\n                    elem = elem.down('.element-value-changer');\n                    elem.container = container;\n\n                    if (!elem.multiple) {\n                        Event.observe(elem, 'change', this.hideParamInputField.bind(this, container));\n\n                        this.changeVisibilityForValueRuleParam(elem);\n\n                    }\n                    Event.observe(elem, 'blur', this.hideParamInputField.bind(this, container));\n                }\n            }\n\n            var remove = Element.down(container, '.rule-param-remove');\n\n            if (remove) {\n                Event.observe(remove, 'click', this.removeRuleEntry.bind(this, container));\n            }\n        },\n\n        showChooserElement: function (chooser) {\n            this.chooserSelectedItems = $H({});\n\n            if (chooser.hasClassName('no-split')) {\n                this.chooserSelectedItems.set(this.updateElement.value, 1);\n            } else {\n                var values = this.updateElement.value.split(','),\n s = '';\n\n                for (var i = 0; i < values.length; i++) {\n                    s = values[i].strip();\n\n                    if (s != '') {\n                        this.chooserSelectedItems.set(s, 1);\n                    }\n                }\n            }\n            new Ajax.Request(chooser.getAttribute('url'), {\n                evalScripts: true,\n                parameters: {\n                    'form_key': FORM_KEY, 'selected[]': this.chooserSelectedItems.keys()\n                },\n                onSuccess: function (transport) {\n                    if (this._processSuccess(transport)) {\n                        jQuery(chooser).html(transport.responseText);\n                        this.showChooserLoaded(chooser, transport);\n                        jQuery(chooser).trigger('contentUpdated');\n                    }\n                }.bind(this),\n                onFailure: this._processFailure.bind(this)\n            });\n        },\n\n        showChooserLoaded: function (chooser, transport) {\n            chooser.style.display = 'block';\n        },\n\n        showChooser: function (container, event) {\n            var chooser = container.up('li');\n\n            if (!chooser) {\n                return;\n            }\n            chooser = chooser.down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            this.showChooserElement(chooser);\n        },\n\n        hideChooser: function (container, event) {\n            var chooser = container.up('li');\n\n            if (!chooser) {\n                return;\n            }\n            chooser = chooser.down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            chooser.style.display = 'none';\n        },\n\n        toggleChooser: function (container, event) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            var chooser = container.up('li').down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n\n            if (chooser.style.display == 'block') {\n                chooser.style.display = 'none';\n                this.cleanChooser(container, event);\n            } else {\n                this.showChooserElement(chooser);\n            }\n        },\n\n        cleanChooser: function (container, event) {\n            var chooser = container.up('li').down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            chooser.innerHTML = '';\n        },\n\n        showParamInputField: function (container, event) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            if (this.shownElement) {\n                this.hideParamInputField(this.shownElement, event);\n            }\n\n            Element.addClassName(container, 'rule-param-edit');\n            var elemContainer = Element.down(container, '.element');\n\n            var elem = Element.down(elemContainer, 'input.input-text');\n\n            jQuery(elem).trigger('contentUpdated');\n\n            if (elem) {\n                elem.focus();\n\n                if (elem && elem.id && elem.id.match(/__value$/)) {\n                    this.updateElement = elem;\n                }\n\n            }\n\n            var elem = Element.down(elemContainer, '.element-value-changer');\n\n            if (elem) {\n                elem.focus();\n            }\n\n            this.shownElement = container;\n        },\n\n        hideParamInputField: function (container, event) {\n            Element.removeClassName(container, 'rule-param-edit');\n            var label = Element.down(container, '.label'),\n elem;\n\n            if (!container.hasClassName('rule-param-new-child')) {\n                elem = Element.down(container, '.element-value-changer');\n\n                if (elem && elem.options) {\n                    var selectedOptions = [];\n\n                    for (var i = 0; i < elem.options.length; i++) {\n                        if (elem.options[i].selected) {\n                            selectedOptions.push(elem.options[i].text);\n                        }\n                    }\n\n                    var str = selectedOptions.join(', ');\n\n                    label.innerHTML = str != '' ? str : '...';\n                }\n\n                this.changeVisibilityForValueRuleParam(elem);\n\n                elem = Element.down(container, 'input.input-text');\n\n                if (elem) {\n                    var str = elem.value.replace(/(^\\s+|\\s+$)/g, '');\n\n                    elem.value = str;\n\n                    if (str == '') {\n                        str = '...';\n                    } else if (str.length > 30) {\n                        str = str.substr(0, 30) + '...';\n                    }\n                    label.innerHTML = str.escapeHTML();\n                }\n            } else {\n                elem = container.down('.element-value-changer');\n\n                if (elem.value) {\n                    this.addRuleNewChild(elem);\n                }\n                elem.value = '';\n            }\n\n            if (elem && elem.id && elem.id.match(/__value$/)) {\n                this.hideChooser(container, event);\n                this.updateElement = null;\n            }\n\n            this.shownElement = null;\n        },\n\n        changeVisibilityForValueRuleParam: function(elem) {\n            var parsedElementId = elem.id.split('__');\n            if (parsedElementId[2] !== 'operator') {\n                return false;\n            }\n\n            var valueElement = jQuery('#' + parsedElementId[0] + '__' + parsedElementId[1] + '__value');\n\n            if(elem.value === '<=>') {\n                valueElement.closest('.rule-param').hide();\n            } else {\n                valueElement.closest('.rule-param').show();\n            }\n\n            return true;\n        },\n\n        addRuleNewChild: function (elem) {\n            var parent_id = elem.id.replace(/^.*__(.*)__.*$/, '$1');\n            var children_ul_id = elem.id.replace(/__/g, ':').replace(/[^:]*$/, 'children').replace(/:/g, '__');\n            var children_ul = $(this.parent).select('#' + children_ul_id)[0];\n            var max_id = 0,\n i;\n            var children_inputs = Selector.findChildElements(children_ul, $A(['input.hidden']));\n\n            if (children_inputs.length) {\n                children_inputs.each(function (el) {\n                    if (el.id.match(/__type$/)) {\n                        i = 1 * el.id.replace(/^.*__.*?([0-9]+)__.*$/, '$1');\n                        max_id = i > max_id ? i : max_id;\n                    }\n                });\n            }\n            var new_id = parent_id + '--' + (max_id + 1);\n            var new_type = elem.value;\n            var new_elem = document.createElement('LI');\n\n            new_elem.className = 'rule-param-wait';\n            new_elem.innerHTML = jQuery.mage.__('This won\\'t take long . . .');\n            children_ul.insertBefore(new_elem, $(elem).up('li'));\n\n            new Ajax.Request(this.newChildUrl, {\n                evalScripts: true,\n                parameters: {\n                    form_key: FORM_KEY, type: new_type.replace('/', '-'), id: new_id\n                },\n                onComplete: this.onAddNewChildComplete.bind(this, new_elem),\n                onSuccess: function (transport) {\n                    if (this._processSuccess(transport)) {\n                        $(new_elem).update(transport.responseText);\n                    }\n                }.bind(this),\n                onFailure: this._processFailure.bind(this)\n            });\n        },\n\n        _processSuccess: function (transport) {\n            if (transport.responseText.isJSON()) {\n                var response = transport.responseText.evalJSON();\n\n                if (response.error) {\n                    alert(response.message);\n                }\n\n                if (response.ajaxExpired && response.ajaxRedirect) {\n                    setLocation(response.ajaxRedirect);\n                }\n\n                return false;\n            }\n\n            return true;\n        },\n\n        _processFailure: function (transport) {\n            location.href = BASE_URL;\n        },\n\n        onAddNewChildComplete: function (new_elem) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            $(new_elem).removeClassName('rule-param-wait');\n            var elems = new_elem.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                this.initParam(elems[i]);\n            }\n        },\n\n        removeRuleEntry: function (container, event) {\n            var li = Element.up(container, 'li');\n\n            li.parentNode.removeChild(li);\n        },\n\n        chooserGridInit: function (grid) {\n            //grid.reloadParams = {'selected[]':this.chooserSelectedItems.keys()};\n        },\n\n        chooserGridRowInit: function (grid, row) {\n            if (!grid.reloadParams) {\n                grid.reloadParams = {\n                    'selected[]': this.chooserSelectedItems.keys()\n                };\n            }\n        },\n\n        chooserGridRowClick: function (grid, event) {\n            var trElement = Event.findElement(event, 'tr');\n            var isInput = Event.element(event).tagName == 'INPUT';\n\n            if (trElement) {\n                var checkbox = Element.select(trElement, 'input');\n\n                if (checkbox[0]) {\n                    var checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n\n                    grid.setCheckboxChecked(checkbox[0], checked);\n\n                }\n            }\n        },\n\n        chooserGridCheckboxCheck: function (grid, element, checked) {\n            if (checked) {\n                if (!element.up('th')) {\n                    this.chooserSelectedItems.set(element.value, 1);\n                }\n            } else {\n                this.chooserSelectedItems.unset(element.value);\n            }\n            grid.reloadParams = {\n                'selected[]': this.chooserSelectedItems.keys()\n            };\n            this.updateElement.value = this.chooserSelectedItems.keys().join(', ');\n        }\n    };\n\n    return VarienRulesForm;\n});\n","Magento_ProductVideo/js/new-video-dialog.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/backend/tree-suggest',\n    'mage/backend/validation',\n    'Magento_ProductVideo/js/get-video-information'\n], function ($, _) {\n    'use strict';\n\n    $.widget('mage.createVideoPlayer', {\n        options: {\n            videoId: '',\n            videoProvider: '',\n            container: '.video-player-container',\n            videoClass: 'product-video',\n            reset: false,\n            useYoutubeNocookie: false,\n            metaData: {\n                DOM: {\n                    title: '.video-information.title span',\n                    uploaded: '.video-information.uploaded span',\n                    uploader: '.video-information.uploader span',\n                    duration: '.video-information.duration span',\n                    all: '.video-information span',\n                    wrapper: '.video-information'\n                },\n                data: {\n                    title: '',\n                    uploaded: '',\n                    uploader: '',\n                    uploaderUrl: '',\n                    duration: ''\n                }\n            }\n        },\n\n        _FINISH_CREATE_VIDEO_TRIGGER: 'finish_create_video',\n\n        _FINISH_UPDATE_VIDEO_TRIGGER: 'finish_update_video',\n\n        /**\n         * @private\n         */\n        _init: function () {\n            if (this.options.reset) {\n                this.reset();\n            } else {\n                this.update();\n            }\n\n            this.element.on('reset', $.proxy(this.reset, this));\n\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        update: function () {\n            var checkVideoID =\n                this.element.find(this.options.container).find('.' + this.options.videoClass).data('code'),\n            eventVideoData = {\n                oldVideoId: checkVideoID ? checkVideoID.toString() : checkVideoID,\n                newVideoId: this.options.videoId ? this.options.videoId.toString() : this.options.videoId\n            };\n\n            if (checkVideoID && checkVideoID !== this.options.videoId) {\n                this._doUpdate();\n                this.element.trigger(this._FINISH_UPDATE_VIDEO_TRIGGER, eventVideoData);\n            } else if (checkVideoID && checkVideoID === this.options.videoId) {\n                return false;\n            } else if (!checkVideoID) {\n                this._doUpdate();\n                this.element.trigger(this._FINISH_CREATE_VIDEO_TRIGGER, eventVideoData);\n            }\n\n        },\n\n        /**\n         * @private\n         */\n        _doUpdate: function () {\n            var uploaderLinkUrl,\n                uploaderLink;\n\n            this.reset();\n            this.element.find(this.options.container).append(\n                '<div class=\"' +\n                this.options.videoClass +\n                '\" data-type=\"' +\n                this.options.videoProvider +\n                '\" data-code=\"' +\n                this.options.videoId +\n                '\" data-youtubenocookie=\"' +\n                this.options.useYoutubeNocookie +\n                '\" data-width=\"100%\" data-height=\"100%\"></div>'\n            );\n            this.element.find(this.options.metaData.DOM.wrapper).show();\n            this.element.find(this.options.metaData.DOM.title).text(this.options.metaData.data.title);\n            this.element.find(this.options.metaData.DOM.uploaded).text(this.options.metaData.data.uploaded);\n            this.element.find(this.options.metaData.DOM.duration).text(this.options.metaData.data.duration);\n\n            if (this.options.videoProvider === 'youtube') {\n                uploaderLinkUrl = 'https://youtube.com/channel/' + this.options.metaData.data.uploaderUrl;\n            } else if (this.options.videoProvider === 'vimeo') {\n                uploaderLinkUrl = this.options.metaData.data.uploaderUrl;\n            }\n            uploaderLink = document.createElement('a');\n            uploaderLink.setAttribute('href', uploaderLinkUrl);\n            uploaderLink.setAttribute('target', '_blank');\n            uploaderLink.innerText = this.options.metaData.data.uploader;\n            this.element.find(this.options.metaData.DOM.uploader)[0].appendChild(uploaderLink);\n            this.element.find('.' + this.options.videoClass).productVideoLoader();\n\n        },\n\n        /**\n         * Reset\n         */\n        reset: function () {\n            this.element.find(this.options.container).find('.' + this.options.videoClass).remove();\n            this.element.find(this.options.metaData.DOM.wrapper).hide();\n            this.element.find(this.options.metaData.DOM.all).text('');\n\n        }\n    });\n\n    $.widget('mage.updateInputFields', {\n        options: {\n            reset: false,\n            DOM: {\n                urlField: 'input[name=\"video_url\"]',\n                titleField: 'input[name=\"video_title\"]',\n                fileField: '#file_name',\n                descriptionField: 'textarea[name=\"video_description\"]',\n                thumbnailLocation: '.field-new_video_screenshot_preview .admin__field-control'\n            },\n            data: {\n                url: '',\n                title: '',\n                description: '',\n                thumbnail: ''\n            }\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            if (this.options.reset) {\n                this.reset();\n            } else {\n                this.update();\n            }\n        },\n\n        /**\n         * Update\n         */\n        update: function () {\n            $(this.options.DOM.titleField).val(this.options.data.title);\n            $(this.options.DOM.descriptionField).val(this.options.data.description);\n        },\n\n        /**\n         * Reset\n         */\n        reset: function () {\n            $(this.options.DOM.fileField).val('');\n            $(this.options.DOM.urlField).val('');\n            $(this.options.DOM.titleField).val('');\n            $(this.options.DOM.descriptionField).val('');\n        }\n    });\n\n    /**\n     */\n    $.widget('mage.newVideoDialog', {\n\n        _previewImage: null,\n\n        clickedElement: '',\n\n        _images: {},\n\n        _imageTypes: [\n            '.jpeg',\n            '.pjpeg',\n            '.jpeg',\n            '.jpg',\n            '.pjpeg',\n            '.png',\n            '.gif'\n        ],\n\n        _imageProductGalleryWrapperSelector: '#image-container',\n\n        _videoPreviewInputSelector: '#new_video_screenshot',\n\n        _videoPreviewRemoteSelector: '',\n\n        _videoDisableinputSelector: '#new_video_disabled',\n\n        _videoPreviewImagePointer: '#new_video_screenshot_preview',\n\n        _videoFormSelector: '#new_video_form',\n\n        _itemIdSelector: '#item_id',\n\n        _videoUrlSelector: '[name=\"video_url\"]',\n\n        _videoImageFilenameselector: '#file_name',\n\n        _videoUrlWidget: null,\n\n        _videoInformationBtnSelector: '[name=\"new_video_get\"]',\n\n        _editVideoBtnSelector: '.image',\n\n        _deleteGalleryVideoSelector: '[data-role=delete-button]',\n\n        _deleteGalleryVideoSelectorBtn: null,\n\n        _videoInformationGetBtn: null,\n\n        _videoInformationGetUrlField: null,\n\n        _videoInformationGetEditBtn: null,\n\n        _isEditPage: false,\n\n        _onlyVideoPlayer: false,\n\n        _tempPreviewImageData: null,\n\n        _videoPlayerSelector: '.mage-new-video-dialog',\n\n        _videoRequestComplete: null,\n\n        _gallery: null,\n\n        /**\n         * Bind events\n         * @private\n         */\n        _bind: function () {\n            var events = {\n                'setImage': '_onSetImage'\n            };\n\n            this._on(events);\n\n            this._videoUrlWidget = this.element.find(this._videoUrlSelector).videoData({\n                youtubeKey: this.options.youTubeApiKey,\n                eventSource: 'focusout'\n            });\n\n            this._videoInformationGetBtn = this.element.find(this._videoInformationBtnSelector);\n            this._videoInformationGetUrlField = this.element.find(this._videoUrlSelector);\n            this._videoInformationGetEditBtn = this._gallery.find(this._editVideoBtnSelector);\n\n            this._videoInformationGetBtn.on('click', $.proxy(this._onGetVideoInformationClick, this));\n            this._videoInformationGetUrlField.on('focusout', $.proxy(this._onGetVideoInformationFocusOut, this));\n\n            this._videoUrlWidget.on('updated_video_information', $.proxy(this._onGetVideoInformationSuccess, this));\n            this._videoUrlWidget.on('error_updated_information', $.proxy(this._onGetVideoInformationError, this));\n            this._videoUrlWidget.on(\n                'request_video_information',\n                $.proxy(this._onGetVideoInformationStartRequest, this)\n            );\n        },\n\n        /**\n         * Fired when user click on button \"Get video information\"\n         * @private\n         */\n        _onGetVideoInformationClick: function () {\n            var videoForm = this.element.find(this._videoFormSelector);\n\n            videoForm.validation();\n\n            if (this.element.find(this._videoUrlSelector).valid()) {\n                this._onlyVideoPlayer = false;\n                this._isEditPage = false;\n                this._videoUrlWidget.trigger('update_video_information');\n            }\n        },\n\n        /**\n         * Fired when user do focus out from url field\n         * @private\n         */\n        _onGetVideoInformationFocusOut: function () {\n            this._videoUrlWidget.trigger('update_video_information');\n        },\n\n        /**\n         * @private\n         */\n        _onGetVideoInformationStartRequest: function () {\n            var videoForm = this.element.find(this._videoFormSelector);\n\n            try {\n                videoForm.validation('clearError');\n            } catch (e) {\n                // Do nothing\n            }\n\n            this._videoRequestComplete = false;\n        },\n\n        /**\n         * Fired when user click Edit Video button\n         * @private\n         */\n        _onGetVideoInformationEditClick: function () {\n            this._onlyVideoPlayer = true;\n            this._isEditPage = true;\n            this._videoUrlWidget.trigger('update_video_information');\n        },\n\n        /**\n         * Fired when successfully received information about the video.\n         * @param {Object} e\n         * @param {Object} data\n         * @private\n         */\n        _onGetVideoInformationSuccess: function (e, data) {\n            var self = this;\n\n            self.element.on('finish_update_video finish_create_video', $.proxy(function (element, playerData) {\n                if (!self._onlyVideoPlayer ||\n                    !self._isEditPage && playerData.oldVideoId !== playerData.newVideoId ||\n                    playerData.oldVideoId && playerData.oldVideoId !== playerData.newVideoId\n                ) {\n                    self.element.updateInputFields({\n                        reset: false,\n                        data: {\n                            title: data.title,\n                            description: data.description\n                        }\n                    });\n                    this._loadRemotePreview(data.thumbnail);\n                }\n                self._onlyVideoPlayer = true;\n            }, this))\n            .createVideoPlayer({\n                videoId: data.videoId,\n                videoProvider: data.videoProvider,\n                useYoutubeNocookie: data.useYoutubeNocookie,\n                reset: false,\n                metaData: {\n                    DOM: {\n                        title: '.video-information.title span',\n                        uploaded: '.video-information.uploaded span',\n                        uploader: '.video-information.uploader span',\n                        duration: '.video-information.duration span',\n                        all: '.video-information span',\n                        wrapper: '.video-information'\n                    },\n                    data: {\n                        title: data.title,\n                        uploaded: data.uploaded,\n                        uploader: data.channel,\n                        duration: data.duration,\n                        uploaderUrl: data.channelId\n                    }\n                }\n            })\n            .off('finish_update_video finish_create_video');\n\n            this._videoRequestComplete = true;\n        },\n\n        /**\n         * Load preview from youtube/vimeo\n         * @param {String} sourceUrl\n         * @private\n         */\n        _loadRemotePreview: function (sourceUrl) {\n            var url = this.options.saveRemoteVideoUrl,\n                self = this;\n\n            this._getPreviewImage().attr('src', sourceUrl).hide();\n            this._blockActionButtons(true, true);\n            $.ajax({\n                url: url,\n                data: 'remote_image=' + sourceUrl,\n                type: 'post',\n                success: $.proxy(function (result) {\n                    this._tempPreviewImageData = result;\n                    this._getPreviewImage().attr('src', sourceUrl).show();\n                    this._blockActionButtons(false, true);\n                }, self)\n            });\n        },\n\n        /**\n         * Fired when receiving information about the video ended with error\n         * @private\n         */\n        _onGetVideoInformationError: function () {\n        },\n\n        /**\n         * Remove \".tmp\"\n         * @param {String} name\n         * @returns {*}\n         * @private\n         */\n        __prepareFilename: function (name) {\n            var tmppost = '.tmp';\n\n            if (!name) {\n                return name;\n            }\n\n            if (name.endsWith(tmppost)) {\n                name = name.slice(0, name.length - tmppost.length);\n            }\n\n            return name;\n        },\n\n        /**\n         * Set image data\n         * @param {String} file\n         * @param {Object} imageData\n         * @private\n         */\n        _setImage: function (file, imageData) {\n            file = this.__prepareFilename(file);\n            this._images[file] = imageData;\n            this._gallery.trigger('addItem', imageData);\n            this.element.trigger('setImage', imageData);\n            this._addVideoClass(imageData.url);\n        },\n\n        /**\n         * Get image data\n         *\n         * @param {String} file\n         * @returns {*}\n         * @private\n         */\n        _getImage: function (file) {\n            file = this.__prepareFilename(file);\n\n            return this._images[file];\n        },\n\n        /**\n         * Replace image (update)\n         * @param {String} oldFile\n         * @param {String} newFile\n         * @param {Object} imageData\n         * @private\n         */\n        _replaceImage: function (oldFile, newFile, imageData) {\n            var tmpNewFile = newFile,\n                tmpOldImage,\n                newImageId,\n                oldNewFilePosition,\n                fc,\n                suff,\n                searchsuff,\n                key,\n                oldValIdElem;\n\n            oldFile = this.__prepareFilename(oldFile);\n            newFile = this.__prepareFilename(newFile);\n            tmpOldImage = this._images[oldFile];\n\n            if (newFile === oldFile) {\n                this._images[newFile] = imageData;\n                this.saveImageRoles(imageData);\n                this._updateVisibility(imageData);\n                this._updateImageTitle(imageData);\n\n                return null;\n            }\n\n            this._removeImage(oldFile);\n            this._setImage(newFile, imageData);\n\n            if (!oldFile || !imageData.oldFile) {\n                return null;\n            }\n\n            newImageId = this.findElementId(tmpNewFile);\n            fc = this.element.find(this._itemIdSelector).val();\n\n            suff = 'product[media_gallery][images]' + fc;\n\n            searchsuff = 'input[name=\"' + suff + '[value_id]\"]';\n            key = this._gallery.find(searchsuff).val();\n\n            if (!key) {\n                return null;\n            }\n\n            oldValIdElem = document.createElement('input');\n            this._gallery.find('form[data-form=\"edit-product\"]').append(oldValIdElem);\n            $(oldValIdElem).attr({\n                type: 'hidden',\n                name: 'product[media_gallery][images][' + newImageId + '][save_data_from]'\n            }).val(key);\n\n            oldNewFilePosition = parseInt(tmpOldImage.position, 10);\n            imageData.position = oldNewFilePosition;\n\n            this._gallery.trigger('setPosition', {\n                imageData: imageData,\n                position: oldNewFilePosition\n            });\n        },\n\n        /**\n         * Remove image data\n         * @param {String} file\n         * @private\n         */\n        _removeImage: function (file) {\n            var imageData = this._getImage(file);\n\n            if (!imageData) {\n                return null;\n            }\n\n            this._gallery.trigger('removeItem', imageData);\n            this.element.trigger('removeImage', imageData);\n            delete this._images[file];\n        },\n\n        /**\n         * Fired when image setted\n         * @param {Event} event\n         * @param {Object} imageData\n         * @private\n         */\n        _onSetImage: function (event, imageData) {\n            this.saveImageRoles(imageData);\n        },\n\n        /**\n         *\n         * Wrap _uploadFile\n         * @param {String} file\n         * @param {String} oldFile\n         * @param {Function} callback\n         * @private\n         */\n        _uploadImage: function (file, oldFile, callback) {\n            var url = this.options.saveVideoUrl,\n            data = {\n                files: file,\n                url: url\n            };\n\n            this._blockActionButtons(true, true);\n            this._uploadFile(data, $.proxy(function (result) {\n                this._onImageLoaded(result, file, oldFile, callback);\n                this._blockActionButtons(false);\n            }, this));\n\n        },\n\n        /**\n         * @param {String} result\n         * @param {String} file\n         * @param {String} oldFile\n         * @param {Function} callback\n         * @private\n         */\n        _onImageLoaded: function (result, file, oldFile, callback) {\n            var data;\n\n            try {\n                data = JSON.parse(result);\n            } catch (e) {\n                data = result;\n            }\n\n            if (this.element.find('#video_url').parent().find('.image-upload-error').length > 0) {\n                this.element.find('.image-upload-error').remove();\n            }\n\n            if (data.errorcode || data.error) {\n                this.element.find('#video_url').parent().append('<div class=\"image-upload-error\">' +\n                '<div class=\"image-upload-error-cross\"></div><span>' + data.error + '</span></div>');\n\n                return;\n            }\n            $.each(this.element.find(this._videoFormSelector).serializeArray(), function (i, field) {\n                data[field.name] = field.value;\n            });\n            data.disabled = this.element.find(this._videoDisableinputSelector).prop('checked') ? 1 : 0;\n            data['media_type'] = 'external-video';\n            data.oldFile = oldFile;\n\n            oldFile ?\n                this._replaceImage(oldFile, data.file, data) :\n                this._setImage(data.file, data);\n            callback.call(0, data);\n        },\n\n        /**\n         * File uploader\n         * @private\n         */\n        _uploadFile: function (data, callback) {\n            var fu = this.element.find(this._videoPreviewInputSelector),\n                tmpInput = document.createElement('input'),\n                fileUploader = null;\n\n            $(tmpInput).attr({\n                'name': fu.attr('name'),\n                'value': fu.val(),\n                'type': 'file',\n                'data-ui-ud': fu.attr('data-ui-ud')\n            }).css('display', 'none');\n            fu.parent().append(tmpInput);\n            fileUploader = $(tmpInput).fileupload();\n            fileUploader.fileupload('send', data).done(function (result, textStatus, jqXHR) {\n                tmpInput.remove();\n                callback.call(null, result, textStatus, jqXHR);\n            });\n        },\n\n        /**\n         * Update style\n         * @param {String} url\n         * @private\n         */\n        _addVideoClass: function (url) {\n            var classVideo = 'video-item';\n\n            this._gallery.find('img[src=\"' + url + '\"]').addClass(classVideo);\n        },\n\n        /**\n         * Build widget\n         * @private\n         */\n        _create: function () {\n            var imgs = _.values(this.element.closest(this.options.videoSelector).data('images')) || [],\n                widget,\n                uploader,\n                tmp,\n                i;\n\n            this._gallery =  this.element.closest(this.options.videoSelector);\n\n            for (i = 0; i < imgs.length; i++) {\n                tmp = imgs[i];\n                this._images[tmp.file] = tmp;\n\n                if (tmp['media_type'] === 'external-video') {\n                    tmp.subclass = 'video-item';\n                    this._addVideoClass(tmp.url);\n                }\n            }\n\n            this._gallery.on('openDialog', $.proxy(this._onOpenDialog, this));\n            this._bind();\n            this.createVideoItemIcons();\n            widget = this;\n            uploader = this.element.find(this._videoPreviewInputSelector);\n            uploader.on('change', this._onImageInputChange.bind(this));\n            uploader.attr('accept', this._imageTypes.join(','));\n\n            this.element.modal({\n                type: 'slide',\n                //appendTo: this._gallery,\n                modalClass: 'mage-new-video-dialog form-inline',\n                title: $.mage.__('New Video'),\n                buttons: [\n                {\n                    text: $.mage.__('Save'),\n                    class: 'action-primary video-create-button',\n                    click: $.proxy(widget._onCreate, widget)\n                },\n                {\n                    text: $.mage.__('Cancel'),\n                    class: 'video-cancel-button',\n                    click: $.proxy(widget._onCancel, widget)\n                },\n                {\n                    text: $.mage.__('Delete'),\n                    class: 'video-delete-button',\n                    click: $.proxy(widget._onDelete, widget)\n                },\n                {\n                    text: $.mage.__('Save'),\n                    class: 'action-primary video-edit',\n                    click: $.proxy(widget._onUpdate, widget)\n                }\n                ],\n\n                /**\n                 * @returns {null}\n                 */\n                opened: function () {\n                    var roles,\n                        file,\n                        modalTitleElement,\n                        imageData,\n                        modal = widget.element.closest('.mage-new-video-dialog');\n\n                    widget.element.find('#video_url').focus();\n                    roles = widget.element.find('.video_image_role');\n                    roles.prop('disabled', false);\n                    file = widget.element.find('#file_name').val();\n                    widget._onGetVideoInformationEditClick();\n                    modalTitleElement = modal.find('.modal-title');\n\n                    if (!file) {\n                        widget._blockActionButtons(true);\n\n                        modal.find('.video-delete-button').hide();\n                        modal.find('.video-edit').hide();\n                        modal.find('.video-create-button').show();\n                        roles.prop('checked', widget._gallery.find('.image.item:not(.removed)').length < 1);\n                        modalTitleElement.text($.mage.__('New Video'));\n                        widget._isEditPage = false;\n\n                        return null;\n                    }\n                    widget._blockActionButtons(false);\n                    modalTitleElement.text($.mage.__('Edit Video'));\n                    widget._isEditPage = true;\n                    imageData = widget._getImage(file);\n\n                    if (!imageData) {\n                        imageData = {\n                            url: _.find(widget._gallery.find('.product-image'), function (image) {\n                                return image.src.indexOf(file) > -1;\n                            }).src\n                        };\n                    }\n\n                    widget._onPreview(null, imageData.url, false);\n                },\n\n                /**\n                 * Closed\n                 */\n                closed: function () {\n                    widget._onClose();\n                    widget.createVideoItemIcons();\n                }\n            });\n            this.toggleButtons();\n        },\n\n        /**\n         * @param {String} status\n         * @private\n         */\n        _blockActionButtons: function (status) {\n            this.element\n                .closest('.mage-new-video-dialog')\n                .find('.page-actions-buttons button.video-create-button, .page-actions-buttons button.video-edit')\n                .attr('disabled', status);\n        },\n\n        /**\n         * Check form\n         * @param {Function} callback\n         */\n        isValid: function (callback) {\n            var videoForm = this.element.find(this._videoFormSelector),\n                videoLoaded = true;\n\n            this._blockActionButtons(true);\n\n            this._videoUrlWidget.trigger('validate_video_url', $.proxy(function () {\n\n                videoForm.mage('validation', {\n\n                    /**\n                     * @param {jQuery} error\n                     * @param {jQuery} element\n                     */\n                    errorPlacement: function (error, element) {\n                        error.insertAfter(element);\n                    }\n                }).on('highlight.validate', function () {\n                    $(this).validation('option');\n                });\n\n                videoForm.validation();\n\n                if (this._videoRequestComplete === false) {\n                    videoLoaded = false;\n                }\n\n                callback(videoForm.valid() && videoLoaded);\n            }, this));\n\n            this._blockActionButtons(false);\n        },\n\n        /**\n         * Create video item icons\n         */\n        createVideoItemIcons: function () {\n            var $imageWidget = this._gallery.find('.product-image.video-item'),\n                $productGalleryWrapper = $(this._imageProductGalleryWrapperSelector).find('.product-image.video-item');\n\n            $imageWidget.parent().addClass('video-item');\n            $productGalleryWrapper.parent().addClass('video-item');\n            $imageWidget.removeClass('video-item');\n            $productGalleryWrapper.removeClass('video-item');\n            $('.video-item .action-delete').attr('title', $.mage.__('Delete video'));\n            $('.video-item .action-delete span').html($.mage.__('Delete video'));\n        },\n\n        /**\n         * Fired when click on create video\n         * @private\n         */\n        _onCreate: function () {\n            var nvs = this.element.find(this._videoPreviewInputSelector),\n                file = nvs.get(0),\n                reqClass = 'required-entry _required';\n\n            if (file && file.files && file.files.length) {\n                file = file.files[0];\n            } else {\n                file = null;\n            }\n\n            if (!file && !this._tempPreviewImageData) {\n                nvs.addClass(reqClass);\n            }\n\n            this.isValid($.proxy(\n                function (videoValidStatus) {\n\n                    if (!videoValidStatus) {\n                        return;\n                    }\n\n                    if (this._tempPreviewImageData) {\n                        this._onImageLoaded(this._tempPreviewImageData, null, null, $.proxy(this.close, this));\n                    } else {\n                        this._uploadImage(file, null, $.proxy(function () {\n                            this.close();\n                        }, this));\n                    }\n\n                    nvs.removeClass(reqClass);\n                },\n                this\n            ));\n        },\n\n        /**\n         * Fired when click on update video\n         * @private\n         */\n        _onUpdate: function () {\n            var inputFile, itemId, _inputSelector, mediaFields, imageData, flagChecked, fileName, callback;\n\n            this.isValid($.proxy(\n                function (videoValidStatus) {\n\n                    if (!videoValidStatus) {\n                        return;\n                    }\n\n                    imageData = this.imageData || {};\n                    inputFile = this.element.find(this._videoPreviewInputSelector);\n                    itemId = this.element.find(this._itemIdSelector).val();\n                    itemId = itemId.slice(1, itemId.length - 1);\n                    _inputSelector = '[name*=\"[' + itemId + ']\"]';\n                    mediaFields = this._gallery.find('input' + _inputSelector);\n                    $.each(mediaFields, function (i, el) {\n                        var elName = el.name,\n                            start = elName.indexOf(itemId) + itemId.length + 2,\n                            fieldName = elName.substring(start, el.name.length - 1),\n                            _field = this.element.find('#' + fieldName),\n                            _tmp;\n\n                        if (_field.length > 0) {\n                            _tmp = _inputSelector.slice(0, _inputSelector.length - 2) + '[' + fieldName + ']\"]';\n                            this._gallery.find(_tmp).val(_field.val());\n                            imageData[fieldName] = _field.val();\n                        }\n                    }.bind(this));\n                    flagChecked = this.element.find(this._videoDisableinputSelector).prop('checked') ? 1 : 0;\n                    this._gallery.find('input[name*=\"' + itemId + '][disabled]\"]').val(flagChecked);\n                    this._gallery.find(_inputSelector).siblings('.image-fade').css(\n                        'visibility',\n                        flagChecked ? 'visible' : 'hidden'\n                    );\n                    imageData.disabled = flagChecked;\n\n                    if (this._tempPreviewImageData) {\n                        this._onImageLoaded(\n                            this._tempPreviewImageData,\n                            null,\n                            imageData.file,\n                            $.proxy(this.close, this)\n                        );\n\n                        return;\n                    }\n                    fileName = inputFile.get(0).files;\n\n                    if (!fileName || !fileName.length) {\n                        fileName = null;\n                    }\n                    inputFile.replaceWith(inputFile);\n\n                    callback = $.proxy(function () {\n                        this.close();\n                    }, this);\n\n                    if (fileName) {\n                        this._uploadImage(fileName, imageData.file, callback);\n                    } else {\n                        this._replaceImage(imageData.file, imageData.file, imageData);\n                        callback(0, imageData);\n                    }\n                },\n                this\n            ));\n        },\n\n        /**\n         * Delegates call to producwt gallery to update video visibility.\n         *\n         * @param {Object} imageData\n         */\n        _updateVisibility: function (imageData) {\n            this._gallery.trigger('updateVisibility', {\n                disabled: imageData.disabled,\n                imageData: imageData\n            });\n        },\n\n        /**\n         * Delegates call to product gallery to update video title.\n         *\n         * @param {Object} imageData\n         */\n        _updateImageTitle: function (imageData) {\n            this._gallery.trigger('updateImageTitle', {\n                imageData: imageData\n            });\n        },\n\n        /**\n         * Fired when clicked on cancel\n         * @private\n         */\n        _onCancel: function () {\n            this.close();\n        },\n\n        /**\n         * Fired when clicked on delete\n         * @private\n         */\n        _onDelete: function () {\n            var filename = this.element.find(this._videoImageFilenameselector).val();\n\n            this._removeImage(filename);\n            this.close();\n        },\n\n        /**\n         * @param {String} file\n         * @param {Function} callback\n         * @private\n         */\n        _readPreviewLocal: function (file, callback) {\n            var fr = new FileReader;\n\n            if (!window.FileReader) {\n                return;\n            }\n\n            /**\n             * On load end\n             */\n            fr.onloadend = function () {\n                callback(fr.result);\n            };\n            fr.readAsDataURL(file);\n        },\n\n        /**\n         *  Image file input handler\n         * @private\n         */\n        _onImageInputChange: function () {\n            var jFile = this.element.find(this._videoPreviewInputSelector),\n                file = jFile[0],\n                val = jFile.val(),\n                prev = this._getPreviewImage(),\n                ext = '.' + val.split('.').pop();\n\n            if (!val) {\n                return;\n            }\n            ext = ext ? ext.toLowerCase() : '';\n\n            if (\n                ext.length < 2 ||\n                this._imageTypes.indexOf(ext.toLowerCase()) === -1 || !file.files || !file.files.length\n            ) {\n                prev.remove();\n                this._previewImage = null;\n                jFile.val('');\n\n                return;\n            } // end if\n            file = file.files[0];\n            this._tempPreviewImageData = null;\n            this._onPreview(null, file, true);\n        },\n\n        /**\n         * Change Preview\n         * @param {String} error\n         * @param {String} src\n         * @param {Boolean} local\n         * @private\n         */\n        _onPreview: function (error, src, local) {\n            var img, renderImage;\n\n            img = this._getPreviewImage();\n\n            /**\n             * Callback\n             * @param {String} source\n             */\n            renderImage = function (source) {\n                img.attr({\n                    'src': source\n                }).show();\n            };\n\n            if (error) {\n                return;\n            }\n\n            if (!local) {\n                renderImage(src);\n            } else {\n                this._readPreviewLocal(src, renderImage);\n            }\n        },\n\n        /**\n         *\n         * Return preview image imstance\n         * @returns {null}\n         * @private\n         */\n        _getPreviewImage: function () {\n\n            if (!this._previewImage) {\n                this._previewImage = $(document.createElement('img')).css({\n                    'width': '100%',\n                    'display': 'none',\n                    'src': ''\n                });\n                $(this._previewImage).insertAfter(this.element.find(this._videoPreviewImagePointer));\n                $(this._previewImage).attr('data-role', 'video_preview_image');\n            }\n\n            return this._previewImage;\n        },\n\n        /**\n         * Close slideout dialog\n         */\n        close: function () {\n            this.element.modal('closeModal');\n        },\n\n        /**\n         * Close dialog wrap\n         * @private\n         */\n        _onClose: function () {\n            var newVideoForm;\n\n            this._isEditPage = true;\n            this.imageData = null;\n\n            if (this._previewImage) {\n                this._previewImage.remove();\n                this._previewImage = null;\n            }\n            this._tempPreviewImageData = null;\n            this.element.trigger('reset');\n            newVideoForm = this.element.find(this._videoFormSelector);\n\n            $(newVideoForm).find('input[type=\"hidden\"][name!=\"form_key\"]').val('');\n            this._gallery.find(\n                'input[name*=\"' + this.element.find(this._itemIdSelector).val() + '\"]'\n            ).parent().removeClass('active');\n\n            try {\n                newVideoForm.validation('clearError');\n            } catch (e) {\n\n            }\n            newVideoForm.trigger('reset');\n        },\n\n        /**\n         * Find element by fileName\n         * @param {String} file\n         */\n        findElementId: function (file) {\n            var elem = this._gallery.find('.image.item').find('input[value=\"' + file + '\"]');\n\n            if (!elem.length) {\n                return null;\n            }\n\n            return $(elem).attr('name').replace('product[media_gallery][images][', '').replace('][file]', '');\n        },\n\n        /**\n         * Save image roles\n         * @param {Object} imageData\n         */\n        saveImageRoles: function (imageData) {\n            var data = imageData.file,\n                self = this,\n                containers;\n\n            if (data && data.length > 0) {\n                containers = this._gallery.find('.image-placeholder').siblings('input');\n                $.each(containers, function (i, el) {\n                    var start = el.name.indexOf('[') + 1,\n                        end = el.name.indexOf(']'),\n                        imageType = el.name.substring(start, end),\n                        imageCheckbox = self.element.find(\n                            self._videoFormSelector + ' input[value=\"' + imageType + '\"]'\n                        );\n\n                    self._changeRole(imageType, imageCheckbox.prop('checked'), imageData);\n                });\n            }\n        },\n\n        /**\n         * Change image role\n         * @param {String} imageType - role name\n         * @param {bool} isEnabled - role active status\n         * @param {Object} imageData - image data object\n         * @private\n         */\n        _changeRole: function (imageType, isEnabled, imageData) {\n            var needCheked = true;\n\n            if (!isEnabled) {\n                needCheked = this._gallery.find('input[name=\"product[' + imageType + ']\"]').val() === imageData.file;\n            }\n\n            if (!needCheked) {\n                return null;\n            }\n\n            this._gallery.trigger('setImageType', {\n                type: imageType,\n                imageData: isEnabled ? imageData : null\n            });\n        },\n\n        /**\n         * On open dialog\n         * @param {Object} e\n         * @param {Object} imageData\n         * @private\n         */\n        _onOpenDialog: function (e, imageData) {\n            var formFields, flagChecked, file,\n                modal = this.element.closest('.mage-new-video-dialog');\n\n            if (imageData['media_type'] === 'external-video') {\n                this.imageData = imageData;\n                modal.find('.video-create-button').hide();\n                modal.find('.video-delete-button').show();\n                modal.find('.video-edit').show();\n                modal.createVideoPlayer({\n                    reset: true\n                }).createVideoPlayer('reset');\n\n                formFields = modal.find(this._videoFormSelector).find('.edited-data');\n\n                $.each(formFields, function (i, field) {\n                    $(field).val(imageData[field.name]);\n                });\n\n                flagChecked = imageData.disabled > 0;\n                modal.find(this._videoDisableinputSelector).prop('checked', flagChecked);\n\n                file = modal.find('#file_name').val(imageData.file);\n\n                $.each(modal.find('.video_image_role'), function () {\n                    $(this).prop('checked', false).prop('disabled', false);\n                });\n\n                $.each(this._gallery.find('.image-placeholder').siblings('input:hidden'), function () {\n                    var start, end, imageRole;\n\n                    if ($(this).val() === file.val()) {\n                        start = this.name.indexOf('[') + 1;\n                        end = this.name.length - 1;\n                        imageRole = this.name.substring(start, end);\n                        modal.find('#new_video_form input[value=\"' + imageRole + '\"]').prop('checked', true);\n                    }\n                });\n            }\n\n        },\n\n        /**\n         * Toggle buttons\n         */\n        toggleButtons: function () {\n            var self = this,\n                modal = this.element.closest('.mage-new-video-dialog');\n\n            modal.find('.video-placeholder, .add-video-button-container > button').click(function () {\n                modal.find('.video-create-button').show();\n                modal.find('.video-delete-button').hide();\n                modal.find('.video-edit').hide();\n                modal.createVideoPlayer({\n                    reset: true\n                }).createVideoPlayer('reset').updateInputFields({\n                    reset: true\n                }).updateInputFields('reset');\n            });\n            this._gallery.on('click', '.item.video-item', function () {\n                modal.find('.video-create-button').hide();\n                modal.find('.video-delete-button').show();\n                modal.find('.video-edit').show();\n                modal.find('.mage-new-video-dialog').createVideoPlayer({\n                    reset: true\n                }).createVideoPlayer('reset');\n            });\n            this._gallery.on('click', '.item.video-item:not(.removed)', function () {\n                var flagChecked,\n                    file,\n                    formFields = modal.find('.edited-data'),\n                    container = $(this);\n\n                $.each(formFields, function (i, field) {\n                    $(field).val(container.find('input[name*=\"' + field.name + '\"]').val());\n                });\n\n                flagChecked = container.find('input[name*=\"disabled\"]').val() > 0;\n                self._gallery.find(self._videoDisableinputSelector).prop('checked', flagChecked);\n\n                file = self._gallery.find('#file_name').val(container.find('input[name*=\"file\"]').val());\n\n                $.each(self._gallery.find('.video_image_role'), function () {\n                    $(this).prop('checked', false).prop('disabled', false);\n                });\n\n                $.each(self._gallery.find('.image-placeholder').siblings('input:hidden'), function () {\n                    var start, end, imageRole;\n\n                    if ($(this).val() !== file.val()) {\n                        return null;\n                    }\n\n                    start = this.name.indexOf('[') + 1;\n                    end = this.name.length - 1;\n                    imageRole = this.name.substring(start, end);\n                    self._gallery.find('input[value=\"' + imageRole + '\"]').prop('checked', true);\n                });\n            });\n        }\n    });\n\n    $('#group-fields-image-management > legend > span').text($.mage.__('Images and Videos'));\n\n    return $.mage.newVideoDialog;\n});\n","Magento_ProductVideo/js/video-modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'productGallery',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/backend/tree-suggest',\n    'mage/backend/validation',\n    'newVideoDialog'\n], function ($, productGallery) {\n    'use strict';\n\n    $.widget('mage.productGallery', productGallery, {\n\n        /**\n         * Bind events\n         * @private\n         */\n        _bind: function () {\n            var events = {},\n                itemId;\n\n            this._super();\n\n            /**\n             * Add item_id value to opened modal\n             * @param {Object} event\n             */\n            events['click ' + this.options.imageSelector] = function (event) {\n                if (!$(event.currentTarget).is('.ui-sortable-helper')) {\n                    itemId = $(event.currentTarget).find('input')[0].name.match(/\\[([^\\]]*)\\]/g)[2];\n                    this.videoDialog.find('#item_id').val(itemId);\n                }\n            };\n            this._on(events);\n            this.element.prev().find('[data-role=\"add-video-button\"]').on('click', this.showModal.bind(this));\n            this.element.on('openDialog', '.gallery.ui-sortable', $.proxy(this._onOpenDialog, this));\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this._super();\n            this.videoDialog = this.element.find('#new-video');\n            this.videoDialog.mage('newVideoDialog', this.videoDialog.data('modalInfo'));\n        },\n\n        /**\n         * Open dialog for external video\n         * @private\n         */\n        _onOpenDialog: function (e, imageData) {\n\n            if (imageData['media_type'] !== 'external-video') {\n                this._superApply(arguments);\n            } else {\n                this.showModal();\n            }\n        },\n\n        /**\n         * Fired on trigger \"openModal\"\n         */\n        showModal: function () {\n            this.videoDialog.modal('openModal');\n        }\n    });\n\n    return $.mage.productGallery;\n});\n","Magento_ProductVideo/js/get-video-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate'\n], function ($, alert) {\n        'use strict';\n\n        var videoRegister = {\n            _register: {},\n\n            /**\n             * Checks, if api is already registered\n             *\n             * @param {String} api\n             * @returns {bool}\n             */\n            isRegistered: function (api) {\n                return this._register[api] !== undefined;\n            },\n\n            /**\n             * Checks, if api is loaded\n             *\n             * @param {String} api\n             * @returns {bool}\n             */\n            isLoaded: function (api) {\n                return this._register[api] !== undefined && this._register[api] === true;\n            },\n\n            /**\n             * Register new video api\n             * @param {String} api\n             * @param {bool} loaded\n             */\n            register: function (api, loaded) {\n                loaded = loaded || false;\n                this._register[api] = loaded;\n            }\n        };\n\n        $.widget('mage.productVideoLoader', {\n\n            /**\n             * @private\n             */\n            _create: function () {\n                switch (this.element.data('type')) {\n                    case 'youtube':\n                        this.element.videoYoutube();\n                        this._player = this.element.data('mageVideoYoutube');\n                        break;\n\n                    case 'vimeo':\n                        this.element.videoVimeo();\n                        this._player = this.element.data('mageVideoVimeo');\n                        break;\n                    default:\n                        throw {\n                            name: $.mage.__('Video Error'),\n                            message: $.mage.__('Unknown video type'),\n\n                            /**\n                             * Return string\n                             */\n                            toString: function () {\n                                return this.name + ': ' + this.message;\n                            }\n                        };\n                }\n            },\n\n            /**\n             * Initializes variables\n             * @private\n             */\n            _initialize: function () {\n                this._params = this.element.data('params') || {};\n                this._code = this.element.data('code');\n                this._width = this.element.data('width');\n                this._height = this.element.data('height');\n                this._autoplay = !!this.element.data('autoplay');\n                this._playing = this._autoplay || false;\n                this.useYoutubeNocookie = this.element.data('youtubenocookie') || false;\n\n                this._responsive = this.element.data('responsive') !== false;\n\n                if (this._responsive === true) {\n                    this.element.addClass('responsive');\n                }\n\n                this._calculateRatio();\n            },\n\n            /**\n             * Abstract play command\n             */\n            play: function () {\n                this._player.play();\n            },\n\n            /**\n             * Abstract pause command\n             */\n            pause: function () {\n                this._player.pause();\n            },\n\n            /**\n             * Abstract stop command\n             */\n            stop: function () {\n                this._player.stop();\n            },\n\n            /**\n             * Abstract playing command\n             */\n            playing: function () {\n                return this._player.playing();\n            },\n\n            /**\n             * Abstract destroying command\n             */\n            destroy: function () {\n                if (this._player) {\n                    this._player.destroy();\n                }\n            },\n\n            /**\n             * Calculates ratio for responsive videos\n             * @private\n             */\n            _calculateRatio: function () {\n                if (!this._responsive) {\n                    return;\n                }\n                this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n            }\n        });\n\n        $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n            /**\n             * Initialization of the Youtube widget\n             * @private\n             */\n            _create: function () {\n                var self = this;\n\n                this._initialize();\n\n                this.element.append('<div></div>');\n\n                this._on(window, {\n\n                    /**\n                     * Youtube state check\n                     * @private\n                     */\n                    'youtubeapiready': function () {\n                        var host = 'https://www.youtube.com';\n\n                        if (self.useYoutubeNocookie) {\n                            host = 'https://www.youtube-nocookie.com';\n                        }\n\n                        if (self._player !== undefined) {\n                            return;\n                        }\n\n                        if (self._autoplay) {\n                            self._params.autoplay = 1;\n                        }\n                        self._params.rel = 0;\n\n                        self._player = new window.YT.Player(self.element.children(':first')[0], {\n                            height: self._height,\n                            width: self._width,\n                            videoId: self._code,\n                            playerVars: self._params,\n                            host: host,\n                            events: {\n\n                                /**\n                                 * @private\n                                 */\n                                'onReady': function onPlayerReady() {\n                                    self._player.getDuration();\n                                },\n\n                                /**\n                                 * State change flag init\n                                 */\n                                onStateChange: function (data) {\n                                    switch (window.parseInt(data.data, 10)) {\n                                        case 1:\n                                            self._playing = true;\n                                            break;\n                                        default:\n                                            self._playing = false;\n                                            break;\n                                    }\n\n                                    self._trigger('statechange', {}, data);\n                                }\n                            }\n\n                        });\n                    }\n                });\n\n                this._loadApi();\n            },\n\n            /**\n             * Loads Youtube API and triggers event, when loaded\n             * @private\n             */\n            _loadApi: function () {\n                var element,\n                    scriptTag;\n\n                if (videoRegister.isRegistered('youtube')) {\n                    if (videoRegister.isLoaded('youtube')) {\n                        $(window).trigger('youtubeapiready');\n                    }\n\n                    return;\n                }\n                videoRegister.register('youtube');\n\n                element = document.createElement('script');\n                scriptTag = document.getElementsByTagName('script')[0];\n\n                element.async = true;\n                element.src = 'https://www.youtube.com/iframe_api';\n                scriptTag.parentNode.insertBefore(element, scriptTag);\n\n                /**\n                 * Trigger youtube api ready event\n                 */\n                window.onYouTubeIframeAPIReady = function () {\n                    $(window).trigger('youtubeapiready');\n                    videoRegister.register('youtube', true);\n                };\n            },\n\n            /**\n             * Play command for Youtube\n             */\n            play: function () {\n                this._player.playVideo();\n                this._playing = true;\n            },\n\n            /**\n             * Pause command for Youtube\n             */\n            pause: function () {\n                this._player.pauseVideo();\n                this._playing = false;\n            },\n\n            /**\n             * Stop command for Youtube\n             */\n            stop: function () {\n                this._player.stopVideo();\n                this._playing = false;\n            },\n\n            /**\n             * Playing command for Youtube\n             */\n            playing: function () {\n                return this._playing;\n            },\n\n            /**\n             * stops and unloads player\n             * @private\n             */\n            destroy: function () {\n                if (this._player) {\n                    this.stop();\n                    this._player.destroy();\n                    this._player = undefined;\n                }\n            }\n        });\n\n        $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n            /**\n             * Initialize the Vimeo widget\n             * @private\n             */\n            _create: function () {\n                var timestamp,\n                    src,\n                    additionalParams;\n\n                this._initialize();\n                timestamp = new Date().getTime();\n\n                if (this._autoplay) {\n                    additionalParams += '&autoplay=1';\n                }\n\n                src = 'https://player.vimeo.com/video/' +\n                    this._code + '?api=1&player_id=vimeo' +\n                    this._code +\n                    timestamp +\n                    additionalParams;\n                this.element.append(\n                    $('<iframe></iframe>')\n                        .attr('frameborder', 0)\n                        .attr('id', 'vimeo' + this._code + timestamp)\n                        .attr('width', this._width)\n                        .attr('height', this._height)\n                        .attr('src', src)\n                );\n\n            }\n        });\n\n        $.widget('mage.videoData', {\n            options: {\n                youtubeKey: '',\n                eventSource: '' //where is data going from - focus out or click on button\n            },\n\n            _REQUEST_VIDEO_INFORMATION_TRIGGER: 'request_video_information',\n\n            _UPDATE_VIDEO_INFORMATION_TRIGGER: 'updated_video_information',\n\n            _START_UPDATE_INFORMATION_TRIGGER: 'update_video_information',\n\n            _ERROR_UPDATE_INFORMATION_TRIGGER: 'error_updated_information',\n\n            _FINISH_UPDATE_INFORMATION_TRIGGER: 'finish_update_information',\n\n            _VIDEO_URL_VALIDATE_TRIGGER: 'validate_video_url',\n\n            _videoInformation: null,\n\n            _currentVideoUrl: null,\n\n            /**\n             * @private\n             */\n            _init: function () {\n                this.element.on(this._START_UPDATE_INFORMATION_TRIGGER, $.proxy(this._onRequestHandler, this));\n                this.element.on(this._ERROR_UPDATE_INFORMATION_TRIGGER, $.proxy(this._onVideoInvalid, this));\n                this.element.on(this._FINISH_UPDATE_INFORMATION_TRIGGER, $.proxy(\n                    function () {\n                        this._currentVideoUrl = null;\n                    }, this\n                ));\n                this.element.on(this._VIDEO_URL_VALIDATE_TRIGGER, $.proxy(this._onUrlValidateHandler, this));\n            },\n\n            /**\n             * @private\n             */\n            _onUrlValidateHandler: function (event, callback, forceVideo) {\n                var url = this.element.val(),\n                    videoInfo;\n\n                videoInfo = this._validateURL(url, forceVideo);\n\n                if (videoInfo) {\n                    callback();\n                } else {\n                    this._onRequestError($.mage.__('Invalid video url'));\n                }\n            },\n\n            /**\n             * @private\n             */\n            _onRequestHandler: function () {\n                var url = this.element.val(),\n                    self = this,\n                    videoInfo,\n                    type,\n                    id,\n                    googleapisUrl;\n\n                if (this._currentVideoUrl === url) {\n                    return;\n                }\n\n                this._currentVideoUrl = url;\n\n                this.element.trigger(this._REQUEST_VIDEO_INFORMATION_TRIGGER, {\n                    url: url\n                });\n\n                if (!url) {\n                    return;\n                }\n\n                videoInfo = this._validateURL(url);\n\n                if (!videoInfo) {\n                    this._onRequestError($.mage.__('Invalid video url'));\n\n                    return;\n                }\n\n                /**\n                 *\n                 * @param {Object} data\n                 * @private\n                 */\n                function _onYouTubeLoaded(data) {\n                    var tmp,\n                        uploadedFormatted,\n                        respData,\n                        createErrorMessage;\n\n                    /**\n                     * Create errors message\n                     *\n                     * @returns {String}\n                     */\n                    createErrorMessage = function () {\n                        var error = data.error,\n                            errors = error.errors,\n                            i,\n                            errLength = errors.length,\n                            tmpError,\n                            errReason,\n                            errorsMessage = [];\n\n                        for (i = 0; i < errLength; i++) {\n                            tmpError = errors[i];\n                            errReason = tmpError.reason;\n\n                            if (['keyInvalid'].indexOf(errReason) !== -1) {\n                                errorsMessage.push($.mage.__('Youtube API key is invalid'));\n\n                                break;\n                            }\n\n                            errorsMessage.push(tmpError.message);\n                        }\n\n                        return $.mage.__('Video cant be shown due to the following reason: ') +\n                            $.unique(errorsMessage).join(', ');\n                    };\n\n                    if (data.error && [400, 402, 403].indexOf(data.error.code) !== -1) {\n                        this._onRequestError(createErrorMessage());\n\n                        return;\n                    }\n\n                    if (!data.items || data.items.length < 1) {\n                        this._onRequestError($.mage.__('Video not found'));\n\n                        return;\n                    }\n\n                    tmp = data.items[0];\n                    uploadedFormatted = tmp.snippet.publishedAt.replace('T', ' ').replace(/\\..+/g, '');\n                    respData = {\n                        duration: this._formatYoutubeDuration(tmp.contentDetails.duration),\n                        channel: tmp.snippet.channelTitle,\n                        channelId: tmp.snippet.channelId,\n                        uploaded: uploadedFormatted,\n                        title: tmp.snippet.localized.title,\n                        description: tmp.snippet.description,\n                        thumbnail: tmp.snippet.thumbnails.high.url,\n                        videoId: videoInfo.id,\n                        videoProvider: videoInfo.type,\n                        useYoutubeNocookie: videoInfo.useYoutubeNocookie\n                    };\n                    this._videoInformation = respData;\n                    this.element.trigger(this._UPDATE_VIDEO_INFORMATION_TRIGGER, respData);\n                    this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, true);\n                }\n\n                /**\n                 * @private\n                 */\n                function _onVimeoLoaded(data) {\n                    var tmp,\n                        respData,\n                        videoDescription = '';\n\n                    if (!data) {\n                        this._onRequestError($.mage.__('Video not found'));\n\n                        return null;\n                    }\n                    tmp = data;\n\n                    if (tmp.description !== null) {\n                        videoDescription = tmp.description;\n                    }\n\n                    if (tmp.duration == null) {\n                        this._onRequestError(\n                            $.mage.__('Because of its privacy settings, this video cannot be played here.')\n                        );\n                    } else {\n                        respData = {\n                            duration: this._formatVimeoDuration(tmp.duration),\n                            channel: tmp['author_name'],\n                            channelId: tmp['author_url'],\n                            uploaded: tmp['upload_date'],\n                            title: tmp.title,\n                            description: videoDescription.replace(/(&nbsp;|<([^>]+)>)/ig, ''),\n                            thumbnail: tmp['thumbnail_url'],\n                            videoId: videoInfo.id,\n                            videoProvider: videoInfo.type\n                        };\n                        this._videoInformation = respData;\n                        this.element.trigger(this._UPDATE_VIDEO_INFORMATION_TRIGGER, respData);\n                        this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, true);\n                    }\n                }\n\n                type = videoInfo.type;\n                id = videoInfo.id;\n\n                if (type === 'youtube') {\n                    googleapisUrl = 'https://www.googleapis.com/youtube/v3/videos?id=' +\n                        id +\n                        '&part=snippet,contentDetails&key=' +\n                        this.options.youtubeKey + '&alt=json&callback=?';\n                    $.getJSON(googleapisUrl,\n                        {\n                            format: 'json'\n                        },\n                        $.proxy(_onYouTubeLoaded, self)\n                    ).fail(\n                        function () {\n                            self._onRequestError('Video not found');\n                        }\n                    );\n                } else if (type === 'vimeo') {\n                    $.ajax({\n                        url: 'https://vimeo.com/api/oembed.json',\n                        dataType: 'jsonp',\n                        data: {\n                            format: 'json',\n                            url: 'https://vimeo.com/' + id\n                        },\n                        timeout: 5000,\n                        success:  $.proxy(_onVimeoLoaded, self),\n\n                        /**\n                         * @private\n                         */\n                        error: function () {\n                            self._onRequestError($.mage.__('Video not found'));\n                        }\n                    });\n                }\n            },\n\n            /**\n             * @private\n             */\n            _onVideoInvalid: function (event, data) {\n                this._videoInformation = null;\n                this.element.val('');\n                alert({\n                    content: 'Error: \"' + data + '\"'\n                });\n            },\n\n            /**\n             * @private\n             */\n            _onRequestError: function (error) {\n                this.element.trigger(this._ERROR_UPDATE_INFORMATION_TRIGGER, error);\n                this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, false);\n                this._currentVideoUrl = null;\n            },\n\n            /**\n             * @private\n             */\n            _formatYoutubeDuration: function (duration) {\n                var match = duration.match(/PT(\\d+H)?(\\d+M)?(\\d+S)?/),\n                    hours = parseInt(match[1], 10) || 0,\n                    minutes = parseInt(match[2], 10) || 0,\n                    seconds = parseInt(match[3], 10) || 0;\n\n                return this._formatVimeoDuration(hours * 3600 + minutes * 60 + seconds);\n            },\n\n            /**\n             * @private\n             */\n            _formatVimeoDuration: function (seconds) {\n                return new Date(seconds * 1000).toUTCString().match(/(\\d\\d:\\d\\d:\\d\\d)/)[0];\n            },\n\n            /**\n             * @private\n             */\n            _parseHref: function (href) {\n                var a = document.createElement('a');\n\n                a.href = href;\n\n                return a;\n            },\n\n            /**\n             * @private\n             */\n            _validateURL: function (href, forceVideo) {\n                var id,\n                    type,\n                    ampersandPosition,\n                    vimeoRegex,\n                    useYoutubeNocookie = false;\n\n                if (typeof href !== 'string') {\n                    return href;\n                }\n                href = this._parseHref(href);\n\n                if (href.host.match(/youtube\\.com/) && href.search) {\n\n                    id = href.search.split('v=')[1];\n\n                    if (id) {\n                        ampersandPosition = id.indexOf('&');\n                        type = 'youtube';\n                    }\n\n                    if (id && ampersandPosition !== -1) {\n                        id = id.substring(0, ampersandPosition);\n                    }\n\n                } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n                    id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n                    type = 'youtube';\n\n                    if (href.host.match(/youtube-nocookie.com/)) {\n                        useYoutubeNocookie = true;\n                    }\n                } else if (href.host.match(/vimeo\\.com/)) {\n                    type = 'vimeo';\n                    vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                        '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n                    ].join(''));\n\n                    if (href.href.match(vimeoRegex) != null) {\n                        id = href.href.match(vimeoRegex)[3];\n                    }\n                }\n\n                if ((!id || !type) && forceVideo) {\n                    id = href.href;\n                    type = 'custom';\n                }\n\n                return id ? {\n                    id: id, type: type, s: href.search.replace(/^\\?/, ''), useYoutubeNocookie: useYoutubeNocookie\n                } : false;\n            }\n        });\n    });\n","Magento_InventoryCatalogAdminUi/js/product/form/source-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'uiRegistry',\n    'underscore'\n], function (Fieldset, registry, _) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            advancedInventoryButtonIndex: '',\n            imports: {\n                onStockChange: '${ $.provider }:data.product.stock_data.manage_stock'\n            }\n        },\n\n        /**\n         * \"Advanced Inventory\" button should stay active in any case.\n         *\n         * @param {Integer} canManageStock\n         */\n        onStockChange: function (canManageStock) {\n            var advancedInventoryButton = registry.get('index = ' + this.advancedInventoryButtonIndex);\n\n            if (canManageStock === 0) {\n                if (!_.isUndefined(advancedInventoryButton)) {\n                    advancedInventoryButton.disabled(false);\n                }\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            var initialValue;\n\n            this._super();\n            initialValue = this.source.data.product['current_product_id'] !== null ? this.initialValue : 0;\n\n            if (this.value() &&\n                parseFloat(initialValue) !== parseFloat(this.value())\n            ) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/stock-status.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            links: {\n                linkedValue: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            this._super();\n\n            if (parseFloat(this.initialValue) !== parseFloat(this.value())) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/sources/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Validator) {\n    'use strict';\n\n    return Validator.extend({\n\n        /**\n         * Set default value for source quantity, depends on 'Use Decimal\" value.\n         *\n         * @param {Integer} isDecimal\n         * @returns void\n         */\n        setDefaultValue: function (isDecimal) {\n            if (!this.value()) {\n                isDecimal ? this.value('0.0') : this.value('0');\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/attribute/edit/inventory/toggle/toggle-editability.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $('[data-role=toggle-editability]').on('change', function () {\n        var useConfigSettings = $(this),\n            field = useConfigSettings.parents('.field'),\n            someEditable = $('input[type!=\"checkbox\"], select, textarea', field);\n\n        someEditable.prop('disabled', useConfigSettings.prop('checked'));\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/attribute/edit/inventory/toggle/toggle-editability-all.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $('[data-role=toggle-editability-all]').on('change', function () {\n        var toggler = $(this),\n            field = toggler.parents('.field'),\n            someEditable = $('input[type!=\"checkbox\"], select, textarea', field),\n            someEditableCheckboxes = $('input[type=\"checkbox\"]', field).not(toggler);\n\n        if (someEditableCheckboxes.length) {\n            someEditable.prop('disabled', !toggler.prop('checked') || someEditableCheckboxes.prop('checked'));\n            someEditableCheckboxes.prop('disabled', !toggler.prop('checked'));\n        } else {\n            someEditable.prop('disabled', !toggler.prop('checked'));\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/grid/cell/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryCatalogAdminUi/product/grid/cell/source-items.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         * Get source items data (source name and qty)\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsData: function (record) {\n            return record[this.index] ? record[this.index] : [];\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsDataCut: function (record) {\n            return this.getSourceItemsData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_AdminNotification/toolbar_entry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'domReady!'\n], function ($) {\n    'use strict';\n\n    /**\n     * Mark notification as read via AJAX call.\n     *\n     * @param {String} notificationId\n     */\n    var markNotificationAsRead = function (notificationId) {\n            var requestUrl = $('.notifications-wrapper .admin__action-dropdown-menu').attr('data-mark-as-read-url');\n\n            $.ajax({\n                url: requestUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: {\n                    id: notificationId\n                },\n                showLoader: false\n            });\n        },\n        notificationCount = $('.notifications-wrapper').attr('data-notification-count'),\n\n        /**\n         * Remove notification from the list.\n         *\n         * @param {jQuery} notificationEntry\n         */\n        removeNotificationFromList = function (notificationEntry) {\n            var notificationIcon, actionElement;\n\n            notificationEntry.remove();\n            notificationCount--;\n            $('.notifications-wrapper').attr('data-notification-count', notificationCount);\n\n            if (notificationCount == 0) {// eslint-disable-line eqeqeq\n                // Change appearance of the bubble and its behavior when the last notification is removed\n                $('.notifications-wrapper .admin__action-dropdown-menu').remove();\n                notificationIcon = $('.notifications-wrapper .notifications-icon');\n                notificationIcon.removeAttr('data-toggle');\n                notificationIcon.off('click.dropdown');\n                $('.notifications-action .notifications-counter').text('').hide();\n            } else {\n                // Change top counter only for allowable range\n                if (notificationCount <= 99) {\n                    $('.notifications-action .notifications-counter').text(notificationCount);\n                }\n                $('.notifications-entry-last .notifications-counter').text(notificationCount);\n                // Modify caption of the 'See All' link\n                actionElement = $('.notifications-wrapper .admin__action-dropdown-menu .last .action-more');\n                actionElement.text(actionElement.text().replace(/\\d+/, notificationCount));\n            }\n        },\n\n        /**\n         * Show notification details.\n         *\n         * @param {jQuery} notificationEntry\n         */\n        showNotificationDetails = function (notificationEntry) {\n            var notificationDescription = notificationEntry.find('.notifications-entry-description'),\n                notificationDescriptionEnd = notificationEntry.find('.notifications-entry-description-end');\n\n            if (notificationDescriptionEnd.length > 0) {\n                notificationDescriptionEnd.addClass('_show');\n            }\n\n            if (notificationDescription.hasClass('_cutted')) {\n                notificationDescription.removeClass('_cutted');\n            }\n        };\n\n    // Show notification description when corresponding item is clicked\n    $('.notifications-wrapper .admin__action-dropdown-menu .notifications-entry').on(\n        'click.showNotification',\n        function (event) {\n            // hide notification dropdown\n            $('.notifications-wrapper .notifications-icon').trigger('click.dropdown');\n\n            showNotificationDetails($(this));\n            event.stopPropagation();\n        }\n    );\n\n    // Remove corresponding notification from the list and mark it as read\n    $('.notifications-close').on('click.removeNotification', function (event) {\n        var notificationEntry = $(this).closest('.notifications-entry'),\n            notificationId = notificationEntry.attr('data-notification-id');\n\n        markNotificationAsRead(notificationId);\n        removeNotificationFromList(notificationEntry);\n\n        // Checking for last unread notification to hide dropdown\n        if (notificationCount == 0) {// eslint-disable-line eqeqeq\n            $('.notifications-wrapper').removeClass('active')\n                .find('.notifications-action')\n                .removeAttr('data-toggle')\n                .off('click.dropdown');\n        }\n        event.stopPropagation();\n    });\n\n    // Hide notifications bubble\n    if (notificationCount == 0) {// eslint-disable-line eqeqeq\n        $('.notifications-action .notifications-counter').hide();\n    } else {\n        $('.notifications-action .notifications-counter').show();\n    }\n});\n","Magento_AdminNotification/js/system/messages/popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($, modal) {\n    'use strict';\n\n    return function (data, element) {\n\n        if (modal.modal) {\n            modal.modal.html($(element).html());\n        } else {\n            modal.modal = $(element).modal({\n                modalClass: data.class,\n                type: 'popup',\n                buttons: []\n            });\n        }\n\n        modal.modal.modal('openModal');\n    };\n});\n","Magento_AdminNotification/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/grid/listing',\n    'Magento_Ui/js/lib/spinner',\n    'jquery'\n], function (Listing, loader, $) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            imports: {\n                totalRecords: '${ $.provider }:data.totalRecords'\n            },\n            selectors: {\n                collapsible: '.message-system-collapsible',\n                messages: '.message-system'\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .track({\n                    totalRecords: 0\n                });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        showLoader: function () {\n            if (!this.source.firstLoad) {\n                this.fixLoaderHeight();\n                this._super();\n            }\n        },\n\n        /**\n         * Calculates loader height\n         *\n         * @param {Boolean} [closed]\n         */\n        fixLoaderHeight: function (closed) {\n            var $messagesBlock = $(this.selectors.messages),\n                $collapsibleBlock = $(this.selectors.collapsible),\n                resultHeight = 0;\n\n            if ($messagesBlock.length) {\n                resultHeight += $messagesBlock.outerHeight();\n            }\n\n            if ($collapsibleBlock.length && $collapsibleBlock.is(':visible') && !closed) {\n                resultHeight += $collapsibleBlock.outerHeight();\n            }\n\n            loader.get(this.name).height(resultHeight);\n        }\n    });\n});\n","Magento_AdminNotification/js/grid/columns/message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_AdminNotification/grid/cells/message',\n            messageIndex: 'text',\n            fieldClass: {\n                message: true,\n                'message-warning': false,\n                'message-progress': false,\n                'message-success': false,\n                'message-error': false\n            },\n            statusMap: {\n                0: 'info',\n                1: 'progress',\n                2: 'success',\n                3: 'error'\n            }\n        },\n\n        /** @inheritdoc */\n        getLabel: function (record) {\n            return record[this.messageIndex];\n        },\n\n        /**\n         * Proxy to getLabel function with UnsanitizedHtml suffix\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getLabelUnsanitizedHtml: function (record) {\n            return this.getLabel(record);\n        },\n\n        /** @inheritdoc */\n        getFieldClass: function ($row) {\n            var status = this.statusMap[$row.status] || 'warning',\n                result = {};\n\n            result['message-' + status] = true;\n            result = _.extend({}, this.fieldClass, result);\n\n            return result;\n        }\n    });\n});\n","Magento_AdminNotification/system/notification.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.systemMessageDialog', $.mage.modal, {\n        options: {\n            modalClass: 'modal-system-messages',\n            systemMessageTemplate:\n                '<% _.each(data.items, function(item) { %>' +\n                    '<li class=\"message message-warning' +\n                        '<% if (item.severity == 1) { %>error<% } else { %>warning<% } %>\">' +\n                        '<%= item.text %>' +\n                    '</li>' +\n                '<% }); %>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.options.title = $('#message-system-all').attr('title');\n            this._super();\n        },\n\n        /** @inheritdoc */\n        openModal: function (severity) {\n            var superMethod = $.proxy(this._super, this);\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'GET',\n                data: {\n                    severity: severity\n                }\n            }).done($.proxy(function (data) {\n                var tmpl = mageTemplate(this.options.systemMessageTemplate, {\n                    data: {\n                        items: data\n                    }\n                });\n\n                tmpl = $(tmpl);\n\n                this.element.html(\n                    $('<ul></ul>', {\n                        'class': 'message-system-list'\n                    }).append(tmpl)\n                ).trigger('contentUpdated');\n\n                superMethod();\n            }, this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        closeModal: function () {\n            this._super();\n        }\n    });\n\n    $(function () {\n        $('#system_messages .message-system-short .error').on('click', function () {\n            $('#message-system-all').systemMessageDialog('openModal', 1);\n        });\n\n        $('#system_messages .message-system-short .warning').on('click', function () {\n            $('#message-system-all').systemMessageDialog('openModal', 2);\n        });\n    });\n\n    return $.mage.systemMessageDialog;\n});\n","Magento_AdobeStockImageAdminUi/js/panel.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'jquery',\n    'mage/translate'\n], function (Element, $, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            containerId: '#adobe-stock-images-search-modal',\n            masonryComponentPath: 'adobe_stock_images_listing.adobe_stock_images_listing.adobe_stock_images_columns',\n            dataSourcePath: 'adobe_stock_images_listing.adobe_stock_images_listing_data_source',\n            modules: {\n                masonry: '${ $.masonryComponentPath }',\n                source: '${ $.dataSourcePath }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n\n            $(this.containerId).modal({\n                type: 'slide',\n                buttons: [],\n                modalClass: 'adobe-stock-modal',\n                title: $t('Adobe Stock')\n            }).on('openModal', function () {\n                this.masonry().setLayoutStylesWhenLoaded();\n            }.bind(this));\n\n            try {\n                $(this.containerId).applyBindings();\n            } catch (e) {\n                //already bounded\n            }\n\n            $(window).on('fileDeleted.mediabrowser', this.reloadGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Update listing data\n         */\n        reloadGrid: function () {\n            this.source().set('params.t', Date.now());\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/path-utility.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * Extracts image name from its path\n         *\n         * @param {String} path\n         * @returns {String}\n         */\n        getImageNameFromPath: function (path) {\n            var filePathArray = path.split('/'),\n                imageIndex = filePathArray.length - 1;\n\n            return filePathArray[imageIndex].substring(0, filePathArray[imageIndex].lastIndexOf('.'));\n        },\n\n        /**\n         * Generate meaningful name image file,\n         * allow only alphanumerics, dashes, and underscores\n         *\n         * @param {String} title\n         * @param {Number} id\n         * @return string\n         */\n        generateImageName: function (title, id) {\n            var fileName = title.substring(0, 32)\n                .replace(/[^a-zA-Z0-9_]/g, '-')\n                .replace(/-{2,}/g, '-')\n                .toLowerCase();\n\n            /* If the filename does not contain latin chars, use ID as a filename */\n            return fileName === '-' ? id : fileName;\n        },\n\n        /**\n         * Get image file extension\n         *\n         * @param {String} contentType\n         * @return string\n         */\n        getImageExtension: function (contentType) {\n            return contentType.match(/[^/]{1,4}$/);\n        },\n\n        /**\n         * Create path\n         *\n         * @param {String} directoryPath\n         * @param {String} fileName\n         * @param {String} contentType\n         * @returns {String}\n         */\n        buildPath: function (directoryPath, fileName, contentType) {\n            return directoryPath + '/' + fileName + '.' + this.getImageExtension(contentType);\n        }\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/signIn.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeIms/js/signIn',\n    'Magento_AdobeIms/js/action/authorization',\n    'Magento_Ui/js/modal/confirm'\n], function ($, signIn, auth, confirm) {\n    'use strict';\n\n    return signIn.extend({\n\n        defaults: {\n            userQuota: {},\n            // eslint-disable-next-line max-len\n            dataProvider: 'name = adobe_stock_images_listing.adobe_stock_images_listing_data_source, ns = adobe_stock_images_listing',\n            // eslint-disable-next-line max-len\n            previewProvider: 'name = adobe_stock_images_listing.adobe_stock_images_listing.adobe_stock_images_columns.preview, ns = adobe_stock_images_listing',\n            quotaUrl: 'adobe_stock/license/quota',\n            modules: {\n                source: '${ $.dataProvider }',\n                preview: '${ $.previewProvider }'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super().observe(['userQuota']);\n\n            return this;\n        },\n\n        /**\n         * Login to Adobe\n         *\n         * @return {*}\n         */\n        login: function () {\n            var deferred = $.Deferred();\n\n            if (this.user().isAuthorized) {\n                return deferred.resolve();\n            }\n            auth(this.loginConfig)\n                .then(function (response) {\n                    this.loadUserProfile();\n                    deferred.resolve(response);\n                }.bind(this))\n                .fail(function (error) {\n                    deferred.reject(error);\n                });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Login action with popup on error..\n         */\n        loginClick: function () {\n            this.login().fail(function (error) {\n                this.showLoginErrorPopup(error);\n            }.bind(this));\n        },\n\n        /**\n         * Show popup that user failed to login.\n         */\n        showLoginErrorPopup: function (error) {\n            confirm({\n                title: $.mage.__('Couldn\\'t log you in'),\n                content: error,\n                buttons: [{\n                    text: $.mage.__('Ok'),\n                    class: 'action-primary action-accept'\n                }],\n                actions: {\n\n                    /**\n                       * Close modal\n                       */\n                    confirm: function (event) {\n                        this.closeModal(event);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Logout from adobe account\n         */\n        logout: function () {\n            $.ajax({\n                type: 'POST',\n                url: this.logoutUrl,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                dataType: 'json',\n                context: this,\n                showLoader: true,\n                success: function () {\n                    this.user({\n                        isAuthorized: false,\n                        name: '',\n                        email: '',\n                        image: this.defaultProfileImage\n                    });\n                }.bind(this),\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        },\n\n        /**\n         * Retrieves full user quota.\n         */\n        getUserQuota: function () {\n            $.ajax({\n                type: 'GET',\n                url: this.quotaUrl,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * @param {Object} response\n                 * @returns void\n                 */\n                success: function (response) {\n                    this.userQuota(response.result);\n                },\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        },\n\n        /**\n         * @inheritdoc\n         */\n        loadUserProfile: function () {\n            $.ajax({\n                type: 'GET',\n                url: this.profileUrl,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * @param {Object} response\n                 * @returns void\n                 */\n                success: function (response) {\n                    this.user({\n                        isAuthorized: true,\n                        name: response.result.name,\n                        email: response.result.email,\n                        image: response.result.image\n                    });\n                    this.getUserQuota();\n                },\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/media-gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Base64 */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm'\n], function ($, confirm) {\n    'use strict';\n\n    return {\n        jsTreeRootFolderId: 'root',\n        jsTreeFolderNameMaxLength: 20,\n\n        /**\n         * Locate downloaded image in media browser\n         *\n         * @param {String} path\n         */\n        locate: function (path) {\n            var imageFolder = this.selectFolder(path),\n                imageFilename = path.substring(path.lastIndexOf('/') + 1),\n                locatedImage;\n\n            if (imageFolder.length) {\n                locatedImage = $('div[data-row=\"file\"]:has(img[alt=\\\"' + imageFilename + '\\\"])');\n\n                return locatedImage.length ? locatedImage : false;\n            }\n\n            $.ajaxSetup({\n                async: true\n            });\n        },\n\n        /**\n         * Select folder\n         *\n         * @param {String} path\n         */\n        selectFolder: function (path) {\n            var imageFolder,\n                pathId,\n                imagePath = path.replace(/^\\/+/, ''),\n                folderPathParts = imagePath.split('/').slice(0, -1);\n\n            $.ajaxSetup({\n                async: false\n            });\n\n            if (folderPathParts.length > 1) {\n                this.openFolderTree(folderPathParts);\n            }\n\n            pathId = Base64.idEncode(folderPathParts.join('/'));\n            imageFolder = $('.jstree li[data-id=\"' + pathId + '\"]').children('a');\n\n            if (!imageFolder.length) {\n                imageFolder = $('.jstree li[data-id=\"' + this.jsTreeRootFolderId + '\"]')\n                    .children('a');\n            }\n\n            if (imageFolder.length) {\n                imageFolder[0].click();\n            }\n\n            return imageFolder;\n        },\n\n        /**\n         * Show popup that image cannot be located\n         */\n        notLocated: function () {\n            confirm({\n                title: $.mage.__('The image cannot be located'),\n                content: $.mage.__('We cannot find this image in the media gallery.'),\n                buttons: [{\n                    text: $.mage.__('Ok'),\n                    class: 'action-primary',\n                    attr: {},\n\n                    /**\n                     * Close modal on button click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }]\n            });\n        },\n\n        /**\n         * Open folder Tree\n         *\n         * @param {Array} folderPathParts\n         */\n        openFolderTree: function (folderPathParts) {\n            var i,\n                pathId,\n                openFolderButton,\n                folderPath = '';\n\n            for (i = 0; i < folderPathParts.length - 1; i++) {\n                if (folderPath === '') {\n                    folderPath = folderPathParts[i];\n                } else {\n                    folderPath = folderPath + '/' + folderPathParts[i];\n                }\n                pathId = Base64.idEncode(folderPath);\n                openFolderButton = $('.jstree li[data-id=\"' + pathId + '\"].jstree-closed').children('.jstree-icon');\n\n                if (openFolderButton.length) {\n                    openFolderButton.click();\n                }\n            }\n        }\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/components/images-grid-sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes',\n    'underscore'\n], function (Sizes, _) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            value: 32,\n            minSize: 1,\n            maxSize: 64\n        },\n\n        exports: {\n            value: '${ $.provider }:params.paging.page',\n            options: '${ $.provider }:params.paging.options'\n        },\n\n        sizes: {\n            '32': {\n                value: 32,\n                label: 32\n            },\n            '48': {\n                value: 48,\n                label: 48\n            },\n            '64': {\n                value: 64,\n                label: 64\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        updateArray: function () {\n            if (_.isUndefined(this.options)) {\n                this.options = this.sizes;\n            }\n\n            return this._super();\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/image-preview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'uiLayout',\n    'Magento_Ui/js/grid/columns/image-preview'\n], function ($, layout, imagePreview) {\n    'use strict';\n\n    return imagePreview.extend({\n        defaults: {\n            downloadImagePreviewUrl: 'adobe_stock/preview/download',\n            licenseAndDownloadUrl: 'adobe_stock/license/license',\n            saveLicensedAndDownloadUrl: 'adobe_stock/license/saveLicensed',\n            confirmationUrl: 'adobe_stock/license/confirmation',\n            relatedImagesUrl: 'adobe_stock/preview/relatedimages',\n            buyCreditsUrl: 'https://stock.adobe.com/',\n            mediaGallerySelector: '.media-gallery-modal:has(#search_adobe_stock)',\n            adobeStockModalSelector: '.adobe-search-images-modal',\n            activeMediaGallerySelector: 'aside.modal-slide.adobe-stock-modal._show',\n            modules: {\n                keywords: '${ $.name }_keywords',\n                related: '${ $.name }_related',\n                actions: '${ $.name }_actions'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/keywords',\n                    name: '${ $.name }_keywords'\n                },\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/related',\n                    name: '${ $.name }_related'\n                },\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/actions',\n                    name: '${ $.name }_actions',\n                    provider: '${ $.provider }',\n                    mediaGallery: '${ $.mediaGalleryComponent }',\n                    mediaGalleryName: '${ $.mediaGalleryName }',\n                    mediaGalleryProvider: '${ $.mediaGalleryProvider }',\n                    mediaGallerySortBy: '${ $.mediaGallerySortBy }',\n                    mediaGallerySearchInput: '${ $.mediaGallerySearchInput }',\n                    mediaGalleryListingFilters: '${ $.mediaGalleryListingFilters }',\n                    getMediaGalleryAsset: '${ $.getMediaGalleryAsset }',\n                    imageEditDetailsUrl: '${ $.imageEditDetailsUrl }',\n                    listingPaging: '${ $.listingPaging }'\n                }\n            ],\n            listens: {\n                '${ $.sortByComponentName }:applied': 'hide'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super().initView();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.reloadAdobeGrid.bind(this));\n            $(window).on('folderDeleted.enhancedMediaGallery', this.reloadAdobeGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Get previous button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewPrevious: function (record) {\n            return this.related().cannotViewPrevious(record);\n        },\n\n        /**\n         * Get next button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewNext: function (record) {\n            return this.related().cannotViewNext(record);\n        },\n\n        /**\n         * Return active adobe gallery selector.\n         */\n        getAdobeModal: function () {\n            return $(this.activeMediaGallerySelector).find(this.adobeStockModalSelector);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        next: function (record) {\n            if (this.related().selectedTab()) {\n                this.related().nextRelated(record);\n\n                return;\n            }\n            this.keywords().hideAllKeywords();\n            this._super(record);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        prev: function (record) {\n            if (this.related().selectedTab()) {\n                this.related().prevRelated(record);\n\n                return;\n            }\n            this.keywords().hideAllKeywords();\n            this._super(record);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        show: function (record) {\n            this.related().selectedTab(null);\n            this.keywords().hideAllKeywords();\n            this.displayedRecord(record);\n            this._super(record);\n            this.related().loadRelatedImages(record);\n        },\n\n        /**\n         * Show related image data in the preview section\n         *\n         * @param {Object} record\n         */\n        showRelated: function (record) {\n            this.keywords().hideAllKeywords();\n            this.displayedRecord(record);\n            this.updateHeight();\n        },\n\n        /**\n         * Returns attributes to display under the preview image\n         *\n         * @returns {*[]}\n         */\n        getDisplayAttributes: function () {\n            if (!this.displayedRecord()) {\n                return [];\n            }\n\n            return [\n                {\n                    name: 'Dimensions',\n                    value: this.displayedRecord().width + ' x ' + this.displayedRecord().height + ' px'\n                },\n                {\n                    name: 'File type',\n                    value: this.displayedRecord()['content_type'].toUpperCase()\n                },\n                {\n                    name: 'Category',\n                    value: this.displayedRecord().category.name || 'None'\n                },\n                {\n                    name: 'File #',\n                    value: this.displayedRecord().id\n                }\n            ];\n        },\n\n        /**\n         * Reload Adobe grid after deleting image\n         */\n        reloadAdobeGrid: function () {\n            this.actions().source().reload({\n                refresh: true\n            });\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/overlay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/grid/columns/overlay',\n    'Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus'\n], function ($, _, overlay, getLicenseStatus) {\n    'use strict';\n\n    return overlay.extend({\n        defaults: {\n            // eslint-disable-next-line max-len\n            provider: 'name = adobe_stock_images_listing.adobe_stock_images_listing_data_source, ns = adobe_stock_images_listing',\n            loginProvider: 'name = adobe-login, ns = adobe-login',\n            getImagesUrl: 'adobe_stock/license/getlist',\n            licensed: {},\n            modules: {\n                login: '${ $.loginProvider }'\n            },\n            listens: {\n                '${ $.provider }:data.items': 'handleItemsUpdate',\n                '${ $.loginProvider }:user': 'handleUserUpdate'\n            },\n            imports: {\n                rows: '${ $.provider }:data.items'\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'licensed'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Updates the licensed data when items data is updated.\n         *\n         * @param {Array} items\n         */\n        handleItemsUpdate: function (items) {\n            var ids = this.getIds(items);\n\n            this.updateLicensed(ids);\n        },\n\n        /**\n         * Updates the licensed data when user data is updated.\n         */\n        handleUserUpdate: function () {\n            var ids = this.getIds(this.rows);\n\n            this.updateLicensed(ids);\n        },\n\n        /**\n         * Set Licensed images data.\n         *\n         * @param {Array} ids\n         */\n        updateLicensed: function (ids) {\n            if (!this.isUserAuthorized() || ids.length === 0) {\n                this.licensed({});\n\n                return;\n            }\n\n            getLicenseStatus(this.getImagesUrl, ids).then(function (licensed) {\n                this.licensed(licensed);\n            }.bind(this));\n        },\n\n        /**\n         * Checks if user is logged in and authorized\n         *\n         * @returns {Boolean}\n         */\n        isUserAuthorized: function () {\n            return !_.isUndefined(this.login()) && this.login().user().isAuthorized;\n        },\n\n        /**\n         * Get all ids from items array\n         *\n         * @param {Array} items\n         * @returns {Number[]}\n         */\n        getIds: function (items) {\n            var ids = [];\n\n            items.forEach(function (record) {\n                ids.push(record.id);\n            });\n\n            return ids;\n        },\n\n        /**\n         * Returns top displacement of overlay according to image height\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Object}\n         */\n        getStyles: function (record) {\n            var height = record.styles().height.replace('px', '') - 40;\n\n            return {\n                top: height + 'px'\n            };\n        },\n\n        /**\n         * If overlay should be visible\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isVisible: function (row) {\n            return this.licensed()[row.id];\n        },\n\n        /**\n         * Get overlay label\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getLabel: function (row) {\n            return this.licensed()[row.id] ? 'Licensed' : '';\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/keywords.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'underscore'\n], function (Component, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/keywords',\n            chipsProvider: 'componentType = filtersChips, ns = ${ $.ns }',\n            defaultKeywordsLimit: 5,\n            keywordsLimit: 5,\n            canViewMoreKeywords: true,\n            modules: {\n                chips: '${ $.chipsProvider }',\n                preview: '${ $.parentName }.preview'\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'keywordsLimit',\n                    'canViewMoreKeywords'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Returns keywords to display under the attributes image\n         *\n         * @returns {*[]}\n         */\n        getKeywords: function (record) {\n            return record.keywords;\n        },\n\n        /**\n         * Returns keywords limit to show no of keywords\n         */\n        getKeywordsLimit: function () {\n            return this.keywordsLimit();\n        },\n\n        /**\n         * Show all the related keywords\n         */\n        viewAllKeywords: function (record) {\n            this.keywordsLimit(record.keywords.length);\n            this.canViewMoreKeywords(false);\n            this.preview().updateHeight();\n            this.preview().scrollToPreview();\n        },\n\n        /**\n         * Hide all the related keywords\n         */\n        hideAllKeywords: function () {\n            this.keywordsLimit(this.defaultKeywordsLimit);\n            this.canViewMoreKeywords(true);\n        },\n\n        /**\n         * Drop all filters and initiate search on keyword click event\n         */\n        searchByKeyWord: function (keyword) {\n            _.invoke(this.chips().elems(), 'clear');\n            _.invoke(this.chips().elems(), 'apply', keyword);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/related.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'underscore',\n    'jquery'\n], function (Component, _, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/related',\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            filterBookmarksSelector: '.admin__data-grid-action-bookmarks',\n            tabImagesLimit: 4,\n            tabsContainerId: '#adobe-stock-tabs',\n            serieFilterValue: '',\n            modelFilterValue: '',\n            selectedTab: null,\n            loader: false,\n            relatedImages: {\n                series: {},\n                model: {}\n            },\n            statefull: {\n                serieFilterValue: true,\n                modelFilterValue: true\n            },\n            modules: {\n                chips: '${ $.chipsProvider }',\n                filterChips: '${ $.filterChipsProvider }',\n                preview: '${ $.parentName }.preview'\n            },\n            exports: {\n                serieFilterValue: '${ $.provider }:params.filters.serie_id',\n                modelFilterValue: '${ $.provider }:params.filters.model_id'\n            }\n        },\n\n        /**\n         * Initializes related component.\n         */\n        initialize: function () {\n            this._super();\n\n            this.filterChips().updateActive();\n\n            return this;\n        },\n\n        /**\n         * Disable keydown event for related content tabs\n         */\n        disableTabsKeyDownEvent: function () {\n            if ($(this.tabsContainerId + ' li[role=tab]').length === 0) {\n                setTimeout(function () {\n                    this.disableTabsKeyDownEvent();\n                }.bind(this), 100);\n            } else {\n                $(this.tabsContainerId + ' li[role=tab]').off('keydown');\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'serieFilterValue',\n                    'modelFilterValue',\n                    'selectedTab',\n                    'relatedImages',\n                    'loader'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Check if visible container\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        isVisible: function (record) {\n            return this.showSeriesTab(record) && this.showModelTab(record);\n        },\n\n        /**\n         * Get image related image series.s\n         *\n         * @param {Object} record\n         */\n        loadRelatedImages: function (record) {\n            var series = this.getSeries(record),\n                model = this.getModel(record);\n\n            if (series && series.length ||\n                model && model.length\n            ) {\n                return;\n            }\n            $.ajax({\n                type: 'GET',\n                url: this.preview().relatedImagesUrl,\n                dataType: 'json',\n                beforeSend: function () {\n                    this.loader(true);\n                }.bind(this),\n                data: {\n                    'image_id': record.id,\n                    'limit': this.tabImagesLimit\n                }\n            }).done(function (data) {\n                var relatedImages = this.relatedImages();\n\n                this.loader(false);\n                relatedImages.series[record.id] = data.result['same_series'];\n                relatedImages.model[record.id] = data.result['same_model'];\n\n                this.relatedImages(relatedImages);\n                this.preview().updateHeight();\n\n                /* Switch to the model tab if the series tab is hidden */\n                if (relatedImages.series[record.id].length === 0 && relatedImages.model[record.id].length > 0) {\n                    // eslint-disable-next-line jquery-no-input-event-shorthand\n                    $('#adobe-stock-tabs').data().mageTabs.select(1);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Returns true if the series tab should be show, false otherwise\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        showSeriesTab: function (record) {\n            return typeof this.relatedImages().series[record.id] === 'undefined' ||\n                this.relatedImages().series[record.id].length !== 0;\n        },\n\n        /**\n         * Returns true if the model tab should be show, false otherwise\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        showModelTab: function (record) {\n            return typeof this.relatedImages().model[record.id] === 'undefined' ||\n                this.relatedImages().model[record.id].length !== 0;\n        },\n\n        /**\n         * Returns series to display under the image\n         *\n         * @param {Object} record\n         * @returns {*[]}\n         */\n        getSeries: function (record) {\n            return this.relatedImages().series[record.id] || [];\n        },\n\n        /**\n         * Check if the number of related series image is greater than 4 or not\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        canShowMoreSeriesImages: function (record) {\n            return this.getSeries(record).length >= this.tabImagesLimit;\n        },\n\n        /**\n         * Returns model to display under the image\n         *\n         * @param {Object} record\n         * @returns {*[]}\n         */\n        getModel: function (record) {\n            return this.relatedImages().model[record.id] || [];\n        },\n\n        /**\n         * Check if the number of related model image is greater than 4 or not\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        canShowMoreModelImages: function (record) {\n            return this.getModel(record).length >= this.tabImagesLimit;\n        },\n\n        /**\n         * Filter images from serie_id\n         *\n         * @param {Object} record\n         */\n        seeMoreFromSeries: function (record) {\n            if (this.isSerieFilterApplied(record)) {\n                this.scrollToFilter();\n\n                return;\n            }\n            this.serieFilterValue(record.id);\n            this.applyFilter('serie_id', record.id.toString());\n        },\n\n        /**\n         * Filter images from serie_id\n         *\n         * @param {Object} record\n         */\n        seeMoreFromModel: function (record) {\n            if (this.isModelFilterApplied(record)) {\n                this.scrollToFilter();\n\n                return;\n            }\n            this.modelFilterValue(record.id);\n            this.applyFilter('model_id', record.id.toString());\n        },\n\n        /**\n         * Apply series or model id filter and scroll to top of the page\n         *\n         * @param {String} typeId\n         * @param {String} recordId\n         */\n        applyFilter: function (typeId, recordId) {\n            var data = {};\n\n            data[typeId] = recordId;\n\n            this.filterChips().clear();\n            this.filterChips().setData(data, true);\n            this.filterChips().apply();\n\n            this.scrollToFilter();\n        },\n\n        /**\n         * Checks if the filter is applied\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isSerieFilterApplied: function (record) {\n            return this.filterChips().get('applied')['serie_id'] === record.id.toString();\n        },\n\n        /**\n         * Checks if the filter is applied\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isModelFilterApplied: function (record) {\n            return this.filterChips().get('applied')['model_id'] === record.id.toString();\n        },\n\n        /**\n         * Scrolls user window to the filter bookmarks\n         */\n        scrollToFilter: function () {\n            $(this.preview().adobeStockModalSelector + ' ' + this.filterBookmarksSelector).get(0).scrollIntoView({\n                behavior: 'smooth',\n                block: 'center',\n                inline: 'nearest'\n            });\n        },\n\n        /**\n         * Next related image preview\n         *\n         * @param {Object} record\n         */\n        nextRelated: function (record) {\n            var relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record),\n                nextRelatedIndex = _.findLastIndex(\n                    relatedList,\n                    {\n                        id: this.preview().displayedRecord().id\n                    }\n                ) + 1,\n                nextRelated = relatedList[nextRelatedIndex];\n\n            if (typeof nextRelated === 'undefined') {\n                return;\n            }\n\n            this.switchImagePreviewToRelatedImage(nextRelated);\n        },\n\n        /**\n         * Previous related preview\n         *\n         * @param {Object} record\n         */\n        prevRelated: function (record) {\n            var relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record),\n                prevRelatedIndex = _.findLastIndex(\n                    relatedList,\n                    {\n                        id: this.preview().displayedRecord().id\n                    }\n                ) - 1,\n                prevRelated = relatedList[prevRelatedIndex];\n\n            if (typeof prevRelated === 'undefined') {\n                return;\n            }\n\n            this.switchImagePreviewToRelatedImage(prevRelated);\n        },\n\n        /**\n         * Get previous button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewPrevious: function (record) {\n            var relatedList, prevRelatedIndex, prevRelated;\n\n            if (!this.selectedTab()) {\n                return false;\n            }\n            relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record);\n            prevRelatedIndex = _.findLastIndex(\n                relatedList,\n                {\n                    id: this.preview().displayedRecord().id\n                }\n            ) - 1;\n            prevRelated = relatedList[prevRelatedIndex];\n\n            return typeof prevRelated === 'undefined';\n        },\n\n        /**\n         * Get next button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewNext: function (record) {\n            var relatedList, nextRelatedIndex, nextRelated;\n\n            if (!this.selectedTab()) {\n                return false;\n            }\n            relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record);\n            nextRelatedIndex = _.findLastIndex(\n                relatedList,\n                {\n                    id: this.preview().displayedRecord().id\n                }\n            ) + 1;\n            nextRelated = relatedList[nextRelatedIndex];\n\n            return typeof nextRelated === 'undefined';\n        },\n\n        /**\n         * Switch image preview to related image\n         *\n         * @param {Object|null} relatedImage\n         */\n        switchImagePreviewToRelatedImage: function (relatedImage) {\n            if (!relatedImage) {\n                this.selectedTab(null);\n\n                return;\n            }\n\n            if (this.preview().displayedRecord().id === relatedImage.id) {\n                return;\n            }\n\n            this.preview().showRelated(relatedImage);\n        },\n\n        /**\n         * Switch image preview to series image\n         *\n         * @param {Object} record\n         */\n        switchImagePreviewToSeriesImage: function (record) {\n            this.selectedTab('series');\n            this.switchImagePreviewToRelatedImage(record);\n        },\n\n        /**\n         * Switch image preview to model image\n         *\n         * @param {Object} record\n         */\n        switchImagePreviewToModelImage: function (record) {\n            this.selectedTab('model');\n            this.switchImagePreviewToRelatedImage(record);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'uiRegistry',\n    'jquery',\n    'underscore',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/action/savePreview',\n    'Magento_AdobeStockImageAdminUi/js/action/saveLicensed',\n    'Magento_AdobeStockImageAdminUi/js/action/licenseAndSave',\n    'Magento_AdobeStockImageAdminUi/js/action/confirmQuota',\n    'Magento_AdobeStockImageAdminUi/js/media-gallery',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/buyCredits',\n    'Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus',\n    'Magento_Ui/js/modal/alert'\n], function (\n    Component,\n    uiRegistry,\n    $,\n    _,\n    saveAction,\n    savePreviewAction,\n    saveLicensedAction,\n    licenseAndSaveAction,\n    confirmQuotaAction,\n    mediaGallery,\n    buyCreditsConfirmation,\n    getLicenseStatus,\n    uiAlert\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/actions',\n            loginProvider: 'name = adobe-login, ns = adobe-login',\n            mediaGallerySelector: '.media-gallery-modal:has(#search_adobe_stock)',\n            adobeStockModalSelector: '.adobe-search-images-modal',\n            downloadImagePreviewUrl: 'adobe_stock/preview/download',\n            licenseAndDownloadUrl: 'adobe_stock/license/license',\n            saveLicensedAndDownloadUrl: 'adobe_stock/license/saveLicensed',\n            buyCreditsUrl: 'https://stock.adobe.com/',\n            messageDelay: 5,\n            mediaGallery: '',\n            imageItems: [],\n            messages: [],\n            listens: {\n                '${ $.provider }:data.items': 'updateActions'\n            },\n            modules: {\n                login: '${ $.loginProvider }',\n                preview: '${ $.parentName }.preview',\n                overlay: '${ $.parentName }.overlay',\n                source: '${ $.provider }',\n                imageDirectory: '${ $.mediaGalleryName }',\n                mediaGallerySortBy: '${ $.mediaGallerySortBy }',\n                mediaGallerySearchInput: '${ $.mediaGallerySearchInput }',\n                mediaGalleryListingFilters: '${ $.mediaGalleryListingFilters }',\n                listingPaging: '${ $.listingPaging }'\n            },\n            imports: {\n                imageItems: '${ $.mediaGalleryProvider }:data.items'\n            }\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'imageItems',\n                    'messages'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Update displayed record data on data source update\n         */\n        updateActions: function () {\n            var displayedRecord = this.preview().displayedRecord(),\n                updatedDisplayedRecord = this.preview().displayedRecord(),\n                records = this.source().data.items,\n                index;\n\n            if (typeof displayedRecord.id === 'undefined') {\n                return;\n            }\n\n            for (index = 0; index < records.length; index++) {\n                if (records[index].id === displayedRecord.id) {\n                    updatedDisplayedRecord = records[index];\n                    break;\n                }\n            }\n\n            this.preview().displayedRecord(updatedDisplayedRecord);\n        },\n\n        /**\n         * Returns is_downloaded flag as observable for given record\n         *\n         * @returns {observable}\n         */\n        isDownloaded: function () {\n            return this.preview().displayedRecord()['is_downloaded'];\n        },\n\n        /**\n         * Is asset licensed in adobe stock in context of currently logged in account\n         *\n         * @returns {observable}\n         */\n        isLicensed: function () {\n            return this.overlay().licensed()[this.preview().displayedRecord().id] && !this.isLicensedLocally();\n        },\n\n        /**\n         * Is licensed version of asset saved locally\n         *\n         * @returns {observable}\n         */\n        isLicensedLocally: function () {\n            return this.preview().displayedRecord()['is_licensed_locally'];\n        },\n\n        /**\n         * Locate downloaded image in media browser\n         */\n        openInMediaGalleryClick: function () {\n            this.preview().getAdobeModal().trigger('closeModal');\n\n            if (!this.isMediaBrowser()) {\n                this.selectImageInNewMediaGalleryBySearch(this.preview().displayedRecord().id);\n            } else {\n                this.selectDisplayedImageForOldMediaGallery(this.preview().displayedRecord().path);\n            }\n        },\n\n        /**\n         * Return adobe stock asset by adobe id\n         *\n         * @param {String} adobeId\n         */\n        getAssetDetails: function (adobeId) {\n            return $.ajax({\n                url: this.getMediaGalleryAsset,\n                data: {\n                    'adobe_id': adobeId\n                },\n                context: this,\n                showLoader: true\n            });\n        },\n\n        /**\n         * Select image in new media gallery via search input\n         *\n         * @param {String} imageId\n         */\n        selectImageInNewMediaGalleryBySearch: function (imageId) {\n            var path;\n\n            this.mediaGalleryListingFilters().clear();\n            this.getAssetDetails(imageId).then(function (assetDetails) {\n                if (assetDetails.length === 0) {\n                    return;\n                }\n                this.mediaGallerySearchInput().apply(assetDetails.title);\n                path = assetDetails.path;\n                path = path.substring(0, path.lastIndexOf('/'));\n\n                if (path !== '') {\n                    this.imageDirectory().locateNode(path);\n                }\n                this.selectRecordFromMediaGalleryProvider(assetDetails.path);\n            }.bind(this));\n\n        },\n\n        /**\n         * Open recently saved image and go to first page\n         */\n        openNewestImage: function () {\n            this.listingPaging().goFirst();\n            this.mediaGallerySortBy().selectDefaultOption();\n        },\n\n        /**\n         * Selects displayed image in media gallery for old gallery\n         */\n        selectDisplayedImageForOldMediaGallery: function (path) {\n            var image = mediaGallery.locate(path);\n\n            image ? image.trigger('click') : mediaGallery.notLocated();\n        },\n\n        /**\n         * Select record by image file name\n         *\n         * @param {String} path\n         */\n        selectRecordFromMediaGalleryProvider: function (path) {\n            var subscription;\n\n            subscription = this.imageItems.subscribe(function (items) {\n                subscription.dispose();\n                items.each(function (item) {\n                    if (item.path === path) {\n                        this.selectRecord(item);\n\n                        return false;\n                    }\n                }.bind(this));\n            }.bind(this));\n\n            setTimeout(function () {\n                subscription.dispose();\n            }, 1500);\n        },\n\n        /**\n         * Set the record as selected\n         *\n         * @param {Object} record\n         */\n        selectRecord: function (record) {\n            uiRegistry.get('name =' + this.mediaGallery).select(record);\n        },\n\n        /**\n         * Save preview click handler\n         */\n        savePreviewClick: function () {\n            var record = this.preview().displayedRecord();\n\n            savePreviewAction(\n                this.preview().downloadImagePreviewUrl,\n                record.id,\n                record.title,\n                record['content_type'],\n                this.getDestinationDirectoryPath()\n            ).then(function (destinationPath) {\n                this.updateDownloadedDisplayedRecord(destinationPath);\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    this.showErrorMessage(error);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Update displayed record after downloading\n         *\n         * @param {String} path\n         */\n        updateDownloadedDisplayedRecord: function (path) {\n            var record = this.preview().displayedRecord();\n\n            record['is_downloaded'] = 1;\n\n            if (record.path === '') {\n                record.path = path;\n            }\n\n            this.preview().displayedRecord(record);\n        },\n\n        /**\n         * Update displayed record after licensing\n         *\n         * @param {String} path\n         */\n        updateLicensedDisplayedRecord: function (path) {\n            var record = this.preview().displayedRecord();\n\n            record['is_downloaded'] = 1;\n\n            if (record.path === '') {\n                record.path = path;\n            }\n\n            record['is_licensed'] = 1;\n            record['is_licensed_locally'] = 1;\n\n            this.preview().displayedRecord(record);\n        },\n\n        /**\n         * Get image destination path\n         *\n         * @param {String} fileName\n         * @param {String} contentType\n         * @returns {String}\n         */\n        getDestinationPath: function (fileName, contentType) {\n            return this.getDestinationDirectoryPath() + '/' + fileName + '.' + this.getImageExtension(contentType);\n        },\n\n        /**\n         * Get destination directory path\n         *\n         * @returns {String}\n         */\n        getDestinationDirectoryPath: function () {\n            var activeNodePath,\n                activeNode;\n\n            if (this.isMediaBrowser()) {\n                activeNode = this.getMageMediaBrowserData().activeNode;\n\n                activeNodePath = _.isUndefined(activeNode.original.path) ? '' : activeNode.original.path;\n            } else {\n                activeNodePath = this.imageDirectory().activeNode() || '';\n            }\n\n            return activeNodePath;\n        },\n\n        /**\n         * Reload grid\n         *\n         * @returns {*}\n         */\n        reloadGrid: function () {\n            var provider,\n                dataStorage;\n\n            if (this.isMediaBrowser()) {\n                return this.getMageMediaBrowserData().reload();\n            }\n\n            provider = uiRegistry.get('index = media_gallery_listing_data_source'),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n\n            return provider.reload();\n        },\n\n        /**\n         * Get data for media browser\n         *\n         * @returns {Undefined|Object}\n         */\n        getMageMediaBrowserData: function () {\n            return $(this.preview().mediaGallerySelector).data('mageMediabrowser');\n        },\n\n        /**\n         * Is the media browser used in the content of the grid\n         *\n         * @returns {Boolean}\n         */\n        isMediaBrowser: function () {\n            return typeof this.getMageMediaBrowserData() !== 'undefined';\n        },\n\n        /**\n         * Generate meaningful name image file,\n         * allow only alphanumerics, dashes, and underscores\n         *\n         * @param {String} title\n         * @param {Number} id\n         * @return string\n         */\n        generateImageName: function (title, id) {\n            var fileName = title.substring(0, 32)\n                .replace(/[^a-zA-Z0-9_]/g, '-')\n                .replace(/-{2,}/g, '-')\n                .toLowerCase();\n\n            /* If the filename does not contain latin chars, use ID as a filename */\n            return fileName === '-' ? id : fileName;\n        },\n\n        /**\n         * Get image file extension\n         *\n         * @param {String} contentType\n         * @return string\n         */\n        getImageExtension: function (contentType) {\n            return contentType.match(/[^/]{1,4}$/);\n        },\n\n        /**\n         * Get messages\n         *\n         * @return {Array}\n         */\n        getMessages: function () {\n            return this.messages();\n        },\n\n        /**\n         * License click handler\n         */\n        licenseClick: function () {\n            var record = this.preview().displayedRecord();\n\n            this.licenseProcess(\n                record.id,\n                record.title,\n                record.path,\n                record['content_type'],\n                this.isDownloaded()\n            ).then(function (destinationPath) {\n                this.updateLicensedDisplayedRecord(destinationPath);\n                this.login().getUserQuota();\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    uiAlert({\n                        content: error\n                    });\n                }\n            });\n        },\n\n        /**\n         * Process of license\n         *\n         * @param {Number} id\n         * @param {String} title\n         * @param {String} path\n         * @param {String} contentType\n         * @param {Boolean} isDownloaded\n         * @return {window.Promise}\n         */\n        licenseProcess: function (id, title, path, contentType, isDownloaded) {\n            var deferred = $.Deferred();\n\n            this.login().login()\n                .then(function () {\n                    getLicenseStatus(\n                        this.overlay().getImagesUrl,\n                        [id]\n                    ).then(function (licensedInfo) {\n                        var isLicensed = licensedInfo[id] || false;\n\n                        if (isLicensed) {\n                            saveLicensedAction(\n                                this.preview().saveLicensedAndDownloadUrl,\n                                id,\n                                title,\n                                path,\n                                contentType,\n                                this.getDestinationDirectoryPath()\n                            ).then(function (destinationPath) {\n                                deferred.resolve(destinationPath);\n                            }).fail(function (error) {\n                                deferred.reject(error);\n                            });\n                        } else {\n                            confirmQuotaAction(this.preview().confirmationUrl, id).then(function (data) {\n                                if (data.canLicense === false) {\n                                    buyCreditsConfirmation(\n                                        this.preview().buyCreditsUrl,\n                                        title,\n                                        data.message\n                                    );\n                                } else {\n                                    licenseAndSaveAction(\n                                        this.preview().licenseAndDownloadUrl,\n                                        id,\n                                        title,\n                                        path,\n                                        contentType,\n                                        isDownloaded,\n                                        data.message,\n                                        this.getDestinationDirectoryPath()\n                                    ).then(function (destinationPath) {\n                                        deferred.resolve(destinationPath);\n                                    }).fail(function (error) {\n                                        deferred.reject(error);\n                                    });\n                                }\n                            }.bind(this)).fail(function (error) {\n                                deferred.reject(error);\n                            });\n                        }\n                    }.bind(this)).fail(function (error) {\n                        deferred.reject(error);\n                    });\n                }.bind(this)).fail(function (error) {\n                deferred.reject(error);\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Save licensed click handler\n         */\n        saveLicensedClick: function () {\n            var record = this.preview().displayedRecord();\n\n            if (!this.login().user().isAuthorized) {\n                return;\n            }\n\n            if (!this.isLicensed()) {\n                return;\n            }\n\n            saveLicensedAction(\n                this.preview().saveLicensedAndDownloadUrl,\n                record.id,\n                record.title,\n                record.path,\n                record['content_type'],\n                this.getDestinationDirectoryPath()\n            ).then(function (destinationPath) {\n                this.updateLicensedDisplayedRecord(destinationPath);\n                this.login().getUserQuota();\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    uiAlert({\n                        content: error\n                    });\n                }\n            });\n        },\n\n        /**\n         * Returns license button title depending on the existing saved preview\n         *\n         * @returns {String}\n         */\n        getLicenseButtonTitle: function () {\n            return this.isDownloaded() ? $.mage.__('License') : $.mage.__('License and Save');\n        },\n\n        /**\n         * Extracts image name from its path\n         *\n         * @param {String} path\n         * @returns {String}\n         */\n        getImageNameFromPath: function (path) {\n            var filePathArray = path.split('/'),\n                imageIndex = filePathArray.length - 1;\n\n            return filePathArray[imageIndex].substring(0, filePathArray[imageIndex].lastIndexOf('.'));\n        },\n\n        /**\n         * Show error message and schedule cleanup\n         *\n         * @param {String} message\n         */\n        showErrorMessage: function (message) {\n            this.messages.push({\n                code: 'error',\n                messageUnsanitizedHtml: message\n            });\n            this.messagesCleanup();\n        },\n\n        /**\n         * Messages cleanup\n         */\n        messagesCleanup: function () {\n            // eslint-disable-next-line no-unused-vars\n            var timerId;\n\n            // eslint-disable-next-line no-unused-vars\n            timerId = setTimeout(function () {\n                clearTimeout(timerId);\n                this.messages.removeAll();\n            }.bind(this), Number(this.messageDelay) * 1000);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, ids) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'GET',\n            url: requestUrl + '?ids=' + ids.join(','),\n            data: {\n                'form_key': window.FORM_KEY\n            },\n            showLoader: true,\n            dataType: 'json',\n\n            /**\n             * Resolve with the response result\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                deferred.resolve(response.result);\n            },\n\n            /**\n             * Reject with the message from response\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message = response.message;\n\n                if (response.status === 403) {\n                    message = $.mage.__('Your admin role does not have permissions to license an image');\n                }\n\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/confirmQuota.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, adobeAssetId) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'GET',\n            url: requestUrl,\n            dataType: 'json',\n            data: {\n                'media_id': adobeAssetId\n            },\n            showLoader: true,\n\n            /**\n             * Extract the data from the response and resolve\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                deferred.resolve({\n                    canLicense: response.result.canLicense,\n                    message: response.result.message\n                });\n            },\n\n            /**\n             * Extract the error message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message = response.JSON ? response.JSON.message\n                    : $.mage.__('Could not fetch licensing information.');\n\n                if (response.status === 403) {\n                    message = $.mage.__('Your admin role does not have permissions to license an image');\n                }\n\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/saveLicensed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/saveLicensed',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, saveLicensedConfirmation, pathUtility) {\n    'use strict';\n\n    return function (requestUrl, id, title, path, contentType, directoryPath) {\n        var imageName = '',\n            destinationPath,\n            deferred = $.Deferred();\n\n        if (path !== '') {\n            imageName = pathUtility.getImageNameFromPath(path);\n            destinationPath = pathUtility.buildPath(directoryPath, imageName, contentType);\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (message) {\n                deferred.reject(message);\n            });\n\n            return deferred.promise();\n        }\n\n        saveLicensedConfirmation(\n            pathUtility.generateImageName(title, id),\n            pathUtility.getImageExtension(contentType)\n        ).then(function (fileName) {\n            destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (message) {\n                deferred.reject(message);\n            });\n        }).fail(function (error) {\n            deferred.reject(error);\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, adobeAssetId, destinationPath) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'POST',\n            url: requestUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                'media_id': adobeAssetId,\n                'destination_path': destinationPath\n            },\n\n            /**\n             * Resolve on success\n             */\n            success: function () {\n                deferred.resolve();\n            },\n\n            /**\n             * Extract the error message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message;\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = 'Could not save the asset!';\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/savePreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/save',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, saveConfirmation, pathUtility) {\n    'use strict';\n\n    return function (requestUrl, id, title, contentType, directoryPath) {\n        var deferred = $.Deferred(),\n            destinationPath;\n\n        saveConfirmation(\n            pathUtility.generateImageName(title, id),\n            pathUtility.getImageExtension(contentType)\n        ).then(function (fileName) {\n            destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (error) {\n                deferred.reject(error);\n            });\n        }).fail(function (error) {\n            deferred.reject(error);\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/licenseAndSave.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/license',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, licenseConfirmation, pathUtility) {\n    'use strict';\n\n    return function (\n        requestUrl,\n        id,\n        title,\n        path,\n        contentType,\n        isDownloaded,\n        quotaMessage,\n        directoryPath\n    ) {\n        var deferred = $.Deferred(),\n            destinationPath;\n\n        licenseConfirmation(\n                title,\n                quotaMessage,\n                isDownloaded,\n                pathUtility.generateImageName(title, id),\n                pathUtility.getImageExtension(contentType)\n            ).then(function (fileName) {\n\n                if (typeof fileName === 'undefined') {\n                    fileName = pathUtility.getImageNameFromPath(path);\n                }\n\n                destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n\n                saveAction(\n                    requestUrl,\n                    id,\n                    destinationPath\n                ).then(function () {\n                    deferred.resolve(destinationPath);\n                }).fail(function (message) {\n                    deferred.reject(message);\n                });\n            }).fail(function (error) {\n                deferred.reject(error);\n            });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/saveLicensed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (proposedfileName, fileExtension) {\n        var deferred = $.Deferred(),\n            data = {\n                'title': $.mage.__('Save'),\n                'content': $.mage.__('File Name'),\n                'visible': true,\n                'actions': {\n                    /**\n                     * Resolve with the specified file name\n                     *\n                     * @param {String} fileName\n                     */\n                    confirm: function (fileName) {\n                        deferred.resolve(fileName);\n                    }\n                },\n                'buttons': [\n                    {\n                        text: $.mage.__('Cancel'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Close modal on button click\n                         */\n                        click: function () {\n                            this.closeModal();\n                            deferred.reject();\n                        }\n                    },\n                    {\n                        text: $.mage.__('Confirm'),\n                        class: 'action-primary action-accept'\n                    }\n                ]\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (proposedfileName, fileExtension) {\n        var deferred = $.Deferred(),\n            data = {\n                'title': $.mage.__('Save Preview'),\n                'content': $.mage.__('File Name'),\n                'visible': true,\n                'actions': {\n                    /**\n                     * Resolve with the specified file name\n                     *\n                     * @param {String} specifiedFileName\n                     */\n                    confirm: function (specifiedFileName) {\n                        deferred.resolve(specifiedFileName);\n                    }\n                },\n                'buttons': [{\n                    text: $.mage.__('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal on button click\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.reject();\n                    }\n                }, {\n                    text: $.mage.__('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/buyCredits.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm'\n], function ($, confirm) {\n    'use strict';\n\n    return function (buyCreditsUrl, recordTitle, quotaMessage) {\n        var confirmationContent = $.mage.__('License \"' + recordTitle + '\"'),\n            content = '<p>' + confirmationContent + '</p><p><b>' + quotaMessage + '</b></p><br>';\n\n        confirm({\n            title: $.mage.__('License Adobe Stock Images?'),\n            content: content,\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Close modal\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            },{\n                text: $.mage.__('Buy Credits'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Close modal\n                 */\n                click: function () {\n                    window.open(buyCreditsUrl);\n                    this.closeModal();\n                }\n            }]\n        });\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/license.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (recordTitle, quotaMessage, isPreviewDownloaded, proposedfileName, fileExtension) {\n        var confirmationContent = $.mage.__('License \"' + recordTitle + '\"'),\n            deferred = $.Deferred(),\n            displayFieldName = !isPreviewDownloaded ? '<b>' + $.mage.__('File Name') + '</b>' : '',\n            content = '<p>' + confirmationContent + '</p><p><b>' + quotaMessage + '</b></p><br>' + displayFieldName,\n            data = {\n                'title': $.mage.__('License Adobe Stock Images?'),\n                'content': content,\n                'visible': !isPreviewDownloaded,\n                'actions': {\n                    /**\n                     * Confirm action\n                     *\n                     * @param {String} fileName\n                     */\n                    confirm: function (fileName) {\n                        deferred.resolve(fileName);\n                    }\n                },\n                'buttons': [{\n                    text: $.mage.__('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.reject();\n                    }\n                }, {\n                    text: $.mage.__('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        if (!data.visible) {\n            $('.adobe-stock-save-preview-prompt').trigger('focus');\n        }\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/licenseImage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_MediaGalleryUi/js/grid/columns/image'\n], function (Image) {\n    'use strict';\n\n    return Image.extend({\n        defaults: {\n            viewConfig: [\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/image/licenseActions',\n                    name: '${ $.name }_actions',\n                    imageModelName: '${ $.name }',\n                    imageDetailsUrl: '${ $.imageDetailsurl }',\n                    imageComponent: '${ $.imageComponent }'\n                }\n            ]\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/image/licenseActions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_MediaGalleryUi/js/grid/columns/image/actions',\n    'Magento_MediaGalleryUi/js/action/getDetails',\n    'mage/translate'\n], function ($, _, Action, getDetails) {\n    'use strict';\n\n    return Action.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/mediaGallery/grid/columns/image/licenseActions',\n            licenseAction: {\n                name: 'license',\n                title: $.mage.__('License'),\n                handler: 'licenseImageAction'\n            },\n            modules: {\n                image: '${ $.imageComponent }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.actionsList.push(this.licenseAction);\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'visible'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * License image\n         *\n         * @param {Object} record\n         */\n        licenseImageAction: function (record) {\n            this.getImageRecord(record.id);\n        },\n\n        /**\n         * Check if image licensed\n         *\n         * @param {Object} record\n         * @param {Object} name\n         */\n        isVisible: function (record, name) {\n            if (name === this.licenseAction.name) {\n                if (_.isUndefined(record.overlay) || record.overlay === '') {\n                    return false;\n                }\n\n                return true;\n            }\n\n            return true;\n        },\n\n        /**\n         * Get image record and start license process\n         *\n         * @param {Number} imageId\n         */\n        getImageRecord: function (imageId) {\n            getDetails(this.imageDetailsUrl, [imageId]).then(function (imageDetails) {\n                var id = imageDetails[imageId]['adobe_stock'][0].value;\n\n                this.image().actions().licenseProcess(\n                    id,\n                    imageDetails[imageId].title,\n                    imageDetails[imageId].path,\n                    imageDetails[imageId]['content_type'],\n                    true\n                ).then(function () {\n                    this.image().actions().login().getUserQuota();\n                    this.imageModel().reloadGrid();\n                    this.imageModel().addMessage('success', $.mage.__('The image has been licensed.'));\n                }.bind(this)).fail(function (error) {\n                    if (error) {\n                        this.imageModel().addMessage('error', error);\n                    }\n                }.bind(this));\n            }.bind(this)).fail(function (message) {\n                this.imageModel().addMessage('error', message);\n            }.bind(this));\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/validation/validate-image-name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery/validate'\n], function ($, $t) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-name', function (value) {\n            return /^[a-zA-Z0-9\\-\\_]+$/i.test(value);\n\n        }, $t('Please name the file using only letters, numbers, underscores and dashes'));\n});\n","Magento_InventoryLowQuantityNotificationAdminUi/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: ''\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        'onCheckedChanged': function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * @returns {String}\n         */\n        getInitialValue: function () {\n            var values = [this.value(), this.default],\n                value;\n\n            values.some(function (v) {\n                value = v || !!v;\n\n                return value;\n            });\n\n            return this.normalizeData(value);\n        }\n    });\n});\n","Magento_InventoryLowQuantityNotificationAdminUi/js/components/notify-stock-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (AbstractField) {\n    'use strict';\n\n    return AbstractField.extend({\n        defaults: {\n            notifyStockQtyUseDefault: '',\n            manageStock: '',\n            listens: {\n                notifyStockQtyUseDefault: 'onChange',\n                manageStock: 'onChange'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['notifyStockQtyUseDefault', 'manageStock']);\n        },\n\n        /**\n         * Disable input when Manage Stock switched off or Notify Quantity Use Default\n         */\n        onChange: function () {\n            this.disabled(\n                this.notifyStockQtyUseDefault() ||\n                this.manageStock()\n            );\n        }\n    });\n});\n","mage/accordion.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/tabs'\n], function ($, tabs) {\n    'use strict';\n\n    $.widget('mage.accordion', tabs, {\n        options: {\n            active: [0],\n            multipleCollapsible: false,\n            openOnFocus: false\n        },\n\n        /**\n         * @private\n         */\n        _callCollapsible: function () {\n            var self = this,\n                disabled = false,\n                active = false;\n\n            if (typeof this.options.active === 'string') {\n                this.options.active = this.options.active.split(' ').map(function (item) {\n                    return parseInt(item, 10);\n                });\n            }\n\n            $.each(this.collapsibles, function (i) {\n                disabled = active = false;\n\n                if ($.inArray(i, self.options.disabled) !== -1) {\n                    disabled = true;\n                }\n\n                if ($.inArray(i, self.options.active) !== -1) {\n                    active = true;\n                }\n                self._instantiateCollapsible(this, i, active, disabled);\n            });\n        },\n\n        /**\n         * Overwrites default functionality to provide the option to activate/deactivate multiple sections simultaneous\n         * @param {*} action\n         * @param {*} index\n         * @private\n         */\n        _toggleActivate: function (action, index) {\n            var self = this;\n\n            if (Array.isArray(index && this.options.multipleCollapsible)) {\n                $.each(index, function () {\n                    self.collapsibles.eq(this).collapsible(action);\n                });\n            } else if (index === undefined && this.options.multipleCollapsible) {\n                this.collapsibles.collapsible(action);\n            } else {\n                this._super(action, index);\n            }\n        },\n\n        /**\n         * If the Accordion allows multiple section to be active at the same time, if deep linking is used\n         * sections that don't contain the id from anchor shouldn't be closed, otherwise the accordion uses the\n         * tabs behavior\n         * @private\n         */\n        _handleDeepLinking: function () {\n            if (!this.options.multipleCollapsible) {\n                this._super();\n            }\n        },\n\n        /**\n         * Prevent default behavior that closes the other sections when one gets activated if the Accordion allows\n         * multiple sections simultaneous\n         * @private\n         */\n        _closeOthers: function () {\n            var self = this;\n\n            if (!this.options.multipleCollapsible) {\n                $.each(this.collapsibles, function () {\n                    $(this).on('beforeOpen', function () {\n                        self.collapsibles.not(this).collapsible('deactivate');\n                    });\n                });\n            }\n            $.each(this.collapsibles, function () {\n                $(this).on('beforeOpen', function () {\n                    var section = $(this);\n\n                    section.addClass('allow').prevAll().addClass('allow');\n                    section.nextAll().removeClass('allow');\n                });\n            });\n        }\n    });\n\n    return $.mage.accordion;\n});\n","mage/translate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage',\n    'mageTranslationDictionary',\n    'underscore'\n], function ($, mage, dictionary, _) {\n    'use strict';\n\n    $.extend(true, $, {\n        mage: {\n            translate: (function () {\n                /**\n                 * Key-value translations storage\n                 * @type {Object}\n                 * @private\n                 */\n                var _data = dictionary;\n\n                return {\n                    /**\n                     * Add new translation (two string parameters) or several translations (object)\n                     */\n                    add: function () {\n                        if (arguments.length > 1) {\n                            _data[arguments[0]] = arguments[1];\n                        } else if (typeof arguments[0] === 'object') {\n                            $.extend(_data, arguments[0]);\n                        }\n                    },\n\n                    /**\n                     * Make a translation with parsing (to handle case when _data represents tuple)\n                     * @param {String} text\n                     * @return {String}\n                     */\n                    translate: function (text) {\n                        return typeof _data[text] !== 'undefined' ? _data[text] : text;\n                    }\n                };\n            }())\n        }\n    });\n    $.mage.__ = $.proxy($.mage.translate.translate, $.mage.translate);\n\n    // Provide i18n wrapper to be used in underscore templates for translation\n    _.extend(_, {\n        /**\n         * Make a translation using $.mage.__\n         *\n         * @param {String} text\n         * @return {String}\n         */\n        i18n: function (text) {\n            return $.mage.__(text);\n        }\n    });\n\n    return $.mage.__;\n});\n","mage/translate-inline.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/utils/misc',\n    'mage/translate',\n    'jquery-ui-modules/dialog'\n], function ($, mageTemplate, miscUtils) {\n    'use strict';\n\n    $.widget('mage.translateInline', $.ui.dialog, {\n        options: {\n            translateForm: {\n                template: '#translate-form-template',\n                data: {\n                    id: 'translate-inline-form',\n                    message: 'Please refresh the page to see your changes after submitting this form. ' +\n                        'Note: browser cache refresh may be required'\n                }\n            },\n            autoOpen: false,\n            translateArea: null,\n            modal: true,\n            dialogClass: 'popup-window window-translate-inline',\n            width: '75%',\n            title: $.mage.__('Translate'),\n            height: 470,\n            position: {\n                my: 'left top',\n                at: 'center top',\n                of: 'body'\n            },\n            buttons: [{\n                text: $.mage.__('Submit'),\n                'class': 'action-primary',\n\n                /**\n                 * Click\n                 */\n                click: function () {\n                    $(this).translateInline('submit');\n                }\n            },\n            {\n                text: $.mage.__('Close'),\n                'class': 'action-close',\n\n                /**\n                 * Click.\n                 */\n                click: function () {\n                    $(this).translateInline('close');\n                }\n            }],\n\n            /**\n             * Open.\n             */\n            open: function () {\n                var $uiDialog = $(this).closest('.ui-dialog'),\n                    topMargin = $uiDialog.children('.ui-dialog-titlebar').outerHeight() + 45;\n\n                $uiDialog\n                    .addClass('ui-dialog-active')\n                    .css('margin-top', topMargin);\n            },\n\n            /**\n             * Close.\n             */\n            close: function () {\n                $(this).closest('.ui-dialog').removeClass('ui-dialog-active');\n            }\n        },\n\n        /**\n         * Translate Inline creation\n         * @protected\n         */\n        _create: function () {\n            var $translateArea = $(this.options.translateArea);\n\n            if (!$translateArea.length) {\n                $translateArea = $('body');\n            }\n            $translateArea.on('edit.editTrigger', $.proxy(this._onEdit, this));\n\n            this.tmpl = mageTemplate(this.options.translateForm.template);\n\n            this._super();\n        },\n\n        /**\n         * @param {*} templateData\n         * @return {*|jQuery|HTMLElement}\n         * @private\n         */\n        _prepareContent: function (templateData) {\n            var data = $.extend({\n                items: templateData,\n                escape: miscUtils.escape\n            }, this.options.translateForm.data);\n\n            this.data = data;\n\n            return $(this.tmpl({\n                data: data\n            }));\n        },\n\n        /**\n         * Render translation form and open dialog\n         * @param {Object} e - object\n         * @protected\n         */\n        _onEdit: function (e) {\n            this.target = e.target;\n            this.element.html(this._prepareContent($(e.target).data('translate')));\n            this.open(e);\n        },\n\n        /**\n         * Submit.\n         */\n        submit: function () {\n            if (this.formIsSubmitted) {\n                return;\n            }\n            this._formSubmit();\n        },\n\n        /**\n         * Send ajax request on form submit\n         * @protected\n         */\n        _formSubmit: function () {\n            var parameters = $.param({\n                    area: this.options.area\n                }) + '&' + $('#' + this.options.translateForm.data.id).serialize();\n\n            this.formIsSubmitted = true;\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'POST',\n                data: parameters,\n                loaderContext: this.element,\n                showLoader: true\n            }).always($.proxy(this._formSubmitComplete, this));\n        },\n\n        /**\n         * @param {Object} response\n         * @private\n         */\n        _formSubmitComplete: function (response) {\n            var responseJSON = response.responseJSON || response;\n\n            this.close();\n            this.formIsSubmitted = false;\n            $.mage.translate.add(responseJSON);\n            this._updatePlaceholder(responseJSON[this.data.items[0].original]);\n        },\n\n        /**\n         * @param {*} newValue\n         * @private\n         */\n        _updatePlaceholder: function (newValue) {\n            var $target = $(this.target),\n                translateObject = $target.data('translate')[0];\n\n            translateObject.shown = newValue;\n            translateObject.translated = newValue;\n            $.mage.translate.add(this.data.items[0].original, newValue);\n\n            $target.html(newValue);\n        },\n\n        /**\n         * Destroy translateInline\n         */\n        destroy: function () {\n            this.element.off('.editTrigger');\n            this._super();\n        }\n    });\n\n    return $.mage.translateInline;\n});\n","mage/storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery', 'mage/url'], function ($, urlBuilder) {\n    'use strict';\n\n    return {\n        /**\n         * Perform asynchronous GET request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @param {Object} headers\n         * @returns {Deferred}\n         */\n        get: function (url, global, contentType, headers) {\n            headers = headers || {};\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'GET',\n                global: global,\n                contentType: contentType,\n                headers: headers\n            });\n        },\n\n        /**\n         * Perform asynchronous POST request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @param {Object} headers\n         * @returns {Deferred}\n         */\n        post: function (url, data, global, contentType, headers) {\n            headers = headers || {};\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'POST',\n                data: data,\n                global: global,\n                contentType: contentType,\n                headers: headers\n            });\n        },\n\n        /**\n         * Perform asynchronous PUT request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @param {Object} headers\n         * @returns {Deferred}\n         */\n        put: function (url, data, global, contentType, headers) {\n            var ajaxSettings = {};\n\n            headers = headers || {};\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n            ajaxSettings.url = urlBuilder.build(url);\n            ajaxSettings.type = 'PUT';\n            ajaxSettings.data = data;\n            ajaxSettings.global = global;\n            ajaxSettings.contentType = contentType;\n            ajaxSettings.headers = headers;\n\n            return $.ajax(ajaxSettings);\n        },\n\n        /**\n         * Perform asynchronous DELETE request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @param {Object} headers\n         * @returns {Deferred}\n         */\n        delete: function (url, global, contentType, headers) {\n            headers = headers || {};\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'DELETE',\n                global: global,\n                contentType: contentType,\n                headers: headers\n            });\n        }\n    };\n});\n","mage/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/apply/main',\n    'Magento_Ui/js/lib/knockout/bootstrap'\n], function ($, mage) {\n    'use strict';\n\n    $.ajaxSetup({\n        cache: false\n    });\n\n    /**\n     * Init all components defined via data-mage-init attribute.\n     * Execute in a separate task to prevent main thread blocking.\n     */\n    setTimeout(mage.apply);\n});\n","mage/dropdown_old.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var ESC_KEY_CODE = '27';\n\n    $(document)\n        .on('click.dropdown', function (event) {\n            if (!$(event.target).is('[data-toggle=dropdown].active, ' +\n                '[data-toggle=dropdown].active *, ' +\n                '[data-toggle=dropdown].active + .dropdown-menu, ' +\n                '[data-toggle=dropdown].active + .dropdown-menu *,' +\n                '[data-toggle=dropdown].active + [data-target=\"dropdown\"],' +\n                '[data-toggle=dropdown].active + [data-target=\"dropdown\"] *')\n            ) {\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n            }\n        })\n        .on('keyup.dropdown', function (event) {\n            if (event.keyCode == ESC_KEY_CODE) { //eslint-disable-line eqeqeq\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n            }\n        });\n\n    /**\n     * @param {Object} options\n     */\n    $.fn.dropdown = function (options) {\n        options = $.extend({\n            parent: null,\n            btnArrow: '.arrow',\n            activeClass: 'active'\n        }, options);\n\n        return this.each(function () {\n            var elem = $(this);\n\n            elem.off('open.dropdown, close.dropdown, click.dropdown');\n            elem.on('open.dropdown', function () {\n                elem\n                    .addClass(options.activeClass)\n                    .parent()\n                    .addClass(options.activeClass);\n                elem.find(options.btnArrow).text('\\u25b2'); // arrow up\n            });\n\n            elem.on('close.dropdown', function () {\n                elem\n                    .removeClass(options.activeClass)\n                    .parent()\n                    .removeClass(options.activeClass);\n                elem.find(options.btnArrow).text('\\u25bc'); // arrow down\n            });\n\n            elem.on('click.dropdown', function () {\n                var isActive = elem.hasClass('active');\n\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n                elem.trigger(isActive ? 'close.dropdown' : 'open.dropdown');\n\n                return false;\n            });\n        });\n    };\n\n    return function (data, el) {\n        $(el).dropdown(data);\n    };\n});\n","mage/popup-window.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.popupWindow', {\n        options: {\n            centerBrowser: 0, // center window over browser window? {1 (YES) or 0 (NO)}. overrides top and left\n            centerScreen: 0, // center window over entire screen? {1 (YES) or 0 (NO)}. overrides top and left\n            height: 500, // sets the height in pixels of the window.\n            left: 0, // left position when the window appears.\n            location: 0, // determines whether the address bar is displayed {1 (YES) or 0 (NO)}.\n            menubar: 0, // determines whether the menu bar is displayed {1 (YES) or 0 (NO)}.\n            resizable: 0, // whether the window can be resized {1 (YES) or 0 (NO)}.\n            scrollbars: 0, // determines whether scrollbars appear on the window {1 (YES) or 0 (NO)}.\n            status: 0, // whether a status line appears at the bottom of the window {1 (YES) or 0 (NO)}.\n            width: 500, // sets the width in pixels of the window.\n            windowName: null, // name of window set from the name attribute of the element that invokes the click\n            windowURL: null, // url used for the popup\n            top: 0, // top position when the window appears.\n            toolbar: 0 // determines whether a toolbar is displayed {1 (YES) or 0 (NO)}.\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._openPopupWindow, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _openPopupWindow: function (event) {\n            var element = $(event.target),\n                settings = this.options,\n                windowFeatures =\n                    'height=' + settings.height +\n                        ',width=' + settings.width +\n                        ',toolbar=' + settings.toolbar +\n                        ',scrollbars=' + settings.scrollbars +\n                        ',status=' + settings.status +\n                        ',resizable=' + settings.resizable +\n                        ',location=' + settings.location +\n                        ',menuBar=' + settings.menubar,\n                centeredX,\n                centeredY;\n\n            settings.windowName = settings.windowName || element.attr('name');\n            settings.windowURL = settings.windowURL || element.attr('href');\n\n            if (settings.centerBrowser) {\n                centeredY = window.screenY + (window.outerHeight / 2 - settings.height / 2);\n                centeredX = window.screenX + (window.outerWidth / 2 - settings.width / 2);\n                windowFeatures += ',left=' + centeredX + ',top=' + centeredY;\n            } else if (settings.centerScreen) {\n                centeredY = (screen.height - settings.height) / 2;\n                centeredX = (screen.width - settings.width) / 2;\n                windowFeatures += ',left=' + centeredX + ',top=' + centeredY;\n            } else {\n                windowFeatures += ',left=' + settings.left + ',top=' + settings.top;\n            }\n\n            window.open(settings.windowURL, settings.windowName, windowFeatures).focus();\n            event.preventDefault();\n        }\n    });\n\n    return $.mage.popupWindow;\n});\n","mage/trim-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.trimInput', {\n        options: {\n            cache: {}\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function () {\n            this.options.cache.input = $(this.element);\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor change, keyup and paste events.\n         * @private\n         */\n        _bind: function () {\n            if (this.options.cache.input.length) {\n                this._on(this.options.cache.input, {\n                    'change': this._trimInput,\n                    'keyup': this._trimInput,\n                    'paste': this._trimInput\n                });\n            }\n        },\n\n        /**\n         * Trim value\n         * @private\n         */\n        _trimInput: function () {\n            // Safari caret position workaround: storing carter position\n            var caretStart, caretEnd, input;\n\n            caretStart = this.options.cache.input.get(0).selectionStart;\n            caretEnd = this.options.cache.input.get(0).selectionEnd;\n\n            input = this._getInputValue().trim();\n\n            this.options.cache.input.val(input);\n\n            // Safari caret position workaround: setting caret position to previously stored values\n            if (caretStart !== null && caretEnd !== null) {\n                this.options.cache.input.get(0).setSelectionRange(caretStart, caretEnd);\n            }\n        },\n\n        /**\n         * Get input value\n         * @returns {*}\n         * @private\n         */\n        _getInputValue: function () {\n            return this.options.cache.input.val();\n        }\n    });\n\n    return $.mage.trimInput;\n});\n","mage/touch-slider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'jquery-ui-modules/slider'\n], function ($, _) {\n    'use strict';\n\n    /**\n     * Adds support for touch events for regular jQuery UI slider.\n     */\n    $.widget('mage.touchSlider', $.ui.slider, {\n\n        /**\n         * Creates instance of widget.\n         *\n         * @override\n         */\n        _create: function () {\n            _.bindAll(\n                this,\n                '_mouseDown',\n                '_mouseMove',\n                '_onTouchEnd'\n            );\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Initializes mouse events on element.\n         * @override\n         */\n        _mouseInit: function () {\n            var result = this._superApply(arguments);\n\n            this.element\n                .off('mousedown.' + this.widgetName)\n                .on('touchstart.' + this.widgetName, this._mouseDown);\n\n            return result;\n        },\n\n        /**\n         * Elements' 'mousedown' event handler polyfill.\n         * @override\n         */\n        _mouseDown: function (event) {\n            var prevDelegate = this._mouseMoveDelegate,\n                result;\n\n            event = this._touchToMouse(event);\n            result = this._super(event);\n\n            if (prevDelegate === this._mouseMoveDelegate) {\n                return result;\n            }\n\n            $(document)\n                .off('mousemove.' + this.widgetName)\n                .off('mouseup.' + this.widgetName);\n\n            $(document)\n                .on('touchmove.' + this.widgetName, this._mouseMove)\n                .on('touchend.' + this.widgetName, this._onTouchEnd)\n                .on('tochleave.' + this.widgetName, this._onTouchEnd);\n\n            return result;\n        },\n\n        /**\n         * Documents' 'mousemove' event handler polyfill.\n         *\n         * @override\n         * @param {Event} event - Touch event object.\n         */\n        _mouseMove: function (event) {\n            event = this._touchToMouse(event);\n\n            return this._super(event);\n        },\n\n        /**\n         * Documents' 'touchend' event handler.\n         */\n        _onTouchEnd: function (event) {\n            $(document).trigger('mouseup');\n\n            return this._mouseUp(event);\n        },\n\n        /**\n         * Removes previously assigned touch handlers.\n         *\n         * @override\n         */\n        _mouseUp: function () {\n            this._removeTouchHandlers();\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Removes previously assigned touch handlers.\n         *\n         * @override\n         */\n        _mouseDestroy: function () {\n            this._removeTouchHandlers();\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Removes touch events from document object.\n         */\n        _removeTouchHandlers: function () {\n            $(document)\n                .off('touchmove.' + this.widgetName)\n                .off('touchend.' + this.widgetName)\n                .off('touchleave.' + this.widgetName);\n        },\n\n        /**\n         * Adds properties to the touch event to mimic mouse event.\n         *\n         * @param {Event} event - Touch event object.\n         * @returns {Event}\n         */\n        _touchToMouse: function (event) {\n            var orig = event.originalEvent,\n                touch = orig.touches[0];\n\n            return _.extend(event, {\n                which:      1,\n                pageX:      touch.pageX,\n                pageY:      touch.pageY,\n                clientX:    touch.clientX,\n                clientY:    touch.clientY,\n                screenX:    touch.screenX,\n                screenY:    touch.screenY\n            });\n        }\n    });\n\n    return $.mage.touchSlider;\n});\n","mage/template.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Checks if provided string is a valid DOM selector.\n     *\n     * @param {String} selector - Selector to be checked.\n     * @returns {Boolean}\n     */\n    function isSelector(selector) {\n        try {\n            document.querySelector(selector);\n\n            return true;\n        } catch (e) {\n            return false;\n        }\n    }\n\n    /**\n     * Unescapes characters used in underscore templates.\n     *\n     * @param {String} str - String to be processed.\n     * @returns {String}\n     */\n    function unescape(str) {\n        return str.replace(/&lt;%|%3C%/g, '<%').replace(/%&gt;|%%3E/g, '%>');\n    }\n\n    /**\n     * If 'tmpl' is a valid selector, returns target node's innerHTML if found.\n     * Else, returns empty string and emits console warning.\n     * If 'tmpl' is not a selector, returns 'tmpl' as is.\n     *\n     * @param {String} tmpl\n     * @returns {String}\n     */\n    function getTmplString(tmpl) {\n        if (isSelector(tmpl)) {\n            tmpl = document.querySelector(tmpl);\n\n            if (tmpl) {\n                tmpl = tmpl.innerHTML.trim();\n            } else {\n                console.warn('No template was found by selector: ' + tmpl);\n\n                tmpl = '';\n            }\n        }\n\n        return unescape(tmpl);\n    }\n\n    /**\n     * Compiles or renders template provided either\n     * by selector or by the template string.\n     *\n     * @param {String} tmpl - Template string or selector.\n     * @param {(Object|Array|Function)} [data] - Data object with which to render template.\n     * @returns {String|Function}\n     */\n    return function (tmpl, data) {\n        var render;\n\n        tmpl   = getTmplString(tmpl);\n        render = _.template(tmpl);\n\n        return !_.isUndefined(data) ?\n            render(data) :\n            render;\n    };\n});\n","mage/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'moment',\n    'mageUtils',\n    'jquery-ui-modules/widget',\n    'jquery/validate',\n    'mage/translate'\n], function ($, moment, utils) {\n    'use strict';\n\n    var creditCartTypes, rules, showLabel, originValidateDelegate;\n\n    $.extend(true, $, {\n        // @TODO: Move methods 'isEmpty', 'isEmptyNoTrim', 'parseNumber', 'stripHtml' in file with utility functions\n        mage: {\n            /**\n             * Check if string is empty with trim\n             * @param {String} value\n             */\n            isEmpty: function (value) {\n                return value === '' || value === undefined ||\n                    value == null || value.length === 0 || /^\\s+$/.test(value);\n            },\n\n            /**\n             * Check if string is empty no trim\n             * @param {String} value\n             */\n            isEmptyNoTrim: function (value) {\n                return value === '' || value == null || value.length === 0;\n            },\n\n            /**\n             * Checks if {value} is between numbers {from} and {to}\n             * @param {String} value\n             * @param {String} from\n             * @param {String} to\n             * @returns {Boolean}\n             */\n            isBetween: function (value, from, to) {\n                return ($.mage.isEmpty(from) || value >= $.mage.parseNumber(from)) &&\n                    ($.mage.isEmpty(to) || value <= $.mage.parseNumber(to));\n            },\n\n            /**\n             * Parse price string\n             * @param {String} value\n             */\n            parseNumber: function (value) {\n                var isDot, isComa;\n\n                if (typeof value !== 'string') {\n                    return parseFloat(value);\n                }\n                isDot = value.indexOf('.');\n                isComa = value.indexOf(',');\n\n                if (isDot !== -1 && isComa !== -1) {\n                    if (isComa > isDot) {\n                        value = value.replace('.', '').replace(',', '.');\n                    } else {\n                        value = value.replace(',', '');\n                    }\n                } else if (isComa !== -1) {\n                    value = value.replace(',', '.');\n                }\n\n                return parseFloat(value);\n            },\n\n            /**\n             * Removes HTML tags and space characters, numbers and punctuation.\n             *\n             * @param {String} value - Value being stripped.\n             * @return {String}\n             */\n            stripHtml: function (value) {\n                return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                    .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n            }\n        }\n    });\n\n    /**\n     * @param {String} name\n     * @param {*} method\n     * @param {*} message\n     * @param {*} dontSkip\n     */\n    $.validator.addMethod = function (name, method, message, dontSkip) {\n        $.validator.methods[name] = method;\n        $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];\n\n        if (method.length < 3 || dontSkip) {\n            $.validator.addClassRules(name, $.validator.normalizeRule(name));\n        }\n    };\n\n    /**\n     * Javascript object with credit card types\n     * 0 - regexp for card number\n     * 1 - regexp for cvn\n     * 2 - check or not credit card number trough Luhn algorithm by\n     */\n    creditCartTypes = {\n        'SO': [\n            new RegExp('^(6334[5-9]([0-9]{11}|[0-9]{13,14}))|(6767([0-9]{12}|[0-9]{14,15}))$'),\n            new RegExp('^([0-9]{3}|[0-9]{4})?$'),\n            true\n        ],\n        'SM': [\n            new RegExp('(^(5[0678])[0-9]{11,18}$)|(^(6[^05])[0-9]{11,18}$)|' +\n                '(^(601)[^1][0-9]{9,16}$)|(^(6011)[0-9]{9,11}$)|(^(6011)[0-9]{13,16}$)|' +\n                '(^(65)[0-9]{11,13}$)|(^(65)[0-9]{15,18}$)|(^(49030)[2-9]([0-9]{10}$|[0-9]{12,13}$))|' +\n                '(^(49033)[5-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49110)[1-2]([0-9]{10}$|[0-9]{12,13}$))|' +\n                '(^(49117)[4-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49118)[0-2]([0-9]{10}$|[0-9]{12,13}$))|' +\n                '(^(4936)([0-9]{12}$|[0-9]{14,15}$))'), new RegExp('^([0-9]{3}|[0-9]{4})?$'),\n            true\n        ],\n        'VI': [new RegExp('^4[0-9]{12}([0-9]{3})?$'), new RegExp('^[0-9]{3}$'), true],\n        'MC': [\n            new RegExp('^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}$'),\n            new RegExp('^[0-9]{3}$'),\n            true\n        ],\n        'AE': [new RegExp('^3[47][0-9]{13}$'), new RegExp('^[0-9]{4}$'), true],\n        'DI': [new RegExp('^(6011(0|[2-4]|74|7[7-9]|8[6-9]|9)|6(4[4-9]|5))\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'JCB': [new RegExp('^35(2[8-9]|[3-8])\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'DN': [new RegExp('^(3(0[0-5]|095|6|[8-9]))\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'UN': [\n            new RegExp('^(622(1(2[6-9]|[3-9])|[3-8]|9([[0-1]|2[0-5]))|62[4-6]|628([2-8]))\\\\d*?$'),\n            new RegExp('^[0-9]{3}$'),\n            true\n        ],\n        'MI': [new RegExp('^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'MD': [new RegExp('^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$'), new RegExp('^[0-9]{3}$'), true]\n    };\n\n    /**\n     * validate credit card number using mod10\n     * @param {String} s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = '0123456789',\n            w = '',\n            i, j, k, m, c, a, x;\n\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n\n            if (v.indexOf(x, 0) !== -1) {\n                w += x;\n            }\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n\n        return c % 10 === 0;\n    }\n\n    /**\n     * validate all table required inputs at once, using single hidden input\n     * @param {String} value\n     * @param {HTMLElement} element\n     *\n     * @return {Boolean}\n     */\n    function tableSingleValidation(value, element) {\n        var empty = $(element).closest('table')\n            .find('input.required-option:visible')\n            .filter(function (i, el) {\n                if ($(el).is('disabled')) {\n                    return $.mage.isEmpty(el.value);\n                }\n            })\n            .length;\n\n        return empty === 0;\n    }\n\n    /**\n     *\n     * @param {float} qty\n     * @param {float} qtyIncrements\n     * @returns {float}\n     */\n    function resolveModulo(qty, qtyIncrements) {\n        var divideEpsilon = 10000,\n            epsilon,\n            remainder;\n\n        while (qtyIncrements < 1) {\n            qty *= 10;\n            qtyIncrements *= 10;\n        }\n\n        epsilon = qtyIncrements / divideEpsilon;\n        remainder = qty % qtyIncrements;\n\n        if (Math.abs(remainder - qtyIncrements) < epsilon ||\n            Math.abs(remainder) < epsilon) {\n            remainder = 0;\n        }\n\n        return remainder;\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    rules = {\n        'max-words': [\n            function (value, element, params) {\n                return this.optional(element) || $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length <= params;\n            },\n            $.mage.__('Please enter {0} words or less.')\n        ],\n        'min-words': [\n            function (value, element, params) {\n                return this.optional(element) || $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            $.mage.__('Please enter at least {0} words.')\n        ],\n        'range-words': [\n            function (value, element, params) {\n                return this.optional(element) ||\n                    $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length >= params[0] &&\n                    value.match(/bw+b/g).length < params[1];\n            },\n            $.mage.__('Please enter between {0} and {1} words.')\n        ],\n        'letters-with-basic-punc': [\n            function (value, element) {\n                return this.optional(element) || /^[a-z\\-.,()'\\\"\\s]+$/i.test(value);\n            },\n            $.mage.__('Letters or punctuation only please')\n        ],\n        'alphanumeric': [\n            function (value, element) {\n                return this.optional(element) || /^\\w+$/i.test(value);\n            },\n            $.mage.__('Letters, numbers, spaces or underscores only please')\n        ],\n        'letters-only': [\n            function (value, element) {\n                return this.optional(element) || /^[a-z]+$/i.test(value);\n            },\n            $.mage.__('Letters only please')\n        ],\n        'no-whitespace': [\n            function (value, element) {\n                return this.optional(element) || /^\\S+$/i.test(value);\n            },\n            $.mage.__('No white space please')\n        ],\n        'no-marginal-whitespace': [\n            function (value, element) {\n                return this.optional(element) || !/^\\s+|\\s+$/i.test(value);\n            },\n            $.mage.__('No marginal white space please')\n        ],\n        'zip-range': [\n            function (value, element) {\n                return this.optional(element) || /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            $.mage.__('Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx')\n        ],\n        'integer': [\n            function (value, element) {\n                return this.optional(element) || /^-?\\d+$/.test(value);\n            },\n            $.mage.__('A positive or negative non-decimal number please')\n        ],\n        'vinUS': [\n            function (v) {\n                var i, n, d, f, cd, cdv, LL, VL, FL, rs;\n\n                /* eslint-disable max-depth */\n                if (v.length !== 17) {\n                    return false;\n                }\n\n                LL = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L',\n                    'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];\n                VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9];\n                FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2];\n                rs = 0;\n\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = v.slice(i, i + 1);\n\n                    if (i === 8) {\n                        cdv = d;\n                    }\n\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {\n                            if (d.toUpperCase() === LL[n]) {\n                                d = VL[n];\n                                d *= f;\n\n                                if (isNaN(cdv) && n === 8) {\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n\n                /* eslint-enable max-depth */\n                cd = rs % 11;\n\n                if (cd === 10) {\n                    cd = 'X';\n                }\n\n                if (cd === cdv) {\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('The specified vehicle identification number (VIN) is invalid.')\n        ],\n        'dateITA': [\n            function (value, element) {\n                var check = false,\n                    re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/,\n                    adata, gg, mm, aaaa, xdata;\n\n                if (re.test(value)) {\n                    adata = value.split('/');\n                    gg = parseInt(adata[0], 10);\n                    mm = parseInt(adata[1], 10);\n                    aaaa = parseInt(adata[2], 10);\n                    xdata = new Date(aaaa, mm - 1, gg);\n\n                    if (xdata.getFullYear() === aaaa &&\n                        xdata.getMonth() === mm - 1 &&\n                        xdata.getDate() === gg\n                    ) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n\n                return this.optional(element) || check;\n            },\n            $.mage.__('Please enter a correct date')\n        ],\n        'dateNL': [\n            function (value, element) {\n                return this.optional(element) || /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            'Vul hier een geldige datum in.'\n        ],\n        'time': [\n            function (value, element) {\n                return this.optional(element) || /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 and 23:59')\n        ],\n        'time12h': [\n            function (value, element) {\n                return this.optional(element) || /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\s[AP]M))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 am and 12:00 pm')\n        ],\n        'phoneUS': [\n            function (phoneNumber, element) {\n                phoneNumber = phoneNumber.replace(/\\s+/g, '');\n\n                return this.optional(element) || phoneNumber.length > 9 &&\n                    phoneNumber.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'phoneUK': [\n            function (phoneNumber, element) {\n                return this.optional(element) || phoneNumber.length > 9 &&\n                    phoneNumber.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'mobileUK': [\n            function (phoneNumber, element) {\n                return this.optional(element) || phoneNumber.length > 9 &&\n                    phoneNumber.match(/^((0|\\+44)7\\d{3}\\s?\\d{6})$/);\n            },\n            $.mage.__('Please specify a valid mobile number')\n        ],\n        'stripped-min-length': [\n            function (value, element, param) {\n                return value.length >= param;\n            },\n            $.mage.__('Please enter at least {0} characters')\n        ],\n\n        /* detect chars that would require more than 3 bytes */\n        'validate-no-utf8mb4-characters': [\n            function (value) {\n                var validator = this,\n                    message = $.mage.__('Please remove invalid characters: {0}.'),\n                    matches = value.match(/(?:[\\uD800-\\uDBFF][\\uDC00-\\uDFFF])/g),\n                    result = matches === null;\n\n                if (!result) {\n                    validator.charErrorMessage = message.replace('{0}', matches.join());\n                }\n\n                return result;\n            }, function () {\n                return this.charErrorMessage;\n            }\n        ],\n\n        /* eslint-disable max-len */\n        'email2': [\n            function (value, element) {\n                return this.optional(element) ||\n                    /^((([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\x22)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\x22)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);\n            },\n            $.validator.messages.email\n        ],\n        'url2': [\n            function (value, element) {\n                return this.optional(element) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);\n            },\n            $.validator.messages.url\n        ],\n\n        /* eslint-enable max-len */\n        'credit-card-types': [\n            function (value, element, param) {\n                var validTypes;\n\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, '');\n\n                validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n\n        /* eslint-disable max-len */\n        'ipv4': [\n            function (value, element) {\n                return this.optional(element) ||\n                    /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);\n            },\n            $.mage.__('Please enter a valid IP v4 address.')\n        ],\n        'ipv6': [\n            function (value, element) {\n                return this.optional(element) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid IP v6 address.')\n        ],\n\n        /* eslint-enable max-len */\n        'pattern': [\n            function (value, element, param) {\n                return this.optional(element) || new RegExp(param).test(value);\n            },\n            $.mage.__('Invalid format.')\n        ],\n        'allow-container-className': [\n            function (element) {\n                if (element.type === 'radio' || element.type === 'checkbox') {\n                    return $(element).hasClass('change-container-classname');\n                }\n            },\n            ''\n        ],\n        'validate-no-html-tags': [\n            function (value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            $.mage.__('HTML tags are not allowed.')\n        ],\n        'validate-select': [\n            function (value) {\n                return value !== 'none' && value != null && value.length !== 0;\n            },\n            $.mage.__('Please select an option.')\n        ],\n        'validate-no-empty': [\n            function (value) {\n                return !$.mage.isEmpty(value);\n            },\n            $.mage.__('Empty Value.')\n        ],\n        'validate-alphanum-with-spaces': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z0-9 ]+$/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.')\n        ],\n        'validate-data': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.') //eslint-disable-line max-len\n        ],\n        'validate-street': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.')\n        ],\n        'validate-phoneStrict': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(v);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-phoneLax': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) ||\n                    /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(v);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-fax': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(v);\n            },\n            $.mage.__('Please enter a valid fax number (Ex: 123-456-7890).')\n        ],\n        'validate-email': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(v); //eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-emailSender': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[\\S ]+$/.test(v);\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-password': [\n            function (v) {\n                var pass;\n\n                if (v == null) {\n                    return false;\n                }\n                //strip leading and trailing spaces\n                pass = v.trim();\n\n                if (!pass.length) {\n                    return true;\n                }\n\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-admin-password': [\n            function (v) {\n                var pass;\n\n                if (v == null) {\n                    return false;\n                }\n                pass = v.trim();\n                // strip leading and trailing spaces\n                if (pass.length === 0) {\n                    return true;\n                }\n\n                if (!/[a-z]/i.test(v) || !/[0-9]/.test(v)) {\n                    return false;\n                }\n\n                if (pass.length < 7) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 7 or more characters, using both numeric and alphabetic.')\n        ],\n        'validate-customer-password': [\n            function (v, elm) {\n                var validator = this,\n                    counter = 0,\n                    passwordMinLength = $(elm).data('password-min-length'),\n                    passwordMinCharacterSets = $(elm).data('password-min-character-sets'),\n                    pass = v.trim(),\n                    result = pass.length >= passwordMinLength;\n\n                if (result === false) {\n                    validator.passwordErrorMessage = $.mage.__('Minimum length of this field must be equal or greater than %1 symbols. Leading and trailing spaces will be ignored.').replace('%1', passwordMinLength); //eslint-disable-line max-len\n\n                    return result;\n                }\n\n                if (pass.match(/\\d+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[a-z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[A-Z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter++;\n                }\n\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__('Minimum of different classes of characters in password is %1. Classes of characters: Lower Case, Upper Case, Digits, Special Characters.').replace('%1', passwordMinCharacterSets); //eslint-disable-line max-len\n                }\n\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        'validate-url': [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = (v || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(v); //eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. Protocol is required (http://, https:// or ftp://).')\n        ],\n        'validate-clean-url': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v); //eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. For example http://www.example.com or www.example.com.')\n        ],\n        'validate-xml-identifier': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(v);\n\n            },\n            $.mage.__('Please enter a valid XML-identifier (Ex: something_1, block5, id-4).')\n        ],\n        'validate-ssn': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(v);\n\n            },\n            $.mage.__('Please enter a valid social security number (Ex: 123-45-6789).')\n        ],\n        'validate-zip-us': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(v);\n\n            },\n            $.mage.__('Please enter a valid zip code (Ex: 90602 or 90602-1234).')\n        ],\n        'validate-date-au': [\n            function (v) {\n                var regex, d;\n\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/;\n\n                if ($.mage.isEmpty(v) || !regex.test(v)) {\n                    return false;\n                }\n                d = new Date(v.replace(regex, '$2/$1/$3'));\n\n                return parseInt(RegExp.$2, 10) === 1 + d.getMonth() &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            $.mage.__('Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.')\n        ],\n        'validate-currency-dollar': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(v); //eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid $ amount. For example $100.00.')\n        ],\n        'validate-not-negative-number': [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n\n                return !isNaN(v) && v >= 0;\n\n            },\n            $.mage.__('Please enter a number 0 or greater in this field.')\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        'validate-zero-or-greater': [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n\n                return !isNaN(v) && v >= 0;\n\n            },\n            $.mage.__('Please enter a number 0 or greater in this field.')\n        ],\n        'validate-greater-than-zero': [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n\n                return !isNaN(v) && v > 0;\n            },\n            $.mage.__('Please enter a number greater than 0 in this field.')\n        ],\n        'validate-css-length': [\n            function (v) {\n                if (v !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(v);\n                }\n\n                return true;\n            },\n            $.mage.__('Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).')\n        ],\n        // Additional methods\n        'validate-number': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || !isNaN($.mage.parseNumber(v)) && /^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(v);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'required-number': [\n            function (v) {\n                return !!v.length;\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-number-range': [\n            function (v, elm, param) {\n                var numValue, dataAttrRange, classNameRange, result, range, m, classes, ii;\n\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                numValue = $.mage.parseNumber(v);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/;\n                classNameRange = /^number-range-(-?[\\d.,]+)?-(-?[\\d.,]+)?$/;\n                result = true;\n                range = param;\n\n                if (typeof range === 'string') {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                    } else {\n                        result = false;\n                    }\n                } else if (elm && elm.className) {\n                    classes = elm.className.split(' ');\n                    ii = classes.length;\n\n                    while (ii--) {\n                        range = classes[ii];\n                        m = classNameRange.exec(range);\n\n                        if (m) { //eslint-disable-line max-depth\n                            result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                            break;\n                        }\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.'),\n            true\n        ],\n        'validate-digits': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || !/[^\\d]/.test(v);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-forbidden-extensions': [\n            function (v, elem) {\n                var forbiddenExtensions = $(elem).attr('data-validation-params'),\n                    forbiddenExtensionsArray = forbiddenExtensions.split(','),\n                    extensionsArray = v.split(','),\n                    result = true;\n\n                this.validateExtensionsMessage = $.mage.__('Forbidden extensions has been used. Avoid usage of ') +\n                    forbiddenExtensions;\n\n                $.each(extensionsArray, function (key, extension) {\n                    if (forbiddenExtensionsArray.indexOf(extension) !== -1) {\n                        result = false;\n                    }\n                });\n\n                return result;\n            }, function () {\n                return this.validateExtensionsMessage;\n            }\n        ],\n        'validate-digits-range': [\n            function (v, elm, param) {\n                var numValue, dataAttrRange, classNameRange, result, range, m, classes, ii;\n\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                numValue = $.mage.parseNumber(v);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/;\n                classNameRange = /^digits-range-(-?\\d+)?-(-?\\d+)?$/;\n                result = true;\n                range = param;\n\n                if (typeof range === 'string') {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                    } else {\n                        result = false;\n                    }\n                } else if (elm && elm.className) {\n                    classes = elm.className.split(' ');\n                    ii = classes.length;\n\n                    while (ii--) {\n                        range = classes[ii];\n                        m = classNameRange.exec(range);\n\n                        if (m) { //eslint-disable-line max-depth\n                            result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                            break;\n                        }\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.'),\n            true\n        ],\n        'validate-range': [\n            function (v, elm) {\n                var minValue, maxValue, ranges, reRange, result, values,\n                    i, name, validRange, minValidRange, maxValidRange;\n\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](v)) {\n                    minValue = maxValue = $.mage.parseNumber(v);\n                } else {\n                    ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(v);\n\n                    if (ranges) {\n                        minValue = $.mage.parseNumber(ranges[1]);\n                        maxValue = $.mage.parseNumber(ranges[2]);\n\n                        if (minValue > maxValue) { //eslint-disable-line max-depth\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n                reRange = /^range-(-?\\d+)?-(-?\\d+)?$/;\n                result = true;\n                values = $(elm).prop('class').split(' ');\n\n                for (i = values.length - 1; i >= 0; i--) {\n                    name = values[i];\n                    validRange = reRange.exec(name);\n\n                    if (validRange) {\n                        minValidRange = $.mage.parseNumber(validRange[1]);\n                        maxValidRange = $.mage.parseNumber(validRange[2]);\n                        result = result &&\n                            (isNaN(minValidRange) || minValue >= minValidRange) &&\n                            (isNaN(maxValidRange) || maxValue <= maxValidRange);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-alpha': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z]+$/.test(v);\n            },\n            $.mage.__('Please use letters only (a-z or A-Z) in this field.')\n        ],\n        'validate-code': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z]+[a-zA-Z0-9_]+$/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.') //eslint-disable-line max-len\n        ],\n        'validate-alphanum': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z0-9]+$/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.') //eslint-disable-line max-len\n        ],\n        'validate-not-number-first': [\n            function (value) {\n                return $.mage.isEmptyNoTrim(value) || /^[^0-9-\\.].*$/.test(value.trim());\n            },\n            $.mage.__('First character must be letter.')\n        ],\n        'validate-date': [\n            function (value, params, additionalParams) {\n                var test = moment(value, utils.convertToMomentFormat(additionalParams.dateFormat));\n\n                return $.mage.isEmptyNoTrim(value) || test.isValid();\n            },\n            $.mage.__('Please enter a valid date.')\n\n        ],\n        'validate-date-range': [\n            function (v, elm) {\n                var m = /\\bdate-range-(\\w+)-(\\w+)\\b/.exec(elm.className),\n                    currentYear, normalizedTime, dependentElements;\n\n                if (!m || m[2] === 'to' || $.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                currentYear = new Date().getFullYear() + '';\n\n                /**\n                 * @param {String} vd\n                 * @return {Number}\n                 */\n                normalizedTime = function (vd) {\n                    vd = vd.split(/[.\\/]/);\n\n                    if (vd[2] && vd[2].length < 4) {\n                        vd[2] = currentYear.substr(0, vd[2].length) + vd[2];\n                    }\n\n                    return new Date(vd.join('/')).getTime();\n                };\n\n                dependentElements = $(elm.form).find('.validate-date-range.date-range-' + m[1] + '-to');\n\n                return !dependentElements.length || $.mage.isEmptyNoTrim(dependentElements[0].value) ||\n                    normalizedTime(v) <= normalizedTime(dependentElements[0].value);\n            },\n            $.mage.__('Make sure the To Date is later than or the same as the From Date.')\n        ],\n        'validate-cpassword': [\n            function () {\n                var conf = $('#confirmation').length > 0 ? $('#confirmation') : $($('.validate-cpassword')[0]),\n                    pass = false,\n                    passwordElements, i, passwordElement;\n\n                if ($('#password')) {\n                    pass = $('#password');\n                }\n                passwordElements = $('.validate-password');\n\n                for (i = 0; i < passwordElements.length; i++) {\n                    passwordElement = $(passwordElements[i]);\n\n                    if (passwordElement.closest('form').attr('id') === conf.closest('form').attr('id')) {\n                        pass = passwordElement;\n                    }\n                }\n\n                if ($('.validate-admin-password').length) {\n                    pass = $($('.validate-admin-password')[0]);\n                }\n\n                return pass.val() === conf.val();\n            },\n            $.mage.__('Please make sure your passwords match.')\n        ],\n        'validate-identifier': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(v);\n            },\n            $.mage.__('Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").') //eslint-disable-line max-len\n        ],\n        'validate-zip-international': [\n\n            /*function(v) {\n             // @TODO: Cleanup\n             return Validation.get('IsEmpty').test(v) ||\n             /(^[A-z0-9]{2,10}([\\s]{0,1}|[\\-]{0,1})[A-z0-9]{2,10}$)/.test(v);\n             }*/\n            function () {\n                return true;\n            },\n            $.mage.__('Please enter a valid zip code.')\n        ],\n        'validate-one-required': [\n            function (v, elm) {\n                var p = $(elm).parent(),\n                    options = p.find('input');\n\n                return options.map(function (el) {\n                    return $(el).val();\n                }).length > 0;\n            },\n            $.mage.__('Please select one of the options above.')\n        ],\n        'validate-state': [\n            function (v) {\n                return v !== 0;\n            },\n            $.mage.__('Please select State/Province.')\n        ],\n        'required-file': [\n            function (v, elm) {\n                var result = !$.mage.isEmptyNoTrim(v),\n                    ovId;\n\n                if (!result) {\n                    ovId = $('#' + $(elm).attr('id') + '_value');\n\n                    if (ovId.length > 0) {\n                        result = !$.mage.isEmptyNoTrim(ovId.val());\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('Please select a file.')\n        ],\n        'validate-ajax-error': [\n            function (v, element) {\n                element = $(element);\n                element.on('change.ajaxError', function () {\n                    element.removeClass('validate-ajax-error');\n                    element.off('change.ajaxError');\n                });\n\n                return !element.hasClass('validate-ajax-error');\n            },\n            ''\n        ],\n        'validate-optional-datetime': [\n            function (v, elm, param) {\n                var dateTimeParts = $('.datetime-picker[id^=\"options_' + param + '\"]'),\n                    hasWithValue = false,\n                    hasWithNoValue = false,\n                    pattern = /day_part$/i,\n                    i;\n\n                for (i = 0; i < dateTimeParts.length; i++) {\n                    if (!pattern.test($(dateTimeParts[i]).attr('id'))) {\n                        if ($(dateTimeParts[i]).val() === 's') { //eslint-disable-line max-depth\n                            hasWithValue = true;\n                        } else {\n                            hasWithNoValue = true;\n                        }\n                    }\n                }\n\n                return hasWithValue ^ hasWithNoValue;\n            },\n            $.mage.__('The field isn\\'t complete.')\n        ],\n        'validate-required-datetime': [\n            function (v, elm, param) {\n                var dateTimeParts = $('.datetime-picker[id^=\"options_' + param + '\"]'),\n                    i;\n\n                for (i = 0; i < dateTimeParts.length; i++) {\n                    if (dateTimeParts[i].value === '') {\n                        return false;\n                    }\n                }\n\n                return true;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'validate-one-required-by-name': [\n            function (v, elm, selector) {\n                var name = elm.name.replace(/([\\\\\"])/g, '\\\\$1'),\n                    container = this.currentForm;\n\n                selector = selector === true ? 'input[name=\"' + name + '\"]:checked' : selector;\n\n                return !!container.querySelectorAll(selector).length;\n            },\n            $.mage.__('Please select one of the options.')\n        ],\n        'less-than-equals-to': [\n            function (value, element, params) {\n                if ($.isNumeric($(params).val()) && $.isNumeric(value)) {\n                    this.lteToVal = $(params).val();\n\n                    return parseFloat(value) <= parseFloat($(params).val());\n                }\n\n                return true;\n            },\n            function () {\n                var message = $.mage.__('Please enter a value less than or equal to %s.');\n\n                return message.replace('%s', this.lteToVal);\n            }\n        ],\n        'greater-than-equals-to': [\n            function (value, element, params) {\n                if ($.isNumeric($(params).val()) && $.isNumeric(value)) {\n                    this.gteToVal = $(params).val();\n\n                    return parseFloat(value) >= parseFloat($(params).val());\n                }\n\n                return true;\n            },\n            function () {\n                var message = $.mage.__('Please enter a value greater than or equal to %s.');\n\n                return message.replace('%s', this.gteToVal);\n            }\n        ],\n        'validate-emails': [\n            function (value) {\n                var validRegexp, emails, i;\n\n                if ($.mage.isEmpty(value)) {\n                    return true;\n                }\n                validRegexp = /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i; //eslint-disable-line max-len\n                emails = value.split(/[\\s\\n\\,]+/g);\n\n                for (i = 0; i < emails.length; i++) {\n                    if (!validRegexp.test(emails[i].trim())) {\n                        return false;\n                    }\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter valid email addresses, separated by commas. For example, johndoe@domain.com, johnsmith@domain.com.') //eslint-disable-line max-len\n        ],\n\n        'validate-cc-type-select': [\n\n            /**\n             * Validate credit card type matches credit card number\n             * @param {*} value - select credit card type\n             * @param {*} element - element contains the select box for credit card types\n             * @param {*} params - selector for credit card number\n             * @return {Boolean}\n             */\n            function (value, element, params) {\n                if (value && params && creditCartTypes[value]) {\n                    return creditCartTypes[value][0].test($(params).val().replace(/\\s+/g, ''));\n                }\n\n                return false;\n            },\n            $.mage.__('Card type does not match credit card number.')\n        ],\n        'validate-cc-number': [\n\n            /**\n             * Validate credit card number based on mod 10.\n             *\n             * @param {*} value - credit card number\n             * @return {Boolean}\n             */\n            function (value) {\n                if (value) {\n                    return validateCreditCard(value);\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-cc-type': [\n\n            /**\n             * Validate credit card number is for the correct credit card type.\n             *\n             * @param {String} value - credit card number\n             * @param {*} element - element contains credit card number\n             * @param {*} params - selector for credit card type\n             * @return {Boolean}\n             */\n            function (value, element, params) {\n                var ccType;\n\n                if (value && params) {\n                    ccType = $(params).val();\n                    value = value.replace(/\\s/g, '').replace(/\\-/g, '');\n\n                    if (creditCartTypes[ccType] && creditCartTypes[ccType][0]) {\n                        return creditCartTypes[ccType][0].test(value);\n                    } else if (creditCartTypes[ccType] && !creditCartTypes[ccType][0]) {\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n            $.mage.__('Credit card number does not match credit card type.')\n        ],\n        'validate-cc-exp': [\n\n            /**\n             * Validate credit card expiration date, make sure it's within the year and not before current month.\n             *\n             * @param {*} value - month\n             * @param {*} element - element contains month\n             * @param {*} params - year selector\n             * @return {Boolean}\n             */\n            function (value, element, params) {\n                var isValid = false,\n                    month, year, currentTime, currentMonth, currentYear;\n\n                if (value && params) {\n                    month = value;\n                    year = $(params).val();\n                    currentTime = new Date();\n                    currentMonth = currentTime.getMonth() + 1;\n                    currentYear = currentTime.getFullYear();\n\n                    isValid = !year || year > currentYear || year == currentYear && month >= currentMonth; //eslint-disable-line\n                }\n\n                return isValid;\n            },\n            $.mage.__('Incorrect credit card expiration date.')\n        ],\n        'validate-cc-cvn': [\n\n            /**\n             * Validate credit card cvn based on credit card type.\n             *\n             * @param {*} value - credit card cvn\n             * @param {*} element - element contains credit card cvn\n             * @param {*} params - credit card type selector\n             * @return {*}\n             */\n            function (value, element, params) {\n                var ccType;\n\n                if (value && params) {\n                    ccType = $(params).val();\n\n                    if (creditCartTypes[ccType] && creditCartTypes[ccType][0]) {\n                        return creditCartTypes[ccType][1].test(value);\n                    }\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card verification number.')\n        ],\n        'validate-cc-ukss': [\n\n            /**\n             * Validate Switch/Solo/Maestro issue number and start date is filled.\n             *\n             * @param {*} value - input field value\n             * @return {*}\n             */\n            function (value) {\n                return value;\n            },\n            $.mage.__('Please enter issue number or start date for switch/solo card type.')\n        ],\n        'validate-length': [\n            function (v, elm) {\n                var reMax = new RegExp(/^maximum-length-[0-9]+$/),\n                    reMin = new RegExp(/^minimum-length-[0-9]+$/),\n                    validator = this,\n                    result = true,\n                    length = 0;\n\n                $.each(elm.className.split(' '), function (index, name) {\n                    if (name.match(reMax) && result) {\n                        length = name.split('-')[2];\n                        result = v.length <= length;\n                        validator.validateMessage =\n                            $.mage.__('Please enter less or equal than %1 symbols.').replace('%1', length);\n                    }\n\n                    if (name.match(reMin) && result && !$.mage.isEmpty(v)) {\n                        length = name.split('-')[2];\n                        result = v.length >= length;\n                        validator.validateMessage =\n                            $.mage.__('Please enter more or equal than %1 symbols.').replace('%1', length);\n                    }\n                });\n\n                return result;\n            }, function () {\n                return this.validateMessage;\n            }\n        ],\n        'required-entry': [\n            function (value) {\n                return !$.mage.isEmpty(value);\n            }, $.mage.__('This is a required field.')\n        ],\n        'not-negative-amount': [\n            function (v) {\n                if (v.length) {\n                    return (/^\\s*\\d+([,.]\\d+)*\\s*%?\\s*$/).test(v);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter positive number in this field.')\n        ],\n        'validate-per-page-value-list': [\n            function (v) {\n                var isValid = true,\n                    values = v.split(','),\n                    i;\n\n                if ($.mage.isEmpty(v)) {\n                    return isValid;\n                }\n\n                for (i = 0; i < values.length; i++) {\n                    if (!/^[0-9]+$/.test(values[i])) {\n                        isValid = false;\n                    }\n                }\n\n                return isValid;\n            },\n            $.mage.__('Please enter a valid value, ex: 10,20,30')\n        ],\n        'validate-per-page-value': [\n            function (v, elm) {\n                var values;\n\n                if ($.mage.isEmpty(v)) {\n                    return false;\n                }\n                values = $('#' + elm.id + '_values').val().split(',');\n\n                return values.indexOf(v) !== -1;\n            },\n            $.mage.__('Please enter a valid value from list')\n        ],\n        'validate-new-password': [\n            function (v) {\n                if ($.validator.methods['validate-password'] && !$.validator.methods['validate-password'](v)) {\n                    return false;\n                }\n\n                if ($.mage.isEmpty(v) && v !== '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'required-if-not-specified': [\n            function (value, element, params) {\n                var valid = false,\n                    alternate = $(params),\n                    alternateValue;\n\n                if (alternate.length > 0) {\n                    valid = this.check(alternate);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        alternateValue = alternate.val();\n\n                        if (typeof alternateValue == 'undefined' || alternateValue.length === 0) { //eslint-disable-line\n                            valid = false;\n                        }\n                    }\n                }\n\n                if (!valid) {\n                    valid = !this.optional(element);\n                }\n\n                return valid;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'required-if-all-sku-empty-and-file-not-loaded': [\n            function (value, element, params) {\n                var valid = false,\n                    alternate = $(params.specifiedId),\n                    alternateValue;\n\n                if (alternate.length > 0) {\n                    valid = this.check(alternate);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        alternateValue = alternate.val();\n\n                        if (typeof alternateValue == 'undefined' || alternateValue.length === 0) { //eslint-disable-line\n                            valid = false;\n                        }\n                    }\n                }\n\n                if (!valid) {\n                    valid = !this.optional(element);\n                }\n\n                $('input[' + params.dataSku + '=true]').each(function () {\n                    if ($(this).val() !== '') {\n                        valid = true;\n                    }\n                });\n\n                return valid;\n            },\n            $.mage.__('Please enter valid SKU key.')\n        ],\n        'required-if-specified': [\n            function (value, element, params) {\n                var valid = true,\n                    dependent = $(params),\n                    dependentValue;\n\n                if (dependent.length > 0) {\n                    valid = this.check(dependent);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        dependentValue = dependent.val();\n                        valid = typeof dependentValue != 'undefined' && dependentValue.length > 0;\n                    }\n                }\n\n                if (valid) {\n                    valid = !this.optional(element);\n                } else {\n                    valid = true; // dependent was not valid, so don't even check\n                }\n\n                return valid;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'required-number-if-specified': [\n            function (value, element, params) {\n                var valid = true,\n                    dependent = $(params),\n                    depeValue;\n\n                if (dependent.length) {\n                    valid = this.check(dependent);\n\n                    if (valid) {\n                        depeValue = dependent[0].value;\n                        valid = !!(depeValue && depeValue.length);\n                    }\n                }\n\n                return valid ? !!value.length : true;\n            },\n            $.mage.__('Please enter a valid number.')\n        ],\n        'datetime-validation': [\n            function (value, element) {\n                var isValid = true;\n\n                if ($(element).val().length === 0) {\n                    isValid = false;\n                    $(element).addClass('mage-error');\n                }\n\n                return isValid;\n            },\n            $.mage.__('This is required field')\n        ],\n        'required-text-swatch-entry': [\n            tableSingleValidation,\n            $.mage.__('Admin is a required field in each row.')\n        ],\n        'required-visual-swatch-entry': [\n            tableSingleValidation,\n            $.mage.__('Admin is a required field in each row.')\n        ],\n        'required-dropdown-attribute-entry': [\n            tableSingleValidation,\n            $.mage.__('Admin is a required field in each row.')\n        ],\n        'validate-item-quantity': [\n            function (value, element, params) {\n                var validator = this,\n                    result = false,\n                    // obtain values for validation\n                    qty = $.mage.parseNumber(value),\n                    isMinAllowedValid = typeof params.minAllowed === 'undefined' ||\n                        qty >= $.mage.parseNumber(params.minAllowed),\n                    isMaxAllowedValid = typeof params.maxAllowed === 'undefined' ||\n                        qty <= $.mage.parseNumber(params.maxAllowed),\n                    isQtyIncrementsValid = typeof params.qtyIncrements === 'undefined' ||\n                        resolveModulo(qty, $.mage.parseNumber(params.qtyIncrements)) === 0.0;\n\n                result = qty > 0;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('Please enter a quantity greater than 0.');//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMinAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The fewest you may purchase is %1.').replace('%1', params.minAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMaxAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The maximum you may purchase is %1.').replace('%1', params.maxAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isQtyIncrementsValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('You can buy this product only in quantities of %1 at a time.').replace('%1', params.qtyIncrements);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                return result;\n            }, function () {\n                return this.itemQtyErrorMessage;\n            }\n        ],\n        'password-not-equal-to-user-name': [\n            function (value, element, params) {\n                if (typeof params === 'string') {\n                    return value.toLowerCase() !== params.toLowerCase();\n                }\n\n                return true;\n            },\n            $.mage.__('The password can\\'t be the same as the email address. Create a new password and try again.')\n        ]\n    };\n\n    $.each(rules, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n    $.validator.addClassRules({\n        'required-option': {\n            required: true\n        },\n        'required-options-count': {\n            required: true\n        },\n        'validate-both-passwords': {\n            'validate-cpassword': true\n        }\n    });\n    $.validator.messages = $.extend($.validator.messages, {\n        required: $.mage.__('This is a required field.'),\n        remote: $.mage.__('Please fix this field.'),\n        email: $.mage.__('Please enter a valid email address.'),\n        url: $.mage.__('Please enter a valid URL.'),\n        date: $.mage.__('Please enter a valid date.'),\n        dateISO: $.mage.__('Please enter a valid date (ISO).'),\n        number: $.mage.__('Please enter a valid number.'),\n        digits: $.mage.__('Please enter only digits.'),\n        creditcard: $.mage.__('Please enter a valid credit card number.'),\n        equalTo: $.mage.__('Please enter the same value again.'),\n        maxlength: $.validator.format($.mage.__('Please enter no more than {0} characters.')),\n        minlength: $.validator.format($.mage.__('Please enter at least {0} characters.')),\n        rangelength: $.validator.format($.mage.__('Please enter a value between {0} and {1} characters long.')),\n        range: $.validator.format($.mage.__('Please enter a value between {0} and {1}.')),\n        max: $.validator.format($.mage.__('Please enter a value less than or equal to {0}.')),\n        min: $.validator.format($.mage.__('Please enter a value greater than or equal to {0}.'))\n    });\n\n    if ($.metadata) {\n        // Setting the type as html5 to enable data-validate attribute\n        $.metadata.setType('html5');\n    }\n\n    showLabel = $.validator.prototype.showLabel;\n    $.extend(true, $.validator.prototype, {\n        /**\n         * @param {*} element\n         * @param {*} message\n         */\n        showLabel: function (element, message) {\n            var label, elem;\n\n            showLabel.call(this, element, message);\n\n            // ARIA (adding aria-invalid & aria-describedby)\n            label = this.errorsFor(element);\n            elem = $(element);\n\n            if (!label.attr('id')) {\n                label.attr('id', this.idOrName(element) + '-error');\n            }\n            elem.attr('aria-invalid', 'true')\n                .attr('aria-describedby', label.attr('id'));\n        }\n    });\n\n    /**\n     * Validate form field without instantiating validate plug-in.\n     *\n     * @param {Element|String} element - DOM element or selector\n     * @return {Boolean} validation result\n     */\n    $.validator.validateElement = function (element) {\n        var form, validator, valid, classes;\n\n        element = $(element);\n        form = element.get(0).form;\n        validator = form ? $(form).data('validator') : null;\n\n        if (validator) {\n            return validator.element(element.get(0));\n        }\n        valid = true;\n        classes = element.prop('class').split(' ');\n        $.each(classes, $.proxy(function (i, className) {\n            if (this.methods[className] && !this.methods[className](element.val(), element.get(0))) {\n                valid = false;\n\n                return valid;\n            }\n        }, this));\n\n        return valid;\n    };\n\n    originValidateDelegate = $.fn.validateDelegate;\n\n    /**\n     * @return {*}\n     */\n    $.fn.validateDelegate = function () {\n        if (!this[0].form) {\n            return this;\n        }\n\n        return originValidateDelegate.apply(this, arguments);\n    };\n\n    /**\n     * Validate single element.\n     *\n     * @param {Element} element\n     * @param {Object} config\n     * @returns {*}\n     */\n    $.validator.validateSingleElement = function (element, config) {\n        var errors = {},\n            valid = true,\n            validateConfig = {\n                errorElement: 'label',\n                ignore: '.ignore-validate',\n                hideError: false\n            },\n            form, validator, classes, elementValue;\n\n        $.extend(validateConfig, config);\n        element = $(element).not(validateConfig.ignore);\n\n        if (!element.length) {\n            return true;\n        }\n\n        form = element.get(0).form;\n        validator = form ? $(form).data('validator') : null;\n\n        if (validator) {\n            return validator.element(element.get(0));\n        }\n\n        classes = element.prop('class').split(' ');\n        validator = element.parent().data('validator') ||\n            $.mage.validation(validateConfig, element.parent()).validate;\n\n        element.removeClass(validator.settings.errorClass);\n        validator.toHide = validator.toShow;\n        validator.hideErrors();\n        validator.toShow = validator.toHide = $([]);\n\n        $.each(classes, $.proxy(function (i, className) {\n            elementValue = element.val();\n\n            if (element.is(':checkbox') || element.is(':radio')) {\n                elementValue = element.is(':checked') || null;\n            }\n\n            if (this.methods[className] && !this.methods[className](elementValue, element.get(0))) {\n                valid = false;\n                errors[element.get(0).name] = this.messages[className];\n                validator.invalid[element.get(0).name] = true;\n\n                if (!validateConfig.hideError) {\n                    validator.showErrors(errors);\n                }\n\n                return valid;\n            }\n        }, this));\n\n        return valid;\n    };\n\n    $.widget('mage.validation', {\n        options: {\n            meta: 'validate',\n            onfocusout: false,\n            onkeyup: false,\n            onclick: false,\n            ignoreTitle: true,\n            errorClass: 'mage-error',\n            errorElement: 'div',\n\n            /**\n             * @param {*} error\n             * @param {*} element\n             */\n            errorPlacement: function (error, element) {\n                var errorPlacement = element,\n                    fieldWrapper;\n\n                // logic for date-picker error placement\n                if (element.hasClass('_has-datepicker')) {\n                    errorPlacement = element.siblings('button');\n                }\n                // logic for field wrapper\n                fieldWrapper = element.closest('.addon');\n\n                if (fieldWrapper.length) {\n                    errorPlacement = fieldWrapper.after(error);\n                }\n                //logic for checkboxes/radio\n                if (element.is(':checkbox') || element.is(':radio')) {\n                    errorPlacement = element.parents('.control').children().last();\n\n                    //fallback if group does not have .control parent\n                    if (!errorPlacement.length) {\n                        errorPlacement = element.siblings('label').last();\n                    }\n                }\n                //logic for control with tooltip\n                if (element.siblings('.tooltip').length) {\n                    errorPlacement = element.siblings('.tooltip');\n                }\n                //logic for select with tooltip in after element\n                if (element.next().find('.tooltip').length) {\n                    errorPlacement = element.next();\n                }\n                errorPlacement.after(error);\n            }\n        },\n\n        /**\n         * Check if form pass validation rules without submit.\n         *\n         * @return boolean\n         */\n        isValid: function () {\n            return this.element.valid();\n        },\n\n        /**\n         * Remove validation error messages\n         */\n        clearError: function () {\n            if (arguments.length) {\n                $.each(arguments, $.proxy(function (index, item) {\n                    this.validate.prepareElement(item);\n                    this.validate.hideErrors();\n                }, this));\n            } else {\n                this.validate.resetForm();\n            }\n        },\n\n        /**\n         * Validation creation.\n         *\n         * @protected\n         */\n        _create: function () {\n            this.validate = this.element.validate(this.options);\n\n            // ARIA (adding aria-required attribute)\n            this.element\n                .find('.field.required')\n                .find('.control')\n                .find('input, select, textarea')\n                .attr('aria-required', 'true');\n\n            this._listenFormValidate();\n        },\n\n        /**\n         * Validation listening.\n         *\n         * @protected\n         */\n        _listenFormValidate: function () {\n            $('form').on('invalid-form.validate', this.listenFormValidateHandler);\n        },\n\n        /**\n         * Handle form validation. Focus on first invalid form field.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var firstActive = $(validation.errorList[0].element || []),\n                lastActive = $(validation.findLastActive() ||\n                    validation.errorList.length && validation.errorList[0].element || []),\n                windowHeight = $(window).height(),\n                parent, successList;\n\n            if (lastActive.is(':hidden')) {\n                parent = lastActive.parent();\n                $('html, body').animate({\n                    scrollTop: parent.offset().top - windowHeight / 2\n                });\n            }\n\n            // ARIA (removing aria attributes if success)\n            successList = validation.successList;\n\n            if (successList.length) {\n                $.each(successList, function () {\n                    $(this)\n                        .removeAttr('aria-describedby')\n                        .removeAttr('aria-invalid');\n                });\n            }\n\n            if (firstActive.length) {\n                $('html, body').stop().animate({\n                    scrollTop: firstActive.parent().offset().top - windowHeight / 2\n                });\n                firstActive.focus();\n            }\n        }\n    });\n\n    return $.mage.validation;\n});\n","mage/loader_old.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.loader', {\n        loaderStarted: 0,\n        spinner: $(undefined),\n        options: {\n            icon: '',\n            texts: {\n                loaderText: $.mage.__('Please wait...'),\n                imgAlt: $.mage.__('Loading...')\n            },\n            template: '<div class=\"loading-mask\" data-role=\"loader\">' +\n                '<div class=\"popup popup-loading\">' +\n                '<div class=\"popup-inner\">' +\n                '<% if (data.icon) { %>' +\n                    '<img ' +\n                        '<% if (data.texts.imgAlt) { %>alt=\"<%- data.texts.imgAlt %>\"<% } %> ' +\n                        'src=\"<%- data.icon %>\"><% } %>' +\n                '<% if (data.texts.loaderText) { %><%- data.texts.loaderText %><% } %>' +\n                '</div>' +\n                '</div>' +\n                '</div>'\n        },\n\n        /**\n         * Loader creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind on ajax events\n         * @protected\n         */\n        _bind: function () {\n            this._on({\n                'processStop': 'hide',\n                'processStart': 'show',\n                'show.loader': 'show',\n                'hide.loader': 'hide',\n                'contentUpdated.loader': '_contentUpdated'\n            });\n        },\n\n        /**\n         * Verify loader present after content updated\n         *\n         * This will be cleaned up by the task MAGETWO-11070\n         *\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _contentUpdated: function (e) {\n            this.show(e);\n        },\n\n        /**\n         * Show loader\n         */\n        show: function (e, ctx) {\n            this._render();\n            this.loaderStarted++;\n            this.spinner.show();\n\n            if (ctx) {\n                this.spinner\n                    .css({\n                        width: ctx.outerWidth(),\n                        height: ctx.outerHeight(),\n                        position: 'absolute'\n                    })\n                    .position({\n                        my: 'top left',\n                        at: 'top left',\n                        of: ctx\n                    });\n            }\n\n            return false;\n        },\n\n        /**\n         * Hide loader\n         */\n        hide: function () {\n            if (this.loaderStarted > 0) {\n                this.loaderStarted--;\n\n                if (this.loaderStarted === 0) {\n                    this.spinner.hide();\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Render loader\n         * @protected\n         */\n        _render: function () {\n            var tmpl;\n\n            if (this.spinner.length === 0) {\n                tmpl = mageTemplate(this.options.template, {\n                    data: this.options\n                });\n\n                this.spinner = $(tmpl);\n            }\n\n            this.element.prepend(this.spinner);\n        },\n\n        /**\n         * Destroy loader\n         */\n        _destroy: function () {\n            this.spinner.remove();\n        }\n    });\n\n    /**\n     * This widget takes care of registering the needed loader listeners on the body\n     */\n    $.widget('mage.loaderAjax', {\n        options: {\n            defaultContainer: '[data-container=body]'\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this._bind();\n            // There should only be one instance of this widget, and it should be attached\n            // to the body only. Having it on the page twice will trigger multiple processStarts.\n            if (window.console && !this.element.is(this.options.defaultContainer) && $.mage.isDevMode(undefined)) {\n                console.warn('This widget is intended to be attached to the body, not below.');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            $(document).on({\n                'ajaxSend': this._onAjaxSend.bind(this),\n                'ajaxComplete': this._onAjaxComplete.bind(this)\n            });\n        },\n\n        /**\n         * @param {Object} loaderContext\n         * @return {*}\n         * @private\n         */\n        _getJqueryObj: function (loaderContext) {\n            var ctx;\n\n            // Check to see if context is jQuery object or not.\n            if (loaderContext) {\n                if (loaderContext.jquery) {\n                    ctx = loaderContext;\n                } else {\n                    ctx = $(loaderContext);\n                }\n            } else {\n                ctx = $('[data-container=\"body\"]');\n            }\n\n            return ctx;\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @param {Object} jqxhr\n         * @param {Object} settings\n         * @private\n         */\n        _onAjaxSend: function (e, jqxhr, settings) {\n            var ctx;\n\n            if (settings && settings.showLoader) {\n                ctx = this._getJqueryObj(settings.loaderContext);\n                ctx.trigger('processStart');\n\n                // Check to make sure the loader is there on the page if not report it on the console.\n                // NOTE that this check should be removed before going live. It is just an aid to help\n                // in finding the uses of the loader that maybe broken.\n                if (window.console && !ctx.parents('[data-role=\"loader\"]').length) {\n                    console.warn('Expected to start loader but did not find one in the dom');\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @param {Object} jqxhr\n         * @param {Object} settings\n         * @private\n         */\n        _onAjaxComplete: function (e, jqxhr, settings) {\n            if (settings && settings.showLoader && !settings.dontHide) {\n                this._getJqueryObj(settings.loaderContext).trigger('processStop');\n            }\n        }\n    });\n\n    return {\n        loader: $.mage.loader,\n        loaderAjax: $.mage.loaderAjax\n    };\n});\n","mage/url.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable strict */\ndefine([], function () {\n    var baseUrl = '';\n\n    return {\n        /**\n         * @param {String} url\n         */\n        setBaseUrl: function (url) {\n            baseUrl = url;\n        },\n\n        /**\n         * @param {String} path\n         * @return {*}\n         */\n        build: function (path) {\n            if (path.indexOf(baseUrl) !== -1) {\n                return path;\n            }\n\n            return baseUrl + path;\n        }\n    };\n});\n","mage/multiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'text!mage/multiselect.html',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'jquery/editableMultiselect/js/jquery.multiselect'\n], function (_, $, searchTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.multiselect2', {\n        options: {\n            mselectContainer: 'section.mselect-list',\n            mselectItemsWrapperClass: 'mselect-items-wrapper',\n            mselectCheckedClass: 'mselect-checked',\n            containerClass: 'paginated',\n            searchInputClass: 'admin__action-multiselect-search',\n            selectedItemsCountClass: 'admin__action-multiselect-items-selected',\n            currentPage: 1,\n            lastAppendValue: 0,\n            updateDelay: 1000,\n            optionsLoaded: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            $.fn.multiselect.call(this.element, this.options);\n        },\n\n        /** @inheritdoc */\n        _init: function () {\n            this.domElement = this.element.get(0);\n\n            this.$container = $(this.options.mselectContainer);\n            this.$wrapper = this.$container.find('.' + this.options.mselectItemsWrapperClass);\n            this.$item = this.$wrapper.find('div').first();\n            this.selectedValues = [];\n            this.values = {};\n\n            this.$container.addClass(this.options.containerClass).prepend(searchTemplate);\n            this.$input = this.$container.find('.' + this.options.searchInputClass);\n            this.$selectedCounter = this.$container.find('.' + this.options.selectedItemsCountClass);\n            this.filter = '';\n\n            if (this.domElement.options.length) {\n                this._setLastAppendOption(this.domElement.options[this.domElement.options.length - 1].value);\n            }\n\n            this._initElement();\n            this._events();\n        },\n\n        /**\n         * Leave only saved/selected options in select element.\n         *\n         * @private\n         */\n        _initElement: function () {\n            this.element.empty();\n            _.each(this.options.selectedValues, function (value) {\n                this._createSelectedOption({\n                    value: value,\n                    label: value\n                });\n            }, this);\n        },\n\n        /**\n         * Attach required events.\n         *\n         * @private\n         */\n        _events: function () {\n            var onKeyUp = _.debounce(this.onKeyUp, this.options.updateDelay);\n\n            _.bindAll(this, 'onScroll', 'onCheck', 'onOptionsChange');\n\n            this.$wrapper.on('scroll', this.onScroll);\n            this.$wrapper.on('change.mselectCheck', '[type=checkbox]', this.onCheck);\n            this.$input.on('keyup', _.bind(onKeyUp, this));\n            this.element.on('change.hiddenSelect', this.onOptionsChange);\n        },\n\n        /**\n         * Behaves multiselect scroll.\n         */\n        onScroll: function () {\n            var height = this.$wrapper.height(),\n                scrollHeight = this.$wrapper.prop('scrollHeight'),\n                scrollTop = Math.ceil(this.$wrapper.prop('scrollTop'));\n\n            if (!this.options.optionsLoaded && scrollHeight - height <= scrollTop) {\n                this.loadOptions();\n            }\n        },\n\n        /**\n         * Behaves keyup event on input search\n         */\n        onKeyUp: function () {\n            if (this.getSearchCriteria() === this.filter) {\n                return false;\n            }\n\n            this.setFilter();\n            this.clearMultiselectOptions();\n            this.setCurrentPage(0);\n            this.loadOptions();\n        },\n\n        /**\n         * Callback for select change event\n         */\n        onOptionsChange: function () {\n            this.selectedValues = _.map(this.domElement.options, function (option) {\n                this.values[option.value] = true;\n\n                return option.value;\n            }, this);\n\n            this._updateSelectedCounter();\n        },\n\n        /**\n         * Overrides native check behaviour.\n         *\n         * @param {Event} event\n         */\n        onCheck: function (event) {\n            var checkbox = event.target,\n                option = {\n                    value: checkbox.value,\n                    label: $(checkbox).parent('label').text()\n                };\n\n            checkbox.checked ? this._createSelectedOption(option) : this._removeSelectedOption(option);\n            event.stopPropagation();\n        },\n\n        /**\n         * Show error message.\n         *\n         * @param {String} message\n         */\n        onError: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Updates current filter state.\n         */\n        setFilter: function () {\n            this.filter = this.getSearchCriteria() || '';\n        },\n\n        /**\n         * Reads search input value.\n         *\n         * @return {String}\n         */\n        getSearchCriteria: function () {\n            return this.$input.val().trim();\n        },\n\n        /**\n         * Load options data.\n         */\n        loadOptions: function () {\n            var nextPage = this.getCurrentPage() + 1;\n\n            this.$wrapper.trigger('processStart');\n            this.$input.prop('disabled', true);\n\n            $.get(this.options.nextPageUrl, {\n                p: nextPage,\n                s: this.filter\n            })\n            .done(function (response) {\n                if (response.success) {\n                    this.appendOptions(response.result);\n                    this.setCurrentPage(nextPage);\n                } else {\n                    this.onError(response.errorMessage);\n                }\n            }.bind(this))\n            .always(function () {\n                this.$wrapper.trigger('processStop');\n                this.$input.prop('disabled', false);\n\n                if (this.filter) {\n                    this.$input.focus();\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Append loaded options\n         *\n         * @param {Array} options\n         */\n        appendOptions: function (options) {\n            var divOptions = [];\n\n            if (!options.length) {\n                return false;\n            }\n\n            if (this.isOptionsLoaded(options)) {\n                return;\n            }\n\n            options.forEach(function (option) {\n                if (!this.values[option.value]) {\n                    this.values[option.value] = true;\n                    option.selected = this._isOptionSelected(option);\n                    divOptions.push(this._createMultiSelectOption(option));\n                    this._setLastAppendOption(option.value);\n                }\n            }, this);\n\n            this.$wrapper.append(divOptions);\n        },\n\n        /**\n         * Clear multiselect options\n         */\n        clearMultiselectOptions: function () {\n            this._setLastAppendOption(0);\n            this.values = {};\n            this.$wrapper.empty();\n        },\n\n        /**\n         * Checks if all options are already loaded\n         *\n         * @return {Boolean}\n         */\n        isOptionsLoaded: function (options) {\n            this.options.optionsLoaded = this.options.lastAppendValue === options[options.length - 1].value;\n\n            return this.options.optionsLoaded;\n        },\n\n        /**\n         * Setter for current page.\n         *\n         * @param {Number} page\n         */\n        setCurrentPage: function (page) {\n            this.options.currentPage = page;\n        },\n\n        /**\n         * Getter for current page.\n         *\n         * @return {Number}\n         */\n        getCurrentPage: function () {\n            return this.options.currentPage;\n        },\n\n        /**\n         * Creates new selected option for select element\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @private\n         */\n        _createSelectedOption: function (option) {\n            var selectOption = new Option(option.label, option.value, false, true);\n\n            this.element.append(selectOption);\n            this.selectedValues.push(option.value);\n            this._updateSelectedCounter();\n\n            return selectOption;\n        },\n\n        /**\n         * Remove passed option from select element\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @return {Object} option\n         * @private\n         */\n        _removeSelectedOption: function (option) {\n            var unselectedOption = _.findWhere(this.domElement.options, {\n                value: option.value\n            });\n\n            if (!_.isUndefined(unselectedOption)) {\n                this.domElement.remove(unselectedOption.index);\n                this.selectedValues.splice(_.indexOf(this.selectedValues, option.value), 1);\n                this._updateSelectedCounter();\n            }\n\n            return unselectedOption;\n        },\n\n        /**\n         * Creates new DIV option for multiselect widget\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @param {Boolean} option.selected - is option selected\n         * @private\n         */\n        _createMultiSelectOption: function (option) {\n            var item = this.$item.clone(),\n                checkbox = item.find('input'),\n                isSelected = !!option.selected;\n\n            checkbox.val(option.value)\n                .prop('checked', isSelected)\n                .toggleClass(this.options.mselectCheckedClass, isSelected);\n\n            item.find('label > span').text(option.label);\n\n            return item;\n        },\n\n        /**\n         * Checks if passed option should be selected\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @param {Boolean} option.selected - is option selected\n         * @return {Boolean}\n         * @private\n         */\n        _isOptionSelected: function (option) {\n            return !!~this.selectedValues.indexOf(option.value);\n        },\n\n        /**\n         * Saves last added option value.\n         *\n         * @param {Number} value\n         * @private\n         */\n        _setLastAppendOption: function (value) {\n            this.options.lastAppendValue = value;\n        },\n\n        /**\n         * Updates counter of selected items.\n         *\n         * @private\n         */\n        _updateSelectedCounter: function () {\n            this.$selectedCounter.text(this.selectedValues.length);\n        }\n    });\n\n    return $.mage.multiselect2;\n});\n","mage/mage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/apply/main'\n], function ($, mage) {\n    'use strict';\n\n    /**\n     * Main namespace for Magento extensions\n     * @type {Object}\n     */\n    $.mage = $.mage || {};\n\n    /**\n     * Plugin mage, initialize components on elements\n     * @param {String} name - Components' path.\n     * @param {Object} config - Components' config.\n     * @returns {JQuery} Chainable.\n     */\n    $.fn.mage = function (name, config) {\n        config = config || {};\n\n        this.each(function (index, el) {\n            mage.applyFor(el, config, name);\n        });\n\n        return this;\n    };\n\n    $.extend($.mage, {\n        /**\n         * Handle all components declared via data attribute\n         * @return {Object} $.mage\n         */\n        init: function () {\n            mage.apply();\n\n            return this;\n        },\n\n        /**\n         * Method handling redirects and page refresh\n         * @param {String} url - redirect URL\n         * @param {(undefined|String)} type - 'assign', 'reload', 'replace'\n         * @param {(undefined|Number)} timeout - timeout in milliseconds before processing the redirect or reload\n         * @param {(undefined|Boolean)} forced - true|false used for 'reload' only\n         */\n        redirect: function (url, type, timeout, forced) {\n            var _redirect;\n\n            forced  = !!forced;\n            timeout = timeout || 0;\n            type    = type || 'assign';\n\n            /**\n             * @private\n             */\n            _redirect = function () {\n                window.location[type](type === 'reload' ? forced : url);\n            };\n\n            timeout ? setTimeout(_redirect, timeout) : _redirect();\n        },\n\n        /**\n         * Checks if provided string is a valid selector.\n         * @param {String} selector - Selector to check.\n         * @returns {Boolean}\n         */\n        isValidSelector: function (selector) {\n            try {\n                document.querySelector(selector);\n\n                return true;\n            } catch (e) {\n                return false;\n            }\n        }\n    });\n\n    /**\n     * Init components inside of dynamically updated elements\n     */\n    $(document).on('contentUpdated', 'body', function () {\n        if (mage) {\n            mage.apply();\n        }\n    });\n\n    return $.mage;\n});\n","mage/calendar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint max-depth: 0*/\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/datepicker',\n    'jquery-ui-modules/timepicker'\n], function ($) {\n    'use strict';\n\n    var calendarBasePrototype,\n        datepickerPrototype = $.datepicker.constructor.prototype;\n\n    $.datepicker.markerClassName = '_has-datepicker';\n\n    /**\n     * Extend JQuery date picker prototype with store local time methods\n     */\n    $.extend(datepickerPrototype, {\n        /**\n         * Get date/time according to store settings.\n         * We use serverTimezoneOffset (in seconds) instead of serverTimezoneSeconds\n         * in order to have ability to know actual store time even if page hadn't been reloaded\n         * @returns {Date}\n         */\n        _getTimezoneDate: function (options) {\n            // local time in ms\n            var ms = Date.now();\n\n            options = options || $.calendarConfig || {};\n\n            // Adjust milliseconds according to store timezone offset,\n            // mind the GMT zero offset\n            if (typeof options.serverTimezoneOffset !== 'undefined') {\n                // Make UTC time and add store timezone offset in seconds\n                ms += new Date().getTimezoneOffset() * 60 * 1000 + options.serverTimezoneOffset * 1000;\n            } else if (typeof options.serverTimezoneSeconds !== 'undefined') {\n                //Set milliseconds according to client local timezone offset\n                ms = (options.serverTimezoneSeconds + new Date().getTimezoneOffset() * 60) * 1000;\n            }\n\n            return new Date(ms);\n        },\n\n        /**\n         * Set date/time according to store settings.\n         * @param {String|Object} target - the target input field or division or span\n         */\n        _setTimezoneDateDatepicker: function (target) {\n            this._setDateDatepicker(target, this._getTimezoneDate());\n        }\n    });\n\n    /**\n     * Widget calendar\n     */\n    $.widget('mage.calendar', {\n        options: {\n            autoComplete: true\n        },\n\n        /**\n         * Merge global options with options passed to widget invoke\n         * @protected\n         */\n        _create: function () {\n            this._enableAMPM();\n            this.options = $.extend(\n                {},\n                $.calendarConfig ? $.calendarConfig : {},\n                this.options.showsTime ? {\n                    showTime: true,\n                    showHour: true,\n                    showMinute: true\n                } : {},\n                this.options\n            );\n            this._initPicker(this.element);\n            this._overwriteGenerateHtml();\n        },\n\n        /**\n         * Get picker name\n         * @protected\n         */\n        _picker: function () {\n            return this.options.showsTime ? 'datetimepicker' : 'datepicker';\n        },\n\n        /**\n         * Fix for Timepicker - Set ampm option for Timepicker if timeformat contains string 'tt'\n         * @protected\n         */\n        _enableAMPM: function () {\n            if (this.options.timeFormat && this.options.timeFormat.indexOf('tt') >= 0) {\n                this.options.ampm = true;\n            }\n        },\n\n        /**\n         * Wrapper for overwrite jQuery UI datepicker function.\n         */\n        _overwriteGenerateHtml: function () {\n            /**\n             * Overwrite jQuery UI datepicker function.\n             * Reason: magento date could be set before calendar show\n             * but local date will be styled as current in original _generateHTML\n             *\n             * @param {Object} inst - instance datepicker.\n             * @return {String} html template\n             */\n            $.datepicker.constructor.prototype._generateHTML = function (inst) {\n                var today = this._getTimezoneDate(),\n                    isRTL = this._get(inst, 'isRTL'),\n                    showButtonPanel = this._get(inst, 'showButtonPanel'),\n                    hideIfNoPrevNext = this._get(inst, 'hideIfNoPrevNext'),\n                    navigationAsDateFormat = this._get(inst, 'navigationAsDateFormat'),\n                    numMonths = this._getNumberOfMonths(inst),\n                    showCurrentAtPos = this._get(inst, 'showCurrentAtPos'),\n                    stepMonths = this._get(inst, 'stepMonths'),\n                    isMultiMonth = parseInt(numMonths[0], 10) !== 1 || parseInt(numMonths[1], 10) !== 1,\n                    currentDate = this._daylightSavingAdjust(!inst.currentDay ? new Date(9999, 9, 9) :\n                        new Date(inst.currentYear, inst.currentMonth, inst.currentDay)),\n                    minDate = this._getMinMaxDate(inst, 'min'),\n                    maxDate = this._getMinMaxDate(inst, 'max'),\n                    drawMonth = inst.drawMonth - showCurrentAtPos,\n                    drawYear = inst.drawYear,\n                    maxDraw,\n                    prevText = this._get(inst, 'prevText'),\n                    prev,\n                    nextText = this._get(inst, 'nextText'),\n                    next,\n                    currentText = this._get(inst, 'currentText'),\n                    gotoDate,\n                    controls,\n                    buttonPanel,\n                    firstDay,\n                    showWeek = this._get(inst, 'showWeek'),\n                    dayNames = this._get(inst, 'dayNames'),\n                    dayNamesMin = this._get(inst, 'dayNamesMin'),\n                    monthNames = this._get(inst, 'monthNames'),\n                    monthNamesShort =  this._get(inst, 'monthNamesShort'),\n                    beforeShowDay = this._get(inst, 'beforeShowDay'),\n                    showOtherMonths = this._get(inst, 'showOtherMonths'),\n                    selectOtherMonths = this._get(inst, 'selectOtherMonths'),\n                    defaultDate = this._getDefaultDate(inst),\n                    html = '',\n                    row = 0,\n                    col = 0,\n                    selectedDate,\n                    cornerClass = ' ui-corner-all',\n                    group = '',\n                    calender = '',\n                    dow = 0,\n                    thead,\n                    day,\n                    daysInMonth,\n                    leadDays,\n                    curRows,\n                    numRows,\n                    printDate,\n                    dRow = 0,\n                    tbody,\n                    daySettings,\n                    otherMonth,\n                    unselectable;\n\n                if (drawMonth < 0) {\n                    drawMonth += 12;\n                    drawYear--;\n                }\n\n                if (maxDate) {\n                    maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),\n                        maxDate.getMonth() - numMonths[0] * numMonths[1] + 1, maxDate.getDate()));\n                    maxDraw = minDate && maxDraw < minDate ? minDate : maxDraw;\n\n                    while (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {\n                        drawMonth--;\n\n                        if (drawMonth < 0) {\n                            drawMonth = 11;\n                            drawYear--;\n\n                        }\n                    }\n                }\n                inst.drawMonth = drawMonth;\n                inst.drawYear = drawYear;\n                prevText = !navigationAsDateFormat ? prevText : this.formatDate(prevText,\n                    this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),\n                    this._getFormatConfig(inst));\n                prev = this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?\n                    '<a class=\"ui-datepicker-prev ui-corner-all\" data-handler=\"prev\" data-event=\"click\"' +\n                    ' title=\"' + prevText + '\">' +\n                    '<span class=\"ui-icon ui-icon-circle-triangle-' + (isRTL ? 'e' : 'w') + '\">' +\n                    '' + prevText + '</span></a>'\n                    : hideIfNoPrevNext ? ''\n                        :   '<a class=\"ui-datepicker-prev ui-corner-all ui-state-disabled\" title=\"' +\n                            '' + prevText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' +\n                            '' + (isRTL ? 'e' : 'w') + '\">' + prevText + '</span></a>';\n                nextText = !navigationAsDateFormat ?\n                    nextText\n                    :   this.formatDate(nextText,\n                        this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),\n                        this._getFormatConfig(inst));\n                next = this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?\n                    '<a class=\"ui-datepicker-next ui-corner-all\" data-handler=\"next\" data-event=\"click\"' +\n                    'title=\"' + nextText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' +\n                    '' + (isRTL ? 'w' : 'e') + '\">' + nextText + '</span></a>'\n                    : hideIfNoPrevNext ? ''\n                        :   '<a class=\"ui-datepicker-next ui-corner-all ui-state-disabled\" title=\"' + nextText + '\">' +\n                            '<span class=\"ui-icon ui-icon-circle-triangle-' + (isRTL ? 'w' : 'e') + '\">' + nextText +\n                            '</span></a>';\n                gotoDate = this._get(inst, 'gotoCurrent') && inst.currentDay ? currentDate : today;\n                currentText = !navigationAsDateFormat ? currentText :\n                    this.formatDate(currentText, gotoDate, this._getFormatConfig(inst));\n                controls = !inst.inline ?\n                    '<button type=\"button\" class=\"ui-datepicker-close ui-state-default ui-priority-primary ' +\n                    'ui-corner-all\" data-handler=\"hide\" data-event=\"click\">' +\n                    this._get(inst, 'closeText') + '</button>'\n                    : '';\n                buttonPanel = showButtonPanel ?\n                    '<div class=\"ui-datepicker-buttonpane ui-widget-content\">' + (isRTL ? controls : '') +\n                    (this._isInRange(inst, gotoDate) ? '<button type=\"button\" class=\"ui-datepicker-current ' +\n                    'ui-state-default ui-priority-secondary ui-corner-all\" data-handler=\"today\" data-event=\"click\"' +\n                    '>' + currentText + '</button>' : '') + (isRTL ? '' : controls) + '</div>' : '';\n                firstDay = parseInt(this._get(inst, 'firstDay'), 10);\n                firstDay = isNaN(firstDay) ? 0 : firstDay;\n\n                for (row = 0; row < numMonths[0]; row++) {\n                    this.maxRows = 4;\n\n                    for (col = 0; col < numMonths[1]; col++) {\n                        selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));\n\n                        calender = '';\n\n                        if (isMultiMonth) {\n                            calender += '<div class=\"ui-datepicker-group';\n\n                            if (numMonths[1] > 1) {\n                                switch (col) {\n                                    case 0: calender += ' ui-datepicker-group-first';\n                                        cornerClass = ' ui-corner-' + (isRTL ? 'right' : 'left');\n                                        break;\n\n                                    case numMonths[1] - 1: calender += ' ui-datepicker-group-last';\n                                        cornerClass = ' ui-corner-' + (isRTL ? 'left' : 'right');\n                                        break;\n\n                                    default: calender += ' ui-datepicker-group-middle'; cornerClass = '';\n                                }\n                            }\n                            calender += '\">';\n                        }\n                        calender += '<div class=\"ui-datepicker-header ' +\n                            'ui-widget-header ui-helper-clearfix' + cornerClass + '\">' +\n                            (/all|left/.test(cornerClass) && parseInt(row, 10) === 0 ? isRTL ? next : prev : '') +\n                            (/all|right/.test(cornerClass) && parseInt(row, 10) === 0 ? isRTL ? prev : next : '') +\n                            this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,\n                            row > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers\n                            '</div><table class=\"ui-datepicker-calendar\"><thead>' +\n                            '<tr>';\n                        thead = showWeek ?\n                            '<th class=\"ui-datepicker-week-col\">' + this._get(inst, 'weekHeader') + '</th>' : '';\n\n                        for (dow = 0; dow < 7; dow++) { // days of the week\n                            day = (dow + firstDay) % 7;\n                            thead += '<th' + ((dow + firstDay + 6) % 7 >= 5 ?\n                                ' class=\"ui-datepicker-week-end\"' : '') + '>' +\n                                '<span title=\"' + dayNames[day] + '\">' + dayNamesMin[day] + '</span></th>';\n                        }\n                        calender += thead + '</tr></thead><tbody>';\n                        daysInMonth = this._getDaysInMonth(drawYear, drawMonth);\n\n                        if (drawYear === inst.selectedYear && drawMonth === inst.selectedMonth) {\n                            inst.selectedDay = Math.min(inst.selectedDay, daysInMonth);\n                        }\n                        leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;\n                        curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate\n                        numRows = isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows;\n                        this.maxRows = numRows;\n                        printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));\n\n                        for (dRow = 0; dRow < numRows; dRow++) { // create date picker rows\n                            calender += '<tr>';\n                            tbody = !showWeek ? '' : '<td class=\"ui-datepicker-week-col\">' +\n                            this._get(inst, 'calculateWeek')(printDate) + '</td>';\n\n                            for (dow = 0; dow < 7; dow++) { // create date picker days\n                                daySettings = beforeShowDay ?\n                                    beforeShowDay.apply(inst.input ? inst.input[0] : null, [printDate]) : [true, ''];\n                                otherMonth = printDate.getMonth() !== drawMonth;\n                                unselectable = otherMonth && !selectOtherMonths || !daySettings[0] ||\n                                minDate && printDate < minDate || maxDate && printDate > maxDate;\n                                tbody += '<td class=\"' +\n                                ((dow + firstDay + 6) % 7 >= 5 ? ' ui-datepicker-week-end' : '') + // highlight weekends\n                                (otherMonth ? ' ui-datepicker-other-month' : '') + // highlight days from other months\n                                (printDate.getTime() === selectedDate.getTime() &&\n                                drawMonth === inst.selectedMonth && inst._keyEvent || // user pressed key\n                                defaultDate.getTime() === printDate.getTime() &&\n                                defaultDate.getTime() === selectedDate.getTime() ?\n                                    // or defaultDate is current printedDate and defaultDate is selectedDate\n                                ' ' + this._dayOverClass : '') + // highlight selected day\n                                (unselectable ? ' ' + this._unselectableClass + ' ui-state-disabled' : '') +\n                                (otherMonth && !showOtherMonths ? '' : ' ' + daySettings[1] + // highlight custom dates\n                                (printDate.getTime() === currentDate.getTime() ? ' ' + this._currentClass : '') +\n                                (printDate.getDate() === today.getDate() && printDate.getMonth() === today.getMonth() &&\n                                printDate.getYear() === today.getYear() ? ' ui-datepicker-today' : '')) + '\"' +\n                                ((!otherMonth || showOtherMonths) && daySettings[2] ?\n                                ' title=\"' + daySettings[2] + '\"' : '') + // cell title\n                                (unselectable ? '' : ' data-handler=\"selectDay\" data-event=\"click\" data-month=\"' +\n                                '' + printDate.getMonth() + '\" data-year=\"' + printDate.getFullYear() + '\"') + '>' +\n                                (otherMonth && !showOtherMonths ? '&#xa0;' : // display for other months\n                                    unselectable ? '<span class=\"ui-state-default\">' + printDate.getDate() + '</span>'\n                                        : '<a class=\"ui-state-default' +\n                                    (printDate.getTime() === today.getTime() ? ' ' : '') +\n                                    (printDate.getTime() === currentDate.getTime() ? ' ui-state-active' : '') +\n                                    (otherMonth ? ' ui-priority-secondary' : '') +\n                                    '\" data-date=\"' + printDate.getDate() + '\" href=\"#\">' +\n                                        printDate.getDate() + '</a>') + '</td>';\n                                printDate.setDate(printDate.getDate() + 1);\n                                printDate = this._daylightSavingAdjust(printDate);\n                            }\n                            calender += tbody + '</tr>';\n                        }\n                        drawMonth++;\n\n                        if (drawMonth > 11) {\n                            drawMonth = 0;\n                            drawYear++;\n                        }\n                        calender += '</tbody></table>' + (isMultiMonth ? '</div>' +\n                        (numMonths[0] > 0 && col === numMonths[1] - 1 ? '<div class=\"ui-datepicker-row-break\"></div>'\n                            : '') : '');\n                        group += calender;\n                    }\n                    html += group;\n                }\n                html += buttonPanel + ($.ui.ie6 && !inst.inline ?\n                    '<iframe src=\"javascript:false;\" class=\"ui-datepicker-cover\" frameborder=\"0\"></iframe>' : '');\n                inst._keyEvent = false;\n\n                return html;\n            };\n        },\n\n        /**\n         * Set current date if the date is not set\n         * @protected\n         * @param {Object} element\n         */\n        _setCurrentDate: function (element) {\n            if (!element.val()) {\n                element[this._picker()]('setTimezoneDate').val('');\n            }\n        },\n\n        /**\n         * Init Datetimepicker\n         * @protected\n         * @param {Object} element\n         */\n        _initPicker: function (element) {\n            var picker = element[this._picker()](this.options),\n                pickerButtonText = picker.next('.ui-datepicker-trigger')\n                    .find('img')\n                    .attr('title');\n\n            picker.next('.ui-datepicker-trigger')\n                .addClass('v-middle')\n                .text('') // Remove jQuery UI datepicker generated image\n                .append('<span>' + pickerButtonText + '</span>');\n\n            $(element).attr('autocomplete', this.options.autoComplete ? 'on' : 'off');\n\n            this._setCurrentDate(element);\n        },\n\n        /**\n         * destroy instance of datetimepicker\n         */\n        _destroy: function () {\n            this.element[this._picker()]('destroy');\n            this._super();\n        },\n\n        /**\n         * Method is kept for backward compatibility and unit-tests acceptance\n         * see \\mage\\calendar\\calendar-test.js\n         * @return {Object} date\n         */\n        getTimezoneDate: function () {\n            return datepickerPrototype._getTimezoneDate.call(this, this.options);\n        }\n    });\n\n    calendarBasePrototype = $.mage.calendar.prototype;\n\n    /**\n     * Extension for Calendar - date and time format convert functionality\n     * @var {Object}\n     */\n    $.widget('mage.calendar', $.extend({}, calendarBasePrototype,\n            /** @lends {$.mage.calendar.prototype} */ {\n                /**\n                 * key - backend format, value - jquery format\n                 * @type {Object}\n                 * @private\n                 */\n                dateTimeFormat: {\n                    date: {\n                        'EEEE': 'DD',\n                        'EEE': 'D',\n                        'EE': 'D',\n                        'E': 'D',\n                        'D': 'o',\n                        'MMMM': 'MM',\n                        'MMM': 'M',\n                        'MM': 'mm',\n                        'M': 'mm',\n                        'yyyy': 'yy',\n                        'y': 'yy',\n                        'Y': 'yy',\n                        'yy': 'yy' // Always long year format on frontend\n                    },\n                    time: {\n                        'a': 'TT'\n                    }\n                },\n\n                /**\n                 * Add Date and Time converting to _create method\n                 * @protected\n                 */\n                _create: function () {\n                    if (this.options.dateFormat) {\n                        this.options.dateFormat = this._convertFormat(this.options.dateFormat, 'date');\n                    }\n\n                    if (this.options.timeFormat) {\n                        this.options.timeFormat = this._convertFormat(this.options.timeFormat, 'time');\n                    }\n                    calendarBasePrototype._create.apply(this, arguments);\n                },\n\n                /**\n                 * Converting date or time format\n                 * @protected\n                 * @param {String} format\n                 * @param {String} type\n                 * @return {String}\n                 */\n                _convertFormat: function (format, type) {\n                    var symbols = format.match(/([a-z]+)/ig),\n                        separators = format.match(/([^a-z]+)/ig),\n                        self = this,\n                        convertedFormat = '';\n\n                    if (symbols) {\n                        $.each(symbols, function (key, val) {\n                            convertedFormat +=\n                                (self.dateTimeFormat[type][val] || val) +\n                                (separators[key] || '');\n                        });\n                    }\n\n                    return convertedFormat;\n                }\n            })\n    );\n\n    /**\n     * Widget dateRange\n     * @extends $.mage.calendar\n     */\n    $.widget('mage.dateRange', $.mage.calendar, {\n\n        /**\n         * creates two instances of datetimepicker for date range selection\n         * @protected\n         */\n        _initPicker: function () {\n            var from,\n                to;\n\n            if (this.options.from && this.options.to) {\n                from = this.element.find('#' + this.options.from.id);\n                to = this.element.find('#' + this.options.to.id);\n                this.options.onSelect = $.proxy(function (selectedDate) {\n                    to[this._picker()]('option', 'minDate', selectedDate);\n                }, this);\n                $.mage.calendar.prototype._initPicker.call(this, from);\n                from.on('change', $.proxy(function () {\n                    to[this._picker()]('option', 'minDate', from[this._picker()]('getDate'));\n                }, this));\n                this.options.onSelect = $.proxy(function (selectedDate) {\n                    from[this._picker()]('option', 'maxDate', selectedDate);\n                }, this);\n                $.mage.calendar.prototype._initPicker.call(this, to);\n                to.on('change', $.proxy(function () {\n                    from[this._picker()]('option', 'maxDate', to[this._picker()]('getDate'));\n                }, this));\n            }\n        },\n\n        /**\n         * destroy two instances of datetimepicker\n         */\n        _destroy: function () {\n            if (this.options.from) {\n                this.element.find('#' + this.options.from.id)[this._picker()]('destroy');\n            }\n\n            if (this.options.to) {\n                this.element.find('#' + this.options.to.id)[this._picker()]('destroy');\n            }\n            this._super();\n        }\n    });\n\n    // Overrides the \"today\" button functionality to select today's date when clicked.\n    $.datepicker._gotoTodayOriginal = $.datepicker._gotoToday;\n\n    /**\n     * overwrite jQuery UI _showDatepicker function for proper HTML generation conditions.\n     *\n     */\n    $.datepicker._showDatepickerOriginal = $.datepicker._showDatepicker;\n\n    /**\n     * Triggers original method showDataPicker for rendering calendar\n     * @param {HTMLObject} input\n     * @private\n     */\n    $.datepicker._showDatepicker = function (input) {\n        if (!input.disabled) {\n            $.datepicker._showDatepickerOriginal.call(this, input);\n        }\n    };\n\n    /**\n     * _gotoToday\n     * @param {Object} el\n     */\n    $.datepicker._gotoToday = function (el) {\n        //Set date/time according to timezone offset\n        $(el).datepicker('setTimezoneDate')\n            // To ensure that user can re-select date field without clicking outside it first.\n            .trigger('blur').trigger('change');\n    };\n\n    return {\n        dateRange:  $.mage.dateRange,\n        calendar:   $.mage.calendar\n    };\n});\n","mage/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/core',\n    'jquery/jquery-storageapi',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    var hideProps = {},\n        showProps = {};\n\n    hideProps.height = 'hide';\n    showProps.height = 'show';\n\n    $.widget('mage.collapsible', {\n        options: {\n            active: false,\n            disabled: false,\n            collapsible: true,\n            header: '[data-role=title]',\n            content: '[data-role=content]',\n            trigger: '[data-role=trigger]',\n            closedState: null,\n            openedState: null,\n            disabledState: null,\n            ajaxUrlElement: '[data-ajax=true]',\n            ajaxContent: false,\n            loadingClass: null,\n            saveState: false,\n            animate: false,\n            icons: {\n                activeHeader: null,\n                header: null\n            },\n            collateral: {\n                element: null,\n                openedState: null\n            }\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.storage = $.localStorage;\n            this.icons = false;\n\n            if (typeof this.options.icons === 'string') {\n                this.options.icons = JSON.parse(this.options.icons);\n            }\n\n            this._processPanels();\n            this._processState();\n            this._refresh();\n\n            if (this.options.icons.header && this.options.icons.activeHeader) {\n                this._createIcons();\n                this.icons = true;\n            }\n\n            this.element.on('dimensionsChanged', function (e) {\n                if (e.target && e.target.classList.contains('active')) {\n                    this._scrollToTopIfNotVisible();\n                }\n            }.bind(this));\n\n            this._bind('click');\n            this._trigger('created');\n        },\n\n        /**\n         * @private\n         */\n        _refresh: function () {\n            this.trigger.attr('tabIndex', 0);\n\n            if (this.options.active && !this.options.disabled) {\n                if (this.options.openedState) {\n                    this.element.addClass(this.options.openedState);\n                }\n\n                if (this.options.collateral.element && this.options.collateral.openedState) {\n                    $(this.options.collateral.element).addClass(this.options.collateral.openedState);\n                }\n\n                if (this.options.ajaxContent) {\n                    this._loadContent();\n                }\n                // ARIA (updates aria attributes)\n                this.header.attr({\n                    'aria-selected': false\n                });\n            } else if (this.options.disabled) {\n                this.disable();\n            } else {\n                this.content.hide();\n\n                if (this.options.closedState) {\n                    this.element.addClass(this.options.closedState);\n                }\n            }\n        },\n\n        /**\n         * Processing the state:\n         *     If deep linking is used and the anchor is the id of the content or the content contains this id,\n         *     and the collapsible element is a nested one having collapsible parents, in order to see the content,\n         *     all the parents must be expanded.\n         * @private\n         */\n        _processState: function () {\n            var anchor = window.location.hash,\n                isValid = $.mage.isValidSelector(anchor),\n                urlPath = window.location.pathname.replace(/\\./g, ''),\n                state;\n\n            this.stateKey = encodeURIComponent(urlPath + this.element.attr('id'));\n\n            if (isValid &&\n                ($(this.content.find(anchor)).length > 0 || this.content.attr('id') === anchor.replace('#', ''))\n            ) {\n                this.element.parents('[data-collapsible=true]').collapsible('forceActivate');\n\n                if (!this.options.disabled) {\n                    this.options.active = true;\n\n                    if (this.options.saveState) { //eslint-disable-line max-depth\n                        this.storage.set(this.stateKey, true);\n                    }\n                }\n            } else if (this.options.saveState && !this.options.disabled) {\n                state = this.storage.get(this.stateKey);\n\n                if (typeof state === 'undefined' || state === null) {\n                    this.storage.set(this.stateKey, this.options.active);\n                } else if (state === true) {\n                    this.options.active = true;\n                } else if (state === false) {\n                    this.options.active = false;\n                }\n            }\n        },\n\n        /**\n         * @private\n         */\n        _createIcons: function () {\n            var icons = this.options.icons;\n\n            if (icons) {\n                $('<span>')\n                    .addClass(icons.header)\n                    .attr('data-role', 'icons')\n                    .prependTo(this.header);\n\n                if (this.options.active && !this.options.disabled) {\n                    this.header.children('[data-role=icons]')\n                        .removeClass(icons.header)\n                        .addClass(icons.activeHeader);\n                }\n            }\n        },\n\n        /**\n         * @private\n         */\n        _destroyIcons: function () {\n            this.header\n                .children('[data-role=icons]')\n                .remove();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            var options = this.options;\n\n            this.element.removeAttr('data-collapsible');\n\n            this.trigger.removeAttr('tabIndex');\n\n            if (options.openedState) {\n                this.element.removeClass(options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).removeClass(this.options.collateral.openedState);\n            }\n\n            if (options.closedState) {\n                this.element.removeClass(options.closedState);\n            }\n\n            if (options.disabledState) {\n                this.element.removeClass(options.disabledState);\n            }\n\n            if (this.icons) {\n                this._destroyIcons();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _processPanels: function () {\n            var headers, triggers;\n\n            this.element.attr('data-collapsible', 'true');\n\n            if (typeof this.options.header === 'object') {\n                this.header = this.options.header;\n            } else {\n                headers = this.element.find(this.options.header);\n\n                if (headers.length > 0) {\n                    this.header = headers.eq(0);\n                } else {\n                    this.header = this.element;\n                }\n            }\n\n            if (typeof this.options.content === 'object') {\n                this.content = this.options.content;\n            } else {\n                this.content = this.header.next(this.options.content).eq(0);\n            }\n\n            // ARIA (init aria attributes)\n            if (this.header.attr('id')) {\n                this.content.attr('aria-labelledby', this.header.attr('id'));\n            }\n\n            if (this.content.attr('id')) {\n                this.header.attr('aria-controls', this.content.attr('id'));\n            }\n\n            this.header\n                .attr({\n                    'role': 'tab',\n                    'aria-selected': this.options.active,\n                    'aria-expanded': this.options.active\n                });\n\n            // For collapsible widget only (not tabs or accordion)\n            if (this.header.parent().attr('role') !== 'presentation') {\n                this.header\n                    .parent()\n                    .attr('role', 'tablist');\n            }\n\n            this.content.attr({\n                'role': 'tabpanel',\n                'aria-hidden': !this.options.active\n            });\n\n            if (typeof this.options.trigger === 'object') {\n                this.trigger = this.options.trigger;\n            } else {\n                triggers = this.header.find(this.options.trigger);\n\n                if (triggers.length > 0) {\n                    this.trigger = triggers.eq(0);\n                } else {\n                    this.trigger = this.header;\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var keyCode;\n\n            if (event.altKey || event.ctrlKey) {\n                return;\n            }\n\n            keyCode = $.ui.keyCode;\n\n            switch (event.keyCode) {\n                case keyCode.SPACE:\n                case keyCode.ENTER:\n                    this._eventHandler(event);\n                    break;\n            }\n\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _bind: function (event) {\n            var self = this;\n\n            this.events = {\n                keydown: '_keydown'\n            };\n\n            if (event) {\n                $.each(event.split(' '), function (index, eventName) {\n                    self.events[eventName] = '_eventHandler';\n                });\n            }\n            this._off(this.trigger);\n\n            if (!this.options.disabled) {\n                this._on(this.trigger, this.events);\n            }\n        },\n\n        /**\n         * Disable.\n         */\n        disable: function () {\n            this.options.disabled = true;\n            this._off(this.trigger);\n            this.forceDeactivate();\n\n            if (this.options.disabledState) {\n                this.element.addClass(this.options.disabledState);\n            }\n            this.trigger.attr('tabIndex', -1);\n        },\n\n        /**\n         * Enable.\n         */\n        enable: function () {\n            this.options.disabled = false;\n            this._on(this.trigger, this.events);\n            this.forceActivate();\n\n            if (this.options.disabledState) {\n                this.element.removeClass(this.options.disabledState);\n            }\n            this.trigger.attr('tabIndex', 0);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _eventHandler: function (event) {\n\n            if (this.options.active && this.options.collapsible) {\n                this.deactivate();\n            } else {\n                this.activate();\n\n            }\n            event.preventDefault();\n\n        },\n\n        /**\n         * @param {*} prop\n         * @private\n         */\n        _animate: function (prop) {\n            var duration,\n                easing,\n                animate = this.options.animate;\n\n            if (typeof animate === 'number') {\n                duration = animate;\n            }\n\n            if (typeof animate === 'string') {\n                animate = JSON.parse(animate);\n            }\n            duration = duration || animate.duration;\n            easing = animate.easing;\n            this.content.animate(prop, duration, easing);\n        },\n\n        /**\n         * Deactivate.\n         */\n        deactivate: function () {\n            if (this.options.animate) {\n                this._animate(hideProps);\n            } else {\n                this.content.hide();\n            }\n            this._close();\n        },\n\n        /**\n         * Force deactivate.\n         */\n        forceDeactivate: function () {\n            this.content.hide();\n            this._close();\n\n        },\n\n        /**\n         * @private\n         */\n        _close: function () {\n            this.options.active = false;\n\n            if (this.options.saveState) {\n                this.storage.set(this.stateKey, false);\n            }\n\n            if (this.options.openedState) {\n                this.element.removeClass(this.options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).removeClass(this.options.collateral.openedState);\n            }\n\n            if (this.options.closedState) {\n                this.element.addClass(this.options.closedState);\n            }\n\n            if (this.icons) {\n                this.header.children('[data-role=icons]')\n                    .removeClass(this.options.icons.activeHeader)\n                    .addClass(this.options.icons.header);\n            }\n\n            // ARIA (updates aria attributes)\n            this.header.attr({\n                'aria-selected': 'false',\n                'aria-expanded': 'false'\n            });\n            this.content.attr({\n                'aria-hidden': 'true'\n            });\n\n            this.element.trigger('dimensionsChanged', {\n                opened: false\n            });\n        },\n\n        /**\n         * Activate.\n         *\n         * @return void;\n         */\n        activate: function () {\n            if (this.options.disabled) {\n                return;\n            }\n\n            if (this.options.animate) {\n                this._animate(showProps);\n            } else {\n                this.content.show();\n            }\n            this._open();\n        },\n\n        /**\n         * Force activate.\n         */\n        forceActivate: function () {\n            if (!this.options.disabled) {\n                this.content.show();\n                this._open();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _open: function () {\n            this.element.trigger('beforeOpen');\n            this.options.active = true;\n\n            if (this.options.ajaxContent) {\n                this._loadContent();\n            }\n\n            if (this.options.saveState) {\n                this.storage.set(this.stateKey, true);\n            }\n\n            if (this.options.openedState) {\n                this.element.addClass(this.options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).addClass(this.options.collateral.openedState);\n            }\n\n            if (this.options.closedState) {\n                this.element.removeClass(this.options.closedState);\n            }\n\n            if (this.icons) {\n                this.header.children('[data-role=icons]')\n                    .removeClass(this.options.icons.header)\n                    .addClass(this.options.icons.activeHeader);\n            }\n\n            // ARIA (updates aria attributes)\n            this.header.attr({\n                'aria-selected': 'true',\n                'aria-expanded': 'true'\n            });\n            this.content.attr({\n                'aria-hidden': 'false'\n            });\n\n            this.element.trigger('dimensionsChanged', {\n                opened: true\n            });\n        },\n\n        /**\n         * @private\n         */\n        _loadContent: function () {\n            var url = this.element.find(this.options.ajaxUrlElement).attr('href'),\n                that = this;\n\n            if (url) {\n                that.xhr = $.get({\n                    url: url,\n                    dataType: 'html'\n                }, function () {\n                });\n            }\n\n            if (that.xhr && that.xhr.statusText !== 'canceled') {\n                if (that.options.loadingClass) {\n                    that.element.addClass(that.options.loadingClass);\n                }\n                that.content.attr('aria-busy', 'true');\n                that.xhr.done(function (response) {\n                    setTimeout(function () {\n                        that.content.html(response);\n                    }, 1);\n                });\n                that.xhr.always(function (jqXHR, status) {\n                    setTimeout(function () {\n                        if (status === 'abort') {\n                            that.content.stop(false, true);\n                        }\n\n                        if (that.options.loadingClass) {\n                            that.element.removeClass(that.options.loadingClass);\n                        }\n                        that.content.removeAttr('aria-busy');\n\n                        if (jqXHR === that.xhr) {\n                            delete that.xhr;\n                        }\n                    }, 1);\n                });\n            }\n        },\n\n        /**\n         * @private\n         */\n        _scrollToTopIfNotVisible: function () {\n            if (this._isElementOutOfViewport()) {\n                this.header[0].scrollIntoView();\n            }\n        },\n\n        /**\n         * @private\n         * @return {Boolean}\n         */\n        _isElementOutOfViewport: function () {\n            var headerRect = this.header[0].getBoundingClientRect(),\n                contentRect = this.content.get().length ? this.content[0].getBoundingClientRect() : false,\n                headerOut,\n                contentOut;\n\n            headerOut = headerRect.bottom - headerRect.height < 0 ||\n                headerRect.right - headerRect.width < 0 ||\n                headerRect.left + headerRect.width > window.innerWidth ||\n                headerRect.top + headerRect.height > window.innerHeight;\n\n            contentOut = contentRect ? contentRect.bottom - contentRect.height < 0 ||\n                contentRect.right - contentRect.width < 0 ||\n                contentRect.left + contentRect.width > window.innerWidth ||\n                contentRect.top + contentRect.height > window.innerHeight : false;\n\n            return headerOut ? headerOut : contentOut;\n        }\n    });\n\n    return $.mage.collapsible;\n});\n","mage/edit-trigger.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate) {\n    'use strict';\n\n    var editTriggerPrototype;\n\n    $.widget('mage.editTrigger', {\n        options: {\n            img: '',\n            alt: '[TR]',\n            template: '#translate-inline-icon',\n            zIndex: 2000,\n            editSelector: '[data-translate]',\n            delay: 2000,\n            offsetTop: -3,\n            singleElement: true\n        },\n\n        /**\n         * editTriger creation\n         * @protected\n         */\n        _create: function () {\n            this.tmpl = mageTemplate(this.options.template);\n            this._initTrigger();\n            this._bind();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _getCss: function () {\n            return {\n                position: 'absolute',\n                cursor: 'pointer',\n                display: 'none',\n                'z-index': this.options.zIndex\n            };\n        },\n\n        /**\n         * @param {*} appendTo\n         * @return {*|jQuery}\n         * @private\n         */\n        _createTrigger: function (appendTo) {\n            var tmpl = this.tmpl({\n                data: this.options\n            });\n\n            return $(tmpl)\n                .css(this._getCss())\n                .data('role', 'edit-trigger-element')\n                .appendTo(appendTo);\n        },\n\n        /**\n         * @private\n         */\n        _initTrigger: function () {\n            this.trigger = this._createTrigger($('body'));\n        },\n\n        /**\n         * Bind on mousemove event\n         * @protected\n         */\n        _bind: function () {\n            this.trigger.on('click.' + this.widgetName, $.proxy(this._onClick, this));\n            this.element.on('mousemove.' + this.widgetName, $.proxy(this._onMouseMove, this));\n        },\n\n        /**\n         * Show editTriger\n         */\n        show: function () {\n            if (this.trigger.is(':hidden')) {\n                this.trigger.show();\n            }\n        },\n\n        /**\n         * Hide editTriger\n         */\n        hide: function () {\n            this.currentTarget = null;\n\n            if (this.trigger && this.trigger.is(':visible')) {\n                this.trigger.hide();\n            }\n        },\n\n        /**\n         * Set editTriger position\n         * @protected\n         */\n        _setPosition: function (el) {\n            var offset = el.offset();\n\n            this.trigger.css({\n                top: offset.top + el.outerHeight() + this.options.offsetTop,\n                left: offset.left\n            });\n        },\n\n        /**\n         * Show/hide trigger on mouse move.\n         *\n         * @param {jQuery.Event} e\n         * @protected\n         */\n        _onMouseMove: function (e) {\n            var target = $(e.target),\n                inner = target.find(this.options.editSelector);\n\n            if ($(e.target).is('button') && inner.length) {\n                target = inner;\n            } else if (!target.is(this.trigger) && !target.is(this.options.editSelector)) {\n                target = target.parents(this.options.editSelector).first();\n            }\n\n            if (target.length) {\n                if (!target.is(this.trigger)) {\n                    this._setPosition(target);\n                    this.currentTarget = target;\n                }\n                this.show();\n            } else {\n                this.hide();\n            }\n        },\n\n        /**\n         * Trigger event \"edit\" on element for translate.\n         *\n         * @param {jQuery.Event} e\n         * @protected\n         */\n        _onClick: function (e) {\n            e.preventDefault();\n            e.stopImmediatePropagation();\n            $(this.currentTarget).trigger('edit.' + this.widgetName);\n            this.hide(true);\n        },\n\n        /**\n         * Destroy editTriger\n         */\n        destroy: function () {\n            this.trigger.remove();\n            this.element.off('.' + this.widgetName);\n\n            return $.Widget.prototype.destroy.call(this);\n        }\n    });\n\n    /**\n     * Extention for widget editTrigger - hide trigger with delay\n     */\n    editTriggerPrototype = $.mage.editTrigger.prototype;\n\n    $.widget('mage.editTrigger', $.extend({}, editTriggerPrototype, {\n        /**\n         * Added clear timeout on trigger show\n         */\n        show: function () {\n            editTriggerPrototype.show.apply(this, arguments);\n\n            if (this.options.delay) {\n                this._clearTimer();\n            }\n        },\n\n        /**\n         * Added setTimeout on trigger hide\n         */\n        hide: function (immediate) {\n            if (!immediate && this.options.delay) {\n                if (!this.timer) {\n                    this.timer = setTimeout($.proxy(function () {\n                        editTriggerPrototype.hide.apply(this, arguments);\n                        this._clearTimer();\n                    }, this), this.options.delay);\n                }\n            } else {\n                editTriggerPrototype.hide.apply(this, arguments);\n            }\n        },\n\n        /**\n         * Clear timer\n         * @protected\n         */\n        _clearTimer: function () {\n            if (this.timer) {\n                clearTimeout(this.timer);\n                this.timer = null;\n            }\n        }\n    }));\n\n    return $.mage.editTrigger;\n});\n","mage/polyfill.js":"(function (root, doc) {\n    'use strict';\n\n    var Storage;\n\n    try {\n        if (!root.localStorage || !root.sessionStorage) {\n            throw new Error();\n        }\n\n        localStorage.setItem('storage_test', 1);\n        localStorage.removeItem('storage_test');\n    } catch (e) {\n        /**\n         * Returns a storage object to shim local or sessionStorage\n         * @param {String} type - either 'local' or 'session'\n         */\n        Storage = function (type) {\n            var data;\n\n            /**\n             * Creates a cookie\n             * @param {String} name\n             * @param {String} value\n             * @param {Integer} days\n             */\n            function createCookie(name, value, days) {\n                var date, expires;\n\n                if (days) {\n                    date = new Date();\n                    date.setTime(date.getTime() + days * 24 * 60 * 60 * 1000);\n                    expires = '; expires=' + date.toGMTString();\n                } else {\n                    expires = '';\n                }\n                doc.cookie = name + '=' + value + expires + '; path=/';\n            }\n\n            /**\n             * Reads value of a cookie\n             * @param {String} name\n             */\n            function readCookie(name) {\n                var nameEQ = name + '=',\n                    ca = doc.cookie.split(';'),\n                    i = 0,\n                    c;\n\n                for (i = 0; i < ca.length; i++) {\n                    c = ca[i];\n\n                    while (c.charAt(0) === ' ') {\n                        c = c.substring(1, c.length);\n                    }\n\n                    if (c.indexOf(nameEQ) === 0) {\n                        return c.substring(nameEQ.length, c.length);\n                    }\n                }\n\n                return null;\n            }\n\n            /**\n             * Returns cookie name based upon the storage type.\n             * If this is session storage, the function returns a unique cookie per tab\n             */\n            function getCookieName() {\n\n                if (type !== 'session') {\n                    return 'localstorage';\n                }\n\n                if (!root.name) {\n                    root.name = new Date().getTime();\n                }\n\n                return 'sessionStorage' + root.name;\n            }\n\n            /**\n             * Sets storage cookie to a data object\n             * @param {Object} dataObject\n             */\n            function setData(dataObject) {\n                data = encodeURIComponent(JSON.stringify(dataObject));\n                createCookie(getCookieName(), data, 365);\n            }\n\n            /**\n             * Clears value of cookie data\n             */\n            function clearData() {\n                createCookie(getCookieName(), '', 365);\n            }\n\n            /**\n             * @returns value of cookie data\n             */\n            function getData() {\n                var dataResponse = readCookie(getCookieName());\n\n                return dataResponse ? JSON.parse(decodeURIComponent(dataResponse)) : {};\n            }\n\n            data = getData();\n\n            return {\n                length: 0,\n\n                /**\n                 * Clears data from storage\n                 */\n                clear: function () {\n                    data = {};\n                    this.length = 0;\n                    clearData();\n                },\n\n                /**\n                 * Gets an item from storage\n                 * @param {String} key\n                 */\n                getItem: function (key) {\n                    return data[key] === undefined ? null : data[key];\n                },\n\n                /**\n                 * Gets an item by index from storage\n                 * @param {Integer} i\n                 */\n                key: function (i) {\n                    var ctr = 0,\n                        k;\n\n                    for (k in data) {\n\n                        if (data.hasOwnProperty(k)) {\n\n                            // eslint-disable-next-line max-depth\n                            if (ctr.toString() === i.toString()) {\n                                return k;\n                            }\n                            ctr++;\n                        }\n                    }\n\n                    return null;\n                },\n\n                /**\n                 * Removes an item from storage\n                 * @param {String} key\n                 */\n                removeItem: function (key) {\n                    delete data[key];\n                    this.length--;\n                    setData(data);\n                },\n\n                /**\n                 * Sets an item from storage\n                 * @param {String} key\n                 * @param {String} value\n                 */\n                setItem: function (key, value) {\n                    data[key] = value.toString();\n                    this.length++;\n                    setData(data);\n                }\n            };\n        };\n\n        root.localStorage.prototype = root.localStorage = new Storage('local');\n        root.sessionStorage.prototype = root.sessionStorage = new Storage('session');\n    }\n})(window, document);\n","mage/smart-keyboard-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @return {Object}\n     * @constructor\n     */\n    function KeyboardHandler() {\n        var body = $('body'),\n            focusState = false,\n            tabFocusClass = '_keyfocus',\n            productsGrid = '[data-container=\"product-grid\"]',\n            catalogProductsGrid = $(productsGrid),\n            CODE_TAB = 9;\n\n        /**\n         * Handle logic, when onTabKeyPress fired at first.\n         * Then it changes state.\n         */\n        function onFocusInHandler() {\n            focusState = true;\n            body.addClass(tabFocusClass)\n                .off('focusin.keyboardHandler', onFocusInHandler);\n        }\n\n        /**\n         * Handle logic to remove state after onTabKeyPress to normal.\n         */\n        function onClickHandler() {\n            focusState = false;\n            body.removeClass(tabFocusClass)\n                .off('click', onClickHandler);\n        }\n\n        /**\n         * Tab key onKeypress handler. Apply main logic:\n         *  - call differ actions onTabKeyPress and onClick\n         */\n        function smartKeyboardFocus() {\n            $(document).on('keydown keypress', function (event) {\n                if (event.which === CODE_TAB && !focusState) {\n                    body\n                        .on('focusin.keyboardHandler', onFocusInHandler)\n                        .on('click', onClickHandler);\n                }\n            });\n\n            // ARIA support for catalog grid products\n            if (catalogProductsGrid.length) {\n                body.on('focusin.gridProducts', productsGrid, function () {\n                    if (body.hasClass(tabFocusClass)) {\n                        $(this).addClass('active');\n                    }\n                });\n                body.on('focusout.gridProducts', productsGrid, function () {\n                    $(this).removeClass('active');\n                });\n            }\n        }\n\n        /**\n         * Attach smart focus on specific element.\n         * @param {jQuery} element\n         */\n        function handleFocus(element) {\n            element.on('focusin.emulateTabFocus', function () {\n                focusState = true;\n                body.addClass(tabFocusClass);\n                element.off();\n            });\n\n            element.on('focusout.emulateTabFocus', function () {\n                focusState = false;\n                body.removeClass(tabFocusClass);\n                element.off();\n            });\n        }\n\n        return {\n            apply: smartKeyboardFocus,\n            focus: handleFocus\n        };\n    }\n\n    return new KeyboardHandler;\n});\n","mage/tabs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'jquery/ui-modules/widgets/tabs',\n    'mage/mage',\n    'mage/collapsible'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.tabs', {\n        options: {\n            active: 0,\n            disabled: [],\n            openOnFocus: true,\n            collapsible: false,\n            collapsibleElement: '[data-role=collapsible]',\n            header: '[data-role=title]',\n            content: '[data-role=content]',\n            trigger: '[data-role=trigger]',\n            closedState: null,\n            openedState: null,\n            disabledState: null,\n            ajaxUrlElement: '[data-ajax=true]',\n            ajaxContent: false,\n            loadingClass: null,\n            saveState: false,\n            animate: false,\n            icons: {\n                activeHeader: null,\n                header: null\n            }\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            if (typeof this.options.disabled === 'string') {\n                this.options.disabled = this.options.disabled.split(' ').map(function (item) {\n                    return parseInt(item, 10);\n                });\n            }\n            this._processPanels();\n            this._handleDeepLinking();\n            this._processTabIndex();\n            this._closeOthers();\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            $.each(this.collapsibles, function () {\n                $(this).collapsible('destroy');\n            });\n        },\n\n        /**\n         * If deep linking is used, all sections must be closed but the one that contains the anchor.\n         * @private\n         */\n        _handleDeepLinking: function () {\n            var self = this,\n                anchor = window.location.hash,\n                isValid = $.mage.isValidSelector(anchor),\n                anchorId = anchor.replace('#', '');\n\n            if (anchor && isValid) {\n                $.each(self.contents, function (i) {\n                    if ($(this).attr('id') === anchorId || $(this).find('#' + anchorId).length) {\n                        self.collapsibles.not(self.collapsibles.eq(i)).collapsible('forceDeactivate');\n\n                        return false;\n                    }\n                });\n            }\n        },\n\n        /**\n         * When the widget gets instantiated, the first tab that is not disabled receive focusable property\n         * All tabs receive tabIndex 0\n         * @private\n         */\n        _processTabIndex: function () {\n            var self = this;\n\n            self.triggers.attr('tabIndex', 0);\n            $.each(this.collapsibles, function (i) {\n                self.triggers.attr('tabIndex', 0);\n                self.triggers.eq(i).attr('tabIndex', 0);\n            });\n        },\n\n        /**\n         * Prepare the elements for instantiating the collapsible widget\n         * @private\n         */\n        _processPanels: function () {\n            var isNotNested = this._isNotNested.bind(this);\n\n            this.contents = this.element\n                .find(this.options.content)\n                .filter(isNotNested);\n\n            this.collapsibles =  this.element\n                .find(this.options.collapsibleElement)\n                .filter(isNotNested);\n\n            this.collapsibles\n                .attr('role', 'presentation')\n                .parent()\n                .attr('role', 'tablist');\n\n            this.headers = this.element\n                .find(this.options.header)\n                .filter(isNotNested);\n\n            if (this.headers.length === 0) {\n                this.headers = this.collapsibles;\n            }\n            this.triggers = this.element\n                .find(this.options.trigger)\n                .filter(isNotNested);\n\n            if (this.triggers.length === 0) {\n                this.triggers = this.headers;\n            }\n            this._callCollapsible();\n        },\n\n        /**\n         * Checks if element is not in nested container to keep the correct scope of collapsible\n         * @param {Number} index\n         * @param {HTMLElement} element\n         * @private\n         * @return {Boolean}\n         */\n        _isNotNested: function (index, element) {\n            var parentContent = $(element).parents(this.options.content);\n\n            return !parentContent.length || !this.element.find(parentContent).length;\n        },\n\n        /**\n         * Setting the disabled and active tabs and calling instantiation of collapsible\n         * @private\n         */\n        _callCollapsible: function () {\n            var self = this,\n                disabled = false,\n                active = false;\n\n            $.each(this.collapsibles, function (i) {\n                disabled = active = false;\n\n                if ($.inArray(i, self.options.disabled) !== -1) {\n                    disabled = true;\n                }\n\n                if (i === self.options.active) {\n                    active = true;\n                }\n                self._instantiateCollapsible(this, i, active, disabled);\n            });\n        },\n\n        /**\n         * Instantiate collapsible.\n         *\n         * @param {HTMLElement} element\n         * @param {Number} index\n         * @param {*} active\n         * @param {*} disabled\n         * @private\n         */\n        _instantiateCollapsible: function (element, index, active, disabled) {\n            $(element).collapsible(\n                $.extend({}, this.options, {\n                    active: active,\n                    disabled: disabled,\n                    header: this.headers.eq(index),\n                    content: this.contents.eq(index),\n                    trigger: this.triggers.eq(index)\n                })\n            );\n        },\n\n        /**\n         * Adding callback to close others tabs when one gets opened\n         * @private\n         */\n        _closeOthers: function () {\n            var self = this;\n\n            $.each(this.collapsibles, function () {\n                $(this).on('beforeOpen', function () {\n                    self.collapsibles.not(this).collapsible('forceDeactivate');\n                });\n            });\n        },\n\n        /**\n         * @param {*} index\n         */\n        activate: function (index) {\n            this._toggleActivate('activate', index);\n        },\n\n        /**\n         * @param {*} index\n         */\n        deactivate: function (index) {\n            this._toggleActivate('deactivate', index);\n        },\n\n        /**\n         * @param {*} action\n         * @param {*} index\n         * @private\n         */\n        _toggleActivate: function (action, index) {\n            this.collapsibles.eq(index).collapsible(action);\n        },\n\n        /**\n         * @param {*} index\n         */\n        disable: function (index) {\n            this._toggleEnable('disable', index);\n        },\n\n        /**\n         * @param {*} index\n         */\n        enable: function (index) {\n            this._toggleEnable('enable', index);\n        },\n\n        /**\n         * @param {*} action\n         * @param {*} index\n         * @private\n         */\n        _toggleEnable: function (action, index) {\n            var self = this;\n\n            if (Array.isArray(index)) {\n                $.each(index, function () {\n                    self.collapsibles.eq(this).collapsible(action);\n                });\n            } else if (index === undefined) {\n                this.collapsibles.collapsible(action);\n            } else {\n                this.collapsibles.eq(index).collapsible(action);\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var self = this,\n                keyCode, toFocus, toFocusIndex, enabledTriggers, length, currentIndex, nextToFocus;\n\n            if (event.altKey || event.ctrlKey) {\n                return;\n            }\n            keyCode = $.ui.keyCode;\n            toFocus = false;\n            enabledTriggers = [];\n\n            $.each(this.triggers, function () {\n                if (!self.collapsibles.eq(self.triggers.index($(this))).collapsible('option', 'disabled')) {\n                    enabledTriggers.push(this);\n                }\n            });\n            length = $(enabledTriggers).length;\n            currentIndex = $(enabledTriggers).index(event.target);\n\n            /**\n             * @param {String} direction\n             * @return {*}\n             */\n            nextToFocus = function (direction) {\n                if (length > 0) {\n                    if (direction === 'right') {\n                        toFocusIndex = (currentIndex + 1) % length;\n                    } else {\n                        toFocusIndex = (currentIndex + length - 1) % length;\n                    }\n\n                    return enabledTriggers[toFocusIndex];\n                }\n\n                return event.target;\n            };\n\n            switch (event.keyCode) {\n                case keyCode.RIGHT:\n                case keyCode.DOWN:\n                    toFocus = nextToFocus('right');\n                    break;\n\n                case keyCode.LEFT:\n                case keyCode.UP:\n                    toFocus = nextToFocus('left');\n                    break;\n\n                case keyCode.HOME:\n                    toFocus = enabledTriggers[0];\n                    break;\n\n                case keyCode.END:\n                    toFocus = enabledTriggers[length - 1];\n                    break;\n            }\n\n            if (toFocus) {\n                toFocusIndex = this.triggers.index(toFocus);\n                $(event.target).attr('tabIndex', -1);\n                $(toFocus).attr('tabIndex', 0);\n                toFocus.focus();\n\n                if (this.options.openOnFocus) {\n                    this.activate(toFocusIndex);\n                }\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var events = {\n                keydown: '_keydown'\n            };\n\n            this._off(this.triggers);\n            this._on(this.triggers, events);\n        }\n    });\n\n    return $.mage.tabs;\n});\n","mage/requirejs/resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'domReady!'\n], function (_) {\n    'use strict';\n\n    var context = require.s.contexts._,\n        execCb = context.execCb,\n        registry = context.registry,\n        callbacks = [],\n        retries = 10,\n        updateDelay = 1,\n        ready,\n        update;\n\n    /**\n     * Checks if provided callback already exists in the callbacks list.\n     *\n     * @param {Object} callback - Callback object to be checked.\n     * @returns {Boolean}\n     */\n    function isSubscribed(callback) {\n        return !!_.findWhere(callbacks, callback);\n    }\n\n    /**\n     * Checks if provided module is rejected during load.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isRejected(module) {\n        return registry[module.id] && (registry[module.id].inited || registry[module.id].error);\n    }\n\n    /**\n     * Checks if provided module had path fallback triggered.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isPathFallback(module) {\n        return registry[module.id] && registry[module.id].events.error;\n    }\n\n    /**\n     * Checks if provided module has unresolved dependencies.\n     *\n     * @param {Object} module - Module to be checked.\n     * @returns {Boolean}\n     */\n    function isPending(module) {\n        if (!module.depCount) {\n            return false;\n        }\n\n        return module.depCount >\n            _.filter(module.depMaps, isRejected).length + _.filter(module.depMaps, isPathFallback).length;\n    }\n\n    /**\n     * Checks if requirejs's registry object contains pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function hasPending() {\n        return _.some(registry, isPending);\n    }\n\n    /**\n     * Checks if 'resolver' module is in ready\n     * state and that there are no pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function isReady() {\n        return ready && !hasPending();\n    }\n\n    /**\n     * Invokes provided callback handler.\n     *\n     * @param {Object} callback\n     */\n    function invoke(callback) {\n        callback.handler.call(callback.ctx);\n    }\n\n    /**\n     * Sets 'resolver' module to a ready state\n     * and invokes pending callbacks.\n     */\n    function resolve() {\n        ready = true;\n\n        callbacks.splice(0).forEach(invoke);\n    }\n\n    /**\n     * Drops 'ready' flag and runs the update process.\n     */\n    function tick() {\n        ready = false;\n\n        update(retries);\n    }\n\n    /**\n     * Adds callback which will be invoked\n     * when all of the pending modules are initiated.\n     *\n     * @param {Function} handler - 'Ready' event handler function.\n     * @param {Object} [ctx] - Optional context with which handler\n     *      will be invoked.\n     */\n    function subscribe(handler, ctx) {\n        var callback = {\n            handler: handler,\n            ctx: ctx\n        };\n\n        if (!isSubscribed(callback)) {\n            callbacks.push(callback);\n\n            if (isReady()) {\n                _.defer(tick);\n            }\n        }\n    }\n\n    /**\n     * Checks for all modules to be initiated\n     * and invokes pending callbacks if it's so.\n     *\n     * @param {Number} [retry] - Number of retries\n     *      that will be used to repeat the 'update' function\n     *      invokation in case if there are no pending requests.\n     */\n    update = _.debounce(function (retry) {\n        if (!hasPending()) {\n            retry ? update(--retry) : resolve();\n        }\n    }, updateDelay);\n\n    /**\n     * Overrides requirejs's original 'execCb' method\n     * in order to track pending modules.\n     *\n     * @returns {*} Result of original method call.\n     */\n    context.execCb = function () {\n        var exported = execCb.apply(context, arguments);\n\n        tick();\n\n        return exported;\n    };\n\n    return subscribe;\n});\n","mage/requirejs/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* inspired by http://github.com/requirejs/text */\n/*global XDomainRequest */\n\ndefine(['module'], function (module) {\n    'use strict';\n\n    var xmlRegExp = /^\\s*<\\?xml(\\s)+version=[\\'\\\"](\\d)*.(\\d)*[\\'\\\"](\\s)*\\?>/im,\n        bodyRegExp = /<body[^>]*>\\s*([\\s\\S]+)\\s*<\\/body>/im,\n        stripReg = /!strip$/i,\n        defaultConfig = module.config && module.config() || {};\n\n    /**\n     * Strips <?xml ...?> declarations so that external SVG and XML documents can be\n     * added to a document without worry.\n     * Also, if the string is an HTML document, only the part inside the body tag is returned.\n     *\n     * @param {String} external\n     * @returns {String}\n     */\n    function stripContent(external) {\n        var matches;\n\n        if (!external) {\n            return '';\n        }\n\n        matches = external.match(bodyRegExp);\n        external = matches ?\n            matches[1] :\n            external.replace(xmlRegExp, '');\n\n        return external;\n    }\n\n    /**\n     * Checks that url match current location\n     *\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    function sameDomain(url) {\n        var uProtocol, uHostName, uPort,\n            xdRegExp = /^([\\w:]+)?\\/\\/([^\\/\\\\]+)/i,\n            location = window.location,\n            match = xdRegExp.exec(url);\n\n        if (!match) {\n            return true;\n        }\n        uProtocol = match[1];\n        uHostName = match[2];\n\n        uHostName = uHostName.split(':');\n        uPort = uHostName[1] || '';\n        uHostName = uHostName[0];\n\n        return (!uProtocol || uProtocol === location.protocol) &&\n            (!uHostName || uHostName.toLowerCase() === location.hostname.toLowerCase()) &&\n            (!uPort && !uHostName || uPort === location.port);\n    }\n\n    /**\n     * @returns {XMLHttpRequest|XDomainRequest|null}\n     */\n    function createRequest(url) {\n        var xhr = new XMLHttpRequest();\n\n        if (!sameDomain(url) && typeof XDomainRequest !== 'undefined') {\n            xhr = new XDomainRequest();\n        }\n\n        return xhr;\n    }\n\n    /**\n     * XHR requester. Returns value to callback.\n     *\n     * @param {String} url\n     * @param {Function} callback\n     * @param {Function} fail\n     * @param {Object} headers\n     */\n    function getContent(url, callback, fail, headers) {\n        var xhr = createRequest(url),\n            header;\n\n        xhr.open('GET', url);\n\n        /*eslint-disable max-depth */\n        if ('setRequestHeader' in xhr && headers) {\n            for (header in headers) {\n                if (headers.hasOwnProperty(header)) {\n                    xhr.setRequestHeader(header.toLowerCase(), headers[header]);\n                }\n            }\n        }\n\n        /**\n         * @inheritdoc\n         */\n        xhr.onreadystatechange = function () {\n            var status, err;\n\n            //Do not explicitly handle errors, those should be\n            //visible via console output in the browser.\n            if (xhr.readyState === 4) {\n                status = xhr.status || 0;\n\n                if (status > 399 && status < 600) {\n                    //An http 4xx or 5xx error. Signal an error.\n                    err = new Error(url + ' HTTP status: ' + status);\n                    err.xhr = xhr;\n\n                    if (fail) {\n                        fail(err);\n                    }\n                } else {\n                    callback(xhr.responseText);\n\n                    if (defaultConfig.onXhrComplete) {\n                        defaultConfig.onXhrComplete(xhr, url);\n                    }\n                }\n            }\n        };\n\n        /*eslint-enable max-depth */\n\n        if (defaultConfig.onXhr) {\n            defaultConfig.onXhr(xhr, url);\n        }\n\n        xhr.send();\n    }\n\n    /**\n     * Main method used by RequireJs.\n     *\n     * @param {String} name - has format: some.module.filext!strip\n     * @param {Function} req\n     * @param {Function|undefined} onLoad\n     */\n    function loadContent(name, req, onLoad) {\n\n        var toStrip = stripReg.test(name),\n            url = req.toUrl(name.replace(stripReg, '')),\n            headers = defaultConfig.headers;\n\n        getContent(url, function (content) {\n                content = toStrip ? stripContent(content) : content;\n                onLoad(content);\n            }, onLoad.error, headers);\n    }\n\n    return {\n        load: loadContent,\n        get: getContent\n    };\n});\n","mage/requirejs/baseUrlResolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Sample configuration:\n *\n require.config({\n        \"config\": {\n            \"baseUrlInterceptor\": {\n                \"Magento_Ui/js/lib/knockout/bindings/collapsible.js\": \"../../../../frontend/Magento/luma/en_US/\"\n            }\n        }\n    });\n */\n\n/* global jsSuffixRegExp */\n/* eslint-disable max-depth */\ndefine('baseUrlInterceptor', [\n    'module'\n], function (module) {\n    'use strict';\n\n    /**\n     * RequireJS Context object\n     */\n    var ctx = require.s.contexts._,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        origNameToUrl = ctx.nameToUrl,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        newContextConstr = require.s.newContext;\n\n    /**\n     * Remove dots from URL\n     *\n     * @param {Array} ary\n     */\n    function trimDots(ary) {\n        var i, part, length = ary.length;\n\n        for (i = 0; i < length; i++) {\n            part = ary[i];\n\n            if (part === '.') {\n                ary.splice(i, 1);\n                i -= 1;\n            } else if (part === '..') {\n                if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {\n                    //End of the line. Keep at least one non-dot\n                    //path segment at the front so it can be mapped\n                    //correctly to disk. Otherwise, there is likely\n                    //no path mapping for a path starting with '..'.\n                    //This can still fail, but catches the most reasonable\n                    //uses of ..\n                    break;\n                } else if (i > 0) {\n                    ary.splice(i - 1, 2);\n                    i -= 2;\n                }\n            }\n        }\n    }\n\n    /**\n     * Normalize URL string (remove '/../')\n     *\n     * @param {String} name\n     * @param {String} baseName\n     * @param {Object} applyMap\n     * @param {Object} localContext\n     * @returns {*}\n     */\n    function normalize(name, baseName, applyMap, localContext) {\n        var lastIndex,\n            baseParts = baseName && baseName.split('/'),\n            normalizedBaseParts = baseParts;\n\n        //Adjust any relative paths.\n        if (name && name.charAt(0) === '.') {\n            //If have a base name, try to normalize against it,\n            //otherwise, assume it is a top-level require that will\n            //be relative to baseUrl in the end.\n            if (baseName) {\n                //Convert baseName to array, and lop off the last part,\n                //so that . matches that 'directory' and not name of the baseName's\n                //module. For instance, baseName of 'one/two/three', maps to\n                //'one/two/three.js', but we want the directory, 'one/two' for\n                //this normalization.\n                normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);\n                name = name.split('/');\n                lastIndex = name.length - 1;\n\n                // If wanting node ID compatibility, strip .js from end\n                // of IDs. Have to do this here, and not in nameToUrl\n                // because node allows either .js or non .js to map\n                // to same file.\n                if (localContext.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {\n                    name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');\n                }\n\n                name = normalizedBaseParts.concat(name);\n                trimDots(name);\n                name = name.join('/');\n            } else if (name.indexOf('./') === 0) {\n                // No baseName, so this is ID is resolved relative\n                // to baseUrl, pull off the leading dot.\n                name = name.substring(2);\n            }\n        }\n\n        return name;\n    }\n\n    /**\n     * Get full url.\n     *\n     * @param {Object} context\n     * @param {String} url\n     * @return {String}\n     */\n    function getUrl(context, url) {\n        var baseUrl = context.config.baseUrl,\n            newConfig = context.config,\n            modulePath = url.replace(baseUrl, ''),\n            newBaseUrl,\n            rewrite = module.config()[modulePath];\n\n        if (!rewrite) {\n            return url;\n        }\n\n        newBaseUrl = normalize(rewrite, baseUrl, undefined, newConfig);\n\n        return newBaseUrl + modulePath;\n    }\n\n    /**\n     * Replace original function.\n     *\n     * @returns {*}\n     */\n    ctx.nameToUrl = function () {\n        return getUrl(ctx, origNameToUrl.apply(ctx, arguments));\n    };\n\n    /**\n     * Replace original function.\n     *\n     * @return {*}\n     */\n    require.s.newContext = function () {\n        var newCtx = newContextConstr.apply(require.s, arguments),\n            newOrigNameToUrl = newCtx.nameToUrl;\n\n        /**\n         * New implementation of native function.\n         *\n         * @returns {String}\n         */\n        newCtx.nameToUrl = function () {\n            return getUrl(newCtx, newOrigNameToUrl.apply(newCtx, arguments));\n        };\n\n        return newCtx;\n    };\n});\n\nrequire(['baseUrlInterceptor'], function () {\n    'use strict';\n\n});\n","mage/utils/main.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function (require) {\n    'use strict';\n\n    var utils = {},\n        _ = require('underscore'),\n        root = typeof self == 'object' && self.self === self && self ||\n            typeof global == 'object' && global.global === global && global ||\n            Function('return this')() || {};\n\n    root._ = _;\n\n    return _.extend(\n        utils,\n        require('./arrays'),\n        require('./compare'),\n        require('./misc'),\n        require('./objects'),\n        require('./strings'),\n        require('./template')\n    );\n});\n","mage/utils/objects.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'mage/utils/strings'\n], function (ko, $, _, stringUtils) {\n    'use strict';\n\n    var primitives = [\n        'undefined',\n        'boolean',\n        'number',\n        'string'\n    ];\n\n    /**\n     * Sets nested property of a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @param {*} value - Value of the last property in 'path' array.\n     * returns {*} New value for the property.\n     */\n    function setNested(parent, path, value) {\n        var last = path.pop(),\n            len = path.length,\n            pi = 0,\n            part = path[pi];\n\n        for (; pi < len; part = path[++pi]) {\n            if (!_.isObject(parent[part])) {\n                parent[part] = {};\n            }\n\n            parent = parent[part];\n        }\n\n        if (typeof parent[last] === 'function') {\n            parent[last](value);\n        } else {\n            parent[last] = value;\n        }\n\n        return value;\n    }\n\n    /**\n     * Retrieves value of a nested property.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @returns {*} Value of the property.\n     */\n    function getNested(parent, path) {\n        var exists = true,\n            len = path.length,\n            pi = 0;\n\n        for (; pi < len && exists; pi++) {\n            parent = parent[path[pi]];\n\n            if (typeof parent === 'undefined') {\n                exists = false;\n            }\n        }\n\n        if (exists) {\n            if (ko.isObservable(parent)) {\n                parent = parent();\n            }\n\n            return parent;\n        }\n    }\n\n    /**\n     * Removes property from a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object from which to remove property.\n     * @param {Array} path - Splitted path to the property.\n     */\n    function removeNested(parent, path) {\n        var field = path.pop();\n\n        parent = getNested(parent, path);\n\n        if (_.isObject(parent)) {\n            delete parent[field];\n        }\n    }\n\n    return {\n\n        /**\n         * Retrieves or defines objects' property by a composite path.\n         *\n         * @param {Object} data - Container for the properties specified in path.\n         * @param {String} path - Objects' properties divided by dots.\n         * @param {*} [value] - New value for the last property.\n         * @returns {*} Returns value of the last property in chain.\n         *\n         * @example\n         *      utils.nested({}, 'one.two', 3);\n         *      => { one: {two: 3} }\n         */\n        nested: function (data, path, value) {\n            var action = arguments.length > 2 ? setNested : getNested;\n\n            path = path ? path.split('.') : [];\n\n            return action(data, path, value);\n        },\n\n        /**\n         * Removes nested property from an object.\n         *\n         * @param {Object} data - Data source.\n         * @param {String} path - Path to the property e.g. 'one.two.three'\n         */\n        nestedRemove: function (data, path) {\n            path = path.split('.');\n\n            removeNested(data, path);\n        },\n\n        /**\n         * Flattens objects' nested properties.\n         *\n         * @param {Object} data - Object to flatten.\n         * @param {String} [separator='.'] - Objects' keys separator.\n         * @returns {Object} Flattened object.\n         *\n         * @example Example with a default separator.\n         *      utils.flatten({one: { two: { three: 'value'} }});\n         *      => { 'one.two.three': 'value' };\n         *\n         * @example Example with a custom separator.\n         *      utils.flatten({one: { two: { three: 'value'} }}, '=>');\n         *      => {'one=>two=>three': 'value'};\n         */\n        flatten: function (data, separator, parent, result) {\n            separator = separator || '.';\n            result = result || {};\n\n            if (!data) {\n                return result;\n            }\n\n            // UnderscoreJS each breaks when an object has a length property so we use Object.keys\n            _.each(Object.keys(data), function (name) {\n                var node = data[name];\n\n                if ({}.toString.call(node) === '[object Function]') {\n                    return;\n                }\n\n                if (parent) {\n                    name = parent + separator + name;\n                }\n\n                typeof node === 'object' ?\n                    this.flatten(node, separator, name, result) :\n                    result[name] = node;\n\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Opposite operation of the 'flatten' method.\n         *\n         * @param {Object} data - Previously flattened object.\n         * @param {String} [separator='.'] - Keys separator.\n         * @returns {Object} Object with nested properties.\n         *\n         * @example Example using custom separator.\n         *      utils.unflatten({'one=>two': 'value'}, '=>');\n         *      => {\n         *          one: { two: 'value' }\n         *      };\n         */\n        unflatten: function (data, separator) {\n            var result = {};\n\n            separator = separator || '.';\n\n            _.each(data, function (value, nodes) {\n                nodes = nodes.split(separator);\n\n                setNested(result, nodes, value);\n            });\n\n            return result;\n        },\n\n        /**\n         * Same operation as 'flatten' method,\n         * but returns objects' keys wrapped in '[]'.\n         *\n         * @param {Object} data - Object that should be serialized.\n         * @returns {Object} Serialized data.\n         *\n         * @example\n         *      utils.serialize({one: { two: { three: 'value'} }});\n         *      => { 'one[two][three]': 'value' }\n         */\n        serialize: function (data) {\n            var result = {};\n\n            data = this.flatten(data);\n\n            _.each(data, function (value, keys) {\n                keys = stringUtils.serializeName(keys);\n                value = _.isUndefined(value) ? '' : value;\n\n                result[keys] = value;\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Performs deep extend of specified objects.\n         *\n         * @returns {Object|Array} Extended object.\n         */\n        extend: function () {\n            var args = _.toArray(arguments);\n\n            args.unshift(true);\n\n            return $.extend.apply($, args);\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         *\n         * @param {(Object|Array)} data - Data that should be copied.\n         * @returns {Object|Array} Cloned object.\n         */\n        copy: function (data) {\n            var result = data,\n                isArray = Array.isArray(data),\n                placeholder;\n\n            if (this.isObject(data) || isArray) {\n                placeholder = isArray ? [] : {};\n                result = this.extend(placeholder, data);\n            }\n\n            return result;\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         * Doesn't save links to original object.\n         *\n         * @param {*} original - Object to clone\n         * @returns {*}\n         */\n        hardCopy: function (original) {\n            if (original === null || typeof original !== 'object') {\n                return original;\n            }\n\n            return JSON.parse(JSON.stringify(original));\n        },\n\n        /**\n         * Removes specified nested properties from the target object.\n         *\n         * @param {Object} target - Object whose properties should be removed.\n         * @param {(...String|Array|Object)} list - List that specifies properties to be removed.\n         * @returns {Object} Modified object.\n         *\n         * @example Basic usage\n         *      var obj = {a: {b: 2}, c: 'a'};\n         *\n         *      omit(obj, 'a.b');\n         *      => {'a.b': 2};\n         *      obj => {a: {}, c: 'a'};\n         *\n         * @example Various syntaxes that would return same result\n         *      omit(obj, ['a.b', 'c']);\n         *      omit(obj, 'a.b', 'c');\n         *      omit(obj, {'a.b': true, 'c': true});\n         */\n        omit: function (target, list) {\n            var removed = {},\n                ignored = list;\n\n            if (this.isObject(list)) {\n                ignored = [];\n\n                _.each(list, function (value, key) {\n                    if (value) {\n                        ignored.push(key);\n                    }\n                });\n            } else if (_.isString(list)) {\n                ignored = _.toArray(arguments).slice(1);\n            }\n\n            _.each(ignored, function (path) {\n                var value = this.nested(target, path);\n\n                if (!_.isUndefined(value)) {\n                    removed[path] = value;\n\n                    this.nestedRemove(target, path);\n                }\n            }, this);\n\n            return removed;\n        },\n\n        /**\n         * Checks if provided value is a plain object.\n         *\n         * @param {*} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isObject: function (value) {\n            var objProto = Object.prototype;\n\n            return typeof value == 'object' ?\n            objProto.toString.call(value) === '[object Object]' :\n                false;\n        },\n\n        /**\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isPrimitive: function (value) {\n            return value === null || ~primitives.indexOf(typeof value);\n        },\n\n        /**\n         * Iterates over obj props/array elems recursively, applying action to each one\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to be called with each item as an argument.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         */\n        forEachRecursive: function (data, action, maxDepth) {\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return;\n            }\n\n            if (!_.isObject(data)) {\n                action(data);\n\n                return;\n            }\n\n            _.each(data, function (value) {\n                this.forEachRecursive(value, action, maxDepth);\n            }, this);\n\n            action(data);\n        },\n\n        /**\n         * Maps obj props/array elems recursively\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to transform each item.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         *\n         * @returns {Object|Array}\n         */\n        mapRecursive: function (data, action, maxDepth) {\n            var newData;\n\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return data;\n            }\n\n            if (!_.isObject(data)) {\n                return action(data);\n            }\n\n            if (_.isArray(data)) {\n                newData = _.map(data, function (item) {\n                    return this.mapRecursive(item, action, maxDepth);\n                }, this);\n\n                return action(newData);\n            }\n\n            newData = _.mapObject(data, function (val, key) {\n                if (data.hasOwnProperty(key)) {\n                    return this.mapRecursive(val, action, maxDepth);\n                }\n\n                return val;\n            }, this);\n\n            return action(newData);\n        },\n\n        /**\n         * Removes empty(in common sence) obj props/array elems\n         *\n         * @param {*} data - Data to be cleaned.\n         * @returns {*}\n         */\n        removeEmptyValues: function (data) {\n            if (!_.isObject(data)) {\n                return data;\n            }\n\n            if (_.isArray(data)) {\n                return data.filter(function (item) {\n                    return !this.isEmptyObj(item);\n                }, this);\n            }\n\n            return _.omit(data, this.isEmptyObj.bind(this));\n        },\n\n        /**\n         * Checks that argument of any type is empty in common sence:\n         * empty string, string with spaces only, object without own props, empty array, null or undefined\n         *\n         * @param {*} val - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEmptyObj: function (val) {\n\n            return _.isObject(val) && _.isEmpty(val) ||\n            this.isEmpty(val) ||\n            val && val.trim && this.isEmpty(val.trim());\n        }\n    };\n});\n\n","mage/utils/compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mage/utils/objects'\n], function (_, utils) {\n    'use strict';\n\n    var result = [];\n\n    /**\n     * Checks if all of the provided arrays contains equal values.\n     *\n     * @param {(Boolean|Array)} [keepOrder=false]\n     * @param {Array} target\n     * @returns {Boolean}\n     */\n    function equalArrays(keepOrder, target) {\n        var args = _.toArray(arguments),\n            arrays;\n\n        if (!Array.isArray(keepOrder)) {\n            arrays      = args.slice(2);\n        } else {\n            target      = keepOrder;\n            keepOrder   = false;\n            arrays      = args.slice(1);\n        }\n\n        if (!arrays.length) {\n            return true;\n        }\n\n        return arrays.every(function (array) {\n            if (array === target) {\n                return true;\n            } else if (array.length !== target.length) {\n                return false;\n            } else if (!keepOrder) {\n                return !_.difference(target, array).length;\n            }\n\n            return array.every(function (value, index) {\n                return target[index] === value;\n            });\n        });\n    }\n\n    /**\n     * Checks if two values are different.\n     *\n     * @param {*} a - First value.\n     * @param {*} b - Second value.\n     * @returns {Boolean}\n     */\n    function isDifferent(a, b) {\n        var oldIsPrimitive = utils.isPrimitive(a);\n\n        if (Array.isArray(a) && Array.isArray(b)) {\n            return !equalArrays(true, a, b);\n        }\n\n        return oldIsPrimitive ? a !== b : true;\n    }\n\n    /**\n     * @param {String} prefix\n     * @param {String} part\n     */\n    function getPath(prefix, part) {\n        return prefix ? prefix + '.' + part : part;\n    }\n\n    /**\n     * Checks if object has own specified property.\n     *\n     * @param {*} obj - Value to be checked.\n     * @param {String} key - Key of the property.\n     * @returns {Boolean}\n     */\n    function hasOwn(obj, key) {\n        return Object.prototype.hasOwnProperty.call(obj, key);\n    }\n\n    /**\n     * @param {Array} changes\n     */\n    function getContainers(changes) {\n        var containers  = {},\n            indexed     = _.indexBy(changes, 'path');\n\n        _.each(indexed, function (change, name) {\n            var path;\n\n            name.split('.').forEach(function (part) {\n                path = getPath(path, part);\n\n                if (path in indexed) {\n                    return;\n                }\n\n                (containers[path] = containers[path] || []).push(change);\n            });\n        });\n\n        return containers;\n    }\n\n    /**\n     * @param {String} path\n     * @param {String} name\n     * @param {String} type\n     * @param {String} newValue\n     * @param {String} oldValue\n     */\n    function addChange(path, name, type, newValue, oldValue) {\n        var data;\n\n        data = {\n            path: path,\n            name: name,\n            type: type\n        };\n\n        if (type !== 'remove') {\n            data.value = newValue;\n            data.oldValue = oldValue;\n        } else {\n            data.oldValue = newValue;\n        }\n\n        result.push(data);\n    }\n\n    /**\n     * @param {String} ns\n     * @param {String} name\n     * @param {String} type\n     * @param {String} iterator\n     * @param {String} placeholder\n     */\n    function setAll(ns, name, type, iterator, placeholder) {\n        var key;\n\n        if (arguments.length > 4) {\n            type === 'add' ?\n                addChange(ns, name, 'update', iterator, placeholder) :\n                addChange(ns, name, 'update', placeholder, iterator);\n        } else {\n            addChange(ns, name, type, iterator);\n        }\n\n        if (!utils.isObject(iterator)) {\n            return;\n        }\n\n        for (key in iterator) {\n            if (hasOwn(iterator, key)) {\n                setAll(getPath(ns, key), key, type, iterator[key]);\n            }\n        }\n    }\n\n    /*eslint-disable max-depth*/\n    /**\n     * @param {Object} old\n     * @param {Object} current\n     * @param {String} ns\n     * @param {String} name\n     */\n    function compare(old, current, ns, name) {\n        var key,\n            oldIsObj = utils.isObject(old),\n            newIsObj = utils.isObject(current);\n\n        if (oldIsObj && newIsObj) {\n            for (key in old) {\n                if (hasOwn(old, key) && !hasOwn(current, key)) {\n                    setAll(getPath(ns, key), key, 'remove', old[key]);\n                }\n            }\n\n            for (key in current) {\n                if (hasOwn(current, key)) {\n                    hasOwn(old, key) ?\n                        compare(old[key], current[key], getPath(ns, key), key) :\n                        setAll(getPath(ns, key), key, 'add', current[key]);\n                }\n            }\n        } else if (oldIsObj) {\n            setAll(ns, name, 'remove', old, current);\n        } else if (newIsObj) {\n            setAll(ns, name, 'add', current, old);\n        } else if (isDifferent(old, current)) {\n            addChange(ns, name, 'update', current, old);\n        }\n    }\n\n    /*eslint-enable max-depth*/\n\n    return {\n\n        /**\n         *\n         * @returns {Object}\n         */\n        compare: function () {\n            var changes;\n\n            compare.apply(null, arguments);\n\n            changes = result.splice(0);\n\n            return {\n                containers: getContainers(changes),\n                changes: changes,\n                equal: !changes.length\n            };\n        },\n\n        equalArrays: equalArrays\n    };\n});\n","mage/utils/strings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var jsonRe = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/;\n\n    return {\n\n        /**\n         * Attempts to convert string to one of the primitive values,\n         * or to parse it as a valid json object.\n         *\n         * @param {String} str - String to be processed.\n         * @returns {*}\n         */\n        castString: function (str) {\n            try {\n                str = str === 'true' ? true :\n                    str === 'false' ? false :\n                        str === 'null' ? null :\n                            +str + '' === str ? +str :\n                                jsonRe.test(str) ? JSON.parse(str) :\n                                    str;\n            } catch (e) {\n            }\n\n            return str;\n        },\n\n        /**\n         * Splits string by separator if it's possible,\n         * otherwise returns the incoming value.\n         *\n         * @param {(String|Array|*)} str - String to split.\n         * @param {String} [separator=' '] - Seperator based on which to split the string.\n         * @returns {Array|*} Splitted string or the incoming value.\n         */\n        stringToArray: function (str, separator) {\n            separator = separator || ' ';\n\n            return typeof str === 'string' ?\n                str.split(separator) :\n                str;\n        },\n\n        /**\n         * Converts the incoming string which consists\n         * of a specified delimiters into a format commonly used in form elements.\n         *\n         * @param {String} name - The incoming string.\n         * @param {String} [separator='.']\n         * @returns {String} Serialized string.\n         *\n         * @example\n         *      utils.serializeName('one.two.three');\n         *      => 'one[two][three]';\n         */\n        serializeName: function (name, separator) {\n            var result;\n\n            separator = separator || '.';\n            name = name.split(separator);\n\n            result = name.shift();\n\n            name.forEach(function (part) {\n                result += '[' + part + ']';\n            });\n\n            return result;\n        },\n\n        /**\n         * Checks wether the incoming value is not empty,\n         * e.g. not 'null' or 'undefined'\n         *\n         * @param {*} value - Value to check.\n         * @returns {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || _.isUndefined(value) || _.isNull(value);\n        },\n\n        /**\n         * Adds 'prefix' to the 'part' value if it was provided.\n         *\n         * @param {String} prefix\n         * @param {String} part\n         * @returns {String}\n         */\n        fullPath: function (prefix, part) {\n            return prefix ? prefix + '.' + part : part;\n        },\n\n        /**\n         * Splits incoming string and returns its' part specified by offset.\n         *\n         * @param {String} parts\n         * @param {Number} [offset]\n         * @param {String} [delimiter=.]\n         * @returns {String}\n         */\n        getPart: function (parts, offset, delimiter) {\n            delimiter = delimiter || '.';\n            parts = parts.split(delimiter);\n            offset = this.formatOffset(parts, offset);\n\n            parts.splice(offset, 1);\n\n            return parts.join(delimiter) || '';\n        },\n\n        /**\n         * Converts nameThroughCamelCase to name-through-minus\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        camelCaseToMinus: function camelCaseToMinus(string) {\n            return ('' + string)\n                .split('')\n                .map(function (symbol, index) {\n                    return index ?\n                        symbol.toUpperCase() === symbol ?\n                        '-' + symbol.toLowerCase() :\n                            symbol :\n                        symbol.toLowerCase();\n                })\n                .join('');\n        },\n\n        /**\n         * Converts name-through-minus to nameThroughCamelCase\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        minusToCamelCase: function minusToCamelCase(string) {\n            return ('' + string)\n                .split('-')\n                .map(function (part, index) {\n                    return index ? part.charAt(0).toUpperCase() + part.slice(1) : part;\n                })\n                .join('');\n        }\n    };\n});\n","mage/utils/arrays.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './strings'\n], function (_, utils) {\n    'use strict';\n\n    /**\n     * Defines index of an item in a specified container.\n     *\n     * @param {*} item - Item whose index should be defined.\n     * @param {Array} container - Container upon which to perform search.\n     * @returns {Number}\n     */\n    function getIndex(item, container) {\n        var index = container.indexOf(item);\n\n        if (~index) {\n            return index;\n        }\n\n        return _.findIndex(container, function (value) {\n            return value && value.name === item;\n        });\n    }\n\n    return {\n        /**\n         * Facade method to remove/add value from/to array\n         * without creating a new instance.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to add/remove.\n         * @param {Boolean} add - Flag that specfies operation.\n         * @returns {Utils} Chainable.\n         */\n        toggle: function (arr, value, add) {\n            return add ?\n                this.add(arr, value) :\n                this.remove(arr, value);\n        },\n\n        /**\n         * Removes the incoming value from array in case\n         * without creating a new instance of it.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to be removed.\n         * @returns {Utils} Chainable.\n         */\n        remove: function (arr, value) {\n            var index = arr.indexOf(value);\n\n            if (~index) {\n                arr.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds the incoming value to array if\n         * it's not alredy present in there.\n         *\n         * @param {Array} arr - Array to be modifed.\n         * @param {...*} arguments - Values to be added.\n         * @returns {Utils} Chainable.\n         */\n        add: function (arr) {\n            var values = _.toArray(arguments).slice(1);\n\n            values.forEach(function (value) {\n                if (!~arr.indexOf(value)) {\n                    arr.push(value);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Inserts specified item into container at a specified position.\n         *\n         * @param {*} item - Item to be inserted into container.\n         * @param {Array} container - Container of items.\n         * @param {*} [position=-1] - Position at which item should be inserted.\n         *      Position can represent:\n         *          - specific index in container\n         *          - item which might already be present in container\n         *          - structure with one of these properties: after, before\n         * @returns {Boolean|*}\n         *      - true if element has changed its' position\n         *      - false if nothing has changed\n         *      - inserted value if it wasn't present in container\n         */\n        insert: function (item, container, position) {\n            var currentIndex = getIndex(item, container),\n                newIndex,\n                target;\n\n            if (typeof position === 'undefined') {\n                position = -1;\n            } else if (typeof position === 'string') {\n                position = isNaN(+position) ? position : +position;\n            }\n\n            newIndex = position;\n\n            if (~currentIndex) {\n                target = container.splice(currentIndex, 1)[0];\n\n                if (typeof item === 'string') {\n                    item = target;\n                }\n            }\n\n            if (typeof position !== 'number') {\n                target = position.after || position.before || position;\n\n                newIndex = getIndex(target, container);\n\n                if (~newIndex && (position.after || newIndex >= currentIndex)) {\n                    newIndex++;\n                }\n            }\n\n            if (newIndex < 0) {\n                newIndex += container.length + 1;\n            }\n\n            container[newIndex] ?\n                container.splice(newIndex, 0, item) :\n                container[newIndex] = item;\n\n            return !~currentIndex ? item : currentIndex !== newIndex;\n        },\n\n        /**\n         * @param {Array} elems\n         * @param {Number} offset\n         * @return {Number|*}\n         */\n        formatOffset: function (elems, offset) {\n            if (utils.isEmpty(offset)) {\n                offset = -1;\n            }\n\n            offset = +offset;\n\n            if (offset < 0) {\n                offset += elems.length + 1;\n            }\n\n            return offset;\n        }\n    };\n});\n","mage/utils/wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Utility methods used to wrap and extend functions.\n *\n * @example Usage of a 'wrap' method with arguments delegation.\n *      var multiply = function (a, b) {\n *          return a * b;\n *      };\n *\n *      multiply = module.wrap(multiply, function (orig) {\n *          return 'Result is: ' + orig();\n *      });\n *\n *      multiply(2, 2);\n *      => 'Result is: 4'\n *\n * @example Usage of 'wrapSuper' method.\n *      var multiply = function (a, b) {\n *         return a * b;\n *      };\n *\n *      var obj = {\n *          multiply: module.wrapSuper(multiply, function () {\n *              return 'Result is: ' + this._super();\n *          });\n *      };\n *\n *      obj.multiply(2, 2);\n *      => 'Result is: 4'\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Checks if string has a '_super' substring.\n     */\n    var superReg = /\\b_super\\b/;\n\n    return {\n\n        /**\n         * Wraps target function with a specified wrapper, which will receive\n         * reference to the original function as a first argument.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapper function.\n         */\n        wrap: function (target, wrapper) {\n            if (!_.isFunction(target) || !_.isFunction(wrapper)) {\n                return wrapper;\n            }\n\n            return function () {\n                var args    = _.toArray(arguments),\n                    ctx     = this,\n                    _super;\n\n                /**\n                 * Function that will be passed to the wrapper.\n                 * If no arguments will be passed to it, then the original\n                 * function will be called with an arguments of a wrapper function.\n                 */\n                _super = function () {\n                    var superArgs = arguments.length ? arguments : args.slice(1);\n\n                    return target.apply(ctx, superArgs);\n                };\n\n                args.unshift(_super);\n\n                return wrapper.apply(ctx, args);\n            };\n        },\n\n        /**\n         * Wraps the incoming function to implement support of the '_super' method.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapped function.\n         */\n        wrapSuper: function (target, wrapper) {\n            if (!this.hasSuper(wrapper) || !_.isFunction(target)) {\n                return wrapper;\n            }\n\n            return function () {\n                var _super  = this._super,\n                    args    = arguments,\n                    result;\n\n                /**\n                 * Temporary define '_super' method which\n                 * contains call to the original function.\n                 */\n                this._super = function () {\n                    var superArgs = arguments.length ? arguments : args;\n\n                    return target.apply(this, superArgs);\n                };\n\n                result = wrapper.apply(this, args);\n\n                this._super = _super;\n\n                return result;\n            };\n        },\n\n        /**\n         * Checks wether the incoming method contains calls of the '_super' method.\n         *\n         * @param {Function} fn - Function to be checked.\n         * @returns {Boolean}\n         */\n        hasSuper: function (fn) {\n            return _.isFunction(fn) && superReg.test(fn);\n        },\n\n        /**\n         * Extends target object with provided extenders.\n         * If property in target and extender objects is a function,\n         * then it will be wrapped using 'wrap' method.\n         *\n         * @param {Object} target - Object to be extended.\n         * @param {...Object} extenders - Multiple extenders objects.\n         * @returns {Object} Modified target object.\n         */\n        extend: function (target) {\n            var extenders = _.toArray(arguments).slice(1),\n                iterator = this._extend.bind(this, target);\n\n            extenders.forEach(iterator);\n\n            return target;\n        },\n\n        /**\n         * Same as the 'extend' method, but operates only on one extender object.\n         *\n         * @private\n         * @param {Object} target\n         * @param {Object} extender\n         */\n        _extend: function (target, extender) {\n            _.each(extender, function (value, key) {\n                target[key] = this.wrap(target[key], extender[key]);\n            }, this);\n        }\n    };\n});\n","mage/utils/template.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-shadow */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/utils/objects',\n    'mage/utils/strings'\n], function ($, _, utils, stringUtils) {\n    'use strict';\n\n    var tmplSettings = _.templateSettings,\n        interpolate = /\\$\\{([\\s\\S]+?)\\}/g,\n        opener = '${',\n        template,\n        hasStringTmpls;\n\n    /**\n     * Identifies whether ES6 templates are supported.\n     */\n    hasStringTmpls = (function () {\n        var testString = 'var foo = \"bar\"; return `${ foo }` === foo';\n\n        try {\n            return Function(testString)();\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    /**\n     * Objects can specify how to use templating for their properties - getting that configuration.\n     *\n     * To disable rendering for all properties of your object add __disableTmpl: true.\n     * To disable for specific property add __disableTmpl: {propertyName: true}.\n     * To limit recursion for a specific property add __disableTmpl: {propertyName: numberOfCycles}.\n     *\n     * @param {String} tmpl\n     * @param {Object | undefined} target\n     * @returns {Boolean|Object}\n     */\n    function isTmplIgnored(tmpl, target) {\n        var parsedTmpl;\n\n        try {\n            parsedTmpl = JSON.parse(tmpl);\n\n            if (typeof parsedTmpl === 'object') {\n                return tmpl.includes('__disableTmpl');\n            }\n        } catch (e) {\n        }\n\n        if (typeof target !== 'undefined') {\n            if (typeof target === 'object' && target.hasOwnProperty('__disableTmpl')) {\n                return target.__disableTmpl;\n            }\n        }\n\n        return false;\n\n    }\n\n    if (hasStringTmpls) {\n\n        /*eslint-disable no-unused-vars, no-eval*/\n        /**\n         * Evaluates template string using ES6 templates.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} $ - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, $) {\n            return eval('`' + tmpl + '`');\n        };\n\n        /*eslint-enable no-unused-vars, no-eval*/\n    } else {\n\n        /**\n         * Fallback function used when ES6 templates are not supported.\n         * Uses underscore templates renderer.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} data - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, data) {\n            var cached = tmplSettings.interpolate;\n\n            tmplSettings.interpolate = interpolate;\n\n            tmpl = _.template(tmpl, {\n                variable: '$'\n            })(data);\n\n            tmplSettings.interpolate = cached;\n\n            return tmpl;\n        };\n    }\n\n    /**\n     * Checks if provided value contains template syntax.\n     *\n     * @param {*} value - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isTemplate(value) {\n        return typeof value === 'string' &&\n            value.indexOf(opener) !== -1 &&\n            // the below pattern almost always indicates an accident which should not cause template evaluation\n            // refuse to evaluate\n            value.indexOf('${{') === -1;\n    }\n\n    /**\n     * Iteratively processes provided string\n     * until no templates syntax will be found.\n     *\n     * @param {String} tmpl - Template string.\n     * @param {Object} data - Data object used in a template.\n     * @param {Boolean} [castString=false] - Flag that indicates whether template\n     *      should be casted after evaluation to a value of another type or\n     *      that it should be leaved as a string.\n     * @param {Number|undefined} maxCycles - Maximum number of rendering cycles, can be 0.\n     * @returns {*} Compiled template.\n     */\n    function render(tmpl, data, castString, maxCycles) {\n        var last = tmpl,\n            cycles = 0;\n\n        while (~tmpl.indexOf(opener) && (typeof maxCycles === 'undefined' || cycles < maxCycles)) {\n            if (!isTmplIgnored(tmpl)) {\n                tmpl = template(tmpl, data);\n            }\n\n            if (tmpl === last) {\n                break;\n            }\n\n            last = tmpl;\n            cycles++;\n        }\n\n        return castString ?\n            stringUtils.castString(tmpl) :\n            tmpl;\n    }\n\n    return {\n\n        /**\n         * Applies provided data to the template.\n         *\n         * @param {Object|String} tmpl\n         * @param {Object} [data] - Data object to match with template.\n         * @param {Boolean} [castString=false] - Flag that indicates whether template\n         *      should be casted after evaluation to a value of another type or\n         *      that it should be leaved as a string.\n         * @returns {*}\n         *\n         * @example Template defined as a string.\n         *      var source = { foo: 'Random Stuff', bar: 'Some' };\n         *\n         *      utils.template('${ $.bar } ${ $.foo }', source);\n         *      => 'Some Random Stuff';\n         *\n         * @example Template defined as an object.\n         *      var tmpl = {\n         *              key: {'${ $.$data.bar }': '${ $.$data.foo }'},\n         *              foo: 'bar',\n         *              x1: 2, x2: 5,\n         *              delta: '${ $.x2 - $.x1 }',\n         *              baz: 'Upper ${ $.foo.toUpperCase() }'\n         *      };\n         *\n         *      utils.template(tmpl, source);\n         *      => {\n         *          key: {'Some': 'Random Stuff'},\n         *          foo: 'bar',\n         *          x1: 2, x2: 5,\n         *          delta: 3,\n         *          baz: 'Upper BAR'\n         *      };\n         */\n        template: function (tmpl, data, castString, dontClone) {\n            if (typeof tmpl === 'string') {\n                return render(tmpl, data, castString);\n            }\n\n            if (!dontClone) {\n                tmpl = utils.copy(tmpl);\n            }\n\n            tmpl.$data = data || {};\n\n            /**\n             * Template iterator function.\n             */\n            _.each(tmpl, function iterate(value, key, list) {\n                var disabled,\n                    maxCycles;\n\n                if (key === '$data') {\n                    return;\n                }\n\n                if (isTemplate(key)) {\n                    delete list[key];\n\n                    key = render(key, tmpl);\n                    list[key] = value;\n                }\n\n                if (isTemplate(value)) {\n                    //Getting template disabling settings, can be true for all disabled and separate settings\n                    //for each property.\n                    disabled = isTmplIgnored(value, list);\n\n                    if (typeof disabled === 'object' && disabled.hasOwnProperty(key) && disabled[key] !== false) {\n                        //Checking if specific settings for a property provided.\n                        maxCycles = disabled[key];\n                    }\n\n                    if (disabled === true || maxCycles === true) {\n                        //Rendering for all properties is disabled.\n                        maxCycles = 0;\n                    }\n\n                    list[key] = render(value, tmpl, castString, maxCycles);\n                } else if ($.isPlainObject(value) || Array.isArray(value)) {\n                    _.each(value, iterate);\n                }\n            });\n\n            delete tmpl.$data;\n\n            return tmpl;\n        }\n    };\n});\n","mage/utils/misc.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mage/utils/objects'\n], function (_, $, utils) {\n    'use strict';\n\n    var defaultAttributes,\n        ajaxSettings,\n        map;\n\n    defaultAttributes = {\n        method: 'post',\n        enctype: 'multipart/form-data'\n    };\n\n    ajaxSettings = {\n        default: {\n            method: 'POST',\n            cache: false,\n            processData: false,\n            contentType: false\n        },\n        simple: {\n            method: 'POST',\n            dataType: 'json'\n        }\n    };\n\n    map = {\n        'D': 'DDD',\n        'dd': 'DD',\n        'd': 'D',\n        'EEEE': 'dddd',\n        'EEE': 'ddd',\n        'e': 'd',\n        'yyyy': 'YYYY',\n        'yy': 'YY',\n        'y': 'YYYY',\n        'a': 'A'\n    };\n\n    return {\n\n        /**\n         * Generates a unique identifier.\n         *\n         * @param {Number} [size=7] - Length of a resulting identifier.\n         * @returns {String}\n         */\n        uniqueid: function (size) {\n            var code = Math.random() * 25 + 65 | 0,\n                idstr = String.fromCharCode(code);\n\n            size = size || 7;\n\n            while (idstr.length < size) {\n                code = Math.floor(Math.random() * 42 + 48);\n\n                if (code < 58 || code > 64) {\n                    idstr += String.fromCharCode(code);\n                }\n            }\n\n            return idstr;\n        },\n\n        /**\n         * Limits function call.\n         *\n         * @param {Object} owner\n         * @param {String} target\n         * @param {Number} limit\n         */\n        limit: function (owner, target, limit) {\n            var fn = owner[target];\n\n            owner[target] = _.debounce(fn.bind(owner), limit);\n        },\n\n        /**\n         * Converts mage date format to a moment.js format.\n         *\n         * @param {String} mageFormat\n         * @returns {String}\n         */\n        normalizeDate: function (mageFormat) {\n            var result = mageFormat;\n\n            _.each(map, function (moment, mage) {\n                result = result.replace(\n                    new RegExp(mage + '(?=([^\\u0027]*\\u0027[^\\u0027]*\\u0027)*[^\\u0027]*$)'),\n                    moment\n                );\n            });\n            result = result.replace(/'(.*?)'/g, '[$1]');\n            return result;\n        },\n\n        /**\n         * Puts provided value in range of min and max parameters.\n         *\n         * @param {Number} value - Value to be located.\n         * @param {Number} min - Min value.\n         * @param {Number} max - Max value.\n         * @returns {Number}\n         */\n        inRange: function (value, min, max) {\n            return Math.min(Math.max(min, value), max);\n        },\n\n        /**\n         * Serializes and sends data via POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} attrs - Attributes that will be added to virtual form.\n         */\n        submit: function (options, attrs) {\n            var form        = document.createElement('form'),\n                data        = utils.serialize(options.data),\n                attributes  = _.extend({}, defaultAttributes, attrs || {});\n\n            if (!attributes.action) {\n                attributes.action = options.url;\n            }\n\n            data['form_key'] = window.FORM_KEY;\n\n            _.each(attributes, function (value, name) {\n                form.setAttribute(name, value);\n            });\n\n            data = _.map(\n                data,\n                function (value, name) {\n                    return '<input type=\"hidden\" ' +\n                        'name=\"' + _.escape(name) + '\" ' +\n                        'value=\"' + _.escape(value) + '\"' +\n                        ' />';\n                }\n            ).join('');\n\n            form.insertAdjacentHTML('afterbegin', data);\n            document.body.appendChild(form);\n\n            form.submit();\n        },\n\n        /**\n         * Serializes and sends data via AJAX POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} config\n         */\n        ajaxSubmit: function (options, config) {\n            var t = new Date().getTime(),\n                settings;\n\n            options.data['form_key'] = window.FORM_KEY;\n            options.data = this.prepareFormData(options.data, config.ajaxSaveType);\n            settings = _.extend({}, ajaxSettings[config.ajaxSaveType], options || {});\n\n            if (!config.ignoreProcessEvents) {\n                $('body').trigger('processStart');\n            }\n\n            return $.ajax(settings)\n                .done(function (data) {\n                    if (config.response) {\n                        data.t = t;\n                        config.response.data(data);\n                        config.response.status(undefined);\n                        config.response.status(!data.error);\n                    }\n                })\n                .fail(function () {\n                    if (config.response) {\n                        config.response.status(undefined);\n                        config.response.status(false);\n                        config.response.data({\n                            error: true,\n                            messages: 'Something went wrong.',\n                            t: t\n                        });\n                    }\n                })\n                .always(function () {\n                    if (!config.ignoreProcessEvents) {\n                        $('body').trigger('processStop');\n                    }\n                });\n        },\n\n        /**\n         * Creates FormData object and append this data.\n         *\n         * @param {Object} data\n         * @param {String} type\n         * @returns {FormData}\n         */\n        prepareFormData: function (data, type) {\n            var formData;\n\n            if (type === 'default') {\n                formData = new FormData();\n                _.each(utils.serialize(data), function (val, name) {\n                    formData.append(name, val);\n                });\n            } else if (type === 'simple') {\n                formData = utils.serialize(data);\n            }\n\n            return formData;\n        },\n\n        /**\n         * Filters data object. Finds properties with suffix\n         * and sets their values to properties with the same name without suffix.\n         *\n         * @param {Object} data - The data object that should be filtered\n         * @param {String} suffix - The string by which data object should be filtered\n         * @param {String} separator - The string that is separator between property and suffix\n         *\n         * @returns {Object} Filtered data object\n         */\n        filterFormData: function (data, suffix, separator) {\n            data = data || {};\n            suffix = suffix || 'prepared-for-send';\n            separator = separator || '-';\n\n            _.each(data, function (value, key) {\n                if (_.isObject(value) && !Array.isArray(value)) {\n                    this.filterFormData(value, suffix, separator);\n                } else if (_.isString(key) && ~key.indexOf(suffix)) {\n                    data[key.split(separator)[0]] = value;\n                    delete data[key];\n                }\n            }, this);\n\n            return data;\n        },\n\n        /**\n         * Replaces special characters with their corresponding HTML entities.\n         *\n         * @param {String} string - Text to escape.\n         * @returns {String} Escaped text.\n         */\n        escape: function (string) {\n            return string ? $('<p></p>').text(string).html().replace(/\"/g, '&quot;') : string;\n        },\n\n        /**\n         * Replaces symbol codes with their unescaped counterparts.\n         *\n         * @param {String} data\n         *\n         * @returns {String}\n         */\n        unescape: function (data) {\n            var unescaped = _.unescape(data),\n                mapCharacters = {\n                    '&#039;': '\\''\n                };\n\n            _.each(mapCharacters, function (value, key) {\n                unescaped = unescaped.replace(key, value);\n            });\n\n            return unescaped;\n        },\n\n        /**\n         * Converts PHP IntlFormatter format to moment format.\n         *\n         * @param {String} format - PHP format\n         * @returns {String} - moment compatible formatting\n         */\n        convertToMomentFormat: function (format) {\n            var newFormat;\n\n            newFormat = format.replace(/yyyy|yy|y/, 'YYYY'); // replace the year\n            newFormat = newFormat.replace(/dd|d/g, 'DD'); // replace the date\n\n            return newFormat;\n        },\n\n        /**\n         * Get Url Parameters.\n         *\n         * @param {String} url - Url string\n         * @returns {Object}\n         */\n        getUrlParameters: function (url) {\n            var params = {},\n                queries = url.split('?'),\n                temp,\n                i,\n                l;\n\n            if (!queries[1]) {\n                return params;\n            }\n\n            queries = queries[1].split('&');\n\n            for (i = 0, l = queries.length; i < l; i++) {\n                temp = queries[i].split('=');\n\n                if (temp[1]) {\n                    params[temp[0]] = decodeURIComponent(temp[1].replace(/\\+/g, '%20'));\n                } else {\n                    params[temp[0]] = '';\n                }\n            }\n\n            return params;\n        }\n    };\n});\n","mage/backend/suggest.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/mage',\n    'jquery/ui',\n    'mage/backend/menu',\n    'mage/translate'\n], function ($, mageTemplate) {\n    'use strict';\n\n    /**\n     * Implement base functionality\n     */\n    $.widget('mage.suggest', {\n        widgetEventPrefix: 'suggest',\n        options: {\n            template: '<% if (data.items.length) { %>' +\n                '<% if (!data.term && !data.allShown() && data.recentShown()) { %>' +\n                '<h5 class=\"title\"><%- data.recentTitle %></h5>' +\n                '<% } %>' +\n                '<ul data-mage-init=\\'{\"menu\":[]}\\'>' +\n                '<% _.each(data.items, function(value){ %>' +\n                '<% if (!data.itemSelected(value)) { %><li <%= data.optionData(value) %>>' +\n                '<a href=\"#\"><%- value.label %></a></li><% } %>' +\n                '<% }); %>' +\n                '<% if (!data.term && !data.allShown() && data.recentShown()) { %>' +\n                '<li data-mage-init=\\'{\"actionLink\":{\"event\":\"showAll\"}}\\' class=\"show-all\">' +\n                '<a href=\"#\"><%- data.showAllTitle %></a></li>' +\n                '<% } %>' +\n                '</ul><% } else { %><span class=\"mage-suggest-no-records\"><%- data.noRecordsText %></span><% } %>',\n            minLength: 1,\n\n            /**\n             * @type {(String|Array)}\n             */\n            source: null,\n            delay: 500,\n            loadingClass: 'mage-suggest-state-loading',\n            events: {},\n            appendMethod: 'after',\n            controls: {\n                selector: ':ui-menu, :mage-menu',\n                eventsMap: {\n                    focus: ['menufocus'],\n                    blur: ['menublur'],\n                    select: ['menuselect']\n                }\n            },\n            termAjaxArgument: 'label_part',\n            filterProperty: 'label',\n            className: null,\n            inputWrapper: '<div class=\"mage-suggest\"><div class=\"mage-suggest-inner\"></div></div>',\n            dropdownWrapper: '<div class=\"mage-suggest-dropdown\"></div>',\n            preventClickPropagation: true,\n            currentlySelected: null,\n            submitInputOnEnter: true\n        },\n\n        /**\n         * Component's constructor\n         * @private\n         */\n        _create: function () {\n            this._term = null;\n            this._nonSelectedItem = {\n                id: '',\n                label: ''\n            };\n            this.templates = {};\n            this._renderedContext = null;\n            this._selectedItem = this._nonSelectedItem;\n            this._control = this.options.controls || {};\n            this._setTemplate();\n            this._prepareValueField();\n            this._render();\n            this._bind();\n        },\n\n        /**\n         * Render base elements for suggest component\n         * @private\n         */\n        _render: function () {\n            var wrapper;\n\n            this.dropdown = $(this.options.dropdownWrapper).hide();\n            wrapper = this.options.className ?\n                $(this.options.inputWrapper).addClass(this.options.className) :\n                $(this.options.inputWrapper);\n            this.element\n                .wrap(wrapper)[this.options.appendMethod](this.dropdown)\n                .attr('autocomplete', 'off');\n        },\n\n        /**\n         * Define a field for storing item id (find in DOM or create a new one)\n         * @private\n         */\n        _prepareValueField: function () {\n            if (this.options.valueField) {\n                this.valueField = $(this.options.valueField);\n            } else {\n                this.valueField = this._createValueField()\n                    .insertBefore(this.element)\n                    .attr('name', this.element.attr('name'));\n                this.element.removeAttr('name');\n            }\n        },\n\n        /**\n         * Create value field which keeps a id for selected option\n         * can be overridden in descendants\n         * @return {jQuery}\n         * @private\n         */\n        _createValueField: function () {\n            return $('<input/>', {\n                type: 'hidden'\n            });\n        },\n\n        /**\n         * Component's destructor\n         * @private\n         */\n        _destroy: function () {\n            this.element\n                .unwrap()\n                .removeAttr('autocomplete');\n\n            if (!this.options.valueField) {\n                this.element.attr('name', this.valueField.attr('name'));\n                this.valueField.remove();\n            }\n\n            this.dropdown.remove();\n            this._off(this.element, 'keydown keyup blur');\n        },\n\n        /**\n         * Return actual value of an \"input\"-element\n         * @return {String}\n         * @private\n         */\n        _value: function () {\n            return this.element[this.element.is(':input') ? 'val' : 'text']().trim();\n        },\n\n        /**\n         * Pass original event to a control component for handling it as it's own event\n         * @param {Object} event - event object\n         * @private\n         */\n        _proxyEvents: function (event) {\n            var fakeEvent = $.extend({}, $.Event(event.type), {\n                    ctrlKey: event.ctrlKey,\n                    keyCode: event.keyCode,\n                    which: event.keyCode\n                }),\n                target = this._control.selector ? this.dropdown.find(this._control.selector) : this.dropdown;\n\n            target.trigger(fakeEvent);\n        },\n\n        /**\n         * Bind handlers on specific events\n         * @private\n         */\n        _bind: function () {\n            this._on($.extend({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keydown: function (event) {\n                    var keyCode = $.ui.keyCode,\n                        suggestList,\n                        hasSuggestedItems,\n                        hasSelectedItems,\n                        selectedItem;\n\n                    switch (event.keyCode) {\n                        case keyCode.PAGE_UP:\n                        case keyCode.UP:\n                            if (!event.shiftKey) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n\n                            suggestList = event.currentTarget.parentNode.getElementsByTagName('ul')[0];\n                            hasSuggestedItems = event.currentTarget\n                                    .parentNode.getElementsByTagName('ul')[0].children.length >= 0;\n\n                            if (hasSuggestedItems) {\n                                selectedItem =  $(suggestList.getElementsByClassName('_active')[0])\n                                    .removeClass('_active').prev().addClass('_active');\n                                event.currentTarget.value = selectedItem.find('a').text();\n                            }\n\n                            break;\n\n                        case keyCode.PAGE_DOWN:\n                        case keyCode.DOWN:\n                            if (!event.shiftKey) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n\n                            suggestList = event.currentTarget.parentNode.getElementsByTagName('ul')[0];\n                            hasSuggestedItems = event.currentTarget\n                                .parentNode.getElementsByTagName('ul')[0].children.length >= 0;\n\n                            if (hasSuggestedItems) {\n                                hasSelectedItems = suggestList.getElementsByClassName('_active').length === 0;\n\n                                if (hasSelectedItems) { //eslint-disable-line max-depth\n                                    selectedItem = $(suggestList.children[0]).addClass('_active');\n                                    event.currentTarget.value = selectedItem.find('a').text();\n                                } else {\n                                    selectedItem = $(suggestList.getElementsByClassName('_active')[0])\n                                        .removeClass('_active').next().addClass('_active');\n                                    event.currentTarget.value = selectedItem.find('a').text();\n                                }\n                            }\n                            break;\n\n                        case keyCode.TAB:\n                            if (this.isDropdownShown()) {\n                                this._onSelectItem(event, null);\n                                event.preventDefault();\n                            }\n                            break;\n\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._toggleEnter(event);\n\n                            if (this.isDropdownShown() && this._focused) {\n                                this._proxyEvents(event);\n                                event.preventDefault();\n                            }\n                            break;\n\n                        case keyCode.ESCAPE:\n                            if (this.isDropdownShown()) {\n                                event.stopPropagation();\n                            }\n                            this.close(event);\n                            this._blurItem();\n                            break;\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keyup: function (event) {\n                    var keyCode = $.ui.keyCode;\n\n                    switch (event.keyCode) {\n                        case keyCode.HOME:\n                        case keyCode.END:\n                        case keyCode.PAGE_UP:\n                        case keyCode.PAGE_DOWN:\n                        case keyCode.ESCAPE:\n                        case keyCode.UP:\n                        case keyCode.DOWN:\n                        case keyCode.LEFT:\n                        case keyCode.RIGHT:\n                        case keyCode.TAB:\n                            break;\n\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            if (this.isDropdownShown()) {\n                                event.preventDefault();\n                            }\n                            break;\n                        default:\n                            this.search(event);\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                blur: function (event) {\n                    if (!this.preventBlur) {\n                        this._abortSearch();\n                        this.close(event);\n                        this._change(event);\n                    } else {\n                        this.element.trigger('focus');\n                    }\n                },\n                cut: this.search,\n                paste: this.search,\n                input: this.search,\n                selectItem: this._onSelectItem,\n                click: this.search\n            }, this.options.events));\n\n            this._bindSubmit();\n            this._bindDropdown();\n        },\n\n        /**\n         * @param {Object} event\n         * @private\n         */\n        _toggleEnter: function (event) {\n            var suggestList,\n                activeItems,\n                selectedItem;\n\n            if (!this.options.submitInputOnEnter) {\n                event.preventDefault();\n            }\n\n            suggestList = $(event.currentTarget.parentNode).find('ul').first();\n            activeItems = suggestList.find('._active');\n\n            if (activeItems.length >= 0) {\n                selectedItem = activeItems.first();\n\n                if (selectedItem.find('a') && selectedItem.find('a').attr('href') !== undefined) {\n                    window.location = selectedItem.find('a').attr('href');\n                    event.preventDefault();\n                }\n            }\n        },\n\n        /**\n         * Bind handlers for submit on enter\n         * @private\n         */\n        _bindSubmit: function () {\n            this.element.parents('form').on('submit', function (event) {\n                if (!this.submitInputOnEnter) {\n                    event.preventDefault();\n                }\n            });\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @private\n         */\n        _change: function (e) {\n            if (this._term !== this._value()) {\n                this._trigger('change', e);\n            }\n        },\n\n        /**\n         * Bind handlers for dropdown element on specific events\n         * @private\n         */\n        _bindDropdown: function () {\n            var events = {\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                click: function (e) {\n                    // prevent default browser's behavior of changing location by anchor href\n                    e.preventDefault();\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mousedown: function (e) {\n                    e.preventDefault();\n                }\n            };\n\n            $.each(this._control.eventsMap, $.proxy(function (suggestEvent, controlEvents) {\n                $.each(controlEvents, $.proxy(function (i, handlerName) {\n                    switch (suggestEvent) {\n                        case 'select':\n                            events[handlerName] = this._onSelectItem;\n                            break;\n\n                        case 'focus':\n                            events[handlerName] = this._focusItem;\n                            break;\n\n                        case 'blur':\n                            events[handlerName] = this._blurItem;\n                            break;\n                    }\n                }, this));\n            }, this));\n\n            if (this.options.preventClickPropagation) {\n                this._on(this.dropdown, events);\n            }\n            // Fix for IE 8\n            this._on(this.dropdown, {\n                /**\n                 * Mousedown.\n                 */\n                mousedown: function () {\n                    this.preventBlur = true;\n                },\n\n                /**\n                 * Mouseup.\n                 */\n                mouseup: function () {\n                    this.preventBlur = false;\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        _trigger: function (type, event) {\n            var result = this._superApply(arguments);\n\n            if (result === false && event) {\n                event.stopImmediatePropagation();\n                event.preventDefault();\n            }\n\n            return result;\n        },\n\n        /**\n         * Handle focus event of options item\n         * @param {Object} e - event object\n         * @param {Object} ui - object that can contain information about focused item\n         * @private\n         */\n        _focusItem: function (e, ui) {\n            if (ui && ui.item) {\n                this._focused = $(ui.item).prop('tagName') ?\n                    this._readItemData(ui.item) :\n                    ui.item;\n\n                this.element.val(this._focused.label);\n                this._trigger('focus', e, {\n                    item: this._focused\n                });\n            }\n        },\n\n        /**\n         * Handle blur event of options item\n         * @private\n         */\n        _blurItem: function () {\n            this._focused = null;\n            this.element.val(this._term);\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @param {Object} item\n         * @private\n         */\n        _onSelectItem: function (e, item) {\n            if (item && typeof item === 'object' && $(e.target).is(this.element)) {\n                this._focusItem(e, {\n                    item: item\n                });\n            }\n\n            if (this._trigger('beforeselect', e || null, {\n                    item: this._focused\n                }) === false) {\n                return;\n            }\n            this._selectItem(e);\n            this._blurItem();\n            this._trigger('select', e || null, {\n                item: this._selectedItem\n            });\n        },\n\n        /**\n         * Save selected item and hide dropdown\n         * @private\n         * @param {Object} e - event object\n         */\n        _selectItem: function (e) {\n            if (this._focused) {\n                this._selectedItem = this._focused;\n\n                if (this._selectedItem !== this._nonSelectedItem) {\n                    this._term = this._selectedItem.label;\n                    this.valueField.val(this._selectedItem.id);\n                    this.close(e);\n                }\n            }\n        },\n\n        /**\n         * Read option data from item element\n         * @param {Element} element\n         * @return {Object}\n         * @private\n         */\n        _readItemData: function (element) {\n            return element.data('suggestOption') || this._nonSelectedItem;\n        },\n\n        /**\n         * Check if dropdown is shown\n         * @return {Boolean}\n         */\n        isDropdownShown: function () {\n            return this.dropdown.is(':visible');\n        },\n\n        /**\n         * Open dropdown\n         * @private\n         * @param {Object} e - event object\n         */\n        open: function (e) {\n            if (!this.isDropdownShown()) {\n                this.element.addClass('_suggest-dropdown-open');\n                this.dropdown.show();\n                this._trigger('open', e);\n            }\n        },\n\n        /**\n         * Close and clear dropdown content\n         * @private\n         * @param {Object} e - event object\n         */\n        close: function (e) {\n            this._renderedContext = null;\n\n            if (this.dropdown.length) {\n                this.element.removeClass('_suggest-dropdown-open');\n                this.dropdown.hide().empty();\n            }\n\n            this._trigger('close', e);\n        },\n\n        /**\n         * Acquire content template\n         * @private\n         */\n        _setTemplate: function () {\n            this.templateName = 'suggest' + Math.random().toString(36).substr(2);\n\n            this.templates[this.templateName] = mageTemplate(this.options.template);\n        },\n\n        /**\n         * Execute search process\n         * @public\n         * @param {Object} e - event object\n         */\n        search: function (e) {\n            var term = this._value();\n\n            if ((this._term !== term || term.length === 0) && !this.preventBlur) {\n                this._term = term;\n\n                if (typeof term === 'string' && term.length >= this.options.minLength) {\n                    if (this._trigger('search', e) === false) { //eslint-disable-line max-depth\n                        return;\n                    }\n                    this._search(e, term, {});\n                } else {\n                    this._selectedItem = this._nonSelectedItem;\n                    this._resetSuggestValue();\n                }\n            }\n        },\n\n        /**\n         * Clear suggest hidden input\n         * @private\n         */\n        _resetSuggestValue: function () {\n            this.valueField.val(this._nonSelectedItem.id);\n        },\n\n        /**\n         * Actual search method, can be overridden in descendants\n         * @param {Object} e - event object\n         * @param {String} term - search phrase\n         * @param {Object} context - search context\n         * @private\n         */\n        _search: function (e, term, context) {\n            var response = $.proxy(function (items) {\n                return this._processResponse(e, items, context || {});\n            }, this);\n\n            this.element.addClass(this.options.loadingClass);\n\n            if (this.options.delay) {\n                if (typeof this.options.data !== 'undefined') {\n                    response(this.filter(this.options.data, term));\n                }\n                clearTimeout(this._searchTimeout);\n                this._searchTimeout = this._delay(function () {\n                    this._source(term, response);\n                }, this.options.delay);\n            } else {\n                this._source(term, response);\n            }\n        },\n\n        /**\n         * Extend basic context with additional data (search results, search term)\n         * @param {Object} context\n         * @return {Object}\n         * @private\n         */\n        _prepareDropdownContext: function (context) {\n            return $.extend(context, {\n                items: this._items,\n                term: this._term,\n\n                /**\n                 * @param {Object} item\n                 * @return {String}\n                 */\n                optionData: function (item) {\n                    return 'data-suggest-option=\"' +\n                        $('<div>').text(JSON.stringify(item)).html().replace(/\"/g, '&quot;') + '\"';\n                },\n                itemSelected: $.proxy(this._isItemSelected, this),\n                noRecordsText: $.mage.__('No records found.')\n            });\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         * @private\n         */\n        _isItemSelected: function (item) {\n            return item.id == (this._selectedItem && this._selectedItem.id ? //eslint-disable-line eqeqeq\n                this._selectedItem.id :\n                this.options.currentlySelected);\n        },\n\n        /**\n         * Render content of suggest's dropdown\n         * @param {Object} e - event object\n         * @param {Array} items - list of label+id objects\n         * @param {Object} context - template's context\n         * @private\n         */\n        _renderDropdown: function (e, items, context) {\n            var tmpl = this.templates[this.templateName];\n\n            this._items = items;\n\n            tmpl = tmpl({\n                data: this._prepareDropdownContext(context)\n            });\n\n            $(tmpl).appendTo(this.dropdown.empty());\n\n            this.dropdown.trigger('contentUpdated')\n                .find(this._control.selector).on('focus', function (event) {\n                    event.preventDefault();\n                });\n\n            this._renderedContext = context;\n            this.element.removeClass(this.options.loadingClass);\n            this.open(e);\n        },\n\n        /**\n         * @param {Object} e\n         * @param {Object} items\n         * @param {Object} context\n         * @private\n         */\n        _processResponse: function (e, items, context) {\n            var renderer = $.proxy(function (i) {\n                return this._renderDropdown(e, i, context || {});\n            }, this);\n\n            if (this._trigger('response', e, [items, renderer]) === false) {\n                return;\n            }\n            this._renderDropdown(e, items, context);\n        },\n\n        /**\n         * Implement search process via spesific source\n         * @param {String} term - search phrase\n         * @param {Function} response - search results handler, process search result\n         * @private\n         */\n        _source: function (term, response) {\n            var o = this.options,\n                ajaxData;\n\n            if (Array.isArray(o.source)) {\n                response(this.filter(o.source, term));\n            } else if (typeof o.source === 'string') {\n                ajaxData = {};\n                ajaxData[this.options.termAjaxArgument] = term;\n\n                this._xhr = $.ajax($.extend(true, {\n                    url: o.source,\n                    type: 'POST',\n                    dataType: 'json',\n                    data: ajaxData,\n                    success: $.proxy(function (items) {\n                        this.options.data = items;\n                        response.apply(response, arguments);\n                    }, this)\n                }, o.ajaxOptions || {}));\n            } else if (typeof o.source === 'function') {\n                o.source.apply(o.source, arguments);\n            }\n        },\n\n        /**\n         * Abort search process\n         * @private\n         */\n        _abortSearch: function () {\n            this.element.removeClass(this.options.loadingClass);\n            clearTimeout(this._searchTimeout);\n        },\n\n        /**\n         * Perform filtering in advance loaded items and returns search result\n         * @param {Array} items - all available items\n         * @param {String} term - search phrase\n         * @return {Object}\n         */\n        filter: function (items, term) {\n            var matcher = new RegExp(term.replace(/[\\-\\/\\\\\\^$*+?.()|\\[\\]{}]/g, '\\\\$&'), 'i'),\n                itemsArray = Array.isArray(items) ? items : $.map(items, function (element) {\n                    return element;\n                }),\n                property = this.options.filterProperty;\n\n            return $.grep(\n                itemsArray,\n                function (value) {\n                    return matcher.test(value[property] || value.id || value);\n                }\n            );\n        }\n    });\n\n    /**\n     * Implement show all functionality and storing and display recent searches\n     */\n    $.widget('mage.suggest', $.mage.suggest, {\n        options: {\n            showRecent: false,\n            showAll: false,\n            storageKey: 'suggest',\n            storageLimit: 10\n        },\n\n        /**\n         * @override\n         */\n        _create: function () {\n            var recentItems;\n\n            if (this.options.showRecent && window.localStorage) {\n                recentItems = JSON.parse(localStorage.getItem(this.options.storageKey));\n\n                /**\n                 * @type {Array} - list of recently searched items\n                 * @private\n                 */\n                this._recentItems = Array.isArray(recentItems) ? recentItems : [];\n            }\n            this._super();\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n            this._on(this.dropdown, {\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                showAll: function (e) {\n                    e.stopImmediatePropagation();\n                    e.preventDefault();\n                    this.element.trigger('showAll');\n                }\n            });\n\n            if (this.options.showRecent || this.options.showAll) {\n                this._on({\n                    /**\n                     * @param {jQuery.Event} e\n                     */\n                    focus: function (e) {\n                        if (!this.isDropdownShown()) {\n                            this.search(e);\n                        }\n                    },\n                    showAll: this._showAll\n                });\n            }\n        },\n\n        /**\n         * @private\n         * @param {Object} e - event object\n         */\n        _showAll: function (e) {\n            this._abortSearch();\n            this._search(e, '', {\n                _allShown: true\n            });\n        },\n\n        /**\n         * @override\n         */\n        search: function (e) {\n            if (!this._value()) {\n\n                if (this.options.showRecent) {\n\n                    if (this._recentItems.length) { //eslint-disable-line max-depth\n                        this._processResponse(e, this._recentItems, {});\n                    } else {\n                        this._showAll(e);\n                    }\n                } else if (this.options.showAll) {\n                    this._showAll(e);\n                }\n            }\n            this._superApply(arguments);\n        },\n\n        /**\n         * @override\n         */\n        _selectItem: function () {\n            this._superApply(arguments);\n\n            if (this._selectedItem && this._selectedItem.id && this.options.showRecent) {\n                this._addRecent(this._selectedItem);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _prepareDropdownContext: function () {\n            var context = this._superApply(arguments);\n\n            return $.extend(context, {\n                recentShown: $.proxy(function () {\n                    return this.options.showRecent;\n                }, this),\n                recentTitle: $.mage.__('Recent items'),\n                showAllTitle: $.mage.__('Show all...'),\n\n                /**\n                 * @return {Boolean}\n                 */\n                allShown: function () {\n                    return !!context._allShown;\n                }\n            });\n        },\n\n        /**\n         * Add selected item of search result into storage of recents\n         * @param {Object} item - label+id object\n         * @private\n         */\n        _addRecent: function (item) {\n            this._recentItems = $.grep(this._recentItems, function (obj) {\n                return obj.id !== item.id;\n            });\n            this._recentItems.unshift(item);\n            this._recentItems = this._recentItems.slice(0, this.options.storageLimit);\n            localStorage.setItem(this.options.storageKey, JSON.stringify(this._recentItems));\n        }\n    });\n\n    /**\n     * Implement multi suggest functionality\n     */\n    $.widget('mage.suggest', $.mage.suggest, {\n        options: {\n            multiSuggestWrapper: '<ul class=\"mage-suggest-choices\">' +\n                '<li class=\"mage-suggest-search-field\" data-role=\"parent-choice-element\"><' +\n                'label class=\"mage-suggest-search-label\"></label></li></ul>',\n            choiceTemplate: '<li class=\"mage-suggest-choice button\"><div><%- text %></div>' +\n            '<span class=\"mage-suggest-choice-close\" tabindex=\"-1\" ' +\n            'data-mage-init=\\'{\"actionLink\":{\"event\":\"removeOption\"}}\\'></span></li>',\n            selectedClass: 'mage-suggest-selected'\n        },\n\n        /**\n         * @override\n         */\n        _create: function () {\n            this.choiceTmpl = mageTemplate(this.options.choiceTemplate);\n\n            this._super();\n\n            if (this.options.multiselect) {\n                this.valueField.hide();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _render: function () {\n            this._super();\n\n            if (this.options.multiselect) {\n                this._renderMultiselect();\n            }\n        },\n\n        /**\n         * Render selected options\n         * @private\n         */\n        _renderMultiselect: function () {\n            var that = this;\n\n            this.element.wrap(this.options.multiSuggestWrapper);\n            this.elementWrapper = this.element.closest('[data-role=\"parent-choice-element\"]');\n            $(function () {\n                that._getOptions()\n                    .each(function (i, option) {\n                        option = $(option);\n                        that._createOption({\n                            id: option.val(),\n                            label: option.text()\n                        });\n                    });\n            });\n        },\n\n        /**\n         * @return {Array} array of DOM-elements\n         * @private\n         */\n        _getOptions: function () {\n            return this.valueField.find('option');\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n\n            if (this.options.multiselect) {\n                this._on({\n                    /**\n                     * @param {jQuery.Event} event\n                     */\n                    keydown: function (event) {\n                        if (event.keyCode === $.ui.keyCode.BACKSPACE) {\n                            if (!this._value()) {\n                                this._removeLastAdded(event);\n                            }\n                        }\n                    },\n                    removeOption: this.removeOption\n                });\n            }\n        },\n\n        /**\n         * @param {Array} items\n         * @return {Array}\n         * @private\n         */\n        _filterSelected: function (items) {\n            var options = this._getOptions();\n\n            return $.grep(items, function (value) {\n                var itemSelected = false;\n\n                $.each(options, function () {\n                    if (value.id == $(this).val()) { //eslint-disable-line eqeqeq\n                        itemSelected = true;\n                    }\n                });\n\n                return !itemSelected;\n            });\n        },\n\n        /**\n         * @override\n         */\n        _processResponse: function (e, items, context) {\n            if (this.options.multiselect) {\n                items = this._filterSelected(items, context);\n            }\n            this._superApply([e, items, context]);\n        },\n\n        /**\n         * @override\n         */\n        _prepareValueField: function () {\n            this._super();\n\n            if (this.options.multiselect && !this.options.valueField && this.options.selectedItems) {\n                $.each(this.options.selectedItems, $.proxy(function (i, item) {\n                    this._addOption(item);\n                }, this));\n            }\n        },\n\n        /**\n         * If \"multiselect\" option is set, then do not need to clear value for hidden select, to avoid losing of\n         *      previously selected items\n         * @override\n         */\n        _resetSuggestValue: function () {\n            if (!this.options.multiselect) {\n                this._super();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _createValueField: function () {\n            if (this.options.multiselect) {\n                return $('<select></select>', {\n                    type: 'hidden',\n                    multiple: 'multiple'\n                });\n            }\n\n            return this._super();\n        },\n\n        /**\n         * @override\n         */\n        _selectItem: function (e) {\n            if (this.options.multiselect) {\n                if (this._focused) {\n                    this._selectedItem = this._focused;\n\n                    /* eslint-disable max-depth */\n                    if (this._selectedItem !== this._nonSelectedItem) {\n                        this._term = '';\n                        this.element.val(this._term);\n\n                        if (this._isItemSelected(this._selectedItem)) {\n                            $(e.target).removeClass(this.options.selectedClass);\n                            this.removeOption(e, this._selectedItem);\n                            this._selectedItem = this._nonSelectedItem;\n                        } else {\n                            $(e.target).addClass(this.options.selectedClass);\n                            this._addOption(e, this._selectedItem);\n                        }\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n                this.close(e);\n            } else {\n                this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _isItemSelected: function (item) {\n            if (this.options.multiselect) {\n                return this.valueField.find('option[value=' + item.id + ']').length > 0;\n            }\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         *\n         * @param {Object} item\n         * @return {Element}\n         * @private\n         */\n        _createOption: function (item) {\n            var option = this._getOption(item);\n\n            if (!option.length) {\n                option = $('<option>', {\n                    value: item.id,\n                    selected: true\n                }).text(item.label);\n            }\n\n            return option.data('renderedOption', this._renderOption(item));\n        },\n\n        /**\n         * Add selected item in to select options\n         * @param {Object} e - event object\n         * @param {*} item\n         * @private\n         */\n        _addOption: function (e, item) {\n            this.valueField.append(this._createOption(item).data('selectTarget', $(e.target)));\n        },\n\n        /**\n         * @param {Object|Element} item\n         * @return {Element}\n         * @private\n         */\n        _getOption: function (item) {\n            return $(item).prop('tagName') ?\n                $(item) :\n                this.valueField.find('option[value=' + item.id + ']');\n        },\n\n        /**\n         * Remove last added option\n         * @private\n         * @param {Object} e - event object\n         */\n        _removeLastAdded: function (e) {\n            var lastAdded = this._getOptions().last();\n\n            if (lastAdded.length) {\n                this.removeOption(e, lastAdded);\n            }\n        },\n\n        /**\n         * Remove item from select options\n         * @param {Object} e - event object\n         * @param {Object} item\n         * @private\n         */\n        removeOption: function (e, item) {\n            var option = this._getOption(item),\n                selectTarget = option.data('selectTarget');\n\n            if (selectTarget && selectTarget.length) {\n                selectTarget.removeClass(this.options.selectedClass);\n            }\n\n            option.data('renderedOption').remove();\n            option.remove();\n        },\n\n        /**\n         * Render visual element of selected item\n         * @param {Object} item - selected item\n         * @private\n         */\n        _renderOption: function (item) {\n            var tmpl = this.choiceTmpl({\n                text: item.label\n            });\n\n            return $(tmpl)\n                .insertBefore(this.elementWrapper)\n                .trigger('contentUpdated')\n                .on('removeOption', $.proxy(function (e) {\n                    this.removeOption(e, item);\n                }, this));\n        }\n    });\n\n    return $.mage.suggest;\n});\n","mage/backend/menu.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.menu', {\n        widgetEventPrefix: 'menu',\n        version: '1.10.1',\n        defaultElement: '<ul>',\n        delay: 300,\n        options: {\n            icons: {\n                submenu: 'ui-icon-carat-1-e'\n            },\n            menus: 'ul',\n            position: {\n                my: 'left top',\n                at: 'right top'\n            },\n            role: 'menu',\n\n            // callbacks\n            blur: null,\n            focus: null,\n            select: null\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.activeMenu = this.element;\n            // flag used to prevent firing of the click handler\n            // as the event bubbles up through nested menus\n            this.mouseHandled = false;\n            this.element\n                .uniqueId()\n                .addClass('ui-menu ui-widget ui-widget-content ui-corner-all')\n                .toggleClass('ui-menu-icons', !!this.element.find('.ui-icon').length)\n                .attr({\n                    role: this.options.role,\n                    tabIndex: 0\n                })\n                // need to catch all clicks on disabled menu\n                // not possible through _on\n                .on('click' + this.eventNamespace, $.proxy(function (event) {\n                    if (this.options.disabled) {\n                        event.preventDefault();\n                    }\n                }, this));\n\n            if (this.options.disabled) {\n                this.element\n                    .addClass('ui-state-disabled')\n                    .attr('aria-disabled', 'true');\n            }\n\n            this._on({\n                /**\n                 * Prevent focus from sticking to links inside menu after clicking\n                 * them (focus should always stay on UL during navigation).\n                 */\n                'mousedown .ui-menu-item > a': function (event) {\n                    event.preventDefault();\n                },\n\n                /**\n                 * Prevent focus from sticking to links inside menu after clicking\n                 * them (focus should always stay on UL during navigation).\n                 */\n                'click .ui-state-disabled > a': function (event) {\n                    event.preventDefault();\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'click .ui-menu-item:has(a)': function (event) {\n                    var target = $(event.target).closest('.ui-menu-item');\n\n                    if (!this.mouseHandled && target.not('.ui-state-disabled').length) {\n                        this.mouseHandled = true;\n\n                        this.select(event);\n                        // Open submenu on click\n                        if (target.has('.ui-menu').length) {\n                            this.expand(event);\n                        } else if (!this.element.is(':focus')) {\n                            // Redirect focus to the menu\n                            this.element.trigger('focus', [true]);\n\n                            // If the active item is on the top level, let it stay active.\n                            // Otherwise, blur the active item since it is no longer visible.\n                            if (this.active && this.active.parents('.ui-menu').length === 1) { //eslint-disable-line\n                                clearTimeout(this.timer);\n                            }\n                        }\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseenter .ui-menu-item': function (event) {\n                    var target = $(event.currentTarget);\n\n                    // Remove ui-state-active class from siblings of the newly focused menu item\n                    // to avoid a jump caused by adjacent elements both having a class with a border\n                    target.siblings().children('.ui-state-active').removeClass('ui-state-active');\n                    this.focus(event, target);\n                },\n                mouseleave: 'collapseAll',\n                'mouseleave .ui-menu': 'collapseAll',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} keepActiveItem\n                 */\n                focus: function (event, keepActiveItem) {\n                    // If there's already an active item, keep it active\n                    // If not, activate the first item\n                    var item = this.active || this.element.children('.ui-menu-item').eq(0);\n\n                    if (!keepActiveItem) {\n                        this.focus(event, item);\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                blur: function (event) {\n                    this._delay(function () {\n                        if (!$.contains(this.element[0], this.document[0].activeElement)) {\n                            this.collapseAll(event);\n                        }\n                    });\n                },\n                keydown: '_keydown'\n            });\n\n            this.refresh();\n\n            // Clicks outside of a menu collapse any open menus\n            this._on(this.document, {\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                click: function (event) {\n                    if (!$(event.target).closest('.ui-menu').length) {\n                        this.collapseAll(event);\n                    }\n\n                    // Reset the mouseHandled flag\n                    this.mouseHandled = false;\n                }\n            });\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            // Destroy (sub)menus\n            this.element\n                .removeAttr('aria-activedescendant')\n                .find('.ui-menu').addBack()\n                .removeClass('ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons')\n                .removeAttr('role')\n                .removeAttr('tabIndex')\n                .removeAttr('aria-labelledby')\n                .removeAttr('aria-expanded')\n                .removeAttr('aria-hidden')\n                .removeAttr('aria-disabled')\n                .removeUniqueId()\n                .show();\n\n            // Destroy menu items\n            this.element.find('.ui-menu-item')\n                .removeClass('ui-menu-item')\n                .removeAttr('role')\n                .removeAttr('aria-disabled')\n                .children('a')\n                .removeUniqueId()\n                .removeClass('ui-corner-all ui-state-hover')\n                .removeAttr('tabIndex')\n                .removeAttr('role')\n                .removeAttr('aria-haspopup')\n                .children().each(function () {\n                    var elem = $(this);\n\n                    if (elem.data('ui-menu-submenu-carat')) {\n                        elem.remove();\n                    }\n                });\n\n            // Destroy menu dividers\n            this.element.find('.ui-menu-divider').removeClass('ui-menu-divider ui-widget-content');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var match, prev, character, skip, regex,\n                preventDefault = true;\n\n            /**\n             * @param {String} value\n             */\n            function escape(value) {\n                return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, '\\\\$&');\n            }\n\n            switch (event.keyCode) {\n                case $.ui.keyCode.PAGE_UP:\n                    this.previousPage(event);\n                    break;\n\n                case $.ui.keyCode.PAGE_DOWN:\n                    this.nextPage(event);\n                    break;\n\n                case $.ui.keyCode.HOME:\n                    this._move('first', 'first', event);\n                    break;\n\n                case $.ui.keyCode.END:\n                    this._move('last', 'last', event);\n                    break;\n\n                case $.ui.keyCode.UP:\n                    this.previous(event);\n                    break;\n\n                case $.ui.keyCode.DOWN:\n                    this.next(event);\n                    break;\n\n                case $.ui.keyCode.LEFT:\n                    this.collapse(event);\n                    break;\n\n                case $.ui.keyCode.RIGHT:\n                    if (this.active && !this.active.is('.ui-state-disabled')) {\n                        this.expand(event);\n                    }\n                    break;\n\n                case $.ui.keyCode.ENTER:\n                case $.ui.keyCode.SPACE:\n                    this._activate(event);\n                    break;\n\n                case $.ui.keyCode.ESCAPE:\n                    this.collapse(event);\n                    break;\n\n                default:\n                    preventDefault = false;\n                    prev = this.previousFilter || '';\n                    character = String.fromCharCode(event.keyCode);\n                    skip = false;\n\n                    clearTimeout(this.filterTimer);\n\n                    if (character === prev) {\n                        skip = true;\n                    } else {\n                        character = prev + character;\n                    }\n\n                    regex = new RegExp('^' + escape(character), 'i');\n                    match = this.activeMenu.children('.ui-menu-item').filter(function () {\n                        return regex.test($(this).children('a').text());\n                    });\n                    match = skip && match.index(this.active.next()) !== -1 ?\n                        this.active.nextAll('.ui-menu-item') :\n                        match;\n\n                    // If no matches on the current filter, reset to the last character pressed\n                    // to move down the menu to the first item that starts with that character\n                    if (!match.length) {\n                        character = String.fromCharCode(event.keyCode);\n                        regex = new RegExp('^' + escape(character), 'i');\n                        match = this.activeMenu.children('.ui-menu-item').filter(function () {\n                            return regex.test($(this).children('a').text());\n                        });\n                    }\n\n                    if (match.length) {\n                        this.focus(event, match);\n\n                        if (match.length > 1) { //eslint-disable-line max-depth\n                            this.previousFilter = character;\n                            this.filterTimer = this._delay(function () {\n                                delete this.previousFilter;\n                            }, 1000);\n                        } else {\n                            delete this.previousFilter;\n                        }\n                    } else {\n                        delete this.previousFilter;\n                    }\n            }\n\n            if (preventDefault) {\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _activate: function (event) {\n            if (!this.active.is('.ui-state-disabled')) {\n                if (this.active.children('a[aria-haspopup=\"true\"]').length) {\n                    this.expand(event);\n                } else {\n                    this.select(event);\n                }\n            }\n        },\n\n        /**\n         * Refresh.\n         */\n        refresh: function () {\n            var menus,\n                icon = this.options.icons.submenu,\n                submenus = this.element.find(this.options.menus);\n\n            // Initialize nested menus\n            submenus.filter(':not(.ui-menu)')\n                .addClass('ui-menu ui-widget ui-widget-content ui-corner-all')\n                .hide()\n                .attr({\n                    role: this.options.role,\n                    'aria-hidden': 'true',\n                    'aria-expanded': 'false'\n                })\n                .each(function () {\n                    var menu = $(this),\n                        item = menu.prev('a'),\n                        submenuCarat = $('<span>')\n                            .addClass('ui-menu-icon ui-icon ' + icon)\n                            .data('ui-menu-submenu-carat', true);\n\n                    item\n                        .attr('aria-haspopup', 'true')\n                        .prepend(submenuCarat);\n                    menu.attr('aria-labelledby', item.attr('id'));\n                });\n\n            menus = submenus.add(this.element);\n\n            // Don't refresh list items that are already adapted\n            menus.children(':not(.ui-menu-item):has(a)')\n                .addClass('ui-menu-item')\n                .attr('role', 'presentation')\n                .children('a')\n                .uniqueId()\n                .addClass('ui-corner-all')\n                .attr({\n                    tabIndex: -1,\n                    role: this._itemRole()\n                });\n\n            // Initialize unlinked menu-items containing spaces and/or dashes only as dividers\n            menus.children(':not(.ui-menu-item)').each(function () {\n                var item = $(this);\n\n                // hyphen, em dash, en dash\n                if (!/[^\\-\\u2014\\u2013\\s]/.test(item.text())) {\n                    item.addClass('ui-widget-content ui-menu-divider');\n                }\n            });\n\n            // Add aria-disabled attribute to any disabled menu item\n            menus.children('.ui-state-disabled').attr('aria-disabled', 'true');\n\n            // If the active item has been removed, blur the menu\n            if (this.active && !$.contains(this.element[0], this.active[0])) {\n                this.blur();\n            }\n        },\n\n        /**\n         * @return {*}\n         * @private\n         */\n        _itemRole: function () {\n            return {\n                menu: 'menuitem',\n                listbox: 'option'\n            }[this.options.role];\n        },\n\n        /**\n         * @param {String} key\n         * @param {*} value\n         * @private\n         */\n        _setOption: function (key, value) {\n            if (key === 'icons') {\n                this.element.find('.ui-menu-icon')\n                    .removeClass(this.options.icons.submenu)\n                    .addClass(value.submenu);\n            }\n            this._super(key, value);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} item\n         */\n        focus: function (event, item) {\n            var nested, focused;\n\n            this.blur(event, event && event.type === 'focus');\n\n            this._scrollIntoView(item);\n\n            this.active = item.first();\n            focused = this.active.children('a').addClass('ui-state-focus');\n            // Only update aria-activedescendant if there's a role\n            // otherwise we assume focus is managed elsewhere\n            if (this.options.role) {\n                this.element.attr('aria-activedescendant', focused.attr('id'));\n            }\n\n            // Highlight active parent menu item, if any\n            this.active\n                .parent()\n                .closest('.ui-menu-item')\n                .children('a:first')\n                .addClass('ui-state-active');\n\n            if (event && event.type === 'keydown') {\n                this._close();\n            } else {\n                this.timer = this._delay(function () {\n                    this._close();\n                }, this.delay);\n            }\n\n            nested = item.children('.ui-menu');\n\n            if (nested.length && /^mouse/.test(event.type)) {\n                this._startOpening(nested);\n            }\n            this.activeMenu = item.parent();\n\n            this._trigger('focus', event, {\n                item: item\n            });\n        },\n\n        /**\n         * @param {Object} item\n         * @private\n         */\n        _scrollIntoView: function (item) {\n            var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n\n            if (this._hasScroll()) {\n                borderTop = parseFloat($.css(this.activeMenu[0], 'borderTopWidth')) || 0;\n                paddingTop = parseFloat($.css(this.activeMenu[0], 'paddingTop')) || 0;\n                offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n                scroll = this.activeMenu.scrollTop();\n                elementHeight = this.activeMenu.height();\n                itemHeight = item.height();\n\n                if (offset < 0) {\n                    this.activeMenu.scrollTop(scroll + offset);\n                } else if (offset + itemHeight > elementHeight) {\n                    this.activeMenu.scrollTop(scroll + offset - elementHeight + itemHeight);\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {*} fromFocus\n         */\n        blur: function (event, fromFocus) {\n            if (!fromFocus) {\n                clearTimeout(this.timer);\n            }\n\n            if (!this.active) {\n                return;\n            }\n\n            this.active.children('a').removeClass('ui-state-focus');\n            this.active = null;\n\n            this._trigger('blur', event, {\n                item: this.active\n            });\n        },\n\n        /**\n         * @param {*} submenu\n         * @private\n         */\n        _startOpening: function (submenu) {\n            clearTimeout(this.timer);\n\n            // Don't open if already open fixes a Firefox bug that caused a .5 pixel\n            // shift in the submenu position when mousing over the carat icon\n            if (submenu.attr('aria-hidden') !== 'true') {\n                return;\n            }\n\n            this.timer = this._delay(function () {\n                this._close();\n                this._open(submenu);\n            }, this.delay);\n        },\n\n        /**\n         * @param {*} submenu\n         * @private\n         */\n        _open: function (submenu) {\n            var position = $.extend({\n                of: this.active\n            }, this.options.position);\n\n            clearTimeout(this.timer);\n            this.element.find('.ui-menu').not(submenu.parents('.ui-menu'))\n                .hide()\n                .attr('aria-hidden', 'true');\n\n            submenu\n                .show()\n                .removeAttr('aria-hidden')\n                .attr('aria-expanded', 'true')\n                .position(position);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {*} all\n         */\n        collapseAll: function (event, all) {\n            clearTimeout(this.timer);\n            this.timer = this._delay(function () {\n                // If we were passed an event, look for the submenu that contains the event\n                var currentMenu = all ? this.element :\n                    $(event && event.target).closest(this.element.find('.ui-menu'));\n\n                // If we found no valid submenu ancestor, use the main menu to close all sub menus anyway\n                if (!currentMenu.length) {\n                    currentMenu = this.element;\n                }\n\n                this._close(currentMenu);\n\n                this.blur(event);\n                this.activeMenu = currentMenu;\n            }, this.delay);\n        },\n\n        // With no arguments, closes the currently active menu - if nothing is active\n        // it closes all menus.  If passed an argument, it will search for menus BELOW\n        /**\n         * With no arguments, closes the currently active menu - if nothing is active\n         * it closes all menus.  If passed an argument, it will search for menus BELOW.\n         *\n         * @param {*} startMenu\n         * @private\n         */\n        _close: function (startMenu) {\n            if (!startMenu) {\n                startMenu = this.active ? this.active.parent() : this.element;\n            }\n\n            startMenu\n                .find('.ui-menu')\n                .hide()\n                .attr('aria-hidden', 'true')\n                .attr('aria-expanded', 'false')\n                .end()\n                .find('a.ui-state-active')\n                .removeClass('ui-state-active');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        collapse: function (event) {\n            var newItem = this.active &&\n                this.active.parent().closest('.ui-menu-item', this.element);\n\n            if (newItem && newItem.length) {\n                this._close();\n                this.focus(event, newItem);\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        expand: function (event) {\n            var newItem = this.active &&\n                this.active\n                    .children('.ui-menu ')\n                    .children('.ui-menu-item')\n                    .first();\n\n            if (newItem && newItem.length) {\n                this._open(newItem.parent());\n\n                // Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n                this._delay(function () {\n                    this.focus(event, newItem);\n                });\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        next: function (event) {\n            this._move('next', 'first', event);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        previous: function (event) {\n            this._move('prev', 'last', event);\n        },\n\n        /**\n         * @return {null|Boolean}\n         */\n        isFirstItem: function () {\n            return this.active && !this.active.prevAll('.ui-menu-item').length;\n        },\n\n        /**\n         * @return {null|Boolean}\n         */\n        isLastItem: function () {\n            return this.active && !this.active.nextAll('.ui-menu-item').length;\n        },\n\n        /**\n         * @param {*} direction\n         * @param {*} filter\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _move: function (direction, filter, event) {\n            var next;\n\n            if (this.active) {\n                if (direction === 'first' || direction === 'last') {\n                    next = this.active\n                        [direction === 'first' ? 'prevAll' : 'nextAll']('.ui-menu-item')\n                        .eq(-1);\n                } else {\n                    next = this.active\n                        [direction + 'All']('.ui-menu-item')\n                        .eq(0);\n                }\n            }\n\n            if (!next || !next.length || !this.active) {\n                next = this.activeMenu.children('.ui-menu-item')[filter]();\n            }\n\n            this.focus(event, next);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        nextPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n\n                return;\n            }\n\n            if (this.isLastItem()) {\n                return;\n            }\n\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.nextAll('.ui-menu-item').each(function () {\n                    item = $(this);\n\n                    return item.offset().top - base - height < 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children('.ui-menu-item')\n                    [!this.active ? 'first' : 'last']());\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        previousPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n\n                return;\n            }\n\n            if (this.isFirstItem()) {\n                return;\n            }\n\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.prevAll('.ui-menu-item').each(function () {\n                    item = $(this);\n\n                    return item.offset().top - base + height > 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children('.ui-menu-item').first());\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         * @private\n         */\n        _hasScroll: function () {\n            return this.element.outerHeight() < this.element.prop('scrollHeight');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        select: function (event) {\n            // TODO: It should never be possible to not have an active item at this\n            // point, but the tests don't trigger mouseenter before click.\n            var ui;\n\n            this.active = this.active || $(event.target).closest('.ui-menu-item');\n            ui = {\n                item: this.active\n            };\n\n            if (!this.active.has('.ui-menu').length) {\n                this.collapseAll(event, true);\n            }\n            this._trigger('select', event, ui);\n        }\n    });\n\n    return $.mage.menu;\n});\n","mage/backend/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.form', {\n        options: {\n            handlersData: {\n                save: {},\n                saveAndContinueEdit: {\n                    action: {\n                        args: {\n                            back: 'edit'\n                        }\n                    }\n                },\n                preview: {\n                    target: '_blank'\n                }\n            }\n        },\n\n        /**\n         * Form creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Set form attributes to initial state\n         * @protected\n         */\n        _rollback: function () {\n            if (this.oldAttributes) {\n                this.element.prop(this.oldAttributes);\n            }\n        },\n\n        /**\n         * Check if field value is changed\n         * @protected\n         * @param {Object} e - event object\n         */\n        _changesObserver: function (e) {\n            var target = $(e.target),\n                changed;\n\n            if (e.type === 'focus' || e.type === 'focusin') {\n                this.currentField = {\n                    statuses: {\n                        checked: target.is(':checked'),\n                        selected: target.is(':selected')\n                    },\n                    val: target.val()\n                };\n\n            } else {\n                if (this.currentField) { //eslint-disable-line no-lonely-if\n                    changed = target.val() !== this.currentField.val ||\n                        target.is(':checked') !== this.currentField.statuses.checked ||\n                        target.is(':selected') !== this.currentField.statuses.selected;\n\n                    if (changed) { //eslint-disable-line max-depth\n                        target.trigger('changed');\n                    }\n                }\n            }\n        },\n\n        /**\n         * Get array with handler names\n         * @protected\n         * @return {Array} Array of handler names\n         */\n        _getHandlers: function () {\n            var handlers = [];\n\n            $.each(this.options.handlersData, function (key) {\n                handlers.push(key);\n            });\n\n            return handlers;\n        },\n\n        /**\n         * Store initial value of form attribute\n         * @param {String} attrName - name of attribute\n         * @protected\n         */\n        _storeAttribute: function (attrName) {\n            var prop;\n\n            this.oldAttributes = this.oldAttributes || {};\n\n            if (!this.oldAttributes[attrName]) {\n                prop = this.element.attr(attrName);\n                this.oldAttributes[attrName] = prop ? prop : '';\n            }\n        },\n\n        /**\n         * Bind handlers\n         * @protected\n         */\n        _bind: function () {\n            this.element\n                .on(this._getHandlers().join(' '), $.proxy(this._submit, this))\n                .on('focus blur focusin focusout', $.proxy(this._changesObserver, this));\n        },\n\n        /**\n         * Get action url for form\n         * @param {Object|String} data - object with parameters for action url or url string\n         * @return {String} action url\n         */\n        _getActionUrl: function (data) {\n            if (typeof data === 'object') {\n                return this._buildURL(this.oldAttributes.action, data.args);\n            }\n\n            return typeof data === 'string' ? data : this.oldAttributes.action;\n        },\n\n        /**\n         * Add additional parameters into URL\n         * @param {String} url - original url\n         * @param {Object} params - object with parameters for action url\n         * @return {String} action url\n         * @private\n         */\n        _buildURL: function (url, params) {\n            var concat = /\\?/.test(url) ? ['&', '='] : ['/', '/'];\n\n            url = url.replace(/[\\/&]+$/, '');\n            $.each(params, function (key, value) {\n                url += concat[0] + key + concat[1] + window.encodeURIComponent(value);\n            });\n\n            return url + (concat[0] === '/' ? '/' : '');\n        },\n\n        /**\n         * Prepare data for form attributes\n         * @protected\n         * @param {Object} data\n         * @return {Object}\n         */\n        _processData: function (data) {\n            $.each(data, $.proxy(function (attrName, attrValue) {\n                this._storeAttribute(attrName);\n\n                if (attrName === 'action') {\n                    data[attrName] = this._getActionUrl(attrValue);\n                }\n            }, this));\n\n            return data;\n        },\n\n        /**\n         * Get additional data before form submit\n         * @protected\n         * @param {String} handlerName\n         * @param {Object} data\n         */\n        _beforeSubmit: function (handlerName, data) {\n            var submitData = {},\n                event = new $.Event('beforeSubmit');\n\n            this.element.trigger(event, [submitData, handlerName]);\n            data = $.extend(\n                true, {},\n                this.options.handlersData[handlerName] || {},\n                submitData,\n                data\n            );\n            this.element.prop(this._processData(data));\n\n            return !event.isDefaultPrevented();\n        },\n\n        /**\n         * Submit the form\n         * @param {Object} e - event object\n         * @param {Object} data - event data object\n         */\n        _submit: function (e, data) {\n            this._rollback();\n\n            if (this._beforeSubmit(e.type, data) !== false) {\n                this.element.trigger('submit', e);\n            }\n        }\n    });\n\n    return $.mage.form;\n});\n","mage/backend/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\ndefine([\n    'jquery',\n    'mage/apply/main',\n    'mage/backend/notification',\n    'Magento_Ui/js/lib/knockout/bootstrap',\n    'mage/mage',\n    'mage/translate'\n], function ($, mage, notification) {\n    'use strict';\n\n    var bootstrap;\n\n    $.ajaxSetup({\n        /*\n         * @type {string}\n         */\n        type: 'POST',\n\n        /**\n         * Ajax before send callback.\n         *\n         * @param {Object} jqXHR - The jQuery XMLHttpRequest object returned by $.ajax()\n         * @param {Object} settings\n         */\n        beforeSend: function (jqXHR, settings) {\n            var formKey = typeof FORM_KEY !== 'undefined' ? FORM_KEY : null;\n\n            if (!settings.url.match(new RegExp('[?&]isAjax=true',''))) {\n                settings.url = settings.url.match(\n                    new RegExp('\\\\?', 'g')) ?\n                    settings.url + '&isAjax=true' :\n                    settings.url + '?isAjax=true';\n            }\n\n            if (!settings.data) {\n                settings.data = {\n                    'form_key': formKey\n                };\n            } else if (typeof settings.data === 'string' &&\n                settings.data.indexOf('form_key=') === -1) {\n                settings.data += '&' + $.param({\n                    'form_key': formKey\n                });\n            } else if ($.isPlainObject(settings.data) && !settings.data['form_key']) {\n                settings.data['form_key'] = formKey;\n            }\n        },\n\n        /**\n         * Ajax complete callback.\n         *\n         * @param {Object} jqXHR - The jQuery XMLHttpRequest object returned by $.ajax()\n         */\n        complete: function (jqXHR) {\n            var jsonObject;\n\n            if (jqXHR.readyState === 4) {\n                try {\n                    jsonObject = JSON.parse(jqXHR.responseText);\n\n                    if (jsonObject.ajaxExpired && jsonObject.ajaxRedirect) { //eslint-disable-line max-depth\n                        window.location.replace(jsonObject.ajaxRedirect);\n                    }\n                } catch (e) {}\n            }\n        },\n\n        /**\n         * Error callback.\n         */\n        error: function () {\n            $('body').notification('clear')\n                .notification('add', {\n                    error: true,\n                    message: $.mage.__(\n                        'A technical problem with the server created an error. ' +\n                        'Try again to continue what you were doing. If the problem persists, try again later.'\n                    ),\n\n                    /**\n                     * @param {String} message\n                     */\n                    insertMethod: function (message) {\n                        var $wrapper = $('<div></div>').html(message);\n\n                        $('.page-main-actions').after($wrapper);\n                    }\n                });\n        }\n    });\n\n    /**\n     * Bootstrap application.\n     */\n    bootstrap = function () {\n        /**\n         * Init all components defined via data-mage-init attribute\n         * and subscribe init action on contentUpdated event\n         */\n        mage.apply();\n\n        /*\n         * Initialization of notification widget\n         */\n        notification({}, $('body'));\n    };\n\n    $(bootstrap);\n});\n","mage/backend/editablemultiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/* global EditableMultiselect */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'jquery/editableMultiselect/js/jquery.editable',\n    'jquery/editableMultiselect/js/jquery.multiselect'\n], function ($, alert, confirm) {\n    /**\n     * Editable multiselect wrapper for multiselects\n     * This class is defined in global scope ('var' is not needed).\n     *\n     *  @param {Object} settings - settings object.\n     *  @param {String} settings.add_button_caption - caption of the 'Add New Value' button\n     *  @param {String} settings.new_url - URL to which new request has to be submitted\n     *  @param {String} settings.save_url - URL to which save request has to be submitted\n     *  @param {String} settings.delete_url - URL to which delete request has to be submitted\n     *  @param {String} settings.delete_confirm_message - confirmation message that is shown to user during\n     *      delete operation\n     *  @param {String} settings.target_select_id - HTML ID of target select element\n     *  @param {Hash} settings.submit_data - extra parameters to send with new/edit/delete requests\n     *  @param {String} settings.entity_value_name - name of the request parameter that represents select option text\n     *  @param {String} settings.entity_id_name - name of the request parameter that represents select option value\n     *  @param {Boolean} settings.is_entry_editable - flag that shows if user can add/edit/remove data\n     *\n     * @constructor\n     */\n    window.EditableMultiselect = function (settings) {\n\n        this.settings = settings || {};\n        this.addButtonCaption = this.settings['add_button_caption'] || 'Add new value';\n        this.newUrl = this.settings['new_url'];\n        this.saveUrl = this.settings['save_url'];\n        this.deleteUrl = this.settings['delete_url'];\n        this.deleteConfirmMessage = this.settings['delete_confirm_message'];\n        this.targetSelectId = this.settings['target_select_id'];\n        this.submitData = this.settings['submit_data'] || {};\n        this.entityIdName = this.settings['entity_id_name'] || 'entity_id';\n        this.entityValueName = this.settings['entity_value_name'] || 'entity_value';\n        this.isEntityEditable = this.settings['is_entity_editable'] || false;\n\n        /**\n         * Initialize editable multiselect (make it visible in UI)\n         */\n        EditableMultiselect.prototype.init = function () {\n            var self = this,\n                mselectOptions = {\n                    addText: this.addButtonCaption,\n\n                    /**\n                     * @param {*} value\n                     * @param {*} options\n                     */\n                    mselectInputSubmitCallback: function (value, options) {\n                        self.createEntity(value, options);\n                    }\n                },\n                mselectList;\n\n            if (!this.isEntityEditable) {\n                // Override default layout of editable multiselect\n                mselectOptions.layout = '<section class=\"block %mselectListClass%\">' +\n                    '<div class=\"block-content\"><div class=\"%mselectItemsWrapperClass%\">' +\n                    '%items%' +\n                    '</div></div>' +\n                    '<div class=\"%mselectInputContainerClass%\">' +\n                    '<input type=\"text\" class=\"%mselectInputClass%\" title=\"%inputTitle%\"/>' +\n                    '<span class=\"%mselectButtonCancelClass%\" title=\"%cancelText%\"></span>' +\n                    '<span class=\"%mselectButtonSaveClass%\" title=\"Add\"></span>' +\n                    '</div>' +\n                    '</section>';\n            }\n\n            $('#' + this.targetSelectId).multiselect(mselectOptions);\n\n            // Make multiselect editable if needed\n            if (this.isEntityEditable) {\n                this.makeMultiselectEditable();\n\n                // Root element of HTML markup that represents select element in UI\n                mselectList = $('#' + this.targetSelectId).next();\n                this.attachEventsToControls(mselectList);\n            }\n        };\n\n        /**\n         * Attach required event handlers to control elements of editable multiselect\n         *\n         * @param {Object} mselectList\n         */\n        EditableMultiselect.prototype.attachEventsToControls = function (mselectList) {\n            mselectList.on('click.mselect-delete', '.mselect-delete', {\n                container: this\n            }, function (event) {\n                // Pass the clicked button to container\n                event.data.container.deleteEntity({\n                    'delete_button': this\n                });\n            });\n\n            mselectList.on('click.mselect-checked', '.mselect-list-item input', {\n                container: this\n            }, function (event) {\n                var el = $(this),\n                    checkedClassName = 'mselect-checked';\n\n                el[el.is(':checked') ? 'addClass' : 'removeClass'](checkedClassName);\n                event.data.container.makeMultiselectEditable();\n            });\n\n            mselectList.on('click.mselect-edit', '.mselect-edit', {\n                container: this\n            }, function (event) {\n                event.data.container.makeMultiselectEditable();\n                $(this).parent().find('label span').trigger('dblclick');\n            });\n        };\n\n        /**\n         * Make multiselect editable\n         */\n        EditableMultiselect.prototype.makeMultiselectEditable = function () {\n            var entityIdName = this.entityIdName,\n                entityValueName = this.entityValueName,\n                selectList = $('#' + this.targetSelectId).next();\n\n            selectList.find('.mselect-list-item:not(.mselect-list-item-not-editable) label span').editable(this.saveUrl,\n            {\n                type: 'text',\n                submit: '<button class=\"mselect-save\" title=\"Save\" type=\"submit\"></button>',\n                cancel: '<span class=\"mselect-cancel\" title=\"Cancel\"></span>',\n                event: 'dblclick',\n                placeholder: '',\n\n                /**\n                 * Is checked.\n                 */\n                isChecked: function () {\n                    var that = $(this),\n                        checked;\n\n                    if (!that.closest('.mselect-list-item').hasClass('mselect-disabled')) {\n                        checked = that.parent().find('[type=checkbox]').prop('disabled');\n                        that.parent().find('[type=checkbox]').prop({\n                            disabled: !checked\n                        });\n                    }\n                },\n\n                /**\n                 * @param {*} value\n                 * @param {Object} sett\n                 * @return {*}\n                 */\n                data: function (value, sett) {\n                    var retval;\n\n                    sett.isChecked.apply(this, [sett]);\n\n                    if (typeof value === 'string') {\n                        retval = value.unescapeHTML();\n\n                        return retval;\n                    }\n\n                    return value;\n                },\n                submitdata: this.submitData,\n                onblur: 'cancel',\n                name: entityValueName,\n                ajaxoptions: {\n                    dataType: 'json'\n                },\n\n                /**\n                 * @param {Object} sett\n                 * @param {*} original\n                 */\n                onsubmit: function (sett, original) {\n                    var select = $(original).closest('.mselect-list').prev(),\n                        current = $(original).closest('.mselect-list-item').index(),\n                        entityId = select.find('option').eq(current).val(),\n                        entityInfo = {};\n\n                    entityInfo[entityIdName] = entityId;\n                    sett.submitdata = $.extend(sett.submitdata || {}, entityInfo);\n                },\n\n                /**\n                 * @param {Object} result\n                 * @param {Object} sett\n                 */\n                callback: function (result, sett) {\n                    var select, current;\n\n                    sett.isChecked.apply(this, [sett]);\n                    select = $(this).closest('.mselect-list').prev();\n                    current = $(this).closest('.mselect-list-item').index();\n\n                    if (result.success) {\n                        if (typeof result[entityValueName] === 'string') {\n                            select.find('option').eq(current).val(result[entityIdName]).text(result[entityValueName]);\n                            $(this).html(result[entityValueName].escapeHTML());\n                        }\n                    } else {\n                        alert({\n                            content: result['error_message']\n                        });\n                    }\n                }\n            });\n        };\n\n        /**\n         * Callback function that is called when admin adds new value to select\n         *\n         * @param {*} value\n         * @param {Object} options - list of settings of multiselect\n         */\n        EditableMultiselect.prototype.createEntity = function (value, options) {\n            var select, entityIdName, entityValueName, entityInfo, postData, ajaxOptions;\n\n            if (!value) {\n                return;\n            }\n\n            select = $('#' + this.targetSelectId),\n            entityIdName = this.entityIdName,\n            entityValueName = this.entityValueName,\n            entityInfo = {};\n            entityInfo[entityIdName] = null;\n            entityInfo[entityValueName] = value;\n\n            postData = $.extend(entityInfo, this.submitData);\n\n            ajaxOptions = {\n                type: 'POST',\n                data: postData,\n                dataType: 'json',\n                url: this.newUrl,\n\n                /**\n                 * @param {Object} result\n                 */\n                success: function (result) {\n                    var resultEntityValueName, mselectItemHtml, sectionBlock, itemsWrapper, inputSelector;\n\n                    if (result.success) {\n                        resultEntityValueName = '';\n\n                        if (typeof result[entityValueName] === 'string') {\n                            resultEntityValueName = result[entityValueName].escapeHTML();\n                        } else {\n                            resultEntityValueName = result[entityValueName];\n                        }\n                        // Add item to initial select element\n                        select.append('<option value=\"' + result[entityIdName] + '\" selected=\"selected\">' +\n                        resultEntityValueName + '</option>');\n                        // Add editable multiselect item\n                        mselectItemHtml = $(options.item.replace(/%value%|%label%/gi, resultEntityValueName)\n                            .replace(/%mselectDisabledClass%|%iseditable%|%isremovable%/gi, '')\n                            .replace(/%mselectListItemClass%/gi, options.mselectListItemClass))\n                            .find('[type=checkbox]')\n                            .addClass(options.mselectCheckedClass)\n                            .prop('checked', true)\n                            .end();\n                        sectionBlock = select.nextAll('section.block:first');\n                        itemsWrapper = sectionBlock.find('.' + options.mselectItemsWrapperClass + '');\n\n                        if (itemsWrapper.children('.' + options.mselectListItemClass + '').length) {\n                            itemsWrapper.children('.' + options.mselectListItemClass + ':last').after(mselectItemHtml);\n                        } else {\n                            itemsWrapper.prepend(mselectItemHtml);\n                        }\n                        // Trigger blur event on input field, that is used to add new value, to hide it\n                        inputSelector = '.' + options.mselectInputContainerClass + ' [type=text].' +\n                            options.mselectInputClass + '';\n                        sectionBlock.find(inputSelector).trigger('blur');\n                    } else {\n                        alert({\n                            content: result['error_message']\n                        });\n                    }\n                }\n            };\n            $.ajax(ajaxOptions);\n        };\n\n        /**\n         * Callback function that is called when user tries to delete value from select\n         *\n         * @param {Object} options\n         */\n        EditableMultiselect.prototype.deleteEntity = function (options) {\n            var self = this;\n\n            if (options['delete_button']) {\n                confirm({\n                    content: this.deleteConfirmMessage,\n                    actions: {\n                        /**\n                         * Confirm.\n                         */\n                        confirm: function () {\n                            // Button that has been clicked\n                            var deleteButton = $(options['delete_button']),\n                                index = deleteButton.parent().index(),\n                                select = deleteButton.closest('.mselect-list').prev(),\n                                entityId = select.find('option').eq(index).val(),\n                                entityInfo = {},\n                                postData, ajaxOptions;\n\n                            entityInfo[self.entityIdName] = entityId;\n                            postData = $.extend(entityInfo, self.submitData);\n\n                            ajaxOptions = {\n                                type: 'POST',\n                                data: postData,\n                                dataType: 'json',\n                                url: self.deleteUrl,\n\n                                /**\n                                 * @param {Object} result\n                                 */\n                                success: function (result) {\n                                    if (result.success) {\n                                        deleteButton.parent().remove();\n                                        select.find('option').eq(index).remove();\n                                    } else {\n                                        alert({\n                                            content: result['error_message']\n                                        });\n                                    }\n                                }\n                            };\n                            $.ajax(ajaxOptions);\n                        }\n                    }\n                });\n            }\n        };\n    };\n});\n","mage/backend/floating-header.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.floatingHeader', {\n        options: {\n            placeholderAttrs: {\n                'class': 'page-actions-placeholder'\n            },\n            fixedClass: '_fixed',\n            hiddenClass: '_hidden',\n            title: '.page-title-wrapper .page-title',\n            pageMainActions: '.page-main-actions',\n            contains: '[data-role=modal]'\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function () {\n            var title = $(this.options.title).text(),\n                wrapped = this.element.find('.page-actions-buttons').children();\n\n            if (this.element.parents(this.options.contains).length) {\n                return this;\n            }\n\n            this._setVars();\n            this._bind();\n            this.element.find('script').remove();\n\n            if (wrapped.length) {\n                wrapped\n                    .unwrap()   // .page-actions-buttons\n                    .unwrap();  // .page-actions-inner\n            }\n            this.element.wrapInner($('<div></div>', {\n                'class': 'page-actions-buttons'\n            }));\n            this.element.wrapInner($('<div></div>', {\n                'class': 'page-actions-inner', 'data-title': title\n            }));\n            this.element.removeClass('floating-header');\n        },\n\n        /**\n         * Set privat variables on load, for performance purposes\n         * @private\n         */\n        _setVars: function () {\n            this._placeholder = this.element.before($('<div/>', this.options.placeholderAttrs)).prev();\n            this._offsetTop = this._placeholder.offset().top;\n            this._height = this.element\n                .parents(this.options.pageMainActions)\n                .outerHeight();\n        },\n\n        /**\n         * Event binding, will monitor scroll and resize events (resize events left for backward compat)\n         * @private\n         */\n        _bind: function () {\n            this._on(window, {\n                scroll: this._handlePageScroll,\n                resize: this._handlePageScroll\n            });\n        },\n\n        /**\n         * Event handler for setting fixed positioning\n         * @private\n         */\n        _handlePageScroll: function () {\n            var isActive = $(window).scrollTop() > this._offsetTop;\n\n            if (isActive) {\n                this.element\n                    .addClass(this.options.fixedClass)\n                    .parents(this.options.pageMainActions)\n                    .addClass(this.options.hiddenClass);\n            } else {\n                this.element\n                    .removeClass(this.options.fixedClass)\n                    .parents(this.options.pageMainActions)\n                    .removeClass(this.options.hiddenClass);\n            }\n\n            this._placeholder.height(isActive ? this._height : '');\n        },\n\n        /**\n         * Widget destroy functionality\n         * @private\n         */\n        _destroy: function () {\n            if (this._placeholder) {\n                this._placeholder.remove();\n            }\n            this._off($(window));\n        }\n    });\n\n    return $.mage.floatingHeader;\n});\n","mage/backend/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global BASE_URL, alertAlreadyDisplayed */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'jquery/validate',\n    'mage/translate',\n    'mage/validation'\n], function ($, _, alert) {\n    'use strict';\n\n    $.extend(true, $.validator.prototype, {\n        /**\n         * Focus invalid fields\n         */\n        focusInvalid: function () {\n            if (this.settings.focusInvalid) {\n                try {\n                    $(this.errorList.length && this.errorList[0].element || [])\n                        .trigger('focus')\n                        .trigger('focusin');\n                } catch (e) {\n                    // ignore IE throwing errors when focusing hidden elements\n                }\n            }\n        },\n\n        /**\n         * Elements.\n         */\n        elements: function () {\n            var validator = this,\n                rulesCache = {};\n\n            // select all valid inputs inside the form (no submit or reset buttons)\n            return $(this.currentForm)\n                .find('input, select, textarea')\n                .not(this.settings.forceIgnore)\n                .not(':submit, :reset, :image, [disabled]')\n                .not(this.settings.ignore)\n                .filter(function () {\n                    if (!this.name && validator.settings.debug && window.console) {\n                        console.error('%o has no name assigned', this);\n                    }\n\n                    // select only the first element for each name, and only those with rules specified\n                    if (this.name in rulesCache || !validator.objectLength($(this).rules())) {\n                        return false;\n                    }\n\n                    rulesCache[this.name] = true;\n\n                    return true;\n                });\n        }\n    });\n\n    $.extend($.fn, {\n        /**\n         * ValidationDelegate overridden for those cases where the form is located in another form,\n         *     to avoid not correct working of validate plug-in\n         * @override\n         * @param {String} delegate - selector, if event target matched against this selector,\n         *     then event will be delegated\n         * @param {String} type - event type\n         * @param {Function} handler - event handler\n         * @return {Element}\n         */\n        validateDelegate: function (delegate, type, handler) {\n            return this.on(type, $.proxy(function (event) {\n                var target = $(event.target),\n                    form = target[0].form;\n\n                if (form && $(form).is(this) && $.data(form, 'validator') && target.is(delegate)) {\n                    return handler.apply(target, arguments);\n                }\n            }, this));\n        }\n    });\n\n    $.widget('mage.validation', $.mage.validation, {\n        options: {\n            messagesId: 'messages',\n            forceIgnore: '',\n            ignore: ':disabled, .ignore-validate, .no-display.template, ' +\n                ':disabled input, .ignore-validate input, .no-display.template input, ' +\n                ':disabled select, .ignore-validate select, .no-display.template select, ' +\n                ':disabled textarea, .ignore-validate textarea, .no-display.template textarea',\n            errorElement: 'label',\n            errorUrl: typeof BASE_URL !== 'undefined' ? BASE_URL : null,\n\n            /**\n             * @param {HTMLElement} element\n             */\n            highlight: function (element) {\n                if ($.validator.defaults.highlight && typeof $.validator.defaults.highlight === 'function') {\n                    $.validator.defaults.highlight.apply(this, arguments);\n                }\n                $(element).trigger('highlight.validate');\n            },\n\n            /**\n             * @param {HTMLElement} element\n             */\n            unhighlight: function (element) {\n                if ($.validator.defaults.unhighlight && typeof $.validator.defaults.unhighlight === 'function') {\n                    $.validator.defaults.unhighlight.apply(this, arguments);\n                }\n                $(element).trigger('unhighlight.validate');\n            }\n        },\n\n        /**\n         * Validation creation\n         * @protected\n         */\n        _create: function () {\n            if (!this.options.submitHandler && typeof this.options.submitHandler !== 'function') {\n                if (!this.options.frontendOnly && this.options.validationUrl) {\n                    this.options.submitHandler = $.proxy(this._ajaxValidate, this);\n                } else {\n                    this.options.submitHandler = $.proxy(this._submit, this);\n                }\n            }\n            this.element.on('resetElement', function (e) {\n                $(e.target).rules('remove');\n            });\n            this._super('_create');\n        },\n\n        /**\n         * ajax validation\n         * @protected\n         */\n        _ajaxValidate: function () {\n            $.ajax({\n                url: this.options.validationUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: this.element.serialize(),\n                context: $('body'),\n                success: $.proxy(this._onSuccess, this),\n                error: $.proxy(this._onError, this),\n                showLoader: true,\n                dontHide: false\n            });\n        },\n\n        /**\n         * Process ajax success.\n         *\n         * @protected\n         * @param {Object} response\n         */\n        _onSuccess: function (response) {\n            if (!response.error) {\n                this._submit();\n            } else {\n                this._showErrors(response);\n                $(this.element[0]).trigger('afterValidate.error');\n                $('body').trigger('processStop');\n            }\n        },\n\n        /**\n         * Submitting a form.\n         * @private\n         */\n        _submit: function () {\n            $(this.element[0]).trigger('afterValidate.beforeSubmit');\n            this.element[0].submit();\n        },\n\n        /**\n         * Displays errors after backend validation.\n         *\n         * @param {Object} data - Data that came from backend.\n         */\n        _showErrors: function (data) {\n            $('body').notification('clear')\n                .notification('add', {\n                    error: data.error,\n                    message: data.message,\n\n                    /**\n                     * @param {*} message\n                     */\n                    insertMethod: function (message) {\n                        $('.messages:first').html(message);\n                    }\n                });\n        },\n\n        /**\n         * Tries to retrieve element either by id or by inputs' name property.\n         * @param {String} code - String to search by.\n         * @returns {jQuery} jQuery element.\n         */\n        _getByCode: function (code) {\n            var parent = this.element[0],\n                element;\n\n            element = parent.querySelector('#' + code) || parent.querySelector('input[name=' + code + ']');\n\n            return $(element);\n        },\n\n        /**\n         * Process ajax error\n         * @protected\n         */\n        _onError: function () {\n            $(this.element[0]).trigger('afterValidate.error');\n            $('body').trigger('processStop');\n\n            if (this.options.errorUrl) {\n                location.href = this.options.errorUrl;\n            }\n        }\n    });\n\n    _.each({\n        'validate-greater-zero-based-on-option': [\n            function (v, el) {\n                var optionType = $(el)\n                    .closest('.form-list')\n                    .prev('.fieldset-alt')\n                    .find('select.select-product-option-type'),\n                    optionTypeVal = optionType.val();\n\n                v = Number(v) || 0;\n\n                if (optionType && (optionTypeVal == 'checkbox' || optionTypeVal == 'multi') && v <= 0) { //eslint-disable-line\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a number greater 0 in this field.')\n        ],\n        'validate-rating': [\n            function () {\n                var ratings = $('#detailed_rating').find('.field-rating'),\n                    noError = true;\n\n                ratings.each(function (index, rating) {\n                    noError = noError && $(rating).find('input:checked').length > 0;\n                });\n\n                return noError;\n            },\n            $.mage.__('Please select one of each ratings above.')\n        ],\n        'validate-downloadable-file': [\n            function (v, element) {\n                var elmParent = $(element).parent(),\n                    linkType = elmParent.find('input[value=\"file\"]'),\n                    newFileContainer;\n\n                if (linkType.is(':checked') && (v === '' || v === '[]')) {\n                    newFileContainer = elmParent.find('.new-file');\n\n                    if (!alertAlreadyDisplayed && (newFileContainer.empty() || newFileContainer.is(':visible'))) {\n                        window.alertAlreadyDisplayed = true;\n                        alert({\n                            content: $.mage.__('There are files that were selected but not uploaded yet. ' +\n                            'Please upload or remove them first')\n                        });\n                    }\n\n                    return false;\n                }\n\n                return true;\n            },\n            'Please upload a file.'\n        ],\n        'validate-downloadable-url': [\n            function (v, element) {\n                var linkType = $(element).parent().find('input[value=\"url\"]');\n\n                if (linkType.is(':checked') && v === '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please specify Url.')\n        ]\n    }, function (rule, i) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n\n    return $.mage.validation;\n});\n","mage/backend/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('ui.button', $.ui.button, {\n        options: {\n            eventData: {},\n            waitTillResolved: true\n        },\n\n        /**\n         * Button creation.\n         * @protected\n         */\n        _create: function () {\n            if (this.options.event) {\n                this.options.target = this.options.target || this.element;\n                this._bind();\n            }\n\n            this._super();\n        },\n\n        /**\n         * Bind handler on button click.\n         * @protected\n         */\n        _bind: function () {\n            this.element\n                .off('click.button')\n                .on('click.button', $.proxy(this._click, this));\n        },\n\n        /**\n         * Button click handler.\n         * @protected\n         */\n        _click: function () {\n            var options = this.options;\n\n            $(options.target).trigger(options.event, [options.eventData]);\n        }\n    });\n\n    return $.ui.button;\n});\n","mage/backend/action-link.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.actionLink', {\n        /**\n         * Button creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind handler on button click\n         * @protected\n         */\n        _bind: function () {\n            var keyCode = $.ui.keyCode;\n\n            this._on({\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mousedown: function (e) {\n                    this._stopPropogation(e);\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mouseup: function (e) {\n                    this._stopPropogation(e);\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                click: function (e) {\n                    this._stopPropogation(e);\n                    this._triggerEvent();\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                keydown: function (e) {\n                    switch (e.keyCode) {\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._stopPropogation(e);\n                            this._triggerEvent();\n                            break;\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                keyup: function (e) {\n                    switch (e.keyCode) {\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._stopPropogation(e);\n                            break;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @private\n         */\n        _stopPropogation: function (e) {\n            e.stopImmediatePropagation();\n            e.preventDefault();\n        },\n\n        /**\n         * @private\n         */\n        _triggerEvent: function () {\n            $(this.options.related || this.element)\n                .trigger(this.options.event, this.options.eventData ? [this.options.eventData] : [{}]);\n        }\n    });\n\n    return $.mage.actionLink;\n});\n","mage/backend/notification.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.notification', {\n        options: {\n            templates: {\n                global: '<div data-role=\"messages\" id=\"messages\">' +\n                    '<div class=\"message <% if (data.error) { %>error<% } %>\"><div><%- data.message %></div></div>' +\n                '</div>',\n                error: '<div data-role=\"messages\" id=\"messages\">' +\n                    '<div class=\"messages\"><div class=\"message message-error error\">' +\n                        '<div data-ui-id=\"messages-message-error\"><%- data.message %></div></div>' +\n                    '</div></div>'\n            }\n        },\n        placeholder: '[data-role=messages]',\n\n        /**\n         * Notification creation\n         * @protected\n         */\n        _create: function () {\n            $(document).on('ajaxComplete ajaxError', $.proxy(this._add, this));\n        },\n\n        /**\n         * Add new message\n         * @protected\n         * @param {Object} event - object\n         * @param {Object} jqXHR - The jQuery XMLHttpRequest object returned by $.ajax()\n         */\n        _add: function (event, jqXHR) {\n            var response;\n\n            try {\n                response = JSON.parse(jqXHR.responseText);\n\n                if (response && response.error && response['html_message']) {\n                    $(this.placeholder).html(response['html_message']);\n                }\n            } catch (e) {}\n        },\n\n        /**\n         * Adds new message.\n         *\n         * @param {Object} data - Data with a message to be displayed.\n         */\n        add: function (data) {\n            var template = data.error ? this.options.templates.error : this.options.templates.global,\n                message = mageTemplate(template, {\n                    data: data\n                }),\n                messageContainer;\n\n            if (typeof data.insertMethod === 'function') {\n                data.insertMethod(message);\n            } else {\n                messageContainer = data.messageContainer || this.placeholder;\n                $(messageContainer).prepend(message);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes error messages.\n         */\n        clear: function () {\n            $(this.placeholder).html('');\n        }\n    });\n\n    return $.mage.notification;\n});\n","mage/backend/tree-suggest.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree',\n    'mage/backend/suggest'\n], function ($) {\n    'use strict';\n\n    /* jscs:disable requireCamelCaseOrUpperCaseIdentifiers */\n    var hover_node, dehover_node, select_node, init;\n\n    $.extend(true, $, {\n        // @TODO: Move method 'treeToList' in file with utility functions\n        mage: {\n            /**\n             * @param {Array} list\n             * @param {Object} nodes\n             * @param {*} level\n             * @param {*} path\n             * @return {*}\n             */\n            treeToList: function (list, nodes, level, path) {\n                $.each(nodes, function () {\n                    if (typeof this === 'object') {\n                        list.push({\n                            label: this.label,\n                            id: this.id,\n                            level: level,\n                            item: this,\n                            path: path + this.label\n                        });\n\n                        if (this.children) {\n                            $.mage.treeToList(list, this.children, level + 1, path + this.label + ' / ');\n                        }\n                    }\n                });\n\n                return list;\n            }\n        }\n    });\n\n    hover_node = $.jstree.core.prototype.hover_node;\n    dehover_node = $.jstree.core.prototype.dehover_node;\n    select_node = $.jstree.core.prototype.select_node;\n    init = $.jstree.core.prototype.init;\n\n    $.extend(true, $.jstree.core.prototype, {\n        /**\n         * @override\n         */\n        init: function () {\n            this.get_container()\n                .show()\n                .on('keydown', $.proxy(function (e) {\n                    var o;\n\n                    if (e.keyCode === $.ui.keyCode.ENTER) {\n                        o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n                        this.select_node(o, true);\n                    }\n                }, this));\n            init.call(this);\n        },\n\n        /**\n         * @override\n         */\n        hover_node: function (obj) {\n            hover_node.apply(this, arguments);\n            obj = this._get_node(obj);\n\n            if (!obj.length) {\n                return false;\n            }\n            this.get_container().trigger('hover_node', [{\n                item: obj.find('a:first')\n            }]);\n        },\n\n        /**\n         * @override\n         */\n        dehover_node: function () {\n            dehover_node.call(this);\n            this.get_container().trigger('dehover_node');\n        },\n\n        /**\n         * @override\n         */\n        select_node: function (o) {\n            var node;\n\n            select_node.apply(this, arguments);\n            node = this._get_node(o);\n\n            (node ? $(node) : this.data.ui.last_selected)\n                .trigger('select_tree_node');\n        }\n    });\n\n    $.widget('mage.treeSuggest', $.mage.suggest, {\n        widgetEventPrefix: 'suggest',\n        options: {\n            template:\n                '<% if (data.items.length) { %>' +\n                    '<% if (data.allShown()) { %>' +\n                        '<% if (typeof data.nested === \"undefined\") { %>' +\n                            '<div style=\"display:none;\" data-mage-init=\"{&quot;jstree&quot;:{&quot;plugins&quot;:[&quot;themes&quot;,&quot;html_data&quot;,&quot;ui&quot;,&quot;hotkeys&quot;],&quot;themes&quot;:{&quot;theme&quot;:&quot;default&quot;,&quot;dots&quot;:false,&quot;icons&quot;:false}}}\">' + //eslint-disable-line max-len\n                        '<% } %>' +\n                        '<ul>' +\n                            '<% _.each(data.items, function(value) { %>' +\n                                '<li class=\"<% if (data.itemSelected(value)) { %>mage-suggest-selected<% } %>' +\n                '                   <% if (value.is_active == 0) { %> mage-suggest-not-active<% } %>\">' +\n                                    '<a href=\"#\" <%= data.optionData(value) %>><%- value.label %></a>' +\n                                    '<% if (value.children && value.children.length) { %>' +\n                                        '<%= data.renderTreeLevel(value.children) %>' +\n                                    '<% } %>' +\n                                '</li>' +\n                            '<% }); %>' +\n                        '</ul>' +\n                        '<% if (typeof data.nested === \"undefined\") { %>' +\n                            '</div>' +\n                        '<% } %>' +\n                    '<% } else { %>' +\n                        '<ul data-mage-init=\"{&quot;menu&quot;:[]}\">' +\n                            '<% _.each(data.items, function(value) { %>' +\n                                '<% if (!data.itemSelected(value)) {%>' +\n                                    '<li <%= data.optionData(value) %>>' +\n                                        '<a href=\"#\">' +\n                                            '<span class=\"category-label\"><%- value.label %></span>' +\n                                            '<span class=\"category-path\"><%- value.path %></span>' +\n                                        '</a>' +\n                                    '</li>' +\n                                '<% } %>' +\n                            '<% }); %>' +\n                        '</ul>' +\n                    '<% } %>' +\n                '<% } else { %>' +\n                    '<span class=\"mage-suggest-no-records\"><%- data.noRecordsText %></span>' +\n                '<% } %>',\n            controls: {\n                selector: ':ui-menu, :mage-menu, .jstree',\n                eventsMap: {\n                    focus: ['menufocus', 'hover_node'],\n                    blur: ['menublur', 'dehover_node'],\n                    select: ['menuselect', 'select_tree_node']\n                }\n            }\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keydown: function (event) {\n                    var keyCode = $.ui.keyCode;\n\n                    switch (event.keyCode) {\n                        case keyCode.LEFT:\n                        case keyCode.RIGHT:\n\n                            if (this.isDropdownShown()) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n                            break;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        close: function (e) {\n            var eType = e ? e.type : null;\n\n            if (eType === 'select_tree_node') {\n                this.element.focus();\n            } else {\n                this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _filterSelected: function (items, context) {\n            if (context._allShown) {\n                return items;\n            }\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * @override\n         */\n        _prepareDropdownContext: function () {\n            var context = this._superApply(arguments),\n                optionData = context.optionData,\n                templates = this.templates,\n                tmplName = this.templateName;\n\n            /**\n             * @param {Object} item\n             * @return {*|String}\n             */\n            context.optionData = function (item) {\n                item = $.extend({}, item);\n                delete item.children;\n\n                return optionData(item);\n            };\n\n            return $.extend(context, {\n                /**\n                 * @param {*} children\n                 * @return {*|jQuery}\n                 */\n                renderTreeLevel: function (children) {\n                    var _context = $.extend({}, this, {\n                        items: children,\n                        nested: true\n                    }),\n                    tmpl = templates[tmplName];\n\n                    tmpl = tmpl({\n                        data: _context\n                    });\n\n                    return $('<div>').append($(tmpl)).html();\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        _processResponse: function (e, items, context) {\n            var control;\n\n            if (context && !context._allShown) {\n                items = this.filter($.mage.treeToList([], items, 0, ''), this._term);\n            }\n            control = this.dropdown.find(this._control.selector);\n\n            if (control.length && control.hasClass('jstree')) {\n                control.jstree('destroy');\n            }\n            this._superApply([e, items, context]);\n        }\n    });\n\n    return $.mage.treeSuggest;\n});\n","mage/backend/tabs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/ui-modules/widgets/tabs'\n], function ($) {\n    'use strict';\n\n    var rhash, isLocal;\n\n    // mage.tabs base functionality\n    $.widget('mage.tabs', $.ui.tabs, {\n        options: {\n            spinner: false,\n            groups: null,\n            tabPanelClass: '',\n            excludedPanel: ''\n        },\n\n        /**\n         * Tabs creation\n         * @protected\n         */\n        _create: function () {\n            var activeIndex = this._getTabIndex(this.options.active);\n\n            this.options.active = activeIndex >= 0 ? activeIndex : 0;\n            this._super();\n        },\n\n        /**\n         * @override\n         * @private\n         * @return {Array} Array of DOM-elements\n         */\n        _getList: function () {\n            if (this.options.groups) {\n                return this.element.find(this.options.groups);\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Get active anchor\n         * @return {Element}\n         */\n        activeAnchor: function () {\n            return this.anchors.eq(this.option('active'));\n        },\n\n        /**\n         * Get tab index by tab id\n         * @protected\n         * @param {String} id - id of tab\n         * @return {Number}\n         */\n        _getTabIndex: function (id) {\n            var anchors = this.anchors ?\n                this.anchors :\n                this._getList().find('> li > a[href]');\n\n            return anchors.index($('#' + id));\n        },\n\n        /**\n         * Switch between tabs\n         * @protected\n         * @param {Object} event - event object\n         * @param {undefined|Object} eventData\n         */\n        _toggle: function (event, eventData) {\n            var anchor = $(eventData.newTab).find('a');\n\n            if ($(eventData.newTab).find('a').data().tabType === 'link') {\n                location.href = anchor.prop('href');\n            } else {\n                this._superApply(arguments);\n            }\n        }\n    });\n\n    rhash = /#.*$/;\n\n    /**\n     * @param {*} anchor\n     * @return {Boolean}\n     */\n    isLocal = function (anchor) {\n        return anchor.hash.length > 1 &&\n            anchor.href.replace(rhash, '') ===\n                location.href.replace(rhash, '')\n                    // support: Safari 5.1\n                    // Safari 5.1 doesn't encode spaces in window.location\n                    // but it does encode spaces from anchors (#8777)\n                    .replace(/\\s/g, '%20');\n    };\n\n    // Extension for mage.tabs - Move panels in destination element\n    $.widget('mage.tabs', $.mage.tabs, {\n        /**\n         * Move panels in destination element on creation\n         * @protected\n         * @override\n         */\n        _create: function () {\n            this._super();\n            this._movePanelsInDestination(this.panels);\n        },\n\n        /**\n         * Get panel for tab. If panel no exist in tabs container, then find panel in destination element\n         * @protected\n         * @override\n         * @param {Element} tab - tab \"li\" DOM-element\n         * @return {Element}\n         */\n        _getPanelForTab: function (tab) {\n            var panel = this._superApply(arguments),\n                id;\n\n            if (!panel.length) {\n                id = $(tab).attr('aria-controls');\n                panel = $(this.options.destination).find(this._sanitizeSelector('#' + id));\n            }\n\n            return panel;\n        },\n\n        /**\n         * @private\n         */\n        _processTabs: function () {\n            var that = this;\n\n            this.tablist = this._getList()\n                .addClass('ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all')\n                .attr('role', 'tablist');\n\n            this.tabs = this.tablist.find('> li:has(a[href])')\n                .addClass('ui-state-default ui-corner-top')\n                .attr({\n                    role: 'tab',\n                    tabIndex: -1\n                });\n\n            this.anchors = this.tabs.map(function () {\n                return $('a', this)[ 0 ];\n            })\n                .addClass('ui-tabs-anchor')\n                .attr({\n                    role: 'presentation',\n                    tabIndex: -1\n                });\n\n            this.panels = $();\n\n            this.anchors.each(function (i, anchor) {\n                var selector, panel, panelId,\n                    anchorId = $(anchor).uniqueId().attr('id'),\n                    tab = $(anchor).closest('li'),\n                    originalAriaControls = tab.attr('aria-controls');\n\n                // inline tab\n                if (isLocal(anchor)) {\n                    selector = anchor.hash;\n                    panel = that.document.find(that._sanitizeSelector(selector));\n                    // remote tab\n                } else {\n                    panelId = tab.attr('aria-controls') || $({}).uniqueId()[ 0 ].id;\n                    selector = '#' + panelId;\n                    panel = that.element.find(selector);\n\n                    if (!panel.length) {\n                        panel = that._createPanel(panelId);\n                        panel.insertAfter(that.panels[ i - 1 ] || that.tablist);\n                    }\n                    panel.attr('aria-live', 'polite');\n                }\n\n                if (panel.length) {\n                    that.panels = that.panels.add(panel);\n                }\n\n                if (originalAriaControls) {\n                    tab.data('ui-tabs-aria-controls', originalAriaControls);\n                }\n                tab.attr({\n                    'aria-controls': selector.substring(1),\n                    'aria-labelledby': anchorId\n                });\n                panel.attr('aria-labelledby', anchorId);\n\n                if (that.options.excludedPanel.indexOf(anchorId + '_content') < 0) {\n                    panel.addClass(that.options.tabPanelClass);\n                }\n            });\n\n            this.panels\n                .addClass('ui-tabs-panel ui-widget-content ui-corner-bottom')\n                .attr('role', 'tabpanel');\n        },\n\n        /**\n         * Move panels in destination element\n         * @protected\n         * @override\n         */\n        _movePanelsInDestination: function (panels) {\n            if (this.options.destination && !panels.parents(this.options.destination).length) {\n                this.element.trigger('beforePanelsMove', panels);\n\n                panels.find('script:not([type]), script[type=\"text/javascript\"]').remove();\n\n                panels.appendTo(this.options.destination)\n                    .each($.proxy(function (i, panel) {\n                        $(panel).trigger('move.tabs', this.anchors.eq(i));\n                    }, this));\n            }\n        },\n\n        /**\n         * Move panels in destination element on tabs switching\n         * @protected\n         * @override\n         * @param {Object} event - event object\n         * @param {Object} eventData\n         */\n        _toggle: function (event, eventData) {\n            this._movePanelsInDestination(eventData.newPanel);\n            this._superApply(arguments);\n        }\n    });\n\n    // Extension for mage.tabs - Ajax functionality for tabs\n    $.widget('mage.tabs', $.mage.tabs, {\n        options: {\n            /**\n             * Add form key to ajax call\n             * @param {Object} event - event object\n             * @param {Object} ui\n             */\n            beforeLoad: function (event, ui) {\n                ui.ajaxSettings.type = 'POST';\n                ui.ajaxSettings.hasContent = true;\n                ui.jqXHR.setRequestHeader('Content-Type', ui.ajaxSettings.contentType);\n                ui.ajaxSettings.data = jQuery.param(\n                    {\n                        isAjax: true,\n                        'form_key': typeof FORM_KEY !== 'undefined' ? FORM_KEY : null\n                    },\n                    ui.ajaxSettings.traditional\n                );\n            },\n\n            /**\n             * Replacing href attribute with loaded panel id\n             * @param {Object} event - event object\n             * @param {Object} ui\n             */\n            load: function (event, ui) {\n                var panel = $(ui.panel);\n\n                $(ui.tab).prop('href', '#' + panel.prop('id'));\n                panel.trigger('contentUpdated');\n            }\n        }\n    });\n\n    // Extension for mage.tabs - Attach event handlers to tabs\n    $.widget('mage.tabs', $.mage.tabs, {\n        options: {\n            tabIdArgument: 'tab',\n            tabsBlockPrefix: null\n        },\n\n        /**\n         * Attach event handlers to tabs, on creation\n         * @protected\n         * @override\n         */\n        _refresh: function () {\n            this._super();\n            $.each(this.tabs, $.proxy(function (i, tab) {\n                $(this._getPanelForTab(tab))\n                    .off('changed' + this.eventNamespace)\n                    .off('highlight.validate' + this.eventNamespace)\n                    .off('focusin' + this.eventNamespace)\n\n                    .on('changed' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onContentChange, this))\n                    .on('highlight.validate' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onInvalid, this))\n                    .on('focusin' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onFocus, this));\n            }, this));\n\n            ($(this.options.destination).is('form') ?\n                $(this.options.destination) :\n                $(this.options.destination).closest('form'))\n                    .off('beforeSubmit' + this.eventNamespace)\n                    .on('beforeSubmit' + this.eventNamespace, $.proxy(this._onBeforeSubmit, this));\n        },\n\n        /**\n         * Mark tab as changed if some field inside tab panel is changed\n         * @protected\n         * @param {Object} e - event object\n         */\n        _onContentChange: function (e) {\n            var cssChanged = '_changed';\n\n            this.anchors.eq(e.data.index).addClass(cssChanged);\n            this._updateNavTitleMessages(e, cssChanged);\n        },\n\n        /**\n         * Clone messages (tooltips) from anchor to parent element\n         * @protected\n         * @param {Object} e - event object\n         * @param {String} messageType - changed or error\n         */\n        _updateNavTitleMessages: function (e, messageType) {\n            var curAnchor = this.anchors.eq(e.data.index),\n                curItem = curAnchor.parents('[data-role=\"container\"]').find('[data-role=\"title\"]'),\n                curItemMessages = curItem.find('[data-role=\"title-messages\"]'),\n                activeClass = '_active';\n\n            if (curItemMessages.is(':empty')) {\n                curAnchor\n                    .find('[data-role=\"item-messages\"]')\n                    .clone()\n                    .appendTo(curItemMessages);\n            }\n\n            curItemMessages.find('.' + messageType).addClass(activeClass);\n        },\n\n        /**\n         * Mark tab as error if some field inside tab panel is not passed validation\n         * @param {Object} e - event object\n         * @protected\n         */\n        _onInvalid: function (e) {\n            var cssError = '_error',\n                fakeEvent = e;\n\n            fakeEvent.currentTarget = $(this.anchors).eq(e.data.index);\n            this._eventHandler(fakeEvent);\n            this.anchors.eq(e.data.index).addClass(cssError).find('.' + cssError).show();\n            this._updateNavTitleMessages(e, cssError);\n        },\n\n        /**\n         * Show tab panel if focus event triggered of some field inside tab panel\n         * @param {Object} e - event object\n         * @protected\n         */\n        _onFocus: function (e) {\n            this.option('_active', e.data.index);\n        },\n\n        /**\n         * Add active tab id in data object when \"beforeSubmit\" event is triggered\n         * @param {Object} e - event object\n         * @param {Object} data - event data object\n         * @protected\n         */\n        _onBeforeSubmit: function (e, data) { //eslint-disable-line no-unused-vars\n            var activeAnchor = this.activeAnchor(),\n                activeTabId = activeAnchor.prop('id'),\n                options;\n\n            if (this.options.tabsBlockPrefix) {\n                if (activeAnchor.is('[id*=\"' + this.options.tabsBlockPrefix + '\"]')) {\n                    activeTabId = activeAnchor.prop('id').substr(this.options.tabsBlockPrefix.length);\n                }\n            }\n            $(this.anchors).removeClass('error');\n            options = {\n                action: {\n                    args: {}\n                }\n            };\n            options.action.args[this.options.tabIdArgument] = activeTabId;\n        }\n    });\n\n    // Extension for mage.tabs - Shadow tabs functionality\n    $.widget('mage.tabs', $.mage.tabs, {\n        /**\n         * Add shadow tabs functionality on creation\n         * @protected\n         * @override\n         */\n        _refresh: function () {\n            var anchors, shadowTabs, tabs;\n\n            this._super();\n            anchors = this.anchors;\n            shadowTabs = this.options.shadowTabs;\n            tabs = this.tabs;\n\n            if (shadowTabs) {\n                anchors.each($.proxy(function (i, anchor) {\n                    var anchorId = $(anchor).prop('id');\n\n                    if (shadowTabs[anchorId]) {\n                        $(anchor).parents('li').on('click', $.proxy(function () {\n                            $.each(shadowTabs[anchorId], $.proxy(function (key, id) {\n                                this.load($(tabs).index($('#' + id).parents('li')), {});\n                            }, this));\n                        }, this));\n                    }\n                }, this));\n            }\n        }\n    });\n\n    return $.mage.tabs;\n});\n","mage/adminhtml/accordion.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global varienAccordion, varienLoader, Cookie */\n/* eslint-disable strict */\ndefine([\n    'prototype'\n], function () {\n    window.varienAccordion = new Class.create(); //eslint-disable-line\n    varienAccordion.prototype = {\n        /**\n         * @param {*} containerId\n         * @param {*} activeOnlyOne\n         */\n        initialize: function (containerId, activeOnlyOne) {\n            var links, i;\n\n            this.containerId = containerId;\n            this.activeOnlyOne = activeOnlyOne || false;\n            this.container = $(this.containerId);\n            this.items = $$('#' + this.containerId + ' dt');\n            this.loader = new varienLoader(true); //jscs:ignore requireCapitalizedConstructors\n\n            links = $$('#' + this.containerId + ' dt a');\n\n            for (i in links) {\n                if (links[i].href) {\n                    Event.observe(links[i], 'click', this.clickItem.bind(this));\n                    this.items[i].dd = this.items[i].next('dd');\n                    this.items[i].link = links[i];\n                }\n            }\n\n            this.initFromCookie();\n        },\n\n        /**\n         * Init from cookie.\n         */\n        initFromCookie: function () {\n            var activeItemId, visibility;\n\n            if (this.activeOnlyOne &&\n                (activeItemId = Cookie.read(this.cookiePrefix() + 'active-item')) !== null) {\n                this.hideAllItems();\n                this.showItem(this.getItemById(activeItemId));\n            } else if (!this.activeOnlyOne) {\n                this.items.each(function (item) {\n                    if ((visibility = Cookie.read(this.cookiePrefix() + item.id)) !== null) {\n                        if (visibility == 0) { //eslint-disable-line eqeqeq\n                            this.hideItem(item);\n                        } else {\n                            this.showItem(item);\n                        }\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @return {String}\n         */\n        cookiePrefix: function () {\n            return 'accordion-' + this.containerId + '-';\n        },\n\n        /**\n         * @param {*} itemId\n         * @return {*}\n         */\n        getItemById: function (itemId) {\n            var result = null;\n\n            this.items.each(function (item) {\n                if (item.id == itemId) { //eslint-disable-line\n                    result = item;\n                    throw $break;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {*} event\n         */\n        clickItem: function (event) {\n            var item = Event.findElement(event, 'dt');\n\n            if (this.activeOnlyOne) {\n                this.hideAllItems();\n                this.showItem(item);\n                Cookie.write(this.cookiePrefix() + 'active-item', item.id, 30 * 24 * 60 * 60);\n            } else {\n                if (this.isItemVisible(item)) { //eslint-disable-line no-lonely-if\n                    this.hideItem(item);\n                    Cookie.write(this.cookiePrefix() + item.id, 0, 30 * 24 * 60 * 60);\n                } else {\n                    this.showItem(item);\n                    Cookie.write(this.cookiePrefix() + item.id, 1, 30 * 24 * 60 * 60);\n                }\n            }\n            Event.stop(event);\n        },\n\n        /**\n         * @param {Object} item\n         */\n        showItem: function (item) {\n            if (item && item.link) {\n                if (item.link.href) {\n                    this.loadContent(item);\n                }\n\n                Element.addClassName(item, 'open');\n                Element.addClassName(item.dd, 'open');\n            }\n        },\n\n        /**\n         * @param {Object} item\n         */\n        hideItem: function (item) {\n            Element.removeClassName(item, 'open');\n            Element.removeClassName(item.dd, 'open');\n        },\n\n        /**\n         * @param {*} item\n         * @return {*}\n         */\n        isItemVisible: function (item) {\n            return Element.hasClassName(item, 'open');\n        },\n\n        /**\n         * @param {*} item\n         */\n        loadContent: function (item) {\n            if (item.link.href.indexOf('#') == item.link.href.length - 1) { //eslint-disable-line eqeqeq\n                return;\n            }\n\n            if (Element.hasClassName(item.link, 'ajax')) {\n                this.loadingItem = item;\n                this.loader.load(item.link.href, {\n                    updaterId: this.loadingItem.dd.id\n                }, this.setItemContent.bind(this));\n\n                return;\n            }\n            location.href = item.link.href;\n        },\n\n        /**\n         * @param {Object} content\n         */\n        setItemContent: function (content) {\n            if (content.isJSON) {\n                return;\n            }\n            this.loadingItem.dd.innerHTML = content;\n        },\n\n        /**\n         * Hide all items\n         */\n        hideAllItems: function () {\n            var i;\n\n            for (i in this.items) {\n                if (this.items[i].id) {\n                    Element.removeClassName(this.items[i], 'open');\n                    Element.removeClassName(this.items[i].dd, 'open');\n                }\n            }\n        }\n    };\n});\n","mage/adminhtml/grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// also depends on a mage/adminhtml/tools.js for Base64 encoding\n/* global varienGrid, setLocation, varienGlobalEvents, FORM_KEY,\n    BASE_URL, Base64, varienGridMassaction, varienStringArray, serializerController\n*/\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'mage/mage',\n    'prototype',\n    'mage/adminhtml/form',\n    'mage/adminhtml/events'\n], function (jQuery, mageTemplate, alert, confirm) {\n    /**\n     * @param {*} grid\n     * @param {*} event\n     */\n    function openGridRow(grid, event) {\n        var element = Event.findElement(event, 'tr');\n\n        if (['a', 'input', 'select', 'option'].indexOf(Event.element(event).tagName.toLowerCase()) !== -1) {\n            return;\n        }\n\n        if (element.title) {\n            setLocation(element.title);\n        }\n    }\n    window.openGridRow = openGridRow;\n\n    window.varienGrid = new Class.create();\n\n    varienGrid.prototype = {\n        /**\n         * @param {String} containerId\n         * @param {String} url\n         * @param {*} pageVar\n         * @param {*} sortVar\n         * @param {*} dirVar\n         * @param {*} filterVar\n         */\n        initialize: function (containerId, url, pageVar, sortVar, dirVar, filterVar) {\n            this.containerId = containerId;\n            jQuery('#' + containerId).data('gridObject', this);\n            this.url = url;\n            this.pageVar = pageVar || false;\n            this.sortVar = sortVar || false;\n            this.dirVar = dirVar || false;\n            this.filterVar = filterVar || false;\n            this.tableSufix = '_table';\n            this.useAjax = false;\n            this.rowClickCallback = false;\n            this.checkboxCheckCallback = false;\n            this.preInitCallback = false;\n            this.initCallback = false;\n            this.initRowCallback = false;\n            this.doFilterCallback = false;\n            this.sortableUpdateCallback = false;\n            this.targetElement = undefined;\n            this.filterKeyPressCallback = false;\n\n            this.reloadParams = false;\n\n            this.trOnMouseOver = this.rowMouseOver.bindAsEventListener(this);\n            this.trOnMouseOut = this.rowMouseOut.bindAsEventListener(this);\n            this.trOnMouseDown = this.rowMouseDown.bindAsEventListener(this);\n            this.trOnClick = this.rowMouseClick.bindAsEventListener(this);\n            this.trOnDblClick = this.rowMouseDblClick.bindAsEventListener(this);\n            this.trOnKeyPress = this.keyPress.bindAsEventListener(this);\n\n            this.thLinkOnClick = this.doSort.bindAsEventListener(this);\n            this.initGrid();\n        },\n\n        /**\n         * Init grid.\n         */\n        initGrid: function () {\n            var row, columns, col;\n\n            if (this.preInitCallback) {\n                this.preInitCallback(this);\n            }\n\n            if ($(this.containerId + this.tableSufix)) {\n                this.rows = $$('#' + this.containerId + this.tableSufix + ' tbody tr');\n\n                for (row = 0; row < this.rows.length; row++) {\n                    if (row % 2 == 0) { //eslint-disable-line eqeqeq, max-depth\n                        Element.addClassName(this.rows[row], 'even');\n                    }\n\n                    Event.observe(this.rows[row], 'mouseover', this.trOnMouseOver);\n                    Event.observe(this.rows[row], 'mouseout', this.trOnMouseOut);\n                    Event.observe(this.rows[row], 'mousedown', this.trOnMouseDown);\n                    Event.observe(this.rows[row], 'click', this.trOnClick);\n                    Event.observe(this.rows[row], 'dblclick', this.trOnDblClick);\n                }\n            }\n\n            if (this.sortVar && this.dirVar) {\n                columns = $$('#' + this.containerId + this.tableSufix + ' thead [data-sort]');\n\n                for (col = 0; col < columns.length; col++) {\n                    Event.observe(columns[col], 'click', this.thLinkOnClick);\n                }\n            }\n            this.bindFilterFields();\n            this.bindFieldsChange();\n\n            if (this.initCallback) {\n                try {\n                    this.initCallback(this);\n                } catch (e) {\n                    if (window.console) { //eslint-disable-line max-depth\n                        console.log(e);\n                    }\n                }\n            }\n            jQuery('#' + this.containerId).trigger('gridinit', this);\n        },\n\n        /**\n         * Init grid ajax.\n         */\n        initGridAjax: function () {\n            this.initGrid();\n            this.initGridRows();\n        },\n\n        /**\n         * Init grid rows.\n         */\n        initGridRows: function () {\n            var row;\n\n            if (this.initRowCallback) {\n                for (row = 0; row < this.rows.length; row++) {\n                    try { //eslint-disable-line max-depth\n                        this.initRowCallback(this, this.rows[row]);\n                    } catch (e) {\n                        if (window.console) { //eslint-disable-line max-depth\n                            console.log(e);\n                        }\n                    }\n                }\n            }\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseOver: function (event) {\n            var element = Event.findElement(event, 'tr');\n\n            if (!element.title) {\n                return;\n            }\n\n            Element.addClassName(element, 'on-mouse');\n\n            if (!Element.hasClassName('_clickable') && (this.rowClickCallback !== openGridRow || element.title)) {\n                if (element.title) {\n                    Element.addClassName(element, '_clickable');\n                }\n            }\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseOut: function (event) {\n            var element = Event.findElement(event, 'tr');\n\n            Element.removeClassName(element, 'on-mouse');\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseDown: function (event) {\n            this.targetElement = event.target;\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseClick: function (event) {\n            if (this.rowClickCallback) {\n                try {\n                    this.rowClickCallback(this, event);\n                } catch (e) {\n                }\n            }\n            varienGlobalEvents.fireEvent('gridRowClick', event);\n            this.targetElement = undefined;\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseDblClick: function (event) {\n            varienGlobalEvents.fireEvent('gridRowDblClick', event);\n        },\n\n        /**\n         * Key press.\n         */\n        keyPress: function () {\n        },\n\n        /**\n         * @param {*} event\n         * @return {Boolean}\n         */\n        doSort: function (event) {\n            var element = Event.findElement(event, 'th');\n\n            if (element.readAttribute('data-sort') && element.readAttribute('data-direction')) {\n                this.addVarToUrl(this.sortVar, element.readAttribute('data-sort'));\n                this.addVarToUrl(this.dirVar, element.readAttribute('data-direction'));\n                this.reload(this.url);\n            }\n            Event.stop(event);\n\n            return false;\n        },\n\n        /**\n         * @param {Object} element\n         */\n        loadByElement: function (element) {\n            if (element && element.name) {\n                this.reload(this.addVarToUrl(element.name, element.value));\n            }\n        },\n\n        /**\n         * @param {*} data\n         * @param {*} textStatus\n         * @param {*} transport\n         * @private\n         */\n        _onAjaxSeccess: function (data, textStatus, transport) {\n            var responseText, response, divId;\n\n            /* eslint-disable max-depth */\n            try {\n                responseText = transport.responseText;\n\n                if (transport.responseText.isJSON()) {\n                    response = transport.responseText.evalJSON();\n\n                    if (response.error) {\n                        alert({\n                            content: response.message\n                        });\n                    }\n\n                    if (response.ajaxExpired && response.ajaxRedirect) {\n                        setLocation(response.ajaxRedirect);\n                    }\n                } else {\n\n                    /*eslint-disable max-len*/\n                    /**\n                     * For IE <= 7.\n                     * If there are two elements, and first has name, that equals id of second.\n                     * In this case, IE will choose one that is above\n                     *\n                     * @see https://prototype.lighthouseapp.com/projects/8886/tickets/994-id-selector-finds-elements-by-name-attribute-in-ie7\n                     */\n\n                    /*eslint-enable max-len*/\n                    divId = $(this.containerId);\n\n                    if (divId.id == this.containerId) { //eslint-disable-line eqeqeq\n                        divId.update(responseText);\n                    } else {\n                        $$('div[id=\"' + this.containerId + '\"]')[0].update(responseText);\n                    }\n                }\n            } catch (e) {\n                divId = $(this.containerId);\n\n                if (divId.id == this.containerId) { //eslint-disable-line eqeqeq\n                    divId.update(responseText);\n                } else {\n                    $$('div[id=\"' + this.containerId + '\"]')[0].update(responseText);\n                }\n            }\n\n            /* eslint-enable max-depth */\n            jQuery('#' + this.containerId).trigger('contentUpdated');\n        },\n\n        /**\n         * @param {*} url\n         * @param {Function} onSuccessCallback\n         * @return {*}\n         */\n        reload: function (url, onSuccessCallback) {\n            var ajaxSettings, ajaxRequest;\n\n            this.reloadParams = this.reloadParams || {};\n            this.reloadParams['form_key'] = FORM_KEY;\n            url = url || this.url;\n\n            if (this.useAjax) {\n                ajaxSettings = {\n                    url: url + (url.match(new RegExp('\\\\?')) ? '&ajax=true' : '?ajax=true'),\n                    showLoader: true,\n                    method: 'post',\n                    context: jQuery('#' + this.containerId),\n                    data: this.reloadParams,\n                    error: this._processFailure.bind(this),\n                    complete: this.initGridAjax.bind(this),\n                    dataType: 'html',\n\n                    /**\n                     * Success callback.\n                     */\n                    success: function (data, textStatus, transport) {\n                        this._onAjaxSeccess(data, textStatus, transport);\n\n                        if (onSuccessCallback && typeof onSuccessCallback === 'function') {\n                            // execute the callback, passing parameters as necessary\n                            onSuccessCallback();\n                        }\n                    }.bind(this)\n                };\n                jQuery('#' + this.containerId).trigger('gridajaxsettings', ajaxSettings);\n                ajaxRequest = jQuery.ajax(ajaxSettings);\n                jQuery('#' + this.containerId).trigger('gridajax', ajaxRequest);\n\n                return ajaxRequest;\n            }\n\n            if (this.reloadParams) {\n                $H(this.reloadParams).each(function (pair) {\n                    url = this.addVarToUrl(pair.key, pair.value);\n                }.bind(this));\n            }\n            location.href = url;\n        },\n\n        /**\n         * @private\n         */\n        _processFailure: function () {\n            location.href = BASE_URL;\n        },\n\n        /**\n         * @param {*} url\n         * @param {*} varName\n         * @param {*} varValue\n         * @return {String|*}\n         * @private\n         */\n        _addVarToUrl: function (url, varName, varValue) {\n            var re = new RegExp('\\/(' + varName + '\\/.*?\\/)'),\n                parts = url.split(new RegExp('\\\\?'));\n\n            url = parts[0].replace(re, '/');\n            url += varName + '/' + varValue + '/';\n\n            if (parts.size() > 1) {\n                url += '?' + parts[1];\n            }\n\n            return url;\n        },\n\n        /**\n         * Builds the form with fields containing the and submits\n         *\n         * @param {String} url\n         * @param {String} varName\n         * @param {String} varValue\n         * @private\n         */\n        _buildFormAndSubmit: function (url, varName, varValue) {\n            var re = new RegExp('\\/(' + varName + '\\/.*?\\/)'),\n                parts = url.split(new RegExp('\\\\?')),\n                form = jQuery('<form></form>'),\n                inputProps = [\n                    {\n                        name: varName,\n                        value: varValue\n                    },\n                    {\n                        name: 'form_key',\n                        value: window.FORM_KEY\n                    }\n                ],\n                input;\n\n            url = parts[0].replace(re, '/');\n\n            if (parts.size() > 1) {\n                url += '?' + parts[1];\n            }\n\n            form.attr('action', url);\n            form.attr('method', 'POST');\n\n            inputProps.forEach(function (item) {\n                input = jQuery('<input/>');\n                input.attr('name', item.name);\n                input.attr('type', 'hidden');\n                input.val(item.value);\n                form.append(input);\n            });\n            jQuery('[data-container=\"body\"]').append(form);\n            form.submit();\n            form.remove();\n        },\n\n        /**\n         * @param {*} varName\n         * @param {*} varValue\n         * @return {*|String}\n         */\n        addVarToUrl: function (varName, varValue) {\n            this.url = this._addVarToUrl(this.url, varName, varValue);\n\n            return this.url;\n        },\n\n        /**\n         * Do export.\n         */\n        doExport: function () {\n            var exportUrl;\n\n            if ($(this.containerId + '_export')) {\n                exportUrl = $(this.containerId + '_export').value;\n\n                if (this.massaction && this.massaction.checkedString) {\n                    this._buildFormAndSubmit(\n                        exportUrl,\n                        this.massaction.formFieldNameInternal,\n                        this.massaction.checkedString\n                    );\n                } else {\n                    location.href = exportUrl;\n                }\n            }\n        },\n\n        /**\n         * Bind filter fields.\n         */\n        bindFilterFields: function () {\n            var filters = $$(\n                '#' + this.containerId + ' [data-role=\"filter-form\"] input',\n                '#' + this.containerId + ' [data-role=\"filter-form\"] select'\n                ),\n                i;\n\n            for (i = 0; i < filters.length; i++) {\n                Event.observe(filters[i], 'keypress', this.filterKeyPress.bind(this));\n            }\n        },\n\n        /**\n         * Bind field change.\n         */\n        bindFieldsChange: function () {\n            var dataElements, i;\n\n            if (!$(this.containerId)) {\n                return;\n            }\n            //var dataElements = $(this.containerId+this.tableSufix).down('.data tbody').select('input', 'select');\n            // eslint-disable-next-line jquery-no-input-event-shorthand\n            dataElements = $(this.containerId + this.tableSufix).down('tbody').select('input', 'select');\n\n            for (i = 0; i < dataElements.length; i++) {\n                Event.observe(dataElements[i], 'change', dataElements[i].setHasChanges.bind(dataElements[i]));\n            }\n        },\n\n        /**\n         * Bind sortable.\n         */\n        bindSortable: function () {\n            if (jQuery('#' + this.containerId).find('.draggable-handle').length) {\n                jQuery('#' + this.containerId).find('tbody').sortable({\n                    axis: 'y',\n                    handle: '.draggable-handle',\n\n                    /**\n                     * @param {*} event\n                     * @param {*} ui\n                     * @return {*}\n                     */\n                    helper: function (event, ui) {\n                        ui.children().each(function () {\n                            jQuery(this).width(jQuery(this).width());\n                        });\n\n                        return ui;\n                    },\n                    update: this.sortableUpdateCallback ? this.sortableUpdateCallback : function () {\n                    },\n                    tolerance: 'pointer'\n                });\n            }\n        },\n\n        /**\n         * @param {Object} event\n         */\n        filterKeyPress: function (event) {\n            if (event.keyCode == Event.KEY_RETURN) { //eslint-disable-line eqeqeq\n                this.doFilter();\n            }\n\n            if (this.filterKeyPressCallback) {\n                this.filterKeyPressCallback(this, event);\n            }\n        },\n\n        /**\n         * @param {Function} callback\n         */\n        doFilter: function (callback) {\n            var filters = $$(\n                '#' + this.containerId + ' [data-role=\"filter-form\"] input',\n                '#' + this.containerId + ' [data-role=\"filter-form\"] select'\n                ),\n                elements = [],\n                i;\n\n            for (i in filters) {\n                if (filters[i].value && filters[i].value.length) {\n                    elements.push(filters[i]);\n                }\n            }\n\n            if (!this.doFilterCallback || this.doFilterCallback && this.doFilterCallback()) {\n                this.reload(\n                    this.addVarToUrl(this.filterVar, Base64.encode(Form.serializeElements(elements))),\n                    callback\n                );\n            }\n        },\n\n        /**\n         * @param {Function} callback\n         */\n        resetFilter: function (callback) {\n            this.reload(this.addVarToUrl(this.filterVar, ''), callback);\n        },\n\n        /**\n         * @param {Object} element\n         */\n        checkCheckboxes: function (element) {\n            var elements = Element.select($(this.containerId), 'input[name=\"' + element.name + '\"]'),\n                i;\n\n            for (i = 0; i < elements.length; i++) {\n                this.setCheckboxChecked(elements[i], element.checked);\n            }\n\n            /*eslint-enable no-undef*/\n        },\n\n        /**\n         *\n         * @param {HTMLElement} element\n         * @param {*} checked\n         */\n        setCheckboxChecked: function (element, checked) {\n            element.checked = checked;\n            jQuery(element).trigger('change');\n            element.setHasChanges({});\n\n            if (this.checkboxCheckCallback) {\n                this.checkboxCheckCallback(this, element, checked);\n            }\n        },\n\n        /**\n         * @param {Object} event\n         * @param {*} lastId\n         */\n        inputPage: function (event, lastId) {\n            var element = Event.element(event),\n                keyCode = event.keyCode || event.which,\n                enteredValue = parseInt(element.value, 10),\n                pageId = parseInt(lastId, 10);\n\n            if (keyCode == Event.KEY_RETURN) { //eslint-disable-line eqeqeq\n                if (enteredValue > pageId) {\n                    this.setPage(pageId);\n                } else {\n                    this.setPage(enteredValue);\n                }\n            }\n\n            /*if(keyCode>47 && keyCode<58){\n\n             }\n             else{\n             Event.stop(event);\n             }*/\n        },\n\n        /**\n         * @param {*} pageNumber\n         */\n        setPage: function (pageNumber) {\n            this.reload(this.addVarToUrl(this.pageVar, pageNumber));\n        }\n    };\n\n    window.varienGridMassaction = Class.create();\n    varienGridMassaction.prototype = {\n        /* Predefined vars */\n        checkedValues: $H({}),\n        checkedString: '',\n        oldCallbacks: {},\n        errorText: '',\n        items: {},\n        gridIds: [],\n        useSelectAll: false,\n        currentItem: false,\n        lastChecked: {\n            left: false,\n            top: false,\n            checkbox: false\n        },\n        fieldTemplate: mageTemplate('<input type=\"hidden\" name=\"<%- name %>\" value=\"<%- value %>\" />'),\n\n        /**\n         * @param {*} containerId\n         * @param {*} grid\n         * @param {*} checkedValues\n         * @param {*} formFieldNameInternal\n         * @param {*} formFieldName\n         */\n        initialize: function (containerId, grid, checkedValues, formFieldNameInternal, formFieldName) {\n            this.setOldCallback('row_click', grid.rowClickCallback);\n            this.setOldCallback('init', grid.initCallback);\n            this.setOldCallback('init_row', grid.initRowCallback);\n            this.setOldCallback('pre_init', grid.preInitCallback);\n\n            this.useAjax = false;\n            this.grid = grid;\n            this.grid.massaction = this;\n            this.containerId = containerId;\n            this.initMassactionElements();\n\n            this.checkedString = checkedValues;\n            this.formFieldName = formFieldName;\n            this.formFieldNameInternal = formFieldNameInternal;\n\n            this.grid.initCallback = this.onGridInit.bind(this);\n            this.grid.preInitCallback = this.onGridPreInit.bind(this);\n            this.grid.initRowCallback = this.onGridRowInit.bind(this);\n            this.grid.rowClickCallback = this.onGridRowClick.bind(this);\n            this.initCheckboxes();\n            this.checkCheckboxes();\n        },\n\n        /**\n         * @param {*} flag\n         */\n        setUseAjax: function (flag) {\n            this.useAjax = flag;\n        },\n\n        /**\n         * @param {*} flag\n         */\n        setUseSelectAll: function (flag) {\n            this.useSelectAll = flag;\n        },\n\n        /**\n         * Init massaction elements.\n         */\n        initMassactionElements: function () {\n            this.container = $(this.containerId);\n            this.multiselect = $(this.containerId + '-mass-select');\n            this.count = $(this.containerId + '-count');\n            this.formHiddens = $(this.containerId + '-form-hiddens');\n            this.formAdditional = $(this.containerId + '-form-additional');\n            this.select = $(this.containerId + '-select');\n            this.form = this.prepareForm();\n            jQuery(this.form).mage('validation');\n            this.select.observe('change', this.onSelectChange.bindAsEventListener(this));\n            this.lastChecked = {\n                left: false,\n                top: false,\n                checkbox: false\n            };\n            this.select.addClassName(this.select.value ? '_selected' : '');\n            this.initMassSelect();\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        prepareForm: function () {\n            var form = $(this.containerId + '-form'),\n                formPlace = null,\n                formElement = this.formHiddens || this.formAdditional;\n\n            if (!formElement) {\n                formElement = this.container.getElementsByTagName('button')[0];\n                formElement && formElement.parentNode;\n            }\n\n            if (!form && formElement) {\n                /* fix problem with rendering form in FF through innerHTML property */\n                form = document.createElement('form');\n                form.setAttribute('method', 'post');\n                form.setAttribute('action', '');\n                form.id = this.containerId + '-form';\n                formPlace = formElement.parentNode;\n                formPlace.parentNode.appendChild(form);\n                form.appendChild(formPlace);\n            }\n\n            return form;\n        },\n\n        /**\n         * @param {Array} gridIds\n         */\n        setGridIds: function (gridIds) {\n            this.gridIds = gridIds;\n            this.updateCount();\n        },\n\n        /**\n         * @return {Array}\n         */\n        getGridIds: function () {\n            return this.gridIds;\n        },\n\n        /**\n         * @param {*} items\n         */\n        setItems: function (items) {\n            this.items = items;\n            this.updateCount();\n        },\n\n        /**\n         * @return {Object}\n         */\n        getItems: function () {\n            return this.items;\n        },\n\n        /**\n         * @param {*} itemId\n         * @return {*}\n         */\n        getItem: function (itemId) {\n            if (this.items[itemId]) {\n                return this.items[itemId];\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {String} callbackName\n         * @return {Function}\n         */\n        getOldCallback: function (callbackName) {\n            return this.oldCallbacks[callbackName] ? this.oldCallbacks[callbackName] : Prototype.emptyFunction;\n        },\n\n        /**\n         * @param {String} callbackName\n         * @param {Function} callback\n         */\n        setOldCallback: function (callbackName, callback) {\n            this.oldCallbacks[callbackName] = callback;\n        },\n\n        /**\n         * @param {*} grid\n         */\n        onGridPreInit: function (grid) {\n            this.initMassactionElements();\n            this.getOldCallback('pre_init')(grid);\n        },\n\n        /**\n         * @param {*} grid\n         */\n        onGridInit: function (grid) {\n            this.initCheckboxes();\n            this.checkCheckboxes();\n            this.updateCount();\n            this.getOldCallback('init')(grid);\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} row\n         */\n        onGridRowInit: function (grid, row) {\n            this.getOldCallback('init_row')(grid, row);\n        },\n\n        /**\n         * @param {Object} evt\n         */\n        isDisabled: function (evt) {\n            var target = jQuery(evt.target),\n                tr,\n                checkbox;\n\n            tr = target.is('tr') ? target : target.closest('tr');\n            checkbox = tr.find('input[type=\"checkbox\"]');\n\n            return checkbox.is(':disabled');\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} evt\n         * @return {*}\n         */\n        onGridRowClick: function (grid, evt) {\n            var tdElement = Event.findElement(evt, 'td'),\n                trElement = Event.findElement(evt, 'tr'),\n                checkbox, isInput, checked;\n\n            if (this.isDisabled(evt)) {\n                return false;\n            }\n\n            if (!$(tdElement).down('input')) {\n                if ($(tdElement).down('a') || $(tdElement).down('select')) {\n                    return; //eslint-disable-line\n                }\n\n                if (trElement.title && trElement.title.strip() != '#') { //eslint-disable-line eqeqeq\n                    this.getOldCallback('row_click')(grid, evt);\n                } else {\n                    checkbox = Element.select(trElement, 'input');\n                    isInput = Event.element(evt).tagName == 'input'; //eslint-disable-line eqeqeq\n                    checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n\n                    if (checked) { //eslint-disable-line max-depth\n                        this.checkedString = varienStringArray.add(checkbox[0].value, this.checkedString);\n                    } else {\n                        this.checkedString = varienStringArray.remove(checkbox[0].value, this.checkedString);\n                    }\n                    this.grid.setCheckboxChecked(checkbox[0], checked);\n                    this.updateCount();\n                }\n\n                return; //eslint-disable-line\n            }\n\n            if (Event.element(evt).isMassactionCheckbox) {\n                this.setCheckbox(Event.element(evt));\n            } else if (checkbox = this.findCheckbox(evt)) { //eslint-disable-line no-cond-assign\n                checkbox.checked = !checkbox.checked;\n                jQuery(checkbox).trigger('change');\n                this.setCheckbox(checkbox);\n            }\n        },\n\n        /**\n         * @param {Object} evt\n         */\n        onSelectChange: function (evt) {\n            var item = this.getSelectedItem();\n\n            if (item) {\n                this.formAdditional.update($(this.containerId + '-item-' + item.id + '-block').innerHTML);\n                evt.target.addClassName('_selected');\n            } else {\n                this.formAdditional.update('');\n                evt.target.removeClassName('_selected');\n            }\n            jQuery(this.form).data('validator').resetForm();\n        },\n\n        /**\n         * @param {Object} evt\n         * @return {*}\n         */\n        findCheckbox: function (evt) {\n            if (['a', 'input', 'select'].indexOf(Event.element(evt).tagName.toLowerCase()) !== -1) {\n                return false;\n            }\n            checkbox = false; //eslint-disable-line no-undef\n            Event.findElement(evt, 'tr').select('[data-role=\"select-row\"]').each(function (element) { //eslint-disable-line\n                if (element.isMassactionCheckbox) {\n                    checkbox = element; //eslint-disable-line no-undef\n                }\n            });\n\n            return checkbox; //eslint-disable-line no-undef\n        },\n\n        /**\n         * Init checkobox.\n         */\n        initCheckboxes: function () {\n            this.getCheckboxes().each(function (checkbox) { //eslint-disable-line no-extra-bind\n                checkbox.isMassactionCheckbox = true; //eslint-disable-line no-undef\n            });\n        },\n\n        /**\n         * Check checkbox.\n         */\n        checkCheckboxes: function () {\n            this.getCheckboxes().each(function (checkbox) {\n                checkbox.checked = varienStringArray.has(checkbox.value, this.checkedString);\n                jQuery(checkbox).trigger('change');\n            }.bind(this));\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        selectAll: function () {\n            this.setCheckedValues(this.useSelectAll ? this.getGridIds() : this.getCheckboxesValuesAsString());\n            this.checkCheckboxes();\n            this.updateCount();\n            this.clearLastChecked();\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        unselectAll: function () {\n            this.setCheckedValues('');\n            this.checkCheckboxes();\n            this.updateCount();\n            this.clearLastChecked();\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        selectVisible: function () {\n            this.setCheckedValues(this.getCheckboxesValuesAsString());\n            this.checkCheckboxes();\n            this.updateCount();\n            this.clearLastChecked();\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        unselectVisible: function () {\n            this.getCheckboxesValues().each(function (key) {\n                this.checkedString = varienStringArray.remove(key, this.checkedString);\n            }.bind(this));\n            this.checkCheckboxes();\n            this.updateCount();\n            this.clearLastChecked();\n\n            return false;\n        },\n\n        /**\n         * @param {*} values\n         */\n        setCheckedValues: function (values) {\n            this.checkedString = values;\n        },\n\n        /**\n         * @return {String}\n         */\n        getCheckedValues: function () {\n            return this.checkedString;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getCheckboxes: function () {\n            var result = [];\n\n            this.grid.rows.each(function (row) {\n                var checkboxes = row.select('[data-role=\"select-row\"]');\n\n                checkboxes.each(function (checkbox) {\n                    result.push(checkbox);\n                });\n            });\n\n            return result;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getCheckboxesValues: function () {\n            var result = [];\n\n            this.getCheckboxes().each(function (checkbox) { //eslint-disable-line no-extra-bind\n                result.push(checkbox.value);\n            });\n\n            return result;\n        },\n\n        /**\n         * @return {String}\n         */\n        getCheckboxesValuesAsString: function () {\n            return this.getCheckboxesValues().join(',');\n        },\n\n        /**\n         * @param {Object} checkbox\n         */\n        setCheckbox: function (checkbox) {\n            if (checkbox.checked) {\n                this.checkedString = varienStringArray.add(checkbox.value, this.checkedString);\n            } else {\n                this.checkedString = varienStringArray.remove(checkbox.value, this.checkedString);\n            }\n            this.updateCount();\n        },\n\n        /**\n         * Update count.\n         */\n        updateCount: function () {\n            var checkboxesTotal = varienStringArray.count(\n                this.useSelectAll ? this.getGridIds() : this.getCheckboxesValuesAsString()\n                ),\n                checkboxesChecked = varienStringArray.count(this.checkedString);\n\n            jQuery('[data-role=\"counter\"]', this.count).html(checkboxesChecked);\n\n            if (!checkboxesTotal) {\n                this.multiselect.addClassName('_disabled');\n            } else {\n                this.multiselect.removeClassName('_disabled');\n            }\n\n            if (checkboxesChecked == checkboxesTotal && checkboxesTotal != 0) { //eslint-disable-line eqeqeq\n                this.count.removeClassName('_empty');\n                this.multiselect.addClassName('_checked').removeClassName('_indeterminate');\n            } else if (checkboxesChecked == 0) { //eslint-disable-line eqeqeq\n                this.count.addClassName('_empty');\n                this.multiselect.removeClassName('_checked').removeClassName('_indeterminate');\n            } else {\n                this.count.removeClassName('_empty');\n                this.multiselect.addClassName('_checked').addClassName('_indeterminate');\n            }\n\n            if (!this.grid.reloadParams) {\n                this.grid.reloadParams = {};\n            }\n            this.grid.reloadParams[this.formFieldNameInternal] = this.checkedString;\n        },\n\n        /**\n         * @return {*}\n         */\n        getSelectedItem: function () {\n            if (this.getItem(this.select.value)) {\n                return this.getItem(this.select.value);\n            }\n\n            return false;\n        },\n\n        /**\n         * Apply.\n         */\n        apply: function () {\n            var item, fieldName;\n\n            if (varienStringArray.count(this.checkedString) == 0) { //eslint-disable-line eqeqeq\n                alert({\n                    content: this.errorText\n                });\n\n                return;\n            }\n\n            item = this.getSelectedItem();\n\n            if (!item) {\n                jQuery(this.form).valid();\n\n                return;\n            }\n            this.currentItem = item;\n            fieldName = item.field ? item.field : this.formFieldName;\n\n            if (this.currentItem.confirm) {\n                confirm({\n                    content: this.currentItem.confirm,\n                    actions: {\n                        confirm: this.onConfirm.bind(this, fieldName, item)\n                    }\n                });\n            } else {\n                this.onConfirm(fieldName, item);\n            }\n        },\n\n        /**\n         * @param {*} fieldName\n         * @param {*} item\n         */\n        onConfirm: function (fieldName, item) {\n            this.formHiddens.update('');\n            new Insertion.Bottom(this.formHiddens, this.fieldTemplate({\n                name: fieldName,\n                value: this.checkedString\n            }));\n            new Insertion.Bottom(this.formHiddens, this.fieldTemplate({\n                name: 'massaction_prepare_key',\n                value: fieldName\n            }));\n\n            if (!jQuery(this.form).valid()) {\n                return;\n            }\n\n            if (this.useAjax && item.url) {\n                new Ajax.Request(item.url, {\n                    'method': 'post',\n                    'parameters': this.form.serialize(true),\n                    'onComplete': this.onMassactionComplete.bind(this)\n                });\n            } else if (item.url) {\n                this.form.action = item.url;\n                this.form.submit();\n            }\n        },\n\n        /**\n         * @param {*} transport\n         */\n        onMassactionComplete: function (transport) {\n            var listener;\n\n            if (this.currentItem.complete) {\n                try {\n                    listener = this.getListener(this.currentItem.complete) || Prototype.emptyFunction;\n                    listener(this.grid, this, transport);\n                } catch (e) {\n                }\n            }\n        },\n\n        /**\n         * @param {*} strValue\n         * @return {Object}\n         */\n        getListener: function (strValue) {\n            return eval(strValue); //eslint-disable-line no-eval\n        },\n\n        /**\n         * Init mass select.\n         */\n        initMassSelect: function () {\n            $$('input[data-role=\"select-row\"]').each(function (element) {\n                element.observe('click', this.massSelect.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Clear last checked.\n         */\n        clearLastChecked: function () {\n            this.lastChecked = {\n                left: false,\n                top: false,\n                checkbox: false\n            };\n        },\n\n        /**\n         * @param {Object} evt\n         */\n        massSelect: function (evt) {\n            var currentCheckbox, lastCheckbox, start, finish;\n\n            if (this.lastChecked.left !== false &&\n                this.lastChecked.top !== false &&\n                evt.button === 0 &&\n                evt.shiftKey === true\n            ) {\n                currentCheckbox = Event.element(evt);\n                lastCheckbox = this.lastChecked.checkbox;\n\n                if (lastCheckbox != currentCheckbox) { //eslint-disable-line eqeqeq\n                    start = this.getCheckboxOrder(lastCheckbox);\n                    finish = this.getCheckboxOrder(currentCheckbox);\n\n                    if (start !== false && finish !== false) { //eslint-disable-line max-depth\n                        this.selectCheckboxRange(\n                            Math.min(start, finish),\n                            Math.max(start, finish),\n                            currentCheckbox.checked\n                        );\n                    }\n                }\n            }\n\n            this.lastChecked = {\n                left: Event.element(evt).viewportOffset().left,\n                top: Event.element(evt).viewportOffset().top,\n                checkbox: Event.element(evt) // \"boundary\" checkbox\n            };\n        },\n\n        /**\n         * @param {*} curCheckbox\n         * @return {Boolean}\n         */\n        getCheckboxOrder: function (curCheckbox) {\n            var order = false;\n\n            this.getCheckboxes().each(function (checkbox, key) {\n                if (curCheckbox == checkbox) { //eslint-disable-line eqeqeq\n                    order = key;\n                }\n            });\n\n            return order;\n        },\n\n        /**\n         * @param {*} start\n         * @param {*} finish\n         * @param {*} isChecked\n         */\n        selectCheckboxRange: function (start, finish, isChecked) {\n            this.getCheckboxes().each(function (checkbox, key) {\n                if (key >= start && key <= finish) {\n                    checkbox.checked = isChecked;\n                    this.setCheckbox(checkbox);\n                }\n            }.bind(this));\n        }\n    };\n\n    window.varienGridAction = {\n        /**\n         * @param {Object} select\n         */\n        execute: function (select) {\n            var config, win;\n\n            if (!select.value || !select.value.isJSON()) {\n                return;\n            }\n\n            config = select.value.evalJSON();\n\n            if (config.confirm && !window.confirm(config.confirm)) { //eslint-disable-line no-alert\n                select.options[0].selected = true;\n\n                return;\n            }\n\n            if (config.popup) {\n                win = window.open(config.href, 'action_window', 'width=500,height=600,resizable=1,scrollbars=1');\n                win.focus();\n                select.options[0].selected = true;\n            } else {\n                setLocation(config.href);\n            }\n        }\n    };\n\n    window.varienStringArray = {\n        /**\n         * @param {*} str\n         * @param {*} haystack\n         * @return {*}\n         */\n        remove: function (str, haystack) {\n            haystack = ',' + haystack + ',';\n            haystack = haystack.replace(new RegExp(',' + str + ',', 'g'), ',');\n\n            return this.trimComma(haystack);\n        },\n\n        /**\n         * @param {*} str\n         * @param {*} haystack\n         * @return {*}\n         */\n        add: function (str, haystack) {\n            haystack = ',' + haystack + ',';\n\n            if (haystack.search(new RegExp(',' + str + ',', 'g'), haystack) === -1) {\n                haystack += str + ',';\n            }\n\n            return this.trimComma(haystack);\n        },\n\n        /**\n         * @param {*} str\n         * @param {*} haystack\n         * @return {Boolean}\n         */\n        has: function (str, haystack) {\n            haystack = ',' + haystack + ',';\n\n            if (haystack.search(new RegExp(',' + str + ',', 'g'), haystack) === -1) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * @param {*} haystack\n         * @return {*}\n         */\n        count: function (haystack) {\n            var match;\n\n            if (typeof haystack != 'string') {\n                return 0;\n            }\n\n            /* eslint-disable no-undef, no-cond-assign, eqeqeq */\n            if (match = haystack.match(new RegExp(',', 'g'))) {\n                return match.length + 1;\n            } else if (haystack.length != 0) {\n                return 1;\n            }\n\n            /* eslint-enable no-undef, no-cond-assign, eqeqeq */\n            return 0;\n        },\n\n        /**\n         * @param {*} haystack\n         * @param {*} fnc\n         */\n        each: function (haystack, fnc) {\n            var i;\n\n            haystack = haystack.split(',');\n\n            for (i = 0; i < haystack.length; i++) {\n                fnc(haystack[i]);\n            }\n        },\n\n        /**\n         * @param {String} string\n         * @return {String}\n         */\n        trimComma: function (string) {\n            string = string.replace(new RegExp('^(,+)', 'i'), '');\n            string = string.replace(new RegExp('(,+)$', 'i'), '');\n\n            return string;\n        }\n    };\n\n    window.serializerController = Class.create();\n    serializerController.prototype = {\n        oldCallbacks: {},\n\n        /**\n         * @param {*} hiddenDataHolder\n         * @param {*} predefinedData\n         * @param {*} inputsToManage\n         * @param {*} grid\n         * @param {*} reloadParamName\n         */\n        initialize: function (hiddenDataHolder, predefinedData, inputsToManage, grid, reloadParamName) {\n            //Grid inputs\n            this.tabIndex = 1000;\n            this.inputsToManage = inputsToManage;\n            this.multidimensionalMode = inputsToManage.length > 0;\n\n            //Hash with grid data\n            this.gridData = this.getGridDataHash(predefinedData);\n\n            //Hidden input data holder\n            this.hiddenDataHolder = $(hiddenDataHolder);\n            this.hiddenDataHolder.value = this.serializeObject();\n\n            this.grid = grid;\n\n            // Set old callbacks\n            this.setOldCallback('row_click', this.grid.rowClickCallback);\n            this.setOldCallback('init_row', this.grid.initRowCallback);\n            this.setOldCallback('checkbox_check', this.grid.checkboxCheckCallback);\n\n            //Grid\n            this.reloadParamName = reloadParamName;\n            this.grid.reloadParams = {};\n            this.grid.reloadParams[this.reloadParamName + '[]'] = this.getDataForReloadParam();\n            this.grid.rowClickCallback = this.rowClick.bind(this);\n            this.grid.initRowCallback = this.rowInit.bind(this);\n            this.grid.checkboxCheckCallback = this.registerData.bind(this);\n            this.grid.rows.each(this.eachRow.bind(this));\n        },\n\n        /**\n         * @param {String} callbackName\n         * @param {Function} callback\n         */\n        setOldCallback: function (callbackName, callback) {\n            this.oldCallbacks[callbackName] = callback;\n        },\n\n        /**\n         * @param {String} callbackName\n         * @return {Prototype.emptyFunction}\n         */\n        getOldCallback: function (callbackName) {\n            return this.oldCallbacks[callbackName] ? this.oldCallbacks[callbackName] : Prototype.emptyFunction;\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} element\n         * @param {*} checked\n         */\n        registerData: function (grid, element, checked) {\n            var i;\n\n            if (this.multidimensionalMode) {\n                if (checked) {\n                    /*eslint-disable max-depth*/\n                    if (element.inputElements) {\n                        this.gridData.set(element.value, {});\n\n                        for (i = 0; i < element.inputElements.length; i++) {\n                            element.inputElements[i].disabled = false;\n                            this.gridData.get(element.value)[element.inputElements[i].name] =\n                                element.inputElements[i].value;\n                        }\n                    }\n                } else {\n                    if (element.inputElements) {\n                        for (i = 0; i < element.inputElements.length; i++) {\n                            element.inputElements[i].disabled = true;\n                        }\n                    }\n                    this.gridData.unset(element.value);\n                }\n            } else {\n                if (checked) { //eslint-disable-line no-lonely-if\n                    this.gridData.set(element.value, element.value);\n                } else {\n                    this.gridData.unset(element.value);\n                }\n            }\n\n            this.hiddenDataHolder.value = this.serializeObject();\n            this.grid.reloadParams = {};\n            this.grid.reloadParams[this.reloadParamName + '[]'] = this.getDataForReloadParam();\n            this.getOldCallback('checkbox_check')(grid, element, checked);\n\n            /*eslint-enable max-depth*/\n        },\n\n        /**\n         * @param {*} row\n         */\n        eachRow: function (row) {\n            this.rowInit(this.grid, row);\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} event\n         */\n        rowClick: function (grid, event) {\n            var trElement = Event.findElement(event, 'tr'),\n                isInput = Event.element(event).tagName == 'INPUT', //eslint-disable-line eqeqeq\n                checkbox, checked;\n\n            if (trElement) {\n                // eslint-disable-next-line jquery-no-input-event-shorthand\n                checkbox = Element.select(trElement, 'input');\n\n                if (checkbox[0] && !checkbox[0].disabled) {\n                    checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n                    this.grid.setCheckboxChecked(checkbox[0], checked);\n                }\n            }\n            this.getOldCallback('row_click')(grid, event);\n        },\n\n        /**\n         * @param {*} event\n         */\n        inputChange: function (event) {\n            var element = Event.element(event);\n\n            if (element && element.checkboxElement && element.checkboxElement.checked) {\n                this.gridData.get(element.checkboxElement.value)[element.name] = element.value;\n                this.hiddenDataHolder.value = this.serializeObject();\n            }\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} row\n         */\n        rowInit: function (grid, row) {\n            var checkbox, selectors, inputs, i;\n\n            if (this.multidimensionalMode) {\n                // eslint-disable-next-line jquery-no-input-event-shorthand\n                checkbox = $(row).select('.checkbox')[0];\n                selectors = this.inputsToManage.map(function (name) {\n                    return ['input[name=\"' + name + '\"]', 'select[name=\"' + name + '\"]'];\n                });\n                inputs = $(row).select.apply($(row), selectors.flatten());\n\n                if (checkbox && inputs.length > 0) {\n                    checkbox.inputElements = inputs;\n\n                    /* eslint-disable max-depth */\n                    for (i = 0; i < inputs.length; i++) {\n                        inputs[i].checkboxElement = checkbox;\n\n                        if (this.gridData.get(checkbox.value) && this.gridData.get(checkbox.value)[inputs[i].name]) {\n                            inputs[i].value = this.gridData.get(checkbox.value)[inputs[i].name];\n                        }\n                        inputs[i].disabled = !checkbox.checked;\n                        inputs[i].tabIndex = this.tabIndex++;\n                        Event.observe(inputs[i], 'keyup', this.inputChange.bind(this));\n                        Event.observe(inputs[i], 'change', this.inputChange.bind(this));\n                    }\n                }\n            }\n\n            /* eslint-enable max-depth */\n            this.getOldCallback('init_row')(grid, row);\n        },\n\n        /**\n         * Stuff methods.\n         *\n         * @param {*} _object\n         * @return {*}\n         */\n        getGridDataHash: function (_object) {\n            return $H(this.multidimensionalMode ? _object : this.convertArrayToObject(_object));\n        },\n\n        /**\n         * @return {*}\n         */\n        getDataForReloadParam: function () {\n            return this.multidimensionalMode ? this.gridData.keys() : this.gridData.values();\n        },\n\n        /**\n         * @return {*}\n         */\n        serializeObject: function () {\n            var clone;\n\n            if (this.multidimensionalMode) {\n                clone = this.gridData.clone();\n                clone.each(function (pair) {\n                    clone.set(pair.key, Base64.encode(Object.toQueryString(pair.value)));\n                });\n\n                return clone.toQueryString();\n            }\n\n            return this.gridData.values().join('&');\n        },\n\n        /**\n         * @param {Array} _array\n         * @return {Object}\n         */\n        convertArrayToObject: function (_array) {\n            var _object = {},\n                i, l;\n\n            for (i = 0, l = _array.length; i < l; i++) {\n                _object[_array[i]] = _array[i];\n            }\n\n            return _object;\n        }\n    };\n});\n","mage/adminhtml/backup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/* global  AdminBackup, setLocation */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/mage',\n    'prototype'\n], function (jQuery) {\n    window.AdminBackup = new Class.create();\n\n    AdminBackup.prototype = {\n        /**\n         * Initialize.\n         */\n        initialize: function () {\n            this.reset();\n            this.rollbackUrl = this.backupUrl = '';\n        },\n\n        /**\n         * reset.\n         */\n        reset: function () {\n            this.time = 0;\n            this.type = '';\n        },\n\n        /**\n         * @param {*} type\n         * @return {Boolean}\n         */\n        backup: function (type) {\n            this.reset();\n            this.type = type;\n            this.requestBackupOptions();\n\n            return false;\n        },\n\n        /**\n         * @param {*} type\n         * @param {*} time\n         * @return {Boolean}\n         */\n        rollback: function (type, time) {\n            this.reset();\n            this.time = time;\n            this.type = type;\n            this.showRollbackWarning();\n\n            return false;\n        },\n\n        /**\n         * Show rollback warning.\n         */\n        showRollbackWarning: function () {\n            this.showPopup('rollback-warning');\n        },\n\n        /**\n         * request backup options.\n         */\n        requestBackupOptions: function () {\n            this.hidePopups();\n            this.showPopup('backup-options');\n\n            if (this.type === 'snapshot') {\n                jQuery('#exclude-media-checkbox-container').removeClass('no-display');\n            }\n        },\n\n        /**\n         * Request password.\n         */\n        requestPassword: function () {\n            this.hidePopups();\n\n            this.showPopup('rollback-request-password');\n\n            this.type != 'db' ? //eslint-disable-line eqeqeq\n                $('use-ftp-checkbox-row').show() :\n                $('use-ftp-checkbox-row').hide();\n        },\n\n        /**\n         * Toggle Ftp Credentials Form.\n         */\n        toggleFtpCredentialsForm: function () {\n            $('use_ftp').checked ? $('ftp-credentials-container').show()\n                : $('ftp-credentials-container').hide();\n\n            $$('#ftp-credentials-container input').each(function (item) {\n                if (item.name == 'ftp_path') { //eslint-disable-line eqeqeq\n                    return;\n                }\n                $('use_ftp').checked ? item.addClassName('required-entry') : item.removeClassName('required-entry');\n            });\n        },\n\n        /**\n         * Submit backup.\n         */\n        submitBackup: function () {\n            var data = {\n                'type': this.type,\n                'maintenance_mode': $('backup_maintenance_mode').checked ? 1 : 0,\n                'backup_name': $('backup_name').value,\n                'exclude_media': $('exclude_media').checked ? 1 : 0\n            };\n\n            new Ajax.Request(this.backupUrl, {\n                onSuccess: function (transport) {\n                    this.processResponse(transport, 'backup-options');\n                }.bind(this),\n                method: 'post',\n                parameters: data\n            });\n\n            this.modal.modal('closeModal');\n        },\n\n        /**\n         * Submit rollback.\n         */\n        submitRollback: function () {\n            var data = this.getPostData();\n\n            new Ajax.Request(this.rollbackUrl, {\n                onSuccess: function (transport) {\n                    this.processResponse(transport, 'rollback-request-password');\n                }.bind(this),\n                method: 'post',\n                parameters: data\n            });\n\n            this.modal.modal('closeModal');\n        },\n\n        /**\n         * @param {Object} transport\n         * @param {*} popupId\n         */\n        processResponse: function (transport, popupId) {\n            var json;\n\n            if (!transport.responseText.isJSON()) {\n                return;\n            }\n\n            json = transport.responseText.evalJSON();\n\n            if (json.error) {\n                this.showPopup(popupId);\n                this.displayError(popupId, json.error);\n\n                return;\n            }\n\n            if (json['redirect_url']) {\n                setLocation(json['redirect_url']);\n            }\n        },\n\n        /**\n         * @param {*} parentContainer\n         * @param {*} message\n         */\n        displayError: function (parentContainer, message) {\n            var messageHtml = this.getErrorMessageHtml(message);\n\n            $$('#' + parentContainer + ' .backup-messages .messages').invoke('update', messageHtml);\n            $$('#' + parentContainer + ' .backup-messages').invoke('show');\n        },\n\n        /**\n         * @param {*} message\n         * @return {String}\n         */\n        getErrorMessageHtml: function (message) {\n            return '<div class=\"message message-error error\"><div>' + message + '</div></div>';\n        },\n\n        /**\n         * @return {*|jQuery}\n         */\n        getPostData: function () {\n            var data = $('rollback-form').serialize(true);\n\n            data.time = this.time;\n            data.type = this.type;\n\n            return data;\n        },\n        backupConfig: {\n            'backup-options': {\n                title: jQuery.mage.__('Backup options'),\n\n                /**\n                 * @return {String}\n                 */\n                content: function () {\n                    return document.getElementById('backup-options-template').textContent;\n                },\n\n                /**\n                 * Action Ok.\n                 */\n                actionOk: function () {\n                    this.modal.find('#backup-form').validation({\n                        submitHandler: jQuery.proxy(this.submitBackup, this)\n                    });\n                    this.modal.find('#backup-form').submit();\n                }\n            },\n            'rollback-warning': {\n                title: jQuery.mage.__('Warning'),\n\n                /**\n                 * @return {String}\n                 */\n                content: function () {\n                    return document.getElementById('rollback-warning-template').textContent;\n                },\n\n                /**\n                 * Action Ok.\n                 */\n                actionOk: function () {\n                    this.modal.modal('closeModal');\n                    this.requestPassword();\n                }\n            },\n            'rollback-request-password': {\n                title: jQuery.mage.__('Backup options'),\n\n                /**\n                 * @return {String}\n                 */\n                content: function () {\n                    return document.getElementById('rollback-request-password-template').textContent;\n                },\n\n                /**\n                 * Action Ok.\n                 */\n                actionOk: function () {\n                    this.modal.find('#rollback-form').validation({\n                        submitHandler: jQuery.proxy(this.submitRollback, this)\n                    });\n                    this.modal.find('#rollback-form').submit();\n                },\n\n                /**\n                 * Opened.\n                 */\n                opened: function () {\n                    this.toggleFtpCredentialsForm();\n                }\n            }\n        },\n\n        /**\n         * @param {*} divId\n         */\n        showPopup: function (divId) {\n            var self = this;\n\n            this.modal = jQuery('<div></div>').attr({\n                id: divId\n            }).html(this.backupConfig[divId].content()).modal({\n                modalClass: 'magento',\n                title: this.backupConfig[divId].title,\n                type: 'slide',\n\n                /**\n                 * @param {juery.Event} e\n                 * @param {Object} modal\n                 */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                },\n\n                /**\n                 * Opened.\n                 */\n                opened: function () {\n                    if (self.backupConfig[divId].opened) {\n                        self.backupConfig[divId].opened.call(self);\n                    }\n                },\n                buttons: [{\n                    text: jQuery.mage.__('Cancel'),\n                    'class': 'action cancel',\n\n                    /**\n                     * Click action.\n                     */\n                    click: function () {\n                        this.closeModal();\n                    }\n                }, {\n                    text: jQuery.mage.__('Ok'),\n                    'class': 'action primary',\n\n                    /**\n                     * Click action.\n                     */\n                    click: function () {\n                        self.backupConfig[divId].actionOk.call(self);\n                    }\n                }]\n            });\n            this.modal.modal('openModal');\n        },\n\n        /**\n         * Hide Popups.\n         */\n        hidePopups: function () {\n            var mask;\n\n            $$('.backup-dialog').each(Element.hide);\n            mask = $('popup-window-mask');\n\n            if (mask) {\n                mask.hide();\n            }\n        }\n    };\n});\n","mage/adminhtml/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global varienGlobalEvents, varienWindowOnloadCache, RegionUpdater, FormElementDependenceController */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'prototype',\n    'mage/adminhtml/events'\n], function (jQuery) {\n    var varienElementMethods;\n\n    /*\n     * @TODO Need to be removed after refactoring all dependent of the form the components\n     */\n    (function ($) {\n        $(function () {\n            $(document).on('beforeSubmit', function (e) { //eslint-disable-line max-nested-callbacks\n                if (typeof varienGlobalEvents !== 'undefined') {\n                    varienGlobalEvents.fireEvent('formSubmit', $(e.target).attr('id'));\n                }\n            });\n        });\n    })(jQuery);\n\n    /**\n     *  Additional elements methods\n     */\n    varienElementMethods = {\n        /**\n         * @param {HTMLElement} element\n         */\n        setHasChanges: function (element) {\n            var elm;\n\n            if ($(element) && $(element).hasClassName('no-changes')) {\n                return;\n            }\n            elm = element;\n\n            while (elm && elm.tagName != 'BODY') { //eslint-disable-line eqeqeq\n                if (elm.statusBar) {\n                    Element.addClassName($(elm.statusBar), 'changed');\n                }\n                elm = elm.parentNode;\n            }\n        },\n\n        /**\n         * @param {HTMLElement} element\n         * @param {*} flag\n         * @param {Object} form\n         */\n        setHasError: function (element, flag, form) {\n            var elm = element;\n\n            while (elm && elm.tagName != 'BODY') { //eslint-disable-line eqeqeq\n                if (elm.statusBar) {\n                    /* eslint-disable max-depth */\n                    if (form.errorSections.keys().indexOf(elm.statusBar.id) < 0) {\n                        form.errorSections.set(elm.statusBar.id, flag);\n                    }\n\n                    if (flag) {\n                        Element.addClassName($(elm.statusBar), 'error');\n\n                        if (form.canShowError && $(elm.statusBar).show) {\n                            form.canShowError = false;\n                            $(elm.statusBar).show();\n                        }\n                        form.errorSections.set(elm.statusBar.id, flag);\n                    } else if (!form.errorSections.get(elm.statusBar.id)) {\n                        Element.removeClassName($(elm.statusBar), 'error');\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n                elm = elm.parentNode;\n            }\n            this.canShowElement = false;\n        }\n    };\n\n    Element.addMethods(varienElementMethods);\n\n    // Global bind changes\n    window.varienWindowOnloadCache = {};\n\n    /**\n     * @param {*} useCache\n     */\n    function varienWindowOnload(useCache) {\n        var dataElements = $$('input', 'select', 'textarea'),\n            i;\n\n        for (i = 0; i < dataElements.length; i++) {\n            if (dataElements[i] && dataElements[i].id) {\n\n                /* eslint-disable max-depth */\n                if (!useCache || !varienWindowOnloadCache[dataElements[i].id]) {\n                    Event.observe(dataElements[i], 'change', dataElements[i].setHasChanges.bind(dataElements[i]));\n\n                    if (useCache) {\n                        varienWindowOnloadCache[dataElements[i].id] = true;\n                    }\n                }\n\n                /* eslint-disable max-depth */\n            }\n        }\n    }\n    Event.observe(window, 'load', varienWindowOnload);\n\n    window.RegionUpdater = Class.create();\n    RegionUpdater.prototype = {\n        /**\n         * @param {HTMLElement} countryEl\n         * @param {HTMLElement} regionTextEl\n         * @param {HTMLElement}regionSelectEl\n         * @param {Object} regions\n         * @param {*} disableAction\n         * @param {*} clearRegionValueOnDisable\n         */\n        initialize: function (\n            countryEl, regionTextEl, regionSelectEl, regions, disableAction, clearRegionValueOnDisable\n        ) {\n            this.isRegionRequired = true;\n            this.countryEl = $(countryEl);\n            this.regionTextEl = $(regionTextEl);\n            this.regionSelectEl = $(regionSelectEl);\n            this.config = regions.config;\n            delete regions.config;\n            this.regions = regions;\n            this.sortedRegions = this.getSortedRegions();\n            this.disableAction = typeof disableAction === 'undefined' ? 'hide' : disableAction;\n            this.clearRegionValueOnDisable = typeof clearRegionValueOnDisable === 'undefined' ?\n                false : clearRegionValueOnDisable;\n\n            if (this.regionSelectEl.options.length <= 1) {\n                this.update();\n            } else {\n                this.lastCountryId = this.countryEl.value;\n            }\n\n            this.countryEl.changeUpdater = this.update.bind(this);\n\n            Event.observe(this.countryEl, 'change', this.update.bind(this));\n        },\n\n        /**\n         * @private\n         */\n        _checkRegionRequired: function () {\n            var label, wildCard, elements, that, regionRequired;\n\n            if (!this.isRegionRequired) {\n                return;\n            }\n\n            elements = [this.regionTextEl, this.regionSelectEl];\n            that = this;\n\n            if (typeof this.config == 'undefined') {\n                return;\n            }\n            regionRequired = this.config['regions_required'].indexOf(this.countryEl.value) >= 0;\n\n            elements.each(function (currentElement) {\n                var form, validationInstance, field, topElement;\n\n                if (!currentElement) {\n                    return;\n                }\n                form = currentElement.form;\n                validationInstance = form ? jQuery(form).data('validation') : null;\n                field = currentElement.up('.field') || new Element('div');\n\n                if (validationInstance) {\n                    validationInstance.clearError(currentElement);\n                }\n                label = $$('label[for=\"' + currentElement.id + '\"]')[0];\n\n                if (label) {\n                    wildCard = label.down('em') || label.down('span.required');\n                    topElement = label.up('tr') || label.up('li');\n\n                    if (!that.config['show_all_regions'] && topElement) {\n                        if (regionRequired) {\n                            topElement.show();\n                        } else {\n                            topElement.hide();\n                        }\n                    }\n                }\n\n                if (label && wildCard) {\n                    if (!regionRequired) {\n                        wildCard.hide();\n                    } else {\n                        wildCard.show();\n                    }\n                }\n\n                //compute the need for the required fields\n                if (!regionRequired || !currentElement.visible()) {\n                    if (field.hasClassName('required')) {\n                        field.removeClassName('required');\n                    }\n\n                    if (currentElement.hasClassName('required-entry')) {\n                        currentElement.removeClassName('required-entry');\n                    }\n\n                    if (currentElement.tagName.toLowerCase() == 'select' && //eslint-disable-line eqeqeq\n                        currentElement.hasClassName('validate-select')\n                    ) {\n                        currentElement.removeClassName('validate-select');\n                    }\n                } else {\n                    if (!field.hasClassName('required')) {\n                        field.addClassName('required');\n                    }\n\n                    if (!currentElement.hasClassName('required-entry')) {\n                        currentElement.addClassName('required-entry');\n                    }\n\n                    if (currentElement.tagName.toLowerCase() == 'select' && //eslint-disable-line eqeqeq\n                        !currentElement.hasClassName('validate-select')\n                    ) {\n                        currentElement.addClassName('validate-select');\n                    }\n                }\n            });\n        },\n\n        /**\n         * Disable region validation.\n         */\n        disableRegionValidation: function () {\n            this.isRegionRequired = false;\n        },\n\n        /**\n         * Update.\n         */\n        update: function () {\n            var option, selectElement, def, regionId, region;\n\n            selectElement = this.regionSelectEl;\n\n            if (this.sortedRegions[this.countryEl.value]) {\n                if (this.lastCountryId != this.countryEl.value) { //eslint-disable-line eqeqeq\n                    def = selectElement.getAttribute('defaultValue');\n\n                    if (this.regionTextEl) {\n                        if (!def) {\n                            def = this.regionTextEl.value.toLowerCase();\n                        }\n                        this.regionTextEl.value = '';\n                    }\n\n                    selectElement.options.length = 1;\n\n                    this.sortedRegions[this.countryEl.value].forEach(function (item) {\n                        regionId = item[0];\n                        region = item[1];\n\n                        option = document.createElement('OPTION');\n                        option.value = regionId;\n                        option.text = region.name.stripTags();\n                        option.title = region.name;\n\n                        if (selectElement.options.add) {\n                            selectElement.options.add(option);\n                        } else {\n                            selectElement.appendChild(option);\n                        }\n\n                        if (regionId == def || region.name.toLowerCase() == def || region.code.toLowerCase() == def) { //eslint-disable-line\n                            selectElement.value = regionId;\n                        }\n                    });\n                }\n\n                if (this.disableAction == 'hide') { //eslint-disable-line eqeqeq\n                    if (this.regionTextEl) {\n                        this.regionTextEl.style.display = 'none';\n                        this.regionTextEl.style.disabled = true;\n                    }\n                    this.regionSelectEl.style.display = '';\n                    this.regionSelectEl.disabled = false;\n                } else if (this.disableAction == 'disable') { //eslint-disable-line eqeqeq\n                    if (this.regionTextEl) {\n                        this.regionTextEl.disabled = true;\n                    }\n                    this.regionSelectEl.disabled = false;\n                }\n                this.setMarkDisplay(this.regionSelectEl, true);\n\n                this.lastCountryId = this.countryEl.value;\n            } else {\n                if (this.disableAction == 'hide') { //eslint-disable-line eqeqeq\n                    if (this.regionTextEl) {\n                        this.regionTextEl.style.display = '';\n                        this.regionTextEl.style.disabled = false;\n                    }\n                    this.regionSelectEl.style.display = 'none';\n                    this.regionSelectEl.disabled = true;\n                } else if (this.disableAction == 'disable') { //eslint-disable-line eqeqeq\n                    if (this.regionTextEl) {\n                        this.regionTextEl.disabled = false;\n                    }\n                    this.regionSelectEl.disabled = true;\n\n                    if (this.clearRegionValueOnDisable) {\n                        this.regionSelectEl.value = '';\n                    }\n                } else if (this.disableAction == 'nullify') { //eslint-disable-line eqeqeq\n                    this.regionSelectEl.options.length = 1;\n                    this.regionSelectEl.value = '';\n                    this.regionSelectEl.selectedIndex = 0;\n                    this.lastCountryId = '';\n                }\n                this.setMarkDisplay(this.regionSelectEl, false);\n            }\n            varienGlobalEvents.fireEvent('address_country_changed', this.countryEl);\n            this._checkRegionRequired();\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @param {*} display\n         */\n        setMarkDisplay: function (elem, display) {\n            var marks;\n\n            if (elem.parentNode.parentNode) {\n                marks = Element.select(elem.parentNode.parentNode, '.required');\n\n                if (marks[0]) {\n                    display ? marks[0].show() : marks[0].hide();\n                }\n            }\n        },\n\n        /**\n         * Sort regions from JSON by name\n         *\n         * @returns {*[]}\n         */\n        getSortedRegions: function () {\n            var country, regionsEntries, regionsByCountry;\n\n            regionsByCountry = [];\n\n            for (country in this.regions) { //eslint-disable-line guard-for-in\n                regionsEntries = Object.entries(this.regions[country]);\n                regionsEntries.sort(function (a, b) {\n                    return a[1].name > b[1].name ? 1 : -1;\n                });\n\n                regionsByCountry[country] = regionsEntries;\n            }\n\n            return regionsByCountry;\n        }\n    };\n\n    window.regionUpdater = RegionUpdater;\n\n    /**\n     * Fix errorrs in IE\n     */\n    Event.pointerX = function (event) {\n        try {\n            return event.pageX || (event.clientX + (document.documentElement.scrollLeft || document.body.scrollLeft)); //eslint-disable-line\n        }\n        catch (e) {}\n    };\n\n    /**\n     * @param {jQuery.Event} event\n     * @return {*}\n     */\n    Event.pointerY = function (event) {\n        try {\n            return event.pageY || (event.clientY + (document.documentElement.scrollTop || document.body.scrollTop)); //eslint-disable-line\n        }\n        catch (e) {}\n    };\n\n    /**\n     * Observer that watches for dependent form elements\n     * If an element depends on 1 or more of other elements,\n     * it should show up only when all of them gain specified values\n     */\n    window.FormElementDependenceController = Class.create();\n    FormElementDependenceController.prototype = {\n        /**\n         * Structure of elements: {\n         *     'id_of_dependent_element' : {\n         *         'id_of_master_element_1' : 'reference_value',\n         *         'id_of_master_element_2' : 'reference_value'\n         *         'id_of_master_element_3' : ['reference_value1', 'reference_value2']\n         *         ...\n         *     }\n         * }\n         * @param {Object} elementsMap\n         * @param {Object} config\n         */\n        initialize: function (elementsMap, config) {\n            var idTo, idFrom, values, fromId, radioFrom;\n\n            if (config) {\n                this._config = jQuery.extend(this._config, config);\n            }\n\n            for (idTo in elementsMap) { //eslint-disable-line guard-for-in\n                for (idFrom in elementsMap[idTo]) { //eslint-disable-line guard-for-in\n                    if ($(idFrom)) {\n                        Event.observe(\n                            $(idFrom),\n                            'change',\n                            this.trackChange.bindAsEventListener(this, idTo, elementsMap[idTo])\n                        );\n                    } else {\n                        // Check if radio button\n                        values = elementsMap[idTo][idFrom].values;\n                        fromId = $(idFrom + values[0]);\n                        radioFrom = fromId ? $$('[name=\"' + fromId.name + '\"]') : false;\n\n                        if (radioFrom) {\n                            radioFrom.invoke(\n                                'on',\n                                'change',\n                                this.trackChange.bindAsEventListener(this, idTo, elementsMap[idTo])\n                            );\n                        }\n                    }\n                    this.trackChange(null, idTo, elementsMap[idTo]);\n                }\n            }\n        },\n\n        /**\n         * Misc. config options\n         * Keys are underscored intentionally\n         */\n        _config: {\n            'levels_up': 1 // how many levels up to travel when toggling element\n        },\n\n        /**\n         * Define whether target element should be toggled and show/hide its row\n         *\n         * @param {Object} e - event\n         * @param {String} idTo - id of target element\n         * @param {Object} valuesFrom - ids of master elements and reference values\n         * @return\n         */\n        trackChange: function (e, idTo, valuesFrom) {\n            // define whether the target should show up\n            var shouldShowUp = true,\n                idFrom, from, values, isInArray, isNegative, headElement, isInheritCheckboxChecked, target, inputs,\n                isAnInputOrSelect, currentConfig, rowElement, fromId, radioFrom, targetArray, isChooser;\n\n            for (idFrom in valuesFrom) { //eslint-disable-line guard-for-in\n                from = $(idFrom);\n\n                if (from) {\n                    values = valuesFrom[idFrom].values;\n                    isInArray = values.indexOf(from.value) != -1; //eslint-disable-line\n                    isNegative = valuesFrom[idFrom].negative;\n\n                    if (!from || isInArray && isNegative || !isInArray && !isNegative) {\n                        shouldShowUp = false;\n                    }\n                // Check if radio button\n                } else {\n                    values = valuesFrom[idFrom].values;\n                    fromId = $(idFrom + values[0]);\n\n                    if (fromId) {\n                        radioFrom = $$('[name=\"' + fromId.name + '\"]:checked');\n                        isInArray = radioFrom.length > 0 && values.indexOf(radioFrom[0].value) !== -1;\n                        isNegative = valuesFrom[idFrom].negative;\n\n                        if (!radioFrom || isInArray && isNegative || !isInArray && !isNegative) {\n                            shouldShowUp = false;\n                        }\n                    }\n                }\n            }\n\n            // toggle target row\n            headElement = jQuery('#' + idTo + '-head');\n            isInheritCheckboxChecked = $(idTo + '_inherit') && $(idTo + '_inherit').checked;\n            target = $(idTo);\n\n            // Account for the chooser style parameters.\n            if (target === null && headElement.length === 0 && idTo.substring(0, 16) === 'options_fieldset') {\n                targetArray = $$('input[id*=\"' + idTo + '\"]');\n                isChooser = true;\n\n                if (targetArray !== null && targetArray.length > 0) {\n                    target = targetArray[0];\n                }\n                headElement = jQuery('.field-' + idTo).add('.field-chooser' + idTo);\n            }\n\n            // Target won't always exist (for example, if field type is \"label\")\n            if (target) {\n                inputs = target.up(this._config['levels_up']).select('input', 'select', 'td');\n                isAnInputOrSelect = ['input', 'select'].indexOf(target.tagName.toLowerCase()) != -1; //eslint-disable-line\n\n                if (target.type === 'fieldset') {\n                    inputs = target.select('input', 'select', 'td');\n                }\n            } else {\n                inputs = false;\n                isAnInputOrSelect = false;\n            }\n\n            if (shouldShowUp) {\n                currentConfig = this._config;\n\n                if (inputs) {\n                    inputs.each(function (item) {\n                        // don't touch hidden inputs (and Use Default inputs too), bc they may have custom logic\n                        if ((!item.type || item.type != 'hidden') && !($(item.id + '_inherit') && $(item.id + '_inherit').checked) && //eslint-disable-line\n                            !(currentConfig['can_edit_price'] != undefined && !currentConfig['can_edit_price']) && //eslint-disable-line\n                            !item.getAttribute('readonly') || isChooser //eslint-disable-line\n                        ) {\n                            item.disabled = false;\n                            jQuery(item).removeClass('ignore-validate');\n                        }\n                    });\n                }\n\n                if (headElement.length > 0) {\n                    headElement.show();\n\n                    if (headElement.hasClass('open') && target) {\n                        target.show();\n                    } else if (target) {\n                        target.hide();\n                    }\n                } else {\n                    if (target) {\n                        target.show();\n                        headElement = jQuery('.field-' + idTo).add('.field-chooser' + idTo);\n                        headElement.show();\n                    }\n\n                    if (isAnInputOrSelect && !isInheritCheckboxChecked) {\n                        if (target) {\n                            if (target.getAttribute('readonly')) {\n                                target.disabled = true;\n                            } else {\n                                target.disabled = false;\n                            }\n                        }\n\n                        jQuery('#' + idTo).removeClass('ignore-validate');\n                    }\n                }\n            } else {\n                if (inputs) {\n                    inputs.each(function (item) {\n                        // don't touch hidden inputs (and Use Default inputs too), bc they may have custom logic\n                        if ((!item.type || item.type != 'hidden') && //eslint-disable-line eqeqeq\n                            !($(item.id + '_inherit') && $(item.id + '_inherit').checked)\n                        ) {\n                            item.disabled = true;\n                            jQuery(item).addClass('ignore-validate');\n                        }\n                    });\n                }\n\n                if (headElement.length > 0) {\n                    headElement.hide();\n                } else {\n                    headElement = jQuery('.field-' + idTo).add('.field-chooser' + idTo);\n                    headElement.hide();\n                }\n\n                if (target) {\n                    target.hide();\n                }\n\n                if (isAnInputOrSelect && !isInheritCheckboxChecked) {\n                    if (target) {\n                        target.disabled = true;\n                    }\n                    jQuery('#' + idTo).addClass('ignore-validate');\n                }\n\n            }\n            rowElement = $('row_' + idTo);\n\n            if (rowElement == undefined && target) { //eslint-disable-line eqeqeq\n                rowElement = target.up(this._config['levels_up']);\n\n                if (target.type === 'fieldset') {\n                    rowElement = target;\n                }\n            }\n\n            if (rowElement) {\n                if (shouldShowUp) {\n                    rowElement.show();\n                } else {\n                    rowElement.hide();\n                }\n            }\n        }\n    };\n\n    window.varienWindowOnload = varienWindowOnload;\n    window.varienElementMethods = varienElementMethods;\n});\n","mage/adminhtml/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global varienEvents */\n/* eslint-disable strict */\ndefine([\n    'Magento_Ui/js/modal/alert',\n    'prototype'\n], function (alert) {\n    // from http://www.someelement.com/2007/03/eventpublisher-custom-events-la-pubsub.html\n    window.varienEvents = Class.create();\n\n    varienEvents.prototype = {\n        /**\n         * Initialize.\n         */\n        initialize: function () {\n            this.arrEvents = {};\n            this.eventPrefix = '';\n        },\n\n        /**\n        * Attaches a {handler} function to the publisher's {eventName} event for execution upon the event firing\n        * @param {String} eventName\n        * @param {Function} handler\n        * @param {Boolean} [asynchFlag] - Defaults to false if omitted.\n        * Indicates whether to execute {handler} asynchronously (true) or not (false).\n        */\n        attachEventHandler: function (eventName, handler) {\n            var asynchVar, handlerObj;\n\n            if (typeof handler == 'undefined' || handler == null) {\n                return;\n            }\n            eventName += this.eventPrefix;\n            // using an event cache array to track all handlers for proper cleanup\n            if (this.arrEvents[eventName] == null) {\n                this.arrEvents[eventName] = [];\n            }\n            //create a custom object containing the handler method and the asynch flag\n            asynchVar = arguments.length > 2 ? arguments[2] : false;\n            handlerObj = {\n                method: handler,\n                asynch: asynchVar\n            };\n            this.arrEvents[eventName].push(handlerObj);\n        },\n\n        /**\n        * Removes a single handler from a specific event\n        * @param {String} eventName - The event name to clear the handler from\n        * @param {Function} handler - A reference to the handler function to un-register from the event\n        */\n        removeEventHandler: function (eventName, handler) {\n            eventName += this.eventPrefix;\n\n            if (this.arrEvents[eventName] != null) {\n                this.arrEvents[eventName] = this.arrEvents[eventName].reject(function (obj) {\n                    return obj.method == handler; //eslint-disable-line eqeqeq\n                });\n            }\n        },\n\n        /**\n        * Removes all handlers from a single event\n        * @param {String} eventName - The event name to clear handlers from\n        */\n        clearEventHandlers: function (eventName) {\n            eventName += this.eventPrefix;\n            this.arrEvents[eventName] = null;\n        },\n\n        /**\n        * Removes all handlers from ALL events\n        */\n        clearAllEventHandlers: function () {\n            this.arrEvents = {};\n        },\n\n        /**\n         * Collect and modify value of arg synchronously in succession and return its new value.\n         * In order to use, call attachEventHandler and add function handlers with eventName.\n         * Then call fireEventReducer with eventName and any argument to have its value accumulatively modified.\n         * Event handlers will be applied to argument in order of first attached to last attached.\n         * @param {String} eventName\n         * @param {*} arg\n         */\n        fireEventReducer: function (eventName, arg) {\n            var evtName = eventName + this.eventPrefix,\n                result = arg,\n                len,\n                i;\n\n            if (!this.arrEvents[evtName]) {\n                return result;\n            }\n\n            len = this.arrEvents[evtName].length; //optimization\n\n            for (i = 0; i < len; i++) {\n                /* eslint-disable max-depth */\n                try {\n                    result = this.arrEvents[evtName][i].method(result);\n                } catch (e) {\n                    if (this.id) {\n                        alert({\n                            content: 'error: error in ' + this.id + '.fireEventReducer():\\n\\nevent name: ' +\n                            eventName + '\\n\\nerror message: ' + e.message\n                        });\n                    } else {\n                        alert({\n                            content: 'error: error in [unknown object].fireEventReducer():\\n\\nevent name: ' +\n                            eventName + '\\n\\nerror message: ' + e.message\n                        });\n                    }\n                }\n                /* eslint-disable max-depth */\n            }\n\n            return result;\n        },\n\n        /**\n        * Fires the event {eventName}, resulting in all registered handlers to be executed.\n        * It also collects and returns results of all non-asynchronous handlers\n        * @param {String} eventName - The name of the event to fire\n        * @param {Object} [args] - Any object, will be passed into the handler function as the only argument\n        * @return {Array}\n        */\n        fireEvent: function (eventName) {\n            var evtName = eventName + this.eventPrefix,\n                results = [],\n                result, len, i, eventArgs, method, eventHandler;\n\n            if (this.arrEvents[evtName] != null) {\n                len = this.arrEvents[evtName].length; //optimization\n\n                for (i = 0; i < len; i++) {\n                    /* eslint-disable max-depth */\n                    try {\n                        if (arguments.length > 1) {\n                            if (this.arrEvents[evtName][i].asynch) {\n                                eventArgs = arguments[1];\n                                method = this.arrEvents[evtName][i].method.bind(this);\n                                setTimeout(function () { //eslint-disable-line no-loop-func\n                                    method(eventArgs);\n                                }, 10);\n                            } else {\n                                result = this.arrEvents[evtName][i].method(arguments[1]);\n                            }\n                        } else {\n                            if (this.arrEvents[evtName][i].asynch) { //eslint-disable-line no-lonely-if\n                                eventHandler = this.arrEvents[evtName][i].method;\n                                setTimeout(eventHandler, 1);\n                            } else if (\n                                this.arrEvents &&\n                                this.arrEvents[evtName] &&\n                                this.arrEvents[evtName][i] &&\n                                this.arrEvents[evtName][i].method\n                            ) {\n                                result = this.arrEvents[evtName][i].method();\n                            }\n                        }\n                        results.push(result);\n                    }\n                    catch (e) {\n                        if (this.id) {\n                            alert({\n                                content: 'error: error in ' + this.id + '.fireEvent():\\n\\nevent name: ' +\n                                eventName + '\\n\\nerror message: ' + e.message\n                            });\n                        } else {\n                            alert({\n                                content: 'error: error in [unknown object].fireEvent():\\n\\nevent name: ' +\n                                eventName + '\\n\\nerror message: ' + e.message\n                            });\n                        }\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n            }\n\n            return results;\n        }\n    };\n\n    window.varienGlobalEvents = new varienEvents(); //jscs:ignore requireCapitalizedConstructors\n\n    return window.varienGlobalEvents;\n});\n","mage/adminhtml/globals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global setLocation */\ndefine([\n    'Magento_Ui/js/modal/confirm',\n    'mage/dataPost'\n], function (confirm, dataPost) {\n    'use strict';\n\n    /**\n     * Set of a temporary methods used to provide\n     * backward compatibility with a legacy code.\n     */\n    window.setLocation = function (url) {\n        window.location.href = url;\n    };\n\n    /**\n     * Helper for onclick action.\n     * @param {String} message\n     * @param {String} url\n     * @param {Object} postData\n     * @returns {Boolean}\n     */\n    window.deleteConfirm = function (message, url, postData) {\n        confirm({\n            content: message,\n            actions: {\n                /**\n                 * Confirm action.\n                 */\n                confirm: function () {\n                    if (postData !== undefined) {\n                        postData.action = url;\n                        dataPost().postData(postData);\n                    } else {\n                        setLocation(url);\n                    }\n                }\n            }\n        });\n\n        return false;\n    };\n\n    /**\n     * Helper for onclick action.\n     * @param {String} message\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    window.confirmSetLocation = window.deleteConfirm;\n});\n","mage/adminhtml/browser.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global MediabrowserUtility, FORM_KEY, tinyMceEditors */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'wysiwygAdapter',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree',\n    'mage/mage'\n], function ($, wysiwyg, prompt, confirm, alert, _) {\n    window.MediabrowserUtility = {\n        windowId: 'modal_dialog_message',\n        modalLoaded: false,\n        targetElementId: false,\n        pathId: '',\n\n        /**\n         * @return {Number}\n         */\n        getMaxZIndex: function () {\n            var max = 0,\n                cn = document.body.childNodes,\n                i, el, zIndex;\n\n            for (i = 0; i < cn.length; i++) {\n                el = cn[i];\n                zIndex = el.nodeType == 1 ? parseInt(el.style.zIndex, 10) || 0 : 0; //eslint-disable-line eqeqeq\n\n                if (zIndex < 10000) {\n                    max = Math.max(max, zIndex);\n                }\n            }\n\n            return max + 10;\n        },\n\n        /**\n         * @param {*} url\n         * @param {*} width\n         * @param {*} height\n         * @param {*} title\n         * @param {Object} options\n         */\n        openDialog: function (url, width, height, title, options) {\n            var windowId = this.windowId,\n                content = '<div class=\"popup-window\" id=\"' + windowId + '\"></div>';\n\n            if (this.modalLoaded) {\n\n                if (!_.isUndefined(options)) {\n                    this.modal.modal('option', 'closed', options.closed);\n                }\n\n                this.modal.modal('openModal');\n                this.setTargetElementId(options, url);\n                this.setPathId(url);\n                $(window).trigger('reload.MediaGallery');\n\n                return;\n            }\n\n            this.modal = $(content).modal($.extend({\n                title:  title || 'Insert File...',\n                modalClass: 'magento',\n                type: 'slide',\n                buttons: []\n            }, options));\n\n            this.modal.modal('openModal');\n\n            $.ajax({\n                url: url,\n                type: 'get',\n                context: $(this),\n                showLoader: true\n\n            }).done(function (data) {\n                this.modal.html(data).trigger('contentUpdated');\n                this.modalLoaded = true;\n                this.setTargetElementId(options, url);\n                this.setPathId(url);\n            }.bind(this));\n\n        },\n\n        /**\n         * Setter for endcoded path id\n         */\n        setPathId: function (url) {\n            this.pathId = url.match(/(&|\\/|%26)current_tree_path(=|\\/)([\\s\\S].*?)(\\/|$)/)[3];\n        },\n\n        /**\n         * Setter for targetElementId property\n         *\n         * @param {Object} options\n         * @param {String} url\n         */\n        setTargetElementId: function (options, url) {\n            this.targetElementId = options && options.targetElementId ?\n                options.targetElementId\n                : url.match(/\\/target_element_id\\/([\\s\\S].*?)\\//)[1];\n        },\n\n        /**\n         * Close dialog.\n         */\n        closeDialog: function () {\n            this.modal.modal('closeModal');\n        }\n    };\n\n    $.widget('mage.mediabrowser', {\n        eventPrefix: 'mediabrowser',\n        options: {\n            contentsUrl: null,\n            onInsertUrl: null,\n            newFolderUrl: null,\n            deleteFolderUrl: null,\n            deleteFilesUrl: null,\n            headerText: null,\n            tree: null,\n            currentNode: null,\n            storeId: null,\n            showBreadcrumbs: null,\n            hidden: 'no-display'\n        },\n\n        /**\n         * Proxy creation\n         * @protected\n         */\n        _create: function () {\n            this._on({\n                'click [data-row=file]': 'selectFile',\n                'dblclick [data-row=file]': 'insert',\n                'click #new_folder': 'newFolder',\n                'click #delete_folder': 'deleteFolder',\n                'click #delete_files': 'deleteFiles',\n                'click #insert_files': 'insertSelectedFiles',\n                'fileuploaddone': '_uploadDone',\n                'click [data-row=breadcrumb]': 'selectFolder'\n            });\n\n            $(window).on('reload.MediaGallery', $.proxy(this.reload, this));\n            this.activeNode = null;\n            //tree dont use event bubbling\n            this.tree = this.element.find('[data-role=tree]');\n            this.tree.on('select_node.jstree', $.proxy(this._selectNode, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _selectNode: function (event, data) {\n            var node = data.node;\n\n            this.activeNode = node;\n            this.element.find('#delete_files, #insert_files').toggleClass(this.options.hidden, true);\n            this.element.find('#contents').toggleClass(this.options.hidden, false);\n            this.element.find('#delete_folder')\n                .toggleClass(this.options.hidden, node.id === 'root'); //eslint-disable-line eqeqeq\n            this.element.find('#content_header_text')\n                .html(node.id === 'root' ? this.headerText : node.text); //eslint-disable-line eqeqeq\n\n            this.drawBreadcrumbs(data);\n            this.loadFileList(node);\n        },\n\n        /**\n         * @return {*}\n         */\n        reload: function (uploaded) {\n            return this.loadFileList(this.activeNode, uploaded);\n        },\n\n        /**\n         * @param {Object} element\n         * @param {*} value\n         */\n        insertAtCursor: function (element, value) {\n            var sel, startPos, endPos, scrollTop;\n\n            if ('selection' in document) {\n                //For browsers like Internet Explorer\n                element.focus();\n                sel = document.selection.createRange();\n                sel.text = value;\n                element.focus();\n            } else if (element.selectionStart || element.selectionStart == '0') { //eslint-disable-line eqeqeq\n                //For browsers like Firefox and Webkit based\n                startPos = element.selectionStart;\n                endPos = element.selectionEnd;\n                scrollTop = element.scrollTop;\n                element.value = element.value.substring(0, startPos) + value +\n                    element.value.substring(startPos, endPos) + element.value.substring(endPos, element.value.length);\n                element.focus();\n                element.selectionStart = startPos + value.length;\n                element.selectionEnd = startPos + value.length + element.value.substring(startPos, endPos).length;\n                element.scrollTop = scrollTop;\n            } else {\n                element.value += value;\n                element.focus();\n            }\n        },\n\n        /**\n         * @param {Object} node\n         */\n        loadFileList: function (node, uploaded) {\n            var contentBlock = this.element.find('#contents');\n\n            return $.ajax({\n                url: this.options.contentsUrl,\n                type: 'GET',\n                dataType: 'html',\n                data: {\n                    'form_key': FORM_KEY,\n                    node: node ? node.id : null\n                },\n                context: contentBlock,\n                showLoader: true\n            }).done(function (data) {\n                contentBlock.html(data).trigger('contentUpdated');\n\n                if (uploaded) {\n                    contentBlock.find('.filecnt:last').trigger('click');\n                }\n            });\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        selectFolder: function (event) {\n            this.element.find('[data-id=\"' + $(event.currentTarget).data('node').id + '\"]>a').trigger('click');\n        },\n\n        /**\n         * Insert selected files.\n         */\n        insertSelectedFiles: function () {\n            this.element.find('[data-row=file].selected').trigger('dblclick');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        selectFile: function (event) {\n            var fileRow = $(event.currentTarget);\n\n            fileRow.toggleClass('selected');\n            this.element.find('[data-row=file]').not(fileRow).removeClass('selected');\n            this.element.find('#delete_files, #insert_files')\n                .toggleClass(this.options.hidden, !fileRow.is('.selected'));\n            fileRow.trigger('selectfile');\n        },\n\n        /**\n         * @private\n         */\n        _uploadDone: function () {\n            this.element.find('.file-row').remove();\n            this.reload(true);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @return {Boolean}\n         */\n        insert: function (event) {\n            var fileRow = $(event.currentTarget),\n                targetEl;\n\n            if (!fileRow.prop('id')) {\n                return false;\n            }\n            targetEl = this.getTargetElement();\n\n            if (!targetEl.length) {\n                MediabrowserUtility.closeDialog();\n                throw 'Target element not found for content update';\n            }\n\n            return $.ajax({\n                url: this.options.onInsertUrl,\n                data: {\n                    filename: fileRow.attr('id'),\n                    node: this.activeNode.id,\n                    store: this.options.storeId,\n                    'as_is': typeof targetEl !== 'function' && targetEl.is('textarea') ? 1 : 0,\n                    'force_static_path': typeof targetEl !== 'function' && targetEl.data('force_static_path') ? 1 : 0,\n                    'form_key': FORM_KEY\n                },\n                context: this,\n                showLoader: true\n            }).done($.proxy(function (data) {\n                if (typeof targetEl === 'function') {\n                    targetEl(data, {text: fileRow.find('img').attr('alt')});\n                } else if (targetEl.is('textarea')) {\n                    this.insertAtCursor(targetEl.get(0), data);\n                } else {\n                    targetEl\n                        .val(data)\n                        .data('size', fileRow.data('size'))\n                        .data('mime-type', fileRow.data('mime-type'));\n                }\n                MediabrowserUtility.closeDialog();\n\n                if (typeof targetEl !== 'function') {\n                    targetEl.focus();\n                    jQuery(targetEl).trigger('change');\n                }\n            }, this));\n        },\n\n        /**\n         * Find document target element in next order:\n         *  in acive file browser opener:\n         *  - input field with ID: \"src\" in opener window\n         *  - input field with ID: \"href\" in opener window\n         *  in document:\n         *  - element with target ID\n         *\n         * return {HTMLElement|null}\n         */\n        getTargetElement: function () {\n            var mediaBrowser = window.MediabrowserUtility;\n\n            if (!_.isUndefined(wysiwyg) && wysiwyg.get(mediaBrowser.targetElementId)) {\n                return this.getMediaBrowserOpener() || window;\n            }\n\n            return $('#' + mediaBrowser.targetElementId);\n        },\n\n        /**\n         * Return opener Window object if it exists, not closed and editor is active\n         *\n         * return {Object|null}\n         */\n        getMediaBrowserOpener: function () {\n            var targetElementId = window.MediabrowserUtility.targetElementId;\n\n            if (!_.isUndefined(wysiwyg) && wysiwyg.get(targetElementId) && !_.isUndefined(tinyMceEditors)) {\n                return tinyMceEditors.get(targetElementId).getMediaBrowserOpener();\n            }\n\n            return null;\n        },\n\n        /**\n         * New folder.\n         */\n        newFolder: function () {\n            var self = this;\n\n            prompt({\n                title: this.options.newFolderPrompt,\n                actions: {\n                    /**\n                     * @param {*} folderName\n                     */\n                    confirm: function (folderName) {\n                        $.ajax({\n                            url: self.options.newFolderUrl,\n                            dataType: 'json',\n                            data: {\n                                name: folderName,\n                                node: self.activeNode.id,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function (data) {\n                            if (data.error) {\n                                alert({\n                                    content: data.message\n                                });\n                            } else {\n                                self.tree.jstree(\n                                    'refresh_node',\n                                    self.element.find('[data-id=\"' + self.activeNode.id + '\"]')\n                                );\n                            }\n                        }, this));\n\n                        return true;\n                    }\n                }\n            });\n        },\n\n        /**\n         * Delete folder.\n         */\n        deleteFolder: function () {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteFolderConfirmationMessage,\n                actions: {\n                    /**\n                     * Confirm.\n                     */\n                    confirm: function () {\n                        return $.ajax({\n                            url: self.options.deleteFolderUrl,\n                            dataType: 'json',\n                            data: {\n                                node: self.activeNode.id,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function (data) {\n                            if (data.error) {\n                                alert({\n                                    content: data.message\n                                });\n                            } else {\n                                self.tree.jstree('refresh', self.activeNode.id);\n                                self.reload();\n                                $(window).trigger('fileDeleted.mediabrowser', {\n                                    ids: self.activeNode.id\n                                });\n                            }\n                        }, this));\n                    },\n\n                    /**\n                     * @return {Boolean}\n                     */\n                    cancel: function () {\n                        return false;\n                    }\n                }\n            });\n        },\n\n        /**\n         * Delete files.\n         */\n        deleteFiles: function () {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteFileConfirmationMessage,\n                actions: {\n                    /**\n                     * Confirm.\n                     */\n                    confirm: function () {\n                        var selectedFiles = self.element.find('[data-row=file].selected'),\n                            ids = selectedFiles.map(function () {\n                                return $(this).attr('id');\n                            }).toArray();\n\n                        return $.ajax({\n                            url: self.options.deleteFilesUrl,\n                            data: {\n                                files: ids,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function (data) {\n                            if (data.error) {\n                                alert({\n                                    content: data.message\n                                });\n                            } else {\n                                self.reload();\n                                self.element.find('#delete_files, #insert_files').toggleClass(\n                                    self.options.hidden, true\n                                );\n\n                                $(window).trigger('fileDeleted.mediabrowser', {\n                                    ids: ids\n                                });\n                            }\n                        }, this));\n                    },\n\n                    /**\n                     * @return {Boolean}\n                     */\n                    cancel: function () {\n                        return false;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {Object} data\n         */\n        drawBreadcrumbs: function (data) {\n            var node, breadcrumbs;\n\n            if (this.element.find('#breadcrumbs').length) {\n                this.element.find('#breadcrumbs').remove();\n            }\n            node = data.node;\n\n            if (node.id === 'root') { //eslint-disable-line eqeqeq\n                return;\n            }\n            breadcrumbs = $('<ul class=\"breadcrumbs\" id=\"breadcrumbs\"></ul>');\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            data.instance.get_path(node).each(function (name, index) {\n                if (index > 0) {\n                    breadcrumbs.append($('<li>\\/</li>')); //eslint-disable-line\n                }\n                breadcrumbs.append($('<li />').attr('data-row', 'breadcrumb').text(name));\n\n            });\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            breadcrumbs.insertAfter(this.element.find('#content_header'));\n        }\n    });\n\n    return window.MediabrowserUtility;\n});\n","mage/adminhtml/wysiwyg/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global setLocation, Base64, updateElementAtCursor, varienGlobalEvents */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'wysiwygAdapter',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate',\n    'mage/mage',\n    'mage/validation',\n    'mage/adminhtml/events',\n    'prototype',\n    'Magento_Ui/js/modal/modal'\n], function (jQuery, wysiwyg, alert) {\n    var widgetTools = {\n\n        /**\n         * Sets the widget to be active and is the scope of the slide out if the value is set\n         */\n        activeSelectedNode: null,\n        editMode: false,\n        cursorLocation: 0,\n\n        /**\n         * Set active selected node.\n         *\n         * @param {Object} activeSelectedNode\n         */\n        setActiveSelectedNode: function (activeSelectedNode) {\n            this.activeSelectedNode = activeSelectedNode;\n        },\n\n        /**\n         * Get active selected node.\n         *\n         * @returns {null}\n         */\n        getActiveSelectedNode: function () {\n            return this.activeSelectedNode;\n        },\n\n        /**\n         *\n         * @param {Boolean} editMode\n         */\n        setEditMode: function (editMode) {\n            this.editMode = editMode;\n        },\n\n        /**\n         * @param {*} id\n         * @param {*} html\n         * @return {String}\n         */\n        getDivHtml: function (id, html) {\n\n            if (!html) {\n                html = '';\n            }\n\n            return '<div id=\"' + id + '\">' + html + '</div>';\n        },\n\n        /**\n         * @param {Object} transport\n         */\n        onAjaxSuccess: function (transport) {\n            var response;\n\n            if (transport.responseText.isJSON()) {\n                response = transport.responseText.evalJSON();\n\n                if (response.error) {\n                    throw response;\n                } else if (response.ajaxExpired && response.ajaxRedirect) {\n                    setLocation(response.ajaxRedirect);\n                }\n            }\n        },\n\n        dialogOpened: false,\n\n        /**\n         * @return {Number}\n         */\n        getMaxZIndex: function () {\n            var max = 0,\n                cn = document.body.childNodes,\n                i, el, zIndex;\n\n            for (i = 0; i < cn.length; i++) {\n                el = cn[i];\n                zIndex = el.nodeType == 1 ? parseInt(el.style.zIndex, 10) || 0 : 0; //eslint-disable-line eqeqeq\n\n                if (zIndex < 10000) {\n                    max = Math.max(max, zIndex);\n                }\n            }\n\n            return max + 10;\n        },\n\n        /**\n         * @param {String} widgetUrl\n         */\n        openDialog: function (widgetUrl) {\n            var oThis = this,\n                title = 'Insert Widget',\n                mode = 'new',\n                dialog;\n\n            if (this.editMode) {\n                title = 'Edit Widget';\n                mode = 'edit';\n            }\n\n            if (this.dialogOpened) {\n                return;\n            }\n\n            this.dialogWindow = jQuery('<div/>').modal({\n\n                title: jQuery.mage.__(title),\n                type: 'slide',\n                buttons: [],\n\n                /**\n                 * Opened.\n                 */\n                opened: function () {\n                    dialog = jQuery(this).addClass('loading magento-message');\n\n                    widgetUrl += 'mode/' + mode;\n\n                    new Ajax.Updater($(this), widgetUrl, {\n                        evalScripts: true,\n\n                        /**\n                         * On complete.\n                         */\n                        onComplete: function () {\n                            dialog.removeClass('loading');\n                        }\n                    });\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} modal\n                 */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                    oThis.dialogOpened = false;\n                }\n            });\n\n            this.dialogOpened = true;\n            this.dialogWindow.modal('openModal');\n        }\n    },\n    WysiwygWidget = {};\n\n    WysiwygWidget.Widget = Class.create();\n    WysiwygWidget.Widget.prototype = {\n        /**\n         * @param {HTMLElement} formEl\n         * @param {HTMLElement} widgetEl\n         * @param {*} widgetOptionsEl\n         * @param {*} optionsSourceUrl\n         * @param {*} widgetTargetId\n         */\n        initialize: function (formEl, widgetEl, widgetOptionsEl, optionsSourceUrl, widgetTargetId) {\n            $(formEl).insert({\n                bottom: widgetTools.getDivHtml(widgetOptionsEl)\n            });\n\n            this.formEl = formEl;\n            this.widgetEl = $(widgetEl);\n            this.widgetOptionsEl = $(widgetOptionsEl);\n            this.optionsUrl = optionsSourceUrl;\n            this.optionValues = new Hash({});\n            this.widgetTargetId = widgetTargetId;\n\n            if (typeof wysiwyg != 'undefined' && wysiwyg.activeEditor()) { //eslint-disable-line eqeqeq\n                this.bMark = wysiwyg.activeEditor().selection.getBookmark();\n            }\n\n            // disable -- Please Select -- option from being re-selected\n            this.widgetEl.querySelector('option').setAttribute('disabled', 'disabled');\n\n            Event.observe(this.widgetEl, 'change', this.loadOptions.bind(this));\n\n            this.initOptionValues();\n        },\n\n        /**\n         * @return {String}\n         */\n        getOptionsContainerId: function () {\n            return this.widgetOptionsEl.id + '_' + this.widgetEl.value.gsub(/\\//, '_');\n        },\n\n        /**\n         * @param {*} containerId\n         */\n        switchOptionsContainer: function (containerId) {\n            $$('#' + this.widgetOptionsEl.id + ' div[id^=' + this.widgetOptionsEl.id + ']').each(function (e) {\n                this.disableOptionsContainer(e.id);\n            }.bind(this));\n\n            if (containerId != undefined) { //eslint-disable-line eqeqeq\n                this.enableOptionsContainer(containerId);\n            }\n            this._showWidgetDescription();\n        },\n\n        /**\n         * @param {*} containerId\n         */\n        enableOptionsContainer: function (containerId) {\n            var container = $(containerId);\n\n            container.select('.widget-option').each(function (e) {\n                e.removeClassName('skip-submit');\n\n                if (e.hasClassName('obligatory')) {\n                    e.removeClassName('obligatory');\n                    e.addClassName('required-entry');\n                }\n            });\n            container.removeClassName('no-display');\n        },\n\n        /**\n         * @param {*} containerId\n         */\n        disableOptionsContainer: function (containerId) {\n            var container = $(containerId);\n\n            if (container.hasClassName('no-display')) {\n                return;\n            }\n            container.select('.widget-option').each(function (e) {\n                // Avoid submitting fields of unactive container\n                if (!e.hasClassName('skip-submit')) {\n                    e.addClassName('skip-submit');\n                }\n                // Form validation workaround for unactive container\n                if (e.hasClassName('required-entry')) {\n                    e.removeClassName('required-entry');\n                    e.addClassName('obligatory');\n                }\n            });\n            container.addClassName('no-display');\n        },\n\n        /**\n         * Assign widget options values when existing widget selected in WYSIWYG.\n         *\n         * @return {Boolean}\n         */\n        initOptionValues: function () {\n            var e, widgetCode;\n\n            if (!this.wysiwygExists()) {\n                return false;\n            }\n\n            e = this.getWysiwygNode();\n\n            if (e.localName === 'span') {\n                e = e.firstElementChild;\n            }\n\n            if (e != undefined && e.id) { //eslint-disable-line eqeqeq\n                // attempt to Base64-decode id on selected node; exception is thrown if it is in fact not a widget node\n                try {\n                    widgetCode = Base64.idDecode(e.id);\n                } catch (ex) {\n                    return false;\n                }\n\n                if (widgetCode.indexOf('{{widget') !== -1) {\n                    this.optionValues = new Hash({});\n                    widgetCode.gsub(/([a-z0-9\\_]+)\\s*\\=\\s*[\\\"]{1}([^\\\"]+)[\\\"]{1}/i, function (match) {\n\n                        if (match[1] == 'type') { //eslint-disable-line eqeqeq\n                            this.widgetEl.value = match[2];\n                        } else {\n                            this.optionValues.set(match[1], match[2]);\n                        }\n\n                    }.bind(this));\n\n                    this.loadOptions();\n                }\n            }\n        },\n\n        /**\n         * Load options.\n         */\n        loadOptions: function () {\n            var optionsContainerId,\n                params,\n                msg,\n                msgTmpl,\n                $wrapper,\n                typeName = this.optionValues.get('type_name');\n\n            if (!this.widgetEl.value) {\n                if (typeName) {\n                    msgTmpl = jQuery.mage.__('The widget %1 is no longer available. Select a different widget.');\n                    msg = jQuery.mage.__(msgTmpl).replace('%1', typeName);\n\n                    jQuery('body').notification('clear').notification('add', {\n                        error: true,\n                        message: msg,\n\n                        /**\n                         * @param {String} message\n                         */\n                        insertMethod: function (message) {\n                            $wrapper = jQuery('<div/>').html(message);\n\n                            $wrapper.insertAfter('.modal-slide .page-main-actions');\n                        }\n                    });\n                }\n                this.switchOptionsContainer();\n\n                return;\n            }\n\n            optionsContainerId = this.getOptionsContainerId();\n\n            if ($(optionsContainerId) != undefined) { //eslint-disable-line eqeqeq\n                this.switchOptionsContainer(optionsContainerId);\n\n                return;\n            }\n\n            this._showWidgetDescription();\n\n            params = {\n                'widget_type': this.widgetEl.value,\n                values: this.optionValues\n            };\n            new Ajax.Request(this.optionsUrl, {\n                parameters: {\n                    widget: Object.toJSON(params)\n                },\n\n                /**\n                 * On success.\n                 */\n                onSuccess: function (transport) {\n                    try {\n                        widgetTools.onAjaxSuccess(transport);\n                        this.switchOptionsContainer();\n\n                        if ($(optionsContainerId) == undefined) { //eslint-disable-line eqeqeq\n                            this.widgetOptionsEl.insert({\n                                bottom: widgetTools.getDivHtml(optionsContainerId, transport.responseText)\n                            });\n                        } else {\n                            this.switchOptionsContainer(optionsContainerId);\n                        }\n                    } catch (e) {\n                        alert({\n                            content: e.message\n                        });\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * @private\n         */\n        _showWidgetDescription: function () {\n            var noteCnt = this.widgetEl.next().down('small'),\n                descrCnt = $('widget-description-' + this.widgetEl.selectedIndex),\n                description;\n\n            if (noteCnt != undefined) { //eslint-disable-line eqeqeq\n                description = descrCnt != undefined ? descrCnt.innerHTML : ''; //eslint-disable-line eqeqeq\n                noteCnt.update(description);\n            }\n        },\n\n        /**\n         * Validate field.\n         */\n        validateField: function () {\n            jQuery(this.widgetEl).valid();\n            jQuery('#insert_button').removeClass('disabled');\n        },\n\n        /**\n         * Closes the modal\n         */\n        closeModal: function () {\n            widgetTools.dialogWindow.modal('closeModal');\n        },\n\n        /* eslint-disable max-depth*/\n        /**\n         * Insert widget.\n         */\n        insertWidget: function () {\n            var validationResult,\n                $form = jQuery('#' + this.formEl),\n                formElements,\n                i,\n                params,\n                editor,\n                activeNode;\n\n            // remove cached validator instance, which caches elements to validate\n            jQuery.data($form[0], 'validator', null);\n\n            $form.validate({\n                /**\n                 * Ignores elements with .skip-submit, .no-display ancestor elements\n                 */\n                ignore: function () {\n                    return jQuery(this).closest('.skip-submit, .no-display').length;\n                },\n                errorClass: 'mage-error'\n            });\n\n            validationResult = $form.valid();\n\n            if (validationResult) {\n                formElements = [];\n                i = 0;\n                Form.getElements($(this.formEl)).each(function (e) {\n\n                    if (jQuery(e).closest('.skip-submit, .no-display').length === 0) {\n                        formElements[i] = e;\n                        i++;\n                    }\n                });\n\n                // Add as_is flag to parameters if wysiwyg editor doesn't exist\n                params = Form.serializeElements(formElements);\n\n                if (!this.wysiwygExists()) {\n                    params += '&as_is=1';\n                }\n\n                new Ajax.Request($(this.formEl).action, {\n                    parameters: params,\n                    onComplete: function (transport) {\n                        try {\n                            editor = wysiwyg.get(this.widgetTargetId);\n\n                            widgetTools.onAjaxSuccess(transport);\n                            widgetTools.dialogWindow.modal('closeModal');\n\n                            if (editor) {\n                                editor.focus();\n                                activeNode = widgetTools.getActiveSelectedNode();\n\n                                if (activeNode) {\n                                    editor.selection.select(activeNode);\n                                    editor.selection.setContent(transport.responseText);\n                                    editor.fire('Change');\n                                } else if (this.bMark) {\n                                    editor.selection.moveToBookmark(this.bMark);\n                                }\n                            }\n\n                            if (!activeNode) {\n                                this.updateContent(transport.responseText);\n                            }\n                        } catch (e) {\n                            alert({\n                                content: e.message\n                            });\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        /**\n         * @param {Object} content\n         */\n        updateContent: function (content) {\n            var textarea;\n\n            if (this.wysiwygExists()) {\n                wysiwyg.insertContent(content, false);\n            } else {\n                textarea = document.getElementById(this.widgetTargetId);\n                updateElementAtCursor(textarea, content);\n                varienGlobalEvents.fireEvent('tinymceChange');\n                jQuery(textarea).trigger('change');\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        wysiwygExists: function () {\n            return typeof wysiwyg != 'undefined' && wysiwyg.get(this.widgetTargetId);\n        },\n\n        /**\n         * @return {null|wysiwyg.Editor|*}\n         */\n        getWysiwyg: function () {\n            return wysiwyg.get(this.widgetTargetId);\n        },\n\n        /**\n         * @return {*|Element}\n         */\n        getWysiwygNode: function () {\n            return widgetTools.getActiveSelectedNode() || wysiwyg.activeEditor().selection.getNode();\n        }\n    };\n\n    WysiwygWidget.chooser = Class.create();\n    WysiwygWidget.chooser.prototype = {\n\n        // HTML element A, on which click event fired when choose a selection\n        chooserId: null,\n\n        // Source URL for Ajax requests\n        chooserUrl: null,\n\n        // Chooser config\n        config: null,\n\n        // Chooser dialog window\n        dialogWindow: null,\n\n        // Chooser content for dialog window\n        dialogContent: null,\n\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n\n        /**\n         * @param {*} chooserId\n         * @param {*} chooserUrl\n         * @param {*} config\n         */\n        initialize: function (chooserId, chooserUrl, config) {\n            this.chooserId = chooserId;\n            this.chooserUrl = chooserUrl;\n            this.config = config;\n        },\n\n        /**\n         * @return {String}\n         */\n        getResponseContainerId: function () {\n            return 'responseCnt' + this.chooserId;\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getChooserControl: function () {\n            return $(this.chooserId + 'control');\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getElement: function () {\n            return $(this.chooserId + 'value');\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getElementLabel: function () {\n            return $(this.chooserId + 'label');\n        },\n\n        /**\n         * Open.\n         */\n        open: function () {\n            $(this.getResponseContainerId()).show();\n        },\n\n        /**\n         * Close.\n         */\n        close: function () {\n            $(this.getResponseContainerId()).hide();\n            this.closeDialogWindow();\n        },\n\n        /**\n         * Choose.\n         */\n        choose: function () {\n            // Open dialog window with previously loaded dialog content\n            var responseContainerId;\n\n            if (this.dialogContent) {\n                this.openDialogWindow(this.dialogContent);\n\n                return;\n            }\n            // Show or hide chooser content if it was already loaded\n            responseContainerId = this.getResponseContainerId();\n\n            // Otherwise load content from server\n            new Ajax.Request(this.chooserUrl, {\n                parameters: {\n                    'element_value': this.getElementValue(),\n                    'element_label': this.getElementLabelText()\n                },\n\n                /**\n                 * On success.\n                 */\n                onSuccess: function (transport) {\n                    try {\n                        widgetTools.onAjaxSuccess(transport);\n                        this.dialogContent = widgetTools.getDivHtml(responseContainerId, transport.responseText);\n                        this.openDialogWindow(this.dialogContent);\n                    } catch (e) {\n                        alert({\n                            content: e.message\n                        });\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Open dialog winodw.\n         *\n         * @param {*} content\n         */\n        openDialogWindow: function (content) {\n            this.dialogWindow = jQuery('<div/>').modal({\n                title: this.config.buttons.open,\n                type: 'slide',\n                buttons: [],\n\n                /**\n                 * Opened.\n                 */\n                opened: function () {\n                    jQuery(this).addClass('magento-message');\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} modal\n                 */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                    this.dialogWindow = null;\n                }\n            });\n\n            this.dialogWindow.modal('openModal').append(content);\n        },\n\n        /**\n         * Close dialog window.\n         */\n        closeDialogWindow: function () {\n            this.dialogWindow.modal('closeModal').remove();\n        },\n\n        /**\n         * @return {*|Number}\n         */\n        getElementValue: function () {\n            return this.getElement().value;\n        },\n\n        /**\n         * @return {String}\n         */\n        getElementLabelText: function () {\n            return this.getElementLabel().innerHTML;\n        },\n\n        /**\n         * @param {*} value\n         */\n        setElementValue: function (value) {\n            this.getElement().value = value;\n        },\n\n        /**\n         * @param {*} value\n         */\n        setElementLabel: function (value) {\n            this.getElementLabel().innerHTML = value;\n        }\n    };\n\n    window.WysiwygWidget = WysiwygWidget;\n    window.widgetTools = widgetTools;\n});\n","mage/adminhtml/wysiwyg/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        afterInitialization: 'afterInitialization',\n        afterChangeContent: 'afterChangeContent',\n        afterUndo: 'afterUndo',\n        afterPaste: 'afterPaste',\n        beforeSetContent: 'beforeSetContent',\n        afterSetContent: 'afterSetContent',\n        afterSave: 'afterSave',\n        afterOpenFileBrowser: 'afterOpenFileBrowser',\n        afterFormSubmit: 'afterFormSubmit',\n        afterBlur: 'afterBlur',\n        afterFocus: 'afterFocus'\n    };\n});\n","mage/adminhtml/wysiwyg/tiny_mce/setup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'underscore',\n    'wysiwygAdapter',\n    'module',\n    'mage/translate',\n    'prototype',\n    'mage/adminhtml/events',\n    'mage/adminhtml/browser'\n], function (jQuery, _, wysiwygAdapter, module) {\n    var baseConfig = module.config().config || {},\n        wysiwygSetup = Class.create({\n        wysiwygInstance: null\n    });\n\n    wysiwygSetup.prototype = {\n\n        /**\n         * @param {*} htmlId\n         * @param {Object} config\n         */\n        initialize: function (htmlId, config) {\n            var WysiwygInstancePrototype = new wysiwygAdapter.getAdapterPrototype();\n\n            _.bindAll(this, 'openFileBrowser');\n\n            config = _.extend({}, baseConfig, config || {});\n            this.wysiwygInstance = new WysiwygInstancePrototype(htmlId, config);\n            this.wysiwygInstance.eventBus = this.eventBus = new window.varienEvents();\n        },\n\n        /**\n         * @param {*} mode\n         */\n        setup: function (mode) {\n            this.wysiwygInstance.setup(mode);\n        },\n\n        /**\n         * @param {Object} o\n         */\n        openFileBrowser: function (o) {\n            this.wysiwygInstance.openFileBrowser(o);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        toggle: function () {\n            return this.wysiwygInstance.toggle();\n        },\n\n        /**\n         * On form validation.\n         */\n        onFormValidation: function () {\n            this.wysiwygInstance.onFormValidation();\n        },\n\n        /**\n         * Encodes the content so it can be inserted into the wysiwyg\n         * @param {String} content - The content to be encoded\n         *\n         * @returns {*} - The encoded content\n         */\n        updateContent: function (content) {\n            return this.wysiwygInstance.encodeContent(content);\n        }\n\n    };\n    window.wysiwygSetup = wysiwygSetup;\n\n    return wysiwygSetup;\n});\n","mage/adminhtml/wysiwyg/tiny_mce/html5-schema.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /* eslint-disable max-len */\n\n    var schema = {\n        blockContent: [\n            'address', 'article', 'aside', 'blockquote', 'details', 'dialog', 'div', 'dl', 'fieldset',\n            'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr',\n            'menu', 'nav', 'ol', 'p', 'pre', 'section', 'table', 'ul'\n        ],\n        phrasingContent: [\n            '#comment', '#text', 'a', 'abbr', 'audio', 'b', 'bdi', 'bdo', 'br', 'button', 'canvas',\n            'cite','code', 'command', 'datalist', 'del', 'dfn', 'em', 'embed', 'i', 'iframe', 'img',\n            'input', 'ins', 'kbd', 'keygen', 'label', 'map', 'mark', 'meter', 'noscript', 'object',\n            'output', 'picture', 'progress', 'q', 'ruby', 's', 'samp', 'script', 'select', 'small',\n            'span', 'strong', 'sub', 'sup', 'textarea', 'time', 'u', 'var', 'video', 'wbr'\n        ],\n        blockElements: [\n            'address', 'article', 'aside', 'blockquote', 'caption', 'center', 'datalist', 'dd', 'dir', 'div',\n            'dl', 'dt', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6',\n            'header', 'hgroup', 'hr', 'isindex', 'li', 'menu', 'nav', 'noscript', 'ol', 'optgroup', 'option',\n            'p', 'pre', 'section', 'select', 'table', 'tbody', 'td', 'tfoot', 'th', 'thead', 'tr', 'ul'\n        ],\n        boolAttrs: [\n            'autoplay', 'checked', 'compact', 'controls', 'declare', 'defer', 'disabled', 'ismap', 'loop',\n            'multiple', 'nohref', 'noresize', 'noshade', 'nowrap', 'readonly', 'selected'\n        ],\n        shortEnded: [\n            'area', 'base', 'basefont', 'br', 'col', 'embed', 'frame', 'hr', 'img', 'input', 'isindex',\n            'link', 'meta', 'param', 'source', 'track', 'wbr'\n        ],\n        whiteSpace: [\n            'audio', 'iframe', 'noscript', 'object', 'pre', 'script', 'style', 'textarea', 'video'\n        ],\n        selfClosing: [\n            'colgroup', 'dd', 'dt', 'li', 'option', 'p', 'td', 'tfoot', 'th', 'thead', 'tr'\n        ]\n    };\n\n    schema.flowContent = schema.blockContent.concat(schema.phrasingContent, ['style']);\n    schema.nonEmpty = ['td', 'th', 'iframe', 'video', 'audio', 'object', 'script', 'i', 'em', 'span'].concat(schema.shortEnded);\n\n    _.extend(schema, (function (phrasingContent, flowContent) {\n        var validElements   = [],\n            validChildren   = [],\n            compiled        = {},\n            globalAttrs,\n            rawData;\n\n        globalAttrs = [\n            'id', 'dir', 'lang', 'class', 'style', 'title', 'hidden', 'onclick', 'onkeyup',\n            'tabindex', 'dropzone', 'accesskey', 'draggable', 'translate', 'onmouseup',\n            'onkeydown', 'spellcheck', 'ondblclick', 'onmouseout', 'onkeypress', 'contextmenu',\n            'onmousedown', 'onmouseover', 'onmousemove', 'contenteditable'\n        ];\n\n        rawData = [\n            ['html', 'manifest', 'head body'],\n            ['head', '', 'base command link meta noscript script style title'],\n            ['title hr noscript br'],\n            ['base', 'href target'],\n            ['link', 'href rel media hreflang type sizes hreflang'],\n            ['meta', 'name http-equiv content charset'],\n            ['style', 'media type scoped'],\n            ['script', 'src async defer type charset'],\n            ['body', 'onafterprint onbeforeprint onbeforeunload onblur onerror onfocus ' +\n                'onhashchange onload onmessage onoffline ononline onpagehide onpageshow ' +\n                'onpopstate onresize onscroll onstorage onunload background bgcolor text link vlink alink', flowContent\n            ],\n            ['caption', '', _.without(flowContent, 'table')],\n            ['address dt dd div', '', flowContent],\n            ['h1 h2 h3 h4 h5 h6 pre p abbr code var samp kbd sub sup i b u bdo span legend em strong small s cite dfn', '', phrasingContent],\n            ['blockquote', 'cite', flowContent],\n            ['ol', 'reversed start type', 'li'],\n            ['ul', 'type compact', 'li'],\n            ['li', 'value type', flowContent],\n            ['dl', '', 'dt dd'],\n            ['a', 'href target rel media hreflang type charset name rev shape coords download', phrasingContent],\n            ['q', 'cite', phrasingContent],\n            ['ins del', 'cite datetime', flowContent],\n            ['img', 'src sizes srcset alt usemap ismap width height name longdesc align border hspace vspace'],\n            ['iframe', 'src name width height longdesc frameborder marginwidth marginheight scrolling align sandbox seamless allowfullscreen', flowContent],\n            ['embed', 'src type width height'],\n            ['object', 'data type typemustmatch name usemap form width height declare classid code codebase codetype archive standby align border hspace vspace', flowContent.concat(['param'])],\n            ['param', 'name value valuetype type'],\n            ['map', 'name', flowContent.concat(['area'])],\n            ['area', 'alt coords shape href target rel media hreflang type nohref'],\n            ['table', 'border summary width frame rules cellspacing cellpadding align bgcolor', 'caption colgroup thead tfoot tbody tr col'],\n            ['colgroup', 'span width align char charoff valign', 'col'],\n            ['col', 'span'],\n            ['tbody thead tfoot', 'align char charoff valign', 'tr'],\n            ['tr', 'align char charoff valign bgcolor', 'td th'],\n            ['td', 'colspan rowspan headers abbr axis scope align char charoff valign nowrap bgcolor width height', flowContent],\n            ['th', 'colspan rowspan headers scope abbr axis align char charoff valign nowrap bgcolor width height accept', flowContent],\n            ['form', 'accept-charset action autocomplete enctype method name novalidate target onsubmit onreset', flowContent],\n            ['fieldset', 'disabled form name', flowContent.concat(['legend'])],\n            ['label', 'form for', phrasingContent],\n            ['input', 'accept alt autocomplete checked dirname disabled form formaction formenctype formmethod formnovalidate ' +\n                'formtarget height list max maxlength min multiple name pattern readonly required size src step type value width usemap align'\n            ],\n            ['button', 'disabled form formaction formenctype formmethod formnovalidate formtarget name type value', phrasingContent],\n            ['select', 'disabled form multiple name required size onfocus onblur onchange', 'option optgroup'],\n            ['optgroup', 'disabled label', 'option'],\n            ['option', 'disabled label selected value'],\n            ['textarea', 'cols dirname disabled form maxlength name readonly required rows wrap'],\n            ['menu', 'type label', flowContent.concat(['li'])],\n            ['noscript', '', flowContent],\n            ['wbr'],\n            ['ruby', '', phrasingContent.concat(['rt', 'rp'])],\n            ['figcaption', '', flowContent],\n            ['mark rt rp summary bdi', '', phrasingContent],\n            ['canvas', 'width height', flowContent],\n            ['video', 'src crossorigin poster preload autoplay mediagroup loop muted controls width height buffered', flowContent.concat(['track', 'source'])],\n            ['audio', 'src crossorigin preload autoplay mediagroup loop muted controls buffered volume', flowContent.concat(['track', 'source'])],\n            ['picture', '', 'img source'],\n            ['source', 'src srcset type media sizes'],\n            ['track', 'kind src srclang label default'],\n            ['datalist', '', phrasingContent.concat(['option'])],\n            ['article section nav aside header footer', '', flowContent],\n            ['hgroup', '', 'h1 h2 h3 h4 h5 h6'],\n            ['figure', '', flowContent.concat(['figcaption'])],\n            ['time', 'datetime', phrasingContent],\n            ['dialog', 'open', flowContent],\n            ['command', 'type label icon disabled checked radiogroup command'],\n            ['output', 'for form name', phrasingContent],\n            ['progress', 'value max', phrasingContent],\n            ['meter', 'value min max low high optimum', phrasingContent],\n            ['details', 'open', flowContent.concat(['summary'])],\n            ['keygen', 'autofocus challenge disabled form keytype name'],\n            ['script', 'language xml:space'],\n            ['style', 'xml:space'],\n            ['embed', 'align name hspace vspace'],\n            ['br', 'clear'],\n            ['applet', 'codebase archive code object alt name width height align hspace vspace'],\n            ['font basefont', 'size color face'],\n            ['h1 h2 h3 h4 h5 h6 div p legend caption', 'align'],\n            ['ol dl menu dir', 'compact'],\n            ['pre', 'width xml:space'],\n            ['hr', 'align noshade size width'],\n            ['isindex', 'prompt'],\n            ['col', 'width align char charoff valign'],\n            ['input button select textarea', 'autofocus'],\n            ['input textarea', 'placeholder onselect onchange onfocus onblur'],\n            ['link script img', 'crossorigin']\n        ];\n\n        rawData.forEach(function (data) {\n            var nodes       = data[0].split(' '),\n                attributes  = data[1] || [],\n                children    = data[2] || [],\n                ni          = nodes.length,\n                nodeName,\n                schemaData;\n\n            if (typeof attributes === 'string') {\n                attributes = attributes.split(' ');\n            }\n\n            if (typeof children === 'string') {\n                children = children.split(' ');\n            }\n\n            while (ni--) {\n                nodeName    = nodes[ni];\n                schemaData  = compiled[nodeName] || {};\n\n                compiled[nodeName] = {\n                    attributes: _.union(schemaData.attributes, globalAttrs, attributes),\n                    children: _.union(schemaData.children, children)\n                };\n            }\n        });\n\n        ['a', 'dfn', 'form', 'meter', 'progress'].forEach(function (nodeName) {\n            var node = compiled[nodeName];\n\n            node.children = _.without(node.children, nodeName);\n        });\n\n        _.each(compiled, function (node, nodeName) {\n            var filteredAttributes = [];\n\n            _.each(node.attributes, function (attribute) { //eslint-disable-line max-nested-callbacks\n                // Disallowing usage of 'on*' attributes.\n                if (!/^on/.test(attribute)) {\n                    filteredAttributes.push(attribute);\n                }\n            });\n\n            node.attributes = filteredAttributes;\n\n            validElements.push(nodeName + '[' + node.attributes.join('|') + ']');\n            validChildren.push(nodeName + '[' + node.children.join('|') + ']');\n        });\n\n        return {\n            nodes: compiled,\n            validElements: validElements,\n            validChildren: validChildren\n        };\n    })(schema.phrasingContent, schema.flowContent));\n\n    return schema;\n});\n","mage/adminhtml/wysiwyg/tiny_mce/tinymce5Adapter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global popups, tinyMceEditors, MediabrowserUtility, Base64 */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'underscore',\n    'tinymce',\n    'mage/adminhtml/events',\n    'mage/adminhtml/wysiwyg/events',\n    'mage/translate',\n    'prototype',\n    'jquery/ui'\n], function (jQuery, _, tinyMCE, varienGlobalEvents, wysiwygEvents) {\n    'use strict';\n\n    var tinyMceWysiwyg = Class.create();\n\n    tinyMceWysiwyg.prototype = {\n        mediaBrowserOpener: null,\n        mediaBrowserTargetElementId: null,\n        magentoVariablesPlugin: null,\n        mode: 'exact',\n\n        /**\n         * @param {*} htmlId\n         * @param {Object} config\n         */\n        initialize: function (htmlId, config) {\n            this.id = htmlId;\n            this.config = config;\n\n            _.bindAll(\n                this,\n                'beforeSetContent',\n                'saveContent',\n                'onChangeContent',\n                'openFileBrowser',\n                'updateTextArea',\n                'onUndo',\n                'removeEvents'\n            );\n\n            varienGlobalEvents.attachEventHandler('tinymceChange', this.onChangeContent);\n            varienGlobalEvents.attachEventHandler('tinymceBeforeSetContent', this.beforeSetContent);\n            varienGlobalEvents.attachEventHandler('tinymceSetContent', this.updateTextArea);\n            varienGlobalEvents.attachEventHandler('tinymceSaveContent', this.saveContent);\n            varienGlobalEvents.attachEventHandler('tinymceUndo', this.onUndo);\n\n            if (typeof tinyMceEditors === 'undefined') {\n                window.tinyMceEditors = $H({});\n            }\n\n            tinyMceEditors.set(this.id, this);\n        },\n\n        /**\n         * Ensures the undo operation works properly\n         */\n        onUndo: function () {\n            this.addContentEditableAttributeBackToNonEditableNodes();\n        },\n\n        /**\n         * Setup TinyMCE editor\n         */\n        setup: function (mode) {\n            var deferreds = [],\n                settings,\n                self = this;\n\n            this.turnOff();\n\n            if (this.config.plugins) {\n                this.config.plugins.forEach(function (plugin) {\n                    var deferred;\n\n                    self.addPluginToToolbar(plugin.name, '|');\n\n                    if (!plugin.src) {\n                        return;\n                    }\n\n                    deferred = jQuery.Deferred();\n                    deferreds.push(deferred);\n\n                    require([plugin.src], function (factoryFn) {\n                        if (typeof factoryFn === 'function') {\n                            factoryFn(plugin.options);\n                        }\n\n                        tinyMCE.PluginManager.load(plugin.name, plugin.src);\n                        deferred.resolve();\n                    });\n                });\n            }\n\n            if (jQuery.isReady) {\n                tinyMCE.dom.Event.domLoaded = true;\n            }\n\n            settings = this.getSettings();\n\n            if (mode === 'inline') {\n                settings.inline = true;\n\n                if (!isNaN(settings.toolbarZIndex)) {\n                    tinyMCE.ui.FloatPanel.zIndex = settings.toolbarZIndex;\n                }\n\n                this.removeEvents(self.id);\n            }\n\n            jQuery.when.apply(jQuery, deferreds).done(function () {\n                tinyMCE.init(settings);\n                this.getPluginButtons().hide();\n                varienGlobalEvents.clearEventHandlers('open_browser_callback');\n                this.eventBus.clearEventHandlers('open_browser_callback');\n                this.eventBus.attachEventHandler('open_browser_callback', tinyMceEditors.get(self.id).openFileBrowser);\n            }.bind(this));\n        },\n\n        /**\n         * Remove events from instance.\n         *\n         * @param {String} wysiwygId\n         */\n        removeEvents: function (wysiwygId) {\n            var editor;\n\n            if (typeof tinyMceEditors !== 'undefined' && tinyMceEditors.get(wysiwygId)) {\n                editor = tinyMceEditors.get(wysiwygId);\n                varienGlobalEvents.removeEventHandler('tinymceChange', editor.onChangeContent);\n            }\n        },\n\n        /**\n         * Add plugin to the toolbar if not added.\n         *\n         * @param {String} plugin\n         * @param {String} separator\n         */\n        addPluginToToolbar: function (plugin, separator) {\n            var plugins = this.config.tinymce.plugins.split(' '),\n                toolbar = this.config.tinymce.toolbar.split(' ');\n\n            if (plugins.indexOf(plugin) === -1) {\n                plugins.push(plugin);\n            }\n\n            if (toolbar.indexOf(plugin) === -1) {\n                toolbar.push(separator || '', plugin);\n            }\n\n            this.config.tinymce.plugins = plugins.join(' ');\n            this.config.tinymce.toolbar = toolbar.join(' ');\n        },\n\n        /**\n         * Set the status of the toolbar to disabled or enabled (true for enabled, false for disabled)\n         * @param {Boolean} enabled\n         */\n        setToolbarStatus: function (enabled) {\n            var controlIds = this.get(this.getId()).theme.panel.rootControl.controlIdLookup;\n\n            _.each(controlIds, function (controlId) {\n                controlId.disabled(!enabled);\n                controlId.canFocus = enabled;\n\n                if (controlId.tooltip) {\n                    controlId.tooltip().state.set('rendered', enabled);\n\n                    if (enabled) {\n                        jQuery(controlId.getEl()).children('button').addBack().removeAttr('style');\n                    } else {\n                        jQuery(controlId.getEl()).children('button').addBack().attr('style', 'color: inherit;' +\n                            'background-color: inherit;' +\n                            'border-color: transparent;'\n                        );\n                    }\n                }\n            });\n        },\n\n        /**\n         * @return {Object}\n         */\n        getSettings: function () {\n            var settings,\n                eventBus = this.eventBus;\n\n            settings = {\n                selector: '#' + this.getId(),\n                theme: 'silver',\n                skin: 'oxide',\n                'toolbar_mode': 'wrap',\n                'entity_encoding': 'raw',\n                'convert_urls': false,\n                'content_css': this.config.tinymce['content_css'],\n                'relative_urls': true,\n                'valid_children': '+body[style]',\n                menubar: false,\n                plugins: this.config.tinymce.plugins,\n                toolbar: this.config.tinymce.toolbar,\n                adapter: this,\n                'body_id': 'html-body',\n\n                /**\n                 * @param {Object} editor\n                 */\n                setup: function (editor) {\n                    var onChange;\n\n                    editor.on('BeforeSetContent', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceBeforeSetContent', evt);\n                        eventBus.fireEvent(wysiwygEvents.beforeSetContent);\n                    });\n\n                    editor.on('SaveContent', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceSaveContent', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterSave);\n                    });\n\n                    editor.on('paste', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymcePaste', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterPaste);\n                    });\n\n                    editor.on('PostProcess', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceSaveContent', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterSave);\n                    });\n\n                    editor.on('undo', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceUndo', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterUndo);\n                    });\n\n                    editor.on('focus', function () {\n                        eventBus.fireEvent(wysiwygEvents.afterFocus);\n                    });\n\n                    editor.on('blur', function () {\n                        eventBus.fireEvent(wysiwygEvents.afterBlur);\n                    });\n\n                    /**\n                     * @param {*} evt\n                     */\n                    onChange = function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceChange', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterChangeContent);\n                    };\n\n                    editor.on('Change', onChange);\n                    editor.on('keyup', onChange);\n\n                    editor.on('ExecCommand', function (cmd) {\n                        varienGlobalEvents.fireEvent('tinymceExecCommand', cmd);\n                    });\n\n                    editor.on('init', function (args) {\n                        varienGlobalEvents.fireEvent('wysiwygEditorInitialized', args.target);\n                        eventBus.fireEvent(wysiwygEvents.afterInitialization);\n                    });\n                }\n            };\n\n            // Set default initial height\n            settings['min_height'] = this.config.tinymce['min_height'] ? this.config.tinymce['min_height'] : 250;\n\n            if (this.config.skin) {\n                settings.skin = this.config.skin;\n            }\n\n            if (this.config['toolbar_mode']) {\n                settings['toolbar_mode'] = this.config['toolbar_mode'];\n            }\n\n            if (this.config.baseStaticUrl && this.config.baseStaticDefaultUrl) {\n                settings['document_base_url'] = this.config.baseStaticUrl;\n            }\n            // Set the document base URL\n            if (this.config['document_base_url']) {\n                settings['document_base_url'] = this.config['document_base_url'];\n            }\n\n            if (this.config['files_browser_window_url']) {\n                settings['file_picker_callback_types'] = 'file image media';\n\n                /**\n                 * @param {*} callback\n                 * @param {*} value\n                 * @param {*} meta\n                 */\n                settings['file_picker_callback'] = function (callback, value, meta) {\n                    var payload = {\n                        callback: callback,\n                        value: value,\n                        meta: meta\n                    };\n\n                    varienGlobalEvents.fireEvent('open_browser_callback', payload);\n                    this.eventBus.fireEvent('open_browser_callback', payload);\n                }.bind(this);\n            }\n\n            if (this.config.width) {\n                settings.width = this.config.width;\n            }\n\n            if (this.config.height) {\n                settings.height = this.config.height;\n            }\n\n            if (this.config.plugins) {\n                settings.magentoPluginsOptions = {};\n\n                _.each(this.config.plugins, function (plugin) {\n                    settings.magentoPluginsOptions[plugin.name] = plugin.options;\n                });\n            }\n\n            if (this.config.settings) {\n                Object.extend(settings, this.config.settings);\n            }\n\n            return settings;\n        },\n\n        /**\n         * @param {String} id\n         */\n        get: function (id) {\n            return tinyMCE.get(id);\n        },\n\n        /**\n         * @return {String|null}\n         */\n        getId: function () {\n            return this.id || (this.activeEditor() ? this.activeEditor().id : null) || tinyMceEditors.values()[0].id;\n        },\n\n        /**\n         * @return {Object}\n         */\n        activeEditor: function () {\n            return tinyMCE.activeEditor;\n        },\n\n        /**\n         * Insert content to active editor.\n         *\n         * @param {String} content\n         * @param {Boolean} ui\n         */\n        insertContent: function (content, ui) {\n            this.activeEditor().execCommand('mceInsertContent', typeof ui !== 'undefined' ? ui : false, content);\n        },\n\n        /**\n         * Replace entire contents of wysiwyg with string content parameter\n         *\n         * @param {String} content\n         */\n        setContent: function (content) {\n            this.get(this.getId()).setContent(content);\n        },\n\n        /**\n         * Set caret location in WYSIWYG editor.\n         *\n         * @param {Object} targetElement\n         */\n        setCaretOnElement: function (targetElement) {\n            this.activeEditor().selection.select(targetElement);\n            this.activeEditor().selection.collapse();\n        },\n\n        /**\n         * @param {Object} o\n         */\n        openFileBrowser: function (o) {\n            var typeTitle = this.translate('Select Images'),\n                storeId = this.config['store_id'] ? this.config['store_id'] : 0,\n                frameDialog = jQuery('div.mce-container[role=\"dialog\"]'),\n                self = this,\n                wUrl = this.config['files_browser_window_url'] +\n                    'target_element_id/' + this.getId() + '/' +\n                    'store/' + storeId + '/';\n\n            this.mediaBrowserOpener = o.callback;\n\n            if (typeof o.meta.filetype !== 'undefined' && o.meta.filetype !== '') { //eslint-disable-line eqeqeq\n                wUrl = wUrl + 'type/' + o.meta.filetype + '/';\n            }\n\n            frameDialog.hide();\n            jQuery('.tox-tinymce-aux').hide();\n\n            require(['mage/adminhtml/browser'], function () {\n                MediabrowserUtility.openDialog(wUrl, false, false, typeTitle, {\n                        /**\n                         * Closed.\n                         */\n                        closed: function () {\n                            frameDialog.show();\n                            jQuery('.tox-tinymce-aux').show();\n                        },\n\n                        targetElementId: self.activeEditor() ? self.activeEditor().id : null\n                    }\n                );\n            });\n        },\n\n        /**\n         * @param {String} string\n         * @return {String}\n         */\n        translate: function (string) {\n            return jQuery.mage.__ ? jQuery.mage.__(string) : string;\n        },\n\n        /**\n         * @return {null}\n         */\n        getMediaBrowserOpener: function () {\n            return this.mediaBrowserOpener;\n        },\n\n        /**\n         * @return {null}\n         */\n        getMediaBrowserTargetElementId: function () {\n            return this.mediaBrowserTargetElementId;\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getToggleButton: function () {\n            return $('toggle' + this.getId());\n        },\n\n        /**\n         * Get plugins button.\n         */\n        getPluginButtons: function () {\n            return jQuery('#buttons' + this.getId() + ' > button.plugin');\n        },\n\n        /**\n         * @param {*} mode\n         * @return {wysiwygSetup}\n         */\n        turnOn: function (mode) {\n            this.closePopups();\n\n            this.setup(mode);\n\n            this.getPluginButtons().hide();\n\n            tinyMCE.execCommand('mceAddControl', false, this.getId());\n\n            return this;\n        },\n\n        /**\n         * @param {String} name\n         */\n        closeEditorPopup: function (name) {\n            if (typeof popups !== 'undefined' && popups[name] !== undefined && !popups[name].closed) {\n                popups[name].close();\n            }\n        },\n\n        /**\n         * @return {wysiwygSetup}\n         */\n        turnOff: function () {\n            this.closePopups();\n\n            this.getPluginButtons().show();\n\n            tinyMCE.execCommand('mceRemoveEditor', false, this.getId());\n\n            return this;\n        },\n\n        /**\n         * Close popups.\n         */\n        closePopups: function () {\n            // close all popups to avoid problems with updating parent content area\n            varienGlobalEvents.fireEvent('wysiwygClosePopups');\n            this.closeEditorPopup('browser_window' + this.getId());\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        toggle: function () {\n            var content;\n\n            if (!tinyMCE.get(this.getId())) {\n                this.turnOn();\n\n                return true;\n            }\n\n            content = this.get(this.getId()) ? this.get(this.getId()).getContent() : this.getTextArea().val();\n\n            this.turnOff();\n\n            if (content.match(/{{.+?}}/g)) {\n                this.getTextArea().val(content.replace(/&quot;/g, '\"'));\n            }\n\n            return false;\n        },\n\n        /**\n         * On form validation.\n         */\n        onFormValidation: function () {\n            if (tinyMCE.get(this.getId())) {\n                $(this.getId()).value = tinyMCE.get(this.getId()).getContent();\n            }\n        },\n\n        /**\n         * On change content.\n         */\n        onChangeContent: function () {\n            // Add \"changed\" to tab class if it exists\n            var tab;\n\n            this.updateTextArea();\n\n            if (this.config['tab_id']) {\n                tab = $$('a[id$=' + this.config['tab_id'] + ']')[0];\n\n                if ($(tab) != undefined && $(tab).hasClassName('tab-item-link')) { //eslint-disable-line eqeqeq\n                    $(tab).addClassName('changed');\n                }\n            }\n        },\n\n        /**\n         * @param {Object} o\n         */\n        beforeSetContent: function (o) {\n            o.content = this.encodeContent(o.content);\n        },\n\n        /**\n         * @param {Object} o\n         */\n        saveContent: function (o) {\n            o.content = this.decodeContent(o.content);\n        },\n\n        /**\n         * Return the content stored in the WYSIWYG field\n         * @param {String} id\n         * @return {String}\n         */\n        getContent: function (id) {\n            return id ? this.get(id).getContent() : this.get(this.getId()).getContent();\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getAdapterPrototype: function () {\n            return tinyMceWysiwyg;\n        },\n\n        /**\n         * Fix range selection placement when typing.  This fixes MAGETWO-84769\n         * @param {Object} editor\n         */\n        fixRangeSelection: function (editor) {\n            var selection = editor.selection,\n                dom = editor.dom,\n                rng = dom.createRng(),\n                doc = editor.getDoc(),\n                markerHtml,\n                marker;\n\n            // Validate the range we're trying to fix is contained within the current editors document\n            if (!selection.getContent().length && jQuery.contains(doc, selection.getRng().startContainer)) {\n                markerHtml = '<span id=\"mce_marker\" data-mce-type=\"bookmark\">\\uFEFF</span>';\n                selection.setContent(markerHtml);\n                marker = dom.get('mce_marker');\n                rng.setStartBefore(marker);\n                rng.setEndBefore(marker);\n                dom.remove(marker);\n                selection.setRng(rng);\n            }\n        },\n\n        /**\n         * Update text area.\n         */\n        updateTextArea: function () {\n            var editor = this.get(this.getId()),\n                content;\n\n            if (!editor || editor.id !== this.activeEditor().id) {\n                return;\n            }\n\n            this.addContentEditableAttributeBackToNonEditableNodes();\n\n            content = editor.getContent();\n            content = this.decodeContent(content);\n\n            this.getTextArea().val(content).trigger('change');\n        },\n\n        /**\n         * @return {Object} jQuery textarea element\n         */\n        getTextArea: function () {\n            return jQuery('#' + this.getId());\n        },\n\n        /**\n         * Set the status of the editor and toolbar\n         *\n         * @param {Boolean} enabled\n         */\n        setEnabledStatus: function (enabled) {\n            if (this.activeEditor()) {\n                this.activeEditor().getBody().setAttribute('contenteditable', enabled);\n                this.activeEditor().readonly = !enabled;\n                this.setToolbarStatus(enabled);\n            }\n\n            if (enabled) {\n                this.getTextArea().prop('disabled', false);\n            } else {\n                this.getTextArea().prop('disabled', 'disabled');\n            }\n        },\n\n        /**\n         * Retrieve directives URL with substituted directive value.\n         *\n         * @param {String} directive\n         */\n        makeDirectiveUrl: function (directive) {\n            return this.config['directives_url']\n                .replace(/directive/, 'directive/___directive/' + directive)\n                .replace(/\\/$/, '');\n        },\n\n        /**\n         * Convert {{directive}} style attributes syntax to absolute URLs\n         * @param {Object} content\n         * @return {*}\n         */\n        encodeDirectives: function (content) {\n            // collect all HTML tags with attributes that contain directives\n            return content.gsub(/<([a-z0-9\\-\\_]+[^>]+?)([a-z0-9\\-\\_]+=\"[^\"]*?\\{\\{.+?\\}\\}.*?\".*?)>/i, function (match) {\n                var attributesString = match[2],\n                    decodedDirectiveString;\n\n                // process tag attributes string\n                attributesString = attributesString.gsub(/([a-z0-9\\-\\_]+)=\"(.*?)(\\{\\{.+?\\}\\})(.*?)\"/i, function (m) {\n                    decodedDirectiveString = encodeURIComponent(Base64.mageEncode(m[3].replace(/&quot;/g, '\"') + m[4]));\n\n                    return m[1] + '=\"' + m[2] + this.makeDirectiveUrl(decodedDirectiveString) + '\"';\n                }.bind(this));\n\n                return '<' + match[1] + attributesString + '>';\n            }.bind(this));\n        },\n\n        /**\n         * Convert absolute URLs to {{directive}} style attributes syntax\n         * @param {Object} content\n         * @return {*}\n         */\n        decodeDirectives: function (content) {\n            var directiveUrl = this.makeDirectiveUrl('%directive%').split('?')[0], // remove query string from directive\n                // escape special chars in directives url to use in regular expression\n                regexEscapedDirectiveUrl = directiveUrl.replace(/([$^.?*!+:=()\\[\\]{}|\\\\])/g, '\\\\$1'),\n                regexDirectiveUrl = regexEscapedDirectiveUrl\n                    .replace(\n                        '%directive%',\n                        '([a-zA-Z0-9,_-]+(?:%2[A-Z]|)+\\/?)(?:(?!\").)*'\n                    ) + '/?(\\\\\\\\?[^\"]*)?', // allow optional query string\n                reg = new RegExp(regexDirectiveUrl);\n\n            return content.gsub(reg, function (match) {\n                return Base64.mageDecode(decodeURIComponent(match[1]).replace(/\\/$/, '')).replace(/\"/g, '&quot;');\n            });\n        },\n\n        /**\n         * @param {Object} attributes\n         * @return {Object}\n         */\n        parseAttributesString: function (attributes) {\n            var result = {};\n\n            // Decode &quot; entity, as regex below does not support encoded quote\n            attributes = attributes.replace(/&quot;/g, '\"');\n\n            attributes.gsub(\n                /(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/,\n                function (match) {\n                    result[match[1]] = match[2];\n                }\n            );\n\n            return result;\n        },\n\n        /**\n         * @param {Object} content\n         * @return {*}\n         */\n        decodeContent: function (content) {\n            if (this.config['add_directives']) {\n                content = this.decodeDirectives(content);\n            }\n\n            content = varienGlobalEvents.fireEventReducer('wysiwygDecodeContent', content);\n\n            return content;\n        },\n\n        /**\n         * @param {Object} content\n         * @return {*}\n         */\n        encodeContent: function (content) {\n            if (this.config['add_directives']) {\n                content = this.encodeDirectives(content);\n            }\n\n            content = varienGlobalEvents.fireEventReducer('wysiwygEncodeContent', content);\n\n            return content;\n        },\n\n        /**\n         * Reinstate contenteditable attributes on .mceNonEditable nodes\n         */\n        addContentEditableAttributeBackToNonEditableNodes: function () {\n            jQuery('.mceNonEditable', this.activeEditor().getDoc()).attr('contenteditable', false);\n        },\n\n        /**\n         * Calls the save method on all editor instances in the collection.\n         */\n        triggerSave: function () {\n            tinyMCE.triggerSave();\n        }\n    };\n\n    return tinyMceWysiwyg.prototype;\n});\n","mage/adminhtml/wysiwyg/tiny_mce/plugins/magentovariable/editor_plugin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global tinymce, MagentovariablePlugin, varienGlobalEvents, Base64 */\n/* eslint-disable strict */\ndefine([\n    'Magento_Variable/js/config-directive-generator',\n    'Magento_Variable/js/custom-directive-generator',\n    'wysiwygAdapter',\n    'jquery',\n    'mage/adminhtml/tools'\n], function (configDirectiveGenerator, customDirectiveGenerator, wysiwyg, jQuery) {\n    return function (config) {\n        tinymce.create('tinymce.plugins.magentovariable', {\n\n            /**\n             * Initialize editor plugin.\n             *\n             * @param {tinymce.editor} editor - Editor instance that the plugin is initialized in.\n             */\n            init: function (editor) {\n                var self = this;\n\n                /**\n                 * Add new command to open variables selector slideout.\n                 */\n                editor.addCommand('openVariablesSlideout', function (commandConfig) {\n                    var selectedElement;\n\n                    if (commandConfig) {\n                        selectedElement = commandConfig.selectedElement;\n                    } else {\n                        selectedElement = tinymce.activeEditor.selection.getNode();\n                    }\n                    MagentovariablePlugin.setEditor(editor);\n                    MagentovariablePlugin.loadChooser(\n                        config.url,\n                        wysiwyg.getId(),\n                        selectedElement\n                    );\n                });\n\n                /**\n                 * Add button to the editor toolbar.\n                 */\n                editor.ui.registry.addIcon(\n                    'magentovariable',\n                    '<svg width=\"24\" height=\"24\" viewBox=\"0 0 32.000000 32.000000\" ' +\n                    'preserveAspectRatio=\"xMidYMid meet\"><g transform=\"translate(0.000000,32.000000) ' +\n                    'scale(0.100000,-0.100000)\" fill=\"#000000\" stroke=\"none\"><path d=\"M68 250 c-56 -44 -75 -136 -37 ' +\n                    '-184 27 -34 42 -33 23 2 -26 50 -9 129 38 179 26 28 10 30 -24 3z\"/><path d=\"M266 253 c5 -10 9 ' +\n                    '-41 9 -70 0 -42 -6 -60 -32 -97 -36 -51 -35 -56 7 -26 54 39 78 139 44 188 -18 26 -40 30 -28 5z\"/>' +\n                    '<path d=\"M128 223 c-15 -4 -15 -6 0 -33 16 -28 16 -30 -11 -58 -30 -31 -34 -42 -13 -42 8 0 17 11 ' +\n                    '20 25 4 14 11 25 16 25 5 0 12 -11 16 -25 6 -25 37 -35 49 -15 3 5 2 10 -3 10 -23 0 -20 44 5 76 ' +\n                    '25 34 25 34 4 34 -12 0 -20 -4 -17  -8 2 -4 0 -14 -5 -22 -7 -10 -12 -11 -15 -4 -10 25 -30 40 ' +\n                    '-46 37z\"/></g>' +\n                    '</svg>'\n                );\n                editor.ui.registry.addToggleButton('magentovariable', {\n                    icon: 'magentovariable',\n                    to