require.config({"config": {
        "jsbuild":{"Magento_Bundle/js/components/bundle-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'uiRegistry'\n], function (Checkbox, registry) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            clearing: false,\n            parentContainer: '',\n            parentSelections: '',\n            changer: '',\n            exports: {\n                value: '${$.parentName}:isDefaultValue'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super().\n                observe('elementTmpl');\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function () {\n            this._super();\n            this.imports.changeType = this.retrieveParentName(this.parentContainer) + '.' + this.changer + ':value';\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            if (this.prefer === 'radio' && this.checked() && !this.clearing) {\n                this.clearValues();\n            }\n\n            this._super();\n        },\n\n        /**\n         * Checkbox to radio type changer.\n         *\n         * @param {String} type - type to change.\n         */\n        changeType: function (type) {\n            var typeMap = registry.get(this.retrieveParentName(this.parentContainer) + '.' + this.changer).typeMap;\n\n            this.prefer = typeMap[type];\n            this.elementTmpl(this.templates[typeMap[type]]);\n        },\n\n        /**\n         * Clears values in components like this.\n         */\n        clearValues: function () {\n            var records = registry.get(this.retrieveParentName(this.parentSelections)),\n                index = this.index,\n                uid = this.uid;\n\n            records.elems.each(function (record) {\n                record.elems.filter(function (comp) {\n                    return comp.index === index && comp.uid !== uid;\n                }).each(function (comp) {\n                    comp.clearing = true;\n                    comp.clear();\n                    comp.clearing = false;\n                });\n            });\n        },\n\n        /**\n         * Retrieve name for the most global parent with provided index.\n         *\n         * @param {String} parent - parent name.\n         * @returns {String}\n         */\n        retrieveParentName: function (parent) {\n            return this.name.replace(new RegExp('^(.+?\\\\.)?' + parent + '\\\\..+'), '$1' + parent);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function (_, utils, registry, dynamicRows) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            label: '',\n            collapsibleHeader: true,\n            columnsHeader: false,\n            deleteProperty: false,\n            addButton: false\n        },\n\n        /**\n         * Set new data to dataSource,\n         * delete element\n         *\n         * @param {Array} data - record data\n         */\n        _updateData: function (data) {\n            var elems = _.clone(this.elems()),\n                path,\n                dataArr,\n                optionBaseData;\n\n            dataArr = this.recordData.splice(this.startIndex, this.recordData().length - this.startIndex);\n            dataArr.splice(0, this.pageSize);\n            elems = _.sortBy(this.elems(), function (elem) {\n                return ~~elem.index;\n            });\n\n            data.concat(dataArr).forEach(function (rec, idx) {\n                if (elems[idx]) {\n                    elems[idx].recordId = rec[this.identificationProperty];\n                }\n\n                if (!rec.position) {\n                    rec.position = this.maxPosition;\n                    this.setMaxPosition();\n                }\n\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + idx);\n                optionBaseData = _.pick(rec, function (value) {\n                    return !_.isObject(value);\n                });\n                this.source.set(path, optionBaseData);\n                this.source.set(path + '.bundle_button_proxy', []);\n                this.source.set(path + '.bundle_selections', []);\n                this.removeBundleItemsFromOption(idx);\n                _.each(rec['bundle_selections'], function (obj, index) {\n                    this.source.set(path + '.bundle_button_proxy' + '.' + index, rec['bundle_button_proxy'][index]);\n                    this.source.set(path + '.bundle_selections' + '.' + index, obj);\n                }, this);\n            }, this);\n\n            this.elems(elems);\n        },\n\n        /**\n         *  Removes nested dynamic-rows-grid rendered records from option\n         *\n         * @param {Number|String} index - element index\n         */\n        removeBundleItemsFromOption: function (index) {\n            var bundleSelections = registry.get(this.name + '.' + index + '.' + this.bundleSelectionsName),\n                bundleSelectionsLength = (bundleSelections.elems() || []).length,\n                i;\n\n            if (bundleSelectionsLength) {\n                for (i = 0; i < bundleSelectionsLength; i++) {\n                    bundleSelections.elems()[0].destroy();\n                }\n            }\n        },\n\n        /**\n        * {@inheritdoc}\n        */\n        processingAddChild: function (ctx, index, prop) {\n            var recordIds = _.map(this.recordData(), function (rec) {\n                return parseInt(rec['record_id'], 10);\n            }),\n            maxRecordId = _.max(recordIds);\n\n            prop = maxRecordId > -1 ? maxRecordId + 1 : prop;\n            this._super(ctx, index, prop);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-input-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated Not used anymore\n * @see Magento_Bundle/js/components/bundle-record\n * @see Magento_Bundle/js/components/bundle-checkbox\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (Select, registry) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            previousType: '',\n            parentContainer: '',\n            selections: '',\n            targetIndex: '',\n            typeMap: {}\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            var type = this.typeMap[this.value()];\n\n            if (type !== this.previousType) {\n                this.previousType = type;\n                this.processSelections(type === 'radio');\n            }\n\n            this._super();\n        },\n\n        /**\n         * Toggle 'User Defined' column and clears values\n         * @param {Boolean} isRadio\n         */\n        processSelections: function (isRadio) {\n            var records = registry.get(this.retrieveParentName(this.parentContainer) + '.' + this.selections),\n                checkedFound = false;\n\n            records.elems.each(function (record) {\n                record.elems.filter(function (comp) {\n                    return comp.index === this.userDefinedIndex;\n                }, this).each(function (comp) {\n                    comp.visible(isRadio);\n                });\n\n                if (isRadio) {\n                    record.elems.filter(function (comp) {\n                        return comp.index === this.isDefaultIndex;\n                    }, this).each(function (comp) {\n                        if (comp.checked()) {\n                            if (checkedFound) {\n                                comp.clearing = true;\n                                comp.clear();\n                                comp.clearing = false;\n                            }\n\n                            checkedFound = true;\n                        }\n                    });\n                }\n            }, this);\n        },\n\n        /**\n         * Retrieve name for the most global parent with provided index.\n         *\n         * @param {String} parent - parent name.\n         * @returns {String}\n         */\n        retrieveParentName: function (parent) {\n            return this.name.replace(new RegExp('^(.+?\\\\.)?' + parent + '\\\\..+'), '$1' + parent);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-dynamic-rows-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid',\n    'uiLayout',\n    'rjsResolver'\n], function (_, dynamicRowsGrid, layout, resolver) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n        defaults: {\n            label: '',\n            columnsHeader: false,\n            columnsHeaderAfterRender: true,\n            addButton: false,\n            isDefaultFieldScope: 'is_default',\n            defaultRecords: {\n                use: [],\n                moreThanOne: false,\n                state: {}\n            },\n            listens: {\n                inputType: 'onInputTypeChange',\n                isDefaultValue: 'onIsDefaultValue',\n                pageSize: 'onPageSizeChange'\n            },\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                options: {\n                    '20': {\n                        value: 20,\n                        label: 20\n                    },\n                    '30': {\n                        value: 30,\n                        label: 30\n                    },\n                    '50': {\n                        value: 50,\n                        label: 50\n                    },\n                    '100': {\n                        value: 100,\n                        label: 100\n                    },\n                    '200': {\n                        value: 200,\n                        label: 200\n                    }\n                },\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                },\n                enabled: false\n            },\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes();\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            if (this.sizesConfig.enabled) {\n                layout([this.sizesConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Handler for type select.\n         *\n         * @param {String} inputType - changed.\n         */\n        onInputTypeChange: function (inputType) {\n            if (this.defaultRecords.moreThanOne && (inputType === 'radio' || inputType === 'select')) {\n                _.each(this.defaultRecords.use, function (index, counter) {\n                    this.source.set(\n                        this.dataScope + '.bundle_selections.' + index + '.' + this.isDefaultFieldScope,\n                        counter ? '0' : '1'\n                    );\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Handler for is_default field.\n         *\n         * @param {Object} data - changed data.\n         */\n        onIsDefaultValue: function (data) {\n            var cb,\n                use = 0;\n\n            this.defaultRecords.use = [];\n\n            cb = function (elem, key) {\n\n                if (~~elem) {\n                    this.defaultRecords.use.push(key);\n                    use++;\n                }\n\n                this.defaultRecords.moreThanOne = use > 1;\n            }.bind(this);\n\n            _.each(data, cb);\n        },\n\n        /**\n         * Initialize elements from grid\n         *\n         * @param {Array} data\n         *\n         * @returns {Object} Chainable.\n         */\n        initElements: function (data) {\n            var newData = this.getNewData(data),\n                recordIndex;\n\n            this.parsePagesData(data);\n\n            if (newData.length) {\n                if (this.insertData().length) {\n                    recordIndex = data.length - newData.length - 1;\n\n                    _.each(newData, function (newRecord) {\n                        this.processingAddChild(newRecord, ++recordIndex, newRecord[this.identificationProperty]);\n                    }, this);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Mapping value from grid\n         *\n         * @param {Array} data\n         */\n        mappingValue: function (data) {\n            if (_.isEmpty(data)) {\n                return;\n            }\n\n            this._super();\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            resolver(function () {\n                if (this.elems().length) {\n                    this.reload();\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-option-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input',\n            isInteger: true,\n            validation: {\n                'validate-number': true\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.initialValue === undefined || this.initialValue === '') {\n                this.initialValue = 1;\n            }\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.on('value', this.onUpdate.bind(this));\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            this.validation['validate-digits'] = this.isInteger;\n            this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        hasChanged: function () {\n            var notEqual = this.value() !== this.initialValue.toString();\n\n            return !this.visible() ? false : notEqual;\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/dynamic-rows/record',\n    'uiRegistry'\n], function (Record, registry) {\n    'use strict';\n\n    return Record.extend({\n        /**\n         * @param {String} val - type of Input Type\n         */\n        onTypeChanged: function (val) {\n            var columnVisibility  = !(val === 'multi' || val === 'checkbox');\n\n            registry.async(this.name + '.' + 'selection_can_change_qty')(function (elem) {\n                elem.visible(columnVisibility);\n            });\n        }\n    });\n});\n","Magento_PageBuilder/js/content-type-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/collection\", \"Magento_PageBuilder/js/content-type\"], function (_events, _underscore, _collection, _contentType) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ContentTypeCollection = /*#__PURE__*/function (_contentType2) {\n    \"use strict\";\n\n    _inheritsLoose(ContentTypeCollection, _contentType2);\n\n    /**\n     * @param {ContentTypeInterface} parentContentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {string} stageId\n     */\n    function ContentTypeCollection(parentContentType, config, stageId) {\n      var _this;\n\n      _this = _contentType2.call(this, parentContentType, config, stageId) || this;\n      _this.collection = new _collection();\n\n      _this.collection.getChildren().subscribe(function () {\n        return _events.trigger(\"stage:updateAfter\", {\n          stageId: _this.stageId\n        });\n      });\n\n      return _this;\n    }\n    /**\n     * Return the children of the current element\n     *\n     * @returns {KnockoutObservableArray<ContentTypeInterface | ContentTypeCollectionInterface>}\n     */\n\n\n    var _proto = ContentTypeCollection.prototype;\n\n    _proto.getChildren = function getChildren() {\n      return this.collection.getChildren();\n    }\n    /**\n     * Add a child into the observable array\n     *\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} child\n     * @param {number} index\n     */\n    ;\n\n    _proto.addChild = function addChild(child, index) {\n      child.parentContentType = this;\n      this.collection.addChild(child, index); // Trigger a mount event when a child is added into a container content type, meaning it'll be re-rendered\n\n      _underscore.defer(function () {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: child.id,\n          contentType: child\n        });\n\n        _events.trigger(child.config.name + \":mountAfter\", {\n          id: child.id,\n          contentType: child\n        });\n      });\n    }\n    /**\n     * Remove a child from the observable array\n     *\n     * @param {ContentTypeInterface} child\n     */\n    ;\n\n    _proto.removeChild = function removeChild(child) {\n      this.collection.removeChild(child);\n    }\n    /**\n     * Destroys current instance and all children\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      [].concat(this.getChildren()()).forEach(function (contentType) {\n        contentType.destroy();\n      });\n\n      _contentType2.prototype.destroy.call(this);\n    }\n    /**\n     * Set the children observable array into the class\n     *\n     * @param {KnockoutObservableArray<ContentTypeInterface>} children\n     */\n    ;\n\n    _proto.setChildren = function setChildren(children) {\n      this.collection.setChildren(children);\n    };\n\n    _createClass(ContentTypeCollection, [{\n      key: \"children\",\n      get: function get() {\n        return this.collection.getChildren();\n      }\n    }]);\n\n    return ContentTypeCollection;\n  }(_contentType);\n\n  return ContentTypeCollection;\n});\n//# sourceMappingURL=content-type-collection.js.map","Magento_PageBuilder/js/panel.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"consoleLogger\", \"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/binding/draggable\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/drag-drop/drop-indicators\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/panel/menu\", \"Magento_PageBuilder/js/panel/menu/content-type\", \"Magento_PageBuilder/js/utils/position-sticky\"], function (_consoleLogger, _jquery, _knockout, _translate, _events, _underscore, _draggable, _config, _dropIndicators, _registry, _menu, _contentType, _positionSticky) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Panel = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Panel(pageBuilder) {\n      this.menuSections = _knockout.observableArray([]);\n      this.searchResults = _knockout.observableArray([]);\n      this.isVisible = _knockout.observable(false);\n      this.isStickyBottom = _knockout.observable(false);\n      this.isStickyTop = _knockout.observable(false);\n      this.searching = _knockout.observable(false);\n      this.searchValue = _knockout.observable(\"\");\n      this.searchPlaceholder = (0, _translate)(\"Find items\");\n      this.searchNoResult = (0, _translate)(\"Nothing found\");\n      this.searchTitle = (0, _translate)(\"Clear Search\");\n      this.template = \"Magento_PageBuilder/panel\";\n      this.pageBuilder = pageBuilder;\n      this.id = this.pageBuilder.id;\n      this.initListeners();\n    }\n    /**\n     * On render init the panel\n     *\n     * @param {Element} element\n     */\n\n\n    var _proto = Panel.prototype;\n\n    _proto.afterRender = function afterRender(element) {\n      this.element = element;\n    }\n    /**\n     * Init listeners\n     */\n    ;\n\n    _proto.initListeners = function initListeners() {\n      var _this = this;\n\n      _events.on(\"stage:\" + this.id + \":readyAfter\", function () {\n        _this.populateContentTypes();\n\n        if (!(0, _positionSticky.supportsPositionSticky)()) {\n          _this.onScroll();\n        }\n\n        _this.isVisible(true);\n      });\n    }\n    /**\n     * Return the template string\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getTemplate = function getTemplate() {\n      return this.template;\n    }\n    /**\n     * Conduct a search on the available content types,\n     * and find matches for beginning of words.\n     *\n     * @param self\n     * @param event\n     */\n    ;\n\n    _proto.search = function search(self, event) {\n      var _this2 = this;\n\n      this.searchValue(event.currentTarget.value.toLowerCase());\n\n      if (this.searchValue() === \"\") {\n        this.searching(false);\n      } else {\n        this.searching(true);\n        this.searchResults(_underscore.map(_underscore.filter(_config.getConfig(\"content_types\"), function (contentType) {\n          if (contentType.is_system !== true) {\n            return false;\n          }\n\n          var escapedSearchValue = self.searchValue().replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g, \"\\\\$&\");\n          var regEx = new RegExp(\"\\\\b\" + escapedSearchValue, \"gi\");\n          return regEx.test(contentType.label.toLowerCase());\n        }), function (contentType, identifier) {\n          // Create a new instance of GroupContentType for each result\n          return new _contentType.ContentType(identifier, contentType, _this2.pageBuilder.stage.id);\n        }));\n      }\n    }\n    /**\n     * Clear Search Results\n     */\n    ;\n\n    _proto.clearSearch = function clearSearch() {\n      this.searchValue(\"\");\n      this.searching(false);\n    }\n    /**\n     * Toggle stickiness of panel based on browser scroll position and height of panel\n     * Enable panel stickiness if panel and stage are available\n     * Only stick when panel height is smaller than stage height\n     * Stick panel to top when scroll reaches top position of stage\n     * Stick panel to bottom when scroll reaches bottom position of stage\n     */\n    ;\n\n    _proto.onScroll = function onScroll() {\n      var self = this;\n      var pageActions = (0, _jquery)(\".page-actions\");\n      var panel = (0, _jquery)(this.element);\n      panel.addClass(\"no-position-sticky\");\n      var stage = panel.siblings(\".pagebuilder-stage\");\n      (0, _jquery)(window).scroll(function () {\n        if (panel && panel.offset()) {\n          var panelOffsetTop = panel.offset().top;\n          var stageOffsetTop = stage.offset().top;\n          var panelHeight = panel.outerHeight();\n          var stageHeight = stage.outerHeight();\n          var currentPanelBottom = Math.round(panelOffsetTop + panel.outerHeight(true) - (0, _jquery)(this).scrollTop());\n          var currentStageBottom = Math.round(stageOffsetTop + stage.outerHeight(true) - (0, _jquery)(this).scrollTop());\n          var currentPanelTop = Math.round(panelOffsetTop - (0, _jquery)(this).scrollTop());\n          var currentStageTop = Math.round(stageOffsetTop - (0, _jquery)(this).scrollTop()); // When panel height is less than stage, begin stickiness\n\n          if (panelHeight <= stageHeight && pageActions.hasClass(\"_fixed\")) {\n            var pageActionsHeight = pageActions.outerHeight() + 15; // When scroll reaches top of stage, stick panel to top\n\n            if (currentStageTop <= pageActionsHeight) {\n              // When panel reaches bottom of stage, stick panel to bottom of stage\n              if (currentPanelBottom >= currentStageBottom && currentPanelTop <= pageActionsHeight) {\n                self.isStickyBottom(true);\n                self.isStickyTop(false);\n              } else {\n                self.isStickyBottom(false);\n                self.isStickyTop(true);\n              }\n            } else {\n              self.isStickyBottom(false);\n              self.isStickyTop(false);\n            }\n          } else {\n            self.isStickyBottom(false);\n            self.isStickyTop(false);\n          }\n        }\n      });\n    }\n    /**\n     * Retrieve the draggable options for the panel items\n     *\n     * @returns {JQueryUI.DraggableOptions}\n     */\n    ;\n\n    _proto.getDraggableOptions = function getDraggableOptions(element) {\n      // If we're within a modal make the containment be the current modal\n      var containment;\n\n      if ((0, _jquery)(element).parents(\".modal-inner-wrap\").length > 0) {\n        containment = (0, _jquery)(element).parents(\".modal-inner-wrap\");\n      }\n\n      var self = this;\n      return {\n        appendTo: \"body\",\n        cursor: \"-webkit-grabbing\",\n        connectToSortable: \".content-type-drop\",\n        containment: containment || \"document\",\n        scroll: true,\n        helper: function helper() {\n          return (0, _jquery)(this).clone().css({\n            width: (0, _jquery)(this).width(),\n            height: (0, _jquery)(this).height(),\n            zIndex: 10001,\n            pointerEvents: \"none\"\n          });\n        },\n        start: function start() {\n          var block = _knockout.dataFor(this);\n\n          if (block && block.config) {\n            // Blur any focused element\n            if (document.querySelector(\":focus\")) {\n              document.querySelector(\":focus\").blur();\n            }\n            /**\n             * Swap all sortable instances to use intersect, as the item from the left panel is a predictable\n             * size this yields better results when dragging\n             */\n\n\n            (0, _jquery)(\".content-type-container.ui-sortable\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"tolerance\", \"intersect\");\n              }\n            });\n            (0, _dropIndicators.showDropIndicators)(block.config.name, self.pageBuilder.stage.id);\n            (0, _registry.setDraggedContentTypeConfig)(block.config);\n\n            _events.trigger(\"stage:interactionStart\", {\n              stage: self.pageBuilder.stage\n            });\n          }\n        },\n        stop: function stop() {\n          (0, _jquery)(\".content-type-container.ui-sortable\").each(function () {\n            if ((0, _jquery)(this).data(\"ui-sortable\")) {\n              (0, _jquery)(this).sortable(\"option\", \"tolerance\", \"pointer\");\n            }\n          });\n          (0, _dropIndicators.hideDropIndicators)();\n          (0, _registry.setDraggedContentTypeConfig)(null);\n\n          _events.trigger(\"stage:interactionStop\", {\n            stage: self.pageBuilder.stage\n          });\n        }\n      };\n    }\n    /**\n     * Populate the panel with the content types\n     */\n    ;\n\n    _proto.populateContentTypes = function populateContentTypes() {\n      var _this3 = this;\n\n      var menuSections = _config.getConfig(\"menu_sections\");\n\n      var contentTypes = _config.getConfig(\"content_types\"); // Verify the configuration contains the required information\n\n\n      if (menuSections && contentTypes) {\n        // Iterate through the menu sections creating new instances with their associated content types\n        _underscore.each(menuSections, function (menuSection, id) {\n          // Push the menu section instance into the observable array to update the UI\n          _this3.menuSections.push(new _menu.Menu(id, menuSection, _underscore.map(_underscore.where(contentTypes, {\n            menu_section: id,\n            is_system: true\n          }),\n          /* Retrieve content types with menu section id */\n          function (contentType, identifier) {\n            return new _contentType.ContentType(identifier, contentType, _this3.pageBuilder.stage.id);\n          }), _this3.pageBuilder.stage.id));\n        }); // Display the panel\n\n\n        this.isVisible(true); // Open first menu section\n\n        var hasGroups = (0 in this.menuSections());\n\n        if (hasGroups) {\n          this.menuSections()[0].active(true);\n        }\n      } else {\n        _consoleLogger.error(\"Unable to retrieve content types from server, please inspect network requests \" + \"response.\");\n      }\n    };\n\n    return Panel;\n  }();\n\n  return Panel;\n});\n//# sourceMappingURL=panel.js.map","Magento_PageBuilder/js/content-type-menu.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"knockout\", \"underscore\"], function (_knockout, _underscore) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var ContentTypeMenu = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Options constructor\n     *\n     * @param preview\n     * @param options\n     */\n    function ContentTypeMenu(preview, options) {\n      var _this = this;\n\n      this.options = _knockout.observableArray([]);\n      this.preview = preview;\n\n      var codes = _underscore.keys(options);\n\n      _underscore.values(options).forEach(function (option, index) {\n        option.code = codes[index];\n\n        _this.options.push(option);\n      });\n\n      this.sort();\n    }\n\n    var _proto = ContentTypeMenu.prototype;\n\n    /**\n     * Get an option from the options array\n     *\n     * @param {string} code\n     * @returns {OptionInterface}\n     */\n    _proto.getOption = function getOption(code) {\n      return this.options().find(function (option) {\n        return option.code === code;\n      });\n    }\n    /**\n     * Sort the options\n     */\n    ;\n\n    _proto.sort = function sort() {\n      this.options.sort(function (a, b) {\n        return a.sort === b.sort ? 0 : a.sort < b.sort ? -1 : 1;\n      });\n    };\n\n    _createClass(ContentTypeMenu, [{\n      key: \"template\",\n      get: function get() {\n        return \"Magento_PageBuilder/content-type/menu\";\n      }\n    }]);\n\n    return ContentTypeMenu;\n  }();\n\n  return ContentTypeMenu;\n});\n//# sourceMappingURL=content-type-menu.js.map","Magento_PageBuilder/js/data-store.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"Magento_PageBuilder/js/utils/object\"], function (_jquery, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var DataStore = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function DataStore() {\n      this.state = {};\n      this.events = (0, _jquery)({});\n      this.previousState = {};\n    }\n\n    var _proto = DataStore.prototype;\n\n    /**\n     * Retrieve specific data from the data store\n     *\n     * @param {string} key\n     * @param defaultValue\n     * @returns {T}\n     */\n    _proto.get = function get(key, defaultValue) {\n      return (0, _object.get)(this.state, key, defaultValue);\n    }\n    /**\n     * Retrieve the entire state of the data object\n     *\n     * @returns {DataObject}\n     */\n    ;\n\n    _proto.getState = function getState() {\n      return this.state;\n    }\n    /**\n     * Retrieve the entire previous state of the data object\n     *\n     * @returns {DataObject}\n     */\n    ;\n\n    _proto.getPreviousState = function getPreviousState() {\n      return this.previousState;\n    }\n    /**\n     * Set a specific keys value in the data store\n     *\n     * @param {string} key\n     * @param value\n     */\n    ;\n\n    _proto.set = function set(key, value) {\n      this.previousState = Object.assign({}, this.state);\n      (0, _object.set)(this.state, key, value);\n      this.emitState();\n    }\n    /**\n     * Update the entire state for the content type\n     *\n     * @param {DataObject} state\n     */\n    ;\n\n    _proto.setState = function setState(state) {\n      this.previousState = Object.assign({}, this.state);\n      this.state = state;\n      this.emitState();\n    }\n    /**\n     * Remove item from DataStore\n     *\n     * @param {string | number} key\n     */\n    ;\n\n    _proto.unset = function unset(key) {\n      var storeState = this.state;\n      delete storeState[key];\n      this.setState(storeState);\n    }\n    /**\n     * Subscribe to data changes within the data store of a content type\n     *\n     * @param {(state: DataObject, event: Event) => void} handler\n     * @param {string | number} key\n     */\n    ;\n\n    _proto.subscribe = function subscribe(handler, key) {\n      var _this = this;\n\n      this.events.on(\"state\", function (event, data) {\n        if (key) {\n          if (_this.previousState[key] !== data.state[key]) {\n            handler(data.state, event);\n          }\n        } else {\n          if (_this.previousState !== data.state) {\n            handler(data.state, event);\n          }\n        }\n      });\n    }\n    /**\n     * Emit state updates through events\n     */\n    ;\n\n    _proto.emitState = function emitState() {\n      this.events.trigger(\"state\", {\n        state: this.state\n      });\n    };\n\n    return DataStore;\n  }();\n\n  return DataStore;\n});\n//# sourceMappingURL=data-store.js.map","Magento_PageBuilder/js/content-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/data-store\"], function (_events, _mageUtils, _underscore, _config, _dataStore) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ContentType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {ContentTypeInterface} parentContentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {string} stageId\n     */\n    function ContentType(parentContentType, config, stageId) {\n      this.id = _mageUtils.uniqueid();\n      this.dataStore = new _dataStore();\n      this.dataStores = {};\n      this.dropped = false;\n      this.parentContentType = parentContentType;\n      this.config = config;\n      this.stageId = stageId;\n      this.initDataStores();\n      this.bindEvents();\n    }\n    /**\n     * Destroys current instance\n     */\n\n\n    var _proto = ContentType.prototype;\n\n    _proto.destroy = function destroy() {\n      var params = {\n        contentType: this,\n        index: this.parentContentType ? this.parentContentType.getChildren().indexOf(this) : null,\n        parentContentType: this.parentContentType,\n        stageId: this.stageId\n      };\n      this.preview ? this.preview.destroy() : this.content.destroy();\n\n      _events.trigger(\"contentType:removeAfter\", params);\n\n      _events.trigger(this.config.name + \":removeAfter\", params);\n    }\n    /**\n     * Get viewport fields.\n     *\n     * @param {string} viewport\n     * @param {DataObject} data\n     */\n    ;\n\n    _proto.getViewportFields = function getViewportFields(viewport, data) {\n      var viewportConfig = this.config.breakpoints[viewport];\n\n      if (!viewportConfig) {\n        return {};\n      }\n\n      return viewportConfig.fields[data.appearance + \"-appearance\"] || viewportConfig.fields.default;\n    }\n    /**\n     * Get data stores states only for viewport fields\n     */\n    ;\n\n    _proto.getDataStoresStates = function getDataStoresStates() {\n      var _this = this;\n\n      var result = {};\n\n      _underscore.each(this.dataStores, function (dataStore, name) {\n        if (_config.getConfig(\"defaultViewport\") !== name) {\n          var dataStoreFields = _underscore.keys(_this.getDiffViewportFields(name, dataStore.getState()));\n\n          result[name] = _underscore.pick(dataStore.getState(), dataStoreFields);\n        } else {\n          result[name] = dataStore.getState();\n        }\n      });\n\n      return result;\n    }\n    /**\n     * Set data to dataStore from dataStores base on current viewport.\n     *\n     * @param {String} viewport\n     */\n    ;\n\n    _proto.setViewportDataToDataStore = function setViewportDataToDataStore(viewport) {\n      var defaultViewport = _config.getConfig(\"defaultViewport\");\n\n      var currentViewportState = this.dataStores[viewport].getState();\n      var defaultViewportState = this.dataStores[defaultViewport].getState();\n\n      var viewportFields = _underscore.keys(this.getDiffViewportFields(viewport, currentViewportState)); // Filter viewport specific data for states\n\n\n      this.dataStore.setState(_underscore.extend({}, defaultViewportState, _underscore.pick(currentViewportState, viewportFields)));\n    };\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      var eventName = this.config.name + \":\" + this.id + \":updateAfter\";\n      var paramObj = {};\n      paramObj[this.id] = this;\n      this.dataStore.subscribe(function (state) {\n        var defaultViewport = _config.getConfig(\"defaultViewport\");\n\n        var viewport = _config.getConfig(\"viewport\") || defaultViewport;\n\n        if (viewport !== defaultViewport) {\n          var viewportFields = _underscore.keys(_this2.getViewportFields(viewport, state));\n\n          var diffViewportFields = _underscore.keys(_this2.getDiffViewportFields(viewport, state));\n\n          _this2.dataStores[defaultViewport].setState(_underscore.extend(_this2.dataStores[defaultViewport].getState(), _underscore.omit(state, viewportFields)));\n\n          _this2.dataStores[viewport].setState(_underscore.extend(_this2.dataStores[viewport].getState(), _underscore.pick(state, diffViewportFields)));\n        } else {\n          _this2.dataStores[viewport].setState(state);\n        }\n\n        return _events.trigger(eventName, paramObj);\n      });\n      this.dataStore.subscribe(function () {\n        return _events.trigger(\"stage:updateAfter\", {\n          stageId: _this2.stageId\n        });\n      });\n\n      _events.on(\"stage:\" + this.stageId + \":viewportChangeAfter\", this.onViewportSwitch.bind(this));\n    }\n    /**\n     * Change data stores on viewport change.\n     * @param {Object} args\n     */\n    ;\n\n    _proto.onViewportSwitch = function onViewportSwitch(args) {\n      this.setViewportDataToDataStore(args.viewport);\n    }\n    /**\n     * Init data store for each viewport.\n     */\n    ;\n\n    _proto.initDataStores = function initDataStores() {\n      var _this3 = this;\n\n      _underscore.each(_config.getConfig(\"viewports\"), function (value, name) {\n        _this3.dataStores[name] = new _dataStore();\n      });\n    }\n    /**\n     * Get viewport fields that is different from default.\n     *\n     * @param {string} viewport\n     * @param {DataObject} data\n     */\n    ;\n\n    _proto.getDiffViewportFields = function getDiffViewportFields(viewport, data) {\n      var fields = this.getViewportFields(viewport, data);\n\n      var defaultData = this.dataStores[_config.getConfig(\"defaultViewport\")].getState();\n\n      var excludedFields = [];\n\n      _underscore.each(fields, function (field, key) {\n        var comparison = _mageUtils.compare(data[key], defaultData[key]);\n\n        var isEmpty = !_underscore.find(comparison.changes, function (change) {\n          return !_underscore.isEmpty(change.oldValue);\n        });\n\n        if (comparison.equal || isEmpty) {\n          excludedFields.push(key);\n        }\n      });\n\n      return _underscore.omit(fields, excludedFields);\n    };\n\n    return ContentType;\n  }();\n\n  return ContentType;\n});\n//# sourceMappingURL=content-type.js.map","Magento_PageBuilder/js/template-manager.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"html2canvas\", \"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/modal/confirm-alert\", \"Magento_PageBuilder/js/modal/template-manager-save\", \"text!Magento_PageBuilder/template/modal/template-manager/save-content-modal.html\", \"uiRegistry\", \"underscore\", \"Magento_PageBuilder/js/acl\", \"Magento_PageBuilder/js/config\"], function (_html2canvas, _jquery, _translate, _confirmAlert, _templateManagerSave, _saveContentModal, _uiRegistry, _underscore, _acl, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Save the current stage contents as a template\n   *\n   * @param stage\n   */\n  function saveAsTemplate(stage) {\n    if (!(0, _acl.isAllowed)(_acl.resources.TEMPLATE_SAVE)) {\n      (0, _confirmAlert)({\n        content: (0, _translate)(\"You do not have permission to save new templates.\"),\n        title: (0, _translate)(\"Permission Error\")\n      });\n      return false;\n    }\n\n    var capture = createCapture(stage);\n    var prompt = (0, _templateManagerSave)({\n      title: (0, _translate)(\"Save Content as Template\"),\n      promptContentTmpl: _saveContentModal,\n      templateTypes: _config.getConfig(\"stage_config\").template_types,\n      createdForNote: (0, _translate)(\"Created For is to help with filtering templates. This does not restrict where this template can be used.\"),\n      typeLabel: (0, _translate)(\"Created For\"),\n      label: (0, _translate)(\"Template Name\"),\n      validation: true,\n      modalClass: \"template-manager-save\",\n      validationRules: [\"required-entry\"],\n      attributesForm: {\n        novalidate: \"novalidate\",\n        action: \"\"\n      },\n      attributesField: {\n        \"name\": \"name\",\n        \"data-validate\": \"{required:true}\",\n        \"maxlength\": \"255\"\n      },\n      actions: {\n        /**\n         * Handle confirmation of the prompt\n         *\n         * @param {String} name\n         * @param {String} createdFor\n         * @this {actions}\n         */\n        confirm: function confirm(name, createdFor) {\n          return new Promise(function (resolve, reject) {\n            // Wait for the screenshot and the rendering lock to complete before making the request\n            var renderingLock = stage.renderingLocks[stage.renderingLocks.length - 1];\n\n            _jquery.when(capture, renderingLock).then(function (imageSrc, content) {\n              _jquery.ajax({\n                url: _config.getConfig(\"template_save_url\"),\n                data: {\n                  name: name,\n                  template: content,\n                  previewImage: imageSrc,\n                  createdFor: createdFor\n                },\n                method: \"POST\",\n                dataType: \"json\"\n              }).done(function (data) {\n                if (data.status === \"ok\") {\n                  (0, _confirmAlert)({\n                    content: (0, _translate)(\"The current contents of Page Builder has been successfully saved as a template.\"),\n                    title: (0, _translate)(\"Template Saved\")\n                  });\n                  refreshGrid();\n                  resolve();\n                } else if (data.status === \"error\") {\n                  (0, _confirmAlert)({\n                    content: data.message || (0, _translate)(\"An issue occurred while attempting to save \" + \"the template, please try again.\"),\n                    title: (0, _translate)(\"An error occurred\")\n                  });\n                  reject();\n                }\n              }).fail(function () {\n                (0, _confirmAlert)({\n                  content: (0, _translate)(\"An issue occurred while attempting to save the template, \" + \"please try again.\"),\n                  title: (0, _translate)(\"Template Save Error\")\n                });\n                reject();\n              });\n            });\n          });\n        }\n      }\n    }); // Update the UI with the preview image once available\n\n    capture.then(function (imageSrc) {\n      // @ts-ignore\n      prompt.templateManagerSave(\"setPreviewImage\", imageSrc);\n    });\n  }\n  /**\n   * Refresh the grid if it exists\n   */\n\n\n  function refreshGrid() {\n    var templateStageGrid = _uiRegistry.get(\"pagebuilder_stage_template_grid.pagebuilder_stage_template_grid_data_source\");\n\n    if (templateStageGrid) {\n      templateStageGrid.storage().clearRequests();\n      templateStageGrid.reload();\n    }\n  }\n  /**\n   * Create a capture of the stage\n   *\n   * @param stage\n   */\n\n\n  function createCapture(stage) {\n    var scrollY = window.scrollY;\n    var stageElement = document.querySelector(\"#\" + stage.id);\n\n    var deferred = _jquery.Deferred(); // Wait for the stage to complete rendering before taking the capture\n\n\n    var renderingLock = stage.renderingLocks[stage.renderingLocks.length - 1];\n    renderingLock.then(function () {\n      // Resolve issues with Parallax\n      var parallaxRestore = disableParallax(stageElement);\n      stageElement.style.height = (0, _jquery)(stageElement).outerHeight(false) + \"px\";\n      stageElement.classList.add(\"capture\");\n      stageElement.classList.add(\"interacting\");\n\n      if (stage.pageBuilder.isFullScreen()) {\n        window.scrollTo({\n          top: 0\n        });\n      }\n\n      _underscore.defer(function () {\n        (0, _html2canvas)(document.querySelector(\"#\" + stage.id + \" .pagebuilder-canvas\"), {\n          scale: 1,\n          useCORS: true,\n          scrollY: window.pageYOffset * -1\n        }).then(function (canvas) {\n          var imageSrc = canvas.toDataURL(\"image/jpeg\", 0.85);\n          deferred.resolve(imageSrc);\n\n          if (stage.pageBuilder.isFullScreen()) {\n            window.scrollTo({\n              top: scrollY\n            });\n          }\n\n          stageElement.style.height = null;\n          stageElement.classList.remove(\"capture\");\n          stageElement.classList.remove(\"interacting\");\n          restoreParallax(parallaxRestore);\n        });\n      });\n    });\n    return deferred;\n  }\n  /**\n   * Disable the parallax elements in the stage\n   *\n   * @param {Element} stageElement\n   */\n\n\n  function disableParallax(stageElement) {\n    var rowsToReset = [];\n    var parallaxRows = stageElement.querySelectorAll(\"[data-jarallax-original-styles]\");\n\n    _underscore.each(parallaxRows, function (row) {\n      var originalStyles = row.getAttribute(\"data-jarallax-original-styles\");\n      var jarallaxStyle = row.style.cssText;\n      row.style.cssText = originalStyles;\n      var jarallaxContainer = row.querySelector('div[id*=\"jarallax-container\"]');\n      jarallaxContainer.style.display = \"none\";\n      rowsToReset.push({\n        element: row,\n        styles: jarallaxStyle,\n        container: jarallaxContainer\n      });\n    });\n\n    return rowsToReset;\n  }\n  /**\n   * Restore parallax on modified nodes\n   *\n   * @param rows\n   */\n\n\n  function restoreParallax(rows) {\n    _underscore.each(rows, function (_ref) {\n      var element = _ref.element,\n          styles = _ref.styles,\n          container = _ref.container;\n      element.style.cssText = styles;\n      container.style.display = \"\";\n    });\n  }\n\n  return {\n    saveAsTemplate: saveAsTemplate\n  };\n});\n//# sourceMappingURL=template-manager.js.map","Magento_PageBuilder/js/widget-initializer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'jquery',\n    'mage/apply/main',\n    'Magento_Ui/js/lib/view/utils/dom-observer'\n], function (_, $, mage, domObserver) {\n    'use strict';\n\n    /**\n     * Initializes components assigned to HTML elements.\n     *\n     *\n     * @param {HTMLElement} el\n     * @param {Array} data\n     * @param {Object} breakpoints\n     * @param {Object} currentViewport\n     */\n    function initializeWidget(el, data, breakpoints, currentViewport) {\n        _.each(data, function (config, component) {\n            config = config || {};\n            config.breakpoints = breakpoints;\n            config.currentViewport = currentViewport;\n            mage.applyFor(el, config, component);\n        });\n    }\n\n    return function (data, contextElement) {\n        _.each(data.config, function (componentConfiguration, elementPath) {\n            domObserver.get(\n                elementPath,\n                function (element) {\n                    var $element = $(element);\n\n                    if (contextElement) {\n                        $element = $(contextElement).find(element);\n                    }\n\n                    if ($element.length) {\n                        initializeWidget($element, componentConfiguration, data.breakpoints, data.currentViewport);\n                    }\n                }\n            );\n        });\n    };\n});\n","Magento_PageBuilder/js/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['uiEvents'], function (uiEvents) {\n    'use strict';\n\n    return {\n\n        /**\n         * Calls callback when name event is triggered\n         *\n         * @param {String} events\n         * @param {Function} callback\n         * @param {Function} ns\n         * @return {Object}\n         */\n        on: function (events, callback, ns) {\n            uiEvents.on('pagebuilder:' + events, callback, 'pagebuilder:' + ns);\n\n            return this;\n        },\n\n        /**\n         * Removed callback from listening to target event\n         *\n         * @param {String} ns\n         * @return {Object}\n         */\n        off: function (ns) {\n            uiEvents.off('pagebuilder:' + ns);\n\n            return this;\n        },\n\n        /**\n         * Triggers event and executes all attached callbacks\n         *\n         * @param {String} name\n         * @param {any} args\n         * @returns {Boolean}\n         */\n        trigger: function (name, args) {\n            return uiEvents.trigger('pagebuilder:' + name, args);\n        }\n    };\n});\n","Magento_PageBuilder/js/stage.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/resource/jquery/ui/jquery.ui.touch-punch\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/binding/sortable\", \"Magento_PageBuilder/js/collection\", \"Magento_PageBuilder/js/data-store\", \"Magento_PageBuilder/js/drag-drop/matrix\", \"Magento_PageBuilder/js/master-format/render\", \"Magento_PageBuilder/js/stage-builder\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/promise-deferred\"], function (_jquery, _knockout, _events, _jqueryUi, _mageUtils, _underscore, _sortable, _collection, _dataStore, _matrix, _render, _stageBuilder, _editor, _promiseDeferred) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Stage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * We always complete a single render when the stage is first loaded, so we can set the lock when the stage is\n     * created. The lock is used to halt the parent forms submission when Page Builder is rendering.\n     */\n\n    /**\n     * Debounce the applyBindings call by 500ms to stop duplicate calls\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n\n    /**\n     * @param {PageBuilderInterface} pageBuilder\n     * @param {ContentTypeCollectionInterface} rootContainer\n     */\n    function Stage(pageBuilder, rootContainer) {\n      var _this = this;\n\n      this.loading = _knockout.observable(true);\n      this.showBorders = _knockout.observable(false);\n      this.interacting = _knockout.observable(false);\n      this.userSelect = _knockout.observable(true);\n      this.focusChild = _knockout.observable(false);\n      this.dataStore = new _dataStore();\n      this.afterRenderDeferred = (0, _promiseDeferred)();\n      this.renderingLocks = [];\n      this.template = \"Magento_PageBuilder/content-type/preview\";\n      this.collection = new _collection();\n      this.applyBindingsDebounce = _underscore.debounce(function (renderId) {\n        _this.render.applyBindings(_this.rootContainer).then(function (renderedOutput) {\n          if (_this.lastRenderId === renderId) {\n            _events.trigger(\"stage:\" + _this.id + \":masterFormatRenderAfter\", {\n              value: (0, _editor.unescapeDoubleQuoteWithinWidgetDirective)(renderedOutput)\n            });\n\n            _this.renderingLocks.forEach(function (lock) {\n              lock.resolve(renderedOutput);\n            });\n          }\n        }).catch(function (error) {\n          if (error) {\n            console.error(error);\n          }\n        });\n      }, 500);\n      this.pageBuilder = pageBuilder;\n      this.id = pageBuilder.id;\n      this.render = new _render(pageBuilder.id);\n      this.rootContainer = rootContainer;\n      (0, _matrix.generateAllowedParents)(); // Fire an event after the DOM has rendered\n\n      this.afterRenderDeferred.promise.then(function () {\n        _this.render.setupChannel();\n\n        _events.trigger(\"stage:\" + _this.id + \":renderAfter\", {\n          stage: _this\n        });\n      }); // Wait for the stage to be built alongside the stage being rendered\n\n      Promise.all([(0, _stageBuilder)(this, (0, _editor.escapeDoubleQuoteWithinWidgetDirective)(this.pageBuilder.initialValue)), this.afterRenderDeferred.promise]).then(this.ready.bind(this)).catch(function (error) {\n        console.error(error);\n      });\n    }\n    /**\n     * Get template.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Stage.prototype;\n\n    _proto.getTemplate = function getTemplate() {\n      return this.template;\n    }\n    /**\n     * The stage has been initiated fully and is ready\n     */\n    ;\n\n    _proto.ready = function ready() {\n      _events.trigger(\"stage:\" + this.id + \":readyAfter\", {\n        stage: this\n      });\n\n      this.loading(false);\n      this.initListeners(); // Ensure we complete an initial save of the data within the stage once we're ready\n\n      _events.trigger(\"stage:updateAfter\", {\n        stageId: this.id\n      });\n    }\n    /**\n     * Init listeners\n     */\n    ;\n\n    _proto.initListeners = function initListeners() {\n      var _this2 = this;\n\n      this.collection.getChildren().subscribe(function () {\n        return _events.trigger(\"stage:updateAfter\", {\n          stageId: _this2.id\n        });\n      }); // ContentType being removed from container\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.stageId === _this2.id) {\n          _this2.onContentTypeRemoved(args);\n        }\n      }); // Any store state changes trigger a stage update event\n\n\n      this.dataStore.subscribe(function () {\n        return _events.trigger(\"stage:updateAfter\", {\n          stageId: _this2.id\n        });\n      }); // Watch for stage update events & manipulations to the store, debounce for 50ms as multiple stage changes\n      // can occur concurrently.\n\n      _events.on(\"stage:updateAfter\", function (args) {\n        if (args.stageId === _this2.id) {\n          // Create the rendering lock straight away\n          _this2.createLock();\n\n          var renderId = _mageUtils.uniqueid();\n\n          _this2.lastRenderId = renderId;\n\n          _this2.applyBindingsDebounce(renderId);\n        }\n      });\n\n      var interactionLevel = 0;\n\n      _events.on(\"stage:interactionStart\", function () {\n        ++interactionLevel;\n\n        _this2.interacting(true);\n      });\n\n      _events.on(\"stage:interactionStop\", function (args) {\n        var forced = _underscore.isObject(args) && args.force === true;\n        interactionLevel = Math.max(interactionLevel - 1, 0);\n\n        if (interactionLevel === 0 || forced) {\n          _this2.interacting(false);\n\n          if (forced) {\n            interactionLevel = 0;\n          }\n        }\n      });\n\n      _events.on(\"stage:childFocusStart\", function () {\n        return _this2.focusChild(true);\n      });\n\n      _events.on(\"stage:childFocusStop\", function () {\n        return _this2.focusChild(false);\n      });\n    }\n    /**\n     * Create a new lock for rendering\n     */\n    ;\n\n    _proto.createLock = function createLock() {\n      this.renderingLocks.push(_jquery.Deferred());\n    }\n    /**\n     * On content type removed\n     *\n     * @param params\n     */\n    ;\n\n    _proto.onContentTypeRemoved = function onContentTypeRemoved(params) {\n      if (params.parentContentType) {\n        params.parentContentType.removeChild(params.contentType);\n      }\n    };\n\n    return Stage;\n  }();\n\n  Stage.rootContainerName = \"root-container\";\n  return Stage;\n});\n//# sourceMappingURL=stage.js.map","Magento_PageBuilder/js/uploader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/events\", \"uiLayout\", \"uiRegistry\"], function (_events, _uiLayout, _uiRegistry) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Uploader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Config data of uploader instance\n     */\n\n    /**\n     * The supplied data store\n     */\n\n    /**\n     * @param {String} name Name to use for lookup reference in registry\n     * @param {Object} uploaderConfig The config used when initializing the Uploader UI component\n     * @param {String} contentTypeId The id of the content type this will be used in\n     * @param {DataStore} dataStore The datastore that the selected image should be stored in.\n     * @param {Object[]} initialValue The value that should be used for the initial state of the component.\n     * @param {Function} onChangeCallback Called when image is added or updated\n     * @param {Function} onDeleteCallback Called when currently set image is deleted from storage\n     */\n    function Uploader(name, uploaderConfig, contentTypeId, dataStore, initialValue, onChangeCallback, onDeleteCallback) {\n      if (onChangeCallback === void 0) {\n        onChangeCallback = null;\n      }\n\n      if (onDeleteCallback === void 0) {\n        onDeleteCallback = null;\n      }\n\n      var config = Object.assign({}, uploaderConfig, {\n        value: initialValue\n      });\n      config.id = contentTypeId;\n      config.name = name;\n      this.dataStore = dataStore;\n\n      _events.on(\"image:\" + contentTypeId + \":uploadAfter\", onChangeCallback ? onChangeCallback : this.onImageChanged.bind(this));\n\n      _events.on(\"image:\" + contentTypeId + \":deleteFileAfter\", onDeleteCallback ? onDeleteCallback : this.onImageDeleted.bind(this));\n\n      this.config = config; // Render uploader\n\n      this.render();\n    }\n    /**\n     * Default callback for upload event\n     * @param {object[]} data\n     */\n\n\n    var _proto = Uploader.prototype;\n\n    _proto.onImageChanged = function onImageChanged(data) {\n      this.dataStore.set(this.config.dataScope.toString(), data);\n    }\n    /**\n     * Default callback for image deleted event\n     */\n    ;\n\n    _proto.onImageDeleted = function onImageDeleted() {\n      this.dataStore.set(this.config.dataScope.toString(), \"\");\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Function}\n     */\n    ;\n\n    _proto.getUiComponent = function getUiComponent() {\n      return _uiRegistry.async(this.config.name);\n    }\n    /**\n     * Instantiate uploader through layout UI component renderer\n     */\n    ;\n\n    _proto.render = function render() {\n      (0, _uiLayout)([this.config]);\n    };\n\n    return Uploader;\n  }();\n\n  return Uploader;\n});\n//# sourceMappingURL=uploader.js.map","Magento_PageBuilder/js/config.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\"], function (_underscore) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Config = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Config() {}\n\n    /**\n     * Set the initial config\n     *\n     * @param config\n     */\n    Config.setConfig = function setConfig(config) {\n      Config.config = _underscore.extend(Config.config, config);\n    }\n    /**\n     * Set the current instances mode, this differs between preview or master depending on whether we're rendering the\n     * admins preview or rendering the master format.\n     *\n     * @param {\"Preview\" | \"Master\"} mode\n     */\n    ;\n\n    Config.setMode = function setMode(mode) {\n      Config.mode = mode;\n    }\n    /**\n     * Retrieve the current instances mode\n     */\n    ;\n\n    Config.getMode = function getMode() {\n      return Config.mode;\n    }\n    /**\n     * Retrieve the init config\n     *\n     * @param {string} key\n     * @returns {T}\n     */\n    ;\n\n    Config.getConfig = function getConfig(key) {\n      if (key) {\n        if (typeof Config.config[key] !== \"undefined\") {\n          return Config.config[key];\n        }\n\n        return null;\n      }\n\n      return Config.config;\n    }\n    /**\n     * Retrieve a content type from the configuration\n     *\n     * @param {string} contentType\n     * @returns {any}\n     */\n    ;\n\n    Config.getContentTypeConfig = function getContentTypeConfig(contentType) {\n      if (typeof Config.getConfig(\"content_types\")[contentType] !== \"undefined\") {\n        return Config.getConfig(\"content_types\")[contentType];\n      }\n\n      return null;\n    };\n\n    return Config;\n  }();\n\n  Config.config = {\n    dataContentTypeAttributeName: \"data-content-type\",\n    bodyId: \"html-body\"\n  };\n  return Config;\n});\n//# sourceMappingURL=config.js.map","Magento_PageBuilder/js/acl.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  var resources = {\n    TEMPLATE_SAVE: \"template_save\",\n    TEMPLATE_APPLY: \"template_apply\"\n  };\n  /**\n   * Determine if the current user is allowed to access this resource\n   *\n   * Usage: isAllowed(resources.TEMPLATE_SAVE)\n   *\n   * @param resource\n   */\n\n  function isAllowed(resource) {\n    return _config.getConfig(\"acl\")[resource] === true;\n  }\n\n  return {\n    isAllowed: isAllowed,\n    resources: resources\n  };\n});\n//# sourceMappingURL=acl.js.map","Magento_PageBuilder/js/stage-builder.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"mage/translate\", \"Magento_PageBuilder/js/events\", \"Magento_Ui/js/modal/alert\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-collection\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/appearance-config\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/master-format/validator\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/utils/object\"], function (_translate, _events, _alert, _, _config, _contentTypeCollection, _contentTypeFactory, _appearanceConfig, _styleRegistry, _validator, _directives, _loader, _object) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Build the stage with the provided value\n   *\n   * @param {stage} stage\n   * @param {string} value\n   * @returns {Promise<void>}\n   */\n  function buildFromContent(stage, value) {\n    var stageDocument = new DOMParser().parseFromString(value, \"text/html\");\n    stageDocument.body.setAttribute(_config.getConfig(\"dataContentTypeAttributeName\"), \"stage\");\n    stageDocument.body.id = _config.getConfig(\"bodyId\");\n    convertToInlineStyles(stageDocument);\n    return buildElementIntoStage(stageDocument.body, stage.rootContainer, stage);\n  }\n  /**\n   * Convert styles to block to inline styles.\n   *\n   * @param document\n   */\n\n\n  function convertToInlineStyles(document) {\n    var styleBlocks = document.getElementsByTagName(\"style\");\n    var viewportStyles = {};\n\n    _.each(_config.getConfig(\"viewports\"), function (viewport, name) {\n      return viewportStyles[name] = {};\n    });\n\n    if (styleBlocks.length > 0) {\n      Array.from(styleBlocks).forEach(function (styleBlock) {\n        var cssRules = styleBlock.sheet.cssRules;\n        processCssRules(cssRules, viewportStyles, _config.getConfig(\"defaultViewport\"));\n        styleBlock.remove();\n      });\n    }\n\n    _.each(viewportStyles, function (styles, name) {\n      _.each(styles, function (stylesArray, selector) {\n        var element = document.querySelector(selector);\n\n        _.each(stylesArray, function (style) {\n          element.setAttribute(\"data-\" + name + \"-style\", element.getAttribute(\"data-\" + name + \"-style\") ? element.getAttribute(\"data-\" + name + \"-style\") + style.cssText : style.cssText);\n        });\n      });\n    });\n\n    document.querySelectorAll(\"[\" + _styleRegistry.pbStyleAttribute + \"]\").forEach(function (element) {\n      element.removeAttribute(_styleRegistry.pbStyleAttribute);\n    });\n  }\n  /**\n   * Process styles and assign them to corespondent style object.\n   *\n   * @param cssRules\n   * @param styles\n   * @param scope\n   */\n\n\n  function processCssRules(cssRules, styles, scope) {\n    Array.from(cssRules).forEach(function (rule) {\n      if (rule instanceof CSSStyleRule) {\n        var selectors = rule.selectorText.split(\",\").map(function (selector) {\n          return selector.trim();\n        });\n        selectors.forEach(function (selector) {\n          if (!styles[scope][selector]) {\n            styles[scope][selector] = [];\n          }\n\n          styles[scope][selector].push(rule.style);\n        });\n      } else if (rule instanceof CSSMediaRule) {\n        var mediaCssRules = rule.cssRules;\n\n        var mediaScope = _.findKey(_config.getConfig(\"viewports\"), function (viewport) {\n          return rule.conditionText === viewport.media;\n        });\n\n        if (mediaScope) {\n          processCssRules(mediaCssRules, styles, mediaScope);\n        }\n      }\n    });\n  }\n  /**\n   * Build an element and it's children into the stage\n   *\n   * @param {Element} element\n   * @param {ContentTypeCollectionInterface} contentType\n   * @param {stage} stage\n   * @returns {Promise<void>}\n   */\n\n\n  function buildElementIntoStage(element, contentType, stage) {\n    if (element instanceof HTMLElement && element.getAttribute(_config.getConfig(\"dataContentTypeAttributeName\"))) {\n      var childPromises = [];\n      var childElements = [];\n      var children = getElementChildren(element);\n\n      if (children.length > 0) {\n        _.forEach(children, function (childElement) {\n          childPromises.push(createElementContentType(childElement, stage, contentType));\n          childElements.push(childElement);\n        });\n      } // Wait for all the promises to finish and add the instances to the stage\n\n\n      return Promise.all(childPromises).then(function (childrenPromises) {\n        return Promise.all(childrenPromises.map(function (child, index) {\n          contentType.addChild(child); // Only render children if the content type implements the collection\n\n          if (child instanceof _contentTypeCollection) {\n            return buildElementIntoStage(childElements[index], child, stage);\n          }\n        }));\n      });\n    }\n  }\n  /**\n   * Parse an element in the structure and build the required element\n   *\n   * @param {Element} element\n   * @param {ContentTypeCollectionInterface} contentType\n   * @param {stage} stage\n   * @returns {Promise<ContentTypeInterface>}\n   */\n\n\n  function createElementContentType(element, stage, contentType) {\n    contentType = contentType || stage.rootContainer;\n    var role = element.getAttribute(_config.getConfig(\"dataContentTypeAttributeName\"));\n\n    if (!role) {\n      return Promise.reject(\"Invalid master format: Content type element does not contain\\n            \" + _config.getConfig(\"dataContentTypeAttributeName\") + \" attribute.\");\n    }\n\n    var config = _config.getContentTypeConfig(role);\n\n    if (!config) {\n      return Promise.reject(\"Unable to load Page Builder configuration for content type \\\"\" + role + \"\\\".\");\n    }\n\n    return getElementData(element, config).then( // @ts-ignore\n    function (data) {\n      return (0, _contentTypeFactory)(config, contentType, stage.id, data[_config.getConfig(\"defaultViewport\")], getElementChildren(element).length, data);\n    });\n  }\n  /**\n   * Retrieve the elements data\n   *\n   * @param {HTMLElement} element\n   * @param {ContentTypeConfigInterface} config\n   * @returns {Promise<{[p: string]: any}>}\n   */\n\n\n  function getElementData(element, config) {\n    // Create an object with all fields for the content type with an empty value\n    var appearance = element.dataset.appearance + \"-appearance\";\n    var fields = config.fields[appearance] || config.fields.default;\n    var result = createInitialElementData(fields);\n    return new Promise(function (resolve) {\n      var role = element.getAttribute(_config.getConfig(\"dataContentTypeAttributeName\"));\n\n      if (!_config.getConfig(\"content_types\").hasOwnProperty(role)) {\n        resolve(result);\n      } else {\n        var readerComponents = (0, _appearanceConfig)(role, element.dataset.appearance).reader;\n        (0, _loader)([readerComponents], function () {\n          for (var _len = arguments.length, readers = new Array(_len), _key = 0; _key < _len; _key++) {\n            readers[_key] = arguments[_key];\n          }\n\n          var ReaderComponent = readers.pop();\n          var reader = new ReaderComponent();\n          reader.read(element).then(function (readerData) {\n            /**\n             * Iterate through the reader data and set the values onto the result array to ensure dot notation\n             * keys are properly handled.\n             */\n            _.each(readerData[_config.getConfig(\"defaultViewport\")], function (value, key) {\n              (0, _object.set)(result, key, value);\n            });\n\n            readerData[_config.getConfig(\"defaultViewport\")] = result;\n            resolve(readerData);\n          });\n        });\n      }\n    });\n  }\n  /**\n   * Create the initial object for storing the elements data\n   *\n   * @param {ConfigFieldInterface} fields\n   * @returns {FieldDefaultsInterface}\n   */\n\n\n  function createInitialElementData(fields) {\n    return _.mapObject(fields, function (field) {\n      if (!_.isUndefined(field.default)) {\n        return \"\";\n      } else if (_.isObject(field)) {\n        return createInitialElementData(field);\n      }\n    });\n  }\n  /**\n   * Return elements children, search for direct descendants, or traverse through to find deeper children\n   *\n   * @param {HTMLElement} element\n   * @returns {Array<HTMLElement>}\n   */\n\n\n  function getElementChildren(element) {\n    if (element.hasChildNodes()) {\n      var children = []; // Find direct children of the element\n\n      _.forEach(element.childNodes, function (child) {\n        if (child.nodeType === Node.ELEMENT_NODE) {\n          if (child.hasAttribute(_config.getConfig(\"dataContentTypeAttributeName\"))) {\n            children.push(child);\n          } else {\n            children = getElementChildren(child);\n          }\n        }\n      });\n\n      return children;\n    }\n\n    return [];\n  }\n  /**\n   * Build a new instance of stage, add row & text content types if needed\n   *\n   * @param {Stage} stage\n   * @param {string} initialValue\n   * @returns {Promise<any>}\n   */\n\n\n  function buildEmpty(stage, initialValue) {\n    var stageConfig = _config.getConfig(\"stage_config\");\n\n    var rootContainer = stage.rootContainer;\n\n    var rootContentTypeConfig = _config.getContentTypeConfig(stageConfig.root_content_type);\n\n    var htmlDisplayContentTypeConfig = _config.getContentTypeConfig(stageConfig.html_display_content_type); // @ts-ignore\n\n\n    var promise = Promise.resolve();\n\n    if (stageConfig.root_content_type && stageConfig.root_content_type !== \"none\") {\n      promise = (0, _contentTypeFactory)(rootContentTypeConfig, rootContainer, stage.id);\n      promise.then(function (rootContentType) {\n        if (!rootContentType) {\n          return Promise.reject(\"Unable to create initial \" + stageConfig.root_content_type + \" content type \" + \" within stage.\");\n        }\n\n        rootContainer.addChild(rootContentType);\n      });\n    }\n\n    promise.then(function (rootContentType) {\n      if (htmlDisplayContentTypeConfig && initialValue) {\n        return (0, _contentTypeFactory)(htmlDisplayContentTypeConfig, rootContainer, stage.id, {\n          html: initialValue\n        }).then(function (html) {\n          if (rootContentType) {\n            rootContentType.addChild(html);\n          } else {\n            rootContainer.addChild(html);\n          }\n        });\n      }\n    });\n    return promise;\n  }\n  /**\n   * Build a stage with the provided content type, content observable and initial value\n   *\n   * @param {Stage} stage\n   * @param {string} content\n   * @returns {Promise}\n   */\n\n\n  function build(stage, content) {\n    var currentBuild;\n    content = (0, _directives.removeQuotesInMediaDirectives)(content); // Determine if we're building from existing page builder content\n\n    if ((0, _validator)(content)) {\n      currentBuild = buildFromContent(stage, content).catch(function (error) {\n        console.error(error);\n        stage.rootContainer.children([]);\n        currentBuild = buildEmpty(stage, content);\n      });\n    } else {\n      currentBuild = buildEmpty(stage, content);\n    } // Once the build process is finished the stage is ready\n\n\n    return currentBuild.catch(function (error) {\n      (0, _alert)({\n        content: (0, _translate)(\"An error has occurred while initiating Page Builder. Please consult with your technical \" + \"support contact.\"),\n        title: (0, _translate)(\"Page Builder Error\")\n      });\n\n      _events.trigger(\"stage:error\", error);\n\n      console.error(error);\n    });\n  }\n\n  return build;\n});\n//# sourceMappingURL=stage-builder.js.map","Magento_PageBuilder/js/content-type-toolbar.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/utils/check-stage-full-screen\", \"Magento_PageBuilder/js/utils/pagebuilder-header-height\", \"Magento_PageBuilder/js/utils/promise-deferred\"], function (_jquery, _knockout, _events, _checkStageFullScreen, _pagebuilderHeaderHeight, _promiseDeferred) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Toolbar = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Toolbar Options constructor\n     *\n     * @param preview\n     * @param options\n     */\n    function Toolbar(preview, options) {\n      this.options = _knockout.observableArray([]);\n      this.afterRenderDeferred = (0, _promiseDeferred)();\n      this.preview = preview;\n      this.options(options);\n    }\n    /**\n     * Toolbar template\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Toolbar.prototype;\n\n    /**\n     * On render init the toolbar\n     *\n     * @param {Element} element\n     */\n    _proto.afterRender = function afterRender(element) {\n      this.element = element;\n      this.afterRenderDeferred.resolve(element);\n    }\n    /**\n     * Upon clicking the option update the value as directed\n     * When user toggles the option off, set the value back to default\n     *\n     * @param {OptionInterface} option\n     * @param {ValueInterface} value\n     */\n    ;\n\n    _proto.onOptionClick = function onOptionClick(option, value) {\n      var appearance = this.preview.appearance() + \"-appearance\";\n      var fields = this.preview.config.fields[appearance] || this.preview.config.fields.default;\n      var defaultValue = fields[option.key].default;\n      var currentValue = this.preview.contentType.dataStore.get(option.key);\n      this.preview.updateData(option.key, currentValue === value.value ? defaultValue : value.value);\n    }\n    /**\n     * Set state based on toolbar focusin event for the preview\n     *\n     * @param {ContentTypeToolbarPreviewInterface} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(context, event) {\n      var currentContentTypeTarget = context.toolbar.getCurrentContentTypeTarget();\n      var toolbarOptions = currentContentTypeTarget.find(\".pagebuilder-toolbar-options\");\n      var currentContentTypeTargetClientRectTop = currentContentTypeTarget[0].getBoundingClientRect().top - (0, _pagebuilderHeaderHeight)(context.contentType.stageId); // Change toolbar orientation if overflow on full screen mode\n\n      if ((0, _checkStageFullScreen)(context.contentType.stageId) && currentContentTypeTargetClientRectTop < toolbarOptions.outerHeight()) {\n        context.toolbar.observer = new MutationObserver(function () {\n          toolbarOptions.css(\"transform\", \"translateY(\" + currentContentTypeTarget.outerHeight() + \"px)\");\n        });\n        context.toolbar.observer.observe(currentContentTypeTarget[0], {\n          attributes: true,\n          childList: true,\n          subtree: true\n        });\n        toolbarOptions.css(\"transform\", \"translateY(\" + currentContentTypeTarget.outerHeight() + \"px)\");\n      } else {\n        toolbarOptions.css(\"transform\", \"translateY(-100%)\");\n      }\n\n      (0, _jquery)(currentContentTypeTarget).addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Set state based on toolbar focusout event for the preview\n     *\n     * @param {ContentTypeToolbarPreviewInterface} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(context, event) {\n      var currentContentTypeTarget = context.toolbar.getCurrentContentTypeTarget();\n      currentContentTypeTarget.removeClass(\"pagebuilder-toolbar-active\");\n      currentContentTypeTarget.find(\".pagebuilder-toolbar-options\").css(\"transform\", \"\");\n\n      if (typeof context.toolbar.observer !== \"undefined\") {\n        context.toolbar.observer.disconnect();\n      }\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Get fixed toolbar container element referenced as selector in wysiwyg adapter settings\n     *\n     * @returns {jQuery}\n     */\n    ;\n\n    _proto.getCurrentContentTypeTarget = function getCurrentContentTypeTarget() {\n      return (0, _jquery)(\"#\" + this.preview.contentType.id).find(\".pagebuilder-content-type\");\n    };\n\n    _createClass(Toolbar, [{\n      key: \"template\",\n      get: function get() {\n        return \"Magento_PageBuilder/content-type-toolbar\";\n      }\n    }]);\n\n    return Toolbar;\n  }();\n  /**\n   * Preview interface for preview instances implementation the toolbar functionality\n   */\n\n\n  return Toolbar;\n});\n//# sourceMappingURL=content-type-toolbar.js.map","Magento_PageBuilder/js/collection.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/utils/array\"], function (_knockout, _array) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Collection = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Collection(children) {\n      this.children = children ? children : _knockout.observableArray([]);\n    }\n    /**\n     * Return the children of the current element\n     *\n     * @returns {KnockoutObservableArray<ContentTypeInterface | ContentTypeCollectionInterface>}\n     */\n\n\n    var _proto = Collection.prototype;\n\n    _proto.getChildren = function getChildren() {\n      return this.children;\n    }\n    /**\n     * Add a child into the observable array\n     *\n     * @param child\n     * @param index\n     */\n    ;\n\n    _proto.addChild = function addChild(child, index) {\n      if (typeof index === \"number\") {\n        // Use the arrayUtil function to add the item in the correct place within the array\n        (0, _array.moveArrayItemIntoArray)(child, this.children, index);\n      } else {\n        this.children.push(child);\n      }\n    }\n    /**\n     * Remove a child from the observable array\n     *\n     * @param child\n     */\n    ;\n\n    _proto.removeChild = function removeChild(child) {\n      (0, _array.removeArrayItem)(this.children, child);\n    }\n    /**\n     * Set the children observable array into the class\n     *\n     * @param children\n     */\n    ;\n\n    _proto.setChildren = function setChildren(children) {\n      this.children = children;\n    };\n\n    return Collection;\n  }();\n\n  return Collection;\n});\n//# sourceMappingURL=collection.js.map","Magento_PageBuilder/js/page-builder.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"Magento_Ui/js/lib/knockout/template/loader\", \"Magento_Ui/js/modal/alert\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/acl\", \"Magento_PageBuilder/js/binding/style\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/panel\", \"Magento_PageBuilder/js/stage\", \"Magento_PageBuilder/js/template-manager\"], function (_jquery, _knockout, _translate, _events, _loader, _alert, _mageUtils, _underscore, _acl, _style, _config, _contentTypeFactory, _panel, _stage, _templateManager) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PageBuilder = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function PageBuilder(config, initialValue) {\n      var _this = this;\n\n      this.template = \"Magento_PageBuilder/page-builder\";\n      this.isStageReady = _knockout.observable(false);\n      this.id = _mageUtils.uniqueid();\n      this.originalScrollTop = 0;\n      this.isFullScreen = _knockout.observable(false);\n      this.isSnapshot = _knockout.observable(false);\n      this.isSnapshotTransition = _knockout.observable(false);\n      this.loading = _knockout.observable(true);\n      this.wrapperStyles = _knockout.observable({});\n      this.stageStyles = _knockout.observable({});\n      this.viewport = _knockout.observable(\"\");\n      this.viewports = {};\n      this.viewportClasses = {};\n      this.previousStyles = {};\n\n      _config.setConfig(config);\n\n      _config.setMode(\"Preview\");\n\n      this.preloadTemplates(config);\n      this.initialValue = initialValue;\n      this.initViewports(config);\n      this.isFullScreen(config.isFullScreen);\n      this.isSnapshot(!!config.pagebuilder_content_snapshot);\n      this.isSnapshotTransition(false);\n      this.snapshot = !!config.pagebuilder_content_snapshot;\n      this.config = config;\n      this.isAllowedTemplateApply = (0, _acl.isAllowed)(_acl.resources.TEMPLATE_APPLY);\n      this.isAllowedTemplateSave = (0, _acl.isAllowed)(_acl.resources.TEMPLATE_SAVE); // Create the required root container for the stage\n\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(_stage.rootContainerName), null, this.id).then(function (rootContainer) {\n        _this.stage = new _stage(_this, rootContainer);\n\n        _this.isStageReady(true);\n      });\n      this.panel = new _panel(this);\n      this.initListeners();\n    }\n    /**\n     * Destroy rootContainer instance.\n     */\n\n\n    var _proto = PageBuilder.prototype;\n\n    _proto.destroy = function destroy() {\n      this.stage.rootContainer.destroy();\n    }\n    /**\n     * Init listeners.\n     */\n    ;\n\n    _proto.initListeners = function initListeners() {\n      var _this2 = this;\n\n      _events.on(\"stage:\" + this.id + \":toggleFullscreen\", this.toggleFullScreen.bind(this));\n\n      this.isFullScreen.subscribe(function () {\n        return _this2.onFullScreenChange();\n      });\n    }\n    /**\n     * Tells the stage wrapper to expand to fullScreen\n     *\n     * @param {StageToggleFullScreenParamsInterface} args\n     */\n    ;\n\n    _proto.toggleFullScreen = function toggleFullScreen(args) {\n      var _this3 = this;\n\n      if (args.animate === false) {\n        this.isFullScreen(!this.isFullScreen());\n        return;\n      }\n\n      var stageWrapper = (0, _jquery)(\"#\" + this.stage.id).parent();\n      var pageBuilderWrapper = stageWrapper.parents(\".pagebuilder-wysiwyg-wrapper\");\n      var panel = stageWrapper.find(\".pagebuilder-panel\");\n\n      if (this.snapshot) {\n        stageWrapper.scrollTop(0);\n      }\n\n      if (!this.isFullScreen()) {\n        pageBuilderWrapper.css(\"height\", pageBuilderWrapper.outerHeight());\n        /**\n         * Fix the stage in the exact place it is when it's part of the content and allow it to transition to full\n         * screen.\n         */\n\n        var xPosition = parseInt(stageWrapper.offset().top.toString(), 10) - parseInt((0, _jquery)(window).scrollTop().toString(), 10) - (this.snapshot ? 63 : 0);\n        var yPosition = stageWrapper.offset().left - (this.snapshot ? 150 : 0);\n        this.previousStyles = {\n          position: this.snapshot ? \"relative\" : \"fixed\",\n          top: xPosition + \"px\",\n          left: yPosition + \"px\",\n          zIndex: \"800\",\n          width: stageWrapper.outerWidth().toString() + \"px\"\n        };\n\n        if (this.snapshot) {\n          this.isSnapshot(false);\n          this.stageStyles(this.previousStyles);\n        } else {\n          this.previousPanelHeight = panel.outerHeight();\n          panel.css(\"height\", this.previousPanelHeight + \"px\");\n          this.wrapperStyles(this.previousStyles);\n        }\n\n        this.isFullScreen(true);\n\n        _underscore.defer(function () {\n          // Remove all styles we applied to fix the position once we're transitioning\n          panel.css(\"height\", \"\");\n\n          if (_this3.snapshot) {\n            _this3.stageStyles(Object.keys(_this3.previousStyles).reduce(function (object, styleName) {\n              var _Object$assign;\n\n              return Object.assign(object, (_Object$assign = {}, _Object$assign[styleName] = \"\", _Object$assign));\n            }, {}));\n          } else {\n            _this3.wrapperStyles(Object.keys(_this3.previousStyles).reduce(function (object, styleName) {\n              var _Object$assign2;\n\n              return Object.assign(object, (_Object$assign2 = {}, _Object$assign2[styleName] = \"\", _Object$assign2));\n            }, {}));\n          }\n        });\n      } else {\n        // When leaving full screen mode just transition back to the original state\n        if (this.snapshot) {\n          this.isSnapshotTransition(true);\n          this.stageStyles(this.previousStyles);\n        } else {\n          this.wrapperStyles(this.previousStyles);\n          this.isFullScreen(false);\n        }\n\n        panel.css(\"height\", this.previousPanelHeight + \"px\"); // Wait for the 350ms animation to complete before changing these properties back\n\n        _underscore.delay(function () {\n          if (_this3.snapshot) {\n            _this3.isSnapshot(true);\n\n            _this3.isSnapshotTransition(false);\n\n            _this3.stageStyles(Object.keys(_this3.previousStyles).reduce(function (object, styleName) {\n              var _Object$assign3;\n\n              return Object.assign(object, (_Object$assign3 = {}, _Object$assign3[styleName] = \"\", _Object$assign3));\n            }, {}));\n\n            _this3.isFullScreen(false);\n          } else {\n            _this3.wrapperStyles(Object.keys(_this3.previousStyles).reduce(function (object, styleName) {\n              var _Object$assign4;\n\n              return Object.assign(object, (_Object$assign4 = {}, _Object$assign4[styleName] = \"\", _Object$assign4));\n            }, {}));\n          }\n\n          panel.css(\"height\", \"\");\n          pageBuilderWrapper.css(\"height\", \"\");\n          _this3.previousStyles = {};\n          _this3.previousPanelHeight = null;\n        }, 350);\n      }\n\n      return true;\n    }\n    /**\n     * Change window scroll base on full screen mode.\n     */\n    ;\n\n    _proto.onFullScreenChange = function onFullScreenChange() {\n      if (this.isFullScreen()) {\n        (0, _jquery)(\"body\").css(\"overflow\", \"hidden\");\n      } else {\n        (0, _jquery)(\"body\").css(\"overflow\", \"\");\n      }\n\n      _events.trigger(\"stage:\" + this.id + \":fullScreenModeChangeAfter\", {\n        fullScreen: this.isFullScreen()\n      });\n\n      _events.trigger(\"stage:fullScreenModeChangeAfter\", {\n        pageBuilderId: this.id,\n        fullScreen: this.isFullScreen()\n      });\n    }\n    /**\n     * Get template.\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getTemplate = function getTemplate() {\n      return this.template;\n    };\n\n    /**\n     * Toggle template manager\n     */\n    _proto.toggleTemplateManger = function toggleTemplateManger() {\n      if (!(0, _acl.isAllowed)(_acl.resources.TEMPLATE_APPLY)) {\n        (0, _alert)({\n          content: (0, _translate)(\"You do not have permission to apply templates.\"),\n          title: (0, _translate)(\"Permission Error\")\n        });\n        return false;\n      }\n\n      _events.trigger(\"stage:templateManager:open\", {\n        stage: this.stage\n      });\n    }\n    /**\n     * Enable saving the current stage as a template\n     */\n    ;\n\n    _proto.saveAsTemplate = function saveAsTemplate() {\n      return (0, _templateManager.saveAsTemplate)(this.stage);\n    };\n\n    _proto.toggleViewport = function toggleViewport(viewport) {\n      var previousViewport = this.viewport();\n      this.viewport(viewport);\n\n      _underscore.each(this.viewportClasses, function (viewportClass) {\n        viewportClass(false);\n      });\n\n      this.viewportClasses[viewport + \"-viewport\"](true);\n\n      _config.setConfig({\n        viewport: viewport\n      });\n\n      _events.trigger(\"stage:\" + this.id + \":viewportChangeAfter\", {\n        viewport: viewport,\n        previousViewport: previousViewport\n      });\n\n      _events.trigger(\"stage:viewportChangeAfter\", {\n        viewport: viewport,\n        previousViewport: previousViewport\n      });\n    }\n    /**\n     * Preload all templates into the window to reduce calls later in the app\n     *\n     * @param config\n     */\n    ;\n\n    _proto.preloadTemplates = function preloadTemplates(config) {\n      var previewTemplates = _underscore.values(config.content_types).map(function (contentType) {\n        return _underscore.values(contentType.appearances).map(function (appearance) {\n          return appearance.preview_template;\n        });\n      }).reduce(function (array, value) {\n        return array.concat(value);\n      }, []).map(function (value) {\n        return (0, _loader.formatPath)(value);\n      });\n\n      _underscore.defer(function () {\n        require(previewTemplates);\n      });\n    };\n\n    _proto.initViewports = function initViewports(config) {\n      var _this4 = this;\n\n      this.viewports = config.viewports;\n      this.defaultViewport = config.defaultViewport;\n      this.viewport(this.defaultViewport);\n\n      _config.setConfig({\n        viewport: this.defaultViewport\n      });\n\n      _underscore.each(this.viewports, function (viewport, name) {\n        _this4.viewportClasses[name + \"-viewport\"] = _knockout.observable(name === _this4.defaultViewport);\n      });\n    };\n\n    _createClass(PageBuilder, [{\n      key: \"viewportTemplate\",\n      get: function get() {\n        return \"Magento_PageBuilder/viewport/switcher\";\n      }\n    }]);\n\n    return PageBuilder;\n  }();\n\n  return PageBuilder;\n});\n//# sourceMappingURL=page-builder.js.map","Magento_PageBuilder/js/content-type-factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/master-factory\", \"Magento_PageBuilder/js/content-type/preview-factory\", \"Magento_PageBuilder/js/utils/loader\"], function (_events, _underscore, _config, _masterFactory, _previewFactory, _loader) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create new content type\n   *\n   * @param {ContentTypeConfigInterface} config\n   * @param {ContentTypeInterface} parentContentType\n   * @param {string} stageId\n   * @param {object} data\n   * @param {number} childrenLength\n   * * @param {object} viewportsData\n   * @returns {Promise<ContentTypeInterface>}\n   * @api\n   */\n  function createContentType(config, parentContentType, stageId, data, childrenLength, viewportsData) {\n    if (data === void 0) {\n      data = {};\n    }\n\n    if (childrenLength === void 0) {\n      childrenLength = 0;\n    }\n\n    if (viewportsData === void 0) {\n      viewportsData = {};\n    }\n\n    return new Promise(function (resolve, reject) {\n      (0, _loader)([config.component], function (contentTypeComponent) {\n        try {\n          var _contentType = new contentTypeComponent(parentContentType, config, stageId);\n\n          var viewFactory = _config.getMode() === \"Preview\" ? _previewFactory : _masterFactory;\n          viewFactory(_contentType, config).then(function (viewComponent) {\n            var viewName = _config.getMode() === \"Preview\" ? \"preview\" : \"content\"; // @ts-ignore\n\n            _contentType[viewName] = viewComponent;\n            assignDataToDataStores(_contentType, config, data, viewportsData);\n            resolve(_contentType);\n          }).catch(function (error) {\n            reject(error);\n          });\n        } catch (error) {\n          reject(\"Error within component (\" + config.component + \") for \" + config.name + \".\");\n          console.error(error);\n        }\n      }, function (error) {\n        reject(\"Unable to load component (\" + config.component + \") for \" + config.name + \". Please check component exists\" + \" and content type configuration is correct.\");\n        console.error(error);\n      });\n    }).then(function (contentType) {\n      _events.trigger(\"contentType:createAfter\", {\n        id: contentType.id,\n        contentType: contentType\n      });\n\n      _events.trigger(config.name + \":createAfter\", {\n        id: contentType.id,\n        contentType: contentType\n      });\n\n      fireContentTypeReadyEvent(contentType, childrenLength);\n      return contentType;\n    }).catch(function (error) {\n      console.error(error);\n      return null;\n    });\n  }\n\n  function assignDataToDataStores(contentType, config, data, viewportsData) {\n    var defaultData = prepareData(config, data);\n\n    var currentViewport = _config.getConfig(\"viewport\") || _config.getConfig(\"defaultViewport\");\n\n    _underscore.each(_config.getConfig(\"viewports\"), function (viewport, name) {\n      var viewportData = {};\n      var breakpoint = config.breakpoints[name];\n      var viewportConfig = breakpoint && breakpoint.fields ? _underscore.extend({}, breakpoint, {\n        name: config.name\n      }) : {};\n\n      if (!_underscore.isEmpty(viewportConfig)) {\n        viewportsData[name] = viewportsData[name] || {};\n        viewportData = prepareData(viewportConfig, viewportsData[name]);\n      }\n\n      contentType.dataStores[name].setState(_underscore.extend({}, defaultData, viewportData));\n    });\n\n    contentType.setViewportDataToDataStore(currentViewport);\n  }\n  /**\n   * Merge defaults and content type data\n   *\n   * @param {ContentTypeConfigInterface} config\n   * @param {object} data\n   * @returns {any}\n   */\n\n\n  function prepareData(config, data) {\n    var appearance = data.appearance + \"-appearance\";\n    var fields = config.fields[appearance] || config.fields.default;\n    var defaults = prepareDefaults(fields || {}); // Set all content types to be displayed by default\n\n    defaults.display = true;\n    return _underscore.extend(defaults, data, {\n      name: config.name\n    });\n  }\n  /**\n   * Prepare the default values for fields within the form\n   *\n   * @param {ConfigFieldInterface} fields\n   * @returns {FieldDefaultsInterface}\n   */\n\n\n  function prepareDefaults(fields) {\n    if (_underscore.isEmpty(fields)) {\n      return {};\n    }\n\n    return _underscore.mapObject(fields, function (field) {\n      if (!_underscore.isUndefined(field.default)) {\n        return field.default;\n      } else if (_underscore.isObject(field)) {\n        return prepareDefaults(field);\n      }\n    });\n  }\n  /**\n   * A content type is ready once all of its children have mounted\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {number} childrenLength\n   */\n\n\n  function fireContentTypeReadyEvent(contentType, childrenLength) {\n    if (childrenLength === void 0) {\n      childrenLength = 0;\n    }\n\n    var fire = function fire() {\n      var params = {\n        id: contentType.id,\n        contentType: contentType,\n        expectChildren: childrenLength\n      };\n\n      _events.trigger(\"contentType:mountAfter\", params);\n\n      _events.trigger(contentType.config.name + \":mountAfter\", params);\n    };\n\n    if (childrenLength === 0) {\n      fire();\n    } else {\n      var mountCounter = 0;\n\n      _events.on(\"contentType:mountAfter\", function (args) {\n        if (args.contentType.parentContentType.id === contentType.id) {\n          mountCounter++;\n\n          if (mountCounter === childrenLength) {\n            mountCounter = 0;\n            fire();\n\n            _events.off(\"contentType:\" + contentType.id + \":mountAfter\");\n          }\n        }\n      }, \"contentType:\" + contentType.id + \":mountAfter\");\n    }\n  }\n  /**\n   * @api\n   */\n\n\n  return createContentType;\n});\n//# sourceMappingURL=content-type-factory.js.map","Magento_PageBuilder/js/master-format/render.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/master-format/render/serialize\"], function (_jquery, _config, _serialize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var MasterFormatRenderer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param stageId\n     */\n    function MasterFormatRenderer(stageId) {\n      this.ready = false;\n      this.readyDeferred = _jquery.Deferred();\n      this.stageId = stageId;\n    }\n    /**\n     * Render the root container into a string utilising our sandboxed iframe\n     *\n     * @param {ContentTypeCollection} rootContainer\n     * @returns {Promise<string>}\n     */\n\n\n    var _proto = MasterFormatRenderer.prototype;\n\n    _proto.applyBindings = function applyBindings(rootContainer) {\n      var _this = this;\n\n      return new Promise(function (resolve, reject) {\n        if (!_this.getRenderFrame()) {\n          // If the stage exists we should also have a frame\n          if (document.getElementById(_this.stageId)) {\n            return reject(\"No render frame present for Page Builder instance.\");\n          } // Otherwise the instance of Page Builder has been removed from the DOM and this is an old instance.\n\n\n          return reject();\n        }\n\n        if (_this.ready) {\n          _this.channel.port1.postMessage({\n            type: \"render\",\n            message: {\n              stageId: _this.stageId,\n              tree: (0, _serialize.getSerializedTree)(rootContainer)\n            }\n          });\n\n          _this.channel.port1.onmessage = function (event) {\n            if (event.isTrusted) {\n              if (event.data.type === \"render\") {\n                resolve(event.data.message);\n              }\n\n              if (event.data.type === \"template\") {\n                _this.loadTemplate(event.data.message);\n              }\n            } else {\n              reject(\"Render event was not trusted.\");\n            }\n          };\n        } else {\n          _this.readyDeferred.then(function () {\n            _this.applyBindings(rootContainer).then(function (rendered) {\n              resolve(rendered);\n            }).catch(function (error) {\n              reject(error);\n            });\n          });\n        }\n      });\n    }\n    /**\n     * Create a channel to communicate with our sandboxed iframe. Firstly add a listener to the current window and then\n     * set the src of the iframe. Listening for a specific message event with a predefined term and then hand over the\n     * MessageChannel port to allow communication between the main window and iframe.\n     */\n    ;\n\n    _proto.setupChannel = function setupChannel() {\n      var _this2 = this;\n\n      this.channel = new MessageChannel();\n      var frame = this.getRenderFrame();\n      window.addEventListener(\"message\", function (event) {\n        if (!_this2.ready && event.data.name === \"PB_RENDER_READY\" && _this2.stageId === event.data.stageId) {\n          frame.contentWindow.postMessage(\"PB_RENDER_PORT\", \"*\", [_this2.channel.port2]);\n          _this2.ready = true;\n\n          _this2.readyDeferred.resolve();\n        }\n      });\n      frame.src = _config.getConfig(\"render_url\") + \"?stageId=\" + this.stageId;\n    }\n    /**\n     * Use the text! RequireJS plugin to load a template and send it back to the child render iframe\n     *\n     * @param name\n     */\n    ;\n\n    _proto.loadTemplate = function loadTemplate(name) {\n      var _this3 = this;\n\n      require([\"text!\" + name], function (template) {\n        _this3.channel.port1.postMessage({\n          type: \"template\",\n          message: {\n            name: name,\n            template: template\n          }\n        });\n      });\n    }\n    /**\n     * Retrieve the render frame\n     *\n     * @returns {HTMLIFrameElement}\n     */\n    ;\n\n    _proto.getRenderFrame = function getRenderFrame() {\n      return document.getElementById(\"render_frame_\" + this.stageId);\n    };\n\n    return MasterFormatRenderer;\n  }();\n\n  return MasterFormatRenderer;\n});\n//# sourceMappingURL=render.js.map","Magento_PageBuilder/js/master-format/filter-html.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Filter the HTML output to only include necessary attributes & nodes\n   *\n   * @param {JQuery} element\n   * @returns {JQuery}\n   */\n  function filterHtml(element) {\n    var isWhiteSpaceOrComment = function isWhiteSpaceOrComment() {\n      return this.nodeType === Node.COMMENT_NODE || this.nodeType === Node.TEXT_NODE && this.data.match(/^\\s+$/);\n    };\n\n    element.find(\"[data-bind]\").each(function (index, value) {\n      (0, _jquery)(value).removeAttr(\"data-bind\");\n    });\n    element.contents().filter(isWhiteSpaceOrComment).remove();\n    element.find(\"*\").filter(function (index, descendentEl) {\n      // filter out elements that are iframes or have .bypass-html-filter ancestor\n      var isIframe = descendentEl.tagName === \"IFRAME\";\n      var isBeingBypassedByThisFilter = !!(0, _jquery)(descendentEl).closest(\".bypass-html-filter\").length;\n      return !isIframe && !isBeingBypassedByThisFilter;\n    }).each(function (index, descendentEl) {\n      (0, _jquery)(descendentEl).contents().filter(isWhiteSpaceOrComment).remove();\n    });\n    element.find(\"[data-wrapper]\").each(function (index, value) {\n      (0, _jquery)(value).parent().append((0, _jquery)(value).children());\n      (0, _jquery)(value).remove();\n    });\n    element.find(\".bypass-html-filter\").each(function (index, value) {\n      (0, _jquery)(value).removeClass(\"bypass-html-filter\").filter('[class=\"\"]').removeAttr(\"class\");\n    });\n    return element;\n  }\n\n  return filterHtml;\n});\n//# sourceMappingURL=filter-html.js.map","Magento_PageBuilder/js/master-format/validator.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate if content has page builder format by checking for any data-content-type attributes\n   *\n   * @param {string} content\n   * @returns {boolean}\n   */\n  function validate(content) {\n    var stageDocument = new DOMParser().parseFromString(content, \"text/html\");\n    return !!stageDocument.querySelector(\"[\" + _config.getConfig(\"dataContentTypeAttributeName\") + \"]\");\n  }\n\n  return validate;\n});\n//# sourceMappingURL=validator.js.map","Magento_PageBuilder/js/master-format/read-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=read-interface.js.map","Magento_PageBuilder/js/master-format/read/configurable.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"jquery\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/appearance-config\", \"Magento_PageBuilder/js/converter/converter-pool-factory\", \"Magento_PageBuilder/js/mass-converter/converter-pool-factory\", \"Magento_PageBuilder/js/property/property-reader-pool-factory\"], function (_jquery, _mageUtils, _underscore, _config, _appearanceConfig, _converterPoolFactory, _converterPoolFactory2, _propertyReaderPoolFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Configurable = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Configurable() {}\n\n    var _proto = Configurable.prototype;\n\n    /**\n     * Read data from the dom based on configuration\n     *\n     * @param element HTMLElement\n     * @returns {Promise<any>}\n     */\n    _proto.read = function read(element) {\n      var _this = this;\n\n      var role = element.getAttribute(_config.getConfig(\"dataContentTypeAttributeName\"));\n      var config = (0, _appearanceConfig)(role, element.getAttribute(\"data-appearance\"));\n      var componentsPromise = [(0, _propertyReaderPoolFactory)(role), (0, _converterPoolFactory)(role), (0, _converterPoolFactory2)(role)];\n      return new Promise(function (resolve) {\n        Promise.all(componentsPromise).then(function (loadedComponents) {\n          var propertyReaderPool = loadedComponents[0],\n              converterPool = loadedComponents[1],\n              massConverterPool = loadedComponents[2];\n\n          var viewports = _config.getConfig(\"viewports\");\n\n          var data = {};\n\n          _underscore.each(viewports, function (viewport, name) {\n            return data[name] = {};\n          });\n\n          var _loop = function _loop() {\n            var elementName = _Object$keys[_i];\n            var elementConfig = config.elements[elementName];\n\n            var currentElement = _this.findElementByName(element, elementName); // If we cannot locate the current element skip trying to read any attributes from it\n\n\n            if (currentElement === null || currentElement === undefined) {\n              return \"continue\";\n            }\n\n            _underscore.each(viewports, function (viewportObj, viewport) {\n              currentElement.setAttribute(\"style\", currentElement.getAttribute(\"data-\" + viewport + \"-style\"));\n\n              if (elementConfig.style.length) {\n                data[viewport] = _this.readStyle(elementConfig.style, currentElement, data[viewport], propertyReaderPool, converterPool);\n              }\n\n              if (elementConfig.attributes.length) {\n                data[viewport] = _this.readAttributes(elementConfig.attributes, currentElement, data[viewport], propertyReaderPool, converterPool);\n              }\n\n              if (undefined !== elementConfig.html.var) {\n                data[viewport] = _this.readHtml(elementConfig, currentElement, data[viewport], converterPool);\n              }\n\n              if (undefined !== elementConfig.tag.var) {\n                data[viewport] = _this.readHtmlTag(elementConfig, currentElement, data[viewport]);\n              }\n\n              if (undefined !== elementConfig.css.var) {\n                data[viewport] = _this.readCss(elementConfig, currentElement, data[viewport]);\n              }\n            });\n          };\n\n          for (var _i = 0, _Object$keys = Object.keys(config.elements); _i < _Object$keys.length; _i++) {\n            var _ret = _loop();\n\n            if (_ret === \"continue\") continue;\n          }\n\n          _underscore.each(viewports, function (viewportObj, viewport) {\n            data[viewport] = _this.convertData(config, data[viewport], massConverterPool);\n          });\n\n          resolve(data);\n        }).catch(function (error) {\n          console.error(error);\n        });\n      });\n    }\n    /**\n     * Find the element for the current content type by it's name, avoiding searching in other content types by\n     * removing any other element which contains it's own data-content-type.\n     *\n     * @param {HTMLElement} element\n     * @param {string} name\n     * @returns {HTMLElement}\n     */\n    ;\n\n    _proto.findElementByName = function findElementByName(element, name) {\n      // Create a clone of the element to avoid modifying the source\n      var currentElement = (0, _jquery)(element).clone();\n\n      if (currentElement.attr(\"data-element\") === name) {\n        return currentElement[0];\n      } // Attempt to find the element in the children of the data-content-type\n\n\n      var searchInChildren = currentElement.find(\"[data-element=\\\"\" + name + \"\\\"]\"); // Ensure the element is within the current content type\n\n      if (searchInChildren.length > 0 && searchInChildren.closest(\"[data-content-type]\")[0] === currentElement[0]) {\n        return searchInChildren[0];\n      }\n\n      return null;\n    }\n    /**\n     * Read attributes for element\n     *\n     * @param {DataMappingAttributesInterface[]} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof PropertyReaderPool} propertyReaderPool\n     * @param {typeof ConverterPool} converterPool\n     * @returns {any}\n     */\n    ;\n\n    _proto.readAttributes = function readAttributes(config, element, data, propertyReaderPool, converterPool) {\n      var result = {};\n\n      for (var _iterator = _createForOfIteratorHelperLoose(config), _step; !(_step = _iterator()).done;) {\n        var attributeConfig = _step.value;\n\n        if (\"write\" === attributeConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = !!attributeConfig.static ? attributeConfig.value : propertyReaderPool.get(attributeConfig.reader).read(element, attributeConfig.name);\n\n        if (converterPool.get(attributeConfig.converter)) {\n          value = converterPool.get(attributeConfig.converter).fromDom(value);\n        }\n\n        if (_jquery.type(result[attributeConfig.var]) === \"object\") {\n          var _mageUtils$extend;\n\n          value = _mageUtils.extend((_mageUtils$extend = {}, _mageUtils$extend[attributeConfig.name] = value, _mageUtils$extend), result[attributeConfig.var]);\n        }\n\n        result[attributeConfig.var] = value;\n      }\n\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read style properties for element\n     *\n     * @param {DataMappingStyleInterface[]} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof PropertyReaderPool} propertyReaderPool\n     * @param {typeof ConverterPool} converterPool\n     * @returns {{[p: string]: string}}\n     */\n    ;\n\n    _proto.readStyle = function readStyle(config, element, data, propertyReaderPool, converterPool) {\n      var result = _underscore.extend({}, data);\n\n      for (var _iterator2 = _createForOfIteratorHelperLoose(config), _step2; !(_step2 = _iterator2()).done;) {\n        var propertyConfig = _step2.value;\n\n        if (\"write\" === propertyConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = !!propertyConfig.static ? propertyConfig.value : propertyReaderPool.get(propertyConfig.reader).read(element, propertyConfig.name);\n\n        if (converterPool.get(propertyConfig.converter)) {\n          value = converterPool.get(propertyConfig.converter).fromDom(value);\n        }\n\n        if (_jquery.type(result[propertyConfig.var]) === \"object\") {\n          value = _mageUtils.extend(result[propertyConfig.var], value);\n        }\n\n        result[propertyConfig.var] = value;\n      }\n\n      return result;\n    }\n    /**\n     * Read element's tag\n     *\n     * @param {object} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @returns {object}\n     */\n    ;\n\n    _proto.readHtmlTag = function readHtmlTag(config, element, data) {\n      var result = {};\n      result[config.tag.var] = element.nodeName.toLowerCase();\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read element's css\n     *\n     * @param {ContentTypeConfigAppearanceElementInterface} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @returns {any}\n     */\n    ;\n\n    _proto.readCss = function readCss(config, element, data) {\n      var result = {};\n      var css = element.getAttribute(\"class\") !== null ? element.getAttribute(\"class\") : \"\";\n\n      if (config.css !== undefined && config.css.filter !== undefined && config.css.filter.length) {\n        for (var _iterator3 = _createForOfIteratorHelperLoose(config.css.filter), _step3; !(_step3 = _iterator3()).done;) {\n          var filterClass = _step3.value;\n          css = css.replace(filterClass, \"\");\n        }\n      }\n\n      result[config.css.var] = css.replace(/\\s{2,}/g, \" \").trim();\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read element's content\n     *\n     * @param {ContentTypeConfigAppearanceElementInterface} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof ConverterPool} converterPool\n     * @returns {any}\n     */\n    ;\n\n    _proto.readHtml = function readHtml(config, element, data, converterPool) {\n      var result = {};\n      var value = element.innerHTML;\n\n      if (converterPool.get(config.html.converter)) {\n        value = converterPool.get(config.html.converter).fromDom(value);\n      }\n\n      result[config.html.var] = value;\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Convert data after it's read for all elements\n     *\n     * @param config\n     * @param {object} data\n     * @param {typeof MassConverterPool} massConverterPool\n     * @returns {object}\n     */\n    ;\n\n    _proto.convertData = function convertData(config, data, massConverterPool) {\n      for (var _iterator4 = _createForOfIteratorHelperLoose(config.converters), _step4; !(_step4 = _iterator4()).done;) {\n        var converterConfig = _step4.value;\n\n        if (massConverterPool.get(converterConfig.component)) {\n          data = massConverterPool.get(converterConfig.component).fromDom(data, converterConfig.config);\n        }\n      }\n\n      return data;\n    };\n\n    return Configurable;\n  }();\n\n  return Configurable;\n});\n//# sourceMappingURL=configurable.js.map","Magento_PageBuilder/js/master-format/render/serialize.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-collection\"], function (_config, _contentTypeCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Serialize the tree as a simplified object for rendering\n   *\n   * @param contentType\n   */\n  function buildTree(contentType) {\n    var data = getData(contentType);\n    var viewportsData = getViewportsData(contentType);\n    var tree = {\n      name: contentType.config.name,\n      id: contentType.id,\n      data: data,\n      children: [],\n      viewportsData: viewportsData\n    };\n\n    if (contentType instanceof _contentTypeCollection && contentType.getChildren()().length > 0) {\n      contentType.getChildren()().forEach(function (child) {\n        tree.children.push(buildTree(child));\n      });\n    }\n\n    return tree;\n  }\n  /**\n   * Get a serialized version of the tree\n   *\n   * @param contentType\n   */\n\n\n  function getSerializedTree(contentType) {\n    return buildTree(contentType);\n  }\n  /**\n   * Retrieve the master data from the content types instance\n   *\n   * @param contentType\n   */\n\n\n  function getData(contentType) {\n    /**\n     * Flip flop to JSON and back again to ensure all data is serializable. Magento by default adds functions into\n     * some basic types which cannot be serialized when calling PostMessage.\n     */\n    return JSON.parse(JSON.stringify(contentType.dataStores[_config.getConfig(\"defaultViewport\")].getState())) || {};\n  }\n  /**\n   * Retrieve the master data from the content types instance\n   *\n   * @param contentType\n   */\n\n\n  function getViewportsData(contentType) {\n    /**\n     * Flip flop to JSON and back again to ensure all data is serializable. Magento by default adds functions into\n     * some basic types which cannot be serialized when calling PostMessage.\n     */\n    var result = {};\n    Object.keys(contentType.dataStores).forEach(function (name) {\n      result[name] = JSON.parse(JSON.stringify(contentType.dataStores[name].getState())) || {};\n    });\n    return result;\n  }\n\n  return {\n    buildTree: buildTree,\n    getSerializedTree: getSerializedTree\n  };\n});\n//# sourceMappingURL=serialize.js.map","Magento_PageBuilder/js/master-format/render/events.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * The frame does not need to create or observe events, however the app will naturally attempt to. So let's stop that!\n   */\n  var _default = {\n    on: function on() {\n      return this;\n    },\n    off: function off() {\n      return this;\n    },\n    trigger: function trigger() {\n      return this;\n    }\n  };\n  return _default;\n});\n//# sourceMappingURL=events.js.map","Magento_PageBuilder/js/master-format/render/frame.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"csso\", \"jquery\", \"knockout\", \"Magento_Ui/js/lib/knockout/template/engine\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/binding/master-style\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/master-format/filter-html\"], function (_csso, _jquery, _knockout, _engine, _mageUtils, _underscore, _masterStyle, _config, _contentTypeFactory, _styleRegistry, _directives, _filterHtml) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var port = null;\n\n  var portDeferred = _jquery.Deferred();\n\n  var deferredTemplates = {};\n  var lastRenderId;\n  /**\n   * Debounce the render call, so we don't render until the final request\n   */\n\n  var debounceRender = _underscore.debounce(function (message, renderId) {\n    render(message, renderId).then(function (output) {\n      // Only post the most recent render back to the parent\n      if (lastRenderId === renderId) {\n        port.postMessage({\n          type: \"render\",\n          message: output\n        });\n      }\n    });\n  }, 50);\n  /**\n   * Listen for requests from the parent window for a render\n   */\n\n\n  function listen(config) {\n    var stageId = window.location.href.split(\"?\")[1].split(\"=\")[1];\n\n    _config.setConfig(config);\n\n    _config.setMode(\"Master\"); // Override assign with extend to prevent deep object overriding.\n\n\n    Object.assign = _mageUtils.extend;\n    /**\n     * Create a listener within our iframe so we can observe messages from the parent, once we receive a port on the\n     * MessageChannel we utilise that for all communication.\n     */\n\n    window.addEventListener(\"message\", function (event) {\n      if (event.ports && event.ports.length) {\n        port = event.ports[0];\n        portDeferred.resolve(port);\n\n        port.onmessage = function (messageEvent) {\n          if (messageEvent.data.type === \"render\") {\n            var renderId = _mageUtils.uniqueid();\n\n            lastRenderId = renderId;\n            debounceRender(messageEvent.data.message, renderId);\n          }\n\n          if (messageEvent.data.type === \"template\") {\n            var message = messageEvent.data.message;\n\n            if (message.name in deferredTemplates) {\n              deferredTemplates[message.name].resolve(message.template);\n              delete deferredTemplates[message.name];\n            }\n          }\n        };\n      }\n    }, false); // Inform the parent iframe that we're ready to receive the port\n\n    window.parent.postMessage({\n      name: \"PB_RENDER_READY\",\n      stageId: stageId\n    }, \"*\");\n  }\n  /**\n   * Use our MessageChannel to load a template from the parent window, this is required as the iframe isn't allowed to\n   * make same origin XHR requests.\n   *\n   * @param name\n   */\n\n\n  function loadTemplate(name) {\n    return new Promise(function (resolve) {\n      if (!(name in deferredTemplates)) {\n        deferredTemplates[name] = _jquery.Deferred();\n      }\n\n      deferredTemplates[name].then(function (template) {\n        resolve(template);\n      });\n\n      if (port) {\n        port.postMessage({\n          type: \"template\",\n          message: name\n        });\n      } else {\n        portDeferred.then(function (messagePort) {\n          messagePort.postMessage({\n            type: \"template\",\n            message: name\n          });\n        });\n      }\n    });\n  }\n  /**\n   * Assert if the render has finished\n   */\n\n\n  var assertRenderFinished = _underscore.debounce(function (element, expectedCount, callback) {\n    if (element.querySelectorAll(\"[data-content-type]\").length === expectedCount) {\n      callback();\n    }\n  }, 50);\n  /**\n   * Iterate over the root container and count all content types\n   *\n   * @param rootContainer\n   * @param count\n   */\n\n\n  function countContentTypes(rootContainer, count) {\n    count = count || 0;\n    rootContainer.getChildren()().forEach(function (child) {\n      ++count;\n\n      if (typeof child.getChildren !== \"undefined\" && child.getChildren()().length > 0) {\n        count = countContentTypes(child, count);\n      }\n    });\n    return count;\n  }\n  /**\n   * Perform a render of the provided data\n   *\n   * @param message\n   * @param renderId\n   */\n\n\n  function render(message, renderId) {\n    var styleRegistries = {};\n\n    _underscore.each(_config.getConfig(\"viewports\"), function (viewport, name) {\n      styleRegistries[name] = new _styleRegistry(name + renderId);\n    });\n\n    return new Promise(function (resolve, reject) {\n      createRenderTree(message.stageId, message.tree).then(function (rootContainer) {\n        var element = document.createElement(\"div\");\n        /**\n         * Setup an event on the element to observe changes and count the expected amount of content types are\n         * present within the content.\n         */\n\n        var renderFinished = _jquery.Deferred();\n\n        var observer = new MutationObserver(function () {\n          assertRenderFinished(element, countContentTypes(rootContainer), renderFinished.resolve);\n        });\n        observer.observe(element, {\n          attributes: true,\n          childList: true,\n          subtree: true\n        }); // Combine this event with our engine waitForRenderFinish to ensure rendering is completed\n\n        _jquery.when(_engine.waitForFinishRender(), renderFinished).then(function () {\n          observer.disconnect();\n\n          _knockout.cleanNode(element);\n\n          var styles = generateMasterCssForViewports(styleRegistries);\n\n          if (styles) {\n            (0, _jquery)(element).append((0, _jquery)(\"<style/>\").html(styles));\n          }\n\n          _underscore.each(styleRegistries, function (value, name) {\n            return (0, _styleRegistry.deleteStyleRegistry)(name + renderId);\n          });\n\n          var filtered = (0, _filterHtml)((0, _jquery)(element));\n          var output = (0, _directives.replaceWithSrc)((0, _directives)(filtered.html()));\n          resolve(output);\n        });\n\n        _knockout.applyBindingsToNode(element, {\n          template: {\n            data: rootContainer.content,\n            name: rootContainer.content.template\n          }\n        }, {\n          id: renderId\n        });\n      }).catch(function (error) {\n        reject(error);\n      });\n    });\n  }\n  /**\n   * Rebuild the content type tree using their original data and configuration\n   *\n   * @param stageId\n   * @param tree\n   * @param parent\n   */\n\n\n  function createRenderTree(stageId, tree, parent) {\n    if (parent === void 0) {\n      parent = null;\n    }\n\n    return new Promise(function (resolve, reject) {\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(tree.name), parent, stageId, tree.data, parent !== null ? tree.children.length : 0, tree.viewportsData).then(function (contentType) {\n        // Ensure  we retain the original tree ID's\n        contentType.id = tree.id;\n\n        if (tree.children.length > 0) {\n          var childPromises = [];\n          tree.children.forEach(function (child) {\n            childPromises.push(createRenderTree(stageId, child, contentType));\n          });\n          Promise.all(childPromises).then(function (children) {\n            children.forEach(function (child) {\n              contentType.addChild(child);\n            });\n            resolve(contentType);\n          });\n        } else {\n          resolve(contentType);\n        }\n      }).catch(function (error) {\n        reject(error);\n      });\n    });\n  }\n  /**\n   * Generate the master format CSS\n   *\n   * @param registry\n   */\n\n\n  function generateMasterCss(registry) {\n    var scopes = Object.keys(registry.getAllStyles()).map(function (selector) {\n      return [selector];\n    });\n    return _csso.minify((0, _styleRegistry.generateCss)(registry.getAllStyles()), {\n      usage: {\n        scopes: scopes\n      }\n    }).css;\n  }\n\n  function generateMasterCssForViewports(registries) {\n    var result = \"\";\n\n    _underscore.each(registries, function (registry, name) {\n      var css = generateMasterCss(registry);\n\n      var media = _config.getConfig(\"viewports\")[name].media;\n\n      if (media && css) {\n        result += \"@media \" + media + \" { \" + css + \" }\";\n      } else {\n        result += css;\n      }\n    });\n\n    return result;\n  }\n\n  return Object.assign(listen, {\n    loadTemplate: loadTemplate\n  });\n});\n//# sourceMappingURL=frame.js.map","Magento_PageBuilder/js/master-format/render/requirejs/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"mage/requirejs/text\", \"Magento_PageBuilder/js/master-format/render/frame\"], function (_text, _frame) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Within our render frame we override the RequireJS text! plugin, this is originally implemented within\n   * lib/web/mage/requirejs/text.js. The override uses the MessageChannel to communicate with the parent frame to\n   * retrieve any requested HTML knockout template. We do this due to the sandbox restrictions on the iframe disallow\n   * XHR requests to the same origin domain.\n   */\n\n  /**\n   * Load a template\n   *\n   * @param name\n   * @param req\n   * @param onLoad\n   */\n  function load(name, req, onLoad) {\n    (0, _frame.loadTemplate)(name).then(function (template) {\n      onLoad(template);\n    }).catch(function (error) {\n      onLoad.error(error);\n    });\n  }\n  /**\n   * Retrieve a template\n   *\n   * @param url\n   * @param callback\n   * @param fail\n   * @param headers\n   */\n\n\n  function get(url, callback, fail, headers) {\n    _text.get.apply(_text, arguments);\n  }\n\n  return {\n    load: load,\n    get: get\n  };\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/modal/modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_PageBuilder/js/events'\n], function (ModalComponent, events) {\n    'use strict';\n\n    return ModalComponent.extend({\n        defaults: {\n            titlePrefix: '${ $.options.title }',\n            modules: {\n                insertForm: '${ $.insertFormProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            events.on('form:renderAfter', function (params) {\n                this.openModal();\n                this.setTitle(this.titlePrefix + ' ' + params.title);\n                this.startListen(params.id);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Listen for from save.\n         *\n         * @param {String} id\n         */\n        startListen: function (id) {\n            events.on('form:' + id + ':saveAfter', function () {\n                this.closeModal();\n            }.bind(this));\n\n        },\n\n        /**\n         * Trigger modalClosed event on external provider\n         *\n         * @returns {any}\n         */\n        closeModal: function () {\n            this.insertForm() &&\n            this.insertForm().externalSource() &&\n            this.insertForm().externalSource().trigger('data.modalClosed');\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/modal/dismissible-confirm.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Extend the confirmation prompt to allow for an additional checkbox to be displayed. The checkbox enables the user to\n * dismiss subsequent prompts of the same type based on their dismissKey.\n *\n * Once a type is dismissed a cookie is set and all future instances of that prompt are bypassed. This cookie is\n * cleared once the user logs out and back in via an observer.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'text!Magento_PageBuilder/template/modal/dismissible-modal-content.html',\n    'mage/translate',\n    'Magento_Ui/js/modal/prompt',\n    'mage/cookies'\n], function ($, _, promptContentTmpl, $t) {\n    'use strict';\n\n    /**\n     * Create buttons array for modal options\n     *\n     * @param {Boolean} haveCancelButton\n     * @return {Object}\n     */\n    function buttonsConfig(haveCancelButton) {\n        var cancelButton = {\n            text: $.mage.__('Cancel'),\n            class: 'action-secondary action-dismiss',\n\n            /**\n             * Click handler.\n             */\n            click: function () {\n                this.closeModal(false);\n            }\n        },\n            confirmButton = {\n            text: $.mage.__('OK'),\n            class: 'action-primary action-accept',\n\n            /**\n             * Click handler.\n             */\n            click: function () {\n                this.closeModal(true);\n            }\n        },\n            buttons = [];\n\n        if (haveCancelButton !== false) {\n            buttons.push(cancelButton);\n        }\n        buttons.push(confirmButton);\n\n        return buttons;\n    }\n\n    $.widget('mage.dismissibleConfirm', $.mage.prompt, {\n        options: {\n            promptContentTmpl: promptContentTmpl,\n            dismissible: false, // Can the modal be dismissed?\n            dismissKey: 'default', // The key we'll check to see if the modal has already been dismissed\n            dismissMessage: $t('Do not show this again'), // Message to display next to the dismiss checkbox\n            dismissCheckbox: '[name=\"modal-dnsa\"]' // Selector to retrieve dismiss checkbox\n        },\n\n        /**\n         * Open the modal window, if the modal has been dismissed, then run the confirm & always actions and don't\n         * don't open the modal\n         *\n         * @returns {*}\n         */\n        openModal: function () {\n            if ($.mage.cookies.get(this.options.dismissKey) === 'true') {\n                this.options.actions.confirm();\n\n                return this.options.actions.always(); // Always runs after confirm in confirm.js\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Close modal window.\n         *\n         * @param {Boolean} result\n         */\n        closeModal: function (result) {\n            this._super(result);\n\n            if (result && this._isDismissed()) {\n                $.mage.cookies.set(this.options.dismissKey, 'true', {});\n            }\n        },\n\n        /**\n         * Is the dismissed checkbox checked?\n         *\n         * @private\n         */\n        _isDismissed: function () {\n            return this.modal.find(this.options.dismissCheckbox).is(':checked');\n        }\n    });\n\n    return function (config) {\n        config.buttons = buttonsConfig(config.haveCancelButton);\n        delete config.haveCancelButton;\n\n        return $('<div></div>').html(config.content).dismissibleConfirm(config);\n    };\n});\n","Magento_PageBuilder/js/modal/template-manager-modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_PageBuilder/js/events',\n    'underscore',\n    'Magento_PageBuilder/js/stage-builder'\n], function ($, ModalComponent, events, _, stageBuilder) {\n    'use strict';\n\n    return ModalComponent.extend({\n        defaults: {\n            stage: null,\n            modules: {\n                messageContainer: '${ $.messageContainerProvider }',\n                listing: '${ $.listingProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            _.bindAll(this, 'closeModal');\n\n            events.on('stage:templateManager:open', function (params) {\n                this.openModal();\n                this.stage = params.stage;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Apply selected template\n         *\n         * @param {String} template\n         */\n        applySelected: function (template) {\n            if (template) {\n                // Destroy the old content in the stage\n                this.stage.pageBuilder.destroy();\n                $('body').trigger('processStart');\n\n                stageBuilder(this.stage, template).then(function () {\n                    $('body').trigger('processStop');\n                    this.closeModal();\n                }.bind(this));\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/modal/template-manager-save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate',\n    'Magento_Ui/js/modal/prompt'\n], function ($, _, $t) {\n    'use strict';\n\n    $.widget('mage.templateManagerSave', $.mage.prompt, {\n        options: {\n            createdForField: '[data-role=\"createdForField\"]',\n            previewImage: '[data-role=\"preview-image\"]',\n            previewImageSpinner: '[data-role=\"preview-image-spinner\"]',\n            saveButton: '[data-role=\"action\"].action-save',\n            form: 'form',\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }, {\n                text: $.mage.__('Save'),\n                class: 'action-primary action-save',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.submit();\n                }\n            }]\n        },\n\n        /**\n         * Create widget\n         *\n         * @private\n         */\n        _create: function () {\n            this._super();\n\n            this.modal.find(this.options.saveButton).prop('disabled', 'disabled');\n            // Ensure if the form is submitted through hitting enter we handle it correctly\n            this.modal.find(this.options.form).on('submit', function (event) {\n                event.preventDefault();\n                this.submit();\n            }.bind(this));\n        },\n\n        /**\n         * Validate prompt contains a template name\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            return this.modal.find(this.options.promptField) &&\n                !_.isEmpty(this.modal.find(this.options.promptField).val());\n        },\n\n        /**\n         * Save the values within the prompt\n         */\n        submit: function () {\n            var name,\n                createdFor;\n\n            if (this.options.validation && !this.validate()) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n\n            name = this.modal.find(this.options.promptField).val();\n            createdFor = this.modal.find(this.options.createdForField).val();\n\n            this.options.actions.confirm.call(this, name, createdFor).then(function () {\n                this.closeModal(true);\n                $('body').trigger('processStop');\n            }.bind(this)).catch(function () {\n                $('body').trigger('processStop');\n            });\n        },\n\n        /**\n         * Set the preview image\n         *\n         * @param {String} image\n         */\n        setPreviewImage: function (image) {\n            var previewImage = this.modal.find(this.options.previewImage),\n                previewImageSpinner = this.modal.find(this.options.previewImageSpinner);\n\n            // Update the preview image within the modal\n            previewImageSpinner.hide();\n            previewImage.append(\n                $('<img />').prop('src', image).prop('alt', $t('Template Preview'))\n            ).show();\n\n            // Enable the button so the user can save\n            this.modal.find(this.options.saveButton).prop('disabled', false);\n        },\n\n        /**\n         * Close modal window\n         */\n        closeModal: function (saved) {\n            if (!saved) {\n                this.options.actions.cancel.call(this, saved);\n            }\n\n            this.options.actions.always();\n            this.element.on('promptclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div class=\"prompt-message\"></div>').html(config.content).templateManagerSave(config);\n    };\n});\n","Magento_PageBuilder/js/modal/confirm-alert.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/alert',\n    'jquery/z-index'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.confirmAlert', $.mage.alert, {\n        /**\n         * Fix issue with zIndex when removing the alert from the screen\n         * @private\n         */\n        _unsetActive: function () {\n            this._super();\n\n            if (this.overlay) {\n                this.overlay.zIndex('');\n            }\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).confirmAlert(config);\n    };\n});\n","Magento_PageBuilder/js/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/provider',\n    'Magento_PageBuilder/js/events'\n], function (Provider, events) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        initClient: function () {\n            return this;\n        },\n\n        /** @inheritdoc **/\n        save: function () {\n            events.trigger('form:' + this.id + ':saveAfter', this.get('data'));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/form-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'consoleLogger'\n], function (_, $, events, consoleLogger) {\n    'use strict';\n\n    var mixin = {\n        defaults: {\n            pageBuilderInstances: []\n        },\n\n        /**\n         * Record instances of Page Builder initialized in the forms namespace\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            events.on('pagebuilder:register', function (data) {\n                if (data.ns === self.ns) {\n                    self.pageBuilderInstances.push(data.instance);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Intercept save call to ensure any Page Builder rendering is completed before submitting form\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        save: function (redirect, data) {\n            var submit = this._super.bind(this, redirect, data),\n                timeout,\n                locks;\n\n            if (_.isEmpty(this.pageBuilderInstances)) {\n                submit();\n            } else {\n                timeout = setTimeout(function () {\n                    consoleLogger.error('Page Builder was rendering for 5 seconds without releasing locks.');\n                }, 5000);\n\n                $('body').trigger('processStart');\n\n                // Wait for all rendering locks within Page Builder stages to resolve\n                $.when.apply(\n                    null,\n                    this.pageBuilderInstances.map(function (instance) {\n                        locks = instance.stage.renderingLocks;\n\n                        return locks[locks.length - 1];\n                    })\n                ).then(function () {\n                    $('body').trigger('processStop');\n                    clearTimeout(timeout);\n                    submit();\n                });\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PageBuilder/js/form/map-location-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/provider',\n    'Magento_PageBuilder/js/events'\n], function (Provider, events) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        initClient: function () {\n            return this;\n        },\n\n        /** @inheritdoc **/\n        save: function () {\n            events.trigger('mapLocation:saveAfter', this.get('data'));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/action-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/button'\n], function (Button) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            modules: {\n                parent: '${ $.parentName }',\n                insertForm: '${ $.insertFormProvider }',\n                modal: '${ $.modalProvider }'\n            }\n        },\n\n        /**\n         * Edit form with data assigning.\n         */\n        edit: function () {\n            this.modal().openModal();\n            this.insertForm().edit(this.parent().data());\n        },\n\n        /**\n         * Delete record from dynamic row.\n         */\n        deleteRecord: function () {\n            var record = this.parent(),\n                dynamicRow = record.parentComponent(),\n                prop = dynamicRow.identificationProperty,\n                id = record.data()[prop];\n\n            dynamicRow.deleteRecord(record.index, id);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/map-location-insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (Insert) {\n    'use strict';\n\n    return Insert.extend({\n        /**\n         * Clear form content and reinsert data in argument\n         * @param {Object} data\n         */\n        edit: function (data) {\n            this.destroyInserted();\n            this.render();\n            this.setData(data);\n        },\n\n        /**\n         * Set data for new form\n         *\n         * @param {Object} data\n         */\n        setData: function (data) {\n            var formQuery = 'index=' + this.ns,\n                dataProviderQuery = 'index=' + this.ns + '_data_source';\n\n            this.providerData = data;\n            this.externalForm = this.requestModule(formQuery);\n            this.externalSource = this.requestModule(dataProviderQuery);\n            this.setLinks({\n                providerData: dataProviderQuery + ':data'\n            }, 'exports');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form',\n    'Magento_PageBuilder/js/events',\n    'jquery'\n], function (Insert, events, $) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            appearanceIndex: '',\n            configs: {},\n            tracks: {\n                id: true\n            },\n            listens: {\n                appearance: 'onAppearanceChange'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            events.on('form:renderAfter', function (params) {\n                this.render(params);\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        render: function (params) {\n            this.availableAppearances = params.appearances;\n            this.title = params.title;\n            this.defaultNamespace = params.defaultNamespace;\n            this.destroyInserted();\n            this.setData(params);\n\n            return this._super({\n                namespace: params.namespace,\n                handle: params.namespace\n            });\n        },\n\n        /**\n         * Set data for new form.\n         *\n         * @param {Object} params\n         */\n        setData: function (params) {\n            var formQuery = 'index=' + params.namespace,\n                dataProviderQuery = 'index=' + params.namespace + '_data_source';\n\n            this.providerData = params.data;\n            this.id = params.id;\n            this.externalForm = this.requestModule(formQuery);\n            this.externalSource = this.requestModule(dataProviderQuery);\n            this.setLinks({\n                appearance: 'ns = ' + params.namespace + ', index = ' + this.appearanceIndex + ':value'\n            }, 'imports');\n            this.setLinks({\n                providerData: dataProviderQuery + ':data',\n                prefix: formQuery + ':selectorPrefix',\n                id: dataProviderQuery + ':id'\n            }, 'exports');\n        },\n\n        /** @inheritdoc **/\n        requestData: function (params) {\n            var deffer = $.Deferred(),\n                formConfig = this.configs[params.namespace];\n\n            if (formConfig) {\n                return deffer.resolve(formConfig);\n            }\n\n            return this._super().done(function (data) {\n                this.configs[params.namespace] = data;\n            }.bind(this));\n        },\n\n        /**\n         * Re-render after appearance change\n         *\n         * @param {String} value\n         */\n        onAppearanceChange: function (value) {\n            var namespace = this.availableAppearances[value] && this.availableAppearances[value].form ||\n                this.defaultNamespace;\n\n            if (namespace !== this.previousParams.namespace) {\n                this.render({\n                    namespace: namespace,\n                    id: this.id,\n                    data: this.externalSource().get('data'),\n                    appearances: this.availableAppearances,\n                    title: this.title,\n                    defaultNamespace: this.defaultNamespace\n                });\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/map-location-dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'Magento_PageBuilder/js/events',\n    'underscore',\n    'jquery'\n], function (dynamicRows, Events, _, $) {\n    'use strict';\n\n    /**\n     * Returns sortable values\n     *\n     * @param {String | Number | Object | Array} value\n     * @return {String | Number}\n     */\n    var sortValueValidator = function (value) {\n        if (typeof value === 'string') {\n            return value.toLowerCase();\n        }\n\n        if (typeof value === 'number') {\n            return value;\n        }\n\n        return '';\n    };\n\n    return dynamicRows.extend({\n        defaults: {\n            modules: {\n                insertForm: '${ $.insertFormProvider }',\n                modal: '${$.modalProvider}'\n            }\n        },\n\n        /** @inheritdoc */\n        initLinks: function () {\n            this._super();\n            Events.on('mapLocation:saveAfter', function (data) {\n                this.modal().closeModal();\n                this.reInitData(data);\n            }.bind(this), this.name);\n\n            return this;\n        },\n\n        /**\n         * Open the location modal and insert form with the data from selected record\n         *\n         * @param {Object} record\n         */\n        edit: function (record) {\n            this.modal().openModal();\n            this.insertForm().edit(record.data());\n        },\n\n        /**\n         * Reinitializing of dynamic row records.\n         *\n         * @param {Object} data\n         */\n        reInitData: function (data) {\n            var recordData = this.recordData().slice(),\n                prop = this.identificationProperty,\n                isExists = false;\n\n            _.each(recordData, function (elem, index) {\n                if (elem[prop] === data[prop]) {\n                    recordData[index] = data;\n                    isExists = true;\n                }\n            }, this);\n\n            if (!isExists) {\n                recordData.push(data);\n            }\n\n            this.recordData(recordData);\n\n            _.each(this.labels(), function (label) {\n                if (label.columnsHeaderClasses) {\n                    this.sortRecord(label.name, label.columnsHeaderClasses === '_ascend');\n                }\n            }.bind(this));\n\n            this.reload();\n        },\n\n        /**\n         * Logic to toggle ascend and descend sorting for headers\n         *\n         * @param {KnockoutObservableArray} property\n         */\n        sortByHeader: function (property) {\n            var ascend,\n                activeLabel,\n                allLabels,\n                placeholder;\n\n            if (property().name === 'actions') {\n                return;\n            }\n\n            if (property().columnsHeaderClasses) {\n                activeLabel = $.extend({}, property());\n                activeLabel.columnsHeaderClasses =\n                    property().columnsHeaderClasses === '_ascend' ? '_descend' : '_ascend';\n                ascend = activeLabel.columnsHeaderClasses === '_ascend';\n                property(activeLabel);\n            } else {\n                allLabels = this.labels().slice();\n                allLabels.forEach(function (label) {\n\n                    if (label.name === property().name) {\n                        label.columnsHeaderClasses = '_ascend';\n                    } else {\n                        label.columnsHeaderClasses = '';\n                    }\n                });\n                ascend = true;\n                this.labels(allLabels);\n            }\n\n            if (this.recordData().length) {\n                placeholder = this.emptyContentPlaceholder;\n\n                this.emptyContentPlaceholder = false;\n                this.sortRecord(property().name, ascend);\n                this.reload();\n                this.emptyContentPlaceholder = placeholder;\n            }\n        },\n\n        /**\n         * Sorting of dynamic row records.\n         *\n         * @param {String} sortBy\n         * @param {Boolean} ascend\n         */\n        sortRecord: function (sortBy, ascend) {\n            this.recordData.sort(function (left, right) {\n                var record1 = ascend ? left : right,\n                    record2 = ascend ? right : left;\n\n                record1 = sortValueValidator(record1[sortBy]);\n                record2 = sortValueValidator(record2[sortBy]);\n\n                return record1 === record2 ? 0 : record1 < record2 ? -1 : 1;\n            });\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n            Events.off(this.name);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/provider/conditions-data-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mage/utils/objects',\n    'Magento_Rule/conditions-data-normalizer'\n], function (_, objectUtils, ConditionsDataNormalizer) {\n    'use strict';\n\n    var serializer = new ConditionsDataNormalizer();\n\n    return function (data, attribute) {\n        var pairs = {},\n            conditions = '';\n\n        /*\n         * The Condition Rule Tree is not a UI component and doesn't provide good data.\n         * The best solution is to implement the tree as a UI component that can provide good data but\n         * that is outside of the scope of the feature for now.\n         */\n        _.each(data, function (element, key) {\n            // parameters is hardcoded in the Magento\\Rule model that creates the HTML forms.\n            if (key.indexOf('parameters[' + attribute + ']') === 0) {\n                // Remove the bad, un-normalized data.\n                delete data[key];\n                pairs[key] = element;\n            }\n        });\n\n        /*\n         * The Combine Condition rule needs to have children,\n         * if does not have, we cannot parse the rule in the backend.\n         */\n        _.each(pairs, function (element, key) {\n            var keyIds = key.match(/[\\d?-]+/g),\n              combineElement = 'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Combine',\n              nextPairsFirstKey = 'parameters[condition_source][NEXT_ITEM--1][type]',\n              nextPairsSecondKey = 'parameters[condition_source][NEXT_ITEM--2][type]';\n\n            if (keyIds !== null && element === combineElement) {\n                if (pairs[nextPairsFirstKey.replace('NEXT_ITEM', keyIds[0])] === undefined ||\n                    pairs[nextPairsFirstKey.replace('NEXT_ITEM', keyIds[0])] === combineElement &&\n                    pairs[nextPairsSecondKey.replace('NEXT_ITEM', keyIds[0])] === undefined) {\n                    pairs[key] = '';\n                }\n            }\n        });\n\n        /*\n         * Add pairs in case conditions source is not rules configurator\n         */\n        if (data['condition_option'] !== 'condition') {\n            pairs['parameters[' + attribute + '][1--1][operator]'] =\n                data[data['condition_option'] + '-condition_operator'] ?\n                data[data['condition_option'] + '-condition_operator'] :\n                '==';\n            pairs['parameters[' + attribute + '][1--1][type]'] =\n                'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Product';\n            pairs['parameters[' + attribute + '][1][aggregator]'] = 'all';\n            pairs['parameters[' + attribute + '][1][new_child]'] = '';\n            pairs['parameters[' + attribute + '][1][type]'] = 'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Combine';\n            pairs['parameters[' + attribute + '][1][value]'] = '1';\n            pairs['parameters[' + attribute + '][1--1][attribute]'] = data['condition_option'];\n            pairs['parameters[' + attribute + '][1--1][value]'] = _.isString(data[data['condition_option']]) ?\n                data[data['condition_option']].trim() :\n                '';\n        }\n\n        if (!_.isEmpty(pairs)) {\n            conditions = JSON.stringify(serializer.normalize(pairs).parameters[attribute]);\n            data['conditions_encoded'] = conditions;\n            objectUtils.nested(data, attribute, conditions);\n        }\n    };\n});\n","Magento_PageBuilder/js/form/element/dependent-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            visible: false\n        },\n\n        /**\n         * Dependently display dropdown component if it contains more than one option\n         *\n         * @returns {Object} Chainable\n         */\n        setOptions: function () {\n            this._super();\n\n            if (this.options().length > 1) {\n                this.setVisible(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/html-code.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global MediabrowserUtility, widgetTools, MagentovariablePlugin */\ndefine([\n    'Magento_Ui/js/form/element/textarea',\n    'mage/adminhtml/wysiwyg/widget'\n], function (Textarea) {\n    'use strict';\n\n    var HTML_ID_PLACEHOLDER = 'HTML_ID_PLACEHOLDER';\n\n    return Textarea.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/html-code'\n        },\n\n        /**\n         * Click event for Insert Widget Button\n         */\n        clickInsertWidget: function () {\n            return widgetTools.openDialog(\n                this.widgetUrl.replace(HTML_ID_PLACEHOLDER, this.uid)\n            );\n        },\n\n        /**\n         * Click event for Insert Image Button\n         */\n        clickInsertImage: function () {\n            return MediabrowserUtility.openDialog(\n                this.imageUrl.replace(HTML_ID_PLACEHOLDER, this.uid)\n            );\n        },\n\n        /**\n         * Click event for Insert Variable Button\n         */\n        clickInsertVariable: function () {\n            return MagentovariablePlugin.loadChooser(\n                this.variableUrl,\n                this.uid\n            );\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-visual-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_PageBuilder/js/form/element/visual-select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            visible: false\n        },\n\n        /**\n         * Dependently display dropdown component if it contains more than one option\n         *\n         * @returns {Object} Chainable\n         */\n        setOptions: function () {\n            this._super();\n\n            if (this.options().length > 1) {\n                this.setVisible(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset'\n], function (Fieldset) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            originalLabelValue: ''\n        },\n\n        /**\n         * Observe label\n         * {@inheritDoc}\n         */\n        initObservable: function () {\n            this._super().observe('label');\n\n            return this;\n        },\n\n        /**\n         * Store original label value\n         * {@inheritDoc}\n         */\n        initConfig: function () {\n            this._super();\n            this.originalLabelValue = this.label;\n        },\n\n        /**\n         * Hide fieldset if number of field options is <= 1 and it is the only element in the group\n         *\n         * @param {Array} options\n         */\n        hideFieldset: function (options) {\n            this.visible(options.length > 1 || this.elems().length > 1);\n        },\n\n        /**\n         * Hide label if number of field options is <= 1\n         *\n         * @param {Array} options\n         */\n        hideLabel: function (options) {\n            this.label(options.length > 1 ? this.originalLabelValue : '');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html',\n    'jquery',\n    'underscore'\n], function (Html, $, _) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            inputSelector: '[data-form-part=${ $.ns }]',\n            elements: [],\n            value: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.initInputListener();\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('value');\n        },\n\n        /**\n         * Listen for value change on each field that has been added.\n         */\n        initInputListener: function () {\n            $.async({\n                component: this,\n                selector: this.inputSelector\n            }, function (el) {\n                this.elements.push(el);\n                $(el).on('change', this.updateValue.bind(this));\n                $(el).nextAll('.rule-param-apply').on('click', function () {\n                    $(el).trigger('change');\n                });\n                $(el).closest('li').find('.rule-param-remove').on('click', function () {\n                    $(el).val('').trigger('change');\n                });\n                this.updateValue(this);\n            }.bind(this));\n        },\n\n        /**\n         * Collect data and update value.\n         */\n        updateValue: function () {\n            var result = {},\n                name;\n\n            this.elements.forEach(function (item) {\n                switch (item.type) {\n                    case 'checkbox':\n                        result[item.name] = +!!item.checked;\n                        break;\n\n                    case 'radio':\n                        if (item.checked) {\n                            result[item.name] = item.value;\n                        }\n                        break;\n\n                    case 'select-multiple':\n                        name = item.name.substring(0, item.name.length - 2); //remove [] from the name ending\n                        result[name] = _.pluck(item.selectedOptions, 'value');\n                        break;\n\n                    default:\n                        result[item.name] = item.value;\n                }\n            });\n\n            this.value(result);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-value-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var setDependentValuesSetting = {\n        defaults: {\n            dependentValues: {}\n        },\n\n        /**\n         * Change value of component if it present in dependentValues\n         */\n        setDependentValues: function (value) {\n            if (this.dependentValues.hasOwnProperty(value)) {\n                this.previousValue = this.value();\n                this.value(this.dependentValues[value]);\n            } else if (this.hasOwnProperty('previousValue')) {\n                this.value(this.previousValue);\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(setDependentValuesSetting);\n    };\n});\n","Magento_PageBuilder/js/form/element/select-filtered-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n\n        defaults: {\n            excludeOptions: []\n        },\n\n        /** @inheritdoc */\n        onUpdate: function () {\n            if (!this.updatedByFilter) {\n                this.transferredValue = null;\n            } else {\n                this.updatedByFilter = false;\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Excluding options according excludeOptions configuration based on the passed value\n         *\n         * @param {String} value\n         */\n        filter: function (value) {\n            var source = this.initialOptions,\n                initialValue = this.value(),\n                result,\n                excludeOptions =  this.excludeOptions[value],\n                excludedOptionsArray = excludeOptions ? excludeOptions.split(',') : [];\n\n            result = _.filter(source, function (item) {\n                return !excludeOptions || excludedOptionsArray.indexOf(item.value) === -1;\n            });\n\n            this.updatedByFilter = true;\n            this.setOptions(result);\n\n            this.value(this.transferredValue ? this.transferredValue : initialValue);\n\n            if (excludedOptionsArray.indexOf(initialValue) !== -1) {\n                this.transferredValue = initialValue;\n            } else {\n                this.transferredValue = null;\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_PageBuilder/js/utils/map',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (AbstractField, GoogleMap, module, events) {\n    'use strict';\n\n    var google = window.google || {};\n\n    return AbstractField.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/map',\n            map: false,\n            marker: false,\n            apiKeyValid: !!module.config().apiKey,\n            apiKeyErrorMessage: module.config().apiKeyErrorMessage\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n\n            this.observe('apiKeyValid');\n\n            return this;\n        },\n\n        /**\n         * Render the map into the field\n         *\n         * @param {HTMLElement} element\n         */\n        renderMap: function (element) {\n            // Get the start value and convert the value into an array\n            var startValue = this.value(),\n                mapOptions,\n                latitudeLongitude;\n\n            if (!this.apiKeyValid()) {\n                return;\n            }\n\n            if (typeof startValue === 'string' && startValue !== '') {\n                startValue = JSON.parse(startValue);\n            }\n\n            mapOptions = {\n                navigationControl: true,\n                navigationControlOptions: {\n                    style: google.maps.NavigationControlStyle.DEFAULT\n                }\n            };\n\n            events.on('googleMaps:authFailure', function () {\n                this.apiKeyValid(false);\n            }.bind(this));\n\n            // Create the map\n            this.mapElement = new GoogleMap(element, [], mapOptions);\n\n            if (!this.mapElement || !this.mapElement.map) {\n                return;\n            }\n\n            // Add marker if there is a start value\n            if (startValue.latitude !== '' && startValue.longitude !== '') {\n                latitudeLongitude = new google.maps.LatLng(\n                    parseFloat(startValue.latitude),\n                    parseFloat(startValue.longitude)\n                );\n\n                this.mapElement.map.setCenter(latitudeLongitude);\n                this.addMarker(startValue.latitude, startValue.longitude);\n            }\n\n            // After click, add and update both Latitude and Longitude.\n            google.maps.event.addListener(this.mapElement.map, 'click', this.onClick.bind(this));\n            google.maps.event.addListener(this.mapElement.map, 'dblclick', this.onDblClick.bind(this));\n            google.maps.event.trigger(this.marker, 'click');\n        },\n\n        /**\n         * Adds a map marker\n         *\n         * @param {String} latitude\n         * @param {String} longitude\n         */\n        addMarker: function (latitude, longitude) {\n            this.marker = new google.maps.Marker({\n                draggable: true,\n                map: this.mapElement.map,\n                position: new google.maps.LatLng(latitude, longitude)\n            });\n            google.maps.event.addListener(this.marker, 'dragend', this.onDragEnd.bind(this));\n        },\n\n        /**\n         * Event for drag end to update value\n         */\n        onDragEnd: function () {\n            this.value(this.exportValue());\n        },\n\n        /**\n         * Event for click to update marker, delayed by 300ms in case of double click\n         *\n         * @param {Event} event\n         */\n        onClick: function (event) {\n            this.clickTimer = setTimeout(function () {\n                if (!this.marker) {\n                    this.addMarker(event.latLng.lat(), event.latLng.lng());\n                }\n                this.value(this.exportValue(event.latLng));\n            }.bind(this), 300);\n        },\n\n        /**\n         * Event for double click to prevent call from single click\n         */\n        onDblClick: function () {\n            clearTimeout(this.clickTimer);\n        },\n\n        /**\n         * Callback after an update to map\n         */\n        onUpdate: function () {\n            if (!this.mapElement) {\n                return;\n            }\n\n            this._super();\n            var content = this.value(),\n                latitudeLongitude;\n\n            if (this.marker && content.latitude === '' && content.longitude === '') {\n                this.marker.setMap(null);\n                delete this.marker;\n\n                return;\n            }\n\n            if (!this.validateCoordinate(content) ||\n                this.mapElement &&\n                !this.mapElement.map ||\n                this.value() === '' ||\n                this.value() === this.exportValue()) {\n                return;\n            }\n\n            if (typeof this.value() === 'string' && this.value() !== '') {\n                content = JSON.parse(this.value());\n            }\n            latitudeLongitude = new google.maps.LatLng(parseFloat(content.latitude), parseFloat(content.longitude));\n\n            if (!this.marker) {\n                this.addMarker(latitudeLongitude.lat(), latitudeLongitude.lng());\n            }\n\n            this.marker.setPosition(latitudeLongitude);\n            this.mapElement.map.setCenter(latitudeLongitude);\n        },\n\n        /**\n         * Coordinate validation\n         *\n         * @param {Object} coordinates\n         * @return {Boolean}\n         */\n        validateCoordinate: function (coordinates) {\n            var valid = true;\n\n            if (coordinates.longitude === '' ||\n                coordinates.latitude === '' ||\n                isNaN(coordinates.longitude) ||\n                isNaN(coordinates.latitude) ||\n                parseFloat(coordinates.longitude) < -180 ||\n                parseFloat(coordinates.longitude) > 180 ||\n                parseFloat(coordinates.latitude) < -90 ||\n                parseFloat(coordinates.latitude) > 90\n            ) {\n                valid = false;\n            }\n\n            return valid;\n        },\n\n        /**\n         * Returns current latitude and longitude as an object\n         *\n         * @param {Object} coordinate\n         * @return {Object}\n         */\n        exportValue: function (coordinate) {\n            var position = this.marker ?\n                this.marker.getPosition() :\n                new google.maps.LatLng(this.mapElement.map.center.lat(), this.mapElement.map.center.lng()),\n                currentCoordinate = coordinate ? coordinate : position;\n\n            return {\n                latitude: currentCoordinate.lat(),\n                longitude: currentCoordinate.lng()\n            };\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/margins-and-padding.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict */\n\ndefine([\n    'underscore',\n    'ko',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, ko, Abstract) {\n    'use strict';\n\n    var defaultValue = '';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/margins-and-padding',\n            marginTop: defaultValue,\n            marginRight: defaultValue,\n            marginBottom: defaultValue,\n            marginLeft: defaultValue,\n            paddingTop: defaultValue,\n            paddingRight: defaultValue,\n            paddingBottom: defaultValue,\n            paddingLeft: defaultValue,\n            listens: {\n                marginTop: 'updateValue',\n                marginRight: 'updateValue',\n                marginBottom: 'updateValue',\n                marginLeft: 'updateValue',\n                paddingTop: 'updateValue',\n                paddingRight: 'updateValue',\n                paddingBottom: 'updateValue',\n                paddingLeft: 'updateValue'\n            }\n        },\n\n        /**\n         * Init observable on our margin & padding properties\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('marginTop marginRight marginBottom marginLeft ' +\n                'paddingTop paddingRight paddingBottom paddingLeft');\n\n            return this;\n        },\n\n        /**\n         * Update the value on individual property changes\n         */\n        updateValue: function () {\n            this.value({\n                margin: {\n                    top: this.marginTop(),\n                    right: this.marginRight(),\n                    bottom: this.marginBottom(),\n                    left: this.marginLeft()\n                },\n                padding: {\n                    top: this.paddingTop(),\n                    right: this.paddingRight(),\n                    bottom: this.paddingBottom(),\n                    left: this.paddingLeft()\n                }\n            });\n        },\n\n        /**\n         * On set of the initial value update our individual observables\n         *\n         * @returns {exports}\n         */\n        setInitialValue: function () {\n            this._super();\n            this._updateObservables(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * On update of the value property update our individual observables, the data provider can have data\n         * set on it after the initial construction, this ensures we translate our values\n         *\n         * @returns {exports}\n         */\n        onUpdate: function () {\n            this._super();\n            this._updateObservables(this.value());\n\n            return this;\n        },\n\n        /**\n         * Update the observable properties\n         *\n         * @param {Number} value\n         * @private\n         */\n        _updateObservables: function (value) {\n            if (value && _.isString(value)) {\n                value = JSON.parse(value);\n            }\n\n            if (value && _.isObject(value)) {\n                _.each(value, function (attributeData, attributeType) {\n                    _.each(attributeData, function (attributeValue, attributeDirection) {\n                        if (attributeValue !== defaultValue) {\n                            this[attributeType + attributeDirection.capitalize()](attributeValue);\n                        }\n                    }, this);\n                }, this);\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/conditional-disable-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var setDisabledSetting = {\n        defaults: {\n            disabledValues: []\n        },\n\n        /**\n         * Set the field as disabled when it's empty or is equal to a value within disabledValues\n         *\n         * @param {Array} value\n         */\n        setDisabled: function (value) {\n            if (_.indexOf(_.values(this.disabledValues), value) !== -1) {\n                this.disable();\n            } else {\n                this.enable();\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(setDisabledSetting);\n    };\n});\n","Magento_PageBuilder/js/form/element/condition-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/form/element/visual-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.showRelatedElement(this.value());\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super();\n\n            this.options().forEach(function (option) {\n                this.observe(option.value + 'Visible');\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        onUpdate: function (value) {\n            this.showRelatedElement(value);\n\n            return this._super();\n        },\n\n        /**\n         * Sets exported property, linked with visibility of the element, defined as option\n         *\n         * @param {String} value\n         * @returns {Object} Chainable\n         */\n        showRelatedElement: function (value) {\n            this[value + 'Visible'](true);\n            this.options().forEach(function (option) {\n                if (value !== option.value) {\n                    this[option.value + 'Visible'](false);\n                }\n            }.bind(this));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/visual-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            noticeMessage: '',\n            listens: {\n                value: 'setNoticeMessage'\n            }\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('noticeMessage');\n\n            return this;\n        },\n\n        /**\n         * Parses incoming options, considers options with undefined value property\n         *     as caption\n         *\n         * @param  {Array} nodes\n         * @param {Object} captionValue\n         * @return {Object} captionValue\n         */\n        parseOptions: function (nodes, captionValue) {\n            var caption,\n                value;\n\n            nodes = _.map(nodes, function (node) {\n                value = node.value;\n\n                if ((value === null || value === captionValue) && _.isUndefined(caption)) {\n                    caption = node.label;\n                }\n\n                return node;\n            });\n\n            return {\n                options: _.compact(nodes),\n                caption: _.isString(caption) ? caption : false\n            };\n        },\n\n        /**\n         * Recursively set to object item like value and item.value like key.\n         *\n         * @param {Array} data\n         * @param {Object} result\n         * @returns {Object}\n         */\n        indexOptions: function (data, result) {\n            var value;\n\n            result = result || {};\n\n            data.forEach(function (item) {\n                value = item.value;\n\n                if (Array.isArray(value)) {\n                    this.indexOptions(value, result);\n                } else {\n                    result[value] = item;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * Sets 'data' to 'options' observable array, if instance has\n         * 'customEntry' property set to true, calls 'setHidden' method\n         *  passing !options.length as a parameter\n         *\n         * @param {Array} data\n         * @returns {Object} Chainable\n         */\n        setOptions: function (data) {\n            var captionValue = this.captionValue || '',\n                result = this.parseOptions(data, captionValue),\n                isVisible;\n\n            this.indexedOptions = this.indexOptions(result.options);\n\n            this.options(result.options);\n\n            if (!this.caption()) {\n                this.caption(result.caption);\n            }\n\n            if (this.customEntry) {\n                isVisible = !!result.options.length;\n\n                this.setVisible(isVisible);\n                this.toggleInput(!isVisible);\n            }\n\n            return this;\n        },\n\n        /**\n         * Set the notice message on value change\n         *\n         * @param {any} value\n         * @returns {exports}\n         */\n        setNoticeMessage: function (value) {\n            var noticeMessage = '',\n                selectedOption = _.find(this.options(), function (option) {\n                    return option.value === value;\n                });\n\n            if (selectedOption && typeof selectedOption.noticeMessage !== 'undefined') {\n                noticeMessage = selectedOption.noticeMessage;\n            }\n\n            this.noticeMessage(noticeMessage);\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/image-uploader',\n    'Magento_PageBuilder/js/resource/resize-observer/ResizeObserver',\n    'Magento_PageBuilder/js/events',\n    'mage/translate'\n], function ($, _, uiRegistry, Uploader, ResizeObserver, events, $t) {\n    'use strict';\n\n    var initializedOnce = false;\n\n    return Uploader.extend({\n        defaults: {\n            $uploadArea: null,\n            isShowImageUploadInstructions: true,\n            isShowImageUploadOptions: false,\n            visibleControls: true,\n            classes: {\n                dragging: 'dragging',\n                draggingInside: 'dragging-inside',\n                draggingOutside: 'dragging-outside'\n            },\n            // listed in ascending order\n            elementWidthModifierClasses: {\n                '_micro-ui': {\n                    maxWidth: 130\n                },\n                '_compact-ui': {\n                    minWidth: 131,\n                    maxWidth: 440\n                }\n            },\n            translations: {\n                allowedFileTypes: $t('Allowed file types'),\n                dragImageHere: $t('Drag image here'),\n                dropHere: $t('Drop here'),\n                maximumFileSize: $t('Maximum file size'),\n                selectFromGallery: $t('Select from Gallery'),\n                or: $t('or'),\n                uploadImage: $t('Upload Image'),\n                uploadNewImage: $t('Upload New Image')\n            },\n            tracks: {\n                visibleControls: true\n            }\n        },\n\n        /**\n         * Bind drag events to highlight/unhighlight dropzones\n         * {@inheritDoc}\n         */\n        initialize: function () {\n            var $document = $(document);\n\n            this._super();\n\n            events.on('image:' + this.id + ':assignAfter', this.onAssignedFile.bind(this));\n\n            // bind dropzone highlighting using event delegation only once\n            if (!initializedOnce) {\n                // dropzone highlighting\n                $document.on('dragover', this.highlightDropzone.bind(this));\n\n                // dropzone unhighlighting\n                $document.on('dragend dragleave mouseup', this.unhighlightDropzone.bind(this));\n\n                initializedOnce = true;\n            }\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        initUploader: function (fileInput) {\n            this._super(fileInput);\n            this.$uploadArea = $(this.$fileInput).closest('.pagebuilder-image-empty-preview');\n            new ResizeObserver(this.updateResponsiveClasses.bind(this)).observe(this.$uploadArea.get(0));\n        },\n\n        /**\n         * Checks if provided file is allowed to be uploaded.\n         * {@inheritDoc}\n         */\n        isFileAllowed: function () {\n            var result = this._super(),\n                allowedExtensions = this.getAllowedFileExtensionsInCommaDelimitedFormat();\n\n            if (!result.passed && result.rule === 'validate-file-type') {\n                result.message += ' ' + this.translations.allowedFileTypes + ': ' + allowedExtensions + '.';\n            }\n\n            return result;\n        },\n\n        /**\n         * Remove draggable classes from dropzones\n         * {@inheritDoc}\n         */\n        onBeforeFileUpload: function () {\n            this.removeDraggableClassesFromDropzones();\n            this._super();\n        },\n\n        /**\n         * Add/remove CSS classes to $dropzone element to provide UI feedback\n         *\n         * @param {jQuery.event} e\n         */\n        highlightDropzone: function (e) {\n            var $dropzone = $(e.target).closest(this.dropZone),\n                $otherDropzones = $(this.dropZone).not($dropzone),\n                isInsideDropzone = !!$dropzone.length;\n\n            if (isInsideDropzone) {\n                $dropzone\n                  .removeClass(this.classes.draggingOutside)\n                  .addClass([this.classes.dragging, this.classes.draggingInside].join(' '));\n            }\n\n            $otherDropzones\n              .removeClass(this.classes.draggingInside)\n              .addClass([this.classes.dragging, this.classes.draggingOutside].join(' '));\n        },\n\n        /**\n         * Remove all UI styling from dropzone\n         *\n         * @param {jQuery.event} e\n         */\n        unhighlightDropzone: function (e) {\n            var isMouseReleased = e.type === 'mouseup' || e.type === 'dragend',\n                isActuallyLeavingThePage = e.type === 'dragleave' && (e.clientX === 0 || e.clientY === 0);\n\n            if (!isMouseReleased && !isActuallyLeavingThePage) {\n                return;\n            }\n\n            this.removeDraggableClassesFromDropzones();\n        },\n\n        /**\n         * Remove draggable CSS classes from dropzone elements\n         */\n        removeDraggableClassesFromDropzones: function () {\n            var $dropzones = $(this.dropZone);\n\n            $dropzones\n                .removeClass([\n                    this.classes.dragging,\n                    this.classes.draggingInside,\n                    this.classes.draggingOutside\n                ].join(' '));\n        },\n\n        /**\n         * Trigger image:uploadAfter event to be handled by PageBuilder image component\n         * {@inheritDoc}\n         */\n        addFile: function (file) {\n            this._super();\n\n            events.trigger('image:' + this.id + ':uploadAfter', [file]);\n\n            return this;\n        },\n\n        /**\n         * Trigger image:deleteFileAfter event to be handled by PageBuilder image component\n         * {inheritDoc}\n         */\n        clear: function () {\n            this._super();\n\n            events.trigger('image:' + this.id + ':deleteFileAfter');\n\n            return this;\n        },\n\n        /**\n         * Propagate file changes through all image uploaders sharing the same id\n         *\n         * @param {Object} file\n         */\n        onAssignedFile: function (file) {\n            this.value([file]);\n        },\n\n        /**\n         * Adds the appropriate ui state class to the upload control area based on the current rendered size\n         */\n        updateResponsiveClasses: function () {\n            var classesToAdd = [],\n                classConfig,\n                elementWidth = this.$uploadArea.width(),\n                modifierClass;\n\n            if (!this.$uploadArea.is(':visible')) {\n                return;\n            }\n\n            this.$uploadArea.removeClass(Object.keys(this.elementWidthModifierClasses).join(' '));\n\n            for (modifierClass in this.elementWidthModifierClasses) {\n                if (!this.elementWidthModifierClasses.hasOwnProperty(modifierClass)) {\n                    // jscs:disable disallowKeywords\n                    continue;\n                    // jscs:enable disallowKeywords\n                }\n\n                classConfig = this.elementWidthModifierClasses[modifierClass];\n\n                if (classConfig.minWidth && classConfig.maxWidth &&\n                    (classConfig.minWidth <= elementWidth && elementWidth <= classConfig.maxWidth) ||\n                    classConfig.minWidth && !classConfig.maxWidth && classConfig.minWidth <= elementWidth ||\n                    classConfig.maxWidth && !classConfig.minWidth && elementWidth <= classConfig.maxWidth\n                ) {\n                    classesToAdd.push(modifierClass);\n                }\n            }\n\n            if (classesToAdd.length) {\n                this.$uploadArea.addClass(classesToAdd.join(' '));\n            }\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        hasData: function () {\n            // Some of the components automatically add an empty object if the value is unset.\n            return this._super() && !$.isEmptyObject(this.value()[0]);\n        },\n\n        /**\n         * Stop event to prevent it from reaching any objects other than the current object.\n         *\n         * @param {Object} uploader\n         * @param {Event} event\n         * @returns {Boolean}\n         */\n        stopEvent: function (uploader, event) {\n            event.stopPropagation();\n\n            return true;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/validator-rules-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/lib/validation/utils'\n], function ($, _, utils) {\n    'use strict';\n\n    /**\n     * Validate the number is between the min and max provided\n     *\n     * @param {Number} value\n     * @param {Number} min\n     * @param {Number} max\n     * @return {Boolean}\n     */\n    function validateNumberBetween(value, min, max) {\n        var numValue;\n\n        if ($.mage.isEmptyNoTrim(value)) {\n            return true;\n        }\n\n        numValue = $.mage.parseNumber(value);\n\n        if (isNaN(numValue)) {\n            return false;\n        }\n\n        return $.mage.isBetween(numValue, min, max);\n    }\n\n    /**\n     * Validate that string is url\n     * @param {String} href\n     * @return {Boolean}\n     */\n    function validateIsUrl(href) {\n        return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(href);//eslint-disable-line max-len\n    }\n\n    /**\n     * Validate that string has an anchor tag\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateWysiwygHasAnchorTags(str) {\n        return (/<a[\\s]+([^>]+)>|<a>|<\\/a>/igm).test(str);\n    }\n\n    /**\n     * Validate that string has a widget\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateWysiwygHasWidget(str) {\n        return (/\\{\\{widget(.*?)\\}\\}/ig).test(str);\n    }\n\n    /**\n     * Validate that string is a proper css-class\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateCssClass(str) {\n        return (/^[a-zA-Z _\\-\\d]+$/i).test(str);\n    }\n\n    /**\n     * Validate message field and url field anchor tag is used exclusively by one field\n     * @param {String} message\n     * @param {Object} url\n     * @return {Boolean}\n     */\n    function validateOneAnchorTagField(message, url) {\n        return !(validateWysiwygHasAnchorTags(message) &&\n            ['page', 'product', 'category', 'default'].indexOf(url.type) !== -1 &&\n            url[url.type] &&\n            url[url.type].length > 0);\n    }\n\n    /**\n     * Validate message field and url field html standards, nested widget\n     * @param {String} message\n     * @param {Object} url\n     * @return {Boolean}\n     */\n    function validateNestedWidgetElement(message, url) {\n        return !(validateWysiwygHasWidget(message) &&\n            ['page', 'product', 'category', 'default'].indexOf(url.type) !== -1 &&\n            url[url.type] &&\n            url[url.type].length > 0);\n    }\n\n    /**\n     * Validate a field with an expected data value of type object, like margins_and_padding field\n     * @param {Function} validator\n     * @param {String} ruleName\n     */\n    function validateObjectField(validator, ruleName) {\n        var rule = validator.getRule(ruleName);\n\n        validator.addRule(\n            ruleName,\n            function (value, params) {\n                var allNumbers = true,\n                    handler = rule.handler.bind(this);\n\n                if (typeof value !== 'object') {\n                    return handler(value, params);\n                }\n\n                _.flatten(_.map(value, _.values)).forEach(function (val) {\n                    if (!handler(val, params)) {\n                        allNumbers = false;\n\n                        return allNumbers;\n                    }\n                });\n\n                return allNumbers;\n            },\n            $.mage.__(rule.message)\n        );\n    }\n\n    /**\n     * Validate calc value.\n     *\n     * @param {String} value\n     * @returns {Boolean}\n     */\n    function validateCalc(value) {\n        var el = document.createElement('div'),\n            style = el.style;\n\n        if (!value.trim().length) {\n            return true;\n        }\n\n        style.width = 'calc(' + value + ')';\n\n        return !!style.width.length;\n    }\n\n    return function (validator) {\n        var requiredInputRule = validator.getRule('required-entry');\n\n        validator.addRule(\n            'required-entry-location-name',\n            requiredInputRule.handler,\n            $.mage.__('Please enter the location name.')\n        );\n\n        validator.addRule(\n            'required-entry-latitude',\n            requiredInputRule.handler,\n            $.mage.__('Enter latitude')\n        );\n\n        validator.addRule(\n            'required-entry-longitude',\n            requiredInputRule.handler,\n            $.mage.__('Enter longitude')\n        );\n\n        validator.addRule(\n            'validate-latitude',\n            function (value) {\n                return validateNumberBetween(value, -85, 85);\n            },\n            $.mage.__('Please enter a number between -85 and 85')\n        );\n\n        validator.addRule(\n            'validate-longitude',\n            function (value) {\n                return validateNumberBetween(value, -180, 180);\n            },\n            $.mage.__('Please enter a number between -180 and 180')\n        );\n\n        validator.addRule(\n            'validate-video-url',\n            function (href) {\n                if (utils.isEmptyNoTrim(href)) {\n                    return true;\n                }\n\n                href = (href || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return validateIsUrl(href) && (href.match(/youtube\\.com|youtu\\.be/) || href.match(/vimeo\\.com/));\n            },\n            $.mage.__('Please enter a valid video URL.')\n        );\n\n        validator.addRule(\n            'validate-video-source',\n            function (href) {\n                if (utils.isEmptyNoTrim(href)) {\n                    return true;\n                }\n\n                href = (href || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return validateIsUrl(href) && (\n                    href.match(/youtube\\.com|youtu\\.be/) ||\n                    href.match(/vimeo\\.com/) ||\n                    href.match(/\\.(mp4|ogv|webm)(?!\\w)/)\n                );\n            },\n            $.mage.__('Please enter a valid video URL. Valid URLs have a video file extension (.mp4, .webm, .ogv) or links to videos on YouTube or Vimeo.')//eslint-disable-line max-len\n        );\n\n        validator.addRule(\n            'validate-css-class',\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                return validateCssClass(value);\n            },\n            $.mage.__('Please enter a valid CSS class.')\n        );\n\n        validator.addRule(\n            'required-entry',\n            function (value) {\n                var allFilled;\n\n                // Validation only for margins and paddings\n                if (typeof value === 'object' && !!(value.padding || value.margin)) {\n                    allFilled = true;\n\n                    _.flatten(_.map(value, _.values)).forEach(function (val) {\n                        if (utils.isEmpty(val)) {\n                            allFilled = false;\n\n                            return allFilled;\n                        }\n                    });\n\n                    return allFilled;\n                }\n\n                return requiredInputRule.handler(value);\n            },\n            $.mage.__(requiredInputRule.message)\n        );\n\n        validator.addRule(\n            'validate-message-no-link',\n            function (url, message) {\n                return validateOneAnchorTagField(message, url);\n            },\n            $.mage.__('Adding link in both content and outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-no-url',\n            function (message, url) {\n                return validateOneAnchorTagField(message, url);\n            },\n            $.mage.__('Adding link in both content and outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-message-no-widget',\n            function (url, message) {\n                return validateNestedWidgetElement(message, url);\n            },\n            $.mage.__('Adding link in outer element and widget in content is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-no-widget',\n            function (message, url) {\n                return validateNestedWidgetElement(message, url);\n            },\n            $.mage.__('Adding widget in content and link in outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-calc',\n            function (value) {\n                return validateCalc(value);\n            },\n            $.mage.__('Please enter a valid number or calculation: Valid numbers must have an extension (px, %, pt, vh). Calculations must have white space around the + and - operators and cannot divide by zero.')//eslint-disable-line max-len\n        );\n\n        validator.addRule(\n            'validate-grid-size',\n            function (value, params, additionalParams) {\n                if (value < additionalParams.non_empty_column_count) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Grid size cannot be smaller than the current total amount of columns, minus any empty columns.')\n        );\n\n        validator.addRule(\n            'validate-max-grid-size',\n            function (value, params, additionalParams) {\n                if (value > additionalParams.max_grid_size) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a value less than or equal to the Maximum Column Grid Size configuration.')\n        );\n\n        validateObjectField(validator, 'validate-number');\n        validateObjectField(validator, 'less-than-equals-to');\n        validateObjectField(validator, 'greater-than-equals-to');\n\n        return validator;\n    };\n});\n","Magento_PageBuilder/js/form/element/grid-size.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        validate: function () {\n            var externalFormSourceData = this.requestModule('index=' + this.ns)().source.data;\n\n            this.validationParams = {\n                'non_empty_column_count': externalFormSourceData.non_empty_column_count,\n                'max_grid_size': externalFormSourceData.max_grid_size\n            };\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/block-chooser.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiLayout',\n    'uiElement',\n    'Magento_PageBuilder/js/config',\n    'mage/translate',\n    'mage/utils/objects'\n], function ($, layout, Element, Config, $t, objectUtils) {\n    'use strict';\n\n    return Element.extend({\n        id: null,\n        meta: {},\n        errorMessage: null,\n        displayMetadata: true,\n        messages: {\n            UNKOWN_ERROR: $t('Sorry, there was an error getting requested content. ' +\n                'Please contact the store owner.'),\n            UNKNOWN_SELECTION: $t('The currently selected block does not exist.')\n        },\n        defaults: {\n            template: 'Magento_PageBuilder/form/element/block-chooser',\n            requestParameter: null,\n            dataUrlConfigPath: null,\n            modalName: null,\n            buttonComponentConfig: {\n                title: '${ $.buttonTitle }',\n                component: 'Magento_Ui/js/form/components/button',\n                actions: [{\n                    targetName: '${ $.modalName }',\n                    actionName: 'openModal'\n                }]\n            },\n            requestData: {\n                method: 'POST',\n                data: {\n                    'form_key': window.FORM_KEY\n                }\n            },\n            listens: {\n                id: 'updateFromServer'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super()\n                .observe('id meta errorMessage displayMetadata');\n        },\n\n        /**\n         * Updates the block data from the server\n         *\n         * @returns void\n         */\n        updateFromServer: function () {\n            var requestData = $.extend(true, {}, this.requestData);\n\n            // The component hasn't be configured yet. Nothing to do.\n            if (!this.id().length || !this.requestParameter || !this.dataUrlConfigPath) {\n                this.meta({});\n\n                return;\n            }\n\n            requestData.data[this.requestParameter] = this.id();\n            $('body').trigger('processStart');\n\n            $.ajax(objectUtils.nested(Config.getConfig(), this.dataUrlConfigPath), requestData)\n                .always(function () {\n                    $('body').trigger('processStop');\n                    this.errorMessage(null);\n                }.bind(this))\n                .done(function (response) {\n                    if (typeof response !== 'object' || response.error) {\n                        this.meta({});\n                        this.errorMessage(this.messages.UNKOWN_ERROR);\n\n                        return;\n                    } else if (Array.isArray(response)) {\n                        this.meta({});\n                        this.errorMessage(this.messages.UNKNOWN_SELECTION);\n\n                        return;\n                    }\n\n                    this.meta(response);\n                }.bind(this))\n                .fail(function () {\n                    this.meta({});\n                    this.errorMessage(this.messages.UNKOWN_ERROR);\n                }.bind(this));\n        },\n\n        /**\n         * Creates the button component for rendering\n         *\n         * @returns {Object} The button component\n         */\n        getButton: function () {\n            var elementConfig = this.buttonComponentConfig;\n\n            elementConfig.name = this.name + '_button';\n            layout([elementConfig]);\n\n            return this.requestModule(elementConfig.name);\n        },\n\n        /**\n         * Determines the status label for the currently loaded block\n         *\n         * @returns {String}\n         */\n        getStatusLabel: function () {\n            return this.meta()['is_active'] === '1' ? $t('Active') : $t('Inactive');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/product-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'Magento_PageBuilder/js/form/provider/conditions-data-processor',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, $, $t, conditionsDataProcessor, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            conditionOption: '',\n            conditionValue: '',\n            formData: {},\n            totalProductCount: 0,\n            totalDisabledProducts: 0,\n            totalNotVisibleProducts: 0,\n            previousConditions: false,\n            listens: {\n                conditionOption: 'updateProductTotals',\n                conditionValue: 'updateProductTotals',\n                '${ $.provider }:data.modalClosed': 'abortRunningRequest'\n            },\n            imports: {\n                formData: '${ $.provider }:data'\n            },\n            links: {\n                value: false\n            },\n            url: null,\n            valuePlaceholder: $t('of %1 total'),\n            disabledPlaceholder: $t('%1 disabled'),\n            notVisiblePlaceholder: $t('%1 not visible'),\n            showSpinner: true,\n            loading: false,\n            jqXHR: null\n        },\n\n        /**\n         * Abort running Ajax request\n         */\n        abortRunningRequest: function () {\n            if (this.jqXHR && this.jqXHR.readyState !== 4) {\n                this.jqXHR.abort();\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('value totalProductCount totalDisabledProducts totalNotVisibleProducts loading');\n        },\n\n        /**\n         * If we haven't aborted the request, continue and display the error\n         *\n         * @param {Object} jqXHR\n         */\n        callSuperError: function (jqXHR) {\n            // eslint-disable-next-line jquery-no-bind-unbind\n            var superError = $.ajaxSettings.error.bind(window, jqXHR);\n\n            superError();\n        },\n\n        /**\n         * Update product count.\n         */\n        updateProductTotals: _.debounce(function () {\n            var totalText,\n                negativeTotals = [];\n\n            if (!this.conditionOption || _.isEmpty(this.formData)) {\n                return;\n            }\n\n            if (this.conditionOption === 'category_ids' && typeof this.formData['category_ids'] !== 'string') {\n                this.formData['category_ids'] = '';\n            }\n\n            _.extend(this.formData, this.conditionValue);\n            conditionsDataProcessor(this.formData, this.conditionOption + '_source');\n\n            // Store the previous conditions so we don't update the totals when nothing has changed\n            if (this.previousConditions === this.formData['conditions_encoded']) {\n                return;\n            }\n            this.previousConditions = this.formData['conditions_encoded'];\n\n            this.loading(true);\n            this.abortRunningRequest();\n            this.jqXHR = $.ajax({\n                url: this.url,\n                method: 'POST',\n                data: {\n                    conditionValue: this.formData['conditions_encoded']\n                },\n                error: function (jqXHR) {\n                    if (jqXHR.statusText !== 'abort') {\n                        this.callSuperError(jqXHR);\n                    }\n                }.bind(this)\n            }).done(function (response) {\n                this.totalProductCount(parseInt(response.total, 10));\n                this.totalDisabledProducts(parseInt(response.disabled, 10));\n                this.totalNotVisibleProducts(parseInt(response.notVisible, 10));\n                totalText = this.valuePlaceholder\n                    .replace('%1', parseInt(response.total, 10));\n\n                if (parseInt(response.disabled, 10) > 0) {\n                    negativeTotals.push(this.disabledPlaceholder.replace('%1', parseInt(response.disabled, 10)));\n                }\n\n                if (parseInt(response.notVisible, 10) > 0) {\n                    negativeTotals.push(this.notVisiblePlaceholder.replace('%1', parseInt(response.notVisible, 10)));\n                }\n\n                if (negativeTotals.length > 0) {\n                    totalText += ' (' + negativeTotals.join(', ') + ')';\n                }\n\n                this.value(totalText);\n                this.loading(false);\n            }.bind(this)).fail(function () {\n                if (this.jqXHR.statusText !== 'abort') {\n                    this.value($t('An unknown error occurred. Please try again.'));\n                }\n                this.loading(false);\n            }.bind(this));\n        }, 10)\n    });\n});\n","Magento_PageBuilder/js/form/element/page-ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Get path to current option\n         *\n         * @param {Object} data - option data\n         * @returns {String} path\n         */\n        getPath: function (data) {\n            var path = '';\n\n            if (this.renderPath) {\n                path = data.identifier || path;\n            }\n\n            return path;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/wysiwyg.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/element/wysiwyg',\n    'mage/translate',\n    'Magento_PageBuilder/js/events',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'Magento_PageBuilder/js/page-builder',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, _, Wysiwyg, $t, events, domObserver, PageBuilder) {\n    'use strict';\n\n    /**\n     * Extend the original WYSIWYG with added PageBuilder functionality\n     */\n    return Wysiwyg.extend({\n        defaults: {\n            transition: false,\n            transitionOut: false,\n            elementSelector: '> textarea',\n            stageSelector: '.pagebuilder-stage-wrapper',\n            fieldsetSelector: 'fieldset.admin__fieldset',\n            overlaySelector: '.pagebuilder-wysiwyg-overlay',\n            overlayMouseover: false,\n            pageBuilder: false,\n            visiblePageBuilder: false,\n            isComponentInitialized: false,\n            wysiwygConfigData: {\n                isFullScreen: false\n            },\n            pageBuilderEditButtonText: $t('Edit with Page Builder'),\n            isWithinModal: false,\n            modal: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n\n            if (!this.wysiwygConfigData()['pagebuilder_button'] ||\n                this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                this.initPageBuilder();\n            }\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super()\n                .observe('isComponentInitialized visiblePageBuilder wysiwygConfigData loading transition ' +\n                    'transitionOut overlayMouseover');\n\n            return this;\n        },\n\n        /**\n         * Handle button click, init the Page Builder application\n         */\n        pageBuilderEditButtonClick: function (context, event) {\n            this.determineIfWithinModal(event.currentTarget);\n            this.transition(false);\n\n            if (!this.isComponentInitialized()) {\n                this.disableDomObserver($(event.currentTarget).parent()[0]);\n            }\n\n            this.initPageBuilder();\n            this.toggleFullScreen();\n        },\n\n        /**\n         * Init Page Builder\n         */\n        initPageBuilder: function () {\n            if (!this.isComponentInitialized()) {\n                this.loading(true);\n                this.pageBuilder = new PageBuilder(\n                  this.wysiwygConfigData(),\n                  this.initialValue\n                );\n                events.trigger('pagebuilder:register', {\n                    ns: this.ns,\n                    instance: this.pageBuilder\n                });\n                this.initPageBuilderListeners();\n                this.isComponentInitialized(true);\n\n                // Disable the domObserver for the entire stage\n                $.async({\n                    component: this,\n                    selector: this.stageSelector\n                }, this.disableDomObserver.bind(this));\n\n                if (!this.wysiwygConfigData()['pagebuilder_button'] ||\n                    this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.visiblePageBuilder(true);\n                }\n            }\n        },\n\n        /**\n         * Disable the domObserver on the PageBuilder stage to improve performance\n         *\n         * @param {HTMLElement} node\n         */\n        disableDomObserver: function (node) {\n            this.determineIfWithinModal(node);\n            domObserver.disableNode(node);\n            domObserver.disableNode($(node).parents(this.fieldsetSelector)[0]);\n        },\n\n        /**\n         * Changes tabindex and content editable on stage elements\n         */\n        toggleFocusableElements: function () {\n            var pageBuilderSelector = '#' + this.pageBuilder.id,\n                editable = $(pageBuilderSelector).find('[contenteditable]:not(.mceNonEditable)'),\n                focusableSelector = ' :focusable:not(' + this.overlaySelector + ')',\n                mediaSelector = pageBuilderSelector + ' iframe,' + pageBuilderSelector + ' video',\n                tabIndexValue = this.pageBuilder.isFullScreen() ? '0' : '-1',\n                editableValue = this.pageBuilder.isFullScreen();\n\n            editable.attr('contenteditable', editableValue);\n            $(pageBuilderSelector + focusableSelector).attr('tabindex', tabIndexValue);\n            $(mediaSelector).attr('tabindex', tabIndexValue);\n        },\n\n        /**\n         * Determine if the current instance is within a modal\n         *\n         * @param {HTMLElement} element\n         */\n        determineIfWithinModal: function (element) {\n            var modalInnerWrap = $(element).parents('.modal-inner-wrap');\n\n            // Determine if the Page Builder instance is within a modal\n            this.isWithinModal = modalInnerWrap.length === 1;\n\n            if (this.isWithinModal) {\n                this.modal = modalInnerWrap;\n            }\n        },\n\n        /**\n         * Press Enter key on Overlay\n         */\n        onOverlayKeyDown: function (context, event) {\n            if (event.which === 13 || event.keyCode === 13) {\n                this.pageBuilderEditButtonClick(context, event);\n            }\n\n            return true;\n        },\n\n        /**\n         * Toggle Page Builder full screen mode\n         */\n        toggleFullScreen: function () {\n            events.trigger('stage:' + this.pageBuilder.id + ':toggleFullscreen', {\n                animate: !!this.wysiwygConfigData()['pagebuilder_content_snapshot']\n            });\n        },\n\n        /**\n         * Init various listeners on the stage\n         */\n        initPageBuilderListeners: function () {\n            var id = this.pageBuilder.id,\n                renderDeferred = $.Deferred(),\n                fullScreenDeferred = $.Deferred(),\n                rendered = false;\n\n            events.on('stage:' + id + ':readyAfter', function () {\n                this.loading(false);\n            }.bind(this));\n\n            events.on('stage:' + id + ':renderAfter', function () {\n                renderDeferred.resolve();\n                rendered = true;\n            });\n\n            events.on('stage:' + id + ':masterFormatRenderAfter', function (args) {\n                this.value(args.value);\n\n                if (this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.toggleFocusableElements();\n                }\n            }.bind(this));\n\n            events.on('stage:' + id + ':fullScreenModeChangeAfter', function (args) {\n                if (!args.fullScreen) {\n                    if (this.isWithinModal && this.modal) {\n                        _.delay(function () {\n                            this.modal.css({\n                                transform: '',\n                                transition: ''\n                            });\n                        }.bind(this), 350);\n                    }\n\n                    if (this.wysiwygConfigData()['pagebuilder_button'] &&\n                        !this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                        // Force full screen mode whilst the animation occurs\n                        this.transitionOut(true);\n                        // Trigger animation out\n                        this.transition(false);\n\n                        // Reset the transition out class and hide the stage\n                        _.delay(function () {\n                            this.transitionOut(false);\n                            this.visiblePageBuilder(false);\n                        }.bind(this), 185);\n                    }\n                } else if (args.fullScreen) {\n                    if (this.isWithinModal && this.modal) {\n                        this.modal.css({\n                            transform: 'none',\n                            transition: 'none'\n                        });\n                    }\n\n                    if (this.wysiwygConfigData()['pagebuilder_button'] &&\n                        !this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                        this.visiblePageBuilder(true);\n\n                        fullScreenDeferred.resolve();\n\n                        /* eslint-disable max-depth */\n                        // If the stage has already rendered once we don't need to wait until animating the stage in\n                        if (rendered) {\n                            _.defer(function () {\n                                this.transition(true);\n                            }.bind(this));\n                        }\n                        /* eslint-enable max-depth */\n                    }\n                }\n\n                if (this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.toggleFocusableElements();\n                }\n            }.bind(this));\n\n            // Wait until the stage is rendered and full screen mode is activated\n            $.when(renderDeferred, fullScreenDeferred).done(function () {\n                _.defer(function () {\n                    this.transition(true);\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this.pageBuilder && this.pageBuilder.destroy();\n            this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/conditions-loader.js":"define([\n    'jquery',\n    'Magento_Rule/rules',\n    'uiRegistry',\n    'mage/utils/objects'\n], function ($, RulesForm, uiRegistry, objectUtils) {\n    'use strict';\n\n    return function (config, conditionsFormPlaceholder) {\n        var $conditionsFormPlaceholder = $(conditionsFormPlaceholder),\n            attributeData = uiRegistry.get(config.formNamespace + '.' + config.formNamespace).source.data,\n            conditions = objectUtils.nested(attributeData, config.attribute) || '[]';\n\n        $('body').trigger('processStart');\n\n        $.ajax(config.componentUrl, {\n            method: 'POST',\n            data: {\n                conditions: conditions\n            }\n        })\n        .done(function (response) {\n            $conditionsFormPlaceholder.html(response);\n            window[config.jsObjectName] = new RulesForm(config.jsObjectName, config.childComponentUrl);\n            $('body').trigger('processStop');\n        });\n    };\n});\n","Magento_PageBuilder/js/property/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Read paddings from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      return {\n        padding: {\n          left: element.style.paddingLeft,\n          top: element.style.paddingTop,\n          right: element.style.paddingRight,\n          bottom: element.style.paddingBottom\n        }\n      };\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/property/link.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Link = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Link() {\n      this.regexpByLinkType = {\n        category: new RegExp(/id_path=['\"]category\\/(\\d+)/),\n        product: new RegExp(/id_path=['\"]product\\/(\\d+)/),\n        page: new RegExp(/page_id=['\"](\\d+)/)\n      };\n    }\n\n    var _proto = Link.prototype;\n\n    /**\n     * Read link from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      var _ref;\n\n      var href = element.getAttribute(\"href\");\n      var attributeLinkType = element.getAttribute(\"data-link-type\");\n\n      if (typeof href === \"string\" && attributeLinkType !== \"default\") {\n        href = this.getIdFromWidgetSyntax(href, this.regexpByLinkType[attributeLinkType]);\n      }\n\n      return _ref = {}, _ref[attributeLinkType] = href, _ref.setting = element.getAttribute(\"target\") === \"_blank\", _ref.type = attributeLinkType, _ref;\n    }\n    /**\n     * Returns link value from widget string\n     *\n     * @param {string} href\n     * @param {RegExp} regexp\n     * @return {string}\n     */\n    ;\n\n    _proto.getIdFromWidgetSyntax = function getIdFromWidgetSyntax(href, regexp) {\n      var attributeIdMatches = href.match(regexp);\n\n      if (!attributeIdMatches) {\n        return href;\n      }\n\n      return attributeIdMatches[1];\n    };\n\n    return Link;\n  }();\n\n  return Link;\n});\n//# sourceMappingURL=link.js.map","Magento_PageBuilder/js/property/property-reader-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PropertyReaderPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function PropertyReaderPool() {\n      this.propertyReaders = {};\n    }\n\n    var _proto = PropertyReaderPool.prototype;\n\n    /**\n     * Retrieve a property reader from the pool\n     *\n     * @param {string} name\n     * @returns {PropertyReaderInterface}\n     */\n    _proto.get = function get(name) {\n      return this.propertyReaders[name] !== undefined ? this.propertyReaders[name] : null;\n    }\n    /**\n     * Register a new property reader into the pool\n     *\n     * @param {string} name\n     * @param {PropertyReaderInterface} property\n     */\n    ;\n\n    _proto.register = function register(name, property) {\n      this.propertyReaders[name] = property;\n    };\n\n    return PropertyReaderPool;\n  }();\n\n  var _default = new PropertyReaderPool();\n\n  return Object.assign(_default, {\n    PropertyReaderPool: PropertyReaderPool\n  });\n});\n//# sourceMappingURL=property-reader-pool.js.map","Magento_PageBuilder/js/property/property-reader-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/property/property-reader-pool\"], function (_config, _loader, _propertyReaderPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of property reader pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var propertyReaders = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (appearance !== undefined && appearance.elements !== undefined) {\n        var elementName = void 0;\n\n        for (var _i2 = 0, _Object$keys2 = Object.keys(appearance.elements); _i2 < _Object$keys2.length; _i2++) {\n          elementName = _Object$keys2[_i2];\n          var element = appearance.elements[elementName];\n\n          if (element.style !== undefined) {\n            for (var _iterator = _createForOfIteratorHelperLoose(element.style), _step; !(_step = _iterator()).done;) {\n              var propertyConfig = _step.value;\n\n              if (propertyConfig.reader && propertyReaders.indexOf(propertyConfig.reader) === -1 && !_propertyReaderPool.get(propertyConfig.reader)) {\n                propertyReaders.push(propertyConfig.reader);\n              }\n            }\n          }\n\n          if (element.attributes !== undefined) {\n            for (var _iterator2 = _createForOfIteratorHelperLoose(element.attributes), _step2; !(_step2 = _iterator2()).done;) {\n              var attributeConfig = _step2.value;\n\n              if (attributeConfig.reader && propertyReaders.indexOf(attributeConfig.reader) === -1 && !_propertyReaderPool.get(attributeConfig.reader)) {\n                propertyReaders.push(attributeConfig.reader);\n              }\n            }\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(propertyReaders, function () {\n        for (var _len = arguments.length, loadedPropertyReaders = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedPropertyReaders[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < propertyReaders.length; i++) {\n          _propertyReaderPool.register(propertyReaders[i], new loadedPropertyReaders[i]());\n        }\n\n        resolve(_propertyReaderPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=property-reader-pool-factory.js.map","Magento_PageBuilder/js/property/style-property-reader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/string\"], function (_string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var StylePropertyReader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StylePropertyReader() {}\n\n    var _proto = StylePropertyReader.prototype;\n\n    /**\n     * Read style property from element\n     *\n     * @param {HTMLElement} element\n     * @param {string} source\n     * @returns {string | object}\n     */\n    _proto.read = function read(element, source) {\n      var camelCasedSource = (0, _string.fromSnakeToCamelCase)(source);\n      return element.style[camelCasedSource];\n    };\n\n    return StylePropertyReader;\n  }();\n\n  return StylePropertyReader;\n});\n//# sourceMappingURL=style-property-reader.js.map","Magento_PageBuilder/js/property/property-reader-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=property-reader-interface.js.map","Magento_PageBuilder/js/property/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Read margins from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      return {\n        margin: {\n          left: element.style.marginLeft,\n          top: element.style.marginTop,\n          right: element.style.marginRight,\n          bottom: element.style.marginBottom\n        }\n      };\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/property/attribute-reader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var AttributeReader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function AttributeReader() {}\n\n    var _proto = AttributeReader.prototype;\n\n    /**\n     * Read attribute from element\n     *\n     * @param {HTMLElement} element\n     * @param {string} source\n     * @returns {string | object}\n     */\n    _proto.read = function read(element, source) {\n      return element.getAttribute(source);\n    };\n\n    return AttributeReader;\n  }();\n\n  return AttributeReader;\n});\n//# sourceMappingURL=attribute-reader.js.map","Magento_PageBuilder/js/panel/menu.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\"], function (_knockout) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Menu = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Menu constructor\n     *\n     * @param id\n     * @param menu\n     * @param contentTypes\n     * @param stageId\n     */\n    function Menu(id, menu, contentTypes, stageId) {\n      if (contentTypes === void 0) {\n        contentTypes = [];\n      }\n\n      this.hidden = _knockout.observable(false);\n      this.id = _knockout.observable();\n      this.code = _knockout.observable(\"\");\n      this.label = _knockout.observable(\"\");\n      this.icon = _knockout.observable(\"\");\n      this.sort = _knockout.observable();\n      this.contentTypes = _knockout.observableArray([]);\n      this.active = _knockout.observable(false);\n      this.id(id);\n      this.code(menu.code);\n      this.label(menu.label);\n      this.icon(menu.icon);\n      this.sort(menu.sort);\n      this.contentTypes(contentTypes);\n      this.stageId = stageId;\n    }\n    /**\n     * Toggle the menu\n     */\n\n\n    var _proto = Menu.prototype;\n\n    _proto.toggle = function toggle() {\n      this.active(!this.active());\n    };\n\n    return Menu;\n  }();\n\n  return {\n    Menu: Menu\n  };\n});\n//# sourceMappingURL=menu.js.map","Magento_PageBuilder/js/panel/menu/content-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/drag-drop/matrix\"], function (_knockout, _matrix) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ContentType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {string} identifier\n     * @param {ContentTypeConfigInterface} config\n     * @param {string} stageId\n     */\n    function ContentType(identifier, config, stageId) {\n      this.droppable = true;\n      this.icon = _knockout.observable(\"\");\n      this.identifier = _knockout.observable(\"\");\n      this.label = _knockout.observable(\"\");\n      this.config = config;\n      this.identifier(identifier);\n      this.label(config.label);\n      this.icon(config.icon);\n      this.stageId = stageId;\n    }\n    /**\n     * Retrieve the config object\n     *\n     * @returns {ContentTypeConfigInterface}\n     */\n\n\n    var _proto = ContentType.prototype;\n\n    _proto.getConfig = function getConfig() {\n      return this.config;\n    }\n    /**\n     * Only connect to container sortable instances that the current content type is accepted into\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getDraggableOptions = function getDraggableOptions() {\n      return {\n        connectToSortable: (0, _matrix.getAllowedContainersClasses)(this.config.name, this.stageId)\n      };\n    };\n\n    return ContentType;\n  }();\n\n  return {\n    ContentType: ContentType\n  };\n});\n//# sourceMappingURL=content-type.js.map","Magento_PageBuilder/js/drag-drop/move-content-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\"], function (_knockout, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Move a content type to a new index, with the option to move to a new container\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {number} targetIndex\n   * @param {ContentTypeCollectionInterface} targetParent\n   */\n  function moveContentType(contentType, targetIndex, targetParent) {\n    if (targetParent === void 0) {\n      targetParent = null;\n    }\n\n    var sourceParent = contentType.parentContentType;\n    var sourceIndex = contentType.parentContentType.children().indexOf(contentType);\n    var sourceParentChildren = sourceParent.getChildren(); // Trigger our block move event\n\n    _events.trigger(\"contentType:moveBefore\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    _events.trigger(contentType.config.name + \":moveBefore\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    if (targetParent && sourceParent !== targetParent) {\n      contentType.parentContentType = targetParent; // Handle dragging between sortable elements\n\n      sourceParentChildren.splice(sourceIndex, 1);\n      targetParent.getChildren().splice(targetIndex, 0, contentType);\n    } else {\n      // Retrieve the children from the source parent\n      var children = _knockout.utils.unwrapObservable(sourceParentChildren); // Inform KO that this value is about to mutate\n\n\n      if (sourceParentChildren.valueWillMutate) {\n        sourceParentChildren.valueWillMutate();\n      } // Perform the mutation\n\n\n      children.splice(sourceIndex, 1);\n      children.splice(targetIndex, 0, contentType); // Inform KO that the mutation is complete\n\n      if (sourceParentChildren.valueHasMutated) {\n        sourceParentChildren.valueHasMutated();\n      }\n    } // Process any deferred bindings\n\n\n    if (_knockout.processAllDeferredBindingUpdates) {\n      _knockout.processAllDeferredBindingUpdates();\n    } // Trigger our content type move event\n\n\n    _events.trigger(\"contentType:moveAfter\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    _events.trigger(contentType.config.name + \":moveAfter\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n  }\n\n  return {\n    moveContentType: moveContentType\n  };\n});\n//# sourceMappingURL=move-content-type.js.map","Magento_PageBuilder/js/drag-drop/drop-indicators.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/create-stylesheet\", \"Magento_PageBuilder/js/drag-drop/matrix\"], function (_createStylesheet, _matrix) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var headDropIndicatorStyles;\n  /**\n   * Show the drop indicators for a specific content type\n   *\n   * We do this by creating a style sheet and injecting it into the head. It's dramatically quicker to allow the browsers\n   * CSS engine to display these for us than manually iterating through the DOM and applying a class to the elements.\n   *\n   * @param {string} contentType\n   * @param {string} stageId\n   * @returns {HTMLStyleElement}\n   */\n\n  function showDropIndicators(contentType, stageId) {\n    var acceptedContainers = (0, _matrix.getContainersFor)(contentType);\n\n    if (acceptedContainers.length > 0) {\n      var _ref;\n\n      var classNames = acceptedContainers.map(function (container) {\n        return \"#\" + stageId + \" .content-type-container.\" + container + \"-container > .pagebuilder-drop-indicator, \" + (\"#\" + stageId + \" .pagebuilder-content-type.type-container.empty-container > .content-type-container.\") + (container + \"-container:before\");\n      });\n      var styles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classNames.join(\", \")] = {\n        opacity: 1,\n        visibility: \"visible\"\n      }, _ref));\n      document.head.appendChild(styles);\n      headDropIndicatorStyles = styles;\n      return styles;\n    }\n  }\n  /**\n   * Hide the drop indicators\n   */\n\n\n  function hideDropIndicators() {\n    if (headDropIndicatorStyles) {\n      headDropIndicatorStyles.remove();\n      headDropIndicatorStyles = null;\n    }\n  }\n\n  return {\n    showDropIndicators: showDropIndicators,\n    hideDropIndicators: hideDropIndicators\n  };\n});\n//# sourceMappingURL=drop-indicators.js.map","Magento_PageBuilder/js/drag-drop/sortable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/drag-drop/drop-indicators\", \"Magento_PageBuilder/js/drag-drop/matrix\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\"], function (_jquery, _knockout, _events, _contentTypeFactory, _dropIndicators, _matrix, _moveContentType, _registry) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * The class used when hiding a content type\n   * @type {string}\n   */\n  var hiddenClass = \".pagebuilder-content-type-hidden\";\n  /**\n   * Return the sortable options for an instance which requires sorting / dropping functionality\n   *\n   * @param {Preview} preview\n   * @returns {JQueryUI.SortableOptions | any}\n   */\n\n  function getSortableOptions(preview) {\n    return {\n      cursor: \"-webkit-grabbing\",\n      tolerance: \"pointer\",\n      helper: function helper(event, item) {\n        var helper = (0, _jquery)(item).clone();\n        helper.css({\n          pointerEvents: \"none\"\n        });\n        return helper[0];\n      },\n      appendTo: document.body,\n      placeholder: {\n        element: function element() {\n          return (0, _jquery)(\"<div />\").addClass(\"pagebuilder-sortable-placeholder\")[0];\n        },\n        update: function update() {\n          return;\n        }\n      },\n      handle: \".move-structural\",\n      items: \"> .pagebuilder-content-type-wrapper\",\n      start: function start() {\n        onSortStart.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      sort: function sort() {\n        onSort.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      receive: function receive() {\n        onSortReceive.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      update: function update() {\n        onSortUpdate.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      stop: function stop() {\n        onSortStop.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      }\n    };\n  }\n  /**\n   * Get the stage ID from the preview\n   *\n   * @param {Preview | Stage} preview\n   * @returns {string}\n   */\n\n\n  function getPreviewStageIdProxy(preview) {\n    return preview.contentType.stageId;\n  }\n  /**\n   * Retrieve the contentType from the preview\n   *\n   * @param {Preview | Stage} instance\n   * @returns {any}\n   */\n\n\n  function getcontentTypeProxy(instance) {\n    return instance.contentType;\n  }\n\n  var sortedContentType;\n  /**\n   * On sort start record the item being sorted\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n  function onSortStart(preview, event, ui) {\n    // Verify we're sorting an already created item\n    if (ui.item.hasClass(\"pagebuilder-content-type-wrapper\")) {\n      _events.trigger(\"stage:interactionStart\");\n\n      var contentTypeInstance = _knockout.dataFor(ui.item[0]);\n\n      if (contentTypeInstance) {\n        // Ensure the original item is displayed but with reduced opacity\n        ui.item.css(\"display\", \"block\").addClass(\"pagebuilder-sorting-original\");\n        (0, _jquery)(\".pagebuilder-drop-indicator.hidden-drop-indicator\").css(\"display\", \"block\").removeClass(\"hidden-drop-indicator\"); // If we're the first item in the container we need to hide the first drop indicator\n\n        if (contentTypeInstance.parentContentType.getChildren().indexOf(contentTypeInstance) === 0) {\n          ui.item.prev(\".pagebuilder-drop-indicator\").css(\"display\", \"none\").addClass(\"hidden-drop-indicator\");\n        }\n\n        (0, _dropIndicators.showDropIndicators)(contentTypeInstance.config.name, preview.contentType.stageId);\n        sortedContentType = contentTypeInstance; // Dynamically change the connect with option to restrict content types\n\n        (0, _jquery)(this).sortable(\"option\", \"connectWith\", (0, _matrix.getAllowedContainersClasses)(contentTypeInstance.config.name, preview.contentType.stageId));\n        (0, _jquery)(this).sortable(\"refresh\");\n      }\n    }\n  }\n\n  var placeholderContainer;\n  /**\n   * On a sort action hide the placeholder if disabled\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n  function onSort(preview, event, ui) {\n    if ((0, _jquery)(this).sortable(\"option\", \"disabled\") || ui.placeholder.parents(hiddenClass).length > 0) {\n      ui.placeholder.css(\"display\", \"none\");\n    } else {\n      ui.placeholder.css(\"display\", \"block\");\n    }\n    /**\n     * We record the position of the placeholder on sort so we can ensure we place the content type in the correct place\n     * as jQuery UI's events aren't reliable.\n     */\n\n\n    placeholderContainer = ui.placeholder.parents(\".content-type-container\")[0];\n  }\n  /**\n   * On sort stop hide any indicators\n   */\n\n\n  function onSortStop(preview, event, ui) {\n    ui.item.removeClass(\"pagebuilder-sorting-original\");\n    (0, _dropIndicators.hideDropIndicators)();\n    (0, _registry.setDraggedContentTypeConfig)(null); // Only trigger stop if we triggered start\n\n    if (ui.item.hasClass(\"pagebuilder-content-type-wrapper\")) {\n      _events.trigger(\"stage:interactionStop\");\n    }\n\n    if (ui.item && !sortedContentType) {\n      ui.item.remove();\n    }\n\n    sortedContentType = null;\n  }\n  /**\n   * Handle receiving a content type from the left panel\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n\n  function onSortReceive(preview, event, ui) {\n    var contentTypeConfig = (0, _registry.getDraggedContentTypeConfig)();\n    (0, _registry.setDraggedContentTypeConfig)(null);\n\n    if ((0, _jquery)(event.target)[0] !== this) {\n      return;\n    } // If the container content type can't receive drops we need to cancel the operation\n\n\n    if (!preview.isContainer()) {\n      (0, _jquery)(this).sortable(\"cancel\");\n      return;\n    }\n\n    if (contentTypeConfig) {\n      // If the sortable instance is disabled don't complete this operation\n      if ((0, _jquery)(this).sortable(\"option\", \"disabled\") || (0, _jquery)(this).parents(hiddenClass).length > 0) {\n        return;\n      } // jQuery's index method doesn't work correctly here, so use Array.findIndex instead\n\n\n      var index = (0, _jquery)(event.target).children(\".pagebuilder-content-type-wrapper, .pagebuilder-draggable-content-type\").toArray().findIndex(function (element) {\n        return element.classList.contains(\"pagebuilder-draggable-content-type\");\n      }); // Create the new content type and insert it into the parent\n\n      (0, _contentTypeFactory)(contentTypeConfig, getcontentTypeProxy(preview), getPreviewStageIdProxy(preview)).then(function (contentType) {\n        // Set the content type instance as \"dropped\", as it was dropped from the left panel\n        contentType.dropped = true;\n        getcontentTypeProxy(preview).addChild(contentType, index);\n\n        _events.trigger(\"contentType:dropAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentTypeConfig.name + \":dropAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        return contentType;\n      }); // Remove the DOM element, as this is a drop event we can't just remove the ui.item\n\n      (0, _jquery)(event.target).find(\".pagebuilder-draggable-content-type\").remove();\n    }\n  }\n  /**\n   * On sort update handle sorting the underlying children knockout list\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n\n  function onSortUpdate(preview, event, ui) {\n    // If the sortable instance is disabled don't complete this operation\n    if ((0, _jquery)(this).hasClass(\"ui-sortable\") && (0, _jquery)(this).sortable(\"option\", \"disabled\") || ui.item.parents(hiddenClass).length > 0) {\n      ui.item.remove();\n      (0, _jquery)(this).sortable(\"cancel\"); // jQuery tries to reset the state but kills KO's bindings, so we'll force a re-render on the content type\n\n      if (ui.item.length > 0 && typeof _knockout.dataFor(ui.item[0]) !== \"undefined\") {\n        var data = _knockout.dataFor(ui.item[0]);\n\n        var contentType = data.contentType && data.contentType.getChildren ? data.contentType : data.parentContentType;\n        var children = contentType.getChildren()().splice(0);\n        contentType.getChildren()([]);\n        contentType.getChildren()(children);\n      }\n\n      return;\n    }\n    /**\n     * Validate the event is coming from the exact instance or a child instance, we validate on the child instance\n     * as the event is sometimes annoyingly caught by the parent rather than the child it's dropped into. Combining this\n     * with placeholderContainer logic we can ensure we always do the right operation.\n     */\n\n\n    if (sortedContentType && (this === ui.item.parent()[0] || placeholderContainer && (0, _jquery)(this).find(ui.item.parent()).length > 0)) {\n      var el = ui.item[0];\n\n      var contentTypeInstance = _knockout.dataFor(el);\n\n      var target = _knockout.dataFor(placeholderContainer);\n\n      if (target && contentTypeInstance) {\n        // Calculate the source and target index\n        var sourceParent = contentTypeInstance.parentContentType;\n        var targetParent = getcontentTypeProxy(target);\n        var targetIndex = (0, _jquery)(placeholderContainer).children(\".pagebuilder-content-type-wrapper, .pagebuilder-draggable-content-type\").toArray().findIndex(function (element) {\n          return element === el;\n        });\n\n        if (sourceParent) {\n          (0, _jquery)(sourceParent === targetParent ? this : ui.sender || this).sortable(\"cancel\");\n        } else {\n          (0, _jquery)(el).remove();\n        }\n\n        (0, _moveContentType.moveContentType)(contentTypeInstance, targetIndex, targetParent);\n\n        if (contentTypeInstance.parentContentType !== targetParent) {\n          ui.item.remove();\n        }\n      }\n    }\n  }\n\n  return {\n    getSortableOptions: getSortableOptions,\n    hiddenClass: hiddenClass\n  };\n});\n//# sourceMappingURL=sortable.js.map","Magento_PageBuilder/js/drag-drop/matrix.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/config\"], function (_underscore, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var allowedParents = {};\n  /**\n   * Build a matrix of which containers each content type can go into, these are determined by the allowed_parents\n   * node within the content types configuration\n   */\n\n  function generateAllowedParents() {\n    _underscore.values(_config.getConfig(\"content_types\")).forEach(function (contentType) {\n      allowedParents[contentType.name] = contentType.allowed_parents.slice();\n    });\n  }\n  /**\n   * Retrieve the containers a specific content type can be contained in\n   *\n   * @param {string} contentType\n   * @returns {any}\n   */\n\n\n  function getContainersFor(contentType) {\n    if (allowedParents[contentType]) {\n      return allowedParents[contentType];\n    }\n\n    return [];\n  }\n  /**\n   * Generate classes of containers the content type is allowed within\n   *\n   * @param {string} contentType\n   * @param {string} stageId\n   * @returns {string}\n   */\n\n\n  function getAllowedContainersClasses(contentType, stageId) {\n    return getContainersFor(contentType).map(function (value) {\n      return \"#\" + stageId + \" .content-type-container.\" + value + \"-container\";\n    }).join(\", \");\n  }\n  /**\n   * @api\n   */\n\n\n  return {\n    generateAllowedParents: generateAllowedParents,\n    getContainersFor: getContainersFor,\n    getAllowedContainersClasses: getAllowedContainersClasses\n  };\n});\n//# sourceMappingURL=matrix.js.map","Magento_PageBuilder/js/drag-drop/registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var draggedContentTypeConfig;\n  /**\n   * Set the current dragged blocks config into the registry\n   *\n   * @param {ContentTypeConfigInterface} config\n   */\n\n  function setDraggedContentTypeConfig(config) {\n    draggedContentTypeConfig = config;\n  }\n  /**\n   * Retrieve the dragged blocks config\n   *\n   * @returns {ContentTypeConfigInterface}\n   */\n\n\n  function getDraggedContentTypeConfig() {\n    return draggedContentTypeConfig;\n  }\n\n  return {\n    setDraggedContentTypeConfig: setDraggedContentTypeConfig,\n    getDraggedContentTypeConfig: getDraggedContentTypeConfig\n  };\n});\n//# sourceMappingURL=registry.js.map","Magento_PageBuilder/js/content-type/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/modal/dismissible-confirm\", \"underscore\", \"Magento_PageBuilder/js/binding/live-edit\", \"Magento_PageBuilder/js/binding/sortable\", \"Magento_PageBuilder/js/binding/sortable-children\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-collection\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu\", \"Magento_PageBuilder/js/content-type-menu/edit\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/content-type-menu/title-option\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/utils/check-stage-full-screen\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/appearance-config\"], function (_jquery, _knockout, _translate, _events, _dismissibleConfirm, _underscore, _liveEdit, _sortable, _sortableChildren, _config, _contentTypeCollection, _contentTypeFactory, _contentTypeMenu, _edit, _option, _titleOption, _registry, _sortable2, _checkStageFullScreen, _object, _appearanceConfig) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Provide preview data as an object which can be queried\n     *\n     * @deprecated please use getOptionValue directly\n     */\n\n    /**\n     * Fields that should not be considered when evaluating whether an object has been configured.\n     *\n     * @see {Preview.isConfigured}\n     * @type {[string]}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      this.data = {};\n      this.displayLabel = _knockout.observable();\n      this.display = _knockout.observable(true);\n      this.appearance = _knockout.observable();\n      this.isPlaceholderVisible = _knockout.observable(true);\n      this.isEmpty = _knockout.observable(true);\n      this.viewport = _knockout.observable(\"\");\n      this.previewData = {};\n      this.fieldsToIgnoreOnRemove = [];\n      this.events = {};\n      this.isSnapshot = _knockout.observable(false);\n      this.mouseover = false;\n      this.contentType = contentType;\n      this.config = config;\n      this.edit = new _edit(this.contentType, this.contentType.dataStore);\n      this.optionsMenu = new _contentTypeMenu(this, this.retrieveOptions());\n      this.observableUpdater = observableUpdater;\n      this.displayLabel(this.config.label);\n      this.placeholderCss = _knockout.observable({\n        \"visible\": this.isEmpty,\n        \"empty-placeholder-background\": this.isPlaceholderVisible\n      });\n\n      if (_config.getConfig(\"pagebuilder_content_snapshot\")) {\n        this.isSnapshot(!(0, _checkStageFullScreen)(this.contentType.stageId));\n      }\n\n      this.viewport(_config.getConfig(\"viewport\"));\n      this.bindEvents();\n      this.populatePreviewData();\n    }\n    /**\n     * Retrieve the preview template\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Calls methods by event name.\n     *\n     * @param {string}  eventName\n     * @param {any} params\n     */\n    _proto.trigger = function trigger(eventName, params) {\n      var _this = this;\n\n      if (this.events[eventName]) {\n        var methods = this.events[eventName];\n\n        _underscore.each(methods.split(\" \"), function (methodName) {\n          var method = _this[methodName];\n\n          if (method) {\n            method.call(_this, params);\n          }\n        }, this);\n      }\n    }\n    /**\n     * Tries to call specified method of a current content type.\n     *\n     * @param args\n     */\n    ;\n\n    _proto.delegate = function delegate() {\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      var methodName = args.slice(0, 1)[0];\n      var method = this[methodName];\n\n      if (method) {\n        method.apply(this, args.slice(1, args.length));\n      }\n    }\n    /**\n     * Open the edit form for this content type\n     */\n    ;\n\n    _proto.openEdit = function openEdit() {\n      return this.edit.open();\n    }\n    /**\n     * Update data store\n     *\n     * @param {string} key\n     * @param {string} value\n     */\n    ;\n\n    _proto.updateData = function updateData(key, value) {\n      this.contentType.dataStore.set(key, value);\n    }\n    /**\n     * Retrieve the value for an option\n     *\n     * @param key\n     */\n    ;\n\n    _proto.getOptionValue = function getOptionValue(key) {\n      return this.contentType.dataStore.get(key);\n    }\n    /**\n     * Set state based on mouseover event for the preview\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onMouseOver = function onMouseOver(context, event) {\n      if (this.mouseover || (0, _registry.getDraggedContentTypeConfig)()) {\n        return;\n      } // Ensure no other options panel is displayed\n\n\n      (0, _jquery)(\".pagebuilder-options-visible\").removeClass(\"pagebuilder-options-visible\");\n      this.mouseover = true;\n      this.mouseoverContext = context;\n      var currentTarget = event.currentTarget;\n      var optionsMenu = (0, _jquery)(currentTarget).find(\".pagebuilder-options-wrapper\");\n\n      if (!(0, _jquery)(currentTarget).hasClass(\"type-nested\")) {\n        optionsMenu = optionsMenu.first();\n      }\n\n      var middleOfPreview = currentTarget.getBoundingClientRect().left + currentTarget.offsetWidth / 2; // Check for space for option menu\n\n      if (window.innerWidth - middleOfPreview > optionsMenu.width() / 2) {\n        optionsMenu.parent().addClass(\"pagebuilder-options-middle\");\n      } else {\n        optionsMenu.parent().removeClass(\"pagebuilder-options-middle\");\n      }\n\n      optionsMenu.parent().addClass(\"pagebuilder-options-visible\");\n      (0, _jquery)(currentTarget).addClass(\"pagebuilder-content-type-active\");\n    }\n    /**\n     * Set state based on mouseout event for the preview\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onMouseOut = function onMouseOut(context, event) {\n      var _this2 = this;\n\n      this.mouseover = false;\n\n      if ((0, _registry.getDraggedContentTypeConfig)()) {\n        return;\n      }\n\n      _underscore.delay(function () {\n        if (!_this2.mouseover && _this2.mouseoverContext === context) {\n          var currentTarget = event.currentTarget;\n          var optionsMenu = (0, _jquery)(currentTarget).find(\".pagebuilder-options-wrapper\");\n\n          if (!(0, _jquery)(currentTarget).hasClass(\"type-nested\")) {\n            optionsMenu = optionsMenu.first();\n          }\n\n          optionsMenu.parent().removeClass(\"pagebuilder-options-visible\");\n          (0, _jquery)(currentTarget).removeClass(\"pagebuilder-content-type-active\");\n        }\n      }, 100); // 100 ms delay to allow for users hovering over other elements\n\n    }\n    /**\n     * After children render fire an event\n     *\n     * @param {Element} element\n     * @deprecated\n     */\n    ;\n\n    _proto.afterChildrenRender = function afterChildrenRender(element) {\n      _events.trigger(\"contentType:childrenRenderAfter\", {\n        id: this.contentType.id,\n        contentType: this.contentType,\n        element: element\n      });\n\n      _events.trigger(this.contentType.config.name + \":childrenRenderAfter\", {\n        contentType: this.contentType,\n        element: element,\n        id: this.contentType.id\n      });\n    }\n    /**\n     * Dispatch an after render event for individual content types\n     *\n     * @param {Element[]} elements\n     */\n    ;\n\n    _proto.dispatchAfterRenderEvent = function dispatchAfterRenderEvent(elements) {\n      var elementNodes = elements.filter(function (renderedElement) {\n        return renderedElement.nodeType === Node.ELEMENT_NODE;\n      });\n\n      if (elementNodes.length > 0) {\n        var element = elementNodes[0];\n        this.wrapperElement = element;\n\n        _events.trigger(\"contentType:renderAfter\", {\n          id: this.contentType.id,\n          contentType: this.contentType,\n          element: element\n        });\n\n        _events.trigger(this.contentType.config.name + \":renderAfter\", {\n          contentType: this.contentType,\n          element: element,\n          id: this.contentType.id\n        });\n\n        this.disableImageUploadOnHide(element);\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {ContentTypeMenu}\n     */\n    ;\n\n    _proto.getOptions = function getOptions() {\n      return this.optionsMenu;\n    }\n    /**\n     * Handle user editing an instance\n     */\n    ;\n\n    _proto.onOptionEdit = function onOptionEdit() {\n      this.openEdit();\n    }\n    /**\n     * Reverse the display data currently in the data store\n     */\n    ;\n\n    _proto.onOptionVisibilityToggle = function onOptionVisibilityToggle() {\n      var display = this.contentType.dataStore.get(\"display\");\n      this.contentType.dataStore.set(\"display\", !display);\n      this.dispatchContentTypeVisibilityEvents(this.contentType, !display);\n    }\n    /**\n     * Handle duplicate of items\n     */\n    ;\n\n    _proto.onOptionDuplicate = function onOptionDuplicate() {\n      this.clone(this.contentType, true, true);\n    }\n    /**\n     * Duplicate content type\n     *\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n     * @param {boolean} autoAppend\n     * @param {boolean} direct\n     * @returns {Promise<ContentTypeInterface> | void}\n     */\n    ;\n\n    _proto.clone = function clone(contentType, autoAppend, direct) {\n      var _this3 = this;\n\n      if (autoAppend === void 0) {\n        autoAppend = true;\n      }\n\n      if (direct === void 0) {\n        direct = false;\n      }\n\n      var defaultViewport = _config.getConfig(\"defaultViewport\");\n\n      var contentTypeData = contentType.dataStores[defaultViewport].getState();\n      var index = contentType.parentContentType.getChildren()().indexOf(contentType) + 1 || null;\n      return (0, _contentTypeFactory)(contentType.config, contentType.parentContentType, contentType.stageId, contentTypeData, 0, contentType.getDataStoresStates()).then(function (duplicateContentType) {\n        if (autoAppend) {\n          contentType.parentContentType.addChild(duplicateContentType, index);\n        }\n\n        _this3.dispatchContentTypeCloneEvents(contentType, duplicateContentType, index, direct);\n\n        return duplicateContentType;\n      });\n    }\n    /**\n     * Handle content type removal\n     */\n    ;\n\n    _proto.onOptionRemove = function onOptionRemove() {\n      var _this4 = this;\n\n      var removeContentType = function removeContentType() {\n        if (_this4.wrapperElement) {\n          // Fade out the content type\n          (0, _jquery)(_this4.wrapperElement).fadeOut(350 / 2, function () {\n            _this4.contentType.destroy();\n          });\n        } else {\n          _this4.contentType.destroy();\n        }\n      };\n\n      if (this.isConfigured()) {\n        (0, _dismissibleConfirm)({\n          actions: {\n            confirm: function confirm() {\n              // Call the parent to remove the child element\n              removeContentType();\n            }\n          },\n          content: (0, _translate)(\"Are you sure you want to remove this item? The data within this item is not recoverable once removed.\"),\n          // tslint:disable-line:max-line-length\n          dismissKey: \"pagebuilder_modal_dismissed\",\n          dismissible: true,\n          title: (0, _translate)(\"Confirm Item Removal\")\n        });\n      } else {\n        removeContentType();\n      }\n    }\n    /**\n     * Determine if the container can receive drop events? With the current matrix system everything can unless\n     * specified in an inherited preview instance.\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isContainer = function isContainer() {\n      return true;\n    }\n    /**\n     * Return the sortable options\n     *\n     * @returns {JQueryUI.SortableOptions}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions() {\n      return (0, _sortable2.getSortableOptions)(this);\n    }\n    /**\n     * Destroys current instance\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      return;\n    }\n    /**\n     * Get the CSS classes for the children element, as we dynamically create this class name it can't sit in the DOM\n     * without causing browser issues\n     *\n     * @returns {{[p: string]: boolean}}\n     */\n    ;\n\n    _proto.getChildrenCss = function getChildrenCss() {\n      var _ref;\n\n      return _ref = {}, _ref[this.config.name + \"-container\"] = true, _ref;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = {\n        move: new _option({\n          preview: this,\n          icon: \"<i class='icon-admin-pagebuilder-handle'></i>\",\n          title: (0, _translate)(\"Move\"),\n          classes: [\"move-structural\"],\n          sort: 10\n        }),\n        title: new _titleOption({\n          preview: this,\n          title: this.config.label,\n          template: \"Magento_PageBuilder/content-type/title\",\n          sort: 20\n        }),\n        edit: new _option({\n          preview: this,\n          icon: \"<i class='icon-admin-pagebuilder-systems'></i>\",\n          title: (0, _translate)(\"Edit\"),\n          action: this.onOptionEdit,\n          classes: [\"edit-content-type\"],\n          sort: 30\n        }),\n        duplicate: new _option({\n          preview: this,\n          icon: \"<i class='icon-pagebuilder-copy'></i>\",\n          title: (0, _translate)(\"Duplicate\"),\n          action: this.onOptionDuplicate,\n          classes: [\"duplicate-structural\"],\n          sort: 50\n        }),\n        remove: new _option({\n          preview: this,\n          icon: \"<i class='icon-admin-pagebuilder-remove'></i>\",\n          title: (0, _translate)(\"Remove\"),\n          action: this.onOptionRemove,\n          classes: [\"remove-structural\"],\n          sort: 60\n        })\n      };\n      return options;\n    }\n    /**\n     * Dispatch content type clone events\n     *\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} originalContentType\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} duplicateContentType\n     * @param {number} index\n     * @param {boolean} direct\n     */\n    ;\n\n    _proto.dispatchContentTypeCloneEvents = function dispatchContentTypeCloneEvents(originalContentType, duplicateContentType, index, direct) {\n      var duplicateEventParams = {\n        originalContentType: originalContentType,\n        duplicateContentType: duplicateContentType,\n        index: index,\n        direct: direct\n      };\n\n      _events.trigger(\"contentType:duplicateAfter\", duplicateEventParams);\n\n      _events.trigger(originalContentType.config.name + \":duplicateAfter\", duplicateEventParams);\n    }\n    /**\n     * Dispatch content type visibility events\n     *\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n     * @param {boolean} visibility\n     */\n    ;\n\n    _proto.dispatchContentTypeVisibilityEvents = function dispatchContentTypeVisibilityEvents(contentType, visibility) {\n      var visibilityEventParams = {\n        contentType: contentType,\n        visibility: visibility\n      };\n\n      _events.trigger(\"contentType:visibilityAfter\", visibilityEventParams);\n\n      _events.trigger(contentType.config.name + \":visibilityAfter\", visibilityEventParams);\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this5 = this;\n\n      var fullScreenModeChangeAfterEvent = \"stage:\" + this.contentType.stageId + \":fullScreenModeChangeAfter\";\n      this.contentType.dataStore.subscribe(function (data) {\n        _this5.updateObservables();\n\n        _this5.updatePlaceholderVisibility(data); // Keep a reference to the display state in an observable for adding classes to the wrapper\n\n\n        _this5.display(!!data.display);\n\n        _this5.appearance(data.appearance);\n      });\n\n      if (this.contentType instanceof _contentTypeCollection) {\n        this.contentType.children.subscribe(function (children) {\n          _this5.isEmpty(!children.length);\n        });\n      }\n\n      _events.on(fullScreenModeChangeAfterEvent, this.toggleSnapshot.bind(this));\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this5.viewport(args.viewport);\n      });\n    }\n    /**\n     * After observables updated, allows to modify observables\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      return;\n    }\n    /**\n     * Does the current instance have any children or values different from the default for it's type?\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isConfigured = function isConfigured() {\n      var _this6 = this;\n\n      var data = this.contentType.dataStore.getState();\n      var fields = this.contentType.config.fields[this.appearance() + \"-appearance\"] || this.contentType.config.fields.default;\n      var hasDataChanges = false;\n\n      _underscore.each(fields, function (field, key) {\n        if (_this6.fieldsToIgnoreOnRemove && _this6.fieldsToIgnoreOnRemove.includes(key)) {\n          return;\n        }\n\n        var fieldValue = (0, _object.get)(data, key);\n\n        if (!fieldValue) {\n          fieldValue = \"\";\n        } // Default values can only ever be strings\n\n\n        if (_underscore.isObject(fieldValue)) {\n          // Empty arrays as default values appear as empty strings\n          if (_underscore.isArray(fieldValue) && fieldValue.length === 0) {\n            fieldValue = \"\";\n          } else {\n            fieldValue = JSON.stringify(fieldValue);\n          }\n        }\n\n        if (_underscore.isObject(field.default)) {\n          if (JSON.stringify(field.default) !== fieldValue) {\n            hasDataChanges = true;\n          }\n        } else if (field.default !== fieldValue) {\n          hasDataChanges = true;\n        }\n\n        return;\n      });\n\n      return hasDataChanges;\n    }\n    /**\n     * Any hidden element should block drag / drop events from uploading images from the OS. We have to block this for\n     * all elements as underlying elements could still receive the events if a parent is hidden.\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.disableImageUploadOnHide = function disableImageUploadOnHide(element) {\n      var _this7 = this;\n\n      (0, _jquery)(element).on(\"drag dragstart dragend dragover dragenter dragleave drop\", function (event) {\n        if (_this7.display() === false) {\n          event.preventDefault();\n          event.stopPropagation();\n        }\n      });\n    }\n    /**\n     * Update observables\n     */\n    ;\n\n    _proto.updateObservables = function updateObservables() {\n      this.observableUpdater.update(this, _underscore.extend({}, this.contentType.dataStore.getState()));\n      this.afterObservablesUpdated();\n    }\n    /**\n     * Update placeholder background visibility base on height and padding\n     *\n     * @param {DataObject} data\n     */\n    ;\n\n    _proto.updatePlaceholderVisibility = function updatePlaceholderVisibility(data) {\n      var minHeight = !_underscore.isEmpty(data.min_height) ? parseFloat(data.min_height) : 130;\n      var marginsAndPadding = _underscore.isString(data.margins_and_padding) && data.margins_and_padding ? JSON.parse(data.margins_and_padding) : data.margins_and_padding || {};\n      var padding = marginsAndPadding.padding || {};\n      var paddingBottom = parseFloat(padding.bottom) || 0;\n      var paddingTop = parseFloat(padding.top) || 0;\n      this.isPlaceholderVisible(paddingBottom + paddingTop + minHeight >= 130);\n    }\n    /**\n     * Populate the preview data with calls to the supported getOptionValue method\n     *\n     * @deprecated this function is only included to preserve backwards compatibility, use getOptionValue directly\n     */\n    ;\n\n    _proto.populatePreviewData = function populatePreviewData() {\n      var _this8 = this;\n\n      if (this.config.fields) {\n        _underscore.each(this.config.fields, function (fields) {\n          _underscore.keys(fields).forEach(function (key) {\n            _this8.previewData[key] = _knockout.observable(\"\");\n          });\n        });\n      } // Subscribe to this content types data in the store\n\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _underscore.forEach(data, function (value, key) {\n          var optionValue = _this8.getOptionValue(key);\n\n          if (_knockout.isObservable(_this8.previewData[key])) {\n            _this8.previewData[key](optionValue);\n          } else {\n            if (_underscore.isArray(optionValue)) {\n              _this8.previewData[key] = _knockout.observableArray(optionValue);\n            } else {\n              _this8.previewData[key] = _knockout.observable(optionValue);\n            }\n          }\n        });\n      });\n    }\n    /**\n     * Enable snapshot mode.\n     * @param args\n     */\n    ;\n\n    _proto.toggleSnapshot = function toggleSnapshot(args) {\n      if (_config.getConfig(\"pagebuilder_content_snapshot\")) {\n        this.isSnapshot(!args.fullScreen);\n      }\n    };\n\n    _createClass(Preview, [{\n      key: \"template\",\n      get: function get() {\n        return (0, _appearanceConfig)(this.config.name, this.appearance()).preview_template;\n      }\n    }]);\n\n    return Preview;\n  }();\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/master-factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/content-type/converter-resolver\", \"Magento_PageBuilder/js/content-type/observable-updater-factory\"], function (_loader, _converterResolver, _observableUpdaterFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create new content instance\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {ContentTypeConfigInterface} config\n   * @returns {Promise<ContentTypeInterface>}\n   */\n  function create(contentType, config) {\n    return new Promise(function (resolve, reject) {\n      (0, _observableUpdaterFactory)(config, _converterResolver).then(function (observableUpdater) {\n        (0, _loader)([config.master_component], function (masterComponent) {\n          try {\n            var master = new masterComponent(contentType, observableUpdater);\n            resolve(master);\n          } catch (error) {\n            reject(\"Error within master component (\" + config.master_component + \") for \" + config.name + \".\");\n            console.error(error);\n          }\n        }, function (error) {\n          reject(\"Unable to load preview component (\" + config.master_component + \") for \" + config.name + \". Please \" + \"check preview component exists and content type configuration is correct.\");\n          console.error(error);\n        });\n      }).catch(function (error) {\n        console.error(error);\n        return null;\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=master-factory.js.map","Magento_PageBuilder/js/content-type/preview-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_config, _contentTypeFactory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PreviewCollection = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(PreviewCollection, _preview2);\n\n    function PreviewCollection() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = PreviewCollection.prototype;\n\n    /**\n     * Duplicate a collection content type\n     *\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {boolean} autoAppend\n     * @param {boolean} direct\n     * @returns {Promise<ContentTypeCollectionInterface> | void}\n     */\n    _proto.clone = function clone(contentType, autoAppend, direct) {\n      var _this = this;\n\n      if (autoAppend === void 0) {\n        autoAppend = true;\n      }\n\n      if (direct === void 0) {\n        direct = false;\n      }\n\n      var defaultViewport = _config.getConfig(\"defaultViewport\");\n\n      var index = contentType.parentContentType.getChildren().indexOf(contentType) + 1 || null;\n      var childrenLength = contentType.children ? contentType.children().length : 0;\n      return new Promise(function (resolve, reject) {\n        (0, _contentTypeFactory)(contentType.config, contentType.parentContentType, contentType.stageId, contentType.dataStores[defaultViewport].getState(), childrenLength, contentType.getDataStoresStates()).then(function (duplicate) {\n          if (contentType.children && contentType.children().length > 0) {\n            // Duplicate the instances children into the new duplicate\n            contentType.children().forEach(function (subChild) {\n              var subChildClone = duplicate.preview.clone(subChild, false);\n\n              if (subChildClone) {\n                subChildClone.then(function (duplicateSubChild) {\n                  duplicateSubChild.parentContentType = duplicate;\n                  duplicate.addChild(duplicateSubChild);\n                });\n              } else {\n                reject(\"Unable to duplicate sub child.\");\n              }\n            });\n          }\n\n          if (autoAppend) {\n            contentType.parentContentType.addChild(duplicate, index);\n          }\n\n          _this.dispatchContentTypeCloneEvents(contentType, duplicate, index, direct);\n\n          resolve(duplicate);\n        });\n      });\n    }\n    /**\n     * Tries to call specified method of a current content type,\n     * and delegates attempt to its' children.\n     * @param args\n     */\n    ;\n\n    _proto.delegate = function delegate() {\n      var _preview2$prototype$d;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      (_preview2$prototype$d = _preview2.prototype.delegate).call.apply(_preview2$prototype$d, [this].concat(args));\n\n      this.contentType.getChildren()().forEach(function (elem) {\n        elem.preview.delegate.apply(elem.preview, args);\n      });\n    }\n    /**\n     * Does the current instance have any children or values different from the default for it's type?\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isConfigured = function isConfigured() {\n      if (this.contentType.children().length > 0) {\n        return true;\n      }\n\n      return _preview2.prototype.isConfigured.call(this);\n    };\n\n    _createClass(PreviewCollection, [{\n      key: \"childTemplate\",\n      get:\n      /**\n       * Retrieve the preview child template\n       *\n       * @returns {string}\n       */\n      function get() {\n        return \"Magento_PageBuilder/content-type/preview-collection\";\n      }\n    }]);\n\n    return PreviewCollection;\n  }(_preview);\n\n  return PreviewCollection;\n});\n//# sourceMappingURL=preview-collection.js.map","Magento_PageBuilder/js/content-type/preview-styles.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type/style-registry\"], function (_knockout, _events, _styleRegistry) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PreviewStyles =\n  /*#__PURE__*/\n  function () {\n    \"use strict\";\n\n    function PreviewStyles(stageId) {\n      var _this = this;\n\n      this.styleBlocks = _knockout.observableArray([]);\n      this.template = \"Magento_PageBuilder/content-type/preview-styles\";\n      this.stageId = stageId;\n\n      _events.on(\"styles:update\", function (args) {\n        if (args.stageId === _this.stageId) {\n          var css = (0, _styleRegistry.generateCssBlock)(args.className, args.styles); // Remove any existing style blocks for the current class name\n\n          var existingBlock = _this.styleBlocks().find(function (block) {\n            return block.className === args.className;\n          });\n\n          if (existingBlock) {\n            // Don't do an update if the CSS matches\n            if (existingBlock.css === css) {\n              return;\n            }\n\n            _this.styleBlocks.splice(_this.styleBlocks().indexOf(existingBlock), 1);\n          }\n\n          _this.styleBlocks.push({\n            className: args.className,\n            css: css\n          });\n        }\n      });\n    }\n    /**\n     * Get template.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = PreviewStyles.prototype;\n\n    _proto.getTemplate = function getTemplate() {\n      return this.template;\n    };\n\n    return PreviewStyles;\n  }();\n\n  return PreviewStyles;\n});\n//# sourceMappingURL=preview-styles.js.map","Magento_PageBuilder/js/content-type/observable-updater.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"consoleLogger\", \"knockout\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/appearance-config\", \"Magento_PageBuilder/js/content-type/observable-updater/attributes\", \"Magento_PageBuilder/js/content-type/observable-updater/css\", \"Magento_PageBuilder/js/content-type/observable-updater/html\", \"Magento_PageBuilder/js/content-type/observable-updater/style\"], function (_consoleLogger, _knockout, _underscore, _config, _appearanceConfig, _attributes, _css, _html, _style) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ObservableUpdater = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {typeof ConverterPool} converterPool\n     * @param {typeof MassConverterPool} massConverterPool\n     * @param {(config: object) => string} converterResolver\n     */\n    function ObservableUpdater(converterPool, massConverterPool, converterResolver) {\n      this.previousData = {};\n      this.bindingGenerators = {\n        attributes: _attributes,\n        css: _css,\n        html: _html,\n        style: _style\n      };\n      this.converterPool = converterPool;\n      this.massConverterPool = massConverterPool;\n      this.converterResolver = converterResolver;\n    }\n    /**\n     * Update the associated viewModel with the generated data\n     *\n     * We create an API for each potential binding and make it available in the master and preview templates through\n     * the data variable. Each data variable will have associated observables that are updated on a data change.\n     *\n     * @param {Preview} viewModel\n     * @param {DataObject} data\n     * @param {DataObject} dataStores\n     */\n\n\n    var _proto = ObservableUpdater.prototype;\n\n    _proto.update = function update(viewModel, data, dataStores) {\n      var appearance = data && data.appearance !== undefined ? data.appearance : undefined;\n      var appearanceConfiguration = (0, _appearanceConfig)(viewModel.contentType.config.name, appearance);\n\n      if (undefined === appearanceConfiguration || undefined === appearanceConfiguration.elements) {\n        return;\n      } // Generate Knockout bindings in objects for usage in preview and master templates\n\n\n      var generatedBindings = this.generateKnockoutBindings(appearanceConfiguration.elements, appearanceConfiguration.converters, data, dataStores);\n\n      var _loop = function _loop(element) {\n        if (generatedBindings.hasOwnProperty(element)) {\n          // Ensure every element is represented by an object\n          if (viewModel.data[element] === undefined) {\n            viewModel.data[element] = {};\n          }\n          /**\n           * Iterate through each elements data (css, style, attributes) and apply data updates within the\n           * observable. If no observable already exists create a new one.\n           */\n\n\n          Object.keys(generatedBindings[element]).forEach(function (key) {\n            var elementBindings = viewModel.data[element][key];\n\n            if (elementBindings !== undefined && _knockout.isObservable(elementBindings)) {\n              elementBindings(generatedBindings[element][key]);\n            } else {\n              viewModel.data[element][key] = _knockout.observable(generatedBindings[element][key]);\n            }\n          });\n        }\n      };\n\n      for (var element in generatedBindings) {\n        _loop(element);\n      }\n    }\n    /**\n     * Generate binding object to be applied to master format\n     *\n     * This function iterates through each element defined in the content types XML and generates a nested object of\n     * the associated Knockout binding data. We support 5 bindings attributes, style, css, html & tag.\n     *\n     * @param elements\n     * @param converters\n     * @param data\n     * @param dataStoreStates\n     */\n    ;\n\n    _proto.generateKnockoutBindings = function generateKnockoutBindings(elements, converters, data, dataStoreStates) {\n      var convertedData = this.convertData(data, converters);\n      var generatedData = {};\n\n      for (var _i = 0, _Object$keys = Object.keys(elements); _i < _Object$keys.length; _i++) {\n        var elementName = _Object$keys[_i];\n        var elementConfig = elements[elementName];\n\n        if (this.previousData[elementName] === undefined) {\n          this.previousData[elementName] = {};\n        }\n\n        generatedData[elementName] = {\n          attributes: this.generateKnockoutBinding(\"attributes\", elementName, elementConfig, data),\n          style: _config.getMode() === \"Preview\" ? this.generateKnockoutBinding(\"style\", elementName, elementConfig, data) : this.generateKnockoutBindingForBreakpoints(\"style\", elementName, elementConfig, data, dataStoreStates),\n          css: elementConfig.css.var in convertedData ? this.generateKnockoutBinding(\"css\", elementName, elementConfig, data) : {},\n          html: this.generateKnockoutBinding(\"html\", elementName, elementConfig, data)\n        };\n\n        if (elementConfig.tag !== undefined && elementConfig.tag.var !== undefined) {\n          if (generatedData[elementName][elementConfig.tag.var] === undefined) {\n            generatedData[elementName][elementConfig.tag.var] = \"\";\n          }\n\n          generatedData[elementName][elementConfig.tag.var] = convertedData[elementConfig.tag.var];\n        }\n      }\n\n      return generatedData;\n    }\n    /**\n     * Process data for elements before its converted to knockout format\n     *\n     * @param {object} data\n     * @param {ConverterInterface[]} convertersConfig\n     * @returns {object}\n     */\n    ;\n\n    _proto.convertData = function convertData(data, convertersConfig) {\n      for (var _iterator = _createForOfIteratorHelperLoose(convertersConfig), _step; !(_step = _iterator()).done;) {\n        var converterConfig = _step.value;\n        this.massConverterPool.get(converterConfig.component).toDom(data, converterConfig.config);\n      }\n\n      return data;\n    }\n    /**\n     * Generate an individual knockout binding\n     *\n     * @param binding\n     * @param elementName\n     * @param config\n     * @param data\n     */\n    ;\n\n    _proto.generateKnockoutBinding = function generateKnockoutBinding(binding, elementName, config, data) {\n      if (config[binding] === undefined) {\n        return {};\n      }\n\n      var previousData = {};\n\n      if (this.previousData[elementName][binding] !== undefined) {\n        previousData = this.previousData[elementName][binding];\n      }\n\n      if (this.bindingGenerators[binding] === undefined) {\n        _consoleLogger.error(\"Unable to find Knockout binding generator for \" + binding);\n\n        return {};\n      } // Generate the associated binding using our dedicated generators\n\n\n      var generatedBindingData = this.bindingGenerators[binding](elementName, config, data, this.converterResolver, this.converterPool, previousData);\n      this.previousData[elementName][binding] = generatedBindingData;\n      return generatedBindingData;\n    }\n    /**\n     * Generate an individual knockout binding for breakpoints\n     *\n     * @param binding\n     * @param elementName\n     * @param config\n     * @param data\n     * @param dataStoreStates\n     */\n    ;\n\n    _proto.generateKnockoutBindingForBreakpoints = function generateKnockoutBindingForBreakpoints(binding, elementName, config, data, dataStoreStates) {\n      var _this = this;\n\n      var result = {};\n      Object.keys(dataStoreStates).forEach(function (name) {\n        result[name] = _underscore.isEmpty(dataStoreStates[name]) ? {} : _this.generateKnockoutBinding(binding, elementName, config, dataStoreStates[name]);\n      });\n      return result;\n    };\n\n    return ObservableUpdater;\n  }();\n\n  return ObservableUpdater;\n});\n//# sourceMappingURL=observable-updater.js.map","Magento_PageBuilder/js/content-type/master.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/appearance-config\"], function (_underscore, _object, _appearanceConfig) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Master = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Master(contentType, observableUpdater) {\n      this.data = {};\n      this.contentType = contentType;\n      this.observableUpdater = observableUpdater;\n      this.bindEvents();\n    }\n    /**\n     * Retrieve the render template\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Master.prototype;\n\n    /**\n     * Get content type data\n     *\n     * @param {string} element\n     * @returns {DataObject}\n     * @deprecated\n     */\n    _proto.getData = function getData(element) {\n      var data = _underscore.extend({}, this.contentType.dataStore.getState());\n\n      if (undefined === element) {\n        return data;\n      }\n\n      var appearanceConfiguration = (0, _appearanceConfig)(this.contentType.config.name, data.appearance);\n      var config = appearanceConfiguration.elements;\n      data = this.observableUpdater.convertData(data, appearanceConfiguration.converters);\n      var result = {};\n\n      if (undefined !== config[element].tag.var) {\n        result[config[element].tag.var] = (0, _object.get)(data, config[element].tag.var);\n      }\n\n      return result;\n    }\n    /**\n     * Destroys current instance\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      return;\n    }\n    /**\n     * Attach event to updating data in data store to update observables\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this = this;\n\n      this.contentType.dataStore.subscribe(function () {\n        _this.updateObservables();\n      });\n    }\n    /**\n     * After observables updated, allows to modify observables\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      return;\n    }\n    /**\n     * Update observables\n     *\n     * @deprecated\n     */\n    ;\n\n    _proto.updateObservables = function updateObservables() {\n      this.observableUpdater.update(this, _underscore.extend({\n        name: this.contentType.config.name\n      }, this.contentType.dataStore.getState()), this.contentType.getDataStoresStates());\n      this.afterObservablesUpdated();\n    };\n\n    _createClass(Master, [{\n      key: \"template\",\n      get: function get() {\n        return (0, _appearanceConfig)(this.contentType.config.name, this.getData().appearance).master_template;\n      }\n    }]);\n\n    return Master;\n  }();\n\n  return Master;\n});\n//# sourceMappingURL=master.js.map","Magento_PageBuilder/js/content-type/master-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type/master\"], function (_master) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var MasterCollection = /*#__PURE__*/function (_master2) {\n    \"use strict\";\n\n    _inheritsLoose(MasterCollection, _master2);\n\n    function MasterCollection() {\n      return _master2.apply(this, arguments) || this;\n    }\n\n    _createClass(MasterCollection, [{\n      key: \"masterTemplate\",\n      get:\n      /**\n       * Retrieve the child template\n       *\n       * @returns {string}\n       */\n      function get() {\n        return \"Magento_PageBuilder/content-type/master-collection\";\n      }\n    }]);\n\n    return MasterCollection;\n  }(_master);\n\n  return MasterCollection;\n});\n//# sourceMappingURL=master-collection.js.map","Magento_PageBuilder/js/content-type/preview-factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/content-type/observable-updater-factory\", \"Magento_PageBuilder/js/content-type/preview-converter-resolver\"], function (_loader, _observableUpdaterFactory, _previewConverterResolver) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create new preview instance\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {ContentTypeConfigInterface} config\n   * @returns {Promise<Preview | PreviewCollection>}\n   */\n  function create(contentType, config) {\n    return new Promise(function (resolve, reject) {\n      (0, _observableUpdaterFactory)(config, _previewConverterResolver).then(function (observableUpdater) {\n        (0, _loader)([config.preview_component], function (previewComponent) {\n          try {\n            var preview = new previewComponent(contentType, config, observableUpdater);\n            resolve(preview);\n          } catch (error) {\n            reject(\"Error within preview component (\" + config.preview_component + \") for \" + config.name + \".\");\n            console.error(error);\n          }\n        }, function (error) {\n          reject(\"Unable to load preview component (\" + config.preview_component + \") for \" + config.name + \". Please \" + \"check preview component exists and content type configuration is correct.\");\n          console.error(error);\n        });\n      }).catch(function (error) {\n        console.error(error);\n        return null;\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=preview-factory.js.map","Magento_PageBuilder/js/content-type/converter-resolver.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Resolve converter\n   *\n   * @param {DataMappingInterface} config\n   * @return string\n   */\n  function resolve(config) {\n    return config.converter;\n  }\n\n  return resolve;\n});\n//# sourceMappingURL=converter-resolver.js.map","Magento_PageBuilder/js/content-type/appearance-config.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Get config for appearance\n   *\n   * @param {string} contentType\n   * @param {string} appearance\n   * @returns {ContentTypeConfigAppearanceInterface}\n   * @api\n   */\n  function getAppearanceConfig(contentType, appearance) {\n    var contentTypeConfig = _config.getContentTypeConfig(contentType);\n\n    var config;\n\n    if (contentTypeConfig.appearances !== undefined) {\n      if (!appearance) {\n        for (var key in contentTypeConfig.appearances) {\n          if (!!contentTypeConfig.appearances[key].default) {\n            appearance = key;\n            break;\n          }\n        }\n      }\n\n      if (appearance) {\n        config = contentTypeConfig.appearances[appearance];\n      }\n    }\n\n    return config;\n  }\n\n  return getAppearanceConfig;\n});\n//# sourceMappingURL=appearance-config.js.map","Magento_PageBuilder/js/content-type/observable-updater-factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/converter/converter-pool-factory\", \"Magento_PageBuilder/js/mass-converter/converter-pool-factory\", \"Magento_PageBuilder/js/content-type/observable-updater\"], function (_converterPoolFactory, _converterPoolFactory2, _observableUpdater) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create new observable updater instance\n   *\n   * @param {ContentTypeConfigInterface} config\n   * @param {Function} converterResolver\n   * @returns {Promise<ObservableUpdater>}\n   */\n  function create(config, converterResolver) {\n    var promises = [(0, _converterPoolFactory)(config.name), (0, _converterPoolFactory2)(config.name)];\n    return new Promise(function (resolve) {\n      Promise.all(promises).then(function (resolvedPromises) {\n        var converterPool = resolvedPromises[0],\n            massConverterPool = resolvedPromises[1];\n        resolve(new _observableUpdater(converterPool, massConverterPool, converterResolver));\n      }).catch(function (error) {\n        console.error(error);\n        return null;\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=observable-updater-factory.js.map","Magento_PageBuilder/js/content-type/style-registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/string\"], function (_underscore, _string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var styleRegistries = {};\n  var pbStyleAttribute = \"data-pb-style\";\n  var styleDataAttribute = \"data-style-id\";\n\n  var StyleRegistry = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StyleRegistry(identifier) {\n      this.styles = {};\n\n      if (identifier) {\n        styleRegistries[identifier] = this;\n      }\n    }\n    /**\n     * Update styles for selector\n     *\n     * @param selector\n     * @param styles\n     */\n\n\n    var _proto = StyleRegistry.prototype;\n\n    _proto.setStyles = function setStyles(selector, styles) {\n      this.styles[selector] = styles;\n    }\n    /**\n     * Retrieve styles for a selector\n     *\n     * @param selector\n     */\n    ;\n\n    _proto.getStyles = function getStyles(selector) {\n      if (this.styles[selector]) {\n        return this.styles[selector];\n      }\n\n      return {};\n    }\n    /**\n     * Retrieve all styles\n     */\n    ;\n\n    _proto.getAllStyles = function getAllStyles() {\n      return this.styles;\n    };\n\n    return StyleRegistry;\n  }();\n  /**\n   * Return the style registry\n   *\n   * @param id\n   */\n\n\n  function getStyleRegistry(id) {\n    return styleRegistries[id] !== undefined ? styleRegistries[id] : null;\n  }\n  /**\n   * Delete the style registry\n   *\n   * @param id\n   */\n\n\n  function deleteStyleRegistry(id) {\n    if (styleRegistries[id]) {\n      delete styleRegistries[id];\n    }\n  }\n  /**\n   * Generate CSS from styles\n   *\n   * @param styles\n   */\n\n\n  function generateCss(styles) {\n    var generatedCss = \"\";\n    Object.keys(styles).forEach(function (selector) {\n      if (!_underscore.isEmpty(styles[selector])) {\n        generatedCss += generateCssBlock(selector, styles[selector]);\n      }\n    });\n    return generatedCss;\n  }\n  /**\n   * Generate styles from an object\n   *\n   * @param selector\n   * @param styles\n   */\n\n\n  function generateCssBlock(selector, styles) {\n    var generatedStyles = \"\";\n    Object.keys(styles).forEach(function (key) {\n      if (!_underscore.isEmpty(styles[key])) {\n        generatedStyles += (0, _string.fromCamelCaseToDash)(key) + \": \" + styles[key] + \"; \";\n      }\n    });\n    return selector + \" { \" + generatedStyles + \" }\";\n  }\n\n  return Object.assign(StyleRegistry, {\n    getStyleRegistry: getStyleRegistry,\n    deleteStyleRegistry: deleteStyleRegistry,\n    generateCss: generateCss,\n    generateCssBlock: generateCssBlock,\n    pbStyleAttribute: pbStyleAttribute,\n    styleDataAttribute: styleDataAttribute\n  });\n});\n//# sourceMappingURL=style-registry.js.map","Magento_PageBuilder/js/content-type/preview-converter-resolver.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Resolve converter\n   *\n   * @param {DataMappingStyleInterface} config\n   * @return string\n   */\n  function resolve(config) {\n    return config.preview_converter ? config.preview_converter : config.converter;\n  }\n\n  return resolve;\n});\n//# sourceMappingURL=preview-converter-resolver.js.map","Magento_PageBuilder/js/content-type/products/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"slick\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _events, _slick, _underscore, _config, _hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * Define keys which when changed should not trigger the slider to be rebuilt\n     *\n     * @type {string[]}\n     */\n\n    /**\n     * @inheritdoc\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.displayPreview = _knockout.observable(false);\n      _this.previewElement = _jquery.Deferred();\n      _this.widgetUnsanitizedHtml = _knockout.observable();\n      _this.slidesToShow = 5;\n      _this.productItemSelector = \".product-item\";\n      _this.centerModeClass = \"center-mode\";\n      _this.messages = {\n        EMPTY: (0, _translate)(\"Empty Products\"),\n        NO_RESULTS: (0, _translate)(\"No products were found matching your condition\"),\n        LOADING: (0, _translate)(\"Loading...\"),\n        UNKNOWN_ERROR: (0, _translate)(\"An unknown error occurred. Please try again.\")\n      };\n      _this.ignoredKeysForBuild = [\"margins_and_padding\", \"border\", \"border_color\", \"border_radius\", \"border_width\", \"css_classes\", \"text_align\"];\n      _this.placeholderText = _knockout.observable(_this.messages.EMPTY); // Redraw slider after content type gets redrawn\n\n      _events.on(\"contentType:redrawAfter\", function (args) {\n        if (_this.element && _this.element.children) {\n          var $element = (0, _jquery)(_this.element.children);\n\n          if (args.element && $element.closest(args.element).length) {\n            $element.slick(\"setPosition\");\n          }\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        var viewports = _config.getConfig(\"viewports\");\n\n        if (_this.element && _this.appearance() === \"carousel\") {\n          _this.slidesToShow = parseFloat(viewports[args.viewport].options.products.default.slidesToShow);\n\n          _this.destroySlider();\n\n          _this.initSlider();\n        }\n      });\n\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * On afterRender callback.\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.onAfterRender = function onAfterRender(element) {\n      this.element = element;\n      this.previewElement.resolve(element);\n      this.initSlider();\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      var _this2 = this;\n\n      _preview2.prototype.afterObservablesUpdated.call(this);\n\n      var data = this.contentType.dataStore.getState();\n\n      if (this.hasDataChanged(this.previousData, data)) {\n        this.displayPreview(false);\n\n        if (typeof data.conditions_encoded !== \"string\" || data.conditions_encoded.length === 0) {\n          this.placeholderText(this.messages.EMPTY);\n          return;\n        }\n\n        var url = _config.getConfig(\"preview_url\");\n\n        var requestConfig = {\n          // Prevent caching\n          method: \"POST\",\n          data: {\n            role: this.config.name,\n            directive: this.data.main.html()\n          }\n        };\n        this.placeholderText(this.messages.LOADING);\n\n        _jquery.ajax(url, requestConfig).done(function (response) {\n          if (typeof response.data !== \"object\" || !Boolean(response.data.content)) {\n            _this2.placeholderText(_this2.messages.NO_RESULTS);\n\n            return;\n          }\n\n          if (response.data.error) {\n            _this2.widgetUnsanitizedHtml(response.data.error);\n          } else {\n            _this2.widgetUnsanitizedHtml(response.data.content);\n\n            _this2.displayPreview(true);\n          }\n\n          _this2.previewElement.done(function () {\n            (0, _jquery)(_this2.element).trigger(\"contentUpdated\");\n          });\n        }).fail(function () {\n          _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n        });\n      }\n\n      this.previousData = Object.assign({}, data);\n    };\n\n    _proto.initSlider = function initSlider() {\n      if (this.element && this.appearance() === \"carousel\") {\n        (0, _jquery)(this.element.children).slick(this.buildSlickConfig());\n      }\n    };\n\n    _proto.destroySlider = function destroySlider() {\n      (0, _jquery)(this.element.children).slick(\"unslick\");\n    }\n    /**\n     * Build the slick config object\n     *\n     * @returns {{autoplay: boolean; autoplay: number; infinite: boolean; arrows: boolean; dots: boolean;\n     * centerMode: boolean; slidesToScroll: number; slidesToShow: number;}}\n     */\n    ;\n\n    _proto.buildSlickConfig = function buildSlickConfig() {\n      var attributes = this.data.main.attributes();\n      var productCount = (0, _jquery)(this.widgetUnsanitizedHtml()).find(this.productItemSelector).length;\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      var currentViewport = this.viewport();\n      var carouselMode = attributes[\"data-carousel-mode\"];\n      var config = {\n        slidesToShow: this.slidesToShow,\n        slidesToScroll: this.slidesToShow,\n        dots: attributes[\"data-show-dots\"] === \"true\",\n        arrows: attributes[\"data-show-arrows\"] === \"true\",\n        autoplay: attributes[\"data-autoplay\"] === \"true\",\n        autoplaySpeed: parseFloat(attributes[\"data-autoplay-speed\"])\n      };\n      var slidesToShow = viewports[currentViewport].options.products[carouselMode] ? viewports[currentViewport].options.products[carouselMode].slidesToShow : viewports[currentViewport].options.products.default.slidesToShow;\n      config.slidesToShow = parseFloat(slidesToShow);\n\n      if (attributes[\"data-carousel-mode\"] === \"continuous\" && productCount > config.slidesToShow) {\n        config.centerPadding = attributes[\"data-center-padding\"];\n        config.centerMode = true;\n        (0, _jquery)(this.element).addClass(this.centerModeClass);\n      } else {\n        config.infinite = attributes[\"data-infinite-loop\"] === \"true\";\n        (0, _jquery)(this.element).removeClass(this.centerModeClass);\n      }\n\n      return config;\n    }\n    /**\n     * Determine if the data has changed, whilst ignoring certain keys which don't require a rebuild\n     *\n     * @param {DataObject} previousData\n     * @param {DataObject} newData\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.hasDataChanged = function hasDataChanged(previousData, newData) {\n      previousData = _underscore.omit(previousData, this.ignoredKeysForBuild);\n      newData = _underscore.omit(newData, this.ignoredKeysForBuild);\n      return !_underscore.isEqual(previousData, newData);\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/products/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/form/provider',\n    'Magento_PageBuilder/js/form/provider/conditions-data-processor'\n], function (Provider, conditionsDataProcessor) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        save: function () {\n            var data = this.get('data');\n\n            conditionsDataProcessor(data, data['condition_option'] + '_source');\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/content-type/products/appearance/carousel/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'matchMedia',\n    'Magento_PageBuilder/js/utils/breakpoints',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, _, mediaCheck, breakpointsUtils, events) {\n    'use strict';\n\n    /**\n     * Build slick\n     *\n     * @param {jQuery} $carouselElement\n     * @param {Object} config\n     */\n    function buildSlick($carouselElement, config) {\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($carouselElement.hasClass('slick-initialized')) {\n            $carouselElement.slick('unslick');\n        }\n\n        config.slidesToScroll = config.slidesToShow;\n        $carouselElement.slick(config);\n    }\n\n    /**\n     * Initialize slider.\n     *\n     * @param {jQuery} $element\n     * @param {Object} slickConfig\n     * @param {Object} breakpoint\n     */\n    function initSlider($element, slickConfig, breakpoint) {\n        var productCount = $element.find('.product-item').length,\n            $carouselElement = $($element.children()),\n            centerModeClass = 'center-mode',\n            carouselMode = $element.data('carousel-mode'),\n            slidesToShow = breakpoint.options.products[carouselMode] ?\n                breakpoint.options.products[carouselMode].slidesToShow :\n                breakpoint.options.products.default.slidesToShow;\n\n        slickConfig.slidesToShow = parseFloat(slidesToShow);\n\n        if (carouselMode === 'continuous' && productCount > slickConfig.slidesToShow) {\n            $element.addClass(centerModeClass);\n            slickConfig.centerPadding = $element.data('center-padding');\n            slickConfig.centerMode = true;\n        } else {\n            $element.removeClass(centerModeClass);\n            slickConfig.infinite = $element.data('infinite-loop');\n        }\n\n        buildSlick($carouselElement, slickConfig);\n    }\n\n    return function (config, element) {\n        var $element = $(element),\n            $carouselElement = $($element.children()),\n            currentViewport = config.currentViewport,\n            currentBreakpoint = config.breakpoints[currentViewport],\n            slickConfig = {\n                autoplay: $element.data('autoplay'),\n                autoplaySpeed: $element.data('autoplay-speed') || 0,\n                arrows: $element.data('show-arrows'),\n                dots: $element.data('show-dots')\n            };\n\n        _.each(config.breakpoints, function (breakpoint) {\n            mediaCheck({\n                media: breakpointsUtils.buildMedia(breakpoint.conditions),\n\n                /** @inheritdoc */\n                entry: function () {\n                    initSlider($element, slickConfig, breakpoint);\n                }\n            });\n        });\n\n        //initialize slider when content type is added in mobile viewport\n        if (currentViewport === 'mobile') {\n            initSlider($element, slickConfig, currentBreakpoint);\n        }\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($carouselElement.closest(args.element).length) {\n                $carouselElement.slick('setPosition');\n            }\n        });\n\n        events.on('stage:viewportChangeAfter', function (args) {\n            var breakpoint = config.breakpoints[args.viewport];\n\n            initSlider($element, slickConfig, breakpoint);\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/products/mass-converter/carousel-widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.carousel_products_count = attributes.products_count;\n      data.sort_order = attributes.sort_order;\n      data.condition_option = attributes.condition_option || \"condition\";\n      data[data.condition_option] = this.decodeWysiwygCharacters(attributes.condition_option_value || \"\");\n      data.conditions_encoded = this.decodeWysiwygCharacters(attributes.conditions_encoded || \"\");\n      data[data.condition_option + \"_source\"] = data.conditions_encoded;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\CatalogWidget\\\\Block\\\\Product\\\\ProductsList\",\n        template: \"Magento_PageBuilder::catalog/product/widget/content/carousel.phtml\",\n        anchor_text: \"\",\n        id_path: \"\",\n        show_pager: 0,\n        products_count: data.carousel_products_count,\n        condition_option: data.condition_option,\n        condition_option_value: \"\",\n        type_name: \"Catalog Products Carousel\",\n        conditions_encoded: this.encodeWysiwygCharacters(data.conditions_encoded || \"\")\n      };\n\n      if (data.sort_order) {\n        attributes.sort_order = data.sort_order;\n      }\n\n      if (typeof data[data.condition_option] === \"string\") {\n        attributes.condition_option_value = this.encodeWysiwygCharacters(data[data.condition_option]);\n      }\n\n      if (attributes.conditions_encoded.length === 0) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.encodeWysiwygCharacters = function encodeWysiwygCharacters(content) {\n      return content.replace(/\\{/g, \"^[\").replace(/\\}/g, \"^]\").replace(/\"/g, \"`\").replace(/\\\\/g, \"|\").replace(/</g, \"&lt;\").replace(/>/g, \"&gt;\");\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeWysiwygCharacters = function decodeWysiwygCharacters(content) {\n      return content.replace(/\\^\\[/g, \"{\").replace(/\\^\\]/g, \"}\").replace(/`/g, \"\\\"\").replace(/\\|/g, \"\\\\\").replace(/&lt;/g, \"<\").replace(/&gt;/g, \">\");\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=carousel-widget-directive.js.map","Magento_PageBuilder/js/content-type/products/mass-converter/widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.products_count = attributes.products_count;\n      data.sort_order = attributes.sort_order;\n      data.condition_option = attributes.condition_option || \"condition\";\n      data[data.condition_option] = this.decodeWysiwygCharacters(attributes.condition_option_value || \"\");\n      data.conditions_encoded = this.decodeWysiwygCharacters(attributes.conditions_encoded || \"\");\n      data[data.condition_option + \"_source\"] = data.conditions_encoded;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\CatalogWidget\\\\Block\\\\Product\\\\ProductsList\",\n        template: \"Magento_CatalogWidget::product/widget/content/grid.phtml\",\n        anchor_text: \"\",\n        id_path: \"\",\n        show_pager: 0,\n        products_count: data.products_count,\n        condition_option: data.condition_option,\n        condition_option_value: \"\",\n        type_name: \"Catalog Products List\",\n        conditions_encoded: this.encodeWysiwygCharacters(data.conditions_encoded || \"\")\n      };\n\n      if (data.sort_order) {\n        attributes.sort_order = data.sort_order;\n      }\n\n      if (typeof data[data.condition_option] === \"string\") {\n        attributes.condition_option_value = this.encodeWysiwygCharacters(data[data.condition_option]);\n      }\n\n      if (attributes.conditions_encoded.length === 0) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.encodeWysiwygCharacters = function encodeWysiwygCharacters(content) {\n      return content.replace(/\\{/g, \"^[\").replace(/\\}/g, \"^]\").replace(/\"/g, \"`\").replace(/\\\\/g, \"|\").replace(/</g, \"&lt;\").replace(/>/g, \"&gt;\");\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeWysiwygCharacters = function decodeWysiwygCharacters(content) {\n      return content.replace(/\\^\\[/g, \"{\").replace(/\\^\\]/g, \"}\").replace(/`/g, \"\\\"\").replace(/\\|/g, \"\\\\\").replace(/&lt;/g, \"<\").replace(/&gt;/g, \">\");\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=widget-directive.js.map","Magento_PageBuilder/js/content-type/root-container/content-type-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_Ui/js/modal/alert\", \"Magento_PageBuilder/js/content-type-collection\"], function (_alert, _contentTypeCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var RootContainer = /*#__PURE__*/function (_contentTypeCollectio) {\n    \"use strict\";\n\n    _inheritsLoose(RootContainer, _contentTypeCollectio);\n\n    function RootContainer() {\n      return _contentTypeCollectio.apply(this, arguments) || this;\n    }\n\n    var _proto = RootContainer.prototype;\n\n    /**\n     * Remove a child from the observable array\n     *\n     * @param child\n     */\n    _proto.removeChild = function removeChild(child) {\n      if (this.getChildren().length === 1) {\n        (0, _alert)({\n          content: $t(\"You are not able to remove the final row from the content.\"),\n          title: $t(\"Unable to Remove\")\n        });\n        return;\n      }\n\n      _contentTypeCollectio.prototype.removeChild.call(this, child);\n    };\n\n    return RootContainer;\n  }(_contentTypeCollection);\n\n  return RootContainer;\n});\n//# sourceMappingURL=content-type-collection.js.map","Magento_PageBuilder/js/content-type/tabs/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"tabs\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _tabs, _underscore, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _promiseDeferred, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Wait for the tabs instance to mount and the container to be ready\n\n      _this.focusedTab = _knockout.observable(null);\n      _this.activeTab = _knockout.observable(0);\n      _this.onContainerRenderDeferred = (0, _promiseDeferred)();\n      _this.mountAfterDeferred = (0, _promiseDeferred)();\n      Promise.all([_this.onContainerRenderDeferred.promise, _this.mountAfterDeferred.promise]).then(function (_ref) {\n        var element = _ref[0],\n            expectedChildren = _ref[1];\n        // We always create 1 tab when dropping tabs into the instance\n        expectedChildren = expectedChildren || 1; // Wait until all children's DOM elements are present before building the tabs instance\n\n        (0, _delayUntil)(function () {\n          _this.element = element;\n\n          _this.buildTabs();\n        }, function () {\n          return (0, _jquery)(element).find(\".pagebuilder-tab-item\").length === expectedChildren;\n        });\n      }); // Resolve our deferred when the tabs item mounts with expect children\n\n      _events.on(\"tabs:mountAfter\", function (args) {\n        if (args.contentType.id === _this.contentType.id && args.expectChildren !== undefined) {\n          _this.mountAfterDeferred.resolve(args.expectChildren);\n        }\n      });\n\n      _events.on(\"tab-item:mountAfter\", function (args) {\n        if (_this.element && args.contentType.parentContentType.id === _this.contentType.id) {\n          _this.refreshTabs();\n        }\n      });\n\n      _events.on(\"tab-item:renderAfter\", function (args) {\n        if (_this.element && args.contentType.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.refreshTabs();\n          });\n        }\n      }); // Set the active tab to the new position of the sorted tab\n\n\n      _events.on(\"tab-item:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _this.refreshTabs(); // We need to wait for the tabs to refresh before executing the focus\n\n\n          _underscore.defer(function () {\n            var newPosition = args.index > 0 ? args.index - 1 : 0;\n\n            _this.setFocusedTab(newPosition, true);\n          });\n        }\n      }); // Refresh tab contents and set the focus to the new position of the sorted tab\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this.contentType.id) {\n          _this.refreshTabs(args.newPosition, true);\n          /**\n           * Update the default active tab if its position was affected by the sorting\n           */\n\n\n          var defaultActiveTab = +_this.activeTab();\n          var newDefaultActiveTab = defaultActiveTab;\n\n          if (args.originalPosition === defaultActiveTab) {\n            newDefaultActiveTab = args.newPosition;\n          } else if (args.originalPosition < defaultActiveTab && args.newPosition >= defaultActiveTab) {\n            // a tab was moved from the left of the default active tab the right of it, changing its index\n            newDefaultActiveTab--;\n          } else if (args.originalPosition > defaultActiveTab && args.newPosition <= defaultActiveTab) {\n            // a tab was moved from the right of the default active tab the left of it, changing its index\n            newDefaultActiveTab++;\n          }\n\n          _this.updateData(\"default_active\", newDefaultActiveTab.toString());\n        }\n      }); // Monitor focus tab to start / stop interaction on the stage, debounce to avoid duplicate calls\n\n\n      _this.focusedTab.subscribe(_underscore.debounce(function (index) {\n        if (index !== null) {\n          _events.trigger(\"stage:interactionStart\");\n\n          (0, _delayUntil)(function () {\n            return (0, _jquery)((0, _jquery)(_this.wrapperElement).find(\".tab-header\")[index]).find(\"[contenteditable]\").focus();\n          }, function () {\n            return (0, _jquery)((0, _jquery)(_this.wrapperElement).find(\".tab-header\")[index]).find(\"[contenteditable]\").length > 0;\n          }, 10);\n        } else {\n          // We have to force the stop as the event firing is inconsistent for certain operations\n          _events.trigger(\"stage:interactionStop\", {\n            force: true\n          });\n        }\n      }, 1));\n\n      return _this;\n    }\n    /**\n     * Remove focused tab\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.destroy = function destroy() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.destroy.call(this);\n\n      _underscore.defer(function () {\n        return _this2.setFocusedTab(null);\n      });\n    }\n    /**\n     * Refresh the tabs instance when new content appears\n     *\n     * @param {number} focusIndex\n     * @param {boolean} forceFocus\n     * @param {number} activeIndex\n     */\n    ;\n\n    _proto.refreshTabs = function refreshTabs(focusIndex, forceFocus, activeIndex) {\n      try {\n        (0, _jquery)(this.element).tabs(\"refresh\");\n\n        if (focusIndex >= 0) {\n          this.setFocusedTab(focusIndex, forceFocus);\n        } else if (activeIndex) {\n          this.setActiveTab(activeIndex);\n        } // update sortability of tabs\n\n\n        var sortableElement = (0, _jquery)(this.element).find(\".tabs-navigation\");\n\n        if (sortableElement.hasClass(\"ui-sortable\")) {\n          if (this.contentType.children().length <= 1) {\n            sortableElement.sortable(\"disable\");\n          } else {\n            sortableElement.sortable(\"enable\");\n          }\n        }\n      } catch (e) {\n        this.buildTabs();\n      }\n    }\n    /**\n     * Set the active tab, we maintain a reference to it in an observable for when we rebuild the tab instance\n     *\n     * @param {number} index\n     */\n    ;\n\n    _proto.setActiveTab = function setActiveTab(index) {\n      var _this3 = this;\n\n      if (index !== null) {\n        // Added to prevent mismatched fragment error caused by not yet rendered tab-item\n        index = parseInt(index.toString(), 10);\n        (0, _delayUntil)(function () {\n          (0, _jquery)(_this3.element).tabs(\"option\", \"active\", index);\n\n          _this3.activeTab(index);\n\n          _events.trigger(\"contentType:redrawAfter\", {\n            id: _this3.contentType.id,\n            contentType: _this3\n          });\n        }, function () {\n          return (0, _jquery)(_this3.element).find(\".pagebuilder-tab-item\").length >= index + 1;\n        });\n      }\n    }\n    /**\n     * Set the focused tab\n     *\n     * @param {number} index\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.setFocusedTab = function setFocusedTab(index, force) {\n      if (force === void 0) {\n        force = false;\n      }\n\n      this.setActiveTab(index);\n\n      if (force) {\n        this.focusedTab(null);\n      }\n\n      this.focusedTab(index);\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add\"),\n        action: this.addTab,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Add a tab\n     */\n    ;\n\n    _proto.addTab = function addTab() {\n      var _this4 = this;\n\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"tab-item\"), this.contentType, this.contentType.stageId).then(function (tab) {\n        _events.on(\"tab-item:mountAfter\", function (args) {\n          if (args.id === tab.id) {\n            _this4.setFocusedTab(_this4.contentType.children().length - 1);\n\n            _events.off(\"tab-item:\" + tab.id + \":mountAfter\");\n          }\n        }, \"tab-item:\" + tab.id + \":mountAfter\");\n\n        _this4.contentType.addChild(tab, _this4.contentType.children().length); // Update the default tab title when adding a new tab\n\n\n        tab.dataStore.set(\"tab_name\", (0, _translate)(\"Tab\") + \" \" + (_this4.contentType.children.indexOf(tab) + 1));\n      });\n    }\n    /**\n     * On render init the tabs widget\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.onContainerRender = function onContainerRender(element) {\n      this.element = element;\n      this.onContainerRenderDeferred.resolve(element);\n    }\n    /**\n     * Copy over border styles to the tab headers\n     *\n     * @returns {any}\n     */\n    ;\n\n    _proto.getTabHeaderStyles = function getTabHeaderStyles() {\n      var headerStyles = this.data.headers.style();\n      return _extends({}, headerStyles, {\n        marginBottom: \"-\" + headerStyles.borderWidth,\n        marginLeft: \"-\" + headerStyles.borderWidth\n      });\n    }\n    /**\n     * Get the sortable options for the tab heading sorting\n     *\n     * @returns {JQueryUI.SortableOptions}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions() {\n      var self = this;\n      var borderWidth;\n      return {\n        handle: \".tab-drag-handle\",\n        tolerance: \"pointer\",\n        cursor: \"grabbing\",\n        cursorAt: {\n          left: 8,\n          top: 25\n        },\n\n        /**\n         * Provide custom helper element\n         *\n         * @param {Event} event\n         * @param {JQueryUI.Sortable} element\n         * @returns {Element}\n         */\n        helper: function helper(event, element) {\n          var helper = (0, _jquery)(element).clone().css(\"opacity\", \"0.7\");\n          helper[0].querySelector(\".pagebuilder-options\").remove();\n          return helper[0];\n        },\n\n        /**\n         * Add a padding to the navigation UL to resolve issues of negative margins when sorting\n         *\n         * @param {Event} event\n         * @param {JQueryUI.SortableUIParams} ui\n         */\n        start: function start(event, ui) {\n          /**\n           * Due to the way we use negative margins to overlap the borders we need to apply a padding to the\n           * container when we're moving the first item to ensure the tabs remain in the same place.\n           */\n          if (ui.item.index() === 0) {\n            borderWidth = parseInt(ui.item.css(\"borderWidth\"), 10) || 1;\n            (0, _jquery)(this).css(\"paddingLeft\", borderWidth);\n          }\n\n          ui.helper.css(\"width\", \"\");\n\n          _events.trigger(\"stage:interactionStart\");\n\n          self.disableInteracting = true;\n        },\n\n        /**\n         * Remove the padding once the operation is completed\n         *\n         * @param {Event} event\n         * @param {JQueryUI.SortableUIParams} ui\n         */\n        stop: function stop(event, ui) {\n          (0, _jquery)(this).css(\"paddingLeft\", \"\");\n\n          _events.trigger(\"stage:interactionStop\");\n\n          self.disableInteracting = false;\n        },\n        placeholder: {\n          /**\n           * Provide custom placeholder element\n           *\n           * @param {JQuery} item\n           * @returns {JQuery}\n           */\n          element: function element(item) {\n            var placeholder = item.clone().css({\n              display: \"inline-block\",\n              opacity: \"0.3\"\n            }).removeClass(\"focused\").addClass(\"sortable-placeholder\");\n            placeholder[0].querySelector(\".pagebuilder-options\").remove();\n            return placeholder[0];\n          },\n          update: function update() {\n            return;\n          }\n        }\n      };\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this5 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this); // ContentType being mounted onto container\n\n\n      _events.on(\"tabs:dropAfter\", function (args) {\n        if (args.id === _this5.contentType.id && _this5.contentType.children().length === 0) {\n          _this5.addTab();\n        }\n      }); // ContentType being removed from container\n\n\n      _events.on(\"tab-item:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this5.contentType.id) {\n          // Mark the previous tab as active\n          var newIndex = args.index - 1 >= 0 ? args.index - 1 : 0;\n\n          _this5.refreshTabs(newIndex, true);\n        }\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedTab;\n      var duplicatedTabIndex;\n\n      _events.on(\"tab-item:duplicateAfter\", function (args) {\n        if (_this5.contentType.id === args.duplicateContentType.parentContentType.id && args.direct) {\n          var tabData = args.duplicateContentType.dataStore.getState();\n          args.duplicateContentType.dataStore.set(\"tab_name\", tabData.tab_name.toString() + \" copy\");\n          duplicatedTab = args.duplicateContentType;\n          duplicatedTabIndex = args.index;\n        }\n      });\n\n      _events.on(\"tab-item:mountAfter\", function (args) {\n        if (duplicatedTab && args.id === duplicatedTab.id) {\n          _this5.refreshTabs(duplicatedTabIndex, true);\n\n          duplicatedTab = duplicatedTabIndex = null;\n        }\n\n        if (_this5.contentType.id === args.contentType.parentContentType.id) {\n          _this5.updateTabNamesInDataStore();\n\n          args.contentType.dataStore.subscribe(function () {\n            _this5.updateTabNamesInDataStore();\n          });\n        }\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _this5.activeTab(data.default_active);\n      });\n    }\n    /**\n     * Update data store with active options\n     */\n    ;\n\n    _proto.updateTabNamesInDataStore = function updateTabNamesInDataStore() {\n      var activeOptions = [];\n      this.contentType.children().forEach(function (tab, index) {\n        var tabData = tab.dataStore.getState();\n        activeOptions.push({\n          label: tabData.tab_name.toString(),\n          labeltitle: tabData.tab_name.toString(),\n          value: index\n        });\n      });\n      this.contentType.dataStore.set(\"_default_active_options\", activeOptions);\n    }\n    /**\n     * Assign a debounce and delay to the init of tabs to ensure the DOM has updated\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n    ;\n\n    _proto.buildTabs = function buildTabs(activeTabIndex) {\n      var _this6 = this;\n\n      if (activeTabIndex === void 0) {\n        activeTabIndex = this.activeTab() || 0;\n      }\n\n      this.ready = false;\n\n      if (this.element && this.element.children.length > 0) {\n        var focusedTab = this.focusedTab();\n\n        try {\n          (0, _jquery)(this.element).tabs(\"destroy\");\n        } catch (e) {// We aren't concerned if this fails, tabs throws an Exception when we cannot destroy\n        }\n\n        (0, _jquery)(this.element).tabs({\n          create: function create() {\n            _this6.ready = true; // Ensure focus tab is restored after a rebuild cycle\n\n            if (focusedTab !== null) {\n              _this6.setFocusedTab(focusedTab, true);\n            } else {\n              _this6.setFocusedTab(null);\n\n              if (activeTabIndex) {\n                _this6.setActiveTab(activeTabIndex);\n              }\n            }\n          },\n\n          /**\n           * Trigger redraw event since new content is being displayed\n           */\n          activate: function activate() {\n            _events.trigger(\"contentType:redrawAfter\", {\n              element: _this6.element\n            });\n          }\n        });\n      }\n    };\n\n    return Preview;\n  }(_previewCollection); // Resolve issue with jQuery UI tabs content typing events on content editable areas\n\n\n  var originalTabKeyDown = _jquery.ui.tabs.prototype._tabKeydown;\n\n  _jquery.ui.tabs.prototype._tabKeydown = function (event) {\n    // If the target is content editable don't handle any events\n    if ((0, _jquery)(event.target).attr(\"contenteditable\")) {\n      return;\n    }\n\n    originalTabKeyDown.call(this, event);\n  };\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/tabs/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'jquery-ui-modules/tabs'\n], function ($, events) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element);\n\n        // Ignore stage builder preview tabs\n        if ($element.is('.pagebuilder-tabs')) {\n            return;\n        }\n\n        // Disambiguate between the mage/tabs component which is loaded randomly depending on requirejs order.\n        $.ui.tabs({\n            active: $element.data('activeTab') || 0,\n            create:\n\n                /**\n                 * Adjust the margin bottom of the navigation to correctly display the active tab\n                 */\n                function () {\n                    var borderWidth = parseInt($element.find('.tabs-content').css('borderWidth').toString(), 10);\n\n                    $element.find('.tabs-navigation').css('marginBottom', -borderWidth);\n                    $element.find('.tabs-navigation li:not(:first-child)').css('marginLeft', -borderWidth);\n                },\n            activate:\n\n                /**\n                 * Trigger redraw event since new content is being displayed\n                 */\n                function () {\n                    events.trigger('contentType:redrawAfter', {\n                        element: element\n                    });\n                }\n        }, element);\n    };\n});\n","Magento_PageBuilder/js/content-type/tabs/mass-converter/header-alignment.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var HeaderAlignment = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function HeaderAlignment() {}\n\n    var _proto = HeaderAlignment.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      return data;\n    }\n    /**\n     * Add our tab alignment class into the data for the tabs\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      data.css_classes += \" tab-align-\" + (0, _object.get)(data, config.navigation_alignment_variable, \"left\");\n      return data;\n    };\n\n    return HeaderAlignment;\n  }();\n\n  return HeaderAlignment;\n});\n//# sourceMappingURL=header-alignment.js.map","Magento_PageBuilder/js/content-type/heading/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-toolbar\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _events, _underscore, _hideShowOption, _contentTypeToolbar, _promiseDeferred, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.afterRenderDeferred = (0, _promiseDeferred)();\n      _this.toolbar = new _contentTypeToolbar(_assertThisInitialized(_this), _this.getToolbarOptions());\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * On render init the heading\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.afterRender = function afterRender(element) {\n      this.element = element;\n      this.afterRenderDeferred.resolve(element);\n    };\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _preview2.prototype.bindEvents.call(this); // When a heading is dropped for the first time show heading toolbar\n\n\n      _events.on(\"heading:dropAfter\", function (args) {\n        if (args.id === _this2.contentType.id) {\n          Promise.all([_this2.afterRenderDeferred.promise, _this2.toolbar.afterRenderDeferred.promise]).then(function (_ref) {\n            var element = _ref[0];\n\n            _underscore.defer(function () {\n              (0, _jquery)(element).focus();\n            });\n          });\n        }\n      });\n    }\n    /**\n     * Get option value from observable data.\n     *\n     * @param {string} key\n     * @return {*}\n     */\n    ;\n\n    _proto.getOptionValue = function getOptionValue(key) {\n      if (key === \"heading_type\") {\n        return this.data.main.heading_type();\n      } else if (key === \"text_align\") {\n        return this.data.main.style().textAlign;\n      }\n\n      return;\n    }\n    /**\n     * Build and return the tool bar options for heading\n     *\n     * @returns {OptionInterface[]}\n     */\n    ;\n\n    _proto.getToolbarOptions = function getToolbarOptions() {\n      return [{\n        key: \"heading_type\",\n        type: \"select\",\n        values: [{\n          value: \"h1\",\n          label: \"H1\",\n          icon: \"\"\n        }, {\n          value: \"h2\",\n          label: \"H2\",\n          icon: \"\"\n        }, {\n          value: \"h3\",\n          label: \"H3\",\n          icon: \"\"\n        }, {\n          value: \"h4\",\n          label: \"H4\",\n          icon: \"\"\n        }, {\n          value: \"h5\",\n          label: \"H5\",\n          icon: \"\"\n        }, {\n          value: \"h6\",\n          label: \"H6\",\n          icon: \"\"\n        }]\n      }, {\n        key: \"text_align\",\n        type: \"select\",\n        values: [{\n          value: \"left\",\n          label: \"Left\",\n          icon: \"icon-pagebuilder-align-left\"\n        }, {\n          value: \"center\",\n          label: \"Center\",\n          icon: \"icon-pagebuilder-align-center\"\n        }, {\n          value: \"right\",\n          label: \"Right\",\n          icon: \"icon-pagebuilder-align-right\"\n        }]\n      }];\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/text/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _events, _underscore, _hideShowOption, _delayUntil, _editor, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.afterRenderDeferred = _jquery.Deferred();\n      _this.handledDoubleClick = false;\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * @returns {Boolean}\n     */\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.main.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.main.html();\n        }\n      }, \"content\");\n      this.afterRenderDeferred.resolve(element);\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(true);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this3 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n      wysiwygConfig.adapter.settings.paste_as_text = true;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function () {\n          _underscore.defer(function () {\n            _this3.element.blur();\n\n            _this3.element.focus();\n          });\n        };\n      }\n\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"content\", this.contentType.stageId).then(function (wysiwyg) {\n        _this3.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this4 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this4.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this4.handledDoubleClick = true;\n\n              _this4.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this4.element);\n            }, function () {\n              return _this4.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this5 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this5.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this6 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"content\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this6.textarea.value = _this6.contentType.dataStore.get(\"content\");\n\n        _this6.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"content\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Retrieve the margin & padding & alignment styles for the placeholder\n     *\n     * @returns {any}\n     */\n    ;\n\n    _proto.getPlaceholderStyle = function getPlaceholderStyle() {\n      var keys = [\"marginBottom\", \"marginLeft\", \"marginRight\", \"marginTop\", \"paddingBottom\", \"paddingLeft\", \"paddingRight\", \"paddingTop\", \"textAlign\"];\n      return _underscore.pick(this.data.main.style(), function (style, key) {\n        return keys.indexOf(key) !== -1;\n      });\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this7 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      this.contentType.dataStore.subscribe(function (state) {\n        var sanitizedContent = (0, _editor.replaceDoubleQuoteWithSingleQuoteWithinVariableDirective)((0, _editor.escapeDoubleQuoteWithinWidgetDirective)(state.content));\n\n        if (sanitizedContent !== state.content) {\n          state.content = sanitizedContent;\n        }\n      }); // After drop of new content type open TinyMCE and focus\n\n      _events.on(\"text:dropAfter\", function (args) {\n        if (args.id === _this7.contentType.id) {\n          _this7.afterRenderDeferred.then(function () {\n            if (_this7.isWysiwygSupported()) {\n              _this7.initWysiwygFromClick(true);\n            }\n          });\n        }\n      });\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/text/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\"], function (_jquery, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {}\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * The editor element\n     */\n\n    /**\n     * The configuration of the wysiwyg content type\n     */\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n    }\n    /**\n     * Called when tinymce is focused\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this = this;\n\n      // If there isn't enough room for a left-aligned toolbar, right align it\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this.$element.closest(selector).css(\"z-index\", 100);\n      });\n    }\n    /**\n     * Called when tinymce is blurred\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this2 = this;\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this2.$element.closest(selector).css(\"z-index\", \"\");\n      });\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/text/wysiwyg/tinymce/config-modifier.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConfigModifier = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConfigModifier() {}\n\n    var _proto = ConfigModifier.prototype;\n\n    /**\n     * Initialize the config\n     *\n     * @param {String} contentTypeId\n     * @param {Object} config\n     */\n    _proto.modify = function modify(contentTypeId, config) {\n      if (config.adapter_config.mode === \"inline\") {\n        config.adapter.settings.fixed_toolbar_container = \"#\" + contentTypeId + \" \" + config.adapter.settings.fixed_toolbar_container;\n      }\n    };\n\n    return ConfigModifier;\n  }();\n\n  return ConfigModifier;\n});\n//# sourceMappingURL=config-modifier.js.map","Magento_PageBuilder/js/content-type/row/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/resource/resize-observer/ResizeObserver\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jarallax, _jarallaxVideo, _jquery, _knockout, _events, _ResizeObserver, _underscore, _vimeoWrapper, _hideShowOption, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Debounce and defer the init of Jarallax\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.wrapClass = _knockout.observable(false);\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.element, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.element && (0, _jquery)(_this.element).hasClass(\"jarallax\") && _this.contentType.dataStore.get(\"background_type\") !== \"video\" && _this.contentType.dataStore.get(\"background_image\").length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            var parallaxSpeed = Number.parseFloat(_this.contentType.dataStore.get(\"parallax_speed\"));\n            jarallax(_this.element, {\n              imgPosition: _this.contentType.dataStore.get(\"background_position\") || \"50% 50%\",\n              imgRepeat: _this.contentType.dataStore.get(\"background_repeat\") || \"no-repeat\",\n              imgSize: _this.contentType.dataStore.get(\"background_size\") || \"cover\",\n              speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n            });\n            jarallax(_this.element, \"onResize\");\n          });\n        }\n\n        if (_this.element && _this.element.dataset.backgroundType === \"video\" && _this.element.dataset.videoSrc.length) {\n          var parallaxSpeed = _this.contentType.dataStore.get(\"enable_parallax\") === \"1\" ? Number.parseFloat(_this.contentType.dataStore.get(\"parallax_speed\")) : 1;\n\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            jarallax(_this.element, {\n              videoSrc: _this.element.dataset.videoSrc,\n              imgSrc: _this.element.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.element.jarallax && _this.element.jarallax.video) {\n              // @ts-ignore\n              _this.element.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.element.jarallax.$video) {\n                  // @ts-ignore\n                  _this.element.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n\n      _this.contentType.dataStore.subscribe(_this.buildJarallax);\n\n      _events.on(\"row:mountAfter\", function (args) {\n        if (args.id === _this.contentType.id) {\n          _this.buildJarallax();\n        }\n      });\n\n      _events.on(\"contentType:mountAfter\", function (args) {\n        if (args.contentType.parentContentType && args.contentType.parentContentType.id === _this.contentType.id) {\n          _this.buildJarallax();\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.toggleFullScreen.bind(_assertThisInitialized(_this)));\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this.buildJarallax();\n      });\n\n      return _this;\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Toggle fullscreen\n     */\n    ;\n\n    _proto.toggleFullScreen = function toggleFullScreen() {\n      if ((0, _jquery)(this.element).hasClass(\"jarallax\")) {\n        this.buildJarallax();\n      }\n    }\n    /**\n     * Use the conditional remove to disable the option when the content type has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this2 = this;\n\n      this.element = element;\n\n      _underscore.defer(function () {\n        _this2.buildJarallax();\n      });\n\n      new _ResizeObserver(function () {\n        // Observe for resizes of the element and force jarallax to display correctly\n        if ((0, _jquery)(_this2.element).hasClass(\"jarallax\") && _this2.contentType.dataStore.get(\"background_image\").length) {\n          jarallax(_this2.element, \"onResize\");\n          jarallax(_this2.element, \"onScroll\");\n        }\n      }).observe(this.element);\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _previewCollection2.prototype.destroy.call(this);\n\n      if (this.element) {\n        jarallax(this.element, \"destroy\");\n      }\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/row/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/widget/video-background',\n    'jarallax'\n], function ($, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = null,\n            elementStyle = null;\n\n        if ($element.data('appearance') === 'contained') {\n            $element = $(element).find('[data-element=\"inner\"]');\n        }\n\n        if ($element.data('background-type') === 'video') {\n            videoBackground(config, $element[0]);\n\n            return;\n        }\n\n        if ($element.data('enableParallax') !== 1) {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        parallaxSpeed = parseFloat($element.data('parallaxSpeed'));\n        elementStyle = window.getComputedStyle($element[0]);\n\n        window.jarallax($element[0], {\n            imgPosition: elementStyle.backgroundPosition || '50% 50%',\n            imgRepeat: elementStyle.backgroundRepeat || 'no-repeat',\n            imgSize: elementStyle.backgroundSize || 'cover',\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/row/appearance/default/widget-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(['underscore', 'jquery', 'Magento_PageBuilder/js/events'], function (_, $, events) {\n    'use strict';\n\n    return function (target) {\n        return function (config, element) {\n            var result = target(config, element),\n                stageId = $(element).parents('[data-role=\"pagebuilder-stage\"]').attr('id'),\n                $element = $(element);\n\n            if ($element.data('appearance') === 'contained') {\n                $element = $(element).find('[data-element=\"inner\"]');\n            }\n\n            // If Parallax isn't enabled, let's not attach the event\n            if ($element.data('enableParallax') !== 1) {\n                return result;\n            }\n\n            // Listen for full screen events and destroy and rebuild jarallax\n            events.on('stage:' + stageId + ':fullScreenModeChangeAfter', function () {\n                _.delay(function () {\n                    $element.jarallax('destroy');\n                    target(config, element);\n                }, 350);\n            });\n\n            return result;\n        };\n    };\n});\n","Magento_PageBuilder/js/content-type/row/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * @param {string} value\n     * @returns {Object | string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/content-type/row/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * @param {string} value\n     * @returns {Object | string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = (parseInt(value.margin.bottom, 10) > 0 ? value.margin.bottom : 1) + \"px\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/video/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    _proto.isHosted = function isHosted(src) {\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      return vimeoRegExp.test(src) || youtubeRegExp.test(src);\n    }\n    /**\n     * After render callback\n     *\n     * @param {HTMLVideoElement} videoElement\n     * @param {Preview} self\n     */\n    ;\n\n    _proto.onAfterRender = function onAfterRender(videoElement, self) {\n      // Assign muted attribute explicitly due to API issues\n      videoElement.muted = self.data.video.attributes().autoplay;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/video/master.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type/master\"], function (_master) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Master = /*#__PURE__*/function (_master2) {\n    \"use strict\";\n\n    _inheritsLoose(Master, _master2);\n\n    function Master() {\n      return _master2.apply(this, arguments) || this;\n    }\n\n    var _proto = Master.prototype;\n\n    _proto.isHosted = function isHosted(src) {\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      return vimeoRegExp.test(src) || youtubeRegExp.test(src);\n    };\n\n    return Master;\n  }(_master);\n\n  return Master;\n});\n//# sourceMappingURL=master.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/videosrc.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoSrc = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoSrc() {}\n\n    /**\n     * Parse YouTube parameters from given URL and Autoplay setting from UI\n     *\n     * @param url string\n     * @param data DataObject\n     * @returns string\n     * @private\n     */\n    VideoSrc.parseYoutubeGetParams = function parseYoutubeGetParams(url, data) {\n      var acceptableYouTubeParams = [\"rel\", \"controls\", \"autoplay\", \"mute\", \"loop\", \"playlist\", \"cc_lang_pref\", \"cc_load_policy\", \"color\", \"disablekb\", \"end\", \"fs\", \"hl\", \"iv_load_policy\", \"modestbranding\", \"start\"];\n      var a = document.createElement(\"a\");\n      a.href = url;\n      var urlGetParams = {};\n      a.search.slice(a.search.indexOf(\"?\") + 1).split(\"&\").map(function (hash) {\n        var _hash$split = hash.split(\"=\"),\n            key = _hash$split[0],\n            val = _hash$split[1];\n\n        urlGetParams[key] = decodeURIComponent(val);\n      });\n      var filteredGetParams = {};\n\n      for (var _i = 0, _acceptableYouTubePar = acceptableYouTubeParams; _i < _acceptableYouTubePar.length; _i++) {\n        var param = _acceptableYouTubePar[_i];\n\n        if (urlGetParams.hasOwnProperty(param)) {\n          filteredGetParams[param] = urlGetParams[param];\n        }\n      }\n\n      if (data.autoplay === \"true\") {\n        filteredGetParams.autoplay = \"1\";\n        filteredGetParams.mute = \"1\";\n      } else {\n        delete filteredGetParams.autoplay;\n        delete filteredGetParams.mute;\n      }\n\n      var processedGetParams = [];\n\n      for (var _param in filteredGetParams) {\n        if (filteredGetParams.hasOwnProperty(_param)) {\n          processedGetParams.push(encodeURI(_param + \"=\" + filteredGetParams[_param]));\n        }\n      }\n\n      return processedGetParams.length > 0 ? \"?\" + processedGetParams.join(\"&\") : \"\";\n    }\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    ;\n\n    var _proto = VideoSrc.prototype;\n\n    _proto.fromDom = function fromDom(value) {\n      value = value.replace(/\\?autoplay=1&mute=1/g, \"\");\n      value = value.replace(/&autoplay=1&mute=1/g, \"\");\n      value = value.replace(/\\?title=0&byline=0&portrait=0/g, \"\");\n      value = value.replace(/&autoplay=1&autopause=0&muted=1/g, \"\");\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value === undefined) {\n        return \"\";\n      }\n\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n\n      if (youtubeRegExp.test(value)) {\n        return \"https://www.youtube.com/embed/\" + youtubeRegExp.exec(value)[1] + VideoSrc.parseYoutubeGetParams(value, data);\n      } else if (vimeoRegExp.test(value)) {\n        return \"https://player.vimeo.com/video/\" + vimeoRegExp.exec(value)[3] + \"?title=0&byline=0&portrait=0\" + (data.autoplay === \"true\" ? \"&autoplay=1&autopause=0&muted=1\" : \"\");\n      }\n\n      return value;\n    };\n\n    return VideoSrc;\n  }();\n\n  return VideoSrc;\n});\n//# sourceMappingURL=videosrc.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/autoplay.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoSrc = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoSrc() {}\n\n    var _proto = VideoSrc.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"true\" ? value : \"false\";\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {boolean|string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value === \"true\" ? true : null;\n    };\n\n    return VideoSrc;\n  }();\n\n  return VideoSrc;\n});\n//# sourceMappingURL=autoplay.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var fileRegExp = new RegExp(\"^(webm:|mp4:|ogv:)\");\n\n      if (fileRegExp.test(value)) {\n        return value.substr(fileRegExp.exec(value)[0].length);\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value === undefined) {\n        return \"\";\n      }\n\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      var fileRegExp = new RegExp(\"^(?:https:|http:)?\\\\/\\\\/.*[\\\\\\\\\\\\/].+\\\\.(webm|mp4|ogv)(?!\\w)\");\n\n      if (youtubeRegExp.test(value)) {\n        return \"https://www.youtube.com/embed/\" + youtubeRegExp.exec(value)[1];\n      } else if (vimeoRegExp.test(value)) {\n        return \"https://player.vimeo.com/video/\" + vimeoRegExp.exec(value)[3] + \"?title=0&byline=0&portrait=0\";\n      } else if (fileRegExp.test(value)) {\n        var result = fileRegExp.exec(value);\n        return result[1] + \":\" + value;\n      }\n\n      return value;\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/content-type/divider/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/observable-updater/attributes.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _config, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements attribute binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   */\n  function generate(elementName, config, data, converterResolver, converterPool) {\n    var attributeData = {};\n\n    var _loop = function _loop() {\n      var attributeConfig = _step.value;\n\n      if (\"read\" === attributeConfig.persistence_mode) {\n        return \"continue\";\n      } // @ts-ignore\n\n\n      var value = void 0;\n\n      if (!!attributeConfig.static) {\n        value = attributeConfig.value;\n      } else {\n        value = (0, _object.get)(data, attributeConfig.var);\n      }\n\n      var converter = converterResolver(attributeConfig);\n\n      if (converterPool.get(converter)) {\n        value = converterPool.get(converter).toDom(attributeConfig.var, data);\n      } // Replacing src attribute with data-tmp-src to prevent img requests in iframe during master format rendering\n\n\n      if (_config.getMode() !== \"Preview\" && attributeConfig.name === \"src\" && _underscore.isString(value) && !value.indexOf(\"{{media url=\")) {\n        attributeData[\"data-tmp-\" + attributeConfig.name] = value; // @ts-ignore\n\n        Object.defineProperty(attributeData, attributeConfig.name, {\n          get: function get() {\n            return value;\n          }\n        });\n      } else {\n        attributeData[attributeConfig.name] = value;\n      }\n    };\n\n    for (var _iterator = _createForOfIteratorHelperLoose(config.attributes), _step; !(_step = _iterator()).done;) {\n      var _ret = _loop();\n\n      if (_ret === \"continue\") continue;\n    }\n\n    attributeData[\"data-element\"] = elementName;\n    return attributeData;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=attributes.js.map","Magento_PageBuilder/js/content-type/observable-updater/style.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/utils/string\"], function (_underscore, _object, _string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements style binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   * @param previousData\n   */\n  function generate(elementName, config, data, converterResolver, converterPool, previousData) {\n    var newStyles = {};\n\n    if (config.style) {\n      for (var _iterator = _createForOfIteratorHelperLoose(config.style), _step; !(_step = _iterator()).done;) {\n        var propertyConfig = _step.value;\n\n        if (\"read\" === propertyConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = void 0;\n\n        if (!!propertyConfig.static) {\n          value = propertyConfig.value;\n        } else {\n          value = (0, _object.get)(data, propertyConfig.var);\n          var converter = converterResolver(propertyConfig);\n\n          if (converterPool.get(converter)) {\n            value = converterPool.get(converter).toDom(propertyConfig.var, data);\n          }\n        }\n\n        if (typeof value === \"object\") {\n          _underscore.extend(newStyles, value);\n        } else if (value !== undefined) {\n          newStyles[(0, _string.fromSnakeToCamelCase)(propertyConfig.name)] = value;\n        }\n      }\n    }\n\n    if (previousData) {\n      /**\n       * If so we need to retrieve the previous styles applied to this element and create a new object\n       * which forces all of these styles to be \"false\". Knockout doesn't clean existing styles when\n       * applying new styles to an element. This resolves styles sticking around when they should be\n       * removed.\n       */\n      var removeCurrentStyles = Object.keys(previousData).reduce(function (object, styleName) {\n        var _Object$assign;\n\n        return Object.assign(object, (_Object$assign = {}, _Object$assign[styleName] = \"\", _Object$assign));\n      }, {});\n\n      if (!_underscore.isEmpty(removeCurrentStyles)) {\n        newStyles = _underscore.extend(removeCurrentStyles, newStyles);\n      }\n    }\n\n    return newStyles;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=style.js.map","Magento_PageBuilder/js/content-type/observable-updater/html.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/object\"], function (_config, _directives, _editor, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements html binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   */\n  function generate(elementName, config, data, converterResolver, converterPool) {\n    var value = config.html.var ? (0, _object.get)(data, config.html.var, config.html.placeholder) : config.html.placeholder;\n    var converter = converterResolver(config.html);\n\n    if (converterPool.get(converter)) {\n      value = converterPool.get(converter).toDom(config.html.var, data);\n    } // if value is empty, use placeholder\n\n\n    if (typeof value === \"string\" && !value.length && config.html.placeholder) {\n      value = config.html.placeholder;\n    } // Replacing src attribute with data-tmp-src to prevent img requests in iframe during master format rendering\n\n\n    if (_config.getMode() !== \"Preview\" && typeof value === \"string\" && value.indexOf(\"{{media url=\") !== -1) {\n      value = (0, _directives.replaceWithDataSrc)(value);\n    } // Process all desktop styles that left unprocessed after migrating from inline styles.\n\n\n    if (typeof value === \"string\") {\n      value = (0, _editor.processInlineStyles)(value);\n    }\n\n    return value;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=html.js.map","Magento_PageBuilder/js/content-type/observable-updater/css.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements css binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   * @param previousData\n   */\n  function generate(elementName, config, data, converterResolver, converterPool, previousData) {\n    var css = (0, _object.get)(data, config.css.var);\n    var newClasses = {};\n\n    if (css && css.length > 0) {\n      css.toString().split(\" \").map(function (value) {\n        return newClasses[value] = true;\n      });\n    }\n\n    for (var _i = 0, _Object$keys = Object.keys(previousData); _i < _Object$keys.length; _i++) {\n      var className = _Object$keys[_i];\n\n      if (!(className in newClasses)) {\n        newClasses[className] = false;\n      }\n    }\n\n    return newClasses;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=css.js.map","Magento_PageBuilder/js/content-type/buttons/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _underscore, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Keeps track of number of button item to disable sortable if there is only 1.\n\n      _this.focusedButton = _knockout.observable();\n      _this.debouncedResizeHandler = _underscore.debounce(function () {\n        _this.resizeChildButtons();\n      }, 350);\n\n      _this.contentType.children.subscribe(function () {\n        var sortableElement = (0, _jquery)(_this.wrapperElement).find(\".buttons-container\");\n\n        if (!sortableElement.data(\"ui-sortable\")) {\n          return;\n        }\n\n        if (_this.contentType.children().length <= 1) {\n          sortableElement.sortable(\"disable\");\n        } else {\n          sortableElement.sortable(\"enable\");\n        }\n      }); // Monitor focus tab to start / stop interaction on the stage, debounce to avoid duplicate calls\n\n\n      _this.focusedButton.subscribe(_underscore.debounce(function (index) {\n        if (index !== null) {\n          _events.trigger(\"stage:interactionStart\");\n\n          var focusedButton = _this.contentType.children()[index];\n\n          (0, _delayUntil)(function () {\n            return (0, _jquery)(focusedButton.preview.wrapperElement).find(\"[contenteditable]\").focus();\n          }, function () {\n            return typeof focusedButton.preview.wrapperElement !== \"undefined\";\n          }, 10);\n        } else {\n          // We have to force the stop as the event firing is inconsistent for certain operations\n          _events.trigger(\"stage:interactionStop\", {\n            force: true\n          });\n        }\n      }, 1));\n\n      return _this;\n    }\n    /**\n     * Bind events\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"buttons:dropAfter\", function (args) {\n        if (args.id === _this2.contentType.id && _this2.contentType.children().length === 0) {\n          _this2.addButton();\n        }\n      });\n\n      _events.on(\"buttons:renderAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.debouncedResizeHandler();\n        }\n      });\n\n      _events.on(\"button-item:renderAfter\", function (args) {\n        if (args.contentType.parentContentType.id === _this2.contentType.id) {\n          _this2.debouncedResizeHandler();\n        }\n      });\n\n      _events.on(\"stage:updateAfter\", function () {\n        _this2.debouncedResizeHandler();\n      });\n\n      _events.on(\"contentType:redrawAfter\", function () {\n        _this2.debouncedResizeHandler();\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedButton;\n      var duplicatedButtonIndex;\n\n      _events.on(\"button-item:duplicateAfter\", function (args) {\n        if (_this2.contentType.id === args.duplicateContentType.parentContentType.id && args.direct) {\n          duplicatedButton = args.duplicateContentType;\n          duplicatedButtonIndex = args.index;\n        }\n      });\n\n      _events.on(\"button-item:mountAfter\", function (args) {\n        if (duplicatedButton && args.id === duplicatedButton.id) {\n          _this2.focusedButton(duplicatedButtonIndex);\n        }\n      });\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add Button\"),\n        action: this.addButton,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Add button-item to buttons children array\n     */\n    ;\n\n    _proto.addButton = function addButton() {\n      var _this3 = this;\n\n      var createButtonItemPromise = (0, _contentTypeFactory)(_config.getContentTypeConfig(\"button-item\"), this.contentType, this.contentType.stageId, {});\n      createButtonItemPromise.then(function (button) {\n        _this3.contentType.addChild(button);\n\n        var buttonIndex = _this3.contentType.children().indexOf(button);\n\n        _this3.focusedButton(buttonIndex > -1 ? buttonIndex : null);\n\n        return button;\n      }).catch(function (error) {\n        console.error(error);\n      });\n    }\n    /**\n     * Get the sortable options for the buttons sorting\n     *\n     * @param {string} orientation\n     * @param {string} tolerance\n     * @returns {JQueryUI.Sortable}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions(orientation, tolerance) {\n      if (orientation === void 0) {\n        orientation = \"width\";\n      }\n\n      if (tolerance === void 0) {\n        tolerance = \"intersect\";\n      }\n\n      return {\n        handle: \".button-item-drag-handle\",\n        items: \".pagebuilder-content-type-wrapper\",\n        cursor: \"grabbing\",\n        containment: \"parent\",\n        tolerance: tolerance,\n        revert: 200,\n        disabled: this.contentType.children().length <= 1,\n\n        /**\n         * Provide custom helper element\n         *\n         * @param {Event} event\n         * @param {JQueryUI.Sortable} element\n         * @returns {Element}\n         */\n        helper: function helper(event, element) {\n          var helper = (0, _jquery)(element).clone().css({\n            opacity: \"0.7\",\n            width: \"auto\"\n          });\n          helper[0].querySelector(\".pagebuilder-options\").remove();\n          return helper[0];\n        },\n        placeholder: {\n          /**\n           * Provide custom placeholder element\n           *\n           * @param {JQuery} item\n           * @returns {JQuery}\n           */\n          element: function element(item) {\n            var placeholder = item.clone().css({\n              display: \"inline-block\",\n              opacity: \"0.3\"\n            }).removeClass(\"focused\").addClass(\"sortable-placeholder\");\n            placeholder[0].querySelector(\".pagebuilder-options\").remove();\n            return placeholder[0];\n          },\n          update: function update() {\n            return;\n          }\n        },\n\n        /**\n         * Trigger interaction start on sort\n         */\n        start: function start() {\n          _events.trigger(\"stage:interactionStart\");\n        },\n\n        /**\n         * Stop stage interaction on stop\n         */\n        stop: function stop() {\n          _events.trigger(\"stage:interactionStop\");\n        }\n      };\n    }\n    /**\n     * Resize width of all child buttons. Dependently make them the same width if configured.\n     */\n    ;\n\n    _proto.resizeChildButtons = function resizeChildButtons() {\n      if (this.wrapperElement) {\n        var buttonItems = (0, _jquery)(this.wrapperElement).find(\".pagebuilder-button-item > a\");\n        var buttonResizeValue = 0;\n\n        if (this.contentType.dataStore.get(\"is_same_width\") === \"true\") {\n          if (buttonItems.length > 0) {\n            var currentLargestButtonWidth = this.findLargestButtonWidth(buttonItems);\n            var parentWrapperWidth = (0, _jquery)(this.wrapperElement).find(\".buttons-container\").width();\n\n            if (currentLargestButtonWidth === 0) {\n              return;\n            }\n\n            buttonResizeValue = Math.min(currentLargestButtonWidth, parentWrapperWidth);\n          }\n        }\n\n        buttonItems.css(\"min-width\", buttonResizeValue);\n      }\n    }\n    /**\n     * Find the largest button width for calculating same size value.\n     *\n     * @param {JQuery} buttonItems\n     * @returns {number}\n     */\n    ;\n\n    _proto.findLargestButtonWidth = function findLargestButtonWidth(buttonItems) {\n      var _this4 = this;\n\n      return _underscore.max(_underscore.map(buttonItems, function (buttonItem) {\n        return _this4.calculateButtonWidth((0, _jquery)(buttonItem));\n      }));\n    }\n    /**\n     * Manually calculate button width using content plus box widths (padding, border)\n     *\n     * @param {JQuery} buttonItem\n     * @returns {number}\n     */\n    ;\n\n    _proto.calculateButtonWidth = function calculateButtonWidth(buttonItem) {\n      if (buttonItem.is(\":visible\") === false) {\n        return 0;\n      }\n\n      var widthProperties = [\"paddingLeft\", \"paddingRight\", \"borderLeftWidth\", \"borderRightWidth\"];\n      var buttonText = buttonItem.find(\"[data-element='link_text']\");\n      var textWidth = buttonText.css(\"display\", \"inline-block\").width();\n      buttonText.css(\"display\", \"\");\n      return widthProperties.reduce(function (accumulatedWidth, widthProperty) {\n        return accumulatedWidth + (parseInt(buttonItem.css(widthProperty), 10) || 0);\n      }, textWidth);\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/buttons/appearance/inline/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events'\n], function ($, events) {\n    'use strict';\n\n    /**\n     * Equalize the width of a list of button-item components\n     *\n     * @param {JQuery} buttonList\n     */\n    var equalizeButtonWidth = function (buttonList) {\n        var buttonMinWidth = 0;\n\n        buttonList.css('min-width', buttonMinWidth);\n        buttonList.each(function () {\n            var buttonWidth = this.offsetWidth;\n\n            if (buttonWidth > buttonMinWidth) {\n                buttonMinWidth = buttonWidth;\n            }\n        });\n        buttonList.css('min-width', buttonMinWidth);\n    };\n\n    return function (config, element) {\n        var $element = $(element),\n            buttonSelector = '[data-element=\"link\"], [data-element=\"empty_link\"]';\n\n        if ($element.data('sameWidth')) {\n            equalizeButtonWidth($element.find(buttonSelector));\n            $(window).on('resize', function () {\n                equalizeButtonWidth($element.find(buttonSelector));\n            });\n            events.on('contentType:redrawAfter', function (eventData) {\n                if ($element.closest(eventData.element).length > 0) {\n                    equalizeButtonWidth($element.find(buttonSelector));\n                }\n            });\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/buttons/converter/style/display/flex.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Flex = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Flex() {}\n\n    var _proto = Flex.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be inline block\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"flex\";\n    };\n\n    return Flex;\n  }();\n\n  return Flex;\n});\n//# sourceMappingURL=flex.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/display/boolean.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Boolean = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Boolean() {}\n\n    var _proto = Boolean.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be reset to default\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"\";\n    };\n\n    return Boolean;\n  }();\n\n  return Boolean;\n});\n//# sourceMappingURL=boolean.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/preview/display/flex.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return;\n    }\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return \"flex\";\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=flex.js.map","Magento_PageBuilder/js/content-type/column-line/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/column-group/factory\", \"Magento_PageBuilder/js/content-type/column-group/registry\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/utils/create-stylesheet\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column/resize\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column-line/drag-and-drop\"], function (_jquery, _knockout, _contentTypeFactory, _factory, _registry, _moveContentType, _registry2, _sortable, _events, _createStylesheet, _underscore, _config, _gridSize, _resize, _previewCollection, _dragAndDrop) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     *\n     * @param {ContentTypeCollection} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.resizing = _knockout.observable(false);\n      _this.gridSizeArray = _knockout.observableArray([]);\n      _this.dropPositions = [];\n      _this.resizeHistory = {\n        left: [],\n        right: []\n      };\n      _this.interactionLevel = 0;\n      _this.lineDropperHeight = 50;\n      _this.resizeUtils = new _resize(_this.contentType.parentContentType, _this.contentType);\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.spreadWidth(args.index);\n          });\n        }\n      }); // Listen for resizing events from child columns\n\n\n      _events.on(\"column:resizeHandleBindAfter\", function (args) {\n        // Does the events content type match the previews column group?\n        if (args.columnLine.id === _this.contentType.id) {\n          _this.registerResizeHandle(args.column, args.handle);\n        }\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnGroup.id === _this.contentType.id) {\n          _this.bindDraggable(args.column);\n        }\n      });\n\n      var parentPreview = _this.contentType.parentContentType.preview;\n\n      _this.gridSizeArray(parentPreview.gridSizeArray());\n\n      parentPreview.gridSizeArray.subscribe(function (gridSize) {\n        _this.gridSizeArray(gridSize);\n      });\n\n      _this.contentType.children.subscribe(_underscore.debounce(_this.removeIfEmpty.bind(_assertThisInitialized(_this)), 50));\n\n      return _this;\n    }\n    /**\n     * Bind events\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      if (_config.getContentTypeConfig(\"column\")) {\n        _events.on(\"column-line:dropAfter\", function (args) {\n          if (args.id === _this2.contentType.id) {\n            _this2.createColumns();\n          }\n        });\n      }\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnLine.id === _this2.contentType.id) {\n          _this2.bindDraggable(args.column);\n        }\n      });\n    }\n    /**\n     * Init the droppable & resizing interactions\n     *\n     * @param line\n     */\n    ;\n\n    _proto.bindInteractions = function bindInteractions(line) {\n      this.element = (0, _jquery)(line);\n      this.initDroppable(this.element);\n      this.initMouseMove(this.element); // Handle the mouse leaving the window\n      //  $(\"body\").mouseleave(this.endAllInteractions.bind(this));\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindDropPlaceholder = function bindDropPlaceholder(element) {\n      this.dropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindColumnLineBottomDropPlaceholder = function bindColumnLineBottomDropPlaceholder(element) {\n      this.columnLineBottomDropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindColumnLineDropPlaceholder = function bindColumnLineDropPlaceholder(element) {\n      this.columnLineDropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the move placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindMovePlaceholder = function bindMovePlaceholder(element) {\n      this.movePlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Retrieve the ghost element from the template\n     *\n     * @param {Element} ghost\n     */\n    ;\n\n    _proto.bindGhost = function bindGhost(ghost) {\n      this.resizeGhost = (0, _jquery)(ghost);\n    }\n    /**\n     * Retrieve the resize utils\n     *\n     * @returns {Resize}\n     */\n    ;\n\n    _proto.getResizeUtils = function getResizeUtils() {\n      return this.resizeUtils;\n    }\n    /**\n     * Bind draggable instances to the child columns\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     */\n    ;\n\n    _proto.bindDraggable = function bindDraggable(column) {\n      var _this3 = this;\n\n      column.preview.element.draggable({\n        appendTo: \"body\",\n        containment: \"body\",\n        cursor: \"-webkit-grabbing\",\n        handle: \".move-column\",\n        revertDuration: 250,\n        helper: function helper() {\n          var helper = (0, _jquery)(this).clone();\n          helper.css({\n            height: (0, _jquery)(this).outerHeight() + \"px\",\n            minHeight: 0,\n            opacity: 0.5,\n            pointerEvents: \"none\",\n            width: (0, _jquery)(this).outerWidth() + \"px\",\n            zIndex: 5000\n          });\n          return helper;\n        },\n        start: function start(event) {\n          var columnInstance = _knockout.dataFor((0, _jquery)(event.target)[0]); // Use the global state as columns can be dragged between groups\n\n\n          (0, _registry.setDragColumn)(columnInstance.contentType);\n          _this3.dropPositions = (0, _dragAndDrop.calculateDropPositions)(_this3.contentType);\n          _this3.startDragEvent = event;\n\n          _events.trigger(\"column:dragStart\", {\n            column: columnInstance,\n            stageId: _this3.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStart\", {\n            stageId: _this3.contentType.stageId\n          });\n        },\n        stop: function stop() {\n          var draggedColumn = (0, _registry.getDragColumn)();\n\n          if (_this3.movePosition && draggedColumn) {\n            // Check if we're moving within the same group, even though this function will\n            // only ever run on the group that bound the draggable event\n            if (draggedColumn.parentContentType === _this3.contentType) {\n              _this3.onColumnSort(draggedColumn, _this3.movePosition.insertIndex);\n\n              _this3.movePosition = null; // todo see from column group\n            }\n          }\n\n          (0, _registry.removeDragColumn)();\n\n          _this3.dropPlaceholder.removeClass(\"left right\");\n\n          _this3.movePlaceholder.removeClass(\"active\");\n\n          _this3.movePosition = null;\n          _this3.startDragEvent = null;\n\n          _events.trigger(\"column:dragStop\", {\n            column: draggedColumn,\n            stageId: _this3.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: _this3.contentType.stageId\n          });\n        }\n      });\n    }\n    /**\n     * Handle a column being sorted into a new position in the column line\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} newIndex\n     */\n    ;\n\n    _proto.onColumnSort = function onColumnSort(column, newIndex) {\n      var currentIndex = (0, _resize.getColumnIndexInLine)(column);\n\n      if (currentIndex !== newIndex) {\n        if (currentIndex < newIndex) {\n          // As we're moving an array item the keys all reduce by 1\n          --newIndex;\n        } // Move the content type\n\n\n        (0, _moveContentType.moveContentType)(column, newIndex);\n      }\n    }\n    /**\n     * Handle a new column being dropped into the group\n     *\n     * @param {DropPosition} dropPosition\n     */\n    ;\n\n    _proto.onNewColumnDrop = function onNewColumnDrop(dropPosition) {\n      var _this4 = this;\n\n      // Create our new column\n      (0, _factory.createColumn)(this.contentType, this.resizeUtils.getSmallestColumnWidth(), dropPosition.insertIndex).then(function () {\n        var newWidth = _this4.resizeUtils.getAcceptedColumnWidth((_this4.resizeUtils.getColumnWidth(dropPosition.affectedColumn) - _this4.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n\n        (0, _resize.updateColumnWidth)(dropPosition.affectedColumn, newWidth);\n      });\n    }\n    /**\n     * Handle an existing column being dropped into a different column line\n     *\n     * @param {DropPosition} movePosition\n     */\n    ;\n\n    _proto.onExistingColumnDrop = function onExistingColumnDrop(movePosition) {\n      var _this5 = this;\n\n      var column = (0, _registry.getDragColumn)();\n      var sourceLinePreview = column.parentContentType.preview;\n      var modifyOldNeighbour; // Determine which old neighbour we should modify\n\n      var oldWidth = sourceLinePreview.getResizeUtils().getColumnWidth(column);\n      var direction = \"+1\"; // Retrieve the adjacent column either +1 or -1\n\n      if ((0, _resize.getAdjacentColumn)(column, \"+1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"+1\");\n      } else if ((0, _resize.getAdjacentColumn)(column, \"-1\")) {\n        direction = \"-1\";\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"-1\");\n      } // Modify the old neighbour\n\n\n      var oldNeighbourWidth = 100;\n\n      if (modifyOldNeighbour) {\n        oldNeighbourWidth = sourceLinePreview.getResizeUtils().getAcceptedColumnWidth((oldWidth + sourceLinePreview.getResizeUtils().getColumnWidth(modifyOldNeighbour)).toString());\n      } // Move the content type\n\n\n      if (this.columnLineDropPlaceholder.hasClass(\"active\")) {\n        // if new column line placeholders are visible, add new column line and move column there\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          (0, _moveContentType.moveContentType)(column, 0, columnLine);\n          (0, _resize.updateColumnWidth)(column, 100);\n\n          if (modifyOldNeighbour) {\n            (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n          }\n\n          _this5.fireMountEvent(_this5.contentType, column);\n        });\n      } else if (this.columnLineBottomDropPlaceholder.hasClass(\"active\")) {\n        // if new column line placeholders are visible, add new column line and move column there\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          (0, _moveContentType.moveContentType)(column, 0, columnLine);\n          (0, _resize.updateColumnWidth)(column, 100);\n\n          if (modifyOldNeighbour) {\n            (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n          }\n\n          _this5.fireMountEvent(_this5.contentType, column);\n        });\n      } else {\n        (0, _moveContentType.moveContentType)(column, movePosition.insertIndex, this.contentType);\n\n        if (modifyOldNeighbour) {\n          (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n        }\n\n        var newNeighbourWidth = this.resizeUtils.getAcceptedColumnWidth((this.resizeUtils.getColumnWidth(movePosition.affectedColumn) - oldWidth).toString());\n        var newNeighbour = movePosition.affectedColumn;\n        var totalWidthAdjusted = 0;\n        (0, _resize.updateColumnWidth)(column, oldWidth);\n\n        while (true) {\n          // take width from all neighbours in one direction till the entire width is obtained\n          if (newNeighbourWidth <= 0) {\n            newNeighbourWidth = this.resizeUtils.getSmallestColumnWidth();\n            var originalWidthOfNeighbour = this.resizeUtils.getColumnWidth(newNeighbour);\n            (0, _resize.updateColumnWidth)(newNeighbour, newNeighbourWidth);\n            totalWidthAdjusted += originalWidthOfNeighbour - newNeighbourWidth;\n          } else {\n            (0, _resize.updateColumnWidth)(newNeighbour, newNeighbourWidth);\n            break;\n          }\n\n          if (direction === \"+1\") {\n            newNeighbour = (0, _resize.getAdjacentColumn)(newNeighbour, \"+1\");\n          } else {\n            newNeighbour = (0, _resize.getAdjacentColumn)(newNeighbour, \"-1\");\n          }\n\n          if (!newNeighbour) {\n            (0, _resize.updateColumnWidth)(column, totalWidthAdjusted);\n            break;\n          }\n\n          var neighbourExistingWidth = this.resizeUtils.getColumnWidth(newNeighbour);\n          newNeighbourWidth = neighbourExistingWidth - (oldWidth - totalWidthAdjusted);\n\n          if (newNeighbourWidth < 0.001) {\n            newNeighbourWidth = 0;\n          }\n        }\n\n        var totalWidth = 0;\n        this.contentType.children().forEach(function (columnChild) {\n          totalWidth += _this5.resizeUtils.getColumnWidth(columnChild);\n        });\n\n        if (totalWidth > 100) {\n          // take extra width from newly moved column\n          (0, _resize.updateColumnWidth)(column, this.resizeUtils.getColumnWidth(column) - (totalWidth - 100));\n        }\n      }\n    }\n    /**\n     * Init the resizing events on the group\n     *\n     * @param {JQuery} line\n     */\n    ;\n\n    _proto.initMouseMove = function initMouseMove(line) {\n      var _this6 = this;\n\n      var intersects = false;\n      (0, _jquery)(document).on(\"mousemove touchmove\", function (event) {\n        if (line.parents(_sortable.hiddenClass).length > 0) {\n          return;\n        }\n\n        var linePosition = _this6.getLinePosition(line); // If we're handling a touch event we need to pass through the page X & Y\n\n\n        if (event.type === \"touchmove\") {\n          event.pageX = event.originalEvent.pageX;\n          event.pageY = event.originalEvent.pageY;\n        }\n\n        if (_this6.eventIntersectsLine(event, linePosition)) {\n          intersects = true; // @todo re-instate onResizingMouseMove\n\n          _this6.onResizingMouseMove(event, line, linePosition);\n\n          _this6.onDraggingMouseMove(event, line, linePosition);\n\n          _this6.onDroppingMouseMove(event, line, linePosition);\n        } else {\n          intersects = false;\n          _this6.linePositionCache = null;\n          _this6.dropPosition = null;\n\n          _this6.dropPlaceholder.removeClass(\"left right\");\n\n          _this6.columnLineDropPlaceholder.removeClass(\"active\");\n\n          _this6.columnLineBottomDropPlaceholder.removeClass(\"active\");\n\n          _this6.columnLineBottomDropPlaceholder.hide();\n\n          _this6.columnLineDropPlaceholder.hide(); // @todo combine active and show/hide functionality for columnLineDropPlaceholder\n          //  this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n\n        }\n      }).on(\"mouseup touchend\", function () {\n        if (intersects) {\n          _this6.handleMouseUp();\n        }\n\n        intersects = false;\n        _this6.dropPosition = null;\n\n        _this6.endAllInteractions();\n\n        _underscore.defer(function () {\n          // Re-enable any disabled sortable areas\n          line.find(\".ui-sortable\").each(function () {\n            if ((0, _jquery)(this).data(\"ui-sortable\")) {\n              (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n            }\n          });\n        });\n      });\n    }\n    /**\n     * End all current interactions\n     */\n    ;\n\n    _proto.endAllInteractions = function endAllInteractions() {\n      if (this.resizing() === true) {\n        for (; this.interactionLevel > 0; this.interactionLevel--) {\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: this.contentType.stageId\n          });\n        }\n      }\n\n      this.linePositionCache = null;\n      this.dropPosition = null;\n      this.dropPlaceholder.removeClass(\"left right\");\n      this.columnLineDropPlaceholder.removeClass(\"active\");\n      this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n      this.columnLineBottomDropPlaceholder.hide();\n      this.columnLineDropPlaceholder.hide();\n      this.resizing(false);\n      this.resizeMouseDown = null;\n      this.resizeLeftLastColumnShrunk = this.resizeRightLastColumnShrunk = null;\n      this.dropPositions = [];\n      this.unsetResizingColumns(); // Change the cursor back\n\n      (0, _jquery)(\"body\").css(\"cursor\", \"\");\n      this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n      this.resizeGhost.removeClass(\"active\"); // Reset the line positions cache\n\n      this.linePositionCache = null;\n    }\n    /**\n     * Handle the mouse up action, either adding a new column or moving an existing\n     */\n    ;\n\n    _proto.handleMouseUp = function handleMouseUp() {\n      var self = this;\n      var dragColumn = (0, _registry.getDragColumn)();\n\n      if ((this.columnLineDropPlaceholder.hasClass(\"active\") || this.columnLineBottomDropPlaceholder.hasClass(\"active\")) && !dragColumn) {\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          _events.trigger(columnLine.config.name + \":dropAfter\", {\n            id: columnLine.id,\n            columnLine: columnLine\n          });\n        });\n        return;\n      }\n\n      if (this.dropOverElement && this.dropPosition) {\n        this.onNewColumnDrop(this.dropPosition);\n        this.dropOverElement = null; // Re-enable the parent disabled sortable instance\n\n        _underscore.defer(function () {\n          (0, _jquery)(\".element-children.ui-sortable-disabled\").each(function () {\n            (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n          });\n        });\n      }\n\n      var column = (0, _registry.getDragColumn)();\n\n      if (this.isColumnBeingMovedToAnotherColumnLine()) {\n        this.onExistingColumnDrop(this.movePosition);\n      }\n    }\n    /**\n     * Does the current event intersect with the line?\n     *\n     * @param {JQueryEventObject} event\n     * @param {LinePositionCache} groupPosition\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.eventIntersectsLine = function eventIntersectsLine(event, groupPosition) {\n      return event.pageY > groupPosition.top && event.pageY < groupPosition.top + groupPosition.outerHeight && event.pageX > groupPosition.left && event.pageX < groupPosition.left + groupPosition.outerWidth;\n    }\n    /**\n     * Handle a column being dragged around the group\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} line\n     * @param {LinePositionCache} linePosition\n     */\n    ;\n\n    _proto.onDraggingMouseMove = function onDraggingMouseMove(event, line, linePosition) {\n      var dragColumn = (0, _registry.getDragColumn)();\n\n      if (dragColumn) {\n        // If the drop positions haven't been calculated for this line do so now\n        if (this.dropPositions.length === 0) {\n          this.dropPositions = (0, _dragAndDrop.calculateDropPositions)(this.contentType);\n        }\n\n        var columnInstance = dragColumn;\n        var currentX = event.pageX - linePosition.left; // Are we within the same column line or have we ended up over another?\n\n        if (columnInstance.parentContentType === this.contentType && this.startDragEvent) {\n          var dragDirection = event.pageX <= this.startDragEvent.pageX ? \"left\" : \"right\";\n          var adjacentLeftColumn = (0, _resize.getAdjacentColumn)(dragColumn, \"-1\"); // Determine the current move position based on the cursors position and direction of drag\n\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX < position.right && position.placement === dragDirection && position.affectedColumn !== dragColumn;\n          }); // Differences in the element & event positions cause a right movement to activate on the left column\n\n          if (this.movePosition && dragDirection === \"right\" && this.movePosition.affectedColumn === adjacentLeftColumn) {\n            this.movePosition = null;\n          }\n\n          if (this.movePosition && !this.isNewLinePlaceDropPlaceholderVisible(event, linePosition) && !this.isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition)) {\n            this.dropPlaceholder.removeClass(\"left right\");\n            this.movePlaceholder.css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? linePosition.width - this.movePosition.right : \"\",\n              width: dragColumn.preview.element.outerWidth() + \"px\"\n            }).addClass(\"active\");\n          } else {\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        } else {\n          // If we're moving to another column line we utilise the existing drop placeholder\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX <= position.right && position.canShrink;\n          });\n\n          if (this.movePosition && !this.isNewLinePlaceDropPlaceholderVisible(event, linePosition)) {\n            var classToRemove = this.movePosition.placement === \"left\" ? \"right\" : \"left\";\n            this.movePlaceholder.removeClass(\"active\");\n            this.dropPlaceholder.removeClass(classToRemove).css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? linePosition.width - this.movePosition.right : \"\",\n              width: linePosition.width / this.resizeUtils.getGridSize() + \"px\"\n            }).addClass(this.movePosition.placement);\n          } else {\n            this.dropPlaceholder.removeClass(\"left right\");\n          }\n        }\n      }\n    }\n    /**\n     * Handle the resizing on mouse move, we always resize a pair of columns at once\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onResizingMouseMove = function onResizingMouseMove(event, group, groupPosition) {\n      var _this7 = this;\n\n      var newColumnWidth;\n\n      if (this.resizeMouseDown) {\n        event.preventDefault();\n        var currentPos = event.pageX;\n        var resizeColumnLeft = this.resizeColumnInstance.preview.element.offset().left;\n        var resizeColumnWidth = this.resizeColumnInstance.preview.element.outerWidth();\n        var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n        var direction = currentPos >= resizeHandlePosition ? \"right\" : \"left\";\n        var adjustedColumn;\n        var modifyColumnInPair; // We need to know if we're modifying the left or right column in the pair\n\n        var usedHistory; // Was the adjusted column pulled from history?\n        // Determine which column in the group should be adjusted for this action\n\n        var _this$resizeUtils$det = this.resizeUtils.determineAdjustedColumn(currentPos, this.resizeColumnInstance, this.resizeHistory);\n\n        adjustedColumn = _this$resizeUtils$det[0];\n        modifyColumnInPair = _this$resizeUtils$det[1];\n        usedHistory = _this$resizeUtils$det[2];\n        // Calculate the ghost width based on mouse position and bounds of allowed sizes\n        var ghostWidth = this.resizeUtils.calculateGhostWidth(groupPosition, currentPos, this.resizeColumnInstance, modifyColumnInPair, this.resizeMaxGhostWidth);\n        this.resizeGhost.width(ghostWidth - 15 + \"px\").addClass(\"active\");\n\n        if (adjustedColumn && this.resizeColumnWidths) {\n          newColumnWidth = this.resizeColumnWidths.find(function (val) {\n            return (0, _resize.comparator)(currentPos, val.position, 35) && val.forColumn === modifyColumnInPair;\n          });\n\n          if (newColumnWidth) {\n            var mainColumn = this.resizeColumnInstance; // If we're using the left data set, we're actually resizing the right column of the group\n\n            if (modifyColumnInPair === \"right\") {\n              mainColumn = (0, _resize.getAdjacentColumn)(this.resizeColumnInstance, \"+1\");\n            } // Ensure we aren't resizing multiple times, also validate the last resize isn't the same as the\n            // one being performed now. This occurs as we re-calculate the column positions on resize, we have\n            // to use the comparator as the calculation may result in slightly different numbers due to rounding\n\n\n            if (this.resizeUtils.getColumnWidth(mainColumn) !== newColumnWidth.width && !(0, _resize.comparator)(this.resizeLastPosition, newColumnWidth.position, 10)) {\n              // If our previous action was to resize the right column in pair, and we're now dragging back\n              // to the right, but have matched a column for the left we need to fix the columns being\n              // affected\n              if (usedHistory && this.resizeLastColumnInPair === \"right\" && direction === \"right\" && newColumnWidth.forColumn === \"left\") {\n                var originalMainColumn = mainColumn;\n                mainColumn = adjustedColumn;\n                adjustedColumn = (0, _resize.getAdjacentColumn)(originalMainColumn, \"+1\");\n              }\n\n              this.recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair);\n              this.resizeLastPosition = newColumnWidth.position;\n              this.resizeLastColumnInPair = modifyColumnInPair; // Ensure the adjusted column is marked as resizing to animate correctly\n\n              this.setColumnsAsResizing(mainColumn, adjustedColumn);\n              this.onColumnResize(mainColumn, newColumnWidth.width, adjustedColumn); // Wait for the render cycle to finish from the above resize before re-calculating\n\n              _underscore.defer(function () {\n                // If we do a resize, re-calculate the column widths\n                _this7.resizeColumnWidths = _this7.resizeUtils.determineColumnWidths(_this7.resizeColumnInstance, groupPosition);\n                _this7.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this7.resizeColumnWidths);\n              });\n            }\n          }\n        }\n      }\n    }\n    /**\n     * Unset resizing flag on all child columns\n     */\n    ;\n\n    _proto.unsetResizingColumns = function unsetResizingColumns() {\n      this.contentType.children().forEach(function (column) {\n        column.preview.resizing(false);\n\n        if (column.preview.element) {\n          column.preview.element.css({\n            transition: \"\"\n          });\n        }\n      });\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewLinePlaceDropPlaceholderVisible = function isNewLinePlaceDropPlaceholderVisible(event, linePosition) {\n      var siblings = this.contentType.parentContentType.children();\n      var id = this.contentType.id;\n      var index = 0;\n      siblings.forEach(function (columnLine) {\n        if (columnLine.id === id) {\n          return false;\n        }\n\n        index++;\n      });\n      var draggedColumn = (0, _registry.getDragColumn)(); // show column line drop placeholder only for top column line in a group\n\n      return (this.dropOverElement || draggedColumn) && event.pageY > linePosition.top + 15 && event.pageY < linePosition.top + 15 + this.lineDropperHeight;\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewLineBottomPlaceDropPlaceholderVisible = function isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition) {\n      var draggedColumn = (0, _registry.getDragColumn)();\n      return (this.dropOverElement || draggedColumn) && event.pageY < linePosition.top + 15 + this.element.outerHeight() && event.pageY > linePosition.top + 15 + this.element.outerHeight() - this.lineDropperHeight;\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewColumnDropPlaceholderVisible = function isNewColumnDropPlaceholderVisible(event, linePosition) {\n      var draggedColumn = (0, _registry.getDragColumn)();\n      return (this.dropOverElement || draggedColumn) && event.pageY > linePosition.top + 15 + this.lineDropperHeight && event.pageY < linePosition.top + 15 + linePosition.outerHeight - this.lineDropperHeight;\n    }\n    /**\n     * Handle mouse move events on when dropping elements\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} line\n     * @param {LinePositionCache} linePosition\n     */\n    ;\n\n    _proto.onDroppingMouseMove = function onDroppingMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.isNewLinePlaceDropPlaceholderVisible(event, linePosition)) {\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n        this.columnLineDropPlaceholder.addClass(\"active\");\n        this.columnLineDropPlaceholder.show();\n        return this.handleLineDropMouseMove(event, line, linePosition);\n      } else if (this.isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition)) {\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n        this.columnLineBottomDropPlaceholder.addClass(\"active\");\n        this.columnLineBottomDropPlaceholder.show();\n        return this.handleLineDropMouseMove(event, line, linePosition);\n      } else if (this.dropOverElement) {\n        this.columnLineDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n        this.columnLineDropPlaceholder.removeClass(\"active\");\n      }\n\n      if (this.isNewColumnDropPlaceholderVisible(event, linePosition)) {\n        this.columnLineDropPlaceholder.hide();\n        this.columnLineDropPlaceholder.removeClass(\"active\");\n        this.columnLineBottomDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n        return this.handleColumnDropMouseMove(event, line, linePosition);\n      }\n    }\n    /**\n     *\n     * @param event\n     * @param line\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.handleLineDropMouseMove = function handleLineDropMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Disable the column line sortable instance\n      // Disable the column group sortable instance\n\n      if (elementChildrenParent.data(\"ui-sortable\")) {\n        elementChildrenParent.sortable(\"option\", \"disabled\", true);\n      }\n    }\n    /**\n     *\n     * @param event\n     * @param line\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.handleColumnDropMouseMove = function handleColumnDropMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.dropOverElement && event.pageY > linePosition.top + 50 && event.pageY < linePosition.top + linePosition.outerHeight - 50) {\n        // Disable the column line sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", true);\n        }\n\n        var currentX = event.pageX - linePosition.left;\n        this.dropPosition = this.dropPositions.find(function (position) {\n          return currentX > position.left && currentX <= position.right && position.canShrink;\n        });\n\n        if (this.dropPosition) {\n          this.dropPlaceholder.removeClass(\"left right\").css({\n            left: this.dropPosition.placement === \"left\" ? this.dropPosition.left : \"\",\n            right: this.dropPosition.placement === \"right\" ? linePosition.width - this.dropPosition.right : \"\",\n            width: linePosition.width / this.resizeUtils.getGridSize() + \"px\"\n          }).addClass(this.dropPosition.placement);\n        }\n      } else if (this.dropOverElement) {\n        // Re-enable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", false);\n        }\n\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n      }\n    }\n    /**\n     * Cache the groups positions\n     *\n     * @param {JQuery} line\n     * @returns {}\n     */\n    ;\n\n    _proto.getLinePosition = function getLinePosition(line) {\n      if (!this.linePositionCache) {\n        this.linePositionCache = {\n          top: line.offset().top,\n          left: line.offset().left,\n          width: line.width(),\n          height: line.height(),\n          outerWidth: line.outerWidth(),\n          outerHeight: line.outerHeight()\n        };\n      }\n\n      return this.linePositionCache;\n    }\n    /**\n     * Init the droppable functionality for new columns\n     *\n     * @param {JQuery} line\n     */\n    ;\n\n    _proto.initDroppable = function initDroppable(line) {\n      var self = this;\n      var headStyles;\n      line.droppable({\n        deactivate: function deactivate() {\n          self.dropOverElement = null;\n          self.dropPlaceholder.removeClass(\"left right\");\n\n          _underscore.defer(function () {\n            // Re-enable the column group sortable instance & all children sortable instances\n            line.parents(\".element-children\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n              }\n            });\n          });\n        },\n        activate: function activate() {\n          if ((0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            var _ref;\n\n            line.find(\".ui-sortable\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", true);\n              }\n            });\n            var classes = [\".pagebuilder-content-type.pagebuilder-column .pagebuilder-drop-indicator\", \".pagebuilder-content-type.pagebuilder-column .empty-container .content-type-container:before\"]; // Ensure we don't display any drop indicators inside the column\n\n            headStyles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classes.join(\", \")] = {\n              display: \"none!important\"\n            }, _ref));\n            document.head.appendChild(headStyles);\n          } else if (headStyles) {\n            headStyles.remove();\n            headStyles = null;\n          }\n        },\n        drop: function drop() {\n          self.dropPositions = [];\n          self.dropPlaceholder.removeClass(\"left right\");\n        },\n        out: function out() {\n          self.dropOverElement = null;\n          self.dropPlaceholder.removeClass(\"left right\");\n        },\n        over: function over() {\n          // Is the element currently being dragged a column group?\n          if ((0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\") || (0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column\")) {\n            // Always calculate drop positions when an element is dragged over\n            var ownContentType = self.contentType;\n            self.dropPositions = (0, _dragAndDrop.calculateDropPositions)(ownContentType);\n            self.dropOverElement = true;\n          } else {\n            self.dropOverElement = null;\n          }\n        }\n      });\n    }\n    /**\n     * Spread any empty space across the other columns when a column is removed\n     *\n     * @param {number} removedIndex\n     */\n    ;\n\n    _proto.spreadWidth = function spreadWidth(removedIndex) {\n      if (this.contentType.children().length === 0) {\n        return;\n      }\n\n      var availableWidth = 100 - this.resizeUtils.getColumnsWidth();\n      var formattedAvailableWidth = (0, _resize.getRoundedColumnWidth)(availableWidth);\n      var totalChildColumns = this.contentType.children().length;\n      var allowedColumnWidths = [];\n      var spreadAcross = 1;\n      var spreadAmount;\n\n      for (var i = this.resizeUtils.getGridSize(); i > 0; i--) {\n        allowedColumnWidths.push((0, _resize.getRoundedColumnWidth)(100 / this.resizeUtils.getGridSize() * i));\n      } // Determine how we can spread the empty space across the columns\n\n\n      for (var _i = totalChildColumns; _i > 0; _i--) {\n        var potentialWidth = Math.floor(formattedAvailableWidth / _i);\n\n        for (var _iterator = _createForOfIteratorHelperLoose(allowedColumnWidths), _step; !(_step = _iterator()).done;) {\n          var width = _step.value;\n\n          if (potentialWidth === Math.floor(width)) {\n            spreadAcross = _i;\n            spreadAmount = formattedAvailableWidth / _i;\n            break;\n          }\n        }\n\n        if (spreadAmount) {\n          break;\n        }\n      } // Let's spread the width across the columns\n\n\n      for (var _i2 = 1; _i2 <= spreadAcross; _i2++) {\n        var columnToModify = void 0; // As the original column has been removed from the array, check the new index for a column\n\n        if (removedIndex <= this.contentType.children().length && typeof this.contentType.children()[removedIndex] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex];\n        }\n\n        if (!columnToModify && removedIndex - _i2 >= 0 && typeof this.contentType.children()[removedIndex - _i2] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex - _i2];\n        }\n\n        if (columnToModify) {\n          (0, _resize.updateColumnWidth)(columnToModify, this.resizeUtils.getColumnWidth(columnToModify) + spreadAmount);\n        }\n      }\n    }\n    /**\n     * Register a resize handle within a child column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {JQuery} handle\n     */\n    ;\n\n    _proto.registerResizeHandle = function registerResizeHandle(column, handle) {\n      var _this8 = this;\n\n      handle.off(\"mousedown touchstart\");\n      handle.on(\"mousedown touchstart\", function (event) {\n        event.preventDefault();\n\n        var groupPosition = _this8.getLinePosition(_this8.element);\n\n        _this8.resizing(true); // @ts-ignore\n\n\n        _this8.resizeColumnInstance = column;\n        _this8.resizeColumnWidths = _this8.resizeUtils.determineColumnWidths(_this8.resizeColumnInstance, groupPosition);\n        _this8.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this8.resizeColumnWidths); // Force the cursor to resizing\n\n        (0, _jquery)(\"body\").css(\"cursor\", \"col-resize\"); // Reset the resize history\n\n        _this8.resizeHistory = {\n          left: [],\n          right: []\n        };\n        _this8.resizeLastPosition = null;\n        _this8.resizeMouseDown = true;\n        ++_this8.interactionLevel;\n\n        _events.trigger(\"stage:interactionStart\", {\n          stageId: _this8.contentType.stageId\n        });\n      });\n    }\n    /**\n     * Add Columns to the current Column Line\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumns = function createColumns() {\n      var _this9 = this;\n\n      var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n      var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n      Promise.all([(0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: col1Width + \"%\"\n      }), (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: 100 - parseFloat(col1Width) + \"%\"\n      })]).then(function (columns) {\n        _this9.contentType.addChild(columns[0], 0);\n\n        _this9.contentType.addChild(columns[1], 1);\n\n        _this9.fireMountEvent(_this9.contentType, columns[0], columns[1]);\n      });\n    }\n    /**\n     * Record the resizing history for this action\n     *\n     * @param {string} usedHistory\n     * @param {string} direction\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     * @param {string} modifyColumnInPair\n     */\n    ;\n\n    _proto.recordResizeHistory = function recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair) {\n      if (usedHistory) {\n        this.resizeHistory[usedHistory].pop();\n      }\n\n      this.resizeHistory[direction].push({\n        adjustedColumn: adjustedColumn,\n        modifyColumnInPair: modifyColumnInPair\n      });\n    }\n    /**\n     * Set columns in the group as resizing\n     *\n     * @param {Array<ContentTypeCollectionInterface<ColumnPreview>>} columns\n     */\n    ;\n\n    _proto.setColumnsAsResizing = function setColumnsAsResizing() {\n      for (var _len = arguments.length, columns = new Array(_len), _key = 0; _key < _len; _key++) {\n        columns[_key] = arguments[_key];\n      }\n\n      columns.forEach(function (column) {\n        column.preview.resizing(true);\n        column.preview.element.css({\n          transition: \"width 350ms ease-in-out\"\n        });\n      });\n    }\n    /**\n     * Handle a column being resized\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(column, width, adjustedColumn) {\n      this.resizeUtils.resizeColumn(column, width, adjustedColumn);\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len2 = arguments.length, contentTypes = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n        contentTypes[_key2] = arguments[_key2];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Remove self if we contain no children\n     */\n    ;\n\n    _proto.removeIfEmpty = function removeIfEmpty() {\n      if (this.contentType.children().length === 0) {\n        this.contentType.parentContentType.removeChild(this.contentType);\n        return;\n      }\n    };\n\n    _proto.getNewColumnLineIndex = function getNewColumnLineIndex() {\n      var index = -1;\n      var self = this;\n\n      for (var _iterator2 = _createForOfIteratorHelperLoose(this.contentType.parentContentType.children()), _step2; !(_step2 = _iterator2()).done;) {\n        var child = _step2.value;\n        index++;\n\n        if (child.id === self.contentType.id) {\n          break;\n        }\n      }\n\n      if (this.columnLineBottomDropPlaceholder.hasClass(\"active\")) {\n        // show the bottom drop placeholder\n        index++;\n      }\n\n      return index;\n    };\n\n    _proto.isColumnBeingMovedToAnotherColumnLine = function isColumnBeingMovedToAnotherColumnLine() {\n      var column = (0, _registry.getDragColumn)();\n\n      if (!column) {\n        // if no move position, column is not being moved.\n        return false;\n      }\n\n      if (column.parentContentType !== this.contentType) {\n        // if the parent content type is not same as this column line, column is being moved to new column line\n        return true;\n      }\n\n      if (column.parentContentType === this.contentType && (this.columnLineDropPlaceholder.hasClass(\"active\") || this.columnLineBottomDropPlaceholder.hasClass(\"active\"))) {\n        // since new column line drop placeholder is visible, column move should introduce a new column line\n        return true;\n      }\n\n      return false;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column-line/drag-and-drop.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Calculate the drop positions of a column group\n   *\n   * @param {ContentTypeCollectionInterface} group\n   * @returns {any[]}\n   */\n  function calculateDropPositions(line) {\n    var resizeUtils = line.preview.getResizeUtils();\n    var dropPositions = [];\n    line.children().forEach(function (column, index) {\n      var left = column.preview.element.position().left;\n      var width = column.preview.element.outerWidth(true);\n      var canShrink = resizeUtils.getAcceptedColumnWidth(resizeUtils.getColumnWidth(column).toString()) > resizeUtils.getSmallestColumnWidth();\n      dropPositions.push({\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index,\n        left: left,\n        placement: \"left\",\n        right: left + width / 2\n      }, {\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index + 1,\n        left: left + width / 2,\n        placement: \"right\",\n        right: left + width\n      });\n    });\n    return dropPositions;\n  }\n\n  return {\n    calculateDropPositions: calculateDropPositions\n  };\n});\n//# sourceMappingURL=drag-and-drop.js.map","Magento_PageBuilder/js/content-type/slide/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/nesting-link-dialog\", \"Magento_PageBuilder/js/utils/nesting-widget-dialog\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jarallax, _jarallaxVideo, _jquery, _knockout, _translate, _events, _mageUtils, _underscore, _vimeoWrapper, _conditionalRemoveOption, _uploader, _delayUntil, _editor, _nestingLinkDialog, _nestingWidgetDialog, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      _this.slideName = _knockout.observable();\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.slideChanged = true;\n      _this.handledDoubleClick = false;\n      _this.videoUpdateProperties = [\"background_type\", \"video_fallback_image\", \"video_lazy_load\", \"video_loop\", \"video_play_only_visible\", \"video_source\"];\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.wrapper, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.wrapper && _this.wrapper.dataset.backgroundType === \"video\" && _this.wrapper.dataset.videoSrc.length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            var viewportElement = (0, _jquery)(\"<div/>\").addClass(\"jarallax-viewport-element\");\n            (0, _jquery)(_this.wrapper).append((0, _jquery)(\".jarallax-viewport-element\", _this.wrapper).length ? \"\" : viewportElement);\n            jarallax(_this.wrapper, {\n              videoSrc: _this.wrapper.dataset.videoSrc,\n              imgSrc: _this.wrapper.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: 1,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              elementInViewport: (0, _jquery)(\".jarallax-viewport-element\", _this.wrapper),\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.wrapper.jarallax && _this.wrapper.jarallax.video) {\n              // @ts-ignore\n              _this.wrapper.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.wrapper.jarallax && _this.wrapper.jarallax.$video) {\n                  // @ts-ignore\n                  _this.wrapper.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.content.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.content.html();\n        }\n      }, \"content\");\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Set state based on overlay mouseover event for the preview\n     */\n    ;\n\n    _proto.onMouseOverWrapper = function onMouseOverWrapper() {\n      // Triggers the visibility of the overlay content to show\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.attributes(Object.assign(this.data.overlay.attributes(), {\n          \"data-background-color-orig\": this.data.overlay.style().backgroundColor\n        }));\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-overlay-color\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 1,\n          visibility: \"visible\"\n        }));\n      }\n    }\n    /**\n     * Set state based on overlay mouseout event for the preview\n     */\n    ;\n\n    _proto.onMouseOutWrapper = function onMouseOutWrapper() {\n      // Triggers the visibility of the overlay content to hide\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-background-color-orig\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 0,\n          visibility: \"hidden\"\n        }));\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      delete options.move;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\"); // Create uploader\n\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this3 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this3.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this3.handledDoubleClick = true;\n\n              _this3.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this3.element);\n            }, function () {\n              return _this3.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      } else if (this.element && this.wysiwyg) {\n        var element = this.element || this.textarea;\n\n        if (event.currentTarget !== event.target && event.target !== element && !element.contains(event.target)) {\n          return;\n        }\n\n        element.focus();\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this4 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this4.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this5 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"content\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this5.textarea.value = _this5.contentType.dataStore.get(\"content\");\n\n        _this5.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"content\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(true);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this6 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function (editor) {\n          editor.on(\"blur\", function () {\n            (0, _nestingLinkDialog)(_this6.contentType.dataStore, _this6.wysiwyg, \"content\", \"link_url\");\n            (0, _nestingWidgetDialog)(_this6.contentType.dataStore, _this6.wysiwyg, \"content\", \"link_url\");\n          });\n\n          _underscore.defer(function () {\n            _this6.element.blur();\n\n            _this6.element.focus();\n          });\n        };\n      }\n\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"content\", this.contentType.stageId).then(function (wysiwyg) {\n        _this6.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this7 = this;\n\n      this.wrapper = element;\n\n      _underscore.defer(function () {\n        _this7.buildJarallax();\n      });\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _preview2.prototype.destroy.call(this);\n\n      if (this.wrapper) {\n        jarallax(this.wrapper, \"destroy\");\n      }\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"slide:mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.buildJarallax();\n\n          _this8.isSnapshot.subscribe(function (value) {\n            _this8.changeUploaderControlsVisibility();\n          });\n\n          _this8.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var dataStore = _this8.contentType.dataStore.getState();\n\n        var imageObject = dataStore[_this8.config.additional_data.uploaderConfig.dataScope][0] || {};\n\n        _events.trigger(\"image:\" + _this8.contentType.id + \":assignAfter\", imageObject);\n      }); // Remove wysiwyg before assign new instance.\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this8.contentType.parentContentType.id) {\n          _this8.wysiwyg = null;\n        }\n      });\n\n      _events.on(this.config.name + \":mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          // Update the display label for the slide\n          var slider = _this8.contentType.parentContentType;\n\n          _this8.displayLabel((0, _translate)(\"Slide \" + (slider.children().indexOf(_this8.contentType) + 1)));\n\n          slider.children.subscribe(function (children) {\n            var index = children.indexOf(_this8.contentType);\n\n            _this8.displayLabel((0, _translate)(\"Slide \" + (slider.children().indexOf(_this8.contentType) + 1)));\n          });\n        }\n      });\n\n      _events.on(this.config.name + \":renderAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          var slider = _this8.contentType.parentContentType;\n          (0, _jquery)(slider.preview.element).on(\"beforeChange\", function () {\n            _this8.slideChanged = false;\n          });\n          (0, _jquery)(slider.preview.element).on(\"afterChange\", function (event, slick) {\n            (0, _jquery)(slick.$slides).each(function (index, slide) {\n              var videoSlide = slide.querySelector(\".jarallax\");\n\n              if (videoSlide) {\n                jarallax(videoSlide, \"onScroll\");\n              }\n            });\n            _this8.slideChanged = true;\n          });\n        }\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _this8.slideName(data.slide_name);\n\n        if (_this8.shouldUpdateVideo(data)) {\n          _this8.buildJarallax();\n        }\n      });\n\n      _events.on(\"image:\" + this.contentType.id + \":uploadAfter\", function () {\n        _this8.contentType.dataStore.set(\"background_type\", \"image\");\n      });\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        if (_this8.contentType.dataStore.get(\"background_type\") === \"video\") {\n          _this8.buildJarallax();\n        }\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this9 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this9.isSnapshot();\n      });\n    }\n    /**\n     * Update image data inside data store\n     *\n     * @param {Array} data - list of each files' data\n     */\n    ;\n\n    _proto.onImageUploaded = function onImageUploaded(data) {\n      this.contentType.dataStore.set(this.config.additional_data.uploaderConfig.dataScope, data);\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    }\n    /**\n     * Check if video options has been updated.\n     *\n     * @return boolean\n     */\n    ;\n\n    _proto.shouldUpdateVideo = function shouldUpdateVideo(state) {\n      var _this10 = this;\n\n      var previousState = this.contentType.dataStore.getPreviousState();\n\n      var diff = _mageUtils.compare(previousState, state).changes;\n\n      if (diff.length > 0) {\n        return _underscore.some(diff, function (element) {\n          if (element.name === \"video_fallback_image\") {\n            return (!_underscore.isEmpty(previousState.video_fallback_image) && previousState.video_fallback_image) !== (!_underscore.isEmpty(state.video_fallback_image) && state.video_fallback_image);\n          }\n\n          return _this10.videoUpdateProperties.indexOf(element.name) !== -1;\n        });\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slide/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function ($, _, showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]'),\n            viewportElement = document.createElement('div'),\n            $slider = null;\n\n        showOnHover(config);\n\n        if (videoElement) {\n            $slider = $(element).closest('[data-content-type=slider]');\n            viewportElement.classList.add('jarallax-viewport-element');\n            videoElement.setAttribute('data-element-in-viewport', '.jarallax-viewport-element');\n            videoElement.appendChild(viewportElement);\n            videoBackground(config, videoElement);\n\n            if ($slider.data('afterChangeIsSet')) {\n                return;\n            }\n\n            $slider.on('afterChange init', function () {\n                var videoSlides = $slider[0].querySelectorAll('.jarallax');\n\n                _.each(videoSlides, function (videoSlide) {\n                    videoSlide.jarallax && videoSlide.jarallax.onScroll();\n                });\n            });\n            $slider.data('afterChangeIsSet', true);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/slide/converter/style/button-opacity.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonOpacity = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonOpacity() {}\n\n    var _proto = ButtonOpacity.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"1\" : \"0\";\n    };\n\n    return ButtonOpacity;\n  }();\n\n  return ButtonOpacity;\n});\n//# sourceMappingURL=button-opacity.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var result = {};\n\n      if (undefined !== value.padding) {\n        result.padding = {\n          bottom: value.padding.bottom.replace(\"px\", \"\"),\n          left: value.padding.left.replace(\"px\", \"\"),\n          right: value.padding.right.replace(\"px\", \"\"),\n          top: value.padding.top.replace(\"px\", \"\")\n        };\n      }\n\n      if (result.padding.right[0] === \"c\") {\n        result.padding.right = parseInt(result.padding.right.split(\"+\")[1].trim(), 10);\n      }\n\n      if (result.padding.left[0] === \"c\") {\n        result.padding.left = parseInt(result.padding.left.split(\"+\")[1].trim(), 10);\n      }\n\n      return result;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/overlay-background-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayBackgroundColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBackgroundColor() {}\n\n    var _proto = OverlayBackgroundColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (data.show_overlay === \"always\" && value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return OverlayBackgroundColor;\n  }();\n\n  return OverlayBackgroundColor;\n});\n//# sourceMappingURL=overlay-background-color.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/button-visibility.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonVisibility = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonVisibility() {}\n\n    var _proto = ButtonVisibility.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"visible\" : \"hidden\";\n    };\n\n    return ButtonVisibility;\n  }();\n\n  return ButtonVisibility;\n});\n//# sourceMappingURL=button-visibility.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/slide/converter/attribute/overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.overlay_color) {\n        return data.overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=overlay-color.js.map","Magento_PageBuilder/js/content-type/slide/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\", \"Magento_PageBuilder/js/utils/delay-until\"], function (_jquery, _events, _delayUntil) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {\n      this.sliderSelector = \".slick-list\";\n      this.sliderContentSelector = \".slick-track\";\n      this.slideSelector = \".slick-slide\";\n      this.activeSlideSelector = \".slick-current\";\n      this.slideChanging = false;\n    }\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      var _this = this;\n\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this)); // Update our KO pointer to the active slide on change\n\n      (0, _jquery)(this.$element.parents(this.sliderSelector)).parent().on(\"beforeChange\", function () {\n        _this.slideChanging = true;\n      }).on(\"afterChange\", function () {\n        _this.slideChanging = false;\n      });\n    }\n    /**\n     * Event handler for wysiwyg focus\n     * Fixes z-index issues for tabs and column\n     * Fixes slider\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this2 = this;\n\n      var $slider = (0, _jquery)(this.$element.parents(this.sliderSelector));\n      var sliderContent = this.$element.parents(this.sliderContentSelector)[0];\n      var $notActiveSlides = $slider.find(this.slideSelector).not(this.activeSlideSelector); // If there isn't enough room for a left-aligned toolbar, right align it\n\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      (0, _delayUntil)(function () {\n        _jquery.each(_this2.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n          _this2.$element.closest(selector).css(\"z-index\", 100);\n        }); // Disable slider keyboard events and fix problem with overflow hidden issue\n\n\n        $slider.parent().slick(\"slickSetOption\", \"accessibility\", false);\n        _this2.autoplay = $slider.parent().slick(\"slickGetOption\", \"autoplay\");\n        _this2.fade = $slider.parent().slick(\"slickGetOption\", \"fade\");\n\n        if (_this2.autoplay) {\n          $slider.parent().slick(\"slickPause\");\n        }\n\n        if (!_this2.fade) {\n          $notActiveSlides.css(\"display\", \"none\");\n        }\n\n        _this2.sliderTransform = sliderContent.style.transform;\n        sliderContent.style.transform = \"\";\n        $slider.css(\"overflow\", \"visible\");\n      }, function () {\n        return !_this2.slideChanging;\n      }, 10);\n    }\n    /**\n     * Event handler for wysiwyg blur\n     * Fixes z-index issues for tabs and column\n     * Fixes slider\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this3 = this;\n\n      var $slider = (0, _jquery)(this.$element.parents(this.sliderSelector));\n      var sliderContent = this.$element.parents(this.sliderContentSelector)[0];\n      var $notActiveSlides = $slider.find(this.slideSelector).not(this.activeSlideSelector);\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this3.$element.closest(selector).css(\"z-index\", \"\");\n      }); // Enable slider keyboard events and revert changes made in onFocus\n\n\n      $slider.css(\"overflow\", \"hidden\");\n      sliderContent.style.transform = this.sliderTransform;\n      $notActiveSlides.css(\"display\", \"block\");\n      $slider.parent().slick(\"slickSetOption\", \"accessibility\", true);\n\n      if (this.autoplay) {\n        $slider.parent().slick(\"slickPlay\");\n      }\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/slide/wysiwyg/tinymce/config-modifier.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConfigModifier = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConfigModifier() {}\n\n    var _proto = ConfigModifier.prototype;\n\n    /**\n     * Initialize the config\n     *\n     * @param {String} contentTypeId\n     * @param {Object} config\n     */\n    _proto.modify = function modify(contentTypeId, config) {\n      if (config.adapter_config.mode === \"inline\") {\n        config.adapter.settings.fixed_toolbar_container = \"#\" + contentTypeId + \" .wysiwyg-container\";\n      }\n    };\n\n    return ConfigModifier;\n  }();\n\n  return ConfigModifier;\n});\n//# sourceMappingURL=config-modifier.js.map","Magento_PageBuilder/js/content-type/button-item/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _conditionalRemoveOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Use the conditional remove to disable the option when the parent has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      delete options.title;\n      delete options.move;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    }\n    /**\n     * Force the focus on the clicked button\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onClick = function onClick(index, event) {\n      (0, _jquery)(event.currentTarget).find(\"[contenteditable]\").focus();\n      event.stopPropagation();\n    }\n    /**\n     * Handle on focus out events, when the button item is focused out we need to set our focusedButton record on the\n     * buttons preview item to null. If we detect this focus out event is to focus into another button we need to ensure\n     * we update the record appropriately.\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(index, event) {\n      if (this.contentType && this.contentType.parentContentType) {\n        var parentPreview = this.contentType.parentContentType.preview;\n\n        var unfocus = function unfocus() {\n          window.getSelection().removeAllRanges();\n          parentPreview.focusedButton(null);\n        };\n\n        if (event.relatedTarget && _jquery.contains(parentPreview.wrapperElement, event.relatedTarget)) {\n          // Verify the focus was not onto the options menu\n          if ((0, _jquery)(event.relatedTarget).closest(\".pagebuilder-options\").length > 0) {\n            unfocus();\n          } else {\n            // Have we moved the focus onto another button in the current group?\n            var buttonItem = _knockout.dataFor(event.relatedTarget);\n\n            if (buttonItem && buttonItem.contentType && buttonItem.contentType.parentContentType && buttonItem.contentType.parentContentType.id === this.contentType.parentContentType.id) {\n              var newIndex = buttonItem.contentType.parentContentType.children().indexOf(buttonItem.contentType);\n              parentPreview.focusedButton(newIndex);\n            } else {\n              unfocus();\n            }\n          }\n        } else if (parentPreview.focusedButton() === index) {\n          unfocus();\n        }\n      }\n    }\n    /**\n     * On focus in set the focused button\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(index, event) {\n      var parentPreview = this.contentType.parentContentType.preview;\n\n      if (parentPreview.focusedButton() !== index) {\n        parentPreview.focusedButton(index);\n      }\n    }\n    /**\n     * If the button is displayed we need to show the options menu on hover\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onButtonMouseOver = function onButtonMouseOver(context, event) {\n      if (this.display() === false) {\n        this.onMouseOver(context, event);\n      }\n    }\n    /**\n     * If the button is displayed we need to hide the options menu on mouse out\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onButtonMouseOut = function onButtonMouseOut(context, event) {\n      if (this.display() === false) {\n        this.onMouseOut(context, event);\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/button-item/converter/style/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be inline block\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"inline-block\";\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/content-type/tab-item/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _conditionalRemoveOption, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _previewCollection2.call.apply(_previewCollection2, [this].concat(args)) || this;\n      _this.fieldsToIgnoreOnRemove = [\"tab_name\"];\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Force the focus on the clicked tab header\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onClick = function onClick(index, event) {\n      (0, _jquery)(event.currentTarget).find(\"[contenteditable]\").focus();\n      event.stopPropagation();\n    }\n    /**\n     * On focus in set the focused button\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(index, event) {\n      var parentPreview = this.contentType.parentContentType.preview;\n\n      if (parentPreview.focusedTab() !== index) {\n        parentPreview.setFocusedTab(index, true);\n      }\n    }\n    /**\n     * On focus out set the focused tab to null\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(index, event) {\n      if (this.contentType && this.contentType.parentContentType) {\n        var parentPreview = this.contentType.parentContentType.preview;\n\n        var unfocus = function unfocus() {\n          window.getSelection().removeAllRanges();\n          parentPreview.focusedTab(null);\n        };\n\n        if (event.relatedTarget && _jquery.contains(parentPreview.wrapperElement, event.relatedTarget)) {\n          // Verify the focus was not onto the options menu\n          if ((0, _jquery)(event.relatedTarget).closest(\".pagebuilder-options\").length > 0) {\n            unfocus();\n          } else {\n            // Have we moved the focus onto another button in the current group?\n            var tabItem = _knockout.dataFor(event.relatedTarget);\n\n            if (tabItem && tabItem.contentType && tabItem.contentType.parentContentType && tabItem.contentType.parentContentType.id === this.contentType.parentContentType.id) {\n              var newIndex = tabItem.contentType.parentContentType.children().indexOf(tabItem.contentType);\n              parentPreview.setFocusedTab(newIndex, true);\n            } else {\n              unfocus();\n            }\n          }\n        } else if (parentPreview.focusedTab() === index) {\n          unfocus();\n        }\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      delete options.move;\n      delete options.title;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/banner/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"jquery/z-index\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/nesting-link-dialog\", \"Magento_PageBuilder/js/utils/nesting-widget-dialog\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jarallax, _jarallaxVideo, _jquery, _zIndex, _translate, _events, _mageUtils, _underscore, _vimeoWrapper, _hideShowOption, _uploader, _delayUntil, _editor, _nestingLinkDialog, _nestingWidgetDialog, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.handledDoubleClick = false;\n      _this.videoUpdateProperties = [\"background_type\", \"video_fallback_image\", \"video_lazy_load\", \"video_loop\", \"video_play_only_visible\", \"video_source\"];\n      _this.bannerOverlaySelector = \".pagebuilder-overlay\";\n      _this.defaultOverlayZIndex = 2;\n      _this.activeEditorOverlayZIndex = 3;\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.wrapper, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.wrapper && _this.wrapper.dataset.backgroundType === \"video\" && _this.wrapper.dataset.videoSrc.length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            jarallax(_this.wrapper, {\n              videoSrc: _this.wrapper.dataset.videoSrc,\n              imgSrc: _this.wrapper.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: 1,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.wrapper.jarallax && _this.wrapper.jarallax.video) {\n              // @ts-ignore\n              _this.wrapper.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.wrapper.jarallax && _this.wrapper.jarallax.$video) {\n                  // @ts-ignore\n                  _this.wrapper.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\"); // Create uploader\n\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.content.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.content.html();\n        }\n      }, \"message\");\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(false);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this3 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function (editor) {\n          editor.on(\"focus\", function () {\n            (0, _jquery)(_this3.element).parents(_this3.bannerOverlaySelector).zIndex(_this3.activeEditorOverlayZIndex);\n          });\n          editor.on(\"blur\", function () {\n            (0, _jquery)(_this3.element).parents(_this3.bannerOverlaySelector).zIndex(_this3.defaultOverlayZIndex);\n            (0, _nestingLinkDialog)(_this3.contentType.dataStore, _this3.wysiwyg, \"message\", \"link_url\");\n            (0, _nestingWidgetDialog)(_this3.contentType.dataStore, _this3.wysiwyg, \"message\", \"link_url\");\n          });\n\n          _underscore.defer(function () {\n            _this3.element.blur();\n\n            _this3.element.focus();\n          });\n        };\n      }\n\n      wysiwygConfig.adapter.settings.fixed_toolbar_container = \"#\" + this.contentType.id + \" .pagebuilder-banner-text-content\";\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"message\", this.contentType.stageId).then(function (wysiwyg) {\n        _this3.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this4 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this4.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this4.handledDoubleClick = true;\n\n              _this4.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this4.element);\n            }, function () {\n              return _this4.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      } else if (this.element && this.wysiwyg) {\n        var element = this.element || this.textarea;\n\n        if (event.currentTarget !== event.target && event.target !== element && !element.contains(event.target)) {\n          return;\n        }\n\n        element.focus();\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this5 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this5.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Set state based on overlay mouseover event for the preview\n     */\n    ;\n\n    _proto.onMouseOverWrapper = function onMouseOverWrapper() {\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.attributes(Object.assign(this.data.overlay.attributes(), {\n          \"data-background-color-orig\": this.data.overlay.style().backgroundColor\n        }));\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-overlay-color\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 1,\n          visibility: \"visible\"\n        }));\n      }\n    }\n    /**\n     * Set state based on overlay mouseout event for the preview\n     */\n    ;\n\n    _proto.onMouseOutWrapper = function onMouseOutWrapper() {\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-background-color-orig\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 0,\n          visibility: \"hidden\"\n        }));\n      }\n    }\n    /**\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this6 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"message\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this6.textarea.value = _this6.contentType.dataStore.get(\"message\");\n\n        _this6.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"message\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-banner-text-content\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-banner-text-content\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this7 = this;\n\n      this.wrapper = element;\n\n      _underscore.defer(function () {\n        _this7.buildJarallax();\n      });\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _preview2.prototype.destroy.call(this);\n\n      if (this.wrapper) {\n        jarallax(this.wrapper, \"destroy\");\n      }\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"banner:mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.buildJarallax();\n\n          _this8.isSnapshot.subscribe(function (value) {\n            _this8.changeUploaderControlsVisibility();\n          });\n\n          _this8.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var dataStore = _this8.contentType.dataStore.getState();\n\n        var imageObject = dataStore[_this8.config.additional_data.uploaderConfig.dataScope][0] || {}; // Resolves issue when tinyMCE injects a non-breaking space on reinitialization and removes placeholder.\n\n        if (dataStore.message === \"<div data-bind=\\\"html: data.content.html\\\">&nbsp;</div>\") {\n          _this8.contentType.dataStore.set(\"message\", \"\");\n        }\n\n        _events.trigger(\"image:\" + _this8.contentType.id + \":assignAfter\", imageObject);\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        if (this.shouldUpdateVideo(data)) {\n          this.buildJarallax();\n        }\n      }.bind(this));\n\n      _events.on(\"image:\" + this.contentType.id + \":uploadAfter\", function () {\n        _this8.contentType.dataStore.set(\"background_type\", \"image\");\n      });\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this8.buildJarallax();\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this9 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this9.isSnapshot();\n      });\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    }\n    /**\n     * Check if video options has been updated.\n     *\n     * @return boolean\n     */\n    ;\n\n    _proto.shouldUpdateVideo = function shouldUpdateVideo(state) {\n      var _this10 = this;\n\n      var previousState = this.contentType.dataStore.getPreviousState();\n\n      var diff = _mageUtils.compare(previousState, state).changes;\n\n      if (diff.length > 0) {\n        return _underscore.some(diff, function (element) {\n          if (element.name === \"video_fallback_image\") {\n            return (!_underscore.isEmpty(previousState.video_fallback_image) && previousState.video_fallback_image) !== (!_underscore.isEmpty(state.video_fallback_image) && state.video_fallback_image);\n          }\n\n          return _this10.videoUpdateProperties.indexOf(element.name) !== -1;\n        });\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/banner/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function (showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]');\n\n        showOnHover(config);\n\n        if (videoElement) {\n            videoBackground(config, videoElement);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/banner/converter/style/button-opacity.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonOpacity = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonOpacity() {}\n\n    var _proto = ButtonOpacity.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"1\" : \"0\";\n    };\n\n    return ButtonOpacity;\n  }();\n\n  return ButtonOpacity;\n});\n//# sourceMappingURL=button-opacity.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/overlay-background-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayBackgroundColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBackgroundColor() {}\n\n    var _proto = OverlayBackgroundColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (data.show_overlay === \"always\" && value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return OverlayBackgroundColor;\n  }();\n\n  return OverlayBackgroundColor;\n});\n//# sourceMappingURL=overlay-background-color.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/button-visibility.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonVisibility = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonVisibility() {}\n\n    var _proto = ButtonVisibility.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"visible\" : \"hidden\";\n    };\n\n    return ButtonVisibility;\n  }();\n\n  return ButtonVisibility;\n});\n//# sourceMappingURL=button-visibility.js.map","Magento_PageBuilder/js/content-type/banner/converter/attribute/overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.overlay_color) {\n        return data.overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=overlay-color.js.map","Magento_PageBuilder/js/content-type/banner/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\"], function (_jquery, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {}\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * The editor element\n     */\n\n    /**\n     * The configuration of the wysiwyg content type\n     */\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n    }\n    /**\n     * Called when tinymce is focused\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this = this;\n\n      // If there isn't enough room for a left-aligned toolbar, right align it\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this.$element.closest(selector).css(\"z-index\", 100);\n      });\n    }\n    /**\n     * Called when tinymce is blurred\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this2 = this;\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this2.$element.closest(selector).css(\"z-index\", \"\");\n      });\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/slider/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"slick\", \"underscore\", \"Magento_PageBuilder/js/binding/focus\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _slick, _underscore, _focus, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _promiseDeferred, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Define keys which when changed should not trigger the slider to be rebuilt\n     *\n     * @type {string[]}\n     */\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Wait for the tabs instance to mount and the container to be ready\n\n      _this.focusedSlide = _knockout.observable();\n      _this.activeSlide = _knockout.observable(0);\n      _this.events = {\n        columnWidthChangeAfter: \"onColumnResize\"\n      };\n      _this.ready = false;\n      _this.mountAfterDeferred = (0, _promiseDeferred)();\n      _this.afterChildrenRenderDeferred = (0, _promiseDeferred)();\n      _this.buildSlickDebounce = _underscore.debounce(_this.buildSlick.bind(_assertThisInitialized(_this)), 10);\n      _this.ignoredKeysForBuild = [\"display\", \"margins_and_padding\", \"border\", \"border_color\", \"border_radius\", \"border_width\", \"css_classes\", \"name\", \"text_align\"];\n      Promise.all([_this.afterChildrenRenderDeferred.promise, _this.mountAfterDeferred.promise]).then(function (_ref) {\n        var element = _ref[0],\n            expectedChildren = _ref[1];\n        // We always create 1 tab when dropping tabs into the instance\n        expectedChildren = expectedChildren || 1; // Wait until all children's DOM elements are present before building the tabs instance\n\n        (0, _delayUntil)(function () {\n          _this.element = element;\n          _this.childSubscribe = _this.contentType.children.subscribe(_this.buildSlickDebounce);\n          _this.previousData = _this.contentType.dataStore.getState();\n\n          _this.contentType.dataStore.subscribe(function (data) {\n            if (_this.hasDataChanged(_this.previousData, data)) {\n              _this.buildSlickDebounce();\n            }\n\n            _this.previousData = data;\n          });\n\n          _this.buildSlick(); // Redraw slide after content type gets redrawn\n\n\n          _events.on(\"contentType:redrawAfter\", function (args) {\n            var $element = (0, _jquery)(_this.element);\n\n            if (args.element && _this.element && $element.closest(args.element).length) {\n              $element.slick(\"setPosition\");\n            }\n          }); // Set the stage to interacting when a slide is focused\n\n\n          _this.focusedSlideSubscriber = _this.focusedSlide.subscribe(function (value) {\n            if (value !== null) {\n              _events.trigger(\"stage:interactionStart\");\n            } else {\n              _events.trigger(\"stage:interactionStop\");\n            }\n          });\n\n          _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.onColumnResize.bind(_assertThisInitialized(_this), [true]));\n\n          _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function () {\n            if (_this.element) {\n              (0, _jquery)(_this.element).slick(\"setPosition\");\n\n              _this.checkWidth();\n            }\n          });\n        }, function () {\n          return (0, _jquery)(element).find(\".pagebuilder-slide\").length === expectedChildren;\n        });\n      });\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add\"),\n        action: this.addSlide,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Set an active slide for navigation dot\n     *\n     * @param slideIndex\n     */\n    ;\n\n    _proto.setActiveSlide = function setActiveSlide(slideIndex) {\n      this.activeSlide(slideIndex);\n    }\n    /**\n     * Set the focused slide\n     *\n     * @param {number} slideIndex\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.setFocusedSlide = function setFocusedSlide(slideIndex, force) {\n      if (force === void 0) {\n        force = false;\n      }\n\n      if (force) {\n        this.focusedSlide(null);\n      }\n\n      this.focusedSlide(slideIndex);\n    }\n    /**\n     * Unset focused slide on focusout event.\n     *\n     * @param {PreviewCollection} data\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(data, event) {\n      var relatedTarget = event.relatedTarget;\n\n      if (!relatedTarget && document.activeElement && !(document.activeElement instanceof HTMLBodyElement)) {\n        relatedTarget = document.activeElement;\n      }\n\n      if (!relatedTarget) {\n        this.setFocusedSlide(null);\n        return;\n      }\n\n      var $relatedTarget = (0, _jquery)(relatedTarget);\n      var isRelatedTargetDescendantOfNavigation = $relatedTarget.closest(this.navigationElement).length;\n      var isFocusedOnAnotherSlideInThisSlider = $relatedTarget.hasClass(\"navigation-dot-anchor\") && isRelatedTargetDescendantOfNavigation;\n\n      if (isFocusedOnAnotherSlideInThisSlider) {\n        _events.trigger(\"stage:interactionStop\");\n      } else if (!isRelatedTargetDescendantOfNavigation) {\n        this.setFocusedSlide(null);\n      }\n    }\n    /**\n     * Set reference to navigation element in template\n     *\n     * @param {HTMLElement} navigationElement\n     */\n    ;\n\n    _proto.afterNavigationRender = function afterNavigationRender(navigationElement) {\n      this.navigationElement = navigationElement;\n    }\n    /**\n     * Navigate to a slide\n     *\n     * @param {number} slideIndex\n     * @param {boolean} dontAnimate\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.navigateToSlide = function navigateToSlide(slideIndex, dontAnimate, force) {\n      if (dontAnimate === void 0) {\n        dontAnimate = false;\n      }\n\n      if (force === void 0) {\n        force = false;\n      }\n\n      if ((0, _jquery)(this.element).hasClass(\"slick-initialized\")) {\n        (0, _jquery)(this.element).slick(\"slickGoTo\", slideIndex, dontAnimate);\n        this.setActiveSlide(slideIndex);\n        this.setFocusedSlide(slideIndex, force);\n      }\n    }\n    /**\n     * After child render record element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterChildrenRender = function afterChildrenRender(element) {\n      this.element = element; // if slider has been re-rendered previously on this element, re-build\n\n      if (this.ready) {\n        this.buildSlick();\n      }\n\n      _previewCollection2.prototype.afterChildrenRender.call(this, element);\n\n      this.afterChildrenRenderDeferred.resolve(element);\n    }\n    /**\n     * On sort start force the container height, also focus to that slide\n     *\n     * @param {Event} event\n     * @param {JQueryUI.SortableUIParams} params\n     */\n    ;\n\n    _proto.onSortStart = function onSortStart(event, params) {\n      this.forceContainerHeight();\n\n      if (this.activeSlide() !== params.item.index() || this.focusedSlide() !== params.item.index()) {\n        this.navigateToSlide(params.item.index(), false, true); // As we've completed a navigation request we need to ensure we don't remove the forced height\n\n        this.contentTypeHeightReset = true;\n      }\n    }\n    /**\n     * On sort stop ensure the focused slide and the active slide are in sync, as the focus can be lost in this\n     * operation\n     */\n    ;\n\n    _proto.onSortStop = function onSortStop(event, params) {\n      var _this2 = this;\n\n      if (this.activeSlide() !== this.focusedSlide()) {\n        this.setFocusedSlide(this.activeSlide(), true);\n      }\n\n      if (params.item.index() !== -1) {\n        _underscore.defer(this.focusElement.bind(this, event, params.item.index()));\n      }\n\n      _underscore.defer(function () {\n        (0, _jquery)(_this2.element).css({\n          height: \"\",\n          overflow: \"\"\n        });\n      });\n    }\n    /**\n     * Add a slide into the slider\n     */\n    ;\n\n    _proto.addSlide = function addSlide() {\n      var _this3 = this;\n\n      (0, _contentTypeFactory)(_config.getConfig(\"content_types\").slide, this.contentType, this.contentType.stageId).then(function (slide) {\n        _events.on(\"slide:mountAfter\", function (args) {\n          if (args.id === slide.id) {\n            _underscore.defer(function () {\n              // Wait until slick is initialized before trying to navigate\n              (0, _delayUntil)(function () {\n                return _this3.navigateToSlide(_this3.contentType.children().length - 1);\n              }, function () {\n                return (0, _jquery)(_this3.element).hasClass(\"slick-initialized\");\n              }, 10);\n            });\n\n            _events.off(\"slide:\" + slide.id + \":mountAfter\");\n          }\n        }, \"slide:\" + slide.id + \":mountAfter\");\n\n        _this3.contentType.addChild(slide, _this3.contentType.children().length);\n      });\n    }\n    /**\n     * Slider can not receive drops by default\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isContainer = function isContainer() {\n      return false;\n    }\n    /**\n     * Slider navigation click handler.\n     *\n     * @param {number} index\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onControlClick = function onControlClick(index, context, event) {\n      (0, _jquery)(event.target).focus();\n      this.navigateToSlide(index);\n      this.setFocusedSlide(index);\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _previewCollection2.prototype.destroy.call(this);\n\n      if (this.focusedSlideSubscriber) {\n        this.focusedSlideSubscriber.dispose();\n      }\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this4 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"slider:mountAfter\", function (args) {\n        if (args.id === _this4.contentType.id) {\n          if (args.expectChildren !== undefined) {\n            _this4.mountAfterDeferred.resolve(args.expectChildren);\n          }\n        }\n      }); // Set the active slide to the new position of the sorted slide\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this4.contentType.id) {\n          (0, _jquery)(args.ui.item).remove(); // Remove the item as the container's children is controlled by knockout\n\n          _this4.setActiveSlide(args.newPosition);\n\n          _underscore.defer(_this4.focusElement.bind(_this4, args.event, args.newPosition));\n        }\n      }); // When a slide content type is removed\n      // we need to force update the content of the slider due to KO rendering issues\n\n\n      var newItemIndex;\n\n      _events.on(\"slide:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this4.contentType.id) {\n          // Mark the previous slide as active\n          newItemIndex = args.index - 1 >= 0 ? args.index - 1 : 0;\n\n          _this4.forceContainerHeight();\n\n          var data = _this4.contentType.children().slice(0);\n\n          _this4.contentType.children([]);\n\n          _this4.contentType.children(data);\n\n          _underscore.defer(function () {\n            _this4.buildSlick();\n          });\n        }\n      });\n\n      _events.on(\"slide:renderAfter\", function (args) {\n        var itemIndex = args.contentType.parentContentType.getChildren()().indexOf(args.contentType);\n\n        if (args.contentType.parentContentType.id === _this4.contentType.id && newItemIndex !== null && newItemIndex === itemIndex) {\n          _underscore.defer(function () {\n            if (newItemIndex !== null) {\n              newItemIndex = null;\n\n              _this4.navigateToSlide(itemIndex, true, true);\n\n              _underscore.defer(function () {\n                _this4.focusedSlide(null);\n\n                _this4.focusedSlide(itemIndex);\n              });\n            }\n          });\n        }\n      }); // On a slide content types creation we need to lock the height of the slider to ensure a smooth transition\n\n\n      _events.on(\"slide:createAfter\", function (args) {\n        if (_this4.element && _this4.ready && args.contentType.parentContentType.id === _this4.contentType.id) {\n          _this4.forceContainerHeight();\n\n          _underscore.defer(function () {\n            (0, _jquery)(_this4.element).css({\n              height: \"\",\n              overflow: \"\"\n            });\n          });\n        }\n      }); // ContentType being mounted onto container\n\n\n      _events.on(\"slider:dropAfter\", function (args) {\n        if (args.id === _this4.contentType.id && _this4.contentType.children().length === 0) {\n          _this4.addSlide();\n        }\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedSlide;\n      var duplicatedSlideIndex;\n\n      _events.on(\"slide:duplicateAfter\", function (args) {\n        if (args.duplicateContentType.parentContentType.id === _this4.contentType.id && args.direct) {\n          duplicatedSlide = args.duplicateContentType;\n          duplicatedSlideIndex = args.index;\n        }\n      });\n\n      _events.on(\"slide:mountAfter\", function (args) {\n        if (duplicatedSlide && args.id === duplicatedSlide.id) {\n          _underscore.defer(function () {\n            // Mark the new duplicate slide as active\n            _this4.navigateToSlide(duplicatedSlideIndex, true, true);\n\n            duplicatedSlide = duplicatedSlideIndex = null;\n          });\n        }\n      });\n    }\n    /**\n     * Determine if the data has changed, whilst ignoring certain keys which don't require a rebuild\n     *\n     * @param {DataObject} previousData\n     * @param {DataObject} newData\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.hasDataChanged = function hasDataChanged(previousData, newData) {\n      previousData = _underscore.omit(previousData, this.ignoredKeysForBuild);\n      newData = _underscore.omit(newData, this.ignoredKeysForBuild);\n      return !_underscore.isEqual(previousData, newData);\n    }\n    /**\n     * Build our instance of slick\n     */\n    ;\n\n    _proto.buildSlick = function buildSlick() {\n      var _this5 = this;\n\n      if (this.element && this.element.children.length > 0) {\n        try {\n          (0, _jquery)(this.element).slick(\"unslick\");\n        } catch (e) {// We aren't concerned if this fails, slick throws an Exception when we cannot unslick\n        } // Dispose current subscription in order to prevent infinite loop\n\n\n        if (this.childSubscribe) {\n          this.childSubscribe.dispose();\n        } // Force an update on all children, ko tries to intelligently re-render but fails\n\n\n        var data = this.contentType.children().slice(0);\n        this.contentType.children([]);\n        (0, _jquery)(this.element).empty();\n        this.contentType.children(data); // Re-subscribe original event\n\n        this.childSubscribe = this.contentType.children.subscribe(this.buildSlickDebounce); // Bind our init event for slick\n\n        (0, _jquery)(this.element).on(\"init\", function () {\n          _this5.ready = true;\n        }); // Build slick\n\n        (0, _jquery)(this.element).slick(Object.assign({\n          initialSlide: this.activeSlide() || 0\n        }, this.buildSlickConfig())); // Update our KO pointer to the active slide on change\n\n        (0, _jquery)(this.element).on(\"beforeChange\", function (event, slick, currentSlide, nextSlide) {\n          (0, _jquery)(_this5.element).css(\"pointer-events\", \"none\");\n\n          _this5.setActiveSlide(nextSlide);\n        }).on(\"afterChange\", function () {\n          if (!_this5.contentTypeHeightReset) {\n            (0, _jquery)(_this5.element).css({\n              height: \"\",\n              overflow: \"\"\n            });\n            _this5.contentTypeHeightReset = null;\n          }\n\n          (0, _jquery)(_this5.element).css(\"pointer-events\", \"\");\n        });\n      }\n    }\n    /**\n     * Take dropped element on focus.\n     *\n     * @param {JQueryEventObject} event\n     * @param {number} index\n     */\n    ;\n\n    _proto.focusElement = function focusElement(event, index) {\n      var handleClassName = (0, _jquery)(event.target).data(\"ui-sortable\").options.handle;\n      (0, _jquery)((0, _jquery)(event.target).find(handleClassName)[index]).focus();\n    }\n    /**\n     * To ensure smooth animations we need to lock the container height\n     */\n    ;\n\n    _proto.forceContainerHeight = function forceContainerHeight() {\n      (0, _jquery)(this.element).css({\n        height: (0, _jquery)(this.element).outerHeight(),\n        overflow: \"hidden\"\n      });\n    }\n    /**\n     * Build the slick config object\n     *\n     * @returns {{autoplay: boolean; autoplaySpeed: (any | number);\n     * fade: boolean; infinite: boolean; arrows: boolean; dots: boolean}}\n     */\n    ;\n\n    _proto.buildSlickConfig = function buildSlickConfig() {\n      var data = this.contentType.dataStore.getState();\n      return {\n        arrows: data.show_arrows === \"true\",\n        autoplay: data.autoplay === \"true\",\n        autoplaySpeed: data.autoplay_speed,\n        dots: false,\n        // We have our own dots implemented\n        fade: data.fade === \"true\",\n        infinite: data.is_infinite === \"true\",\n        waitForAnimate: false,\n        swipe: false\n      };\n    }\n    /**\n     * Fit slider in column container\n     *\n     * @param params\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(params) {\n      var _this6 = this;\n\n      setTimeout(function () {\n        if (_this6.element) {\n          (0, _jquery)(_this6.element).slick(\"setPosition\");\n\n          _this6.checkWidth();\n        }\n      }, 450);\n    }\n    /**\n     * Check width and add class that marks element as small\n     */\n    ;\n\n    _proto.checkWidth = function checkWidth() {\n      if (this.element.offsetWidth < 410) {\n        this.element.classList.add(\"slider-small-width\");\n      } else {\n        this.element.classList.remove(\"slider-small-width\");\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slider/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, events) {\n    'use strict';\n\n    return function (config, sliderElement) {\n        var $element = $(sliderElement);\n\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($element.hasClass('slick-initialized')) {\n            $element.slick('unslick');\n        }\n\n        $element.slick({\n            autoplay: $element.data('autoplay'),\n            autoplaySpeed: $element.data('autoplay-speed') || 0,\n            fade: $element.data('fade'),\n            infinite: $element.data('infinite-loop'),\n            arrows: $element.data('show-arrows'),\n            dots: $element.data('show-dots')\n        });\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($element.closest(args.element).length) {\n                $element.slick('setPosition');\n            }\n        });\n        // eslint-disable-next-line jquery-no-bind-unbind\n        events.on('stage:viewportChangeAfter', $element.slick.bind($element, 'setPosition'));\n    };\n});\n","Magento_PageBuilder/js/content-type/map/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/utils/map\", \"module\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_knockout, _events, _map, _module, _hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.apiKeyValid = _knockout.observable(!!_module.config().apiKey);\n      _this.apiKeyErrorMessage = _module.config().apiKeyErrorMessage;\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Open edit menu on map content type drop with a delay of 300ms\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _preview2.prototype.bindEvents.call(this); // When the map api key fails, empties out the content type and adds the placeholder\n\n\n      _events.on(\"googleMaps:authFailure\", function () {\n        _this2.apiKeyValid(false);\n      });\n    }\n    /**\n     * Renders the map and subscribe to position for updates\n     *\n     * @param {Element} element\n     * @returns {void}\n     */\n    ;\n\n    _proto.renderMap = function renderMap(element) {\n      var _this3 = this;\n\n      if (!this.apiKeyValid()) {\n        return;\n      }\n\n      this.generateMap(element);\n      this.element = element;\n\n      if (this.mapElement && this.mapElement.map) {\n        this.data.main.attributes.subscribe(function () {\n          _this3.updateMap();\n        });\n      }\n    }\n    /**\n     * Generate maps\n     *\n     * @param {Element} element\n     * @returns {void}\n     */\n    ;\n\n    _proto.generateMap = function generateMap(element) {\n      var currentLocations = this.data.main.attributes()[\"data-locations\"] || \"[]\";\n      var controls = this.data.main.attributes()[\"data-show-controls\"] || \"true\";\n      var locations = [];\n      var options = {\n        disableDefaultUI: controls !== \"true\",\n        mapTypeControl: controls === \"true\"\n      };\n\n      if (currentLocations !== \"[]\") {\n        var mapData = this.getMapData();\n        locations = mapData.locations;\n        options = mapData.options;\n      }\n\n      this.mapElement = new _map(element, locations, options);\n    }\n    /**\n     * Updates map\n     *\n     * @returns {void}\n     */\n    ;\n\n    _proto.updateMap = function updateMap() {\n      var mapData = this.getMapData();\n      this.mapElement.onUpdate(mapData.locations, mapData.options);\n    }\n    /**\n     * Get locations, center coordinates, and zoom from data.position\n     *\n     * @returns {Object}\n     */\n    ;\n\n    _proto.getMapData = function getMapData() {\n      var attributes = this.data.main.attributes();\n      var controls = attributes[\"data-show-controls\"];\n      var options = {\n        disableDefaultUI: controls !== \"true\",\n        mapTypeControl: controls === \"true\"\n      };\n      var locations = attributes[\"data-locations\"];\n\n      if (locations !== \"\" && typeof locations === \"string\") {\n        locations = JSON.parse(locations);\n      }\n\n      locations.forEach(function (location) {\n        location.position.latitude = parseFloat(location.position.latitude);\n        location.position.longitude = parseFloat(location.position.longitude);\n      });\n      return {\n        locations: locations,\n        options: options\n      };\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/map/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/utils/map'\n], function ($, GoogleMap) {\n    'use strict';\n\n    return function (config, element) {\n        var locations,\n            controls,\n            mapOptions = {};\n\n        element = element[0];\n\n        if (element !== undefined && element.hasAttribute('data-locations')) {\n\n            /**\n             * Set map display to none if no locations\n             */\n            if (element.getAttribute('data-locations') === '[]') {\n                $(element).hide();\n\n                return;\n            }\n            locations = JSON.parse(element.getAttribute('data-locations'));\n            locations.forEach(function (location) {\n                location.position.latitude = parseFloat(location.position.latitude);\n                location.position.longitude = parseFloat(location.position.longitude);\n            });\n            controls = element.getAttribute('data-show-controls');\n            mapOptions.disableDefaultUI = controls !== 'true';\n            mapOptions.mapTypeControl = controls === 'true';\n            new GoogleMap(element, locations, mapOptions);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/map/converter/attribute/locations.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Locations = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Locations() {}\n\n    var _proto = Locations.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value && value !== \"\") {\n        return JSON.parse(value);\n      }\n\n      return [];\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var content = (0, _object.get)(data, name);\n\n      if (_underscore.isString(content) && content !== \"\") {\n        content = JSON.parse(content);\n      }\n\n      if (content && Object.keys(content).length) {\n        content.forEach(function (marker) {\n          if (marker.position) {\n            marker.position.latitude = parseFloat(marker.position.latitude);\n            marker.position.longitude = parseFloat(marker.position.longitude);\n          }\n        });\n        return JSON.stringify(content);\n      }\n\n      return JSON.stringify([]);\n    };\n\n    return Locations;\n  }();\n\n  return Locations;\n});\n//# sourceMappingURL=locations.js.map","Magento_PageBuilder/js/content-type/block/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/widget-initializer\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _widgetInitializer, _mageUtils, _underscore, _config, _hideShowOption, _styleRegistry, _object, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * @inheritdoc\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.displayingBlockPreview = _knockout.observable(false);\n      _this.loading = _knockout.observable(false);\n      _this.messages = {\n        NOT_SELECTED: (0, _translate)(\"Empty Block\"),\n        UNKNOWN_ERROR: (0, _translate)(\"An unknown error occurred. Please try again.\")\n      };\n      _this.placeholderText = _knockout.observable(_this.messages.NOT_SELECTED);\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Runs the widget initializer for each configured widget\n     */\n    ;\n\n    _proto.initializeWidgets = function initializeWidgets(element) {\n      if (element) {\n        this.element = element;\n        (0, _widgetInitializer)({\n          config: _config.getConfig(\"widgets\"),\n          breakpoints: _config.getConfig(\"breakpoints\"),\n          currentViewport: _config.getConfig(\"viewport\")\n        }, element);\n      }\n    }\n    /**\n     * Updates the view state using the data provided\n     * @param {DataObject} data\n     */\n    ;\n\n    _proto.processBlockData = function processBlockData(data) {\n      // Only load if something changed\n      this.displayPreviewPlaceholder(data, \"block_id\");\n\n      if (data.block_id && data.template.length !== 0) {\n        this.processRequest(data, \"block_id\", \"title\");\n      }\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      _preview2.prototype.afterObservablesUpdated.call(this);\n\n      var data = this.contentType.dataStore.getState(); // Only load if something changed\n\n      this.processBlockData(data);\n    }\n    /**\n     * Display preview placeholder\n     *\n     * @param {DataObject} data\n     * @param {string} identifierName\n     */\n    ;\n\n    _proto.displayPreviewPlaceholder = function displayPreviewPlaceholder(data, identifierName) {\n      var blockId = (0, _object.get)(data, identifierName); // Only load if something changed\n\n      if (this.lastBlockId === blockId && this.lastTemplate === data.template) {\n        // The mass converter will have transformed the HTML property into a directive\n        if (this.lastRenderedHtml) {\n          this.data.main.html(this.lastRenderedHtml);\n          this.showBlockPreview(true);\n          this.initializeWidgets(this.element);\n        }\n      } else {\n        this.showBlockPreview(false);\n        this.placeholderText(\"\");\n      }\n\n      if (!blockId || blockId && blockId.toString().length === 0 || data.template.length === 0) {\n        this.showBlockPreview(false);\n        this.placeholderText(this.messages.NOT_SELECTED);\n        return;\n      }\n    }\n    /**\n     *\n     * @param {DataObject} data\n     * @param {string} identifierName\n     * @param {string} labelKey\n     */\n    ;\n\n    _proto.processRequest = function processRequest(data, identifierName, labelKey) {\n      var _this2 = this;\n\n      var url = _config.getConfig(\"preview_url\");\n\n      var identifier = (0, _object.get)(data, identifierName);\n      var requestConfig = {\n        // Prevent caching\n        method: \"POST\",\n        data: {\n          role: this.config.name,\n          block_id: identifier,\n          directive: this.data.main.html()\n        }\n      };\n      this.loading(true); // Retrieve a state object representing the block from the preview controller and process it on the stage\n\n      _jquery.ajax(url, requestConfig) // The state object will contain the block name and either html or a message why there isn't any.\n      .done(function (response) {\n        // Empty content means something bad happened in the controller that didn't trigger a 5xx\n        if (typeof response.data !== \"object\") {\n          _this2.showBlockPreview(false);\n\n          _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n\n          return;\n        } // Update the stage content type label with the real block title if provided\n\n\n        _this2.displayLabel(response.data[labelKey] ? response.data[labelKey] : _this2.config.label);\n\n        var content = \"\";\n\n        if (response.data.content) {\n          content = _this2.processContent(response.data.content);\n\n          _this2.data.main.html(content);\n\n          _this2.showBlockPreview(true);\n\n          _this2.initializeWidgets(_this2.element);\n        } else if (response.data.error) {\n          _this2.showBlockPreview(false);\n\n          _this2.placeholderText(response.data.error);\n        }\n\n        _this2.lastBlockId = parseInt(identifier.toString(), 10);\n        _this2.lastTemplate = data.template.toString();\n        _this2.lastRenderedHtml = content;\n      }).fail(function () {\n        _this2.showBlockPreview(false);\n\n        _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n      }).always(function () {\n        _this2.loading(false);\n      });\n    }\n    /**\n     * Toggle display of block preview.  If showing block preview, add hidden mode to PB preview.\n     * @param {boolean} isShow\n     */\n    ;\n\n    _proto.showBlockPreview = function showBlockPreview(isShow) {\n      this.displayingBlockPreview(isShow);\n    }\n    /**\n     * Adapt content to view it on stage.\n     *\n     * @param content\n     */\n    ;\n\n    _proto.processContent = function processContent(content) {\n      var processedContent = this.processBackgroundImages(content);\n      processedContent = this.processBreakpointStyles(processedContent);\n      return processedContent;\n    }\n    /**\n     * Generate styles for background images.\n     *\n     * @param {string} content\n     * @return string\n     */\n    ;\n\n    _proto.processBackgroundImages = function processBackgroundImages(content) {\n      var document = new DOMParser().parseFromString(content, \"text/html\");\n      var elements = document.querySelectorAll(\"[data-background-images]\");\n      var styleBlock = document.createElement(\"style\");\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      elements.forEach(function (element) {\n        var rawAttrValue = element.getAttribute(\"data-background-images\").replace(/\\\\(.)/mg, \"$1\");\n        var attrValue = JSON.parse(rawAttrValue);\n\n        var elementClass = \"background-image-\" + _mageUtils.uniqueid(13);\n\n        var rules = \"\";\n        Object.keys(attrValue).forEach(function (imageName) {\n          var imageUrl = attrValue[imageName];\n          var viewportName = imageName.replace(\"_image\", \"\");\n\n          if (viewports[viewportName].stage && imageUrl) {\n            rules += \".\" + viewportName + \"-viewport .\" + elementClass + \" {\\n                            background-image: url(\\\"\" + imageUrl + \"\\\");\\n                        }\";\n          }\n        });\n\n        if (rules.length) {\n          styleBlock.append(rules);\n          element.classList.add(elementClass);\n        }\n      });\n\n      if (elements.length && styleBlock.innerText.length) {\n        document.body.append(styleBlock);\n        content = document.head.innerHTML + document.body.innerHTML;\n      }\n\n      return content;\n    }\n    /**\n     * Replace media queries with viewport classes.\n     *\n     * @param {string} content\n     * @return string\n     */\n    ;\n\n    _proto.processBreakpointStyles = function processBreakpointStyles(content) {\n      var document = new DOMParser().parseFromString(content, \"text/html\");\n      var styleBlocks = document.querySelectorAll(\"style\");\n      var mediaStyleBlock = document.createElement(\"style\");\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      styleBlocks.forEach(function (styleBlock) {\n        var cssRules = styleBlock.sheet.cssRules;\n        Array.from(cssRules).forEach(function (rule) {\n          var mediaScope = rule instanceof CSSMediaRule && _underscore.findKey(viewports, function (viewport) {\n            return rule.conditionText === viewport.media;\n          });\n\n          if (mediaScope) {\n            Array.from(rule.cssRules).forEach(function (mediaRule, index) {\n              if (mediaRule.selectorText.indexOf(_styleRegistry.pbStyleAttribute) !== -1) {\n                var searchPattern = new RegExp(_config.getConfig(\"bodyId\") + \" \", \"g\");\n                var replaceValue = _config.getConfig(\"bodyId\") + \" .\" + mediaScope + \"-viewport \";\n                var selector = mediaRule.selectorText.replace(searchPattern, replaceValue);\n                mediaStyleBlock.append(selector + \" {\" + mediaRule.style.cssText + \"}\");\n              }\n            });\n          }\n        });\n      });\n\n      if (mediaStyleBlock.innerText.length) {\n        document.body.append(mediaStyleBlock);\n        content = document.head.innerHTML + document.body.innerHTML;\n      }\n\n      return content;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/block/mass-converter/widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Enables the settings of the content type to be stored as a widget directive.\n   *\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.template = attributes.template;\n      data.block_id = attributes.block_id;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\Cms\\\\Block\\\\Widget\\\\Block\",\n        template: data.template,\n        block_id: data.block_id,\n        type_name: \"CMS Static Block\"\n      };\n\n      if (!attributes.block_id || !attributes.template) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=widget-directive.js.map","Magento_PageBuilder/js/content-type/column-group/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/utils/create-stylesheet\", \"Magento_PageBuilder/js/content-type/column/resize\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column-group/drag-and-drop\", \"Magento_PageBuilder/js/content-type/column-group/factory\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column-group/registry\"], function (_jquery, _knockout, _translate, _hideShowOption, _events, _underscore, _config, _contentTypeFactory, _moveContentType, _registry, _sortable, _createStylesheet, _resize, _previewCollection, _dragAndDrop, _factory, _gridSize, _registry2) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     *\n     * @param {ContentTypeCollection} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.resizing = _knockout.observable(false);\n      _this.hasEmptyChild = _knockout.computed(function () {\n        var empty = false;\n\n        _this.contentType.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            empty = true;\n          }\n        });\n\n        return empty;\n      });\n      _this.gridSize = _knockout.observable();\n      _this.gridSizeInput = _knockout.observable();\n      _this.gridSizeArray = _knockout.observableArray([]);\n      _this.gridSizeError = _knockout.observable();\n      _this.gridSizeMax = _knockout.observable((0, _gridSize.getMaxGridSize)());\n      _this.gridFormOpen = _knockout.observable(false);\n      _this.gridChange = _knockout.observable(false);\n      _this.gridToolTipOverFlow = _knockout.observable(false);\n      _this.resizeColumnWidths = [];\n      _this.resizeHistory = {\n        left: [],\n        right: []\n      };\n      _this.dropPositions = [];\n      _this.gridSizeHistory = new Map();\n      _this.interactionLevel = 0;\n      _this.resizeUtils = new _resize(_this.contentType); // Keep track of the grid size in an observable\n\n      _this.contentType.dataStore.subscribe(function (state) {\n        var gridSize = parseInt(state.grid_size.toString(), 10);\n\n        _this.gridSize(gridSize);\n\n        _this.gridSizeInput(gridSize);\n\n        if (gridSize) {\n          _this.gridSizeArray(new Array(gridSize));\n        }\n      }, \"grid_size\");\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.spreadWidth(args.index);\n          });\n        }\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnGroup.id === _this.contentType.id) {\n          _this.bindDraggable(args.column);\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.moveContentsToNewColumnGroup.bind(_assertThisInitialized(_this)));\n\n      _events.on(\"column-group:renderAfter\", function (args) {\n        if (args.contentType.id === _this.contentType.id) {\n          if (!_this.hasColumnLine(args.contentType)) {\n            args.element.classList.add(\"no-column-line\");\n          } else {\n            args.element.classList.remove(\"no-column-line\");\n            args.element.classList.add(\"with-column-line\");\n          }\n        }\n      });\n\n      _this.contentType.children.subscribe(_underscore.debounce(_this.removeIfEmpty.bind(_assertThisInitialized(_this)), 50));\n\n      return _this;\n    }\n    /**\n     * Handle user editing an instance\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.onOptionEdit = function onOptionEdit() {\n      var numCols = this.contentType.getChildren()().length; // count the number of non empty columns\n\n      var numEmptyColumns = 0;\n      this.contentType.getChildren()().forEach(function (column) {\n        if (column.getChildren()().length === 0) {\n          numEmptyColumns++;\n        }\n      });\n      var appearance = this.contentType.dataStore.get(\"appearance\") ? this.contentType.dataStore.get(\"appearance\") : \"default\";\n      this.contentType.dataStore.set(\"appearance\", appearance);\n      this.contentType.dataStore.set(\"non_empty_column_count\", this.getNonEmptyColumnCount());\n      this.contentType.dataStore.set(\"max_grid_size\", (0, _gridSize.getMaxGridSize)());\n      this.contentType.dataStore.set(\"initial_grid_size\", this.contentType.dataStore.get(\"grid_size\"));\n\n      _previewCollection2.prototype.openEdit.call(this);\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      if (_config.getContentTypeConfig(\"column\")) {\n        _events.on(\"column-group:dropAfter\", function (args) {\n          if (args.id === _this2.contentType.id) {\n            _this2.setDefaultGridSizeOnColumnGroup();\n\n            _this2.addDefaultColumnLine(args);\n          }\n        });\n      }\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        if (_this2.contentType.dataStore.get(\"grid_size\") !== _this2.contentType.dataStore.get(\"initial_grid_size\")) {\n          _this2.updateGridSize();\n        }\n      });\n    }\n    /**\n     * Set default grid size on current column group\n     */\n    ;\n\n    _proto.setDefaultGridSizeOnColumnGroup = function setDefaultGridSizeOnColumnGroup() {\n      this.contentType.dataStore.set(\"grid_size\", (0, _gridSize.getDefaultGridSize)());\n    }\n    /**\n     * Add Columns to the current Column Group\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumns = function createColumns() {\n      var _this3 = this;\n\n      var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n      var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n      Promise.all([(0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: col1Width + \"%\"\n      }), (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: 100 - parseFloat(col1Width) + \"%\"\n      })]).then(function (columns) {\n        _this3.contentType.addChild(columns[0], 0);\n\n        _this3.contentType.addChild(columns[1], 1);\n\n        _this3.fireMountEvent(_this3.contentType, columns[0], columns[1]);\n      });\n    };\n\n    _proto.addDefaultColumnLine = function addDefaultColumnLine(args) {\n      var _this4 = this;\n\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-line\"), this.contentType, this.contentType.stageId).then(function (columnLine) {\n        _this4.contentType.addChild(columnLine, 0);\n\n        if (args.columnGroupWithoutColumnLine === undefined) {\n          _events.trigger(columnLine.config.name + \":dropAfter\", {\n            id: columnLine.id,\n            columnLine: columnLine\n          });\n        } else {\n          // Move children of this column group without column line as descendant of new\n          // column group that has a column line\n          var children = args.columnGroupWithoutColumnLine.getChildren()();\n          var index = 0;\n          children.forEach(function (child) {\n            setTimeout(function () {\n              (0, _moveContentType.moveContentType)(child, index++, columnLine);\n            }, 250);\n          });\n        }\n\n        _this4.fireMountEvent(_this4.contentType, columnLine);\n      });\n    }\n    /**\n     * Use the conditional remove to disable the option when the content type has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Retrieve the resize utils\n     *\n     * @returns {Resize}\n     */\n    ;\n\n    _proto.getResizeUtils = function getResizeUtils() {\n      return this.resizeUtils;\n    }\n    /**\n     * Handle a new column being dropped into the group\n     *\n     * @param {DropPosition} dropPosition\n     */\n    ;\n\n    _proto.onNewColumnDrop = function onNewColumnDrop(dropPosition) {\n      var _this5 = this;\n\n      // Create our new column\n      (0, _factory.createColumn)(this.contentType, this.resizeUtils.getSmallestColumnWidth(), dropPosition.insertIndex).then(function () {\n        var newWidth = _this5.resizeUtils.getAcceptedColumnWidth((_this5.resizeUtils.getColumnWidth(dropPosition.affectedColumn) - _this5.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n\n        (0, _resize.updateColumnWidth)(dropPosition.affectedColumn, newWidth);\n      });\n    }\n    /**\n     * Handle an existing column being dropped into a new column group\n     *\n     * @param {DropPosition} movePosition\n     */\n    ;\n\n    _proto.onExistingColumnDrop = function onExistingColumnDrop(movePosition) {\n      var column = (0, _registry2.getDragColumn)();\n      var sourceGroupPreview = column.parentContentType.preview;\n      var modifyOldNeighbour; // Determine which old neighbour we should modify\n\n      var oldWidth = sourceGroupPreview.getResizeUtils().getColumnWidth(column); // Retrieve the adjacent column either +1 or -1\n\n      if ((0, _resize.getAdjacentColumn)(column, \"+1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"+1\");\n      } else if ((0, _resize.getAdjacentColumn)(column, \"-1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"-1\");\n      } // Set the column to it's smallest column width\n\n\n      (0, _resize.updateColumnWidth)(column, this.resizeUtils.getSmallestColumnWidth()); // Move the content type\n\n      (0, _moveContentType.moveContentType)(column, movePosition.insertIndex, this.contentType); // Modify the old neighbour\n\n      if (modifyOldNeighbour) {\n        var oldNeighbourWidth = sourceGroupPreview.getResizeUtils().getAcceptedColumnWidth((oldWidth + sourceGroupPreview.getResizeUtils().getColumnWidth(modifyOldNeighbour)).toString());\n        (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n      } // Modify the columns new neighbour\n\n\n      var newNeighbourWidth = this.resizeUtils.getAcceptedColumnWidth((this.resizeUtils.getColumnWidth(movePosition.affectedColumn) - this.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n      (0, _resize.updateColumnWidth)(movePosition.affectedColumn, newNeighbourWidth);\n    }\n    /**\n     * Handle a column being sorted into a new position in the group\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} newIndex\n     */\n    ;\n\n    _proto.onColumnSort = function onColumnSort(column, newIndex) {\n      var currentIndex = (0, _resize.getColumnIndexInGroup)(column);\n\n      if (currentIndex !== newIndex) {\n        if (currentIndex < newIndex) {\n          // As we're moving an array item the keys all reduce by 1\n          --newIndex;\n        } // Move the content type\n\n\n        (0, _moveContentType.moveContentType)(column, newIndex);\n      }\n    }\n    /**\n     * Handle a column being resized\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(column, width, adjustedColumn) {\n      this.resizeUtils.resizeColumn(column, width, adjustedColumn);\n    }\n    /**\n     * Init the droppable & resizing interactions\n     *\n     * @param group\n     */\n    ;\n\n    _proto.bindInteractions = function bindInteractions(group) {\n      this.groupElement = (0, _jquery)(group);\n      this.initDroppable(this.groupElement);\n      this.initMouseMove(this.groupElement); // Handle the mouse leaving the window\n\n      (0, _jquery)(\"body\").mouseleave(this.endAllInteractions.bind(this));\n    }\n    /**\n     * Init the drop placeholder\n     * @deprecated - dropPlaceholder functionality moved to column-line\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindDropPlaceholder = function bindDropPlaceholder(element) {\n      this.dropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the move placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindMovePlaceholder = function bindMovePlaceholder(element) {\n      this.movePlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Retrieve the ghost element from the template\n     *\n     * @param {Element} ghost\n     */\n    ;\n\n    _proto.bindGhost = function bindGhost(ghost) {\n      this.resizeGhost = (0, _jquery)(ghost);\n    }\n    /**\n     * Register a resize handle within a child column\n     * @deprecated\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {JQuery} handle\n     */\n    ;\n\n    _proto.registerResizeHandle = function registerResizeHandle(column, handle) {\n      var _this6 = this;\n\n      handle.off(\"mousedown touchstart\");\n      handle.on(\"mousedown touchstart\", function (event) {\n        event.preventDefault();\n\n        var groupPosition = _this6.getGroupPosition(_this6.groupElement);\n\n        _this6.resizing(true);\n\n        _this6.resizeColumnInstance = column;\n        _this6.resizeColumnWidths = _this6.resizeUtils.determineColumnWidths(_this6.resizeColumnInstance, groupPosition);\n        _this6.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this6.resizeColumnWidths); // Force the cursor to resizing\n\n        (0, _jquery)(\"body\").css(\"cursor\", \"col-resize\"); // Reset the resize history\n\n        _this6.resizeHistory = {\n          left: [],\n          right: []\n        };\n        _this6.resizeLastPosition = null;\n        _this6.resizeMouseDown = true;\n        ++_this6.interactionLevel;\n\n        _events.trigger(\"stage:interactionStart\", {\n          stageId: _this6.contentType.stageId\n        });\n      });\n    }\n    /**\n     * Bind draggable instances to the child columns\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     */\n    ;\n\n    _proto.bindDraggable = function bindDraggable(column) {\n      var _this7 = this;\n\n      column.preview.element.draggable({\n        appendTo: \"body\",\n        containment: \"body\",\n        cursor: \"-webkit-grabbing\",\n        handle: \".move-column\",\n        revertDuration: 250,\n        helper: function helper() {\n          var helper = (0, _jquery)(this).clone();\n          helper.css({\n            height: (0, _jquery)(this).outerHeight() + \"px\",\n            minHeight: 0,\n            opacity: 0.5,\n            pointerEvents: \"none\",\n            width: (0, _jquery)(this).outerWidth() + \"px\",\n            zIndex: 5000\n          });\n          return helper;\n        },\n        start: function start(event) {\n          var columnInstance = _knockout.dataFor((0, _jquery)(event.target)[0]); // Use the global state as columns can be dragged between groups\n\n\n          (0, _registry2.setDragColumn)(columnInstance.contentType);\n          _this7.dropPositions = (0, _dragAndDrop.calculateDropPositions)(_this7.contentType);\n          _this7.startDragEvent = event;\n\n          _events.trigger(\"column:dragStart\", {\n            column: columnInstance,\n            stageId: _this7.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStart\", {\n            stageId: _this7.contentType.stageId\n          });\n        },\n        stop: function stop() {\n          var draggedColumn = (0, _registry2.getDragColumn)();\n\n          if (_this7.movePosition && draggedColumn) {\n            // Check if we're moving within the same group, even though this function will\n            // only ever run on the group that bound the draggable event\n            if (draggedColumn.parentContentType === _this7.contentType) {\n              _this7.onColumnSort(draggedColumn, _this7.movePosition.insertIndex);\n\n              _this7.movePosition = null;\n            }\n          }\n\n          (0, _registry2.removeDragColumn)();\n\n          _this7.movePlaceholder.removeClass(\"active\");\n\n          _this7.startDragEvent = null;\n\n          _events.trigger(\"column:dragStop\", {\n            column: draggedColumn,\n            stageId: _this7.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: _this7.contentType.stageId\n          });\n        }\n      });\n    }\n    /**\n     * Update the grid size on enter or blur of the input\n     */\n    ;\n\n    _proto.updateGridSize = function updateGridSize() {\n      var _this8 = this;\n\n      if (!_jquery.isNumeric(this.gridSizeInput())) {\n        this.gridSizeError((0, _translate)(\"Please enter a valid number.\"));\n      }\n\n      var newGridSize = parseInt(this.gridSizeInput().toString(), 10);\n\n      if (newGridSize || newGridSize === 0) {\n        if (newGridSize !== this.resizeUtils.getGridSize() || true) {\n          try {\n            (0, _gridSize.resizeGrid)(this.contentType, newGridSize, this.gridSizeHistory);\n            this.recordGridResize(newGridSize);\n            this.gridSizeError(null); // Make the grid \"flash\" on successful change\n\n            this.gridChange(true);\n\n            _underscore.delay(function () {\n              _this8.gridChange(false);\n            }, 1000);\n          } catch (e) {\n            if (e instanceof _gridSize.GridSizeError) {\n              this.gridSizeError(e.message);\n            } else {\n              throw e;\n            }\n          }\n        } else {\n          this.gridSizeError(null);\n        }\n      }\n    }\n    /**\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n     * @private\n     */\n    ;\n\n    _proto.hasColumnLine = function hasColumnLine(contentType) {\n      var children = this.contentType.getChildren()();\n      var hasColumnLine = false;\n\n      if (children.length === 0) {\n        // new column group, so it has a column line\n        hasColumnLine = true;\n      }\n\n      children.forEach(function (child) {\n        if (child.config.name === \"column-line\") {\n          hasColumnLine = true;\n        }\n      });\n      return hasColumnLine;\n    }\n    /**\n     * If the column group does not have a column line, move contents to a new column group with a column line\n     */\n    ;\n\n    _proto.moveContentsToNewColumnGroup = function moveContentsToNewColumnGroup() {\n      var _this9 = this;\n\n      if (this.hasColumnLine(this.contentType)) {\n        // This column-group already has a column line. Don't need to add one.\n        return;\n      }\n\n      var indexToInsertNewColumnGroupAt = this.getCurrentIndexInParent();\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-group\"), this.contentType.parentContentType, this.contentType.stageId).then(function (columnGroup) {\n        _this9.contentType.parentContentType.addChild(columnGroup, indexToInsertNewColumnGroupAt);\n\n        _events.trigger(columnGroup.config.name + \":dropAfter\", {\n          id: columnGroup.id,\n          columnGroup: columnGroup,\n          columnGroupWithoutColumnLine: _this9.contentType\n        });\n\n        _this9.fireMountEvent(_this9.contentType, columnGroup);\n      });\n    }\n    /**\n     * @private return index of current content type in parent\n     */\n    ;\n\n    _proto.getCurrentIndexInParent = function getCurrentIndexInParent() {\n      var parentContentType = this.contentType.parentContentType;\n      var currentIndex = 0;\n\n      for (var _iterator = _createForOfIteratorHelperLoose(this.contentType.parentContentType.getChildren()()), _step; !(_step = _iterator()).done;) {\n        var sibling = _step.value;\n\n        if (sibling.id !== this.contentType.id) {\n          currentIndex++;\n          continue;\n        }\n\n        break;\n      }\n\n      return currentIndex;\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len = arguments.length, contentTypes = new Array(_len), _key = 0; _key < _len; _key++) {\n        contentTypes[_key] = arguments[_key];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Set columns in the group as resizing\n     *\n     * @param {Array<ContentTypeCollectionInterface<ColumnPreview>>} columns\n     */\n    ;\n\n    _proto.setColumnsAsResizing = function setColumnsAsResizing() {\n      for (var _len2 = arguments.length, columns = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n        columns[_key2] = arguments[_key2];\n      }\n\n      columns.forEach(function (column) {\n        column.preview.resizing(true);\n        column.preview.element.css({\n          transition: \"width 350ms ease-in-out\"\n        });\n      });\n    }\n    /**\n     * Unset resizing flag on all child columns\n     */\n    ;\n\n    _proto.unsetResizingColumns = function unsetResizingColumns() {\n      this.contentType.children().forEach(function (column) {\n        column.preview.resizing(false);\n\n        if (column.preview.element) {\n          column.preview.element.css({\n            transition: \"\"\n          });\n        }\n      });\n    }\n    /**\n     * End all current interactions\n     */\n    ;\n\n    _proto.endAllInteractions = function endAllInteractions() {\n      if (this.resizing() === true) {\n        for (; this.interactionLevel > 0; this.interactionLevel--) {\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: this.contentType.stageId\n          });\n        }\n      }\n\n      this.resizing(false);\n      this.resizeMouseDown = null;\n      this.resizeLeftLastColumnShrunk = this.resizeRightLastColumnShrunk = null;\n      this.dropPositions = []; // this.unsetResizingColumns();\n      // Change the cursor back\n\n      (0, _jquery)(\"body\").css(\"cursor\", \"\");\n      this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n      this.resizeGhost.removeClass(\"active\"); // Reset the group positions cache\n\n      this.groupPositionCache = null;\n    }\n    /**\n     * Init the resizing events on the group\n     *\n     * @param {JQuery} group\n     */\n    ;\n\n    _proto.initMouseMove = function initMouseMove(group) {\n      var _this10 = this;\n\n      var intersects = false;\n      (0, _jquery)(document).on(\"mousemove touchmove\", function (event) {\n        if (group.parents(_sortable.hiddenClass).length > 0) {\n          return;\n        }\n\n        var groupPosition = _this10.getGroupPosition(group); // If we're handling a touch event we need to pass through the page X & Y\n\n\n        if (event.type === \"touchmove\") {\n          event.pageX = event.originalEvent.pageX;\n          event.pageY = event.originalEvent.pageY;\n        }\n\n        if (_this10.eventIntersectsGroup(event, groupPosition)) {\n          intersects = true; // @todo make column re-sizing work\n\n          _this10.onResizingMouseMove(event, group, groupPosition);\n        } else {\n          intersects = false;\n          _this10.groupPositionCache = null;\n          _this10.dropPosition = null;\n\n          _this10.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n        }\n      }).on(\"mouseup touchend\", function () {\n        intersects = false;\n        _this10.dropPosition = null;\n\n        _this10.endAllInteractions();\n\n        _underscore.defer(function () {\n          // Re-enable any disabled sortable areas\n          group.find(\".ui-sortable\").each(function () {\n            if ((0, _jquery)(this).data(\"ui-sortable\")) {\n              (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n            }\n          });\n        });\n      });\n    }\n    /**\n     * Handle the mouse up action, either adding a new column or moving an existing\n     * @deprecated\n     */\n    ;\n\n    _proto.handleMouseUp = function handleMouseUp() {\n      if (this.dropOverElement && this.dropPosition) {\n        this.onNewColumnDrop(this.dropPosition);\n        this.dropOverElement = null; // Re-enable the parent disabled sortable instance\n\n        _underscore.defer(function () {\n          (0, _jquery)(\".element-children.ui-sortable-disabled\").each(function () {\n            (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n          });\n        });\n      }\n\n      var column = (0, _registry2.getDragColumn)();\n\n      if (this.movePosition && column && column.parentContentType !== this.contentType) {\n        this.onExistingColumnDrop(this.movePosition);\n      }\n    }\n    /**\n     * Does the current event intersect with the group?\n     *\n     * @param {JQueryEventObject} event\n     * @param {GroupPositionCache} groupPosition\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.eventIntersectsGroup = function eventIntersectsGroup(event, groupPosition) {\n      return event.pageY > groupPosition.top && event.pageY < groupPosition.top + groupPosition.outerHeight && event.pageX > groupPosition.left && event.pageX < groupPosition.left + groupPosition.outerWidth;\n    }\n    /**\n     * Cache the groups positions\n     *\n     * @param {JQuery} group\n     * @returns {GroupPositionCache}\n     */\n    ;\n\n    _proto.getGroupPosition = function getGroupPosition(group) {\n      if (!this.groupPositionCache) {\n        this.groupPositionCache = {\n          top: group.offset().top,\n          left: group.offset().left,\n          width: group.width(),\n          height: group.height(),\n          outerWidth: group.outerWidth(),\n          outerHeight: group.outerHeight()\n        };\n      }\n\n      return this.groupPositionCache;\n    }\n    /**\n     * Record the resizing history for this action\n     *\n     * @param {string} usedHistory\n     * @param {string} direction\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     * @param {string} modifyColumnInPair\n     */\n    ;\n\n    _proto.recordResizeHistory = function recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair) {\n      if (usedHistory) {\n        this.resizeHistory[usedHistory].pop();\n      }\n\n      this.resizeHistory[direction].push({\n        adjustedColumn: adjustedColumn,\n        modifyColumnInPair: modifyColumnInPair\n      });\n    }\n    /**\n     * Handle the resizing on mouse move, we always resize a pair of columns at once\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onResizingMouseMove = function onResizingMouseMove(event, group, groupPosition) {\n      var _this11 = this;\n\n      var newColumnWidth;\n\n      if (this.resizeMouseDown) {\n        event.preventDefault();\n        var currentPos = event.pageX;\n        var resizeColumnLeft = this.resizeColumnInstance.preview.element.offset().left;\n        var resizeColumnWidth = this.resizeColumnInstance.preview.element.outerWidth();\n        var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n        var direction = currentPos >= resizeHandlePosition ? \"right\" : \"left\";\n        var adjustedColumn;\n        var modifyColumnInPair; // We need to know if we're modifying the left or right column in the pair\n\n        var usedHistory; // Was the adjusted column pulled from history?\n        // Determine which column in the group should be adjusted for this action\n\n        var _this$resizeUtils$det = this.resizeUtils.determineAdjustedColumn(currentPos, this.resizeColumnInstance, this.resizeHistory);\n\n        adjustedColumn = _this$resizeUtils$det[0];\n        modifyColumnInPair = _this$resizeUtils$det[1];\n        usedHistory = _this$resizeUtils$det[2];\n        // Calculate the ghost width based on mouse position and bounds of allowed sizes\n        var ghostWidth = this.resizeUtils.calculateGhostWidth(groupPosition, currentPos, this.resizeColumnInstance, modifyColumnInPair, this.resizeMaxGhostWidth);\n        this.resizeGhost.width(ghostWidth - 15 + \"px\").addClass(\"active\");\n\n        if (adjustedColumn && this.resizeColumnWidths) {\n          newColumnWidth = this.resizeColumnWidths.find(function (val) {\n            return (0, _resize.comparator)(currentPos, val.position, 35) && val.forColumn === modifyColumnInPair;\n          });\n\n          if (newColumnWidth) {\n            var mainColumn = this.resizeColumnInstance; // If we're using the left data set, we're actually resizing the right column of the group\n\n            if (modifyColumnInPair === \"right\") {\n              mainColumn = (0, _resize.getAdjacentColumn)(this.resizeColumnInstance, \"+1\");\n            } // Ensure we aren't resizing multiple times, also validate the last resize isn't the same as the\n            // one being performed now. This occurs as we re-calculate the column positions on resize, we have\n            // to use the comparator as the calculation may result in slightly different numbers due to rounding\n\n\n            if (this.resizeUtils.getColumnWidth(mainColumn) !== newColumnWidth.width && !(0, _resize.comparator)(this.resizeLastPosition, newColumnWidth.position, 10)) {\n              // If our previous action was to resize the right column in pair, and we're now dragging back\n              // to the right, but have matched a column for the left we need to fix the columns being\n              // affected\n              if (usedHistory && this.resizeLastColumnInPair === \"right\" && direction === \"right\" && newColumnWidth.forColumn === \"left\") {\n                var originalMainColumn = mainColumn;\n                mainColumn = adjustedColumn;\n                adjustedColumn = (0, _resize.getAdjacentColumn)(originalMainColumn, \"+1\");\n              }\n\n              this.recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair);\n              this.resizeLastPosition = newColumnWidth.position;\n              this.resizeLastColumnInPair = modifyColumnInPair; // Ensure the adjusted column is marked as resizing to animate correctly\n\n              this.setColumnsAsResizing(mainColumn, adjustedColumn);\n              this.onColumnResize(mainColumn, newColumnWidth.width, adjustedColumn); // Wait for the render cycle to finish from the above resize before re-calculating\n\n              _underscore.defer(function () {\n                // If we do a resize, re-calculate the column widths\n                _this11.resizeColumnWidths = _this11.resizeUtils.determineColumnWidths(_this11.resizeColumnInstance, groupPosition);\n                _this11.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this11.resizeColumnWidths);\n              });\n            }\n          }\n        }\n      }\n    }\n    /**\n     * Handle a column being dragged around the group\n     * @deprecated - this is now handled in column-line/preview onDraggingMouseMove\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onDraggingMouseMove = function onDraggingMouseMove(event, group, groupPosition) {\n      var dragColumn = (0, _registry2.getDragColumn)();\n\n      if (dragColumn) {\n        // If the drop positions haven't been calculated for this group do so now\n        if (this.dropPositions.length === 0) {\n          this.dropPositions = (0, _dragAndDrop.calculateDropPositions)(this.contentType);\n        }\n\n        var columnInstance = dragColumn;\n        var currentX = event.pageX - groupPosition.left; // Are we within the same column group or have we ended up over another?\n\n        if (columnInstance.parentContentType === this.contentType && this.startDragEvent) {\n          var dragDirection = event.pageX <= this.startDragEvent.pageX ? \"left\" : \"right\";\n          var adjacentLeftColumn = (0, _resize.getAdjacentColumn)(dragColumn, \"-1\"); // Determine the current move position based on the cursors position and direction of drag\n\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX < position.right && position.placement === dragDirection && position.affectedColumn !== dragColumn;\n          }); // Differences in the element & event positions cause a right movement to activate on the left column\n\n          if (this.movePosition && dragDirection === \"right\" && this.movePosition.affectedColumn === adjacentLeftColumn) {\n            this.movePosition = null;\n          }\n\n          if (this.movePosition) {\n            this.movePlaceholder.css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? groupPosition.width - this.movePosition.right : \"\",\n              width: dragColumn.preview.element.outerWidth() + \"px\"\n            }).addClass(\"active\");\n          } else {\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        } else {\n          // If we're moving to another column group we utilise the existing drop placeholder\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX <= position.right && position.canShrink;\n          });\n\n          if (this.movePosition) {\n            var classToRemove = this.movePosition.placement === \"left\" ? \"right\" : \"left\";\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        }\n      }\n    }\n    /**\n     * Handle mouse move events on when dropping elements\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     * @deprecated now handled in column-line/preview\n     */\n    ;\n\n    _proto.onDroppingMouseMove = function onDroppingMouseMove(event, group, groupPosition) {\n      var elementChildrenParent = group.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.dropOverElement && event.pageY > groupPosition.top + 20 && event.pageY < groupPosition.top + groupPosition.outerHeight - 20) {\n        // Disable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", true);\n        }\n\n        var currentX = event.pageX - groupPosition.left;\n        this.dropPosition = this.dropPositions.find(function (position) {\n          return currentX > position.left && currentX <= position.right && position.canShrink;\n        });\n      } else if (this.dropOverElement) {\n        // Re-enable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", false);\n        }\n\n        this.dropPosition = null;\n      }\n    }\n    /**\n     * Init the droppable functionality for new columns\n     *\n     * @param {JQuery} group\n     */\n    ;\n\n    _proto.initDroppable = function initDroppable(group) {\n      var self = this;\n      var headStyles;\n      group.droppable({\n        deactivate: function deactivate() {\n          self.dropOverElement = null;\n\n          _underscore.defer(function () {\n            // Re-enable the column group sortable instance & all children sortable instances\n            group.parents(\".element-children\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n              }\n            });\n          });\n        },\n        activate: function activate() {\n          if ((0, _registry.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            var _ref;\n\n            group.find(\".ui-sortable\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", true);\n              }\n            });\n            var classes = [\".pagebuilder-content-type.pagebuilder-column .pagebuilder-drop-indicator\", \".pagebuilder-content-type.pagebuilder-column .empty-container .content-type-container:before\"]; // Ensure we don't display any drop indicators inside the column\n\n            headStyles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classes.join(\", \")] = {\n              display: \"none!important\"\n            }, _ref));\n            document.head.appendChild(headStyles);\n          } else if (headStyles) {\n            headStyles.remove();\n            headStyles = null;\n          }\n        },\n        drop: function drop() {\n          self.dropPositions = [];\n        },\n        out: function out() {\n          self.dropOverElement = null;\n        },\n        over: function over() {\n          // Is the element currently being dragged a column group?\n          if ((0, _registry.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            // Always calculate drop positions when an element is dragged over\n            self.dropOverElement = true;\n          } else {\n            self.dropOverElement = null;\n          }\n        }\n      });\n    }\n    /**\n     * Spread any empty space across the other columns when a column is removed\n     *\n     * @param {number} removedIndex\n     */\n    ;\n\n    _proto.spreadWidth = function spreadWidth(removedIndex) {\n      if (this.contentType.children().length === 0) {\n        return;\n      }\n\n      var availableWidth = 100 - this.resizeUtils.getColumnsWidth();\n      var formattedAvailableWidth = (0, _resize.getRoundedColumnWidth)(availableWidth);\n      var totalChildColumns = this.contentType.children().length;\n      var allowedColumnWidths = [];\n      var spreadAcross = 1;\n      var spreadAmount;\n\n      for (var i = this.resizeUtils.getGridSize(); i > 0; i--) {\n        allowedColumnWidths.push((0, _resize.getRoundedColumnWidth)(100 / this.resizeUtils.getGridSize() * i));\n      } // Determine how we can spread the empty space across the columns\n\n\n      for (var _i = totalChildColumns; _i > 0; _i--) {\n        var potentialWidth = Math.floor(formattedAvailableWidth / _i);\n\n        for (var _iterator2 = _createForOfIteratorHelperLoose(allowedColumnWidths), _step2; !(_step2 = _iterator2()).done;) {\n          var width = _step2.value;\n\n          if (potentialWidth === Math.floor(width)) {\n            spreadAcross = _i;\n            spreadAmount = formattedAvailableWidth / _i;\n            break;\n          }\n        }\n\n        if (spreadAmount) {\n          break;\n        }\n      } // Let's spread the width across the columns\n\n\n      for (var _i2 = 1; _i2 <= spreadAcross; _i2++) {\n        var columnToModify = void 0; // As the original column has been removed from the array, check the new index for a column\n\n        if (removedIndex <= this.contentType.children().length && typeof this.contentType.children()[removedIndex] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex];\n        }\n\n        if (!columnToModify && removedIndex - _i2 >= 0 && typeof this.contentType.children()[removedIndex - _i2] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex - _i2];\n        }\n\n        if (columnToModify) {\n          (0, _resize.updateColumnWidth)(columnToModify, this.resizeUtils.getColumnWidth(columnToModify) + spreadAmount);\n        }\n      }\n    }\n    /**\n     * Remove self if we contain no children\n     */\n    ;\n\n    _proto.removeIfEmpty = function removeIfEmpty() {\n      if (this.contentType.children().length === 0) {\n        this.contentType.parentContentType.removeChild(this.contentType);\n        return;\n      }\n    }\n    /**\n     * Record the grid resize operation into a history for later restoration\n     *\n     * @param {number} newGridSize\n     */\n    ;\n\n    _proto.recordGridResize = function recordGridResize(newGridSize) {\n      var _this12 = this;\n\n      // @todo evaluate utility of having a grid size history\n      return;\n\n      if (!this.gridSizeHistory.has(newGridSize)) {\n        var columnWidths = [];\n        this.contentType.getChildren()().forEach(function (column) {\n          columnWidths.push(_this12.resizeUtils.getColumnWidth(column));\n        });\n        this.gridSizeHistory.set(newGridSize, columnWidths);\n      }\n    }\n    /**\n     * Figure out the maximum number of non-empty columns in various column lines\n     * @private\n     */\n    ;\n\n    _proto.getNonEmptyColumnCount = function getNonEmptyColumnCount() {\n      var nonEmptyColumnCount = 0;\n      this.contentType.getChildren()().forEach(function (columnLine, index) {\n        var numEmptyColumns = 0;\n        var numCols = columnLine.getChildren()().length;\n        columnLine.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            numEmptyColumns++;\n          }\n        });\n\n        if (numCols - numEmptyColumns > nonEmptyColumnCount) {\n          nonEmptyColumnCount = numCols - numEmptyColumns;\n        }\n      });\n      return nonEmptyColumnCount;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column-group/factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\"], function (_config, _contentTypeFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a column and add it to it's column group\n   *\n   * @param {ContentTypeCollectionInterface} columnGroup\n   * @param {number} width\n   * @param {number} index\n   * @returns {Promise<ContentTypeCollectionInterface>}\n   */\n  function createColumn(columnGroup, width, index) {\n    return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), columnGroup, columnGroup.stageId, {\n      width: parseFloat(width.toString()) + \"%\"\n    }).then(function (column) {\n      columnGroup.addChild(column, index);\n      return column;\n    }).catch(function (error) {\n      console.error(error);\n      return null;\n    });\n  }\n  /**\n   * Create a column and add it to it's column group\n   *\n   * @param {ContentTypeCollectionInterface} columnGroup\n   * @param {number} width\n   * @param {number} index\n   * @returns {Promise<ContentTypeCollectionInterface>}\n   */\n\n\n  function createColumnLine(columnGroup, width, index) {\n    return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-line\"), columnGroup, columnGroup.stageId, {\n      width: parseFloat(width.toString()) + \"%\"\n    }).then(function (columnLine) {\n      columnGroup.addChild(columnLine, index);\n      return columnLine;\n    }).catch(function (error) {\n      console.error(error);\n      return null;\n    });\n  }\n\n  return {\n    createColumn: createColumn,\n    createColumnLine: createColumnLine\n  };\n});\n//# sourceMappingURL=factory.js.map","Magento_PageBuilder/js/content-type/column-group/registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var dragColumn;\n  /**\n   * Retrieve the drag column from the registry\n   *\n   * @returns {ContentTypeCollectionInterface}\n   */\n\n  function getDragColumn() {\n    return dragColumn;\n  }\n  /**\n   * Remove the drag column reference\n   */\n\n\n  function removeDragColumn() {\n    dragColumn = null;\n  }\n  /**\n   * Set the drag column in the registry\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   */\n\n\n  function setDragColumn(column) {\n    dragColumn = column;\n  }\n\n  return {\n    getDragColumn: getDragColumn,\n    removeDragColumn: removeDragColumn,\n    setDragColumn: setDragColumn\n  };\n});\n//# sourceMappingURL=registry.js.map","Magento_PageBuilder/js/content-type/column-group/drag-and-drop.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Calculate the drop positions of a column group\n   *\n   * @param {ContentTypeCollectionInterface} group\n   * @returns {any[]}\n   */\n  function calculateDropPositions(group) {\n    var resizeUtils = group.preview.getResizeUtils();\n    var dropPositions = [];\n    group.children().forEach(function (column, index) {\n      var left = column.preview.element.position().left;\n      var width = column.preview.element.outerWidth(true);\n      var canShrink = resizeUtils.getAcceptedColumnWidth(resizeUtils.getColumnWidth(column).toString()) > resizeUtils.getSmallestColumnWidth();\n      dropPositions.push({\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index,\n        left: left,\n        placement: \"left\",\n        right: left + width / 2\n      }, {\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index + 1,\n        left: left + width / 2,\n        placement: \"right\",\n        right: left + width\n      });\n    });\n    return dropPositions;\n  }\n\n  return {\n    calculateDropPositions: calculateDropPositions\n  };\n});\n//# sourceMappingURL=drag-and-drop.js.map","Magento_PageBuilder/js/content-type/column-group/grid-size.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _wrapNativeSuper(Class) { var _cache = typeof Map === \"function\" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== \"function\") { throw new TypeError(\"Super expression must either be null or a function\"); } if (typeof _cache !== \"undefined\") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }\n\nfunction _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _isNativeFunction(fn) { return Function.toString.call(fn).indexOf(\"[native code]\") !== -1; }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"mage/translate\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/column/resize\"], function (_translate, _config, _resize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Retrieve default  grid size\n   *\n   * @returns {number}\n   */\n  function getDefaultGridSize() {\n    return parseInt(_config.getConfig(\"column_grid_default\"), 10);\n  }\n  /**\n   * Retrieve the max grid size\n   *\n   * @returns {number}\n   */\n\n\n  function getMaxGridSize() {\n    return parseInt(_config.getConfig(\"column_grid_max\"), 10);\n  }\n  /**\n   * Apply the new grid size, adjusting the existing columns as needed.\n   *\n   * Rules for resizing the grid:\n   *  - The grid size can be increased up to the configured maximum value.\n   *  - The grid size can be decreased only if the number of non-empty columns is less than or equal to the new size.\n   *  - If the new grid size is less than the number of columns currently in the grid, empty columns will be deleted\n   *    to accommodate the new size.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   * @param {Map<number, number[]>} gridSizeHistory\n   */\n\n\n  function resizeGrid(columnGroup, newGridSize, gridSizeHistory) {\n    if (newGridSize === columnGroup.preview.getResizeUtils().getInitialGridSize()) {\n      return;\n    }\n\n    validateNewGridSize(columnGroup, newGridSize);\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      // if we have more columns than the new grid size allows, remove empty columns till the correct size\n      console.log(columnLine.getChildren()().length);\n\n      if (newGridSize < columnLine.getChildren()().length) {\n        removeEmptyColumnsToFit(columnLine, newGridSize);\n      }\n    }); // update column widths\n\n    redistributeColumnWidths(columnGroup, newGridSize, gridSizeHistory);\n  }\n  /**\n   * Validate that the new grid size is within the configured limits and can be achieved.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function validateNewGridSize(columnGroup, newGridSize) {\n    // Validate against the max grid size\n    if (newGridSize > getMaxGridSize()) {\n      throw new GridSizeError((0, _translate)(\"The maximum grid size supported is \" + getMaxGridSize() + \".\"));\n    } else if (newGridSize < 2) {\n      throw new GridSizeError((0, _translate)(\"The minimum grid size supported is 2.\"));\n    } // Validate that the operation will be successful\n\n\n    var doThrowException = false;\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      var numEmptyColumns = 0;\n      var numCols = columnLine.getChildren()().length;\n      var currentGridSize = columnLine.preview.getResizeUtils().getInitialGridSize();\n\n      if (newGridSize < currentGridSize && numCols > newGridSize) {\n        columnLine.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            numEmptyColumns++;\n          }\n        });\n\n        if (newGridSize < numCols - numEmptyColumns) {\n          doThrowException = true;\n        }\n      }\n    });\n\n    if (doThrowException) {\n      throw new Error((0, _translate)(\"Grid size cannot be smaller than the current total amount of columns, minus any empty columns.\"));\n    }\n  }\n  /**\n   * Remove empty columns so we can accommodate the new grid size\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function removeEmptyColumnsToFit(columnLine, newGridSize) {\n    var columns = columnLine.getChildren()();\n    var numColumns = columns.length;\n    var i;\n\n    for (i = numColumns - 1; i >= 0; i--) {\n      var column = columns[i];\n\n      if (newGridSize < numColumns && column.getChildren()().length === 0) {\n        columnLine.removeChild(column);\n        numColumns--;\n      }\n    }\n  }\n  /**\n   * Adjust columns widths across the new grid size, making sure each column is at least one grid size in width\n   * and the entire grid size is distributed.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   * @param {Map<number, number[]>} gridSizeHistory\n   */\n\n\n  function redistributeColumnWidths(columnGroup, newGridSize, gridSizeHistory) {\n    // apply known column widths if we have resized before\n    if (gridSizeHistory.has(newGridSize) && gridSizeHistory.get(newGridSize).length === columnGroup.getChildren()().length) {\n      var columnWidths = gridSizeHistory.get(newGridSize);\n      columnGroup.getChildren()().forEach(function (column, index) {\n        (0, _resize.updateColumnWidth)(column, columnWidths[index]);\n      });\n      columnGroup.dataStore.set(\"grid_size\", newGridSize);\n      columnGroup.dataStore.unset(\"initial_grid_size\");\n      return;\n    }\n\n    var columnGroupResizeUtil = columnGroup.preview.getResizeUtils();\n    var existingGridSize = columnGroupResizeUtil.getInitialGridSize();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    columnGroup.getChildren()().forEach(function (columnLine, columnLineIndex) {\n      var totalNewWidths = 0;\n      var remainingWidth = 0;\n      var numColumns = columnLine.getChildren()().length;\n      var resizeUtils = columnLine.preview.getResizeUtils();\n      columnLine.getChildren()().forEach(function (column, index) {\n        var existingWidth = resizeUtils.getColumnWidth(column);\n        var fractionColumnWidth = Math.round(existingWidth / (100 / existingGridSize));\n        /**\n         * Determine if the grid & column are directly compatible with the new defined grid size, this will\n         * directly convert fractions to their equivalent of the new grid size.\n         *\n         * For instance changing a 12 column grid with 2 x 6 / 12 columns to a 6 grid is fully compatible.\n         *\n         * Check the existing grid size and new grid size are divisible, verify the amount of columns will fit\n         * in the new grid size and finally check the calculation to convert the existing column width results\n         * in a positive integer.\n         */\n\n        if ((existingGridSize > newGridSize && existingGridSize % newGridSize === 0 || existingGridSize < newGridSize && newGridSize % existingGridSize === 0) && newGridSize % numColumns === 0 && newGridSize / existingGridSize * fractionColumnWidth % 1 === 0) {\n          // We don't need to modify the columns width as it's compatible, we will however increment the\n          // width counter as some other columns may not be compatible.\n          totalNewWidths += existingWidth;\n        } else {\n          var newWidth = (100 * Math.floor(existingWidth / 100 * newGridSize) / newGridSize).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0); // make sure the column is at least one grid size wide\n\n          if (parseFloat(newWidth) < parseFloat(minColWidth)) {\n            newWidth = minColWidth;\n          } // make sure we leave enough space for other columns\n\n\n          var widthTaken = totalNewWidths + (numColumns - index - 1) * parseFloat(minColWidth);\n          var maxAvailableWidth = 100 - totalNewWidths;\n\n          if (parseFloat(newWidth) > maxAvailableWidth) {\n            var gridWidth = Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0;\n            newWidth = maxAvailableWidth.toFixed(gridWidth);\n          } // Calculate any width lost from the column, if a 5 / 12 is becoming a 2 / 6 then it's lost 1 / 12\n\n\n          remainingWidth += existingWidth - parseFloat(newWidth);\n          /**\n           * Determine if we have enough remaining width, and apply it to the current column, this results in\n           * a subsequent column always receiving any additional width from the previous column\n           */\n\n          if (resizeUtils.getSmallestColumnWidth(newGridSize) === resizeUtils.getAcceptedColumnWidth(remainingWidth.toString(), newGridSize)) {\n            var widthWithRemaining = resizeUtils.getAcceptedColumnWidth((parseFloat(newWidth) + remainingWidth).toString(), newGridSize);\n\n            if (widthWithRemaining > 0) {\n              newWidth = widthWithRemaining.toFixed(Math.round(100 / widthWithRemaining) !== 100 / widthWithRemaining ? 8 : 0);\n              remainingWidth = 0;\n            }\n          }\n\n          totalNewWidths += parseFloat(newWidth);\n          (0, _resize.updateColumnWidth)(column, parseFloat(newWidth));\n        }\n\n        column.preview.updateDisplayLabel();\n      });\n    });\n    columnGroup.dataStore.set(\"grid_size\", newGridSize);\n    columnGroup.dataStore.unset(\"initial_grid_size\");\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      var resizeUtils = columnLine.preview.getResizeUtils();\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        applyLeftoverColumnsInColumnLine(columnLine, newGridSize);\n      }\n    });\n  }\n  /**\n   * Make sure the full grid size is distributed across the columns\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function applyLeftoverColumns(columnGroup, newGridSize) {\n    var resizeUtils = columnGroup.preview.getResizeUtils();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    var column;\n\n    for (var _iterator = _createForOfIteratorHelperLoose(columnGroup.getChildren()()), _step; !(_step = _iterator()).done;) {\n      column = _step.value;\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        (0, _resize.updateColumnWidth)(column, parseFloat(resizeUtils.getColumnWidth(column).toString()) + parseFloat(minColWidth));\n      } else {\n        break;\n      }\n    }\n  }\n  /**\n   * Make sure the full grid size is distributed across the columns\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function applyLeftoverColumnsInColumnLine(columnLine, newGridSize) {\n    var resizeUtils = columnLine.preview.getResizeUtils();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    var column;\n\n    for (var _iterator2 = _createForOfIteratorHelperLoose(columnLine.getChildren()()), _step2; !(_step2 = _iterator2()).done;) {\n      column = _step2.value;\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        (0, _resize.updateColumnWidth)(column, parseFloat(resizeUtils.getColumnWidth(column).toString()) + parseFloat(minColWidth));\n      } else {\n        break;\n      }\n    }\n  }\n\n  var GridSizeError = /*#__PURE__*/function (_Error) {\n    \"use strict\";\n\n    _inheritsLoose(GridSizeError, _Error);\n\n    function GridSizeError(m) {\n      var _this;\n\n      _this = _Error.call(this, m) || this;\n      Object.setPrototypeOf(_assertThisInitialized(_this), GridSizeError.prototype);\n      return _this;\n    }\n\n    return GridSizeError;\n  }( /*#__PURE__*/_wrapNativeSuper(Error));\n\n  return {\n    getDefaultGridSize: getDefaultGridSize,\n    getMaxGridSize: getMaxGridSize,\n    resizeGrid: resizeGrid,\n    GridSizeError: GridSizeError\n  };\n});\n//# sourceMappingURL=grid-size.js.map","Magento_PageBuilder/js/content-type/html/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"Magento_Ui/js/modal/alert\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column-line/preview\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column/resize\"], function (_jquery, _knockout, _translate, _events, _alert, _config, _contentTypeFactory, _option, _gridSize, _preview, _previewCollection, _resize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Fields that should not be considered when evaluating whether an object has been configured.\n     *\n     * @see {Preview.isConfigured}\n     * @type {[string]}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Update the width label for the column\n\n      _this.resizing = _knockout.observable(false);\n      _this.fieldsToIgnoreOnRemove = [\"width\"];\n\n      _this.contentType.dataStore.subscribe(_this.updateColumnWidthClass.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.dataStore.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.dataStore.subscribe(_this.triggerChildren.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.parentContentType.dataStore.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)), \"grid_size\"); // Update the column number for the column\n\n\n      _this.contentType.parentContentType.children.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)));\n\n      return _this;\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"column:moveAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.updateDisplayLabel();\n        }\n\n        _this2.resetRemoveOnLastColumn(args.targetParent);\n\n        _this2.resetRemoveOnLastColumn(args.sourceParent);\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(args.columnLine);\n      });\n\n      _events.on(\"column:dropAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(_this2.contentType.parentContentType);\n      });\n\n      _events.on(\"column:duplicateAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(args.duplicateContentType.parentContentType);\n      });\n\n      _events.on(\"column:removeAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.resetRemoveOnLastColumn(args.parentContentType);\n        }\n      });\n    }\n    /**\n     * Make a reference to the element in the column\n     *\n     * @param element\n     */\n    ;\n\n    _proto.initColumn = function initColumn(element) {\n      this.element = (0, _jquery)(element);\n      this.updateColumnWidthClass();\n\n      _events.trigger(\"column:initializeAfter\", {\n        column: this.contentType,\n        element: (0, _jquery)(element),\n        columnLine: this.contentType.parentContentType,\n        columnGroup: this.contentType.parentContentType.parentContentType\n      });\n\n      this.updateDisplayLabel();\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.move = new _option({\n        preview: this,\n        icon: \"<i class='icon-admin-pagebuilder-handle'></i>\",\n        title: (0, _translate)(\"Move\"),\n        classes: [\"move-column\"],\n        sort: 10\n      });\n      return options;\n    }\n    /**\n     * Init the resize handle for the resizing functionality\n     *\n     * @param handle\n     */\n    ;\n\n    _proto.bindResizeHandle = function bindResizeHandle(handle) {\n      _events.trigger(\"column:resizeHandleBindAfter\", {\n        column: this.contentType,\n        handle: (0, _jquery)(handle),\n        columnLine: this.contentType.parentContentType\n      });\n    }\n    /**\n     * Wrap the current column in a group if it not in a column-group\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumnGroup = function createColumnGroup() {\n      var _this3 = this;\n\n      if (this.contentType.parentContentType.config.name !== \"column-group\") {\n        var index = this.contentType.parentContentType.children().indexOf(this.contentType); // Remove child instantly to stop content jumping around\n\n        this.contentType.parentContentType.removeChild(this.contentType); // Create a new instance of column group to wrap our columns with\n\n        var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n        return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-group\"), this.contentType.parentContentType, this.contentType.stageId, {\n          grid_size: defaultGridSize\n        }).then(function (columnGroup) {\n          var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n          return Promise.all([(0, _contentTypeFactory)(_this3.contentType.config, columnGroup, columnGroup.stageId, {\n            width: col1Width + \"%\"\n          }), (0, _contentTypeFactory)(_this3.contentType.config, columnGroup, columnGroup.stageId, {\n            width: 100 - parseFloat(col1Width) + \"%\"\n          })]).then(function (columns) {\n            columnGroup.addChild(columns[0], 0);\n            columnGroup.addChild(columns[1], 1);\n\n            _this3.contentType.parentContentType.addChild(columnGroup, index);\n\n            _this3.fireMountEvent(columnGroup, columns[0], columns[1]);\n\n            return columnGroup;\n          });\n        });\n      }\n    }\n    /**\n     * Duplicate a child of the current instance\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} contentType\n     * @param {boolean} autoAppend\n     * @returns {Promise<ContentTypeCollectionInterface> | void}\n     */\n    ;\n\n    _proto.clone = function clone(contentType, autoAppend) {\n      if (autoAppend === void 0) {\n        autoAppend = true;\n      }\n\n      var resizeUtils = this.contentType.parentContentType.preview.getResizeUtils(); // Are we duplicating from a container content type?\n\n      if (contentType.config.name !== \"column\" || this.contentType.parentContentType.children().length === 0 || this.contentType.parentContentType.children().length > 0 && resizeUtils.getColumnsWidth() < 100) {\n        return _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n      }\n\n      var biggestShrinkableColumn = resizeUtils.findBiggerShrinkableColumn(contentType);\n\n      if (biggestShrinkableColumn) {\n        var shrinkableClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n        if (shrinkableClone) {\n          var newShrinkableColumnWidth = resizeUtils.getColumnWidth(biggestShrinkableColumn) - resizeUtils.getColumnWidth(contentType);\n          var duplicateColumnWidth = resizeUtils.getColumnWidth(contentType);\n          shrinkableClone.then(function (duplicateContentType) {\n            (0, _resize.updateColumnWidth)(biggestShrinkableColumn, resizeUtils.getAcceptedColumnWidth(newShrinkableColumnWidth.toString()));\n            (0, _resize.updateColumnWidth)(duplicateContentType, duplicateColumnWidth);\n            return duplicateContentType;\n          });\n        }\n\n        return;\n      } // Attempt to split the current column into parts\n\n\n      var splitTimes = Math.round(resizeUtils.getColumnWidth(contentType) / resizeUtils.getSmallestColumnWidth());\n\n      if (splitTimes > 1) {\n        var splitClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n        if (splitClone) {\n          splitClone.then(function (duplicateContentType) {\n            /**\n             * Distribute the width across the original & duplicated columns, if the we have an odd number of\n             * split times apply it to the original.\n             */\n            var originalWidth = (Math.floor(splitTimes / 2) + splitTimes % 2) * resizeUtils.getSmallestColumnWidth();\n            var duplicateWidth = Math.floor(splitTimes / 2) * resizeUtils.getSmallestColumnWidth();\n            (0, _resize.updateColumnWidth)(contentType, resizeUtils.getAcceptedColumnWidth(originalWidth.toString()));\n            (0, _resize.updateColumnWidth)(duplicateContentType, resizeUtils.getAcceptedColumnWidth(duplicateWidth.toString()));\n            return duplicateContentType;\n          });\n        }\n      } else {\n        // Conduct an outward search on the children to locate a suitable shrinkable column\n        var shrinkableColumn = resizeUtils.findShrinkableColumn(contentType);\n\n        if (shrinkableColumn) {\n          var _shrinkableClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n          if (_shrinkableClone) {\n            _shrinkableClone.then(function (duplicateContentType) {\n              (0, _resize.updateColumnWidth)(shrinkableColumn, resizeUtils.getAcceptedColumnWidth((resizeUtils.getColumnWidth(shrinkableColumn) - resizeUtils.getSmallestColumnWidth()).toString()));\n              (0, _resize.updateColumnWidth)(duplicateContentType, resizeUtils.getSmallestColumnWidth());\n              return duplicateContentType;\n            });\n          }\n        } else {\n          // If we aren't able to duplicate inform the user why\n          (0, _alert)({\n            content: (0, _translate)(\"There is no free space within the column group to perform this action.\"),\n            title: (0, _translate)(\"Unable to duplicate column\")\n          });\n        }\n      }\n    }\n    /**\n     * Update the display label for the column\n     */\n    ;\n\n    _proto.updateDisplayLabel = function updateDisplayLabel() {\n      if (this.contentType.parentContentType.preview instanceof _preview) {\n        var newWidth = parseFloat(this.contentType.dataStore.get(\"width\").toString());\n        var grandParent = this.contentType.parentContentType.parentContentType;\n        var columnGroupPreview = grandParent.preview;\n        var gridSize = columnGroupPreview.gridSize();\n        var newLabel = Math.round(newWidth / (100 / gridSize)) + \"/\" + gridSize;\n        var columnIndex = this.contentType.parentContentType.children().indexOf(this.contentType);\n        var columnNumber = columnIndex !== -1 ? columnIndex + 1 + \" \" : \"\";\n        this.displayLabel((0, _translate)(\"Column\") + \" \" + columnNumber + \"(\" + newLabel + \")\");\n      }\n    }\n    /**\n     * Reset remove option on all columns within a column-group depending on the number of remaining child columns\n     * @param parentContentType\n     */\n    ;\n\n    _proto.resetRemoveOnLastColumn = function resetRemoveOnLastColumn(parentContentType) {\n      if (!parentContentType) {\n        // can happen if the column is moved within the same column group\n        return;\n      }\n\n      if (parentContentType.config.name !== \"column-line\") {\n        // for legacy content in preview mode before stage is initialized, the parent may not be a column line\n        return;\n      }\n\n      var siblings = parentContentType.children();\n      var siblingColumnLines = parentContentType.parentContentType.children();\n      var totalColumnCount = 0;\n      siblingColumnLines.forEach(function (columnLine) {\n        var columns = columnLine.children();\n        columns.forEach(function (column) {\n          totalColumnCount++;\n        });\n      });\n      var isRemoveDisabled = totalColumnCount <= 1;\n      siblingColumnLines.forEach(function (columnLine) {\n        var columns = columnLine.children();\n        columns.forEach(function (column) {\n          var removeOption = column.preview.getOptions().getOption(\"remove\");\n          removeOption.isDisabled(isRemoveDisabled);\n        });\n      });\n    }\n    /**\n     * Syncs the column-width-* class on the children-wrapper with the current width to the nearest tenth rounded up\n     */\n    ;\n\n    _proto.updateColumnWidthClass = function updateColumnWidthClass() {\n      // Only update once instantiated\n      if (!this.element) {\n        return;\n      }\n\n      var currentClass = this.element.attr(\"class\").match(/(?:^|\\s)(column-width-\\d{1,3})(?:$|\\s)/);\n\n      if (currentClass !== null) {\n        this.element.removeClass(currentClass[1]);\n      }\n\n      var roundedWidth = Math.ceil(parseFloat(this.contentType.dataStore.get(\"width\").toString()) / 10) * 10;\n      this.element.addClass(\"column-width-\" + roundedWidth);\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len = arguments.length, contentTypes = new Array(_len), _key = 0; _key < _len; _key++) {\n        contentTypes[_key] = arguments[_key];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Delegate trigger call on children elements.\n     */\n    ;\n\n    _proto.triggerChildren = function triggerChildren() {\n      if (this.contentType.parentContentType.preview instanceof _preview) {\n        var newWidth = parseFloat(this.contentType.dataStore.get(\"width\").toString());\n        this.delegate(\"trigger\", \"columnWidthChangeAfter\", {\n          width: newWidth\n        });\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column/resize.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/array\"], function (_array) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Resize = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Resize(columnGroup, columnLine) {\n      this.columnGroup = columnGroup;\n      this.columnLine = columnLine;\n    }\n    /**\n     * Get the grid size for this columnGroup\n     *\n     * @returns {number}\n     */\n\n\n    var _proto = Resize.prototype;\n\n    _proto.getGridSize = function getGridSize() {\n      return parseInt(this.columnGroup.dataStore.get(\"grid_size\").toString(), 10);\n    }\n    /**\n     * Get the initial grid size for this columnGroup before it was updated\n     *\n     * @returns {number}\n     */\n    ;\n\n    _proto.getInitialGridSize = function getInitialGridSize() {\n      return parseInt(this.columnGroup.dataStore.get(\"initial_grid_size\", 0).toString(), 10);\n    }\n    /**\n     * Get the smallest column width possible\n     *\n     * @param {number} gridSize\n     * @returns {number}\n     */\n    ;\n\n    _proto.getSmallestColumnWidth = function getSmallestColumnWidth(gridSize) {\n      gridSize = gridSize || this.getInitialGridSize() || this.getGridSize();\n      return this.getAcceptedColumnWidth(parseFloat((100 / gridSize).toString()).toFixed(Math.round(100 / gridSize) !== 100 / gridSize ? 8 : 0));\n    }\n    /**\n     * Get an accepted column width to resolve rounding issues, e.g. turn 49.995% into 50%\n     *\n     * @param {string} width\n     * @param {number} gridSize\n     * @returns {number}\n     */\n    ;\n\n    _proto.getAcceptedColumnWidth = function getAcceptedColumnWidth(width, gridSize) {\n      gridSize = gridSize || this.getInitialGridSize() || this.getGridSize();\n      var newWidth = 0;\n\n      for (var i = gridSize; i > 0; i--) {\n        var percentage = parseFloat((100 / gridSize * i).toFixed(Math.round(100 / gridSize * i) !== 100 / gridSize * i ? 8 : 0)); // Allow for rounding issues\n\n        if (parseFloat(width) > percentage - 0.1 && parseFloat(width) < percentage + 0.1) {\n          newWidth = percentage;\n          break;\n        }\n      }\n\n      return newWidth;\n    }\n    /**\n     * Return the width of the column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {number}\n     */\n    ;\n\n    _proto.getColumnWidth = function getColumnWidth(column) {\n      return this.getAcceptedColumnWidth(column.dataStore.get(\"width\").toString());\n    }\n    /**\n     * Get the total width of all columns in the column line\n     *\n     * @returns {number}\n     */\n    ;\n\n    _proto.getColumnsWidth = function getColumnsWidth() {\n      var _this = this;\n\n      return this.getAcceptedColumnWidth(this.columnLine.children().map(function (column) {\n        return _this.getColumnWidth(column);\n      }).reduce(function (widthA, widthB) {\n        return widthA + (widthB ? widthB : 0);\n      }).toString());\n    }\n    /**\n     * Determine the pixel position of every column that can be created within the group\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {GroupPositionCache} groupPosition\n     * @returns {ColumnWidth[]}\n     */\n    ;\n\n    _proto.determineColumnWidths = function determineColumnWidths(column, groupPosition) {\n      var gridSize = this.getGridSize();\n      var singleColumnWidth = groupPosition.outerWidth / gridSize;\n      var adjacentColumn = getAdjacentColumn(column, \"+1\");\n      var columnWidths = [];\n      var columnLeft = column.preview.element.offset().left - parseInt(column.preview.element.css(\"margin-left\"), 10);\n      var adjacentRightPosition = adjacentColumn.preview.element.offset().left + adjacentColumn.preview.element.outerWidth(true); // Determine the maximum size (in pixels) that this column can be dragged to\n\n      var columnsToRight = column.parentContentType.children().length - (getColumnIndexInGroup(column) + 1);\n      var leftMaxWidthFromChildren = groupPosition.left + groupPosition.outerWidth - columnsToRight * singleColumnWidth + 10;\n      var rightMaxWidthFromChildren = groupPosition.left + (column.parentContentType.children().length - columnsToRight) * singleColumnWidth - 10; // Due to rounding we add a threshold of 10\n      // Iterate through the amount of columns generating the position for both left & right interactions\n\n      for (var i = gridSize; i > 0; i--) {\n        var position = Math.round(columnLeft + singleColumnWidth * i);\n\n        if (position > Math.round(leftMaxWidthFromChildren)) {\n          continue;\n        }\n\n        columnWidths.push({\n          forColumn: \"left\",\n          // These positions are for the left column in the pair\n          name: i + \"/\" + gridSize,\n          position: position,\n          width: getRoundedColumnWidth(100 / gridSize * i)\n        });\n      }\n\n      for (var _i = 1; _i < gridSize; _i++) {\n        var _position = Math.floor(adjacentRightPosition - _i * singleColumnWidth);\n\n        if (_position < Math.floor(rightMaxWidthFromChildren)) {\n          continue;\n        } // The right interaction is only used when we're crushing a column that isn't adjacent\n\n\n        columnWidths.push({\n          forColumn: \"right\",\n          // These positions are for the left column in the pair\n          name: _i + \"/\" + gridSize,\n          position: _position,\n          width: getRoundedColumnWidth(100 / gridSize * _i)\n        });\n      }\n\n      return columnWidths;\n    }\n    /**\n     * Find a column which can be shrunk for the current resize action\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {\"left\" | \"right\"} direction\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findShrinkableColumnForResize = function findShrinkableColumnForResize(column, direction) {\n      var _this2 = this;\n\n      var currentIndex = getColumnIndexInGroup(column);\n      var columnItemsArray = column.parentContentType.children();\n      var searchArray;\n\n      switch (direction) {\n        case \"right\":\n          searchArray = columnItemsArray.slice(currentIndex + 1);\n          break;\n\n        case \"left\":\n          searchArray = columnItemsArray.slice(0).reverse().slice(columnItemsArray.length - currentIndex);\n          break;\n      }\n\n      return searchArray.find(function (groupColumn) {\n        return _this2.getColumnWidth(groupColumn) > _this2.getSmallestColumnWidth();\n      });\n    }\n    /**\n     * Find a shrinkable column outwards from the current column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findShrinkableColumn = function findShrinkableColumn(column) {\n      var _this3 = this;\n\n      return (0, _array.outwardSearch)(column.parentContentType.children(), getColumnIndexInGroup(column), function (neighbourColumn) {\n        return _this3.getColumnWidth(neighbourColumn) > _this3.getSmallestColumnWidth();\n      });\n    }\n    /**\n     * Find a shrinkable column of a greater size outwards from the current column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findBiggerShrinkableColumn = function findBiggerShrinkableColumn(column) {\n      var _this4 = this;\n\n      return (0, _array.outwardSearch)(column.parentContentType.children(), getColumnIndexInGroup(column), function (neighbourColumn) {\n        return _this4.getColumnWidth(neighbourColumn) > _this4.getColumnWidth(column);\n      });\n    }\n    /**\n     * Calculate the ghost size for the resizing action\n     *\n     * @param {GroupPositionCache} groupPosition\n     * @param {number} currentPos\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {string} modifyColumnInPair\n     * @param {MaxGhostWidth} maxGhostWidth\n     * @returns {number}\n     */\n    ;\n\n    _proto.calculateGhostWidth = function calculateGhostWidth(groupPosition, currentPos, column, modifyColumnInPair, maxGhostWidth) {\n      var ghostWidth = currentPos - groupPosition.left;\n\n      switch (modifyColumnInPair) {\n        case \"left\":\n          var singleColumnWidth = column.preview.element.position().left + groupPosition.outerWidth / this.getGridSize(); // Don't allow the ghost widths be less than the smallest column\n\n          if (ghostWidth <= singleColumnWidth) {\n            ghostWidth = singleColumnWidth;\n          }\n\n          if (currentPos >= maxGhostWidth.left) {\n            ghostWidth = maxGhostWidth.left - groupPosition.left;\n          }\n\n          break;\n\n        case \"right\":\n          if (currentPos <= maxGhostWidth.right) {\n            ghostWidth = maxGhostWidth.right - groupPosition.left;\n          }\n\n          break;\n      }\n\n      return ghostWidth;\n    }\n    /**\n     * Determine which column in the group should be adjusted for the current resize action\n     *\n     * @param {number} currentPos\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {ResizeHistory} history\n     * @returns {[ContentTypeCollectionInterface<ColumnPreview>, string, string]}\n     */\n    ;\n\n    _proto.determineAdjustedColumn = function determineAdjustedColumn(currentPos, column, history) {\n      var modifyColumnInPair = \"left\";\n      var usedHistory;\n      var resizeColumnLeft = column.preview.element.offset().left - parseInt(column.preview.element.css(\"margin-left\"), 10);\n      var resizeColumnWidth = column.preview.element.outerWidth(true);\n      var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n      var adjustedColumn;\n\n      if (currentPos >= resizeHandlePosition) {\n        // Get the history for the opposite direction of resizing\n        if (history.left.length > 0) {\n          usedHistory = \"left\";\n          adjustedColumn = history.left.reverse()[0].adjustedColumn;\n          modifyColumnInPair = history.left.reverse()[0].modifyColumnInPair;\n        } else {\n          // If we're increasing the width of our column we need to locate a column that can shrink to the\n          // right\n          adjustedColumn = this.findShrinkableColumnForResize(column, \"right\");\n        }\n      } else {\n        if (this.getColumnWidth(column) <= this.getSmallestColumnWidth()) {\n          adjustedColumn = this.findShrinkableColumnForResize(column, \"left\");\n\n          if (adjustedColumn) {\n            modifyColumnInPair = \"right\";\n          }\n        } else if (history.right.length > 0) {\n          usedHistory = \"right\";\n          adjustedColumn = history.right.reverse()[0].adjustedColumn;\n          modifyColumnInPair = history.right.reverse()[0].modifyColumnInPair;\n        } else {\n          // If we're shrinking our column we can just increase the adjacent column\n          adjustedColumn = getAdjacentColumn(column, \"+1\");\n        }\n      }\n\n      return [adjustedColumn, modifyColumnInPair, usedHistory];\n    }\n    /**\n     * Resize a column to a specific width\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<Preview>} shrinkableColumn\n     */\n    ;\n\n    _proto.resizeColumn = function resizeColumn(column, width, shrinkableColumn) {\n      var current = this.getColumnWidth(column);\n      var difference = (parseFloat(width.toString()) - current).toFixed(8); // Don't run the update if we've already modified the column\n\n      if (current === parseFloat(width.toString()) || parseFloat(width.toString()) < this.getSmallestColumnWidth()) {\n        return;\n      } // Also shrink the closest shrinkable column\n\n\n      var allowedToShrink = true;\n\n      if (difference && shrinkableColumn) {\n        var currentShrinkable = this.getColumnWidth(shrinkableColumn);\n        var shrinkableSize = this.getAcceptedColumnWidth((currentShrinkable + -difference).toString()); // Ensure the column we're crushing is not becoming the same size, and it's not less than the smallest width\n\n        if (currentShrinkable === parseFloat(shrinkableSize.toString()) || parseFloat(shrinkableSize.toString()) < this.getSmallestColumnWidth()) {\n          allowedToShrink = false;\n        } else {\n          // Ensure we're not creating more columns width than the grid can support\n          if (this.gridSupportsResize(column, width, shrinkableColumn, shrinkableSize)) {\n            updateColumnWidth(shrinkableColumn, shrinkableSize);\n          } else {\n            allowedToShrink = false;\n          }\n        }\n      }\n\n      if (allowedToShrink) {\n        updateColumnWidth(column, width);\n      }\n    }\n    /**\n     * Determine if the grid supports the new proposed grid size\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} column\n     * @param {number} newWidth\n     * @param {ContentTypeCollectionInterface<Preview>} shrinkableColumn\n     * @param {number} shrinkableColumnNewWidth\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.gridSupportsResize = function gridSupportsResize(column, newWidth, shrinkableColumn, shrinkableColumnNewWidth) {\n      var _this5 = this;\n\n      // Determine the total width of all other columns in the grid, excluding the ones we plan to resize\n      var otherColumnsWidth = column.parentContentType.getChildren()().filter(function (gridColumn) {\n        return gridColumn !== column && shrinkableColumn && gridColumn !== shrinkableColumn;\n      }).map(function (otherColumn) {\n        return _this5.getColumnWidth(otherColumn);\n      }).reduce(function (a, b) {\n        return a + b;\n      }, 0); // Determine if the new total grid size will be 100%, with 1 for margin of error with rounding\n\n      return comparator(otherColumnsWidth + newWidth + (shrinkableColumnNewWidth ? shrinkableColumnNewWidth : 0), 100, 0.1);\n    };\n\n    return Resize;\n  }();\n  /**\n   * Retrieve the index of the column within it's group\n   * @deprecated use getColumnIndexInLine\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @returns {number}\n   */\n\n\n  function getColumnIndexInGroup(column) {\n    return column.parentContentType.children().indexOf(column);\n  }\n  /**\n   * Retrieve the index of the column within it's column line\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @returns {number}\n   */\n\n\n  function getColumnIndexInLine(column) {\n    return column.parentContentType.children().indexOf(column);\n  }\n  /**\n   * Retrieve the adjacent column based on a direction of +1 or -1\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} column\n   * @param {\"+1\" | \"-1\"} direction\n   * @returns {ContentTypeCollectionInterface<Preview>}\n   */\n\n\n  function getAdjacentColumn(column, direction) {\n    var currentIndex = getColumnIndexInGroup(column);\n\n    if (typeof column.parentContentType.children()[currentIndex + parseInt(direction, 10)] !== \"undefined\") {\n      return column.parentContentType.children()[currentIndex + parseInt(direction, 10)];\n    }\n\n    return null;\n  }\n  /**\n   * Determine the max ghost width based on the calculated columns\n   *\n   * @param {ColumnWidth[]} columnWidths\n   * @returns {MaxGhostWidth}\n   */\n\n\n  function determineMaxGhostWidth(columnWidths) {\n    var leftColumns = columnWidths.filter(function (width) {\n      return width.forColumn === \"left\";\n    });\n    var rightColumns = columnWidths.filter(function (width) {\n      return width.forColumn === \"right\";\n    });\n    return {\n      left: leftColumns[0].position,\n      right: rightColumns[rightColumns.length - 1].position\n    };\n  }\n  /**\n   * Return the column width to 8 decimal places if it's not a whole number\n   *\n   * @param {number} width\n   * @returns {string}\n   */\n\n\n  function getRoundedColumnWidth(width) {\n    return Number(width.toFixed(Math.round(width) !== width ? 8 : 0));\n  }\n  /**\n   * Compare if two numbers are within a certain threshold of each other\n   *\n   * comparator(10,11,2) => true\n   * comparator(1.1,1.11,0.5) => true\n   *\n   * @param {number} num1\n   * @param {number} num2\n   * @param {number} threshold\n   * @returns {boolean}\n   */\n\n\n  function comparator(num1, num2, threshold) {\n    return num1 > num2 - threshold / 2 && num1 < num2 + threshold / 2;\n  }\n  /**\n   * Update the width of a column\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @param {number} width\n   */\n\n\n  function updateColumnWidth(column, width) {\n    column.dataStore.set(\"width\", parseFloat(width.toString()) + \"%\");\n  }\n\n  return Object.assign(Resize, {\n    getColumnIndexInGroup: getColumnIndexInGroup,\n    getColumnIndexInLine: getColumnIndexInLine,\n    getAdjacentColumn: getAdjacentColumn,\n    determineMaxGhostWidth: determineMaxGhostWidth,\n    getRoundedColumnWidth: getRoundedColumnWidth,\n    comparator: comparator,\n    updateColumnWidth: updateColumnWidth\n  });\n});\n//# sourceMappingURL=resize.js.map","Magento_PageBuilder/js/content-type/column/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = (value.margin.right && parseInt(value.margin.right, 10) !== 0 ? value.margin.right : 1) + \"px\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/image/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/content-type/preview\"], function (_events, _hideShowOption, _uploader, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\");\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * Get viewport image data\n     */\n    ;\n\n    _proto.getViewportImageData = function getViewportImageData() {\n      var desktopImageData = this.data.desktop_image;\n      var mobileImageData = this.data.mobile_image;\n      return this.viewport() === \"mobile\" && typeof mobileImageData !== \"undefined\" ? mobileImageData : desktopImageData;\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"image:mountAfter\", function (args) {\n        if (args.id === _this.contentType.id) {\n          _this.isSnapshot.subscribe(function (value) {\n            _this.changeUploaderControlsVisibility();\n          });\n\n          _this.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var files = _this.contentType.dataStore.get(_this.config.additional_data.uploaderConfig.dataScope);\n\n        var imageObject = files ? files[0] : {};\n\n        _events.trigger(\"image:\" + _this.contentType.id + \":assignAfter\", imageObject);\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this2 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this2.isSnapshot();\n      });\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/utils/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/utils/object.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"object-path\"], function (_objectPath) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Retrieve a value from an object via a path\n   *\n   * @param {object} object\n   * @param {string} path\n   * @param {TResult} defaultValue\n   * @returns {TResult}\n   */\n  function get(object, path, defaultValue) {\n    return _objectPath.get(object, path, defaultValue);\n  }\n  /**\n   * Set a value within an object via a path\n   *\n   * @param {object} object\n   * @param {string} path\n   * @param {TResult} value\n   * @returns {TResult | undefined}\n   */\n\n\n  function set(object, path, value) {\n    return _objectPath.set(object, path, value);\n  }\n\n  return {\n    get: get,\n    set: set\n  };\n});\n//# sourceMappingURL=object.js.map","Magento_PageBuilder/js/utils/position-sticky.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Determine if the current browser supports position sticky\n   *\n   * @returns {boolean}\n   */\n  function supportsPositionSticky() {\n    if (!window.getComputedStyle) {\n      return false;\n    }\n\n    var testNode = document.createElement(\"div\");\n    return [\"\", \"-webkit-\", \"-moz-\", \"-ms-\"].some(function (prefix) {\n      try {\n        testNode.style.position = prefix + \"sticky\";\n      } catch (e) {// Fail silently\n      }\n\n      return testNode.style.position !== \"\";\n    });\n  }\n\n  return {\n    supportsPositionSticky: supportsPositionSticky\n  };\n});\n//# sourceMappingURL=position-sticky.js.map","Magento_PageBuilder/js/utils/array.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Move an array item within the current array\n   *\n   * @param array\n   * @param fromIndex\n   * @param toIndex\n   * @returns {Array<any>}\n   */\n  function moveArrayItem(array, fromIndex, toIndex) {\n    array.splice(toIndex, 0, array.splice(fromIndex, 1)[0]);\n    return array;\n  }\n  /**\n   * Move an array item from one array into another\n   *\n   * @param item\n   * @param array\n   * @param toIndex\n   * @returns {Array<any>}\n   */\n\n\n  function moveArrayItemIntoArray(item, array, toIndex) {\n    array.splice(toIndex, 0, item);\n    return array;\n  }\n  /**\n   * Remove an array item\n   *\n   * @param array\n   * @param item\n   * @returns {Array<any>}\n   */\n\n\n  function removeArrayItem(array, item) {\n    var index = array.indexOf(item);\n\n    if (index > -1) {\n      array.splice(index, 1);\n    }\n\n    return array;\n  }\n  /**\n   * Search outwards from an array item until a callback matches\n   *\n   * @author https://github.com/thejameskyle/outward-search\n   *\n   * @param {any[]} items\n   * @param {number} start\n   * @param {(item: any, index: number) => boolean} callback\n   * @returns {any}\n   * @api\n   */\n\n\n  function outwardSearch(items, start, callback) {\n    if (!items.length) {\n      return null;\n    }\n\n    if (start < 0 || start > items.length - 1) {\n      throw new TypeError(\"starting index must be within bounds of array\");\n    }\n\n    var max = items.length - 1;\n    var low = start;\n    var high = start + 1;\n\n    while (true) {\n      var hitMin = low < 0;\n      var hitMax = high > max;\n\n      if (hitMin && hitMax) {\n        break;\n      }\n\n      if (!hitMin) {\n        var _item = items[low];\n        var result = callback(_item, low);\n\n        if (!!result) {\n          return _item;\n        }\n\n        low--;\n      }\n\n      if (!hitMax) {\n        var _item2 = items[high];\n\n        var _result = callback(_item2, high);\n\n        if (!!_result) {\n          return _item2;\n        }\n\n        high++;\n      }\n    }\n\n    return null;\n  }\n\n  return {\n    moveArrayItem: moveArrayItem,\n    moveArrayItemIntoArray: moveArrayItemIntoArray,\n    removeArrayItem: removeArrayItem,\n    outwardSearch: outwardSearch\n  };\n});\n//# sourceMappingURL=array.js.map","Magento_PageBuilder/js/utils/breakpoints.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        /**\n         * Build media query.\n         *\n         * @param {Object} conditions\n         * @returns {String}\n         */\n        buildMedia: function (conditions) {\n            var result = _.map(_.pairs(conditions), function (condition) {\n                return '(' + condition.join(': ') + ')';\n            });\n\n            return result.join(' and ');\n        }\n    };\n});\n","Magento_PageBuilder/js/utils/directives.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * MIME type to use in place of the image\n   *\n   * @type {string}\n   */\n  var mimeType = \"text/magento-directive\";\n  /**\n   * Determine if a URL is a directive of our type\n   *\n   * @param {string} url\n   * @returns {boolean}\n   * @api\n   */\n\n  function isDirectiveDataUrl(url) {\n    return url.indexOf(\"data:\" + mimeType) === 0;\n  }\n  /**\n   * Convert a directive into our data URI\n   *\n   * @param {string} directive\n   * @returns {string}\n   * @api\n   */\n\n\n  function toDataUrl(directive) {\n    return \"data:\" + mimeType + \",\" + encodeURIComponent(directive);\n  }\n  /**\n   * Convert a URI to it's directive equivalent\n   *\n   * @param {string} url\n   * @returns {string}\n   * @api\n   */\n\n\n  function fromDataUrl(url) {\n    if (!isDirectiveDataUrl(url)) {\n      throw Error(url + \" is not a magento directive data url\");\n    }\n\n    return decodeURIComponent(url.split(mimeType + \",\")[1]);\n  }\n  /**\n   * Decode all data URIs present in a string\n   *\n   * @param {string} str\n   * @returns {string}\n   * @api\n   */\n\n\n  function decodeAllDataUrlsInString(str) {\n    return str.replace(new RegExp(\"url\\\\s*\\\\(\\\\s*(?:&quot;|\\'|\\\")?(data:\" + mimeType + \",.+?)(?:&quot;|\\'|\\\")?\\\\s*\\\\)\", \"g\"), function (match, url) {\n      return \"url(\\'\" + fromDataUrl(url) + \"\\')\";\n    });\n  }\n  /**\n   * Retrieve the image URL with directive\n   *\n   * @param {Array} image\n   * @returns {string}\n   * @api\n   */\n\n\n  function getImageUrl(image) {\n    var imageUrl = image[0].url;\n    var mediaPath = imageUrl.split(_config.getConfig(\"media_url\"));\n    return \"{{media url=\" + mediaPath[1] + \"}}\";\n  }\n  /**\n   * Remove quotes in media directives, {{media url=\"wysiwyg/image.png\"}} convert to {{media url=wysiwyg/image.png}}\n   *\n   * @param {string} html\n   * @returns {string}\n   * @api\n   */\n\n\n  function removeQuotesInMediaDirectives(html) {\n    if (!html) {\n      return \"\";\n    }\n\n    var mediaDirectiveRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(.*?)\\s*\\}\\}/g;\n    var urlRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(.*)\\s*\\}\\}/;\n    var mediaDirectiveMatches = html.match(mediaDirectiveRegExp);\n\n    if (mediaDirectiveMatches) {\n      mediaDirectiveMatches.forEach(function (mediaDirective) {\n        var urlMatches = mediaDirective.match(urlRegExp);\n\n        if (urlMatches && urlMatches[1] !== undefined) {\n          var directiveWithOutQuotes = \"{{media url=\" + urlMatches[1].replace(/(\"|&quot;|\\s)/g, \"\") + \"}}\";\n          html = html.replace(mediaDirective, directiveWithOutQuotes);\n        }\n      });\n    }\n\n    return html;\n  }\n  /**\n   * Replace media directives with actual media URLs\n   *\n   * @param {string} html\n   * @returns {string}\n   * @api\n   */\n\n\n  function convertMediaDirectivesToUrls(html) {\n    if (!html) {\n      return \"\";\n    }\n\n    var mediaDirectiveRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*\"?[^\"\\s\\}]+\"?\\s*\\}\\}/g;\n    var mediaDirectiveMatches = html.match(mediaDirectiveRegExp);\n\n    if (mediaDirectiveMatches) {\n      mediaDirectiveMatches.forEach(function (mediaDirective) {\n        var urlRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(?:\"|&quot;)?(.+)(?=}})\\s*\\}\\}/;\n        var urlMatches = mediaDirective.match(urlRegExp);\n\n        if (urlMatches && typeof urlMatches[1] !== \"undefined\") {\n          html = html.replace(mediaDirective, _config.getConfig(\"media_url\") + urlMatches[1].replace(/\"$/, \"\").replace(/&quot;$/, \"\"));\n        }\n      });\n    }\n\n    return html;\n  }\n  /**\n   * Replace data-src attribute with src.\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n\n\n  function replaceWithSrc(html) {\n    return html.replace(new RegExp(\"data-tmp-src=\\\"\\{\\{\", \"g\"), \"src=\\\"{{\");\n  }\n  /**\n   * Replace src attribute with data-tmp-src.\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n\n\n  function replaceWithDataSrc(html) {\n    return html.replace(new RegExp(\"src=\\\"\\{\\{\", \"g\"), \"data-tmp-src=\\\"{{\");\n  }\n\n  return Object.assign(decodeAllDataUrlsInString, {\n    toDataUrl: toDataUrl,\n    fromDataUrl: fromDataUrl,\n    getImageUrl: getImageUrl,\n    removeQuotesInMediaDirectives: removeQuotesInMediaDirectives,\n    convertMediaDirectivesToUrls: convertMediaDirectivesToUrls,\n    replaceWithSrc: replaceWithSrc,\n    replaceWithDataSrc: replaceWithDataSrc\n  });\n});\n//# sourceMappingURL=directives.js.map","Magento_PageBuilder/js/utils/check-stage-full-screen.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Check if stage full screen mode is active\n   *\n   * @param {string} stageId\n   * @returns {boolean}\n   */\n  function checkStageFullScreen(stageId) {\n    var $stage = (0, _jquery)(\"#\" + stageId);\n    var $fullScreenStageWrapper = $stage.closest(\".stage-full-screen\");\n    return !!$fullScreenStageWrapper.length;\n  }\n\n  return checkStageFullScreen;\n});\n//# sourceMappingURL=check-stage-full-screen.js.map","Magento_PageBuilder/js/utils/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * googleMaps dependency is added within googlemaps.phtml through shim based on API key being set\n *\n * @api\n */\ndefine([\n    'underscore',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (_, module, events) {\n    'use strict';\n\n    var google = window.google || {},\n\n        /**\n         * Generates a google map usable latitude and longitude object\n         *\n         * @param {Object} position\n         * @return {google.maps.LatLng}\n         */\n        getGoogleLatitudeLongitude = function (position) {\n            return new google.maps.LatLng(position.latitude, position.longitude);\n        },\n        gmAuthFailure = false;\n\n    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n    /**\n     * Google's error listener for map loader failures\n     */\n    window.gm_authFailure = function () {\n        events.trigger('googleMaps:authFailure');\n        gmAuthFailure = true;\n    };\n    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n    return function (element, markers, additionalOptions) {\n        var options,\n            style;\n\n        // If we've previously had an API key error, throw the error even again\n        if (gmAuthFailure) {\n            events.trigger('googleMaps:authFailure');\n\n            return;\n        }\n\n        // If Google Maps isn't loaded don't try init the map, it won't work\n        if (typeof google.maps === 'undefined') {\n            return;\n        }\n\n        /**\n         * Just in case of a bad JSON that bypassed validation\n         */\n        try {\n            style = module.config().style ? JSON.parse(module.config().style) : [];\n        }\n        catch (error) {\n            style = [];\n        }\n        options = _.extend({\n            zoom: 8,\n            center: getGoogleLatitudeLongitude({\n                latitude: 30.2672,\n                longitude: -97.7431\n            }),\n            scrollwheel: false,\n            disableDoubleClickZoom: false,\n            disableDefaultUI: false,\n            mapTypeControl: true,\n            mapTypeControlOptions: {\n                style: google.maps.MapTypeControlStyle.DEFAULT\n            },\n            styles: style\n        }, additionalOptions);\n\n        /* Create the map */\n        this.map = new google.maps.Map(element, options);\n        this.markers = [];\n\n        /**\n         * Callback function on map config update\n         * @param {Array} newMarkers\n         * @param {Object} updateOptions\n         */\n        this.onUpdate = function (newMarkers, updateOptions) {\n            this.map.setOptions(updateOptions);\n            this.setMarkers(newMarkers);\n        };\n\n        /**\n         * Sets the markers to selected map\n         * @param {Object} newMarkers\n         */\n        this.setMarkers = function (newMarkers) {\n            var activeInfoWindow,\n                latitudeLongitudeBounds = new google.maps.LatLngBounds();\n\n            this.markers.forEach(function (marker) {\n                marker.setMap(null);\n            }, this);\n\n            this.markers = [];\n            this.bounds = [];\n\n            /**\n             * Creates and set listener for markers\n             */\n            if (newMarkers && newMarkers.length) {\n                newMarkers.forEach(function (newMarker) {\n                    var location = _.escape(newMarker['location_name']) || '',\n                    comment = newMarker.comment ?\n                        '<p>' + _.escape(newMarker.comment).replace(/(?:\\r\\n|\\r|\\n)/g, '<br/>') + '</p>'\n                        : '',\n                    phone = newMarker.phone ? '<p>Phone: ' + _.escape(newMarker.phone) + '</p>' : '',\n                    address = newMarker.address ? _.escape(newMarker.address) + '<br/>' : '',\n                    city = _.escape(newMarker.city) || '',\n                    country = newMarker.country ? _.escape(newMarker.country) : '',\n                    state = newMarker.state ? _.escape(newMarker.state) + ' ' : '',\n                    zipCode = newMarker.zipcode ? _.escape(newMarker.zipcode) : '',\n                    cityComma = city !== '' && (zipCode !== '' || state !== '') ? ', ' : '',\n                    lineBreak = city !== '' || zipCode !== '' ? '<br/>' : '',\n                    contentString =\n                        '<div>' +\n                        '<h3><b>' + location + '</b></h3>' +\n                        comment +\n                        phone +\n                        '<p><span>' + address +\n                        city + cityComma + state + zipCode + lineBreak +\n                        country + '</span></p>' +\n                        '</div>',\n                    infowindow = new google.maps.InfoWindow({\n                        content: contentString,\n                        maxWidth: 350\n                    }),\n                    newCreatedMarker = new google.maps.Marker({\n                        map: this.map,\n                        position: getGoogleLatitudeLongitude(newMarker.position),\n                        title: location\n                    });\n\n                    if (location) {\n                        newCreatedMarker.addListener('click', function () {\n                            if (activeInfoWindow) {\n                                activeInfoWindow.close();\n                            }\n\n                            infowindow.open(this.map, newCreatedMarker);\n                            activeInfoWindow = infowindow;\n                        }, this);\n                    }\n\n                    this.markers.push(newCreatedMarker);\n                    this.bounds.push(getGoogleLatitudeLongitude(newMarker.position));\n                }, this);\n            }\n\n            /**\n             * This sets the bounds of the map for multiple locations\n             */\n            if (this.bounds.length > 1) {\n                this.bounds.forEach(function (bound) {\n                    latitudeLongitudeBounds.extend(bound);\n                });\n                this.map.fitBounds(latitudeLongitudeBounds);\n            }\n\n            /**\n             * Zoom to 8 if there is only a single location\n             */\n            if (this.bounds.length === 1) {\n                this.map.setCenter(this.bounds[0]);\n                this.map.setZoom(8);\n            }\n        };\n\n        this.setMarkers(markers);\n    };\n});\n","Magento_PageBuilder/js/utils/string.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Convert from snake case to camel case\n   *\n   * @param {string} currentString\n   * @returns {string}\n   * @api\n   */\n  function fromSnakeToCamelCase(currentString) {\n    var parts = currentString.split(/[_-]/);\n    var newString = \"\";\n\n    for (var i = 1; i < parts.length; i++) {\n      newString += parts[i].charAt(0).toUpperCase() + parts[i].slice(1);\n    }\n\n    return parts[0] + newString;\n  }\n  /**\n   * Convert a camel case string to snake case\n   *\n   * @param currentString\n   */\n\n\n  function fromCamelCaseToDash(currentString) {\n    return currentString.replace(/[A-Z]/g, function (m) {\n      return \"-\" + m.toLowerCase();\n    });\n  }\n\n  return {\n    fromSnakeToCamelCase: fromSnakeToCamelCase,\n    fromCamelCaseToDash: fromCamelCaseToDash\n  };\n});\n//# sourceMappingURL=string.js.map","Magento_PageBuilder/js/utils/nesting-link-dialog.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/modal/dismissible-confirm\"], function (_jquery, _translate, _dismissibleConfirm) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate inline editor for having nested link\n   * Creates a dialog and removes inline editor link if present\n   *\n   * @param {DataStore} dataStore\n   * @param {WysiwygInterface} wysiwyg\n   * @param {string} inlineMessageField\n   * @param {string} linkUrlField\n   */\n  function nestingLinkDialog(dataStore, wysiwyg, inlineMessageField, linkUrlField) {\n    var dataStoreContent = dataStore.getState();\n    var inlineMessage = dataStoreContent[inlineMessageField];\n    var linkUrl = dataStoreContent[linkUrlField];\n    var aLinkRegex = /(<a[\\s]+[^>]+).+(?=<\\/a>)<\\/a>/igm;\n\n    if (wysiwyg && inlineMessage.match(aLinkRegex) && linkUrl && [\"page\", \"product\", \"category\", \"default\"].indexOf(linkUrl.type) !== -1 && linkUrl[linkUrl.type] && linkUrl[linkUrl.type].length !== 0) {\n      var inlineEditor = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      inlineEditor.trigger(\"blur\");\n      (0, _dismissibleConfirm)({\n        actions: {\n          always: function always() {\n            var anchorLessDataStoreMessage = inlineMessage.replace(aLinkRegex, \"\");\n            var anchorLessInlineMessage = inlineEditor.html().replace(aLinkRegex, \"\");\n            dataStore.set(inlineMessageField, anchorLessDataStoreMessage);\n            inlineEditor.html(anchorLessInlineMessage);\n          }\n        },\n        content: (0, _translate)(\"We are unable to support links within the content field whilst having a link set on the content type. Please remove the content type link if you'd like to set a link within the content. We will automatically remove the links within the content field.\"),\n        // tslint:disable-line:max-line-length\n        title: (0, _translate)(\"Nested links are not allowed\"),\n        haveCancelButton: false\n      });\n    }\n  }\n\n  return nestingLinkDialog;\n});\n//# sourceMappingURL=nesting-link-dialog.js.map","Magento_PageBuilder/js/utils/loader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  function load(dependencies, factory, onError) {\n    require(dependencies, factory, onError);\n  }\n\n  return load;\n});\n//# sourceMappingURL=loader.js.map","Magento_PageBuilder/js/utils/url.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Check for whether url string contains only a path\n   *\n   * @param {String} url\n   * @returns {Boolean}\n   */\n  function isPathOnly(url) {\n    return url.indexOf(\"/\") === 0;\n  }\n  /**\n   * Get the path from a URL\n   *\n   * @param {String} url\n   * @returns {String}\n   */\n\n\n  function getPathFromUrl(url) {\n    var a = document.createElement(\"a\");\n    a.href = url;\n    return a.pathname;\n  }\n  /**\n   * Convert url to path if other url is only a path\n   *\n   * @param {string} url\n   * @param {string} otherUrl\n   * @returns {string}\n   * @api\n   */\n\n\n  function convertUrlToPathIfOtherUrlIsOnlyAPath(url, otherUrl) {\n    return isPathOnly(otherUrl) ? getPathFromUrl(url) : url;\n  }\n\n  return {\n    convertUrlToPathIfOtherUrlIsOnlyAPath: convertUrlToPathIfOtherUrlIsOnlyAPath\n  };\n});\n//# sourceMappingURL=url.js.map","Magento_PageBuilder/js/utils/create-stylesheet.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a stylesheet DOM object from a style block declaration\n   *\n   * @param {StyleBlocks} blocks\n   * @returns {HTMLStyleElement}\n   * @api\n   */\n  function createStyleSheet(blocks) {\n    var style = document.createElement(\"style\");\n    var text = Object.keys(blocks).map(function (selector) {\n      return selector + (\" {\\n\" + processDeclarationBlock(blocks[selector]) + \"\\n}\");\n    }).join(\"\\n\");\n    style.setAttribute(\"type\", \"text/css\");\n    style.appendChild(document.createTextNode(text));\n    return style;\n  }\n  /**\n   * Process a declaration block from the rule set\n   *\n   * @param {StyleBlock} block\n   * @returns {string}\n   */\n\n\n  function processDeclarationBlock(block) {\n    return Object.keys(block).map(function (property) {\n      return processDeclaration(property, block[property]);\n    }).join(\"\\n\");\n  }\n  /**\n   * Process a declaration, creating the property: value syntax\n   *\n   * @param {string} property\n   * @param {string | number} value\n   * @returns {string}\n   */\n\n\n  function processDeclaration(property, value) {\n    return hyphenate(property) + (\": \" + value + \";\");\n  }\n  /**\n   * Hyphenate style property, from textAlign to text-align\n   *\n   * @param {string} property\n   * @returns {string}\n   */\n\n\n  function hyphenate(property) {\n    return property.replace(/[A-Z]/g, function (match) {\n      return \"-\" + match.toLowerCase();\n    });\n  }\n\n  return {\n    createStyleSheet: createStyleSheet\n  };\n});\n//# sourceMappingURL=create-stylesheet.js.map","Magento_PageBuilder/js/utils/image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/url\"], function (_config, _directives, _url) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Decode image background URL to object\n   *\n   * @param value\n   * @returns {Object}\n   * @api\n   */\n  function decodeUrl(value) {\n    var result = \"\";\n    value = decodeURIComponent(value.replace(window.location.href, \"\"));\n    var regexp = /{{.*\\s*url=\"?(.*\\.([a-z|A-Z]*))\"?\\s*}}/;\n\n    if (regexp.test(value)) {\n      var _regexp$exec = regexp.exec(value),\n          url = _regexp$exec[1],\n          type = _regexp$exec[2];\n\n      var image = {\n        name: url.split(\"/\").pop(),\n        size: 0,\n        type: \"image/\" + type,\n        url: _config.getConfig(\"media_url\") + url\n      };\n      result = [image];\n    }\n\n    return result;\n  }\n  /**\n   * Convert a URL to an image directive\n   *\n   * @param {string} imageUrl\n   * @returns {string}\n   */\n\n\n  function urlToDirective(imageUrl) {\n    var mediaUrl = (0, _url.convertUrlToPathIfOtherUrlIsOnlyAPath)(_config.getConfig(\"media_url\"), imageUrl);\n    var mediaPath = imageUrl.split(mediaUrl);\n    return \"{{media url=\" + mediaPath[1] + \"}}\";\n  }\n  /**\n   * Convert an image URL to a background image data uri\n   *\n   * @param {string} imageUrl\n   * @returns {string}\n   */\n\n\n  function imageToBackgroundImageDataUrl(imageUrl) {\n    return \"url(\\'\" + (0, _directives.toDataUrl)(urlToDirective(imageUrl)) + \"\\')\";\n  }\n\n  return {\n    decodeUrl: decodeUrl,\n    urlToDirective: urlToDirective,\n    imageToBackgroundImageDataUrl: imageToBackgroundImageDataUrl\n  };\n});\n//# sourceMappingURL=image.js.map","Magento_PageBuilder/js/utils/nesting-widget-dialog.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/modal/dismissible-confirm\"], function (_jquery, _translate, _dismissibleConfirm) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate inline editor for having nested widget\n   * Creates a dialog and removes inline editor widget if present\n   *\n   * @param {DataStore} dataStore\n   * @param {WysiwygInterface} wysiwyg\n   * @param {string} inlineMessageField\n   * @param {string} linkUrlField\n   */\n  function nestingWidgetDialog(dataStore, wysiwyg, inlineMessageField, linkUrlField) {\n    var dataStoreContent = dataStore.getState();\n    var inlineMessage = dataStoreContent[inlineMessageField];\n    var linkUrl = dataStoreContent[linkUrlField];\n    var widgetRegex = /\\{\\{widget([\\S\\s]*?)\\}\\}/ig;\n    var widgetPlaceholderRegex = /<span.*(class=)(\\\"|\\').*((magento-placeholder).*(magento-widget)|(magento-widget).*(magento-placeholder)).*<\\/span>/igm;\n\n    if (wysiwyg && inlineMessage.match(widgetRegex) && linkUrl && [\"page\", \"product\", \"category\", \"default\"].indexOf(linkUrl.type) !== -1 && linkUrl[linkUrl.type] && linkUrl[linkUrl.type].length !== 0) {\n      var inlineEditor = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      inlineEditor.trigger(\"blur\");\n      (0, _dismissibleConfirm)({\n        actions: {\n          always: function always() {\n            var widgetLessDataStoreMessage = inlineMessage.replace(widgetRegex, \"\");\n            var widgetLessInlineMessage = inlineEditor.html().replace(widgetPlaceholderRegex, \"\");\n            dataStore.set(inlineMessageField, widgetLessDataStoreMessage);\n            inlineEditor.html(widgetLessInlineMessage);\n          }\n        },\n        content: (0, _translate)(\"We are unable to support widget within the content field whilst having a link set on the content type. Please remove the content type link if you'd like to set a widget within the content. We will automatically remove the widget within the content field.\"),\n        // tslint:disable-line:max-line-length\n        title: (0, _translate)(\"Nested widgets are not allowed\"),\n        haveCancelButton: false\n      });\n    }\n  }\n\n  return nestingWidgetDialog;\n});\n//# sourceMappingURL=nesting-widget-dialog.js.map","Magento_PageBuilder/js/utils/delay-until.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Delay until a condition is met\n   *\n   * @param {() => void} callback\n   * @param {() => boolean} condition\n   * @param {number} interval\n   */\n  function delayUntil(callback, condition, interval) {\n    if (interval === void 0) {\n      interval = 50;\n    }\n\n    var delayInterval = setInterval(function () {\n      if (condition()) {\n        clearInterval(delayInterval);\n        callback();\n      }\n    }, interval);\n  }\n\n  return delayUntil;\n});\n//# sourceMappingURL=delay-until.js.map","Magento_PageBuilder/js/utils/promise-deferred.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Returns a deferred promise\n   *\n   * @returns {DeferredInterface}\n   * @api\n   */\n  function deferred() {\n    var resolve;\n    var reject;\n    var promise = new Promise(function (promiseResolve, promiseReject) {\n      resolve = promiseResolve;\n      reject = promiseReject;\n    });\n    return {\n      resolve: resolve,\n      reject: reject,\n      promise: promise\n    };\n  }\n\n  return deferred;\n});\n//# sourceMappingURL=promise-deferred.js.map","Magento_PageBuilder/js/utils/pagebuilder-header-height.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Checks if PageBuilder has header and returns it's height\n   *\n   * @param {string} stageId\n   * @param {string} stageWrapper\n   * @param {string} pageBuilderHeader\n   * @returns {number}\n   */\n  function pageBuilderHeaderHeight(stageId, stageWrapper, pageBuilderHeader) {\n    if (stageWrapper === void 0) {\n      stageWrapper = \".pagebuilder-stage-wrapper\";\n    }\n\n    if (pageBuilderHeader === void 0) {\n      pageBuilderHeader = \".pagebuilder-header\";\n    }\n\n    var $stageWrapper = (0, _jquery)(\"#\" + stageId).closest(stageWrapper);\n    var $pageBuilderHeader = $stageWrapper.find(pageBuilderHeader);\n    return !!$pageBuilderHeader.length ? $pageBuilderHeader.height() : 0;\n  }\n\n  return pageBuilderHeaderHeight;\n});\n//# sourceMappingURL=pagebuilder-header-height.js.map","Magento_PageBuilder/js/utils/editor.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/tools\", \"mage/translate\", \"mageUtils\", \"Magento_PageBuilder/js/config\"], function (_jquery, _tools, _translate, _mageUtils, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Is the inline WYSIWYG supported?\n   */\n  function isWysiwygSupported() {\n    return _config.getConfig(\"can_use_inline_editing_on_stage\");\n  }\n  /**\n   * Encode content for TinyMCE\n   *\n   * @param content\n   */\n\n\n  function encodeContent(content) {\n    if (isWysiwygSupported()) {\n      return convertVariablesToHtmlPreview(convertWidgetsToHtmlPreview(unescapeDoubleQuoteWithinWidgetDirective(removeInvalidPlaceholders(content))));\n    }\n\n    return content;\n  }\n  /**\n   * Prior to parsing the content remove any invalid placeholders within the content\n   *\n   * @param content\n   */\n\n\n  function removeInvalidPlaceholders(content) {\n    if (content.indexOf(\"magento-placeholder\") !== -1) {\n      var html = new DOMParser().parseFromString(content, \"text/html\");\n      var placeholders = html.querySelectorAll(\"span.magento-placeholder\");\n\n      if (placeholders.length > 0) {\n        [].slice.call(placeholders).forEach(function (placeholder) {\n          // If the invalid placeholder contains a directive, let's insert it back where it belongs\n          if (placeholder.innerText.indexOf(\"{{\") !== -1) {\n            placeholder.parentNode.insertBefore(document.createTextNode(placeholder.innerText), placeholder);\n          }\n\n          placeholder.remove();\n        });\n      }\n\n      return html.body.innerHTML;\n    }\n\n    return content;\n  }\n  /**\n   * Convert all variables to their HTML preview counterparts\n   *\n   * Re-implements logic from lib/web/mage/adminhtml/wysiwyg/tiny_mce/plugins/magentovariable/editor_plugin.js to parse\n   * and replace the variables within the content.\n   *\n   * @param content\n   */\n\n\n  function convertVariablesToHtmlPreview(content) {\n    var config = _config.getConfig(\"tinymce\").variables;\n\n    var magentoVariables = JSON.parse(config.placeholders);\n    return content.replace(/{\\{\\s?(?:customVar code=|config path=\\\")([^\\}\\\"]+)[\\\"]?\\s?\\}\\}/ig, function (match, path) {\n      var id = btoa(path).replace(/\\+/g, \":\").replace(/\\//g, \"_\").replace(/=/g, \"-\");\n      var placeholder = (0, _jquery)(\"<span />\").addClass(\"magento-variable\").addClass(\"magento-placeholder\").addClass(\"mceNonEditable\").prop(\"id\", id).prop(\"contentEditable\", \"false\");\n\n      if (magentoVariables[path].variable_type === \"custom\") {\n        placeholder.addClass(\"magento-custom-var\");\n      }\n\n      var variableType = magentoVariables[path].variable_type;\n\n      if (magentoVariables[path] && (variableType === \"default\" || variableType === \"custom\")) {\n        placeholder.text(magentoVariables[path].variable_name);\n      } else {\n        // If we're unable to find the placeholder we need to attach an error class\n        placeholder.addClass(\"magento-placeholder-error\");\n        placeholder.text(variableType === \"custom\" ? path : (0, _translate)(\"Not Found\"));\n      }\n\n      return placeholder[0].outerHTML;\n    });\n  }\n  /**\n   * Convert widgets within content to their HTML counterparts\n   *\n   * @param content\n   */\n\n\n  function convertWidgetsToHtmlPreview(content) {\n    var config = _config.getConfig(\"tinymce\").widgets;\n\n    return content.replace(/\\{\\{widget([\\S\\s]*?)\\}\\}/ig, function (match, widgetBody) {\n      var attributes = parseAttributesString(widgetBody);\n      var imageSrc;\n\n      if (attributes.type) {\n        var placeholder = (0, _jquery)(\"<span />\").addClass(\"magento-placeholder\").addClass(\"magento-widget\").addClass(\"mceNonEditable\").prop(\"id\", _mageUtils.uniqueid()).prop(\"contentEditable\", \"false\");\n        attributes.type = attributes.type.replace(/\\\\\\\\/g, \"\\\\\");\n        imageSrc = config.placeholders[attributes.type];\n\n        if (!imageSrc) {\n          imageSrc = config.error_image_url;\n          placeholder.addClass(\"magento-placeholder-error\");\n        }\n\n        var image = (0, _jquery)(\"<img />\").prop(\"id\", window.Base64.idEncode(match)).prop(\"src\", imageSrc);\n        placeholder.append(image);\n        var widgetType = \"\";\n\n        if (config.types[attributes.type]) {\n          widgetType += config.types[attributes.type];\n        }\n\n        placeholder.append((0, _jquery)(document.createTextNode(widgetType)));\n        return placeholder[0].outerHTML;\n      }\n    });\n  }\n  /**\n   * Parse attributes into a string\n   *\n   * @param attributes\n   */\n\n\n  function parseAttributesString(attributes) {\n    var result = {};\n    attributes.replace(/(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/g, function (match, key, value) {\n      result[key] = value ? value.replace(/&quote;/g, \"\\\"\") : value;\n      return \"\";\n    });\n    return result;\n  }\n  /**\n   * Lock all image sizes before initializing TinyMCE to avoid content jumps\n   *\n   * @param element\n   */\n\n\n  function lockImageSize(element) {\n    [].slice.call(element.querySelectorAll(\"img\")).forEach(function (image) {\n      if (image.style.width.length === 0) {\n        image.style.width = /^\\d+$/.test(image.getAttribute(\"width\")) ? image.getAttribute(\"width\") + \"px\" : image.getAttribute(\"width\");\n        image.setAttribute(\"data-width-locked\", \"true\");\n      }\n\n      if (image.style.height.length === 0) {\n        image.style.height = /^\\d+$/.test(image.getAttribute(\"height\")) ? image.getAttribute(\"height\") + \"px\" : image.getAttribute(\"height\");\n        image.setAttribute(\"data-height-locked\", \"true\");\n      }\n    });\n  }\n  /**\n   * Reverse forced image size after TinyMCE is finished initializing\n   *\n   * @param element\n   */\n\n\n  function unlockImageSize(element) {\n    [].slice.call(element.querySelectorAll(\"img\")).forEach(function (image) {\n      if (image.getAttribute(\"data-width-locked\")) {\n        image.style.width = null;\n        image.removeAttribute(\"data-width-locked\");\n      }\n\n      if (image.getAttribute(\"data-height-locked\")) {\n        image.style.height = null;\n        image.removeAttribute(\"data-height-locked\");\n      }\n    });\n  }\n  /**\n   * Create a bookmark within the content to be restored later\n   */\n\n\n  function createBookmark(event) {\n    var wrapperElement = (0, _jquery)(event.target).parents(\".inline-wysiwyg\");\n    /**\n     * Create an element bookmark\n     *\n     * @param element\n     */\n\n    var createElementBookmark = function createElementBookmark(element) {\n      return {\n        name: element.nodeName,\n        index: findNodeIndex(wrapperElement[0], element.nodeName, element)\n      };\n    }; // Handle direct clicks onto an IMG\n\n\n    if (event.target.nodeName === \"IMG\") {\n      return createElementBookmark(event.target);\n    }\n\n    if (window.getSelection) {\n      var selection = window.getSelection();\n\n      var id = _mageUtils.uniqueid();\n\n      if (selection.getRangeAt && selection.rangeCount) {\n        var range = normalizeTableCellSelection(selection.getRangeAt(0).cloneRange()); // Determine if the current node is an image or span that we want to select instead of text\n\n        var currentNode = range.startContainer;\n\n        if (currentNode.nodeType === Node.ELEMENT_NODE && (currentNode.nodeName === \"IMG\" || currentNode.nodeName === \"SPAN\" && currentNode.classList.contains(\"magento-placeholder\"))) {\n          return createElementBookmark(currentNode);\n        } // Also check if the direct parent is either of these\n\n\n        var parentNode = range.startContainer.parentNode;\n\n        if (parentNode.nodeName === \"IMG\" || parentNode.nodeName === \"SPAN\" && parentNode.classList.contains(\"magento-placeholder\")) {\n          return createElementBookmark(parentNode);\n        }\n\n        if (!range.collapsed) {\n          range.collapse(false);\n          var endBookmarkNode = createBookmarkSpan(id + \"_end\");\n          range.insertNode(endBookmarkNode);\n        }\n\n        var range2 = normalizeTableCellSelection(selection.getRangeAt(0));\n        range2.collapse(true);\n        var startBookmarkNode = createBookmarkSpan(id + \"_start\");\n        range2.insertNode(startBookmarkNode);\n        return {\n          id: id\n        };\n      }\n    }\n\n    return null;\n  }\n  /**\n   * Move the cursor to our new bookmark\n   *\n   * @param bookmark\n   */\n\n\n  function moveToBookmark(bookmark) {\n    window.tinymce.activeEditor.selection.moveToBookmark(bookmark);\n  }\n  /**\n   * Retrieve active editor from TinyMCE\n   */\n\n\n  function getActiveEditor() {\n    return window.tinymce.activeEditor;\n  }\n  /**\n   * Create a bookmark span for the selection\n   *\n   * @param id\n   */\n\n\n  function createBookmarkSpan(id) {\n    var bookmark = document.createElement(\"span\");\n    bookmark.setAttribute(\"data-mce-type\", \"bookmark\");\n    bookmark.id = id;\n    bookmark.style.overflow = \"hidden\";\n    bookmark.style.lineHeight = \"0px\";\n    return bookmark;\n  }\n  /**\n   * Find the index of an element within a wrapper\n   *\n   * @param wrapperElement\n   * @param name\n   * @param element\n   */\n\n\n  function findNodeIndex(wrapperElement, name, element) {\n    var selector = name.toLowerCase() + ':not([data-mce-bogus=\"all\"])'; // If there is no ID on the element add a unique ID so we can efficiently find it\n\n    if (!element.id) {\n      element.id = _mageUtils.uniqueid();\n    }\n\n    return (0, _jquery)(wrapperElement).find(selector).toArray().findIndex(function (node) {\n      return node.id === element.id;\n    });\n  }\n  /**\n   * Get a node by index within a wrapper\n   *\n   * @param wrapperElement\n   * @param name\n   * @param index\n   */\n\n\n  function getNodeByIndex(wrapperElement, name, index) {\n    var selector = name.toLowerCase() + ':not([data-mce-bogus=\"all\"])';\n    return (0, _jquery)(wrapperElement).find(selector).get(index);\n  }\n  /**\n   * Create a double click event that works in all browsers\n   */\n\n\n  function createDoubleClickEvent() {\n    try {\n      return new MouseEvent(\"dblclick\", {\n        view: window,\n        bubbles: true,\n        cancelable: true\n      });\n    } catch (e) {\n      var dblClickEvent = document.createEvent(\"MouseEvent\");\n      dblClickEvent.initMouseEvent(\"dblclick\", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n      return dblClickEvent;\n    }\n  }\n  /**\n   * Replace all desktop styles that left unprocessed back to style element to prevent data corruption.\n   */\n\n\n  function processInlineStyles(html) {\n    var name = _config.getConfig(\"defaultViewport\");\n\n    var searchPattern = new RegExp(\"data-\" + name + \"-style=\", \"g\");\n    return html.replace(searchPattern, \"style=\");\n  }\n  /**\n   * Move the end point of a range to handle tables\n   *\n   * @param range\n   * @param start\n   */\n\n\n  function moveEndPoint(range, start) {\n    var container;\n    var offset;\n    var childNodes;\n\n    if (start) {\n      container = range.startContainer;\n      offset = range.startOffset;\n    } else {\n      container = range.endContainer;\n      offset = range.endOffset;\n    }\n\n    if (container.nodeType === Node.ELEMENT_NODE && container.nodeName === \"TR\") {\n      childNodes = container.childNodes;\n      container = childNodes[Math.min(start ? offset : offset - 1, childNodes.length - 1)];\n\n      if (container) {\n        offset = start ? 0 : container.childNodes.length;\n\n        if (start) {\n          range.setStart(container, offset);\n        } else {\n          range.setEnd(container, offset);\n        }\n      }\n    }\n  }\n  /**\n   * Normalize the table sell selection within a range to better handle selections being inside of tables\n   *\n   * @param range\n   */\n\n\n  function normalizeTableCellSelection(range) {\n    moveEndPoint(range, true);\n    moveEndPoint(range, false);\n    return range;\n  }\n  /**\n   * Convert HTML encoded double quote to double quote with backslash within widget directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function escapeDoubleQuoteWithinWidgetDirective(content) {\n    return content.replace(/\\{\\{widget[\\S\\s]*?\\}\\}/ig, function (match) {\n      return match.replace(/&quot;/g, \"\\\\\\\"\");\n    });\n  }\n  /**\n   * Convert double quote with backslash to HTML encoded double quote within widget directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function unescapeDoubleQuoteWithinWidgetDirective(content) {\n    return content.replace(/\\{\\{widget[\\S\\s]*?\\}\\}/ig, function (match) {\n      return match.replace(/\\\\+\"/g, \"&quot;\");\n    });\n  }\n  /**\n   * Convert double quote to single quote within magento variable directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function replaceDoubleQuoteWithSingleQuoteWithinVariableDirective(content) {\n    // Find html elements which attributes contain magento variables directives\n    return content.replace(/<([a-z0-9\\-\\_]+)([^>]+?[a-z0-9\\-\\_]+=\"[^\"]*?\\{\\{.+?\\}\\}.*?\".*?)>/gi, function (match1, tag, attributes) {\n      // Replace double quote with single quote within magento variable directive\n      var sanitizedAttributes = attributes.replace(/\\{\\{[^\\{\\}]+\\}\\}/gi, function (match2) {\n        return match2.replace(/\"/g, \"'\");\n      });\n      return \"<\" + tag + sanitizedAttributes + \">\";\n    });\n  }\n\n  return {\n    isWysiwygSupported: isWysiwygSupported,\n    encodeContent: encodeContent,\n    parseAttributesString: parseAttributesString,\n    lockImageSize: lockImageSize,\n    unlockImageSize: unlockImageSize,\n    createBookmark: createBookmark,\n    moveToBookmark: moveToBookmark,\n    getActiveEditor: getActiveEditor,\n    findNodeIndex: findNodeIndex,\n    getNodeByIndex: getNodeByIndex,\n    createDoubleClickEvent: createDoubleClickEvent,\n    processInlineStyles: processInlineStyles,\n    escapeDoubleQuoteWithinWidgetDirective: escapeDoubleQuoteWithinWidgetDirective,\n    unescapeDoubleQuoteWithinWidgetDirective: unescapeDoubleQuoteWithinWidgetDirective,\n    replaceDoubleQuoteWithSingleQuoteWithinVariableDirective: replaceDoubleQuoteWithSingleQuoteWithinVariableDirective\n  };\n});\n//# sourceMappingURL=editor.js.map","Magento_PageBuilder/js/resource/object-path.js":"(function (root, factory){\n    'use strict';\n\n    /*istanbul ignore next:cant test*/\n    if (typeof module === 'object' && typeof module.exports === 'object') {\n        module.exports = factory();\n    } else if (typeof define === 'function' && define.amd) {\n        // AMD. Register as an anonymous module.\n        define([], factory);\n    } else {\n        // Browser globals\n        root.objectPath = factory();\n    }\n})(this, function(){\n    'use strict';\n\n    var toStr = Object.prototype.toString;\n    function hasOwnProperty(obj, prop) {\n        if(obj == null) {\n            return false\n        }\n        //to handle objects with null prototypes (too edge case?)\n        return Object.prototype.hasOwnProperty.call(obj, prop)\n    }\n\n    function isEmpty(value){\n        if (!value) {\n            return true;\n        }\n        if (isArray(value) && value.length === 0) {\n            return true;\n        } else if (typeof value !== 'string') {\n            for (var i in value) {\n                if (hasOwnProperty(value, i)) {\n                    return false;\n                }\n            }\n            return true;\n        }\n        return false;\n    }\n\n    function toString(type){\n        return toStr.call(type);\n    }\n\n    function isObject(obj){\n        return typeof obj === 'object' && toString(obj) === \"[object Object]\";\n    }\n\n    var isArray = Array.isArray || function(obj){\n        /*istanbul ignore next:cant test*/\n        return toStr.call(obj) === '[object Array]';\n    }\n\n    function isBoolean(obj){\n        return typeof obj === 'boolean' || toString(obj) === '[object Boolean]';\n    }\n\n    function getKey(key){\n        var intKey = parseInt(key);\n        if (intKey.toString() === key) {\n            return intKey;\n        }\n        return key;\n    }\n\n    function factory(options) {\n        options = options || {}\n\n        var objectPath = function(obj) {\n            return Object.keys(objectPath).reduce(function(proxy, prop) {\n                if(prop === 'create') {\n                    return proxy;\n                }\n\n                /*istanbul ignore else*/\n                if (typeof objectPath[prop] === 'function') {\n                    proxy[prop] = objectPath[prop].bind(objectPath, obj);\n                }\n\n                return proxy;\n            }, {});\n        };\n\n        var hasShallowProperty\n        if (options.includeInheritedProps) {\n            hasShallowProperty = function () {\n                return true\n            }\n        } else {\n            hasShallowProperty = function (obj, prop) {\n                return (typeof prop === 'number' && Array.isArray(obj)) || hasOwnProperty(obj, prop)\n            }\n        }\n\n        function getShallowProperty(obj, prop) {\n            if (hasShallowProperty(obj, prop)) {\n                return obj[prop];\n            }\n        }\n\n        function set(obj, path, value, doNotReplace){\n            if (typeof path === 'number') {\n                path = [path];\n            }\n            if (!path || path.length === 0) {\n                return obj;\n            }\n            if (typeof path === 'string') {\n                return set(obj, path.split('.').map(getKey), value, doNotReplace);\n            }\n            var currentPath = path[0];\n            var currentValue = getShallowProperty(obj, currentPath);\n            if (options.includeInheritedProps && (currentPath === '__proto__' ||\n                (currentPath === 'constructor' && typeof currentValue === 'function'))) {\n                throw new Error('For security reasons, object\\'s magic properties cannot be set')\n            }\n            if (path.length === 1) {\n                if (currentValue === void 0 || !doNotReplace) {\n                    obj[currentPath] = value;\n                }\n                return currentValue;\n            }\n\n            if (currentValue === void 0) {\n                //check if we assume an array\n                if(typeof path[1] === 'number') {\n                    obj[currentPath] = [];\n                } else {\n                    obj[currentPath] = {};\n                }\n            }\n\n            return set(obj[currentPath], path.slice(1), value, doNotReplace);\n        }\n\n        objectPath.has = function (obj, path) {\n            if (typeof path === 'number') {\n                path = [path];\n            } else if (typeof path === 'string') {\n                path = path.split('.');\n            }\n\n            if (!path || path.length === 0) {\n                return !!obj;\n            }\n\n            for (var i = 0; i < path.length; i++) {\n                var j = getKey(path[i]);\n\n                if((typeof j === 'number' && isArray(obj) && j < obj.length) ||\n                    (options.includeInheritedProps ? (j in Object(obj)) : hasOwnProperty(obj, j))) {\n                    obj = obj[j];\n                } else {\n                    return false;\n                }\n            }\n\n            return true;\n        };\n\n        objectPath.ensureExists = function (obj, path, value){\n            return set(obj, path, value, true);\n        };\n\n        objectPath.set = function (obj, path, value, doNotReplace){\n            return set(obj, path, value, doNotReplace);\n        };\n\n        objectPath.insert = function (obj, path, value, at){\n            var arr = objectPath.get(obj, path);\n            at = ~~at;\n            if (!isArray(arr)) {\n                arr = [];\n                objectPath.set(obj, path, arr);\n            }\n            arr.splice(at, 0, value);\n        };\n\n        objectPath.empty = function(obj, path) {\n            if (isEmpty(path)) {\n                return void 0;\n            }\n            if (obj == null) {\n                return void 0;\n            }\n\n            var value, i;\n            if (!(value = objectPath.get(obj, path))) {\n                return void 0;\n            }\n\n            if (typeof value === 'string') {\n                return objectPath.set(obj, path, '');\n            } else if (isBoolean(value)) {\n                return objectPath.set(obj, path, false);\n            } else if (typeof value === 'number') {\n                return objectPath.set(obj, path, 0);\n            } else if (isArray(value)) {\n                value.length = 0;\n            } else if (isObject(value)) {\n                for (i in value) {\n                    if (hasShallowProperty(value, i)) {\n                        delete value[i];\n                    }\n                }\n            } else {\n                return objectPath.set(obj, path, null);\n            }\n        };\n\n        objectPath.push = function (obj, path /*, values */){\n            var arr = objectPath.get(obj, path);\n            if (!isArray(arr)) {\n                arr = [];\n                objectPath.set(obj, path, arr);\n            }\n\n            arr.push.apply(arr, Array.prototype.slice.call(arguments, 2));\n        };\n\n        objectPath.coalesce = function (obj, paths, defaultValue) {\n            var value;\n\n            for (var i = 0, len = paths.length; i < len; i++) {\n                if ((value = objectPath.get(obj, paths[i])) !== void 0) {\n                    return value;\n                }\n            }\n\n            return defaultValue;\n        };\n\n        objectPath.get = function (obj, path, defaultValue){\n            if (typeof path === 'number') {\n                path = [path];\n            }\n            if (!path || path.length === 0) {\n                return obj;\n            }\n            if (obj == null) {\n                return defaultValue;\n            }\n            if (typeof path === 'string') {\n                return objectPath.get(obj, path.split('.'), defaultValue);\n            }\n\n            var currentPath = getKey(path[0]);\n            var nextObj = getShallowProperty(obj, currentPath)\n            if (nextObj === void 0) {\n                return defaultValue;\n            }\n\n            if (path.length === 1) {\n                return nextObj;\n            }\n\n            return objectPath.get(obj[currentPath], path.slice(1), defaultValue);\n        };\n\n        objectPath.del = function del(obj, path) {\n            if (typeof path === 'number') {\n                path = [path];\n            }\n\n            if (obj == null) {\n                return obj;\n            }\n\n            if (isEmpty(path)) {\n                return obj;\n            }\n            if(typeof path === 'string') {\n                return objectPath.del(obj, path.split('.'));\n            }\n\n            var currentPath = getKey(path[0]);\n            if (!hasShallowProperty(obj, currentPath)) {\n                return obj;\n            }\n\n            if(path.length === 1) {\n                if (isArray(obj)) {\n                    obj.splice(currentPath, 1);\n                } else {\n                    delete obj[currentPath];\n                }\n            } else {\n                return objectPath.del(obj[currentPath], path.slice(1));\n            }\n\n            return obj;\n        }\n\n        return objectPath;\n    }\n\n    var mod = factory();\n    mod.create = factory;\n    mod.withInheritedProps = factory({includeInheritedProps: true})\n    return mod;\n});","Magento_PageBuilder/js/resource/babel/polyfill.min.js":"!function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var c=\"function\"==typeof require&&require;if(!u&&c)return c(o,!0);if(i)return i(o,!0);var a=new Error(\"Cannot find module '\"+o+\"'\");throw a.code=\"MODULE_NOT_FOUND\",a}var f=n[o]={exports:{}};t[o][0].call(f.exports,function(n){var r=t[o][1][n];return s(r||n)},f,f.exports,e,t,n,r)}return n[o].exports}for(var i=\"function\"==typeof require&&require,o=0;o<r.length;o++)s(r[o]);return s}({1:[function(t,n,r){(function(n){\"use strict\";function define(t,n,e){t[n]||Object[r](t,n,{writable:!0,configurable:!0,value:e})}if(t(327),t(328),t(2),n._babelPolyfill)throw new Error(\"only one instance of babel-polyfill is allowed\");n._babelPolyfill=!0;var r=\"defineProperty\";define(String.prototype,\"padLeft\",\"\".padStart),define(String.prototype,\"padRight\",\"\".padEnd),\"pop,reverse,shift,keys,values,entries,indexOf,every,some,forEach,map,filter,find,findIndex,includes,join,slice,concat,push,splice,unshift,sort,lastIndexOf,reduce,reduceRight,copyWithin,fill\".split(\",\").forEach(function(t){[][t]&&define(Array,t,Function.call.bind([][t]))})}).call(this,\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:{})},{2:2,327:327,328:328}],2:[function(t,n,r){t(130),n.exports=t(23).RegExp.escape},{130:130,23:23}],3:[function(t,n,r){n.exports=function(t){if(\"function\"!=typeof t)throw TypeError(t+\" is not a function!\");return t}},{}],4:[function(t,n,r){var e=t(18);n.exports=function(t,n){if(\"number\"!=typeof t&&\"Number\"!=e(t))throw TypeError(n);return+t}},{18:18}],5:[function(t,n,r){var e=t(128)(\"unscopables\"),i=Array.prototype;void 0==i[e]&&t(42)(i,e,{}),n.exports=function(t){i[e][t]=!0}},{128:128,42:42}],6:[function(t,n,r){n.exports=function(t,n,r,e){if(!(t instanceof n)||void 0!==e&&e in t)throw TypeError(r+\": incorrect invocation!\");return t}},{}],7:[function(t,n,r){var e=t(51);n.exports=function(t){if(!e(t))throw TypeError(t+\" is not an object!\");return t}},{51:51}],8:[function(t,n,r){\"use strict\";var e=t(119),i=t(114),o=t(118);n.exports=[].copyWithin||function copyWithin(t,n){var r=e(this),u=o(r.length),c=i(t,u),a=i(n,u),f=arguments.length>2?arguments[2]:void 0,s=Math.min((void 0===f?u:i(f,u))-a,u-c),l=1;for(a<c&&c<a+s&&(l=-1,a+=s-1,c+=s-1);s-- >0;)a in r?r[c]=r[a]:delete r[c],c+=l,a+=l;return r}},{114:114,118:118,119:119}],9:[function(t,n,r){\"use strict\";var e=t(119),i=t(114),o=t(118);n.exports=function fill(t){for(var n=e(this),r=o(n.length),u=arguments.length,c=i(u>1?arguments[1]:void 0,r),a=u>2?arguments[2]:void 0,f=void 0===a?r:i(a,r);f>c;)n[c++]=t;return n}},{114:114,118:118,119:119}],10:[function(t,n,r){var e=t(39);n.exports=function(t,n){var r=[];return e(t,!1,r.push,r,n),r}},{39:39}],11:[function(t,n,r){var e=t(117),i=t(118),o=t(114);n.exports=function(t){return function(n,r,u){var c,a=e(n),f=i(a.length),s=o(u,f);if(t&&r!=r){for(;f>s;)if((c=a[s++])!=c)return!0}else for(;f>s;s++)if((t||s in a)&&a[s]===r)return t||s||0;return!t&&-1}}},{114:114,117:117,118:118}],12:[function(t,n,r){var e=t(25),i=t(47),o=t(119),u=t(118),c=t(15);n.exports=function(t,n){var r=1==t,a=2==t,f=3==t,s=4==t,l=6==t,h=5==t||l,v=n||c;return function(n,c,p){for(var d,y,g=o(n),m=i(g),b=e(c,p,3),x=u(m.length),S=0,w=r?v(n,x):a?v(n,0):void 0;x>S;S++)if((h||S in m)&&(d=m[S],y=b(d,S,g),t))if(r)w[S]=y;else if(y)switch(t){case 3:return!0;case 5:return d;case 6:return S;case 2:w.push(d)}else if(s)return!1;return l?-1:f||s?s:w}}},{118:118,119:119,15:15,25:25,47:47}],13:[function(t,n,r){var e=t(3),i=t(119),o=t(47),u=t(118);n.exports=function(t,n,r,c,a){e(n);var f=i(t),s=o(f),l=u(f.length),h=a?l-1:0,v=a?-1:1;if(r<2)for(;;){if(h in s){c=s[h],h+=v;break}if(h+=v,a?h<0:l<=h)throw TypeError(\"Reduce of empty array with no initial value\")}for(;a?h>=0:l>h;h+=v)h in s&&(c=n(c,s[h],h,f));return c}},{118:118,119:119,3:3,47:47}],14:[function(t,n,r){var e=t(51),i=t(49),o=t(128)(\"species\");n.exports=function(t){var n;return i(t)&&(n=t.constructor,\"function\"!=typeof n||n!==Array&&!i(n.prototype)||(n=void 0),e(n)&&null===(n=n[o])&&(n=void 0)),void 0===n?Array:n}},{128:128,49:49,51:51}],15:[function(t,n,r){var e=t(14);n.exports=function(t,n){return new(e(t))(n)}},{14:14}],16:[function(t,n,r){\"use strict\";var e=t(3),i=t(51),o=t(46),u=[].slice,c={},a=function(t,n,r){if(!(n in c)){for(var e=[],i=0;i<n;i++)e[i]=\"a[\"+i+\"]\";c[n]=Function(\"F,a\",\"return new F(\"+e.join(\",\")+\")\")}return c[n](t,r)};n.exports=Function.bind||function bind(t){var n=e(this),r=u.call(arguments,1),c=function(){var e=r.concat(u.call(arguments));return this instanceof c?a(n,e.length,e):o(n,e,t)};return i(n.prototype)&&(c.prototype=n.prototype),c}},{3:3,46:46,51:51}],17:[function(t,n,r){var e=t(18),i=t(128)(\"toStringTag\"),o=\"Arguments\"==e(function(){return arguments}()),u=function(t,n){try{return t[n]}catch(t){}};n.exports=function(t){var n,r,c;return void 0===t?\"Undefined\":null===t?\"Null\":\"string\"==typeof(r=u(n=Object(t),i))?r:o?e(n):\"Object\"==(c=e(n))&&\"function\"==typeof n.callee?\"Arguments\":c}},{128:128,18:18}],18:[function(t,n,r){var e={}.toString;n.exports=function(t){return e.call(t).slice(8,-1)}},{}],19:[function(t,n,r){\"use strict\";var e=t(72).f,i=t(71),o=t(93),u=t(25),c=t(6),a=t(39),f=t(55),s=t(57),l=t(100),h=t(29),v=t(66).fastKey,p=t(125),d=h?\"_s\":\"size\",y=function(t,n){var r,e=v(n);if(\"F\"!==e)return t._i[e];for(r=t._f;r;r=r.n)if(r.k==n)return r};n.exports={getConstructor:function(t,n,r,f){var s=t(function(t,e){c(t,s,n,\"_i\"),t._t=n,t._i=i(null),t._f=void 0,t._l=void 0,t[d]=0,void 0!=e&&a(e,r,t[f],t)});return o(s.prototype,{clear:function clear(){for(var t=p(this,n),r=t._i,e=t._f;e;e=e.n)e.r=!0,e.p&&(e.p=e.p.n=void 0),delete r[e.i];t._f=t._l=void 0,t[d]=0},delete:function(t){var r=p(this,n),e=y(r,t);if(e){var i=e.n,o=e.p;delete r._i[e.i],e.r=!0,o&&(o.n=i),i&&(i.p=o),r._f==e&&(r._f=i),r._l==e&&(r._l=o),r[d]--}return!!e},forEach:function forEach(t){p(this,n);for(var r,e=u(t,arguments.length>1?arguments[1]:void 0,3);r=r?r.n:this._f;)for(e(r.v,r.k,this);r&&r.r;)r=r.p},has:function has(t){return!!y(p(this,n),t)}}),h&&e(s.prototype,\"size\",{get:function(){return p(this,n)[d]}}),s},def:function(t,n,r){var e,i,o=y(t,n);return o?o.v=r:(t._l=o={i:i=v(n,!0),k:n,v:r,p:e=t._l,n:void 0,r:!1},t._f||(t._f=o),e&&(e.n=o),t[d]++,\"F\"!==i&&(t._i[i]=o)),t},getEntry:y,setStrong:function(t,n,r){f(t,n,function(t,r){this._t=p(t,n),this._k=r,this._l=void 0},function(){for(var t=this,n=t._k,r=t._l;r&&r.r;)r=r.p;return t._t&&(t._l=r=r?r.n:t._t._f)?\"keys\"==n?s(0,r.k):\"values\"==n?s(0,r.v):s(0,[r.k,r.v]):(t._t=void 0,s(1))},r?\"entries\":\"values\",!r,!0),l(n)}}},{100:100,125:125,25:25,29:29,39:39,55:55,57:57,6:6,66:66,71:71,72:72,93:93}],20:[function(t,n,r){var e=t(17),i=t(10);n.exports=function(t){return function toJSON(){if(e(this)!=t)throw TypeError(t+\"#toJSON isn't generic\");return i(this)}}},{10:10,17:17}],21:[function(t,n,r){\"use strict\";var e=t(93),i=t(66).getWeak,o=t(7),u=t(51),c=t(6),a=t(39),f=t(12),s=t(41),l=t(125),h=f(5),v=f(6),p=0,d=function(t){return t._l||(t._l=new y)},y=function(){this.a=[]},g=function(t,n){return h(t.a,function(t){return t[0]===n})};y.prototype={get:function(t){var n=g(this,t);if(n)return n[1]},has:function(t){return!!g(this,t)},set:function(t,n){var r=g(this,t);r?r[1]=n:this.a.push([t,n])},delete:function(t){var n=v(this.a,function(n){return n[0]===t});return~n&&this.a.splice(n,1),!!~n}},n.exports={getConstructor:function(t,n,r,o){var f=t(function(t,e){c(t,f,n,\"_i\"),t._t=n,t._i=p++,t._l=void 0,void 0!=e&&a(e,r,t[o],t)});return e(f.prototype,{delete:function(t){if(!u(t))return!1;var r=i(t);return!0===r?d(l(this,n)).delete(t):r&&s(r,this._i)&&delete r[this._i]},has:function has(t){if(!u(t))return!1;var r=i(t);return!0===r?d(l(this,n)).has(t):r&&s(r,this._i)}}),f},def:function(t,n,r){var e=i(o(n),!0);return!0===e?d(t).set(n,r):e[t._i]=r,t},ufstore:d}},{12:12,125:125,39:39,41:41,51:51,6:6,66:66,7:7,93:93}],22:[function(t,n,r){\"use strict\";var e=t(40),i=t(33),o=t(94),u=t(93),c=t(66),a=t(39),f=t(6),s=t(51),l=t(35),h=t(56),v=t(101),p=t(45);n.exports=function(t,n,r,d,y,g){var m=e[t],b=m,x=y?\"set\":\"add\",S=b&&b.prototype,w={},_=function(t){var n=S[t];o(S,t,\"delete\"==t?function(t){return!(g&&!s(t))&&n.call(this,0===t?0:t)}:\"has\"==t?function has(t){return!(g&&!s(t))&&n.call(this,0===t?0:t)}:\"get\"==t?function get(t){return g&&!s(t)?void 0:n.call(this,0===t?0:t)}:\"add\"==t?function add(t){return n.call(this,0===t?0:t),this}:function set(t,r){return n.call(this,0===t?0:t,r),this})};if(\"function\"==typeof b&&(g||S.forEach&&!l(function(){(new b).entries().next()}))){var E=new b,O=E[x](g?{}:-0,1)!=E,P=l(function(){E.has(1)}),M=h(function(t){new b(t)}),F=!g&&l(function(){for(var t=new b,n=5;n--;)t[x](n,n);return!t.has(-0)});M||(b=n(function(n,r){f(n,b,t);var e=p(new m,n,b);return void 0!=r&&a(r,y,e[x],e),e}),b.prototype=S,S.constructor=b),(P||F)&&(_(\"delete\"),_(\"has\"),y&&_(\"get\")),(F||O)&&_(x),g&&S.clear&&delete S.clear}else b=d.getConstructor(n,t,y,x),u(b.prototype,r),c.NEED=!0;return v(b,t),w[t]=b,i(i.G+i.W+i.F*(b!=m),w),g||d.setStrong(b,t,y),b}},{101:101,33:33,35:35,39:39,40:40,45:45,51:51,56:56,6:6,66:66,93:93,94:94}],23:[function(t,n,r){var e=n.exports={version:\"2.5.0\"};\"number\"==typeof __e&&(__e=e)},{}],24:[function(t,n,r){\"use strict\";var e=t(72),i=t(92);n.exports=function(t,n,r){n in t?e.f(t,n,i(0,r)):t[n]=r}},{72:72,92:92}],25:[function(t,n,r){var e=t(3);n.exports=function(t,n,r){if(e(t),void 0===n)return t;switch(r){case 1:return function(r){return t.call(n,r)};case 2:return function(r,e){return t.call(n,r,e)};case 3:return function(r,e,i){return t.call(n,r,e,i)}}return function(){return t.apply(n,arguments)}}},{3:3}],26:[function(t,n,r){\"use strict\";var e=t(35),i=Date.prototype.getTime,o=Date.prototype.toISOString,u=function(t){return t>9?t:\"0\"+t};n.exports=e(function(){return\"0385-07-25T07:06:39.999Z\"!=o.call(new Date(-5e13-1))})||!e(function(){o.call(new Date(NaN))})?function toISOString(){if(!isFinite(i.call(this)))throw RangeError(\"Invalid time value\");var t=this,n=t.getUTCFullYear(),r=t.getUTCMilliseconds(),e=n<0?\"-\":n>9999?\"+\":\"\";return e+(\"00000\"+Math.abs(n)).slice(e?-6:-4)+\"-\"+u(t.getUTCMonth()+1)+\"-\"+u(t.getUTCDate())+\"T\"+u(t.getUTCHours())+\":\"+u(t.getUTCMinutes())+\":\"+u(t.getUTCSeconds())+\".\"+(r>99?r:\"0\"+u(r))+\"Z\"}:o},{35:35}],27:[function(t,n,r){\"use strict\";var e=t(7),i=t(120);n.exports=function(t){if(\"string\"!==t&&\"number\"!==t&&\"default\"!==t)throw TypeError(\"Incorrect hint\");return i(e(this),\"number\"!=t)}},{120:120,7:7}],28:[function(t,n,r){n.exports=function(t){if(void 0==t)throw TypeError(\"Can't call method on  \"+t);return t}},{}],29:[function(t,n,r){n.exports=!t(35)(function(){return 7!=Object.defineProperty({},\"a\",{get:function(){return 7}}).a})},{35:35}],30:[function(t,n,r){var e=t(51),i=t(40).document,o=e(i)&&e(i.createElement);n.exports=function(t){return o?i.createElement(t):{}}},{40:40,51:51}],31:[function(t,n,r){n.exports=\"constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf\".split(\",\")},{}],32:[function(t,n,r){var e=t(81),i=t(78),o=t(82);n.exports=function(t){var n=e(t),r=i.f;if(r)for(var u,c=r(t),a=o.f,f=0;c.length>f;)a.call(t,u=c[f++])&&n.push(u);return n}},{78:78,81:81,82:82}],33:[function(t,n,r){var e=t(40),i=t(23),o=t(42),u=t(94),c=t(25),a=function(t,n,r){var f,s,l,h,v=t&a.F,p=t&a.G,d=t&a.S,y=t&a.P,g=t&a.B,m=p?e:d?e[n]||(e[n]={}):(e[n]||{}).prototype,b=p?i:i[n]||(i[n]={}),x=b.prototype||(b.prototype={});p&&(r=n);for(f in r)s=!v&&m&&void 0!==m[f],l=(s?m:r)[f],h=g&&s?c(l,e):y&&\"function\"==typeof l?c(Function.call,l):l,m&&u(m,f,l,t&a.U),b[f]!=l&&o(b,f,h),y&&x[f]!=l&&(x[f]=l)};e.core=i,a.F=1,a.G=2,a.S=4,a.P=8,a.B=16,a.W=32,a.U=64,a.R=128,n.exports=a},{23:23,25:25,40:40,42:42,94:94}],34:[function(t,n,r){var e=t(128)(\"match\");n.exports=function(t){var n=/./;try{\"/./\"[t](n)}catch(r){try{return n[e]=!1,!\"/./\"[t](n)}catch(t){}}return!0}},{128:128}],35:[function(t,n,r){n.exports=function(t){try{return!!t()}catch(t){return!0}}},{}],36:[function(t,n,r){\"use strict\";var e=t(42),i=t(94),o=t(35),u=t(28),c=t(128);n.exports=function(t,n,r){var a=c(t),f=r(u,a,\"\"[t]),s=f[0],l=f[1];o(function(){var n={};return n[a]=function(){return 7},7!=\"\"[t](n)})&&(i(String.prototype,t,s),e(RegExp.prototype,a,2==n?function(t,n){return l.call(t,this,n)}:function(t){return l.call(t,this)}))}},{128:128,28:28,35:35,42:42,94:94}],37:[function(t,n,r){\"use strict\";var e=t(7);n.exports=function(){var t=e(this),n=\"\";return t.global&&(n+=\"g\"),t.ignoreCase&&(n+=\"i\"),t.multiline&&(n+=\"m\"),t.unicode&&(n+=\"u\"),t.sticky&&(n+=\"y\"),n}},{7:7}],38:[function(t,n,r){\"use strict\";function flattenIntoArray(t,n,r,a,f,s,l,h){for(var v,p,d=f,y=0,g=!!l&&u(l,h,3);y<a;){if(y in r){if(v=g?g(r[y],y,n):r[y],p=!1,i(v)&&(p=v[c],p=void 0!==p?!!p:e(v)),p&&s>0)d=flattenIntoArray(t,n,v,o(v.length),d,s-1)-1;else{if(d>=9007199254740991)throw TypeError();t[d]=v}d++}y++}return d}var e=t(49),i=t(51),o=t(118),u=t(25),c=t(128)(\"isConcatSpreadable\");n.exports=flattenIntoArray},{118:118,128:128,25:25,49:49,51:51}],39:[function(t,n,r){var e=t(25),i=t(53),o=t(48),u=t(7),c=t(118),a=t(129),f={},s={},r=n.exports=function(t,n,r,l,h){var v,p,d,y,g=h?function(){return t}:a(t),m=e(r,l,n?2:1),b=0;if(\"function\"!=typeof g)throw TypeError(t+\" is not iterable!\");if(o(g)){for(v=c(t.length);v>b;b++)if((y=n?m(u(p=t[b])[0],p[1]):m(t[b]))===f||y===s)return y}else for(d=g.call(t);!(p=d.next()).done;)if((y=i(d,m,p.value,n))===f||y===s)return y};r.BREAK=f,r.RETURN=s},{118:118,129:129,25:25,48:48,53:53,7:7}],40:[function(t,n,r){var e=n.exports=\"undefined\"!=typeof window&&window.Math==Math?window:\"undefined\"!=typeof self&&self.Math==Math?self:Function(\"return this\")();\"number\"==typeof __g&&(__g=e)},{}],41:[function(t,n,r){var e={}.hasOwnProperty;n.exports=function(t,n){return e.call(t,n)}},{}],42:[function(t,n,r){var e=t(72),i=t(92);n.exports=t(29)?function(t,n,r){return e.f(t,n,i(1,r))}:function(t,n,r){return t[n]=r,t}},{29:29,72:72,92:92}],43:[function(t,n,r){var e=t(40).document;n.exports=e&&e.documentElement},{40:40}],44:[function(t,n,r){n.exports=!t(29)&&!t(35)(function(){return 7!=Object.defineProperty(t(30)(\"div\"),\"a\",{get:function(){return 7}}).a})},{29:29,30:30,35:35}],45:[function(t,n,r){var e=t(51),i=t(99).set;n.exports=function(t,n,r){var o,u=n.constructor;return u!==r&&\"function\"==typeof u&&(o=u.prototype)!==r.prototype&&e(o)&&i&&i(t,o),t}},{51:51,99:99}],46:[function(t,n,r){n.exports=function(t,n,r){var e=void 0===r;switch(n.length){case 0:return e?t():t.call(r);case 1:return e?t(n[0]):t.call(r,n[0]);case 2:return e?t(n[0],n[1]):t.call(r,n[0],n[1]);case 3:return e?t(n[0],n[1],n[2]):t.call(r,n[0],n[1],n[2]);case 4:return e?t(n[0],n[1],n[2],n[3]):t.call(r,n[0],n[1],n[2],n[3])}return t.apply(r,n)}},{}],47:[function(t,n,r){var e=t(18);n.exports=Object(\"z\").propertyIsEnumerable(0)?Object:function(t){return\"String\"==e(t)?t.split(\"\"):Object(t)}},{18:18}],48:[function(t,n,r){var e=t(58),i=t(128)(\"iterator\"),o=Array.prototype;n.exports=function(t){return void 0!==t&&(e.Array===t||o[i]===t)}},{128:128,58:58}],49:[function(t,n,r){var e=t(18);n.exports=Array.isArray||function isArray(t){return\"Array\"==e(t)}},{18:18}],50:[function(t,n,r){var e=t(51),i=Math.floor;n.exports=function isInteger(t){return!e(t)&&isFinite(t)&&i(t)===t}},{51:51}],51:[function(t,n,r){n.exports=function(t){return\"object\"==typeof t?null!==t:\"function\"==typeof t}},{}],52:[function(t,n,r){var e=t(51),i=t(18),o=t(128)(\"match\");n.exports=function(t){var n;return e(t)&&(void 0!==(n=t[o])?!!n:\"RegExp\"==i(t))}},{128:128,18:18,51:51}],53:[function(t,n,r){var e=t(7);n.exports=function(t,n,r,i){try{return i?n(e(r)[0],r[1]):n(r)}catch(n){var o=t.return;throw void 0!==o&&e(o.call(t)),n}}},{7:7}],54:[function(t,n,r){\"use strict\";var e=t(71),i=t(92),o=t(101),u={};t(42)(u,t(128)(\"iterator\"),function(){return this}),n.exports=function(t,n,r){t.prototype=e(u,{next:i(1,r)}),o(t,n+\" Iterator\")}},{101:101,128:128,42:42,71:71,92:92}],55:[function(t,n,r){\"use strict\";var e=t(60),i=t(33),o=t(94),u=t(42),c=t(41),a=t(58),f=t(54),s=t(101),l=t(79),h=t(128)(\"iterator\"),v=!([].keys&&\"next\"in[].keys()),p=function(){return this};n.exports=function(t,n,r,d,y,g,m){f(r,n,d);var b,x,S,w=function(t){if(!v&&t in P)return P[t];switch(t){case\"keys\":return function keys(){return new r(this,t)};case\"values\":return function values(){return new r(this,t)}}return function entries(){return new r(this,t)}},_=n+\" Iterator\",E=\"values\"==y,O=!1,P=t.prototype,M=P[h]||P[\"@@iterator\"]||y&&P[y],F=M||w(y),I=y?E?w(\"entries\"):F:void 0,A=\"Array\"==n?P.entries||M:M;if(A&&(S=l(A.call(new t)))!==Object.prototype&&S.next&&(s(S,_,!0),e||c(S,h)||u(S,h,p)),E&&M&&\"values\"!==M.name&&(O=!0,F=function values(){return M.call(this)}),e&&!m||!v&&!O&&P[h]||u(P,h,F),a[n]=F,a[_]=p,y)if(b={values:E?F:w(\"values\"),keys:g?F:w(\"keys\"),entries:I},m)for(x in b)x in P||o(P,x,b[x]);else i(i.P+i.F*(v||O),n,b);return b}},{101:101,128:128,33:33,41:41,42:42,54:54,58:58,60:60,79:79,94:94}],56:[function(t,n,r){var e=t(128)(\"iterator\"),i=!1;try{var o=[7][e]();o.return=function(){i=!0},Array.from(o,function(){throw 2})}catch(t){}n.exports=function(t,n){if(!n&&!i)return!1;var r=!1;try{var o=[7],u=o[e]();u.next=function(){return{done:r=!0}},o[e]=function(){return u},t(o)}catch(t){}return r}},{128:128}],57:[function(t,n,r){n.exports=function(t,n){return{value:n,done:!!t}}},{}],58:[function(t,n,r){n.exports={}},{}],59:[function(t,n,r){var e=t(81),i=t(117);n.exports=function(t,n){for(var r,o=i(t),u=e(o),c=u.length,a=0;c>a;)if(o[r=u[a++]]===n)return r}},{117:117,81:81}],60:[function(t,n,r){n.exports=!1},{}],61:[function(t,n,r){var e=Math.expm1;n.exports=!e||e(10)>22025.465794806718||e(10)<22025.465794806718||-2e-17!=e(-2e-17)?function expm1(t){return 0==(t=+t)?t:t>-1e-6&&t<1e-6?t+t*t/2:Math.exp(t)-1}:e},{}],62:[function(t,n,r){var e=t(65),i=Math.pow,o=i(2,-52),u=i(2,-23),c=i(2,127)*(2-u),a=i(2,-126),f=function(t){return t+1/o-1/o};n.exports=Math.fround||function fround(t){var n,r,i=Math.abs(t),s=e(t);return i<a?s*f(i/a/u)*a*u:(n=(1+u/o)*i,r=n-(n-i),r>c||r!=r?s*(1/0):s*r)}},{65:65}],63:[function(t,n,r){n.exports=Math.log1p||function log1p(t){return(t=+t)>-1e-8&&t<1e-8?t-t*t/2:Math.log(1+t)}},{}],64:[function(t,n,r){n.exports=Math.scale||function scale(t,n,r,e,i){return 0===arguments.length||t!=t||n!=n||r!=r||e!=e||i!=i?NaN:t===1/0||t===-1/0?t:(t-n)*(i-e)/(r-n)+e}},{}],65:[function(t,n,r){n.exports=Math.sign||function sign(t){return 0==(t=+t)||t!=t?t:t<0?-1:1}},{}],66:[function(t,n,r){var e=t(124)(\"meta\"),i=t(51),o=t(41),u=t(72).f,c=0,a=Object.isExtensible||function(){return!0},f=!t(35)(function(){return a(Object.preventExtensions({}))}),s=function(t){u(t,e,{value:{i:\"O\"+ ++c,w:{}}})},l=function(t,n){if(!i(t))return\"symbol\"==typeof t?t:(\"string\"==typeof t?\"S\":\"P\")+t;if(!o(t,e)){if(!a(t))return\"F\";if(!n)return\"E\";s(t)}return t[e].i},h=function(t,n){if(!o(t,e)){if(!a(t))return!0;if(!n)return!1;s(t)}return t[e].w},v=function(t){return f&&p.NEED&&a(t)&&!o(t,e)&&s(t),t},p=n.exports={KEY:e,NEED:!1,fastKey:l,getWeak:h,onFreeze:v}},{124:124,35:35,41:41,51:51,72:72}],67:[function(t,n,r){var e=t(160),i=t(33),o=t(103)(\"metadata\"),u=o.store||(o.store=new(t(266))),c=function(t,n,r){var i=u.get(t);if(!i){if(!r)return;u.set(t,i=new e)}var o=i.get(n);if(!o){if(!r)return;i.set(n,o=new e)}return o},a=function(t,n,r){var e=c(n,r,!1);return void 0!==e&&e.has(t)},f=function(t,n,r){var e=c(n,r,!1);return void 0===e?void 0:e.get(t)},s=function(t,n,r,e){c(r,e,!0).set(t,n)},l=function(t,n){var r=c(t,n,!1),e=[];return r&&r.forEach(function(t,n){e.push(n)}),e},h=function(t){return void 0===t||\"symbol\"==typeof t?t:String(t)},v=function(t){i(i.S,\"Reflect\",t)};n.exports={store:u,map:c,has:a,get:f,set:s,keys:l,key:h,exp:v}},{103:103,160:160,266:266,33:33}],68:[function(t,n,r){var e=t(40),i=t(113).set,o=e.MutationObserver||e.WebKitMutationObserver,u=e.process,c=e.Promise,a=\"process\"==t(18)(u);n.exports=function(){var t,n,r,f=function(){var e,i;for(a&&(e=u.domain)&&e.exit();t;){i=t.fn,t=t.next;try{i()}catch(e){throw t?r():n=void 0,e}}n=void 0,e&&e.enter()};if(a)r=function(){u.nextTick(f)};else if(o){var s=!0,l=document.createTextNode(\"\");new o(f).observe(l,{characterData:!0}),r=function(){l.data=s=!s}}else if(c&&c.resolve){var h=c.resolve();r=function(){h.then(f)}}else r=function(){i.call(e,f)};return function(e){var i={fn:e,next:void 0};n&&(n.next=i),t||(t=i,r()),n=i}}},{113:113,18:18,40:40}],69:[function(t,n,r){\"use strict\";function PromiseCapability(t){var n,r;this.promise=new t(function(t,e){if(void 0!==n||void 0!==r)throw TypeError(\"Bad Promise constructor\");n=t,r=e}),this.resolve=e(n),this.reject=e(r)}var e=t(3);n.exports.f=function(t){return new PromiseCapability(t)}},{3:3}],70:[function(t,n,r){\"use strict\";var e=t(81),i=t(78),o=t(82),u=t(119),c=t(47),a=Object.assign;n.exports=!a||t(35)(function(){var t={},n={},r=Symbol(),e=\"abcdefghijklmnopqrst\";return t[r]=7,e.split(\"\").forEach(function(t){n[t]=t}),7!=a({},t)[r]||Object.keys(a({},n)).join(\"\")!=e})?function assign(t,n){for(var r=u(t),a=arguments.length,f=1,s=i.f,l=o.f;a>f;)for(var h,v=c(arguments[f++]),p=s?e(v).concat(s(v)):e(v),d=p.length,y=0;d>y;)l.call(v,h=p[y++])&&(r[h]=v[h]);return r}:a},{119:119,35:35,47:47,78:78,81:81,82:82}],71:[function(t,n,r){var e=t(7),i=t(73),o=t(31),u=t(102)(\"IE_PROTO\"),c=function(){},a=function(){var n,r=t(30)(\"iframe\"),e=o.length;for(r.style.display=\"none\",t(43).appendChild(r),r.src=\"javascript:\",n=r.contentWindow.document,n.open(),n.write(\"<script>document.F=Object<\\/script>\"),n.close(),a=n.F;e--;)delete a.prototype[o[e]];return a()};n.exports=Object.create||function create(t,n){var r;return null!==t?(c.prototype=e(t),r=new c,c.prototype=null,r[u]=t):r=a(),void 0===n?r:i(r,n)}},{102:102,30:30,31:31,43:43,7:7,73:73}],72:[function(t,n,r){var e=t(7),i=t(44),o=t(120),u=Object.defineProperty;r.f=t(29)?Object.defineProperty:function defineProperty(t,n,r){if(e(t),n=o(n,!0),e(r),i)try{return u(t,n,r)}catch(t){}if(\"get\"in r||\"set\"in r)throw TypeError(\"Accessors not supported!\");return\"value\"in r&&(t[n]=r.value),t}},{120:120,29:29,44:44,7:7}],73:[function(t,n,r){var e=t(72),i=t(7),o=t(81);n.exports=t(29)?Object.defineProperties:function defineProperties(t,n){i(t);for(var r,u=o(n),c=u.length,a=0;c>a;)e.f(t,r=u[a++],n[r]);return t}},{29:29,7:7,72:72,81:81}],74:[function(t,n,r){\"use strict\";n.exports=t(60)||!t(35)(function(){var n=Math.random();__defineSetter__.call(null,n,function(){}),delete t(40)[n]})},{35:35,40:40,60:60}],75:[function(t,n,r){var e=t(82),i=t(92),o=t(117),u=t(120),c=t(41),a=t(44),f=Object.getOwnPropertyDescriptor;r.f=t(29)?f:function getOwnPropertyDescriptor(t,n){if(t=o(t),n=u(n,!0),a)try{return f(t,n)}catch(t){}if(c(t,n))return i(!e.f.call(t,n),t[n])}},{117:117,120:120,29:29,41:41,44:44,82:82,92:92}],76:[function(t,n,r){var e=t(117),i=t(77).f,o={}.toString,u=\"object\"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[],c=function(t){try{return i(t)}catch(t){return u.slice()}};n.exports.f=function getOwnPropertyNames(t){return u&&\"[object Window]\"==o.call(t)?c(t):i(e(t))}},{117:117,77:77}],77:[function(t,n,r){var e=t(80),i=t(31).concat(\"length\",\"prototype\");r.f=Object.getOwnPropertyNames||function getOwnPropertyNames(t){return e(t,i)}},{31:31,80:80}],78:[function(t,n,r){r.f=Object.getOwnPropertySymbols},{}],79:[function(t,n,r){var e=t(41),i=t(119),o=t(102)(\"IE_PROTO\"),u=Object.prototype;n.exports=Object.getPrototypeOf||function(t){return t=i(t),e(t,o)?t[o]:\"function\"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?u:null}},{102:102,119:119,41:41}],80:[function(t,n,r){var e=t(41),i=t(117),o=t(11)(!1),u=t(102)(\"IE_PROTO\");n.exports=function(t,n){var r,c=i(t),a=0,f=[];for(r in c)r!=u&&e(c,r)&&f.push(r);for(;n.length>a;)e(c,r=n[a++])&&(~o(f,r)||f.push(r));return f}},{102:102,11:11,117:117,41:41}],81:[function(t,n,r){var e=t(80),i=t(31);n.exports=Object.keys||function keys(t){return e(t,i)}},{31:31,80:80}],82:[function(t,n,r){r.f={}.propertyIsEnumerable},{}],83:[function(t,n,r){var e=t(33),i=t(23),o=t(35);n.exports=function(t,n){var r=(i.Object||{})[t]||Object[t],u={};u[t]=n(r),e(e.S+e.F*o(function(){r(1)}),\"Object\",u)}},{23:23,33:33,35:35}],84:[function(t,n,r){var e=t(81),i=t(117),o=t(82).f;n.exports=function(t){return function(n){for(var r,u=i(n),c=e(u),a=c.length,f=0,s=[];a>f;)o.call(u,r=c[f++])&&s.push(t?[r,u[r]]:u[r]);return s}}},{117:117,81:81,82:82}],85:[function(t,n,r){var e=t(77),i=t(78),o=t(7),u=t(40).Reflect;n.exports=u&&u.ownKeys||function ownKeys(t){var n=e.f(o(t)),r=i.f;return r?n.concat(r(t)):n}},{40:40,7:7,77:77,78:78}],86:[function(t,n,r){var e=t(40).parseFloat,i=t(111).trim;n.exports=1/e(t(112)+\"-0\")!=-1/0?function parseFloat(t){var n=i(String(t),3),r=e(n);return 0===r&&\"-\"==n.charAt(0)?-0:r}:e},{111:111,112:112,40:40}],87:[function(t,n,r){var e=t(40).parseInt,i=t(111).trim,o=t(112),u=/^[-+]?0[xX]/;n.exports=8!==e(o+\"08\")||22!==e(o+\"0x16\")?function parseInt(t,n){var r=i(String(t),3);return e(r,n>>>0||(u.test(r)?16:10))}:e},{111:111,112:112,40:40}],88:[function(t,n,r){\"use strict\";var e=t(89),i=t(46),o=t(3);n.exports=function(){for(var t=o(this),n=arguments.length,r=Array(n),u=0,c=e._,a=!1;n>u;)(r[u]=arguments[u++])===c&&(a=!0);return function(){var e,o=this,u=arguments.length,f=0,s=0;if(!a&&!u)return i(t,r,o);if(e=r.slice(),a)for(;n>f;f++)e[f]===c&&(e[f]=arguments[s++]);for(;u>s;)e.push(arguments[s++]);return i(t,e,o)}}},{3:3,46:46,89:89}],89:[function(t,n,r){n.exports=t(40)},{40:40}],90:[function(t,n,r){n.exports=function(t){try{return{e:!1,v:t()}}catch(t){return{e:!0,v:t}}}},{}],91:[function(t,n,r){var e=t(69);n.exports=function(t,n){var r=e.f(t);return(0,r.resolve)(n),r.promise}},{69:69}],92:[function(t,n,r){n.exports=function(t,n){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:n}}},{}],93:[function(t,n,r){var e=t(94);n.exports=function(t,n,r){for(var i in n)e(t,i,n[i],r);return t}},{94:94}],94:[function(t,n,r){var e=t(40),i=t(42),o=t(41),u=t(124)(\"src\"),c=Function.toString,a=(\"\"+c).split(\"toString\");t(23).inspectSource=function(t){return c.call(t)},(n.exports=function(t,n,r,c){var f=\"function\"==typeof r;f&&(o(r,\"name\")||i(r,\"name\",n)),t[n]!==r&&(f&&(o(r,u)||i(r,u,t[n]?\"\"+t[n]:a.join(String(n)))),t===e?t[n]=r:c?t[n]?t[n]=r:i(t,n,r):(delete t[n],i(t,n,r)))})(Function.prototype,\"toString\",function toString(){return\"function\"==typeof this&&this[u]||c.call(this)})},{124:124,23:23,40:40,41:41,42:42}],95:[function(t,n,r){n.exports=function(t,n){var r=n===Object(n)?function(t){return n[t]}:n;return function(n){return String(n).replace(t,r)}}},{}],96:[function(t,n,r){n.exports=Object.is||function is(t,n){return t===n?0!==t||1/t==1/n:t!=t&&n!=n}},{}],97:[function(t,n,r){\"use strict\";var e=t(33),i=t(3),o=t(25),u=t(39);n.exports=function(t){e(e.S,t,{from:function from(t){var n,r,e,c,a=arguments[1];return i(this),n=void 0!==a,n&&i(a),void 0==t?new this:(r=[],n?(e=0,c=o(a,arguments[2],2),u(t,!1,function(t){r.push(c(t,e++))})):u(t,!1,r.push,r),new this(r))}})}},{25:25,3:3,33:33,39:39}],98:[function(t,n,r){\"use strict\";var e=t(33);n.exports=function(t){e(e.S,t,{of:function of(){for(var t=arguments.length,n=Array(t);t--;)n[t]=arguments[t];return new this(n)}})}},{33:33}],99:[function(t,n,r){var e=t(51),i=t(7),o=function(t,n){if(i(t),!e(n)&&null!==n)throw TypeError(n+\": can't set as prototype!\")};n.exports={set:Object.setPrototypeOf||(\"__proto__\"in{}?function(n,r,e){try{e=t(25)(Function.call,t(75).f(Object.prototype,\"__proto__\").set,2),e(n,[]),r=!(n instanceof Array)}catch(t){r=!0}return function setPrototypeOf(t,n){return o(t,n),r?t.__proto__=n:e(t,n),t}}({},!1):void 0),check:o}},{25:25,51:51,7:7,75:75}],100:[function(t,n,r){\"use strict\";var e=t(40),i=t(72),o=t(29),u=t(128)(\"species\");n.exports=function(t){var n=e[t];o&&n&&!n[u]&&i.f(n,u,{configurable:!0,get:function(){return this}})}},{128:128,29:29,40:40,72:72}],101:[function(t,n,r){var e=t(72).f,i=t(41),o=t(128)(\"toStringTag\");n.exports=function(t,n,r){t&&!i(t=r?t:t.prototype,o)&&e(t,o,{configurable:!0,value:n})}},{128:128,41:41,72:72}],102:[function(t,n,r){var e=t(103)(\"keys\"),i=t(124);n.exports=function(t){return e[t]||(e[t]=i(t))}},{103:103,124:124}],103:[function(t,n,r){var e=t(40),i=e[\"__core-js_shared__\"]||(e[\"__core-js_shared__\"]={});n.exports=function(t){return i[t]||(i[t]={})}},{40:40}],104:[function(t,n,r){var e=t(7),i=t(3),o=t(128)(\"species\");n.exports=function(t,n){var r,u=e(t).constructor;return void 0===u||void 0==(r=e(u)[o])?n:i(r)}},{128:128,3:3,7:7}],105:[function(t,n,r){\"use strict\";var e=t(35);n.exports=function(t,n){return!!t&&e(function(){n?t.call(null,function(){},1):t.call(null)})}},{35:35}],106:[function(t,n,r){var e=t(116),i=t(28);n.exports=function(t){return function(n,r){var o,u,c=String(i(n)),a=e(r),f=c.length;return a<0||a>=f?t?\"\":void 0:(o=c.charCodeAt(a),o<55296||o>56319||a+1===f||(u=c.charCodeAt(a+1))<56320||u>57343?t?c.charAt(a):o:t?c.slice(a,a+2):u-56320+(o-55296<<10)+65536)}}},{116:116,28:28}],107:[function(t,n,r){var e=t(52),i=t(28);n.exports=function(t,n,r){if(e(n))throw TypeError(\"String#\"+r+\" doesn't accept regex!\");return String(i(t))}},{28:28,52:52}],108:[function(t,n,r){var e=t(33),i=t(35),o=t(28),u=/\"/g,c=function(t,n,r,e){var i=String(o(t)),c=\"<\"+n;return\"\"!==r&&(c+=\" \"+r+'=\"'+String(e).replace(u,\"&quot;\")+'\"'),c+\">\"+i+\"</\"+n+\">\"};n.exports=function(t,n){var r={};r[t]=n(c),e(e.P+e.F*i(function(){var n=\"\"[t]('\"');return n!==n.toLowerCase()||n.split('\"').length>3}),\"String\",r)}},{28:28,33:33,35:35}],109:[function(t,n,r){var e=t(118),i=t(110),o=t(28);n.exports=function(t,n,r,u){var c=String(o(t)),a=c.length,f=void 0===r?\" \":String(r),s=e(n);if(s<=a||\"\"==f)return c;var l=s-a,h=i.call(f,Math.ceil(l/f.length));return h.length>l&&(h=h.slice(0,l)),u?h+c:c+h}},{110:110,118:118,28:28}],110:[function(t,n,r){\"use strict\";var e=t(116),i=t(28);n.exports=function repeat(t){var n=String(i(this)),r=\"\",o=e(t);if(o<0||o==1/0)throw RangeError(\"Count can't be negative\");for(;o>0;(o>>>=1)&&(n+=n))1&o&&(r+=n);return r}},{116:116,28:28}],111:[function(t,n,r){var e=t(33),i=t(28),o=t(35),u=t(112),c=\"[\"+u+\"]\",a=\"\u200b\u0085\",f=RegExp(\"^\"+c+c+\"*\"),s=RegExp(c+c+\"*$\"),l=function(t,n,r){var i={},c=o(function(){return!!u[t]()||a[t]()!=a}),f=i[t]=c?n(h):u[t];r&&(i[r]=f),e(e.P+e.F*c,\"String\",i)},h=l.trim=function(t,n){return t=String(i(t)),1&n&&(t=t.replace(f,\"\")),2&n&&(t=t.replace(s,\"\")),t};n.exports=l},{112:112,28:28,33:33,35:35}],112:[function(t,n,r){n.exports=\"\\t\\n\\v\\f\\r \u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\\u2028\\u2029\\ufeff\"},{}],113:[function(t,n,r){var e,i,o,u=t(25),c=t(46),a=t(43),f=t(30),s=t(40),l=s.process,h=s.setImmediate,v=s.clearImmediate,p=s.MessageChannel,d=s.Dispatch,y=0,g={},m=function(){var t=+this;if(g.hasOwnProperty(t)){var n=g[t];delete g[t],n()}},b=function(t){m.call(t.data)};h&&v||(h=function setImmediate(t){for(var n=[],r=1;arguments.length>r;)n.push(arguments[r++]);return g[++y]=function(){c(\"function\"==typeof t?t:Function(t),n)},e(y),y},v=function clearImmediate(t){delete g[t]},\"process\"==t(18)(l)?e=function(t){l.nextTick(u(m,t,1))}:d&&d.now?e=function(t){d.now(u(m,t,1))}:p?(i=new p,o=i.port2,i.port1.onmessage=b,e=u(o.postMessage,o,1)):s.addEventListener&&\"function\"==typeof postMessage&&!s.importScripts?(e=function(t){s.postMessage(t+\"\",\"*\")},s.addEventListener(\"message\",b,!1)):e=\"onreadystatechange\"in f(\"script\")?function(t){a.appendChild(f(\"script\")).onreadystatechange=function(){a.removeChild(this),m.call(t)}}:function(t){setTimeout(u(m,t,1),0)}),n.exports={set:h,clear:v}},{18:18,25:25,30:30,40:40,43:43,46:46}],114:[function(t,n,r){var e=t(116),i=Math.max,o=Math.min;n.exports=function(t,n){return t=e(t),t<0?i(t+n,0):o(t,n)}},{116:116}],115:[function(t,n,r){var e=t(116),i=t(118);n.exports=function(t){if(void 0===t)return 0;var n=e(t),r=i(n);if(n!==r)throw RangeError(\"Wrong length!\");return r}},{116:116,118:118}],116:[function(t,n,r){var e=Math.ceil,i=Math.floor;n.exports=function(t){return isNaN(t=+t)?0:(t>0?i:e)(t)}},{}],117:[function(t,n,r){var e=t(47),i=t(28);n.exports=function(t){return e(i(t))}},{28:28,47:47}],118:[function(t,n,r){var e=t(116),i=Math.min;n.exports=function(t){return t>0?i(e(t),9007199254740991):0}},{116:116}],\n119:[function(t,n,r){var e=t(28);n.exports=function(t){return Object(e(t))}},{28:28}],120:[function(t,n,r){var e=t(51);n.exports=function(t,n){if(!e(t))return t;var r,i;if(n&&\"function\"==typeof(r=t.toString)&&!e(i=r.call(t)))return i;if(\"function\"==typeof(r=t.valueOf)&&!e(i=r.call(t)))return i;if(!n&&\"function\"==typeof(r=t.toString)&&!e(i=r.call(t)))return i;throw TypeError(\"Can't convert object to primitive value\")}},{51:51}],121:[function(t,n,r){\"use strict\";if(t(29)){var e=t(60),i=t(40),o=t(35),u=t(33),c=t(123),a=t(122),f=t(25),s=t(6),l=t(92),h=t(42),v=t(93),p=t(116),d=t(118),y=t(115),g=t(114),m=t(120),b=t(41),x=t(17),S=t(51),w=t(119),_=t(48),E=t(71),O=t(79),P=t(77).f,M=t(129),F=t(124),I=t(128),A=t(12),k=t(11),N=t(104),j=t(141),T=t(58),R=t(56),L=t(100),G=t(9),D=t(8),C=t(72),W=t(75),U=C.f,B=W.f,V=i.RangeError,z=i.TypeError,q=i.Uint8Array,K=Array.prototype,Y=a.ArrayBuffer,J=a.DataView,H=A(0),X=A(2),$=A(3),Z=A(4),Q=A(5),tt=A(6),nt=k(!0),rt=k(!1),et=j.values,it=j.keys,ot=j.entries,ut=K.lastIndexOf,ct=K.reduce,at=K.reduceRight,ft=K.join,st=K.sort,lt=K.slice,ht=K.toString,vt=K.toLocaleString,pt=I(\"iterator\"),dt=I(\"toStringTag\"),yt=F(\"typed_constructor\"),gt=F(\"def_constructor\"),mt=c.CONSTR,bt=c.TYPED,xt=c.VIEW,St=A(1,function(t,n){return Pt(N(t,t[gt]),n)}),wt=o(function(){return 1===new q(new Uint16Array([1]).buffer)[0]}),_t=!!q&&!!q.prototype.set&&o(function(){new q(1).set({})}),Et=function(t,n){var r=p(t);if(r<0||r%n)throw V(\"Wrong offset!\");return r},Ot=function(t){if(S(t)&&bt in t)return t;throw z(t+\" is not a typed array!\")},Pt=function(t,n){if(!(S(t)&&yt in t))throw z(\"It is not a typed array constructor!\");return new t(n)},Mt=function(t,n){return Ft(N(t,t[gt]),n)},Ft=function(t,n){for(var r=0,e=n.length,i=Pt(t,e);e>r;)i[r]=n[r++];return i},It=function(t,n,r){U(t,n,{get:function(){return this._d[r]}})},At=function from(t){var n,r,e,i,o,u,c=w(t),a=arguments.length,s=a>1?arguments[1]:void 0,l=void 0!==s,h=M(c);if(void 0!=h&&!_(h)){for(u=h.call(c),e=[],n=0;!(o=u.next()).done;n++)e.push(o.value);c=e}for(l&&a>2&&(s=f(s,arguments[2],2)),n=0,r=d(c.length),i=Pt(this,r);r>n;n++)i[n]=l?s(c[n],n):c[n];return i},kt=function of(){for(var t=0,n=arguments.length,r=Pt(this,n);n>t;)r[t]=arguments[t++];return r},Nt=!!q&&o(function(){vt.call(new q(1))}),jt=function toLocaleString(){return vt.apply(Nt?lt.call(Ot(this)):Ot(this),arguments)},Tt={copyWithin:function copyWithin(t,n){return D.call(Ot(this),t,n,arguments.length>2?arguments[2]:void 0)},every:function every(t){return Z(Ot(this),t,arguments.length>1?arguments[1]:void 0)},fill:function fill(t){return G.apply(Ot(this),arguments)},filter:function filter(t){return Mt(this,X(Ot(this),t,arguments.length>1?arguments[1]:void 0))},find:function find(t){return Q(Ot(this),t,arguments.length>1?arguments[1]:void 0)},findIndex:function findIndex(t){return tt(Ot(this),t,arguments.length>1?arguments[1]:void 0)},forEach:function forEach(t){H(Ot(this),t,arguments.length>1?arguments[1]:void 0)},indexOf:function indexOf(t){return rt(Ot(this),t,arguments.length>1?arguments[1]:void 0)},includes:function includes(t){return nt(Ot(this),t,arguments.length>1?arguments[1]:void 0)},join:function join(t){return ft.apply(Ot(this),arguments)},lastIndexOf:function lastIndexOf(t){return ut.apply(Ot(this),arguments)},map:function map(t){return St(Ot(this),t,arguments.length>1?arguments[1]:void 0)},reduce:function reduce(t){return ct.apply(Ot(this),arguments)},reduceRight:function reduceRight(t){return at.apply(Ot(this),arguments)},reverse:function reverse(){for(var t,n=this,r=Ot(n).length,e=Math.floor(r/2),i=0;i<e;)t=n[i],n[i++]=n[--r],n[r]=t;return n},some:function some(t){return $(Ot(this),t,arguments.length>1?arguments[1]:void 0)},sort:function sort(t){return st.call(Ot(this),t)},subarray:function subarray(t,n){var r=Ot(this),e=r.length,i=g(t,e);return new(N(r,r[gt]))(r.buffer,r.byteOffset+i*r.BYTES_PER_ELEMENT,d((void 0===n?e:g(n,e))-i))}},Rt=function slice(t,n){return Mt(this,lt.call(Ot(this),t,n))},Lt=function set(t){Ot(this);var n=Et(arguments[1],1),r=this.length,e=w(t),i=d(e.length),o=0;if(i+n>r)throw V(\"Wrong length!\");for(;o<i;)this[n+o]=e[o++]},Gt={entries:function entries(){return ot.call(Ot(this))},keys:function keys(){return it.call(Ot(this))},values:function values(){return et.call(Ot(this))}},Dt=function(t,n){return S(t)&&t[bt]&&\"symbol\"!=typeof n&&n in t&&String(+n)==String(n)},Ct=function getOwnPropertyDescriptor(t,n){return Dt(t,n=m(n,!0))?l(2,t[n]):B(t,n)},Wt=function defineProperty(t,n,r){return!(Dt(t,n=m(n,!0))&&S(r)&&b(r,\"value\"))||b(r,\"get\")||b(r,\"set\")||r.configurable||b(r,\"writable\")&&!r.writable||b(r,\"enumerable\")&&!r.enumerable?U(t,n,r):(t[n]=r.value,t)};mt||(W.f=Ct,C.f=Wt),u(u.S+u.F*!mt,\"Object\",{getOwnPropertyDescriptor:Ct,defineProperty:Wt}),o(function(){ht.call({})})&&(ht=vt=function toString(){return ft.call(this)});var Ut=v({},Tt);v(Ut,Gt),h(Ut,pt,Gt.values),v(Ut,{slice:Rt,set:Lt,constructor:function(){},toString:ht,toLocaleString:jt}),It(Ut,\"buffer\",\"b\"),It(Ut,\"byteOffset\",\"o\"),It(Ut,\"byteLength\",\"l\"),It(Ut,\"length\",\"e\"),U(Ut,dt,{get:function(){return this[bt]}}),n.exports=function(t,n,r,a){a=!!a;var f=t+(a?\"Clamped\":\"\")+\"Array\",l=\"get\"+t,v=\"set\"+t,p=i[f],g=p||{},m=p&&O(p),b=!p||!c.ABV,w={},_=p&&p.prototype,M=function(t,r){var e=t._d;return e.v[l](r*n+e.o,wt)},F=function(t,r,e){var i=t._d;a&&(e=(e=Math.round(e))<0?0:e>255?255:255&e),i.v[v](r*n+i.o,e,wt)},I=function(t,n){U(t,n,{get:function(){return M(this,n)},set:function(t){return F(this,n,t)},enumerable:!0})};b?(p=r(function(t,r,e,i){s(t,p,f,\"_d\");var o,u,c,a,l=0,v=0;if(S(r)){if(!(r instanceof Y||\"ArrayBuffer\"==(a=x(r))||\"SharedArrayBuffer\"==a))return bt in r?Ft(p,r):At.call(p,r);o=r,v=Et(e,n);var g=r.byteLength;if(void 0===i){if(g%n)throw V(\"Wrong length!\");if((u=g-v)<0)throw V(\"Wrong length!\")}else if((u=d(i)*n)+v>g)throw V(\"Wrong length!\");c=u/n}else c=y(r),u=c*n,o=new Y(u);for(h(t,\"_d\",{b:o,o:v,l:u,e:c,v:new J(o)});l<c;)I(t,l++)}),_=p.prototype=E(Ut),h(_,\"constructor\",p)):o(function(){p(1)})&&o(function(){new p(-1)})&&R(function(t){new p,new p(null),new p(1.5),new p(t)},!0)||(p=r(function(t,r,e,i){s(t,p,f);var o;return S(r)?r instanceof Y||\"ArrayBuffer\"==(o=x(r))||\"SharedArrayBuffer\"==o?void 0!==i?new g(r,Et(e,n),i):void 0!==e?new g(r,Et(e,n)):new g(r):bt in r?Ft(p,r):At.call(p,r):new g(y(r))}),H(m!==Function.prototype?P(g).concat(P(m)):P(g),function(t){t in p||h(p,t,g[t])}),p.prototype=_,e||(_.constructor=p));var A=_[pt],k=!!A&&(\"values\"==A.name||void 0==A.name),N=Gt.values;h(p,yt,!0),h(_,bt,f),h(_,xt,!0),h(_,gt,p),(a?new p(1)[dt]==f:dt in _)||U(_,dt,{get:function(){return f}}),w[f]=p,u(u.G+u.W+u.F*(p!=g),w),u(u.S,f,{BYTES_PER_ELEMENT:n}),u(u.S+u.F*o(function(){g.of.call(p,1)}),f,{from:At,of:kt}),\"BYTES_PER_ELEMENT\"in _||h(_,\"BYTES_PER_ELEMENT\",n),u(u.P,f,Tt),L(f),u(u.P+u.F*_t,f,{set:Lt}),u(u.P+u.F*!k,f,Gt),e||_.toString==ht||(_.toString=ht),u(u.P+u.F*o(function(){new p(1).slice()}),f,{slice:Rt}),u(u.P+u.F*(o(function(){return[1,2].toLocaleString()!=new p([1,2]).toLocaleString()})||!o(function(){_.toLocaleString.call([1,2])})),f,{toLocaleString:jt}),T[f]=k?A:N,e||k||h(_,pt,N)}}else n.exports=function(){}},{100:100,104:104,11:11,114:114,115:115,116:116,118:118,119:119,12:12,120:120,122:122,123:123,124:124,128:128,129:129,141:141,17:17,25:25,29:29,33:33,35:35,40:40,41:41,42:42,48:48,51:51,56:56,58:58,6:6,60:60,71:71,72:72,75:75,77:77,79:79,8:8,9:9,92:92,93:93}],122:[function(t,n,r){\"use strict\";function packIEEE754(t,n,r){var e,i,o,u=Array(r),c=8*r-n-1,a=(1<<c)-1,f=a>>1,s=23===n?M(2,-24)-M(2,-77):0,l=0,h=t<0||0===t&&1/t<0?1:0;for(t=P(t),t!=t||t===E?(i=t!=t?1:0,e=a):(e=F(I(t)/A),t*(o=M(2,-e))<1&&(e--,o*=2),t+=e+f>=1?s/o:s*M(2,1-f),t*o>=2&&(e++,o/=2),e+f>=a?(i=0,e=a):e+f>=1?(i=(t*o-1)*M(2,n),e+=f):(i=t*M(2,f-1)*M(2,n),e=0));n>=8;u[l++]=255&i,i/=256,n-=8);for(e=e<<n|i,c+=n;c>0;u[l++]=255&e,e/=256,c-=8);return u[--l]|=128*h,u}function unpackIEEE754(t,n,r){var e,i=8*r-n-1,o=(1<<i)-1,u=o>>1,c=i-7,a=r-1,f=t[a--],s=127&f;for(f>>=7;c>0;s=256*s+t[a],a--,c-=8);for(e=s&(1<<-c)-1,s>>=-c,c+=n;c>0;e=256*e+t[a],a--,c-=8);if(0===s)s=1-u;else{if(s===o)return e?NaN:f?-E:E;e+=M(2,n),s-=u}return(f?-1:1)*e*M(2,s-n)}function unpackI32(t){return t[3]<<24|t[2]<<16|t[1]<<8|t[0]}function packI8(t){return[255&t]}function packI16(t){return[255&t,t>>8&255]}function packI32(t){return[255&t,t>>8&255,t>>16&255,t>>24&255]}function packF64(t){return packIEEE754(t,52,8)}function packF32(t){return packIEEE754(t,23,4)}function addGetter(t,n,r){d(t[m],n,{get:function(){return this[r]}})}function get(t,n,r,e){var i=+r,o=v(i);if(o+n>t[N])throw _(b);var u=t[k]._b,c=o+t[j],a=u.slice(c,c+n);return e?a:a.reverse()}function set(t,n,r,e,i,o){var u=+r,c=v(u);if(c+n>t[N])throw _(b);for(var a=t[k]._b,f=c+t[j],s=e(+i),l=0;l<n;l++)a[f+l]=s[o?l:n-l-1]}var e=t(40),i=t(29),o=t(60),u=t(123),c=t(42),a=t(93),f=t(35),s=t(6),l=t(116),h=t(118),v=t(115),p=t(77).f,d=t(72).f,y=t(9),g=t(101),m=\"prototype\",b=\"Wrong index!\",x=e.ArrayBuffer,S=e.DataView,w=e.Math,_=e.RangeError,E=e.Infinity,O=x,P=w.abs,M=w.pow,F=w.floor,I=w.log,A=w.LN2,k=i?\"_b\":\"buffer\",N=i?\"_l\":\"byteLength\",j=i?\"_o\":\"byteOffset\";if(u.ABV){if(!f(function(){x(1)})||!f(function(){new x(-1)})||f(function(){return new x,new x(1.5),new x(NaN),\"ArrayBuffer\"!=x.name})){x=function ArrayBuffer(t){return s(this,x),new O(v(t))};for(var T,R=x[m]=O[m],L=p(O),G=0;L.length>G;)(T=L[G++])in x||c(x,T,O[T]);o||(R.constructor=x)}var D=new S(new x(2)),C=S[m].setInt8;D.setInt8(0,2147483648),D.setInt8(1,2147483649),!D.getInt8(0)&&D.getInt8(1)||a(S[m],{setInt8:function setInt8(t,n){C.call(this,t,n<<24>>24)},setUint8:function setUint8(t,n){C.call(this,t,n<<24>>24)}},!0)}else x=function ArrayBuffer(t){s(this,x,\"ArrayBuffer\");var n=v(t);this._b=y.call(Array(n),0),this[N]=n},S=function DataView(t,n,r){s(this,S,\"DataView\"),s(t,x,\"DataView\");var e=t[N],i=l(n);if(i<0||i>e)throw _(\"Wrong offset!\");if(r=void 0===r?e-i:h(r),i+r>e)throw _(\"Wrong length!\");this[k]=t,this[j]=i,this[N]=r},i&&(addGetter(x,\"byteLength\",\"_l\"),addGetter(S,\"buffer\",\"_b\"),addGetter(S,\"byteLength\",\"_l\"),addGetter(S,\"byteOffset\",\"_o\")),a(S[m],{getInt8:function getInt8(t){return get(this,1,t)[0]<<24>>24},getUint8:function getUint8(t){return get(this,1,t)[0]},getInt16:function getInt16(t){var n=get(this,2,t,arguments[1]);return(n[1]<<8|n[0])<<16>>16},getUint16:function getUint16(t){var n=get(this,2,t,arguments[1]);return n[1]<<8|n[0]},getInt32:function getInt32(t){return unpackI32(get(this,4,t,arguments[1]))},getUint32:function getUint32(t){return unpackI32(get(this,4,t,arguments[1]))>>>0},getFloat32:function getFloat32(t){return unpackIEEE754(get(this,4,t,arguments[1]),23,4)},getFloat64:function getFloat64(t){return unpackIEEE754(get(this,8,t,arguments[1]),52,8)},setInt8:function setInt8(t,n){set(this,1,t,packI8,n)},setUint8:function setUint8(t,n){set(this,1,t,packI8,n)},setInt16:function setInt16(t,n){set(this,2,t,packI16,n,arguments[2])},setUint16:function setUint16(t,n){set(this,2,t,packI16,n,arguments[2])},setInt32:function setInt32(t,n){set(this,4,t,packI32,n,arguments[2])},setUint32:function setUint32(t,n){set(this,4,t,packI32,n,arguments[2])},setFloat32:function setFloat32(t,n){set(this,4,t,packF32,n,arguments[2])},setFloat64:function setFloat64(t,n){set(this,8,t,packF64,n,arguments[2])}});g(x,\"ArrayBuffer\"),g(S,\"DataView\"),c(S[m],u.VIEW,!0),r.ArrayBuffer=x,r.DataView=S},{101:101,115:115,116:116,118:118,123:123,29:29,35:35,40:40,42:42,6:6,60:60,72:72,77:77,9:9,93:93}],123:[function(t,n,r){for(var e,i=t(40),o=t(42),u=t(124),c=u(\"typed_array\"),a=u(\"view\"),f=!(!i.ArrayBuffer||!i.DataView),s=f,l=0,h=\"Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array\".split(\",\");l<9;)(e=i[h[l++]])?(o(e.prototype,c,!0),o(e.prototype,a,!0)):s=!1;n.exports={ABV:f,CONSTR:s,TYPED:c,VIEW:a}},{124:124,40:40,42:42}],124:[function(t,n,r){var e=0,i=Math.random();n.exports=function(t){return\"Symbol(\".concat(void 0===t?\"\":t,\")_\",(++e+i).toString(36))}},{}],125:[function(t,n,r){var e=t(51);n.exports=function(t,n){if(!e(t)||t._t!==n)throw TypeError(\"Incompatible receiver, \"+n+\" required!\");return t}},{51:51}],126:[function(t,n,r){var e=t(40),i=t(23),o=t(60),u=t(127),c=t(72).f;n.exports=function(t){var n=i.Symbol||(i.Symbol=o?{}:e.Symbol||{});\"_\"==t.charAt(0)||t in n||c(n,t,{value:u.f(t)})}},{127:127,23:23,40:40,60:60,72:72}],127:[function(t,n,r){r.f=t(128)},{128:128}],128:[function(t,n,r){var e=t(103)(\"wks\"),i=t(124),o=t(40).Symbol,u=\"function\"==typeof o;(n.exports=function(t){return e[t]||(e[t]=u&&o[t]||(u?o:i)(\"Symbol.\"+t))}).store=e},{103:103,124:124,40:40}],129:[function(t,n,r){var e=t(17),i=t(128)(\"iterator\"),o=t(58);n.exports=t(23).getIteratorMethod=function(t){if(void 0!=t)return t[i]||t[\"@@iterator\"]||o[e(t)]}},{128:128,17:17,23:23,58:58}],130:[function(t,n,r){var e=t(33),i=t(95)(/[\\\\^$*+?.()|[\\]{}]/g,\"\\\\$&\");e(e.S,\"RegExp\",{escape:function escape(t){return i(t)}})},{33:33,95:95}],131:[function(t,n,r){var e=t(33);e(e.P,\"Array\",{copyWithin:t(8)}),t(5)(\"copyWithin\")},{33:33,5:5,8:8}],132:[function(t,n,r){\"use strict\";var e=t(33),i=t(12)(4);e(e.P+e.F*!t(105)([].every,!0),\"Array\",{every:function every(t){return i(this,t,arguments[1])}})},{105:105,12:12,33:33}],133:[function(t,n,r){var e=t(33);e(e.P,\"Array\",{fill:t(9)}),t(5)(\"fill\")},{33:33,5:5,9:9}],134:[function(t,n,r){\"use strict\";var e=t(33),i=t(12)(2);e(e.P+e.F*!t(105)([].filter,!0),\"Array\",{filter:function filter(t){return i(this,t,arguments[1])}})},{105:105,12:12,33:33}],135:[function(t,n,r){\"use strict\";var e=t(33),i=t(12)(6),o=\"findIndex\",u=!0;o in[]&&Array(1)[o](function(){u=!1}),e(e.P+e.F*u,\"Array\",{findIndex:function findIndex(t){return i(this,t,arguments.length>1?arguments[1]:void 0)}}),t(5)(o)},{12:12,33:33,5:5}],136:[function(t,n,r){\"use strict\";var e=t(33),i=t(12)(5),o=!0;\"find\"in[]&&Array(1).find(function(){o=!1}),e(e.P+e.F*o,\"Array\",{find:function find(t){return i(this,t,arguments.length>1?arguments[1]:void 0)}}),t(5)(\"find\")},{12:12,33:33,5:5}],137:[function(t,n,r){\"use strict\";var e=t(33),i=t(12)(0),o=t(105)([].forEach,!0);e(e.P+e.F*!o,\"Array\",{forEach:function forEach(t){return i(this,t,arguments[1])}})},{105:105,12:12,33:33}],138:[function(t,n,r){\"use strict\";var e=t(25),i=t(33),o=t(119),u=t(53),c=t(48),a=t(118),f=t(24),s=t(129);i(i.S+i.F*!t(56)(function(t){Array.from(t)}),\"Array\",{from:function from(t){var n,r,i,l,h=o(t),v=\"function\"==typeof this?this:Array,p=arguments.length,d=p>1?arguments[1]:void 0,y=void 0!==d,g=0,m=s(h);if(y&&(d=e(d,p>2?arguments[2]:void 0,2)),void 0==m||v==Array&&c(m))for(n=a(h.length),r=new v(n);n>g;g++)f(r,g,y?d(h[g],g):h[g]);else for(l=m.call(h),r=new v;!(i=l.next()).done;g++)f(r,g,y?u(l,d,[i.value,g],!0):i.value);return r.length=g,r}})},{118:118,119:119,129:129,24:24,25:25,33:33,48:48,53:53,56:56}],139:[function(t,n,r){\"use strict\";var e=t(33),i=t(11)(!1),o=[].indexOf,u=!!o&&1/[1].indexOf(1,-0)<0;e(e.P+e.F*(u||!t(105)(o)),\"Array\",{indexOf:function indexOf(t){return u?o.apply(this,arguments)||0:i(this,t,arguments[1])}})},{105:105,11:11,33:33}],140:[function(t,n,r){var e=t(33);e(e.S,\"Array\",{isArray:t(49)})},{33:33,49:49}],141:[function(t,n,r){\"use strict\";var e=t(5),i=t(57),o=t(58),u=t(117);n.exports=t(55)(Array,\"Array\",function(t,n){this._t=u(t),this._i=0,this._k=n},function(){var t=this._t,n=this._k,r=this._i++;return!t||r>=t.length?(this._t=void 0,i(1)):\"keys\"==n?i(0,r):\"values\"==n?i(0,t[r]):i(0,[r,t[r]])},\"values\"),o.Arguments=o.Array,e(\"keys\"),e(\"values\"),e(\"entries\")},{117:117,5:5,55:55,57:57,58:58}],142:[function(t,n,r){\"use strict\";var e=t(33),i=t(117),o=[].join;e(e.P+e.F*(t(47)!=Object||!t(105)(o)),\"Array\",{join:function join(t){return o.call(i(this),void 0===t?\",\":t)}})},{105:105,117:117,33:33,47:47}],143:[function(t,n,r){\"use strict\";var e=t(33),i=t(117),o=t(116),u=t(118),c=[].lastIndexOf,a=!!c&&1/[1].lastIndexOf(1,-0)<0;e(e.P+e.F*(a||!t(105)(c)),\"Array\",{lastIndexOf:function lastIndexOf(t){if(a)return c.apply(this,arguments)||0;var n=i(this),r=u(n.length),e=r-1;for(arguments.length>1&&(e=Math.min(e,o(arguments[1]))),e<0&&(e=r+e);e>=0;e--)if(e in n&&n[e]===t)return e||0;return-1}})},{105:105,116:116,117:117,118:118,33:33}],144:[function(t,n,r){\"use strict\";var e=t(33),i=t(12)(1);e(e.P+e.F*!t(105)([].map,!0),\"Array\",{map:function map(t){return i(this,t,arguments[1])}})},{105:105,12:12,33:33}],145:[function(t,n,r){\"use strict\";var e=t(33),i=t(24);e(e.S+e.F*t(35)(function(){function F(){}return!(Array.of.call(F)instanceof F)}),\"Array\",{of:function of(){for(var t=0,n=arguments.length,r=new(\"function\"==typeof this?this:Array)(n);n>t;)i(r,t,arguments[t++]);return r.length=n,r}})},{24:24,33:33,35:35}],146:[function(t,n,r){\"use strict\";var e=t(33),i=t(13);e(e.P+e.F*!t(105)([].reduceRight,!0),\"Array\",{reduceRight:function reduceRight(t){return i(this,t,arguments.length,arguments[1],!0)}})},{105:105,13:13,33:33}],147:[function(t,n,r){\"use strict\";var e=t(33),i=t(13);e(e.P+e.F*!t(105)([].reduce,!0),\"Array\",{reduce:function reduce(t){return i(this,t,arguments.length,arguments[1],!1)}})},{105:105,13:13,33:33}],148:[function(t,n,r){\"use strict\";var e=t(33),i=t(43),o=t(18),u=t(114),c=t(118),a=[].slice;e(e.P+e.F*t(35)(function(){i&&a.call(i)}),\"Array\",{slice:function slice(t,n){var r=c(this.length),e=o(this);if(n=void 0===n?r:n,\"Array\"==e)return a.call(this,t,n);for(var i=u(t,r),f=u(n,r),s=c(f-i),l=Array(s),h=0;h<s;h++)l[h]=\"String\"==e?this.charAt(i+h):this[i+h];return l}})},{114:114,118:118,18:18,33:33,35:35,43:43}],149:[function(t,n,r){\"use strict\";var e=t(33),i=t(12)(3);e(e.P+e.F*!t(105)([].some,!0),\"Array\",{some:function some(t){return i(this,t,arguments[1])}})},{105:105,12:12,33:33}],150:[function(t,n,r){\"use strict\";var e=t(33),i=t(3),o=t(119),u=t(35),c=[].sort,a=[1,2,3];e(e.P+e.F*(u(function(){a.sort(void 0)})||!u(function(){a.sort(null)})||!t(105)(c)),\"Array\",{sort:function sort(t){return void 0===t?c.call(o(this)):c.call(o(this),i(t))}})},{105:105,119:119,3:3,33:33,35:35}],151:[function(t,n,r){t(100)(\"Array\")},{100:100}],152:[function(t,n,r){var e=t(33);e(e.S,\"Date\",{now:function(){return(new Date).getTime()}})},{33:33}],153:[function(t,n,r){var e=t(33),i=t(26);e(e.P+e.F*(Date.prototype.toISOString!==i),\"Date\",{toISOString:i})},{26:26,33:33}],154:[function(t,n,r){\"use strict\";var e=t(33),i=t(119),o=t(120);e(e.P+e.F*t(35)(function(){return null!==new Date(NaN).toJSON()||1!==Date.prototype.toJSON.call({toISOString:function(){return 1}})}),\"Date\",{toJSON:function toJSON(t){var n=i(this),r=o(n);return\"number\"!=typeof r||isFinite(r)?n.toISOString():null}})},{119:119,120:120,33:33,35:35}],155:[function(t,n,r){var e=t(128)(\"toPrimitive\"),i=Date.prototype;e in i||t(42)(i,e,t(27))},{128:128,27:27,42:42}],156:[function(t,n,r){var e=Date.prototype,i=e.toString,o=e.getTime;new Date(NaN)+\"\"!=\"Invalid Date\"&&t(94)(e,\"toString\",function toString(){var t=o.call(this);return t===t?i.call(this):\"Invalid Date\"})},{94:94}],157:[function(t,n,r){var e=t(33);e(e.P,\"Function\",{bind:t(16)})},{16:16,33:33}],158:[function(t,n,r){\"use strict\";var e=t(51),i=t(79),o=t(128)(\"hasInstance\"),u=Function.prototype;o in u||t(72).f(u,o,{value:function(t){if(\"function\"!=typeof this||!e(t))return!1;if(!e(this.prototype))return t instanceof this;for(;t=i(t);)if(this.prototype===t)return!0;return!1}})},{128:128,51:51,72:72,79:79}],159:[function(t,n,r){var e=t(72).f,i=Function.prototype,o=/^\\s*function ([^ (]*)/;\"name\"in i||t(29)&&e(i,\"name\",{configurable:!0,get:function(){try{return(\"\"+this).match(o)[1]}catch(t){return\"\"}}})},{29:29,72:72}],160:[function(t,n,r){\"use strict\";var e=t(19),i=t(125);n.exports=t(22)(\"Map\",function(t){return function Map(){return t(this,arguments.length>0?arguments[0]:void 0)}},{get:function get(t){var n=e.getEntry(i(this,\"Map\"),t);return n&&n.v},set:function set(t,n){return e.def(i(this,\"Map\"),0===t?0:t,n)}},e,!0)},{125:125,19:19,22:22}],161:[function(t,n,r){var e=t(33),i=t(63),o=Math.sqrt,u=Math.acosh;e(e.S+e.F*!(u&&710==Math.floor(u(Number.MAX_VALUE))&&u(1/0)==1/0),\"Math\",{acosh:function acosh(t){return(t=+t)<1?NaN:t>94906265.62425156?Math.log(t)+Math.LN2:i(t-1+o(t-1)*o(t+1))}})},{33:33,63:63}],162:[function(t,n,r){function asinh(t){return isFinite(t=+t)&&0!=t?t<0?-asinh(-t):Math.log(t+Math.sqrt(t*t+1)):t}var e=t(33),i=Math.asinh;e(e.S+e.F*!(i&&1/i(0)>0),\"Math\",{asinh:asinh})},{33:33}],163:[function(t,n,r){var e=t(33),i=Math.atanh;e(e.S+e.F*!(i&&1/i(-0)<0),\"Math\",{atanh:function atanh(t){return 0==(t=+t)?t:Math.log((1+t)/(1-t))/2}})},{33:33}],164:[function(t,n,r){var e=t(33),i=t(65);e(e.S,\"Math\",{cbrt:function cbrt(t){return i(t=+t)*Math.pow(Math.abs(t),1/3)}})},{33:33,65:65}],165:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{clz32:function clz32(t){return(t>>>=0)?31-Math.floor(Math.log(t+.5)*Math.LOG2E):32}})},{33:33}],166:[function(t,n,r){var e=t(33),i=Math.exp;e(e.S,\"Math\",{cosh:function cosh(t){return(i(t=+t)+i(-t))/2}})},{33:33}],167:[function(t,n,r){var e=t(33),i=t(61);e(e.S+e.F*(i!=Math.expm1),\"Math\",{expm1:i})},{33:33,61:61}],168:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{fround:t(62)})},{33:33,62:62}],169:[function(t,n,r){var e=t(33),i=Math.abs;e(e.S,\"Math\",{hypot:function hypot(t,n){for(var r,e,o=0,u=0,c=arguments.length,a=0;u<c;)r=i(arguments[u++]),a<r?(e=a/r,o=o*e*e+1,a=r):r>0?(e=r/a,o+=e*e):o+=r;return a===1/0?1/0:a*Math.sqrt(o)}})},{33:33}],170:[function(t,n,r){var e=t(33),i=Math.imul;e(e.S+e.F*t(35)(function(){return-5!=i(4294967295,5)||2!=i.length}),\"Math\",{imul:function imul(t,n){var r=+t,e=+n,i=65535&r,o=65535&e;return 0|i*o+((65535&r>>>16)*o+i*(65535&e>>>16)<<16>>>0)}})},{33:33,35:35}],171:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{log10:function log10(t){return Math.log(t)*Math.LOG10E}})},{33:33}],172:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{log1p:t(63)})},{33:33,63:63}],173:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{log2:function log2(t){return Math.log(t)/Math.LN2}})},{33:33}],174:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{sign:t(65)})},{33:33,65:65}],175:[function(t,n,r){var e=t(33),i=t(61),o=Math.exp;e(e.S+e.F*t(35)(function(){return-2e-17!=!Math.sinh(-2e-17)}),\"Math\",{sinh:function sinh(t){return Math.abs(t=+t)<1?(i(t)-i(-t))/2:(o(t-1)-o(-t-1))*(Math.E/2)}})},{33:33,35:35,61:61}],176:[function(t,n,r){var e=t(33),i=t(61),o=Math.exp;e(e.S,\"Math\",{tanh:function tanh(t){var n=i(t=+t),r=i(-t);return n==1/0?1:r==1/0?-1:(n-r)/(o(t)+o(-t))}})},{33:33,61:61}],177:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{trunc:function trunc(t){return(t>0?Math.floor:Math.ceil)(t)}})},{33:33}],178:[function(t,n,r){\"use strict\";var e=t(40),i=t(41),o=t(18),u=t(45),c=t(120),a=t(35),f=t(77).f,s=t(75).f,l=t(72).f,h=t(111).trim,v=e.Number,p=v,d=v.prototype,y=\"Number\"==o(t(71)(d)),g=\"trim\"in String.prototype,m=function(t){var n=c(t,!1);if(\"string\"==typeof n&&n.length>2){n=g?n.trim():h(n,3);var r,e,i,o=n.charCodeAt(0);if(43===o||45===o){if(88===(r=n.charCodeAt(2))||120===r)return NaN}else if(48===o){switch(n.charCodeAt(1)){case 66:case 98:e=2,i=49;break;case 79:case 111:e=8,i=55;break;default:return+n}for(var u,a=n.slice(2),f=0,s=a.length;f<s;f++)if((u=a.charCodeAt(f))<48||u>i)return NaN;return parseInt(a,e)}}return+n};if(!v(\" 0o1\")||!v(\"0b1\")||v(\"+0x1\")){v=function Number(t){var n=arguments.length<1?0:t,r=this;return r instanceof v&&(y?a(function(){d.valueOf.call(r)}):\"Number\"!=o(r))?u(new p(m(n)),r,v):m(n)};for(var b,x=t(29)?f(p):\"MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger\".split(\",\"),S=0;x.length>S;S++)i(p,b=x[S])&&!i(v,b)&&l(v,b,s(p,b));v.prototype=d,d.constructor=v,t(94)(e,\"Number\",v)}},{111:111,120:120,18:18,29:29,35:35,40:40,41:41,45:45,71:71,72:72,75:75,77:77,94:94}],179:[function(t,n,r){var e=t(33);e(e.S,\"Number\",{EPSILON:Math.pow(2,-52)})},{33:33}],180:[function(t,n,r){var e=t(33),i=t(40).isFinite;e(e.S,\"Number\",{isFinite:function isFinite(t){return\"number\"==typeof t&&i(t)}})},{33:33,40:40}],181:[function(t,n,r){var e=t(33);e(e.S,\"Number\",{isInteger:t(50)})},{33:33,50:50}],182:[function(t,n,r){var e=t(33);e(e.S,\"Number\",{isNaN:function isNaN(t){return t!=t}})},{33:33}],183:[function(t,n,r){var e=t(33),i=t(50),o=Math.abs;e(e.S,\"Number\",{isSafeInteger:function isSafeInteger(t){return i(t)&&o(t)<=9007199254740991}})},{33:33,50:50}],184:[function(t,n,r){var e=t(33);e(e.S,\"Number\",{MAX_SAFE_INTEGER:9007199254740991})},{33:33}],185:[function(t,n,r){var e=t(33);e(e.S,\"Number\",{MIN_SAFE_INTEGER:-9007199254740991})},{33:33}],186:[function(t,n,r){var e=t(33),i=t(86);e(e.S+e.F*(Number.parseFloat!=i),\"Number\",{parseFloat:i})},{33:33,86:86}],187:[function(t,n,r){var e=t(33),i=t(87);e(e.S+e.F*(Number.parseInt!=i),\"Number\",{parseInt:i})},{33:33,87:87}],188:[function(t,n,r){\"use strict\";var e=t(33),i=t(116),o=t(4),u=t(110),c=1..toFixed,a=Math.floor,f=[0,0,0,0,0,0],s=\"Number.toFixed: incorrect invocation!\",l=function(t,n){for(var r=-1,e=n;++r<6;)e+=t*f[r],f[r]=e%1e7,e=a(e/1e7)},h=function(t){for(var n=6,r=0;--n>=0;)r+=f[n],f[n]=a(r/t),r=r%t*1e7},v=function(){for(var t=6,n=\"\";--t>=0;)if(\"\"!==n||0===t||0!==f[t]){var r=String(f[t]);n=\"\"===n?r:n+u.call(\"0\",7-r.length)+r}return n},p=function(t,n,r){return 0===n?r:n%2==1?p(t,n-1,r*t):p(t*t,n/2,r)},d=function(t){for(var n=0,r=t;r>=4096;)n+=12,r/=4096;for(;r>=2;)n+=1,r/=2;return n};e(e.P+e.F*(!!c&&(\"0.000\"!==8e-5.toFixed(3)||\"1\"!==.9.toFixed(0)||\"1.25\"!==1.255.toFixed(2)||\"1000000000000000128\"!==(0xde0b6b3a7640080).toFixed(0))||!t(35)(function(){c.call({})})),\"Number\",{toFixed:function toFixed(t){var n,r,e,c,a=o(this,s),f=i(t),y=\"\",g=\"0\";if(f<0||f>20)throw RangeError(s);if(a!=a)return\"NaN\";if(a<=-1e21||a>=1e21)return String(a);if(a<0&&(y=\"-\",a=-a),a>1e-21)if(n=d(a*p(2,69,1))-69,r=n<0?a*p(2,-n,1):a/p(2,n,1),r*=4503599627370496,(n=52-n)>0){for(l(0,r),e=f;e>=7;)l(1e7,0),e-=7;for(l(p(10,e,1),0),e=n-1;e>=23;)h(1<<23),e-=23;h(1<<e),l(1,1),h(2),g=v()}else l(0,r),l(1<<-n,0),g=v()+u.call(\"0\",f);return f>0?(c=g.length,g=y+(c<=f?\"0.\"+u.call(\"0\",f-c)+g:g.slice(0,c-f)+\".\"+g.slice(c-f))):g=y+g,g}})},{110:110,116:116,33:33,35:35,4:4}],189:[function(t,n,r){\"use strict\";var e=t(33),i=t(35),o=t(4),u=1..toPrecision;e(e.P+e.F*(i(function(){return\"1\"!==u.call(1,void 0)})||!i(function(){u.call({})})),\"Number\",{toPrecision:function toPrecision(t){var n=o(this,\"Number#toPrecision: incorrect invocation!\");return void 0===t?u.call(n):u.call(n,t)}})},{33:33,35:35,4:4}],190:[function(t,n,r){var e=t(33);e(e.S+e.F,\"Object\",{assign:t(70)})},{33:33,70:70}],191:[function(t,n,r){var e=t(33);e(e.S,\"Object\",{create:t(71)})},{33:33,71:71}],192:[function(t,n,r){var e=t(33);e(e.S+e.F*!t(29),\"Object\",{defineProperties:t(73)})},{29:29,33:33,73:73}],193:[function(t,n,r){var e=t(33);e(e.S+e.F*!t(29),\"Object\",{defineProperty:t(72).f})},{29:29,33:33,72:72}],194:[function(t,n,r){var e=t(51),i=t(66).onFreeze;t(83)(\"freeze\",function(t){return function freeze(n){return t&&e(n)?t(i(n)):n}})},{51:51,66:66,83:83}],195:[function(t,n,r){var e=t(117),i=t(75).f;t(83)(\"getOwnPropertyDescriptor\",function(){return function getOwnPropertyDescriptor(t,n){return i(e(t),n)}})},{117:117,75:75,83:83}],196:[function(t,n,r){t(83)(\"getOwnPropertyNames\",function(){return t(76).f})},{76:76,83:83}],197:[function(t,n,r){var e=t(119),i=t(79);t(83)(\"getPrototypeOf\",function(){return function getPrototypeOf(t){return i(e(t))}})},{119:119,79:79,83:83}],198:[function(t,n,r){var e=t(51);t(83)(\"isExtensible\",function(t){return function isExtensible(n){return!!e(n)&&(!t||t(n))}})},{51:51,83:83}],199:[function(t,n,r){var e=t(51);t(83)(\"isFrozen\",function(t){return function isFrozen(n){return!e(n)||!!t&&t(n)}})},{51:51,83:83}],200:[function(t,n,r){var e=t(51);t(83)(\"isSealed\",function(t){return function isSealed(n){return!e(n)||!!t&&t(n)}})},{51:51,83:83}],201:[function(t,n,r){var e=t(33);e(e.S,\"Object\",{is:t(96)})},{33:33,96:96}],202:[function(t,n,r){var e=t(119),i=t(81);t(83)(\"keys\",function(){return function keys(t){return i(e(t))}})},{119:119,81:81,83:83}],203:[function(t,n,r){var e=t(51),i=t(66).onFreeze;t(83)(\"preventExtensions\",function(t){return function preventExtensions(n){return t&&e(n)?t(i(n)):n}})},{51:51,66:66,83:83}],204:[function(t,n,r){var e=t(51),i=t(66).onFreeze;t(83)(\"seal\",function(t){return function seal(n){return t&&e(n)?t(i(n)):n}})},{51:51,66:66,83:83}],205:[function(t,n,r){var e=t(33);e(e.S,\"Object\",{setPrototypeOf:t(99).set})},{33:33,99:99}],206:[function(t,n,r){\"use strict\";var e=t(17),i={};i[t(128)(\"toStringTag\")]=\"z\",i+\"\"!=\"[object z]\"&&t(94)(Object.prototype,\"toString\",function toString(){return\"[object \"+e(this)+\"]\"},!0)},{128:128,17:17,94:94}],207:[function(t,n,r){var e=t(33),i=t(86);e(e.G+e.F*(parseFloat!=i),{parseFloat:i})},{33:33,86:86}],208:[function(t,n,r){var e=t(33),i=t(87);e(e.G+e.F*(parseInt!=i),{parseInt:i})},{33:33,87:87}],209:[function(t,n,r){\"use strict\";var e,i,o,u,c=t(60),a=t(40),f=t(25),s=t(17),l=t(33),h=t(51),v=t(3),p=t(6),d=t(39),y=t(104),g=t(113).set,m=t(68)(),b=t(69),x=t(90),S=t(91),w=a.TypeError,_=a.process,E=a.Promise,O=\"process\"==s(_),P=function(){},M=i=b.f,F=!!function(){try{var n=E.resolve(1),r=(n.constructor={})[t(128)(\"species\")]=function(t){t(P,P)};return(O||\"function\"==typeof PromiseRejectionEvent)&&n.then(P)instanceof r}catch(t){}}(),I=c?function(t,n){return t===n||t===E&&n===u}:function(t,n){return t===n},A=function(t){var n;return!(!h(t)||\"function\"!=typeof(n=t.then))&&n},k=function(t,n){if(!t._n){t._n=!0;var r=t._c;m(function(){for(var e=t._v,i=1==t._s,o=0;r.length>o;)!function(n){var r,o,u=i?n.ok:n.fail,c=n.resolve,a=n.reject,f=n.domain;try{u?(i||(2==t._h&&T(t),t._h=1),!0===u?r=e:(f&&f.enter(),r=u(e),f&&f.exit()),r===n.promise?a(w(\"Promise-chain cycle\")):(o=A(r))?o.call(r,c,a):c(r)):a(e)}catch(t){a(t)}}(r[o++]);t._c=[],t._n=!1,n&&!t._h&&N(t)})}},N=function(t){g.call(a,function(){var n,r,e,i=t._v,o=j(t);if(o&&(n=x(function(){O?_.emit(\"unhandledRejection\",i,t):(r=a.onunhandledrejection)?r({promise:t,reason:i}):(e=a.console)&&e.error&&e.error(\"Unhandled promise rejection\",i)}),t._h=O||j(t)?2:1),t._a=void 0,o&&n.e)throw n.v})},j=function(t){if(1==t._h)return!1;for(var n,r=t._a||t._c,e=0;r.length>e;)if(n=r[e++],n.fail||!j(n.promise))return!1;return!0},T=function(t){g.call(a,function(){var n;O?_.emit(\"rejectionHandled\",t):(n=a.onrejectionhandled)&&n({promise:t,reason:t._v})})},R=function(t){var n=this;n._d||(n._d=!0,n=n._w||n,n._v=t,n._s=2,n._a||(n._a=n._c.slice()),k(n,!0))},L=function(t){var n,r=this;if(!r._d){r._d=!0,r=r._w||r;try{if(r===t)throw w(\"Promise can't be resolved itself\");(n=A(t))?m(function(){var e={_w:r,_d:!1};try{n.call(t,f(L,e,1),f(R,e,1))}catch(t){R.call(e,t)}}):(r._v=t,r._s=1,k(r,!1))}catch(t){R.call({_w:r,_d:!1},t)}}};F||(E=function Promise(t){p(this,E,\"Promise\",\"_h\"),v(t),e.call(this);try{t(f(L,this,1),f(R,this,1))}catch(t){R.call(this,t)}},e=function Promise(t){this._c=[],this._a=void 0,this._s=0,this._d=!1,this._v=void 0,this._h=0,this._n=!1},e.prototype=t(93)(E.prototype,{then:function then(t,n){var r=M(y(this,E));return r.ok=\"function\"!=typeof t||t,r.fail=\"function\"==typeof n&&n,r.domain=O?_.domain:void 0,this._c.push(r),this._a&&this._a.push(r),this._s&&k(this,!1),r.promise},catch:function(t){return this.then(void 0,t)}}),o=function(){var t=new e;this.promise=t,this.resolve=f(L,t,1),this.reject=f(R,t,1)},b.f=M=function(t){return I(E,t)?new o(t):i(t)}),l(l.G+l.W+l.F*!F,{Promise:E}),t(101)(E,\"Promise\"),t(100)(\"Promise\"),u=t(23).Promise,l(l.S+l.F*!F,\"Promise\",{reject:function reject(t){var n=M(this);return(0,n.reject)(t),n.promise}}),l(l.S+l.F*(c||!F),\"Promise\",{resolve:function resolve(t){return t instanceof E&&I(t.constructor,this)?t:S(this,t)}}),l(l.S+l.F*!(F&&t(56)(function(t){E.all(t).catch(P)})),\"Promise\",{all:function all(t){var n=this,r=M(n),e=r.resolve,i=r.reject,o=x(function(){var r=[],o=0,u=1;d(t,!1,function(t){var c=o++,a=!1;r.push(void 0),u++,n.resolve(t).then(function(t){a||(a=!0,r[c]=t,--u||e(r))},i)}),--u||e(r)});return o.e&&i(o.v),r.promise},race:function race(t){var n=this,r=M(n),e=r.reject,i=x(function(){d(t,!1,function(t){n.resolve(t).then(r.resolve,e)})});return i.e&&e(i.v),r.promise}})},{100:100,101:101,104:104,113:113,128:128,17:17,23:23,25:25,\n3:3,33:33,39:39,40:40,51:51,56:56,6:6,60:60,68:68,69:69,90:90,91:91,93:93}],210:[function(t,n,r){var e=t(33),i=t(3),o=t(7),u=(t(40).Reflect||{}).apply,c=Function.apply;e(e.S+e.F*!t(35)(function(){u(function(){})}),\"Reflect\",{apply:function apply(t,n,r){var e=i(t),a=o(r);return u?u(e,n,a):c.call(e,n,a)}})},{3:3,33:33,35:35,40:40,7:7}],211:[function(t,n,r){var e=t(33),i=t(71),o=t(3),u=t(7),c=t(51),a=t(35),f=t(16),s=(t(40).Reflect||{}).construct,l=a(function(){function F(){}return!(s(function(){},[],F)instanceof F)}),h=!a(function(){s(function(){})});e(e.S+e.F*(l||h),\"Reflect\",{construct:function construct(t,n){o(t),u(n);var r=arguments.length<3?t:o(arguments[2]);if(h&&!l)return s(t,n,r);if(t==r){switch(n.length){case 0:return new t;case 1:return new t(n[0]);case 2:return new t(n[0],n[1]);case 3:return new t(n[0],n[1],n[2]);case 4:return new t(n[0],n[1],n[2],n[3])}var e=[null];return e.push.apply(e,n),new(f.apply(t,e))}var a=r.prototype,v=i(c(a)?a:Object.prototype),p=Function.apply.call(t,v,n);return c(p)?p:v}})},{16:16,3:3,33:33,35:35,40:40,51:51,7:7,71:71}],212:[function(t,n,r){var e=t(72),i=t(33),o=t(7),u=t(120);i(i.S+i.F*t(35)(function(){Reflect.defineProperty(e.f({},1,{value:1}),1,{value:2})}),\"Reflect\",{defineProperty:function defineProperty(t,n,r){o(t),n=u(n,!0),o(r);try{return e.f(t,n,r),!0}catch(t){return!1}}})},{120:120,33:33,35:35,7:7,72:72}],213:[function(t,n,r){var e=t(33),i=t(75).f,o=t(7);e(e.S,\"Reflect\",{deleteProperty:function deleteProperty(t,n){var r=i(o(t),n);return!(r&&!r.configurable)&&delete t[n]}})},{33:33,7:7,75:75}],214:[function(t,n,r){\"use strict\";var e=t(33),i=t(7),o=function(t){this._t=i(t),this._i=0;var n,r=this._k=[];for(n in t)r.push(n)};t(54)(o,\"Object\",function(){var t,n=this,r=n._k;do{if(n._i>=r.length)return{value:void 0,done:!0}}while(!((t=r[n._i++])in n._t));return{value:t,done:!1}}),e(e.S,\"Reflect\",{enumerate:function enumerate(t){return new o(t)}})},{33:33,54:54,7:7}],215:[function(t,n,r){var e=t(75),i=t(33),o=t(7);i(i.S,\"Reflect\",{getOwnPropertyDescriptor:function getOwnPropertyDescriptor(t,n){return e.f(o(t),n)}})},{33:33,7:7,75:75}],216:[function(t,n,r){var e=t(33),i=t(79),o=t(7);e(e.S,\"Reflect\",{getPrototypeOf:function getPrototypeOf(t){return i(o(t))}})},{33:33,7:7,79:79}],217:[function(t,n,r){function get(t,n){var r,u,f=arguments.length<3?t:arguments[2];return a(t)===f?t[n]:(r=e.f(t,n))?o(r,\"value\")?r.value:void 0!==r.get?r.get.call(f):void 0:c(u=i(t))?get(u,n,f):void 0}var e=t(75),i=t(79),o=t(41),u=t(33),c=t(51),a=t(7);u(u.S,\"Reflect\",{get:get})},{33:33,41:41,51:51,7:7,75:75,79:79}],218:[function(t,n,r){var e=t(33);e(e.S,\"Reflect\",{has:function has(t,n){return n in t}})},{33:33}],219:[function(t,n,r){var e=t(33),i=t(7),o=Object.isExtensible;e(e.S,\"Reflect\",{isExtensible:function isExtensible(t){return i(t),!o||o(t)}})},{33:33,7:7}],220:[function(t,n,r){var e=t(33);e(e.S,\"Reflect\",{ownKeys:t(85)})},{33:33,85:85}],221:[function(t,n,r){var e=t(33),i=t(7),o=Object.preventExtensions;e(e.S,\"Reflect\",{preventExtensions:function preventExtensions(t){i(t);try{return o&&o(t),!0}catch(t){return!1}}})},{33:33,7:7}],222:[function(t,n,r){var e=t(33),i=t(99);i&&e(e.S,\"Reflect\",{setPrototypeOf:function setPrototypeOf(t,n){i.check(t,n);try{return i.set(t,n),!0}catch(t){return!1}}})},{33:33,99:99}],223:[function(t,n,r){function set(t,n,r){var c,l,h=arguments.length<4?t:arguments[3],v=i.f(f(t),n);if(!v){if(s(l=o(t)))return set(l,n,r,h);v=a(0)}return u(v,\"value\")?!(!1===v.writable||!s(h))&&(c=i.f(h,n)||a(0),c.value=r,e.f(h,n,c),!0):void 0!==v.set&&(v.set.call(h,r),!0)}var e=t(72),i=t(75),o=t(79),u=t(41),c=t(33),a=t(92),f=t(7),s=t(51);c(c.S,\"Reflect\",{set:set})},{33:33,41:41,51:51,7:7,72:72,75:75,79:79,92:92}],224:[function(t,n,r){var e=t(40),i=t(45),o=t(72).f,u=t(77).f,c=t(52),a=t(37),f=e.RegExp,s=f,l=f.prototype,h=/a/g,v=/a/g,p=new f(h)!==h;if(t(29)&&(!p||t(35)(function(){return v[t(128)(\"match\")]=!1,f(h)!=h||f(v)==v||\"/a/i\"!=f(h,\"i\")}))){f=function RegExp(t,n){var r=this instanceof f,e=c(t),o=void 0===n;return!r&&e&&t.constructor===f&&o?t:i(p?new s(e&&!o?t.source:t,n):s((e=t instanceof f)?t.source:t,e&&o?a.call(t):n),r?this:l,f)};for(var d=u(s),y=0;d.length>y;)!function(t){t in f||o(f,t,{configurable:!0,get:function(){return s[t]},set:function(n){s[t]=n}})}(d[y++]);l.constructor=f,f.prototype=l,t(94)(e,\"RegExp\",f)}t(100)(\"RegExp\")},{100:100,128:128,29:29,35:35,37:37,40:40,45:45,52:52,72:72,77:77,94:94}],225:[function(t,n,r){t(29)&&\"g\"!=/./g.flags&&t(72).f(RegExp.prototype,\"flags\",{configurable:!0,get:t(37)})},{29:29,37:37,72:72}],226:[function(t,n,r){t(36)(\"match\",1,function(t,n,r){return[function match(r){\"use strict\";var e=t(this),i=void 0==r?void 0:r[n];return void 0!==i?i.call(r,e):new RegExp(r)[n](String(e))},r]})},{36:36}],227:[function(t,n,r){t(36)(\"replace\",2,function(t,n,r){return[function replace(e,i){\"use strict\";var o=t(this),u=void 0==e?void 0:e[n];return void 0!==u?u.call(e,o,i):r.call(String(o),e,i)},r]})},{36:36}],228:[function(t,n,r){t(36)(\"search\",1,function(t,n,r){return[function search(r){\"use strict\";var e=t(this),i=void 0==r?void 0:r[n];return void 0!==i?i.call(r,e):new RegExp(r)[n](String(e))},r]})},{36:36}],229:[function(t,n,r){t(36)(\"split\",2,function(n,r,e){\"use strict\";var i=t(52),o=e,u=[].push,c=\"length\";if(\"c\"==\"abbc\".split(/(b)*/)[1]||4!=\"test\".split(/(?:)/,-1)[c]||2!=\"ab\".split(/(?:ab)*/)[c]||4!=\".\".split(/(.?)(.?)/)[c]||\".\".split(/()()/)[c]>1||\"\".split(/.?/)[c]){var a=void 0===/()??/.exec(\"\")[1];e=function(t,n){var r=String(this);if(void 0===t&&0===n)return[];if(!i(t))return o.call(r,t,n);var e,f,s,l,h,v=[],p=(t.ignoreCase?\"i\":\"\")+(t.multiline?\"m\":\"\")+(t.unicode?\"u\":\"\")+(t.sticky?\"y\":\"\"),d=0,y=void 0===n?4294967295:n>>>0,g=new RegExp(t.source,p+\"g\");for(a||(e=new RegExp(\"^\"+g.source+\"$(?!\\\\s)\",p));(f=g.exec(r))&&!((s=f.index+f[0][c])>d&&(v.push(r.slice(d,f.index)),!a&&f[c]>1&&f[0].replace(e,function(){for(h=1;h<arguments[c]-2;h++)void 0===arguments[h]&&(f[h]=void 0)}),f[c]>1&&f.index<r[c]&&u.apply(v,f.slice(1)),l=f[0][c],d=s,v[c]>=y));)g.lastIndex===f.index&&g.lastIndex++;return d===r[c]?!l&&g.test(\"\")||v.push(\"\"):v.push(r.slice(d)),v[c]>y?v.slice(0,y):v}}else\"0\".split(void 0,0)[c]&&(e=function(t,n){return void 0===t&&0===n?[]:o.call(this,t,n)});return[function split(t,i){var o=n(this),u=void 0==t?void 0:t[r];return void 0!==u?u.call(t,o,i):e.call(String(o),t,i)},e]})},{36:36,52:52}],230:[function(t,n,r){\"use strict\";t(225);var e=t(7),i=t(37),o=t(29),u=/./.toString,c=function(n){t(94)(RegExp.prototype,\"toString\",n,!0)};t(35)(function(){return\"/a/b\"!=u.call({source:\"a\",flags:\"b\"})})?c(function toString(){var t=e(this);return\"/\".concat(t.source,\"/\",\"flags\"in t?t.flags:!o&&t instanceof RegExp?i.call(t):void 0)}):\"toString\"!=u.name&&c(function toString(){return u.call(this)})},{225:225,29:29,35:35,37:37,7:7,94:94}],231:[function(t,n,r){\"use strict\";var e=t(19),i=t(125);n.exports=t(22)(\"Set\",function(t){return function Set(){return t(this,arguments.length>0?arguments[0]:void 0)}},{add:function add(t){return e.def(i(this,\"Set\"),t=0===t?0:t,t)}},e)},{125:125,19:19,22:22}],232:[function(t,n,r){\"use strict\";t(108)(\"anchor\",function(t){return function anchor(n){return t(this,\"a\",\"name\",n)}})},{108:108}],233:[function(t,n,r){\"use strict\";t(108)(\"big\",function(t){return function big(){return t(this,\"big\",\"\",\"\")}})},{108:108}],234:[function(t,n,r){\"use strict\";t(108)(\"blink\",function(t){return function blink(){return t(this,\"blink\",\"\",\"\")}})},{108:108}],235:[function(t,n,r){\"use strict\";t(108)(\"bold\",function(t){return function bold(){return t(this,\"b\",\"\",\"\")}})},{108:108}],236:[function(t,n,r){\"use strict\";var e=t(33),i=t(106)(!1);e(e.P,\"String\",{codePointAt:function codePointAt(t){return i(this,t)}})},{106:106,33:33}],237:[function(t,n,r){\"use strict\";var e=t(33),i=t(118),o=t(107),u=\"\".endsWith;e(e.P+e.F*t(34)(\"endsWith\"),\"String\",{endsWith:function endsWith(t){var n=o(this,t,\"endsWith\"),r=arguments.length>1?arguments[1]:void 0,e=i(n.length),c=void 0===r?e:Math.min(i(r),e),a=String(t);return u?u.call(n,a,c):n.slice(c-a.length,c)===a}})},{107:107,118:118,33:33,34:34}],238:[function(t,n,r){\"use strict\";t(108)(\"fixed\",function(t){return function fixed(){return t(this,\"tt\",\"\",\"\")}})},{108:108}],239:[function(t,n,r){\"use strict\";t(108)(\"fontcolor\",function(t){return function fontcolor(n){return t(this,\"font\",\"color\",n)}})},{108:108}],240:[function(t,n,r){\"use strict\";t(108)(\"fontsize\",function(t){return function fontsize(n){return t(this,\"font\",\"size\",n)}})},{108:108}],241:[function(t,n,r){var e=t(33),i=t(114),o=String.fromCharCode,u=String.fromCodePoint;e(e.S+e.F*(!!u&&1!=u.length),\"String\",{fromCodePoint:function fromCodePoint(t){for(var n,r=[],e=arguments.length,u=0;e>u;){if(n=+arguments[u++],i(n,1114111)!==n)throw RangeError(n+\" is not a valid code point\");r.push(n<65536?o(n):o(55296+((n-=65536)>>10),n%1024+56320))}return r.join(\"\")}})},{114:114,33:33}],242:[function(t,n,r){\"use strict\";var e=t(33),i=t(107);e(e.P+e.F*t(34)(\"includes\"),\"String\",{includes:function includes(t){return!!~i(this,t,\"includes\").indexOf(t,arguments.length>1?arguments[1]:void 0)}})},{107:107,33:33,34:34}],243:[function(t,n,r){\"use strict\";t(108)(\"italics\",function(t){return function italics(){return t(this,\"i\",\"\",\"\")}})},{108:108}],244:[function(t,n,r){\"use strict\";var e=t(106)(!0);t(55)(String,\"String\",function(t){this._t=String(t),this._i=0},function(){var t,n=this._t,r=this._i;return r>=n.length?{value:void 0,done:!0}:(t=e(n,r),this._i+=t.length,{value:t,done:!1})})},{106:106,55:55}],245:[function(t,n,r){\"use strict\";t(108)(\"link\",function(t){return function link(n){return t(this,\"a\",\"href\",n)}})},{108:108}],246:[function(t,n,r){var e=t(33),i=t(117),o=t(118);e(e.S,\"String\",{raw:function raw(t){for(var n=i(t.raw),r=o(n.length),e=arguments.length,u=[],c=0;r>c;)u.push(String(n[c++])),c<e&&u.push(String(arguments[c]));return u.join(\"\")}})},{117:117,118:118,33:33}],247:[function(t,n,r){var e=t(33);e(e.P,\"String\",{repeat:t(110)})},{110:110,33:33}],248:[function(t,n,r){\"use strict\";t(108)(\"small\",function(t){return function small(){return t(this,\"small\",\"\",\"\")}})},{108:108}],249:[function(t,n,r){\"use strict\";var e=t(33),i=t(118),o=t(107),u=\"\".startsWith;e(e.P+e.F*t(34)(\"startsWith\"),\"String\",{startsWith:function startsWith(t){var n=o(this,t,\"startsWith\"),r=i(Math.min(arguments.length>1?arguments[1]:void 0,n.length)),e=String(t);return u?u.call(n,e,r):n.slice(r,r+e.length)===e}})},{107:107,118:118,33:33,34:34}],250:[function(t,n,r){\"use strict\";t(108)(\"strike\",function(t){return function strike(){return t(this,\"strike\",\"\",\"\")}})},{108:108}],251:[function(t,n,r){\"use strict\";t(108)(\"sub\",function(t){return function sub(){return t(this,\"sub\",\"\",\"\")}})},{108:108}],252:[function(t,n,r){\"use strict\";t(108)(\"sup\",function(t){return function sup(){return t(this,\"sup\",\"\",\"\")}})},{108:108}],253:[function(t,n,r){\"use strict\";t(111)(\"trim\",function(t){return function trim(){return t(this,3)}})},{111:111}],254:[function(t,n,r){\"use strict\";var e=t(40),i=t(41),o=t(29),u=t(33),c=t(94),a=t(66).KEY,f=t(35),s=t(103),l=t(101),h=t(124),v=t(128),p=t(127),d=t(126),y=t(59),g=t(32),m=t(49),b=t(7),x=t(117),S=t(120),w=t(92),_=t(71),E=t(76),O=t(75),P=t(72),M=t(81),F=O.f,I=P.f,A=E.f,k=e.Symbol,N=e.JSON,j=N&&N.stringify,T=v(\"_hidden\"),R=v(\"toPrimitive\"),L={}.propertyIsEnumerable,G=s(\"symbol-registry\"),D=s(\"symbols\"),C=s(\"op-symbols\"),W=Object.prototype,U=\"function\"==typeof k,B=e.QObject,V=!B||!B.prototype||!B.prototype.findChild,z=o&&f(function(){return 7!=_(I({},\"a\",{get:function(){return I(this,\"a\",{value:7}).a}})).a})?function(t,n,r){var e=F(W,n);e&&delete W[n],I(t,n,r),e&&t!==W&&I(W,n,e)}:I,q=function(t){var n=D[t]=_(k.prototype);return n._k=t,n},K=U&&\"symbol\"==typeof k.iterator?function(t){return\"symbol\"==typeof t}:function(t){return t instanceof k},Y=function defineProperty(t,n,r){return t===W&&Y(C,n,r),b(t),n=S(n,!0),b(r),i(D,n)?(r.enumerable?(i(t,T)&&t[T][n]&&(t[T][n]=!1),r=_(r,{enumerable:w(0,!1)})):(i(t,T)||I(t,T,w(1,{})),t[T][n]=!0),z(t,n,r)):I(t,n,r)},J=function defineProperties(t,n){b(t);for(var r,e=g(n=x(n)),i=0,o=e.length;o>i;)Y(t,r=e[i++],n[r]);return t},H=function create(t,n){return void 0===n?_(t):J(_(t),n)},X=function propertyIsEnumerable(t){var n=L.call(this,t=S(t,!0));return!(this===W&&i(D,t)&&!i(C,t))&&(!(n||!i(this,t)||!i(D,t)||i(this,T)&&this[T][t])||n)},$=function getOwnPropertyDescriptor(t,n){if(t=x(t),n=S(n,!0),t!==W||!i(D,n)||i(C,n)){var r=F(t,n);return!r||!i(D,n)||i(t,T)&&t[T][n]||(r.enumerable=!0),r}},Z=function getOwnPropertyNames(t){for(var n,r=A(x(t)),e=[],o=0;r.length>o;)i(D,n=r[o++])||n==T||n==a||e.push(n);return e},Q=function getOwnPropertySymbols(t){for(var n,r=t===W,e=A(r?C:x(t)),o=[],u=0;e.length>u;)!i(D,n=e[u++])||r&&!i(W,n)||o.push(D[n]);return o};U||(k=function Symbol(){if(this instanceof k)throw TypeError(\"Symbol is not a constructor!\");var t=h(arguments.length>0?arguments[0]:void 0),n=function(r){this===W&&n.call(C,r),i(this,T)&&i(this[T],t)&&(this[T][t]=!1),z(this,t,w(1,r))};return o&&V&&z(W,t,{configurable:!0,set:n}),q(t)},c(k.prototype,\"toString\",function toString(){return this._k}),O.f=$,P.f=Y,t(77).f=E.f=Z,t(82).f=X,t(78).f=Q,o&&!t(60)&&c(W,\"propertyIsEnumerable\",X,!0),p.f=function(t){return q(v(t))}),u(u.G+u.W+u.F*!U,{Symbol:k});for(var tt=\"hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables\".split(\",\"),nt=0;tt.length>nt;)v(tt[nt++]);for(var rt=M(v.store),et=0;rt.length>et;)d(rt[et++]);u(u.S+u.F*!U,\"Symbol\",{for:function(t){return i(G,t+=\"\")?G[t]:G[t]=k(t)},keyFor:function keyFor(t){if(K(t))return y(G,t);throw TypeError(t+\" is not a symbol!\")},useSetter:function(){V=!0},useSimple:function(){V=!1}}),u(u.S+u.F*!U,\"Object\",{create:H,defineProperty:Y,defineProperties:J,getOwnPropertyDescriptor:$,getOwnPropertyNames:Z,getOwnPropertySymbols:Q}),N&&u(u.S+u.F*(!U||f(function(){var t=k();return\"[null]\"!=j([t])||\"{}\"!=j({a:t})||\"{}\"!=j(Object(t))})),\"JSON\",{stringify:function stringify(t){if(void 0!==t&&!K(t)){for(var n,r,e=[t],i=1;arguments.length>i;)e.push(arguments[i++]);return n=e[1],\"function\"==typeof n&&(r=n),!r&&m(n)||(n=function(t,n){if(r&&(n=r.call(this,t,n)),!K(n))return n}),e[1]=n,j.apply(N,e)}}}),k.prototype[R]||t(42)(k.prototype,R,k.prototype.valueOf),l(k,\"Symbol\"),l(Math,\"Math\",!0),l(e.JSON,\"JSON\",!0)},{101:101,103:103,117:117,120:120,124:124,126:126,127:127,128:128,29:29,32:32,33:33,35:35,40:40,41:41,42:42,49:49,59:59,60:60,66:66,7:7,71:71,72:72,75:75,76:76,77:77,78:78,81:81,82:82,92:92,94:94}],255:[function(t,n,r){\"use strict\";var e=t(33),i=t(123),o=t(122),u=t(7),c=t(114),a=t(118),f=t(51),s=t(40).ArrayBuffer,l=t(104),h=o.ArrayBuffer,v=o.DataView,p=i.ABV&&s.isView,d=h.prototype.slice,y=i.VIEW;e(e.G+e.W+e.F*(s!==h),{ArrayBuffer:h}),e(e.S+e.F*!i.CONSTR,\"ArrayBuffer\",{isView:function isView(t){return p&&p(t)||f(t)&&y in t}}),e(e.P+e.U+e.F*t(35)(function(){return!new h(2).slice(1,void 0).byteLength}),\"ArrayBuffer\",{slice:function slice(t,n){if(void 0!==d&&void 0===n)return d.call(u(this),t);for(var r=u(this).byteLength,e=c(t,r),i=c(void 0===n?r:n,r),o=new(l(this,h))(a(i-e)),f=new v(this),s=new v(o),p=0;e<i;)s.setUint8(p++,f.getUint8(e++));return o}}),t(100)(\"ArrayBuffer\")},{100:100,104:104,114:114,118:118,122:122,123:123,33:33,35:35,40:40,51:51,7:7}],256:[function(t,n,r){var e=t(33);e(e.G+e.W+e.F*!t(123).ABV,{DataView:t(122).DataView})},{122:122,123:123,33:33}],257:[function(t,n,r){t(121)(\"Float32\",4,function(t){return function Float32Array(n,r,e){return t(this,n,r,e)}})},{121:121}],258:[function(t,n,r){t(121)(\"Float64\",8,function(t){return function Float64Array(n,r,e){return t(this,n,r,e)}})},{121:121}],259:[function(t,n,r){t(121)(\"Int16\",2,function(t){return function Int16Array(n,r,e){return t(this,n,r,e)}})},{121:121}],260:[function(t,n,r){t(121)(\"Int32\",4,function(t){return function Int32Array(n,r,e){return t(this,n,r,e)}})},{121:121}],261:[function(t,n,r){t(121)(\"Int8\",1,function(t){return function Int8Array(n,r,e){return t(this,n,r,e)}})},{121:121}],262:[function(t,n,r){t(121)(\"Uint16\",2,function(t){return function Uint16Array(n,r,e){return t(this,n,r,e)}})},{121:121}],263:[function(t,n,r){t(121)(\"Uint32\",4,function(t){return function Uint32Array(n,r,e){return t(this,n,r,e)}})},{121:121}],264:[function(t,n,r){t(121)(\"Uint8\",1,function(t){return function Uint8Array(n,r,e){return t(this,n,r,e)}})},{121:121}],265:[function(t,n,r){t(121)(\"Uint8\",1,function(t){return function Uint8ClampedArray(n,r,e){return t(this,n,r,e)}},!0)},{121:121}],266:[function(t,n,r){\"use strict\";var e,i=t(12)(0),o=t(94),u=t(66),c=t(70),a=t(21),f=t(51),s=t(35),l=t(125),h=u.getWeak,v=Object.isExtensible,p=a.ufstore,d={},y=function(t){return function WeakMap(){return t(this,arguments.length>0?arguments[0]:void 0)}},g={get:function get(t){if(f(t)){var n=h(t);return!0===n?p(l(this,\"WeakMap\")).get(t):n?n[this._i]:void 0}},set:function set(t,n){return a.def(l(this,\"WeakMap\"),t,n)}},m=n.exports=t(22)(\"WeakMap\",y,g,a,!0,!0);s(function(){return 7!=(new m).set((Object.freeze||Object)(d),7).get(d)})&&(e=a.getConstructor(y,\"WeakMap\"),c(e.prototype,g),u.NEED=!0,i([\"delete\",\"has\",\"get\",\"set\"],function(t){var n=m.prototype,r=n[t];o(n,t,function(n,i){if(f(n)&&!v(n)){this._f||(this._f=new e);var o=this._f[t](n,i);return\"set\"==t?this:o}return r.call(this,n,i)})}))},{12:12,125:125,21:21,22:22,35:35,51:51,66:66,70:70,94:94}],267:[function(t,n,r){\"use strict\";var e=t(21),i=t(125);t(22)(\"WeakSet\",function(t){return function WeakSet(){return t(this,arguments.length>0?arguments[0]:void 0)}},{add:function add(t){return e.def(i(this,\"WeakSet\"),t,!0)}},e,!1,!0)},{125:125,21:21,22:22}],268:[function(t,n,r){\"use strict\";var e=t(33),i=t(38),o=t(119),u=t(118),c=t(3),a=t(15);e(e.P,\"Array\",{flatMap:function flatMap(t){var n,r,e=o(this);return c(t),n=u(e.length),r=a(e,0),i(r,e,e,n,0,1,t,arguments[1]),r}}),t(5)(\"flatMap\")},{118:118,119:119,15:15,3:3,33:33,38:38,5:5}],269:[function(t,n,r){\"use strict\";var e=t(33),i=t(38),o=t(119),u=t(118),c=t(116),a=t(15);e(e.P,\"Array\",{flatten:function flatten(){var t=arguments[0],n=o(this),r=u(n.length),e=a(n,0);return i(e,n,n,r,0,void 0===t?1:c(t)),e}}),t(5)(\"flatten\")},{116:116,118:118,119:119,15:15,33:33,38:38,5:5}],270:[function(t,n,r){\"use strict\";var e=t(33),i=t(11)(!0);e(e.P,\"Array\",{includes:function includes(t){return i(this,t,arguments.length>1?arguments[1]:void 0)}}),t(5)(\"includes\")},{11:11,33:33,5:5}],271:[function(t,n,r){var e=t(33),i=t(68)(),o=t(40).process,u=\"process\"==t(18)(o);e(e.G,{asap:function asap(t){var n=u&&o.domain;i(n?n.bind(t):t)}})},{18:18,33:33,40:40,68:68}],272:[function(t,n,r){var e=t(33),i=t(18);e(e.S,\"Error\",{isError:function isError(t){return\"Error\"===i(t)}})},{18:18,33:33}],273:[function(t,n,r){var e=t(33);e(e.G,{global:t(40)})},{33:33,40:40}],274:[function(t,n,r){t(97)(\"Map\")},{97:97}],275:[function(t,n,r){t(98)(\"Map\")},{98:98}],276:[function(t,n,r){var e=t(33);e(e.P+e.R,\"Map\",{toJSON:t(20)(\"Map\")})},{20:20,33:33}],277:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{clamp:function clamp(t,n,r){return Math.min(r,Math.max(n,t))}})},{33:33}],278:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{DEG_PER_RAD:Math.PI/180})},{33:33}],279:[function(t,n,r){var e=t(33),i=180/Math.PI;e(e.S,\"Math\",{degrees:function degrees(t){return t*i}})},{33:33}],280:[function(t,n,r){var e=t(33),i=t(64),o=t(62);e(e.S,\"Math\",{fscale:function fscale(t,n,r,e,u){return o(i(t,n,r,e,u))}})},{33:33,62:62,64:64}],281:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{iaddh:function iaddh(t,n,r,e){var i=t>>>0,o=n>>>0,u=r>>>0;return o+(e>>>0)+((i&u|(i|u)&~(i+u>>>0))>>>31)|0}})},{33:33}],282:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{imulh:function imulh(t,n){var r=+t,e=+n,i=65535&r,o=65535&e,u=r>>16,c=e>>16,a=(u*o>>>0)+(i*o>>>16);return u*c+(a>>16)+((i*c>>>0)+(65535&a)>>16)}})},{33:33}],283:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{isubh:function isubh(t,n,r,e){var i=t>>>0,o=n>>>0,u=r>>>0;return o-(e>>>0)-((~i&u|~(i^u)&i-u>>>0)>>>31)|0}})},{33:33}],284:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{RAD_PER_DEG:180/Math.PI})},{33:33}],285:[function(t,n,r){var e=t(33),i=Math.PI/180;e(e.S,\"Math\",{radians:function radians(t){return t*i}})},{33:33}],286:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{scale:t(64)})},{33:33,64:64}],287:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{signbit:function signbit(t){return(t=+t)!=t?t:0==t?1/t==1/0:t>0}})},{33:33}],288:[function(t,n,r){var e=t(33);e(e.S,\"Math\",{umulh:function umulh(t,n){var r=+t,e=+n,i=65535&r,o=65535&e,u=r>>>16,c=e>>>16,a=(u*o>>>0)+(i*o>>>16);return u*c+(a>>>16)+((i*c>>>0)+(65535&a)>>>16)}})},{33:33}],289:[function(t,n,r){\"use strict\";var e=t(33),i=t(119),o=t(3),u=t(72);t(29)&&e(e.P+t(74),\"Object\",{__defineGetter__:function __defineGetter__(t,n){u.f(i(this),t,{get:o(n),enumerable:!0,configurable:!0})}})},{119:119,29:29,3:3,33:33,72:72,74:74}],290:[function(t,n,r){\"use strict\";var e=t(33),i=t(119),o=t(3),u=t(72);t(29)&&e(e.P+t(74),\"Object\",{__defineSetter__:function __defineSetter__(t,n){u.f(i(this),t,{set:o(n),enumerable:!0,configurable:!0})}})},{119:119,29:29,3:3,33:33,72:72,74:74}],291:[function(t,n,r){var e=t(33),i=t(84)(!0);e(e.S,\"Object\",{entries:function entries(t){return i(t)}})},{33:33,84:84}],292:[function(t,n,r){var e=t(33),i=t(85),o=t(117),u=t(75),c=t(24);e(e.S,\"Object\",{getOwnPropertyDescriptors:function getOwnPropertyDescriptors(t){for(var n,r,e=o(t),a=u.f,f=i(e),s={},l=0;f.length>l;)void 0!==(r=a(e,n=f[l++]))&&c(s,n,r);return s}})},{117:117,24:24,33:33,75:75,85:85}],293:[function(t,n,r){\"use strict\";var e=t(33),i=t(119),o=t(120),u=t(79),c=t(75).f;t(29)&&e(e.P+t(74),\"Object\",{__lookupGetter__:function __lookupGetter__(t){var n,r=i(this),e=o(t,!0);do{if(n=c(r,e))return n.get}while(r=u(r))}})},{119:119,120:120,29:29,33:33,74:74,75:75,79:79}],294:[function(t,n,r){\"use strict\";var e=t(33),i=t(119),o=t(120),u=t(79),c=t(75).f;t(29)&&e(e.P+t(74),\"Object\",{__lookupSetter__:function __lookupSetter__(t){var n,r=i(this),e=o(t,!0);do{if(n=c(r,e))return n.set}while(r=u(r))}})},{119:119,120:120,29:29,33:33,74:74,75:75,79:79}],295:[function(t,n,r){var e=t(33),i=t(84)(!1);e(e.S,\"Object\",{values:function values(t){return i(t)}})},{33:33,84:84}],296:[function(t,n,r){\"use strict\";var e=t(33),i=t(40),o=t(23),u=t(68)(),c=t(128)(\"observable\"),a=t(3),f=t(7),s=t(6),l=t(93),h=t(42),v=t(39),p=v.RETURN,d=function(t){return null==t?void 0:a(t)},y=function(t){var n=t._c;n&&(t._c=void 0,n())},g=function(t){return void 0===t._o},m=function(t){g(t)||(t._o=void 0,y(t))},b=function(t,n){f(t),this._c=void 0,this._o=t,t=new x(this);try{var r=n(t),e=r;null!=r&&(\"function\"==typeof r.unsubscribe?r=function(){e.unsubscribe()}:a(r),this._c=r)}catch(n){return void t.error(n)}g(this)&&y(this)};b.prototype=l({},{unsubscribe:function unsubscribe(){m(this)}});var x=function(t){this._s=t};x.prototype=l({},{next:function next(t){var n=this._s;if(!g(n)){var r=n._o;try{var e=d(r.next);if(e)return e.call(r,t)}catch(t){try{m(n)}finally{throw t}}}},error:function error(t){var n=this._s;if(g(n))throw t;var r=n._o;n._o=void 0;try{var e=d(r.error);if(!e)throw t;t=e.call(r,t)}catch(t){try{y(n)}finally{throw t}}return y(n),t},complete:function complete(t){var n=this._s;if(!g(n)){var r=n._o;n._o=void 0;try{var e=d(r.complete);t=e?e.call(r,t):void 0}catch(t){try{y(n)}finally{throw t}}return y(n),t}}});var S=function Observable(t){s(this,S,\"Observable\",\"_f\")._f=a(t)};l(S.prototype,{subscribe:function subscribe(t){return new b(t,this._f)},forEach:function forEach(t){var n=this;return new(o.Promise||i.Promise)(function(r,e){a(t);var i=n.subscribe({next:function(n){try{return t(n)}catch(t){e(t),i.unsubscribe()}},error:e,complete:r})})}}),l(S,{from:function from(t){var n=\"function\"==typeof this?this:S,r=d(f(t)[c]);if(r){var e=f(r.call(t));return e.constructor===n?e:new n(function(t){return e.subscribe(t)})}return new n(function(n){var r=!1;return u(function(){if(!r){try{if(v(t,!1,function(t){if(n.next(t),r)return p})===p)return}catch(t){if(r)throw t;return void n.error(t)}n.complete()}}),function(){r=!0}})},of:function of(){for(var t=0,n=arguments.length,r=Array(n);t<n;)r[t]=arguments[t++];return new(\"function\"==typeof this?this:S)(function(t){var n=!1;return u(function(){if(!n){for(var e=0;e<r.length;++e)if(t.next(r[e]),n)return;t.complete()}}),function(){n=!0}})}}),h(S.prototype,c,function(){return this}),e(e.G,{Observable:S}),t(100)(\"Observable\")},{100:100,128:128,23:23,3:3,33:33,39:39,40:40,42:42,6:6,68:68,7:7,93:93}],297:[function(t,n,r){\"use strict\";var e=t(33),i=t(23),o=t(40),u=t(104),c=t(91);e(e.P+e.R,\"Promise\",{finally:function(t){var n=u(this,i.Promise||o.Promise),r=\"function\"==typeof t;return this.then(r?function(r){return c(n,t()).then(function(){return r})}:t,r?function(r){return c(n,t()).then(function(){throw r})}:t)}})},{104:104,23:23,33:33,40:40,91:91}],298:[function(t,n,r){\"use strict\";var e=t(33),i=t(69),o=t(90);e(e.S,\"Promise\",{try:function(t){var n=i.f(this),r=o(t);return(r.e?n.reject:n.resolve)(r.v),n.promise}})},{33:33,69:69,90:90}],299:[function(t,n,r){var e=t(67),i=t(7),o=e.key,u=e.set;e.exp({defineMetadata:function defineMetadata(t,n,r,e){u(t,n,i(r),o(e))}})},{67:67,7:7}],300:[function(t,n,r){var e=t(67),i=t(7),o=e.key,u=e.map,c=e.store;e.exp({deleteMetadata:function deleteMetadata(t,n){var r=arguments.length<3?void 0:o(arguments[2]),e=u(i(n),r,!1);if(void 0===e||!e.delete(t))return!1;if(e.size)return!0;var a=c.get(n);return a.delete(r),!!a.size||c.delete(n)}})},{67:67,7:7}],301:[function(t,n,r){var e=t(231),i=t(10),o=t(67),u=t(7),c=t(79),a=o.keys,f=o.key,s=function(t,n){var r=a(t,n),o=c(t);if(null===o)return r;var u=s(o,n);return u.length?r.length?i(new e(r.concat(u))):u:r};o.exp({getMetadataKeys:function getMetadataKeys(t){return s(u(t),arguments.length<2?void 0:f(arguments[1]))}})},{10:10,231:231,67:67,7:7,79:79}],302:[function(t,n,r){var e=t(67),i=t(7),o=t(79),u=e.has,c=e.get,a=e.key,f=function(t,n,r){if(u(t,n,r))return c(t,n,r);var e=o(n);return null!==e?f(t,e,r):void 0};e.exp({getMetadata:function getMetadata(t,n){return f(t,i(n),arguments.length<3?void 0:a(arguments[2]))}})},{67:67,7:7,79:79}],303:[function(t,n,r){var e=t(67),i=t(7),o=e.keys,u=e.key;e.exp({getOwnMetadataKeys:function getOwnMetadataKeys(t){return o(i(t),arguments.length<2?void 0:u(arguments[1]))}})},{67:67,7:7}],304:[function(t,n,r){var e=t(67),i=t(7),o=e.get,u=e.key;e.exp({getOwnMetadata:function getOwnMetadata(t,n){return o(t,i(n),arguments.length<3?void 0:u(arguments[2]))}})},{67:67,7:7}],305:[function(t,n,r){var e=t(67),i=t(7),o=t(79),u=e.has,c=e.key,a=function(t,n,r){if(u(t,n,r))return!0;var e=o(n);return null!==e&&a(t,e,r)};e.exp({hasMetadata:function hasMetadata(t,n){return a(t,i(n),arguments.length<3?void 0:c(arguments[2]))}})},{67:67,7:7,79:79}],306:[function(t,n,r){var e=t(67),i=t(7),o=e.has,u=e.key;e.exp({hasOwnMetadata:function hasOwnMetadata(t,n){return o(t,i(n),arguments.length<3?void 0:u(arguments[2]))}})},{67:67,7:7}],307:[function(t,n,r){var e=t(67),i=t(7),o=t(3),u=e.key,c=e.set;e.exp({metadata:function metadata(t,n){return function decorator(r,e){c(t,n,(void 0!==e?i:o)(r),u(e))}}})},{3:3,67:67,7:7}],308:[function(t,n,r){t(97)(\"Set\")},{97:97}],309:[function(t,n,r){t(98)(\"Set\")},{98:98}],310:[function(t,n,r){var e=t(33);e(e.P+e.R,\"Set\",{toJSON:t(20)(\"Set\")})},{20:20,33:33}],311:[function(t,n,r){\"use strict\";var e=t(33),i=t(106)(!0);e(e.P,\"String\",{at:function at(t){return i(this,t)}})},{106:106,33:33}],312:[function(t,n,r){\"use strict\";var e=t(33),i=t(28),o=t(118),u=t(52),c=t(37),a=RegExp.prototype,f=function(t,n){this._r=t,this._s=n};t(54)(f,\"RegExp String\",function next(){var t=this._r.exec(this._s);return{value:t,done:null===t}}),e(e.P,\"String\",{matchAll:function matchAll(t){if(i(this),!u(t))throw TypeError(t+\" is not a regexp!\");var n=String(this),r=\"flags\"in a?String(t.flags):c.call(t),e=new RegExp(t.source,~r.indexOf(\"g\")?r:\"g\"+r);return e.lastIndex=o(t.lastIndex),new f(e,n)}})},{118:118,28:28,33:33,37:37,52:52,54:54}],313:[function(t,n,r){\"use strict\";var e=t(33),i=t(109);e(e.P,\"String\",{padEnd:function padEnd(t){return i(this,t,arguments.length>1?arguments[1]:void 0,!1)}})},{109:109,33:33}],314:[function(t,n,r){\"use strict\";var e=t(33),i=t(109);e(e.P,\"String\",{padStart:function padStart(t){return i(this,t,arguments.length>1?arguments[1]:void 0,!0)}})},{109:109,33:33}],315:[function(t,n,r){\"use strict\";t(111)(\"trimLeft\",function(t){return function trimLeft(){return t(this,1)}},\"trimStart\")},{111:111}],316:[function(t,n,r){\"use strict\";t(111)(\"trimRight\",function(t){return function trimRight(){return t(this,2)}},\"trimEnd\")},{111:111}],317:[function(t,n,r){t(126)(\"asyncIterator\")},{126:126}],318:[function(t,n,r){t(126)(\"observable\")},{126:126}],319:[function(t,n,r){var e=t(33);e(e.S,\"System\",{global:t(40)})},{33:33,40:40}],320:[function(t,n,r){t(97)(\"WeakMap\")},{97:97}],321:[function(t,n,r){t(98)(\"WeakMap\")},{98:98}],322:[function(t,n,r){t(97)(\"WeakSet\")},{97:97}],323:[function(t,n,r){t(98)(\"WeakSet\")},{98:98}],324:[function(t,n,r){for(var e=t(141),i=t(81),o=t(94),u=t(40),c=t(42),a=t(58),f=t(128),s=f(\"iterator\"),l=f(\"toStringTag\"),h=a.Array,v={CSSRuleList:!0,CSSStyleDeclaration:!1,CSSValueList:!1,ClientRectList:!1,DOMRectList:!1,DOMStringList:!1,DOMTokenList:!0,DataTransferItemList:!1,FileList:!1,HTMLAllCollection:!1,HTMLCollection:!1,HTMLFormElement:!1,HTMLSelectElement:!1,MediaList:!0,MimeTypeArray:!1,NamedNodeMap:!1,NodeList:!0,PaintRequestList:!1,Plugin:!1,PluginArray:!1,SVGLengthList:!1,SVGNumberList:!1,SVGPathSegList:!1,SVGPointList:!1,SVGStringList:!1,SVGTransformList:!1,SourceBufferList:!1,StyleSheetList:!0,TextTrackCueList:!1,TextTrackList:!1,TouchList:!1},p=i(v),d=0;d<p.length;d++){var y,g=p[d],m=v[g],b=u[g],x=b&&b.prototype;if(x&&(x[s]||c(x,s,h),x[l]||c(x,l,g),a[g]=h,m))for(y in e)x[y]||o(x,y,e[y],!0)}},{128:128,141:141,40:40,42:42,58:58,81:81,94:94}],325:[function(t,n,r){var e=t(33),i=t(113);e(e.G+e.B,{setImmediate:i.set,clearImmediate:i.clear})},{113:113,33:33}],326:[function(t,n,r){var e=t(40),i=t(33),o=t(46),u=t(88),c=e.navigator,a=!!c&&/MSIE .\\./.test(c.userAgent),f=function(t){return a?function(n,r){return t(o(u,[].slice.call(arguments,2),\"function\"==typeof n?n:Function(n)),r)}:t};i(i.G+i.B+i.F*a,{setTimeout:f(e.setTimeout),setInterval:f(e.setInterval)})},{33:33,40:40,46:46,88:88}],327:[function(t,n,r){t(254),t(191),t(193),t(192),t(195),t(197),t(202),t(196),t(194),t(204),t(203),t(199),t(200),t(198),t(190),t(201),t(205),t(206),t(157),t(159),t(158),t(208),t(207),t(178),t(188),t(189),t(179),t(180),t(181),t(182),t(183),t(184),t(185),t(186),t(187),t(161),t(162),t(163),t(164),t(165),t(166),t(167),t(168),t(169),t(170),t(171),t(172),t(173),t(174),t(175),t(176),t(177),t(241),t(246),t(253),t(244),t(236),t(237),t(242),t(247),t(249),t(232),t(233),t(234),t(235),t(238),t(239),t(240),t(243),t(245),t(248),t(250),t(251),t(252),t(152),t(154),t(153),t(156),t(155),t(140),t(138),t(145),t(142),t(148),t(150),t(137),t(144),t(134),t(149),t(132),t(147),t(146),t(139),t(143),t(131),t(133),t(136),t(135),t(151),t(141),t(224),t(230),t(225),t(226),t(227),t(228),t(229),t(209),t(160),t(231),t(266),t(267),t(255),t(256),t(261),t(264),t(265),t(259),t(262),t(260),t(263),t(257),t(258),t(210),t(211),t(212),t(213),t(214),t(217),t(215),t(216),t(218),t(219),t(220),t(221),t(223),t(222),t(270),t(268),t(269),t(311),t(314),t(313),t(315),t(316),t(312),t(317),t(318),t(292),t(295),t(291),t(289),t(290),t(293),t(294),t(276),t(310),t(275),t(309),t(321),t(323),t(274),t(308),t(320),t(322),t(273),t(319),t(272),t(277),t(278),t(279),t(280),t(281),t(283),t(282),t(284),t(285),t(286),t(288),t(287),t(297),t(298),t(299),t(300),t(302),t(301),t(304),t(303),t(305),t(306),t(307),t(271),t(296),t(326),t(325),t(324),n.exports=t(23)},{131:131,132:132,133:133,134:134,135:135,136:136,137:137,138:138,139:139,140:140,141:141,142:142,143:143,144:144,145:145,146:146,147:147,148:148,149:149,150:150,151:151,152:152,153:153,154:154,155:155,156:156,157:157,158:158,159:159,160:160,161:161,162:162,163:163,164:164,165:165,166:166,167:167,168:168,169:169,170:170,171:171,172:172,173:173,174:174,175:175,176:176,177:177,178:178,179:179,180:180,181:181,182:182,183:183,184:184,185:185,\n186:186,187:187,188:188,189:189,190:190,191:191,192:192,193:193,194:194,195:195,196:196,197:197,198:198,199:199,200:200,201:201,202:202,203:203,204:204,205:205,206:206,207:207,208:208,209:209,210:210,211:211,212:212,213:213,214:214,215:215,216:216,217:217,218:218,219:219,220:220,221:221,222:222,223:223,224:224,225:225,226:226,227:227,228:228,229:229,23:23,230:230,231:231,232:232,233:233,234:234,235:235,236:236,237:237,238:238,239:239,240:240,241:241,242:242,243:243,244:244,245:245,246:246,247:247,248:248,249:249,250:250,251:251,252:252,253:253,254:254,255:255,256:256,257:257,258:258,259:259,260:260,261:261,262:262,263:263,264:264,265:265,266:266,267:267,268:268,269:269,270:270,271:271,272:272,273:273,274:274,275:275,276:276,277:277,278:278,279:279,280:280,281:281,282:282,283:283,284:284,285:285,286:286,287:287,288:288,289:289,290:290,291:291,292:292,293:293,294:294,295:295,296:296,297:297,298:298,299:299,300:300,301:301,302:302,303:303,304:304,305:305,306:306,307:307,308:308,309:309,310:310,311:311,312:312,313:313,314:314,315:315,316:316,317:317,318:318,319:319,320:320,321:321,322:322,323:323,324:324,325:325,326:326}],328:[function(t,n,r){(function(t){!function(t){\"use strict\";function wrap(t,n,r,e){var i=n&&n.prototype instanceof Generator?n:Generator,o=Object.create(i.prototype),u=new Context(e||[]);return o._invoke=makeInvokeMethod(t,r,u),o}function tryCatch(t,n,r){try{return{type:\"normal\",arg:t.call(n,r)}}catch(t){return{type:\"throw\",arg:t}}}function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}function defineIteratorMethods(t){[\"next\",\"throw\",\"return\"].forEach(function(n){t[n]=function(t){return this._invoke(n,t)}})}function AsyncIterator(n){function invoke(t,r,e,o){var u=tryCatch(n[t],n,r);if(\"throw\"!==u.type){var c=u.arg,a=c.value;return a&&\"object\"==typeof a&&i.call(a,\"__await\")?Promise.resolve(a.__await).then(function(t){invoke(\"next\",t,e,o)},function(t){invoke(\"throw\",t,e,o)}):Promise.resolve(a).then(function(t){c.value=t,e(c)},o)}o(u.arg)}function enqueue(t,n){function callInvokeWithMethodAndArg(){return new Promise(function(r,e){invoke(t,n,r,e)})}return r=r?r.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg()}\"object\"==typeof t.process&&t.process.domain&&(invoke=t.process.domain.bind(invoke));var r;this._invoke=enqueue}function makeInvokeMethod(t,n,r){var e=l;return function invoke(i,o){if(e===v)throw new Error(\"Generator is already running\");if(e===p){if(\"throw\"===i)throw o;return doneResult()}for(r.method=i,r.arg=o;;){var u=r.delegate;if(u){var c=maybeInvokeDelegate(u,r);if(c){if(c===d)continue;return c}}if(\"next\"===r.method)r.sent=r._sent=r.arg;else if(\"throw\"===r.method){if(e===l)throw e=p,r.arg;r.dispatchException(r.arg)}else\"return\"===r.method&&r.abrupt(\"return\",r.arg);e=v;var a=tryCatch(t,n,r);if(\"normal\"===a.type){if(e=r.done?p:h,a.arg===d)continue;return{value:a.arg,done:r.done}}\"throw\"===a.type&&(e=p,r.method=\"throw\",r.arg=a.arg)}}}function maybeInvokeDelegate(t,n){var e=t.iterator[n.method];if(e===r){if(n.delegate=null,\"throw\"===n.method){if(t.iterator.return&&(n.method=\"return\",n.arg=r,maybeInvokeDelegate(t,n),\"throw\"===n.method))return d;n.method=\"throw\",n.arg=new TypeError(\"The iterator does not provide a 'throw' method\")}return d}var i=tryCatch(e,t.iterator,n.arg);if(\"throw\"===i.type)return n.method=\"throw\",n.arg=i.arg,n.delegate=null,d;var o=i.arg;return o?o.done?(n[t.resultName]=o.value,n.next=t.nextLoc,\"return\"!==n.method&&(n.method=\"next\",n.arg=r),n.delegate=null,d):o:(n.method=\"throw\",n.arg=new TypeError(\"iterator result is not an object\"),n.delegate=null,d)}function pushTryEntry(t){var n={tryLoc:t[0]};1 in t&&(n.catchLoc=t[1]),2 in t&&(n.finallyLoc=t[2],n.afterLoc=t[3]),this.tryEntries.push(n)}function resetTryEntry(t){var n=t.completion||{};n.type=\"normal\",delete n.arg,t.completion=n}function Context(t){this.tryEntries=[{tryLoc:\"root\"}],t.forEach(pushTryEntry,this),this.reset(!0)}function values(t){if(t){var n=t[u];if(n)return n.call(t);if(\"function\"==typeof t.next)return t;if(!isNaN(t.length)){var e=-1,o=function next(){for(;++e<t.length;)if(i.call(t,e))return next.value=t[e],next.done=!1,next;return next.value=r,next.done=!0,next};return o.next=o}}return{next:doneResult}}function doneResult(){return{value:r,done:!0}}var r,e=Object.prototype,i=e.hasOwnProperty,o=\"function\"==typeof Symbol?Symbol:{},u=o.iterator||\"@@iterator\",c=o.asyncIterator||\"@@asyncIterator\",a=o.toStringTag||\"@@toStringTag\",f=\"object\"==typeof n,s=t.regeneratorRuntime;if(s)return void(f&&(n.exports=s));s=t.regeneratorRuntime=f?n.exports:{},s.wrap=wrap;var l=\"suspendedStart\",h=\"suspendedYield\",v=\"executing\",p=\"completed\",d={},y={};y[u]=function(){return this};var g=Object.getPrototypeOf,m=g&&g(g(values([])));m&&m!==e&&i.call(m,u)&&(y=m);var b=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(y);GeneratorFunction.prototype=b.constructor=GeneratorFunctionPrototype,GeneratorFunctionPrototype.constructor=GeneratorFunction,GeneratorFunctionPrototype[a]=GeneratorFunction.displayName=\"GeneratorFunction\",s.isGeneratorFunction=function(t){var n=\"function\"==typeof t&&t.constructor;return!!n&&(n===GeneratorFunction||\"GeneratorFunction\"===(n.displayName||n.name))},s.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,GeneratorFunctionPrototype):(t.__proto__=GeneratorFunctionPrototype,a in t||(t[a]=\"GeneratorFunction\")),t.prototype=Object.create(b),t},s.awrap=function(t){return{__await:t}},defineIteratorMethods(AsyncIterator.prototype),AsyncIterator.prototype[c]=function(){return this},s.AsyncIterator=AsyncIterator,s.async=function(t,n,r,e){var i=new AsyncIterator(wrap(t,n,r,e));return s.isGeneratorFunction(n)?i:i.next().then(function(t){return t.done?t.value:i.next()})},defineIteratorMethods(b),b[a]=\"Generator\",b[u]=function(){return this},b.toString=function(){return\"[object Generator]\"},s.keys=function(t){var n=[];for(var r in t)n.push(r);return n.reverse(),function next(){for(;n.length;){var r=n.pop();if(r in t)return next.value=r,next.done=!1,next}return next.done=!0,next}},s.values=values,Context.prototype={constructor:Context,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=r,this.done=!1,this.delegate=null,this.method=\"next\",this.arg=r,this.tryEntries.forEach(resetTryEntry),!t)for(var n in this)\"t\"===n.charAt(0)&&i.call(this,n)&&!isNaN(+n.slice(1))&&(this[n]=r)},stop:function(){this.done=!0;var t=this.tryEntries[0],n=t.completion;if(\"throw\"===n.type)throw n.arg;return this.rval},dispatchException:function(t){function handle(e,i){return u.type=\"throw\",u.arg=t,n.next=e,i&&(n.method=\"next\",n.arg=r),!!i}if(this.done)throw t;for(var n=this,e=this.tryEntries.length-1;e>=0;--e){var o=this.tryEntries[e],u=o.completion;if(\"root\"===o.tryLoc)return handle(\"end\");if(o.tryLoc<=this.prev){var c=i.call(o,\"catchLoc\"),a=i.call(o,\"finallyLoc\");if(c&&a){if(this.prev<o.catchLoc)return handle(o.catchLoc,!0);if(this.prev<o.finallyLoc)return handle(o.finallyLoc)}else if(c){if(this.prev<o.catchLoc)return handle(o.catchLoc,!0)}else{if(!a)throw new Error(\"try statement without catch or finally\");if(this.prev<o.finallyLoc)return handle(o.finallyLoc)}}}},abrupt:function(t,n){for(var r=this.tryEntries.length-1;r>=0;--r){var e=this.tryEntries[r];if(e.tryLoc<=this.prev&&i.call(e,\"finallyLoc\")&&this.prev<e.finallyLoc){var o=e;break}}o&&(\"break\"===t||\"continue\"===t)&&o.tryLoc<=n&&n<=o.finallyLoc&&(o=null);var u=o?o.completion:{};return u.type=t,u.arg=n,o?(this.method=\"next\",this.next=o.finallyLoc,d):this.complete(u)},complete:function(t,n){if(\"throw\"===t.type)throw t.arg;return\"break\"===t.type||\"continue\"===t.type?this.next=t.arg:\"return\"===t.type?(this.rval=this.arg=t.arg,this.method=\"return\",this.next=\"end\"):\"normal\"===t.type&&n&&(this.next=n),d},finish:function(t){for(var n=this.tryEntries.length-1;n>=0;--n){var r=this.tryEntries[n];if(r.finallyLoc===t)return this.complete(r.completion,r.afterLoc),resetTryEntry(r),d}},catch:function(t){for(var n=this.tryEntries.length-1;n>=0;--n){var r=this.tryEntries[n];if(r.tryLoc===t){var e=r.completion;if(\"throw\"===e.type){var i=e.arg;resetTryEntry(r)}return i}}throw new Error(\"illegal catch attempt\")},delegateYield:function(t,n,e){return this.delegate={iterator:values(t),resultName:n,nextLoc:e},\"next\"===this.method&&(this.arg=r),d}}}(\"object\"==typeof t?t:\"object\"==typeof window?window:\"object\"==typeof self?self:this)}).call(this,\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:{})},{}]},{},[1]);\n","Magento_PageBuilder/js/resource/slick/slick.min.js":"/*\n     _ _      _       _\n ___| (_) ___| | __  (_)___\n/ __| | |/ __| |/ /  | / __|\n\\__ \\ | | (__|   < _ | \\__ \\\n|___/_|_|\\___|_|\\_(_)/ |___/\n                   |__/\n\n Version: 1.9.0\n  Author: Ken Wheeler\n Website: http://kenwheeler.github.io\n    Docs: http://kenwheeler.github.io/slick\n    Repo: http://github.com/kenwheeler/slick\n  Issues: http://github.com/kenwheeler/slick/issues\n\n */\n(function(i){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],i):\"undefined\"!=typeof exports?module.exports=i(require(\"jquery\")):i(jQuery)})(function(i){\"use strict\";var e=window.Slick||{};e=function(){function e(e,o){var s,n=this;n.defaults={accessibility:!0,adaptiveHeight:!1,appendArrows:i(e),appendDots:i(e),arrows:!0,asNavFor:null,prevArrow:'<button class=\"slick-prev\" aria-label=\"Previous\" type=\"button\">Previous</button>',nextArrow:'<button class=\"slick-next\" aria-label=\"Next\" type=\"button\">Next</button>',autoplay:!1,autoplaySpeed:3e3,centerMode:!1,centerPadding:\"50px\",cssEase:\"ease\",customPaging:function(e,t){return i('<button type=\"button\" />').text(t+1)},dots:!1,dotsClass:\"slick-dots\",draggable:!0,easing:\"linear\",edgeFriction:.35,fade:!1,focusOnSelect:!1,focusOnChange:!1,infinite:!0,initialSlide:0,lazyLoad:\"ondemand\",mobileFirst:!1,pauseOnHover:!0,pauseOnFocus:!0,pauseOnDotsHover:!1,respondTo:\"window\",responsive:null,rows:1,rtl:!1,slide:\"\",slidesPerRow:1,slidesToShow:1,slidesToScroll:1,speed:500,swipe:!0,swipeToSlide:!1,touchMove:!0,touchThreshold:5,useCSS:!0,useTransform:!0,variableWidth:!1,vertical:!1,verticalSwiping:!1,waitForAnimate:!0,zIndex:1e3},n.initials={animating:!1,dragging:!1,autoPlayTimer:null,currentDirection:0,currentLeft:null,currentSlide:0,direction:1,$dots:null,listWidth:null,listHeight:null,loadIndex:0,$nextArrow:null,$prevArrow:null,scrolling:!1,slideCount:null,slideWidth:null,$slideTrack:null,$slides:null,sliding:!1,slideOffset:0,swipeLeft:null,swiping:!1,$list:null,touchObject:{},transformsEnabled:!1,unslicked:!1},i.extend(n,n.initials),n.activeBreakpoint=null,n.animType=null,n.animProp=null,n.breakpoints=[],n.breakpointSettings=[],n.cssTransitions=!1,n.focussed=!1,n.interrupted=!1,n.hidden=\"hidden\",n.paused=!0,n.positionProp=null,n.respondTo=null,n.rowCount=1,n.shouldClick=!0,n.$slider=i(e),n.$slidesCache=null,n.transformType=null,n.transitionType=null,n.visibilityChange=\"visibilitychange\",n.windowWidth=0,n.windowTimer=null,s=i(e).data(\"slick\")||{},n.options=i.extend({},n.defaults,o,s),n.currentSlide=n.options.initialSlide,n.originalSettings=n.options,\"undefined\"!=typeof document.mozHidden?(n.hidden=\"mozHidden\",n.visibilityChange=\"mozvisibilitychange\"):\"undefined\"!=typeof document.webkitHidden&&(n.hidden=\"webkitHidden\",n.visibilityChange=\"webkitvisibilitychange\"),n.autoPlay=i.proxy(n.autoPlay,n),n.autoPlayClear=i.proxy(n.autoPlayClear,n),n.autoPlayIterator=i.proxy(n.autoPlayIterator,n),n.changeSlide=i.proxy(n.changeSlide,n),n.clickHandler=i.proxy(n.clickHandler,n),n.selectHandler=i.proxy(n.selectHandler,n),n.setPosition=i.proxy(n.setPosition,n),n.swipeHandler=i.proxy(n.swipeHandler,n),n.dragHandler=i.proxy(n.dragHandler,n),n.keyHandler=i.proxy(n.keyHandler,n),n.instanceUid=t++,n.htmlExpr=/^(?:\\s*(<[\\w\\W]+>)[^>]*)$/,n.registerBreakpoints(),n.init(!0)}var t=0;return e}(),e.prototype.activateADA=function(){var i=this;i.$slideTrack.find(\".slick-active\").attr({\"aria-hidden\":\"false\"}).find(\"a, input, button, select\").attr({tabindex:\"0\"})},e.prototype.addSlide=e.prototype.slickAdd=function(e,t,o){var s=this;if(\"boolean\"==typeof t)o=t,t=null;else if(t<0||t>=s.slideCount)return!1;s.unload(),\"number\"==typeof t?0===t&&0===s.$slides.length?i(e).appendTo(s.$slideTrack):o?i(e).insertBefore(s.$slides.eq(t)):i(e).insertAfter(s.$slides.eq(t)):o===!0?i(e).prependTo(s.$slideTrack):i(e).appendTo(s.$slideTrack),s.$slides=s.$slideTrack.children(this.options.slide),s.$slideTrack.children(this.options.slide).detach(),s.$slideTrack.append(s.$slides),s.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e)}),s.$slidesCache=s.$slides,s.reinit()},e.prototype.animateHeight=function(){var i=this;if(1===i.options.slidesToShow&&i.options.adaptiveHeight===!0&&i.options.vertical===!1){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.animate({height:e},i.options.speed)}},e.prototype.animateSlide=function(e,t){var o={},s=this;s.animateHeight(),s.options.rtl===!0&&s.options.vertical===!1&&(e=-e),s.transformsEnabled===!1?s.options.vertical===!1?s.$slideTrack.animate({left:e},s.options.speed,s.options.easing,t):s.$slideTrack.animate({top:e},s.options.speed,s.options.easing,t):s.cssTransitions===!1?(s.options.rtl===!0&&(s.currentLeft=-s.currentLeft),i({animStart:s.currentLeft}).animate({animStart:e},{duration:s.options.speed,easing:s.options.easing,step:function(i){i=Math.ceil(i),s.options.vertical===!1?(o[s.animType]=\"translate(\"+i+\"px, 0px)\",s.$slideTrack.css(o)):(o[s.animType]=\"translate(0px,\"+i+\"px)\",s.$slideTrack.css(o))},complete:function(){t&&t.call()}})):(s.applyTransition(),e=Math.ceil(e),s.options.vertical===!1?o[s.animType]=\"translate3d(\"+e+\"px, 0px, 0px)\":o[s.animType]=\"translate3d(0px,\"+e+\"px, 0px)\",s.$slideTrack.css(o),t&&setTimeout(function(){s.disableTransition(),t.call()},s.options.speed))},e.prototype.getNavTarget=function(){var e=this,t=e.options.asNavFor;return t&&null!==t&&(t=i(t).not(e.$slider)),t},e.prototype.asNavFor=function(e){var t=this,o=t.getNavTarget();null!==o&&\"object\"==typeof o&&o.each(function(){var t=i(this).slick(\"getSlick\");t.unslicked||t.slideHandler(e,!0)})},e.prototype.applyTransition=function(i){var e=this,t={};e.options.fade===!1?t[e.transitionType]=e.transformType+\" \"+e.options.speed+\"ms \"+e.options.cssEase:t[e.transitionType]=\"opacity \"+e.options.speed+\"ms \"+e.options.cssEase,e.options.fade===!1?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.autoPlay=function(){var i=this;i.autoPlayClear(),i.slideCount>i.options.slidesToShow&&(i.autoPlayTimer=setInterval(i.autoPlayIterator,i.options.autoplaySpeed))},e.prototype.autoPlayClear=function(){var i=this;i.autoPlayTimer&&clearInterval(i.autoPlayTimer)},e.prototype.autoPlayIterator=function(){var i=this,e=i.currentSlide+i.options.slidesToScroll;i.paused||i.interrupted||i.focussed||(i.options.infinite===!1&&(1===i.direction&&i.currentSlide+1===i.slideCount-1?i.direction=0:0===i.direction&&(e=i.currentSlide-i.options.slidesToScroll,i.currentSlide-1===0&&(i.direction=1))),i.slideHandler(e))},e.prototype.buildArrows=function(){var e=this;e.options.arrows===!0&&(e.$prevArrow=i(e.options.prevArrow).addClass(\"slick-arrow\"),e.$nextArrow=i(e.options.nextArrow).addClass(\"slick-arrow\"),e.slideCount>e.options.slidesToShow?(e.$prevArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.$nextArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.prependTo(e.options.appendArrows),e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.appendTo(e.options.appendArrows),e.options.infinite!==!0&&e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\")):e.$prevArrow.add(e.$nextArrow).addClass(\"slick-hidden\").attr({\"aria-disabled\":\"true\",tabindex:\"-1\"}))},e.prototype.buildDots=function(){var e,t,o=this;if(o.options.dots===!0&&o.slideCount>o.options.slidesToShow){for(o.$slider.addClass(\"slick-dotted\"),t=i(\"<ul />\").addClass(o.options.dotsClass),e=0;e<=o.getDotCount();e+=1)t.append(i(\"<li />\").append(o.options.customPaging.call(this,o,e)));o.$dots=t.appendTo(o.options.appendDots),o.$dots.find(\"li\").first().addClass(\"slick-active\")}},e.prototype.buildOut=function(){var e=this;e.$slides=e.$slider.children(e.options.slide+\":not(.slick-cloned)\").addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e).data(\"originalStyling\",i(t).attr(\"style\")||\"\")}),e.$slider.addClass(\"slick-slider\"),e.$slideTrack=0===e.slideCount?i('<div class=\"slick-track\"/>').appendTo(e.$slider):e.$slides.wrapAll('<div class=\"slick-track\"/>').parent(),e.$list=e.$slideTrack.wrap('<div class=\"slick-list\"/>').parent(),e.$slideTrack.css(\"opacity\",0),e.options.centerMode!==!0&&e.options.swipeToSlide!==!0||(e.options.slidesToScroll=1),i(\"img[data-lazy]\",e.$slider).not(\"[src]\").addClass(\"slick-loading\"),e.setupInfinite(),e.buildArrows(),e.buildDots(),e.updateDots(),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.options.draggable===!0&&e.$list.addClass(\"draggable\")},e.prototype.buildRows=function(){var i,e,t,o,s,n,r,l=this;if(o=document.createDocumentFragment(),n=l.$slider.children(),l.options.rows>0){for(r=l.options.slidesPerRow*l.options.rows,s=Math.ceil(n.length/r),i=0;i<s;i++){var d=document.createElement(\"div\");for(e=0;e<l.options.rows;e++){var a=document.createElement(\"div\");for(t=0;t<l.options.slidesPerRow;t++){var c=i*r+(e*l.options.slidesPerRow+t);n.get(c)&&a.appendChild(n.get(c))}d.appendChild(a)}o.appendChild(d)}l.$slider.empty().append(o),l.$slider.children().children().children().css({width:100/l.options.slidesPerRow+\"%\",display:\"inline-block\"})}},e.prototype.checkResponsive=function(e,t){var o,s,n,r=this,l=!1,d=r.$slider.width(),a=window.innerWidth||i(window).width();if(\"window\"===r.respondTo?n=a:\"slider\"===r.respondTo?n=d:\"min\"===r.respondTo&&(n=Math.min(a,d)),r.options.responsive&&r.options.responsive.length&&null!==r.options.responsive){s=null;for(o in r.breakpoints)r.breakpoints.hasOwnProperty(o)&&(r.originalSettings.mobileFirst===!1?n<r.breakpoints[o]&&(s=r.breakpoints[o]):n>r.breakpoints[o]&&(s=r.breakpoints[o]));null!==s?null!==r.activeBreakpoint?(s!==r.activeBreakpoint||t)&&(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):null!==r.activeBreakpoint&&(r.activeBreakpoint=null,r.options=r.originalSettings,e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e),l=s),e||l===!1||r.$slider.trigger(\"breakpoint\",[r,l])}},e.prototype.changeSlide=function(e,t){var o,s,n,r=this,l=i(e.currentTarget);switch(l.is(\"a\")&&e.preventDefault(),l.is(\"li\")||(l=l.closest(\"li\")),n=r.slideCount%r.options.slidesToScroll!==0,o=n?0:(r.slideCount-r.currentSlide)%r.options.slidesToScroll,e.data.message){case\"previous\":s=0===o?r.options.slidesToScroll:r.options.slidesToShow-o,r.slideCount>r.options.slidesToShow&&r.slideHandler(r.currentSlide-s,!1,t);break;case\"next\":s=0===o?r.options.slidesToScroll:o,r.slideCount>r.options.slidesToShow&&r.slideHandler(r.currentSlide+s,!1,t);break;case\"index\":var d=0===e.data.index?0:e.data.index||l.index()*r.options.slidesToScroll;r.slideHandler(r.checkNavigable(d),!1,t),l.children().trigger(\"focus\");break;default:return}},e.prototype.checkNavigable=function(i){var e,t,o=this;if(e=o.getNavigableIndexes(),t=0,i>e[e.length-1])i=e[e.length-1];else for(var s in e){if(i<e[s]){i=t;break}t=e[s]}return i},e.prototype.cleanUpEvents=function(){var e=this;e.options.dots&&null!==e.$dots&&(i(\"li\",e.$dots).off(\"click.slick\",e.changeSlide).off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)),e.options.accessibility===!0&&e.$dots.off(\"keydown.slick\",e.keyHandler)),e.$slider.off(\"focus.slick blur.slick\"),e.options.arrows===!0&&e.slideCount>e.options.slidesToShow&&(e.$prevArrow&&e.$prevArrow.off(\"click.slick\",e.changeSlide),e.$nextArrow&&e.$nextArrow.off(\"click.slick\",e.changeSlide),e.options.accessibility===!0&&(e.$prevArrow&&e.$prevArrow.off(\"keydown.slick\",e.keyHandler),e.$nextArrow&&e.$nextArrow.off(\"keydown.slick\",e.keyHandler))),e.$list.off(\"touchstart.slick mousedown.slick\",e.swipeHandler),e.$list.off(\"touchmove.slick mousemove.slick\",e.swipeHandler),e.$list.off(\"touchend.slick mouseup.slick\",e.swipeHandler),e.$list.off(\"touchcancel.slick mouseleave.slick\",e.swipeHandler),e.$list.off(\"click.slick\",e.clickHandler),i(document).off(e.visibilityChange,e.visibility),e.cleanUpSlideEvents(),e.options.accessibility===!0&&e.$list.off(\"keydown.slick\",e.keyHandler),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().off(\"click.slick\",e.selectHandler),i(window).off(\"orientationchange.slick.slick-\"+e.instanceUid,e.orientationChange),i(window).off(\"resize.slick.slick-\"+e.instanceUid,e.resize),i(\"[draggable!=true]\",e.$slideTrack).off(\"dragstart\",e.preventDefault),i(window).off(\"load.slick.slick-\"+e.instanceUid,e.setPosition)},e.prototype.cleanUpSlideEvents=function(){var e=this;e.$list.off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.cleanUpRows=function(){var i,e=this;e.options.rows>0&&(i=e.$slides.children().children(),i.removeAttr(\"style\"),e.$slider.empty().append(i))},e.prototype.clickHandler=function(i){var e=this;e.shouldClick===!1&&(i.stopImmediatePropagation(),i.stopPropagation(),i.preventDefault())},e.prototype.destroy=function(e){var t=this;t.autoPlayClear(),t.touchObject={},t.cleanUpEvents(),i(\".slick-cloned\",t.$slider).detach(),t.$dots&&t.$dots.remove(),t.$prevArrow&&t.$prevArrow.length&&(t.$prevArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.prevArrow)&&t.$prevArrow.remove()),t.$nextArrow&&t.$nextArrow.length&&(t.$nextArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.nextArrow)&&t.$nextArrow.remove()),t.$slides&&(t.$slides.removeClass(\"slick-slide slick-active slick-center slick-visible slick-current\").removeAttr(\"aria-hidden\").removeAttr(\"data-slick-index\").each(function(){i(this).attr(\"style\",i(this).data(\"originalStyling\"))}),t.$slideTrack.children(this.options.slide).detach(),t.$slideTrack.detach(),t.$list.detach(),t.$slider.append(t.$slides)),t.cleanUpRows(),t.$slider.removeClass(\"slick-slider\"),t.$slider.removeClass(\"slick-initialized\"),t.$slider.removeClass(\"slick-dotted\"),t.unslicked=!0,e||t.$slider.trigger(\"destroy\",[t])},e.prototype.disableTransition=function(i){var e=this,t={};t[e.transitionType]=\"\",e.options.fade===!1?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.fadeSlide=function(i,e){var t=this;t.cssTransitions===!1?(t.$slides.eq(i).css({zIndex:t.options.zIndex}),t.$slides.eq(i).animate({opacity:1},t.options.speed,t.options.easing,e)):(t.applyTransition(i),t.$slides.eq(i).css({opacity:1,zIndex:t.options.zIndex}),e&&setTimeout(function(){t.disableTransition(i),e.call()},t.options.speed))},e.prototype.fadeSlideOut=function(i){var e=this;e.cssTransitions===!1?e.$slides.eq(i).animate({opacity:0,zIndex:e.options.zIndex-2},e.options.speed,e.options.easing):(e.applyTransition(i),e.$slides.eq(i).css({opacity:0,zIndex:e.options.zIndex-2}))},e.prototype.filterSlides=e.prototype.slickFilter=function(i){var e=this;null!==i&&(e.$slidesCache=e.$slides,e.unload(),e.$slideTrack.children(this.options.slide).detach(),e.$slidesCache.filter(i).appendTo(e.$slideTrack),e.reinit())},e.prototype.focusHandler=function(){var e=this;e.$slider.off(\"focus.slick blur.slick\").on(\"focus.slick\",\"*\",function(t){var o=i(this);setTimeout(function(){e.options.pauseOnFocus&&o.is(\":focus\")&&(e.focussed=!0,e.autoPlay())},0)}).on(\"blur.slick\",\"*\",function(t){i(this);e.options.pauseOnFocus&&(e.focussed=!1,e.autoPlay())})},e.prototype.getCurrent=e.prototype.slickCurrentSlide=function(){var i=this;return i.currentSlide},e.prototype.getDotCount=function(){var i=this,e=0,t=0,o=0;if(i.options.infinite===!0)if(i.slideCount<=i.options.slidesToShow)++o;else for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else if(i.options.centerMode===!0)o=i.slideCount;else if(i.options.asNavFor)for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else o=1+Math.ceil((i.slideCount-i.options.slidesToShow)/i.options.slidesToScroll);return o-1},e.prototype.getLeft=function(i){var e,t,o,s,n=this,r=0;return n.slideOffset=0,t=n.$slides.first().outerHeight(!0),n.options.infinite===!0?(n.slideCount>n.options.slidesToShow&&(n.slideOffset=n.slideWidth*n.options.slidesToShow*-1,s=-1,n.options.vertical===!0&&n.options.centerMode===!0&&(2===n.options.slidesToShow?s=-1.5:1===n.options.slidesToShow&&(s=-2)),r=t*n.options.slidesToShow*s),n.slideCount%n.options.slidesToScroll!==0&&i+n.options.slidesToScroll>n.slideCount&&n.slideCount>n.options.slidesToShow&&(i>n.slideCount?(n.slideOffset=(n.options.slidesToShow-(i-n.slideCount))*n.slideWidth*-1,r=(n.options.slidesToShow-(i-n.slideCount))*t*-1):(n.slideOffset=n.slideCount%n.options.slidesToScroll*n.slideWidth*-1,r=n.slideCount%n.options.slidesToScroll*t*-1))):i+n.options.slidesToShow>n.slideCount&&(n.slideOffset=(i+n.options.slidesToShow-n.slideCount)*n.slideWidth,r=(i+n.options.slidesToShow-n.slideCount)*t),n.slideCount<=n.options.slidesToShow&&(n.slideOffset=0,r=0),n.options.centerMode===!0&&n.slideCount<=n.options.slidesToShow?n.slideOffset=n.slideWidth*Math.floor(n.options.slidesToShow)/2-n.slideWidth*n.slideCount/2:n.options.centerMode===!0&&n.options.infinite===!0?n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)-n.slideWidth:n.options.centerMode===!0&&(n.slideOffset=0,n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)),e=n.options.vertical===!1?i*n.slideWidth*-1+n.slideOffset:i*t*-1+r,n.options.variableWidth===!0&&(o=n.slideCount<=n.options.slidesToShow||n.options.infinite===!1?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow),e=n.options.rtl===!0?o[0]?(n.$slideTrack.width()-o[0].offsetLeft-o.width())*-1:0:o[0]?o[0].offsetLeft*-1:0,n.options.centerMode===!0&&(o=n.slideCount<=n.options.slidesToShow||n.options.infinite===!1?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow+1),e=n.options.rtl===!0?o[0]?(n.$slideTrack.width()-o[0].offsetLeft-o.width())*-1:0:o[0]?o[0].offsetLeft*-1:0,e+=(n.$list.width()-o.outerWidth())/2)),e},e.prototype.getOption=e.prototype.slickGetOption=function(i){var e=this;return e.options[i]},e.prototype.getNavigableIndexes=function(){var i,e=this,t=0,o=0,s=[];for(e.options.infinite===!1?i=e.slideCount:(t=e.options.slidesToScroll*-1,o=e.options.slidesToScroll*-1,i=2*e.slideCount);t<i;)s.push(t),t=o+e.options.slidesToScroll,o+=e.options.slidesToScroll<=e.options.slidesToShow?e.options.slidesToScroll:e.options.slidesToShow;return s},e.prototype.getSlick=function(){return this},e.prototype.getSlideCount=function(){var e,t,o,s,n=this;return s=n.options.centerMode===!0?Math.floor(n.$list.width()/2):0,o=n.swipeLeft*-1+s,n.options.swipeToSlide===!0?(n.$slideTrack.find(\".slick-slide\").each(function(e,s){var r,l,d;if(r=i(s).outerWidth(),l=s.offsetLeft,n.options.centerMode!==!0&&(l+=r/2),d=l+r,o<d)return t=s,!1}),e=Math.abs(i(t).attr(\"data-slick-index\")-n.currentSlide)||1):n.options.slidesToScroll},e.prototype.goTo=e.prototype.slickGoTo=function(i,e){var t=this;t.changeSlide({data:{message:\"index\",index:parseInt(i)}},e)},e.prototype.init=function(e){var t=this;i(t.$slider).hasClass(\"slick-initialized\")||(i(t.$slider).addClass(\"slick-initialized\"),t.buildRows(),t.buildOut(),t.setProps(),t.startLoad(),t.loadSlider(),t.initializeEvents(),t.updateArrows(),t.updateDots(),t.checkResponsive(!0),t.focusHandler()),e&&t.$slider.trigger(\"init\",[t]),t.options.accessibility===!0&&t.initADA(),t.options.autoplay&&(t.paused=!1,t.autoPlay())},e.prototype.initADA=function(){var e=this,t=Math.ceil(e.slideCount/e.options.slidesToShow),o=e.getNavigableIndexes().filter(function(i){return i>=0&&i<e.slideCount});e.$slides.add(e.$slideTrack.find(\".slick-cloned\")).attr({\"aria-hidden\":\"true\",tabindex:\"-1\"}).find(\"a, input, button, select\").attr({tabindex:\"-1\"}),null!==e.$dots&&(e.$slides.not(e.$slideTrack.find(\".slick-cloned\")).each(function(t){var s=o.indexOf(t);if(i(this).attr({role:\"tabpanel\",id:\"slick-slide\"+e.instanceUid+t,tabindex:-1}),s!==-1){var n=\"slick-slide-control\"+e.instanceUid+s;i(\"#\"+n).length&&i(this).attr({\"aria-describedby\":n})}}),e.$dots.attr(\"role\",\"tablist\").find(\"li\").each(function(s){var n=o[s];i(this).attr({role:\"presentation\"}),i(this).find(\"button\").first().attr({role:\"tab\",id:\"slick-slide-control\"+e.instanceUid+s,\"aria-controls\":\"slick-slide\"+e.instanceUid+n,\"aria-label\":s+1+\" of \"+t,\"aria-selected\":null,tabindex:\"-1\"})}).eq(e.currentSlide).find(\"button\").attr({\"aria-selected\":\"true\",tabindex:\"0\"}).end());for(var s=e.currentSlide,n=s+e.options.slidesToShow;s<n;s++)e.options.focusOnChange?e.$slides.eq(s).attr({tabindex:\"0\"}):e.$slides.eq(s).removeAttr(\"tabindex\");e.activateADA()},e.prototype.initArrowEvents=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.off(\"click.slick\").on(\"click.slick\",{message:\"previous\"},i.changeSlide),i.$nextArrow.off(\"click.slick\").on(\"click.slick\",{message:\"next\"},i.changeSlide),i.options.accessibility===!0&&(i.$prevArrow.on(\"keydown.slick\",i.keyHandler),i.$nextArrow.on(\"keydown.slick\",i.keyHandler)))},e.prototype.initDotEvents=function(){var e=this;e.options.dots===!0&&e.slideCount>e.options.slidesToShow&&(i(\"li\",e.$dots).on(\"click.slick\",{message:\"index\"},e.changeSlide),e.options.accessibility===!0&&e.$dots.on(\"keydown.slick\",e.keyHandler)),e.options.dots===!0&&e.options.pauseOnDotsHover===!0&&e.slideCount>e.options.slidesToShow&&i(\"li\",e.$dots).on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.initSlideEvents=function(){var e=this;e.options.pauseOnHover&&(e.$list.on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)))},e.prototype.initializeEvents=function(){var e=this;e.initArrowEvents(),e.initDotEvents(),e.initSlideEvents(),e.$list.on(\"touchstart.slick mousedown.slick\",{action:\"start\"},e.swipeHandler),e.$list.on(\"touchmove.slick mousemove.slick\",{action:\"move\"},e.swipeHandler),e.$list.on(\"touchend.slick mouseup.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"touchcancel.slick mouseleave.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"click.slick\",e.clickHandler),i(document).on(e.visibilityChange,i.proxy(e.visibility,e)),e.options.accessibility===!0&&e.$list.on(\"keydown.slick\",e.keyHandler),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),i(window).on(\"orientationchange.slick.slick-\"+e.instanceUid,i.proxy(e.orientationChange,e)),i(window).on(\"resize.slick.slick-\"+e.instanceUid,i.proxy(e.resize,e)),i(\"[draggable!=true]\",e.$slideTrack).on(\"dragstart\",e.preventDefault),i(window).on(\"load.slick.slick-\"+e.instanceUid,e.setPosition),i(e.setPosition)},e.prototype.initUI=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.show(),i.$nextArrow.show()),i.options.dots===!0&&i.slideCount>i.options.slidesToShow&&i.$dots.show()},e.prototype.keyHandler=function(i){var e=this;i.target.tagName.match(\"TEXTAREA|INPUT|SELECT\")||(37===i.keyCode&&e.options.accessibility===!0?e.changeSlide({data:{message:e.options.rtl===!0?\"next\":\"previous\"}}):39===i.keyCode&&e.options.accessibility===!0&&e.changeSlide({data:{message:e.options.rtl===!0?\"previous\":\"next\"}}))},e.prototype.lazyLoad=function(){function e(e){i(\"img[data-lazy]\",e).each(function(){var e=i(this),t=i(this).attr(\"data-lazy\"),o=i(this).attr(\"data-srcset\"),s=i(this).attr(\"data-sizes\")||r.$slider.attr(\"data-sizes\"),n=document.createElement(\"img\");n.onload=function(){e.animate({opacity:0},100,function(){o&&(e.attr(\"srcset\",o),s&&e.attr(\"sizes\",s)),e.attr(\"src\",t).animate({opacity:1},200,function(){e.removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\")}),r.$slider.trigger(\"lazyLoaded\",[r,e,t])})},n.onerror=function(){e.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),r.$slider.trigger(\"lazyLoadError\",[r,e,t])},n.src=t})}var t,o,s,n,r=this;if(r.options.centerMode===!0?r.options.infinite===!0?(s=r.currentSlide+(r.options.slidesToShow/2+1),n=s+r.options.slidesToShow+2):(s=Math.max(0,r.currentSlide-(r.options.slidesToShow/2+1)),n=2+(r.options.slidesToShow/2+1)+r.currentSlide):(s=r.options.infinite?r.options.slidesToShow+r.currentSlide:r.currentSlide,n=Math.ceil(s+r.options.slidesToShow),r.options.fade===!0&&(s>0&&s--,n<=r.slideCount&&n++)),t=r.$slider.find(\".slick-slide\").slice(s,n),\"anticipated\"===r.options.lazyLoad)for(var l=s-1,d=n,a=r.$slider.find(\".slick-slide\"),c=0;c<r.options.slidesToScroll;c++)l<0&&(l=r.slideCount-1),t=t.add(a.eq(l)),t=t.add(a.eq(d)),l--,d++;e(t),r.slideCount<=r.options.slidesToShow?(o=r.$slider.find(\".slick-slide\"),e(o)):r.currentSlide>=r.slideCount-r.options.slidesToShow?(o=r.$slider.find(\".slick-cloned\").slice(0,r.options.slidesToShow),e(o)):0===r.currentSlide&&(o=r.$slider.find(\".slick-cloned\").slice(r.options.slidesToShow*-1),e(o))},e.prototype.loadSlider=function(){var i=this;i.setPosition(),i.$slideTrack.css({opacity:1}),i.$slider.removeClass(\"slick-loading\"),i.initUI(),\"progressive\"===i.options.lazyLoad&&i.progressiveLazyLoad()},e.prototype.next=e.prototype.slickNext=function(){var i=this;i.changeSlide({data:{message:\"next\"}})},e.prototype.orientationChange=function(){var i=this;i.checkResponsive(),i.setPosition()},e.prototype.pause=e.prototype.slickPause=function(){var i=this;i.autoPlayClear(),i.paused=!0},e.prototype.play=e.prototype.slickPlay=function(){var i=this;i.autoPlay(),i.options.autoplay=!0,i.paused=!1,i.focussed=!1,i.interrupted=!1},e.prototype.postSlide=function(e){var t=this;if(!t.unslicked&&(t.$slider.trigger(\"afterChange\",[t,e]),t.animating=!1,t.slideCount>t.options.slidesToShow&&t.setPosition(),t.swipeLeft=null,t.options.autoplay&&t.autoPlay(),t.options.accessibility===!0&&(t.initADA(),t.options.focusOnChange))){var o=i(t.$slides.get(t.currentSlide));o.attr(\"tabindex\",0).focus()}},e.prototype.prev=e.prototype.slickPrev=function(){var i=this;i.changeSlide({data:{message:\"previous\"}})},e.prototype.preventDefault=function(i){i.preventDefault()},e.prototype.progressiveLazyLoad=function(e){e=e||1;var t,o,s,n,r,l=this,d=i(\"img[data-lazy]\",l.$slider);d.length?(t=d.first(),o=t.attr(\"data-lazy\"),s=t.attr(\"data-srcset\"),n=t.attr(\"data-sizes\")||l.$slider.attr(\"data-sizes\"),r=document.createElement(\"img\"),r.onload=function(){s&&(t.attr(\"srcset\",s),n&&t.attr(\"sizes\",n)),t.attr(\"src\",o).removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\"),l.options.adaptiveHeight===!0&&l.setPosition(),l.$slider.trigger(\"lazyLoaded\",[l,t,o]),l.progressiveLazyLoad()},r.onerror=function(){e<3?setTimeout(function(){l.progressiveLazyLoad(e+1)},500):(t.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),l.$slider.trigger(\"lazyLoadError\",[l,t,o]),l.progressiveLazyLoad())},r.src=o):l.$slider.trigger(\"allImagesLoaded\",[l])},e.prototype.refresh=function(e){var t,o,s=this;o=s.slideCount-s.options.slidesToShow,!s.options.infinite&&s.currentSlide>o&&(s.currentSlide=o),s.slideCount<=s.options.slidesToShow&&(s.currentSlide=0),t=s.currentSlide,s.destroy(!0),i.extend(s,s.initials,{currentSlide:t}),s.init(),e||s.changeSlide({data:{message:\"index\",index:t}},!1)},e.prototype.registerBreakpoints=function(){var e,t,o,s=this,n=s.options.responsive||null;if(\"array\"===i.type(n)&&n.length){s.respondTo=s.options.respondTo||\"window\";for(e in n)if(o=s.breakpoints.length-1,n.hasOwnProperty(e)){for(t=n[e].breakpoint;o>=0;)s.breakpoints[o]&&s.breakpoints[o]===t&&s.breakpoints.splice(o,1),o--;s.breakpoints.push(t),s.breakpointSettings[t]=n[e].settings}s.breakpoints.sort(function(i,e){return s.options.mobileFirst?i-e:e-i})}},e.prototype.reinit=function(){var e=this;e.$slides=e.$slideTrack.children(e.options.slide).addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.currentSlide>=e.slideCount&&0!==e.currentSlide&&(e.currentSlide=e.currentSlide-e.options.slidesToScroll),e.slideCount<=e.options.slidesToShow&&(e.currentSlide=0),e.registerBreakpoints(),e.setProps(),e.setupInfinite(),e.buildArrows(),e.updateArrows(),e.initArrowEvents(),e.buildDots(),e.updateDots(),e.initDotEvents(),e.cleanUpSlideEvents(),e.initSlideEvents(),e.checkResponsive(!1,!0),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.setPosition(),e.focusHandler(),e.paused=!e.options.autoplay,e.autoPlay(),e.$slider.trigger(\"reInit\",[e])},e.prototype.resize=function(){var e=this;i(window).width()!==e.windowWidth&&(clearTimeout(e.windowDelay),e.windowDelay=window.setTimeout(function(){e.windowWidth=i(window).width(),e.checkResponsive(),e.unslicked||e.setPosition()},50))},e.prototype.removeSlide=e.prototype.slickRemove=function(i,e,t){var o=this;return\"boolean\"==typeof i?(e=i,i=e===!0?0:o.slideCount-1):i=e===!0?--i:i,!(o.slideCount<1||i<0||i>o.slideCount-1)&&(o.unload(),t===!0?o.$slideTrack.children().remove():o.$slideTrack.children(this.options.slide).eq(i).remove(),o.$slides=o.$slideTrack.children(this.options.slide),o.$slideTrack.children(this.options.slide).detach(),o.$slideTrack.append(o.$slides),o.$slidesCache=o.$slides,void o.reinit())},e.prototype.setCSS=function(i){var e,t,o=this,s={};o.options.rtl===!0&&(i=-i),e=\"left\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",t=\"top\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",s[o.positionProp]=i,o.transformsEnabled===!1?o.$slideTrack.css(s):(s={},o.cssTransitions===!1?(s[o.animType]=\"translate(\"+e+\", \"+t+\")\",o.$slideTrack.css(s)):(s[o.animType]=\"translate3d(\"+e+\", \"+t+\", 0px)\",o.$slideTrack.css(s)))},e.prototype.setDimensions=function(){var i=this;i.options.vertical===!1?i.options.centerMode===!0&&i.$list.css({padding:\"0px \"+i.options.centerPadding}):(i.$list.height(i.$slides.first().outerHeight(!0)*i.options.slidesToShow),i.options.centerMode===!0&&i.$list.css({padding:i.options.centerPadding+\" 0px\"})),i.listWidth=i.$list.width(),i.listHeight=i.$list.height(),i.options.vertical===!1&&i.options.variableWidth===!1?(i.slideWidth=Math.ceil(i.listWidth/i.options.slidesToShow),i.$slideTrack.width(Math.ceil(i.slideWidth*i.$slideTrack.children(\".slick-slide\").length))):i.options.variableWidth===!0?i.$slideTrack.width(5e3*i.slideCount):(i.slideWidth=Math.ceil(i.listWidth),i.$slideTrack.height(Math.ceil(i.$slides.first().outerHeight(!0)*i.$slideTrack.children(\".slick-slide\").length)));var e=i.$slides.first().outerWidth(!0)-i.$slides.first().width();i.options.variableWidth===!1&&i.$slideTrack.children(\".slick-slide\").width(i.slideWidth-e)},e.prototype.setFade=function(){var e,t=this;t.$slides.each(function(o,s){e=t.slideWidth*o*-1,t.options.rtl===!0?i(s).css({position:\"relative\",right:e,top:0,zIndex:t.options.zIndex-2,opacity:0}):i(s).css({position:\"relative\",left:e,top:0,zIndex:t.options.zIndex-2,opacity:0})}),t.$slides.eq(t.currentSlide).css({zIndex:t.options.zIndex-1,opacity:1})},e.prototype.setHeight=function(){var i=this;if(1===i.options.slidesToShow&&i.options.adaptiveHeight===!0&&i.options.vertical===!1){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.css(\"height\",e)}},e.prototype.setOption=e.prototype.slickSetOption=function(){var e,t,o,s,n,r=this,l=!1;if(\"object\"===i.type(arguments[0])?(o=arguments[0],l=arguments[1],n=\"multiple\"):\"string\"===i.type(arguments[0])&&(o=arguments[0],s=arguments[1],l=arguments[2],\"responsive\"===arguments[0]&&\"array\"===i.type(arguments[1])?n=\"responsive\":\"undefined\"!=typeof arguments[1]&&(n=\"single\")),\"single\"===n)r.options[o]=s;else if(\"multiple\"===n)i.each(o,function(i,e){r.options[i]=e});else if(\"responsive\"===n)for(t in s)if(\"array\"!==i.type(r.options.responsive))r.options.responsive=[s[t]];else{for(e=r.options.responsive.length-1;e>=0;)r.options.responsive[e].breakpoint===s[t].breakpoint&&r.options.responsive.splice(e,1),e--;r.options.responsive.push(s[t])}l&&(r.unload(),r.reinit())},e.prototype.setPosition=function(){var i=this;i.setDimensions(),i.setHeight(),i.options.fade===!1?i.setCSS(i.getLeft(i.currentSlide)):i.setFade(),i.$slider.trigger(\"setPosition\",[i])},e.prototype.setProps=function(){var i=this,e=document.body.style;i.positionProp=i.options.vertical===!0?\"top\":\"left\",\n\"top\"===i.positionProp?i.$slider.addClass(\"slick-vertical\"):i.$slider.removeClass(\"slick-vertical\"),void 0===e.WebkitTransition&&void 0===e.MozTransition&&void 0===e.msTransition||i.options.useCSS===!0&&(i.cssTransitions=!0),i.options.fade&&(\"number\"==typeof i.options.zIndex?i.options.zIndex<3&&(i.options.zIndex=3):i.options.zIndex=i.defaults.zIndex),void 0!==e.OTransform&&(i.animType=\"OTransform\",i.transformType=\"-o-transform\",i.transitionType=\"OTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.MozTransform&&(i.animType=\"MozTransform\",i.transformType=\"-moz-transform\",i.transitionType=\"MozTransition\",void 0===e.perspectiveProperty&&void 0===e.MozPerspective&&(i.animType=!1)),void 0!==e.webkitTransform&&(i.animType=\"webkitTransform\",i.transformType=\"-webkit-transform\",i.transitionType=\"webkitTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.msTransform&&(i.animType=\"msTransform\",i.transformType=\"-ms-transform\",i.transitionType=\"msTransition\",void 0===e.msTransform&&(i.animType=!1)),void 0!==e.transform&&i.animType!==!1&&(i.animType=\"transform\",i.transformType=\"transform\",i.transitionType=\"transition\"),i.transformsEnabled=i.options.useTransform&&null!==i.animType&&i.animType!==!1},e.prototype.setSlideClasses=function(i){var e,t,o,s,n=this;if(t=n.$slider.find(\".slick-slide\").removeClass(\"slick-active slick-center slick-current\").attr(\"aria-hidden\",\"true\"),n.$slides.eq(i).addClass(\"slick-current\"),n.options.centerMode===!0){var r=n.options.slidesToShow%2===0?1:0;e=Math.floor(n.options.slidesToShow/2),n.options.infinite===!0&&(i>=e&&i<=n.slideCount-1-e?n.$slides.slice(i-e+r,i+e+1).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(o=n.options.slidesToShow+i,t.slice(o-e+1+r,o+e+2).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\")),0===i?t.eq(t.length-1-n.options.slidesToShow).addClass(\"slick-center\"):i===n.slideCount-1&&t.eq(n.options.slidesToShow).addClass(\"slick-center\")),n.$slides.eq(i).addClass(\"slick-center\")}else i>=0&&i<=n.slideCount-n.options.slidesToShow?n.$slides.slice(i,i+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.length<=n.options.slidesToShow?t.addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(s=n.slideCount%n.options.slidesToShow,o=n.options.infinite===!0?n.options.slidesToShow+i:i,n.options.slidesToShow==n.options.slidesToScroll&&n.slideCount-i<n.options.slidesToShow?t.slice(o-(n.options.slidesToShow-s),o+s).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.slice(o,o+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"));\"ondemand\"!==n.options.lazyLoad&&\"anticipated\"!==n.options.lazyLoad||n.lazyLoad()},e.prototype.setupInfinite=function(){var e,t,o,s=this;if(s.options.fade===!0&&(s.options.centerMode=!1),s.options.infinite===!0&&s.options.fade===!1&&(t=null,s.slideCount>s.options.slidesToShow)){for(o=s.options.centerMode===!0?s.options.slidesToShow+1:s.options.slidesToShow,e=s.slideCount;e>s.slideCount-o;e-=1)t=e-1,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t-s.slideCount).prependTo(s.$slideTrack).addClass(\"slick-cloned\");for(e=0;e<o+s.slideCount;e+=1)t=e,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t+s.slideCount).appendTo(s.$slideTrack).addClass(\"slick-cloned\");s.$slideTrack.find(\".slick-cloned\").find(\"[id]\").each(function(){i(this).attr(\"id\",\"\")})}},e.prototype.interrupt=function(i){var e=this;i||e.autoPlay(),e.interrupted=i},e.prototype.selectHandler=function(e){var t=this,o=i(e.target).is(\".slick-slide\")?i(e.target):i(e.target).parents(\".slick-slide\"),s=parseInt(o.attr(\"data-slick-index\"));return s||(s=0),t.slideCount<=t.options.slidesToShow?void t.slideHandler(s,!1,!0):void t.slideHandler(s)},e.prototype.slideHandler=function(i,e,t){var o,s,n,r,l,d=null,a=this;if(e=e||!1,!(a.animating===!0&&a.options.waitForAnimate===!0||a.options.fade===!0&&a.currentSlide===i))return e===!1&&a.asNavFor(i),o=i,d=a.getLeft(o),r=a.getLeft(a.currentSlide),a.currentLeft=null===a.swipeLeft?r:a.swipeLeft,a.options.infinite===!1&&a.options.centerMode===!1&&(i<0||i>a.getDotCount()*a.options.slidesToScroll)?void(a.options.fade===!1&&(o=a.currentSlide,t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o))):a.options.infinite===!1&&a.options.centerMode===!0&&(i<0||i>a.slideCount-a.options.slidesToScroll)?void(a.options.fade===!1&&(o=a.currentSlide,t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o))):(a.options.autoplay&&clearInterval(a.autoPlayTimer),s=o<0?a.slideCount%a.options.slidesToScroll!==0?a.slideCount-a.slideCount%a.options.slidesToScroll:a.slideCount+o:o>=a.slideCount?a.slideCount%a.options.slidesToScroll!==0?0:o-a.slideCount:o,a.animating=!0,a.$slider.trigger(\"beforeChange\",[a,a.currentSlide,s]),n=a.currentSlide,a.currentSlide=s,a.setSlideClasses(a.currentSlide),a.options.asNavFor&&(l=a.getNavTarget(),l=l.slick(\"getSlick\"),l.slideCount<=l.options.slidesToShow&&l.setSlideClasses(a.currentSlide)),a.updateDots(),a.updateArrows(),a.options.fade===!0?(t!==!0?(a.fadeSlideOut(n),a.fadeSlide(s,function(){a.postSlide(s)})):a.postSlide(s),void a.animateHeight()):void(t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(d,function(){a.postSlide(s)}):a.postSlide(s)))},e.prototype.startLoad=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.hide(),i.$nextArrow.hide()),i.options.dots===!0&&i.slideCount>i.options.slidesToShow&&i.$dots.hide(),i.$slider.addClass(\"slick-loading\")},e.prototype.swipeDirection=function(){var i,e,t,o,s=this;return i=s.touchObject.startX-s.touchObject.curX,e=s.touchObject.startY-s.touchObject.curY,t=Math.atan2(e,i),o=Math.round(180*t/Math.PI),o<0&&(o=360-Math.abs(o)),o<=45&&o>=0?s.options.rtl===!1?\"left\":\"right\":o<=360&&o>=315?s.options.rtl===!1?\"left\":\"right\":o>=135&&o<=225?s.options.rtl===!1?\"right\":\"left\":s.options.verticalSwiping===!0?o>=35&&o<=135?\"down\":\"up\":\"vertical\"},e.prototype.swipeEnd=function(i){var e,t,o=this;if(o.dragging=!1,o.swiping=!1,o.scrolling)return o.scrolling=!1,!1;if(o.interrupted=!1,o.shouldClick=!(o.touchObject.swipeLength>10),void 0===o.touchObject.curX)return!1;if(o.touchObject.edgeHit===!0&&o.$slider.trigger(\"edge\",[o,o.swipeDirection()]),o.touchObject.swipeLength>=o.touchObject.minSwipe){switch(t=o.swipeDirection()){case\"left\":case\"down\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide+o.getSlideCount()):o.currentSlide+o.getSlideCount(),o.currentDirection=0;break;case\"right\":case\"up\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide-o.getSlideCount()):o.currentSlide-o.getSlideCount(),o.currentDirection=1}\"vertical\"!=t&&(o.slideHandler(e),o.touchObject={},o.$slider.trigger(\"swipe\",[o,t]))}else o.touchObject.startX!==o.touchObject.curX&&(o.slideHandler(o.currentSlide),o.touchObject={})},e.prototype.swipeHandler=function(i){var e=this;if(!(e.options.swipe===!1||\"ontouchend\"in document&&e.options.swipe===!1||e.options.draggable===!1&&i.type.indexOf(\"mouse\")!==-1))switch(e.touchObject.fingerCount=i.originalEvent&&void 0!==i.originalEvent.touches?i.originalEvent.touches.length:1,e.touchObject.minSwipe=e.listWidth/e.options.touchThreshold,e.options.verticalSwiping===!0&&(e.touchObject.minSwipe=e.listHeight/e.options.touchThreshold),i.data.action){case\"start\":e.swipeStart(i);break;case\"move\":e.swipeMove(i);break;case\"end\":e.swipeEnd(i)}},e.prototype.swipeMove=function(i){var e,t,o,s,n,r,l=this;return n=void 0!==i.originalEvent?i.originalEvent.touches:null,!(!l.dragging||l.scrolling||n&&1!==n.length)&&(e=l.getLeft(l.currentSlide),l.touchObject.curX=void 0!==n?n[0].pageX:i.clientX,l.touchObject.curY=void 0!==n?n[0].pageY:i.clientY,l.touchObject.swipeLength=Math.round(Math.sqrt(Math.pow(l.touchObject.curX-l.touchObject.startX,2))),r=Math.round(Math.sqrt(Math.pow(l.touchObject.curY-l.touchObject.startY,2))),!l.options.verticalSwiping&&!l.swiping&&r>4?(l.scrolling=!0,!1):(l.options.verticalSwiping===!0&&(l.touchObject.swipeLength=r),t=l.swipeDirection(),void 0!==i.originalEvent&&l.touchObject.swipeLength>4&&(l.swiping=!0,i.preventDefault()),s=(l.options.rtl===!1?1:-1)*(l.touchObject.curX>l.touchObject.startX?1:-1),l.options.verticalSwiping===!0&&(s=l.touchObject.curY>l.touchObject.startY?1:-1),o=l.touchObject.swipeLength,l.touchObject.edgeHit=!1,l.options.infinite===!1&&(0===l.currentSlide&&\"right\"===t||l.currentSlide>=l.getDotCount()&&\"left\"===t)&&(o=l.touchObject.swipeLength*l.options.edgeFriction,l.touchObject.edgeHit=!0),l.options.vertical===!1?l.swipeLeft=e+o*s:l.swipeLeft=e+o*(l.$list.height()/l.listWidth)*s,l.options.verticalSwiping===!0&&(l.swipeLeft=e+o*s),l.options.fade!==!0&&l.options.touchMove!==!1&&(l.animating===!0?(l.swipeLeft=null,!1):void l.setCSS(l.swipeLeft))))},e.prototype.swipeStart=function(i){var e,t=this;return t.interrupted=!0,1!==t.touchObject.fingerCount||t.slideCount<=t.options.slidesToShow?(t.touchObject={},!1):(void 0!==i.originalEvent&&void 0!==i.originalEvent.touches&&(e=i.originalEvent.touches[0]),t.touchObject.startX=t.touchObject.curX=void 0!==e?e.pageX:i.clientX,t.touchObject.startY=t.touchObject.curY=void 0!==e?e.pageY:i.clientY,void(t.dragging=!0))},e.prototype.unfilterSlides=e.prototype.slickUnfilter=function(){var i=this;null!==i.$slidesCache&&(i.unload(),i.$slideTrack.children(this.options.slide).detach(),i.$slidesCache.appendTo(i.$slideTrack),i.reinit())},e.prototype.unload=function(){var e=this;i(\".slick-cloned\",e.$slider).remove(),e.$dots&&e.$dots.remove(),e.$prevArrow&&e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.remove(),e.$nextArrow&&e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.remove(),e.$slides.removeClass(\"slick-slide slick-active slick-visible slick-current\").attr(\"aria-hidden\",\"true\").css(\"width\",\"\")},e.prototype.unslick=function(i){var e=this;e.$slider.trigger(\"unslick\",[e,i]),e.destroy()},e.prototype.updateArrows=function(){var i,e=this;i=Math.floor(e.options.slidesToShow/2),e.options.arrows===!0&&e.slideCount>e.options.slidesToShow&&!e.options.infinite&&(e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),e.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),0===e.currentSlide?(e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):e.currentSlide>=e.slideCount-e.options.slidesToShow&&e.options.centerMode===!1?(e.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):e.currentSlide>=e.slideCount-1&&e.options.centerMode===!0&&(e.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")))},e.prototype.updateDots=function(){var i=this;null!==i.$dots&&(i.$dots.find(\"li\").removeClass(\"slick-active\").end(),i.$dots.find(\"li\").eq(Math.floor(i.currentSlide/i.options.slidesToScroll)).addClass(\"slick-active\"))},e.prototype.visibility=function(){var i=this;i.options.autoplay&&(document[i.hidden]?i.interrupted=!0:i.interrupted=!1)},i.fn.slick=function(){var i,t,o=this,s=arguments[0],n=Array.prototype.slice.call(arguments,1),r=o.length;for(i=0;i<r;i++)if(\"object\"==typeof s||\"undefined\"==typeof s?o[i].slick=new e(o[i],s):t=o[i].slick[s].apply(o[i].slick,n),\"undefined\"!=typeof t)return t;return o}});\n","Magento_PageBuilder/js/resource/html2canvas/html2canvas.min.js":"/*!\n * html2canvas 1.0.0-rc.5 <https://html2canvas.hertzen.com>\n * Copyright (c) 2019 Niklas von Hertzen <https://hertzen.com>\n * Released under MIT License\n */\n!function(A,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=e():\"function\"==typeof define&&define.amd?define(e):(A=A||self).html2canvas=e()}(this,function(){\"use strict\";\n    /*! *****************************************************************************\n        Copyright (c) Microsoft Corporation. All rights reserved.\n        Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use\n        this file except in compliance with the License. You may obtain a copy of the\n        License at http://www.apache.org/licenses/LICENSE-2.0\n\n        THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n        KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\n        WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\n        MERCHANTABLITY OR NON-INFRINGEMENT.\n\n        See the Apache Version 2.0 License for specific language governing permissions\n        and limitations under the License.\n        ***************************************************************************** */var r=function(A,e){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(A,e){A.__proto__=e}||function(A,e){for(var t in e)e.hasOwnProperty(t)&&(A[t]=e[t])})(A,e)};function A(A,e){function t(){this.constructor=A}r(A,e),A.prototype=null===e?Object.create(e):(t.prototype=e.prototype,new t)}var K=function(){return(K=Object.assign||function(A){for(var e,t=1,r=arguments.length;t<r;t++)for(var n in e=arguments[t])Object.prototype.hasOwnProperty.call(e,n)&&(A[n]=e[n]);return A}).apply(this,arguments)};function a(B,s,o,i){return new(o||(o=Promise))(function(A,e){function t(A){try{n(i.next(A))}catch(A){e(A)}}function r(A){try{n(i.throw(A))}catch(A){e(A)}}function n(e){e.done?A(e.value):new o(function(A){A(e.value)}).then(t,r)}n((i=i.apply(B,s||[])).next())})}function S(t,r){var n,B,s,A,o={label:0,sent:function(){if(1&s[0])throw s[1];return s[1]},trys:[],ops:[]};return A={next:e(0),throw:e(1),return:e(2)},\"function\"==typeof Symbol&&(A[Symbol.iterator]=function(){return this}),A;function e(e){return function(A){return function(e){if(n)throw new TypeError(\"Generator is already executing.\");for(;o;)try{if(n=1,B&&(s=2&e[0]?B.return:e[0]?B.throw||((s=B.return)&&s.call(B),0):B.next)&&!(s=s.call(B,e[1])).done)return s;switch(B=0,s&&(e=[2&e[0],s.value]),e[0]){case 0:case 1:s=e;break;case 4:return o.label++,{value:e[1],done:!1};case 5:o.label++,B=e[1],e=[0];continue;case 7:e=o.ops.pop(),o.trys.pop();continue;default:if(!(s=0<(s=o.trys).length&&s[s.length-1])&&(6===e[0]||2===e[0])){o=0;continue}if(3===e[0]&&(!s||e[1]>s[0]&&e[1]<s[3])){o.label=e[1];break}if(6===e[0]&&o.label<s[1]){o.label=s[1],s=e;break}if(s&&o.label<s[2]){o.label=s[2],o.ops.push(e);break}s[2]&&o.ops.pop(),o.trys.pop();continue}e=r.call(t,o)}catch(A){e=[6,A],B=0}finally{n=s=0}if(5&e[0])throw e[1];return{value:e[0]?e[1]:void 0,done:!0}}([e,A])}}}var I=(n.prototype.add=function(A,e,t,r){return new n(this.left+A,this.top+e,this.width+t,this.height+r)},n.fromClientRect=function(A){return new n(A.left,A.top,A.width,A.height)},n);function n(A,e,t,r){this.left=A,this.top=e,this.width=t,this.height=r}for(var T=function(A){return I.fromClientRect(A.getBoundingClientRect())},c=function(A){for(var e=[],t=0,r=A.length;t<r;){var n=A.charCodeAt(t++);if(55296<=n&&n<=56319&&t<r){var B=A.charCodeAt(t++);56320==(64512&B)?e.push(((1023&n)<<10)+(1023&B)+65536):(e.push(n),t--)}else e.push(n)}return e},l=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];if(String.fromCodePoint)return String.fromCodePoint.apply(String,A);var t=A.length;if(!t)return\"\";for(var r=[],n=-1,B=\"\";++n<t;){var s=A[n];s<=65535?r.push(s):(s-=65536,r.push(55296+(s>>10),s%1024+56320)),(n+1===t||16384<r.length)&&(B+=String.fromCharCode.apply(String,r),r.length=0)}return B},e=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\",Q=\"undefined\"==typeof Uint8Array?[]:new Uint8Array(256),t=0;t<e.length;t++)Q[e.charCodeAt(t)]=t;function B(A,e,t){return A.slice?A.slice(e,t):new Uint16Array(Array.prototype.slice.call(A,e,t))}var s=(o.prototype.get=function(A){var e;if(0<=A){if(A<55296||56319<A&&A<=65535)return e=((e=this.index[A>>5])<<2)+(31&A),this.data[e];if(A<=65535)return e=((e=this.index[2048+(A-55296>>5)])<<2)+(31&A),this.data[e];if(A<this.highStart)return e=2080+(A>>11),e=this.index[e],e+=A>>5&63,e=((e=this.index[e])<<2)+(31&A),this.data[e];if(A<=1114111)return this.data[this.highValueIndex]}return this.errorValue},o);function o(A,e,t,r,n,B){this.initialValue=A,this.errorValue=e,this.highStart=t,this.highValueIndex=r,this.index=n,this.data=B}function C(A,e,t,r){var n=r[t];if(Array.isArray(A)?-1!==A.indexOf(n):A===n)for(var B=t;B<=r.length;){if((i=r[++B])===e)return!0;if(i!==H)break}if(n===H)for(B=t;0<B;){var s=r[--B];if(Array.isArray(A)?-1!==A.indexOf(s):A===s)for(var o=t;o<=r.length;){var i;if((i=r[++o])===e)return!0;if(i!==H)break}if(s!==H)break}return!1}function g(A,e){for(var t=A;0<=t;){var r=e[t];if(r!==H)return r;t--}return 0}function w(A,e,t,r,n){if(0===t[r])return Y;var B=r-1;if(Array.isArray(n)&&!0===n[B])return Y;var s=B-1,o=1+B,i=e[B],a=0<=s?e[s]:0,c=e[o];if(2===i&&3===c)return Y;if(-1!==j.indexOf(i))return\"!\";if(-1!==j.indexOf(c))return Y;if(-1!==$.indexOf(c))return Y;if(8===g(B,e))return\"\u00f7\";if(11===q.get(A[B])&&(c===X||c===P||c===x))return Y;if(7===i||7===c)return Y;if(9===i)return Y;if(-1===[H,d,f].indexOf(i)&&9===c)return Y;if(-1!==[p,N,m,O,y].indexOf(c))return Y;if(g(B,e)===v)return Y;if(C(23,v,B,e))return Y;if(C([p,N],L,B,e))return Y;if(C(12,12,B,e))return Y;if(i===H)return\"\u00f7\";if(23===i||23===c)return Y;if(16===c||16===i)return\"\u00f7\";if(-1!==[d,f,L].indexOf(c)||14===i)return Y;if(36===a&&-1!==rA.indexOf(i))return Y;if(i===y&&36===c)return Y;if(c===R&&-1!==Z.concat(R,m,D,X,P,x).indexOf(i))return Y;if(-1!==Z.indexOf(c)&&i===D||-1!==Z.indexOf(i)&&c===D)return Y;if(i===M&&-1!==[X,P,x].indexOf(c)||-1!==[X,P,x].indexOf(i)&&c===b)return Y;if(-1!==Z.indexOf(i)&&-1!==AA.indexOf(c)||-1!==AA.indexOf(i)&&-1!==Z.indexOf(c))return Y;if(-1!==[M,b].indexOf(i)&&(c===D||-1!==[v,f].indexOf(c)&&e[1+o]===D)||-1!==[v,f].indexOf(i)&&c===D||i===D&&-1!==[D,y,O].indexOf(c))return Y;if(-1!==[D,y,O,p,N].indexOf(c))for(var Q=B;0<=Q;){if((w=e[Q])===D)return Y;if(-1===[y,O].indexOf(w))break;Q--}if(-1!==[M,b].indexOf(c))for(Q=-1!==[p,N].indexOf(i)?s:B;0<=Q;){var w;if((w=e[Q])===D)return Y;if(-1===[y,O].indexOf(w))break;Q--}if(J===i&&-1!==[J,G,V,z].indexOf(c)||-1!==[G,V].indexOf(i)&&-1!==[G,k].indexOf(c)||-1!==[k,z].indexOf(i)&&c===k)return Y;if(-1!==tA.indexOf(i)&&-1!==[R,b].indexOf(c)||-1!==tA.indexOf(c)&&i===M)return Y;if(-1!==Z.indexOf(i)&&-1!==Z.indexOf(c))return Y;if(i===O&&-1!==Z.indexOf(c))return Y;if(-1!==Z.concat(D).indexOf(i)&&c===v||-1!==Z.concat(D).indexOf(c)&&i===N)return Y;if(41===i&&41===c){for(var u=t[B],U=1;0<u&&41===e[--u];)U++;if(U%2!=0)return Y}return i===P&&c===x?Y:\"\u00f7\"}function u(t,A){A||(A={lineBreak:\"normal\",wordBreak:\"normal\"});var e=function(A,n){void 0===n&&(n=\"strict\");var B=[],s=[],o=[];return A.forEach(function(A,e){var t=q.get(A);if(50<t?(o.push(!0),t-=50):o.push(!1),-1!==[\"normal\",\"auto\",\"loose\"].indexOf(n)&&-1!==[8208,8211,12316,12448].indexOf(A))return s.push(e),B.push(16);if(4!==t&&11!==t)return s.push(e),31===t?B.push(\"strict\"===n?L:X):t===W?B.push(_):29===t?B.push(_):43===t?131072<=A&&A<=196605||196608<=A&&A<=262141?B.push(X):B.push(_):void B.push(t);if(0===e)return s.push(e),B.push(_);var r=B[e-1];return-1===eA.indexOf(r)?(s.push(s[e-1]),B.push(r)):(s.push(e),B.push(_))}),[s,B,o]}(t,A.lineBreak),r=e[0],n=e[1],B=e[2];return\"break-all\"!==A.wordBreak&&\"break-word\"!==A.wordBreak||(n=n.map(function(A){return-1!==[D,_,W].indexOf(A)?X:A})),[r,n,\"keep-all\"===A.wordBreak?B.map(function(A,e){return A&&19968<=t[e]&&t[e]<=40959}):void 0]}var i,U,E,F,h,H=10,d=13,f=15,p=17,N=18,m=19,R=20,L=21,v=22,O=24,D=25,b=26,M=27,y=28,_=30,P=32,x=33,V=34,z=35,X=37,J=38,G=39,k=40,W=42,Y=\"\u00d7\",q=(i=function(A){var e,t,r,n,B,s=.75*A.length,o=A.length,i=0;\"=\"===A[A.length-1]&&(s--,\"=\"===A[A.length-2]&&s--);var a=\"undefined\"!=typeof ArrayBuffer&&\"undefined\"!=typeof Uint8Array&&void 0!==Uint8Array.prototype.slice?new ArrayBuffer(s):new Array(s),c=Array.isArray(a)?a:new Uint8Array(a);for(e=0;e<o;e+=4)t=Q[A.charCodeAt(e)],r=Q[A.charCodeAt(e+1)],n=Q[A.charCodeAt(e+2)],B=Q[A.charCodeAt(e+3)],c[i++]=t<<2|r>>4,c[i++]=(15&r)<<4|n>>2,c[i++]=(3&n)<<6|63&B;return a}(\"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\"),U=Array.isArray(i)?function(A){for(var e=A.length,t=[],r=0;r<e;r+=4)t.push(A[r+3]<<24|A[r+2]<<16|A[r+1]<<8|A[r]);return t}(i):new Uint32Array(i),E=Array.isArray(i)?function(A){for(var e=A.length,t=[],r=0;r<e;r+=2)t.push(A[r+1]<<8|A[r]);return t}(i):new Uint16Array(i),F=B(E,12,U[4]/2),h=2===U[5]?B(E,(24+U[4])/2):function(A,e,t){return A.slice?A.slice(e,t):new Uint32Array(Array.prototype.slice.call(A,e,t))}(U,Math.ceil((24+U[4])/4)),new s(U[0],U[1],U[2],U[3],F,h)),Z=[_,36],j=[1,2,3,5],$=[H,8],AA=[M,b],eA=j.concat($),tA=[J,G,k,V,z],rA=[f,d],nA=(BA.prototype.slice=function(){return l.apply(void 0,this.codePoints.slice(this.start,this.end))},BA);function BA(A,e,t,r){this.codePoints=A,this.required=\"!\"===e,this.start=t,this.end=r}var sA,oA;(oA=sA||(sA={}))[oA.STRING_TOKEN=0]=\"STRING_TOKEN\",oA[oA.BAD_STRING_TOKEN=1]=\"BAD_STRING_TOKEN\",oA[oA.LEFT_PARENTHESIS_TOKEN=2]=\"LEFT_PARENTHESIS_TOKEN\",oA[oA.RIGHT_PARENTHESIS_TOKEN=3]=\"RIGHT_PARENTHESIS_TOKEN\",oA[oA.COMMA_TOKEN=4]=\"COMMA_TOKEN\",oA[oA.HASH_TOKEN=5]=\"HASH_TOKEN\",oA[oA.DELIM_TOKEN=6]=\"DELIM_TOKEN\",oA[oA.AT_KEYWORD_TOKEN=7]=\"AT_KEYWORD_TOKEN\",oA[oA.PREFIX_MATCH_TOKEN=8]=\"PREFIX_MATCH_TOKEN\",oA[oA.DASH_MATCH_TOKEN=9]=\"DASH_MATCH_TOKEN\",oA[oA.INCLUDE_MATCH_TOKEN=10]=\"INCLUDE_MATCH_TOKEN\",oA[oA.LEFT_CURLY_BRACKET_TOKEN=11]=\"LEFT_CURLY_BRACKET_TOKEN\",oA[oA.RIGHT_CURLY_BRACKET_TOKEN=12]=\"RIGHT_CURLY_BRACKET_TOKEN\",oA[oA.SUFFIX_MATCH_TOKEN=13]=\"SUFFIX_MATCH_TOKEN\",oA[oA.SUBSTRING_MATCH_TOKEN=14]=\"SUBSTRING_MATCH_TOKEN\",oA[oA.DIMENSION_TOKEN=15]=\"DIMENSION_TOKEN\",oA[oA.PERCENTAGE_TOKEN=16]=\"PERCENTAGE_TOKEN\",oA[oA.NUMBER_TOKEN=17]=\"NUMBER_TOKEN\",oA[oA.FUNCTION=18]=\"FUNCTION\",oA[oA.FUNCTION_TOKEN=19]=\"FUNCTION_TOKEN\",oA[oA.IDENT_TOKEN=20]=\"IDENT_TOKEN\",oA[oA.COLUMN_TOKEN=21]=\"COLUMN_TOKEN\",oA[oA.URL_TOKEN=22]=\"URL_TOKEN\",oA[oA.BAD_URL_TOKEN=23]=\"BAD_URL_TOKEN\",oA[oA.CDC_TOKEN=24]=\"CDC_TOKEN\",oA[oA.CDO_TOKEN=25]=\"CDO_TOKEN\",oA[oA.COLON_TOKEN=26]=\"COLON_TOKEN\",oA[oA.SEMICOLON_TOKEN=27]=\"SEMICOLON_TOKEN\",oA[oA.LEFT_SQUARE_BRACKET_TOKEN=28]=\"LEFT_SQUARE_BRACKET_TOKEN\",oA[oA.RIGHT_SQUARE_BRACKET_TOKEN=29]=\"RIGHT_SQUARE_BRACKET_TOKEN\",oA[oA.UNICODE_RANGE_TOKEN=30]=\"UNICODE_RANGE_TOKEN\",oA[oA.WHITESPACE_TOKEN=31]=\"WHITESPACE_TOKEN\",oA[oA.EOF_TOKEN=32]=\"EOF_TOKEN\";function iA(A){return 48<=A&&A<=57}function aA(A){return iA(A)||65<=A&&A<=70||97<=A&&A<=102}function cA(A){return 10===A||9===A||32===A}function QA(A){return function(A){return function(A){return 97<=A&&A<=122}(A)||function(A){return 65<=A&&A<=90}(A)}(A)||function(A){return 128<=A}(A)||95===A}function wA(A){return QA(A)||iA(A)||45===A}function uA(A,e){return 92===A&&10!==e}function UA(A,e,t){return 45===A?QA(e)||uA(e,t):!!QA(A)||!(92!==A||!uA(A,e))}function lA(A,e,t){return 43===A||45===A?!!iA(e)||46===e&&iA(t):iA(46===A?e:A)}var CA={type:sA.LEFT_PARENTHESIS_TOKEN},gA={type:sA.RIGHT_PARENTHESIS_TOKEN},EA={type:sA.COMMA_TOKEN},FA={type:sA.SUFFIX_MATCH_TOKEN},hA={type:sA.PREFIX_MATCH_TOKEN},HA={type:sA.COLUMN_TOKEN},dA={type:sA.DASH_MATCH_TOKEN},fA={type:sA.INCLUDE_MATCH_TOKEN},pA={type:sA.LEFT_CURLY_BRACKET_TOKEN},NA={type:sA.RIGHT_CURLY_BRACKET_TOKEN},KA={type:sA.SUBSTRING_MATCH_TOKEN},IA={type:sA.BAD_URL_TOKEN},TA={type:sA.BAD_STRING_TOKEN},mA={type:sA.CDO_TOKEN},RA={type:sA.CDC_TOKEN},LA={type:sA.COLON_TOKEN},vA={type:sA.SEMICOLON_TOKEN},OA={type:sA.LEFT_SQUARE_BRACKET_TOKEN},DA={type:sA.RIGHT_SQUARE_BRACKET_TOKEN},bA={type:sA.WHITESPACE_TOKEN},SA={type:sA.EOF_TOKEN},MA=(yA.prototype.write=function(A){this._value=this._value.concat(c(A))},yA.prototype.read=function(){for(var A=[],e=this.consumeToken();e!==SA;)A.push(e),e=this.consumeToken();return A},yA.prototype.consumeToken=function(){var A=this.consumeCodePoint();switch(A){case 34:return this.consumeStringToken(34);case 35:var e=this.peekCodePoint(0),t=this.peekCodePoint(1),r=this.peekCodePoint(2);if(wA(e)||uA(t,r)){var n=UA(e,t,r)?2:1,B=this.consumeName();return{type:sA.HASH_TOKEN,value:B,flags:n}}break;case 36:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),FA;break;case 39:return this.consumeStringToken(39);case 40:return CA;case 41:return gA;case 42:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),KA;break;case 43:if(lA(A,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(A),this.consumeNumericToken();break;case 44:return EA;case 45:var s=A,o=this.peekCodePoint(0),i=this.peekCodePoint(1);if(lA(s,o,i))return this.reconsumeCodePoint(A),this.consumeNumericToken();if(UA(s,o,i))return this.reconsumeCodePoint(A),this.consumeIdentLikeToken();if(45===o&&62===i)return this.consumeCodePoint(),this.consumeCodePoint(),RA;break;case 46:if(lA(A,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(A),this.consumeNumericToken();break;case 47:if(42===this.peekCodePoint(0))for(this.consumeCodePoint();;){var a=this.consumeCodePoint();if(42===a&&47===(a=this.consumeCodePoint()))return this.consumeToken();if(-1===a)return this.consumeToken()}break;case 58:return LA;case 59:return vA;case 60:if(33===this.peekCodePoint(0)&&45===this.peekCodePoint(1)&&45===this.peekCodePoint(2))return this.consumeCodePoint(),this.consumeCodePoint(),mA;break;case 64:var c=this.peekCodePoint(0),Q=this.peekCodePoint(1),w=this.peekCodePoint(2);if(UA(c,Q,w))return B=this.consumeName(),{type:sA.AT_KEYWORD_TOKEN,value:B};break;case 91:return OA;case 92:if(uA(A,this.peekCodePoint(0)))return this.reconsumeCodePoint(A),this.consumeIdentLikeToken();break;case 93:return DA;case 61:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),hA;break;case 123:return pA;case 125:return NA;case 117:case 85:var u=this.peekCodePoint(0),U=this.peekCodePoint(1);return 43!==u||!aA(U)&&63!==U||(this.consumeCodePoint(),this.consumeUnicodeRangeToken()),this.reconsumeCodePoint(A),this.consumeIdentLikeToken();case 124:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),dA;if(124===this.peekCodePoint(0))return this.consumeCodePoint(),HA;break;case 126:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),fA;break;case-1:return SA}return cA(A)?(this.consumeWhiteSpace(),bA):iA(A)?(this.reconsumeCodePoint(A),this.consumeNumericToken()):QA(A)?(this.reconsumeCodePoint(A),this.consumeIdentLikeToken()):{type:sA.DELIM_TOKEN,value:l(A)}},yA.prototype.consumeCodePoint=function(){var A=this._value.shift();return void 0===A?-1:A},yA.prototype.reconsumeCodePoint=function(A){this._value.unshift(A)},yA.prototype.peekCodePoint=function(A){return A>=this._value.length?-1:this._value[A]},yA.prototype.consumeUnicodeRangeToken=function(){for(var A=[],e=this.consumeCodePoint();aA(e)&&A.length<6;)A.push(e),e=this.consumeCodePoint();for(var t=!1;63===e&&A.length<6;)A.push(e),e=this.consumeCodePoint(),t=!0;if(t){var r=parseInt(l.apply(void 0,A.map(function(A){return 63===A?48:A})),16),n=parseInt(l.apply(void 0,A.map(function(A){return 63===A?70:A})),16);return{type:sA.UNICODE_RANGE_TOKEN,start:r,end:n}}var B=parseInt(l.apply(void 0,A),16);if(45===this.peekCodePoint(0)&&aA(this.peekCodePoint(1))){this.consumeCodePoint(),e=this.consumeCodePoint();for(var s=[];aA(e)&&s.length<6;)s.push(e),e=this.consumeCodePoint();return n=parseInt(l.apply(void 0,s),16),{type:sA.UNICODE_RANGE_TOKEN,start:B,end:n}}return{type:sA.UNICODE_RANGE_TOKEN,start:B,end:B}},yA.prototype.consumeIdentLikeToken=function(){var A=this.consumeName();return\"url\"===A.toLowerCase()&&40===this.peekCodePoint(0)?(this.consumeCodePoint(),this.consumeUrlToken()):40===this.peekCodePoint(0)?(this.consumeCodePoint(),{type:sA.FUNCTION_TOKEN,value:A}):{type:sA.IDENT_TOKEN,value:A}},yA.prototype.consumeUrlToken=function(){var A=[];if(this.consumeWhiteSpace(),-1===this.peekCodePoint(0))return{type:sA.URL_TOKEN,value:\"\"};var e,t=this.peekCodePoint(0);if(39===t||34===t){var r=this.consumeStringToken(this.consumeCodePoint());return r.type===sA.STRING_TOKEN&&(this.consumeWhiteSpace(),-1===this.peekCodePoint(0)||41===this.peekCodePoint(0))?(this.consumeCodePoint(),{type:sA.URL_TOKEN,value:r.value}):(this.consumeBadUrlRemnants(),IA)}for(;;){var n=this.consumeCodePoint();if(-1===n||41===n)return{type:sA.URL_TOKEN,value:l.apply(void 0,A)};if(cA(n))return this.consumeWhiteSpace(),-1===this.peekCodePoint(0)||41===this.peekCodePoint(0)?(this.consumeCodePoint(),{type:sA.URL_TOKEN,value:l.apply(void 0,A)}):(this.consumeBadUrlRemnants(),IA);if(34===n||39===n||40===n||0<=(e=n)&&e<=8||11===e||14<=e&&e<=31||127===e)return this.consumeBadUrlRemnants(),IA;if(92===n){if(!uA(n,this.peekCodePoint(0)))return this.consumeBadUrlRemnants(),IA;A.push(this.consumeEscapedCodePoint())}else A.push(n)}},yA.prototype.consumeWhiteSpace=function(){for(;cA(this.peekCodePoint(0));)this.consumeCodePoint()},yA.prototype.consumeBadUrlRemnants=function(){for(;;){var A=this.consumeCodePoint();if(41===A||-1===A)return;uA(A,this.peekCodePoint(0))&&this.consumeEscapedCodePoint()}},yA.prototype.consumeStringSlice=function(A){for(var e=\"\";0<A;){var t=Math.min(6e4,A);e+=l.apply(void 0,this._value.splice(0,t)),A-=t}return this._value.shift(),e},yA.prototype.consumeStringToken=function(A){for(var e=\"\",t=0;;){var r=this._value[t];if(-1===r||void 0===r||r===A)return e+=this.consumeStringSlice(t),{type:sA.STRING_TOKEN,value:e};if(10===r)return this._value.splice(0,t),TA;if(92===r){var n=this._value[t+1];-1!==n&&void 0!==n&&(10===n?(e+=this.consumeStringSlice(t),t=-1,this._value.shift()):uA(r,n)&&(e+=this.consumeStringSlice(t),e+=l(this.consumeEscapedCodePoint()),t=-1))}t++}},yA.prototype.consumeNumber=function(){var A=[],e=4,t=this.peekCodePoint(0);for(43!==t&&45!==t||A.push(this.consumeCodePoint());iA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());t=this.peekCodePoint(0);var r=this.peekCodePoint(1);if(46===t&&iA(r))for(A.push(this.consumeCodePoint(),this.consumeCodePoint()),e=8;iA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());t=this.peekCodePoint(0),r=this.peekCodePoint(1);var n=this.peekCodePoint(2);if((69===t||101===t)&&((43===r||45===r)&&iA(n)||iA(r)))for(A.push(this.consumeCodePoint(),this.consumeCodePoint()),e=8;iA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());return[function(A){var e=0,t=1;43!==A[e]&&45!==A[e]||(45===A[e]&&(t=-1),e++);for(var r=[];iA(A[e]);)r.push(A[e++]);var n=r.length?parseInt(l.apply(void 0,r),10):0;46===A[e]&&e++;for(var B=[];iA(A[e]);)B.push(A[e++]);var s=B.length,o=s?parseInt(l.apply(void 0,B),10):0;69!==A[e]&&101!==A[e]||e++;var i=1;43!==A[e]&&45!==A[e]||(45===A[e]&&(i=-1),e++);for(var a=[];iA(A[e]);)a.push(A[e++]);var c=a.length?parseInt(l.apply(void 0,a),10):0;return t*(n+o*Math.pow(10,-s))*Math.pow(10,i*c)}(A),e]},yA.prototype.consumeNumericToken=function(){var A=this.consumeNumber(),e=A[0],t=A[1],r=this.peekCodePoint(0),n=this.peekCodePoint(1),B=this.peekCodePoint(2);if(UA(r,n,B)){var s=this.consumeName();return{type:sA.DIMENSION_TOKEN,number:e,flags:t,unit:s}}return 37===r?(this.consumeCodePoint(),{type:sA.PERCENTAGE_TOKEN,number:e,flags:t}):{type:sA.NUMBER_TOKEN,number:e,flags:t}},yA.prototype.consumeEscapedCodePoint=function(){var A=this.consumeCodePoint();if(aA(A)){for(var e=l(A);aA(this.peekCodePoint(0))&&e.length<6;)e+=l(this.consumeCodePoint());cA(this.peekCodePoint(0))&&this.consumeCodePoint();var t=parseInt(e,16);return 0===t||function(A){return 55296<=A&&A<=57343}(t)||1114111<t?65533:t}return-1===A?65533:A},yA.prototype.consumeName=function(){for(var A=\"\";;){var e=this.consumeCodePoint();if(wA(e))A+=l(e);else{if(!uA(e,this.peekCodePoint(0)))return this.reconsumeCodePoint(e),A;A+=l(this.consumeEscapedCodePoint())}}},yA);function yA(){this._value=[]}var _A=(PA.create=function(A){var e=new MA;return e.write(A),new PA(e.read())},PA.parseValue=function(A){return PA.create(A).parseComponentValue()},PA.parseValues=function(A){return PA.create(A).parseComponentValues()},PA.prototype.parseComponentValue=function(){for(var A=this.consumeToken();A.type===sA.WHITESPACE_TOKEN;)A=this.consumeToken();if(A.type===sA.EOF_TOKEN)throw new SyntaxError(\"Error parsing CSS component value, unexpected EOF\");this.reconsumeToken(A);for(var e=this.consumeComponentValue();(A=this.consumeToken()).type===sA.WHITESPACE_TOKEN;);if(A.type===sA.EOF_TOKEN)return e;throw new SyntaxError(\"Error parsing CSS component value, multiple values found when expecting only one\")},PA.prototype.parseComponentValues=function(){for(var A=[];;){var e=this.consumeComponentValue();if(e.type===sA.EOF_TOKEN)return A;A.push(e),A.push()}},PA.prototype.consumeComponentValue=function(){var A=this.consumeToken();switch(A.type){case sA.LEFT_CURLY_BRACKET_TOKEN:case sA.LEFT_SQUARE_BRACKET_TOKEN:case sA.LEFT_PARENTHESIS_TOKEN:return this.consumeSimpleBlock(A.type);case sA.FUNCTION_TOKEN:return this.consumeFunction(A)}return A},PA.prototype.consumeSimpleBlock=function(A){for(var e={type:A,values:[]},t=this.consumeToken();;){if(t.type===sA.EOF_TOKEN||Be(t,A))return e;this.reconsumeToken(t),e.values.push(this.consumeComponentValue()),t=this.consumeToken()}},PA.prototype.consumeFunction=function(A){for(var e={name:A.value,values:[],type:sA.FUNCTION};;){var t=this.consumeToken();if(t.type===sA.EOF_TOKEN||t.type===sA.RIGHT_PARENTHESIS_TOKEN)return e;this.reconsumeToken(t),e.values.push(this.consumeComponentValue())}},PA.prototype.consumeToken=function(){var A=this._tokens.shift();return void 0===A?SA:A},PA.prototype.reconsumeToken=function(A){this._tokens.unshift(A)},PA);function PA(A){this._tokens=A}function xA(A){return A.type===sA.DIMENSION_TOKEN}function VA(A){return A.type===sA.NUMBER_TOKEN}function zA(A){return A.type===sA.IDENT_TOKEN}function XA(A){return A.type===sA.STRING_TOKEN}function JA(A,e){return zA(A)&&A.value===e}function GA(A){return A.type!==sA.WHITESPACE_TOKEN}function kA(A){return A.type!==sA.WHITESPACE_TOKEN&&A.type!==sA.COMMA_TOKEN}function WA(A){var e=[],t=[];return A.forEach(function(A){if(A.type===sA.COMMA_TOKEN){if(0===t.length)throw new Error(\"Error parsing function args, zero tokens for arg\");return e.push(t),void(t=[])}A.type!==sA.WHITESPACE_TOKEN&&t.push(A)}),t.length&&e.push(t),e}function YA(A){return A.type===sA.NUMBER_TOKEN||A.type===sA.DIMENSION_TOKEN}function qA(A){return A.type===sA.PERCENTAGE_TOKEN||YA(A)}function ZA(A){return 1<A.length?[A[0],A[1]]:[A[0]]}function jA(A,e,t){var r=A[0],n=A[1];return[ae(r,e),ae(void 0!==n?n:r,t)]}function $A(A){return A.type===sA.DIMENSION_TOKEN&&(\"deg\"===A.unit||\"grad\"===A.unit||\"rad\"===A.unit||\"turn\"===A.unit)}function Ae(A){switch(A.filter(zA).map(function(A){return A.value}).join(\" \")){case\"to bottom right\":case\"to right bottom\":case\"left top\":case\"top left\":return[se,se];case\"to top\":case\"bottom\":return Qe(0);case\"to bottom left\":case\"to left bottom\":case\"right top\":case\"top right\":return[se,ie];case\"to right\":case\"left\":return Qe(90);case\"to top left\":case\"to left top\":case\"right bottom\":case\"bottom right\":return[ie,ie];case\"to bottom\":case\"top\":return Qe(180);case\"to top right\":case\"to right top\":case\"left bottom\":case\"bottom left\":return[ie,se];case\"to left\":case\"right\":return Qe(270)}return 0}function ee(A){return 0==(255&A)}function te(A){var e=255&A,t=255&A>>8,r=255&A>>16,n=255&A>>24;return e<255?\"rgba(\"+n+\",\"+r+\",\"+t+\",\"+e/255+\")\":\"rgb(\"+n+\",\"+r+\",\"+t+\")\"}function re(A,e){if(A.type===sA.NUMBER_TOKEN)return A.number;if(A.type!==sA.PERCENTAGE_TOKEN)return 0;var t=3===e?1:255;return 3===e?A.number/100*t:Math.round(A.number/100*t)}function ne(A){var e=A.filter(kA);if(3===e.length){var t=e.map(re),r=t[0],n=t[1],B=t[2];return ue(r,n,B,1)}if(4!==e.length)return 0;var s=e.map(re),o=(r=s[0],n=s[1],B=s[2],s[3]);return ue(r,n,B,o)}var Be=function(A,e){return e===sA.LEFT_CURLY_BRACKET_TOKEN&&A.type===sA.RIGHT_CURLY_BRACKET_TOKEN||(e===sA.LEFT_SQUARE_BRACKET_TOKEN&&A.type===sA.RIGHT_SQUARE_BRACKET_TOKEN||e===sA.LEFT_PARENTHESIS_TOKEN&&A.type===sA.RIGHT_PARENTHESIS_TOKEN)},se={type:sA.NUMBER_TOKEN,number:0,flags:4},oe={type:sA.PERCENTAGE_TOKEN,number:50,flags:4},ie={type:sA.PERCENTAGE_TOKEN,number:100,flags:4},ae=function(A,e){if(A.type===sA.PERCENTAGE_TOKEN)return A.number/100*e;if(xA(A))switch(A.unit){case\"rem\":case\"em\":return 16*A.number;case\"px\":default:return A.number}return A.number},ce=function(A){if(A.type===sA.DIMENSION_TOKEN)switch(A.unit){case\"deg\":return Math.PI*A.number/180;case\"grad\":return Math.PI/200*A.number;case\"rad\":return A.number;case\"turn\":return 2*Math.PI*A.number}throw new Error(\"Unsupported angle type\")},Qe=function(A){return Math.PI*A/180},we=function(A){if(A.type===sA.FUNCTION){var e=he[A.name];if(void 0===e)throw new Error('Attempting to parse an unsupported color function \"'+A.name+'\"');return e(A.values)}if(A.type===sA.HASH_TOKEN){if(3===A.value.length){var t=A.value.substring(0,1),r=A.value.substring(1,2),n=A.value.substring(2,3);return ue(parseInt(t+t,16),parseInt(r+r,16),parseInt(n+n,16),1)}if(4===A.value.length){t=A.value.substring(0,1),r=A.value.substring(1,2),n=A.value.substring(2,3);var B=A.value.substring(3,4);return ue(parseInt(t+t,16),parseInt(r+r,16),parseInt(n+n,16),parseInt(B+B,16)/255)}if(6===A.value.length){t=A.value.substring(0,2),r=A.value.substring(2,4),n=A.value.substring(4,6);return ue(parseInt(t,16),parseInt(r,16),parseInt(n,16),1)}if(8===A.