/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
    "jquery",
    "moment",
    'mage/template',
    'mage/translate',
    'Magento_Ui/js/modal/alert',
    "mage/calendar",
    "jquery/ui",
    'prototype'
], function (jQuery, moment, mageTemplate, $t, alert) {
    'use strict';

    if (typeof RentBookingProduct == 'undefined') {
        window.RentBookingProduct = {};
    }

    RentBookingProduct.Config = Class.create();
    RentBookingProduct.Config.prototype = {

        /**
         * Initialize function.
         *
         * @param {Object} config
         */
        initialize: function (config) {
            this.config = config;
            this.holidaysData = config.holidaysData;

            var optionsData = JSON.parse(config.optionsJson);

            jQuery.each(optionsData, function (k, v) {
                if (v.title == 'Choose Rent Type') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_2').val(config.bookingDate);
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_2').parents('.field.admin__field').hide();
                    jQuery('.wk-bk-rent-type-option').each(function () {
                        var dataOptId = jQuery(this).attr('data-opt-id');
                        var value = jQuery(this).val();
                        jQuery('#'+dataOptId).val(value);
                        if (this.checked) {                            
                            jQuery('#'+dataOptId).trigger('click');
                        }
                    });
                }
                if (v.title == 'Rent From') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
                if (v.title == 'Rent To') {
                   jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').parents('.field.admin__field').hide();
                }
            });

            if (config.containerId) {
                this.settings   = $$('#' + config.containerId + ' ' + '.wk-bk-dates-container');
            } else {
                this.settings   = $$('.wk-bk-dates-container');
            }

            // Set values to inputs
            this.configureForValues();
            document.observe('dom:loaded', this.configureForValues.bind(this));
        },

        /**
         * Configure for values.
         */
        configureForValues: function () {
            this.settings.each(function (element) {
                this.configureElement(element);
            }.bind(this));
        },

        /**
         * @param {Object} event
         */
        configure: function (event) {
            var element = Event.element(event);

            this.configureElement(element);
        },

        /**
         * @param {Object} element
         */
        configureElement: function (element) {
            this.fillSelect(element);
        },

        /**
         * @param {Object} element
         */
        fillSelect: function (element) {
            var self = this;
            //var optionId = element.id.replace(/[a-z]*/, '');
            var options = this.config;
            var rentTypeArr = options.rentTypeArr;
            var unvailableDates = options.hourlyUnavailableDates;

            if (element.querySelector('.wk-bk-rent-type-option')) {
                var children = element.querySelectorAll('.wk-bk-rent-type-option');
                for(var i=0; i < children.length; i++) {
                    if (children[i].nodeType == 1 & (children[i].classList.contains('wk-bk-rent-type-option'))) {
                        if (children[i].checked) {
                            var rentTypeElement = children[i];
                            var dataOptId = jQuery(rentTypeElement).attr('data-opt-id');
                            jQuery('#product_composite_configure_form_fields #'+dataOptId).prop('checked', true);
                            jQuery('#product_composite_configure_form_fields #wk-rbk-select-slot').html('');
                            jQuery('#product_composite_configure_form_fields #wk-rbk-select-time').html('');
                            if (parseInt(jQuery(rentTypeElement).val()) == parseInt(rentTypeArr.d)) {
                                var tmpl = self.generateSelectDailyTemplate(options.rentOptions);
                                element.querySelector('#wk-rbk-select-date').innerHTML = tmpl;

                                var bookingDateFrom = jQuery("#product_composite_configure_form_fields #wk-rbk-select-from-date")
                                    .datepicker({
                                        minDate: options.bookingAvailableFrom,
                                        maxDate: options.bookingAvailableTo
                                    })
                                    .on("change", function () {
                                        bookingDateTo.datepicker("option", "minDate", self.getBookingDate(element, this));
                                    }),
                                bookingDateTo = jQuery("#product_composite_configure_form_fields #wk-rbk-select-to-date")
                                    .datepicker({
                                        minDate: options.bookingAvailableFrom,
                                        maxDate: options.bookingAvailableTo
                                    })
                                    .on("change", function () {
                                        bookingDateFrom.datepicker("option", "maxDate", self.getBookingDate(element, this));
                                    });
                            } else {
                                var tmpl = self.generateSelectHourlyTemplate(options.rentOptions);
        
                                element.querySelector('#wk-rbk-select-date').innerHTML = tmpl;
        
                                var bookingDateFrom = jQuery("#product_composite_configure_form_fields #wk-rbk-select-from-date")
                                .datepicker({
                                    minDate: options.bookingAvailableFrom,
                                    maxDate: options.bookingAvailableTo,
                                    beforeShowDay: function (date) {
                                        var string = jQuery.datepicker.formatDate('dd M, yy', date);
                                        var isDisabled = (jQuery.inArray(string, unvailableDates) != -1);
                                        if(isDisabled){
                                            return [!isDisabled];
                                        }
                                        string = jQuery.datepicker.formatDate('yy-mm-dd', date);
                                        let holiday = self.holidaysData[string];
                                        if(holiday){
                                            return [false,'',holiday];
                                        }
                                        return [true];
                                    },
                                    onSelect: function () {
                                        self.getBookingDate(element, this);
                                    }
                                });
                            }
                        }

                        this.changeRentTypeOptionEvent(self, element, children[i]);
                    }
                }
            }
        },
    
        getBookingDate: function (element, currentElement) {
            var self = this;
            var date;
            try {
                var dataOption = this.config;
                var monthArr = dataOption.monthArr;
                var rentTypeArr = dataOption.rentTypeArr;
                var dateFormat = "mm/dd/yy";
                date = jQuery.datepicker.parseDate(dateFormat, currentElement.value);
                var selectedDate  = jQuery(currentElement).val();
                var selectedDateArr  = selectedDate.split('/');
                var day = selectedDateArr[1];
                var month = selectedDateArr[0];
                var year = selectedDateArr[2];
                var formatedDate = day+" "+monthArr[month]+", "+year;
                let optionDate = year+"-"+month+"-"+day;
                var d = new Date(selectedDate);
                var dayIndex = d.getDay();
                if (!dayIndex) {
                    dayIndex = 7;
                }

                jQuery(currentElement)
                    .parents('.wk-bk-dates-wrapper')
                    .find('.wk-bk-select-date-label').text(formatedDate).attr('data-booking-date', optionDate);

                var rentType = jQuery("#product_composite_configure_form_fields .wk-bk-rent-type-option:input[type='radio']:checked").val();
                if (parseInt(rentTypeArr.d) == parseInt(rentType)) {
                    jQuery(currentElement)
                        .parents('.wk-bk-dates-wrapper')
                        .find('.wk-bk-date-option').val(optionDate);

                    var dataOptId = jQuery(currentElement)
                        .parents('.wk-bk-dates-wrapper')
                        .find('.wk-bk-date-option')
                        .attr('data-opt-id');

                    jQuery('#product_composite_configure_form_fields #'+dataOptId).val(optionDate);

                    var dataFromOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').attr('data-opt-id');
                    var currentFromDate = jQuery('#product_composite_configure_form_fields #'+dataFromOptId).val();
                    var dataToOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').attr('data-opt-id');
                    var currentToDate = jQuery('#product_composite_configure_form_fields #'+dataToOptId).val();
                    self.calculatePrice(self, element, currentFromDate, currentToDate);
                } else {
                    this.resetOptions(element, dataOption);

                    if (jQuery('#product_composite_configure_form_fields #wk-rbk-select-from-date').val()) {
                        var fromDate = new Date(jQuery('#product_composite_configure_form_fields #wk-rbk-select-from-date').val());
                        var fday = fromDate.getDate();
                        var fmonth = fromDate.getMonth() + 1;
                        var fyear = fromDate.getFullYear();

                        var todayDate = new Date();
                        var tday = todayDate.getDate();
                        var tmonth = todayDate.getMonth() + 1;
                        var tyear = todayDate.getFullYear();
                        // if from selected date is today
                        if (fday == tday && fmonth == tmonth && fyear == tyear) {
                            var tmpl = this.generateSelectSlotTodayTemplate(dataOption);
                        } else {
                            var tmpl = this.generateSelectSlotTemplateByDay(dataOption, dayIndex);
                        }
                        jQuery('#product_composite_configure_form_fields #wk-rbk-select-slot').html(tmpl);
                        this.changeParentSlotIdEvent(self, element);
                    } else {
                        jQuery('#product_composite_configure_form_fields #wk-rbk-select-slot').html('');
                    }
                    jQuery('#product_composite_configure_form_fields #wk-rbk-select-time').html('');
                }
            } catch (error) {
                console.log(error);
                date = null;
            }
            return date;
        },

        resetOptions: function (element, dataOption) {
            var optionsData = JSON.parse(dataOption.optionsJson);
            jQuery.each(optionsData, function (k, v) {
                if (v.title == 'Rent From') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val('');
                }
                if (v.title == 'Rent To') {
                    jQuery('#product_composite_configure_form_fields #options_'+v.id+'_text').val('');
                }
            });
        },

        generateSelectDailyTemplate: function (rentOptions) {
            var tempHtml = '';
            tempHtml = tempHtml + '<div class="wk-bk-dates-wrapper wk-bk-dates-left-container field required">';
            tempHtml = tempHtml + '<label class="admin__field-label label wk-bk-dates-title-container">';
            tempHtml = tempHtml + '<span>' + $t('From') + '</span>';
            tempHtml = tempHtml + '</label>';
            tempHtml = tempHtml + '<label for="wk-rbk-select-from-date" data-booking-date="" class="wk-bk-select-date-label">';
            tempHtml = tempHtml + $t('Select Date') + '</label>';
            if (rentOptions.rent_from.option_id) {
                var dateFromOptionId = rentOptions.rent_from.option_id;
                tempHtml = tempHtml + '<input type="hidden" id="wk-rbk-from-date-option" class="wk-bk-date-option" data-opt-id="options_'+dateFromOptionId+'_text" value="">';
            }
            tempHtml = tempHtml + '<input class="required-entry input-text wk-bk-datetype" id="wk-rbk-select-from-date" type="text" name="booking_date_from" value="" placeholder="' + $t('Select Date') + '" readonly>';
            tempHtml = tempHtml + '</div>';
            tempHtml = tempHtml + '<div class="wk-bk-dates-wrapper wk-bk-dates-left-container field required">';
            tempHtml = tempHtml + '<label class="admin__field-label label wk-bk-dates-title-container">';
            tempHtml = tempHtml + '<span>' + $t('To') + '</span>';
            tempHtml = tempHtml + '</label>';
            tempHtml = tempHtml + '<label for="wk-rbk-select-to-date" data-booking-date="" class="wk-bk-select-date-label">' + $t('Select Date') + '</label>';
            if (rentOptions.rent_to.option_id) {
                var dateToOptionId = rentOptions.rent_to.option_id;
                tempHtml = tempHtml + '<input type="hidden" id="wk-rbk-to-date-option" class="wk-bk-date-option" data-opt-id="options_'+dateToOptionId+'_text" value="">';
            }
            tempHtml = tempHtml + '<input class="required-entry input-text wk-bk-datetype" id="wk-rbk-select-to-date" type="text" name="booking_date_to" value="" placeholder="' + $t('Select Date') + '" readonly>';
            tempHtml = tempHtml + '</div>';
            return tempHtml;
        },

        generateSelectHourlyTemplate: function (rentOptions) {
            var tempHtml = '';
            tempHtml = tempHtml + '<div class="wk-bk-dates-wrapper field required">';
            tempHtml = tempHtml + '<label class="admin__field-label label wk-bk-dates-title-container">';
            tempHtml = tempHtml + '<span>' + $t('Select Date') + '</span>';
            tempHtml = tempHtml + '</label>';
            tempHtml = tempHtml + '<label for="wk-rbk-select-from-date" data-booking-date="" class="wk-bk-select-date-label">';
            tempHtml = tempHtml + $t('Select Date') + '</label>';
            if (rentOptions.rent_from.option_id) {
                var dateFromOptionId = rentOptions.rent_from.option_id;
                tempHtml = tempHtml + '<input type="hidden" id="wk-rbk-from-date-option" data-opt-id="options_'+dateFromOptionId+'_text" class="wk-bk-date-option" value="">';
            }
            tempHtml = tempHtml + '<input class="required-entry input-text wk-bk-datetype" id="wk-rbk-select-from-date" type="text" name="booking_date_from" value="" placeholder="' + $t('Select Date') + '" readonly>';
            if (rentOptions.rent_to.option_id) {
                var dateToOptionId = rentOptions.rent_to.option_id;
                tempHtml = tempHtml + '<input type="hidden" id="wk-rbk-to-date-option" data-opt-id="options_'+dateToOptionId+'_text" class="wk-bk-date-option" value="">';
            }
            tempHtml = tempHtml + '</div>';
            return tempHtml;
        },

        generateSelectSlotTodayTemplate: function (options) {
            var fromDayIndex = options.fromDayIndex;
            var bookingSlotData = options.bookingSlotData;
            var currentTime = options.currentTime;
            var tempHtml = '';
            tempHtml = tempHtml + '<div class="wk-bk-dates-left-container field required">';
            tempHtml = tempHtml + '<label class="admin__field-label label wk-bk-dates-title-container">';
            tempHtml = tempHtml + '<span>' + $t('Select Time Slot') + '</span>';
            tempHtml = tempHtml + '</label>';
            tempHtml = tempHtml + '</div>';
            tempHtml = tempHtml + '<div>';
            tempHtml = tempHtml + '<input type="hidden" name="slot_day_index" id="wk-rbk-slot-day-index" value="'+fromDayIndex+'">';
            tempHtml = tempHtml + '<input type="hidden" name="slot_id" id="wk-rbk-slot-id" value="">';
            tempHtml = tempHtml + '<select name="parent_slot_id" id="wk-rbk-parent-slot-id" class="validate-select admin__control-text required-entry valid">';
            if (bookingSlotData[fromDayIndex]) {
                tempHtml = tempHtml + '<option value="">' + $t('Select Slot') + '</option>';
                var toDaySlots = bookingSlotData[fromDayIndex];
                jQuery.each(toDaySlots, function (key, slots) {
                    if (currentTime <= slots.to_time_string) { 
                        tempHtml = tempHtml + '<option value="' +key+ '">';
                        tempHtml = tempHtml + $t(slots.from+' to '+slots.to);
                        tempHtml = tempHtml + '</option>';
                    }else { 
                        tempHtml = tempHtml + '<option value="' +key+ '">';
                        tempHtml = tempHtml + $t(slots.from+' to '+slots.to+' (Closed)');
                        tempHtml = tempHtml + '</option>';
                    }
                });
            } else {
                tempHtml = tempHtml + '<option value="">'+ $t('Closed') +'</option>';
            }
            tempHtml = tempHtml + '</select>';
            tempHtml = tempHtml + '</div>';
            return tempHtml;
        },

        generateSelectSlotTemplateByDay: function (options, dayIndex) {
            var bookingSlotData = options.bookingSlotData;
            var tempHtml = '';
            tempHtml = tempHtml + '<div class="wk-bk-dates-left-container field required">';
            tempHtml = tempHtml + '<label class="admin__field-label label wk-bk-dates-title-container">';
            tempHtml = tempHtml + '<span>'+ $t('Select Time Slot') +'</span>';
            tempHtml = tempHtml + '</label>';
            tempHtml = tempHtml + '</div>';
            tempHtml = tempHtml + '<div>';
            tempHtml = tempHtml + '<input type="hidden" name="slot_day_index" id="wk-rbk-slot-day-index" value="'+ dayIndex +'">';
            tempHtml = tempHtml + '<input type="hidden" name="slot_id" id="wk-rbk-slot-id" value="">';
            tempHtml = tempHtml + '<select name="parent_slot_id" id="wk-rbk-parent-slot-id" class="validate-select  admin__control-text required-entry">';
            if (bookingSlotData[dayIndex]) {
                tempHtml = tempHtml + '<option value="">' + $t('Select Slot') + '</option>';
                var toDaySlots = bookingSlotData[dayIndex];
                jQuery.each(toDaySlots, function (key, slots) {
                    tempHtml = tempHtml + '<option value="' + key + '">';
                    tempHtml = tempHtml + $t('%1 to %2').replace('%1', slots.from).replace('%2', slots.to);
                    tempHtml = tempHtml + '</option>';
                });
            } else {
                tempHtml = tempHtml + '<option value="">' + $t('Closed') + '</option>';
            }
            tempHtml = tempHtml + '</select>';
            tempHtml = tempHtml + '</div>';
            return tempHtml;
        },

        generateSelectTimeTemplate: function () {
            var tempHtml = '';
            tempHtml = tempHtml + '<div class="field required">';
            tempHtml = tempHtml + '<label class="admin__field-label label wk-bk-dates-title-container">';
            tempHtml = tempHtml + '<span>' + $t('Select Rent Time') + '</span>';
            tempHtml = tempHtml + '</label>';
            tempHtml = tempHtml + '</div>';
            tempHtml = tempHtml + '<div class="wk-bk-dates-left-container">';
            tempHtml = tempHtml + '<label class="admin__field-label label wk-bk-dates-title-container">';
            tempHtml = tempHtml + '<span>' + $t('From') + '</span>';
            tempHtml = tempHtml + '</label>';
            tempHtml = tempHtml + '<select name="booking_from_time" id="wk-rbk-from-time" class="wk-bk-date-time validate-select admin__control-text required-entry">';
            tempHtml = tempHtml + '</select>';
            tempHtml = tempHtml + '</div>';
            tempHtml = tempHtml + '<div class="wk-bk-dates-right-container">';
            tempHtml = tempHtml + '<label class="admin__field-label label wk-bk-dates-title-container">';
            tempHtml = tempHtml + '<span>' + $t('To') + '</span>';
            tempHtml = tempHtml + '</label>';
            tempHtml = tempHtml + '<select name="booking_to_time" id="wk-rbk-to-time" class="wk-bk-date-time validate-select admin__control-text required-entry">';
            tempHtml = tempHtml + '</select>';
            tempHtml = tempHtml + '</div>';
            return tempHtml;
        },

        generateSelectFromTimeOptTemplateToday: function (options, dayIndex, slotIndex, slots) {
            var tempHtml = '';
            tempHtml = tempHtml + '<option value="">'+$t('Select Time')+'</option>';
            var firstIndex = 0;
            var firstTodayIndex = 0;
            var fromDayIndex = options.fromDayIndex;
            var currentTime = options.currentTime;
            var totalSlots = Object.keys(slots.slots_info).length;
            jQuery.each(slots.slots_info, function (slotKey, slotValue) {
                firstIndex = firstIndex + 1;
                firstTodayIndex = firstTodayIndex + 1;
                if (fromDayIndex == dayIndex && currentTime <= slotValue.time_string) {
                    if (firstTodayIndex != totalSlots) {
                        tempHtml = tempHtml + '<option data-time="' + slotValue.time_string + '" value="' + slotKey +'">';
                        tempHtml = tempHtml + slotValue.time + '</option>';
                    }
                }
            });
            return tempHtml;
        },

        generateSelectFromTimeOptTemplate: function (options, dayIndex, slotIndex, slots) {
            var tempHtml = '';
            tempHtml = tempHtml + '<option value="">'+$t('Select Time')+'</option>';
            var firstIndex = 0;
            var totalSlots = Object.keys(slots.slots_info).length;
            jQuery.each(slots.slots_info, function (slotKey, slotValue) {
                firstIndex = firstIndex + 1;
                if (firstIndex != totalSlots) {
                    tempHtml = tempHtml + '<option value="'+slotKey+'">'+slotValue.time+'</option>';
                }
            });
            return tempHtml;
        },

        generateSelectToTimeOptTemplateToday: function (options, dayIndex, slotIndex, slots) {
            var tempHtml = '';
            tempHtml = tempHtml + '<option value="">'+$t('Select Time')+'</option>';
            var firstIndex = 0;
            var firstTodayIndex = 0;
            var fromDayIndex = options.fromDayIndex;
            var currentTime = options.currentTime;
            jQuery.each(slots.slots_info, function (slotKey, slotValue) {
                firstIndex = firstIndex + 1;
                firstTodayIndex = firstTodayIndex + 1;
                if (fromDayIndex == dayIndex && currentTime <= slotValue.time_string) {
                    if (firstTodayIndex) {
                        tempHtml = tempHtml + '<option data-time="' + slotValue.time_string + '" value="' + slotKey +'">';
                        tempHtml = tempHtml + slotValue.time + '</option>';
                    }
                }
            });
            return tempHtml;
        },

        generateSelectToTimeOptTemplate: function (options, dayIndex, slotIndex, slots) {
            var tempHtml = '';
            tempHtml = tempHtml + '<option value="">'+$t('Select Time')+'</option>';
            var firstIndex = 0;
            jQuery.each(slots.slots_info, function (slotKey, slotValue) {
                if (firstIndex) {
                    tempHtml = tempHtml + '<option value="'+slotKey+'">'+slotValue.time+'</option>';
                }
                firstIndex = firstIndex + 1;
            });
            return tempHtml;
        },

        changeRentTypeOptionEvent: function (self, element, currentElement) {
            currentElement.onchange = function() {
                if (currentElement.checked) {
                    var dataOption = self.config;
                    var rentTypeArr = dataOption.rentTypeArr;
                    var unvailableDates = dataOption.hourlyUnavailableDates;

                    var dataOptId = jQuery(currentElement).attr('data-opt-id');
                    jQuery('#product_composite_configure_form_fields #'+dataOptId).prop('checked', true);

                    jQuery('#product_composite_configure_form_fields #wk-rbk-select-slot').html('');
                    jQuery('#product_composite_configure_form_fields #wk-rbk-select-time').html('');
                    if (parseInt(jQuery(currentElement).val()) == parseInt(rentTypeArr['d'])) {
                        var tmpl = self.generateSelectDailyTemplate(dataOption.rentOptions);
                        jQuery('#product_composite_configure_form_fields #wk-rbk-select-date').html(tmpl);
                        var bookingDateFrom = jQuery("#product_composite_configure_form_fields #wk-rbk-select-from-date")
                            .datepicker({
                                minDate: dataOption.bookingAvailableFrom,
                                maxDate: dataOption.bookingAvailableTo
                            })
                            .on("change", function () {
                                bookingDateTo.datepicker("option", "minDate", self.getBookingDate(element, this));
                            }),
                        bookingDateTo = jQuery("#product_composite_configure_form_fields #wk-rbk-select-to-date")
                            .datepicker({
                                minDate: dataOption.bookingAvailableFrom,
                                maxDate: dataOption.bookingAvailableTo
                            })
                            .on("change", function () {
                                bookingDateFrom.datepicker("option", "maxDate", self.getBookingDate(element, this));
                            });
                    } else {
                        var tmpl = self.generateSelectHourlyTemplate(dataOption.rentOptions);

                        jQuery('#product_composite_configure_form_fields #wk-rbk-select-date').html(tmpl);

                        var bookingDateFrom = jQuery("#product_composite_configure_form_fields #wk-rbk-select-from-date")
                        .datepicker({
                            minDate: dataOption.bookingAvailableFrom,
                            maxDate: dataOption.bookingAvailableTo,
                            beforeShowDay: function (date) {
                                var string = jQuery.datepicker.formatDate('dd M, yy', date);
                                var isDisabled = (jQuery.inArray(string, unvailableDates) != -1);
                                if(isDisabled){
                                    return [!isDisabled];
                                }
                                string = jQuery.datepicker.formatDate('yy-mm-dd', date);
                                let holiday = self.holidaysData[string];
                                if(holiday){
                                    return [false,'',holiday];
                                }
                                return [true];
                            },
                            onSelect: function () {
                                self.getBookingDate(element, this);
                            }
                        });
                    }
                }
            }
        },

        changeParentSlotIdEvent: function (self, element) {
            if (element.querySelector('#wk-rbk-parent-slot-id')) {
                element.querySelector('#wk-rbk-parent-slot-id').onchange = function() {
                    var dataOption = self.config;

                    jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').val('');
                    var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').attr('data-opt-id');
                    jQuery('#product_composite_configure_form_fields #'+dataOptId).val('');

                    jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').val('');
                    var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').attr('data-opt-id');
                    jQuery('#product_composite_configure_form_fields #'+dataOptId).val('');

                    if (jQuery(this).val()) {
                        var dayIndex = jQuery('#product_composite_configure_form_fields #wk-rbk-slot-day-index').val();
                        var slotIndex = jQuery(this).val();

                        var tmpl = self.generateSelectTimeTemplate(dataOption.rentOptions);

                        jQuery('#product_composite_configure_form_fields #wk-rbk-select-time').html(tmpl);

                        self.changeRentFromDateEvent(self, element);

                        self.changeRentToDateEvent(self, element);

                        var formattedDate = moment(jQuery('#product_composite_configure_form_fields #wk-rbk-select-from-date').val()).format('YYYY-MM-DD');
                        var fromDate = new Date(formattedDate);
                        var fday = fromDate.getDate();
                        var fmonth = fromDate.getMonth() + 1;
                        var fyear = fromDate.getFullYear();

                        var todayDate = new Date();
                        var tday = todayDate.getDate();
                        var tmonth = todayDate.getMonth() + 1;
                        var tyear = todayDate.getFullYear();

                        var slots = dataOption.bookingSlotData[dayIndex][slotIndex];
                        // if from selected date is today
                        if (fday == tday && fmonth == tmonth && fyear == tyear) {
                            if (dataOption.fromDayIndex == dayIndex) {
                                var tmpl = self.generateSelectFromTimeOptTemplateToday(
                                    dataOption,
                                    dayIndex,
                                    slotIndex,
                                    slots
                                );
                                jQuery('#product_composite_configure_form_fields #wk-rbk-from-time').html(tmpl);
                            }

                            let currentTimeString = parseInt(Date.now()/1000);
                            jQuery('#product_composite_configure_form_fields #wk-rbk-from-time > option').each(function() {
                                if (jQuery(this).val() != '' && currentTimeString >= parseInt(jQuery(this).data('time'))) {
                                    jQuery(this).attr('disabled', 'disabled');
                                }
                            });

                            if (dataOption.fromDayIndex == dayIndex) {
                                var tmpl = self.generateSelectToTimeOptTemplateToday(
                                    dataOption,
                                    dayIndex,
                                    slotIndex,
                                    slots
                                );
                                jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').html(tmpl);
                            }
                        } else {
                            var tmpl = self.generateSelectFromTimeOptTemplate(
                                dataOption,
                                dayIndex,
                                slotIndex,
                                slots
                            );
                            jQuery('#product_composite_configure_form_fields #wk-rbk-from-time').html(tmpl);
                            
                            var tmpl = self.generateSelectToTimeOptTemplate(
                                dataOption,
                                dayIndex,
                                slotIndex,
                                slots
                            );
                            jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').html(tmpl);
                        }

                        jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').attr('disabled', 'disabled');
                    } else {
                        jQuery('#product_composite_configure_form_fields #wk-rbk-select-time').html('');
                    }
                };
            }
        },

        changeRentFromDateEvent: function (self, element) {
            if (element.querySelector('#wk-rbk-from-time')) {
                element.querySelector('#wk-rbk-from-time').onchange = function() {
                    var dataOption = self.config;
                    var thisObj = jQuery(this);
                    jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').removeAttr('disabled');
                    jQuery("#product_composite_configure_form_fields #wk-rbk-from-time option").each(function () {
                        this.disabled = false;
                    });
                    jQuery("#product_composite_configure_form_fields #wk-rbk-to-time option").each(function () {
                        this.disabled = false;
                    });
                    if (thisObj.val()) {
                        jQuery('#product_composite_configure_form_fields #wk-rbk-slot-id').val(thisObj.val());
                        if (thisObj.val() && jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').val()) {
                            if (parseInt(thisObj.val()) >= parseInt(jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').val())) {
                                thisObj.val('');
                                jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').val('');
                                var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').attr('data-opt-id');
                                jQuery('#product_composite_configure_form_fields #'+dataOptId).val('');
                            } else {
                                var currentDate = jQuery('#product_composite_configure_form_fields #wk-rbk-select-from-date')
                                .parents('.wk-bk-dates-wrapper')
                                .find('.wk-bk-select-date-label').attr('data-booking-date');
                                var currentFromDate = currentDate;
                                var currentToDate = currentDate;
                                var currentFromTime = jQuery("#product_composite_configure_form_fields #wk-rbk-from-time option:selected").text();
                                if (currentFromTime && currentFromTime!=0) {
                                    currentFromDate = currentDate+' '+currentFromTime;
                                }
    
                                jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').val(currentFromDate);
                                var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').attr('data-opt-id');
                                jQuery('#product_composite_configure_form_fields #'+dataOptId).val(currentFromDate);
    
                                var currentToTime = jQuery("#product_composite_configure_form_fields #wk-rbk-to-time option:selected").text();
                                if (currentToTime && currentToTime!=0) {
                                    currentToDate = currentDate+' '+currentToTime;
                                }
                                jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').val(currentToDate);
                                var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').attr('data-opt-id');
                                jQuery('#product_composite_configure_form_fields #'+dataOptId).val(currentToDate);
                            }
                        }
                        jQuery("#product_composite_configure_form_fields #wk-rbk-to-time option").each(function () {
                            if (parseInt(this.value) <= parseInt(thisObj.val())) {
                                this.disabled = true;
                            }
                        });
                    } else {
                        jQuery('#product_composite_configure_form_fields #wk-rbk-slot-id').val('');
                        jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').val('');
                        jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').val('');
                        var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').attr('data-opt-id');
                        jQuery('#product_composite_configure_form_fields #'+dataOptId).val('');
                        jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').attr('disabled', 'disabled');
                    }
                };
            }
        },

        changeRentToDateEvent: function (self, element) {
            if (element.querySelector('#wk-rbk-to-time')) {
                element.querySelector('#wk-rbk-to-time').onchange = function() {
                    var dataOption = self.config;
                    var thisObj = jQuery(this);
                    jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').removeAttr('disabled');
                    jQuery("#product_composite_configure_form_fields #wk-rbk-from-time option").each(function () {
                        this.disabled = false;
                    });
                    jQuery("#product_composite_configure_form_fields #wk-rbk-to-time option").each(function () {
                        this.disabled = false;
                    });
                    if (thisObj.val() && jQuery('#product_composite_configure_form_fields #wk-rbk-from-time').val()) {
                        if (parseInt(thisObj.val()) <= parseInt(jQuery('#product_composite_configure_form_fields #wk-rbk-from-time').val())) {
                            thisObj.val('');
                            jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').val('');
                            var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').attr('data-opt-id');
                            jQuery('#product_composite_configure_form_fields #'+dataOptId).val('');
                        } else {
                            var currentDate = jQuery('#product_composite_configure_form_fields #wk-rbk-select-from-date')
                            .parents('.wk-bk-dates-wrapper')
                            .find('.wk-bk-select-date-label').attr('data-booking-date');
                            var currentFromDate = currentDate;
                            var currentToDate = currentDate;
                            var currentFromTime = jQuery("#product_composite_configure_form_fields #wk-rbk-from-time option:selected").text();
                            if (currentFromTime && currentFromTime!=0) {
                                currentFromDate = currentDate+' '+currentFromTime;
                            }
    
                            jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').val(currentFromDate);
                            var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-from-date-option').attr('data-opt-id');
                            jQuery('#product_composite_configure_form_fields #'+dataOptId).val(currentFromDate);
    
                            var currentToTime = jQuery("#product_composite_configure_form_fields #wk-rbk-to-time option:selected").text();
                            if (currentToTime && currentToTime!=0) {
                                currentToDate = currentDate+' '+currentToTime;
                            }
                            jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').val(currentToDate);
                            var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').attr('data-opt-id');
                            jQuery('#product_composite_configure_form_fields #'+dataOptId).val(currentToDate);

                            self.calculatePrice(self, element, currentFromDate, currentToDate);
                        }
                        jQuery("#product_composite_configure_form_fields #wk-rbk-from-time option").each(function () {
                            if (parseInt(this.value) >= parseInt(thisObj.val())) {
                                this.disabled = true;
                            }
                        });
                    } else {
                        jQuery('#product_composite_configure_form_fields #wk-rbk-slot-id').val('');
                        jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').val('');
                        jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').val('');
                        var dataOptId = jQuery('#product_composite_configure_form_fields #wk-rbk-to-date-option').attr('data-opt-id');
                        jQuery('#product_composite_configure_form_fields #'+dataOptId).val('');
                        if (!jQuery('#product_composite_configure_form_fields #wk-rbk-from-time').val()) {
                            jQuery('#product_composite_configure_form_fields #wk-rbk-to-time').attr('disabled', 'disabled');
                        }
                    }
                };
            }
        },

        calculatePrice: function (self, element, currentFromDate, currentToDate) {
            var price;
            var rentTypeArr = self.config.rentTypeArr;
            var rentType = element.querySelector('.wk-bk-rent-type-option:checked').value;
            var selectedTypeId = jQuery(element.querySelector('.wk-bk-rent-type-option:checked')).attr('data-opt-id');
            var chargedPrice = jQuery(element.querySelector('.wk-bk-rent-type-option:checked')).attr('data-charged-price');
            var productPrice = jQuery(element.querySelector('.wk-bk-rent-type-option:checked')).attr('data-product-price');
            var dateFrom = new Date(currentFromDate);
            var dateTo = new Date(currentToDate);

            var timeDiff = dateTo.getTime() - dateFrom.getTime();
            if (parseInt(rentType) == parseInt(rentTypeArr['d'])) {
                var daysDiff = timeDiff / (1000 * 3600 * 24);
                daysDiff = daysDiff+1; //as diff is not considering end day
                price = chargedPrice*daysDiff;
            } else {
                var hoursDiff = timeDiff / (1000 * 3600);
                price = chargedPrice*hoursDiff;
            }
            price = price - productPrice;
            jQuery('#'+selectedTypeId).attr('price', price);
        }
    };
});
