require(['jquery'], function ($) {
    $(document).ready(function () {
        const maxLength = 167;

        $('.product.attribute.overview [itemprop="description"]').each(function () {
            const fullText = $(this).text();

            if (fullText.length > maxLength) {
                const visibleText = fullText.substring(0, maxLength) + "...";
                $(this).html(`
                    <span class="short-text">${visibleText}</span>
                    <span class="full-text" style="display: none;">${fullText}</span>
                    <a href="#" class="toggle-text">Ver más</a>
                `);
            }
        });

        $(document).on('click', '.toggle-text', function (e) {
            e.preventDefault();
            const container = $(this).closest('[itemprop="description"]');
            container.find('.short-text').toggle();
            container.find('.full-text').toggle();

            $(this).text($(this).text() === "Ver más" ? "Ver menos" : "Ver más");
        });
    });
});
