require(['jquery', 'mage/translate'], function ($, $t) {
    $(document).ready(function () {
        $(document).on('click', '#slot_time', function () {
            $(this).attr('step', '900'); // 900 segundos = 15 minutos
            });
        // $(document).on('click', '#slot_time', function () {
        //     let timeValue = $(this).val();
        //     let [hours, minutes] = timeValue.split(":").map(Number);
        //
        //     // Redondear minutos a los valores permitidos (00, 15, 30, 45)
        //     minutes = Math.floor(minutes / 15) * 15;
        //
        //     // Asegurar que la hora no pase de 12 y convertir a formato 12 horas
        //     let period = hours >= 12 ? "PM" : "AM";
        //     hours = hours % 12 || 12; // Convertir 0 a 12 para formato 12 horas
        //
        //     // Formatear la hora con ceros a la izquierda si es necesario
        //     let formattedTime = `${String(hours).padStart(2, "0")}:${String(minutes).padStart(2, "0")}`;
        //     $(this).val(formattedTime);
        // });
        // Obtener parámetros de la URL
        var urlParams = new URLSearchParams(window.location.search);

        // Verificar si el parámetro 'action' tiene el valor 'newReservation'
        if (urlParams.get('action') === 'newReservation') {
            var checkExist = setInterval(function () {
                if ($('#create_reservation').length) {
                    clearInterval(checkExist); // Detiene el intervalo una vez encontrado
                    $('#create_reservation').trigger('click');
                }
            }, 500); // Revisa cada 500ms si el botón existe
        }

        $('.filter_button#filter_by_today').addClass('active');

        function convertTo24Hour(timeStr) {
            // Usar una expresión regular para detectar el formato am/pm
            var timeFormat = /(\d{1,2}):(\d{2}):(\d{2}) ([apAP][mM])/;
            var match = timeStr.match(timeFormat);

            if (match) {
                var hours = parseInt(match[1], 10);
                var minutes = match[2];
                var period = match[3].toLowerCase();

                // Convertir a formato 24 horas
                if (period === 'pm' && hours !== 12) {
                    hours += 12;  // Agregar 12 horas si es PM
                } else if (period === 'am' && hours === 12) {
                    hours = 0;  // 12 AM es igual a 00
                }

                // Formatear el tiempo a HH:MM:SS
                return ("0" + hours).slice(-2) + ":" + minutes + ":00";
            }

            return "Formato inválido";
        }

        // Obtener la fecha actual en formato "YYYY-MM-DD"
        function getCurrentDate() {
            const today = new Date();
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, '0');
            const day = String(today.getDate()).padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        $('.filter_button').on('click', function () {
            let filterButton = $(this).attr('id');
            $('.filter_input').each(function () {
                $(this).val('');
            });
            $('.filter_button').removeClass('active'); // Reemplaza 'active' por el nombre de la clase que quieras quitar
            $('.filter_button#' + filterButton).addClass('active');
            switch (filterButton) {
                case "filter_by_today":
                    filterValue = getCurrentDate();
                    break;
                case "filter_by_confirm_status":
                    filterValue = "complete";
                    break;
                case "filter_by_cancel_status":
                    filterValue = "cancelled";
                    break;
                default:
                    filterValue = ""; // Valor por defecto en caso de que no coincida ningún caso
                    break;
            }
            let filterButtonKeysAndValues = {
                key: filterButton,
                value: filterValue
            };
            let filters = {filtros: [filterButtonKeysAndValues]};

            $.ajax({
                url: '/hostess/index/filter',
                type: 'POST',
                data: filters,
                showLoader: true,
                success: function (response) {
                    $('.reservation-list').html(response.html);
                },
                error: function () {
                    console.log($t('Error loading the form data.')); // Traducido
                }
            });
        });

        $('.filter_input').on('change', function () {
            let filters = [];
            $('.filter_input').each(function () {
                let filterInput = $(this).attr('id');
                if ($(this).val().trim() != '') {
                    let filterInputKeysAndValues = {
                        key: filterInput,
                        value: $(this).val().trim()
                    };
                    filters.push(filterInputKeysAndValues);
                }
            });
            if (filters.length <= 0) {
                return;
            }
            $.ajax({
                url: '/hostess/index/filter',
                type: 'POST',
                data: {filtros: filters},
                showLoader: true,
                success: function (response) {
                    $('.reservation-list').html(response.html);
                },
                error: function () {
                    console.log($t('Error loading the form data.')); // Traducido
                }
            });
        });

        // Capturar clic en el botón Detalles
        $(document).on('click', '.action.details', function () {
            var card = $(this).closest('.reservation-card');
            let customerName = card.find('[name="nombre"] .name-value');
            let adultVar = card.find('[name="adultos"]');
            let childVar = card.find('[name="niños"]');
            let tableType = card.find('[name="table-type"]');
            let tableIds = card.find('[name="table-ids"]');
            let timeStr = card.find('[name="slot-time"]').val().trim();
            let telephone = card.find('[name="telephone"]');
            let convertedTime = convertTo24Hour(timeStr);
            let reservationData = {
                customerFirstname: customerName[0].value,
                customerLastname: customerName[1].value,
                orderId: card.find('[name="order_id"]').val(),
                slotDate: card.find('[name="slot-date"]').val().trim(),
                slotTime: convertedTime,
                guestQty: card.find('[name="comensales"] .item-value').text().trim(),
                guestQtyAdult: adultVar[0].value,
                guestQtyChildren: childVar[0].value,
                tableType: tableType[0].value,
                tableIds: tableIds[0].value,
                status: card.find('[name="status-order"]').val().trim(),
                assignedTables: card.find('[name="mesa_asignada"] .item-value').text().trim(),
                commentReservation: card.find('[name="comentarios"]').val(),
                requestedTable: card.find('[name="table-request-type"]').val(),
                requestedArea: card.find('[name="table-request-zone"]').val(),
                telephone: telephone[0].value
            };

            // Hacer una llamada AJAX al controlador
            $.ajax({
                url: '/hostess/index/edit',
                type: 'POST',
                data: reservationData,
                showLoader: true,
                success: function (response) {
                    $('.reservation-edit-form-container-form').html(response.html);
                    let formContainer = document.querySelector('.reservation-edit-form-container-form');
                    let formElements = formContainer.querySelectorAll('input[type="text"], input[type="date"], input[type="time"], input[type="number"], select, textarea button');
                    let status = card.find('[name="status-order"]').val().trim();
                    $('#save_button').addClass('update-reservation');
                    $('#save_button').removeClass('create-reservation');

                    let currentIncrementId = $('.current-detail-reservation').val();
                    let getTimeFormatCurrent = $('#get-time-format-'+currentIncrementId).val();
                    $('#slot_time').val(getTimeFormatCurrent);

                    if (status != 'complete' && status != 'cancelled') {
                        formElements.forEach(element => {
                            element.removeAttribute('disabled');
                            $('button.assign-table').attr('disabled', false);
                            $('button.assign-table-delete').attr('disabled', false);
                        });
                        $('#slot_date').attr('disabled', 'disabled');
                        $('#slot_time').attr('disabled', 'disabled');
                        $('#assignment_wait_time').attr('disabled', 'disabled');
                        $('#consumption_time_remaining').attr('disabled', 'disabled');
                        $('#assign-table').attr('disabled', false);
                    } else {
                        $('button.assign-table').attr('disabled', 'disabled');
                        $('button.assign-table-delete').attr('disabled', 'disabled');
                        formElements.forEach(element => {
                            element.setAttribute('disabled', 'disabled');
                        });
                    }
                },
                error: function () {
                    console.log($t('Error loading the form data.')); // Traducido
                }
            });
        });

        // Guardar cambios del formulario
        $(document).on('click', '#create_reservation', function () {

            $.ajax({
                url: '/hostess/index/create',
                type: 'POST',
                showLoader: true,
                success: function (response) {
                    $('.reservation-edit-form-container-form').html(response.html);
                    $('#save_button').addClass('create-reservation');
                    $('#save_button').removeClass('update-reservation');
                    $('#assign-table').attr('disabled', false);
                },
                error: function () {
                    alert($t('Error guetting form.')); // Traducido
                }
            });
        });

        $('#consumption-form-group').hide();
        $('#assignment-form-group').show();
        $(document).on('change', '#initial_reservation', function () {
            if ($(this).is(':checked')) {
                $('#status').val('confirmed');
                $('#assignment-form-group').hide();
                $('#consumption-form-group').show();
            } else {
                $('#status').val('pending');
                $('#consumption-form-group').hide();
                $('#assignment-form-group').show();
            }
        });


        $(document).on('click', '.create-reservation', function (e) {
            e.preventDefault();
            if (!$('#reservation-method').val()) {
                $('#reservation-method').addClass('error-select');
                alert($t('Select Reservation Method Value'));
                return false;
            }
            // Obtener la fecha actual en formato YYYY-MM-DD
            let tzoffset = (new Date()).getTimezoneOffset() * 60000; //offset in milliseconds
            let localISOTime = (new Date(Date.now() - tzoffset)).toISOString().slice(0, -1);
            let today = localISOTime.split('T')[0];
            let reservationDate = $('#slot_date').val();
            let isInitialReservationChecked = $('#initial_reservation').prop('checked');

            // Validar si el checkbox está marcado y la fecha es distinta a hoy
            if (isInitialReservationChecked && reservationDate !== today) {
                alert($t('The reservation date must be today for an initial reservation.'));
                return false; // Detiene la ejecución
            }
            $('#assigment-table-list').val($('.assigment-table-value-table').text());
            $('#assigment-table-type').val($('.assigment-table-value-type').text());
            $('#reservation-method').removeClass('error-select');
            $.ajax({
                url: '/hostess/index/save',
                type: 'POST',
                data: $("#reservation-edit-form").serialize(),
                showLoader: true,
                success: function (response) {
                    if (response.success == true) {
                        alert($t('Created Order') + response.order_id);
                        $('#search_filter_by_word').val(response.order_id);
                        // Esperar 2 segundos y ejecutar la función de filtrado
                        $('#search_filter_by_word').trigger('change');
                            setTimeout(function () {
                            $('.action.details').trigger('click');
                            $('#search_filter_by_word').val('');
                                var urlParams = new URLSearchParams(window.location.search);
                                // Verificar si el parámetro 'action' tiene el valor 'newReservation'
                                if (urlParams.get('action') === 'newReservation') {
                                    urlParams.delete('action'); // Eliminar el parámetro de la URL
                                    // Reconstruir la URL sin el parámetro y actualizarla
                                    var newUrl = window.location.pathname + '?' + urlParams.toString();
                                    window.history.replaceState(null, '', newUrl);
                                }
                        }, 2500);


                    } else {
                        if(response.message.substring(29,32) == "IV-"){
                            alert(response.message.substring(32,response.message.length));
                        } else {
                            alert($t('Error to create Reservation.')); // Traducido
                        }
                    }
                    return true;
                },
                error: function () {
                    alert($t('Error to create Reservation.')); // Traducido
                    return true;
                }
            });
        });

        $(document).on('click', '.update-reservation', function (e) {
            e.preventDefault();
// Obtener la fecha actual en formato YYYY-MM-DD
            let tzoffset = (new Date()).getTimezoneOffset() * 60000; //offset in milliseconds
            let localISOTime = (new Date(Date.now() - tzoffset)).toISOString().slice(0, -1);
            let today = localISOTime.split('T')[0];
            let reservationDate = $('#slot_date').val();
            let status = $('#status').val();

            // Validar si el checkbox está marcado y la fecha es distinta a hoy
            if (status === 'confirmed' && reservationDate !== today) {
                alert($t('The reservation date must be today for an initial reservation.'));
                return false; // Detiene la ejecución
            }

            if (status === 'complete' || status === 'cancelled') {
                $('#assigment-table-list-id').val('');
            }

            $('#assigment-table-list').val($('.assigment-table-value-table').text());
            $('#assigment-table-type').val($('.assigment-table-value-type').text());


            $.ajax({
                url: '/hostess/index/save',
                type: 'POST',
                data: $("#reservation-edit-form").serialize(),
                showLoader: true,
                success: function (response) {
                    if (response.success == true) {
                        alert($t('Update Order: ') + response.order_id);
                        // $('#search_filter_by_word').val(response.order_id);
                        $('#filter_by_today').trigger('click');
                        // $('#search_filter_by_word').trigger('change');
                        // $('#search_filter_by_word').val('');

                    } else {
                        alert($t('Error to update Reservation.')); // Traducido
                    }
                    return true;
                },
                error: function () {
                    alert($t('Error to update Reservation.')); // Traducido
                    return true;
                }
            });
        });

        const timers = document.querySelectorAll('[data-time-end]');
        timers.forEach(timer => {
            const now = new Date();
            const [hours, minutes, seconds] = timer.getAttribute('data-time-end').split(':').map(Number);
            // Tiempo total en segundos
            let totalSeconds = hours * 3600 + minutes * 60 + seconds;
            const interval = setInterval(() => {
                if (totalSeconds <= 0) {
                    timer.textContent = '00:00:00';
                    timer.classList.remove('status-serving');
                    timer.classList.add('status-cancelled');
                    clearInterval(interval);
                    return;
                }
                totalSeconds--;
                const h = String(Math.floor(totalSeconds / 3600)).padStart(2, '0');
                const m = String(Math.floor((totalSeconds % 3600) / 60)).padStart(2, '0');
                const s = String(totalSeconds % 60).padStart(2, '0');
                timer.textContent = `${h}:${m}:${s}`;
            }, 1000);
        });
    });
});
