require.config({"config": {
        "jsbuild":{"Andromeda_MenuDigital/js/menudigital.js":"require(['jquery', 'mage/translate', 'Magento_Ui/js/modal/modal'], function ($, $t, modal) {\n    $(document).ready(function () {\n\n        $('.custom-header-links li').each(function () {\n            var linkText = $(this).find('a').text().trim();\n            if (linkText === 'Menu digital') {\n                $(this).addClass('active');\n            }\n        });\n\n        $('.link-create-menu').on('click', function() {\n            window.location.href = '/menudigital/index/create';\n        });\n\n        $('.link-introduction-menu').on('click', function() {\n            window.location.href = '/menudigital/index/introduction/';\n        });\n\n\n        //Tabs header\n        $('.tabs .tab').on('click', function() {\n\n            var tabId = $(this).data('tab-id');\n\n            // Validar solo si hacen click en las pesta\u00f1as que mencionaste\n            if (tabId === 'select-categories' || tabId === 'select-products' || tabId === 'select-template' || tabId === 'select-custom' || tabId === 'select-preview' ) {\n                var menuId = $('#menu-id').val().trim(); // Tomamos el valor del input y quitamos espacios\n\n                if (menuId === '') {\n                    alert('Debes de completar la secci\u00f3n de \"Informaci\u00f3n men\u00fa\" para continuar.');\n                    return false;\n                }\n            }\n\n\n\n            $('.container-block').hide();\n            var tabId = $(this).data('tab-id');\n            if(tabId == 'select-template'){\n                $('.container-template').show();\n            }else if(tabId == 'select-custom'){\n                $('.container-custom').show();\n            }else if(tabId == 'select-preview'){\n                $('.container-preview').show();\n                reloadPreview();\n            }else if(tabId == 'select-create-menu'){\n                $('.container-information').show();\n            }else if(tabId == 'select-categories'){\n                $('.container-categories').show();\n                reloadCategories();\n                let menuId = $('#menu-id').val();\n                if (menuId && menuId.trim() !== '') {\n                    $('.wrapper-list-categories').show();\n                }\n            }else{\n                $('.container-products').show();\n                $('.contenedor-principal, .template-section').show();\n                $('.container-new-product').hide();\n                reloadTableProducts();\n            }\n            $('.tabs .tab').removeClass('active');\n            $(this).addClass('active');\n\n        });\n\n        //DASHBOARD\n        $(document).on('click', '.menu-options', function (e) {\n            e.stopPropagation();\n            const $menu = $(this).siblings('.dropdown-menu');\n            $('.dropdown-menu').not($menu).hide();\n            $menu.toggle();\n        });\n\n        $(document).on('click', function () {\n            $('.dropdown-menu').hide();\n        });\n\n        $('.menu-list').on('click', '.item-show', function () {\n            const card = $(this).closest('.menu-card');\n            const id = card.data('id');\n            window.open('/menudigital/index/view/id/' + id, '_blank');\n        });\n\n        $('.menu-list').on('click', '.item-qr', function () {\n            const card = $(this).closest('.menu-card');\n            const id = card.data('id');\n            window.location.href = '/menudigital/index/qr/id/'+id;\n        });\n\n        $('.menu-list').on('click', '.item-edit', function () {\n            const card = $(this).closest('.menu-card');\n            const id = card.data('id');\n            window.location.href = '/menudigital/index/menu/id/'+id;\n        });\n\n        $('.menu-list').on('click', '.item-delete', function () {\n            const card = $(this).closest('.menu-card');\n            const id = card.data('id');\n            if (!id) return;\n\n            if (!confirm('\u00bfEst\u00e1s seguro de que deseas eliminar este men\u00fa?')) return;\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/deletemenu',\n                method: 'POST',\n                data: { id },\n                success: function (res) {\n                    if (res.success) {\n                        card.fadeOut(300, () => card.remove());\n                    } else {\n                        alert(res.message || 'Error al eliminar', false);\n                    }\n                },\n                error: function () {\n                    alert('Error de red', false);\n                }\n            });\n        });\n\n        // Inicializar cada modal por clase\n        $('.modal-contenido').each(function() {\n            var options = {\n                type: 'popup',\n                responsive: true,\n                innerScroll: true,\n                title: 'Vista previa',\n                buttons: [{\n                    text: $.mage.__('Cerrar'),\n                    class: 'action-secondary',\n                    click: function () {\n                        this.closeModal();\n                    }\n                }]\n            };\n\n            modal(options, $(this));\n        });\n\n        // Abrir el modal correspondiente al hacer clic\n        $('.abrir-modal, .card-actions').on('click', function() {\n            var modalId = $(this).data('modal-id');\n            $('#' + modalId).modal('openModal');\n        });\n\n        //upload image product\n        $('#upload-image').on('change', function (event) {\n            const file = event.target.files[0];\n            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];\n            const maxSize = 2 * 1024 * 1024; // 2 MB\n            if (!allowedTypes.includes(file.type) || file.size > maxSize) {\n                alert(\"Lo sentimos, solo se permiten im\u00e1genes en formato JPG, JPEG y PNG menores a 2 MB\");\n                return;\n            }\n            if (!file) return;\n\n            const reader = new FileReader();\n            reader.onload = function (e) {\n                $('.preview-image').attr('src', e.target.result).show();\n                $('.image-upload-placeholder').hide();\n                $('.image-upload-placeholder-loaded').show();\n\n            };\n            reader.readAsDataURL(file);\n        });\n\n        $('#edit-upload-image').on('change', function (event) {\n            const file = event.target.files[0];\n            if (!file) return;\n\n            const reader = new FileReader();\n            reader.onload = function (e) {\n                $('.edit-preview-image').attr('src', e.target.result).show();\n                $('.edit-image-upload-placeholder').hide();\n                $('.edit-image-upload-placeholder-loaded').show();\n\n            };\n            reader.readAsDataURL(file);\n        });\n\n        $('.remove-image').on('click', function () {\n            $('#upload-image').val('');\n            $('.preview-image').attr('src', '').hide();\n            $('.image-upload-placeholder').show();\n            $('.image-upload-placeholder-loaded').hide();\n\n        });\n\n        $('.edit-remove-image').on('click', function () {\n            $('#edit-upload-image').val('');\n            $('.edit-preview-image').attr('src', '').hide();\n            $('.edit-image-upload-placeholder').show();\n            $('.edit-image-upload-placeholder-loaded').hide();\n\n        });\n\n\n\n        $('.add-image').on('click', function () {\n            $('#upload-image').click();\n        });\n\n        $('.edit-add-image').on('click', function () {\n            $('#edit-upload-image').click();\n        });\n\n        $('.menu-actions.cancel').on('click', function() {\n            window.location.href = '/menudigital/index/dashboard/';\n        });\n\n        //Guardar Informaci\u00f3n MENU\n        $('.container-information .btn-save-info-menu').on('click', function (e) {\n            e.preventDefault(); // Evita el env\u00edo tradicional del formulario\n\n            var form = $('#menu-form')[0]; // obtenemos el DOM puro del form\n            var formData = new FormData(form); // construimos el FormData desde el form\n\n            // Validaciones de campos obligatorios\n            var menuName = formData.get('menu_name');\n            var menuDesc = formData.get('menu_description');\n            var restaurantId = formData.get('restaurant_id');\n            var terms = formData.get('terms');\n            var status = formData.get('status');\n\n\n            let camposFaltantes = [];\n\n            if (!menuName) camposFaltantes.push('Nombre');\n            if (!restaurantId) camposFaltantes.push('Restaurante');\n            if (!menuDesc) camposFaltantes.push('Descripci\u00f3n');\n            if (!terms) camposFaltantes.push('Terminos y condiciones');\n            if (!status) camposFaltantes.push('Status');\n\n            if (camposFaltantes.length > 0) {\n                alert('Por favor, complete los siguientes campos:\\n- ' + camposFaltantes.join('\\n- '));\n                return;\n            }\n\n            if (menuName.length > 30) {\n                alert('El campo \"Nombre\" no puede tener m\u00e1s de 30 caracteres.');\n                return;\n            }\n\n            if (menuDesc.length > 200) {\n                alert('El campo \"Descripci\u00f3n\" no puede tener m\u00e1s de 200 caracteres.');\n                return;\n            }\n\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savemenuinfo',\n                type: 'POST',\n                showLoader: true,\n                data: formData,\n                processData: false,\n                contentType: false,\n                success: function (res) {\n                    if (res.success) {\n                        alert(res.message);\n                        $('#menu-id').val(res.menu_id);\n\n                        $('html, body').animate({\n                            scrollTop: $('.tabs').offset().top - 50\n                        }, 600, function () {\n                            // Aplicar efecto de resaltar al siguiente tab\n                            //$('.tab[data-tab-id=\"select-categories\"]').addClass('highlight-tab');\n\n                            // Opcional: removerlo despu\u00e9s de un tiempo (ej. 4 parpadeos \u2248 4s)\n                            setTimeout(function () {\n                                //$('.tab[data-tab-id=\"select-categories\"]').removeClass('highlight-tab');\n                            }, 2000);\n                        });\n\n\n\n                    } else {\n                        alert(res.message || 'Ocurri\u00f3 un error al guardar');\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado al guardar el men\u00fa');\n                }\n            });\n        });\n\n        function buildSelect(levelData, level = 1, selectedPath = []) {\n            const select = $('<select>').attr('data-level', level).addClass('category-level');\n            select.addClass('custom-select');\n            select.append($('<option>', { value: '', text: '-- Selecciona --' }));\n\n            levelData.forEach(category => {\n                select.append($('<option>', {\n                    value: category.id,\n                    text: category.name,\n                    'data-json': JSON.stringify(category)\n                }));\n            });\n\n            return select;\n        }\n\n        function renderNextLevel(selectedOption, level) {\n            const selected = $(selectedOption).find(':selected');\n            const data = selected.data('json');\n            const nextData = data?.children || [];\n\n            $(\"#category-selects select\").each(function () {\n                if (parseInt($(this).data('level')) > level) {\n                    $(this).closest('.col-select').remove();\n                }\n            });\n\n            if (nextData.length > 0 && level < 4) {\n                const nextSelect = buildSelect(nextData, level + 1);\n                const container = $(`\n                        <div class=\"col-select form-group\">\n                            <label>Subcategorias</label>\n                        </div>\n                    `);\n\n                container.append(nextSelect);\n                $('#category-selects').append(container);\n            }\n            updateJson();\n        }\n\n        function updateJson() {\n            const path = {};\n            $('#category-selects select').each(function (index) {\n                const selected = $(this).find(':selected');\n                if (selected.val()) {\n                    path['level_' + (index + 1)] = {\n                        id: selected.val()\n                    };\n                }\n            });\n            $('#categories-json').val(JSON.stringify(path));\n        }\n\n        function buildSelectEdit(levelData, level = 1, selectedPath = []) {\n            const select = $('<select>').attr('data-level', level).addClass('category-level');\n            select.addClass('custom-select');\n            select.append($('<option>', { value: '', text: '-- Selecciona --' }));\n\n            levelData.forEach(category => {\n                select.append($('<option>', {\n                    value: category.id,\n                    text: category.name,\n                    'data-json': JSON.stringify(category)\n                }));\n            });\n\n            return select;\n        }\n        function renderNextLevelEdit(selectedOption, level) {\n            const selected = $(selectedOption).find(':selected');\n            const data = selected.data('json');\n            const nextData = data?.children || [];\n\n            $(\"#edit-category-selects select\").each(function () {\n                if (parseInt($(this).data('level')) > level) {\n                    $(this).closest('.col-select').remove();\n                }\n            });\n\n            if (nextData.length > 0 && level < 4) {\n                const nextSelect = buildSelect(nextData, level + 1);\n                const container = $(`\n                        <div class=\"col-select form-group\">\n                            <label>Subcategorias</label>\n                        </div>\n                    `);\n\n                container.append(nextSelect);\n                $('#edit-category-selects').append(container);\n            }\n            updateJsonEdit();\n        }\n\n        function updateJsonEdit() {\n            const path = {};\n            $('#edit-category-selects select').each(function (index) {\n                const selected = $(this).find(':selected');\n                if (selected.val()) {\n                    path['level_' + (index + 1)] = {\n                        id: selected.val(),\n                        name: selected.text()\n                    };\n                }\n            });\n            $('#edit-categories-json').val(JSON.stringify(path));\n        }\n\n\n        /*Ajax Add Product*/\n        $('#add-product').on('click', function () {\n\n            let formData = new FormData();\n            let nombre = $('#nombre').val();\n            let descripcion = $('#descripcion').val();\n            let precio = $('#precio').val();\n            let destacado = $('input[name=\"check-product-destacado\"]:checked').val();\n            let categorias = $('#categories-json').val();\n            let imagen = $('#upload-image')[0].files[0];\n            let categoriaNivel1 = $('select.category-level[data-level=\"1\"]').val();\n\n            let camposFaltantes = [];\n\n            if (!nombre) camposFaltantes.push('Nombre');\n            if (!descripcion) camposFaltantes.push('Descripci\u00f3n');\n            if (!categoriaNivel1) camposFaltantes.push('Categor\u00eda');\n            if (!precio) camposFaltantes.push('Precio');\n            if (!destacado) camposFaltantes.push('Producto destacado');\n            if (!imagen) camposFaltantes.push('Imagen');\n\n            if (camposFaltantes.length > 0) {\n                alert('Por favor, complete los siguientes campos:\\n- ' + camposFaltantes.join('\\n- '));\n                return;\n            }\n\n            if (nombre.length > 30) {\n                alert('El campo \"Nombre\" no puede tener m\u00e1s de 30 caracteres.');\n                return;\n            }\n\n            if (descripcion.length > 200) {\n                alert('El campo \"Descripci\u00f3n\" no puede tener m\u00e1s de 200 caracteres.');\n                return;\n            }\n\n            if (precio.length > 7) {\n                alert('El campo \"Precio\" no puede tener m\u00e1s de 7 caracteres.');\n                return;\n            }\n\n\n            formData.append('nombre', nombre);\n            formData.append('descripcion', descripcion);\n            formData.append('precio', precio);\n            formData.append('destacado', destacado);\n            formData.append('categorias', categorias);\n            if (imagen) {\n                formData.append('imagen', imagen);\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/saveproduct',\n                type: 'POST',\n                data: formData,\n                contentType: false,\n                processData: false,\n                showLoader: true,\n                success: function (res) {\n                    if (res.success) {\n                        reloadTableProducts();\n                    } else {\n                        alert(res.message || 'Error inesperado');\n                    }\n                },\n                error: function () {\n                    alert('Error al procesar el producto');\n                }\n            });\n        });\n\n        $('.container-products').on('click', '.boton-agregar-producto', function () {\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/create',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    $('#category-selects .col-select').remove();\n                    let tempDiv = $('<div>').html(response);\n                    let newContent = tempDiv.find('#data-categories');\n                    let categoryData = newContent[0]['attributes']['value']['value'];\n                    let parsedData = JSON.parse(categoryData);\n                    const firstSelect = buildSelect(parsedData);\n                    const container = $(`\n                            <div class=\"col-select form-group\">\n                                <label>Categorias</label>\n                            </div>\n                        `);\n                    container.append(firstSelect);\n                    $('#category-selects').append(container);\n\n                    $('#category-selects').on('change', 'select', function () {\n                        const level = parseInt($(this).data('level'));\n                        renderNextLevel($(this), level);\n                    });\n                    $('.container-new-product').show();\n                    $('.template-section, .contenedor-principal').hide();\n                    limpiarFormularioProducto();\n\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n\n        });\n\n        $('#cancel-product').on('click', function () {\n            $('.container-new-product').hide();\n            $('.template-section, .contenedor-principal').show();\n            limpiarFormularioProducto();\n        });\n\n        function limpiarFormularioProducto() {\n            const $form = $('.container-new-product');\n            $form.find('#nombre, #descripcion, #precio').val('');\n            $form.find('select.category-level').val('');\n            $form.find('#upload-image').val('');\n            $form.find('.preview-image').attr('src', '');\n            $form.find('.image-upload-placeholder-loaded').hide();\n            $form.find('.image-upload-placeholder').show();\n        }\n\n\n        function reloadTableProducts(){\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/create',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    // Crea un contenedor temporal para poder manipular el DOM recibido\n                    const tempDiv = $('<div>').html(response);\n\n                    // Encuentra el div espec\u00edfico dentro de ese contenido\n                    const newContent = tempDiv.find('.product-table');\n\n                    // Reemplaza el contenido en el DOM actual\n                    $('.product-table').replaceWith(newContent);\n                    $('.container-new-product').hide();\n                    $('input[name=\"check-product-destacado\"][value=\"0\"]').prop('checked', true);\n                    $('.contenedor-principal, .template-section').show();\n\n\n\n                    // Inicializar paginador nuevamente despu\u00e9s de reemplazar la tabla\n                    (function setupPaginator() {\n                        const rowsPerPage = $('#number-paginator').val();\n                        const $rows = $('.product-table tbody tr');\n                        const totalRows = $rows.length;\n                        const totalPages = Math.ceil(totalRows / rowsPerPage);\n                        let currentPage = 1;\n\n                        function showPage(page) {\n                            if (page < 1 || page > totalPages) return;\n                            currentPage = page;\n                            $rows.hide();\n                            const start = (page - 1) * rowsPerPage;\n                            const end = start + rowsPerPage;\n                            $rows.slice(start, end).show();\n\n                            renderPagination();\n                        }\n\n                        function createPageElement(label, page, isActive = false, isEllipsis = false) {\n                            const $el = $('<div class=\"paginator-number\"></div>');\n                            $el.text(label);\n\n                            if (isEllipsis) {\n                                $el.addClass('ellipsis');\n                                return $el;\n                            }\n\n                            if (isActive) $el.addClass('active');\n\n                            $el.attr('data-page', page);\n                            $el.on('click', () => showPage(page));\n\n                            return $el;\n                        }\n\n                        function renderPagination() {\n                            let $pagination = $('.paginator-container');\n                            if ($pagination.length === 0) {\n                                $pagination = $('<div class=\"paginator-container\"></div>');\n                                let $paginatorWrapper = `\n                                <div class=\"paginator-select-wrapper\">\n                                  <div class=\"paginator-select-container\">\n                                    <select id=\"paginator-select\" class=\"paginator-select\">\n                                      <option value=\"10\">Productos por p\u00e1gina: 10</option>\n                                      <option value=\"20\">Productos por p\u00e1gina: 20</option>\n                                      <option value=\"30\">Productos por p\u00e1gina: 30</option>\n                                      <option value=\"40\">Productos por p\u00e1gina: 40</option>\n                                      <option value=\"50\">Productos por p\u00e1gina: 50</option>\n                                      <option value=\"60\">Productos por p\u00e1gina: 60</option>\n                                    </select>\n                                    <div class=\"paginator-arrow\"></div>\n                                  </div>\n                                </div>\n                                `;\n                                $('.wrapper-paginator').append($pagination);\n                                $('.wrapper-paginator').append($paginatorWrapper);\n                            }\n                            $pagination.empty();\n\n                            const $prev = $('<div class=\"paginator-nav-left\"></div>').on('click', () => showPage(currentPage - 1));\n                            const $next = $('<div class=\"paginator-nav-right\"></div>').on('click', () => showPage(currentPage + 1));\n                            $pagination.append($prev);\n\n                            if (totalPages <= 7) {\n                                for (let i = 1; i <= totalPages; i++) {\n                                    $pagination.append(createPageElement(i, i, i === currentPage));\n                                }\n                            } else {\n                                $pagination.append(createPageElement(1, 1, currentPage === 1));\n\n                                if (currentPage > 4) $pagination.append(createPageElement('...', null, false, true));\n\n                                const start = Math.max(2, currentPage - 2);\n                                const end = Math.min(totalPages - 1, currentPage + 2);\n                                for (let i = start; i <= end; i++) {\n                                    $pagination.append(createPageElement(i, i, i === currentPage));\n                                }\n\n                                if (currentPage < totalPages - 3) $pagination.append(createPageElement('...', null, false, true));\n\n                                $pagination.append(createPageElement(totalPages, totalPages, currentPage === totalPages));\n                            }\n\n                            $pagination.append($next);\n                        }\n\n                        renderPagination();\n                        showPage(1);\n                    })();\n\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n        };\n\n        $(document).on('change', '#paginator-select', function () {\n            var valorSeleccionado = $(this).val();\n            $('#number-paginator').val(valorSeleccionado);\n            (function setupPaginator() {\n                const rowsPerPage = $('#number-paginator').val();\n                const $rows = $('.product-table tbody tr');\n                const totalRows = $rows.length;\n                const totalPages = Math.ceil(totalRows / rowsPerPage);\n                let currentPage = 1;\n\n                function showPage(page) {\n                    if (page < 1 || page > totalPages) return;\n                    currentPage = page;\n                    $rows.hide();\n                    const start = (page - 1) * rowsPerPage;\n                    const end = start + rowsPerPage;\n                    $rows.slice(start, end).show();\n\n                    renderPagination();\n                }\n\n                function createPageElement(label, page, isActive = false, isEllipsis = false) {\n                    const $el = $('<div class=\"paginator-number\"></div>');\n                    $el.text(label);\n\n                    if (isEllipsis) {\n                        $el.addClass('ellipsis');\n                        return $el;\n                    }\n\n                    if (isActive) $el.addClass('active');\n\n                    $el.attr('data-page', page);\n                    $el.on('click', () => showPage(page));\n\n                    return $el;\n                }\n\n                function renderPagination() {\n                    let $pagination = $('.paginator-container');\n                    if ($pagination.length === 0) {\n                        $pagination = $('<div class=\"paginator-container\"></div>');\n                        let $paginatorWrapper = `\n                                <div class=\"paginator-select-wrapper\">\n                                  <div class=\"paginator-select-container\">\n                                    <select id=\"paginator-select\" class=\"paginator-select\">\n                                      <option value=\"10\">Productos por p\u00e1gina: 10</option>\n                                      <option value=\"20\">Productos por p\u00e1gina: 20</option>\n                                      <option value=\"30\">Productos por p\u00e1gina: 30</option>\n                                      <option value=\"40\">Productos por p\u00e1gina: 40</option>\n                                      <option value=\"50\">Productos por p\u00e1gina: 50</option>\n                                      <option value=\"60\">Productos por p\u00e1gina: 60</option>\n                                    </select>\n                                    <div class=\"paginator-arrow\"></div>\n                                  </div>\n                                </div>\n                                `;\n                        $('.wrapper-paginator').append($pagination);\n                        $('.wrapper-paginator').append($paginatorWrapper);\n                    }\n                    $pagination.empty();\n\n                    const $prev = $('<div class=\"paginator-nav-left\"></div>').on('click', () => showPage(currentPage - 1));\n                    const $next = $('<div class=\"paginator-nav-right\"></div>').on('click', () => showPage(currentPage + 1));\n                    $pagination.append($prev);\n\n                    if (totalPages <= 7) {\n                        for (let i = 1; i <= totalPages; i++) {\n                            $pagination.append(createPageElement(i, i, i === currentPage));\n                        }\n                    } else {\n                        $pagination.append(createPageElement(1, 1, currentPage === 1));\n\n                        if (currentPage > 4) $pagination.append(createPageElement('...', null, false, true));\n\n                        const start = Math.max(2, currentPage - 2);\n                        const end = Math.min(totalPages - 1, currentPage + 2);\n                        for (let i = start; i <= end; i++) {\n                            $pagination.append(createPageElement(i, i, i === currentPage));\n                        }\n\n                        if (currentPage < totalPages - 3) $pagination.append(createPageElement('...', null, false, true));\n\n                        $pagination.append(createPageElement(totalPages, totalPages, currentPage === totalPages));\n                    }\n\n                    $pagination.append($next);\n                }\n\n                renderPagination();\n                showPage(1);\n            })();\n        });\n\n        /*INFORMACION DEL MENU - BOTONES ACTIONS*/\n        $('.menu-option').on('click', function () {\n            // Desactivar todos\n            $('.menu-option').removeClass('active');\n\n            // Activar el clicado\n            $(this).addClass('active');\n\n            // Seleccionar el radio correspondiente\n            $(this).find('input[type=\"radio\"]').prop('checked', true);\n        });\n\n        /* CATEGORIAS */\n        function getGroup(level, namePrefix) {\n            return `\n            <div class=\"category-group level-${level}\" data-level=\"${level}\">\n                <div class=\"form-group\">\n                    <input type=\"text\" class=\"input-text\" name=\"${namePrefix}[name]\" placeholder=\"Categor\u00eda nivel ${level}\" required />\n                    ${level < 4 ? '<div class=\"btn-agregar-subcategoria add-sub\" data-icono=\"true\" data-property-1=\"Positivo\" data-texto=\"true\"><div class=\"icon-add\" data-icons=\"icon-add\"></div><div class=\"btn-text\">Agregar subcategor\u00eda</div></div>' : ''}\n                    <div class=\"btn-agregar-subcategoria-cancel delete-sub\" data-icono=\"true\" data-property-1=\"Positivo\" data-texto=\"true\">\n                        <div class=\"icon-delete\" data-icons=\"icon-delete\"></div>\n                        <div class=\"btn-text\">Eliminar</div>\n                    </div>\n                </div>\n                <div class=\"subcategories\"></div>\n            </div>\n        `;\n        }\n\n        $('#categories-wrapper').on('click', '.add-sub', function () {\n            const parentGroup = $(this).closest('.category-group');\n            const level = parseInt(parentGroup.data('level'), 10);\n            if (level >= 4) return;\n\n            const parentName = parentGroup.find('input').attr('name');\n            const childCount = parentGroup.find('> .subcategories > .category-group').length;\n            const namePrefix = parentName.replace(/\\[name\\]$/, '') + '[children][' + childCount + ']';\n\n            const subGroup = $(getGroup(level + 1, namePrefix));\n            parentGroup.find('> .subcategories').append(subGroup);\n\n            subGroup.find('input').focus();\n        });\n\n        $('#categories-wrapper').on('click', '.delete-sub', function () {\n            const currentGroup = $(this).closest('.category-group');\n            currentGroup.remove();\n        });\n\n        $('#categories-wrapper').on('click', '.btn-edit', function (e) {\n            e.stopPropagation();\n            const $categoryCard = $(this).closest('.category-card');\n            $categoryCard.find('.edit-form').first().slideToggle();\n        });\n\n        $('#categories-wrapper').on('click', '.btn-add-sub', function (e) {\n            e.stopPropagation();\n            const $categoryCard = $(this).closest('.category-card');\n            $categoryCard.find('.add-sub-form').first().slideToggle();\n        });\n\n        $('#categories-wrapper').on('click', '.edit-save', function (e) {\n\n            let hayError = false;\n\n            // Limpiar errores previos\n            $('.wrapper-list-categories .edit-input').removeClass('campo-error-edit');\n            $('.wrapper-list-categories .mensaje-error-edit').remove();\n\n            $('.wrapper-list-categories .edit-input').each(function () {\n                const valor = $(this).val().trim();\n                const maxCaracteres = 30;\n\n                if (valor.length > maxCaracteres) {\n                    hayError = true;\n                    $(this).addClass('campo-error-edit');\n                    $(this).after('<div class=\"mensaje-error-edit\">M\u00e1ximo 30 caracteres permitidos.</div>');\n                }\n            });\n\n            if (hayError) {\n                // Opcional: hacer scroll al primer error\n                $('html, body').animate({\n                    scrollTop: $('.campo-error-edit').first().offset().top - 100\n                }, 500);\n                return;\n            }\n\n            const id = $(this).data('id');\n            const container = $('[data-id=\"' + id + '\"]');\n            const name = container.find('.edit-input').val();\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savecategory',\n                type: 'POST',\n                showLoader: true,\n                data: { id: id, name: name },\n                success: function (res) {\n                    if (res.success) {\n                        alert('Actualizado correctamente');\n                        reloadCategories();\n                    } else {\n                        alert(res.message);\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado');\n                }\n            });\n        });\n\n        $('#categories-wrapper').on('click', '.accordion-toggle', function (e) {\n            if (!$(e.target).hasClass('btn-edit')) {\n             //   $(this).siblings('.sub-list').slideToggle();\n            }\n            if (!$(e.target).closest('.btn-edit, .btn-delete').length) {\n                const $toggle = $(this);\n                const $arrow = $toggle.find('.toggle-arrow-categories');\n\n                $toggle.siblings('.sub-list').slideToggle();\n                $arrow.toggleClass('rotated');\n            }\n        });\n\n        $(document).on('click', '.edit-save-sub-cat', function () {\n            const parentId = $(this).data('parent-id');\n            const level = $(this).data('level');\n            const input = $('.add-sub-form[data-parent-id=\"' + parentId + '\"]').find('.new-subcategory-input');\n            const name = input.val().trim();\n            const menuId = $('#menu-id').val();\n\n            if (!name) {\n                alert('El nombre no puede estar vac\u00edo');\n                return;\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/editcategories',\n                type: 'POST',\n                data: {\n                    parent_id: parentId,\n                    name: name,\n                    level: level,\n                    menu_id: menuId\n                },\n                success: function () {\n                    reloadCategories();\n                },\n                error: function () {\n                    alert('Ocurri\u00f3 un error al guardar la subcategor\u00eda');\n                }\n            });\n        });\n\n\n        $('#categories-wrapper').on('click', '.btn-delete', function (e) {\n            const id = $(this).data('id');\n            if (confirm('\u00bfEst\u00e1s seguro que deseas eliminar esta categor\u00eda?')) {\n                $.ajax({\n                    url: window.location.origin + '/menudigital/ajax/deletecategory',\n                    type: 'POST',\n                    showLoader: true,\n                    data: { id: id },\n                    success: function (res) {\n                        if (res.success) {\n                            reloadCategories();\n                        } else {\n                            alert(res.message || 'No se pudo eliminar');\n                        }\n                    },\n                    error: function () {\n                        alert('Error inesperado al eliminar');\n                    }\n                });\n            }\n        });\n\n        $(document).on('submit', '#category-form', function (e) {\n            e.preventDefault();\n        });\n\n        $('#categories-wrapper').on('click', '.btn-save-categories', function (e) {\n            e.preventDefault();\n\n            let hayError = false;\n\n            // Limpiar errores previos\n            $('#category-form .input-text').removeClass('campo-error');\n            $('#category-form .mensaje-error').remove();\n\n            $('#category-form .input-text').each(function () {\n                const valor = $(this).val().trim();\n                const maxCaracteres = 30;\n\n                if (valor.length > maxCaracteres) {\n                    hayError = true;\n                    $(this).addClass('campo-error');\n                    $(this).after('<div class=\"mensaje-error\">M\u00e1ximo 30 caracteres permitidos.</div>');\n                }\n            });\n\n            if (hayError) {\n                // Opcional: hacer scroll al primer error\n                $('html, body').animate({\n                    scrollTop: $('.campo-error').first().offset().top - 100\n                }, 500);\n                return;\n            }\n\n            let menuId = $('#menu-id').val();\n            $('#category-form').append('<input type=\"hidden\" value=\"'+menuId+'\" name=\"menu_id\">');\n            var form = $('#category-form')[0];\n            var formData = new FormData(form);\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savecategories',\n                method: 'POST',\n                data: formData,\n                processData: false,\n                contentType: false,\n                showLoader: true,\n                success: function (response) {\n                    if (response.success) {\n                        reloadCategories();\n                    } else {\n                        console.warn('Hubo un problema al guardar:', response.message || response);\n                    }\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error en el guardado AJAX:', error);\n                }\n            });\n        });\n\n        function reloadCategories(){\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/categories',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    // Crea un contenedor temporal para poder manipular el DOM recibido\n                    const tempDiv = $('<div>').html(response);\n\n                    // Encuentra el div espec\u00edfico dentro de ese contenido\n                    const newContent = tempDiv.find('.container-categories.container-block');\n\n                    // Reemplaza el contenido en el DOM actual\n                    $('.container-categories.container-block').replaceWith(newContent);\n                    $('.container-categories.container-block').show();\n                    $('.wrapper-list-categories').show();\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n        };\n\n        $(document).on('click', '.category-card .edit-cancel', function () {\n            var $categoryCard = $(this).closest('.category-card');\n            var $btnEdit = $categoryCard.find('.btn-edit').first();\n            $btnEdit.trigger('click');\n        });\n\n        $(document).on('click', '.category-card .edit-cancel-sub-cat', function () {\n            var $categoryCard = $(this).closest('.category-card');\n            var $btnEdit = $categoryCard.find('.btn-add-sub').first();\n            $btnEdit.trigger('click');\n        });\n\n\n        /*ELIMNAR PRODUCTOS DEL GRID*/\n        $(document).on('click', '.action-delete', function (e) {\n            e.preventDefault();\n\n            const row = $(this).closest('tr');\n            const productId = row.data('id') || row.find('[data-id]').data('id');\n\n            if (!productId) {\n                alert('ID de producto no encontrado.');\n                return;\n            }\n\n            if (!confirm('\u00bfEst\u00e1s seguro que deseas eliminar este producto?')) {\n                return;\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/deleteproduct',\n                type: 'POST',\n                showLoader: true,\n                data: { id: productId },\n                success: function (res) {\n                    if (res.success) {\n                        row.fadeOut(300, function () { $(this).remove(); });\n                    } else {\n                        alert(res.message || 'Error al eliminar.');\n                    }\n                },\n                error: function () {\n                    alert('Error de conexi\u00f3n al eliminar producto.');\n                }\n            });\n        });\n\n        /* Editar productos creados */\n        $(document).on('click', '.action-edit', function (e) {\n            e.preventDefault();\n            const row = $(this).closest('tr');\n            console.log(row.find('td'));\n            const id = row.data('id');\n            const name = row.find('td').eq(2).text().trim();\n            const desc = row.find('td').eq(3).text().trim();\n            const priceText = row.find('td').eq(4).text().trim();\n            const price = priceText.replace(/\\$/g, '');\n            const recommended = row.find('td').eq(5).text().trim() === 'S\u00ed' ? '1' : '0';\n            const imageUrl = row.find('img.product-thumb').attr('src');\n            const categoryJson = JSON.parse(row.attr('data-json') || '{}');\n\n            $('#edit-id').val(id);\n            $('#edit-nombre').val(name);\n            $('#edit-descripcion').val(desc);\n            $('#edit-precio').val(price);\n            $(\"#edit-destacado-si\").prop(\"checked\", recommended === '1');\n            $(\"#edit-destacado-no\").prop(\"checked\", recommended === '0');\n\n            if (imageUrl) {\n                $('.edit-preview-image').attr('src', imageUrl);\n                $('.edit-image-upload-placeholder').hide();\n                $('.edit-image-upload-placeholder-loaded').show();\n            }\n\n            $('#edit-category-selects .col-select').remove();\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/create',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    $('#edit-category-selects .col-select').remove();\n                    let tempDiv = $('<div>').html(response);\n                    let newContent = tempDiv.find('#data-categories');\n                    let categoryData = newContent[0]['attributes']['value']['value'];\n                    let parsedData = JSON.parse(categoryData);\n                    const firstSelect = buildSelectEdit(parsedData);\n                    const container = $(`\n                            <div class=\"col-select form-group\">\n                                <label>Categorias</label>\n                            </div>\n                        `);\n                    container.append(firstSelect);\n                    $('#edit-category-selects').append(container);\n\n                    $('#edit-category-selects').on('change', 'select', function () {\n                        const level = parseInt($(this).data('level'));\n                        renderNextLevelEdit($(this), level);\n                    });\n                    $('.container-edit-product').show();\n                    $('.template-section, .contenedor-principal').hide();\n                    limpiarFormularioProducto();\n                    simulateSelectCascade(categoryJson);\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n\n            $('.container-new-product').hide();\n            $('.container-edit-product').show();\n        });\n\n        function simulateSelectCascade(categoryJson) {\n            const levels = [\"level_1\", \"level_2\", \"level_3\", \"level_4\"];\n\n            levels.forEach(function (level, index) {\n                setTimeout(function () {\n                    const data = categoryJson[level];\n                    if (data && data.id) {\n                        const select = $('#edit-category-selects select[data-level=\"' + (index + 1) + '\"]');\n                        if (select.length) {\n                            select.val(data.id).trigger('change');\n                        }\n                    }\n                }, index * 300);\n            });\n        }\n\n        $('#cancel-edit-product').on('click', function () {\n            $('.container-edit-product').hide();\n            $('.template-section, .contenedor-principal').show();\n        });\n\n        $('#save-edit-product').on('click', function () {\n            const formData = new FormData();\n            formData.append('id', $('#edit-id').val());\n            formData.append('name', $('#edit-nombre').val());\n            formData.append('description', $('#edit-descripcion').val());\n            formData.append('price', $('#edit-precio').val());\n            formData.append('recommended', $('input[name=\"edit-check-product-destacado\"]:checked').val());\n            formData.append('categories', $('#edit-categories-json').val());\n\n            const imageFile = $('#edit-upload-image')[0].files[0];\n            if (imageFile) {\n                formData.append('image', imageFile);\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/editproduct',\n                type: 'POST',\n                data: formData,\n                processData: false,\n                contentType: false,\n                showLoader: true,\n                success: function (res) {\n                    if (res.success) {\n                        $('.container-new-product, .container-edit-product').hide();\n                        $('.template-section, .contenedor-principal').show();\n                        reloadTableProducts();\n                    } else {\n                        alert(res.message || 'Hubo un error al actualizar');\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado');\n                }\n            });\n        });\n\n        /* Personalizaci\u00f3n */\n        $(document).on('click', '.custom-content-color-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-color').toggleClass('rotated');\n            $wrapper.find('.custom-content-color').slideToggle();\n        });\n\n        $(document).on('click', '.custom-content-typography-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-typography').toggleClass('rotated');\n            $wrapper.find('.custom-content-typography').slideToggle();\n        });\n\n        $(document).on('click', '.custom-content-image-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-image').toggleClass('rotated');\n            $wrapper.find('.custom-content-image').slideToggle();\n        });\n\n        /* Templates */\n\n        const selectedValue = $('input[name=\"check-template\"]:checked').val();\n        $('.get-check-template-saved').val(selectedValue);\n\n        $('.menu-actions-options-template .template-cancel').on('click', function() {\n            $('input[name=\"check-template\"]').prop('checked', false);\n            const savedValue = $('.get-check-template-saved').val();\n            $('input[name=\"check-template\"][value=\"' + savedValue + '\"]').prop('checked', true);\n        });\n\n        $('.menu-actions-options-template .template-save').on('click', function() {\n\n            var formData = new FormData();\n            const menuId = $('#menu-id').val();\n\n            formData.append('menu_id', menuId);\n            formData.append('template', $('input[name=\"check-template\"]:checked').val());\n            $('.get-check-template-saved').val($('input[name=\"check-template\"]:checked').val());\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savetemplate',\n                type: 'POST',\n                data: formData,\n                processData: false,\n                contentType: false,\n                showLoader: true,\n                success: function (res) {\n                    if (res.success) {\n                        alert(res.message || 'Plantilla guardada correctamente.');\n                    } else {\n                        alert(res.message || 'Error al guardar el la plantilla.');\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado al guardar QR.');\n                }\n            });\n\n        });\n\n        /* Personalizaci\u00f3n */\n\n        document.querySelectorAll('.color-picker').forEach(function(colorPicker) {\n            colorPicker.addEventListener('input', function() {\n                const selectedColor = this.value;\n\n\n                const card = this.closest('.color-card');\n\n\n                const colorCode = card.querySelector('.color-code');\n                colorCode.value = selectedColor;\n\n                this.style.backgroundColor = selectedColor;\n            });\n        });\n\n        $('.color-refresh-icon').on('click', function () {\n            const newColor = $(this).data('color-id');\n            const parentCard = $(this).closest('.color-card');\n            const colorInput = parentCard.find('.color-picker');\n            const colorDiv = parentCard.find('.color-code');\n            colorInput.val(newColor).trigger('input');\n            colorDiv.val(newColor);\n        });\n\n\n        $(document).on('click', '.custom-icon-visibility', function () {\n            let $div = $('.custom-image-upload-placeholder-head-loaded');\n            if ($div.find('img').length > 0) {\n                $('.custom-image-upload-placeholder-head-loaded').slideToggle();\n            } else {\n                $('.custom-image-upload-placeholder-head').slideToggle();\n            }\n        });\n\n        $('.banner-button-upload').on('click', function () {\n            $('#custom-banner-upload').trigger('click');\n        });\n\n        $('#custom-banner-upload').on('change', function (event) {\n            const file = event.target.files[0];\n            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];\n            const maxSize = 2 * 1024 * 1024; // 2MB\n            if (!allowedTypes.includes(file.type) || file.size > maxSize) {\n                alert(\"Lo sentimos, solo se permiten im\u00e1genes en formato JPG, JPEG y PNG menores a 2 MB\");\n                return;\n            }\n\n            if (file && file.type.startsWith('image/')) {\n                const reader = new FileReader();\n\n                reader.onload = function (e) {\n                    $('.custom-image-upload-placeholder-head').hide();\n                    $('.custom-image-upload-placeholder-head-loaded').show();\n                    $('.custom-img-banner').remove();\n                    $('.custom-image-upload-placeholder-head-loaded').append(`\n                      <img class=\"custom-img-banner\" src=\"${e.target.result}\" alt=\"Vista previa\"/>\n                    `);\n                };\n\n                reader.readAsDataURL(file);\n            } else {\n                alert('Por favor selecciona una imagen v\u00e1lida.');\n            }\n        });\n\n        $('.banner-button-delete').on('click', function () {\n            let $div = $('.custom-image-upload-placeholder-head-loaded');\n            if ($div.find('img').length > 0) {\n                $('.custom-image-upload-placeholder-head-loaded').find('img').remove();\n                $('.custom-image-upload-placeholder-head-loaded').slideToggle();\n            }\n        });\n\n\n        $('.logo-button-upload').on('click', function () {\n            $('#custom-logo-upload').trigger('click');\n        });\n\n        $('#custom-logo-upload').on('change', function (event) {\n            const file = event.target.files[0];\n            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];\n            const maxSize = 2 * 1024 * 1024; // 2MB\n            if (!allowedTypes.includes(file.type) || file.size > maxSize) {\n                alert(\"Lo sentimos, solo se permiten im\u00e1genes en formato JPG, JPEG y PNG menores a 2 MB\");\n                return;\n            }\n\n            if (file && file.type.startsWith('image/')) {\n                const reader = new FileReader();\n\n                reader.onload = function (e) {\n                    $('.custom-image-upload-placeholder-head').hide();\n                    $('.custom-image-upload-placeholder-head-loaded').show();\n                    $('.custom-img-logo').remove();\n                    $('.custom-image-upload-placeholder-loaded').append(`\n                      <img class=\"custom-img-logo\" src=\"${e.target.result}\" alt=\"Vista previa\"/>\n                    `);\n                };\n\n                reader.readAsDataURL(file);\n            } else {\n                alert('Por favor selecciona una imagen v\u00e1lida.');\n            }\n        });\n\n        $('.logo-button-delete').on('click', function () {\n            $('.custom-img-logo').remove();\n        });\n\n        function getColorSettingsJson() {\n            const colorSettings = {\n                principal: $('.color-principal').val(),\n                texto_principal: $('.color-texto-principal').val(),\n                secundario: $('.color-secundario').val(),\n                texto_secundario: $('.color-texto-secundario').val(),\n                fondo: $('.color-fondo').val(),\n                resalto: $('.color-resalto').val()\n            };\n\n            return JSON.stringify(colorSettings);\n        }\n\n        $('.codeInputColor').on('input', function () {\n            const hex = $(this).val().trim();\n\n            // Validar si es un c\u00f3digo hexadecimal v\u00e1lido (como #fff o #ffffff)\n            const isValidHex = /^#([0-9A-Fa-f]{3}){1,2}$/.test(hex);\n\n            if (isValidHex) {\n                const colorCard = $(this).closest('.color-card');\n                const colorPicker = colorCard.find('.color-picker');\n                colorPicker.val(hex);\n                colorPicker.css('background-color', hex);\n            }\n        });\n\n        function getFontsSettingsJson() {\n            const titleFontValue = $('input[name=\"check-font-title\"]:checked').val();\n            const bodyFontValue = $('input[name=\"check-font-body\"]:checked').val();\n\n            const fontsSettings = {\n                title_font: titleFontValue,\n                body_font: bodyFontValue\n            };\n\n            return JSON.stringify(fontsSettings);\n        }\n\n\n        $('.custom-option-save').on('click', function () {\n            const bannerFile = $('#custom-banner-upload')[0].files[0];\n            const bannerImg = $('.custom-img-banner').length;\n\n            if (!bannerFile && !bannerImg) {\n                alert('Debes seleccionar una imagen para el banner antes de guardar.');\n                return;\n            }\n\n            const formData = new FormData();\n            formData.append('menu_id', $('#menu-id').val());\n            formData.append('color_settings', getColorSettingsJson());\n            formData.append('fonts_settings', getFontsSettingsJson());\n\n            const logoFile = $('#custom-logo-upload')[0].files[0];\n\n            if (bannerFile) {\n                formData.append('banner_header', bannerFile);\n            }\n\n            if (logoFile) {\n                formData.append('logo_header', logoFile);\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savecustomization',\n                type: 'POST',\n                data: formData,\n                contentType: false,\n                processData: false,\n                success: function (res) {\n                    if (res.success) {\n                        alert('\u00a1Guardado exitosamente!');\n                    } else {\n                        alert('Error: ' + res.message);\n                    }\n                }\n            });\n        });\n\n        $('.info-text-color, .info-icon-color').on('click', function () {\n            let color_type = $(this).data('color-type');\n            let color_desc = $(this).data('color-desc');\n            let video_url = $('#path_video').val()+\"/\"+$(this).data('video-url');\n            loadVideo(video_url);\n\n            $('.customization-color-badge-text').html(color_type);\n            $('.customization-color-description').html(color_desc);\n            $('.customization-color-modal-overlay').fadeIn();\n        });\n\n        $('.customization-color-modal-overlay').on('click', function (e) {\n            if ($(e.target).is('.customization-color-modal-overlay')) {\n                $(this).fadeOut();\n            }\n        });\n\n        $('.customization-color-title, .customization-color-icon-box').on('click', function (e) {\n            $('.customization-color-modal-overlay').fadeOut();\n        });\n\n        function loadVideo(videoUrl) {\n            const videoHtml = `\n                <video width=\"100%\" height=\"auto\" controls autoplay>\n                    <source src=\"${videoUrl}\" type=\"video/mp4\">\n                    Tu navegador no soporta el video.\n                </video>\n            `;\n            $('.customization-color-preview-box').html(videoHtml);\n        }\n\n\n        /* QR FORM */\n        $('.btn-save-qr').on('click', function (e) {\n            e.preventDefault();\n\n            var formData = new FormData();\n            const menuId = $('#qr-menu-id').val();\n\n            formData.append('menu_id', menuId);\n            formData.append('qr_title', $('input[name=\"qr_title\"]').val());\n            formData.append('qr_description', $('input[name=\"qr_description\"]').val());\n\n            var logoSelected = $('input[name=\"qr_add_logo\"]:checked').val();\n            formData.append('qr_add_logo', logoSelected ? logoSelected : '0');\n\n            var imageInput = $('#upload-image')[0];\n            if (imageInput && imageInput.files.length > 0) {\n                formData.append('qr_image', imageInput.files[0]);\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/saveqr',\n                type: 'POST',\n                data: formData,\n                processData: false,\n                contentType: false,\n                showLoader: true,\n                success: function (res) {\n                    if (res.success) {\n                        reloadQrContent(menuId);\n                        alert(res.message || 'QR guardado correctamente.');\n                    } else {\n                        alert(res.message || 'Error al guardar el QR.');\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado al guardar QR.');\n                }\n            });\n        });\n\n        function reloadQrContent(id){\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/qr/id/'+id,\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    const tempDiv = $('<div>').html(response);\n                    const newContent = tempDiv.find('.qr-menu-container');\n                    $('.qr-menu-container').replaceWith(newContent);\n                    $('html, body').animate({ scrollTop: 0 }, 'slow');\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar contenido del QR:', error);\n                }\n            });\n        };\n\n        /* PREVIEW */\n\n        let path = [];\n\n        function reloadPreview(){\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/preview',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    // Crea un contenedor temporal para poder manipular el DOM recibido\n                    const tempDiv = $('<div>').html(response);\n\n                    // Encuentra el div espec\u00edfico dentro de ese contenido\n                    const newContent = tempDiv.find('.container-preview.container-block');\n\n                    // Reemplaza el contenido en el DOM actual\n                    $('.container-preview.container-block').replaceWith(newContent);\n                    $('.container-preview.container-block').show();\n                    renderCurrentLevel();\n\n                    if (window.location.pathname.includes('/menudigital/index/view')) {\n                        if( $('#is_menu_enable').val() === '0' ){\n                            $('.container-preview').hide();\n                            $('.content-menu-disabled').show();\n                        }\n                    }\n\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n        };\n\n        $(document).on('click', '.menu-complete-button', function () {\n            renderCurrentLevel();\n            $('#back-button-text').html(`<strong>Men\u00fa Completo</strong>`);\n            $('.menu-complete-button, .preview-recommendations').hide();\n            $('#category-container, #back-button-container').show();\n        });\n\n        $(document).on('click', '.category-button', function () {\n            const key = $(this).data('name');\n            if(key === 'menu_complete'){\n                return;\n            }\n            path.push(key);\n            renderCurrentLevel();\n        });\n\n        $(document).on('click', '#back-button-container', function () {\n            let level = $('#back-button-text').attr('data-level');\n            if(level === 'start'){\n                $('#category-container, #back-button-container').hide();\n                $('.menu-complete-button, .preview-recommendations').show();\n            }\n            path.pop();\n            renderCurrentLevel();\n        });\n\n        function renderCurrentLevel() {\n            let fullTree = JSON.parse($('#getCategoryTree').val());\n            let $container = $('#category-container');\n            $container.empty();\n\n            let branch = fullTree;\n            for (const level of path) {\n                if (branch && typeof branch === 'object') {\n                    branch = branch[level];\n                }\n            }\n\n            const subcategories = [];\n            const products = [];\n\n            if (branch && typeof branch === 'object') {\n                for (const key in branch) {\n                    const value = branch[key];\n\n                    // Si es un producto individual (como \"0\")\n                    if (typeof value === 'object' && value.hasOwnProperty('item_id')) {\n                        products.push(value);\n                    }\n                    // Si es un array de productos\n                    else if (Array.isArray(value) && value.length > 0 && value[0].hasOwnProperty('item_id')) {\n                        // Guardar el nombre del array como subcategor\u00eda\n                        subcategories.push(key);\n                    }\n                    // Si es un objeto que puede contener m\u00e1s subcategor\u00edas o productos\n                    else if (typeof value === 'object') {\n                        subcategories.push(key);\n                    }\n                }\n            }\n\n            // Mostrar subcategor\u00edas primero\n            const titleFont = $('#menu_title_font').val();\n            const bodyFont = $('#menu_body_font').val();\n            const fondoPrincipal = $('#menu_fondo_principal').val();\n            const fondoSecundario = $('#menu_fondo_secundario').val();\n            const textoPrincipal = $('#menu_texto_principal').val();\n            const textoSecundario = $('#menu_texto_secundario').val();\n            const path_media = $('#path_image').val();\n            const resalto = $('#menu_resalto').val();\n            const borderRadius = $('#get_border_radius').val();\n            subcategories.forEach(key => {\n                const $btn = $(`\n                    <div class=\"category-button\" style=\"background:${fondoSecundario}; border-radius: ${borderRadius}\" data-name=\"${key}\"><span style=\"color:${textoSecundario};font-family: '${titleFont}', sans-serif\">${key}</span></div>\n                `);\n                $container.append($btn);\n            });\n\n            // Mostrar productos directamente en este nivel\n            const template = $('#get_template').val();\n            if(template === 'round_style'){\n                $container.css('width','400px');\n                products.forEach(product => {\n                    const maxChars = 136;\n                    let description = product.description || '';\n                    let shortDescription = description.length > maxChars\n                        ? description.substring(0, maxChars) + ' ...'\n                        : description;\n                    const badge = product.recommended === '1' ? `<span class=\"list-preview-badge\" style=\"color:${textoPrincipal};font-family: '${titleFont}', sans-serif; background: ${resalto}\">Producto Destacado</span>` : '';\n                    const $card = $(`\n                    <div class=\"list-preview-wrapper\"\n                            data-name=\"${product.name}\"\n                            data-price=\"${product.price}\"\n                            data-description=\"${shortDescription}\"\n                            data-image=\"${product.image}\"\n                            data-recommended=\"${product.recommended}\">\n                        <div class=\"list-preview-container list-preview-container_round_style\" style=\"background:${fondoPrincipal}\">\n                            ${badge}\n                            <img class=\"list-preview-img\" src=\"${path_media+product.image}\" alt=\"${product.name}\" />\n                            <div class=\"list-preview-content\">\n                                <h3 class=\"list-preview-title\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">${product.name}</h3>\n                                <p class=\"list-preview-description\" style=\"color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif\">${shortDescription}</p>\n                                <div class=\"list-preview-price\">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>\n                            </div>\n                        </div>\n                    </div>\n                `);\n                    $container.append($card);\n                });\n            }else if(template === 'vertical_round_style'){\n                let groupContainer = null;\n                let badge = '';\n                products.forEach((product, index) => {\n                    const maxChars = 136;\n                    let description = product.description || '';\n                    let shortDescription = description.length > maxChars\n                        ? description.substring(0, maxChars) + ' ...'\n                        : description;\n                    // Crear un nuevo grupo cada 2 elementos\n                    if (index % 2 === 0) {\n                        groupContainer = $('<div class=\"vertical_round_style-container\"></div>');\n                        $container.append(groupContainer); // $container es tu contenedor principal\n                    }\n\n\n                    if(product.recommended === '1'){\n                        badge = `<div class=\"vertical_round_style-badge-wrapper\" style=\"background:${resalto}\">\n                                    <div class=\"vertical_round_style-detail-product-badge-icon\">\n                                        <svg width=\"15\" height=\"16\" viewBox=\"0 0 15 16\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n                                            <g id=\"Star\">\n                                                <g id=\"Group\">\n                                                    <path id=\"Vector\" d=\"M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z\" fill=\"${textoPrincipal}\"/>\n                                                </g>\n                                            </g>\n                                        </svg>\n                                    </div>\n                                    <div class=\"vertical_round_style-badge\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">Producto Destacado</div>\n                                </div>`;\n                    }else{\n                        badge = '';\n                    }\n\n                    const $card = $(`\n                        <div class=\"vertical_round_style-card\"\n                                data-name=\"${product.name}\"\n                                data-price=\"${product.price}\"\n                                data-description=\"${shortDescription}\"\n                                data-image=\"${product.image}\"\n                                data-recommended=\"${product.recommended}\" style=\"background: ${fondoPrincipal}\">\n                            <div class=\"vertical_round_style-image\"><img src=\"${path_media+product.image}\" /></div>\n                            ${badge}\n                            <h3 class=\"vertical_round_style-title\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">${product.name}</h3>\n                            <p class=\"vertical_round_style-description\" style=\"color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif\">${shortDescription}</p>\n                            <div class=\"vertical_round_style-price\" style=\"background: ${fondoSecundario};color:${titleFont};font-family: '${titleFont}', sans-serif\">\n                                ${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN\n                            </div>\n                        </div>\n                    `);\n\n                    groupContainer.append($card);\n                });\n\n            }else if(template === 'straight_style'){\n                products.forEach(product => {\n                    const maxChars = 96;\n                    let description = product.description || '';\n                    let shortDescription = description.length > maxChars\n                        ? description.substring(0, maxChars) + ' ...'\n                        : description;\n                    let badge = '';\n                    if(product.recommended === '1'){\n                        badge = `<div class=\"straight_style-highlight\">\n                                        <span class=\"straight_style-star\">\n                                            <svg width=\"15\" height=\"16\" viewBox=\"0 0 15 16\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n                                                <g id=\"Star\">\n                                                    <g id=\"Group\">\n                                                        <path id=\"Vector\" d=\"M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z\" fill=\"${textoPrincipal}\"/>\n                                                    </g>\n                                                </g>\n                                            </svg>\n                                        </span>\n                                        <span class=\"straight_style-label\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">Producto Destacado</span>\n                                    </div>`;\n                    }else{\n                        badge = '';\n                    }\n                    const $card = $(`\n                    <div class=\"straight_style-card\"\n                            data-name=\"${product.name}\"\n                            data-price=\"${product.price}\"\n                            data-description=\"${shortDescription}\"\n                            data-image=\"${product.image}\"\n                            data-recommended=\"${product.recommended}\" style=\"background: ${fondoPrincipal}\">\n                        <div class=\"straight_style-header\">\n                            <h3 class=\"straight_style-title\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">${product.name}</h3>\n                            <div class=\"straight_style-image-placeholder\">\n                                <img src=\"${path_media+product.image}\" alt=\"${product.name}\">\n                            </div>\n                        </div>\n                        <div class=\"straight_style-body\">\n                            <div class=\"straight_style-info-wrapper\">\n                                <div class=\"straight_style-left\">\n                                    ${badge}\n                                    <div class=\"straight_style-price\" style=\"color:${textoPrincipal};font-family: '${titleFont}', sans-serif\">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>\n                                </div>\n                                <div class=\"straight_style-description\" style=\"color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif\">${shortDescription}</div>\n                            </div>\n                        </div>\n                    </div>\n                `);\n                    $container.append($card);\n                });\n            }else if(template === 'vertical_straight_style'){\n                products.forEach(product => {\n                    const maxChars = 136;\n                    let description = product.description || '';\n                    let shortDescription = description.length > maxChars\n                        ? description.substring(0, maxChars) + ' ...'\n                        : description;\n                    let badge = '';\n                    if(product.recommended === '1'){\n                        badge = `<div class=\"vertical_straight_style-highlight\">\n                                        <span class=\"vertical_straight_style-star\">\n                                            <svg width=\"15\" height=\"16\" viewBox=\"0 0 15 16\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n                                                <g id=\"Star\">\n                                                    <g id=\"Group\">\n                                                        <path id=\"Vector\" d=\"M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z\" fill=\"${textoPrincipal}\"/>\n                                                    </g>\n                                                </g>\n                                            </svg>\n                                        </span>\n                                        <span class=\"vertical_straight_style-label\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">Producto Destacado</span>\n                                    </div>`;\n                    }else{\n                        badge = '';\n                    }\n                    const $card = $(`\n                    <div class=\"vertical_straight_style-card\"\n                            data-name=\"${product.name}\"\n                            data-price=\"${product.price}\"\n                            data-description=\"${shortDescription}\"\n                            data-image=\"${product.image}\"\n                            data-recommended=\"${product.recommended}\" style=\"background: ${fondoPrincipal}\">\n                        <h3 class=\"vertical_straight_style-title\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">${product.name}</h3>\n\n                        <div class=\"vertical_straight_style-image-placeholder\">\n                            <img src=\"${path_media+product.image}\" alt=\"${product.name}\">\n                        </div>\n                        <p class=\"vertical_straight_style-description\" style=\"color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif\">${shortDescription}</p>\n                        <div class=\"vertical_straight_style-footer\">\n                            <div class=\"vertical_straight_style-price\" style=\"color:${textoPrincipal};font-family: '${titleFont}', sans-serif\">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>\n                            ${badge}\n                        </div>\n                    </div>\n                `);\n                    $container.append($card);\n                });\n            }\n\n\n\n            // Mostrar u ocultar bot\u00f3n regresar\n            if (path.length > 0) {\n                const titleFont = $('#menu_title_font').val();\n                const textPrincipal = $('#menu_texto_principal').val();\n                const prevName = path[path.length - 1];\n                if($('.category-button').length === 1){\n                    $container.prepend(`<div class=\"title-last-level\"><span style=\"font-family: '${titleFont}', sans-serif; color: ${textPrincipal}\">${prevName}</span></div>`);\n                }\n                $('#back-button-text').html(`<strong style=\"font-family: '${titleFont}', sans-serif\">${prevName}</strong>`);\n                $('#back-button-container').show();\n                $('#back-button-text').attr('data-level', prevName);\n            } else {\n\n                $('#back-button-text').html(`<strong style=\"font-family: '${titleFont}', sans-serif\">Men\u00fa Completo</strong>`);\n                $('#back-button-text').attr('data-level', 'start');\n            }\n\n            if ($('.category-button:visible').length === 0) {\n                const colorSecundario = $('#menu_fondo_secundario').val();\n                if(template === 'round_style' || template === 'vertical_round_style'){\n                    $('#category-container').css('background',colorSecundario);\n                }else{\n                    $('#category-container').css('background','none');\n                }\n\n            }else{\n                $('#category-container').css('background','none');\n            }\n        }\n\n        $(document).on('click', '.list-preview-wrapper, .vertical_round_style-card, .straight_style-card, .vertical_straight_style-card', function () {\n            const path_image = $('#path_image').val();\n            const name = $(this).data('name');\n            const price = parseFloat($(this).data('price')).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });\n            const description = $(this).data('description');\n            const image = path_image+$(this).data('image');\n            const recommended = $(this).data('recommended');\n            const tittle_back_link = $('.text-link-back-page strong').html();\n\n            $('.detail-product-title').html(tittle_back_link);\n            $('.detail-product-image').attr('src',image);\n            $('.detail-product-name').html(name);\n            $('.detail-product-description').html(description);\n            $('.detail-product-price').html(price+' MXN');\n            if(recommended === 1){\n                $('.detail-product-badge').show();\n            }\n            $('.detail-product-wrapper').show();\n            $('.preview-header-section, .preview-footer, #category-container').hide();\n            $('.preview-container').css('background','none');\n\n        });\n\n        $(document).on('click', '.detail-product-icons', function () {\n            const $fondo = $('#menu_fondo').val();\n            $('.preview-container').css('background',$fondo);\n            $('.detail-product-badge, .detail-product-wrapper').hide();\n            $('.preview-header-section, .preview-footer, .preview-recommendations').show();\n            const tittle_back_link = $('.detail-product-title').html();\n            if(tittle_back_link != \"Recomendados\"){\n                $('#category-container').show();\n                $('.preview-recommendations').hide();\n            }\n        });\n\n        $(document).on('click', '.preview-products-recommendations', function () {\n            $('.preview-container').css('background','none');\n            const path_image = $('#path_image').val();\n            const name = $(this).data('name');\n            const price = parseFloat($(this).data('price')).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });\n            const description = $(this).data('description');\n            const image = path_image+$(this).data('image');\n            const recommended = $(this).data('recommended');\n            const tittle_back_link = \"Recomendados\";\n            $('.detail-product-title').html(tittle_back_link);\n            $('.detail-product-image').attr('src',image);\n            $('.detail-product-name').html(name);\n            $('.detail-product-description').html(description);\n            $('.detail-product-price').html(price+' MXN');\n            if(recommended === 1){\n                $('.detail-product-badge').show();\n            }\n            $('.detail-product-wrapper').show();\n            $('.preview-header-section, .preview-footer, #category-container, .preview-recommendations').hide();\n        });\n\n        $(document).on('click', '.preview-footer-copyright', function () {\n            window.location.href = '/';\n        });\n\n        $(document).on('click', '.preview-footer-link', function () {\n            let menuId = $(this).data('link-terms');\n            window.location.href = '/menudigital/index/terminos/id/' + menuId;\n        });\n\n        /* Introduction */\n        $(document).on('click', '.intro-create-menu-digital-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-create-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-create-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-edit-menu-digital-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-edit-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-edit-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-edit-qr-menu-digital-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-edit-qr-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-edit-qr-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-create-cat-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-create-cat-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-create-cat-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-edit-cat-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-edit-cat-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-edit-cat-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-create-articulo-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-create-articulo-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-create-articulo-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-edit-articulo-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-edit-articulo-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-edit-articulo-menu').slideToggle();\n        });\n\n        $(document).on('input', '.validate-price', function () {\n            const $this = $(this);\n            let inputVal = $this.val();\n\n            // Evitar ceros a la izquierda, excepto si el valor empieza con \"0.\" (decimal v\u00e1lido)\n            if (/^0+[1-9]/.test(inputVal)) {\n                inputVal = inputVal.replace(/^0+/, '');\n                $this.val(inputVal);\n            }\n\n            const value = parseFloat(inputVal);\n\n            if (isNaN(value) || value <= 0) {\n                alert(\"El valor del precio debe ser mayor a 0\");\n                $this.val('');\n            }\n        });\n\n\n    });\n});\n","Magento_Shipping/js/view/checkout/shipping/shipping-policy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Shipping/js/model/config'\n\n], function (Component, config) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Shipping/checkout/shipping/shipping-policy'\n        },\n        config: config()\n    });\n});\n","Magento_Shipping/js/model/config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function () {\n        return window.checkoutConfig.shippingPolicy;\n    };\n});\n","Magento_Translation/js/add-class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Multishipping/js/multi-shipping-balance.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/dataPost',\n    'jquery-ui-modules/widget'\n], function ($, dataPost) {\n    'use strict';\n\n    $.widget('mage.multiShippingBalance', {\n        options: {\n            changeUrl: ''\n        },\n\n        /**\n         * Initialize balance checkbox events.\n         *\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(function (event) {\n                dataPost().postData({\n                    action: this.options.changeUrl,\n                    data: {\n                        useBalance: +$(event.target).is(':checked')\n                    }\n                });\n            }, this));\n        }\n    });\n\n    return $.mage.multiShippingBalance;\n});\n","Magento_Multishipping/js/payment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.payment', {\n        options: {\n            continueSelector: '#payment-continue',\n            methodsContainer: '#payment-methods',\n            minBalance: 0,\n            tmpl: '<input id=\"hidden-free\" type=\"hidden\" name=\"payment[method]\" value=\"free\">'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.element.find('dd [name^=\"payment[\"]').prop('disabled', true).end()\n                .on('click', this.options.continueSelector, $.proxy(this._submitHandler, this))\n                .on('updateCheckoutPrice', $.proxy(function (event, data) {\n                    //updating the checkoutPrice\n                    if (data.price) {\n                        this.options.checkoutPrice += data.price;\n                    }\n\n                    //updating total price\n                    if (data.totalPrice) {\n                        data.totalPrice = this.options.checkoutPrice;\n                    }\n\n                    if (this.options.checkoutPrice <= this.options.minBalance) {\n                        // Add free input field, hide and disable unchecked\n                        // checkbox payment method and all radio button payment methods\n                        this._disablePaymentMethods();\n                    } else {\n                        // Remove free input field, show all payment method\n                        this._enablePaymentMethods();\n                    }\n                }, this))\n                .on('click', 'dt input:radio', $.proxy(this._paymentMethodHandler, this));\n\n            if (this.options.checkoutPrice < this.options.minBalance) {\n                this._disablePaymentMethods();\n            } else {\n                this._enablePaymentMethods();\n            }\n        },\n\n        /**\n         * Display payment details when payment method radio button is checked\n         * @private\n         * @param {EventObject} e\n         */\n        _paymentMethodHandler: function (e) {\n            var element = $(e.target),\n                parentsDl = element.closest('dl');\n\n            parentsDl.find('dt input:radio').prop('checked', false);\n            parentsDl.find('dd').addClass('no-display').end()\n                .find('.items').hide()\n                .find('[name^=\"payment[\"]').prop('disabled', true);\n            element.prop('checked', true).parent()\n                .next('dd').removeClass('no-display')\n                .find('.items').show().find('[name^=\"payment[\"]').prop('disabled', false);\n        },\n\n        /**\n         * make sure one payment method is selected\n         * @private\n         * @return {Boolean}\n         */\n        _validatePaymentMethod: function () {\n            var methods = this.element.find('[name^=\"payment[\"]'),\n                isValid = false;\n\n            if (methods.length === 0) {\n                alert({\n                    content: $.mage.__('We can\\'t complete your order because you don\\'t have a payment method set up.')\n                });\n            } else if (this.options.checkoutPrice <= this.options.minBalance) {\n                isValid = true;\n            } else if (methods.filter('input:radio:checked').length) {\n                isValid = true;\n            } else {\n                alert({\n                    content: $.mage.__('Please choose a payment method.')\n                });\n            }\n\n            return isValid;\n        },\n\n        /**\n         * Disable and enable payment methods\n         * @private\n         */\n        _disablePaymentMethods: function () {\n            var tmpl = mageTemplate(this.options.tmpl, {\n                data: {}\n            });\n\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', true).end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', true).parent().hide();\n            this.element.find('[name=\"payment[method]\"][value=\"free\"]').parent('dt').remove();\n            this.element.find(this.options.methodsContainer).hide().find('[name^=\"payment[\"]').prop('disabled', true);\n\n            $(tmpl).appendTo(this.element);\n        },\n\n        /**\n         * Enable and enable payment methods\n         * @private\n         */\n        _enablePaymentMethods: function () {\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', false).end()\n                .find('dt input:radio:checked').trigger('click').end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', false).parent().show();\n            this.element.find(this.options.methodsContainer).show();\n        },\n\n        /**\n         * Returns checked payment method.\n         *\n         * @private\n         */\n        _getSelectedPaymentMethod: function () {\n            return this.element.find('input[name=\\'payment[method]\\']:checked');\n        },\n\n        /**\n         * Validate  before form submit\n         * @private\n         * @param {EventObject} e\n         */\n        _submitHandler: function (e) {\n            var currentMethod,\n                submitButton;\n\n            e.preventDefault();\n\n            if (this._validatePaymentMethod()) {\n                currentMethod = this._getSelectedPaymentMethod();\n                submitButton = currentMethod.parent().next('dd').find('button[type=submit]');\n\n                if (submitButton.length) {\n                    submitButton.first().trigger('click');\n                } else {\n                    this.element.trigger('submit');\n                }\n            }\n        }\n    });\n\n    return $.mage.payment;\n});\n","Magento_Multishipping/js/multi-shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'jquery-ui-modules/widget'\n], function ($, customerData) {\n    'use strict';\n\n    $.widget('mage.multiShipping', {\n        options: {\n            itemsQty: 0,\n            addNewAddressBtn: 'button[data-role=\"add-new-address\"]', // Add a new multishipping address.\n            addNewAddressFlag: '#add_new_address_flag', // Hidden input field with value 0 or 1.\n            canContinueBtn: 'button[data-role=\"can-continue\"]', // Continue (update quantity or go to shipping).\n            canContinueFlag: '#can_continue_flag' // Hidden input field with value 0 or 1.\n        },\n\n        /**\n         * Bind event handlers to click events for corresponding buttons.\n         * @private\n         */\n        _create: function () {\n            this._prepareCartData();\n            $(this.options.addNewAddressBtn).on('click', $.proxy(this._addNewAddress, this));\n            $(this.options.canContinueBtn).on('click', $.proxy(this._canContinue, this));\n        },\n\n        /**\n         * Takes cart items qty from current cart data and compare it with current items qty\n         * Reloads cart data if cart items qty is wrong\n         * @private\n         */\n        _prepareCartData: function () {\n            var cartData = customerData.get('cart');\n\n            if (cartData()['summary_count'] !== this.options.itemsQty) {\n                customerData.reload(['cart'], false);\n            }\n        },\n\n        /**\n         * Add a new address. Set the hidden input field and submit the form. Then enter a new shipping address.\n         * @private\n         */\n        _addNewAddress: function () {\n            $(this.options.addNewAddressFlag).val(1);\n            this.element.submit();\n        },\n\n        /**\n         * Can the user continue to the next step? The data-flag attribute holds either 0 (no) or 1 (yes).\n         * @private\n         * @param {Event} event - Click event on the corresponding button.\n         */\n        _canContinue: function (event) {\n            $(this.options.canContinueFlag).val(parseInt($(event.currentTarget).data('flag'), 10));\n        }\n    });\n\n    return $.mage.multiShipping;\n});\n","Magento_Multishipping/js/overview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.orderOverview', {\n        options: {\n            opacity: 0.5, // CSS opacity for the 'Place Order' button when it's clicked and then disabled.\n            pleaseWaitLoader: 'span.please-wait', // 'Submitting order information...' Ajax loader.\n            placeOrderSubmit: 'button[type=\"submit\"]', // The 'Place Order' button.\n            agreements: '.checkout-agreements' // Container for all of the checkout agreements and terms/conditions\n        },\n\n        /**\n         * Bind a submit handler to the form.\n         * @private\n         */\n        _create: function () {\n            this.element.on('submit', $.proxy(this._showLoader, this));\n        },\n\n        /**\n         * Verify that all agreements and terms/conditions are checked. Show the Ajax loader. Disable\n         * the submit button (i.e. Place Order).\n         * @return {Boolean}\n         * @private\n         */\n        _showLoader: function () {\n            if ($(this.options.agreements).find('input[type=\"checkbox\"]:not(:checked)').length > 0) {\n                return false;\n            }\n            this.element.find(this.options.pleaseWaitLoader).show().end()\n                .find(this.options.placeOrderSubmit).prop('disabled', true).css('opacity', this.options.opacity);\n\n            return true;\n        }\n    });\n\n    return $.mage.orderOverview;\n});\n","Magento_LoginAsCustomerFrontendUi/js/login.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/section-config'\n], function ($, customerData, sectionConfig) {\n\n    'use strict';\n\n    return function (config) {\n        customerData.reload(sectionConfig.getSectionNames()).done(function () {\n            window.location.href = config.redirectUrl;\n        });\n    };\n});\n","Magento_LoginAsCustomerFrontendUi/js/view/loginAsCustomer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'mage/translate'\n], function ($, _, Component, customer) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            isVisible: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var customerData, loggedAsCustomerData;\n\n            this._super();\n\n            customerData = customer.get('customer');\n            loggedAsCustomerData = customer.get('loggedAsCustomer');\n\n            customerData.subscribe(function (data) {\n                this.fullname = data.fullname;\n                this.updateBanner();\n            }.bind(this));\n            loggedAsCustomerData.subscribe(function (data) {\n                this.adminUserId = data.adminUserId;\n                this.websiteName = data.websiteName;\n                this.updateBanner();\n            }.bind(this));\n\n            this.fullname = customerData().fullname;\n            this.adminUserId = loggedAsCustomerData().adminUserId;\n            this.websiteName = loggedAsCustomerData().websiteName;\n\n            this.updateBanner();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe(['isVisible', 'notificationText']);\n\n            return this;\n        },\n\n        /**\n         * Update banner area\n         *\n         * @returns void\n         */\n        updateBanner: function () {\n            if (this.adminUserId !== undefined) {\n                this.isVisible(this.adminUserId);\n            }\n\n            if (this.fullname !== undefined && this.websiteName !== undefined) {\n                this.notificationText($.mage.__('You are connected as <strong>%1</strong> on %2')\n                    .replace('%1', _.escape(this.fullname))\n                    .replace('%2', _.escape(this.websiteName)));\n            }\n        }\n    });\n});\n","Threedadv_Hostess/js/reservation-actions.js":"require(['jquery', 'mage/translate'], function ($, $t) {\n    $(document).ready(function () {\n        $(document).on('click', '#slot_time', function () {\n            $(this).attr('step', '900'); // 900 segundos = 15 minutos\n            });\n        // $(document).on('click', '#slot_time', function () {\n        //     let timeValue = $(this).val();\n        //     let [hours, minutes] = timeValue.split(\":\").map(Number);\n        //\n        //     // Redondear minutos a los valores permitidos (00, 15, 30, 45)\n        //     minutes = Math.floor(minutes / 15) * 15;\n        //\n        //     // Asegurar que la hora no pase de 12 y convertir a formato 12 horas\n        //     let period = hours >= 12 ? \"PM\" : \"AM\";\n        //     hours = hours % 12 || 12; // Convertir 0 a 12 para formato 12 horas\n        //\n        //     // Formatear la hora con ceros a la izquierda si es necesario\n        //     let formattedTime = `${String(hours).padStart(2, \"0\")}:${String(minutes).padStart(2, \"0\")}`;\n        //     $(this).val(formattedTime);\n        // });\n        // Obtener par\u00e1metros de la URL\n        var urlParams = new URLSearchParams(window.location.search);\n\n        // Verificar si el par\u00e1metro 'action' tiene el valor 'newReservation'\n        if (urlParams.get('action') === 'newReservation') {\n            var checkExist = setInterval(function () {\n                if ($('#create_reservation').length) {\n                    clearInterval(checkExist); // Detiene el intervalo una vez encontrado\n                    $('#create_reservation').trigger('click');\n                }\n            }, 500); // Revisa cada 500ms si el bot\u00f3n existe\n        }\n\n        $('.filter_button#filter_by_today').addClass('active');\n\n        function convertTo24Hour(timeStr) {\n            // Usar una expresi\u00f3n regular para detectar el formato am/pm\n            var timeFormat = /(\\d{1,2}):(\\d{2}):(\\d{2}) ([apAP][mM])/;\n            var match = timeStr.match(timeFormat);\n\n            if (match) {\n                var hours = parseInt(match[1], 10);\n                var minutes = match[2];\n                var period = match[3].toLowerCase();\n\n                // Convertir a formato 24 horas\n                if (period === 'pm' && hours !== 12) {\n                    hours += 12;  // Agregar 12 horas si es PM\n                } else if (period === 'am' && hours === 12) {\n                    hours = 0;  // 12 AM es igual a 00\n                }\n\n                // Formatear el tiempo a HH:MM:SS\n                return (\"0\" + hours).slice(-2) + \":\" + minutes + \":00\";\n            }\n\n            return \"Formato inv\u00e1lido\";\n        }\n\n        // Obtener la fecha actual en formato \"YYYY-MM-DD\"\n        function getCurrentDate() {\n            const today = new Date();\n            const year = today.getFullYear();\n            const month = String(today.getMonth() + 1).padStart(2, '0');\n            const day = String(today.getDate()).padStart(2, '0');\n            return `${year}-${month}-${day}`;\n        }\n\n        $('.filter_button').on('click', function () {\n            let filterButton = $(this).attr('id');\n            $('.filter_input').each(function () {\n                $(this).val('');\n            });\n            $('.filter_button').removeClass('active'); // Reemplaza 'active' por el nombre de la clase que quieras quitar\n            $('.filter_button#' + filterButton).addClass('active');\n            switch (filterButton) {\n                case \"filter_by_today\":\n                    filterValue = getCurrentDate();\n                    break;\n                case \"filter_by_confirm_status\":\n                    filterValue = \"complete\";\n                    break;\n                case \"filter_by_cancel_status\":\n                    filterValue = \"cancelled\";\n                    break;\n                default:\n                    filterValue = \"\"; // Valor por defecto en caso de que no coincida ning\u00fan caso\n                    break;\n            }\n            let filterButtonKeysAndValues = {\n                key: filterButton,\n                value: filterValue\n            };\n            let filters = {filtros: [filterButtonKeysAndValues]};\n\n            $.ajax({\n                url: '/hostess/index/filter',\n                type: 'POST',\n                data: filters,\n                showLoader: true,\n                success: function (response) {\n                    $('.reservation-list').html(response.html);\n                },\n                error: function () {\n                    console.log($t('Error loading the form data.')); // Traducido\n                }\n            });\n        });\n\n        $('.filter_input').on('change', function () {\n            let filters = [];\n            $('.filter_input').each(function () {\n                let filterInput = $(this).attr('id');\n                if ($(this).val().trim() != '') {\n                    let filterInputKeysAndValues = {\n                        key: filterInput,\n                        value: $(this).val().trim()\n                    };\n                    filters.push(filterInputKeysAndValues);\n                }\n            });\n            if (filters.length <= 0) {\n                return;\n            }\n            $.ajax({\n                url: '/hostess/index/filter',\n                type: 'POST',\n                data: {filtros: filters},\n                showLoader: true,\n                success: function (response) {\n                    $('.reservation-list').html(response.html);\n                },\n                error: function () {\n                    console.log($t('Error loading the form data.')); // Traducido\n                }\n            });\n        });\n\n        // Capturar clic en el bot\u00f3n Detalles\n        $(document).on('click', '.action.details', function () {\n            var card = $(this).closest('.reservation-card');\n            let customerName = card.find('[name=\"nombre\"] .name-value');\n            let adultVar = card.find('[name=\"adultos\"]');\n            let childVar = card.find('[name=\"ni\u00f1os\"]');\n            let tableType = card.find('[name=\"table-type\"]');\n            let tableIds = card.find('[name=\"table-ids\"]');\n            let timeStr = card.find('[name=\"slot-time\"]').val().trim();\n            let telephone = card.find('[name=\"telephone\"]');\n            let convertedTime = convertTo24Hour(timeStr);\n            let reservationData = {\n                customerFirstname: customerName[0].value,\n                customerLastname: customerName[1].value,\n                orderId: card.find('[name=\"order_id\"]').val(),\n                slotDate: card.find('[name=\"slot-date\"]').val().trim(),\n                slotTime: convertedTime,\n                guestQty: card.find('[name=\"comensales\"] .item-value').text().trim(),\n                guestQtyAdult: adultVar[0].value,\n                guestQtyChildren: childVar[0].value,\n                tableType: tableType[0].value,\n                tableIds: tableIds[0].value,\n                status: card.find('[name=\"status-order\"]').val().trim(),\n                assignedTables: card.find('[name=\"mesa_asignada\"] .item-value').text().trim(),\n                commentReservation: card.find('[name=\"comentarios\"]').val(),\n                requestedTable: card.find('[name=\"table-request-type\"]').val(),\n                requestedArea: card.find('[name=\"table-request-zone\"]').val(),\n                telephone: telephone[0].value\n            };\n\n            // Hacer una llamada AJAX al controlador\n            $.ajax({\n                url: '/hostess/index/edit',\n                type: 'POST',\n                data: reservationData,\n                showLoader: true,\n                success: function (response) {\n                    $('.reservation-edit-form-container-form').html(response.html);\n                    let formContainer = document.querySelector('.reservation-edit-form-container-form');\n                    let formElements = formContainer.querySelectorAll('input[type=\"text\"], input[type=\"date\"], input[type=\"time\"], input[type=\"number\"], select, textarea button');\n                    let status = card.find('[name=\"status-order\"]').val().trim();\n                    $('#save_button').addClass('update-reservation');\n                    $('#save_button').removeClass('create-reservation');\n\n                    let currentIncrementId = $('.current-detail-reservation').val();\n                    let getTimeFormatCurrent = $('#get-time-format-'+currentIncrementId).val();\n                    $('#slot_time').val(getTimeFormatCurrent);\n\n                    if (status != 'complete' && status != 'cancelled') {\n                        formElements.forEach(element => {\n                            element.removeAttribute('disabled');\n                            $('button.assign-table').attr('disabled', false);\n                            $('button.assign-table-delete').attr('disabled', false);\n                        });\n                        $('#slot_date').attr('disabled', 'disabled');\n                        $('#slot_time').attr('disabled', 'disabled');\n                        $('#assignment_wait_time').attr('disabled', 'disabled');\n                        $('#consumption_time_remaining').attr('disabled', 'disabled');\n                        $('#assign-table').attr('disabled', false);\n                    } else {\n                        $('button.assign-table').attr('disabled', 'disabled');\n                        $('button.assign-table-delete').attr('disabled', 'disabled');\n                        formElements.forEach(element => {\n                            element.setAttribute('disabled', 'disabled');\n                        });\n                    }\n                },\n                error: function () {\n                    console.log($t('Error loading the form data.')); // Traducido\n                }\n            });\n        });\n\n        // Guardar cambios del formulario\n        $(document).on('click', '#create_reservation', function () {\n\n            $.ajax({\n                url: '/hostess/index/create',\n                type: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    $('.reservation-edit-form-container-form').html(response.html);\n                    $('#save_button').addClass('create-reservation');\n                    $('#save_button').removeClass('update-reservation');\n                    $('#assign-table').attr('disabled', false);\n                },\n                error: function () {\n                    alert($t('Error guetting form.')); // Traducido\n                }\n            });\n        });\n\n        $('#consumption-form-group').hide();\n        $('#assignment-form-group').show();\n        $(document).on('change', '#initial_reservation', function () {\n            if ($(this).is(':checked')) {\n                $('#status').val('confirmed');\n                $('#assignment-form-group').hide();\n                $('#consumption-form-group').show();\n            } else {\n                $('#status').val('pending');\n                $('#consumption-form-group').hide();\n                $('#assignment-form-group').show();\n            }\n        });\n\n\n        $(document).on('click', '.create-reservation', function (e) {\n            e.preventDefault();\n            if (!$('#reservation-method').val()) {\n                $('#reservation-method').addClass('error-select');\n                alert($t('Select Reservation Method Value'));\n                return false;\n            }\n            // Obtener la fecha actual en formato YYYY-MM-DD\n            let tzoffset = (new Date()).getTimezoneOffset() * 60000; //offset in milliseconds\n            let localISOTime = (new Date(Date.now() - tzoffset)).toISOString().slice(0, -1);\n            let today = localISOTime.split('T')[0];\n            let reservationDate = $('#slot_date').val();\n            let isInitialReservationChecked = $('#initial_reservation').prop('checked');\n\n            // Validar si el checkbox est\u00e1 marcado y la fecha es distinta a hoy\n            if (isInitialReservationChecked && reservationDate !== today) {\n                alert($t('The reservation date must be today for an initial reservation.'));\n                return false; // Detiene la ejecuci\u00f3n\n            }\n            $('#assigment-table-list').val($('.assigment-table-value-table').text());\n            $('#assigment-table-type').val($('.assigment-table-value-type').text());\n            $('#reservation-method').removeClass('error-select');\n            $.ajax({\n                url: '/hostess/index/save',\n                type: 'POST',\n                data: $(\"#reservation-edit-form\").serialize(),\n                showLoader: true,\n                success: function (response) {\n                    if (response.success == true) {\n                        alert($t('Created Order') + response.order_id);\n                        $('#search_filter_by_word').val(response.order_id);\n                        // Esperar 2 segundos y ejecutar la funci\u00f3n de filtrado\n                        $('#search_filter_by_word').trigger('change');\n                            setTimeout(function () {\n                            $('.action.details').trigger('click');\n                            $('#search_filter_by_word').val('');\n                                var urlParams = new URLSearchParams(window.location.search);\n                                // Verificar si el par\u00e1metro 'action' tiene el valor 'newReservation'\n                                if (urlParams.get('action') === 'newReservation') {\n                                    urlParams.delete('action'); // Eliminar el par\u00e1metro de la URL\n                                    // Reconstruir la URL sin el par\u00e1metro y actualizarla\n                                    var newUrl = window.location.pathname + '?' + urlParams.toString();\n                                    window.history.replaceState(null, '', newUrl);\n                                }\n                        }, 2500);\n\n\n                    } else {\n                        if(response.message.substring(29,32) == \"IV-\"){\n                            alert(response.message.substring(32,response.message.length));\n                        } else {\n                            alert($t('Error to create Reservation.')); // Traducido\n                        }\n                    }\n                    return true;\n                },\n                error: function () {\n                    alert($t('Error to create Reservation.')); // Traducido\n                    return true;\n                }\n            });\n        });\n\n        $(document).on('click', '.update-reservation', function (e) {\n            e.preventDefault();\n// Obtener la fecha actual en formato YYYY-MM-DD\n            let tzoffset = (new Date()).getTimezoneOffset() * 60000; //offset in milliseconds\n            let localISOTime = (new Date(Date.now() - tzoffset)).toISOString().slice(0, -1);\n            let today = localISOTime.split('T')[0];\n            let reservationDate = $('#slot_date').val();\n            let status = $('#status').val();\n\n            // Validar si el checkbox est\u00e1 marcado y la fecha es distinta a hoy\n            if (status === 'confirmed' && reservationDate !== today) {\n                alert($t('The reservation date must be today for an initial reservation.'));\n                return false; // Detiene la ejecuci\u00f3n\n            }\n\n            if (status === 'complete' || status === 'cancelled') {\n                $('#assigment-table-list-id').val('');\n            }\n\n            $('#assigment-table-list').val($('.assigment-table-value-table').text());\n            $('#assigment-table-type').val($('.assigment-table-value-type').text());\n\n\n            $.ajax({\n                url: '/hostess/index/save',\n                type: 'POST',\n                data: $(\"#reservation-edit-form\").serialize(),\n                showLoader: true,\n                success: function (response) {\n                    if (response.success == true) {\n                        alert($t('Update Order: ') + response.order_id);\n                        // $('#search_filter_by_word').val(response.order_id);\n                        $('#filter_by_today').trigger('click');\n                        // $('#search_filter_by_word').trigger('change');\n                        // $('#search_filter_by_word').val('');\n\n                    } else {\n                        alert($t('Error to update Reservation.')); // Traducido\n                    }\n                    return true;\n                },\n                error: function () {\n                    alert($t('Error to update Reservation.')); // Traducido\n                    return true;\n                }\n            });\n        });\n\n        const timers = document.querySelectorAll('[data-time-end]');\n        timers.forEach(timer => {\n            const now = new Date();\n            const [hours, minutes, seconds] = timer.getAttribute('data-time-end').split(':').map(Number);\n            // Tiempo total en segundos\n            let totalSeconds = hours * 3600 + minutes * 60 + seconds;\n            const interval = setInterval(() => {\n                if (totalSeconds <= 0) {\n                    timer.textContent = '00:00:00';\n                    timer.classList.remove('status-serving');\n                    timer.classList.add('status-cancelled');\n                    clearInterval(interval);\n                    return;\n                }\n                totalSeconds--;\n                const h = String(Math.floor(totalSeconds / 3600)).padStart(2, '0');\n                const m = String(Math.floor((totalSeconds % 3600) / 60)).padStart(2, '0');\n                const s = String(totalSeconds % 60).padStart(2, '0');\n                timer.textContent = `${h}:${m}:${s}`;\n            }, 1000);\n        });\n    });\n});\n","Magento_InventorySwatchesFrontendUi/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'configurableVariationQty',\n    'jquery-ui-modules/widget'\n], function ($, configurableVariationQty) {\n    'use strict';\n\n    return function (SwatchRenderer) {\n        $.widget('mage.SwatchRenderer', SwatchRenderer, {\n\n            /** @inheritdoc */\n            _OnClick: function ($this, widget) {\n                var salesChannel = this.options.jsonConfig.channel,\n                    salesChannelCode = this.options.jsonConfig.salesChannelCode,\n                    productVariationsSku = this.options.jsonConfig.sku;\n\n                this._super($this, widget);\n                configurableVariationQty(productVariationsSku[widget.getProductId()], salesChannel, salesChannelCode);\n            }\n        });\n\n        return $.mage.SwatchRenderer;\n    };\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/view/product-page.js":"define(\n    ['uiComponent'],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n        });\n    }\n);","PayPal_Braintree/js/view/payment/adapter.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'braintree',\n    'braintreeDataCollector',\n    'braintreeHostedFields',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function ($, client, dataCollector, hostedFields, fullScreenLoader, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        apiClient: null,\n        config: {},\n        checkout: null,\n        deviceData: null,\n        clientInstance: null,\n        hostedFieldsInstance: null,\n        paypalInstance: null,\n        code: 'braintree',\n\n        /**\n         * {Object}\n         */\n        events: {\n            onClick: null,\n            onCancel: null,\n            onError: null\n        },\n\n        /**\n         * Get Braintree api client\n         * @returns {Object}\n         */\n        getApiClient: function () {\n            return this.clientInstance;\n        },\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get payment name\n         * @returns {String}\n         */\n        getCode: function () {\n            if (window.checkoutConfig.payment[this.code]) {\n                return this.code;\n            } else {\n                return 'braintree_paypal';\n            }\n        },\n\n        /**\n         * Get client token\n         * @returns {String|*}\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment[this.getCode()].environment;\n        },\n\n        getCurrentCode: function (paypalType = null) {\n            var code = 'braintree_paypal';\n            if (paypalType !== 'paypal') {\n                code = code + '_' + paypalType;\n            }\n            return code;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getColor: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.color;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getShape: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.shape;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSize: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.size;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getLabel: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.label;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getBranding: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getFundingIcons: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getDisabledFunding: function () {\n            return window.checkoutConfig.payment[this.getCode()].disabledFunding;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader();\n        },\n\n        /**\n         * Has PayPal been init'd already\n         */\n        getPayPalInstance: function() {\n            if (typeof this.config.paypalInstance !== 'undefined' && this.config.paypalInstance) {\n                return this.config.paypalInstance;\n            }\n\n            return null;\n        },\n\n        setPayPalInstance: function(val) {\n            this.config.paypalInstance = val;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        setup: function (callback) {\n            if (!this.getClientToken()) {\n                this.showError($t('Sorry, but something went wrong.'));\n                return;\n            }\n\n            if (this.clientInstance) {\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === \"function\") {\n                    callback(this.clientInstance);\n                }\n                return;\n            }\n\n            client.create({\n                authorization: this.getClientToken()\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('Braintree Setup Error', clientErr);\n                    return this.showError(\"Sorry, but something went wrong. Please contact the store owner.\");\n                }\n\n                var options = {\n                    client: clientInstance\n                };\n\n                if (typeof this.config.dataCollector === 'object' && typeof this.config.dataCollector.paypal === 'boolean') {\n                    options.paypal = true;\n                }\n\n                dataCollector.create(options, function (err, dataCollectorInstance) {\n                    if (err) {\n                        return console.log(err);\n                    }\n\n                    this.deviceData = dataCollectorInstance.deviceData;\n                    this.config.onDeviceDataRecieved(this.deviceData);\n                }.bind(this));\n\n                this.clientInstance = clientInstance;\n\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === \"function\") {\n                    callback(this.clientInstance);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Setup hosted fields instance\n         */\n        setupHostedFields: function () {\n            var self = this;\n\n            if (this.hostedFieldsInstance) {\n                this.hostedFieldsInstance.teardown(function () {\n                    this.hostedFieldsInstance = null;\n                    this.setupHostedFields();\n                }.bind(this));\n                return;\n            }\n\n            hostedFields.create({\n                client: this.clientInstance,\n                fields: this.config.hostedFields,\n                styles: {\n                    \"input\": {\n                        \"font-size\": \"14pt\",\n                        \"color\": \"#3A3A3A\"\n                    },\n                    \":focus\": {\n                        \"color\": \"black\"\n                    },\n                    \".valid\": {\n                        \"color\": \"green\"\n                    },\n                    \".invalid\": {\n                        \"color\": \"red\"\n                    }\n                }\n            }, function (createErr, hostedFieldsInstance) {\n                if (createErr) {\n                    self.showError($t(\"Braintree hosted fields could not be initialized. Please contact the store owner.\"));\n                    console.error('Braintree hosted fields error', createErr);\n                    return;\n                }\n\n                this.config.onInstanceReady(hostedFieldsInstance);\n                this.hostedFieldsInstance = hostedFieldsInstance;\n            }.bind(this));\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({}, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            console.error('All fields are empty! Please fill out the form.');\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            console.error('This payment method already exists in your vault.');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            console.error('CVV did not pass verification');\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            console.error('Network error occurred when tokenizing.');\n                            break;\n                        default:\n                            console.error('Something bad happened!', tokenizeErr);\n                    }\n                } else {\n                    this.config.onPaymentMethodReceived(payload);\n                }\n            }.bind(this));\n        }\n    };\n});\n\n","PayPal_Braintree/js/view/payment/3d-secure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate',\n    'braintreeThreeDSecure',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, braintree, quote, $t, threeDSecure, fullScreenLoader) {\n    'use strict';\n\n    return {\n        config: null,\n\n        /**\n         * Set 3d secure config\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n            this.config.thresholdAmount = parseFloat(config.thresholdAmount);\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'three_d_secure';\n        },\n\n        /**\n         * convert Non-ASCII characters into unicode\n         * @param str\n         * @returns {string}\n         */\n        escapeNonAsciiCharacters: function (str) {\n            return str.split(\"\").map(function (c) { return /[^\\x00-\\x7F]$/.test(c) ? c : c.split(\"\").map(function (a) { return \"\\\\u00\" + a.charCodeAt().toString(16)}).join(\"\")}).join(\"\");\n        },\n\n        /**\n         * Validate Braintree payment nonce\n         * @param {Object} context\n         * @returns {Object}\n         */\n        validate: function (context) {\n            var clientInstance = braintree.getApiClient(),\n                state = $.Deferred(),\n                totalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2),\n                billingAddress = quote.billingAddress();\n\n            if (billingAddress.regionCode == null) {\n                billingAddress.regionCode = undefined;\n            }\n\n            if (billingAddress.regionCode !== undefined && billingAddress.regionCode.length > 2) {\n                billingAddress.regionCode = undefined;\n            }\n\n            // No 3d secure if using CVV verification on vaulted cards\n            if (quote.paymentMethod().method.indexOf('braintree_cc_vault_') !== -1) {\n                if (this.config.useCvvVault === true) {\n                    state.resolve();\n                    return state.promise();\n                }\n            }\n\n            if (!this.isAmountAvailable(totalAmount) || !this.isCountryAvailable(billingAddress.countryId)) {\n                state.resolve();\n                return state.promise();\n            }\n\n            var firstName = this.escapeNonAsciiCharacters(billingAddress.firstname);\n            var lastName = this.escapeNonAsciiCharacters(billingAddress.lastname);\n\n            let challengeRequested = this.getChallengeRequested();\n\n            fullScreenLoader.startLoader();\n\n            var setup3d = function(clientInstance) {\n                threeDSecure.create({\n                    version: 2,\n                    client: clientInstance\n                }, function (threeDSecureErr, threeDSecureInstance) {\n                    if (threeDSecureErr) {\n                        fullScreenLoader.stopLoader();\n                        return state.reject($t('Please try again with another form of payment.'));\n                    }\n\n                    var threeDSContainer = document.createElement('div'),\n                        tdmask = document.createElement('div'),\n                        tdframe = document.createElement('div'),\n                        tdbody = document.createElement('div');\n\n                    threeDSContainer.id = 'braintree-three-d-modal';\n                    tdmask.className =\"bt-mask\";\n                    tdframe.className =\"bt-modal-frame\";\n                    tdbody.className =\"bt-modal-body\";\n\n                    tdframe.appendChild(tdbody);\n                    threeDSContainer.appendChild(tdmask);\n                    threeDSContainer.appendChild(tdframe);\n\n                    threeDSecureInstance.verifyCard({\n                        amount: totalAmount,\n                        nonce: context.paymentMethodNonce,\n                        challengeRequested: challengeRequested,\n                        billingAddress: {\n                            givenName: firstName,\n                            surname: lastName,\n                            phoneNumber: billingAddress.telephone,\n                            streetAddress: billingAddress.street[0],\n                            extendedAddress: billingAddress.street[1],\n                            locality: billingAddress.city,\n                            region: billingAddress.regionCode,\n                            postalCode: billingAddress.postcode,\n                            countryCodeAlpha2: billingAddress.countryId\n                        },\n                        onLookupComplete: function (data, next) {\n                            next();\n                        },\n                        addFrame: function (err, iframe) {\n                            fullScreenLoader.stopLoader();\n\n                            if (err) {\n                                console.log(\"Unable to verify card over 3D Secure\", err);\n                                return state.reject($t('Please try again with another form of payment.'));\n                            }\n\n                            tdbody.appendChild(iframe);\n                            document.body.appendChild(threeDSContainer);\n                        },\n                        removeFrame: function () {\n                            fullScreenLoader.startLoader();\n                            document.body.removeChild(threeDSContainer);\n                        }\n                    }, function (err, response) {\n                        fullScreenLoader.stopLoader();\n\n                        if (err) {\n                            console.error(\"3DSecure validation failed\", err);\n                            if (err.code === 'THREEDS_LOOKUP_VALIDATION_ERROR') {\n                                let errorMessage = err.details.originalError.details.originalError.error.message;\n                                if (errorMessage === 'Billing line1 format is invalid.' && billingAddress.street[0].length > 50) {\n                                    return state.reject(\n                                      $t('Billing line1 must be string and less than 50 characters. Please update the address and try again.')\n                                    );\n\n                                } else if (errorMessage === 'Billing line2 format is invalid.' && billingAddress.street[1].length > 50) {\n                                    return state.reject(\n                                      $t('Billing line2 must be string and less than 50 characters. Please update the address and try again.')\n                                    );\n                                }\n                                return state.reject($t(errorMessage));\n                            } else {\n                                return state.reject($t('Please try again with another form of payment.'));\n                            }\n                        }\n\n                        var liability = {\n                            shifted: response.liabilityShifted,\n                            shiftPossible: response.liabilityShiftPossible\n                        };\n\n                        if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                            context.paymentMethodNonce = response.nonce;\n                            state.resolve();\n                        } else {\n                            state.reject($t('Please try again with another form of payment.'));\n                        }\n                    });\n                });\n            };\n\n            if (!clientInstance) {\n                require(['PayPal_Braintree/js/view/payment/method-renderer/cc-form'], function(c) {\n                    var config = c.extend({\n                        defaults: {\n                            clientConfig: {\n                                onReady: function() {}\n                            }\n                        }\n                    });\n                    braintree.setConfig(config.defaults.clientConfig);\n                    braintree.setup(setup3d);\n                });\n            } else {\n                setup3d(clientInstance);\n            }\n\n            return state.promise();\n        },\n\n        /**\n         * Check minimal amount for 3d secure activation\n         * @param {Number} amount\n         * @returns {Boolean}\n         */\n        isAmountAvailable: function (amount) {\n            amount = parseFloat(amount);\n\n            return amount >= this.config.thresholdAmount;\n        },\n\n        /**\n         * Check if current country is available for 3d secure\n         * @param {String} countryId\n         * @returns {Boolean}\n         */\n        isCountryAvailable: function (countryId) {\n            var key,\n                specificCountries = this.config.specificCountries;\n\n            // all countries are available\n            if (!specificCountries.length) {\n                return true;\n            }\n\n            for (key in specificCountries) {\n                if (countryId === specificCountries[key]) {\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        getChallengeRequested: function () {\n            return this.config.challengeRequested;\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/venmo.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_venmo',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/venmo'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/lpm.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_local_payment',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/lpm'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/ach.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_ach_direct_debit',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/ach'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment,\n        braintreeType = 'braintree',\n        payPalType = 'braintree_paypal',\n        braintreeAchDirectDebit = 'braintree_ach_direct_debit',\n        braintreeVenmo = 'braintree_venmo',\n        braintreeLocalPayment = 'braintree_local_payment';\n\n    if (config[braintreeType] && config[braintreeType].isActive && config[braintreeType].clientToken) {\n        rendererList.push({\n            type: braintreeType,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/hosted-fields'\n        });\n    }\n\n    if (config[payPalType] && config[payPalType].isActive) {\n        rendererList.push({\n            type: payPalType,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/paypal'\n        });\n    }\n\n    if (config[braintreeVenmo] && config[braintreeVenmo].isAllowed && config[braintreeVenmo].clientToken) {\n        rendererList.push({\n            type: braintreeVenmo,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/venmo'\n        });\n    }\n\n    if (config[braintreeAchDirectDebit] && config[braintreeAchDirectDebit].isActive && config[braintreeAchDirectDebit].clientToken) {\n        rendererList.push({\n            type: braintreeAchDirectDebit,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/ach'\n        });\n    }\n\n    if (config[braintreeLocalPayment] && config[braintreeLocalPayment].clientToken) {\n        rendererList.push({\n            type: braintreeLocalPayment,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/lpm'\n        });\n    }\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","PayPal_Braintree/js/view/payment/validator-handler.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/3d-secure',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, globalMessageList, verify3DSecure, fullScreenLoader) {\n    'use strict';\n\n    return {\n        validators: [],\n\n        /**\n         * Get payment config\n         * @returns {Object}\n         */\n        getConfig: function () {\n            return window.checkoutConfig.payment;\n        },\n\n        /**\n         * Init list of validators\n         */\n        initialize: function () {\n            var config = this.getConfig();\n\n            if (config[verify3DSecure.getCode()].enabled) {\n                verify3DSecure.setConfig(config[verify3DSecure.getCode()]);\n                this.add(verify3DSecure);\n            }\n        },\n\n        /**\n         * Add new validator\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators\n         * @param {Object} context\n         * @param {Function} callback\n         */\n        validate: function (context, callback, errorCallback) {\n            var self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback();\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback();\n                }).fail(function (error) {\n                    errorCallback();\n                    self.showError(error);\n                });\n        },\n\n        /**\n         * Show error message\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal-vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, _, VaultComponent, globalMessageList, fullScreenLoader) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal/vault',\n            additionalData: {}\n        },\n\n        /**\n         * Get PayPal payer email\n         * @returns {String}\n         */\n        getPayerEmail: function () {\n            return this.details.payerEmail;\n        },\n\n        /**\n         * Get type of payment\n         * @returns {String}\n         */\n        getPaymentIcon: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].paymentIcon;\n        },\n\n        /**\n         * Place order\n         */\n        beforePlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            })\n                .done(function (response) {\n                    fullScreenLoader.stopLoader();\n                    self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                    self.placeOrder();\n                })\n                .fail(function (response) {\n                    var error = JSON.parse(response.responseText);\n\n                    fullScreenLoader.stopLoader();\n                    globalMessageList.addErrorMessage({\n                        message: error.message\n                    });\n                });\n        },\n\n        /**\n         * Get payment method data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/venmo.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeVenmo',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        braintree,\n        dataCollector,\n        venmo,\n        formBuilder,\n        messageList,\n        fullScreenLoader,\n        additionalValidators,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                deviceData: null,\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/venmo',\n                venmoInstance: null\n            },\n\n            clickVenmoBtn: function () {\n                var self = this;\n\n                if (!additionalValidators.validate()) {\n                    return false;\n                }\n\n                if (!this.venmoInstance) {\n                    this.setErrorMsg($t('Venmo not initialized, please try reloading.'));\n                    return;\n                }\n\n                this.venmoInstance.tokenize(function (tokenizeErr, payload) {\n                    if (tokenizeErr) {\n                        if (tokenizeErr.code === 'VENMO_CANCELED') {\n                            self.setErrorMsg($t('Venmo app is not available or the payment flow was cancelled.'));\n                        } else if (tokenizeErr.code === 'VENMO_APP_CANCELED') {\n                            self.setErrorMsg($t('Venmo payment flow cancelled.'));\n                        } else {\n                            self.setErrorMsg(tokenizeErr.message);\n                        }\n                    } else {\n                        self.handleVenmoSuccess(payload);\n                    }\n                });\n            },\n\n            collectDeviceData: function (clientInstance, callback) {\n                var self = this;\n                dataCollector.create({\n                    client: clientInstance,\n                    paypal: true\n                }, function (dataCollectorErr, dataCollectorInstance) {\n                    if (dataCollectorErr) {\n                        return;\n                    }\n                    self.deviceData = dataCollectorInstance.deviceData;\n                    callback();\n                });\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function() {\n                return 'braintree_venmo';\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'device_data': this.deviceData\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getPaymentMarkSrc: function () {\n                return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n            },\n\n            getTitle: function() {\n                return 'Venmo';\n            },\n\n            handleVenmoSuccess: function (payload) {\n                this.setPaymentMethodNonce(payload.nonce);\n                this.placeOrder();\n            },\n\n            initialize: function () {\n                this._super();\n\n                var self = this;\n\n                braintree.create({\n                    authorization: self.getClientToken()\n                }, function (clientError, clientInstance) {\n                    if (clientError) {\n                        this.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                        return;\n                    }\n\n                    // Collect device data\n                    self.collectDeviceData(clientInstance, function () {\n                        // callback from collectDeviceData\n                        venmo.create({\n                            client: clientInstance,\n                            allowDesktop: true,\n                            allowNewBrowserTab: false\n                        }, function (venmoErr, venmoInstance) {\n                            if (venmoErr) {\n                                self.setErrorMsg($t('Error initializing Venmo: %1').replace('%1', venmoErr));\n                                return;\n                            }\n\n                            if (!venmoInstance.isBrowserSupported()) {\n                                console.log('Browser does not support Venmo');\n                                return;\n                            }\n\n                            self.setVenmoInstance(venmoInstance);\n                        });\n                    });\n                });\n\n                return this;\n            },\n\n            isAllowed: function () {\n                return window.checkoutConfig.payment[this.getCode()].isAllowed;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            setVenmoInstance: function (instance) {\n                this.venmoInstance = instance;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/lpm.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'jquery',\n        'braintree',\n        'braintreeLpm',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'mage/url',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        ko,\n        $,\n        braintree,\n        lpm,\n        formBuilder,\n        messageList,\n        selectBillingAddress,\n        fullScreenLoader,\n        quote,\n        additionalValidators,\n        url,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                code: 'braintree_local_payment',\n                paymentMethodsAvailable: ko.observable(false),\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/lpm'\n            },\n\n            clickPaymentBtn: function (method) {\n                var self = this;\n\n                if (additionalValidators.validate()) {\n                    fullScreenLoader.startLoader();\n\n                    braintree.create({\n                        authorization: self.getClientToken()\n                    }, function (clientError, clientInstance) {\n                        if (clientError) {\n                            self.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                            fullScreenLoader.stopLoader();\n                            return;\n                        }\n\n                        lpm.create({\n                            client: clientInstance,\n                            merchantAccountId: self.getMerchantAccountId()\n                        }, function (lpmError, lpmInstance) {\n                            if (lpmError) {\n                                self.setErrorMsg(lpmError);\n                                fullScreenLoader.stopLoader();\n                                return;\n                            }\n\n                            lpmInstance.startPayment({\n                                amount: self.getAmount(),\n                                currencyCode: self.getCurrencyCode(),\n                                email: self.getCustomerDetails().email,\n                                phone: self.getCustomerDetails().phone,\n                                givenName: self.getCustomerDetails().firstName,\n                                surname: self.getCustomerDetails().lastName,\n                                shippingAddressRequired: !quote.isVirtual(),\n                                address: self.getAddress(),\n                                paymentType: method,\n                                onPaymentStart: function (data, start) {\n                                    start();\n                                },\n                                // This is a required option, however it will apparently never be used in the current payment flow.\n                                // Therefore, both values are set to allow the payment flow to continute, rather than erroring out.\n                                fallback: {\n                                    url: 'N/A',\n                                    buttonText: 'N/A'\n                                }\n                            }, function (startPaymentError, payload) {\n                                fullScreenLoader.stopLoader();\n                                if (startPaymentError) {\n                                    switch (startPaymentError.code) {\n                                        case 'LOCAL_PAYMENT_POPUP_CLOSED':\n                                            self.setErrorMsg($t('Local Payment popup was closed unexpectedly.'));\n                                            break;\n                                        case 'LOCAL_PAYMENT_WINDOW_OPEN_FAILED':\n                                            self.setErrorMsg($t('Local Payment popup failed to open.'));\n                                            break;\n                                        case 'LOCAL_PAYMENT_WINDOW_CLOSED':\n                                            self.setErrorMsg($t('Local Payment popup was closed. Payment cancelled.'));\n                                            break;\n                                        default:\n                                            self.setErrorMsg('Error! ' + startPaymentError);\n                                            break;\n                                    }\n                                } else {\n                                    // Send the nonce to your server to create a transaction\n                                    self.setPaymentMethodNonce(payload.nonce);\n                                    self.placeOrder();\n                                }\n                            });\n                        });\n                    });\n                }\n            },\n\n            getAddress: function () {\n                var shippingAddress = quote.shippingAddress();\n\n                if (quote.isVirtual()) {\n                    return {\n                        countryCode: shippingAddress.countryId\n                    }\n                }\n\n                return {\n                    streetAddress: shippingAddress.street[0],\n                    extendedAddress: shippingAddress.street[1],\n                    locality: shippingAddress.city,\n                    postalCode: shippingAddress.postcode,\n                    region: shippingAddress.region,\n                    countryCode: shippingAddress.countryId\n                }\n            },\n\n            getAmount: function () {\n                return quote.totals()['base_grand_total'].toString();\n            },\n\n            getBillingAddress: function () {\n                return quote.billingAddress();\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return this.code;\n            },\n\n            getCurrencyCode: function () {\n                return quote.totals()['base_currency_code'];\n            },\n\n            getCustomerDetails: function () {\n                var billingAddress = quote.billingAddress();\n                return {\n                    firstName: billingAddress.firstname,\n                    lastName: billingAddress.lastname,\n                    phone: billingAddress.telephone,\n                    email: typeof quote.guestEmail === 'string' ? quote.guestEmail : window.checkoutConfig.customerData.email\n                }\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getMerchantAccountId: function () {\n                return window.checkoutConfig.payment[this.getCode()].merchantAccountId;\n            },\n\n            getPaymentMethod: function (method) {\n                var methods = this.getPaymentMethods();\n\n                for (var i = 0; i < methods.length; i++) {\n                    if (methods[i].method === method) {\n                        return methods[i]\n                    }\n                }\n            },\n\n            getPaymentMethods: function () {\n                return window.checkoutConfig.payment[this.getCode()].allowedMethods;\n            },\n\n            getPaymentMarkSrc: function () {\n                return window.checkoutConfig.payment[this.getCode()].paymentIcons;\n            },\n\n            getTitle: function () {\n                return window.checkoutConfig.payment[this.getCode()].title;\n            },\n\n            initialize: function () {\n                this._super();\n                return this;\n            },\n\n            isActive: function () {\n                var address = quote.billingAddress() || quote.shippingAddress();\n                var methods = this.getPaymentMethods();\n\n                for (var i = 0; i < methods.length; i++) {\n                    if (methods[i].countries.includes(address.countryId)) {\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n\n            isValidCountryAndCurrency: function (method) {\n                var address = quote.billingAddress();\n\n                if (!address) {\n                    this.paymentMethodsAvailable(false);\n                    return false;\n                }\n\n                var countryId = address.countryId;\n                var quoteCurrency = quote.totals()['base_currency_code'];\n                var paymentMethodDetails = this.getPaymentMethod(method);\n\n                if ((countryId !== 'GB' && paymentMethodDetails.countries.includes(countryId) && (quoteCurrency === 'EUR' || quoteCurrency === 'PLN')) || (countryId === 'GB' && paymentMethodDetails.countries.includes(countryId) && quoteCurrency === 'GBP')) {\n                    this.paymentMethodsAvailable(true);\n                    return true;\n                }\n\n                return false;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            validateForm: function (form) {\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/hosted-fields.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/method-renderer/cc-form',\n    'PayPal_Braintree/js/validator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'mage/translate'\n], function ($, Component, validator, VaultEnabler, additionalValidators, $t) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'PayPal_Braintree/payment/form',\n            clientConfig: {\n\n                /**\n                 * {String}\n                 */\n                id: 'co-transparent-form-braintree'\n            },\n            isValidCardNumber: false,\n            isValidExpirationDate: false,\n            isValidCvvNumber: false,\n\n            onInstanceReady: function (instance) {\n                instance.on('validityChange', this.onValidityChange.bind(this));\n                instance.on('cardTypeChange', this.onCardTypeChange.bind(this));\n            }\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this._super();\n\n            this.clientConfig.hostedFields = this.getHostedFields();\n            this.clientConfig.onInstanceReady = this.onInstanceReady.bind(this);\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = this._super();\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * Get Braintree Hosted Fields\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number'),\n                        placeholder: $t('4111 1111 1111 1111')\n                    },\n                    expirationDate: {\n                        selector: self.getSelector('expirationDate'),\n                        placeholder: $t('MM/YYYY')\n                    }\n                };\n\n            if (self.hasVerification()) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Triggers on Hosted Field changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onValidityChange: function (event) {\n            // Handle a change in validation or card type\n            if (event.emittedBy === 'number') {\n                this.selectedCardType(null);\n\n                if (event.cards.length === 1) {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.selectedCardType(\n                        validator.getMageCardType(event.cards[0].type, this.getCcAvailableTypes())\n                    );\n                    this.validateCardType();\n                } else {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.validateCardType();\n                }\n            }\n\n            // Other field validations\n            if (event.emittedBy === 'expirationDate') {\n                this.isValidExpirationDate = event.fields.expirationDate.isValid;\n            }\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvvNumber = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * Triggers on Hosted Field card type changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onCardTypeChange: function (event) {\n            if (event.cards.length === 1) {\n                this.selectedCardType(\n                    validator.getMageCardType(event.cards[0].type, this.getCcAvailableTypes())\n                );\n            } else {\n                this.selectedCardType(null);\n            }\n        },\n\n        /**\n         * Toggle invalid class on selector\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateField: function (selector, state) {\n            var $selector = $(this.getSelector(selector)),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Validate current credit card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            return this.validateField(\n                'cc_number',\n                (this.isValidCardNumber)\n            );\n        },\n\n        /**\n         * Validate current expiry date\n         * @returns {boolean}\n         */\n        validateExpirationDate: function () {\n            return this.validateField(\n                'expirationDate',\n                (this.isValidExpirationDate === true)\n            );\n        },\n\n        /**\n         * Validate current CVV field\n         * @returns {boolean}\n         */\n        validateCvvNumber: function () {\n            var self = this;\n\n            if (self.hasVerification() === false) {\n                return true;\n            }\n\n            return this.validateField(\n                'cc_cid',\n                (this.isValidCvvNumber === true)\n            );\n        },\n\n        /**\n         * Validate all fields\n         * @returns {boolean}\n         */\n        validateFormFields: function () {\n            return (this.validateCardType() && this.validateExpirationDate() && this.validateCvvNumber()) === true;\n        },\n\n        /**\n         * Trigger order placing\n         */\n        placeOrderClick: function () {\n            if (this.validateFormFields() && additionalValidators.validate()) {\n                this.placeOrder();\n            }\n        },\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].ccVaultCode;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/ach.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'jquery',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeAch',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        ko,\n        $,\n        braintree,\n        dataCollector,\n        ach,\n        formBuilder,\n        messageList,\n        selectBillingAddress,\n        fullScreenLoader,\n        quote,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                deviceData: null,\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/ach',\n                achInstance: null,\n                routingNumber: ko.observable(\"\"),\n                accountNumber: ko.observable(\"\"),\n                accountType: ko.observable(\"checking\"),\n                ownershipType: ko.observable(\"personal\"),\n                firstName: ko.observable(\"\"),\n                lastName: ko.observable(\"\"),\n                businessName: ko.observable(\"\"),\n                hasAuthorization: ko.observable(false),\n                business: ko.observable(false), // for ownership type\n                personal: ko.observable(true) // for ownership type\n            },\n\n            clickAchBtn: function () {\n                if (!this.validateForm('#' + this.getCode() + '-form')) {\n                    return;\n                }\n\n                fullScreenLoader.startLoader();\n\n                var self = this;\n\n                var billingAddress = quote.billingAddress();\n\n                let regionCode;\n\n                let bankDetails = {\n                    routingNumber: self.routingNumber(),\n                    accountNumber: self.accountNumber(),\n                    accountType: self.accountType(),\n                    ownershipType: self.ownershipType(),\n                    billingAddress: {\n                        streetAddress: billingAddress.street[0],\n                        extendedAddress: billingAddress.street[1],\n                        locality: billingAddress.city,\n                        region: billingAddress.regionCode,\n                        postalCode: billingAddress.postcode,\n                    }\n                };\n\n                if (bankDetails.ownershipType === 'personal') {\n                    bankDetails.firstName = self.firstName();\n                    bankDetails.lastName = self.lastName();\n                } else {\n                    bankDetails.businessName = self.businessName();\n                }\n\n                var mandateText = document.getElementById('braintree-ach-mandate').textContent;\n\n                // if no region code is available, lets find one!\n                if (typeof billingAddress.regionCode === 'undefined') {\n                    $.get('/rest/V1/directory/countries/' + billingAddress.countryId).done(function (data) {\n                        if (typeof data.available_regions !== 'undefined') {\n                            for (var i = 0; i < data.available_regions.length; ++i) {\n                                if (data.available_regions[i].id === billingAddress.regionId) {\n                                    regionCode = data.available_regions[i].code;\n                                    bankDetails.billingAddress.region = regionCode;\n                                    self.tokenizeAch(bankDetails, mandateText);\n                                }\n                            }\n                        } else {\n                            fullScreenLoader.stopLoader();\n                            self.tokenizeAch(bankDetails, mandateText);\n                        }\n                    }).fail(function() {\n                        fullScreenLoader.stopLoader();\n                    });\n                } else {\n                    self.tokenizeAch(bankDetails, mandateText);\n                }\n            },\n\n            tokenizeAch: function (bankDetails, mandateText) {\n                var self = this;\n                this.achInstance.tokenize({\n                    bankDetails: bankDetails,\n                    mandateText: mandateText\n                }, function (tokenizeErr, tokenizedPayload) {\n                    if (tokenizeErr) {\n                        self.setErrorMsg($t('There was an error with the provided bank details. Please check and try again.'));\n                        self.hasAuthorization(false);\n                    } else {\n                        fullScreenLoader.stopLoader();\n                        self.handleAchSuccess(tokenizedPayload);\n                    }\n                });\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return 'braintree_ach_direct_debit';\n            },\n\n            getStoreName: function () {\n                return window.checkoutConfig.payment[this.getCode()].storeName;\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getTitle: function() {\n                return 'ACH Direct Debit';\n            },\n\n            handleAchSuccess: function (payload) {\n                this.setPaymentMethodNonce(payload.nonce);\n                this.placeOrder();\n            },\n\n            initialize: function () {\n                this._super();\n\n                var self = this;\n\n                braintree.create({\n                    authorization: self.getClientToken()\n                }, function (clientError, clientInstance) {\n                    if (clientError) {\n                        this.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                        return;\n                    }\n\n                    ach.create({\n                        client: clientInstance\n                    }, function (achErr, achInstance) {\n                        if (achErr) {\n                            self.setErrorMsg($t('Error initializing ACH: %1').replace('%1', achErr));\n                            return;\n                        }\n\n                        self.setAchInstance(achInstance);\n                    });\n                });\n\n                return this;\n            },\n\n            isAllowed: function () {\n                return window.checkoutConfig.payment[this.getCode()].isAllowed;\n            },\n\n            changeOwnershipType: function (data, event) {\n                var self = this;\n                if (event.currentTarget.value === 'business') {\n                    self.business(true);\n                    self.personal(false);\n                } else {\n                    self.business(false);\n                    self.personal(true);\n                }\n            },\n\n            isBusiness: function () {\n                return this.business;\n            },\n\n            isPersonal: function () {\n                return this.personal;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            setAchInstance: function (instance) {\n                this.achInstance = instance;\n            },\n\n            validateForm: function (form) {\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/validator-handler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'braintree',\n    'braintreeHostedFields',\n    'mage/url'\n], function (\n    ko,\n    $,\n    VaultComponent,\n    Braintree,\n    globalMessageList,\n    validatorManager,\n    additionalValidators,\n    fullScreenLoader,\n    client,\n    hostedFields,\n    url\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            active: false,\n            hostedFieldsInstance: null,\n            imports: {\n                onActiveChange: 'active'\n            },\n            modules: {\n                hostedFields: '${ $.parentName }.braintree'\n            },\n            template: 'PayPal_Braintree/payment/cc/vault',\n            updatePaymentUrl: url.build('braintree/payment/updatepaymentmethod'),\n            vaultedCVV: ko.observable(\"\"),\n            validatorManager: validatorManager,\n            isValidCvv: false,\n            onInstanceReady: function (instance) {\n                instance.on('validityChange', this.onValidityChange.bind(this));\n            }\n        },\n\n        /**\n         * Event fired by Braintree SDK whenever input value length matches the validation length.\n         * In the case of a CVV, this is 3, or 4 for AMEX.\n         * @param event\n         */\n        onValidityChange: function (event) {\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvv = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super().observe(['active']);\n            this.validatorManager.initialize();\n            return this;\n        },\n\n        /**\n         * Is payment option active?\n         * @returns {boolean}\n         */\n        isActive: function () {\n            var active = this.getId() === this.isChecked();\n            this.active(active);\n            return active;\n        },\n\n        /**\n         * Fired whenever a payment option is changed.\n         * @param isActive\n         */\n        onActiveChange: function (isActive) {\n            var self = this;\n\n            if (!isActive) {\n                return;\n            }\n\n            if (self.showCvvVerify()) {\n                if (self.hostedFieldsInstance) {\n                    self.hostedFieldsInstance.teardown(function (teardownError) {\n                        if (teardownError) {\n                            globalMessageList.addErrorMessage({\n                                message: teardownError.message\n                            });\n                        }\n                        self.hostedFieldsInstance = null;\n                        self.initHostedCvvField();\n                    });\n                    return;\n                }\n                self.initHostedCvvField();\n            }\n        },\n\n        /**\n         * Initialize the CVV input field with the Braintree Hosted Fields SDK.\n         */\n        initHostedCvvField: function () {\n            var self = this;\n            client.create({\n                authorization: Braintree.getClientToken()\n            }, function (clientError, clientInstance) {\n                if (clientError) {\n                    globalMessageList.addErrorMessage({\n                        message: clientError.message\n                    });\n                }\n                hostedFields.create({\n                    client: clientInstance,\n                    fields: {\n                        cvv: {\n                            selector: '#' + self.getId() + '_cid',\n                            placeholder: '123'\n                        }\n                    }\n                }, function (hostedError, hostedFieldsInstance) {\n                    if (hostedError) {\n                        globalMessageList.addErrorMessage({\n                            message: hostedError.message\n                        });\n                        return;\n                    }\n\n                    self.hostedFieldsInstance = hostedFieldsInstance;\n                    self.onInstanceReady(self.hostedFieldsInstance);\n                });\n            });\n        },\n\n        /**\n         * Return the payment method code.\n         * @returns {string}\n         */\n        getCode: function () {\n            return 'braintree_cc_vault';\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Get show CVV Field\n         * @returns {Boolean}\n         */\n        showCvvVerify: function () {\n            return window.checkoutConfig.payment[this.code].cvvVerify;\n        },\n\n        /**\n         * Show or hide the error message.\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateCvv: function (selector, state) {\n            var $selector = $(selector),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (self.showCvvVerify()) {\n                if (!self.validateCvv('#' + self.getId() + '_cid', self.isValidCvv) || !additionalValidators.validate()) {\n                    return;\n                }\n            } else {\n                if (!additionalValidators.validate()) {\n                    return;\n                }\n            }\n\n            fullScreenLoader.startLoader();\n\n            if (self.showCvvVerify() && typeof self.hostedFieldsInstance !== 'undefined') {\n                self.hostedFieldsInstance.tokenize({}, function (error, payload) {\n                    if (error) {\n                        fullScreenLoader.stopLoader();\n                        globalMessageList.addErrorMessage({\n                            message: error.message\n                        });\n                        return;\n                    }\n                    $.getJSON(\n                        self.updatePaymentUrl,\n                        {\n                            'nonce': payload.nonce,\n                            'public_hash': self.publicHash\n                        }\n                    ).done(function (response) {\n                        if (response.success === false) {\n                            fullScreenLoader.stopLoader();\n                            globalMessageList.addErrorMessage({\n                                message: 'CVV verification failed.'\n                            });\n                            return;\n                        }\n                        self.getPaymentMethodNonce();\n                    })\n                });\n            } else {\n                self.getPaymentMethodNonce();\n            }\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash,\n                'cvv': self.vaultedCVV()\n            }).done(function (response) {\n                fullScreenLoader.stopLoader();\n                self.hostedFields(function (formComponent) {\n                    formComponent.setPaymentMethodNonce(response.paymentMethodNonce);\n                    formComponent.additionalData['public_hash'] = self.publicHash;\n                    formComponent.code = self.code;\n                    if (self.vaultedCVV()) {\n                        formComponent.additionalData['cvv'] = self.vaultedCVV();\n                    }\n\n                    self.validatorManager.validate(formComponent, function () {\n                        fullScreenLoader.stopLoader();\n                        return formComponent.placeOrder('parent');\n                    }, function() {\n                        // No teardown actions required.\n                        fullScreenLoader.stopLoader();\n                        formComponent.setPaymentMethodNonce(null);\n                    });\n\n                });\n            }).fail(function (response) {\n                var error = JSON.parse(response.responseText);\n\n                fullScreenLoader.stopLoader();\n                globalMessageList.addErrorMessage({\n                    message: error.message\n                });\n            });\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'braintree',\n    'braintreeCheckoutPayPalAdapter',\n    'braintreePayPalCheckout',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_CheckoutAgreements/js/view/checkout-agreements',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    braintree,\n    Braintree,\n    paypalCheckout,\n    quote,\n    fullScreenLoader,\n    additionalValidators,\n    stepNavigator,\n    VaultEnabler,\n    createBillingAddress,\n    selectBillingAddress,\n    checkoutAgreements,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal',\n            code: 'braintree_paypal',\n            active: false,\n            paypalInstance: null,\n            paymentMethodNonce: null,\n            grandTotalAmount: null,\n            isReviewRequired: false,\n            customerEmail: null,\n\n            /**\n             * Additional payment data\n             *\n             * {Object}\n             */\n            additionalData: {},\n\n            /**\n             * {Array}\n             */\n            lineItemsArray: [\n                'name',\n                'kind',\n                'quantity',\n                'unitAmount',\n                'unitTaxAmount',\n                'productCode',\n                'description'\n            ],\n\n            /**\n             * PayPal client configuration\n             * {Object}\n             */\n            clientConfig: {\n                offerCredit: false,\n                offerCreditOnly: false,\n                dataCollector: {\n                    paypal: true\n                },\n\n                buttonPayPalId: 'braintree_paypal_placeholder',\n                buttonCreditId: 'braintree_paypal_credit_placeholder',\n                buttonPaylaterId: 'braintree_paypal_paylater_placeholder',\n\n                onDeviceDataRecieved: function (deviceData) {\n                    this.additionalData['device_data'] = deviceData;\n                },\n\n                /**\n                 * Triggers when widget is loaded\n                 * @param {Object} context\n                 */\n                onReady: function (context) {\n                    this.setupPayPal();\n                },\n\n                /**\n                 * Triggers on payment nonce receive\n                 * @param {Object} response\n                 */\n                onPaymentMethodReceived: function (response) {\n                    this.beforePlaceOrder(response);\n                }\n            },\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super()\n                .observe(['active', 'isReviewRequired', 'customerEmail']);\n\n            window.addEventListener('hashchange', function (e) {\n                var methodCode = quote.paymentMethod();\n\n                if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                    if (e.newURL.indexOf('payment') > 0 && self.grandTotalAmount !== null) {\n                        self.reInitPayPal();\n                    }\n                }\n            });\n\n            quote.paymentMethod.subscribe(function (value) {\n                var methodCode = value;\n\n                if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                    self.reInitPayPal();\n                }\n            });\n\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n            this.vaultEnabler.isActivePaymentTokenEnabler.subscribe(function () {\n                self.onVaultPaymentTokenEnablerChange();\n            });\n\n            this.grandTotalAmount = quote.totals()['base_grand_total'];\n\n            quote.totals.subscribe(function () {\n                if (self.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    self.grandTotalAmount = quote.totals()['base_grand_total'];\n                    var methodCode = quote.paymentMethod();\n\n                    if (methodCode && (methodCode.method === 'braintree_paypal' || methodCode.method === 'braintree_paypal_vault')) {\n                        self.reInitPayPal();\n                    }\n                }\n            });\n\n            // for each component initialization need update property\n            this.isReviewRequired(false);\n            this.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Get payment name\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get payment title\n         *\n         * @returns {String}\n         */\n        getTitle: function () {\n            return window.checkoutConfig.payment[this.getCode()].title;\n        },\n\n        /**\n         * Check if payment is active\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            var active = this.getCode() === this.isChecked();\n\n            this.active(active);\n\n            return active;\n        },\n\n        /**\n         * Triggers when payment method change\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                return;\n            }\n\n            // need always re-init Braintree with PayPal configuration\n            this.reInitPayPal();\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n        },\n\n        /**\n         * Set payment nonce\n         * @param {String} paymentMethodNonce\n         */\n        setPaymentMethodNonce: function (paymentMethodNonce) {\n            this.paymentMethodNonce = paymentMethodNonce;\n        },\n\n        /**\n         * Update quote billing address\n         * @param {Object}customer\n         * @param {Object}address\n         */\n        setBillingAddress: function (customer, address) {\n            var billingAddress = {\n                street: [address.line1],\n                city: address.city,\n                postcode: address.postalCode,\n                countryId: address.countryCode,\n                email: customer.email,\n                firstname: customer.firstName,\n                lastname: customer.lastName,\n                telephone: typeof customer.phone !== 'undefined' ? customer.phone : '00000000000'\n            };\n\n            billingAddress['region_code'] = typeof address.state === 'string' ? address.state : '';\n            billingAddress = createBillingAddress(billingAddress);\n            quote.billingAddress(billingAddress);\n        },\n\n        /**\n         * Prepare data to place order\n         * @param {Object} data\n         */\n        beforePlaceOrder: function (data) {\n            this.setPaymentMethodNonce(data.nonce);\n            this.customerEmail(data.details.email);\n            if (quote.isVirtual()) {\n                this.isReviewRequired(true);\n            } else {\n                if (this.isRequiredBillingAddress() === '1' || quote.billingAddress() === null) {\n                    if (typeof data.details.billingAddress !== 'undefined') {\n                        this.setBillingAddress(data.details, data.details.billingAddress);\n                    } else {\n                        this.setBillingAddress(data.details, data.details.shippingAddress);\n                    }\n                } else {\n                    if (quote.shippingAddress() === quote.billingAddress()) {\n                        selectBillingAddress(quote.shippingAddress());\n                    } else {\n                        selectBillingAddress(quote.billingAddress());\n                    }\n                }\n            }\n            this.placeOrder();\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = parseFloat(this.grandTotalAmount).toFixed(2);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = true;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n                this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n            // Send Line Items\n            this.clientConfig.paypal.lineItems = this.getLineItems();\n\n            Braintree.setConfig(this.clientConfig);\n\n            if (Braintree.getPayPalInstance()) {\n                Braintree.getPayPalInstance().teardown(function () {\n                    Braintree.setup();\n                }.bind(this));\n                Braintree.setPayPalInstance(null);\n            } else {\n                Braintree.setup();\n                this.enableButton();\n            }\n        },\n\n        /**\n         * Setup PayPal instance\n         */\n        setupPayPal: function () {\n            var self = this;\n\n            if (Braintree.config.paypalInstance) {\n                fullScreenLoader.stopLoader(true);\n                return;\n            }\n\n            paypalCheckout.create({\n                client: Braintree.clientInstance\n            }, function (createErr, paypalCheckoutInstance) {\n                if (createErr) {\n                    Braintree.showError($t(\"PayPal Checkout could not be initialized. Please contact the store owner.\"));\n                    console.error('paypalCheckout error', createErr);\n                    return;\n                }\n                let quoteObj = quote.totals();\n\n                var configSDK = {\n                    components: 'buttons,messages,funding-eligibility',\n                    \"enable-funding\": \"paylater\",\n                    currency: quoteObj['base_currency_code']\n                };\n                var merchantCountry = window.checkoutConfig.payment['braintree_paypal'].merchantCountry;\n                if (Braintree.getEnvironment() == 'sandbox' && merchantCountry != null) {\n                    configSDK[\"buyer-country\"] = merchantCountry;\n                }\n                paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                    this.loadPayPalButton(paypalCheckoutInstance, 'paypal');\n                    if (this.isCreditEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'credit');\n                    }\n                    if (this.isPaylaterEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'paylater');\n                    }\n\n                }.bind(this));\n            }.bind(this));\n        },\n\n        loadPayPalButton: function (paypalCheckoutInstance, funding) {\n            var paypalPayment = Braintree.config.paypal,\n                onPaymentMethodReceived = Braintree.config.onPaymentMethodReceived;\n            var style = {\n                color: Braintree.getColor(funding),\n                shape: Braintree.getShape(funding),\n                size: Braintree.getSize(funding),\n                label: Braintree.getLabel(funding)\n            };\n\n            if (Braintree.getBranding()) {\n                style.branding = Braintree.getBranding();\n            }\n            if (Braintree.getFundingIcons()) {\n                style.fundingicons = Braintree.getFundingIcons();\n            }\n\n            if (funding === 'credit') {\n                Braintree.config.buttonId = this.clientConfig.buttonCreditId;\n            } else if (funding === 'paylater') {\n                Braintree.config.buttonId = this.clientConfig.buttonPaylaterId;\n            } else {\n                Braintree.config.buttonId = this.clientConfig.buttonPayPalId;\n            }\n            // Render\n            Braintree.config.paypalInstance = paypalCheckoutInstance;\n            var events = Braintree.events;\n            $('#' + Braintree.config.buttonId).html('');\n\n            var button = paypal.Buttons({\n                fundingSource: funding,\n                env: Braintree.getEnvironment(),\n                style: style,\n                commit: true,\n                locale: Braintree.config.paypal.locale,\n\n                onInit: function (data, actions) {\n                    var agreements = checkoutAgreements().agreements,\n                        shouldDisableActions = false;\n\n                    actions.disable();\n\n                    _.each(agreements, function (item, index) {\n                        if (checkoutAgreements().isAgreementRequired(item)) {\n                            var paymentMethodCode = quote.paymentMethod().method,\n                                inputId = '#agreement_' + paymentMethodCode + '_' + item.agreementId,\n                                inputEl = document.querySelector(inputId);\n\n\n                            if (!inputEl.checked) {\n                                shouldDisableActions = true;\n                            }\n\n                            inputEl.addEventListener('change', function (event) {\n                                if (additionalValidators.validate()) {\n                                    actions.enable();\n                                } else {\n                                    actions.disable();\n                                }\n                            });\n                        }\n                    });\n\n                    if (!shouldDisableActions) {\n                        actions.enable();\n                    }\n                },\n\n                createOrder: function () {\n                    return paypalCheckoutInstance.createPayment(paypalPayment).catch(function (err) {\n                        throw err.details.originalError.details.originalError.paymentResource;\n                    });\n                },\n\n                onCancel: function (data) {\n                    console.log('checkout.js payment cancelled', JSON.stringify(data, 0, 2));\n\n                    if (typeof events.onCancel === 'function') {\n                        events.onCancel();\n                    }\n                },\n\n                onError: function (err) {\n                    if (err.errorName === 'VALIDATION_ERROR' && err.errorMessage.indexOf('Value is invalid') !== -1) {\n                        Braintree.showError($t('Address failed validation. Please check and confirm your City, State, and Postal Code'));\n                    } else {\n                        Braintree.showError($t(\"PayPal Checkout could not be initialized. Please contact the store owner.\"));\n                    }\n                    Braintree.config.paypalInstance = null;\n                    console.error('Paypal checkout.js error', err);\n\n                    if (typeof events.onError === 'function') {\n                        events.onError(err);\n                    }\n                }.bind(this),\n\n                onClick: function (data) {\n                    if (!quote.isVirtual()) {\n                        this.clientConfig.paypal.enableShippingAddress = true;\n                        this.clientConfig.paypal.shippingAddressEditable = false;\n                        this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n                    }\n\n                    // To check term & conditions input checked - validate additional validators.\n                    if (!additionalValidators.validate()) {\n                        return false;\n                    }\n\n                    if (typeof events.onClick === 'function') {\n                        events.onClick(data);\n                    }\n                }.bind(this),\n\n                onApprove: function (data, actions) {\n                    return paypalCheckoutInstance.tokenizePayment(data)\n                        .then(function (payload) {\n                            onPaymentMethodReceived(payload);\n                        });\n                }\n\n            });\n            if (button.isEligible() && $('#' + Braintree.config.buttonId).length) {\n                button.render('#' + Braintree.config.buttonId).then(function () {\n                    Braintree.enableButton();\n                    if (typeof Braintree.config.onPaymentMethodError === 'function') {\n                        Braintree.config.onPaymentMethodError();\n                    }\n                }.bind(this)).then(function (data) {\n                    if (typeof events.onRender === 'function') {\n                        events.onRender(data);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Get locale\n         * @returns {String}\n         */\n        getLocale: function () {\n            return window.checkoutConfig.payment[this.getCode()].locale;\n        },\n\n        /**\n         * Is Billing Address required from PayPal side\n         * @returns {exports.isRequiredBillingAddress|(function())|boolean}\n         */\n        isRequiredBillingAddress: function () {\n            return window.checkoutConfig.payment[this.getCode()].isRequiredBillingAddress;\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {},\n                isActiveVaultEnabler = this.isActiveVault();\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: parseFloat(this.grandTotalAmount).toFixed(2),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (isActiveVaultEnabler) {\n                config.paypal.requestBillingAgreement = true;\n            }\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = true;\n                config.paypal.shippingAddressEditable = false;\n                config.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Get shipping address\n         * @returns {Object}\n         */\n        getShippingAddress: function () {\n            var address = quote.shippingAddress();\n\n            return {\n                recipientName: address.firstname + ' ' + address.lastname,\n                line1: address.street[0],\n                line2: typeof address.street[2] === 'undefined' ? address.street[1] : address.street[1] + ' ' + address.street[2],\n                city: address.city,\n                countryCode: address.countryId,\n                postalCode: address.postcode,\n                state: address.regionCode\n            };\n        },\n\n        /**\n         * Get merchant name\n         * @returns {String}\n         */\n        getMerchantName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * Returns payment acceptance mark image path\n         * @returns {String}\n         */\n        getPaymentAcceptanceMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentAcceptanceMarkSrc;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].vaultCode;\n        },\n\n        /**\n         * Check if need to skip order review\n         * @returns {Boolean}\n         */\n        isSkipOrderReview: function () {\n            return window.checkoutConfig.payment[this.getCode()].skipOrderReview;\n        },\n\n        /**\n         * Checks if vault is active\n         * @returns {Boolean}\n         */\n        isActiveVault: function () {\n            return this.vaultEnabler.isVaultEnabled() && this.vaultEnabler.isActivePaymentTokenEnabler();\n        },\n\n        /**\n         * Re-init PayPal Auth flow to use Vault\n         */\n        onVaultPaymentTokenEnablerChange: function () {\n            this.clientConfig.paypal.singleUse = !this.isActiveVault();\n            this.reInitPayPal();\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Triggers when customer click \"Continue to PayPal\" button\n         */\n        payWithPayPal: function () {\n            if (additionalValidators.validate()) {\n                Braintree.checkout.paypal.initAuthFlow();\n            }\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getPayPalButtonId: function () {\n            return this.clientConfig.buttonPayPalId;\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getCreditButtonId: function () {\n            return this.clientConfig.buttonCreditId;\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getPaylaterButtonId: function () {\n            return this.clientConfig.buttonPaylaterId;\n        },\n\n        isPaylaterEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['isActive'];\n        },\n\n        isPaylaterMessageEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['isMessageActive'];\n        },\n\n        getGrandTotalAmount: function () {\n            return parseFloat(this.grandTotalAmount).toFixed(2);\n        },\n\n        isCreditEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_credit']['isActive'];\n        },\n\n        /**\n         * Get Message Layout\n         * @returns {*}\n         */\n        getMessagingLayout: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['layout'];\n        },\n\n        /**\n         * Get Message Logo\n         * @returns {*}\n         */\n        getMessagingLogo: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['logo'];\n        },\n\n        /**\n         * Get Message Logo position\n         * @returns {*}\n         */\n        getMessagingLogoPosition: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['logo_position'];\n        },\n\n        /**\n         * Get Message Text Color\n         * @returns {*}\n         */\n        getMessagingTextColor: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['text_color'];\n        },\n\n        /**\n         * Get line items\n         * @returns {Array}\n         */\n        getLineItems: function () {\n            let self = this;\n            let lineItems = [], storeCredit = 0, giftCardAccount = 0;\n            let giftWrappingItems = 0, giftWrappingOrder = 0;\n            $.each(quote.totals()['total_segments'], function(segmentsKey, segmentsItem) {\n                if (segmentsItem['code'] === 'customerbalance') {\n                    storeCredit = parseFloat(Math.abs(segmentsItem['value']).toString()).toFixed(2);\n                }\n                if (segmentsItem['code'] === 'giftcardaccount') {\n                    giftCardAccount = parseFloat(Math.abs(segmentsItem['value']).toString()).toFixed(2);\n                }\n                if (segmentsItem['code'] === 'giftwrapping') {\n                    let extensionAttributes = segmentsItem['extension_attributes'];\n                    giftWrappingOrder = extensionAttributes['gw_base_price'];\n                    giftWrappingItems = extensionAttributes['gw_items_base_price'];\n                }\n            });\n            if (this.canSendLineItems()) {\n                $.each(quote.getItems(), function(quoteItemKey, quoteItem) {\n                    if (quoteItem.parent_item_id !== null || 0.0 === quoteItem.price) {\n                        return true;\n                    }\n\n                    let itemName = self.replaceUnsupportedCharacters(quoteItem.name);\n                    let itemSku = self.replaceUnsupportedCharacters(quoteItem.sku);\n\n                    let description = '';\n                    let itemQty = parseFloat(quoteItem.qty);\n                    let itemUnitAmount = parseFloat(quoteItem.price);\n                    if (itemQty > Math.floor(itemQty) && itemQty < Math.ceil(itemQty)) {\n                        description = 'Item quantity is ' + itemQty.toFixed(2) + ' and per unit amount is ' + itemUnitAmount.toFixed(2);\n                        itemUnitAmount = parseFloat(itemQty * itemUnitAmount);\n                        itemQty = parseFloat('1');\n                    }\n\n                    let lineItemValues = [\n                        itemName,\n                        'debit',\n                        itemQty.toFixed(2),\n                        itemUnitAmount.toFixed(2),\n                        parseFloat(quoteItem.base_tax_amount).toFixed(2),\n                        itemSku,\n                        description\n                    ];\n\n                    let mappedLineItems = $.map(self.lineItemsArray, function(itemElement, itemIndex) {\n                        return [[\n                            self.lineItemsArray[itemIndex],\n                            lineItemValues[itemIndex]\n                        ]]\n                    });\n\n                    lineItems[quoteItemKey] = Object.fromEntries(mappedLineItems);\n                });\n\n                /**\n                 * Adds credit (refund or discount) kind as LineItems for the\n                 * PayPal transaction if discount amount is greater than 0(Zero)\n                 * as discountAmount lineItem field is not being used by PayPal.\n                 *\n                 * https://developer.paypal.com/braintree/docs/reference/response/transaction-line-item/php#discount_amount\n                 */\n                let baseDiscountAmount = parseFloat(Math.abs(quote.totals()['base_discount_amount']).toString()).toFixed(2);\n                if (baseDiscountAmount > 0) {\n                    let discountLineItem = {\n                        'name': 'Discount',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': baseDiscountAmount\n                    };\n\n                    lineItems = $.merge(lineItems, [discountLineItem]);\n                }\n\n                /**\n                 * Adds shipping as LineItems for the PayPal transaction\n                 * if shipping amount is greater than 0(Zero) to manage\n                 * the totals with client-side implementation as there is\n                 * no any field exist in the client-side implementation\n                 * to send the shipping amount to the Braintree.\n                 */\n                if (quote.totals()['base_shipping_amount'] > 0) {\n                    let shippingLineItem = {\n                        'name': 'Shipping',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': quote.totals()['base_shipping_amount']\n                    };\n\n                    lineItems = $.merge(lineItems, [shippingLineItem]);\n                }\n\n                /**\n                 * Adds credit (Store Credit) kind as LineItems for the\n                 * PayPal transaction if store credit is greater than 0(Zero)\n                 * to manage the totals with client-side implementation\n                 */\n                if (storeCredit > 0) {\n                    let storeCreditItem = {\n                        'name': 'Store Credit',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': storeCredit\n                    };\n\n                    lineItems = $.merge(lineItems, [storeCreditItem]);\n                }\n\n                /**\n                 * Adds Gift Wrapping for items as LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftWrappingItems > 0) {\n                    let gwItems = {\n                        'name': 'Gift Wrapping for Items',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': giftWrappingItems\n                    };\n\n                    lineItems = $.merge(lineItems, [gwItems]);\n                }\n\n                /**\n                 * Adds Gift Wrapping for order as LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftWrappingOrder > 0) {\n                    let gwOrderItem = {\n                        'name': 'Gift Wrapping for Order',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': giftWrappingOrder\n                    };\n\n                    lineItems = $.merge(lineItems, [gwOrderItem]);\n                }\n\n                /**\n                 * Adds Gift Cards as credit LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftCardAccount > 0) {\n                    let giftCardItem = {\n                        'name': 'Gift Cards',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': giftCardAccount\n                    };\n\n                    lineItems = $.merge(lineItems, [giftCardItem]);\n                }\n\n                if (lineItems.length >= 250) {\n                    lineItems = [];\n                }\n            }\n            return lineItems;\n        },\n\n        /**\n         * Regex to replace all unsupported characters.\n         *\n         * @param str\n         */\n        replaceUnsupportedCharacters: function (str) {\n            str.replace('/[^a-zA-Z0-9\\s\\-.\\']/', '');\n            return str.substr(0, 127);\n        },\n\n        /**\n         * Can send line items\n         *\n         * @returns {Boolean}\n         */\n        canSendLineItems: function () {\n            return window.checkoutConfig.payment[this.getCode()].canSendLineItems;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/cc-form.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Checkout/js/model/quote',\n        'PayPal_Braintree/js/view/payment/adapter',\n        'mage/translate',\n        'PayPal_Braintree/js/validator',\n        'PayPal_Braintree/js/view/payment/validator-handler',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        quote,\n        braintree,\n        $t,\n        validator,\n        validatorManager,\n        fullScreenLoader\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                active: false,\n                braintreeClient: null,\n                braintreeDeviceData: null,\n                paymentMethodNonce: null,\n                lastBillingAddress: null,\n                validatorManager: validatorManager,\n                code: 'braintree',\n                isProcessing: false,\n\n                /**\n                 * Additional payment data\n                 *\n                 * {Object}\n                 */\n                additionalData: {},\n\n                /**\n                 * Braintree client configuration\n                 *\n                 * {Object}\n                 */\n                clientConfig: {\n                    onReady: function (context) {\n                        context.setupHostedFields();\n                    },\n\n                    /**\n                     * Triggers on payment nonce receive\n                     * @param {Object} response\n                     */\n                    onPaymentMethodReceived: function (response) {\n                        this.handleNonce(response);\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Allow a new nonce to be generated\n                     */\n                    onPaymentMethodError: function() {\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Device data initialization\n                     * @param {String} deviceData\n                     */\n                    onDeviceDataRecieved: function (deviceData) {\n                        this.additionalData['device_data'] = deviceData;\n                    },\n\n                    /**\n                     * After Braintree instance initialization\n                     */\n                    onInstanceReady: function () {},\n\n                    /**\n                     * Triggers on any Braintree error\n                     * @param {Object} response\n                     */\n                    onError: function (response) {\n                        this.isProcessing = false;\n                        braintree.showError($t('Payment ' + this.getTitle() + ' can\\'t be initialized'));\n                        throw response.message;\n                    },\n\n                    /**\n                     * Triggers when customer click \"Cancel\"\n                     */\n                    onCancelled: function () {\n                        this.paymentMethodNonce = null;\n                        this.isProcessing = false;\n                    }\n                },\n                imports: {\n                    onActiveChange: 'active'\n                }\n            },\n\n            /**\n             * Set list of observable attributes\n             *\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                validator.setConfig(window.checkoutConfig.payment[this.getCode()]);\n                this._super()\n                    .observe(['active']);\n                this.validatorManager.initialize();\n                this.initClientConfig();\n\n                return this;\n            },\n\n            /**\n             * Get payment name\n             *\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Check if payment is active\n             *\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                var active = this.getCode() === this.isChecked();\n\n                this.active(active);\n\n                return active;\n            },\n\n            /**\n             * Triggers when payment method change\n             * @param {Boolean} isActive\n             */\n            onActiveChange: function (isActive) {\n                if (!isActive) {\n                    return;\n                }\n\n                this.initBraintree();\n            },\n\n            /**\n             * Init config\n             */\n            initClientConfig: function () {\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n            },\n\n            /**\n             * Init Braintree configuration\n             */\n            initBraintree: function () {\n                var intervalId = setInterval(function () {\n                    // stop loader when frame will be loaded\n                    if ($('#braintree-hosted-field-number').length) {\n                        clearInterval(intervalId);\n                        fullScreenLoader.stopLoader(true);\n                    }\n                }, 500);\n\n                if (braintree.checkout) {\n                    braintree.checkout.teardown(function () {\n                        braintree.checkout = null;\n                    });\n                }\n\n                fullScreenLoader.startLoader();\n                braintree.setConfig(this.clientConfig);\n                braintree.setup();\n            },\n\n            /**\n             * Get full selector name\n             *\n             * @param {String} field\n             * @returns {String}\n             */\n            getSelector: function (field) {\n                return '#' + this.getCode() + '_' + field;\n            },\n\n            /**\n             * Get list of available CC types\n             *\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                var availableTypes = validator.getAvailableCardTypes(),\n                    billingAddress = quote.billingAddress(),\n                    billingCountryId;\n\n                this.lastBillingAddress = quote.shippingAddress();\n\n                if (!billingAddress) {\n                    billingAddress = this.lastBillingAddress;\n                }\n\n                billingCountryId = billingAddress.countryId;\n\n                if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n                    return validator.collectTypes(\n                        availableTypes,\n                        validator.getCountrySpecificCardTypes(billingCountryId)\n                    );\n                }\n\n                return availableTypes;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getEnvironment: function () {\n                return window.checkoutConfig.payment[this.getCode()].environment;\n            },\n\n            /**\n             * Get data\n             *\n             * @returns {Object}\n             */\n            getData: function () {\n                var data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'g-recaptcha-response' : $(\"#token-grecaptcha-braintree\").val()\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            /**\n             * Set payment nonce\n             * @param {String} paymentMethodNonce\n             */\n            setPaymentMethodNonce: function (paymentMethodNonce) {\n                this.paymentMethodNonce = paymentMethodNonce;\n            },\n\n            /**\n             * Prepare data to place order\n             * @param {Object} data\n             */\n            handleNonce: function (data) {\n                var self = this;\n\n                this.setPaymentMethodNonce(data.nonce);\n\n                // place order on success validation\n                self.validatorManager.validate(self, function () {\n                    return self.placeOrder('parent');\n                }, function() {\n                    self.isProcessing = false;\n                    self.paymentMethodNonce = null;\n                });\n            },\n\n            /**\n             * Action to place order\n             * @param {String} key\n             */\n            placeOrder: function (key) {\n                if (key) {\n                    return this._super();\n                }\n\n                if (this.isProcessing) {\n                    return false;\n                } else {\n                    this.isProcessing = true;\n                }\n\n                braintree.tokenizeHostedFields();\n                return false;\n            },\n\n            /**\n             * Get payment icons\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.braintree.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.braintree.icons[type]\n                    : false;\n            },\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/multishipping/hosted-fields.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/method-renderer/hosted-fields',\n    'PayPal_Braintree/js/validator',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'PayPal_Braintree/js/view/payment/adapter'\n], function (\n    $,\n    Component,\n    validator,\n    messageList,\n    $t,\n    fullScreenLoader,\n    setPaymentInformationAction,\n    additionalValidators,\n    braintree\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/multishipping/form'\n        },\n\n        /**\n         * Get list of available CC types\n         *\n         * @returns {Object}\n         */\n        getCcAvailableTypes: function () {\n            var availableTypes = validator.getAvailableCardTypes(),\n                billingCountryId;\n\n            billingCountryId = $('#multishipping_billing_country_id').val();\n\n            if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n                return validator.collectTypes(\n                    availableTypes, validator.getCountrySpecificCardTypes(billingCountryId)\n                );\n            }\n\n            return availableTypes;\n        },\n\n        /**\n         * @override\n         */\n        handleNonce: function (data) {\n            var self = this;\n            this.setPaymentMethodNonce(data.nonce);\n\n            // place order on success validation\n            self.validatorManager.validate(self, function () {\n                return self.setPaymentInformation();\n            }, function() {\n                self.isProcessing = false;\n                self.paymentMethodNonce = null;\n            });\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (this.isProcessing) {\n                return false;\n            } else {\n                this.isProcessing = true;\n            }\n\n            braintree.tokenizeHostedFields();\n            return false;\n        },\n\n        /**\n         * @override\n         */\n        setPaymentInformation: function () {\n            if (additionalValidators.validate()) {\n                fullScreenLoader.startLoader();\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        this.getData()\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            fullScreenLoader.stopLoader();\n            $('#multishipping-billing-form').submit();\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/multishipping/paypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'braintreeCheckoutPayPalAdapter',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/view/payment/method-renderer/paypal',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Braintree,\n    quote,\n    Component,\n    setPaymentInformationAction,\n    additionalValidators,\n    fullScreenLoader,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/multishipping/paypal',\n            submitButtonSelector: '[id=\"parent-payment-continue\"]',\n            reviewButtonHtml: ''\n        },\n\n        /**\n         * @override\n         */\n        initObservable: function () {\n            this.reviewButtonHtml = $(this.submitButtonSelector).html();\n            return this._super();\n        },\n\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n            this.clientConfig.paypal.enableShippingAddress = false;\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n            this.clientConfig.buttonPayPalId = 'parent-payment-continue';\n\n        },\n\n        /**\n         * @override\n         */\n        onActiveChange: function (isActive) {\n            this.updateSubmitButtonHtml(isActive);\n            this._super(isActive);\n        },\n\n        /**\n         * @override\n         */\n        beforePlaceOrder: function (data) {\n            this._super(data);\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = parseFloat(this.grandTotalAmount).toFixed(2);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = false;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n            }\n\n            Braintree.setConfig(this.clientConfig);\n\n            if (Braintree.getPayPalInstance()) {\n                Braintree.getPayPalInstance().teardown(function () {\n                    Braintree.setup();\n                }.bind(this));\n                Braintree.setPayPalInstance(null);\n            } else {\n                Braintree.setup();\n                this.enableButton();\n            }\n        },\n\n        loadPayPalButton: function (paypalCheckoutInstance, funding) {\n            let paypalPayment = Braintree.config.paypal,\n                onPaymentMethodReceived = Braintree.config.onPaymentMethodReceived;\n            let style = {\n                color: Braintree.getColor(funding),\n                shape: Braintree.getShape(funding),\n                size: Braintree.getSize(funding),\n                label: Braintree.getLabel(funding)\n            };\n\n            if (Braintree.getBranding()) {\n                style.branding = Braintree.getBranding();\n            }\n            if (Braintree.getFundingIcons()) {\n                style.fundingicons = Braintree.getFundingIcons();\n            }\n\n            if (funding === 'credit') {\n                Braintree.config.buttonId = this.clientConfig.buttonCreditId;\n            } else if (funding === 'paylater') {\n                Braintree.config.buttonId = this.clientConfig.buttonPaylaterId;\n            } else {\n                Braintree.config.buttonId = this.clientConfig.buttonPayPalId;\n            }\n\n            // Render\n            Braintree.config.paypalInstance = paypalCheckoutInstance;\n            var events = Braintree.events;\n            $('#' + Braintree.config.buttonId).html('');\n\n            var button = paypal.Buttons({\n                fundingSource: funding,\n                env: Braintree.getEnvironment(),\n                style: style,\n                commit: true,\n                locale: Braintree.config.paypal.locale,\n\n                createOrder: function () {\n                    return paypalCheckoutInstance.createPayment(paypalPayment);\n                },\n\n                onCancel: function (data) {\n                    console.log('checkout.js payment cancelled', JSON.stringify(data, 0, 2));\n\n                    if (typeof events.onCancel === 'function') {\n                        events.onCancel();\n                    }\n                },\n\n                onError: function (err) {\n                    Braintree.showError($t(\"PayPal Checkout could not be initialized. Please contact the store owner.\"));\n                    Braintree.config.paypalInstance = null;\n                    console.error('Paypal checkout.js error', err);\n\n                    if (typeof events.onError === 'function') {\n                        events.onError(err);\n                    }\n                }.bind(this),\n\n                onClick: function (data) {\n                    // To check term & conditions input checked - validate additional validators.\n                    if (!additionalValidators.validate()) {\n                        return false;\n                    }\n\n                    if (typeof events.onClick === 'function') {\n                        events.onClick(data);\n                    }\n                }.bind(this),\n\n                onApprove: function (data, actions) {\n                    return paypalCheckoutInstance.tokenizePayment(data)\n                        .then(function (payload) {\n                            onPaymentMethodReceived(payload);\n                        });\n                }\n\n            });\n            if (button.isEligible() && $('#' + Braintree.config.buttonId).length) {\n\n                button.render('#' + Braintree.config.buttonId).then(function () {\n                    Braintree.enableButton();\n                    if (typeof Braintree.config.onPaymentMethodError === 'function') {\n                        Braintree.config.onPaymentMethodError();\n                    }\n                }.bind(this)).then(function (data) {\n                    if (typeof events.onRender === 'function') {\n                        events.onRender(data);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {},\n                isActiveVaultEnabler = this.isActiveVault();\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: parseFloat(this.grandTotalAmount).toFixed(2),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n                requestBillingAgreement: true,\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = false;\n                config.paypal.shippingAddressEditable = false;\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        getShippingAddress: function () {\n\n            return {};\n        },\n\n        /**\n         * @override\n         */\n        getData: function () {\n            var data = this._super();\n\n            data['additional_data']['is_active_payment_token_enabler'] = true;\n\n            return data;\n        },\n\n        /**\n         * @override\n         */\n        isActiveVault: function () {\n            return true;\n        },\n\n        /**\n         * Skipping order review step on checkout with multiple addresses is not allowed.\n         *\n         * @returns {Boolean}\n         */\n        isSkipOrderReview: function () {\n            return false;\n        },\n\n        /**\n         * Checks if payment method nonce is already received.\n         *\n         * @returns {Boolean}\n         */\n        isPaymentMethodNonceReceived: function () {\n            return this.paymentMethodNonce !== null;\n        },\n\n        /**\n         * Update submit button on multi-addresses checkout billing form.\n         *\n         * @param {Boolean} isActive\n         */\n        updateSubmitButtonHtml: function (isActive) {\n            $(this.submitButtonSelector).removeClass(\"primary\");\n            if (this.isPaymentMethodNonceReceived() || !isActive) {\n                $(this.submitButtonSelector).addClass(\"primary\");\n                $(this.submitButtonSelector).html(this.reviewButtonHtml);\n            }\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            if (!this.isPaymentMethodNonceReceived()) {\n                this.payWithPayPal();\n            } else {\n                fullScreenLoader.startLoader();\n\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        this.getData()\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            fullScreenLoader.stopLoader();\n            $('#multishipping-billing-form').submit();\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/applepay/api.js":"/**\n * Braintree Apple Pay button API\n *\n **/\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'uiComponent',\n        'mage/translate',\n        'mage/storage',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (\n        $,\n        _,\n        Component,\n        $t,\n        storage,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                clientToken: null,\n                quoteId: 0,\n                displayName: null,\n                actionSuccess: null,\n                grandTotalAmount: 0,\n                isLoggedIn: false,\n                storeCode: \"default\",\n                shippingAddress: {},\n                countryDirectory: null,\n                shippingMethods: {}\n            },\n\n            initialize: function () {\n                this._super();\n                if (!this.countryDirectory) {\n                    storage.get(\"rest/V1/directory/countries\").done(function (result) {\n                        this.countryDirectory = {};\n                        let i, data, x, region;\n                        for (i = 0; i < result.length; ++i) {\n                            data = result[i];\n                            this.countryDirectory[data.two_letter_abbreviation] = {};\n                            if (typeof data.available_regions !== 'undefined') {\n                                for (x = 0; x < data.available_regions.length; ++x) {\n                                    region = data.available_regions[x];\n                                    this.countryDirectory[data.two_letter_abbreviation][region.name.toLowerCase().replace(/[^A-Z0-9]/ig, '')] = region.id;\n                                }\n                            }\n                        }\n                    }.bind(this));\n                }\n            },\n\n            /**\n             * Get region ID\n             */\n            getRegionId: function (countryCode, regionName) {\n                if (typeof regionName !== 'string') {\n                    return null;\n                }\n\n                regionName = regionName.toLowerCase().replace(/[^A-Z0-9]/ig, '');\n\n                if (typeof this.countryDirectory[countryCode] !== 'undefined' && typeof this.countryDirectory[countryCode][regionName] !== 'undefined') {\n                    return this.countryDirectory[countryCode][regionName];\n                }\n\n                return 0;\n            },\n\n            /**\n             * Set & get api token\n             */\n            setClientToken: function (value) {\n                this.clientToken = value;\n            },\n            getClientToken: function () {\n                return this.clientToken;\n            },\n\n            /**\n             * Set and get quote id\n             */\n            setQuoteId: function (value) {\n                this.quoteId = value;\n            },\n            getQuoteId: function () {\n                return this.quoteId;\n            },\n\n            /**\n             * Set and get display name\n             */\n            setDisplayName: function (value) {\n                this.displayName = value;\n            },\n            getDisplayName: function () {\n                return this.displayName;\n            },\n\n            /**\n             * Set and get success redirection url\n             */\n            setActionSuccess: function (value) {\n                this.actionSuccess = value;\n            },\n            getActionSuccess: function () {\n                return this.actionSuccess;\n            },\n\n            /**\n             * Set and get grand total\n             */\n            setGrandTotalAmount: function (value) {\n                this.grandTotalAmount = parseFloat(value).toFixed(2);\n            },\n            getGrandTotalAmount: function () {\n                return parseFloat(this.grandTotalAmount);\n            },\n\n            /**\n             * Set and get is logged in\n             */\n            setIsLoggedIn: function (value) {\n                this.isLoggedIn = value;\n            },\n            getIsLoggedIn: function () {\n                return this.isLoggedIn;\n            },\n\n            /**\n             * Set and get store code\n             */\n            setStoreCode: function (value) {\n                this.storeCode = value;\n            },\n            getStoreCode: function () {\n                return this.storeCode;\n            },\n\n            /**\n             * API Urls for logged in / guest\n             */\n            getApiUrl: function (uri) {\n                if (this.getIsLoggedIn() === true) {\n                    return \"rest/\" + this.getStoreCode() + \"/V1/carts/mine/\" + uri;\n                } else {\n                    return \"rest/\" + this.getStoreCode() + \"/V1/guest-carts/\" + this.getQuoteId() + \"/\" + uri;\n                }\n            },\n\n            /**\n             * Payment request info\n             */\n            getPaymentRequest: function () {\n                return {\n                    total: {\n                        label: this.getDisplayName(),\n                        amount: this.getGrandTotalAmount()\n                    },\n                    requiredShippingContactFields: ['postalAddress', 'name', 'email', 'phone'],\n                    requiredBillingContactFields: ['postalAddress', 'name']\n                };\n            },\n\n            /**\n             * Retrieve shipping methods based on address\n             */\n            onShippingContactSelect: function (event, session) {\n                // Get the address.\n                let address = event.shippingContact;\n\n                // Create a payload.\n                let payload = {\n                    address: {\n                        city: address.locality,\n                        region: address.administrativeArea,\n                        country_id: address.countryCode.toUpperCase(),\n                        postcode: address.postalCode,\n                        save_in_address_book: 0\n                    }\n                };\n\n                this.shippingAddress = payload.address;\n\n                // POST to endpoint for shipping methods.\n                storage.post(\n                    this.getApiUrl(\"estimate-shipping-methods\"),\n                    JSON.stringify(payload)\n                ).done(function (result) {\n                    // Stop if no shipping methods.\n                    let virtualFlag = false;\n                    if (result.length === 0) {\n                        let productItems = customerData.get('cart')().items;\n                        _.each(productItems,\n                            function (item) {\n                                if (item.is_virtual || item.product_type == 'bundle') {\n                                    virtualFlag = true;\n                                } else {\n                                    virtualFlag = false;\n                                }\n                            }\n                        );\n                        if (!virtualFlag) {\n                            session.abort();\n                            alert($t(\"There are no shipping methods available for you right now. Please try again or use an alternative payment method.\"));\n                            return false;\n                        }\n                    }\n\n                    let shippingMethods = [];\n                    this.shippingMethods = {};\n\n                    // Format shipping methods array.\n                    for (let i = 0; i < result.length; i++) {\n                        if (typeof result[i].method_code !== 'string') {\n                            continue;\n                        }\n\n                        let method = {\n                            identifier: result[i].method_code,\n                            label: result[i].method_title,\n                            detail: result[i].carrier_title ? result[i].carrier_title : \"\",\n                            amount: parseFloat(result[i].amount).toFixed(2)\n                        };\n\n                        // Add method object to array.\n                        shippingMethods.push(method);\n\n                        this.shippingMethods[result[i].method_code] = result[i];\n\n                        if (!this.shippingMethod) {\n                            this.shippingMethod = result[i].method_code;\n                        }\n                    }\n\n                    // Create payload to get totals\n                    let totalsPayload = {\n                        \"addressInformation\": {\n                            \"address\": {\n                                \"countryId\": this.shippingAddress.country_id,\n                                \"region\": this.shippingAddress.region,\n                                \"regionId\": this.getRegionId(this.shippingAddress.country_id, this.shippingAddress.region),\n                                \"postcode\": this.shippingAddress.postcode\n                            },\n                            \"shipping_method_code\": virtualFlag ? null : this.shippingMethods[shippingMethods[0].identifier].method_code,\n                            \"shipping_carrier_code\": virtualFlag ? null : this.shippingMethods[shippingMethods[0].identifier].carrier_code\n                        }\n                    };\n\n                    // POST to endpoint to get totals, using 1st shipping method\n                    storage.post(\n                        this.getApiUrl(\"totals-information\"),\n                        JSON.stringify(totalsPayload)\n                    ).done(function (result) {\n                        // Set total\n                        this.setGrandTotalAmount(result.base_grand_total);\n\n                        // Pass shipping methods back\n                        session.completeShippingContactSelection(\n                            ApplePaySession.STATUS_SUCCESS,\n                            shippingMethods,\n                            {\n                                label: this.getDisplayName(),\n                                amount: this.getGrandTotalAmount()\n                            },\n                            [{\n                                type: 'final',\n                                label: $t('Shipping'),\n                                amount: virtualFlag ? 0 : shippingMethods[0].amount\n                            }]\n                        );\n                    }.bind(this)).fail(function (result) {\n                        session.abort();\n                        alert($t(\"We're unable to fetch the cart totals for you. Please try an alternative payment method.\"));\n                        console.error(\"Braintree ApplePay: Unable to get totals\", result);\n                        return false;\n                    });\n\n                }.bind(this)).fail(function (result) {\n                    session.abort();\n                    alert($t(\"We're unable to find any shipping methods for you. Please try an alternative payment method.\"));\n                    console.error(\"Braintree ApplePay: Unable to find shipping methods for estimate-shipping-methods\", result);\n                    return false;\n                });\n            },\n\n            /**\n             * Record which shipping method has been selected & Updated totals\n             */\n            onShippingMethodSelect: function (event, session) {\n                let shippingMethod = event.shippingMethod;\n                this.shippingMethod = shippingMethod.identifier;\n\n                let payload = {\n                    \"addressInformation\": {\n                        \"address\": {\n                            \"countryId\": this.shippingAddress.country_id,\n                            \"region\": this.shippingAddress.region,\n                            \"regionId\": this.getRegionId(this.shippingAddress.country_id, this.shippingAddress.region),\n                            \"postcode\": this.shippingAddress.postcode\n                        },\n                        \"shipping_method_code\": this.shippingMethods[this.shippingMethod].method_code,\n                        \"shipping_carrier_code\": this.shippingMethods[this.shippingMethod].carrier_code\n                    }\n                };\n\n                storage.post(\n                    this.getApiUrl(\"totals-information\"),\n                    JSON.stringify(payload)\n                ).done(function (r) {\n                    this.setGrandTotalAmount(r.base_grand_total);\n\n                    session.completeShippingMethodSelection(\n                        ApplePaySession.STATUS_SUCCESS,\n                        {\n                            label: this.getDisplayName(),\n                            amount: this.getGrandTotalAmount()\n                        },\n                        [{\n                            type: 'final',\n                            label: $t('Shipping'),\n                            amount: shippingMethod.amount\n                        }]\n                    );\n                }.bind(this));\n            },\n\n            /**\n             * Place the order\n             */\n            startPlaceOrder: function (nonce, event, session, device_data) {\n                let shippingContact = event.payment.shippingContact,\n                    billingContact = event.payment.billingContact,\n                    payload = {\n                        \"addressInformation\": {\n                            \"shipping_address\": {\n                                \"email\": shippingContact.emailAddress,\n                                \"telephone\": shippingContact.phoneNumber,\n                                \"firstname\": shippingContact.givenName,\n                                \"lastname\": shippingContact.familyName,\n                                \"street\": shippingContact.addressLines,\n                                \"city\": shippingContact.locality,\n                                \"region\": shippingContact.administrativeArea,\n                                \"region_id\": this.getRegionId(shippingContact.countryCode.toUpperCase(), shippingContact.administrativeArea),\n                                \"region_code\": null,\n                                \"country_id\": shippingContact.countryCode.toUpperCase(),\n                                \"postcode\": shippingContact.postalCode,\n                                \"same_as_billing\": 0,\n                                \"customer_address_id\": 0,\n                                \"save_in_address_book\": 0\n                            },\n                            \"billing_address\": {\n                                \"email\": shippingContact.emailAddress,\n                                \"telephone\": shippingContact.phoneNumber,\n                                \"firstname\": billingContact.givenName,\n                                \"lastname\": billingContact.familyName,\n                                \"street\": billingContact.addressLines,\n                                \"city\": billingContact.locality,\n                                \"region\": billingContact.administrativeArea,\n                                \"region_id\": this.getRegionId(billingContact.countryCode.toUpperCase(), billingContact.administrativeArea),\n                                \"region_code\": null,\n                                \"country_id\": billingContact.countryCode.toUpperCase(),\n                                \"postcode\": billingContact.postalCode,\n                                \"same_as_billing\": 0,\n                                \"customer_address_id\": 0,\n                                \"save_in_address_book\": 0\n                            },\n                            \"shipping_method_code\": this.shippingMethod ? this.shippingMethods[this.shippingMethod].method_code : '' ,\n                            \"shipping_carrier_code\": this.shippingMethod ? this.shippingMethods[this.shippingMethod].carrier_code : ''\n                        }\n                    };\n\n                // Set addresses\n                storage.post(\n                    this.getApiUrl(\"shipping-information\"),\n                    JSON.stringify(payload)\n                ).done(function () {\n                    // Submit payment information\n                    let paymentInformation = {\n                            \"email\": shippingContact.emailAddress,\n                            \"paymentMethod\": {\n                                \"method\": \"braintree_applepay\",\n                                \"additional_data\": {\n                                    \"payment_method_nonce\": nonce,\n                                    \"device_data\": device_data\n                                }\n                            }\n                        };\n                    if (window.checkout && window.checkout.agreementIds) {\n                        paymentInformation.paymentMethod.extension_attributes = {\n                            \"agreement_ids\": window.checkout.agreementIds\n                        };\n                    }\n                    storage.post(\n                        this.getApiUrl(\"payment-information\"),\n                        JSON.stringify(paymentInformation)\n                    ).done(function (r) {\n                        document.location = this.getActionSuccess();\n                        session.completePayment(ApplePaySession.STATUS_SUCCESS);\n                    }.bind(this)).fail(function (r) {\n                        session.completePayment(ApplePaySession.STATUS_FAILURE);\n                        session.abort();\n                        alert($t(\"We're unable to take your payment through Apple Pay. Please try an again or use an alternative payment method.\"));\n                        console.error(\"Braintree ApplePay Unable to take payment\", r);\n                        return false;\n                    });\n\n                }.bind(this)).fail(function (r) {\n                    console.error(\"Braintree ApplePay Unable to set shipping information\", r);\n                    session.completePayment(ApplePaySession.STATUS_INVALID_BILLING_POSTAL_ADDRESS);\n                });\n            }\n        });\n    });\n","PayPal_Braintree/js/applepay/button.js":"/**\n * Braintree Apple Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        \"knockout\",\n        \"jquery\",\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeApplePay',\n        'mage/translate',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        ],\n    function (\n        Component,\n        ko,\n        jQuery,\n        braintree,\n        dataCollector,\n        applePay,\n        $t,\n        additionalValidators\n    ) {\n        'use strict';\n\n        var that;\n\n        return {\n            init: function (element, context) {\n                // No element or context\n                if (!element || !context) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a getClientToken method\", context);\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a getPaymentRequest method\", context);\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a startPlaceOrder method\", context);\n                    return;\n                }\n\n                if (this.deviceSupported() === false) {\n                    return;\n                }\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error creating client:', clientErr);\n                        return;\n                    }\n\n                        dataCollector.create({\n                            client: clientInstance\n                        }, function (dataCollectorErr, dataCollectorInstance) {\n                            if (dataCollectorErr) {\n                                return;\n                            }\n\n                            applePay.create({\n                                client: clientInstance\n                            }, function (applePayErr, applePayInstance) {\n                                // No instance\n                                if (applePayErr) {\n                                    console.error('Braintree ApplePay Error creating applePayInstance:', applePayErr);\n                                    return;\n                                }\n\n                                // Create a button within the KO element, as apple pay can only be instantiated through\n                                // a valid on click event (ko onclick bind interferes with this).\n                                var el = document.createElement('div');\n                                el.className = \"braintree-apple-pay-button\";\n                                el.title = $t(\"Pay with Apple Pay\");\n                                el.alt = $t(\"Pay with Apple Pay\");\n                                el.addEventListener('click', function (e) {\n                                    e.preventDefault();\n\n                                    if (!additionalValidators.validate()) {\n                                        return false;\n                                    }\n                                    // Payment request object\n                                    var paymentRequest = applePayInstance.createPaymentRequest(context.getPaymentRequest());\n                                    if (!paymentRequest) {\n                                        alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                        console.error('Braintree ApplePay Unable to create paymentRequest', paymentRequest);\n                                        return;\n                                    }\n\n                                    // Show the loader\n                                    jQuery(\"body\").loader('show');\n\n                                    // Init apple pay session\n                                    try {\n                                        var session = new ApplePaySession(1, paymentRequest);\n                                    } catch (err) {\n                                        jQuery(\"body\").loader('hide');\n                                        console.error('Braintree ApplePay Unable to create ApplePaySession', err);\n                                        alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                        return false;\n                                    }\n\n                                    // Handle invalid merchant\n                                    session.onvalidatemerchant = function (event) {\n                                        applePayInstance.performValidation({\n                                            validationURL: event.validationURL,\n                                            displayName: context.getDisplayName()\n                                        }, function (validationErr, merchantSession) {\n                                            if (validationErr) {\n                                                session.abort();\n                                                console.error('Braintree ApplePay Error validating merchant:', validationErr);\n                                                alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                                return;\n                                            }\n\n                                            session.completeMerchantValidation(merchantSession);\n                                        });\n                                    };\n\n                                    // Attach payment auth event\n                                    session.onpaymentauthorized = function (event) {\n                                        applePayInstance.tokenize({\n                                            token: event.payment.token\n                                        }, function (tokenizeErr, payload) {\n                                            if (tokenizeErr) {\n                                                console.error('Error tokenizing Apple Pay:', tokenizeErr);\n                                                session.completePayment(ApplePaySession.STATUS_FAILURE);\n                                                return;\n                                            }\n\n                                            // Pass the nonce back to the payment method\n                                            context.startPlaceOrder(payload.nonce, event, session, dataCollectorInstance.deviceData);\n                                        });\n                                    };\n\n                                    // Attach onShippingContactSelect method\n                                    if (typeof context.onShippingContactSelect === 'function') {\n                                        session.onshippingcontactselected = function (event) {\n                                            return context.onShippingContactSelect(event, session);\n                                        };\n                                    }\n\n                                    // Attach onShippingMethodSelect method\n                                    if (typeof context.onShippingMethodSelect === 'function') {\n                                        session.onshippingmethodselected = function (event) {\n                                            return context.onShippingMethodSelect(event, session);\n                                        };\n                                    }\n\n                                    // Hook\n                                    if (typeof context.onButtonClick === 'function') {\n                                        context.onButtonClick(session, this, e);\n                                    } else {\n                                        jQuery(\"body\").loader('hide');\n                                        session.begin();\n                                    }\n                                });\n                                element.appendChild(el);\n                            });\n                        });\n\n                });\n            },\n\n            /**\n             * Check the site is using HTTPS & apple pay is supported on this device.\n             * @return boolean\n             */\n            deviceSupported: function () {\n                if (location.protocol != 'https:') {\n                    console.warn(\"Braintree Apple Pay requires your checkout be served over HTTPS\");\n                    return false;\n                }\n\n                if ((window.ApplePaySession && ApplePaySession.canMakePayments()) !== true) {\n                    console.warn(\"Braintree Apple Pay is not supported on this device/browser\");\n                    return false;\n                }\n\n                return true;\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/applepay/implementations/shortcut.js":"/**\n * Braintree Apple Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/applepay/button',\n        'PayPal_Braintree/js/applepay/api',\n        'mage/translate',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                quoteId: 0,\n                displayName: null,\n                actionSuccess: null,\n                grandTotalAmount: 0,\n                isLoggedIn: false,\n                storeCode: \"default\"\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n                if (!this.displayName) {\n                    this.displayName = $t('Store');\n                }\n\n                var api = new buttonApi();\n                api.setGrandTotalAmount(parseFloat(this.grandTotalAmount).toFixed(2));\n                api.setClientToken(this.clientToken);\n                api.setDisplayName(this.displayName);\n                api.setQuoteId(this.quoteId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setIsLoggedIn(this.isLoggedIn);\n                api.setStoreCode(this.storeCode);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/applepay/implementations/core-checkout/method-applepay.js":"define([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment;\n\n    if (config['braintree_applepay'].clientToken) {\n        rendererList.push({\n            type: 'braintree_applepay',\n            component: 'PayPal_Braintree/js/applepay/implementations/core-checkout/method-renderer/applepay'\n        });\n    }\n\n    return Component.extend({});\n});\n","PayPal_Braintree/js/applepay/implementations/core-checkout/method-renderer/applepay.js":"/**\n * Braintree Apple Pay payment method integration.\n **/\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/applepay/button'\n], function (\n    Component,\n    quote,\n    button\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/applepay/core-checkout',\n            paymentMethodNonce: null,\n            deviceData: null,\n            grandTotalAmount: 0,\n            deviceSupported: button.deviceSupported()\n        },\n\n        /**\n         * Inject the apple pay button into the target element\n         */\n        getApplePayBtn: function (id) {\n            button.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n            this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n\n            quote.totals.subscribe(function () {\n                if (this.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Apple pay place order method\n         */\n        startPlaceOrder: function (nonce, event, session, device_data) {\n            this.setPaymentMethodNonce(nonce);\n            this.setDeviceData(device_data);\n            this.placeOrder();\n\n            session.completePayment(ApplePaySession.STATUS_SUCCESS);\n        },\n\n        /**\n         * Save nonce\n         */\n        setPaymentMethodNonce: function (nonce) {\n            this.paymentMethodNonce = nonce;\n        },\n\n        /**\n         * Save nonce\n         */\n        setDeviceData: function (device_data) {\n            this.deviceData = device_data;\n        },\n\n        /**\n         * Retrieve the client token\n         * @returns null|string\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Payment request data\n         */\n        getPaymentRequest: function () {\n            return {\n                total: {\n                    label: this.getDisplayName(),\n                    amount: this.grandTotalAmount\n                }\n            };\n        },\n\n        /**\n         * Merchant display name\n         */\n        getDisplayName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce,\n                    'device_data': this.deviceData\n                }\n            };\n            return data;\n        },\n\n        /**\n         * Return image url for the apple pay mark\n         */\n        getPaymentMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n        }\n    });\n});\n","PayPal_Braintree/js/paypal/product-page.js":"define(\n    ['PayPal_Braintree/js/paypal/button', 'jquery'],\n    function (button, $) {\n        'use strict';\n\n        return button.extend({\n\n            defaults: {\n                label: 'buynow',\n                branding: true,\n            },\n\n            /**\n             * The validation on the add-to-cart form is done after the PayPal window has opened.\n             * This is because the validate method exposed by the PP Button requires an event to disable/enable the button.\n             * We can't fire an event due to the way the mage.validation widget works and we can't do something gross like\n             * an interval because the validation() method shows the error messages and focuses the user's input on the\n             * first erroring input field.\n             * @param payload\n             * @returns {*}\n             */\n            beforeSubmit: function (payload) {\n                var form = $(\"#product_addtocart_form\");\n\n                if (!(form.validation() && form.validation('isValid'))) {\n                    return false;\n                }\n\n                payload.additionalData = form.serialize();\n\n                return payload;\n            }\n        });\n    }\n);","PayPal_Braintree/js/paypal/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/paypal/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'rjsResolver',\n        'uiRegistry',\n        'uiComponent',\n        'underscore',\n        'jquery',\n        'Magento_Customer/js/customer-data',\n        'mage/translate',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreePayPalCheckout',\n        'PayPal_Braintree/js/form-builder',\n        'domReady!'\n    ],\n    function (\n        resolver,\n        registry,\n        Component,\n        _,\n        $,\n        customerData,\n        $t,\n        braintree,\n        dataCollector,\n        paypalCheckout,\n        formBuilder\n    ) {\n        'use strict';\n        let buttonIds = [];\n\n        return {\n            events: {\n                onClick: null,\n                onCancel: null,\n                onError: null\n            },\n\n            /**\n             * @param token\n             * @param currency\n             * @param env\n             * @param local\n             * @param lineItems\n             */\n            init: function (token, currency, env, local, lineItems) {\n                if ($('.action-braintree-paypal-message').length) {\n                    $('.product-add-form form').on('keyup change paste', 'input, select, textarea', function () {\n                        var currentPrice, currencySymbol;\n                        currentPrice = $(\".product-info-main span\").find(\"[data-price-type='finalPrice']\").text();\n                        currencySymbol = $('.action-braintree-paypal-message[data-pp-type=\"product\"]').data('currency-symbol');\n                        $('.action-braintree-paypal-message[data-pp-type=\"product\"]').attr('data-pp-amount', currentPrice.replace(currencySymbol,''));\n                    });\n                }\n\n                buttonIds = [];\n                $('.action-braintree-paypal-logo').each(function () {\n                    if (!$(this).hasClass(\"button-loaded\")) {\n                        $(this).addClass('button-loaded');\n                        buttonIds.push($(this).attr('id'));\n                    }\n                });\n\n                if (buttonIds.length > 0) {\n                    this.loadSDK(token, currency, env, local, lineItems);\n                }\n            },\n\n            /**\n             * Load Braintree PayPal SDK\n             * @param token\n             * @param currency\n             * @param env\n             * @param local\n             * @param lineItems\n             */\n            loadSDK: function (token, currency, env, local, lineItems) {\n                braintree.create({\n                    authorization: token\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('paypalCheckout error', clientErr);\n                        return this.showError(\"PayPal Checkout could not be initialized. Please contact the store owner.\");\n                    }\n                    dataCollector.create({\n                        client: clientInstance,\n                        paypal: true\n                    }, function (err, dataCollectorInstance) {\n                        if (err) {\n                            return console.log(err);\n                        }\n                    });\n                    paypalCheckout.create({\n                        client: clientInstance\n                    }, function (err, paypalCheckoutInstance) {\n                        if (typeof paypal !== 'undefined' ) {\n                            this.renderPayPalButtons(buttonIds, paypalCheckoutInstance, lineItems);\n                            this.renderPayPalMessages();\n                        } else {\n                            var configSDK = {\n                                components: 'buttons,messages,funding-eligibility',\n                                \"enable-funding\": \"paylater\",\n                                currency: currency\n                            };\n                            if (env === 'sandbox' && local !== '') {\n                                configSDK[\"buyer-country\"] = local;\n                            }\n                            paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                                this.renderPayPalButtons(buttonIds, paypalCheckoutInstance, lineItems);\n                                this.renderPayPalMessages();\n                            }.bind(this));\n                        }\n                    }.bind(this));\n                }.bind(this));\n            },\n\n            /**\n             * Render PayPal buttons\n             *\n             * @param ids\n             * @param paypalCheckoutInstance\n             * @param lineItems\n             */\n            renderPayPalButtons: function (ids, paypalCheckoutInstance, lineItems) {\n                _.each(ids, function (id) {\n                    this.payPalButton(id, paypalCheckoutInstance, lineItems);\n                }.bind(this));\n            },\n\n            /**\n             * Render PayPal messages\n             */\n            renderPayPalMessages: function () {\n                $('.action-braintree-paypal-message').each(function () {\n                    paypal.Messages({\n                        amount: $(this).data('pp-amount'),\n                        pageType: $(this).data('pp-type'),\n                        style: {\n                            layout: $(this).data('messaging-layout'),\n                            text: {\n                              color:   $(this).data('messaging-text-color')\n                            },\n                            logo: {\n                                type: $(this).data('messaging-logo'),\n                                position: $(this).data('messaging-logo-position')\n                            }\n                        }\n                    }).render('#' + $(this).attr('id'));\n\n\n                });\n            },\n\n            /**\n             * @param id\n             * @param paypalCheckoutInstance\n             * @param lineItems\n             */\n            payPalButton: function (id, paypalCheckoutInstance, lineItems) {\n                let data = $('#' + id);\n                let style = {\n                    color: data.data('color'),\n                    shape: data.data('shape'),\n                    size: data.data('size'),\n                    label: data.data('label')\n                };\n\n                if (data.data('fundingicons')) {\n                    style.fundingicons = data.data('fundingicons');\n                }\n\n                // Render\n                var paypalActions;\n                var button = paypal.Buttons({\n                    fundingSource: data.data('funding'),\n                    style: style,\n                    createOrder: function () {\n                        return paypalCheckoutInstance.createPayment({\n                            amount: data.data('amount'),\n                            locale: data.data('locale'),\n                            currency: data.data('currency'),\n                            flow: 'checkout',\n                            enableShippingAddress: true,\n                            displayName: data.data('displayname'),\n                            lineItems: $.parseJSON(lineItems)\n                        });\n                    },\n                    validate: function (actions) {\n                        var cart = customerData.get('cart'),\n                            customer = customerData.get('customer'),\n                            declinePayment = false,\n                            isGuestCheckoutAllowed;\n                        isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n                        declinePayment = !customer().firstname && !isGuestCheckoutAllowed;\n                        if (declinePayment) {\n                            actions.disable();\n                        }\n                        paypalActions = actions;\n                    },\n\n                    onCancel: function (data) {\n                        jQuery(\"#maincontent\").trigger('processStop');\n                    },\n\n                    onError: function (err) {\n                        console.error('paypalCheckout button render error', err);\n                        jQuery(\"#maincontent\").trigger('processStop');\n                    },\n\n                    onClick: function (data) {\n                        var cart = customerData.get('cart'),\n                            customer = customerData.get('customer'),\n                            declinePayment = false,\n                            isGuestCheckoutAllowed;\n\n                        isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n                        declinePayment = !customer().firstname && !isGuestCheckoutAllowed && (typeof isGuestCheckoutAllowed !== 'undefined');\n                        if (declinePayment) {\n                            alert($t('To check out, please sign in with your email address.'));\n                        }\n                    },\n\n                    onApprove: function (data1) {\n                        return paypalCheckoutInstance.tokenizePayment(data1, function (err, payload) {\n                            jQuery(\"#maincontent\").trigger('processStart');\n\n                            // Map the shipping address correctly\n                            var address = payload.details.shippingAddress;\n                            var recipientFirstName, recipientLastName;\n                            if (typeof address.recipientName !== 'undefined') {\n                                var recipientName = address.recipientName.split(\" \");\n                                recipientFirstName = recipientName[0].replace(/'/g, \"&apos;\");\n                                recipientLastName = recipientName[1].replace(/'/g, \"&apos;\");\n                            } else {\n                                recipientFirstName = payload.details.firstName.replace(/'/g, \"&apos;\");\n                                recipientLastName = payload.details.lastName.replace(/'/g, \"&apos;\");\n                            }\n                            payload.details.shippingAddress = {\n                                streetAddress: typeof address.line2 !== 'undefined' ? address.line1.replace(/'/g, \"&apos;\") + \" \" + address.line2.replace(/'/g, \"&apos;\") : address.line1.replace(/'/g, \"&apos;\"),\n                                locality: address.city.replace(/'/g, \"&apos;\"),\n                                postalCode: address.postalCode,\n                                countryCodeAlpha2: address.countryCode,\n                                email: payload.details.email.replace(/'/g, \"&apos;\"),\n                                recipientFirstName: recipientFirstName,\n                                recipientLastName: recipientLastName,\n                                telephone: typeof payload.details.phone !== 'undefined' ? payload.details.phone : '',\n                                region: typeof address.state !== 'undefined' ? address.state.replace(/'/g, \"&apos;\") : ''\n                            };\n\n                            payload.details.email = payload.details.email.replace(/'/g, \"&apos;\");\n                            payload.details.firstName = payload.details.firstName.replace(/'/g, \"&apos;\");\n                            payload.details.lastName = payload.details.lastName.replace(/'/g, \"&apos;\");\n                            if (typeof payload.details.businessName !== 'undefined') {\n                                payload.details.businessName = payload.details.businessName.replace(/'/g, \"&apos;\");\n                            }\n\n                            // Map the billing address correctly\n                            let isRequiredBillingAddress = data.data('requiredbillingaddress');\n                            if ((isRequiredBillingAddress === 1) && (typeof payload.details.billingAddress !== 'undefined')) {\n                                var billingAddress = payload.details.billingAddress;\n                                payload.details.billingAddress = {\n                                    streetAddress: typeof billingAddress.line2 !== 'undefined' ? billingAddress.line1.replace(/'/g, \"&apos;\") + \" \" + billingAddress.line2.replace(/'/g, \"&apos;\") : billingAddress.line1.replace(/'/g, \"&apos;\"),\n                                    locality: billingAddress.city.replace(/'/g, \"&apos;\"),\n                                    postalCode: billingAddress.postalCode,\n                                    countryCodeAlpha2: billingAddress.countryCode,\n                                    telephone: typeof payload.details.phone !== 'undefined' ? payload.details.phone : '',\n                                    region: typeof billingAddress.state !== 'undefined' ? billingAddress.state.replace(/'/g, \"&apos;\") : ''\n                                };\n                            }\n\n                            if (data.data('location') == 'productpage') {\n                                var form = $(\"#product_addtocart_form\");\n                                if (!(form.validation() && form.validation('isValid'))) {\n                                    return false;\n                                }\n                                payload.additionalData = form.serialize();\n                            }\n\n                            var actionSuccess = data.data('actionsuccess');\n                            formBuilder.build(\n                                {\n                                    action: actionSuccess,\n                                    fields: {\n                                        result: JSON.stringify(payload)\n                                    }\n                                }\n                            ).submit();\n                        });\n                    }\n                });\n                if (!button.isEligible()) {\n                    console.log('PayPal button is not elligible')\n                    data.parent().remove();\n                    return;\n                }\n                if ($('#' + data.attr('id')).length) {\n                    button.render('#' + data.attr('id'));\n                }\n            },\n        }\n    }\n);\n","PayPal_Braintree/js/paypal/credit/calculator.js":"define([\n    'underscore',\n    'uiComponent',\n    'jquery'\n], function (_, Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: \"PayPal_Braintree/credit/calculator\",\n            displaySummary: true, // \"From X per month\"\n            displayInterestDetails: false, // Display the more in-depth summary of interest rates\n            instalmentsFrom: 0,\n            currentInstalment: {\n                term: 0,\n                monthlyPayment: 0,\n                apr: 0,\n                cost: 0,\n                costIncInterest: 0\n            },\n            endpoint: null,\n            instalments: [],\n            visible: false,\n            merchantName: ''\n        },\n\n        initObservable: function () {\n            this._super();\n            if (this.instalments.length > 0) {\n                this.currentInstalment = this.instalments[0];\n                this.instalmentsFrom = this.instalments[this.instalments.length-1].monthlyPayment;\n                this.visible = true;\n            } else {\n                this.loadInstalments();\n            }\n\n            this.observe(['instalments', 'currentInstalment', 'instalmentsFrom', 'visible']);\n            return this;\n        },\n\n        isCurrentInstalment: function (term) {\n            return (this.currentInstalment().term === term);\n        },\n\n        setCurrentInstalment: function (instalment) {\n            this.currentInstalment(instalment);\n        },\n\n        loadInstalments: function () {\n            if (!this.endpoint) {\n                return false;\n            }\n\n            var self = this;\n            require(['Magento_Checkout/js/model/quote', 'jquery'], function (quote, $) {\n                if (typeof quote.totals().base_grand_total === 'undefined') {\n                    return false;\n                }\n\n                $.getJSON(self.endpoint, {amount: quote.totals().base_grand_total}, function (response) {\n                    self.instalments(response);\n                    self.setCurrentInstalment(response[0]);\n                    self.visible(true);\n                });\n            });\n        }\n    });\n});\n","PayPal_Braintree/js/googlepay/api.js":"/**\n * Braintree Google Pay button api\n **/\ndefine([\n    'uiComponent',\n    'mage/translate',\n    'mage/storage',\n    'jquery',\n    'PayPal_Braintree/js/form-builder'\n], function (Component, $t, storage, jQuery, formBuilder) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            clientToken: null,\n            merchantId: null,\n            currencyCode: null,\n            actionSuccess: null,\n            amount: null,\n            cardTypes: [],\n            btnColor: 0\n        },\n\n        /**\n         * Set & get environment\n         * \"PRODUCTION\" or \"TEST\"\n         */\n        setEnvironment: function (value) {\n            this.environment = value;\n        },\n        getEnvironment: function () {\n            return this.environment;\n        },\n\n        /**\n         * Set & get api token\n         */\n        setClientToken: function (value) {\n            this.clientToken = value;\n        },\n        getClientToken: function () {\n            return this.clientToken;\n        },\n\n        /**\n         * Set and get display name\n         */\n        setMerchantId: function (value) {\n            this.merchantId = value;\n        },\n        getMerchantId: function () {\n            return this.merchantId;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setAmount: function (value) {\n            this.amount = parseFloat(value).toFixed(2);\n        },\n        getAmount: function () {\n            return this.amount;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setCurrencyCode: function (value) {\n            this.currencyCode = value;\n        },\n        getCurrencyCode: function () {\n            return this.currencyCode;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setActionSuccess: function (value) {\n            this.actionSuccess = value;\n        },\n        getActionSuccess: function () {\n            return this.actionSuccess;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setCardTypes: function (value) {\n            this.cardTypes = value;\n        },\n        getCardTypes: function () {\n            return this.cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        setBtnColor: function (value) {\n            this.btnColor = value;\n        },\n        getBtnColor: function () {\n            return this.btnColor;\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n            var result = {\n                transactionInfo: {\n                    totalPriceStatus: 'ESTIMATED',\n                    totalPrice: this.getAmount(),\n                    currencyCode: this.getCurrencyCode()\n                },\n                allowedPaymentMethods: [\n                    {\n                        \"type\": \"CARD\",\n                        \"parameters\": {\n                            \"allowedCardNetworks\": this.getCardTypes(),\n                            \"billingAddressRequired\": true,\n                            \"billingAddressParameters\": {\n                                format: 'FULL',\n                                phoneNumberRequired: true\n                            },\n                        },\n\n                    }\n                ],\n                shippingAddressRequired: true,\n                emailRequired: true,\n            };\n\n            if (this.getEnvironment() !== \"TEST\") {\n                result.merchantInfo = { merchantId: this.getMerchantId() };\n            }\n\n            return result;\n        },\n\n        /**\n         * Place the order\n         */\n        startPlaceOrder: function (nonce, paymentData, deviceData) {\n            var payload = {\n                details: {\n                    shippingAddress: {\n                        streetAddress: paymentData.shippingAddress.address1 + \"\\n\"\n                            + paymentData.shippingAddress.address2,\n                        locality: paymentData.shippingAddress.locality,\n                        postalCode: paymentData.shippingAddress.postalCode,\n                        countryCodeAlpha2: paymentData.shippingAddress.countryCode,\n                        email: paymentData.email,\n                        name: paymentData.shippingAddress.name,\n                        telephone: typeof paymentData.shippingAddress.phoneNumber !== 'undefined' ? paymentData.shippingAddress.phoneNumber : '',\n                        region: typeof paymentData.shippingAddress.administrativeArea !== 'undefined' ? paymentData.shippingAddress.administrativeArea : ''\n                    },\n                    billingAddress: {\n                        streetAddress: paymentData.paymentMethodData.info.billingAddress.address1 + \"\\n\"\n                            + paymentData.paymentMethodData.info.billingAddress.address2,\n                        locality: paymentData.paymentMethodData.info.billingAddress.locality,\n                        postalCode: paymentData.paymentMethodData.info.billingAddress.postalCode,\n                        countryCodeAlpha2: paymentData.paymentMethodData.info.billingAddress.countryCode,\n                        email: paymentData.email,\n                        name: paymentData.paymentMethodData.info.billingAddress.name,\n                        telephone: typeof paymentData.paymentMethodData.info.billingAddress.phoneNumber !== 'undefined' ? paymentData.paymentMethodData.info.billingAddress.phoneNumber : '',\n                        region: typeof paymentData.paymentMethodData.info.billingAddress.administrativeArea !== 'undefined' ? paymentData.paymentMethodData.info.billingAddress.administrativeArea : ''\n                    }\n                },\n                nonce: nonce,\n                deviceData: deviceData,\n            };\n\n            formBuilder.build({\n                action: this.getActionSuccess(),\n                fields: {\n                    result: JSON.stringify(payload)\n                }\n            }).submit();\n        }\n    });\n});\n","PayPal_Braintree/js/googlepay/button.js":"/**\n * Braintree Google Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        \"knockout\",\n        \"jquery\",\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_CheckoutAgreements/js/view/checkout-agreements',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeGooglePay',\n        'mage/translate',\n        'googlePayLibrary'\n    ],\n    function (\n        Component,\n        ko,\n        jQuery,\n        additionalValidators,\n        checkoutAgreements,\n        braintree,\n        dataCollector,\n        googlePay,\n        $t\n    ) {\n        'use strict';\n\n        return {\n            init: function (element, context) {\n\n                // No element or context\n                if (!element || !context ) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a getClientToken method\", context);\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a getPaymentRequest method\", context);\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a startPlaceOrder method\", context);\n                    return;\n                }\n\n                // init google pay object\n                var paymentsClient = new google.payments.api.PaymentsClient({\n                    environment: context.getEnvironment()\n                });\n\n                // Create a button within the KO element, as google pay can only be instantiated through\n                // a valid on click event (ko onclick bind interferes with this).\n                var deviceData;\n                var button = document.createElement('button');\n                button.className = \"braintree-googlepay-button long \" + (context.getBtnColor() == 1 ? 'black' : 'white');\n                button.title = $t(\"Buy with Google Pay\");\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error creating client:', clientErr);\n                        return;\n                    }\n                    dataCollector.create({\n                        client: clientInstance\n                    }, function (dataCollectorErr, dataCollectorInstance) {\n                        if (dataCollectorErr) {\n                            return;\n                        }\n                        googlePay.create({\n                            client: clientInstance,\n                            googlePayVersion: 2\n                        }, function (googlePayErr, googlePaymentInstance) {\n                            // No instance\n                            if (googlePayErr) {\n                                console.error('Braintree GooglePay Error creating googlePayInstance:', googlePayErr);\n                                return;\n                            }\n\n                            paymentsClient.isReadyToPay({\n                                apiVersion: 2,\n                                apiVersionMinor: 0,\n                                allowedPaymentMethods: googlePaymentInstance.createPaymentDataRequest().allowedPaymentMethods\n                            }).then(function(response) {\n                                if (response.result) {\n                                    button.addEventListener('click', function (event) {\n\n                                        var agreements = checkoutAgreements().agreements,\n                                            shouldDisableActions = false;\n\n\n                                        _.each(agreements, function (item, index) {\n                                            if (checkoutAgreements().isAgreementRequired(item)) {\n                                                var inputId = '#agreement_braintree_googlepay_' + item.agreementId,\n                                                    inputEl = document.querySelector(inputId);\n\n                                                if (inputEl !== null && !inputEl.checked) {\n                                                    shouldDisableActions = true;\n                                                }\n\n                                            }\n                                        });\n\n                                        if (!additionalValidators.validate()) {\n                                            event.preventDefault();\n                                            return false;\n                                        }\n\n                                        if (!shouldDisableActions) {\n                                            event.preventDefault();\n                                            jQuery(\"body\").loader('show');\n                                            var responseData;\n\n                                            var paymentDataRequest = googlePaymentInstance.createPaymentDataRequest(context.getPaymentRequest());\n                                            paymentsClient.loadPaymentData(paymentDataRequest).then(function (paymentData) {\n                                                // Persist the paymentData (shipping address etc)\n                                                responseData = paymentData;\n                                                // Return the braintree nonce promise\n                                                return googlePaymentInstance.parseResponse(paymentData);\n                                            }).then(function (result) {\n                                                context.startPlaceOrder(result.nonce, responseData, dataCollectorInstance.deviceData);\n                                            }).catch(function (err) {\n                                                // Handle errors\n                                                // err = {statusCode: \"CANCELED\"}\n                                                console.error(err);\n                                                jQuery(\"body\").loader('hide');\n                                            });\n                                        }\n                                    });\n\n                                    element.appendChild(button);\n                                }\n                            }).catch(function (err) {\n                                console.error(err);\n                                jQuery(\"body\").loader('hide');\n                            });\n                        });\n                    });\n                });\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/googlepay/implementations/shortcut.js":"/**\n * Braintree Google Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/googlepay/button',\n        'PayPal_Braintree/js/googlepay/api',\n        'mage/translate',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                merchantId: null,\n                currencyCode: null,\n                actionSuccess: null,\n                amount: null,\n                environment: \"TEST\",\n                cardType: [],\n                btnColor: 0\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                var api = new buttonApi();\n                api.setEnvironment(this.environment);\n                api.setCurrencyCode(this.currencyCode);\n                api.setClientToken(this.clientToken);\n                api.setMerchantId(this.merchantId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setAmount(this.amount);\n                api.setCardTypes(this.cardTypes)\n                api.setBtnColor(this.btnColor);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-googlepay.js":"define([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment;\n\n    if (config['braintree_googlepay'].clientToken) {\n        rendererList.push({\n            type: 'braintree_googlepay',\n            component: 'PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay'\n        });\n    }\n\n    return Component.extend({});\n});\n","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay.js":"/**\n * Braintree Google Pay payment method integration.\n **/\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/googlepay/button'\n], function (\n    Component,\n    quote,\n    button\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/googlepay/core-checkout',\n            paymentMethodNonce: null,\n            deviceData: null,\n            grandTotalAmount: 0\n        },\n\n        /**\n         * Inject the google pay button into the target element\n         */\n        getGooglePayBtn: function (id) {\n            button.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n            this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n            this.currencyCode = quote.totals()['base_currency_code'];\n\n            quote.totals.subscribe(function () {\n                if (this.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Google pay place order method\n         */\n        startPlaceOrder: function (nonce, paymentData, device_data) {\n            this.setPaymentMethodNonce(nonce);\n            this.setDeviceData(device_data);\n            this.placeOrder();\n        },\n\n        /**\n         * Save nonce\n         */\n        setPaymentMethodNonce: function (nonce) {\n            this.paymentMethodNonce = nonce;\n        },\n\n        /**\n         * Save device_data\n         */\n        setDeviceData: function (device_data) {\n            this.deviceData = device_data;\n        },\n\n        /**\n         * Retrieve the client token\n         * @returns null|string\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n           var result = {\n               transactionInfo: {\n                   totalPriceStatus: 'FINAL',\n                   totalPrice: this.grandTotalAmount,\n                   currencyCode: this.currencyCode\n               },\n               allowedPaymentMethods: [\n                   {\n                       \"type\": \"CARD\",\n                       \"parameters\": {\n                           \"allowedCardNetworks\": this.getCardTypes(),\n                           \"billingAddressRequired\": false,\n                       },\n\n                   }\n               ],\n               shippingAddressRequired: false,\n               emailRequired: false,\n            };\n\n            if (this.getEnvironment() !== \"TEST\") {\n                result.merchantInfo = { merchantId: this.getMerchantId() };\n            }\n\n           return result;\n        },\n\n        /**\n         * Merchant display name\n         */\n        getMerchantId: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantId;\n        },\n\n        /**\n         * Environment\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment[this.getCode()].environment;\n        },\n\n        /**\n         * Card Types\n         */\n        getCardTypes: function () {\n            return window.checkoutConfig.payment[this.getCode()].cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        getBtnColor: function () {\n            return window.checkoutConfig.payment[this.getCode()].btnColor;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce,\n                    'device_data': this.deviceData\n                }\n            };\n        },\n\n        /**\n         * Return image url for the google pay mark\n         */\n        getPaymentMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n        }\n    });\n});\n","PayPal_Braintree/js/reCaptcha/webapiReCaptchaRegistry-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function (originalFunction) {\n        /**\n         * {@inheritDoc}\n         */\n       originalFunction.addListener = function (id , func) {\n            this._listeners[id] = func;\n       };\n\n       return originalFunction;\n    };\n});\n","PayPal_Braintree/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable max-nested-callbacks */\n\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry'\n], function ($, wrapper, recaptchaRegistry) {\n    'use strict';\n\n    return function (placeOrder) {\n        return wrapper.wrap(placeOrder, function (originalAction, serviceUrl, payload, messageContainer) {\n            var recaptchaDeferred;\n\n            if (recaptchaRegistry.triggers.hasOwnProperty('recaptcha-checkout-braintree')) {\n                //ReCaptcha is present for checkout\n                recaptchaDeferred = $.Deferred();\n                recaptchaRegistry.addListener('recaptcha-checkout-braintree', function (token) {\n                    //Add reCaptcha value to place-order request and resolve deferred with the API call results\n                    payload.xReCaptchaValue = token;\n                    originalAction(serviceUrl, payload, messageContainer).done(function () {\n                        recaptchaDeferred.resolve.apply(recaptchaDeferred, arguments);\n                    }).fail(function () {\n                        recaptchaDeferred.reject.apply(recaptchaDeferred, arguments);\n                    });\n                });\n                //Trigger ReCaptcha validation\n                recaptchaRegistry.triggers['recaptcha-checkout-braintree']();\n                //remove listener so that place order action is only triggered by the 'Place Order' button\n                recaptchaRegistry.removeListener('recaptcha-checkout-braintree');\n                return recaptchaDeferred;\n            }\n\n            //No ReCaptcha, just sending the request\n            return originalAction(serviceUrl, payload, messageContainer);\n        });\n    };\n});\n","PayPal_Braintree/js/model/step-navigator-mixin.js":"define([\n    'mage/utils/wrapper',\n    'jquery'\n], function (wrapper, $) {\n    'use strict';\n\n    let mixin = {\n        handleHash: function (originalFn) {\n            var hashString = window.location.hash.replace('#', '');\n            if (hashString.indexOf('venmo') > -1) {\n                return false;\n            }\n\n            return originalFn();\n        }\n    };\n\n    return function (target) {\n        return wrapper.extend(target, mixin);\n    };\n});\n","Magento_Catalog/js/price-option-file.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.priceOptionFile', {\n        options: {\n            fileName: '',\n            fileNamed: '',\n            fieldNameAction: '',\n            changeFileSelector: '',\n            deleteFileSelector: ''\n        },\n\n        /**\n         * Creates instance of widget\n         * @private\n         */\n        _create: function () {\n            this.fileDeleteFlag = this.fileChangeFlag = false;\n            this.inputField = this.element.find('input[name=' + this.options.fileName + ']')[0];\n            this.inputFieldAction = this.element.find('input[name=' + this.options.fieldNameAction + ']')[0];\n            this.fileNameSpan = this.element.parent('dd').find('.' + this.options.fileNamed);\n\n            $(this.options.changeFileSelector).on('click', $.proxy(function () {\n                this._toggleFileChange();\n            }, this));\n            $(this.options.deleteFileSelector).on('click', $.proxy(function () {\n                this._toggleFileDelete();\n            }, this));\n        },\n\n        /**\n         * Toggles whether the current file is being changed or not. If the file is being deleted\n         * then the option to change the file is disabled.\n         * @private\n         */\n        _toggleFileChange: function () {\n            this.element.toggle();\n            this.fileChangeFlag = !this.fileChangeFlag;\n\n            if (!this.fileDeleteFlag) {\n                $(this.inputFieldAction).attr('value', this.fileChangeFlag ? 'save_new' : 'save_old');\n                this.inputField.disabled = !this.fileChangeFlag;\n            }\n        },\n\n        /**\n         * Toggles whether the file is to be deleted. When the file is being deleted, the name of\n         * the file is decorated with strike-through text and the option to change the file is\n         * disabled.\n         * @private\n         */\n        _toggleFileDelete: function () {\n            this.fileDeleteFlag = $(this.options.deleteFileSelector + ':checked').val();\n            $(this.inputFieldAction).attr('value',\n                this.fileDeleteFlag ? '' : this.fileChangeFlag ? 'save_new' : 'save_old');\n            this.inputField.disabled = this.fileDeleteFlag || !this.fileChangeFlag;\n            this.fileNameSpan.css('text-decoration', this.fileDeleteFlag ? 'line-through' : 'none');\n        }\n    });\n\n    return $.mage.priceOptionFile;\n});\n","Magento_Catalog/js/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.compareList', {\n\n        /** @inheritdoc */\n        _create: function () {\n            var elem = this.element,\n                products = $('thead td', elem),\n                headings;\n\n            if (products.length > this.options.productsInRow) {\n                headings = $('<table></table>')\n                    .addClass('comparison headings data table')\n                    .insertBefore(elem.closest('.container'));\n\n                elem.addClass('scroll');\n\n                $('th', elem).each(function () {\n                    var th = $(this),\n                        thCopy = th.clone();\n\n                    th.animate({\n                        top: '+=0'\n                    }, 50, function () {\n                        var height = th.height();\n\n                        thCopy.css('height', height)\n                            .appendTo(headings)\n                            .wrap('<tr></tr>');\n                    });\n                });\n            }\n\n            $(this.options.windowPrintSelector).on('click', function (e) {\n                e.preventDefault();\n                window.print();\n            });\n        }\n    });\n\n    return $.mage.compareList;\n});\n","Magento_Catalog/js/price-option-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'priceUtils',\n    'priceOptions',\n    'jquery-ui-modules/widget'\n], function ($, utils) {\n    'use strict';\n\n    var globalOptions = {\n            fromSelector: 'form',\n            dropdownsSelector: '[data-role=calendar-dropdown]'\n        },\n        optionHandler = {};\n\n    optionHandler.optionHandlers = {};\n\n    /**\n     * Custom handler for Date-with-Dropdowns option type.\n     * @param  {jQuery} siblings\n     * @return {Function} function that return object { optionHash : optionAdditionalPrice }\n     */\n    function onCalendarDropdownChange(siblings) {\n        return function (element, optionConfig) {\n            var changes = {},\n                optionId = utils.findOptionId(element),\n                overhead = optionConfig[optionId].prices,\n                isNeedToUpdate = true,\n                optionHash = 'price-option-calendar-' + optionId;\n\n            siblings.each(function (index, el) {\n                isNeedToUpdate = isNeedToUpdate && !!$(el).val();\n            });\n\n            overhead = isNeedToUpdate ? overhead : {};\n            changes[optionHash] = overhead;\n\n            return changes;\n        };\n    }\n\n    /**\n     * Returns number of days for special month and year\n     * @param  {Number} month\n     * @param  {Number} year\n     * @return {Number}\n     */\n    function getDaysInMonth(month, year) {\n        return new Date(year, month, 0).getDate();\n    }\n\n    /**\n     * Adjusts the number of days in the day option element based on which month or year\n     * is selected (changed). Adjusts the days to 28, 29, 30, or 31 typically.\n     * @param {jQuery} dropdowns\n     */\n    function onDateChange(dropdowns) {\n        var daysNodes,\n            curMonth, curYear, expectedDays,\n            options, needed,\n            month = dropdowns.filter('[data-calendar-role=month]'),\n            year = dropdowns.filter('[data-calendar-role=year]');\n\n        if (month.length && year.length) {\n            daysNodes = dropdowns.filter('[data-calendar-role=day]').find('option');\n\n            curMonth = month.val() || '01';\n            curYear = year.val() || '2000';\n            expectedDays = getDaysInMonth(curMonth, curYear);\n\n            if (daysNodes.length - 1 > expectedDays) { // remove unnecessary option nodes\n                daysNodes.each(function (i, e) {\n                    if (e.value > expectedDays) {\n                        $(e).remove();\n                    }\n                });\n            } else if (daysNodes.length - 1 < expectedDays) { // add missing option nodes\n                options = [];\n                needed = expectedDays - daysNodes.length + 1;\n\n                while (needed--) { //eslint-disable-line max-depth\n                    options.push(\n                        '<option value=\"' + (expectedDays - needed) + '\">' + (expectedDays - needed) + '</option>'\n                    );\n                }\n                $(options.join('')).insertAfter(daysNodes.last());\n            }\n        }\n    }\n\n    $.widget('mage.priceOptionDate', {\n        options: globalOptions,\n\n        /**\n         * Function-initializer of priceOptionDate widget\n         * @private\n         */\n        _create: function initOptionDate() {\n            var field = this.element,\n                form = field.closest(this.options.fromSelector),\n                dropdowns = $(this.options.dropdownsSelector, field),\n                dateOptionId;\n\n            if (dropdowns.length) {\n                dateOptionId = this.options.dropdownsSelector + dropdowns.attr('name');\n\n                optionHandler.optionHandlers[dateOptionId] = onCalendarDropdownChange(dropdowns);\n\n                form.priceOptions(optionHandler);\n\n                dropdowns.data('role', dateOptionId);\n                dropdowns.on('change', onDateChange.bind(this, dropdowns));\n            }\n        }\n    });\n\n    return $.mage.priceOptionDate;\n});\n","Magento_Catalog/js/related-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.relatedProducts', {\n        options: {\n            relatedCheckbox: '.related-checkbox', // Class name for a related product's input checkbox.\n            relatedProductsCheckFlag: false, // Related products checkboxes are initially unchecked.\n            relatedProductsField: '#related-products-field', // Hidden input field that stores related products.\n            selectAllMessage: $.mage.__('select all'),\n            unselectAllMessage: $.mage.__('unselect all'),\n            selectAllLink: '[data-role=\"select-all\"]',\n            elementsSelector: '.item.product'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            $(this.options.selectAllLink, this.element).on('click', $.proxy(this._selectAllRelated, this));\n            $(this.options.relatedCheckbox, this.element).on('click', $.proxy(this._addRelatedToProduct, this));\n\n            if (this.element.data('shuffle')) {\n                this._shuffle(this.element.find(this.options.elementsSelector));\n            }\n            this._showRelatedProducts(\n                this.element.find(this.options.elementsSelector),\n                this.element.data('limit'),\n                this.element.data('shuffle-weighted')\n            );\n        },\n\n        /**\n         * This method either checks all checkboxes for a product's set of related products (select all)\n         * or unchecks them (unselect all).\n         * @private\n         * @param {jQuery.Event} e - Click event on either the \"select all\" link or the \"unselect all\" link.\n         * @return {Boolean} - Prevent default event action and event propagation.\n         */\n        _selectAllRelated: function (e) {\n            var innerHTML = this.options.relatedProductsCheckFlag ?\n                this.options.selectAllMessage : this.options.unselectAllMessage;\n\n            $(e.target).html(innerHTML);\n            $(this.options.relatedCheckbox + ':visible').attr(\n                'checked',\n                this.options.relatedProductsCheckFlag = !this.options.relatedProductsCheckFlag\n            );\n            this._addRelatedToProduct();\n\n            return false;\n        },\n\n        /**\n         * This method iterates through each checkbox for all related products and collects only those products\n         * whose checkbox has been checked. The selected related products are stored in a hidden input field.\n         * @private\n         */\n        _addRelatedToProduct: function () {\n            $(this.options.relatedProductsField).val(\n                $(this.options.relatedCheckbox + ':checked').map(function () {\n                    return this.value;\n                }).get().join(',')\n            );\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Show related products according to limit. Shuffle if needed.\n         * @param {*} elements\n         * @param {*} limit\n         * @param weightedRandom\n         * @private\n         */\n        _showRelatedProducts: function (elements, limit, weightedRandom) {\n            var index, weights = [], random = [], weight = 2, shown = 0, $element, currentGroup, prevGroup;\n\n            if (limit === 0) {\n                limit = elements.length;\n            }\n\n            if (weightedRandom && limit > 0 && limit < elements.length) {\n                for (index = 0; index < limit; index++) {\n                    $element = $(elements[index]);\n                    if ($element.data('shuffle-group') !== '') {\n                        break;\n                    }\n                    $element.show();\n                    shown++;\n                }\n                limit -= shown;\n                for (index = elements.length - 1; index >= 0; index--) {\n                    $element = $(elements[index]);\n                    currentGroup = $element.data('shuffle-group');\n                    if (currentGroup !== '') {\n                        weights.push([index, Math.log(weight)]);\n                        if (typeof prevGroup !== 'undefined' && prevGroup !== currentGroup) {\n                            weight += 2;\n                        }\n                        prevGroup = currentGroup;\n                    }\n                }\n\n                if (weights.length === 0) {\n                    return;\n                }\n\n                for (index = 0; index < weights.length; index++) {\n                    random.push([weights[index][0], Math.pow(Math.random(), 1 / weights[index][1])]);\n                }\n\n                random.sort(function(a, b) {\n                    a = a[1];\n                    b = b[1];\n                    return a < b ? 1 : (a > b ? -1 : 0);\n                });\n                index = 0;\n                while (limit) {\n                    $(elements[random[index][0]]).show();\n                    limit--;\n                    index++\n                }\n                return;\n            }\n\n            for (index = 0; index < limit; index++) {\n                $(elements[index]).show();\n            }\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Shuffle an array\n         * @param {Array} elements\n         * @returns {*}\n         */\n        _shuffle: function shuffle(elements) {\n            var parent, child, lastSibling;\n            if (elements.length) {\n                parent = $(elements[0]).parent();\n            }\n            while (elements.length) {\n                child = elements.splice(Math.floor(Math.random() *  elements.length), 1)[0];\n                lastSibling = parent.find('[data-shuffle-group=\"' + $(child).data('shuffle-group') + '\"]').last();\n                lastSibling.after(child);\n            }\n        }\n\n        /* jscs:disable */\n        /* eslint:disable */\n    });\n\n    return $.mage.relatedProducts;\n});\n","Magento_Catalog/js/price-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery-ui-modules/widget'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        optionTemplate: '<%= data.label %>' +\n        '<% if (data.finalPrice.value > 0) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } else if (data.finalPrice.value < 0) { %>' +\n        ' <%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig) {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            $(this.options.optionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions() {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event) {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig[optionId];\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue] ? optionConfig[optionValue].prices : null;\n\n                    if (prices) {\n                        _.each(prices, function (price, type) {\n                            var value = +price.amount;\n\n                            value += _.reduce(price.adjustments, function (sum, x) { //eslint-disable-line\n                                return sum + x;\n                            }, 0);\n                            toTemplate.data[type] = {\n                                value: value,\n                                formatted: utils.formatPriceLocale(value, format)\n                            };\n                        });\n\n                        $option.text(template(toTemplate));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         * @private\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n            this._super(options);\n\n            return this;\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Magento_Catalog/js/price-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var globalPriceFormat = {\n        requiredPrecision: 2,\n        integerRequired: 1,\n        decimalSymbol: ',',\n        groupSymbol: ',',\n        groupLength: ','\n    };\n\n    /**\n     * Repeats {string} {times} times\n     * @param  {String} string\n     * @param  {Number} times\n     * @return {String}\n     */\n    function stringPad(string, times) {\n        return new Array(times + 1).join(string);\n    }\n\n    /**\n     * Format the price with the compliance to the specified locale\n     *\n     * @param {Number} amount\n     * @param {Object} format\n     * @param  {Boolean} isShowSign\n     */\n    function formatPriceLocale(amount, format, isShowSign)\n    {\n        var s = '',\n            precision, pattern, locale, r;\n\n        format = _.extend(globalPriceFormat, format);\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        pattern = format.pattern || '%s';\n        locale = window.LOCALE || 'en-US';\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n        amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision));\n        r = amount.toLocaleString(locale, {minimumFractionDigits: precision});\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Formatter for price amount\n     * @param  {Number}  amount\n     * @param  {Object}  format\n     * @param  {Boolean} isShowSign\n     * @return {String}              Formatted value\n     * @deprecated\n     */\n    function formatPrice(amount, format, isShowSign) {\n        var s = '',\n            precision, integerRequired, decimalSymbol, groupSymbol, groupLength, pattern, i, pad, j, re, r, am;\n\n        format = _.extend(globalPriceFormat, format);\n\n        // copied from price-option.js | Could be refactored with varien/js.js\n\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        integerRequired = isNaN(format.integerRequired = Math.abs(format.integerRequired)) ? 1 : format.integerRequired;\n        decimalSymbol = format.decimalSymbol === undefined ? ',' : format.decimalSymbol;\n        groupSymbol = format.groupSymbol === undefined ? '.' : format.groupSymbol;\n        groupLength = format.groupLength === undefined ? 3 : format.groupLength;\n        pattern = format.pattern || '%s';\n\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n\n        // we're avoiding the usage of to fixed, and using round instead with the e representation to address\n        // numbers like 1.005 = 1.01. Using ToFixed to only provide trailing zeroes in case we have a whole number\n        i = parseInt(\n                amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision)),\n                10\n            ) + '';\n        pad = i.length < integerRequired ? integerRequired - i.length : 0;\n\n        i = stringPad('0', pad) + i;\n\n        j = i.length > groupLength ? i.length % groupLength : 0;\n        re = new RegExp('(\\\\d{' + groupLength + '})(?=\\\\d)', 'g');\n\n        // replace(/-/, 0) is only for fixing Safari bug which appears\n        // when Math.abs(0).toFixed() executed on '0' number.\n        // Result is '0.-0' :(\n\n        am = Number(Math.round(Math.abs(amount - i) + 'e+' + precision) + ('e-' + precision));\n        r = (j ? i.substr(0, j) + groupSymbol : '') +\n            i.substr(j).replace(re, '$1' + groupSymbol) +\n            (precision ? decimalSymbol + am.toFixed(precision).replace(/-/, 0).slice(2) : '');\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Deep clone of Object. Doesn't support functions\n     * @param {Object} obj\n     * @return {Object}\n     */\n    function objectDeepClone(obj) {\n        return JSON.parse(JSON.stringify(obj));\n    }\n\n    /**\n     * Helper to find ID in name attribute\n     * @param   {jQuery} element\n     * @returns {undefined|String}\n     */\n    function findOptionId(element) {\n        var re, id, name;\n\n        if (!element) {\n            return id;\n        }\n        name = $(element).attr('name');\n\n        if (name.indexOf('[') !== -1) {\n            re = /\\[([^\\]]+)?\\]/;\n        } else {\n            re = /_([^\\]]+)?_/; // just to support file-type-option\n        }\n        id = re.exec(name) && re.exec(name)[1];\n\n        if (id) {\n            return id;\n        }\n    }\n\n    return {\n        formatPriceLocale: formatPriceLocale,\n        formatPrice: formatPrice,\n        deepClone: objectDeepClone,\n        strPad: stringPad,\n        findOptionId: findOptionId\n    };\n});\n","Magento_Catalog/js/validate-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/mage',\n    'Magento_Catalog/product/view/validation',\n    'catalogAddToCart'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.productValidate', {\n        options: {\n            bindSubmit: false,\n            radioCheckboxClosest: '.nested',\n            addToCartButtonSelector: '.action.tocart'\n        },\n\n        /**\n         * Uses Magento's validation widget for the form object.\n         * @private\n         */\n        _create: function () {\n            var bindSubmit = this.options.bindSubmit;\n\n            this.element.validation({\n                radioCheckboxClosest: this.options.radioCheckboxClosest,\n\n                /**\n                 * Uses catalogAddToCart widget as submit handler.\n                 * @param {Object} form\n                 * @returns {Boolean}\n                 */\n                submitHandler: function (form) {\n                    var jqForm = $(form).catalogAddToCart({\n                        bindSubmit: bindSubmit\n                    });\n\n                    jqForm.catalogAddToCart('submitForm', jqForm);\n\n                    return false;\n                }\n            });\n            $(this.options.addToCartButtonSelector).attr('disabled', false);\n        }\n    });\n\n    return $.mage.productValidate;\n});\n","Magento_Catalog/js/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, utils, _, mageTemplate) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceConfig: null,\n        prices: {},\n        priceTemplate: '<span class=\"price\"><%- data.formatted %></span>'\n    };\n\n    $.widget('mage.priceBox', {\n        options: globalOptions,\n        qtyInfo: '#qty',\n\n        /**\n         * Widget initialisation.\n         * Every time when option changed prices also can be changed. So\n         * changed options.prices -> changed cached prices -> recalculation -> redraw price box\n         */\n        _init: function initPriceBox() {\n            var box = this.element;\n\n            box.trigger('updatePrice');\n            this.cache.displayPrices = utils.deepClone(this.options.prices);\n        },\n\n        /**\n         * Widget creating.\n         */\n        _create: function createPriceBox() {\n            var box = this.element;\n\n            this.cache = {};\n            this._setDefaultsFromPriceConfig();\n            this._setDefaultsFromDataSet();\n\n            box.on('reloadPrice', this.reloadPrice.bind(this));\n            box.on('updatePrice', this.onUpdatePrice.bind(this));\n            $(this.qtyInfo).on('input', this.updateProductTierPrice.bind(this));\n            box.trigger('price-box-initialized');\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updatePrice method.\n         * @param {Event} event\n         * @param {Object} prices\n         */\n        onUpdatePrice: function onUpdatePrice(event, prices) {\n            return this.updatePrice(prices);\n        },\n\n        /**\n         * Updates price via new (or additional values).\n         * It expects object like this:\n         * -----\n         *   \"option-hash\":\n         *      \"price-code\":\n         *         \"amount\": 999.99999,\n         *         ...\n         * -----\n         * Empty option-hash object or empty price-code object treats as zero amount.\n         * @param {Object} newPrices\n         */\n        updatePrice: function updatePrice(newPrices) {\n            var prices = this.cache.displayPrices,\n                additionalPrice = {},\n                pricesCode = [],\n                priceValue, origin, finalPrice;\n\n            this.cache.additionalPriceObject = this.cache.additionalPriceObject || {};\n\n            if (newPrices) {\n                $.extend(this.cache.additionalPriceObject, newPrices);\n            }\n\n            if (!_.isEmpty(additionalPrice)) {\n                pricesCode = _.keys(additionalPrice);\n            } else if (!_.isEmpty(prices)) {\n                pricesCode = _.keys(prices);\n            }\n\n            _.each(this.cache.additionalPriceObject, function (additional) {\n                if (additional && !_.isEmpty(additional)) {\n                    pricesCode = _.keys(additional);\n                }\n                _.each(pricesCode, function (priceCode) {\n                    priceValue = additional[priceCode] || {};\n                    priceValue.amount = +priceValue.amount || 0;\n                    priceValue.adjustments = priceValue.adjustments || {};\n\n                    additionalPrice[priceCode] = additionalPrice[priceCode] || {\n                        'amount': 0,\n                        'adjustments': {}\n                    };\n                    additionalPrice[priceCode].amount =  0 + (additionalPrice[priceCode].amount || 0) +\n                        priceValue.amount;\n                    _.each(priceValue.adjustments, function (adValue, adCode) {\n                        additionalPrice[priceCode].adjustments[adCode] = 0 +\n                            (additionalPrice[priceCode].adjustments[adCode] || 0) + adValue;\n                    });\n                });\n            });\n\n            if (_.isEmpty(additionalPrice)) {\n                this.cache.displayPrices = utils.deepClone(this.options.prices);\n            } else {\n                _.each(additionalPrice, function (option, priceCode) {\n                    origin = this.options.prices[priceCode] || {};\n                    finalPrice = prices[priceCode] || {};\n                    option.amount = option.amount || 0;\n                    origin.amount = origin.amount || 0;\n                    origin.adjustments = origin.adjustments || {};\n                    finalPrice.adjustments = finalPrice.adjustments || {};\n\n                    finalPrice.amount = 0 + origin.amount + option.amount;\n                    _.each(option.adjustments, function (pa, paCode) {\n                        finalPrice.adjustments[paCode] = 0 + (origin.adjustments[paCode] || 0) + pa;\n                    });\n                }, this);\n            }\n\n            this.element.trigger('priceUpdated', this.cache.displayPrices);\n            this.element.trigger('reloadPrice');\n        },\n\n        /*eslint-disable no-extra-parens*/\n        /**\n         * Render price unit block.\n         */\n        reloadPrice: function reDrawPrices() {\n            var priceFormat = (this.options.priceConfig && this.options.priceConfig.priceFormat) || {},\n                priceTemplate = mageTemplate(this.options.priceTemplate);\n\n            _.each(this.cache.displayPrices, function (price, priceCode) {\n                price.final = _.reduce(price.adjustments, function (memo, amount) {\n                    return memo + amount;\n                }, price.amount);\n\n                price.formatted = utils.formatPriceLocale(price.final, priceFormat);\n\n                $('[data-price-type=\"' + priceCode + '\"]', this.element).html(priceTemplate({\n                    data: price\n                }));\n            }, this);\n        },\n\n        /*eslint-enable no-extra-parens*/\n        /**\n         * Overwrites initial (default) prices object.\n         * @param {Object} prices\n         */\n        setDefault: function setDefaultPrices(prices) {\n            this.cache.displayPrices = utils.deepClone(prices);\n            this.options.prices = utils.deepClone(prices);\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge of accepted configuration.\n         * @param  {Object} options\n         * @return {mage.priceBox}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            if ('disabled' in options) {\n                this._setOption('disabled', options.disabled);\n            }\n\n            return this;\n        },\n\n        /**\n         * setDefaultsFromDataSet\n         */\n        _setDefaultsFromDataSet: function _setDefaultsFromDataSet() {\n            var box = this.element,\n                priceHolders = $('[data-price-type]', box),\n                prices = this.options.prices;\n\n            this.options.productId = box.data('productId');\n\n            if (_.isEmpty(prices)) {\n                priceHolders.each(function (index, element) {\n                    var type = $(element).data('priceType'),\n                        amount = parseFloat($(element).data('priceAmount'));\n\n                    if (type && !_.isNaN(amount)) {\n                        prices[type] = {\n                            amount: amount\n                        };\n                    }\n                });\n            }\n        },\n\n        /**\n         * setDefaultsFromPriceConfig\n         */\n        _setDefaultsFromPriceConfig: function _setDefaultsFromPriceConfig() {\n            var config = this.options.priceConfig;\n\n            if (config && config.prices) {\n                this.options.prices = config.prices;\n            }\n        },\n\n        /**\n         * Updates product final and base price according to tier prices\n         */\n        updateProductTierPrice: function updateProductTierPrice() {\n            var originalPrice,\n                prices = {'prices': {}};\n\n            if (this.options.prices.finalPrice) {\n                originalPrice = this.options.prices.finalPrice.amount;\n                prices.prices.finalPrice = {'amount': this.getPrice('price') - originalPrice};\n            }\n\n            if (this.options.prices.basePrice) {\n                originalPrice = this.options.prices.basePrice.amount;\n                prices.prices.basePrice = {'amount': this.getPrice('basePrice') - originalPrice};\n            }\n\n            this.updatePrice(prices);\n        },\n\n        /**\n         * Returns price.\n         *\n         * @param {String} priceKey\n         * @returns {Number}\n         */\n        getPrice: function (priceKey) {\n            var productQty = $(this.qtyInfo).val(),\n                result,\n                tierPriceItem,\n                i;\n\n            for (i = 0; i < this.options.priceConfig.tierPrices.length; i++) {\n                tierPriceItem = this.options.priceConfig.tierPrices[i];\n                if (productQty >= tierPriceItem.qty && tierPriceItem[priceKey]) {\n                    result = tierPriceItem[priceKey];\n                }\n            }\n\n            return result;\n        }\n    });\n\n    return $.mage.priceBox;\n});\n","Magento_Catalog/js/gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.gallery', {\n        options: {\n            minWidth: 300, // Minimum width of the gallery image.\n            widthOffset: 90, // Offset added to the width of the gallery image.\n            heightOffset: 210, // Offset added to the height of the gallery image.\n            closeWindow: 'div.buttons-set a[role=\"close-window\"]' // Selector for closing the gallery popup window.\n        },\n\n        /**\n         * Bind click handler for closing the popup window and resize the popup based on the image size.\n         * @private\n         */\n        _create: function () {\n            $(this.options.closeWindow).on('click', function () {\n                window.close();\n            });\n            this._resizeWindow();\n        },\n\n        /**\n         * Resize the gallery image popup window based on the image's dimensions.\n         * @private\n         */\n        _resizeWindow: function () {\n            var img = this.element,\n                width = img.width() < this.options.minWidth ? this.options.minWidth : img.width();\n\n            window.resizeTo(width + this.options.widthOffset, img.height() + this.options.heightOffset);\n        }\n    });\n\n    return $.mage.gallery;\n});\n","Magento_Catalog/js/upsell-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.upsellProducts', {\n        options: {\n            elementsSelector: '.item.product'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            if (this.element.data('shuffle')) {\n                this._shuffle(this.element.find(this.options.elementsSelector));\n            }\n            this._showUpsellProducts(\n                this.element.find(this.options.elementsSelector),\n                this.element.data('limit'),\n                this.element.data('shuffle-weighted')\n            );\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Show upsell products according to limit. Shuffle if needed.\n         * @param {*} elements\n         * @param {Number} limit\n         * @param {Boolean} weightedRandom\n         * @private\n         */\n        _showUpsellProducts: function (elements, limit, weightedRandom) {\n            var index, weights = [], random = [], weight = 2, shown = 0, $element, currentGroup, prevGroup;\n\n            if (limit === 0) {\n                limit = elements.length;\n            }\n\n            if (weightedRandom && limit > 0 && limit < elements.length) {\n                for (index = 0; index < limit; index++) {\n                    $element = $(elements[index]);\n                    if ($element.data('shuffle-group') !== '') {\n                        break;\n                    }\n                    $element.show();\n                    shown++;\n                }\n                limit -= shown;\n                for (index = elements.length - 1; index >= 0; index--) {\n                    $element = $(elements[index]);\n                    currentGroup = $element.data('shuffle-group');\n                    if (currentGroup !== '') {\n                        weights.push([index, Math.log(weight)]);\n                        if (typeof prevGroup !== 'undefined' && prevGroup !== currentGroup) {\n                            weight += 2;\n                        }\n                        prevGroup = currentGroup;\n                    }\n                }\n\n                if (weights.length === 0) {\n                    return;\n                }\n\n                for (index = 0; index < weights.length; index++) {\n                    random.push([weights[index][0], Math.pow(Math.random(), 1 / weights[index][1])]);\n                }\n\n                random.sort(function(a, b) {\n                    a = a[1];\n                    b = b[1];\n                    return a < b ? 1 : (a > b ? -1 : 0);\n                });\n                index = 0;\n                while (limit) {\n                    $(elements[random[index][0]]).show();\n                    limit--;\n                    index++\n                }\n                return;\n            }\n\n            for (index = 0; index < limit; index++) {\n                $(elements[index]).show();\n            }\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Shuffle an array\n         * @param elements\n         * @returns {*}\n         */\n        _shuffle: function shuffle(elements){ //v1.0\n            var parent, child, lastSibling;\n            if (elements.length) {\n                parent = $(elements[0]).parent();\n            }\n            while (elements.length) {\n                child = elements.splice(Math.floor(Math.random() *  elements.length), 1)[0];\n                lastSibling = parent.find('[data-shuffle-group=\"' + $(child).data('shuffle-group') + '\"]').last();\n                lastSibling.after(child);\n            }\n        }\n\n        /* jscs:disable */\n        /* eslint:disable */\n    });\n\n    return $.mage.upsellProducts;\n});\n","Magento_Catalog/js/storage-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'mageUtils',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/section-config',\n    'jquery'\n], function (_, Element, utils, storage, sectionConfig, $) {\n    'use strict';\n\n    /**\n     * Flush events, that are clones of the same customer data sections\n     * Events listener\n     */\n    $(document).on('submit', function (event) {\n        var sections;\n\n        if (event.target.method.match(/post|put|delete/i)) {\n            sections = sectionConfig.getAffectedSections(event.target.action);\n\n            if (sections && window.localStorage) {\n                _.each(sections, function (section) {\n                    window.localStorage.removeItem(section);\n                });\n            }\n        }\n    });\n\n    return Element.extend({\n        defaults: {\n            defaultNamespace: {\n                lifetime: 1000\n            },\n            storagesConfiguration: {\n                'recently_viewed_product': {\n                    namespace: 'recently_viewed_product',\n                    className: 'IdsStorage',\n                    lifetime: '${ $.defaultNamespace.lifetime }',\n                    requestConfig: {\n                        typeId: '${ $.storagesConfiguration.recently_viewed_product.namespace }'\n                    },\n                    savePrevious: {\n                        namespace: '${ $.storagesConfiguration.recently_viewed_product.namespace }' + '_previous',\n                        className: '${ $.storagesConfiguration.recently_viewed_product.className }'\n                    },\n                    allowToSendRequest: 0\n                },\n                'recently_compared_product': {\n                    namespace: 'recently_compared_product',\n                    className: 'IdsStorageCompare',\n                    provider: 'compare-products',\n                    lifetime: '${ $.defaultNamespace.lifetime }',\n                    requestConfig: {\n                        typeId: '${ $.storagesConfiguration.recently_compared_product.namespace }'\n                    },\n                    savePrevious: {\n                        namespace: '${ $.storagesConfiguration.recently_compared_product.namespace }' + '_previous',\n                        className: '${ $.storagesConfiguration.recently_compared_product.className }'\n                    },\n                    allowToSendRequest: 0\n                },\n                'product_data_storage': {\n                    namespace: 'product_data_storage',\n                    className: 'DataStorage',\n                    allowToSendRequest: 0,\n                    updateRequestConfig: {\n                        url: '',\n                        method: 'GET',\n                        dataType: 'json'\n                    }\n                }\n            },\n            requestConfig: {\n                method: 'POST',\n                dataType: 'json',\n                ajaxSaveType: 'default',\n                ignoreProcessEvents: true\n            },\n            requestSent: 0\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .prepareStoragesConfig()\n                .initStorages()\n                .initStartData()\n                .initUpdateStorageDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes storages.\n         *\n         * @returns {Object} Chainable.\n         */\n        initStorages: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this[name] = storage.createStorage(this.storagesConfiguration[name]);\n\n                if (this.storagesConfiguration[name].savePrevious) {\n                    this[name].previous = storage.createStorage(this.storagesConfiguration[name].savePrevious);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes start data.\n         *\n         * @returns {Object} Chainable.\n         */\n        initStartData: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this.updateDataHandler(name, this[name].get());\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Prepare storages congfig.\n         *\n         * @returns {Object} Chainable.\n         */\n        prepareStoragesConfig: function () {\n            this.storagesNamespace = _.keys(this.storagesConfiguration);\n\n            _.each(this.storagesNamespace, function (name) {\n                this.storagesConfiguration[name].requestConfig = _.extend(\n                    utils.copy(this.requestConfig),\n                    this.storagesConfiguration[name].requestConfig\n                );\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Prepare date in UTC format (in GMT), and calculate unix timestamp based in seconds\n         *\n         * @returns {Number}\n         * @private\n         */\n        getUtcTime: function () {\n            return new Date().getTime() / 1000;\n        },\n\n        /**\n         * Initializes listeners to storages \"data\" property.\n         */\n        initUpdateStorageDataListener: function () {\n            _.each(this.storagesNamespace, function (name) {\n                if (this[name].data) {\n                    this[name].data.subscribe(this.updateDataHandler.bind(this, name));\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Handlers for storages \"data\" property\n         */\n        updateDataHandler: function (name, data) {\n            var previousData = this[name].previous ? this[name].previous.get() : false;\n\n            if (!_.isEmpty(previousData) &&\n                !_.isEmpty(data) &&\n                !utils.compare(data, previousData).equal) {\n                this[name].set(data);\n                this[name].previous.set(data);\n                this.sendRequest(name, data);\n            } else if (\n                _.isEmpty(previousData) &&\n                !_.isEmpty(data)\n            ) {\n                this[name].set(data);\n                this.sendRequest(name, data);\n            }\n        },\n\n        /**\n         * Gets last updated time\n         *\n         * @param {String} name - storage name\n         */\n        getLastUpdate: function (name) {\n            return window.localStorage.getItem(this[name].namespace + '_last_update');\n        },\n\n        /**\n         * Sets last updated time\n         *\n         * @param {String} name - storage name\n         */\n        setLastUpdate: function (name) {\n            window.localStorage.setItem(this[name].namespace + '_last_update', this.getUtcTime());\n        },\n\n        /**\n         * Request handler\n         *\n         * @param {String} name - storage name\n         */\n        requestHandler: function (name) {\n            this.setLastUpdate(name);\n            this.requestSent = 1;\n        },\n\n        /**\n         * Sends request to server to gets data\n         *\n         * @param {String} name - storage name\n         * @param {Object} data - ids\n         */\n        sendRequest: function (name, data) {\n            var params  = utils.copy(this.storagesConfiguration[name].requestConfig),\n                url = params.syncUrl,\n                typeId = params.typeId;\n\n            if (this.requestSent || !~~this.storagesConfiguration[name].allowToSendRequest) {\n                return;\n            }\n\n            delete params.typeId;\n            delete params.url;\n            this.requestSent = 1;\n\n            return utils.ajaxSubmit({\n                url: url,\n                data: {\n                    ids: data,\n                    'type_id': typeId\n                }\n            }, params).done(this.requestHandler.bind(this, name));\n        }\n    });\n});\n","Magento_Catalog/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'underscore',\n    'Magento_Catalog/js/product/view/product-ids-resolver',\n    'Magento_Catalog/js/product/view/product-info-resolver',\n    'jquery-ui-modules/widget'\n], function ($, $t, _, idsResolver, productInfoResolver) {\n    'use strict';\n\n    $.widget('mage.catalogAddToCart', {\n        options: {\n            processStart: null,\n            processStop: null,\n            bindSubmit: true,\n            minicartSelector: '[data-block=\"minicart\"]',\n            messagesSelector: '[data-placeholder=\"messages\"]',\n            productStatusSelector: '.stock.available',\n            addToCartButtonSelector: '.action.tocart',\n            addToCartButtonDisabledClass: 'disabled',\n            addToCartButtonTextWhileAdding: '',\n            addToCartButtonTextAdded: '',\n            addToCartButtonTextDefault: '',\n            productInfoResolver: productInfoResolver\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            if (this.options.bindSubmit) {\n                this._bindSubmit();\n            }\n            $(this.options.addToCartButtonSelector).prop('disabled', false);\n        },\n\n        /**\n         * @private\n         */\n        _bindSubmit: function () {\n            var self = this;\n\n            if (this.element.data('catalog-addtocart-initialized')) {\n                return;\n            }\n\n            this.element.data('catalog-addtocart-initialized', 1);\n            this.element.on('submit', function (e) {\n                e.preventDefault();\n                self.submitForm($(this));\n            });\n        },\n\n        /**\n         * @private\n         */\n        _redirect: function (url) {\n            var urlParts, locationParts, forceReload;\n\n            urlParts = url.split('#');\n            locationParts = window.location.href.split('#');\n            forceReload = urlParts[0] === locationParts[0];\n\n            window.location.assign(url);\n\n            if (forceReload) {\n                window.location.reload();\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isLoaderEnabled: function () {\n            return this.options.processStart && this.options.processStop;\n        },\n\n        /**\n         * Handler for the form 'submit' event\n         *\n         * @param {jQuery} form\n         */\n        submitForm: function (form) {\n            this.ajaxSubmit(form);\n        },\n\n        /**\n         * @param {jQuery} form\n         */\n        ajaxSubmit: function (form) {\n            var self = this,\n                productIds = idsResolver(form),\n                productInfo = self.options.productInfoResolver(form),\n                formData;\n\n            $(self.options.minicartSelector).trigger('contentLoading');\n            self.disableAddToCartButton(form);\n            formData = new FormData(form[0]);\n\n            $.ajax({\n                url: form.prop('action'),\n                data: formData,\n                type: 'post',\n                dataType: 'json',\n                cache: false,\n                contentType: false,\n                processData: false,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStart);\n                    }\n                },\n\n                /** @inheritdoc */\n                success: function (res) {\n                    var eventData, parameters;\n\n                    $(document).trigger('ajax:addToCart', {\n                        'sku': form.data().productSku,\n                        'productIds': productIds,\n                        'productInfo': productInfo,\n                        'form': form,\n                        'response': res\n                    });\n\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStop);\n                    }\n\n                    if (res.backUrl) {\n                        eventData = {\n                            'form': form,\n                            'redirectParameters': []\n                        };\n                        // trigger global event, so other modules will be able add parameters to redirect url\n                        $('body').trigger('catalogCategoryAddToCartRedirect', eventData);\n\n                        if (eventData.redirectParameters.length > 0 &&\n                            window.location.href.split(/[?#]/)[0] === res.backUrl\n                        ) {\n                            parameters = res.backUrl.split('#');\n                            parameters.push(eventData.redirectParameters.join('&'));\n                            res.backUrl = parameters.join('#');\n                        }\n\n                        self._redirect(res.backUrl);\n\n                        return;\n                    }\n\n                    if (res.messages) {\n                        $(self.options.messagesSelector).html(res.messages);\n                    }\n\n                    if (res.minicart) {\n                        $(self.options.minicartSelector).replaceWith(res.minicart);\n                        $(self.options.minicartSelector).trigger('contentUpdated');\n                    }\n\n                    if (res.product && res.product.statusText) {\n                        $(self.options.productStatusSelector)\n                            .removeClass('available')\n                            .addClass('unavailable')\n                            .find('span')\n                            .html(res.product.statusText);\n                    }\n                    self.enableAddToCartButton(form);\n                },\n\n                /** @inheritdoc */\n                error: function (res) {\n                    $(document).trigger('ajax:addToCart:error', {\n                        'sku': form.data().productSku,\n                        'productIds': productIds,\n                        'productInfo': productInfo,\n                        'form': form,\n                        'response': res\n                    });\n                },\n\n                /** @inheritdoc */\n                complete: function (res) {\n                    if (res.state() === 'rejected') {\n                        location.reload();\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {String} form\n         */\n        disableAddToCartButton: function (form) {\n            var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...'),\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n            addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n            addToCartButton.prop('title', addToCartButtonTextWhileAdding);\n        },\n\n        /**\n         * @param {String} form\n         */\n        enableAddToCartButton: function (form) {\n            var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added'),\n                self = this,\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.find('span').text(addToCartButtonTextAdded);\n            addToCartButton.prop('title', addToCartButtonTextAdded);\n\n            setTimeout(function () {\n                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n\n                addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                addToCartButton.find('span').text(addToCartButtonTextDefault);\n                addToCartButton.prop('title', addToCartButtonTextDefault);\n            }, 1000);\n        }\n    });\n\n    return $.mage.catalogAddToCart;\n});\n","Magento_Catalog/js/view/compare-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'underscore',\n    'mage/mage',\n    'mage/decorate'\n], function (Component, customerData, $, _) {\n    'use strict';\n\n    var sidebarInitialized = false,\n        compareProductsReloaded = false;\n\n    /**\n     * Initialize sidebar\n     */\n    function initSidebar() {\n        if (sidebarInitialized) {\n            return;\n        }\n\n        sidebarInitialized = true;\n        $('[data-role=compare-products-sidebar]').decorate('list', true);\n    }\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.compareProducts = customerData.get('compare-products');\n            if (!compareProductsReloaded\n                && !_.isEmpty(this.compareProducts())\n                //Expired section names are reloaded on page load\n                && _.indexOf(customerData.getExpiredSectionNames(), 'compare-products') === -1\n                && window.checkout\n                && window.checkout.websiteId\n                && window.checkout.websiteId !== this.compareProducts().websiteId\n            ) {\n                //set count to 0 to prevent \"compared products\" blocks and count to show with wrong count and items\n                this.compareProducts().count = 0;\n                customerData.reload(['compare-products'], false);\n                compareProductsReloaded = true;\n            }\n            initSidebar();\n        }\n    });\n});\n","Magento_Catalog/js/view/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.template = window.checkout.imageTemplate || this.template;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/view/product-ids-resolver'\n], function (_, $, utils, Element, storage, customerData, productResolver) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: ''\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                customerDataProvider: 'product_data_storage',\n                updateRequestConfig: {\n                    url: '',\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            },\n            ids: {},\n            listens: {\n                ids: 'idsHandler'\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initIdsStorage();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('ids');\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage handler.\n         *\n         * @param {Object} idsStorage\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.productStorage = storage.createStorage(this.productStorageConfig);\n            this.productStorage.data.subscribe(this.dataCollectionHandler.bind(this));\n\n            if (~~this.idsStorage.allowToSendRequest) {\n                customerData.reload([idsStorage.namespace]).done(this._resolveDataByIds.bind(this));\n            } else {\n                this._resolveDataByIds();\n            }\n        },\n\n        /**\n         * Callback, which load by ids from ids-storage product data\n         *\n         * @private\n         */\n        _resolveDataByIds: function () {\n            if (!window.checkout || !window.checkout.baseUrl) {\n                // We need data that the minicart provdes to determine storeId/websiteId\n                return;\n            }\n\n            this.initIdsListener();\n            this.idsMerger(\n                this.idsStorage.get(),\n                this.prepareDataFromCustomerData(customerData.get(this.identifiersConfig.namespace)())\n            );\n\n            if (!_.isEmpty(this.productStorage.data())) {\n                this.dataCollectionHandler(this.productStorage.data());\n            } else {\n                this.productStorage.setIds(this.data.currency, this.data.store, this.ids());\n            }\n        },\n\n        /**\n         * Init ids storage listener.\n         */\n        initIdsListener: function () {\n            customerData.get(this.identifiersConfig.namespace).subscribe(function (data) {\n                this.idsMerger(this.prepareDataFromCustomerData(data));\n            }.bind(this));\n            this.idsStorage.data.subscribe(this.idsMerger.bind(this));\n        },\n\n        /**\n         * Prepare data from customerData.\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        prepareDataFromCustomerData: function (data) {\n            data = data.items ? data.items : data;\n\n            return data;\n        },\n\n        /**\n         * Filter ids by their lifetime in order to show only hot ids :)\n         *\n         * @param {Object} ids\n         * @returns {Array}\n         */\n        filterIds: function (ids) {\n            var _ids = {},\n                currentTime = new Date().getTime() / 1000,\n                currentProductIds = productResolver($('#product_addtocart_form')),\n                productCurrentScope = this.data.productCurrentScope,\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                    window.checkout.websiteId;\n\n            _.each(ids, function (id, key) {\n                if (\n                    currentTime - ids[key]['added_at'] < ~~this.idsStorage.lifetime &&\n                    !_.contains(currentProductIds, ids[key]['product_id']) &&\n                    (!id.hasOwnProperty('scope_id') || ids[key]['scope_id'] === scopeId)\n                ) {\n                    _ids[id['product_id']] = id;\n\n                }\n            }, this);\n\n            return _ids;\n        },\n\n        /**\n         * Merges id from storage and customer data\n         *\n         * @param {Object} data\n         * @param {Object} optionalData\n         */\n        idsMerger: function (data, optionalData) {\n            if (data && optionalData) {\n                data = _.extend(data, optionalData);\n            }\n\n            if (!_.isEmpty(data)) {\n                this.ids(\n                    this.filterIds(_.extend(this.ids(), data))\n                );\n            }\n        },\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, data);\n        },\n\n        /**\n         * Process data\n         *\n         * @param {Object} data\n         */\n        processData: function (data) {\n            var curData = utils.copy(this.data),\n                ids = this.ids();\n\n            delete data['data_id'];\n            data = _.values(data);\n\n            _.each(data, function (record, index) {\n                record._rowIndex = index;\n                record['added_at'] = ids[record.id]['added_at'];\n            }, this);\n\n            curData.items = data;\n            this.set('data', curData);\n        },\n\n        /**\n         * Product storage data handler\n         *\n         * @param {Object} data\n         */\n        dataCollectionHandler: function (data) {\n            data = this.filterData(data);\n            this.processData(data);\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.ids()),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider-compared.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './provider',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data'\n], function (_, Provider, storage, customerData) {\n    'use strict';\n\n    return Provider.extend({\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, this.dataFilter(data));\n        },\n\n        /**\n         * Filters data by provider\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        dataFilter: function (data) {\n            var providerData = this.idsStorage.prepareData(customerData.get(this.identifiersConfig.provider)().items),\n                result = {},\n                productCurrentScope,\n                scopeId;\n\n            if (typeof this.data.productCurrentScope !== 'undefined' && window.checkout && window.checkout.baseUrl) {\n                productCurrentScope = this.data.productCurrentScope;\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                    productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                        window.checkout.websiteId;\n                _.each(data, function (value, key) {\n                    if (!providerData[productCurrentScope + '-' + scopeId + '-' + key]) {\n                        result[key] = value;\n                    }\n                });\n            } else {\n                _.each(data, function (value, key) {\n                    if (!providerData[key]) {\n                        result[key] = value;\n                    }\n                });\n            }\n\n            return result;\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.dataFilter(this.ids())),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/learn-more.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Depends on this option, \"Learn More\" link can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'learn_more', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/remaining-characters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery-ui-modules/widget'\n], function ($, $t) {\n    'use strict';\n\n    $.widget('mage.remainingCharacters', {\n        options: {\n            remainingText: $t('remaining'),\n            tooManyText: $t('too many'),\n            errorClass: 'mage-error',\n            noDisplayClass: 'no-display'\n        },\n\n        /**\n         * Initializes custom option component\n         *\n         * @private\n         */\n        _create: function () {\n            this.note = $(this.options.noteSelector);\n            this.counter = $(this.options.counterSelector);\n\n            this.updateCharacterCount();\n            this.element.on('change keyup paste', this.updateCharacterCount.bind(this));\n        },\n\n        /**\n         * Updates counter message\n         */\n        updateCharacterCount: function () {\n            var length = this.element.val().length,\n                diff = this.options.maxLength - length;\n\n            this.counter.text(this._formatMessage(diff));\n            this.counter.toggleClass(this.options.noDisplayClass, length === 0);\n            this.note.toggleClass(this.options.errorClass, diff < 0);\n        },\n\n        /**\n         * Format remaining characters message\n         *\n         * @param {int} diff\n         * @returns {String}\n         * @private\n         */\n        _formatMessage: function (diff) {\n            var count = Math.abs(diff),\n                qualifier = diff < 0 ? this.options.tooManyText : this.options.remainingText;\n\n            return '(' + count + ' ' + qualifier + ')';\n        }\n    });\n\n    return $.mage.remainingCharacters;\n});\n","Magento_Catalog/js/product/query-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'underscore'\n    ], function (_) {\n        'use strict';\n\n        return {\n\n            /**\n             * Build query to get id\n             *\n             * @param {Object} data\n             */\n            buildQuery: function (data) {\n                var filters = [];\n\n                _.each(data, function (value, key) {\n                    filters.push({\n                        field: key,\n                        value: value,\n                        'condition_type': 'in'\n                    });\n                });\n\n                return {\n                    searchCriteria: {\n                        filterGroups: [\n                            {\n                                filters: filters\n                            }\n                        ]\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Catalog/js/product/uenc-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n        'use strict';\n\n        /**\n         * Check data to JSON.\n         *\n         * @returns {Boolean}\n         */\n        function _isJSON(data) {\n            try {\n                JSON.parse(data);\n            } catch (e) {\n                return false;\n            }\n\n            return true;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _stringProcessor(data, placeholder, uenc) {\n            if (data && ~data.indexOf(placeholder)) {\n                return data.replace(placeholder, uenc);\n            }\n\n            return data;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _objectProcessor(data, placeholder, uenc) {\n            data = JSON.parse(data);\n\n            if (data.hasOwnProperty('action')) {\n                data.action = _stringProcessor(data.action, placeholder, uenc);\n            }\n\n            if (data.hasOwnProperty('data') && data.data.hasOwnProperty('uenc')) {\n                data.data.uenc = uenc;\n            }\n\n            return JSON.stringify(data);\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         *\n         * @returns {String}\n         */\n        return function (data, placeholder) {\n            var uenc = btoa(window.location.href).replace('+/=', '-_,');\n\n            placeholder = placeholder || encodeURI('%uenc%');\n\n            return _isJSON(data) ?\n                _objectProcessor(data, placeholder, uenc) :\n                _stringProcessor(data, placeholder, uenc);\n\n        };\n    }\n);\n","Magento_Catalog/js/product/addtocompare-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @returns {Array}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_compare_button'].url ||\n                    row['add_to_compare_button']['post_data']);\n        },\n\n        /**\n         * Depends on this option, \"Add to compare\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_compare', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/breadcrumbs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Theme/js/model/breadcrumb-list'\n], function ($, breadcrumbList) {\n    'use strict';\n\n    return function (widget) {\n\n        $.widget('mage.breadcrumbs', widget, {\n            options: {\n                categoryUrlSuffix: '',\n                useCategoryPathInUrl: false,\n                product: '',\n                categoryItemSelector: '.category-item',\n                menuContainer: '[data-action=\"navigation\"] > ul'\n            },\n\n            /** @inheritdoc */\n            _render: function () {\n                this._appendCatalogCrumbs();\n                this._super();\n            },\n\n            /**\n             * Append category and product crumbs.\n             *\n             * @private\n             */\n            _appendCatalogCrumbs: function () {\n                var categoryCrumbs = this._resolveCategoryCrumbs();\n\n                categoryCrumbs.forEach(function (crumbInfo) {\n                    breadcrumbList.push(crumbInfo);\n                });\n\n                if (this.options.product) {\n                    breadcrumbList.push(this._getProductCrumb());\n                }\n            },\n\n            /**\n             * Resolve categories crumbs.\n             *\n             * @return Array\n             * @private\n             */\n            _resolveCategoryCrumbs: function () {\n                var menuItem = this._resolveCategoryMenuItem(),\n                    categoryCrumbs = [];\n\n                if (menuItem !== null && menuItem.length) {\n                    categoryCrumbs.unshift(this._getCategoryCrumb(menuItem));\n\n                    while ((menuItem = this._getParentMenuItem(menuItem)) !== null) {\n                        categoryCrumbs.unshift(this._getCategoryCrumb(menuItem));\n                    }\n                }\n\n                return categoryCrumbs;\n            },\n\n            /**\n             * Returns crumb data.\n             *\n             * @param {Object} menuItem\n             * @return {Object}\n             * @private\n             */\n            _getCategoryCrumb: function (menuItem) {\n                return {\n                    'name': 'category',\n                    'label': menuItem.text(),\n                    'link': menuItem.attr('href'),\n                    'title': ''\n                };\n            },\n\n            /**\n             * Returns product crumb.\n             *\n             * @return {Object}\n             * @private\n             */\n            _getProductCrumb: function () {\n                return {\n                    'name': 'product',\n                    'label': this.options.product,\n                    'link': '',\n                    'title': ''\n                };\n            },\n\n            /**\n             * Find parent menu item for current.\n             *\n             * @param {Object} menuItem\n             * @return {Object|null}\n             * @private\n             */\n            _getParentMenuItem: function (menuItem) {\n                var classes,\n                    classNav,\n                    parentClass,\n                    parentMenuItem = null;\n\n                if (!menuItem) {\n                    return null;\n                }\n\n                classes = menuItem.parent().attr('class');\n                classNav = classes.match(/(nav\\-)[0-9]+(\\-[0-9]+)+/gi);\n\n                if (classNav) {\n                    classNav = classNav[0];\n                    parentClass = classNav.substr(0, classNav.lastIndexOf('-'));\n\n                    if (parentClass.lastIndexOf('-') !== -1) {\n                        parentMenuItem = $(this.options.menuContainer).find('.' + parentClass + ' > a');\n                        parentMenuItem = parentMenuItem.length ? parentMenuItem : null;\n                    }\n                }\n\n                return parentMenuItem;\n            },\n\n            /**\n             * Returns category menu item.\n             *\n             * Tries to resolve category from url or from referrer as fallback and\n             * find menu item from navigation menu by category url.\n             *\n             * @return {Object|null}\n             * @private\n             */\n            _resolveCategoryMenuItem: function () {\n                var categoryUrl = this._resolveCategoryUrl(),\n                    menu = $(this.options.menuContainer),\n                    categoryMenuItem = null;\n\n                if (categoryUrl && menu.length) {\n                    categoryMenuItem = menu.find(\n                        this.options.categoryItemSelector +\n                        ' > a[href=\"' + categoryUrl + '\"]'\n                    );\n                }\n\n                return categoryMenuItem;\n            },\n\n            /**\n             * Returns category url.\n             *\n             * @return {String}\n             * @private\n             */\n            _resolveCategoryUrl: function () {\n                var categoryUrl;\n\n                if (this.options.useCategoryPathInUrl) {\n                    // In case category path is used in product url - resolve category url from current url.\n                    categoryUrl = window.location.href.split('?')[0];\n                    categoryUrl = categoryUrl.substring(0, categoryUrl.lastIndexOf('/')) +\n                        this.options.categoryUrlSuffix;\n                } else {\n                    // In other case - try to resolve it from referrer (without parameters).\n                    categoryUrl = document.referrer;\n\n                    if (categoryUrl.indexOf('?') > 0) {\n                        categoryUrl = categoryUrl.substr(0, categoryUrl.indexOf('?'));\n                    }\n                }\n\n                return categoryUrl;\n            }\n        });\n\n        return $.mage.breadcrumbs;\n    };\n});\n","Magento_Catalog/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, stock status text can be \"In stock\" or \"Out Of Stock\"\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isAvailable: function (row) {\n            return row['is_available'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'escaper'\n], function (Column, columnStatusValidator, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Depends on this option, product name can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'name', 'show_attributes');\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getNameUnsanitizedHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        }\n    });\n});\n","Magento_Catalog/js/product/storage/ids-storage-compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/storage/ids-storage'\n], function (_, ko, utils, customerData, idsStorage) {\n    'use strict';\n\n    return _.extend(utils.copy(idsStorage), {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorageCompare',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            if (this.provider && window.checkout && window.checkout.baseUrl) {\n                this.providerDataHandler(customerData.get(this.provider)());\n                this.initProviderListener();\n            }\n\n            this.initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes listener for external data provider\n         */\n        initProviderListener: function () {\n            customerData.get(this.provider).subscribe(this.providerDataHandler.bind(this));\n        },\n\n        /**\n         * Initializes handler for external data provider update\n         *\n         * @param {Object} data\n         */\n        providerDataHandler: function (data) {\n            data = data.items || data;\n            data = this.prepareData(data);\n\n            this.add(data);\n        },\n\n        /**\n         * Prepares data to correct interface\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} data\n         */\n        prepareData: function (data) {\n            var result = {},\n                scopeId;\n\n            _.each(data, function (item) {\n                if (typeof item.productScope !== 'undefined') {\n                    scopeId = item.productScope === 'store' ? window.checkout.storeId :\n                        item.productScope === 'group' ? window.checkout.storeGroupId :\n                            window.checkout.websiteId;\n\n                    result[item.productScope + '-' + scopeId + '-' + item.id] = {\n                        'added_at': new Date().getTime() / 1000,\n                        'product_id': item.id,\n                        'scope_id': scopeId\n                    };\n                } else {\n                    result[item.id] = {\n                        'added_at': new Date().getTime() / 1000,\n                        'product_id': item.id\n                    };\n                }\n            });\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/storage/storage-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'Magento_Catalog/js/product/storage/ids-storage',\n    'Magento_Catalog/js/product/storage/data-storage',\n    'Magento_Catalog/js/product/storage/ids-storage-compare'\n], function ($, _, utils, $t, IdsStorage, DataStore, IdsStorageCompare) {\n    'use strict';\n\n    return (function () {\n\n        var /**\n             * {Object} storages - list of storages\n             */\n            storages = {},\n\n            /**\n             * {Object} classes - list of classes\n             */\n            classes = {},\n\n            /**\n             * {Object} prototype - methods that will be added to all storage classes to prototype property.\n             */\n            prototype = {\n\n                /**\n                 * Sets data to storage\n                 *\n                 * @param {*} data\n                 */\n                set: function (data) {\n                    if (!utils.compare(data, this.data()).equal) {\n                        this.data(data);\n                    }\n                },\n\n                /**\n                 * Adds some data to current storage data\n                 *\n                 * @param {*} data\n                 */\n                add: function (data) {\n                    if (!_.isEmpty(data)) {\n                        this.data(_.extend(utils.copy(this.data()), data));\n                    }\n                },\n\n                /**\n                 * Gets current storage data\n                 *\n                 * @returns {*} data\n                 */\n                get: function () {\n                    return this.data();\n                }\n            },\n\n            /**\n             * Required properties to storage\n             */\n            storagesInterface =  {\n                data: 'function',\n                initialize: 'function',\n                namespace: 'string'\n            },\n\n            /**\n             * Private service methods\n             */\n            _private = {\n\n                /**\n                 * Overrides class method and add ability use _super to call parent method\n                 *\n                 * @param {Object} extensionMethods\n                 * @param {Object} originInstance\n                 */\n                overrideClassMethods: function (extensionMethods, originInstance) {\n                    var methodsName = _.keys(extensionMethods),\n                        i = 0,\n                        length = methodsName.length;\n\n                    for (i; i < length; i++) {\n                        if (_.isFunction(originInstance[methodsName[i]])) {\n                            originInstance[methodsName[i]] = extensionMethods[methodsName[i]];\n                        }\n                    }\n\n                    return originInstance;\n                },\n\n                /**\n                 * Checks is storage implement interface\n                 *\n                 * @param {Object} classInstance\n                 *\n                 * @returns {Boolean}\n                 */\n                isImplementInterface: function (classInstance) {\n                    _.each(storagesInterface, function (key, value) {\n                        if (typeof classInstance[key] !== value) {\n                            return false;\n                        }\n                    });\n\n                    return true;\n                }\n            },\n\n            /**\n             * Subscribers list\n             */\n            subsctibers = {};\n\n        (function () {\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorage.name] = function (config) {\n                _.extend(this, IdsStorage, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorageCompare.name] = function (config) {\n                _.extend(this, IdsStorageCompare, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[DataStore.name] = function (config) {\n                _.extend(this, DataStore, config);\n            };\n\n            _.each(classes, function (classItem) {\n                classItem.prototype = prototype;\n            });\n        })();\n\n        return {\n\n            /**\n             * Creates new storage or returns if storage with declared namespace exist\n             *\n             * @param {Object} config - storage config\n             * @throws {Error}\n             * @returns {Object} storage instance\n             */\n            createStorage: function (config) {\n                var instance,\n                    initialized;\n\n                if (storages[config.namespace]) {\n                    return storages[config.namespace];\n                }\n\n                instance = new classes[config.className](config);\n\n                if (_private.isImplementInterface(instance)) {\n                    initialized = storages[config.namespace] = instance.initialize();\n                    this.processSubscribers(initialized, config);\n\n                    return initialized;\n                }\n\n                throw new Error('Class ' + config.className + $t('does not implement Storage Interface'));\n            },\n\n            /**\n             * Process subscribers\n             *\n             * Differentiate subscribers by their namespaces: recently_viewed or recently_compared\n             * and process callbacks. Callbacks can be add through onStorageInit function\n             *\n             * @param {Object} initialized\n             * @param {Object} config\n             * @return void\n             */\n            processSubscribers: function (initialized, config) {\n                if (subsctibers[config.namespace]) {\n                    _.each(subsctibers[config.namespace], function (callback) {\n                        callback(initialized);\n                    });\n\n                    delete subsctibers[config.namespace];\n                }\n            },\n\n            /**\n             * Listens storage creating by namespace\n             *\n             * @param {String} namespace\n             * @param {Function} callback\n             * @return void\n             */\n            onStorageInit: function (namespace, callback) {\n                if (storages[namespace]) {\n                    callback(storages[namespace]);\n                } else {\n                    subsctibers[namespace] ?\n                        subsctibers[namespace].push(callback) :\n                        subsctibers[namespace] = [callback];\n                }\n            },\n\n            /**\n             * Gets storage by namespace\n             *\n             * @param {String} namespace\n             *\n             * @returns {Object} storage insance\n             */\n            getStorage: function (namespace) {\n                return storages[namespace];\n            }\n        };\n    })();\n});\n\n","Magento_Catalog/js/product/storage/ids-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils) {\n    'use strict';\n\n    /**\n     * Set data to localStorage with support check.\n     *\n     * @param {String} namespace\n     * @param {Object} data\n     */\n    function setLocalStorageItem(namespace, data) {\n        try {\n            window.localStorage.setItem(namespace, JSON.stringify(data));\n        } catch (e) {\n            console.warn('localStorage is unavailable - skipping local caching of product data');\n            console.error(e);\n        }\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorage',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initCustomerDataReloadListener()\n                .initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        },\n\n        /**\n         * Initializes listener to \"data\" property\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.internalDataHandler.bind(this));\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-reload', function (event, sections) {\n                if ((_.isEmpty(sections) || _.contains(sections, this.namespace)) && ~~this.allowToSendRequest) {\n                    this.localStorage.removeAll();\n                    this.data();\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes handler to \"data\" property update\n         */\n        internalDataHandler: function (data) {\n            setLocalStorageItem(this.namespace, data);\n        },\n\n        /**\n         * Initializes handler to storage update\n         */\n        externalDataHandler: function (data) {\n            data = data.items ? data.items : data;\n\n            this.set(_.extend(utils.copy(this.data()), data));\n        }\n    };\n});\n\n","Magento_Catalog/js/product/storage/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Catalog/js/product/query-builder',\n    'Magento_Customer/js/customer-data',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils, queryBuilder, customerData) {\n    'use strict';\n\n    /**\n     * Process data from API request\n     *\n     * @param {Object} data\n     * @returns {Object}\n     */\n    function getParsedDataFromServer(data) {\n        var result = {};\n\n        _.each(data.items, function (item) {\n                if (item.id) {\n                    result[item.id] = item;\n                }\n            }\n        );\n\n        return {\n            items: result\n        };\n    }\n\n    /**\n     * Set data to localStorage with support check.\n     *\n     * @param {String} namespace\n     * @param {Object} data\n     */\n    function setLocalStorageItem(namespace, data) {\n        try {\n            window.localStorage.setItem(namespace, JSON.stringify(data));\n        } catch (e) {\n            console.warn('localStorage is unavailable - skipping local caching of product data');\n            console.error(e);\n        }\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'DataStorage',\n        request: {},\n        customerDataProvider: 'product_data_storage',\n\n        /**\n         * Initialize class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initLocalStorage()\n                .initCustomerDataReloadListener()\n                .cachesDataFromLocalStorage()\n                .initDataListener()\n                .initProvideStorage()\n                .initProviderListener();\n\n            return this;\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-invalidate', this._flushProductStorage.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Flush product storage\n         *\n         * @private\n         * @return void\n         */\n        _flushProductStorage: function (event, sections) {\n            if (_.isEmpty(sections) || _.contains(sections, 'product_data_storage')) {\n                this.localStorage.removeAll();\n            }\n        },\n\n        /**\n         * Initialize listener to data property\n         *\n         * @return Chainable.\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.dataHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize provider storage\n         *\n         * @return Chainable.\n         */\n        initProvideStorage: function () {\n            this.providerHandler(customerData.get(this.customerDataProvider)());\n\n            return this;\n        },\n\n        /**\n         * Handler to update \"data\" property.\n         * Sets data to localStorage\n         *\n         * @param {Object} data\n         */\n        dataHandler: function (data) {\n            if (_.isEmpty(data)) {\n                this.localStorage.removeAll();\n            } else {\n                setLocalStorageItem(this.namespace, data);\n            }\n        },\n\n        /**\n         * Handler to update data in provider.\n         *\n         * @param {Object} data\n         */\n        providerHandler: function (data) {\n            var currentData = utils.copy(this.data()),\n                ids = _.keys(data.items);\n\n            if (data.items && ids.length) {\n                //we can extend only items\n                data = data.items;\n                this.data(_.extend(data, currentData));\n            }\n        },\n\n        /**\n         * Sets data ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         */\n        setIds: function (currency, store, ids) {\n            if (!this.hasInCache(currency, store, ids)) {\n                this.loadDataFromServer(currency, store, ids);\n            } else {\n                this.data.valueHasMutated();\n            }\n        },\n\n        /**\n         * Gets data from \"data\" property by identifiers\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} productIdentifiers\n         *\n         * @return {Object} data.\n         */\n        getDataByIdentifiers: function (currency, store, productIdentifiers) {\n            var data = {},\n                dataCollection = this.data(),\n                id;\n\n            for (id in productIdentifiers) {\n                if (productIdentifiers.hasOwnProperty(id)) {\n                    data[id] = dataCollection[id];\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Checks has cached data or not\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return {Boolean}\n         */\n        hasInCache: function (currency, store, ids) {\n            var data = this.data(),\n                id;\n\n            for (id in ids) {\n                if (!data.hasOwnProperty(id) ||\n                    data[id]['currency_code'] !== currency ||\n                    ~~data[id]['store_id'] !== ~~store\n                ) {\n                    return false;\n                }\n            }\n\n            return true;\n        },\n\n        /**\n         * Load data from server by ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return void\n         */\n        loadDataFromServer: function (currency, store, ids) {\n            var idsArray = _.keys(ids),\n                prepareAjaxParams = {\n                    'entity_id': idsArray.join(',')\n                };\n\n            if (this.request.sent && this.hasIdsInSentRequest(ids)) {\n                return;\n            }\n\n            this.request = {\n                sent: true,\n                data: ids\n            };\n\n            this.updateRequestConfig.data = queryBuilder.buildQuery(prepareAjaxParams);\n            this.updateRequestConfig.data['store_id'] = store;\n            this.updateRequestConfig.data['currency_code'] = currency;\n            $.ajax(this.updateRequestConfig).done(function (data) {\n                this.request = {};\n                this.providerHandler(getParsedDataFromServer(data));\n            }.bind(this));\n        },\n\n        /**\n         * Each product page consist product cache data,\n         * this function prepare those data to appropriate view, and save it\n         *\n         * @param {Object} data\n         */\n        addDataFromPageCache: function (data) {\n            this.providerHandler(getParsedDataFromServer(data));\n        },\n\n        /**\n         * @param {Object} ids\n         * @returns {Boolean}\n         */\n        hasIdsInSentRequest: function (ids) {\n            var sentDataIds,\n                currentDataIds;\n\n            if (this.request.data) {\n                sentDataIds = _.keys(this.request.data);\n                currentDataIds = _.keys(ids);\n\n                _.each(currentDataIds, function (id) {\n                    if (_.lastIndexOf(sentDataIds, id) === -1) {\n                        return false;\n                    }\n                });\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Initialize provider listener\n         *\n         * @return Chainable.\n         */\n        initProviderListener: function () {\n            customerData.get(this.customerDataProvider).subscribe(this.providerHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        }\n    };\n});\n","Magento_Catalog/js/product/view/product-info.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Catalog/js/product/view/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service'\n], function (_, Element, storage) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: 'recently_viewed_product'\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                updateRequestConfig: {\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            }\n        },\n\n        /**\n         * Initializes\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            if (window.checkout && window.checkout.baseUrl) {\n                this.initIdsStorage();\n            }\n\n            this.initDataStorage();\n\n            return this;\n        },\n\n        /**\n         * Init ids storage\n         *\n         * @returns {Object} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init data storage\n         *\n         * @returns {Object} Chainable.\n         */\n        initDataStorage: function () {\n            storage.onStorageInit(this.productStorageConfig.namespace, this.dataStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init data storage handler\n         *\n         * @param {Object} dataStorage - storage instance\n         */\n        dataStorageHandler: function (dataStorage) {\n            this.productStorage = dataStorage;\n            this.productStorage.add(this.data.items);\n        },\n\n        /**\n         * Init ids storage handler\n         *\n         * @param {Object} idsStorage - storage instance\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.idsStorage.add(this.getIdentifiers());\n        },\n\n        /**\n         * Gets ids from items\n         *\n         * @returns {Object}\n         */\n        getIdentifiers: function () {\n            var result = {},\n                productCurrentScope = this.data.productCurrentScope,\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                    productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                        window.checkout.websiteId;\n\n            _.each(this.data.items, function (item, key) {\n                result[productCurrentScope + '-' + scopeId + '-' + key] = {\n                    'added_at': new Date().getTime() / 1000,\n                    'product_id': key,\n                    'scope_id': scopeId\n                };\n            }, this);\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/view/product-info-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Catalog/js/product/view/product-info'\n], function (_, productInfo) {\n    'use strict';\n\n    /**\n     * Returns info about products in form.\n     *\n     * @param {jQuery} $form\n     * @return {Array}\n     */\n    return function ($form) {\n        var product = _.findWhere($form.serializeArray(), {\n                name: 'product'\n            });\n\n        if (!_.isUndefined(product)) {\n            productInfo().push(\n                {\n                    'id': product.value\n                }\n            );\n        }\n\n        return _.uniq(productInfo(), function (item) {\n            return item.id;\n        });\n    };\n});\n\n","Magento_Catalog/js/product/view/product-ids-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Catalog/js/product/view/product-ids'\n], function (_, productIds) {\n    'use strict';\n\n    /**\n     * Returns id's of products in form.\n     *\n     * @param {jQuery} $form\n     * @return {Array}\n     */\n    return function ($form) {\n        var idSet = productIds(),\n            product = _.findWhere($form.serializeArray(), {\n            name: 'product'\n        });\n\n        if (!_.isUndefined(product)) {\n            idSet.push(product.value);\n        }\n\n        return _.uniq(idSet);\n    };\n});\n","Magento_Catalog/js/product/view/product-ids.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Catalog/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing'\n], function (ko, _, Listing) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/column-status-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        /**\n         * Check whether we can show column depends on server settings or not\n         *\n         * @param {Object} source\n         * @param {String} attributeCode\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        isValid: function (source, attributeCode, type) {\n            var attributes;\n\n            if (!source[type]) {\n                return false;\n            }\n\n            attributes = source[type].split(',');\n\n            return _.contains(attributes, attributeCode);\n        }\n    });\n});\n","Magento_Catalog/js/product/list/toolbar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    /**\n     * ProductListToolbarForm Widget - this widget is setting cookie and submitting form according to toolbar controls\n     */\n    $.widget('mage.productListToolbarForm', {\n\n        options: {\n            modeControl: '[data-role=\"mode-switcher\"]',\n            directionControl: '[data-role=\"direction-switcher\"]',\n            orderControl: '[data-role=\"sorter\"]',\n            limitControl: '[data-role=\"limiter\"]',\n            mode: 'product_list_mode',\n            direction: 'product_list_dir',\n            order: 'product_list_order',\n            limit: 'product_list_limit',\n            page: 'p',\n            modeDefault: 'grid',\n            directionDefault: 'asc',\n            orderDefault: 'position',\n            limitDefault: '9',\n            url: '',\n            formKey: '',\n            post: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._bind(\n                $(this.options.modeControl, this.element),\n                this.options.mode,\n                this.options.modeDefault\n            );\n            this._bind(\n                $(this.options.directionControl, this.element),\n                this.options.direction,\n                this.options.directionDefault\n            );\n            this._bind(\n                $(this.options.orderControl, this.element),\n                this.options.order,\n                this.options.orderDefault\n            );\n            this._bind(\n                $(this.options.limitControl, this.element),\n                this.options.limit,\n                this.options.limitDefault\n            );\n        },\n\n        /** @inheritdoc */\n        _bind: function (element, paramName, defaultValue) {\n            if (element.is('select')) {\n                element.on('change', {\n                    paramName: paramName,\n                    'default': defaultValue\n                }, $.proxy(this._processSelect, this));\n            } else {\n                element.on('click', {\n                    paramName: paramName,\n                    'default': defaultValue\n                }, $.proxy(this._processLink, this));\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _processLink: function (event) {\n            event.preventDefault();\n            this.changeUrl(\n                event.data.paramName,\n                $(event.currentTarget).data('value'),\n                event.data.default\n            );\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _processSelect: function (event) {\n            this.changeUrl(\n                event.data.paramName,\n                event.currentTarget.options[event.currentTarget.selectedIndex].value,\n                event.data.default\n            );\n        },\n\n        /**\n         * @private\n         */\n        getUrlParams: function () {\n            var decode = window.decodeURIComponent,\n                urlPaths = this.options.url.split('?'),\n                urlParams = urlPaths[1] ? urlPaths[1].split('&') : [],\n                params = {},\n                parameters, i;\n\n            for (i = 0; i < urlParams.length; i++) {\n                parameters = urlParams[i].split('=');\n                params[decode(parameters[0])] = parameters[1] !== undefined ?\n                    decode(parameters[1].replace(/\\+/g, '%20')) :\n                    '';\n            }\n\n            return params;\n        },\n\n        /**\n         * @returns {String}\n         * @private\n         */\n        getCurrentLimit: function () {\n            return this.getUrlParams()[this.options.limit] || this.options.limitDefault;\n        },\n\n        /**\n         * @returns {String}\n         * @private\n         */\n        getCurrentPage: function () {\n            return this.getUrlParams()[this.options.page] || 1;\n        },\n\n        /**\n         * @param {String} paramName\n         * @param {*} paramValue\n         * @param {*} defaultValue\n         */\n        changeUrl: function (paramName, paramValue, defaultValue) {\n            var urlPaths = this.options.url.split('?'),\n                baseUrl = urlPaths[0],\n                paramData = this.getUrlParams(),\n                currentPage = this.getCurrentPage(),\n                form, params, key, input, formKey, newPage;\n\n            if (currentPage > 1 && paramName === this.options.mode) {\n                delete paramData[this.options.page];\n            }\n\n            if (currentPage > 1 && paramName === this.options.limit) {\n                newPage = Math.floor(this.getCurrentLimit() * (currentPage - 1) / paramValue) + 1;\n\n                if (newPage > 1) {\n                    paramData[this.options.page] = newPage;\n                } else {\n                    delete paramData[this.options.page];\n                }\n            }\n\n            paramData[paramName] = paramValue;\n\n            if (this.options.post) {\n                form = document.createElement('form');\n                params = [this.options.mode, this.options.direction, this.options.order, this.options.limit];\n\n                for (key in paramData) {\n                    if (params.indexOf(key) !== -1) { //eslint-disable-line max-depth\n                        input = document.createElement('input');\n                        input.name = key;\n                        input.value = paramData[key];\n                        form.appendChild(input);\n                        delete paramData[key];\n                    }\n                }\n                formKey = document.createElement('input');\n                formKey.name = 'form_key';\n                formKey.value = this.options.formKey;\n                form.appendChild(formKey);\n\n                paramData = $.param(paramData);\n                baseUrl += paramData.length ? '?' + paramData : '';\n\n                form.action = baseUrl;\n                form.method = 'POST';\n                document.body.appendChild(form);\n                form.submit();\n            } else {\n                if (paramValue == defaultValue) { //eslint-disable-line eqeqeq\n                    delete paramData[paramName];\n                }\n\n                paramData = $.param(paramData);\n                location.href = baseUrl + (paramData.length ? '?' + paramData : '');\n            }\n        }\n    });\n\n    return $.mage.productListToolbarForm;\n});\n","Magento_Catalog/js/product/list/columns/pricetype-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiCollection'\n], function (ko, _, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        /**\n         * Find from all price ui components, price with specific code, init source on it and set priceType\n         *\n         * @param {String} code\n         * @returns {*|T}\n         */\n        getPriceByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                price;\n\n            price = _.filter(elems, function (elem) {\n                return elem.index.split('.').shift() === code;\n            }, this).pop();\n\n            price.source = this.source();\n            price.priceType = code;\n\n            return price;\n        },\n\n        /**\n         * Retrieve body template\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check whether price has price range, depends on different options, that can be choose\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'uiLayout'\n], function (ko, _, registry, utils, Collection, columnStatusValidator, layout) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: '',\n            hasSpecialPrice: false,\n            showMinimalPrice: false,\n            useLinkForAsLowAs: false,\n            visible: true,\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_Catalog/product/price/price_box',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: false,\n            sorting: false,\n            draggable: true,\n            fieldClass: {},\n            renders: {\n                default: {}\n            },\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                elems: ''\n            },\n            modules: {\n                source: '${ $.provider }'\n            },\n            pricesInit: {}\n        },\n\n        /**\n         * Sort prices api\n         *\n         * @returns {exports}\n         */\n        sort: function () {\n            return this;\n        },\n\n        /**\n         * Check whether is allowed to render price or not\n         *\n         * @returns {*}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'price', 'show_attributes');\n        },\n\n        /**\n         * Retrieve array of prices, that should be rendered for specific product\n         *\n         * @param {Array} row\n         * @return {Array}\n         */\n        getPrices: function (row) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                result;\n\n            //we cant take type of product from row\n            this.initPrices(row);\n            result = _.filter(elems, function (elem) {\n                return elem.productType === row.type;\n            });\n\n            return result;\n        },\n\n        /**\n         * Recursive Merging of objects\n         *\n         * @param {Array} target\n         * @param {Array} source\n         * @returns {Array}\n         * @private\n         */\n        _deepObjectExtend: function (target, source) {\n            var _target = utils.copy(target);\n\n            _.each(source, function (value, key) {\n                if (_.keys(value).length && typeof _target[key] !== 'undefined') {\n                    _target[key] = this._deepObjectExtend(_target[key], value);\n                } else {\n                    _target[key] = value;\n                }\n            }, this);\n\n            return _target;\n        },\n\n        /**\n         * Init price type box, in cases when product type has custom component or bodyTmpl\n         *\n         * @param {String} productType\n         * @private\n         */\n        _initPriceWithCustomMetaData: function (productType) {\n            var price = this._deepObjectExtend(\n                this.renders.prices['default'],\n                this.renders.prices[productType]\n            );\n\n            price.name = productType + '.default';\n            price.parent = this.name;\n            price.source = this.source;\n            price.productType = productType;\n            layout([price]);\n        },\n\n        /**\n         * Init Prices by product type and add them to layout\n         *\n         * @param {Array} _priceData\n         * @param {String} productType\n         * @private\n         */\n        _initPricesForProductType: function (_priceData, productType) {\n            var prices = [];\n\n            this._setPriceNamesToPrices(_priceData, productType);\n            _.sortBy(_priceData, this._comparePrices);\n\n            _.each(_priceData, function (priceData) {\n                if (!priceData.component) {\n                    return;\n                }\n\n                priceData.parent = this.name;\n                priceData.provider = this.provider;\n                priceData.productType = productType;\n                priceData = utils.template(priceData, this);\n                prices.push(priceData);\n            }, this);\n\n            layout(prices);\n        },\n\n        /**\n         * Init dynamic price components\n         *\n         * @param {Array} row\n         * @returns {void}\n         */\n        initPrices: function (row) {\n            var _priceData = [],\n                productType = row.type,\n                defaultPrice = this.renders.prices['default'];\n\n            if (this.pricesInit[productType]) {\n                return true;\n            }\n\n            this.pricesInit[productType] = true;\n\n            if (this.renders.prices[productType] && this._needToApplyCustomTemplate(this.renders.prices[productType])) {\n                return this._initPriceWithCustomMetaData(productType);\n            }\n\n            if (this.renders.prices[productType] && this.renders.prices[productType].children) {\n                _priceData = this._deepObjectExtend(defaultPrice.children, this.renders.prices[productType].children);\n            } else {\n                _priceData = defaultPrice.children;\n            }\n\n            return this._initPricesForProductType(_priceData, productType);\n        },\n\n        /**\n         * Set name to all price components\n         *\n         * @param {Array} prices\n         * @param {String} productType\n         * @private\n         */\n        _setPriceNamesToPrices: function (prices, productType) {\n            _.each(prices, function (price, name) {\n                price.priceType = name;\n                price.name = name + '.' + productType;\n            });\n\n            return prices;\n        },\n\n        /**\n         * Sort callback to compare prices by sort order\n         *\n         * @param {Number} firstPrice\n         * @param {Number} secondPrice\n         * @returns {Number}\n         * @private\n         */\n        _comparePrices: function (firstPrice, secondPrice) {\n            if (firstPrice.sortOrder < secondPrice.sortOrder) {\n                return -1;\n            }\n\n            if (firstPrice.sortOrder > secondPrice.sortOrder) {\n                return 1;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Check whether metadata of product type prices was changed, and we should\n         * to apply custom template or custom component\n         *\n         * @param {Array} productData\n         * @returns {*}\n         * @private\n         */\n        _needToApplyCustomTemplate: function (productData) {\n            return productData.bodyTmpl || productData.component;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get price label.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (_, Element, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Catalog/product/list/columns/image',\n            imageCode: 'default',\n            image: {}\n        },\n\n        /**\n         * Find image by code in scope of images\n         *\n         * @param {Object} images\n         * @returns {*|T}\n         */\n        getImage: function (images) {\n            return _.filter(images, function (image) {\n                return this.imageCode === image.code;\n            }, this).pop();\n        },\n\n        /**\n         * Get image path.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getImageUrl: function (row) {\n            return this.getImage(row.images).url;\n        },\n\n        /**\n         * Get image box width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getWidth: function (row) {\n            return this.getImage(row.images).width;\n        },\n\n        /**\n         * Get image box height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getHeight: function (row) {\n            return this.getImage(row.images).height;\n        },\n\n        /**\n         * Get resized image width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageWidth: function (row) {\n            return this.getImage(row.images)['resized_width'];\n        },\n\n        /**\n         * Get resized image height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageHeight: function (row) {\n            return this.getImage(row.images)['resized_height'];\n        },\n\n        /**\n         * Get image alt text.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getLabel: function (row) {\n            if (!this.imageExists(row)) {\n                return this._super();\n            }\n\n            return this.getImage(row.images).label;\n        },\n\n        /**\n         * Check if image exist.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        imageExists: function (row) {\n            return this.getImage(row.images) !== 'undefined';\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'image', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/final-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection'\n], function (_, registry, utils, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: false,\n            headerTmpl: 'ui/grid/columns/text',\n            showMinimalPrice: false,\n            showMaximumPrice: false,\n            useLinkForAsLowAs: false,\n            bodyTmpl: 'Magento_Catalog/product/final_price',\n            priceWrapperCssClasses: '',\n            priceWrapperAttr: {}\n        },\n\n        /**\n         * Get product final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPrice: function (row) {\n            return row['price_info']['formatted_prices']['final_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPriceUnsanitizedHtml: function (row) {\n            return this.getPrice(row);\n        },\n\n        /**\n         * Get product regular price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPriceUnsanitizedHtml: function (row) {\n            return this.getRegularPrice(row);\n        },\n\n        /**\n         * Check if product has a price range.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Check if product has special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} special price html\n         */\n        hasSpecialPrice: function (row) {\n            return row['price_info']['regular_price'] > row['price_info']['final_price'];\n        },\n\n        /**\n         * Check if product has minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        isMinimalPrice: function (row) {\n            return row['price_info']['minimal_price'] < row['price_info']['final_price'];\n        },\n\n        /**\n         * Get product minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPrice: function (row) {\n            return row['price_info']['formatted_prices']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPriceUnsanitizedHtml: function (row) {\n            return this.getMinimalPrice(row);\n        },\n\n        /**\n         * Check if product is salable.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Get product maximum price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPriceUnsanitizedHtml: function (row) {\n            return this.getMaxPrice(row);\n        },\n\n        /**\n         * Get product maximum regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMaxRegularPrice(row);\n        },\n\n        /**\n         * Get product minimal regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['min_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMinRegularPrice(row);\n        },\n\n        /**\n         * Get adjustments names and return as string.\n         *\n         * @return {String} adjustments classes\n         */\n        getAdjustmentCssClasses: function () {\n            return _.pluck(this.getAdjustments(), 'index').join(' ');\n        },\n\n        /**\n         * Get product minimal price as number.\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmount: function (row) {\n            return row['price_info']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPriceAmount\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmountUnsanitizedHtml: function (row) {\n            return this.getMinimalPriceAmount(row);\n        },\n\n        /**\n         * Get product minimal regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} minimal regular price amount\n         */\n        getMinimalRegularPriceAmount: function (row) {\n            return row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Get product maximum price as number.\n         *\n         * @param {Object} row\n         * @return {Number} maximum price amount\n         */\n        getMaximumPriceAmount: function (row) {\n            return row['price_info']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} maximum regular price amount\n         */\n        getMaximumRegularPriceAmount: function (row) {\n            return row['price_info']['max_regular_price'];\n        },\n\n        /**\n         * Check if minimal regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMinRegularPrice: function (row) {\n            return this.getMinimalPriceAmount(row) < this.getMinimalRegularPriceAmount(row);\n        },\n\n        /**\n         * Check if maximum regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMaxRegularPrice: function (row) {\n            return this.getMaximumPriceAmount(row) < this.getMaximumRegularPriceAmount(row);\n        },\n\n        /**\n         * Get path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get all price adjustments.\n         *\n         * @returns {Object}\n         */\n        getAdjustments: function () {\n            var adjustments = this.elems();\n\n            _.each(adjustments, function (adjustment) {\n                adjustment.setPriceType(this.priceType);\n                adjustment.source = this.source;\n            }, this);\n\n            return adjustments;\n        }\n    });\n});\n","Magento_Catalog/product/view/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/validation/validation'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.validation', $.mage.validation, {\n        options: {\n            radioCheckboxClosest: 'ul, ol',\n\n            /**\n             * @param {*} error\n             * @param {HTMLElement} element\n             */\n            errorPlacement: function (error, element) {\n                var messageBox,\n                    dataValidate;\n\n                if ($(element).hasClass('datetime-picker')) {\n                    element = $(element).parent();\n\n                    if (element.parent().find('.mage-error').length) {\n                        return;\n                    }\n                }\n\n                if (element.attr('data-errors-message-box')) {\n                    messageBox = $(element.attr('data-errors-message-box'));\n                    messageBox.html(error);\n\n                    return;\n                }\n\n                dataValidate = element.attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-one-checkbox-required-by-name') > 0) {\n                    error.appendTo('#links-advice-container');\n                } else if (element.is(':radio, :checkbox')) {\n                    element.closest(this.radioCheckboxClosest).after(error);\n                } else {\n                    element.after(error);\n                }\n            },\n\n            /**\n             * @param {HTMLElement} element\n             * @param {String} errorClass\n             */\n            highlight: function (element, errorClass) {\n                var dataValidate = $(element).attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                    $(element).parent().find('.datetime-picker').each(function () {\n                        $(this).removeClass(errorClass);\n\n                        if ($(this).val().length === 0) {\n                            $(this).addClass(errorClass);\n                        }\n                    });\n                } else if ($(element).is(':radio, :checkbox')) {\n                    $(element).closest(this.radioCheckboxClosest).addClass(errorClass);\n                } else {\n                    $(element).addClass(errorClass);\n                }\n            },\n\n            /**\n             * @param {HTMLElement} element\n             * @param {String} errorClass\n             */\n            unhighlight: function (element, errorClass) {\n                var dataValidate = $(element).attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                    $(element).parent().find('.datetime-picker').removeClass(errorClass);\n                } else if ($(element).is(':radio, :checkbox')) {\n                    $(element).closest(this.radioCheckboxClosest).removeClass(errorClass);\n                } else {\n                    $(element).removeClass(errorClass);\n                }\n            }\n        }\n    });\n\n    return $.mage.validation;\n});\n","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiated by prepareExports, accounting for which module loader is being used.\n  var weakMapFactory;\n\n  // Extends a Knockout instance with Knockout-ES5 functionality\n  function attachToKo(ko) {\n    ko.track = track;\n    ko.untrack = untrack;\n    ko.getObservable = getObservable;\n    ko.valueHasMutated = valueHasMutated;\n    ko.defineProperty = defineComputedProperty;\n\n    // todo: test it, maybe added it to ko. directly\n    ko.es5 = {\n      getAllObservablesForObject: getAllObservablesForObject,\n      notifyWhenPresentOrFutureArrayValuesMutate: notifyWhenPresentOrFutureArrayValuesMutate,\n      isTracked: isTracked\n    };\n  }\n\n  // Determines which module loading scenario we're in, grabs dependencies, and attaches to KO\n  function prepareExports() {\n    if (typeof exports === 'object' && typeof module === 'object') {\n      // Node.js case - load KO and WeakMap modules synchronously\n      ko = require('knockout');\n      var WM = require('../lib/weakmap');\n      attachToKo(ko);\n      weakMapFactory = function() { return new WM(); };\n      module.exports = ko;\n    } else if (typeof define === 'function' && define.amd) {\n      define(['knockout'], function(koModule) {\n        ko = koModule;\n        attachToKo(koModule);\n        weakMapFactory = function() { return new global.WeakMap(); };\n        return koModule;\n      });\n    } else if ('ko' in global) {\n      // Non-module case - attach to the global instance, and assume a global WeakMap constructor\n      ko = global.ko;\n      attachToKo(global.ko);\n      weakMapFactory = function() { return new global.WeakMap(); };\n    }\n  }\n\n  prepareExports();\n\n})(this);","knockoutjs/knockout-fast-foreach.js":"/*!\n  Knockout Fast Foreach v0.4.1 (2015-07-17T14:06:15.974Z)\n  By: Brian M Hunt (C) 2015\n  License: MIT\n\n  Adds `fastForEach` to `ko.bindingHandlers`.\n*/\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    define(['knockout'], factory);\n  } else if (typeof exports === 'object') {\n    module.exports = factory(require('knockout'));\n  } else {\n    root.KnockoutFastForeach = factory(root.ko);\n  }\n}(this, function (ko) {\n  \"use strict\";\n// index.js\n// --------\n// Fast For Each\n//\n// Employing sound techniques to make a faster Knockout foreach binding.\n// --------\n\n//      Utilities\n\n// from https://github.com/jonschlinkert/is-plain-object\nfunction isPlainObject(o) {\n  return !!o && typeof o === 'object' && o.constructor === Object;\n}\n\n// From knockout/src/virtualElements.js\nvar commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\nvar startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\nvar supportsDocumentFragment = document && typeof document.createDocumentFragment === \"function\";\nfunction isVirtualNode(node) {\n  return (node.nodeType === 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n}\n\n\n// Get a copy of the (possibly virtual) child nodes of the given element,\n// put them into a container, then empty the given node.\nfunction makeTemplateNode(sourceNode) {\n  var container = document.createElement(\"div\");\n  var parentNode;\n  if (sourceNode.content) {\n    // For e.g. <template> tags\n    parentNode = sourceNode.content;\n  } else if (sourceNode.tagName === 'SCRIPT') {\n    parentNode = document.createElement(\"div\");\n    parentNode.innerHTML = sourceNode.text;\n  } else {\n    // Anything else e.g. <div>\n    parentNode = sourceNode;\n  }\n  ko.utils.arrayForEach(ko.virtualElements.childNodes(parentNode), function (child) {\n    // FIXME - This cloneNode could be expensive; we may prefer to iterate over the\n    // parentNode children in reverse (so as not to foul the indexes as childNodes are\n    // removed from parentNode when inserted into the container)\n    if (child) {\n      container.insertBefore(child.cloneNode(true), null);\n    }\n  });\n  return container;\n}\n\nfunction insertAllAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode) {\n  var frag, len, i;\n  // poor man's node and array check, should be enough for this\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\" && typeof nodeOrNodeArrayToInsert.length === \"undefined\") {\n    throw new Error(\"Expected a single node or a node array\");\n  }\n\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\") {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode);\n    return;\n  }\n\n  if (nodeOrNodeArrayToInsert.length === 1) {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert[0], insertAfterNode);\n    return;\n  }\n\n  if (supportsDocumentFragment) {\n    frag = document.createDocumentFragment();\n\n    for (i = 0, len = nodeOrNodeArrayToInsert.length; i !== len; ++i) {\n      frag.appendChild(nodeOrNodeArrayToInsert[i]);\n    }\n    ko.virtualElements.insertAfter(containerNode, frag, insertAfterNode);\n  } else {\n    // Nodes are inserted in reverse order - pushed down immediately after\n    // the last node for the previous item or as the first node of element.\n    for (i = nodeOrNodeArrayToInsert.length - 1; i >= 0; --i) {\n      var child = nodeOrNodeArrayToInsert[i];\n      if (!child) {\n        return;\n      }\n      ko.virtualElements.insertAfter(containerNode, child, insertAfterNode);\n    }\n  }\n}\n\n// Mimic a KO change item 'add'\nfunction valueToChangeAddItem(value, index) {\n  return {\n    status: 'added',\n    value: value,\n    index: index\n  };\n}\n\nfunction isAdditionAdjacentToLast(changeIndex, arrayChanges) {\n  return changeIndex > 0 &&\n    changeIndex < arrayChanges.length &&\n    arrayChanges[changeIndex].status === \"added\" &&\n    arrayChanges[changeIndex - 1].status === \"added\" &&\n    arrayChanges[changeIndex - 1].index === arrayChanges[changeIndex].index - 1;\n}\n\nfunction FastForEach(spec) {\n  this.element = spec.element;\n  this.container = isVirtualNode(this.element) ?\n                   this.element.parentNode : this.element;\n  this.$context = spec.$context;\n  this.data = spec.data;\n  this.as = spec.as;\n  this.noContext = spec.noContext;\n  this.templateNode = makeTemplateNode(\n    spec.name ? document.getElementById(spec.name).cloneNode(true) : spec.element\n  );\n  this.afterQueueFlush = spec.afterQueueFlush;\n  this.beforeQueueFlush = spec.beforeQueueFlush;\n  this.changeQueue = [];\n  this.lastNodesList = [];\n  this.indexesToDelete = [];\n  this.rendering_queued = false;\n\n  // Remove existing content.\n  ko.virtualElements.emptyNode(this.element);\n\n  // Prime content\n  var primeData = ko.unwrap(this.data);\n  if (primeData.map) {\n    this.onArrayChange(primeData.map(valueToChangeAddItem));\n  }\n\n  // Watch for changes\n  if (ko.isObservable(this.data)) {\n    if (!this.data.indexOf) {\n      // Make sure the observable is trackable.\n      this.data = this.data.extend({trackArrayChanges: true});\n    }\n    this.changeSubs = this.data.subscribe(this.onArrayChange, this, 'arrayChange');\n  }\n}\n\n\nFastForEach.animateFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame ||\n  window.mozRequestAnimationFrame || window.msRequestAnimationFrame ||\n  function(cb) { return window.setTimeout(cb, 1000 / 60); };\n\n\nFastForEach.prototype.dispose = function () {\n  if (this.changeSubs) {\n    this.changeSubs.dispose();\n  }\n};\n\n\n// If the array changes we register the change.\nFastForEach.prototype.onArrayChange = function (changeSet) {\n  var self = this;\n  var changeMap = {\n    added: [],\n    deleted: []\n  };\n  for (var i = 0, len = changeSet.length; i < len; i++) {\n    // the change is appended to a last change info object when both are 'added' and have indexes next to each other\n    // here I presume that ko is sending changes in monotonic order (in index variable) which happens to be true, tested with push and splice with multiple pushed values\n    if (isAdditionAdjacentToLast(i, changeSet)) {\n      var batchValues = changeMap.added[changeMap.added.length - 1].values;\n      if (!batchValues) {\n        // transform the last addition into a batch addition object\n        var lastAddition = changeMap.added.pop();\n        var batchAddition = {\n          isBatch: true,\n          status: 'added',\n          index: lastAddition.index,\n          values: [lastAddition.value]\n        };\n        batchValues = batchAddition.values;\n        changeMap.added.push(batchAddition);\n      }\n      batchValues.push(changeSet[i].value);\n    } else {\n      changeMap[changeSet[i].status].push(changeSet[i]);\n    }\n  }\n  if (changeMap.deleted.length > 0) {\n    this.changeQueue.push.apply(this.changeQueue, changeMap.deleted);\n    this.changeQueue.push({status: 'clearDeletedIndexes'});\n  }\n  this.changeQueue.push.apply(this.changeQueue, changeMap.added);\n  // Once a change is registered, the ticking count-down starts for the processQueue.\n  if (this.changeQueue.length > 0 && !this.rendering_queued) {\n    this.rendering_queued = true;\n    FastForEach.animateFrame.call(window, function () { self.processQueue(); });\n  }\n};\n\n\n// Reflect all the changes in the queue in the DOM, then wipe the queue.\nFastForEach.prototype.processQueue = function () {\n  var self = this;\n\n  // Callback so folks can do things before the queue flush.\n  if (typeof this.beforeQueueFlush === 'function') {\n    this.beforeQueueFlush(this.changeQueue);\n  }\n\n  ko.utils.arrayForEach(this.changeQueue, function (changeItem) {\n    // console.log(self.data(), \"CI\", JSON.stringify(changeItem, null, 2), JSON.stringify($(self.element).text()))\n    self[changeItem.status](changeItem);\n    // console.log(\"  ==> \", JSON.stringify($(self.element).text()))\n  });\n  this.rendering_queued = false;\n  // Callback so folks can do things.\n  if (typeof this.afterQueueFlush === 'function') {\n    this.afterQueueFlush(this.changeQueue);\n  }\n  this.changeQueue = [];\n};\n\n\n// Process a changeItem with {status: 'added', ...}\nFastForEach.prototype.added = function (changeItem) {\n  var index = changeItem.index;\n  var valuesToAdd = changeItem.isBatch ? changeItem.values : [changeItem.value];\n  var referenceElement = this.lastNodesList[index - 1] || null;\n  // gather all childnodes for a possible batch insertion\n  var allChildNodes = [];\n\n  for (var i = 0, len = valuesToAdd.length; i < len; ++i) {\n    var templateClone = this.templateNode.cloneNode(true);\n    var childContext;\n\n    if (this.noContext) {\n      childContext = this.$context.extend({\n        '$item': valuesToAdd[i]\n      });\n    } else {\n      childContext = this.$context.createChildContext(valuesToAdd[i], this.as || null);\n    }\n\n    // apply bindings first, and then process child nodes, because bindings can add childnodes\n    ko.applyBindingsToDescendants(childContext, templateClone);\n\n    var childNodes = ko.virtualElements.childNodes(templateClone);\n    // Note discussion at https://github.com/angular/angular.js/issues/7851\n    allChildNodes.push.apply(allChildNodes, Array.prototype.slice.call(childNodes));\n    this.lastNodesList.splice(index + i, 0, childNodes[childNodes.length - 1]);\n  }\n\n  insertAllAfter(this.element, allChildNodes, referenceElement);\n};\n\n\n// Process a changeItem with {status: 'deleted', ...}\nFastForEach.prototype.deleted = function (changeItem) {\n  var index = changeItem.index;\n  var ptr = this.lastNodesList[index],\n      // We use this.element because that will be the last previous node\n      // for virtual element lists.\n      lastNode = this.lastNodesList[index - 1] || this.element;\n  do {\n    ptr = ptr.previousSibling;\n    ko.removeNode((ptr && ptr.nextSibling) || ko.virtualElements.firstChild(this.element));\n  } while (ptr && ptr !== lastNode);\n  // The \"last node\" in the DOM from which we begin our delets of the next adjacent node is\n  // now the sibling that preceded the first node of this item.\n  this.lastNodesList[index] = this.lastNodesList[index - 1];\n  this.indexesToDelete.push(index);\n};\n\n\n// We batch our deletion of item indexes in our parallel array.\n// See brianmhunt/knockout-fast-foreach#6/#8\nFastForEach.prototype.clearDeletedIndexes = function () {\n  // We iterate in reverse on the presumption (following the unit tests) that KO's diff engine\n  // processes diffs (esp. deletes) monotonically ascending i.e. from index 0 -> N.\n  for (var i = this.indexesToDelete.length - 1; i >= 0; --i) {\n    this.lastNodesList.splice(this.indexesToDelete[i], 1);\n  }\n  this.indexesToDelete = [];\n};\n\n\nko.bindingHandlers.fastForEach = {\n  // Valid valueAccessors:\n  //    []\n  //    ko.observable([])\n  //    ko.observableArray([])\n  //    ko.computed\n  //    {data: array, name: string, as: string}\n  init: function init(element, valueAccessor, bindings, vm, context) {\n    var value = valueAccessor(),\n        ffe;\n    if (isPlainObject(value)) {\n      value.element = value.element || element;\n      value.$context = context;\n      ffe = new FastForEach(value);\n    } else {\n      ffe = new FastForEach({\n        element: element,\n        data: ko.unwrap(context.$rawData) === value ? context.$rawData : value,\n        $context: context\n      });\n    }\n    ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n      ffe.dispose();\n    });\n    return {controlsDescendantBindings: true};\n  },\n\n  // Export for testing, debugging, and overloading.\n  FastForEach: FastForEach\n};\n\nko.virtualElements.allowedBindings.fastForEach = true;\n}));","knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.5.1\n * (c) The Knockout.js team - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\n    var DEBUG=true;\n    (function(undefined){\n        // (0, eval)('this') is a robust way of getting a reference to the global object\n        // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n        var window = this || (0, eval)('this'),\n            document = window['document'],\n            navigator = window['navigator'],\n            jQueryInstance = window[\"jQuery\"],\n            JSON = window[\"JSON\"];\n\n        if (!jQueryInstance && typeof jQuery !== \"undefined\") {\n            jQueryInstance = jQuery;\n        }\n        (function(factory) {\n            // Support three module loading scenarios\n            if (typeof define === 'function' && define['amd']) {\n                // [1] AMD anonymous module\n                define(['exports', 'require'], factory);\n            } else if (typeof exports === 'object' && typeof module === 'object') {\n                // [2] CommonJS/Node.js\n                factory(module['exports'] || exports);  // module.exports is for Node.js\n            } else {\n                // [3] No module loader (plain <script> tag) - put directly in global namespace\n                factory(window['ko'] = {});\n            }\n        }(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\n            var ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\n            ko.exportSymbol = function(koPath, object) {\n                var tokens = koPath.split(\".\");\n\n                // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n                // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n                var target = ko;\n\n                for (var i = 0; i < tokens.length - 1; i++)\n                    target = target[tokens[i]];\n                target[tokens[tokens.length - 1]] = object;\n            };\n            ko.exportProperty = function(owner, publicName, object) {\n                owner[publicName] = object;\n            };\n            ko.version = \"3.5.1\";\n\n            ko.exportSymbol('version', ko.version);\n// For any options that may affect various areas of Knockout and aren't directly associated with data binding.\n            ko.options = {\n                'deferUpdates': false,\n                'useOnlyNativeEvents': false,\n                'foreachHidesDestroyed': false\n            };\n\n//ko.exportSymbol('options', ko.options);   // 'options' isn't minified\n            ko.utils = (function () {\n                var hasOwnProperty = Object.prototype.hasOwnProperty;\n\n                function objectForEach(obj, action) {\n                    for (var prop in obj) {\n                        if (hasOwnProperty.call(obj, prop)) {\n                            action(prop, obj[prop]);\n                        }\n                    }\n                }\n\n                function extend(target, source) {\n                    if (source) {\n                        for(var prop in source) {\n                            if(hasOwnProperty.call(source, prop)) {\n                                target[prop] = source[prop];\n                            }\n                        }\n                    }\n                    return target;\n                }\n\n                function setPrototypeOf(obj, proto) {\n                    obj.__proto__ = proto;\n                    return obj;\n                }\n\n                var canSetPrototype = ({ __proto__: [] } instanceof Array);\n                var canUseSymbols = !DEBUG && typeof Symbol === 'function';\n\n                // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n                var knownEvents = {}, knownEventTypesByEventName = {};\n                var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n                knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n                knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n                objectForEach(knownEvents, function(eventType, knownEventsForType) {\n                    if (knownEventsForType.length) {\n                        for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                            knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n                    }\n                });\n                var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n                // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n                // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n                // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n                // If there is a future need to detect specific versions of IE10+, we will amend this.\n                var ieVersion = document && (function() {\n                    var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n                    // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n                    while (\n                        div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n                            iElems[0]\n                        ) {}\n                    return version > 4 ? version : undefined;\n                }());\n                var isIe6 = ieVersion === 6,\n                    isIe7 = ieVersion === 7;\n\n                function isClickOnCheckableElement(element, eventType) {\n                    if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n                    if (eventType.toLowerCase() != \"click\") return false;\n                    var inputType = element.type;\n                    return (inputType == \"checkbox\") || (inputType == \"radio\");\n                }\n\n                // For details on the pattern for changing node classes\n                // see: https://github.com/knockout/knockout/issues/1597\n                var cssClassNameRegex = /\\S+/g;\n\n                var jQueryEventAttachName;\n\n                function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n                    var addOrRemoveFn;\n                    if (classNames) {\n                        if (typeof node.classList === 'object') {\n                            addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                            ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                                addOrRemoveFn.call(node.classList, className);\n                            });\n                        } else if (typeof node.className['baseVal'] === 'string') {\n                            // SVG tag .classNames is an SVGAnimatedString instance\n                            toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n                        } else {\n                            // node.className ought to be a string.\n                            toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n                        }\n                    }\n                }\n\n                function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n                    // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n                    var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n                    ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                        ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n                    });\n                    obj[prop] = currentClassNames.join(\" \");\n                }\n\n                return {\n                    fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n                    arrayForEach: function (array, action, actionOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            action.call(actionOwner, array[i], i, array);\n                        }\n                    },\n\n                    arrayIndexOf: typeof Array.prototype.indexOf == \"function\"\n                        ? function (array, item) {\n                            return Array.prototype.indexOf.call(array, item);\n                        }\n                        : function (array, item) {\n                            for (var i = 0, j = array.length; i < j; i++) {\n                                if (array[i] === item)\n                                    return i;\n                            }\n                            return -1;\n                        },\n\n                    arrayFirst: function (array, predicate, predicateOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            if (predicate.call(predicateOwner, array[i], i, array))\n                                return array[i];\n                        }\n                        return undefined;\n                    },\n\n                    arrayRemoveItem: function (array, itemToRemove) {\n                        var index = ko.utils.arrayIndexOf(array, itemToRemove);\n                        if (index > 0) {\n                            array.splice(index, 1);\n                        }\n                        else if (index === 0) {\n                            array.shift();\n                        }\n                    },\n\n                    arrayGetDistinctValues: function (array) {\n                        var result = [];\n                        if (array) {\n                            ko.utils.arrayForEach(array, function(item) {\n                                if (ko.utils.arrayIndexOf(result, item) < 0)\n                                    result.push(item);\n                            });\n                        }\n                        return result;\n                    },\n\n                    arrayMap: function (array, mapping, mappingOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                result.push(mapping.call(mappingOwner, array[i], i));\n                        }\n                        return result;\n                    },\n\n                    arrayFilter: function (array, predicate, predicateOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                if (predicate.call(predicateOwner, array[i], i))\n                                    result.push(array[i]);\n                        }\n                        return result;\n                    },\n\n                    arrayPushAll: function (array, valuesToPush) {\n                        if (valuesToPush instanceof Array)\n                            array.push.apply(array, valuesToPush);\n                        else\n                            for (var i = 0, j = valuesToPush.length; i < j; i++)\n                                array.push(valuesToPush[i]);\n                        return array;\n                    },\n\n                    addOrRemoveItem: function(array, value, included) {\n                        var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n                        if (existingEntryIndex < 0) {\n                            if (included)\n                                array.push(value);\n                        } else {\n                            if (!included)\n                                array.splice(existingEntryIndex, 1);\n                        }\n                    },\n\n                    canSetPrototype: canSetPrototype,\n\n                    extend: extend,\n\n                    setPrototypeOf: setPrototypeOf,\n\n                    setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n                    objectForEach: objectForEach,\n\n                    objectMap: function(source, mapping, mappingOwner) {\n                        if (!source)\n                            return source;\n                        var target = {};\n                        for (var prop in source) {\n                            if (hasOwnProperty.call(source, prop)) {\n                                target[prop] = mapping.call(mappingOwner, source[prop], prop, source);\n                            }\n                        }\n                        return target;\n                    },\n\n                    emptyDomNode: function (domNode) {\n                        while (domNode.firstChild) {\n                            ko.removeNode(domNode.firstChild);\n                        }\n                    },\n\n                    moveCleanedNodesToContainerElement: function(nodes) {\n                        // Ensure it's a real array, as we're about to reparent the nodes and\n                        // we don't want the underlying collection to change while we're doing that.\n                        var nodesArray = ko.utils.makeArray(nodes);\n                        var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n                        var container = templateDocument.createElement('div');\n                        for (var i = 0, j = nodesArray.length; i < j; i++) {\n                            container.appendChild(ko.cleanNode(nodesArray[i]));\n                        }\n                        return container;\n                    },\n\n                    cloneNodes: function (nodesArray, shouldCleanNodes) {\n                        for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                            var clonedNode = nodesArray[i].cloneNode(true);\n                            newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n                        }\n                        return newNodesArray;\n                    },\n\n                    setDomNodeChildren: function (domNode, childNodes) {\n                        ko.utils.emptyDomNode(domNode);\n                        if (childNodes) {\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                domNode.appendChild(childNodes[i]);\n                        }\n                    },\n\n                    replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n                        var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n                        if (nodesToReplaceArray.length > 0) {\n                            var insertionPoint = nodesToReplaceArray[0];\n                            var parent = insertionPoint.parentNode;\n                            for (var i = 0, j = newNodesArray.length; i < j; i++)\n                                parent.insertBefore(newNodesArray[i], insertionPoint);\n                            for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                                ko.removeNode(nodesToReplaceArray[i]);\n                            }\n                        }\n                    },\n\n                    fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n                        // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n                        // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n                        // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n                        // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n                        // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n                        //\n                        // Rules:\n                        //   [A] Any leading nodes that have been removed should be ignored\n                        //       These most likely correspond to memoization nodes that were already removed during binding\n                        //       See https://github.com/knockout/knockout/pull/440\n                        //   [B] Any trailing nodes that have been remove should be ignored\n                        //       This prevents the code here from adding unrelated nodes to the array while processing rule [C]\n                        //       See https://github.com/knockout/knockout/pull/1903\n                        //   [C] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n                        //       and include any nodes that have been inserted among the previous collection\n\n                        if (continuousNodeArray.length) {\n                            // The parent node can be a virtual element; so get the real parent node\n                            parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                            // Rule [A]\n                            while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                                continuousNodeArray.splice(0, 1);\n\n                            // Rule [B]\n                            while (continuousNodeArray.length > 1 && continuousNodeArray[continuousNodeArray.length - 1].parentNode !== parentNode)\n                                continuousNodeArray.length--;\n\n                            // Rule [C]\n                            if (continuousNodeArray.length > 1) {\n                                var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                                // Replace with the actual new continuous node set\n                                continuousNodeArray.length = 0;\n                                while (current !== last) {\n                                    continuousNodeArray.push(current);\n                                    current = current.nextSibling;\n                                }\n                                continuousNodeArray.push(last);\n                            }\n                        }\n                        return continuousNodeArray;\n                    },\n\n                    setOptionNodeSelectionState: function (optionNode, isSelected) {\n                        // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n                        if (ieVersion < 7)\n                            optionNode.setAttribute(\"selected\", isSelected);\n                        else\n                            optionNode.selected = isSelected;\n                    },\n\n                    stringTrim: function (string) {\n                        return string === null || string === undefined ? '' :\n                            string.trim ?\n                                string.trim() :\n                                string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n                    },\n\n                    stringStartsWith: function (string, startsWith) {\n                        string = string || \"\";\n                        if (startsWith.length > string.length)\n                            return false;\n                        return string.substring(0, startsWith.length) === startsWith;\n                    },\n\n                    domNodeIsContainedBy: function (node, containedByNode) {\n                        if (node === containedByNode)\n                            return true;\n                        if (node.nodeType === 11)\n                            return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n                        if (containedByNode.contains)\n                            return containedByNode.contains(node.nodeType !== 1 ? node.parentNode : node);\n                        if (containedByNode.compareDocumentPosition)\n                            return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n                        while (node && node != containedByNode) {\n                            node = node.parentNode;\n                        }\n                        return !!node;\n                    },\n\n                    domNodeIsAttachedToDocument: function (node) {\n                        return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n                    },\n\n                    anyDomNodeIsAttachedToDocument: function(nodes) {\n                        return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n                    },\n\n                    tagNameLower: function(element) {\n                        // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n                        // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n                        // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n                        return element && element.tagName && element.tagName.toLowerCase();\n                    },\n\n                    catchFunctionErrors: function (delegate) {\n                        return ko['onError'] ? function () {\n                            try {\n                                return delegate.apply(this, arguments);\n                            } catch (e) {\n                                ko['onError'] && ko['onError'](e);\n                                throw e;\n                            }\n                        } : delegate;\n                    },\n\n                    setTimeout: function (handler, timeout) {\n                        return setTimeout(ko.utils.catchFunctionErrors(handler), timeout);\n                    },\n\n                    deferError: function (error) {\n                        setTimeout(function () {\n                            ko['onError'] && ko['onError'](error);\n                            throw error;\n                        }, 0);\n                    },\n\n                    registerEventHandler: function (element, eventType, handler) {\n                        var wrappedHandler = ko.utils.catchFunctionErrors(handler);\n\n                        var mustUseAttachEvent = eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n                        if (!ko.options['useOnlyNativeEvents'] && !mustUseAttachEvent && jQueryInstance) {\n                            if (!jQueryEventAttachName) {\n                                jQueryEventAttachName = (typeof jQueryInstance(element)['on'] == 'function') ? 'on' : 'bind';\n                            }\n                            jQueryInstance(element)[jQueryEventAttachName](eventType, wrappedHandler);\n                        } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                            element.addEventListener(eventType, wrappedHandler, false);\n                        else if (typeof element.attachEvent != \"undefined\") {\n                            var attachEventHandler = function (event) { wrappedHandler.call(element, event); },\n                                attachEventName = \"on\" + eventType;\n                            element.attachEvent(attachEventName, attachEventHandler);\n\n                            // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                            // so to avoid leaks, we have to remove them manually. See bug #856\n                            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                                element.detachEvent(attachEventName, attachEventHandler);\n                            });\n                        } else\n                            throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n                    },\n\n                    triggerEvent: function (element, eventType) {\n                        if (!(element && element.nodeType))\n                            throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n                        // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n                        // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n                        // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n                        // In both cases, we'll use the click method instead.\n                        var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n                        if (!ko.options['useOnlyNativeEvents'] && jQueryInstance && !useClickWorkaround) {\n                            jQueryInstance(element)['trigger'](eventType);\n                        } else if (typeof document.createEvent == \"function\") {\n                            if (typeof element.dispatchEvent == \"function\") {\n                                var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                                var event = document.createEvent(eventCategory);\n                                event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                                element.dispatchEvent(event);\n                            }\n                            else\n                                throw new Error(\"The supplied element doesn't support dispatchEvent\");\n                        } else if (useClickWorkaround && element.click) {\n                            element.click();\n                        } else if (typeof element.fireEvent != \"undefined\") {\n                            element.fireEvent(\"on\" + eventType);\n                        } else {\n                            throw new Error(\"Browser doesn't support triggering events\");\n                        }\n                    },\n\n                    unwrapObservable: function (value) {\n                        return ko.isObservable(value) ? value() : value;\n                    },\n\n                    peekObservable: function (value) {\n                        return ko.isObservable(value) ? value.peek() : value;\n                    },\n\n                    toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n                    setTextContent: function(element, textContent) {\n                        var value = ko.utils.unwrapObservable(textContent);\n                        if ((value === null) || (value === undefined))\n                            value = \"\";\n\n                        // We need there to be exactly one child: a text node.\n                        // If there are no children, more than one, or if it's not a text node,\n                        // we'll clear everything and create a single text node.\n                        var innerTextNode = ko.virtualElements.firstChild(element);\n                        if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                            ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n                        } else {\n                            innerTextNode.data = value;\n                        }\n\n                        ko.utils.forceRefresh(element);\n                    },\n\n                    setElementName: function(element, name) {\n                        element.name = name;\n\n                        // Workaround IE 6/7 issue\n                        // - https://github.com/SteveSanderson/knockout/issues/197\n                        // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n                        if (ieVersion <= 7) {\n                            try {\n                                var escapedName = element.name.replace(/[&<>'\"]/g, function(r){ return \"&#\" + r.charCodeAt(0) + \";\"; });\n                                element.mergeAttributes(document.createElement(\"<input name='\" + escapedName + \"'/>\"), false);\n                            }\n                            catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n                        }\n                    },\n\n                    forceRefresh: function(node) {\n                        // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n                        if (ieVersion >= 9) {\n                            // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                            var elem = node.nodeType == 1 ? node : node.parentNode;\n                            if (elem.style)\n                                elem.style.zoom = elem.style.zoom;\n                        }\n                    },\n\n                    ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n                        // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n                        // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n                        // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n                        if (ieVersion) {\n                            var originalWidth = selectElement.style.width;\n                            selectElement.style.width = 0;\n                            selectElement.style.width = originalWidth;\n                        }\n                    },\n\n                    range: function (min, max) {\n                        min = ko.utils.unwrapObservable(min);\n                        max = ko.utils.unwrapObservable(max);\n                        var result = [];\n                        for (var i = min; i <= max; i++)\n                            result.push(i);\n                        return result;\n                    },\n\n                    makeArray: function(arrayLikeObject) {\n                        var result = [];\n                        for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                            result.push(arrayLikeObject[i]);\n                        };\n                        return result;\n                    },\n\n                    createSymbolOrString: function(identifier) {\n                        return canUseSymbols ? Symbol(identifier) : identifier;\n                    },\n\n                    isIe6 : isIe6,\n                    isIe7 : isIe7,\n                    ieVersion : ieVersion,\n\n                    getFormFields: function(form, fieldName) {\n                        var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n                        var isMatchingField = (typeof fieldName == 'string')\n                            ? function(field) { return field.name === fieldName }\n                            : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n                        var matches = [];\n                        for (var i = fields.length - 1; i >= 0; i--) {\n                            if (isMatchingField(fields[i]))\n                                matches.push(fields[i]);\n                        };\n                        return matches;\n                    },\n\n                    parseJson: function (jsonString) {\n                        if (typeof jsonString == \"string\") {\n                            jsonString = ko.utils.stringTrim(jsonString);\n                            if (jsonString) {\n                                if (JSON && JSON.parse) // Use native parsing where available\n                                    return JSON.parse(jsonString);\n                                return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                            }\n                        }\n                        return null;\n                    },\n\n                    stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n                        if (!JSON || !JSON.stringify)\n                            throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n                        return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n                    },\n\n                    postJson: function (urlOrForm, data, options) {\n                        options = options || {};\n                        var params = options['params'] || {};\n                        var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n                        var url = urlOrForm;\n\n                        // If we were given a form, use its 'action' URL and pick out any requested field values\n                        if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                            var originalForm = urlOrForm;\n                            url = originalForm.action;\n                            for (var i = includeFields.length - 1; i >= 0; i--) {\n                                var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                                for (var j = fields.length - 1; j >= 0; j--)\n                                    params[fields[j].name] = fields[j].value;\n                            }\n                        }\n\n                        data = ko.utils.unwrapObservable(data);\n                        var form = document.createElement(\"form\");\n                        form.style.display = \"none\";\n                        form.action = url;\n                        form.method = \"post\";\n                        for (var key in data) {\n                            // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                            form.appendChild(input);\n                        }\n                        objectForEach(params, function(key, value) {\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = value;\n                            form.appendChild(input);\n                        });\n                        document.body.appendChild(form);\n                        options['submitter'] ? options['submitter'](form) : form.submit();\n                        setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n                    }\n                }\n            }());\n\n            ko.exportSymbol('utils', ko.utils);\n            ko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\n            ko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\n            ko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\n            ko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\n            ko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\n            ko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\n            ko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\n            ko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\n            ko.exportSymbol('utils.cloneNodes', ko.utils.cloneNodes);\n            ko.exportSymbol('utils.createSymbolOrString', ko.utils.createSymbolOrString);\n            ko.exportSymbol('utils.extend', ko.utils.extend);\n            ko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\n            ko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\n            ko.exportSymbol('utils.objectMap', ko.utils.objectMap);\n            ko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\n            ko.exportSymbol('utils.postJson', ko.utils.postJson);\n            ko.exportSymbol('utils.parseJson', ko.utils.parseJson);\n            ko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\n            ko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\n            ko.exportSymbol('utils.range', ko.utils.range);\n            ko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\n            ko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\n            ko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\n            ko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\n            ko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\n            ko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\n            ko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\n            if (!Function.prototype['bind']) {\n                // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n                // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n                Function.prototype['bind'] = function (object) {\n                    var originalFunction = this;\n                    if (arguments.length === 1) {\n                        return function () {\n                            return originalFunction.apply(object, arguments);\n                        };\n                    } else {\n                        var partialArgs = Array.prototype.slice.call(arguments, 1);\n                        return function () {\n                            var args = partialArgs.slice(0);\n                            args.push.apply(args, arguments);\n                            return originalFunction.apply(object, args);\n                        };\n                    }\n                };\n            }\n\n            ko.utils.domData = new (function () {\n                var uniqueId = 0;\n                var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n                var dataStore = {};\n\n                var getDataForNode, clear;\n                if (!ko.utils.ieVersion) {\n                    // We considered using WeakMap, but it has a problem in IE 11 and Edge that prevents using\n                    // it cross-window, so instead we just store the data directly on the node.\n                    // See https://github.com/knockout/knockout/issues/2141\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataForNode = node[dataStoreKeyExpandoPropertyName];\n                        if (!dataForNode && createIfNotFound) {\n                            dataForNode = node[dataStoreKeyExpandoPropertyName] = {};\n                        }\n                        return dataForNode;\n                    };\n                    clear = function (node) {\n                        if (node[dataStoreKeyExpandoPropertyName]) {\n                            delete node[dataStoreKeyExpandoPropertyName];\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                } else {\n                    // Old IE versions have memory issues if you store objects on the node, so we use a\n                    // separate data storage and link to it from the node using a string key.\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n                        if (!hasExistingDataStore) {\n                            if (!createIfNotFound)\n                                return undefined;\n                            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n                            dataStore[dataStoreKey] = {};\n                        }\n                        return dataStore[dataStoreKey];\n                    };\n                    clear = function (node) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        if (dataStoreKey) {\n                            delete dataStore[dataStoreKey];\n                            node[dataStoreKeyExpandoPropertyName] = null;\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                }\n\n                return {\n                    get: function (node, key) {\n                        var dataForNode = getDataForNode(node, false);\n                        return dataForNode && dataForNode[key];\n                    },\n                    set: function (node, key, value) {\n                        // Make sure we don't actually create a new domData key if we are actually deleting a value\n                        var dataForNode = getDataForNode(node, value !== undefined /* createIfNotFound */);\n                        dataForNode && (dataForNode[key] = value);\n                    },\n                    getOrSet: function (node, key, value) {\n                        var dataForNode = getDataForNode(node, true /* createIfNotFound */);\n                        return dataForNode[key] || (dataForNode[key] = value);\n                    },\n                    clear: clear,\n\n                    nextKey: function () {\n                        return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.domData', ko.utils.domData);\n            ko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\n            ko.utils.domNodeDisposal = new (function () {\n                var domDataKey = ko.utils.domData.nextKey();\n                var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n                var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n                function getDisposeCallbacksCollection(node, createIfNotFound) {\n                    var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n                    if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n                        allDisposeCallbacks = [];\n                        ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n                    }\n                    return allDisposeCallbacks;\n                }\n                function destroyCallbacksCollection(node) {\n                    ko.utils.domData.set(node, domDataKey, undefined);\n                }\n\n                function cleanSingleNode(node) {\n                    // Run all the dispose callbacks\n                    var callbacks = getDisposeCallbacksCollection(node, false);\n                    if (callbacks) {\n                        callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n                        for (var i = 0; i < callbacks.length; i++)\n                            callbacks[i](node);\n                    }\n\n                    // Erase the DOM data\n                    ko.utils.domData.clear(node);\n\n                    // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n                    ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n                    // Clear any immediate-child comment nodes, as these wouldn't have been found by\n                    // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n                    if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                        cleanNodesInList(node.childNodes, true/*onlyComments*/);\n                    }\n                }\n\n                function cleanNodesInList(nodeList, onlyComments) {\n                    var cleanedNodes = [], lastCleanedNode;\n                    for (var i = 0; i < nodeList.length; i++) {\n                        if (!onlyComments || nodeList[i].nodeType === 8) {\n                            cleanSingleNode(cleanedNodes[cleanedNodes.length] = lastCleanedNode = nodeList[i]);\n                            if (nodeList[i] !== lastCleanedNode) {\n                                while (i-- && ko.utils.arrayIndexOf(cleanedNodes, nodeList[i]) == -1) {}\n                            }\n                        }\n                    }\n                }\n\n                return {\n                    addDisposeCallback : function(node, callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"Callback must be a function\");\n                        getDisposeCallbacksCollection(node, true).push(callback);\n                    },\n\n                    removeDisposeCallback : function(node, callback) {\n                        var callbacksCollection = getDisposeCallbacksCollection(node, false);\n                        if (callbacksCollection) {\n                            ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                            if (callbacksCollection.length == 0)\n                                destroyCallbacksCollection(node);\n                        }\n                    },\n\n                    cleanNode : function(node) {\n                        ko.dependencyDetection.ignore(function () {\n                            // First clean this node, where applicable\n                            if (cleanableNodeTypes[node.nodeType]) {\n                                cleanSingleNode(node);\n\n                                // ... then its descendants, where applicable\n                                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                                    cleanNodesInList(node.getElementsByTagName(\"*\"));\n                                }\n                            }\n                        });\n\n                        return node;\n                    },\n\n                    removeNode : function(node) {\n                        ko.cleanNode(node);\n                        if (node.parentNode)\n                            node.parentNode.removeChild(node);\n                    },\n\n                    \"cleanExternalData\" : function (node) {\n                        // Special support for jQuery here because it's so commonly used.\n                        // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n                        // so notify it to tear down any resources associated with the node & descendants here.\n                        if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                            jQueryInstance['cleanData']([node]);\n                    }\n                };\n            })();\n            ko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\n            ko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\n            ko.exportSymbol('cleanNode', ko.cleanNode);\n            ko.exportSymbol('removeNode', ko.removeNode);\n            ko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\n            ko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\n            ko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n            (function () {\n                var none = [0, \"\", \"\"],\n                    table = [1, \"<table>\", \"</table>\"],\n                    tbody = [2, \"<table><tbody>\", \"</tbody></table>\"],\n                    tr = [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"],\n                    select = [1, \"<select multiple='multiple'>\", \"</select>\"],\n                    lookup = {\n                        'thead': table,\n                        'tbody': table,\n                        'tfoot': table,\n                        'tr': tbody,\n                        'td': tr,\n                        'th': tr,\n                        'option': select,\n                        'optgroup': select\n                    },\n\n                    // This is needed for old IE if you're *not* using either jQuery or innerShiv. Doesn't affect other cases.\n                    mayRequireCreateElementHack = ko.utils.ieVersion <= 8;\n\n                function getWrap(tags) {\n                    var m = tags.match(/^(?:<!--.*?-->\\s*?)*?<([a-z]+)[\\s>]/);\n                    return (m && lookup[m[1]]) || none;\n                }\n\n                function simpleHtmlParse(html, documentContext) {\n                    documentContext || (documentContext = document);\n                    var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n                    // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n                    // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n                    // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n                    // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n                    // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n                    // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n                    // Trim whitespace, otherwise indexOf won't work as expected\n                    var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\"),\n                        wrap = getWrap(tags),\n                        depth = wrap[0];\n\n                    // Go to html and back, then peel off extra wrappers\n                    // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n                    var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n                    if (typeof windowContext['innerShiv'] == \"function\") {\n                        // Note that innerShiv is deprecated in favour of html5shiv. We should consider adding\n                        // support for html5shiv (except if no explicit support is needed, e.g., if html5shiv\n                        // somehow shims the native APIs so it just works anyway)\n                        div.appendChild(windowContext['innerShiv'](markup));\n                    } else {\n                        if (mayRequireCreateElementHack) {\n                            // The document.createElement('my-element') trick to enable custom elements in IE6-8\n                            // only works if we assign innerHTML on an element associated with that document.\n                            documentContext.body.appendChild(div);\n                        }\n\n                        div.innerHTML = markup;\n\n                        if (mayRequireCreateElementHack) {\n                            div.parentNode.removeChild(div);\n                        }\n                    }\n\n                    // Move to the right depth\n                    while (depth--)\n                        div = div.lastChild;\n\n                    return ko.utils.makeArray(div.lastChild.childNodes);\n                }\n\n                function jQueryHtmlParse(html, documentContext) {\n                    // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n                    if (jQueryInstance['parseHTML']) {\n                        return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n                    } else {\n                        // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n                        var elems = jQueryInstance['clean']([html], documentContext);\n\n                        // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n                        // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n                        // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n                        if (elems && elems[0]) {\n                            // Find the top-most parent element that's a direct child of a document fragment\n                            var elem = elems[0];\n                            while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                                elem = elem.parentNode;\n                            // ... then detach it\n                            if (elem.parentNode)\n                                elem.parentNode.removeChild(elem);\n                        }\n\n                        return elems;\n                    }\n                }\n\n                ko.utils.parseHtmlFragment = function(html, documentContext) {\n                    return jQueryInstance ?\n                        jQueryHtmlParse(html, documentContext) :   // As below, benefit from jQuery's optimisations where possible\n                        simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n                };\n\n                ko.utils.parseHtmlForTemplateNodes = function(html, documentContext) {\n                    var nodes = ko.utils.parseHtmlFragment(html, documentContext);\n                    return (nodes.length && nodes[0].parentElement) || ko.utils.moveCleanedNodesToContainerElement(nodes);\n                };\n\n                ko.utils.setHtml = function(node, html) {\n                    ko.utils.emptyDomNode(node);\n\n                    // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n                    html = ko.utils.unwrapObservable(html);\n\n                    if ((html !== null) && (html !== undefined)) {\n                        if (typeof html != 'string')\n                            html = html.toString();\n\n                        // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n                        // for example <tr> elements which are not normally allowed to exist on their own.\n                        // If you've referenced jQuery we'll use that rather than duplicating its code.\n                        if (jQueryInstance) {\n                            jQueryInstance(node)['html'](html);\n                        } else {\n                            // ... otherwise, use KO's own parsing logic.\n                            var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                            for (var i = 0; i < parsedNodes.length; i++)\n                                node.appendChild(parsedNodes[i]);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\n            ko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\n            ko.memoization = (function () {\n                var memos = {};\n\n                function randomMax8HexChars() {\n                    return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n                }\n                function generateRandomId() {\n                    return randomMax8HexChars() + randomMax8HexChars();\n                }\n                function findMemoNodes(rootNode, appendToArray) {\n                    if (!rootNode)\n                        return;\n                    if (rootNode.nodeType == 8) {\n                        var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n                        if (memoId != null)\n                            appendToArray.push({ domNode: rootNode, memoId: memoId });\n                    } else if (rootNode.nodeType == 1) {\n                        for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                            findMemoNodes(childNodes[i], appendToArray);\n                    }\n                }\n\n                return {\n                    memoize: function (callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n                        var memoId = generateRandomId();\n                        memos[memoId] = callback;\n                        return \"<!--[ko_memo:\" + memoId + \"]-->\";\n                    },\n\n                    unmemoize: function (memoId, callbackParams) {\n                        var callback = memos[memoId];\n                        if (callback === undefined)\n                            throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n                        try {\n                            callback.apply(null, callbackParams || []);\n                            return true;\n                        }\n                        finally { delete memos[memoId]; }\n                    },\n\n                    unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n                        var memos = [];\n                        findMemoNodes(domNode, memos);\n                        for (var i = 0, j = memos.length; i < j; i++) {\n                            var node = memos[i].domNode;\n                            var combinedParams = [node];\n                            if (extraCallbackParamsArray)\n                                ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                            ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                            node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                            if (node.parentNode)\n                                node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n                        }\n                    },\n\n                    parseMemoText: function (memoText) {\n                        var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n                        return match ? match[1] : null;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('memoization', ko.memoization);\n            ko.exportSymbol('memoization.memoize', ko.memoization.memoize);\n            ko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\n            ko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\n            ko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\n            ko.tasks = (function () {\n                var scheduler,\n                    taskQueue = [],\n                    taskQueueLength = 0,\n                    nextHandle = 1,\n                    nextIndexToProcess = 0;\n\n                if (window['MutationObserver']) {\n                    // Chrome 27+, Firefox 14+, IE 11+, Opera 15+, Safari 6.1+\n                    // From https://github.com/petkaantonov/bluebird * Copyright (c) 2014 Petka Antonov * License: MIT\n                    scheduler = (function (callback) {\n                        var div = document.createElement(\"div\");\n                        new MutationObserver(callback).observe(div, {attributes: true});\n                        return function () { div.classList.toggle(\"foo\"); };\n                    })(scheduledProcess);\n                } else if (document && \"onreadystatechange\" in document.createElement(\"script\")) {\n                    // IE 6-10\n                    // From https://github.com/YuzuJS/setImmediate * Copyright (c) 2012 Barnesandnoble.com, llc, Donavon West, and Domenic Denicola * License: MIT\n                    scheduler = function (callback) {\n                        var script = document.createElement(\"script\");\n                        script.onreadystatechange = function () {\n                            script.onreadystatechange = null;\n                            document.documentElement.removeChild(script);\n                            script = null;\n                            callback();\n                        };\n                        document.documentElement.appendChild(script);\n                    };\n                } else {\n                    scheduler = function (callback) {\n                        setTimeout(callback, 0);\n                    };\n                }\n\n                function processTasks() {\n                    if (taskQueueLength) {\n                        // Each mark represents the end of a logical group of tasks and the number of these groups is\n                        // limited to prevent unchecked recursion.\n                        var mark = taskQueueLength, countMarks = 0;\n\n                        // nextIndexToProcess keeps track of where we are in the queue; processTasks can be called recursively without issue\n                        for (var task; nextIndexToProcess < taskQueueLength; ) {\n                            if (task = taskQueue[nextIndexToProcess++]) {\n                                if (nextIndexToProcess > mark) {\n                                    if (++countMarks >= 5000) {\n                                        nextIndexToProcess = taskQueueLength;   // skip all tasks remaining in the queue since any of them could be causing the recursion\n                                        ko.utils.deferError(Error(\"'Too much recursion' after processing \" + countMarks + \" task groups.\"));\n                                        break;\n                                    }\n                                    mark = taskQueueLength;\n                                }\n                                try {\n                                    task();\n                                } catch (ex) {\n                                    ko.utils.deferError(ex);\n                                }\n                            }\n                        }\n                    }\n                }\n\n                function scheduledProcess() {\n                    processTasks();\n\n                    // Reset the queue\n                    nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                }\n\n                function scheduleTaskProcessing() {\n                    ko.tasks['scheduler'](scheduledProcess);\n                }\n\n                var tasks = {\n                    'scheduler': scheduler,     // Allow overriding the scheduler\n\n                    schedule: function (func) {\n                        if (!taskQueueLength) {\n                            scheduleTaskProcessing();\n                        }\n\n                        taskQueue[taskQueueLength++] = func;\n                        return nextHandle++;\n                    },\n\n                    cancel: function (handle) {\n                        var index = handle - (nextHandle - taskQueueLength);\n                        if (index >= nextIndexToProcess && index < taskQueueLength) {\n                            taskQueue[index] = null;\n                        }\n                    },\n\n                    // For testing only: reset the queue and return the previous queue length\n                    'resetForTesting': function () {\n                        var length = taskQueueLength - nextIndexToProcess;\n                        nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                        return length;\n                    },\n\n                    runEarly: processTasks\n                };\n\n                return tasks;\n            })();\n\n            ko.exportSymbol('tasks', ko.tasks);\n            ko.exportSymbol('tasks.schedule', ko.tasks.schedule);\n//ko.exportSymbol('tasks.cancel', ko.tasks.cancel);  \"cancel\" isn't minified\n            ko.exportSymbol('tasks.runEarly', ko.tasks.runEarly);\n            ko.extenders = {\n                'throttle': function(target, timeout) {\n                    // Throttling means two things:\n\n                    // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n                    //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n                    target['throttleEvaluation'] = timeout;\n\n                    // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n                    //     so the target cannot change value synchronously or faster than a certain rate\n                    var writeTimeoutInstance = null;\n                    return ko.dependentObservable({\n                        'read': target,\n                        'write': function(value) {\n                            clearTimeout(writeTimeoutInstance);\n                            writeTimeoutInstance = ko.utils.setTimeout(function() {\n                                target(value);\n                            }, timeout);\n                        }\n                    });\n                },\n\n                'rateLimit': function(target, options) {\n                    var timeout, method, limitFunction;\n\n                    if (typeof options == 'number') {\n                        timeout = options;\n                    } else {\n                        timeout = options['timeout'];\n                        method = options['method'];\n                    }\n\n                    // rateLimit supersedes deferred updates\n                    target._deferUpdates = false;\n\n                    limitFunction = typeof method == 'function' ? method : method == 'notifyWhenChangesStop' ?  debounce : throttle;\n                    target.limit(function(callback) {\n                        return limitFunction(callback, timeout, options);\n                    });\n                },\n\n                'deferred': function(target, options) {\n                    if (options !== true) {\n                        throw new Error('The \\'deferred\\' extender only accepts the value \\'true\\', because it is not supported to turn deferral off once enabled.')\n                    }\n\n                    if (!target._deferUpdates) {\n                        target._deferUpdates = true;\n                        target.limit(function (callback) {\n                            var handle,\n                                ignoreUpdates = false;\n                            return function () {\n                                if (!ignoreUpdates) {\n                                    ko.tasks.cancel(handle);\n                                    handle = ko.tasks.schedule(callback);\n\n                                    try {\n                                        ignoreUpdates = true;\n                                        target['notifySubscribers'](undefined, 'dirty');\n                                    } finally {\n                                        ignoreUpdates = false;\n                                    }\n                                }\n                            };\n                        });\n                    }\n                },\n\n                'notify': function(target, notifyWhen) {\n                    target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n                        null :  // null equalityComparer means to always notify\n                        valuesArePrimitiveAndEqual;\n                }\n            };\n\n            var primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\n            function valuesArePrimitiveAndEqual(a, b) {\n                var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n                return oldValueIsPrimitive ? (a === b) : false;\n            }\n\n            function throttle(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    if (!timeoutInstance) {\n                        timeoutInstance = ko.utils.setTimeout(function () {\n                            timeoutInstance = undefined;\n                            callback();\n                        }, timeout);\n                    }\n                };\n            }\n\n            function debounce(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    clearTimeout(timeoutInstance);\n                    timeoutInstance = ko.utils.setTimeout(callback, timeout);\n                };\n            }\n\n            function applyExtenders(requestedExtenders) {\n                var target = this;\n                if (requestedExtenders) {\n                    ko.utils.objectForEach(requestedExtenders, function(key, value) {\n                        var extenderHandler = ko.extenders[key];\n                        if (typeof extenderHandler == 'function') {\n                            target = extenderHandler(target, value) || target;\n                        }\n                    });\n                }\n                return target;\n            }\n\n            ko.exportSymbol('extenders', ko.extenders);\n\n            ko.subscription = function (target, callback, disposeCallback) {\n                this._target = target;\n                this._callback = callback;\n                this._disposeCallback = disposeCallback;\n                this._isDisposed = false;\n                this._node = null;\n                this._domNodeDisposalCallback = null;\n                ko.exportProperty(this, 'dispose', this.dispose);\n                ko.exportProperty(this, 'disposeWhenNodeIsRemoved', this.disposeWhenNodeIsRemoved);\n            };\n            ko.subscription.prototype.dispose = function () {\n                var self = this;\n                if (!self._isDisposed) {\n                    if (self._domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(self._node, self._domNodeDisposalCallback);\n                    }\n                    self._isDisposed = true;\n                    self._disposeCallback();\n\n                    self._target = self._callback = self._disposeCallback = self._node = self._domNodeDisposalCallback = null;\n                }\n            };\n            ko.subscription.prototype.disposeWhenNodeIsRemoved = function (node) {\n                this._node = node;\n                ko.utils.domNodeDisposal.addDisposeCallback(node, this._domNodeDisposalCallback = this.dispose.bind(this));\n            };\n\n            ko.subscribable = function () {\n                ko.utils.setPrototypeOfOrExtend(this, ko_subscribable_fn);\n                ko_subscribable_fn.init(this);\n            }\n\n            var defaultEvent = \"change\";\n\n// Moved out of \"limit\" to avoid the extra closure\n            function limitNotifySubscribers(value, event) {\n                if (!event || event === defaultEvent) {\n                    this._limitChange(value);\n                } else if (event === 'beforeChange') {\n                    this._limitBeforeChange(value);\n                } else {\n                    this._origNotifySubscribers(value, event);\n                }\n            }\n\n            var ko_subscribable_fn = {\n                init: function(instance) {\n                    instance._subscriptions = { \"change\": [] };\n                    instance._versionNumber = 1;\n                },\n\n                subscribe: function (callback, callbackTarget, event) {\n                    var self = this;\n\n                    event = event || defaultEvent;\n                    var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n                    var subscription = new ko.subscription(self, boundCallback, function () {\n                        ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n                        if (self.afterSubscriptionRemove)\n                            self.afterSubscriptionRemove(event);\n                    });\n\n                    if (self.beforeSubscriptionAdd)\n                        self.beforeSubscriptionAdd(event);\n\n                    if (!self._subscriptions[event])\n                        self._subscriptions[event] = [];\n                    self._subscriptions[event].push(subscription);\n\n                    return subscription;\n                },\n\n                \"notifySubscribers\": function (valueToNotify, event) {\n                    event = event || defaultEvent;\n                    if (event === defaultEvent) {\n                        this.updateVersion();\n                    }\n                    if (this.hasSubscriptionsForEvent(event)) {\n                        var subs = event === defaultEvent && this._changeSubscriptions || this._subscriptions[event].slice(0);\n                        try {\n                            ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                            for (var i = 0, subscription; subscription = subs[i]; ++i) {\n                                // In case a subscription was disposed during the arrayForEach cycle, check\n                                // for isDisposed on each subscription before invoking its callback\n                                if (!subscription._isDisposed)\n                                    subscription._callback(valueToNotify);\n                            }\n                        } finally {\n                            ko.dependencyDetection.end(); // End suppressing dependency detection\n                        }\n                    }\n                },\n\n                getVersion: function () {\n                    return this._versionNumber;\n                },\n\n                hasChanged: function (versionToCheck) {\n                    return this.getVersion() !== versionToCheck;\n                },\n\n                updateVersion: function () {\n                    ++this._versionNumber;\n                },\n\n                limit: function(limitFunction) {\n                    var self = this, selfIsObservable = ko.isObservable(self),\n                        ignoreBeforeChange, notifyNextChange, previousValue, pendingValue, didUpdate,\n                        beforeChange = 'beforeChange';\n\n                    if (!self._origNotifySubscribers) {\n                        self._origNotifySubscribers = self[\"notifySubscribers\"];\n                        self[\"notifySubscribers\"] = limitNotifySubscribers;\n                    }\n\n                    var finish = limitFunction(function() {\n                        self._notificationIsPending = false;\n\n                        // If an observable provided a reference to itself, access it to get the latest value.\n                        // This allows computed observables to delay calculating their value until needed.\n                        if (selfIsObservable && pendingValue === self) {\n                            pendingValue = self._evalIfChanged ? self._evalIfChanged() : self();\n                        }\n                        var shouldNotify = notifyNextChange || (didUpdate && self.isDifferent(previousValue, pendingValue));\n\n                        didUpdate = notifyNextChange = ignoreBeforeChange = false;\n\n                        if (shouldNotify) {\n                            self._origNotifySubscribers(previousValue = pendingValue);\n                        }\n                    });\n\n                    self._limitChange = function(value, isDirty) {\n                        if (!isDirty || !self._notificationIsPending) {\n                            didUpdate = !isDirty;\n                        }\n                        self._changeSubscriptions = self._subscriptions[defaultEvent].slice(0);\n                        self._notificationIsPending = ignoreBeforeChange = true;\n                        pendingValue = value;\n                        finish();\n                    };\n                    self._limitBeforeChange = function(value) {\n                        if (!ignoreBeforeChange) {\n                            previousValue = value;\n                            self._origNotifySubscribers(value, beforeChange);\n                        }\n                    };\n                    self._recordUpdate = function() {\n                        didUpdate = true;\n                    };\n                    self._notifyNextChangeIfValueIsDifferent = function() {\n                        if (self.isDifferent(previousValue, self.peek(true /*evaluate*/))) {\n                            notifyNextChange = true;\n                        }\n                    };\n                },\n\n                hasSubscriptionsForEvent: function(event) {\n                    return this._subscriptions[event] && this._subscriptions[event].length;\n                },\n\n                getSubscriptionsCount: function (event) {\n                    if (event) {\n                        return this._subscriptions[event] && this._subscriptions[event].length || 0;\n                    } else {\n                        var total = 0;\n                        ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                            if (eventName !== 'dirty')\n                                total += subscriptions.length;\n                        });\n                        return total;\n                    }\n                },\n\n                isDifferent: function(oldValue, newValue) {\n                    return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n                },\n\n                toString: function() {\n                    return '[object Object]'\n                },\n\n                extend: applyExtenders\n            };\n\n            ko.exportProperty(ko_subscribable_fn, 'init', ko_subscribable_fn.init);\n            ko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\n            ko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\n            ko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n            }\n\n            ko.subscribable['fn'] = ko_subscribable_fn;\n\n\n            ko.isSubscribable = function (instance) {\n                return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n            };\n\n            ko.exportSymbol('subscribable', ko.subscribable);\n            ko.exportSymbol('isSubscribable', ko.isSubscribable);\n\n            ko.computedContext = ko.dependencyDetection = (function () {\n                var outerFrames = [],\n                    currentFrame,\n                    lastId = 0;\n\n                // Return a unique ID that can be assigned to an observable for dependency tracking.\n                // Theoretically, you could eventually overflow the number storage size, resulting\n                // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n                // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n                // take over 285 years to reach that number.\n                // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n                function getId() {\n                    return ++lastId;\n                }\n\n                function begin(options) {\n                    outerFrames.push(currentFrame);\n                    currentFrame = options;\n                }\n\n                function end() {\n                    currentFrame = outerFrames.pop();\n                }\n\n                return {\n                    begin: begin,\n\n                    end: end,\n\n                    registerDependency: function (subscribable) {\n                        if (currentFrame) {\n                            if (!ko.isSubscribable(subscribable))\n                                throw new Error(\"Only subscribable things can act as dependencies\");\n                            currentFrame.callback.call(currentFrame.callbackTarget, subscribable, subscribable._id || (subscribable._id = getId()));\n                        }\n                    },\n\n                    ignore: function (callback, callbackTarget, callbackArgs) {\n                        try {\n                            begin();\n                            return callback.apply(callbackTarget, callbackArgs || []);\n                        } finally {\n                            end();\n                        }\n                    },\n\n                    getDependenciesCount: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependenciesCount();\n                    },\n\n                    getDependencies: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependencies();\n                    },\n\n                    isInitial: function() {\n                        if (currentFrame)\n                            return currentFrame.isInitial;\n                    },\n\n                    computed: function() {\n                        if (currentFrame)\n                            return currentFrame.computed;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('computedContext', ko.computedContext);\n            ko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\n            ko.exportSymbol('computedContext.getDependencies', ko.computedContext.getDependencies);\n            ko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\n            ko.exportSymbol('computedContext.registerDependency', ko.computedContext.registerDependency);\n\n            ko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\n            var observableLatestValue = ko.utils.createSymbolOrString('_latestValue');\n\n            ko.observable = function (initialValue) {\n                function observable() {\n                    if (arguments.length > 0) {\n                        // Write\n\n                        // Ignore writes if the value hasn't changed\n                        if (observable.isDifferent(observable[observableLatestValue], arguments[0])) {\n                            observable.valueWillMutate();\n                            observable[observableLatestValue] = arguments[0];\n                            observable.valueHasMutated();\n                        }\n                        return this; // Permits chained assignments\n                    }\n                    else {\n                        // Read\n                        ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n                        return observable[observableLatestValue];\n                    }\n                }\n\n                observable[observableLatestValue] = initialValue;\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(observable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(observable);\n\n                // Inherit from 'observable'\n                ko.utils.setPrototypeOfOrExtend(observable, observableFn);\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](observable, true);\n                }\n\n                return observable;\n            }\n\n// Define prototype for observables\n            var observableFn = {\n                'equalityComparer': valuesArePrimitiveAndEqual,\n                peek: function() { return this[observableLatestValue]; },\n                valueHasMutated: function () {\n                    this['notifySubscribers'](this[observableLatestValue], 'spectate');\n                    this['notifySubscribers'](this[observableLatestValue]);\n                },\n                valueWillMutate: function () { this['notifySubscribers'](this[observableLatestValue], 'beforeChange'); }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(observableFn, ko.subscribable['fn']);\n            }\n\n            var protoProperty = ko.observable.protoProperty = '__ko_proto__';\n            observableFn[protoProperty] = ko.observable;\n\n            ko.isObservable = function (instance) {\n                var proto = typeof instance == 'function' && instance[protoProperty];\n                if (proto && proto !== observableFn[protoProperty] && proto !== ko.computed['fn'][protoProperty]) {\n                    throw Error(\"Invalid object that looks like an observable; possibly from another Knockout instance\");\n                }\n                return !!proto;\n            };\n\n            ko.isWriteableObservable = function (instance) {\n                return (typeof instance == 'function' && (\n                    (instance[protoProperty] === observableFn[protoProperty]) ||  // Observable\n                    (instance[protoProperty] === ko.computed['fn'][protoProperty] && instance.hasWriteFunction)));   // Writable computed observable\n            };\n\n            ko.exportSymbol('observable', ko.observable);\n            ko.exportSymbol('isObservable', ko.isObservable);\n            ko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('observable.fn', observableFn);\n            ko.exportProperty(observableFn, 'peek', observableFn.peek);\n            ko.exportProperty(observableFn, 'valueHasMutated', observableFn.valueHasMutated);\n            ko.exportProperty(observableFn, 'valueWillMutate', observableFn.valueWillMutate);\n            ko.observableArray = function (initialValues) {\n                initialValues = initialValues || [];\n\n                if (typeof initialValues != 'object' || !('length' in initialValues))\n                    throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n                var result = ko.observable(initialValues);\n                ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n                return result.extend({'trackArrayChanges':true});\n            };\n\n            ko.observableArray['fn'] = {\n                'remove': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var removedValues = [];\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    for (var i = 0; i < underlyingArray.length; i++) {\n                        var value = underlyingArray[i];\n                        if (predicate(value)) {\n                            if (removedValues.length === 0) {\n                                this.valueWillMutate();\n                            }\n                            if (underlyingArray[i] !== value) {\n                                throw Error(\"Array modified during remove; cannot remove item\");\n                            }\n                            removedValues.push(value);\n                            underlyingArray.splice(i, 1);\n                            i--;\n                        }\n                    }\n                    if (removedValues.length) {\n                        this.valueHasMutated();\n                    }\n                    return removedValues;\n                },\n\n                'removeAll': function (arrayOfValues) {\n                    // If you passed zero args, we remove everything\n                    if (arrayOfValues === undefined) {\n                        var underlyingArray = this.peek();\n                        var allValues = underlyingArray.slice(0);\n                        this.valueWillMutate();\n                        underlyingArray.splice(0, underlyingArray.length);\n                        this.valueHasMutated();\n                        return allValues;\n                    }\n                    // If you passed an arg, we interpret it as an array of entries to remove\n                    if (!arrayOfValues)\n                        return [];\n                    return this['remove'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'destroy': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    this.valueWillMutate();\n                    for (var i = underlyingArray.length - 1; i >= 0; i--) {\n                        var value = underlyingArray[i];\n                        if (predicate(value))\n                            value[\"_destroy\"] = true;\n                    }\n                    this.valueHasMutated();\n                },\n\n                'destroyAll': function (arrayOfValues) {\n                    // If you passed zero args, we destroy everything\n                    if (arrayOfValues === undefined)\n                        return this['destroy'](function() { return true });\n\n                    // If you passed an arg, we interpret it as an array of entries to destroy\n                    if (!arrayOfValues)\n                        return [];\n                    return this['destroy'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'indexOf': function (item) {\n                    var underlyingArray = this();\n                    return ko.utils.arrayIndexOf(underlyingArray, item);\n                },\n\n                'replace': function(oldItem, newItem) {\n                    var index = this['indexOf'](oldItem);\n                    if (index >= 0) {\n                        this.valueWillMutate();\n                        this.peek()[index] = newItem;\n                        this.valueHasMutated();\n                    }\n                },\n\n                'sorted': function (compareFunction) {\n                    var arrayCopy = this().slice(0);\n                    return compareFunction ? arrayCopy.sort(compareFunction) : arrayCopy.sort();\n                },\n\n                'reversed': function () {\n                    return this().slice(0).reverse();\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n            }\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\n            ko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n                    // (for consistency with mutating regular observables)\n                    var underlyingArray = this.peek();\n                    this.valueWillMutate();\n                    this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n                    var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n                    this.valueHasMutated();\n                    // The native sort and reverse methods return a reference to the array, but it makes more sense to return the observable array instead.\n                    return methodCallResult === underlyingArray ? this : methodCallResult;\n                };\n            });\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\n            ko.utils.arrayForEach([\"slice\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    var underlyingArray = this();\n                    return underlyingArray[methodName].apply(underlyingArray, arguments);\n                };\n            });\n\n            ko.isObservableArray = function (instance) {\n                return ko.isObservable(instance)\n                    && typeof instance[\"remove\"] == \"function\"\n                    && typeof instance[\"push\"] == \"function\";\n            };\n\n            ko.exportSymbol('observableArray', ko.observableArray);\n            ko.exportSymbol('isObservableArray', ko.isObservableArray);\n            var arrayChangeEventName = 'arrayChange';\n            ko.extenders['trackArrayChanges'] = function(target, options) {\n                // Use the provided options--each call to trackArrayChanges overwrites the previously set options\n                target.compareArrayOptions = {};\n                if (options && typeof options == \"object\") {\n                    ko.utils.extend(target.compareArrayOptions, options);\n                }\n                target.compareArrayOptions['sparse'] = true;\n\n                // Only modify the target observable once\n                if (target.cacheDiffForKnownOperation) {\n                    return;\n                }\n                var trackingChanges = false,\n                    cachedDiff = null,\n                    changeSubscription,\n                    spectateSubscription,\n                    pendingChanges = 0,\n                    previousContents,\n                    underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n                    underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n                // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n                target.beforeSubscriptionAdd = function (event) {\n                    if (underlyingBeforeSubscriptionAddFunction) {\n                        underlyingBeforeSubscriptionAddFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName) {\n                        trackChanges();\n                    }\n                };\n                // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n                target.afterSubscriptionRemove = function (event) {\n                    if (underlyingAfterSubscriptionRemoveFunction) {\n                        underlyingAfterSubscriptionRemoveFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                        if (changeSubscription) {\n                            changeSubscription.dispose();\n                        }\n                        if (spectateSubscription) {\n                            spectateSubscription.dispose();\n                        }\n                        spectateSubscription = changeSubscription = null;\n                        trackingChanges = false;\n                        previousContents = undefined;\n                    }\n                };\n\n                function trackChanges() {\n                    if (trackingChanges) {\n                        // Whenever there's a new subscription and there are pending notifications, make sure all previous\n                        // subscriptions are notified of the change so that all subscriptions are in sync.\n                        notifyChanges();\n                        return;\n                    }\n\n                    trackingChanges = true;\n\n                    // Track how many times the array actually changed value\n                    spectateSubscription = target.subscribe(function () {\n                        ++pendingChanges;\n                    }, null, \"spectate\");\n\n                    // Each time the array changes value, capture a clone so that on the next\n                    // change it's possible to produce a diff\n                    previousContents = [].concat(target.peek() || []);\n                    cachedDiff = null;\n                    changeSubscription = target.subscribe(notifyChanges);\n\n                    function notifyChanges() {\n                        if (pendingChanges) {\n                            // Make a copy of the current contents and ensure it's an array\n                            var currentContents = [].concat(target.peek() || []), changes;\n\n                            // Compute the diff and issue notifications, but only if someone is listening\n                            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                                changes = getChanges(previousContents, currentContents);\n                            }\n\n                            // Eliminate references to the old, removed items, so they can be GCed\n                            previousContents = currentContents;\n                            cachedDiff = null;\n                            pendingChanges = 0;\n\n                            if (changes && changes.length) {\n                                target['notifySubscribers'](changes, arrayChangeEventName);\n                            }\n                        }\n                    }\n                }\n\n                function getChanges(previousContents, currentContents) {\n                    // We try to re-use cached diffs.\n                    // The scenarios where pendingChanges > 1 are when using rate limiting or deferred updates,\n                    // which without this check would not be compatible with arrayChange notifications. Normally,\n                    // notifications are issued immediately so we wouldn't be queueing up more than one.\n                    if (!cachedDiff || pendingChanges > 1) {\n                        cachedDiff = ko.utils.compareArrays(previousContents, currentContents, target.compareArrayOptions);\n                    }\n\n                    return cachedDiff;\n                }\n\n                target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n                    // Only run if we're currently tracking changes for this observable array\n                    // and there aren't any pending deferred notifications.\n                    if (!trackingChanges || pendingChanges) {\n                        return;\n                    }\n                    var diff = [],\n                        arrayLength = rawArray.length,\n                        argsLength = args.length,\n                        offset = 0;\n\n                    function pushDiff(status, value, index) {\n                        return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n                    }\n                    switch (operationName) {\n                        case 'push':\n                            offset = arrayLength;\n                        case 'unshift':\n                            for (var index = 0; index < argsLength; index++) {\n                                pushDiff('added', args[index], offset + index);\n                            }\n                            break;\n\n                        case 'pop':\n                            offset = arrayLength - 1;\n                        case 'shift':\n                            if (arrayLength) {\n                                pushDiff('deleted', rawArray[offset], offset);\n                            }\n                            break;\n\n                        case 'splice':\n                            // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                            // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                            var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                                endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                                endAddIndex = startIndex + argsLength - 2,\n                                endIndex = Math.max(endDeleteIndex, endAddIndex),\n                                additions = [], deletions = [];\n                            for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                                if (index < endDeleteIndex)\n                                    deletions.push(pushDiff('deleted', rawArray[index], index));\n                                if (index < endAddIndex)\n                                    additions.push(pushDiff('added', args[argsIndex], index));\n                            }\n                            ko.utils.findMovesInArrayComparison(deletions, additions);\n                            break;\n\n                        default:\n                            return;\n                    }\n                    cachedDiff = diff;\n                };\n            };\n            var computedState = ko.utils.createSymbolOrString('_state');\n\n            ko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n                if (typeof evaluatorFunctionOrOptions === \"object\") {\n                    // Single-parameter syntax - everything is on this \"options\" param\n                    options = evaluatorFunctionOrOptions;\n                } else {\n                    // Multi-parameter syntax - construct the options according to the params passed\n                    options = options || {};\n                    if (evaluatorFunctionOrOptions) {\n                        options[\"read\"] = evaluatorFunctionOrOptions;\n                    }\n                }\n                if (typeof options[\"read\"] != \"function\")\n                    throw Error(\"Pass a function that returns the value of the ko.computed\");\n\n                var writeFunction = options[\"write\"];\n                var state = {\n                    latestValue: undefined,\n                    isStale: true,\n                    isDirty: true,\n                    isBeingEvaluated: false,\n                    suppressDisposalUntilDisposeWhenReturnsFalse: false,\n                    isDisposed: false,\n                    pure: false,\n                    isSleeping: false,\n                    readFunction: options[\"read\"],\n                    evaluatorFunctionTarget: evaluatorFunctionTarget || options[\"owner\"],\n                    disposeWhenNodeIsRemoved: options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n                    disposeWhen: options[\"disposeWhen\"] || options.disposeWhen,\n                    domNodeDisposalCallback: null,\n                    dependencyTracking: {},\n                    dependenciesCount: 0,\n                    evaluationTimeoutInstance: null\n                };\n\n                function computedObservable() {\n                    if (arguments.length > 0) {\n                        if (typeof writeFunction === \"function\") {\n                            // Writing a value\n                            writeFunction.apply(state.evaluatorFunctionTarget, arguments);\n                        } else {\n                            throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n                        }\n                        return this; // Permits chained assignments\n                    } else {\n                        // Reading the value\n                        if (!state.isDisposed) {\n                            ko.dependencyDetection.registerDependency(computedObservable);\n                        }\n                        if (state.isDirty || (state.isSleeping && computedObservable.haveDependenciesChanged())) {\n                            computedObservable.evaluateImmediate();\n                        }\n                        return state.latestValue;\n                    }\n                }\n\n                computedObservable[computedState] = state;\n                computedObservable.hasWriteFunction = typeof writeFunction === \"function\";\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(computedObservable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(computedObservable);\n\n                // Inherit from 'computed'\n                ko.utils.setPrototypeOfOrExtend(computedObservable, computedFn);\n\n                if (options['pure']) {\n                    state.pure = true;\n                    state.isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n                    ko.utils.extend(computedObservable, pureComputedOverrides);\n                } else if (options['deferEvaluation']) {\n                    ko.utils.extend(computedObservable, deferEvaluationOverrides);\n                }\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](computedObservable, true);\n                }\n\n                if (DEBUG) {\n                    // #1731 - Aid debugging by exposing the computed's options\n                    computedObservable[\"_options\"] = options;\n                }\n\n                if (state.disposeWhenNodeIsRemoved) {\n                    // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n                    // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n                    // we'll prevent disposal until \"disposeWhen\" first returns false.\n                    state.suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n                    // disposeWhenNodeIsRemoved: true can be used to opt into the \"only dispose after first false result\"\n                    // behaviour even if there's no specific node to watch. In that case, clear the option so we don't try\n                    // to watch for a non-node's disposal. This technique is intended for KO's internal use only and shouldn't\n                    // be documented or used by application code, as it's likely to change in a future version of KO.\n                    if (!state.disposeWhenNodeIsRemoved.nodeType) {\n                        state.disposeWhenNodeIsRemoved = null;\n                    }\n                }\n\n                // Evaluate, unless sleeping or deferEvaluation is true\n                if (!state.isSleeping && !options['deferEvaluation']) {\n                    computedObservable.evaluateImmediate();\n                }\n\n                // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n                // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n                if (state.disposeWhenNodeIsRemoved && computedObservable.isActive()) {\n                    ko.utils.domNodeDisposal.addDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback = function () {\n                        computedObservable.dispose();\n                    });\n                }\n\n                return computedObservable;\n            };\n\n// Utility function that disposes a given dependencyTracking entry\n            function computedDisposeDependencyCallback(id, entryToDispose) {\n                if (entryToDispose !== null && entryToDispose.dispose) {\n                    entryToDispose.dispose();\n                }\n            }\n\n// This function gets called each time a dependency is detected while evaluating a computed.\n// It's factored out as a shared function to avoid creating unnecessary function instances during evaluation.\n            function computedBeginDependencyDetectionCallback(subscribable, id) {\n                var computedObservable = this.computedObservable,\n                    state = computedObservable[computedState];\n                if (!state.isDisposed) {\n                    if (this.disposalCount && this.disposalCandidates[id]) {\n                        // Don't want to dispose this subscription, as it's still being used\n                        computedObservable.addDependencyTracking(id, subscribable, this.disposalCandidates[id]);\n                        this.disposalCandidates[id] = null; // No need to actually delete the property - disposalCandidates is a transient object anyway\n                        --this.disposalCount;\n                    } else if (!state.dependencyTracking[id]) {\n                        // Brand new subscription - add it\n                        computedObservable.addDependencyTracking(id, subscribable, state.isSleeping ? { _target: subscribable } : computedObservable.subscribeToDependency(subscribable));\n                    }\n                    // If the observable we've accessed has a pending notification, ensure we get notified of the actual final value (bypass equality checks)\n                    if (subscribable._notificationIsPending) {\n                        subscribable._notifyNextChangeIfValueIsDifferent();\n                    }\n                }\n            }\n\n            var computedFn = {\n                \"equalityComparer\": valuesArePrimitiveAndEqual,\n                getDependenciesCount: function () {\n                    return this[computedState].dependenciesCount;\n                },\n                getDependencies: function () {\n                    var dependencyTracking = this[computedState].dependencyTracking, dependentObservables = [];\n\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependentObservables[dependency._order] = dependency._target;\n                    });\n\n                    return dependentObservables;\n                },\n                hasAncestorDependency: function (obs) {\n                    if (!this[computedState].dependenciesCount) {\n                        return false;\n                    }\n                    var dependencies = this.getDependencies();\n                    if (ko.utils.arrayIndexOf(dependencies, obs) !== -1) {\n                        return true;\n                    }\n                    return !!ko.utils.arrayFirst(dependencies, function (dep) {\n                        return dep.hasAncestorDependency && dep.hasAncestorDependency(obs);\n                    });\n                },\n                addDependencyTracking: function (id, target, trackingObj) {\n                    if (this[computedState].pure && target === this) {\n                        throw Error(\"A 'pure' computed must not be called recursively\");\n                    }\n\n                    this[computedState].dependencyTracking[id] = trackingObj;\n                    trackingObj._order = this[computedState].dependenciesCount++;\n                    trackingObj._version = target.getVersion();\n                },\n                haveDependenciesChanged: function () {\n                    var id, dependency, dependencyTracking = this[computedState].dependencyTracking;\n                    for (id in dependencyTracking) {\n                        if (Object.prototype.hasOwnProperty.call(dependencyTracking, id)) {\n                            dependency = dependencyTracking[id];\n                            if ((this._evalDelayed && dependency._target._notificationIsPending) || dependency._target.hasChanged(dependency._version)) {\n                                return true;\n                            }\n                        }\n                    }\n                },\n                markDirty: function () {\n                    // Process \"dirty\" events if we can handle delayed notifications\n                    if (this._evalDelayed && !this[computedState].isBeingEvaluated) {\n                        this._evalDelayed(false /*isChange*/);\n                    }\n                },\n                isActive: function () {\n                    var state = this[computedState];\n                    return state.isDirty || state.dependenciesCount > 0;\n                },\n                respondToChange: function () {\n                    // Ignore \"change\" events if we've already scheduled a delayed notification\n                    if (!this._notificationIsPending) {\n                        this.evaluatePossiblyAsync();\n                    } else if (this[computedState].isDirty) {\n                        this[computedState].isStale = true;\n                    }\n                },\n                subscribeToDependency: function (target) {\n                    if (target._deferUpdates) {\n                        var dirtySub = target.subscribe(this.markDirty, this, 'dirty'),\n                            changeSub = target.subscribe(this.respondToChange, this);\n                        return {\n                            _target: target,\n                            dispose: function () {\n                                dirtySub.dispose();\n                                changeSub.dispose();\n                            }\n                        };\n                    } else {\n                        return target.subscribe(this.evaluatePossiblyAsync, this);\n                    }\n                },\n                evaluatePossiblyAsync: function () {\n                    var computedObservable = this,\n                        throttleEvaluationTimeout = computedObservable['throttleEvaluation'];\n                    if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n                        clearTimeout(this[computedState].evaluationTimeoutInstance);\n                        this[computedState].evaluationTimeoutInstance = ko.utils.setTimeout(function () {\n                            computedObservable.evaluateImmediate(true /*notifyChange*/);\n                        }, throttleEvaluationTimeout);\n                    } else if (computedObservable._evalDelayed) {\n                        computedObservable._evalDelayed(true /*isChange*/);\n                    } else {\n                        computedObservable.evaluateImmediate(true /*notifyChange*/);\n                    }\n                },\n                evaluateImmediate: function (notifyChange) {\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        disposeWhen = state.disposeWhen,\n                        changed = false;\n\n                    if (state.isBeingEvaluated) {\n                        // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n                        // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n                        // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n                        // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n                        return;\n                    }\n\n                    // Do not evaluate (and possibly capture new dependencies) if disposed\n                    if (state.isDisposed) {\n                        return;\n                    }\n\n                    if (state.disposeWhenNodeIsRemoved && !ko.utils.domNodeIsAttachedToDocument(state.disposeWhenNodeIsRemoved) || disposeWhen && disposeWhen()) {\n                        // See comment above about suppressDisposalUntilDisposeWhenReturnsFalse\n                        if (!state.suppressDisposalUntilDisposeWhenReturnsFalse) {\n                            computedObservable.dispose();\n                            return;\n                        }\n                    } else {\n                        // It just did return false, so we can stop suppressing now\n                        state.suppressDisposalUntilDisposeWhenReturnsFalse = false;\n                    }\n\n                    state.isBeingEvaluated = true;\n                    try {\n                        changed = this.evaluateImmediate_CallReadWithDependencyDetection(notifyChange);\n                    } finally {\n                        state.isBeingEvaluated = false;\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadWithDependencyDetection: function (notifyChange) {\n                    // This function is really just part of the evaluateImmediate logic. You would never call it from anywhere else.\n                    // Factoring it out into a separate function means it can be independent of the try/catch block in evaluateImmediate,\n                    // which contributes to saving about 40% off the CPU overhead of computed evaluation (on V8 at least).\n\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        changed = false;\n\n                    // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n                    // Then, during evaluation, we cross off any that are in fact still being used.\n                    var isInitial = state.pure ? undefined : !state.dependenciesCount,   // If we're evaluating when there are no previous dependencies, it must be the first time\n                        dependencyDetectionContext = {\n                            computedObservable: computedObservable,\n                            disposalCandidates: state.dependencyTracking,\n                            disposalCount: state.dependenciesCount\n                        };\n\n                    ko.dependencyDetection.begin({\n                        callbackTarget: dependencyDetectionContext,\n                        callback: computedBeginDependencyDetectionCallback,\n                        computed: computedObservable,\n                        isInitial: isInitial\n                    });\n\n                    state.dependencyTracking = {};\n                    state.dependenciesCount = 0;\n\n                    var newValue = this.evaluateImmediate_CallReadThenEndDependencyDetection(state, dependencyDetectionContext);\n\n                    if (!state.dependenciesCount) {\n                        computedObservable.dispose();\n                        changed = true; // When evaluation causes a disposal, make sure all dependent computeds get notified so they'll see the new state\n                    } else {\n                        changed = computedObservable.isDifferent(state.latestValue, newValue);\n                    }\n\n                    if (changed) {\n                        if (!state.isSleeping) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"beforeChange\");\n                        } else {\n                            computedObservable.updateVersion();\n                        }\n\n                        state.latestValue = newValue;\n                        if (DEBUG) computedObservable._latestValue = newValue;\n\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"spectate\");\n\n                        if (!state.isSleeping && notifyChange) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue);\n                        }\n                        if (computedObservable._recordUpdate) {\n                            computedObservable._recordUpdate();\n                        }\n                    }\n\n                    if (isInitial) {\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadThenEndDependencyDetection: function (state, dependencyDetectionContext) {\n                    // This function is really part of the evaluateImmediate_CallReadWithDependencyDetection logic.\n                    // You'd never call it from anywhere else. Factoring it out means that evaluateImmediate_CallReadWithDependencyDetection\n                    // can be independent of try/finally blocks, which contributes to saving about 40% off the CPU\n                    // overhead of computed evaluation (on V8 at least).\n\n                    try {\n                        var readFunction = state.readFunction;\n                        return state.evaluatorFunctionTarget ? readFunction.call(state.evaluatorFunctionTarget) : readFunction();\n                    } finally {\n                        ko.dependencyDetection.end();\n\n                        // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                        if (dependencyDetectionContext.disposalCount && !state.isSleeping) {\n                            ko.utils.objectForEach(dependencyDetectionContext.disposalCandidates, computedDisposeDependencyCallback);\n                        }\n\n                        state.isStale = state.isDirty = false;\n                    }\n                },\n                peek: function (evaluate) {\n                    // By default, peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n                    // Pass in true to evaluate if needed.\n                    var state = this[computedState];\n                    if ((state.isDirty && (evaluate || !state.dependenciesCount)) || (state.isSleeping && this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return state.latestValue;\n                },\n                limit: function (limitFunction) {\n                    // Override the limit function with one that delays evaluation as well\n                    ko.subscribable['fn'].limit.call(this, limitFunction);\n                    this._evalIfChanged = function () {\n                        if (!this[computedState].isSleeping) {\n                            if (this[computedState].isStale) {\n                                this.evaluateImmediate();\n                            } else {\n                                this[computedState].isDirty = false;\n                            }\n                        }\n                        return this[computedState].latestValue;\n                    };\n                    this._evalDelayed = function (isChange) {\n                        this._limitBeforeChange(this[computedState].latestValue);\n\n                        // Mark as dirty\n                        this[computedState].isDirty = true;\n                        if (isChange) {\n                            this[computedState].isStale = true;\n                        }\n\n                        // Pass the observable to the \"limit\" code, which will evaluate it when\n                        // it's time to do the notification.\n                        this._limitChange(this, !isChange /* isDirty */);\n                    };\n                },\n                dispose: function () {\n                    var state = this[computedState];\n                    if (!state.isSleeping && state.dependencyTracking) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose)\n                                dependency.dispose();\n                        });\n                    }\n                    if (state.disposeWhenNodeIsRemoved && state.domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback);\n                    }\n                    state.dependencyTracking = undefined;\n                    state.dependenciesCount = 0;\n                    state.isDisposed = true;\n                    state.isStale = false;\n                    state.isDirty = false;\n                    state.isSleeping = false;\n                    state.disposeWhenNodeIsRemoved = undefined;\n                    state.disposeWhen = undefined;\n                    state.readFunction = undefined;\n                    if (!this.hasWriteFunction) {\n                        state.evaluatorFunctionTarget = undefined;\n                    }\n                }\n            };\n\n            var pureComputedOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // If asleep, wake up the computed by subscribing to any dependencies.\n                    var computedObservable = this,\n                        state = computedObservable[computedState];\n                    if (!state.isDisposed && state.isSleeping && event == 'change') {\n                        state.isSleeping = false;\n                        if (state.isStale || computedObservable.haveDependenciesChanged()) {\n                            state.dependencyTracking = null;\n                            state.dependenciesCount = 0;\n                            if (computedObservable.evaluateImmediate()) {\n                                computedObservable.updateVersion();\n                            }\n                        } else {\n                            // First put the dependencies in order\n                            var dependenciesOrder = [];\n                            ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                                dependenciesOrder[dependency._order] = id;\n                            });\n                            // Next, subscribe to each one\n                            ko.utils.arrayForEach(dependenciesOrder, function (id, order) {\n                                var dependency = state.dependencyTracking[id],\n                                    subscription = computedObservable.subscribeToDependency(dependency._target);\n                                subscription._order = order;\n                                subscription._version = dependency._version;\n                                state.dependencyTracking[id] = subscription;\n                            });\n                            // Waking dependencies may have triggered effects\n                            if (computedObservable.haveDependenciesChanged()) {\n                                if (computedObservable.evaluateImmediate()) {\n                                    computedObservable.updateVersion();\n                                }\n                            }\n                        }\n\n                        if (!state.isDisposed) {     // test since evaluating could trigger disposal\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                        }\n                    }\n                },\n                afterSubscriptionRemove: function (event) {\n                    var state = this[computedState];\n                    if (!state.isDisposed && event == 'change' && !this.hasSubscriptionsForEvent('change')) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose) {\n                                state.dependencyTracking[id] = {\n                                    _target: dependency._target,\n                                    _order: dependency._order,\n                                    _version: dependency._version\n                                };\n                                dependency.dispose();\n                            }\n                        });\n                        state.isSleeping = true;\n                        this[\"notifySubscribers\"](undefined, \"asleep\");\n                    }\n                },\n                getVersion: function () {\n                    // Because a pure computed is not automatically updated while it is sleeping, we can't\n                    // simply return the version number. Instead, we check if any of the dependencies have\n                    // changed and conditionally re-evaluate the computed observable.\n                    var state = this[computedState];\n                    if (state.isSleeping && (state.isStale || this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return ko.subscribable['fn'].getVersion.call(this);\n                }\n            };\n\n            var deferEvaluationOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // This will force a computed with deferEvaluation to evaluate when the first subscription is registered.\n                    if (event == 'change' || event == 'beforeChange') {\n                        this.peek();\n                    }\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.computed constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(computedFn, ko.subscribable['fn']);\n            }\n\n// Set the proto values for ko.computed\n            var protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\n            computedFn[protoProp] = ko.computed;\n\n            ko.isComputed = function (instance) {\n                return (typeof instance == 'function' && instance[protoProp] === computedFn[protoProp]);\n            };\n\n            ko.isPureComputed = function (instance) {\n                return ko.isComputed(instance) && instance[computedState] && instance[computedState].pure;\n            };\n\n            ko.exportSymbol('computed', ko.computed);\n            ko.exportSymbol('dependentObservable', ko.computed);    // export ko.dependentObservable for backwards compatibility (1.x)\n            ko.exportSymbol('isComputed', ko.isComputed);\n            ko.exportSymbol('isPureComputed', ko.isPureComputed);\n            ko.exportSymbol('computed.fn', computedFn);\n            ko.exportProperty(computedFn, 'peek', computedFn.peek);\n            ko.exportProperty(computedFn, 'dispose', computedFn.dispose);\n            ko.exportProperty(computedFn, 'isActive', computedFn.isActive);\n            ko.exportProperty(computedFn, 'getDependenciesCount', computedFn.getDependenciesCount);\n            ko.exportProperty(computedFn, 'getDependencies', computedFn.getDependencies);\n\n            ko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n                if (typeof evaluatorFunctionOrOptions === 'function') {\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n                } else {\n                    evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n                    evaluatorFunctionOrOptions['pure'] = true;\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n                }\n            }\n            ko.exportSymbol('pureComputed', ko.pureComputed);\n\n            (function() {\n                var maxNestedObservableDepth = 10; // Escape the (unlikely) pathological case where an observable's current value is itself (or similar reference cycle)\n\n                ko.toJS = function(rootObject) {\n                    if (arguments.length == 0)\n                        throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n                    // We just unwrap everything at every level in the object graph\n                    return mapJsObjectGraph(rootObject, function(valueToMap) {\n                        // Loop because an observable's value might in turn be another observable wrapper\n                        for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                            valueToMap = valueToMap();\n                        return valueToMap;\n                    });\n                };\n\n                ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n                    var plainJavaScriptObject = ko.toJS(rootObject);\n                    return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n                };\n\n                function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n                    visitedObjects = visitedObjects || new objectLookup();\n\n                    rootObject = mapInputCallback(rootObject);\n                    var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof RegExp)) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n                    if (!canHaveProperties)\n                        return rootObject;\n\n                    var outputProperties = rootObject instanceof Array ? [] : {};\n                    visitedObjects.save(rootObject, outputProperties);\n\n                    visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n                        var propertyValue = mapInputCallback(rootObject[indexer]);\n\n                        switch (typeof propertyValue) {\n                            case \"boolean\":\n                            case \"number\":\n                            case \"string\":\n                            case \"function\":\n                                outputProperties[indexer] = propertyValue;\n                                break;\n                            case \"object\":\n                            case \"undefined\":\n                                var previouslyMappedValue = visitedObjects.get(propertyValue);\n                                outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                                    ? previouslyMappedValue\n                                    : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                                break;\n                        }\n                    });\n\n                    return outputProperties;\n                }\n\n                function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n                    if (rootObject instanceof Array) {\n                        for (var i = 0; i < rootObject.length; i++)\n                            visitorCallback(i);\n\n                        // For arrays, also respect toJSON property for custom mappings (fixes #278)\n                        if (typeof rootObject['toJSON'] == 'function')\n                            visitorCallback('toJSON');\n                    } else {\n                        for (var propertyName in rootObject) {\n                            visitorCallback(propertyName);\n                        }\n                    }\n                };\n\n                function objectLookup() {\n                    this.keys = [];\n                    this.values = [];\n                };\n\n                objectLookup.prototype = {\n                    constructor: objectLookup,\n                    save: function(key, value) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        if (existingIndex >= 0)\n                            this.values[existingIndex] = value;\n                        else {\n                            this.keys.push(key);\n                            this.values.push(value);\n                        }\n                    },\n                    get: function(key) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('toJS', ko.toJS);\n            ko.exportSymbol('toJSON', ko.toJSON);\n            ko.when = function(predicate, callback, context) {\n                function kowhen (resolve) {\n                    var observable = ko.pureComputed(predicate, context).extend({notify:'always'});\n                    var subscription = observable.subscribe(function(value) {\n                        if (value) {\n                            subscription.dispose();\n                            resolve(value);\n                        }\n                    });\n                    // In case the initial value is true, process it right away\n                    observable['notifySubscribers'](observable.peek());\n\n                    return subscription;\n                }\n                if (typeof Promise === \"function\" && !callback) {\n                    return new Promise(kowhen);\n                } else {\n                    return kowhen(callback.bind(context));\n                }\n            };\n\n            ko.exportSymbol('when', ko.when);\n            (function () {\n                var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n                // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n                // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n                // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n                ko.selectExtensions = {\n                    readValue : function(element) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (element[hasDomDataExpandoProperty] === true)\n                                    return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                                return ko.utils.ieVersion <= 7\n                                    ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                                    : element.value;\n                            case 'select':\n                                return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                            default:\n                                return element.value;\n                        }\n                    },\n\n                    writeValue: function(element, value, allowUnset) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (typeof value === \"string\") {\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                                    if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                        delete element[hasDomDataExpandoProperty];\n                                    }\n                                    element.value = value;\n                                }\n                                else {\n                                    // Store arbitrary object using DomData\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                                    element[hasDomDataExpandoProperty] = true;\n\n                                    // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                                    element.value = typeof value === \"number\" ? value : \"\";\n                                }\n                                break;\n                            case 'select':\n                                if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                                    value = undefined;\n                                var selection = -1;\n                                for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                                    optionValue = ko.selectExtensions.readValue(element.options[i]);\n                                    // Include special check to handle selecting a caption with a blank string value\n                                    if (optionValue == value || (optionValue === \"\" && value === undefined)) {\n                                        selection = i;\n                                        break;\n                                    }\n                                }\n                                if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                                    element.selectedIndex = selection;\n                                    if (ko.utils.ieVersion === 6) {\n                                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                                        // to apply the value as well.\n                                        ko.utils.setTimeout(function () {\n                                            element.selectedIndex = selection;\n                                        }, 0);\n                                    }\n                                }\n                                break;\n                            default:\n                                if ((value === null) || (value === undefined))\n                                    value = \"\";\n                                element.value = value;\n                                break;\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('selectExtensions', ko.selectExtensions);\n            ko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\n            ko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\n            ko.expressionRewriting = (function () {\n                var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n                // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n                // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n                // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n                var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n                function getWriteableValue(expression) {\n                    if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n                        return false;\n                    var match = expression.match(javaScriptAssignmentTarget);\n                    return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n                }\n\n                // The following regular expressions will be used to split an object-literal string into tokens\n\n                var specials = ',\"\\'`{}()/:[\\\\]',    // These characters have special meaning to the parser and must not appear in the middle of a token, except as part of a string.\n                    // Create the actual regular expression by or-ing the following regex strings. The order is important.\n                    bindingToken = RegExp([\n                        // These match strings, either with double quotes, single quotes, or backticks\n                        '\"(?:\\\\\\\\.|[^\"])*\"',\n                        \"'(?:\\\\\\\\.|[^'])*'\",\n                        \"`(?:\\\\\\\\.|[^`])*`\",\n                        // Match C style comments\n                        \"/\\\\*(?:[^*]|\\\\*+[^*/])*\\\\*+/\",\n                        // Match C++ style comments\n                        \"//.*\\n\",\n                        // Match a regular expression (text enclosed by slashes), but will also match sets of divisions\n                        // as a regular expression (this is handled by the parsing loop below).\n                        '/(?:\\\\\\\\.|[^/])+/\\w*',\n                        // Match text (at least two characters) that does not contain any of the above special characters,\n                        // although some of the special characters are allowed to start it (all but the colon and comma).\n                        // The text can contain spaces, but leading or trailing spaces are skipped.\n                        '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n                        // Match any non-space character not matched already. This will match colons and commas, since they're\n                        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n                        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n                        '[^\\\\s]'\n                    ].join('|'), 'g'),\n\n                    // Match end of previous token to determine whether a slash is a division or regex.\n                    divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n                    keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n                function parseObjectLiteral(objectLiteralString) {\n                    // Trim leading and trailing spaces from the string\n                    var str = ko.utils.stringTrim(objectLiteralString);\n\n                    // Trim braces '{' surrounding the whole object literal\n                    if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n                    // Add a newline to correctly match a C++ style comment at the end of the string and\n                    // add a comma so that we don't need a separate code block to deal with the last item\n                    str += \"\\n,\";\n\n                    // Split into tokens\n                    var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n                    if (toks.length > 1) {\n                        for (var i = 0, tok; tok = toks[i]; ++i) {\n                            var c = tok.charCodeAt(0);\n                            // A comma signals the end of a key/value pair if depth is zero\n                            if (c === 44) { // \",\"\n                                if (depth <= 0) {\n                                    result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                                    key = depth = 0;\n                                    values = [];\n                                    continue;\n                                }\n                                // Simply skip the colon that separates the name and value\n                            } else if (c === 58) { // \":\"\n                                if (!depth && !key && values.length === 1) {\n                                    key = values.pop();\n                                    continue;\n                                }\n                                // Comments: skip them\n                            } else if (c === 47 && tok.length > 1 && (tok.charCodeAt(1) === 47 || tok.charCodeAt(1) === 42)) {  // \"//\" or \"/*\"\n                                continue;\n                                // A set of slashes is initially matched as a regular expression, but could be division\n                            } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                                // Look at the end of the previous token to determine if the slash is actually division\n                                var match = toks[i-1].match(divisionLookBehind);\n                                if (match && !keywordRegexLookBehind[match[0]]) {\n                                    // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                                    str = str.substr(str.indexOf(tok) + 1);\n                                    toks = str.match(bindingToken);\n                                    i = -1;\n                                    // Continue with just the slash\n                                    tok = '/';\n                                }\n                                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                            } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                                ++depth;\n                            } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                                --depth;\n                                // The key will be the first token; if it's a string, trim the quotes\n                            } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                                tok = tok.slice(1, -1);\n                            }\n                            values.push(tok);\n                        }\n                        if (depth > 0) {\n                            throw Error(\"Unbalanced parentheses, braces, or brackets\");\n                        }\n                    }\n                    return result;\n                }\n\n                // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n                var twoWayBindings = {};\n\n                function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n                    bindingOptions = bindingOptions || {};\n\n                    function processKeyValue(key, val) {\n                        var writableVal;\n                        function callPreprocessHook(obj) {\n                            return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n                        }\n                        if (!bindingParams) {\n                            if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                                return;\n\n                            if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                                // For two-way bindings, provide a write method in case the value\n                                // isn't a writable observable.\n                                var writeKey = typeof twoWayBindings[key] == 'string' ? twoWayBindings[key] : key;\n                                propertyAccessorResultStrings.push(\"'\" + writeKey + \"':function(_z){\" + writableVal + \"=_z}\");\n                            }\n                        }\n                        // Values are wrapped in a function so that each value can be accessed independently\n                        if (makeValueAccessors) {\n                            val = 'function(){return ' + val + ' }';\n                        }\n                        resultStrings.push(\"'\" + key + \"':\" + val);\n                    }\n\n                    var resultStrings = [],\n                        propertyAccessorResultStrings = [],\n                        makeValueAccessors = bindingOptions['valueAccessors'],\n                        bindingParams = bindingOptions['bindingParams'],\n                        keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                            parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n                    ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n                        processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n                    });\n\n                    if (propertyAccessorResultStrings.length)\n                        processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n                    return resultStrings.join(\",\");\n                }\n\n                return {\n                    bindingRewriteValidators: [],\n\n                    twoWayBindings: twoWayBindings,\n\n                    parseObjectLiteral: parseObjectLiteral,\n\n                    preProcessBindings: preProcessBindings,\n\n                    keyValueArrayContainsKey: function(keyValueArray, key) {\n                        for (var i = 0; i < keyValueArray.length; i++)\n                            if (keyValueArray[i]['key'] == key)\n                                return true;\n                        return false;\n                    },\n\n                    // Internal, private KO utility for updating model properties from within bindings\n                    // property:            If the property being updated is (or might be) an observable, pass it here\n                    //                      If it turns out to be a writable observable, it will be written to directly\n                    // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n                    //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n                    // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n                    // value:               The value to be written\n                    // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n                    //                      it is !== existing value on that writable observable\n                    writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n                        if (!property || !ko.isObservable(property)) {\n                            var propWriters = allBindings.get('_ko_property_writers');\n                            if (propWriters && propWriters[key])\n                                propWriters[key](value);\n                        } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                            property(value);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('expressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\n            ko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\n            ko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\n            ko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\n            ko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n            (function() {\n                // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n                // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n                // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n                // of that virtual hierarchy\n                //\n                // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n                // without having to scatter special cases all over the binding and templating code.\n\n                // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n                // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n                // So, use node.text where available, and node.nodeValue elsewhere\n                var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n                var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n                var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n                var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n                function isStartComment(node) {\n                    return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isEndComment(node) {\n                    return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isUnmatchedEndComment(node) {\n                    return isEndComment(node) && !(ko.utils.domData.get(node, matchedEndCommentDataKey));\n                }\n\n                var matchedEndCommentDataKey = \"__ko_matchedEndComment__\"\n\n                function getVirtualChildren(startComment, allowUnbalanced) {\n                    var currentNode = startComment;\n                    var depth = 1;\n                    var children = [];\n                    while (currentNode = currentNode.nextSibling) {\n                        if (isEndComment(currentNode)) {\n                            ko.utils.domData.set(currentNode, matchedEndCommentDataKey, true);\n                            depth--;\n                            if (depth === 0)\n                                return children;\n                        }\n\n                        children.push(currentNode);\n\n                        if (isStartComment(currentNode))\n                            depth++;\n                    }\n                    if (!allowUnbalanced)\n                        throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n                    return null;\n                }\n\n                function getMatchingEndComment(startComment, allowUnbalanced) {\n                    var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n                    if (allVirtualChildren) {\n                        if (allVirtualChildren.length > 0)\n                            return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n                        return startComment.nextSibling;\n                    } else\n                        return null; // Must have no matching end comment, and allowUnbalanced is true\n                }\n\n                function getUnbalancedChildTags(node) {\n                    // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n                    //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n                    var childNode = node.firstChild, captureRemaining = null;\n                    if (childNode) {\n                        do {\n                            if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                                captureRemaining.push(childNode);\n                            else if (isStartComment(childNode)) {\n                                var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                                if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                                    childNode = matchingEndComment;\n                                else\n                                    captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                            } else if (isEndComment(childNode)) {\n                                captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                            }\n                        } while (childNode = childNode.nextSibling);\n                    }\n                    return captureRemaining;\n                }\n\n                ko.virtualElements = {\n                    allowedBindings: {},\n\n                    childNodes: function(node) {\n                        return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n                    },\n\n                    emptyNode: function(node) {\n                        if (!isStartComment(node))\n                            ko.utils.emptyDomNode(node);\n                        else {\n                            var virtualChildren = ko.virtualElements.childNodes(node);\n                            for (var i = 0, j = virtualChildren.length; i < j; i++)\n                                ko.removeNode(virtualChildren[i]);\n                        }\n                    },\n\n                    setDomNodeChildren: function(node, childNodes) {\n                        if (!isStartComment(node))\n                            ko.utils.setDomNodeChildren(node, childNodes);\n                        else {\n                            ko.virtualElements.emptyNode(node);\n                            var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n                        }\n                    },\n\n                    prepend: function(containerNode, nodeToPrepend) {\n                        var insertBeforeNode;\n\n                        if (isStartComment(containerNode)) {\n                            // Start comments must always have a parent and at least one following sibling (the end comment)\n                            insertBeforeNode = containerNode.nextSibling;\n                            containerNode = containerNode.parentNode;\n                        } else {\n                            insertBeforeNode = containerNode.firstChild;\n                        }\n\n                        if (!insertBeforeNode) {\n                            containerNode.appendChild(nodeToPrepend);\n                        } else if (nodeToPrepend !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                            containerNode.insertBefore(nodeToPrepend, insertBeforeNode);\n                        }\n                    },\n\n                    insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n                        if (!insertAfterNode) {\n                            ko.virtualElements.prepend(containerNode, nodeToInsert);\n                        } else {\n                            // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                            var insertBeforeNode = insertAfterNode.nextSibling;\n\n                            if (isStartComment(containerNode)) {\n                                containerNode = containerNode.parentNode;\n                            }\n\n                            if (!insertBeforeNode) {\n                                containerNode.appendChild(nodeToInsert);\n                            } else if (nodeToInsert !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                                containerNode.insertBefore(nodeToInsert, insertBeforeNode);\n                            }\n                        }\n                    },\n\n                    firstChild: function(node) {\n                        if (!isStartComment(node)) {\n                            if (node.firstChild && isEndComment(node.firstChild)) {\n                                throw new Error(\"Found invalid end comment, as the first child of \" + node);\n                            }\n                            return node.firstChild;\n                        } else if (!node.nextSibling || isEndComment(node.nextSibling)) {\n                            return null;\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    nextSibling: function(node) {\n                        if (isStartComment(node)) {\n                            node = getMatchingEndComment(node);\n                        }\n\n                        if (node.nextSibling && isEndComment(node.nextSibling)) {\n                            if (isUnmatchedEndComment(node.nextSibling)) {\n                                throw Error(\"Found end comment without a matching opening comment, as child of \" + node);\n                            } else {\n                                return null;\n                            }\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    hasBindingValue: isStartComment,\n\n                    virtualNodeBindingValue: function(node) {\n                        var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n                        return regexMatch ? regexMatch[1] : null;\n                    },\n\n                    normaliseVirtualElementDomStructure: function(elementVerified) {\n                        // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n                        // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n                        // that are direct descendants of <ul> into the preceding <li>)\n                        if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                            return;\n\n                        // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n                        // must be intended to appear *after* that child, so move them there.\n                        var childNode = elementVerified.firstChild;\n                        if (childNode) {\n                            do {\n                                if (childNode.nodeType === 1) {\n                                    var unbalancedTags = getUnbalancedChildTags(childNode);\n                                    if (unbalancedTags) {\n                                        // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                                        var nodeToInsertBefore = childNode.nextSibling;\n                                        for (var i = 0; i < unbalancedTags.length; i++) {\n                                            if (nodeToInsertBefore)\n                                                elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                            else\n                                                elementVerified.appendChild(unbalancedTags[i]);\n                                        }\n                                    }\n                                }\n                            } while (childNode = childNode.nextSibling);\n                        }\n                    }\n                };\n            })();\n            ko.exportSymbol('virtualElements', ko.virtualElements);\n            ko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\n            ko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\n            ko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\n            ko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\n            ko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n            (function() {\n                var defaultBindingAttributeName = \"data-bind\";\n\n                ko.bindingProvider = function() {\n                    this.bindingCache = {};\n                };\n\n                ko.utils.extend(ko.bindingProvider.prototype, {\n                    'nodeHasBindings': function(node) {\n                        switch (node.nodeType) {\n                            case 1: // Element\n                                return node.getAttribute(defaultBindingAttributeName) != null\n                                    || ko.components['getComponentNameForNode'](node);\n                            case 8: // Comment node\n                                return ko.virtualElements.hasBindingValue(node);\n                            default: return false;\n                        }\n                    },\n\n                    'getBindings': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n                    },\n\n                    'getBindingAccessors': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'getBindingsString': function(node, bindingContext) {\n                        switch (node.nodeType) {\n                            case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                            case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                            default: return null;\n                        }\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n                        try {\n                            var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                            return bindingFunction(bindingContext, node);\n                        } catch (ex) {\n                            ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                            throw ex;\n                        }\n                    }\n                });\n\n                ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n                function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n                    var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n                    return cache[cacheKey]\n                        || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n                }\n\n                function createBindingsStringEvaluator(bindingsString, options) {\n                    // Build the source for a function that evaluates \"expression\"\n                    // For each scope variable, add an extra level of \"with\" nesting\n                    // Example result: with(sc1) { with(sc0) { return (expression) } }\n                    var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n                        functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n                    return new Function(\"$context\", \"$element\", functionBody);\n                }\n            })();\n\n            ko.exportSymbol('bindingProvider', ko.bindingProvider);\n            (function () {\n                // Hide or don't minify context properties, see https://github.com/knockout/knockout/issues/2294\n                var contextSubscribable = ko.utils.createSymbolOrString('_subscribable');\n                var contextAncestorBindingInfo = ko.utils.createSymbolOrString('_ancestorBindingInfo');\n                var contextDataDependency = ko.utils.createSymbolOrString('_dataDependency');\n\n                ko.bindingHandlers = {};\n\n                // The following element types will not be recursed into during binding.\n                var bindingDoesNotRecurseIntoElementTypes = {\n                    // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n                    // because it's unexpected and a potential XSS issue.\n                    // Also bindings should not operate on <template> elements since this breaks in Internet Explorer\n                    // and because such elements' contents are always intended to be bound in a different context\n                    // from where they appear in the document.\n                    'script': true,\n                    'textarea': true,\n                    'template': true\n                };\n\n                // Use an overridable method for retrieving binding handlers so that plugins may support dynamically created handlers\n                ko['getBindingHandler'] = function(bindingKey) {\n                    return ko.bindingHandlers[bindingKey];\n                };\n\n                var inheritParentVm = {};\n\n                // The ko.bindingContext constructor is only called directly to create the root context. For child\n                // contexts, use bindingContext.createChildContext or bindingContext.extend.\n                ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback, options) {\n\n                    // The binding context object includes static properties for the current, parent, and root view models.\n                    // If a view model is actually stored in an observable, the corresponding binding context object, and\n                    // any child contexts, must be updated when the view model is changed.\n                    function updateContext() {\n                        // Most of the time, the context will directly get a view model object, but if a function is given,\n                        // we call the function to retrieve the view model. If the function accesses any observables or returns\n                        // an observable, the dependency is tracked, and those observables can later cause the binding\n                        // context to be updated.\n                        var dataItemOrObservable = isFunc ? realDataItemOrAccessor() : realDataItemOrAccessor,\n                            dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n                        if (parentContext) {\n                            // Copy $root and any custom properties from the parent context\n                            ko.utils.extend(self, parentContext);\n\n                            // Copy Symbol properties\n                            if (contextAncestorBindingInfo in parentContext) {\n                                self[contextAncestorBindingInfo] = parentContext[contextAncestorBindingInfo];\n                            }\n                        } else {\n                            self['$parents'] = [];\n                            self['$root'] = dataItem;\n\n                            // Export 'ko' in the binding context so it will be available in bindings and templates\n                            // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                            // See https://github.com/SteveSanderson/knockout/issues/490\n                            self['ko'] = ko;\n                        }\n\n                        self[contextSubscribable] = subscribable;\n\n                        if (shouldInheritData) {\n                            dataItem = self['$data'];\n                        } else {\n                            self['$rawData'] = dataItemOrObservable;\n                            self['$data'] = dataItem;\n                        }\n\n                        if (dataItemAlias)\n                            self[dataItemAlias] = dataItem;\n\n                        // The extendCallback function is provided when creating a child context or extending a context.\n                        // It handles the specific actions needed to finish setting up the binding context. Actions in this\n                        // function could also add dependencies to this binding context.\n                        if (extendCallback)\n                            extendCallback(self, parentContext, dataItem);\n\n                        // When a \"parent\" context is given and we don't already have a dependency on its context, register a dependency on it.\n                        // Thus whenever the parent context is updated, this context will also be updated.\n                        if (parentContext && parentContext[contextSubscribable] && !ko.computedContext.computed().hasAncestorDependency(parentContext[contextSubscribable])) {\n                            parentContext[contextSubscribable]();\n                        }\n\n                        if (dataDependency) {\n                            self[contextDataDependency] = dataDependency;\n                        }\n\n                        return self['$data'];\n                    }\n\n                    var self = this,\n                        shouldInheritData = dataItemOrAccessor === inheritParentVm,\n                        realDataItemOrAccessor = shouldInheritData ? undefined : dataItemOrAccessor,\n                        isFunc = typeof(realDataItemOrAccessor) == \"function\" && !ko.isObservable(realDataItemOrAccessor),\n                        nodes,\n                        subscribable,\n                        dataDependency = options && options['dataDependency'];\n\n                    if (options && options['exportDependencies']) {\n                        // The \"exportDependencies\" option means that the calling code will track any dependencies and re-create\n                        // the binding context when they change.\n                        updateContext();\n                    } else {\n                        subscribable = ko.pureComputed(updateContext);\n                        subscribable.peek();\n\n                        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n                        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n                        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n                        // the context object.\n                        if (subscribable.isActive()) {\n                            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n                            subscribable['equalityComparer'] = null;\n                        } else {\n                            self[contextSubscribable] = undefined;\n                        }\n                    }\n                }\n\n                // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n                // any observables, the new child context will automatically get a dependency on the parent context.\n                // But this does not mean that the $data value of the child context will also get updated. If the child\n                // view model also depends on the parent view model, you must provide a function that returns the correct\n                // view model on each update.\n                ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback, options) {\n                    if (!options && dataItemAlias && typeof dataItemAlias == \"object\") {\n                        options = dataItemAlias;\n                        dataItemAlias = options['as'];\n                        extendCallback = options['extend'];\n                    }\n\n                    if (dataItemAlias && options && options['noChildContext']) {\n                        var isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor);\n                        return new ko.bindingContext(inheritParentVm, this, null, function (self) {\n                            if (extendCallback)\n                                extendCallback(self);\n                            self[dataItemAlias] = isFunc ? dataItemOrAccessor() : dataItemOrAccessor;\n                        }, options);\n                    }\n\n                    return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function (self, parentContext) {\n                        // Extend the context hierarchy by setting the appropriate pointers\n                        self['$parentContext'] = parentContext;\n                        self['$parent'] = parentContext['$data'];\n                        self['$parents'] = (parentContext['$parents'] || []).slice(0);\n                        self['$parents'].unshift(self['$parent']);\n                        if (extendCallback)\n                            extendCallback(self);\n                    }, options);\n                };\n\n                // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n                // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n                // when an observable view model is updated.\n                ko.bindingContext.prototype['extend'] = function(properties, options) {\n                    return new ko.bindingContext(inheritParentVm, this, null, function(self, parentContext) {\n                        ko.utils.extend(self, typeof(properties) == \"function\" ? properties(self) : properties);\n                    }, options);\n                };\n\n                var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n                function asyncContextDispose(node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey),\n                        asyncContext = bindingInfo && bindingInfo.asyncContext;\n                    if (asyncContext) {\n                        bindingInfo.asyncContext = null;\n                        asyncContext.notifyAncestor();\n                    }\n                }\n                function AsyncCompleteContext(node, bindingInfo, ancestorBindingInfo) {\n                    this.node = node;\n                    this.bindingInfo = bindingInfo;\n                    this.asyncDescendants = [];\n                    this.childrenComplete = false;\n\n                    if (!bindingInfo.asyncContext) {\n                        ko.utils.domNodeDisposal.addDisposeCallback(node, asyncContextDispose);\n                    }\n\n                    if (ancestorBindingInfo && ancestorBindingInfo.asyncContext) {\n                        ancestorBindingInfo.asyncContext.asyncDescendants.push(node);\n                        this.ancestorBindingInfo = ancestorBindingInfo;\n                    }\n                }\n                AsyncCompleteContext.prototype.notifyAncestor = function () {\n                    if (this.ancestorBindingInfo && this.ancestorBindingInfo.asyncContext) {\n                        this.ancestorBindingInfo.asyncContext.descendantComplete(this.node);\n                    }\n                };\n                AsyncCompleteContext.prototype.descendantComplete = function (node) {\n                    ko.utils.arrayRemoveItem(this.asyncDescendants, node);\n                    if (!this.asyncDescendants.length && this.childrenComplete) {\n                        this.completeChildren();\n                    }\n                };\n                AsyncCompleteContext.prototype.completeChildren = function () {\n                    this.childrenComplete = true;\n                    if (this.bindingInfo.asyncContext && !this.asyncDescendants.length) {\n                        this.bindingInfo.asyncContext = null;\n                        ko.utils.domNodeDisposal.removeDisposeCallback(this.node, asyncContextDispose);\n                        ko.bindingEvent.notify(this.node, ko.bindingEvent.descendantsComplete);\n                        this.notifyAncestor();\n                    }\n                };\n\n                ko.bindingEvent = {\n                    childrenComplete: \"childrenComplete\",\n                    descendantsComplete : \"descendantsComplete\",\n\n                    subscribe: function (node, event, callback, context, options) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n                        if (!bindingInfo.eventSubscribable) {\n                            bindingInfo.eventSubscribable = new ko.subscribable;\n                        }\n                        if (options && options['notifyImmediately'] && bindingInfo.notifiedEvents[event]) {\n                            ko.dependencyDetection.ignore(callback, context, [node]);\n                        }\n                        return bindingInfo.eventSubscribable.subscribe(callback, context, event);\n                    },\n\n                    notify: function (node, event) {\n                        var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                        if (bindingInfo) {\n                            bindingInfo.notifiedEvents[event] = true;\n                            if (bindingInfo.eventSubscribable) {\n                                bindingInfo.eventSubscribable['notifySubscribers'](node, event);\n                            }\n                            if (event == ko.bindingEvent.childrenComplete) {\n                                if (bindingInfo.asyncContext) {\n                                    bindingInfo.asyncContext.completeChildren();\n                                } else if (bindingInfo.asyncContext === undefined && bindingInfo.eventSubscribable && bindingInfo.eventSubscribable.hasSubscriptionsForEvent(ko.bindingEvent.descendantsComplete)) {\n                                    // It's currently an error to register a descendantsComplete handler for a node that was never registered as completing asynchronously.\n                                    // That's because without the asyncContext, we don't have a way to know that all descendants have completed.\n                                    throw new Error(\"descendantsComplete event not supported for bindings on this node\");\n                                }\n                            }\n                        }\n                    },\n\n                    startPossiblyAsyncContentBinding: function (node, bindingContext) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                        if (!bindingInfo.asyncContext) {\n                            bindingInfo.asyncContext = new AsyncCompleteContext(node, bindingInfo, bindingContext[contextAncestorBindingInfo]);\n                        }\n\n                        // If the provided context was already extended with this node's binding info, just return the extended context\n                        if (bindingContext[contextAncestorBindingInfo] == bindingInfo) {\n                            return bindingContext;\n                        }\n\n                        return bindingContext['extend'](function (ctx) {\n                            ctx[contextAncestorBindingInfo] = bindingInfo;\n                        });\n                    }\n                };\n\n                // Returns the valueAccessor function for a binding value\n                function makeValueAccessor(value) {\n                    return function() {\n                        return value;\n                    };\n                }\n\n                // Returns the value of a valueAccessor function\n                function evaluateValueAccessor(valueAccessor) {\n                    return valueAccessor();\n                }\n\n                // Given a function that returns bindings, create and return a new object that contains\n                // binding value-accessors functions. Each accessor function calls the original function\n                // so that it always gets the latest value and all dependencies are captured. This is used\n                // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n                function makeAccessorsFromFunction(callback) {\n                    return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n                        return function() {\n                            return callback()[key];\n                        };\n                    });\n                }\n\n                // Given a bindings function or object, create and return a new object that contains\n                // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n                function makeBindingAccessors(bindings, context, node) {\n                    if (typeof bindings === 'function') {\n                        return makeAccessorsFromFunction(bindings.bind(null, context, node));\n                    } else {\n                        return ko.utils.objectMap(bindings, makeValueAccessor);\n                    }\n                }\n\n                // This function is used if the binding provider doesn't include a getBindingAccessors function.\n                // It must be called with 'this' set to the provider instance.\n                function getBindingsAndMakeAccessors(node, context) {\n                    return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n                }\n\n                function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n                    var validator = ko.virtualElements.allowedBindings[bindingName];\n                    if (!validator)\n                        throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n                }\n\n                function applyBindingsToDescendantsInternal(bindingContext, elementOrVirtualElement) {\n                    var nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n\n                    if (nextInQueue) {\n                        var currentChild,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n                        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n                        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n                        // trigger insertion of <template> contents at that point in the document.\n                        if (preprocessNode) {\n                            while (currentChild = nextInQueue) {\n                                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                                preprocessNode.call(provider, currentChild);\n                            }\n                            // Reset nextInQueue for the next loop\n                            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n                        }\n\n                        while (currentChild = nextInQueue) {\n                            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n                            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild);\n                        }\n                    }\n                    ko.bindingEvent.notify(elementOrVirtualElement, ko.bindingEvent.childrenComplete);\n                }\n\n                function applyBindingsToNodeAndDescendantsInternal(bindingContext, nodeVerified) {\n                    var bindingContextForDescendants = bindingContext;\n\n                    var isElement = (nodeVerified.nodeType === 1);\n                    if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n                    // Perf optimisation: Apply bindings only if...\n                    // (1) We need to store the binding info for the node (all element nodes)\n                    // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n                    var shouldApplyBindings = isElement || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);\n                    if (shouldApplyBindings)\n                        bindingContextForDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext)['bindingContextForDescendants'];\n\n                    if (bindingContextForDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n                        applyBindingsToDescendantsInternal(bindingContextForDescendants, nodeVerified);\n                    }\n                }\n\n                function topologicalSortBindings(bindings) {\n                    // Depth-first sort\n                    var result = [],                // The list of key/handler pairs that we will return\n                        bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n                        cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n                    ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n                        if (!bindingsConsidered[bindingKey]) {\n                            var binding = ko['getBindingHandler'](bindingKey);\n                            if (binding) {\n                                // First add dependencies (if any) of the current binding\n                                if (binding['after']) {\n                                    cyclicDependencyStack.push(bindingKey);\n                                    ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                                        if (bindings[bindingDependencyKey]) {\n                                            if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                                throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                            } else {\n                                                pushBinding(bindingDependencyKey);\n                                            }\n                                        }\n                                    });\n                                    cyclicDependencyStack.length--;\n                                }\n                                // Next add the current binding\n                                result.push({ key: bindingKey, handler: binding });\n                            }\n                            bindingsConsidered[bindingKey] = true;\n                        }\n                    });\n\n                    return result;\n                }\n\n                function applyBindingsToNodeInternal(node, sourceBindings, bindingContext) {\n                    var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                    // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n                    var alreadyBound = bindingInfo.alreadyBound;\n                    if (!sourceBindings) {\n                        if (alreadyBound) {\n                            throw Error(\"You cannot apply bindings multiple times to the same element.\");\n                        }\n                        bindingInfo.alreadyBound = true;\n                    }\n                    if (!alreadyBound) {\n                        bindingInfo.context = bindingContext;\n                    }\n                    if (!bindingInfo.notifiedEvents) {\n                        bindingInfo.notifiedEvents = {};\n                    }\n\n                    // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n                    var bindings;\n                    if (sourceBindings && typeof sourceBindings !== 'function') {\n                        bindings = sourceBindings;\n                    } else {\n                        var provider = ko.bindingProvider['instance'],\n                            getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n                        // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n                        // the binding context is updated or if the binding provider accesses observables.\n                        var bindingsUpdater = ko.dependentObservable(\n                            function() {\n                                bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                                // Register a dependency on the binding context to support observable view models.\n                                if (bindings) {\n                                    if (bindingContext[contextSubscribable]) {\n                                        bindingContext[contextSubscribable]();\n                                    }\n                                    if (bindingContext[contextDataDependency]) {\n                                        bindingContext[contextDataDependency]();\n                                    }\n                                }\n                                return bindings;\n                            },\n                            null, { disposeWhenNodeIsRemoved: node }\n                        );\n\n                        if (!bindings || !bindingsUpdater.isActive())\n                            bindingsUpdater = null;\n                    }\n\n                    var contextToExtend = bindingContext;\n                    var bindingHandlerThatControlsDescendantBindings;\n                    if (bindings) {\n                        // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n                        // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n                        // the latest binding value and registers a dependency on the binding updater.\n                        var getValueAccessor = bindingsUpdater\n                            ? function(bindingKey) {\n                                return function() {\n                                    return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                                };\n                            } : function(bindingKey) {\n                                return bindings[bindingKey];\n                            };\n\n                        // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n                        function allBindings() {\n                            return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n                        }\n                        // The following is the 3.x allBindings API\n                        allBindings['get'] = function(key) {\n                            return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n                        };\n                        allBindings['has'] = function(key) {\n                            return key in bindings;\n                        };\n\n                        if (ko.bindingEvent.childrenComplete in bindings) {\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.childrenComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.childrenComplete]);\n                                if (callback) {\n                                    var nodes = ko.virtualElements.childNodes(node);\n                                    if (nodes.length) {\n                                        callback(nodes, ko.dataFor(nodes[0]));\n                                    }\n                                }\n                            });\n                        }\n\n                        if (ko.bindingEvent.descendantsComplete in bindings) {\n                            contextToExtend = ko.bindingEvent.startPossiblyAsyncContentBinding(node, bindingContext);\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.descendantsComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.descendantsComplete]);\n                                if (callback && ko.virtualElements.firstChild(node)) {\n                                    callback(node);\n                                }\n                            });\n                        }\n\n                        // First put the bindings into the right order\n                        var orderedBindings = topologicalSortBindings(bindings);\n\n                        // Go through the sorted bindings, calling init and update for each\n                        ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                            // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                            // so bindingKeyAndHandler.handler will always be nonnull.\n                            var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                                handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                                bindingKey = bindingKeyAndHandler.key;\n\n                            if (node.nodeType === 8) {\n                                validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                            }\n\n                            try {\n                                // Run init, ignoring any dependencies\n                                if (typeof handlerInitFn == \"function\") {\n                                    ko.dependencyDetection.ignore(function() {\n                                        var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n\n                                        // If this binding handler claims to control descendant bindings, make a note of this\n                                        if (initResult && initResult['controlsDescendantBindings']) {\n                                            if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                                throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                            bindingHandlerThatControlsDescendantBindings = bindingKey;\n                                        }\n                                    });\n                                }\n\n                                // Run update in its own computed wrapper\n                                if (typeof handlerUpdateFn == \"function\") {\n                                    ko.dependentObservable(\n                                        function() {\n                                            handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n                                        },\n                                        null,\n                                        { disposeWhenNodeIsRemoved: node }\n                                    );\n                                }\n                            } catch (ex) {\n                                ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                                throw ex;\n                            }\n                        });\n                    }\n\n                    var shouldBindDescendants = bindingHandlerThatControlsDescendantBindings === undefined;\n                    return {\n                        'shouldBindDescendants': shouldBindDescendants,\n                        'bindingContextForDescendants': shouldBindDescendants && contextToExtend\n                    };\n                };\n\n                ko.storedBindingContextForNode = function (node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                    return bindingInfo && bindingInfo.context;\n                }\n\n                function getBindingContext(viewModelOrBindingContext, extendContextCallback) {\n                    return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n                        ? viewModelOrBindingContext\n                        : new ko.bindingContext(viewModelOrBindingContext, undefined, undefined, extendContextCallback);\n                }\n\n                ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(node);\n                    return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext));\n                };\n\n                ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    var context = getBindingContext(viewModelOrBindingContext);\n                    return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n                };\n\n                ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n                    if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n                        applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode);\n                };\n\n                ko.applyBindings = function (viewModelOrBindingContext, rootNode, extendContextCallback) {\n                    // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n                    if (!jQueryInstance && window['jQuery']) {\n                        jQueryInstance = window['jQuery'];\n                    }\n\n                    if (arguments.length < 2) {\n                        rootNode = document.body;\n                        if (!rootNode) {\n                            throw Error(\"ko.applyBindings: could not find document.body; has the document been loaded?\");\n                        }\n                    } else if (!rootNode || (rootNode.nodeType !== 1 && rootNode.nodeType !== 8)) {\n                        throw Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n                    }\n\n                    applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext, extendContextCallback), rootNode);\n                };\n\n                // Retrieving binding context from arbitrary nodes\n                ko.contextFor = function(node) {\n                    // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n                    if (node && (node.nodeType === 1 || node.nodeType === 8)) {\n                        return ko.storedBindingContextForNode(node);\n                    }\n                    return undefined;\n                };\n                ko.dataFor = function(node) {\n                    var context = ko.contextFor(node);\n                    return context ? context['$data'] : undefined;\n                };\n\n                ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n                ko.exportSymbol('bindingEvent', ko.bindingEvent);\n                ko.exportSymbol('bindingEvent.subscribe', ko.bindingEvent.subscribe);\n                ko.exportSymbol('bindingEvent.startPossiblyAsyncContentBinding', ko.bindingEvent.startPossiblyAsyncContentBinding);\n                ko.exportSymbol('applyBindings', ko.applyBindings);\n                ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n                ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n                ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n                ko.exportSymbol('contextFor', ko.contextFor);\n                ko.exportSymbol('dataFor', ko.dataFor);\n            })();\n            (function(undefined) {\n                var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n                    loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n                ko.components = {\n                    get: function(componentName, callback) {\n                        var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n                        if (cachedDefinition) {\n                            // It's already loaded and cached. Reuse the same definition object.\n                            // Note that for API consistency, even cache hits complete asynchronously by default.\n                            // You can bypass this by putting synchronous:true on your component config.\n                            if (cachedDefinition.isSynchronousComponent) {\n                                ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                                    callback(cachedDefinition.definition);\n                                });\n                            } else {\n                                ko.tasks.schedule(function() { callback(cachedDefinition.definition); });\n                            }\n                        } else {\n                            // Join the loading process that is already underway, or start a new one.\n                            loadComponentAndNotify(componentName, callback);\n                        }\n                    },\n\n                    clearCachedDefinition: function(componentName) {\n                        delete loadedDefinitionsCache[componentName];\n                    },\n\n                    _getFirstResultFromLoaders: getFirstResultFromLoaders\n                };\n\n                function getObjectOwnProperty(obj, propName) {\n                    return Object.prototype.hasOwnProperty.call(obj, propName) ? obj[propName] : undefined;\n                }\n\n                function loadComponentAndNotify(componentName, callback) {\n                    var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n                        completedAsync;\n                    if (!subscribable) {\n                        // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n                        subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n                        subscribable.subscribe(callback);\n\n                        beginLoadingComponent(componentName, function(definition, config) {\n                            var isSynchronousComponent = !!(config && config['synchronous']);\n                            loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                            delete loadingSubscribablesCache[componentName];\n\n                            // For API consistency, all loads complete asynchronously. However we want to avoid\n                            // adding an extra task schedule if it's unnecessary (i.e., the completion is already\n                            // async).\n                            //\n                            // You can bypass the 'always asynchronous' feature by putting the synchronous:true\n                            // flag on your component configuration when you register it.\n                            if (completedAsync || isSynchronousComponent) {\n                                // Note that notifySubscribers ignores any dependencies read within the callback.\n                                // See comment in loaderRegistryBehaviors.js for reasoning\n                                subscribable['notifySubscribers'](definition);\n                            } else {\n                                ko.tasks.schedule(function() {\n                                    subscribable['notifySubscribers'](definition);\n                                });\n                            }\n                        });\n                        completedAsync = true;\n                    } else {\n                        subscribable.subscribe(callback);\n                    }\n                }\n\n                function beginLoadingComponent(componentName, callback) {\n                    getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n                        if (config) {\n                            // We have a config, so now load its definition\n                            getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                                callback(definition, config);\n                            });\n                        } else {\n                            // The component has no config - it's unknown to all the loaders.\n                            // Note that this is not an error (e.g., a module loading error) - that would abort the\n                            // process and this callback would not run. For this callback to run, all loaders must\n                            // have confirmed they don't know about this component.\n                            callback(null, null);\n                        }\n                    });\n                }\n\n                function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n                    // On the first call in the stack, start with the full set of loaders\n                    if (!candidateLoaders) {\n                        candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n                    }\n\n                    // Try the next candidate\n                    var currentCandidateLoader = candidateLoaders.shift();\n                    if (currentCandidateLoader) {\n                        var methodInstance = currentCandidateLoader[methodName];\n                        if (methodInstance) {\n                            var wasAborted = false,\n                                synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                                    if (wasAborted) {\n                                        callback(null);\n                                    } else if (result !== null) {\n                                        // This candidate returned a value. Use it.\n                                        callback(result);\n                                    } else {\n                                        // Try the next candidate\n                                        getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                                    }\n                                }));\n\n                            // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                            // that we'll extend the API to support synchronous return values in the future. It won't be\n                            // a breaking change, because currently no loader is allowed to return anything except undefined.\n                            if (synchronousReturnValue !== undefined) {\n                                wasAborted = true;\n\n                                // Method to suppress exceptions will remain undocumented. This is only to keep\n                                // KO's specs running tidily, since we can observe the loading got aborted without\n                                // having exceptions cluttering up the console too.\n                                if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                                    throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                                }\n                            }\n                        } else {\n                            // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    } else {\n                        // No candidates returned a value\n                        callback(null);\n                    }\n                }\n\n                // Reference the loaders via string name so it's possible for developers\n                // to replace the whole array by assigning to ko.components.loaders\n                ko.components['loaders'] = [];\n\n                ko.exportSymbol('components', ko.components);\n                ko.exportSymbol('components.get', ko.components.get);\n                ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n            })();\n            (function(undefined) {\n\n                // The default loader is responsible for two things:\n                // 1. Maintaining the default in-memory registry of component configuration objects\n                //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n                // 2. Answering requests for components by fetching configuration objects\n                //    from that default in-memory registry and resolving them into standard\n                //    component definition objects (of the form { createViewModel: ..., template: ... })\n                // Custom loaders may override either of these facilities, i.e.,\n                // 1. To supply configuration objects from some other source (e.g., conventions)\n                // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n                var defaultConfigRegistry = {};\n\n                ko.components.register = function(componentName, config) {\n                    if (!config) {\n                        throw new Error('Invalid configuration for ' + componentName);\n                    }\n\n                    if (ko.components.isRegistered(componentName)) {\n                        throw new Error('Component ' + componentName + ' is already registered');\n                    }\n\n                    defaultConfigRegistry[componentName] = config;\n                };\n\n                ko.components.isRegistered = function(componentName) {\n                    return Object.prototype.hasOwnProperty.call(defaultConfigRegistry, componentName);\n                };\n\n                ko.components.unregister = function(componentName) {\n                    delete defaultConfigRegistry[componentName];\n                    ko.components.clearCachedDefinition(componentName);\n                };\n\n                ko.components.defaultLoader = {\n                    'getConfig': function(componentName, callback) {\n                        var result = ko.components.isRegistered(componentName)\n                            ? defaultConfigRegistry[componentName]\n                            : null;\n                        callback(result);\n                    },\n\n                    'loadComponent': function(componentName, config, callback) {\n                        var errorCallback = makeErrorCallback(componentName);\n                        possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                            resolveConfig(componentName, errorCallback, loadedConfig, callback);\n                        });\n                    },\n\n                    'loadTemplate': function(componentName, templateConfig, callback) {\n                        resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n                    },\n\n                    'loadViewModel': function(componentName, viewModelConfig, callback) {\n                        resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n                    }\n                };\n\n                var createViewModelKey = 'createViewModel';\n\n                // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n                // into the standard component definition format:\n                //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n                // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n                // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n                // so this is implemented manually below.\n                function resolveConfig(componentName, errorCallback, config, callback) {\n                    var result = {},\n                        makeCallBackWhenZero = 2,\n                        tryIssueCallback = function() {\n                            if (--makeCallBackWhenZero === 0) {\n                                callback(result);\n                            }\n                        },\n                        templateConfig = config['template'],\n                        viewModelConfig = config['viewModel'];\n\n                    if (templateConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                                result['template'] = resolvedTemplate;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n\n                    if (viewModelConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                                result[createViewModelKey] = resolvedViewModel;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n                }\n\n                function resolveTemplate(errorCallback, templateConfig, callback) {\n                    if (typeof templateConfig === 'string') {\n                        // Markup - parse it\n                        callback(ko.utils.parseHtmlFragment(templateConfig));\n                    } else if (templateConfig instanceof Array) {\n                        // Assume already an array of DOM nodes - pass through unchanged\n                        callback(templateConfig);\n                    } else if (isDocumentFragment(templateConfig)) {\n                        // Document fragment - use its child nodes\n                        callback(ko.utils.makeArray(templateConfig.childNodes));\n                    } else if (templateConfig['element']) {\n                        var element = templateConfig['element'];\n                        if (isDomElement(element)) {\n                            // Element instance - copy its child nodes\n                            callback(cloneNodesFromTemplateSourceElement(element));\n                        } else if (typeof element === 'string') {\n                            // Element ID - find it, then copy its child nodes\n                            var elemInstance = document.getElementById(element);\n                            if (elemInstance) {\n                                callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                            } else {\n                                errorCallback('Cannot find element with ID ' + element);\n                            }\n                        } else {\n                            errorCallback('Unknown element type: ' + element);\n                        }\n                    } else {\n                        errorCallback('Unknown template value: ' + templateConfig);\n                    }\n                }\n\n                function resolveViewModel(errorCallback, viewModelConfig, callback) {\n                    if (typeof viewModelConfig === 'function') {\n                        // Constructor - convert to standard factory function format\n                        // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n                        // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n                        // be used in factory functions, not viewmodel constructors.\n                        callback(function (params /*, componentInfo */) {\n                            return new viewModelConfig(params);\n                        });\n                    } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n                        // Already a factory function - use it as-is\n                        callback(viewModelConfig[createViewModelKey]);\n                    } else if ('instance' in viewModelConfig) {\n                        // Fixed object instance - promote to createViewModel format for API consistency\n                        var fixedInstance = viewModelConfig['instance'];\n                        callback(function (params, componentInfo) {\n                            return fixedInstance;\n                        });\n                    } else if ('viewModel' in viewModelConfig) {\n                        // Resolved AMD module whose value is of the form { viewModel: ... }\n                        resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n                    } else {\n                        errorCallback('Unknown viewModel value: ' + viewModelConfig);\n                    }\n                }\n\n                function cloneNodesFromTemplateSourceElement(elemInstance) {\n                    switch (ko.utils.tagNameLower(elemInstance)) {\n                        case 'script':\n                            return ko.utils.parseHtmlFragment(elemInstance.text);\n                        case 'textarea':\n                            return ko.utils.parseHtmlFragment(elemInstance.value);\n                        case 'template':\n                            // For browsers with proper <template> element support (i.e., where the .content property\n                            // gives a document fragment), use that document fragment.\n                            if (isDocumentFragment(elemInstance.content)) {\n                                return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                            }\n                    }\n\n                    // Regular elements such as <div>, and <template> elements on old browsers that don't really\n                    // understand <template> and just treat it as a regular container\n                    return ko.utils.cloneNodes(elemInstance.childNodes);\n                }\n\n                function isDomElement(obj) {\n                    if (window['HTMLElement']) {\n                        return obj instanceof HTMLElement;\n                    } else {\n                        return obj && obj.tagName && obj.nodeType === 1;\n                    }\n                }\n\n                function isDocumentFragment(obj) {\n                    if (window['DocumentFragment']) {\n                        return obj instanceof DocumentFragment;\n                    } else {\n                        return obj && obj.nodeType === 11;\n                    }\n                }\n\n                function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n                    if (typeof config['require'] === 'string') {\n                        // The config is the value of an AMD module\n                        if (amdRequire || window['require']) {\n                            (amdRequire || window['require'])([config['require']], function (module) {\n                                if (module && typeof module === 'object' && module.__esModule && module.default) {\n                                    module = module.default;\n                                }\n                                callback(module);\n                            });\n                        } else {\n                            errorCallback('Uses require, but no AMD loader is present');\n                        }\n                    } else {\n                        callback(config);\n                    }\n                }\n\n                function makeErrorCallback(componentName) {\n                    return function (message) {\n                        throw new Error('Component \\'' + componentName + '\\': ' + message);\n                    };\n                }\n\n                ko.exportSymbol('components.register', ko.components.register);\n                ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n                ko.exportSymbol('components.unregister', ko.components.unregister);\n\n                // Expose the default loader so that developers can directly ask it for configuration\n                // or to resolve configuration\n                ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n                // By default, the default loader is the only registered component loader\n                ko.components['loaders'].push(ko.components.defaultLoader);\n\n                // Privately expose the underlying config registry for use in old-IE shim\n                ko.components._allRegisteredComponents = defaultConfigRegistry;\n            })();\n            (function (undefined) {\n                // Overridable API for determining which component name applies to a given node. By overriding this,\n                // you can for example map specific tagNames to components that are not preregistered.\n                ko.components['getComponentNameForNode'] = function(node) {\n                    var tagNameLower = ko.utils.tagNameLower(node);\n                    if (ko.components.isRegistered(tagNameLower)) {\n                        // Try to determine that this node can be considered a *custom* element; see https://github.com/knockout/knockout/issues/1603\n                        if (tagNameLower.indexOf('-') != -1 || ('' + node) == \"[object HTMLUnknownElement]\" || (ko.utils.ieVersion <= 8 && node.tagName === tagNameLower)) {\n                            return tagNameLower;\n                        }\n                    }\n                };\n\n                ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n                    // Determine if it's really a custom element matching a component\n                    if (node.nodeType === 1) {\n                        var componentName = ko.components['getComponentNameForNode'](node);\n                        if (componentName) {\n                            // It does represent a component, so add a component binding for it\n                            allBindings = allBindings || {};\n\n                            if (allBindings['component']) {\n                                // Avoid silently overwriting some other 'component' binding that may already be on the element\n                                throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                            }\n\n                            var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                            allBindings['component'] = valueAccessors\n                                ? function() { return componentBindingValue; }\n                                : componentBindingValue;\n                        }\n                    }\n\n                    return allBindings;\n                }\n\n                var nativeBindingProviderInstance = new ko.bindingProvider();\n\n                function getComponentParamsFromCustomElement(elem, bindingContext) {\n                    var paramsAttribute = elem.getAttribute('params');\n\n                    if (paramsAttribute) {\n                        var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                            rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                                return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                            }),\n                            result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                                var paramValue = paramValueComputed.peek();\n                                // Does the evaluation of the parameter value unwrap any observables?\n                                if (!paramValueComputed.isActive()) {\n                                    // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                                    // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                                    return paramValue;\n                                } else {\n                                    // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                                    // level of observability, and any inner (resulting model value) level of observability.\n                                    // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                                    // writable observable, the computed will also be writable and pass the value on to the observable.\n                                    return ko.computed({\n                                        'read': function() {\n                                            return ko.utils.unwrapObservable(paramValueComputed());\n                                        },\n                                        'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                            paramValueComputed()(value);\n                                        },\n                                        disposeWhenNodeIsRemoved: elem\n                                    });\n                                }\n                            });\n\n                        // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n                        // This is in case the developer wants to react to outer (binding) observability separately from inner\n                        // (model value) observability, or in case the model value observable has subobservables.\n                        if (!Object.prototype.hasOwnProperty.call(result, '$raw')) {\n                            result['$raw'] = rawParamComputedValues;\n                        }\n\n                        return result;\n                    } else {\n                        // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n                        // any empty one. Otherwise component viewmodels need special code to check whether or not\n                        // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n                        return { '$raw': {} };\n                    }\n                }\n\n                // --------------------------------------------------------------------------------\n                // Compatibility code for older (pre-HTML5) IE browsers\n\n                if (ko.utils.ieVersion < 9) {\n                    // Whenever you preregister a component, enable it as a custom element in the current document\n                    ko.components['register'] = (function(originalFunction) {\n                        return function(componentName) {\n                            document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                            return originalFunction.apply(this, arguments);\n                        }\n                    })(ko.components['register']);\n\n                    // Whenever you create a document fragment, enable all preregistered component names as custom elements\n                    // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n                    document.createDocumentFragment = (function(originalFunction) {\n                        return function() {\n                            var newDocFrag = originalFunction(),\n                                allComponents = ko.components._allRegisteredComponents;\n                            for (var componentName in allComponents) {\n                                if (Object.prototype.hasOwnProperty.call(allComponents, componentName)) {\n                                    newDocFrag.createElement(componentName);\n                                }\n                            }\n                            return newDocFrag;\n                        };\n                    })(document.createDocumentFragment);\n                }\n            })();(function(undefined) {\n                var componentLoadingOperationUniqueId = 0;\n\n                ko.bindingHandlers['component'] = {\n                    'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n                        var currentViewModel,\n                            currentLoadingOperationId,\n                            afterRenderSub,\n                            disposeAssociatedComponentViewModel = function () {\n                                var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                                if (typeof currentViewModelDispose === 'function') {\n                                    currentViewModelDispose.call(currentViewModel);\n                                }\n                                if (afterRenderSub) {\n                                    afterRenderSub.dispose();\n                                }\n                                afterRenderSub = null;\n                                currentViewModel = null;\n                                // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                                currentLoadingOperationId = null;\n                            },\n                            originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n                        ko.virtualElements.emptyNode(element);\n                        ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n                        ko.computed(function () {\n                            var value = ko.utils.unwrapObservable(valueAccessor()),\n                                componentName, componentParams;\n\n                            if (typeof value === 'string') {\n                                componentName = value;\n                            } else {\n                                componentName = ko.utils.unwrapObservable(value['name']);\n                                componentParams = ko.utils.unwrapObservable(value['params']);\n                            }\n\n                            if (!componentName) {\n                                throw new Error('No component name specified');\n                            }\n\n                            var asyncContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n\n                            var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                            ko.components.get(componentName, function(componentDefinition) {\n                                // If this is not the current load operation for this element, ignore it.\n                                if (currentLoadingOperationId !== loadingOperationId) {\n                                    return;\n                                }\n\n                                // Clean up previous state\n                                disposeAssociatedComponentViewModel();\n\n                                // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                                if (!componentDefinition) {\n                                    throw new Error('Unknown component \\'' + componentName + '\\'');\n                                }\n                                cloneTemplateIntoElement(componentName, componentDefinition, element);\n\n                                var componentInfo = {\n                                    'element': element,\n                                    'templateNodes': originalChildNodes\n                                };\n\n                                var componentViewModel = createViewModel(componentDefinition, componentParams, componentInfo),\n                                    childBindingContext = asyncContext['createChildContext'](componentViewModel, {\n                                        'extend': function(ctx) {\n                                            ctx['$component'] = componentViewModel;\n                                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                                        }\n                                    });\n\n                                if (componentViewModel && componentViewModel['koDescendantsComplete']) {\n                                    afterRenderSub = ko.bindingEvent.subscribe(element, ko.bindingEvent.descendantsComplete, componentViewModel['koDescendantsComplete'], componentViewModel);\n                                }\n\n                                currentViewModel = componentViewModel;\n                                ko.applyBindingsToDescendants(childBindingContext, element);\n                            });\n                        }, null, { disposeWhenNodeIsRemoved: element });\n\n                        return { 'controlsDescendantBindings': true };\n                    }\n                };\n\n                ko.virtualElements.allowedBindings['component'] = true;\n\n                function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n                    var template = componentDefinition['template'];\n                    if (!template) {\n                        throw new Error('Component \\'' + componentName + '\\' has no template');\n                    }\n\n                    var clonedNodesArray = ko.utils.cloneNodes(template);\n                    ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n                }\n\n                function createViewModel(componentDefinition, componentParams, componentInfo) {\n                    var componentViewModelFactory = componentDefinition['createViewModel'];\n                    return componentViewModelFactory\n                        ? componentViewModelFactory.call(componentDefinition, componentParams, componentInfo)\n                        : componentParams; // Template-only component\n                }\n\n            })();\n            var attrHtmlToJavaScriptMap = { 'class': 'className', 'for': 'htmlFor' };\n            ko.bindingHandlers['attr'] = {\n                'update': function(element, valueAccessor, allBindings) {\n                    var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n                    ko.utils.objectForEach(value, function(attrName, attrValue) {\n                        attrValue = ko.utils.unwrapObservable(attrValue);\n\n                        // Find the namespace of this attribute, if any.\n                        var prefixLen = attrName.indexOf(':');\n                        var namespace = \"lookupNamespaceURI\" in element && prefixLen > 0 && element.lookupNamespaceURI(attrName.substr(0, prefixLen));\n\n                        // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n                        // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n                        // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n                        var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n                        if (toRemove) {\n                            namespace ? element.removeAttributeNS(namespace, attrName) : element.removeAttribute(attrName);\n                        } else {\n                            attrValue = attrValue.toString();\n                        }\n\n                        // In IE <= 7 and IE8 Quirks Mode, you have to use the JavaScript property name instead of the\n                        // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n                        // but instead of figuring out the mode, we'll just set the attribute through the JavaScript\n                        // property for IE <= 8.\n                        if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavaScriptMap) {\n                            attrName = attrHtmlToJavaScriptMap[attrName];\n                            if (toRemove)\n                                element.removeAttribute(attrName);\n                            else\n                                element[attrName] = attrValue;\n                        } else if (!toRemove) {\n                            namespace ? element.setAttributeNS(namespace, attrName, attrValue) : element.setAttribute(attrName, attrValue);\n                        }\n\n                        // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n                        // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n                        // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n                        // entirely, and there's no strong reason to allow for such casing in HTML.\n                        if (attrName === \"name\") {\n                            ko.utils.setElementName(element, toRemove ? \"\" : attrValue);\n                        }\n                    });\n                }\n            };\n            (function() {\n\n                ko.bindingHandlers['checked'] = {\n                    'after': ['value', 'attr'],\n                    'init': function (element, valueAccessor, allBindings) {\n                        var checkedValue = ko.pureComputed(function() {\n                            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n                            if (allBindings['has']('checkedValue')) {\n                                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                            } else if (useElementValue) {\n                                if (allBindings['has']('value')) {\n                                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                                } else {\n                                    return element.value;\n                                }\n                            }\n                        });\n\n                        function updateModel() {\n                            // This updates the model value from the view value.\n                            // It runs in response to DOM events (click) and changes in checkedValue.\n                            var isChecked = element.checked,\n                                elemValue = checkedValue();\n\n                            // When we're first setting up this computed, don't change any model state.\n                            if (ko.computedContext.isInitial()) {\n                                return;\n                            }\n\n                            // We can ignore unchecked radio buttons, because some other radio\n                            // button will be checked, and that one can take care of updating state.\n                            // Also ignore value changes to an already unchecked checkbox.\n                            if (!isChecked && (isRadio || ko.computedContext.getDependenciesCount())) {\n                                return;\n                            }\n\n                            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n                            if (valueIsArray) {\n                                var writableValue = rawValueIsNonArrayObservable ? modelValue.peek() : modelValue,\n                                    saveOldValue = oldElemValue;\n                                oldElemValue = elemValue;\n\n                                if (saveOldValue !== elemValue) {\n                                    // When we're responding to the checkedValue changing, and the element is\n                                    // currently checked, replace the old elem value with the new elem value\n                                    // in the model array.\n                                    if (isChecked) {\n                                        ko.utils.addOrRemoveItem(writableValue, elemValue, true);\n                                        ko.utils.addOrRemoveItem(writableValue, saveOldValue, false);\n                                    }\n                                } else {\n                                    // When we're responding to the user having checked/unchecked a checkbox,\n                                    // add/remove the element value to the model array.\n                                    ko.utils.addOrRemoveItem(writableValue, elemValue, isChecked);\n                                }\n\n                                if (rawValueIsNonArrayObservable && ko.isWriteableObservable(modelValue)) {\n                                    modelValue(writableValue);\n                                }\n                            } else {\n                                if (isCheckbox) {\n                                    if (elemValue === undefined) {\n                                        elemValue = isChecked;\n                                    } else if (!isChecked) {\n                                        elemValue = undefined;\n                                    }\n                                }\n                                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                            }\n                        };\n\n                        function updateView() {\n                            // This updates the view value from the model value.\n                            // It runs in response to changes in the bound (checked) value.\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor()),\n                                elemValue = checkedValue();\n\n                            if (valueIsArray) {\n                                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                                element.checked = ko.utils.arrayIndexOf(modelValue, elemValue) >= 0;\n                                oldElemValue = elemValue;\n                            } else if (isCheckbox && elemValue === undefined) {\n                                // When a checkbox is bound to any other value (not an array) and \"checkedValue\" is not defined,\n                                // being checked represents the value being trueish\n                                element.checked = !!modelValue;\n                            } else {\n                                // Otherwise, being checked means that the checkbox or radio button's value corresponds to the model value\n                                element.checked = (checkedValue() === modelValue);\n                            }\n                        };\n\n                        var isCheckbox = element.type == \"checkbox\",\n                            isRadio = element.type == \"radio\";\n\n                        // Only bind to check boxes and radio buttons\n                        if (!isCheckbox && !isRadio) {\n                            return;\n                        }\n\n                        var rawValue = valueAccessor(),\n                            valueIsArray = isCheckbox && (ko.utils.unwrapObservable(rawValue) instanceof Array),\n                            rawValueIsNonArrayObservable = !(valueIsArray && rawValue.push && rawValue.splice),\n                            useElementValue = isRadio || valueIsArray,\n                            oldElemValue = valueIsArray ? checkedValue() : undefined;\n\n                        // IE 6 won't allow radio buttons to be selected unless they have a name\n                        if (isRadio && !element.name)\n                            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n                        // Set up two computeds to update the binding:\n\n                        // The first responds to changes in the checkedValue value and to element clicks\n                        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n                        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n                        // The second responds to changes in the model value (the one associated with the checked binding)\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n\n                        rawValue = undefined;\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['checked'] = true;\n\n                ko.bindingHandlers['checkedValue'] = {\n                    'update': function (element, valueAccessor) {\n                        element.value = ko.utils.unwrapObservable(valueAccessor());\n                    }\n                };\n\n            })();var classesWrittenByBindingKey = '__ko__cssValue';\n            ko.bindingHandlers['class'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.stringTrim(ko.utils.unwrapObservable(valueAccessor()));\n                    ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n                    element[classesWrittenByBindingKey] = value;\n                    ko.utils.toggleDomNodeCssClass(element, value, true);\n                }\n            };\n\n            ko.bindingHandlers['css'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value !== null && typeof value == \"object\") {\n                        ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                            shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                            ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n                        });\n                    } else {\n                        ko.bindingHandlers['class']['update'](element, valueAccessor);\n                    }\n                }\n            };\n            ko.bindingHandlers['enable'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value && element.disabled)\n                        element.removeAttribute(\"disabled\");\n                    else if ((!value) && (!element.disabled))\n                        element.disabled = true;\n                }\n            };\n\n            ko.bindingHandlers['disable'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\n            function makeEventHandlerShortcut(eventName) {\n                ko.bindingHandlers[eventName] = {\n                    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var newValueAccessor = function () {\n                            var result = {};\n                            result[eventName] = valueAccessor();\n                            return result;\n                        };\n                        return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n                    }\n                }\n            }\n\n            ko.bindingHandlers['event'] = {\n                'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var eventsToHandle = valueAccessor() || {};\n                    ko.utils.objectForEach(eventsToHandle, function(eventName) {\n                        if (typeof eventName == \"string\") {\n                            ko.utils.registerEventHandler(element, eventName, function (event) {\n                                var handlerReturnValue;\n                                var handlerFunction = valueAccessor()[eventName];\n                                if (!handlerFunction)\n                                    return;\n\n                                try {\n                                    // Take all the event args, and prefix with the viewmodel\n                                    var argsForHandler = ko.utils.makeArray(arguments);\n                                    viewModel = bindingContext['$data'];\n                                    argsForHandler.unshift(viewModel);\n                                    handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                                } finally {\n                                    if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                        if (event.preventDefault)\n                                            event.preventDefault();\n                                        else\n                                            event.returnValue = false;\n                                    }\n                                }\n\n                                var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                                if (!bubble) {\n                                    event.cancelBubble = true;\n                                    if (event.stopPropagation)\n                                        event.stopPropagation();\n                                }\n                            });\n                        }\n                    });\n                }\n            };\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\n            ko.bindingHandlers['foreach'] = {\n                makeTemplateValueAccessor: function(valueAccessor) {\n                    return function() {\n                        var modelValue = valueAccessor(),\n                            unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n                        // If unwrappedValue is the array, pass in the wrapped value on its own\n                        // The value will be unwrapped and tracked within the template binding\n                        // (See https://github.com/SteveSanderson/knockout/issues/523)\n                        if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                            return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n                        // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n                        ko.utils.unwrapObservable(modelValue);\n                        return {\n                            'foreach': unwrappedValue['data'],\n                            'as': unwrappedValue['as'],\n                            'noChildContext': unwrappedValue['noChildContext'],\n                            'includeDestroyed': unwrappedValue['includeDestroyed'],\n                            'afterAdd': unwrappedValue['afterAdd'],\n                            'beforeRemove': unwrappedValue['beforeRemove'],\n                            'afterRender': unwrappedValue['afterRender'],\n                            'beforeMove': unwrappedValue['beforeMove'],\n                            'afterMove': unwrappedValue['afterMove'],\n                            'templateEngine': ko.nativeTemplateEngine.instance\n                        };\n                    };\n                },\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n                },\n                'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n                }\n            };\n            ko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\n            ko.virtualElements.allowedBindings['foreach'] = true;\n            var hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\n            var hasfocusLastValue = '__ko_hasfocusLastValue';\n            ko.bindingHandlers['hasfocus'] = {\n                'init': function(element, valueAccessor, allBindings) {\n                    var handleElementFocusChange = function(isFocused) {\n                        // Where possible, ignore which event was raised and determine focus state using activeElement,\n                        // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n                        // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n                        // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n                        // from calling 'blur()' on the element when it loses focus.\n                        // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n                        element[hasfocusUpdatingProperty] = true;\n                        var ownerDoc = element.ownerDocument;\n                        if (\"activeElement\" in ownerDoc) {\n                            var active;\n                            try {\n                                active = ownerDoc.activeElement;\n                            } catch(e) {\n                                // IE9 throws if you access activeElement during page load (see issue #703)\n                                active = ownerDoc.body;\n                            }\n                            isFocused = (active === element);\n                        }\n                        var modelValue = valueAccessor();\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n                        //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n                        element[hasfocusLastValue] = isFocused;\n                        element[hasfocusUpdatingProperty] = false;\n                    };\n                    var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n                    var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n                    ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n                    ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n                    ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n                    ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n\n                    // Assume element is not focused (prevents \"blur\" being called initially)\n                    element[hasfocusLastValue] = false;\n                },\n                'update': function(element, valueAccessor) {\n                    var value = !!ko.utils.unwrapObservable(valueAccessor());\n\n                    if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n                        value ? element.focus() : element.blur();\n\n                        // In IE, the blur method doesn't always cause the element to lose focus (for example, if the window is not in focus).\n                        // Setting focus to the body element does seem to be reliable in IE, but should only be used if we know that the current\n                        // element was focused already.\n                        if (!value && element[hasfocusLastValue]) {\n                            element.ownerDocument.body.focus();\n                        }\n\n                        // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]);\n                    }\n                }\n            };\n            ko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\n            ko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\n            ko.expressionRewriting.twoWayBindings['hasFocus'] = 'hasfocus';\n            ko.bindingHandlers['html'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    // setHtml will unwrap the value if needed\n                    ko.utils.setHtml(element, valueAccessor());\n                }\n            };\n            (function () {\n\n// Makes a binding like with or if\n                function makeWithIfBinding(bindingKey, isWith, isNot) {\n                    ko.bindingHandlers[bindingKey] = {\n                        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                            var didDisplayOnLastUpdate, savedNodes, contextOptions = {}, completeOnRender, needAsyncContext, renderOnEveryChange;\n\n                            if (isWith) {\n                                var as = allBindings.get('as'), noChildContext = allBindings.get('noChildContext');\n                                renderOnEveryChange = !(as && noChildContext);\n                                contextOptions = { 'as': as, 'noChildContext': noChildContext, 'exportDependencies': renderOnEveryChange };\n                            }\n\n                            completeOnRender = allBindings.get(\"completeOn\") == \"render\";\n                            needAsyncContext = completeOnRender || allBindings['has'](ko.bindingEvent.descendantsComplete);\n\n                            ko.computed(function() {\n                                var value = ko.utils.unwrapObservable(valueAccessor()),\n                                    shouldDisplay = !isNot !== !value, // equivalent to isNot ? !value : !!value,\n                                    isInitial = !savedNodes,\n                                    childContext;\n\n                                if (!renderOnEveryChange && shouldDisplay === didDisplayOnLastUpdate) {\n                                    return;\n                                }\n\n                                if (needAsyncContext) {\n                                    bindingContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isWith || renderOnEveryChange) {\n                                        contextOptions['dataDependency'] = ko.computedContext.computed();\n                                    }\n\n                                    if (isWith) {\n                                        childContext = bindingContext['createChildContext'](typeof value == \"function\" ? value : valueAccessor, contextOptions);\n                                    } else if (ko.computedContext.getDependenciesCount()) {\n                                        childContext = bindingContext['extend'](null, contextOptions);\n                                    } else {\n                                        childContext = bindingContext;\n                                    }\n                                }\n\n                                // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                                if (isInitial && ko.computedContext.getDependenciesCount()) {\n                                    savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isInitial) {\n                                        ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                                    }\n\n                                    ko.applyBindingsToDescendants(childContext, element);\n                                } else {\n                                    ko.virtualElements.emptyNode(element);\n\n                                    if (!completeOnRender) {\n                                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                                    }\n                                }\n\n                                didDisplayOnLastUpdate = shouldDisplay;\n\n                            }, null, { disposeWhenNodeIsRemoved: element });\n\n                            return { 'controlsDescendantBindings': true };\n                        }\n                    };\n                    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n                    ko.virtualElements.allowedBindings[bindingKey] = true;\n                }\n\n// Construct the actual binding handlers\n                makeWithIfBinding('if');\n                makeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\n                makeWithIfBinding('with', true /* isWith */);\n\n            })();ko.bindingHandlers['let'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    // Make a modified binding context, with extra properties, and apply it to descendant elements\n                    var innerContext = bindingContext['extend'](valueAccessor);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['let'] = true;\n            var captionPlaceholder = {};\n            ko.bindingHandlers['options'] = {\n                'init': function(element) {\n                    if (ko.utils.tagNameLower(element) !== \"select\")\n                        throw new Error(\"options binding applies only to SELECT elements\");\n\n                    // Remove all existing <option>s.\n                    while (element.length > 0) {\n                        element.remove(0);\n                    }\n\n                    // Ensures that the binding processor doesn't try to bind the options\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor, allBindings) {\n                    function selectedOptions() {\n                        return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n                    }\n\n                    var selectWasPreviouslyEmpty = element.length == 0,\n                        multiple = element.multiple,\n                        previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n                        unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                        valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n                        includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                        arrayToDomNodeChildrenOptions = {},\n                        captionValue,\n                        filteredArray,\n                        previousSelectedValues = [];\n\n                    if (!valueAllowUnset) {\n                        if (multiple) {\n                            previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n                        } else if (element.selectedIndex >= 0) {\n                            previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n                        }\n                    }\n\n                    if (unwrappedArray) {\n                        if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                            unwrappedArray = [unwrappedArray];\n\n                        // Filter out any entries marked as destroyed\n                        filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                            return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                        });\n\n                        // If caption is included, add it to the array\n                        if (allBindings['has']('optionsCaption')) {\n                            captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                            // If caption value is null or undefined, don't show a caption\n                            if (captionValue !== null && captionValue !== undefined) {\n                                filteredArray.unshift(captionPlaceholder);\n                            }\n                        }\n                    } else {\n                        // If a falsy value is provided (e.g. null), we'll simply empty the select element\n                    }\n\n                    function applyToObject(object, predicate, defaultValue) {\n                        var predicateType = typeof predicate;\n                        if (predicateType == \"function\")    // Given a function; run it against the data value\n                            return predicate(object);\n                        else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                            return object[predicate];\n                        else                                // Given no optionsText arg; use the data value itself\n                            return defaultValue;\n                    }\n\n                    // The following functions can run at two different times:\n                    // The first is when the whole array is being updated directly from this binding handler.\n                    // The second is when an observable value for a specific array entry is updated.\n                    // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n                    var itemUpdate = false;\n                    function optionForArrayItem(arrayEntry, index, oldOptions) {\n                        if (oldOptions.length) {\n                            previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                            itemUpdate = true;\n                        }\n                        var option = element.ownerDocument.createElement(\"option\");\n                        if (arrayEntry === captionPlaceholder) {\n                            ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                            ko.selectExtensions.writeValue(option, undefined);\n                        } else {\n                            // Apply a value to the option element\n                            var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                            ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                            // Apply some text to the option element\n                            var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                            ko.utils.setTextContent(option, optionText);\n                        }\n                        return [option];\n                    }\n\n                    // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n                    // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n                    arrayToDomNodeChildrenOptions['beforeRemove'] =\n                        function (option) {\n                            element.removeChild(option);\n                        };\n\n                    function setSelectionCallback(arrayEntry, newOptions) {\n                        if (itemUpdate && valueAllowUnset) {\n                            // The model value is authoritative, so make sure its value is the one selected\n                            ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                        } else if (previousSelectedValues.length) {\n                            // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                            // That's why we first added them without selection. Now it's time to set the selection.\n                            var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                            ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                            // If this option was changed from being selected during a single-item update, notify the change\n                            if (itemUpdate && !isSelected) {\n                                ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                            }\n                        }\n                    }\n\n                    var callback = setSelectionCallback;\n                    if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n                        callback = function(arrayEntry, newOptions) {\n                            setSelectionCallback(arrayEntry, newOptions);\n                            ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n                        }\n                    }\n\n                    ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n                    if (!valueAllowUnset) {\n                        // Determine if the selection has changed as a result of updating the options list\n                        var selectionChanged;\n                        if (multiple) {\n                            // For a multiple-select box, compare the new selection count to the previous one\n                            // But if nothing was selected before, the selection can't have changed\n                            selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                        } else {\n                            // For a single-select box, compare the current value to the previous value\n                            // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                            selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                                ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                                : (previousSelectedValues.length || element.selectedIndex >= 0);\n                        }\n\n                        // Ensure consistency between model value and selected option.\n                        // If the dropdown was changed so that selection is no longer the same,\n                        // notify the value or selectedOptions binding.\n                        if (selectionChanged) {\n                            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                        }\n                    }\n\n                    if (valueAllowUnset || ko.computedContext.isInitial()) {\n                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                    }\n\n                    // Workaround for IE bug\n                    ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n                    if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n                        element.scrollTop = previousScrollTop;\n                }\n            };\n            ko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\n            ko.bindingHandlers['selectedOptions'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    function updateFromView() {\n                        var value = valueAccessor(), valueToWrite = [];\n                        ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                            if (node.selected)\n                                valueToWrite.push(ko.selectExtensions.readValue(node));\n                        });\n                        ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n                    }\n\n                    function updateFromModel() {\n                        var newValue = ko.utils.unwrapObservable(valueAccessor()),\n                            previousScrollTop = element.scrollTop;\n\n                        if (newValue && typeof newValue.length == \"number\") {\n                            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                                if (node.selected != isSelected) {      // This check prevents flashing of the select element in IE\n                                    ko.utils.setOptionNodeSelectionState(node, isSelected);\n                                }\n                            });\n                        }\n\n                        element.scrollTop = previousScrollTop;\n                    }\n\n                    if (ko.utils.tagNameLower(element) != \"select\") {\n                        throw new Error(\"selectedOptions binding applies only to SELECT elements\");\n                    }\n\n                    var updateFromModelComputed;\n                    ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                        if (!updateFromModelComputed) {\n                            ko.utils.registerEventHandler(element, \"change\", updateFromView);\n                            updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                        } else {\n                            updateFromView();\n                        }\n                    }, null, { 'notifyImmediately': true });\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped binding\n            };\n            ko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\n            ko.bindingHandlers['style'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor() || {});\n                    ko.utils.objectForEach(value, function(styleName, styleValue) {\n                        styleValue = ko.utils.unwrapObservable(styleValue);\n\n                        if (styleValue === null || styleValue === undefined || styleValue === false) {\n                            // Empty string removes the value, whereas null/undefined have no effect\n                            styleValue = \"\";\n                        }\n\n                        if (jQueryInstance) {\n                            jQueryInstance(element)['css'](styleName, styleValue);\n                        } else if (/^--/.test(styleName)) {\n                            // Is styleName a custom CSS property?\n                            element.style.setProperty(styleName, styleValue);\n                        } else {\n                            styleName = styleName.replace(/-(\\w)/g, function (all, letter) {\n                                return letter.toUpperCase();\n                            });\n\n                            var previousStyle = element.style[styleName];\n                            element.style[styleName] = styleValue;\n\n                            if (styleValue !== previousStyle && element.style[styleName] == previousStyle && !isNaN(styleValue)) {\n                                element.style[styleName] = styleValue + \"px\";\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['submit'] = {\n                'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    if (typeof valueAccessor() != \"function\")\n                        throw new Error(\"The value for a submit binding must be a function\");\n                    ko.utils.registerEventHandler(element, \"submit\", function (event) {\n                        var handlerReturnValue;\n                        var value = valueAccessor();\n                        try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n                        finally {\n                            if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                if (event.preventDefault)\n                                    event.preventDefault();\n                                else\n                                    event.returnValue = false;\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['text'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n                    // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    ko.utils.setTextContent(element, valueAccessor());\n                }\n            };\n            ko.virtualElements.allowedBindings['text'] = true;\n            (function () {\n\n                if (window && window.navigator) {\n                    var parseVersion = function (matches) {\n                        if (matches) {\n                            return parseFloat(matches[1]);\n                        }\n                    };\n\n                    // Detect various browser versions because some old versions don't fully support the 'input' event\n                    var userAgent = window.navigator.userAgent,\n                        operaVersion, chromeVersion, safariVersion, firefoxVersion, ieVersion, edgeVersion;\n\n                    (operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()))\n                    || (edgeVersion = parseVersion(userAgent.match(/Edge\\/([^ ]+)$/)))\n                    || (chromeVersion = parseVersion(userAgent.match(/Chrome\\/([^ ]+)/)))\n                    || (safariVersion = parseVersion(userAgent.match(/Version\\/([^ ]+) Safari/)))\n                    || (firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]+)/)))\n                    || (ieVersion = ko.utils.ieVersion || parseVersion(userAgent.match(/MSIE ([^ ]+)/)))      // Detects up to IE 10\n                    || (ieVersion = parseVersion(userAgent.match(/rv:([^ )]+)/)));      // Detects IE 11\n                }\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\n                if (ieVersion >= 8 && ieVersion < 10) {\n                    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n                        selectionChangeHandlerName = ko.utils.domData.nextKey();\n                    var selectionChangeHandler = function(event) {\n                        var target = this.activeElement,\n                            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n                        if (handler) {\n                            handler(event);\n                        }\n                    };\n                    var registerForSelectionChangeEvent = function (element, handler) {\n                        var ownerDoc = element.ownerDocument;\n                        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n                            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n                            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n                        }\n                        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n                    };\n                }\n\n                ko.bindingHandlers['textInput'] = {\n                    'init': function (element, valueAccessor, allBindings) {\n\n                        var previousElementValue = element.value,\n                            timeoutHandle,\n                            elementValueBeforeEvent;\n\n                        var updateModel = function (event) {\n                            clearTimeout(timeoutHandle);\n                            elementValueBeforeEvent = timeoutHandle = undefined;\n\n                            var elementValue = element.value;\n                            if (previousElementValue !== elementValue) {\n                                // Provide a way for tests to know exactly which event was processed\n                                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                                previousElementValue = elementValue;\n                                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n                            }\n                        };\n\n                        var deferUpdateModel = function (event) {\n                            if (!timeoutHandle) {\n                                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                                // event firing and the updateModel function running. This allows us to ignore model\n                                // updates that are from the previous state of the element, usually due to techniques\n                                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                                elementValueBeforeEvent = element.value;\n                                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                                timeoutHandle = ko.utils.setTimeout(handler, 4);\n                            }\n                        };\n\n                        // IE9 will mess up the DOM if you handle events synchronously which results in DOM changes (such as other bindings);\n                        // so we'll make sure all updates are asynchronous\n                        var ieUpdateModel = ko.utils.ieVersion == 9 ? deferUpdateModel : updateModel,\n                            ourUpdate = false;\n\n                        var updateView = function () {\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                            if (modelValue === null || modelValue === undefined) {\n                                modelValue = '';\n                            }\n\n                            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateView, 4);\n                                return;\n                            }\n\n                            // Update the element only if the element and model are different. On some browsers, updating the value\n                            // will move the cursor to the end of the input, which would be bad while the user is typing.\n                            if (element.value !== modelValue) {\n                                ourUpdate = true;  // Make sure we ignore events (propertychange) that result from updating the value\n                                element.value = modelValue;\n                                ourUpdate = false;\n                                previousElementValue = element.value; // In case the browser changes the value (see #2281)\n                            }\n                        };\n\n                        var onEvent = function (event, handler) {\n                            ko.utils.registerEventHandler(element, event, handler);\n                        };\n\n                        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n                            // Provide a way for tests to specify exactly which events are bound\n                            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                                if (eventName.slice(0,5) == 'after') {\n                                    onEvent(eventName.slice(5), deferUpdateModel);\n                                } else {\n                                    onEvent(eventName, updateModel);\n                                }\n                            });\n                        } else {\n                            if (ieVersion) {\n                                // All versions (including 11) of Internet Explorer have a bug that they don't generate an input or propertychange event when ESC is pressed\n                                onEvent('keypress', updateModel);\n                            }\n                            if (ieVersion < 11) {\n                                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                                // but that's an acceptable compromise for this binding. IE 9 and 10 support 'input', but since they don't always\n                                // fire it when using autocomplete, we'll use 'propertychange' for them also.\n                                onEvent('propertychange', function(event) {\n                                    if (!ourUpdate && event.propertyName === 'value') {\n                                        ieUpdateModel(event);\n                                    }\n                                });\n                            }\n                            if (ieVersion == 8) {\n                                // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                                // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                                // events too.\n                                onEvent('keyup', updateModel);      // A single keystoke\n                                onEvent('keydown', updateModel);    // The first character when a key is held down\n                            }\n                            if (registerForSelectionChangeEvent) {\n                                // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                                // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                                // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                                // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                                // These are also needed in IE8 because of the bug described above.\n                                registerForSelectionChangeEvent(element, ieUpdateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                                onEvent('dragend', deferUpdateModel);\n                            }\n\n                            if (!ieVersion || ieVersion >= 9) {\n                                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                                // through the user interface.\n                                onEvent('input', ieUpdateModel);\n                            }\n\n                            if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                                // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                                // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                                onEvent('keydown', deferUpdateModel);\n                                onEvent('paste', deferUpdateModel);\n                                onEvent('cut', deferUpdateModel);\n                            } else if (operaVersion < 11) {\n                                // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                                // We can try to catch some of those using 'keydown'.\n                                onEvent('keydown', deferUpdateModel);\n                            } else if (firefoxVersion < 4.0) {\n                                // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                                onEvent('DOMAutoComplete', updateModel);\n\n                                // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                                onEvent('dragdrop', updateModel);       // <3.5\n                                onEvent('drop', updateModel);           // 3.5\n                            } else if (edgeVersion && element.type === \"number\") {\n                                // Microsoft Edge doesn't fire 'input' or 'change' events for number inputs when\n                                // the value is changed via the up / down arrow keys\n                                onEvent('keydown', deferUpdateModel);\n                            }\n                        }\n\n                        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n                        onEvent('change', updateModel);\n\n                        // To deal with browsers that don't notify any kind of event for some changes (IE, Safari, etc.)\n                        onEvent('blur', updateModel);\n\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\n                ko.bindingHandlers['textinput'] = {\n                    // preprocess is the only way to set up a full alias\n                    'preprocess': function (value, name, addBinding) {\n                        addBinding('textInput', value);\n                    }\n                };\n\n            })();ko.bindingHandlers['uniqueName'] = {\n                'init': function (element, valueAccessor) {\n                    if (valueAccessor()) {\n                        var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n                        ko.utils.setElementName(element, name);\n                    }\n                }\n            };\n            ko.bindingHandlers['uniqueName'].currentIndex = 0;\n            ko.bindingHandlers['using'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var options;\n\n                    if (allBindings['has']('as')) {\n                        options = { 'as': allBindings.get('as'), 'noChildContext': allBindings.get('noChildContext') };\n                    }\n\n                    var innerContext = bindingContext['createChildContext'](valueAccessor, options);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['using'] = true;\n            ko.bindingHandlers['value'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    var tagName = ko.utils.tagNameLower(element),\n                        isInputElement = tagName == \"input\";\n\n                    // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n                    if (isInputElement && (element.type == \"checkbox\" || element.type == \"radio\")) {\n                        ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n                        return;\n                    }\n\n                    var eventsToCatch = [];\n                    var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n                    var propertyChangedFired = false;\n                    var elementValueBeforeEvent = null;\n\n                    if (requestedEventsToCatch) {\n                        // Allow both individual event names, and arrays of event names\n                        if (typeof requestedEventsToCatch == \"string\") {\n                            eventsToCatch = [requestedEventsToCatch];\n                        } else {\n                            eventsToCatch = ko.utils.arrayGetDistinctValues(requestedEventsToCatch);\n                        }\n                        ko.utils.arrayRemoveItem(eventsToCatch, \"change\");  // We'll subscribe to \"change\" events later\n                    }\n\n                    var valueUpdateHandler = function() {\n                        elementValueBeforeEvent = null;\n                        propertyChangedFired = false;\n                        var modelValue = valueAccessor();\n                        var elementValue = ko.selectExtensions.readValue(element);\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n                    }\n\n                    // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n                    // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n                    var ieAutoCompleteHackNeeded = ko.utils.ieVersion && isInputElement && element.type == \"text\"\n                        && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n                    if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n                        ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n                        ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n                        ko.utils.registerEventHandler(element, \"blur\", function() {\n                            if (propertyChangedFired) {\n                                valueUpdateHandler();\n                            }\n                        });\n                    }\n\n                    ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n                        // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n                        // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n                        // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n                        var handler = valueUpdateHandler;\n                        if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                            handler = function() {\n                                // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                                // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                                // at the earliest asynchronous opportunity. We store this temporary information so that\n                                // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                                // we can overwrite that model value change with the value the user just typed. Otherwise,\n                                // techniques like rateLimit can trigger model changes at critical moments that will\n                                // override the user's inputs, causing keystrokes to be lost.\n                                elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                                ko.utils.setTimeout(valueUpdateHandler, 0);\n                            };\n                            eventName = eventName.substring(\"after\".length);\n                        }\n                        ko.utils.registerEventHandler(element, eventName, handler);\n                    });\n\n                    var updateFromModel;\n\n                    if (isInputElement && element.type == \"file\") {\n                        // For file input elements, can only write the empty string\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            if (newValue === null || newValue === undefined || newValue === \"\") {\n                                element.value = \"\";\n                            } else {\n                                ko.dependencyDetection.ignore(valueUpdateHandler);  // reset the model to match the element\n                            }\n                        }\n                    } else {\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            var elementValue = ko.selectExtensions.readValue(element);\n\n                            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateFromModel, 0);\n                                return;\n                            }\n\n                            var valueHasChanged = newValue !== elementValue;\n\n                            if (valueHasChanged || elementValue === undefined) {\n                                if (tagName === \"select\") {\n                                    var allowUnset = allBindings.get('valueAllowUnset');\n                                    ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                                        ko.dependencyDetection.ignore(valueUpdateHandler);\n                                    }\n                                } else {\n                                    ko.selectExtensions.writeValue(element, newValue);\n                                }\n                            }\n                        };\n                    }\n\n                    if (tagName === \"select\") {\n                        var updateFromModelComputed;\n                        ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                            if (!updateFromModelComputed) {\n                                ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                                updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                            } else if (allBindings.get('valueAllowUnset')) {\n                                updateFromModel();\n                            } else {\n                                valueUpdateHandler();\n                            }\n                        }, null, { 'notifyImmediately': true });\n                    } else {\n                        ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n            };\n            ko.expressionRewriting.twoWayBindings['value'] = true;\n            ko.bindingHandlers['visible'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    var isCurrentlyVisible = !(element.style.display == \"none\");\n                    if (value && !isCurrentlyVisible)\n                        element.style.display = \"\";\n                    else if ((!value) && isCurrentlyVisible)\n                        element.style.display = \"none\";\n                }\n            };\n\n            ko.bindingHandlers['hidden'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['visible']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\n            makeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\n            ko.templateEngine = function () { };\n\n            ko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                throw new Error(\"Override renderTemplateSource\");\n            };\n\n            ko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n                throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n            };\n\n            ko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n                // Named template\n                if (typeof template == \"string\") {\n                    templateDocument = templateDocument || document;\n                    var elem = templateDocument.getElementById(template);\n                    if (!elem)\n                        throw new Error(\"Cannot find template with ID \" + template);\n                    return new ko.templateSources.domElement(elem);\n                } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n                    // Anonymous template\n                    return new ko.templateSources.anonymousTemplate(template);\n                } else\n                    throw new Error(\"Unknown template type: \" + template);\n            };\n\n            ko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n            };\n\n            ko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n                // Skip rewriting if requested\n                if (this['allowTemplateRewriting'] === false)\n                    return true;\n                return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n            };\n\n            ko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                var rewritten = rewriterCallback(templateSource['text']());\n                templateSource['text'](rewritten);\n                templateSource['data'](\"isRewritten\", true);\n            };\n\n            ko.exportSymbol('templateEngine', ko.templateEngine);\n\n            ko.templateRewriting = (function () {\n                var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n                var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n                function validateDataBindValuesForRewriting(keyValueArray) {\n                    var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n                    for (var i = 0; i < keyValueArray.length; i++) {\n                        var key = keyValueArray[i]['key'];\n                        if (Object.prototype.hasOwnProperty.call(allValidators, key)) {\n                            var validator = allValidators[key];\n\n                            if (typeof validator === \"function\") {\n                                var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                                if (possibleErrorMessage)\n                                    throw new Error(possibleErrorMessage);\n                            } else if (!validator) {\n                                throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                            }\n                        }\n                    }\n                }\n\n                function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n                    var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n                    validateDataBindValuesForRewriting(dataBindKeyValueArray);\n                    var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n                    // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n                    // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n                    // extra indirection.\n                    var applyBindingsToNextSiblingScript =\n                        \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n                    return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n                }\n\n                return {\n                    ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n                        if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                            templateEngine['rewriteTemplate'](template, function (htmlString) {\n                                return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                            }, templateDocument);\n                    },\n\n                    memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n                        return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n                        }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n                        });\n                    },\n\n                    applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n                        return ko.memoization.memoize(function (domNode, bindingContext) {\n                            var nodeToBind = domNode.nextSibling;\n                            if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                                ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                            }\n                        });\n                    }\n                }\n            })();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\n            ko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n            (function() {\n                // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n                // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n                //\n                // Two are provided by default:\n                //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n                //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n                //                                           without reading/writing the actual element text content, since it will be overwritten\n                //                                           with the rendered template output.\n                // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n                // Template sources need to have the following functions:\n                //   text() \t\t\t- returns the template text from your storage location\n                //   text(value)\t\t- writes the supplied template text to your storage location\n                //   data(key)\t\t\t- reads values stored using data(key, value) - see below\n                //   data(key, value)\t- associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n                //\n                // Optionally, template sources can also have the following functions:\n                //   nodes()            - returns a DOM element containing the nodes of this template, where available\n                //   nodes(value)       - writes the given DOM element to your storage location\n                // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n                // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n                //\n                // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n                // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n                ko.templateSources = {};\n\n                // ---- ko.templateSources.domElement -----\n\n                // template types\n                var templateScript = 1,\n                    templateTextArea = 2,\n                    templateTemplate = 3,\n                    templateElement = 4;\n\n                ko.templateSources.domElement = function(element) {\n                    this.domElement = element;\n\n                    if (element) {\n                        var tagNameLower = ko.utils.tagNameLower(element);\n                        this.templateType =\n                            tagNameLower === \"script\" ? templateScript :\n                                tagNameLower === \"textarea\" ? templateTextArea :\n                                    // For browsers with proper <template> element support, where the .content property gives a document fragment\n                                    tagNameLower == \"template\" && element.content && element.content.nodeType === 11 ? templateTemplate :\n                                        templateElement;\n                    }\n                }\n\n                ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n                    var elemContentsProperty = this.templateType === templateScript ? \"text\"\n                        : this.templateType === templateTextArea ? \"value\"\n                            : \"innerHTML\";\n\n                    if (arguments.length == 0) {\n                        return this.domElement[elemContentsProperty];\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (elemContentsProperty === \"innerHTML\")\n                            ko.utils.setHtml(this.domElement, valueToWrite);\n                        else\n                            this.domElement[elemContentsProperty] = valueToWrite;\n                    }\n                };\n\n                var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n                ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n                    if (arguments.length === 1) {\n                        return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n                    } else {\n                        ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n                    }\n                };\n\n                var templatesDomDataKey = ko.utils.domData.nextKey();\n                function getTemplateDomData(element) {\n                    return ko.utils.domData.get(element, templatesDomDataKey) || {};\n                }\n                function setTemplateDomData(element, data) {\n                    ko.utils.domData.set(element, templatesDomDataKey, data);\n                }\n\n                ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n                    var element = this.domElement;\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(element),\n                            nodes = templateData.containerData || (\n                                this.templateType === templateTemplate ? element.content :\n                                    this.templateType === templateElement ? element :\n                                        undefined);\n                        if (!nodes || templateData.alwaysCheckText) {\n                            // If the template is associated with an element that stores the template as text,\n                            // parse and cache the nodes whenever there's new text content available. This allows\n                            // the user to update the template content by updating the text of template node.\n                            var text = this['text']();\n                            if (text && text !== templateData.textData) {\n                                nodes = ko.utils.parseHtmlForTemplateNodes(text, element.ownerDocument);\n                                setTemplateDomData(element, {containerData: nodes, textData: text, alwaysCheckText: true});\n                            }\n                        }\n                        return nodes;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (this.templateType !== undefined) {\n                            this['text'](\"\");   // clear the text from the node\n                        }\n                        setTemplateDomData(element, {containerData: valueToWrite});\n                    }\n                };\n\n                // ---- ko.templateSources.anonymousTemplate -----\n                // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n                // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n                // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n                ko.templateSources.anonymousTemplate = function(element) {\n                    this.domElement = element;\n                }\n                ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n                ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n                ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(this.domElement);\n                        if (templateData.textData === undefined && templateData.containerData)\n                            templateData.textData = templateData.containerData.innerHTML;\n                        return templateData.textData;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        setTemplateDomData(this.domElement, {textData: valueToWrite});\n                    }\n                };\n\n                ko.exportSymbol('templateSources', ko.templateSources);\n                ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n                ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n            })();\n            (function () {\n                var _templateEngine;\n                ko.setTemplateEngine = function (templateEngine) {\n                    if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n                        throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n                    _templateEngine = templateEngine;\n                }\n\n                function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n                    var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n                    while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n                        nextInQueue = ko.virtualElements.nextSibling(node);\n                        action(node, nextInQueue);\n                    }\n                }\n\n                function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n                    // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n                    // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n                    // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n                    // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n                    // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n                    if (continuousNodeArray.length) {\n                        var firstNode = continuousNodeArray[0],\n                            lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                            parentNode = firstNode.parentNode,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        if (preprocessNode) {\n                            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                                var nodePreviousSibling = node.previousSibling;\n                                var newNodes = preprocessNode.call(provider, node);\n                                if (newNodes) {\n                                    if (node === firstNode)\n                                        firstNode = newNodes[0] || nextNodeInRange;\n                                    if (node === lastNode)\n                                        lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                                }\n                            });\n\n                            // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                            // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                            // first node needs to be in the array).\n                            continuousNodeArray.length = 0;\n                            if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                                return;\n                            }\n                            if (firstNode === lastNode) {\n                                continuousNodeArray.push(firstNode);\n                            } else {\n                                continuousNodeArray.push(firstNode, lastNode);\n                                ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                            }\n                        }\n\n                        // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n                        // whereas a regular applyBindings won't introduce new memoized nodes\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.applyBindings(bindingContext, node);\n                        });\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n                        });\n\n                        // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n                        ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                    }\n                }\n\n                function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n                    return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                            : null;\n                }\n\n                function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n                    options = options || {};\n                    var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n                    var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n                    ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n                    var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n                    // Loosely check result is an array of DOM nodes\n                    if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n                        throw new Error(\"Template engine must return an array of DOM nodes\");\n\n                    var haveAddedNodesToParent = false;\n                    switch (renderMode) {\n                        case \"replaceChildren\":\n                            ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"replaceNode\":\n                            ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"ignoreTargetNode\": break;\n                        default:\n                            throw new Error(\"Unknown renderMode: \" + renderMode);\n                    }\n\n                    if (haveAddedNodesToParent) {\n                        activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n                        if (options['afterRender']) {\n                            ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext[options['as'] || '$data']]);\n                        }\n                        if (renderMode == \"replaceChildren\") {\n                            ko.bindingEvent.notify(targetNodeOrNodeArray, ko.bindingEvent.childrenComplete);\n                        }\n                    }\n\n                    return renderedNodesArray;\n                }\n\n                function resolveTemplateName(template, data, context) {\n                    // The template can be specified as:\n                    if (ko.isObservable(template)) {\n                        // 1. An observable, with string value\n                        return template();\n                    } else if (typeof template === 'function') {\n                        // 2. A function of (data, context) returning a string\n                        return template(data, context);\n                    } else {\n                        // 3. A string\n                        return template;\n                    }\n                }\n\n                ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n                    options = options || {};\n                    if ((options['templateEngine'] || _templateEngine) == undefined)\n                        throw new Error(\"Set a template engine before calling renderTemplate\");\n                    renderMode = renderMode || \"replaceChildren\";\n\n                    if (targetNodeOrNodeArray) {\n                        var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n                        var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n                        var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n                        return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                            function () {\n                                // Ensure we've got a proper binding context to work with\n                                var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                                    ? dataOrBindingContext\n                                    : new ko.bindingContext(dataOrBindingContext, null, null, null, { \"exportDependencies\": true });\n\n                                var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                                    renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                                if (renderMode == \"replaceNode\") {\n                                    targetNodeOrNodeArray = renderedNodesArray;\n                                    firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                                }\n                            },\n                            null,\n                            { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n                        );\n                    } else {\n                        // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n                        return ko.memoization.memoize(function (domNode) {\n                            ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n                        });\n                    }\n                };\n\n                ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n                    // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n                    // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n                    var arrayItemContext, asName = options['as'];\n\n                    // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n                    var executeTemplateForArrayItem = function (arrayValue, index) {\n                        // Support selecting template as a function of the data being rendered\n                        arrayItemContext = parentBindingContext['createChildContext'](arrayValue, {\n                            'as': asName,\n                            'noChildContext': options['noChildContext'],\n                            'extend': function(context) {\n                                context['$index'] = index;\n                                if (asName) {\n                                    context[asName + \"Index\"] = index;\n                                }\n                            }\n                        });\n\n                        var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n                        return executeTemplate(targetNode, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n                    };\n\n                    // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n                    var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n                        activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n                        if (options['afterRender'])\n                            options['afterRender'](addedNodesArray, arrayValue);\n\n                        // release the \"cache\" variable, so that it can be collected by\n                        // the GC when its value isn't used from within the bindings anymore.\n                        arrayItemContext = null;\n                    };\n\n                    var setDomNodeChildrenFromArrayMapping = function (newArray, changeList) {\n                        // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n                        // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n                        ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, newArray, executeTemplateForArrayItem, options, activateBindingsCallback, changeList]);\n                        ko.bindingEvent.notify(targetNode, ko.bindingEvent.childrenComplete);\n                    };\n\n                    var shouldHideDestroyed = (options['includeDestroyed'] === false) || (ko.options['foreachHidesDestroyed'] && !options['includeDestroyed']);\n\n                    if (!shouldHideDestroyed && !options['beforeRemove'] && ko.isObservableArray(arrayOrObservableArray)) {\n                        setDomNodeChildrenFromArrayMapping(arrayOrObservableArray.peek());\n\n                        var subscription = arrayOrObservableArray.subscribe(function (changeList) {\n                            setDomNodeChildrenFromArrayMapping(arrayOrObservableArray(), changeList);\n                        }, null, \"arrayChange\");\n                        subscription.disposeWhenNodeIsRemoved(targetNode);\n\n                        return subscription;\n                    } else {\n                        return ko.dependentObservable(function () {\n                            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n                            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                                unwrappedArray = [unwrappedArray];\n\n                            if (shouldHideDestroyed) {\n                                // Filter out any entries marked as destroyed\n                                unwrappedArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                                    return item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                                });\n                            }\n                            setDomNodeChildrenFromArrayMapping(unwrappedArray);\n\n                        }, null, { disposeWhenNodeIsRemoved: targetNode });\n                    }\n                };\n\n                var templateComputedDomDataKey = ko.utils.domData.nextKey();\n                function disposeOldComputedAndStoreNewOne(element, newComputed) {\n                    var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n                    if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n                        oldComputed.dispose();\n                    ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && (!newComputed.isActive || newComputed.isActive())) ? newComputed : undefined);\n                }\n\n                var cleanContainerDomDataKey = ko.utils.domData.nextKey();\n                ko.bindingHandlers['template'] = {\n                    'init': function(element, valueAccessor) {\n                        // Support anonymous templates\n                        var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n                        if (typeof bindingValue == \"string\" || 'name' in bindingValue) {\n                            // It's a named template - clear the element\n                            ko.virtualElements.emptyNode(element);\n                        } else if ('nodes' in bindingValue) {\n                            // We've been given an array of DOM nodes. Save them as the template source.\n                            // There is no known use case for the node array being an observable array (if the output\n                            // varies, put that behavior *into* your template - that's what templates are for), and\n                            // the implementation would be a mess, so assert that it's not observable.\n                            var nodes = bindingValue['nodes'] || [];\n                            if (ko.isObservable(nodes)) {\n                                throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                            }\n\n                            // If the nodes are already attached to a KO-generated container, we reuse that container without moving the\n                            // elements to a new one (we check only the first node, as the nodes are always moved together)\n                            var container = nodes[0] && nodes[0].parentNode;\n                            if (!container || !ko.utils.domData.get(container, cleanContainerDomDataKey)) {\n                                container = ko.utils.moveCleanedNodesToContainerElement(nodes);\n                                ko.utils.domData.set(container, cleanContainerDomDataKey, true);\n                            }\n\n                            new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                        } else {\n                            // It's an anonymous template - store the element contents, then clear the element\n                            var templateNodes = ko.virtualElements.childNodes(element);\n                            if (templateNodes.length > 0) {\n                                var container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                            } else {\n                                throw new Error(\"Anonymous template defined, but no template content was provided\");\n                            }\n                        }\n                        return { 'controlsDescendantBindings': true };\n                    },\n                    'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var value = valueAccessor(),\n                            options = ko.utils.unwrapObservable(value),\n                            shouldDisplay = true,\n                            templateComputed = null,\n                            template;\n\n                        if (typeof options == \"string\") {\n                            template = value;\n                            options = {};\n                        } else {\n                            template = 'name' in options ? options['name'] : element;\n\n                            // Support \"if\"/\"ifnot\" conditions\n                            if ('if' in options)\n                                shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                            if (shouldDisplay && 'ifnot' in options)\n                                shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                            // Don't show anything if an empty name is given (see #2446)\n                            if (shouldDisplay && !template) {\n                                shouldDisplay = false;\n                            }\n                        }\n\n                        if ('foreach' in options) {\n                            // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                            var dataArray = (shouldDisplay && options['foreach']) || [];\n                            templateComputed = ko.renderTemplateForEach(template, dataArray, options, element, bindingContext);\n                        } else if (!shouldDisplay) {\n                            ko.virtualElements.emptyNode(element);\n                        } else {\n                            // Render once for this single data point (or use the viewModel if no data was provided)\n                            var innerBindingContext = bindingContext;\n                            if ('data' in options) {\n                                innerBindingContext = bindingContext['createChildContext'](options['data'], {\n                                    'as': options['as'],\n                                    'noChildContext': options['noChildContext'],\n                                    'exportDependencies': true\n                                });\n                            }\n                            templateComputed = ko.renderTemplate(template, innerBindingContext, options, element);\n                        }\n\n                        // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n                        disposeOldComputedAndStoreNewOne(element, templateComputed);\n                    }\n                };\n\n                // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n                ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n                    var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n                    if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n                        return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n                    if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n                        return null; // Named templates can be rewritten, so return \"no error\"\n                    return \"This template engine does not support anonymous templates nested within its templates\";\n                };\n\n                ko.virtualElements.allowedBindings['template'] = true;\n            })();\n\n            ko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\n            ko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\n            ko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n                if (left.length && right.length) {\n                    var failedCompares, l, r, leftItem, rightItem;\n                    for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n                        for (r = 0; rightItem = right[r]; ++r) {\n                            if (leftItem['value'] === rightItem['value']) {\n                                leftItem['moved'] = rightItem['index'];\n                                rightItem['moved'] = leftItem['index'];\n                                right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                                failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                                break;\n                            }\n                        }\n                        failedCompares += r;\n                    }\n                }\n            };\n\n            ko.utils.compareArrays = (function () {\n                var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n                // Simple calculation based on Levenshtein distance.\n                function compareArrays(oldArray, newArray, options) {\n                    // For backward compatibility, if the third arg is actually a bool, interpret\n                    // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n                    options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n                    oldArray = oldArray || [];\n                    newArray = newArray || [];\n\n                    if (oldArray.length < newArray.length)\n                        return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n                    else\n                        return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n                }\n\n                function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n                    var myMin = Math.min,\n                        myMax = Math.max,\n                        editDistanceMatrix = [],\n                        smlIndex, smlIndexMax = smlArray.length,\n                        bigIndex, bigIndexMax = bigArray.length,\n                        compareRange = (bigIndexMax - smlIndexMax) || 1,\n                        maxDistance = smlIndexMax + bigIndexMax + 1,\n                        thisRow, lastRow,\n                        bigIndexMaxForRow, bigIndexMinForRow;\n\n                    for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n                        lastRow = thisRow;\n                        editDistanceMatrix.push(thisRow = []);\n                        bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n                        bigIndexMinForRow = myMax(0, smlIndex - 1);\n                        for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                            if (!bigIndex)\n                                thisRow[bigIndex] = smlIndex + 1;\n                            else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                                thisRow[bigIndex] = bigIndex + 1;\n                            else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                                thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                            else {\n                                var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                                var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                                thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                            }\n                        }\n                    }\n\n                    var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n                    for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n                        meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n                        if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                            notInSml.push(editScript[editScript.length] = {     // added\n                                'status': statusNotInSml,\n                                'value': bigArray[--bigIndex],\n                                'index': bigIndex });\n                        } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                            notInBig.push(editScript[editScript.length] = {     // deleted\n                                'status': statusNotInBig,\n                                'value': smlArray[--smlIndex],\n                                'index': smlIndex });\n                        } else {\n                            --bigIndex;\n                            --smlIndex;\n                            if (!options['sparse']) {\n                                editScript.push({\n                                    'status': \"retained\",\n                                    'value': bigArray[bigIndex] });\n                            }\n                        }\n                    }\n\n                    // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n                    // smlIndexMax keeps the time complexity of this algorithm linear.\n                    ko.utils.findMovesInArrayComparison(notInBig, notInSml, !options['dontLimitMoves'] && smlIndexMax * 10);\n\n                    return editScript.reverse();\n                }\n\n                return compareArrays;\n            })();\n\n            ko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n            (function () {\n                // Objective:\n                // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n                //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n                // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n                //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n                //   previously mapped - retain those nodes, and just insert/delete other ones\n\n                // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n                // You can use this, for example, to activate bindings on those nodes.\n\n                function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n                    // Map this array value inside a dependentObservable so we re-map when any dependency changes\n                    var mappedNodes = [];\n                    var dependentObservable = ko.dependentObservable(function() {\n                        var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n                        // On subsequent evaluations, just replace the previously-inserted DOM nodes\n                        if (mappedNodes.length > 0) {\n                            ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                            if (callbackAfterAddingNodes)\n                                ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n                        }\n\n                        // Replace the contents of the mappedNodes array, thereby updating the record\n                        // of which nodes would be deleted if valueToMap was itself later removed\n                        mappedNodes.length = 0;\n                        ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n                    }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n                    return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n                }\n\n                var lastMappingResultDomDataKey = ko.utils.domData.nextKey(),\n                    deletedItemDummyValue = ko.utils.domData.nextKey();\n\n                ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes, editScript) {\n                    array = array || [];\n                    if (typeof array.length == \"undefined\") // Coerce single value into array\n                        array = [array];\n\n                    options = options || {};\n                    var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey);\n                    var isFirstExecution = !lastMappingResult;\n\n                    // Build the new mapping result\n                    var newMappingResult = [];\n                    var lastMappingResultIndex = 0;\n                    var currentArrayIndex = 0;\n\n                    var nodesToDelete = [];\n                    var itemsToMoveFirstIndexes = [];\n                    var itemsForBeforeRemoveCallbacks = [];\n                    var itemsForMoveCallbacks = [];\n                    var itemsForAfterAddCallbacks = [];\n                    var mapData;\n                    var countWaitingForRemove = 0;\n\n                    function itemAdded(value) {\n                        mapData = { arrayEntry: value, indexObservable: ko.observable(currentArrayIndex++) };\n                        newMappingResult.push(mapData);\n                        if (!isFirstExecution) {\n                            itemsForAfterAddCallbacks.push(mapData);\n                        }\n                    }\n\n                    function itemMovedOrRetained(oldPosition) {\n                        mapData = lastMappingResult[oldPosition];\n                        if (currentArrayIndex !== mapData.indexObservable.peek())\n                            itemsForMoveCallbacks.push(mapData);\n                        // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n                        mapData.indexObservable(currentArrayIndex++);\n                        ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n                        newMappingResult.push(mapData);\n                    }\n\n                    function callCallback(callback, items) {\n                        if (callback) {\n                            for (var i = 0, n = items.length; i < n; i++) {\n                                ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                                    callback(node, i, items[i].arrayEntry);\n                                });\n                            }\n                        }\n                    }\n\n                    if (isFirstExecution) {\n                        ko.utils.arrayForEach(array, itemAdded);\n                    } else {\n                        if (!editScript || (lastMappingResult && lastMappingResult['_countWaitingForRemove'])) {\n                            // Compare the provided array against the previous one\n                            var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; }),\n                                compareOptions = {\n                                    'dontLimitMoves': options['dontLimitMoves'],\n                                    'sparse': true\n                                };\n                            editScript = ko.utils.compareArrays(lastArray, array, compareOptions);\n                        }\n\n                        for (var i = 0, editScriptItem, movedIndex, itemIndex; editScriptItem = editScript[i]; i++) {\n                            movedIndex = editScriptItem['moved'];\n                            itemIndex = editScriptItem['index'];\n                            switch (editScriptItem['status']) {\n                                case \"deleted\":\n                                    while (lastMappingResultIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex === undefined) {\n                                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                                        // Stop tracking changes to the mapping for these nodes\n                                        if (mapData.dependentObservable) {\n                                            mapData.dependentObservable.dispose();\n                                            mapData.dependentObservable = undefined;\n                                        }\n\n                                        // Queue these nodes for later removal\n                                        if (ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode).length) {\n                                            if (options['beforeRemove']) {\n                                                newMappingResult.push(mapData);\n                                                countWaitingForRemove++;\n                                                if (mapData.arrayEntry === deletedItemDummyValue) {\n                                                    mapData = null;\n                                                } else {\n                                                    itemsForBeforeRemoveCallbacks.push(mapData);\n                                                }\n                                            }\n                                            if (mapData) {\n                                                nodesToDelete.push.apply(nodesToDelete, mapData.mappedNodes);\n                                            }\n                                        }\n                                    }\n                                    lastMappingResultIndex++;\n                                    break;\n\n                                case \"added\":\n                                    while (currentArrayIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex !== undefined) {\n                                        itemsToMoveFirstIndexes.push(newMappingResult.length);\n                                        itemMovedOrRetained(movedIndex);\n                                    } else {\n                                        itemAdded(editScriptItem['value']);\n                                    }\n                                    break;\n                            }\n                        }\n\n                        while (currentArrayIndex < array.length) {\n                            itemMovedOrRetained(lastMappingResultIndex++);\n                        }\n\n                        // Record that the current view may still contain deleted items\n                        // because it means we won't be able to use a provided editScript.\n                        newMappingResult['_countWaitingForRemove'] = countWaitingForRemove;\n                    }\n\n                    // Store a copy of the array items we just considered so we can difference it next time\n                    ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n\n                    // Call beforeMove first before any changes have been made to the DOM\n                    callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n                    // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n                    ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n                    var i, j, lastNode, nodeToInsert, mappedNodes, activeElement;\n\n                    // Since most browsers remove the focus from an element when it's moved to another location,\n                    // save the focused element and try to restore it later.\n                    try {\n                        activeElement = domNode.ownerDocument.activeElement;\n                    } catch(e) {\n                        // IE9 throws if you access activeElement during page load (see issue #703)\n                    }\n\n                    // Try to reduce overall moved nodes by first moving the ones that were marked as moved by the edit script\n                    if (itemsToMoveFirstIndexes.length) {\n                        while ((i = itemsToMoveFirstIndexes.shift()) != undefined) {\n                            mapData = newMappingResult[i];\n                            for (lastNode = undefined; i; ) {\n                                if ((mappedNodes = newMappingResult[--i].mappedNodes) && mappedNodes.length) {\n                                    lastNode = mappedNodes[mappedNodes.length-1];\n                                    break;\n                                }\n                            }\n                            for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                                ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                            }\n                        }\n                    }\n\n                    // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n                    for (i = 0; mapData = newMappingResult[i]; i++) {\n                        // Get nodes for newly added items\n                        if (!mapData.mappedNodes)\n                            ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n                        // Put nodes in the right place if they aren't there already\n                        for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                            ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                        }\n\n                        // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n                        if (!mapData.initialized && callbackAfterAddingNodes) {\n                            callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                            mapData.initialized = true;\n                            lastNode = mapData.mappedNodes[mapData.mappedNodes.length - 1];     // get the last node again since it may have been changed by a preprocessor\n                        }\n                    }\n\n                    // Restore the focused element if it had lost focus\n                    if (activeElement && domNode.ownerDocument.activeElement != activeElement) {\n                        activeElement.focus();\n                    }\n\n                    // If there's a beforeRemove callback, call it after reordering.\n                    // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n                    // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n                    // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n                    // Perhaps we'll make that change in the future if this scenario becomes more common.\n                    callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n                    // Replace the stored values of deleted items with a dummy value. This provides two benefits: it marks this item\n                    // as already \"removed\" so we won't call beforeRemove for it again, and it ensures that the item won't match up\n                    // with an actual item in the array and appear as \"retained\" or \"moved\".\n                    for (i = 0; i < itemsForBeforeRemoveCallbacks.length; ++i) {\n                        itemsForBeforeRemoveCallbacks[i].arrayEntry = deletedItemDummyValue;\n                    }\n\n                    // Finally call afterMove and afterAdd callbacks\n                    callCallback(options['afterMove'], itemsForMoveCallbacks);\n                    callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n                }\n            })();\n\n            ko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\n            ko.nativeTemplateEngine = function () {\n                this['allowTemplateRewriting'] = false;\n            }\n\n            ko.nativeTemplateEngine.prototype = new ko.templateEngine();\n            ko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\n            ko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n                    templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n                    templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n                if (templateNodes) {\n                    return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n                } else {\n                    var templateText = templateSource['text']();\n                    return ko.utils.parseHtmlFragment(templateText, templateDocument);\n                }\n            };\n\n            ko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\n            ko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\n            ko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n            (function() {\n                ko.jqueryTmplTemplateEngine = function () {\n                    // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n                    // doesn't expose a version number, so we have to infer it.\n                    // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n                    // which KO internally refers to as version \"2\", so older versions are no longer detected.\n                    var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n                        if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                            return 0;\n                        // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n                        try {\n                            if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                                // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                                return 2; // Final version of jquery.tmpl\n                            }\n                        } catch(ex) { /* Apparently not the version we were looking for */ }\n\n                        return 1; // Any older version that we don't support\n                    })();\n\n                    function ensureHasReferencedJQueryTemplates() {\n                        if (jQueryTmplVersion < 2)\n                            throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n                    }\n\n                    function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n                        return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n                    }\n\n                    this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n                        templateDocument = templateDocument || document;\n                        options = options || {};\n                        ensureHasReferencedJQueryTemplates();\n\n                        // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n                        var precompiled = templateSource['data']('precompiled');\n                        if (!precompiled) {\n                            var templateText = templateSource['text']() || \"\";\n                            // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                            templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                            precompiled = jQueryInstance['template'](null, templateText);\n                            templateSource['data']('precompiled', precompiled);\n                        }\n\n                        var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n                        var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n                        var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n                        resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n                        jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n                        return resultNodes;\n                    };\n\n                    this['createJavaScriptEvaluatorBlock'] = function(script) {\n                        return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n                    };\n\n                    this['addTemplate'] = function(templateName, templateMarkup) {\n                        document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n                    };\n\n                    if (jQueryTmplVersion > 0) {\n                        jQueryInstance['tmpl']['tag']['ko_code'] = {\n                            open: \"__.push($1 || '');\"\n                        };\n                        jQueryInstance['tmpl']['tag']['ko_with'] = {\n                            open: \"with($1) {\",\n                            close: \"} \"\n                        };\n                    }\n                };\n\n                ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n                ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n                // Use this one by default *only if jquery.tmpl is referenced*\n                var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n                if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n                    ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n                ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n            })();\n        }));\n    }());\n})();\n","knockoutjs/knockout-repeat.js":"// REPEAT binding for Knockout http://knockoutjs.com/\n// (c) Michael Best\n// License: MIT (http://www.opensource.org/licenses/mit-license.php)\n// Version 2.1.0\n\n(function(factory) {\n    if (typeof define === 'function' && define.amd) {\n        // [1] AMD anonymous module\n        define(['knockout'], factory);\n    } else if (typeof exports === 'object') {\n        // [2] commonJS\n        factory(require('knockout'));\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko);\n    }\n})(function(ko) {\n\nif (!ko.virtualElements)\n    throw Error('Repeat requires at least Knockout 2.1');\n\nvar ko_bindingFlags = ko.bindingFlags || {};\nvar ko_unwrap = ko.utils.unwrapObservable;\n\nvar koProtoName = '__ko_proto__';\n\nif (ko.version >= \"3.0.0\") {\n    // In Knockout 3.0.0, use the node preprocessor to replace a node with a repeat binding with a virtual element\n    var provider = ko.bindingProvider.instance, previousPreprocessFn = provider.preprocessNode;\n    provider.preprocessNode = function(node) {\n        var newNodes, nodeBinding;\n        if (!previousPreprocessFn || !(newNodes = previousPreprocessFn.call(this, node))) {\n            if (node.nodeType === 1 && (nodeBinding = node.getAttribute('data-bind'))) {\n                if (/^\\s*repeat\\s*:/.test(nodeBinding)) {\n                    var leadingComment = node.ownerDocument.createComment('ko ' + nodeBinding),\n                        trailingComment = node.ownerDocument.createComment('/ko');\n                    node.parentNode.insertBefore(leadingComment, node);\n                    node.parentNode.insertBefore(trailingComment, node.nextSibling);\n                    node.removeAttribute('data-bind');\n                    newNodes = [leadingComment, node, trailingComment];\n                }\n            }\n        }\n        return newNodes;\n    };\n}\n\nko.virtualElements.allowedBindings.repeat = true;\nko.bindingHandlers.repeat = {\n    flags: ko_bindingFlags.contentBind | ko_bindingFlags.canUseVirtual,\n    init: function(element, valueAccessor, allBindingsAccessor, xxx, bindingContext) {\n\n        // Read and set fixed options--these options cannot be changed\n        var repeatParam = ko_unwrap(valueAccessor());\n        if (repeatParam && typeof repeatParam == 'object' && !('length' in repeatParam)) {\n            var repeatIndex = repeatParam.index,\n                repeatData = repeatParam.item,\n                repeatStep = repeatParam.step,\n                repeatReversed = repeatParam.reverse,\n                repeatBind = repeatParam.bind,\n                repeatInit = repeatParam.init,\n                repeatUpdate = repeatParam.update;\n        }\n        // Set default values for options that need it\n        repeatIndex = repeatIndex || '$index';\n        repeatData = repeatData || ko.bindingHandlers.repeat.itemName || '$item';\n        repeatStep = repeatStep || 1;\n        repeatReversed = repeatReversed || false;\n\n        var parent = element.parentNode, placeholder;\n        if (element.nodeType == 8) {    // virtual element\n            // Extract the \"children\" and find the single element node\n            var childNodes = ko.utils.arrayFilter(ko.virtualElements.childNodes(element), function(node) { return node.nodeType == 1;});\n            if (childNodes.length !== 1) {\n                throw Error(\"Repeat binding requires a single element to repeat\");\n            }\n            ko.virtualElements.emptyNode(element);\n\n            // The placeholder is the closing comment normally, or the opening comment if reversed\n            placeholder = repeatReversed ? element : element.nextSibling;\n            // The element to repeat is the contained element\n            element = childNodes[0];\n        } else {    // regular element\n            // First clean the element node and remove node's binding\n            var origBindString = element.getAttribute('data-bind');\n            ko.cleanNode(element);\n            element.removeAttribute('data-bind');\n\n            // Original element is no longer needed: delete it and create a placeholder comment\n            placeholder = element.ownerDocument.createComment('ko_repeatplaceholder ' + origBindString);\n            parent.replaceChild(placeholder, element);\n        }\n\n        // extract and remove a data-repeat-bind attribute, if present\n        if (!repeatBind) {\n            repeatBind = element.getAttribute('data-repeat-bind');\n            if (repeatBind) {\n                element.removeAttribute('data-repeat-bind');\n            }\n        }\n\n        // Make a copy of the element node to be copied for each repetition\n        var cleanNode = element.cloneNode(true);\n        if (typeof repeatBind == \"string\") {\n            cleanNode.setAttribute('data-bind', repeatBind);\n            repeatBind = null;\n        }\n\n        // Set up persistent data\n        var lastRepeatCount = 0,\n            notificationObservable = ko.observable(),\n            repeatArray, arrayObservable;\n\n        if (repeatInit) {\n            repeatInit(parent);\n        }\n\n        var subscribable = ko.computed(function() {\n            function makeArrayItemAccessor(index) {\n                var f = function(newValue) {\n                    var item = repeatArray[index];\n                    // Reading the value of the item\n                    if (!arguments.length) {\n                        notificationObservable();   // for dependency tracking\n                        return ko_unwrap(item);\n                    }\n                    // Writing a value to the item\n                    if (ko.isObservable(item)) {\n                        item(newValue);\n                    } else if (arrayObservable && arrayObservable.splice) {\n                        arrayObservable.splice(index, 1, newValue);\n                    } else {\n                        repeatArray[index] = newValue;\n                    }\n                    return this;\n                };\n                // Pretend that our accessor function is an observable\n                f[koProtoName] = ko.observable;\n                return f;\n            }\n\n            function makeBinding(item, index, context) {\n                return repeatArray\n                    ? function() { return repeatBind.call(bindingContext.$data, item, index, context); }\n                    : function() { return repeatBind.call(bindingContext.$data, index, context); }\n            }\n\n            // Read and set up variable options--these options can change and will update the binding\n            var paramObservable = valueAccessor(), repeatParam = ko_unwrap(paramObservable), repeatCount = 0;\n            if (repeatParam && typeof repeatParam == 'object') {\n                if ('length' in repeatParam) {\n                    repeatArray = repeatParam;\n                    repeatCount = repeatArray.length;\n                } else {\n                    if ('foreach' in repeatParam) {\n                        repeatArray = ko_unwrap(paramObservable = repeatParam.foreach);\n                        if (repeatArray && typeof repeatArray == 'object' && 'length' in repeatArray) {\n                            repeatCount = repeatArray.length || 0;\n                        } else {\n                            repeatCount = repeatArray || 0;\n                            repeatArray = null;\n                        }\n                    }\n                    // If a count value is provided (>0), always output that number of items\n                    if ('count' in repeatParam)\n                        repeatCount = ko_unwrap(repeatParam.count) || repeatCount;\n                    // If a limit is provided, don't output more than the limit\n                    if ('limit' in repeatParam)\n                        repeatCount = Math.min(repeatCount, ko_unwrap(repeatParam.limit)) || repeatCount;\n                }\n                arrayObservable = repeatArray && ko.isObservable(paramObservable) ? paramObservable : null;\n            } else {\n                repeatCount = repeatParam || 0;\n            }\n\n            // Remove nodes from end if array is shorter\n            for (; lastRepeatCount > repeatCount; lastRepeatCount-=repeatStep) {\n                ko.removeNode(repeatReversed ? placeholder.nextSibling : placeholder.previousSibling);\n            }\n\n            // Notify existing nodes of change\n            notificationObservable.notifySubscribers();\n\n            // Add nodes to end if array is longer (also initially populates nodes)\n            for (; lastRepeatCount < repeatCount; lastRepeatCount+=repeatStep) {\n                // Clone node and add to document\n                var newNode = cleanNode.cloneNode(true);\n                parent.insertBefore(newNode, repeatReversed ? placeholder.nextSibling : placeholder);\n                newNode.setAttribute('data-repeat-index', lastRepeatCount);\n\n                // Apply bindings to inserted node\n                if (repeatArray && repeatData == '$data') {\n                    var newContext = bindingContext.createChildContext(makeArrayItemAccessor(lastRepeatCount));\n                } else {\n                    var newContext = bindingContext.extend();\n                    if (repeatArray)\n                        newContext[repeatData] = makeArrayItemAccessor(lastRepeatCount);\n                }\n                newContext[repeatIndex] = lastRepeatCount;\n                if (repeatBind) {\n                    var result = ko.applyBindingsToNode(newNode, makeBinding(newContext[repeatData], lastRepeatCount, newContext), newContext, true),\n                        shouldBindDescendants = result && result.shouldBindDescendants;\n                }\n                if (!repeatBind || (result && shouldBindDescendants !== false)) {\n                    ko.applyBindings(newContext, newNode);\n                }\n            }\n            if (repeatUpdate) {\n                repeatUpdate(parent);\n            }\n        }, null, {disposeWhenNodeIsRemoved: placeholder});\n\n        return { controlsDescendantBindings: true, subscribable: subscribable };\n    }\n};\n});"}
}});
