require(['jquery', 'mage/translate', 'Magento_Ui/js/modal/modal'], function ($, $t, modal) {
    $(document).ready(function () {

        $('.custom-header-links li').each(function () {
            var linkText = $(this).find('a').text().trim();
            if (linkText === 'Menu digital') {
                $(this).addClass('active');
            }
        });

        $('.link-create-menu').on('click', function() {
            window.location.href = '/menudigital/index/create';
        });

        $('.link-introduction-menu').on('click', function() {
            window.location.href = '/menudigital/index/introduction/';
        });


        //Tabs header
        $('.tabs .tab').on('click', function() {

            var tabId = $(this).data('tab-id');

            // Validar solo si hacen click en las pestañas que mencionaste
            if (tabId === 'select-categories' || tabId === 'select-products' || tabId === 'select-template' || tabId === 'select-custom' || tabId === 'select-preview' ) {
                var menuId = $('#menu-id').val().trim(); // Tomamos el valor del input y quitamos espacios

                if (menuId === '') {
                    alert('Debes de completar la sección de "Información menú" para continuar.');
                    return false;
                }
            }



            $('.container-block').hide();
            var tabId = $(this).data('tab-id');
            if(tabId == 'select-template'){
                $('.container-template').show();
            }else if(tabId == 'select-custom'){
                $('.container-custom').show();
            }else if(tabId == 'select-preview'){
                $('.container-preview').show();
                reloadPreview();
            }else if(tabId == 'select-create-menu'){
                $('.container-information').show();
            }else if(tabId == 'select-categories'){
                $('.container-categories').show();
                reloadCategories();
                let menuId = $('#menu-id').val();
                if (menuId && menuId.trim() !== '') {
                    $('.wrapper-list-categories').show();
                }
            }else{
                $('.container-products').show();
                $('.contenedor-principal, .template-section').show();
                $('.container-new-product').hide();
                reloadTableProducts();
            }
            $('.tabs .tab').removeClass('active');
            $(this).addClass('active');

        });

        //DASHBOARD
        $(document).on('click', '.menu-options', function (e) {
            e.stopPropagation();
            const $menu = $(this).siblings('.dropdown-menu');
            $('.dropdown-menu').not($menu).hide();
            $menu.toggle();
        });

        $(document).on('click', function () {
            $('.dropdown-menu').hide();
        });

        $('.menu-list').on('click', '.item-show', function () {
            const card = $(this).closest('.menu-card');
            const id = card.data('id');
            window.open('/menudigital/index/view/id/' + id, '_blank');
        });

        $('.menu-list').on('click', '.item-qr', function () {
            const card = $(this).closest('.menu-card');
            const id = card.data('id');
            window.location.href = '/menudigital/index/qr/id/'+id;
        });

        $('.menu-list').on('click', '.item-edit', function () {
            const card = $(this).closest('.menu-card');
            const id = card.data('id');
            window.location.href = '/menudigital/index/menu/id/'+id;
        });

        $('.menu-list').on('click', '.item-delete', function () {
            const card = $(this).closest('.menu-card');
            const id = card.data('id');
            if (!id) return;

            if (!confirm('¿Estás seguro de que deseas eliminar este menú?')) return;

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/deletemenu',
                method: 'POST',
                data: { id },
                success: function (res) {
                    if (res.success) {
                        card.fadeOut(300, () => card.remove());
                    } else {
                        alert(res.message || 'Error al eliminar', false);
                    }
                },
                error: function () {
                    alert('Error de red', false);
                }
            });
        });

        // Inicializar cada modal por clase
        $('.modal-contenido').each(function() {
            var options = {
                type: 'popup',
                responsive: true,
                innerScroll: true,
                title: 'Vista previa',
                buttons: [{
                    text: $.mage.__('Cerrar'),
                    class: 'action-secondary',
                    click: function () {
                        this.closeModal();
                    }
                }]
            };

            modal(options, $(this));
        });

        // Abrir el modal correspondiente al hacer clic
        $('.abrir-modal, .card-actions').on('click', function() {
            var modalId = $(this).data('modal-id');
            $('#' + modalId).modal('openModal');
        });

        //upload image product
        $('#upload-image').on('change', function (event) {
            const file = event.target.files[0];
            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];
            const maxSize = 2 * 1024 * 1024; // 2 MB
            if (!allowedTypes.includes(file.type) || file.size > maxSize) {
                alert("Lo sentimos, solo se permiten imágenes en formato JPG, JPEG y PNG menores a 2 MB");
                return;
            }
            if (!file) return;

            const reader = new FileReader();
            reader.onload = function (e) {
                $('.preview-image').attr('src', e.target.result).show();
                $('.image-upload-placeholder').hide();
                $('.image-upload-placeholder-loaded').show();

            };
            reader.readAsDataURL(file);
        });

        $('#edit-upload-image').on('change', function (event) {
            const file = event.target.files[0];
            if (!file) return;

            const reader = new FileReader();
            reader.onload = function (e) {
                $('.edit-preview-image').attr('src', e.target.result).show();
                $('.edit-image-upload-placeholder').hide();
                $('.edit-image-upload-placeholder-loaded').show();

            };
            reader.readAsDataURL(file);
        });

        $('.remove-image').on('click', function () {
            $('#upload-image').val('');
            $('.preview-image').attr('src', '').hide();
            $('.image-upload-placeholder').show();
            $('.image-upload-placeholder-loaded').hide();

        });

        $('.edit-remove-image').on('click', function () {
            $('#edit-upload-image').val('');
            $('.edit-preview-image').attr('src', '').hide();
            $('.edit-image-upload-placeholder').show();
            $('.edit-image-upload-placeholder-loaded').hide();

        });



        $('.add-image').on('click', function () {
            $('#upload-image').click();
        });

        $('.edit-add-image').on('click', function () {
            $('#edit-upload-image').click();
        });

        $('.menu-actions.cancel').on('click', function() {
            window.location.href = '/menudigital/index/dashboard/';
        });

        //Guardar Información MENU
        $('.container-information .btn-save-info-menu').on('click', function (e) {
            e.preventDefault(); // Evita el envío tradicional del formulario

            var form = $('#menu-form')[0]; // obtenemos el DOM puro del form
            var formData = new FormData(form); // construimos el FormData desde el form

            // Validaciones de campos obligatorios
            var menuName = formData.get('menu_name');
            var menuDesc = formData.get('menu_description');
            var restaurantId = formData.get('restaurant_id');
            var terms = formData.get('terms');
            var status = formData.get('status');


            let camposFaltantes = [];

            if (!menuName) camposFaltantes.push('Nombre');
            if (!restaurantId) camposFaltantes.push('Restaurante');
            if (!menuDesc) camposFaltantes.push('Descripción');
            if (!terms) camposFaltantes.push('Terminos y condiciones');
            if (!status) camposFaltantes.push('Status');

            if (camposFaltantes.length > 0) {
                alert('Por favor, complete los siguientes campos:\n- ' + camposFaltantes.join('\n- '));
                return;
            }

            if (menuName.length > 30) {
                alert('El campo "Nombre" no puede tener más de 30 caracteres.');
                return;
            }

            if (menuDesc.length > 200) {
                alert('El campo "Descripción" no puede tener más de 200 caracteres.');
                return;
            }


            $.ajax({
                url: window.location.origin + '/menudigital/ajax/savemenuinfo',
                type: 'POST',
                showLoader: true,
                data: formData,
                processData: false,
                contentType: false,
                success: function (res) {
                    if (res.success) {
                        alert(res.message);
                        $('#menu-id').val(res.menu_id);

                        $('html, body').animate({
                            scrollTop: $('.tabs').offset().top - 50
                        }, 600, function () {
                            // Aplicar efecto de resaltar al siguiente tab
                            //$('.tab[data-tab-id="select-categories"]').addClass('highlight-tab');

                            // Opcional: removerlo después de un tiempo (ej. 4 parpadeos ≈ 4s)
                            setTimeout(function () {
                                //$('.tab[data-tab-id="select-categories"]').removeClass('highlight-tab');
                            }, 2000);
                        });



                    } else {
                        alert(res.message || 'Ocurrió un error al guardar');
                    }
                },
                error: function () {
                    alert('Error inesperado al guardar el menú');
                }
            });
        });

        function buildSelect(levelData, level = 1, selectedPath = []) {
            const select = $('<select>').attr('data-level', level).addClass('category-level');
            select.addClass('custom-select');
            select.append($('<option>', { value: '', text: '-- Selecciona --' }));

            levelData.forEach(category => {
                select.append($('<option>', {
                    value: category.id,
                    text: category.name,
                    'data-json': JSON.stringify(category)
                }));
            });

            return select;
        }

        function renderNextLevel(selectedOption, level) {
            const selected = $(selectedOption).find(':selected');
            const data = selected.data('json');
            const nextData = data?.children || [];

            $("#category-selects select").each(function () {
                if (parseInt($(this).data('level')) > level) {
                    $(this).closest('.col-select').remove();
                }
            });

            if (nextData.length > 0 && level < 4) {
                const nextSelect = buildSelect(nextData, level + 1);
                const container = $(`
                        <div class="col-select form-group">
                            <label>Subcategorias</label>
                        </div>
                    `);

                container.append(nextSelect);
                $('#category-selects').append(container);
            }
            updateJson();
        }

        function updateJson() {
            const path = {};
            $('#category-selects select').each(function (index) {
                const selected = $(this).find(':selected');
                if (selected.val()) {
                    path['level_' + (index + 1)] = {
                        id: selected.val()
                    };
                }
            });
            $('#categories-json').val(JSON.stringify(path));
        }

        function buildSelectEdit(levelData, level = 1, selectedPath = []) {
            const select = $('<select>').attr('data-level', level).addClass('category-level');
            select.addClass('custom-select');
            select.append($('<option>', { value: '', text: '-- Selecciona --' }));

            levelData.forEach(category => {
                select.append($('<option>', {
                    value: category.id,
                    text: category.name,
                    'data-json': JSON.stringify(category)
                }));
            });

            return select;
        }
        function renderNextLevelEdit(selectedOption, level) {
            const selected = $(selectedOption).find(':selected');
            const data = selected.data('json');
            const nextData = data?.children || [];

            $("#edit-category-selects select").each(function () {
                if (parseInt($(this).data('level')) > level) {
                    $(this).closest('.col-select').remove();
                }
            });

            if (nextData.length > 0 && level < 4) {
                const nextSelect = buildSelect(nextData, level + 1);
                const container = $(`
                        <div class="col-select form-group">
                            <label>Subcategorias</label>
                        </div>
                    `);

                container.append(nextSelect);
                $('#edit-category-selects').append(container);
            }
            updateJsonEdit();
        }

        function updateJsonEdit() {
            const path = {};
            $('#edit-category-selects select').each(function (index) {
                const selected = $(this).find(':selected');
                if (selected.val()) {
                    path['level_' + (index + 1)] = {
                        id: selected.val(),
                        name: selected.text()
                    };
                }
            });
            $('#edit-categories-json').val(JSON.stringify(path));
        }


        /*Ajax Add Product*/
        $('#add-product').on('click', function () {

            let formData = new FormData();
            let nombre = $('#nombre').val();
            let descripcion = $('#descripcion').val();
            let precio = $('#precio').val();
            let destacado = $('input[name="check-product-destacado"]:checked').val();
            let categorias = $('#categories-json').val();
            let imagen = $('#upload-image')[0].files[0];
            let categoriaNivel1 = $('select.category-level[data-level="1"]').val();

            let camposFaltantes = [];

            if (!nombre) camposFaltantes.push('Nombre');
            if (!descripcion) camposFaltantes.push('Descripción');
            if (!categoriaNivel1) camposFaltantes.push('Categoría');
            if (!precio) camposFaltantes.push('Precio');
            if (!destacado) camposFaltantes.push('Producto destacado');
            if (!imagen) camposFaltantes.push('Imagen');

            if (camposFaltantes.length > 0) {
                alert('Por favor, complete los siguientes campos:\n- ' + camposFaltantes.join('\n- '));
                return;
            }

            if (nombre.length > 30) {
                alert('El campo "Nombre" no puede tener más de 30 caracteres.');
                return;
            }

            if (descripcion.length > 200) {
                alert('El campo "Descripción" no puede tener más de 200 caracteres.');
                return;
            }

            if (precio.length > 7) {
                alert('El campo "Precio" no puede tener más de 7 caracteres.');
                return;
            }


            formData.append('nombre', nombre);
            formData.append('descripcion', descripcion);
            formData.append('precio', precio);
            formData.append('destacado', destacado);
            formData.append('categorias', categorias);
            if (imagen) {
                formData.append('imagen', imagen);
            }

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/saveproduct',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                showLoader: true,
                success: function (res) {
                    if (res.success) {
                        reloadTableProducts();
                    } else {
                        alert(res.message || 'Error inesperado');
                    }
                },
                error: function () {
                    alert('Error al procesar el producto');
                }
            });
        });

        $('.container-products').on('click', '.boton-agregar-producto', function () {

            $.ajax({
                url: window.location.origin + '/menudigital/index/create',
                method: 'POST',
                showLoader: true,
                success: function (response) {
                    $('#category-selects .col-select').remove();
                    let tempDiv = $('<div>').html(response);
                    let newContent = tempDiv.find('#data-categories');
                    let categoryData = newContent[0]['attributes']['value']['value'];
                    let parsedData = JSON.parse(categoryData);
                    const firstSelect = buildSelect(parsedData);
                    const container = $(`
                            <div class="col-select form-group">
                                <label>Categorias</label>
                            </div>
                        `);
                    container.append(firstSelect);
                    $('#category-selects').append(container);

                    $('#category-selects').on('change', 'select', function () {
                        const level = parseInt($(this).data('level'));
                        renderNextLevel($(this), level);
                    });
                    $('.container-new-product').show();
                    $('.template-section, .contenedor-principal').hide();
                    limpiarFormularioProducto();

                },
                error: function (xhr, status, error) {
                    console.error('Error al recargar categorías:', error);
                }
            });

        });

        $('#cancel-product').on('click', function () {
            $('.container-new-product').hide();
            $('.template-section, .contenedor-principal').show();
            limpiarFormularioProducto();
        });

        function limpiarFormularioProducto() {
            const $form = $('.container-new-product');
            $form.find('#nombre, #descripcion, #precio').val('');
            $form.find('select.category-level').val('');
            $form.find('#upload-image').val('');
            $form.find('.preview-image').attr('src', '');
            $form.find('.image-upload-placeholder-loaded').hide();
            $form.find('.image-upload-placeholder').show();
        }


        function reloadTableProducts(){
            $.ajax({
                url: window.location.origin + '/menudigital/index/create',
                method: 'POST',
                showLoader: true,
                success: function (response) {
                    // Crea un contenedor temporal para poder manipular el DOM recibido
                    const tempDiv = $('<div>').html(response);

                    // Encuentra el div específico dentro de ese contenido
                    const newContent = tempDiv.find('.product-table');

                    // Reemplaza el contenido en el DOM actual
                    $('.product-table').replaceWith(newContent);
                    $('.container-new-product').hide();
                    $('input[name="check-product-destacado"][value="0"]').prop('checked', true);
                    $('.contenedor-principal, .template-section').show();



                    // Inicializar paginador nuevamente después de reemplazar la tabla
                    (function setupPaginator() {
                        const rowsPerPage = $('#number-paginator').val();
                        const $rows = $('.product-table tbody tr');
                        const totalRows = $rows.length;
                        const totalPages = Math.ceil(totalRows / rowsPerPage);
                        let currentPage = 1;

                        function showPage(page) {
                            if (page < 1 || page > totalPages) return;
                            currentPage = page;
                            $rows.hide();
                            const start = (page - 1) * rowsPerPage;
                            const end = start + rowsPerPage;
                            $rows.slice(start, end).show();

                            renderPagination();
                        }

                        function createPageElement(label, page, isActive = false, isEllipsis = false) {
                            const $el = $('<div class="paginator-number"></div>');
                            $el.text(label);

                            if (isEllipsis) {
                                $el.addClass('ellipsis');
                                return $el;
                            }

                            if (isActive) $el.addClass('active');

                            $el.attr('data-page', page);
                            $el.on('click', () => showPage(page));

                            return $el;
                        }

                        function renderPagination() {
                            let $pagination = $('.paginator-container');
                            if ($pagination.length === 0) {
                                $pagination = $('<div class="paginator-container"></div>');
                                let $paginatorWrapper = `
                                <div class="paginator-select-wrapper">
                                  <div class="paginator-select-container">
                                    <select id="paginator-select" class="paginator-select">
                                      <option value="10">Productos por página: 10</option>
                                      <option value="20">Productos por página: 20</option>
                                      <option value="30">Productos por página: 30</option>
                                      <option value="40">Productos por página: 40</option>
                                      <option value="50">Productos por página: 50</option>
                                      <option value="60">Productos por página: 60</option>
                                    </select>
                                    <div class="paginator-arrow"></div>
                                  </div>
                                </div>
                                `;
                                $('.wrapper-paginator').append($pagination);
                                $('.wrapper-paginator').append($paginatorWrapper);
                            }
                            $pagination.empty();

                            const $prev = $('<div class="paginator-nav-left"></div>').on('click', () => showPage(currentPage - 1));
                            const $next = $('<div class="paginator-nav-right"></div>').on('click', () => showPage(currentPage + 1));
                            $pagination.append($prev);

                            if (totalPages <= 7) {
                                for (let i = 1; i <= totalPages; i++) {
                                    $pagination.append(createPageElement(i, i, i === currentPage));
                                }
                            } else {
                                $pagination.append(createPageElement(1, 1, currentPage === 1));

                                if (currentPage > 4) $pagination.append(createPageElement('...', null, false, true));

                                const start = Math.max(2, currentPage - 2);
                                const end = Math.min(totalPages - 1, currentPage + 2);
                                for (let i = start; i <= end; i++) {
                                    $pagination.append(createPageElement(i, i, i === currentPage));
                                }

                                if (currentPage < totalPages - 3) $pagination.append(createPageElement('...', null, false, true));

                                $pagination.append(createPageElement(totalPages, totalPages, currentPage === totalPages));
                            }

                            $pagination.append($next);
                        }

                        renderPagination();
                        showPage(1);
                    })();

                },
                error: function (xhr, status, error) {
                    console.error('Error al recargar categorías:', error);
                }
            });
        };

        $(document).on('change', '#paginator-select', function () {
            var valorSeleccionado = $(this).val();
            $('#number-paginator').val(valorSeleccionado);
            (function setupPaginator() {
                const rowsPerPage = $('#number-paginator').val();
                const $rows = $('.product-table tbody tr');
                const totalRows = $rows.length;
                const totalPages = Math.ceil(totalRows / rowsPerPage);
                let currentPage = 1;

                function showPage(page) {
                    if (page < 1 || page > totalPages) return;
                    currentPage = page;
                    $rows.hide();
                    const start = (page - 1) * rowsPerPage;
                    const end = start + rowsPerPage;
                    $rows.slice(start, end).show();

                    renderPagination();
                }

                function createPageElement(label, page, isActive = false, isEllipsis = false) {
                    const $el = $('<div class="paginator-number"></div>');
                    $el.text(label);

                    if (isEllipsis) {
                        $el.addClass('ellipsis');
                        return $el;
                    }

                    if (isActive) $el.addClass('active');

                    $el.attr('data-page', page);
                    $el.on('click', () => showPage(page));

                    return $el;
                }

                function renderPagination() {
                    let $pagination = $('.paginator-container');
                    if ($pagination.length === 0) {
                        $pagination = $('<div class="paginator-container"></div>');
                        let $paginatorWrapper = `
                                <div class="paginator-select-wrapper">
                                  <div class="paginator-select-container">
                                    <select id="paginator-select" class="paginator-select">
                                      <option value="10">Productos por página: 10</option>
                                      <option value="20">Productos por página: 20</option>
                                      <option value="30">Productos por página: 30</option>
                                      <option value="40">Productos por página: 40</option>
                                      <option value="50">Productos por página: 50</option>
                                      <option value="60">Productos por página: 60</option>
                                    </select>
                                    <div class="paginator-arrow"></div>
                                  </div>
                                </div>
                                `;
                        $('.wrapper-paginator').append($pagination);
                        $('.wrapper-paginator').append($paginatorWrapper);
                    }
                    $pagination.empty();

                    const $prev = $('<div class="paginator-nav-left"></div>').on('click', () => showPage(currentPage - 1));
                    const $next = $('<div class="paginator-nav-right"></div>').on('click', () => showPage(currentPage + 1));
                    $pagination.append($prev);

                    if (totalPages <= 7) {
                        for (let i = 1; i <= totalPages; i++) {
                            $pagination.append(createPageElement(i, i, i === currentPage));
                        }
                    } else {
                        $pagination.append(createPageElement(1, 1, currentPage === 1));

                        if (currentPage > 4) $pagination.append(createPageElement('...', null, false, true));

                        const start = Math.max(2, currentPage - 2);
                        const end = Math.min(totalPages - 1, currentPage + 2);
                        for (let i = start; i <= end; i++) {
                            $pagination.append(createPageElement(i, i, i === currentPage));
                        }

                        if (currentPage < totalPages - 3) $pagination.append(createPageElement('...', null, false, true));

                        $pagination.append(createPageElement(totalPages, totalPages, currentPage === totalPages));
                    }

                    $pagination.append($next);
                }

                renderPagination();
                showPage(1);
            })();
        });

        /*INFORMACION DEL MENU - BOTONES ACTIONS*/
        $('.menu-option').on('click', function () {
            // Desactivar todos
            $('.menu-option').removeClass('active');

            // Activar el clicado
            $(this).addClass('active');

            // Seleccionar el radio correspondiente
            $(this).find('input[type="radio"]').prop('checked', true);
        });

        /* CATEGORIAS */
        function getGroup(level, namePrefix) {
            return `
            <div class="category-group level-${level}" data-level="${level}">
                <div class="form-group">
                    <input type="text" class="input-text" name="${namePrefix}[name]" placeholder="Categoría nivel ${level}" required />
                    ${level < 4 ? '<div class="btn-agregar-subcategoria add-sub" data-icono="true" data-property-1="Positivo" data-texto="true"><div class="icon-add" data-icons="icon-add"></div><div class="btn-text">Agregar subcategoría</div></div>' : ''}
                    <div class="btn-agregar-subcategoria-cancel delete-sub" data-icono="true" data-property-1="Positivo" data-texto="true">
                        <div class="icon-delete" data-icons="icon-delete"></div>
                        <div class="btn-text">Eliminar</div>
                    </div>
                </div>
                <div class="subcategories"></div>
            </div>
        `;
        }

        $('#categories-wrapper').on('click', '.add-sub', function () {
            const parentGroup = $(this).closest('.category-group');
            const level = parseInt(parentGroup.data('level'), 10);
            if (level >= 4) return;

            const parentName = parentGroup.find('input').attr('name');
            const childCount = parentGroup.find('> .subcategories > .category-group').length;
            const namePrefix = parentName.replace(/\[name\]$/, '') + '[children][' + childCount + ']';

            const subGroup = $(getGroup(level + 1, namePrefix));
            parentGroup.find('> .subcategories').append(subGroup);

            subGroup.find('input').focus();
        });

        $('#categories-wrapper').on('click', '.delete-sub', function () {
            const currentGroup = $(this).closest('.category-group');
            currentGroup.remove();
        });

        $('#categories-wrapper').on('click', '.btn-edit', function (e) {
            e.stopPropagation();
            const $categoryCard = $(this).closest('.category-card');
            $categoryCard.find('.edit-form').first().slideToggle();
        });

        $('#categories-wrapper').on('click', '.btn-add-sub', function (e) {
            e.stopPropagation();
            const $categoryCard = $(this).closest('.category-card');
            $categoryCard.find('.add-sub-form').first().slideToggle();
        });

        $('#categories-wrapper').on('click', '.edit-save', function (e) {

            let hayError = false;

            // Limpiar errores previos
            $('.wrapper-list-categories .edit-input').removeClass('campo-error-edit');
            $('.wrapper-list-categories .mensaje-error-edit').remove();

            $('.wrapper-list-categories .edit-input').each(function () {
                const valor = $(this).val().trim();
                const maxCaracteres = 30;

                if (valor.length > maxCaracteres) {
                    hayError = true;
                    $(this).addClass('campo-error-edit');
                    $(this).after('<div class="mensaje-error-edit">Máximo 30 caracteres permitidos.</div>');
                }
            });

            if (hayError) {
                // Opcional: hacer scroll al primer error
                $('html, body').animate({
                    scrollTop: $('.campo-error-edit').first().offset().top - 100
                }, 500);
                return;
            }

            const id = $(this).data('id');
            const container = $('[data-id="' + id + '"]');
            const name = container.find('.edit-input').val();

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/savecategory',
                type: 'POST',
                showLoader: true,
                data: { id: id, name: name },
                success: function (res) {
                    if (res.success) {
                        alert('Actualizado correctamente');
                        reloadCategories();
                    } else {
                        alert(res.message);
                    }
                },
                error: function () {
                    alert('Error inesperado');
                }
            });
        });

        $('#categories-wrapper').on('click', '.accordion-toggle', function (e) {
            if (!$(e.target).hasClass('btn-edit')) {
             //   $(this).siblings('.sub-list').slideToggle();
            }
            if (!$(e.target).closest('.btn-edit, .btn-delete').length) {
                const $toggle = $(this);
                const $arrow = $toggle.find('.toggle-arrow-categories');

                $toggle.siblings('.sub-list').slideToggle();
                $arrow.toggleClass('rotated');
            }
        });

        $(document).on('click', '.edit-save-sub-cat', function () {
            const parentId = $(this).data('parent-id');
            const level = $(this).data('level');
            const input = $('.add-sub-form[data-parent-id="' + parentId + '"]').find('.new-subcategory-input');
            const name = input.val().trim();
            const menuId = $('#menu-id').val();

            if (!name) {
                alert('El nombre no puede estar vacío');
                return;
            }

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/editcategories',
                type: 'POST',
                data: {
                    parent_id: parentId,
                    name: name,
                    level: level,
                    menu_id: menuId
                },
                success: function () {
                    reloadCategories();
                },
                error: function () {
                    alert('Ocurrió un error al guardar la subcategoría');
                }
            });
        });


        $('#categories-wrapper').on('click', '.btn-delete', function (e) {
            const id = $(this).data('id');
            if (confirm('¿Estás seguro que deseas eliminar esta categoría?')) {
                $.ajax({
                    url: window.location.origin + '/menudigital/ajax/deletecategory',
                    type: 'POST',
                    showLoader: true,
                    data: { id: id },
                    success: function (res) {
                        if (res.success) {
                            reloadCategories();
                        } else {
                            alert(res.message || 'No se pudo eliminar');
                        }
                    },
                    error: function () {
                        alert('Error inesperado al eliminar');
                    }
                });
            }
        });

        $(document).on('submit', '#category-form', function (e) {
            e.preventDefault();
        });

        $('#categories-wrapper').on('click', '.btn-save-categories', function (e) {
            e.preventDefault();

            let hayError = false;

            // Limpiar errores previos
            $('#category-form .input-text').removeClass('campo-error');
            $('#category-form .mensaje-error').remove();

            $('#category-form .input-text').each(function () {
                const valor = $(this).val().trim();
                const maxCaracteres = 30;

                if (valor.length > maxCaracteres) {
                    hayError = true;
                    $(this).addClass('campo-error');
                    $(this).after('<div class="mensaje-error">Máximo 30 caracteres permitidos.</div>');
                }
            });

            if (hayError) {
                // Opcional: hacer scroll al primer error
                $('html, body').animate({
                    scrollTop: $('.campo-error').first().offset().top - 100
                }, 500);
                return;
            }

            let menuId = $('#menu-id').val();
            $('#category-form').append('<input type="hidden" value="'+menuId+'" name="menu_id">');
            var form = $('#category-form')[0];
            var formData = new FormData(form);

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/savecategories',
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                showLoader: true,
                success: function (response) {
                    if (response.success) {
                        reloadCategories();
                    } else {
                        console.warn('Hubo un problema al guardar:', response.message || response);
                    }
                },
                error: function (xhr, status, error) {
                    console.error('Error en el guardado AJAX:', error);
                }
            });
        });

        function reloadCategories(){
            $.ajax({
                url: window.location.origin + '/menudigital/index/categories',
                method: 'POST',
                showLoader: true,
                success: function (response) {
                    // Crea un contenedor temporal para poder manipular el DOM recibido
                    const tempDiv = $('<div>').html(response);

                    // Encuentra el div específico dentro de ese contenido
                    const newContent = tempDiv.find('.container-categories.container-block');

                    // Reemplaza el contenido en el DOM actual
                    $('.container-categories.container-block').replaceWith(newContent);
                    $('.container-categories.container-block').show();
                    $('.wrapper-list-categories').show();
                },
                error: function (xhr, status, error) {
                    console.error('Error al recargar categorías:', error);
                }
            });
        };

        $(document).on('click', '.category-card .edit-cancel', function () {
            var $categoryCard = $(this).closest('.category-card');
            var $btnEdit = $categoryCard.find('.btn-edit').first();
            $btnEdit.trigger('click');
        });

        $(document).on('click', '.category-card .edit-cancel-sub-cat', function () {
            var $categoryCard = $(this).closest('.category-card');
            var $btnEdit = $categoryCard.find('.btn-add-sub').first();
            $btnEdit.trigger('click');
        });


        /*ELIMNAR PRODUCTOS DEL GRID*/
        $(document).on('click', '.action-delete', function (e) {
            e.preventDefault();

            const row = $(this).closest('tr');
            const productId = row.data('id') || row.find('[data-id]').data('id');

            if (!productId) {
                alert('ID de producto no encontrado.');
                return;
            }

            if (!confirm('¿Estás seguro que deseas eliminar este producto?')) {
                return;
            }

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/deleteproduct',
                type: 'POST',
                showLoader: true,
                data: { id: productId },
                success: function (res) {
                    if (res.success) {
                        row.fadeOut(300, function () { $(this).remove(); });
                    } else {
                        alert(res.message || 'Error al eliminar.');
                    }
                },
                error: function () {
                    alert('Error de conexión al eliminar producto.');
                }
            });
        });

        /* Editar productos creados */
        $(document).on('click', '.action-edit', function (e) {
            e.preventDefault();
            const row = $(this).closest('tr');
            console.log(row.find('td'));
            const id = row.data('id');
            const name = row.find('td').eq(2).text().trim();
            const desc = row.find('td').eq(3).text().trim();
            const priceText = row.find('td').eq(4).text().trim();
            const price = priceText.replace(/\$/g, '');
            const recommended = row.find('td').eq(5).text().trim() === 'Sí' ? '1' : '0';
            const imageUrl = row.find('img.product-thumb').attr('src');
            const categoryJson = JSON.parse(row.attr('data-json') || '{}');

            $('#edit-id').val(id);
            $('#edit-nombre').val(name);
            $('#edit-descripcion').val(desc);
            $('#edit-precio').val(price);
            $("#edit-destacado-si").prop("checked", recommended === '1');
            $("#edit-destacado-no").prop("checked", recommended === '0');

            if (imageUrl) {
                $('.edit-preview-image').attr('src', imageUrl);
                $('.edit-image-upload-placeholder').hide();
                $('.edit-image-upload-placeholder-loaded').show();
            }

            $('#edit-category-selects .col-select').remove();

            $.ajax({
                url: window.location.origin + '/menudigital/index/create',
                method: 'POST',
                showLoader: true,
                success: function (response) {
                    $('#edit-category-selects .col-select').remove();
                    let tempDiv = $('<div>').html(response);
                    let newContent = tempDiv.find('#data-categories');
                    let categoryData = newContent[0]['attributes']['value']['value'];
                    let parsedData = JSON.parse(categoryData);
                    const firstSelect = buildSelectEdit(parsedData);
                    const container = $(`
                            <div class="col-select form-group">
                                <label>Categorias</label>
                            </div>
                        `);
                    container.append(firstSelect);
                    $('#edit-category-selects').append(container);

                    $('#edit-category-selects').on('change', 'select', function () {
                        const level = parseInt($(this).data('level'));
                        renderNextLevelEdit($(this), level);
                    });
                    $('.container-edit-product').show();
                    $('.template-section, .contenedor-principal').hide();
                    limpiarFormularioProducto();
                    simulateSelectCascade(categoryJson);
                },
                error: function (xhr, status, error) {
                    console.error('Error al recargar categorías:', error);
                }
            });

            $('.container-new-product').hide();
            $('.container-edit-product').show();
        });

        function simulateSelectCascade(categoryJson) {
            const levels = ["level_1", "level_2", "level_3", "level_4"];

            levels.forEach(function (level, index) {
                setTimeout(function () {
                    const data = categoryJson[level];
                    if (data && data.id) {
                        const select = $('#edit-category-selects select[data-level="' + (index + 1) + '"]');
                        if (select.length) {
                            select.val(data.id).trigger('change');
                        }
                    }
                }, index * 300);
            });
        }

        $('#cancel-edit-product').on('click', function () {
            $('.container-edit-product').hide();
            $('.template-section, .contenedor-principal').show();
        });

        $('#save-edit-product').on('click', function () {
            const formData = new FormData();
            formData.append('id', $('#edit-id').val());
            formData.append('name', $('#edit-nombre').val());
            formData.append('description', $('#edit-descripcion').val());
            formData.append('price', $('#edit-precio').val());
            formData.append('recommended', $('input[name="edit-check-product-destacado"]:checked').val());
            formData.append('categories', $('#edit-categories-json').val());

            const imageFile = $('#edit-upload-image')[0].files[0];
            if (imageFile) {
                formData.append('image', imageFile);
            }

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/editproduct',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                showLoader: true,
                success: function (res) {
                    if (res.success) {
                        $('.container-new-product, .container-edit-product').hide();
                        $('.template-section, .contenedor-principal').show();
                        reloadTableProducts();
                    } else {
                        alert(res.message || 'Hubo un error al actualizar');
                    }
                },
                error: function () {
                    alert('Error inesperado');
                }
            });
        });

        /* Personalización */
        $(document).on('click', '.custom-content-color-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-color').toggleClass('rotated');
            $wrapper.find('.custom-content-color').slideToggle();
        });

        $(document).on('click', '.custom-content-typography-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-typography').toggleClass('rotated');
            $wrapper.find('.custom-content-typography').slideToggle();
        });

        $(document).on('click', '.custom-content-image-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-image').toggleClass('rotated');
            $wrapper.find('.custom-content-image').slideToggle();
        });

        /* Templates */

        const selectedValue = $('input[name="check-template"]:checked').val();
        $('.get-check-template-saved').val(selectedValue);

        $('.menu-actions-options-template .template-cancel').on('click', function() {
            $('input[name="check-template"]').prop('checked', false);
            const savedValue = $('.get-check-template-saved').val();
            $('input[name="check-template"][value="' + savedValue + '"]').prop('checked', true);
        });

        $('.menu-actions-options-template .template-save').on('click', function() {

            var formData = new FormData();
            const menuId = $('#menu-id').val();

            formData.append('menu_id', menuId);
            formData.append('template', $('input[name="check-template"]:checked').val());
            $('.get-check-template-saved').val($('input[name="check-template"]:checked').val());
            $.ajax({
                url: window.location.origin + '/menudigital/ajax/savetemplate',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                showLoader: true,
                success: function (res) {
                    if (res.success) {
                        alert(res.message || 'Plantilla guardada correctamente.');
                    } else {
                        alert(res.message || 'Error al guardar el la plantilla.');
                    }
                },
                error: function () {
                    alert('Error inesperado al guardar QR.');
                }
            });

        });

        /* Personalización */

        document.querySelectorAll('.color-picker').forEach(function(colorPicker) {
            colorPicker.addEventListener('input', function() {
                const selectedColor = this.value;


                const card = this.closest('.color-card');


                const colorCode = card.querySelector('.color-code');
                colorCode.value = selectedColor;

                this.style.backgroundColor = selectedColor;
            });
        });

        $('.color-refresh-icon').on('click', function () {
            const newColor = $(this).data('color-id');
            const parentCard = $(this).closest('.color-card');
            const colorInput = parentCard.find('.color-picker');
            const colorDiv = parentCard.find('.color-code');
            colorInput.val(newColor).trigger('input');
            colorDiv.val(newColor);
        });


        $(document).on('click', '.custom-icon-visibility', function () {
            let $div = $('.custom-image-upload-placeholder-head-loaded');
            if ($div.find('img').length > 0) {
                $('.custom-image-upload-placeholder-head-loaded').slideToggle();
            } else {
                $('.custom-image-upload-placeholder-head').slideToggle();
            }
        });

        $('.banner-button-upload').on('click', function () {
            $('#custom-banner-upload').trigger('click');
        });

        $('#custom-banner-upload').on('change', function (event) {
            const file = event.target.files[0];
            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];
            const maxSize = 2 * 1024 * 1024; // 2MB
            if (!allowedTypes.includes(file.type) || file.size > maxSize) {
                alert("Lo sentimos, solo se permiten imágenes en formato JPG, JPEG y PNG menores a 2 MB");
                return;
            }

            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();

                reader.onload = function (e) {
                    $('.custom-image-upload-placeholder-head').hide();
                    $('.custom-image-upload-placeholder-head-loaded').show();
                    $('.custom-img-banner').remove();
                    $('.custom-image-upload-placeholder-head-loaded').append(`
                      <img class="custom-img-banner" src="${e.target.result}" alt="Vista previa"/>
                    `);
                };

                reader.readAsDataURL(file);
            } else {
                alert('Por favor selecciona una imagen válida.');
            }
        });

        $('.banner-button-delete').on('click', function () {
            let $div = $('.custom-image-upload-placeholder-head-loaded');
            if ($div.find('img').length > 0) {
                $('.custom-image-upload-placeholder-head-loaded').find('img').remove();
                $('.custom-image-upload-placeholder-head-loaded').slideToggle();
            }
        });


        $('.logo-button-upload').on('click', function () {
            $('#custom-logo-upload').trigger('click');
        });

        $('#custom-logo-upload').on('change', function (event) {
            const file = event.target.files[0];
            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];
            const maxSize = 2 * 1024 * 1024; // 2MB
            if (!allowedTypes.includes(file.type) || file.size > maxSize) {
                alert("Lo sentimos, solo se permiten imágenes en formato JPG, JPEG y PNG menores a 2 MB");
                return;
            }

            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();

                reader.onload = function (e) {
                    $('.custom-image-upload-placeholder-head').hide();
                    $('.custom-image-upload-placeholder-head-loaded').show();
                    $('.custom-img-logo').remove();
                    $('.custom-image-upload-placeholder-loaded').append(`
                      <img class="custom-img-logo" src="${e.target.result}" alt="Vista previa"/>
                    `);
                };

                reader.readAsDataURL(file);
            } else {
                alert('Por favor selecciona una imagen válida.');
            }
        });

        $('.logo-button-delete').on('click', function () {
            $('.custom-img-logo').remove();
        });

        function getColorSettingsJson() {
            const colorSettings = {
                principal: $('.color-principal').val(),
                texto_principal: $('.color-texto-principal').val(),
                secundario: $('.color-secundario').val(),
                texto_secundario: $('.color-texto-secundario').val(),
                fondo: $('.color-fondo').val(),
                resalto: $('.color-resalto').val()
            };

            return JSON.stringify(colorSettings);
        }

        $('.codeInputColor').on('input', function () {
            const hex = $(this).val().trim();

            // Validar si es un código hexadecimal válido (como #fff o #ffffff)
            const isValidHex = /^#([0-9A-Fa-f]{3}){1,2}$/.test(hex);

            if (isValidHex) {
                const colorCard = $(this).closest('.color-card');
                const colorPicker = colorCard.find('.color-picker');
                colorPicker.val(hex);
                colorPicker.css('background-color', hex);
            }
        });

        function getFontsSettingsJson() {
            const titleFontValue = $('input[name="check-font-title"]:checked').val();
            const bodyFontValue = $('input[name="check-font-body"]:checked').val();

            const fontsSettings = {
                title_font: titleFontValue,
                body_font: bodyFontValue
            };

            return JSON.stringify(fontsSettings);
        }


        $('.custom-option-save').on('click', function () {
            const bannerFile = $('#custom-banner-upload')[0].files[0];
            const bannerImg = $('.custom-img-banner').length;

            if (!bannerFile && !bannerImg) {
                alert('Debes seleccionar una imagen para el banner antes de guardar.');
                return;
            }

            const formData = new FormData();
            formData.append('menu_id', $('#menu-id').val());
            formData.append('color_settings', getColorSettingsJson());
            formData.append('fonts_settings', getFontsSettingsJson());

            const logoFile = $('#custom-logo-upload')[0].files[0];

            if (bannerFile) {
                formData.append('banner_header', bannerFile);
            }

            if (logoFile) {
                formData.append('logo_header', logoFile);
            }

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/savecustomization',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function (res) {
                    if (res.success) {
                        alert('¡Guardado exitosamente!');
                    } else {
                        alert('Error: ' + res.message);
                    }
                }
            });
        });

        $('.info-text-color, .info-icon-color').on('click', function () {
            let color_type = $(this).data('color-type');
            let color_desc = $(this).data('color-desc');
            let video_url = $('#path_video').val()+"/"+$(this).data('video-url');
            loadVideo(video_url);

            $('.customization-color-badge-text').html(color_type);
            $('.customization-color-description').html(color_desc);
            $('.customization-color-modal-overlay').fadeIn();
        });

        $('.customization-color-modal-overlay').on('click', function (e) {
            if ($(e.target).is('.customization-color-modal-overlay')) {
                $(this).fadeOut();
            }
        });

        $('.customization-color-title, .customization-color-icon-box').on('click', function (e) {
            $('.customization-color-modal-overlay').fadeOut();
        });

        function loadVideo(videoUrl) {
            const videoHtml = `
                <video width="100%" height="auto" controls autoplay>
                    <source src="${videoUrl}" type="video/mp4">
                    Tu navegador no soporta el video.
                </video>
            `;
            $('.customization-color-preview-box').html(videoHtml);
        }


        /* QR FORM */
        $('.btn-save-qr').on('click', function (e) {
            e.preventDefault();

            var formData = new FormData();
            const menuId = $('#qr-menu-id').val();

            formData.append('menu_id', menuId);
            formData.append('qr_title', $('input[name="qr_title"]').val());
            formData.append('qr_description', $('input[name="qr_description"]').val());

            var logoSelected = $('input[name="qr_add_logo"]:checked').val();
            formData.append('qr_add_logo', logoSelected ? logoSelected : '0');

            var imageInput = $('#upload-image')[0];
            if (imageInput && imageInput.files.length > 0) {
                formData.append('qr_image', imageInput.files[0]);
            }

            $.ajax({
                url: window.location.origin + '/menudigital/ajax/saveqr',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                showLoader: true,
                success: function (res) {
                    if (res.success) {
                        reloadQrContent(menuId);
                        alert(res.message || 'QR guardado correctamente.');
                    } else {
                        alert(res.message || 'Error al guardar el QR.');
                    }
                },
                error: function () {
                    alert('Error inesperado al guardar QR.');
                }
            });
        });

        function reloadQrContent(id){
            $.ajax({
                url: window.location.origin + '/menudigital/index/qr/id/'+id,
                method: 'POST',
                showLoader: true,
                success: function (response) {
                    const tempDiv = $('<div>').html(response);
                    const newContent = tempDiv.find('.qr-menu-container');
                    $('.qr-menu-container').replaceWith(newContent);
                    $('html, body').animate({ scrollTop: 0 }, 'slow');
                },
                error: function (xhr, status, error) {
                    console.error('Error al recargar contenido del QR:', error);
                }
            });
        };

        /* PREVIEW */

        let path = [];

        function reloadPreview(){
            $.ajax({
                url: window.location.origin + '/menudigital/index/preview',
                method: 'POST',
                showLoader: true,
                success: function (response) {
                    // Crea un contenedor temporal para poder manipular el DOM recibido
                    const tempDiv = $('<div>').html(response);

                    // Encuentra el div específico dentro de ese contenido
                    const newContent = tempDiv.find('.container-preview.container-block');

                    // Reemplaza el contenido en el DOM actual
                    $('.container-preview.container-block').replaceWith(newContent);
                    $('.container-preview.container-block').show();
                    renderCurrentLevel();

                    if (window.location.pathname.includes('/menudigital/index/view')) {
                        if( $('#is_menu_enable').val() === '0' ){
                            $('.container-preview').hide();
                            $('.content-menu-disabled').show();
                        }
                    }

                },
                error: function (xhr, status, error) {
                    console.error('Error al recargar categorías:', error);
                }
            });
        };

        $(document).on('click', '.menu-complete-button', function () {
            renderCurrentLevel();
            $('#back-button-text').html(`<strong>Menú Completo</strong>`);
            $('.menu-complete-button, .preview-recommendations').hide();
            $('#category-container, #back-button-container').show();
        });

        $(document).on('click', '.category-button', function () {
            const key = $(this).data('name');
            if(key === 'menu_complete'){
                return;
            }
            path.push(key);
            renderCurrentLevel();
        });

        $(document).on('click', '#back-button-container', function () {
            let level = $('#back-button-text').attr('data-level');
            if(level === 'start'){
                $('#category-container, #back-button-container').hide();
                $('.menu-complete-button, .preview-recommendations').show();
            }
            path.pop();
            renderCurrentLevel();
        });

        function renderCurrentLevel() {
            let fullTree = JSON.parse($('#getCategoryTree').val());
            let $container = $('#category-container');
            $container.empty();

            let branch = fullTree;
            for (const level of path) {
                if (branch && typeof branch === 'object') {
                    branch = branch[level];
                }
            }

            const subcategories = [];
            const products = [];

            if (branch && typeof branch === 'object') {
                for (const key in branch) {
                    const value = branch[key];

                    // Si es un producto individual (como "0")
                    if (typeof value === 'object' && value.hasOwnProperty('item_id')) {
                        products.push(value);
                    }
                    // Si es un array de productos
                    else if (Array.isArray(value) && value.length > 0 && value[0].hasOwnProperty('item_id')) {
                        // Guardar el nombre del array como subcategoría
                        subcategories.push(key);
                    }
                    // Si es un objeto que puede contener más subcategorías o productos
                    else if (typeof value === 'object') {
                        subcategories.push(key);
                    }
                }
            }

            // Mostrar subcategorías primero
            const titleFont = $('#menu_title_font').val();
            const bodyFont = $('#menu_body_font').val();
            const fondoPrincipal = $('#menu_fondo_principal').val();
            const fondoSecundario = $('#menu_fondo_secundario').val();
            const textoPrincipal = $('#menu_texto_principal').val();
            const textoSecundario = $('#menu_texto_secundario').val();
            const path_media = $('#path_image').val();
            const resalto = $('#menu_resalto').val();
            const borderRadius = $('#get_border_radius').val();
            subcategories.forEach(key => {
                const $btn = $(`
                    <div class="category-button" style="background:${fondoSecundario}; border-radius: ${borderRadius}" data-name="${key}"><span style="color:${textoSecundario};font-family: '${titleFont}', sans-serif">${key}</span></div>
                `);
                $container.append($btn);
            });

            // Mostrar productos directamente en este nivel
            const template = $('#get_template').val();
            if(template === 'round_style'){
                $container.css('width','400px');
                products.forEach(product => {
                    const maxChars = 136;
                    let description = product.description || '';
                    let shortDescription = description.length > maxChars
                        ? description.substring(0, maxChars) + ' ...'
                        : description;
                    const badge = product.recommended === '1' ? `<span class="list-preview-badge" style="color:${textoPrincipal};font-family: '${titleFont}', sans-serif; background: ${resalto}">Producto Destacado</span>` : '';
                    const $card = $(`
                    <div class="list-preview-wrapper"
                            data-name="${product.name}"
                            data-price="${product.price}"
                            data-description="${shortDescription}"
                            data-image="${product.image}"
                            data-recommended="${product.recommended}">
                        <div class="list-preview-container list-preview-container_round_style" style="background:${fondoPrincipal}">
                            ${badge}
                            <img class="list-preview-img" src="${path_media+product.image}" alt="${product.name}" />
                            <div class="list-preview-content">
                                <h3 class="list-preview-title" style="color: ${textoPrincipal};font-family: '${titleFont}', sans-serif">${product.name}</h3>
                                <p class="list-preview-description" style="color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif">${shortDescription}</p>
                                <div class="list-preview-price">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>
                            </div>
                        </div>
                    </div>
                `);
                    $container.append($card);
                });
            }else if(template === 'vertical_round_style'){
                let groupContainer = null;
                let badge = '';
                products.forEach((product, index) => {
                    const maxChars = 136;
                    let description = product.description || '';
                    let shortDescription = description.length > maxChars
                        ? description.substring(0, maxChars) + ' ...'
                        : description;
                    // Crear un nuevo grupo cada 2 elementos
                    if (index % 2 === 0) {
                        groupContainer = $('<div class="vertical_round_style-container"></div>');
                        $container.append(groupContainer); // $container es tu contenedor principal
                    }


                    if(product.recommended === '1'){
                        badge = `<div class="vertical_round_style-badge-wrapper" style="background:${resalto}">
                                    <div class="vertical_round_style-detail-product-badge-icon">
                                        <svg width="15" height="16" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g id="Star">
                                                <g id="Group">
                                                    <path id="Vector" d="M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z" fill="${textoPrincipal}"/>
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="vertical_round_style-badge" style="color: ${textoPrincipal};font-family: '${titleFont}', sans-serif">Producto Destacado</div>
                                </div>`;
                    }else{
                        badge = '';
                    }

                    const $card = $(`
                        <div class="vertical_round_style-card"
                                data-name="${product.name}"
                                data-price="${product.price}"
                                data-description="${shortDescription}"
                                data-image="${product.image}"
                                data-recommended="${product.recommended}" style="background: ${fondoPrincipal}">
                            <div class="vertical_round_style-image"><img src="${path_media+product.image}" /></div>
                            ${badge}
                            <h3 class="vertical_round_style-title" style="color: ${textoPrincipal};font-family: '${titleFont}', sans-serif">${product.name}</h3>
                            <p class="vertical_round_style-description" style="color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif">${shortDescription}</p>
                            <div class="vertical_round_style-price" style="background: ${fondoSecundario};color:${titleFont};font-family: '${titleFont}', sans-serif">
                                ${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN
                            </div>
                        </div>
                    `);

                    groupContainer.append($card);
                });

            }else if(template === 'straight_style'){
                products.forEach(product => {
                    const maxChars = 96;
                    let description = product.description || '';
                    let shortDescription = description.length > maxChars
                        ? description.substring(0, maxChars) + ' ...'
                        : description;
                    let badge = '';
                    if(product.recommended === '1'){
                        badge = `<div class="straight_style-highlight">
                                        <span class="straight_style-star">
                                            <svg width="15" height="16" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g id="Star">
                                                    <g id="Group">
                                                        <path id="Vector" d="M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z" fill="${textoPrincipal}"/>
                                                    </g>
                                                </g>
                                            </svg>
                                        </span>
                                        <span class="straight_style-label" style="color: ${textoPrincipal};font-family: '${titleFont}', sans-serif">Producto Destacado</span>
                                    </div>`;
                    }else{
                        badge = '';
                    }
                    const $card = $(`
                    <div class="straight_style-card"
                            data-name="${product.name}"
                            data-price="${product.price}"
                            data-description="${shortDescription}"
                            data-image="${product.image}"
                            data-recommended="${product.recommended}" style="background: ${fondoPrincipal}">
                        <div class="straight_style-header">
                            <h3 class="straight_style-title" style="color: ${textoPrincipal};font-family: '${titleFont}', sans-serif">${product.name}</h3>
                            <div class="straight_style-image-placeholder">
                                <img src="${path_media+product.image}" alt="${product.name}">
                            </div>
                        </div>
                        <div class="straight_style-body">
                            <div class="straight_style-info-wrapper">
                                <div class="straight_style-left">
                                    ${badge}
                                    <div class="straight_style-price" style="color:${textoPrincipal};font-family: '${titleFont}', sans-serif">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>
                                </div>
                                <div class="straight_style-description" style="color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif">${shortDescription}</div>
                            </div>
                        </div>
                    </div>
                `);
                    $container.append($card);
                });
            }else if(template === 'vertical_straight_style'){
                products.forEach(product => {
                    const maxChars = 136;
                    let description = product.description || '';
                    let shortDescription = description.length > maxChars
                        ? description.substring(0, maxChars) + ' ...'
                        : description;
                    let badge = '';
                    if(product.recommended === '1'){
                        badge = `<div class="vertical_straight_style-highlight">
                                        <span class="vertical_straight_style-star">
                                            <svg width="15" height="16" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g id="Star">
                                                    <g id="Group">
                                                        <path id="Vector" d="M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z" fill="${textoPrincipal}"/>
                                                    </g>
                                                </g>
                                            </svg>
                                        </span>
                                        <span class="vertical_straight_style-label" style="color: ${textoPrincipal};font-family: '${titleFont}', sans-serif">Producto Destacado</span>
                                    </div>`;
                    }else{
                        badge = '';
                    }
                    const $card = $(`
                    <div class="vertical_straight_style-card"
                            data-name="${product.name}"
                            data-price="${product.price}"
                            data-description="${shortDescription}"
                            data-image="${product.image}"
                            data-recommended="${product.recommended}" style="background: ${fondoPrincipal}">
                        <h3 class="vertical_straight_style-title" style="color: ${textoPrincipal};font-family: '${titleFont}', sans-serif">${product.name}</h3>

                        <div class="vertical_straight_style-image-placeholder">
                            <img src="${path_media+product.image}" alt="${product.name}">
                        </div>
                        <p class="vertical_straight_style-description" style="color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif">${shortDescription}</p>
                        <div class="vertical_straight_style-footer">
                            <div class="vertical_straight_style-price" style="color:${textoPrincipal};font-family: '${titleFont}', sans-serif">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>
                            ${badge}
                        </div>
                    </div>
                `);
                    $container.append($card);
                });
            }



            // Mostrar u ocultar botón regresar
            if (path.length > 0) {
                const titleFont = $('#menu_title_font').val();
                const textPrincipal = $('#menu_texto_principal').val();
                const prevName = path[path.length - 1];
                if($('.category-button').length === 1){
                    $container.prepend(`<div class="title-last-level"><span style="font-family: '${titleFont}', sans-serif; color: ${textPrincipal}">${prevName}</span></div>`);
                }
                $('#back-button-text').html(`<strong style="font-family: '${titleFont}', sans-serif">${prevName}</strong>`);
                $('#back-button-container').show();
                $('#back-button-text').attr('data-level', prevName);
            } else {

                $('#back-button-text').html(`<strong style="font-family: '${titleFont}', sans-serif">Menú Completo</strong>`);
                $('#back-button-text').attr('data-level', 'start');
            }

            if ($('.category-button:visible').length === 0) {
                const colorSecundario = $('#menu_fondo_secundario').val();
                if(template === 'round_style' || template === 'vertical_round_style'){
                    $('#category-container').css('background',colorSecundario);
                }else{
                    $('#category-container').css('background','none');
                }

            }else{
                $('#category-container').css('background','none');
            }
        }

        $(document).on('click', '.list-preview-wrapper, .vertical_round_style-card, .straight_style-card, .vertical_straight_style-card', function () {
            const path_image = $('#path_image').val();
            const name = $(this).data('name');
            const price = parseFloat($(this).data('price')).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });
            const description = $(this).data('description');
            const image = path_image+$(this).data('image');
            const recommended = $(this).data('recommended');
            const tittle_back_link = $('.text-link-back-page strong').html();

            $('.detail-product-title').html(tittle_back_link);
            $('.detail-product-image').attr('src',image);
            $('.detail-product-name').html(name);
            $('.detail-product-description').html(description);
            $('.detail-product-price').html(price+' MXN');
            if(recommended === 1){
                $('.detail-product-badge').show();
            }
            $('.detail-product-wrapper').show();
            $('.preview-header-section, .preview-footer, #category-container').hide();
            $('.preview-container').css('background','none');

        });

        $(document).on('click', '.detail-product-icons', function () {
            const $fondo = $('#menu_fondo').val();
            $('.preview-container').css('background',$fondo);
            $('.detail-product-badge, .detail-product-wrapper').hide();
            $('.preview-header-section, .preview-footer, .preview-recommendations').show();
            const tittle_back_link = $('.detail-product-title').html();
            if(tittle_back_link != "Recomendados"){
                $('#category-container').show();
                $('.preview-recommendations').hide();
            }
        });

        $(document).on('click', '.preview-products-recommendations', function () {
            $('.preview-container').css('background','none');
            const path_image = $('#path_image').val();
            const name = $(this).data('name');
            const price = parseFloat($(this).data('price')).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });
            const description = $(this).data('description');
            const image = path_image+$(this).data('image');
            const recommended = $(this).data('recommended');
            const tittle_back_link = "Recomendados";
            $('.detail-product-title').html(tittle_back_link);
            $('.detail-product-image').attr('src',image);
            $('.detail-product-name').html(name);
            $('.detail-product-description').html(description);
            $('.detail-product-price').html(price+' MXN');
            if(recommended === 1){
                $('.detail-product-badge').show();
            }
            $('.detail-product-wrapper').show();
            $('.preview-header-section, .preview-footer, #category-container, .preview-recommendations').hide();
        });

        $(document).on('click', '.preview-footer-copyright', function () {
            window.location.href = '/';
        });

        $(document).on('click', '.preview-footer-link', function () {
            let menuId = $(this).data('link-terms');
            window.location.href = '/menudigital/index/terminos/id/' + menuId;
        });

        /* Introduction */
        $(document).on('click', '.intro-create-menu-digital-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-create-menu').toggleClass('rotated');
            $wrapper.find('.custom-content-create-menu').slideToggle();
        });

        $(document).on('click', '.intro-edit-menu-digital-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-edit-menu').toggleClass('rotated');
            $wrapper.find('.custom-content-edit-menu').slideToggle();
        });

        $(document).on('click', '.intro-edit-qr-menu-digital-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-edit-qr-menu').toggleClass('rotated');
            $wrapper.find('.custom-content-edit-qr-menu').slideToggle();
        });

        $(document).on('click', '.intro-create-cat-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-create-cat-menu').toggleClass('rotated');
            $wrapper.find('.custom-content-create-cat-menu').slideToggle();
        });

        $(document).on('click', '.intro-edit-cat-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-edit-cat-menu').toggleClass('rotated');
            $wrapper.find('.custom-content-edit-cat-menu').slideToggle();
        });

        $(document).on('click', '.intro-create-articulo-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-create-articulo-menu').toggleClass('rotated');
            $wrapper.find('.custom-content-create-articulo-menu').slideToggle();
        });

        $(document).on('click', '.intro-edit-articulo-click', function () {
            const $wrapper = $(this).closest('.customization-wrapper');

            $wrapper.find('.toggle-arrow-edit-articulo-menu').toggleClass('rotated');
            $wrapper.find('.custom-content-edit-articulo-menu').slideToggle();
        });

        $(document).on('input', '.validate-price', function () {
            const $this = $(this);
            let inputVal = $this.val();

            // Evitar ceros a la izquierda, excepto si el valor empieza con "0." (decimal válido)
            if (/^0+[1-9]/.test(inputVal)) {
                inputVal = inputVal.replace(/^0+/, '');
                $this.val(inputVal);
            }

            const value = parseFloat(inputVal);

            if (isNaN(value) || value <= 0) {
                alert("El valor del precio debe ser mayor a 0");
                $this.val('');
            }
        });


    });
});
