define([
  'jquery',
  'Magento_Ui/js/modal/modal',
  'mage/url',
  'Magento_Customer/js/customer-data'
], function($, modal, urlBuilder, customerData) {
    var options = {
      type: 'popup',
      modalClass: 'add-card-popup',
      responsive: true,
      innerScroll: true
    };
    modal(options, $('#suscription-modal'));

    $('#suscription-new-btn').on('click', function(){
      $('#suscription-modal').modal('openModal');
    });

    var editOptions = {
      type: 'popup',
      modalClass: 'add-card-popups',
      responsive: true,
      innerScroll: true
    };
    modal(editOptions, $('#suscription-modal'));

    modal(options, $('#suscription-edit-modal'));

    var editOptions = {
      type: 'popup',
      modalClass: 'add-card-popups',
      responsive: true,
      innerScroll: true
    };
    modal(editOptions, $('#suscription-edit-modal'));

    var suscriptionId;
    $('#ajax-content').on('click', '.icon-edit', function() {
        event.preventDefault();
        var skuRestauran = $(this).closest('td').data('skurestaurant');
        var skuProduct = $(this).closest('td').data('skuproduct');
        var periodicity = $(this).closest('td').data('periodicity');
        var qty = $(this).closest('td').data('qty');
        var startDate = $(this).closest('td').data('startdate');
        var endDate = $(this).closest('td').data('enddate');
        var suscriptionId = $(this).closest('td').data('suscriptionid');

        $('#edit-sku-restauran').find('option[value="'+skuRestauran+'"]').prop('selected', true);
        $('#edit-sku-suscription').find('option[value="'+skuProduct+'"]').prop('selected', true);
        $('#edit-periodicity-suscription').find('option[value="'+periodicity+'"]').prop('selected', true);
        $('#edit-qty-suscription').find('option[value="'+qty+'"]').prop('selected', true);
        $('#edit-start-date').val(startDate.substr(0,10));
        $('#edit-end-date').val(endDate.substr(0,10));
        $("#suscription-id").val(suscriptionId);

        $('#suscription-edit-modal').modal('openModal');
    });

    $('#edit-suscription').on('click', function (event) {
        const restaurantSku = $('#edit-sku-restauran').find(":selected").val();
        const productSku = $('#edit-sku-suscription').find(":selected").val();
        const periodicity = $('#edit-periodicity-suscription').find(":selected").val();
        const quantity = $('#edit-qty-suscription').find(":selected").val();
        const startDate = $('#edit-start-date').val().trim();
        const endDate = $('#edit-end-date').val().trim();
        const suscriptionId = $('#suscription-id').val();

        const data = {
            suscriptionId: suscriptionId,
            restaurantSku: restaurantSku,
            productSku: productSku,
            periodicity: periodicity,
            quantity: quantity,
            startDate: startDate,
            endDate: endDate
        }

        $.ajax({
            url: urlBuilder.build('restaurant_subscription/restaurant_listhistory/subscriptionupdate'),
            type: 'POST',
            data: data,
            dataType: 'json'
        }).done(function(res) {
            alert('Suscripcion guardada con exito');
            window.location.href = urlBuilder.build('/restaurant_subscription/restaurant_listhistory/index');
        }).fail(function() {
            alert('Error al guardar la suscripcion');
        });
    });

    $('#suscription-new-form').on('submit', function (event) {
        event.preventDefault();
        const restaurantSku = $('#sku-restauran').val().trim();
        const productSku = $('#sku-suscription').val().trim();
        const periodicity = $('#periodicity-suscription').find(":selected").val();
        const quantity = $('#qty-suscription').find(":selected").val();
        const startDate = $('#start-date').val().trim();
        const endDate = $('#end-date').val().trim();

        $.ajax({
            url: urlBuilder.build('restaurant_subscription/restaurant_listhistory/subscriptionew'),
            type: 'POST',
            data: {
                restaurantSku: restaurantSku,
                productSku: productSku,
                periodicity: periodicity,
                quantity: quantity,
                startDate: startDate,
                endDate: endDate
            },
            showLoader: true,
            success: function (response) {
                if (response.success) {
                    alert($.mage.__('Suscription saved successfully.'));
                    customerData.reload(['customer']);
                    $('#suscription-new-form-form button').text('Guardada');
                    location.reload();
                } else {
                    alert($.mage.__('Error saving card: ' + (response.message || '')));
                    $('#suscription-new-form button')
                        .prop('disabled', false)
                        .text('Suscripcion Tarjeta');
                }
            },
            error: function () {
                alert($.mage.__('An unexpected error occurred.'));
                $('#stripe-add-card-form button')
                    .prop('disabled', false)
                    .text('Guardar Tarjeta');
            }
        });
    });

});