/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
    "jquery",
    'Magento_Ui/js/modal/alert',
    'mage/template',
    'mage/translate',
    "mage/calendar"
], function ($, alert, mageTemplate, $t) {
    'use strict';
    $.widget('appointmentbooking.appointmentbooking', {
        options: {
        },
        _create: function () {
            var self = this;
            var monthArr = self.options.monthArr;
            var todaySlotArr = self.options.todaySlotArr;
            var options = JSON.parse(self.options.optionsJson);
            var unvailableDates = self.options.appointmentUnavailableDates;
            var holidaysData = self.options.holidaysData;
            $("#wk-bk-select-date").datepicker({
                'dateFormat':'mm/dd/yy',
                'minDate': 'today',
                'maxDate': self.options.bookingAvailableTo,
                'beforeShowDay': function (date) {
                    var string = $.datepicker.formatDate('dd M, yy', date);
                    var isDisabled = ($.inArray(string, unvailableDates) != -1);
                    if(isDisabled){
                        return [!isDisabled];
                    }
                    string = $.datepicker.formatDate('yy-mm-dd', date);
                    let holiday = holidaysData[string];
                    if(holiday){
                        return [false,'',holiday];
                    }
                    return [true];
                },
            });
            todaySlotArr.now = parseInt(Date.now()/1000);
            todaySlotArr.activeFirst = 0;
            var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template-today'),
            tmpl;
            tmpl = progressTmpl({
                data: todaySlotArr
            });
            $('.wk-bk-select-time-opt-wrapper').html(tmpl);
            var selectedTime = $('.wk-bk-slot-selected').text();
            $('#wk-bk-booking-time-field').val(selectedTime);
            $('#wk-bk-booking-time-field').next('.wk-bk-select-time-label').text(selectedTime);
            self._setProductOptions($('.wk-bk-slot-selected'), options);

            $("body").on('change', '#wk-bk-select-date', function () {
                var selectedDate  = $(this).val();
                var parsedDate = Date.parse(selectedDate, "yyyy-MM-dd");
                let serverTimezoneDate = '';
                var str = parsedDate.toString();
                parsedDate = str.substr(0, str.length-3);

                var selectedDateArr  = selectedDate.split('/');
                var day = selectedDateArr[1];
                var month = selectedDateArr[0];
                var year = selectedDateArr[2];
                var formatedDate = day+" "+monthArr[month]+", "+year;
                let optionDate = year+"-"+month+"-"+day;
                serverTimezoneDate = year+month+day;
                var d = new Date(selectedDate);
                var dayIndex = d.getDay();
                if (dayIndex == 0) {
                    dayIndex = 7;
                }

                var todayDate = new Date();
                var tday = todayDate.getDate();
                var tmonth = todayDate.getMonth() + 1;
                var tyear = todayDate.getFullYear();
                let holidayDateFormat = $.datepicker.formatDate('yy-mm-dd', d);;
                var isHoliday = holidaysData[holidayDateFormat];
                if(isHoliday){
                    tmpl = null;
                } else if (day == tday && month == tmonth && year == tyear) {
                    // if from selected date is today
                    var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template-today'),
                    tmpl;
                    tmpl = progressTmpl({
                        data: todaySlotArr
                    });
                } else {
                    var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template'+dayIndex),
                    tmpl;
                    tmpl = progressTmpl({
                        data: {}
                    });
                }
                $('.wk-bk-select-time-opt-wrapper').html(tmpl);
                let currentDate = parsedDate;
                if (serverTimezoneDate) {
                    currentDate = serverTimezoneDate;
                }
                if (currentDate in self.options.bookedData) {
                    $.each(self.options.bookedData[currentDate], function (key, value) {
                        if ($('.wk-bk-select-time-opt-wrapper').find(".wk-bk-select-time-opt[data-type-time='"+key+"']").length) {
                            var optTimeHtml = $('.wk-bk-select-time-opt-wrapper').find(".wk-bk-select-time-opt[data-type-time='"+key+"']");
                            var remainingQty = optTimeHtml.data("slot-qty") - value;
                            if (remainingQty <= 0) {
                                optTimeHtml.removeClass('wk-bk-slot-booked');
                                optTimeHtml.addClass('wk-bk-slot-booked');
                            }
                        }
                    });
                }

                $('.wk-bk-select-time-opt-wrapper').removeAttr('style');
                var selectedTime = $('.wk-bk-slot-selected').text();
                var isTimeClosed = false;
                $('#wk-bk-booking-time-field').val(selectedTime);
                $('#wk-bk-slot-day-index').val($('.wk-bk-slot-selected').attr('data-day-index'));
                $('#wk-bk-parent-slot-id').val($('.wk-bk-slot-selected').attr('data-index'));
                $('#wk-bk-slot-id').val($('.wk-bk-slot-selected').attr('data-slot-index'));
                if (!tmpl) {
                    selectedTime = self.options.titleClosed;
                    isTimeClosed = true;
                    $('.wk-bk-select-time-opt-wrapper').attr('style', 'display: none;');
                }
                $(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text(selectedTime);
                if (!selectedTime) {
                    $(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text($t('Closed'));
                }
                $('.wk-bk-select-date-label').text(formatedDate);
                $('.wk-bk-select-date-label').attr('data-booking-date', optionDate);
                var bookedDate = $('.wk-bk-select-date-label').text();
                $.each(options, function (k, v) {
                    if (v.title == 'Booking Date') {
                        if ($('#options_'+v.id+'_text').length) {
                            $('#options_'+v.id+'_text').val(optionDate);
                        } else {
                            $('#product-options-wrapper').find('.fieldset').append(
                                $('<input>')
                                    .attr('type', 'hidden')
                                    .attr('name', 'options['+v.id+']')
                                    .attr('id', 'options_'+v.id+'_text')
                                    .val(optionDate)
                            );
                        }
                    }
                    if (v.title == 'Booking Slot') {
                        if (isTimeClosed) {
                            selectedTime = "";
                        }
                        if ($('#options_'+v.id+'_text').length) {
                            $('#options_'+v.id+'_text').val(selectedTime);
                        } else {
                            $('#product-options-wrapper').find('.fieldset').append(
                                $('<input>')
                                    .attr('type', 'hidden')
                                    .attr('name', 'options['+v.id+']')
                                    .attr('id', 'options_'+v.id+'_text')
                                    .val(selectedTime)
                            );
                        }
                    }
                });
            });
            $('#wk-bk-select-date').trigger('change');
            $("body").on('click', '.wk-bk-select-time-opt', function () {
                if (!$(this).hasClass('wk-bk-slot-booked')) {
                    self._setProductOptions($(this), options);
                }
            });
        },

        _setProductOptions: function (element, options) {
            var thisObj = element;
            var selectedTime = thisObj.attr('data-type-time');
            $(".wk-bk-select-time-opt").each(function () {
                if ($(this).hasClass('wk-bk-slot-selected')) {
                    $(this).removeClass('wk-bk-slot-selected');
                }
            });
            thisObj.parents('.wk-bk-dates-right-container').find('.wk-bk-select-time-label').text(selectedTime);
            thisObj.addClass('wk-bk-slot-selected');
            $('#wk-bk-booking-time-field').val(selectedTime);
            $('#wk-bk-slot-day-index').val(thisObj.attr('data-day-index'));
            $('#wk-bk-parent-slot-id').val(thisObj.attr('data-index'));
            $('#wk-bk-slot-id').val(thisObj.attr('data-slot-index'));
            var bookedDate = $('.wk-bk-select-date-label').attr('data-booking-date');
            $.each(options, function (k, v) {
                if (v.title == 'Booking Date') {
                    if ($('#options_'+v.id+'_text').length) {
                        $('#options_'+v.id+'_text').val(bookedDate);
                    } else {
                        $('#product-options-wrapper').find('.fieldset').append(
                            $('<input>')
                                .attr('type', 'hidden')
                                .attr('name', 'options['+v.id+']')
                                .attr('id', 'options_'+v.id+'_text')
                                .val(bookedDate)
                        );
                    }
                }
                if (v.title == 'Booking Slot') {
                    if ($('#options_'+v.id+'_text').length) {
                        $('#options_'+v.id+'_text').val(selectedTime);
                    } else {
                        $('#product-options-wrapper').find('.fieldset').append(
                            $('<input>')
                                .attr('type', 'hidden')
                                .attr('name', 'options['+v.id+']')
                                .attr('id', 'options_'+v.id+'_text')
                                .val(selectedTime)
                        );
                    }
                }
            });
        }
    });
    return $.appointmentbooking.appointmentbooking;
});
