define(['jquery', 'Magento_Ui/js/modal/alert', 'mage/url'], function ($, alert, urlBuilder) {
    return function (options) {
        var customerToken = options.token;
        var $categoryDropdown = $(options.categoryDropdown);

        $.ajax({
            url: '/rest/V1/categories',
            type: 'GET',
            contentType: 'application/json',
            headers: {
                'Authorization': 'Bearer ' + customerToken
            },
            success: function (response) {
                var categories = response.children_data;
                buildCategoryDropdown(categories, $categoryDropdown);
            },
            error: function (xhr, status, error) {
                console.log("Error fetching categories: ", error);
                console.log("Response: ", xhr.responseText);
            }
        });

        function buildCategoryDropdown(categories, dropdown, prefix = '') {
            categories.forEach(function (category) {
                var optionText = prefix + category.name;
                var optionValue = category.id;
                var option = $('<option></option>').val(optionValue).text(optionText);
                dropdown.append(option);

                if (category.children_data.length) {
                    buildCategoryDropdown(category.children_data, dropdown, prefix + '- ');
                }
            });
        }
    };
});
