require(['jquery'], function ($) {
    $(document).ready(function () {
        $('#go-to-address-btn').on('click', function () {
            const targetCoordinates = $(this).data('coordinates');
            const [targetLat, targetLng] = targetCoordinates.split(',').map(coord => coord.trim());

            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(
                    function (position) {
                        const userLat = position.coords.latitude;
                        const userLng = position.coords.longitude;
                        const googleMapsUrl = `https://www.google.com/maps/dir/${userLat},${userLng}/${targetLat},${targetLng}`;
                        window.open(googleMapsUrl, '_blank');
                    },
                    function (error) {
                        alert('Error getting your location: ' + error.message);
                    }
                );
            } else {
                alert('Geolocation is not supported by your browser.');
            }
        });
    });
});