define([
    'uiComponent',
    'escaper',
    'underscore'
], function (Component, escaper, _) {
    'use strict';
    
    var quoteItemData = window.checkoutConfig.quoteItemData;

    return Component.extend({
        defaults: {
            template: 'Threedadv_Webkul/summary/item/details',
            allowedTags: ['b', 'strong', 'i', 'em', 'u']
        },

        getNameUnsanitizedHtml: function (quoteItem) {
            var txt = document.createElement('textarea');
            txt.innerHTML = quoteItem.name;
            return escaper.escapeHtml(txt.value, this.allowedTags);
        },

        getValue: function (quoteItem) {
            return quoteItem.name;
        },

        getTempQty: function(quoteItem) {
            var item = this.getItem(quoteItem.item_id);
            return item && item.temp_qty ? item.temp_qty : 0;
        },

        getItem: function(item_id) {
            // Primero, busca en el objeto con la clave basada en item_id
            if (quoteItemData[item_id]) {
                return quoteItemData[item_id];
            }

            // Si no se encuentra, busca en la parte del objeto que es un array numérico
            var itemElement = null;
            _.each(quoteItemData, function(element) {
                if (element.item_id == item_id) {
                    itemElement = element;
                }
            });
            console.log(itemElement);
            return itemElement;
        }
    });
});
