define(['jquery'], function ($) {
    'use strict';

    return {
        init: function () {            
            $(document).ready(function () {
                const items = document.querySelectorAll(".product-item");
                let totalItems = items.length;
                const carousel = document.querySelector(".product-items");
                let currentIndex = 0;

                const prevButton = document.querySelector(".wishlist-prev");
                const nextButton = document.querySelector(".wishlist-next");

                function updateButtons() {
                    let visibleItems = window.innerWidth <= 768 ? 1 : 3;

                    if (totalItems <= visibleItems) {
                        prevButton.style.display = "none";
                        nextButton.style.display = "none";
                    } else {
                        prevButton.style.display = "block";
                        nextButton.style.display = "block";
                    }

                    if (currentIndex === 0) {
                        prevButton.style.display = "none";
                    } else {
                        prevButton.style.display = "block";
                    }

                    if (currentIndex >= totalItems - visibleItems) {
                        nextButton.style.display = "none";
                    } else {
                        nextButton.style.display = "block";
                    }
                }

                function moveCarousel() {
                    let visibleItems = window.innerWidth <= 768 ? 1 : 3;
                    const offset = -(currentIndex * (100 / visibleItems));
                    carousel.style.transform = `translateX(${offset}%)`;

                    updateButtons();
                }

                prevButton.addEventListener("click", function (event) {
                    event.preventDefault();
                    event.stopPropagation();
                    if (currentIndex > 0) {
                        currentIndex--;
                        moveCarousel();
                    }
                });

                nextButton.addEventListener("click", function (event) {
                    event.preventDefault();
                    event.stopPropagation();
                    if (currentIndex < totalItems - (window.innerWidth <= 768 ? 1 : 3)) {
                        currentIndex++;
                        moveCarousel();
                    }
                });

                updateButtons();
                window.addEventListener("resize", function () {
                    updateButtons();
                    moveCarousel();
                });
            });
        }
    };
});
