require(["jquery"], function (jQuery) {
    document
        .getElementById("form-restaurant-search")
        .addEventListener("submit", function (event) {
            const queryInput = document.getElementById("q");
            if (queryInput.value.trim() === "") {
                queryInput.value = "restaurante";
            }
        });

    document.getElementById("date").addEventListener("change", function (e) {
        getTimeOptions(getCurrentDate() == e.target.value);
    });

    document.getElementById("date").addEventListener("click", () => {
        document.getElementById("date").showPicker();
    });

    function getCurrentDate() {
        const today = new Date();
        const year = today.getFullYear();
        const month = ("0" + (today.getMonth() + 1)).slice(-2);
        const day = ("0" + today.getDate()).slice(-2);

        return `${year}-${month}-${day}`;
    }

    function getTimeOptions(isToday) {
        let hours = 0;
        if (isToday) {
            const currentDateTime = new Date();
            currentDateTime.setHours(currentDateTime.getHours() + 1);
            hours = currentDateTime.getHours();
        }

        const timeOptions = [];
        for (let h = hours; h < 24; h++) {
            ["00", "30"].forEach((minute) => {
                timeOptions.push(("0" + h).slice(-2) + ":" + minute);
            });
        }

        const select = document.getElementById("hourly");
        select.innerHTML = "";

        timeOptions.forEach((time) => {
            const option = document.createElement("option");
            option.value = time;
            option.text = time;
            select.appendChild(option);
        });
    }

    getTimeOptions(true);
});
