define([
  'jquery',
  'mage/url',
  'Magento_Customer/js/customer-data',
  'https://js.stripe.com/v3/'
], function($, urlBuilder, customerData) {
  'use strict';
  return function(config) {
    var stripe   = Stripe(config.publicKey),
        elements = stripe.elements();
  
    $('#stripe-edit-card-form').on('submit', function(e) {
      e.preventDefault();
        var $btn = $(this).find('button[type=submit]')
          .prop('disabled', true)
          .text($.mage.__('Saving…'));

    var payload = {
      old_token:       $('#edit-gateway-token').val(),
      card_id:         $('#edit-card-id').val(),
      cardholder_name: $('#edit-cardholder-name').val().trim(),
      postal_code:     $('#edit-billing-zip').val().trim(),
      billing_address: $('#edit-billing-address').val().trim(),
      exp_month:       $('#edit-exp-month').val(),
      exp_year:        $('#edit-exp-year').val()
    };
    $.ajax({
      url: urlBuilder.build('stripecards/cards/updatecard'),
      type: 'POST',
      data: payload,
      dataType: 'json',
      showLoader: true
    }).done(function(resp) {
      if (resp.success) {
        alert($.mage.__('Card updated correctly.'));
        customerData.reload(['customer']);
        location.reload();
      } else {
        alert(resp.message || $.mage.__('Error updating.'));
        $btn.prop('disabled', false).text($.mage.__('Save Changes'));
      }
    }).fail(function() {
      alert($.mage.__('Error inesperado.'));
      $btn.prop('disabled', false).text($.mage.__('Save Changes'));
    });
  });
};
});
