document.addEventListener('DOMContentLoaded', function () {
    function relocateMediaCard() {
        const mediaCard = document.querySelector('.left-pdp.product-media-restaurant-card');
        const productMedia = document.querySelector('.product-media');
        const productInfoPrice = document.querySelector('.product-info-price');
        const reservation = document.querySelector('.costo-la');

        if (window.innerWidth < 769) {
            if (mediaCard && productMedia && productInfoPrice && !productMedia.contains(mediaCard)) {
                productInfoPrice.insertAdjacentElement('afterend', mediaCard);
            }
        } else {
            if (reservation && mediaCard) {
                if (mediaCard.parentNode && mediaCard.parentNode !== reservation) {
                    mediaCard.parentNode.insertBefore(reservation, mediaCard);
                }
                if (!reservation.contains(mediaCard)) {
                    reservation.appendChild(mediaCard);
                }
            }
        }
    }

    relocateMediaCard();
    window.addEventListener('resize', relocateMediaCard);

    const removeSelectedSlot = () => {
        const interval = setInterval(() => {  
            let selectedSlots = Array.from(document.getElementsByClassName("wk-bk-slot-selected")); 
        
            if (selectedSlots.length > 1) {  
                let lastSlot = selectedSlots[selectedSlots.length - 1];
                if (lastSlot.classList.contains("wk-bk-slot-selected")) { 
                    lastSlot.classList.remove("wk-bk-slot-selected");
                    clearInterval(interval); 
                }
            } 
        }, 500);
    };

    removeSelectedSlot();
    
    function hiddeLabel() {
        const interval = setInterval(() => {
            const timeLabel = document.getElementById('default-time-label');
            const selectTimeLabel = document.getElementById('select-time-label');
            const reservationButton = document.getElementById('wk-book-now'); 

            if (timeLabel) {
                if (timeLabel.textContent.trim() === 'Cerrado') {
                    selectTimeLabel.style.display = 'none';
                    timeLabel.style.height = '60px';
    
                    if (reservationButton) { 
                        reservationButton.disabled = true;
                        reservationButton.classList.add('disabled');
                    }
                } else {   
                    timeLabel.style.display = 'none';                 
                    if (reservationButton) {
                        reservationButton.disabled = false;
                        reservationButton.classList.remove('disabled');
                    }
                }
                clearInterval(interval);
            }
        }, 500); 
    }
    hiddeLabel();
});
