define(["jquery", "domReady"], function ($, dom) {
    "use strict";
    document
        .querySelector(".notifications-container")
        .addEventListener("click", (event) => {
            const notificationsList = document.querySelector(
                ".notifications-list"
            );
            if (notificationsList.style.display === "none") {
                notificationsList.style.display = "block";
            } else {
                notificationsList.style.display = "none";
            }
            event.stopPropagation();
        });

    document.addEventListener("click", (event) => {
        const notificationsList = document.getElementById("notifications-list");
        if (notificationsList && !notificationsList.contains(event.target)) {
            notificationsList.style.display = "none";
        }
    });

    document.querySelector("#mark-as-read")?.addEventListener("click", (e) => {
        e.preventDefault();
        readNotifications();
    });

    const readNotifications = () => {
        console.info("FRONT ");
        const notifications = document.querySelectorAll(".notification");

        if (notifications.length > 0) {
            const BASE_URL = window.location.origin;
            const url = `${BASE_URL}/rest/V1/customer-notifications/read`;
            const ids = [];
            notifications.forEach((notification) => {
                ids.push(notification.getAttribute("notification-id"));
            });

            if (ids.length === 0) return;

            const init = {
                method: "POST",
                body: JSON.stringify({
                    ids: ids,
                }),
                headers: {
                    "Content-Type": "application/json",
                },
            };

            fetch(url, init)
                .then((response) => {
                    if (!response.ok) {
                        throw new Error("Error en la solicitud");
                    }
                    document.querySelector(".notifications-count").textContent =
                        "(0)";
                    document.querySelector(".notifications-list").innerHTML =
                        "";
                    document.querySelector(".notifications-list").innerHTML =
                        '<p class="no-notifications">No tienes notificaciones</p>';
                })
                .catch((error) => {
                    console.error(error);
                });
        }
    };

    //notification sound
    let doSound = false;
    const audio = document.getElementById("notification-sound");

    if (audio) {
        document.addEventListener("mousemove", () => {
            if (!audio.paused || doSound) return;

            audio
                .play()
                .then(() => (doSound = true))
                .catch((error) => {});
        });
    }

    return function () {
        function checkNotifications() {
            $.ajax({
                url: '/rest/V1/customer-notifications/notifications/messages',
                method: 'GET',
                success: function (response) {
                    if (response.length) {
                        $('.notifications-count span').text(response[2]);
                    }
                },
                error: function () {
                    console.error('❌ Error consultando notificaciones');
                }
            });
        }

        setInterval(checkNotifications, 10000);
    };

});
