define([
    'jquery',
    'Magento_Checkout/js/view/payment/default',
    'ko',
    'mage/storage',
    'Magento_Customer/js/model/customer',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/action/set-payment-information'
], function ($, Component, ko, storage, customer, quote, setPaymentInformationAction) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Threedadv_Stripe/payment/stripevault',
            savedCards: ko.observableArray([]),
            selectedCard: ko.observable(null),
            cvvCode: ko.observable(''),
            showNewCardForm: ko.observable('saved_card'),
            cardOperation: 'saved_card',
            billingAddressListTemplate: 'Threedadv_Stripe/billing-address/list-custom',
            billingAddressDetailsTemplate: 'Threedadv_Stripe/billing-address/details-custom',
        },

        initialize: function () {
            this._super();
            this.loadSavedCards();
        },

        loadSavedCards: function () {
            if (!customer.isLoggedIn()) {
                return;
            }
            var self = this;
            storage.post(
                '/stripecards/vault/getsavedcards',
                JSON.stringify({})
            ).done(function (response) {
                if (!response.error) {
                    self.savedCards(response.cards);
                    if (response.cards.length) {
                        self.selectedCard(response.cards[0].public_hash);
                    }
                } else {
                    console.error(response.message);
                }
            }).fail(function () {
                console.error('Error al obtener tarjetas guardadas.');
            });
        },

        initStripe: function () {
            var self = this;
            if (typeof Stripe === 'undefined') {
                require(['https://js.stripe.com/v3/'], function () {
                    self.setupStripeElement();
                });
            } else {
                self.setupStripeElement();
            }
        },
        
        setupStripeElement: function () {
            var self = this;
            var stripe = Stripe(window.checkoutConfig.payment.stripevault.publicKey);
            var elements = stripe.elements();

            const cardNumber = elements.create('cardNumber', {
                placeholder: '16 dígitos'
            });
            cardNumber.mount('#stripe-card-number');
    
            const cardExpiry = elements.create('cardExpiry', {
                placeholder: 'MM / AA'
            });
            cardExpiry.mount('#stripe-card-expiry');
    
            const cardCvc = elements.create('cardCvc', {
                placeholder: '3 dígitos'
            });
            cardCvc.mount('#stripe-card-cvc');
            self.stripe = stripe;
            self.cardNumber = cardNumber;
            self.cardExpiry = cardExpiry;
            self.cardCvc = cardCvc;
            $('#stripe-add-card-form').on('submit', function (event) {
                event.preventDefault();
                
                var cardholderName = $('#cardholder-name').val();
                if (!cardholderName) {
                    alert('Por favor ingrese el nombre del titular de la tarjeta');
                    return;
                }
                
                $("#stripe-add-card-form button").prop("disabled", true).text("Guardando...");
                
                stripe.createToken(cardNumber, { name: cardholderName }).then(function (result) {
                    if (result.error) {
                        alert(result.error.message);
                        $("#stripe-add-card-form button").prop("disabled", false).text("Guardar Tarjeta");
                    } else {
                        var billingAddr = quote.billingAddress() || {};
                        var streetArr = billingAddr.street || [];
                        var street = streetArr.join(' ');
                        var city = billingAddr.city || '';
                        var region = billingAddr.region || billingAddr.regionCode || '';
                        var postcode = billingAddr.postcode || '';
                        var country = billingAddr.countryId || '';
                        var billingAddressString = [street, city, (region + ' ' + postcode).trim(), country]
                            .filter(function(item) { return item; })
                            .join(', ');
                        $.ajax({
                            url: window.checkoutConfig.payment.stripevault.saveCardUrl,
                            type: "POST",
                            data: { token: result.token.id,
                                cardholder_name:   cardholderName,
                                billing_address:   billingAddressString
                             },
                            showLoader: true,
                            success: function (response) {
                                if (response.success) {
                                    alert("Tarjeta guardada correctamente.");
                                    require(['Magento_Customer/js/customer-data'], function (customerData) {
                                        customerData.reload(["customer"]);
                                    });
                                    $("#stripe-add-card-form button").text("Guardada ✔");
                                    location.reload();
                                } else {
                                    alert("Error al guardar la tarjeta: " + response.message);
                                    $("#stripe-add-card-form button").prop("disabled", false).text("Guardar Tarjeta");
                                }
                            },
                            error: function () {
                                alert("Ocurrió un error inesperado.");
                                $("#stripe-add-card-form button").prop("disabled", false).text("Guardar Tarjeta");
                            }
                        });
                    }
                });
            });
        },

        getData: function () {
            var selected = this.selectedCard();
            var billingAddr = quote.billingAddress() || {};
            var streetArr = billingAddr.street || [];
            var street = streetArr.join(' ');
            var city = billingAddr.city || '';
            var region = billingAddr.region || billingAddr.regionCode || '';
            var postcode = billingAddr.postcode || '';
            var country = billingAddr.countryId || '';
            var billingAddressString = [street, city, (region + ' ' + postcode).trim(), country]
                .filter(function(item) { return item; })
                .join(', ');

            return {
                method: this.getCode(),
                additional_data: {
                    public_hash:     selected || '',
                    cvv:             this.cvvCode() || '',
                    billing_address: billingAddressString
                }
            };
        },

        selectPaymentMethod: function () {
            this._super();
            var paymentData = this.getData();
            quote.paymentMethod(paymentData);
            return setPaymentInformationAction(paymentData, paymentData);
        },

        getMaskedCC: function (card) {
            return card.maskedCC || '****';
        },

        getExpiration: function (card) {
            return card.expiration || 'N/A';
        },

        getCode: function () {
            return 'stripevault';
        },
        getInstructions: function () {
            return window.checkoutConfig.payment.stripevault.instructions;
        },

        getRegion: function (name) {
            var region = this._super(name);
            if (name === this.getBillingAddressFormName()) {
              region.forEach(function (component) {
                component.template = this.billingAddressListTemplate;
                if (component.children) {
                  component.children.forEach(function (child) {
                    child.template = this.billingAddressDetailsTemplate;
                  }.bind(this));
                }
              }.bind(this));
            }
            return region;
          }
    });
});
