define([
    'jquery',
    'html2canvas',
    'jspdf'
], function($, html2canvas, jsPDF) {
    'use strict';

    var $tabs       = $('.tabs .tab-item'),
        $content    = $('#ajax-content'),
        $searchIn   = $('#invoice-search-input'),
        $title      = $('#title'),
        $subtitle   = $('#subtitle'),
        $searchLbl  = $('#search-label'),
        currentSort = { field: '', dir: 'ASC' };

    var headers = {
        invoice: {
            title: "Factura e historial de facturación",
            subtitle: "Consulta tus facturas, descarga comprobantes y mantén al día tu historial de pagos.",
            label: "Buscar factura",
            placeholder: "Busca por fecha, concepto, SKU o ID de pedido..."
        },
        subscription: {
            title: "Suscripciones Activas y Canceladas",
            subtitle: "Consulta tus suscripciones activas, cancela o modifícalas",
            label: "Buscar suscripción",
            placeholder: "Busca por ID, estatus, SKU producto, SKU restaurante o tipo de cargo..."
        }
    };

    function updateHeader(type) {
        var h = headers[type];
        if (!h) return;
        $title.text(h.title);
        $subtitle.text(h.subtitle);
        $searchLbl.text(h.label);
        $searchIn.attr('placeholder', h.placeholder);
        if(h.label === 'Buscar suscripción'){
            $("#suscription-new").show();
        }else{
            $("#suscription-new").hide();
        }
    }

    function updateSortIcons() {
        $('.sort-icon').removeClass('asc desc');
        if (currentSort.field) {
            $('th.sortable[data-field="' + currentSort.field + '"] .sort-icon')
                .addClass(currentSort.dir.toLowerCase());
        }
    }

    function loadTab($tab, page) {
        var type = $tab.data('type');
        updateHeader(type);

        var data = {
            q: $searchIn.val(),
            sort: currentSort.field,
            dir: currentSort.dir
        };
        if (page) { data.p = page; }

        $content.html('<div class="loading">Cargando...</div>');
        $.ajax({
            url: $tab.data('url'),
            type: 'POST',
            data: data,
            dataType: 'json'
        }).done(function(res) {
            $content.html(res.html);
            updateSortIcons();
        }).fail(function() {
            $content.html('<div class="error">Error al cargar datos</div>');
        });
    }

    $(function() {
        // clic en pestañas
        $tabs.on('click', function() {
            $tabs.addClass('active');
            $(this).removeClass('active');
            // reset sorting
            currentSort = { field: '', dir: 'ASC' };
            loadTab($(this));
        });

        // sortables
        $content.on('click', 'th.sortable', function() {
            var field = $(this).data('field');
            if (currentSort.field === field) {
                currentSort.dir = (currentSort.dir === 'ASC' ? 'DESC' : 'ASC');
            } else {
                currentSort.field = field;
                currentSort.dir   = 'ASC';
            }
            loadTab($tabs.filter('.active'));
        });

        // búsqueda
        $('#invoice_search_button').on('click', function() {
            loadTab($tabs.filter('.active'));
        });

        // paginación
        $content.on('click', '.pagination a', function(e) {
            e.preventDefault();
            var page = $(this).data('page');
            if (page) {
                loadTab($tabs.filter('.active'), page);
            }
        });

        // 1) Detalle
        $content.on('click', '.icon-detalle', function() {
            var inc = $(this).closest('td').data('increment');
            $.post(window.subscriptionRoutes.detail, {increment_id: inc}, function(res) {
                $('body').append(res.html);
                $('body').on('click', '.modal-close', function() {
                    $('.modal-overlay').remove();
                });
            }, 'json');
        });

        // 2) Descargar PDF
        $content.on('click', '.icon-download', function() {
            var row = $(this).closest('tr')[0];
            var increment = $(row).find('.action-cell').data('increment');
            var url = BASE_URL + '/restaurant_subscription/restaurant_listhistory/downloadpdf?increment=' + increment;
            fetch(url)
            .then(res => {
                console.log(res);
                if (!res.ok) throw new Error();
                return res.blob();
            })
            .then(blob => {
                const link = document.createElement('a');
                link.href = URL.createObjectURL(blob);
                link.download = 'factura_'+increment+'.pdf';
                link.click();
            })
            .catch(() => alert('Error al generar o descargar el PDF.'));
        });

        // 3) Enviar por correo
        $content.on('click', '.icon-email', function() {
            var inc = $(this).closest('td').data('increment');
            $.post(window.subscriptionRoutes.email, {increment_id: inc}, function(res) {
                if (res.success) {
                    alert('Correo enviado correctamente');
                } else {
                    alert('Error: ' + (res.error||'Desconocido'));
                }
            }, 'json');
        });

        // carga inicial
        loadTab($tabs.filter('.inactive'));
    });
    
    function editSuscription(data) {
        $.ajax({
            url: $BASE_URL + '/restaurant_subscription/restaurant_listhistory/subscriptionnew',
            type: 'POST',
            data: data,
            dataType: 'json'
        }).done(function(res) {
            window.location.href = $BASE_URL + '/restaurant_subscription/restaurant_listhistory/index';
        }).fail(function() {
            alert('Error al guardar la suscripcion');
        });
    }
});
