require.config({"config": {
        "jsbuild":{"Threedadv_Base/js/lib/chart.js":"/*!\n * Chart.js\n * http://chartjs.org/\n * Version: 2.1.2\n *\n * Copyright 2016 Nick Downie\n * Released under the MIT license\n * https://github.com/chartjs/Chart.js/blob/master/LICENSE.md\n */\n(function e(t, n, r) { function s(o, u) { if (!n[o]) { if (!t[o]) { var a = typeof require == \"function\" && require; if (!u && a) return a(o, !0); if (i) return i(o, !0); var f = new Error(\"Cannot find module '\" + o + \"'\"); throw f.code = \"MODULE_NOT_FOUND\", f } var l = n[o] = { exports: {} }; t[o][0].call(l.exports, function (e) { var n = t[o][1][e]; return s(n ? n : e) }, l, l.exports, e, t, n, r) } return n[o].exports } var i = typeof require == \"function\" && require; for (var o = 0; o < r.length; o++)s(r[o]); return s })({\n    1: [function (require, module, exports) {\n\n    }, {}], 2: [function (require, module, exports) {\n        /* MIT license */\n        var colorNames = require('color-name');\n\n        module.exports = {\n            getRgba: getRgba,\n            getHsla: getHsla,\n            getRgb: getRgb,\n            getHsl: getHsl,\n            getHwb: getHwb,\n            getAlpha: getAlpha,\n\n            hexString: hexString,\n            rgbString: rgbString,\n            rgbaString: rgbaString,\n            percentString: percentString,\n            percentaString: percentaString,\n            hslString: hslString,\n            hslaString: hslaString,\n            hwbString: hwbString,\n            keyword: keyword\n        }\n\n        function getRgba(string) {\n            if (!string) {\n                return;\n            }\n            var abbr = /^#([a-fA-F0-9]{3})$/,\n                hex = /^#([a-fA-F0-9]{6})$/,\n                rgba = /^rgba?\\(\\s*([+-]?\\d+)\\s*,\\s*([+-]?\\d+)\\s*,\\s*([+-]?\\d+)\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)$/,\n                per = /^rgba?\\(\\s*([+-]?[\\d\\.]+)\\%\\s*,\\s*([+-]?[\\d\\.]+)\\%\\s*,\\s*([+-]?[\\d\\.]+)\\%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)$/,\n                keyword = /(\\w+)/;\n\n            var rgb = [0, 0, 0],\n                a = 1,\n                match = string.match(abbr);\n            if (match) {\n                match = match[1];\n                for (var i = 0; i < rgb.length; i++) {\n                    rgb[i] = parseInt(match[i] + match[i], 16);\n                }\n            }\n            else if (match = string.match(hex)) {\n                match = match[1];\n                for (var i = 0; i < rgb.length; i++) {\n                    rgb[i] = parseInt(match.slice(i * 2, i * 2 + 2), 16);\n                }\n            }\n            else if (match = string.match(rgba)) {\n                for (var i = 0; i < rgb.length; i++) {\n                    rgb[i] = parseInt(match[i + 1]);\n                }\n                a = parseFloat(match[4]);\n            }\n            else if (match = string.match(per)) {\n                for (var i = 0; i < rgb.length; i++) {\n                    rgb[i] = Math.round(parseFloat(match[i + 1]) * 2.55);\n                }\n                a = parseFloat(match[4]);\n            }\n            else if (match = string.match(keyword)) {\n                if (match[1] == \"transparent\") {\n                    return [0, 0, 0, 0];\n                }\n                rgb = colorNames[match[1]];\n                if (!rgb) {\n                    return;\n                }\n            }\n\n            for (var i = 0; i < rgb.length; i++) {\n                rgb[i] = scale(rgb[i], 0, 255);\n            }\n            if (!a && a != 0) {\n                a = 1;\n            }\n            else {\n                a = scale(a, 0, 1);\n            }\n            rgb[3] = a;\n            return rgb;\n        }\n\n        function getHsla(string) {\n            if (!string) {\n                return;\n            }\n            var hsl = /^hsla?\\(\\s*([+-]?\\d+)(?:deg)?\\s*,\\s*([+-]?[\\d\\.]+)%\\s*,\\s*([+-]?[\\d\\.]+)%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)/;\n            var match = string.match(hsl);\n            if (match) {\n                var alpha = parseFloat(match[4]);\n                var h = scale(parseInt(match[1]), 0, 360),\n                    s = scale(parseFloat(match[2]), 0, 100),\n                    l = scale(parseFloat(match[3]), 0, 100),\n                    a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);\n                return [h, s, l, a];\n            }\n        }\n\n        function getHwb(string) {\n            if (!string) {\n                return;\n            }\n            var hwb = /^hwb\\(\\s*([+-]?\\d+)(?:deg)?\\s*,\\s*([+-]?[\\d\\.]+)%\\s*,\\s*([+-]?[\\d\\.]+)%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)/;\n            var match = string.match(hwb);\n            if (match) {\n                var alpha = parseFloat(match[4]);\n                var h = scale(parseInt(match[1]), 0, 360),\n                    w = scale(parseFloat(match[2]), 0, 100),\n                    b = scale(parseFloat(match[3]), 0, 100),\n                    a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);\n                return [h, w, b, a];\n            }\n        }\n\n        function getRgb(string) {\n            var rgba = getRgba(string);\n            return rgba && rgba.slice(0, 3);\n        }\n\n        function getHsl(string) {\n            var hsla = getHsla(string);\n            return hsla && hsla.slice(0, 3);\n        }\n\n        function getAlpha(string) {\n            var vals = getRgba(string);\n            if (vals) {\n                return vals[3];\n            }\n            else if (vals = getHsla(string)) {\n                return vals[3];\n            }\n            else if (vals = getHwb(string)) {\n                return vals[3];\n            }\n        }\n\n        // generators\n        function hexString(rgb) {\n            return \"#\" + hexDouble(rgb[0]) + hexDouble(rgb[1])\n                + hexDouble(rgb[2]);\n        }\n\n        function rgbString(rgba, alpha) {\n            if (alpha < 1 || (rgba[3] && rgba[3] < 1)) {\n                return rgbaString(rgba, alpha);\n            }\n            return \"rgb(\" + rgba[0] + \", \" + rgba[1] + \", \" + rgba[2] + \")\";\n        }\n\n        function rgbaString(rgba, alpha) {\n            if (alpha === undefined) {\n                alpha = (rgba[3] !== undefined ? rgba[3] : 1);\n            }\n            return \"rgba(\" + rgba[0] + \", \" + rgba[1] + \", \" + rgba[2]\n                + \", \" + alpha + \")\";\n        }\n\n        function percentString(rgba, alpha) {\n            if (alpha < 1 || (rgba[3] && rgba[3] < 1)) {\n                return percentaString(rgba, alpha);\n            }\n            var r = Math.round(rgba[0] / 255 * 100),\n                g = Math.round(rgba[1] / 255 * 100),\n                b = Math.round(rgba[2] / 255 * 100);\n\n            return \"rgb(\" + r + \"%, \" + g + \"%, \" + b + \"%)\";\n        }\n\n        function percentaString(rgba, alpha) {\n            var r = Math.round(rgba[0] / 255 * 100),\n                g = Math.round(rgba[1] / 255 * 100),\n                b = Math.round(rgba[2] / 255 * 100);\n            return \"rgba(\" + r + \"%, \" + g + \"%, \" + b + \"%, \" + (alpha || rgba[3] || 1) + \")\";\n        }\n\n        function hslString(hsla, alpha) {\n            if (alpha < 1 || (hsla[3] && hsla[3] < 1)) {\n                return hslaString(hsla, alpha);\n            }\n            return \"hsl(\" + hsla[0] + \", \" + hsla[1] + \"%, \" + hsla[2] + \"%)\";\n        }\n\n        function hslaString(hsla, alpha) {\n            if (alpha === undefined) {\n                alpha = (hsla[3] !== undefined ? hsla[3] : 1);\n            }\n            return \"hsla(\" + hsla[0] + \", \" + hsla[1] + \"%, \" + hsla[2] + \"%, \"\n                + alpha + \")\";\n        }\n\n        // hwb is a bit different than rgb(a) & hsl(a) since there is no alpha specific syntax\n        // (hwb have alpha optional & 1 is default value)\n        function hwbString(hwb, alpha) {\n            if (alpha === undefined) {\n                alpha = (hwb[3] !== undefined ? hwb[3] : 1);\n            }\n            return \"hwb(\" + hwb[0] + \", \" + hwb[1] + \"%, \" + hwb[2] + \"%\"\n                + (alpha !== undefined && alpha !== 1 ? \", \" + alpha : \"\") + \")\";\n        }\n\n        function keyword(rgb) {\n            return reverseNames[rgb.slice(0, 3)];\n        }\n\n        // helpers\n        function scale(num, min, max) {\n            return Math.min(Math.max(min, num), max);\n        }\n\n        function hexDouble(num) {\n            var str = num.toString(16).toUpperCase();\n            return (str.length < 2) ? \"0\" + str : str;\n        }\n\n\n        //create a list of reverse color names\n        var reverseNames = {};\n        for (var name in colorNames) {\n            reverseNames[colorNames[name]] = name;\n        }\n\n    }, { \"color-name\": 6 }], 3: [function (require, module, exports) {\n        /* MIT license */\n\n        var convert = require(\"color-convert\"),\n            string = require(\"chartjs-color-string\");\n\n        var Color = function (obj) {\n            if (obj instanceof Color) return obj;\n            if (!(this instanceof Color)) return new Color(obj);\n\n            this.values = {\n                rgb: [0, 0, 0],\n                hsl: [0, 0, 0],\n                hsv: [0, 0, 0],\n                hwb: [0, 0, 0],\n                cmyk: [0, 0, 0, 0],\n                alpha: 1\n            }\n\n            // parse Color() argument\n            if (typeof obj == \"string\") {\n                var vals = string.getRgba(obj);\n                if (vals) {\n                    this.setValues(\"rgb\", vals);\n                } else if (vals = string.getHsla(obj)) {\n                    this.setValues(\"hsl\", vals);\n                } else if (vals = string.getHwb(obj)) {\n                    this.setValues(\"hwb\", vals);\n                } else {\n                    throw new Error(\"Unable to parse color from string \\\"\" + obj + \"\\\"\");\n                }\n            } else if (typeof obj == \"object\") {\n                var vals = obj;\n                if (vals[\"r\"] !== undefined || vals[\"red\"] !== undefined) {\n                    this.setValues(\"rgb\", vals)\n                } else if (vals[\"l\"] !== undefined || vals[\"lightness\"] !== undefined) {\n                    this.setValues(\"hsl\", vals)\n                } else if (vals[\"v\"] !== undefined || vals[\"value\"] !== undefined) {\n                    this.setValues(\"hsv\", vals)\n                } else if (vals[\"w\"] !== undefined || vals[\"whiteness\"] !== undefined) {\n                    this.setValues(\"hwb\", vals)\n                } else if (vals[\"c\"] !== undefined || vals[\"cyan\"] !== undefined) {\n                    this.setValues(\"cmyk\", vals)\n                } else {\n                    throw new Error(\"Unable to parse color from object \" + JSON.stringify(obj));\n                }\n            }\n        }\n\n        Color.prototype = {\n            rgb: function (vals) {\n                return this.setSpace(\"rgb\", arguments);\n            },\n            hsl: function (vals) {\n                return this.setSpace(\"hsl\", arguments);\n            },\n            hsv: function (vals) {\n                return this.setSpace(\"hsv\", arguments);\n            },\n            hwb: function (vals) {\n                return this.setSpace(\"hwb\", arguments);\n            },\n            cmyk: function (vals) {\n                return this.setSpace(\"cmyk\", arguments);\n            },\n\n            rgbArray: function () {\n                return this.values.rgb;\n            },\n            hslArray: function () {\n                return this.values.hsl;\n            },\n            hsvArray: function () {\n                return this.values.hsv;\n            },\n            hwbArray: function () {\n                if (this.values.alpha !== 1) {\n                    return this.values.hwb.concat([this.values.alpha])\n                }\n                return this.values.hwb;\n            },\n            cmykArray: function () {\n                return this.values.cmyk;\n            },\n            rgbaArray: function () {\n                var rgb = this.values.rgb;\n                return rgb.concat([this.values.alpha]);\n            },\n            hslaArray: function () {\n                var hsl = this.values.hsl;\n                return hsl.concat([this.values.alpha]);\n            },\n            alpha: function (val) {\n                if (val === undefined) {\n                    return this.values.alpha;\n                }\n                this.setValues(\"alpha\", val);\n                return this;\n            },\n\n            red: function (val) {\n                return this.setChannel(\"rgb\", 0, val);\n            },\n            green: function (val) {\n                return this.setChannel(\"rgb\", 1, val);\n            },\n            blue: function (val) {\n                return this.setChannel(\"rgb\", 2, val);\n            },\n            hue: function (val) {\n                return this.setChannel(\"hsl\", 0, val);\n            },\n            saturation: function (val) {\n                return this.setChannel(\"hsl\", 1, val);\n            },\n            lightness: function (val) {\n                return this.setChannel(\"hsl\", 2, val);\n            },\n            saturationv: function (val) {\n                return this.setChannel(\"hsv\", 1, val);\n            },\n            whiteness: function (val) {\n                return this.setChannel(\"hwb\", 1, val);\n            },\n            blackness: function (val) {\n                return this.setChannel(\"hwb\", 2, val);\n            },\n            value: function (val) {\n                return this.setChannel(\"hsv\", 2, val);\n            },\n            cyan: function (val) {\n                return this.setChannel(\"cmyk\", 0, val);\n            },\n            magenta: function (val) {\n                return this.setChannel(\"cmyk\", 1, val);\n            },\n            yellow: function (val) {\n                return this.setChannel(\"cmyk\", 2, val);\n            },\n            black: function (val) {\n                return this.setChannel(\"cmyk\", 3, val);\n            },\n\n            hexString: function () {\n                return string.hexString(this.values.rgb);\n            },\n            rgbString: function () {\n                return string.rgbString(this.values.rgb, this.values.alpha);\n            },\n            rgbaString: function () {\n                return string.rgbaString(this.values.rgb, this.values.alpha);\n            },\n            percentString: function () {\n                return string.percentString(this.values.rgb, this.values.alpha);\n            },\n            hslString: function () {\n                return string.hslString(this.values.hsl, this.values.alpha);\n            },\n            hslaString: function () {\n                return string.hslaString(this.values.hsl, this.values.alpha);\n            },\n            hwbString: function () {\n                return string.hwbString(this.values.hwb, this.values.alpha);\n            },\n            keyword: function () {\n                return string.keyword(this.values.rgb, this.values.alpha);\n            },\n\n            rgbNumber: function () {\n                return (this.values.rgb[0] << 16) | (this.values.rgb[1] << 8) | this.values.rgb[2];\n            },\n\n            luminosity: function () {\n                // http://www.w3.org/TR/WCAG20/#relativeluminancedef\n                var rgb = this.values.rgb;\n                var lum = [];\n                for (var i = 0; i < rgb.length; i++) {\n                    var chan = rgb[i] / 255;\n                    lum[i] = (chan <= 0.03928) ? chan / 12.92 : Math.pow(((chan + 0.055) / 1.055), 2.4)\n                }\n                return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];\n            },\n\n            contrast: function (color2) {\n                // http://www.w3.org/TR/WCAG20/#contrast-ratiodef\n                var lum1 = this.luminosity();\n                var lum2 = color2.luminosity();\n                if (lum1 > lum2) {\n                    return (lum1 + 0.05) / (lum2 + 0.05)\n                };\n                return (lum2 + 0.05) / (lum1 + 0.05);\n            },\n\n            level: function (color2) {\n                var contrastRatio = this.contrast(color2);\n                return (contrastRatio >= 7.1) ? 'AAA' : (contrastRatio >= 4.5) ? 'AA' : '';\n            },\n\n            dark: function () {\n                // YIQ equation from http://24ways.org/2010/calculating-color-contrast\n                var rgb = this.values.rgb,\n                    yiq = (rgb[0] * 299 + rgb[1] * 587 + rgb[2] * 114) / 1000;\n                return yiq < 128;\n            },\n\n            light: function () {\n                return !this.dark();\n            },\n\n            negate: function () {\n                var rgb = []\n                for (var i = 0; i < 3; i++) {\n                    rgb[i] = 255 - this.values.rgb[i];\n                }\n                this.setValues(\"rgb\", rgb);\n                return this;\n            },\n\n            lighten: function (ratio) {\n                this.values.hsl[2] += this.values.hsl[2] * ratio;\n                this.setValues(\"hsl\", this.values.hsl);\n                return this;\n            },\n\n            darken: function (ratio) {\n                this.values.hsl[2] -= this.values.hsl[2] * ratio;\n                this.setValues(\"hsl\", this.values.hsl);\n                return this;\n            },\n\n            saturate: function (ratio) {\n                this.values.hsl[1] += this.values.hsl[1] * ratio;\n                this.setValues(\"hsl\", this.values.hsl);\n                return this;\n            },\n\n            desaturate: function (ratio) {\n                this.values.hsl[1] -= this.values.hsl[1] * ratio;\n                this.setValues(\"hsl\", this.values.hsl);\n                return this;\n            },\n\n            whiten: function (ratio) {\n                this.values.hwb[1] += this.values.hwb[1] * ratio;\n                this.setValues(\"hwb\", this.values.hwb);\n                return this;\n            },\n\n            blacken: function (ratio) {\n                this.values.hwb[2] += this.values.hwb[2] * ratio;\n                this.setValues(\"hwb\", this.values.hwb);\n                return this;\n            },\n\n            greyscale: function () {\n                var rgb = this.values.rgb;\n                // http://en.wikipedia.org/wiki/Grayscale#Converting_color_to_grayscale\n                var val = rgb[0] * 0.3 + rgb[1] * 0.59 + rgb[2] * 0.11;\n                this.setValues(\"rgb\", [val, val, val]);\n                return this;\n            },\n\n            clearer: function (ratio) {\n                this.setValues(\"alpha\", this.values.alpha - (this.values.alpha * ratio));\n                return this;\n            },\n\n            opaquer: function (ratio) {\n                this.setValues(\"alpha\", this.values.alpha + (this.values.alpha * ratio));\n                return this;\n            },\n\n            rotate: function (degrees) {\n                var hue = this.values.hsl[0];\n                hue = (hue + degrees) % 360;\n                hue = hue < 0 ? 360 + hue : hue;\n                this.values.hsl[0] = hue;\n                this.setValues(\"hsl\", this.values.hsl);\n                return this;\n            },\n\n            mix: function (color2, weight) {\n                weight = 1 - (weight == null ? 0.5 : weight);\n\n                // algorithm from Sass's mix(). Ratio of first color in mix is\n                // determined by the alphas of both colors and the weight\n                var t1 = weight * 2 - 1,\n                    d = this.alpha() - color2.alpha();\n\n                var weight1 = (((t1 * d == -1) ? t1 : (t1 + d) / (1 + t1 * d)) + 1) / 2;\n                var weight2 = 1 - weight1;\n\n                var rgb = this.rgbArray();\n                var rgb2 = color2.rgbArray();\n\n                for (var i = 0; i < rgb.length; i++) {\n                    rgb[i] = rgb[i] * weight1 + rgb2[i] * weight2;\n                }\n                this.setValues(\"rgb\", rgb);\n\n                var alpha = this.alpha() * weight + color2.alpha() * (1 - weight);\n                this.setValues(\"alpha\", alpha);\n\n                return this;\n            },\n\n            toJSON: function () {\n                return this.rgb();\n            },\n\n            clone: function () {\n                return new Color(this.rgb());\n            }\n        }\n\n\n        Color.prototype.getValues = function (space) {\n            var vals = {};\n            for (var i = 0; i < space.length; i++) {\n                vals[space.charAt(i)] = this.values[space][i];\n            }\n            if (this.values.alpha != 1) {\n                vals[\"a\"] = this.values.alpha;\n            }\n            // {r: 255, g: 255, b: 255, a: 0.4}\n            return vals;\n        }\n\n        Color.prototype.setValues = function (space, vals) {\n            var spaces = {\n                \"rgb\": [\"red\", \"green\", \"blue\"],\n                \"hsl\": [\"hue\", \"saturation\", \"lightness\"],\n                \"hsv\": [\"hue\", \"saturation\", \"value\"],\n                \"hwb\": [\"hue\", \"whiteness\", \"blackness\"],\n                \"cmyk\": [\"cyan\", \"magenta\", \"yellow\", \"black\"]\n            };\n\n            var maxes = {\n                \"rgb\": [255, 255, 255],\n                \"hsl\": [360, 100, 100],\n                \"hsv\": [360, 100, 100],\n                \"hwb\": [360, 100, 100],\n                \"cmyk\": [100, 100, 100, 100]\n            };\n\n            var alpha = 1;\n            if (space == \"alpha\") {\n                alpha = vals;\n            } else if (vals.length) {\n                // [10, 10, 10]\n                this.values[space] = vals.slice(0, space.length);\n                alpha = vals[space.length];\n            } else if (vals[space.charAt(0)] !== undefined) {\n                // {r: 10, g: 10, b: 10}\n                for (var i = 0; i < space.length; i++) {\n                    this.values[space][i] = vals[space.charAt(i)];\n                }\n                alpha = vals.a;\n            } else if (vals[spaces[space][0]] !== undefined) {\n                // {red: 10, green: 10, blue: 10}\n                var chans = spaces[space];\n                for (var i = 0; i < space.length; i++) {\n                    this.values[space][i] = vals[chans[i]];\n                }\n                alpha = vals.alpha;\n            }\n            this.values.alpha = Math.max(0, Math.min(1, (alpha !== undefined ? alpha : this.values.alpha)));\n            if (space == \"alpha\") {\n                return;\n            }\n\n            // cap values of the space prior converting all values\n            for (var i = 0; i < space.length; i++) {\n                var capped = Math.max(0, Math.min(maxes[space][i], this.values[space][i]));\n                this.values[space][i] = Math.round(capped);\n            }\n\n            // convert to all the other color spaces\n            for (var sname in spaces) {\n                if (sname != space) {\n                    this.values[sname] = convert[space][sname](this.values[space])\n                }\n\n                // cap values\n                for (var i = 0; i < sname.length; i++) {\n                    var capped = Math.max(0, Math.min(maxes[sname][i], this.values[sname][i]));\n                    this.values[sname][i] = Math.round(capped);\n                }\n            }\n            return true;\n        }\n\n        Color.prototype.setSpace = function (space, args) {\n            var vals = args[0];\n            if (vals === undefined) {\n                // color.rgb()\n                return this.getValues(space);\n            }\n            // color.rgb(10, 10, 10)\n            if (typeof vals == \"number\") {\n                vals = Array.prototype.slice.call(args);\n            }\n            this.setValues(space, vals);\n            return this;\n        }\n\n        Color.prototype.setChannel = function (space, index, val) {\n            if (val === undefined) {\n                // color.red()\n                return this.values[space][index];\n            }\n            // color.red(100)\n            this.values[space][index] = val;\n            this.setValues(space, this.values[space]);\n            return this;\n        }\n\n        window.Color = module.exports = Color\n\n    }, { \"chartjs-color-string\": 2, \"color-convert\": 5 }], 4: [function (require, module, exports) {\n        /* MIT license */\n\n        module.exports = {\n            rgb2hsl: rgb2hsl,\n            rgb2hsv: rgb2hsv,\n            rgb2hwb: rgb2hwb,\n            rgb2cmyk: rgb2cmyk,\n            rgb2keyword: rgb2keyword,\n            rgb2xyz: rgb2xyz,\n            rgb2lab: rgb2lab,\n            rgb2lch: rgb2lch,\n\n            hsl2rgb: hsl2rgb,\n            hsl2hsv: hsl2hsv,\n            hsl2hwb: hsl2hwb,\n            hsl2cmyk: hsl2cmyk,\n            hsl2keyword: hsl2keyword,\n\n            hsv2rgb: hsv2rgb,\n            hsv2hsl: hsv2hsl,\n            hsv2hwb: hsv2hwb,\n            hsv2cmyk: hsv2cmyk,\n            hsv2keyword: hsv2keyword,\n\n            hwb2rgb: hwb2rgb,\n            hwb2hsl: hwb2hsl,\n            hwb2hsv: hwb2hsv,\n            hwb2cmyk: hwb2cmyk,\n            hwb2keyword: hwb2keyword,\n\n            cmyk2rgb: cmyk2rgb,\n            cmyk2hsl: cmyk2hsl,\n            cmyk2hsv: cmyk2hsv,\n            cmyk2hwb: cmyk2hwb,\n            cmyk2keyword: cmyk2keyword,\n\n            keyword2rgb: keyword2rgb,\n            keyword2hsl: keyword2hsl,\n            keyword2hsv: keyword2hsv,\n            keyword2hwb: keyword2hwb,\n            keyword2cmyk: keyword2cmyk,\n            keyword2lab: keyword2lab,\n            keyword2xyz: keyword2xyz,\n\n            xyz2rgb: xyz2rgb,\n            xyz2lab: xyz2lab,\n            xyz2lch: xyz2lch,\n\n            lab2xyz: lab2xyz,\n            lab2rgb: lab2rgb,\n            lab2lch: lab2lch,\n\n            lch2lab: lch2lab,\n            lch2xyz: lch2xyz,\n            lch2rgb: lch2rgb\n        }\n\n\n        function rgb2hsl(rgb) {\n            var r = rgb[0] / 255,\n                g = rgb[1] / 255,\n                b = rgb[2] / 255,\n                min = Math.min(r, g, b),\n                max = Math.max(r, g, b),\n                delta = max - min,\n                h, s, l;\n\n            if (max == min)\n                h = 0;\n            else if (r == max)\n                h = (g - b) / delta;\n            else if (g == max)\n                h = 2 + (b - r) / delta;\n            else if (b == max)\n                h = 4 + (r - g) / delta;\n\n            h = Math.min(h * 60, 360);\n\n            if (h < 0)\n                h += 360;\n\n            l = (min + max) / 2;\n\n            if (max == min)\n                s = 0;\n            else if (l <= 0.5)\n                s = delta / (max + min);\n            else\n                s = delta / (2 - max - min);\n\n            return [h, s * 100, l * 100];\n        }\n\n        function rgb2hsv(rgb) {\n            var r = rgb[0],\n                g = rgb[1],\n                b = rgb[2],\n                min = Math.min(r, g, b),\n                max = Math.max(r, g, b),\n                delta = max - min,\n                h, s, v;\n\n            if (max == 0)\n                s = 0;\n            else\n                s = (delta / max * 1000) / 10;\n\n            if (max == min)\n                h = 0;\n            else if (r == max)\n                h = (g - b) / delta;\n            else if (g == max)\n                h = 2 + (b - r) / delta;\n            else if (b == max)\n                h = 4 + (r - g) / delta;\n\n            h = Math.min(h * 60, 360);\n\n            if (h < 0)\n                h += 360;\n\n            v = ((max / 255) * 1000) / 10;\n\n            return [h, s, v];\n        }\n\n        function rgb2hwb(rgb) {\n            var r = rgb[0],\n                g = rgb[1],\n                b = rgb[2],\n                h = rgb2hsl(rgb)[0],\n                w = 1 / 255 * Math.min(r, Math.min(g, b)),\n                b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));\n\n            return [h, w * 100, b * 100];\n        }\n\n        function rgb2cmyk(rgb) {\n            var r = rgb[0] / 255,\n                g = rgb[1] / 255,\n                b = rgb[2] / 255,\n                c, m, y, k;\n\n            k = Math.min(1 - r, 1 - g, 1 - b);\n            c = (1 - r - k) / (1 - k) || 0;\n            m = (1 - g - k) / (1 - k) || 0;\n            y = (1 - b - k) / (1 - k) || 0;\n            return [c * 100, m * 100, y * 100, k * 100];\n        }\n\n        function rgb2keyword(rgb) {\n            return reverseKeywords[JSON.stringify(rgb)];\n        }\n\n        function rgb2xyz(rgb) {\n            var r = rgb[0] / 255,\n                g = rgb[1] / 255,\n                b = rgb[2] / 255;\n\n            // assume sRGB\n            r = r > 0.04045 ? Math.pow(((r + 0.055) / 1.055), 2.4) : (r / 12.92);\n            g = g > 0.04045 ? Math.pow(((g + 0.055) / 1.055), 2.4) : (g / 12.92);\n            b = b > 0.04045 ? Math.pow(((b + 0.055) / 1.055), 2.4) : (b / 12.92);\n\n            var x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);\n            var y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);\n            var z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);\n\n            return [x * 100, y * 100, z * 100];\n        }\n\n        function rgb2lab(rgb) {\n            var xyz = rgb2xyz(rgb),\n                x = xyz[0],\n                y = xyz[1],\n                z = xyz[2],\n                l, a, b;\n\n            x /= 95.047;\n            y /= 100;\n            z /= 108.883;\n\n            x = x > 0.008856 ? Math.pow(x, 1 / 3) : (7.787 * x) + (16 / 116);\n            y = y > 0.008856 ? Math.pow(y, 1 / 3) : (7.787 * y) + (16 / 116);\n            z = z > 0.008856 ? Math.pow(z, 1 / 3) : (7.787 * z) + (16 / 116);\n\n            l = (116 * y) - 16;\n            a = 500 * (x - y);\n            b = 200 * (y - z);\n\n            return [l, a, b];\n        }\n\n        function rgb2lch(args) {\n            return lab2lch(rgb2lab(args));\n        }\n\n        function hsl2rgb(hsl) {\n            var h = hsl[0] / 360,\n                s = hsl[1] / 100,\n                l = hsl[2] / 100,\n                t1, t2, t3, rgb, val;\n\n            if (s == 0) {\n                val = l * 255;\n                return [val, val, val];\n            }\n\n            if (l < 0.5)\n                t2 = l * (1 + s);\n            else\n                t2 = l + s - l * s;\n            t1 = 2 * l - t2;\n\n            rgb = [0, 0, 0];\n            for (var i = 0; i < 3; i++) {\n                t3 = h + 1 / 3 * - (i - 1);\n                t3 < 0 && t3++;\n                t3 > 1 && t3--;\n\n                if (6 * t3 < 1)\n                    val = t1 + (t2 - t1) * 6 * t3;\n                else if (2 * t3 < 1)\n                    val = t2;\n                else if (3 * t3 < 2)\n                    val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;\n                else\n                    val = t1;\n\n                rgb[i] = val * 255;\n            }\n\n            return rgb;\n        }\n\n        function hsl2hsv(hsl) {\n            var h = hsl[0],\n                s = hsl[1] / 100,\n                l = hsl[2] / 100,\n                sv, v;\n\n            if (l === 0) {\n                // no need to do calc on black\n                // also avoids divide by 0 error\n                return [0, 0, 0];\n            }\n\n            l *= 2;\n            s *= (l <= 1) ? l : 2 - l;\n            v = (l + s) / 2;\n            sv = (2 * s) / (l + s);\n            return [h, sv * 100, v * 100];\n        }\n\n        function hsl2hwb(args) {\n            return rgb2hwb(hsl2rgb(args));\n        }\n\n        function hsl2cmyk(args) {\n            return rgb2cmyk(hsl2rgb(args));\n        }\n\n        function hsl2keyword(args) {\n            return rgb2keyword(hsl2rgb(args));\n        }\n\n\n        function hsv2rgb(hsv) {\n            var h = hsv[0] / 60,\n                s = hsv[1] / 100,\n                v = hsv[2] / 100,\n                hi = Math.floor(h) % 6;\n\n            var f = h - Math.floor(h),\n                p = 255 * v * (1 - s),\n                q = 255 * v * (1 - (s * f)),\n                t = 255 * v * (1 - (s * (1 - f))),\n                v = 255 * v;\n\n            switch (hi) {\n                case 0:\n                    return [v, t, p];\n                case 1:\n                    return [q, v, p];\n                case 2:\n                    return [p, v, t];\n                case 3:\n                    return [p, q, v];\n                case 4:\n                    return [t, p, v];\n                case 5:\n                    return [v, p, q];\n            }\n        }\n\n        function hsv2hsl(hsv) {\n            var h = hsv[0],\n                s = hsv[1] / 100,\n                v = hsv[2] / 100,\n                sl, l;\n\n            l = (2 - s) * v;\n            sl = s * v;\n            sl /= (l <= 1) ? l : 2 - l;\n            sl = sl || 0;\n            l /= 2;\n            return [h, sl * 100, l * 100];\n        }\n\n        function hsv2hwb(args) {\n            return rgb2hwb(hsv2rgb(args))\n        }\n\n        function hsv2cmyk(args) {\n            return rgb2cmyk(hsv2rgb(args));\n        }\n\n        function hsv2keyword(args) {\n            return rgb2keyword(hsv2rgb(args));\n        }\n\n        // http://dev.w3.org/csswg/css-color/#hwb-to-rgb\n        function hwb2rgb(hwb) {\n            var h = hwb[0] / 360,\n                wh = hwb[1] / 100,\n                bl = hwb[2] / 100,\n                ratio = wh + bl,\n                i, v, f, n;\n\n            // wh + bl cant be > 1\n            if (ratio > 1) {\n                wh /= ratio;\n                bl /= ratio;\n            }\n\n            i = Math.floor(6 * h);\n            v = 1 - bl;\n            f = 6 * h - i;\n            if ((i & 0x01) != 0) {\n                f = 1 - f;\n            }\n            n = wh + f * (v - wh);  // linear interpolation\n\n            switch (i) {\n                default:\n                case 6:\n                case 0: r = v; g = n; b = wh; break;\n                case 1: r = n; g = v; b = wh; break;\n                case 2: r = wh; g = v; b = n; break;\n                case 3: r = wh; g = n; b = v; break;\n                case 4: r = n; g = wh; b = v; break;\n                case 5: r = v; g = wh; b = n; break;\n            }\n\n            return [r * 255, g * 255, b * 255];\n        }\n\n        function hwb2hsl(args) {\n            return rgb2hsl(hwb2rgb(args));\n        }\n\n        function hwb2hsv(args) {\n            return rgb2hsv(hwb2rgb(args));\n        }\n\n        function hwb2cmyk(args) {\n            return rgb2cmyk(hwb2rgb(args));\n        }\n\n        function hwb2keyword(args) {\n            return rgb2keyword(hwb2rgb(args));\n        }\n\n        function cmyk2rgb(cmyk) {\n            var c = cmyk[0] / 100,\n                m = cmyk[1] / 100,\n                y = cmyk[2] / 100,\n                k = cmyk[3] / 100,\n                r, g, b;\n\n            r = 1 - Math.min(1, c * (1 - k) + k);\n            g = 1 - Math.min(1, m * (1 - k) + k);\n            b = 1 - Math.min(1, y * (1 - k) + k);\n            return [r * 255, g * 255, b * 255];\n        }\n\n        function cmyk2hsl(args) {\n            return rgb2hsl(cmyk2rgb(args));\n        }\n\n        function cmyk2hsv(args) {\n            return rgb2hsv(cmyk2rgb(args));\n        }\n\n        function cmyk2hwb(args) {\n            return rgb2hwb(cmyk2rgb(args));\n        }\n\n        function cmyk2keyword(args) {\n            return rgb2keyword(cmyk2rgb(args));\n        }\n\n\n        function xyz2rgb(xyz) {\n            var x = xyz[0] / 100,\n                y = xyz[1] / 100,\n                z = xyz[2] / 100,\n                r, g, b;\n\n            r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);\n            g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);\n            b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);\n\n            // assume sRGB\n            r = r > 0.0031308 ? ((1.055 * Math.pow(r, 1.0 / 2.4)) - 0.055)\n                : r = (r * 12.92);\n\n            g = g > 0.0031308 ? ((1.055 * Math.pow(g, 1.0 / 2.4)) - 0.055)\n                : g = (g * 12.92);\n\n            b = b > 0.0031308 ? ((1.055 * Math.pow(b, 1.0 / 2.4)) - 0.055)\n                : b = (b * 12.92);\n\n            r = Math.min(Math.max(0, r), 1);\n            g = Math.min(Math.max(0, g), 1);\n            b = Math.min(Math.max(0, b), 1);\n\n            return [r * 255, g * 255, b * 255];\n        }\n\n        function xyz2lab(xyz) {\n            var x = xyz[0],\n                y = xyz[1],\n                z = xyz[2],\n                l, a, b;\n\n            x /= 95.047;\n            y /= 100;\n            z /= 108.883;\n\n            x = x > 0.008856 ? Math.pow(x, 1 / 3) : (7.787 * x) + (16 / 116);\n            y = y > 0.008856 ? Math.pow(y, 1 / 3) : (7.787 * y) + (16 / 116);\n            z = z > 0.008856 ? Math.pow(z, 1 / 3) : (7.787 * z) + (16 / 116);\n\n            l = (116 * y) - 16;\n            a = 500 * (x - y);\n            b = 200 * (y - z);\n\n            return [l, a, b];\n        }\n\n        function xyz2lch(args) {\n            return lab2lch(xyz2lab(args));\n        }\n\n        function lab2xyz(lab) {\n            var l = lab[0],\n                a = lab[1],\n                b = lab[2],\n                x, y, z, y2;\n\n            if (l <= 8) {\n                y = (l * 100) / 903.3;\n                y2 = (7.787 * (y / 100)) + (16 / 116);\n            } else {\n                y = 100 * Math.pow((l + 16) / 116, 3);\n                y2 = Math.pow(y / 100, 1 / 3);\n            }\n\n            x = x / 95.047 <= 0.008856 ? x = (95.047 * ((a / 500) + y2 - (16 / 116))) / 7.787 : 95.047 * Math.pow((a / 500) + y2, 3);\n\n            z = z / 108.883 <= 0.008859 ? z = (108.883 * (y2 - (b / 200) - (16 / 116))) / 7.787 : 108.883 * Math.pow(y2 - (b / 200), 3);\n\n            return [x, y, z];\n        }\n\n        function lab2lch(lab) {\n            var l = lab[0],\n                a = lab[1],\n                b = lab[2],\n                hr, h, c;\n\n            hr = Math.atan2(b, a);\n            h = hr * 360 / 2 / Math.PI;\n            if (h < 0) {\n                h += 360;\n            }\n            c = Math.sqrt(a * a + b * b);\n            return [l, c, h];\n        }\n\n        function lab2rgb(args) {\n            return xyz2rgb(lab2xyz(args));\n        }\n\n        function lch2lab(lch) {\n            var l = lch[0],\n                c = lch[1],\n                h = lch[2],\n                a, b, hr;\n\n            hr = h / 360 * 2 * Math.PI;\n            a = c * Math.cos(hr);\n            b = c * Math.sin(hr);\n            return [l, a, b];\n        }\n\n        function lch2xyz(args) {\n            return lab2xyz(lch2lab(args));\n        }\n\n        function lch2rgb(args) {\n            return lab2rgb(lch2lab(args));\n        }\n\n        function keyword2rgb(keyword) {\n            return cssKeywords[keyword];\n        }\n\n        function keyword2hsl(args) {\n            return rgb2hsl(keyword2rgb(args));\n        }\n\n        function keyword2hsv(args) {\n            return rgb2hsv(keyword2rgb(args));\n        }\n\n        function keyword2hwb(args) {\n            return rgb2hwb(keyword2rgb(args));\n        }\n\n        function keyword2cmyk(args) {\n            return rgb2cmyk(keyword2rgb(args));\n        }\n\n        function keyword2lab(args) {\n            return rgb2lab(keyword2rgb(args));\n        }\n\n        function keyword2xyz(args) {\n            return rgb2xyz(keyword2rgb(args));\n        }\n\n        var cssKeywords = {\n            aliceblue: [240, 248, 255],\n            antiquewhite: [250, 235, 215],\n            aqua: [0, 255, 255],\n            aquamarine: [127, 255, 212],\n            azure: [240, 255, 255],\n            beige: [245, 245, 220],\n            bisque: [255, 228, 196],\n            black: [0, 0, 0],\n            blanchedalmond: [255, 235, 205],\n            blue: [0, 0, 255],\n            blueviolet: [138, 43, 226],\n            brown: [165, 42, 42],\n            burlywood: [222, 184, 135],\n            cadetblue: [95, 158, 160],\n            chartreuse: [127, 255, 0],\n            chocolate: [210, 105, 30],\n            coral: [255, 127, 80],\n            cornflowerblue: [100, 149, 237],\n            cornsilk: [255, 248, 220],\n            crimson: [220, 20, 60],\n            cyan: [0, 255, 255],\n            darkblue: [0, 0, 139],\n            darkcyan: [0, 139, 139],\n            darkgoldenrod: [184, 134, 11],\n            darkgray: [169, 169, 169],\n            darkgreen: [0, 100, 0],\n            darkgrey: [169, 169, 169],\n            darkkhaki: [189, 183, 107],\n            darkmagenta: [139, 0, 139],\n            darkolivegreen: [85, 107, 47],\n            darkorange: [255, 140, 0],\n            darkorchid: [153, 50, 204],\n            darkred: [139, 0, 0],\n            darksalmon: [233, 150, 122],\n            darkseagreen: [143, 188, 143],\n            darkslateblue: [72, 61, 139],\n            darkslategray: [47, 79, 79],\n            darkslategrey: [47, 79, 79],\n            darkturquoise: [0, 206, 209],\n            darkviolet: [148, 0, 211],\n            deeppink: [255, 20, 147],\n            deepskyblue: [0, 191, 255],\n            dimgray: [105, 105, 105],\n            dimgrey: [105, 105, 105],\n            dodgerblue: [30, 144, 255],\n            firebrick: [178, 34, 34],\n            floralwhite: [255, 250, 240],\n            forestgreen: [34, 139, 34],\n            fuchsia: [255, 0, 255],\n            gainsboro: [220, 220, 220],\n            ghostwhite: [248, 248, 255],\n            gold: [255, 215, 0],\n            goldenrod: [218, 165, 32],\n            gray: [128, 128, 128],\n            green: [0, 128, 0],\n            greenyellow: [173, 255, 47],\n            grey: [128, 128, 128],\n            honeydew: [240, 255, 240],\n            hotpink: [255, 105, 180],\n            indianred: [205, 92, 92],\n            indigo: [75, 0, 130],\n            ivory: [255, 255, 240],\n            khaki: [240, 230, 140],\n            lavender: [230, 230, 250],\n            lavenderblush: [255, 240, 245],\n            lawngreen: [124, 252, 0],\n            lemonchiffon: [255, 250, 205],\n            lightblue: [173, 216, 230],\n            lightcoral: [240, 128, 128],\n            lightcyan: [224, 255, 255],\n            lightgoldenrodyellow: [250, 250, 210],\n            lightgray: [211, 211, 211],\n            lightgreen: [144, 238, 144],\n            lightgrey: [211, 211, 211],\n            lightpink: [255, 182, 193],\n            lightsalmon: [255, 160, 122],\n            lightseagreen: [32, 178, 170],\n            lightskyblue: [135, 206, 250],\n            lightslategray: [119, 136, 153],\n            lightslategrey: [119, 136, 153],\n            lightsteelblue: [176, 196, 222],\n            lightyellow: [255, 255, 224],\n            lime: [0, 255, 0],\n            limegreen: [50, 205, 50],\n            linen: [250, 240, 230],\n            magenta: [255, 0, 255],\n            maroon: [128, 0, 0],\n            mediumaquamarine: [102, 205, 170],\n            mediumblue: [0, 0, 205],\n            mediumorchid: [186, 85, 211],\n            mediumpurple: [147, 112, 219],\n            mediumseagreen: [60, 179, 113],\n            mediumslateblue: [123, 104, 238],\n            mediumspringgreen: [0, 250, 154],\n            mediumturquoise: [72, 209, 204],\n            mediumvioletred: [199, 21, 133],\n            midnightblue: [25, 25, 112],\n            mintcream: [245, 255, 250],\n            mistyrose: [255, 228, 225],\n            moccasin: [255, 228, 181],\n            navajowhite: [255, 222, 173],\n            navy: [0, 0, 128],\n            oldlace: [253, 245, 230],\n            olive: [128, 128, 0],\n            olivedrab: [107, 142, 35],\n            orange: [255, 165, 0],\n            orangered: [255, 69, 0],\n            orchid: [218, 112, 214],\n            palegoldenrod: [238, 232, 170],\n            palegreen: [152, 251, 152],\n            paleturquoise: [175, 238, 238],\n            palevioletred: [219, 112, 147],\n            papayawhip: [255, 239, 213],\n            peachpuff: [255, 218, 185],\n            peru: [205, 133, 63],\n            pink: [255, 192, 203],\n            plum: [221, 160, 221],\n            powderblue: [176, 224, 230],\n            purple: [128, 0, 128],\n            rebeccapurple: [102, 51, 153],\n            red: [255, 0, 0],\n            rosybrown: [188, 143, 143],\n            royalblue: [65, 105, 225],\n            saddlebrown: [139, 69, 19],\n            salmon: [250, 128, 114],\n            sandybrown: [244, 164, 96],\n            seagreen: [46, 139, 87],\n            seashell: [255, 245, 238],\n            sienna: [160, 82, 45],\n            silver: [192, 192, 192],\n            skyblue: [135, 206, 235],\n            slateblue: [106, 90, 205],\n            slategray: [112, 128, 144],\n            slategrey: [112, 128, 144],\n            snow: [255, 250, 250],\n            springgreen: [0, 255, 127],\n            steelblue: [70, 130, 180],\n            tan: [210, 180, 140],\n            teal: [0, 128, 128],\n            thistle: [216, 191, 216],\n            tomato: [255, 99, 71],\n            turquoise: [64, 224, 208],\n            violet: [238, 130, 238],\n            wheat: [245, 222, 179],\n            white: [255, 255, 255],\n            whitesmoke: [245, 245, 245],\n            yellow: [255, 255, 0],\n            yellowgreen: [154, 205, 50]\n        };\n\n        var reverseKeywords = {};\n        for (var key in cssKeywords) {\n            reverseKeywords[JSON.stringify(cssKeywords[key])] = key;\n        }\n\n    }, {}], 5: [function (require, module, exports) {\n        var conversions = require(\"./conversions\");\n\n        var convert = function () {\n            return new Converter();\n        }\n\n        for (var func in conversions) {\n            // export Raw versions\n            convert[func + \"Raw\"] = (function (func) {\n                // accept array or plain args\n                return function (arg) {\n                    if (typeof arg == \"number\")\n                        arg = Array.prototype.slice.call(arguments);\n                    return conversions[func](arg);\n                }\n            })(func);\n\n            var pair = /(\\w+)2(\\w+)/.exec(func),\n                from = pair[1],\n                to = pair[2];\n\n            // export rgb2hsl and [\"rgb\"][\"hsl\"]\n            convert[from] = convert[from] || {};\n\n            convert[from][to] = convert[func] = (function (func) {\n                return function (arg) {\n                    if (typeof arg == \"number\")\n                        arg = Array.prototype.slice.call(arguments);\n\n                    var val = conversions[func](arg);\n                    if (typeof val == \"string\" || val === undefined)\n                        return val; // keyword\n\n                    for (var i = 0; i < val.length; i++)\n                        val[i] = Math.round(val[i]);\n                    return val;\n                }\n            })(func);\n        }\n\n\n        /* Converter does lazy conversion and caching */\n        var Converter = function () {\n            this.convs = {};\n        };\n\n        /* Either get the values for a space or\n         set the values for a space, depending on args */\n        Converter.prototype.routeSpace = function (space, args) {\n            var values = args[0];\n            if (values === undefined) {\n                // color.rgb()\n                return this.getValues(space);\n            }\n            // color.rgb(10, 10, 10)\n            if (typeof values == \"number\") {\n                values = Array.prototype.slice.call(args);\n            }\n\n            return this.setValues(space, values);\n        };\n\n        /* Set the values for a space, invalidating cache */\n        Converter.prototype.setValues = function (space, values) {\n            this.space = space;\n            this.convs = {};\n            this.convs[space] = values;\n            return this;\n        };\n\n        /* Get the values for a space. If there's already\n         a conversion for the space, fetch it, otherwise\n         compute it */\n        Converter.prototype.getValues = function (space) {\n            var vals = this.convs[space];\n            if (!vals) {\n                var fspace = this.space,\n                    from = this.convs[fspace];\n                vals = convert[fspace][space](from);\n\n                this.convs[space] = vals;\n            }\n            return vals;\n        };\n\n        [\"rgb\", \"hsl\", \"hsv\", \"cmyk\", \"keyword\"].forEach(function (space) {\n            Converter.prototype[space] = function (vals) {\n                return this.routeSpace(space, arguments);\n            }\n        });\n\n        module.exports = convert;\n    }, { \"./conversions\": 4 }], 6: [function (require, module, exports) {\n        module.exports = {\n            \"aliceblue\": [240, 248, 255],\n            \"antiquewhite\": [250, 235, 215],\n            \"aqua\": [0, 255, 255],\n            \"aquamarine\": [127, 255, 212],\n            \"azure\": [240, 255, 255],\n            \"beige\": [245, 245, 220],\n            \"bisque\": [255, 228, 196],\n            \"black\": [0, 0, 0],\n            \"blanchedalmond\": [255, 235, 205],\n            \"blue\": [0, 0, 255],\n            \"blueviolet\": [138, 43, 226],\n            \"brown\": [165, 42, 42],\n            \"burlywood\": [222, 184, 135],\n            \"cadetblue\": [95, 158, 160],\n            \"chartreuse\": [127, 255, 0],\n            \"chocolate\": [210, 105, 30],\n            \"coral\": [255, 127, 80],\n            \"cornflowerblue\": [100, 149, 237],\n            \"cornsilk\": [255, 248, 220],\n            \"crimson\": [220, 20, 60],\n            \"cyan\": [0, 255, 255],\n            \"darkblue\": [0, 0, 139],\n            \"darkcyan\": [0, 139, 139],\n            \"darkgoldenrod\": [184, 134, 11],\n            \"darkgray\": [169, 169, 169],\n            \"darkgreen\": [0, 100, 0],\n            \"darkgrey\": [169, 169, 169],\n            \"darkkhaki\": [189, 183, 107],\n            \"darkmagenta\": [139, 0, 139],\n            \"darkolivegreen\": [85, 107, 47],\n            \"darkorange\": [255, 140, 0],\n            \"darkorchid\": [153, 50, 204],\n            \"darkred\": [139, 0, 0],\n            \"darksalmon\": [233, 150, 122],\n            \"darkseagreen\": [143, 188, 143],\n            \"darkslateblue\": [72, 61, 139],\n            \"darkslategray\": [47, 79, 79],\n            \"darkslategrey\": [47, 79, 79],\n            \"darkturquoise\": [0, 206, 209],\n            \"darkviolet\": [148, 0, 211],\n            \"deeppink\": [255, 20, 147],\n            \"deepskyblue\": [0, 191, 255],\n            \"dimgray\": [105, 105, 105],\n            \"dimgrey\": [105, 105, 105],\n            \"dodgerblue\": [30, 144, 255],\n            \"firebrick\": [178, 34, 34],\n            \"floralwhite\": [255, 250, 240],\n            \"forestgreen\": [34, 139, 34],\n            \"fuchsia\": [255, 0, 255],\n            \"gainsboro\": [220, 220, 220],\n            \"ghostwhite\": [248, 248, 255],\n            \"gold\": [255, 215, 0],\n            \"goldenrod\": [218, 165, 32],\n            \"gray\": [128, 128, 128],\n            \"green\": [0, 128, 0],\n            \"greenyellow\": [173, 255, 47],\n            \"grey\": [128, 128, 128],\n            \"honeydew\": [240, 255, 240],\n            \"hotpink\": [255, 105, 180],\n            \"indianred\": [205, 92, 92],\n            \"indigo\": [75, 0, 130],\n            \"ivory\": [255, 255, 240],\n            \"khaki\": [240, 230, 140],\n            \"lavender\": [230, 230, 250],\n            \"lavenderblush\": [255, 240, 245],\n            \"lawngreen\": [124, 252, 0],\n            \"lemonchiffon\": [255, 250, 205],\n            \"lightblue\": [173, 216, 230],\n            \"lightcoral\": [240, 128, 128],\n            \"lightcyan\": [224, 255, 255],\n            \"lightgoldenrodyellow\": [250, 250, 210],\n            \"lightgray\": [211, 211, 211],\n            \"lightgreen\": [144, 238, 144],\n            \"lightgrey\": [211, 211, 211],\n            \"lightpink\": [255, 182, 193],\n            \"lightsalmon\": [255, 160, 122],\n            \"lightseagreen\": [32, 178, 170],\n            \"lightskyblue\": [135, 206, 250],\n            \"lightslategray\": [119, 136, 153],\n            \"lightslategrey\": [119, 136, 153],\n            \"lightsteelblue\": [176, 196, 222],\n            \"lightyellow\": [255, 255, 224],\n            \"lime\": [0, 255, 0],\n            \"limegreen\": [50, 205, 50],\n            \"linen\": [250, 240, 230],\n            \"magenta\": [255, 0, 255],\n            \"maroon\": [128, 0, 0],\n            \"mediumaquamarine\": [102, 205, 170],\n            \"mediumblue\": [0, 0, 205],\n            \"mediumorchid\": [186, 85, 211],\n            \"mediumpurple\": [147, 112, 219],\n            \"mediumseagreen\": [60, 179, 113],\n            \"mediumslateblue\": [123, 104, 238],\n            \"mediumspringgreen\": [0, 250, 154],\n            \"mediumturquoise\": [72, 209, 204],\n            \"mediumvioletred\": [199, 21, 133],\n            \"midnightblue\": [25, 25, 112],\n            \"mintcream\": [245, 255, 250],\n            \"mistyrose\": [255, 228, 225],\n            \"moccasin\": [255, 228, 181],\n            \"navajowhite\": [255, 222, 173],\n            \"navy\": [0, 0, 128],\n            \"oldlace\": [253, 245, 230],\n            \"olive\": [128, 128, 0],\n            \"olivedrab\": [107, 142, 35],\n            \"orange\": [255, 165, 0],\n            \"orangered\": [255, 69, 0],\n            \"orchid\": [218, 112, 214],\n            \"palegoldenrod\": [238, 232, 170],\n            \"palegreen\": [152, 251, 152],\n            \"paleturquoise\": [175, 238, 238],\n            \"palevioletred\": [219, 112, 147],\n            \"papayawhip\": [255, 239, 213],\n            \"peachpuff\": [255, 218, 185],\n            \"peru\": [205, 133, 63],\n            \"pink\": [255, 192, 203],\n            \"plum\": [221, 160, 221],\n            \"powderblue\": [176, 224, 230],\n            \"purple\": [128, 0, 128],\n            \"rebeccapurple\": [102, 51, 153],\n            \"red\": [255, 0, 0],\n            \"rosybrown\": [188, 143, 143],\n            \"royalblue\": [65, 105, 225],\n            \"saddlebrown\": [139, 69, 19],\n            \"salmon\": [250, 128, 114],\n            \"sandybrown\": [244, 164, 96],\n            \"seagreen\": [46, 139, 87],\n            \"seashell\": [255, 245, 238],\n            \"sienna\": [160, 82, 45],\n            \"silver\": [192, 192, 192],\n            \"skyblue\": [135, 206, 235],\n            \"slateblue\": [106, 90, 205],\n            \"slategray\": [112, 128, 144],\n            \"slategrey\": [112, 128, 144],\n            \"snow\": [255, 250, 250],\n            \"springgreen\": [0, 255, 127],\n            \"steelblue\": [70, 130, 180],\n            \"tan\": [210, 180, 140],\n            \"teal\": [0, 128, 128],\n            \"thistle\": [216, 191, 216],\n            \"tomato\": [255, 99, 71],\n            \"turquoise\": [64, 224, 208],\n            \"violet\": [238, 130, 238],\n            \"wheat\": [245, 222, 179],\n            \"white\": [255, 255, 255],\n            \"whitesmoke\": [245, 245, 245],\n            \"yellow\": [255, 255, 0],\n            \"yellowgreen\": [154, 205, 50]\n        };\n    }, {}], 7: [function (require, module, exports) {\n        var Chart = require('./core/core.js')();\n\n        require('./core/core.helpers')(Chart);\n        require('./core/core.element')(Chart);\n        require('./core/core.animation')(Chart);\n        require('./core/core.controller')(Chart);\n        require('./core/core.datasetController')(Chart);\n        require('./core/core.layoutService')(Chart);\n        require('./core/core.legend')(Chart);\n        require('./core/core.plugin.js')(Chart);\n        require('./core/core.scale')(Chart);\n        require('./core/core.scaleService')(Chart);\n        require('./core/core.title')(Chart);\n        require('./core/core.tooltip')(Chart);\n\n        require('./controllers/controller.bar')(Chart);\n        require('./controllers/controller.bubble')(Chart);\n        require('./controllers/controller.doughnut')(Chart);\n        require('./controllers/controller.line')(Chart);\n        require('./controllers/controller.polarArea')(Chart);\n        require('./controllers/controller.radar')(Chart);\n\n        require('./scales/scale.category')(Chart);\n        require('./scales/scale.linear')(Chart);\n        require('./scales/scale.logarithmic')(Chart);\n        require('./scales/scale.radialLinear')(Chart);\n        require('./scales/scale.time')(Chart);\n\n        require('./elements/element.arc')(Chart);\n        require('./elements/element.line')(Chart);\n        require('./elements/element.point')(Chart);\n        require('./elements/element.rectangle')(Chart);\n\n        require('./charts/Chart.Bar')(Chart);\n        require('./charts/Chart.Bubble')(Chart);\n        require('./charts/Chart.Doughnut')(Chart);\n        require('./charts/Chart.Line')(Chart);\n        require('./charts/Chart.PolarArea')(Chart);\n        require('./charts/Chart.Radar')(Chart);\n        require('./charts/Chart.Scatter')(Chart);\n\n        window.Chart = module.exports = Chart;\n\n    }, { \"./charts/Chart.Bar\": 8, \"./charts/Chart.Bubble\": 9, \"./charts/Chart.Doughnut\": 10, \"./charts/Chart.Line\": 11, \"./charts/Chart.PolarArea\": 12, \"./charts/Chart.Radar\": 13, \"./charts/Chart.Scatter\": 14, \"./controllers/controller.bar\": 15, \"./controllers/controller.bubble\": 16, \"./controllers/controller.doughnut\": 17, \"./controllers/controller.line\": 18, \"./controllers/controller.polarArea\": 19, \"./controllers/controller.radar\": 20, \"./core/core.animation\": 21, \"./core/core.controller\": 22, \"./core/core.datasetController\": 23, \"./core/core.element\": 24, \"./core/core.helpers\": 25, \"./core/core.js\": 26, \"./core/core.layoutService\": 27, \"./core/core.legend\": 28, \"./core/core.plugin.js\": 29, \"./core/core.scale\": 30, \"./core/core.scaleService\": 31, \"./core/core.title\": 32, \"./core/core.tooltip\": 33, \"./elements/element.arc\": 34, \"./elements/element.line\": 35, \"./elements/element.point\": 36, \"./elements/element.rectangle\": 37, \"./scales/scale.category\": 38, \"./scales/scale.linear\": 39, \"./scales/scale.logarithmic\": 40, \"./scales/scale.radialLinear\": 41, \"./scales/scale.time\": 42 }], 8: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            Chart.Bar = function (context, config) {\n                config.type = 'bar';\n\n                return new Chart(context, config);\n            };\n\n        };\n    }, {}], 9: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            Chart.Bubble = function (context, config) {\n                config.type = 'bubble';\n                return new Chart(context, config);\n            };\n\n        };\n    }, {}], 10: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            Chart.Doughnut = function (context, config) {\n                config.type = 'doughnut';\n\n                return new Chart(context, config);\n            };\n\n        };\n    }, {}], 11: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            Chart.Line = function (context, config) {\n                config.type = 'line';\n\n                return new Chart(context, config);\n            };\n\n        };\n    }, {}], 12: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            Chart.PolarArea = function (context, config) {\n                config.type = 'polarArea';\n\n                return new Chart(context, config);\n            };\n\n        };\n    }, {}], 13: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            var defaultConfig = {\n                aspectRatio: 1\n            };\n\n            Chart.Radar = function (context, config) {\n                config.options = helpers.configMerge(defaultConfig, config.options);\n                config.type = 'radar';\n\n                return new Chart(context, config);\n            };\n\n        };\n\n    }, {}], 14: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var defaultConfig = {\n                hover: {\n                    mode: 'single'\n                },\n\n                scales: {\n                    xAxes: [{\n                        type: \"linear\", // scatter should not use a category axis\n                        position: \"bottom\",\n                        id: \"x-axis-1\" // need an ID so datasets can reference the scale\n                    }],\n                    yAxes: [{\n                        type: \"linear\",\n                        position: \"left\",\n                        id: \"y-axis-1\"\n                    }]\n                },\n\n                tooltips: {\n                    callbacks: {\n                        title: function (tooltipItems, data) {\n                            // Title doesn't make sense for scatter since we format the data as a point\n                            return '';\n                        },\n                        label: function (tooltipItem, data) {\n                            return '(' + tooltipItem.xLabel + ', ' + tooltipItem.yLabel + ')';\n                        }\n                    }\n                }\n            };\n\n            // Register the default config for this type\n            Chart.defaults.scatter = defaultConfig;\n\n            // Scatter charts use line controllers\n            Chart.controllers.scatter = Chart.controllers.line;\n\n            Chart.Scatter = function (context, config) {\n                config.type = 'scatter';\n                return new Chart(context, config);\n            };\n\n        };\n    }, {}], 15: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.bar = {\n                hover: {\n                    mode: \"label\"\n                },\n\n                scales: {\n                    xAxes: [{\n                        type: \"category\",\n\n                        // Specific to Bar Controller\n                        categoryPercentage: 0.8,\n                        barPercentage: 0.9,\n\n                        // grid line settings\n                        gridLines: {\n                            offsetGridLines: true\n                        }\n                    }],\n                    yAxes: [{\n                        type: \"linear\"\n                    }]\n                }\n            };\n\n            Chart.controllers.bar = Chart.DatasetController.extend({\n                initialize: function (chart, datasetIndex) {\n                    Chart.DatasetController.prototype.initialize.call(this, chart, datasetIndex);\n\n                    // Use this to indicate that this is a bar dataset.\n                    this.getMeta().bar = true;\n                },\n                // Get the number of datasets that display bars. We use this to correctly calculate the bar width\n                getBarCount: function getBarCount() {\n                    var barCount = 0;\n                    helpers.each(this.chart.data.datasets, function (dataset, datasetIndex) {\n                        var meta = this.chart.getDatasetMeta(datasetIndex);\n                        if (meta.bar && this.chart.isDatasetVisible(datasetIndex)) {\n                            ++barCount;\n                        }\n                    }, this);\n                    return barCount;\n                },\n\n                addElements: function () {\n                    var meta = this.getMeta();\n                    helpers.each(this.getDataset().data, function (value, index) {\n                        meta.data[index] = meta.data[index] || new Chart.elements.Rectangle({\n                            _chart: this.chart.chart,\n                            _datasetIndex: this.index,\n                            _index: index\n                        });\n                    }, this);\n                },\n\n                addElementAndReset: function (index) {\n                    var rectangle = new Chart.elements.Rectangle({\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _index: index\n                    });\n\n                    var numBars = this.getBarCount();\n\n                    // Add to the points array and reset it\n                    this.getMeta().data.splice(index, 0, rectangle);\n                    this.updateElement(rectangle, index, true, numBars);\n                },\n\n                update: function update(reset) {\n                    var numBars = this.getBarCount();\n\n                    helpers.each(this.getMeta().data, function (rectangle, index) {\n                        this.updateElement(rectangle, index, reset, numBars);\n                    }, this);\n                },\n\n                updateElement: function updateElement(rectangle, index, reset, numBars) {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n\n                    var yScalePoint;\n\n                    if (yScale.min < 0 && yScale.max < 0) {\n                        // all less than 0. use the top\n                        yScalePoint = yScale.getPixelForValue(yScale.max);\n                    } else if (yScale.min > 0 && yScale.max > 0) {\n                        yScalePoint = yScale.getPixelForValue(yScale.min);\n                    } else {\n                        yScalePoint = yScale.getPixelForValue(0);\n                    }\n\n                    helpers.extend(rectangle, {\n                        // Utility\n                        _chart: this.chart.chart,\n                        _xScale: xScale,\n                        _yScale: yScale,\n                        _datasetIndex: this.index,\n                        _index: index,\n\n\n                        // Desired view properties\n                        _model: {\n                            x: this.calculateBarX(index, this.index),\n                            y: reset ? yScalePoint : this.calculateBarY(index, this.index),\n\n                            // Tooltip\n                            label: this.chart.data.labels[index],\n                            datasetLabel: this.getDataset().label,\n\n                            // Appearance\n                            base: reset ? yScalePoint : this.calculateBarBase(this.index, index),\n                            width: this.calculateBarWidth(numBars),\n                            backgroundColor: rectangle.custom && rectangle.custom.backgroundColor ? rectangle.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.rectangle.backgroundColor),\n                            borderSkipped: rectangle.custom && rectangle.custom.borderSkipped ? rectangle.custom.borderSkipped : this.chart.options.elements.rectangle.borderSkipped,\n                            borderColor: rectangle.custom && rectangle.custom.borderColor ? rectangle.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.rectangle.borderColor),\n                            borderWidth: rectangle.custom && rectangle.custom.borderWidth ? rectangle.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.rectangle.borderWidth)\n                        }\n                    });\n                    rectangle.pivot();\n                },\n\n                calculateBarBase: function (datasetIndex, index) {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n\n                    var base = 0;\n\n                    if (yScale.options.stacked) {\n\n                        var value = this.chart.data.datasets[datasetIndex].data[index];\n\n                        if (value < 0) {\n                            for (var i = 0; i < datasetIndex; i++) {\n                                var negDS = this.chart.data.datasets[i];\n                                var negDSMeta = this.chart.getDatasetMeta(i);\n                                if (negDSMeta.bar && negDSMeta.yAxisID === yScale.id && this.chart.isDatasetVisible(i)) {\n                                    base += negDS.data[index] < 0 ? negDS.data[index] : 0;\n                                }\n                            }\n                        } else {\n                            for (var j = 0; j < datasetIndex; j++) {\n                                var posDS = this.chart.data.datasets[j];\n                                var posDSMeta = this.chart.getDatasetMeta(j);\n                                if (posDSMeta.bar && posDSMeta.yAxisID === yScale.id && this.chart.isDatasetVisible(j)) {\n                                    base += posDS.data[index] > 0 ? posDS.data[index] : 0;\n                                }\n                            }\n                        }\n\n                        return yScale.getPixelForValue(base);\n                    }\n\n                    base = yScale.getPixelForValue(yScale.min);\n\n                    if (yScale.beginAtZero || ((yScale.min <= 0 && yScale.max >= 0) || (yScale.min >= 0 && yScale.max <= 0))) {\n                        base = yScale.getPixelForValue(0, 0);\n                        //base += yScale.options.gridLines.lineWidth;\n                    } else if (yScale.min < 0 && yScale.max < 0) {\n                        // All values are negative. Use the top as the base\n                        base = yScale.getPixelForValue(yScale.max);\n                    }\n\n                    return base;\n\n                },\n\n                getRuler: function () {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n                    var datasetCount = this.getBarCount();\n\n                    var tickWidth = (function () {\n                        var min = xScale.getPixelForTick(1) - xScale.getPixelForTick(0);\n                        for (var i = 2; i < xScale.ticks.length; i++) {\n                            min = Math.min(xScale.getPixelForTick(i) - xScale.getPixelForTick(i - 1), min);\n                        }\n                        return min;\n                    }).call(this);\n                    var categoryWidth = tickWidth * xScale.options.categoryPercentage;\n                    var categorySpacing = (tickWidth - (tickWidth * xScale.options.categoryPercentage)) / 2;\n                    var fullBarWidth = categoryWidth / datasetCount;\n\n                    if (xScale.ticks.length !== this.chart.data.labels.length) {\n                        var perc = xScale.ticks.length / this.chart.data.labels.length;\n                        fullBarWidth = fullBarWidth * perc;\n                    }\n\n                    var barWidth = fullBarWidth * xScale.options.barPercentage;\n                    var barSpacing = fullBarWidth - (fullBarWidth * xScale.options.barPercentage);\n\n                    return {\n                        datasetCount: datasetCount,\n                        tickWidth: tickWidth,\n                        categoryWidth: categoryWidth,\n                        categorySpacing: categorySpacing,\n                        fullBarWidth: fullBarWidth,\n                        barWidth: barWidth,\n                        barSpacing: barSpacing\n                    };\n                },\n\n                calculateBarWidth: function () {\n                    var xScale = this.getScaleForId(this.getMeta().xAxisID);\n                    var ruler = this.getRuler();\n                    return xScale.options.stacked ? ruler.categoryWidth : ruler.barWidth;\n                },\n\n                // Get bar index from the given dataset index accounting for the fact that not all bars are visible\n                getBarIndex: function (datasetIndex) {\n                    var barIndex = 0;\n                    var meta, j;\n\n                    for (j = 0; j < datasetIndex; ++j) {\n                        meta = this.chart.getDatasetMeta(j);\n                        if (meta.bar && this.chart.isDatasetVisible(j)) {\n                            ++barIndex;\n                        }\n                    }\n\n                    return barIndex;\n                },\n\n                calculateBarX: function (index, datasetIndex) {\n                    var meta = this.getMeta();\n                    var yScale = this.getScaleForId(meta.yAxisID);\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var barIndex = this.getBarIndex(datasetIndex);\n\n                    var ruler = this.getRuler();\n                    var leftTick = xScale.getPixelForValue(null, index, datasetIndex, this.chart.isCombo);\n                    leftTick -= this.chart.isCombo ? (ruler.tickWidth / 2) : 0;\n\n                    if (xScale.options.stacked) {\n                        return leftTick + (ruler.categoryWidth / 2) + ruler.categorySpacing;\n                    }\n\n                    return leftTick +\n                        (ruler.barWidth / 2) +\n                        ruler.categorySpacing +\n                        (ruler.barWidth * barIndex) +\n                        (ruler.barSpacing / 2) +\n                        (ruler.barSpacing * barIndex);\n                },\n\n                calculateBarY: function (index, datasetIndex) {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n\n                    var value = this.getDataset().data[index];\n\n                    if (yScale.options.stacked) {\n\n                        var sumPos = 0,\n                            sumNeg = 0;\n\n                        for (var i = 0; i < datasetIndex; i++) {\n                            var ds = this.chart.data.datasets[i];\n                            var dsMeta = this.chart.getDatasetMeta(i);\n                            if (dsMeta.bar && dsMeta.yAxisID === yScale.id && this.chart.isDatasetVisible(i)) {\n                                if (ds.data[index] < 0) {\n                                    sumNeg += ds.data[index] || 0;\n                                } else {\n                                    sumPos += ds.data[index] || 0;\n                                }\n                            }\n                        }\n\n                        if (value < 0) {\n                            return yScale.getPixelForValue(sumNeg + value);\n                        } else {\n                            return yScale.getPixelForValue(sumPos + value);\n                        }\n                    }\n\n                    return yScale.getPixelForValue(value);\n                },\n\n                draw: function (ease) {\n                    var easingDecimal = ease || 1;\n                    helpers.each(this.getMeta().data, function (rectangle, index) {\n                        var d = this.getDataset().data[index];\n                        if (d !== null && d !== undefined && !isNaN(d)) {\n                            rectangle.transition(easingDecimal).draw();\n                        }\n                    }, this);\n                },\n\n                setHoverStyle: function (rectangle) {\n                    var dataset = this.chart.data.datasets[rectangle._datasetIndex];\n                    var index = rectangle._index;\n\n                    rectangle._model.backgroundColor = rectangle.custom && rectangle.custom.hoverBackgroundColor ? rectangle.custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(dataset.hoverBackgroundColor, index, helpers.color(rectangle._model.backgroundColor).saturate(0.5).darken(0.1).rgbString());\n                    rectangle._model.borderColor = rectangle.custom && rectangle.custom.hoverBorderColor ? rectangle.custom.hoverBorderColor : helpers.getValueAtIndexOrDefault(dataset.hoverBorderColor, index, helpers.color(rectangle._model.borderColor).saturate(0.5).darken(0.1).rgbString());\n                    rectangle._model.borderWidth = rectangle.custom && rectangle.custom.hoverBorderWidth ? rectangle.custom.hoverBorderWidth : helpers.getValueAtIndexOrDefault(dataset.hoverBorderWidth, index, rectangle._model.borderWidth);\n                },\n\n                removeHoverStyle: function (rectangle) {\n                    var dataset = this.chart.data.datasets[rectangle._datasetIndex];\n                    var index = rectangle._index;\n\n                    rectangle._model.backgroundColor = rectangle.custom && rectangle.custom.backgroundColor ? rectangle.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.rectangle.backgroundColor);\n                    rectangle._model.borderColor = rectangle.custom && rectangle.custom.borderColor ? rectangle.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.rectangle.borderColor);\n                    rectangle._model.borderWidth = rectangle.custom && rectangle.custom.borderWidth ? rectangle.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.rectangle.borderWidth);\n                }\n\n            });\n\n\n            // including horizontalBar in the bar file, instead of a file of its own\n            // it extends bar (like pie extends doughnut)\n            Chart.defaults.horizontalBar = {\n                hover: {\n                    mode: \"label\"\n                },\n\n                scales: {\n                    xAxes: [{\n                        type: \"linear\",\n                        position: \"bottom\"\n                    }],\n                    yAxes: [{\n                        position: \"left\",\n                        type: \"category\",\n\n                        // Specific to Horizontal Bar Controller\n                        categoryPercentage: 0.8,\n                        barPercentage: 0.9,\n\n                        // grid line settings\n                        gridLines: {\n                            offsetGridLines: true\n                        }\n                    }]\n                },\n            };\n\n            Chart.controllers.horizontalBar = Chart.controllers.bar.extend({\n                updateElement: function updateElement(rectangle, index, reset, numBars) {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n\n                    var xScalePoint;\n\n                    if (xScale.min < 0 && xScale.max < 0) {\n                        // all less than 0. use the right\n                        xScalePoint = xScale.getPixelForValue(xScale.max);\n                    } else if (xScale.min > 0 && xScale.max > 0) {\n                        xScalePoint = xScale.getPixelForValue(xScale.min);\n                    } else {\n                        xScalePoint = xScale.getPixelForValue(0);\n                    }\n\n                    helpers.extend(rectangle, {\n                        // Utility\n                        _chart: this.chart.chart,\n                        _xScale: xScale,\n                        _yScale: yScale,\n                        _datasetIndex: this.index,\n                        _index: index,\n\n                        // Desired view properties\n                        _model: {\n                            x: reset ? xScalePoint : this.calculateBarX(index, this.index),\n                            y: this.calculateBarY(index, this.index),\n\n                            // Tooltip\n                            label: this.chart.data.labels[index],\n                            datasetLabel: this.getDataset().label,\n\n                            // Appearance\n                            base: reset ? xScalePoint : this.calculateBarBase(this.index, index),\n                            height: this.calculateBarHeight(numBars),\n                            backgroundColor: rectangle.custom && rectangle.custom.backgroundColor ? rectangle.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.rectangle.backgroundColor),\n                            borderSkipped: rectangle.custom && rectangle.custom.borderSkipped ? rectangle.custom.borderSkipped : this.chart.options.elements.rectangle.borderSkipped,\n                            borderColor: rectangle.custom && rectangle.custom.borderColor ? rectangle.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.rectangle.borderColor),\n                            borderWidth: rectangle.custom && rectangle.custom.borderWidth ? rectangle.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.rectangle.borderWidth)\n                        },\n\n                        draw: function () {\n\n                            var ctx = this._chart.ctx;\n                            var vm = this._view;\n\n                            var halfHeight = vm.height / 2,\n                                topY = vm.y - halfHeight,\n                                bottomY = vm.y + halfHeight,\n                                right = vm.base - (vm.base - vm.x),\n                                halfStroke = vm.borderWidth / 2;\n\n                            // Canvas doesn't allow us to stroke inside the width so we can\n                            // adjust the sizes to fit if we're setting a stroke on the line\n                            if (vm.borderWidth) {\n                                topY += halfStroke;\n                                bottomY -= halfStroke;\n                                right += halfStroke;\n                            }\n\n                            ctx.beginPath();\n\n                            ctx.fillStyle = vm.backgroundColor;\n                            ctx.strokeStyle = vm.borderColor;\n                            ctx.lineWidth = vm.borderWidth;\n\n                            // Corner points, from bottom-left to bottom-right clockwise\n                            // | 1 2 |\n                            // | 0 3 |\n                            var corners = [\n                                [vm.base, bottomY],\n                                [vm.base, topY],\n                                [right, topY],\n                                [right, bottomY]\n                            ];\n\n                            // Find first (starting) corner with fallback to 'bottom'\n                            var borders = ['bottom', 'left', 'top', 'right'];\n                            var startCorner = borders.indexOf(vm.borderSkipped, 0);\n                            if (startCorner === -1)\n                                startCorner = 0;\n\n                            function cornerAt(index) {\n                                return corners[(startCorner + index) % 4];\n                            }\n\n                            // Draw rectangle from 'startCorner'\n                            ctx.moveTo.apply(ctx, cornerAt(0));\n                            for (var i = 1; i < 4; i++)\n                                ctx.lineTo.apply(ctx, cornerAt(i));\n\n                            ctx.fill();\n                            if (vm.borderWidth) {\n                                ctx.stroke();\n                            }\n                        },\n\n                        inRange: function (mouseX, mouseY) {\n                            var vm = this._view;\n                            var inRange = false;\n\n                            if (vm) {\n                                if (vm.x < vm.base) {\n                                    inRange = (mouseY >= vm.y - vm.height / 2 && mouseY <= vm.y + vm.height / 2) && (mouseX >= vm.x && mouseX <= vm.base);\n                                } else {\n                                    inRange = (mouseY >= vm.y - vm.height / 2 && mouseY <= vm.y + vm.height / 2) && (mouseX >= vm.base && mouseX <= vm.x);\n                                }\n                            }\n\n                            return inRange;\n                        }\n                    });\n\n                    rectangle.pivot();\n                },\n\n                calculateBarBase: function (datasetIndex, index) {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n\n                    var base = 0;\n\n                    if (xScale.options.stacked) {\n\n                        var value = this.chart.data.datasets[datasetIndex].data[index];\n\n                        if (value < 0) {\n                            for (var i = 0; i < datasetIndex; i++) {\n                                var negDS = this.chart.data.datasets[i];\n                                var negDSMeta = this.chart.getDatasetMeta(i);\n                                if (negDSMeta.bar && negDSMeta.xAxisID === xScale.id && this.chart.isDatasetVisible(i)) {\n                                    base += negDS.data[index] < 0 ? negDS.data[index] : 0;\n                                }\n                            }\n                        } else {\n                            for (var j = 0; j < datasetIndex; j++) {\n                                var posDS = this.chart.data.datasets[j];\n                                var posDSMeta = this.chart.getDatasetMeta(j);\n                                if (posDSMeta.bar && posDSMeta.xAxisID === xScale.id && this.chart.isDatasetVisible(j)) {\n                                    base += posDS.data[index] > 0 ? posDS.data[index] : 0;\n                                }\n                            }\n                        }\n\n                        return xScale.getPixelForValue(base);\n                    }\n\n                    base = xScale.getPixelForValue(xScale.min);\n\n                    if (xScale.beginAtZero || ((xScale.min <= 0 && xScale.max >= 0) || (xScale.min >= 0 && xScale.max <= 0))) {\n                        base = xScale.getPixelForValue(0, 0);\n                    } else if (xScale.min < 0 && xScale.max < 0) {\n                        // All values are negative. Use the right as the base\n                        base = xScale.getPixelForValue(xScale.max);\n                    }\n\n                    return base;\n                },\n\n                getRuler: function () {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n                    var datasetCount = this.getBarCount();\n\n                    var tickHeight = (function () {\n                        var min = yScale.getPixelForTick(1) - yScale.getPixelForTick(0);\n                        for (var i = 2; i < this.getDataset().data.length; i++) {\n                            min = Math.min(yScale.getPixelForTick(i) - yScale.getPixelForTick(i - 1), min);\n                        }\n                        return min;\n                    }).call(this);\n                    var categoryHeight = tickHeight * yScale.options.categoryPercentage;\n                    var categorySpacing = (tickHeight - (tickHeight * yScale.options.categoryPercentage)) / 2;\n                    var fullBarHeight = categoryHeight / datasetCount;\n\n                    if (yScale.ticks.length !== this.chart.data.labels.length) {\n                        var perc = yScale.ticks.length / this.chart.data.labels.length;\n                        fullBarHeight = fullBarHeight * perc;\n                    }\n\n                    var barHeight = fullBarHeight * yScale.options.barPercentage;\n                    var barSpacing = fullBarHeight - (fullBarHeight * yScale.options.barPercentage);\n\n                    return {\n                        datasetCount: datasetCount,\n                        tickHeight: tickHeight,\n                        categoryHeight: categoryHeight,\n                        categorySpacing: categorySpacing,\n                        fullBarHeight: fullBarHeight,\n                        barHeight: barHeight,\n                        barSpacing: barSpacing,\n                    };\n                },\n\n                calculateBarHeight: function () {\n                    var yScale = this.getScaleForId(this.getMeta().yAxisID);\n                    var ruler = this.getRuler();\n                    return yScale.options.stacked ? ruler.categoryHeight : ruler.barHeight;\n                },\n\n                calculateBarX: function (index, datasetIndex) {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n\n                    var value = this.getDataset().data[index];\n\n                    if (xScale.options.stacked) {\n\n                        var sumPos = 0,\n                            sumNeg = 0;\n\n                        for (var i = 0; i < datasetIndex; i++) {\n                            var ds = this.chart.data.datasets[i];\n                            var dsMeta = this.chart.getDatasetMeta(i);\n                            if (dsMeta.bar && dsMeta.xAxisID === xScale.id && this.chart.isDatasetVisible(i)) {\n                                if (ds.data[index] < 0) {\n                                    sumNeg += ds.data[index] || 0;\n                                } else {\n                                    sumPos += ds.data[index] || 0;\n                                }\n                            }\n                        }\n\n                        if (value < 0) {\n                            return xScale.getPixelForValue(sumNeg + value);\n                        } else {\n                            return xScale.getPixelForValue(sumPos + value);\n                        }\n                    }\n\n                    return xScale.getPixelForValue(value);\n                },\n\n                calculateBarY: function (index, datasetIndex) {\n                    var meta = this.getMeta();\n                    var yScale = this.getScaleForId(meta.yAxisID);\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var barIndex = this.getBarIndex(datasetIndex);\n\n                    var ruler = this.getRuler();\n                    var topTick = yScale.getPixelForValue(null, index, datasetIndex, this.chart.isCombo);\n                    topTick -= this.chart.isCombo ? (ruler.tickHeight / 2) : 0;\n\n                    if (yScale.options.stacked) {\n                        return topTick + (ruler.categoryHeight / 2) + ruler.categorySpacing;\n                    }\n\n                    return topTick +\n                        (ruler.barHeight / 2) +\n                        ruler.categorySpacing +\n                        (ruler.barHeight * barIndex) +\n                        (ruler.barSpacing / 2) +\n                        (ruler.barSpacing * barIndex);\n                }\n            });\n        };\n\n    }, {}], 16: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.bubble = {\n                hover: {\n                    mode: \"single\"\n                },\n\n                scales: {\n                    xAxes: [{\n                        type: \"linear\", // bubble should probably use a linear scale by default\n                        position: \"bottom\",\n                        id: \"x-axis-0\" // need an ID so datasets can reference the scale\n                    }],\n                    yAxes: [{\n                        type: \"linear\",\n                        position: \"left\",\n                        id: \"y-axis-0\"\n                    }]\n                },\n\n                tooltips: {\n                    callbacks: {\n                        title: function (tooltipItems, data) {\n                            // Title doesn't make sense for scatter since we format the data as a point\n                            return '';\n                        },\n                        label: function (tooltipItem, data) {\n                            var datasetLabel = data.datasets[tooltipItem.datasetIndex].label || '';\n                            var dataPoint = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];\n                            return datasetLabel + ': (' + dataPoint.x + ', ' + dataPoint.y + ', ' + dataPoint.r + ')';\n                        }\n                    }\n                }\n            };\n\n\n            Chart.controllers.bubble = Chart.DatasetController.extend({\n                addElements: function () {\n                    var meta = this.getMeta();\n                    helpers.each(this.getDataset().data, function (value, index) {\n                        meta.data[index] = meta.data[index] || new Chart.elements.Point({\n                            _chart: this.chart.chart,\n                            _datasetIndex: this.index,\n                            _index: index\n                        });\n                    }, this);\n                },\n                addElementAndReset: function (index) {\n                    var point = new Chart.elements.Point({\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _index: index\n                    });\n\n                    // Add to the points array and reset it\n                    this.getMeta().data.splice(index, 0, point);\n                    this.updateElement(point, index, true);\n                },\n\n                update: function update(reset) {\n                    var meta = this.getMeta();\n                    var points = meta.data;\n                    var yScale = this.getScaleForId(meta.yAxisID);\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var scaleBase;\n\n                    if (yScale.min < 0 && yScale.max < 0) {\n                        scaleBase = yScale.getPixelForValue(yScale.max);\n                    } else if (yScale.min > 0 && yScale.max > 0) {\n                        scaleBase = yScale.getPixelForValue(yScale.min);\n                    } else {\n                        scaleBase = yScale.getPixelForValue(0);\n                    }\n\n                    // Update Points\n                    helpers.each(points, function (point, index) {\n                        this.updateElement(point, index, reset);\n                    }, this);\n\n                },\n\n                updateElement: function (point, index, reset) {\n                    var meta = this.getMeta();\n                    var yScale = this.getScaleForId(meta.yAxisID);\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var scaleBase;\n\n                    if (yScale.min < 0 && yScale.max < 0) {\n                        scaleBase = yScale.getPixelForValue(yScale.max);\n                    } else if (yScale.min > 0 && yScale.max > 0) {\n                        scaleBase = yScale.getPixelForValue(yScale.min);\n                    } else {\n                        scaleBase = yScale.getPixelForValue(0);\n                    }\n\n                    helpers.extend(point, {\n                        // Utility\n                        _chart: this.chart.chart,\n                        _xScale: xScale,\n                        _yScale: yScale,\n                        _datasetIndex: this.index,\n                        _index: index,\n\n                        // Desired view properties\n                        _model: {\n                            x: reset ? xScale.getPixelForDecimal(0.5) : xScale.getPixelForValue(this.getDataset().data[index], index, this.index, this.chart.isCombo),\n                            y: reset ? scaleBase : yScale.getPixelForValue(this.getDataset().data[index], index, this.index),\n                            // Appearance\n                            radius: reset ? 0 : point.custom && point.custom.radius ? point.custom.radius : this.getRadius(this.getDataset().data[index]),\n                            backgroundColor: point.custom && point.custom.backgroundColor ? point.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.point.backgroundColor),\n                            borderColor: point.custom && point.custom.borderColor ? point.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.point.borderColor),\n                            borderWidth: point.custom && point.custom.borderWidth ? point.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.point.borderWidth),\n\n                            // Tooltip\n                            hitRadius: point.custom && point.custom.hitRadius ? point.custom.hitRadius : helpers.getValueAtIndexOrDefault(this.getDataset().hitRadius, index, this.chart.options.elements.point.hitRadius)\n                        }\n                    });\n\n                    point._model.skip = point.custom && point.custom.skip ? point.custom.skip : (isNaN(point._model.x) || isNaN(point._model.y));\n\n                    point.pivot();\n                },\n\n                getRadius: function (value) {\n                    return value.r || this.chart.options.elements.point.radius;\n                },\n\n                draw: function (ease) {\n                    var easingDecimal = ease || 1;\n\n                    // Transition and Draw the Points\n                    helpers.each(this.getMeta().data, function (point, index) {\n                        point.transition(easingDecimal);\n                        point.draw();\n                    });\n\n                },\n\n                setHoverStyle: function (point) {\n                    // Point\n                    var dataset = this.chart.data.datasets[point._datasetIndex];\n                    var index = point._index;\n\n                    point._model.radius = point.custom && point.custom.hoverRadius ? point.custom.hoverRadius : (helpers.getValueAtIndexOrDefault(dataset.hoverRadius, index, this.chart.options.elements.point.hoverRadius)) + this.getRadius(this.getDataset().data[point._index]);\n                    point._model.backgroundColor = point.custom && point.custom.hoverBackgroundColor ? point.custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(dataset.hoverBackgroundColor, index, helpers.color(point._model.backgroundColor).saturate(0.5).darken(0.1).rgbString());\n                    point._model.borderColor = point.custom && point.custom.hoverBorderColor ? point.custom.hoverBorderColor : helpers.getValueAtIndexOrDefault(dataset.hoverBorderColor, index, helpers.color(point._model.borderColor).saturate(0.5).darken(0.1).rgbString());\n                    point._model.borderWidth = point.custom && point.custom.hoverBorderWidth ? point.custom.hoverBorderWidth : helpers.getValueAtIndexOrDefault(dataset.hoverBorderWidth, index, point._model.borderWidth);\n                },\n\n                removeHoverStyle: function (point) {\n                    var dataset = this.chart.data.datasets[point._datasetIndex];\n                    var index = point._index;\n\n                    point._model.radius = point.custom && point.custom.radius ? point.custom.radius : this.getRadius(this.getDataset().data[point._index]);\n                    point._model.backgroundColor = point.custom && point.custom.backgroundColor ? point.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.point.backgroundColor);\n                    point._model.borderColor = point.custom && point.custom.borderColor ? point.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.point.borderColor);\n                    point._model.borderWidth = point.custom && point.custom.borderWidth ? point.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.point.borderWidth);\n                }\n            });\n        };\n    }, {}], 17: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.doughnut = {\n                animation: {\n                    //Boolean - Whether we animate the rotation of the Doughnut\n                    animateRotate: true,\n                    //Boolean - Whether we animate scaling the Doughnut from the centre\n                    animateScale: false\n                },\n                aspectRatio: 1,\n                hover: {\n                    mode: 'single'\n                },\n                legendCallback: function (chart) {\n                    var text = [];\n                    text.push('<ul class=\"' + chart.id + '-legend\">');\n\n                    if (chart.data.datasets.length) {\n                        for (var i = 0; i < chart.data.datasets[0].data.length; ++i) {\n                            text.push('<li><span style=\"background-color:' + chart.data.datasets[0].backgroundColor[i] + '\"></span>');\n                            if (chart.data.labels[i]) {\n                                text.push(chart.data.labels[i]);\n                            }\n                            text.push('</li>');\n                        }\n                    }\n\n                    text.push('</ul>');\n                    return text.join(\"\");\n                },\n                legend: {\n                    labels: {\n                        generateLabels: function (chart) {\n                            var data = chart.data;\n                            if (data.labels.length && data.datasets.length) {\n                                return data.labels.map(function (label, i) {\n                                    var meta = chart.getDatasetMeta(0);\n                                    var ds = data.datasets[0];\n                                    var arc = meta.data[i];\n                                    var fill = arc.custom && arc.custom.backgroundColor ? arc.custom.backgroundColor : helpers.getValueAtIndexOrDefault(ds.backgroundColor, i, this.chart.options.elements.arc.backgroundColor);\n                                    var stroke = arc.custom && arc.custom.borderColor ? arc.custom.borderColor : helpers.getValueAtIndexOrDefault(ds.borderColor, i, this.chart.options.elements.arc.borderColor);\n                                    var bw = arc.custom && arc.custom.borderWidth ? arc.custom.borderWidth : helpers.getValueAtIndexOrDefault(ds.borderWidth, i, this.chart.options.elements.arc.borderWidth);\n\n                                    return {\n                                        text: label,\n                                        fillStyle: fill,\n                                        strokeStyle: stroke,\n                                        lineWidth: bw,\n                                        hidden: isNaN(ds.data[i]) || meta.data[i].hidden,\n\n                                        // Extra data used for toggling the correct item\n                                        index: i\n                                    };\n                                }, this);\n                            } else {\n                                return [];\n                            }\n                        }\n                    },\n\n                    onClick: function (e, legendItem) {\n                        var index = legendItem.index;\n                        var chart = this.chart;\n                        var i, ilen, meta;\n\n                        for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {\n                            meta = chart.getDatasetMeta(i);\n                            meta.data[index].hidden = !meta.data[index].hidden;\n                        }\n\n                        chart.update();\n                    }\n                },\n\n                //The percentage of the chart that we cut out of the middle.\n                cutoutPercentage: 50,\n\n                //The rotation of the chart, where the first data arc begins.\n                rotation: Math.PI * -0.5,\n\n                //The total circumference of the chart.\n                circumference: Math.PI * 2.0,\n\n                // Need to override these to give a nice default\n                tooltips: {\n                    callbacks: {\n                        title: function () {\n                            return '';\n                        },\n                        label: function (tooltipItem, data) {\n                            return data.labels[tooltipItem.index] + ': ' + data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];\n                        }\n                    }\n                }\n            };\n\n            Chart.defaults.pie = helpers.clone(Chart.defaults.doughnut);\n            helpers.extend(Chart.defaults.pie, {\n                cutoutPercentage: 0\n            });\n\n\n            Chart.controllers.doughnut = Chart.controllers.pie = Chart.DatasetController.extend({\n                linkScales: function () {\n                    // no scales for doughnut\n                },\n\n                addElements: function () {\n                    var meta = this.getMeta();\n                    helpers.each(this.getDataset().data, function (value, index) {\n                        meta.data[index] = meta.data[index] || new Chart.elements.Arc({\n                            _chart: this.chart.chart,\n                            _datasetIndex: this.index,\n                            _index: index\n                        });\n                    }, this);\n                },\n\n                addElementAndReset: function (index, colorForNewElement) {\n                    var arc = new Chart.elements.Arc({\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _index: index\n                    });\n\n                    if (colorForNewElement && helpers.isArray(this.getDataset().backgroundColor)) {\n                        this.getDataset().backgroundColor.splice(index, 0, colorForNewElement);\n                    }\n\n                    // Add to the points array and reset it\n                    this.getMeta().data.splice(index, 0, arc);\n                    this.updateElement(arc, index, true);\n                },\n\n                // Get index of the dataset in relation to the visible datasets. This allows determining the inner and outer radius correctly\n                getRingIndex: function getRingIndex(datasetIndex) {\n                    var ringIndex = 0;\n\n                    for (var j = 0; j < datasetIndex; ++j) {\n                        if (this.chart.isDatasetVisible(j)) {\n                            ++ringIndex;\n                        }\n                    }\n\n                    return ringIndex;\n                },\n\n                update: function update(reset) {\n                    var availableWidth = this.chart.chartArea.right - this.chart.chartArea.left - this.chart.options.elements.arc.borderWidth;\n                    var availableHeight = this.chart.chartArea.bottom - this.chart.chartArea.top - this.chart.options.elements.arc.borderWidth;\n                    var minSize = Math.min(availableWidth, availableHeight);\n                    var offset = { x: 0, y: 0 };\n\n                    // If the chart's circumference isn't a full circle, calculate minSize as a ratio of the width/height of the arc\n                    if (this.chart.options.circumference < Math.PI * 2.0) {\n                        var startAngle = this.chart.options.rotation % (Math.PI * 2.0);\n                        startAngle += Math.PI * 2.0 * (startAngle >= Math.PI ? -1 : startAngle < -Math.PI ? 1 : 0);\n                        var endAngle = startAngle + this.chart.options.circumference;\n                        var start = { x: Math.cos(startAngle), y: Math.sin(startAngle) };\n                        var end = { x: Math.cos(endAngle), y: Math.sin(endAngle) };\n                        var contains0 = (startAngle <= 0 && 0 <= endAngle) || (startAngle <= Math.PI * 2.0 && Math.PI * 2.0 <= endAngle);\n                        var contains90 = (startAngle <= Math.PI * 0.5 && Math.PI * 0.5 <= endAngle) || (startAngle <= Math.PI * 2.5 && Math.PI * 2.5 <= endAngle);\n                        var contains180 = (startAngle <= -Math.PI && -Math.PI <= endAngle) || (startAngle <= Math.PI && Math.PI <= endAngle);\n                        var contains270 = (startAngle <= -Math.PI * 0.5 && -Math.PI * 0.5 <= endAngle) || (startAngle <= Math.PI * 1.5 && Math.PI * 1.5 <= endAngle);\n                        var cutout = this.chart.options.cutoutPercentage / 100.0;\n                        var min = { x: contains180 ? -1 : Math.min(start.x * (start.x < 0 ? 1 : cutout), end.x * (end.x < 0 ? 1 : cutout)), y: contains270 ? -1 : Math.min(start.y * (start.y < 0 ? 1 : cutout), end.y * (end.y < 0 ? 1 : cutout)) };\n                        var max = { x: contains0 ? 1 : Math.max(start.x * (start.x > 0 ? 1 : cutout), end.x * (end.x > 0 ? 1 : cutout)), y: contains90 ? 1 : Math.max(start.y * (start.y > 0 ? 1 : cutout), end.y * (end.y > 0 ? 1 : cutout)) };\n                        var size = { width: (max.x - min.x) * 0.5, height: (max.y - min.y) * 0.5 };\n                        minSize = Math.min(availableWidth / size.width, availableHeight / size.height);\n                        offset = { x: (max.x + min.x) * -0.5, y: (max.y + min.y) * -0.5 };\n                    }\n\n                    this.chart.outerRadius = Math.max(minSize / 2, 0);\n                    this.chart.innerRadius = Math.max(this.chart.options.cutoutPercentage ? (this.chart.outerRadius / 100) * (this.chart.options.cutoutPercentage) : 1, 0);\n                    this.chart.radiusLength = (this.chart.outerRadius - this.chart.innerRadius) / this.chart.getVisibleDatasetCount();\n                    this.chart.offsetX = offset.x * this.chart.outerRadius;\n                    this.chart.offsetY = offset.y * this.chart.outerRadius;\n\n                    this.getMeta().total = this.calculateTotal();\n\n                    this.outerRadius = this.chart.outerRadius - (this.chart.radiusLength * this.getRingIndex(this.index));\n                    this.innerRadius = this.outerRadius - this.chart.radiusLength;\n\n                    helpers.each(this.getMeta().data, function (arc, index) {\n                        this.updateElement(arc, index, reset);\n                    }, this);\n                },\n\n                updateElement: function (arc, index, reset) {\n                    var centerX = (this.chart.chartArea.left + this.chart.chartArea.right) / 2;\n                    var centerY = (this.chart.chartArea.top + this.chart.chartArea.bottom) / 2;\n                    var startAngle = this.chart.options.rotation; // non reset case handled later\n                    var endAngle = this.chart.options.rotation; // non reset case handled later\n                    var circumference = reset && this.chart.options.animation.animateRotate ? 0 : arc.hidden ? 0 : this.calculateCircumference(this.getDataset().data[index]) * (this.chart.options.circumference / (2.0 * Math.PI));\n                    var innerRadius = reset && this.chart.options.animation.animateScale ? 0 : this.innerRadius;\n                    var outerRadius = reset && this.chart.options.animation.animateScale ? 0 : this.outerRadius;\n\n                    helpers.extend(arc, {\n                        // Utility\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _index: index,\n\n                        // Desired view properties\n                        _model: {\n                            x: centerX + this.chart.offsetX,\n                            y: centerY + this.chart.offsetY,\n                            startAngle: startAngle,\n                            endAngle: endAngle,\n                            circumference: circumference,\n                            outerRadius: outerRadius,\n                            innerRadius: innerRadius,\n\n                            backgroundColor: arc.custom && arc.custom.backgroundColor ? arc.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.arc.backgroundColor),\n                            hoverBackgroundColor: arc.custom && arc.custom.hoverBackgroundColor ? arc.custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().hoverBackgroundColor, index, this.chart.options.elements.arc.hoverBackgroundColor),\n                            borderWidth: arc.custom && arc.custom.borderWidth ? arc.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.arc.borderWidth),\n                            borderColor: arc.custom && arc.custom.borderColor ? arc.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.arc.borderColor),\n\n                            label: helpers.getValueAtIndexOrDefault(this.getDataset().label, index, this.chart.data.labels[index])\n                        }\n                    });\n\n                    // Set correct angles if not resetting\n                    if (!reset || !this.chart.options.animation.animateRotate) {\n\n                        if (index === 0) {\n                            arc._model.startAngle = this.chart.options.rotation;\n                        } else {\n                            arc._model.startAngle = this.getMeta().data[index - 1]._model.endAngle;\n                        }\n\n                        arc._model.endAngle = arc._model.startAngle + arc._model.circumference;\n                    }\n\n                    arc.pivot();\n                },\n\n                draw: function (ease) {\n                    var easingDecimal = ease || 1;\n                    helpers.each(this.getMeta().data, function (arc, index) {\n                        arc.transition(easingDecimal).draw();\n                    });\n                },\n\n                setHoverStyle: function (arc) {\n                    var dataset = this.chart.data.datasets[arc._datasetIndex];\n                    var index = arc._index;\n\n                    arc._model.backgroundColor = arc.custom && arc.custom.hoverBackgroundColor ? arc.custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(dataset.hoverBackgroundColor, index, helpers.color(arc._model.backgroundColor).saturate(0.5).darken(0.1).rgbString());\n                    arc._model.borderColor = arc.custom && arc.custom.hoverBorderColor ? arc.custom.hoverBorderColor : helpers.getValueAtIndexOrDefault(dataset.hoverBorderColor, index, helpers.color(arc._model.borderColor).saturate(0.5).darken(0.1).rgbString());\n                    arc._model.borderWidth = arc.custom && arc.custom.hoverBorderWidth ? arc.custom.hoverBorderWidth : helpers.getValueAtIndexOrDefault(dataset.hoverBorderWidth, index, arc._model.borderWidth);\n                },\n\n                removeHoverStyle: function (arc) {\n                    var dataset = this.chart.data.datasets[arc._datasetIndex];\n                    var index = arc._index;\n\n                    arc._model.backgroundColor = arc.custom && arc.custom.backgroundColor ? arc.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.arc.backgroundColor);\n                    arc._model.borderColor = arc.custom && arc.custom.borderColor ? arc.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.arc.borderColor);\n                    arc._model.borderWidth = arc.custom && arc.custom.borderWidth ? arc.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.arc.borderWidth);\n                },\n\n                calculateTotal: function () {\n                    var dataset = this.getDataset();\n                    var meta = this.getMeta();\n                    var total = 0;\n                    var value;\n\n                    helpers.each(meta.data, function (element, index) {\n                        value = dataset.data[index];\n                        if (!isNaN(value) && !element.hidden) {\n                            total += Math.abs(value);\n                        }\n                    });\n\n                    return total;\n                },\n\n                calculateCircumference: function (value) {\n                    var total = this.getMeta().total;\n                    if (total > 0 && !isNaN(value)) {\n                        return (Math.PI * 2.0) * (value / total);\n                    } else {\n                        return 0;\n                    }\n                }\n            });\n        };\n\n    }, {}], 18: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.line = {\n                showLines: true,\n\n                hover: {\n                    mode: \"label\"\n                },\n\n                scales: {\n                    xAxes: [{\n                        type: \"category\",\n                        id: 'x-axis-0'\n                    }],\n                    yAxes: [{\n                        type: \"linear\",\n                        id: 'y-axis-0'\n                    }]\n                }\n            };\n\n\n            Chart.controllers.line = Chart.DatasetController.extend({\n                addElements: function () {\n                    var meta = this.getMeta();\n                    meta.dataset = meta.dataset || new Chart.elements.Line({\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _points: meta.data\n                    });\n\n                    helpers.each(this.getDataset().data, function (value, index) {\n                        meta.data[index] = meta.data[index] || new Chart.elements.Point({\n                            _chart: this.chart.chart,\n                            _datasetIndex: this.index,\n                            _index: index\n                        });\n                    }, this);\n                },\n\n                addElementAndReset: function (index) {\n                    var point = new Chart.elements.Point({\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _index: index\n                    });\n\n                    // Add to the points array and reset it\n                    this.getMeta().data.splice(index, 0, point);\n                    this.updateElement(point, index, true);\n\n                    // Make sure bezier control points are updated\n                    if (this.chart.options.showLines && this.chart.options.elements.line.tension !== 0)\n                        this.updateBezierControlPoints();\n                },\n\n                update: function update(reset) {\n                    var meta = this.getMeta();\n                    var line = meta.dataset;\n                    var points = meta.data;\n\n                    var yScale = this.getScaleForId(meta.yAxisID);\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var scaleBase;\n\n                    if (yScale.min < 0 && yScale.max < 0) {\n                        scaleBase = yScale.getPixelForValue(yScale.max);\n                    } else if (yScale.min > 0 && yScale.max > 0) {\n                        scaleBase = yScale.getPixelForValue(yScale.min);\n                    } else {\n                        scaleBase = yScale.getPixelForValue(0);\n                    }\n\n                    // Update Line\n                    if (this.chart.options.showLines) {\n                        // Utility\n                        line._scale = yScale;\n                        line._datasetIndex = this.index;\n                        // Data\n                        line._children = points;\n                        // Model\n\n                        // Compatibility: If the properties are defined with only the old name, use those values\n                        if ((this.getDataset().tension !== undefined) && (this.getDataset().lineTension === undefined)) {\n                            this.getDataset().lineTension = this.getDataset().tension;\n                        }\n\n                        line._model = {\n                            // Appearance\n                            tension: line.custom && line.custom.tension ? line.custom.tension : helpers.getValueOrDefault(this.getDataset().lineTension, this.chart.options.elements.line.tension),\n                            backgroundColor: line.custom && line.custom.backgroundColor ? line.custom.backgroundColor : (this.getDataset().backgroundColor || this.chart.options.elements.line.backgroundColor),\n                            borderWidth: line.custom && line.custom.borderWidth ? line.custom.borderWidth : (this.getDataset().borderWidth || this.chart.options.elements.line.borderWidth),\n                            borderColor: line.custom && line.custom.borderColor ? line.custom.borderColor : (this.getDataset().borderColor || this.chart.options.elements.line.borderColor),\n                            borderCapStyle: line.custom && line.custom.borderCapStyle ? line.custom.borderCapStyle : (this.getDataset().borderCapStyle || this.chart.options.elements.line.borderCapStyle),\n                            borderDash: line.custom && line.custom.borderDash ? line.custom.borderDash : (this.getDataset().borderDash || this.chart.options.elements.line.borderDash),\n                            borderDashOffset: line.custom && line.custom.borderDashOffset ? line.custom.borderDashOffset : (this.getDataset().borderDashOffset || this.chart.options.elements.line.borderDashOffset),\n                            borderJoinStyle: line.custom && line.custom.borderJoinStyle ? line.custom.borderJoinStyle : (this.getDataset().borderJoinStyle || this.chart.options.elements.line.borderJoinStyle),\n                            fill: line.custom && line.custom.fill ? line.custom.fill : (this.getDataset().fill !== undefined ? this.getDataset().fill : this.chart.options.elements.line.fill),\n                            // Scale\n                            scaleTop: yScale.top,\n                            scaleBottom: yScale.bottom,\n                            scaleZero: scaleBase\n                        };\n                        line.pivot();\n                    }\n\n                    // Update Points\n                    helpers.each(points, function (point, index) {\n                        this.updateElement(point, index, reset);\n                    }, this);\n\n                    if (this.chart.options.showLines && this.chart.options.elements.line.tension !== 0)\n                        this.updateBezierControlPoints();\n                },\n\n                getPointBackgroundColor: function (point, index) {\n                    var backgroundColor = this.chart.options.elements.point.backgroundColor;\n                    var dataset = this.getDataset();\n\n                    if (point.custom && point.custom.backgroundColor) {\n                        backgroundColor = point.custom.backgroundColor;\n                    } else if (dataset.pointBackgroundColor) {\n                        backgroundColor = helpers.getValueAtIndexOrDefault(dataset.pointBackgroundColor, index, backgroundColor);\n                    } else if (dataset.backgroundColor) {\n                        backgroundColor = dataset.backgroundColor;\n                    }\n\n                    return backgroundColor;\n                },\n                getPointBorderColor: function (point, index) {\n                    var borderColor = this.chart.options.elements.point.borderColor;\n                    var dataset = this.getDataset();\n\n                    if (point.custom && point.custom.borderColor) {\n                        borderColor = point.custom.borderColor;\n                    } else if (dataset.pointBorderColor) {\n                        borderColor = helpers.getValueAtIndexOrDefault(this.getDataset().pointBorderColor, index, borderColor);\n                    } else if (dataset.borderColor) {\n                        borderColor = dataset.borderColor;\n                    }\n\n                    return borderColor;\n                },\n                getPointBorderWidth: function (point, index) {\n                    var borderWidth = this.chart.options.elements.point.borderWidth;\n                    var dataset = this.getDataset();\n\n                    if (point.custom && point.custom.borderWidth !== undefined) {\n                        borderWidth = point.custom.borderWidth;\n                    } else if (dataset.pointBorderWidth !== undefined) {\n                        borderWidth = helpers.getValueAtIndexOrDefault(dataset.pointBorderWidth, index, borderWidth);\n                    } else if (dataset.borderWidth !== undefined) {\n                        borderWidth = dataset.borderWidth;\n                    }\n\n                    return borderWidth;\n                },\n\n                updateElement: function (point, index, reset) {\n                    var meta = this.getMeta();\n                    var yScale = this.getScaleForId(meta.yAxisID);\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var scaleBase;\n\n                    if (yScale.min < 0 && yScale.max < 0) {\n                        scaleBase = yScale.getPixelForValue(yScale.max);\n                    } else if (yScale.min > 0 && yScale.max > 0) {\n                        scaleBase = yScale.getPixelForValue(yScale.min);\n                    } else {\n                        scaleBase = yScale.getPixelForValue(0);\n                    }\n\n                    // Utility\n                    point._chart = this.chart.chart;\n                    point._xScale = xScale;\n                    point._yScale = yScale;\n                    point._datasetIndex = this.index;\n                    point._index = index;\n\n                    // Desired view properties\n\n                    // Compatibility: If the properties are defined with only the old name, use those values\n                    if ((this.getDataset().radius !== undefined) && (this.getDataset().pointRadius === undefined)) {\n                        this.getDataset().pointRadius = this.getDataset().radius;\n                    }\n                    if ((this.getDataset().hitRadius !== undefined) && (this.getDataset().pointHitRadius === undefined)) {\n                        this.getDataset().pointHitRadius = this.getDataset().hitRadius;\n                    }\n\n                    point._model = {\n                        x: xScale.getPixelForValue(this.getDataset().data[index], index, this.index, this.chart.isCombo),\n                        y: reset ? scaleBase : this.calculatePointY(this.getDataset().data[index], index, this.index, this.chart.isCombo),\n                        // Appearance\n                        radius: point.custom && point.custom.radius ? point.custom.radius : helpers.getValueAtIndexOrDefault(this.getDataset().pointRadius, index, this.chart.options.elements.point.radius),\n                        pointStyle: point.custom && point.custom.pointStyle ? point.custom.pointStyle : helpers.getValueAtIndexOrDefault(this.getDataset().pointStyle, index, this.chart.options.elements.point.pointStyle),\n                        backgroundColor: this.getPointBackgroundColor(point, index),\n                        borderColor: this.getPointBorderColor(point, index),\n                        borderWidth: this.getPointBorderWidth(point, index),\n                        tension: meta.dataset._model ? meta.dataset._model.tension : 0,\n                        // Tooltip\n                        hitRadius: point.custom && point.custom.hitRadius ? point.custom.hitRadius : helpers.getValueAtIndexOrDefault(this.getDataset().pointHitRadius, index, this.chart.options.elements.point.hitRadius)\n                    };\n\n                    point._model.skip = point.custom && point.custom.skip ? point.custom.skip : (isNaN(point._model.x) || isNaN(point._model.y));\n                },\n\n                calculatePointY: function (value, index, datasetIndex, isCombo) {\n                    var meta = this.getMeta();\n                    var xScale = this.getScaleForId(meta.xAxisID);\n                    var yScale = this.getScaleForId(meta.yAxisID);\n\n                    if (yScale.options.stacked) {\n\n                        var sumPos = 0,\n                            sumNeg = 0;\n\n                        for (var i = 0; i < datasetIndex; i++) {\n                            var ds = this.chart.data.datasets[i];\n                            var dsMeta = this.chart.getDatasetMeta(i);\n                            if (dsMeta.type === 'line' && this.chart.isDatasetVisible(i)) {\n                                if (ds.data[index] < 0) {\n                                    sumNeg += ds.data[index] || 0;\n                                } else {\n                                    sumPos += ds.data[index] || 0;\n                                }\n                            }\n                        }\n\n                        if (value < 0) {\n                            return yScale.getPixelForValue(sumNeg + value);\n                        } else {\n                            return yScale.getPixelForValue(sumPos + value);\n                        }\n                    }\n\n                    return yScale.getPixelForValue(value);\n                },\n\n                updateBezierControlPoints: function () {\n                    // Update bezier control points\n                    var meta = this.getMeta();\n                    helpers.each(meta.data, function (point, index) {\n                        var controlPoints = helpers.splineCurve(\n                            helpers.previousItem(meta.data, index)._model,\n                            point._model,\n                            helpers.nextItem(meta.data, index)._model,\n                            meta.dataset._model.tension\n                        );\n\n                        // Prevent the bezier going outside of the bounds of the graph\n                        point._model.controlPointPreviousX = Math.max(Math.min(controlPoints.previous.x, this.chart.chartArea.right), this.chart.chartArea.left);\n                        point._model.controlPointPreviousY = Math.max(Math.min(controlPoints.previous.y, this.chart.chartArea.bottom), this.chart.chartArea.top);\n\n                        point._model.controlPointNextX = Math.max(Math.min(controlPoints.next.x, this.chart.chartArea.right), this.chart.chartArea.left);\n                        point._model.controlPointNextY = Math.max(Math.min(controlPoints.next.y, this.chart.chartArea.bottom), this.chart.chartArea.top);\n\n                        // Now pivot the point for animation\n                        point.pivot();\n                    }, this);\n                },\n\n                draw: function (ease) {\n                    var meta = this.getMeta();\n                    var easingDecimal = ease || 1;\n\n                    // Transition Point Locations\n                    helpers.each(meta.data, function (point) {\n                        point.transition(easingDecimal);\n                    });\n\n                    // Transition and Draw the line\n                    if (this.chart.options.showLines)\n                        meta.dataset.transition(easingDecimal).draw();\n\n                    // Draw the points\n                    helpers.each(meta.data, function (point) {\n                        point.draw();\n                    });\n                },\n\n                setHoverStyle: function (point) {\n                    // Point\n                    var dataset = this.chart.data.datasets[point._datasetIndex];\n                    var index = point._index;\n\n                    point._model.radius = point.custom && point.custom.hoverRadius ? point.custom.hoverRadius : helpers.getValueAtIndexOrDefault(dataset.pointHoverRadius, index, this.chart.options.elements.point.hoverRadius);\n                    point._model.backgroundColor = point.custom && point.custom.hoverBackgroundColor ? point.custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(dataset.pointHoverBackgroundColor, index, helpers.color(point._model.backgroundColor).saturate(0.5).darken(0.1).rgbString());\n                    point._model.borderColor = point.custom && point.custom.hoverBorderColor ? point.custom.hoverBorderColor : helpers.getValueAtIndexOrDefault(dataset.pointHoverBorderColor, index, helpers.color(point._model.borderColor).saturate(0.5).darken(0.1).rgbString());\n                    point._model.borderWidth = point.custom && point.custom.hoverBorderWidth ? point.custom.hoverBorderWidth : helpers.getValueAtIndexOrDefault(dataset.pointHoverBorderWidth, index, point._model.borderWidth);\n                },\n\n                removeHoverStyle: function (point) {\n                    var dataset = this.chart.data.datasets[point._datasetIndex];\n                    var index = point._index;\n\n                    // Compatibility: If the properties are defined with only the old name, use those values\n                    if ((this.getDataset().radius !== undefined) && (this.getDataset().pointRadius === undefined)) {\n                        this.getDataset().pointRadius = this.getDataset().radius;\n                    }\n\n                    point._model.radius = point.custom && point.custom.radius ? point.custom.radius : helpers.getValueAtIndexOrDefault(this.getDataset().pointRadius, index, this.chart.options.elements.point.radius);\n                    point._model.backgroundColor = this.getPointBackgroundColor(point, index);\n                    point._model.borderColor = this.getPointBorderColor(point, index);\n                    point._model.borderWidth = this.getPointBorderWidth(point, index);\n                }\n            });\n        };\n\n    }, {}], 19: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.polarArea = {\n\n                scale: {\n                    type: \"radialLinear\",\n                    lineArc: true // so that lines are circular\n                },\n\n                //Boolean - Whether to animate the rotation of the chart\n                animation: {\n                    animateRotate: true,\n                    animateScale: true\n                },\n\n                aspectRatio: 1,\n                legendCallback: function (chart) {\n                    var text = [];\n                    text.push('<ul class=\"' + chart.id + '-legend\">');\n\n                    if (chart.data.datasets.length) {\n                        for (var i = 0; i < chart.data.datasets[0].data.length; ++i) {\n                            text.push('<li><span style=\"background-color:' + chart.data.datasets[0].backgroundColor[i] + '\">');\n                            if (chart.data.labels[i]) {\n                                text.push(chart.data.labels[i]);\n                            }\n                            text.push('</span></li>');\n                        }\n                    }\n\n                    text.push('</ul>');\n                    return text.join(\"\");\n                },\n                legend: {\n                    labels: {\n                        generateLabels: function (chart) {\n                            var data = chart.data;\n                            if (data.labels.length && data.datasets.length) {\n                                return data.labels.map(function (label, i) {\n                                    var meta = chart.getDatasetMeta(0);\n                                    var ds = data.datasets[0];\n                                    var arc = meta.data[i];\n                                    var fill = arc.custom && arc.custom.backgroundColor ? arc.custom.backgroundColor : helpers.getValueAtIndexOrDefault(ds.backgroundColor, i, this.chart.options.elements.arc.backgroundColor);\n                                    var stroke = arc.custom && arc.custom.borderColor ? arc.custom.borderColor : helpers.getValueAtIndexOrDefault(ds.borderColor, i, this.chart.options.elements.arc.borderColor);\n                                    var bw = arc.custom && arc.custom.borderWidth ? arc.custom.borderWidth : helpers.getValueAtIndexOrDefault(ds.borderWidth, i, this.chart.options.elements.arc.borderWidth);\n\n                                    return {\n                                        text: label,\n                                        fillStyle: fill,\n                                        strokeStyle: stroke,\n                                        lineWidth: bw,\n                                        hidden: isNaN(ds.data[i]) || meta.data[i].hidden,\n\n                                        // Extra data used for toggling the correct item\n                                        index: i\n                                    };\n                                }, this);\n                            } else {\n                                return [];\n                            }\n                        }\n                    },\n\n                    onClick: function (e, legendItem) {\n                        var index = legendItem.index;\n                        var chart = this.chart;\n                        var i, ilen, meta;\n\n                        for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {\n                            meta = chart.getDatasetMeta(i);\n                            meta.data[index].hidden = !meta.data[index].hidden;\n                        }\n\n                        chart.update();\n                    }\n                },\n\n                // Need to override these to give a nice default\n                tooltips: {\n                    callbacks: {\n                        title: function () {\n                            return '';\n                        },\n                        label: function (tooltipItem, data) {\n                            return data.labels[tooltipItem.index] + ': ' + tooltipItem.yLabel;\n                        }\n                    }\n                }\n            };\n\n            Chart.controllers.polarArea = Chart.DatasetController.extend({\n                linkScales: function () {\n                    // no scales for doughnut\n                },\n\n                addElements: function () {\n                    var meta = this.getMeta();\n                    helpers.each(this.getDataset().data, function (value, index) {\n                        meta.data[index] = meta.data[index] || new Chart.elements.Arc({\n                            _chart: this.chart.chart,\n                            _datasetIndex: this.index,\n                            _index: index\n                        });\n                    }, this);\n                },\n\n                addElementAndReset: function (index) {\n                    var arc = new Chart.elements.Arc({\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _index: index\n                    });\n\n                    // Add to the points array and reset it\n                    this.getMeta().data.splice(index, 0, arc);\n                    this.updateElement(arc, index, true);\n                },\n\n                update: function update(reset) {\n                    var meta = this.getMeta();\n                    var minSize = Math.min(this.chart.chartArea.right - this.chart.chartArea.left, this.chart.chartArea.bottom - this.chart.chartArea.top);\n                    this.chart.outerRadius = Math.max((minSize - this.chart.options.elements.arc.borderWidth / 2) / 2, 0);\n                    this.chart.innerRadius = Math.max(this.chart.options.cutoutPercentage ? (this.chart.outerRadius / 100) * (this.chart.options.cutoutPercentage) : 1, 0);\n                    this.chart.radiusLength = (this.chart.outerRadius - this.chart.innerRadius) / this.chart.getVisibleDatasetCount();\n\n                    this.outerRadius = this.chart.outerRadius - (this.chart.radiusLength * this.index);\n                    this.innerRadius = this.outerRadius - this.chart.radiusLength;\n\n                    meta.count = this.countVisibleElements();\n\n                    helpers.each(meta.data, function (arc, index) {\n                        this.updateElement(arc, index, reset);\n                    }, this);\n                },\n\n                updateElement: function (arc, index, reset) {\n                    var circumference = this.calculateCircumference(this.getDataset().data[index]);\n                    var centerX = (this.chart.chartArea.left + this.chart.chartArea.right) / 2;\n                    var centerY = (this.chart.chartArea.top + this.chart.chartArea.bottom) / 2;\n\n                    // If there is NaN data before us, we need to calculate the starting angle correctly.\n                    // We could be way more efficient here, but its unlikely that the polar area chart will have a lot of data\n                    var visibleCount = 0;\n                    var meta = this.getMeta();\n                    for (var i = 0; i < index; ++i) {\n                        if (!isNaN(this.getDataset().data[i]) && !meta.data[i].hidden) {\n                            ++visibleCount;\n                        }\n                    }\n\n                    var distance = arc.hidden ? 0 : this.chart.scale.getDistanceFromCenterForValue(this.getDataset().data[index]);\n                    var startAngle = (-0.5 * Math.PI) + (circumference * visibleCount);\n                    var endAngle = startAngle + (arc.hidden ? 0 : circumference);\n\n                    var resetModel = {\n                        x: centerX,\n                        y: centerY,\n                        innerRadius: 0,\n                        outerRadius: this.chart.options.animation.animateScale ? 0 : this.chart.scale.getDistanceFromCenterForValue(this.getDataset().data[index]),\n                        startAngle: this.chart.options.animation.animateRotate ? Math.PI * -0.5 : startAngle,\n                        endAngle: this.chart.options.animation.animateRotate ? Math.PI * -0.5 : endAngle,\n\n                        backgroundColor: arc.custom && arc.custom.backgroundColor ? arc.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.arc.backgroundColor),\n                        borderWidth: arc.custom && arc.custom.borderWidth ? arc.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.arc.borderWidth),\n                        borderColor: arc.custom && arc.custom.borderColor ? arc.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.arc.borderColor),\n\n                        label: helpers.getValueAtIndexOrDefault(this.chart.data.labels, index, this.chart.data.labels[index])\n                    };\n\n                    helpers.extend(arc, {\n                        // Utility\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _index: index,\n                        _scale: this.chart.scale,\n\n                        // Desired view properties\n                        _model: reset ? resetModel : {\n                            x: centerX,\n                            y: centerY,\n                            innerRadius: 0,\n                            outerRadius: distance,\n                            startAngle: startAngle,\n                            endAngle: endAngle,\n\n                            backgroundColor: arc.custom && arc.custom.backgroundColor ? arc.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.arc.backgroundColor),\n                            borderWidth: arc.custom && arc.custom.borderWidth ? arc.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.arc.borderWidth),\n                            borderColor: arc.custom && arc.custom.borderColor ? arc.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.arc.borderColor),\n\n                            label: helpers.getValueAtIndexOrDefault(this.chart.data.labels, index, this.chart.data.labels[index])\n                        }\n                    });\n\n                    arc.pivot();\n                },\n\n                draw: function (ease) {\n                    var easingDecimal = ease || 1;\n                    helpers.each(this.getMeta().data, function (arc, index) {\n                        arc.transition(easingDecimal).draw();\n                    });\n                },\n\n                setHoverStyle: function (arc) {\n                    var dataset = this.chart.data.datasets[arc._datasetIndex];\n                    var index = arc._index;\n\n                    arc._model.backgroundColor = arc.custom && arc.custom.hoverBackgroundColor ? arc.custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(dataset.hoverBackgroundColor, index, helpers.color(arc._model.backgroundColor).saturate(0.5).darken(0.1).rgbString());\n                    arc._model.borderColor = arc.custom && arc.custom.hoverBorderColor ? arc.custom.hoverBorderColor : helpers.getValueAtIndexOrDefault(dataset.hoverBorderColor, index, helpers.color(arc._model.borderColor).saturate(0.5).darken(0.1).rgbString());\n                    arc._model.borderWidth = arc.custom && arc.custom.hoverBorderWidth ? arc.custom.hoverBorderWidth : helpers.getValueAtIndexOrDefault(dataset.hoverBorderWidth, index, arc._model.borderWidth);\n                },\n\n                removeHoverStyle: function (arc) {\n                    var dataset = this.chart.data.datasets[arc._datasetIndex];\n                    var index = arc._index;\n\n                    arc._model.backgroundColor = arc.custom && arc.custom.backgroundColor ? arc.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().backgroundColor, index, this.chart.options.elements.arc.backgroundColor);\n                    arc._model.borderColor = arc.custom && arc.custom.borderColor ? arc.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().borderColor, index, this.chart.options.elements.arc.borderColor);\n                    arc._model.borderWidth = arc.custom && arc.custom.borderWidth ? arc.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().borderWidth, index, this.chart.options.elements.arc.borderWidth);\n                },\n\n                countVisibleElements: function () {\n                    var dataset = this.getDataset();\n                    var meta = this.getMeta();\n                    var count = 0;\n\n                    helpers.each(meta.data, function (element, index) {\n                        if (!isNaN(dataset.data[index]) && !element.hidden) {\n                            count++;\n                        }\n                    });\n\n                    return count;\n                },\n\n                calculateCircumference: function (value) {\n                    var count = this.getMeta().count;\n                    if (count > 0 && !isNaN(value)) {\n                        return (2 * Math.PI) / count;\n                    } else {\n                        return 0;\n                    }\n                }\n            });\n        };\n\n    }, {}], 20: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n\n            Chart.defaults.radar = {\n                scale: {\n                    type: \"radialLinear\"\n                },\n                elements: {\n                    line: {\n                        tension: 0 // no bezier in radar\n                    }\n                }\n            };\n\n            Chart.controllers.radar = Chart.DatasetController.extend({\n                linkScales: function () {\n                    // No need. Single scale only\n                },\n\n                addElements: function () {\n                    var meta = this.getMeta();\n\n                    meta.dataset = meta.dataset || new Chart.elements.Line({\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _points: meta.data,\n                        _loop: true\n                    });\n\n                    helpers.each(this.getDataset().data, function (value, index) {\n                        meta.data[index] = meta.data[index] || new Chart.elements.Point({\n                            _chart: this.chart.chart,\n                            _datasetIndex: this.index,\n                            _index: index,\n                            _model: {\n                                x: 0, //xScale.getPixelForValue(null, index, true),\n                                y: 0 //this.chartArea.bottom,\n                            }\n                        });\n                    }, this);\n                },\n                addElementAndReset: function (index) {\n                    var point = new Chart.elements.Point({\n                        _chart: this.chart.chart,\n                        _datasetIndex: this.index,\n                        _index: index\n                    });\n\n                    // Add to the points array and reset it\n                    this.getMeta().data.splice(index, 0, point);\n                    this.updateElement(point, index, true);\n\n                    // Make sure bezier control points are updated\n                    this.updateBezierControlPoints();\n                },\n\n                update: function update(reset) {\n                    var meta = this.getMeta();\n                    var line = meta.dataset;\n                    var points = meta.data;\n\n                    var scale = this.chart.scale;\n                    var scaleBase;\n\n                    if (scale.min < 0 && scale.max < 0) {\n                        scaleBase = scale.getPointPositionForValue(0, scale.max);\n                    } else if (scale.min > 0 && scale.max > 0) {\n                        scaleBase = scale.getPointPositionForValue(0, scale.min);\n                    } else {\n                        scaleBase = scale.getPointPositionForValue(0, 0);\n                    }\n\n                    // Compatibility: If the properties are defined with only the old name, use those values\n                    if ((this.getDataset().tension !== undefined) && (this.getDataset().lineTension === undefined)) {\n                        this.getDataset().lineTension = this.getDataset().tension;\n                    }\n\n                    helpers.extend(meta.dataset, {\n                        // Utility\n                        _datasetIndex: this.index,\n                        // Data\n                        _children: points,\n                        // Model\n                        _model: {\n                            // Appearance\n                            tension: line.custom && line.custom.tension ? line.custom.tension : helpers.getValueOrDefault(this.getDataset().lineTension, this.chart.options.elements.line.tension),\n                            backgroundColor: line.custom && line.custom.backgroundColor ? line.custom.backgroundColor : (this.getDataset().backgroundColor || this.chart.options.elements.line.backgroundColor),\n                            borderWidth: line.custom && line.custom.borderWidth ? line.custom.borderWidth : (this.getDataset().borderWidth || this.chart.options.elements.line.borderWidth),\n                            borderColor: line.custom && line.custom.borderColor ? line.custom.borderColor : (this.getDataset().borderColor || this.chart.options.elements.line.borderColor),\n                            fill: line.custom && line.custom.fill ? line.custom.fill : (this.getDataset().fill !== undefined ? this.getDataset().fill : this.chart.options.elements.line.fill),\n                            borderCapStyle: line.custom && line.custom.borderCapStyle ? line.custom.borderCapStyle : (this.getDataset().borderCapStyle || this.chart.options.elements.line.borderCapStyle),\n                            borderDash: line.custom && line.custom.borderDash ? line.custom.borderDash : (this.getDataset().borderDash || this.chart.options.elements.line.borderDash),\n                            borderDashOffset: line.custom && line.custom.borderDashOffset ? line.custom.borderDashOffset : (this.getDataset().borderDashOffset || this.chart.options.elements.line.borderDashOffset),\n                            borderJoinStyle: line.custom && line.custom.borderJoinStyle ? line.custom.borderJoinStyle : (this.getDataset().borderJoinStyle || this.chart.options.elements.line.borderJoinStyle),\n\n                            // Scale\n                            scaleTop: scale.top,\n                            scaleBottom: scale.bottom,\n                            scaleZero: scaleBase\n                        }\n                    });\n\n                    meta.dataset.pivot();\n\n                    // Update Points\n                    helpers.each(points, function (point, index) {\n                        this.updateElement(point, index, reset);\n                    }, this);\n\n\n                    // Update bezier control points\n                    this.updateBezierControlPoints();\n                },\n                updateElement: function (point, index, reset) {\n                    var pointPosition = this.chart.scale.getPointPositionForValue(index, this.getDataset().data[index]);\n\n                    helpers.extend(point, {\n                        // Utility\n                        _datasetIndex: this.index,\n                        _index: index,\n                        _scale: this.chart.scale,\n\n                        // Desired view properties\n                        _model: {\n                            x: reset ? this.chart.scale.xCenter : pointPosition.x, // value not used in dataset scale, but we want a consistent API between scales\n                            y: reset ? this.chart.scale.yCenter : pointPosition.y,\n\n                            // Appearance\n                            tension: point.custom && point.custom.tension ? point.custom.tension : helpers.getValueOrDefault(this.getDataset().tension, this.chart.options.elements.line.tension),\n                            radius: point.custom && point.custom.radius ? point.custom.radius : helpers.getValueAtIndexOrDefault(this.getDataset().pointRadius, index, this.chart.options.elements.point.radius),\n                            backgroundColor: point.custom && point.custom.backgroundColor ? point.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().pointBackgroundColor, index, this.chart.options.elements.point.backgroundColor),\n                            borderColor: point.custom && point.custom.borderColor ? point.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().pointBorderColor, index, this.chart.options.elements.point.borderColor),\n                            borderWidth: point.custom && point.custom.borderWidth ? point.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().pointBorderWidth, index, this.chart.options.elements.point.borderWidth),\n                            pointStyle: point.custom && point.custom.pointStyle ? point.custom.pointStyle : helpers.getValueAtIndexOrDefault(this.getDataset().pointStyle, index, this.chart.options.elements.point.pointStyle),\n\n                            // Tooltip\n                            hitRadius: point.custom && point.custom.hitRadius ? point.custom.hitRadius : helpers.getValueAtIndexOrDefault(this.getDataset().hitRadius, index, this.chart.options.elements.point.hitRadius)\n                        }\n                    });\n\n                    point._model.skip = point.custom && point.custom.skip ? point.custom.skip : (isNaN(point._model.x) || isNaN(point._model.y));\n                },\n                updateBezierControlPoints: function () {\n                    var meta = this.getMeta();\n                    helpers.each(meta.data, function (point, index) {\n                        var controlPoints = helpers.splineCurve(\n                            helpers.previousItem(meta.data, index, true)._model,\n                            point._model,\n                            helpers.nextItem(meta.data, index, true)._model,\n                            point._model.tension\n                        );\n\n                        // Prevent the bezier going outside of the bounds of the graph\n                        point._model.controlPointPreviousX = Math.max(Math.min(controlPoints.previous.x, this.chart.chartArea.right), this.chart.chartArea.left);\n                        point._model.controlPointPreviousY = Math.max(Math.min(controlPoints.previous.y, this.chart.chartArea.bottom), this.chart.chartArea.top);\n\n                        point._model.controlPointNextX = Math.max(Math.min(controlPoints.next.x, this.chart.chartArea.right), this.chart.chartArea.left);\n                        point._model.controlPointNextY = Math.max(Math.min(controlPoints.next.y, this.chart.chartArea.bottom), this.chart.chartArea.top);\n\n                        // Now pivot the point for animation\n                        point.pivot();\n                    }, this);\n                },\n\n                draw: function (ease) {\n                    var meta = this.getMeta();\n                    var easingDecimal = ease || 1;\n\n                    // Transition Point Locations\n                    helpers.each(meta.data, function (point, index) {\n                        point.transition(easingDecimal);\n                    });\n\n                    // Transition and Draw the line\n                    meta.dataset.transition(easingDecimal).draw();\n\n                    // Draw the points\n                    helpers.each(meta.data, function (point) {\n                        point.draw();\n                    });\n                },\n\n                setHoverStyle: function (point) {\n                    // Point\n                    var dataset = this.chart.data.datasets[point._datasetIndex];\n                    var index = point._index;\n\n                    point._model.radius = point.custom && point.custom.hoverRadius ? point.custom.hoverRadius : helpers.getValueAtIndexOrDefault(dataset.pointHoverRadius, index, this.chart.options.elements.point.hoverRadius);\n                    point._model.backgroundColor = point.custom && point.custom.hoverBackgroundColor ? point.custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(dataset.pointHoverBackgroundColor, index, helpers.color(point._model.backgroundColor).saturate(0.5).darken(0.1).rgbString());\n                    point._model.borderColor = point.custom && point.custom.hoverBorderColor ? point.custom.hoverBorderColor : helpers.getValueAtIndexOrDefault(dataset.pointHoverBorderColor, index, helpers.color(point._model.borderColor).saturate(0.5).darken(0.1).rgbString());\n                    point._model.borderWidth = point.custom && point.custom.hoverBorderWidth ? point.custom.hoverBorderWidth : helpers.getValueAtIndexOrDefault(dataset.pointHoverBorderWidth, index, point._model.borderWidth);\n                },\n\n                removeHoverStyle: function (point) {\n                    var dataset = this.chart.data.datasets[point._datasetIndex];\n                    var index = point._index;\n\n                    point._model.radius = point.custom && point.custom.radius ? point.custom.radius : helpers.getValueAtIndexOrDefault(this.getDataset().radius, index, this.chart.options.elements.point.radius);\n                    point._model.backgroundColor = point.custom && point.custom.backgroundColor ? point.custom.backgroundColor : helpers.getValueAtIndexOrDefault(this.getDataset().pointBackgroundColor, index, this.chart.options.elements.point.backgroundColor);\n                    point._model.borderColor = point.custom && point.custom.borderColor ? point.custom.borderColor : helpers.getValueAtIndexOrDefault(this.getDataset().pointBorderColor, index, this.chart.options.elements.point.borderColor);\n                    point._model.borderWidth = point.custom && point.custom.borderWidth ? point.custom.borderWidth : helpers.getValueAtIndexOrDefault(this.getDataset().pointBorderWidth, index, this.chart.options.elements.point.borderWidth);\n                }\n            });\n        };\n    }, {}], 21: [function (require, module, exports) {\n        /*global window: false */\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.global.animation = {\n                duration: 1000,\n                easing: \"easeOutQuart\",\n                onProgress: helpers.noop,\n                onComplete: helpers.noop\n            };\n\n            Chart.Animation = Chart.Element.extend({\n                currentStep: null, // the current animation step\n                numSteps: 60, // default number of steps\n                easing: \"\", // the easing to use for this animation\n                render: null, // render function used by the animation service\n\n                onAnimationProgress: null, // user specified callback to fire on each step of the animation\n                onAnimationComplete: null // user specified callback to fire when the animation finishes\n            });\n\n            Chart.animationService = {\n                frameDuration: 17,\n                animations: [],\n                dropFrames: 0,\n                request: null,\n                addAnimation: function (chartInstance, animationObject, duration, lazy) {\n\n                    if (!lazy) {\n                        chartInstance.animating = true;\n                    }\n\n                    for (var index = 0; index < this.animations.length; ++index) {\n                        if (this.animations[index].chartInstance === chartInstance) {\n                            // replacing an in progress animation\n                            this.animations[index].animationObject = animationObject;\n                            return;\n                        }\n                    }\n\n                    this.animations.push({\n                        chartInstance: chartInstance,\n                        animationObject: animationObject\n                    });\n\n                    // If there are no animations queued, manually kickstart a digest, for lack of a better word\n                    if (this.animations.length === 1) {\n                        this.requestAnimationFrame();\n                    }\n                },\n                // Cancel the animation for a given chart instance\n                cancelAnimation: function (chartInstance) {\n                    var index = helpers.findIndex(this.animations, function (animationWrapper) {\n                        return animationWrapper.chartInstance === chartInstance;\n                    });\n\n                    if (index !== -1) {\n                        this.animations.splice(index, 1);\n                        chartInstance.animating = false;\n                    }\n                },\n                requestAnimationFrame: function () {\n                    var me = this;\n                    if (me.request === null) {\n                        // Skip animation frame requests until the active one is executed.\n                        // This can happen when processing mouse events, e.g. 'mousemove'\n                        // and 'mouseout' events will trigger multiple renders.\n                        me.request = helpers.requestAnimFrame.call(window, function () {\n                            me.request = null;\n                            me.startDigest();\n                        });\n                    }\n                },\n                startDigest: function () {\n\n                    var startTime = Date.now();\n                    var framesToDrop = 0;\n\n                    if (this.dropFrames > 1) {\n                        framesToDrop = Math.floor(this.dropFrames);\n                        this.dropFrames = this.dropFrames % 1;\n                    }\n\n                    var i = 0;\n                    while (i < this.animations.length) {\n                        if (this.animations[i].animationObject.currentStep === null) {\n                            this.animations[i].animationObject.currentStep = 0;\n                        }\n\n                        this.animations[i].animationObject.currentStep += 1 + framesToDrop;\n\n                        if (this.animations[i].animationObject.currentStep > this.animations[i].animationObject.numSteps) {\n                            this.animations[i].animationObject.currentStep = this.animations[i].animationObject.numSteps;\n                        }\n\n                        this.animations[i].animationObject.render(this.animations[i].chartInstance, this.animations[i].animationObject);\n                        if (this.animations[i].animationObject.onAnimationProgress && this.animations[i].animationObject.onAnimationProgress.call) {\n                            this.animations[i].animationObject.onAnimationProgress.call(this.animations[i].chartInstance, this.animations[i]);\n                        }\n\n                        if (this.animations[i].animationObject.currentStep === this.animations[i].animationObject.numSteps) {\n                            if (this.animations[i].animationObject.onAnimationComplete && this.animations[i].animationObject.onAnimationComplete.call) {\n                                this.animations[i].animationObject.onAnimationComplete.call(this.animations[i].chartInstance, this.animations[i]);\n                            }\n\n                            // executed the last frame. Remove the animation.\n                            this.animations[i].chartInstance.animating = false;\n\n                            this.animations.splice(i, 1);\n                        } else {\n                            ++i;\n                        }\n                    }\n\n                    var endTime = Date.now();\n                    var dropFrames = (endTime - startTime) / this.frameDuration;\n\n                    this.dropFrames += dropFrames;\n\n                    // Do we have more stuff to animate?\n                    if (this.animations.length > 0) {\n                        this.requestAnimationFrame();\n                    }\n                }\n            };\n        };\n    }, {}], 22: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n            //Create a dictionary of chart types, to allow for extension of existing types\n            Chart.types = {};\n\n            //Store a reference to each instance - allowing us to globally resize chart instances on window resize.\n            //Destroy method on the chart will remove the instance of the chart from this reference.\n            Chart.instances = {};\n\n            // Controllers available for dataset visualization eg. bar, line, slice, etc.\n            Chart.controllers = {};\n\n            // The main controller of a chart\n            Chart.Controller = function (instance) {\n\n                this.chart = instance;\n                this.config = instance.config;\n                this.options = this.config.options = helpers.configMerge(Chart.defaults.global, Chart.defaults[this.config.type], this.config.options || {});\n                this.id = helpers.uid();\n\n                Object.defineProperty(this, 'data', {\n                    get: function () {\n                        return this.config.data;\n                    }\n                });\n\n                //Add the chart instance to the global namespace\n                Chart.instances[this.id] = this;\n\n                if (this.options.responsive) {\n                    // Silent resize before chart draws\n                    this.resize(true);\n                }\n\n                this.initialize();\n\n                return this;\n            };\n\n            helpers.extend(Chart.Controller.prototype, {\n\n                initialize: function initialize() {\n                    // Before init plugin notification\n                    Chart.pluginService.notifyPlugins('beforeInit', [this]);\n\n                    this.bindEvents();\n\n                    // Make sure controllers are built first so that each dataset is bound to an axis before the scales\n                    // are built\n                    this.ensureScalesHaveIDs();\n                    this.buildOrUpdateControllers();\n                    this.buildScales();\n                    this.buildSurroundingItems();\n                    this.updateLayout();\n                    this.resetElements();\n                    this.initToolTip();\n                    this.update();\n\n                    // After init plugin notification\n                    Chart.pluginService.notifyPlugins('afterInit', [this]);\n\n                    return this;\n                },\n\n                clear: function clear() {\n                    helpers.clear(this.chart);\n                    return this;\n                },\n\n                stop: function stop() {\n                    // Stops any current animation loop occuring\n                    Chart.animationService.cancelAnimation(this);\n                    return this;\n                },\n\n                resize: function resize(silent) {\n                    var canvas = this.chart.canvas;\n                    var newWidth = helpers.getMaximumWidth(this.chart.canvas);\n                    var newHeight = (this.options.maintainAspectRatio && isNaN(this.chart.aspectRatio) === false && isFinite(this.chart.aspectRatio) && this.chart.aspectRatio !== 0) ? newWidth / this.chart.aspectRatio : helpers.getMaximumHeight(this.chart.canvas);\n\n                    var sizeChanged = this.chart.width !== newWidth || this.chart.height !== newHeight;\n\n                    if (!sizeChanged)\n                        return this;\n\n                    canvas.width = this.chart.width = newWidth;\n                    canvas.height = this.chart.height = newHeight;\n\n                    helpers.retinaScale(this.chart);\n\n                    if (!silent) {\n                        this.stop();\n                        this.update(this.options.responsiveAnimationDuration);\n                    }\n\n                    return this;\n                },\n                ensureScalesHaveIDs: function ensureScalesHaveIDs() {\n                    var defaultXAxisID = 'x-axis-';\n                    var defaultYAxisID = 'y-axis-';\n\n                    if (this.options.scales) {\n                        if (this.options.scales.xAxes && this.options.scales.xAxes.length) {\n                            helpers.each(this.options.scales.xAxes, function (xAxisOptions, index) {\n                                xAxisOptions.id = xAxisOptions.id || (defaultXAxisID + index);\n                            });\n                        }\n\n                        if (this.options.scales.yAxes && this.options.scales.yAxes.length) {\n                            // Build the y axes\n                            helpers.each(this.options.scales.yAxes, function (yAxisOptions, index) {\n                                yAxisOptions.id = yAxisOptions.id || (defaultYAxisID + index);\n                            });\n                        }\n                    }\n                },\n                buildScales: function buildScales() {\n                    // Map of scale ID to scale object so we can lookup later\n                    this.scales = {};\n\n                    // Build the x axes\n                    if (this.options.scales) {\n                        if (this.options.scales.xAxes && this.options.scales.xAxes.length) {\n                            helpers.each(this.options.scales.xAxes, function (xAxisOptions, index) {\n                                var xType = helpers.getValueOrDefault(xAxisOptions.type, 'category');\n                                var ScaleClass = Chart.scaleService.getScaleConstructor(xType);\n                                if (ScaleClass) {\n                                    var scale = new ScaleClass({\n                                        ctx: this.chart.ctx,\n                                        options: xAxisOptions,\n                                        chart: this,\n                                        id: xAxisOptions.id\n                                    });\n\n                                    this.scales[scale.id] = scale;\n                                }\n                            }, this);\n                        }\n\n                        if (this.options.scales.yAxes && this.options.scales.yAxes.length) {\n                            // Build the y axes\n                            helpers.each(this.options.scales.yAxes, function (yAxisOptions, index) {\n                                var yType = helpers.getValueOrDefault(yAxisOptions.type, 'linear');\n                                var ScaleClass = Chart.scaleService.getScaleConstructor(yType);\n                                if (ScaleClass) {\n                                    var scale = new ScaleClass({\n                                        ctx: this.chart.ctx,\n                                        options: yAxisOptions,\n                                        chart: this,\n                                        id: yAxisOptions.id\n                                    });\n\n                                    this.scales[scale.id] = scale;\n                                }\n                            }, this);\n                        }\n                    }\n                    if (this.options.scale) {\n                        // Build radial axes\n                        var ScaleClass = Chart.scaleService.getScaleConstructor(this.options.scale.type);\n                        if (ScaleClass) {\n                            var scale = new ScaleClass({\n                                ctx: this.chart.ctx,\n                                options: this.options.scale,\n                                chart: this\n                            });\n\n                            this.scale = scale;\n\n                            this.scales.radialScale = scale;\n                        }\n                    }\n\n                    Chart.scaleService.addScalesToLayout(this);\n                },\n\n                buildSurroundingItems: function () {\n                    if (this.options.title) {\n                        this.titleBlock = new Chart.Title({\n                            ctx: this.chart.ctx,\n                            options: this.options.title,\n                            chart: this\n                        });\n\n                        Chart.layoutService.addBox(this, this.titleBlock);\n                    }\n\n                    if (this.options.legend) {\n                        this.legend = new Chart.Legend({\n                            ctx: this.chart.ctx,\n                            options: this.options.legend,\n                            chart: this\n                        });\n\n                        Chart.layoutService.addBox(this, this.legend);\n                    }\n                },\n\n                updateLayout: function () {\n                    Chart.layoutService.update(this, this.chart.width, this.chart.height);\n                },\n\n                buildOrUpdateControllers: function buildOrUpdateControllers() {\n                    var types = [];\n                    var newControllers = [];\n\n                    helpers.each(this.data.datasets, function (dataset, datasetIndex) {\n                        var meta = this.getDatasetMeta(datasetIndex);\n                        if (!meta.type) {\n                            meta.type = dataset.type || this.config.type;\n                        }\n\n                        types.push(meta.type);\n\n                        if (meta.controller) {\n                            meta.controller.updateIndex(datasetIndex);\n                        } else {\n                            meta.controller = new Chart.controllers[meta.type](this, datasetIndex);\n                            newControllers.push(meta.controller);\n                        }\n                    }, this);\n\n                    if (types.length > 1) {\n                        for (var i = 1; i < types.length; i++) {\n                            if (types[i] !== types[i - 1]) {\n                                this.isCombo = true;\n                                break;\n                            }\n                        }\n                    }\n\n                    return newControllers;\n                },\n\n                resetElements: function resetElements() {\n                    helpers.each(this.data.datasets, function (dataset, datasetIndex) {\n                        this.getDatasetMeta(datasetIndex).controller.reset();\n                    }, this);\n                },\n\n                update: function update(animationDuration, lazy) {\n                    Chart.pluginService.notifyPlugins('beforeUpdate', [this]);\n\n                    // In case the entire data object changed\n                    this.tooltip._data = this.data;\n\n                    // Make sure dataset controllers are updated and new controllers are reset\n                    var newControllers = this.buildOrUpdateControllers();\n\n                    // Make sure all dataset controllers have correct meta data counts\n                    helpers.each(this.data.datasets, function (dataset, datasetIndex) {\n                        this.getDatasetMeta(datasetIndex).controller.buildOrUpdateElements();\n                    }, this);\n\n                    Chart.layoutService.update(this, this.chart.width, this.chart.height);\n\n                    // Can only reset the new controllers after the scales have been updated\n                    helpers.each(newControllers, function (controller) {\n                        controller.reset();\n                    });\n\n                    // This will loop through any data and do the appropriate element update for the type\n                    helpers.each(this.data.datasets, function (dataset, datasetIndex) {\n                        this.getDatasetMeta(datasetIndex).controller.update();\n                    }, this);\n\n                    this.render(animationDuration, lazy);\n\n                    Chart.pluginService.notifyPlugins('afterUpdate', [this]);\n                },\n\n                render: function render(duration, lazy) {\n                    Chart.pluginService.notifyPlugins('beforeRender', [this]);\n\n                    if (this.options.animation && ((typeof duration !== 'undefined' && duration !== 0) || (typeof duration === 'undefined' && this.options.animation.duration !== 0))) {\n                        var animation = new Chart.Animation();\n                        animation.numSteps = (duration || this.options.animation.duration) / 16.66; //60 fps\n                        animation.easing = this.options.animation.easing;\n\n                        // render function\n                        animation.render = function (chartInstance, animationObject) {\n                            var easingFunction = helpers.easingEffects[animationObject.easing];\n                            var stepDecimal = animationObject.currentStep / animationObject.numSteps;\n                            var easeDecimal = easingFunction(stepDecimal);\n\n                            chartInstance.draw(easeDecimal, stepDecimal, animationObject.currentStep);\n                        };\n\n                        // user events\n                        animation.onAnimationProgress = this.options.animation.onProgress;\n                        animation.onAnimationComplete = this.options.animation.onComplete;\n\n                        Chart.animationService.addAnimation(this, animation, duration, lazy);\n                    } else {\n                        this.draw();\n                        if (this.options.animation && this.options.animation.onComplete && this.options.animation.onComplete.call) {\n                            this.options.animation.onComplete.call(this);\n                        }\n                    }\n                    return this;\n                },\n\n                draw: function (ease) {\n                    var easingDecimal = ease || 1;\n                    this.clear();\n\n                    Chart.pluginService.notifyPlugins('beforeDraw', [this, easingDecimal]);\n\n                    // Draw all the scales\n                    helpers.each(this.boxes, function (box) {\n                        box.draw(this.chartArea);\n                    }, this);\n                    if (this.scale) {\n                        this.scale.draw();\n                    }\n\n                    // Clip out the chart area so that anything outside does not draw. This is necessary for zoom and pan to function\n                    this.chart.ctx.save();\n                    this.chart.ctx.beginPath();\n                    this.chart.ctx.rect(this.chartArea.left, this.chartArea.top, this.chartArea.right - this.chartArea.left, this.chartArea.bottom - this.chartArea.top);\n                    this.chart.ctx.clip();\n\n                    // Draw each dataset via its respective controller (reversed to support proper line stacking)\n                    helpers.each(this.data.datasets, function (dataset, datasetIndex) {\n                        if (this.isDatasetVisible(datasetIndex)) {\n                            this.getDatasetMeta(datasetIndex).controller.draw(ease);\n                        }\n                    }, this, true);\n\n                    // Restore from the clipping operation\n                    this.chart.ctx.restore();\n\n                    // Finally draw the tooltip\n                    this.tooltip.transition(easingDecimal).draw();\n\n                    Chart.pluginService.notifyPlugins('afterDraw', [this, easingDecimal]);\n                },\n\n                // Get the single element that was clicked on\n                // @return : An object containing the dataset index and element index of the matching element. Also contains the rectangle that was draw\n                getElementAtEvent: function (e) {\n                    var eventPosition = helpers.getRelativePosition(e, this.chart);\n                    var elementsArray = [];\n\n                    helpers.each(this.data.datasets, function (dataset, datasetIndex) {\n                        if (this.isDatasetVisible(datasetIndex)) {\n                            var meta = this.getDatasetMeta(datasetIndex);\n                            helpers.each(meta.data, function (element, index) {\n                                if (element.inRange(eventPosition.x, eventPosition.y)) {\n                                    elementsArray.push(element);\n                                    return elementsArray;\n                                }\n                            });\n                        }\n                    }, this);\n\n                    return elementsArray;\n                },\n\n                getElementsAtEvent: function (e) {\n                    var eventPosition = helpers.getRelativePosition(e, this.chart);\n                    var elementsArray = [];\n\n                    var found = (function () {\n                        if (this.data.datasets) {\n                            for (var i = 0; i < this.data.datasets.length; i++) {\n                                var meta = this.getDatasetMeta(i);\n                                if (this.isDatasetVisible(i)) {\n                                    for (var j = 0; j < meta.data.length; j++) {\n                                        if (meta.data[j].inRange(eventPosition.x, eventPosition.y)) {\n                                            return meta.data[j];\n                                        }\n                                    }\n                                }\n                            }\n                        }\n                    }).call(this);\n\n                    if (!found) {\n                        return elementsArray;\n                    }\n\n                    helpers.each(this.data.datasets, function (dataset, datasetIndex) {\n                        if (this.isDatasetVisible(datasetIndex)) {\n                            var meta = this.getDatasetMeta(datasetIndex);\n                            elementsArray.push(meta.data[found._index]);\n                        }\n                    }, this);\n\n                    return elementsArray;\n                },\n\n                getDatasetAtEvent: function (e) {\n                    var elementsArray = this.getElementAtEvent(e);\n\n                    if (elementsArray.length > 0) {\n                        elementsArray = this.getDatasetMeta(elementsArray[0]._datasetIndex).data;\n                    }\n\n                    return elementsArray;\n                },\n\n                getDatasetMeta: function (datasetIndex) {\n                    var dataset = this.data.datasets[datasetIndex];\n                    if (!dataset._meta) {\n                        dataset._meta = {};\n                    }\n\n                    var meta = dataset._meta[this.id];\n                    if (!meta) {\n                        meta = dataset._meta[this.id] = {\n                            type: null,\n                            data: [],\n                            dataset: null,\n                            controller: null,\n                            hidden: null,\t\t\t// See isDatasetVisible() comment\n                            xAxisID: null,\n                            yAxisID: null\n                        };\n                    }\n\n                    return meta;\n                },\n\n                getVisibleDatasetCount: function () {\n                    var count = 0;\n                    for (var i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {\n                        if (this.isDatasetVisible(i)) {\n                            count++;\n                        }\n                    }\n                    return count;\n                },\n\n                isDatasetVisible: function (datasetIndex) {\n                    var meta = this.getDatasetMeta(datasetIndex);\n\n                    // meta.hidden is a per chart dataset hidden flag override with 3 states: if true or false,\n                    // the dataset.hidden value is ignored, else if null, the dataset hidden state is returned.\n                    return typeof meta.hidden === 'boolean' ? !meta.hidden : !this.data.datasets[datasetIndex].hidden;\n                },\n\n                generateLegend: function generateLegend() {\n                    return this.options.legendCallback(this);\n                },\n\n                destroy: function destroy() {\n                    this.clear();\n                    helpers.unbindEvents(this, this.events);\n                    helpers.removeResizeListener(this.chart.canvas.parentNode);\n\n                    // Reset canvas height/width attributes\n                    var canvas = this.chart.canvas;\n                    canvas.width = this.chart.width;\n                    canvas.height = this.chart.height;\n\n                    // if we scaled the canvas in response to a devicePixelRatio !== 1, we need to undo that transform here\n                    if (this.chart.originalDevicePixelRatio !== undefined) {\n                        this.chart.ctx.scale(1 / this.chart.originalDevicePixelRatio, 1 / this.chart.originalDevicePixelRatio);\n                    }\n\n                    // Reset to the old style since it may have been changed by the device pixel ratio changes\n                    canvas.style.width = this.chart.originalCanvasStyleWidth;\n                    canvas.style.height = this.chart.originalCanvasStyleHeight;\n\n                    Chart.pluginService.notifyPlugins('destroy', [this]);\n\n                    delete Chart.instances[this.id];\n                },\n\n                toBase64Image: function toBase64Image() {\n                    return this.chart.canvas.toDataURL.apply(this.chart.canvas, arguments);\n                },\n\n                initToolTip: function initToolTip() {\n                    this.tooltip = new Chart.Tooltip({\n                        _chart: this.chart,\n                        _chartInstance: this,\n                        _data: this.data,\n                        _options: this.options\n                    }, this);\n                },\n\n                bindEvents: function bindEvents() {\n                    helpers.bindEvents(this, this.options.events, function (evt) {\n                        this.eventHandler(evt);\n                    });\n                },\n                eventHandler: function eventHandler(e) {\n                    this.lastActive = this.lastActive || [];\n                    this.lastTooltipActive = this.lastTooltipActive || [];\n\n                    // Find Active Elements for hover and tooltips\n                    if (e.type === 'mouseout') {\n                        this.active = [];\n                        this.tooltipActive = [];\n                    } else {\n\n                        var _this = this;\n                        var getItemsForMode = function (mode) {\n                            switch (mode) {\n                                case 'single':\n                                    return _this.getElementAtEvent(e);\n                                case 'label':\n                                    return _this.getElementsAtEvent(e);\n                                case 'dataset':\n                                    return _this.getDatasetAtEvent(e);\n                                default:\n                                    return e;\n                            }\n                        };\n\n                        this.active = getItemsForMode(this.options.hover.mode);\n                        this.tooltipActive = getItemsForMode(this.options.tooltips.mode);\n                    }\n\n                    // On Hover hook\n                    if (this.options.hover.onHover) {\n                        this.options.hover.onHover.call(this, this.active);\n                    }\n\n                    if (e.type === 'mouseup' || e.type === 'click') {\n                        if (this.options.onClick) {\n                            this.options.onClick.call(this, e, this.active);\n                        }\n\n                        if (this.legend && this.legend.handleEvent) {\n                            this.legend.handleEvent(e);\n                        }\n                    }\n\n                    // Remove styling for last active (even if it may still be active)\n                    if (this.lastActive.length) {\n                        switch (this.options.hover.mode) {\n                            case 'single':\n                                this.getDatasetMeta(this.lastActive[0]._datasetIndex).controller.removeHoverStyle(this.lastActive[0], this.lastActive[0]._datasetIndex, this.lastActive[0]._index);\n                                break;\n                            case 'label':\n                            case 'dataset':\n                                for (var i = 0; i < this.lastActive.length; i++) {\n                                    if (this.lastActive[i])\n                                        this.getDatasetMeta(this.lastActive[i]._datasetIndex).controller.removeHoverStyle(this.lastActive[i], this.lastActive[i]._datasetIndex, this.lastActive[i]._index);\n                                }\n                                break;\n                            default:\n                            // Don't change anything\n                        }\n                    }\n\n                    // Built in hover styling\n                    if (this.active.length && this.options.hover.mode) {\n                        switch (this.options.hover.mode) {\n                            case 'single':\n                                this.getDatasetMeta(this.active[0]._datasetIndex).controller.setHoverStyle(this.active[0]);\n                                break;\n                            case 'label':\n                            case 'dataset':\n                                for (var j = 0; j < this.active.length; j++) {\n                                    if (this.active[j])\n                                        this.getDatasetMeta(this.active[j]._datasetIndex).controller.setHoverStyle(this.active[j]);\n                                }\n                                break;\n                            default:\n                            // Don't change anything\n                        }\n                    }\n\n\n                    // Built in Tooltips\n                    if (this.options.tooltips.enabled || this.options.tooltips.custom) {\n\n                        // The usual updates\n                        this.tooltip.initialize();\n                        this.tooltip._active = this.tooltipActive;\n                        this.tooltip.update(true);\n                    }\n\n                    // Hover animations\n                    this.tooltip.pivot();\n\n                    if (!this.animating) {\n                        var changed;\n\n                        helpers.each(this.active, function (element, index) {\n                            if (element !== this.lastActive[index]) {\n                                changed = true;\n                            }\n                        }, this);\n\n                        helpers.each(this.tooltipActive, function (element, index) {\n                            if (element !== this.lastTooltipActive[index]) {\n                                changed = true;\n                            }\n                        }, this);\n\n                        // If entering, leaving, or changing elements, animate the change via pivot\n                        if ((this.lastActive.length !== this.active.length) ||\n                            (this.lastTooltipActive.length !== this.tooltipActive.length) ||\n                            changed) {\n\n                            this.stop();\n\n                            if (this.options.tooltips.enabled || this.options.tooltips.custom) {\n                                this.tooltip.update(true);\n                            }\n\n                            // We only need to render at this point. Updating will cause scales to be recomputed generating flicker & using more\n                            // memory than necessary.\n                            this.render(this.options.hover.animationDuration, true);\n                        }\n                    }\n\n                    // Remember Last Actives\n                    this.lastActive = this.active;\n                    this.lastTooltipActive = this.tooltipActive;\n                    return this;\n                }\n            });\n        };\n\n    }, {}], 23: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n            var noop = helpers.noop;\n\n            // Base class for all dataset controllers (line, bar, etc)\n            Chart.DatasetController = function (chart, datasetIndex) {\n                this.initialize.call(this, chart, datasetIndex);\n            };\n\n            helpers.extend(Chart.DatasetController.prototype, {\n                initialize: function (chart, datasetIndex) {\n                    this.chart = chart;\n                    this.index = datasetIndex;\n                    this.linkScales();\n                    this.addElements();\n                },\n                updateIndex: function (datasetIndex) {\n                    this.index = datasetIndex;\n                },\n\n                linkScales: function () {\n                    var meta = this.getMeta();\n                    var dataset = this.getDataset();\n\n                    if (meta.xAxisID === null) {\n                        meta.xAxisID = dataset.xAxisID || this.chart.options.scales.xAxes[0].id;\n                    }\n                    if (meta.yAxisID === null) {\n                        meta.yAxisID = dataset.yAxisID || this.chart.options.scales.yAxes[0].id;\n                    }\n                },\n\n                getDataset: function () {\n                    return this.chart.data.datasets[this.index];\n                },\n\n                getMeta: function () {\n                    return this.chart.getDatasetMeta(this.index);\n                },\n\n                getScaleForId: function (scaleID) {\n                    return this.chart.scales[scaleID];\n                },\n\n                reset: function () {\n                    this.update(true);\n                },\n\n                buildOrUpdateElements: function buildOrUpdateElements() {\n                    // Handle the number of data points changing\n                    var meta = this.getMeta(),\n                        md = meta.data,\n                        numData = this.getDataset().data.length,\n                        numMetaData = md.length;\n\n                    // Make sure that we handle number of datapoints changing\n                    if (numData < numMetaData) {\n                        // Remove excess bars for data points that have been removed\n                        md.splice(numData, numMetaData - numData);\n                    } else if (numData > numMetaData) {\n                        // Add new elements\n                        for (var index = numMetaData; index < numData; ++index) {\n                            this.addElementAndReset(index);\n                        }\n                    }\n                },\n\n                // Controllers should implement the following\n                addElements: noop,\n                addElementAndReset: noop,\n                draw: noop,\n                removeHoverStyle: noop,\n                setHoverStyle: noop,\n                update: noop\n            });\n\n            Chart.DatasetController.extend = helpers.inherits;\n        };\n    }, {}], 24: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.elements = {};\n\n            Chart.Element = function (configuration) {\n                helpers.extend(this, configuration);\n                this.initialize.apply(this, arguments);\n            };\n            helpers.extend(Chart.Element.prototype, {\n                initialize: function () {\n                    this.hidden = false;\n                },\n                pivot: function () {\n                    if (!this._view) {\n                        this._view = helpers.clone(this._model);\n                    }\n                    this._start = helpers.clone(this._view);\n                    return this;\n                },\n                transition: function (ease) {\n                    if (!this._view) {\n                        this._view = helpers.clone(this._model);\n                    }\n\n                    // No animation -> No Transition\n                    if (ease === 1) {\n                        this._view = this._model;\n                        this._start = null;\n                        return this;\n                    }\n\n                    if (!this._start) {\n                        this.pivot();\n                    }\n\n                    helpers.each(this._model, function (value, key) {\n\n                        if (key[0] === '_' || !this._model.hasOwnProperty(key)) {\n                            // Only non-underscored properties\n                        }\n\n                        // Init if doesn't exist\n                        else if (!this._view.hasOwnProperty(key)) {\n                            if (typeof value === 'number' && !isNaN(this._view[key])) {\n                                this._view[key] = value * ease;\n                            } else {\n                                this._view[key] = value;\n                            }\n                        }\n\n                        // No unnecessary computations\n                        else if (value === this._view[key]) {\n                            // It's the same! Woohoo!\n                        }\n\n                        // Color transitions if possible\n                        else if (typeof value === 'string') {\n                            try {\n                                var color = helpers.color(this._start[key]).mix(helpers.color(this._model[key]), ease);\n                                this._view[key] = color.rgbString();\n                            } catch (err) {\n                                this._view[key] = value;\n                            }\n                        }\n                        // Number transitions\n                        else if (typeof value === 'number') {\n                            var startVal = this._start[key] !== undefined && isNaN(this._start[key]) === false ? this._start[key] : 0;\n                            this._view[key] = ((this._model[key] - startVal) * ease) + startVal;\n                        }\n                        // Everything else\n                        else {\n                            this._view[key] = value;\n                        }\n                    }, this);\n\n                    return this;\n                },\n                tooltipPosition: function () {\n                    return {\n                        x: this._model.x,\n                        y: this._model.y\n                    };\n                },\n                hasValue: function () {\n                    return helpers.isNumber(this._model.x) && helpers.isNumber(this._model.y);\n                }\n            });\n\n            Chart.Element.extend = helpers.inherits;\n\n        };\n\n    }, {}], 25: [function (require, module, exports) {\n        /*global window: false */\n        /*global document: false */\n        \"use strict\";\n\n        var color = require('chartjs-color');\n\n        module.exports = function (Chart) {\n\n            //Global Chart helpers object for utility methods and classes\n            var helpers = Chart.helpers = {};\n\n            //-- Basic js utility methods\n            helpers.each = function (loopable, callback, self, reverse) {\n                // Check to see if null or undefined firstly.\n                var i, len;\n                if (helpers.isArray(loopable)) {\n                    len = loopable.length;\n                    if (reverse) {\n                        for (i = len - 1; i >= 0; i--) {\n                            callback.call(self, loopable[i], i);\n                        }\n                    } else {\n                        for (i = 0; i < len; i++) {\n                            callback.call(self, loopable[i], i);\n                        }\n                    }\n                } else if (typeof loopable === 'object') {\n                    var keys = Object.keys(loopable);\n                    len = keys.length;\n                    for (i = 0; i < len; i++) {\n                        callback.call(self, loopable[keys[i]], keys[i]);\n                    }\n                }\n            };\n            helpers.clone = function (obj) {\n                var objClone = {};\n                helpers.each(obj, function (value, key) {\n                    if (obj.hasOwnProperty(key)) {\n                        if (helpers.isArray(value)) {\n                            objClone[key] = value.slice(0);\n                        } else if (typeof value === 'object' && value !== null) {\n                            objClone[key] = helpers.clone(value);\n                        } else {\n                            objClone[key] = value;\n                        }\n                    }\n                });\n                return objClone;\n            };\n            helpers.extend = function (base) {\n                var len = arguments.length;\n                var additionalArgs = [];\n                for (var i = 1; i < len; i++) {\n                    additionalArgs.push(arguments[i]);\n                }\n                helpers.each(additionalArgs, function (extensionObject) {\n                    helpers.each(extensionObject, function (value, key) {\n                        if (extensionObject.hasOwnProperty(key)) {\n                            base[key] = value;\n                        }\n                    });\n                });\n                return base;\n            };\n            // Need a special merge function to chart configs since they are now grouped\n            helpers.configMerge = function (_base) {\n                var base = helpers.clone(_base);\n                helpers.each(Array.prototype.slice.call(arguments, 1), function (extension) {\n                    helpers.each(extension, function (value, key) {\n                        if (extension.hasOwnProperty(key)) {\n                            if (key === 'scales') {\n                                // Scale config merging is complex. Add out own function here for that\n                                base[key] = helpers.scaleMerge(base.hasOwnProperty(key) ? base[key] : {}, value);\n\n                            } else if (key === 'scale') {\n                                // Used in polar area & radar charts since there is only one scale\n                                base[key] = helpers.configMerge(base.hasOwnProperty(key) ? base[key] : {}, Chart.scaleService.getScaleDefaults(value.type), value);\n                            } else if (base.hasOwnProperty(key) && helpers.isArray(base[key]) && helpers.isArray(value)) {\n                                // In this case we have an array of objects replacing another array. Rather than doing a strict replace,\n                                // merge. This allows easy scale option merging\n                                var baseArray = base[key];\n\n                                helpers.each(value, function (valueObj, index) {\n\n                                    if (index < baseArray.length) {\n                                        if (typeof baseArray[index] === 'object' && baseArray[index] !== null && typeof valueObj === 'object' && valueObj !== null) {\n                                            // Two objects are coming together. Do a merge of them.\n                                            baseArray[index] = helpers.configMerge(baseArray[index], valueObj);\n                                        } else {\n                                            // Just overwrite in this case since there is nothing to merge\n                                            baseArray[index] = valueObj;\n                                        }\n                                    } else {\n                                        baseArray.push(valueObj); // nothing to merge\n                                    }\n                                });\n\n                            } else if (base.hasOwnProperty(key) && typeof base[key] === \"object\" && base[key] !== null && typeof value === \"object\") {\n                                // If we are overwriting an object with an object, do a merge of the properties.\n                                base[key] = helpers.configMerge(base[key], value);\n\n                            } else {\n                                // can just overwrite the value in this case\n                                base[key] = value;\n                            }\n                        }\n                    });\n                });\n\n                return base;\n            };\n            helpers.extendDeep = function (_base) {\n                return _extendDeep.apply(this, arguments);\n\n                function _extendDeep(dst) {\n                    helpers.each(arguments, function (obj) {\n                        if (obj !== dst) {\n                            helpers.each(obj, function (value, key) {\n                                if (dst[key] && dst[key].constructor && dst[key].constructor === Object) {\n                                    _extendDeep(dst[key], value);\n                                } else {\n                                    dst[key] = value;\n                                }\n                            });\n                        }\n                    });\n                    return dst;\n                }\n            };\n            helpers.scaleMerge = function (_base, extension) {\n                var base = helpers.clone(_base);\n\n                helpers.each(extension, function (value, key) {\n                    if (extension.hasOwnProperty(key)) {\n                        if (key === 'xAxes' || key === 'yAxes') {\n                            // These properties are arrays of items\n                            if (base.hasOwnProperty(key)) {\n                                helpers.each(value, function (valueObj, index) {\n                                    var axisType = helpers.getValueOrDefault(valueObj.type, key === 'xAxes' ? 'category' : 'linear');\n                                    var axisDefaults = Chart.scaleService.getScaleDefaults(axisType);\n                                    if (index >= base[key].length || !base[key][index].type) {\n                                        base[key].push(helpers.configMerge(axisDefaults, valueObj));\n                                    } else if (valueObj.type && valueObj.type !== base[key][index].type) {\n                                        // Type changed. Bring in the new defaults before we bring in valueObj so that valueObj can override the correct scale defaults\n                                        base[key][index] = helpers.configMerge(base[key][index], axisDefaults, valueObj);\n                                    } else {\n                                        // Type is the same\n                                        base[key][index] = helpers.configMerge(base[key][index], valueObj);\n                                    }\n                                });\n                            } else {\n                                base[key] = [];\n                                helpers.each(value, function (valueObj) {\n                                    var axisType = helpers.getValueOrDefault(valueObj.type, key === 'xAxes' ? 'category' : 'linear');\n                                    base[key].push(helpers.configMerge(Chart.scaleService.getScaleDefaults(axisType), valueObj));\n                                });\n                            }\n                        } else if (base.hasOwnProperty(key) && typeof base[key] === \"object\" && base[key] !== null && typeof value === \"object\") {\n                            // If we are overwriting an object with an object, do a merge of the properties.\n                            base[key] = helpers.configMerge(base[key], value);\n\n                        } else {\n                            // can just overwrite the value in this case\n                            base[key] = value;\n                        }\n                    }\n                });\n\n                return base;\n            };\n            helpers.getValueAtIndexOrDefault = function (value, index, defaultValue) {\n                if (value === undefined || value === null) {\n                    return defaultValue;\n                }\n\n                if (helpers.isArray(value)) {\n                    return index < value.length ? value[index] : defaultValue;\n                }\n\n                return value;\n            };\n            helpers.getValueOrDefault = function (value, defaultValue) {\n                return value === undefined ? defaultValue : value;\n            };\n            helpers.indexOf = function (arrayToSearch, item) {\n                if (Array.prototype.indexOf) {\n                    return arrayToSearch.indexOf(item);\n                } else {\n                    for (var i = 0; i < arrayToSearch.length; i++) {\n                        if (arrayToSearch[i] === item)\n                            return i;\n                    }\n                    return -1;\n                }\n            };\n            helpers.where = function (collection, filterCallback) {\n                var filtered = [];\n\n                helpers.each(collection, function (item) {\n                    if (filterCallback(item)) {\n                        filtered.push(item);\n                    }\n                });\n\n                return filtered;\n            };\n            helpers.findIndex = function (arrayToSearch, callback, thisArg) {\n                var index = -1;\n                if (Array.prototype.findIndex) {\n                    index = arrayToSearch.findIndex(callback, thisArg);\n                } else {\n                    for (var i = 0; i < arrayToSearch.length; ++i) {\n                        thisArg = thisArg !== undefined ? thisArg : arrayToSearch;\n\n                        if (callback.call(thisArg, arrayToSearch[i], i, arrayToSearch)) {\n                            index = i;\n                            break;\n                        }\n                    }\n                }\n\n                return index;\n            };\n            helpers.findNextWhere = function (arrayToSearch, filterCallback, startIndex) {\n                // Default to start of the array\n                if (startIndex === undefined || startIndex === null) {\n                    startIndex = -1;\n                }\n                for (var i = startIndex + 1; i < arrayToSearch.length; i++) {\n                    var currentItem = arrayToSearch[i];\n                    if (filterCallback(currentItem)) {\n                        return currentItem;\n                    }\n                }\n            };\n            helpers.findPreviousWhere = function (arrayToSearch, filterCallback, startIndex) {\n                // Default to end of the array\n                if (startIndex === undefined || startIndex === null) {\n                    startIndex = arrayToSearch.length;\n                }\n                for (var i = startIndex - 1; i >= 0; i--) {\n                    var currentItem = arrayToSearch[i];\n                    if (filterCallback(currentItem)) {\n                        return currentItem;\n                    }\n                }\n            };\n            helpers.inherits = function (extensions) {\n                //Basic javascript inheritance based on the model created in Backbone.js\n                var parent = this;\n                var ChartElement = (extensions && extensions.hasOwnProperty(\"constructor\")) ? extensions.constructor : function () {\n                    return parent.apply(this, arguments);\n                };\n\n                var Surrogate = function () {\n                    this.constructor = ChartElement;\n                };\n                Surrogate.prototype = parent.prototype;\n                ChartElement.prototype = new Surrogate();\n\n                ChartElement.extend = helpers.inherits;\n\n                if (extensions) {\n                    helpers.extend(ChartElement.prototype, extensions);\n                }\n\n                ChartElement.__super__ = parent.prototype;\n\n                return ChartElement;\n            };\n            helpers.noop = function () { };\n            helpers.uid = (function () {\n                var id = 0;\n                return function () {\n                    return id++;\n                };\n            })();\n            helpers.warn = function (str) {\n                //Method for warning of errors\n                if (console && typeof console.warn === \"function\") {\n                    console.warn(str);\n                }\n            };\n            //-- Math methods\n            helpers.isNumber = function (n) {\n                return !isNaN(parseFloat(n)) && isFinite(n);\n            };\n            helpers.almostEquals = function (x, y, epsilon) {\n                return Math.abs(x - y) < epsilon;\n            };\n            helpers.max = function (array) {\n                return array.reduce(function (max, value) {\n                    if (!isNaN(value)) {\n                        return Math.max(max, value);\n                    } else {\n                        return max;\n                    }\n                }, Number.NEGATIVE_INFINITY);\n            };\n            helpers.min = function (array) {\n                return array.reduce(function (min, value) {\n                    if (!isNaN(value)) {\n                        return Math.min(min, value);\n                    } else {\n                        return min;\n                    }\n                }, Number.POSITIVE_INFINITY);\n            };\n            helpers.sign = function (x) {\n                if (Math.sign) {\n                    return Math.sign(x);\n                } else {\n                    x = +x; // convert to a number\n                    if (x === 0 || isNaN(x)) {\n                        return x;\n                    }\n                    return x > 0 ? 1 : -1;\n                }\n            };\n            helpers.log10 = function (x) {\n                if (Math.log10) {\n                    return Math.log10(x);\n                } else {\n                    return Math.log(x) / Math.LN10;\n                }\n            };\n            helpers.toRadians = function (degrees) {\n                return degrees * (Math.PI / 180);\n            };\n            helpers.toDegrees = function (radians) {\n                return radians * (180 / Math.PI);\n            };\n            // Gets the angle from vertical upright to the point about a centre.\n            helpers.getAngleFromPoint = function (centrePoint, anglePoint) {\n                var distanceFromXCenter = anglePoint.x - centrePoint.x,\n                    distanceFromYCenter = anglePoint.y - centrePoint.y,\n                    radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);\n\n                var angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);\n\n                if (angle < (-0.5 * Math.PI)) {\n                    angle += 2.0 * Math.PI; // make sure the returned angle is in the range of (-PI/2, 3PI/2]\n                }\n\n                return {\n                    angle: angle,\n                    distance: radialDistanceFromCenter\n                };\n            };\n            helpers.aliasPixel = function (pixelWidth) {\n                return (pixelWidth % 2 === 0) ? 0 : 0.5;\n            };\n            helpers.splineCurve = function (firstPoint, middlePoint, afterPoint, t) {\n                //Props to Rob Spencer at scaled innovation for his post on splining between points\n                //http://scaledinnovation.com/analytics/splines/aboutSplines.html\n\n                // This function must also respect \"skipped\" points\n\n                var previous = firstPoint.skip ? middlePoint : firstPoint,\n                    current = middlePoint,\n                    next = afterPoint.skip ? middlePoint : afterPoint;\n\n                var d01 = Math.sqrt(Math.pow(current.x - previous.x, 2) + Math.pow(current.y - previous.y, 2));\n                var d12 = Math.sqrt(Math.pow(next.x - current.x, 2) + Math.pow(next.y - current.y, 2));\n\n                var s01 = d01 / (d01 + d12);\n                var s12 = d12 / (d01 + d12);\n\n                // If all points are the same, s01 & s02 will be inf\n                s01 = isNaN(s01) ? 0 : s01;\n                s12 = isNaN(s12) ? 0 : s12;\n\n                var fa = t * s01; // scaling factor for triangle Ta\n                var fb = t * s12;\n\n                return {\n                    previous: {\n                        x: current.x - fa * (next.x - previous.x),\n                        y: current.y - fa * (next.y - previous.y)\n                    },\n                    next: {\n                        x: current.x + fb * (next.x - previous.x),\n                        y: current.y + fb * (next.y - previous.y)\n                    }\n                };\n            };\n            helpers.nextItem = function (collection, index, loop) {\n                if (loop) {\n                    return index >= collection.length - 1 ? collection[0] : collection[index + 1];\n                }\n\n                return index >= collection.length - 1 ? collection[collection.length - 1] : collection[index + 1];\n            };\n            helpers.previousItem = function (collection, index, loop) {\n                if (loop) {\n                    return index <= 0 ? collection[collection.length - 1] : collection[index - 1];\n                }\n                return index <= 0 ? collection[0] : collection[index - 1];\n            };\n            // Implementation of the nice number algorithm used in determining where axis labels will go\n            helpers.niceNum = function (range, round) {\n                var exponent = Math.floor(helpers.log10(range));\n                var fraction = range / Math.pow(10, exponent);\n                var niceFraction;\n\n                if (round) {\n                    if (fraction < 1.5) {\n                        niceFraction = 1;\n                    } else if (fraction < 3) {\n                        niceFraction = 2;\n                    } else if (fraction < 7) {\n                        niceFraction = 5;\n                    } else {\n                        niceFraction = 10;\n                    }\n                } else {\n                    if (fraction <= 1.0) {\n                        niceFraction = 1;\n                    } else if (fraction <= 2) {\n                        niceFraction = 2;\n                    } else if (fraction <= 5) {\n                        niceFraction = 5;\n                    } else {\n                        niceFraction = 10;\n                    }\n                }\n\n                return niceFraction * Math.pow(10, exponent);\n            };\n            //Easing functions adapted from Robert Penner's easing equations\n            //http://www.robertpenner.com/easing/\n            var easingEffects = helpers.easingEffects = {\n                linear: function (t) {\n                    return t;\n                },\n                easeInQuad: function (t) {\n                    return t * t;\n                },\n                easeOutQuad: function (t) {\n                    return -1 * t * (t - 2);\n                },\n                easeInOutQuad: function (t) {\n                    if ((t /= 1 / 2) < 1) {\n                        return 1 / 2 * t * t;\n                    }\n                    return -1 / 2 * ((--t) * (t - 2) - 1);\n                },\n                easeInCubic: function (t) {\n                    return t * t * t;\n                },\n                easeOutCubic: function (t) {\n                    return 1 * ((t = t / 1 - 1) * t * t + 1);\n                },\n                easeInOutCubic: function (t) {\n                    if ((t /= 1 / 2) < 1) {\n                        return 1 / 2 * t * t * t;\n                    }\n                    return 1 / 2 * ((t -= 2) * t * t + 2);\n                },\n                easeInQuart: function (t) {\n                    return t * t * t * t;\n                },\n                easeOutQuart: function (t) {\n                    return -1 * ((t = t / 1 - 1) * t * t * t - 1);\n                },\n                easeInOutQuart: function (t) {\n                    if ((t /= 1 / 2) < 1) {\n                        return 1 / 2 * t * t * t * t;\n                    }\n                    return -1 / 2 * ((t -= 2) * t * t * t - 2);\n                },\n                easeInQuint: function (t) {\n                    return 1 * (t /= 1) * t * t * t * t;\n                },\n                easeOutQuint: function (t) {\n                    return 1 * ((t = t / 1 - 1) * t * t * t * t + 1);\n                },\n                easeInOutQuint: function (t) {\n                    if ((t /= 1 / 2) < 1) {\n                        return 1 / 2 * t * t * t * t * t;\n                    }\n                    return 1 / 2 * ((t -= 2) * t * t * t * t + 2);\n                },\n                easeInSine: function (t) {\n                    return -1 * Math.cos(t / 1 * (Math.PI / 2)) + 1;\n                },\n                easeOutSine: function (t) {\n                    return 1 * Math.sin(t / 1 * (Math.PI / 2));\n                },\n                easeInOutSine: function (t) {\n                    return -1 / 2 * (Math.cos(Math.PI * t / 1) - 1);\n                },\n                easeInExpo: function (t) {\n                    return (t === 0) ? 1 : 1 * Math.pow(2, 10 * (t / 1 - 1));\n                },\n                easeOutExpo: function (t) {\n                    return (t === 1) ? 1 : 1 * (-Math.pow(2, -10 * t / 1) + 1);\n                },\n                easeInOutExpo: function (t) {\n                    if (t === 0) {\n                        return 0;\n                    }\n                    if (t === 1) {\n                        return 1;\n                    }\n                    if ((t /= 1 / 2) < 1) {\n                        return 1 / 2 * Math.pow(2, 10 * (t - 1));\n                    }\n                    return 1 / 2 * (-Math.pow(2, -10 * --t) + 2);\n                },\n                easeInCirc: function (t) {\n                    if (t >= 1) {\n                        return t;\n                    }\n                    return -1 * (Math.sqrt(1 - (t /= 1) * t) - 1);\n                },\n                easeOutCirc: function (t) {\n                    return 1 * Math.sqrt(1 - (t = t / 1 - 1) * t);\n                },\n                easeInOutCirc: function (t) {\n                    if ((t /= 1 / 2) < 1) {\n                        return -1 / 2 * (Math.sqrt(1 - t * t) - 1);\n                    }\n                    return 1 / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1);\n                },\n                easeInElastic: function (t) {\n                    var s = 1.70158;\n                    var p = 0;\n                    var a = 1;\n                    if (t === 0) {\n                        return 0;\n                    }\n                    if ((t /= 1) === 1) {\n                        return 1;\n                    }\n                    if (!p) {\n                        p = 1 * 0.3;\n                    }\n                    if (a < Math.abs(1)) {\n                        a = 1;\n                        s = p / 4;\n                    } else {\n                        s = p / (2 * Math.PI) * Math.asin(1 / a);\n                    }\n                    return -(a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t * 1 - s) * (2 * Math.PI) / p));\n                },\n                easeOutElastic: function (t) {\n                    var s = 1.70158;\n                    var p = 0;\n                    var a = 1;\n                    if (t === 0) {\n                        return 0;\n                    }\n                    if ((t /= 1) === 1) {\n                        return 1;\n                    }\n                    if (!p) {\n                        p = 1 * 0.3;\n                    }\n                    if (a < Math.abs(1)) {\n                        a = 1;\n                        s = p / 4;\n                    } else {\n                        s = p / (2 * Math.PI) * Math.asin(1 / a);\n                    }\n                    return a * Math.pow(2, -10 * t) * Math.sin((t * 1 - s) * (2 * Math.PI) / p) + 1;\n                },\n                easeInOutElastic: function (t) {\n                    var s = 1.70158;\n                    var p = 0;\n                    var a = 1;\n                    if (t === 0) {\n                        return 0;\n                    }\n                    if ((t /= 1 / 2) === 2) {\n                        return 1;\n                    }\n                    if (!p) {\n                        p = 1 * (0.3 * 1.5);\n                    }\n                    if (a < Math.abs(1)) {\n                        a = 1;\n                        s = p / 4;\n                    } else {\n                        s = p / (2 * Math.PI) * Math.asin(1 / a);\n                    }\n                    if (t < 1) {\n                        return -0.5 * (a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t * 1 - s) * (2 * Math.PI) / p));\n                    }\n                    return a * Math.pow(2, -10 * (t -= 1)) * Math.sin((t * 1 - s) * (2 * Math.PI) / p) * 0.5 + 1;\n                },\n                easeInBack: function (t) {\n                    var s = 1.70158;\n                    return 1 * (t /= 1) * t * ((s + 1) * t - s);\n                },\n                easeOutBack: function (t) {\n                    var s = 1.70158;\n                    return 1 * ((t = t / 1 - 1) * t * ((s + 1) * t + s) + 1);\n                },\n                easeInOutBack: function (t) {\n                    var s = 1.70158;\n                    if ((t /= 1 / 2) < 1) {\n                        return 1 / 2 * (t * t * (((s *= (1.525)) + 1) * t - s));\n                    }\n                    return 1 / 2 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2);\n                },\n                easeInBounce: function (t) {\n                    return 1 - easingEffects.easeOutBounce(1 - t);\n                },\n                easeOutBounce: function (t) {\n                    if ((t /= 1) < (1 / 2.75)) {\n                        return 1 * (7.5625 * t * t);\n                    } else if (t < (2 / 2.75)) {\n                        return 1 * (7.5625 * (t -= (1.5 / 2.75)) * t + 0.75);\n                    } else if (t < (2.5 / 2.75)) {\n                        return 1 * (7.5625 * (t -= (2.25 / 2.75)) * t + 0.9375);\n                    } else {\n                        return 1 * (7.5625 * (t -= (2.625 / 2.75)) * t + 0.984375);\n                    }\n                },\n                easeInOutBounce: function (t) {\n                    if (t < 1 / 2) {\n                        return easingEffects.easeInBounce(t * 2) * 0.5;\n                    }\n                    return easingEffects.easeOutBounce(t * 2 - 1) * 0.5 + 1 * 0.5;\n                }\n            };\n            //Request animation polyfill - http://www.paulirish.com/2011/requestanimationframe-for-smart-animating/\n            helpers.requestAnimFrame = (function () {\n                return window.requestAnimationFrame ||\n                    window.webkitRequestAnimationFrame ||\n                    window.mozRequestAnimationFrame ||\n                    window.oRequestAnimationFrame ||\n                    window.msRequestAnimationFrame ||\n                    function (callback) {\n                        return window.setTimeout(callback, 1000 / 60);\n                    };\n            })();\n            helpers.cancelAnimFrame = (function () {\n                return window.cancelAnimationFrame ||\n                    window.webkitCancelAnimationFrame ||\n                    window.mozCancelAnimationFrame ||\n                    window.oCancelAnimationFrame ||\n                    window.msCancelAnimationFrame ||\n                    function (callback) {\n                        return window.clearTimeout(callback, 1000 / 60);\n                    };\n            })();\n            //-- DOM methods\n            helpers.getRelativePosition = function (evt, chart) {\n                var mouseX, mouseY;\n                var e = evt.originalEvent || evt,\n                    canvas = evt.currentTarget || evt.srcElement,\n                    boundingRect = canvas.getBoundingClientRect();\n\n                if (e.touches && e.touches.length > 0) {\n                    mouseX = e.touches[0].clientX;\n                    mouseY = e.touches[0].clientY;\n\n                } else {\n                    mouseX = e.clientX;\n                    mouseY = e.clientY;\n                }\n\n                // Scale mouse coordinates into canvas coordinates\n                // by following the pattern laid out by 'jerryj' in the comments of\n                // http://www.html5canvastutorials.com/advanced/html5-canvas-mouse-coordinates/\n                var paddingLeft = parseFloat(helpers.getStyle(canvas, 'padding-left'));\n                var paddingTop = parseFloat(helpers.getStyle(canvas, 'padding-top'));\n                var paddingRight = parseFloat(helpers.getStyle(canvas, 'padding-right'));\n                var paddingBottom = parseFloat(helpers.getStyle(canvas, 'padding-bottom'));\n                var width = boundingRect.right - boundingRect.left - paddingLeft - paddingRight;\n                var height = boundingRect.bottom - boundingRect.top - paddingTop - paddingBottom;\n\n                // We divide by the current device pixel ratio, because the canvas is scaled up by that amount in each direction. However\n                // the backend model is in unscaled coordinates. Since we are going to deal with our model coordinates, we go back here\n                mouseX = Math.round((mouseX - boundingRect.left - paddingLeft) / (width) * canvas.width / chart.currentDevicePixelRatio);\n                mouseY = Math.round((mouseY - boundingRect.top - paddingTop) / (height) * canvas.height / chart.currentDevicePixelRatio);\n\n                return {\n                    x: mouseX,\n                    y: mouseY\n                };\n\n            };\n            helpers.addEvent = function (node, eventType, method) {\n                if (node.addEventListener) {\n                    node.addEventListener(eventType, method);\n                } else if (node.attachEvent) {\n                    node.attachEvent(\"on\" + eventType, method);\n                } else {\n                    node[\"on\" + eventType] = method;\n                }\n            };\n            helpers.removeEvent = function (node, eventType, handler) {\n                if (node.removeEventListener) {\n                    node.removeEventListener(eventType, handler, false);\n                } else if (node.detachEvent) {\n                    node.detachEvent(\"on\" + eventType, handler);\n                } else {\n                    node[\"on\" + eventType] = helpers.noop;\n                }\n            };\n            helpers.bindEvents = function (chartInstance, arrayOfEvents, handler) {\n                // Create the events object if it's not already present\n                if (!chartInstance.events)\n                    chartInstance.events = {};\n\n                helpers.each(arrayOfEvents, function (eventName) {\n                    chartInstance.events[eventName] = function () {\n                        handler.apply(chartInstance, arguments);\n                    };\n                    helpers.addEvent(chartInstance.chart.canvas, eventName, chartInstance.events[eventName]);\n                });\n            };\n            helpers.unbindEvents = function (chartInstance, arrayOfEvents) {\n                helpers.each(arrayOfEvents, function (handler, eventName) {\n                    helpers.removeEvent(chartInstance.chart.canvas, eventName, handler);\n                });\n            };\n\n            // Private helper function to convert max-width/max-height values that may be percentages into a number\n            function parseMaxStyle(styleValue, node, parentProperty) {\n                var valueInPixels;\n                if (typeof (styleValue) === 'string') {\n                    valueInPixels = parseInt(styleValue, 10);\n\n                    if (styleValue.indexOf('%') != -1) {\n                        // percentage * size in dimension\n                        valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];\n                    }\n                } else {\n                    valueInPixels = styleValue;\n                }\n\n                return valueInPixels;\n            }\n\n            // Private helper to get a constraint dimension\n            // @param domNode : the node to check the constraint on\n            // @param maxStyle : the style that defines the maximum for the direction we are using (max-width / max-height)\n            // @param percentageProperty : property of parent to use when calculating width as a percentage\n            function getConstraintDimension(domNode, maxStyle, percentageProperty) {\n                var constrainedDimension;\n                var constrainedNode = document.defaultView.getComputedStyle(domNode)[maxStyle];\n                var constrainedContainer = document.defaultView.getComputedStyle(domNode.parentNode)[maxStyle];\n                var hasCNode = constrainedNode !== null && constrainedNode !== \"none\";\n                var hasCContainer = constrainedContainer !== null && constrainedContainer !== \"none\";\n\n                if (hasCNode || hasCContainer) {\n                    constrainedDimension = Math.min((hasCNode ? parseMaxStyle(constrainedNode, domNode, percentageProperty) : Number.POSITIVE_INFINITY), (hasCContainer ? parseMaxStyle(constrainedContainer, domNode.parentNode, percentageProperty) : Number.POSITIVE_INFINITY));\n                }\n                return constrainedDimension;\n            }\n            // returns Number or undefined if no constraint\n            helpers.getConstraintWidth = function (domNode) {\n                return getConstraintDimension(domNode, 'max-width', 'clientWidth');\n            };\n            // returns Number or undefined if no constraint\n            helpers.getConstraintHeight = function (domNode) {\n                return getConstraintDimension(domNode, 'max-height', 'clientHeight');\n            };\n            helpers.getMaximumWidth = function (domNode) {\n                var container = domNode.parentNode;\n                var padding = parseInt(helpers.getStyle(container, 'padding-left')) + parseInt(helpers.getStyle(container, 'padding-right'));\n\n                var w = container.clientWidth - padding;\n                var cw = helpers.getConstraintWidth(domNode);\n                if (cw !== undefined) {\n                    w = Math.min(w, cw);\n                }\n\n                return w;\n            };\n            helpers.getMaximumHeight = function (domNode) {\n                var container = domNode.parentNode;\n                var padding = parseInt(helpers.getStyle(container, 'padding-top')) + parseInt(helpers.getStyle(container, 'padding-bottom'));\n\n                var h = container.clientHeight - padding;\n                var ch = helpers.getConstraintHeight(domNode);\n                if (ch !== undefined) {\n                    h = Math.min(h, ch);\n                }\n\n                return h;\n            };\n            helpers.getStyle = function (el, property) {\n                return el.currentStyle ?\n                    el.currentStyle[property] :\n                    document.defaultView.getComputedStyle(el, null).getPropertyValue(property);\n            };\n            helpers.retinaScale = function (chart) {\n                var ctx = chart.ctx;\n                var width = chart.canvas.width;\n                var height = chart.canvas.height;\n                var pixelRatio = chart.currentDevicePixelRatio = window.devicePixelRatio || 1;\n\n                if (pixelRatio !== 1) {\n                    ctx.canvas.height = height * pixelRatio;\n                    ctx.canvas.width = width * pixelRatio;\n                    ctx.scale(pixelRatio, pixelRatio);\n\n                    // Store the device pixel ratio so that we can go backwards in `destroy`.\n                    // The devicePixelRatio changes with zoom, so there are no guarantees that it is the same\n                    // when destroy is called\n                    chart.originalDevicePixelRatio = chart.originalDevicePixelRatio || pixelRatio;\n                }\n\n                ctx.canvas.style.width = width + 'px';\n                ctx.canvas.style.height = height + 'px';\n            };\n            //-- Canvas methods\n            helpers.clear = function (chart) {\n                chart.ctx.clearRect(0, 0, chart.width, chart.height);\n            };\n            helpers.fontString = function (pixelSize, fontStyle, fontFamily) {\n                return fontStyle + \" \" + pixelSize + \"px \" + fontFamily;\n            };\n            helpers.longestText = function (ctx, font, arrayOfStrings, cache) {\n                cache = cache || {};\n                cache.data = cache.data || {};\n                cache.garbageCollect = cache.garbageCollect || [];\n\n                if (cache.font !== font) {\n                    cache.data = {};\n                    cache.garbageCollect = [];\n                    cache.font = font;\n                }\n\n                ctx.font = font;\n                var longest = 0;\n                helpers.each(arrayOfStrings, function (string) {\n                    // Undefined strings should not be measured\n                    if (string !== undefined && string !== null) {\n                        var textWidth = cache.data[string];\n                        if (!textWidth) {\n                            textWidth = cache.data[string] = ctx.measureText(string).width;\n                            cache.garbageCollect.push(string);\n                        }\n\n                        if (textWidth > longest) {\n                            longest = textWidth;\n                        }\n                    }\n                });\n\n                var gcLen = cache.garbageCollect.length / 2;\n                if (gcLen > arrayOfStrings.length) {\n                    for (var i = 0; i < gcLen; i++) {\n                        delete cache.data[cache.garbageCollect[i]];\n                    }\n                    cache.garbageCollect.splice(0, gcLen);\n                }\n\n                return longest;\n            };\n            helpers.drawRoundedRectangle = function (ctx, x, y, width, height, radius) {\n                ctx.beginPath();\n                ctx.moveTo(x + radius, y);\n                ctx.lineTo(x + width - radius, y);\n                ctx.quadraticCurveTo(x + width, y, x + width, y + radius);\n                ctx.lineTo(x + width, y + height - radius);\n                ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);\n                ctx.lineTo(x + radius, y + height);\n                ctx.quadraticCurveTo(x, y + height, x, y + height - radius);\n                ctx.lineTo(x, y + radius);\n                ctx.quadraticCurveTo(x, y, x + radius, y);\n                ctx.closePath();\n            };\n            helpers.color = function (c) {\n                if (!color) {\n                    console.log('Color.js not found!');\n                    return c;\n                }\n\n                /* global CanvasGradient */\n                if (c instanceof CanvasGradient) {\n                    return color(Chart.defaults.global.defaultColor);\n                }\n\n                return color(c);\n            };\n            helpers.addResizeListener = function (node, callback) {\n                // Hide an iframe before the node\n                var hiddenIframe = document.createElement('iframe');\n                var hiddenIframeClass = 'chartjs-hidden-iframe';\n\n                if (hiddenIframe.classlist) {\n                    // can use classlist\n                    hiddenIframe.classlist.add(hiddenIframeClass);\n                } else {\n                    hiddenIframe.setAttribute('class', hiddenIframeClass);\n                }\n\n                // Set the style\n                hiddenIframe.style.width = '100%';\n                hiddenIframe.style.display = 'block';\n                hiddenIframe.style.border = 0;\n                hiddenIframe.style.height = 0;\n                hiddenIframe.style.margin = 0;\n                hiddenIframe.style.position = 'absolute';\n                hiddenIframe.style.left = 0;\n                hiddenIframe.style.right = 0;\n                hiddenIframe.style.top = 0;\n                hiddenIframe.style.bottom = 0;\n\n                // Insert the iframe so that contentWindow is available\n                node.insertBefore(hiddenIframe, node.firstChild);\n\n                (hiddenIframe.contentWindow || hiddenIframe).onresize = function () {\n                    if (callback) {\n                        callback();\n                    }\n                };\n            };\n            helpers.removeResizeListener = function (node) {\n                var hiddenIframe = node.querySelector('.chartjs-hidden-iframe');\n\n                // Remove the resize detect iframe\n                if (hiddenIframe) {\n                    hiddenIframe.parentNode.removeChild(hiddenIframe);\n                }\n            };\n            helpers.isArray = function (obj) {\n                if (!Array.isArray) {\n                    return Object.prototype.toString.call(obj) === '[object Array]';\n                }\n                return Array.isArray(obj);\n            };\n            helpers.pushAllIfDefined = function (element, array) {\n                if (typeof element === \"undefined\") {\n                    return;\n                }\n\n                if (helpers.isArray(element)) {\n                    array.push.apply(array, element);\n                } else {\n                    array.push(element);\n                }\n            };\n            helpers.callCallback = function (fn, args, _tArg) {\n                if (fn && typeof fn.call === 'function') {\n                    fn.apply(_tArg, args);\n                }\n            };\n\n        };\n\n    }, { \"chartjs-color\": 3 }], 26: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function () {\n\n            //Occupy the global variable of Chart, and create a simple base class\n            var Chart = function (context, config) {\n                this.config = config;\n\n                // Support a jQuery'd canvas element\n                if (context.length && context[0].getContext) {\n                    context = context[0];\n                }\n\n                // Support a canvas domnode\n                if (context.getContext) {\n                    context = context.getContext(\"2d\");\n                }\n\n                this.ctx = context;\n                this.canvas = context.canvas;\n\n                // Figure out what the size of the chart will be.\n                // If the canvas has a specified width and height, we use those else\n                // we look to see if the canvas node has a CSS width and height.\n                // If there is still no height, fill the parent container\n                this.width = context.canvas.width || parseInt(Chart.helpers.getStyle(context.canvas, 'width')) || Chart.helpers.getMaximumWidth(context.canvas);\n                this.height = context.canvas.height || parseInt(Chart.helpers.getStyle(context.canvas, 'height')) || Chart.helpers.getMaximumHeight(context.canvas);\n\n                this.aspectRatio = this.width / this.height;\n\n                if (isNaN(this.aspectRatio) || isFinite(this.aspectRatio) === false) {\n                    // If the canvas has no size, try and figure out what the aspect ratio will be.\n                    // Some charts prefer square canvases (pie, radar, etc). If that is specified, use that\n                    // else use the canvas default ratio of 2\n                    this.aspectRatio = config.aspectRatio !== undefined ? config.aspectRatio : 2;\n                }\n\n                // Store the original style of the element so we can set it back\n                this.originalCanvasStyleWidth = context.canvas.style.width;\n                this.originalCanvasStyleHeight = context.canvas.style.height;\n\n                // High pixel density displays - multiply the size of the canvas height/width by the device pixel ratio, then scale.\n                Chart.helpers.retinaScale(this);\n\n                if (config) {\n                    this.controller = new Chart.Controller(this);\n                }\n\n                // Always bind this so that if the responsive state changes we still work\n                var _this = this;\n                Chart.helpers.addResizeListener(context.canvas.parentNode, function () {\n                    if (_this.controller && _this.controller.config.options.responsive) {\n                        _this.controller.resize();\n                    }\n                });\n\n                return this.controller ? this.controller : this;\n\n            };\n\n            //Globally expose the defaults to allow for user updating/changing\n            Chart.defaults = {\n                global: {\n                    responsive: true,\n                    responsiveAnimationDuration: 0,\n                    maintainAspectRatio: true,\n                    events: [\"mousemove\", \"mouseout\", \"click\", \"touchstart\", \"touchmove\"],\n                    hover: {\n                        onHover: null,\n                        mode: 'single',\n                        animationDuration: 400\n                    },\n                    onClick: null,\n                    defaultColor: 'rgba(0,0,0,0.1)',\n                    defaultFontColor: '#666',\n                    defaultFontFamily: \"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif\",\n                    defaultFontSize: 12,\n                    defaultFontStyle: 'normal',\n                    showLines: true,\n\n                    // Element defaults defined in element extensions\n                    elements: {},\n\n                    // Legend callback string\n                    legendCallback: function (chart) {\n                        var text = [];\n                        text.push('<ul class=\"' + chart.id + '-legend\">');\n                        for (var i = 0; i < chart.data.datasets.length; i++) {\n                            text.push('<li><span style=\"background-color:' + chart.data.datasets[i].backgroundColor + '\"></span>');\n                            if (chart.data.datasets[i].label) {\n                                text.push(chart.data.datasets[i].label);\n                            }\n                            text.push('</li>');\n                        }\n                        text.push('</ul>');\n\n                        return text.join(\"\");\n                    }\n                }\n            };\n\n            return Chart;\n\n        };\n\n    }, {}], 27: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            // The layout service is very self explanatory.  It's responsible for the layout within a chart.\n            // Scales, Legends and Plugins all rely on the layout service and can easily register to be placed anywhere they need\n            // It is this service's responsibility of carrying out that layout.\n            Chart.layoutService = {\n                defaults: {},\n\n                // Register a box to a chartInstance. A box is simply a reference to an object that requires layout. eg. Scales, Legend, Plugins.\n                addBox: function (chartInstance, box) {\n                    if (!chartInstance.boxes) {\n                        chartInstance.boxes = [];\n                    }\n                    chartInstance.boxes.push(box);\n                },\n\n                removeBox: function (chartInstance, box) {\n                    if (!chartInstance.boxes) {\n                        return;\n                    }\n                    chartInstance.boxes.splice(chartInstance.boxes.indexOf(box), 1);\n                },\n\n                // The most important function\n                update: function (chartInstance, width, height) {\n\n                    if (!chartInstance) {\n                        return;\n                    }\n\n                    var xPadding = 0;\n                    var yPadding = 0;\n\n                    var leftBoxes = helpers.where(chartInstance.boxes, function (box) {\n                        return box.options.position === \"left\";\n                    });\n                    var rightBoxes = helpers.where(chartInstance.boxes, function (box) {\n                        return box.options.position === \"right\";\n                    });\n                    var topBoxes = helpers.where(chartInstance.boxes, function (box) {\n                        return box.options.position === \"top\";\n                    });\n                    var bottomBoxes = helpers.where(chartInstance.boxes, function (box) {\n                        return box.options.position === \"bottom\";\n                    });\n\n                    // Boxes that overlay the chartarea such as the radialLinear scale\n                    var chartAreaBoxes = helpers.where(chartInstance.boxes, function (box) {\n                        return box.options.position === \"chartArea\";\n                    });\n\n                    // Ensure that full width boxes are at the very top / bottom\n                    topBoxes.sort(function (a, b) {\n                        return (b.options.fullWidth ? 1 : 0) - (a.options.fullWidth ? 1 : 0);\n                    });\n                    bottomBoxes.sort(function (a, b) {\n                        return (a.options.fullWidth ? 1 : 0) - (b.options.fullWidth ? 1 : 0);\n                    });\n\n                    // Essentially we now have any number of boxes on each of the 4 sides.\n                    // Our canvas looks like the following.\n                    // The areas L1 and L2 are the left axes. R1 is the right axis, T1 is the top axis and\n                    // B1 is the bottom axis\n                    // There are also 4 quadrant-like locations (left to right instead of clockwise) reserved for chart overlays\n                    // These locations are single-box locations only, when trying to register a chartArea location that is already taken,\n                    // an error will be thrown.\n                    //\n                    // |----------------------------------------------------|\n                    // |                  T1 (Full Width)                   |\n                    // |----------------------------------------------------|\n                    // |    |    |                 T2                  |    |\n                    // |    |----|-------------------------------------|----|\n                    // |    |    | C1 |                           | C2 |    |\n                    // |    |    |----|                           |----|    |\n                    // |    |    |                                     |    |\n                    // | L1 | L2 |           ChartArea (C0)            | R1 |\n                    // |    |    |                                     |    |\n                    // |    |    |----|                           |----|    |\n                    // |    |    | C3 |                           | C4 |    |\n                    // |    |----|-------------------------------------|----|\n                    // |    |    |                 B1                  |    |\n                    // |----------------------------------------------------|\n                    // |                  B2 (Full Width)                   |\n                    // |----------------------------------------------------|\n                    //\n                    // What we do to find the best sizing, we do the following\n                    // 1. Determine the minimum size of the chart area.\n                    // 2. Split the remaining width equally between each vertical axis\n                    // 3. Split the remaining height equally between each horizontal axis\n                    // 4. Give each layout the maximum size it can be. The layout will return it's minimum size\n                    // 5. Adjust the sizes of each axis based on it's minimum reported size.\n                    // 6. Refit each axis\n                    // 7. Position each axis in the final location\n                    // 8. Tell the chart the final location of the chart area\n                    // 9. Tell any axes that overlay the chart area the positions of the chart area\n\n                    // Step 1\n                    var chartWidth = width - (2 * xPadding);\n                    var chartHeight = height - (2 * yPadding);\n                    var chartAreaWidth = chartWidth / 2; // min 50%\n                    var chartAreaHeight = chartHeight / 2; // min 50%\n\n                    // Step 2\n                    var verticalBoxWidth = (width - chartAreaWidth) / (leftBoxes.length + rightBoxes.length);\n\n                    // Step 3\n                    var horizontalBoxHeight = (height - chartAreaHeight) / (topBoxes.length + bottomBoxes.length);\n\n                    // Step 4\n                    var maxChartAreaWidth = chartWidth;\n                    var maxChartAreaHeight = chartHeight;\n                    var minBoxSizes = [];\n\n                    helpers.each(leftBoxes.concat(rightBoxes, topBoxes, bottomBoxes), getMinimumBoxSize);\n\n                    function getMinimumBoxSize(box) {\n                        var minSize;\n                        var isHorizontal = box.isHorizontal();\n\n                        if (isHorizontal) {\n                            minSize = box.update(box.options.fullWidth ? chartWidth : maxChartAreaWidth, horizontalBoxHeight);\n                            maxChartAreaHeight -= minSize.height;\n                        } else {\n                            minSize = box.update(verticalBoxWidth, chartAreaHeight);\n                            maxChartAreaWidth -= minSize.width;\n                        }\n\n                        minBoxSizes.push({\n                            horizontal: isHorizontal,\n                            minSize: minSize,\n                            box: box\n                        });\n                    }\n\n                    // At this point, maxChartAreaHeight and maxChartAreaWidth are the size the chart area could\n                    // be if the axes are drawn at their minimum sizes.\n\n                    // Steps 5 & 6\n                    var totalLeftBoxesWidth = xPadding;\n                    var totalRightBoxesWidth = xPadding;\n                    var totalTopBoxesHeight = yPadding;\n                    var totalBottomBoxesHeight = yPadding;\n\n                    // Update, and calculate the left and right margins for the horizontal boxes\n                    helpers.each(leftBoxes.concat(rightBoxes), fitBox);\n\n                    helpers.each(leftBoxes, function (box) {\n                        totalLeftBoxesWidth += box.width;\n                    });\n\n                    helpers.each(rightBoxes, function (box) {\n                        totalRightBoxesWidth += box.width;\n                    });\n\n                    // Set the Left and Right margins for the horizontal boxes\n                    helpers.each(topBoxes.concat(bottomBoxes), fitBox);\n\n                    // Function to fit a box\n                    function fitBox(box) {\n                        var minBoxSize = helpers.findNextWhere(minBoxSizes, function (minBoxSize) {\n                            return minBoxSize.box === box;\n                        });\n\n                        if (minBoxSize) {\n                            if (box.isHorizontal()) {\n                                var scaleMargin = {\n                                    left: totalLeftBoxesWidth,\n                                    right: totalRightBoxesWidth,\n                                    top: 0,\n                                    bottom: 0\n                                };\n\n                                // Don't use min size here because of label rotation. When the labels are rotated, their rotation highly depends\n                                // on the margin. Sometimes they need to increase in size slightly\n                                box.update(box.options.fullWidth ? chartWidth : maxChartAreaWidth, chartHeight / 2, scaleMargin);\n                            } else {\n                                box.update(minBoxSize.minSize.width, maxChartAreaHeight);\n                            }\n                        }\n                    }\n\n                    // Figure out how much margin is on the top and bottom of the vertical boxes\n                    helpers.each(topBoxes, function (box) {\n                        totalTopBoxesHeight += box.height;\n                    });\n\n                    helpers.each(bottomBoxes, function (box) {\n                        totalBottomBoxesHeight += box.height;\n                    });\n\n                    // Let the left layout know the final margin\n                    helpers.each(leftBoxes.concat(rightBoxes), finalFitVerticalBox);\n\n                    function finalFitVerticalBox(box) {\n                        var minBoxSize = helpers.findNextWhere(minBoxSizes, function (minBoxSize) {\n                            return minBoxSize.box === box;\n                        });\n\n                        var scaleMargin = {\n                            left: 0,\n                            right: 0,\n                            top: totalTopBoxesHeight,\n                            bottom: totalBottomBoxesHeight\n                        };\n\n                        if (minBoxSize) {\n                            box.update(minBoxSize.minSize.width, maxChartAreaHeight, scaleMargin);\n                        }\n                    }\n\n                    // Recalculate because the size of each layout might have changed slightly due to the margins (label rotation for instance)\n                    totalLeftBoxesWidth = xPadding;\n                    totalRightBoxesWidth = xPadding;\n                    totalTopBoxesHeight = yPadding;\n                    totalBottomBoxesHeight = yPadding;\n\n                    helpers.each(leftBoxes, function (box) {\n                        totalLeftBoxesWidth += box.width;\n                    });\n\n                    helpers.each(rightBoxes, function (box) {\n                        totalRightBoxesWidth += box.width;\n                    });\n\n                    helpers.each(topBoxes, function (box) {\n                        totalTopBoxesHeight += box.height;\n                    });\n                    helpers.each(bottomBoxes, function (box) {\n                        totalBottomBoxesHeight += box.height;\n                    });\n\n                    // Figure out if our chart area changed. This would occur if the dataset layout label rotation\n                    // changed due to the application of the margins in step 6. Since we can only get bigger, this is safe to do\n                    // without calling `fit` again\n                    var newMaxChartAreaHeight = height - totalTopBoxesHeight - totalBottomBoxesHeight;\n                    var newMaxChartAreaWidth = width - totalLeftBoxesWidth - totalRightBoxesWidth;\n\n                    if (newMaxChartAreaWidth !== maxChartAreaWidth || newMaxChartAreaHeight !== maxChartAreaHeight) {\n                        helpers.each(leftBoxes, function (box) {\n                            box.height = newMaxChartAreaHeight;\n                        });\n\n                        helpers.each(rightBoxes, function (box) {\n                            box.height = newMaxChartAreaHeight;\n                        });\n\n                        helpers.each(topBoxes, function (box) {\n                            if (!box.options.fullWidth) {\n                                box.width = newMaxChartAreaWidth;\n                            }\n                        });\n\n                        helpers.each(bottomBoxes, function (box) {\n                            if (!box.options.fullWidth) {\n                                box.width = newMaxChartAreaWidth;\n                            }\n                        });\n\n                        maxChartAreaHeight = newMaxChartAreaHeight;\n                        maxChartAreaWidth = newMaxChartAreaWidth;\n                    }\n\n                    // Step 7 - Position the boxes\n                    var left = xPadding;\n                    var top = yPadding;\n                    var right = 0;\n                    var bottom = 0;\n\n                    helpers.each(leftBoxes.concat(topBoxes), placeBox);\n\n                    // Account for chart width and height\n                    left += maxChartAreaWidth;\n                    top += maxChartAreaHeight;\n\n                    helpers.each(rightBoxes, placeBox);\n                    helpers.each(bottomBoxes, placeBox);\n\n                    function placeBox(box) {\n                        if (box.isHorizontal()) {\n                            box.left = box.options.fullWidth ? xPadding : totalLeftBoxesWidth;\n                            box.right = box.options.fullWidth ? width - xPadding : totalLeftBoxesWidth + maxChartAreaWidth;\n                            box.top = top;\n                            box.bottom = top + box.height;\n\n                            // Move to next point\n                            top = box.bottom;\n\n                        } else {\n\n                            box.left = left;\n                            box.right = left + box.width;\n                            box.top = totalTopBoxesHeight;\n                            box.bottom = totalTopBoxesHeight + maxChartAreaHeight;\n\n                            // Move to next point\n                            left = box.right;\n                        }\n                    }\n\n                    // Step 8\n                    chartInstance.chartArea = {\n                        left: totalLeftBoxesWidth,\n                        top: totalTopBoxesHeight,\n                        right: totalLeftBoxesWidth + maxChartAreaWidth,\n                        bottom: totalTopBoxesHeight + maxChartAreaHeight\n                    };\n\n                    // Step 9\n                    helpers.each(chartAreaBoxes, function (box) {\n                        box.left = chartInstance.chartArea.left;\n                        box.top = chartInstance.chartArea.top;\n                        box.right = chartInstance.chartArea.right;\n                        box.bottom = chartInstance.chartArea.bottom;\n\n                        box.update(maxChartAreaWidth, maxChartAreaHeight);\n                    });\n                }\n            };\n        };\n\n    }, {}], 28: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n            var noop = helpers.noop;\n\n            Chart.defaults.global.legend = {\n\n                display: true,\n                position: 'top',\n                fullWidth: true, // marks that this box should take the full width of the canvas (pushing down other boxes)\n                reverse: false,\n\n                // a callback that will handle\n                onClick: function (e, legendItem) {\n                    var index = legendItem.datasetIndex;\n                    var ci = this.chart;\n                    var meta = ci.getDatasetMeta(index);\n\n                    // See controller.isDatasetVisible comment\n                    meta.hidden = meta.hidden === null ? !ci.data.datasets[index].hidden : null;\n\n                    // We hid a dataset ... rerender the chart\n                    ci.update();\n                },\n\n                labels: {\n                    boxWidth: 40,\n                    padding: 10,\n                    // Generates labels shown in the legend\n                    // Valid properties to return:\n                    // text : text to display\n                    // fillStyle : fill of coloured box\n                    // strokeStyle: stroke of coloured box\n                    // hidden : if this legend item refers to a hidden item\n                    // lineCap : cap style for line\n                    // lineDash\n                    // lineDashOffset :\n                    // lineJoin :\n                    // lineWidth :\n                    generateLabels: function (chart) {\n                        var data = chart.data;\n                        return helpers.isArray(data.datasets) ? data.datasets.map(function (dataset, i) {\n                            return {\n                                text: dataset.label,\n                                fillStyle: dataset.backgroundColor,\n                                hidden: !chart.isDatasetVisible(i),\n                                lineCap: dataset.borderCapStyle,\n                                lineDash: dataset.borderDash,\n                                lineDashOffset: dataset.borderDashOffset,\n                                lineJoin: dataset.borderJoinStyle,\n                                lineWidth: dataset.borderWidth,\n                                strokeStyle: dataset.borderColor,\n\n                                // Below is extra data used for toggling the datasets\n                                datasetIndex: i\n                            };\n                        }, this) : [];\n                    }\n                }\n            };\n\n            Chart.Legend = Chart.Element.extend({\n\n                initialize: function (config) {\n                    helpers.extend(this, config);\n\n                    // Contains hit boxes for each dataset (in dataset order)\n                    this.legendHitBoxes = [];\n\n                    // Are we in doughnut mode which has a different data type\n                    this.doughnutMode = false;\n                },\n\n                // These methods are ordered by lifecyle. Utilities then follow.\n                // Any function defined here is inherited by all legend types.\n                // Any function can be extended by the legend type\n\n                beforeUpdate: noop,\n                update: function (maxWidth, maxHeight, margins) {\n\n                    // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)\n                    this.beforeUpdate();\n\n                    // Absorb the master measurements\n                    this.maxWidth = maxWidth;\n                    this.maxHeight = maxHeight;\n                    this.margins = margins;\n\n                    // Dimensions\n                    this.beforeSetDimensions();\n                    this.setDimensions();\n                    this.afterSetDimensions();\n                    // Labels\n                    this.beforeBuildLabels();\n                    this.buildLabels();\n                    this.afterBuildLabels();\n\n                    // Fit\n                    this.beforeFit();\n                    this.fit();\n                    this.afterFit();\n                    //\n                    this.afterUpdate();\n\n                    return this.minSize;\n                },\n                afterUpdate: noop,\n\n                //\n\n                beforeSetDimensions: noop,\n                setDimensions: function () {\n                    // Set the unconstrained dimension before label rotation\n                    if (this.isHorizontal()) {\n                        // Reset position before calculating rotation\n                        this.width = this.maxWidth;\n                        this.left = 0;\n                        this.right = this.width;\n                    } else {\n                        this.height = this.maxHeight;\n\n                        // Reset position before calculating rotation\n                        this.top = 0;\n                        this.bottom = this.height;\n                    }\n\n                    // Reset padding\n                    this.paddingLeft = 0;\n                    this.paddingTop = 0;\n                    this.paddingRight = 0;\n                    this.paddingBottom = 0;\n\n                    // Reset minSize\n                    this.minSize = {\n                        width: 0,\n                        height: 0\n                    };\n                },\n                afterSetDimensions: noop,\n\n                //\n\n                beforeBuildLabels: noop,\n                buildLabels: function () {\n                    this.legendItems = this.options.labels.generateLabels.call(this, this.chart);\n                    if (this.options.reverse) {\n                        this.legendItems.reverse();\n                    }\n                },\n                afterBuildLabels: noop,\n\n                //\n\n                beforeFit: noop,\n                fit: function () {\n                    var opts = this.options;\n                    var labelOpts = opts.labels;\n                    var display = opts.display;\n\n                    var ctx = this.ctx;\n\n                    var globalDefault = Chart.defaults.global,\n                        itemOrDefault = helpers.getValueOrDefault,\n                        fontSize = itemOrDefault(labelOpts.fontSize, globalDefault.defaultFontSize),\n                        fontStyle = itemOrDefault(labelOpts.fontStyle, globalDefault.defaultFontStyle),\n                        fontFamily = itemOrDefault(labelOpts.fontFamily, globalDefault.defaultFontFamily),\n                        labelFont = helpers.fontString(fontSize, fontStyle, fontFamily);\n\n                    // Reset hit boxes\n                    var hitboxes = this.legendHitBoxes = [];\n\n                    var minSize = this.minSize;\n                    var isHorizontal = this.isHorizontal();\n\n                    if (isHorizontal) {\n                        minSize.width = this.maxWidth; // fill all the width\n                        minSize.height = display ? 10 : 0;\n                    } else {\n                        minSize.width = display ? 10 : 0;\n                        minSize.height = this.maxHeight; // fill all the height\n                    }\n\n                    // Increase sizes here\n                    if (display) {\n                        if (isHorizontal) {\n                            // Labels\n\n                            // Width of each line of legend boxes. Labels wrap onto multiple lines when there are too many to fit on one\n                            var lineWidths = this.lineWidths = [0];\n                            var totalHeight = this.legendItems.length ? fontSize + (labelOpts.padding) : 0;\n\n                            ctx.textAlign = \"left\";\n                            ctx.textBaseline = 'top';\n                            ctx.font = labelFont;\n\n                            helpers.each(this.legendItems, function (legendItem, i) {\n                                var width = labelOpts.boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;\n                                if (lineWidths[lineWidths.length - 1] + width + labelOpts.padding >= this.width) {\n                                    totalHeight += fontSize + (labelOpts.padding);\n                                    lineWidths[lineWidths.length] = this.left;\n                                }\n\n                                // Store the hitbox width and height here. Final position will be updated in `draw`\n                                hitboxes[i] = {\n                                    left: 0,\n                                    top: 0,\n                                    width: width,\n                                    height: fontSize\n                                };\n\n                                lineWidths[lineWidths.length - 1] += width + labelOpts.padding;\n                            }, this);\n\n                            minSize.height += totalHeight;\n\n                        } else {\n                            // TODO vertical\n                        }\n                    }\n\n                    this.width = minSize.width;\n                    this.height = minSize.height;\n                },\n                afterFit: noop,\n\n                // Shared Methods\n                isHorizontal: function () {\n                    return this.options.position === \"top\" || this.options.position === \"bottom\";\n                },\n\n                // Actualy draw the legend on the canvas\n                draw: function () {\n                    var opts = this.options;\n                    var labelOpts = opts.labels;\n                    var globalDefault = Chart.defaults.global,\n                        lineDefault = globalDefault.elements.line,\n                        legendWidth = this.width,\n                        lineWidths = this.lineWidths;\n\n                    if (opts.display) {\n                        var ctx = this.ctx,\n                            cursor = {\n                                x: this.left + ((legendWidth - lineWidths[0]) / 2),\n                                y: this.top + labelOpts.padding,\n                                line: 0\n                            },\n                            itemOrDefault = helpers.getValueOrDefault,\n                            fontColor = itemOrDefault(labelOpts.fontColor, globalDefault.defaultFontColor),\n                            fontSize = itemOrDefault(labelOpts.fontSize, globalDefault.defaultFontSize),\n                            fontStyle = itemOrDefault(labelOpts.fontStyle, globalDefault.defaultFontStyle),\n                            fontFamily = itemOrDefault(labelOpts.fontFamily, globalDefault.defaultFontFamily),\n                            labelFont = helpers.fontString(fontSize, fontStyle, fontFamily);\n\n                        // Horizontal\n                        if (this.isHorizontal()) {\n                            // Labels\n                            ctx.textAlign = \"left\";\n                            ctx.textBaseline = 'top';\n                            ctx.lineWidth = 0.5;\n                            ctx.strokeStyle = fontColor; // for strikethrough effect\n                            ctx.fillStyle = fontColor; // render in correct colour\n                            ctx.font = labelFont;\n\n                            var boxWidth = labelOpts.boxWidth,\n                                hitboxes = this.legendHitBoxes;\n\n                            helpers.each(this.legendItems, function (legendItem, i) {\n                                var textWidth = ctx.measureText(legendItem.text).width,\n                                    width = boxWidth + (fontSize / 2) + textWidth,\n                                    x = cursor.x,\n                                    y = cursor.y;\n\n                                if (x + width >= legendWidth) {\n                                    y = cursor.y += fontSize + (labelOpts.padding);\n                                    cursor.line++;\n                                    x = cursor.x = this.left + ((legendWidth - lineWidths[cursor.line]) / 2);\n                                }\n\n                                // Set the ctx for the box\n                                ctx.save();\n\n                                ctx.fillStyle = itemOrDefault(legendItem.fillStyle, globalDefault.defaultColor);\n                                ctx.lineCap = itemOrDefault(legendItem.lineCap, lineDefault.borderCapStyle);\n                                ctx.lineDashOffset = itemOrDefault(legendItem.lineDashOffset, lineDefault.borderDashOffset);\n                                ctx.lineJoin = itemOrDefault(legendItem.lineJoin, lineDefault.borderJoinStyle);\n                                ctx.lineWidth = itemOrDefault(legendItem.lineWidth, lineDefault.borderWidth);\n                                ctx.strokeStyle = itemOrDefault(legendItem.strokeStyle, globalDefault.defaultColor);\n\n                                if (ctx.setLineDash) {\n                                    // IE 9 and 10 do not support line dash\n                                    ctx.setLineDash(itemOrDefault(legendItem.lineDash, lineDefault.borderDash));\n                                }\n\n                                // Draw the box\n                                ctx.strokeRect(x, y, boxWidth, fontSize);\n                                ctx.fillRect(x, y, boxWidth, fontSize);\n\n                                ctx.restore();\n\n                                hitboxes[i].left = x;\n                                hitboxes[i].top = y;\n\n                                // Fill the actual label\n                                ctx.fillText(legendItem.text, boxWidth + (fontSize / 2) + x, y);\n\n                                if (legendItem.hidden) {\n                                    // Strikethrough the text if hidden\n                                    ctx.beginPath();\n                                    ctx.lineWidth = 2;\n                                    ctx.moveTo(boxWidth + (fontSize / 2) + x, y + (fontSize / 2));\n                                    ctx.lineTo(boxWidth + (fontSize / 2) + x + textWidth, y + (fontSize / 2));\n                                    ctx.stroke();\n                                }\n\n                                cursor.x += width + (labelOpts.padding);\n                            }, this);\n                        } else {\n\n                        }\n                    }\n                },\n\n                // Handle an event\n                handleEvent: function (e) {\n                    var position = helpers.getRelativePosition(e, this.chart.chart),\n                        x = position.x,\n                        y = position.y,\n                        opts = this.options;\n\n                    if (x >= this.left && x <= this.right && y >= this.top && y <= this.bottom) {\n                        // See if we are touching one of the dataset boxes\n                        var lh = this.legendHitBoxes;\n                        for (var i = 0; i < lh.length; ++i) {\n                            var hitBox = lh[i];\n\n                            if (x >= hitBox.left && x <= hitBox.left + hitBox.width && y >= hitBox.top && y <= hitBox.top + hitBox.height) {\n                                // Touching an element\n                                if (opts.onClick) {\n                                    opts.onClick.call(this, e, this.legendItems[i]);\n                                }\n                                break;\n                            }\n                        }\n                    }\n                }\n            });\n\n        };\n\n    }, {}], 29: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n            var helpers = Chart.helpers;\n\n            // Plugins are stored here\n            Chart.plugins = [];\n            Chart.pluginService = {\n                // Register a new plugin\n                register: function (plugin) {\n                    var p = Chart.plugins;\n                    if (p.indexOf(plugin) === -1) {\n                        p.push(plugin);\n                    }\n                },\n\n                // Remove a registered plugin\n                remove: function (plugin) {\n                    var p = Chart.plugins;\n                    var idx = p.indexOf(plugin);\n                    if (idx !== -1) {\n                        p.splice(idx, 1);\n                    }\n                },\n\n                // Iterate over all plugins\n                notifyPlugins: function (method, args, scope) {\n                    helpers.each(Chart.plugins, function (plugin) {\n                        if (plugin[method] && typeof plugin[method] === 'function') {\n                            plugin[method].apply(scope, args);\n                        }\n                    }, scope);\n                }\n            };\n\n            var noop = helpers.noop;\n            Chart.PluginBase = Chart.Element.extend({\n                // Plugin methods. All functions are passed the chart instance\n\n                // Called at start of chart init\n                beforeInit: noop,\n\n                // Called at end of chart init\n                afterInit: noop,\n\n                // Called at start of update\n                beforeUpdate: noop,\n\n                // Called at end of update\n                afterUpdate: noop,\n\n                // Called at start of draw\n                beforeDraw: noop,\n\n                // Called at end of draw\n                afterDraw: noop,\n\n                // Called during destroy\n                destroy: noop,\n            });\n        };\n\n    }, {}], 30: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.scale = {\n                display: true,\n                position: \"left\",\n\n                // grid line settings\n                gridLines: {\n                    display: true,\n                    color: \"rgba(0, 0, 0, 0.1)\",\n                    lineWidth: 1,\n                    drawOnChartArea: true,\n                    drawTicks: true,\n                    tickMarkLength: 10,\n                    zeroLineWidth: 1,\n                    zeroLineColor: \"rgba(0,0,0,0.25)\",\n                    offsetGridLines: false\n                },\n\n                // scale label\n                scaleLabel: {\n                    // actual label\n                    labelString: '',\n\n                    // display property\n                    display: false\n                },\n\n                // label settings\n                ticks: {\n                    beginAtZero: false,\n                    maxRotation: 50,\n                    mirror: false,\n                    padding: 10,\n                    reverse: false,\n                    display: true,\n                    autoSkip: true,\n                    autoSkipPadding: 0,\n                    callback: function (value) {\n                        return '' + value;\n                    }\n                }\n            };\n\n            Chart.Scale = Chart.Element.extend({\n\n                // These methods are ordered by lifecyle. Utilities then follow.\n                // Any function defined here is inherited by all scale types.\n                // Any function can be extended by the scale type\n\n                beforeUpdate: function () {\n                    helpers.callCallback(this.options.beforeUpdate, [this]);\n                },\n                update: function (maxWidth, maxHeight, margins) {\n\n                    // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)\n                    this.beforeUpdate();\n\n                    // Absorb the master measurements\n                    this.maxWidth = maxWidth;\n                    this.maxHeight = maxHeight;\n                    this.margins = helpers.extend({\n                        left: 0,\n                        right: 0,\n                        top: 0,\n                        bottom: 0\n                    }, margins);\n\n                    // Dimensions\n                    this.beforeSetDimensions();\n                    this.setDimensions();\n                    this.afterSetDimensions();\n\n                    // Data min/max\n                    this.beforeDataLimits();\n                    this.determineDataLimits();\n                    this.afterDataLimits();\n\n                    // Ticks\n                    this.beforeBuildTicks();\n                    this.buildTicks();\n                    this.afterBuildTicks();\n\n                    this.beforeTickToLabelConversion();\n                    this.convertTicksToLabels();\n                    this.afterTickToLabelConversion();\n\n                    // Tick Rotation\n                    this.beforeCalculateTickRotation();\n                    this.calculateTickRotation();\n                    this.afterCalculateTickRotation();\n                    // Fit\n                    this.beforeFit();\n                    this.fit();\n                    this.afterFit();\n                    //\n                    this.afterUpdate();\n\n                    return this.minSize;\n\n                },\n                afterUpdate: function () {\n                    helpers.callCallback(this.options.afterUpdate, [this]);\n                },\n\n                //\n\n                beforeSetDimensions: function () {\n                    helpers.callCallback(this.options.beforeSetDimensions, [this]);\n                },\n                setDimensions: function () {\n                    // Set the unconstrained dimension before label rotation\n                    if (this.isHorizontal()) {\n                        // Reset position before calculating rotation\n                        this.width = this.maxWidth;\n                        this.left = 0;\n                        this.right = this.width;\n                    } else {\n                        this.height = this.maxHeight;\n\n                        // Reset position before calculating rotation\n                        this.top = 0;\n                        this.bottom = this.height;\n                    }\n\n                    // Reset padding\n                    this.paddingLeft = 0;\n                    this.paddingTop = 0;\n                    this.paddingRight = 0;\n                    this.paddingBottom = 0;\n                },\n                afterSetDimensions: function () {\n                    helpers.callCallback(this.options.afterSetDimensions, [this]);\n                },\n\n                // Data limits\n                beforeDataLimits: function () {\n                    helpers.callCallback(this.options.beforeDataLimits, [this]);\n                },\n                determineDataLimits: helpers.noop,\n                afterDataLimits: function () {\n                    helpers.callCallback(this.options.afterDataLimits, [this]);\n                },\n\n                //\n                beforeBuildTicks: function () {\n                    helpers.callCallback(this.options.beforeBuildTicks, [this]);\n                },\n                buildTicks: helpers.noop,\n                afterBuildTicks: function () {\n                    helpers.callCallback(this.options.afterBuildTicks, [this]);\n                },\n\n                beforeTickToLabelConversion: function () {\n                    helpers.callCallback(this.options.beforeTickToLabelConversion, [this]);\n                },\n                convertTicksToLabels: function () {\n                    // Convert ticks to strings\n                    this.ticks = this.ticks.map(function (numericalTick, index, ticks) {\n                        if (this.options.ticks.userCallback) {\n                            return this.options.ticks.userCallback(numericalTick, index, ticks);\n                        }\n                        return this.options.ticks.callback(numericalTick, index, ticks);\n                    },\n                        this);\n                },\n                afterTickToLabelConversion: function () {\n                    helpers.callCallback(this.options.afterTickToLabelConversion, [this]);\n                },\n\n                //\n\n                beforeCalculateTickRotation: function () {\n                    helpers.callCallback(this.options.beforeCalculateTickRotation, [this]);\n                },\n                calculateTickRotation: function () {\n                    //Get the width of each grid by calculating the difference\n                    //between x offsets between 0 and 1.\n                    var tickFontSize = helpers.getValueOrDefault(this.options.ticks.fontSize, Chart.defaults.global.defaultFontSize);\n                    var tickFontStyle = helpers.getValueOrDefault(this.options.ticks.fontStyle, Chart.defaults.global.defaultFontStyle);\n                    var tickFontFamily = helpers.getValueOrDefault(this.options.ticks.fontFamily, Chart.defaults.global.defaultFontFamily);\n                    var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);\n                    this.ctx.font = tickLabelFont;\n\n                    var firstWidth = this.ctx.measureText(this.ticks[0]).width;\n                    var lastWidth = this.ctx.measureText(this.ticks[this.ticks.length - 1]).width;\n                    var firstRotated;\n\n                    this.labelRotation = 0;\n                    this.paddingRight = 0;\n                    this.paddingLeft = 0;\n\n                    if (this.options.display) {\n                        if (this.isHorizontal()) {\n                            this.paddingRight = lastWidth / 2 + 3;\n                            this.paddingLeft = firstWidth / 2 + 3;\n\n                            if (!this.longestTextCache) {\n                                this.longestTextCache = {};\n                            }\n                            var originalLabelWidth = helpers.longestText(this.ctx, tickLabelFont, this.ticks, this.longestTextCache);\n                            var labelWidth = originalLabelWidth;\n                            var cosRotation;\n                            var sinRotation;\n\n                            // Allow 3 pixels x2 padding either side for label readability\n                            // only the index matters for a dataset scale, but we want a consistent interface between scales\n                            var tickWidth = this.getPixelForTick(1) - this.getPixelForTick(0) - 6;\n\n                            //Max label rotation can be set or default to 90 - also act as a loop counter\n                            while (labelWidth > tickWidth && this.labelRotation < this.options.ticks.maxRotation) {\n                                cosRotation = Math.cos(helpers.toRadians(this.labelRotation));\n                                sinRotation = Math.sin(helpers.toRadians(this.labelRotation));\n\n                                firstRotated = cosRotation * firstWidth;\n\n                                // We're right aligning the text now.\n                                if (firstRotated + tickFontSize / 2 > this.yLabelWidth) {\n                                    this.paddingLeft = firstRotated + tickFontSize / 2;\n                                }\n\n                                this.paddingRight = tickFontSize / 2;\n\n                                if (sinRotation * originalLabelWidth > this.maxHeight) {\n                                    // go back one step\n                                    this.labelRotation--;\n                                    break;\n                                }\n\n                                this.labelRotation++;\n                                labelWidth = cosRotation * originalLabelWidth;\n                            }\n                        }\n                    }\n\n                    if (this.margins) {\n                        this.paddingLeft = Math.max(this.paddingLeft - this.margins.left, 0);\n                        this.paddingRight = Math.max(this.paddingRight - this.margins.right, 0);\n                    }\n                },\n                afterCalculateTickRotation: function () {\n                    helpers.callCallback(this.options.afterCalculateTickRotation, [this]);\n                },\n\n                //\n\n                beforeFit: function () {\n                    helpers.callCallback(this.options.beforeFit, [this]);\n                },\n                fit: function () {\n                    // Reset\n                    var minSize = this.minSize = {\n                        width: 0,\n                        height: 0\n                    };\n\n                    var opts = this.options;\n                    var tickOpts = opts.ticks;\n                    var scaleLabelOpts = opts.scaleLabel;\n                    var globalOpts = Chart.defaults.global;\n                    var display = opts.display;\n                    var isHorizontal = this.isHorizontal();\n\n                    var tickFontSize = helpers.getValueOrDefault(tickOpts.fontSize, globalOpts.defaultFontSize);\n                    var tickFontStyle = helpers.getValueOrDefault(tickOpts.fontStyle, globalOpts.defaultFontStyle);\n                    var tickFontFamily = helpers.getValueOrDefault(tickOpts.fontFamily, globalOpts.defaultFontFamily);\n                    var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);\n\n                    var scaleLabelFontSize = helpers.getValueOrDefault(scaleLabelOpts.fontSize, globalOpts.defaultFontSize);\n                    var scaleLabelFontStyle = helpers.getValueOrDefault(scaleLabelOpts.fontStyle, globalOpts.defaultFontStyle);\n                    var scaleLabelFontFamily = helpers.getValueOrDefault(scaleLabelOpts.fontFamily, globalOpts.defaultFontFamily);\n                    var scaleLabelFont = helpers.fontString(scaleLabelFontSize, scaleLabelFontStyle, scaleLabelFontFamily);\n\n                    var tickMarkLength = opts.gridLines.tickMarkLength;\n\n                    // Width\n                    if (isHorizontal) {\n                        // subtract the margins to line up with the chartArea if we are a full width scale\n                        minSize.width = this.isFullWidth() ? this.maxWidth - this.margins.left - this.margins.right : this.maxWidth;\n                    } else {\n                        minSize.width = display ? tickMarkLength : 0;\n                    }\n\n                    // height\n                    if (isHorizontal) {\n                        minSize.height = display ? tickMarkLength : 0;\n                    } else {\n                        minSize.height = this.maxHeight; // fill all the height\n                    }\n\n                    // Are we showing a title for the scale?\n                    if (scaleLabelOpts.display && display) {\n                        if (isHorizontal) {\n                            minSize.height += (scaleLabelFontSize * 1.5);\n                        } else {\n                            minSize.width += (scaleLabelFontSize * 1.5);\n                        }\n                    }\n\n                    if (tickOpts.display && display) {\n                        // Don't bother fitting the ticks if we are not showing them\n                        if (!this.longestTextCache) {\n                            this.longestTextCache = {};\n                        }\n\n                        var largestTextWidth = helpers.longestText(this.ctx, tickLabelFont, this.ticks, this.longestTextCache);\n\n                        if (isHorizontal) {\n                            // A horizontal axis is more constrained by the height.\n                            this.longestLabelWidth = largestTextWidth;\n\n                            // TODO - improve this calculation\n                            var labelHeight = (Math.sin(helpers.toRadians(this.labelRotation)) * this.longestLabelWidth) + 1.5 * tickFontSize;\n\n                            minSize.height = Math.min(this.maxHeight, minSize.height + labelHeight);\n                            this.ctx.font = tickLabelFont;\n\n                            var firstLabelWidth = this.ctx.measureText(this.ticks[0]).width;\n                            var lastLabelWidth = this.ctx.measureText(this.ticks[this.ticks.length - 1]).width;\n\n                            // Ensure that our ticks are always inside the canvas. When rotated, ticks are right aligned which means that the right padding is dominated\n                            // by the font height\n                            var cosRotation = Math.cos(helpers.toRadians(this.labelRotation));\n                            var sinRotation = Math.sin(helpers.toRadians(this.labelRotation));\n                            this.paddingLeft = this.labelRotation !== 0 ? (cosRotation * firstLabelWidth) + 3 : firstLabelWidth / 2 + 3; // add 3 px to move away from canvas edges\n                            this.paddingRight = this.labelRotation !== 0 ? (sinRotation * (tickFontSize / 2)) + 3 : lastLabelWidth / 2 + 3; // when rotated\n                        } else {\n                            // A vertical axis is more constrained by the width. Labels are the dominant factor here, so get that length first\n                            var maxLabelWidth = this.maxWidth - minSize.width;\n\n                            // Account for padding\n                            var mirror = tickOpts.mirror;\n                            if (!mirror) {\n                                largestTextWidth += this.options.ticks.padding;\n                            } else {\n                                // If mirrored text is on the inside so don't expand\n                                largestTextWidth = 0;\n                            }\n\n                            if (largestTextWidth < maxLabelWidth) {\n                                // We don't need all the room\n                                minSize.width += largestTextWidth;\n                            } else {\n                                // Expand to max size\n                                minSize.width = this.maxWidth;\n                            }\n\n                            this.paddingTop = tickFontSize / 2;\n                            this.paddingBottom = tickFontSize / 2;\n                        }\n                    }\n\n                    if (this.margins) {\n                        this.paddingLeft = Math.max(this.paddingLeft - this.margins.left, 0);\n                        this.paddingTop = Math.max(this.paddingTop - this.margins.top, 0);\n                        this.paddingRight = Math.max(this.paddingRight - this.margins.right, 0);\n                        this.paddingBottom = Math.max(this.paddingBottom - this.margins.bottom, 0);\n                    }\n\n                    this.width = minSize.width;\n                    this.height = minSize.height;\n\n                },\n                afterFit: function () {\n                    helpers.callCallback(this.options.afterFit, [this]);\n                },\n\n                // Shared Methods\n                isHorizontal: function () {\n                    return this.options.position === \"top\" || this.options.position === \"bottom\";\n                },\n                isFullWidth: function () {\n                    return (this.options.fullWidth);\n                },\n\n                // Get the correct value. NaN bad inputs, If the value type is object get the x or y based on whether we are horizontal or not\n                getRightValue: function getRightValue(rawValue) {\n                    // Null and undefined values first\n                    if (rawValue === null || typeof (rawValue) === 'undefined') {\n                        return NaN;\n                    }\n                    // isNaN(object) returns true, so make sure NaN is checking for a number\n                    if (typeof (rawValue) === 'number' && isNaN(rawValue)) {\n                        return NaN;\n                    }\n                    // If it is in fact an object, dive in one more level\n                    if (typeof (rawValue) === \"object\") {\n                        if (rawValue instanceof Date) {\n                            return rawValue;\n                        } else {\n                            return getRightValue(this.isHorizontal() ? rawValue.x : rawValue.y);\n                        }\n                    }\n\n                    // Value is good, return it\n                    return rawValue;\n                },\n\n                // Used to get the value to display in the tooltip for the data at the given index\n                // function getLabelForIndex(index, datasetIndex)\n                getLabelForIndex: helpers.noop,\n\n                // Used to get data value locations.  Value can either be an index or a numerical value\n                getPixelForValue: helpers.noop,\n\n                // Used to get the data value from a given pixel. This is the inverse of getPixelForValue\n                getValueForPixel: helpers.noop,\n\n                // Used for tick location, should\n                getPixelForTick: function (index, includeOffset) {\n                    if (this.isHorizontal()) {\n                        var innerWidth = this.width - (this.paddingLeft + this.paddingRight);\n                        var tickWidth = innerWidth / Math.max((this.ticks.length - ((this.options.gridLines.offsetGridLines) ? 0 : 1)), 1);\n                        var pixel = (tickWidth * index) + this.paddingLeft;\n\n                        if (includeOffset) {\n                            pixel += tickWidth / 2;\n                        }\n\n                        var finalVal = this.left + Math.round(pixel);\n                        finalVal += this.isFullWidth() ? this.margins.left : 0;\n                        return finalVal;\n                    } else {\n                        var innerHeight = this.height - (this.paddingTop + this.paddingBottom);\n                        return this.top + (index * (innerHeight / (this.ticks.length - 1)));\n                    }\n                },\n\n                // Utility for getting the pixel location of a percentage of scale\n                getPixelForDecimal: function (decimal /*, includeOffset*/) {\n                    if (this.isHorizontal()) {\n                        var innerWidth = this.width - (this.paddingLeft + this.paddingRight);\n                        var valueOffset = (innerWidth * decimal) + this.paddingLeft;\n\n                        var finalVal = this.left + Math.round(valueOffset);\n                        finalVal += this.isFullWidth() ? this.margins.left : 0;\n                        return finalVal;\n                    } else {\n                        return this.top + (decimal * this.height);\n                    }\n                },\n\n                // Actualy draw the scale on the canvas\n                // @param {rectangle} chartArea : the area of the chart to draw full grid lines on\n                draw: function (chartArea) {\n                    if (this.options.display) {\n\n                        var setContextLineSettings;\n                        var isRotated = this.labelRotation !== 0;\n                        var skipRatio;\n                        var scaleLabelX;\n                        var scaleLabelY;\n                        var useAutoskipper = this.options.ticks.autoSkip;\n\n\n                        // figure out the maximum number of gridlines to show\n                        var maxTicks;\n\n                        if (this.options.ticks.maxTicksLimit) {\n                            maxTicks = this.options.ticks.maxTicksLimit;\n                        }\n\n                        var tickFontColor = helpers.getValueOrDefault(this.options.ticks.fontColor, Chart.defaults.global.defaultFontColor);\n                        var tickFontSize = helpers.getValueOrDefault(this.options.ticks.fontSize, Chart.defaults.global.defaultFontSize);\n                        var tickFontStyle = helpers.getValueOrDefault(this.options.ticks.fontStyle, Chart.defaults.global.defaultFontStyle);\n                        var tickFontFamily = helpers.getValueOrDefault(this.options.ticks.fontFamily, Chart.defaults.global.defaultFontFamily);\n                        var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);\n                        var tl = this.options.gridLines.tickMarkLength;\n\n                        var scaleLabelFontColor = helpers.getValueOrDefault(this.options.scaleLabel.fontColor, Chart.defaults.global.defaultFontColor);\n                        var scaleLabelFontSize = helpers.getValueOrDefault(this.options.scaleLabel.fontSize, Chart.defaults.global.defaultFontSize);\n                        var scaleLabelFontStyle = helpers.getValueOrDefault(this.options.scaleLabel.fontStyle, Chart.defaults.global.defaultFontStyle);\n                        var scaleLabelFontFamily = helpers.getValueOrDefault(this.options.scaleLabel.fontFamily, Chart.defaults.global.defaultFontFamily);\n                        var scaleLabelFont = helpers.fontString(scaleLabelFontSize, scaleLabelFontStyle, scaleLabelFontFamily);\n\n                        var cosRotation = Math.cos(helpers.toRadians(this.labelRotation));\n                        var sinRotation = Math.sin(helpers.toRadians(this.labelRotation));\n                        var longestRotatedLabel = this.longestLabelWidth * cosRotation;\n                        var rotatedLabelHeight = tickFontSize * sinRotation;\n\n                        // Make sure we draw text in the correct color and font\n                        this.ctx.fillStyle = tickFontColor;\n\n                        if (this.isHorizontal()) {\n                            setContextLineSettings = true;\n                            var yTickStart = this.options.position === \"bottom\" ? this.top : this.bottom - tl;\n                            var yTickEnd = this.options.position === \"bottom\" ? this.top + tl : this.bottom;\n                            skipRatio = false;\n\n                            if (((longestRotatedLabel / 2) + this.options.ticks.autoSkipPadding) * this.ticks.length > (this.width - (this.paddingLeft + this.paddingRight))) {\n                                skipRatio = 1 + Math.floor((((longestRotatedLabel / 2) + this.options.ticks.autoSkipPadding) * this.ticks.length) / (this.width - (this.paddingLeft + this.paddingRight)));\n                            }\n\n                            // if they defined a max number of ticks,\n                            // increase skipRatio until that number is met\n                            if (maxTicks && this.ticks.length > maxTicks) {\n                                while (!skipRatio || this.ticks.length / (skipRatio || 1) > maxTicks) {\n                                    if (!skipRatio) {\n                                        skipRatio = 1;\n                                    }\n                                    skipRatio += 1;\n                                }\n                            }\n\n                            if (!useAutoskipper) {\n                                skipRatio = false;\n                            }\n\n                            helpers.each(this.ticks, function (label, index) {\n                                // Blank ticks\n                                var isLastTick = this.ticks.length === index + 1;\n\n                                // Since we always show the last tick,we need may need to hide the last shown one before\n                                var shouldSkip = (skipRatio > 1 && index % skipRatio > 0) || (index % skipRatio === 0 && index + skipRatio > this.ticks.length);\n                                if (shouldSkip && !isLastTick || (label === undefined || label === null)) {\n                                    return;\n                                }\n                                var xLineValue = this.getPixelForTick(index); // xvalues for grid lines\n                                var xLabelValue = this.getPixelForTick(index, this.options.gridLines.offsetGridLines); // x values for ticks (need to consider offsetLabel option)\n\n                                if (this.options.gridLines.display) {\n                                    if (index === (typeof this.zeroLineIndex !== 'undefined' ? this.zeroLineIndex : 0)) {\n                                        // Draw the first index specially\n                                        this.ctx.lineWidth = this.options.gridLines.zeroLineWidth;\n                                        this.ctx.strokeStyle = this.options.gridLines.zeroLineColor;\n                                        setContextLineSettings = true; // reset next time\n                                    } else if (setContextLineSettings) {\n                                        this.ctx.lineWidth = this.options.gridLines.lineWidth;\n                                        this.ctx.strokeStyle = this.options.gridLines.color;\n                                        setContextLineSettings = false;\n                                    }\n\n                                    xLineValue += helpers.aliasPixel(this.ctx.lineWidth);\n\n                                    // Draw the label area\n                                    this.ctx.beginPath();\n\n                                    if (this.options.gridLines.drawTicks) {\n                                        this.ctx.moveTo(xLineValue, yTickStart);\n                                        this.ctx.lineTo(xLineValue, yTickEnd);\n                                    }\n\n                                    // Draw the chart area\n                                    if (this.options.gridLines.drawOnChartArea) {\n                                        this.ctx.moveTo(xLineValue, chartArea.top);\n                                        this.ctx.lineTo(xLineValue, chartArea.bottom);\n                                    }\n\n                                    // Need to stroke in the loop because we are potentially changing line widths & colours\n                                    this.ctx.stroke();\n                                }\n\n                                if (this.options.ticks.display) {\n                                    this.ctx.save();\n                                    this.ctx.translate(xLabelValue, (isRotated) ? this.top + 12 : this.options.position === \"top\" ? this.bottom - tl : this.top + tl);\n                                    this.ctx.rotate(helpers.toRadians(this.labelRotation) * -1);\n                                    this.ctx.font = tickLabelFont;\n                                    this.ctx.textAlign = (isRotated) ? \"right\" : \"center\";\n                                    this.ctx.textBaseline = (isRotated) ? \"middle\" : this.options.position === \"top\" ? \"bottom\" : \"top\";\n                                    this.ctx.fillText(label, 0, 0);\n                                    this.ctx.restore();\n                                }\n                            }, this);\n\n                            if (this.options.scaleLabel.display) {\n                                // Draw the scale label\n                                this.ctx.textAlign = \"center\";\n                                this.ctx.textBaseline = 'middle';\n                                this.ctx.fillStyle = scaleLabelFontColor; // render in correct colour\n                                this.ctx.font = scaleLabelFont;\n\n                                scaleLabelX = this.left + ((this.right - this.left) / 2); // midpoint of the width\n                                scaleLabelY = this.options.position === 'bottom' ? this.bottom - (scaleLabelFontSize / 2) : this.top + (scaleLabelFontSize / 2);\n\n                                this.ctx.fillText(this.options.scaleLabel.labelString, scaleLabelX, scaleLabelY);\n                            }\n\n                        } else {\n                            setContextLineSettings = true;\n                            var xTickStart = this.options.position === \"right\" ? this.left : this.right - 5;\n                            var xTickEnd = this.options.position === \"right\" ? this.left + 5 : this.right;\n\n                            helpers.each(this.ticks, function (label, index) {\n                                // If the callback returned a null or undefined value, do not draw this line\n                                if (label === undefined || label === null) {\n                                    return;\n                                }\n\n                                var yLineValue = this.getPixelForTick(index); // xvalues for grid lines\n\n                                if (this.options.gridLines.display) {\n                                    if (index === (typeof this.zeroLineIndex !== 'undefined' ? this.zeroLineIndex : 0)) {\n                                        // Draw the first index specially\n                                        this.ctx.lineWidth = this.options.gridLines.zeroLineWidth;\n                                        this.ctx.strokeStyle = this.options.gridLines.zeroLineColor;\n                                        setContextLineSettings = true; // reset next time\n                                    } else if (setContextLineSettings) {\n                                        this.ctx.lineWidth = this.options.gridLines.lineWidth;\n                                        this.ctx.strokeStyle = this.options.gridLines.color;\n                                        setContextLineSettings = false;\n                                    }\n\n                                    yLineValue += helpers.aliasPixel(this.ctx.lineWidth);\n\n                                    // Draw the label area\n                                    this.ctx.beginPath();\n\n                                    if (this.options.gridLines.drawTicks) {\n                                        this.ctx.moveTo(xTickStart, yLineValue);\n                                        this.ctx.lineTo(xTickEnd, yLineValue);\n                                    }\n\n                                    // Draw the chart area\n                                    if (this.options.gridLines.drawOnChartArea) {\n                                        this.ctx.moveTo(chartArea.left, yLineValue);\n                                        this.ctx.lineTo(chartArea.right, yLineValue);\n                                    }\n\n                                    // Need to stroke in the loop because we are potentially changing line widths & colours\n                                    this.ctx.stroke();\n                                }\n\n                                if (this.options.ticks.display) {\n                                    var xLabelValue;\n                                    var yLabelValue = this.getPixelForTick(index, this.options.gridLines.offsetGridLines); // x values for ticks (need to consider offsetLabel option)\n\n                                    this.ctx.save();\n\n                                    if (this.options.position === \"left\") {\n                                        if (this.options.ticks.mirror) {\n                                            xLabelValue = this.right + this.options.ticks.padding;\n                                            this.ctx.textAlign = \"left\";\n                                        } else {\n                                            xLabelValue = this.right - this.options.ticks.padding;\n                                            this.ctx.textAlign = \"right\";\n                                        }\n                                    } else {\n                                        // right side\n                                        if (this.options.ticks.mirror) {\n                                            xLabelValue = this.left - this.options.ticks.padding;\n                                            this.ctx.textAlign = \"right\";\n                                        } else {\n                                            xLabelValue = this.left + this.options.ticks.padding;\n                                            this.ctx.textAlign = \"left\";\n                                        }\n                                    }\n\n                                    this.ctx.translate(xLabelValue, yLabelValue);\n                                    this.ctx.rotate(helpers.toRadians(this.labelRotation) * -1);\n                                    this.ctx.font = tickLabelFont;\n                                    this.ctx.textBaseline = \"middle\";\n                                    this.ctx.fillText(label, 0, 0);\n                                    this.ctx.restore();\n                                }\n                            }, this);\n\n                            if (this.options.scaleLabel.display) {\n                                // Draw the scale label\n                                scaleLabelX = this.options.position === 'left' ? this.left + (scaleLabelFontSize / 2) : this.right - (scaleLabelFontSize / 2);\n                                scaleLabelY = this.top + ((this.bottom - this.top) / 2);\n                                var rotation = this.options.position === 'left' ? -0.5 * Math.PI : 0.5 * Math.PI;\n\n                                this.ctx.save();\n                                this.ctx.translate(scaleLabelX, scaleLabelY);\n                                this.ctx.rotate(rotation);\n                                this.ctx.textAlign = \"center\";\n                                this.ctx.fillStyle = scaleLabelFontColor; // render in correct colour\n                                this.ctx.font = scaleLabelFont;\n                                this.ctx.textBaseline = 'middle';\n                                this.ctx.fillText(this.options.scaleLabel.labelString, 0, 0);\n                                this.ctx.restore();\n                            }\n                        }\n\n                        // Draw the line at the edge of the axis\n                        this.ctx.lineWidth = this.options.gridLines.lineWidth;\n                        this.ctx.strokeStyle = this.options.gridLines.color;\n                        var x1 = this.left,\n                            x2 = this.right,\n                            y1 = this.top,\n                            y2 = this.bottom;\n\n                        if (this.isHorizontal()) {\n                            y1 = y2 = this.options.position === 'top' ? this.bottom : this.top;\n                            y1 += helpers.aliasPixel(this.ctx.lineWidth);\n                            y2 += helpers.aliasPixel(this.ctx.lineWidth);\n                        } else {\n                            x1 = x2 = this.options.position === 'left' ? this.right : this.left;\n                            x1 += helpers.aliasPixel(this.ctx.lineWidth);\n                            x2 += helpers.aliasPixel(this.ctx.lineWidth);\n                        }\n\n                        this.ctx.beginPath();\n                        this.ctx.moveTo(x1, y1);\n                        this.ctx.lineTo(x2, y2);\n                        this.ctx.stroke();\n                    }\n                }\n            });\n        };\n\n    }, {}], 31: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.scaleService = {\n                // Scale registration object. Extensions can register new scale types (such as log or DB scales) and then\n                // use the new chart options to grab the correct scale\n                constructors: {},\n                // Use a registration function so that we can move to an ES6 map when we no longer need to support\n                // old browsers\n\n                // Scale config defaults\n                defaults: {},\n                registerScaleType: function (type, scaleConstructor, defaults) {\n                    this.constructors[type] = scaleConstructor;\n                    this.defaults[type] = helpers.clone(defaults);\n                },\n                getScaleConstructor: function (type) {\n                    return this.constructors.hasOwnProperty(type) ? this.constructors[type] : undefined;\n                },\n                getScaleDefaults: function (type) {\n                    // Return the scale defaults merged with the global settings so that we always use the latest ones\n                    return this.defaults.hasOwnProperty(type) ? helpers.scaleMerge(Chart.defaults.scale, this.defaults[type]) : {};\n                },\n                updateScaleDefaults: function (type, additions) {\n                    var defaults = this.defaults;\n                    if (defaults.hasOwnProperty(type)) {\n                        defaults[type] = helpers.extend(defaults[type], additions);\n                    }\n                },\n                addScalesToLayout: function (chartInstance) {\n                    // Adds each scale to the chart.boxes array to be sized accordingly\n                    helpers.each(chartInstance.scales, function (scale) {\n                        Chart.layoutService.addBox(chartInstance, scale);\n                    });\n                }\n            };\n        };\n    }, {}], 32: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.global.title = {\n                display: false,\n                position: 'top',\n                fullWidth: true, // marks that this box should take the full width of the canvas (pushing down other boxes)\n\n                fontStyle: 'bold',\n                padding: 10,\n\n                // actual title\n                text: ''\n            };\n\n            var noop = helpers.noop;\n            Chart.Title = Chart.Element.extend({\n\n                initialize: function (config) {\n                    helpers.extend(this, config);\n                    this.options = helpers.configMerge(Chart.defaults.global.title, config.options);\n\n                    // Contains hit boxes for each dataset (in dataset order)\n                    this.legendHitBoxes = [];\n                },\n\n                // These methods are ordered by lifecyle. Utilities then follow.\n\n                beforeUpdate: noop,\n                update: function (maxWidth, maxHeight, margins) {\n\n                    // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)\n                    this.beforeUpdate();\n\n                    // Absorb the master measurements\n                    this.maxWidth = maxWidth;\n                    this.maxHeight = maxHeight;\n                    this.margins = margins;\n\n                    // Dimensions\n                    this.beforeSetDimensions();\n                    this.setDimensions();\n                    this.afterSetDimensions();\n                    // Labels\n                    this.beforeBuildLabels();\n                    this.buildLabels();\n                    this.afterBuildLabels();\n\n                    // Fit\n                    this.beforeFit();\n                    this.fit();\n                    this.afterFit();\n                    //\n                    this.afterUpdate();\n\n                    return this.minSize;\n\n                },\n                afterUpdate: noop,\n\n                //\n\n                beforeSetDimensions: noop,\n                setDimensions: function () {\n                    // Set the unconstrained dimension before label rotation\n                    if (this.isHorizontal()) {\n                        // Reset position before calculating rotation\n                        this.width = this.maxWidth;\n                        this.left = 0;\n                        this.right = this.width;\n                    } else {\n                        this.height = this.maxHeight;\n\n                        // Reset position before calculating rotation\n                        this.top = 0;\n                        this.bottom = this.height;\n                    }\n\n                    // Reset padding\n                    this.paddingLeft = 0;\n                    this.paddingTop = 0;\n                    this.paddingRight = 0;\n                    this.paddingBottom = 0;\n\n                    // Reset minSize\n                    this.minSize = {\n                        width: 0,\n                        height: 0\n                    };\n                },\n                afterSetDimensions: noop,\n\n                //\n\n                beforeBuildLabels: noop,\n                buildLabels: noop,\n                afterBuildLabels: noop,\n\n                //\n\n                beforeFit: noop,\n                fit: function () {\n\n                    var ctx = this.ctx,\n                        valueOrDefault = helpers.getValueOrDefault,\n                        opts = this.options,\n                        globalDefaults = Chart.defaults.global,\n                        display = opts.display,\n                        fontSize = valueOrDefault(opts.fontSize, globalDefaults.defaultFontSize),\n                        minSize = this.minSize;\n\n                    if (this.isHorizontal()) {\n                        minSize.width = this.maxWidth; // fill all the width\n                        minSize.height = display ? fontSize + (opts.padding * 2) : 0;\n                    } else {\n                        minSize.width = display ? fontSize + (opts.padding * 2) : 0;\n                        minSize.height = this.maxHeight; // fill all the height\n                    }\n\n                    this.width = minSize.width;\n                    this.height = minSize.height;\n\n                },\n                afterFit: noop,\n\n                // Shared Methods\n                isHorizontal: function () {\n                    var pos = this.options.position;\n                    return pos === \"top\" || pos === \"bottom\";\n                },\n\n                // Actualy draw the title block on the canvas\n                draw: function () {\n                    var ctx = this.ctx,\n                        valueOrDefault = helpers.getValueOrDefault,\n                        opts = this.options,\n                        globalDefaults = Chart.defaults.global;\n\n                    if (opts.display) {\n                        var fontSize = valueOrDefault(opts.fontSize, globalDefaults.defaultFontSize),\n                            fontStyle = valueOrDefault(opts.fontStyle, globalDefaults.defaultFontStyle),\n                            fontFamily = valueOrDefault(opts.fontFamily, globalDefaults.defaultFontFamily),\n                            titleFont = helpers.fontString(fontSize, fontStyle, fontFamily),\n                            rotation = 0,\n                            titleX,\n                            titleY;\n\n                        ctx.fillStyle = valueOrDefault(opts.fontColor, globalDefaults.defaultFontColor); // render in correct colour\n                        ctx.font = titleFont;\n\n                        // Horizontal\n                        if (this.isHorizontal()) {\n                            titleX = this.left + ((this.right - this.left) / 2); // midpoint of the width\n                            titleY = this.top + ((this.bottom - this.top) / 2); // midpoint of the height\n                        } else {\n                            titleX = opts.position === 'left' ? this.left + (fontSize / 2) : this.right - (fontSize / 2);\n                            titleY = this.top + ((this.bottom - this.top) / 2);\n                            rotation = Math.PI * (opts.position === 'left' ? -0.5 : 0.5);\n                        }\n\n                        ctx.save();\n                        ctx.translate(titleX, titleY);\n                        ctx.rotate(rotation);\n                        ctx.textAlign = 'center';\n                        ctx.textBaseline = 'middle';\n                        ctx.fillText(opts.text, 0, 0);\n                        ctx.restore();\n                    }\n                }\n            });\n        };\n    }, {}], 33: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.global.tooltips = {\n                enabled: true,\n                custom: null,\n                mode: 'single',\n                backgroundColor: \"rgba(0,0,0,0.8)\",\n                titleFontStyle: \"bold\",\n                titleSpacing: 2,\n                titleMarginBottom: 6,\n                titleColor: \"#fff\",\n                titleAlign: \"left\",\n                bodySpacing: 2,\n                bodyColor: \"#fff\",\n                bodyAlign: \"left\",\n                footerFontStyle: \"bold\",\n                footerSpacing: 2,\n                footerMarginTop: 6,\n                footerColor: \"#fff\",\n                footerAlign: \"left\",\n                yPadding: 6,\n                xPadding: 6,\n                yAlign: 'center',\n                xAlign: 'center',\n                caretSize: 5,\n                cornerRadius: 6,\n                multiKeyBackground: '#fff',\n                callbacks: {\n                    // Args are: (tooltipItems, data)\n                    beforeTitle: helpers.noop,\n                    title: function (tooltipItems, data) {\n                        // Pick first xLabel for now\n                        var title = '';\n\n                        if (tooltipItems.length > 0) {\n                            if (tooltipItems[0].xLabel) {\n                                title = tooltipItems[0].xLabel;\n                            } else if (data.labels.length > 0 && tooltipItems[0].index < data.labels.length) {\n                                title = data.labels[tooltipItems[0].index];\n                            }\n                        }\n\n                        return title;\n                    },\n                    afterTitle: helpers.noop,\n\n                    // Args are: (tooltipItems, data)\n                    beforeBody: helpers.noop,\n\n                    // Args are: (tooltipItem, data)\n                    beforeLabel: helpers.noop,\n                    label: function (tooltipItem, data) {\n                        var datasetLabel = data.datasets[tooltipItem.datasetIndex].label || '';\n                        return datasetLabel + ': ' + tooltipItem.yLabel;\n                    },\n                    afterLabel: helpers.noop,\n\n                    // Args are: (tooltipItems, data)\n                    afterBody: helpers.noop,\n\n                    // Args are: (tooltipItems, data)\n                    beforeFooter: helpers.noop,\n                    footer: helpers.noop,\n                    afterFooter: helpers.noop\n                }\n            };\n\n            // Helper to push or concat based on if the 2nd parameter is an array or not\n            function pushOrConcat(base, toPush) {\n                if (toPush) {\n                    if (helpers.isArray(toPush)) {\n                        base = base.concat(toPush);\n                    } else {\n                        base.push(toPush);\n                    }\n                }\n\n                return base;\n            }\n\n            Chart.Tooltip = Chart.Element.extend({\n                initialize: function () {\n                    var options = this._options;\n                    helpers.extend(this, {\n                        _model: {\n                            // Positioning\n                            xPadding: options.tooltips.xPadding,\n                            yPadding: options.tooltips.yPadding,\n                            xAlign: options.tooltips.yAlign,\n                            yAlign: options.tooltips.xAlign,\n\n                            // Body\n                            bodyColor: options.tooltips.bodyColor,\n                            _bodyFontFamily: helpers.getValueOrDefault(options.tooltips.bodyFontFamily, Chart.defaults.global.defaultFontFamily),\n                            _bodyFontStyle: helpers.getValueOrDefault(options.tooltips.bodyFontStyle, Chart.defaults.global.defaultFontStyle),\n                            _bodyAlign: options.tooltips.bodyAlign,\n                            bodyFontSize: helpers.getValueOrDefault(options.tooltips.bodyFontSize, Chart.defaults.global.defaultFontSize),\n                            bodySpacing: options.tooltips.bodySpacing,\n\n                            // Title\n                            titleColor: options.tooltips.titleColor,\n                            _titleFontFamily: helpers.getValueOrDefault(options.tooltips.titleFontFamily, Chart.defaults.global.defaultFontFamily),\n                            _titleFontStyle: helpers.getValueOrDefault(options.tooltips.titleFontStyle, Chart.defaults.global.defaultFontStyle),\n                            titleFontSize: helpers.getValueOrDefault(options.tooltips.titleFontSize, Chart.defaults.global.defaultFontSize),\n                            _titleAlign: options.tooltips.titleAlign,\n                            titleSpacing: options.tooltips.titleSpacing,\n                            titleMarginBottom: options.tooltips.titleMarginBottom,\n\n                            // Footer\n                            footerColor: options.tooltips.footerColor,\n                            _footerFontFamily: helpers.getValueOrDefault(options.tooltips.footerFontFamily, Chart.defaults.global.defaultFontFamily),\n                            _footerFontStyle: helpers.getValueOrDefault(options.tooltips.footerFontStyle, Chart.defaults.global.defaultFontStyle),\n                            footerFontSize: helpers.getValueOrDefault(options.tooltips.footerFontSize, Chart.defaults.global.defaultFontSize),\n                            _footerAlign: options.tooltips.footerAlign,\n                            footerSpacing: options.tooltips.footerSpacing,\n                            footerMarginTop: options.tooltips.footerMarginTop,\n\n                            // Appearance\n                            caretSize: options.tooltips.caretSize,\n                            cornerRadius: options.tooltips.cornerRadius,\n                            backgroundColor: options.tooltips.backgroundColor,\n                            opacity: 0,\n                            legendColorBackground: options.tooltips.multiKeyBackground\n                        }\n                    });\n                },\n\n                // Get the title\n                // Args are: (tooltipItem, data)\n                getTitle: function () {\n                    var beforeTitle = this._options.tooltips.callbacks.beforeTitle.apply(this, arguments),\n                        title = this._options.tooltips.callbacks.title.apply(this, arguments),\n                        afterTitle = this._options.tooltips.callbacks.afterTitle.apply(this, arguments);\n\n                    var lines = [];\n                    lines = pushOrConcat(lines, beforeTitle);\n                    lines = pushOrConcat(lines, title);\n                    lines = pushOrConcat(lines, afterTitle);\n\n                    return lines;\n                },\n\n                // Args are: (tooltipItem, data)\n                getBeforeBody: function () {\n                    var lines = this._options.tooltips.callbacks.beforeBody.apply(this, arguments);\n                    return helpers.isArray(lines) ? lines : lines !== undefined ? [lines] : [];\n                },\n\n                // Args are: (tooltipItem, data)\n                getBody: function (tooltipItems, data) {\n                    var lines = [];\n\n                    helpers.each(tooltipItems, function (bodyItem) {\n                        helpers.pushAllIfDefined(this._options.tooltips.callbacks.beforeLabel.call(this, bodyItem, data), lines);\n                        helpers.pushAllIfDefined(this._options.tooltips.callbacks.label.call(this, bodyItem, data), lines);\n                        helpers.pushAllIfDefined(this._options.tooltips.callbacks.afterLabel.call(this, bodyItem, data), lines);\n                    }, this);\n\n                    return lines;\n                },\n\n                // Args are: (tooltipItem, data)\n                getAfterBody: function () {\n                    var lines = this._options.tooltips.callbacks.afterBody.apply(this, arguments);\n                    return helpers.isArray(lines) ? lines : lines !== undefined ? [lines] : [];\n                },\n\n                // Get the footer and beforeFooter and afterFooter lines\n                // Args are: (tooltipItem, data)\n                getFooter: function () {\n                    var beforeFooter = this._options.tooltips.callbacks.beforeFooter.apply(this, arguments);\n                    var footer = this._options.tooltips.callbacks.footer.apply(this, arguments);\n                    var afterFooter = this._options.tooltips.callbacks.afterFooter.apply(this, arguments);\n\n                    var lines = [];\n                    lines = pushOrConcat(lines, beforeFooter);\n                    lines = pushOrConcat(lines, footer);\n                    lines = pushOrConcat(lines, afterFooter);\n\n                    return lines;\n                },\n\n                getAveragePosition: function (elements) {\n\n                    if (!elements.length) {\n                        return false;\n                    }\n\n                    var xPositions = [];\n                    var yPositions = [];\n\n                    helpers.each(elements, function (el) {\n                        if (el) {\n                            var pos = el.tooltipPosition();\n                            xPositions.push(pos.x);\n                            yPositions.push(pos.y);\n                        }\n                    });\n\n                    var x = 0,\n                        y = 0;\n                    for (var i = 0; i < xPositions.length; i++) {\n                        x += xPositions[i];\n                        y += yPositions[i];\n                    }\n\n                    return {\n                        x: Math.round(x / xPositions.length),\n                        y: Math.round(y / xPositions.length)\n                    };\n\n                },\n\n                update: function (changed) {\n                    if (this._active.length) {\n                        this._model.opacity = 1;\n\n                        var element = this._active[0],\n                            labelColors = [],\n                            tooltipPosition;\n\n                        var tooltipItems = [];\n\n                        if (this._options.tooltips.mode === 'single') {\n                            var yScale = element._yScale || element._scale; // handle radar || polarArea charts\n                            tooltipItems.push({\n                                xLabel: element._xScale ? element._xScale.getLabelForIndex(element._index, element._datasetIndex) : '',\n                                yLabel: yScale ? yScale.getLabelForIndex(element._index, element._datasetIndex) : '',\n                                index: element._index,\n                                datasetIndex: element._datasetIndex\n                            });\n                            tooltipPosition = this.getAveragePosition(this._active);\n                        } else {\n                            helpers.each(this._data.datasets, function (dataset, datasetIndex) {\n                                if (!this._chartInstance.isDatasetVisible(datasetIndex)) {\n                                    return;\n                                }\n\n                                var meta = this._chartInstance.getDatasetMeta(datasetIndex);\n                                var currentElement = meta.data[element._index];\n                                if (currentElement) {\n                                    var yScale = element._yScale || element._scale; // handle radar || polarArea charts\n\n                                    tooltipItems.push({\n                                        xLabel: currentElement._xScale ? currentElement._xScale.getLabelForIndex(currentElement._index, currentElement._datasetIndex) : '',\n                                        yLabel: yScale ? yScale.getLabelForIndex(currentElement._index, currentElement._datasetIndex) : '',\n                                        index: element._index,\n                                        datasetIndex: datasetIndex\n                                    });\n                                }\n                            }, this);\n\n                            helpers.each(this._active, function (active) {\n                                if (active) {\n                                    labelColors.push({\n                                        borderColor: active._view.borderColor,\n                                        backgroundColor: active._view.backgroundColor\n                                    });\n                                }\n                            }, null);\n\n                            tooltipPosition = this.getAveragePosition(this._active);\n                        }\n\n                        // Build the Text Lines\n                        helpers.extend(this._model, {\n                            title: this.getTitle(tooltipItems, this._data),\n                            beforeBody: this.getBeforeBody(tooltipItems, this._data),\n                            body: this.getBody(tooltipItems, this._data),\n                            afterBody: this.getAfterBody(tooltipItems, this._data),\n                            footer: this.getFooter(tooltipItems, this._data)\n                        });\n\n                        helpers.extend(this._model, {\n                            x: Math.round(tooltipPosition.x),\n                            y: Math.round(tooltipPosition.y),\n                            caretPadding: helpers.getValueOrDefault(tooltipPosition.padding, 2),\n                            labelColors: labelColors\n                        });\n\n                        // We need to determine alignment of\n                        var tooltipSize = this.getTooltipSize(this._model);\n                        this.determineAlignment(tooltipSize); // Smart Tooltip placement to stay on the canvas\n\n                        helpers.extend(this._model, this.getBackgroundPoint(this._model, tooltipSize));\n                    } else {\n                        this._model.opacity = 0;\n                    }\n\n                    if (changed && this._options.tooltips.custom) {\n                        this._options.tooltips.custom.call(this, this._model);\n                    }\n\n                    return this;\n                },\n                getTooltipSize: function getTooltipSize(vm) {\n                    var ctx = this._chart.ctx;\n\n                    var size = {\n                        height: vm.yPadding * 2, // Tooltip Padding\n                        width: 0\n                    };\n                    var combinedBodyLength = vm.body.length + vm.beforeBody.length + vm.afterBody.length;\n\n                    size.height += vm.title.length * vm.titleFontSize; // Title Lines\n                    size.height += (vm.title.length - 1) * vm.titleSpacing; // Title Line Spacing\n                    size.height += vm.title.length ? vm.titleMarginBottom : 0; // Title's bottom Margin\n                    size.height += combinedBodyLength * vm.bodyFontSize; // Body Lines\n                    size.height += combinedBodyLength ? (combinedBodyLength - 1) * vm.bodySpacing : 0; // Body Line Spacing\n                    size.height += vm.footer.length ? vm.footerMarginTop : 0; // Footer Margin\n                    size.height += vm.footer.length * (vm.footerFontSize); // Footer Lines\n                    size.height += vm.footer.length ? (vm.footer.length - 1) * vm.footerSpacing : 0; // Footer Line Spacing\n\n                    // Width\n                    ctx.font = helpers.fontString(vm.titleFontSize, vm._titleFontStyle, vm._titleFontFamily);\n                    helpers.each(vm.title, function (line) {\n                        size.width = Math.max(size.width, ctx.measureText(line).width);\n                    });\n\n                    ctx.font = helpers.fontString(vm.bodyFontSize, vm._bodyFontStyle, vm._bodyFontFamily);\n                    helpers.each(vm.beforeBody.concat(vm.afterBody), function (line) {\n                        size.width = Math.max(size.width, ctx.measureText(line).width);\n                    });\n                    helpers.each(vm.body, function (line) {\n                        size.width = Math.max(size.width, ctx.measureText(line).width + (this._options.tooltips.mode !== 'single' ? (vm.bodyFontSize + 2) : 0));\n                    }, this);\n\n                    ctx.font = helpers.fontString(vm.footerFontSize, vm._footerFontStyle, vm._footerFontFamily);\n                    helpers.each(vm.footer, function (line) {\n                        size.width = Math.max(size.width, ctx.measureText(line).width);\n                    });\n                    size.width += 2 * vm.xPadding;\n\n                    return size;\n                },\n                determineAlignment: function determineAlignment(size) {\n                    if (this._model.y < size.height) {\n                        this._model.yAlign = 'top';\n                    } else if (this._model.y > (this._chart.height - size.height)) {\n                        this._model.yAlign = 'bottom';\n                    }\n\n                    var lf, rf; // functions to determine left, right alignment\n                    var olf, orf; // functions to determine if left/right alignment causes tooltip to go outside chart\n                    var yf; // function to get the y alignment if the tooltip goes outside of the left or right edges\n                    var _this = this;\n                    var midX = (this._chartInstance.chartArea.left + this._chartInstance.chartArea.right) / 2;\n                    var midY = (this._chartInstance.chartArea.top + this._chartInstance.chartArea.bottom) / 2;\n\n                    if (this._model.yAlign === 'center') {\n                        lf = function (x) {\n                            return x <= midX;\n                        };\n                        rf = function (x) {\n                            return x > midX;\n                        };\n                    } else {\n                        lf = function (x) {\n                            return x <= (size.width / 2);\n                        };\n                        rf = function (x) {\n                            return x >= (_this._chart.width - (size.width / 2));\n                        };\n                    }\n\n                    olf = function (x) {\n                        return x + size.width > _this._chart.width;\n                    };\n                    orf = function (x) {\n                        return x - size.width < 0;\n                    };\n                    yf = function (y) {\n                        return y <= midY ? 'top' : 'bottom';\n                    };\n\n                    if (lf(this._model.x)) {\n                        this._model.xAlign = 'left';\n\n                        // Is tooltip too wide and goes over the right side of the chart.?\n                        if (olf(this._model.x)) {\n                            this._model.xAlign = 'center';\n                            this._model.yAlign = yf(this._model.y);\n                        }\n                    } else if (rf(this._model.x)) {\n                        this._model.xAlign = 'right';\n\n                        // Is tooltip too wide and goes outside left edge of canvas?\n                        if (orf(this._model.x)) {\n                            this._model.xAlign = 'center';\n                            this._model.yAlign = yf(this._model.y);\n                        }\n                    }\n                },\n                getBackgroundPoint: function getBackgroundPoint(vm, size) {\n                    // Background Position\n                    var pt = {\n                        x: vm.x,\n                        y: vm.y\n                    };\n\n                    if (vm.xAlign === 'right') {\n                        pt.x -= size.width;\n                    } else if (vm.xAlign === 'center') {\n                        pt.x -= (size.width / 2);\n                    }\n\n                    if (vm.yAlign === 'top') {\n                        pt.y += vm.caretPadding + vm.caretSize;\n                    } else if (vm.yAlign === 'bottom') {\n                        pt.y -= size.height + vm.caretPadding + vm.caretSize;\n                    } else {\n                        pt.y -= (size.height / 2);\n                    }\n\n                    if (vm.yAlign === 'center') {\n                        if (vm.xAlign === 'left') {\n                            pt.x += vm.caretPadding + vm.caretSize;\n                        } else if (vm.xAlign === 'right') {\n                            pt.x -= vm.caretPadding + vm.caretSize;\n                        }\n                    } else {\n                        if (vm.xAlign === 'left') {\n                            pt.x -= vm.cornerRadius + vm.caretPadding;\n                        } else if (vm.xAlign === 'right') {\n                            pt.x += vm.cornerRadius + vm.caretPadding;\n                        }\n                    }\n\n                    return pt;\n                },\n                drawCaret: function drawCaret(tooltipPoint, size, opacity, caretPadding) {\n                    var vm = this._view;\n                    var ctx = this._chart.ctx;\n                    var x1, x2, x3;\n                    var y1, y2, y3;\n\n                    if (vm.yAlign === 'center') {\n                        // Left or right side\n                        if (vm.xAlign === 'left') {\n                            x1 = tooltipPoint.x;\n                            x2 = x1 - vm.caretSize;\n                            x3 = x1;\n                        } else {\n                            x1 = tooltipPoint.x + size.width;\n                            x2 = x1 + vm.caretSize;\n                            x3 = x1;\n                        }\n\n                        y2 = tooltipPoint.y + (size.height / 2);\n                        y1 = y2 - vm.caretSize;\n                        y3 = y2 + vm.caretSize;\n                    } else {\n                        if (vm.xAlign === 'left') {\n                            x1 = tooltipPoint.x + vm.cornerRadius;\n                            x2 = x1 + vm.caretSize;\n                            x3 = x2 + vm.caretSize;\n                        } else if (vm.xAlign === 'right') {\n                            x1 = tooltipPoint.x + size.width - vm.cornerRadius;\n                            x2 = x1 - vm.caretSize;\n                            x3 = x2 - vm.caretSize;\n                        } else {\n                            x2 = tooltipPoint.x + (size.width / 2);\n                            x1 = x2 - vm.caretSize;\n                            x3 = x2 + vm.caretSize;\n                        }\n\n                        if (vm.yAlign === 'top') {\n                            y1 = tooltipPoint.y;\n                            y2 = y1 - vm.caretSize;\n                            y3 = y1;\n                        } else {\n                            y1 = tooltipPoint.y + size.height;\n                            y2 = y1 + vm.caretSize;\n                            y3 = y1;\n                        }\n                    }\n\n                    var bgColor = helpers.color(vm.backgroundColor);\n                    ctx.fillStyle = bgColor.alpha(opacity * bgColor.alpha()).rgbString();\n                    ctx.beginPath();\n                    ctx.moveTo(x1, y1);\n                    ctx.lineTo(x2, y2);\n                    ctx.lineTo(x3, y3);\n                    ctx.closePath();\n                    ctx.fill();\n                },\n                drawTitle: function drawTitle(pt, vm, ctx, opacity) {\n                    if (vm.title.length) {\n                        ctx.textAlign = vm._titleAlign;\n                        ctx.textBaseline = \"top\";\n\n                        var titleColor = helpers.color(vm.titleColor);\n                        ctx.fillStyle = titleColor.alpha(opacity * titleColor.alpha()).rgbString();\n                        ctx.font = helpers.fontString(vm.titleFontSize, vm._titleFontStyle, vm._titleFontFamily);\n\n                        helpers.each(vm.title, function (title, i) {\n                            ctx.fillText(title, pt.x, pt.y);\n                            pt.y += vm.titleFontSize + vm.titleSpacing; // Line Height and spacing\n\n                            if (i + 1 === vm.title.length) {\n                                pt.y += vm.titleMarginBottom - vm.titleSpacing; // If Last, add margin, remove spacing\n                            }\n                        });\n                    }\n                },\n                drawBody: function drawBody(pt, vm, ctx, opacity) {\n                    ctx.textAlign = vm._bodyAlign;\n                    ctx.textBaseline = \"top\";\n\n                    var bodyColor = helpers.color(vm.bodyColor);\n                    ctx.fillStyle = bodyColor.alpha(opacity * bodyColor.alpha()).rgbString();\n                    ctx.font = helpers.fontString(vm.bodyFontSize, vm._bodyFontStyle, vm._bodyFontFamily);\n\n                    // Before Body\n                    helpers.each(vm.beforeBody, function (beforeBody) {\n                        ctx.fillText(beforeBody, pt.x, pt.y);\n                        pt.y += vm.bodyFontSize + vm.bodySpacing;\n                    });\n\n                    helpers.each(vm.body, function (body, i) {\n                        // Draw Legend-like boxes if needed\n                        if (this._options.tooltips.mode !== 'single') {\n                            // Fill a white rect so that colours merge nicely if the opacity is < 1\n                            ctx.fillStyle = helpers.color(vm.legendColorBackground).alpha(opacity).rgbaString();\n                            ctx.fillRect(pt.x, pt.y, vm.bodyFontSize, vm.bodyFontSize);\n\n                            // Border\n                            ctx.strokeStyle = helpers.color(vm.labelColors[i].borderColor).alpha(opacity).rgbaString();\n                            ctx.strokeRect(pt.x, pt.y, vm.bodyFontSize, vm.bodyFontSize);\n\n                            // Inner square\n                            ctx.fillStyle = helpers.color(vm.labelColors[i].backgroundColor).alpha(opacity).rgbaString();\n                            ctx.fillRect(pt.x + 1, pt.y + 1, vm.bodyFontSize - 2, vm.bodyFontSize - 2);\n\n                            ctx.fillStyle = helpers.color(vm.bodyColor).alpha(opacity).rgbaString(); // Return fill style for text\n                        }\n\n                        // Body Line\n                        ctx.fillText(body, pt.x + (this._options.tooltips.mode !== 'single' ? (vm.bodyFontSize + 2) : 0), pt.y);\n\n                        pt.y += vm.bodyFontSize + vm.bodySpacing;\n                    }, this);\n\n                    // After Body\n                    helpers.each(vm.afterBody, function (afterBody) {\n                        ctx.fillText(afterBody, pt.x, pt.y);\n                        pt.y += vm.bodyFontSize;\n                    });\n\n                    pt.y -= vm.bodySpacing; // Remove last body spacing\n                },\n                drawFooter: function drawFooter(pt, vm, ctx, opacity) {\n                    if (vm.footer.length) {\n                        pt.y += vm.footerMarginTop;\n\n                        ctx.textAlign = vm._footerAlign;\n                        ctx.textBaseline = \"top\";\n\n                        var footerColor = helpers.color(vm.footerColor);\n                        ctx.fillStyle = footerColor.alpha(opacity * footerColor.alpha()).rgbString();\n                        ctx.font = helpers.fontString(vm.footerFontSize, vm._footerFontStyle, vm._footerFontFamily);\n\n                        helpers.each(vm.footer, function (footer) {\n                            ctx.fillText(footer, pt.x, pt.y);\n                            pt.y += vm.footerFontSize + vm.footerSpacing;\n                        });\n                    }\n                },\n                draw: function draw() {\n                    var ctx = this._chart.ctx;\n                    var vm = this._view;\n\n                    if (vm.opacity === 0) {\n                        return;\n                    }\n\n                    var caretPadding = vm.caretPadding;\n                    var tooltipSize = this.getTooltipSize(vm);\n                    var pt = {\n                        x: vm.x,\n                        y: vm.y\n                    };\n\n                    // IE11/Edge does not like very small opacities, so snap to 0\n                    var opacity = Math.abs(vm.opacity < 1e-3) ? 0 : vm.opacity;\n\n                    if (this._options.tooltips.enabled) {\n                        // Draw Background\n                        var bgColor = helpers.color(vm.backgroundColor);\n                        ctx.fillStyle = bgColor.alpha(opacity * bgColor.alpha()).rgbString();\n                        helpers.drawRoundedRectangle(ctx, pt.x, pt.y, tooltipSize.width, tooltipSize.height, vm.cornerRadius);\n                        ctx.fill();\n\n                        // Draw Caret\n                        this.drawCaret(pt, tooltipSize, opacity, caretPadding);\n\n                        // Draw Title, Body, and Footer\n                        pt.x += vm.xPadding;\n                        pt.y += vm.yPadding;\n\n                        // Titles\n                        this.drawTitle(pt, vm, ctx, opacity);\n\n                        // Body\n                        this.drawBody(pt, vm, ctx, opacity);\n\n                        // Footer\n                        this.drawFooter(pt, vm, ctx, opacity);\n                    }\n                }\n            });\n        };\n\n    }, {}], 34: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart, moment) {\n\n            var helpers = Chart.helpers,\n                globalOpts = Chart.defaults.global;\n\n            globalOpts.elements.arc = {\n                backgroundColor: globalOpts.defaultColor,\n                borderColor: \"#fff\",\n                borderWidth: 2\n            };\n\n            Chart.elements.Arc = Chart.Element.extend({\n                inLabelRange: function (mouseX) {\n                    var vm = this._view;\n\n                    if (vm) {\n                        return (Math.pow(mouseX - vm.x, 2) < Math.pow(vm.radius + vm.hoverRadius, 2));\n                    } else {\n                        return false;\n                    }\n                },\n                inRange: function (chartX, chartY) {\n                    var vm = this._view;\n\n                    if (vm) {\n                        var pointRelativePosition = helpers.getAngleFromPoint(vm, {\n                            x: chartX,\n                            y: chartY\n                        }),\n                            angle = pointRelativePosition.angle,\n                            distance = pointRelativePosition.distance;\n\n                        //Sanitise angle range\n                        var startAngle = vm.startAngle;\n                        var endAngle = vm.endAngle;\n                        while (endAngle < startAngle) {\n                            endAngle += 2.0 * Math.PI;\n                        }\n                        while (angle > endAngle) {\n                            angle -= 2.0 * Math.PI;\n                        }\n                        while (angle < startAngle) {\n                            angle += 2.0 * Math.PI;\n                        }\n\n                        //Check if within the range of the open/close angle\n                        var betweenAngles = (angle >= startAngle && angle <= endAngle),\n                            withinRadius = (distance >= vm.innerRadius && distance <= vm.outerRadius);\n\n                        return (betweenAngles && withinRadius);\n                    } else {\n                        return false;\n                    }\n                },\n                tooltipPosition: function () {\n                    var vm = this._view;\n\n                    var centreAngle = vm.startAngle + ((vm.endAngle - vm.startAngle) / 2),\n                        rangeFromCentre = (vm.outerRadius - vm.innerRadius) / 2 + vm.innerRadius;\n                    return {\n                        x: vm.x + (Math.cos(centreAngle) * rangeFromCentre),\n                        y: vm.y + (Math.sin(centreAngle) * rangeFromCentre)\n                    };\n                },\n                draw: function () {\n\n                    var ctx = this._chart.ctx,\n                        vm = this._view,\n                        sA = vm.startAngle,\n                        eA = vm.endAngle;\n\n                    ctx.beginPath();\n\n                    ctx.arc(vm.x, vm.y, vm.outerRadius, sA, eA);\n                    ctx.arc(vm.x, vm.y, vm.innerRadius, eA, sA, true);\n\n                    ctx.closePath();\n                    ctx.strokeStyle = vm.borderColor;\n                    ctx.lineWidth = vm.borderWidth;\n\n                    ctx.fillStyle = vm.backgroundColor;\n\n                    ctx.fill();\n                    ctx.lineJoin = 'bevel';\n\n                    if (vm.borderWidth) {\n                        ctx.stroke();\n                    }\n                }\n            });\n        };\n\n    }, {}], 35: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            Chart.defaults.global.elements.line = {\n                tension: 0.4,\n                backgroundColor: Chart.defaults.global.defaultColor,\n                borderWidth: 3,\n                borderColor: Chart.defaults.global.defaultColor,\n                borderCapStyle: 'butt',\n                borderDash: [],\n                borderDashOffset: 0.0,\n                borderJoinStyle: 'miter',\n                fill: true // do we fill in the area between the line and its base axis\n            };\n\n            Chart.elements.Line = Chart.Element.extend({\n                lineToNextPoint: function (previousPoint, point, nextPoint, skipHandler, previousSkipHandler) {\n                    var ctx = this._chart.ctx;\n\n                    if (point._view.skip) {\n                        skipHandler.call(this, previousPoint, point, nextPoint);\n                    } else if (previousPoint._view.skip) {\n                        previousSkipHandler.call(this, previousPoint, point, nextPoint);\n                    } else if (point._view.tension === 0) {\n                        ctx.lineTo(point._view.x, point._view.y);\n                    } else {\n                        // Line between points\n                        ctx.bezierCurveTo(\n                            previousPoint._view.controlPointNextX,\n                            previousPoint._view.controlPointNextY,\n                            point._view.controlPointPreviousX,\n                            point._view.controlPointPreviousY,\n                            point._view.x,\n                            point._view.y\n                        );\n                    }\n                },\n\n                draw: function () {\n                    var _this = this;\n\n                    var vm = this._view;\n                    var ctx = this._chart.ctx;\n                    var first = this._children[0];\n                    var last = this._children[this._children.length - 1];\n\n                    function loopBackToStart(drawLineToCenter) {\n                        if (!first._view.skip && !last._view.skip) {\n                            // Draw a bezier line from last to first\n                            ctx.bezierCurveTo(\n                                last._view.controlPointNextX,\n                                last._view.controlPointNextY,\n                                first._view.controlPointPreviousX,\n                                first._view.controlPointPreviousY,\n                                first._view.x,\n                                first._view.y\n                            );\n                        } else if (drawLineToCenter) {\n                            // Go to center\n                            ctx.lineTo(_this._view.scaleZero.x, _this._view.scaleZero.y);\n                        }\n                    }\n\n                    ctx.save();\n\n                    // If we had points and want to fill this line, do so.\n                    if (this._children.length > 0 && vm.fill) {\n                        // Draw the background first (so the border is always on top)\n                        ctx.beginPath();\n\n                        helpers.each(this._children, function (point, index) {\n                            var previous = helpers.previousItem(this._children, index);\n                            var next = helpers.nextItem(this._children, index);\n\n                            // First point moves to it's starting position no matter what\n                            if (index === 0) {\n                                if (this._loop) {\n                                    ctx.moveTo(vm.scaleZero.x, vm.scaleZero.y);\n                                } else {\n                                    ctx.moveTo(point._view.x, vm.scaleZero);\n                                }\n\n                                if (point._view.skip) {\n                                    if (!this._loop) {\n                                        ctx.moveTo(next._view.x, this._view.scaleZero);\n                                    }\n                                } else {\n                                    ctx.lineTo(point._view.x, point._view.y);\n                                }\n                            } else {\n                                this.lineToNextPoint(previous, point, next, function (previousPoint, point, nextPoint) {\n                                    if (this._loop) {\n                                        // Go to center\n                                        ctx.lineTo(this._view.scaleZero.x, this._view.scaleZero.y);\n                                    } else {\n                                        ctx.lineTo(previousPoint._view.x, this._view.scaleZero);\n                                        ctx.moveTo(nextPoint._view.x, this._view.scaleZero);\n                                    }\n                                }, function (previousPoint, point) {\n                                    // If we skipped the last point, draw a line to ourselves so that the fill is nice\n                                    ctx.lineTo(point._view.x, point._view.y);\n                                });\n                            }\n                        }, this);\n\n                        // For radial scales, loop back around to the first point\n                        if (this._loop) {\n                            loopBackToStart(true);\n                        } else {\n                            //Round off the line by going to the base of the chart, back to the start, then fill.\n                            ctx.lineTo(this._children[this._children.length - 1]._view.x, vm.scaleZero);\n                            ctx.lineTo(this._children[0]._view.x, vm.scaleZero);\n                        }\n\n                        ctx.fillStyle = vm.backgroundColor || Chart.defaults.global.defaultColor;\n                        ctx.closePath();\n                        ctx.fill();\n                    }\n\n                    // Now draw the line between all the points with any borders\n                    ctx.lineCap = vm.borderCapStyle || Chart.defaults.global.elements.line.borderCapStyle;\n\n                    // IE 9 and 10 do not support line dash\n                    if (ctx.setLineDash) {\n                        ctx.setLineDash(vm.borderDash || Chart.defaults.global.elements.line.borderDash);\n                    }\n\n                    ctx.lineDashOffset = vm.borderDashOffset || Chart.defaults.global.elements.line.borderDashOffset;\n                    ctx.lineJoin = vm.borderJoinStyle || Chart.defaults.global.elements.line.borderJoinStyle;\n                    ctx.lineWidth = vm.borderWidth || Chart.defaults.global.elements.line.borderWidth;\n                    ctx.strokeStyle = vm.borderColor || Chart.defaults.global.defaultColor;\n                    ctx.beginPath();\n\n                    helpers.each(this._children, function (point, index) {\n                        var previous = helpers.previousItem(this._children, index);\n                        var next = helpers.nextItem(this._children, index);\n\n                        if (index === 0) {\n                            ctx.moveTo(point._view.x, point._view.y);\n                        } else {\n                            this.lineToNextPoint(previous, point, next, function (previousPoint, point, nextPoint) {\n                                ctx.moveTo(nextPoint._view.x, nextPoint._view.y);\n                            }, function (previousPoint, point) {\n                                // If we skipped the last point, move up to our point preventing a line from being drawn\n                                ctx.moveTo(point._view.x, point._view.y);\n                            });\n                        }\n                    }, this);\n\n                    if (this._loop && this._children.length > 0) {\n                        loopBackToStart();\n                    }\n\n                    ctx.stroke();\n                    ctx.restore();\n                }\n            });\n        };\n    }, {}], 36: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers,\n                globalOpts = Chart.defaults.global;\n\n            globalOpts.elements.point = {\n                radius: 3,\n                pointStyle: 'circle',\n                backgroundColor: globalOpts.defaultColor,\n                borderWidth: 1,\n                borderColor: globalOpts.defaultColor,\n                // Hover\n                hitRadius: 1,\n                hoverRadius: 4,\n                hoverBorderWidth: 1\n            };\n\n\n            Chart.elements.Point = Chart.Element.extend({\n                inRange: function (mouseX, mouseY) {\n                    var vm = this._view;\n                    return vm ? ((Math.pow(mouseX - vm.x, 2) + Math.pow(mouseY - vm.y, 2)) < Math.pow(vm.hitRadius + vm.radius, 2)) : false;\n                },\n                inLabelRange: function (mouseX) {\n                    var vm = this._view;\n                    return vm ? (Math.pow(mouseX - vm.x, 2) < Math.pow(vm.radius + vm.hitRadius, 2)) : false;\n                },\n                tooltipPosition: function () {\n                    var vm = this._view;\n                    return {\n                        x: vm.x,\n                        y: vm.y,\n                        padding: vm.radius + vm.borderWidth\n                    };\n                },\n                draw: function () {\n                    var vm = this._view,\n                        x = vm.x,\n                        y = vm.y;\n                    var ctx = this._chart.ctx;\n\n                    if (vm.skip) {\n                        return;\n                    }\n\n                    var pointStyle = vm.pointStyle;\n                    if (typeof pointStyle === 'object' && ((pointStyle.toString() === '[object HTMLImageElement]') || (pointStyle.toString() === '[object HTMLCanvasElement]'))) {\n                        ctx.drawImage(pointStyle, x - pointStyle.width / 2, y - pointStyle.height / 2);\n                        return;\n                    }\n\n                    if (!isNaN(vm.radius) && vm.radius > 0) {\n\n                        ctx.strokeStyle = vm.borderColor || Chart.defaults.global.defaultColor;\n                        ctx.lineWidth = helpers.getValueOrDefault(vm.borderWidth, Chart.defaults.global.elements.point.borderWidth);\n\n                        ctx.fillStyle = vm.backgroundColor || Chart.defaults.global.defaultColor;\n\n                        var radius = vm.radius;\n\n                        var xOffset,\n                            yOffset;\n\n                        switch (pointStyle) {\n                            // Default includes circle\n                            default:\n                                ctx.beginPath();\n                                ctx.arc(x, y, radius, 0, Math.PI * 2);\n                                ctx.closePath();\n                                ctx.fill();\n                                break;\n                            case 'triangle':\n                                ctx.beginPath();\n                                var edgeLength = 3 * radius / Math.sqrt(3);\n                                var height = edgeLength * Math.sqrt(3) / 2;\n                                ctx.moveTo(x - edgeLength / 2, y + height / 3);\n                                ctx.lineTo(x + edgeLength / 2, y + height / 3);\n                                ctx.lineTo(x, y - 2 * height / 3);\n                                ctx.closePath();\n                                ctx.fill();\n                                break;\n                            case 'rect':\n                                ctx.fillRect(x - 1 / Math.SQRT2 * radius, y - 1 / Math.SQRT2 * radius, 2 / Math.SQRT2 * radius, 2 / Math.SQRT2 * radius);\n                                ctx.strokeRect(x - 1 / Math.SQRT2 * radius, y - 1 / Math.SQRT2 * radius, 2 / Math.SQRT2 * radius, 2 / Math.SQRT2 * radius);\n                                break;\n                            case 'rectRot':\n                                ctx.translate(x, y);\n                                ctx.rotate(Math.PI / 4);\n                                ctx.fillRect(-1 / Math.SQRT2 * radius, -1 / Math.SQRT2 * radius, 2 / Math.SQRT2 * radius, 2 / Math.SQRT2 * radius);\n                                ctx.strokeRect(-1 / Math.SQRT2 * radius, -1 / Math.SQRT2 * radius, 2 / Math.SQRT2 * radius, 2 / Math.SQRT2 * radius);\n                                ctx.setTransform(1, 0, 0, 1, 0, 0);\n                                break;\n                            case 'cross':\n                                ctx.beginPath();\n                                ctx.moveTo(x, y + radius);\n                                ctx.lineTo(x, y - radius);\n                                ctx.moveTo(x - radius, y);\n                                ctx.lineTo(x + radius, y);\n                                ctx.closePath();\n                                break;\n                            case 'crossRot':\n                                ctx.beginPath();\n                                xOffset = Math.cos(Math.PI / 4) * radius;\n                                yOffset = Math.sin(Math.PI / 4) * radius;\n                                ctx.moveTo(x - xOffset, y - yOffset);\n                                ctx.lineTo(x + xOffset, y + yOffset);\n                                ctx.moveTo(x - xOffset, y + yOffset);\n                                ctx.lineTo(x + xOffset, y - yOffset);\n                                ctx.closePath();\n                                break;\n                            case 'star':\n                                ctx.beginPath();\n                                ctx.moveTo(x, y + radius);\n                                ctx.lineTo(x, y - radius);\n                                ctx.moveTo(x - radius, y);\n                                ctx.lineTo(x + radius, y);\n                                xOffset = Math.cos(Math.PI / 4) * radius;\n                                yOffset = Math.sin(Math.PI / 4) * radius;\n                                ctx.moveTo(x - xOffset, y - yOffset);\n                                ctx.lineTo(x + xOffset, y + yOffset);\n                                ctx.moveTo(x - xOffset, y + yOffset);\n                                ctx.lineTo(x + xOffset, y - yOffset);\n                                ctx.closePath();\n                                break;\n                            case 'line':\n                                ctx.beginPath();\n                                ctx.moveTo(x - radius, y);\n                                ctx.lineTo(x + radius, y);\n                                ctx.closePath();\n                                break;\n                            case 'dash':\n                                ctx.beginPath();\n                                ctx.moveTo(x, y);\n                                ctx.lineTo(x + radius, y);\n                                ctx.closePath();\n                                break;\n                        }\n\n                        ctx.stroke();\n                    }\n                }\n            });\n        };\n    }, {}], 37: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers,\n                globalOpts = Chart.defaults.global;\n\n            globalOpts.elements.rectangle = {\n                backgroundColor: globalOpts.defaultColor,\n                borderWidth: 0,\n                borderColor: globalOpts.defaultColor,\n                borderSkipped: 'bottom'\n            };\n\n            Chart.elements.Rectangle = Chart.Element.extend({\n                draw: function () {\n                    var ctx = this._chart.ctx;\n                    var vm = this._view;\n\n                    var halfWidth = vm.width / 2,\n                        leftX = vm.x - halfWidth,\n                        rightX = vm.x + halfWidth,\n                        top = vm.base - (vm.base - vm.y),\n                        halfStroke = vm.borderWidth / 2;\n\n                    // Canvas doesn't allow us to stroke inside the width so we can\n                    // adjust the sizes to fit if we're setting a stroke on the line\n                    if (vm.borderWidth) {\n                        leftX += halfStroke;\n                        rightX -= halfStroke;\n                        top += halfStroke;\n                    }\n\n                    ctx.beginPath();\n                    ctx.fillStyle = vm.backgroundColor;\n                    ctx.strokeStyle = vm.borderColor;\n                    ctx.lineWidth = vm.borderWidth;\n\n                    // Corner points, from bottom-left to bottom-right clockwise\n                    // | 1 2 |\n                    // | 0 3 |\n                    var corners = [\n                        [leftX, vm.base],\n                        [leftX, top],\n                        [rightX, top],\n                        [rightX, vm.base]\n                    ];\n\n                    // Find first (starting) corner with fallback to 'bottom'\n                    var borders = ['bottom', 'left', 'top', 'right'];\n                    var startCorner = borders.indexOf(vm.borderSkipped, 0);\n                    if (startCorner === -1)\n                        startCorner = 0;\n\n                    function cornerAt(index) {\n                        return corners[(startCorner + index) % 4];\n                    }\n\n                    // Draw rectangle from 'startCorner'\n                    ctx.moveTo.apply(ctx, cornerAt(0));\n                    for (var i = 1; i < 4; i++)\n                        ctx.lineTo.apply(ctx, cornerAt(i));\n\n                    ctx.fill();\n                    if (vm.borderWidth) {\n                        ctx.stroke();\n                    }\n                },\n                height: function () {\n                    var vm = this._view;\n                    return vm.base - vm.y;\n                },\n                inRange: function (mouseX, mouseY) {\n                    var vm = this._view;\n                    return vm ?\n                        (vm.y < vm.base ?\n                            (mouseX >= vm.x - vm.width / 2 && mouseX <= vm.x + vm.width / 2) && (mouseY >= vm.y && mouseY <= vm.base) :\n                            (mouseX >= vm.x - vm.width / 2 && mouseX <= vm.x + vm.width / 2) && (mouseY >= vm.base && mouseY <= vm.y)) :\n                        false;\n                },\n                inLabelRange: function (mouseX) {\n                    var vm = this._view;\n                    return vm ? (mouseX >= vm.x - vm.width / 2 && mouseX <= vm.x + vm.width / 2) : false;\n                },\n                tooltipPosition: function () {\n                    var vm = this._view;\n                    return {\n                        x: vm.x,\n                        y: vm.y\n                    };\n                }\n            });\n\n        };\n    }, {}], 38: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n            // Default config for a category scale\n            var defaultConfig = {\n                position: \"bottom\"\n            };\n\n            var DatasetScale = Chart.Scale.extend({\n                // Implement this so that\n                determineDataLimits: function () {\n                    this.minIndex = 0;\n                    this.maxIndex = this.chart.data.labels.length - 1;\n                    var findIndex;\n\n                    if (this.options.ticks.min !== undefined) {\n                        // user specified min value\n                        findIndex = helpers.indexOf(this.chart.data.labels, this.options.ticks.min);\n                        this.minIndex = findIndex !== -1 ? findIndex : this.minIndex;\n                    }\n\n                    if (this.options.ticks.max !== undefined) {\n                        // user specified max value\n                        findIndex = helpers.indexOf(this.chart.data.labels, this.options.ticks.max);\n                        this.maxIndex = findIndex !== -1 ? findIndex : this.maxIndex;\n                    }\n\n                    this.min = this.chart.data.labels[this.minIndex];\n                    this.max = this.chart.data.labels[this.maxIndex];\n                },\n\n                buildTicks: function (index) {\n                    // If we are viewing some subset of labels, slice the original array\n                    this.ticks = (this.minIndex === 0 && this.maxIndex === this.chart.data.labels.length - 1) ? this.chart.data.labels : this.chart.data.labels.slice(this.minIndex, this.maxIndex + 1);\n                },\n\n                getLabelForIndex: function (index, datasetIndex) {\n                    return this.ticks[index];\n                },\n\n                // Used to get data value locations.  Value can either be an index or a numerical value\n                getPixelForValue: function (value, index, datasetIndex, includeOffset) {\n                    // 1 is added because we need the length but we have the indexes\n                    var offsetAmt = Math.max((this.maxIndex + 1 - this.minIndex - ((this.options.gridLines.offsetGridLines) ? 0 : 1)), 1);\n\n                    if (this.isHorizontal()) {\n                        var innerWidth = this.width - (this.paddingLeft + this.paddingRight);\n                        var valueWidth = innerWidth / offsetAmt;\n                        var widthOffset = (valueWidth * (index - this.minIndex)) + this.paddingLeft;\n\n                        if (this.options.gridLines.offsetGridLines && includeOffset) {\n                            widthOffset += (valueWidth / 2);\n                        }\n\n                        return this.left + Math.round(widthOffset);\n                    } else {\n                        var innerHeight = this.height - (this.paddingTop + this.paddingBottom);\n                        var valueHeight = innerHeight / offsetAmt;\n                        var heightOffset = (valueHeight * (index - this.minIndex)) + this.paddingTop;\n\n                        if (this.options.gridLines.offsetGridLines && includeOffset) {\n                            heightOffset += (valueHeight / 2);\n                        }\n\n                        return this.top + Math.round(heightOffset);\n                    }\n                },\n                getPixelForTick: function (index, includeOffset) {\n                    return this.getPixelForValue(this.ticks[index], index + this.minIndex, null, includeOffset);\n                },\n                getValueForPixel: function (pixel) {\n                    var value\n                        ; var offsetAmt = Math.max((this.ticks.length - ((this.options.gridLines.offsetGridLines) ? 0 : 1)), 1);\n                    var horz = this.isHorizontal();\n                    var innerDimension = horz ? this.width - (this.paddingLeft + this.paddingRight) : this.height - (this.paddingTop + this.paddingBottom);\n                    var valueDimension = innerDimension / offsetAmt;\n\n                    if (this.options.gridLines.offsetGridLines) {\n                        pixel -= (valueDimension / 2);\n                    }\n                    pixel -= horz ? this.paddingLeft : this.paddingTop;\n\n                    if (pixel <= 0) {\n                        value = 0;\n                    } else {\n                        value = Math.round(pixel / valueDimension);\n                    }\n\n                    return value;\n                }\n            });\n\n            Chart.scaleService.registerScaleType(\"category\", DatasetScale, defaultConfig);\n\n        };\n    }, {}], 39: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            var defaultConfig = {\n                position: \"left\",\n                ticks: {\n                    callback: function (tickValue, index, ticks) {\n                        // If we have lots of ticks, don't use the ones\n                        var delta = ticks.length > 3 ? ticks[2] - ticks[1] : ticks[1] - ticks[0];\n\n                        // If we have a number like 2.5 as the delta, figure out how many decimal places we need\n                        if (Math.abs(delta) > 1) {\n                            if (tickValue !== Math.floor(tickValue)) {\n                                // not an integer\n                                delta = tickValue - Math.floor(tickValue);\n                            }\n                        }\n\n                        var logDelta = helpers.log10(Math.abs(delta));\n                        var tickString = '';\n\n                        if (tickValue !== 0) {\n                            var numDecimal = -1 * Math.floor(logDelta);\n                            numDecimal = Math.max(Math.min(numDecimal, 20), 0); // toFixed has a max of 20 decimal places\n                            tickString = tickValue.toFixed(numDecimal);\n                        } else {\n                            tickString = '0'; // never show decimal places for 0\n                        }\n\n                        return tickString;\n                    }\n                }\n            };\n\n            var LinearScale = Chart.Scale.extend({\n                determineDataLimits: function () {\n                    // First Calculate the range\n                    this.min = null;\n                    this.max = null;\n\n                    if (this.options.stacked) {\n                        var valuesPerType = {};\n                        var hasPositiveValues = false;\n                        var hasNegativeValues = false;\n\n                        helpers.each(this.chart.data.datasets, function (dataset, datasetIndex) {\n                            var meta = this.chart.getDatasetMeta(datasetIndex);\n                            if (valuesPerType[meta.type] === undefined) {\n                                valuesPerType[meta.type] = {\n                                    positiveValues: [],\n                                    negativeValues: []\n                                };\n                            }\n\n                            // Store these per type\n                            var positiveValues = valuesPerType[meta.type].positiveValues;\n                            var negativeValues = valuesPerType[meta.type].negativeValues;\n\n                            if (this.chart.isDatasetVisible(datasetIndex) && (this.isHorizontal() ? meta.xAxisID === this.id : meta.yAxisID === this.id)) {\n                                helpers.each(dataset.data, function (rawValue, index) {\n                                    var value = +this.getRightValue(rawValue);\n                                    if (isNaN(value) || meta.data[index].hidden) {\n                                        return;\n                                    }\n\n                                    positiveValues[index] = positiveValues[index] || 0;\n                                    negativeValues[index] = negativeValues[index] || 0;\n\n                                    if (this.options.relativePoints) {\n                                        positiveValues[index] = 100;\n                                    } else {\n                                        if (value < 0) {\n                                            hasNegativeValues = true;\n                                            negativeValues[index] += value;\n                                        } else {\n                                            hasPositiveValues = true;\n                                            positiveValues[index] += value;\n                                        }\n                                    }\n                                }, this);\n                            }\n                        }, this);\n\n                        helpers.each(valuesPerType, function (valuesForType) {\n                            var values = valuesForType.positiveValues.concat(valuesForType.negativeValues);\n                            var minVal = helpers.min(values);\n                            var maxVal = helpers.max(values);\n                            this.min = this.min === null ? minVal : Math.min(this.min, minVal);\n                            this.max = this.max === null ? maxVal : Math.max(this.max, maxVal);\n                        }, this);\n\n                    } else {\n                        helpers.each(this.chart.data.datasets, function (dataset, datasetIndex) {\n                            var meta = this.chart.getDatasetMeta(datasetIndex);\n                            if (this.chart.isDatasetVisible(datasetIndex) && (this.isHorizontal() ? meta.xAxisID === this.id : meta.yAxisID === this.id)) {\n                                helpers.each(dataset.data, function (rawValue, index) {\n                                    var value = +this.getRightValue(rawValue);\n                                    if (isNaN(value) || meta.data[index].hidden) {\n                                        return;\n                                    }\n\n                                    if (this.min === null) {\n                                        this.min = value;\n                                    } else if (value < this.min) {\n                                        this.min = value;\n                                    }\n\n                                    if (this.max === null) {\n                                        this.max = value;\n                                    } else if (value > this.max) {\n                                        this.max = value;\n                                    }\n                                }, this);\n                            }\n                        }, this);\n                    }\n\n                    // If we are forcing it to begin at 0, but 0 will already be rendered on the chart,\n                    // do nothing since that would make the chart weird. If the user really wants a weird chart\n                    // axis, they can manually override it\n                    if (this.options.ticks.beginAtZero) {\n                        var minSign = helpers.sign(this.min);\n                        var maxSign = helpers.sign(this.max);\n\n                        if (minSign < 0 && maxSign < 0) {\n                            // move the top up to 0\n                            this.max = 0;\n                        } else if (minSign > 0 && maxSign > 0) {\n                            // move the botttom down to 0\n                            this.min = 0;\n                        }\n                    }\n\n                    if (this.options.ticks.min !== undefined) {\n                        this.min = this.options.ticks.min;\n                    } else if (this.options.ticks.suggestedMin !== undefined) {\n                        this.min = Math.min(this.min, this.options.ticks.suggestedMin);\n                    }\n\n                    if (this.options.ticks.max !== undefined) {\n                        this.max = this.options.ticks.max;\n                    } else if (this.options.ticks.suggestedMax !== undefined) {\n                        this.max = Math.max(this.max, this.options.ticks.suggestedMax);\n                    }\n\n                    if (this.min === this.max) {\n                        this.max++;\n\n                        if (!this.options.ticks.beginAtZero) {\n                            this.min--;\n                        }\n                    }\n                },\n                buildTicks: function () {\n\n                    // Then calulate the ticks\n                    this.ticks = [];\n\n                    // Figure out what the max number of ticks we can support it is based on the size of\n                    // the axis area. For now, we say that the minimum tick spacing in pixels must be 50\n                    // We also limit the maximum number of ticks to 11 which gives a nice 10 squares on\n                    // the graph\n\n                    var maxTicks;\n\n                    if (this.isHorizontal()) {\n                        maxTicks = Math.min(this.options.ticks.maxTicksLimit ? this.options.ticks.maxTicksLimit : 11, Math.ceil(this.width / 50));\n                    } else {\n                        // The factor of 2 used to scale the font size has been experimentally determined.\n                        var tickFontSize = helpers.getValueOrDefault(this.options.ticks.fontSize, Chart.defaults.global.defaultFontSize);\n                        maxTicks = Math.min(this.options.ticks.maxTicksLimit ? this.options.ticks.maxTicksLimit : 11, Math.ceil(this.height / (2 * tickFontSize)));\n                    }\n\n                    // Make sure we always have at least 2 ticks\n                    maxTicks = Math.max(2, maxTicks);\n\n                    // To get a \"nice\" value for the tick spacing, we will use the appropriately named\n                    // \"nice number\" algorithm. See http://stackoverflow.com/questions/8506881/nice-label-algorithm-for-charts-with-minimum-ticks\n                    // for details.\n\n                    var spacing;\n                    var fixedStepSizeSet = (this.options.ticks.fixedStepSize && this.options.ticks.fixedStepSize > 0) || (this.options.ticks.stepSize && this.options.ticks.stepSize > 0);\n                    if (fixedStepSizeSet) {\n                        spacing = helpers.getValueOrDefault(this.options.ticks.fixedStepSize, this.options.ticks.stepSize);\n                    } else {\n                        var niceRange = helpers.niceNum(this.max - this.min, false);\n                        spacing = helpers.niceNum(niceRange / (maxTicks - 1), true);\n                    }\n                    var niceMin = Math.floor(this.min / spacing) * spacing;\n                    var niceMax = Math.ceil(this.max / spacing) * spacing;\n                    var numSpaces = (niceMax - niceMin) / spacing;\n\n                    // If very close to our rounded value, use it.\n                    if (helpers.almostEquals(numSpaces, Math.round(numSpaces), spacing / 1000)) {\n                        numSpaces = Math.round(numSpaces);\n                    } else {\n                        numSpaces = Math.ceil(numSpaces);\n                    }\n\n                    // Put the values into the ticks array\n                    this.ticks.push(this.options.ticks.min !== undefined ? this.options.ticks.min : niceMin);\n                    for (var j = 1; j < numSpaces; ++j) {\n                        this.ticks.push(niceMin + (j * spacing));\n                    }\n                    this.ticks.push(this.options.ticks.max !== undefined ? this.options.ticks.max : niceMax);\n\n                    if (this.options.position === \"left\" || this.options.position === \"right\") {\n                        // We are in a vertical orientation. The top value is the highest. So reverse the array\n                        this.ticks.reverse();\n                    }\n\n                    // At this point, we need to update our max and min given the tick values since we have expanded the\n                    // range of the scale\n                    this.max = helpers.max(this.ticks);\n                    this.min = helpers.min(this.ticks);\n\n                    if (this.options.ticks.reverse) {\n                        this.ticks.reverse();\n\n                        this.start = this.max;\n                        this.end = this.min;\n                    } else {\n                        this.start = this.min;\n                        this.end = this.max;\n                    }\n                },\n                getLabelForIndex: function (index, datasetIndex) {\n                    return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);\n                },\n                convertTicksToLabels: function () {\n                    this.ticksAsNumbers = this.ticks.slice();\n                    this.zeroLineIndex = this.ticks.indexOf(0);\n\n                    Chart.Scale.prototype.convertTicksToLabels.call(this);\n                },\n                // Utils\n                getPixelForValue: function (value, index, datasetIndex, includeOffset) {\n                    // This must be called after fit has been run so that\n                    //      this.left, this.top, this.right, and this.bottom have been defined\n                    var rightValue = +this.getRightValue(value);\n                    var pixel;\n                    var range = this.end - this.start;\n\n                    if (this.isHorizontal()) {\n                        var innerWidth = this.width - (this.paddingLeft + this.paddingRight);\n                        pixel = this.left + (innerWidth / range * (rightValue - this.start));\n                        return Math.round(pixel + this.paddingLeft);\n                    } else {\n                        var innerHeight = this.height - (this.paddingTop + this.paddingBottom);\n                        pixel = (this.bottom - this.paddingBottom) - (innerHeight / range * (rightValue - this.start));\n                        return Math.round(pixel);\n                    }\n                },\n                getValueForPixel: function (pixel) {\n                    var offset;\n\n                    if (this.isHorizontal()) {\n                        var innerWidth = this.width - (this.paddingLeft + this.paddingRight);\n                        offset = (pixel - this.left - this.paddingLeft) / innerWidth;\n                    } else {\n                        var innerHeight = this.height - (this.paddingTop + this.paddingBottom);\n                        offset = (this.bottom - this.paddingBottom - pixel) / innerHeight;\n                    }\n\n                    return this.start + ((this.end - this.start) * offset);\n                },\n                getPixelForTick: function (index, includeOffset) {\n                    return this.getPixelForValue(this.ticksAsNumbers[index], null, null, includeOffset);\n                }\n            });\n            Chart.scaleService.registerScaleType(\"linear\", LinearScale, defaultConfig);\n\n        };\n    }, {}], 40: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            var defaultConfig = {\n                position: \"left\",\n\n                // label settings\n                ticks: {\n                    callback: function (value, index, arr) {\n                        var remain = value / (Math.pow(10, Math.floor(Chart.helpers.log10(value))));\n\n                        if (remain === 1 || remain === 2 || remain === 5 || index === 0 || index === arr.length - 1) {\n                            return value.toExponential();\n                        } else {\n                            return '';\n                        }\n                    }\n                }\n            };\n\n            var LogarithmicScale = Chart.Scale.extend({\n                determineDataLimits: function () {\n                    // Calculate Range\n                    this.min = null;\n                    this.max = null;\n\n                    if (this.options.stacked) {\n                        var valuesPerType = {};\n\n                        helpers.each(this.chart.data.datasets, function (dataset, datasetIndex) {\n                            var meta = this.chart.getDatasetMeta(datasetIndex);\n                            if (this.chart.isDatasetVisible(datasetIndex) && (this.isHorizontal() ? meta.xAxisID === this.id : meta.yAxisID === this.id)) {\n                                if (valuesPerType[meta.type] === undefined) {\n                                    valuesPerType[meta.type] = [];\n                                }\n\n                                helpers.each(dataset.data, function (rawValue, index) {\n                                    var values = valuesPerType[meta.type];\n                                    var value = +this.getRightValue(rawValue);\n                                    if (isNaN(value) || meta.data[index].hidden) {\n                                        return;\n                                    }\n\n                                    values[index] = values[index] || 0;\n\n                                    if (this.options.relativePoints) {\n                                        values[index] = 100;\n                                    } else {\n                                        // Don't need to split positive and negative since the log scale can't handle a 0 crossing\n                                        values[index] += value;\n                                    }\n                                }, this);\n                            }\n                        }, this);\n\n                        helpers.each(valuesPerType, function (valuesForType) {\n                            var minVal = helpers.min(valuesForType);\n                            var maxVal = helpers.max(valuesForType);\n                            this.min = this.min === null ? minVal : Math.min(this.min, minVal);\n                            this.max = this.max === null ? maxVal : Math.max(this.max, maxVal);\n                        }, this);\n\n                    } else {\n                        helpers.each(this.chart.data.datasets, function (dataset, datasetIndex) {\n                            var meta = this.chart.getDatasetMeta(datasetIndex);\n                            if (this.chart.isDatasetVisible(datasetIndex) && (this.isHorizontal() ? meta.xAxisID === this.id : meta.yAxisID === this.id)) {\n                                helpers.each(dataset.data, function (rawValue, index) {\n                                    var value = +this.getRightValue(rawValue);\n                                    if (isNaN(value) || meta.data[index].hidden) {\n                                        return;\n                                    }\n\n                                    if (this.min === null) {\n                                        this.min = value;\n                                    } else if (value < this.min) {\n                                        this.min = value;\n                                    }\n\n                                    if (this.max === null) {\n                                        this.max = value;\n                                    } else if (value > this.max) {\n                                        this.max = value;\n                                    }\n                                }, this);\n                            }\n                        }, this);\n                    }\n\n                    this.min = this.options.ticks.min !== undefined ? this.options.ticks.min : this.min;\n                    this.max = this.options.ticks.max !== undefined ? this.options.ticks.max : this.max;\n\n                    if (this.min === this.max) {\n                        if (this.min !== 0 && this.min !== null) {\n                            this.min = Math.pow(10, Math.floor(helpers.log10(this.min)) - 1);\n                            this.max = Math.pow(10, Math.floor(helpers.log10(this.max)) + 1);\n                        } else {\n                            this.min = 1;\n                            this.max = 10;\n                        }\n                    }\n                },\n                buildTicks: function () {\n                    // Reset the ticks array. Later on, we will draw a grid line at these positions\n                    // The array simply contains the numerical value of the spots where ticks will be\n                    this.ticks = [];\n\n                    // Figure out what the max number of ticks we can support it is based on the size of\n                    // the axis area. For now, we say that the minimum tick spacing in pixels must be 50\n                    // We also limit the maximum number of ticks to 11 which gives a nice 10 squares on\n                    // the graph\n\n                    var tickVal = this.options.ticks.min !== undefined ? this.options.ticks.min : Math.pow(10, Math.floor(helpers.log10(this.min)));\n\n                    while (tickVal < this.max) {\n                        this.ticks.push(tickVal);\n\n                        var exp = Math.floor(helpers.log10(tickVal));\n                        var significand = Math.floor(tickVal / Math.pow(10, exp)) + 1;\n\n                        if (significand === 10) {\n                            significand = 1;\n                            ++exp;\n                        }\n\n                        tickVal = significand * Math.pow(10, exp);\n                    }\n\n                    var lastTick = this.options.ticks.max !== undefined ? this.options.ticks.max : tickVal;\n                    this.ticks.push(lastTick);\n\n                    if (this.options.position === \"left\" || this.options.position === \"right\") {\n                        // We are in a vertical orientation. The top value is the highest. So reverse the array\n                        this.ticks.reverse();\n                    }\n\n                    // At this point, we need to update our max and min given the tick values since we have expanded the\n                    // range of the scale\n                    this.max = helpers.max(this.ticks);\n                    this.min = helpers.min(this.ticks);\n\n                    if (this.options.ticks.reverse) {\n                        this.ticks.reverse();\n\n                        this.start = this.max;\n                        this.end = this.min;\n                    } else {\n                        this.start = this.min;\n                        this.end = this.max;\n                    }\n                },\n                convertTicksToLabels: function () {\n                    this.tickValues = this.ticks.slice();\n\n                    Chart.Scale.prototype.convertTicksToLabels.call(this);\n                },\n                // Get the correct tooltip label\n                getLabelForIndex: function (index, datasetIndex) {\n                    return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);\n                },\n                getPixelForTick: function (index, includeOffset) {\n                    return this.getPixelForValue(this.tickValues[index], null, null, includeOffset);\n                },\n                getPixelForValue: function (value, index, datasetIndex, includeOffset) {\n                    var pixel;\n\n                    var newVal = +this.getRightValue(value)\n                        ; var range = helpers.log10(this.end) - helpers.log10(this.start);\n\n                    if (this.isHorizontal()) {\n\n                        if (newVal === 0) {\n                            pixel = this.left + this.paddingLeft;\n                        } else {\n                            var innerWidth = this.width - (this.paddingLeft + this.paddingRight);\n                            pixel = this.left + (innerWidth / range * (helpers.log10(newVal) - helpers.log10(this.start)));\n                            pixel += this.paddingLeft;\n                        }\n                    } else {\n                        // Bottom - top since pixels increase downard on a screen\n                        if (newVal === 0) {\n                            pixel = this.top + this.paddingTop;\n                        } else {\n                            var innerHeight = this.height - (this.paddingTop + this.paddingBottom);\n                            pixel = (this.bottom - this.paddingBottom) - (innerHeight / range * (helpers.log10(newVal) - helpers.log10(this.start)));\n                        }\n                    }\n\n                    return pixel;\n                },\n                getValueForPixel: function (pixel) {\n                    var offset;\n                    var range = helpers.log10(this.end) - helpers.log10(this.start);\n                    var value;\n\n                    if (this.isHorizontal()) {\n                        var innerWidth = this.width - (this.paddingLeft + this.paddingRight);\n                        value = this.start * Math.pow(10, (pixel - this.left - this.paddingLeft) * range / innerWidth);\n                    } else {\n                        var innerHeight = this.height - (this.paddingTop + this.paddingBottom);\n                        value = Math.pow(10, (this.bottom - this.paddingBottom - pixel) * range / innerHeight) / this.start;\n                    }\n\n                    return value;\n                }\n\n            });\n            Chart.scaleService.registerScaleType(\"logarithmic\", LogarithmicScale, defaultConfig);\n\n        };\n    }, {}], 41: [function (require, module, exports) {\n        \"use strict\";\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n\n            var defaultConfig = {\n                display: true,\n\n                //Boolean - Whether to animate scaling the chart from the centre\n                animate: true,\n                lineArc: false,\n                position: \"chartArea\",\n\n                angleLines: {\n                    display: true,\n                    color: \"rgba(0, 0, 0, 0.1)\",\n                    lineWidth: 1\n                },\n\n                // label settings\n                ticks: {\n                    //Boolean - Show a backdrop to the scale label\n                    showLabelBackdrop: true,\n\n                    //String - The colour of the label backdrop\n                    backdropColor: \"rgba(255,255,255,0.75)\",\n\n                    //Number - The backdrop padding above & below the label in pixels\n                    backdropPaddingY: 2,\n\n                    //Number - The backdrop padding to the side of the label in pixels\n                    backdropPaddingX: 2\n                },\n\n                pointLabels: {\n                    //Number - Point label font size in pixels\n                    fontSize: 10,\n\n                    //Function - Used to convert point labels\n                    callback: function (label) {\n                        return label;\n                    }\n                }\n            };\n\n            var LinearRadialScale = Chart.Scale.extend({\n                getValueCount: function () {\n                    return this.chart.data.labels.length;\n                },\n                setDimensions: function () {\n                    // Set the unconstrained dimension before label rotation\n                    this.width = this.maxWidth;\n                    this.height = this.maxHeight;\n                    this.xCenter = Math.round(this.width / 2);\n                    this.yCenter = Math.round(this.height / 2);\n\n                    var minSize = helpers.min([this.height, this.width]);\n                    var tickFontSize = helpers.getValueOrDefault(this.options.ticks.fontSize, Chart.defaults.global.defaultFontSize);\n                    this.drawingArea = (this.options.display) ? (minSize / 2) - (tickFontSize / 2 + this.options.ticks.backdropPaddingY) : (minSize / 2);\n                },\n                determineDataLimits: function () {\n                    this.min = null;\n                    this.max = null;\n\n                    helpers.each(this.chart.data.datasets, function (dataset, datasetIndex) {\n                        if (this.chart.isDatasetVisible(datasetIndex)) {\n                            var meta = this.chart.getDatasetMeta(datasetIndex);\n                            helpers.each(dataset.data, function (rawValue, index) {\n                                var value = +this.getRightValue(rawValue);\n                                if (isNaN(value) || meta.data[index].hidden) {\n                                    return;\n                                }\n\n                                if (this.min === null) {\n                                    this.min = value;\n                                } else if (value < this.min) {\n                                    this.min = value;\n                                }\n\n                                if (this.max === null) {\n                                    this.max = value;\n                                } else if (value > this.max) {\n                                    this.max = value;\n                                }\n                            }, this);\n                        }\n                    }, this);\n\n                    // If we are forcing it to begin at 0, but 0 will already be rendered on the chart,\n                    // do nothing since that would make the chart weird. If the user really wants a weird chart\n                    // axis, they can manually override it\n                    if (this.options.ticks.beginAtZero) {\n                        var minSign = helpers.sign(this.min);\n                        var maxSign = helpers.sign(this.max);\n\n                        if (minSign < 0 && maxSign < 0) {\n                            // move the top up to 0\n                            this.max = 0;\n                        } else if (minSign > 0 && maxSign > 0) {\n                            // move the botttom down to 0\n                            this.min = 0;\n                        }\n                    }\n\n                    if (this.options.ticks.min !== undefined) {\n                        this.min = this.options.ticks.min;\n                    } else if (this.options.ticks.suggestedMin !== undefined) {\n                        this.min = Math.min(this.min, this.options.ticks.suggestedMin);\n                    }\n\n                    if (this.options.ticks.max !== undefined) {\n                        this.max = this.options.ticks.max;\n                    } else if (this.options.ticks.suggestedMax !== undefined) {\n                        this.max = Math.max(this.max, this.options.ticks.suggestedMax);\n                    }\n\n                    if (this.min === this.max) {\n                        this.min--;\n                        this.max++;\n                    }\n                },\n                buildTicks: function () {\n\n\n                    this.ticks = [];\n\n                    // Figure out what the max number of ticks we can support it is based on the size of\n                    // the axis area. For now, we say that the minimum tick spacing in pixels must be 50\n                    // We also limit the maximum number of ticks to 11 which gives a nice 10 squares on\n                    // the graph\n                    var tickFontSize = helpers.getValueOrDefault(this.options.ticks.fontSize, Chart.defaults.global.defaultFontSize);\n                    var maxTicks = Math.min(this.options.ticks.maxTicksLimit ? this.options.ticks.maxTicksLimit : 11, Math.ceil(this.drawingArea / (1.5 * tickFontSize)));\n                    maxTicks = Math.max(2, maxTicks); // Make sure we always have at least 2 ticks\n\n                    // To get a \"nice\" value for the tick spacing, we will use the appropriately named\n                    // \"nice number\" algorithm. See http://stackoverflow.com/questions/8506881/nice-label-algorithm-for-charts-with-minimum-ticks\n                    // for details.\n\n                    var niceRange = helpers.niceNum(this.max - this.min, false);\n                    var spacing = helpers.niceNum(niceRange / (maxTicks - 1), true);\n                    var niceMin = Math.floor(this.min / spacing) * spacing;\n                    var niceMax = Math.ceil(this.max / spacing) * spacing;\n\n                    var numSpaces = Math.ceil((niceMax - niceMin) / spacing);\n\n                    // Put the values into the ticks array\n                    this.ticks.push(this.options.ticks.min !== undefined ? this.options.ticks.min : niceMin);\n                    for (var j = 1; j < numSpaces; ++j) {\n                        this.ticks.push(niceMin + (j * spacing));\n                    }\n                    this.ticks.push(this.options.ticks.max !== undefined ? this.options.ticks.max : niceMax);\n\n                    // At this point, we need to update our max and min given the tick values since we have expanded the\n                    // range of the scale\n                    this.max = helpers.max(this.ticks);\n                    this.min = helpers.min(this.ticks);\n\n                    if (this.options.ticks.reverse) {\n                        this.ticks.reverse();\n\n                        this.start = this.max;\n                        this.end = this.min;\n                    } else {\n                        this.start = this.min;\n                        this.end = this.max;\n                    }\n\n                    this.zeroLineIndex = this.ticks.indexOf(0);\n                },\n                convertTicksToLabels: function () {\n                    Chart.Scale.prototype.convertTicksToLabels.call(this);\n\n                    // Point labels\n                    this.pointLabels = this.chart.data.labels.map(this.options.pointLabels.callback, this);\n                },\n                getLabelForIndex: function (index, datasetIndex) {\n                    return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);\n                },\n                fit: function () {\n                    /*\n                     * Right, this is really confusing and there is a lot of maths going on here\n                     * The gist of the problem is here: https://gist.github.com/nnnick/696cc9c55f4b0beb8fe9\n                     *\n                     * Reaction: https://dl.dropboxusercontent.com/u/34601363/toomuchscience.gif\n                     *\n                     * Solution:\n                     *\n                     * We assume the radius of the polygon is half the size of the canvas at first\n                     * at each index we check if the text overlaps.\n                     *\n                     * Where it does, we store that angle and that index.\n                     *\n                     * After finding the largest index and angle we calculate how much we need to remove\n                     * from the shape radius to move the point inwards by that x.\n                     *\n                     * We average the left and right distances to get the maximum shape radius that can fit in the box\n                     * along with labels.\n                     *\n                     * Once we have that, we can find the centre point for the chart, by taking the x text protrusion\n                     * on each side, removing that from the size, halving it and adding the left x protrusion width.\n                     *\n                     * This will mean we have a shape fitted to the canvas, as large as it can be with the labels\n                     * and position it in the most space efficient manner\n                     *\n                     * https://dl.dropboxusercontent.com/u/34601363/yeahscience.gif\n                     */\n\n                    var pointLabelFontSize = helpers.getValueOrDefault(this.options.pointLabels.fontSize, Chart.defaults.global.defaultFontSize);\n                    var pointLabeFontStyle = helpers.getValueOrDefault(this.options.pointLabels.fontStyle, Chart.defaults.global.defaultFontStyle);\n                    var pointLabeFontFamily = helpers.getValueOrDefault(this.options.pointLabels.fontFamily, Chart.defaults.global.defaultFontFamily);\n                    var pointLabeFont = helpers.fontString(pointLabelFontSize, pointLabeFontStyle, pointLabeFontFamily);\n\n                    // Get maximum radius of the polygon. Either half the height (minus the text width) or half the width.\n                    // Use this to calculate the offset + change. - Make sure L/R protrusion is at least 0 to stop issues with centre points\n                    var largestPossibleRadius = helpers.min([(this.height / 2 - pointLabelFontSize - 5), this.width / 2]),\n                        pointPosition,\n                        i,\n                        textWidth,\n                        halfTextWidth,\n                        furthestRight = this.width,\n                        furthestRightIndex,\n                        furthestRightAngle,\n                        furthestLeft = 0,\n                        furthestLeftIndex,\n                        furthestLeftAngle,\n                        xProtrusionLeft,\n                        xProtrusionRight,\n                        radiusReductionRight,\n                        radiusReductionLeft,\n                        maxWidthRadius;\n                    this.ctx.font = pointLabeFont;\n\n                    for (i = 0; i < this.getValueCount(); i++) {\n                        // 5px to space the text slightly out - similar to what we do in the draw function.\n                        pointPosition = this.getPointPosition(i, largestPossibleRadius);\n                        textWidth = this.ctx.measureText(this.pointLabels[i] ? this.pointLabels[i] : '').width + 5;\n                        if (i === 0 || i === this.getValueCount() / 2) {\n                            // If we're at index zero, or exactly the middle, we're at exactly the top/bottom\n                            // of the radar chart, so text will be aligned centrally, so we'll half it and compare\n                            // w/left and right text sizes\n                            halfTextWidth = textWidth / 2;\n                            if (pointPosition.x + halfTextWidth > furthestRight) {\n                                furthestRight = pointPosition.x + halfTextWidth;\n                                furthestRightIndex = i;\n                            }\n                            if (pointPosition.x - halfTextWidth < furthestLeft) {\n                                furthestLeft = pointPosition.x - halfTextWidth;\n                                furthestLeftIndex = i;\n                            }\n                        } else if (i < this.getValueCount() / 2) {\n                            // Less than half the values means we'll left align the text\n                            if (pointPosition.x + textWidth > furthestRight) {\n                                furthestRight = pointPosition.x + textWidth;\n                                furthestRightIndex = i;\n                            }\n                        } else if (i > this.getValueCount() / 2) {\n                            // More than half the values means we'll right align the text\n                            if (pointPosition.x - textWidth < furthestLeft) {\n                                furthestLeft = pointPosition.x - textWidth;\n                                furthestLeftIndex = i;\n                            }\n                        }\n                    }\n\n                    xProtrusionLeft = furthestLeft;\n                    xProtrusionRight = Math.ceil(furthestRight - this.width);\n\n                    furthestRightAngle = this.getIndexAngle(furthestRightIndex);\n                    furthestLeftAngle = this.getIndexAngle(furthestLeftIndex);\n\n                    radiusReductionRight = xProtrusionRight / Math.sin(furthestRightAngle + Math.PI / 2);\n                    radiusReductionLeft = xProtrusionLeft / Math.sin(furthestLeftAngle + Math.PI / 2);\n\n                    // Ensure we actually need to reduce the size of the chart\n                    radiusReductionRight = (helpers.isNumber(radiusReductionRight)) ? radiusReductionRight : 0;\n                    radiusReductionLeft = (helpers.isNumber(radiusReductionLeft)) ? radiusReductionLeft : 0;\n\n                    this.drawingArea = Math.round(largestPossibleRadius - (radiusReductionLeft + radiusReductionRight) / 2);\n                    this.setCenterPoint(radiusReductionLeft, radiusReductionRight);\n                },\n                setCenterPoint: function (leftMovement, rightMovement) {\n\n                    var maxRight = this.width - rightMovement - this.drawingArea,\n                        maxLeft = leftMovement + this.drawingArea;\n\n                    this.xCenter = Math.round(((maxLeft + maxRight) / 2) + this.left);\n                    // Always vertically in the centre as the text height doesn't change\n                    this.yCenter = Math.round((this.height / 2) + this.top);\n                },\n\n                getIndexAngle: function (index) {\n                    var angleMultiplier = (Math.PI * 2) / this.getValueCount();\n                    // Start from the top instead of right, so remove a quarter of the circle\n\n                    return index * angleMultiplier - (Math.PI / 2);\n                },\n                getDistanceFromCenterForValue: function (value) {\n                    if (value === null) {\n                        return 0; // null always in center\n                    }\n\n                    // Take into account half font size + the yPadding of the top value\n                    var scalingFactor = this.drawingArea / (this.max - this.min);\n                    if (this.options.reverse) {\n                        return (this.max - value) * scalingFactor;\n                    } else {\n                        return (value - this.min) * scalingFactor;\n                    }\n                },\n                getPointPosition: function (index, distanceFromCenter) {\n                    var thisAngle = this.getIndexAngle(index);\n                    return {\n                        x: Math.round(Math.cos(thisAngle) * distanceFromCenter) + this.xCenter,\n                        y: Math.round(Math.sin(thisAngle) * distanceFromCenter) + this.yCenter\n                    };\n                },\n                getPointPositionForValue: function (index, value) {\n                    return this.getPointPosition(index, this.getDistanceFromCenterForValue(value));\n                },\n                draw: function () {\n                    if (this.options.display) {\n                        var ctx = this.ctx;\n                        helpers.each(this.ticks, function (label, index) {\n                            // Don't draw a centre value (if it is minimum)\n                            if (index > 0 || this.options.reverse) {\n                                var yCenterOffset = this.getDistanceFromCenterForValue(this.ticks[index]);\n                                var yHeight = this.yCenter - yCenterOffset;\n\n                                // Draw circular lines around the scale\n                                if (this.options.gridLines.display) {\n                                    ctx.strokeStyle = this.options.gridLines.color;\n                                    ctx.lineWidth = this.options.gridLines.lineWidth;\n\n                                    if (this.options.lineArc) {\n                                        // Draw circular arcs between the points\n                                        ctx.beginPath();\n                                        ctx.arc(this.xCenter, this.yCenter, yCenterOffset, 0, Math.PI * 2);\n                                        ctx.closePath();\n                                        ctx.stroke();\n                                    } else {\n                                        // Draw straight lines connecting each index\n                                        ctx.beginPath();\n                                        for (var i = 0; i < this.getValueCount(); i++) {\n                                            var pointPosition = this.getPointPosition(i, this.getDistanceFromCenterForValue(this.ticks[index]));\n                                            if (i === 0) {\n                                                ctx.moveTo(pointPosition.x, pointPosition.y);\n                                            } else {\n                                                ctx.lineTo(pointPosition.x, pointPosition.y);\n                                            }\n                                        }\n                                        ctx.closePath();\n                                        ctx.stroke();\n                                    }\n                                }\n\n                                if (this.options.ticks.display) {\n                                    var tickFontColor = helpers.getValueOrDefault(this.options.ticks.fontColor, Chart.defaults.global.defaultFontColor);\n                                    var tickFontSize = helpers.getValueOrDefault(this.options.ticks.fontSize, Chart.defaults.global.defaultFontSize);\n                                    var tickFontStyle = helpers.getValueOrDefault(this.options.ticks.fontStyle, Chart.defaults.global.defaultFontStyle);\n                                    var tickFontFamily = helpers.getValueOrDefault(this.options.ticks.fontFamily, Chart.defaults.global.defaultFontFamily);\n                                    var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);\n                                    ctx.font = tickLabelFont;\n\n                                    if (this.options.ticks.showLabelBackdrop) {\n                                        var labelWidth = ctx.measureText(label).width;\n                                        ctx.fillStyle = this.options.ticks.backdropColor;\n                                        ctx.fillRect(\n                                            this.xCenter - labelWidth / 2 - this.options.ticks.backdropPaddingX,\n                                            yHeight - tickFontSize / 2 - this.options.ticks.backdropPaddingY,\n                                            labelWidth + this.options.ticks.backdropPaddingX * 2,\n                                            tickFontSize + this.options.ticks.backdropPaddingY * 2\n                                        );\n                                    }\n\n                                    ctx.textAlign = 'center';\n                                    ctx.textBaseline = \"middle\";\n                                    ctx.fillStyle = tickFontColor;\n                                    ctx.fillText(label, this.xCenter, yHeight);\n                                }\n                            }\n                        }, this);\n\n                        if (!this.options.lineArc) {\n                            ctx.lineWidth = this.options.angleLines.lineWidth;\n                            ctx.strokeStyle = this.options.angleLines.color;\n\n                            for (var i = this.getValueCount() - 1; i >= 0; i--) {\n                                if (this.options.angleLines.display) {\n                                    var outerPosition = this.getPointPosition(i, this.getDistanceFromCenterForValue(this.options.reverse ? this.min : this.max));\n                                    ctx.beginPath();\n                                    ctx.moveTo(this.xCenter, this.yCenter);\n                                    ctx.lineTo(outerPosition.x, outerPosition.y);\n                                    ctx.stroke();\n                                    ctx.closePath();\n                                }\n                                // Extra 3px out for some label spacing\n                                var pointLabelPosition = this.getPointPosition(i, this.getDistanceFromCenterForValue(this.options.reverse ? this.min : this.max) + 5);\n\n                                var pointLabelFontColor = helpers.getValueOrDefault(this.options.pointLabels.fontColor, Chart.defaults.global.defaultFontColor);\n                                var pointLabelFontSize = helpers.getValueOrDefault(this.options.pointLabels.fontSize, Chart.defaults.global.defaultFontSize);\n                                var pointLabeFontStyle = helpers.getValueOrDefault(this.options.pointLabels.fontStyle, Chart.defaults.global.defaultFontStyle);\n                                var pointLabeFontFamily = helpers.getValueOrDefault(this.options.pointLabels.fontFamily, Chart.defaults.global.defaultFontFamily);\n                                var pointLabeFont = helpers.fontString(pointLabelFontSize, pointLabeFontStyle, pointLabeFontFamily);\n\n                                ctx.font = pointLabeFont;\n                                ctx.fillStyle = pointLabelFontColor;\n\n                                var labelsCount = this.pointLabels.length,\n                                    halfLabelsCount = this.pointLabels.length / 2,\n                                    quarterLabelsCount = halfLabelsCount / 2,\n                                    upperHalf = (i < quarterLabelsCount || i > labelsCount - quarterLabelsCount),\n                                    exactQuarter = (i === quarterLabelsCount || i === labelsCount - quarterLabelsCount);\n                                if (i === 0) {\n                                    ctx.textAlign = 'center';\n                                } else if (i === halfLabelsCount) {\n                                    ctx.textAlign = 'center';\n                                } else if (i < halfLabelsCount) {\n                                    ctx.textAlign = 'left';\n                                } else {\n                                    ctx.textAlign = 'right';\n                                }\n\n                                // Set the correct text baseline based on outer positioning\n                                if (exactQuarter) {\n                                    ctx.textBaseline = 'middle';\n                                } else if (upperHalf) {\n                                    ctx.textBaseline = 'bottom';\n                                } else {\n                                    ctx.textBaseline = 'top';\n                                }\n\n                                ctx.fillText(this.pointLabels[i] ? this.pointLabels[i] : '', pointLabelPosition.x, pointLabelPosition.y);\n                            }\n                        }\n                    }\n                }\n            });\n            Chart.scaleService.registerScaleType(\"radialLinear\", LinearRadialScale, defaultConfig);\n\n        };\n    }, {}], 42: [function (require, module, exports) {\n        /*global window: false */\n        \"use strict\";\n\n        var moment = require('moment');\n        moment = typeof (moment) === 'function' ? moment : window.moment;\n\n        module.exports = function (Chart) {\n\n            var helpers = Chart.helpers;\n            var time = {\n                units: [{\n                    name: 'millisecond',\n                    steps: [1, 2, 5, 10, 20, 50, 100, 250, 500]\n                }, {\n                    name: 'second',\n                    steps: [1, 2, 5, 10, 30]\n                }, {\n                    name: 'minute',\n                    steps: [1, 2, 5, 10, 30]\n                }, {\n                    name: 'hour',\n                    steps: [1, 2, 3, 6, 12]\n                }, {\n                    name: 'day',\n                    steps: [1, 2, 5]\n                }, {\n                    name: 'week',\n                    maxStep: 4\n                }, {\n                    name: 'month',\n                    maxStep: 3\n                }, {\n                    name: 'quarter',\n                    maxStep: 4\n                }, {\n                    name: 'year',\n                    maxStep: false\n                }]\n            };\n\n            var defaultConfig = {\n                position: \"bottom\",\n\n                time: {\n                    parser: false, // false == a pattern string from http://momentjs.com/docs/#/parsing/string-format/ or a custom callback that converts its argument to a moment\n                    format: false, // DEPRECATED false == date objects, moment object, callback or a pattern string from http://momentjs.com/docs/#/parsing/string-format/\n                    unit: false, // false == automatic or override with week, month, year, etc.\n                    round: false, // none, or override with week, month, year, etc.\n                    displayFormat: false, // DEPRECATED\n\n                    // defaults to unit's corresponding unitFormat below or override using pattern string from http://momentjs.com/docs/#/displaying/format/\n                    displayFormats: {\n                        'millisecond': 'h:mm:ss.SSS a', // 11:20:01.123 AM,\n                        'second': 'h:mm:ss a', // 11:20:01 AM\n                        'minute': 'h:mm:ss a', // 11:20:01 AM\n                        'hour': 'MMM D, hA', // Sept 4, 5PM\n                        'day': 'll', // Sep 4 2015\n                        'week': 'll', // Week 46, or maybe \"[W]WW - YYYY\" ?\n                        'month': 'MMM YYYY', // Sept 2015\n                        'quarter': '[Q]Q - YYYY', // Q3\n                        'year': 'YYYY' // 2015\n                    }\n                },\n                ticks: {\n                    autoSkip: false\n                }\n            };\n\n            var TimeScale = Chart.Scale.extend({\n                initialize: function () {\n                    if (!moment) {\n                        throw new Error('Chart.js - Moment.js could not be found! You must include it before Chart.js to use the time scale. Download at https://momentjs.com');\n                    }\n\n                    Chart.Scale.prototype.initialize.call(this);\n                },\n                getLabelMoment: function (datasetIndex, index) {\n                    return this.labelMoments[datasetIndex][index];\n                },\n                determineDataLimits: function () {\n                    this.labelMoments = [];\n\n                    // Only parse these once. If the dataset does not have data as x,y pairs, we will use\n                    // these\n                    var scaleLabelMoments = [];\n                    if (this.chart.data.labels && this.chart.data.labels.length > 0) {\n                        helpers.each(this.chart.data.labels, function (label, index) {\n                            var labelMoment = this.parseTime(label);\n\n                            if (labelMoment.isValid()) {\n                                if (this.options.time.round) {\n                                    labelMoment.startOf(this.options.time.round);\n                                }\n                                scaleLabelMoments.push(labelMoment);\n                            }\n                        }, this);\n\n                        this.firstTick = moment.min.call(this, scaleLabelMoments);\n                        this.lastTick = moment.max.call(this, scaleLabelMoments);\n                    } else {\n                        this.firstTick = null;\n                        this.lastTick = null;\n                    }\n\n                    helpers.each(this.chart.data.datasets, function (dataset, datasetIndex) {\n                        var momentsForDataset = [];\n                        var datasetVisible = this.chart.isDatasetVisible(datasetIndex);\n\n                        if (typeof dataset.data[0] === 'object') {\n                            helpers.each(dataset.data, function (value, index) {\n                                var labelMoment = this.parseTime(this.getRightValue(value));\n\n                                if (labelMoment.isValid()) {\n                                    if (this.options.time.round) {\n                                        labelMoment.startOf(this.options.time.round);\n                                    }\n                                    momentsForDataset.push(labelMoment);\n\n                                    if (datasetVisible) {\n                                        // May have gone outside the scale ranges, make sure we keep the first and last ticks updated\n                                        this.firstTick = this.firstTick !== null ? moment.min(this.firstTick, labelMoment) : labelMoment;\n                                        this.lastTick = this.lastTick !== null ? moment.max(this.lastTick, labelMoment) : labelMoment;\n                                    }\n                                }\n                            }, this);\n                        } else {\n                            // We have no labels. Use the ones from the scale\n                            momentsForDataset = scaleLabelMoments;\n                        }\n\n                        this.labelMoments.push(momentsForDataset);\n                    }, this);\n\n                    // Set these after we've done all the data\n                    if (this.options.time.min) {\n                        this.firstTick = this.parseTime(this.options.time.min);\n                    }\n\n                    if (this.options.time.max) {\n                        this.lastTick = this.parseTime(this.options.time.max);\n                    }\n\n                    // We will modify these, so clone for later\n                    this.firstTick = (this.firstTick || moment()).clone();\n                    this.lastTick = (this.lastTick || moment()).clone();\n                },\n                buildTicks: function (index) {\n\n                    this.ctx.save();\n                    var tickFontSize = helpers.getValueOrDefault(this.options.ticks.fontSize, Chart.defaults.global.defaultFontSize);\n                    var tickFontStyle = helpers.getValueOrDefault(this.options.ticks.fontStyle, Chart.defaults.global.defaultFontStyle);\n                    var tickFontFamily = helpers.getValueOrDefault(this.options.ticks.fontFamily, Chart.defaults.global.defaultFontFamily);\n                    var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);\n                    this.ctx.font = tickLabelFont;\n\n                    this.ticks = [];\n                    this.unitScale = 1; // How much we scale the unit by, ie 2 means 2x unit per step\n                    this.scaleSizeInUnits = 0; // How large the scale is in the base unit (seconds, minutes, etc)\n\n                    // Set unit override if applicable\n                    if (this.options.time.unit) {\n                        this.tickUnit = this.options.time.unit || 'day';\n                        this.displayFormat = this.options.time.displayFormats[this.tickUnit];\n                        this.scaleSizeInUnits = this.lastTick.diff(this.firstTick, this.tickUnit, true);\n                        this.unitScale = helpers.getValueOrDefault(this.options.time.unitStepSize, 1);\n                    } else {\n                        // Determine the smallest needed unit of the time\n                        var innerWidth = this.isHorizontal() ? this.width - (this.paddingLeft + this.paddingRight) : this.height - (this.paddingTop + this.paddingBottom);\n\n                        // Crude approximation of what the label length might be\n                        var tempFirstLabel = this.tickFormatFunction(this.firstTick, 0, []);\n                        var tickLabelWidth = this.ctx.measureText(tempFirstLabel).width;\n                        var cosRotation = Math.cos(helpers.toRadians(this.options.ticks.maxRotation));\n                        var sinRotation = Math.sin(helpers.toRadians(this.options.ticks.maxRotation));\n                        tickLabelWidth = (tickLabelWidth * cosRotation) + (tickFontSize * sinRotation);\n                        var labelCapacity = innerWidth / (tickLabelWidth);\n\n                        // Start as small as possible\n                        this.tickUnit = 'millisecond';\n                        this.scaleSizeInUnits = this.lastTick.diff(this.firstTick, this.tickUnit, true);\n                        this.displayFormat = this.options.time.displayFormats[this.tickUnit];\n\n                        var unitDefinitionIndex = 0;\n                        var unitDefinition = time.units[unitDefinitionIndex];\n\n                        // While we aren't ideal and we don't have units left\n                        while (unitDefinitionIndex < time.units.length) {\n                            // Can we scale this unit. If `false` we can scale infinitely\n                            this.unitScale = 1;\n\n                            if (helpers.isArray(unitDefinition.steps) && Math.ceil(this.scaleSizeInUnits / labelCapacity) < helpers.max(unitDefinition.steps)) {\n                                // Use one of the prefedined steps\n                                for (var idx = 0; idx < unitDefinition.steps.length; ++idx) {\n                                    if (unitDefinition.steps[idx] >= Math.ceil(this.scaleSizeInUnits / labelCapacity)) {\n                                        this.unitScale = helpers.getValueOrDefault(this.options.time.unitStepSize, unitDefinition.steps[idx]);\n                                        break;\n                                    }\n                                }\n\n                                break;\n                            } else if ((unitDefinition.maxStep === false) || (Math.ceil(this.scaleSizeInUnits / labelCapacity) < unitDefinition.maxStep)) {\n                                // We have a max step. Scale this unit\n                                this.unitScale = helpers.getValueOrDefault(this.options.time.unitStepSize, Math.ceil(this.scaleSizeInUnits / labelCapacity));\n                                break;\n                            } else {\n                                // Move to the next unit up\n                                ++unitDefinitionIndex;\n                                unitDefinition = time.units[unitDefinitionIndex];\n\n                                this.tickUnit = unitDefinition.name;\n                                var leadingUnitBuffer = this.firstTick.diff(this.firstTick.clone().startOf(this.tickUnit), this.tickUnit, true);\n                                var trailingUnitBuffer = this.lastTick.clone().add(1, this.tickUnit).startOf(this.tickUnit).diff(this.lastTick, this.tickUnit, true);\n                                this.scaleSizeInUnits = this.lastTick.diff(this.firstTick, this.tickUnit, true) + leadingUnitBuffer + trailingUnitBuffer;\n                                this.displayFormat = this.options.time.displayFormats[unitDefinition.name];\n                            }\n                        }\n                    }\n\n                    var roundedStart;\n\n                    // Only round the first tick if we have no hard minimum\n                    if (!this.options.time.min) {\n                        this.firstTick.startOf(this.tickUnit);\n                        roundedStart = this.firstTick;\n                    } else {\n                        roundedStart = this.firstTick.clone().startOf(this.tickUnit);\n                    }\n\n                    // Only round the last tick if we have no hard maximum\n                    if (!this.options.time.max) {\n                        var roundedEnd = this.lastTick.clone().startOf(this.tickUnit);\n                        if (roundedEnd.diff(this.lastTick, this.tickUnit, true) !== 0) {\n                            // Do not use end of because we need this to be in the next time unit\n                            this.lastTick.add(1, this.tickUnit).startOf(this.tickUnit);\n                        }\n                    }\n\n                    this.smallestLabelSeparation = this.width;\n\n                    helpers.each(this.chart.data.datasets, function (dataset, datasetIndex) {\n                        for (var i = 1; i < this.labelMoments[datasetIndex].length; i++) {\n                            this.smallestLabelSeparation = Math.min(this.smallestLabelSeparation, this.labelMoments[datasetIndex][i].diff(this.labelMoments[datasetIndex][i - 1], this.tickUnit, true));\n                        }\n                    }, this);\n\n                    // Tick displayFormat override\n                    if (this.options.time.displayFormat) {\n                        this.displayFormat = this.options.time.displayFormat;\n                    }\n\n                    // first tick. will have been rounded correctly if options.time.min is not specified\n                    this.ticks.push(this.firstTick.clone());\n\n                    // For every unit in between the first and last moment, create a moment and add it to the ticks tick\n                    for (var i = 1; i <= this.scaleSizeInUnits; ++i) {\n                        var newTick = roundedStart.clone().add(i, this.tickUnit);\n\n                        // Are we greater than the max time\n                        if (this.options.time.max && newTick.diff(this.lastTick, this.tickUnit, true) >= 0) {\n                            break;\n                        }\n\n                        if (i % this.unitScale === 0) {\n                            this.ticks.push(newTick);\n                        }\n                    }\n\n                    // Always show the right tick\n                    var diff = this.ticks[this.ticks.length - 1].diff(this.lastTick, this.tickUnit);\n                    if (diff !== 0 || this.scaleSizeInUnits === 0) {\n                        // this is a weird case. If the <max> option is the same as the end option, we can't just diff the times because the tick was created from the roundedStart\n                        // but the last tick was not rounded.\n                        if (this.options.time.max) {\n                            this.ticks.push(this.lastTick.clone());\n                            this.scaleSizeInUnits = this.lastTick.diff(this.ticks[0], this.tickUnit, true);\n                        } else {\n                            this.ticks.push(this.lastTick.clone());\n                            this.scaleSizeInUnits = this.lastTick.diff(this.firstTick, this.tickUnit, true);\n                        }\n                    }\n\n                    this.ctx.restore();\n                },\n                // Get tooltip label\n                getLabelForIndex: function (index, datasetIndex) {\n                    var label = this.chart.data.labels && index < this.chart.data.labels.length ? this.chart.data.labels[index] : '';\n\n                    if (typeof this.chart.data.datasets[datasetIndex].data[0] === 'object') {\n                        label = this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);\n                    }\n\n                    // Format nicely\n                    if (this.options.time.tooltipFormat) {\n                        label = this.parseTime(label).format(this.options.time.tooltipFormat);\n                    }\n\n                    return label;\n                },\n                // Function to format an individual tick mark\n                tickFormatFunction: function tickFormatFunction(tick, index, ticks) {\n                    var formattedTick = tick.format(this.displayFormat);\n\n                    if (this.options.ticks.userCallback) {\n                        return this.options.ticks.userCallback(formattedTick, index, ticks);\n                    } else {\n                        return formattedTick;\n                    }\n                },\n                convertTicksToLabels: function () {\n                    this.tickMoments = this.ticks;\n                    this.ticks = this.ticks.map(this.tickFormatFunction, this);\n                },\n                getPixelForValue: function (value, index, datasetIndex, includeOffset) {\n                    var labelMoment = value && value.isValid && value.isValid() ? value : this.getLabelMoment(datasetIndex, index);\n\n                    if (labelMoment) {\n                        var offset = labelMoment.diff(this.firstTick, this.tickUnit, true);\n\n                        var decimal = offset / this.scaleSizeInUnits;\n\n                        if (this.isHorizontal()) {\n                            var innerWidth = this.width - (this.paddingLeft + this.paddingRight);\n                            var valueWidth = innerWidth / Math.max(this.ticks.length - 1, 1);\n                            var valueOffset = (innerWidth * decimal) + this.paddingLeft;\n\n                            return this.left + Math.round(valueOffset);\n                        } else {\n                            var innerHeight = this.height - (this.paddingTop + this.paddingBottom);\n                            var valueHeight = innerHeight / Math.max(this.ticks.length - 1, 1);\n                            var heightOffset = (innerHeight * decimal) + this.paddingTop;\n\n                            return this.top + Math.round(heightOffset);\n                        }\n                    }\n                },\n                getPixelForTick: function (index, includeOffset) {\n                    return this.getPixelForValue(this.tickMoments[index], null, null, includeOffset);\n                },\n                getValueForPixel: function (pixel) {\n                    var innerDimension = this.isHorizontal() ? this.width - (this.paddingLeft + this.paddingRight) : this.height - (this.paddingTop + this.paddingBottom);\n                    var offset = (pixel - (this.isHorizontal() ? this.left + this.paddingLeft : this.top + this.paddingTop)) / innerDimension;\n                    offset *= this.scaleSizeInUnits;\n                    return this.firstTick.clone().add(moment.duration(offset, this.tickUnit).asSeconds(), 'seconds');\n                },\n                parseTime: function (label) {\n                    if (typeof this.options.time.parser === 'string') {\n                        return moment(label, this.options.time.parser);\n                    }\n                    if (typeof this.options.time.parser === 'function') {\n                        return this.options.time.parser(label);\n                    }\n                    // Date objects\n                    if (typeof label.getMonth === 'function' || typeof label === 'number') {\n                        return moment(label);\n                    }\n                    // Moment support\n                    if (label.isValid && label.isValid()) {\n                        return label;\n                    }\n                    // Custom parsing (return an instance of moment)\n                    if (typeof this.options.time.format !== 'string' && this.options.time.format.call) {\n                        console.warn(\"options.time.format is deprecated and replaced by options.time.parser. See http://nnnick.github.io/Chart.js/docs-v2/#scales-time-scale\");\n                        return this.options.time.format(label);\n                    }\n                    // Moment format parsing\n                    return moment(label, this.options.time.format);\n                }\n            });\n            Chart.scaleService.registerScaleType(\"time\", TimeScale, defaultConfig);\n\n        };\n\n    }, { \"moment\": 1 }]\n}, {}, [7]);\n","Magento_Directory/js/region-updater.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function ($, mageTemplate, _) {\n    'use strict';\n\n    $.widget('mage.directoryRegionUpdater', {\n        options: {\n            regionTemplate:\n                '<option value=\"<%- data.value %>\" <% if (data.isSelected) { %>selected=\"selected\"<% } %>>' +\n                '<%- data.title %>' +\n                '</option>',\n            isRegionRequired: true,\n            isZipRequired: true,\n            isCountryRequired: true,\n            currentRegion: null,\n            isMultipleCountriesAllowed: true\n        },\n\n        /**\n         *\n         * @private\n         */\n        _create: function () {\n            this._initCountryElement();\n\n            this.currentRegionOption = this.options.currentRegion;\n            this.regionTmpl = mageTemplate(this.options.regionTemplate);\n\n            this._updateRegion(this.element.find('option:selected').val());\n\n            $(this.options.regionListId).on('change', $.proxy(function (e) {\n                this.setOption = false;\n                this.currentRegionOption = $(e.target).val();\n            }, this));\n\n            $(this.options.regionInputId).on('focusout', $.proxy(function () {\n                this.setOption = true;\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initCountryElement: function () {\n\n            if (this.options.isMultipleCountriesAllowed) {\n                this.element.parents('div.field').show();\n                this.element.on('change', $.proxy(function (e) {\n                    // clear region inputs on country change\n                    $(this.options.regionListId).val('');\n                    $(this.options.regionInputId).val('');\n                    this._updateRegion($(e.target).val());\n                }, this));\n\n                if (this.options.isCountryRequired) {\n                    this.element.addClass('required-entry');\n                    this.element.parents('div.field').addClass('required');\n                }\n            } else {\n                this.element.parents('div.field').hide();\n            }\n        },\n\n        /**\n         * Remove options from dropdown list\n         *\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @private\n         */\n        _removeSelectOptions: function (selectElement) {\n            selectElement.find('option').each(function (index) {\n                if (index) {\n                    $(this).remove();\n                }\n            });\n        },\n\n        /**\n         * Render dropdown list\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @param {String} key - region code\n         * @param {Object} value - region object\n         * @private\n         */\n        _renderSelectOption: function (selectElement, key, value) {\n            selectElement.append($.proxy(function () {\n                var name = value.name.replace(/[!\"#$%&'()*+,.\\/:;<=>?@[\\\\\\]^`{|}~]/g, '\\\\$&'),\n                    tmplData,\n                    tmpl;\n\n                if (value.code && $(name).is('span')) {\n                    key = value.code;\n                    value.name = $(name).text();\n                }\n\n                tmplData = {\n                    value: key,\n                    title: value.name,\n                    isSelected: false\n                };\n\n                if (this.options.defaultRegion === key) {\n                    tmplData.isSelected = true;\n                }\n\n                tmpl = this.regionTmpl({\n                    data: tmplData\n                });\n\n                return $(tmpl);\n            }, this));\n        },\n\n        /**\n         * Takes clearError callback function as first option\n         * If no form is passed as option, look up the closest form and call clearError method.\n         * @private\n         */\n        _clearError: function () {\n            var args = ['clearError', this.options.regionListId, this.options.regionInputId, this.options.postcodeId];\n\n            if (this.options.clearError && typeof this.options.clearError === 'function') {\n                this.options.clearError.call(this);\n            } else {\n                if (!this.options.form) {\n                    this.options.form = this.element.closest('form').length ? $(this.element.closest('form')[0]) : null;\n                }\n\n                this.options.form = $(this.options.form);\n\n                this.options.form && this.options.form.data('validator') &&\n                this.options.form.validation.apply(this.options.form, _.compact(args));\n\n                // Clean up errors on region & zip fix\n                $(this.options.regionInputId).removeClass('mage-error').parent().find('[generated]').remove();\n                $(this.options.regionListId).removeClass('mage-error').parent().find('[generated]').remove();\n                $(this.options.postcodeId).removeClass('mage-error').parent().find('[generated]').remove();\n            }\n        },\n\n        /**\n         * Update dropdown list based on the country selected\n         *\n         * @param {String} country - 2 uppercase letter for country code\n         * @private\n         */\n        _updateRegion: function (country) {\n            // Clear validation error messages\n            var regionList = $(this.options.regionListId),\n                regionInput = $(this.options.regionInputId),\n                postcode = $(this.options.postcodeId),\n                label = regionList.parent().siblings('label'),\n                container = regionList.parents('div.field'),\n                regionsEntries,\n                regionId,\n                regionData;\n\n            this._clearError();\n            this._checkRegionRequired(country);\n\n            // Populate state/province dropdown list if available or use input box\n            if (this.options.regionJson[country]) {\n                this._removeSelectOptions(regionList);\n                regionsEntries = _.pairs(this.options.regionJson[country]);\n                $.each(regionsEntries, $.proxy(function (key, value) {\n                    regionData = value[1];\n                    regionId = regionData.id;\n                    this._renderSelectOption(regionList, regionId.toString(), regionData);\n                }, this));\n\n                if (this.currentRegionOption) {\n                    regionList.val(this.currentRegionOption);\n                }\n\n                if (this.setOption) {\n                    regionList.find('option').filter(function () {\n                        return this.text === regionInput.val();\n                    }).attr('selected', true);\n                }\n\n                if (this.options.isRegionRequired) {\n                    regionList.addClass('required-entry').removeAttr('disabled');\n                    container.addClass('required').show();\n                } else {\n                    regionList.removeClass('required-entry validate-select').removeAttr('data-validate');\n                    container.removeClass('required');\n\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionList.hide();\n                        container.hide();\n                    } else {\n                        regionList.removeAttr('disabled').show();\n                    }\n                }\n\n                regionList.show();\n                regionInput.hide();\n                label.attr('for', regionList.attr('id'));\n            } else {\n                this._removeSelectOptions(regionList);\n\n                if (this.options.isRegionRequired) {\n                    regionInput.addClass('required-entry').removeAttr('disabled');\n                    container.addClass('required').show();\n                } else {\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionInput.attr('disabled', 'disabled');\n                        container.hide();\n                    }\n                    container.removeClass('required');\n                    regionInput.removeClass('required-entry');\n                }\n\n                regionList.removeClass('required-entry').prop('disabled', 'disabled').hide();\n                regionInput.show();\n                label.attr('for', regionInput.attr('id'));\n            }\n\n            // If country is in optionalzip list, make postcode input not required\n            if (this.options.isZipRequired) {\n                $.inArray(country, this.options.countriesWithOptionalZip) >= 0 ?\n                    postcode.removeClass('required-entry').closest('.field').removeClass('required') :\n                    postcode.addClass('required-entry').closest('.field').addClass('required');\n            }\n\n            // Add defaultvalue attribute to state/province select element\n            regionList.attr('defaultvalue', this.options.defaultRegion);\n            this.options.form.find('[type=\"submit\"]').removeAttr('disabled').show();\n        },\n\n        /**\n         * Check if the selected country has a mandatory region selection\n         *\n         * @param {String} country - Code of the country - 2 uppercase letter for country code\n         * @private\n         */\n        _checkRegionRequired: function (country) {\n            var self = this;\n\n            this.options.isRegionRequired = false;\n            $.each(this.options.regionJson.config['regions_required'], function (index, elem) {\n                if (elem === country) {\n                    self.options.isRegionRequired = true;\n                }\n            });\n        }\n    });\n\n    return $.mage.directoryRegionUpdater;\n});\n","Threedadv_Wishlist/js/add-to-wishlist.js":"define([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Customer/js/customer-data',\n    'mage/translate',\n    'mage/url'\n], function ($, alert, messageList, customerData,$t,urlBuilder) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).on('click', function (e) {\n            e.preventDefault();\n            var productId = $(this).data('product-id');\n\n            $.ajax({\n                url: config.addToWishlistUrl,\n                type: 'POST',\n                data: { product_id: productId },\n                dataType: 'json',\n                showLoader: true,\n                success: function (response) {\n                    \n                    if (response.success) {\n                       // Mostrar mensaje de \u00e9xito\n                       messageList.addSuccessMessage({\n                        message: response.message\n                    });\n                    customerData.set('messages', {\n                        messages: [{\n                            text: response.message,\n                            type: 'success'\n                        }]\n                    });\n                        \n                        if (response.action == \"add\") {\n                            $(element).children().attr(\"src\",urlBuilder.build('static/frontend/Sm/multe/es_MX/Threedadv_CarouselView/images/Heart.svg'));\n                            $(element).parent().parent().parent().parent().parent().before(`<div aria-atomic=\"true\" role=\"alert\" class=\"messages wishlist-message\">\n                                <div class=\"success-error success message\" data-ui-id=\"message-error\" style=\"width: fit-content;\">\n                                    <div>`+$t(response.message)+`</div>\n                                </div>\n                            </div>`);\n                            setTimeout(() => {\n                                $('.wishlist-message').remove();\n                            },3000);\n                        }else{\n                            $(element).children('img').attr(\"src\",urlBuilder.build('static/frontend/Sm/multe/es_MX/Threedadv_CarouselView/images/Favorite.png'));\n                            $(element).parent().parent().parent().parent().parent().before(`<div aria-atomic=\"true\" role=\"alert\" class=\"messages wishlist-message\">\n                                <div class=\"message-success success message\" data-ui-id=\"message-error\" style=\"width: fit-content;\">\n                                    <div>`+$t(response.message)+`</div>\n                                </div>\n                            </div>`);\n                            setTimeout(() => {\n                                $('.wishlist-message').remove();\n                            }, 3000);\n                        }\n                    } else {\n                        \n                       // Mostrar mensaje de error\n                       $(element).parent().parent().parent().parent().parent().before(`<div aria-atomic=\"true\" role=\"alert\" class=\"messages wishlist-message\">\n                            <div class=\"message-success success message\" data-ui-id=\"message-error\" style=\"width: fit-content;\">\n                                <div>`+$t(response.message)+`</div>\n                            </div>\n                        </div>`);\n                        setTimeout(() => {\n                            $('.wishlist-message').remove();\n                        }, 3000);\n                    }\n                },\n                error: function () {\n                    // Mostrar mensaje de error gen\u00e9rico\n                    $(element).parent().parent().parent().parent().parent().before(`<div aria-atomic=\"true\" role=\"alert\" class=\"messages wishlist-message\">\n                        <div class=\"message-error error message\" data-ui-id=\"message-error\" style=\"width: fit-content;\">\n                            <div>`+$t(response.message)+`</div>\n                        </div>\n                    </div>`);\n                    setTimeout(() => {\n                        $('.wishlist-message').remove();\n                    }, 3000);\n                }\n            });\n        });\n    };\n});","Magento_Search/js/form-mini.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'matchMedia',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/core',\n    'mage/translate'\n], function ($, _, mageTemplate, mediaCheck) {\n    'use strict';\n\n    /**\n     * Check whether the incoming string is not empty or if doesn't consist of spaces.\n     *\n     * @param {String} value - Value to check.\n     * @returns {Boolean}\n     */\n    function isEmpty(value) {\n        return value.length === 0 || value == null || /^\\s+$/.test(value);\n    }\n\n    $.widget('mage.quickSearch', {\n        options: {\n            autocomplete: 'off',\n            minSearchLength: 3,\n            responseFieldElements: 'ul li',\n            selectClass: 'selected',\n            template:\n                '<li class=\"<%- data.row_class %>\" id=\"qs-option-<%- data.index %>\" role=\"option\">' +\n                '<span class=\"qs-option-name\">' +\n                ' <%- data.title %>' +\n                '</span>' +\n                '<span aria-hidden=\"true\" class=\"amount\">' +\n                '<%- data.num_results %>' +\n                '</span>' +\n                '</li>',\n            submitBtn: 'button[type=\"submit\"]',\n            searchLabel: '[data-role=minisearch-label]',\n            isExpandable: null,\n            suggestionDelay: 300\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.responseList = {\n                indexList: null,\n                selected: null\n            };\n            this.autoComplete = $(this.options.destinationSelector);\n            this.searchForm = $(this.options.formSelector);\n            this.submitBtn = this.searchForm.find(this.options.submitBtn)[0];\n            this.searchLabel = this.searchForm.find(this.options.searchLabel);\n            this.isExpandable = this.options.isExpandable;\n\n            _.bindAll(this, '_onKeyDown', '_onPropertyChange', '_onSubmit');\n\n            this.submitBtn.disabled = true;\n\n            this.element.attr('autocomplete', this.options.autocomplete);\n\n            mediaCheck({\n                media: '(max-width: 768px)',\n                entry: function () {\n                    this.isExpandable = true;\n                }.bind(this),\n                exit: function () {\n                    this.isExpandable = true;\n                }.bind(this)\n            });\n\n            this.searchLabel.on('click', function (e) {\n                // allow input to lose its' focus when clicking on label\n                if (this.isExpandable && this.isActive()) {\n                    e.preventDefault();\n                }\n            }.bind(this));\n\n            this.element.on('blur', $.proxy(function () {\n                if (!this.searchLabel.hasClass('active')) {\n                    return;\n                }\n\n                setTimeout($.proxy(function () {\n                    if (this.autoComplete.is(':hidden')) {\n                        this.setActiveState(false);\n                    } else {\n                        this.element.trigger('focus');\n                    }\n                    this.autoComplete.hide();\n                    this._updateAriaHasPopup(false);\n                }, this), 250);\n            }, this));\n\n            if (this.element.get(0) === document.activeElement) {\n                this.setActiveState(true);\n            }\n\n            this.element.on('focus', this.setActiveState.bind(this, true));\n            this.element.on('keydown', this._onKeyDown);\n            // Prevent spamming the server with requests by waiting till the user has stopped typing for period of time\n            this.element.on('input propertychange', _.debounce(this._onPropertyChange, this.options.suggestionDelay));\n\n            this.searchForm.on('submit', $.proxy(function (e) {\n                this._onSubmit(e);\n                this._updateAriaHasPopup(false);\n            }, this));\n        },\n\n        /**\n         * Checks if search field is active.\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            return this.searchLabel.hasClass('active');\n        },\n\n        /**\n         * Sets state of the search field to provided value.\n         *\n         * @param {Boolean} isActive\n         */\n        setActiveState: function (isActive) {\n            var searchValue;\n\n            this.searchForm.toggleClass('active', isActive);\n            this.searchLabel.toggleClass('active', isActive);\n\n            if (this.isExpandable) {\n                this.element.attr('aria-expanded', isActive);\n                searchValue = this.element.val();\n                this.element.val('');\n                this.element.val(searchValue);\n            }\n        },\n\n        /**\n         * @private\n         * @return {Element} The first element in the suggestion list.\n         */\n        _getFirstVisibleElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.first() : false;\n        },\n\n        /**\n         * @private\n         * @return {Element} The last element in the suggestion list.\n         */\n        _getLastElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.last() : false;\n        },\n\n        /**\n         * @private\n         * @param {Boolean} show - Set attribute aria-haspopup to \"true/false\" for element.\n         */\n        _updateAriaHasPopup: function (show) {\n            if (show) {\n                this.element.attr('aria-haspopup', 'true');\n            } else {\n                this.element.attr('aria-haspopup', 'false');\n            }\n        },\n\n        /**\n         * Clears the item selected from the suggestion list and resets the suggestion list.\n         * @private\n         * @param {Boolean} all - Controls whether to clear the suggestion list.\n         */\n        _resetResponseList: function (all) {\n            this.responseList.selected = null;\n\n            if (all === true) {\n                this.responseList.indexList = null;\n            }\n        },\n\n        /**\n         * Executes when the search box is submitted. Sets the search input field to the\n         * value of the selected item.\n         * @private\n         * @param {Event} e - The submit event\n         */\n        _onSubmit: function (e) {\n            var value = this.element.val();\n\n            if (isEmpty(value)) {\n                e.preventDefault();\n            }\n\n            if (this.responseList.selected) {\n                this.element.val(this.responseList.selected.find('.qs-option-name').text());\n            }\n        },\n\n        /**\n         * Executes when keys are pressed in the search input field. Performs specific actions\n         * depending on which keys are pressed.\n         * @private\n         * @param {Event} e - The key down event\n         * @return {Boolean} Default return type for any unhandled keys\n         */\n        _onKeyDown: function (e) {\n            var keyCode = e.keyCode || e.which;\n\n            switch (keyCode) {\n                case $.ui.keyCode.HOME:\n                    if (this._getFirstVisibleElement()) {\n                        this._getFirstVisibleElement().addClass(this.options.selectClass);\n                        this.responseList.selected = this._getFirstVisibleElement();\n                    }\n                    break;\n\n                case $.ui.keyCode.END:\n                    if (this._getLastElement()) {\n                        this._getLastElement().addClass(this.options.selectClass);\n                        this.responseList.selected = this._getLastElement();\n                    }\n                    break;\n\n                case $.ui.keyCode.ESCAPE:\n                    this._resetResponseList(true);\n                    this.autoComplete.hide();\n                    break;\n\n                case $.ui.keyCode.ENTER:\n                    if (this.element.val().length >= parseInt(this.options.minSearchLength, 10)) {\n                        this.searchForm.trigger('submit');\n                        e.preventDefault();\n                    }\n                    break;\n\n                case $.ui.keyCode.DOWN:\n                    if (this.responseList.indexList) {\n                        if (!this.responseList.selected) {  //eslint-disable-line max-depth\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        } else if (!this._getLastElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected\n                                .removeClass(this.options.selectClass).next().addClass(this.options.selectClass);\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                        this._updateAriaHasPopup(true);\n                        this.autoComplete.show();\n                    }\n                    break;\n\n                case $.ui.keyCode.UP:\n                    if (this.responseList.indexList !== null) {\n                        if (!this._getFirstVisibleElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected\n                                .removeClass(this.options.selectClass).prev().addClass(this.options.selectClass);\n\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getLastElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getLastElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                        this._updateAriaHasPopup(true);\n                        this.autoComplete.show();\n                    }\n                    break;\n                default:\n                    return true;\n            }\n        },\n\n        /**\n         * Executes when the value of the search input field changes. Executes a GET request\n         * to populate a suggestion list based on entered text. Handles click (select), hover,\n         * and mouseout events on the populated suggestion list dropdown.\n         * @private\n         */\n        _onPropertyChange: function () {\n            var searchField = this.element,\n                clonePosition = {\n                    position: 'absolute',\n                    // Removed to fix display issues\n                    // left: searchField.offset().left,\n                    // top: searchField.offset().top + searchField.outerHeight(),\n                    width: searchField.outerWidth()\n                },\n                source = this.options.template,\n                template = mageTemplate(source),\n                dropdown = $('<ul role=\"listbox\"></ul>'),\n                value = this.element.val();\n\n            this.submitBtn.disabled = true;\n\n            if (value.length >= parseInt(this.options.minSearchLength, 10)) {\n                this.submitBtn.disabled = false;\n\n                if (this.options.url !== '') { //eslint-disable-line eqeqeq\n                    $.getJSON(this.options.url, {\n                        q: value\n                    }, $.proxy(function (data) {\n                        if (data.length) {\n                            $.each(data, function (index, element) {\n                                var html;\n\n                                element.index = index;\n                                html = template({\n                                    data: element\n                                });\n                                dropdown.append(html);\n                            });\n\n                            this._resetResponseList(true);\n\n                            this.responseList.indexList = this.autoComplete.html(dropdown)\n                                .css(clonePosition)\n                                .show()\n                                .find(this.options.responseFieldElements + ':visible');\n\n                            this.element.removeAttr('aria-activedescendant');\n\n                            if (this.responseList.indexList.length) {\n                                this._updateAriaHasPopup(true);\n                            } else {\n                                this._updateAriaHasPopup(false);\n                            }\n\n                            this.responseList.indexList\n                                .on('click', function (e) {\n                                    this.responseList.selected = $(e.currentTarget);\n                                    this.searchForm.trigger('submit');\n                                }.bind(this))\n                                .on('mouseenter mouseleave', function (e) {\n                                    this.responseList.indexList.removeClass(this.options.selectClass);\n                                    $(e.target).addClass(this.options.selectClass);\n                                    this.responseList.selected = $(e.target);\n                                    this.element.attr('aria-activedescendant', $(e.target).attr('id'));\n                                }.bind(this))\n                                .on('mouseout', function (e) {\n                                    if (!this._getLastElement() &&\n                                        this._getLastElement().hasClass(this.options.selectClass)) {\n                                        $(e.target).removeClass(this.options.selectClass);\n                                        this._resetResponseList(false);\n                                    }\n                                }.bind(this));\n                        } else {\n                            this._resetResponseList(true);\n                            this.autoComplete.hide();\n                            this._updateAriaHasPopup(false);\n                            this.element.removeAttr('aria-activedescendant');\n                        }\n                    }, this));\n                }\n            } else {\n                this._resetResponseList(true);\n                this.autoComplete.hide();\n                this._updateAriaHasPopup(false);\n                this.element.removeAttr('aria-activedescendant');\n            }\n        }\n    });\n\n    return $.mage.quickSearch;\n});\n","Magento_Weee/js/tax-toggle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     * @param {jQuery.Event} e\n     */\n    function onToggle(config, e) {\n        var elem = $(e.currentTarget),\n            expandedClassName = config.expandedClassName || 'cart-tax-total-expanded';\n\n        elem.toggleClass(expandedClassName);\n\n        $(config.itemTaxId).toggle();\n    }\n\n    return function (data, el) {\n        $(el).on('click', onToggle.bind(null, data));\n    };\n});\n","Magento_Weee/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Weee/price/adjustment',\n            dataSource: '${ $.parentName }.provider',\n            //Weee configuration constants can be configured from backend\n            inclFptWithDesc: 1,//show FPT and description\n            inclFpt: 0, //show FPT attribute\n            exclFpt: 2, //do not show FPT\n            bothFptPrices: 3 //show price without FPT and with FPT and with description\n        },\n\n        /**\n         * Get Weee attributes.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeAttributes: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'];\n        },\n\n        /**\n         * Get Weee without Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTax: function (taxAmount) {\n            return taxAmount['amount_excl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithoutTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithoutTax(taxAmount);\n        },\n\n        /**\n         * Get Weee with Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTax: function (taxAmount) {\n            return taxAmount['tax_amount_incl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithTax(taxAmount);\n        },\n\n        /**\n         * Get Weee Tax name.\n         *\n         * @param {String} taxAmount\n         * @return {String} Weee name\n         */\n        getWeeTaxAttributeName: function (taxAmount) {\n            return taxAmount['attribute_code'];\n        },\n\n        /**\n         * Set price type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Check if Weee Tax must be shown.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isShown: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'].length;\n        },\n\n        /**\n         * Get Weee final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustment: function (row) {\n            return row['price_info']['extension_attributes']['weee_adjustment'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeAdjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustmentUnsanitizedHtml: function (row) {\n            return this.getWeeeAdjustment(row);\n        },\n\n        /**\n         * Return whether display setting is to display price including FPT only.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFpt: function () {\n            return +this.source.data.displayWeee === this.inclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * price including FPT and FPT description.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFptDescr: function () {\n            return +this.source.data.displayWeee === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price\n         * excluding FPT but including FPT description and final price.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFptDescr: function () {\n            return +this.source.data.displayWeee === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding FPT.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFpt: function () {\n            return +this.source.data.displayWeee === this.bothFptPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclTax: function () {\n            return +this.source.data.displayTaxes === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPricesTax: function () {\n            return +this.source.data.displayTaxes === this.bothFptPrices;\n        }\n    });\n});\n","Magento_Weee/js/view/cart/totals/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/weee'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        isFullMode: function () {\n            return true;\n        }\n    });\n});\n","Magento_Weee/js/view/checkout/summary/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Catalog/js/price-utils'\n], function (Component, quote, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/weee'\n        },\n        isIncludedInSubtotal: window.checkoutConfig.isIncludedInSubtotal,\n        totals: totals.totals,\n\n        /**\n         * @returns {Number}\n         */\n        getWeeeTaxSegment: function () {\n            var weee = totals.getSegment('weee_tax') || totals.getSegment('weee');\n\n            if (weee !== null && weee.hasOwnProperty('value')) {\n                return weee.value;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Get weee value\n         * @returns {String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getWeeeTaxSegment());\n        },\n\n        /**\n         * Weee display flag\n         * @returns {Boolean}\n         */\n        isDisplayed: function () {\n            return this.isFullMode() && this.getWeeeTaxSegment() > 0;\n        }\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/row_excl_tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/item/price/weee'\n], function (weee) {\n    'use strict';\n\n    return weee.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/item/price/row_excl_tax'\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getFinalRowDisplayPriceExclTax: function (item) {\n            var rowTotalExclTax = parseFloat(item['row_total']);\n\n            if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalExclTax += parseFloat(item['qty']) *\n                    parseFloat(item['weee_tax_applied_amount']);\n            }\n\n            return rowTotalExclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowDisplayPriceExclTax: function (item) {\n            var rowTotalExclTax = parseFloat(item['row_total']);\n\n            if (window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalExclTax += this.getRowWeeeTaxExclTax(item);\n            }\n\n            return rowTotalExclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowWeeeTaxExclTax: function (item) {\n            var totalWeeeTaxExclTaxApplied = 0,\n                weeeTaxAppliedAmounts;\n\n            if (item['weee_tax_applied']) {\n                weeeTaxAppliedAmounts = JSON.parse(item['weee_tax_applied']);\n                weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                    totalWeeeTaxExclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount['row_amount'], 0));\n                });\n            }\n\n            return totalWeeeTaxExclTaxApplied;\n        }\n\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/row_incl_tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/item/price/weee'\n], function (weee) {\n    'use strict';\n\n    return weee.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/item/price/row_incl_tax',\n            displayArea: 'row_incl_tax'\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getFinalRowDisplayPriceInclTax: function (item) {\n            var rowTotalInclTax = parseFloat(item['row_total_incl_tax']);\n\n            if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n            }\n\n            return rowTotalInclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowDisplayPriceInclTax: function (item) {\n            var rowTotalInclTax = parseFloat(item['row_total_incl_tax']);\n\n            if (window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n            }\n\n            return rowTotalInclTax;\n        },\n\n        /**\n         * @param {Object}item\n         * @return {Number}\n         */\n        getRowWeeeTaxInclTax: function (item) {\n            var totalWeeeTaxInclTaxApplied = 0,\n                weeeTaxAppliedAmounts;\n\n            if (item['weee_tax_applied']) {\n                weeeTaxAppliedAmounts = JSON.parse(item['weee_tax_applied']);\n                weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                    totalWeeeTaxInclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount['row_amount_incl_tax'], 0));\n                });\n            }\n\n            return totalWeeeTaxInclTaxApplied;\n        }\n\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isDisplayPriceWithWeeeDetails: function (item) {\n            if (!parseFloat(item['weee_tax_applied_amount']) || parseFloat(item['weee_tax_applied_amount'] <= 0)) {\n                return false;\n            }\n\n            return window.checkoutConfig.isDisplayPriceWithWeeeDetails;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isDisplayFinalPrice: function (item) {\n            if (!parseFloat(item['weee_tax_applied_amount'])) {\n                return false;\n            }\n\n            return window.checkoutConfig.isDisplayFinalPrice;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Array}\n         */\n        getWeeeTaxApplied: function (item) {\n            if (item['weee_tax_applied']) {\n                return JSON.parse(item['weee_tax_applied']);\n            }\n\n            return [];\n        }\n    });\n});\n","Magento_Reports/js/recently-viewed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.recentlyViewedProducts', {\n        options: {\n            localStorageKey: 'recently-viewed-products',\n            productBlock: '#widget_viewed_item',\n            viewedContainer: 'ol'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            var productHtml = $(this.options.productBlock).html(),\n                productSku = $(this.options.productBlock).data('sku'),\n                products = JSON.parse(window.localStorage.getItem(this.options.localStorageKey)),\n                productsLength, maximum, showed, index;\n\n            if (products) {\n                productsLength = products.sku.length;\n                maximum = $(this.element).data('count');\n                showed = 0;\n\n                for (index = 0; index <= productsLength; index++) {\n                    if (products.sku[index] == productSku || showed >= maximum) { //eslint-disable-line\n                        products.sku.splice(index, 1);\n                        products.html.splice(index, 1);\n                    } else {\n                        $(this.element).find(this.options.viewedContainer).append(products.html[index]);\n                        $(this.element).show();\n                        showed++;\n                    }\n                }\n                $(this.element).find(this.options.productBlock).show();\n            } else {\n                products = {};\n                products.sku = [];\n                products.html = [];\n            }\n            products.sku.unshift(productSku);\n            products.html.unshift(productHtml);\n            window.localStorage.setItem(this.options.localStorageKey, JSON.stringify(products));\n        }\n    });\n\n    return $.mage.recentlyViewedProducts;\n});\n","Magento_Usps/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../model/shipping-rates-validator',\n    '../model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    uspsShippingRatesValidator,\n    uspsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('usps', uspsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('usps', uspsShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_Usps/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var rules = validationRules.getRules(),\n                self = this;\n\n            $.each(rules, function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            if (!this.validationErrors.length) {\n                if (address['country_id'] == checkoutConfig.originCountryCode) { //eslint-disable-line eqeqeq\n                    return !utils.isEmpty(address.postcode);\n                }\n\n                return true;\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Usps/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                },\n                'postcode': {\n                    'required': false\n                }\n            };\n        }\n    };\n});\n","Magento_GiftMessage/js/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.giftOptions', {\n        options: {\n            mageError: 'mage-error',\n            noDisplay: 'no-display',\n            requiredEntry: 'required-entry'\n        },\n\n        /**\n         * Initial toggle of the various gift options after widget instantiation.\n         * @private\n         */\n        _init: function () {\n            this._toggleVisibility();\n        },\n\n        /**\n         * Bind a click handler to the widget's context element.\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._toggleVisibility, this));\n            $(this.element.data('selector').id).find('.giftmessage-area')\n                .on('change', $.proxy(this._toggleRequired, this));\n        },\n\n        /**\n         * Toggle the visibility of the widget's context element's selector(s).\n         * @private\n         * @param {jQuery.Event} event - Click event. Target is a checkbox.\n         */\n        _toggleVisibility: function (event) {\n            var checkbox = event ? $(event.target) : this.element,\n                container = $(checkbox.data('selector').id),\n                _this;\n\n            if (checkbox.is(':checked')) {\n                container.show()\n                    .find('.giftmessage-area:not(:visible)').each(function (x, element) {\n                        if ($(element).val().length > 0) {\n                            $(element).trigger('change');\n                            container.find('a').trigger('click');\n                        }\n                    });\n            } else {\n                _this = this;\n                container.hide()\n                    .find('.input-text:not(.giftmessage-area)').each(function (x, element) {\n                        $(element).val(element.defaultValue).removeClass(_this.options.mageError)\n                            .next('div.' + _this.options.mageError).remove();\n                    }).end()\n                    .find('.giftmessage-area').val('').change().end()\n                    .find('.select').val('').change().end()\n                    .find('.checkbox:checked').prop('checked', false).trigger('click').prop('checked', false).end()\n                    .find('.price-box').addClass(this.options.noDisplay).end();\n            }\n        },\n\n        /**\n         * Make the From and To input fields required if a gift message has been written.\n         * @private\n         * @param {jQuery.Event} event - Change event. Target is a textarea.\n         */\n        _toggleRequired: function (event) {\n            var textArea = $(event.target),\n                length = textArea.val().length;\n\n            textArea.closest('li').prev('.fields')\n                .find('.input-text').toggleClass(this.options.requiredEntry, length > 0);\n        }\n    });\n\n    return $.mage.giftOptions;\n});\n","Magento_GiftMessage/js/view/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_GiftMessage/js/model/gift-message',\n    'Magento_GiftMessage/js/model/gift-options',\n    'Magento_GiftMessage/js/action/gift-options'\n], function (Component, GiftMessage, giftOptions, giftOptionsService) {\n    'use strict';\n\n    return Component.extend({\n        formBlockVisibility: null,\n        resultBlockVisibility: null,\n        model: {},\n\n        /**\n         * Component init\n         */\n        initialize: function () {\n            var self = this,\n                model;\n\n            this._super()\n                .observe('formBlockVisibility')\n                .observe({\n                    'resultBlockVisibility': false\n                });\n\n            this.itemId = this.itemId || 'orderLevel';\n            model = new GiftMessage(this.itemId);\n            this.model = model;\n            this.isResultBlockVisible();\n            giftOptions.addOption(model);\n\n            this.model.getObservable('isClear').subscribe(function (value) {\n                if (value == true) { //eslint-disable-line eqeqeq\n                    self.formBlockVisibility(false);\n                    self.model.getObservable('alreadyAdded')(true);\n                }\n            });\n        },\n\n        /**\n         * Is reslt block visible\n         */\n        isResultBlockVisible: function () {\n            var self = this;\n\n            if (this.model.getObservable('alreadyAdded')()) {\n                this.resultBlockVisibility(true);\n            }\n            this.model.getObservable('additionalOptionsApplied').subscribe(function (value) {\n                if (value == true) { //eslint-disable-line eqeqeq\n                    self.resultBlockVisibility(true);\n                }\n            });\n        },\n\n        /**\n         * @param {String} key\n         * @return {*}\n         */\n        getObservable: function (key) {\n            return this.model.getObservable(key);\n        },\n\n        /**\n         * Hide\\Show form block\n         */\n        toggleFormBlockVisibility: function () {\n            if (!this.model.getObservable('alreadyAdded')()) {\n                this.formBlockVisibility(!this.formBlockVisibility());\n            } else {\n                this.resultBlockVisibility(!this.resultBlockVisibility());\n            }\n        },\n\n        /**\n         * Edit options\n         */\n        editOptions: function () {\n            this.resultBlockVisibility(false);\n            this.formBlockVisibility(true);\n        },\n\n        /**\n         * Delete options\n         */\n        deleteOptions: function () {\n            giftOptionsService(this.model, true);\n        },\n\n        /**\n         * Hide form block\n         */\n        hideFormBlock: function () {\n            this.formBlockVisibility(false);\n\n            if (this.model.getObservable('alreadyAdded')()) {\n                this.resultBlockVisibility(true);\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        hasActiveOptions: function () {\n            var regionData = this.getRegion('additionalOptions'),\n                options = regionData(),\n                i;\n\n            for (i = 0; i < options.length; i++) {\n                if (options[i].isActive()) {\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return this.model.isGiftMessageAvailable();\n        },\n\n        /**\n         * Submit options\n         */\n        submitOptions: function () {\n            giftOptionsService(this.model);\n        }\n    });\n});\n","Magento_GiftMessage/js/action/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_GiftMessage/js/model/url-builder',\n    'mage/storage',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/error-processor',\n    'mage/url',\n    'Magento_Checkout/js/model/quote',\n    'underscore'\n], function (urlBuilder, storage, messageList, errorProcessor, url, quote, _) {\n    'use strict';\n\n    return function (giftMessage, remove) {\n        var serviceUrl;\n\n        url.setBaseUrl(giftMessage.getConfigValue('baseUrl'));\n\n        if (giftMessage.getConfigValue('isCustomerLoggedIn')) {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message', {});\n\n            if (giftMessage.itemId != 'orderLevel') { //eslint-disable-line eqeqeq\n                serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message/:itemId', {\n                    itemId: giftMessage.itemId\n                });\n            }\n        } else {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/gift-message', {\n                cartId: quote.getQuoteId()\n            });\n\n            if (giftMessage.itemId != 'orderLevel') { //eslint-disable-line eqeqeq\n                serviceUrl = urlBuilder.createUrl(\n                    '/guest-carts/:cartId/gift-message/:itemId',\n                    {\n                        cartId: quote.getQuoteId(), itemId: giftMessage.itemId\n                    }\n                );\n            }\n        }\n        messageList.clear();\n\n        storage.post(\n            serviceUrl,\n            JSON.stringify({\n                'gift_message': giftMessage.getSubmitParams(remove)\n            })\n        ).done(function () {\n            giftMessage.reset();\n            _.each(giftMessage.getAfterSubmitCallbacks(), function (callback) {\n                if (_.isFunction(callback)) {\n                    callback();\n                }\n            });\n        }).fail(function (response) {\n            errorProcessor.process(response);\n        });\n    };\n});\n","Magento_GiftMessage/js/model/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'ko'\n], function (_, ko) {\n    'use strict';\n\n    return {\n        options: ko.observableArray([]),\n\n        /**\n         * @param {Object} option\n         */\n        addOption: function (option) {\n            if (!this.options().hasOwnProperty(option.itemId)) {\n                this.options.push({\n                        id: option.itemId, value: option\n                    }\n                );\n            }\n        },\n\n        /**\n         * @param {*} itemId\n         * @return {*}\n         */\n        getOptionByItemId: function (itemId) {\n            var option = null;\n\n            _.each(this.options(), function (data) {\n                if (data.id === itemId) {\n                    option = data.value;\n\n                    return false;\n                }\n            });\n\n            return option;\n        }\n    };\n});\n","Magento_GiftMessage/js/model/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'underscore',\n    'mage/url'\n], function (uiElement, _, url) {\n    'use strict';\n\n    var provider = uiElement();\n\n    return function (itemId) {\n        var model = {\n            id: 'message-' + itemId,\n            itemId: itemId,\n            observables: {},\n            additionalOptions: [],\n            submitParams: [\n                'recipient',\n                'sender',\n                'message'\n            ],\n\n            /**\n             * Initialize.\n             */\n            initialize: function () {\n                var message = false;\n\n                this.getObservable('alreadyAdded')(false);\n\n                if (this.itemId == 'orderLevel') { //eslint-disable-line eqeqeq\n                    message = window.giftOptionsConfig.giftMessage.hasOwnProperty(this.itemId) ?\n                        window.giftOptionsConfig.giftMessage[this.itemId] :\n                        null;\n                } else {\n                    message =\n                        window.giftOptionsConfig.giftMessage.hasOwnProperty('itemLevel') &&\n                        window.giftOptionsConfig.giftMessage.itemLevel.hasOwnProperty(this.itemId) ?\n                            window.giftOptionsConfig.giftMessage.itemLevel[this.itemId].message :\n                            null;\n                }\n\n                if (_.isObject(message)) {\n                    this.getObservable('recipient')(message.recipient);\n                    this.getObservable('sender')(message.sender);\n                    this.getObservable('message')(message.message);\n                    this.getObservable('alreadyAdded')(true);\n                }\n            },\n\n            /**\n             * @param {String} key\n             * @return {*}\n             */\n            getObservable: function (key) {\n                this.initObservable(this.id, key);\n\n                return provider[this.getUniqueKey(this.id, key)];\n            },\n\n            /**\n             * @param {String} node\n             * @param {String} key\n             */\n            initObservable: function (node, key) {\n                if (node && !this.observables.hasOwnProperty(node)) {\n                    this.observables[node] = [];\n                }\n\n                if (key && this.observables[node].indexOf(key) === -1) {\n                    this.observables[node].push(key);\n                    provider.observe(this.getUniqueKey(node, key));\n                }\n            },\n\n            /**\n             * @param {String} node\n             * @param {String} key\n             * @return {String}\n             */\n            getUniqueKey: function (node, key) {\n                return node + '-' + key;\n            },\n\n            /**\n             * @param {String} key\n             * @return {null}\n             */\n            getConfigValue: function (key) {\n                return window.giftOptionsConfig.hasOwnProperty(key) ?\n                    window.giftOptionsConfig[key]\n                    : null;\n            },\n\n            /**\n             * Reset.\n             */\n            reset: function () {\n                this.getObservable('isClear')(true);\n            },\n\n            /**\n             * @return {Array}\n             */\n            getAfterSubmitCallbacks: function () {\n                var callbacks = [];\n\n                callbacks.push(this.afterSubmit);\n                _.each(this.additionalOptions, function (option) {\n                    if (_.isFunction(option.afterSubmit)) {\n                        callbacks.push(option.afterSubmit);\n                    }\n                });\n\n                return callbacks;\n            },\n\n            /**\n             * After submit.\n             */\n            afterSubmit: function () {\n                window.location.href = url.build('checkout/cart/updatePost') +\n                    '?form_key=' + window.checkoutConfig.formKey +\n                    '&cart[]';\n            },\n\n            /**\n             * @param {Boolean} remove\n             * @return {Object}\n             */\n            getSubmitParams: function (remove) {\n                var params = {},\n                    self = this;\n\n                _.each(this.submitParams, function (key) {\n                    var observable = provider[self.getUniqueKey(self.id, key)];\n\n                    if (_.isFunction(observable)) {\n                        params[key] = remove ? null : observable();\n                    }\n                });\n\n                if (this.additionalOptions.length) {\n                    params['extension_attributes'] = {};\n                }\n                _.each(this.additionalOptions, function (option) {\n                    if (_.isFunction(option.getSubmitParams)) {\n                        params['extension_attributes'] = _.extend(\n                            params['extension_attributes'],\n                            option.getSubmitParams(remove)\n                        );\n                    }\n                });\n\n                return params;\n            },\n\n            /**\n             * Check if gift message can be displayed\n             *\n             * @returns {Boolean}\n             */\n            isGiftMessageAvailable: function () {\n                var isGloballyAvailable,\n                    giftMessageConfig,\n                    itemConfig;\n\n                // itemId represent gift message level: 'orderLevel' constant or cart item ID\n                if (this.itemId === 'orderLevel') {\n                    return this.getConfigValue('isOrderLevelGiftOptionsEnabled');\n                }\n\n                // gift message product configuration must override system configuration\n                isGloballyAvailable = this.getConfigValue('isItemLevelGiftOptionsEnabled');\n                giftMessageConfig = window.giftOptionsConfig.giftMessage;\n                itemConfig = giftMessageConfig.hasOwnProperty('itemLevel') &&\n                    giftMessageConfig.itemLevel.hasOwnProperty(this.itemId) ?\n                    giftMessageConfig.itemLevel[this.itemId] :\n                    {};\n\n                return itemConfig.hasOwnProperty('is_available') ? itemConfig['is_available'] : isGloballyAvailable;\n            }\n        };\n\n        model.initialize();\n\n        return model;\n    };\n});\n","Magento_GiftMessage/js/model/url-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/url-builder'\n], function ($, urlBuilder) {\n    'use strict';\n\n    return $.extend(urlBuilder, {\n        storeCode: window.giftOptionsConfig.storeCode\n    });\n});\n","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * UnsanitizedHtml version of getTax.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTaxUnsanitizedHtml: function (row) {\n            return this.getTax(row);\n        },\n\n        /**\n         * Set price tax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals'\n], function (Component, quote, priceUtils, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isFullTaxSummaryDisplayed: window.checkoutConfig.isFullTaxSummaryDisplayed || false,\n            template: 'Magento_Tax/checkout/summary/grand-total'\n        },\n        totals: quote.getTotals(),\n        isTaxDisplayedInGrandTotal: window.checkoutConfig.includeTaxInGrandTotal || false,\n\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = totals.getSegment('grand_total').value;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getBaseValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['base_grand_total'];\n            }\n\n            return priceUtils.formatPriceLocale(price, quote.getBasePriceFormat());\n        },\n\n        /**\n         * @return {*}\n         */\n        getGrandTotalExclTax: function () {\n            var total = this.totals(),\n                amount;\n\n            if (!total) {\n                return 0;\n            }\n\n            amount = total['grand_total'] - total['tax_amount'];\n\n            if (amount < 0) {\n                amount = 0;\n            }\n\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBaseGrandTotalDisplayNeeded: function () {\n            var total = this.totals();\n\n            if (!total) {\n                return false;\n            }\n\n            return total['base_currency_code'] != total['quote_currency_code']; //eslint-disable-line eqeqeq\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/totals',\n    'mage/translate',\n    'underscore'\n], function (ko, Component, quote, totals, $t, _) {\n    'use strict';\n\n    var isTaxDisplayedInGrandTotal = window.checkoutConfig.includeTaxInGrandTotal,\n        isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed,\n        taxAmount = 0,\n        rates = 0;\n\n    return Component.extend({\n        defaults: {\n            isTaxDisplayedInGrandTotal: isTaxDisplayedInGrandTotal,\n            notCalculatedMessage: $t('Not yet calculated'),\n            template: 'Magento_Tax/checkout/summary/tax'\n        },\n        totals: quote.getTotals(),\n        isFullTaxSummaryDisplayed: isFullTaxSummaryDisplayed,\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowValue: function () {\n            if (this.isFullMode() && this.getPureValue() == 0) { //eslint-disable-line eqeqeq\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowDetails: function () {\n            if (!this.isFullMode()) {\n                return false;\n            }\n\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            var amount = 0,\n                taxTotal;\n\n            if (this.totals()) {\n                taxTotal = totals.getSegment('tax');\n\n                if (taxTotal) {\n                    amount = taxTotal.value;\n                }\n            }\n\n            return amount;\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && totals.getSegment('tax') != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getValue: function () {\n            var amount;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            amount = totals.getSegment('tax').value;\n\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} amount\n         * @return {*|String}\n         */\n        formatPrice: function (amount) {\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} parent\n         * @param {*} percentage\n         * @return {*|String}\n         */\n        getTaxAmount: function (parent, percentage) {\n            var totalPercentage = 0;\n\n            taxAmount = parent.amount;\n            rates = parent.rates;\n            _.each(rates, function (rate) {\n                totalPercentage += parseFloat(rate.percent);\n            });\n\n            return this.getFormattedPrice(this.getPercentAmount(taxAmount, totalPercentage, percentage));\n        },\n\n        /**\n         * @param {*} amount\n         * @param {*} totalPercentage\n         * @param {*} percentage\n         * @return {*|String}\n         */\n        getPercentAmount: function (amount, totalPercentage, percentage) {\n            return parseFloat(amount * percentage / totalPercentage);\n        },\n\n        /**\n         * @return {Array}\n         */\n        getDetails: function () {\n            var taxSegment = totals.getSegment('tax');\n\n            if (taxSegment && taxSegment['extension_attributes']) {\n                return taxSegment['extension_attributes']['tax_grandtotal_details'];\n            }\n\n            return [];\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function ($, Component, quote) {\n    'use strict';\n\n    var displayMode = window.checkoutConfig.reviewShippingDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displayMode: displayMode,\n            template: 'Magento_Tax/checkout/summary/shipping'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displayMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingDisplayed: function () {\n            return this.displayMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isExcludingDisplayed: function () {\n            return this.displayMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && quote.shippingMethod() != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getIncludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_incl_tax'];\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*}\n         */\n        getExcludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_amount'];\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    var displaySubtotalMode = window.checkoutConfig.reviewTotalsDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displaySubtotalMode: displaySubtotalMode,\n            template: 'Magento_Tax/checkout/summary/subtotal'\n        },\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals().subtotal;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displaySubtotalMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingTaxDisplayed: function () {\n            return this.displaySubtotalMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValueInclTax: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['subtotal_incl_tax'];\n            }\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/item/details/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/item/details/subtotal'\n], function (subtotal) {\n    'use strict';\n\n    var displayPriceMode = window.checkoutConfig.reviewItemPriceDisplayMode || 'including';\n\n    return subtotal.extend({\n        defaults: {\n            displayPriceMode: displayPriceMode,\n            template: 'Magento_Tax/checkout/summary/item/details/subtotal'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceInclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceExclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueInclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total_incl_tax']);\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueExclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total']);\n        }\n\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/grand-total'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isDisplayed: function () {\n            return true;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/tax',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    var isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed;\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        ifShowValue: function () {\n            if (parseInt(this.getPureValue()) === 0) { //eslint-disable-line radix\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @override\n         */\n        ifShowDetails: function () {\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return this.totals() && totals.getSegment('tax') !== null;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return !!quote.shippingMethod();\n        },\n\n        /**\n         * @override\n         */\n        getShippingMethodTitle: function () {\n            return '(' + this._super() + ')';\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/shipping_method/price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils'\n], function (Component, quote, priceUtils) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Tax/checkout/shipping_method/price'\n        },\n        isDisplayShippingPriceExclTax: window.checkoutConfig.isDisplayShippingPriceExclTax,\n        isDisplayShippingBothPrices: window.checkoutConfig.isDisplayShippingBothPrices,\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isPriceEqual: function (item) {\n            return item['price_excl_tax'] != item['price_incl_tax']; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            //todo add format data\n            return priceUtils.formatPriceLocale(price, quote.getPriceFormat());\n        }\n    });\n});\n","Magefan_Blog/js/tagcanvas.min.js":"/**\n * Copyright (C) 2010-2021 Graham Breach\n *\n * This program is free software: you can redistribute it and/or modify\n * it under the terms of the GNU Lesser General Public License as published by\n * the Free Software Foundation, either version 3 of the License, or\n * (at your option) any later version.\n *\n * This program is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU Lesser General Public License for more details.\n * \n * You should have received a copy of the GNU Lesser General Public License\n * along with this program.  If not, see <http://www.gnu.org/licenses/>.\n */\n/**\n * TagCanvas 2.11\n * For more information, please contact <graham@goat1000.com>\n */\n(function(){\"use strict\";var r,C,p=Math.abs,o=Math.sin,l=Math.cos,g=Math.max,h=Math.min,af=Math.ceil,E=Math.sqrt,w=Math.pow,I={},D={},R={0:\"0,\",1:\"17,\",2:\"34,\",3:\"51,\",4:\"68,\",5:\"85,\",6:\"102,\",7:\"119,\",8:\"136,\",9:\"153,\",a:\"170,\",A:\"170,\",b:\"187,\",B:\"187,\",c:\"204,\",C:\"204,\",d:\"221,\",D:\"221,\",e:\"238,\",E:\"238,\",f:\"255,\",F:\"255,\"},f,d,b,T,z,F,M,c=document,v,e,P,j={};for(r=0;r<256;++r)C=r.toString(16),r<16&&(C='0'+C),D[C]=D[C.toUpperCase()]=r.toString()+',';function n(a){return typeof a!='undefined'}function B(a){return typeof a=='object'&&a!=null}function G(a,c,b){return isNaN(a)?b:h(b,g(c,a))}function x(){return!1}function q(){return(new Date).valueOf()}function ak(c,d){var b=[],e=c.length,a;for(a=0;a<e;++a)b.push(c[a]);return b.sort(d),b}function ai(a){for(var b=a.length-1,d,c;b;)c=~~(Math.random()*b),d=a[b],a[b]=a[c],a[c]=d,--b}function ag(){var a=window.AudioContext||window.webkitAudioContext;if(e=new a,!e){e='off';return}return e}function $(u,a,t,s,r,q,p){var j=s,h=r,i=t*.01,n=80*i,m=100*i,o=40*i,l=30*i,c=l/2,b=j+n,f=b-o,k=h+m,d=k-l,g=h+l,e=h+m/2;if(a.setTransform(1,0,0,1,0,0),a.setLineDash([]),a.globalAlpha=1,a.strokeStyle=p,a.lineWidth=q,a.lineJoin='round',a.beginPath(),a.moveTo(f,g),a.lineTo(f,d),a.moveTo(b,k),a.lineTo(f,d),a.lineTo(j,d),a.lineTo(j,g),a.lineTo(f,g),a.lineTo(b,h),u){a.lineTo(b,g),a.moveTo(b,d),a.lineTo(b,k),a.moveTo(b-c,e-c),a.lineTo(b+c,e+c),a.moveTo(b+c,e-c),a.lineTo(b-c,e+c),a.stroke();return}a.closePath(),a.stroke()}function s(a,b,c){this.x=a,this.y=b,this.z=c}z=s.prototype,z.length=function(){return E(this.x*this.x+this.y*this.y+this.z*this.z)},z.dot=function(a){return this.x*a.x+this.y*a.y+this.z*a.z},z.cross=function(a){var b=this.y*a.z-this.z*a.y,c=this.z*a.x-this.x*a.z,d=this.x*a.y-this.y*a.x;return new s(b,c,d)},z.angle=function(b){var c=this.dot(b),a;return c==0?Math.PI/2:(a=c/(this.length()*b.length()),a>=1)?0:a<=-1?Math.PI:Math.acos(a)},z.unit=function(){var a=this.length();return new s(this.x/a,this.y/a,this.z/a)};function ay(b,a){a=a*Math.PI/180,b=b*Math.PI/180;var c=o(b)*l(a),d=-o(a),e=-l(b)*l(a);return new s(c,d,e)}function m(a){this[1]={1:a[0],2:a[1],3:a[2]},this[2]={1:a[3],2:a[4],3:a[5]},this[3]={1:a[6],2:a[7],3:a[8]}}T=m.prototype,m.Identity=function(){return new m([1,0,0,0,1,0,0,0,1])},m.Rotation=function(e,a){var c=o(e),d=l(e),b=1-d;return new m([d+w(a.x,2)*b,a.x*a.y*b-a.z*c,a.x*a.z*b+a.y*c,a.y*a.x*b+a.z*c,d+w(a.y,2)*b,a.y*a.z*b-a.x*c,a.z*a.x*b-a.y*c,a.z*a.y*b+a.x*c,d+w(a.z,2)*b])},T.mul=function(c){var d=[],a,b,e=c.xform?1:0;for(a=1;a<=3;++a)for(b=1;b<=3;++b)e?d.push(this[a][1]*c[1][b]+this[a][2]*c[2][b]+this[a][3]*c[3][b]):d.push(this[a][b]*c);return new m(d)},T.xform=function(b){var a={},c=b.x,d=b.y,e=b.z;return a.x=c*this[1][1]+d*this[2][1]+e*this[3][1],a.y=c*this[1][2]+d*this[2][2]+e*this[3][2],a.z=c*this[1][3]+d*this[2][3]+e*this[3][3],a};function aB(g,j,k,m,f){var a,b,c,d,e=[],h=2/g,i;i=Math.PI*(3-E(5)+(parseFloat(f)?parseFloat(f):0));for(a=0;a<g;++a)b=a*h-1+h/2,c=E(1-b*b),d=a*i,e.push([l(d)*c*j,b*k,o(d)*c*m]);return e}function U(n,p,m,k,h,g){var b,f=[],i=2/n,j,a,d,c,e;j=Math.PI*(3-E(5)+(parseFloat(g)?parseFloat(g):0));for(a=0;a<n;++a)d=a*i-1+i/2,b=a*j,c=l(b),e=o(b),f.push(p?[d*m,c*k,e*h]:[c*m,d*k,e*h]);return f}function aa(k,e,f,h,i,j){var b,g=[],m=Math.PI*2/e,a,c,d;for(a=0;a<e;++a)b=a*m,c=l(b),d=o(b),g.push(k?[j*f,c*h,d*i]:[c*f,j*h,d*i]);return g}function ax(a,b,c,d,e){return U(a,0,b,c,d,e)}function aH(a,b,c,d,e){return U(a,1,b,c,d,e)}function aG(b,c,d,e,a){return a=isNaN(a)?0:a*1,aa(0,b,c,d,e,a)}function aF(b,c,d,e,a){return a=isNaN(a)?0:a*1,aa(1,b,c,d,e,a)}function av(b){var a=new Image;a.onload=function(){var c=a.width/2,d=a.height/2;b.centreFunc=function(b,g,h,e,f){b.setTransform(1,0,0,1,0,0),b.globalAlpha=1,b.drawImage(a,e-c,f-d)}},a.src=b.centreImage}function aE(a,c){var b=a,d,e,f=(c*1).toPrecision(3)+')';return a[0]==='#'?(I[a]||(a.length===4?I[a]='rgba('+R[a[1]]+R[a[2]]+R[a[3]]:I[a]='rgba('+D[a.substr(1,2)]+D[a.substr(3,2)]+D[a.substr(5,2)]),b=I[a]+f):a.substr(0,4)==='rgb('||a.substr(0,4)==='hsl('?b=a.replace('(','a(').replace(')',','+f):(a.substr(0,5)==='rgba('||a.substr(0,5)==='hsla(')&&(d=a.lastIndexOf(',')+1,e=a.indexOf(')'),c*=parseFloat(a.substring(d,e)),b=a.substr(0,d)+c.toPrecision(3)+')'),b}function k(b,d){if(window.G_vmlCanvasManager)return null;var a=c.createElement('canvas');return a.width=b,a.height=d,a}function aD(){var b=k(3,3),a,c;return!!b&&(a=b.getContext('2d'),a.strokeStyle='#000',a.shadowColor='#fff',a.shadowBlur=3,a.globalAlpha=0,a.strokeRect(2,2,2,2),a.globalAlpha=1,c=a.getImageData(2,2,1,1),b=null,c.data[0]>0)}function aC(a,c,f,d){var e=a.createLinearGradient(0,0,c,0),b;for(b in d)e.addColorStop(1-b,d[b]);a.fillStyle=e,a.fillRect(0,f,c,1)}function L(a,m,j){var l=1024,d=1,e=a.weightGradient,i,f,b,c;if(a.gCanvas)f=a.gCanvas.getContext('2d'),d=a.gCanvas.height;else{if(B(e[0])?d=e.length:e=[e],a.gCanvas=i=k(l,d),!i)return null;f=i.getContext('2d');for(b=0;b<d;++b)aC(f,l,b,e[b])}return j=g(h(j||0,d-1),0),c=f.getImageData(~~((l-1)*m),j,1,1).data,'rgba('+c[0]+','+c[1]+','+c[2]+','+c[3]/255+')'}function Y(b,i,q,k,o,n,h,d,a,g,f,l){var m=o+(d||0)+(a.length&&a[0]<0?p(a[0]):0),j=n+(d||0)+(a.length&&a[1]<0?p(a[1]):0),c,e;b.font=i,b.textBaseline='top',b.fillStyle=q,h&&(b.shadowColor=h),d&&(b.shadowBlur=d),a.length&&(b.shadowOffsetX=a[0],b.shadowOffsetY=a[1]);for(c=0;c<k.length;++c)e=0,f&&('right'==l?e=g-f[c]:'centre'==l&&(e=(g-f[c])/2)),b.fillText(k[c],m+e,j),j+=parseInt(i)}function y(d,a,b,f,e,c,g){c?(d.beginPath(),d.moveTo(a,b+e-c),d.arcTo(a,b,a+c,b,c),d.arcTo(a+f,b,a+f,b+c,c),d.arcTo(a+f,b+e,a+f-c,b+e,c),d.arcTo(a,b+e,a,b+e-c,c),d.closePath(),d[g?'stroke':'fill']()):d[g?'strokeRect':'fillRect'](a,b,f,e)}function O(a,b,c,d,e,f,g,h,i){this.strings=a,this.font=b,this.width=c,this.height=d,this.maxWidth=e,this.stringWidths=f,this.align=g,this.valign=h,this.scale=i}M=O.prototype,M.SetImage=function(a,b,c,d,e,f,g,h){this.image=a,this.iwidth=b*this.scale,this.iheight=c*this.scale,this.ipos=d,this.ipad=e*this.scale,this.iscale=h,this.ialign=f,this.ivalign=g},M.Align=function(c,d,a){var b=0;return a=='right'||a=='bottom'?b=d-c:a!='left'&&a!='top'&&(b=(d-c)/2),b},M.Create=function(G,D,F,b,A,m,q,j,E){var o,e,f,a,l,s,i,u,v,r,w,n,c,d,x,B=p(q[0]),C=p(q[1]),t,z;return j=g(j,B+m,C+m),l=2*(j+b),i=2*(j+b),e=this.width+l,f=this.height+i,v=r=j+b,this.image&&(w=n=j+b,c=this.iwidth,d=this.iheight,this.ipos=='top'||this.ipos=='bottom'?(c<this.width?w+=this.Align(c,this.width,this.ialign):v+=this.Align(this.width,c,this.align),this.ipos=='top'?r+=d+this.ipad:n+=this.height+this.ipad,e=g(e,c+l),f+=d+this.ipad):(d<this.height?n+=this.Align(d,this.height,this.ivalign):r+=this.Align(this.height,d,this.valign),this.ipos=='right'?w+=this.width+this.ipad:v+=c+this.ipad,e+=c+this.ipad,f=g(f,d+i))),o=k(e,f),!o?null:(l=i=b/2,s=e-b,u=f-b,x=h(E,s/2,u/2),a=o.getContext('2d'),D&&(a.fillStyle=D,y(a,l,i,s,u,x)),b&&(a.strokeStyle=F,a.lineWidth=b,y(a,l,i,s,u,x,!0)),(m||B||C)&&(t=k(e,f),t&&(z=a,a=t.getContext('2d'))),Y(a,this.font,G,this.strings,v,r,0,0,[],this.maxWidth,this.stringWidths,this.align),this.image&&a.drawImage(this.image,w,n,c,d),z&&(a=z,A&&(a.shadowColor=A),m&&(a.shadowBlur=m),a.shadowOffsetX=q[0],a.shadowOffsetY=q[1],a.drawImage(t,0,0)),o)};function H(a,c,d){var b=k(c,d),e;return b?(e=b.getContext('2d'),e.drawImage(a,(c-a.width)/2,(d-a.height)/2),b):null}function S(e,b,c){var a=k(b,c),d;return a?(d=a.getContext('2d'),d.drawImage(e,0,0,b,c),a):null}function W(n,u,t,e,s,c,v,d,r,w){var g=u+(2*d+c)*e,f=t+(2*d+c)*e,l=k(g,f),b,i,q,m,j,o,a,p;return l?(c*=e,r*=e,i=q=c/2,m=g-c,j=f-c,d=d*e+i,b=l.getContext('2d'),p=h(r,m/2,j/2),s&&(b.fillStyle=s,y(b,i,q,m,j,p)),c&&(b.strokeStyle=v,b.lineWidth=c,y(b,i,q,m,j,p,!0)),w?(o=k(g,f),a=o.getContext('2d'),a.drawImage(n,d,d,u,t),a.globalCompositeOperation='source-in',a.fillStyle=v,a.fillRect(0,0,g,f),a.globalCompositeOperation='destination-over',a.drawImage(l,0,0),a.globalCompositeOperation='source-over',b.drawImage(o,0,0)):b.drawImage(n,d,d,n.width,n.height),{image:l,width:g/e,height:f/e}):null}function at(l,f,c,d,j){var e,a,b=parseFloat(f),i=g(c,d);return e=k(c,d),!e?null:(f.indexOf('%')>0?b=i*b/100:b=b*j,a=e.getContext('2d'),a.globalCompositeOperation='source-over',a.fillStyle='#fff',b>=i/2?(b=h(c,d)/2,a.beginPath(),a.moveTo(c/2,d/2),a.arc(c/2,d/2,b,0,2*Math.PI,!1),a.fill(),a.closePath()):(b=h(c/2,d/2,b),y(a,0,0,c,d,b,!0),a.fill()),a.globalCompositeOperation='source-in',a.drawImage(l,0,0,c,d),e)}function ao(q,m,i,b,h,a,c){var g=p(c[0]),f=p(c[1]),j=m+(g>a?g+a:a*2)*b,l=i+(f>a?f+a:a*2)*b,n=b*((a||0)+(c[0]<0?g:0)),o=b*((a||0)+(c[1]<0?f:0)),e,d;return e=k(j,l),!e?null:(d=e.getContext('2d'),h&&(d.shadowColor=h),a&&(d.shadowBlur=a*b),c&&(d.shadowOffsetX=c[0]*b,d.shadowOffsetY=c[1]*b),d.drawImage(q,n,o,m,i),{image:e,width:j/b,height:l/b})}function ae(m,o,l){var c=parseInt(m.toString().length*l),h=parseInt(l*2*m.length),j=k(c,h),g,i,e,f,b,d,n,a;if(!j)return null;g=j.getContext('2d'),g.fillStyle='#000',g.fillRect(0,0,c,h),Y(g,l+'px '+o,'#fff',m,0,0,0,0,[],'centre'),i=g.getImageData(0,0,c,h),e=i.width,f=i.height,a={min:{x:e,y:f},max:{x:-1,y:-1}};for(d=0;d<f;++d)for(b=0;b<e;++b)n=(d*e+b)*4,i.data[n+1]>0&&(b<a.min.x&&(a.min.x=b),b>a.max.x&&(a.max.x=b),d<a.min.y&&(a.min.y=d),d>a.max.y&&(a.max.y=d));return e!=c&&(a.min.x*=c/e,a.max.x*=c/e),f!=h&&(a.min.y*=c/f,a.max.y*=c/f),j=null,a}function Q(a){return\"'\"+a.replace(/(\\'|\\\")/g,'').replace(/\\s*,\\s*/g,\"', '\")+\"'\"}function t(b,d,a){a=a||c,a.addEventListener?a.addEventListener(b,d,!1):a.attachEvent('on'+b,d)}function am(b,d,a){a=a||c,a.removeEventListener?a.removeEventListener(b,d):a.detachEvent('on'+b,d)}function A(g,e,j,a,b){var l=b.imageScale,h,c,k,m,f,d;if(!e.complete)return t('load',function(){A(g,e,j,a,b)},e);if(!g.complete)return t('load',function(){A(g,e,j,a,b)},g);if(j&&!j.complete)return t('load',function(){A(g,e,j,a,b)},j);e.width=e.width,e.height=e.height,l&&(g.width=e.width*l,g.height=e.height*l),a.iw=g.width,a.ih=g.height,b.txtOpt&&(c=g,h=b.zoomMax*b.txtScale,f=a.iw*h,d=a.ih*h,f<e.naturalWidth||d<e.naturalHeight?(c=S(g,f,d),c&&(a.fimage=c)):(f=a.iw,d=a.ih,h=1),parseFloat(b.imageRadius)&&(a.image=a.fimage=g=at(a.image,b.imageRadius,f,d,h)),a.HasText()||(b.shadow&&(c=ao(a.image,f,d,h,b.shadow,b.shadowBlur,b.shadowOffset),c&&(a.fimage=c.image,a.w=c.width,a.h=c.height)),(b.bgColour||b.bgOutlineThickness)&&(k=b.bgColour=='tag'?i(a.a,'background-color'):b.bgColour,m=b.bgOutline=='tag'?i(a.a,'color'):b.bgOutline||b.textColour,f=a.fimage.width,d=a.fimage.height,b.outlineMethod=='colour'&&(c=W(a.fimage,f,d,h,k,b.bgOutlineThickness,a.outline.colour,b.padding,b.bgRadius,1),c&&(a.oimage=c.image)),c=W(a.fimage,f,d,h,k,b.bgOutlineThickness,m,b.padding,b.bgRadius),c&&(a.fimage=c.image,a.w=c.width,a.h=c.height)),b.outlineMethod=='size'&&(b.outlineIncrease>0?(a.iw+=2*b.outlineIncrease,a.ih+=2*b.outlineIncrease,f=h*a.iw,d=h*a.ih,c=S(a.fimage,f,d),a.oimage=c,a.fimage=H(a.fimage,a.oimage.width,a.oimage.height)):(f=h*(a.iw+2*b.outlineIncrease),d=h*(a.ih+2*b.outlineIncrease),c=S(a.fimage,f,d),a.oimage=H(c,a.fimage.width,a.fimage.height))))),a.alt=j,a.Init()}function i(a,d){var b=c.defaultView,e=d.replace(/\\-([a-z])/g,function(a){return a.charAt(1).toUpperCase()});return b&&b.getComputedStyle&&b.getComputedStyle(a,null).getPropertyValue(d)||a.currentStyle&&a.currentStyle[e]}function aj(c,d,e){var b=1,a;return d?b=1*(c.getAttribute(d)||e):(a=i(c,'font-size'))&&(b=a.indexOf('px')>-1&&a.replace('px','')*1||a.indexOf('pt')>-1&&a.replace('pt','')*1.25||a*3.3),b}function u(a){return a.target&&n(a.target.id)?a.target.id:a.srcElement.parentNode.id}function K(a,c){var b,d,e=parseInt(i(c,'width'))/c.width,f=parseInt(i(c,'height'))/c.height;return n(a.offsetX)?b={x:a.offsetX,y:a.offsetY}:(d=X(c.id),n(a.changedTouches)&&(a=a.changedTouches[0]),a.pageX&&(b={x:a.pageX-d.x,y:a.pageY-d.y})),b&&e&&f&&(b.x/=e,b.y/=f),b}function an(c){var d=c.target||c.fromElement.parentNode,b=a.tc[d.id];b&&(b.mx=b.my=-1,b.UnFreeze(),b.EndDrag())}function ad(e){var g,c=a,b,d,f=u(e);for(g in c.tc)b=c.tc[g],b.tttimer&&(clearTimeout(b.tttimer),b.tttimer=null);f&&c.tc[f]&&(b=c.tc[f],(d=K(e,b.canvas))&&(b.mx=d.x,b.my=d.y,b.Drag(e,d)),b.drawn=0)}function ap(b){var e=a,f=c.addEventListener?0:1,d=u(b);d&&b.button==f&&e.tc[d]&&e.tc[d].BeginDrag(b)}function aq(b){var f=a,g=c.addEventListener?0:1,e=u(b),d;e&&b.button==g&&f.tc[e]&&(d=f.tc[e],ad(b),!d.EndDrag()&&!d.touchState&&d.Clicked(b))}function ar(c){var e=u(c),b=e&&a.tc[e],d;b&&c.changedTouches&&(c.touches.length==1&&b.touchState==0?(b.touchState=1,b.BeginDrag(c),(d=K(c,b.canvas))&&(b.mx=d.x,b.my=d.y,b.drawn=0)):c.targetTouches.length==2&&b.pinchZoom?(b.touchState=3,b.EndDrag(),b.BeginPinch(c)):(b.EndDrag(),b.EndPinch(),b.touchState=0))}function ac(c){var d=u(c),b=d&&a.tc[d];if(b&&c.changedTouches){switch(b.touchState){case 1:b.Draw(),b.Clicked();break;break;case 2:b.EndDrag();break;case 3:b.EndPinch()}b.touchState=0}}function au(c){var f,e=a,b,d,g=u(c);for(f in e.tc)b=e.tc[f],b.tttimer&&(clearTimeout(b.tttimer),b.tttimer=null);if(b=g&&e.tc[g],b&&c.changedTouches&&b.touchState){switch(b.touchState){case 1:case 2:(d=K(c,b.canvas))&&(b.mx=d.x,b.my=d.y,b.Drag(c,d)&&(b.touchState=2));break;case 3:b.Pinch(c)}b.drawn=0}}function ab(b){var d=a,c=u(b);c&&d.tc[c]&&(b.cancelBubble=!0,b.returnValue=!1,b.preventDefault&&b.preventDefault(),d.tc[c].Wheel((b.wheelDelta||b.detail)>0))}function aw(d){var c,b=a;clearTimeout(b.scrollTimer);for(c in b.tc)b.tc[c].Pause();b.scrollTimer=setTimeout(function(){var b,c=a;for(b in c.tc)c.tc[b].Resume()},b.scrollPause)}function al(){Z(q())}function Z(b){var c=a.tc,d;a.NextFrame(a.interval),b=b||q();for(d in c)c[d].Draw(b)}function az(){requestAnimationFrame(Z)}function aA(a){setTimeout(al,a)}function X(f){var g=c.getElementById(f),b=g.getBoundingClientRect(),a=c.documentElement,d=c.body,e=window,h=e.pageXOffset||a.scrollLeft,i=e.pageYOffset||a.scrollTop,j=a.clientLeft||d.clientLeft,k=a.clientTop||d.clientTop;return{x:b.left+h-j,y:b.top+i-k}}function aI(a,b,d,e){var c=a.radius*a.z1/(a.z1+a.z2+b.z);return{x:b.x*c*d,y:b.y*c*e,z:b.z,w:(a.z1-b.z)/a.z2}}function V(a){this.e=a,this.br=0,this.line=[],this.text=[],this.original=a.innerText||a.textContent}F=V.prototype,F.Empty=function(){for(var a=0;a<this.text.length;++a)if(this.text[a].length)return!1;return!0},F.Lines=function(c){var e=c?1:0,b,d,a;c=c||this.e,b=c.childNodes,d=b.length;for(a=0;a<d;++a)b[a].nodeName=='BR'?(this.text.push(this.line.join(' ')),this.br=1):b[a].nodeType==3?this.br?(this.line=[b[a].nodeValue],this.br=0):this.line.push(b[a].nodeValue):this.Lines(b[a]);return e||this.br||this.text.push(this.line.join(' ')),this.text},F.SplitWidth=function(h,e,f,g){var c,b,a,d=[];e.font=g+'px '+f;for(c=0;c<this.text.length;++c){a=this.text[c].split(/\\s+/),this.line=[a[0]];for(b=1;b<a.length;++b)e.measureText(this.line.join(' ')+' '+a[b]).width>h?(d.push(this.line.join(' ')),this.line=[a[b]]):this.line.push(a[b]);d.push(this.line.join(' '))}return this.text=d};function _(a,b){this.ts=null,this.tc=a,this.tag=b,this.x=this.y=this.w=this.h=this.sc=1,this.z=0,this.pulse=1,this.pulsate=a.pulsateTo<1,this.colour=a.outlineColour,this.adash=~~a.outlineDash,this.agap=~~a.outlineDashSpace||this.adash,this.aspeed=a.outlineDashSpeed*1,this.colour=='tag'?this.colour=i(b.a,'color'):this.colour=='tagbg'&&(this.colour=i(b.a,'background-color')),this.Draw=this.pulsate?this.DrawPulsate:this.DrawSimple,this.radius=a.outlineRadius|0,this.SetMethod(a.outlineMethod,a.altImage)}f=_.prototype,f.SetMethod=function(a,d){var b={block:['PreDraw','DrawBlock'],colour:['PreDraw','DrawColour'],outline:['PostDraw','DrawOutline'],classic:['LastDraw','DrawOutline'],size:['PreDraw','DrawSize'],none:['LastDraw']},c=b[a]||b.outline;a=='none'?this.Draw=function(){return 1}:this.drawFunc=this[c[1]],this[c[0]]=this.Draw,d&&(this.RealPreDraw=this.PreDraw,this.PreDraw=this.DrawAlt)},f.Update=function(d,e,i,j,a,f,g,h){var b=this.tc.outlineOffset,c=2*b;this.x=a*d+g-b,this.y=a*e+h-b,this.w=a*i+c,this.h=a*j+c,this.sc=a,this.z=f},f.Ants=function(k){if(!this.adash)return;var b=this.adash,c=this.agap,a=this.aspeed,j=b+c,h=0,g=b,f=c,i=0,d=0,e;a&&(d=p(a)*(q()-this.ts)/50,a<0&&(d=864e4-d),a=~~d%j),a?(b>=a?(h=b-a,g=a):(f=j-a,i=c-f),e=[h,f,g,i]):e=[b,c],k.setLineDash(e)},f.DrawOutline=function(a,d,e,b,c,f){var g=h(this.radius,c/2,b/2);a.strokeStyle=f,this.Ants(a),y(a,d,e,b,c,g,!0)},f.DrawSize=function(i,n,m,l,k,j,a,h,g){var f=a.w,e=a.h,c,b,d;return this.pulsate?(a.image?d=(a.image.height+this.tc.outlineIncrease)/a.image.height:d=a.oscale,b=a.fimage||a.image,c=1+(d-1)*(1-this.pulse),a.h*=c,a.w*=c):b=a.oimage,a.alpha=1,a.Draw(i,h,g,b),a.h=e,a.w=f,1},f.DrawColour=function(d,h,i,e,f,g,a,b,c){return a.oimage?(this.pulse<1?(a.alpha=1-w(this.pulse,2),a.Draw(d,b,c,a.fimage),a.alpha=this.pulse):a.alpha=1,a.Draw(d,b,c,a.oimage),1):this[a.image?'DrawColourImage':'DrawColourText'](d,h,i,e,f,g,a,b,c)},f.DrawColourText=function(f,h,i,j,g,e,a,b,c){var d=a.colour;return a.colour=e,a.alpha=1,a.Draw(f,b,c),a.colour=d,1},f.DrawColourImage=function(a,q,p,o,n,m,i,r,l){var f=a.canvas,e=~~g(q,0),d=~~g(p,0),c=h(f.width-e,o)+.5|0,b=h(f.height-d,n)+.5|0,j;return v?(v.width=c,v.height=b):v=k(c,b),!v?this.SetMethod('outline'):(j=v.getContext('2d'),j.drawImage(f,e,d,c,b,0,0,c,b),a.clearRect(e,d,c,b),this.pulsate?i.alpha=1-w(this.pulse,2):i.alpha=1,i.Draw(a,r,l),a.setTransform(1,0,0,1,0,0),a.save(),a.beginPath(),a.rect(e,d,c,b),a.clip(),a.globalCompositeOperation='source-in',a.fillStyle=m,a.fillRect(e,d,c,b),a.restore(),a.globalAlpha=1,a.globalCompositeOperation='destination-over',a.drawImage(v,0,0,c,b,e,d,c,b),a.globalCompositeOperation='source-over',1)},f.DrawAlt=function(b,a,c,d,f,g){var e=this.RealPreDraw(b,a,c,d,f,g);return a.alt&&(a.DrawImage(b,c,d,a.alt),e=1),e},f.DrawBlock=function(a,d,e,b,c,f){var g=h(this.radius,c/2,b/2);a.fillStyle=f,y(a,d,e,b,c,g)},f.DrawSimple=function(a,b,c,d,e,f){var g=this.tc;return a.setTransform(1,0,0,1,0,0),a.strokeStyle=this.colour,a.lineWidth=g.outlineThickness,a.shadowBlur=a.shadowOffsetX=a.shadowOffsetY=0,a.globalAlpha=f?e:1,this.drawFunc(a,this.x,this.y,this.w,this.h,this.colour,b,c,d)},f.DrawPulsate=function(h,d,e,f){var g=q()-this.ts,c=this.tc,b=c.pulsateTo+(1-c.pulsateTo)*(.5+l(2*Math.PI*g/(1e3*c.pulsateTime))/2);return this.pulse=b=a.Smooth(1,b),this.DrawSimple(h,d,e,f,b,1)},f.Active=function(d,a,b){var c=a>=this.x&&b>=this.y&&a<=this.x+this.w&&b<=this.y+this.h;return c?this.ts=this.ts||q():this.ts=null,c},f.PreDraw=f.PostDraw=f.LastDraw=x;function J(a,h,c,b,e,f,g,d,i,j,k,l,m,n){this.tc=a,this.image=null,this.text=h,this.text_original=n,this.line_widths=[],this.title=c.title||null,this.a=c,this.position=new s(b[0],b[1],b[2]),this.x=this.y=this.z=0,this.w=e,this.h=f,this.colour=g||a.textColour,this.bgColour=d||a.bgColour,this.bgRadius=i|0,this.bgOutline=j||this.colour,this.bgOutlineThickness=k|0,this.textFont=l||a.textFont,this.padding=m|0,this.sc=this.alpha=1,this.weighted=!a.weight,this.outline=new _(a,this),this.audio=null}d=J.prototype,d.Init=function(b){var a=this.tc;this.textHeight=a.textHeight,this.HasText()?this.Measure(a.ctxt,a):(this.w=this.iw,this.h=this.ih),this.SetShadowColour=a.shadowAlpha?this.SetShadowColourAlpha:this.SetShadowColourFixed,this.SetDraw(a)},d.Draw=x,d.HasText=function(){return this.text&&this.text[0].length>0},d.EqualTo=function(a){var b=a.getElementsByTagName('img');return this.a.href!=a.href?0:b.length?this.image.src==b[0].src:(a.innerText||a.textContent)==this.text_original},d.SetImage=function(a){this.image=this.fimage=a},d.SetAudio=function(a){this.audio=a,this.audio.load()},d.SetDraw=function(a){this.Draw=this.fimage?a.ie>7?this.DrawImageIE:this.DrawImage:this.DrawText,a.noSelect&&(this.CheckActive=x)},d.MeasureText=function(d){var a,e=this.text.length,b=0,c;for(a=0;a<e;++a)this.line_widths[a]=c=d.measureText(this.text[a]).width,b=g(b,c);return b},d.Measure=function(e,a){var f=ae(this.text,this.textFont,this.textHeight),b,k,h,i,g,l,j,c,d;j=f?f.max.y+f.min.y:this.textHeight,e.font=this.font=this.textHeight+'px '+this.textFont,l=this.MeasureText(e),a.txtOpt&&(b=a.txtScale,k=b*this.textHeight,h=k+'px '+this.textFont,i=[b*a.shadowOffset[0],b*a.shadowOffset[1]],e.font=h,g=this.MeasureText(e),d=new O(this.text,h,g+b,b*j+b,g,this.line_widths,a.textAlign,a.textVAlign,b),this.image&&d.SetImage(this.image,this.iw,this.ih,a.imagePosition,a.imagePadding,a.imageAlign,a.imageVAlign,a.imageScale),c=d.Create(this.colour,this.bgColour,this.bgOutline,b*this.bgOutlineThickness,a.shadow,b*a.shadowBlur,i,b*this.padding,b*this.bgRadius),a.outlineMethod=='colour'?this.oimage=d.Create(this.outline.colour,this.bgColour,this.outline.colour,b*this.bgOutlineThickness,a.shadow,b*a.shadowBlur,i,b*this.padding,b*this.bgRadius):a.outlineMethod=='size'&&(f=ae(this.text,this.textFont,this.textHeight+a.outlineIncrease),k=f.max.y+f.min.y,h=b*(this.textHeight+a.outlineIncrease)+'px '+this.textFont,e.font=h,g=this.MeasureText(e),d=new O(this.text,h,g+b,b*k+b,g,this.line_widths,a.textAlign,a.textVAlign,b),this.image&&d.SetImage(this.image,this.iw+a.outlineIncrease,this.ih+a.outlineIncrease,a.imagePosition,a.imagePadding,a.imageAlign,a.imageVAlign,a.imageScale),this.oimage=d.Create(this.colour,this.bgColour,this.bgOutline,b*this.bgOutlineThickness,a.shadow,b*a.shadowBlur,i,b*this.padding,b*this.bgRadius),this.oscale=this.oimage.width/c.width,a.outlineIncrease>0?c=H(c,this.oimage.width,this.oimage.height):this.oimage=H(this.oimage,c.width,c.height)),c&&(this.fimage=c,l=this.fimage.width/b,j=this.fimage.height/b),this.SetDraw(a),a.txtOpt=!!this.fimage),this.h=j,this.w=l},d.SetFont=function(a,b,c,d){this.textFont=a,this.colour=b,this.bgColour=c,this.bgOutline=d,this.Measure(this.tc.ctxt,this.tc)},d.SetWeight=function(c){var b=this.tc,e=b.weightMode.split(/[, ]/),d,a,f=c.length;if(!this.HasText())return;this.weighted=!0;for(a=0;a<f;++a)d=e[a]||'size','both'==d?(this.Weight(c[a],b.ctxt,b,'size',b.min_weight[a],b.max_weight[a],a),this.Weight(c[a],b.ctxt,b,'colour',b.min_weight[a],b.max_weight[a],a)):this.Weight(c[a],b.ctxt,b,d,b.min_weight[a],b.max_weight[a],a);this.Measure(b.ctxt,b)},d.Weight=function(b,i,a,d,f,h,e){b=isNaN(b)?1:b;var c=(b-f)/(h-f);'colour'==d?this.colour=L(a,c,e):'bgcolour'==d?this.bgColour=L(a,c,e):'bgoutline'==d?this.bgOutline=L(a,c,e):'outline'==d?this.outline.colour=L(a,c,e):'size'==d&&(a.weightSizeMin>0&&a.weightSizeMax>a.weightSizeMin?this.textHeight=a.weightSize*(a.weightSizeMin+(a.weightSizeMax-a.weightSizeMin)*c):this.textHeight=g(1,b*a.weightSize))},d.SetShadowColourFixed=function(a,b,c){a.shadowColor=b},d.SetShadowColourAlpha=function(a,b,c){a.shadowColor=aE(b,c)},d.DrawText=function(a,h,i){var e=this.tc,g=this.x,f=this.y,c=this.sc,b,d;a.globalAlpha=this.alpha,a.fillStyle=this.colour,e.shadow&&this.SetShadowColour(a,e.shadow,this.alpha),a.font=this.font,g+=h/c,f+=i/c-this.h/2;for(b=0;b<this.text.length;++b)d=g,'right'==e.textAlign?d+=this.w/2-this.line_widths[b]:'centre'==e.textAlign?d-=this.line_widths[b]/2:d-=this.w/2,a.setTransform(c,0,0,c,c*d,c*f),a.fillText(this.text[b],0,0),f+=this.textHeight},d.DrawImage=function(b,i,k,l){var e=this.x,f=this.y,a=this.sc,j=l||this.fimage,c=this.w,d=this.h,g=this.alpha,h=this.shadow;b.globalAlpha=g,h&&this.SetShadowColour(b,h,g),e+=i/a-c/2,f+=k/a-d/2,b.setTransform(a,0,0,a,a*e,a*f),b.drawImage(j,0,0,c,d)},d.DrawImageIE=function(b,d,e){var c=this.fimage,a=this.sc,f=c.width=this.w*a,g=c.height=this.h*a,h=this.x*a+d-f/2,i=this.y*a+e-g/2;b.setTransform(1,0,0,1,0,0),b.globalAlpha=this.alpha,b.drawImage(c,h,i)},d.Calc=function(g,e){var a,b=this.tc,d=b.minBrightness,f=b.maxBrightness,c=b.max_radius;return a=g.xform(this.position),this.xformed=a,a=aI(b,a,b.stretchX,b.stretchY),this.x=a.x,this.y=a.y,this.z=a.z,this.sc=a.w,this.alpha=e*G(d+(f-d)*(c-this.z)/(2*c),0,1),this.xformed},d.UpdateActive=function(h,e,f){var a=this.outline,b=this.w,c=this.h,d=this.x-b/2,g=this.y-c/2;return a.Update(d,g,b,c,this.sc,this.z,e,f),a},d.CheckActive=function(a,d,e){var b=this.tc,c=this.UpdateActive(a,d,e);return c.Active(a,b.mx,b.my)?c:null},d.Clicked=function(f){var b=this.a,a=b.target,d=b.href,e;if(a!=''&&a!='_self'){if(self.frames[a])self.frames[a].document.location=d;else{try{if(top.frames[a]){top.frames[a].document.location=d;return}}catch(a){}window.open(d,a)}return}if(c.createEvent){if(e=c.createEvent('MouseEvents'),e.initMouseEvent('click',1,1,window,0,0,0,0,0,0,0,0,0,0,null),!b.dispatchEvent(e))return}else if(b.fireEvent)if(!b.fireEvent('onclick'))return;c.location=d},d.StopAudio=function(){this.audio&&this.playing&&this.audio.pause(),this.stopped=1,this.playing=0},d.PlayAudio=function(){if(e==='off'||this.tc.audioOff)return;if(!e&&!ag())return;var a=this.tc.audio,c=this.tc.gain,d='suspended',b;if(this.audio)if(this.track||(this.track=e.createMediaElementSource(this.audio),this.gain=e.createGain(),this.track.connect(this.gain),this.gain.connect(e.destination)),a=this.audio,c=this.gain,!a.paused)return 1;if(a){if(e.state==d&&e.resume(),e.state==d)return;return c.gain.value=h(2,g(0,this.tc.audioVolume*1)),a.currentTime=0,this.stopped=0,b=a.play(),b!==void 0&&b.then(a=>{this.stopped?this.audio.pause():this.playing=1}),1}};function a(f,o,k){var d,i,b=c.getElementById(f),l=['id','class','innerHTML'];if(!b)throw 0;if(n(window.G_vmlCanvasManager)&&(b=window.G_vmlCanvasManager.initElement(b),this.ie=parseFloat(navigator.appVersion.split('MSIE')[1])),b&&(!b.getContext||!b.getContext('2d').fillText)){i=c.createElement('DIV');for(d=0;d<l.length;++d)i[l[d]]=b[l[d]];throw b.parentNode.insertBefore(i,b),b.parentNode.removeChild(b),0}for(d in a.options)this[d]=k&&n(k[d])?k[d]:n(a[d])?a[d]:a.options[d];if(this.canvas=b,this.ctxt=b.getContext('2d'),this.z1=250/g(this.depth,.001),this.z2=this.z1/this.zoom,this.radius=h(b.height,b.width)*.0075,this.max_radius=100,this.max_weight=[],this.min_weight=[],this.textFont=this.textFont&&Q(this.textFont),this.textHeight*=1,this.imageRadius=this.imageRadius.toString(),this.pulsateTo=G(this.pulsateTo,0,1),this.minBrightness=G(this.minBrightness,0,1),this.maxBrightness=G(this.maxBrightness,this.minBrightness,1),this.ctxt.textBaseline='top',this.lx=(this.lock+'').indexOf('x')+1,this.ly=(this.lock+'').indexOf('y')+1,this.frozen=this.dx=this.dy=this.fixedAnim=this.touchState=0,this.fixedAlpha=1,this.source=o||f,this.repeatTags=h(64,~~this.repeatTags),this.minTags=h(200,~~this.minTags),~~this.scrollPause>0?a.scrollPause=~~this.scrollPause:this.scrollPause=0,this.minTags>0&&this.repeatTags<1&&(d=this.GetTags().length)&&(this.repeatTags=af(this.minTags/d)-1),this.transform=m.Identity(),this.startTime=this.time=q(),this.mx=this.my=-1,this.centreImage&&av(this),this.Animate=this.dragControl?this.AnimateDrag:this.AnimatePosition,this.animTiming=typeof a[this.animTiming]=='function'?a[this.animTiming]:a.Smooth,this.shadowBlur||this.shadowOffset[0]||this.shadowOffset[1]?(this.ctxt.shadowColor=this.shadow,this.shadow=this.ctxt.shadowColor,this.shadowAlpha=aD()):delete this.shadow,this.activeAudio===!1?e='off':this.activeAudio&&this.LoadAudio(),this.Load(),o&&this.hideTags&&function(b){a.loaded?b.HideTags():t('load',function(){b.HideTags()},window)}(this),this.yaw=this.initial?this.initial[0]*this.maxSpeed:0,this.pitch=this.initial?this.initial[1]*this.maxSpeed:0,this.tooltip?(this.ctitle=b.title,b.title='',this.tooltip=='native'?this.Tooltip=this.TooltipNative:(this.Tooltip=this.TooltipDiv,this.ttdiv||(this.ttdiv=c.createElement('div'),this.ttdiv.className=this.tooltipClass,this.ttdiv.style.position='absolute',this.ttdiv.style.zIndex=b.style.zIndex+1,t('mouseover',function(a){a.target.style.display='none'},this.ttdiv),c.body.appendChild(this.ttdiv)))):this.Tooltip=this.TooltipNone,!this.noMouse&&!j[f]){j[f]=[['mousemove',ad],['mouseout',an],['mouseup',aq],['touchstart',ar],['touchend',ac],['touchcancel',ac],['touchmove',au]],this.dragControl&&(j[f].push(['mousedown',ap]),j[f].push(['selectstart',x])),this.wheelZoom&&(j[f].push(['mousewheel',ab]),j[f].push(['DOMMouseScroll',ab])),this.scrollPause&&j[f].push(['scroll',aw,window]);for(d=0;d<j[f].length;++d)i=j[f][d],t(i[0],i[1],i[2]?i[2]:b)}a.started||(a.NextFrame=window.requestAnimationFrame?az:aA,a.interval=this.interval,a.NextFrame(this.interval),a.started=1)}b=a.prototype,b.SourceElements=function(){return c.querySelectorAll?c.querySelectorAll('#'+this.source):[c.getElementById(this.source)]},b.HideTags=function(){var b=this.SourceElements(),a;for(a=0;a<b.length;++a)b[a].style.display='none'},b.GetTags=function(){var e=this.SourceElements(),c,f=[],a,b,d;for(d=0;d<=this.repeatTags;++d)for(a=0;a<e.length;++a){c=e[a].getElementsByTagName('a');for(b=0;b<c.length;++b)f.push(c[b])}return f},b.Message=function(j){var g=[],a,f,b=j.split(''),d,e,h,i;for(a=0;a<b.length;++a)b[a]!=' '&&(f=a-b.length/2,d=c.createElement('A'),d.href='#',d.innerText=b[a],h=100*o(f/9),i=-100*l(f/9),e=new J(this,b[a],d,[h,0,i],2,18,'#000','#fff',0,0,0,'monospace',2,b[a]),e.Init(),g.push(e));return g},b.AddAudio=function(b,c){if(e==='off')return;var a=b.getElementsByTagName('audio');a.length&&(c.SetAudio(a[0]),this.hasAudio=1)},b.CreateTag=function(b){var e,c,a,f,d,g,h,j,k=[0,0,0],l;if('text'!=this.imageMode)if(e=b.getElementsByTagName('img'),e.length)if(c=new Image,c.src=e[0].src,!this.imageMode)return a=new J(this,\"\",b,k,0,0),a.SetImage(c),A(c,e[0],e[1],a,this),this.AddAudio(b,a),a;if('image'!=this.imageMode&&(d=new V(b),f=d.Lines(),d.Empty()?d=null:(g=this.textFont||Q(i(b,'font-family')),this.splitWidth&&(f=d.SplitWidth(this.splitWidth,this.ctxt,g,this.textHeight)),h=this.bgColour=='tag'?i(b,'background-color'):this.bgColour,j=this.bgOutline=='tag'?i(b,'color'):this.bgOutline)),d||c)return a=new J(this,f,b,k,2,this.textHeight+2,this.textColour||i(b,'color'),h,this.bgRadius,j,this.bgOutlineThickness,g,this.padding,d&&d.original),c?(a.SetImage(c),A(c,e[0],e[1],a,this)):a.Init(),this.AddAudio(b,a),a},b.UpdateTag=function(a,b){var c=this.textColour||i(b,'color'),d=this.textFont||Q(i(b,'font-family')),e=this.bgColour=='tag'?i(b,'background-color'):this.bgColour,f=this.bgOutline=='tag'?i(b,'color'):this.bgOutline;a.a=b,a.title=b.title,(a.colour!=c||a.textFont!=d||a.bgColour!=e||a.bgOutline!=f)&&a.SetFont(d,c,e,f)},b.Weight=function(d){var f=d.length,c,b,a,e=[],g,h=this.weightFrom?this.weightFrom.split(/[, ]/):[null],i=h.length;for(b=0;b<f;++b){e[b]=[];for(a=0;a<i;++a)c=aj(d[b].a,h[a],this.textHeight),(!this.max_weight[a]||c>this.max_weight[a])&&(this.max_weight[a]=c),(!this.min_weight[a]||c<this.min_weight[a])&&(this.min_weight[a]=c),e[b][a]=c}for(a=0;a<i;++a)this.max_weight[a]>this.min_weight[a]&&(g=1);if(g)for(b=0;b<f;++b)d[b].SetWeight(e[b])},b.Load=function(){var c=this.GetTags(),b=[],d,k,l,h,i,j,f,a,e=[],m={sphere:aB,vcylinder:ax,hcylinder:aH,vring:aG,hring:aF};if(c.length){e.length=c.length;for(a=0;a<c.length;++a)e[a]=a;this.shuffleTags&&ai(e),h=100*this.radiusX,i=100*this.radiusY,j=100*this.radiusZ,this.max_radius=g(h,g(i,j));for(a=0;a<c.length;++a)k=this.CreateTag(c[e[a]]),k&&b.push(k);this.weight&&this.Weight(b,!0),this.shapeArgs?this.shapeArgs[0]=b.length:(l=this.shape.toString().split(/[(),]/),d=l.shift(),typeof window[d]=='function'?this.shape=window[d]:this.shape=m[d]||m.sphere,this.shapeArgs=[b.length,h,i,j].concat(l)),f=this.shape.apply(this,this.shapeArgs),this.listLength=b.length;for(a=0;a<b.length;++a)b[a].position=new s(f[a][0],f[a][1],f[a][2])}this.noTagsMessage&&!b.length&&(a=this.imageMode&&this.imageMode!='both'?this.imageMode+' ':'',b=this.Message('No '+a+'tags')),this.taglist=b},b.Update=function(){var e=this.GetTags(),d=[],j=this.taglist,k,f=[],c=[],h,i,g,a,b;if(!this.shapeArgs)return this.Load();if(e.length){g=this.listLength=e.length,i=j.length;for(a=0;a<i;++a)d.push(j[a]),c.push(a);for(a=0;a<g;++a){for(b=0,k=0;b<i;++b)j[b].EqualTo(e[a])&&(this.UpdateTag(d[b],e[a]),k=c[b]=-1);k||f.push(a)}for(a=0,b=0;a<i;++a)c[b]==-1?c.splice(b,1):++b;if(c.length){for(ai(c);c.length&&f.length;)a=c.shift(),b=f.shift(),d[a]=this.CreateTag(e[b]);for(c.sort(function(a,b){return a-b});c.length;)d.splice(c.pop(),1)}for(b=d.length/(f.length+1),a=0;f.length;)d.splice(af(++a*b),0,this.CreateTag(e[f.shift()]));this.shapeArgs[0]=g=d.length,h=this.shape.apply(this,this.shapeArgs);for(a=0;a<g;++a)d[a].position=new s(h[a][0],h[a][1],h[a][2]);this.weight&&this.Weight(d)}this.taglist=d},b.SetShadow=function(a){a.shadowBlur=this.shadowBlur,a.shadowOffsetX=this.shadowOffset[0],a.shadowOffsetY=this.shadowOffset[1]},b.LoadAudio=function(){if(!e&&!ag())return;this.audio=c.createElement('audio'),this.audio.src=this.activeAudio,this.track=e.createMediaElementSource(this.audio),this.gain=e.createGain(),this.track.connect(this.gain),this.gain.connect(e.destination),this.hasAudio=1,P=function(a){e.resume(),c.removeEventListener('click',P)},c.addEventListener('click',P)},b.ShowAudioIcon=function(){var a=this.audioIconSize,c=this.canvas,d=this.ctxt,k=c.width-a-3,f=c.height-a-3,g=this.audioIconThickness,h='#000',i='#fff',j=this.audioIconDark,b=this.audioOff,l='suspended';if(!e)return;b||(b=e.state===l),this.audioIcon&&this.hasAudio&&($(b,d,a,k,f,g+1,j?i:h),$(b,d,a,k,f,g,j?h:i))},b.CheckAudioIcon=function(){var a=this.audioIconSize,b=this.canvas,c=this.audioIconThickness/2,d=b.width-a-3-c,e=b.height-a-3-c;if(this.audioIcon&&this.mx>=d&&this.my>=e)return!0},b.ToggleAudio=function(){var a=this.audioOff||e&&e.state==='suspended';a||this.currentAudio&&this.currentAudio.StopAudio(),this.audioOff=!a},b.Draw=function(s){if(this.paused)return;var l=this.canvas,i=l.width,j=l.height,q=0,p=(s-this.time)*a.interval/1e3,h=i/2+this.offsetX,g=j/2+this.offsetY,d=this.ctxt,b,f,c,o=-1,e=this.taglist,k=e.length,t=this.active&&this.active.tag,m='',u=this.frontSelect,r=this.centreFunc==x,n;if(this.time=s,this.frozen&&this.drawn)return this.Animate(i,j,p);n=this.AnimateFixed(),d.setTransform(1,0,0,1,0,0);for(c=0;c<k;++c)e[c].Calc(this.transform,this.fixedAlpha);if(e=ak(e,function(a,b){return b.z-a.z}),n&&this.fixedAnim.active)b=this.fixedAnim.tag.UpdateActive(d,h,g);else if(this.active=null,this.CheckAudioIcon())m='pointer';else{for(c=0;c<k;++c)f=this.mx>=0&&this.my>=0&&this.taglist[c].CheckActive(d,h,g),f&&f.sc>q&&(!u||f.z<=0)&&(b=f,o=c,b.tag=this.taglist[c],q=f.sc);this.active=b}this.txtOpt||this.shadow&&this.SetShadow(d),d.clearRect(0,0,i,j);for(c=0;c<k;++c){if(!r&&e[c].z<=0){try{this.centreFunc(d,i,j,h,g)}catch(a){alert(a),this.centreFunc=x}r=!0}b&&b.tag==e[c]&&b.PreDraw(d,e[c],h,g)||e[c].Draw(d,h,g),b&&b.tag==e[c]&&b.PostDraw(d)}this.freezeActive&&b?this.Freeze():(this.UnFreeze(),this.drawn=k==this.listLength),this.fixedCallback&&(this.fixedCallback(this,this.fixedCallbackTag),this.fixedCallback=null),n||this.Animate(i,j,p),b&&(b.LastDraw(d),b.tag!=t&&(this.currentAudio&&this.currentAudio!=b.tag&&this.currentAudio.StopAudio(),b.tag.PlayAudio()&&(this.currentAudio=b.tag)),m=this.activeCursor),l.style.cursor=m,this.Tooltip(b,this.taglist[o]),this.audioIcon&&this.ShowAudioIcon()},b.TooltipNone=function(){},b.TooltipNative=function(b,a){b?this.canvas.title=a&&a.title?a.title:'':this.canvas.title=this.ctitle},b.SetTTDiv=function(c,d){var a=this,b=a.ttdiv.style;c!=a.ttdiv.innerHTML&&(b.display='none'),a.ttdiv.innerHTML=c,d&&(d.title=a.ttdiv.innerHTML),b.display=='none'&&!a.tttimer&&(a.tttimer=setTimeout(function(){var c=X(a.canvas.id);b.display='block',b.left=c.x+a.mx+'px',b.top=c.y+a.my+24+'px',a.tttimer=null},a.tooltipDelay))},b.TooltipDiv=function(b,a){b&&a&&a.title?this.SetTTDiv(a.title,a):!b&&this.mx!=-1&&this.my!=-1&&this.ctitle.length?this.SetTTDiv(this.ctitle):this.ttdiv.style.display='none'},b.Transform=function(c,a,b){if(a||b){var d=o(a),e=l(a),f=o(b),g=l(b),h=new m([g,0,f,0,1,0,-f,0,g]),i=new m([1,0,0,0,e,-d,0,d,e]);c.transform=c.transform.mul(h.mul(i))}},b.AnimateFixed=function(){var a,b,c,d,e;return!!(this.fadeIn&&(b=q()-this.startTime,b>=this.fadeIn?(this.fadeIn=0,this.fixedAlpha=1):this.fixedAlpha=b/this.fadeIn),this.fixedAnim)&&(this.fixedAnim.transform||(this.fixedAnim.transform=this.transform),a=this.fixedAnim,b=q()-a.t0,c=a.angle,d,e=this.animTiming(a.t,b),this.transform=a.transform,b>=a.t?(this.fixedCallbackTag=a.tag,this.fixedCallback=a.cb,this.fixedAnim=this.yaw=this.pitch=0):c*=e,d=m.Rotation(c,a.axis),this.transform=this.transform.mul(d),this.fixedAnim!=0)},b.AnimatePosition=function(g,h,f){var a=this,d=a.mx,e=a.my,b,c;!a.frozen&&d>=0&&e>=0&&d<g&&e<h?(b=a.maxSpeed,c=a.reverse?-1:1,a.lx||(a.yaw=(d*2*b/g-b)*c*f),a.ly||(a.pitch=(e*2*b/h-b)*-c*f),a.initial=null):a.initial||(a.frozen&&!a.freezeDecel?a.yaw=a.pitch=0:a.Decel(a)),this.Transform(a,a.pitch,a.yaw)},b.AnimateDrag=function(d,e,c){var a=this,b=100*c*a.maxSpeed/a.max_radius/a.zoom;a.dx||a.dy?(a.lx||(a.yaw=a.dx*b/a.stretchX),a.ly||(a.pitch=a.dy*-b/a.stretchY),a.dx=a.dy=0,a.initial=null):a.initial||a.Decel(a),this.Transform(a,a.pitch,a.yaw)},b.Freeze=function(){this.frozen||(this.preFreeze=[this.yaw,this.pitch],this.frozen=1,this.drawn=0)},b.UnFreeze=function(){this.frozen&&(this.yaw=this.preFreeze[0],this.pitch=this.preFreeze[1],this.frozen=0)},b.Decel=function(a){var b=a.minSpeed,c=p(a.yaw),d=p(a.pitch);!a.lx&&c>b&&(a.yaw=c>a.z0?a.yaw*a.decel:0),!a.ly&&d>b&&(a.pitch=d>a.z0?a.pitch*a.decel:0)},b.Zoom=function(a){this.z2=this.z1*(1/a),this.drawn=0},b.Clicked=function(b){if(this.CheckAudioIcon()){this.ToggleAudio();return}var a=this.active;try{a&&a.tag&&(this.clickToFront===!1||this.clickToFront===null?a.tag.Clicked(b):this.TagToFront(a.tag,this.clickToFront,function(){a.tag.Clicked(b)},!0))}catch(a){}},b.Wheel=function(a){var b=this.zoom+this.zoomStep*(a?1:-1);this.zoom=h(this.zoomMax,g(this.zoomMin,b)),this.Zoom(this.zoom)},b.BeginDrag=function(a){this.down=K(a,this.canvas),a.cancelBubble=!0,a.returnValue=!1,a.preventDefault&&a.preventDefault()},b.Drag=function(e,a){if(this.dragControl&&this.down){var d=this.dragThreshold*this.dragThreshold,b=a.x-this.down.x,c=a.y-this.down.y;(this.dragging||b*b+c*c>d)&&(this.dx=b,this.dy=c,this.dragging=1,this.down=a)}return this.dragging},b.EndDrag=function(){var a=this.dragging;return this.dragging=this.down=null,a};function ah(a){var b=a.targetTouches[0],c=a.targetTouches[1];return E(w(c.pageX-b.pageX,2)+w(c.pageY-b.pageY,2))}b.BeginPinch=function(a){this.pinched=[ah(a),this.zoom],a.preventDefault&&a.preventDefault()},b.Pinch=function(d){var b,c,a=this.pinched;if(!a)return;c=ah(d),b=a[1]*c/a[0],this.zoom=h(this.zoomMax,g(this.zoomMin,b)),this.Zoom(this.zoom)},b.EndPinch=function(a){this.pinched=null},b.Pause=function(){this.paused=!0},b.Resume=function(){this.paused=!1},b.SetSpeed=function(a){this.initial=a,this.yaw=a[0]*this.maxSpeed,this.pitch=a[1]*this.maxSpeed},b.FindTag=function(a){if(!n(a))return null;if(n(a.index)&&(a=a.index),!B(a))return this.taglist[a];var c,d,b;n(a.id)?(c='id',d=a.id):n(a.text)&&(c='innerText',d=a.text);for(b=0;b<this.taglist.length;++b)if(this.taglist[b].a[c]==d)return this.taglist[b]},b.RotateTag=function(a,h,i,j,f,g){var b=a.Calc(this.transform,1),c=new s(b.x,b.y,b.z),d=ay(i,h),e=c.angle(d),k=c.cross(d).unit();e==0?(this.fixedCallbackTag=a,this.fixedCallback=f):this.fixedAnim={angle:-e,axis:k,t:j,t0:q(),cb:f,tag:a,active:g}},b.TagToFront=function(a,b,c,d){this.RotateTag(a,0,0,b,c,d)},b.Volume=function(a){this.audioVolume=a*1},a.Start=function(b,c,d){a.Delete(b),a.tc[b]=new a(b,c,d)};function N(c,b){a.tc[b]&&a.tc[b][c]()}a.Linear=function(a,b){return b/a},a.Smooth=function(a,b){return.5-l(b*Math.PI/a)/2},a.Pause=function(a){N('Pause',a)},a.Resume=function(a){N('Resume',a)},a.Reload=function(a){N('Load',a)},a.Update=function(a){N('Update',a)},a.SetSpeed=function(c,b){return!!(B(b)&&a.tc[c]&&!isNaN(b[0])&&!isNaN(b[1]))&&(a.tc[c].SetSpeed(b),!0)},a.TagToFront=function(c,b){return!!B(b)&&(b.lat=b.lng=0,a.RotateTag(c,b))},a.RotateTag=function(c,b){if(B(b)&&a.tc[c]){isNaN(b.time)&&(b.time=500);var d=a.tc[c].FindTag(b);if(d)return a.tc[c].RotateTag(d,b.lat,b.lng,b.time,b.callback,b.active),!0}return!1},a.Delete=function(b){var d,e;if(j[b])if(e=c.getElementById(b),e)for(d=0;d<j[b].length;++d)am(j[b][d][0],j[b][d][1],e);delete j[b],delete a.tc[b]},a.tc={},a.options={z1:2e4,z2:2e4,z0:2e-4,freezeActive:!1,freezeDecel:!1,activeCursor:'pointer',pulsateTo:1,pulsateTime:3,reverse:!1,depth:.5,maxSpeed:.05,minSpeed:0,decel:.95,interval:20,minBrightness:.1,maxBrightness:1,outlineColour:'#ffff99',outlineThickness:2,outlineOffset:5,outlineMethod:'outline',outlineRadius:0,textColour:'#ff99ff',textHeight:15,textFont:'Helvetica, Arial, sans-serif',shadow:'#000',shadowBlur:0,shadowOffset:[0,0],initial:null,hideTags:!0,zoom:1,weight:!1,weightMode:'size',weightFrom:null,weightSize:1,weightSizeMin:null,weightSizeMax:null,weightGradient:{0:'#f00',0.33:'#ff0',0.66:'#0f0',1:'#00f'},txtOpt:!0,txtScale:2,frontSelect:!1,wheelZoom:!0,zoomMin:.3,zoomMax:3,zoomStep:.05,shape:'sphere',lock:null,tooltip:null,tooltipDelay:300,tooltipClass:'tctooltip',radiusX:1,radiusY:1,radiusZ:1,stretchX:1,stretchY:1,offsetX:0,offsetY:0,shuffleTags:!1,noSelect:!1,noMouse:!1,imageScale:1,paused:!1,dragControl:!1,dragThreshold:4,centreFunc:x,splitWidth:0,animTiming:'Smooth',clickToFront:!1,fadeIn:0,padding:0,bgColour:null,bgRadius:0,bgOutline:null,bgOutlineThickness:0,outlineIncrease:4,textAlign:'centre',textVAlign:'middle',imageMode:null,imagePosition:null,imagePadding:2,imageAlign:'centre',imageVAlign:'middle',noTagsMessage:!0,centreImage:null,pinchZoom:!1,repeatTags:0,minTags:0,imageRadius:0,scrollPause:!1,outlineDash:0,outlineDashSpace:0,outlineDashSpeed:1,activeAudio:'',audioVolume:1,audioIcon:1,audioIconSize:20,audioIconThickness:2,audioIconDark:0,altImage:0};for(r in a.options)a[r]=a.options[r];window.TagCanvas=a,t('load',function(){a.loaded=1},window)})()","Magefan_Blog/js/jquery.tagcanvas.min.js":"/**\n * Copyright (C) 2010-2015 Graham Breach\n *\n * This program is free software: you can redistribute it and/or modify\n * it under the terms of the GNU Lesser General Public License as published by\n * the Free Software Foundation, either version 3 of the License, or\n * (at your option) any later version.\n *\n * This program is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU Lesser General Public License for more details.\n * \n * You should have received a copy of the GNU Lesser General Public License\n * along with this program.  If not, see <http://www.gnu.org/licenses/>.\n */\n/**\n * jQuery.tagcanvas 2.9\n * For more information, please contact <graham@goat1000.com>\n */\n(function(ap){var M,K,L=Math.abs,ah=Math.sin,w=Math.cos,s=Math.max,aE=Math.min,aq=Math.ceil,F=Math.sqrt,au=Math.pow,h={},l={},m={0:\"0,\",1:\"17,\",2:\"34,\",3:\"51,\",4:\"68,\",5:\"85,\",6:\"102,\",7:\"119,\",8:\"136,\",9:\"153,\",a:\"170,\",A:\"170,\",b:\"187,\",B:\"187,\",c:\"204,\",C:\"204,\",d:\"221,\",D:\"221,\",e:\"238,\",E:\"238,\",f:\"255,\",F:\"255,\"},x,c,Q,aG,H,aH,aa,C=document,p,b={};for(M=0;M<256;++M){K=M.toString(16);if(M<16){K=\"0\"+K}l[K]=l[K.toUpperCase()]=M.toString()+\",\"}function ai(i){return typeof i!=\"undefined\"}function I(i){return typeof i==\"object\"&&i!=null}function aw(i,j,aI){return isNaN(i)?aI:aE(aI,s(j,i))}function aB(){return false}function G(){return new Date().valueOf()}function A(aI,aL){var j=[],aJ=aI.length,aK;for(aK=0;aK<aJ;++aK){j.push(aI[aK])}j.sort(aL);return j}function an(j){var aJ=j.length-1,aI,aK;while(aJ){aK=~~(Math.random()*aJ);aI=j[aJ];j[aJ]=j[aK];j[aK]=aI;--aJ}}function ae(i,aI,j){this.x=i;this.y=aI;this.z=j}H=ae.prototype;H.length=function(){return F(this.x*this.x+this.y*this.y+this.z*this.z)};H.dot=function(i){return this.x*i.x+this.y*i.y+this.z*i.z};H.cross=function(j){var i=this.y*j.z-this.z*j.y,aJ=this.z*j.x-this.x*j.z,aI=this.x*j.y-this.y*j.x;return new ae(i,aJ,aI)};H.angle=function(j){var i=this.dot(j),aI;if(i==0){return Math.PI/2}aI=i/(this.length()*j.length());if(aI>=1){return 0}if(aI<=-1){return Math.PI}return Math.acos(aI)};H.unit=function(){var i=this.length();return new ae(this.x/i,this.y/i,this.z/i)};function aj(aI,j){j=j*Math.PI/180;aI=aI*Math.PI/180;var i=ah(aI)*w(j),aK=-ah(j),aJ=-w(aI)*w(j);return new ae(i,aK,aJ)}function R(i){this[1]={1:i[0],2:i[1],3:i[2]};this[2]={1:i[3],2:i[4],3:i[5]};this[3]={1:i[6],2:i[7],3:i[8]}}aG=R.prototype;R.Identity=function(){return new R([1,0,0,0,1,0,0,0,1])};R.Rotation=function(aJ,i){var j=ah(aJ),aI=w(aJ),aK=1-aI;return new R([aI+au(i.x,2)*aK,i.x*i.y*aK-i.z*j,i.x*i.z*aK+i.y*j,i.y*i.x*aK+i.z*j,aI+au(i.y,2)*aK,i.y*i.z*aK-i.x*j,i.z*i.x*aK-i.y*j,i.z*i.y*aK+i.x*j,aI+au(i.z,2)*aK])};aG.mul=function(aI){var aJ=[],aM,aL,aK=(aI.xform?1:0);for(aM=1;aM<=3;++aM){for(aL=1;aL<=3;++aL){if(aK){aJ.push(this[aM][1]*aI[1][aL]+this[aM][2]*aI[2][aL]+this[aM][3]*aI[3][aL])}else{aJ.push(this[aM][aL]*aI)}}}return new R(aJ)};aG.xform=function(aI){var j={},i=aI.x,aK=aI.y,aJ=aI.z;j.x=i*this[1][1]+aK*this[2][1]+aJ*this[3][1];j.y=i*this[1][2]+aK*this[2][2]+aJ*this[3][2];j.z=i*this[1][3]+aK*this[2][3]+aJ*this[3][3];return j};function q(aJ,aL,aR,aO,aQ){var aM,aP,j,aN,aS=[],aI=2/aJ,aK;aK=Math.PI*(3-F(5)+(parseFloat(aQ)?parseFloat(aQ):0));for(aM=0;aM<aJ;++aM){aP=aM*aI-1+(aI/2);j=F(1-aP*aP);aN=aM*aK;aS.push([w(aN)*j*aL,aP*aR,ah(aN)*j*aO])}return aS}function W(aK,aI,aN,aU,aR,aT){var aS,aV=[],aJ=2/aK,aL,aQ,aP,aO,aM;aL=Math.PI*(3-F(5)+(parseFloat(aT)?parseFloat(aT):0));for(aQ=0;aQ<aK;++aQ){aP=aQ*aJ-1+(aJ/2);aS=aQ*aL;aO=w(aS);aM=ah(aS);aV.push(aI?[aP*aN,aO*aU,aM*aR]:[aO*aN,aP*aU,aM*aR])}return aV}function N(aI,aJ,aM,aS,aQ,aO){var aR,aT=[],aK=Math.PI*2/aJ,aP,aN,aL;for(aP=0;aP<aJ;++aP){aR=aP*aK;aN=w(aR);aL=ah(aR);aT.push(aI?[aO*aM,aN*aS,aL*aQ]:[aN*aM,aO*aS,aL*aQ])}return aT}function am(aK,j,aI,aJ,i){return W(aK,0,j,aI,aJ,i)}function av(aK,j,aI,aJ,i){return W(aK,1,j,aI,aJ,i)}function d(aK,i,j,aI,aJ){aJ=isNaN(aJ)?0:aJ*1;return N(0,aK,i,j,aI,aJ)}function n(aK,i,j,aI,aJ){aJ=isNaN(aJ)?0:aJ*1;return N(1,aK,i,j,aI,aJ)}function ao(aI){var j=new Image;j.onload=function(){var aJ=j.width/2,i=j.height/2;aI.centreFunc=function(aO,aL,aM,aK,aN){aO.setTransform(1,0,0,1,0,0);aO.globalAlpha=1;aO.drawImage(j,aK-aJ,aN-i)}};j.src=aI.centreImage}function U(aL,i){var aK=aL,aJ,aI,j=(i*1).toPrecision(3)+\")\";if(aL[0]===\"#\"){if(!h[aL]){if(aL.length===4){h[aL]=\"rgba(\"+m[aL[1]]+m[aL[2]]+m[aL[3]]}else{h[aL]=\"rgba(\"+l[aL.substr(1,2)]+l[aL.substr(3,2)]+l[aL.substr(5,2)]}}aK=h[aL]+j}else{if(aL.substr(0,4)===\"rgb(\"||aL.substr(0,4)===\"hsl(\"){aK=(aL.replace(\"(\",\"a(\").replace(\")\",\",\"+j))}else{if(aL.substr(0,5)===\"rgba(\"||aL.substr(0,5)===\"hsla(\"){aJ=aL.lastIndexOf(\",\")+1,aI=aL.indexOf(\")\");i*=parseFloat(aL.substring(aJ,aI));aK=aL.substr(0,aJ)+i.toPrecision(3)+\")\"}}}return aK}function P(i,j){if(window.G_vmlCanvasManager){return null}var aI=C.createElement(\"canvas\");aI.width=i;aI.height=j;return aI}function al(){var j=P(3,3),aJ,aI;if(!j){return false}aJ=j.getContext(\"2d\");aJ.strokeStyle=\"#000\";aJ.shadowColor=\"#fff\";aJ.shadowBlur=3;aJ.globalAlpha=0;aJ.strokeRect(2,2,2,2);aJ.globalAlpha=1;aI=aJ.getImageData(2,2,1,1);j=null;return(aI.data[0]>0)}function ak(aM,j,aL,aK){var aJ=aM.createLinearGradient(0,0,j,0),aI;for(aI in aK){aJ.addColorStop(1-aI,aK[aI])}aM.fillStyle=aJ;aM.fillRect(0,aL,j,1)}function k(aK,aI,j){var aJ=1024,aO=1,aN=aK.weightGradient,aM,aQ,aL,aP;if(aK.gCanvas){aQ=aK.gCanvas.getContext(\"2d\");aO=aK.gCanvas.height}else{if(I(aN[0])){aO=aN.length}else{aN=[aN]}aK.gCanvas=aM=P(aJ,aO);if(!aM){return null}aQ=aM.getContext(\"2d\");for(aL=0;aL<aO;++aL){ak(aQ,aJ,aL,aN[aL])}}j=s(aE(j||0,aO-1),0);aP=aQ.getImageData(~~((aJ-1)*aI),j,1,1).data;return\"rgba(\"+aP[0]+\",\"+aP[1]+\",\"+aP[2]+\",\"+(aP[3]/255)+\")\"}function X(aR,aK,j,aV,aU,aS,aQ,aM,aJ,aT,aL,aP){var aO=aU+(aM||0)+(aJ.length&&aJ[0]<0?L(aJ[0]):0),aI=aS+(aM||0)+(aJ.length&&aJ[1]<0?L(aJ[1]):0),aN,aW;aR.font=aK;aR.textBaseline=\"top\";aR.fillStyle=j;aQ&&(aR.shadowColor=aQ);aM&&(aR.shadowBlur=aM);aJ.length&&(aR.shadowOffsetX=aJ[0],aR.shadowOffsetY=aJ[1]);for(aN=0;aN<aV.length;++aN){aW=0;if(aL){if(\"right\"==aP){aW=aT-aL[aN]}else{if(\"centre\"==aP){aW=(aT-aL[aN])/2}}}aR.fillText(aV[aN],aO+aW,aI);aI+=parseInt(aK)}}function at(aM,i,aL,j,aJ,aK,aI){if(aK){aM.beginPath();aM.moveTo(i,aL+aJ-aK);aM.arcTo(i,aL,i+aK,aL,aK);aM.arcTo(i+j,aL,i+j,aL+aK,aK);aM.arcTo(i+j,aL+aJ,i+j-aK,aL+aJ,aK);aM.arcTo(i,aL+aJ,i,aL+aJ-aK,aK);aM.closePath();aM[aI?\"stroke\":\"fill\"]()}else{aM[aI?\"strokeRect\":\"fillRect\"](i,aL,j,aJ)}}function g(aO,i,aM,aJ,aN,aI,aK,aL,j){this.strings=aO;this.font=i;this.width=aM;this.height=aJ;this.maxWidth=aN;this.stringWidths=aI;this.align=aK;this.valign=aL;this.scale=j}aa=g.prototype;aa.SetImage=function(aL,j,aJ,i,aK,aN,aI,aM){this.image=aL;this.iwidth=j*this.scale;this.iheight=aJ*this.scale;this.ipos=i;this.ipad=aK*this.scale;this.iscale=aM;this.ialign=aN;this.ivalign=aI};aa.Align=function(j,aI,i){var aJ=0;if(i==\"right\"||i==\"bottom\"){aJ=aI-j}else{if(i!=\"left\"&&i!=\"top\"){aJ=(aI-j)/2}}return aJ};aa.Create=function(aV,a1,aU,a2,a0,aZ,i,aY,aQ){var aO,aM,aW,a7,a4,a3,aK,aJ,aI,j,aN,aL,aP,aX,aT,a6=L(i[0]),a5=L(i[1]),aR,aS;aY=s(aY,a6+aZ,a5+aZ);a4=2*(aY+a2);aK=2*(aY+a2);aM=this.width+a4;aW=this.height+aK;aI=j=aY+a2;if(this.image){aN=aL=aY+a2;aP=this.iwidth;aX=this.iheight;if(this.ipos==\"top\"||this.ipos==\"bottom\"){if(aP<this.width){aN+=this.Align(aP,this.width,this.ialign)}else{aI+=this.Align(this.width,aP,this.align)}if(this.ipos==\"top\"){j+=aX+this.ipad}else{aL+=this.height+this.ipad}aM=s(aM,aP+a4);aW+=aX+this.ipad}else{if(aX<this.height){aL+=this.Align(aX,this.height,this.ivalign)}else{j+=this.Align(this.height,aX,this.valign)}if(this.ipos==\"right\"){aN+=this.width+this.ipad}else{aI+=aP+this.ipad}aM+=aP+this.ipad;aW=s(aW,aX+aK)}}aO=P(aM,aW);if(!aO){return null}a4=aK=a2/2;a3=aM-a2;aJ=aW-a2;aT=aE(aQ,a3/2,aJ/2);a7=aO.getContext(\"2d\");if(a1){a7.fillStyle=a1;at(a7,a4,aK,a3,aJ,aT)}if(a2){a7.strokeStyle=aU;a7.lineWidth=a2;at(a7,a4,aK,a3,aJ,aT,true)}if(aZ||a6||a5){aR=P(aM,aW);if(aR){aS=a7;a7=aR.getContext(\"2d\")}}X(a7,this.font,aV,this.strings,aI,j,0,0,[],this.maxWidth,this.stringWidths,this.align);if(this.image){a7.drawImage(this.image,aN,aL,aP,aX)}if(aS){a7=aS;a0&&(a7.shadowColor=a0);aZ&&(a7.shadowBlur=aZ);a7.shadowOffsetX=i[0];a7.shadowOffsetY=i[1];a7.drawImage(aR,0,0)}return aO};function v(aJ,j,aK){var aI=P(j,aK),aL;if(!aI){return null}aL=aI.getContext(\"2d\");aL.drawImage(aJ,(j-aJ.width)/2,(aK-aJ.height)/2);return aI}function ay(aJ,j,aK){var aI=P(j,aK),aL;if(!aI){return null}aL=aI.getContext(\"2d\");aL.drawImage(aJ,0,0,j,aK);return aI}function aD(aV,aQ,aW,a0,aR,aP,aN,aT,aL,aM){var aJ=aQ+((2*aT)+aP)*a0,aS=aW+((2*aT)+aP)*a0,aK=P(aJ,aS),aZ,aY,aI,aX,j,a1,aU,aO;if(!aK){return null}aP*=a0;aL*=a0;aY=aI=aP/2;aX=aJ-aP;j=aS-aP;aT=(aT*a0)+aY;aZ=aK.getContext(\"2d\");aO=aE(aL,aX/2,j/2);if(aR){aZ.fillStyle=aR;at(aZ,aY,aI,aX,j,aO)}if(aP){aZ.strokeStyle=aN;aZ.lineWidth=aP;at(aZ,aY,aI,aX,j,aO,true)}if(aM){a1=P(aJ,aS);aU=a1.getContext(\"2d\");aU.drawImage(aV,aT,aT,aQ,aW);aU.globalCompositeOperation=\"source-in\";aU.fillStyle=aN;aU.fillRect(0,0,aJ,aS);aU.globalCompositeOperation=\"destination-over\";aU.drawImage(aK,0,0);aU.globalCompositeOperation=\"source-over\";aZ.drawImage(a1,0,0)}else{aZ.drawImage(aV,aT,aT,aV.width,aV.height)}return{image:aK,width:aJ/a0,height:aS/a0}}function ar(aL,j,aK,aO,aP){var aM,aN,aI=parseFloat(j),aJ=s(aK,aO);aM=P(aK,aO);if(!aM){return null}if(j.indexOf(\"%\")>0){aI=aJ*aI/100}else{aI=aI*aP}aN=aM.getContext(\"2d\");aN.globalCompositeOperation=\"source-over\";aN.fillStyle=\"#fff\";if(aI>=aJ/2){aI=aE(aK,aO)/2;aN.beginPath();aN.moveTo(aK/2,aO/2);aN.arc(aK/2,aO/2,aI,0,2*Math.PI,false);aN.fill();aN.closePath()}else{aI=aE(aK/2,aO/2,aI);at(aN,0,0,aK,aO,aI,true);aN.fill()}aN.globalCompositeOperation=\"source-in\";aN.drawImage(aL,0,0,aK,aO);return aM}function Z(aO,aU,aQ,aK,aS,aT,aJ){var aV=L(aJ[0]),aP=L(aJ[1]),aL=aU+(aV>aT?aV+aT:aT*2)*aK,j=aQ+(aP>aT?aP+aT:aT*2)*aK,aN=aK*((aT||0)+(aJ[0]<0?aV:0)),aI=aK*((aT||0)+(aJ[1]<0?aP:0)),aM,aR;aM=P(aL,j);if(!aM){return null}aR=aM.getContext(\"2d\");aS&&(aR.shadowColor=aS);aT&&(aR.shadowBlur=aT*aK);aJ&&(aR.shadowOffsetX=aJ[0]*aK,aR.shadowOffsetY=aJ[1]*aK);aR.drawImage(aO,aN,aI,aU,aQ);return{image:aM,width:aL/aK,height:j/aK}}function t(aU,aM,aS){var aT=parseInt(aU.toString().length*aS),aL=parseInt(aS*2*aU.length),aJ=P(aT,aL),aP,j,aK,aO,aR,aQ,aI,aN;if(!aJ){return null}aP=aJ.getContext(\"2d\");aP.fillStyle=\"#000\";aP.fillRect(0,0,aT,aL);X(aP,aS+\"px \"+aM,\"#fff\",aU,0,0,0,0,[],\"centre\");j=aP.getImageData(0,0,aT,aL);aK=j.width;aO=j.height;aN={min:{x:aK,y:aO},max:{x:-1,y:-1}};for(aQ=0;aQ<aO;++aQ){for(aR=0;aR<aK;++aR){aI=(aQ*aK+aR)*4;if(j.data[aI+1]>0){if(aR<aN.min.x){aN.min.x=aR}if(aR>aN.max.x){aN.max.x=aR}if(aQ<aN.min.y){aN.min.y=aQ}if(aQ>aN.max.y){aN.max.y=aQ}}}}if(aK!=aT){aN.min.x*=(aT/aK);aN.max.x*=(aT/aK)}if(aO!=aL){aN.min.y*=(aT/aO);aN.max.y*=(aT/aO)}aJ=null;return aN}function o(i){return\"'\"+i.replace(/(\\'|\\\")/g,\"\").replace(/\\s*,\\s*/g,\"', '\")+\"'\"}function ad(i,j,aI){aI=aI||C;if(aI.addEventListener){aI.addEventListener(i,j,false)}else{aI.attachEvent(\"on\"+i,j)}}function a(i,j,aI){aI=aI||C;if(aI.removeEventListener){aI.removeEventListener(i,j)}else{aI.detachEvent(\"on\"+i,j)}}function ax(aM,aI,aQ,aL){var aR=aL.imageScale,aO,aJ,aN,j,aK,aP;if(!aI.complete){return ad(\"load\",function(){ax(aM,aI,aQ,aL)},aI)}if(!aM.complete){return ad(\"load\",function(){ax(aM,aI,aQ,aL)},aM)}aI.width=aI.width;aI.height=aI.height;if(aR){aM.width=aI.width*aR;aM.height=aI.height*aR}aQ.iw=aM.width;aQ.ih=aM.height;if(aL.txtOpt){aJ=aM;aO=aL.zoomMax*aL.txtScale;aK=aQ.iw*aO;aP=aQ.ih*aO;if(aK<aI.naturalWidth||aP<aI.naturalHeight){aJ=ay(aM,aK,aP);if(aJ){aQ.fimage=aJ}}else{aK=aQ.iw;aP=aQ.ih;aO=1}if(parseFloat(aL.imageRadius)){aQ.image=aQ.fimage=aM=ar(aQ.image,aL.imageRadius,aK,aP,aO)}if(!aQ.HasText()){if(aL.shadow){aJ=Z(aQ.image,aK,aP,aO,aL.shadow,aL.shadowBlur,aL.shadowOffset);if(aJ){aQ.fimage=aJ.image;aQ.w=aJ.width;aQ.h=aJ.height}}if(aL.bgColour||aL.bgOutlineThickness){aN=aL.bgColour==\"tag\"?Y(aQ.a,\"background-color\"):aL.bgColour;j=aL.bgOutline==\"tag\"?Y(aQ.a,\"color\"):(aL.bgOutline||aL.textColour);aK=aQ.fimage.width;aP=aQ.fimage.height;if(aL.outlineMethod==\"colour\"){aJ=aD(aQ.fimage,aK,aP,aO,aN,aL.bgOutlineThickness,aQ.outline.colour,aL.padding,aL.bgRadius,1);if(aJ){aQ.oimage=aJ.image}}aJ=aD(aQ.fimage,aK,aP,aO,aN,aL.bgOutlineThickness,j,aL.padding,aL.bgRadius);if(aJ){aQ.fimage=aJ.image;aQ.w=aJ.width;aQ.h=aJ.height}}if(aL.outlineMethod==\"size\"){if(aL.outlineIncrease>0){aQ.iw+=2*aL.outlineIncrease;aQ.ih+=2*aL.outlineIncrease;aK=aO*aQ.iw;aP=aO*aQ.ih;aJ=ay(aQ.fimage,aK,aP);aQ.oimage=aJ;aQ.fimage=v(aQ.fimage,aQ.oimage.width,aQ.oimage.height)}else{aK=aO*(aQ.iw+(2*aL.outlineIncrease));aP=aO*(aQ.ih+(2*aL.outlineIncrease));aJ=ay(aQ.fimage,aK,aP);aQ.oimage=v(aJ,aQ.fimage.width,aQ.fimage.height)}}}}aQ.Init()}function Y(aJ,aI){var j=C.defaultView,i=aI.replace(/\\-([a-z])/g,function(aK){return aK.charAt(1).toUpperCase()});return(j&&j.getComputedStyle&&j.getComputedStyle(aJ,null).getPropertyValue(aI))||(aJ.currentStyle&&aJ.currentStyle[i])}function u(j,aJ,aI){var i=1,aK;if(aJ){i=1*(j.getAttribute(aJ)||aI)}else{if(aK=Y(j,\"font-size\")){i=(aK.indexOf(\"px\")>-1&&aK.replace(\"px\",\"\")*1)||(aK.indexOf(\"pt\")>-1&&aK.replace(\"pt\",\"\")*1.25)||aK*3.3}}return i}function f(i){return i.target&&ai(i.target.id)?i.target.id:i.srcElement.parentNode.id}function S(aK,aL){var aJ,aI,i=parseInt(Y(aL,\"width\"))/aL.width,j=parseInt(Y(aL,\"height\"))/aL.height;if(ai(aK.offsetX)){aJ={x:aK.offsetX,y:aK.offsetY}}else{aI=ab(aL.id);if(ai(aK.changedTouches)){aK=aK.changedTouches[0]}if(aK.pageX){aJ={x:aK.pageX-aI.x,y:aK.pageY-aI.y}}}if(aJ&&i&&j){aJ.x/=i;aJ.y/=j}return aJ}function B(aI){var j=aI.target||aI.fromElement.parentNode,i=y.tc[j.id];if(i){i.mx=i.my=-1;i.UnFreeze();i.EndDrag()}}function af(aM){var aJ,aI=y,j,aL,aK=f(aM);for(aJ in aI.tc){j=aI.tc[aJ];if(j.tttimer){clearTimeout(j.tttimer);j.tttimer=null}}if(aK&&aI.tc[aK]){j=aI.tc[aK];if(aL=S(aM,j.canvas)){j.mx=aL.x;j.my=aL.y;j.Drag(aM,aL)}j.drawn=0}}function z(aJ){var j=y,i=C.addEventListener?0:1,aI=f(aJ);if(aI&&aJ.button==i&&j.tc[aI]){j.tc[aI].BeginDrag(aJ)}}function aF(aK){var aI=y,j=C.addEventListener?0:1,aJ=f(aK),i;if(aJ&&aK.button==j&&aI.tc[aJ]){i=aI.tc[aJ];af(aK);if(!i.EndDrag()&&!i.touchState){i.Clicked(aK)}}}function T(aJ){var j=f(aJ),i=(j&&y.tc[j]),aI;if(i&&aJ.changedTouches){if(aJ.touches.length==1&&i.touchState==0){i.touchState=1;i.BeginDrag(aJ);if(aI=S(aJ,i.canvas)){i.mx=aI.x;i.my=aI.y;i.drawn=0}}else{if(aJ.targetTouches.length==2&&i.pinchZoom){i.touchState=3;i.EndDrag();i.BeginPinch(aJ)}else{i.EndDrag();i.EndPinch();i.touchState=0}}}}function r(aI){var j=f(aI),i=(j&&y.tc[j]);if(i&&aI.changedTouches){switch(i.touchState){case 1:i.Draw();i.Clicked();break;case 2:i.EndDrag();break;case 3:i.EndPinch()}i.touchState=0}}function aA(aM){var aJ,aI=y,j,aL,aK=f(aM);for(aJ in aI.tc){j=aI.tc[aJ];if(j.tttimer){clearTimeout(j.tttimer);j.tttimer=null}}j=(aK&&aI.tc[aK]);if(j&&aM.changedTouches&&j.touchState){switch(j.touchState){case 1:case 2:if(aL=S(aM,j.canvas)){j.mx=aL.x;j.my=aL.y;if(j.Drag(aM,aL)){j.touchState=2}}break;case 3:j.Pinch(aM)}j.drawn=0}}function ag(aI){var i=y,j=f(aI);if(j&&i.tc[j]){aI.cancelBubble=true;aI.returnValue=false;aI.preventDefault&&aI.preventDefault();i.tc[j].Wheel((aI.wheelDelta||aI.detail)>0)}}function ac(aJ){var aI,j=y;clearTimeout(j.scrollTimer);for(aI in j.tc){j.tc[aI].Pause()}j.scrollTimer=setTimeout(function(){var aL,aK=y;for(aL in aK.tc){aK.tc[aL].Resume()}},j.scrollPause)}function O(){E(G())}function E(aJ){var j=y.tc,aI;y.NextFrame(y.interval);aJ=aJ||G();for(aI in j){j[aI].Draw(aJ)}}function ab(aI){var aL=C.getElementById(aI),i=aL.getBoundingClientRect(),aO=C.documentElement,aM=C.body,aN=window,aJ=aN.pageXOffset||aO.scrollLeft,aP=aN.pageYOffset||aO.scrollTop,aK=aO.clientLeft||aM.clientLeft,j=aO.clientTop||aM.clientTop;return{x:i.left+aJ-aK,y:i.top+aP-j}}function V(j,aJ,aK,aI){var i=j.radius*j.z1/(j.z1+j.z2+aJ.z);return{x:aJ.x*i*aK,y:aJ.y*i*aI,z:aJ.z,w:(j.z1-aJ.z)/j.z2}}function aC(i){this.e=i;this.br=0;this.line=[];this.text=[];this.original=i.innerText||i.textContent}aH=aC.prototype;aH.Empty=function(){for(var j=0;j<this.text.length;++j){if(this.text[j].length){return false}}return true};aH.Lines=function(aK){var aJ=aK?1:0,aL,j,aI;aK=aK||this.e;aL=aK.childNodes;j=aL.length;for(aI=0;aI<j;++aI){if(aL[aI].nodeName==\"BR\"){this.text.push(this.line.join(\" \"));this.br=1}else{if(aL[aI].nodeType==3){if(this.br){this.line=[aL[aI].nodeValue];this.br=0}else{this.line.push(aL[aI].nodeValue)}}else{this.Lines(aL[aI])}}}aJ||this.br||this.text.push(this.line.join(\" \"));return this.text};aH.SplitWidth=function(aI,aP,aM,aL){var aK,aJ,aO,aN=[];aP.font=aL+\"px \"+aM;for(aK=0;aK<this.text.length;++aK){aO=this.text[aK].split(/\\s+/);this.line=[aO[0]];for(aJ=1;aJ<aO.length;++aJ){if(aP.measureText(this.line.join(\" \")+\" \"+aO[aJ]).width>aI){aN.push(this.line.join(\" \"));this.line=[aO[aJ]]}else{this.line.push(aO[aJ])}}aN.push(this.line.join(\" \"))}return this.text=aN};function J(i,j){this.ts=null;this.tc=i;this.tag=j;this.x=this.y=this.w=this.h=this.sc=1;this.z=0;this.pulse=1;this.pulsate=i.pulsateTo<1;this.colour=i.outlineColour;this.adash=~~i.outlineDash;this.agap=~~i.outlineDashSpace||this.adash;this.aspeed=i.outlineDashSpeed*1;if(this.colour==\"tag\"){this.colour=Y(j.a,\"color\")}else{if(this.colour==\"tagbg\"){this.colour=Y(j.a,\"background-color\")}}this.Draw=this.pulsate?this.DrawPulsate:this.DrawSimple;this.radius=i.outlineRadius|0;this.SetMethod(i.outlineMethod)}x=J.prototype;x.SetMethod=function(aI){var j={block:[\"PreDraw\",\"DrawBlock\"],colour:[\"PreDraw\",\"DrawColour\"],outline:[\"PostDraw\",\"DrawOutline\"],classic:[\"LastDraw\",\"DrawOutline\"],size:[\"PreDraw\",\"DrawSize\"],none:[\"LastDraw\"]},i=j[aI]||j.outline;if(aI==\"none\"){this.Draw=function(){return 1}}else{this.drawFunc=this[i[1]]}this[i[0]]=this.Draw};x.Update=function(aO,aN,aP,aK,aL,aM,aJ,i){var j=this.tc.outlineOffset,aI=2*j;this.x=aL*aO+aJ-j;this.y=aL*aN+i-j;this.w=aL*aP+aI;this.h=aL*aK+aI;this.sc=aL;this.z=aM};x.Ants=function(aN){if(!this.adash){return}var aK=this.adash,aM=this.agap,aQ=this.aspeed,j=aK+aM,aL=0,aJ=aK,i=aM,aP=0,aO=0,aI;if(aQ){aO=L(aQ)*(G()-this.ts)/50;if(aQ<0){aO=8640000-aO}aQ=~~aO%j}if(aQ){if(aK>=aQ){aL=aK-aQ;aJ=aQ}else{i=j-aQ;aP=aM-i}aI=[aL,i,aJ,aP]}else{aI=[aK,aM]}aN.setLineDash(aI)};x.DrawOutline=function(aM,i,aL,j,aI,aK){var aJ=aE(this.radius,aI/2,j/2);aM.strokeStyle=aK;this.Ants(aM);at(aM,i,aL,j,aI,aJ,true)};x.DrawSize=function(aP,aS,aQ,aT,aN,j,aU,aJ,aR){var aM=aU.w,aI=aU.h,aK,aL,aO;if(this.pulsate){if(aU.image){aO=(aU.image.height+this.tc.outlineIncrease)/aU.image.height}else{aO=aU.oscale}aL=aU.fimage||aU.image;aK=1+((aO-1)*(1-this.pulse));aU.h*=aK;aU.w*=aK}else{aL=aU.oimage}aU.alpha=1;aU.Draw(aP,aJ,aR,aL);aU.h=aI;aU.w=aM;return 1};x.DrawColour=function(aJ,aM,aK,aN,aI,i,aO,j,aL){if(aO.oimage){if(this.pulse<1){aO.alpha=1-au(this.pulse,2);aO.Draw(aJ,j,aL,aO.fimage);aO.alpha=this.pulse}else{aO.alpha=1}aO.Draw(aJ,j,aL,aO.oimage);return 1}return this[aO.image?\"DrawColourImage\":\"DrawColourText\"](aJ,aM,aK,aN,aI,i,aO,j,aL)};x.DrawColourText=function(aK,aN,aL,aO,aI,i,aP,j,aM){var aJ=aP.colour;aP.colour=i;aP.alpha=1;aP.Draw(aK,j,aM);aP.colour=aJ;return 1};x.DrawColourImage=function(aN,aQ,aO,aR,aM,i,aU,j,aP){var aS=aN.canvas,aK=~~s(aQ,0),aJ=~~s(aO,0),aL=aE(aS.width-aK,aR)+0.5|0,aT=aE(aS.height-aJ,aM)+0.5|0,aI;if(p){p.width=aL,p.height=aT}else{p=P(aL,aT)}if(!p){return this.SetMethod(\"outline\")}aI=p.getContext(\"2d\");aI.drawImage(aS,aK,aJ,aL,aT,0,0,aL,aT);aN.clearRect(aK,aJ,aL,aT);if(this.pulsate){aU.alpha=1-au(this.pulse,2)}else{aU.alpha=1}aU.Draw(aN,j,aP);aN.setTransform(1,0,0,1,0,0);aN.save();aN.beginPath();aN.rect(aK,aJ,aL,aT);aN.clip();aN.globalCompositeOperation=\"source-in\";aN.fillStyle=i;aN.fillRect(aK,aJ,aL,aT);aN.restore();aN.globalAlpha=1;aN.globalCompositeOperation=\"destination-over\";aN.drawImage(p,0,0,aL,aT,aK,aJ,aL,aT);aN.globalCompositeOperation=\"source-over\";return 1};x.DrawBlock=function(aM,i,aL,j,aI,aK){var aJ=aE(this.radius,aI/2,j/2);aM.fillStyle=aK;at(aM,i,aL,j,aI,aJ)};x.DrawSimple=function(aM,i,j,aJ,aL,aK){var aI=this.tc;aM.setTransform(1,0,0,1,0,0);aM.strokeStyle=this.colour;aM.lineWidth=aI.outlineThickness;aM.shadowBlur=aM.shadowOffsetX=aM.shadowOffsetY=0;aM.globalAlpha=aK?aL:1;return this.drawFunc(aM,this.x,this.y,this.w,this.h,this.colour,i,j,aJ)};x.DrawPulsate=function(aM,i,j,aJ){var aK=G()-this.ts,aI=this.tc,aL=aI.pulsateTo+((1-aI.pulsateTo)*(0.5+(w(2*Math.PI*aK/(1000*aI.pulsateTime))/2)));this.pulse=aL=y.Smooth(1,aL);return this.DrawSimple(aM,i,j,aJ,aL,1)};x.Active=function(aJ,i,aI){var j=(i>=this.x&&aI>=this.y&&i<=this.x+this.w&&aI<=this.y+this.h);if(j){this.ts=this.ts||G()}else{this.ts=null}return j};x.PreDraw=x.PostDraw=x.LastDraw=aB;function e(aJ,aT,aP,aS,aQ,aK,aI,aM,aR,aL,aO,j,aN,i){this.tc=aJ;this.image=null;this.text=aT;this.text_original=i;this.line_widths=[];this.title=aP.title||null;this.a=aP;this.position=new ae(aS[0],aS[1],aS[2]);this.x=this.y=this.z=0;this.w=aQ;this.h=aK;this.colour=aI||aJ.textColour;this.bgColour=aM||aJ.bgColour;this.bgRadius=aR|0;this.bgOutline=aL||this.colour;this.bgOutlineThickness=aO|0;this.textFont=j||aJ.textFont;this.padding=aN|0;this.sc=this.alpha=1;this.weighted=!aJ.weight;this.outline=new J(aJ,this)}c=e.prototype;c.Init=function(j){var i=this.tc;this.textHeight=i.textHeight;if(this.HasText()){this.Measure(i.ctxt,i)}else{this.w=this.iw;this.h=this.ih}this.SetShadowColour=i.shadowAlpha?this.SetShadowColourAlpha:this.SetShadowColourFixed;this.SetDraw(i)};c.Draw=aB;c.HasText=function(){return this.text&&this.text[0].length>0};c.EqualTo=function(aI){var j=aI.getElementsByTagName(\"img\");if(this.a.href!=aI.href){return 0}if(j.length){return this.image.src==j[0].src}return(aI.innerText||aI.textContent)==this.text_original};c.SetImage=function(j){this.image=this.fimage=j};c.SetDraw=function(i){this.Draw=this.fimage?(i.ie>7?this.DrawImageIE:this.DrawImage):this.DrawText;i.noSelect&&(this.CheckActive=aB)};c.MeasureText=function(aL){var aJ,aI=this.text.length,j=0,aK;for(aJ=0;aJ<aI;++aJ){this.line_widths[aJ]=aK=aL.measureText(this.text[aJ]).width;j=s(j,aK)}return j};c.Measure=function(aN,aQ){var aO=t(this.text,this.textFont,this.textHeight),aR,i,aK,j,aI,aM,aP,aJ,aL;aP=aO?aO.max.y+aO.min.y:this.textHeight;aN.font=this.font=this.textHeight+\"px \"+this.textFont;aM=this.MeasureText(aN);if(aQ.txtOpt){aR=aQ.txtScale;i=aR*this.textHeight;aK=i+\"px \"+this.textFont;j=[aR*aQ.shadowOffset[0],aR*aQ.shadowOffset[1]];aN.font=aK;aI=this.MeasureText(aN);aL=new g(this.text,aK,aI+aR,(aR*aP)+aR,aI,this.line_widths,aQ.textAlign,aQ.textVAlign,aR);if(this.image){aL.SetImage(this.image,this.iw,this.ih,aQ.imagePosition,aQ.imagePadding,aQ.imageAlign,aQ.imageVAlign,aQ.imageScale)}aJ=aL.Create(this.colour,this.bgColour,this.bgOutline,aR*this.bgOutlineThickness,aQ.shadow,aR*aQ.shadowBlur,j,aR*this.padding,aR*this.bgRadius);if(aQ.outlineMethod==\"colour\"){this.oimage=aL.Create(this.outline.colour,this.bgColour,this.outline.colour,aR*this.bgOutlineThickness,aQ.shadow,aR*aQ.shadowBlur,j,aR*this.padding,aR*this.bgRadius)}else{if(aQ.outlineMethod==\"size\"){aO=t(this.text,this.textFont,this.textHeight+aQ.outlineIncrease);i=aO.max.y+aO.min.y;aK=(aR*(this.textHeight+aQ.outlineIncrease))+\"px \"+this.textFont;aN.font=aK;aI=this.MeasureText(aN);aL=new g(this.text,aK,aI+aR,(aR*i)+aR,aI,this.line_widths,aQ.textAlign,aQ.textVAlign,aR);if(this.image){aL.SetImage(this.image,this.iw+aQ.outlineIncrease,this.ih+aQ.outlineIncrease,aQ.imagePosition,aQ.imagePadding,aQ.imageAlign,aQ.imageVAlign,aQ.imageScale)}this.oimage=aL.Create(this.colour,this.bgColour,this.bgOutline,aR*this.bgOutlineThickness,aQ.shadow,aR*aQ.shadowBlur,j,aR*this.padding,aR*this.bgRadius);this.oscale=this.oimage.width/aJ.width;if(aQ.outlineIncrease>0){aJ=v(aJ,this.oimage.width,this.oimage.height)}else{this.oimage=v(this.oimage,aJ.width,aJ.height)}}}if(aJ){this.fimage=aJ;aM=this.fimage.width/aR;aP=this.fimage.height/aR}this.SetDraw(aQ);aQ.txtOpt=!!this.fimage}this.h=aP;this.w=aM};c.SetFont=function(j,aJ,aI,i){this.textFont=j;this.colour=aJ;this.bgColour=aI;this.bgOutline=i;this.Measure(this.tc.ctxt,this.tc)};c.SetWeight=function(aI){var j=this.tc,aK=j.weightMode.split(/[, ]/),i,aJ,aL=aI.length;if(!this.HasText()){return}this.weighted=true;for(aJ=0;aJ<aL;++aJ){i=aK[aJ]||\"size\";if(\"both\"==i){this.Weight(aI[aJ],j.ctxt,j,\"size\",j.min_weight[aJ],j.max_weight[aJ],aJ);this.Weight(aI[aJ],j.ctxt,j,\"colour\",j.min_weight[aJ],j.max_weight[aJ],aJ)}else{this.Weight(aI[aJ],j.ctxt,j,i,j.min_weight[aJ],j.max_weight[aJ],aJ)}}this.Measure(j.ctxt,j)};c.Weight=function(aI,aN,aJ,j,aM,aK,aL){aI=isNaN(aI)?1:aI;var i=(aI-aM)/(aK-aM);if(\"colour\"==j){this.colour=k(aJ,i,aL)}else{if(\"bgcolour\"==j){this.bgColour=k(aJ,i,aL)}else{if(\"bgoutline\"==j){this.bgOutline=k(aJ,i,aL)}else{if(\"outline\"==j){this.outline.colour=k(aJ,i,aL)}else{if(\"size\"==j){if(aJ.weightSizeMin>0&&aJ.weightSizeMax>aJ.weightSizeMin){this.textHeight=aJ.weightSize*(aJ.weightSizeMin+(aJ.weightSizeMax-aJ.weightSizeMin)*i)}else{this.textHeight=s(1,aI*aJ.weightSize)}}}}}}};c.SetShadowColourFixed=function(aI,j,i){aI.shadowColor=j};c.SetShadowColourAlpha=function(aI,j,i){aI.shadowColor=U(j,i)};c.DrawText=function(aK,aN,aJ){var aO=this.tc,aM=this.x,aL=this.y,aP=this.sc,j,aI;aK.globalAlpha=this.alpha;aK.fillStyle=this.colour;aO.shadow&&this.SetShadowColour(aK,aO.shadow,this.alpha);aK.font=this.font;aM+=aN/aP;aL+=(aJ/aP)-(this.h/2);for(j=0;j<this.text.length;++j){aI=aM;if(\"right\"==aO.textAlign){aI+=this.w/2-this.line_widths[j]}else{if(\"centre\"==aO.textAlign){aI-=this.line_widths[j]/2}else{aI-=this.w/2}}aK.setTransform(aP,0,0,aP,aP*aI,aP*aL);aK.fillText(this.text[j],0,0);aL+=this.textHeight}};c.DrawImage=function(aK,aR,aJ,aM){var aO=this.x,aL=this.y,aS=this.sc,j=aM||this.fimage,aP=this.w,aI=this.h,aN=this.alpha,aQ=this.shadow;aK.globalAlpha=aN;aQ&&this.SetShadowColour(aK,aQ,aN);aO+=(aR/aS)-(aP/2);aL+=(aJ/aS)-(aI/2);aK.setTransform(aS,0,0,aS,aS*aO,aS*aL);aK.drawImage(j,0,0,aP,aI)};c.DrawImageIE=function(aK,aO,aJ){var j=this.fimage,aP=this.sc,aN=j.width=this.w*aP,aI=j.height=this.h*aP,aM=(this.x*aP)+aO-(aN/2),aL=(this.y*aP)+aJ-(aI/2);aK.setTransform(1,0,0,1,0,0);aK.globalAlpha=this.alpha;aK.drawImage(j,aM,aL)};c.Calc=function(i,aI){var j,aL=this.tc,aK=aL.minBrightness,aJ=aL.maxBrightness,aM=aL.max_radius;j=i.xform(this.position);this.xformed=j;j=V(aL,j,aL.stretchX,aL.stretchY);this.x=j.x;this.y=j.y;this.z=j.z;this.sc=j.w;this.alpha=aI*aw(aK+(aJ-aK)*(aM-this.z)/(2*aM),0,1);return this.xformed};c.UpdateActive=function(aN,aI,aL){var aK=this.outline,j=this.w,aJ=this.h,i=this.x-j/2,aM=this.y-aJ/2;aK.Update(i,aM,j,aJ,this.sc,this.z,aI,aL);return aK};c.CheckActive=function(aK,i,aJ){var j=this.tc,aI=this.UpdateActive(aK,i,aJ);return aI.Active(aK,j.mx,j.my)?aI:null};c.Clicked=function(aL){var j=this.a,aI=j.target,aJ=j.href,i;if(aI!=\"\"&&aI!=\"_self\"){if(self.frames[aI]){self.frames[aI].document.location=aJ}else{try{if(top.frames[aI]){top.frames[aI].document.location=aJ;return}}catch(aK){}window.open(aJ,aI)}return}if(C.createEvent){i=C.createEvent(\"MouseEvents\");i.initMouseEvent(\"click\",1,1,window,0,0,0,0,0,0,0,0,0,0,null);if(!j.dispatchEvent(i)){return}}else{if(j.fireEvent){if(!j.fireEvent(\"onclick\")){return}}}C.location=aJ};function y(aO,j,aJ){var aI,aL,aN=C.getElementById(aO),aK=[\"id\",\"class\",\"innerHTML\"],aM;if(!aN){throw 0}if(ai(window.G_vmlCanvasManager)){aN=window.G_vmlCanvasManager.initElement(aN);this.ie=parseFloat(navigator.appVersion.split(\"MSIE\")[1])}if(aN&&(!aN.getContext||!aN.getContext(\"2d\").fillText)){aL=C.createElement(\"DIV\");for(aI=0;aI<aK.length;++aI){aL[aK[aI]]=aN[aK[aI]]}aN.parentNode.insertBefore(aL,aN);aN.parentNode.removeChild(aN);throw 0}for(aI in y.options){this[aI]=aJ&&ai(aJ[aI])?aJ[aI]:(ai(y[aI])?y[aI]:y.options[aI])}this.canvas=aN;this.ctxt=aN.getContext(\"2d\");this.z1=250/s(this.depth,0.001);this.z2=this.z1/this.zoom;this.radius=aE(aN.height,aN.width)*0.0075;this.max_radius=100;this.max_weight=[];this.min_weight=[];this.textFont=this.textFont&&o(this.textFont);this.textHeight*=1;this.imageRadius=this.imageRadius.toString();this.pulsateTo=aw(this.pulsateTo,0,1);this.minBrightness=aw(this.minBrightness,0,1);this.maxBrightness=aw(this.maxBrightness,this.minBrightness,1);this.ctxt.textBaseline=\"top\";this.lx=(this.lock+\"\").indexOf(\"x\")+1;this.ly=(this.lock+\"\").indexOf(\"y\")+1;this.frozen=this.dx=this.dy=this.fixedAnim=this.touchState=0;this.fixedAlpha=1;this.source=j||aO;this.repeatTags=aE(64,~~this.repeatTags);this.minTags=aE(200,~~this.minTags);if(~~this.scrollPause>0){y.scrollPause=~~this.scrollPause}else{this.scrollPause=0}if(this.minTags>0&&this.repeatTags<1&&(aI=this.GetTags().length)){this.repeatTags=aq(this.minTags/aI)-1}this.transform=R.Identity();this.startTime=this.time=G();this.mx=this.my=-1;this.centreImage&&ao(this);this.Animate=this.dragControl?this.AnimateDrag:this.AnimatePosition;this.animTiming=(typeof y[this.animTiming]==\"function\"?y[this.animTiming]:y.Smooth);if(this.shadowBlur||this.shadowOffset[0]||this.shadowOffset[1]){this.ctxt.shadowColor=this.shadow;this.shadow=this.ctxt.shadowColor;this.shadowAlpha=al()}else{delete this.shadow}this.Load();if(j&&this.hideTags){(function(i){if(y.loaded){i.HideTags()}else{ad(\"load\",function(){i.HideTags()},window)}})(this)}this.yaw=this.initial?this.initial[0]*this.maxSpeed:0;this.pitch=this.initial?this.initial[1]*this.maxSpeed:0;if(this.tooltip){this.ctitle=aN.title;aN.title=\"\";if(this.tooltip==\"native\"){this.Tooltip=this.TooltipNative}else{this.Tooltip=this.TooltipDiv;if(!this.ttdiv){this.ttdiv=C.createElement(\"div\");this.ttdiv.className=this.tooltipClass;this.ttdiv.style.position=\"absolute\";this.ttdiv.style.zIndex=aN.style.zIndex+1;ad(\"mouseover\",function(i){i.target.style.display=\"none\"},this.ttdiv);C.body.appendChild(this.ttdiv)}}}else{this.Tooltip=this.TooltipNone}if(!this.noMouse&&!b[aO]){b[aO]=[[\"mousemove\",af],[\"mouseout\",B],[\"mouseup\",aF],[\"touchstart\",T],[\"touchend\",r],[\"touchcancel\",r],[\"touchmove\",aA]];if(this.dragControl){b[aO].push([\"mousedown\",z]);b[aO].push([\"selectstart\",aB])}if(this.wheelZoom){b[aO].push([\"mousewheel\",ag]);b[aO].push([\"DOMMouseScroll\",ag])}if(this.scrollPause){b[aO].push([\"scroll\",ac,window])}for(aI=0;aI<b[aO].length;++aI){aL=b[aO][aI];ad(aL[0],aL[1],aL[2]?aL[2]:aN)}}if(!y.started){aM=window.requestAnimationFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame;y.NextFrame=aM?y.NextFrameRAF:y.NextFrameTimeout;y.interval=this.interval;y.NextFrame(this.interval);y.started=1}}Q=y.prototype;Q.SourceElements=function(){if(C.querySelectorAll){return C.querySelectorAll(\"#\"+this.source)}return[C.getElementById(this.source)]};Q.HideTags=function(){var aI=this.SourceElements(),j;for(j=0;j<aI.length;++j){aI[j].style.display=\"none\"}};Q.GetTags=function(){var aN=this.SourceElements(),aM,aJ=[],aL,aK,aI;for(aI=0;aI<=this.repeatTags;++aI){for(aL=0;aL<aN.length;++aL){aM=aN[aL].getElementsByTagName(\"a\");for(aK=0;aK<aM.length;++aK){aJ.push(aM[aK])}}}return aJ};Q.Message=function(aN){var aP=[],aJ,j,aI=aN.split(\"\"),aL,aO,aM,aK;for(aJ=0;aJ<aI.length;++aJ){if(aI[aJ]!=\" \"){j=aJ-aI.length/2;aL=C.createElement(\"A\");aL.href=\"#\";aL.innerText=aI[aJ];aM=100*ah(j/9);aK=-100*w(j/9);aO=new e(this,aI[aJ],aL,[aM,0,aK],2,18,\"#000\",\"#fff\",0,0,0,\"monospace\",2,aI[aJ]);aO.Init();aP.push(aO)}}return aP};Q.CreateTag=function(aM){var aP,aK,aQ,aL,aO,aI,aN,aJ,j=[0,0,0];if(\"text\"!=this.imageMode){aP=aM.getElementsByTagName(\"img\");if(aP.length){aK=new Image;aK.src=aP[0].src;if(!this.imageMode){aQ=new e(this,\"\",aM,j,0,0);aQ.SetImage(aK);ax(aK,aP[0],aQ,this);return aQ}}}if(\"image\"!=this.imageMode){aO=new aC(aM);aL=aO.Lines();if(!aO.Empty()){aI=this.textFont||o(Y(aM,\"font-family\"));if(this.splitWidth){aL=aO.SplitWidth(this.splitWidth,this.ctxt,aI,this.textHeight)}aN=this.bgColour==\"tag\"?Y(aM,\"background-color\"):this.bgColour;aJ=this.bgOutline==\"tag\"?Y(aM,\"color\"):this.bgOutline}else{aO=null}}if(aO||aK){aQ=new e(this,aL,aM,j,2,this.textHeight+2,this.textColour||Y(aM,\"color\"),aN,this.bgRadius,aJ,this.bgOutlineThickness,aI,this.padding,aO&&aO.original);if(aK){aQ.SetImage(aK);ax(aK,aP[0],aQ,this)}else{aQ.Init()}return aQ}};Q.UpdateTag=function(aI,i){var aL=this.textColour||Y(i,\"color\"),j=this.textFont||o(Y(i,\"font-family\")),aK=this.bgColour==\"tag\"?Y(i,\"background-color\"):this.bgColour,aJ=this.bgOutline==\"tag\"?Y(i,\"color\"):this.bgOutline;aI.a=i;aI.title=i.title;if(aI.colour!=aL||aI.textFont!=j||aI.bgColour!=aK||aI.bgOutline!=aJ){aI.SetFont(j,aL,aK,aJ)}};Q.Weight=function(aO){var aK=aO.length,aM,aI,aP,aL=[],j,aJ=this.weightFrom?this.weightFrom.split(/[, ]/):[null],aN=aJ.length;for(aI=0;aI<aK;++aI){aL[aI]=[];for(aP=0;aP<aN;++aP){aM=u(aO[aI].a,aJ[aP],this.textHeight);if(!this.max_weight[aP]||aM>this.max_weight[aP]){this.max_weight[aP]=aM}if(!this.min_weight[aP]||aM<this.min_weight[aP]){this.min_weight[aP]=aM}aL[aI][aP]=aM}}for(aP=0;aP<aN;++aP){if(this.max_weight[aP]>this.min_weight[aP]){j=1}}if(j){for(aI=0;aI<aK;++aI){aO[aI].SetWeight(aL[aI])}}};Q.Load=function(){var aS=this.GetTags(),aN=[],aQ,aR,aM,aJ,aI,j,aK,aP,aL=[],aO={sphere:q,vcylinder:am,hcylinder:av,vring:d,hring:n};if(aS.length){aL.length=aS.length;for(aP=0;aP<aS.length;++aP){aL[aP]=aP}this.shuffleTags&&an(aL);aJ=100*this.radiusX;aI=100*this.radiusY;j=100*this.radiusZ;this.max_radius=s(aJ,s(aI,j));for(aP=0;aP<aS.length;++aP){aR=this.CreateTag(aS[aL[aP]]);if(aR){aN.push(aR)}}this.weight&&this.Weight(aN,true);if(this.shapeArgs){this.shapeArgs[0]=aN.length}else{aM=this.shape.toString().split(/[(),]/);aQ=aM.shift();if(typeof window[aQ]===\"function\"){this.shape=window[aQ]}else{this.shape=aO[aQ]||aO.sphere}this.shapeArgs=[aN.length,aJ,aI,j].concat(aM)}aK=this.shape.apply(this,this.shapeArgs);this.listLength=aN.length;for(aP=0;aP<aN.length;++aP){aN[aP].position=new ae(aK[aP][0],aK[aP][1],aK[aP][2])}}if(this.noTagsMessage&&!aN.length){aP=(this.imageMode&&this.imageMode!=\"both\"?this.imageMode+\" \":\"\");aN=this.Message(\"No \"+aP+\"tags\")}this.taglist=aN};Q.Update=function(){var aR=this.GetTags(),aQ=[],aL=this.taglist,aS,aP=[],aN=[],aJ,aO,aI,aM,aK;if(!this.shapeArgs){return this.Load()}if(aR.length){aI=this.listLength=aR.length;aO=aL.length;for(aM=0;aM<aO;++aM){aQ.push(aL[aM]);aN.push(aM)}for(aM=0;aM<aI;++aM){for(aK=0,aS=0;aK<aO;++aK){if(aL[aK].EqualTo(aR[aM])){this.UpdateTag(aQ[aK],aR[aM]);aS=aN[aK]=-1}}if(!aS){aP.push(aM)}}for(aM=0,aK=0;aM<aO;++aM){if(aN[aK]==-1){aN.splice(aK,1)}else{++aK}}if(aN.length){an(aN);while(aN.length&&aP.length){aM=aN.shift();aK=aP.shift();aQ[aM]=this.CreateTag(aR[aK])}aN.sort(function(j,i){return j-i});while(aN.length){aQ.splice(aN.pop(),1)}}aK=aQ.length/(aP.length+1);aM=0;while(aP.length){aQ.splice(aq(++aM*aK),0,this.CreateTag(aR[aP.shift()]))}this.shapeArgs[0]=aI=aQ.length;aJ=this.shape.apply(this,this.shapeArgs);for(aM=0;aM<aI;++aM){aQ[aM].position=new ae(aJ[aM][0],aJ[aM][1],aJ[aM][2])}this.weight&&this.Weight(aQ)}this.taglist=aQ};Q.SetShadow=function(i){i.shadowBlur=this.shadowBlur;i.shadowOffsetX=this.shadowOffset[0];i.shadowOffsetY=this.shadowOffset[1]};Q.Draw=function(aS){if(this.paused){return}var aM=this.canvas,aK=aM.width,aR=aM.height,aU=0,aJ=(aS-this.time)*y.interval/1000,aQ=aK/2+this.offsetX,aP=aR/2+this.offsetY,aY=this.ctxt,aO,aZ,aW,aI=-1,aL=this.taglist,aV=aL.length,j=this.frontSelect,aT=(this.centreFunc==aB),aN;this.time=aS;if(this.frozen&&this.drawn){return this.Animate(aK,aR,aJ)}aN=this.AnimateFixed();aY.setTransform(1,0,0,1,0,0);for(aW=0;aW<aV;++aW){aL[aW].Calc(this.transform,this.fixedAlpha)}aL=A(aL,function(a0,i){return i.z-a0.z});if(aN&&this.fixedAnim.active){aO=this.fixedAnim.tag.UpdateActive(aY,aQ,aP)}else{this.active=null;for(aW=0;aW<aV;++aW){aZ=this.mx>=0&&this.my>=0&&this.taglist[aW].CheckActive(aY,aQ,aP);if(aZ&&aZ.sc>aU&&(!j||aZ.z<=0)){aO=aZ;aI=aW;aO.tag=this.taglist[aW];aU=aZ.sc}}this.active=aO}this.txtOpt||(this.shadow&&this.SetShadow(aY));aY.clearRect(0,0,aK,aR);for(aW=0;aW<aV;++aW){if(!aT&&aL[aW].z<=0){try{this.centreFunc(aY,aK,aR,aQ,aP)}catch(aX){alert(aX);this.centreFunc=aB}aT=true}if(!(aO&&aO.tag==aL[aW]&&aO.PreDraw(aY,aL[aW],aQ,aP))){aL[aW].Draw(aY,aQ,aP)}aO&&aO.tag==aL[aW]&&aO.PostDraw(aY)}if(this.freezeActive&&aO){this.Freeze()}else{this.UnFreeze();this.drawn=(aV==this.listLength)}if(this.fixedCallback){this.fixedCallback(this,this.fixedCallbackTag);this.fixedCallback=null}aN||this.Animate(aK,aR,aJ);aO&&aO.LastDraw(aY);aM.style.cursor=aO?this.activeCursor:\"\";this.Tooltip(aO,this.taglist[aI])};Q.TooltipNone=function(){};Q.TooltipNative=function(j,i){if(j){this.canvas.title=i&&i.title?i.title:\"\"}else{this.canvas.title=this.ctitle}};Q.SetTTDiv=function(aJ,j){var i=this,aI=i.ttdiv.style;if(aJ!=i.ttdiv.innerHTML){aI.display=\"none\"}i.ttdiv.innerHTML=aJ;j&&(j.title=i.ttdiv.innerHTML);if(aI.display==\"none\"&&!i.tttimer){i.tttimer=setTimeout(function(){var aK=ab(i.canvas.id);aI.display=\"block\";aI.left=aK.x+i.mx+\"px\";aI.top=aK.y+i.my+24+\"px\";i.tttimer=null},i.tooltipDelay)}};Q.TooltipDiv=function(j,i){if(j&&i&&i.title){this.SetTTDiv(i.title,i)}else{if(!j&&this.mx!=-1&&this.my!=-1&&this.ctitle.length){this.SetTTDiv(this.ctitle)}else{this.ttdiv.style.display=\"none\"}}};Q.Transform=function(aL,i,aN){if(i||aN){var j=ah(i),aM=w(i),aO=ah(aN),aK=w(aN),aI=new R([aK,0,aO,0,1,0,-aO,0,aK]),aJ=new R([1,0,0,0,aM,-j,0,j,aM]);aL.transform=aL.transform.mul(aI.mul(aJ))}};Q.AnimateFixed=function(){var aI,j,aK,i,aJ;if(this.fadeIn){j=G()-this.startTime;if(j>=this.fadeIn){this.fadeIn=0;this.fixedAlpha=1}else{this.fixedAlpha=j/this.fadeIn}}if(this.fixedAnim){if(!this.fixedAnim.transform){this.fixedAnim.transform=this.transform}aI=this.fixedAnim,j=G()-aI.t0,aK=aI.angle,i,aJ=this.animTiming(aI.t,j);this.transform=aI.transform;if(j>=aI.t){this.fixedCallbackTag=aI.tag;this.fixedCallback=aI.cb;this.fixedAnim=this.yaw=this.pitch=0}else{aK*=aJ}i=R.Rotation(aK,aI.axis);this.transform=this.transform.mul(i);return(this.fixedAnim!=0)}return false};Q.AnimatePosition=function(aI,aL,aJ){var j=this,i=j.mx,aN=j.my,aK,aM;if(!j.frozen&&i>=0&&aN>=0&&i<aI&&aN<aL){aK=j.maxSpeed,aM=j.reverse?-1:1;j.lx||(j.yaw=((i*2*aK/aI)-aK)*aM*aJ);j.ly||(j.pitch=((aN*2*aK/aL)-aK)*-aM*aJ);j.initial=null}else{if(!j.initial){if(j.frozen&&!j.freezeDecel){j.yaw=j.pitch=0}else{j.Decel(j)}}}this.Transform(j,j.pitch,j.yaw)};Q.AnimateDrag=function(j,aK,aJ){var i=this,aI=100*aJ*i.maxSpeed/i.max_radius/i.zoom;if(i.dx||i.dy){i.lx||(i.yaw=i.dx*aI/i.stretchX);i.ly||(i.pitch=i.dy*-aI/i.stretchY);i.dx=i.dy=0;i.initial=null}else{if(!i.initial){i.Decel(i)}}this.Transform(i,i.pitch,i.yaw)};Q.Freeze=function(){if(!this.frozen){this.preFreeze=[this.yaw,this.pitch];this.frozen=1;this.drawn=0}};Q.UnFreeze=function(){if(this.frozen){this.yaw=this.preFreeze[0];this.pitch=this.preFreeze[1];this.frozen=0}};Q.Decel=function(i){var aI=i.minSpeed,aJ=L(i.yaw),j=L(i.pitch);if(!i.lx&&aJ>aI){i.yaw=aJ>i.z0?i.yaw*i.decel:0}if(!i.ly&&j>aI){i.pitch=j>i.z0?i.pitch*i.decel:0}};Q.Zoom=function(i){this.z2=this.z1*(1/i);this.drawn=0};Q.Clicked=function(aI){var i=this.active;try{if(i&&i.tag){if(this.clickToFront===false||this.clickToFront===null){i.tag.Clicked(aI)}else{this.TagToFront(i.tag,this.clickToFront,function(){i.tag.Clicked(aI)},true)}}}catch(j){}};Q.Wheel=function(j){var aI=this.zoom+this.zoomStep*(j?1:-1);this.zoom=aE(this.zoomMax,s(this.zoomMin,aI));this.Zoom(this.zoom)};Q.BeginDrag=function(i){this.down=S(i,this.canvas);i.cancelBubble=true;i.returnValue=false;i.preventDefault&&i.preventDefault()};Q.Drag=function(aK,aJ){if(this.dragControl&&this.down){var aI=this.dragThreshold*this.dragThreshold,j=aJ.x-this.down.x,i=aJ.y-this.down.y;if(this.dragging||j*j+i*i>aI){this.dx=j;this.dy=i;this.dragging=1;this.down=aJ}}return this.dragging};Q.EndDrag=function(){var i=this.dragging;this.dragging=this.down=null;return i};function D(aI){var j=aI.targetTouches[0],i=aI.targetTouches[1];return F(au(i.pageX-j.pageX,2)+au(i.pageY-j.pageY,2))}Q.BeginPinch=function(i){this.pinched=[D(i),this.zoom];i.preventDefault&&i.preventDefault()};Q.Pinch=function(j){var aJ,aI,i=this.pinched;if(!i){return}aI=D(j);aJ=i[1]*aI/i[0];this.zoom=aE(this.zoomMax,s(this.zoomMin,aJ));this.Zoom(this.zoom)};Q.EndPinch=function(i){this.pinched=null};Q.Pause=function(){this.paused=true};Q.Resume=function(){this.paused=false};Q.SetSpeed=function(j){this.initial=j;this.yaw=j[0]*this.maxSpeed;this.pitch=j[1]*this.maxSpeed};Q.FindTag=function(aI){if(!ai(aI)){return null}ai(aI.index)&&(aI=aI.index);if(!I(aI)){return this.taglist[aI]}var aJ,aK,j;if(ai(aI.id)){aJ=\"id\",aK=aI.id}else{if(ai(aI.text)){aJ=\"innerText\",aK=aI.text}}for(j=0;j<this.taglist.length;++j){if(this.taglist[j].a[aJ]==aK){return this.taglist[j]}}};Q.RotateTag=function(aQ,aJ,aP,i,aN,aI){var aO=aQ.Calc(this.transform,1),aL=new ae(aO.x,aO.y,aO.z),aK=aj(aP,aJ),j=aL.angle(aK),aM=aL.cross(aK).unit();if(j==0){this.fixedCallbackTag=aQ;this.fixedCallback=aN}else{this.fixedAnim={angle:-j,axis:aM,t:i,t0:G(),cb:aN,tag:aQ,active:aI}}};Q.TagToFront=function(i,aI,aJ,j){this.RotateTag(i,0,0,aI,aJ,j)};y.Start=function(aI,i,j){y.Delete(aI);y.tc[aI]=new y(aI,i,j)};function az(i,j){y.tc[j]&&y.tc[j][i]()}y.Linear=function(i,j){return j/i};y.Smooth=function(i,j){return 0.5-w(j*Math.PI/i)/2};y.Pause=function(i){az(\"Pause\",i)};y.Resume=function(i){az(\"Resume\",i)};y.Reload=function(i){az(\"Load\",i)};y.Update=function(i){az(\"Update\",i)};y.SetSpeed=function(j,i){if(I(i)&&y.tc[j]&&!isNaN(i[0])&&!isNaN(i[1])){y.tc[j].SetSpeed(i);return true}return false};y.TagToFront=function(j,i){if(!I(i)){return false}i.lat=i.lng=0;return y.RotateTag(j,i)};y.RotateTag=function(aI,i){if(I(i)&&y.tc[aI]){if(isNaN(i.time)){i.time=500}var j=y.tc[aI].FindTag(i);if(j){y.tc[aI].RotateTag(j,i.lat,i.lng,i.time,i.callback,i.active);return true}}return false};y.Delete=function(aJ){var j,aI;if(b[aJ]){aI=C.getElementById(aJ);if(aI){for(j=0;j<b[aJ].length;++j){a(b[aJ][j][0],b[aJ][j][1],aI)}}}delete b[aJ];delete y.tc[aJ]};y.NextFrameRAF=function(){requestAnimationFrame(E)};y.NextFrameTimeout=function(i){setTimeout(O,i)};y.tc={};y.options={z1:20000,z2:20000,z0:0.0002,freezeActive:false,freezeDecel:false,activeCursor:\"pointer\",pulsateTo:1,pulsateTime:3,reverse:false,depth:0.5,maxSpeed:0.05,minSpeed:0,decel:0.95,interval:20,minBrightness:0.1,maxBrightness:1,outlineColour:\"#ffff99\",outlineThickness:2,outlineOffset:5,outlineMethod:\"outline\",outlineRadius:0,textColour:\"#ff99ff\",textHeight:15,textFont:\"Helvetica, Arial, sans-serif\",shadow:\"#000\",shadowBlur:0,shadowOffset:[0,0],initial:null,hideTags:true,zoom:1,weight:false,weightMode:\"size\",weightFrom:null,weightSize:1,weightSizeMin:null,weightSizeMax:null,weightGradient:{0:\"#f00\",0.33:\"#ff0\",0.66:\"#0f0\",1:\"#00f\"},txtOpt:true,txtScale:2,frontSelect:false,wheelZoom:true,zoomMin:0.3,zoomMax:3,zoomStep:0.05,shape:\"sphere\",lock:null,tooltip:null,tooltipDelay:300,tooltipClass:\"tctooltip\",radiusX:1,radiusY:1,radiusZ:1,stretchX:1,stretchY:1,offsetX:0,offsetY:0,shuffleTags:false,noSelect:false,noMouse:false,imageScale:1,paused:false,dragControl:false,dragThreshold:4,centreFunc:aB,splitWidth:0,animTiming:\"Smooth\",clickToFront:false,fadeIn:0,padding:0,bgColour:null,bgRadius:0,bgOutline:null,bgOutlineThickness:0,outlineIncrease:4,textAlign:\"centre\",textVAlign:\"middle\",imageMode:null,imagePosition:null,imagePadding:2,imageAlign:\"centre\",imageVAlign:\"middle\",noTagsMessage:true,centreImage:null,pinchZoom:false,repeatTags:0,minTags:0,imageRadius:0,scrollPause:false,outlineDash:0,outlineDashSpace:0,outlineDashSpeed:1};for(M in y.options){y[M]=y.options[M]}window.TagCanvas=y;jQuery.fn.tagcanvas=function(j,i){var aI={pause:function(){ap(this).each(function(){az(\"Pause\",ap(this)[0].id)})},resume:function(){ap(this).each(function(){az(\"Resume\",ap(this)[0].id)})},reload:function(){ap(this).each(function(){az(\"Load\",ap(this)[0].id)})},update:function(){ap(this).each(function(){az(\"Update\",ap(this)[0].id)})},tagtofront:function(){ap(this).each(function(){y.TagToFront(ap(this)[0].id,i)})},rotatetag:function(){ap(this).each(function(){y.RotateTag(ap(this)[0].id,i)})},\"delete\":function(){ap(this).each(function(){y.Delete(ap(this)[0].id)})},setspeed:function(){ap(this).each(function(){y.SetSpeed(ap(this)[0].id,i)})}};if(typeof j==\"string\"&&aI[j]){aI[j].apply(this);return this}else{y.jquery=1;ap(this).each(function(){y.Start(ap(this)[0].id,i,j)});return y.started}};ad(\"load\",function(){y.loaded=1},window)})(jQuery);\n","Magefan_Blog/js/magefan-comments.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine(\n    [\n    'jquery',\n    'uiComponent',\n    'mage/validation'],\n    function ($, Component, validation) {\n    'use strict';\n\n\n    return Component.extend({\n        initialize: function ($options) {\n\n            var msgLifetime = 4000;\n            var $hd = $('#post-comments');\n\n            var getMessageHtml = function (msg, type) {\n                var h = '<div class=\"message-' + type + ' ' + type + ' message\">'\n                    + '<div>' + msg + '</div>'\n                +'</div>';\n                return $(h);\n            };\n\n            var processError = function ($form, msg) {\n                $form.find('[type=submit]').removeAttr('disabled');\n                var $h = getMessageHtml(msg, 'error');\n                $h.insertBefore($form);\n                setTimeout(function () {\n                    $h.remove();\n                }, msgLifetime);\n            };\n\n            var processSuccess = function ($form, msg) {\n                $form.find('[type=submit]').removeAttr('disabled');\n                var $h = getMessageHtml(msg, 'success');\n                $h.insertBefore($form);\n                $form.hide();\n                setTimeout(function () {\n                    $h.remove();\n                }, msgLifetime);\n            };\n\n            $hd.find('form').submit(function () {\n                var $form = $(this);\n                if ($form.validation() && $form.validation('isValid')) {\n                    $form.find('[type=submit]').attr('disabled', 'disabled');\n                    $.ajax({\n                        'method': 'post',\n                        'url': $form.attr('action'),\n                        'dataType': 'json',\n                        'data': $form.serialize(),\n                        'success': function (res) {\n                            if (res.success) {\n                                processSuccess($form, res.message);\n                            } else {\n                                processError($form, res.message);\n                            }\n                        },\n                        'error': function () {\n                            processError($form, 'Unexpected error. Please try again later or contact us.')\n                        }\n                    })\n                }\n                return false;\n            });\n\n            $hd.find('.more-comments-action').click(function () {\n                var id = $(this).data('comment');\n                $hd.find('.c-comment-parent-'+id).fadeIn();\n                $(this).hide();\n                return false;\n            });\n\n            $hd.find('form textarea').click(function () {\n                $(this).parents('.no-active').removeClass('no-active');\n            });\n\n            var $rf = $('#c-replyform-comment');\n            $hd.find('.reply-action').click(function () {\n                var id = $(this).data('comment');\n                $rf.hide();\n                $rf.appendTo('.c-post-'+id);\n                $rf.find('.refresh-value').val('').html('');\n                $rf.find('[name=parent_id]').val(id);\n                $rf.find('form').show();\n                $rf.fadeIn();\n                return false;\n            });\n\n            $hd.find('.reply-cancel-action').click(function () {\n                $rf.hide();\n            });\n\n            return this;\n        },\n\n    });\n    }\n);","Magefan_Blog/js/jquery.fancybox.min.js":"// ==================================================\n// fancyBox v3.2.8\n//\n// Licensed GPLv3 for open source use\n// or fancyBox Commercial License for commercial use\n//\n// http://fancyapps.com/fancybox/\n// Copyright 2017 fancyApps\n//\n// ==================================================\n!function(t,e,n,o){\"use strict\";function a(t){var e=n(t.currentTarget),o=t.data?t.data.options:{},a=e.attr(\"data-fancybox\")||\"\",i=0,s=[];t.isDefaultPrevented()||(t.preventDefault(),a?(s=o.selector?n(o.selector):t.data?t.data.items:[],s=s.length?s.filter('[data-fancybox=\"'+a+'\"]'):n('[data-fancybox=\"'+a+'\"]'),i=s.index(e),i<0&&(i=0)):s=[e],n.fancybox.open(s,o,i))}if(n){if(n.fn.fancybox)return void(\"console\"in t&&console.log(\"fancyBox already initialized\"));var i={loop:!1,margin:[44,0],gutter:50,keyboard:!0,arrows:!0,infobar:!0,toolbar:!0,buttons:[\"slideShow\",\"fullScreen\",\"thumbs\",\"share\",\"close\"],idleTime:3,smallBtn:\"auto\",protect:!1,modal:!1,image:{preload:\"auto\"},ajax:{settings:{data:{fancybox:!0}}},iframe:{tpl:'<iframe id=\"fancybox-frame{rnd}\" name=\"fancybox-frame{rnd}\" class=\"fancybox-iframe\" frameborder=\"0\" vspace=\"0\" hspace=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen allowtransparency=\"true\" src=\"\"></iframe>',preload:!0,css:{},attr:{scrolling:\"auto\"}},defaultType:\"image\",animationEffect:\"zoom\",animationDuration:500,zoomOpacity:\"auto\",transitionEffect:\"fade\",transitionDuration:366,slideClass:\"\",baseClass:\"\",baseTpl:'<div class=\"fancybox-container\" role=\"dialog\" tabindex=\"-1\"><div class=\"fancybox-bg\"></div><div class=\"fancybox-inner\"><div class=\"fancybox-infobar\"><span data-fancybox-index></span>&nbsp;/&nbsp;<span data-fancybox-count></span></div><div class=\"fancybox-toolbar\">{{buttons}}</div><div class=\"fancybox-navigation\">{{arrows}}</div><div class=\"fancybox-stage\"></div><div class=\"fancybox-caption-wrap\"><div class=\"fancybox-caption\"></div></div></div></div>',spinnerTpl:'<div class=\"fancybox-loading\"></div>',errorTpl:'<div class=\"fancybox-error\"><p>{{ERROR}}<p></div>',btnTpl:{download:'<a download data-fancybox-download class=\"fancybox-button fancybox-button--download\" title=\"{{DOWNLOAD}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M20,23 L20,8 L20,23 L13,16 L20,23 L27,16 L20,23 M26,28 L13,28 L27,28 L14,28\" /></svg></a>',zoom:'<button data-fancybox-zoom class=\"fancybox-button fancybox-button--zoom\" title=\"{{ZOOM}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M 18,17 m-8,0 a 8,8 0 1,0 16,0 a 8,8 0 1,0 -16,0 M25,23 L31,29 L25,23\" /></svg></button>',close:'<button data-fancybox-close class=\"fancybox-button fancybox-button--close\" title=\"{{CLOSE}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M10,10 L30,30 M30,10 L10,30\" /></svg></button>',smallBtn:'<button data-fancybox-close class=\"fancybox-close-small\" title=\"{{CLOSE}}\"></button>',arrowLeft:'<button data-fancybox-prev class=\"fancybox-button fancybox-button--arrow_left\" title=\"{{PREV}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M10,20 L30,20 L10,20 L18,28 L10,20 L18,12 L10,20\"></path></svg></button>',arrowRight:'<button data-fancybox-next class=\"fancybox-button fancybox-button--arrow_right\" title=\"{{NEXT}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M30,20 L10,20 L30,20 L22,28 L30,20 L22,12 L30,20\"></path></svg></button>'},parentEl:\"body\",autoFocus:!1,backFocus:!0,trapFocus:!0,fullScreen:{autoStart:!1},touch:{vertical:!0,momentum:!0},hash:null,media:{},slideShow:{autoStart:!1,speed:4e3},thumbs:{autoStart:!1,hideOnClose:!0,parentEl:\".fancybox-container\",axis:\"y\"},wheel:\"auto\",onInit:n.noop,beforeLoad:n.noop,afterLoad:n.noop,beforeShow:n.noop,afterShow:n.noop,beforeClose:n.noop,afterClose:n.noop,onActivate:n.noop,onDeactivate:n.noop,clickContent:function(t,e){return\"image\"===t.type&&\"zoom\"},clickSlide:\"close\",clickOutside:\"close\",dblclickContent:!1,dblclickSlide:!1,dblclickOutside:!1,mobile:{idleTime:!1,margin:0,clickContent:function(t,e){return\"image\"===t.type&&\"toggleControls\"},clickSlide:function(t,e){return\"image\"===t.type?\"toggleControls\":\"close\"},dblclickContent:function(t,e){return\"image\"===t.type&&\"zoom\"},dblclickSlide:function(t,e){return\"image\"===t.type&&\"zoom\"}},lang:\"en\",i18n:{en:{CLOSE:\"Close\",NEXT:\"Next\",PREV:\"Previous\",ERROR:\"The requested content cannot be loaded. <br/> Please try again later.\",PLAY_START:\"Start slideshow\",PLAY_STOP:\"Pause slideshow\",FULL_SCREEN:\"Full screen\",THUMBS:\"Thumbnails\",DOWNLOAD:\"Download\",SHARE:\"Share\",ZOOM:\"Zoom\"},de:{CLOSE:\"Schliessen\",NEXT:\"Weiter\",PREV:\"Zur\u00fcck\",ERROR:\"Die angeforderten Daten konnten nicht geladen werden. <br/> Bitte versuchen Sie es sp\u00e4ter nochmal.\",PLAY_START:\"Diaschau starten\",PLAY_STOP:\"Diaschau beenden\",FULL_SCREEN:\"Vollbild\",THUMBS:\"Vorschaubilder\",DOWNLOAD:\"Herunterladen\",SHARE:\"Teilen\",ZOOM:\"Ma\u00dfstab\"}}},s=n(t),r=n(e),c=0,l=function(t){return t&&t.hasOwnProperty&&t instanceof n},u=function(){return t.requestAnimationFrame||t.webkitRequestAnimationFrame||t.mozRequestAnimationFrame||t.oRequestAnimationFrame||function(e){return t.setTimeout(e,1e3/60)}}(),d=function(){var t,n=e.createElement(\"fakeelement\"),a={transition:\"transitionend\",OTransition:\"oTransitionEnd\",MozTransition:\"transitionend\",WebkitTransition:\"webkitTransitionEnd\"};for(t in a)if(n.style[t]!==o)return a[t];return\"transitionend\"}(),f=function(t){return t&&t.length&&t[0].offsetHeight},p=function(t,o,a){var i=this;i.opts=n.extend(!0,{index:a},n.fancybox.defaults,o||{}),n.fancybox.isMobile&&(i.opts=n.extend(!0,{},i.opts,i.opts.mobile)),o&&n.isArray(o.buttons)&&(i.opts.buttons=o.buttons),i.id=i.opts.id||++c,i.group=[],i.currIndex=parseInt(i.opts.index,10)||0,i.prevIndex=null,i.prevPos=null,i.currPos=0,i.firstRun=null,i.createGroup(t),i.group.length&&(i.$lastFocus=n(e.activeElement).blur(),i.slides={},i.init())};n.extend(p.prototype,{init:function(){var a,i,s,c=this,l=c.group[c.currIndex],u=l.opts,d=n.fancybox.scrollbarWidth;c.scrollTop=r.scrollTop(),c.scrollLeft=r.scrollLeft(),n.fancybox.getInstance()||(n(\"body\").addClass(\"fancybox-active\"),/iPad|iPhone|iPod/.test(navigator.userAgent)&&!t.MSStream?\"image\"!==l.type&&n(\"body\").css(\"top\",n(\"body\").scrollTop()*-1).addClass(\"fancybox-iosfix\"):!n.fancybox.isMobile&&e.body.scrollHeight>t.innerHeight&&(d===o&&(a=n('<div style=\"width:50px;height:50px;overflow:scroll;\" />').appendTo(\"body\"),d=n.fancybox.scrollbarWidth=a[0].offsetWidth-a[0].clientWidth,a.remove()),n(\"head\").append('<style id=\"fancybox-style-noscroll\" type=\"text/css\">.compensate-for-scrollbar { margin-right: '+d+\"px; }</style>\"),n(\"body\").addClass(\"compensate-for-scrollbar\"))),s=\"\",n.each(u.buttons,function(t,e){s+=u.btnTpl[e]||\"\"}),i=n(c.translate(c,u.baseTpl.replace(\"{{buttons}}\",s).replace(\"{{arrows}}\",u.btnTpl.arrowLeft+u.btnTpl.arrowRight))).attr(\"id\",\"fancybox-container-\"+c.id).addClass(\"fancybox-is-hidden\").addClass(u.baseClass).data(\"FancyBox\",c).appendTo(u.parentEl),c.$refs={container:i},[\"bg\",\"inner\",\"infobar\",\"toolbar\",\"stage\",\"caption\",\"navigation\"].forEach(function(t){c.$refs[t]=i.find(\".fancybox-\"+t)}),c.trigger(\"onInit\"),c.activate(),c.jumpTo(c.currIndex)},translate:function(t,e){var n=t.opts.i18n[t.opts.lang];return e.replace(/\\{\\{(\\w+)\\}\\}/g,function(t,e){var a=n[e];return a===o?t:a})},createGroup:function(t){var e=this,a=n.makeArray(t);n.each(a,function(t,a){var i,s,r,c,l={},u={};n.isPlainObject(a)?(l=a,u=a.opts||a):\"object\"===n.type(a)&&n(a).length?(i=n(a),u=i.data(),u=n.extend({},u,u.options||{}),u.$orig=i,l.src=u.src||i.attr(\"href\"),l.type||l.src||(l.type=\"inline\",l.src=a)):l={type:\"html\",src:a+\"\"},l.opts=n.extend(!0,{},e.opts,u),n.isArray(u.buttons)&&(l.opts.buttons=u.buttons),s=l.type||l.opts.type,r=l.src||\"\",!s&&r&&(r.match(/(^data:image\\/[a-z0-9+\\/=]*,)|(\\.(jp(e|g|eg)|gif|png|bmp|webp|svg|ico)((\\?|#).*)?$)/i)?s=\"image\":r.match(/\\.(pdf)((\\?|#).*)?$/i)?s=\"pdf\":\"#\"===r.charAt(0)&&(s=\"inline\")),s?l.type=s:e.trigger(\"objectNeedsType\",l),l.index=e.group.length,l.opts.$orig&&!l.opts.$orig.length&&delete l.opts.$orig,!l.opts.$thumb&&l.opts.$orig&&(l.opts.$thumb=l.opts.$orig.find(\"img:first\")),l.opts.$thumb&&!l.opts.$thumb.length&&delete l.opts.$thumb,\"function\"===n.type(l.opts.caption)&&(l.opts.caption=l.opts.caption.apply(a,[e,l])),\"function\"===n.type(e.opts.caption)&&(l.opts.caption=e.opts.caption.apply(a,[e,l])),l.opts.caption instanceof n||(l.opts.caption=l.opts.caption===o?\"\":l.opts.caption+\"\"),\"ajax\"===s&&(c=r.split(/\\s+/,2),c.length>1&&(l.src=c.shift(),l.opts.filter=c.shift())),\"auto\"==l.opts.smallBtn&&(n.inArray(s,[\"html\",\"inline\",\"ajax\"])>-1?(l.opts.toolbar=!1,l.opts.smallBtn=!0):l.opts.smallBtn=!1),\"pdf\"===s&&(l.type=\"iframe\",l.opts.iframe.preload=!1),l.opts.modal&&(l.opts=n.extend(!0,l.opts,{infobar:0,toolbar:0,smallBtn:0,keyboard:0,slideShow:0,fullScreen:0,thumbs:0,touch:0,clickContent:!1,clickSlide:!1,clickOutside:!1,dblclickContent:!1,dblclickSlide:!1,dblclickOutside:!1})),e.group.push(l)})},addEvents:function(){var o=this;o.removeEvents(),o.$refs.container.on(\"click.fb-close\",\"[data-fancybox-close]\",function(t){t.stopPropagation(),t.preventDefault(),o.close(t)}).on(\"click.fb-prev touchend.fb-prev\",\"[data-fancybox-prev]\",function(t){t.stopPropagation(),t.preventDefault(),o.previous()}).on(\"click.fb-next touchend.fb-next\",\"[data-fancybox-next]\",function(t){t.stopPropagation(),t.preventDefault(),o.next()}).on(\"click.fb\",\"[data-fancybox-zoom]\",function(t){o[o.isScaledDown()?\"scaleToActual\":\"scaleToFit\"]()}),s.on(\"orientationchange.fb resize.fb\",function(t){t&&t.originalEvent&&\"resize\"===t.originalEvent.type?u(function(){o.update()}):(o.$refs.stage.hide(),setTimeout(function(){o.$refs.stage.show(),o.update()},600))}),r.on(\"focusin.fb\",function(t){var a=n.fancybox?n.fancybox.getInstance():null;a.isClosing||!a.current||!a.current.opts.trapFocus||n(t.target).hasClass(\"fancybox-container\")||n(t.target).is(e)||a&&\"fixed\"!==n(t.target).css(\"position\")&&!a.$refs.container.has(t.target).length&&(t.stopPropagation(),a.focus(),s.scrollTop(o.scrollTop).scrollLeft(o.scrollLeft))}),r.on(\"keydown.fb\",function(t){var e=o.current,a=t.keyCode||t.which;if(e&&e.opts.keyboard&&!n(t.target).is(\"input\")&&!n(t.target).is(\"textarea\"))return 8===a||27===a?(t.preventDefault(),void o.close(t)):37===a||38===a?(t.preventDefault(),void o.previous()):39===a||40===a?(t.preventDefault(),void o.next()):void o.trigger(\"afterKeydown\",t,a)}),o.group[o.currIndex].opts.idleTime&&(o.idleSecondsCounter=0,r.on(\"mousemove.fb-idle mouseleave.fb-idle mousedown.fb-idle touchstart.fb-idle touchmove.fb-idle scroll.fb-idle keydown.fb-idle\",function(t){o.idleSecondsCounter=0,o.isIdle&&o.showControls(),o.isIdle=!1}),o.idleInterval=t.setInterval(function(){o.idleSecondsCounter++,o.idleSecondsCounter>=o.group[o.currIndex].opts.idleTime&&!o.isDragging&&(o.isIdle=!0,o.idleSecondsCounter=0,o.hideControls())},1e3))},removeEvents:function(){var e=this;s.off(\"orientationchange.fb resize.fb\"),r.off(\"focusin.fb keydown.fb .fb-idle\"),this.$refs.container.off(\".fb-close .fb-prev .fb-next\"),e.idleInterval&&(t.clearInterval(e.idleInterval),e.idleInterval=null)},previous:function(t){return this.jumpTo(this.currPos-1,t)},next:function(t){return this.jumpTo(this.currPos+1,t)},jumpTo:function(t,e,a){var i,s,r,c,l,u,d,p=this,h=p.group.length;if(!(p.isDragging||p.isClosing||p.isAnimating&&p.firstRun)){if(t=parseInt(t,10),s=p.current?p.current.opts.loop:p.opts.loop,!s&&(t<0||t>=h))return!1;if(i=p.firstRun=null===p.firstRun,!(h<2&&!i&&p.isDragging)){if(c=p.current,p.prevIndex=p.currIndex,p.prevPos=p.currPos,r=p.createSlide(t),h>1&&((s||r.index>0)&&p.createSlide(t-1),(s||r.index<h-1)&&p.createSlide(t+1)),p.current=r,p.currIndex=r.index,p.currPos=r.pos,p.trigger(\"beforeShow\",i),p.updateControls(),u=n.fancybox.getTranslate(r.$slide),r.isMoved=(0!==u.left||0!==u.top)&&!r.$slide.hasClass(\"fancybox-animated\"),r.forcedDuration=o,n.isNumeric(e)?r.forcedDuration=e:e=r.opts[i?\"animationDuration\":\"transitionDuration\"],e=parseInt(e,10),i)return r.opts.animationEffect&&e&&p.$refs.container.css(\"transition-duration\",e+\"ms\"),p.$refs.container.removeClass(\"fancybox-is-hidden\"),f(p.$refs.container),p.$refs.container.addClass(\"fancybox-is-open\"),r.$slide.addClass(\"fancybox-slide--current\"),p.loadSlide(r),void p.preload();n.each(p.slides,function(t,e){n.fancybox.stop(e.$slide)}),r.$slide.removeClass(\"fancybox-slide--next fancybox-slide--previous\").addClass(\"fancybox-slide--current\"),r.isMoved?(l=Math.round(r.$slide.width()),n.each(p.slides,function(t,o){var a=o.pos-r.pos;n.fancybox.animate(o.$slide,{top:0,left:a*l+a*o.opts.gutter},e,function(){o.$slide.removeAttr(\"style\").removeClass(\"fancybox-slide--next fancybox-slide--previous\"),o.pos===p.currPos&&(r.isMoved=!1,p.complete())})})):p.$refs.stage.children().removeAttr(\"style\"),r.isLoaded?p.revealContent(r):p.loadSlide(r),p.preload(),c.pos!==r.pos&&(d=\"fancybox-slide--\"+(c.pos>r.pos?\"next\":\"previous\"),c.$slide.removeClass(\"fancybox-slide--complete fancybox-slide--current fancybox-slide--next fancybox-slide--previous\"),c.isComplete=!1,e&&(r.isMoved||r.opts.transitionEffect)&&(r.isMoved?c.$slide.addClass(d):(d=\"fancybox-animated \"+d+\" fancybox-fx-\"+r.opts.transitionEffect,n.fancybox.animate(c.$slide,d,e,function(){c.$slide.removeClass(d).removeAttr(\"style\")}))))}}},createSlide:function(t){var e,o,a=this;return o=t%a.group.length,o=o<0?a.group.length+o:o,!a.slides[t]&&a.group[o]&&(e=n('<div class=\"fancybox-slide\"></div>').appendTo(a.$refs.stage),a.slides[t]=n.extend(!0,{},a.group[o],{pos:t,$slide:e,isLoaded:!1}),a.updateSlide(a.slides[t])),a.slides[t]},scaleToActual:function(t,e,a){var i,s,r,c,l,u=this,d=u.current,f=d.$content,p=parseInt(d.$slide.width(),10),h=parseInt(d.$slide.height(),10),g=d.width,b=d.height;\"image\"!=d.type||d.hasError||!f||u.isAnimating||(n.fancybox.stop(f),u.isAnimating=!0,t=t===o?.5*p:t,e=e===o?.5*h:e,i=n.fancybox.getTranslate(f),c=g/i.width,l=b/i.height,s=.5*p-.5*g,r=.5*h-.5*b,g>p&&(s=i.left*c-(t*c-t),s>0&&(s=0),s<p-g&&(s=p-g)),b>h&&(r=i.top*l-(e*l-e),r>0&&(r=0),r<h-b&&(r=h-b)),u.updateCursor(g,b),n.fancybox.animate(f,{top:r,left:s,scaleX:c,scaleY:l},a||330,function(){u.isAnimating=!1}),u.SlideShow&&u.SlideShow.isActive&&u.SlideShow.stop())},scaleToFit:function(t){var e,o=this,a=o.current,i=a.$content;\"image\"!=a.type||a.hasError||!i||o.isAnimating||(n.fancybox.stop(i),o.isAnimating=!0,e=o.getFitPos(a),o.updateCursor(e.width,e.height),n.fancybox.animate(i,{top:e.top,left:e.left,scaleX:e.width/i.width(),scaleY:e.height/i.height()},t||330,function(){o.isAnimating=!1}))},getFitPos:function(t){var e,o,a,i,s,r=this,c=t.$content,l=t.width,u=t.height,d=t.opts.margin;return!(!c||!c.length||!l&&!u)&&(\"number\"===n.type(d)&&(d=[d,d]),2==d.length&&(d=[d[0],d[1],d[0],d[1]]),e=parseInt(r.$refs.stage.width(),10)-(d[1]+d[3]),o=parseInt(r.$refs.stage.height(),10)-(d[0]+d[2]),a=Math.min(1,e/l,o/u),i=Math.floor(a*l),s=Math.floor(a*u),{top:Math.floor(.5*(o-s))+d[0],left:Math.floor(.5*(e-i))+d[3],width:i,height:s})},update:function(){var t=this;n.each(t.slides,function(e,n){t.updateSlide(n)})},updateSlide:function(t){var e=this,o=t.$content;o&&(t.width||t.height)&&(e.isAnimating=!1,n.fancybox.stop(o),n.fancybox.setTranslate(o,e.getFitPos(t)),t.pos===e.currPos&&e.updateCursor()),t.$slide.trigger(\"refresh\"),e.trigger(\"onUpdate\",t)},updateCursor:function(t,e){var n,a=this,i=a.$refs.container.removeClass(\"fancybox-is-zoomable fancybox-can-zoomIn fancybox-can-drag fancybox-can-zoomOut\");a.current&&!a.isClosing&&(a.isZoomable()?(i.addClass(\"fancybox-is-zoomable\"),n=t!==o&&e!==o?t<a.current.width&&e<a.current.height:a.isScaledDown(),n?i.addClass(\"fancybox-can-zoomIn\"):a.current.opts.touch?i.addClass(\"fancybox-can-drag\"):i.addClass(\"fancybox-can-zoomOut\")):a.current.opts.touch&&i.addClass(\"fancybox-can-drag\"))},isZoomable:function(){var t,e=this,o=e.current;if(o&&!e.isClosing)return!!(\"image\"===o.type&&o.isLoaded&&!o.hasError&&(\"zoom\"===o.opts.clickContent||n.isFunction(o.opts.clickContent)&&\"zoom\"===o.opts.clickContent(o))&&(t=e.getFitPos(o),o.width>t.width||o.height>t.height))},isScaledDown:function(){var t=this,e=t.current,o=e.$content,a=!1;return o&&(a=n.fancybox.getTranslate(o),a=a.width<e.width||a.height<e.height),a},canPan:function(){var t=this,e=t.current,n=e.$content,o=!1;return n&&(o=t.getFitPos(e),o=Math.abs(n.width()-o.width)>1||Math.abs(n.height()-o.height)>1),o},loadSlide:function(t){var e,o,a,i=this;if(!t.isLoading&&!t.isLoaded){switch(t.isLoading=!0,i.trigger(\"beforeLoad\",t),e=t.type,o=t.$slide,o.off(\"refresh\").trigger(\"onReset\").addClass(\"fancybox-slide--\"+(e||\"unknown\")).addClass(t.opts.slideClass),e){case\"image\":i.setImage(t);break;case\"iframe\":i.setIframe(t);break;case\"html\":i.setContent(t,t.src||t.content);break;case\"inline\":n(t.src).length?i.setContent(t,n(t.src)):i.setError(t);break;case\"ajax\":i.showLoading(t),a=n.ajax(n.extend({},t.opts.ajax.settings,{url:t.src,success:function(e,n){\"success\"===n&&i.setContent(t,e)},error:function(e,n){e&&\"abort\"!==n&&i.setError(t)}})),o.one(\"onReset\",function(){a.abort()});break;default:i.setError(t)}return!0}},setImage:function(e){var o,a,i,s,r=this,c=e.opts.srcset||e.opts.image.srcset;if(c){i=t.devicePixelRatio||1,s=t.innerWidth*i,a=c.split(\",\").map(function(t){var e={};return t.trim().split(/\\s+/).forEach(function(t,n){var o=parseInt(t.substring(0,t.length-1),10);return 0===n?e.url=t:void(o&&(e.value=o,e.postfix=t[t.length-1]))}),e}),a.sort(function(t,e){return t.value-e.value});for(var l=0;l<a.length;l++){var u=a[l];if(\"w\"===u.postfix&&u.value>=s||\"x\"===u.postfix&&u.value>=i){o=u;break}}!o&&a.length&&(o=a[a.length-1]),o&&(e.src=o.url,e.width&&e.height&&\"w\"==o.postfix&&(e.height=e.width/e.height*o.value,e.width=o.value))}e.$content=n('<div class=\"fancybox-image-wrap\"></div>').addClass(\"fancybox-is-hidden\").appendTo(e.$slide),e.opts.preload!==!1&&e.opts.width&&e.opts.height&&(e.opts.thumb||e.opts.$thumb)?(e.width=e.opts.width,e.height=e.opts.height,e.$ghost=n(\"<img />\").one(\"error\",function(){n(this).remove(),e.$ghost=null,r.setBigImage(e)}).one(\"load\",function(){r.afterLoad(e),r.setBigImage(e)}).addClass(\"fancybox-image\").appendTo(e.$content).attr(\"src\",e.opts.thumb||e.opts.$thumb.attr(\"src\"))):r.setBigImage(e)},setBigImage:function(t){var e=this,o=n(\"<img />\");t.$image=o.one(\"error\",function(){e.setError(t)}).one(\"load\",function(){clearTimeout(t.timouts),t.timouts=null,e.isClosing||(t.width=this.naturalWidth,t.height=this.naturalHeight,t.opts.image.srcset&&o.attr(\"sizes\",\"100vw\").attr(\"srcset\",t.opts.image.srcset),e.hideLoading(t),t.$ghost?t.timouts=setTimeout(function(){t.timouts=null,t.$ghost.hide()},Math.min(300,Math.max(1e3,t.height/1600))):e.afterLoad(t))}).addClass(\"fancybox-image\").attr(\"src\",t.src).appendTo(t.$content),(o[0].complete||\"complete\"==o[0].readyState)&&o[0].naturalWidth&&o[0].naturalHeight?o.trigger(\"load\"):o[0].error?o.trigger(\"error\"):t.timouts=setTimeout(function(){o[0].complete||t.hasError||e.showLoading(t)},100)},setIframe:function(t){var e,a=this,i=t.opts.iframe,s=t.$slide;t.$content=n('<div class=\"fancybox-content'+(i.preload?\" fancybox-is-hidden\":\"\")+'\"></div>').css(i.css).appendTo(s),e=n(i.tpl.replace(/\\{rnd\\}/g,(new Date).getTime())).attr(i.attr).appendTo(t.$content),i.preload?(a.showLoading(t),e.on(\"load.fb error.fb\",function(e){this.isReady=1,t.$slide.trigger(\"refresh\"),a.afterLoad(t)}),s.on(\"refresh.fb\",function(){var n,a,s,r=t.$content,c=i.css.width,l=i.css.height;if(1===e[0].isReady){try{a=e.contents(),s=a.find(\"body\")}catch(t){}s&&s.length&&(c===o&&(n=e[0].contentWindow.document.documentElement.scrollWidth,c=Math.ceil(s.outerWidth(!0)+(r.width()-n)),c+=r.outerWidth()-r.innerWidth()),l===o&&(l=Math.ceil(s.outerHeight(!0)),l+=r.outerHeight()-r.innerHeight()),c&&r.width(c),l&&r.height(l)),r.removeClass(\"fancybox-is-hidden\")}})):this.afterLoad(t),e.attr(\"src\",t.src),t.opts.smallBtn===!0&&t.$content.prepend(a.translate(t,t.opts.btnTpl.smallBtn)),s.one(\"onReset\",function(){try{n(this).find(\"iframe\").hide().attr(\"src\",\"//about:blank\")}catch(t){}n(this).empty(),t.isLoaded=!1})},setContent:function(t,e){var o=this;o.isClosing||(o.hideLoading(t),t.$slide.empty(),l(e)&&e.parent().length?(e.parent(\".fancybox-slide--inline\").trigger(\"onReset\"),t.$placeholder=n(\"<div></div>\").hide().insertAfter(e),e.css(\"display\",\"inline-block\")):t.hasError||(\"string\"===n.type(e)&&(e=n(\"<div>\").append(n.trim(e)).contents(),3===e[0].nodeType&&(e=n(\"<div>\").html(e))),t.opts.filter&&(e=n(\"<div>\").html(e).find(t.opts.filter))),t.$slide.one(\"onReset\",function(){n(this).find(\"video,audio\").each(function(){this.pause()}),t.$placeholder&&(t.$placeholder.after(e.hide()).remove(),t.$placeholder=null),t.$smallBtn&&(t.$smallBtn.remove(),t.$smallBtn=null),t.hasError||(n(this).empty(),t.isLoaded=!1)}),t.$content=n(e).appendTo(t.$slide),this.afterLoad(t))},setError:function(t){t.hasError=!0,t.$slide.removeClass(\"fancybox-slide--\"+t.type),this.setContent(t,this.translate(t,t.opts.errorTpl))},showLoading:function(t){var e=this;t=t||e.current,t&&!t.$spinner&&(t.$spinner=n(e.opts.spinnerTpl).appendTo(t.$slide))},hideLoading:function(t){var e=this;t=t||e.current,t&&t.$spinner&&(t.$spinner.remove(),delete t.$spinner)},afterLoad:function(t){var e=this;e.isClosing||(t.isLoading=!1,t.isLoaded=!0,e.trigger(\"afterLoad\",t),e.hideLoading(t),t.opts.smallBtn&&!t.$smallBtn&&(t.$smallBtn=n(e.translate(t,t.opts.btnTpl.smallBtn)).appendTo(t.$content.filter(\"div,form\").first())),t.opts.protect&&t.$content&&!t.hasError&&(t.$content.on(\"contextmenu.fb\",function(t){return 2==t.button&&t.preventDefault(),!0}),\"image\"===t.type&&n('<div class=\"fancybox-spaceball\"></div>').appendTo(t.$content)),e.revealContent(t))},revealContent:function(t){var e,a,i,s,r,c=this,l=t.$slide,u=!1;return e=t.opts[c.firstRun?\"animationEffect\":\"transitionEffect\"],i=t.opts[c.firstRun?\"animationDuration\":\"transitionDuration\"],i=parseInt(t.forcedDuration===o?i:t.forcedDuration,10),!t.isMoved&&t.pos===c.currPos&&i||(e=!1),\"zoom\"!==e||t.pos===c.currPos&&i&&\"image\"===t.type&&!t.hasError&&(u=c.getThumbPos(t))||(e=\"fade\"),\"zoom\"===e?(r=c.getFitPos(t),r.scaleX=r.width/u.width,r.scaleY=r.height/u.height,delete r.width,delete r.height,s=t.opts.zoomOpacity,\"auto\"==s&&(s=Math.abs(t.width/t.height-u.width/u.height)>.1),s&&(u.opacity=.1,r.opacity=1),n.fancybox.setTranslate(t.$content.removeClass(\"fancybox-is-hidden\"),u),f(t.$content),void n.fancybox.animate(t.$content,r,i,function(){c.complete()})):(c.updateSlide(t),e?(n.fancybox.stop(l),a=\"fancybox-animated fancybox-slide--\"+(t.pos>=c.prevPos?\"next\":\"previous\")+\" fancybox-fx-\"+e,l.removeAttr(\"style\").removeClass(\"fancybox-slide--current fancybox-slide--next fancybox-slide--previous\").addClass(a),t.$content.removeClass(\"fancybox-is-hidden\"),f(l),void n.fancybox.animate(l,\"fancybox-slide--current\",i,function(e){l.removeClass(a).removeAttr(\"style\"),t.pos===c.currPos&&c.complete()},!0)):(f(l),t.$content.removeClass(\"fancybox-is-hidden\"),void(t.pos===c.currPos&&c.complete())))},getThumbPos:function(o){var a,i=this,s=!1,r=function(e){for(var o,a=e[0],i=a.getBoundingClientRect(),s=[];null!==a.parentElement;)\"hidden\"!==n(a.parentElement).css(\"overflow\")&&\"auto\"!==n(a.parentElement).css(\"overflow\")||s.push(a.parentElement.getBoundingClientRect()),a=a.parentElement;return o=s.every(function(t){var e=Math.min(i.right,t.right)-Math.max(i.left,t.left),n=Math.min(i.bottom,t.bottom)-Math.max(i.top,t.top);return e>0&&n>0}),o&&i.bottom>0&&i.right>0&&i.left<n(t).width()&&i.top<n(t).height()},c=o.opts.$thumb,l=c?c.offset():0;return l&&c[0].ownerDocument===e&&r(c)&&(a=i.$refs.stage.offset(),s={top:l.top-a.top+parseFloat(c.css(\"border-top-width\")||0),left:l.left-a.left+parseFloat(c.css(\"border-left-width\")||0),width:c.width(),height:c.height(),scaleX:1,scaleY:1}),s},complete:function(){var t=this,o=t.current,a={};if(!o.isMoved&&o.isLoaded&&!o.isComplete){o.isComplete=!0,o.$slide.siblings().trigger(\"onReset\"),f(o.$slide),o.$slide.addClass(\"fancybox-slide--complete\"),n.each(t.slides,function(e,o){o.pos>=t.currPos-1&&o.pos<=t.currPos+1?a[o.pos]=o:o&&(n.fancybox.stop(o.$slide),o.$slide.off().remove())}),t.slides=a,t.updateCursor(),t.trigger(\"afterShow\");var i=o.$slide.find(\"video,audio\").first();i.length&&i[0].play(),(n(e.activeElement).is(\"[disabled]\")||o.opts.autoFocus&&\"image\"!=o.type&&\"iframe\"!==o.type)&&t.focus()}},preload:function(){var t,e,n=this;n.group.length<2||(t=n.slides[n.currPos+1],e=n.slides[n.currPos-1],t&&\"image\"===t.type&&n.loadSlide(t),e&&\"image\"===e.type&&n.loadSlide(e))},focus:function(){var t,e=this.current;this.isClosing||(e&&e.isComplete&&(t=e.$slide.find(\"input[autofocus]:enabled:visible:first\"),t.length||(t=e.$slide.find(\"button,:input,[tabindex],a\").filter(\":enabled:visible:first\"))),t=t&&t.length?t:this.$refs.container,t.focus())},activate:function(){var t=this;n(\".fancybox-container\").each(function(){var e=n(this).data(\"FancyBox\");e&&e.id!==t.id&&!e.isClosing&&(e.trigger(\"onDeactivate\"),e.removeEvents(),e.isVisible=!1)}),t.isVisible=!0,(t.current||t.isIdle)&&(t.update(),t.updateControls()),t.trigger(\"onActivate\"),t.addEvents()},close:function(t,e){var o,a,i,s,r,c,l=this,p=l.current,h=function(){l.cleanUp(t)};return!l.isClosing&&(l.isClosing=!0,l.trigger(\"beforeClose\",t)===!1?(l.isClosing=!1,u(function(){l.update()}),!1):(l.removeEvents(),p.timouts&&clearTimeout(p.timouts),i=p.$content,o=p.opts.animationEffect,a=n.isNumeric(e)?e:o?p.opts.animationDuration:0,p.$slide.off(d).removeClass(\"fancybox-slide--complete fancybox-slide--next fancybox-slide--previous fancybox-animated\"),p.$slide.siblings().trigger(\"onReset\").remove(),a&&l.$refs.container.removeClass(\"fancybox-is-open\").addClass(\"fancybox-is-closing\"),l.hideLoading(p),l.hideControls(),l.updateCursor(),\"zoom\"!==o||t!==!0&&i&&a&&\"image\"===p.type&&!p.hasError&&(c=l.getThumbPos(p))||(o=\"fade\"),\"zoom\"===o?(n.fancybox.stop(i),r=n.fancybox.getTranslate(i),r.width=r.width*r.scaleX,r.height=r.height*r.scaleY,s=p.opts.zoomOpacity,\"auto\"==s&&(s=Math.abs(p.width/p.height-c.width/c.height)>.1),s&&(c.opacity=0),r.scaleX=r.width/c.width,r.scaleY=r.height/c.height,r.width=c.width,r.height=c.height,n.fancybox.setTranslate(p.$content,r),f(p.$content),n.fancybox.animate(p.$content,c,a,h),!0):(o&&a?t===!0?setTimeout(h,a):n.fancybox.animate(p.$slide.removeClass(\"fancybox-slide--current\"),\"fancybox-animated fancybox-slide--previous fancybox-fx-\"+o,a,h):h(),!0)))},cleanUp:function(t){var o,a,i=this,r=n(\"body\");i.current.$slide.trigger(\"onReset\"),i.$refs.container.empty().remove(),i.trigger(\"afterClose\",t),i.$lastFocus&&i.current.opts.backFocus&&i.$lastFocus.focus(),i.current=null,o=n.fancybox.getInstance(),o?o.activate():(s.scrollTop(i.scrollTop).scrollLeft(i.scrollLeft),r.removeClass(\"fancybox-active compensate-for-scrollbar\"),r.hasClass(\"fancybox-iosfix\")&&(a=parseInt(e.body.style.top,10),r.removeClass(\"fancybox-iosfix\").css(\"top\",\"\").scrollTop(a*-1)),n(\"#fancybox-style-noscroll\").remove())},trigger:function(t,e){var o,a=Array.prototype.slice.call(arguments,1),i=this,s=e&&e.opts?e:i.current;return s?a.unshift(s):s=i,a.unshift(i),n.isFunction(s.opts[t])&&(o=s.opts[t].apply(s,a)),o===!1?o:void(\"afterClose\"!==t&&i.$refs?i.$refs.container.trigger(t+\".fb\",a):r.trigger(t+\".fb\",a))},updateControls:function(t){var e=this,n=e.current,o=n.index,a=n.opts.caption,i=e.$refs.container,s=e.$refs.caption;n.$slide.trigger(\"refresh\"),e.$caption=a&&a.length?s.html(a):null,e.isHiddenControls||e.isIdle||e.showControls(),i.find(\"[data-fancybox-count]\").html(e.group.length),i.find(\"[data-fancybox-index]\").html(o+1),i.find(\"[data-fancybox-prev]\").prop(\"disabled\",!n.opts.loop&&o<=0),i.find(\"[data-fancybox-next]\").prop(\"disabled\",!n.opts.loop&&o>=e.group.length-1),\"image\"===n.type?i.find(\"[data-fancybox-download]\").attr(\"href\",n.opts.image.src||n.src).show():i.find(\"[data-fancybox-download],[data-fancybox-zoom]\").hide()},hideControls:function(){this.isHiddenControls=!0,this.$refs.container.removeClass(\"fancybox-show-infobar fancybox-show-toolbar fancybox-show-caption fancybox-show-nav\")},showControls:function(){var t=this,e=t.current?t.current.opts:t.opts,n=t.$refs.container;t.isHiddenControls=!1,t.idleSecondsCounter=0,n.toggleClass(\"fancybox-show-toolbar\",!(!e.toolbar||!e.buttons)).toggleClass(\"fancybox-show-infobar\",!!(e.infobar&&t.group.length>1)).toggleClass(\"fancybox-show-nav\",!!(e.arrows&&t.group.length>1)).toggleClass(\"fancybox-is-modal\",!!e.modal),t.$caption?n.addClass(\"fancybox-show-caption \"):n.removeClass(\"fancybox-show-caption\")},toggleControls:function(){this.isHiddenControls?this.showControls():this.hideControls()}}),n.fancybox={version:\"3.2.8\",defaults:i,getInstance:function(t){var e=n('.fancybox-container:not(\".fancybox-is-closing\"):last').data(\"FancyBox\"),o=Array.prototype.slice.call(arguments,1);return e instanceof p&&(\"string\"===n.type(t)?e[t].apply(e,o):\"function\"===n.type(t)&&t.apply(e,o),e)},open:function(t,e,n){return new p(t,e,n)},close:function(t){var e=this.getInstance();e&&(e.close(),t===!0&&this.close())},destroy:function(){this.close(!0),r.off(\"click.fb-start\")},isMobile:e.createTouch!==o&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),use3d:function(){var n=e.createElement(\"div\");return t.getComputedStyle&&t.getComputedStyle(n).getPropertyValue(\"transform\")&&!(e.documentMode&&e.documentMode<11)}(),getTranslate:function(t){var e;if(!t||!t.length)return!1;if(e=t.eq(0).css(\"transform\"),e&&e.indexOf(\"matrix\")!==-1?(e=e.split(\"(\")[1],e=e.split(\")\")[0],e=e.split(\",\")):e=[],e.length)e=e.length>10?[e[13],e[12],e[0],e[5]]:[e[5],e[4],e[0],e[3]],e=e.map(parseFloat);else{e=[0,0,1,1];var n=/\\.*translate\\((.*)px,(.*)px\\)/i,o=n.exec(t.eq(0).attr(\"style\"));o&&(e[0]=parseFloat(o[2]),e[1]=parseFloat(o[1]))}return{top:e[0],left:e[1],scaleX:e[2],scaleY:e[3],opacity:parseFloat(t.css(\"opacity\")),width:t.width(),height:t.height()}},setTranslate:function(t,e){var n=\"\",a={};if(t&&e)return e.left===o&&e.top===o||(n=(e.left===o?t.position().left:e.left)+\"px, \"+(e.top===o?t.position().top:e.top)+\"px\",n=this.use3d?\"translate3d(\"+n+\", 0px)\":\"translate(\"+n+\")\"),e.scaleX!==o&&e.scaleY!==o&&(n=(n.length?n+\" \":\"\")+\"scale(\"+e.scaleX+\", \"+e.scaleY+\")\"),n.length&&(a.transform=n),e.opacity!==o&&(a.opacity=e.opacity),e.width!==o&&(a.width=e.width),e.height!==o&&(a.height=e.height),t.css(a)},animate:function(t,e,a,i,s){n.isFunction(a)&&(i=a,a=null),n.isPlainObject(e)||t.removeAttr(\"style\"),t.on(d,function(a){(!a||!a.originalEvent||t.is(a.originalEvent.target)&&\"z-index\"!=a.originalEvent.propertyName)&&(n.fancybox.stop(t),n.isPlainObject(e)?e.scaleX!==o&&e.scaleY!==o&&(t.css(\"transition-duration\",\"\"),e.width=Math.round(t.width()*e.scaleX),e.height=Math.round(t.height()*e.scaleY),e.scaleX=1,e.scaleY=1,n.fancybox.setTranslate(t,e)):s!==!0&&t.removeClass(e),n.isFunction(i)&&i(a))}),n.isNumeric(a)&&t.css(\"transition-duration\",a+\"ms\"),n.isPlainObject(e)?n.fancybox.setTranslate(t,e):t.addClass(e),e.scaleX&&t.hasClass(\"fancybox-image-wrap\")&&t.parent().addClass(\"fancybox-is-scaling\"),t.data(\"timer\",setTimeout(function(){t.trigger(\"transitionend\")},a+16))},stop:function(t){clearTimeout(t.data(\"timer\")),t.off(\"transitionend\").css(\"transition-duration\",\"\"),t.hasClass(\"fancybox-image-wrap\")&&t.parent().removeClass(\"fancybox-is-scaling\")}},n.fn.fancybox=function(t){var e;return t=t||{},e=t.selector||!1,e?n(\"body\").off(\"click.fb-start\",e).on(\"click.fb-start\",e,{options:t},a):this.off(\"click.fb-start\").on(\"click.fb-start\",{items:this,options:t},a),this},r.on(\"click.fb-start\",\"[data-fancybox]\",a)}}(window,document,window.jQuery||jQuery),function(t){\"use strict\";var e=function(e,n,o){if(e)return o=o||\"\",\"object\"===t.type(o)&&(o=t.param(o,!0)),t.each(n,function(t,n){e=e.replace(\"$\"+t,n||\"\")}),o.length&&(e+=(e.indexOf(\"?\")>0?\"&\":\"?\")+o),e},n={youtube:{matcher:/(youtube\\.com|youtu\\.be|youtube\\-nocookie\\.com)\\/(watch\\?(.*&)?v=|v\\/|u\\/|embed\\/?)?(videoseries\\?list=(.*)|[\\w-]{11}|\\?listType=(.*)&list=(.*))(.*)/i,params:{autoplay:1,autohide:1,fs:1,rel:0,hd:1,wmode:\"transparent\",enablejsapi:1,html5:1},paramPlace:8,type:\"iframe\",url:\"//www.youtube.com/embed/$4\",thumb:\"//img.youtube.com/vi/$4/hqdefault.jpg\"},vimeo:{matcher:/^.+vimeo.com\\/(.*\\/)?([\\d]+)(.*)?/,params:{autoplay:1,hd:1,show_title:1,show_byline:1,show_portrait:0,fullscreen:1,api:1},paramPlace:3,type:\"iframe\",url:\"//player.vimeo.com/video/$2\"},metacafe:{matcher:/metacafe.com\\/watch\\/(\\d+)\\/(.*)?/,type:\"iframe\",url:\"//www.metacafe.com/embed/$1/?ap=1\"},dailymotion:{matcher:/dailymotion.com\\/video\\/(.*)\\/?(.*)/,params:{additionalInfos:0,autoStart:1},type:\"iframe\",url:\"//www.dailymotion.com/embed/video/$1\"},vine:{matcher:/vine.co\\/v\\/([a-zA-Z0-9\\?\\=\\-]+)/,\ntype:\"iframe\",url:\"//vine.co/v/$1/embed/simple\"},instagram:{matcher:/(instagr\\.am|instagram\\.com)\\/p\\/([a-zA-Z0-9_\\-]+)\\/?/i,type:\"image\",url:\"//$1/p/$2/media/?size=l\"},gmap_place:{matcher:/(maps\\.)?google\\.([a-z]{2,3}(\\.[a-z]{2})?)\\/(((maps\\/(place\\/(.*)\\/)?\\@(.*),(\\d+.?\\d+?)z))|(\\?ll=))(.*)?/i,type:\"iframe\",url:function(t){return\"//maps.google.\"+t[2]+\"/?ll=\"+(t[9]?t[9]+\"&z=\"+Math.floor(t[10])+(t[12]?t[12].replace(/^\\//,\"&\"):\"\"):t[12])+\"&output=\"+(t[12]&&t[12].indexOf(\"layer=c\")>0?\"svembed\":\"embed\")}},gmap_search:{matcher:/(maps\\.)?google\\.([a-z]{2,3}(\\.[a-z]{2})?)\\/(maps\\/search\\/)(.*)/i,type:\"iframe\",url:function(t){return\"//maps.google.\"+t[2]+\"/maps?q=\"+t[5].replace(\"query=\",\"q=\").replace(\"api=1\",\"\")+\"&output=embed\"}}};t(document).on(\"objectNeedsType.fb\",function(o,a,i){var s,r,c,l,u,d,f,p=i.src||\"\",h=!1;s=t.extend(!0,{},n,i.opts.media),t.each(s,function(n,o){if(c=p.match(o.matcher)){if(h=o.type,d={},o.paramPlace&&c[o.paramPlace]){u=c[o.paramPlace],\"?\"==u[0]&&(u=u.substring(1)),u=u.split(\"&\");for(var a=0;a<u.length;++a){var s=u[a].split(\"=\",2);2==s.length&&(d[s[0]]=decodeURIComponent(s[1].replace(/\\+/g,\" \")))}}return l=t.extend(!0,{},o.params,i.opts[n],d),p=\"function\"===t.type(o.url)?o.url.call(this,c,l,i):e(o.url,c,l),r=\"function\"===t.type(o.thumb)?o.thumb.call(this,c,l,i):e(o.thumb,c),\"vimeo\"===n&&(p=p.replace(\"&%23\",\"#\")),!1}}),h?(i.src=p,i.type=h,i.opts.thumb||i.opts.$thumb&&i.opts.$thumb.length||(i.opts.thumb=r),\"iframe\"===h&&(t.extend(!0,i.opts,{iframe:{preload:!1,attr:{scrolling:\"no\"}}}),i.contentProvider=f,i.opts.slideClass+=\" fancybox-slide--\"+(\"gmap_place\"==f||\"gmap_search\"==f?\"map\":\"video\"))):p&&(i.type=i.opts.defaultType)})}(window.jQuery||jQuery),function(t,e,n){\"use strict\";var o=function(){return t.requestAnimationFrame||t.webkitRequestAnimationFrame||t.mozRequestAnimationFrame||t.oRequestAnimationFrame||function(e){return t.setTimeout(e,1e3/60)}}(),a=function(){return t.cancelAnimationFrame||t.webkitCancelAnimationFrame||t.mozCancelAnimationFrame||t.oCancelAnimationFrame||function(e){t.clearTimeout(e)}}(),i=function(e){var n=[];e=e.originalEvent||e||t.e,e=e.touches&&e.touches.length?e.touches:e.changedTouches&&e.changedTouches.length?e.changedTouches:[e];for(var o in e)e[o].pageX?n.push({x:e[o].pageX,y:e[o].pageY}):e[o].clientX&&n.push({x:e[o].clientX,y:e[o].clientY});return n},s=function(t,e,n){return e&&t?\"x\"===n?t.x-e.x:\"y\"===n?t.y-e.y:Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2)):0},r=function(t){if(t.is('a,area,button,[role=\"button\"],input,label,select,summary,textarea')||n.isFunction(t.get(0).onclick)||t.data(\"selectable\"))return!0;for(var e=0,o=t[0].attributes,a=o.length;e<a;e++)if(\"data-fancybox-\"===o[e].nodeName.substr(0,14))return!0;return!1},c=function(e){var n=t.getComputedStyle(e)[\"overflow-y\"],o=t.getComputedStyle(e)[\"overflow-x\"],a=(\"scroll\"===n||\"auto\"===n)&&e.scrollHeight>e.clientHeight,i=(\"scroll\"===o||\"auto\"===o)&&e.scrollWidth>e.clientWidth;return a||i},l=function(t){for(var e=!1;;){if(e=c(t.get(0)))break;if(t=t.parent(),!t.length||t.hasClass(\"fancybox-stage\")||t.is(\"body\"))break}return e},u=function(t){var e=this;e.instance=t,e.$bg=t.$refs.bg,e.$stage=t.$refs.stage,e.$container=t.$refs.container,e.destroy(),e.$container.on(\"touchstart.fb.touch mousedown.fb.touch\",n.proxy(e,\"ontouchstart\"))};u.prototype.destroy=function(){this.$container.off(\".fb.touch\")},u.prototype.ontouchstart=function(o){var a=this,c=n(o.target),u=a.instance,d=u.current,f=d.$content,p=\"touchstart\"==o.type;if(p&&a.$container.off(\"mousedown.fb.touch\"),!d||a.instance.isAnimating||a.instance.isClosing)return o.stopPropagation(),void o.preventDefault();if((!o.originalEvent||2!=o.originalEvent.button)&&c.length&&!r(c)&&!r(c.parent())&&!(o.originalEvent.clientX>c[0].clientWidth+c.offset().left)&&(a.startPoints=i(o),a.startPoints)){if(a.$target=c,a.$content=f,a.canTap=!0,a.opts=d.opts.touch,n(e).off(\".fb.touch\"),n(e).on(p?\"touchend.fb.touch touchcancel.fb.touch\":\"mouseup.fb.touch mouseleave.fb.touch\",n.proxy(a,\"ontouchend\")),n(e).on(p?\"touchmove.fb.touch\":\"mousemove.fb.touch\",n.proxy(a,\"ontouchmove\")),!a.opts&&!u.canPan()||!c.is(a.$stage)&&!a.$stage.find(c).length)return void(c.is(\"img\")&&o.preventDefault());o.stopPropagation(),n.fancybox.isMobile&&(l(a.$target)||l(a.$target.parent()))||o.preventDefault(),a.canvasWidth=Math.round(d.$slide[0].clientWidth),a.canvasHeight=Math.round(d.$slide[0].clientHeight),a.startTime=(new Date).getTime(),a.distanceX=a.distanceY=a.distance=0,a.isPanning=!1,a.isSwiping=!1,a.isZooming=!1,a.sliderStartPos=a.sliderLastPos||{top:0,left:0},a.contentStartPos=n.fancybox.getTranslate(a.$content),a.contentLastPos=null,1!==a.startPoints.length||a.isZooming||(a.canTap=!0,\"image\"===d.type&&(a.contentStartPos.width>a.canvasWidth+1||a.contentStartPos.height>a.canvasHeight+1)?(n.fancybox.stop(a.$content),a.$content.css(\"transition-duration\",\"\"),a.isPanning=!0):a.isSwiping=!0,a.$container.addClass(\"fancybox-controls--isGrabbing\")),2!==a.startPoints.length||u.isAnimating||d.hasError||\"image\"!==d.type||!d.isLoaded&&!d.$ghost||(a.isZooming=!0,a.isSwiping=!1,a.isPanning=!1,n.fancybox.stop(a.$content),a.$content.css(\"transition-duration\",\"\"),a.centerPointStartX=.5*(a.startPoints[0].x+a.startPoints[1].x)-n(t).scrollLeft(),a.centerPointStartY=.5*(a.startPoints[0].y+a.startPoints[1].y)-n(t).scrollTop(),a.percentageOfImageAtPinchPointX=(a.centerPointStartX-a.contentStartPos.left)/a.contentStartPos.width,a.percentageOfImageAtPinchPointY=(a.centerPointStartY-a.contentStartPos.top)/a.contentStartPos.height,a.startDistanceBetweenFingers=s(a.startPoints[0],a.startPoints[1]))}},u.prototype.ontouchmove=function(t){var e=this;if(e.newPoints=i(t),n.fancybox.isMobile&&(l(e.$target)||l(e.$target.parent())))return t.stopPropagation(),void(e.canTap=!1);if((e.opts||e.instance.canPan())&&e.newPoints&&e.newPoints.length&&(e.distanceX=s(e.newPoints[0],e.startPoints[0],\"x\"),e.distanceY=s(e.newPoints[0],e.startPoints[0],\"y\"),e.distance=s(e.newPoints[0],e.startPoints[0]),e.distance>0&&!e.tapped)){if(!e.$target.is(e.$stage)&&!e.$stage.find(e.$target).length)return;t.stopPropagation(),t.preventDefault(),e.isSwiping?e.onSwipe():e.isPanning?e.onPan():e.isZooming&&e.onZoom()}},u.prototype.onSwipe=function(){var e,i=this,s=i.isSwiping,r=i.sliderStartPos.left||0;return s===!0?void(Math.abs(i.distance)>10&&(i.canTap=!1,i.instance.group.length<2&&i.opts.vertical?i.isSwiping=\"y\":i.instance.isDragging||i.opts.vertical===!1||\"auto\"===i.opts.vertical&&n(t).width()>800?i.isSwiping=\"x\":(e=Math.abs(180*Math.atan2(i.distanceY,i.distanceX)/Math.PI),i.isSwiping=e>45&&e<135?\"y\":\"x\"),i.instance.isDragging=i.isSwiping,i.startPoints=i.newPoints,n.each(i.instance.slides,function(t,e){n.fancybox.stop(e.$slide),e.$slide.css(\"transition-duration\",\"\"),e.inTransition=!1,e.pos===i.instance.current.pos&&(i.sliderStartPos.left=n.fancybox.getTranslate(e.$slide).left)}),i.instance.SlideShow&&i.instance.SlideShow.isActive&&i.instance.SlideShow.stop())):(\"x\"==s&&(i.distanceX>0&&(i.instance.group.length<2||0===i.instance.current.index&&!i.instance.current.opts.loop)?r+=Math.pow(i.distanceX,.8):i.distanceX<0&&(i.instance.group.length<2||i.instance.current.index===i.instance.group.length-1&&!i.instance.current.opts.loop)?r-=Math.pow(-i.distanceX,.8):r+=i.distanceX),i.sliderLastPos={top:\"x\"==s?0:i.sliderStartPos.top+i.distanceY,left:r},i.requestId&&(a(i.requestId),i.requestId=null),void(i.requestId=o(function(){i.sliderLastPos&&(n.each(i.instance.slides,function(t,e){var o=e.pos-i.instance.currPos;n.fancybox.setTranslate(e.$slide,{top:i.sliderLastPos.top,left:i.sliderLastPos.left+o*i.canvasWidth+o*e.opts.gutter})}),i.$container.addClass(\"fancybox-is-sliding\"))})))},u.prototype.onPan=function(){var t,e,i,s=this;s.canTap=!1,t=s.contentStartPos.width>s.canvasWidth?s.contentStartPos.left+s.distanceX:s.contentStartPos.left,e=s.contentStartPos.top+s.distanceY,i=s.limitMovement(t,e,s.contentStartPos.width,s.contentStartPos.height),i.scaleX=s.contentStartPos.scaleX,i.scaleY=s.contentStartPos.scaleY,s.contentLastPos=i,s.requestId&&(a(s.requestId),s.requestId=null),s.requestId=o(function(){n.fancybox.setTranslate(s.$content,s.contentLastPos)})},u.prototype.limitMovement=function(t,e,n,o){var a,i,s,r,c=this,l=c.canvasWidth,u=c.canvasHeight,d=c.contentStartPos.left,f=c.contentStartPos.top,p=c.distanceX,h=c.distanceY;return a=Math.max(0,.5*l-.5*n),i=Math.max(0,.5*u-.5*o),s=Math.min(l-n,.5*l-.5*n),r=Math.min(u-o,.5*u-.5*o),n>l&&(p>0&&t>a&&(t=a-1+Math.pow(-a+d+p,.8)||0),p<0&&t<s&&(t=s+1-Math.pow(s-d-p,.8)||0)),o>u&&(h>0&&e>i&&(e=i-1+Math.pow(-i+f+h,.8)||0),h<0&&e<r&&(e=r+1-Math.pow(r-f-h,.8)||0)),{top:e,left:t}},u.prototype.limitPosition=function(t,e,n,o){var a=this,i=a.canvasWidth,s=a.canvasHeight;return n>i?(t=t>0?0:t,t=t<i-n?i-n:t):t=Math.max(0,i/2-n/2),o>s?(e=e>0?0:e,e=e<s-o?s-o:e):e=Math.max(0,s/2-o/2),{top:e,left:t}},u.prototype.onZoom=function(){var e=this,i=e.contentStartPos.width,r=e.contentStartPos.height,c=e.contentStartPos.left,l=e.contentStartPos.top,u=s(e.newPoints[0],e.newPoints[1]),d=u/e.startDistanceBetweenFingers,f=Math.floor(i*d),p=Math.floor(r*d),h=(i-f)*e.percentageOfImageAtPinchPointX,g=(r-p)*e.percentageOfImageAtPinchPointY,b=(e.newPoints[0].x+e.newPoints[1].x)/2-n(t).scrollLeft(),m=(e.newPoints[0].y+e.newPoints[1].y)/2-n(t).scrollTop(),y=b-e.centerPointStartX,v=m-e.centerPointStartY,x=c+(h+y),w=l+(g+v),$={top:w,left:x,scaleX:e.contentStartPos.scaleX*d,scaleY:e.contentStartPos.scaleY*d};e.canTap=!1,e.newWidth=f,e.newHeight=p,e.contentLastPos=$,e.requestId&&(a(e.requestId),e.requestId=null),e.requestId=o(function(){n.fancybox.setTranslate(e.$content,e.contentLastPos)})},u.prototype.ontouchend=function(t){var o=this,s=Math.max((new Date).getTime()-o.startTime,1),r=o.isSwiping,c=o.isPanning,l=o.isZooming;return o.endPoints=i(t),o.$container.removeClass(\"fancybox-controls--isGrabbing\"),n(e).off(\".fb.touch\"),o.requestId&&(a(o.requestId),o.requestId=null),o.isSwiping=!1,o.isPanning=!1,o.isZooming=!1,o.instance.isDragging=!1,o.canTap?o.onTap(t):(o.speed=366,o.velocityX=o.distanceX/s*.5,o.velocityY=o.distanceY/s*.5,o.speedX=Math.max(.5*o.speed,Math.min(1.5*o.speed,1/Math.abs(o.velocityX)*o.speed)),void(c?o.endPanning():l?o.endZooming():o.endSwiping(r)))},u.prototype.endSwiping=function(t){var e=this,o=!1;e.sliderLastPos=null,\"y\"==t&&Math.abs(e.distanceY)>50?(n.fancybox.animate(e.instance.current.$slide,{top:e.sliderStartPos.top+e.distanceY+150*e.velocityY,opacity:0},150),o=e.instance.close(!0,300)):\"x\"==t&&e.distanceX>50&&e.instance.group.length>1?o=e.instance.previous(e.speedX):\"x\"==t&&e.distanceX<-50&&e.instance.group.length>1&&(o=e.instance.next(e.speedX)),o!==!1||\"x\"!=t&&\"y\"!=t||e.instance.jumpTo(e.instance.current.index,150),e.$container.removeClass(\"fancybox-is-sliding\")},u.prototype.endPanning=function(){var t,e,o,a=this;a.contentLastPos&&(a.opts.momentum===!1?(t=a.contentLastPos.left,e=a.contentLastPos.top):(t=a.contentLastPos.left+a.velocityX*a.speed,e=a.contentLastPos.top+a.velocityY*a.speed),o=a.limitPosition(t,e,a.contentStartPos.width,a.contentStartPos.height),o.width=a.contentStartPos.width,o.height=a.contentStartPos.height,n.fancybox.animate(a.$content,o,330))},u.prototype.endZooming=function(){var t,e,o,a,i=this,s=i.instance.current,r=i.newWidth,c=i.newHeight;i.contentLastPos&&(t=i.contentLastPos.left,e=i.contentLastPos.top,a={top:e,left:t,width:r,height:c,scaleX:1,scaleY:1},n.fancybox.setTranslate(i.$content,a),r<i.canvasWidth&&c<i.canvasHeight?i.instance.scaleToFit(150):r>s.width||c>s.height?i.instance.scaleToActual(i.centerPointStartX,i.centerPointStartY,150):(o=i.limitPosition(t,e,r,c),n.fancybox.setTranslate(i.content,n.fancybox.getTranslate(i.$content)),n.fancybox.animate(i.$content,o,150)))},u.prototype.onTap=function(t){var e,o=this,a=n(t.target),s=o.instance,r=s.current,c=t&&i(t)||o.startPoints,l=c[0]?c[0].x-o.$stage.offset().left:0,u=c[0]?c[0].y-o.$stage.offset().top:0,d=function(e){var a=r.opts[e];if(n.isFunction(a)&&(a=a.apply(s,[r,t])),a)switch(a){case\"close\":s.close(o.startEvent);break;case\"toggleControls\":s.toggleControls(!0);break;case\"next\":s.next();break;case\"nextOrClose\":s.group.length>1?s.next():s.close(o.startEvent);break;case\"zoom\":\"image\"==r.type&&(r.isLoaded||r.$ghost)&&(s.canPan()?s.scaleToFit():s.isScaledDown()?s.scaleToActual(l,u):s.group.length<2&&s.close(o.startEvent))}};if(!(t.originalEvent&&2==t.originalEvent.button||l>a[0].clientWidth+a.offset().left)){if(a.is(\".fancybox-bg,.fancybox-inner,.fancybox-outer,.fancybox-container\"))e=\"Outside\";else if(a.is(\".fancybox-slide\"))e=\"Slide\";else{if(!s.current.$content||!s.current.$content.has(t.target).length)return;e=\"Content\"}if(o.tapped){if(clearTimeout(o.tapped),o.tapped=null,Math.abs(l-o.tapX)>50||Math.abs(u-o.tapY)>50)return this;d(\"dblclick\"+e)}else o.tapX=l,o.tapY=u,r.opts[\"dblclick\"+e]&&r.opts[\"dblclick\"+e]!==r.opts[\"click\"+e]?o.tapped=setTimeout(function(){o.tapped=null,d(\"click\"+e)},500):d(\"click\"+e);return this}},n(e).on(\"onActivate.fb\",function(t,e){e&&!e.Guestures&&(e.Guestures=new u(e))}),n(e).on(\"beforeClose.fb\",function(t,e){e&&e.Guestures&&e.Guestures.destroy()})}(window,document,window.jQuery||jQuery),function(t,e){\"use strict\";e.extend(!0,e.fancybox.defaults,{btnTpl:{slideShow:'<button data-fancybox-play class=\"fancybox-button fancybox-button--play\" title=\"{{PLAY_START}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M13,12 L27,20 L13,27 Z\" /><path d=\"M15,10 v19 M23,10 v19\" /></svg></button>'},slideShow:{autoStart:!1,speed:3e3}});var n=function(t){this.instance=t,this.init()};e.extend(n.prototype,{timer:null,isActive:!1,$button:null,init:function(){var t=this;t.$button=t.instance.$refs.toolbar.find(\"[data-fancybox-play]\").on(\"click\",function(){t.toggle()}),(t.instance.group.length<2||!t.instance.group[t.instance.currIndex].opts.slideShow)&&t.$button.hide()},set:function(t){var e=this;e.instance&&e.instance.current&&(t===!0||e.instance.current.opts.loop||e.instance.currIndex<e.instance.group.length-1)?e.timer=setTimeout(function(){e.isActive&&e.instance.jumpTo((e.instance.currIndex+1)%e.instance.group.length)},e.instance.current.opts.slideShow.speed):(e.stop(),e.instance.idleSecondsCounter=0,e.instance.showControls())},clear:function(){var t=this;clearTimeout(t.timer),t.timer=null},start:function(){var t=this,e=t.instance.current;e&&(t.isActive=!0,t.$button.attr(\"title\",e.opts.i18n[e.opts.lang].PLAY_STOP).removeClass(\"fancybox-button--play\").addClass(\"fancybox-button--pause\"),t.set(!0))},stop:function(){var t=this,e=t.instance.current;t.clear(),t.$button.attr(\"title\",e.opts.i18n[e.opts.lang].PLAY_START).removeClass(\"fancybox-button--pause\").addClass(\"fancybox-button--play\"),t.isActive=!1},toggle:function(){var t=this;t.isActive?t.stop():t.start()}}),e(t).on({\"onInit.fb\":function(t,e){e&&!e.SlideShow&&(e.SlideShow=new n(e))},\"beforeShow.fb\":function(t,e,n,o){var a=e&&e.SlideShow;o?a&&n.opts.slideShow.autoStart&&a.start():a&&a.isActive&&a.clear()},\"afterShow.fb\":function(t,e,n){var o=e&&e.SlideShow;o&&o.isActive&&o.set()},\"afterKeydown.fb\":function(n,o,a,i,s){var r=o&&o.SlideShow;!r||!a.opts.slideShow||80!==s&&32!==s||e(t.activeElement).is(\"button,a,input\")||(i.preventDefault(),r.toggle())},\"beforeClose.fb onDeactivate.fb\":function(t,e){var n=e&&e.SlideShow;n&&n.stop()}}),e(t).on(\"visibilitychange\",function(){var n=e.fancybox.getInstance(),o=n&&n.SlideShow;o&&o.isActive&&(t.hidden?o.clear():o.set())})}(document,window.jQuery||jQuery),function(t,e){\"use strict\";var n=function(){var e,n,o,a=[[\"requestFullscreen\",\"exitFullscreen\",\"fullscreenElement\",\"fullscreenEnabled\",\"fullscreenchange\",\"fullscreenerror\"],[\"webkitRequestFullscreen\",\"webkitExitFullscreen\",\"webkitFullscreenElement\",\"webkitFullscreenEnabled\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"webkitRequestFullScreen\",\"webkitCancelFullScreen\",\"webkitCurrentFullScreenElement\",\"webkitCancelFullScreen\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"mozRequestFullScreen\",\"mozCancelFullScreen\",\"mozFullScreenElement\",\"mozFullScreenEnabled\",\"mozfullscreenchange\",\"mozfullscreenerror\"],[\"msRequestFullscreen\",\"msExitFullscreen\",\"msFullscreenElement\",\"msFullscreenEnabled\",\"MSFullscreenChange\",\"MSFullscreenError\"]],i={};for(n=0;n<a.length;n++)if(e=a[n],e&&e[1]in t){for(o=0;o<e.length;o++)i[a[0][o]]=e[o];return i}return!1}();if(!n)return void(e&&e.fancybox&&(e.fancybox.defaults.btnTpl.fullScreen=!1));var o={request:function(e){e=e||t.documentElement,e[n.requestFullscreen](e.ALLOW_KEYBOARD_INPUT)},exit:function(){t[n.exitFullscreen]()},toggle:function(e){e=e||t.documentElement,this.isFullscreen()?this.exit():this.request(e)},isFullscreen:function(){return Boolean(t[n.fullscreenElement])},enabled:function(){return Boolean(t[n.fullscreenEnabled])}};e.extend(!0,e.fancybox.defaults,{btnTpl:{fullScreen:'<button data-fancybox-fullscreen class=\"fancybox-button fancybox-button--fullscreen\" title=\"{{FULL_SCREEN}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M9,12 h22 v16 h-22 v-16 v16 h22 v-16 Z\" /></svg></button>'},fullScreen:{autoStart:!1}}),e(t).on({\"onInit.fb\":function(t,e){var n;e&&e.group[e.currIndex].opts.fullScreen?(n=e.$refs.container,n.on(\"click.fb-fullscreen\",\"[data-fancybox-fullscreen]\",function(t){t.stopPropagation(),t.preventDefault(),o.toggle(n[0])}),e.opts.fullScreen&&e.opts.fullScreen.autoStart===!0&&o.request(n[0]),e.FullScreen=o):e&&e.$refs.toolbar.find(\"[data-fancybox-fullscreen]\").hide()},\"afterKeydown.fb\":function(t,e,n,o,a){e&&e.FullScreen&&70===a&&(o.preventDefault(),e.FullScreen.toggle(e.$refs.container[0]))},\"beforeClose.fb\":function(t){t&&t.FullScreen&&o.exit()}}),e(t).on(n.fullscreenchange,function(){var t=o.isFullscreen(),n=e.fancybox.getInstance();n&&(n.current&&\"image\"===n.current.type&&n.isAnimating&&(n.current.$content.css(\"transition\",\"none\"),n.isAnimating=!1,n.update(!0,!0,0)),n.trigger(\"onFullscreenChange\",t),n.$refs.container.toggleClass(\"fancybox-is-fullscreen\",t))})}(document,window.jQuery||jQuery),function(t,e){\"use strict\";e.fancybox.defaults=e.extend(!0,{btnTpl:{thumbs:'<button data-fancybox-thumbs class=\"fancybox-button fancybox-button--thumbs\" title=\"{{THUMBS}}\"><svg viewBox=\"0 0 120 120\"><path d=\"M30,30 h14 v14 h-14 Z M50,30 h14 v14 h-14 Z M70,30 h14 v14 h-14 Z M30,50 h14 v14 h-14 Z M50,50 h14 v14 h-14 Z M70,50 h14 v14 h-14 Z M30,70 h14 v14 h-14 Z M50,70 h14 v14 h-14 Z M70,70 h14 v14 h-14 Z\" /></svg></button>'},thumbs:{autoStart:!1,hideOnClose:!0,parentEl:\".fancybox-container\",axis:\"y\"}},e.fancybox.defaults);var n=function(t){this.init(t)};e.extend(n.prototype,{$button:null,$grid:null,$list:null,isVisible:!1,isActive:!1,init:function(t){var e=this;e.instance=t,t.Thumbs=e;var n=t.group[0],o=t.group[1];e.opts=t.group[t.currIndex].opts.thumbs,e.$button=t.$refs.toolbar.find(\"[data-fancybox-thumbs]\"),e.opts&&n&&o&&(\"image\"==n.type||n.opts.thumb||n.opts.$thumb)&&(\"image\"==o.type||o.opts.thumb||o.opts.$thumb)?(e.$button.show().on(\"click\",function(){e.toggle()}),e.isActive=!0):e.$button.hide()},create:function(){var t,n,o=this,a=o.instance,i=o.opts.parentEl;o.$grid=e('<div class=\"fancybox-thumbs fancybox-thumbs-'+o.opts.axis+'\"></div>').appendTo(a.$refs.container.find(i).addBack().filter(i)),t=\"<ul>\",e.each(a.group,function(e,o){n=o.opts.thumb||(o.opts.$thumb?o.opts.$thumb.attr(\"src\"):null),n||\"image\"!==o.type||(n=o.src),n&&n.length&&(t+='<li data-index=\"'+e+'\"  tabindex=\"0\" class=\"fancybox-thumbs-loading\"><img data-src=\"'+n+'\" /></li>')}),t+=\"</ul>\",o.$list=e(t).appendTo(o.$grid).on(\"click\",\"li\",function(){a.jumpTo(e(this).data(\"index\"))}),o.$list.find(\"img\").hide().one(\"load\",function(){var t,n,o,a,i=e(this).parent().removeClass(\"fancybox-thumbs-loading\"),s=i.outerWidth(),r=i.outerHeight();t=this.naturalWidth||this.width,n=this.naturalHeight||this.height,o=t/s,a=n/r,o>=1&&a>=1&&(o>a?(t/=a,n=r):(t=s,n/=o)),e(this).css({width:Math.floor(t),height:Math.floor(n),\"margin-top\":n>r?Math.floor(.3*r-.3*n):Math.floor(.5*r-.5*n),\"margin-left\":Math.floor(.5*s-.5*t)}).show()}).each(function(){this.src=e(this).data(\"src\")}),\"x\"===o.opts.axis&&o.$list.width(parseInt(o.$grid.css(\"padding-right\"))+a.group.length*o.$list.children().eq(0).outerWidth(!0)+\"px\")},focus:function(t){var e,n,o=this,a=o.$list;o.instance.current&&(e=a.children().removeClass(\"fancybox-thumbs-active\").filter('[data-index=\"'+o.instance.current.index+'\"]').addClass(\"fancybox-thumbs-active\"),n=e.position(),\"y\"===o.opts.axis&&(n.top<0||n.top>a.height()-e.outerHeight())?a.stop().animate({scrollTop:a.scrollTop()+n.top},t):\"x\"===o.opts.axis&&(n.left<a.parent().scrollLeft()||n.left>a.parent().scrollLeft()+(a.parent().width()-e.outerWidth()))&&a.parent().stop().animate({scrollLeft:n.left},t))},update:function(){this.instance.$refs.container.toggleClass(\"fancybox-show-thumbs\",this.isVisible),this.isVisible?(this.$grid||this.create(),this.instance.trigger(\"onThumbsShow\"),this.focus(0)):this.$grid&&this.instance.trigger(\"onThumbsHide\"),this.instance.update()},hide:function(){this.isVisible=!1,this.update()},show:function(){this.isVisible=!0,this.update()},toggle:function(){this.isVisible=!this.isVisible,this.update()}}),e(t).on({\"onInit.fb\":function(t,e){var o;e&&!e.Thumbs&&(o=new n(e),o.isActive&&o.opts.autoStart===!0&&o.show())},\"beforeShow.fb\":function(t,e,n,o){var a=e&&e.Thumbs;a&&a.isVisible&&a.focus(o?0:250)},\"afterKeydown.fb\":function(t,e,n,o,a){var i=e&&e.Thumbs;i&&i.isActive&&71===a&&(o.preventDefault(),i.toggle())},\"beforeClose.fb\":function(t,e){var n=e&&e.Thumbs;n&&n.isVisible&&n.opts.hideOnClose!==!1&&n.$grid.hide()}})}(document,window.jQuery),function(t,e){\"use strict\";function n(t){var e={\"&\":\"&amp;\",\"<\":\"&lt;\",\">\":\"&gt;\",'\"':\"&quot;\",\"'\":\"&#39;\",\"/\":\"&#x2F;\",\"`\":\"&#x60;\",\"=\":\"&#x3D;\"};return String(t).replace(/[&<>\"'`=\\/]/g,function(t){return e[t]})}e.extend(!0,e.fancybox.defaults,{btnTpl:{share:'<button data-fancybox-share class=\"fancybox-button fancybox-button--share\" title=\"{{SHARE}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M6,30 C8,18 19,16 23,16 L23,16 L23,10 L33,20 L23,29 L23,24 C19,24 8,27 6,30 Z\"></svg></button>'},share:{tpl:'<div class=\"fancybox-share\"><h1>{{SHARE}}</h1><p><a href=\"https://www.facebook.com/sharer/sharer.php?u={{src}}\" target=\"_blank\" class=\"fancybox-share_button\"><svg version=\"1.1\" viewBox=\"0 0 32 32\" fill=\"#3b5998\"><path d=\"M27.6 3h-23.2c-.8 0-1.4.6-1.4 1.4v23.1c0 .9.6 1.5 1.4 1.5h12.5v-10.1h-3.4v-3.9h3.4v-2.9c0-3.4 2.1-5.2 5-5.2 1.4 0 2.7.1 3 .2v3.5h-2.1c-1.6 0-1.9.8-1.9 1.9v2.5h3.9l-.5 3.9h-3.4v10.1h6.6c.8 0 1.4-.6 1.4-1.4v-23.2c.1-.8-.5-1.4-1.3-1.4z\"></path></svg><span>Facebook</span></a><a href=\"https://www.pinterest.com/pin/create/button/?url={{src}}&amp;description={{descr}}\" target=\"_blank\" class=\"fancybox-share_button\"><svg version=\"1.1\" viewBox=\"0 0 32 32\" fill=\"#c92228\"><path d=\"M16 3c-7.2 0-13 5.8-13 13 0 5.5 3.4 10.2 8.3 12.1-.1-1-.2-2.6 0-3.7.2-1 1.5-6.5 1.5-6.5s-.4-.8-.4-1.9c0-1.8 1-3.2 2.4-3.2 1.1 0 1.6.8 1.6 1.8 0 1.1-.7 2.8-1.1 4.3-.3 1.3.6 2.3 1.9 2.3 2.3 0 4.1-2.4 4.1-6 0-3.1-2.2-5.3-5.4-5.3-3.7 0-5.9 2.8-5.9 5.6 0 1.1.4 2.3 1 3 .1.1.1.2.1.4-.1.4-.3 1.3-.4 1.5-.1.2-.2.3-.4.2-1.6-.8-2.6-3.1-2.6-5 0-4.1 3-7.9 8.6-7.9 4.5 0 8 3.2 8 7.5 0 4.5-2.8 8.1-6.7 8.1-1.3 0-2.6-.7-3-1.5 0 0-.7 2.5-.8 3.1-.3 1.1-1.1 2.5-1.6 3.4 1.2.4 2.5.6 3.8.6 7.2 0 13-5.8 13-13 0-7.1-5.8-12.9-13-12.9z\"></path></svg><span>Pinterest</span></a><a href=\"https://twitter.com/intent/tweet?url={{src}}&amp;text={{descr}}\" target=\"_blank\" class=\"fancybox-share_button\"><svg version=\"1.1\" viewBox=\"0 0 32 32\" fill=\"#1da1f2\"><path d=\"M30 7.3c-1 .5-2.1.8-3.3.9 1.2-.7 2.1-1.8 2.5-3.2-1.1.7-2.3 1.1-3.6 1.4-1-1.1-2.5-1.8-4.2-1.8-3.2 0-5.7 2.6-5.7 5.7 0 .5.1.9.1 1.3-4.8-.2-9-2.5-11.8-6-.5.9-.8 1.9-.8 3 0 2 1 3.8 2.6 4.8-.9 0-1.8-.3-2.6-.7v.1c0 2.8 2 5.1 4.6 5.6-.5.1-1 .2-1.5.2-.4 0-.7 0-1.1-.1.7 2.3 2.9 3.9 5.4 4-2 1.5-4.4 2.5-7.1 2.5-.5 0-.9 0-1.4-.1 2.5 1.6 5.6 2.6 8.8 2.6 10.6 0 16.3-8.8 16.3-16.3v-.7c1.1-1 2-2 2.8-3.2z\"></path></svg><span>Twitter</span></a></p><p><input type=\"text\" value=\"{{src_raw}}\" onfocus=\"this.select()\" /></p></div>'}}),e(t).on(\"click\",\"[data-fancybox-share]\",function(){var t,o,a=e.fancybox.getInstance();a&&(t=a.current.opts.hash===!1?a.current.src:window.location,o=a.current.opts.share.tpl.replace(/\\{\\{src\\}\\}/g,encodeURIComponent(t)).replace(/\\{\\{src_raw\\}\\}/g,n(t)).replace(/\\{\\{descr\\}\\}/g,a.$caption?encodeURIComponent(a.$caption.text()):\"\"),e.fancybox.open({src:a.translate(a,o),type:\"html\",opts:{animationEffect:\"fade\",animationDuration:250}}))})}(document,window.jQuery||jQuery),function(t,e,n){\"use strict\";function o(){var t=e.location.hash.substr(1),n=t.split(\"-\"),o=n.length>1&&/^\\+?\\d+$/.test(n[n.length-1])?parseInt(n.pop(-1),10)||1:1,a=n.join(\"-\");return o<1&&(o=1),{hash:t,index:o,gallery:a}}function a(t){var e;\"\"!==t.gallery&&(e=n(\"[data-fancybox='\"+n.escapeSelector(t.gallery)+\"']\").eq(t.index-1),e.length||(e=n(\"#\"+n.escapeSelector(t.gallery))),e.length&&(s=!1,e.trigger(\"click\")))}function i(t){var e;return!!t&&(e=t.current?t.current.opts:t.opts,e.hash||(e.$orig?e.$orig.data(\"fancybox\"):\"\"))}n.escapeSelector||(n.escapeSelector=function(t){var e=/([\\0-\\x1f\\x7f]|^-?\\d)|^-$|[^\\x80-\\uFFFF\\w-]/g,n=function(t,e){return e?\"\\0\"===t?\"\ufffd\":t.slice(0,-1)+\"\\\\\"+t.charCodeAt(t.length-1).toString(16)+\" \":\"\\\\\"+t};return(t+\"\").replace(e,n)});var s=!0,r=null,c=null;n(function(){n.fancybox.defaults.hash!==!1&&(n(t).on({\"onInit.fb\":function(t,e){var n,a;e.group[e.currIndex].opts.hash!==!1&&(n=o(),a=i(e),a&&n.gallery&&a==n.gallery&&(e.currIndex=n.index-1))},\"beforeShow.fb\":function(n,o,a){var l;a&&a.opts.hash!==!1&&(l=i(o),l&&\"\"!==l&&(e.location.hash.indexOf(l)<0&&(o.opts.origHash=e.location.hash),r=l+(o.group.length>1?\"-\"+(a.index+1):\"\"),\"replaceState\"in e.history?(c&&clearTimeout(c),c=setTimeout(function(){e.history[s?\"pushState\":\"replaceState\"]({},t.title,e.location.pathname+e.location.search+\"#\"+r),c=null,s=!1},300)):e.location.hash=r))},\"beforeClose.fb\":function(o,a,s){var l,u;c&&clearTimeout(c),s.opts.hash!==!1&&(l=i(a),u=a&&a.opts.origHash?a.opts.origHash:\"\",l&&\"\"!==l&&(\"replaceState\"in history?e.history.replaceState({},t.title,e.location.pathname+e.location.search+u):(e.location.hash=u,n(e).scrollTop(a.scrollTop).scrollLeft(a.scrollLeft))),r=null)}}),n(e).on(\"hashchange.fb\",function(){var t=o();n.fancybox.getInstance()?!r||r===t.gallery+\"-\"+t.index||1===t.index&&r==t.gallery||(r=null,n.fancybox.close()):\"\"!==t.gallery&&a(t)}),setTimeout(function(){a(o())},50))})}(document,window,window.jQuery||jQuery),function(t,e){\"use strict\";var n=(new Date).getTime();e(t).on({\"onInit.fb\":function(t,e,o){e.$refs.stage.on(\"mousewheel DOMMouseScroll wheel MozMousePixelScroll\",function(t){var o,a,i,s,r,c=e.current;c.opts.wheel===!1||\"auto\"===c.opts.wheel&&\"image\"!==c.type||c.$slide.hasClass(\"fancybox-animated\")||e.group.length<1||(t.preventDefault(),t.stopPropagation(),t=t.originalEvent||t,o-n<250||(n=o,a=t.wheelDelta||-t.deltaY||-t.detail,i=Math.max(-1,Math.min(1,a)),s=\"undefined\"!=typeof t.wheelDeltaX||\"undefined\"!=typeof t.deltaX,r=!s||Math.abs(t.wheelDeltaX)<Math.abs(t.wheelDelta)||Math.abs(t.deltaX)<Math.abs(t.deltaY),i<0?e[r?\"previous\":\"next\"]():e[r?\"next\":\"previous\"]()))})}})}(document,window.jQuery||jQuery);","Magefan_Blog/js/lazyload.js":"/**\n * Copyright \u00a9 2016 Ihor Vansach (ihor@magefan.com). All rights reserved.\n * See LICENSE.txt for license details (http://opensource.org/licenses/osl-3.0.php).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\n/**\n * Posts autload\n */\n define([\n    'domReady!',\n    'jquery'\n], function (domReady, $) {\n    'use strict';\n\n    var Lazyload = function(options) {\n\n        var that = this;\n\n        /**\n         * Lazyload default options.\n         * @type {Object}\n         */\n        that.defaults = {\n            expires: null,\n            path: '/',\n            domain: null,\n            secure: false,\n            lifetime: null\n        };\n\n        /**\n         * Init options\n         * @type {Object}\n         */\n        that.opt = $.extend(that.default, options);\n\n        /**\n         * Load new content\n         */\n        function startLoading()\n        {\n            if (that.opt.current_page < that.opt.last_page && !that.loading) {\n\n                that.loading = true;\n                $('.mfblog-show-onload').show();\n                $('.mfblog-hide-onload').hide();\n\n                $.ajax({\n                    \"url\":that.opt.page_url[that.opt.current_page+1],\n                    \"cache\":true\n                }).success(function(data) {\n                    var $html = $(data);\n                    var ws = that.opt.list_wrapper;\n                    var $nw = $html.find(ws);\n                    if ($nw.length) {\n                        $(ws).append($nw.html());\n                        that.opt.current_page++;\n                    }\n\n                    endLoading();\n\n                }).fail(function(xhr, ajaxOptions, thrownError) {\n                    console.log(thrownError);\n                    endLoading();\n                });\n            }\n        }\n\n        /**\n         * On loading end\n         */\n        function endLoading() {\n            that.loading = false;\n            $('.mfblog-show-onload').hide();\n            if (that.opt.current_page < that.opt.last_page) {\n                $('.mfblog-hide-onload').show();\n            }\n        }\n\n        /* Is not loading now */\n        endLoading();\n\n        /* If auto trigger enabled */\n        if (that.opt.auto_trigger) {\n            var $w = $(window);\n            $w.scroll(function() {\n                if ($w.scrollTop() + $w.height() >= $(document).height() - that.opt.padding)  {\n                    startLoading();\n                }\n            });\n        }\n\n        /* On trigger element click */\n        if (that.opt.trigger_element) {\n            $(that.opt.trigger_element).click(function(){\n                startLoading();\n            });\n        }\n    }\n\n    return function (options) {\n        new Lazyload(options)\n    };\n\n});\n","Magefan_Blog/js/lib/masonry.pkgd.min.js":"/*!\n * Masonry PACKAGED v4.1.1\n * Cascading grid layout library\n * http://masonry.desandro.com\n * MIT License\n * by David DeSandro\n */\n\n!function(t,e){\"function\"==typeof define&&define.amd?define(\"jquery-bridget/jquery-bridget\",[\"jquery\"],function(i){return e(t,i)}):\"object\"==typeof module&&module.exports?module.exports=e(t,require(\"jquery\")):t.jQueryBridget=e(t,t.jQuery)}(window,function(t,e){\"use strict\";function i(i,r,a){function h(t,e,n){var o,r=\"$().\"+i+'(\"'+e+'\")';return t.each(function(t,h){var u=a.data(h,i);if(!u)return void s(i+\" not initialized. Cannot call methods, i.e. \"+r);var d=u[e];if(!d||\"_\"==e.charAt(0))return void s(r+\" is not a valid method\");var l=d.apply(u,n);o=void 0===o?l:o}),void 0!==o?o:t}function u(t,e){t.each(function(t,n){var o=a.data(n,i);o?(o.option(e),o._init()):(o=new r(n,e),a.data(n,i,o))})}a=a||e||t.jQuery,a&&(r.prototype.option||(r.prototype.option=function(t){a.isPlainObject(t)&&(this.options=a.extend(!0,this.options,t))}),a.fn[i]=function(t){if(\"string\"==typeof t){var e=o.call(arguments,1);return h(this,t,e)}return u(this,t),this},n(a))}function n(t){!t||t&&t.bridget||(t.bridget=i)}var o=Array.prototype.slice,r=t.console,s=\"undefined\"==typeof r?function(){}:function(t){r.error(t)};return n(e||t.jQuery),i}),function(t,e){\"function\"==typeof define&&define.amd?define(\"ev-emitter/ev-emitter\",e):\"object\"==typeof module&&module.exports?module.exports=e():t.EvEmitter=e()}(\"undefined\"!=typeof window?window:this,function(){function t(){}var e=t.prototype;return e.on=function(t,e){if(t&&e){var i=this._events=this._events||{},n=i[t]=i[t]||[];return-1==n.indexOf(e)&&n.push(e),this}},e.once=function(t,e){if(t&&e){this.on(t,e);var i=this._onceEvents=this._onceEvents||{},n=i[t]=i[t]||{};return n[e]=!0,this}},e.off=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var n=i.indexOf(e);return-1!=n&&i.splice(n,1),this}},e.emitEvent=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var n=0,o=i[n];e=e||[];for(var r=this._onceEvents&&this._onceEvents[t];o;){var s=r&&r[o];s&&(this.off(t,o),delete r[o]),o.apply(this,e),n+=s?0:1,o=i[n]}return this}},t}),function(t,e){\"use strict\";\"function\"==typeof define&&define.amd?define(\"get-size/get-size\",[],function(){return e()}):\"object\"==typeof module&&module.exports?module.exports=e():t.getSize=e()}(window,function(){\"use strict\";function t(t){var e=parseFloat(t),i=-1==t.indexOf(\"%\")&&!isNaN(e);return i&&e}function e(){}function i(){for(var t={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},e=0;u>e;e++){var i=h[e];t[i]=0}return t}function n(t){var e=getComputedStyle(t);return e||a(\"Style returned \"+e+\". Are you running this code in a hidden iframe on Firefox? See http://bit.ly/getsizebug1\"),e}function o(){if(!d){d=!0;var e=document.createElement(\"div\");e.style.width=\"200px\",e.style.padding=\"1px 2px 3px 4px\",e.style.borderStyle=\"solid\",e.style.borderWidth=\"1px 2px 3px 4px\",e.style.boxSizing=\"border-box\";var i=document.body||document.documentElement;i.appendChild(e);var o=n(e);r.isBoxSizeOuter=s=200==t(o.width),i.removeChild(e)}}function r(e){if(o(),\"string\"==typeof e&&(e=document.querySelector(e)),e&&\"object\"==typeof e&&e.nodeType){var r=n(e);if(\"none\"==r.display)return i();var a={};a.width=e.offsetWidth,a.height=e.offsetHeight;for(var d=a.isBorderBox=\"border-box\"==r.boxSizing,l=0;u>l;l++){var c=h[l],f=r[c],m=parseFloat(f);a[c]=isNaN(m)?0:m}var p=a.paddingLeft+a.paddingRight,g=a.paddingTop+a.paddingBottom,y=a.marginLeft+a.marginRight,v=a.marginTop+a.marginBottom,_=a.borderLeftWidth+a.borderRightWidth,E=a.borderTopWidth+a.borderBottomWidth,z=d&&s,b=t(r.width);b!==!1&&(a.width=b+(z?0:p+_));var x=t(r.height);return x!==!1&&(a.height=x+(z?0:g+E)),a.innerWidth=a.width-(p+_),a.innerHeight=a.height-(g+E),a.outerWidth=a.width+y,a.outerHeight=a.height+v,a}}var s,a=\"undefined\"==typeof console?e:function(t){console.error(t)},h=[\"paddingLeft\",\"paddingRight\",\"paddingTop\",\"paddingBottom\",\"marginLeft\",\"marginRight\",\"marginTop\",\"marginBottom\",\"borderLeftWidth\",\"borderRightWidth\",\"borderTopWidth\",\"borderBottomWidth\"],u=h.length,d=!1;return r}),function(t,e){\"use strict\";\"function\"==typeof define&&define.amd?define(\"desandro-matches-selector/matches-selector\",e):\"object\"==typeof module&&module.exports?module.exports=e():t.matchesSelector=e()}(window,function(){\"use strict\";var t=function(){var t=Element.prototype;if(t.matches)return\"matches\";if(t.matchesSelector)return\"matchesSelector\";for(var e=[\"webkit\",\"moz\",\"ms\",\"o\"],i=0;i<e.length;i++){var n=e[i],o=n+\"MatchesSelector\";if(t[o])return o}}();return function(e,i){return e[t](i)}}),function(t,e){\"function\"==typeof define&&define.amd?define(\"fizzy-ui-utils/utils\",[\"desandro-matches-selector/matches-selector\"],function(i){return e(t,i)}):\"object\"==typeof module&&module.exports?module.exports=e(t,require(\"desandro-matches-selector\")):t.fizzyUIUtils=e(t,t.matchesSelector)}(window,function(t,e){var i={};i.extend=function(t,e){for(var i in e)t[i]=e[i];return t},i.modulo=function(t,e){return(t%e+e)%e},i.makeArray=function(t){var e=[];if(Array.isArray(t))e=t;else if(t&&\"number\"==typeof t.length)for(var i=0;i<t.length;i++)e.push(t[i]);else e.push(t);return e},i.removeFrom=function(t,e){var i=t.indexOf(e);-1!=i&&t.splice(i,1)},i.getParent=function(t,i){for(;t!=document.body;)if(t=t.parentNode,e(t,i))return t},i.getQueryElement=function(t){return\"string\"==typeof t?document.querySelector(t):t},i.handleEvent=function(t){var e=\"on\"+t.type;this[e]&&this[e](t)},i.filterFindElements=function(t,n){t=i.makeArray(t);var o=[];return t.forEach(function(t){if(t instanceof HTMLElement){if(!n)return void o.push(t);e(t,n)&&o.push(t);for(var i=t.querySelectorAll(n),r=0;r<i.length;r++)o.push(i[r])}}),o},i.debounceMethod=function(t,e,i){var n=t.prototype[e],o=e+\"Timeout\";t.prototype[e]=function(){var t=this[o];t&&clearTimeout(t);var e=arguments,r=this;this[o]=setTimeout(function(){n.apply(r,e),delete r[o]},i||100)}},i.docReady=function(t){var e=document.readyState;\"complete\"==e||\"interactive\"==e?t():document.addEventListener(\"DOMContentLoaded\",t)},i.toDashed=function(t){return t.replace(/(.)([A-Z])/g,function(t,e,i){return e+\"-\"+i}).toLowerCase()};var n=t.console;return i.htmlInit=function(e,o){i.docReady(function(){var r=i.toDashed(o),s=\"data-\"+r,a=document.querySelectorAll(\"[\"+s+\"]\"),h=document.querySelectorAll(\".js-\"+r),u=i.makeArray(a).concat(i.makeArray(h)),d=s+\"-options\",l=t.jQuery;u.forEach(function(t){var i,r=t.getAttribute(s)||t.getAttribute(d);try{i=r&&JSON.parse(r)}catch(a){return void(n&&n.error(\"Error parsing \"+s+\" on \"+t.className+\": \"+a))}var h=new e(t,i);l&&l.data(t,o,h)})})},i}),function(t,e){\"function\"==typeof define&&define.amd?define(\"outlayer/item\",[\"ev-emitter/ev-emitter\",\"get-size/get-size\"],e):\"object\"==typeof module&&module.exports?module.exports=e(require(\"ev-emitter\"),require(\"get-size\")):(t.Outlayer={},t.Outlayer.Item=e(t.EvEmitter,t.getSize))}(window,function(t,e){\"use strict\";function i(t){for(var e in t)return!1;return e=null,!0}function n(t,e){t&&(this.element=t,this.layout=e,this.position={x:0,y:0},this._create())}function o(t){return t.replace(/([A-Z])/g,function(t){return\"-\"+t.toLowerCase()})}var r=document.documentElement.style,s=\"string\"==typeof r.transition?\"transition\":\"WebkitTransition\",a=\"string\"==typeof r.transform?\"transform\":\"WebkitTransform\",h={WebkitTransition:\"webkitTransitionEnd\",transition:\"transitionend\"}[s],u={transform:a,transition:s,transitionDuration:s+\"Duration\",transitionProperty:s+\"Property\",transitionDelay:s+\"Delay\"},d=n.prototype=Object.create(t.prototype);d.constructor=n,d._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:\"absolute\"})},d.handleEvent=function(t){var e=\"on\"+t.type;this[e]&&this[e](t)},d.getSize=function(){this.size=e(this.element)},d.css=function(t){var e=this.element.style;for(var i in t){var n=u[i]||i;e[n]=t[i]}},d.getPosition=function(){var t=getComputedStyle(this.element),e=this.layout._getOption(\"originLeft\"),i=this.layout._getOption(\"originTop\"),n=t[e?\"left\":\"right\"],o=t[i?\"top\":\"bottom\"],r=this.layout.size,s=-1!=n.indexOf(\"%\")?parseFloat(n)/100*r.width:parseInt(n,10),a=-1!=o.indexOf(\"%\")?parseFloat(o)/100*r.height:parseInt(o,10);s=isNaN(s)?0:s,a=isNaN(a)?0:a,s-=e?r.paddingLeft:r.paddingRight,a-=i?r.paddingTop:r.paddingBottom,this.position.x=s,this.position.y=a},d.layoutPosition=function(){var t=this.layout.size,e={},i=this.layout._getOption(\"originLeft\"),n=this.layout._getOption(\"originTop\"),o=i?\"paddingLeft\":\"paddingRight\",r=i?\"left\":\"right\",s=i?\"right\":\"left\",a=this.position.x+t[o];e[r]=this.getXValue(a),e[s]=\"\";var h=n?\"paddingTop\":\"paddingBottom\",u=n?\"top\":\"bottom\",d=n?\"bottom\":\"top\",l=this.position.y+t[h];e[u]=this.getYValue(l),e[d]=\"\",this.css(e),this.emitEvent(\"layout\",[this])},d.getXValue=function(t){var e=this.layout._getOption(\"horizontal\");return this.layout.options.percentPosition&&!e?t/this.layout.size.width*100+\"%\":t+\"px\"},d.getYValue=function(t){var e=this.layout._getOption(\"horizontal\");return this.layout.options.percentPosition&&e?t/this.layout.size.height*100+\"%\":t+\"px\"},d._transitionTo=function(t,e){this.getPosition();var i=this.position.x,n=this.position.y,o=parseInt(t,10),r=parseInt(e,10),s=o===this.position.x&&r===this.position.y;if(this.setPosition(t,e),s&&!this.isTransitioning)return void this.layoutPosition();var a=t-i,h=e-n,u={};u.transform=this.getTranslate(a,h),this.transition({to:u,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0})},d.getTranslate=function(t,e){var i=this.layout._getOption(\"originLeft\"),n=this.layout._getOption(\"originTop\");return t=i?t:-t,e=n?e:-e,\"translate3d(\"+t+\"px, \"+e+\"px, 0)\"},d.goTo=function(t,e){this.setPosition(t,e),this.layoutPosition()},d.moveTo=d._transitionTo,d.setPosition=function(t,e){this.position.x=parseInt(t,10),this.position.y=parseInt(e,10)},d._nonTransition=function(t){this.css(t.to),t.isCleaning&&this._removeStyles(t.to);for(var e in t.onTransitionEnd)t.onTransitionEnd[e].call(this)},d.transition=function(t){if(!parseFloat(this.layout.options.transitionDuration))return void this._nonTransition(t);var e=this._transn;for(var i in t.onTransitionEnd)e.onEnd[i]=t.onTransitionEnd[i];for(i in t.to)e.ingProperties[i]=!0,t.isCleaning&&(e.clean[i]=!0);if(t.from){this.css(t.from);var n=this.element.offsetHeight;n=null}this.enableTransition(t.to),this.css(t.to),this.isTransitioning=!0};var l=\"opacity,\"+o(a);d.enableTransition=function(){if(!this.isTransitioning){var t=this.layout.options.transitionDuration;t=\"number\"==typeof t?t+\"ms\":t,this.css({transitionProperty:l,transitionDuration:t,transitionDelay:this.staggerDelay||0}),this.element.addEventListener(h,this,!1)}},d.onwebkitTransitionEnd=function(t){this.ontransitionend(t)},d.onotransitionend=function(t){this.ontransitionend(t)};var c={\"-webkit-transform\":\"transform\"};d.ontransitionend=function(t){if(t.target===this.element){var e=this._transn,n=c[t.propertyName]||t.propertyName;if(delete e.ingProperties[n],i(e.ingProperties)&&this.disableTransition(),n in e.clean&&(this.element.style[t.propertyName]=\"\",delete e.clean[n]),n in e.onEnd){var o=e.onEnd[n];o.call(this),delete e.onEnd[n]}this.emitEvent(\"transitionEnd\",[this])}},d.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(h,this,!1),this.isTransitioning=!1},d._removeStyles=function(t){var e={};for(var i in t)e[i]=\"\";this.css(e)};var f={transitionProperty:\"\",transitionDuration:\"\",transitionDelay:\"\"};return d.removeTransitionStyles=function(){this.css(f)},d.stagger=function(t){t=isNaN(t)?0:t,this.staggerDelay=t+\"ms\"},d.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:\"\"}),this.emitEvent(\"remove\",[this])},d.remove=function(){return s&&parseFloat(this.layout.options.transitionDuration)?(this.once(\"transitionEnd\",function(){this.removeElem()}),void this.hide()):void this.removeElem()},d.reveal=function(){delete this.isHidden,this.css({display:\"\"});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty(\"visibleStyle\");e[i]=this.onRevealTransitionEnd,this.transition({from:t.hiddenStyle,to:t.visibleStyle,isCleaning:!0,onTransitionEnd:e})},d.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent(\"reveal\")},d.getHideRevealTransitionEndProperty=function(t){var e=this.layout.options[t];if(e.opacity)return\"opacity\";for(var i in e)return i},d.hide=function(){this.isHidden=!0,this.css({display:\"\"});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty(\"hiddenStyle\");e[i]=this.onHideTransitionEnd,this.transition({from:t.visibleStyle,to:t.hiddenStyle,isCleaning:!0,onTransitionEnd:e})},d.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:\"none\"}),this.emitEvent(\"hide\"))},d.destroy=function(){this.css({position:\"\",left:\"\",right:\"\",top:\"\",bottom:\"\",transition:\"\",transform:\"\"})},n}),function(t,e){\"use strict\";\"function\"==typeof define&&define.amd?define(\"outlayer/outlayer\",[\"ev-emitter/ev-emitter\",\"get-size/get-size\",\"fizzy-ui-utils/utils\",\"./item\"],function(i,n,o,r){return e(t,i,n,o,r)}):\"object\"==typeof module&&module.exports?module.exports=e(t,require(\"ev-emitter\"),require(\"get-size\"),require(\"fizzy-ui-utils\"),require(\"./item\")):t.Outlayer=e(t,t.EvEmitter,t.getSize,t.fizzyUIUtils,t.Outlayer.Item)}(window,function(t,e,i,n,o){\"use strict\";function r(t,e){var i=n.getQueryElement(t);if(!i)return void(h&&h.error(\"Bad element for \"+this.constructor.namespace+\": \"+(i||t)));this.element=i,u&&(this.$element=u(this.element)),this.options=n.extend({},this.constructor.defaults),this.option(e);var o=++l;this.element.outlayerGUID=o,c[o]=this,this._create();var r=this._getOption(\"initLayout\");r&&this.layout()}function s(t){function e(){t.apply(this,arguments)}return e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e}function a(t){if(\"number\"==typeof t)return t;var e=t.match(/(^\\d*\\.?\\d*)(\\w*)/),i=e&&e[1],n=e&&e[2];if(!i.length)return 0;i=parseFloat(i);var o=m[n]||1;return i*o}var h=t.console,u=t.jQuery,d=function(){},l=0,c={};r.namespace=\"outlayer\",r.Item=o,r.defaults={containerStyle:{position:\"relative\"},initLayout:!0,originLeft:!0,originTop:!0,resize:!0,resizeContainer:!0,transitionDuration:\"0.4s\",hiddenStyle:{opacity:0,transform:\"scale(0.001)\"},visibleStyle:{opacity:1,transform:\"scale(1)\"}};var f=r.prototype;n.extend(f,e.prototype),f.option=function(t){n.extend(this.options,t)},f._getOption=function(t){var e=this.constructor.compatOptions[t];return e&&void 0!==this.options[e]?this.options[e]:this.options[t]},r.compatOptions={initLayout:\"isInitLayout\",horizontal:\"isHorizontal\",layoutInstant:\"isLayoutInstant\",originLeft:\"isOriginLeft\",originTop:\"isOriginTop\",resize:\"isResizeBound\",resizeContainer:\"isResizingContainer\"},f._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),n.extend(this.element.style,this.options.containerStyle);var t=this._getOption(\"resize\");t&&this.bindResize()},f.reloadItems=function(){this.items=this._itemize(this.element.children)},f._itemize=function(t){for(var e=this._filterFindItemElements(t),i=this.constructor.Item,n=[],o=0;o<e.length;o++){var r=e[o],s=new i(r,this);n.push(s)}return n},f._filterFindItemElements=function(t){return n.filterFindElements(t,this.options.itemSelector)},f.getItemElements=function(){return this.items.map(function(t){return t.element})},f.layout=function(){this._resetLayout(),this._manageStamps();var t=this._getOption(\"layoutInstant\"),e=void 0!==t?t:!this._isLayoutInited;this.layoutItems(this.items,e),this._isLayoutInited=!0},f._init=f.layout,f._resetLayout=function(){this.getSize()},f.getSize=function(){this.size=i(this.element)},f._getMeasurement=function(t,e){var n,o=this.options[t];o?(\"string\"==typeof o?n=this.element.querySelector(o):o instanceof HTMLElement&&(n=o),this[t]=n?i(n)[e]:o):this[t]=0},f.layoutItems=function(t,e){t=this._getItemsForLayout(t),this._layoutItems(t,e),this._postLayout()},f._getItemsForLayout=function(t){return t.filter(function(t){return!t.isIgnored})},f._layoutItems=function(t,e){if(this._emitCompleteOnItems(\"layout\",t),t&&t.length){var i=[];t.forEach(function(t){var n=this._getItemLayoutPosition(t);n.item=t,n.isInstant=e||t.isLayoutInstant,i.push(n)},this),this._processLayoutQueue(i)}},f._getItemLayoutPosition=function(){return{x:0,y:0}},f._processLayoutQueue=function(t){this.updateStagger(),t.forEach(function(t,e){this._positionItem(t.item,t.x,t.y,t.isInstant,e)},this)},f.updateStagger=function(){var t=this.options.stagger;return null===t||void 0===t?void(this.stagger=0):(this.stagger=a(t),this.stagger)},f._positionItem=function(t,e,i,n,o){n?t.goTo(e,i):(t.stagger(o*this.stagger),t.moveTo(e,i))},f._postLayout=function(){this.resizeContainer()},f.resizeContainer=function(){var t=this._getOption(\"resizeContainer\");if(t){var e=this._getContainerSize();e&&(this._setContainerMeasure(e.width,!0),this._setContainerMeasure(e.height,!1))}},f._getContainerSize=d,f._setContainerMeasure=function(t,e){if(void 0!==t){var i=this.size;i.isBorderBox&&(t+=e?i.paddingLeft+i.paddingRight+i.borderLeftWidth+i.borderRightWidth:i.paddingBottom+i.paddingTop+i.borderTopWidth+i.borderBottomWidth),t=Math.max(t,0),this.element.style[e?\"width\":\"height\"]=t+\"px\"}},f._emitCompleteOnItems=function(t,e){function i(){o.dispatchEvent(t+\"Complete\",null,[e])}function n(){s++,s==r&&i()}var o=this,r=e.length;if(!e||!r)return void i();var s=0;e.forEach(function(e){e.once(t,n)})},f.dispatchEvent=function(t,e,i){var n=e?[e].concat(i):i;if(this.emitEvent(t,n),u)if(this.$element=this.$element||u(this.element),e){var o=u.Event(e);o.type=t,this.$element.trigger(o,i)}else this.$element.trigger(t,i)},f.ignore=function(t){var e=this.getItem(t);e&&(e.isIgnored=!0)},f.unignore=function(t){var e=this.getItem(t);e&&delete e.isIgnored},f.stamp=function(t){t=this._find(t),t&&(this.stamps=this.stamps.concat(t),t.forEach(this.ignore,this))},f.unstamp=function(t){t=this._find(t),t&&t.forEach(function(t){n.removeFrom(this.stamps,t),this.unignore(t)},this)},f._find=function(t){return t?(\"string\"==typeof t&&(t=this.element.querySelectorAll(t)),t=n.makeArray(t)):void 0},f._manageStamps=function(){this.stamps&&this.stamps.length&&(this._getBoundingRect(),this.stamps.forEach(this._manageStamp,this))},f._getBoundingRect=function(){var t=this.element.getBoundingClientRect(),e=this.size;this._boundingRect={left:t.left+e.paddingLeft+e.borderLeftWidth,top:t.top+e.paddingTop+e.borderTopWidth,right:t.right-(e.paddingRight+e.borderRightWidth),bottom:t.bottom-(e.paddingBottom+e.borderBottomWidth)}},f._manageStamp=d,f._getElementOffset=function(t){var e=t.getBoundingClientRect(),n=this._boundingRect,o=i(t),r={left:e.left-n.left-o.marginLeft,top:e.top-n.top-o.marginTop,right:n.right-e.right-o.marginRight,bottom:n.bottom-e.bottom-o.marginBottom};return r},f.handleEvent=n.handleEvent,f.bindResize=function(){t.addEventListener(\"resize\",this),this.isResizeBound=!0},f.unbindResize=function(){t.removeEventListener(\"resize\",this),this.isResizeBound=!1},f.onresize=function(){this.resize()},n.debounceMethod(r,\"onresize\",100),f.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout()},f.needsResizeLayout=function(){var t=i(this.element),e=this.size&&t;return e&&t.innerWidth!==this.size.innerWidth},f.addItems=function(t){var e=this._itemize(t);return e.length&&(this.items=this.items.concat(e)),e},f.appended=function(t){var e=this.addItems(t);e.length&&(this.layoutItems(e,!0),this.reveal(e))},f.prepended=function(t){var e=this._itemize(t);if(e.length){var i=this.items.slice(0);this.items=e.concat(i),this._resetLayout(),this._manageStamps(),this.layoutItems(e,!0),this.reveal(e),this.layoutItems(i)}},f.reveal=function(t){if(this._emitCompleteOnItems(\"reveal\",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.reveal()})}},f.hide=function(t){if(this._emitCompleteOnItems(\"hide\",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.hide()})}},f.revealItemElements=function(t){var e=this.getItems(t);this.reveal(e)},f.hideItemElements=function(t){var e=this.getItems(t);this.hide(e)},f.getItem=function(t){for(var e=0;e<this.items.length;e++){var i=this.items[e];if(i.element==t)return i}},f.getItems=function(t){t=n.makeArray(t);var e=[];return t.forEach(function(t){var i=this.getItem(t);i&&e.push(i)},this),e},f.remove=function(t){var e=this.getItems(t);this._emitCompleteOnItems(\"remove\",e),e&&e.length&&e.forEach(function(t){t.remove(),n.removeFrom(this.items,t)},this)},f.destroy=function(){var t=this.element.style;t.height=\"\",t.position=\"\",t.width=\"\",this.items.forEach(function(t){t.destroy()}),this.unbindResize();var e=this.element.outlayerGUID;delete c[e],delete this.element.outlayerGUID,u&&u.removeData(this.element,this.constructor.namespace)},r.data=function(t){t=n.getQueryElement(t);var e=t&&t.outlayerGUID;return e&&c[e]},r.create=function(t,e){var i=s(r);return i.defaults=n.extend({},r.defaults),n.extend(i.defaults,e),i.compatOptions=n.extend({},r.compatOptions),i.namespace=t,i.data=r.data,i.Item=s(o),n.htmlInit(i,t),u&&u.bridget&&u.bridget(t,i),i};var m={ms:1,s:1e3};return r.Item=o,r}),function(t,e){\"function\"==typeof define&&define.amd?define([\"outlayer/outlayer\",\"get-size/get-size\"],e):\"object\"==typeof module&&module.exports?module.exports=e(require(\"outlayer\"),require(\"get-size\")):t.Masonry=e(t.Outlayer,t.getSize)}(window,function(t,e){var i=t.create(\"masonry\");return i.compatOptions.fitWidth=\"isFitWidth\",i.prototype._resetLayout=function(){this.getSize(),this._getMeasurement(\"columnWidth\",\"outerWidth\"),this._getMeasurement(\"gutter\",\"outerWidth\"),this.measureColumns(),this.colYs=[];for(var t=0;t<this.cols;t++)this.colYs.push(0);this.maxY=0},i.prototype.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var t=this.items[0],i=t&&t.element;this.columnWidth=i&&e(i).outerWidth||this.containerWidth}var n=this.columnWidth+=this.gutter,o=this.containerWidth+this.gutter,r=o/n,s=n-o%n,a=s&&1>s?\"round\":\"floor\";r=Math[a](r),this.cols=Math.max(r,1)},i.prototype.getContainerWidth=function(){var t=this._getOption(\"fitWidth\"),i=t?this.element.parentNode:this.element,n=e(i);this.containerWidth=n&&n.innerWidth},i.prototype._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth%this.columnWidth,i=e&&1>e?\"round\":\"ceil\",n=Math[i](t.size.outerWidth/this.columnWidth);n=Math.min(n,this.cols);for(var o=this._getColGroup(n),r=Math.min.apply(Math,o),s=o.indexOf(r),a={x:this.columnWidth*s,y:r},h=r+t.size.outerHeight,u=this.cols+1-o.length,d=0;u>d;d++)this.colYs[s+d]=h;return a},i.prototype._getColGroup=function(t){if(2>t)return this.colYs;for(var e=[],i=this.cols+1-t,n=0;i>n;n++){var o=this.colYs.slice(n,n+t);e[n]=Math.max.apply(Math,o)}return e},i.prototype._manageStamp=function(t){var i=e(t),n=this._getElementOffset(t),o=this._getOption(\"originLeft\"),r=o?n.left:n.right,s=r+i.outerWidth,a=Math.floor(r/this.columnWidth);a=Math.max(0,a);var h=Math.floor(s/this.columnWidth);h-=s%this.columnWidth?0:1,h=Math.min(this.cols-1,h);for(var u=this._getOption(\"originTop\"),d=(u?n.top:n.bottom)+i.outerHeight,l=a;h>=l;l++)this.colYs[l]=Math.max(d,this.colYs[l])},i.prototype._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var t={height:this.maxY};return this._getOption(\"fitWidth\")&&(t.width=this._getContainerFitWidth()),t},i.prototype._getContainerFitWidth=function(){for(var t=0,e=this.cols;--e&&0===this.colYs[e];)t++;return(this.cols-t)*this.columnWidth-this.gutter},i.prototype.needsResizeLayout=function(){var t=this.containerWidth;return this.getContainerWidth(),t!=this.containerWidth},i});","Magefan_Blog/js/lib/mfblogunveil.js":"/**\n * jQuery Unveil\n * A very lightweight jQuery plugin to lazy load images\n * http://luis-almeida.github.com/unveil\n *\n * Licensed under the MIT license.\n * Copyright 2013 Lu\u00eds Almeida\n * https://github.com/luis-almeida\n */\n\ndefine(['jquery'], function($) {\n    /* Origin https://github.com/luis-almeida/unveil/blob/master/jquery.unveil.js */\n    $.fn.mfblogunveil = function(threshold, callback) {\n\n        var $w = $(window),\n            th = threshold || 0,\n            attrib = 'data-original',\n            images = this,\n            loaded;\n\n        this.one(\"mfblogunveil\", function() {\n            var source = this.getAttribute(attrib);\n            /*source = source || this.getAttribute(\"data-src\");*/\n            if (source) {\n                /*this.setAttribute(\"src\", source);*/\n\n                if (window.MagefanWebP && window.MagefanWebP.canUseWebP() && !source.includes('mf_webp')) {\n                    source = window.MagefanWebP.getWebUrl(source);\n                }\n                \n                var style = this.getAttribute('style') ? (this.getAttribute('style') + '; ') : '';\n                style = style + 'background-image: url(\"' + source + '\");'\n                this.setAttribute('style', style);\n\n                if (typeof callback === \"function\") callback.call(this);\n            }\n        });\n\n        function mfblogunveil() {\n            var inview = images.filter(function() {\n                var $e = $(this);\n                if ($e.is(\":hidden\")) return;\n\n                var wt = $w.scrollTop(),\n                    wb = wt + $w.height(),\n                    et = $e.offset().top,\n                    eb = et + $e.height();\n\n                return eb >= wt - th && et <= wb + th;\n            });\n\n            loaded = inview.trigger(\"mfblogunveil\");\n            images = images.not(loaded);\n        }\n\n        $w.on(\"scroll.mfblogunveil resize.mfblogunveil lookup.mfblogunveil\", mfblogunveil);\n\n        mfblogunveil();\n\n        return this;\n    };\n});\n","Magento_InventoryConfigurableProductFrontendUi/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'configurableVariationQty',\n    'jquery-ui-modules/widget'\n], function ($, configurableVariationQty) {\n    'use strict';\n\n    return function (configurable) {\n        $.widget('mage.configurable', configurable, {\n\n            /** @inheritdoc */\n            _configureElement: function (element) {\n                var salesChannel = this.options.spConfig.channel,\n                    salesChannelCode = this.options.spConfig.salesChannelCode,\n                    productVariationsSku = this.options.spConfig.sku;\n\n                this._super(element);\n                configurableVariationQty(productVariationsSku[this.simpleProduct], salesChannel, salesChannelCode);\n            }\n        });\n\n        return $.mage.configurable;\n    };\n});\n","Magento_InventoryConfigurableProductFrontendUi/js/configurable-variation-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Configurable variation left qty.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/url'\n], function ($, _, urlBuilder) {\n    'use strict';\n\n    return function (productSku, salesChannel, salesChannelCode) {\n        var selectorInfoStockSkuQty = '.availability.only',\n            selectorInfoStockSkuQtyValue = '.availability.only > strong',\n            productQtyInfoBlock = $(selectorInfoStockSkuQty),\n            productQtyInfo = $(selectorInfoStockSkuQtyValue);\n\n        if (!_.isUndefined(productSku) && productSku !== null) {\n            $.ajax({\n                url: urlBuilder.build('inventory_catalog/product/getQty/'),\n                dataType: 'json',\n                data: {\n                    'sku': productSku,\n                    'channel': salesChannel,\n                    'salesChannelCode': salesChannelCode\n                }\n            }).done(function (response) {\n                if (response.qty !== null && response.qty > 0) {\n                    productQtyInfo.text(response.qty);\n                    productQtyInfoBlock.show();\n                } else {\n                    productQtyInfoBlock.hide();\n                }\n            }).fail(function () {\n                productQtyInfoBlock.hide();\n            });\n        } else {\n            productQtyInfoBlock.hide();\n        }\n    };\n});\n","js-cookie/cookie-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-cookie/js.cookie'\n], function ($, cookie) {\n    'use strict';\n\n    window.Cookies = window.Cookies || cookie;\n\n    var config = $.cookie = function (key, value, options) {\n        if (value !== undefined) {\n            options = $.extend({}, config.defaults, options);\n\n            return cookie.set(key, value, options);\n        }\n\n        var result = key ? undefined : {},\n            cookies = document.cookie ? document.cookie.split('; ') : [],\n            i;\n\n        for (i = 0; i < cookies.length; i++) {\n            var parts = cookies[i].split('='),\n                name = config.raw ? parts.shift() : decodeURIComponent(parts.shift()),\n                cookieValue = parts.join('=');\n\n            if (key && key === name) {\n                result = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '));\n                break;\n            }\n\n            if (!key && (cookieValue = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '))) !== undefined) {\n                result[name] = cookieValue;\n            }\n        }\n\n        return result;\n    };\n\n    config.defaults = {};\n\n    $.removeCookie = function (key, options) {\n        if ($.cookie(key) === undefined) {\n            return false;\n        }\n\n        $.cookie(key, '', $.extend({}, options, { expires: -1 }));\n        return !$.cookie(key);\n    };\n});\n","js-cookie/js.cookie.js":"/*! js-cookie v3.0.1 | MIT */\n;\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = global || self, (function () {\n                var current = global.Cookies;\n                var exports = global.Cookies = factory();\n                exports.noConflict = function () { global.Cookies = current; return exports; };\n            }()));\n}(this, (function () { 'use strict';\n\n    /* eslint-disable no-var */\n    function assign (target) {\n        for (var i = 1; i < arguments.length; i++) {\n            var source = arguments[i];\n            for (var key in source) {\n                target[key] = source[key];\n            }\n        }\n        return target\n    }\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n    var defaultConverter = {\n        read: function (value) {\n            if (value[0] === '\"') {\n                value = value.slice(1, -1);\n            }\n            return value.replace(/(%[\\dA-F]{2})+/gi, decodeURIComponent)\n        },\n        write: function (value) {\n            return encodeURIComponent(value).replace(\n                /%(2[346BF]|3[AC-F]|40|5[BDE]|60|7[BCD])/g,\n                decodeURIComponent\n            )\n        }\n    };\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n\n    function init (converter, defaultAttributes) {\n        function set (key, value, attributes) {\n            if (typeof document === 'undefined') {\n                return\n            }\n\n            attributes = assign({}, defaultAttributes, attributes);\n\n            if (typeof attributes.expires === 'number') {\n                attributes.expires = new Date(Date.now() + attributes.expires * 864e5);\n            }\n            if (attributes.expires) {\n                attributes.expires = attributes.expires.toUTCString();\n            }\n\n            key = encodeURIComponent(key)\n                .replace(/%(2[346B]|5E|60|7C)/g, decodeURIComponent)\n                .replace(/[()]/g, escape);\n\n            var stringifiedAttributes = '';\n            for (var attributeName in attributes) {\n                if (!attributes[attributeName]) {\n                    continue\n                }\n\n                stringifiedAttributes += '; ' + attributeName;\n\n                if (attributes[attributeName] === true) {\n                    continue\n                }\n\n                // Considers RFC 6265 section 5.2:\n                // ...\n                // 3.  If the remaining unparsed-attributes contains a %x3B (\";\")\n                //     character:\n                // Consume the characters of the unparsed-attributes up to,\n                // not including, the first %x3B (\";\") character.\n                // ...\n                stringifiedAttributes += '=' + attributes[attributeName].split(';')[0];\n            }\n\n            return (document.cookie =\n                key + '=' + converter.write(value, key) + stringifiedAttributes)\n        }\n\n        function get (key) {\n            if (typeof document === 'undefined' || (arguments.length && !key)) {\n                return\n            }\n\n            // To prevent the for loop in the first place assign an empty array\n            // in case there are no cookies at all.\n            var cookies = document.cookie ? document.cookie.split('; ') : [];\n            var jar = {};\n            for (var i = 0; i < cookies.length; i++) {\n                var parts = cookies[i].split('=');\n                var value = parts.slice(1).join('=');\n\n                try {\n                    var foundKey = decodeURIComponent(parts[0]);\n                    jar[foundKey] = converter.read(value, foundKey);\n\n                    if (key === foundKey) {\n                        break\n                    }\n                } catch (e) {}\n            }\n\n            return key ? jar[key] : jar\n        }\n\n        return Object.create(\n            {\n                set: set,\n                get: get,\n                remove: function (key, attributes) {\n                    set(\n                        key,\n                        '',\n                        assign({}, attributes, {\n                            expires: -1\n                        })\n                    );\n                },\n                withAttributes: function (attributes) {\n                    return init(this.converter, assign({}, this.attributes, attributes))\n                },\n                withConverter: function (converter) {\n                    return init(assign({}, this.converter, converter), this.attributes)\n                }\n            },\n            {\n                attributes: { value: Object.freeze(defaultAttributes) },\n                converter: { value: Object.freeze(converter) }\n            }\n        )\n    }\n\n    var api = init(defaultConverter, { path: '/' });\n    /* eslint-enable no-var */\n\n    return api;\n\n})));\n","Magento_ReCaptchaCheckoutSalesRule/js/checkout-sales-rule.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* global grecaptcha */\ndefine(\n    [\n        'Magento_ReCaptchaWebapiUi/js/webapiReCaptcha',\n        'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry',\n        'jquery',\n        'Magento_SalesRule/js/action/set-coupon-code',\n        'Magento_SalesRule/js/action/cancel-coupon',\n        'Magento_Checkout/js/model/quote',\n        'ko'\n    ], function (Component, recaptchaRegistry, $, setCouponCodeAction, cancelCouponAction, quote, ko) {\n        'use strict';\n\n        var totals = quote.getTotals(),\n            couponCode = ko.observable(null),\n            isApplied;\n\n        if (totals()) {\n            couponCode(totals()['coupon_code']);\n        }\n        //Captcha can only be required for adding a coupon so we need to know if one was added already.\n        isApplied = ko.observable(couponCode() != null);\n\n        return Component.extend({\n\n            /**\n             * Initialize parent form.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var self = this,\n                    xRecaptchaValue,\n                    captchaId = this.getReCaptchaId();\n\n                this._super();\n\n                if (couponCode() != null) {\n                    if (isApplied) {\n                        self.validateReCaptcha(true);\n                        $('#' + captchaId).hide();\n                    }\n                }\n\n                if (recaptchaRegistry.triggers.hasOwnProperty('recaptcha-checkout-coupon-apply')) {\n                    recaptchaRegistry.addListener('recaptcha-checkout-coupon-apply', function (token) {\n                        //Add reCaptcha value to coupon request\n                        xRecaptchaValue = token;\n                    });\n                }\n\n                setCouponCodeAction.registerDataModifier(function (headers) {\n                    headers['X-ReCaptcha'] = xRecaptchaValue;\n                });\n\n                if (self.getIsInvisibleRecaptcha()) {\n                    grecaptcha.execute(widgetId);\n                    self.validateReCaptcha(true);\n                }\n                //Refresh reCaptcha after failed request.\n                setCouponCodeAction.registerFailCallback(function () {\n                    if (self.getIsInvisibleRecaptcha()) {\n                        grecaptcha.execute(widgetId);\n                        self.validateReCaptcha(true);\n                    } else {\n                        self.validateReCaptcha(false);\n                        grecaptcha.reset(widgetId);\n                        $('#' + captchaId).show();\n                    }\n                });\n                //Hide captcha when a coupon has been applied.\n                setCouponCodeAction.registerSuccessCallback(function () {\n                    self.validateReCaptcha(true);\n                    $('#' + captchaId).hide();\n                });\n                //Show captcha again if it was canceled.\n                cancelCouponAction.registerSuccessCallback(function () {\n                    self.validateReCaptcha(false);\n                    grecaptcha.reset(widgetId);\n                    $('#' + captchaId).show();\n                });\n            }\n        });\n    });\n","Magento_Newsletter/js/newsletter-sign-up.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiElement',\n    'mage/url',\n    'subscriptionStatusResolver',\n    'mage/validation'\n], function ($, Component, urlBuilder, subscriptionStatusResolver) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            signUpElement: '',\n            submitButton: '',\n            element: null\n        },\n\n        /** @inheritdoc */\n        initialize: function (config, element) {\n            this._super();\n            this.element = element;\n            $(element).on('change', $.proxy(this.updateSignUpStatus, this));\n            this.updateSignUpStatus();\n        },\n\n        /**\n         * Send status request and update subscription element according to result.\n         */\n        updateSignUpStatus: function () {\n            var element = $(this.element),\n                email = element.val(),\n                self = this,\n                newsletterSubscription;\n\n            if ($(self.signUpElement).is(':checked')) {\n                return;\n            }\n\n            if (!email || !$.validator.methods['validate-email'].call(this, email, element)) {\n                return;\n            }\n\n            newsletterSubscription = $.Deferred();\n\n            $(self.submitButton).prop('disabled', true);\n\n            subscriptionStatusResolver(email, newsletterSubscription);\n\n            $.when(newsletterSubscription).done(function (isSubscribed) {\n                if (isSubscribed) {\n                    $(self.signUpElement).prop('checked', true);\n                }\n            }).always(function () {\n                $(self.submitButton).prop('disabled', false);\n            });\n        }\n    });\n});\n","Magento_Newsletter/js/subscription-status-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/url'\n], function ($, urlBuilder) {\n    'use strict';\n\n    return function (email, deferred) {\n        return $.getJSON(\n            urlBuilder.build('newsletter/ajax/status'),\n            {\n                email: email\n            }\n        ).done(function (response) {\n            if (response.errors) {\n                deferred.reject();\n            } else {\n                deferred.resolve(response.subscribed);\n            }\n        }).fail(function () {\n            deferred.reject();\n        });\n    };\n});\n","Magento_Swatches/js/configurable-customer-data.js":"require([\n    'jquery',\n    'Magento_ConfigurableProduct/js/options-updater'\n], function ($, Updater) {\n    'use strict';\n\n    var selectors = {\n            formSelector: '#product_addtocart_form',\n            swatchSelector: '.swatch-opt'\n        },\n        swatchWidgetName = 'mage-SwatchRenderer',\n        widgetInitEvent = 'swatch.initialized',\n\n    /**\n    * Sets all configurable swatch attribute's selected values\n    */\n    updateSwatchOptions = function () {\n        var swatchWidget = $(selectors.swatchSelector).data(swatchWidgetName);\n\n        if (!swatchWidget || !swatchWidget._EmulateSelectedByAttributeId) {\n            return;\n        }\n        swatchWidget._EmulateSelectedByAttributeId(this.productOptions);\n    },\n    updater = new Updater(widgetInitEvent, updateSwatchOptions);\n\n    updater.listen();\n});\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/smart-keyboard-handler',\n    'mage/translate',\n    'priceUtils',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'mage/validation/validation'\n], function ($, _, mageTemplate, keyboardHandler, $t, priceUtils) {\n    'use strict';\n\n    /**\n     * Extend form validation to support swatch accessibility\n     */\n    $.widget('mage.validation', $.mage.validation, {\n        /**\n         * Handle form with swatches validation. Focus on first invalid swatch block.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var swatchWrapper, firstActive, swatches, swatch, successList, errorList, firstSwatch;\n\n            this._superApply(arguments);\n\n            swatchWrapper = '.swatch-attribute-options';\n            swatches = $(event.target).find(swatchWrapper);\n\n            if (!swatches.length) {\n                return;\n            }\n\n            swatch = '.swatch-attribute';\n            firstActive = $(validation.errorList[0].element || []);\n            successList = validation.successList;\n            errorList = validation.errorList;\n            firstSwatch = $(firstActive).parent(swatch).find(swatchWrapper);\n\n            keyboardHandler.focus(swatches);\n\n            $.each(successList, function (index, item) {\n                $(item).parent(swatch).find(swatchWrapper).attr('aria-invalid', false);\n            });\n\n            $.each(errorList, function (index, item) {\n                $(item.element).parent(swatch).find(swatchWrapper).attr('aria-invalid', true);\n            });\n\n            if (firstSwatch.length) {\n                $(firstSwatch).trigger('focus');\n            }\n        }\n    });\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - data-option-type (integer, 0-3)\n     *  - data-option-label (string)\n     *  - data-option-tooltip-thumb\n     *  - data-option-tooltip-value\n     *  - data-thumb-width\n     *  - data-thumb-height\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.data('option-type'), 10),\n                label = $this.data('option-label'),\n                thumb = $this.data('option-tooltip-thumb'),\n                value = $this.data('option-tooltip-value'),\n                width = $this.data('thumb-width'),\n                height = $this.data('thumb-height'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.length) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.on('mouseenter', function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial',\n                                    'width': width + 'px',\n                                    'height': height + 'px'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            });\n\n            $this.on('mouseleave', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // selector of category product tile wrapper\n            selectorProductTile: '.product-item',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // control label id\n            controlLabelId: '',\n\n            // text for more button\n            moreButtonText: $t('More'),\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            // Use ajax to get image data\n            useAjax: false,\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n\n            // whether swatches are rendered in product list or on product page\n            inProductList: false,\n\n            // sly-old-price block selector\n            slyOldPriceSelector: '.sly-old-price',\n\n            // tier prise selectors start\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: '',\n            // tier prise selectors end\n\n            // A price label selector\n            normalPriceLabelSelector: '.product-info-main .normal-price .price-label',\n            qtyInfo: '#qty'\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns int|null\n         */\n        getProduct: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) ? products[0] : null;\n        },\n\n        /**\n         * Get chosen product id\n         *\n         * @returns int|null\n         */\n        getProductId: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) && products.length === 1 ? products[0] : null;\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            // Don't render the same set of swatches twice\n            if ($(this.element).attr('data-rendered')) {\n                return;\n            }\n\n            $(this.element).attr('data-rendered', true);\n\n            if (_.isEmpty(this.options.jsonConfig.images)) {\n                this.options.useAjax = true;\n                // creates debounced variant of _LoadProductMedia()\n                // to use it in events handlers instead of _LoadProductMedia()\n                this._debouncedLoadProductMedia = _.debounce(this._LoadProductMedia.bind(this), 500);\n            }\n\n            this.options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                // store unsorted attributes\n                this.options.jsonConfig.mappedAttributes = _.clone(this.options.jsonConfig.attributes);\n                this._sortAttributes();\n                this._RenderControls();\n                this._setPreSelectedGallery();\n                $(this.element).trigger('swatch.initialized');\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return parseInt(attribute.position, 10);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                productData = this._determineProductData(),\n                $main = productData.isInProductView ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (productData.isInProductView) {\n                gallery.data('gallery') ?\n                    this._onGalleryLoaded(gallery) :\n                    gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n\n            this.productForm = this.element.parents(this.options.selectorProductTile).find('form:first');\n            this.inProductList = this.productForm.length > 0;\n            $(this.options.qtyInfo).on('input', this._onQtyChanged.bind(this));\n        },\n\n        /**\n         * Determine product id and related data\n         *\n         * @returns {{productId: *, isInProductView: bool}}\n         * @private\n         */\n        _determineProductData: function () {\n            // Check if product is in a list of products.\n            var productId,\n                isInProductView = false;\n\n            productId = this.element.parents('.product-item-details')\n                    .find('.price-box.price-final_price').attr('data-product-id');\n\n            if (!productId) {\n                // Check individual product.\n                productId = $('[name=product]').val();\n                isInProductView = productId > 0;\n            }\n\n            return {\n                productId: productId,\n                isInProductView: isInProductView\n            };\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText,\n                showTooltip = this.options.showTooltip;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    controlLabelId = 'option-label-' + item.code + '-' + item.id,\n                    options = $widget._RenderSwatchOptions(item, controlLabelId),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    listLabel = '',\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span id=\"' + controlLabelId + '\" class=\"' + classes.attributeLabelClass + '\">' +\n                        $('<i></i>').text(item.label).html() +\n                        '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.inProductList) {\n                    $widget.productForm.append(input);\n                    input = '';\n                    listLabel = 'aria-label=\"' + $('<i></i>').text(item.label).html() + '\"';\n                } else {\n                    listLabel = 'aria-labelledby=\"' + controlLabelId + '\"';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code + '\" ' +\n                         'data-attribute-code=\"' + item.code + '\" ' +\n                         'data-attribute-id=\"' + item.id + '\">' +\n                        label +\n                        '<div aria-activedescendant=\"\" ' +\n                             'tabindex=\"0\" ' +\n                             'aria-invalid=\"false\" ' +\n                             'aria-required=\"true\" ' +\n                             'role=\"listbox\" ' + listLabel +\n                             'class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: this.products\n                        };\n                    }\n                });\n            });\n\n            if (showTooltip === 1) {\n                // Connect Tooltip\n                container\n                    .find('[data-option-type=\"1\"], [data-option-type=\"2\"],' +\n                        ' [data-option-type=\"0\"], [data-option-type=\"3\"]')\n                    .SwatchRendererTooltip();\n            }\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        disableSwatchForOutOfStockProducts: function () {\n            let $widget = this, container = this.element;\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                let item = this;\n\n                if ($widget.options.jsonConfig.canDisplayShowOutOfStockStatus) {\n                    let salableProducts = $widget.options.jsonConfig.salable[item.id],\n                        swatchOptions = $(container).find(`[data-attribute-id='${item.id}']`).find('.swatch-option');\n\n                    swatchOptions.each(function (key, value) {\n                        let optionId = $(value).data('option-id');\n\n                        if (!salableProducts.hasOwnProperty(optionId)) {\n                            $(value).attr('disabled', true).addClass('disabled');\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @param {String} controlId\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config, controlId) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                sizeConfig = this.options.jsonSwatchImageSizeConfig,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function (index) {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    width,\n                    height,\n                    attr,\n                    swatchImageWidth,\n                    swatchImageHeight;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\"><span>' + moreText + '</span></a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ?\n                    $('<i></i>').text(optionConfig[id].value).html() : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;\n                height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;\n                label = this.label ? $('<i></i>').text(this.label).html() : '';\n                attr =\n                    ' id=\"' + controlId + '-item-' + id + '\"' +\n                    ' index=\"' + index + '\"' +\n                    ' aria-checked=\"false\"' +\n                    ' aria-describedby=\"' + controlId + '\"' +\n                    ' tabindex=\"0\"' +\n                    ' data-option-type=\"' + type + '\"' +\n                    ' data-option-id=\"' + id + '\"' +\n                    ' data-option-label=\"' + label + '\"' +\n                    ' aria-label=\"' + label + '\"' +\n                    ' role=\"option\"' +\n                    ' data-thumb-width=\"' + width + '\"' +\n                    ' data-thumb-height=\"' + height + '\"';\n\n                attr += thumb !== '' ? ' data-option-tooltip-thumb=\"' + thumb + '\"' : '';\n                attr += value !== '' ? ' data-option-tooltip-value=\"' + value + '\"' : '';\n\n                swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;\n                swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        ' style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        ' style=\"background: url(' + value + ') no-repeat center; background-size: initial;width:' +\n                        swatchImageWidth + 'px; height:' + swatchImageHeight + 'px\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Default\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" data-option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" data-option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required: true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"false\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n            var $widget = this,\n                options = this.options.classes,\n                target;\n\n            $widget.element.on('click', '.' + options.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + options.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + options.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n\n            $widget.element.on('keydown', function (e) {\n                if (e.which === 13) {\n                    target = $(e.target);\n\n                    if (target.is('.' + options.optionClass)) {\n                        return $widget._OnClick(target, $widget);\n                    } else if (target.is('.' + options.selectClass)) {\n                        return $widget._OnChange(target, $widget);\n                    } else if (target.is('.' + options.moreButton)) {\n                        e.preventDefault();\n\n                        return $widget._OnMoreClick(target);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Load media gallery using ajax or json config.\n         *\n         * @private\n         */\n        _loadMedia: function () {\n            var $main = this.inProductList ?\n                    this.element.parents('.product-item-info') :\n                    this.element.parents('.column.main'),\n                images;\n\n            if (this.options.useAjax) {\n                this._debouncedLoadProductMedia();\n            }  else {\n                images = this.options.jsonConfig.images[this.getProduct()];\n\n                if (!images) {\n                    images = this.options.mediaGalleryInitial;\n                }\n                this.updateBaseImage(this._sortImages(images), $main, !this.inProductList);\n            }\n        },\n\n        /**\n         * Sorting images array\n         *\n         * @private\n         */\n        _sortImages: function (images) {\n            return _.sortBy(images, function (image) {\n                return parseInt(image.position, 10);\n            });\n        },\n\n        /**\n         * Event for swatch options\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnClick: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                $wrapper = $this.parents('.' + $widget.options.classes.attributeOptionsWrapper),\n                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput),\n                checkAdditionalData = JSON.parse(this.options.jsonSwatchConfig[attributeId]['additional_data']),\n                $priceBox = $widget.element.parents($widget.options.selectorProduct)\n                    .find(this.options.selectorProductPrice);\n\n            if ($widget.inProductList) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.hasClass('disabled')) {\n                return;\n            }\n\n            if ($this.hasClass('selected')) {\n                $parent.removeAttr('data-option-selected').find('.selected').removeClass('selected');\n                $input.val('');\n                $label.text('');\n                $this.attr('aria-checked', false);\n            } else {\n                $parent.attr('data-option-selected', $this.data('option-id')).find('.selected').removeClass('selected');\n                $label.text($this.data('option-label'));\n                $input.val($this.data('option-id'));\n                $input.attr('data-attr-name', this._getAttributeCodeById(attributeId));\n                $this.addClass('selected');\n                $widget._toggleCheckedAttributes($this, $wrapper);\n            }\n\n            $widget._Rebuild();\n\n            if ($priceBox.is(':data(mage-priceBox)')) {\n                $widget._UpdatePrice();\n            }\n\n            $(document).trigger('updateMsrpPriceBlock',\n                [\n                    this._getSelectedOptionPriceIndex(),\n                    $widget.options.jsonConfig.optionPrices,\n                    $priceBox\n                ]);\n\n            if (parseInt(checkAdditionalData['update_product_preview_image'], 10) === 1) {\n                $widget._loadMedia();\n            }\n\n            $input.trigger('change');\n        },\n\n        /**\n         * Get selected option price index\n         *\n         * @return {String|undefined}\n         * @private\n         */\n        _getSelectedOptionPriceIndex: function () {\n            var allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (_.isEmpty(allowedProduct)) {\n                return undefined;\n            }\n\n            return allowedProduct;\n        },\n\n        /**\n         * Get human readable attribute code (eg. size, color) by it ID from configuration\n         *\n         * @param {Number} attributeId\n         * @returns {*}\n         * @private\n         */\n        _getAttributeCodeById: function (attributeId) {\n            var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n            return attribute ? attribute.code : attributeId;\n        },\n\n        /**\n         * Toggle accessibility attributes\n         *\n         * @param {Object} $this\n         * @param {Object} $wrapper\n         * @private\n         */\n        _toggleCheckedAttributes: function ($this, $wrapper) {\n            $wrapper.attr('aria-activedescendant', $this.attr('id'))\n                    .find('.' + this.options.classes.optionClass).attr('aria-checked', false);\n            $this.attr('aria-checked', true);\n        },\n\n        /**\n         * Event for select\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnChange: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput);\n\n            if ($widget.productForm.length > 0) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.val() > 0) {\n                $parent.attr('data-option-selected', $this.val());\n                $input.val($this.val());\n            } else {\n                $parent.removeAttr('data-option-selected');\n                $input.val('');\n            }\n\n            $widget._Rebuild();\n            $widget._UpdatePrice();\n            $widget._loadMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for more switcher\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _OnMoreClick: function ($this) {\n            $this.nextAll().show();\n            $this.trigger('blur').remove();\n        },\n\n        /**\n         * Rewind options for controls\n         *\n         * @private\n         */\n        _Rewind: function (controls) {\n            controls.find('div[data-option-id], option[data-option-id]')\n                .removeClass('disabled')\n                .prop('disabled', false);\n            controls.find('div[data-option-empty], option[data-option-empty]')\n                .attr('disabled', true)\n                .addClass('disabled')\n                .attr('tabindex', '-1');\n            this.disableSwatchForOutOfStockProducts();\n        },\n\n        /**\n         * Rebuild container\n         *\n         * @private\n         */\n        _Rebuild: function () {\n            var $widget = this,\n                controls = $widget.element.find('.' + $widget.options.classes.attributeClass + '[data-attribute-id]'),\n                selected = controls.filter('[data-option-selected]');\n\n            // Enable all options\n            $widget._Rewind(controls);\n\n            // done if nothing selected\n            if (selected.length <= 0) {\n                return;\n            }\n\n            // Disable not available options\n            controls.each(function () {\n                var $this = $(this),\n                    id = $this.data('attribute-id'),\n                    products = $widget._CalcProducts(id);\n\n                if (selected.length === 1 && selected.first().data('attribute-id') === id) {\n                    return;\n                }\n\n                $this.find('[data-option-id]').each(function () {\n                    var $element = $(this),\n                        option = $element.data('option-id');\n\n                    if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option) ||\n                        $element.hasClass('selected') ||\n                        $element.is(':selected')) {\n                        return;\n                    }\n\n                    if (_.intersection(products, $widget.optionsMap[id][option].products).length <= 0) {\n                        $element.attr('disabled', true).addClass('disabled');\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get selected product list\n         *\n         * @returns {Array}\n         * @private\n         */\n        _CalcProducts: function ($skipAttributeId) {\n            var $widget = this,\n                selectedOptions = '.' + $widget.options.classes.attributeClass + '[data-option-selected]',\n                products = [];\n\n            // Generate intersection of products\n            $widget.element.find(selectedOptions).each(function () {\n                var id = $(this).data('attribute-id'),\n                    option = $(this).attr('data-option-selected');\n\n                if ($skipAttributeId !== undefined && $skipAttributeId === id) {\n                    return;\n                }\n\n                if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option)) {\n                    return;\n                }\n\n                if (products.length === 0) {\n                    products = $widget.optionsMap[id][option].products;\n                } else {\n                    products = _.intersection(products, $widget.optionsMap[id][option].products);\n                }\n            });\n\n            return products;\n        },\n\n        /**\n         * Update total price\n         *\n         * @private\n         */\n        _UpdatePrice: function () {\n            var $widget = this,\n                $product = $widget.element.parents($widget.options.selectorProduct),\n                $productPrice = $product.find(this.options.selectorProductPrice),\n                result = $widget._getNewPrices(),\n                tierPriceHtml,\n                isShow;\n\n            $productPrice.trigger(\n                'updatePrice',\n                {\n                    'prices': $widget._getPrices(result, $productPrice.priceBox('option').prices)\n                }\n            );\n\n            isShow = typeof result != 'undefined' && result.oldPrice.amount !== result.finalPrice.amount;\n\n            $productPrice.find('span:first').toggleClass('special-price', isShow);\n\n            $product.find(this.options.slyOldPriceSelector)[isShow ? 'show' : 'hide']();\n\n            if (typeof result != 'undefined' && result.tierPrices && result.tierPrices.length) {\n                if (this.options.tierPriceTemplate) {\n                    tierPriceHtml = mageTemplate(\n                        this.options.tierPriceTemplate,\n                        {\n                            'tierPrices': result.tierPrices,\n                            '$t': $t,\n                            'currencyFormat': this.options.jsonConfig.currencyFormat,\n                            'priceUtils': priceUtils\n                        }\n                    );\n                    $(this.options.tierPriceBlockSelector).html(tierPriceHtml).show();\n                }\n            } else {\n                $(this.options.tierPriceBlockSelector).hide();\n            }\n\n            $(this.options.normalPriceLabelSelector).hide();\n\n            _.each($('.' + this.options.classes.attributeOptionsWrapper), function (attribute) {\n                if ($(attribute).find('.' + this.options.classes.optionClass + '.selected').length === 0) {\n                    if ($(attribute).find('.' + this.options.classes.selectClass).length > 0) {\n                        _.each($(attribute).find('.' + this.options.classes.selectClass), function (dropdown) {\n                            if ($(dropdown).val() === '0') {\n                                $(this.options.normalPriceLabelSelector).show();\n                            }\n                        }.bind(this));\n                    } else {\n                        $(this.options.normalPriceLabelSelector).show();\n                    }\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Get new prices for selected options\n         *\n         * @returns {*}\n         * @private\n         */\n        _getNewPrices: function () {\n            var $widget = this,\n                newPrices = $widget.options.jsonConfig.prices,\n                allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (!_.isEmpty(allowedProduct)) {\n                newPrices = this.options.jsonConfig.optionPrices[allowedProduct];\n            }\n\n            return newPrices;\n        },\n\n        /**\n         * Get prices\n         *\n         * @param {Object} newPrices\n         * @param {Object} displayPrices\n         * @returns {*}\n         * @private\n         */\n        _getPrices: function (newPrices, displayPrices) {\n            var $widget = this;\n\n            if (_.isEmpty(newPrices)) {\n                newPrices = $widget._getNewPrices();\n            }\n            _.each(displayPrices, function (price, code) {\n\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Get product with minimum price from selected options.\n         *\n         * @param {Array} allowedProducts\n         * @returns {String}\n         * @private\n         */\n        _getAllowedProductWithMinPrice: function (allowedProducts) {\n            var optionPrices = this.options.jsonConfig.optionPrices,\n                product = {},\n                optionFinalPrice, optionMinPrice;\n\n            _.each(allowedProducts, function (allowedProduct) {\n                optionFinalPrice = parseFloat(optionPrices[allowedProduct].finalPrice.amount);\n\n                if (_.isEmpty(product) || optionFinalPrice < optionMinPrice) {\n                    optionMinPrice = optionFinalPrice;\n                    product = allowedProduct;\n                }\n            }, this);\n\n            return product;\n        },\n\n        /**\n         * Gets all product media and change current to the needed one\n         *\n         * @private\n         */\n        _LoadProductMedia: function () {\n            var $widget = this,\n                $this = $widget.element,\n                productData = this._determineProductData(),\n                mediaCallData,\n                mediaCacheKey,\n\n                /**\n                 * Processes product media data\n                 *\n                 * @param {Object} data\n                 * @returns void\n                 */\n                mediaSuccessCallback = function (data) {\n                    if (!(mediaCacheKey in $widget.options.mediaCache)) {\n                        $widget.options.mediaCache[mediaCacheKey] = data;\n                    }\n                    $widget._ProductMediaCallback($this, data, productData.isInProductView);\n                    setTimeout(function () {\n                        $widget._DisableProductMediaLoader($this);\n                    }, 300);\n                };\n\n            if (!$widget.options.mediaCallback) {\n                return;\n            }\n\n            mediaCallData = {\n                'product_id': this.getProduct()\n            };\n\n            mediaCacheKey = JSON.stringify(mediaCallData);\n\n            if (mediaCacheKey in $widget.options.mediaCache) {\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                mediaSuccessCallback($widget.options.mediaCache[mediaCacheKey]);\n            } else {\n                mediaCallData.isAjax = true;\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                $widget.xhr = $.ajax({\n                    url: $widget.options.mediaCallback,\n                    cache: true,\n                    type: 'GET',\n                    dataType: 'json',\n                    data: mediaCallData,\n                    success: mediaSuccessCallback\n                }).done(function () {\n                    $widget._XhrKiller();\n                });\n            }\n        },\n\n        /**\n         * Enable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _EnableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .addClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .addClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Disable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _DisableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .removeClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .removeClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Callback for product media\n         *\n         * @param {Object} $this\n         * @param {String} response\n         * @param {Boolean} isInProductView\n         * @private\n         */\n        _ProductMediaCallback: function ($this, response, isInProductView) {\n            var $main = isInProductView ? $this.parents('.column.main') : $this.parents('.product-item-info'),\n                $widget = this,\n                images = [],\n\n                /**\n                 * Check whether object supported or not\n                 *\n                 * @param {Object} e\n                 * @returns {*|Boolean}\n                 */\n                support = function (e) {\n                    return e.hasOwnProperty('large') && e.hasOwnProperty('medium') && e.hasOwnProperty('small');\n                };\n\n            if (_.size($widget) < 1 || !support(response)) {\n                this.updateBaseImage(this.options.mediaGalleryInitial, $main, isInProductView);\n\n                return;\n            }\n\n            images.push({\n                full: response.large,\n                img: response.medium,\n                thumb: response.small,\n                isMain: true\n            });\n\n            if (response.hasOwnProperty('gallery')) {\n                $.each(response.gallery, function () {\n                    if (!support(this) || response.large === this.large) {\n                        return;\n                    }\n                    images.push({\n                        full: this.large,\n                        img: this.medium,\n                        thumb: this.small\n                    });\n                });\n            }\n\n            this.updateBaseImage(images, $main, isInProductView);\n        },\n\n        /**\n         * Check if images to update are initial and set their type\n         * @param {Array} images\n         */\n        _setImageType: function (images) {\n\n            images.map(function (img) {\n                if (!img.type) {\n                    img.type = 'image';\n                }\n            });\n\n            return images;\n        },\n\n        /**\n         * Update [gallery-placeholder] or [product-image-photo]\n         * @param {Array} images\n         * @param {jQuery} context\n         * @param {Boolean} isInProductView\n         */\n        updateBaseImage: function (images, context, isInProductView) {\n            var justAnImage = images[0],\n                initialImages = this.options.mediaGalleryInitial,\n                imagesToUpdate,\n                gallery = context.find(this.options.mediaGallerySelector).data('gallery'),\n                isInitial;\n\n            if (isInProductView) {\n                if (_.isUndefined(gallery)) {\n                    context.find(this.options.mediaGallerySelector).on('gallery:loaded', function () {\n                        this.updateBaseImage(images, context, isInProductView);\n                    }.bind(this));\n\n                    return;\n                }\n\n                imagesToUpdate = images.length ? this._setImageType($.extend(true, [], images)) : [];\n                isInitial = _.isEqual(imagesToUpdate, initialImages);\n\n                if (this.options.gallerySwitchStrategy === 'prepend' && !isInitial) {\n                    imagesToUpdate = imagesToUpdate.concat(initialImages);\n                }\n\n                imagesToUpdate = this._setImageIndex(imagesToUpdate);\n\n                gallery.updateData(imagesToUpdate);\n                this._addFotoramaVideoEvents(isInitial);\n            } else if (justAnImage && justAnImage.img) {\n                context.find('.product-image-photo').attr('src', justAnImage.img);\n            }\n        },\n\n        /**\n         * Add video events\n         *\n         * @param {Boolean} isInitial\n         * @private\n         */\n        _addFotoramaVideoEvents: function (isInitial) {\n            if (_.isUndefined($.mage.AddFotoramaVideoEvents)) {\n                return;\n            }\n\n            if (isInitial) {\n                $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n\n                return;\n            }\n\n            $(this.options.mediaGallerySelector).AddFotoramaVideoEvents({\n                selectedOption: this.getProduct(),\n                dataMergeStrategy: this.options.gallerySwitchStrategy\n            });\n        },\n\n        /**\n         * Set correct indexes for image set.\n         *\n         * @param {Array} images\n         * @private\n         */\n        _setImageIndex: function (images) {\n            var length = images.length,\n                i;\n\n            for (i = 0; length > i; i++) {\n                images[i].i = i + 1;\n            }\n\n            return images;\n        },\n\n        /**\n         * Kill doubled AJAX requests\n         *\n         * @private\n         */\n        _XhrKiller: function () {\n            var $widget = this;\n\n            if ($widget.xhr !== undefined && $widget.xhr !== null) {\n                $widget.xhr.abort();\n                $widget.xhr = null;\n            }\n        },\n\n        /**\n         * Emulate mouse click on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelected: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeCode, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-code=\"' + attributeCode + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Emulate mouse click or selection change on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelectedByAttributeId: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeId, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-id=\"' + attributeId + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Get default options values settings with either URL query parameters\n         * @private\n         */\n        _getSelectedAttributes: function () {\n            var hashIndex = window.location.href.indexOf('#'),\n                selectedAttributes = {},\n                params;\n\n            if (hashIndex !== -1) {\n                params = $.parseQuery(window.location.href.substr(hashIndex + 1));\n\n                selectedAttributes = _.invert(_.mapObject(_.invert(params), function (attributeId) {\n                    var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n                    return attribute ? attribute.code : attributeId;\n                }.bind(this)));\n            }\n\n            return selectedAttributes;\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         *\n         * @param {HTMLElement} element - DOM element associated with a gallery.\n         */\n        _onGalleryLoaded: function (element) {\n            var galleryObject = element.data('gallery');\n\n            this.options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n        },\n\n        /**\n         * Sets mediaCache for cases when jsonConfig contains preSelectedGallery on layered navigation result pages\n         *\n         * @private\n         */\n        _setPreSelectedGallery: function () {\n            var mediaCallData;\n\n            if (this.options.jsonConfig.preSelectedGallery) {\n                mediaCallData = {\n                    'product_id': this.getProduct()\n                };\n\n                this.options.mediaCache[JSON.stringify(mediaCallData)] = this.options.jsonConfig.preSelectedGallery;\n            }\n        },\n\n        /**\n         * Callback for quantity change event.\n         */\n        _onQtyChanged: function () {\n            var $price = this.element.parents(this.options.selectorProduct)\n                .find(this.options.selectorProductPrice);\n\n            $price.trigger(\n                'updatePrice',\n                {\n                    'prices': this._getPrices(this._getNewPrices(), $price.priceBox('option').prices)\n                }\n            );\n        }\n    });\n\n    return $.mage.SwatchRenderer;\n});\n","Magento_Swatches/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Add selected swatch attributes to redirect url\n     *\n     * @see Magento_Catalog/js/catalog-add-to-cart\n     */\n    $('body').on('catalogCategoryAddToCartRedirect', function (event, data) {\n        $(data.form).find('[name*=\"super\"]').each(function (index, item) {\n            var $item = $(item),\n                attr;\n\n            if ($item.attr('data-attr-name')) {\n                attr = $item.attr('data-attr-name');\n            } else {\n                attr = $item.parent().attr('attribute-code');\n            }\n            data.redirectParameters.push(attr + '=' + $item.val());\n\n        });\n    });\n});\n","Magento_Security/js/escaper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * A loose JavaScript version of Magento\\Framework\\Escaper\n *\n * Due to differences in how XML/HTML is processed in PHP vs JS there are a couple of minor differences in behavior\n * from the PHP counterpart.\n *\n * The first difference is that the default invocation of escapeHtml without allowedTags will double-escape existing\n * entities as the intention of such an invocation is that the input isn't supposed to contain any HTML.\n *\n * The second difference is that escapeHtml will not escape quotes. Since the input is actually being processed by the\n * DOM there is no chance of quotes being mixed with HTML syntax. And, since escapeHtml is not\n * intended to be used with raw injection into a HTML attribute, this is acceptable.\n *\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        neverAllowedElements: ['script', 'img', 'embed', 'iframe', 'video', 'source', 'object', 'audio'],\n        generallyAllowedAttributes: ['id', 'class', 'href', 'title', 'style'],\n        forbiddenAttributesByElement: {\n            a: ['style']\n        },\n\n        /**\n         * Escape a string for safe injection into HTML\n         *\n         * @param {String} data\n         * @param {Array|null} allowedTags\n         * @returns {String}\n         */\n        escapeHtml: function (data, allowedTags) {\n            var domParser = new DOMParser(),\n                fragment = domParser.parseFromString('<div></div>', 'text/html');\n\n            fragment = fragment.body.childNodes[0];\n            allowedTags = typeof allowedTags === 'object' && allowedTags.length ? allowedTags : null;\n\n            if (allowedTags) {\n                fragment.innerHTML = data || '';\n                allowedTags = this._filterProhibitedTags(allowedTags);\n\n                this._removeComments(fragment);\n                this._removeNotAllowedElements(fragment, allowedTags);\n                this._removeNotAllowedAttributes(fragment);\n\n                return fragment.innerHTML;\n            }\n\n            fragment.textContent = data || '';\n\n            return fragment.innerHTML;\n        },\n\n        /**\n         * Remove the always forbidden tags from a list of provided tags\n         *\n         * @param {Array} tags\n         * @returns {Array}\n         * @private\n         */\n        _filterProhibitedTags: function (tags) {\n            return tags.filter(function (n) {\n                return this.neverAllowedElements.indexOf(n) === -1;\n            }.bind(this));\n        },\n\n        /**\n         * Remove comment nodes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeComments: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_COMMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                    false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                nodesToRemove.push(treeWalker.currentNode);\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.removeChild(nodeToRemove);\n            });\n        },\n\n        /**\n         * Strip the given node of all disallowed tags while permitting any nested text nodes\n         *\n         * @param {Node} node\n         * @param {Array|null} allowedTags\n         * @private\n         */\n        _removeNotAllowedElements: function (node, allowedTags) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function (currentNode) {\n                        return allowedTags.indexOf(currentNode.nodeName.toLowerCase()) === -1 ?\n                            NodeFilter.FILTER_ACCEPT\n                            // SKIP instead of REJECT because REJECT also rejects child nodes\n                            : NodeFilter.FILTER_SKIP;\n                    },\n                false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                if (allowedTags.indexOf(treeWalker.currentNode.nodeName.toLowerCase()) === -1) {\n                    nodesToRemove.push(treeWalker.currentNode);\n                }\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.replaceChild(\n                    node.ownerDocument.createTextNode(nodeToRemove.textContent),\n                    nodeToRemove\n                );\n            });\n        },\n\n        /**\n         * Remove any invalid attributes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeNotAllowedAttributes: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                false\n                ),\n                i,\n                attribute,\n                nodeName,\n                attributesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                for (i = 0; i < treeWalker.currentNode.attributes.length; i++) {\n                    attribute = treeWalker.currentNode.attributes[i];\n                    nodeName = treeWalker.currentNode.nodeName.toLowerCase();\n\n                    if (this.generallyAllowedAttributes.indexOf(attribute.name) === -1  || // eslint-disable-line max-depth,max-len\n                        this._checkHrefValue(attribute) ||\n                        this.forbiddenAttributesByElement[nodeName] &&\n                        this.forbiddenAttributesByElement[nodeName].indexOf(attribute.name) !== -1\n                    ) {\n                        attributesToRemove.push(attribute);\n                    }\n                }\n            }\n\n            attributesToRemove.forEach(function (attributeToRemove) {\n                attributeToRemove.ownerElement.removeAttribute(attributeToRemove.name);\n            });\n        },\n\n        /**\n         * Check that attribute contains script content\n         *\n         * @param {Object} attribute\n         * @private\n         */\n        _checkHrefValue: function (attribute) {\n            return attribute.nodeName === 'href' && attribute.nodeValue.startsWith('javascript');\n        }\n    };\n});\n","Magento_InstantPurchase/js/view/instant-purchase.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'mage/url',\n    'mage/template',\n    'mage/translate',\n    'text!Magento_InstantPurchase/template/confirmation.html',\n    'mage/validation'\n], function (ko, $, _, Component, confirm, customerData, urlBuilder, mageTemplate, $t, confirmationTemplate) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_InstantPurchase/instant-purchase',\n            buttonText: $t('Instant Purchase'),\n            purchaseUrl: urlBuilder.build('instantpurchase/button/placeOrder'),\n            showButton: false,\n            paymentToken: null,\n            shippingAddress: null,\n            billingAddress: null,\n            shippingMethod: null,\n            productFormSelector: '#product_addtocart_form',\n            confirmationTitle: $t('Instant Purchase Confirmation'),\n            confirmationData: {\n                message: $t('Are you sure you want to place order and pay?'),\n                shippingAddressTitle: $t('Shipping Address'),\n                billingAddressTitle: $t('Billing Address'),\n                paymentMethodTitle: $t('Payment Method'),\n                shippingMethodTitle: $t('Shipping Method')\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var instantPurchase = customerData.get('instant-purchase');\n\n            this._super();\n\n            this.setPurchaseData(instantPurchase());\n            instantPurchase.subscribe(this.setPurchaseData, this);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('showButton paymentToken shippingAddress billingAddress shippingMethod');\n\n            return this;\n        },\n\n        /**\n         * Set data from customerData.\n         *\n         * @param {Object} data\n         */\n        setPurchaseData: function (data) {\n            this.showButton(data.available);\n            this.paymentToken(data.paymentToken);\n            this.shippingAddress(data.shippingAddress);\n            this.billingAddress(data.billingAddress);\n            this.shippingMethod(data.shippingMethod);\n        },\n\n        /**\n         * Confirmation method\n         */\n        instantPurchase: function () {\n            var form = $(this.productFormSelector),\n                confirmTemplate = mageTemplate(confirmationTemplate),\n                confirmData = _.extend({}, this.confirmationData, {\n                    paymentToken: this.paymentToken().summary,\n                    shippingAddress: this.shippingAddress().summary,\n                    billingAddress: this.billingAddress().summary,\n                    shippingMethod: this.shippingMethod().summary\n                });\n\n            if (!(form.validation() && form.validation('isValid'))) {\n                return;\n            }\n\n            confirm({\n                title: this.confirmationTitle,\n                content: confirmTemplate({\n                    data: confirmData\n                }),\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        $.ajax({\n                            url: this.purchaseUrl,\n                            data: form.serialize(),\n                            type: 'post',\n                            dataType: 'json',\n\n                            /** Show loader before send */\n                            beforeSend: function () {\n                                $('body').trigger('processStart');\n                            }\n                        }).always(function () {\n                            $('body').trigger('processStop');\n                        });\n                    }.bind(this)\n                }\n            });\n        }\n    });\n});\n","Mageplaza_Smtp/js/view/shipping-mixins.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_StoreLocator\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'Magento_Ui/js/form/form',\n        'ko',\n        'Magento_Customer/js/model/customer',\n        'Magento_Customer/js/model/address-list',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/action/create-shipping-address',\n        'Magento_Checkout/js/action/select-shipping-address',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-address/form-popup-state',\n        'Magento_Checkout/js/model/shipping-service',\n        'Magento_Checkout/js/action/select-shipping-method',\n        'Magento_Checkout/js/model/shipping-rate-registry',\n        'Magento_Checkout/js/action/set-shipping-information',\n        'Magento_Checkout/js/model/step-navigator',\n        'Magento_Ui/js/modal/modal',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'Magento_Checkout/js/checkout-data',\n        'uiRegistry',\n        'mage/translate',\n        'Magento_Checkout/js/model/shipping-rate-service',\n        'Mageplaza_Smtp/js/model/address-on-change'\n    ],\n    function (\n        $,\n        _,\n        Component,\n        ko,\n        customer,\n        addressList,\n        addressConverter,\n        quote,\n        createShippingAddress,\n        selectShippingAddress,\n        shippingRatesValidator,\n        formPopUpState,\n        shippingService,\n        selectShippingMethodAction,\n        rateRegistry,\n        setShippingInformationAction,\n        stepNavigator,\n        modal,\n        checkoutDataResolver,\n        checkoutData,\n        registry,\n        $t,\n        shippingRateService,\n        shippingAddressOnChange\n    ) {\n        'use strict';\n\n        var mixin = {\n\n            initialize: function () {\n                var fieldsetName = 'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset';\n\n                this._super();\n\n                shippingAddressOnChange.initFields(fieldsetName);\n            }\n        };\n\n        return function (target) {\n            return target.extend(mixin);\n        };\n    }\n);\n","Mageplaza_Smtp/js/view/billing-address-mixins.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_StoreLocator\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine(\n    [\n        'jquery',\n        'ko',\n        'underscore',\n        'Magento_Ui/js/form/form',\n        'Magento_Customer/js/model/customer',\n        'Magento_Customer/js/model/address-list',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/action/create-billing-address',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'Magento_Customer/js/customer-data',\n        'Magento_Checkout/js/action/set-billing-address',\n        'Magento_Ui/js/model/messageList',\n        'mage/translate',\n        'Magento_Checkout/js/model/billing-address-postcode-validator',\n        'Mageplaza_Smtp/js/model/address-on-change'\n    ],\n    function (\n        $,\n        ko,\n        _,\n        Component,\n        customer,\n        addressList,\n        quote,\n        createBillingAddress,\n        selectBillingAddress,\n        checkoutData,\n        checkoutDataResolver,\n        customerData,\n        setBillingAddressAction,\n        globalMessageList,\n        $t,\n        billingAddressPostcodeValidator,\n        billingAddressOnChange\n    ) {\n        'use strict';\n\n        var mixin = {\n            initialize: function () {\n                var fieldset;\n\n                this._super();\n\n                if (window.checkoutConfig.oscConfig) {\n                    fieldset = this.get('name') + '.billing-address-fieldset';\n                } else {\n                    fieldset = this.get('name') + '.form-fields';\n                }\n\n                billingAddressOnChange.initFields(fieldset);\n            },\n        };\n\n        return function (target) {\n            return target.extend(mixin);\n        };\n    }\n);\n","Mageplaza_Smtp/js/action/send-address.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Smtp\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'mage/storage',\n    'Mageplaza_Smtp/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote'\n], function (storage, resourceUrlManager, quote) {\n    'use strict';\n\n    return function (address, isOsc) {\n        return storage.post(\n            resourceUrlManager.getUrlForUpdateOrder(quote),\n            JSON.stringify({\n                address: address,\n                isOsc: isOsc\n            }),\n            false\n        );\n    };\n});\n","Mageplaza_Smtp/js/model/resource-url-manager.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Smtp\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/resource-url-manager'\n    ],\n    function ($, resourceUrlManager) {\n        \"use strict\";\n\n        return $.extend({\n            /** Get url for send the address to update order */\n            getUrlForUpdateOrder: function (quote) {\n                var params = {cartId: quote.getQuoteId()};\n                var urls   = {\n                    'default': '/carts/:cartId/update-order'\n                };\n\n                return this.getUrl(urls, params);\n            }\n        }, resourceUrlManager);\n    }\n);\n","Mageplaza_Smtp/js/model/address-on-change.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    'mage/translate',\n    'uiRegistry',\n    'Magento_Checkout/js/model/quote',\n    'Mageplaza_Smtp/js/action/send-address'\n], function (\n    $,\n    ko,\n    $t,\n    uiRegistry,\n    quote,\n    sendAddress\n) {\n    'use strict';\n\n    var elements         = ['firstname', 'lastname', 'company', 'street', 'country_id', 'region_id', 'city', 'postcode', 'telephone'],\n        observedElements = [];\n\n    return {\n        validateAddressTimeout: 0,\n        validateDelay: 1000,\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this;\n\n            $.each(elements, function (index, field) {\n                uiRegistry.async(formPath + '.' + field)(self.smtpBindHandler.bind(self));\n            });\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        smtpBindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            if (element.component.indexOf('/group') !== -1) {\n                $.each(element.elems(), function (index, elem) {\n                    uiRegistry.async(elem.name)(function () {\n                        self.smtpBindHandler(elem);\n                    });\n                });\n            } else if (element && element.hasOwnProperty('value')) {\n                element.on('value', function () {\n                    clearTimeout(self.validateAddressTimeout);\n                    self.validateAddressTimeout = setTimeout(function () {\n                        sendAddress(JSON.stringify(self.collectObservedData()), self.isOsc());\n                    }, delay);\n                });\n\n                observedElements.push(element);\n            }\n        },\n        /**\n         * Collect observed fields data to object\n         *\n         * @returns {*}\n         */\n        collectObservedData: function () {\n            var observedValues = {};\n\n            $.each(observedElements, function (index, field) {\n                var value = field.value();\n\n                if ($.type(value) === 'undefined') {\n                    value = '';\n                }\n                observedValues[field.dataScope] = value;\n            });\n\n            return observedValues;\n        },\n        isOsc: function () {\n            return !!window.checkoutConfig.oscConfig;\n        }\n    };\n});\n","Magento_Theme/js/cookie-status.js":"define([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal) {\n    'use strict';\n\n    $.widget('mage.cookieStatus', {\n        options: {\n            type: 'popup',\n            responsive: true,\n            innerScroll: true,\n            autoOpen: true,\n            buttons: [{\n                text: $.mage.__('Close'),\n                class: 'cookie-status',\n\n                /**\n                 * Callback for click event\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }]\n        },\n\n        /**\n         * Init object\n         * @private\n         */\n        _init: function () {\n\n            if (!navigator.cookieEnabled) {\n                modal(this.options, $('#cookie-status'));\n            }\n        }\n    });\n\n    return $.mage.cookieStatus;\n});\n","Magento_Theme/js/row-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.rowBuilder'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.rowBuilder', {\n\n        /**\n         * options with default values for setting up the template\n         */\n        options: {\n            //Default template options\n            rowTemplate: '#template-registrant',\n            rowContainer: '#registrant-container',\n            //Row index used by the template rows.\n            rowIndex: 0,\n            //Row count: Should not be set externally\n            rowCount: 0,\n            rowParentElem: '<li></li>',\n            rowContainerClass: 'fields',\n            addRowBtn: '#add-registrant-button',\n            btnRemoveIdPrefix: 'btn-remove',\n            btnRemoveSelector: '.btn-remove',\n            rowIdPrefix: 'row',\n            //This class is added to rows added after the first one. Adds the dotted separator\n            additionalRowClass: 'add-row',\n\n            /*\n             This is provided during widget instantiation. eg :\n             formDataPost : {\"formData\":formData,\"templateFields\":['field1-name','field2-name'] }\n             -\"formData\" is the multi-dimensional array of form field values : [['a','b'],['c','b']]\n             received from the server and encoded\n             -\"templateFields\" are the input fields in the template with index suffixed after the field name\n             eg field1-name{index}\n             */\n            formDataPost: null,\n            //Default selectors for add element of a template\n            addEventSelector: 'button',\n            //Default selectors for remove markup elements of a template\n            remEventSelector: 'a',\n            //This option allows adding first row delete option and a row separator\n            hideFirstRowAddSeparator: true,\n            //Max rows - This option should be set when instantiating the widget\n            maxRows: 1000,\n            maxRowsMsg: '#max-registrant-message'\n        },\n\n        /**\n         * Initialize create\n         * @private\n         */\n        _create: function () {\n            this.rowTemplate = mageTemplate(this.options.rowTemplate);\n\n            this.options.rowCount = this.options.rowIndex = 0;\n\n            //On document ready related tasks\n            $($.proxy(this.ready, this));\n\n            //Binding template-wide events handlers for adding and removing rows\n            this.element.on(\n                'click',\n                this.options.addEventSelector + this.options.addRowBtn,\n                $.proxy(this.handleAdd, this)\n            );\n            this.element.on(\n                'click',\n                this.options.remEventSelector + this.options.btnRemoveSelector,\n                $.proxy(this.handleRemove, this)\n            );\n        },\n\n        /**\n         * Initialize template\n         * @public\n         */\n        ready: function () {\n            if (this.options.formDataPost &&\n                this.options.formDataPost.formData &&\n                this.options.formDataPost.formData.length\n            ) {\n                this.processFormDataArr(this.options.formDataPost);\n            } else if (this.options.rowIndex === 0 && this.options.maxRows !== 0) {\n                //If no form data , then add default row\n                this.addRow(0);\n            }\n        },\n\n        /**\n         * Process and loop through all row data to create preselected values. This is used for any error on submit.\n         * For complex implementations the inheriting widget can override this behavior\n         * @public\n         * @param {Object} formDataArr\n         */\n        processFormDataArr: function (formDataArr) {\n            var formData = formDataArr.formData,\n                templateFields = formDataArr.templateFields,\n                formRow,\n                i, j;\n\n            for (i = this.options.rowIndex = 0; i < formData.length; this.options.rowIndex = i++) {\n                this.addRow(i);\n\n                formRow = formData[i];\n\n                for (j = 0; j < formRow.length; j++) {\n                    this.setFieldById(templateFields[j] + i, formRow[j]);\n                }\n            }\n\n        },\n\n        /**\n         * Initialize and create markup for template row. Add it to the parent container.\n         * The template processing will substitute row index at all places marked with _index_ in the template\n         * using the template\n         * @public\n         * @param {Number} index - current index/count of the created template. This will be used as the id\n         * @return {*}\n         */\n        addRow: function (index) {\n            var row = $(this.options.rowParentElem),\n                tmpl;\n\n            row.addClass(this.options.rowContainerClass).attr('id', this.options.rowIdPrefix + index);\n\n            tmpl = this.rowTemplate({\n                data: {\n                    _index_: index\n                }\n            });\n\n            $(tmpl).appendTo(row);\n\n            $(this.options.rowContainer).append(row).trigger('contentUpdated');\n\n            row.addClass(this.options.additionalRowClass);\n\n            //Remove 'delete' link and additionalRowClass for first row\n            if (this.options.rowIndex === 0 && this.options.hideFirstRowAddSeparator) {\n                $('#' + this._esc(this.options.btnRemoveIdPrefix) + '0').remove();\n                $('#' + this._esc(this.options.rowIdPrefix) + '0').removeClass(this.options.additionalRowClass);\n            }\n\n            this.maxRowCheck(++this.options.rowCount);\n\n            return row;\n        },\n\n        /**\n         * Remove return item information row\n         * @public\n         * @param {*} rowIndex - return item information row index\n         * @return {Boolean}\n         */\n        removeRow: function (rowIndex) {\n            $('#' + this._esc(this.options.rowIdPrefix) + rowIndex).remove();\n            this.maxRowCheck(--this.options.rowCount);\n\n            return false;\n        },\n\n        /**\n         * Function to check if maximum rows are exceeded and render/hide maxMsg and Add btn\n         * @public\n         * @param {Number} rowIndex\n         */\n        maxRowCheck: function (rowIndex) {\n            var addRowBtn = $(this.options.addRowBtn),\n                maxRowMsg = $(this.options.maxRowsMsg);\n\n            //liIndex starts from 0\n            if (rowIndex >= this.options.maxRows) {\n                addRowBtn.hide();\n                maxRowMsg.show();\n            } else if (addRowBtn.is(':hidden')) {\n                addRowBtn.show();\n                maxRowMsg.hide();\n            }\n        },\n\n        /**\n         * Set the value on given element\n         * @public\n         * @param {String} domId\n         * @param {String} value\n         */\n        setFieldById: function (domId, value) {\n            var x = $('#' + this._esc(domId));\n\n            if (x.length) {\n\n                if (x.is(':checkbox')) {\n                    x.attr('checked', true);\n                } else if (x.is('option')) {\n                    x.attr('selected', 'selected');\n                } else {\n                    x.val(value);\n                }\n            }\n        },\n\n        /**\n         * Delegated handler for adding a row\n         * @public\n         * @return {Boolean}\n         */\n        handleAdd: function () {\n            this.addRow(++this.options.rowIndex);\n\n            return false;\n        },\n\n        /**\n         * Delegated handler for removing a selected row\n         * @public\n         * @param {Object} e - Native event object\n         * @return {Boolean}\n         */\n        handleRemove: function (e) {\n            this.removeRow($(e.currentTarget).closest('[id^=\"' + this.options.btnRemoveIdPrefix + '\"]')\n                .attr('id').replace(this.options.btnRemoveIdPrefix, ''));\n\n            return false;\n        },\n\n        /**\n         * Utility function to add escape chars for jquery selector strings\n         * @private\n         * @param {String} str - String to be processed\n         * @return {String}\n         */\n        _esc: function (str) {\n            return str ? str.replace(/([ ;&,.+*~\\':\"!\\^$\\[\\]()=>|\\/@])/g, '\\\\$1') : str;\n        }\n    });\n\n    return $.mage.rowBuilder;\n});\n","Magento_Theme/js/theme.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'mage/mage',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    $('.cart-summary').mage('sticky', {\n        container: '#maincontent'\n    });\n\n    $('.panel.header > .header.links').clone().appendTo('#store\\\\.links');\n    $('#store\\\\.links li a').each(function () {\n        var id = $(this).attr('id');\n\n        if (id !== undefined) {\n            $(this).attr('id', id + '_mobile');\n        }\n    });\n    keyboardHandler.apply();\n});\n","Magento_Theme/js/view/breadcrumbs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Theme/js/model/breadcrumb-list',\n    'text!Magento_Theme/templates/breadcrumbs.html',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate, breadcrumbList, tpl) {\n    'use strict';\n\n    /**\n     * Breadcrumb Widget.\n     */\n    $.widget('mage.breadcrumbs', {\n\n        /** @inheritdoc */\n        _init: function () {\n            this._super();\n            this._render();\n        },\n\n        /**\n         * Render breadcrumb.\n         *\n         * @private\n         */\n        _render: function () {\n            var html,\n                crumbs = breadcrumbList,\n                template = mageTemplate(tpl);\n\n            this._decorate(crumbs);\n\n            html = template({\n                'breadcrumbs': crumbs\n            });\n\n            if (html.length) {\n                $(this.element).html(html);\n            }\n        },\n\n        /**\n         * Decorate list.\n         *\n         * @param {Array} list\n         * @private\n         */\n        _decorate: function (list) {\n\n            if (list.length) {\n                list[0].first = true;\n            }\n\n            if (list.length > 1) {\n                list[list.length - 1].last = true;\n            }\n        }\n    });\n\n    return $.mage.breadcrumbs;\n});\n","Magento_Theme/js/view/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'underscore',\n    'escaper',\n    'jquery/jquery-storageapi'\n], function ($, Component, customerData, _, escaper) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            cookieMessages: [],\n            messages: [],\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Extends Component object by storage observable messages.\n         */\n        initialize: function () {\n            this._super();\n\n            this.cookieMessages = _.unique($.cookieStorage.get('mage-messages'), 'text');\n            this.messages = customerData.get('messages').extend({\n                disposableCustomerData: 'messages'\n            });\n\n            // Force to clean obsolete messages\n            if (!_.isEmpty(this.messages().messages)) {\n                customerData.set('messages', {});\n            }\n\n            $.mage.cookies.set('mage-messages', '', {\n                samesite: 'strict',\n                domain: ''\n            });\n        },\n\n        /**\n         * Prepare the given message to be rendered as HTML\n         *\n         * @param {String} message\n         * @return {String}\n         */\n        prepareMessageForHtml: function (message) {\n            return escaper.escapeHtml(message, this.allowedTags);\n        }\n    });\n});\n","Magento_Theme/js/view/add-home-breadcrumb.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable max-nested-callbacks, no-undef */\ndefine([\n    'jquery',\n    'Magento_Theme/js/model/breadcrumb-list',\n    'mage/translate'\n], function ($, breadcrumbList) {\n    'use strict';\n\n    /**\n     * @return {Object}\n     */\n    var homeCrumb = function () {\n        return {\n            name: 'home',\n            label: $.mage.__('Home'),\n            title: $.mage.__('Go to Home Page'),\n            link: BASE_URL || ''\n        };\n    };\n\n    return function (breadcrumb) {\n\n        breadcrumbList.unshift(homeCrumb());\n\n        return breadcrumb;\n    };\n});\n","Magento_Theme/js/model/breadcrumb-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return [];\n});\n","Andromeda_MenuDigital/js/html2canvas.min.js":"/*!\n * html2canvas 1.4.1 <https://html2canvas.hertzen.com>\n * Copyright (c) 2022 Niklas von Hertzen <https://hertzen.com>\n * Released under MIT License\n */\n!function(A,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=e():\"function\"==typeof define&&define.amd?define(e):(A=\"undefined\"!=typeof globalThis?globalThis:A||self).html2canvas=e()}(this,function(){\"use strict\";\n/*! *****************************************************************************\n    Copyright (c) Microsoft Corporation.\n\n    Permission to use, copy, modify, and/or distribute this software for any\n    purpose with or without fee is hereby granted.\n\n    THE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH\n    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY\n    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,\n    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM\n    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR\n    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR\n    PERFORMANCE OF THIS SOFTWARE.\n    ***************************************************************************** */var r=function(A,e){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(A,e){A.__proto__=e}||function(A,e){for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(A[t]=e[t])})(A,e)};function A(A,e){if(\"function\"!=typeof e&&null!==e)throw new TypeError(\"Class extends value \"+String(e)+\" is not a constructor or null\");function t(){this.constructor=A}r(A,e),A.prototype=null===e?Object.create(e):(t.prototype=e.prototype,new t)}var h=function(){return(h=Object.assign||function(A){for(var e,t=1,r=arguments.length;t<r;t++)for(var B in e=arguments[t])Object.prototype.hasOwnProperty.call(e,B)&&(A[B]=e[B]);return A}).apply(this,arguments)};function a(A,s,o,i){return new(o=o||Promise)(function(t,e){function r(A){try{n(i.next(A))}catch(A){e(A)}}function B(A){try{n(i.throw(A))}catch(A){e(A)}}function n(A){var e;A.done?t(A.value):((e=A.value)instanceof o?e:new o(function(A){A(e)})).then(r,B)}n((i=i.apply(A,s||[])).next())})}function H(t,r){var B,n,s,o={label:0,sent:function(){if(1&s[0])throw s[1];return s[1]},trys:[],ops:[]},A={next:e(0),throw:e(1),return:e(2)};return\"function\"==typeof Symbol&&(A[Symbol.iterator]=function(){return this}),A;function e(e){return function(A){return function(e){if(B)throw new TypeError(\"Generator is already executing.\");for(;o;)try{if(B=1,n&&(s=2&e[0]?n.return:e[0]?n.throw||((s=n.return)&&s.call(n),0):n.next)&&!(s=s.call(n,e[1])).done)return s;switch(n=0,(e=s?[2&e[0],s.value]:e)[0]){case 0:case 1:s=e;break;case 4:return o.label++,{value:e[1],done:!1};case 5:o.label++,n=e[1],e=[0];continue;case 7:e=o.ops.pop(),o.trys.pop();continue;default:if(!(s=0<(s=o.trys).length&&s[s.length-1])&&(6===e[0]||2===e[0])){o=0;continue}if(3===e[0]&&(!s||e[1]>s[0]&&e[1]<s[3])){o.label=e[1];break}if(6===e[0]&&o.label<s[1]){o.label=s[1],s=e;break}if(s&&o.label<s[2]){o.label=s[2],o.ops.push(e);break}s[2]&&o.ops.pop(),o.trys.pop();continue}e=r.call(t,o)}catch(A){e=[6,A],n=0}finally{B=s=0}if(5&e[0])throw e[1];return{value:e[0]?e[1]:void 0,done:!0}}([e,A])}}}function t(A,e,t){if(t||2===arguments.length)for(var r,B=0,n=e.length;B<n;B++)!r&&B in e||((r=r||Array.prototype.slice.call(e,0,B))[B]=e[B]);return A.concat(r||e)}var d=(B.prototype.add=function(A,e,t,r){return new B(this.left+A,this.top+e,this.width+t,this.height+r)},B.fromClientRect=function(A,e){return new B(e.left+A.windowBounds.left,e.top+A.windowBounds.top,e.width,e.height)},B.fromDOMRectList=function(A,e){e=Array.from(e).find(function(A){return 0!==A.width});return e?new B(e.left+A.windowBounds.left,e.top+A.windowBounds.top,e.width,e.height):B.EMPTY},B.EMPTY=new B(0,0,0,0),B);function B(A,e,t,r){this.left=A,this.top=e,this.width=t,this.height=r}for(var f=function(A,e){return d.fromClientRect(A,e.getBoundingClientRect())},Q=function(A){for(var e=[],t=0,r=A.length;t<r;){var B,n=A.charCodeAt(t++);55296<=n&&n<=56319&&t<r?56320==(64512&(B=A.charCodeAt(t++)))?e.push(((1023&n)<<10)+(1023&B)+65536):(e.push(n),t--):e.push(n)}return e},g=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];if(String.fromCodePoint)return String.fromCodePoint.apply(String,A);var t=A.length;if(!t)return\"\";for(var r=[],B=-1,n=\"\";++B<t;){var s=A[B];s<=65535?r.push(s):(s-=65536,r.push(55296+(s>>10),s%1024+56320)),(B+1===t||16384<r.length)&&(n+=String.fromCharCode.apply(String,r),r.length=0)}return n},e=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\",n=\"undefined\"==typeof Uint8Array?[]:new Uint8Array(256),s=0;s<e.length;s++)n[e.charCodeAt(s)]=s;for(var o=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\",c=\"undefined\"==typeof Uint8Array?[]:new Uint8Array(256),i=0;i<o.length;i++)c[o.charCodeAt(i)]=i;function w(A,e,t){return A.slice?A.slice(e,t):new Uint16Array(Array.prototype.slice.call(A,e,t))}var U=(l.prototype.get=function(A){var e;if(0<=A){if(A<55296||56319<A&&A<=65535)return e=this.index[A>>5],this.data[e=(e<<2)+(31&A)];if(A<=65535)return e=this.index[2048+(A-55296>>5)],this.data[e=(e<<2)+(31&A)];if(A<this.highStart)return e=this.index[e=2080+(A>>11)],e=this.index[e+=A>>5&63],this.data[e=(e<<2)+(31&A)];if(A<=1114111)return this.data[this.highValueIndex]}return this.errorValue},l);function l(A,e,t,r,B,n){this.initialValue=A,this.errorValue=e,this.highStart=t,this.highValueIndex=r,this.index=B,this.data=n}for(var C=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\",u=\"undefined\"==typeof Uint8Array?[]:new Uint8Array(256),F=0;F<C.length;F++)u[C.charCodeAt(F)]=F;function p(A,e,t,r){var B=r[t];if(Array.isArray(A)?-1!==A.indexOf(B):A===B)for(var n=t;n<=r.length;){if((o=r[++n])===e)return 1;if(o!==D)break}if(B===D)for(n=t;0<n;){var s=r[--n];if(Array.isArray(A)?-1!==A.indexOf(s):A===s)for(var o,i=t;i<=r.length;){if((o=r[++i])===e)return 1;if(o!==D)break}if(s!==D)break}}function E(A,e){for(var t=A;0<=t;){var r=e[t];if(r!==D)return r;t--}return 0}function I(t,A){var e=(B=function(A,r){void 0===r&&(r=\"strict\");var B=[],n=[],s=[];return A.forEach(function(A,e){var t=rA.get(A);if(50<t?(s.push(!0),t-=50):s.push(!1),-1!==[\"normal\",\"auto\",\"loose\"].indexOf(r)&&-1!==[8208,8211,12316,12448].indexOf(A))return n.push(e),B.push(16);if(4!==t&&11!==t)return n.push(e),31===t?B.push(\"strict\"===r?O:q):t===AA||29===t?B.push(J):43===t?131072<=A&&A<=196605||196608<=A&&A<=262141?B.push(q):B.push(J):void B.push(t);if(0===e)return n.push(e),B.push(J);t=B[e-1];return-1===iA.indexOf(t)?(n.push(n[e-1]),B.push(t)):(n.push(e),B.push(J))}),[n,B,s]}(t,(A=A||{lineBreak:\"normal\",wordBreak:\"normal\"}).lineBreak))[0],r=B[1],B=B[2];return[e,r=\"break-all\"===A.wordBreak||\"break-word\"===A.wordBreak?r.map(function(A){return-1!==[R,J,AA].indexOf(A)?q:A}):r,\"keep-all\"===A.wordBreak?B.map(function(A,e){return A&&19968<=t[e]&&t[e]<=40959}):void 0]}var y,K,m,L,b,D=10,v=13,x=15,M=17,S=18,T=19,G=20,O=21,V=22,k=24,R=25,N=26,P=27,X=28,J=30,Y=32,W=33,Z=34,_=35,q=37,j=38,z=39,$=40,AA=42,eA=[9001,65288],tA=\"\u00d7\",rA=(m=function(A){var e,t,r,B,n=.75*A.length,s=A.length,o=0;\"=\"===A[A.length-1]&&(n--,\"=\"===A[A.length-2]&&n--);for(var n=new(\"undefined\"!=typeof ArrayBuffer&&\"undefined\"!=typeof Uint8Array&&void 0!==Uint8Array.prototype.slice?ArrayBuffer:Array)(n),i=Array.isArray(n)?n:new Uint8Array(n),Q=0;Q<s;Q+=4)e=c[A.charCodeAt(Q)],t=c[A.charCodeAt(Q+1)],r=c[A.charCodeAt(Q+2)],B=c[A.charCodeAt(Q+3)],i[o++]=e<<2|t>>4,i[o++]=(15&t)<<4|r>>2,i[o++]=(3&r)<<6|63&B;return n}(y=\"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\"),L=Array.isArray(m)?function(A){for(var e=A.length,t=[],r=0;r<e;r+=4)t.push(A[r+3]<<24|A[r+2]<<16|A[r+1]<<8|A[r]);return t}(m):new Uint32Array(m),b=Array.isArray(m)?function(A){for(var e=A.length,t=[],r=0;r<e;r+=2)t.push(A[r+1]<<8|A[r]);return t}(m):new Uint16Array(m),y=w(b,12,L[4]/2),K=2===L[5]?w(b,(24+L[4])/2):(m=L,b=Math.ceil((24+L[4])/4),m.slice?m.slice(b,K):new Uint32Array(Array.prototype.slice.call(m,b,K))),new U(L[0],L[1],L[2],L[3],y,K)),BA=[J,36],nA=[1,2,3,5],sA=[D,8],oA=[P,N],iA=nA.concat(sA),QA=[j,z,$,Z,_],cA=[x,v],aA=(gA.prototype.slice=function(){return g.apply(void 0,this.codePoints.slice(this.start,this.end))},gA);function gA(A,e,t,r){this.codePoints=A,this.required=\"!\"===e,this.start=t,this.end=r}function wA(A,e){var t=Q(A),r=(e=I(t,e))[0],B=e[1],n=e[2],s=t.length,o=0,i=0;return{next:function(){if(s<=i)return{done:!0,value:null};for(var A=tA;i<s&&(A=function(A,e,t,r,B){if(0===t[r])return tA;var n=r-1;if(Array.isArray(B)&&!0===B[n])return tA;var s=n-1,o=1+n,i=e[n],r=0<=s?e[s]:0,B=e[o];if(2===i&&3===B)return tA;if(-1!==nA.indexOf(i))return\"!\";if(-1!==nA.indexOf(B))return tA;if(-1!==sA.indexOf(B))return tA;if(8===E(n,e))return\"\u00f7\";if(11===rA.get(A[n]))return tA;if((i===Y||i===W)&&11===rA.get(A[o]))return tA;if(7===i||7===B)return tA;if(9===i)return tA;if(-1===[D,v,x].indexOf(i)&&9===B)return tA;if(-1!==[M,S,T,k,X].indexOf(B))return tA;if(E(n,e)===V)return tA;if(p(23,V,n,e))return tA;if(p([M,S],O,n,e))return tA;if(p(12,12,n,e))return tA;if(i===D)return\"\u00f7\";if(23===i||23===B)return tA;if(16===B||16===i)return\"\u00f7\";if(-1!==[v,x,O].indexOf(B)||14===i)return tA;if(36===r&&-1!==cA.indexOf(i))return tA;if(i===X&&36===B)return tA;if(B===G)return tA;if(-1!==BA.indexOf(B)&&i===R||-1!==BA.indexOf(i)&&B===R)return tA;if(i===P&&-1!==[q,Y,W].indexOf(B)||-1!==[q,Y,W].indexOf(i)&&B===N)return tA;if(-1!==BA.indexOf(i)&&-1!==oA.indexOf(B)||-1!==oA.indexOf(i)&&-1!==BA.indexOf(B))return tA;if(-1!==[P,N].indexOf(i)&&(B===R||-1!==[V,x].indexOf(B)&&e[1+o]===R)||-1!==[V,x].indexOf(i)&&B===R||i===R&&-1!==[R,X,k].indexOf(B))return tA;if(-1!==[R,X,k,M,S].indexOf(B))for(var Q=n;0<=Q;){if((c=e[Q])===R)return tA;if(-1===[X,k].indexOf(c))break;Q--}if(-1!==[P,N].indexOf(B))for(var c,Q=-1!==[M,S].indexOf(i)?s:n;0<=Q;){if((c=e[Q])===R)return tA;if(-1===[X,k].indexOf(c))break;Q--}if(j===i&&-1!==[j,z,Z,_].indexOf(B)||-1!==[z,Z].indexOf(i)&&-1!==[z,$].indexOf(B)||-1!==[$,_].indexOf(i)&&B===$)return tA;if(-1!==QA.indexOf(i)&&-1!==[G,N].indexOf(B)||-1!==QA.indexOf(B)&&i===P)return tA;if(-1!==BA.indexOf(i)&&-1!==BA.indexOf(B))return tA;if(i===k&&-1!==BA.indexOf(B))return tA;if(-1!==BA.concat(R).indexOf(i)&&B===V&&-1===eA.indexOf(A[o])||-1!==BA.concat(R).indexOf(B)&&i===S)return tA;if(41===i&&41===B){for(var a=t[n],g=1;0<a&&41===e[--a];)g++;if(g%2!=0)return tA}return i===Y&&B===W?tA:\"\u00f7\"}(t,B,r,++i,n))===tA;);if(A===tA&&i!==s)return{done:!0,value:null};var e=new aA(t,A,o,i);return o=i,{value:e,done:!1}}}}function UA(A){return 48<=A&&A<=57}function lA(A){return UA(A)||65<=A&&A<=70||97<=A&&A<=102}function CA(A){return 10===A||9===A||32===A}function uA(A){return 97<=(t=e=A)&&t<=122||65<=(e=e)&&e<=90||128<=A||95===A;var e,t}function FA(A){return uA(A)||UA(A)||45===A}function hA(A,e){return 92===A&&10!==e}function dA(A,e,t){return 45===A?uA(e)||hA(e,t):!!uA(A)||92===A&&10!==e}function fA(A,e,t){return 43===A||45===A?!!UA(e)||46===e&&UA(t):UA(46===A?e:A)}var HA={type:2},pA={type:3},EA={type:4},IA={type:13},yA={type:8},KA={type:21},mA={type:9},LA={type:10},bA={type:11},DA={type:12},vA={type:14},xA={type:23},MA={type:1},SA={type:25},TA={type:24},GA={type:26},OA={type:27},VA={type:28},kA={type:29},RA={type:31},NA={type:32},PA=(XA.prototype.write=function(A){this._value=this._value.concat(Q(A))},XA.prototype.read=function(){for(var A=[],e=this.consumeToken();e!==NA;)A.push(e),e=this.consumeToken();return A},XA.prototype.consumeToken=function(){var A=this.consumeCodePoint();switch(A){case 34:return this.consumeStringToken(34);case 35:var e=this.peekCodePoint(0),t=this.peekCodePoint(1),r=this.peekCodePoint(2);if(FA(e)||hA(t,r)){var B=dA(e,t,r)?2:1;return{type:5,value:this.consumeName(),flags:B}}break;case 36:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),IA;break;case 39:return this.consumeStringToken(39);case 40:return HA;case 41:return pA;case 42:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),vA;break;case 43:if(fA(A,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(A),this.consumeNumericToken();break;case 44:return EA;case 45:var r=A,B=this.peekCodePoint(0),n=this.peekCodePoint(1);if(fA(r,B,n))return this.reconsumeCodePoint(A),this.consumeNumericToken();if(dA(r,B,n))return this.reconsumeCodePoint(A),this.consumeIdentLikeToken();if(45===B&&62===n)return this.consumeCodePoint(),this.consumeCodePoint(),TA;break;case 46:if(fA(A,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(A),this.consumeNumericToken();break;case 47:if(42===this.peekCodePoint(0))for(this.consumeCodePoint();;){var s=this.consumeCodePoint();if(42===s&&47===(s=this.consumeCodePoint()))return this.consumeToken();if(-1===s)return this.consumeToken()}break;case 58:return GA;case 59:return OA;case 60:if(33===this.peekCodePoint(0)&&45===this.peekCodePoint(1)&&45===this.peekCodePoint(2))return this.consumeCodePoint(),this.consumeCodePoint(),SA;break;case 64:var n=this.peekCodePoint(0),o=this.peekCodePoint(1),i=this.peekCodePoint(2);if(dA(n,o,i))return{type:7,value:this.consumeName()};break;case 91:return VA;case 92:if(hA(A,this.peekCodePoint(0)))return this.reconsumeCodePoint(A),this.consumeIdentLikeToken();break;case 93:return kA;case 61:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),yA;break;case 123:return bA;case 125:return DA;case 117:case 85:o=this.peekCodePoint(0),i=this.peekCodePoint(1);return 43!==o||!lA(i)&&63!==i||(this.consumeCodePoint(),this.consumeUnicodeRangeToken()),this.reconsumeCodePoint(A),this.consumeIdentLikeToken();case 124:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),mA;if(124===this.peekCodePoint(0))return this.consumeCodePoint(),KA;break;case 126:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),LA;break;case-1:return NA}return CA(A)?(this.consumeWhiteSpace(),RA):UA(A)?(this.reconsumeCodePoint(A),this.consumeNumericToken()):uA(A)?(this.reconsumeCodePoint(A),this.consumeIdentLikeToken()):{type:6,value:g(A)}},XA.prototype.consumeCodePoint=function(){var A=this._value.shift();return void 0===A?-1:A},XA.prototype.reconsumeCodePoint=function(A){this._value.unshift(A)},XA.prototype.peekCodePoint=function(A){return A>=this._value.length?-1:this._value[A]},XA.prototype.consumeUnicodeRangeToken=function(){for(var A=[],e=this.consumeCodePoint();lA(e)&&A.length<6;)A.push(e),e=this.consumeCodePoint();for(var t=!1;63===e&&A.length<6;)A.push(e),e=this.consumeCodePoint(),t=!0;if(t)return{type:30,start:parseInt(g.apply(void 0,A.map(function(A){return 63===A?48:A})),16),end:parseInt(g.apply(void 0,A.map(function(A){return 63===A?70:A})),16)};var r=parseInt(g.apply(void 0,A),16);if(45===this.peekCodePoint(0)&&lA(this.peekCodePoint(1))){this.consumeCodePoint();for(var e=this.consumeCodePoint(),B=[];lA(e)&&B.length<6;)B.push(e),e=this.consumeCodePoint();return{type:30,start:r,end:parseInt(g.apply(void 0,B),16)}}return{type:30,start:r,end:r}},XA.prototype.consumeIdentLikeToken=function(){var A=this.consumeName();return\"url\"===A.toLowerCase()&&40===this.peekCodePoint(0)?(this.consumeCodePoint(),this.consumeUrlToken()):40===this.peekCodePoint(0)?(this.consumeCodePoint(),{type:19,value:A}):{type:20,value:A}},XA.prototype.consumeUrlToken=function(){var A=[];if(this.consumeWhiteSpace(),-1===this.peekCodePoint(0))return{type:22,value:\"\"};var e,t=this.peekCodePoint(0);if(39===t||34===t){t=this.consumeStringToken(this.consumeCodePoint());return 0===t.type&&(this.consumeWhiteSpace(),-1===this.peekCodePoint(0)||41===this.peekCodePoint(0))?(this.consumeCodePoint(),{type:22,value:t.value}):(this.consumeBadUrlRemnants(),xA)}for(;;){var r=this.consumeCodePoint();if(-1===r||41===r)return{type:22,value:g.apply(void 0,A)};if(CA(r))return this.consumeWhiteSpace(),-1===this.peekCodePoint(0)||41===this.peekCodePoint(0)?(this.consumeCodePoint(),{type:22,value:g.apply(void 0,A)}):(this.consumeBadUrlRemnants(),xA);if(34===r||39===r||40===r||(0<=(e=r)&&e<=8||11===e||14<=e&&e<=31||127===e))return this.consumeBadUrlRemnants(),xA;if(92===r){if(!hA(r,this.peekCodePoint(0)))return this.consumeBadUrlRemnants(),xA;A.push(this.consumeEscapedCodePoint())}else A.push(r)}},XA.prototype.consumeWhiteSpace=function(){for(;CA(this.peekCodePoint(0));)this.consumeCodePoint()},XA.prototype.consumeBadUrlRemnants=function(){for(;;){var A=this.consumeCodePoint();if(41===A||-1===A)return;hA(A,this.peekCodePoint(0))&&this.consumeEscapedCodePoint()}},XA.prototype.consumeStringSlice=function(A){for(var e=\"\";0<A;){var t=Math.min(5e4,A);e+=g.apply(void 0,this._value.splice(0,t)),A-=t}return this._value.shift(),e},XA.prototype.consumeStringToken=function(A){for(var e=\"\",t=0;;){var r,B=this._value[t];if(-1===B||void 0===B||B===A)return{type:0,value:e+=this.consumeStringSlice(t)};if(10===B)return this._value.splice(0,t),MA;92!==B||-1!==(r=this._value[t+1])&&void 0!==r&&(10===r?(e+=this.consumeStringSlice(t),t=-1,this._value.shift()):hA(B,r)&&(e+=this.consumeStringSlice(t),e+=g(this.consumeEscapedCodePoint()),t=-1)),t++}},XA.prototype.consumeNumber=function(){var A=[],e=4;for(43!==(t=this.peekCodePoint(0))&&45!==t||A.push(this.consumeCodePoint());UA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());var t=this.peekCodePoint(0),r=this.peekCodePoint(1);if(46===t&&UA(r))for(A.push(this.consumeCodePoint(),this.consumeCodePoint()),e=8;UA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());t=this.peekCodePoint(0);var r=this.peekCodePoint(1),B=this.peekCodePoint(2);if((69===t||101===t)&&((43===r||45===r)&&UA(B)||UA(r)))for(A.push(this.consumeCodePoint(),this.consumeCodePoint()),e=8;UA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());return[function(A){var e=0,t=1;43!==A[e]&&45!==A[e]||(45===A[e]&&(t=-1),e++);for(var r=[];UA(A[e]);)r.push(A[e++]);var B=r.length?parseInt(g.apply(void 0,r),10):0;46===A[e]&&e++;for(var n=[];UA(A[e]);)n.push(A[e++]);var s=n.length,o=s?parseInt(g.apply(void 0,n),10):0;69!==A[e]&&101!==A[e]||e++;var i=1;43!==A[e]&&45!==A[e]||(45===A[e]&&(i=-1),e++);for(var Q=[];UA(A[e]);)Q.push(A[e++]);var c=Q.length?parseInt(g.apply(void 0,Q),10):0;return t*(B+o*Math.pow(10,-s))*Math.pow(10,i*c)}(A),e]},XA.prototype.consumeNumericToken=function(){var A=this.consumeNumber(),e=A[0],t=A[1],r=this.peekCodePoint(0),B=this.peekCodePoint(1),A=this.peekCodePoint(2);return dA(r,B,A)?{type:15,number:e,flags:t,unit:this.consumeName()}:37===r?(this.consumeCodePoint(),{type:16,number:e,flags:t}):{type:17,number:e,flags:t}},XA.prototype.consumeEscapedCodePoint=function(){var A,e=this.consumeCodePoint();if(lA(e)){for(var t=g(e);lA(this.peekCodePoint(0))&&t.length<6;)t+=g(this.consumeCodePoint());CA(this.peekCodePoint(0))&&this.consumeCodePoint();var r=parseInt(t,16);return 0===r||55296<=(A=r)&&A<=57343||1114111<r?65533:r}return-1===e?65533:e},XA.prototype.consumeName=function(){for(var A=\"\";;){var e=this.consumeCodePoint();if(FA(e))A+=g(e);else{if(!hA(e,this.peekCodePoint(0)))return this.reconsumeCodePoint(e),A;A+=g(this.consumeEscapedCodePoint())}}},XA);function XA(){this._value=[]}var JA=(YA.create=function(A){var e=new PA;return e.write(A),new YA(e.read())},YA.parseValue=function(A){return YA.create(A).parseComponentValue()},YA.parseValues=function(A){return YA.create(A).parseComponentValues()},YA.prototype.parseComponentValue=function(){for(var A=this.consumeToken();31===A.type;)A=this.consumeToken();if(32===A.type)throw new SyntaxError(\"Error parsing CSS component value, unexpected EOF\");this.reconsumeToken(A);for(var e=this.consumeComponentValue();31===(A=this.consumeToken()).type;);if(32===A.type)return e;throw new SyntaxError(\"Error parsing CSS component value, multiple values found when expecting only one\")},YA.prototype.parseComponentValues=function(){for(var A=[];;){var e=this.consumeComponentValue();if(32===e.type)return A;A.push(e),A.push()}},YA.prototype.consumeComponentValue=function(){var A=this.consumeToken();switch(A.type){case 11:case 28:case 2:return this.consumeSimpleBlock(A.type);case 19:return this.consumeFunction(A)}return A},YA.prototype.consumeSimpleBlock=function(A){for(var e={type:A,values:[]},t=this.consumeToken();;){if(32===t.type||ce(t,A))return e;this.reconsumeToken(t),e.values.push(this.consumeComponentValue()),t=this.consumeToken()}},YA.prototype.consumeFunction=function(A){for(var e={name:A.value,values:[],type:18};;){var t=this.consumeToken();if(32===t.type||3===t.type)return e;this.reconsumeToken(t),e.values.push(this.consumeComponentValue())}},YA.prototype.consumeToken=function(){var A=this._tokens.shift();return void 0===A?NA:A},YA.prototype.reconsumeToken=function(A){this._tokens.unshift(A)},YA);function YA(A){this._tokens=A}function WA(A){return 15===A.type}function ZA(A){return 17===A.type}function _A(A){return 20===A.type}function qA(A){return 0===A.type}function jA(A,e){return _A(A)&&A.value===e}function zA(A){return 31!==A.type}function $A(A){return 31!==A.type&&4!==A.type}function Ae(A){var e=[],t=[];return A.forEach(function(A){if(4===A.type){if(0===t.length)throw new Error(\"Error parsing function args, zero tokens for arg\");return e.push(t),void(t=[])}31!==A.type&&t.push(A)}),t.length&&e.push(t),e}function ee(A){return 17===A.type||15===A.type}function te(A){return 16===A.type||ee(A)}function re(A){return 1<A.length?[A[0],A[1]]:[A[0]]}function Be(A,e,t){var r=A[0],A=A[1];return[Ue(r,e),Ue(void 0!==A?A:r,t)]}function ne(A){return 15===A.type&&(\"deg\"===A.unit||\"grad\"===A.unit||\"rad\"===A.unit||\"turn\"===A.unit)}function se(A){switch(A.filter(_A).map(function(A){return A.value}).join(\" \")){case\"to bottom right\":case\"to right bottom\":case\"left top\":case\"top left\":return[ae,ae];case\"to top\":case\"bottom\":return Ce(0);case\"to bottom left\":case\"to left bottom\":case\"right top\":case\"top right\":return[ae,we];case\"to right\":case\"left\":return Ce(90);case\"to top left\":case\"to left top\":case\"right bottom\":case\"bottom right\":return[we,we];case\"to bottom\":case\"top\":return Ce(180);case\"to top right\":case\"to right top\":case\"left bottom\":case\"bottom left\":return[we,ae];case\"to left\":case\"right\":return Ce(270)}return 0}function oe(A){return 0==(255&A)}function ie(A){var e=255&A,t=255&A>>8,r=255&A>>16,A=255&A>>24;return e<255?\"rgba(\"+A+\",\"+r+\",\"+t+\",\"+e/255+\")\":\"rgb(\"+A+\",\"+r+\",\"+t+\")\"}function Qe(A,e){if(17===A.type)return A.number;if(16!==A.type)return 0;var t=3===e?1:255;return 3===e?A.number/100*t:Math.round(A.number/100*t)}var ce=function(A,e){return 11===e&&12===A.type||(28===e&&29===A.type||2===e&&3===A.type)},ae={type:17,number:0,flags:4},ge={type:16,number:50,flags:4},we={type:16,number:100,flags:4},Ue=function(A,e){if(16===A.type)return A.number/100*e;if(WA(A))switch(A.unit){case\"rem\":case\"em\":return 16*A.number;default:return A.number}return A.number},le=function(A,e){if(15===e.type)switch(e.unit){case\"deg\":return Math.PI*e.number/180;case\"grad\":return Math.PI/200*e.number;case\"rad\":return e.number;case\"turn\":return 2*Math.PI*e.number}throw new Error(\"Unsupported angle type\")},Ce=function(A){return Math.PI*A/180},ue=function(A,e){if(18===e.type){var t=me[e.name];if(void 0===t)throw new Error('Attempting to parse an unsupported color function \"'+e.name+'\"');return t(A,e.values)}if(5===e.type){if(3===e.value.length){var r=e.value.substring(0,1),B=e.value.substring(1,2),n=e.value.substring(2,3);return Fe(parseInt(r+r,16),parseInt(B+B,16),parseInt(n+n,16),1)}if(4===e.value.length){var r=e.value.substring(0,1),B=e.value.substring(1,2),n=e.value.substring(2,3),s=e.value.substring(3,4);return Fe(parseInt(r+r,16),parseInt(B+B,16),parseInt(n+n,16),parseInt(s+s,16)/255)}if(6===e.value.length){r=e.value.substring(0,2),B=e.value.substring(2,4),n=e.value.substring(4,6);return Fe(parseInt(r,16),parseInt(B,16),parseInt(n,16),1)}if(8===e.value.length){r=e.value.substring(0,2),B=e.value.substring(2,4),n=e.value.substring(4,6),s=e.value.substring(6,8);return Fe(parseInt(r,16),parseInt(B,16),parseInt(n,16),parseInt(s,16)/255)}}if(20===e.type){e=Le[e.value.toUpperCase()];if(void 0!==e)return e}return Le.TRANSPARENT},Fe=function(A,e,t,r){return(A<<24|e<<16|t<<8|Math.round(255*r)<<0)>>>0},he=function(A,e){e=e.filter($A);if(3===e.length){var t=e.map(Qe),r=t[0],B=t[1],t=t[2];return Fe(r,B,t,1)}if(4!==e.length)return 0;e=e.map(Qe),r=e[0],B=e[1],t=e[2],e=e[3];return Fe(r,B,t,e)};function de(A,e,t){return t<0&&(t+=1),1<=t&&--t,t<1/6?(e-A)*t*6+A:t<.5?e:t<2/3?6*(e-A)*(2/3-t)+A:A}function fe(A,e){return ue(A,JA.create(e).parseComponentValue())}function He(A,e){return A=ue(A,e[0]),(e=e[1])&&te(e)?{color:A,stop:e}:{color:A,stop:null}}function pe(A,t){var e=A[0],r=A[A.length-1];null===e.stop&&(e.stop=ae),null===r.stop&&(r.stop=we);for(var B=[],n=0,s=0;s<A.length;s++){var o=A[s].stop;null!==o?(n<(o=Ue(o,t))?B.push(o):B.push(n),n=o):B.push(null)}for(var i=null,s=0;s<B.length;s++){var Q=B[s];if(null===Q)null===i&&(i=s);else if(null!==i){for(var c=s-i,a=(Q-B[i-1])/(1+c),g=1;g<=c;g++)B[i+g-1]=a*g;i=null}}return A.map(function(A,e){return{color:A.color,stop:Math.max(Math.min(1,B[e]/t),0)}})}function Ee(A,e,t){var r=\"number\"==typeof A?A:(s=e/2,r=(n=t)/2,s=Ue((B=A)[0],e)-s,n=r-Ue(B[1],n),(Math.atan2(n,s)+2*Math.PI)%(2*Math.PI)),B=Math.abs(e*Math.sin(r))+Math.abs(t*Math.cos(r)),n=e/2,s=t/2,e=B/2,t=Math.sin(r-Math.PI/2)*e,e=Math.cos(r-Math.PI/2)*e;return[B,n-e,n+e,s-t,s+t]}function Ie(A,e){return Math.sqrt(A*A+e*e)}function ye(A,e,B,n,s){return[[0,0],[0,e],[A,0],[A,e]].reduce(function(A,e){var t=e[0],r=e[1],r=Ie(B-t,n-r);return(s?r<A.optimumDistance:r>A.optimumDistance)?{optimumCorner:e,optimumDistance:r}:A},{optimumDistance:s?1/0:-1/0,optimumCorner:null}).optimumCorner}var Ke=function(A,e){var t=e.filter($A),r=t[0],B=t[1],n=t[2],e=t[3],t=(17===r.type?Ce(r.number):le(A,r))/(2*Math.PI),A=te(B)?B.number/100:0,r=te(n)?n.number/100:0,B=void 0!==e&&te(e)?Ue(e,1):1;if(0==A)return Fe(255*r,255*r,255*r,1);n=r<=.5?r*(1+A):r+A-r*A,e=2*r-n,A=de(e,n,t+1/3),r=de(e,n,t),t=de(e,n,t-1/3);return Fe(255*A,255*r,255*t,B)},me={hsl:Ke,hsla:Ke,rgb:he,rgba:he},Le={ALICEBLUE:4042850303,ANTIQUEWHITE:4209760255,AQUA:16777215,AQUAMARINE:2147472639,AZURE:4043309055,BEIGE:4126530815,BISQUE:4293182719,BLACK:255,BLANCHEDALMOND:4293643775,BLUE:65535,BLUEVIOLET:2318131967,BROWN:2771004159,BURLYWOOD:3736635391,CADETBLUE:1604231423,CHARTREUSE:2147418367,CHOCOLATE:3530104575,CORAL:4286533887,CORNFLOWERBLUE:1687547391,CORNSILK:4294499583,CRIMSON:3692313855,CYAN:16777215,DARKBLUE:35839,DARKCYAN:9145343,DARKGOLDENROD:3095837695,DARKGRAY:2846468607,DARKGREEN:6553855,DARKGREY:2846468607,DARKKHAKI:3182914559,DARKMAGENTA:2332068863,DARKOLIVEGREEN:1433087999,DARKORANGE:4287365375,DARKORCHID:2570243327,DARKRED:2332033279,DARKSALMON:3918953215,DARKSEAGREEN:2411499519,DARKSLATEBLUE:1211993087,DARKSLATEGRAY:793726975,DARKSLATEGREY:793726975,DARKTURQUOISE:13554175,DARKVIOLET:2483082239,DEEPPINK:4279538687,DEEPSKYBLUE:12582911,DIMGRAY:1768516095,DIMGREY:1768516095,DODGERBLUE:512819199,FIREBRICK:2988581631,FLORALWHITE:4294635775,FORESTGREEN:579543807,FUCHSIA:4278255615,GAINSBORO:3705462015,GHOSTWHITE:4177068031,GOLD:4292280575,GOLDENROD:3668254975,GRAY:2155905279,GREEN:8388863,GREENYELLOW:2919182335,GREY:2155905279,HONEYDEW:4043305215,HOTPINK:4285117695,INDIANRED:3445382399,INDIGO:1258324735,IVORY:4294963455,KHAKI:4041641215,LAVENDER:3873897215,LAVENDERBLUSH:4293981695,LAWNGREEN:2096890111,LEMONCHIFFON:4294626815,LIGHTBLUE:2916673279,LIGHTCORAL:4034953471,LIGHTCYAN:3774873599,LIGHTGOLDENRODYELLOW:4210742015,LIGHTGRAY:3553874943,LIGHTGREEN:2431553791,LIGHTGREY:3553874943,LIGHTPINK:4290167295,LIGHTSALMON:4288707327,LIGHTSEAGREEN:548580095,LIGHTSKYBLUE:2278488831,LIGHTSLATEGRAY:2005441023,LIGHTSLATEGREY:2005441023,LIGHTSTEELBLUE:2965692159,LIGHTYELLOW:4294959359,LIME:16711935,LIMEGREEN:852308735,LINEN:4210091775,MAGENTA:4278255615,MAROON:2147483903,MEDIUMAQUAMARINE:1724754687,MEDIUMBLUE:52735,MEDIUMORCHID:3126187007,MEDIUMPURPLE:2473647103,MEDIUMSEAGREEN:1018393087,MEDIUMSLATEBLUE:2070474495,MEDIUMSPRINGGREEN:16423679,MEDIUMTURQUOISE:1221709055,MEDIUMVIOLETRED:3340076543,MIDNIGHTBLUE:421097727,MINTCREAM:4127193855,MISTYROSE:4293190143,MOCCASIN:4293178879,NAVAJOWHITE:4292783615,NAVY:33023,OLDLACE:4260751103,OLIVE:2155872511,OLIVEDRAB:1804477439,ORANGE:4289003775,ORANGERED:4282712319,ORCHID:3664828159,PALEGOLDENROD:4008225535,PALEGREEN:2566625535,PALETURQUOISE:2951671551,PALEVIOLETRED:3681588223,PAPAYAWHIP:4293907967,PEACHPUFF:4292524543,PERU:3448061951,PINK:4290825215,PLUM:3718307327,POWDERBLUE:2967529215,PURPLE:2147516671,REBECCAPURPLE:1714657791,RED:4278190335,ROSYBROWN:3163525119,ROYALBLUE:1097458175,SADDLEBROWN:2336560127,SALMON:4202722047,SANDYBROWN:4104413439,SEAGREEN:780883967,SEASHELL:4294307583,SIENNA:2689740287,SILVER:3233857791,SKYBLUE:2278484991,SLATEBLUE:1784335871,SLATEGRAY:1887473919,SLATEGREY:1887473919,SNOW:4294638335,SPRINGGREEN:16744447,STEELBLUE:1182971135,TAN:3535047935,TEAL:8421631,THISTLE:3636451583,TOMATO:4284696575,TRANSPARENT:0,TURQUOISE:1088475391,VIOLET:4001558271,WHEAT:4125012991,WHITE:4294967295,WHITESMOKE:4126537215,YELLOW:4294902015,YELLOWGREEN:2597139199},be={name:\"background-clip\",initialValue:\"border-box\",prefix:!1,type:1,parse:function(A,e){return e.map(function(A){if(_A(A))switch(A.value){case\"padding-box\":return 1;case\"content-box\":return 2}return 0})}},De={name:\"background-color\",initialValue:\"transparent\",prefix:!1,type:3,format:\"color\"},Ke=function(t,A){var r=Ce(180),B=[];return Ae(A).forEach(function(A,e){if(0===e){e=A[0];if(20===e.type&&-1!==[\"top\",\"left\",\"right\",\"bottom\"].indexOf(e.value))return void(r=se(A));if(ne(e))return void(r=(le(t,e)+Ce(270))%Ce(360))}A=He(t,A);B.push(A)}),{angle:r,stops:B,type:1}},ve=\"closest-side\",xe=\"farthest-side\",Me=\"closest-corner\",Se=\"farthest-corner\",Te=\"ellipse\",Ge=\"contain\",he=function(r,A){var B=0,n=3,s=[],o=[];return Ae(A).forEach(function(A,e){var t=!0;0===e?t=A.reduce(function(A,e){if(_A(e))switch(e.value){case\"center\":return o.push(ge),!1;case\"top\":case\"left\":return o.push(ae),!1;case\"right\":case\"bottom\":return o.push(we),!1}else if(te(e)||ee(e))return o.push(e),!1;return A},t):1===e&&(t=A.reduce(function(A,e){if(_A(e))switch(e.value){case\"circle\":return B=0,!1;case Te:return!(B=1);case Ge:case ve:return n=0,!1;case xe:return!(n=1);case Me:return!(n=2);case\"cover\":case Se:return!(n=3)}else if(ee(e)||te(e))return(n=!Array.isArray(n)?[]:n).push(e),!1;return A},t)),t&&(A=He(r,A),s.push(A))}),{size:n,shape:B,stops:s,position:o,type:2}},Oe=function(A,e){if(22===e.type){var t={url:e.value,type:0};return A.cache.addImage(e.value),t}if(18!==e.type)throw new Error(\"Unsupported image type \"+e.type);t=ke[e.name];if(void 0===t)throw new Error('Attempting to parse an unsupported image function \"'+e.name+'\"');return t(A,e.values)};var Ve,ke={\"linear-gradient\":function(t,A){var r=Ce(180),B=[];return Ae(A).forEach(function(A,e){if(0===e){e=A[0];if(20===e.type&&\"to\"===e.value)return void(r=se(A));if(ne(e))return void(r=le(t,e))}A=He(t,A);B.push(A)}),{angle:r,stops:B,type:1}},\"-moz-linear-gradient\":Ke,\"-ms-linear-gradient\":Ke,\"-o-linear-gradient\":Ke,\"-webkit-linear-gradient\":Ke,\"radial-gradient\":function(B,A){var n=0,s=3,o=[],i=[];return Ae(A).forEach(function(A,e){var t,r=!0;0===e&&(t=!1,r=A.reduce(function(A,e){if(t)if(_A(e))switch(e.value){case\"center\":return i.push(ge),A;case\"top\":case\"left\":return i.push(ae),A;case\"right\":case\"bottom\":return i.push(we),A}else(te(e)||ee(e))&&i.push(e);else if(_A(e))switch(e.value){case\"circle\":return n=0,!1;case Te:return!(n=1);case\"at\":return!(t=!0);case ve:return s=0,!1;case\"cover\":case xe:return!(s=1);case Ge:case Me:return!(s=2);case Se:return!(s=3)}else if(ee(e)||te(e))return(s=!Array.isArray(s)?[]:s).push(e),!1;return A},r)),r&&(A=He(B,A),o.push(A))}),{size:s,shape:n,stops:o,position:i,type:2}},\"-moz-radial-gradient\":he,\"-ms-radial-gradient\":he,\"-o-radial-gradient\":he,\"-webkit-radial-gradient\":he,\"-webkit-gradient\":function(r,A){var e=Ce(180),B=[],n=1;return Ae(A).forEach(function(A,e){var t,A=A[0];if(0===e){if(_A(A)&&\"linear\"===A.value)return void(n=1);if(_A(A)&&\"radial\"===A.value)return void(n=2)}18===A.type&&(\"from\"===A.name?(t=ue(r,A.values[0]),B.push({stop:ae,color:t})):\"to\"===A.name?(t=ue(r,A.values[0]),B.push({stop:we,color:t})):\"color-stop\"!==A.name||2===(A=A.values.filter($A)).length&&(t=ue(r,A[1]),A=A[0],ZA(A)&&B.push({stop:{type:16,number:100*A.number,flags:A.flags},color:t})))}),1===n?{angle:(e+Ce(180))%Ce(360),stops:B,type:n}:{size:3,shape:0,stops:B,position:[],type:n}}},Re={name:\"background-image\",initialValue:\"none\",type:1,prefix:!1,parse:function(e,A){if(0===A.length)return[];var t=A[0];return 20===t.type&&\"none\"===t.value?[]:A.filter(function(A){return $A(A)&&!(20===(A=A).type&&\"none\"===A.value||18===A.type&&!ke[A.name])}).map(function(A){return Oe(e,A)})}},Ne={name:\"background-origin\",initialValue:\"border-box\",prefix:!1,type:1,parse:function(A,e){return e.map(function(A){if(_A(A))switch(A.value){case\"padding-box\":return 1;case\"content-box\":return 2}return 0})}},Pe={name:\"background-position\",initialValue:\"0% 0%\",type:1,prefix:!1,parse:function(A,e){return Ae(e).map(function(A){return A.filter(te)}).map(re)}},Xe={name:\"background-repeat\",initialValue:\"repeat\",prefix:!1,type:1,parse:function(A,e){return Ae(e).map(function(A){return A.filter(_A).map(function(A){return A.value}).join(\" \")}).map(Je)}},Je=function(A){switch(A){case\"no-repeat\":return 1;case\"repeat-x\":case\"repeat no-repeat\":return 2;case\"repeat-y\":case\"no-repeat repeat\":return 3;default:return 0}};(he=Ve=Ve||{}).AUTO=\"auto\",he.CONTAIN=\"contain\";function Ye(A,e){return _A(A)&&\"normal\"===A.value?1.2*e:17===A.type?e*A.number:te(A)?Ue(A,e):e}var We,Ze,_e={name:\"background-size\",initialValue:\"0\",prefix:!(he.COVER=\"cover\"),type:1,parse:function(A,e){return Ae(e).map(function(A){return A.filter(qe)})}},qe=function(A){return _A(A)||te(A)},he=function(A){return{name:\"border-\"+A+\"-color\",initialValue:\"transparent\",prefix:!1,type:3,format:\"color\"}},je=he(\"top\"),ze=he(\"right\"),$e=he(\"bottom\"),At=he(\"left\"),he=function(A){return{name:\"border-radius-\"+A,initialValue:\"0 0\",prefix:!1,type:1,parse:function(A,e){return re(e.filter(te))}}},et=he(\"top-left\"),tt=he(\"top-right\"),rt=he(\"bottom-right\"),Bt=he(\"bottom-left\"),he=function(A){return{name:\"border-\"+A+\"-style\",initialValue:\"solid\",prefix:!1,type:2,parse:function(A,e){switch(e){case\"none\":return 0;case\"dashed\":return 2;case\"dotted\":return 3;case\"double\":return 4}return 1}}},nt=he(\"top\"),st=he(\"right\"),ot=he(\"bottom\"),it=he(\"left\"),he=function(A){return{name:\"border-\"+A+\"-width\",initialValue:\"0\",type:0,prefix:!1,parse:function(A,e){return WA(e)?e.number:0}}},Qt=he(\"top\"),ct=he(\"right\"),at=he(\"bottom\"),gt=he(\"left\"),wt={name:\"color\",initialValue:\"transparent\",prefix:!1,type:3,format:\"color\"},Ut={name:\"direction\",initialValue:\"ltr\",prefix:!1,type:2,parse:function(A,e){return\"rtl\"!==e?0:1}},lt={name:\"display\",initialValue:\"inline-block\",prefix:!1,type:1,parse:function(A,e){return e.filter(_A).reduce(function(A,e){return A|Ct(e.value)},0)}},Ct=function(A){switch(A){case\"block\":case\"-webkit-box\":return 2;case\"inline\":return 4;case\"run-in\":return 8;case\"flow\":return 16;case\"flow-root\":return 32;case\"table\":return 64;case\"flex\":case\"-webkit-flex\":return 128;case\"grid\":case\"-ms-grid\":return 256;case\"ruby\":return 512;case\"subgrid\":return 1024;case\"list-item\":return 2048;case\"table-row-group\":return 4096;case\"table-header-group\":return 8192;case\"table-footer-group\":return 16384;case\"table-row\":return 32768;case\"table-cell\":return 65536;case\"table-column-group\":return 131072;case\"table-column\":return 262144;case\"table-caption\":return 524288;case\"ruby-base\":return 1048576;case\"ruby-text\":return 2097152;case\"ruby-base-container\":return 4194304;case\"ruby-text-container\":return 8388608;case\"contents\":return 16777216;case\"inline-block\":return 33554432;case\"inline-list-item\":return 67108864;case\"inline-table\":return 134217728;case\"inline-flex\":return 268435456;case\"inline-grid\":return 536870912}return 0},ut={name:\"float\",initialValue:\"none\",prefix:!1,type:2,parse:function(A,e){switch(e){case\"left\":return 1;case\"right\":return 2;case\"inline-start\":return 3;case\"inline-end\":return 4}return 0}},Ft={name:\"letter-spacing\",initialValue:\"0\",prefix:!1,type:0,parse:function(A,e){return!(20===e.type&&\"normal\"===e.value||17!==e.type&&15!==e.type)?e.number:0}},ht={name:\"line-break\",initialValue:(he=We=We||{}).NORMAL=\"normal\",prefix:!(he.STRICT=\"strict\"),type:2,parse:function(A,e){return\"strict\"!==e?We.NORMAL:We.STRICT}},dt={name:\"line-height\",initialValue:\"normal\",prefix:!1,type:4},ft={name:\"list-style-image\",initialValue:\"none\",type:0,prefix:!1,parse:function(A,e){return 20===e.type&&\"none\"===e.value?null:Oe(A,e)}},Ht={name:\"list-style-position\",initialValue:\"outside\",prefix:!1,type:2,parse:function(A,e){return\"inside\"!==e?1:0}},pt={name:\"list-style-type\",initialValue:\"none\",prefix:!1,type:2,parse:function(A,e){switch(e){case\"disc\":return 0;case\"circle\":return 1;case\"square\":return 2;case\"decimal\":return 3;case\"cjk-decimal\":return 4;case\"decimal-leading-zero\":return 5;case\"lower-roman\":return 6;case\"upper-roman\":return 7;case\"lower-greek\":return 8;case\"lower-alpha\":return 9;case\"upper-alpha\":return 10;case\"arabic-indic\":return 11;case\"armenian\":return 12;case\"bengali\":return 13;case\"cambodian\":return 14;case\"cjk-earthly-branch\":return 15;case\"cjk-heavenly-stem\":return 16;case\"cjk-ideographic\":return 17;case\"devanagari\":return 18;case\"ethiopic-numeric\":return 19;case\"georgian\":return 20;case\"gujarati\":return 21;case\"gurmukhi\":case\"hebrew\":return 22;case\"hiragana\":return 23;case\"hiragana-iroha\":return 24;case\"japanese-formal\":return 25;case\"japanese-informal\":return 26;case\"kannada\":return 27;case\"katakana\":return 28;case\"katakana-iroha\":return 29;case\"khmer\":return 30;case\"korean-hangul-formal\":return 31;case\"korean-hanja-formal\":return 32;case\"korean-hanja-informal\":return 33;case\"lao\":return 34;case\"lower-armenian\":return 35;case\"malayalam\":return 36;case\"mongolian\":return 37;case\"myanmar\":return 38;case\"oriya\":return 39;case\"persian\":return 40;case\"simp-chinese-formal\":return 41;case\"simp-chinese-informal\":return 42;case\"tamil\":return 43;case\"telugu\":return 44;case\"thai\":return 45;case\"tibetan\":return 46;case\"trad-chinese-formal\":return 47;case\"trad-chinese-informal\":return 48;case\"upper-armenian\":return 49;case\"disclosure-open\":return 50;case\"disclosure-closed\":return 51;default:return-1}}},he=function(A){return{name:\"margin-\"+A,initialValue:\"0\",prefix:!1,type:4}},Et=he(\"top\"),It=he(\"right\"),yt=he(\"bottom\"),Kt=he(\"left\"),mt={name:\"overflow\",initialValue:\"visible\",prefix:!1,type:1,parse:function(A,e){return e.filter(_A).map(function(A){switch(A.value){case\"hidden\":return 1;case\"scroll\":return 2;case\"clip\":return 3;case\"auto\":return 4;default:return 0}})}},Lt={name:\"overflow-wrap\",initialValue:\"normal\",prefix:!1,type:2,parse:function(A,e){return\"break-word\"!==e?\"normal\":\"break-word\"}},he=function(A){return{name:\"padding-\"+A,initialValue:\"0\",prefix:!1,type:3,format:\"length-percentage\"}},bt=he(\"top\"),Dt=he(\"right\"),vt=he(\"bottom\"),xt=he(\"left\"),Mt={name:\"text-align\",initialValue:\"left\",prefix:!1,type:2,parse:function(A,e){switch(e){case\"right\":return 2;case\"center\":case\"justify\":return 1;default:return 0}}},St={name:\"position\",initialValue:\"static\",prefix:!1,type:2,parse:function(A,e){switch(e){case\"relative\":return 1;case\"absolute\":return 2;case\"fixed\":return 3;case\"sticky\":return 4}return 0}},Tt={name:\"text-shadow\",initialValue:\"none\",type:1,prefix:!1,parse:function(n,A){return 1===A.length&&jA(A[0],\"none\")?[]:Ae(A).map(function(A){for(var e={color:Le.TRANSPARENT,offsetX:ae,offsetY:ae,blur:ae},t=0,r=0;r<A.length;r++){var B=A[r];ee(B)?(0===t?e.offsetX=B:1===t?e.offsetY=B:e.blur=B,t++):e.color=ue(n,B)}return e})}},Gt={name:\"text-transform\",initialValue:\"none\",prefix:!1,type:2,parse:function(A,e){switch(e){case\"uppercase\":return 2;case\"lowercase\":return 1;case\"capitalize\":return 3}return 0}},Ot={name:\"transform\",initialValue:\"none\",prefix:!0,type:0,parse:function(A,e){if(20===e.type&&\"none\"===e.value)return null;if(18!==e.type)return null;var t=Vt[e.name];if(void 0===t)throw new Error('Attempting to parse an unsupported transform function \"'+e.name+'\"');return t(e.values)}},Vt={matrix:function(A){A=A.filter(function(A){return 17===A.type}).map(function(A){return A.number});return 6===A.length?A:null},matrix3d:function(A){var e=A.filter(function(A){return 17===A.type}).map(function(A){return A.number}),t=e[0],r=e[1];e[2],e[3];var B=e[4],n=e[5];e[6],e[7],e[8],e[9],e[10],e[11];var s=e[12],A=e[13];return e[14],e[15],16===e.length?[t,r,B,n,s,A]:null}},he={type:16,number:50,flags:4},kt=[he,he],Rt={name:\"transform-origin\",initialValue:\"50% 50%\",prefix:!0,type:1,parse:function(A,e){e=e.filter(te);return 2!==e.length?kt:[e[0],e[1]]}},Nt={name:\"visible\",initialValue:\"none\",prefix:!1,type:2,parse:function(A,e){switch(e){case\"hidden\":return 1;case\"collapse\":return 2;default:return 0}}};(he=Ze=Ze||{}).NORMAL=\"normal\",he.BREAK_ALL=\"break-all\";function Pt(A,e){return 0!=(A&e)}function Xt(A,e,t){return(A=A&&A[Math.min(e,A.length-1)])?t?A.open:A.close:\"\"}var Jt={name:\"word-break\",initialValue:\"normal\",prefix:!(he.KEEP_ALL=\"keep-all\"),type:2,parse:function(A,e){switch(e){case\"break-all\":return Ze.BREAK_ALL;case\"keep-all\":return Ze.KEEP_ALL;default:return Ze.NORMAL}}},Yt={name:\"z-index\",initialValue:\"auto\",prefix:!1,type:0,parse:function(A,e){if(20===e.type)return{auto:!0,order:0};if(ZA(e))return{auto:!1,order:e.number};throw new Error(\"Invalid z-index number parsed\")}},Wt=function(A,e){if(15===e.type)switch(e.unit.toLowerCase()){case\"s\":return 1e3*e.number;case\"ms\":return e.number}throw new Error(\"Unsupported time type\")},Zt={name:\"opacity\",initialValue:\"1\",type:0,prefix:!1,parse:function(A,e){return ZA(e)?e.number:1}},_t={name:\"text-decoration-color\",initialValue:\"transparent\",prefix:!1,type:3,format:\"color\"},qt={name:\"text-decoration-line\",initialValue:\"none\",prefix:!1,type:1,parse:function(A,e){return e.filter(_A).map(function(A){switch(A.value){case\"underline\":return 1;case\"overline\":return 2;case\"line-through\":return 3;case\"none\":return 4}return 0}).filter(function(A){return 0!==A})}},jt={name:\"font-family\",initialValue:\"\",prefix:!1,type:1,parse:function(A,e){var t=[],r=[];return e.forEach(function(A){switch(A.type){case 20:case 0:t.push(A.value);break;case 17:t.push(A.number.toString());break;case 4:r.push(t.join(\" \")),t.length=0}}),t.length&&r.push(t.join(\" \")),r.map(function(A){return-1===A.indexOf(\" \")?A:\"'\"+A+\"'\"})}},zt={name:\"font-size\",initialValue:\"0\",prefix:!1,type:3,format:\"length\"},$t={name:\"font-weight\",initialValue:\"normal\",type:0,prefix:!1,parse:function(A,e){return ZA(e)?e.number:!_A(e)||\"bold\"!==e.value?400:700}},Ar={name:\"font-variant\",initialValue:\"none\",type:1,prefix:!1,parse:function(A,e){return e.filter(_A).map(function(A){return A.value})}},er={name:\"font-style\",initialValue:\"normal\",prefix:!1,type:2,parse:function(A,e){switch(e){case\"oblique\":return\"oblique\";case\"italic\":return\"italic\";default:return\"normal\"}}},tr={name:\"content\",initialValue:\"none\",type:1,prefix:!1,parse:function(A,e){if(0===e.length)return[];var t=e[0];return 20===t.type&&\"none\"===t.value?[]:e}},rr={name:\"counter-increment\",initialValue:\"none\",prefix:!0,type:1,parse:function(A,e){if(0===e.length)return null;var t=e[0];if(20===t.type&&\"none\"===t.value)return null;for(var r=[],B=e.filter(zA),n=0;n<B.length;n++){var s=B[n],o=B[n+1];20===s.type&&(o=o&&ZA(o)?o.number:1,r.push({counter:s.value,increment:o}))}return r}},Br={name:\"counter-reset\",initialValue:\"none\",prefix:!0,type:1,parse:function(A,e){if(0===e.length)return[];for(var t=[],r=e.filter(zA),B=0;B<r.length;B++){var n=r[B],s=r[B+1];_A(n)&&\"none\"!==n.value&&(s=s&&ZA(s)?s.number:0,t.push({counter:n.value,reset:s}))}return t}},nr={name:\"duration\",initialValue:\"0s\",prefix:!1,type:1,parse:function(e,A){return A.filter(WA).map(function(A){return Wt(e,A)})}},sr={name:\"quotes\",initialValue:\"none\",prefix:!0,type:1,parse:function(A,e){if(0===e.length)return null;var t=e[0];if(20===t.type&&\"none\"===t.value)return null;var r=[],B=e.filter(qA);if(B.length%2!=0)return null;for(var n=0;n<B.length;n+=2){var s=B[n].value,o=B[n+1].value;r.push({open:s,close:o})}return r}},or={name:\"box-shadow\",initialValue:\"none\",type:1,prefix:!1,parse:function(n,A){return 1===A.length&&jA(A[0],\"none\")?[]:Ae(A).map(function(A){for(var e={color:255,offsetX:ae,offsetY:ae,blur:ae,spread:ae,inset:!1},t=0,r=0;r<A.length;r++){var B=A[r];jA(B,\"inset\")?e.inset=!0:ee(B)?(0===t?e.offsetX=B:1===t?e.offsetY=B:2===t?e.blur=B:e.spread=B,t++):e.color=ue(n,B)}return e})}},ir={name:\"paint-order\",initialValue:\"normal\",prefix:!1,type:1,parse:function(A,e){var t=[];return e.filter(_A).forEach(function(A){switch(A.value){case\"stroke\":t.push(1);break;case\"fill\":t.push(0);break;case\"markers\":t.push(2)}}),[0,1,2].forEach(function(A){-1===t.indexOf(A)&&t.push(A)}),t}},Qr={name:\"-webkit-text-stroke-color\",initialValue:\"currentcolor\",prefix:!1,type:3,format:\"color\"},cr={name:\"-webkit-text-stroke-width\",initialValue:\"0\",type:0,prefix:!1,parse:function(A,e){return WA(e)?e.number:0}},ar=(gr.prototype.isVisible=function(){return 0<this.display&&0<this.opacity&&0===this.visibility},gr.prototype.isTransparent=function(){return oe(this.backgroundColor)},gr.prototype.isTransformed=function(){return null!==this.transform},gr.prototype.isPositioned=function(){return 0!==this.position},gr.prototype.isPositionedWithZIndex=function(){return this.isPositioned()&&!this.zIndex.auto},gr.prototype.isFloating=function(){return 0!==this.float},gr.prototype.isInlineLevel=function(){return Pt(this.display,4)||Pt(this.display,33554432)||Pt(this.display,268435456)||Pt(this.display,536870912)||Pt(this.display,67108864)||Pt(this.display,134217728)},gr);function gr(A,e){this.animationDuration=lr(A,nr,e.animationDuration),this.backgroundClip=lr(A,be,e.backgroundClip),this.backgroundColor=lr(A,De,e.backgroundColor),this.backgroundImage=lr(A,Re,e.backgroundImage),this.backgroundOrigin=lr(A,Ne,e.backgroundOrigin),this.backgroundPosition=lr(A,Pe,e.backgroundPosition),this.backgroundRepeat=lr(A,Xe,e.backgroundRepeat),this.backgroundSize=lr(A,_e,e.backgroundSize),this.borderTopColor=lr(A,je,e.borderTopColor),this.borderRightColor=lr(A,ze,e.borderRightColor),this.borderBottomColor=lr(A,$e,e.borderBottomColor),this.borderLeftColor=lr(A,At,e.borderLeftColor),this.borderTopLeftRadius=lr(A,et,e.borderTopLeftRadius),this.borderTopRightRadius=lr(A,tt,e.borderTopRightRadius),this.borderBottomRightRadius=lr(A,rt,e.borderBottomRightRadius),this.borderBottomLeftRadius=lr(A,Bt,e.borderBottomLeftRadius),this.borderTopStyle=lr(A,nt,e.borderTopStyle),this.borderRightStyle=lr(A,st,e.borderRightStyle),this.borderBottomStyle=lr(A,ot,e.borderBottomStyle),this.borderLeftStyle=lr(A,it,e.borderLeftStyle),this.borderTopWidth=lr(A,Qt,e.borderTopWidth),this.borderRightWidth=lr(A,ct,e.borderRightWidth),this.borderBottomWidth=lr(A,at,e.borderBottomWidth),this.borderLeftWidth=lr(A,gt,e.borderLeftWidth),this.boxShadow=lr(A,or,e.boxShadow),this.color=lr(A,wt,e.color),this.direction=lr(A,Ut,e.direction),this.display=lr(A,lt,e.display),this.float=lr(A,ut,e.cssFloat),this.fontFamily=lr(A,jt,e.fontFamily),this.fontSize=lr(A,zt,e.fontSize),this.fontStyle=lr(A,er,e.fontStyle),this.fontVariant=lr(A,Ar,e.fontVariant),this.fontWeight=lr(A,$t,e.fontWeight),this.letterSpacing=lr(A,Ft,e.letterSpacing),this.lineBreak=lr(A,ht,e.lineBreak),this.lineHeight=lr(A,dt,e.lineHeight),this.listStyleImage=lr(A,ft,e.listStyleImage),this.listStylePosition=lr(A,Ht,e.listStylePosition),this.listStyleType=lr(A,pt,e.listStyleType),this.marginTop=lr(A,Et,e.marginTop),this.marginRight=lr(A,It,e.marginRight),this.marginBottom=lr(A,yt,e.marginBottom),this.marginLeft=lr(A,Kt,e.marginLeft),this.opacity=lr(A,Zt,e.opacity);var t=lr(A,mt,e.overflow);this.overflowX=t[0],this.overflowY=t[1<t.length?1:0],this.overflowWrap=lr(A,Lt,e.overflowWrap),this.paddingTop=lr(A,bt,e.paddingTop),this.paddingRight=lr(A,Dt,e.paddingRight),this.paddingBottom=lr(A,vt,e.paddingBottom),this.paddingLeft=lr(A,xt,e.paddingLeft),this.paintOrder=lr(A,ir,e.paintOrder),this.position=lr(A,St,e.position),this.textAlign=lr(A,Mt,e.textAlign),this.textDecorationColor=lr(A,_t,null!==(t=e.textDecorationColor)&&void 0!==t?t:e.color),this.textDecorationLine=lr(A,qt,null!==(t=e.textDecorationLine)&&void 0!==t?t:e.textDecoration),this.textShadow=lr(A,Tt,e.textShadow),this.textTransform=lr(A,Gt,e.textTransform),this.transform=lr(A,Ot,e.transform),this.transformOrigin=lr(A,Rt,e.transformOrigin),this.visibility=lr(A,Nt,e.visibility),this.webkitTextStrokeColor=lr(A,Qr,e.webkitTextStrokeColor),this.webkitTextStrokeWidth=lr(A,cr,e.webkitTextStrokeWidth),this.wordBreak=lr(A,Jt,e.wordBreak),this.zIndex=lr(A,Yt,e.zIndex)}for(var wr=function(A,e){this.content=lr(A,tr,e.content),this.quotes=lr(A,sr,e.quotes)},Ur=function(A,e){this.counterIncrement=lr(A,rr,e.counterIncrement),this.counterReset=lr(A,Br,e.counterReset)},lr=function(A,e,t){var r=new PA,t=null!=t?t.toString():e.initialValue;r.write(t);var B=new JA(r.read());switch(e.type){case 2:var n=B.parseComponentValue();return e.parse(A,_A(n)?n.value:e.initialValue);case 0:return e.parse(A,B.parseComponentValue());case 1:return e.parse(A,B.parseComponentValues());case 4:return B.parseComponentValue();case 3:switch(e.format){case\"angle\":return le(A,B.parseComponentValue());case\"color\":return ue(A,B.parseComponentValue());case\"image\":return Oe(A,B.parseComponentValue());case\"length\":var s=B.parseComponentValue();return ee(s)?s:ae;case\"length-percentage\":s=B.parseComponentValue();return te(s)?s:ae;case\"time\":return Wt(A,B.parseComponentValue())}}},Cr=function(A,e){A=function(A){switch(A.getAttribute(\"data-html2canvas-debug\")){case\"all\":return 1;case\"clone\":return 2;case\"parse\":return 3;case\"render\":return 4;default:return 0}}(A);return 1===A||e===A},ur=function(A,e){this.context=A,this.textNodes=[],this.elements=[],this.flags=0,Cr(e,3),this.styles=new ar(A,window.getComputedStyle(e,null)),JB(e)&&(this.styles.animationDuration.some(function(A){return 0<A})&&(e.style.animationDuration=\"0s\"),null!==this.styles.transform&&(e.style.transform=\"none\")),this.bounds=f(this.context,e),Cr(e,4)&&(this.flags|=16)},Fr=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\",hr=\"undefined\"==typeof Uint8Array?[]:new Uint8Array(256),dr=0;dr<Fr.length;dr++)hr[Fr.charCodeAt(dr)]=dr;function fr(A,e,t){return A.slice?A.slice(e,t):new Uint16Array(Array.prototype.slice.call(A,e,t))}var Hr=(pr.prototype.get=function(A){var e;if(0<=A){if(A<55296||56319<A&&A<=65535)return e=this.index[A>>5],this.data[e=(e<<2)+(31&A)];if(A<=65535)return e=this.index[2048+(A-55296>>5)],this.data[e=(e<<2)+(31&A)];if(A<this.highStart)return e=this.index[e=2080+(A>>11)],e=this.index[e+=A>>5&63],this.data[e=(e<<2)+(31&A)];if(A<=1114111)return this.data[this.highValueIndex]}return this.errorValue},pr);function pr(A,e,t,r,B,n){this.initialValue=A,this.errorValue=e,this.highStart=t,this.highValueIndex=r,this.index=B,this.data=n}for(var Er=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\",Ir=\"undefined\"==typeof Uint8Array?[]:new Uint8Array(256),yr=0;yr<Er.length;yr++)Ir[Er.charCodeAt(yr)]=yr;function Kr(A){return kr.get(A)}function mr(A){var t=function(A){for(var e=[],t=0,r=A.length;t<r;){var B,n=A.charCodeAt(t++);55296<=n&&n<=56319&&t<r?56320==(64512&(B=A.charCodeAt(t++)))?e.push(((1023&n)<<10)+(1023&B)+65536):(e.push(n),t--):e.push(n)}return e}(A),r=t.length,B=0,n=0,s=t.map(Kr);return{next:function(){if(r<=B)return{done:!0,value:null};for(var A=Rr;B<r&&(A=function(A,e){var t=e-2,r=A[t],B=A[e-1],e=A[e];if(2===B&&3===e)return Rr;if(2===B||3===B||4===B)return\"\u00f7\";if(2===e||3===e||4===e)return\"\u00f7\";if(B===Tr&&-1!==[Tr,Gr,Or,Vr].indexOf(e))return Rr;if(!(B!==Or&&B!==Gr||e!==Gr&&10!==e))return Rr;if((B===Vr||10===B)&&10===e)return Rr;if(13===e||5===e)return Rr;if(7===e)return Rr;if(1===B)return Rr;if(13===B&&14===e){for(;5===r;)r=A[--t];if(14===r)return Rr}if(15===B&&15===e){for(var n=0;15===r;)n++,r=A[--t];if(n%2==0)return Rr}return\"\u00f7\"}(s,++B))===Rr;);if(A===Rr&&B!==r)return{done:!0,value:null};var e=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];if(String.fromCodePoint)return String.fromCodePoint.apply(String,A);var t=A.length;if(!t)return\"\";for(var r=[],B=-1,n=\"\";++B<t;){var s=A[B];s<=65535?r.push(s):(s-=65536,r.push(55296+(s>>10),s%1024+56320)),(B+1===t||16384<r.length)&&(n+=String.fromCharCode.apply(String,r),r.length=0)}return n}.apply(null,t.slice(n,B));return n=B,{value:e,done:!1}}}}function Lr(A){return 0===A[0]&&255===A[1]&&0===A[2]&&255===A[3]}var br,Dr,vr,xr,Mr,Sr,Tr=8,Gr=9,Or=11,Vr=12,kr=(vr=function(A){var e,t,r,B,n=.75*A.length,s=A.length,o=0;\"=\"===A[A.length-1]&&(n--,\"=\"===A[A.length-2]&&n--);for(var n=new(\"undefined\"!=typeof ArrayBuffer&&\"undefined\"!=typeof Uint8Array&&void 0!==Uint8Array.prototype.slice?ArrayBuffer:Array)(n),i=Array.isArray(n)?n:new Uint8Array(n),Q=0;Q<s;Q+=4)e=hr[A.charCodeAt(Q)],t=hr[A.charCodeAt(Q+1)],r=hr[A.charCodeAt(Q+2)],B=hr[A.charCodeAt(Q+3)],i[o++]=e<<2|t>>4,i[o++]=(15&t)<<4|r>>2,i[o++]=(3&r)<<6|63&B;return n}(br=\"AAAAAAAAAAAAEA4AGBkAAFAaAAACAAAAAAAIABAAGAAwADgACAAQAAgAEAAIABAACAAQAAgAEAAIABAACAAQAAgAEAAIABAAQABIAEQATAAIABAACAAQAAgAEAAIABAAVABcAAgAEAAIABAACAAQAGAAaABwAHgAgACIAI4AlgAIABAAmwCjAKgAsAC2AL4AvQDFAMoA0gBPAVYBWgEIAAgACACMANoAYgFkAWwBdAF8AX0BhQGNAZUBlgGeAaMBlQGWAasBswF8AbsBwwF0AcsBYwHTAQgA2wG/AOMBdAF8AekB8QF0AfkB+wHiAHQBfAEIAAMC5gQIAAsCEgIIAAgAFgIeAggAIgIpAggAMQI5AkACygEIAAgASAJQAlgCYAIIAAgACAAKBQoFCgUTBRMFGQUrBSsFCAAIAAgACAAIAAgACAAIAAgACABdAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACABoAmgCrwGvAQgAbgJ2AggAHgEIAAgACADnAXsCCAAIAAgAgwIIAAgACAAIAAgACACKAggAkQKZAggAPADJAAgAoQKkAqwCsgK6AsICCADJAggA0AIIAAgACAAIANYC3gIIAAgACAAIAAgACABAAOYCCAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAkASoB+QIEAAgACAA8AEMCCABCBQgACABJBVAFCAAIAAgACAAIAAgACAAIAAgACABTBVoFCAAIAFoFCABfBWUFCAAIAAgACAAIAAgAbQUIAAgACAAIAAgACABzBXsFfQWFBYoFigWKBZEFigWKBYoFmAWfBaYFrgWxBbkFCAAIAAgACAAIAAgACAAIAAgACAAIAMEFCAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAMgFCADQBQgACAAIAAgACAAIAAgACAAIAAgACAAIAO4CCAAIAAgAiQAIAAgACABAAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAD0AggACAD8AggACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIANYFCAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAMDvwAIAAgAJAIIAAgACAAIAAgACAAIAAgACwMTAwgACAB9BOsEGwMjAwgAKwMyAwsFYgE3A/MEPwMIAEUDTQNRAwgAWQOsAGEDCAAIAAgACAAIAAgACABpAzQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFOgU0BTUFNgU3BTgFOQU6BTQFNQU2BTcFOAU5BToFNAU1BTYFNwU4BTkFIQUoBSwFCAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACABtAwgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACABMAEwACAAIAAgACAAIABgACAAIAAgACAC/AAgACAAyAQgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACACAAIAAwAAgACAAIAAgACAAIAAgACAAIAAAARABIAAgACAAIABQASAAIAAgAIABwAEAAjgCIABsAqAC2AL0AigDQAtwC+IJIQqVAZUBWQqVAZUBlQGVAZUBlQGrC5UBlQGVAZUBlQGVAZUBlQGVAXsKlQGVAbAK6wsrDGUMpQzlDJUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAZUBlQGVAfAKAAuZA64AtwCJALoC6ADwAAgAuACgA/oEpgO6AqsD+AAIAAgAswMIAAgACAAIAIkAuwP5AfsBwwPLAwgACAAIAAgACADRA9kDCAAIAOED6QMIAAgACAAIAAgACADuA/YDCAAIAP4DyQAIAAgABgQIAAgAXQAOBAgACAAIAAgACAAIABMECAAIAAgACAAIAAgACAD8AAQBCAAIAAgAGgQiBCoECAExBAgAEAEIAAgACAAIAAgACAAIAAgACAAIAAgACAA4BAgACABABEYECAAIAAgATAQYAQgAVAQIAAgACAAIAAgACAAIAAgACAAIAFoECAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgAOQEIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAB+BAcACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAEABhgSMBAgACAAIAAgAlAQIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAwAEAAQABAADAAMAAwADAAQABAAEAAQABAAEAAQABHATAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgAdQMIAAgACAAIAAgACAAIAMkACAAIAAgAfQMIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACACFA4kDCAAIAAgACAAIAOcBCAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAIcDCAAIAAgACAAIAAgACAAIAAgACAAIAJEDCAAIAAgACADFAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACABgBAgAZgQIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgAbAQCBXIECAAIAHkECAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACABAAJwEQACjBKoEsgQIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAC6BMIECAAIAAgACAAIAAgACABmBAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgAxwQIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAGYECAAIAAgAzgQIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgAigWKBYoFigWKBYoFigWKBd0FXwUIAOIF6gXxBYoF3gT5BQAGCAaKBYoFigWKBYoFigWKBYoFigWKBYoFigXWBIoFigWKBYoFigWKBYoFigWKBYsFEAaKBYoFigWKBYoFigWKBRQGCACKBYoFigWKBQgACAAIANEECAAIABgGigUgBggAJgYIAC4GMwaKBYoF0wQ3Bj4GigWKBYoFigWKBYoFigWKBYoFigWKBYoFigUIAAgACAAIAAgACAAIAAgAigWKBYoFigWKBYoFigWKBYoFigWKBYoFigWKBYoFigWKBYoFigWKBYoFigWKBYoFigWKBYoFigWKBYoFigWLBf///////wQABAAEAAQABAAEAAQABAAEAAQAAwAEAAQAAgAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAAAAAAAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAQADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAAAUAAAAFAAUAAAAFAAUAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAEAAQABAAEAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUABQAFAAUABQAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUAAQAAAAUABQAFAAUABQAFAAAAAAAFAAUAAAAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAUABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAFAAUAAQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABwAFAAUABQAFAAAABwAHAAcAAAAHAAcABwAFAAEAAAAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAcABwAFAAUABQAFAAcABwAFAAUAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAAAAQABAAAAAAAAAAAAAAAFAAUABQAFAAAABwAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAHAAcABwAHAAcAAAAHAAcAAAAAAAUABQAHAAUAAQAHAAEABwAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUABwABAAUABQAFAAUAAAAAAAAAAAAAAAEAAQABAAEAAQABAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABwAFAAUAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUAAQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQABQANAAQABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQABAAEAAQABAAEAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAEAAQABAAEAAQABAAEAAQABAAEAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAQABAAEAAQABAAEAAQABAAAAAAAAAAAAAAAAAAAAAAABQAHAAUABQAFAAAAAAAAAAcABQAFAAUABQAFAAQABAAEAAQABAAEAAQABAAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUAAAAFAAUABQAFAAUAAAAFAAUABQAAAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAAAAAAAAAAAAUABQAFAAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAHAAUAAAAHAAcABwAFAAUABQAFAAUABQAFAAUABwAHAAcABwAFAAcABwAAAAUABQAFAAUABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABwAHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAUABwAHAAUABQAFAAUAAAAAAAcABwAAAAAABwAHAAUAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAABQAFAAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAAABwAHAAcABQAFAAAAAAAAAAAABQAFAAAAAAAFAAUABQAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAABwAFAAUABQAFAAUAAAAFAAUABwAAAAcABwAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAFAAUABwAFAAUABQAFAAAAAAAHAAcAAAAAAAcABwAFAAAAAAAAAAAAAAAAAAAABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAcABwAAAAAAAAAHAAcABwAAAAcABwAHAAUAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAABQAHAAcABwAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABwAHAAcABwAAAAUABQAFAAAABQAFAAUABQAAAAAAAAAAAAAAAAAAAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAcABQAHAAcABQAHAAcAAAAFAAcABwAAAAcABwAFAAUAAAAAAAAAAAAAAAAAAAAFAAUAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAcABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAAAAUABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAFAAcABwAFAAUABQAAAAUAAAAHAAcABwAHAAcABwAHAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAHAAUABQAFAAUABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAAABwAFAAUABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAUAAAAFAAAAAAAAAAAABwAHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABwAFAAUABQAFAAUAAAAFAAUAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUABQAFAAUABQAAAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABwAFAAUABQAFAAUABQAAAAUABQAHAAcABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAcABQAFAAAAAAAAAAAABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAcABQAFAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAHAAUABQAFAAUABQAFAAUABwAHAAcABwAHAAcABwAHAAUABwAHAAUABQAFAAUABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABwAHAAcABwAFAAUABwAHAAcAAAAAAAAAAAAHAAcABQAHAAcABwAHAAcABwAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAcABwAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABQAHAAUABQAFAAUABQAFAAUAAAAFAAAABQAAAAAABQAFAAUABQAFAAUABQAFAAcABwAHAAcABwAHAAUABQAFAAUABQAFAAUABQAFAAUAAAAAAAUABQAFAAUABQAHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUABwAFAAcABwAHAAcABwAFAAcABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAUABQAFAAUABwAHAAUABQAHAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAcABQAFAAcABwAHAAUABwAFAAUABQAHAAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwAHAAcABwAHAAcABwAHAAUABQAFAAUABQAFAAUABQAHAAcABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUAAAAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAcABQAFAAUABQAFAAUABQAAAAAAAAAAAAUAAAAAAAAAAAAAAAAABQAAAAAABwAFAAUAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAAABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUAAAAFAAUABQAFAAUABQAFAAUABQAFAAAAAAAAAAAABQAAAAAAAAAFAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwAHAAUABQAHAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABwAHAAcABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAUABQAFAAUABQAHAAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAcABwAFAAUABQAFAAcABwAFAAUABwAHAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAFAAcABwAFAAUABwAHAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAFAAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAFAAUABQAAAAAABQAFAAAAAAAAAAAAAAAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABQAFAAcABwAAAAAAAAAAAAAABwAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABwAFAAcABwAFAAcABwAAAAcABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAAAAAAAAAAAAAAAAAFAAUABQAAAAUABQAAAAAAAAAAAAAABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAAAAAAAAAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABQAHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABwAFAAUABQAFAAUABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwAHAAcABQAFAAUABQAFAAUABQAFAAUABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAcABwAFAAUABQAHAAcABQAHAAUABQAAAAAAAAAAAAAAAAAFAAAABwAHAAcABQAFAAUABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABwAHAAcABwAAAAAABwAHAAAAAAAHAAcABwAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAABwAHAAAAAAAFAAUABQAFAAUABQAFAAAAAAAAAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAcABwAFAAUABQAFAAUABQAFAAUABwAHAAUABQAFAAcABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAHAAcABQAFAAUABQAFAAUABwAFAAcABwAFAAcABQAFAAcABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAHAAcABQAFAAUABQAAAAAABwAHAAcABwAFAAUABwAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABwAHAAUABQAFAAUABQAFAAUABQAHAAcABQAHAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABwAFAAcABwAFAAUABQAFAAUABQAHAAUAAAAAAAAAAAAAAAAAAAAAAAcABwAFAAUABQAFAAcABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAcABwAFAAUABQAFAAUABQAFAAUABQAHAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAcABwAFAAUABQAFAAAAAAAFAAUABwAHAAcABwAFAAAAAAAAAAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUABwAHAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABQAFAAUABQAFAAUABQAAAAUABQAFAAUABQAFAAcABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAAAHAAUABQAFAAUABQAFAAUABwAFAAUABwAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUAAAAAAAAABQAAAAUABQAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAHAAcABwAHAAcAAAAFAAUAAAAHAAcABQAHAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABwAHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAAAAAAAAAAAAAAAAAAABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAAAAUABQAFAAAAAAAFAAUABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAAAAAAAAAAABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUABQAFAAUABQAAAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUABQAAAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAAAAABQAFAAUABQAFAAUABQAAAAUABQAAAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAUABQAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAFAAUABQAFAAUABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAFAAUABQAFAAUADgAOAA4ADgAOAA4ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwAHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAAAAAAAAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAMAAwADAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAAAAAAAAAAAAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAKAAoACgAAAAAAAAAAAAsADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwACwAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAAAAAADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAA4ADgAOAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4ADgAAAAAAAAAAAAAAAAAAAAAADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAA4ADgAOAA4ADgAOAA4ADgAOAAAAAAAAAAAADgAOAA4AAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAAAAAAAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAA4ADgAAAA4ADgAOAA4ADgAOAAAADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4AAAAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4AAAAAAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAAAA4AAAAOAAAAAAAAAAAAAAAAAA4AAAAAAAAAAAAAAAAADgAAAAAAAAAAAAAAAAAAAAAAAAAAAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAAAAAADgAAAAAAAAAAAA4AAAAOAAAAAAAAAAAADgAOAA4AAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAA4ADgAOAA4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAA4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4ADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAAAAAAAAAAAA4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAAAADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4ADgAOAA4ADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAAAAAADgAOAA4ADgAOAA4ADgAOAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAAAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4AAAAAAA4ADgAOAA4ADgAOAA4ADgAOAAAADgAOAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4AAAAAAAAAAAAAAAAADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAA4ADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAA4ADgAOAA4ADgAOAAAAAAAAAAAAAAAAAAAAAAAAAAAADgAOAA4ADgAOAA4AAAAAAAAAAAAAAAAAAAAAAA4ADgAOAA4ADgAOAA4ADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4AAAAOAA4ADgAOAA4ADgAAAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4AAAAAAAAAAAA=\"),xr=Array.isArray(vr)?function(A){for(var e=A.length,t=[],r=0;r<e;r+=4)t.push(A[r+3]<<24|A[r+2]<<16|A[r+1]<<8|A[r]);return t}(vr):new Uint32Array(vr),Mr=Array.isArray(vr)?function(A){for(var e=A.length,t=[],r=0;r<e;r+=2)t.push(A[r+1]<<8|A[r]);return t}(vr):new Uint16Array(vr),br=fr(Mr,12,xr[4]/2),Dr=2===xr[5]?fr(Mr,(24+xr[4])/2):(vr=xr,Mr=Math.ceil((24+xr[4])/4),vr.slice?vr.slice(Mr,Dr):new Uint32Array(Array.prototype.slice.call(vr,Mr,Dr))),new Hr(xr[0],xr[1],xr[2],xr[3],br,Dr)),Rr=\"\u00d7\",Nr=function(A,e,t,r,B){var n=\"http://www.w3.org/2000/svg\",s=document.createElementNS(n,\"svg\"),n=document.createElementNS(n,\"foreignObject\");return s.setAttributeNS(null,\"width\",A.toString()),s.setAttributeNS(null,\"height\",e.toString()),n.setAttributeNS(null,\"width\",\"100%\"),n.setAttributeNS(null,\"height\",\"100%\"),n.setAttributeNS(null,\"x\",t.toString()),n.setAttributeNS(null,\"y\",r.toString()),n.setAttributeNS(null,\"externalResourcesRequired\",\"true\"),s.appendChild(n),n.appendChild(B),s},Pr=function(r){return new Promise(function(A,e){var t=new Image;t.onload=function(){return A(t)},t.onerror=e,t.src=\"data:image/svg+xml;charset=utf-8,\"+encodeURIComponent((new XMLSerializer).serializeToString(r))})},Xr={get SUPPORT_RANGE_BOUNDS(){var A=function(A){if(A.createRange){var e=A.createRange();if(e.getBoundingClientRect){var t=A.createElement(\"boundtest\");t.style.height=\"123px\",t.style.display=\"block\",A.body.appendChild(t),e.selectNode(t);e=e.getBoundingClientRect(),e=Math.round(e.height);if(A.body.removeChild(t),123===e)return!0}}return!1}(document);return Object.defineProperty(Xr,\"SUPPORT_RANGE_BOUNDS\",{value:A}),A},get SUPPORT_WORD_BREAKING(){var A=Xr.SUPPORT_RANGE_BOUNDS&&function(A){var e=A.createElement(\"boundtest\");e.style.width=\"50px\",e.style.display=\"block\",e.style.fontSize=\"12px\",e.style.letterSpacing=\"0px\",e.style.wordSpacing=\"0px\",A.body.appendChild(e);var r=A.createRange();e.innerHTML=\"function\"==typeof\"\".repeat?\"&#128104;\".repeat(10):\"\";var B=e.firstChild,t=Q(B.data).map(function(A){return g(A)}),n=0,s={},t=t.every(function(A,e){r.setStart(B,n),r.setEnd(B,n+A.length);var t=r.getBoundingClientRect();n+=A.length;A=t.x>s.x||t.y>s.y;return s=t,0===e||A});return A.body.removeChild(e),t}(document);return Object.defineProperty(Xr,\"SUPPORT_WORD_BREAKING\",{value:A}),A},get SUPPORT_SVG_DRAWING(){var A=function(A){var e=new Image,t=A.createElement(\"canvas\"),A=t.getContext(\"2d\");if(!A)return!1;e.src=\"data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg'></svg>\";try{A.drawImage(e,0,0),t.toDataURL()}catch(A){return!1}return!0}(document);return Object.defineProperty(Xr,\"SUPPORT_SVG_DRAWING\",{value:A}),A},get SUPPORT_FOREIGNOBJECT_DRAWING(){var A=\"function\"==typeof Array.from&&\"function\"==typeof window.fetch?function(t){var A=t.createElement(\"canvas\"),r=100;A.width=r,A.height=r;var B=A.getContext(\"2d\");if(!B)return Promise.reject(!1);B.fillStyle=\"rgb(0, 255, 0)\",B.fillRect(0,0,r,r);var e=new Image,n=A.toDataURL();e.src=n;e=Nr(r,r,0,0,e);return B.fillStyle=\"red\",B.fillRect(0,0,r,r),Pr(e).then(function(A){B.drawImage(A,0,0);var e=B.getImageData(0,0,r,r).data;B.fillStyle=\"red\",B.fillRect(0,0,r,r);A=t.createElement(\"div\");return A.style.backgroundImage=\"url(\"+n+\")\",A.style.height=\"100px\",Lr(e)?Pr(Nr(r,r,0,0,A)):Promise.reject(!1)}).then(function(A){return B.drawImage(A,0,0),Lr(B.getImageData(0,0,r,r).data)}).catch(function(){return!1})}(document):Promise.resolve(!1);return Object.defineProperty(Xr,\"SUPPORT_FOREIGNOBJECT_DRAWING\",{value:A}),A},get SUPPORT_CORS_IMAGES(){var A=void 0!==(new Image).crossOrigin;return Object.defineProperty(Xr,\"SUPPORT_CORS_IMAGES\",{value:A}),A},get SUPPORT_RESPONSE_TYPE(){var A=\"string\"==typeof(new XMLHttpRequest).responseType;return Object.defineProperty(Xr,\"SUPPORT_RESPONSE_TYPE\",{value:A}),A},get SUPPORT_CORS_XHR(){var A=\"withCredentials\"in new XMLHttpRequest;return Object.defineProperty(Xr,\"SUPPORT_CORS_XHR\",{value:A}),A},get SUPPORT_NATIVE_TEXT_SEGMENTATION(){var A=!(\"undefined\"==typeof Intl||!Intl.Segmenter);return Object.defineProperty(Xr,\"SUPPORT_NATIVE_TEXT_SEGMENTATION\",{value:A}),A}},Jr=function(A,e){this.text=A,this.bounds=e},Yr=function(A,e){var t=e.ownerDocument;if(t){var r=t.createElement(\"html2canvaswrapper\");r.appendChild(e.cloneNode(!0));t=e.parentNode;if(t){t.replaceChild(r,e);A=f(A,r);return r.firstChild&&t.replaceChild(r.firstChild,r),A}}return d.EMPTY},Wr=function(A,e,t){var r=A.ownerDocument;if(!r)throw new Error(\"Node has no owner document\");r=r.createRange();return r.setStart(A,e),r.setEnd(A,e+t),r},Zr=function(A){if(Xr.SUPPORT_NATIVE_TEXT_SEGMENTATION){var e=new Intl.Segmenter(void 0,{granularity:\"grapheme\"});return Array.from(e.segment(A)).map(function(A){return A.segment})}return function(A){for(var e,t=mr(A),r=[];!(e=t.next()).done;)e.value&&r.push(e.value.slice());return r}(A)},_r=function(A,e){return 0!==e.letterSpacing?Zr(A):function(A,e){if(Xr.SUPPORT_NATIVE_TEXT_SEGMENTATION){var t=new Intl.Segmenter(void 0,{granularity:\"word\"});return Array.from(t.segment(A)).map(function(A){return A.segment})}return jr(A,e)}(A,e)},qr=[32,160,4961,65792,65793,4153,4241],jr=function(A,e){for(var t,r=wA(A,{lineBreak:e.lineBreak,wordBreak:\"break-word\"===e.overflowWrap?\"break-word\":e.wordBreak}),B=[];!(t=r.next()).done;)!function(){var A,e;t.value&&(A=t.value.slice(),A=Q(A),e=\"\",A.forEach(function(A){-1===qr.indexOf(A)?e+=g(A):(e.length&&B.push(e),B.push(g(A)),e=\"\")}),e.length&&B.push(e))}();return B},zr=function(A,e,t){var B,n,s,o,i;this.text=$r(e.data,t.textTransform),this.textBounds=(B=A,A=this.text,s=e,A=_r(A,n=t),o=[],i=0,A.forEach(function(A){var e,t,r;n.textDecorationLine.length||0<A.trim().length?Xr.SUPPORT_RANGE_BOUNDS?1<(r=Wr(s,i,A.length).getClientRects()).length?(e=Zr(A),t=0,e.forEach(function(A){o.push(new Jr(A,d.fromDOMRectList(B,Wr(s,t+i,A.length).getClientRects()))),t+=A.length})):o.push(new Jr(A,d.fromDOMRectList(B,r))):(r=s.splitText(A.length),o.push(new Jr(A,Yr(B,s))),s=r):Xr.SUPPORT_RANGE_BOUNDS||(s=s.splitText(A.length)),i+=A.length}),o)},$r=function(A,e){switch(e){case 1:return A.toLowerCase();case 3:return A.replace(AB,eB);case 2:return A.toUpperCase();default:return A}},AB=/(^|\\s|:|-|\\(|\\))([a-z])/g,eB=function(A,e,t){return 0<A.length?e+t.toUpperCase():A},tB=(A(rB,Sr=ur),rB);function rB(A,e){A=Sr.call(this,A,e)||this;return A.src=e.currentSrc||e.src,A.intrinsicWidth=e.naturalWidth,A.intrinsicHeight=e.naturalHeight,A.context.cache.addImage(A.src),A}var BB,nB=(A(sB,BB=ur),sB);function sB(A,e){A=BB.call(this,A,e)||this;return A.canvas=e,A.intrinsicWidth=e.width,A.intrinsicHeight=e.height,A}var oB,iB=(A(QB,oB=ur),QB);function QB(A,e){var t=oB.call(this,A,e)||this,r=new XMLSerializer,A=f(A,e);return e.setAttribute(\"width\",A.width+\"px\"),e.setAttribute(\"height\",A.height+\"px\"),t.svg=\"data:image/svg+xml,\"+encodeURIComponent(r.serializeToString(e)),t.intrinsicWidth=e.width.baseVal.value,t.intrinsicHeight=e.height.baseVal.value,t.context.cache.addImage(t.svg),t}var cB,aB=(A(gB,cB=ur),gB);function gB(A,e){A=cB.call(this,A,e)||this;return A.value=e.value,A}var wB,UB=(A(lB,wB=ur),lB);function lB(A,e){A=wB.call(this,A,e)||this;return A.start=e.start,A.reversed=\"boolean\"==typeof e.reversed&&!0===e.reversed,A}var CB,uB=[{type:15,flags:0,unit:\"px\",number:3}],FB=[{type:16,flags:0,number:50}],hB=\"checkbox\",dB=\"radio\",fB=\"password\",HB=707406591,pB=(A(EB,CB=ur),EB);function EB(A,e){var t=CB.call(this,A,e)||this;switch(t.type=e.type.toLowerCase(),t.checked=e.checked,t.value=0===(e=(A=e).type===fB?new Array(A.value.length+1).join(\"\u2022\"):A.value).length?A.placeholder||\"\":e,t.type!==hB&&t.type!==dB||(t.styles.backgroundColor=3739148031,t.styles.borderTopColor=t.styles.borderRightColor=t.styles.borderBottomColor=t.styles.borderLeftColor=2779096575,t.styles.borderTopWidth=t.styles.borderRightWidth=t.styles.borderBottomWidth=t.styles.borderLeftWidth=1,t.styles.borderTopStyle=t.styles.borderRightStyle=t.styles.borderBottomStyle=t.styles.borderLeftStyle=1,t.styles.backgroundClip=[0],t.styles.backgroundOrigin=[0],t.bounds=(e=t.bounds).width>e.height?new d(e.left+(e.width-e.height)/2,e.top,e.height,e.height):e.width<e.height?new d(e.left,e.top+(e.height-e.width)/2,e.width,e.width):e),t.type){case hB:t.styles.borderTopRightRadius=t.styles.borderTopLeftRadius=t.styles.borderBottomRightRadius=t.styles.borderBottomLeftRadius=uB;break;case dB:t.styles.borderTopRightRadius=t.styles.borderTopLeftRadius=t.styles.borderBottomRightRadius=t.styles.borderBottomLeftRadius=FB}return t}var IB,yB=(A(KB,IB=ur),KB);function KB(A,e){A=IB.call(this,A,e)||this,e=e.options[e.selectedIndex||0];return A.value=e&&e.text||\"\",A}var mB,LB=(A(bB,mB=ur),bB);function bB(A,e){A=mB.call(this,A,e)||this;return A.value=e.value,A}var DB,vB=(A(xB,DB=ur),xB);function xB(A,e){var t,r,B=DB.call(this,A,e)||this;B.src=e.src,B.width=parseInt(e.width,10)||0,B.height=parseInt(e.height,10)||0,B.backgroundColor=B.styles.backgroundColor;try{e.contentWindow&&e.contentWindow.document&&e.contentWindow.document.documentElement&&(B.tree=kB(A,e.contentWindow.document.documentElement),t=e.contentWindow.document.documentElement?fe(A,getComputedStyle(e.contentWindow.document.documentElement).backgroundColor):Le.TRANSPARENT,r=e.contentWindow.document.body?fe(A,getComputedStyle(e.contentWindow.document.body).backgroundColor):Le.TRANSPARENT,B.backgroundColor=oe(t)?oe(r)?B.styles.backgroundColor:r:t)}catch(A){}return B}function MB(A){return\"VIDEO\"===A.tagName}function SB(A){return\"STYLE\"===A.tagName}function TB(A){return 0<A.tagName.indexOf(\"-\")}var GB=[\"OL\",\"UL\",\"MENU\"],OB=function(e,A,t,r){for(var B=A.firstChild;B;B=s){var n,s=B.nextSibling;PB(B)&&0<B.data.trim().length?t.textNodes.push(new zr(e,B,t.styles)):XB(B)&&(rn(B)&&B.assignedNodes?B.assignedNodes().forEach(function(A){return OB(e,A,t,r)}):(n=VB(e,B)).styles.isVisible()&&(RB(B,n,r)?n.flags|=4:NB(n.styles)&&(n.flags|=2),-1!==GB.indexOf(B.tagName)&&(n.flags|=8),t.elements.push(n),B.slot,B.shadowRoot?OB(e,B.shadowRoot,n,r):en(B)||qB(B)||tn(B)||OB(e,B,n,r)))}},VB=function(A,e){return new($B(e)?tB:zB(e)?nB:qB(e)?iB:WB(e)?aB:ZB(e)?UB:_B(e)?pB:tn(e)?yB:en(e)?LB:An(e)?vB:ur)(A,e)},kB=function(A,e){var t=VB(A,e);return t.flags|=4,OB(A,e,t,t),t},RB=function(A,e,t){return e.styles.isPositionedWithZIndex()||e.styles.opacity<1||e.styles.isTransformed()||jB(A)&&t.styles.isTransparent()},NB=function(A){return A.isPositioned()||A.isFloating()},PB=function(A){return A.nodeType===Node.TEXT_NODE},XB=function(A){return A.nodeType===Node.ELEMENT_NODE},JB=function(A){return XB(A)&&void 0!==A.style&&!YB(A)},YB=function(A){return\"object\"==typeof A.className},WB=function(A){return\"LI\"===A.tagName},ZB=function(A){return\"OL\"===A.tagName},_B=function(A){return\"INPUT\"===A.tagName},qB=function(A){return\"svg\"===A.tagName},jB=function(A){return\"BODY\"===A.tagName},zB=function(A){return\"CANVAS\"===A.tagName},$B=function(A){return\"IMG\"===A.tagName},An=function(A){return\"IFRAME\"===A.tagName},en=function(A){return\"TEXTAREA\"===A.tagName},tn=function(A){return\"SELECT\"===A.tagName},rn=function(A){return\"SLOT\"===A.tagName},Bn=(nn.prototype.getCounterValue=function(A){A=this.counters[A];return A&&A.length?A[A.length-1]:1},nn.prototype.getCounterValues=function(A){A=this.counters[A];return A||[]},nn.prototype.pop=function(A){var e=this;A.forEach(function(A){return e.counters[A].pop()})},nn.prototype.parse=function(A){var t=this,e=A.counterIncrement,A=A.counterReset,r=!0;null!==e&&e.forEach(function(A){var e=t.counters[A.counter];e&&0!==A.increment&&(r=!1,e.length||e.push(1),e[Math.max(0,e.length-1)]+=A.increment)});var B=[];return r&&A.forEach(function(A){var e=t.counters[A.counter];B.push(A.counter),(e=e||(t.counters[A.counter]=[])).push(A.reset)}),B},nn);function nn(){this.counters={}}function sn(r,A,e,B,t,n){return r<A||e<r?Fn(r,t,0<n.length):B.integers.reduce(function(A,e,t){for(;e<=r;)r-=e,A+=B.values[t];return A},\"\")+n}function on(A,e,t,r){for(var B=\"\";t||A--,B=r(A)+B,e<=(A/=e)*e;);return B}function Qn(A,e,t,r,B){var n=t-e+1;return(A<0?\"-\":\"\")+(on(Math.abs(A),n,r,function(A){return g(Math.floor(A%n)+e)})+B)}function cn(A,e,t){void 0===t&&(t=\". \");var r=e.length;return on(Math.abs(A),r,!1,function(A){return e[Math.floor(A%r)]})+t}function an(A,e,t,r,B,n){if(A<-9999||9999<A)return Fn(A,4,0<B.length);var s=Math.abs(A),o=B;if(0===s)return e[0]+o;for(var i=0;0<s&&i<=4;i++){var Q=s%10;0==Q&&Pt(n,1)&&\"\"!==o?o=e[Q]+o:1<Q||1==Q&&0===i||1==Q&&1===i&&Pt(n,2)||1==Q&&1===i&&Pt(n,4)&&100<A||1==Q&&1<i&&Pt(n,8)?o=e[Q]+(0<i?t[i-1]:\"\")+o:1==Q&&0<i&&(o=t[i-1]+o),s=Math.floor(s/10)}return(A<0?r:\"\")+o}var gn,wn={integers:[1e3,900,500,400,100,90,50,40,10,9,5,4,1],values:[\"M\",\"CM\",\"D\",\"CD\",\"C\",\"XC\",\"L\",\"XL\",\"X\",\"IX\",\"V\",\"IV\",\"I\"]},Un={integers:[9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,900,800,700,600,500,400,300,200,100,90,80,70,60,50,40,30,20,10,9,8,7,6,5,4,3,2,1],values:[\"\u0554\",\"\u0553\",\"\u0552\",\"\u0551\",\"\u0550\",\"\u054f\",\"\u054e\",\"\u054d\",\"\u054c\",\"\u054b\",\"\u054a\",\"\u0549\",\"\u0548\",\"\u0547\",\"\u0546\",\"\u0545\",\"\u0544\",\"\u0543\",\"\u0542\",\"\u0541\",\"\u0540\",\"\u053f\",\"\u053e\",\"\u053d\",\"\u053c\",\"\u053b\",\"\u053a\",\"\u0539\",\"\u0538\",\"\u0537\",\"\u0536\",\"\u0535\",\"\u0534\",\"\u0533\",\"\u0532\",\"\u0531\"]},ln={integers:[1e4,9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,400,300,200,100,90,80,70,60,50,40,30,20,19,18,17,16,15,10,9,8,7,6,5,4,3,2,1],values:[\"\u05d9\u05f3\",\"\u05d8\u05f3\",\"\u05d7\u05f3\",\"\u05d6\u05f3\",\"\u05d5\u05f3\",\"\u05d4\u05f3\",\"\u05d3\u05f3\",\"\u05d2\u05f3\",\"\u05d1\u05f3\",\"\u05d0\u05f3\",\"\u05ea\",\"\u05e9\",\"\u05e8\",\"\u05e7\",\"\u05e6\",\"\u05e4\",\"\u05e2\",\"\u05e1\",\"\u05e0\",\"\u05de\",\"\u05dc\",\"\u05db\",\"\u05d9\u05d8\",\"\u05d9\u05d7\",\"\u05d9\u05d6\",\"\u05d8\u05d6\",\"\u05d8\u05d5\",\"\u05d9\",\"\u05d8\",\"\u05d7\",\"\u05d6\",\"\u05d5\",\"\u05d4\",\"\u05d3\",\"\u05d2\",\"\u05d1\",\"\u05d0\"]},Cn={integers:[1e4,9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,900,800,700,600,500,400,300,200,100,90,80,70,60,50,40,30,20,10,9,8,7,6,5,4,3,2,1],values:[\"\u10f5\",\"\u10f0\",\"\u10ef\",\"\u10f4\",\"\u10ee\",\"\u10ed\",\"\u10ec\",\"\u10eb\",\"\u10ea\",\"\u10e9\",\"\u10e8\",\"\u10e7\",\"\u10e6\",\"\u10e5\",\"\u10e4\",\"\u10f3\",\"\u10e2\",\"\u10e1\",\"\u10e0\",\"\u10df\",\"\u10de\",\"\u10dd\",\"\u10f2\",\"\u10dc\",\"\u10db\",\"\u10da\",\"\u10d9\",\"\u10d8\",\"\u10d7\",\"\u10f1\",\"\u10d6\",\"\u10d5\",\"\u10d4\",\"\u10d3\",\"\u10d2\",\"\u10d1\",\"\u10d0\"]},un=\"\ub9c8\uc774\ub108\uc2a4\",Fn=function(A,e,t){var r=t?\". \":\"\",B=t?\"\u3001\":\"\",n=t?\", \":\"\",s=t?\" \":\"\";switch(e){case 0:return\"\u2022\"+s;case 1:return\"\u25e6\"+s;case 2:return\"\u25fe\"+s;case 5:var o=Qn(A,48,57,!0,r);return o.length<4?\"0\"+o:o;case 4:return cn(A,\"\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\",B);case 6:return sn(A,1,3999,wn,3,r).toLowerCase();case 7:return sn(A,1,3999,wn,3,r);case 8:return Qn(A,945,969,!1,r);case 9:return Qn(A,97,122,!1,r);case 10:return Qn(A,65,90,!1,r);case 11:return Qn(A,1632,1641,!0,r);case 12:case 49:return sn(A,1,9999,Un,3,r);case 35:return sn(A,1,9999,Un,3,r).toLowerCase();case 13:return Qn(A,2534,2543,!0,r);case 14:case 30:return Qn(A,6112,6121,!0,r);case 15:return cn(A,\"\u5b50\u4e11\u5bc5\u536f\u8fb0\u5df3\u5348\u672a\u7533\u9149\u620c\u4ea5\",B);case 16:return cn(A,\"\u7532\u4e59\u4e19\u4e01\u620a\u5df1\u5e9a\u8f9b\u58ec\u7678\",B);case 17:case 48:return an(A,\"\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\",\"\u5341\u767e\u5343\u842c\",\"\u8ca0\",B,14);case 47:return an(A,\"\u96f6\u58f9\u8cb3\u53c3\u8086\u4f0d\u9678\u67d2\u634c\u7396\",\"\u62fe\u4f70\u4edf\u842c\",\"\u8ca0\",B,15);case 42:return an(A,\"\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\",\"\u5341\u767e\u5343\u842c\",\"\u8d1f\",B,14);case 41:return an(A,\"\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\",\"\u62fe\u4f70\u4edf\u842c\",\"\u8d1f\",B,15);case 26:return an(A,\"\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\",\"\u5341\u767e\u5343\u4e07\",\"\u30de\u30a4\u30ca\u30b9\",B,0);case 25:return an(A,\"\u96f6\u58f1\u5f10\u53c2\u56db\u4f0d\u516d\u4e03\u516b\u4e5d\",\"\u62fe\u767e\u5343\u4e07\",\"\u30de\u30a4\u30ca\u30b9\",B,7);case 31:return an(A,\"\uc601\uc77c\uc774\uc0bc\uc0ac\uc624\uc721\uce60\ud314\uad6c\",\"\uc2ed\ubc31\ucc9c\ub9cc\",un,n,7);case 33:return an(A,\"\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\",\"\u5341\u767e\u5343\u842c\",un,n,0);case 32:return an(A,\"\u96f6\u58f9\u8cb3\u53c3\u56db\u4e94\u516d\u4e03\u516b\u4e5d\",\"\u62fe\u767e\u5343\",un,n,7);case 18:return Qn(A,2406,2415,!0,r);case 20:return sn(A,1,19999,Cn,3,r);case 21:return Qn(A,2790,2799,!0,r);case 22:return Qn(A,2662,2671,!0,r);case 22:return sn(A,1,10999,ln,3,r);case 23:return cn(A,\"\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3090\u3091\u3092\u3093\");case 24:return cn(A,\"\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059\");case 27:return Qn(A,3302,3311,!0,r);case 28:return cn(A,\"\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30f3\",B);case 29:return cn(A,\"\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9\",B);case 34:return Qn(A,3792,3801,!0,r);case 37:return Qn(A,6160,6169,!0,r);case 38:return Qn(A,4160,4169,!0,r);case 39:return Qn(A,2918,2927,!0,r);case 40:return Qn(A,1776,1785,!0,r);case 43:return Qn(A,3046,3055,!0,r);case 44:return Qn(A,3174,3183,!0,r);case 45:return Qn(A,3664,3673,!0,r);case 46:return Qn(A,3872,3881,!0,r);default:return Qn(A,48,57,!0,r)}},hn=\"data-html2canvas-ignore\",dn=(fn.prototype.toIFrame=function(A,r){var e=this,B=pn(A,r);if(!B.contentWindow)return Promise.reject(\"Unable to find iframe window\");var t=A.defaultView.pageXOffset,n=A.defaultView.pageYOffset,s=B.contentWindow,o=s.document,A=In(B).then(function(){return a(e,void 0,void 0,function(){var e,t;return H(this,function(A){switch(A.label){case 0:return this.scrolledElements.forEach(bn),s&&(s.scrollTo(r.left,r.top),!/(iPad|iPhone|iPod)/g.test(navigator.userAgent)||s.scrollY===r.top&&s.scrollX===r.left||(this.context.logger.warn(\"Unable to restore scroll position for cloned document\"),this.context.windowBounds=this.context.windowBounds.add(s.scrollX-r.left,s.scrollY-r.top,0,0))),e=this.options.onclone,void 0===(t=this.clonedReferenceElement)?[2,Promise.reject(\"Error finding the \"+this.referenceElement.nodeName+\" in the cloned document\")]:o.fonts&&o.fonts.ready?[4,o.fonts.ready]:[3,2];case 1:A.sent(),A.label=2;case 2:return/(AppleWebKit)/g.test(navigator.userAgent)?[4,En(o)]:[3,4];case 3:A.sent(),A.label=4;case 4:return\"function\"==typeof e?[2,Promise.resolve().then(function(){return e(o,t)}).then(function(){return B})]:[2,B]}})})});return o.open(),o.write(mn(document.doctype)+\"<html></html>\"),Ln(this.referenceElement.ownerDocument,t,n),o.replaceChild(o.adoptNode(this.documentElement),o.documentElement),o.close(),A},fn.prototype.createElementClone=function(A){if(Cr(A,2),zB(A))return this.createCanvasClone(A);if(MB(A))return this.createVideoClone(A);if(SB(A))return this.createStyleClone(A);var e=A.cloneNode(!1);return $B(e)&&($B(A)&&A.currentSrc&&A.currentSrc!==A.src&&(e.src=A.currentSrc,e.srcset=\"\"),\"lazy\"===e.loading&&(e.loading=\"eager\")),TB(e)?this.createCustomElementClone(e):e},fn.prototype.createCustomElementClone=function(A){var e=document.createElement(\"html2canvascustomelement\");return Kn(A.style,e),e},fn.prototype.createStyleClone=function(A){try{var e=A.sheet;if(e&&e.cssRules){var t=[].slice.call(e.cssRules,0).reduce(function(A,e){return e&&\"string\"==typeof e.cssText?A+e.cssText:A},\"\"),r=A.cloneNode(!1);return r.textContent=t,r}}catch(A){if(this.context.logger.error(\"Unable to access cssRules property\",A),\"SecurityError\"!==A.name)throw A}return A.cloneNode(!1)},fn.prototype.createCanvasClone=function(e){var A;if(this.options.inlineImages&&e.ownerDocument){var t=e.ownerDocument.createElement(\"img\");try{return t.src=e.toDataURL(),t}catch(A){this.context.logger.info(\"Unable to inline canvas contents, canvas is tainted\",e)}}t=e.cloneNode(!1);try{t.width=e.width,t.height=e.height;var r,B,n=e.getContext(\"2d\"),s=t.getContext(\"2d\");return s&&(!this.options.allowTaint&&n?s.putImageData(n.getImageData(0,0,e.width,e.height),0,0):(!(r=null!==(A=e.getContext(\"webgl2\"))&&void 0!==A?A:e.getContext(\"webgl\"))||!1===(null==(B=r.getContextAttributes())?void 0:B.preserveDrawingBuffer)&&this.context.logger.warn(\"Unable to clone WebGL context as it has preserveDrawingBuffer=false\",e),s.drawImage(e,0,0))),t}catch(A){this.context.logger.info(\"Unable to clone canvas as it is tainted\",e)}return t},fn.prototype.createVideoClone=function(e){var A=e.ownerDocument.createElement(\"canvas\");A.width=e.offsetWidth,A.height=e.offsetHeight;var t=A.getContext(\"2d\");try{return t&&(t.drawImage(e,0,0,A.width,A.height),this.options.allowTaint||t.getImageData(0,0,A.width,A.height)),A}catch(A){this.context.logger.info(\"Unable to clone video as it is tainted\",e)}A=e.ownerDocument.createElement(\"canvas\");return A.width=e.offsetWidth,A.height=e.offsetHeight,A},fn.prototype.appendChildNode=function(A,e,t){XB(e)&&(\"SCRIPT\"===e.tagName||e.hasAttribute(hn)||\"function\"==typeof this.options.ignoreElements&&this.options.ignoreElements(e))||this.options.copyStyles&&XB(e)&&SB(e)||A.appendChild(this.cloneNode(e,t))},fn.prototype.cloneChildNodes=function(A,e,t){for(var r,B=this,n=(A.shadowRoot||A).firstChild;n;n=n.nextSibling)XB(n)&&rn(n)&&\"function\"==typeof n.assignedNodes?(r=n.assignedNodes()).length&&r.forEach(function(A){return B.appendChildNode(e,A,t)}):this.appendChildNode(e,n,t)},fn.prototype.cloneNode=function(A,e){if(PB(A))return document.createTextNode(A.data);if(!A.ownerDocument)return A.cloneNode(!1);var t=A.ownerDocument.defaultView;if(t&&XB(A)&&(JB(A)||YB(A))){var r=this.createElementClone(A);r.style.transitionProperty=\"none\";var B=t.getComputedStyle(A),n=t.getComputedStyle(A,\":before\"),s=t.getComputedStyle(A,\":after\");this.referenceElement===A&&JB(r)&&(this.clonedReferenceElement=r),jB(r)&&Mn(r);t=this.counters.parse(new Ur(this.context,B)),n=this.resolvePseudoContent(A,r,n,gn.BEFORE);TB(A)&&(e=!0),MB(A)||this.cloneChildNodes(A,r,e),n&&r.insertBefore(n,r.firstChild);s=this.resolvePseudoContent(A,r,s,gn.AFTER);return s&&r.appendChild(s),this.counters.pop(t),(B&&(this.options.copyStyles||YB(A))&&!An(A)||e)&&Kn(B,r),0===A.scrollTop&&0===A.scrollLeft||this.scrolledElements.push([r,A.scrollLeft,A.scrollTop]),(en(A)||tn(A))&&(en(r)||tn(r))&&(r.value=A.value),r}return A.cloneNode(!1)},fn.prototype.resolvePseudoContent=function(o,A,e,t){var i=this;if(e){var r=e.content,Q=A.ownerDocument;if(Q&&r&&\"none\"!==r&&\"-moz-alt-content\"!==r&&\"none\"!==e.display){this.counters.parse(new Ur(this.context,e));var c=new wr(this.context,e),a=Q.createElement(\"html2canvaspseudoelement\");Kn(e,a),c.content.forEach(function(A){if(0===A.type)a.appendChild(Q.createTextNode(A.value));else if(22===A.type){var e=Q.createElement(\"img\");e.src=A.value,e.style.opacity=\"1\",a.appendChild(e)}else if(18===A.type){var t,r,B,n,s;\"attr\"===A.name?(e=A.values.filter(_A)).length&&a.appendChild(Q.createTextNode(o.getAttribute(e[0].value)||\"\")):\"counter\"===A.name?(B=(r=A.values.filter($A))[0],r=r[1],B&&_A(B)&&(t=i.counters.getCounterValue(B.value),s=r&&_A(r)?pt.parse(i.context,r.value):3,a.appendChild(Q.createTextNode(Fn(t,s,!1))))):\"counters\"===A.name&&(B=(t=A.values.filter($A))[0],s=t[1],r=t[2],B&&_A(B)&&(B=i.counters.getCounterValues(B.value),n=r&&_A(r)?pt.parse(i.context,r.value):3,s=s&&0===s.type?s.value:\"\",s=B.map(function(A){return Fn(A,n,!1)}).join(s),a.appendChild(Q.createTextNode(s))))}else if(20===A.type)switch(A.value){case\"open-quote\":a.appendChild(Q.createTextNode(Xt(c.quotes,i.quoteDepth++,!0)));break;case\"close-quote\":a.appendChild(Q.createTextNode(Xt(c.quotes,--i.quoteDepth,!1)));break;default:a.appendChild(Q.createTextNode(A.value))}}),a.className=Dn+\" \"+vn;t=t===gn.BEFORE?\" \"+Dn:\" \"+vn;return YB(A)?A.className.baseValue+=t:A.className+=t,a}}},fn.destroy=function(A){return!!A.parentNode&&(A.parentNode.removeChild(A),!0)},fn);function fn(A,e,t){if(this.context=A,this.options=t,this.scrolledElements=[],this.referenceElement=e,this.counters=new Bn,this.quoteDepth=0,!e.ownerDocument)throw new Error(\"Cloned element does not have an owner document\");this.documentElement=this.cloneNode(e.ownerDocument.documentElement,!1)}(he=gn=gn||{})[he.BEFORE=0]=\"BEFORE\",he[he.AFTER=1]=\"AFTER\";function Hn(e){return new Promise(function(A){!e.complete&&e.src?(e.onload=A,e.onerror=A):A()})}var pn=function(A,e){var t=A.createElement(\"iframe\")